/********************************************************************************************
 *  SVG functions
 * 
 *  Charts - the chart graph has x and y are reversed
 *  Chart1 - basic chart 61 buckets
 *  Chart2 - Full chart including zoom
 *  Chart3 - Full chart including zoom and Two Y-Axis
 * *****************************************************************************************/
//user variables
var g_iDataLogRange = 60;
var g_bChartZoomEnabled = true;
let g_bDashboardDisplayMouseToolTip = true;

// all internal variables
var g_bZoomChartSupported = false;
var g_zoomFontSize = "35px";
var g_datalogWsClient = null;
var g_dtDataLogStartTime  = new Date();
var g_dtDataLogReceiveTime = null;
var g_sDataLogDuration = "";
var g_sDataLogStartTime = "";
var g_iDataLogSortInterations = 0;
var g_datalogJson = [];
var g_bDashboardNeedToInitializeSvg = true;
var g_bDatalogAborted = false;
var g_bChartMakeChartMenuButtonVisible = false;

var dashboardDpList = [];
var g_dashboardChartList = [];
var g_dashboardDatalogData = [];
var g_zoomDashboardChartList = [];
var g_idashboardChartType = 0; //0=trend, 1=stepline
var g_datalogStartTimeMs = 0; // this is used to detrmine if PC and SmartServer are in the same time zone, don't show datalog if not in same timezone
var g_datalogEndTimeMs = -1;

var g_iDashboardInitiCount = "0";
var g_bDashboardChartDynamicRange = true;
var g_bDashboardChartUseTimestamp = false;
var g_bDashboardGetDatalog = true;
var g_iDashboardDatalogRange = 2; //0= none, 1= 1 hour
var g_iDashboardChartDuration = 0; //0= none, 1= 1 hour
let g_idashboardChartMaxNumberOfPointsDefault = 1000; // 0=unlimited
let g_idashboardChartMaxNumberOfEntries = 0; // 0=unlimited
let g_iDashboardChartMaxDuration = 0; // microsec, 0= no limits
var g_bDashboardDataLogGetInProgress = false;
var g_dashboardTimerInterval = 1500; // firefox takes more time to load svg then chrome
var g_dashboardTimerId = 0; // used to initilize svg elements

let g_dashboardDataLogRequestInfo = {}; // used to save showdashboard info during getting datalog 
let g_bdashboardChartPause = false;
let g_bDashboardPollEnabled = true;
let g_bDashboardUseNewChart = true;
let giDashboardChartLineWidth = 10;
let g_bDashboardOptionsMenu = false;
let g_bDashboardSupportDisplayMouseToolTip = true;

let g_bDashboardDisplayMouseToolTipShowPresets = true;
let g_bDashboardMinMaxUsePadding = false;
let g_bDashboardMinMaxDecimalPlaces = true; //work inprogress
let g_iDashboardDecimalPlaces = 2;  // max number of decimal places if value greater than 1, -1=no limit




var ivChartXLengthLargeChart = 1600; // chart9
var ivChartYLengthLargeChart = 800;
var ivChartTotalEntriesLargeChart = 800; // 1200;
var ivChartTotalEntries = ivChartTotalEntriesLargeChart;

var ivChartLines = [];
var ivChartLineColors = ["blue","red","green", "brown","orange","#ff0066","#cc00ff","#6600ff","#ff6666", "#cc00cc", "#669900", "#00cc66", "#6600ff"];
var ivChartLineColorsIndex = 0;
var ivChartAllowTwoYaxis = true; 
var ivChartUseTwoYaxis = false;
var ivChartNeedTwoYaxis = false; // depends on data.  SNVT_switch dps uses both axis one 0-100 and 2nd 0-1
var ivChart3ZeroLineAlreadyCreated = false;

function _chartInit() {
	var i;
	var elements = [];
	g_bChartMakeChartMenuButtonVisible
	g_bZoomChartSupported = false;
	g_datalogWsClient = null;
	g_iDataLogRange = 60; 
	g_dtDataLogStartTime  = new Date();
	g_dtDataLogReceiveTime = null;
	g_sDataLogDuration = "";
	g_sDataLogStartTime = "";
	g_iDataLogSortInterations = 0;
	g_datalogJson = [];
	g_bDashboardNeedToInitializeSvg = true;
	ivChartLines = [];
	dashboardDpList = [];
	g_dashboardChartList = [];
	g_dashboardDatalogData = [];
	g_zoomDashboardChartList = [];
	g_bDatalogAborted = false;
	g_bdashboardChartPause = false;
	g_datalogStartTimeMs = 0; // this is used to detrmine if PC and SmartServer are in the same time zone, don't show datalog if not in same timezone
	g_datalogEndTimeMs = -1;
	elements = document.getElementsByClassName("charMenuButton");
	for(i=0; i < elements.length; i++)
	{
		if(i===0)
		g_bChartMakeChartMenuButtonVisible = true;
		elements[i].style.visibility = "hidden";
	}
	if(g_bChartZoomEnabled) {
		// add zoom chart
		_addZoomChart();
	}
}

/* *********************************************************************
	Main Function calls

***********************************************************************/
function _addValueToDashboardChartList(chartIndex, value, presetValue, timestamp) {
    try { //fix only have two entries per datapoint value. change last entry if previous value two values are the same
        var lastIndex = g_dashboardChartList[chartIndex].data.length;
        if(g_dashboardChartList[chartIndex].data.length > 1) {
            lastIndex --;
            if(isEqual(g_dashboardChartList[chartIndex].data[lastIndex].value, value)) {
                //if(g_idashboardChartType === 0)
                //    return;
                if(isEqual(g_dashboardChartList[chartIndex].data[lastIndex - 1].value, value)) {
                    g_dashboardChartList[chartIndex].data[lastIndex].timestamp = timestamp; 
                    return;
                }
            }
        }
        obj1 = {};
        obj1.value = value;
		if(typeof presetValue === "undefined") 
			obj1.presetValue = "";
		else if(presetValue === null)
			obj1.presetValue = "";
        else
            obj1.presetValue = presetValue;
        obj1.timestamp = timestamp;
        g_dashboardChartList[chartIndex].data.push(obj1);
    }
    catch {}
}
function _addZoomChart() {
	try {
		var image = new Image();
		image.src = "images/chart9.svg";
		if(image.complete) {
			_addZoomChart1();
		}
		else {
			image.onload = () => {
				_addZoomChart1();
				};
			image.onerror = () => {
				g_bZoomChartSupported = false;
				return;
			};
		}
	}
	catch {}
}
function _addZoomChart1() {
	try {
		var elem, content = "";
		var image = new Image();
		var chartZoomDiv = document.getElementById("chartZoomDiv"); 
		if(chartZoomDiv !== null) {
			chartZoomDiv.innerHTML = "";
		}
		else {
			elem = document.createElement("div");
			elem.id = "chartZoomDiv";
			document.body.appendChild(elem)
			chartZoomDiv = document.getElementById("chartZoomDiv");
		}

		content += "<div>";
		content += "<div style=\"float:right\"><button onclick=\"_chartZoomDivClose()\">X</div>";
		content += "<div>Zoom Chart</div>";
		content += "</div>";

		
		content += '<div class="group"   style="float:left;display:inline-block;margin-left:10px;margin-top:10px">';
		content += '<div  style="float:left;display:inline-block">';
		content += '<div style="margin-left: 50px">';
		content += '<span id="zoomDpName" style="margin-left: 200px"></span>';
		content += '<span id=\"zoomValue\" style=\"float:right;display:block;margin-right:30px\"></span>';
		
		content += '</div>';
		content += '<div style="clear:both; display:block; margin-top:30px; text-align:center; z-index: 5; ">';
		content += '<object id="zoomChartSvg" type="image/svg+xml" style="height: 510px;" data-izot-textcolor="white" data="images/chart9.svg"></object>';
		//content += '<object id="zoomChartSvg" type="image/svg+xml" style="width: 100%;" data-izot-textcolor="white" data="images/chart9.svg"></object>';
		content += '</div>';
		content += '</div>';
		content += '</div>';
		chartZoomDiv.innerHTML = content;
		chartZoomDiv.className = "menuDivHide";
		g_bZoomChartSupported = true;
	}
	catch {}
}
function _chartMenu(n, dp, displayElementId) {
	try {
		var iPtr, i;
		var x = 0; // = event.clientX;
		var y = 0;// = event.clientY;
		var bPaused = false;
		var index = -1;
		var menuContent = "";
		var offsets;
		var xOffset = 30;
		var yOffset = 20;
		var width = 100;
		var elem;
		var iPtr, name = dp;

		
		for(i=0; i < dashboardDpList.length; i++)
		{
			if(g_dashboardChartList[i].displayId === displayElementId) {
				index = i;
				break;
			}
		}
		if(index === -1) {
			alert("No chart data yet")
			return;
		}
		iPtr = name.indexOf("(");
		if(iPtr !== 0)
			name = name.substr(0,iPtr);
		

		menuContent = "<div class=\"menuChartDivShowContent\"><div class=\"menuDivDpPathName\">"
		menuContent += name;
		menuContent += "</div>";
		
		menuContent += "<span id=\"menuDivType\" style=\"display:none\">dpMenu_" + dp + "</span>";
		menuContent += "<br><br><button id=\"'pause_" + index + "'\" class=\"menuDivButton\" onclick=\"_chartPauseSingle(" + index  + ")\">";
		if(g_dashboardChartList[i].paused)
			menuContent += "Continue";
		else
			menuContent += "Pause"
		menuContent + "</button><br>";
		if(g_bZoomChartSupported)
			menuContent += "<button class=\"menuDivButton\" onclick=\"_chartZoom(" + index + ",'" + dp + "')\">Zoom</button><br>";
		menuContent += "<button class=\"menuDivButton\" onclick=\"_clearDashboardChart(" + index + ")\">Clear Chart</button><br>";
		
		menuContent += "<br><button  onclick=\"_chartMenuDivClose()\" class=\"menuDivButton\">Close</button><br><br></div>";
		var menuButton = n;
		
		if(menuButton !== null) {
			offsets = menuButton.getBoundingClientRect(); 
			if((offsets.x + offsets.width + window.pageXOffset + width) > (window.pageXOffset + window.innerWidth)) 
				x = offsets.x + window.pageXOffset - width - 10; // takes into account viewport (scrolling)
			else
				x = offsets.x + offsets.width + window.pageXOffset + xOffset; // takes into account viewport (scrolling)
			y = offsets.y + window.pageYOffset - yOffset; // takes into account viewport (scrolling)

			var menuDiv = document.getElementById("chartMenuDiv");
			if(menuDiv === null) {
				// add chartMenuDiv
				elem = document.createElement("div");
				elem.id = "chartMenuDiv";
				document.body.appendChild(elem)
				menuDiv = document.getElementById("chartMenuDiv");
			}
			menuDiv.innerHTML = menuContent;
			
			menuDiv.style.left = x.toString() + "px";
			menuDiv.style.top = y.toString() + "px";
			menuDiv.className = "menuChartDiv";  // doesn't currently guaranty that menu is shown in viewport
			
		}
	}
	catch {}
}
function _chartMenuDivClose() {
	try {
		var menuDiv = document.getElementById("chartMenuDiv");
		if(menuDiv !== null)
			menuDiv.className = "menuDivHide";
	}
	catch {}

}
function _chartZoom(index, dp) {
	try {
		var elem;
		var content = "";

		if(!g_bZoomChartSupported)
			return;
		var menuDiv = document.getElementById("chartZoomDiv"); 
		_chartMenuDivClose();
		if(index < g_dashboardChartList.length) {
			if(menuDiv === null) {
				return;
			}
			menuDiv.className = "chartZoomDiv";
			menuDiv = document.getElementById("zoomDpName"); 
			if(menuDiv !== null)
				menuDiv.innerHTML = dp;
			_InitializeZoomChartElement(index);
		}

	}
	catch {}
}
function _chartZoomDivClose() {
	try {
		var menuDiv = document.getElementById("chartZoomDiv");
		if(menuDiv !== null)
			menuDiv.className = "menuDivHide";
	}
	catch {}

}
function _chartNewUpdate(index, pathName, value, presetValue, timestamp) {
	var chartIndex, bDataEntryRemoved = false,	bInitializeChart = false, obj = {};
	var i, elements;
	try {
		if(g_bChartMakeChartMenuButtonVisible) {
			g_bChartMakeChartMenuButtonVisible = false;
			//at least one chart got a value
			elements = document.getElementsByClassName("charMenuButton");
			for(i=0; i < elements.length; i++)
			{
				elements[i].style.visibility = "visible";
			}
		}

		if((index !== -1) && (index < dashboardDpList.length)) {
			if(pathName === dashboardDpList[index].dpPath) {
				if(presetValue === null)
					presetValue = "";
				if(g_bDashboardDataLogGetInProgress) {
					// save live data to predataloglist
					obj.pathName = pathName;
					obj.value = value;
					obj.presetValue = presetValue;
					obj.timestamp = timestamp;
					dashboardDpList[index].livePreDatalogData.push(obj);
				}
				else {
					if(dashboardDpList[index].bCreateChart) {
						_InitializeChartElement(index);
					}

					bDataEntryRemoved = false;
                    chartIndex = dashboardDpList[index].chartIndex;         
					_addValueToDashboardChartList(chartIndex, value, presetValue, timestamp);
					bDataEntryRemoved = _checkDashboardChartListRemoveOldEntries(chartIndex, timestamp);
					if(g_dashboardChartList[chartIndex].data.length > 0) {
						g_dashboardChartList[chartIndex].startTimestamp = g_dashboardChartList[chartIndex].data[0].timestamp
						g_dashboardChartList[chartIndex].endTimestamp = g_dashboardChartList[chartIndex].data[g_dashboardChartList[chartIndex].data.length - 1].timestamp
						g_dashboardChartList[chartIndex].endPtr = g_dashboardChartList[chartIndex].data.length - 1;
						g_dashboardChartList[chartIndex].dataCurrentEntries = g_dashboardChartList[chartIndex].data.length;
					}
                                       
                                   
					if(g_dashboardChartList[chartIndex].data.length === 1) {
						// needed in case the charts are cleared with a clear chart button
						bDataEntryRemoved = true;
						bInitializeChart = true;
					}

					if(bDataEntryRemoved)
						_dashboardDetermineChartMinMaxValuesForChart(0, chartIndex, null, true);
					else 
						_dashboardDetermineChartMinMaxValuesForChart(1, chartIndex, value, true);
					
					if(!g_dashboardChartList[chartIndex].pause) {
						if(bInitializeChart) {
							ivInitializeChart1(true, g_dashboardChartList[chartIndex].displayId, g_dashboardChartList[chartIndex].minValue, g_dashboardChartList[chartIndex].maxValue, null, null, "black", null, g_dashboardChartList[chartIndex].chartlabels);
						}
						// got log so now only live data
						
						_dashboardUpdateCharts(chartIndex);
					}
					
				}
			}
		}
	}
	catch(err) {}
}
function _chartNewUpdateSameValueDifferentTime(index, pathName,value,presetValue, timestamp) {
	var chartIndex,value,presetValue;
	try {

		var i, elements;
		
		if(g_bChartMakeChartMenuButtonVisible) {
			g_bChartMakeChartMenuButtonVisible = false;
			//at least one chart got a value
			elements = document.getElementsByClassName("charMenuButton");
			for(i=0; i < elements.length; i++)
			{
				elements[i].style.visibility = "visible";
			}
		}

		if((index !== -1) && (index < dashboardDpList.length)) {
			if(pathName === dashboardDpList[index].dpPath) {
				
				if(dashboardDpList[index].bCreateChart) {
					_chartNewUpdate(index,pathName,value,presetValue,timestamp);
					return;
				}
				chartIndex = dashboardDpList[index].chartIndex;
				if(g_dashboardChartList[chartIndex].data.length === 0) {
					_chartNewUpdate(index,pathName,value,presetValue,timestamp);
					return;
				}
				value = g_dashboardChartList[chartIndex].data[g_dashboardChartList[chartIndex].data.length - 1].value;
				presetValue = g_dashboardChartList[chartIndex].data[g_dashboardChartList[chartIndex].data.length - 1].presetValue;
				_addValueToDashboardChartList(chartIndex, value, presetValue, timestamp);
				bDataEntryRemoved = _checkDashboardChartListRemoveOldEntries(chartIndex, timestamp);
				
				if(g_dashboardChartList[chartIndex].data.length > 0) {
					g_dashboardChartList[chartIndex].startTimestamp = g_dashboardChartList[chartIndex].data[0].timestamp
					g_dashboardChartList[chartIndex].endTimestamp = g_dashboardChartList[chartIndex].data[g_dashboardChartList[chartIndex].data.length - 1].timestamp
					g_dashboardChartList[chartIndex].endPtr = g_dashboardChartList[chartIndex].data.length - 1;
					g_dashboardChartList[chartIndex].dataCurrentEntries = g_dashboardChartList[chartIndex].data.length;
				}
				if(bDataEntryRemoved) {
					_dashboardDetermineChartMinMaxValuesForChart(0, chartIndex, null, true);
				}
				if(!g_dashboardChartList[chartIndex].pause)
					_dashboardUpdateCharts(chartIndex);
			}
		}
	}
	catch {}
}
function chartPause() {
    var text = document.getElementById("chartPauseButton").innerText;
    if(text === "Pause Chart") {
        g_bdashboardChartPause = true;
        document.getElementById("chartPauseButton").innerText = "Continue";
    }
    else {
        g_bdashboardChartPause = false;
        document.getElementById("chartPauseButton").innerText = "Pause Chart";
    }
	for(i=0; i < g_dashboardChartList.length; i++){
		g_dashboardChartList[index].paused = g_bdashboardChartPause;
	}
}
function _chartPauseSingle(index) {
	var i;
	try {
		var element = document.getElementById("pause_" + index);
		if(index < g_dashboardChartList.length){
			if(g_dashboardChartList[index].paused) {
				g_dashboardChartList[index].paused = false;
				if(element !== null) {
					element.innerText("Pause");
				}
			}
			else {
				g_dashboardChartList[index].paused = true;
				if(element !== null) {
					element.innerText("Continue");
				}
			}
		}
		
		
	}
	catch {}
    
}
function _checkDashboardChartListRemoveOldEntries(index, currenttimeMs) {
    var removeCount = 0;
    var i;
    var bEntryRemoved = false;
    try {
        if(index < g_dashboardChartList.length) {
            
                
			removeCount = g_dashboardChartList[index].data.length - g_dashboardChartList[index].chartMaxCount; //g_idashboardChartMaxNumberOfEntries;
			if(removeCount > 0) {
				bEntryRemoved = true;
				for(i=0; i < removeCount; i++)
				{
					g_dashboardChartList[index].data.shift();
				}
			}
           
            if(g_dashboardChartList[index].chartMaxDuration !== null) {
				
                startTimestamp = currenttimeMs - g_dashboardChartList[index].chartMaxDuration; 
                for(i=0; i < g_dashboardChartList[index].data.length; i++)
                {
					if((i + 2) < g_dashboardChartList[index].data.length) {
						if(g_dashboardChartList[index].data[i + 1].timestamp < startTimestamp) {
							g_dashboardChartList[index].data.shift();
							bEntryRemoved = true;
						}
						else if(g_dashboardChartList[index].data[i].timestamp < startTimestamp) {
							g_dashboardChartList[index].data[i].timestamp = startTimestamp;
							bEntryRemoved = true;
							break;
						}
						else 
							break;
					}
					else if(g_dashboardChartList[index].data[i].timestamp < startTimestamp) {
                        g_dashboardChartList[index].data[i].timestamp = startTimestamp;
						bEntryRemoved = true;
						break;
                    }
                    else
                        break;
                }
            }
        }
    }
    catch {
        bEntryRemoved = true; // not sure what problem is so calculate new min max
    }
    try {
        if(bEntryRemoved) {
            if(g_dashboardChartList[index].data.length > 0) {
                g_dashboardChartList[index].startTimestamp = g_dashboardChartList[index].data[0].timestamp; //time in milli seconds
                g_dashboardChartList[index].endTimestamp = g_dashboardChartList[index].data[g_dashboardChartList[index].length - 1].timestamp; //time in milli seconds
            }
        }
    }
    catch {}
    g_dashboardChartList[index].dataCurrentEntries = g_dashboardChartList[index].data.length;
    g_dashboardChartList[index].endPtr = g_dashboardChartList[index].data.length - 1;
    return bEntryRemoved;
}
function _clearDashboardChart(index) {
    var i;
    // remove datalog data
    try {
		g_dashboardChartList[index].data = [];
		g_dashboardChartList[index].maxValue = null;
		g_dashboardChartList[index].minValue = null;
    }
    catch {}
    ivInitializeChart3Clear2Yaxis(false, "", g_dashboardChartList[index]);
    
}
function _clearDashboardCharts() {
    var i;
    // remove datalog data
    try {
        for(i=0; i < dashboardDpList.length; i ++)
            dashboardDpList[i].updateDpValue = true
        for(i=0; i < g_dashboardChartList.length; i ++)
        {
            g_dashboardChartList[i].data = [];
            g_dashboardChartList[i].maxValue = null;
            g_dashboardChartList[i].minValue = null;
            
        }
    }
    catch {}
    ivInitializeChart3Clear2Yaxis(false, "", g_dashboardChartList);
    
}
function _createDataLogClientWebSocketConnection(mode, request) {
    //datalogClient = new WebSocket(`wss://${sSmartServerIpAddress}:${clientPort}/iap/ws?dp=true`, [], {
	
    var datalogCount = 0;
	var dataLogData = ""; //Datapoint,Local Time,UTC Time,Value,Device Status";
	g_dtDataLogStartTime  = new Date();
	g_dtDataLogReceiveTime = null;
	g_sDataLogDuration = "";
	g_sDataLogStartTime = "";
	g_iDataLogSortInterations = 0;
	g_datalogJson = [];

	g_bDataLogGetInProgress = true;
	try {
		if(g_datalogWsClient !== null)	{
			g_bDatalogAborted = true;
			g_datalogWsClient.close();
		}
	} catch (err) {}

	//g_datalogWsClient = new WebSocket("wss://"+ window.location.hostname + ":8443" + request);
	g_datalogWsClient = new WebSocket("wss://"+ window.location.hostname  + request);
    
    g_datalogWsClient.onopen = function(event) {
    //        console.log(`SmartServer DataLog WebSocket Connection OPEN to ${sSmartServerIpAddress}: ${request}`);
		dataLogData = "";
    };

    g_datalogWsClient.onmessage = function(event) {
        var nowTs = new Date(); // Seconds TS good enough
        var data = event.data;
        try {
			datalogCount ++;
			
			//console.log(JSON.parse(data));
            if(data !== "\"end\"") {
				// UI shows datalogs in descending order
				//    for intial request list in descending order
				//    all polled request list in ascending order inorder to add new entries at top of existing table 
				if(mode === 2) { // ascending order
					if(dataLogData !== "") 
						dataLogData += ",";
					dataLogData += data;
				}
				else { // descending order
                	if(dataLogData !== "") 
						data += ",";
					dataLogData = data + dataLogData;
				}
 
            }
            return;
		}  
		catch(error) {
            console.error(nowTs.toISOString() + ' - SmartServer DataLog Websocket Error: ' + error);
		}
    };
    g_datalogWsClient.onclose = function(event) {
		// descending order except for mode 2 which is ascending
        var nowTs = new Date(); // Seconds TS good enough
        var i = 0, iTemp;
        var d1, d2;
		var temp;
		var count;
		var iNumOutOfOrderDesc = 0, iNumOutOfOrder1 = 0;
		var iNumOutOfOrderAsc = 0;
		var infoElement;
		g_datalogWsClient = null;
		if(g_bDatalogAborted) {
			g_bDatalogAborted = false;
			return;
		}
		if(g_bDashboardDataLogGetInProgress)
			_getChartDatalogDataResponse(mode, request, JSON.parse("[" + dataLogData + "]")); 
		g_bDataLogGetInProgress = false;
	};
	g_datalogWsClient.onerror = function(event) {
		alert("datalog WebSocket error: " + event.type);
		g_bDataLogGetInProgress = false;
		g_datalogWsClient = null;
	};
}
function _createChartObject(index, displayId, pathName, value, min, max, hasDynmaicRange, linecolor, chartlabels, maxCount, maxDuration) {
    try {
        var fvalue, fvalue1;
        var chart = {}, minmaxObj, obj;
        var d;
        var polygoncolor;
        var type;
        var iDetermineMinMax = -1;
        if(dashboardDpList[index].pathName !== pathName)
            return;
        chart.startPtr = 0;
        chart.endPtr = 0;
        chart.pathName = pathName;
        chart.dashboardDpIndex = index;
        chart.displayId = displayId;
        chart.data = [];
        chart.dataCurrentEntries = 1; //iottest
        chart.hasNegativeNumbers = false; 
        chart.bMinMaxEqual = true;
        //chart.iDynamicRangeCount = ivChartTotalEntries + 2;
		chart.iDynamicRangeCount = maxCount + 2;
        chart.chartMaxCount = maxCount;
        //chart.iDynamicRangeCount = 2;
		chart.chartMaxDuration = maxDuration;

        chart.creatChartLine = true;
        chart.lineName = "line1"
        chart.color = "blue";
		chart.pause = false;
        
        /*
        type = dashboardDpList[index].dashboardType;
        if (type === "t")
            chart.color = "darkred";
        else if (type === "l")
            chart.color = "green";
        */           
        chart.show = true;
        chart.chartLabels = "both";

        chart.bPolygon = !g_bDashboardChartDynamicRange;
        chart.startTimestamp = null; //time in milli seconds
        chart.endTimestamp = null; //time in milli seconds
       
		bDetermineMinMax = true;
		if(typeof dashboardDpList[index].datalogData !== "undefined") {
			if(dashboardDpList[index].datalogData.length > 0)
				chart.data = JSON.parse(JSON.stringify(dashboardDpList[index].datalogData));
		}
		if(value !== null) {
			obj = {};
			obj.value = value;
			obj.presetValue = "";
			
			d = new Date();
			obj.timestamp = d.getTime();
			chart.data.push(obj);
		} 
		iDetermineMinMax = 3;
		
		chart.endPtr = chart.data.length - 1;
		chart.dataCurrentEntries = chart.data.length;
		if(chart.data.length > 0) {
			chart.startTimestamp = chart.data[0].timestamp; //time in milli seconds
			chart.endTimestamp = chart.data[chart.data.length - 1].timestamp; //time in milli seconds
		}
        
        
        
        chart.dynamicRange = hasDynmaicRange;
        chart.chartlabels = chartlabels;
        if(linecolor === null) {
            linecolor = "blue";
        }
        polygoncolor = "light" + linecolor;
        chart.lineColor = linecolor;
        chart.polygoncolor = polygoncolor;
        g_dashboardChartList.push(chart);
        dashboardDpList[index].chartIndex = g_dashboardChartList.length - 1;
        if(iDetermineMinMax !== -1) {
            index = g_dashboardChartList.length - 1;
            if((iDetermineMinMax === 0) || (iDetermineMinMax === 3))
                value = null;
            else
                value = parseFloat(value);
            minmaxObj =  _dashboardDetermineChartMinMaxValuesForChart(iDetermineMinMax, index, value, true);
        }
    }
    catch {}
}
function _getChartDatalogData(mode) {
    // mode: 50=refresh (don't re-draw screen)
    var d, t, t1 = 1, iPtr, n, wsUrl = "/iap/ws?";
	var pathNames;
	var deviceName, blockPath;
    if((dashboardDpList.length > 0) && (g_iDataLogRange > 0)) {
        try {
			for(i=0; i < dashboardDpList.length; i++)
			{
				if(i === 0) {
					deviceName = dashboardDpList[i].deviceName;
					blockPath = dashboardDpList[i].blockPath;
				}
				else {
					if(blockPath !== "") {
						if(blockPath !== dashboardDpList[i].blockPath)
							blockPath = "";
					}
					if(deviceName !== dashboardDpList[i].deviceName)
						deviceName = "";

				}


			}
           
			if(deviceName !== "") {
				wsUrl += "dev=%2A%2Bname==" + deviceName;
			}
			if(blockPath !== "") {
				pathNames = blockPath.split("/");
				if(pathNames.length === 3) {
					wsUrl += "&blockName=%2A%2BxifName=="  + pathNames[0];
					wsUrl += "&blockIndex="  + pathNames[1];
					wsUrl += "&dpName=%2A%2BxifName=="  + pathNames[2];
				}
			}
            d = new Date();
			g_datalogStartTimeMs = d.getTime() + 30000; // this is used to detrmine if PC and SmartServer are in the same time zone, don't show datalog if not in same timezone
	
        	d.setTime(d.getTime() - (g_iDataLogRange * 60 * 1000)); // 10 min
            g_datalogEndTimeMs = d.getTime() + 2000;
            n = d.toISOString();
            n = n.substr(0, n.length - 1);
            if(n !== "") {
                n = n.replace(/:/g,"%3A")
				if(deviceName !== "")
					wsUrl += "&";
                wsUrl += "value=%2A%2Butc%3E" + n;
            }
            g_bChartDataLogGetInProgress = true;
            if(mode !== 50)
                mode = 30;
            _createDataLogClientWebSocketConnection(mode, wsUrl);
        }
        catch {
        }
    }
}
function _getChartDatalogDataResponse(mode, request, datalogData) {
    try {
        var i,j, data,temp,k, bDPsWithAtleastOneOutofOrdervalue = 0, timestamp1, timestamp2,bContinue;
        var tempObj, bContinue, chartIndex;
        
        if(datalogData !== null) { //"") {
            g_dashboardDatalogData = datalogData; //JSON.parse("[" + datalogData + "]");
            //populate datapoint information

            // clear current cache
            for(j=0; j < dashboardDpList.length; j++)
            {
                dashboardDpList[j].datalogData = [];
    
            }
            for(i=0; i < g_dashboardDatalogData.length; i++)
            {
                for(j=0; j < dashboardDpList.length; j++)
                {
                    if(g_dashboardDatalogData[i].dpQualifier === dashboardDpList[j].dpQualifier) {
                        data = {};
                        data.value = g_dashboardDatalogData[i].value;
                        data.utc = g_dashboardDatalogData[i].utc;
                        data.local = g_dashboardDatalogData[i].local;
                        if(typeof g_dashboardDatalogData[i].presetValue !== "undefined") {
                            if(g_dashboardDatalogData[i].presetValue !== "")
                                data.presetValue = g_dashboardDatalogData[i].presetValue;
                        }
                        temp = g_dashboardDatalogData[i].utc;
                        data.timestamp = Date.parse(temp.substr(0,(temp.length - 5)));
                        //data.timestamp = d1.getTime();
                        dashboardDpList[j].datalogData.unshift(data);
                    }
                }
            }
            // reorder if necessary
            for(i=0; i < dashboardDpList.length; i++)
            {
                bContinue = true;
                if(dashboardDpList[i].datalogData.length > 0) {
                    while(bContinue)
                    {
                        bContinue = false;
                        for(j=0; j < (dashboardDpList[i].datalogData.length - 1); j++)
                        {
                            timestamp1 = dashboardDpList[i].datalogData[j].timestamp;
                            timestamp2 = dashboardDpList[i].datalogData[j + 1].timestamp;
                            if(timestamp1 > timestamp2) {
                                bContinue = true;
                                tempObj = {};
                                tempObj = JSON.parse(JSON.stringify(dashboardDpList[i].datalogData[j]));
                                dashboardDpList[i].datalogData[j] = JSON.parse(JSON.stringify(dashboardDpList[i].datalogData[j + 1]));
                                dashboardDpList[i].datalogData[j + 1] = tempObj;
                                bDPsWithAtleastOneOutofOrdervalue ++;
                            }
                        }

                    }
                    // change start and end times
                    k = dashboardDpList[i].datalogData.length;
                    dashboardDpList[i].startTimestamp = dashboardDpList[i].datalogData[0].timestamp;
                    dashboardDpList[i].endTimestamp = dashboardDpList[i].datalogData[k - 1].timestamp;
					if((dashboardDpList[i].startTimestamp < g_datalogStartTimeMs) || (dashboardDpList[i].startTimestamp > g_datalogEndTimeMs)
						|| (dashboardDpList[i].endTimestamp < g_datalogStartTimeMs) || (dashboardDpList[i].endTimestamp > g_datalogEndTimeMs)) {
							// datalog timesamp indicates PC and SmartServer not in same timezone
							for(j=0; j < dashboardDpList.length; j++)
            				{
                				dashboardDpList[j].datalogData = [];
    
            				}
							g_bDashboardDataLogGetInProgress = false;
							return;
						}
                }
            }
        }
    }
    catch {g_dashboardDatalogData = [];} 
	// verify datalog data is within 
	

    //if(bDPsWithAtleastOneOutofOrdervalue > 0)
    //    alert("Datalog DPs with out of order logs = " + bDPsWithAtleastOneOutofOrdervalue);
    if(mode === 50) {
        // refresh
        for(i=0; i < dashboardDpList.length; i++)
        {
            if(dashboardDpList[i].chartIndex !== null) {
                dashboardDpList[i].updateDpValue = true;
                chartIndex = dashboardDpList[i].chartIndex;
                if(chartIndex < g_dashboardChartList.length) {
                    g_dashboardChartList[chartIndex].data = dashboardDpList[i].datalogData;
                    if(g_dashboardChartList[chartIndex].data.length > 0) {
                        g_dashboardChartList[chartIndex].endPtr = g_dashboardChartList[chartIndex].data.length - 1;
                        g_dashboardChartList[chartIndex].startTimestamp = g_dashboardChartList[chartIndex].data[0].timestamp;
                        g_dashboardChartList[chartIndex].endTimestamp = g_dashboardChartList[chartIndex].data[g_dashboardChartList[chartIndex].data.length - 1].timestamp;
                        g_dashboardChartList[chartIndex].dataCurrentEntries = g_dashboardChartList[chartIndex].data.length;
                        _dashboardDetermineChartMinMaxValuesForChart(0, chartIndex, null, true);
                        _dashboardUpdateCharts(chartIndex);
                    }
                    else {
                        g_dashboardChartList[chartIndex].endPtr = 0;
                        g_dashboardChartList[chartIndex].startTimestamp = 0;
                        g_dashboardChartList[chartIndex].endTimestamp = 0;
                        g_dashboardChartList[chartIndex].dataCurrentEntries = 0;
                    }
                }
            }
        }
        //initializeSvgDashboard(); // already have chart so just use new values
        g_bDashboardDataLogGetInProgress = false;
        return;
    }
	_InitializeChartElements(1);
	g_bDashboardDataLogGetInProgress = false;
    //showDashboardUi((g_dashboardDataLogRequestInfo.mode + 20), g_dashboardDataLogRequestInfo.title, null, g_dashboardDataLogRequestInfo.templateType, g_dashboardDataLogRequestInfo.bAddDeviceName);
    
}

function _dashboardDetermineChartMinMaxValuesForChart(mode, index, value, bSaveChanges) {
    // mode: 0= check all, 1= compare last, 2= initial value so use value, 3=same as 0 but init chart
    var results = {};
    var bNoChanged = true;
    var bUpdateChart = true
    var min, max, value, i, fvalue1;
    var bChange = false;
    var index, maxDecimalPlaces = 3;
    results.min = value;
    results.max = value;
	try {
        if(mode === 3) {
            bUpdateChart = false;
            mode = 0;
        }
		
		if((mode === 2) || ((mode === 1) && (index < g_dashboardChartList.length)) || (mode === 0 && (g_dashboardChartList[index].data !== null))) {
            if(mode === 0) {
                for(i=0; i < g_dashboardChartList[index].data.length; i ++)
                {
                    if(i === 0) {
                        
                        min = g_dashboardChartList[index].data[i].value;
                        max = min;
                    }
                    else {
                        value = g_dashboardChartList[index].data[i].value;
                        if(value < min)
                            min = value;
                        if (value > max)
                            max = value;
                    }
                }
                if(min === max) {
                    g_dashboardChartList[index].bMinMaxEqual = true;
                    max = Math.round((max * 10) + 1) / 10;
                    min = Math.ceil((min * 10) - 1) / 10;
                }
                else 
                    g_dashboardChartList[index].bMinMaxEqual = false;
                bChange = true;
            }
            else if (mode === 1) {
                bNoChange = true;
                max =  g_dashboardChartList[index].maxValue;
                min =  g_dashboardChartList[index].minValue;
                if(g_dashboardChartList[index].bMinMaxEqual) {
                    lastIndex =  g_dashboardChartList[index].data.length - 1;
                    if(lastIndex > 0) {
                        if(g_dashboardChartList[index].data[lastIndex - 1].value !== g_dashboardChartList[index].data[lastIndex].value) {
                            max = g_dashboardChartList[index].data[lastIndex - 1].value;
                            min = max;
                            g_dashboardChartList[index].bMinMaxEqual = false;
                            bNoChanged = false;
                        }
                    }
                }
                if(value >= max){
                    max = value;
                    bNoChanged = false;
                }
                if(value <= min){
                    min = value;
                    bNoChanged = false;
                }
                if(bNoChanged)
                    return results;
            }
            else {
                g_dashboardChartList[index].bMinMaxEqual = true;
                min = max = value;
                max = Math.round((max * 10) + 1) / 10;
                min = Math.ceil((min * 10) - 1) / 10;
            }
            if(g_bDashboardMinMaxUsePadding) {
                if(Math.abs(max) > 100)
                    fvalue1 = (Math.round(max / 10) + 1) * 10;
                else if(Math.abs(max) > 1)
                    fvalue1 = Math.ceil(max + 1);
                else 
                    fvalue1 = Math.ceil((max * 10) + 1) / 10;
            }
            else
                fvalue1 = max;
            if(g_bDashboardMinMaxDecimalPlaces) {
                maxDecimalPlaces = -1;
                if(Math.abs(min) > 2)
                    maxDecimalPlaces = g_iDashboardDecimalPlaces;
                fvalue1 = _numToFixedLength(fvalue1, 8, maxDecimalPlaces, true)
            }
            if(mode < 2) {
                if(g_dashboardChartList[index].maxValue !== fvalue1) {
                    if(bSaveChanges)
                        g_dashboardChartList[index].maxValue = fvalue1;
                    bChange = true;
                    
                }
            }
            results.max = fvalue1;
            if(g_bDashboardMinMaxUsePadding) {
                if(Math.abs(min) > 100)
                    fvalue1 = (Math.round(min / 10) - 1) * 10;
                else if(Math.abs(min) > 1)
                    fvalue1 = Math.ceil(min - 1);
                else 
                    fvalue1 = Math.ceil((min * 10) - 1) / 10;
            }
            else
                fvalue1 = min;
            if(g_bDashboardMinMaxDecimalPlaces) {
                
                fvalue1 = _numToFixedLength(fvalue1, 8, maxDecimalPlaces, false)
            }
            if(mode < 2) {
                if(g_dashboardChartList[index].minValue !== fvalue1) {
                    if(bSaveChanges)
                        g_dashboardChartList[index].minValue = fvalue1;
                    bChange = true;
                }
            }
            results.min = fvalue1;
            if(bChange) {
                if(g_dashboardChartList[index].dynamicRange) {
                    g_dashboardChartList[index].iDynamicRangeCount = ivChartTotalEntries + 2;
                }
            }
            if(mode  < 2) {
                if(bChange && bUpdateChart && !g_dashboardChartList[index].paused && bSaveChanges) {
                    try {
                        ivInitializeChart1(true, g_dashboardChartList[index].displayId, g_dashboardChartList[index].minValue, g_dashboardChartList[index].maxValue, null, null, null, null, g_dashboardChartList[index].chartlabels);
                        
                    } catch (err) {}
                }
            }
			
		}
	}
    catch {}
    return results;
}
function dashboardDecimialPlaces() {
    if(g_iMainDisplayMode !== DISPLAYMODE_DASHBOARD)
        return;
    try {
        g_iDashboardDecimalPlaces = document.getElementById("dashboardDecimalPlaces").value;
        g_iDashboardDecimalPlaces = Number(g_iDashboardDecimalPlaces);
    }
    catch(err) {}
}
function dashboardMouseEventsAddToChart(displayId, parentDivId, chartIndex) {
    // SVG must be in a parent DIV by itself
    var meterObj;
    var meterSvgDoc;
    if(navigator.userAgent.match(/Chrome/))	
    {		
      meterObj = document.getElementById(displayId);
      meterSvgDoc = meterObj.contentDocument;
    }
    else
    meterSvgDoc = document.getElementById(displayId).getSVGDocument();
    
    meterSvgDoc.getElementById("rect1").chartIndex = chartIndex;
    meterSvgDoc.getElementById("rect1").parentDivId = parentDivId;
      
    meterSvgDoc.getElementById("rect1").addEventListener("mousemove",_dashboardMousemove);
    meterSvgDoc.getElementById("rect1").addEventListener("mouseenter",_dashboardMouseenter);
    meterSvgDoc.getElementById("rect1").addEventListener("mouseout",_dashboardMouseout);
}
function _dashboardMouseenter(e) {
    if(g_bDashboardDisplayMouseToolTip) {
        _dashboardMousemove(e);
    }
    e.preventDefault();
}
function _dashboardMousemove(e) {
	// mode:0=normal chart, 1=zoom
	var mode = 0;
    try {
        if(g_bDashboardDisplayMouseToolTip) {
            var parentDivId = e.target.parentDivId;
            var chartIndex = e.target.chartIndex; 
			if(chartIndex === "z0")
				mode = 1; // ffixmouse
            _dashboardMousePositionChartDisplayValue(mode, chartIndex, parentDivId, e.clientX, e.clientY);
        }
        e.preventDefault();
    }
catch (err) {}
}
function _dashboardMousePositionChartDisplayValue(mode, chartIndex, parentDivId, eClientX, eClientY) {
	// ffix to add enums zzzzzzzzzz
	// mode:0=normal chart, 1=zoom
		var sResult = "";
		var svgObj, svgDoc, svgChartRectangle;
		var str = "", value, presetValue = "";
		var d, time, dates, timestamp = 0, i, delta1, delta2, dataIndex = -1;
		var chartList = [];
		var startTimestampMicroSec;
		var endTimestampMicroSec; 
		var xRange; 
		var range; 
		var min, max;
		var oneDayMs = 24 * 60 * 60 * 1000;
		var iTimeOffset = 1; // 1: time only, 2=time + date
		var x,y,w = 500, wZoom = 250;
		var yoffset, yoffset1 = 400, yoffset2 = 300;   
		var xoffset, xoffset1 = 550, xoffset2 = 50;
		var yoffset, yZoomOffset1 = 150, yZoomOffset2 = 150;   
		var xoffset, xZoomOffset1 = 480, xZoomOffset2 = -110;
		var bZoomChart = false;
		try {
			if(mode === 0) {
				if(g_dashboardChartList == null) 
					return "";
				if(g_dashboardChartList.length == 0)
					return "";
				if(chartIndex >= g_dashboardChartList.length)
					return "";
				if(typeof g_dashboardChartList[chartIndex].data === "undefined")
					return "";
				if(g_dashboardChartList[chartIndex].data === null)
					return ""
				if(g_dashboardChartList[chartIndex].data.length === 0)
					return "";
				
				chartList = g_dashboardChartList[chartIndex];
			}
			else if(mode === 1) {  
				if(g_zoomDashboardChartList == null) 
					return "";
				if(g_zoomDashboardChartList == 0)
					return "";
				
				if(typeof g_zoomDashboardChartList[0].data === "undefined")
					return "";
				if(g_zoomDashboardChartList[0].data === null)
					return ""
				if(g_zoomDashboardChartList[0].data.length === 0)
					return "";
				
				chartList = g_zoomDashboardChartList[0];
				bZoomChart = true;
			}
			else 
				return;
			min = chartList.minValue;
			max = chartList.maxValue;
			startTimestampMicroSec = chartList.startTimestamp;
			endTimestampMicroSec = chartList.endTimestamp;
			xRange = endTimestampMicroSec - startTimestampMicroSec; // MicroSec
			if(navigator.userAgent.match(/Chrome/))	
			{		
				svgObj = document.getElementById(chartList.displayId);
				svgDoc = svgObj.contentDocument;
			}
			else
				svgDoc = document.getElementById(chartList.displayId).getSVGDocument();
			svgChartRectangle = svgDoc.getElementById("rect1");
			svgP = _ivSvgPoint(svgDoc, svgChartRectangle, eClientX, eClientY);
			if(svgP != null) {
				if((svgP.x >= 0) && (svgP.y >= 0)) {
					
					if((min != null) && (max != null)) {
					range = max - min;
				
					timestamp = (svgP.y / ivChartXLengthLargeChart) * xRange;
					timestamp += startTimestampMicroSec;
					if(timestamp <= endTimestampMicroSec) {
						// determine closest saved value
						if(chartList.data.length === 1) {
							value = chartList.data[0].value;
							timestamp = chartList.data[0].timestamp;
							dataIndex = 0;
							if(typeof chartList.data[dataIndex].presetValue !== "undefined")
								presetValue = chartList.data[dataIndex].presetValue;
						}
						else {
	
							for(i=0; i < chartList.data.length; i++)
							{
								if(timestamp < chartList.data[i].timestamp) {
									if (i === 0) {
										value = chartList.data[0].value;
										timestamp = chartList.data[0].timestamp;
										dataIndex = i;
										if(typeof chartList.data[dataIndex].presetValue !== "undefined")
											presetValue = chartList.data[dataIndex].presetValue;
									}
									else {
									// check if previous stored value closer
										delta1 = timestamp - chartList.data[i - 1].timestamp;
										delta2 = chartList.data[i].timestamp - timestamp;
										dataIndex = i;
										if(delta1 < delta2)
											dataIndex --;
										}
										value = chartList.data[dataIndex].value;
										timestamp = chartList.data[dataIndex].timestamp;
										if(typeof chartList.data[dataIndex].presetValue !== "undefined")
											presetValue = chartList.data[dataIndex].presetValue;
										break;
									}
								}
							}
						}
						if(dataIndex !== -1) {
							if(g_bDashboardDisplayMouseToolTipShowPresets && (presetValue !== ""))
								value = presetValue;
							else {
								if(typeof value === "number") {
									if(value.toString().indexOf(".") !== -1) {
										if(min > 10)
											str = value.toFixed(2);
										else if(max > 50)
											str = value.toFixed(2);
										else if(max >= 1)
											str = value.toFixed(2);
										else if(min > 1)
											str = value.toFixed(3);
										else
											str = value;
										value = str;
									}
								}
							}
							
							d = new Date();
							d.setTime(timestamp);
							time = d.toLocaleTimeString();
							//dates = d.toLocaleDateString().split("/");
							str = time;
							if(bZoomChart) {
								if(xRange > oneDayMs) {
									iTimeOffset = 2;
									str += " " + d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0); //dates[2] + "-" +  ivPadStart(dates[0], "0", 2) + "-" +  ivPadStart(dates[1], "0", 2);
								}
								sResult = value + "<br>" + str;
		
								x =  svgP.y + xZoomOffset1;
								if((x + (wZoom * iTimeOffset / 2)) > (ivChartXLengthLargeChart + 100))
									x =   svgP.y - xZoomOffset2;
								y = ivChartYLengthLargeChart + 100 - svgP.x - yZoomOffset1;
								if(y < 0)
									y = yZoomOffset2;
							}
							else {
								if(xRange > oneDayMs) {
									iTimeOffset = 2;
									str += " " + d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0); //dates[2] + "-" +  ivPadStart(dates[0], "0", 2) + "-" +  ivPadStart(dates[1], "0", 2);
								}
								sResult = value + "<br>" + str;
		
								x =  svgP.y + xoffset1;
								if((x + (w * iTimeOffset)) > (ivChartXLengthLargeChart + 100))
									x =   svgP.y - xoffset2;
								y = ivChartYLengthLargeChart + 100 - svgP.x - yoffset1;
								if(y < 0)
									y = yoffset2;
							}
						
							tooltip = svgDoc.getElementById("tooltip");
							if(tooltip !== null) {
							// tooltip.setAttributeNS(null, "x", svgP.x + 200);//mouseX + 6 / CTM.a);
							//  tooltip.setAttributeNS(null, "y", svgP.y + 200);//mouseY + 20 / CTM.d);
								tooltip.setAttributeNS(null, "visibility", "visible");
								tooltiptext = svgDoc.getElementById("tooltiptextrect");
								tooltiptext.setAttributeNS(null, "x", x - 20);
								tooltiptext.setAttributeNS(null, "y", y);
								tooltiptext = svgDoc.getElementById("tooltiptext1");
								tooltiptext.setAttributeNS(null, "x", x);
								if(bZoomChart)
									tooltiptext.setAttributeNS(null, "y", y + 45);
								else 
									tooltiptext.setAttributeNS(null, "y", y + 100);
								tooltiptext.textContent = value;
								tooltiptext = svgDoc.getElementById("tooltiptext2");
								tooltiptext.setAttributeNS(null, "x", x);
								if(bZoomChart)
									tooltiptext.setAttributeNS(null, "y", y + 55);
								else
									tooltiptext.setAttributeNS(null, "y", y + 150);
								tooltiptext.textContent = str;
								if(iTimeOffset === 2) {
									//ffixx  add g_dashboardChartList[chartIndex].tooltipWidth and clear on clear button and reenter dashboard
									//if( g_dashboardChartList[chartIndex].tooltipWidth !== 2)
									if(bZoomChart)
										tooltiptext.setAttributeNS(null, "width", (wZoom * iTimeOffset));
									else 
										tooltiptext.setAttributeNS(null, "width", (w * iTimeOffset));
								}
								else {
									//if( g_dashboardChartList[chartIndex].tooltipWidth !== 1)
									if(bZoomChart)
										tooltiptext.setAttributeNS(null, "width", (wZoom * iTimeOffset));
									else 
										tooltiptext.setAttributeNS(null, "width", (w * iTimeOffset));
								}
							}
						}
					}
				}
			}
		}
		catch (err) {
			sResult += "<br>" + err.toString();
		}
	return sResult;
	}
function _dashboardMouseout(e) {
	var displayId = "";
    if(g_bDashboardDisplayMouseToolTip) {
        var svgObj, svgDoc;
        var tooltip;
        var chartIndex = e.target.chartIndex;
		if(chartIndex === "z0") {
			if(g_zoomDashboardChartList == null) 
				return "";
			if(g_zoomDashboardChartList.length == 0)
				return "";
			displayId = g_zoomDashboardChartList[0].displayId;
		}
		else {
			if(g_dashboardChartList == null) 
				return "";
			if(g_dashboardChartList.length == 0)
				return "";
			if(chartIndex >= g_dashboardChartList.length)
				return;
			displayId = g_dashboardChartList[chartIndex].displayId;
		}
        if(navigator.userAgent.match(/Chrome/))	
        {		
            svgObj = document.getElementById(displayId);
            svgDoc = svgObj.contentDocument;
        }
        else
            svgDoc = document.getElementById(displayId).getSVGDocument();
        tooltip = svgDoc.getElementById("tooltip");
        if(tooltip !== null) 
            tooltip.setAttributeNS(null, "visibility", "hidden");
    }
    e.preventDefault();
}
function _dashboardUpdateCharts(chartIndex) {
	_dashboardUpdateCharts1(0, chartIndex)
}
function _dashboardUpdateCharts1(mode, chartIndex) {
    // mode:0=normal chart, 1= zoom
    
	var chartObj = g_dashboardChartList[chartIndex];
	var chartObjList = [];
	var temp = 1;
	var sExtraStr = "";  //used to specify duration
	var lineWidth = 5;
	if(mode === 0)
		chartObj = g_dashboardChartList[chartIndex];
	else {
		chartObj = g_zoomDashboardChartList[0];
		lineWidth = 3;
	}
	chartObjList.push(chartObj);
	
	ivUpdateChartsDatalogChart3TwoYaxis(chartObj.displayId, sExtraStr, g_idashboardChartType, 0, chartObjList,  null,chartObj.minValue, chartObj.maxValue, null, null, 
		chartObj.startTimestamp, chartObj.endTimestamp,lineWidth, true, "both");
    
}
function _numToFixedLength(num, maxLength, maxDecimalPlaces, bMaxValue){
	// used for charts
	// bMaxValue: round up max value for positive, round down for negative number
	var numOrig = num;
    var numStr = num.toString();
    var len,decimalPlaces, add
    
    try {
		if(numStr.toLowerCase().indexOf("e") > 0) {
			// exponent
		}
		else {
			len = numStr.length;
			if(len > maxLength) {
				iPtr = numStr.indexOf(".");
				if(iPtr !== -1) {
					if(iPtr < maxLength) {
						decimalPlaces = maxLength - iPtr - 1;
						if(maxDecimalPlaces !== -1) {
							if(decimalPlaces > maxDecimalPlaces) {
								decimalPlaces = maxDecimalPlaces
							}
						}
						add = 5 * Math.pow(10, - (decimalPlaces + 1));
						if(bMaxValue) {
							num += add;
						}
						else
							num -= add;
						
						num = Number(num.toFixed(decimalPlaces));
						
					}
					else {
						num = Number(num.toFixed(0));
					}
				}
			}
			else {
				if(maxDecimalPlaces !== -1) {
					decimalPlaces = maxDecimalPlaces;
					add = 5 * Math.pow(10, - (maxDecimalPlaces + 1));
					if(num >= 0) {
						iPtr = numStr.indexOf(".");
						if(iPtr !== -1) {
							if(num > 1) {
								
								if(bMaxValue) {
									num += add;
								}
								else
									num -= add;
								num = Number(num.toFixed(decimalPlaces));
							}
						}
					}
					else {
						iPtr = numStr.indexOf(".");
						if(iPtr !== -1) {
							if(bMaxValue) {
								//num += add;
								num += add;
							}
							else {
								num -= add;
							}
							num = Number(num.toFixed(decimalPlaces));
						}
					}
				}
			}
		}
    }
    catch {num = numOrig}
    return num;
}
function _InitializeChartElements(mode) {
	var i;
	try {
		for(i=0; i < dashboardDpList.length; i ++)
		{
			// copy the live data to the log
			
			if(mode === 0) {
				if(dashboardDpList[i].livePreDatalogData.length > 0) {
					dashboardDpList[i].datalogData = dashboardDpList[i].datalogData.concat(dashboardDpList[i].livePreDatalogData);
				}
			}
			if(dashboardDpList[i].datalogData.length > 0) {
				if(dashboardDpList[i].bCreateChart) {
					_InitializeChartElement(i);
				}
			}

		}
	}
	catch {}
	
}
function _InitializeChartElement(i) {
	//i= dashboardDpList index 
	var lastIndex, element;
	try {
		if(i < dashboardDpList.length) {
			if(dashboardDpList[i].bCreateChart) {
				//createChartObject
				if(dashboardDpList[i].datalogData.length === 0) {
					if(dashboardDpList[i].livePreDatalogData.length > 0) {
						dashboardDpList[i].datalogData = dashboardDpList[i].livePreDatalogData;
					}
				}
				lastIndex = dashboardDpList[i].datalogData.length -1 ;
				_createChartObject(i, dashboardDpList[i].displayId, dashboardDpList[i].pathName, null, dashboardDpList[i].min, dashboardDpList[i].max, 
					dashboardDpList[i].hasDynmaicRange, dashboardDpList[i].linecolor, dashboardDpList[i].chartlabels, dashboardDpList[i].chartMaxCount, dashboardDpList[i].chartMaxDuration);
				dashboardDpList[i].bCreateChart = false;

				if(typeof dashboardDpList[i].chartIndex !== "undefined") {
					chartIndex = dashboardDpList[i].chartIndex;
					ivInitializeChart1(true, g_dashboardChartList[chartIndex].displayId, g_dashboardChartList[chartIndex].minValue, g_dashboardChartList[chartIndex].maxValue, null, null, "black", null, g_dashboardChartList[chartIndex].chartlabels);
						// add id to chart object parent
					element = document.getElementById(g_dashboardChartList[chartIndex].displayId);
					if(element !== null) {
						element.parentNode.id = "chartParentDiv_" + g_dashboardChartList[chartIndex].displayId;
						dashboardMouseEventsAddToChart(g_dashboardChartList[chartIndex].displayId, "chartParentDiv_" + g_dashboardChartList[chartIndex].displayId, chartIndex);
					}
					_dashboardUpdateCharts(chartIndex);
				}
			}
		}
	}
	catch {}
}
function _InitializeZoomChartElement(i) {
	//i= dashboardDpList index 
	var lastIndex, element;
	try {
		if(i < g_dashboardChartList.length) {
			g_zoomDashboardChartList = [];
			g_zoomDashboardChartList.push(JSON.parse(JSON.stringify(g_dashboardChartList[i])));
			g_zoomDashboardChartList[0].displayId = "zoomChartSvg"
			g_zoomDashboardChartList[0].creatChartLine = true;
			
			ivInitializeChart1(true, g_zoomDashboardChartList[0].displayId, g_zoomDashboardChartList[0].minValue, g_zoomDashboardChartList[0].maxValue, null, null, "black", g_zoomFontSize, g_zoomDashboardChartList[0].chartlabels);
			_InitializeZoomChartToolTipFontSize(g_zoomDashboardChartList[0].displayId);
				// add id to chart object parent
			element = document.getElementById(g_zoomDashboardChartList[0].displayId);
			if(element !== null) {
				element.parentNode.id = "chartParentDiv_" + g_dashboardChartList[chartIndex].displayId;
				dashboardMouseEventsAddToChart(g_zoomDashboardChartList[0].displayId, "chartParentDiv_" + g_zoomDashboardChartList[0].displayId, "z0");
			}
			element = document.getElementById("zoomValue");
			if(element !== null) {
				lastIndex = g_dashboardChartList[i].data.length - 1;
				element.innerHTML = g_dashboardChartList[i].data[lastIndex].value;
			}
			_dashboardUpdateCharts1(1, null);
			
		}
	}
	catch {}
}
function _InitializeZoomChartToolTipFontSize(nameId) {
	try {
		var svgObj = null, svgDoc = null;
		var fontsize = "35px";
		//var linesize = 
		if(fontsize === null)
			return;
		if(navigator.userAgent.match(/Chrome/))	
		{		
			svgObj = document.getElementById(nameId);
			svgDoc = svgObj.contentDocument;
		}
		else
			svgDoc = document.getElementById(nameId).getSVGDocument();
		if(typeof svgDoc === "undefined")
			return;

			svgDoc.getElementById("tspanY3").setAttribute('y', 105); //y=120
		svgDoc.getElementById("tspanY2").setAttribute('y', 500); //y=530

		svgDoc.getElementById("tspanX1").setAttribute('x', 450);
		svgDoc.getElementById("tspanX1").setAttribute('y', 980);
		svgDoc.getElementById("tspanX1b").setAttribute('x', 450);
		svgDoc.getElementById("tspanX1b").setAttribute('y', 1030);

		
		svgDoc.getElementById("tspanX2").setAttribute('y', 980);
		svgDoc.getElementById("tspanX2b").setAttribute('y', 1030);


		svgDoc.getElementById("tspanX3").setAttribute('x', 2000);
		svgDoc.getElementById("tspanX3").setAttribute('y', 980);
		svgDoc.getElementById("tspanX3b").setAttribute('x', 2000);
		svgDoc.getElementById("tspanX3b").setAttribute('y', 1030);

		
		svgDoc.getElementById("tooltiptext").style.fontSize = fontsize;  // change text font size
		svgDoc.getElementById("tooltiptext").setAttribute('width', 300); 
		svgDoc.getElementById("tooltiptextrect").setAttribute('width', 250);
		svgDoc.getElementById("tooltiptextrect").setAttribute('height', 125);
		svgDoc.getElementById("tooltiptextrect").setAttribute('rx', 25);
		svgDoc.getElementById("tooltiptextrect").setAttribute('ry', 25);
		svgDoc.getElementById("tooltiptext1").setAttribute('y', 100);
		svgDoc.getElementById("tooltiptext2").setAttribute('y', 200);
		svgDoc.getElementById("tooltiptext2").setAttribute('dy', 50);
		
		
	}
	catch {}
}
function showTooltip(evt, text) { //remove
    let tooltip = document.getElementById("tooltip");
    tooltip.innerHTML = text;
    tooltip.style.display = "block";
    tooltip.style.left = evt.pageX + 10 + 'px';
    tooltip.style.top = evt.pageY + 10 + 'px';
  }



/***********************************************************************************
	Chart SVG Functions
*/
function ivCreateNewPolyline(displayId, lineName, color, linewidth) {
	var result = false;
	var svgObj, svgDoc, svg2;
	var newLine = document.createElementNS('http://www.w3.org/2000/svg','polyline');
	try {
		if(navigator.userAgent.match(/Chrome/))	
		{		
			svgObj = document.getElementById(displayId);
			svgDoc = svgObj.contentDocument;
		}
		else
			svgDoc = document.getElementById(displayId).getSVGDocument();
			
		newLine.setAttribute('id', lineName);
		if(color === null)
			color = "black"; //"#dcdcdc";
		if(linewidth === null)
			linewidth = 5;
		var newStyleStr = "fill:none;stroke:" + color + ";stroke-width:" + linewidth;
		newLine.setAttribute("style", newStyleStr);
		svg2 = svgDoc.getElementById("svg2");
		//svg2.appendChild(newLine);
		var chart3 = svg2.getElementById("chart1");
		chart3.appendChild(newLine);
		var polyline2Str = "0,0"; // 500,750";
		var polyline = svgDoc.getElementById(lineName);
		polyline.setAttribute("points", polyline2Str);
		result = true;
	}
	catch {}
	return result;
}
function ivConvertValueToDisplayDecimalPlaces(value) {
	if(value > 1) {
		value = value.toFixed(1);
		iPtr = value.indexOf(".0");
		if(iPtr !== -1) {
			value = value.substr(0, iPtr);
		}
	}
	return value;
}
function ivInitializeChart(nameId, ymin, ymax, linecolor, polygoncolor, textcolor, fontsize, chartLabels) {
	ivInitializeChart1(false, nameId, ymin, ymax, linecolor, polygoncolor, textcolor, fontsize, chartLabels);
}
function ivInitializeChart1(bClearDurration, nameId, ymin, ymax, linecolor, polygoncolor, textcolor, fontsize, chartLabels) {
	var middle;
	var svgObj = null, svgDoc = null, middle, i;
	if(navigator.userAgent.match(/Chrome/))	
	{		
		svgObj = document.getElementById(nameId);
		svgDoc = svgObj.contentDocument;
	}
	else
		svgDoc = document.getElementById(nameId).getSVGDocument();
	if(typeof svgDoc === "undefined")
		return;

	if((chartLabels === null) || (chartLabels === "y") || (chartLabels === "both")) {
		if(ymin === ymax) {
			//single datapoint
			svgDoc.getElementById("tspanY1").textContent = "";
			svgDoc.getElementById("tspanY2").textContent = ymin;
			svgDoc.getElementById("tspanY3").textContent = "";
		}
		else {
			svgDoc.getElementById("tspanY1").textContent = ymin;
			middle = ymin + ((ymax - ymin) * .50);
			middle = ivConvertValueToDisplayDecimalPlaces(middle);
			svgDoc.getElementById("tspanY2").textContent = middle;
			svgDoc.getElementById("tspanY3").textContent = ymax;
		}
	}
	if((chartLabels === null) || (chartLabels === "x") || (chartLabels === "both")) {
		if(bClearDurration)
			svgDoc.getElementById("tspanX4").textContent = "";
		else 
			svgDoc.getElementById("tspanX4").textContent = "1 Minute History";
	}
	svgDoc.getElementById("tspanY4").textContent = "";
	svgDoc.getElementById("tspanX1").textContent = ""; //xmin;
	svgDoc.getElementById("tspanX2").textContent = ""; //(xmax - xmin) * .50;
	svgDoc.getElementById("tspanX3").textContent = ""; //xmax;

	if(linecolor !== null){
		// change line color
		var lineObj = svgDoc.getElementById("polyline1");
		var linestyle = lineObj.getAttribute("style");
		var styleParameters = linestyle.split(";")
		var bFoundStroke = false;
		var newStyleStr = "";
		for(i=0; i < styleParameters.length; i ++)
		{
			if(styleParameters[i].includes("stroke:")) {
				styleParameters[i] = "stroke:" + linecolor;
				bFoundStroke = true;
			}
		}
		if(bFoundStroke) {
			for(i=0; i < styleParameters.length; i ++)
			{
				if(i > 0) {
					newStyleStr += ";";
				}
				newStyleStr += styleParameters[i];
				
			}
		}
		else {
			newStyleStr = linestyle + ";stroke:" + linecolor;
		}
		lineObj.setAttribute("style", newStyleStr);
	}
	if(polygoncolor !== null){
		var PolygonObj = svgDoc.getElementById("polygon1");
		var linestyle = lineObj.getAttribute("style");
		var styleParameters = linestyle.split(";")
		var bFoundStroke = false;
		var newStyleStr = "";
		for(i=0; i < styleParameters.length; i ++)
		{
			if(styleParameters[i].includes("fill:")) {
				styleParameters[i] = "fill:" + polygoncolor;
				bFoundStroke = true;
			}
		}
		if(bFoundStroke) {
			for(i=0; i < styleParameters.length; i ++)
			{
				if(i > 0) {
					newStyleStr += ";";
				}
				newStyleStr += styleParameters[i];
				
			}
		}
		else {
			newStyleStr = linestyle + ";fill:" + polygoncolor;
		}
		PolygonObj.setAttribute("style", newStyleStr);
	}
	if(textcolor !== null) {
		svgDoc.getElementById("textYAxis").style.fill = textcolor; // change text color
		svgDoc.getElementById("textXAxis").style.fill = textcolor; // change text color
	}
	if(fontsize !== null) {
		svgDoc.getElementById("textYAxis").style.fontSize = fontsize;  // change text font size
		svgDoc.getElementById("textXAxis").style.fontSize = fontsize; 
	}
}
function ivInitializeChart3Clear(nameId, chartList) {
	ivInitializeChart3Clear2Yaxis(true, nameId, chartList);
}
function ivInitializeChart3Clear2Yaxis(btwoaxis, nameId, chartList) {
	// supports two yaxis
	// if ymin1 and ymax1 = null then no Y2
	// set polygocolor to if more than one line
	var svgObj, svgDoc, currentEntries, i, nameId, PolylineObj;
	var bUseChartListNameId = false;
	try {
		if(nameId === "")
			bUseChartListNameId = true;
		for(i=0; i < chartList.length; i++)
		{
			if(bUseChartListNameId)
				nameId = chartList[i].displayId;
			if(navigator.userAgent.match(/Chrome/))	
			{		
				svgObj = document.getElementById(nameId);
				svgDoc = svgObj.contentDocument;
			}
			else
				svgDoc = document.getElementById(nameId).getSVGDocument();
			
			
			svgDoc.getElementById("tspanY1").textContent = "";
			svgDoc.getElementById("tspanY2").textContent = "";
			svgDoc.getElementById("tspanY3").textContent = "";
			svgDoc.getElementById("tspanY4").textContent = "";
			if(btwoaxis) {
				svgDoc.getElementById("tspan2ndY1").textContent = "";
				svgDoc.getElementById("tspan2ndY2").textContent = "";
				svgDoc.getElementById("tspan2ndY3").textContent = "";
				svgDoc.getElementById("tspan2ndY4").textContent = "";
			}

			svgDoc.getElementById("tspanX4").textContent = "";
			svgDoc.getElementById("tspanX1").textContent = ""; //xmin;
			svgDoc.getElementById("tspanX2").textContent = ""; //(xmax - xmin) * .50;
			svgDoc.getElementById("tspanX3").textContent = ""; //xmax;
			svgDoc.getElementById("tspanX1b").textContent = ""; //xmin;
			svgDoc.getElementById("tspanX2b").textContent = ""; //(xmax - xmin) * .50;
			svgDoc.getElementById("tspanX3b").textContent = ""; //xmax;
		
			currentEntries = chartList[i].dataCurrentEntries;
			if(currentEntries > 0) {
				PolylineObj = svgDoc.getElementById(chartList[i].lineName);
				if(PolylineObj !== null) {
					PolylineObj.setAttribute("color", "black");
					PolylineObj.setAttribute("points", "0,0");
				}
			}
			
		} // for(k=0; k < chartList.length; k++)
	}
	catch {}
}

function ivChangeChartHistoryInterval(n, nameId, interval) {
	var svgObj, svgDoc;
	if(navigator.userAgent.match(/Chrome/))	
	{		
		svgObj = document.getElementById(nameId);
		svgDoc = svgObj.contentDocument;
	}
	else
		svgDoc = document.getElementById(nameId).getSVGDocument();
	if(interval === 1)
	{
		svgDoc.getElementById("tspanX4").textContent = "1 Minute History";
		ChangeIntervalButtons(interval);
	}
	else if(interval === 2)
	{
		svgDoc.getElementById("tspanX4").textContent = "1 Hour History";
		ChangeIntervalButtons(interval);
	}
	else if(interval === 3)
	{
		svgDoc.getElementById("tspanX4").textContent = "1 Day History";
		ChangeIntervalButtons(interval);
	}
	else if(interval === 4)
	{
		svgDoc.getElementById("tspanX4").textContent = "1 Month History";
		ChangeIntervalButtons(interval);
	}

}
function ivUpdateChartsDatalogChart3TwoYaxis(displayId, sExtraStr, type, yAxisMode, chartList, timestamp,min, max, minY2, maxY2, startTimestamp, endTimestamp, iLineWidth, bExtendToEndTimeStamp, chartLabels) {
	// chart3.svg 
	// multiple datapoints and structured datapoints that has  -- chart3
	// type: 0 = trend, 1 =stepline; uses timestamp
	// yAxisMode: 0=single both Y1 and Y2 lines use Y1 axis only, 1= show Y1 only, 2= show Y2 only only, 3=show Both YAxis
	try {
		var xIndex = 0, i, k, x, y, yOld = 0, fvalue, s,t;
		var linestr = "", linestr1;
		var displayObj;
		var svgObj, svgDoc;
		var PolylineObj, PolygonObj;
		var range, rangeY2 = null, xRange, startTimestampMicroSec, endTimestampMicroSec;
		var chartMin, chartMinY2 = null;
		var startIndex;
		var currentEntries;
		var circleObj;
		var PointsPerEntry;
		var iTemp;
		var sDuration;
		
		var lineInfo = "";
		var time,dates, str, d, startDate, endDate, startTime, endTime, midDate = null, midTime = null, startDateStr, endDateStr;
		var bShowDates = false;
		var startPtr;
		var endPtr;
		if(chartList === null)
			return;
		if(chartList.length === 0)
			return;
		
		startTimestampMicroSec = startTimestamp; //chartList[Index].data[startIndex].timestamp;
		endTimestampMicroSec = endTimestamp; //chartList[Index].data[endPtr].timestamp;
		xRange = endTimestampMicroSec - startTimestampMicroSec; // MicroSec
		range = max - min; //chartList[Index].maxValue - chartList[Index].minValue;
		if((maxY2 !== null) && (minY2 !== null)) {
			rangeY2 = maxY2 - minY2; //chartList[Index].maxValue - chartList[Index].minValue;
			chartMinY2 = minY2;
		}
		displayObj = displayId; //chartList[Index].displayId;
		if(navigator.userAgent.match(/Chrome/))	
		{		
			svgObj = document.getElementById(displayObj);
			svgDoc = svgObj.contentDocument;
		}
		else
			svgDoc = document.getElementById(displayObj).getSVGDocument();
		for(k=0; k < chartList.length; k++)
		{
			currentEntries = chartList[k].dataCurrentEntries;
			if(currentEntries > 0) {
				if(chartList[k].creatChartLine) {
					chartList[k].creatChartLine = false;
					ivCreateNewPolyline(displayId, chartList[k].lineName, chartList[k].color, iLineWidth);
				}
				PolylineObj = svgDoc.getElementById(chartList[k].lineName);
				if(chartList[k].show) {
					lineInfo = "";
					linestr = "";
					
					startPtr = chartList[k].startPtr;
					endPtr = chartList[k].endPtr;
					//oldValue = null;
					
					//if(chartList[k].endPtr !== -1)
					//	oldValue = chartList[k].data[endPtr].value;
					
					startIndex = chartList[k].startPtr;
					
					//chartLabels = chartList[k].chartLabels;
					
					if(timestamp !== null) {
						if(chartList[k].data.length  > 0)
							chartList[k].data[endPtr].timestamp = timestamp;
					}
					
					chartMin = min; //chartList[Index].minValue;
					xIndex = startIndex;
					yOld = chartList[k].data[xIndex].value;
					
					//linestr += ' ' + 0 + ',' + 0;
	/*				
					if(currentEntries === 1) {
						PolylineObj = svgDoc.getElementById(chartList[k].lineName); //"polyline1");
						PolylineObj.setAttribute("stroke", "none");
						PolylineObj.setAttribute("color", chartList[k].color);
						//circleObj = svgDoc.getElementById("dot");
						//circleObj.setAttribute("fill", "blue");

					}
					else {
	*/					
					for(i = 0; i < currentEntries; i ++)
					{
						if(xRange === 0)
							x = ivChartXLengthLargeChart / 2;
						else
							x = ((chartList[k].data[xIndex].timestamp - startTimestampMicroSec) / xRange) * ivChartXLengthLargeChart;
						fvalue = chartList[k].data[xIndex].value;
						lineInfo += ", " + fvalue;
						xIndex ++;
						if(xIndex >= currentEntries)
							xIndex = 0;
						//y = (fvalue / g_dashboardChartList[Index].maxValue) * ivChartXYLength;
						if(yAxisMode === 0) // show all on single Yaxis -- the default
							y = ((fvalue - chartMin) / range) * ivChartYLengthLargeChart; 
						else if(yAxisMode === 3) {
							if(chartList[k].yAxis === 1) 
								y = ((fvalue - chartMin) / range) * ivChartYLengthLargeChart;
							else
								y = ((fvalue - chartMinY2) / rangeY2) * ivChartYLengthLargeChart;
						}
						else if(chartList[k].yAxis === 1) {
							if(yAxisMode !== 2)
								y = ((fvalue - chartMin) / range) * ivChartYLengthLargeChart;
						}
						else if(chartList[k].yAxis === 2) {
							if(yAxisMode !== 1)
								y = ((fvalue - chartMinY2) / rangeY2) * ivChartYLengthLargeChart;
						}
						
						if(type === 1) {
							if(i !== 0)
								linestr += ' ' + yOld + ',' + x; //stepLine
						}
						//if(i >= (currentEntries -1))
						//	x = ivChartXYLengthLargeChart + 3;
						linestr += ' ' + y + ',' + x;
						yOld = y;
						if(i === 0) {
							if(currentEntries === 1) { // create a scquare
								linestr = "";
								for(s=0; s < 25; s++)
								{
									for(t=0; t < 25; t++)
									{
										if(linestr !== "")
											linestr += ' ';
										linestr += (y - 12 + s) + ',' + (x - 12 + t);
									}
								}
							}
						}
					}
					if(bExtendToEndTimeStamp) {
						if(currentEntries > 1) {
							// extend line to right Y-axis
							if(chartList[k].data[endPtr].timestamp < endTimestamp) {
								if(xRange === 0)
									x = ivChartXLengthLargeChart / 2;
								else
									x = ivChartXLengthLargeChart;
								linestr += ' ' + y + ',' + x;
							}
						}
					}
					/* remove if polygon is no longer going to be supported
					if(chartList.length === 1) {
						PolygonObj = svgDoc.getElementById("polygon1");
						//line1str = line1obj.getAttribute("points");
						linestr1 = linestr + ' 1,' + x + ', 1,5';
						//linestr += ' 1,' + x + ', 1,5';
						PolygonObj.setAttribute("points", linestr1);
					}
					*/

					//PolylineObj = svgDoc.getElementById("polyline1");
					
					PolylineObj.setAttribute("color", chartList[k].color);
							
					PolylineObj.setAttribute("points", linestr);
	//				}
				}
				else { // hide line
					PolylineObj.setAttribute("color", "black");
					PolylineObj.setAttribute("points", "0,0");
				}
			} // if(currentEntries > 0) {
			else {
				// no data entries
				if(!chartList[k].creatChartLine) {
					PolylineObj = svgDoc.getElementById(chartList[k].lineName);
					if(PolylineObj !== null) {
						PolylineObj.setAttribute("color", "black");
						PolylineObj.setAttribute("points", "0,0");
					}
				}
			}
		} // for(k=0; k < chartList.length; k++)
		iTemp = xRange / 1000;
		sDuration = "";					
		if(iTemp < 60)
			sDuration = iTemp.toFixed(1) + " s";
		else if(iTemp < (60 * 60))
			sDuration = (iTemp / 60).toFixed(1) + " m";
		else if(iTemp < (60 * 60 * 24))
			sDuration = (iTemp / (60 * 60)).toFixed(1) + " hr";
		else 
			sDuration = (iTemp / (60 * 60 * 24)).toFixed(1) + " days";
		
		if((chartLabels === null) || (chartLabels === "x") || (chartLabels === "both")) {
			if((chartList.length === 1) && (currentEntries === 1)) {
				d = new Date();
				//d.setTime(g_chartList[Index].data[startPtr].timestamp);
				d.setTime(chartList[0].data[0].timestamp);
				time = d.toLocaleTimeString();
				dates = d.toLocaleDateString().split("/");
				str = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";
				svgDoc.getElementById("tspanX2b").textContent = str;
				svgDoc.getElementById("tspanX2").textContent = time;
			}
			else {
				d = new Date();
				d.setTime(startTimestamp);
				startDate = d.toLocaleDateString();
				startDateStr = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";
				startTime = d.toLocaleTimeString();

				d.setTime(endTimestamp);
				endDate = d.toLocaleDateString();
				EndDateStr = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";
				endTime = d.toLocaleTimeString();

				if(startDate !== endDate) {
					bShowDates = true;

					d.setTime(((endTimestamp - startTimestamp) / 2) + startTimestamp);
					midDate = d.toLocaleDateString();
					//dates = midDate.split("/");
					midTime = d.toLocaleTimeString();
				}
				str = "";
				if(bShowDates) {
					//dates = startDate.split("/"); 
					str += startDateStr;
					svgDoc.getElementById("tspanX1b").textContent = str;
				}
				else 
					svgDoc.getElementById("tspanX1b").textContent = "  ";
				svgDoc.getElementById("tspanX1").textContent = startTime;

				iTemp = endTimestamp - startTimestamp;
				iTemp = (iTemp / 2) + startTimestamp;
				d = new Date();
				d.setTime(iTemp);
				time = d.toLocaleTimeString();
				
				str = "";
				if(bShowDates) {
					dates = midDate.split("/");
					str += d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";
					dates = d.toLocaleDateString().split("/");
					svgDoc.getElementById("tspanX2b").textContent = str;
				}
				else 
					svgDoc.getElementById("tspanX2b").textContent = "  ";
				svgDoc.getElementById("tspanX2").textContent = time;
				str = "";
				if(bShowDates) {
					//dates = endDate.split("/");
					str += endDateStr;
					svgDoc.getElementById("tspanX3b").textContent = str;
				}
				else 
					svgDoc.getElementById("tspanX3b").textContent = "  ";
				svgDoc.getElementById("tspanX3").textContent = endTime;
			}
			svgDoc.getElementById("tspanX4").textContent = sExtraStr + sDuration; // + "   " + lineInfo;
		}

	} catch (err) {}

}

function ivPadStart(str, padChar, numChars) {
	var sResult = str;
	var sPad = "";
	var i, newChars;
	try {
		if(str.length < numChars) {
			newChars = numChars - str.length;
			for(i = 0; i < newChars; i++)
			{
				sPad += padChar;
			}
			sResult = sPad + str;
		}
	}
	catch {}
	return sResult;
}
function _ivSvgPoint(svgDoc, element, x, y) {
    // translate page to SVG co-ordinates
    if(svgDoc == null) 
        return null;
     //   var pt = g_datalogSvgDoc.createSVGPoint();
    var pt = svgDoc.documentElement.createSVGPoint();
    pt.x = x;
    pt.y = y;
    return pt.matrixTransform(element.getScreenCTM().inverse());

}