"use strict";
const SerialPort = require('serialport');
const Readline = require('@serialport/parser-readline');
const fs = require('fs'); 

// Using port 1 /dev/ttymcxx2
console.log('This application works only when Adam-4150 is in Init mode.');
console.log('\t%0 - Modbus address in hex [defalut = 01] two characters');
console.log('\t%1 - BaudRate 6: 9600, 7: 19200, 8: 38400, 9:57600, A: 115200 [defalut = 6]\n');
let baudRate ='6';
let mbAddr = '01';
let sequenceState = 0; 

let  args = process.argv.slice(2);  
if (args.length === 1)
    mbAddr = args[0];

if (args.length === 2) {

    mbAddr = args[0];
    baudRate = args[1];
}

const port = new SerialPort('/dev/ttymxc2', { baudRate: 9600 });
//%AANNTTCCFF See chapter 4.6 of the Advantech Adam 4100 UG
const adamCfg = `%00${mbAddr}400${baudRate}04\r`;
const parser = new Readline({ delimiter: '\r' });
port.pipe(parser);

var devAck = false;
parser.on('data', (data) => {
    var nowTs = new Date();
    console.log(data);
    // Process Config Response
    switch (sequenceState) {
        case 0:
            if (data.startsWith('!') && sequenceState == 0) {
                devAck = true;
                fs.writeFile('./adamConfig.log', `${nowTs.toLocaleString()} - Address: ${mbAddr}, BitRate: 0${baudRate}\n`,  {flag: 'w'}, 
                    (err) => {
                        if (err)
                            console.error(err);
                    }
                );
            } else {
                fs.writeFile(`./adamConfig.log`, `${nowTs.toLocaleString()} - Config failed\n`,  {flag: 'w'}, 
                    (err) => {
                        if (err)
                            console.error(err);
                    }
                );
            }
            sequenceState = 1;
            break;
        case 1:    
            // Read data !OOII00<cr> OO: hex coded output, II hex coded input, 00<cr> fixed
            //a.push(parseInt(str.substr(i,2),16));
            console.log('Response IO Read');
            if (data.startsWith('!')) {
                var outputs = parseInt(data.substr(1,2),16);
                var inputs = parseInt(data.substr(3,2,16));
                var ioState = `Switch 1: ${(inputs & 1) ? 'ON':'OFF'}\nSwitch 2: ${(inputs & 2)?'ON':'OFF' }\n`;
                fs.writeFile (`./adamConfig.log`, ioState, {flag: 'a'},
                    (err) => {
                        if (err)
                            console.error(err);
                    }
                );
                console.log(ioState);
            }
            break;
        default:
            break    
    }

    // Process DIO read response

});

setTimeout(() => {
    if (devAck)
        console.log("Config Success");
    else  
        console.log("Config Failed");  
    process.exit();
}, 10000);

console.log (`Setting Modbus Addr: ${mbAddr}, BaudRate Code: 0${baudRate}`);
port.write(adamCfg);
// !00\r is the expected device response
setTimeout(() => {
    console.log('Read Adam IO');
    port.write('$006\r');   //Read Digital data 
}, 400);



