/******************************************************************
 *  userinit()
 * 
 * userinit() allows you to customer to customize the Web page based on CMS user types, or specify a custom Web page.
 * 
 * This function is called by navtree init function and should contain or call other functions with all user modified variables and user functions to specify datapoints for for a given device, one or more device types, or program Id.
 * 
 * The navtree can be used to dynmaically show a navigation tree for the devices, and its datapoints, in the SmartServer IoT.  If you assign context to devices (e.g., room or area)
 * the navtree tree will show the contexts and where the device is assigned. Note, a device can be assigned to more than one context.  
 * 
 * When you click a device the default setup is to show all datapoints that have visible selected in the Datapoint Properties Widget.
 * navtree will dynamically create a dashboard and based on datapoint will show switches, charts, dropdown or input and span fields.
 * 
 * You can 
 *   
 * The userinit() allows you to define the navtree defaults and can be used to limit which datapoints are visible based on CMS user types. The default
 * settings is to show all datapoints with a visible flag selected in the datapoint Properties Widget. You can limit  
 * 
 * The CMS has three different user-types:
 *      OWNER, 
 *      SUPERVISOR
 *      USER. 
 * You can specify which datapoints user's can see based on their CMS user-type.
 * 
 * You can also define which writable datapoints ("inputs") are read only based on the CMS user-type. 
 * 
 *  
 *  If no device name, device type or program ID is specified then the dashboard shows all the datapoints for the specific device types.
 *  Replacement Device types can be specified by Device Name, Device Type Name, or by program ID.  
 *     - If using Device Name the you can specify more than one device device for each program ID.
 *     - If using Device Type Name the you can specify more than one device type for each program ID.
 *     - Only one program entry can be specified for a given.
 * 
 *  Order of checking
 *  1. Checks if Context custom tags. If custom tags for the context or device then it uses custom tags
 *  2. Checks if replacement Web page. Replacement Web page is implemented in iframe and requires width and height specification 
 *  3. Checks if replacement datapoints or image, but uses built-in dashboard generation
 *  4. If no replacement Web page or datapoints then shows all datapoints for device using built-in dashboard generation
 * 
 *  To limit which datapoints are shown in dashboard:
 *  1. Filters datapoint based on datapoint Visible flag in Datapoint Properties Widget
 *      - Visibility filter is used for REST API GET request 
 *      - use "g_useVisibilityFilter = <user type Visibility mask>" to specify when visibility filter is used.
 *      - <user type Visibility mask> = NONE then visibility filter is never used
 *      - <user type Visibility mask> = ALL  means visibility filter is used for each user-type
 *      - All other <user type Visibility mask> values specify which user-type use visibility filter
 *  2. List the datapoints per device type using one of the device name, device type or program ID functions below
 *      - if you specify a list of datapoints then only those datapoints are shown.
 *      - First Visibility filter is applied and then the function visibility selection is applied.
 * 
 *  The following is supported:
 *  1. Use default datapoints in dashboard (show all device's datapoints)
 *      a. used for all devices unless replacement Web page, or replacement datapoints/image specified
 *    
 *  2. Add device image only to dashboard
 *      a. For SmartServer 
 *           addSmartServerImage("images/smartserver.png",250, null); // For segment controller
 *      b. For device type
 *          Format: 
 *              addDeviceTypeReplacementProgramId(programId, allVersions, url, width, height)
 *                  or
 *              addDeviceTypeReplacement(deviceType, url, width, height)
 *          Example:
 *              addDeviceTypeDpList("SC100-MP", null, "images/sc100.png",300, null); // add only image
 *  3. Add device image and Select datapoints for each device type to dashboard
 *  4. Use own custom Web page, Uses iframe and need to specify iframe width and height (in px)
 *      Example:
 *          addDeviceTypeWebPage("PulseGen", "../deviceconfig/pulsegenchart.html", 1400, 800);
 *          addProgramIdWebPage("900001153C000405", false, "../deviceconfig/pulsegenchart.html", 1400, 800);
 *      Requires: custom web page to support, ?tree=true&device=<device name>
 *          a. "tree=true" is used to remove the logout button from the custom Web page, otherwise you will see two logout buttons
 *          b.  "device=<device name>" is used to specify device being accessed
 * 
 *  Built-in functions used by this file are defined in devicetypes.js
 *  addDpObjAll(blockPath, displayElementType, userVisibility, userReadtonly, normalUserWritePriority,normalUserClearPriority)
 *      sid = SmartServer "Segment ID" or Install code
 * 
 *
 *   // User-type CONSTANTs - Most be all CAPS 
 *          - used for <user type Visibility mask>
 *              - can equal null, "NONE", "ALL" or combination of adding OWNER, SUPERVISOR and/or USER
 *          - used to determine which user-types are supported for addDpObjAll() visibility and readonly paramters
 *          
 *      ALL = 7; // owner CMS user-type
 *      OWNER = 4; // owner CMS user-type
 *      SUPERVISOR = 2;// supervisor CMS user-type
 *      USER = 1; // user CMS user-type
 *      NONE = 0; // user CMS user-type
 * 
 *   For example:  
 *      g_useVisibilityFilter = SUPERVISOR + USER; // Owner sees all datapoints, 
 *                                                  // but Supervisor and user user-types only see Datapoints with Visible flag set (Datapoint Properties Widget)
 *      g_bDisplayDevicesStatusInFooter = OWNER; // means only owener sees Device status in Footer
 *      g_bDisplayDevicesStatusInFooter = OWNER + SUPERVISOR; // means owener and supervisor user-types see Device status in Footer,
 *                                                              // user user-type doesn't see device status in footer
 *      g_bDisplayDevicesStatusInFooter = ALL; // means all user-types (owener, supervisor and user) see Device status in Footer
 *      g_bDisplayDevicesStatusInFooter = NONE; // means no user-types (owener, supervisor and user) see Device status in Footer
 * 
 *  Adding functions to user.js
 *      Start all of your functions with user (e.g., userMyFunction()) so that there is no conflict with the NavTree built-in functions
 * 
 *	Copyright (C) 2023 EnOcean GmbH.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	EnOcean Example Software License Agreement which is available at
 *	https://enoceanwiki.atlassian.net/wiki/spaces/LON/pages/2425260/Example+Software+License+Agreement. 
 * 
*/
/********************************************************************
 *  Required function - User calls their custom function from this function
 *******************************************************************/


/********************************************************************
 *  userinit() - Changes Web page defaults and datapoints shown based on specific device specific device name, program ID or device type names
 * 
 *  Not all default variables are listed, see navtree.js for most of default settings.
 *  These settings can be overwritten by specifying custom tags for a context in the Planning Widget. 
 * 
 *******************************************************************/
function userInit() {
    

        // Don't remove commented parameters, un-comment to change parameter otherwise default settings are used

    //g_iShowTreeWhenNoContexts = OWNER; // only ownwer see Web page when no contexts in Planning Widget
    //g_NoContextsMessage = "Please Contact Site Administrator"; // If no contexts in Planning Widget
    //g_bUseWebSockets = true; // true = use only with Websockets to get datapoint updates [default], false = use GET response for datapoint updates
    
    //g_useVisibilityFilter = ALL; // use user-type Constants (Must be all CAPS) - NONE - show all datapoints,show visible Datapoints using Datapoint Properties visible setting 
    //g_bHideSubscribeButton = true; //Used with g_bUseWebSockets, false=always show re-subscrive button
    g_bSingleUserType = false; // false=different device types DPs for each user type (owner,supervisor or user), true=same for all user types [default]
    g_bUseChartForAllOutputs = true;
    g_bDashboardAutoDetectDevices = true; // used to create a dashboard if custom tags not available and have knownn device types
    g_bMapDashboardAutoDetectDevices = true; // true= if Context custom tags not specified, create based on known devices
 
        // UI specific
    //g_bShowDevicesInTree = ALL; // ALL [default] used to show devices in tree use user-type CONSTANTs (Must be all CAPS)
    //g_bDisplayDevicesStatusInFooter = OWNER + SUPERVISOR; // use user-type CONSTANTs (Must be all CAPS)
    //g_bShowDeviceStatusInTree = ALL; // use user-type CONSTANTs (Must be all CAPS)
    //g_bShowAllDeviceStatus = ALL; // use user-type CONSTANTs (Must be all CAPS)
    //g_showAdvancedCheckbox = OWNER + SUPERVISOR; // use user-type CONSTANTs (Must be all CAPS)
    //g_bUseChartForAllInputs = false; // false [default] Applies to scalars only (numbers)
    //g_bUseChartForAllOutputs = true; // true [default] Applies to scalars only (numbers)
    //g_iCurrentPriorityButtonType = 2; // 0=don't show, 1= "...", 2 = "P <priority>"
    //g_iDashboardDatalogRange = 1; // 0=no data logs, 1=10min, 2= 1 hour [default], 3 = 1 day. this may slow down Device Web signifantly if data log to big
    //g_iDashboardChartDuration = 0; //0= none [default], 1= 1 hour, 2 = 1 hour, 3 = 1 day
    //g_idashboardChartMaxNumberOfPointsDefault = 1000; // 0=unlimited
    //g_bShowRoomTableContextOnImage = true; // true=show table in image, false=show after image like floor
    //g_sTreeDevicesNoContent = "Click specific device";
    //g_sTreeNoContent = "No Content"; // "No Content" [default] What text to put when Campus, Building and Devices node clicked 
    

        // control write priorities
    g_OwnerUserTypeWritePriority = ">8";//"all"; //"all" = can write all priorities [default], "8" = write at priority 8 only, ">8" can write at priority 9 and below.
    g_OwnerUserTypeClearPriority = ">8";//"all"; //"all" = can write all priorities [default], "8" = write at priority 8 only, ">8" can write at priority 9 and below.
    // g_supervisorUserWriteTypePriority = "all"; //"all" = can write all priorities [default], "8" = write at priority 8 only, ">8" can write at priority 9 and below.
    // g_supervisorUserTypeClearPriority = "all"; //"all" = can write all priorities [default], "8" = write at priority 8 only, ">8" can write at priority 9 and below.
    // g_userUserTypeWritePriority = "all";  //"all" = can write all priorities [default], "8" = write at priority 8 only, ">8" can write at priority 9 and below.
    // g_userUserTypeClearPriority = "all";  //"all" = can write all priorities [default], "8" = write at priority 8 only, ">8" can write at priority 9 and below.
    // g_bIoxUseDefaults = true; // Use the built in IOX devices datapoints, set to false if you want to see all datapoints

        // device Type Replacement code - specify device datapoints and images
    userDeviceTypeReplacements();
}

/********************************************************************
 *  deviceTypeReplacements() - Add images for context or devices and change which datapoints are shown based on specific device specific device name, program ID or device type names
 * 
 *  If you specify a datapoint for a device name/program ID/device type name then you must specify all the datapoints for this item.
 *  These settings can be overwritten by specifying custom tags for a context in the Planning Widget. 
 *******************************************************************/
function userDeviceTypeReplacements() {
    // This function is required
    addSmartServerImage(null, "images/user/smartserver.png",250, null); // For segment controller
    addDeviceTypeProgramIdDpList(null, "900001153C000405", null, "images/user/ft6050_device.png",180, null); //PulseGen
    addDeviceTypeProgramIdDpList(null, "9FFFFF0501840460", null, "images/user/ft6050_device.png",180, null);  // addSensorDpList("6kEvbMultiSensor"); // works but show only image// use DP subset for device type and add image
    addDeviceTypeProgramIdDpList(null, "90000F0501EF0407", null, "images/user/sc100.png",300, null); // add only image
    addDeviceTypeProgramIdDpList(null, "9F0096052804DB01", null, "images/user/adam.png",null, 250); // add only image ADAM-4150
    addDeviceTypeProgramIdDpList(null, "800001230E041005", null, "images/user/nico4201pl.jpg",80,null); // add only image Nico
    //addDeviceTypeDpList(null, "VT7200-1H1C-3", null, "images/user/tstat.png", null, 300); // add only image
    addDeviceDpList(null, "Tstat-01", null, "images/user/tstat.png", null, 300); // add only image
    /*userAddEnoceanDevices();
    userAddEnoceanDashboard(); */
    //addGlobalTags(); // same as putting tags in planning Widget Campus custom tags
    return; //un comment and modify to support your different device types

    // custom webpage needs to support ?devicename={devicename}
    //addDeviceTypeReplacement("PulseGen", "../deviceconfig/pulsegenchart.html", 1400, 800);

    //"sites" have two types: "sites" -at least one context in planning Widget, and "site" - No Contexts in Planning Widget
    addImageForContext(null, "sites", null,null, null, null,"<br><br><br><h2><span style='margin-left:150px'>Monitoring and Control System</span></h2>");
    
    
    addImageForContext("17qam88", "sites",null,"images/user/starterkit.png", null, 600,"<b><span style='margin-left:150px;'>STARTER KIT</span></b><br><br>", true);
    
    //addImageForContext("17qam77,17qam88", "campus",null,"images/user/campus1map.png", 600, null,"3600 Peterson Way, Santa Clara, CA 95054,USA", false);
    addImageForContext("17qam88", "building", "BUILDING","images/user/building1.png",null, null, "South Building"), false;


    //addProgramIdWebPage(null, "900001153C000405", true,  "../deviceconfig/pulsegenchart.html", 1400, 800); // replacement Web page for PulseGen
    addProgramIdWebPage(null, "PulseGen-1", true,  "../deviceconfig/pulsegenchart.html", 1400, 800); // replacement Web page for PulseGen

    
    //addImageForContext(null, "campus",null,"images/user/campus1map.png", 600, null,"3600 Peterson Way, Santa Clara, CA 95054,USA", false);
    addImageForContext(null, "building", "BUILDING","images/user/building1.png",null, null, "South Building", false);
   
    
    // starter kit 
    addDeviceTypeDpList(null, "6kEvbMultiSensor", null, "images/user/ft6050_device.png",300, null);  // addSensorDpList("6kEvbMultiSensor"); // works but show only image// use DP subset for device type and add image
    addDeviceTypeDpList(null, "SC100-MP", null, "images/user/sc100.png",300, null); // add only image
    addDeviceTypeDpList(null, "ADAM-4150", null, "images/user/adam.png",null, 300); // add only image
    //addDeviceTypeDpList(null, "VT7200-1H1C-3", null, "images/user/tstat.png", null, 300); // add only image
    addDeviceDpList(null, "Tstat-01", null, "images/user/tstat.png", null, 300); // add only image

    
}

/********************************************************************
 ********************************************************************
 *  User Custom function - one per device type
 ********************************************************************
 *******************************************************************/
 
 function userAddEnoceanDevices() {
    var sid = null; // null means for all SmartServers, For specific SmartServer enter SmartServer SID as a string "x12345"
    userAddEnoceanDevicesMs();
    addDeviceTypeProgramIdDpList(sid, "80000BF60204E001", null, "images/user/enoceandoublerockerswitch",200,null);
    addDeviceTypeProgramIdDpList(sid, "80000BA50403E001", null, "images/user/enoceaneths.jpg",200,null);
    addDeviceTypeProgramIdDpList(sid, "80000BD50001E001", null, "images/user/enoceanmcs.jpg",200,null);
    addDeviceTypeProgramIdDpList(sid, "80000BA50703E001", null, "images/user/enoceanoccupancysensor.png",null,200);
}

function userAddEnoceanDevicesMs() {
    // STM 550 MultiSensor (MS)
    try {
        var sid = null; // null means for all SmartServers, For specific SmartServer enter SmartServer SID as a string "x12345"
        // create datapoint list
        var dpList = [];
        dpList.push(addDpObjAll(sid,"Multisensor/3/Luminance", "c", null, null, null,null,"lux")); 
        dpList.push(addDpObjAll(sid,"Multisensor/1/Temperature", "c", null, null, null,null,"°F")); 
        dpList.push(addDpObjAll(sid,"Multisensor/2/Humidity", "c", null, null, null,null,"%")); 

        dpList.push(addDpObjAll(sid,"Multisensor/8/Contact State", "c", null, null, null,null,null)); 
        dpList.push(addDpObjAll(sid,"Multisensor/4/Acceleration Status", "c", null, null, null,null,null)); 
        dpList.push(addDpObjAll(sid,"Multisensor/5/Acceleration X", "c", null, null, null,null,null)); 
        dpList.push(addDpObjAll(sid,"Multisensor/6/Acceleration Y", "c", null, null, null,null,null)); 
        dpList.push(addDpObjAll(sid,"Multisensor/7/Acceleration Z", "c", null, null, null,null,null)); 
        addDeviceTypeProgramIdDpList(sid, "80000BD21441E001", dpList, "images/user/enoceanmultisensor.png",150,null);
    }
    catch {}
}
function userAddSensorDpList(deviceTypeName) {
    // deviceTypeName: if not "" then use for specific device type otherwise use for all device types with program ID
    // used to reduce number of datapoints displayed and adds picture
    try {
        var sid = null; // null means for all SmartServers, For specific SmartServer enter SmartServer SID as a string "x12345"
        // create datapoint list
        var dpList = [];
        dpList.push("*/*/nvoTemp*");
        dpList.push("LightSensor/0/nvoLightLevel");
        //dpList.push(addDpObjAll("Lamp/*/~iLamp", null, null, null, ">8",">8")); // user type specific requirements
        //dpList.push(addDpObjAll("Lamp/*/~iLamp", "s3", (OWNER + SUPERVISOR + USER), USER, ">8",">8")); // example for SNVT_switch user type specific requirements
        //dpList.push(addDpObj("Lamp/*/~oLamp"));
        dpList.push("Lamp/0/~Lamp");
        dpList.push(addDpObjAll("Lamp/1/~Lamp", "s4", null, null, ">8",">8")); // example for SNVT_switch user type specific requirements
        
        dpList.push("Lamp/*/~oLamp");
        dpList.push("Switch/*/nvo*");
        if(deviceTypeName !== "")
            addDeviceTypeDpList(sid, deviceTypeName, dpList, "images/user/ft6050_device.png",300,null);
        else
            addDeviceTypeProgramIdDpList(sid, "9FFFFF0501840460", dpList, "images/user/ft6050_device.png",300,null);
    }
    catch {}
}

 function userAddIoxDioDpList(deviceTypeName) {
    // deviceTypeName: if not "" then use for specific device type otherwise use for all device types with program ID
    // used to reduce number of datapoints displayed and adds picture
    try {

        // create datapoint list
        var dpList = [];
        dpList.push("*/*/nvoTemp*");
        dpList.push("LightSensor/0/nvoLightLevel");
        dpList.push(addDpObjAll("Lamp/*/~iLamp", null, null, null, "<8","<8", null)); // user type specific display element requirements
        dpList.push("Lamp/*/~iLamp");
        dpList.push("Lamp/*/~oLamp");
        dpList.push("Switch/*/nvo*");
        if(deviceTypeName !== "")
            addDeviceTypeDpList(deviceTypeName, dpList, "images/user/ft6050_device.png",null,null);
        else
            addDeviceTypeProgramIdDpList("9FFFFF0501840460", dpList, "images/user/ft6050_device.png",null,null);
    }
    catch {}
}
function addGlobalTags() {
    // You can use this to add campus custom tags instead of using the Planning Widget Campus custom tags.
    userAddCustomTag("image: image=images/user/campus1map.png,height=600,above=false,location=Renesas IEC Campus");
    userAddDashboardDpList1();
    userAddSensorDpList1();
    userAddPulseGenDpList1();
    userAddEnoceanDashboard();
}
function userAddDashboardDpList1() {
    // this is a site Dashboard, not device dashboard
}
function userAddSensorDpList1() {
    // Global Tags - same as Campus Tags - not currently supported
    // used to reduce number of datapoints displayed and adds picture
    try {

        addCustomTag("devicetype_sensor.dp1: (9FFFFF0501840460)/Lamp/0/nviLamp, label=LampIn 1, displaytype=s3, color=orange, contexts=floor;room");
        addCustomTag("devicetype_sensor.dp2: (9FFFFF0501840460)/Lamp/0/nvoLampFb, label=LampOut 1, displaytype=l3,color=orange, contexts=floor;room, dashboard=100;405");
        addCustomTag("devicetype_sensor.dp3: (9FFFFF0501840460)/Lamp/1/nviLamp,label= LampIn 2, displaytype=s4, contexts=floor;room");
        addCustomTag("devicetype_sensor.dp4: (9FFFFF0501840460)/Lamp/1/nvoLampFb, label=LampOut 2, displaytype=l4, contexts=floor;room,dashboard=250;405;l4;mediumblue");
        addCustomTag("devicetype_sensor.dp5: (9FFFFF0501840460)/LightSensor/0/nvoLightLevel, label=Light Level, units=lux, displaytype=r;c,contexts=floor;room,dashboard=100;310");
        addCustomTag("devicetype_sensor.dp6: (9FFFFF0501840460)/TempSensor/0/nvoTemperature, label=Temp, displaytype=r;c, units=°C, contexts=floor;room,dashboard=200;310");
        addCustomTag("devicetype_sensor.dp7: (9FFFFF0501840460)/Switch/0/nvoSwitch, label=SwitchOut 1, displaytype=l4, contexts=room,dashboard=60;405");
        addCustomTag("devicetype_sensor.dp8: (9FFFFF0501840460)/Switch/1/nvoSwitch, label=SwitchOut 2, displaytype=s4, contexts=room,dashboard=210;405");
        addCustomTag("devicetype_sensor.image: devicetype=(9FFFFF0501840460),image=images/user/ft6050_device.jpg,width=null,height=null");
    }
    catch {}
}
function userAddPulseGenDpList1() {
    // Global Tags - same as Campus Tags - not currently supported
    // used to reduce number of datapoints displayed and adds picture
    try {

        addCustomTag("devicetype_image.image: devicetype=(900001153C000405),image=images/user/ft6050_device.jpg,width=null,height=null");
        addCustomTag("devicetype_pulsegen.dp01: (900001153C000405)/device/0/nviLamp1, LampIn 1a, displaytype=s4, contexts=room");
        addCustomTag("devicetype_pulsegen.dp02: (900001153C000405)/device/0/nvoLamp1, LampOut 1a, displaytype=l4,dashboard=100;405");
        addCustomTag("devicetype_pulsegen.dp03: (900001153C000405)/device/0/nviLamp2, LampIn 1b, displaytype=s3, contexts=floor;room,color=orange");
        addCustomTag("devicetype_pulsegen.dp04: (900001153C000405)/device/0/nvoLamp2, LampOut 1b, displaytype=l3, contexts=floor;room,color=orange,dashboard=250;405;l3;mediumblue");
        addCustomTag("devicetype_pulsegen.dp05: (900001153C000405)/device/0/nvoSwitch1, Switch 1a, displaytype=l4,contexts=room,color=red,dashboard=60;405");
        addCustomTag("devicetype_pulsegen.dp06: (900001153C000405)/device/0/nvoSwitch2, Switch 1b, displaytype=l4,contexts=room,dashboard=210;405");
        addCustomTag("devicetype_pulsegen.dp07: (900001153C000405)/device/0/nvoLuxLevel, Light Level 1, displaytype=r;c, units=lux, contexts=floor;room,dashboard=100;310");
        addCustomTag("devicetype_pulsegen.dp08: (900001153C000405)/device/0/nvoHVACTemp, Temp 1, displaytype=r;c,units=°C, contexts=floor;room,dashboard=200;310");
        /*
        addCustomTag("devicetype_pulsegen.dp09: (900001153C000405)/device/0/nvoPulseType, Pulse Type");
        addCustomTag("devicetype_pulsegen.dp10: (900001153C000405)/device/0/nviPulseEnable, label=PulseOut Enable");
        addCustomTag("devicetype_pulsegen.dp11: (900001153C000405)/device/0/nvoPulseOut, label=PulseOut,contexts=floor;room,displaytype=c");
        addCustomTag("devicetype_pulsegen.dp12: (900001153C000405)/device/0/nviPulseType, label=PulseOut Type");
        addCustomTag("devicetype_pulsegen.dp13: (900001153C000405)/device/0/nviCount, label=Count In, displaytype=n,contexts=room,readonly=false");
        addCustomTag("devicetype_pulsegen.dp14: (900001153C000405)/device/0/nvoCount, labe=Count Out,contexts=room");
        
        addCustomTag("devicetype_pulsegen.dp15: (900001153C000405)/device/0/nviHVACMode, label=HVAC Mode In, contexts=room, displaytype=d,readonly=false");
        addCustomTag("devicetype_pulsegen.dp16: (900001153C000405)/device/0/nvoHVACMode, label=HVAC Mode Out, displaytype=r;c, contexts=room");
        addCustomTag("devicetype_pulsegen.dp17: (900001153C000405)/device/0/nviDevStatus, label=Dev Status In, displaytype=s1;c, contexts=room,readonly=false");
        addCustomTag("devicetype_pulsegen.dp18: (900001153C000405)/device/0/nvoDevStatus, label=Dev Status Out, displaytype=s0;c, contexts=room");
        addCustomTag("devicetype_pulsegen.dp19: (900001153C000405)/device/0/nviSwIn");
        addCustomTag("devicetype_pulsegen.dp20: (900001153C000405)/device/0/nvoSwOut");
        */
        addCustomTag("devicetype_pulsegen.dp21: (900001153C000405)/device/0/nviTempSetPt, contexts=room, displaytype=r;c,readonly=false");
        addCustomTag("devicetype_pulsegen.dp22: (900001153C000405)/device/0/nvoTempSetPt, displaytype=r;c, contexts=room");
    }
    catch {}
}
function userAddEnoceanDashboard() {
    addCustomTag("dashboard_image.icon: image=images/user/enoceaneths.jpg,height=50,x=50,y=50,device=(80000BD21441E001)");
    addCustomTag("dashboard_dashboard1.dp01:(80000BD21441E001)/Multisensor/3/Luminance,label=EnOcean MS Luminance,displaytype=c,dashboard=100;180,width=4.0em, units=lux");
    addCustomTag("dashboard_dashboard1.dp02:(80000BD21441E001)/Multisensor/1/Temperature,label=EnOcean MS Temperature,displaytype=c,dashboard=100;150,width=4.0em,precision=1, units=°F");
    addCustomTag("dashboard_dashboard1.dp03:(80000BD21441E001)/Multisensor/2/Humidity,label=EnOcean MS Humidity,displaytype=c,dashboard=100;210,width=4.0em, units=%");
    addCustomTag("dashboard_dashboard1.dp04:(80000BD21441E001)/Multisensor/8/Contact State,label=EnOcean MS Contact,displaytype=c,dashboard=120;100;l2g,width=25,value=1:images/user/occupiedSmallNo.gif;0:images/user/occupiedSmallYes.gif");
    addCustomTag("dashboard_dashboard1.dp05:(80000BD21441E001)/Multisensor/4/Acceleration Status,label=EnOcean MS Acceleration Status,displaytype=r;c,dashboard=100;240,width=4.0em");
    addCustomTag("dashboard_dashboard1.dp06:(80000BD21441E001)/Multisensor/5/Acceleration X,label=EnOcean MS Acceleration X,displaytype=r;c,dashboard=100;270,width=4.0em");
    addCustomTag("dashboard_dashboard1.dp07:(80000BD21441E001)/Multisensor/6/Acceleration Y,label=EnOcean MS Acceleration Y,displaytype=r;c,dashboard=160;270,width=4.0em");
    addCustomTag("dashboard_dashboard1.dp08:(80000BD21441E001)/Multisensor/7/Acceleration Z,label=EnOcean MS Acceleration Z,displaytype=r;c,dashboard=220;270,width=4.0em");
    addCustomTag("dashboard_dashboard1.dp10:(80000BA50703E001)/Luminance/1/Luminance,label=EnOcean Occ Luminance,displaytype=r;c,dashboard=230;400,width=4.0em, units=lux");
    addCustomTag("dashboard_dashboard1.dp11:(80000BA50703E001)/Voltage/1/Voltage,label=EnOcean Occ Voltage,displaytype=r,dashboard=230;430,width=4.0em, units=V");
    addCustomTag("dashboard_dashboard1.dp12:(80000BA50703E001)/Occupied/1/Occupied,label=EnOcean Occ Occupancy,displaytype=r,dashboard=230;460;i,width=25,value=0:images/user/occupiedSmallNo.gif;1:images/user/occupiedSmallYes.gif");
    addCustomTag("dashboard_dashboard_image.image:image=images/user/office.jpg,height=500");
    addCustomTag("devicetype_enoceandblrockerswitch.image:devicetype=(80000BF60204E001),image=images/user/enoceandoublerockerswitch,width=200,height=null");
    addCustomTag("devicetype_enoceaneths.image:devicetype=(80000BA50403E001),image=images/user/enoceaneths.jpg,width=200,height=null");
    addCustomTag("devicetype_enoceanmcs.image:devicetype=(80000BD50001E001),image=images/user/enoceanmcs.jpg,width=200,height=null");
    addCustomTag("devicetype_enoceanms.image:devicetype=(80000BD21441E001),image=images/user/enoceanmultisensor.png,width=150,height=null");
    addCustomTag("devicetype_enoceanoccupancy.image:devicetype=(80000BA50703E001),image=images/user/enoceanoccupancysensor.png,width=null,height=200");
}
function userAddTest1DashboardDpList1() {
    // Global Tags - same as Campus Tags - not currently supported
    // used to reduce number of datapoints displayed and adds picture
    try {

        addCustomTag("dashboard_image.image: image=images/user/starterkit.png,height=500");
        addCustomTag("dashboard_dashboard1.dp01: PulseGen-1/device/0/nviLamp2, field=value, LampIn 1b value, displaytype=n, contexts=floor;room,readonly=false");
        addCustomTag("dashboard_dashboard1.dp02: PulseGen-1/device/0/nviLamp2, field=state, LampIn 1b state, displaytype=n, contexts=floor;room,readonly=false");
        addCustomTag("dashboard_dashboard1.dp03: PulseGen-1/device/0/nvoLamp2, field=value, label=LampOut 1b value, displaytype=r, contexts=floor;room,dashboard=250;405");
        addCustomTag("dashboard_dashboard1.dp04: PulseGen-1/device/0/nvoLamp2, field=state, label=LampOut 1b state,displaytype=r, contexts=floor;room,dashboard=230;405");
        addCustomTag("dashboard_dashboard1.dp5: Sensor-1/LightSensor/0/nvoLightLevel, Light Level 2, units=lux, displaytype=r;c,contexts=floor;room,dashboard=100;310");
    }
    catch {}
}



