/*************************************************************************************************
 *  navtreeplanning.js
 * 
 *  Contains code for the Planning View navigation tree.
 * 
 *  This code gets all devices and all context and then builds the navigation tree. Works well on small
 *	sites, but larger sites should probably require user to expand node before getting context and device 
 *	data
 *
 * 
 * When creating the tree, all nodes are fully expanded. A context Devices nodes has all device nodes.  
 * Devices nodes are automatically collapsed so that only context and devices nodes show up initially. 
 * Expanding the devices nodes shows the hidden device nodes. When you exapand a device then a REST call
 * is made to get the device datapoint list. 
 * 
 * It is difficult to get the tree lines to work correctly. The last node in the tree must remove the 
 * previous <ul> lines so that the lines only goes to the device and not extend down to the children.
 * When this occurs the line ends with no nodes attached.  
 * 
 * The site dashboard, context region, campus and building, and device dashboards are built using navtreedashboard.js
 *  
 * When a floor, room or area is selected the the image is shown with UI elements that are populated with out values. 
 * The datapoints are then read and are then populated.
 * 
 * The following style must be added to the last node  <ul> of a node list in order to remove vertical dotted line
 *      style=\"border-left: 3px solid #366184;margin-left: -18px; 
 * 
 * getPlanningCampusContextTags() - gets custom Fields from campus context, only one campus is supported
 * 
 *  
 * build tree:
 * 	getplanningTreeShowTreeContext()
 * 	getplanningTreeShowTreeContextBuilderWithDatapoints() - builds the tree
 * 
 * Clicking on tree:
 *	getPlanningTreeShowSiteDashboard1() - Clicking on site, world, region, campus or building dashboard - works similar to device dashboard
 *	getPlanningTreeShowTreeDetails() - Clicking on site, world, region, campus, building, room, area nodes
 *	treeviewshowcontextdevicesinDetailsPane() - Clicking on devices node
 *	getPlanningTreeShowDashboard() - Clicking on device node shows device dashboard
 *	showPlanningTreeCalendar() - clicking on schdedule node
 * 
 * devices Node:
 * 	treeviewShowContextDevicesInDetailsPane() - when devices node clicked
 * 	getPlanningTreeShowTreeDatapoints() - shows device datapoints in details pane
 * 	treeviewToggle1 - expands/collapse device datapoints
 *  getPlanningTreeShowDashboard() - When device clicked in tree - use custom device dashboard if specified, if not use bultin dashboard
 * 	getPlanningTreeShowTreeDatapointsRequestDataResponse() - used to process datapoint information
 * 	
 * 
 * 
 * 
 * context Node:
 * 	getPlanningTreeShowTreeDetails() - click on context
 * 	getPlanningTreeShowTreeFloorplan - floorplan (floor, room, area)
 *  getPlanningTreeShowTreeFloorplanShowDevices() - shows devices and DPs on floorplan
 * 
 *  
 * 	getPlanningFloorPlanShowContextDps() - builds dplist based on Context or g_CampusTags. This list is then used later to build dashboardDpList for this context
 * 	getPlanningContextDpsListResponse() - builds contexts dashboardDpList displaytypes based on response from GET
 * 	getPlanningGetAlarmsForDeviceResponse() - process active alarms
 * 
 *  g_displayTypeList - list context related display types
 * 
 * 	getPlanningTreeShowSiteDashboardPopulateDpList() - site dashboard, region, campus and building
 * 
 * getPlanningContextDpsListResponse - site dashboard, region, campus and building datapoint list
 * 
 *  dashboardProcessWebSocketDpData() - process datapoint updates - located in the navtreedashboard.js file
 * 
 * 	windowResize() - located in navtree.js
 * 
 *	Example Campus tags (tag: value)
 *	alarms: showalarms=ALL,clearalarms=ALL,alarmcolors=cyan;yellow;orange;pink
 *  devicetype_pulsegen.dp8: (900001153C000405)/device/0/nvoLuxLevel, Light Level 1, displaytype=r;c,units=lux, contexts=floor;room,dashboard=200,300
 * 
 * 	Floorplans 
 * 		GET	/iap/zones/*+floor.id==2237, for 4.1+ use information in /iap/context istead 
 * 		GET	/iap/devs?floorid=2237
 * 		GET /iap/alarms/device/5  - one request per device
 *		GET /iap/devs  +qualifier=-17qehie%2Flon%2F54%2Fdevice%2F0%2FnvoLuxLevel,17qehie%2Flon%2F54%2Fdevice%2F0%2FnvoHVACTemp/*?noxs=true
 * 		GET /iap/dp/types?datapointsPresence=true;  //only if missing SNVT type
 *		PUT /iap/dp/updates/subscribe
 *
 *  Device Dashboard
 * 		GET	/iap/alarms/device/3
 * 		GET /iap/devs/*+name==PulseGen-1   ?noxs=true&visible=true  - gets datapoint list
 *		GET /iap/alarms/count?activeOnly=true -
 * 		WS 	/iap/ws?dev=%2A%2Bname==PulseGen-1&value=....; // get data logsif custom tags are used
 *		GET /iap/dp/types?dpTypeName=SNVT_switch;  //only if missing SNVT type
 * 		PUT	/iap/dp/updates/subscribe
 *
 * 	Site Dashboard
 * 		GET /iap/alarms/device/3 - one request per device
 * 		GET /iap/devs  +qualifier=-17qehie%2Flon%2F54%2Fdevice%2F0%2FnvoLuxLevel,17qehie%2Flon%2F54%2Fdevice%2F0%2FnvoHVACTemp/*?noxs=true
 * 		WS "/iap/ws?dev=%2A%2Bname==PulseGen-1&value=";" // if custom tags are used
 * 
 * 		PUT	/iap/dp/updates/subscribe
 * 
 *  Creating a tree - node class to use
 * 	 tree node list not last node -  class =treeli treeviewLiActive
 * 	 tree node list last node -    class =treeli treeviewLiActiveLastChild
 * 	 tree node entry (not list) - class =treeli
 *   
 *	Copyright (C) 2023 EnOcean GmbH.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	EnOcean Example Software License Agreement which is available at
 *	https://enoceanwiki.atlassian.net/wiki/spaces/LON/pages/2425260/Example+Software+License+Agreement.  
 * 
 ***************************************************************************************************/
var g_bPlanningTreeShowDatapointNodes = true;
var g_treeviewInitialCollapseList = [];
var planningDpList = [];
var g_iPlanningPaneSelectedContextId = -1;
var g_iPlanningPaneSelectedContextType = -1; // 0=campus/building/floor/room/area, 1=devices,2=device,3=datapoints
var g_sPlanningTreeDatapointPath = "";
var g_bPlanningDpPollingEnabled = true;
var g_iPlanningPollInterval = 5;
var g_planningDpOnDemandTimerInterval = 10000; // firefox takes more time to load svg then chrome
var g_planningDpTimerId = 0; // used to initilize svg elements
var g_bPlanningShowDevice = true;
var g_bPlanningShowConfiguration = false;
var g_bPlanningShowConfigurationSingleDp = false;
var g_iPlanningTreeDivResizeTimerId = 0;
var g_iTreeDivTreeHeight = 0;
var g_iTreeDivTreeWidth = 0;
var g_sContextDpQualifierList = "";
var g_sContextDpQualifierDeviceList = []; //used for alarms
var g_displayTypeList = []; // used to use "s3" or "s4" for SNVT_switch
var g_iContextTableX = 0;
var g_iContextTableY = 0;
var g_bPlanningShowContextDpMenuButton = true;
var g_iDisplayIndex = 0;
var g_campusTags = {};
var g_treeDashboardTags = {};
var g_iPlanningFloorplanInputElementSize = 8;
var g_iPlanningFloorplanSpanMinWidth = 15; // needed so span can be hovered for tool tip
var g_bSiteDashboard = false;
var g_bSiteDashboardEnabled = true;
var g_iContextDisplayType = [0,0]; // used to show whether datapoints show device name or only value and units, 0=show defaults, 1=show only value, 2= same as 1 but show tool tip
var g_bContextDatapointDeviceLink = false; // false no link, true = in read only mode clicking device name or value (based on g_iContextDisplayType) will show device dashboard
var g_bPreloadSiteDashboardEnable = true; // site dashboard sometimes takes too long to load on vpns, preload
var g_bPreloadSiteDashboard = true; 
var g_sDemoMode = "none"; // "basic": dashbard only, no tree, no footer status
var g_bIgnoreUserJsReplacements = false;
var g_sPlanningLedOnColor = "rgb(10, 209, 10)";
var g_sPlanningLedOffColor = "white";
var g_bAtLeastOneDeviceFound = false;
var g_oPlanningContextZoom = {};
var g_bAllowContextZoom = true;
var g_bplanningContextZoomButtonsCheck = true; //controls whether buttons are used
var g_bplanningContextZoomButtons = true;
var g_bPlanningContextClicked = false;
var g_oPLanningContextDivs = [];  
var g_bPlanningAutoDetectDevces = false;
var g_bCustomTagsHasMapObjs = false;
var g_sMapTreeNodeId = "";


function planningInit() {
	g_iPlanningPaneSelectedContextId = -1;
	g_iPlanningPaneSelectedContextType = -1;
	g_treeviewInitialCollapseList = [];
	planningDpList = [];
	g_sPlanningTreeDatapointPath = "";
	g_bPlanningDpPollingEnabled = true;
	g_iPlanningPollInterval = 5;
	g_bPlanningShowDevice = true;
	g_bPlanningShowConfiguration = false;
	g_bPlanningShowConfigurationSingleDp = false;
	g_iPlanningTreeDivResizeTimerId = 0;
	g_iTreeDivTreeHeight = 0;
	g_iTreeDivTreeWidth = 0;
	g_sContextDpQualifierList = "";
	g_sContextDpQualifierDeviceList = []; //used for alarms
	g_displayTypeList = []; // used to use "s3" or "s4" for SNVT_switch
	g_bPlanningShowContextDpMenuButton = true;
	g_iDisplayIndex = 0;
	g_campusTags = {};
	g_treeDashboardTags = {};
	g_iContextDisplayType = [0,0]; // used to show whether datapoints show device name or only value and units, 0=show defaults, 1=show only value, 2= same as 1 but show tool tip
	g_bContextDatapointDeviceLink = false; // false no link, true = in read only mode clicking device name or value (based on g_iContextDisplayType) will show device dashboard
	g_bPreloadSiteDashboard = true; 
	g_sDemoMode = "none"; // "basic": dashbard only, no tree, no footer status
	g_bIgnoreUserJsReplacements = false;
	g_bAtLeastOneDeviceFound = false;
	g_bPlanningContextClicked = false;
	g_oPLanningContextDivs = [];
	g_bCustomTagsHasMapObjs = false;
	planningInitContextZoomInfo();
	
}
function planningInitContextZoomInfo() {
	if(g_bplanningContextZoomButtonsCheck) {
		if(g_bAllowContextZoom)
			g_bplanningContextZoomButtons = true;
		else 
			g_bplanningContextZoomButtons = false;
		}
	else 
		g_bplanningContextZoomButtons = false;
	g_oPlanningContextZoom.bFullFloorplan = false;
	g_oPlanningContextZoom.floorplanObjs = null;
	g_oPlanningContextZoom.url = "";
	g_oPlanningContextZoom.json1 = [];
	g_oPlanningContextZoom.imgWidth = -1;
	g_oPlanningContextZoom.imgHeight = -1;
	g_oPlanningContextZoom.top = -1;
	g_oPlanningContextZoom.left = -1;
	g_oPlanningContextZoom.right = -1;
	g_oPlanningContextZoom.bottom = -1;
	g_oPlanningContextZoom.polygonWidth = -1;
	g_oPlanningContextZoom.polygonHeight = -1;
	g_oPlanningContextZoom.polygonX1 = -1;
	g_oPlanningContextZoom.polygonX2 = -1;
	g_oPlanningContextZoom.polygonY1 = -1;
	g_oPlanningContextZoom.polygonY2 = -1;
	g_oPlanningContextZoom.polygonMarginX1 = -1;
	g_oPlanningContextZoom.polygonMarginX2 = -1;
	g_oPlanningContextZoom.polygonMarginY1 = -1;
	g_oPlanningContextZoom.polygonMarginY2 = -1;
	g_oPlanningContextZoom.xMargin = 10;
	g_oPlanningContextZoom.yMargin = 10;
	g_oPlanningContextZoom.multiplier = -1;
	
	g_oPlanningContextZoom.zoomMinWidth = 400;
	g_oPlanningContextZoom.zoomMaxWidth = 1000;
	
	g_oPlanningContextZoom.zoomMinHeight = 400;
	g_oPlanningContextZoom.zoomMaxHeight = 1000;
	g_oPlanningContextZoom.zoomInitialMaxWidth = g_oPlanningContextZoom.zoomMaxWidth;
	g_oPlanningContextZoom.zoomInitialMaxHeight = g_oPlanningContextZoom.zoomMaxHeight;
	g_oPlanningContextZoom.minMultiplier = -1;
	g_oPlanningContextZoom.multiplierIncrement = -1; // used for zooming.
	g_oPlanningContextZoom.zoomFullScreenMode = -1; //Needed to know when to transisition to multiplier before going to full screen mode -1=context always in full screen mode, 1=zoom mode, 0=in zoom full screen 
	g_oPlanningContextZoom.minZoomMultiplier = -1;
	g_oPlanningContextZoom.contextDpsListResponse = {};
	g_oPlanningContextZoom.contextDpsListResponse.mode = -1;
	g_oPlanningContextZoom.contextDpsListResponse.requestUrl = "";
	g_oPlanningContextZoom.contextDpsListResponse.json = []; 
	
	g_oPLanningContextDivs = [];
}
function getPlanningCampusContextTags(customFields) {
	// There are two types of dashboards: site dashboard and a device dashboard. Floorplans use contexts and datapoints
	// tag and values must be less than 256 characters
	var content = "";
	var i, j, k, m, x, y, x1, y1, z, iPtr, iPtr1, iTemp, bContinue2;
	var items = [], items1;
	var x1;
	var sTemp = "", sTemp1, sTemp2,name, name1, names,type, image, width,height, location = "", above = true, sid = null, bSidFound, sFolder;
	var displayType = "n";
	var obj = {}, obj1, obj2, obj3, value, breadonly = false;
	var contextPath = "";
	var layout,ltable,bAtLeastOneItem; 
	var dpList = [], dpList1 = [], items, items1, items2, item3,  items3, item4;
	var label = "";
	var bContinue = true;
	var element;
	
	var iXoffset = 0, iYoffset = 0, iTemp; 
	var sFieldPath = "";
	g_campusTags = {}
	if(customFields === null) 
		return;
	if(customFields === "") 
		return;
	try {
		
		
		
		g_campusTags.label = "";
		g_campusTags.deviceTypesList = [];
		/*
		g_campusTags.image = {};
		g_campusTags.image.image = "";
		g_campusTags.image.height = "";
		g_campusTags.image.width = ""; */
		g_campusTags.userList = [];
		g_campusTags.dashboard = [];
		g_campusTags.contextList = [];
		g_campusTags.map = [];
		g_bIgnoreUserJsReplacements = false;
		g_bCustomTagsHasMapObjs = false;
		
		for(x in customFields)
		{
			x1 = x.toLowerCase();
			items = [];
			try {
				if(x1 === "label")
					label = customFields[x];
				else if (x === "offsetx") {
					sTemp1 = customFields[x];
					try {
						iTemp = Number(sTemp1);
						if(!isNaN(iTemp))
							iXoffset = iTemp;
					}
					catch {}
				}
				else if (x === "demo") {
					sTemp1 = customFields[x];
					sTemp1 = sTemp1.toLowerCase();
					try {
						if(sTemp1 === "basic")
							g_sDemoMode = sTemp1; // no tree, dashboard only, no footer status
						else
							g_sDemoMode === "none"
					}
					catch {}
				}
				else if (x === "contexttagsonly") {
					sTemp1 = customFields[x];
					sTemp1 = sTemp1.toLowerCase();
					try {
						if(sTemp1 === "true")
							g_bIgnoreUserJsReplacements = true; // no tree, dashboard only, no footer status
						else
							g_sDemoMode === "none"
					}
					catch {}
				}
				else if (x === "tree") {
				
					try {
						items = customFields[x].split(",");
						image = ""; width = null; height = null;
						location = "";
						above = true;
						sid = null;
						bSidFound = false;
						for(i=0; i < items.length; i++)
						{
							if(items[i] !== "") {
								items1 = items[i].split("=");
								if(items1.length === 2) {
									items1[0] = items1[0].trim().toLowerCase();
									items1[1] = items1[1].trim();
									if(items1[0] === "showunassigneddevices") {
										iTemp =items1[1].trim();
										if(iTemp !== "") {
											iTemp = iTemp.toLowerCase();
											if(iTemp === "true")
												g_bShowUnassignedDevicesInTree = true; 
											else 
												g_bShowUnassignedDevicesInTree = false; 
										}
									}
									
								}
							}
						}
					}
					catch {}
				}
				else if (x === "showeps") {
					try {
						if(customFields[x] !== "") {
							iTemp = customFields[x].split("=");
				
							if(iTemp === "true")
								g_bShowUnassignedDevicesInTree = true; 
							else 
								g_bShowUnassignedDevicesInTree = false; 
						}
					}
					catch {}
				}
				else if (x === "roomoffsets") {
					try {
						items = customFields[x].split(",");
						image = ""; width = null; height = null;
						location = "";
						above = true;
						sid = null;
						bSidFound = false;
						for(i=0; i < items.length; i++)
						{
							if(items[i] !== "") {
								items1 = items[i].split("=");
								if(items1.length === 2) {
									items1[0] = items1[0].trim().toLowerCase();
									items1[1] = items1[1].trim();
									if(items1[0] === "xoffset") {
										iTemp =items1[1].trim();
										if(!isNaN(iTemp)) 
											g_iContextTableOffsetX = Number(iTemp);
									}
									else if(items1[0] === "yoffset") {
										iTemp =items1[1].trim();
										if(!isNaN(iTemp)) 
											g_iContextTableOffsetY = Number(iTemp);
									}
									else if(items1[0] === "showdevicestatus") {
										iTemp =items1[1].trim();
										if(iTemp !== "") {
											iTemp = iTemp.toLowerCase();
											if(iTemp === "true")
												g_bShowDeviceStatusInFloorplan = ALL; // use user-type CONSTANTs (Must be all CAPS)
											else 
												g_bShowDeviceStatusInFloorplan = NONE; // use user-type CONSTANTs (Must be all CAPS)
										}
									}
								}
							}
						}
					}
					catch {}
				}
				else if (x === "charts") {
					try {
						items = customFields[x].split(",");
						image = ""; width = null; height = null;
						location = "";
						above = true;
						sid = null;
						bSidFound = false;
						for(i=0; i < items.length; i++)
						{
							if(items[i] !== "") {
								items1 = items[i].split("=");
								if(items1.length === 2) {
									items1[0] = items1[0].trim().toLowerCase();
									items1[1] = items1[1].trim();
									if(items1[0] === "showcharts") {
										iTemp =items1[1].trim();  // 0=disable, 1=show charts everywhere, 2=show charts only on device dashboard
										if(iTemp === "0") {
											g_bDashboardGetDatalog = false;
											g_bSiteDashboardGetDatalog = false; // site dashboard,Region, Campus or building
										}
										else if(iTemp === "1") {
											g_bDashboardGetDatalog = true;
											g_bSiteDashboardGetDatalog = true; // site dashboard,Region,Campus or building
										}
										else if(iTemp === "2") {
											g_bDashboardGetDatalog = true;
											g_bSiteDashboardGetDatalog = false; // site dashboard,Region,Campus or building
										}
									}
									else if(items1[0] === "showduration") {
										iTemp =items1[1].trim();
										if(iTemp === "0") {
											g_bShowDatalogDuration = false;
										}
										else if(iTemp === "1") {
											g_bShowDatalogDuration = true;
										}
									}
									else if(items1[0] === "datalogrange") {
										iTemp =items1[1].trim();
										iTemp = Number(sTemp1);
										if(!isNaN(iTemp)) {
											if(iTemp > 0) {
												g_iDashboardDatalogRange = iTemp;

											}
											else {
												g_iDashboardDatalogRange = 0;
											}
										}
									}
								}
							}
						}
					}
					catch {}
				}
				else if (x === "datalog") {
					
					items = customFields[x].split(",");
					try {
						for(i=0; i < items.length; i++)
						{
							if(items[i] !== "") {
								items1 = items[i].split("=");
								if(items1.length === 2) {
									items1[0] = items1[0].trim().toLowerCase();
									items1[1] = items1[1].trim();
									if(items1[0] === "enable") {
										items1[1] = items1[1].toLowerCase();
										if(items1[1] === "true") 
											g_bDashboardGetDatalog = true; // from SmartServer
										else if(items1[1] === "false")
											g_bDashboardGetDatalog = false;
									}
									else if(items1[0] === "range") {
										iTemp = Number(items1[1]);
										if(!isNaN(iTemp)) {
											if(iTemp > 0) {
												g_iDashboardDatalogRange = iTemp;

											}
											else {
												g_iDashboardDatalogRange = 0;
											}
										}
									}
								}
							}
						}
					}
					catch {}
				}
				else if (x === "image") {
					items = customFields[x].split(",");
					image = ""; width = null; height = null;
					location = "";
					above = true;
					sid = null;
					bSidFound = false;
					for(i=0; i < items.length; i++)
					{
						if(items[i] !== "") {
							items1 = items[i].split("=");
							if(items1.length === 2) {
								items1[0] = items1[0].trim().toLowerCase();
								items1[1] = items1[1].trim();
								if(items1[0] === "image") {
									image =items1[1].trim();
								}
								else if(items1[0] === "width") {
									width =items1[1].trim();
								}
								else if(items1[0] === "height") {
									height =items1[1].trim();
								}
								else if(items1[0] === "sid") {
									if(items[1].trim().toLowerCase() !== "null") {
										sid = items1[1].trim();
									}
									bSidFound = true;
								}
								else if(items1[0] === "location") {
									location =items1[1].trim();
								}
								else if(items1[0] === "above") {
									items1[1] = items1[1].trim().toLowerCase();
									if(items1[1] === "false")
										above = false;
								}
							}
						}
						
					}
					if(!bSidFound) 
						sid = g_iSmarserverSid;
					if(image !== "") 
						addImageForContext(sid, "CAMPUS",null, image, width, height,location, above);
				}
				else if(x1 === "contextoffsets") {
					try {
						items = customFields[x].split(",");
						for(i=0; i < items; i++)
						{
							if(items[i] !== "") {
								items1 = items[i].split("=");
								if(items1.length === 2) {
									items1[0] = items1[0].trim().toLowerCase();
									items1[1] = items1[1].trim();
									if(items1[0] === "offsetx") {
										if(items[1].indexOf("." === -1)) {
											iTemp = Number(items[1])
											if(!isNaN(iTemp))
												g_iContextTableX = iTemp; 
										}
									}
									else if(items1[0] === "offsety") {
										if(items[1].indexOf("." === -1)) {
											iTemp = Number(items[1])
											if(!isNaN(iTemp))
												g_iContextTableY = iTemp; 
										}
									}
								}
							}

						}
					}
					catch {}
				}
				else if((x1 === "contexts")) {
					items = customFields[x].split(",");
					for(i=0; i < items.length; i++)
					{
						if(items[i] !== "") {
							items1 = items[i].split("=");
							if(items1.length === 2) {
								items1[0] = items1[0].trim().toLowerCase();
								items1[1] = items1[1].trim();
								
								
								if(items1[0] === "contextdisplaytype") {
									if(items1[1].indexOf(";") !== -1) {
										items2 = items1[1].split(";");
										if(items2.length === 2) {
											items2[0] = items2[0].trim();
											if(!isNaN(items2[0])) {
												items2[0] = Number(items2[0]);
												g_iContextDisplayType[0] = items2[0];
											}
											items2[1] = items2[1].trim();
											if(!isNaN(items2[1])) {
												items2[1] = Number(items2[1]);
												g_iContextDisplayType[1] = items2[1];
											}
										}
										else if(items2[0] !== "") {
											g_iContextDisplayType[0] = 0;
											g_iContextDisplayType[1] = 0;
										}
									}
									else {
										if(!isNaN(items1[1])) {
											items1[1] = Number(items1[1]);
											g_iContextDisplayType[0] = items1[1];
											g_iContextDisplayType[1] = items1[1];
										}
									}
								}
								else if(items1[0] === "deviceLink") {
									if(itemss1[1] === "0")
										g_bContextDatapointDeviceLink = 0;
									else 
										g_bContextDatapointDeviceLink = 1;
								}
							}
						}
					}
				} 
				else if((x1 === "settings") || (x1 === "settingss")) {
					items = customFields[x].split(",");
					for(i=0; i < items.length; i++)
					{
						if(items[i] !== "") {
							items1 = items[i].split("=");
							if(items1.length === 2) {
								items1[0] = items1[0].trim().toLowerCase();
								items1[1] = items1[1].trim();
								
								
								if(items1[0] === "showdplabel") {
									g_iShowContextDpLabels = items1[1];
								}
							}
						}
					}
				} 
				else if(x1 === "layout") {
					items = customFields[x].split(",");
					for(i=0; i < items.length; i++)
					{
						if(items[i] !== "") {
							items1 = items[i].split("=");
							if(items1.length === 2) {
								items1[0] = items1[0].trim().toLowerCase();
								items1[1] = items1[1].trim();
								if((items1[1] !== "") && (items1[1] !== "")) {
									sTemp = items1[1].toLowerCase();
									if(items1[0] === "elementborderstyle") {
										element = document.querySelector(':root');
										if(element !== null) {
											element.style.setProperty('--group-borderStyle', sTemp);
										}
									}
									else if(items1[0] === "elementborderradius") {
										element = document.querySelector(':root');
										if(element !== null) {
											element.style.setProperty('--group-borderRadius', sTemp);
										}
									}
									else if(items1[0] === "elementbordercolor") {
										element = document.querySelector(':root');
										if(element !== null) {
											element.style.setProperty('--group-borderColor', sTemp);
										}
									}
								}
							}
						}
					}
				} 
				else if (x1.startsWith("context_")) {
					//used for site dashboard. Does not require any context to be defined
					// tagvalue: context_building.dp0: pulseGen-1/device/0/nvoLuxLevel, label=nvoLuxLevel, context=Campus/Building, dashboard=140;130, dashboardimageonly=true;
					try {
						iPtr = x1.indexOf(".")
						if((iPtr !== -1) && ((iPtr + 1) < x1.length)) {
							sTemp2 =x1.substr(iPtr + 1);
							if(sTemp2.startsWith("dp")) {
								obj = {};
								obj.name = x1 + " ";
								obj.parameters = customFields[x];
								obj.type = "context";
								dpList1.unshift(obj);

							}
							else if(sTemp2.startsWith("image")) {
								names = [];
								type = "";
								image = "";
								width = "";
								height = "";
								items = customFields[x].split(",");
								name = "";
								
								for(i=0; i < items.length; i++)
								{
									if(items[i] !== "") {
										items1 = items[i].split("=");
										if(items1.length === 2) {
											items1[0] = items1[0].trim().toLowerCase();
											items1[1] = items1[1].trim();
											
											
											if(items1[0] === "image") {
												image = items1[1];
											}
											else if(items1[0] === "width") {
												if(items1[1] !== "null")
													width = items1[1];
											}
											else if(items1[0] === "height") {
												if(items1[1] !== "null")
													height = items1[1];
											}
											else if(items1[0] === "context") {
												if(items1[1] !== "null")
													name = items1[1];
											}
										}
									}
								}
								if((name != "") && (image !== "")) { //if((name != "") && (type !== "") && (image !== "")) {
									// determine if device type already created
									//for(i=0; i < names.length; i ++)
									//{
										z = -1;
										for(k=0; k < g_campusTags.contextList.length; k++)
										{
											if(g_campusTags.contextList[k].contextName.toLowerCase() === name.toLowerCase()) {
												z = k;
												break;
											}
										}
										if(z === -1) {
											obj = {};
											obj.name = "";
											obj.contextName = name;
											obj.type = type;
											obj.image = "";
											obj.width = "";
											obj.height = "";
											obj.dpList = [];
											obj.icons = null;
											g_campusTags.contextList.push(obj);
											z = g_campusTags.contextList.length - 1;
										}
										if(z !== -1) {
											g_campusTags.contextList[z].image = image;
											g_campusTags.contextList[z].width = width;
											g_campusTags.contextList[z].height = height;
										}
									//}
								}
							}
							
						}
					}
					catch {}
				}
				else if (x1.startsWith("dashboard_")) {
					//used for site dashboard. Does not require any context to be defined
					try {
						iPtr = x1.indexOf(".")
						if((iPtr !== -1) && ((iPtr + 1) < x1.length)) {
							sTemp2 =x1.substr(iPtr + 1);
							if(sTemp2.startsWith("dp")) {
								obj = {};
								obj.name = x1 + " ";
								obj.parameters = customFields[x];
								obj.type = "dashboard";
								dpList1.unshift(obj);

							}
							else if(sTemp2.startsWith("layout")) {
								// .layout: layout=cre, table=c2;r3;e2, ewidth=300, eheight=200
								width = "";
								height = "";
								layout = "";
								ltable = null;
								sTemp1 = "";
								bAtLeastOneItem = false;
								items = customFields[x].split(",");
								for(i=0; i < items.length; i++)
								{
									if(items[i] !== "") {
										items1 = items[i].split("=");
										if(items1.length === 2) {
											items1[0] = items1[0].trim().toLowerCase();
											items1[1] = items1[1].trim();
											
											
											if(items1[0] === "layout") {
												layout = items1[1];
												if((layout === "rc") || (layout === "cre")) {
													bAtLeastOneItem = true;
												}
												else
													layout = "";
											}
											else if(items1[0] === "ewidth") {
												if(items1[1] !== "null") {
													width = items1[1];
													if(isNaN(width))
														width = "";
													else {
														width = Number(width);
														bAtLeastOneItem = true;
													}
												}
											}
											else if(items1[0] === "eheight") {
												if(items1[1] !== "null") {
													height = items1[1];
													if(isNaN(height))
														height = "";
													else {
														height = Number(height);
														bAtLeastOneItem = true;
													}
												}
											}
											else if(items1[0] === "table") {
													sTemp1 = items1[1];
											}
										}
									}
								}
								if(sTemp1 !== "") {
									iTemp = 0;
									
									ltable = {};
									ltable.enabled = true;
									ltable.c = -1;
									ltable.r = -1;
									ltable.e = -1;
									ltable.x = -1;
									ltable.y = -1;
									ltable.showPriorities = false;
									ltable.readonly = false;
									try {
										if(sTemp1 === "none") {
											ltable.enabled = false;
											bAtLeastOneItem = true;
										}
										else {
											items = sTemp1.split(";");
											for(i=0; i < items.length; i++)
											{
												if(items[i] !== "") {
													if(items[i].length > 1) {
														if(items[i] === "readonly") {
															ltable.readonly = true;
														}
														if(items[i] === "showpriorities") {
															ltable.showPriorities = true;
														}
														else if(items[i].charAt(0) === "c") {
															sTemp2 = items[i].substring(1);
															if(!isNaN(sTemp2)) {
																ltable.c = Number(sTemp2);
															}
														}
														else if(items[i].charAt(0) === "r") {
															sTemp2 = items[i].substring(1);
															if(!isNaN(sTemp2)) {
																ltable.r = Number(sTemp2);
															}
															else if(sTemp2 === "b")
																ltable.r = 1000; //means last one
														}
														else if(items[i].charAt(0) === "e") {
															sTemp2 = items[i].substring(1);
															if(!isNaN(sTemp2)) {
																ltable.e = Number(sTemp2);
															}
														}
														else if(items[i].charAt(0) === "x") {
															sTemp2 = items[i].substring(1);
															if(!isNaN(sTemp2)) {
																ltable.x = Number(sTemp2);
															}
														}
														else if(items[i].charAt(0) === "y") {
															sTemp2 = items[i].substring(1);
															if(!isNaN(sTemp2)) {
																ltable.y = Number(sTemp2);
															}
														}
													}
												}
											}
											if((ltable.c !== -1) || (ltable.r !== -1) || (ltable.e !== -1) || ((ltable.x !== -1) && (ltable.y !== -1))
												|| ltable.readonly || ltable.showPriorities) {
												bAtLeastOneItem = true;
											}
											else 
												ltable = null;
										}
									}
									catch {
										ltable = null;
									}
								}
								if(bAtLeastOneItem) {

									if(g_campusTags.dashboard.length === 0){
										obj = {};
										obj.name = names[i];
										obj.type = type;
										obj.image = "";
										obj.width = "";
										obj.height = "";
										obj.dpList = [];
										obj.colorOn = g_sDashboardLedOffColor;
										obj.colorOff = g_sDashboardLedOffColor;
										obj.colorBorder = g_sDashboardLedBorderColor;
										obj.layout = null;
										obj.imageLayout = null;
										obj.icons = null;
										g_campusTags.dashboard.push(JSON.parse(JSON.stringify(obj)));
										z = g_campusTags.deviceTypesList.length - 1;
									}
									z = g_campusTags.dashboard.length - 1;
									if(z !== -1) {
										obj = {};
										obj.layout = layout;
										obj.table = ltable;
										obj.eWidth = width;
										obj.eHeight = height;
										g_campusTags.dashboard[z].layout = obj;
									}
								}
							}
							else if(sTemp2.startsWith("image")) {
								names = [];
								type = "";
								image = "";
								width = "";
								height = "";
								x1 = "";
								y1 = "";
								sTemp1 = "";
								bAtLeastOneItem = false;
								items = customFields[x].split(",");
								for(i=0; i < items.length; i++)
								{
									if(items[i] !== "") {
										items1 = items[i].split("=");
										if(items1.length === 2) {
											items1[0] = items1[0].trim().toLowerCase();
											items1[1] = items1[1].trim();
											
											
											if(items1[0] === "image") {
												image = items1[1];
											}
											else if(items1[0] === "width") {
												if(items1[1] !== "null")
													width = items1[1];
											}
											else if(items1[0] === "height") {
												if(items1[1] !== "null")
													height = items1[1];
											}
											else if(items1[0] === "x") {
												if(items1[1] !== "null")
													x1 = items1[1];
											}
											else if(items1[0] === "y") {
												if(items1[1] !== "null")
													y1 = items1[1];
											}
											else if(items1[0] === "layout") {
												sTemp1 = items1[1];
											}
										}
									}
				
								}
								if(sTemp1 !== "") {
									iTemp = 0;
									items = sTemp1.split(";");
									ltable = {};
									ltable.c = -1;
									ltable.r = -1;
									ltable.e = -1;
									ltable.x = -1;
									ltable.y = -1;
									try {
										for(i=0; i < items.length; i++)
										{
											if(items[i] !== "") {
												if(items[i].length > 1) {
													if(items[i].charAt(0) === "c") {
														sTemp2 = items[i].substring(1);
														if(!isNaN(sTemp2)) {
															ltable.c = Number(sTemp2);
														}
													}
													else if(items[i].charAt(0) === "r") {
														sTemp2 = items[i].substring(1);
														if(!isNaN(sTemp2)) {
															ltable.r = Number(sTemp2);
														}
														else if(sTemp2 === "b")
															ltable.r = 1000; //means last one
													}
													else if(items[i].charAt(0) === "e") {
														sTemp2 = items[i].substring(1);
														if(!isNaN(sTemp2)) {
															ltable.e = Number(sTemp2);
														}
													}
													else if(items[i].charAt(0) === "x") {
														sTemp2 = items[i].substring(1);
														if(!isNaN(sTemp2)) {
															ltable.x = Number(sTemp2);
														}
													}
													else if(items[i].charAt(0) === "y") {
														sTemp2 = items[i].substring(1);
														if(!isNaN(sTemp2)) {
															ltable.y = Number(sTemp2);
														}
													}
												}
											}
										}
										if((ltable.c !== -1) || (ltable.r !== -1) || (ltable.e !== -1) || ((ltable.x !== -1) && (ltable.y !== -1))) {
											bAtLeastOneItem = true;
										}
										else 
											ltable = null;
									}
									catch {
										ltable = null;
									}
								}
								if(g_campusTags.dashboard.length === 0){
									obj = {};
										obj.name = names[i];
										obj.type = type;
										obj.image = "";
										obj.width = "";
										obj.height = "";
										obj.x = "";
										obj.y = "";
										obj.dpList = [];
										obj.colorOn = g_sDashboardLedOffColor;
										obj.colorOff = g_sDashboardLedOffColor;
										obj.colorBorder = g_sDashboardLedBorderColor;
										obj.layout = null;
										obj.imageLayout = null;
										obj.icons = null;
										g_campusTags.dashboard.push(JSON.parse(JSON.stringify(obj)));
										z = g_campusTags.deviceTypesList.length - 1;
								}
								z = g_campusTags.dashboard.length - 1;
								if(z !== -1) {
									g_campusTags.dashboard[z].image = image;
									g_campusTags.dashboard[z].width = width;
									g_campusTags.dashboard[z].height = height;
									g_campusTags.dashboard[z].x = x1;
									g_campusTags.dashboard[z].y = y1;
									if(bAtLeastOneItem)
										g_campusTags.dashboard[z].imageLayout = ltable;
								}
							}
							else if(sTemp2.startsWith("icon")) {
								// used to show a graphic on top of an image. For example, show a FT 6050 EVB on top of a floorplan
								names = "";
								type = "";
								image = "";
								width = "";
								height = "";
								x1 = "";
								y1 = "";
								sTemp1 = "";
								bAtLeastOneItem = false;
								items = customFields[x].split(",");
								for(i=0; i < items.length; i++)
								{
									if(items[i] !== "") {
										items1 = items[i].split("=");
										if(items1.length === 2) {
											items1[0] = items1[0].trim().toLowerCase();
											items1[1] = items1[1].trim();
											
											
											if(items1[0] === "image") {
												image = items1[1];
											}
											else if(items1[0] === "width") {
												if(items1[1] !== "null")
													width = items1[1];
											}
											else if(items1[0] === "height") {
												if(items1[1] !== "null")
													height = items1[1];
											}
											else if(items1[0] === "x") {
												if(items1[1] !== "null")
													x1 = items1[1];
											}
											else if(items1[0] === "y") {
												if(items1[1] !== "null")
													y1 = items1[1];
											}
											else if(items1[0] === "device") {
												names = items1[1];
											}
										}
									}
				
								}
								if((image !== "") && (x1 !== "") && (y1 !== "")) {
									if(g_campusTags.dashboard.length === 0){
										obj = {};
											obj.name = [];
											obj.type = type;
											obj.image = "";
											obj.width = "";
											obj.height = "";
											obj.x = "";
											obj.y = "";
											obj.dpList = [];
											obj.colorOn = g_sDashboardLedOffColor;
											obj.colorOff = g_sDashboardLedOffColor;
											obj.colorBorder = g_sDashboardLedBorderColor;
											obj.layout = null;
											obj.imageLayout = null;
											obj.icons = null;
											g_campusTags.dashboard.push(JSON.parse(JSON.stringify(obj)));
											z = g_campusTags.deviceTypesList.length - 1;
									}
									z = g_campusTags.dashboard.length - 1;
									if(z !== -1) {
										if(g_campusTags.dashboard[z].icons === null)
											g_campusTags.dashboard[z].icons = [];
										obj = {};
										obj.image = image;
										obj.x = x1;
										obj.y = y1;
										obj.deviceName = names;
										if(width !== "")
											obj.width = width;
										else 
											obj.width = null;
										if(height !== "")
											obj.height = height;
										else 
											obj.height= null;	
										
										g_campusTags.dashboard[z].icons.push(JSON.parse(JSON.stringify(obj)));
									}
								}
							}
							else if(sTemp2.startsWith("colors")) {
								names = [];
								type = "";
								image = "";
								width = "";
								height = "";
								items = customFields[x].split(",");
								for(i=0; i < items.length; i++)
								{
									if(items[i] !== "") {
										items1 = items[i].split("=");
										if(items1.length === 2) {
											items1[0] = items1[0].trim().toLowerCase();
											items1[1] = items1[1].trim();
											
											
											if(items1[0] === "coloron") {
												image = items1[1];
											}
											else if(items1[0] === "coloroff") {
												if(items1[1] !== "null")
													width = items1[1];
											}
											else if(items1[0] === "colorborder") {
												if(items1[1] !== "null")
													height = items1[1];
											}
										}
									}
				
								}
								if(g_campusTags.dashboard.length === 0){
									obj = {};
										obj.name = names[i];
										obj.type = type;
										obj.image = "";
										obj.width = "";
										obj.height = "";
										obj.dpList = [];
										obj.colorOn = g_sDashboardLedOffColor;
										obj.colorOff = g_sDashboardLedOffColor;
										obj.colorBorder = g_sDashboardLedBorderColor;
										obj.layout = null;
										obj.imageLayout = null;
										obj.icons = null;
										g_campusTags.dashboard.push(JSON.parse(JSON.stringify(obj)));
										z = g_campusTags.deviceTypesList.length - 1;
								}
								z = g_campusTags.dashboard.length - 1;
								if(z !== -1) {
									g_campusTags.dashboard[z].colorOn = image;
									g_campusTags.dashboard[z].colorOff = width;
									g_campusTags.dashboard[z].colorBorder = height;
								}
							}
						}
					}
					catch {}
				} //else if (x1.startsWith("dashboard_"))
				else if (x1.startsWith("devicetype_")) {
					
					// devicetype_pulsegen.dp1: (9FFFFF0501840460)/device/0/nviLamp1, Lamp1, displaytype=s4, context=floor;room
					// devicetype_pulsegen.image:  devicetype=(9FFFFF0501840460),url=images/user/ft6050_device.jpg,width=null,height=null
					
					try {
						iPtr = x1.indexOf(".")
						if((iPtr !== -1) && ((iPtr + 1) < x1.length)) {
							sTemp2 =x1.substr(iPtr + 1);
							if(sTemp2.startsWith("dp")) {
								obj = {};
								obj.name = x1 + " ";
								obj.parameters = customFields[x];
								obj.type = "devicetype";
								dpList1.unshift(obj);

							}
							else if(sTemp2.startsWith("layout")) {
								// .layout: layout=cre, table=c2;r3;e2, ewidth=300, eheight=200
								width = "";
								height = "";
								layout = "";
								ltable = null;
								sTemp1 = "";
								bAtLeastOneItem = false;
								items = customFields[x].split(",");
								for(i=0; i < items.length; i++)
								{
									if(items[i] !== "") {
										items1 = items[i].split("=");
										if(items1.length === 2) {
											items1[0] = items1[0].trim().toLowerCase();
											items1[1] = items1[1].trim();
											
											
											if(items1[0] === "layout") {
												layout = items1[1];
												if((layout === "rc") || (layout === "cre")) {
													bAtLeastOneItem = true;
												}
												else
													layout = "";
											}
											else if(items1[0] === "ewidth") {
												if(items1[1] !== "null") {
													width = items1[1];
													if(isNaN(width))
														width = "";
													else {
														width = Number(width);
														bAtLeastOneItem = true;
													}
												}
											}
											else if(items1[0] === "eheight") {
												if(items1[1] !== "null") {
													height = items1[1];
													if(isNaN(height))
														height = "";
													else {
														height = Number(height);
														bAtLeastOneItem = true;
													}
												}
											}
											else if(items1[0] === "table") {
													sTemp1 = items1[1];
											}
										}
									}
								}
								if(sTemp1 !== "") {
									iTemp = 0;
									items = sTemp1.split(";");
									ltable = {};
									ltable.c = -1;
									ltable.r = -1;
									ltable.e = -1;
									ltable.x = -1;
									ltable.y = -1;
									try {
										for(i=0; i < items.length; i++)
										{
											if(items[i] !== "") {
												if(items[i].length > 1) {
													if(items[i].charAt(0) === "c") {
														sTemp2 = items[i].substring(1);
														if(!isNaN(sTemp2)) {
															ltable.c = Number(sTemp2);
														}
													}
													else if(items[i].charAt(0) === "r") {
														sTemp2 = items[i].substring(1);
														if(!isNaN(sTemp2)) {
															ltable.r = Number(sTemp2);
														}
														else if(sTemp2 === "b")
															ltable.r = 1000; //means last one
													}
													else if(items[i].charAt(0) === "e") {
														sTemp2 = items[i].substring(1);
														if(!isNaN(sTemp2)) {
															ltable.e = Number(sTemp2);
														}
													}
													else if(items[i].charAt(0) === "x") {
														sTemp2 = items[i].substring(1);
														if(!isNaN(sTemp2)) {
															ltable.x = Number(sTemp2);
														}
													}
													else if(items[i].charAt(0) === "y") {
														sTemp2 = items[i].substring(1);
														if(!isNaN(sTemp2)) {
															ltable.y = Number(sTemp2);
														}
													}
												}
											}
										}
										if((ltable.c !== -1) || (ltable.r !== -1) || (ltable.e !== -1) || ((ltable.x !== -1) && (ltable.y !== -1))) {
											bAtLeastOneItem = true;
										}
										else 
											ltable = null;
									}
									catch {
										ltable = null;
									}
								}
								if(bAtLeastOneItem) {

									for(i=0; i < names.length; i ++)
									{
										z = -1;
										for(k=0; k < g_campusTags.deviceTypesList.length; k++)
										{
											if((g_campusTags.deviceTypesList[k].type === type) && (g_campusTags.deviceTypesList[k].name === names[j])) {
												z = k;
												break;
											}
										}
										if(z === -1) {
											obj = {};
											obj.name = names[i];
											obj.type = type;
											obj.image = "";
											obj.width = "";
											obj.height = "";
											obj.dpList = [];
											obj.layout = null;
											g_campusTags.deviceTypesList.push(obj);
											z = g_campusTags.deviceTypesList.length - 1;
										}
										if(z !== -1) {
											obj = {};
											obj.layout = layout;
											obj.table = JSON.parse(JSON.stringify(ltable));
											obj.eWidth = width;
											obj.eHeight = height;
											g_campusTags.deviceTypesList[z].layout = obj;
										}
									}
								}
							}
							else if(sTemp2.startsWith("image")) {
								names = [];
								type = "";
								image = "";
								width = "";
								height = "";
								items = customFields[x].split(",");
								for(i=0; i < items.length; i++)
								{
									if(items[i] !== "") {
										items1 = items[i].split("=");
										if(items1.length === 2) {
											items1[0] = items1[0].trim().toLowerCase();
											items1[1] = items1[1].trim();
											
											
											if(items1[0] === "devicetype") {
												type = "";
												name = "";
												if((items1[1].charAt(0) !== "(") && (items[1].charAt(0) !== "[")) {
													name = items1[1].toLowerCase();
													type = "devicename";
												}
												else if(items1[1].length > 2) {
													if((items1[1].charAt(0) === "[") && (items1[1].charAt(items1[1].length - 1) === "]")) {
														name = items1[1].substr(1,items1[1].length - 2).toLowerCase();
														type = "devicetype";
													}
													else if((items1[1].charAt(0) === "(") && (items1[1].charAt(items1[1].length - 1) === ")")) {
														name = items1[1].substr(1,items1[1].length - 2).toLowerCase();
														type = "programid";
													}
												}
												if((name !== "") && (type !== "")) {
													names = [];
													if(name.indexOf(";") !== -1) {
														names = name.split(";");
													}
													else
														names.push(name);
												}
											}
											else if(items1[0] === "image") {
												image = items1[1];
											}
											else if(items1[0] === "width") {
												if(items1[1] !== "null")
													width = items1[1];
											}
											else if(items1[0] === "height") {
												if(items1[1] !== "null")
													height = items1[1];
											}
										}
									}
				
								}
								if((names.length > 0) && (type !== "") && (image !== "")) {
								// determine if device type already created
									for(i=0; i < names.length; i ++)
									{
										z = -1;
										for(k=0; k < g_campusTags.deviceTypesList.length; k++)
										{
											if((g_campusTags.deviceTypesList[k].type === type) && (g_campusTags.deviceTypesList[k].name === names[j])) {
												z = k;
												break;
											}
										}
										if(z === -1) {
											obj = {};
											obj.name = names[i];
											obj.type = type;
											obj.image = "";
											obj.width = "";
											obj.height = "";
											obj.dpList = [];
											obj.layout = null;
											g_campusTags.deviceTypesList.push(obj);
											z = g_campusTags.deviceTypesList.length - 1;
										}
										if(z !== -1) {
											g_campusTags.deviceTypesList[z].image = image;
											g_campusTags.deviceTypesList[z].width = width;
											g_campusTags.deviceTypesList[z].height = height;
										}
									}
								}
							}
						}
						
					}
					catch {}
					
				}
				else if (x1.startsWith("map_")) {
					
					// devicetype_pulsegen.dp1: (9FFFFF0501840460)/device/0/nviLamp1, Lamp1, displaytype=s4, context=floor;room
					// devicetype_pulsegen.image:  devicetype=(9FFFFF0501840460),url=images/user/ft6050_device.jpg,width=null,height=null
					
					try {
						iPtr = x1.indexOf(".")
						if((iPtr !== -1) && ((iPtr + 1) < x1.length)) {
							sTemp2 =x1.substr(iPtr + 1);
							if(sTemp2.startsWith("dp")) {
								obj = {};
								obj.name = x1 + " ";
								obj.parameters = customFields[x];
								obj.type = "map";
								dpList1.unshift(obj);

							}
							else if(sTemp2.startsWith("layout")) {
								// .layout: layout=cre, table=c2;r3;e2, ewidth=300, eheight=200
								items = customFields[x].split(",");
								for(i=0; i < items.length; i++)
								{
									if(items[i] !== "") {
										items1 = items[i].split("=");
										if(items1.length === 2) {
											items1[0] = items1[0].trim().toLowerCase();
											items1[1] = items1[1].trim();
											
											
											if(items1[0] === "name") {
												if(g_campusTags.map.length === 0){
													obj = {};
													obj.bUseMap = true;
													obj.name = "";
													obj.bClickToDevice = false;
													obj.bReadOnly = true;
													obj.iShowContextName = 0; //0=leave blank
													obj.dpList = [];
													g_campusTags.map.push(JSON.parse(JSON.stringify(obj)));
												}
												g_campusTags.map[0].name = items1[1];
											}
											else if(items1[0] === "showcontextnames") {
												if(g_campusTags.map.length === 0){
													obj = {};
													obj.bUseMap = true;
													obj.name = "";
													obj.bClickToDevice = false;
													obj.bReadOnly = true;
													obj.iShowContextName = 0; //0=leave blank
													obj.dpList = [];
													g_campusTags.map.push(JSON.parse(JSON.stringify(obj)));
												}
												g_campusTags.map[0].iShowContextName = items1[1];
											}
											else if(items1[0] === "datapointclick") {
												if(g_campusTags.map.length === 0){
													obj = {};
													obj.bUseMap = true;
													obj.name = "";
													obj.bClickToDevice = false;
													obj.bReadOnly = true;
													obj.iShowContextName = 0; //0=leave blank
													obj.dpList = [];
													g_campusTags.map.push(JSON.parse(JSON.stringify(obj)));
												}
												if(items1[1] === "1")
													g_campusTags.map[0].bClickToDevice = true;
												else if(items1[1] === "0")
													g_campusTags.map[0].bClickToDevice = false;
											}
											else if(items1[0] === "readonly") {
												if(g_campusTags.map.length === 0){
													obj = {};
													obj.bUseMap = true;
													obj.name = "";
													obj.bClickToDevice = false;
													obj.bReadOnly = true;
													obj.iShowContextName = 0; //0=leave blank
													obj.dpList = [];
													g_campusTags.map.push(JSON.parse(JSON.stringify(obj)));
												}
												if(items1[1] === "1")
													g_campusTags.map[0].bReadOnly = true;
												else if(items1[1] === "0")
													g_campusTags.map[0].bReadOnly = false;
											}
										}
									}
								}
							}
							
						}
						
					}
					catch {}
					
				}
				else if (x1.indexOf(".") !== -1) {
					// user  "mike.settings:context=* / * /Entry,singlecontext=true,dashboard=false,readonly=true
					z = -1;
					iPtr = x1.indexOf(".");
					sTemp = "";
					if(iPtr !== -1) {
						sTemp = x1.substr(0, iPtr);
					}
					for(j=0; j < g_campusTags.userList.length; j++)
					{
						if(g_campusTags.userList[j].name === sTemp) {
							z = j;
							break;
						}
					}
					if(z === -1) {
						obj = {};
						obj.name = sTemp;
						obj.context = "";
						obj.showDeviceDashboard = true;
						obj.readonly = false;
						obj.singleContext = false;
						g_campusTags.userList.push(obj);
						z = g_campusTags.userList.length - 1;
					}
					if(z !== -1) {
						sTemp1 = customFields[x];
						items = sTemp1.split(",");
						for(j=0; j < items.length; j++)
						{
							items1 = items[j].split("=");
							if(items1.length === 2) {
								items1[0] = items1[0].trim().toLowerCase();
								items1[1] = items1[1].trim();
								if(items1[0] === "context") {
									g_campusTags.userList[z].context = items1[1];
								}
								else if(items1[0].startsWith("dashboard")) {
									if(items1[1] === "false")
									g_campusTags.userList[z].showDeviceDashboard = false;
								}
								else if(items1[0] === "readonly") {
									if(items1[1] === "true")
										g_campusTags.userList[z].readonly = true;
								}
								else if(items1[0] === "singlecontext") {
									if(items1[1] === "false")
										g_campusTags.userList[z].singleContext = false;
									else if(items1[1] === "true")
										g_campusTags.userList[z].singleContext = true;
								}
								
							}
						}
					}
				}
			}
			catch {}
		}
		 // create device Type list 
		for(i=0; i < dpList1.length; i++) 
		{
			try {
				items = [];
				items = dpList1[i].parameters.split(",");
				if(items.length > 0) {
					name = "";
					names = [];
					type = "";
					value = null;
					
					items1 = items[0].split("/");
					for(j=0; j < items1.length; j++)
					{
						items1[j]= items1[j].trim().toLowerCase();
					}
					name = items1[0];
					if((name.charAt(0) !== "(") && (name.charAt(0) !== "[")) {
						name = items[0];
						iPtr1 = name.indexOf("/")
						if(iPtr1 > 0) {
							name = name.substr(0, iPtr1)
						}
						name = name.toLowerCase();
						type = "devicename";
					}
					else if(name.length > 2) {
						if((name.charAt(0) === "[") && (name.charAt(name.length - 1) === "]")) {
							name = name.substr(1,name.length - 2);
							type = "devicetype";
						}
						else if((name.charAt(0) === "(") && (name.charAt(name.length - 1) === ")")) {
							name = name.substr(1,name.length - 2);
							type = "programid";
						}
					}
					else 
						name = "";

					if((name !== "") && (type !== "")) {
						names = [];
						if(name.indexOf(";") !== -1) {
							names = name.split(";");
						}
						else
							names.push(name);
						obj1 = {}; // dp info, may be used more than once if multiple device names, device types or program IDs used
						for(j=0; j < names.length; j++)
						{	
							 
							if(j === 0) {

							}
							z = -1;
							if((dpList1[i].type === "dashboard") || (dpList1[i].type === "context") || (dpList1[i].type === "map")) {
								if(dpList1[i].type === "dashboard") {
									if(g_campusTags.dashboard.length > 0)
										z = 0;
									if(z === -1) {
										obj = {};
										obj.name = names[j];
										obj.type = type;
										obj.image = "";
										obj.width = "";
										obj.height = "";
										obj.dpList = [];
										obj.colorOn = g_sDashboardLedOffColor;
										obj.colorOff = g_sDashboardLedOffColor;
										obj.colorBorder = g_sDashboardLedBorderColor;
										obj.layout = null;
										g_campusTags.dashboard.push(obj);
										z = g_campusTags.dashboard.length - 1;
									}
								}
								else if (dpList1[i].type === "context"){
									name1 = "";
									name1 = getPlanningContextPath(dpList1[i].parameters);
									for(k=0; k < g_campusTags.contextList.length; k++)
									{
										//if((g_campusTags.contextList[k].type === type) && (g_campusTags.contextList[k].name === names[j]) && (g_campusTags.contextList[k].contextName === name1)){
										if(g_campusTags.contextList[k].contextName.toLowerCase() === name1.toLowerCase()){
											z = k;
											break;
										}
									}
									if(z === -1) {
										obj = {};
										obj.name = names[j];
										obj.contextName = name1;
										obj.type = type;
										obj.image = "";
										obj.width = "";
										obj.height = "";
										obj.dpList = [];
										obj.layout = null;
										g_campusTags.contextList.push(obj);
										z = g_campusTags.contextList.length - 1;
									}
								}
								else if (dpList1[i].type === "map") {
									if(g_campusTags.map.length === 0){
										obj = {};
										obj.bUseMap = true;
										obj.name = "";
										obj.bClickToDevice = false;
										obj.bReadOnly = true;
										obj.iShowContextName = 0; //0=leave blank
										obj.dpList = [];
										g_campusTags.map.push(JSON.parse(JSON.stringify(obj)));
									}
									z = 0;
								}
								if(j==0) {
									obj2 = null;
									obj1 = {};
									obj1.contextOrder = dpList1[i].name;
									obj1.name = "";
									obj1.type = "";
									obj1.label = "";
									obj1.displayType = "none";
									obj1.contextDisplayType = "";
									obj1.contexts = "";
									obj1.field = "";
									obj1.fieldPath = "";
									obj1.blockPath = "";
									obj1.datapointName = "";
									obj1.path = "";
									obj1.readonly = true;
									obj1.color = "";
									obj1.backgroundColor = "";
									obj1.units = "";
									obj1.size = -1;
									obj1.precision = -1;
									obj1.graphicType = 0; // used with l2 and l4 to show different size dots
									obj1.x = ""; // used for Dashboard positioning
									obj1.y = ""; // Used for Dashboard positioning
									obj1.width = "";
									obj1.height = "";
									obj1.padding = "";
									obj1.paddingChar = "";
									obj1.alarmType = "";
									obj1.siteDashboard = false; // used to specify point is used for site dashboard
									obj1.guageObj = null;
									obj1.layout = null; // used specify where UI element is shown, c,r,e,x,y  e.g., c1;r5
									if(dpList1[i].type === "map")
										obj1.scaleDp = "";
									items1 = [];
									items1 = items[0].trim().split("/");
									obj1.deviceTypeStr = "";
									
									if(items1.length > 1)
										obj1.deviceTypeStr = items1[0];
									
									obj1.datapointName = items1[items1.length - 1];
									for(k=1; k < items1.length; k++) {
										if((k > 1) && (k < 4)) {
											obj1.path += "/";
											obj1.name += "/";
											obj1.blockPath += "/";

										}
										items1[k] = items1[k].trim();
										
										if(items1.length > 4) {
											if(obj1.fieldPath !== "")
													obj1.fieldPath += "/";
											obj1.fieldPath += items1[k];
											if(k > 4) {
												if(obj1.field !== "")
													obj1.field += "/";
												obj1.field += items1[k];
											}

										}
										else {
											obj1.path += items1[k];
											obj1.name += items1[k];
											obj1.blockPath += items1[k];
										}
									}
									sFolder = "";  //used to reduce tag value to under 256 characters
									breadonly = false;
									for(k=1; k < items.length; k++) {
										items1 = [];
										iPtr = items[k].indexOf("=")
										if((iPtr !== -1) && ((iPtr + 1) < items[k].length)) {
											items1[0] = items[k].substr(0,iPtr).trim();
											items1[1] = items[k].substr(iPtr + 1).trim();
											try {
												if((items1[0] === "") || (items1[1] === "")) {

												}
												else if(items1[0].startsWith("label")) {
													obj1.label = items1[1];
												}
												else if(items1[0] === "contexts") {
													if(items1[1] !== "")
														obj1.contexts = items1[1].toLowerCase();
												}
												else if(items1[0].startsWith("units")) {
													obj1.units = items1[1];
												}
												else if(items1[0] === "displaytype") {
													if(items1[1].indexOf(";") !== -1) {
														items2 = items1[1].split(";");
														if(items2.length === 2) {
															obj1.contextDisplayType = items2[0].trim();
															obj1.displayType = items2[1].trim();
															
														}
														else if(items2[0] !== "") {
															obj1.contextDisplayType = items2[0].trim();
															obj1.displayType = items2[0].trim();
														}
													}
													else {
														obj1.contextDisplayType = items1[1];
														obj1.displayType = items1[1];
													}
												}
												else if(items1[0] === "readonly") {
													if(items1[1] === "false")
														obj1.readonly = false;
													else {
														obj1.readonly = true;
														breadonly = true;
													}
												}
												else if(items1[0] === "color") {
													if(items1[1].indexOf(";") === -1)
														obj1.color = items1[1];  //usually on color
													else {
														items2 = items1[1].split(";");
														if(items2.length === 2) {
															obj1.color = items2[0]; // on color
															obj1.backgroundColor = items2[1]; //offcolor
														}
													}
												}
												else if(items1[0] === "units") {
													obj1.units = items1[1];
												}
												else if(items1[0] === "precision") {
													if(!isNaN(items1[1])) 
													obj1.precision =  Number(items1[1]);
												}
												else if(items1[0] === "size") {
													// only used on floorplan, not dashboard
													if(!isNaN(items1[1])) 
														obj1.size = Number(items1[1]);
												}
												else if(items1[0] === "fontsize") {
													obj1.fontsize = items1[1]; // used for text input and span
												}
												else if(items1[0] === "width") {
													obj1.width = items1[1]; // used for text input and span
												}
												else if(items1[0] === "height") {
													obj1.height = items1[1]; // used for text input and span
												}
												else  if(items1[0] === "folder") {
													sFolder = items1[1];
												}
												else  if(items1[0] === "scaledp") {
													
													obj1.scaleDisplayType = "ts";
													items2 = items1[1].split(";");
													if(items2.length > 0) {
														items2[0] = items2[0].trim();
														obj1.scaleDp = items2[0];
														if(items2.length === 2) {
															items2[1] = items2[1].trim();
															obj1.scaleDisplayType = items2[1];
														}
													}
												}
												else if(items1[0] === "dashboard") {
													//used to add span, s1,s4 to graphics
													// x,y,displaytype,padding,paddingCar,alarmtype
													try {
														obj2 = {};
														obj2.x = "";
														obj2.y = "";
														obj2.graphicDisplayType = "";
														obj2.padding = "";
														obj2.paddingChar = "";
														obj2.alarmType = "";
														obj2.color = "";
														obj2.graphicType = 0; // used with l2 and l4 to show different size dots
														if(items1[1].indexOf(";") !== -1) {
															items2 = items1[1].split(";");
															for(m=0;m < items2.length; m++)
															{
																item3 = items2[m].trim();
																if(m === 0)
																	obj2.x = item3;
																else if(m === 1)
																	obj2.y = item3;
																else if(m === 2) {
																	if((item3.startsWith("l2") || item3.startsWith("l4")) && item3.endsWith("a")) {
																		obj2.graphicDisplayType = item3.substr(0,2);
																		obj2.graphicType = 1; // small dot
																	}
																	else if((item3.startsWith("l2") || item3.startsWith("l4")) && item3.endsWith("b")) {
																		obj2.graphicDisplayType = item3.substr(0,2);
																		obj2.graphicType = 2; // large dot with border
																	}
																	else if((item3.startsWith("l2") || item3.startsWith("l4")) && item3.endsWith("c")) {
																		obj2.graphicDisplayType = item3.substr(0,2);
																		obj2.graphicType = 3; // large dot with border
																	}
																	else if(item3.startsWith("l2") && item3.endsWith("e")) {
																		obj2.graphicDisplayType = item3.substr(0,2);
																		obj2.graphicType = 5; // small dot (0 = red, 1=green)
																	}
																	else if(item3.startsWith("l2") && item3.endsWith("f")) {
																		obj2.graphicDisplayType = item3.substr(0,2);
																		obj2.graphicType = 6; // small dot (0 = green, 1=red)
																	}
																	else if(item3.startsWith("l2") && item3.endsWith("g")) {
																		obj2.graphicDisplayType = item3.substr(0,2);
																		obj2.graphicType = 7; // large dot with border (0 = red, 1=green)
																	}
																	else if(item3.startsWith("l2") && item3.endsWith("h")) {
																		obj2.graphicDisplayType = item3.substr(0,2);
																		obj2.graphicType = 8; // large dot with border (0 = green, 1=red)
																	}
																	else if(item3.startsWith("l2") && item3.endsWith("i")) {
																		obj2.graphicDisplayType = item3.substr(0,2);
																		obj2.graphicType = 9; // large dot (0 = red, 1=green)
																	}
																	else if(item3.startsWith("l2") && item3.endsWith("j")) {
																		obj2.graphicDisplayType = item3.substr(0,2);
																		obj2.graphicType = 10; // large dot (0 = green, 1=red)
																	}
																	else
																		obj2.graphicDisplayType = item3;
																}
																else if(m === 3){
																	obj2.dashboardColor = item3;
																}
																else if(m === 4){
																	obj2.dashboardBackgroundColor = item3;
																}
																else if(m === 5) {
																	if((obj2.graphicDisplayType === "r") || (obj2.graphicDisplayType === "n"))
																		obj2.padding = item3;
																	else 
																		obj2.dashboardBorderColor = item3;
																}
																else if(m === 6)
																	obj2.paddingChar = item3;
																else if(m === 7)
																	obj2.alarmType = item3;
															}
														}
													}
													catch {
														obj2 = null;
													}
													
												}
												else if(items1[0] === "layout") { // used specify where UI element is shown, c,r,e,x,y  e.g., c1;r5
													// layout=c2;r3;e2;w200;h600, ewidth=300, eheight=200
													try {
														obj3 = {};
														obj3.c = -1;
														obj3.r = -1;
														obj3.e = -1;
														obj3.w = -1;
														obj3.h = -1;
														obj3.x = -1;
														obj3.y= -1;
														items2 = items1[1].split(";");
														for(m=0; m < items2.length; m++)
														{
															if(items2[m] !== "") {
																if(items2[m].length > 1) {
																	if(items2[m].charAt(0) === "c") {
																		sTemp2 = items2[m].substring(1);
																		if(!isNaN(sTemp2)) {
																			obj3.c = Number(sTemp2);
																		}
																	}
																	else if(items2[m].charAt(0) === "r") {
																		sTemp2 = items2[m].substring(1);
																		if(!isNaN(sTemp2)) {
																			obj3.r = Number(sTemp2);
																		}
																		else if(sTemp2 === "b")
																			obj3.r = 1000; //means last one
																	}
																	else if(items2[m].charAt(0) === "e") {
																		sTemp2 = items2[m].substring(1);
																		if(!isNaN(sTemp2)) {
																			obj3.e = Number(sTemp2);
																		}
																	}
																	else if(items2[m].charAt(0) === "w") {
																		sTemp2 = items2[m].substring(1);
																		if(!isNaN(sTemp2)) {
																			obj3.w = Number(sTemp2);
																		}
																	}
																	else if(items2[m].charAt(0) === "h") {
																		sTemp2 = items2[m].substring(1);
																		if(!isNaN(sTemp2)) {
																			obj3.h = Number(sTemp2);
																		}
																	}
																	else if(items2[m].charAt(0) === "x") {
																		sTemp2 = items2[m].substring(1);
																		if(!isNaN(sTemp2)) {
																			obj3.x = Number(sTemp2);
																		}
																	}
																	else if(items2[m].charAt(0) === "y") {
																		sTemp2 = items2[m].substring(1);
																		if(!isNaN(sTemp2)) {
																			obj3.y = Number(sTemp2);
																		}
																	}
																}
															}
														}
														if((obj3.c !== -1) || (obj3.r !== -1) || (obj3.e !== -1)  || (obj3.w !== -1)  || (obj3.h !== -1) || ((obj3.x !== -1)  && (obj3.y !== -1))) {
															obj1.layout = JSON.parse(JSON.stringify(obj3)); // used specify where UI element is shown, c,r,e,x,y  e.g., c1;r5
														}
													}
													catch {}
												}
												else if(items1[0] === "value") {
													value = items1[1];
												}
												else if(items1[0] === "guagemin") {
													// only used on floorplan, not dashboard
													if(obj1.guageObj === null) {
														obj1.guageObj = {};
														obj1.guageObj.type = 0;
														obj1.guageObj.guageMin = null;
														obj1.guageObj.guageMax = null;
														obj1.guageObj.guageColors = [];
													}
													if(!isNaN(items1[1])) 
														obj1.guageObj.guageMin = Number(items1[1]);
												}
												else if(items1[0] === "guagemax") {
													// only used on floorplan, not dashboard
													if(obj1.guageObj === null) {
														obj1.guageObj = {};
														obj1.guageObj.type = 0;
														obj1.guageObj.guageMin = null;
														obj1.guageObj.guageMax = null;
														obj1.guageObj.guageColors = [];
													}
													if(!isNaN(items1[1])) 
														obj1.guageObj.guageMax = Number(items1[1]);
												}
												else if(items1[0] === "guagecolors") {
													// only used on floorplan, not dashboard
													if(obj1.guageObj === null) {
														obj1.guageObj = {};
														obj1.guageObj.type = 0;
														obj1.guageObj.guageMin = null;
														obj1.guageObj.guageMax = null;
														obj1.guageObj.guageColors = [];
													}
													if(items1[1].indexOf(";") !== -1) {
														
														items2 = items1[1].split(";");
													}
													else {
														items2 = [];
														items2[0] = items1[1];
													}
													
													for(m=0;m < items2.length; m++)
													{
														item3 = items2[m].trim();
														items3 = item3.split("(");
														
														if(items3.length === 0) {

														}
														else if(items3.length === 1) {
															obj3 = {};
															obj3.value = null;
															obj3.color = items3[0].trim();
															if(obj3.color !== "")
																obj3.color = obj3.color.toLowerCase();
															obj1.guageObj.guageColors.push(obj3);
														}
														else if (items3.length === 2) {
															
															obj3 = {};
															obj3.value = null;
															obj3.color = items3[0].trim();
															if(obj3.color !== "")
																obj3.color = obj3.color.toLowerCase();
															item4 = items3[1];
															item4 = item4.trim();
															if(item4.charAt(item4.length - 1) === ")") {
																item4 = item4.substr(0, item4.length - 1);
																if(!isNaN(item4)) 
																	obj3.value = Number(item4);
															}
															obj1.guageObj.guageColors.push(obj3);
														}
													}
													
												}
												else if(items1[0] === "field") 
													obj1.field = items1[1];
											}
											catch {}
										}
									} //for(k=1; k < items.length; k++)
									//check if structured
									if(obj1.displayType === "s1") {
										if(!breadonly)
											obj1.readonly = false;
									}
									// checkif guage
									if(obj1.guageObj !== null) {
										if(obj1.displayType === "g1"){
											obj1.displayType = "g"
											obj1.guageObj.type = 1;
										}
										else if(obj1.displayType === "g2"){
											obj1.displayType = "g"
											obj1.guageObj.type = 2;
										}
										else if(obj1.displayType === "gc1"){
											obj1.displayType = "gc"
											obj1.guageObj.type = 1;
										}
										else if(obj1.displayType === "gc2"){
											obj1.displayType = "gc"
											obj1.guageObj.type = 2;
										}
										else if(obj1.displayType === "m1"){
											obj1.displayType = "m"
											obj1.guageObj.type = 1; // red/yellow/green
										}
										else if(obj1.displayType === "m2"){
											obj1.displayType = "m"; // red/yellow/green/yellow/red
											obj1.guageObj.type = 2; 
										}
										// move range to previous color
										for(m=1;m < obj1.guageObj.guageColors.length; m++)
										{
											obj1.guageObj.guageColors[m-1].value = obj1.guageObj.guageColors[m].value;
											obj1.guageObj.guageColors[m].value = null;
										}
									}
									if(value !== null) {
										bContinue2 = false;
										if((obj1.displayType === "i") || (obj1.displayType === "t1")  || (obj1.displayType === "led1")) {
											bContinue2 = true;
											if(obj1.displayType === "t1") {
												//	sFolder
											}
										}
										else if (obj2 !== null) {
											if(typeof obj2.graphicDisplayType !== "undefined") {
												if((obj2.graphicDisplayType === "i") || (obj2.graphicDisplayType === "t1")  || (obj2.graphicDisplayType === "led1"))
													bContinue2 = true;
												if(obj2.graphicDisplayType === "t1") {
													//sFolder
												}
											}
										}
										if(bContinue2) {
											try {
												// convert value to imageswapper value
												obj1.imageSwapper = [];
												items2 = items1[1].split(";");
												y = 1;
												for(m=0;m < items2.length; m++)
												{
													items3 = items2[m].split(":");
													if(items3.length === 2) {
														
														items3[0] = items3[0].trim();
														items3[1] = items3[1].trim();
														
														obj3 = {};
														obj3.value = items3[0];
														obj3.sortValue = 2;
														obj3.test = "=";
														
														iPtr = obj3.value.indexOf(">=");
														if(iPtr !== -1) {
															obj3.sortValue = 3;
															obj3.value = obj3.value.substr(iPtr + 2).trim();
															obj3.test = ">=";
															if(isNaN(obj3.value))
																y = 0;
														}
														else {
															iPtr = obj3.value.indexOf("=>");
															if(iPtr !== -1) {
																obj3.sortValue = 3;
																obj3.value = obj3.value.substr(iPtr + 2).trim();
																obj3.test = ">=";
																if(isNaN(obj3.value))
																	y = 0;
															}
															else {
																iPtr = obj3.value.indexOf("<=");
																if(iPtr !== -1) {
																	obj3.sortValue = 1;
																	obj3.value = obj3.value.substr(iPtr + 2).trim();
																	obj3.test = "<=";
																	if(isNaN(obj3.value))
																		y = 0;
																}
																else {
																	iPtr = obj3.value.indexOf("=<");
																	if(iPtr !== -1) {
																		obj3.sortValue = 1;
																		obj3.value = obj3.value.substr(iPtr + 2).trim();
																		obj3.test = "<=";
																		if(isNaN(obj3.value))
																			y = 0;
																	}
																	else {
																		iPtr = obj3.value.indexOf(">");
																		if(iPtr !== -1) {
																			obj3.sortValue = 4;
																			obj3.value = obj3.value.substr(iPtr + 1).trim();
																			obj3.test = ">";
																			if(isNaN(obj3.value))
																				y = 0;
																		}
																		else {
																			iPtr = obj3.value.indexOf("<");
																			if(iPtr !== -1) {
																				obj3.sortValue = 0;
																				obj3.value = obj3.value.substr(iPtr + 1).trim();
																				obj3.test = "<";
																				if(isNaN(obj3.value))
																				y = 0;
																			}
																			else {
																				iPtr = obj3.value.indexOf("=");
																				if(iPtr !== -1) {
																					obj3.sortValue = 0;
																					obj3.value = obj3.value.substr(iPtr + 1).trim();
																				}
																				if(isNaN(obj3.value))
																					y = 0;
																			}
																		}
																	}
																}
																
															}
														}
														if(sFolder !== "")
															obj3.image = sFolder + items3[1];  //used for both color and image
														else 
															obj3.image = items3[1]; //used for both color and image
														
														obj1.imageSwapper.unshift(obj3);
														
													}
												}
												// sort values
												if(y === 1) {
													
													for(m=0;m < obj1.imageSwapper.length; m++)
													{
														obj1.imageSwapper[m].value = Number(obj1.imageSwapper[m].value);
													}
													if(y === 1) {
														while(bContinue2)
														{
															bContinue2 = false;
															for(m=0;m < obj1.imageSwapper.length - 1; m++)
															{
																if(obj1.imageSwapper[m].value < obj1.imageSwapper[m + 1].value) {
																	y = obj1.imageSwapper[m].value;
																	obj1.imageSwapper[m].value = obj1.imageSwapper[m + 1].value;
																	obj1.imageSwapper[m + 1].value = y;
																	bContinue2 = true;
																}
																else if(obj1.imageSwapper[m].value === obj1.imageSwapper[m + 1].value) {
																	if(obj1.imageSwapper[m].sortValue < obj1.imageSwapper[m + 1].sortValue) {
																		y = obj1.imageSwapper[m].value;
																		obj1.imageSwapper[m].value = obj1.imageSwapper[m + 1].value;
																		obj1.imageSwapper[m + 1].value = y;
																		bContinue2 = true;
																	}
																}
															}
														}
														// remove sortvalue
														for(m=0;m < obj1.imageSwapper.length; m++)
														{
															delete obj1.imageSwapper[m].sortValue;
														}
													}
												}
											}
											catch {}
										}
									}
									if(obj1.label === "") {
										obj1.label = obj1.datapointName;
									}
									if(obj2 !== null) {
										try {
											if((obj2.x !== "") && (obj2.y !== "")) {
												obj2.x = Number(obj2.x);
												obj2.y = Number(obj2.y);
												if(isNaN(obj2.x) || isNaN(obj2.y))
													obj2 = null;
												/*
												else if((obj1.displayType === "r") || (obj1.displayType === "n") || (obj1.displayType === "c"))
													obj1.displayType = "r";
												else if((obj1.displayType === "s2") || (obj1.displayType === "l2"))
													obj1.displayType = "l2";
												else if((obj1.displayType === "s4") || (obj1.displayType === "l4"))
													obj1.displayType = "l4";	
												else */
												else {
													if(obj2.graphicDisplayType === "") {
														obj2.graphicDisplayType = obj1.displayType;
													}
													if(!((obj2.graphicDisplayType === "r") || (obj2.graphicDisplayType === "n") || (obj2.graphicDisplayType === "c")  || (obj2.graphicDisplayType === "cr")
													|| (obj2.graphicDisplayType === "i") || (obj2.graphicDisplayType === "t1") || (obj2.graphicDisplayType === "led1")
													|| (obj2.graphicDisplayType === "s2") || (obj2.graphicDisplayType === "l2") || (obj2.graphicDisplayType === "s3") || (obj2.graphicDisplayType === "l3")
													|| (obj2.graphicDisplayType === "s4") || (obj2.graphicDisplayType === "l4")
													|| (obj2.graphicDisplayType === "lr2") || (obj2.graphicDisplayType === "lr4")
													|| (obj2.graphicDisplayType === "rbt")
													|| (obj2.graphicDisplayType === "pb") ))
													obj2 = null;
												}
												if(obj2 !== null) {
													
													obj1.x = obj2.x;
													obj1.y = obj2.y;
													obj1.padding = obj2.padding;
													obj1.paddingChar = obj2.paddingChar;
													obj1.alarmType = obj2.alarmType;
													obj1.graphicDisplayType = obj2.graphicDisplayType;
													obj1.graphicType = obj2.graphicType;
													/*if((obj2.graphicDisplayType === "l2") || (obj2.graphicDisplayType === "l3") || (obj2.graphicDisplayType === "l4")) {
														if(typeof obj2.color !== "undefined")
															obj1.backgroundColor = obj2.color;
													} */
													if((obj2.graphicDisplayType === "l2") || (obj2.graphicDisplayType === "l3") || (obj2.graphicDisplayType === "l4")  || (obj2.graphicDisplayType === "pb")) {
														if(typeof obj2.dashboardColor !== "undefined")
															obj1.dashboardColor = obj2.dashboardColor;
														if(typeof obj2.dashboardBackgroundColor !== "undefined")
															obj1.dashboardBackgroundColor = obj2.dashboardBackgroundColor;
														if(typeof obj2.dashboardBorderColor !== "undefined")
															obj1.dashboardBorderColor = obj2.dashboardBorderColor;
														if((typeof obj2.graphicType === "undefined") && (obj2.graphicDisplayType !== "pb"))
															obj1.graphicType = 4;
													}
													else { // r and n
														if(typeof obj2.dashboardColor !== "undefined")
															obj1.dashboardColor = obj2.dashboardColor;
														if(typeof obj2.dashboardBackgroundColor !== "undefined")
															obj1.dashboardBackgroundColor = obj2.dashboardBackgroundColor;
													}
												}
											}
										}
										catch {}
									}
								
									if(dpList1[i].type === "dashboard")
										g_campusTags.dashboard[z].dpList.push(JSON.parse(JSON.stringify(obj1)));
									else if (dpList1[i].type === "context")
										g_campusTags.contextList[z].dpList.push(JSON.parse(JSON.stringify(obj1)));
									else if (dpList1[i].type === "map")
										g_campusTags.map[z].dpList.push(JSON.parse(JSON.stringify(obj1)));
								}
							}
							else if(dpList1[i].type === "devicetype") {
								for(k=0; k < g_campusTags.deviceTypesList.length; k++)
								{
									if((g_campusTags.deviceTypesList[k].type === type) && (g_campusTags.deviceTypesList[k].name === names[j])){
										z = k;
										break;
									}
								}
								if(z === -1) {
									obj = {};
									obj.name = names[j];
									obj.type = type;
									obj.image = "";
									obj.width = "";
									obj.height = "";
									obj.dpList = [];
									g_campusTags.deviceTypesList.push(obj);
									z = g_campusTags.deviceTypesList.length - 1;
								}
								if(z !== -1) {
									if(j === 0) {
										obj2 = null;
										obj1 = {};
										obj1.contextOrder = dpList1[i].name;
										obj1.name = "";
										obj1.type = "";
										obj1.label = "";
										obj1.displayType = "";
										obj1.contextDisplayType = "";
										obj1.contexts = "";
										obj1.field = "";
										obj1.fieldPath = "";
										obj1.blockPath = "";
										obj1.datapointName = "";
										obj1.path = "";
										obj1.readonly = true;
										obj1.backgroundColor = "";
										obj1.units = "";
										obj1.size = -1;
										obj1.precision = -1;
										obj1.graphicType = 0; // used with l2 and l4 to show different size dots
										obj1.x = ""; // used for Dashboard positioning
										obj1.y = ""; // Used for Dashboard positioning
										obj1.padding = "";
										obj1.paddingChar = "";
										obj1.alarmType = "";
										obj1.siteDashboard = false; // used to specify point is used for site dashboard
										obj1.guageObj = null;
										items1 = [];
										items1 = items[0].trim().split("/");
										
										obj1.datapointName = items1[items1.length - 1];
										for(k=1; k < items1.length; k++) {
											if((k > 1) && (k < 4)) {
												obj1.path += "/";
												obj1.name += "/";
												obj1.blockPath += "/";

											}
											items1[k] = items1[k].trim();
											
											if(items1.length > 4) {
												if(obj1.fieldPath !== "")
														obj1.fieldPath += "/";
												obj1.fieldPath += items1[k];
												if(k > 4) {
													if(obj1.field !== "")
														obj1.field += "/";
													obj1.field += items1[k];
												}

											}
											else {
												obj1.path += items1[k];
												obj1.name += items1[k];
												obj1.blockPath += items1[k];
											}
										}
										for(k=1; k < items.length; k++) {
											items1 = [];
											items1 = items[k].split("=");
											if(items1.length === 2) {
												items1[0] = items1[0].trim();
												items1[1] = items1[1].trim();
												try {
													if(items1[j].startsWith("label")) {
														obj1.label = items1[1];
													}
													if(items1[0] === "contexts") {
														if(items1[1] !== "")
															obj1.contexts = items1[1].toLowerCase();
													}
													else if(items1[j].startsWith("units")) {
														obj1.units = items1[1];
													}
													else if(items1[0] === "displaytype") {
														if(items1[1].indexOf(";") !== -1) {
															items2 = items1[1].split(";");
															if(items2.length === 2) {
																obj1.contextDisplayType = items2[0].trim();
																obj1.displayType = items2[1].trim();
																
															}
															else if(items2[0] !== "") {
																obj1.contextDisplayType = items2[0].trim();
																obj1.displayType = items2[0].trim();
															}
														}
														else {
															obj1.contextDisplayType = items1[1];
															obj1.displayType = items1[1];
														}
													}
													else if(items1[0] === "readonly") {
														if(items1[1] === "false")
															obj1.readonly = false;
														else 
															obj1.readonly = true;
													}
													else if(items1[0] === "color") {
														if(items1[1].indexOf(";") === -1)
															obj1.color = items1[1];  //usually on color
														else {
															items2 = items1[1].split(";");
															if(items2.length === 2) {
																obj1.color = items2[0]; // on color
																obj1.backgroundColor = items2[1]; //offcolor
															}
													}
													}
													else if(items1[0] === "units") {
														obj1.units = items1[1];
													}
													else if(items1[0] === "precision") {
														if(!isNaN(items1[1])) 
														obj1.precision =  Number(items1[1]);
													}
													else if(items1[0] === "size") {
														// only used on floorplan, not dashboard
														if(!isNaN(items1[1])) 
															obj1.size = Number(items1[1]);
													}
													else if(items1[0] === "dashboard") {
														//used to add span, s1,s4 to graphics
														// x,y,displaytype,padding,paddingCar,alarmtype
														try {
															obj2 = {};
															obj2.x = "";
															obj2.y = "";
															obj2.graphicDisplayType = "";
															obj2.padding = "";
															obj2.paddingChar = "";
															obj2.alarmType = "";
															//obj2.dashboardColor = "";
															obj2.graphicType = 0; // used with l2 and l4 to show different size dots
															if(items1[1].indexOf(";") !== -1) {
																items2 = items1[1].split(";");
																for(m=0;m < items2.length; m++)
																{
																	item3 = items2[m].trim();
																	if(m === 0)
																		obj2.x = item3;
																	else if(m === 1)
																		obj2.y = item3;
																	else if(m === 2) {
																		if((item3.startsWith("l2") || item3.startsWith("l4")) && item3.endsWith("a")) {
																			obj2.graphicDisplayType = item3.substr(0,2);
																			obj2.graphicType = 1; // small dot
																		}
																		else if((item3.startsWith("l2") || item3.startsWith("l4")) && item3.endsWith("b")) {
																			obj2.graphicDisplayType = item3.substr(0,2);
																			obj2.graphicType = 2; // large dot with border
																		}
																		else if((item3.startsWith("l2") || item3.startsWith("l4")) && item3.endsWith("c")) {
																			obj2.graphicDisplayType = item3.substr(0,2);
																			obj2.graphicType = 3; // large dot with border
																		}
																		else if(item3.startsWith("l2") && item3.endsWith("e")) {
																			obj2.graphicDisplayType = item3.substr(0,2);
																			obj2.graphicType = 5; // small dot (0 = red, 1=green)
																		}
																		else if(item3.startsWith("l2") && item3.endsWith("f")) {
																			obj2.graphicDisplayType = item3.substr(0,2);
																			obj2.graphicType = 6; // small dot (0 = green, 1=red)
																		}
																		else if(item3.startsWith("l2") && item3.endsWith("g")) {
																			obj2.graphicDisplayType = item3.substr(0,2);
																			obj2.graphicType = 7; // large dot with border (0 = red, 1=green)
																		}
																		else if(item3.startsWith("l2") && item3.endsWith("h")) {
																			obj2.graphicDisplayType = item3.substr(0,2);
																			obj2.graphicType = 8; // large dot with border (0 = green, 1=red)
																		}
																		else if(item3.startsWith("l2") && item3.endsWith("i")) {
																			obj2.graphicDisplayType = item3.substr(0,2);
																			obj2.graphicType = 9; // large dot (0 = red, 1=green)
																		}
																		else if(item3.startsWith("l2") && item3.endsWith("j")) {
																			obj2.graphicDisplayType = item3.substr(0,2);
																			obj2.graphicType = 10; // large dot (0 = green, 1=red)
																		}
																		else
																				obj2.graphicDisplayType = item3;
																		
																	}
																	else if(m === 3) {
																		if((obj2.graphicDisplayType === "r") || (obj2.graphicDisplayType === "n"))
																			obj2.padding = item3;
																		else
																			obj2.dashboardColor = item3;
																	}
																	else if(m === 4) {
																		if((obj2.graphicDisplayType === "r") || (obj2.graphicDisplayType === "n"))
																			obj2.paddingChar = item3;
																		else
																			obj2.dashboardBackgroundColor = item3;
																	}
																	else if(m === 5) {
																		if((obj2.graphicDisplayType === "r") || (obj2.graphicDisplayType === "n")) 
																			obj2.alarmType = item3;
																		else
																			obj2.dashboardBorderColor = item3;
																	}
																}
															}
														}
														catch {
															obj2 = null;
														}
														
													}
													else if(items1[0] === "temp") {
														//Used with theometer
														// style(c,f,cf),source(c,f),min
														try {
															obj2 = {};
															obj2.style = "";
															obj2.bAddOtherTemp = ""; // if style = c or f, then used to indicate that you want the other temperature shown. c (f) or f(c) 
															obj2.source = "";
															obj2.degMin = null;
															obj2.degMax = null;
															obj2.custom = false;
															
															if(items1[1].indexOf(";") !== -1) {
																items2 = items1[1].split(";");
																for(m=0;m < items2.length; m++)
																{
																	item3 = items2[m].trim();
																	if(m === 0) {
																		obj2.style = item3.toLowerCase();
																		iPtr = obj2.style.indexOf("+");
																		if(iPtr !== -1) {
																			sTemp2 = obj2.style
																			obj2.bAddOtherTemp = true;
																			obj2.style = obj2.style.substr(0, iPtr);
																		}
																	}
																	else if(m === 1)
																		obj2.source = item3.toLowerCase();
																	else if(m === 2) {
																		obj2.degMin = item3;
																		if(!isNaN(item3)) {
																			if(typeof item3 === "string")
																				obj2.degMin = Number(item3);
																		}
																	}
																	else if(m === 3) {
																		obj2.degMax = item3;
																		if(!isNaN(item3)) {
																			if(typeof item3 === "string")
																				obj2.degMax = Number(item3);
																		}
																	}
																}
																if((obj2.degMin !== null) && (obj2.degMax !== null))
																	obj2.custom = true;
																obj1.thermometerObj = JSON.parse(JSON.stringify(obj2));
															}
															
														}
														catch {
															
														}
														obj2 = null;
													}
													else if(items1[0] === "meter") {
														//Used with lightmeter
														// style(c,f,cf),source(c,f),min
														try {
															obj2 = {};
															obj2.min = null;
															obj2.max = null;
															obj2.color = "";
															if(items1[1].indexOf(";") !== -1) {
																items2 = items1[1].split(";");
																for(m=0;m < items2.length; m++)
																{
																	item3 = items2[m].trim();
																	if(m === 0)
																		obj2.min = item3;
																	else if(m === 1)
																		obj2.max = item3;
																	else if(m === 2)
																		obj2.color = item3;
																	
																	
																}
																obj1.thermometerObj = JSON.parse(JSON.stringify(obj2));
															}
														}
														catch {
														}
														obj2 = null;
													}
													else if(items1[0] === "guagemin") {
														// only used on floorplan, not dashboard
														if(obj1.guageObj === null) {
															obj1.guageObj = {};
															obj1.guageObj.type = 0;
															obj1.guageObj.guageMin = null;
															obj1.guageObj.guageMax = null;
															obj1.guageObj.guageColors = [];
														}
														if(!isNaN(items1[1])) 
															obj1.guageObj.guageMin = Number(items1[1]);
													}
													else if(items1[0] === "guagemax") {
														// only used on floorplan, not dashboard
														if(obj1.guageObj === null) {
															obj1.guageObj = {};
															obj1.guageObj.type = 0;
															obj1.guageObj.guageMin = null;
															obj1.guageObj.guageMax = null;
															obj1.guageObj.guageColors = [];
														}
														if(!isNaN(items1[1])) 
															obj1.guageObj.guageMax = Number(items1[1]);
													}
													else if(items1[0] === "guagecolors") {
														// only used on floorplan, not dashboard
														if(obj1.guageObj === null) {
															obj1.guageObj = {};
															obj1.guageObj.type = 0;
															obj1.guageObj.guageMin = null;
															obj1.guageObj.guageMax = null;
															obj1.guageObj.guageColors = [];
														}
														if(items1[1].indexOf(";") !== -1) {
															
															items2 = items1[1].split(";");
														}
														else {
															items2 = [];
															items2[0] = items1[1];
														}	
														for(m=0;m < items2.length; m++)
														{
															item3 = items2[m].trim();
															items3 = item3.split("(");
															
															if(items3.length === 0) {
		
															}
															else if(items3.length === 1) {
																obj3 = {};
																obj3.value = null;
																obj3.color = items3[0].trim();
																if(obj3.color !== "")
																	obj3.color = obj3.color.toLowerCase();
																obj1.guageObj.guageColors.push(obj3);
															}
															else if (items3.length === 2) {
																
																obj3 = {};
																obj3.value = null;
																obj3.color = items3[0].trim();
																if(obj3.color !== "")
																	obj3.color = obj3.color.toLowerCase();
																item4 = items3[1];
																item4 = item4.trim();
																if(item4.charAt(item4.length - 1) === ")") {
																	item4 = item4.substr(0, item4.length - 1);
																	if(!isNaN(item4)) 
																		obj3.value = Number(item4);
																}
																obj1.guageObj.guageColors.push(obj3);
															}
														}
													}
													else if(items1[0] === "field") 
														obj1.field = items1[1];
												}
												catch {}
											}
										}
										// checkif guage
										if(obj1.guageObj !== null) {
											if(obj1.displayType === "g1"){
												obj1.displayType = "g"
												obj1.guageObj.type = 1;
											}
											else if(obj1.displayType === "g2"){
												obj1.displayType = "g"
												obj1.guageObj.type = 2;
											}
											else if(obj1.displayType === "gc1"){
												obj1.displayType = "gc"
												obj1.guageObj.type = 1;
											}
											else if(obj1.displayType === "gc2"){
												obj1.displayType = "gc"
												obj1.guageObj.type = 2;
											}
											else if(obj1.displayType === "m1"){
												obj1.displayType = "m"
												obj1.guageObj.type = 1; // red/yellow/green
											}
											else if(obj1.displayType === "m2"){
												obj1.displayType = "m"; // red/yellow/green/yellow/red
												obj1.guageObj.type = 2; 
											}
											// move range to previous color
											for(m=1;m < obj1.guageObj.guageColors.length; m++)
											{
												obj1.guageObj.guageColors[m-1].value = obj1.guageObj.guageColors[m].value;
												obj1.guageObj.guageColors[m].value = null;
											}

										}
										if(obj1.label === "") {
											obj1.label = obj1.datapointName;
										}
										if(obj2 !== null) {
											try {
												if((obj2.x !== "") && (obj2.y !== "")) {
													obj2.x = Number(obj2.x);
													obj2.y = Number(obj2.y);
													if(isNaN(obj2.x) || isNaN(obj2.y))
														obj2 = null;
													/*
													else if((obj1.displayType === "r") || (obj1.displayType === "n") || (obj1.displayType === "c"))
														obj1.displayType = "r";
													else if((obj1.displayType === "s2") || (obj1.displayType === "l2"))
														obj1.displayType = "l2";
													else if((obj1.displayType === "s4") || (obj1.displayType === "l4"))
														obj1.displayType = "l4";	
													else */
													else {
														if(obj2.graphicDisplayType === "") {
															obj2.graphicDisplayType = obj1.displayType;
														}
														if(!((obj2.graphicDisplayType === "r") || (obj2.graphicDisplayType === "n") || (obj2.graphicDisplayType === "c") || (obj2.graphicDisplayType === "cr")
														|| (obj2.graphicDisplayType === "s2") || (obj2.graphicDisplayType === "l2") || (obj2.graphicDisplayType === "s3") || (obj2.graphicDisplayType === "l3")
														|| (obj2.graphicDisplayType === "s4") || (obj2.graphicDisplayType === "l4")
														|| (obj2.graphicDisplayType === "lr2") || (obj2.graphicDisplayType === "lr4")
														|| (obj2.graphicDisplayType === "rbt")
														|| (obj2.graphicDisplayType === "pb")))
														obj2 = null;
													}
													if(obj2 !== null) {
														
														obj1.x = obj2.x;
														obj1.y = obj2.y;
														obj1.padding = obj2.padding;
														obj1.paddingChar = obj2.paddingChar;
														obj1.alarmType = obj2.alarmType;
														obj1.graphicDisplayType = obj2.graphicDisplayType;
														obj1.graphicType = obj2.graphicType;
														/*if((obj2.graphicDisplayType === "l2") || (obj2.graphicDisplayType === "l3") || (obj2.graphicDisplayType === "l4")) {
															if(typeof obj2.color !== "undefined")
																obj1.backgroundColor = obj2.color;
														} */
														if((obj2.graphicDisplayType === "l2") || (obj2.graphicDisplayType === "l3") || (obj2.graphicDisplayType === "l4")  || (obj2.graphicDisplayType === "pb")) {
															if(typeof obj2.dashboardColor !== "undefined")
																obj1.dashboardColor = obj2.dashboardColor;
															if(typeof obj2.dashboardBackgroundColor !== "undefined")
																obj1.dashboardBackgroundColor = obj2.dashboardBackgroundColor;
															if(typeof obj2.dashboardBorderColor !== "undefined")
																obj1.dashboardBorderColor = obj2.dashboardBorderColor;
														}
														else { // r and n
															if(typeof obj2.dashboardColor !== "undefined")
																obj1.dashboardColor = obj2.dashboardColor;
															if(typeof obj2.dashboardBackgroundColor !== "undefined")
																obj1.dashboardBackgroundColor = obj2.dashboardBackgroundColor;
														}
													}
												}
											}
											catch {}
										}
										
										
									} //if(j === 0) {
									g_campusTags.deviceTypesList[z].dpList.push(JSON.parse(JSON.stringify(obj1)));
								}
							} // else if(dpList1[i].type === "devicetype")
						}
					}
				}
			}
			catch {}
		}
		// sort device type datapoint list
		for(j=0; j < g_campusTags.deviceTypesList.length; j++)
		{
			if(g_campusTags.deviceTypesList[j].dpList.length > 1) {
				bContinue = true;
				while(bContinue)
				{
					bContinue = false;
					if(typeof g_campusTags.deviceTypesList[j].dpList[0].contextOrder !== "undefined") {
						for(i=0; i < (g_campusTags.deviceTypesList[j].dpList.length - 1); i++) 
						{
							if(g_campusTags.deviceTypesList[j].dpList[i].contextOrder > g_campusTags.deviceTypesList[j].dpList[i + 1].contextOrder) {
								obj = {}
								obj = JSON.parse(JSON.stringify(g_campusTags.deviceTypesList[j].dpList[i]));
								g_campusTags.deviceTypesList[j].dpList[i] = JSON.parse(JSON.stringify(g_campusTags.deviceTypesList[j].dpList[i + 1]));
								g_campusTags.deviceTypesList[j].dpList[i + 1] = JSON.parse(JSON.stringify(obj));
								bContinue = true;
							}
						}
					}
				}
			}
		}
		// sort dashboard datapoint list
		for(j=0; j < g_campusTags.dashboard.length; j++)
		{
			if(g_campusTags.dashboard[j].dpList.length > 1) {
				bContinue = true;
				while(bContinue)
				{
					bContinue = false;
					if(typeof g_campusTags.dashboard[j].dpList[0].contextOrder !== "undefined") {
						for(i=0; i < (g_campusTags.dashboard[j].dpList.length - 1); i++) 
						{
							if(g_campusTags.dashboard[j].dpList[i].contextOrder > g_campusTags.dashboard[j].dpList[i + 1].contextOrder) {
								obj = {}
								obj = JSON.parse(JSON.stringify(g_campusTags.dashboard[j].dpList[i]));
								g_campusTags.dashboard[j].dpList[i] = JSON.parse(JSON.stringify(g_campusTags.dashboard[j].dpList[i + 1]));
								g_campusTags.dashboard[j].dpList[i + 1] = JSON.parse(JSON.stringify(obj));
								bContinue = true;
							}
						}
					}
				}
			}
		}
		// sort contextList datapoint list
		for(j=0; j < g_campusTags.contextList.length; j++)
		{
			if(g_campusTags.contextList[j].dpList.length > 1) {
				bContinue = true;
				while(bContinue)
				{
					bContinue = false;
					if(typeof g_campusTags.contextList[j].dpList[0].nameOrder !== "undefined") {
						for(i=0; i < (g_campusTags.contextList[j].dpList.length - 1); i++) 
						{
							if(g_campusTags.contextList[j].dpList[i].nameOrder > g_campusTags.contextList[j].dpList[i + 1].nameOrder) {
								obj = {}
								obj = JSON.parse(JSON.stringify(g_campusTags.contextList[j].dpList[i]));
								g_campusTags.contextList[j].dpList[i] = JSON.parse(JSON.stringify(g_campusTags.contextList[j].dpList[i + 1]));
								g_campusTags.contextList[j].dpList[i + 1] = JSON.parse(JSON.stringify(obj));
								bContinue = true;
							}
						}
					}
				}
			}
		}
		//sort map dashboard datapoint list
		if(g_campusTags.map.length > 0) {
			if(g_campusTags.map[0].dpList.length > 0) {
				bContinue = true;
				while(bContinue)
				{
					bContinue = false;
					if(typeof g_campusTags.map[0].dpList[0].contextOrder !== "undefined") {
						for(i=0; i < (g_campusTags.map[0].dpList.length - 1); i++) 
						{
							if(g_campusTags.map[0].dpList[i].contextOrder > g_campusTags.map[0].dpList[i + 1].contextOrder) {
								obj = {}
								obj = JSON.parse(JSON.stringify(g_campusTags.map[0].dpList[i]));
								g_campusTags.map[0].dpList[i] = JSON.parse(JSON.stringify(g_campusTags.map[0].dpList[i + 1]));
								g_campusTags.map[0].dpList[i + 1] = JSON.parse(JSON.stringify(obj));
								bContinue = true;
							}
						}
					}
				}
			}
		}
	}
	catch {
	}
	try {
		g_bSiteDashboard = false;
		g_bShowAlarms = false;
		g_bAllowedToClearAlarms = false;
		if(g_campusTags.map.length > 0)
			g_bCustomTagsHasMapObjs = true; // don't use user.js settings
		if(g_sDemoMode === "basic") {
			g_iShowTree = NONE;
			g_bShowTree = false;
			g_bSiteDashboard = true;
			g_bSingleWebpage = true;
			g_bDisplayDevicesStatusInFooter = NONE;
			g_iDashboardDatalogRange = 60; // 1 hour
			
			//g_bShowDevicesInTree = NONE; // used to show devices in tree - use user-type CONSTANTs (Must be all CAPS)
			//g_bDisplayDevicesStatusInFooter = NONE; // use user-type CONSTANTs (Must be all CAPS)
			//g_bShowDeviceStatusInTree = NONE // use user-type CONSTANTs (Must be all CAPS)
			//g_bShowDeviceStatusInDashboard = NONE; // use user-type CONSTANTs (Must be all CAPS)
			//g_bShowDeviceStatusInFloorplan = NONE; // use user-type CONSTANTs (Must be all CAPS)
			g_bShowAllDeviceStatus = NONE;
			g_bShowCpu = false;
			g_iCheckIfGettingCpuUpdates = 0;
			g_bCpuUpdateTimeout = false;
			// take out later
			if(checkIfUserTypeSupported(g_iShowAlarms))  
				g_bShowAlarms = true;

			element = document.getElementById("footerStatusTitle");
			if(element !== null)
				element.innerHTML = "";
			element = document.getElementById("footerStatus");
			if(element !== null)
				element.innerHTML = "";
			element = document.getElementById("footerEpsValue");
			if(element !== null)
				element.innerHTML = "";	
			element = document.getElementById("footerCpuValue");
			if(element !== null)
				element.innerHTML = "";
			element = document.getElementById("footerTimeValue");
			if(element !== null)
				element.innerHTML = "";
			element = document.getElementById("footerStatus1");
			if(element !== null)
				element.innerHTML = "";
			element = document.getElementById("footerStatus2");
			if(element !== null)
				element.innerHTML = "";
		}
		else {
			// normal operation
			g_bShowTree = checkIfUserTypeSupported(g_iShowTree);
			// check for user specific features
			if(g_campusTags.dashboard.length > 0)
				g_bSiteDashboard = true;
			if(checkIfUserTypeSupported(g_iShowAlarms))  
				g_bShowAlarms = true;
			if(!checkIfUserTypeSupported(g_iClearAlarms))
				g_bAllowedToClearAlarms = true;
			g_bShowEventCountInCalendarAllow = checkIfUserTypeSupported(g_iShowEventCountInCalendar);
			if(g_bShowEventCountInCalendarAllow) {
				if(g_bShowEventCountInCalendarDefaultShow) 
					g_bShowEventCountInCalendar = true; // can be enabled or disable by calender menu
				else 
					g_bShowEventCountInCalendar = false;
			}
			else 
				g_bShowEventCountInCalendar = false;
			element = document.getElementById("footerStatusTitle");
			if(element !== null)
				element.innerHTML = "Total Devices";
			
			if(g_bShowEps) {
				element = document.getElementById("footerEpsValue");
				if(element !== null) {
					element.innerHTML = "<span style=\"margin-left:20px\">EPS: </span><span id=\"epsValue\" style=\"display:inline-block;width:30px\"></span>";
				}
			}
			if(g_bShowCpu) {
				element = document.getElementById("footerCpuValue");
				if(element !== null) {
					element.innerHTML = "<span style=\"margin-left:15px\">CPU: </span><span id=\"cpuValue\" style=\"display:inline-block;width:30px\"></span>";
				}
			}
			iTemp = -1;
			if((g_bShowTimestamp) && (g_iSmartServerVersion >= 410000)) {
				element = document.getElementById("footerTimeValue");
				if(element !== null) {
					element.innerHTML = "<span style=\"margin-left:15px\">Server Time: </span><span id=\"timeValue\" style=\"display:inline-block;min-width:140px\"></span>";
					if(g_sInitialServerTimestamp !== "") {
						showCmsTimeStampInFooter(g_sInitialServerTimestamp);
					}
					iTemp = 1;
				}
				else if(g_sInitialServerTimestamp === "") {
					g_sInitialServerTimestamp
				}
			}
			g_bIngnoreDisplayingDeviceDeviceStatus = false;
			displayDeviceStatus();
			
			element = document.getElementById("footerStatus1");
			if(element !== null) {
				sTemp = ""; 
				if(g_bShowTimezone) {
					if(iTemp === -1)
						sTemp += "<span style=\"margin-left:15px\">Timezone: ";
					else 
						sTemp += "<span style=\"margin-left:5px\">[";
					sTemp += g_sTimezoneString;
					if(iTemp !== -1)
						sTemp += "]";
					sTemp += "</span>";
				}
				if(g_bShowCmsVersion) {
					sTemp += "<span style=\"margin-left:15px\">CMS: " + g_sSmartServerVersion + "</span>";
				}
				element.innerHTML = sTemp;
			}
		}
		
	}
	catch {}
}
function getPlanningContextIdFromContextPath(path) {
	var result = -1;
	var pathItems, i, index = 0, pathName;
	var list = [];
	var bFound;
	try {
		if(planningList.length > 0) {
			pathItems = path.split("/");
			list = JSON.parse(JSON.stringify(planningList));
			for(i=0; i < pathItems.length; i++)
			{
				bFound = false;
				pathName = pathItems[i].trim().toLowerCase();
				for(j=0; j < list.length; j++)
				{
					if((pathName === "*") || (list[j].name.toLowerCase() === pathName)) {
						if(i === (pathItems.length - 1)) {
							return list[j].id;
						}
						else {
							list = list[j].children;
							bFound = true;
							break;
						}
					}
				}
				if(!bFound)
					break;
			}
		}
	}
	catch {
		result = -1;
	}

	return result;
}
function getPlanningContextObjFromContextPath(path) {
	var result = null;
	var pathItems, i, index = 0, pathName;
	var list = [];
	var bFound;
	try {
		if(planningList.length > 0) {
			pathItems = path.split("/");
			list = JSON.parse(JSON.stringify(planningList));
			for(i=0; i < pathItems.length; i++)
			{
				bFound = false;
				pathName = pathItems[i].trim().toLowerCase();
				for(j=0; j < list.length; j++)
				{
					if((pathName === "*") || (list[j].name.toLowerCase() === pathName)) {
						if(i === (pathItems.length - 1)) {
							return list[j];
						}
						else {
							list = list[j].children;
							bFound = true;
							break;
						}
					}
				}
				if(!bFound)
					break;
			}
		}
	}
	catch {
		
	}

	return result;
}
function getPlanningContextPath(parameters) {
	result = "";
	try {
		var parameterList = parameters.split(",");
		var i, items;
		for(i=0; i < parameterList.length; i++)
		{
			parameterList[i] = parameterList[i].trim();
			items = parameterList[i].split("=");
			if(items.length === 2) {
				items[0] = items[0].trim();
				if(items[0] !== "") {
					items[0] = items[0].toLowerCase();
					if(items[0] === "context") {
						items[1] = items[1].trim();
						if(items[1] !== "") {
							result = items[1].toLowerCase();
						}
						break;
					}
				}
			}
		}
	}
	catch { result = "";}
	return result;
}
function getPlanningTree() { 
	var url = "https://" + location.host + "/iap/context";
	planningList = [];
	contextList = [];
	g_campusTags = {};
	g_bRemoveDuplicateDps = false;
	g_oDemoDashboardDeviceTypeList = null;
	if(g_bDashboardAutoDetectDevices)
		g_bPlanningAutoDetectDevces = true;
	else
		g_bPlanningAutoDetectDevces = false;
	requestGetData(0, url, getPlanningTreeCallback, getPlanningTreeFailCallback); // get Device list

}
function getPlanningTreeCallback(mode, requestUrlString, json){
	var paneTitle = "";
	var i, j, len,iPtr, z = -1, iTemp, sTemp;
	var paneContent = "";
	var bContinue = true;
	var element;
	var json1 = []; 
	bivServerOnline = true;

	g_bIgnoreNewDeviceDetection = false;
	
	element = document.getElementById("main");
	if(element === null) {
		// add html content
		element = document.getElementById("top-Container");
		if(element !== null)
			element.innerHTML = addTopContainerHtml();
	}
			
	


	if((json === null) || (json.length === 0)) {
		bContinue = false;
		if(g_bPlanningAutoDetectDevces) {
			demoCheckForDashboardDevices();
			if(g_oDemoDashboardDeviceTypeList !== null)
				g_bSiteDashboard = true;
		}
	}
	else if(json.length === 1) {
		if(json[0].contextType === "WORLD") {
			if(json[0].children.length === 0) {
				bContinue = false;
				if(g_bPlanningAutoDetectDevces) {
					demoCheckForDashboardDevices();
					if(g_oDemoDashboardDeviceTypeList !== null)
						g_bSiteDashboard = true;
				}
			}
		}
			
	}
	if((!bContinue) && (g_sDemoMode !== "basic")) {
		try {
			
			if(!checkIfUserTypeSupported(g_iShowTreeWhenNoContexts)) {
				g_NoContextsMessage = "Please Contact Site Administrator"; 
			}
			if(Object.keys(g_oGlobalTags).length > 0)
				getPlanningCampusContextTags(g_oGlobalTags);
			
			g_bShowTree = checkIfUserTypeSupported(g_iShowTree);
			g_bShowUnassignedDevicesInTree = checkIfUserTypeSupported(g_iShowUnassignedDevicesInTree);
			g_bIngnoreDisplayingDeviceDeviceStatus = false;
			
			element = document.getElementById("footerStatusTitle");
			if(element !== null)
				element.innerHTML = "Total Devices";
			if(g_bShowEps) {
				element = document.getElementById("footerEpsValue");
				if(element !== null) {
					element.innerHTML = "<span style=\"margin-left:20px\">EPS: </span><span id=\"epsValue\" style=\"display:inline-block;width:30px\"></span>";
				}
			}
			if(g_bShowCpu) {
				element = document.getElementById("footerCpuValue");
				if(element !== null) {
					element.innerHTML = "<span style=\"margin-left:15px\">CPU: </span><span id=\"cpuValue\" style=\"display:inline-block;width:30px\"></span>";
				}
			}
			iTemp = -1;
			if((g_bShowTimestamp) && (g_iSmartServerVersion >= 410000)) {
				element = document.getElementById("footerTimeValue");
				if(element !== null) {
					element.innerHTML = "<span style=\"margin-left:15px\">Server Time: </span><span id=\"timeValue\" style=\"display:inline-block;min-width:140px\"></span>";
					if(g_sInitialServerTimestamp !== "") {
						showCmsTimeStampInFooter(g_sInitialServerTimestamp);
					}
					else {
						try {
							// check if local CMS, and if so get SmartServer mru as starting timestamp
							element = document.getElementById("timeValue");
							if(element !== null) {
								if(typeof g_sInitialServerTimestamp === "string") {
									showCmsTimeStampInFooter(g_sInitialServerTimestamp);
								}
							}
						}
						catch {}
					}
					iTemp = 1;
				}
				else if(g_sInitialServerTimestamp === "") {
					g_sInitialServerTimestamp
				}
			}
			element = document.getElementById("footerStatus1");
			if(element !== null) {
				sTemp = ""; 
				if(g_bShowTimezone) {
					if(iTemp === -1)
						sTemp += "<span style=\"margin-left:15px\">Timezone: ";
					else 
						sTemp += "<span style=\"margin-left:5px\">[";
					sTemp += g_sTimezoneString;
					if(iTemp !== -1)
						sTemp += "]";
					sTemp += "</span>";
				}
				if(g_bShowCmsVersion) {
					sTemp += "<span style=\"margin-left:15px\">CMS: " + g_sSmartServerVersion + "</span>";
				}
				element.innerHTML = sTemp;
			}
			displayDeviceStatus();
			
		}
		catch {}
		
		if(g_bInitialization) {
			g_bInitialization = false;
			if(deviceListAll.length === 0) {
				document.getElementById("gettingInfoId").innerHTML = "No data avaiable";
				return;
			}
			else if(mode === 0)
				planningList = [];
			
			getplanningTreeShowTree(0);
			if(g_bPreGetDatapointTypes) {
				g_bPreGetDatapointTypes = false;
				setTimeout(function() {showDashboardUiGetAllSnvtType(35, {});}, 500);
			}
			//showDevices(); 123
		}
		else {
			g_bInitialization = false;
			if(deviceListAll.length === 0) {
				document.getElementById("gettingInfoId").innerHTML = "No data avaiable";
				return;
			}
			else if(mode === 0) 
				planningList = [];
			
			getplanningTreeShowTree(0);
			
		}
		return;
	}
	g_bShowDeviceDashboard = true;
	try {
		planningList = json;
// check if there are any campus contexts
		for(i=0; i < json.length; i++)
		{ // 4.4+
			if(json[i].contextType === "WORLD") {
				//look for region, campus or building -- need to add support for multiple regions and campuses
				for(j=0; j < json[i].children.length; j++)
				{
					if(json[i].children[j].contextType === "REGION") {
						z = j;
						json1 = JSON.parse(JSON.stringify(json[i].children));
						break;
					}
				}
				if(z !== -1) {
					z = -1;
					for(j=0; j < json1[i].children.length; j++)
					{
						if(json1[i].children[j].contextType === "CAMPUS") {
							z = j;
							json1 = JSON.parse(JSON.stringify(json1[i].children));
							break;
						}
					}
				}
				if(z === -1) {
					for(j=0; j < json[i].children.length; j++)
					{
						if(json[i].children[j].contextType === "CAMPUS") {
							z = j;
							json1 = JSON.parse(JSON.stringify(json[i].children));
							break;
						}
					}
				}
				if(z === -1) {
					for(j=0; j < json.length; j++)
					{
						
						if(json[i].contextType === "BUILDING") {
							z = j;
							json1 = JSON.parse(JSON.stringify(json[i].children));
							break;
						}
					}
				}
				break;
			}
		}
		if(z === -1) {
		// check if there are any campus contexts
			for(i=0; i < json.length; i++)
			{
				if(json[i].contextType === "CAMPUS") {
					z = i;
					json1 = JSON.parse(JSON.stringify(json));
					break;
				}
			}
			if(z !== -1) {
				for(i=0; i < json.length; i++)
				{
					
					if(json[i].contextType === "BUILDING") {
						z = i;
						json1 = JSON.parse(JSON.stringify(json));
						break;
					}
				}
			}
		}

		//if(json[0].contextType === "CAMPUS") {
		if(z !== -1) {
			//get Campus tags
			if(Object.keys(g_oGlobalTags).length === 0) {
				getPlanningCampusContextTags(json1[z].customFields);
				try {
					if(g_campusTags.dashboard.length === 0) {
						demoCheckForDashboardDevices();
						if(g_oDemoDashboardDeviceTypeList !== null)
							g_bSiteDashboard = true;
					}
				} catch {}
			}
			else if(Object.keys(json1[z].customFields).length === 0) {
				//remove - this line, if(Object.keys(g_oGlobalTags).length !== 0)
				getPlanningCampusContextTags(g_oGlobalTags);
			}
			else  {
				// if both g_oGlobalTags and json[z].customFields then use json[z].customFields if any device type specified in json[z].customFields
				bContinue = false;
				for(x in json1[z].customFields)
				{
					if(x.startsWith("devicetype_")) {
						bContinue = true;
						break;
					}
				}
				if(bContinue)
					getPlanningCampusContextTags(json1[z].customFields);
				else {
					// Use g_oGlobalTags but customFields tags override g_oGlobalTags tags 
					for(x in json1[z].customFields)
					{
						g_oGlobaltags[x] = json1[z].customFields[x];
					}
					getPlanningCampusContextTags(g_oGlobalTags);
				}
			}

			if(g_bCheckUser) {
				for(i=0; i < g_campusTags.userList.length; i++)
				{ 
					
					if(g_campusTags.userList[i].name === g_currentUser) {
						g_bShowDeviceDashboard = g_campusTags.userList[i].showDeviceDashboard;
						g_bReadOonly = g_campusTags.userList[i].readonly;
						contextPath = g_campusTags.userList[i].context;
						if(g_campusTags.userList[i].singleContext) {
							// find context
							
							id = getPlanningContextIdFromContextPath(contextPath);
							if(id === -1)
								showAlertDialog(0,"Error: can't find context\r\n\t" + contextPath);
							else {
								paneContent = "<div id=\"planningPaneDetails\" class=\"planningPaneDetailsShow\">";
								element = document.getElementById("main");
								if(element !== null)
									element.innerHTML = paneContent;
								getPlanningTreeShowTreeFloorplan (id);
							}
							return;
						}
						else if(contextPath !== "") {
							g_bShowUnassignedDevicesInTree = false;
							json = getPlanningContextObjFromContextPath(contextPath);
							planningList = [];
							if(json === null) {
								document.getElementById("main").innerHTML = "<h2>No Context Found</h2>";
								
								return;
							}
							else {
								planningList.push(JSON.parse(JSON.stringify(json)));
							}
						}
						break;
					}
				}
			}
		}
		else {
			g_bShowTree = checkIfUserTypeSupported(g_iShowTree);
			g_bShowUnassignedDevicesInTree = checkIfUserTypeSupported(g_iShowUnassignedDevicesInTree);
		}

/*
		if(g_currentUser !== null) {
			// check if user only has access to single context
			planningList = [];
			for(i=0; i < g_campusTags.userList.length; i ++)
			{
				if(g_campusTags.userList[i].name === g_currentUser) {
					// mike.settings: context=* / * /Entry,singlecontext=true,devicedashboard=false,readonly=true
					if(g_campusTags.userList[i].context !== "") {
						index = 0;
						planningDpList = getPlanningTreeInitPlanningListForUser(0, json,g_campusTags.userList[i].context,0)
						if(planningDpList === null) {
							element = document.getElementById("main");
							if(element !== null) {
								element.innerHTML = "<div style=\"margin-left:250px;margin-top:100px\">No Context Found</div>";
							}
							return;
						}
						if(g_campusTags.userList[i].singlecontext)
							planningDpList[0].children = [];
						if(!g_campusTags.userList[i].showDeviceDashboard) 
							g_bShowDeviceDashboard = false;
					}
					break;
				}
			}
		}
		else if(mode === 0)
			planningList = json;
			*/
			
		g_bInitialization = false;
		
		
		//paneContent = prettyJson(json); //JSON.stringify(json);
		//document.getElementById("main").innerHTML = "<textarea style=\"width:100%;\" cols=\"25\">" + paneContent + "</textarea>";
		getplanningTreeShowTree(0);

		if(g_bCheckForDevicesWithMoreThanOneContext) {
			for(i=0; i < deviceListAll.length; i++)
			{
				if(typeof deviceListAll[i].contexts !== "undefined") {
					if(deviceListAll[i].contexts.length > 1) {
						g_bRemoveDuplicateDps = true;
						break;
					}
				}
			}
		}
			
		
		// navtree - remove 
		paneTitle = "<button id=\"planningTreeShowTreeExpandButton\" class=\"menuIconButton\" onclick=\"planningTreeHide()\" data-navtree=\"expanded\"></button>";
		paneTitle += "<button id=\"planningTreeShowDevicesButton\" class=\"planningTreeShowDevicesButton\" onclick=\"planningExpandDevicesNodeInTree()\">";
		if(g_bPlanningShowDevice)
			paneTitle += "Show All Devices"
		else 
			paneTitle += "Hide All Devices"
		paneTitle += "</button>";
		//paneTitle += "<button onclick=\"showPlanningRefresh(0)\" style=\"margin-left:10px\">Refresh All</button>";
		paneTitle += "<div id=\"planningContextDetailsDiv\" style=\"display:inline-block;float:right;margin-left:300px\"></div>";
		getActiveAlarmsCount(0)
		//navtree document.getElementById("main-Header").innerHTML = paneTitle;
		//if(deviceList.length === 0) {
		//	getDeviceListOnlyDontDisplay();
		//}
		
	}
	catch (err) {
		sTemp = err.toString();
	}
}
function getPlanningTreeFailCallback(mode, requestUrlString, json){
	try {
		if(g_bPreGetDatapointTypes) {
			g_bPreGetDatapointTypes = false;
			setTimeout(function() {showDashboardUiGetAllSnvtType(35, {});}, 500);
		}
	}
	catch {}
}
function getPlanningTreeInitPlanningListForUser(mode, json,path,level) {

	try {
		var i, j, k, iPtr, objs, pathItems;
		level++;
		pathItems = path.split("/");
		if(json === null)
			return null;
		for(i=0; i < json.length; i++)
		{
			if((pathItems[0] === "*") || (pathItems[0] === json[i].name)) {
				if(pathItems.length === 1) {
					objs = [];
					objs.push(JSON.parse(JSON.stringify(json[i])))
					return objs;
				}
				else {
					iPtr = path.indexOf("/")
					if((iPtr > 0) && ((iPtr + 2) < path.length)){

						path = path.substr(iPtr + 1);
						return getPlanningTreeInitPlanningListForUser(mode, json[i].children,path,level);
					}
				}
			}
		}
		json = null;
	}
	catch {
		json = null;
	}
	return json;
}
function getPlanningTreeInitializePlanningList (mode, json, path, level) {
	try {
		var i, j, k;
		level++;
		var devices = [], deviceName1, deviceName2;
		var tempObj;
		var bContinue;
		
		if(json === null)
			return null;
		for(i=0; i < json.length; i++)
		{
			if(level === 1) {
				json[i].show = true;
				
			}
			else {
				json[i].show = false;
				
			}
			if(path !== "") {
				json[i].path = path + "/" + json[i].name;
				json[i].treeLevel = level;
			}
			else {
				json[i].path = json[i].name;
				json[i].treeLevel = level;
			}
			if(mode === 0) {
				tempObj = {};
				tempObj.path = json[i].path;
				tempObj.treelevel = level;
				tempObj.id = json[i].id;
				tempObj.name = json[i].name;
				contextList.push(tempObj);
			}
			json[i].devices = [];
			devices = [];
				// list devices
			for(k=0; k < deviceListAll.length; k++) 
			{
				for(j=0; j < deviceListAll[k].contexts.length; j++)
				{
					
					if(deviceListAll[k].contexts[j] === json[i].id) 
					{
						devices.push(JSON.parse(JSON.stringify(deviceListAll[k])));
						break;
					}
				}
			}
			if(devices.length > 0) {
				// reorder based on device name
				bContinue = true;
				while(bContinue) 
				{
					bContinue = false;
					for(k=0; k < (devices.length - 1); k++)
					{
						deviceName1 = devices[k].name.toLowerCase() + " ";
						if(devices[k].category === "SC")
							deviceName1 = "0" + deviceName1; // make sure smartserver at top of list
						deviceName2 = devices[k + 1].name.toLowerCase() + " ";
						if(devices[k + 1].category === "SC")
							deviceName2 = "0" + deviceName2; // make sure smartserver at top of list
						//if(devices[k].name.toLowerCase() > devices[k + 1].name.toLowerCase()) {
						if(deviceName1 > deviceName2) {
							bContinue = true;
							tempObj = {};
							tempObj = JSON.parse(JSON.stringify(devices[k]));
							devices[k] = JSON.parse(JSON.stringify(devices[k + 1]));
							devices[k + 1] = tempObj;
						}
					}
				}
				json[i].devices = devices;
			}
			if(json[i].children !== null) {
				if(json[i].children.length > 0) {
					json[i].children = getPlanningTreeInitializePlanningList (mode, json[i].children, json[i].path, level);
				}
			}
			
		}
	} catch { sResult = ""; }
	return json;
}
function getPlanningTreeShowDashboard(mode, contextId, deviceName) {
	getPlanningTreeShowDashboard1(false, mode, contextId, deviceName) ;
}
function getPlanningTreeShowDashboard1(bTree, mode, contextId, deviceName) {
	// use for navtree
	// Determine if customer has own device dashboard.  If so use that one in a iframe, if not then use builtin dashboard
	var i, j, k, typeId, deviceTypeName, deviceProgramId, deviceProgramId1, mask = 0xff, deviceProgramIds, deviceProgramIds1, count, match;
	var element, obj = {};
	var content = "", url;
	if(g_sDemoMode === "basic") 
		return;
	if(!bTree) {
		if(g_bEditModeEnabled) {
			// If from details pane then ignore while in edit mode
			return;
		}
	}
	g_iMainDisplayMode = DISPLAYMODE_DASHBOARD;
	menuCloseAll();
	g_bEditModeEnabled = false;
	g_bDeviceDataLogGetInProgress = false;
	g_dashboardChartList = [];
	g_zoomDashboardChartList = [];
	g_oDashboardLayout = null;
	if(g_iShowEditButton > 0) {
		if(g_iShowEditButton === 2) 
			g_bEditModeEnabled = true;
		
	}
	g_iDashboardBackButtonContextId = null;
	if(mode === 10) {
		g_iDashboardBackButtonContextId = g_iPlanningPaneSelectedContextId;
		
	}
	
		
	try {
		// change color of tree context to indicate selected
		if((mode === 0) && (g_iPlanningPaneSelectedContextId !== -1)) {
			treeContext = document.getElementById("planningTreeContext_" + g_iPlanningPaneSelectedContextId);
			if(treeContext !== null) {
				treeContext.classList.remove("treeSelected")
				//treeContext.style.backgroundColor = "white";
				
			}
		}
		treeContext = document.getElementById("planningTreeContext_" + contextId);
		if(treeContext !== null) {
			treeContext.classList.add("treeSelected")
			//treeContext.style.backgroundColor = "red";
		}
		if(contextId !== "")
			g_iPlanningPaneSelectedContextId = contextId;
		element = document.getElementById("planningPaneDetails");
		if(element !== null) {
			element.className = "planningPaneDetailsShow";
		}
		content = "";
		if(g_bSnvtTypePreLoadInProgress) {
			element.innerHTML = "";
			for(i=0; i < deviceListAll.length; i++)
			{
				if(deviceListAll[i].name === deviceName) {
					showDashboard(35,deviceName, deviceListAll[i].id);
					break;
					/*
					if(deviceListAll[i].category === "SC") 
						content = "Dashboard: SmartServer Segment Controller";
					else {
						content = treeviewfindContextPathFromId(contextId, planningList, "")
						if(content === null)
							content = deviceListAll[i].name;
						else
							content += "/" + deviceListAll[i].name; // planningCreateContextbreadcrumbs(contextPath);
					}
					*/
				}
			}
			/*
			content +=  "</div><div id=\"planningPaneDetails_Details\"><br><div class=\"gettingInfo\">" + addWaitSpinner(1) + "</div>";
			if(element !== null) 
				element.innerHTML = content;
			*/
			g_oSnvtTypePreLoadNextStep = {};
			g_oSnvtTypePreLoadNextStep.type = 1; // 0=siteDashboard, 1=device dashboard
			g_oSnvtTypePreLoadNextStep.mode = mode;
			g_oSnvtTypePreLoadNextStep.bTree = bTree;
			g_oSnvtTypePreLoadNextStep.contextId = contextId;
			g_oSnvtTypePreLoadNextStep.deviceName = deviceName;
		}
		else 
			getPlanningTreeShowDashboard2(bTree, mode, contextId, deviceName);
	}
	catch {}
}
function getPlanningTreeShowDashboard2(bTree, mode, contextId, deviceName) {

	try {
		if(g_iMainDisplayMode !== DISPLAYMODE_DASHBOARD)
			return;
		element = document.getElementById("planningPaneDetails");
		if(element !== null) {
			element.className = "planningPaneDetailsShow";
		}

		for(i=0; i < deviceListAll.length; i++)
		{
			if(deviceListAll[i].name === deviceName) {
				if(deviceListAll[i].category === "SC") {
					//custom Web page not found
					content = "<div style=\"display: inline-block;\">";
						//remove content = "<div style=\"display: inline-block;width:" + g_deviceTypesReplacementsProgramId[j].width;
						//remove content += "px;height:" + g_deviceTypesReplacementsProgramId[j].height + "px;\">";
					content += "Dashboard: SmartServer Segment Controller";
					if(g_bMapEnabled) {
						content += "<div style=\"float:right\"><button id=\"mapButton_"+ deviceName + "\" title=\"Show on map\" onclick=\"dashboardMapDevice(" + i + ",'"+ deviceName + "')\">Map</button></div>"; //mainly used by apollo user
					}
					content += "<br>";
					if(g_bShowSmartServerStorage && (g_iSmartServerVersion >= 410000)) {
						content += "<br><div id=\"storageInfo\"><div class=\"gettingInfo\">" + addWaitSpinner(1) + "</div></div>";
						content += "</div>";
						if(element !== null) {
							element.innerHTML = content;
							element.style.marginLeft = "0px";
						}
					
						url = "https://" + location.host + "/iap/storage";
						requestGetData(deviceListAll[i].SID, url, planningSmartServerStorageCallback, planningSmartServerStorageFailCallback); // paginagion does't work on device list get Device list
						
					}
					else {
						
						if(g_smartServerImage !== null) {
							content += "<div style=\"float:left;display:inline-block;margin-left:50 px;margin-top:10px;margin-right:10px\"><img src=\"" +  g_smartServerImage + "\" alt=\"device image\"";
							if(g_smartServerImageWidth !== null)
								content += " width=\"" + g_smartServerImageWidth + "px\"";
							if(g_smartServerImageHeight !== null)
								content += " height=\"" + g_smartServerImageHeight + "px\"";
							content += "></div>";
							
						}
						if(element !== null) {
							element.innerHTML = content;
							element.style.marginLeft = "0px";
						}
					}
					return;
				}
				
				typeId = deviceListAll[i].typeId;
				if(typeof deviceListAll[i].programId === "undefined") {
					for(j=0; j < deviceTypeList.length; j++)
					{
						if(typeId === deviceTypeList[j].id) {
							deviceListAll[i].deviceTypeName = deviceTypeList[j].name;
							deviceListAll[i].programId = deviceTypeList[j].programId;
							break;
						}
					}
				}
				deviceTypeName = deviceListAll[i].deviceTypeName.toLowerCase();
				if(!g_bIgnoreUserJsReplacements) {
					for(j=0; j < g_deviceTypesReplacementsDeviceType.length; j++)
					{
						if(g_deviceTypesReplacementsDeviceType[j].deviceTypeName.toLowerCase() === deviceTypeName) {
							//custom Web page found
							content = "<div style=\"display: inline-block;width:" + g_deviceTypesReplacementsDeviceType[j].width;
							content += "px;height:" + g_deviceTypesReplacementsDeviceType[j].height + "px;\">";
							content += "<iframe src=\"" + g_deviceTypesReplacementsDeviceType[j].url + "?device=" + deviceListAll[i].name + "&embedded=true\" scrolling=\"no\" FrameBorder=\"0\" width=\"";
							content += (g_deviceTypesReplacementsDeviceType[j].width + 50).toString() +"\"";
							content += " height=\"100%\"></iframe></div>";
							if(element !== null) {
								element.innerHTML = content;
								element.className = "planningPaneDetailsIframeShow";
								
							}
							return;
						}
					}
					for(j=0; j < g_deviceTypesReplacementsProgramId.length; j++)
					{
						deviceProgramId = deviceListAll[i].programId.toLowerCase();
						deviceProgramId1 = g_deviceTypesReplacementsProgramId[j].programId.toLowerCase();
						deviceProgramIds = deviceProgramId.split(":");
						deviceProgramIds1 = deviceProgramId1.split(":");
						if(deviceProgramIds.length === deviceProgramIds1.length) {
							count = deviceProgramIds.length - 1;
							if(g_deviceTypesReplacementsProgramId[j].allVersions) {
								count ++;
							}
							match = true;
							for(k=0; k < count; k++)
							{
								if(deviceProgramIds[k] !== deviceProgramIds1[k]) {
									match = false;
									break;
								}
							}
							if(match) {
								//custom Web page found
								content = "<div style=\"display: inline-block;width:" + g_deviceTypesReplacementsProgramId[j].width;
								content += "px;height:" + g_deviceTypesReplacementsProgramId[j].height + "px;\">";
								content += "<iframe src=\"" + g_deviceTypesReplacementsProgramId[j].url + "?device=" + deviceListAll[i].name + "&embedded=true\" scrolling=\"no\" FrameBorder=\"0\" width=\"";
								content += (g_deviceTypesReplacementsProgramId[j].width + 50).toString() +"\"";
								content += " height=\"100%\"></iframe></div>";
								if(element !== null) {
									element.innerHTML = content;
									element.className = "planningPaneDetailsIframeShow";
									
									
								}
								return;
							}
						}
					}
				}
				/*
				// didn't find a custom dashboard so use default
				element = document.getElementById("planningPaneDetails");
				if(element !== null) {
					element.style.marginLeft = "30px";
				}
				*/
				//get datapoint list and call showDashboard
				deviceDpList = [];
				g_bBuildDashboardDps = true; 
				if(g_bShowAlarms) {
					obj = {};
					obj.mode = 12;
					obj.deviceName = deviceName;
					obj.deviceId = deviceListAll[i].id;
					getPlanningGetAlarmsForDevice(obj);
				}
				else
					showDashboard(1, deviceName, deviceListAll[i].id);
			}
		}
	}
	catch {}
}
function getPlanningTreeShowSiteDashboard(mode, bAddImage, contextId,contextPath) {
	g_sContextContent = ""; 
	getPlanningTreeShowSiteDashboard1(mode, bAddImage, contextId,contextPath);
}
function getPlanningTreeShowSiteDashboard1(mode, bAddImage, contextId,contextPath) {
	// contextId: "_sitedashboard" means the site dashboard otherwise it will be a campus or building context
	var i, j, k, typeId, deviceTypeName, deviceProgramId, deviceProgramId1, mask = 0xff, deviceProgramIds, deviceProgramIds1, count, match;
	var element, obj = {};
	var content = "";
	var site = "", url;
	g_bEditModeEnabled = false;
	g_dashboardChartList = [];
	g_zoomDashboardChartList = [];
	g_oDashboardLayout = null;
	
	g_bDeviceDataLogGetInProgress = false;
	if(g_iShowEditButton > 0) {
		if(g_iShowEditButton === 2) 
			g_bEditModeEnabled = true;
	}
	g_iDashboardBackButtonContextId = null;
	if(mode === 10) {
		g_iDashboardBackButtonContextId = g_iPlanningPaneSelectedContextId;
		
	}
	
		
	try {
		if(contextId === "_sitedashboard")  {
			// change color of tree context to indicate selected
			if((mode === 0) && (g_iPlanningPaneSelectedContextId !== -1)) {
				treeContext = document.getElementById("planningTreeContext_" + g_iPlanningPaneSelectedContextId);
				if(treeContext !== null) {
					treeContext.classList.remove("treeSelected")
					//treeContext.style.backgroundColor = "white";
					
				}
			}
			treeContext = document.getElementById("planningTreeContext_" + contextId);
			if(treeContext !== null) {
				treeContext.classList.add("treeSelected")
				//treeContext.style.backgroundColor = "red";
			}
			if(g_bPreloadSiteDashboardEnable) { // site dashboard sometimes takes too long to load on vpns, preload
				if(g_bPreloadSiteDashboard) {
					if(g_campusTags.hasOwnProperty('dashboard')) {
						if(g_campusTags.dashboard.length !== 0) {
							if(g_campusTags.dashboard[0].image !== "") {
								preloadImage(g_campusTags.dashboard[0].image);
							}
						}
					}
					g_bPreloadSiteDashboard = false;
				}
			}
		}
		if(contextId !== "")
			g_iPlanningPaneSelectedContextId = contextId;
		element = document.getElementById("planningPaneDetails");
		if(element !== null) {
			if(contextId === "_sitedashboard") {
				element.className = "planningPaneDetailsShow";
				if(g_campusTags.dashboard.length === 0) {
					content = "<div><br><br>";
					content += "Dashboard Not supported Yet</div>";
					element.innerHTML = content;
					return;
				}
			}
			
			//if(element !== null)
            //    element.innerHTML = "<br><br><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting data ....</span>";
			
			g_sContextDpQualifierList = "";
			// get list of devices and datapoints
			if(g_bSnvtTypePreLoadInProgress) {
				element = document.getElementById("planningPaneDetails");
				content = "<div id=\"planningPaneDetails_title\">";
				if(contextId === "_sitedashboard")
					content += "Site Dashboard: ";
				else
					content += planningCreateContextbreadcrumbs(contextPath);
				content +=  "</div><div id=\"planningPaneDetails_Details\"><br><div class=\"gettingInfo\">" + addWaitSpinner(1) + "</div>";
				if(element !== null) 
					element.innerHTML = content;
				g_oSnvtTypePreLoadNextStep = {};
				g_oSnvtTypePreLoadNextStep.type = 0; // siteDashboard
				g_oSnvtTypePreLoadNextStep.mode = mode;
				g_oSnvtTypePreLoadNextStep.bAddImage = bAddImage;
				g_oSnvtTypePreLoadNextStep.contextId = contextId;
				g_oSnvtTypePreLoadNextStep.contextPath = contextPath;
			}
			else 
				getPlanningTreeShowSiteDashboard2(mode, bAddImage, contextId,contextPath);
			
		}
	}
	catch {}
}
function getPlanningTreeShowSiteDashboard2(mode, bAddImage, contextId,contextPath) {
	try {
		var obj = null, content = "",url,  site = "", element;
		if(contextId === "_sitedashboard") {
			if(g_campusTags.hasOwnProperty("dashboard")) {
				obj = g_campusTags.dashboard[0];
				g_sSiteDashboardSelected = "_sitedashboard";
				showDashboard1(1, "Site", -1);
				getPlanningTreeShowSiteDashboardPopulateDpList();
				if(g_campusTags.dashboard[0].dpList.length === 0) {
					if(g_campusTags.dashboard[0].image !== "") {
						content += "<div ><div id=\"dashboardImageDiv\" style=\"float:left;display:inline-block;position:relative;margin-top:10px;margin-right:10px\"><img src=\"" +  g_campusTags.dashboard[0].image + "\" alt=\"site dashboard image\"";
						if(g_campusTags.dashboard[0].width !== null)
							content += " width=\"" + g_campusTags.dashboard[0].width + "px\"";
						if(g_campusTags.dashboard[0].height !== null)
							content += " height=\"" + g_campusTags.dashboard[0].height + "px\"";
						content += "></div>";
						element.innerHTML = content;
						return;
					}
				}
			}
			else
				return;
		}
		else {
			g_sSiteDashboardSelected = contextPath;
			showDashboard1(1, contextPath, -1);
			j = getPlanningTreeShowContextDashboardPopulateDpList(contextPath);
			if(j !== -1) {
				obj = g_campusTags.contextList[j];
				if(g_campusTags.contextList[j].dpList.length === 0) {
					if(bAddImage) {
						if(g_campusTags.contextList[j].image !== "") {
							content += "<div ><div id=\"dashboardImageDiv\" style=\"float:left;display:inline-block;position:relative;margin-top:10px;margin-right:10px\"><img src=\"" +  g_campusTags.contextList[j].image + "\" alt=\"site dashboard image\"";
							if(g_campusTags.contextList[j].width !== null)
								content += " width=\"" + g_campusTags.contextList[j].width + "px\"";
							if(g_campusTags.contextList[j].height !== null)
								content += " height=\"" + g_campusTags.contextList[j].height + "px\"";
							content += "></div>";
							content = "<div  style=\"float:left;cursor:pointer\">" + planningCreateContextbreadcrumbs(contextPath) + "</div>" + content;
							element.innerHTML = content;
						}
						else if(g_sContextContent !== "") {
							element.innerHTML = "<div  style=\"float:left;cursor:pointer\">" + planningCreateContextbreadcrumbs(contextPath) + "</div>" + g_sContextContent; 
						}
						else  {
							element.innerHTML = "<div style=\"float:left;cursor:pointer\">" + planningCreateContextbreadcrumbs(contextPath) + "</div><br><br>No Content"; 
						}
					}
					else if(g_sContextContent !== "") {
						element.innerHTML = "<div style=\"float:left;cursor:pointer\">" + planningCreateContextbreadcrumbs(contextPath) + "</div>" + g_sContextContent; 
					}
					return;
				}
			}
		}
		
		deviceDpList = [];
		g_sContextDpQualifierDeviceList = [];
		g_bBuildDashboardDps = true; 

		if(obj !== null) {
			for(i=0; i < obj.deviceList.length; i++)
			{
				g_sContextDpQualifierDeviceList.push(JSON.parse(JSON.stringify(obj.deviceList[i])));
				z = g_sContextDpQualifierDeviceList.length - 1;
				g_sContextDpQualifierDeviceList[z].mode = 14;
			}

			if(g_sContextDpQualifierDeviceList.length > 0) {
				if((g_bShowAlarms))
					getPlanningGetAlarmsForDevice(g_sContextDpQualifierDeviceList.shift());
				else {
					url = "https://" + location.host + "/iap/devs/*/if/*/*/*+qualifier=-" + g_sContextDpQualifierList + "/*?noxs=true";
					requestGetData(0, url, getPlanningContextDpsListResponse, null);
				}
			}
			else {

			}
		}
		else
			showSiteDashboard(81, site, ""); // ffix mike doesn't exist -  used for siteDashboard, Campus and Building
	}
	catch {}
}
function getPlanningTreeShowContextDashboardPopulateDpList(contextPath) {
	var i,j,k,m,n,obj;
	var name,type="",names = [];
	var iCount = 0;
	var result = -1;
	try {
		if(g_campusTags.contextList.length === 0)  // len should be 0 or 1 for now
			return;
		for(i=0; i < g_campusTags.contextList.length; i++)
		{
			if(g_campusTags.contextList[i].contextName.toLowerCase() === contextPath.toLowerCase()) {
				result = i;
				if(typeof g_campusTags.contextList[i].dpListOrig === "undefined") {
					g_campusTags.contextList[i].dpListOrig = JSON.parse(JSON.stringify(g_campusTags.contextList[i].dpList));
				}
				if(g_campusTags.contextList[i].dpListOrig.length > 0) {
					
					g_campusTags.contextList[i].dpList = [];
					g_campusTags.contextList[i].deviceList = [];
					for(j=0; j < g_campusTags.contextList[i].dpListOrig.length; j++)
					{
						iCount = 0;
						name = g_campusTags.contextList[i].dpListOrig[j].deviceTypeStr;
						if(name !== "") {
							if((name.charAt(0) !== "(") && (name.charAt(0) !== "[")) {
								name = name.toLowerCase();
								type = "devicename";
							}
							else if(name.length > 2) {
								if((name.charAt(0) === "[") && (name.charAt(name.length - 1) === "]")) {
									name = name.substr(1,name.length - 2).toLowerCase();
									type = "devicetype";
								}
								else if((name.charAt(0) === "(") && (name.charAt(name.length - 1) === ")")) {
									name = name.substr(1,name.length - 2).toLowerCase();
									type = "programid";
								}
							}
							else 
								name = "";
			
							if((name !== "") && (type !== "")) {
								names = [];
								if(name.indexOf(";") !== -1) {
									names = name.split(";");
								}
								else
									names.push(name);
								obj1 = {}; // dp info, may be used more than once if multiple device names, device types or program IDs used
								for(k=0; k < names.length; k++)
								{
									names[k] = names[k].toLowerCase();
									if(type === "devicename") {
										// check if devices in 
										for(m=0; m < deviceListAll.length; m++)
										{
											if(names[k] === deviceListAll[m].name.toLowerCase()) {
												g_campusTags.contextList[i].dpList.push(JSON.parse(JSON.stringify(g_campusTags.contextList[i].dpListOrig[j])))
												z = g_campusTags.contextList[i].dpList.length - 1;
												g_campusTags.contextList[i].dpList[z].deviceName = deviceListAll[m].name;
												g_campusTags.contextList[i].dpList[z].pathname = g_campusTags.contextList[i].dpList[z].deviceName + "/" + g_campusTags.contextList[i].dpList[z].path;
												g_campusTags.contextList[i].dpList[z].deviceListIndex = m;
												if(g_sContextDpQualifierList !== "")
													g_sContextDpQualifierList += ",";
												g_sContextDpQualifierList += encodeUriString(deviceListAll[m].scId + "/" +  deviceListAll[m].protocol + "/" + deviceListAll[m].DID + "/" + g_campusTags.contextList[i].dpList[z].path);

												z = -1;
												for(n=0; n < g_campusTags.contextList[i].deviceList.length; n++)
												{
													if(g_campusTags.contextList[i].deviceList[n].deviceName === deviceListAll[m].name) {
														z = n;
														break;
													}
												}
												if(z === -1) {
													obj = {}
													obj.deviceName = deviceListAll[m].name;
													obj.deviceId = deviceListAll[m].id;
													g_campusTags.contextList[i].deviceList.push(JSON.parse(JSON.stringify(obj)));

												}
												iCount ++;
												if(iCount > 1) {
													// remove x and y
												}
												break;
											}
										}
									}
									else if(type === "devicetype") {
										// check if devices in 
										for(m=0; m < deviceListAll.length; m++)
										{
											if(names[k] === deviceListAll[m].deviceTypeName.toLowerCase()) {
												g_campusTags.contextList[i].dpList.push(JSON.parse(JSON.stringify(g_campusTags.contextList[i].dpListOrig[j])))
												z = g_campusTags.contextList[i].dpList.length - 1;
												g_campusTags.contextList[i].dpList[z].deviceName = deviceListAll[m].name;
												g_campusTags.contextList[i].dpList[z].pathname = g_campusTags.contextList[i].dpList[z].deviceName + "/" + g_campusTags.contextList[i].dpList[z].path;
												g_campusTags.contextList[i].dpList[z].deviceListIndex = m;
												if(g_sContextDpQualifierList !== "")
													g_sContextDpQualifierList += ",";
												g_sContextDpQualifierList += encodeUriString(deviceListAll[m].scId + "/" +  deviceListAll[m].protocol + "/" + deviceListAll[m].DID + "/" + g_campusTags.contextList[i].dpList[z].path);

												z = -1;
												for(n=0; n < g_campusTags.contextList[i].deviceList.length; n++)
												{
													if(g_campusTags.contextList[i].deviceList[n].deviceName === deviceListAll[m].name) {
														z = n;
														break;
													}
												}
												if(z === -1) {
													obj = {}
													obj.deviceName = deviceListAll[m].name;
													obj.deviceId = deviceListAll[m].id;
													g_campusTags.contextList[i].deviceList.push(JSON.parse(JSON.stringify(obj)));

												}
												iCount ++;
												if(iCount > 1) {
													// remove x and y
												}
											}
										}
									}
									else if(type === "programid") {
										// check if devices in 
										for(m=0; m < deviceListAll.length; m++)
										{
											if(typeof deviceListAll[m].programId !== "undefined") {
												if(names[k] === deviceListAll[m].programId.toLowerCase()) {
													g_campusTags.contextList[i].dpList.push(JSON.parse(JSON.stringify(g_campusTags.contextList[i].dpListOrig[j])))
													z = g_campusTags.contextList[i].dpList.length - 1;
													g_campusTags.contextList[i].dpList[z].deviceName = deviceListAll[m].name;
													g_campusTags.contextList[i].dpList[z].pathname = g_campusTagscontextList[i].dpList[z].deviceName + "/" + g_campusTags.contextList[i].dpList[z].path;
													g_campusTags.contextList[i].dpList[z].deviceListIndex = m;
													if(g_sContextDpQualifierList !== "")
														g_sContextDpQualifierList += ",";
													g_sContextDpQualifierList += encodeUriString(deviceListAll[m].scId + "/" +  deviceListAll[m].protocol + "/" + deviceListAll[m].DID + "/" + g_campusTags.contextList[i].dpList[z].path);

													z = -1;
													for(n=0; n < g_campusTags.contextList[i].deviceList.length; n++)
													{
														if(g_campusTags.contextList[i].deviceList[n].deviceName === deviceListAll[m].name) {
															z = n;
															break;
														}
													}
													if(z === -1) {
														obj = {}
														obj.deviceName = deviceListAll[m].name;
														obj.deviceId = deviceListAll[m].id;
														g_campusTags.contextList[i].deviceList.push(JSON.parse(JSON.stringify(obj)));

													}
													iCount ++;
													if(iCount > 1) {
														// remove x and y
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
				break;
			}
		}
	}
	catch {}
	return result;
}
function getPlanningTreeShowSiteDashboardPopulateDpList() {
	var i,j,k,m,n,obj;
	var name,type="",names = [];
	var iCount = 0;
	try {
		if(g_campusTags.dashboard.length === 0)  // len should be 0 or 1 for now
			return;
		g_oDashboardLayout = null;
		if(g_campusTags.dashboard[0].layout !== null)
			g_oDashboardLayout = g_campusTags.dashboard[0].layout;
		for(i=0; i < g_campusTags.dashboard.length; i++)
		{
			if(typeof g_campusTags.dashboard[i].dpListOrig === "undefined") {
				g_campusTags.dashboard[i].dpListOrig = JSON.parse(JSON.stringify(g_campusTags.dashboard[i].dpList));
			}
			if(g_campusTags.dashboard[i].dpListOrig.length > 0) {
				
				g_campusTags.dashboard[i].dpList = [];
				g_campusTags.dashboard[i].deviceList = [];
				for(j=0; j < g_campusTags.dashboard[i].dpListOrig.length; j++)
				{
					iCount = 0;
					name = g_campusTags.dashboard[i].dpListOrig[j].deviceTypeStr;
					if(name !== "") {
						if((name.charAt(0) !== "(") && (name.charAt(0) !== "[")) {
							name = name.toLowerCase();
							type = "devicename";
						}
						else if(name.length > 2) {
							if((name.charAt(0) === "[") && (name.charAt(name.length - 1) === "]")) {
								name = name.substr(1,name.length - 2).toLowerCase();
								type = "devicetype";
							}
							else if((name.charAt(0) === "(") && (name.charAt(name.length - 1) === ")")) {
								name = name.substr(1,name.length - 2).toLowerCase();
								type = "programid";
							}
						}
						else 
							name = "";
		
						if((name !== "") && (type !== "")) {
							names = [];
							if(name.indexOf(";") !== -1) {
								names = name.split(";");
							}
							else
								names.push(name);
							obj1 = {}; // dp info, may be used more than once if multiple device names, device types or program IDs used
							for(k=0; k < names.length; k++)
							{
								names[k] = names[k].toLowerCase();
								if(type === "devicename") {
									// check if devices in 
									for(m=0; m < deviceListAll.length; m++)
									{
										if(names[k] === deviceListAll[m].name.toLowerCase()) {
											g_campusTags.dashboard[i].dpList.push(JSON.parse(JSON.stringify(g_campusTags.dashboard[i].dpListOrig[j])))
											z = g_campusTags.dashboard[i].dpList.length - 1;
											g_campusTags.dashboard[i].dpList[z].deviceName = deviceListAll[m].name;
											g_campusTags.dashboard[i].dpList[z].pathname = g_campusTags.dashboard[i].dpList[z].deviceName + "/" + g_campusTags.dashboard[i].dpList[z].path;
											g_campusTags.dashboard[i].dpList[z].deviceListIndex = m;
											if(g_sContextDpQualifierList !== "")
												g_sContextDpQualifierList += ",";
											g_sContextDpQualifierList += encodeUriString(deviceListAll[m].scId + "/" +  deviceListAll[m].protocol + "/" + deviceListAll[m].DID + "/" + g_campusTags.dashboard[i].dpList[z].path);

											z = -1;
											for(n=0; n < g_campusTags.dashboard[i].deviceList.length; n++)
											{
												if(g_campusTags.dashboard[i].deviceList[n].deviceName === deviceListAll[m].name) {
													z = n;
													break;
												}
											}
											if(z === -1) {
												obj = {}
												obj.deviceName = deviceListAll[m].name;
												obj.deviceId = deviceListAll[m].id;
												g_campusTags.dashboard[i].deviceList.push(JSON.parse(JSON.stringify(obj)));

											}
											iCount ++;
											if(iCount > 1) {
												// remove x and y
											}
											break;
										}
									}
								}
								else if(type === "devicetype") {
									// check if devices in 
									for(m=0; m < deviceListAll.length; m++)
									{
										if(names[k] === deviceListAll[m].deviceTypeName.toLowerCase()) {
											g_campusTags.dashboard[i].dpList.push(JSON.parse(JSON.stringify(g_campusTags.dashboard[i].dpListOrig[j])))
											z = g_campusTags.dashboard[i].dpList.length - 1;
											g_campusTags.dashboard[i].dpList[z].deviceName = deviceListAll[m].name;
											g_campusTags.dashboard[i].dpList[z].pathname = g_campusTags.dashboard[i].dpList[z].deviceName + "/" + g_campusTags.dashboard[i].dpList[z].path;
											g_campusTags.dashboard[i].dpList[z].deviceListIndex = m;
											if(g_sContextDpQualifierList !== "")
												g_sContextDpQualifierList += ",";
											g_sContextDpQualifierList += encodeUriString(deviceListAll[m].scId + "/" +  deviceListAll[m].protocol + "/" + deviceListAll[m].DID + "/" + g_campusTags.dashboard[i].dpList[z].path);

											z = -1;
											for(n=0; n < g_campusTags.dashboard[i].deviceList.length; n++)
											{
												if(g_campusTags.dashboard[i].deviceList[n].deviceName === deviceListAll[m].name) {
													z = n;
													break;
												}
											}
											if(z === -1) {
												obj = {}
												obj.deviceName = deviceListAll[m].name;
												obj.deviceId = deviceListAll[m].id;
												g_campusTags.dashboard[i].deviceList.push(JSON.parse(JSON.stringify(obj)));

											}
											iCount ++;
											if(iCount > 1) {
												// remove x and y
											}
										}
									}
								}
								else if(type === "programid") {
									// check if devices in 
									for(m=0; m < deviceListAll.length; m++)
									{
										if(typeof deviceListAll[m].programId !== "undefined") {
											if(names[k] === deviceListAll[m].programId.toLowerCase()) {
												g_campusTags.dashboard[i].dpList.push(JSON.parse(JSON.stringify(g_campusTags.dashboard[i].dpListOrig[j])))
												z = g_campusTags.dashboard[i].dpList.length - 1;
												g_campusTags.dashboard[i].dpList[z].deviceName = deviceListAll[m].name;
												g_campusTags.dashboard[i].dpList[z].pathname = g_campusTags.dashboard[i].dpList[z].deviceName + "/" + g_campusTags.dashboard[i].dpList[z].path;
												g_campusTags.dashboard[i].dpList[z].deviceListIndex = m;
												if(g_sContextDpQualifierList !== "")
													g_sContextDpQualifierList += ",";
												g_sContextDpQualifierList += encodeUriString(deviceListAll[m].scId + "/" +  deviceListAll[m].protocol + "/" + deviceListAll[m].DID + "/" + g_campusTags.dashboard[i].dpList[z].path);

												z = -1;
												for(n=0; n < g_campusTags.dashboard[i].deviceList.length; n++)
												{
													if(g_campusTags.dashboard[i].deviceList[n].deviceName === deviceListAll[m].name) {
														z = n;
														break;
													}
												}
												if(z === -1) {
													obj = {}
													obj.deviceName = deviceListAll[m].name;
													obj.deviceId = deviceListAll[m].id;
													g_campusTags.dashboard[i].deviceList.push(JSON.parse(JSON.stringify(obj)));

												}
												iCount ++;
												if(iCount > 1) {
													// remove x and y
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	catch {}
}
function getPlanningGetAlarmsForDevice(mode) {
	var	url = "";
	try {
	if(mode !== null)
		url = "https://" + location.host + "/iap/alarms/device/" + mode.deviceId;
		requestGetData(mode, url, getPlanningGetAlarmsForDeviceResponse, getPlanningGetAlarmsForDeviceFailCallback);
	}
	catch {}

}
function getPlanningGetAlarmsForDeviceResponse(mode, requestUrlString, json) {
	try {
		var i, j, k, url, z = -1, json1 = [],type,details,datapointPath, iPtr, iPtr1, obj,obj1;
		if(json !== null) {
			// determine datapoints path
			for(i=0; i < json.length; i++) 
			{
				if(json[i].alarmTargetType === "DEVICE") {
					json1.push(JSON.parse(JSON.stringify(json[i])))
					
					z = json1.length - 1;
					type = json1[z].type;
					details = json[z].details;
					json[i].pathname = "";
					json[i].warningLevel = 0;
					json[i].warningMessage = "";
					json[i].warningValue = "";
					iPtr = details.indexOf(" limit");
					if(iPtr > 1) {
						json[i].warningMessage = details.substr(0, iPtr);
						if(json[i].warningMessage.toLowerCase().startsWith("high error"))
							json[i].warningLevel = 4
						else if(json[i].warningMessage.toLowerCase().startsWith("high warning"))
							json[i].warningLevel = 3
						else if(json[i].warningMessage.toLowerCase().startsWith("low error"))
							json[i].warningLevel = 1
						else if(json[i].warningMessage.toLowerCase().startsWith("low warning"))
							json[i].warningLevel = 2
						iPtr = details.indexOf("\"");
						if(iPtr !== -1) {
						//iPtr += " limit ".length;
							iPtr1 = details.indexOf(" exceeded for ");
							if(iPtr1 !== -1) {
								json[i].warningValue = details.substr(iPtr, iPtr1-iPtr);
							}
						}

						if(json[i].warningLevel > 0) {
							
							datapointPath = "";
							iPtr1 = details.indexOf("exceeded for ");
							if(iPtr1 !== -1) {
								iPtr1 += "exceeded for ".length + 1;
								iPtr1 = details.indexOf(" ",iPtr1);
								if(iPtr1 !== -1) {
									iPtr1 ++;
									iPtr = details.lastIndexOf(". Triggered value is ")
									if(iPtr > 0) {
										datapointPath = details.substr(iPtr1, (iPtr - iPtr1));
										iPtr = 0;
										// replace "." with "/" note iox and CT uses "." so only replace last three "."
										for(j=0; j < 3; j++)
										{
											if(j=== 0)
												iPtr = datapointPath.lastIndexOf(".");
											else if(j=== 1)
												iPtr = datapointPath.lastIndexOf(" ",iPtr);
											else
												iPtr = datapointPath.lastIndexOf(".",iPtr);
											if(iPtr !== -1) {
												datapointPath = datapointPath.substr(0, iPtr) + "/" + datapointPath.substr(iPtr + 1);
												iPtr--;
											}
										}
									}
	
								}
							}
							json[i].pathname = datapointPath;
						}
					}
					if(json1.length > 0) {
						z = -1;
						// look for device
						for(j=0; j < g_deviceAlarmsList.length; j++)
						{
							if(g_deviceAlarmsList[j].deviceId === mode.deviceId) {
								for(k=0; k < g_deviceAlarmsList[j].alarms.length; k++)
								{
									if(g_deviceAlarmsList[j].alarms[k].pathname  === json[i].pathname) {
										g_deviceAlarmsList[j].alarms[k] = JSON.parse(JSON.stringify(json[i]));
										z = k;
									}
								}
								if(z === -1) {
									g_deviceAlarmsList[j].alarms.push(JSON.parse(JSON.stringify(json[i])));
								}
								z = j;
								break;
							}
						}
						if(z === -1){
							obj = {};
							obj.deviceId = mode.deviceId;
							obj.deviceName = mode.deviceName;
							obj.alarms = [];
							obj.alarms.push(JSON.parse(JSON.stringify(json[i])));
							g_deviceAlarmsList.push(obj);
						}
					}

				}
			}
			
		}
	}
	catch {}
	if(mode !== null) {
		if(mode.mode !== 55) {
			// contexts can have more than one device, dashboards has only one device
			if((mode.mode === 11) || (mode.mode === 12) || (mode.mode === 14)) {
				if(g_sContextDpQualifierDeviceList.length > 0) { 
					obj1 = g_sContextDpQualifierDeviceList[0];
					g_sContextDpQualifierDeviceList.shift();
					obj = {};
					if(mode.mode === 14)
						obj.mode = 14;
					else
						obj.mode = 11;
					obj.deviceName = obj1.deviceName;
					obj.deviceId = obj1.deviceId;
					getPlanningGetAlarmsForDevice(obj);
					return;
				}
			}
			if((mode.mode === 11) || (mode.mode === 14)) {
				url = "https://" + location.host + "/iap/devs/*/if/*/*/*+qualifier=-" + g_sContextDpQualifierList + "/*?noxs=true";
				requestGetData(0, url, getPlanningContextDpsListResponse, null);
			}
			//else if (mode.mode === 14) 
			//	showDashboard(81,"Site", "");
			else
				showDashboard(1, mode.deviceName, mode.deviceId);
		}
	}
}
function getPlanningGetAlarmsForDeviceFailCallback(mode, requestUrlString, json) {
	try {
		var url;
		if(mode !== null) {
			// contexts can have more than one device, dashboards has only one device
			if(typeof mode.mode !== "undefined") {
				if((mode.mode === 11) || (mode.mode === 12)) {
					if(g_sContextDpQualifierDeviceList.length > 0) {
						obj1 = g_sContextDpQualifierDeviceList[0];
						g_sContextDpQualifierDeviceList.shift();
						obj = {};
						if(mode.mode === 14)
							obj.mode = 14;
						else
							obj.mode = 11;
						obj.deviceName = obj1.deviceName;
						obj.deviceId = obj1.deviceId;
						getPlanningGetAlarmsForDevice(obj);
						return;
					}
					
				}
				if((mode.mode === 11)  || (mode.mode === 14)) {
					url = "https://" + location.host + "/iap/devs/*/if/*/*/*+qualifier=-" + g_sContextDpQualifierList + "/*?noxs=true";
					requestGetData(0, url, getPlanningContextDpsListResponse, null);
				}
				else
					showDashboard(1, mode.deviceName, mode.deviceId);
			}
		}
	}
	catch {}
}

function getplanningTreeShowTree(mode) {
//planningContext, planningContextRoot
	var paneContent = "", temp = "", sTemp = "";
	var i,j, k;
	var tempStr;
	var sidebar = null;
	try{
		if(planningList.length > 0) {
			//no planning contexts so add site in tree with only devices list
			planningList = getPlanningTreeInitializePlanningList(mode, planningList, "", 0);
		}
		sTemp = getplanningTreeShowTreeContext(planningList, 0) + "<br><br>";
		
		
	}
	catch {}
	
	// tree
	temp  = "<div style=\"display:flex\">";
	temp += "<button id=\"planningTreeShowTreeExpandButton\" class=\"menuIconButton\" onclick=\"planningTreeHide()\" data-navtree-expand=\"expanded\" title=\"Show or hide Tree\"></button>";
	temp += "<button id=\"planningTreeShowDevicesButton\" class=\"planningTreeShowDevicesButton\" onclick=\"planningExpandDevicesNodeInTree()\" title=\"Show or hide devices in tree\">";
	if(g_bPlanningShowDevice)
		temp += "Show All Devices"
	else 
		temp += "Hide All Devices"
	temp += "</button>";
	//temp += "<button onclick=\"showPlanningRefresh(0)\" style=\"margin-left:10px\">Refresh All</button><br><br>";
	temp += '<div id=\"showLegendMenuDiv\" style=\"display:flex\"><label style=\"display:flex;align-items:center;margin-left:10px\"><input id=\"showLegendId\" type=\"checkbox\" onclick=\"showLegend()\">Legend</label></div>';
	temp += "</div>"
	////paneTitle += "<div id=\"planningContextDetailsDiv\" style=\"display:inline-block;float:right;margin-left:300px\"></div>";
	//document.getElementById("main-Header").innerHTML = paneTitle;

	//paneContent = "<div style=\"display:flex\"><div id=\"treeDiv\" style=\"float:left;border: 1px black; white-space:nowrap; overflow:auto\">" + paneContent;
	


	paneContent = "<div style=\"display:flex\"><div id=\"treeDiv\"";
	if(!g_bShowTree) 
		paneContent += " style=\"display:none\"";
	
	paneContent += ">" + temp + "<div id=\"treeDivTreeResize\" style=\"position:relative\"><div id=\"treeDivTree\" onmousedown=\"treeDivTreeMouseDownEvent(this)\" onmouseup=\"treeDivTreeMouseUpEvent(this)\">" + sTemp + "</div>";
	
	// add resize divs
	paneContent += "<div id=\"treeDivResizeRightDiv\" class=\"resizeRightDiv\" onmousedown=\"mouseDownTreeResizeRightHandler(event)\"></div>";
	paneContent += "<div id=\"treeDivResizeBottomDiv\" class=\"resizeBottomDiv\" onmousedown=\"mouseDownTreeResizeBottomHandler(event)\"></div>";
	paneContent += "</div>";
	paneContent += "<div id=\"treeLegend\"><br><br>";
	paneContent += '<div id=\"showLegendDiv\" class=\"';
	if(g_bShowLegendDiv) 
		paneContent += "showLegendShow";
	else 
		paneContent += "showLegendHide";
	paneContent += '\">';
	paneContent += '<span>Legend:</span><br><span class="dot" style="background-color:lawngreen"></span> Device Up';
	paneContent += '<br><span class="dot" style="background-color:red"></span> All Devices Down';
	paneContent += '<br><span class="dot" style="background-color:yellow"></span> Some Devices Down';
	paneContent += '<br><span class="dot" style="background-color:cyan"></span> Device Provisioning';
	paneContent += '<br><span class="dot" style="background-color:blue"></span> Device Unprovisioned';
	paneContent += '<br><span class="dot" style="background-color:#BA55D3"></span> Device Not Licensed';
	paneContent += '</div>';
	paneContent += '</div>';
	paneContent += "</div>";
	// may add back		paneContent += "<div class=\"verticalline\"></div>";
	paneContent += "<div id=\"planningPaneDetails\" class=\"planningPaneDetailsShow\">";
	paneContent += "<br><br><br><br>";
	paneContent += "<div class=\"noContentSelected\">No Context Selected</div></div>"
	paneContent += "</div>"
	paneContent += addTopButton();
	document.getElementById("main").innerHTML = paneContent;
	var iDivWidth = document.getElementById("treeDivTree").offsetWidth;
	//document.getElementById("treeDivTree").style.minWidth = iDivWidth + "px"; 
	document.getElementById("treeDivTree").style.width = iDivWidth + "px"; 
	treeviewNodesCollapseNodesInInialCollapseList();
	treeviewSitesPaneContent();
	// adding context to devicesList
	if(planningList.length > 0) {
		if(mode === 0) {
			if(g_iSmartServerVersion >= 280000) {
				try {
					for(i=0; i < deviceList.length; i++)
					{
						if(deviceList[i].contextStr === null) {
							tempStr = "";
							if(!(typeof deviceList[i].contexts === "undefined")) {
								for(k=0; k < deviceList[i].contexts.length; k++)
								{
									for(j=0; j < contextList.length; j++) 
									{
										if(contextList[j].id === deviceList[i].contexts[k]) {
											if(tempStr !== "")
												tempStr += "<br>"
											tempStr += contextList[j].name; //contextList[j].path;
											break;
										}
									}
									
								}
								deviceList[i].contextStr = tempStr;
							}
						}
					}
				}
				catch
				{
					
				}
			}
		}
	}
	if(g_sDemoMode === "basic") {
		if(g_bSingleWebpage) {
			g_bSingleWebpage = false;
			if(g_campusTags.dashboard.length === 1)
				getPlanningTreeShowSiteDashboard(0, true,'_sitedashboard','');
		}
	  }
	
}
function getplanningTreeShowTreeContext(json, level) {
	var result = null;
	if(g_bPlanningTreeShowDatapointNodes) {
		g_treeviewInitialCollapseList = [];
		result =  getplanningTreeShowTreeContextBuilderWithDatapoints(json, -1, null, level,false);
		
	}
	else
		result =  getplanningTreeShowTreeContextBuilderWithDevices(json, level,false);
	
	
	return result;
}
function getplanningTreeShowTreeContextBuilderWithDatapoints(json, devicesId, deviceList, level, bLastChild) {
	// This is the main code for building Planning Tree with Devices, FBs and datapoints in tree.
	// devicesId: this is the previous context id used for the tree
	var sResult = "", sResult1 = "";
	var i,j, k, index, len, obj;
	var iTotal = 0, iUp = 0, iProvisioned = 0, iUnProvisioned = 0, iDown = 0, iUnLicensed = 0;
	var devicesNoContext = [],devicesPByProgramIdList;
	var bContinue = false;
	g_sMapTreeNodeId = -1; // this is used for change tree node colors to show currently selected node 
	
	
	try {
		level++;
		if(json === null)
			return "";
		var lastIndex = json.length - 1;
		if(level === 1) {
			sResult = "";
			
			sResult += "<ul class=\"treeul\">";  // may have a problem with two campuses
			if(g_bSiteDashboard) {
				/*
				//sResult += "<li class=\"treeli treeviewLiActive\"><p style=\"padding-left:5px\">";
				sResult += "<li class=\"treeli\"><p style=\"padding-left:5px\">";
				sResult += "<img src=\"images/navtree/dashboardIcon1.png\">"
				sResult += "<span id=\"planningTreeContext_sitedashboard\"";
				sResult += "\" onclick=\"getPlanningTreeShowSiteDashboard(0, 'sitedashboard')\""
				//sResult += "<ul id=\"treeblocks_Device_" + devicesNoContext[j].id + "\" class=\"treeul treeviewNested treeviewActive\"";
				sResult += " style=\"border-left: 3px solid white;margin-left: -18px;\"";
				sResult += ">Dashboard</span></p>";
				//sResult += ">";
				//sResult += "</ul>";
				sResult += "</li>";
*/				if((planningList.length === 0) || (planningList[0].children.length === 0)) {
					sResult += "<li class=\"treeli\" ><p style=\"padding-left:5px\">";
				}
				else {
					sResult += "<li class=\"treeli\" ><p style=\"padding-left:30px\">";
				}
				// navtree remove sResult += "<li class=\"treeli treeviewLiActiveLastChild\" ><p>";
				sResult += "<img src=\"images/navtree/dashboardIcon1.png\"  onclick=\"getPlanningTreeShowSiteDashboard(0, false,'_sitedashboard','')\">"; //sResult += "<a class=\"context-schedule\" href=\"#\"></a>";
				sResult += "<span id=\"planningTreeContext__sitedashboard\" class=\"treeviewName\" onclick=\"getPlanningTreeShowSiteDashboard(0, false,'_sitedashboard','')\" style=\"margin-left:10px\">Dashboard</span></p></li>";
			}
			if(planningList.length > 0) {
				for(i=0; i < deviceListAll.length; i++)
				{
					if(deviceListAll[i].contexts.length === 0) {
						// later on test if hidden
						devicesNoContext.push(JSON.parse(JSON.stringify(deviceListAll[i])));
					}
				}
			}
			else 
				devicesNoContext = deviceListAll;

		}
		else {
			if(bLastChild)
				sResult = "<ul class=\"treeul treeviewNested treeviewActive\" style=\"border-left: 3px solid white;margin-left: -18px;\">";

			else
				sResult = "<ul class=\"treeul treeviewNested treeviewActive\">";
		}
		bLastChild = false;
		if(planningList.length > 0) {
			if(devicesId !== -1) {// add devices node
				// device status count
				sResult1 = "";
				if(deviceList.length > 0) {
					//sResult1 += " [" + json[i].devices.length + " Devices]";
					sResult1 += " [" + deviceList.length + "]";
					if(checkIfUserTypeSupported(g_bShowDeviceStatusInTree)) {
						sResult1 += "<span id=\"planningTreeContextDeviceStatus_" + devicesId + "\">"
						iTotal = 0; iUp = 0; iProvisioned = 0; iUnProvisioned = 0; iDown = 0; iUnLicensed = 0;
						for(k=0; k < deviceList.length; k++)
						{
							if(deviceList[k].status.state === "provisioned") {
								if(deviceList[k].status.health === "normal")
									iUp ++;
								else {
									if(deviceList[k].category === "SC")
										iUp ++;
									else 
										iDown ++;
								}
							}
							else if(deviceList[k].status.state === "unlicensed")
									iUnLicensed ++;
							else 
								iUnProvisioned ++;
						}
						if((iDown > 0) && ((iDown + iUnProvisioned) === deviceList.length))
							sResult1 += '<span class="dot" style="background-color:red"></span>';
						else if(iDown > 0)
							sResult1 += '<span class="dot" style="background-color:yellow"></span>';
						if(iUnProvisioned > 0)
							sResult1 += '<span class="dot" style="background-color:blue"></span>';
						if(iUnLicensed > 0)
							sResult1 += '<span class="dot" style="background-color:#BA55D3"></span>';
						sResult1 += "</span>";
					}
				}


				sResult += "<li class=\"treeli treeviewLiActive treeviewDevices\"><p>";
				sResult += "<button id=\"treeDevicesButton_" + devicesId + "\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
				g_treeviewInitialCollapseList.push("treeDevicesButton_" + devicesId); // used to initially collapse all devices and device nodes 
				sResult += "<a class=\"context-devices\" href=\"#\"></a>";
				sResult += "<span id=\"planningTreeContext_Devices_" + devicesId + "\" class=\"treeviewName\" onclick=\"treeviewShowContextDevicesInDetailsPane('Devices_" + devicesId + "')\">Devices" + sResult1 + "</span></p>";
				sResult += "<ul id=\"treeblocks_" + devicesId + "\" class=\"treeul treeviewNested treeviewActive\">";
				if(deviceList !== null) {
					for(j=0; j < deviceList.length; j++)
					{
						sResult += "<li class=\"treeli";
						if(j === (deviceList.length - 1))
							sResult += " treeviewLiActive";
						sResult += "\"><p style=\"padding-left:5px\">";
						//sResult += "\"><p>";
						/* remove this is for browser.html
						if(deviceList[j].category === "SC") 
							sResult += "<span class=\"treeviewSpanNoChildrenSegmentController\"></span>";
						else {
							//sResult += "<button id=\"treeDeviceButton_" + deviceList[j].id + "\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle1(this,'treeblocks_Device_" + deviceList[j].id +  "','" + deviceList[j].name  + "')\"></button>";
							sResult += "<button id=\"treeDeviceButton_" + deviceList[j].id + "\" class=\"treeviewCaret\" onclick=\"treeviewToggle1(this,'treeblocks_Device_" + deviceList[j].id +  "','" + deviceList[j].name  + "')\"></button>";
							g_treeviewInitialCollapseList.push("treeDeviceButton_" + deviceList[j].id); // used to initially collapse all devices and device nodes 
						}
*/
				
						sResult += treeviewAddDeviceStatusDot("deviceStatus_" + deviceList[j].id, deviceList[j].name, deviceList[j].status.state , deviceList[j].status.health, deviceList[j].category);
						sResult += "<span id=\"planningTreeContext_Device_" + deviceList[j].id;
						//sResult += "\" onclick=\"getPlanningTreeShowTreeDatapoints(0, 'Device_" + deviceList[j].id + "', '" + deviceList[j].name + "')\">";
						sResult += "\" class=\"treeviewName\" onclick=\"getPlanningTreeShowDashboard1(true, 0, 'Device_" + deviceList[j].id + "', '" + deviceList[j].name + "')\">"; // changed 4/20/22
						sResult += deviceList[j].name + "</span></p>"
						sResult += "<ul id=\"treeblocks_Device_" + deviceList[j].id + "\" class=\"treeul treeviewNested treeviewActive\"";
						if(j === (deviceList.length - 1))
							sResult += " style=\"border-left: 3px solid white;margin-left: -18px;\"";
						sResult += ">";
						sResult += "</ul></li>";
					}
				}
				sResult += "</ul>";
				sResult += "</li>";
				
			}
			
			for(i=0; i < json.length; i++)
			{
				
				if(json[i].children.length > 0) { 
					
					
					// sort children
					if(json[i].children.length === 1)
						bContinue = false;
					else
						bContinue = true;
					while(bContinue)
					{
						bContinue = false;
						len = json[i].children.length - 1;
						for(k=0; k < len; k++)
						{
							if(json[i].children[k].name.toLowerCase() > json[i].children[k + 1].name.toLowerCase()) {
								bContinue = true;
								obj = {};
								obj = JSON.parse(JSON.stringify(json[i].children[k]));
								json[i].children[k] = JSON.parse(JSON.stringify(json[i].children[k + 1]));
								json[i].children[k + 1] = obj;
							}
						}
					}

					//if(i === lastIndex) {
					if((i === lastIndex) && (((level === 1) && (!g_bShowUnassignedDevicesInTree || (devicesNoContext.length === 0)) && !g_bShowCalendar) || (level !== 1))) {
						
						sResult += "<li class=\"treeli treeviewLiActiveLastChild\" ><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
						bLastChild = true;
					}
					else 
						sResult += "<li class=\"treeli treeviewLiActive\"><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
					
					switch(json[i].contextType.toLowerCase()) {
						case "world": sResult += "<a class=\"context-world\" href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; 
							g_sMapTreeNodeId = json[i].id; break;
						case "region": sResult += "<a class=\"context-region\" href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
						case "campus": sResult += "<a class=\"context-campus\" href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
						case "building": sResult += "<a class=\"context-building\" href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
						case "floor": sResult += "<a class=\"context-floor\"  href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
						case "room": sResult += "<a class=\"context-room\"  href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
						case "area": sResult += "<a class=\"context-area\"  href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
					}
					sResult += "<span id=\"planningTreeContext_" + json[i].id + "\" class=\"treeviewName\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\">" + json[i].name;
					
					sResult += "</span></p>";
					devicesId = -1;
					if(json[i].devices.length > 0)
						devicesId = json[i].id;
					sResult += getplanningTreeShowTreeContextBuilderWithDatapoints(json[i].children, devicesId, json[i].devices, level, bLastChild);
					sResult += "</li>";
				}
				else if ((json[i].devices.length > 0) && (checkIfUserTypeSupported(g_bShowDevicesInTree))) {
					// no child contexts but has devices
					if(i === lastIndex) {
						if((level !== 1) || ((level === 1) && (!g_bShowUnassignedDevicesInTree || (devicesNoContext.length === 0)) && !g_bShowCalendar))  {
							sResult += "<li class=\"treeli treeviewLiActiveLastChild\" ><p>";
							bLastChild = true;
						}
						else 
							sResult += "<li class=\"treeli treeviewLiActive\" ><p>";
					}
					else  
						sResult += "<li class=\"treeli treeviewLiActive\" ><p>";
					sResult += "<button id=\"treeContextButton_" + json[i].id + "\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
					
					switch(json[i].contextType.toLowerCase()) {
						case "world": sResult += "<a class=\"context-world\" href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; 
							g_sMapTreeNodeId = json[i].id;  break;
						case "region": sResult += "<a class=\"context-region\" href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
						case "campus": sResult += "<a class=\"context-campus\" href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
						case "building": sResult += "<a class=\"context-building\"  href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
						case "floor": sResult += "<a class=\"context-floor\" href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
						case "room": sResult += "<a class=\"context-room\"  href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
						case "area": sResult += "<a class=\"context-area\"  href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
					}
					sResult += "<span id=\"planningTreeContext_" + json[i].id + "\" class=\"treeviewName\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\">" + json[i].name;
					sResult1 = "";
					if(json[i].devices.length > 0) {
						sResult1 += "   [" + json[i].devices.length + "]";
						if(checkIfUserTypeSupported(g_bShowDeviceStatusInTree)) {
							sResult1 += "<span id=\"planningTreeContextDeviceStatus_" + json[i].id + "\">"
							iTotal = 0; iUp = 0; iProvisioned = 0; iUnProvisioned = 0; iDown = 0; iUnLicensed = 0;
							for(k=0; k < json[i].devices.length; k++)
							{
								if(json[i].devices[k].status.state === "provisioned") {
									if(json[i].devices[k].status.health === "normal")
										iUp ++;
									else {
										if(json[i].devices[k].category === "SC")
											iUp ++;
										else 
											iDown ++;
									}
								}
								else if(json[i].devices[k].status.state === "provisioned")
									iUnLicensed ++;
								else
									iUnProvisioned ++;
							}
							if((iDown > 0) && ((iDown + iUnProvisioned) === json[i].devices.length))
								sResult1 += '<span class="dot" style="background-color:red"></span>';
							else if(iDown > 0)
								sResult1 += '<span class="dot" style="background-color:yellow"></span>';
							if(iUnProvisioned > 0)
								sResult1 += '<span class="dot" style="background-color:blue"></span>';
							if(iUnLicensed > 0)
								sResult1 += '<span class="dot" style="background-color:#BA55D3"></span>';
							sResult1 += "</span>";
						}
					}
					
					sResult += "</span></p>";
					
					// add devices node
					sResult += "<ul class=\"treeul treeviewNested  treeviewActive treeviewDevices\"";
					if(bLastChild)
						sResult += " style=\"border-left: 3px solid white;margin-left: -18px;\"";
					sResult += ">"
					sResult += "<li class=\"treeli treeviewLiActive treeviewDevices\"><p>";
					sResult += "<button id=\"treeDevicesButton_" + json[i].id + "\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
					g_treeviewInitialCollapseList.push("treeDevicesButton_" + json[i].id); // used to initially collapse all devices and device nodes 
					sResult += "<a class=\"context-devices\" href=\"#\"></a>";
					sResult += "<span id=\"planningTreeContext_Devices_" + json[i].id + "\" class=\"treeviewName\" onclick=\"treeviewShowContextDevicesInDetailsPane('Devices_" + json[i].id + "')\">Devices" + sResult1 + "</span></p>";
					sResult += "<ul id=\"treeblocks_" + json[i].id + "\" class=\"treeul treeviewNested treeviewActive\" style=\"border-left: 3px solid white;margin-left: -18px;\">";
					// add device list to tree
					
					for(j=0; j < json[i].devices.length; j++)
					{
						sResult += "<li class=\"treeli treeviewLiActive\"><p style=\"padding-left:5px\">";
						/* remove for navtree
						if(json[i].devices[j].category === "SC") 
							sResult += "<span class=\"treeviewSpanNoChildrenSegmentController\"></span>";
						else {
							//sResult += "<button id=\"treeDeviceButton_" + json[i].devices[j].id + "\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle1(this,'treeblocks_Device_" + json[i].devices[j].id +  "','" + json[i].devices[j].name  + "')\"></button>";
							sResult += "<button id=\"treeDeviceButton_" + json[i].devices[j].id + "\" class=\"treeviewCaret\" onclick=\"treeviewToggle1(this,'treeblocks_Device_" + json[i].devices[j].id +  "','" + json[i].devices[j].name  + "')\"></button>";
							g_treeviewInitialCollapseList.push("treeDeviceButton_" + json[i].devices[j].id); // used to initially collapse all devices and device nodes 
						}
						*/
						
						sResult += treeviewAddDeviceStatusDot("deviceStatus_" + json[i].devices[j].id, json[i].devices[j].name, json[i].devices[j].status.state , json[i].devices[j].status.health, json[i].devices[j].category);
						sResult += "<span id=\"planningTreeContext_Device_" + json[i].devices[j].id + "\"";
						sResult += "\" class=\"treeviewName\" onclick=\"getPlanningTreeShowDashboard1(true, 0, 'Device_" + json[i].devices[j].id + "', '" + json[i].devices[j].name + "')\">";
						// remove for navtree sResult += "\" onclick=\"getPlanningTreeShowTreeDatapoints(0, 'Device_" + json[i].devices[j].id + "', '" + json[i].devices[j].name + "')\">";
						
						sResult += json[i].devices[j].name + "</span></p>"
						sResult += "<ul id=\"treeblocks_Device_" + json[i].devices[j].id + "\" class=\"treeul treeviewNested treeviewActive\"";
						if(j === (json[i].devices.length - 1)) 
							sResult += " style=\"border-left: 3px solid white;margin-left: -18px;\"";
						sResult += ">";
						sResult += "</ul></li>";
					}
					
					sResult += "</ul>";
					sResult += "</li></ul>";
						
					
					sResult += "</li>";
				}
				else { 
					// no child contexts and no devices
					sResult += "<li class=\"treeli\"><p class=\"treeviewNoChildren\">";
					sResult += "<span class=\"treeviewSpanNoChildren\"></span>";
					switch(json[i].contextType.toLowerCase()) {
						case "world": sResult += "<a class=\"context-world\" href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>";  
							g_sMapTreeNodeId = json[i].id;  break;
						case "region": sResult += "<a class=\"context-region\" href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
						case "campus": sResult += "<a class=\"context-campus\" href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
						case "building": sResult += "<a class=\"context-building\"  href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
						case "floor": sResult += "<a class=\"context-floor\" href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
						case "room": sResult += "<a class=\"context-room\"  href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
						case "area": sResult += "<a class=\"context-area\"  href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
					}
					sResult += "<span id=\"planningTreeContext_" + json[i].id + "\" class=\"treeviewName\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\">" + json[i].name;
					sResult += "</span></p>";
					sResult += "</li>";
				}

			} // for(i=0; i < json.length; i++)
		} // if(planningList.length > 0)
		if(level === 1) {
			// add unassinged devices - devices with no context assigned
			g_bShowDeviceListBasedOnProgramId = false;
			if(g_bShowUnassignedDevicesInTree) {
				if(devicesNoContext.length > 0) {
					if(planningList.length > 0) {
						sResult1 = "";
						if(devicesNoContext.length > 0) {
							sResult1 += "   [" + devicesNoContext.length + "]";
							if(g_bShowDeviceStatusInTree) {
								sResult1 += "<span id=\"planningTreeContextDeviceStatus__NoContext\">"
								iTotal = 0; iUp = 0; iProvisioned = 0; iUnProvisioned = 0; iDown = 0; iUnLicensed = 0;
								for(k=0; k < devicesNoContext.length; k++)
								{
									if(devicesNoContext[k].status.state === "provisioned") {
										if(devicesNoContext[k].status.health === "normal")
											iUp ++;
										else {
											if(devicesNoContext[k].category === "SC")
												iUp ++;
											else 
												iDown ++;
										}
									}
									else if(devicesNoContext[k].status.state === "unlicensed")
										iUnLicensed ++;
									else 
										iUnProvisioned ++;
								}
								if((iDown > 0) && ((iDown + iUnProvisioned) === devicesNoContext.length))
									sResult1 += '<span class="dot" style="background-color:red"></span>';
								else if(iDown > 0)
									sResult1 += '<span class="dot" style="background-color:yellow"></span>';
								if(iUnProvisioned > 0)
									sResult1 += '<span class="dot" style="background-color:blue"></span>';
								if(iUnLicensed > 0)
									sResult1 += '<span class="dot" style="background-color:#BA55D3"></span>';
								sResult1 += "</span>";
							}
						}



						if(g_bShowCalendar)
							sResult += "<li class=\"treeli treeviewLiActive\" ><p>";
						else
							sResult += "<li class=\"treeli treeviewLiActiveLastChild\" ><p>";
						sResult += "<button id=\"treeContextButton__NoContext\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
						sResult += "<a class=\"context-devices\" href=\"#\"></a>";
						sResult += "<span id=\"planningTreeContext__NoContext\" class=\"treeviewName\" onclick=\"getPlanningTreeShowTreeDetails(0, '_NoContext')\">Un-assigned Devices" + sResult1;
						sResult += "</span></p>";
	//navtree remove??					g_treeviewInitialCollapseList.push("planningTreeContext__NoContext"); // used to initially collapse all devices and device nodes navtree not sure this works
						// add devices node
						sResult += "<ul class=\"treeul treeviewNested  treeviewActive treeviewDevices\"";
						//if(bLastChild)
						if(!g_bShowCalendar)
							sResult += " style=\"border-left: 3px solid white;margin-left: -18px;\"";
						sResult += ">"
					}

					bContinue = false;
					
					devicesPByProgramIdList = [];
					obj = {};
					if(g_bShowDeviceListBasedOnProgramId) {
						obj = sortDeviceList(0,devicesNoContext);
						if(obj.valid) {
							devicesPByProgramIdList = JSON.parse(JSON.stringify(obj.deviceList));
							bContinue = true;
						}
					}
					if(bContinue) {
						// device programId list
						sResult += "<li class=\"treeli treeviewLiActive treeviewDevices\"><p>";
						sResult += "<button id=\"treeDevicesButton__NoContext\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
						g_treeviewInitialCollapseList.push("treeDevicesButton__NoContext"); // used to initially collapse all devices and device nodes 
						sResult += "<a class=\"context-devices\" href=\"#\"></a>";
						sResult += "<span id=\"planningTreeContext_Devices__NoContext" + "\" onclick=\"treeviewShowContextDevicesInDetailsPane('_NoContext')\">Device Types</span></p>";
						sResult += "<ul id=\"treeblocks_NoContext\" class=\"treeul treeviewNested treeviewActive\" style=\"border-left: 3px solid white;margin-left: -18px;\">";


						for(k=0; k < devicesPByProgramIdList.length; k++)
						{
							sResult1 = devicesPByProgramIdList[k].deviceTypeName + " [" + devicesPByProgramIdList[k].deviceList.length + "]";

							if(checkIfUserTypeSupported(g_bShowDeviceStatusInTree)) {
								sResult1 += "<span id=\"planningTreeContextDeviceStatus__NoContext\">"
								iTotal = 0; iUp = 0; iProvisioned = 0; iUnProvisioned = 0; iDown = 0; iUnLicensed = 0;
								for(j=0; j < devicesPByProgramIdList[k].deviceList.length; j++)
								{
									if(devicesPByProgramIdList[k].deviceList[j].status.state === "provisioned") {
										if(devicesPByProgramIdList[k].deviceList[j].status.health === "normal")
											iUp ++;
										else {
											if(devicesPByProgramIdList[k].deviceList[j].category === "SC")
												iUp ++;
											else 
												iDown ++;
										}
									}
									else if(devicesPByProgramIdList[k].deviceList[j].status.state === "unlicensed")
										iUnLicensed ++;
									else 
										iUnProvisioned ++;
								}
								if((iDown > 0) && ((iDown + iUnProvisioned) === devicesPByProgramIdList[k].deviceList.length))
									sResult1 += '<span class="dot" style="background-color:red"></span>';
								else if(iDown > 0)
									sResult1 += '<span class="dot" style="background-color:yellow"></span>';
								if(iUnProvisioned > 0)
									sResult1 += '<span class="dot" style="background-color:blue"></span>';
								if(iUnLicensed > 0)
									sResult1 += '<span class="dot" style="background-color:#BA55D3"></span>';
								sResult1 += "</span>";
							}



							sResult += "<li class=\"treeli treeviewLiActive treeviewDevices\"><p>";
							sResult += "<button id=\"treeDevicesButton__NoContext\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
							g_treeviewInitialCollapseList.push("treeDevicesButton__NoContext"); // used to initially collapse all devices and device nodes 
							sResult += "<a class=\"context-devices\" href=\"#\"></a>";
							sResult += "<span id=\"planningTreeContext_Devices__NoContext" + "\" onclick=\"treeviewShowContextDevicesInDetailsPane('_NoContext')\">" + sResult1 + "</span></p>";
							sResult += "<ul id=\"treeblocks_NoContext\" class=\"treeul treeviewNested treeviewActive\" style=\"border-left: 3px solid white;margin-left: -18px;\">";
							for(j=0; j < devicesPByProgramIdList[k].deviceList.length; j++)
							{ 
								sResult += "<li class=\"treeli treeviewLiActive\"><p style=\"padding-left:5px\">";
								sResult += treeviewAddDeviceStatusDot("deviceStatus_" + devicesPByProgramIdList[k].deviceList[j].id, devicesPByProgramIdList[k].deviceList[j].name, 
									devicesPByProgramIdList[k].deviceList[j].status.state , devicesPByProgramIdList[k].deviceList[j].status.health, devicesPByProgramIdList[k].deviceList[j].category);
								sResult += "<span id=\"planningTreeContext_Device_" + devicesPByProgramIdList[k].deviceList[j].id + "\"";
								sResult += "\" class=\"treeviewName\" onclick=\"getPlanningTreeShowDashboard1(true, 0, 'Device_" + devicesPByProgramIdList[k].deviceList[j].id + "', '" + devicesPByProgramIdList[k].deviceList[j].name + "')\">";
								// remove navtree sResult += "\" onclick=\"getPlanningTreeShowTreeDatapoints(0, 'Device_" + devicesNoContext[j].id + "', '" + devicesNoContext[j].name + "')\">";
								
								sResult += devicesPByProgramIdList[k].deviceList[j].name + "</span></p>"
								sResult += "<ul id=\"treeblocks_Device_" + devicesPByProgramIdList[k].deviceList[j].id + "\" class=\"treeul treeviewNested treeviewActive\"";
								if(j === (devicesPByProgramIdList[k].deviceList.length - 1)) 
									sResult += " style=\"border-left: 3px solid white;margin-left: -18px;\"";
								sResult += ">";
								sResult += "</ul></li>";
							}
							sResult += "</ul>";
							sResult += "</li>";
						}
						sResult += "</ul>";
						sResult += "</li>";

					}
					else {
						// one big device list
						if(g_bMapEnabled) {
							if((level === 1) && (!g_bShowCalendar))  {
								sResult += "<li class=\"treeli treeviewLiActiveLastChild\" ><p>";
								bLastChild = true;
							}
							else 
								sResult += "<li class=\"treeli treeviewLiActive\" ><p>";
							
							sResult += "<a class=\"context-world\" href=\"#\" onclick=\"showMap(0,'World','World','WORLD', 0, 0)\"></a>";
							sResult += "<span id=\"planningTreeContext_0\" class=\"treeviewName\" onclick=\"showMap(0,'World','World','WORLD', 0, 0)\">World";
							g_sMapTreeNodeId = "0";
							sResult += "</span></p>";
							sResult += "<ul class=\"treeul treeviewNested  treeviewActive treeviewDevices\"";
							if(bLastChild)
								sResult += " style=\"border-left: 3px solid white;margin-left: -18px;\"";
							sResult += ">"
							
						}
						for(j=0; j < devicesNoContext.length; j++)
						{
							sResult += "<li class=\"treeli treeviewLiActive\"><p style=\"padding-left:5px\">";
							/* remove for navtree
							
							if(devicesNoContext[j].category === "SC") 
								sResult += "<span class=\"treeviewSpanNoChildrenSegmentController\"></span>";
							else {
								//sResult += "<button id=\"treeDeviceButton_" + devicesNoContext[j].id + "\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle1(this,'treeblocks_Device_" + devicesNoContext[j].id +  "','" + devicesNoContext[j].name  + "')\"></button>";
								sResult += "<button id=\"treeDeviceButton_" + devicesNoContext[j].id + "\" class=\"treeviewCaret\" onclick=\"treeviewToggle1(this,'treeblocks_Device_" + devicesNoContext[j].id +  "','" + devicesNoContext[j].name  + "')\"></button>";
								g_treeviewInitialCollapseList.push("treeDeviceButton_" + devicesNoContext[j].id); // used to initially collapse all devices and device nodes 
							}
							*/
							sResult += treeviewAddDeviceStatusDot("deviceStatus_" + devicesNoContext[j].id, devicesNoContext[j].name, devicesNoContext[j].status.state , devicesNoContext[j].status.health, devicesNoContext[j].category);
							sResult += "<span id=\"planningTreeContext_Device_" + devicesNoContext[j].id + "\"";
							sResult += "\" class=\"treeviewName\" onclick=\"getPlanningTreeShowDashboard1(true, 0, 'Device_" + devicesNoContext[j].id + "', '" + devicesNoContext[j].name + "')\">";
							// remove navtree sResult += "\" onclick=\"getPlanningTreeShowTreeDatapoints(0, 'Device_" + devicesNoContext[j].id + "', '" + devicesNoContext[j].name + "')\">";
							
							sResult += devicesNoContext[j].name + "</span></p>"
							sResult += "<ul id=\"treeblocks_Device_" + devicesNoContext[j].id + "\" class=\"treeul treeviewNested treeviewActive\"";
							if(j === (devicesNoContext.length - 1)) 
								sResult += " style=\"border-left: 3px solid white;margin-left: -18px;\"";
							sResult += ">";
							sResult += "</ul></li>";
						}
						if(g_bMapEnabled) {
							sResult += "</ul></li>";
						}
					}
						
					if(planningList.length > 0)
						sResult += "</ul></li>";
				}
			} //g_bShowUnassignedDevicesInTree
			if(g_bShowCalendar) {
				sResult += "<li class=\"treeli\" ><p style=\"padding-left:30px\">";
				// navtree remove sResult += "<li class=\"treeli treeviewLiActiveLastChild\" ><p>";
				sResult += "<img src=\"images/navtree/calendarIcon1.png\">"; //sResult += "<a class=\"context-schedule\" href=\"#\"></a>";
				sResult += "<span id=\"planningTreeContext__TreeSchedules\" class=\"treeviewName\" onclick=\"showPlanningTreeCalendar(0)\" style=\"margin-left:10px\">Schedules</span></p></li>";
			}
		}
		sResult += "</ul>";
	} catch (err) {
		 sResult = "<ul></ul>"; }
	if(level === 1) {
		sResult1 = "Sites";
		if(json.length === 0)
			sResult1 = "Site";
		sResult = "<span id=\"planningTreeContext___sites__\"  class=\"treeviewName\" onclick=\"getPlanningTreeShowTreeDetails(0, '__sites__')\">" + sResult1 + "</span><br>" + sResult; //"Sites<br><div style=\"padding-left:17px\">" + sResult + "</div>"; 
	}
	return sResult;
}

function getplanningTreeShowTreeContextBuilderWithDevices(json, level, bLastChild) {
	// This is the main code for building Planning Tree which shows devices in detail pane but not in the tree
	var sResult = "";
	var i,j, k, index, len, obj;
	var iTotal = 0, iUp = 0, iProvisioned = 0, iUnProvisioned = 0, iDown = 0, iUnLicensed = 0;
	var bContinue = false;
	
	try {
		level++;
		if(json === null)
			return "";
		var lastIndex = json.length - 1;
		if(level === 1) {
			//if(json.length === 1)
			//	sResult = "<ul style=\"border-left: 1px solid #366184;margin-left: -17px;\">"; // try height:8px;
			//else
				sResult = "<ul class=\"treeul\">";  // may have a problem with two campuses
		}
		else {
			//if((level === 2) && bLastChild)
			//	sResult = "<ul class=\"treeviewNested treeviewActive\" style=\"border-left: 1px solid #366184;height:0px\">"; // needed as issue on some display with Site line too long
			//else if(bLastChild)
			if(bLastChild)
				sResult = "<ul class=\"treeul treeviewNested treeviewActive\" style=\"border-left: 3px solid white;margin-left: -18px;\">";

			else
				sResult = "<ul class=\"treeul treeviewNested treeviewActive\">";
		}
		bLastChild = false;
		
		for(i=0; i < json.length; i++)
		{
			if(json[i].children.length > 0) { 
				// sort children
				if(json[i].children.length === 1)
					bContinue = false;
				else
					bContinue = true;
				while(bContinue)
				{
					bContinue = false;
					len = json[i].children.length - 1;
					for(k=0; k < len; k++)
					{
						if(json[i].children[k].name.toLowerCase() > json[i].children[k + 1].name.toLowerCase()) {
							bContinue = true;
							obj = {};
							obj = JSON.parse(JSON.stringify(json[i].children[k]));
							json[i].children[k] = JSON.parse(JSON.stringify(json[i].children[k + 1]));
							json[i].children[k + 1] = obj;
						}
					}
				}


				if(i === lastIndex) {
					//sResult += "<li class=\"treeviewLiActive\" style=\"border-bottom:0px\"><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
					sResult += "<li class=\"treeli treeviewLiActiveLastChild\" ><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
					bLastChild = true;
				}
				else 
					sResult += "<li class=\"treeli treeviewLiActive\"><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
				switch(json[i].contextType.toLowerCase()) {
					case "region": sResult += "<a class=\"context-region\" href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
					case "campus": sResult += "<a class=\"context-campus\" href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
					case "building": sResult += "<a class=\"context-building\" href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
					case "floor": sResult += "<a class=\"context-floor\"  href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
					case "room": sResult += "<a class=\"context-room\"  href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
					case "area": sResult += "<a class=\"context-area\"  href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
				}
				//sResult += "<img class=\"icon-context-type-building\" src=\"\" width=\"1\" height=\"1\">"; 
					//sResult += "<li class=\"icon1-context-type-building\"></li>";  // Test
					//sResult += "<span class=\"material-icons icon-context-type-building\"></span>";  // Test
				//sResult += "<span class=\"context-icons\">&#x00E;</span>";  // Test
				sResult += "<span id=\"planningTreeContext_" + json[i].id + "\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\">" + json[i].name;
				//sResult += "        (" + json[i].contextType.toLowerCase() + ")";
				if(json[i].devices.length > 0) {
					sResult += " [" + json[i].devices.length + " Devices]";
					if(checkIfUserTypeSupported(g_bShowDeviceStatusInTree)) {
						iTotal = 0; iUp = 0; iProvisioned = 0; iUnProvisioned = 0; iDown = 0; iUnLicensed = 0;
						for(k=0; k < json[i].devices.length; k++)
						{
							if(json[i].devices[k].status.state === "provisioned") {
								if(json[i].devices[k].status.health === "normal")
									iUp ++;
								else {
									if(json[i].devices[k].category === "SC")
										iUp ++;
									else 
										iDown ++;
								}
							}
							else if(json[i].devices[k].status.state === "provisioned")
									iUnLicensed ++;
							else 
								iUnProvisioned ++;
						}
						if((iDown > 0) && ((iDown + iUnProvisioned) === json[i].devices.length))
							sResult += '<span class="dot" style="background-color:red"></span>';
						else if(iDown > 0)
							sResult += '<span class="dot" style="background-color:yellow"></span>';
						if(iUnProvisioned > 0)
							sResult += '<span class="dot" style="background-color:blue"></span>';
						if(iUnLicensed > 0)
							sResult1 += '<span class="dot" style="background-color:#BA55D3"></span>';
					}
				}
				sResult += "</span></p>";
				sResult += getplanningTreeShowTreeContextBuilderWithDevices(json[i].children, level, bLastChild);
				sResult += "</li>";
			}
			else { 
				
				sResult += "<li class=\"treeli\"><p class=\"treeviewNoChildren\">";
				switch(json[i].contextType.toLowerCase()) {
					case "region": sResult += "<a class=\"context-region\" href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
					case "campus": sResult += "<a class=\"context-campus\" href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
					case "building": sResult += "<a class=\"context-building\"  href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
					case "floor": sResult += "<a class=\"context-floor\" href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
					case "room": sResult += "<a class=\"context-room\"  href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
					case "area": sResult += "<a class=\"context-area\"  href=\"#\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\"></a>"; break;
				}
				sResult += "<span id=\"planningTreeContext_" + json[i].id + "\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\">" + json[i].name;
				//sResult += "        (" + json[i].contextType.toLowerCase() + ")";
				if(json[i].devices.length > 0) {
					sResult += "   [" + json[i].devices.length + " Devices]";
					if(checkIfUserTypeSupported(g_bShowDeviceStatusInTree)) {
						iTotal = 0; iUp = 0; iProvisioned = 0; iUnProvisioned = 0; iDown = 0; iUnLicensed = 0;
						for(k=0; k < json[i].devices.length; k++)
						{
							if(json[i].devices[k].status.state === "provisioned") {
								if(json[i].devices[k].status.health === "normal")
									iUp ++;
								else {
									if(json[i].devices[k].category === "SC")
										iUp ++;
									else 
										iDown ++;
								}
							}
							else if(json[i].devices[k].status.state === "unlicensed")
									iUnLicensed ++;
							else 
								iUnProvisioned ++;
						}
						if((iDown > 0) && ((iDown + iUnProvisioned) === json[i].devices.length))
							sResult += '<span class="dot" style="background-color:red"></span>';
						else if(iDown > 0)
							sResult += '<span class="dot" style="background-color:yellow"></span>';
						if(iUnProvisioned > 0)
							sResult += '<span class="dot" style="background-color:blue"></span>';
						if(iUnLicensed > 0)
							sResult1 += '<span class="dot" style="background-color:#BA55D3"></span>';
					}
				}
				sResult += "</span></p></li>";
			}
		}
		sResult += "</ul>";
	} catch { sResult = "<ul></ul>"; }
	if(level === 1) {
		sResult = "Sites<br>" + sResult; //"Sites<br><div style=\"padding-left:17px\">" + sResult + "</div>"; 
	}
	return sResult;
}
function getPlanningTreeShowDeviceDetails() {

}
function getPlanningTreeShowTreeDevices(id) {
	try {
		var sResult = "", i;
		var list = [];
		var bContinue = false;
		var json, json1;
		document.getElementById("planningPaneDetails").style.display = "inline-block";
		json = getPlanningTreeShowTreeDetailsGetObj(planningList, id, 0);
		if(json === null)
			document.getElementById("planningPaneDetails").innerHTML = "<br>" + json['path'] + "<br><br>No Devices";
		else {
			// sort
			
			while(bContinue)
			{
				bContinue = false;
				for(i=0; i < json.length; i)
				{

				}
			}
			list = json["devices"];
			if(list.length === 0 ){
				document.getElementById("planningPaneDetails").innerHTML = "<br>" + json['path'] + "<br><br>No Devices";
			}
			else {
				for(i = 0; i < list.length; i++)
				{
					
					if(typeof list[i].id !== "number") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					else if (typeof list[i].name !== "string") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					else if (typeof list[i].deviceTypeName !== "string") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					//sResult += "<tr class=\"planningdevicetableTr\"><td><button class=\"clickabletext\" onclick=\"showDeviceByName(0, '" + list[i].name + "')\">" + list[i].name + "</button></td></tr>"; //ffix
					
					
					sResult += "<tr class=\"planningdevicetableTr\"><td class=\"planningdevicetableTd\">";
					sResult += "<div><canvas id=\"canvas_" + list[i].name +"\" width=\"12\" height=\"12\"></canvas></div>"; 
					

					sResult += "</td><td class=\"planningdevicetableTd\"><button id=\"deviceMenu_" + list[i].name + "\" class=\"clickabletext\"";
					sResult += " onclick=\"menuDevice(1, event," + list[i].id + ", '" + list[i].name  + "', '" + list[i].deviceTypeName  + "', '" + list[i].protocol  + "')\">";
					sResult += list[i].name + "</button></td></tr>"; 
				}
				
				if(sResult !== "") { 
					//sResult = "<hr><div class=\"planningdevicetableDiv\"><table id=\"myTablePlanningTree\" class=\"planningdevicetable\"><tbody>" + sResult + "</tbody></table></div>";
					sResult = "<div class=\"planningdevicetableDiv\"><table id=\"myTablePlanningTree\" class=\"planningdevicetable\"><tbody>" + sResult + "</tbody></table></div>";
					sResult = "<br>" + json['path'] + "<button style=\"margin-left:40px;\" onclick=\"showContextDevices(" + id + ")\">Show Devices Detail</button><br><br>" + sResult;
					document.getElementById("planningPaneDetails").innerHTML = sResult;
					//sortTable(0); 
				}
				if(sResult !== "") {
					for(i = 0; i < list.length; i++)
					{
						deviceStatusColorCanvas("canvas_" + list[i].name, list[i].category,list[i].deviceStatus);
						//deviceStatusColor("canvas_" + list[i].id, list[i].deviceStatus);
					}
				}
			}
		}
	}
	catch {}
}
function getPlanningTreeShowTreeDatapoints(mode, id, programmaticPathname) {
	var json;
	var sResult = "";
	var sTemp;
	var bContinue = false;
	var sResults;
	var x, i;
	var treeContext = null;
	try {
		if(programmaticPathname === "")
			return;
		planningDpList = [];
		g_iPlanningPaneSelectedContextType = 2;
		planningMenuCancel();
		testDeviceCancel();
		if(g_planningDpTimerId !== 0)
				clearTimeout(g_planningDpTimerId);
		g_sPlanningTreeDatapointPath = programmaticPathname; // only used for Devices and Datapoints nodes
		document.getElementById("planningContextDetailsDiv").style.visibility = "hidden";
		document.getElementById("planningRefreshButton").style.visibility = "hidden";
		if(mode === 0) {
			// change color of tree context to indicate selected
			if(g_iPlanningPaneSelectedContextId !== -1) {
				treeContext = document.getElementById("planningTreeContext_" + g_iPlanningPaneSelectedContextId);
				if(treeContext !== null) {
					treeContext.classList.remove("treeSelected")
					//treeContext.style.color = "white";
				}
			}
			treeContext = document.getElementById("planningTreeContext_" + id);
			if(treeContext !== null) {
				//treeContext.style.color = "red";
				treeContext.classList.add("treeSelected")
			}
		}
		g_iPlanningPaneSelectedContextId = id;
		document.getElementById("planningPaneDetails").innerHTML = "Getting Datapoint information...";
		getPlanningTreeShowTreeDatapointsRequest(0, programmaticPathname); 
		
	}
	catch {}
}
function getPlanningTreeShowTreeDatapointsRequest(mode, path) {
	try {
 		var url = "/iap/devs/*+name==";
		var iPtr = path.indexOf("/");
		var obj = {}; 
		if(mode > 0)
			path = g_sPlanningTreeDatapointPath;
		iPtr = path.indexOf("/");
		if(iPtr === -1) 
			url += path + "/if/*/*/*";
		else {
			url += path.substr(0, iPtr) + "/if" + path.substr(iPtr);
			url = encodeNameStr(url);
			if(g_iSmartServerVersion >= 320114) {
				iPtr = url.lastIndexOf("/");
				if(iPtr > 0) {
					iPtr ++;
					url = url.substr(0, iPtr) + "*+xifName==" + url.substr(iPtr);
				}
			}
			
		}
		url += "/*"
		if(mode === 3)
			url += "?max_age=0&noxs=true";
		else
			url += "?noxs=true";
		if(checkIfUserTypeSupported(g_useVisibilityFilter))
			url += "&visible=true";
		obj.mode = mode;
		obj.path = path;
		if(mode === 0)
			cursorSetWait();
 		requestGetData(obj, url, getPlanningTreeShowTreeDatapointsRequestDataResponse, getPlanningTreeRequestFailure);
	}
	catch (err) {}

}

function getPlanningTreeShowTreeDatapointsRequestProcessWebSocketData(mode, requestUrl, json) {
	var obj = {};
	obj.mode = mode;
	obj.path = g_sPlanningTreeDatapointPath;
	getPlanningTreeShowTreeDatapointsRequestDataResponse(obj, requestUrl, json);
}
function getPlanningTreeShowTreeDatapointsRequestDataResponse(obj, requestUrl, json) {
	// mode: 0=creat table, 1= 2=Websocket, 3= on demandfollowup request, 4=refresh [same as 0 but don't create table]
	// Table data
	try {
		
		var iPtr, i, j, z, index = 0;
		var buttonPathname = "", buttonProgrammaticPathname = "", pathname, protocol = "lon";
		var dpPath = "", value, valueStr, fullPath,z, lon_cfg, temp, id = -1, bRequestFollowupRead = false;
		var bDevice = false, bContinue = true, bContinue1 = false, timestamp1,local,utc, bHasPresets, name1, deviceName = "";
		var bSingleDp = false, sTemp = "";
		var element;
		var content = "<br><br><table id=\"myTable\"><thead><tr><th onclick=\"sortTable(0)\">#</th>";
		var path = obj.path;
		var mode = obj.mode;
		var newPath = path;
		var obj, bLonProtocol = false;;
		var d = new Date;
		var sortIndex = 0;
		var t = d.toTimeString();
		//var date = d.toLocaleDateString();
		//var dates = date.split("/");
		var currentTime = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";//dates[2] + "-" + dates[1] + "-" +  dates[0] + " ";
		iPtr = t.indexOf(" ");
		t = t.substr(0, iPtr);
		currentTime += t;
		
		if(g_sPlanningTreeDatapointPath !== path)
			return;
		if(mode > 0) {
			if(planningDpList.length === 0)
				return;
		}
		if(json.length === 0) {
			if(mode === 0) {
				cursorClearWait();
			}
			document.getElementById("planningPaneDetails").innerHTML = "No Datapoints For this Device";
			return;
		}
		
		if(mode === 0) {
			g_bPlanningShowConfigurationSingleDp = false;
			content += "<th><div style=\"display:flex\"><input type=\"checkbox\" id=\"favoritesCheckbox\" onclick=\"planningFavoritesCheckbox()\">FAV</div></th>";
			content += "<th>Menu</th><th onclick=\"sortTable(3)\">Datapoint Path</th><th onclick=\"sortTable(4)\">Datapoint</th><th onclick=\"sortTable(5)\">Value</th>"; 
			content += "<th onclick=\"sortTable(4)\">Priority</th>";
			sortIndex = 5;
			bLonProtocol = false;
			if(json.length > 1) {
				if(typeof json[0]["lon.cfg"] !== "undefined") 
					bLonProtocol = true;
					
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Units</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Direction</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Type</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">XIF DP Path</th>";
				//content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">DP Properties (Device Type)</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Property</th>";
				if(bLonProtocol)
					content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Property For</th>";
				
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Read-only</th>"
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Monitor Rate</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Monitor Event</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Monitor Throttle</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Monitor Heartbeat</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Monitor Threshold</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Monitor ReceiveTimeout</th>";
				if(bLonProtocol) {
					content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Propagation Throttle</th>";
					content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Propagation Heartbeat</th>";
					content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Propagation Threshold</th>";
				}
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Localization</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Presets</th>";
				if(bLonProtocol)
					content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Description</th>";
				if(!bLonProtocol)
					content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Default</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Initial Value</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Write Initial</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Interface</th>"

			}
			
			content += "</tr></thead><tbody>";
		}
		if(mode === 2) {
			for(i=0; i < json.length; i++)
			{ // check if in
				z = -1; 
				for(j=0; j < planningDpList.length; j++)
				{
					if(json[i].datapointQualifier === planningDpList[j].dpQualifier) {
						json[i].bProcess = true;
						json[i].dpPath = planningDpList[j].dpPath;
						json[i].dpName = planningDpList[j].dpName;
						json[i].pathname = planningDpList[j].pathname;
						json[i].block = planningDpList[j].block;
						json[i].programmaticPathname = planningDpList[j].programmaticPathname; 
						json[i].urlPath = planningDpList[j].urlPath;
						z = j;
						break;
					}
				}
				if(z === -1)
					json[i].bProcess = false;
			}
		}
		else {
			iPtr = path.indexOf("/");
			if(mode === 3) {
				mode = 1;
				bRequestFollowupRead = true;
			}
			
			if(iPtr === -1) {
				bDevice = true;
				
				
			}
			else {
				
			}
		}
		if(mode === 0) {
			planningDpList = [];
			temp = "";
			if(bDevice) {
				id = -1;
				for(i=0; i < deviceListAll.length; i++)
				{
					if(deviceListAll[i].name === path) {
						id = deviceListAll[i].id;
						newPath += " [" + deviceListAll[i].deviceTypeName + " (" + deviceListAll[i].protocol  + ")]";
						protocol = deviceListAll[i].protocol;
						deviceName = deviceListAll[i].name;
						break;
					}
				}
				temp = "<button onclick=\"showDashboard(1, '" + path + "', " + id + ")\" style=\"margin-left:0px\">Dashboard</button>";
			}
			else 
				temp = "<button onclick=\"planningshowDashboard()\" style=\"margin-left:0px\">Dashboard</button>";
			temp += "<button onclick=\"showDashboard(3,'Favorites',-1)\">FAV Dashboard</button>";
			if(bDevice)
				//temp += "<button  onclick=\"showDataLogForDevice('" + g_sPlanningTreeDatapointPath + "','" + g_sPlanningTreeDatapointPath + "',null)\">Logs</button>";
				temp += "<button  onclick=\"showDataLog3('" + g_sPlanningTreeDatapointPath + "','" + g_sPlanningTreeDatapointPath + "',null)\">Logs</button>";
			else if(json.length === 1) {
				buttonPathname = json[0].deviceName + "/" + json[0].blockName + "/" + json[0].blockIndex + "/";
				if(typeof json[0].name === "")
					buttonPathname +=  json[0].datapointName;
				if(json[0].name === null)
					buttonPathname +=  json[0].datapointName;
				else
					buttonPathname +=  json[0].name;
				buttonProgrammaticPathname = json[0].deviceName + "/" + json[0].blockName + "/" + json[0].blockIndex + "/" + json[0].datapointName;
				newPath = buttonPathname;
				temp += "<button onclick=\"showDataLog3('" + buttonPathname + "','" + buttonProgrammaticPathname + "',null)\">Logs</button>";
			}
			if(bDevice) {
				temp += "<button onclick=\"showDeviceDpsByDeviceName(0,'" + deviceName + "')\">Datapoints</button>";
			}
			else {
				temp += "<button  onclick=\"planningshowDpInShowDatapoints(0,'" + buttonPathname + "','" + buttonProgrammaticPathname + "')\">Datapoints</button>";
			}
			temp += "<button id=\"planningDpInfoButton\" "; 
			if(bDevice)
				temp += "onclick=\"showDpInfo1(1,'" + g_sPlanningTreeDatapointPath + "','" + g_sPlanningTreeDatapointPath + "')\"";
			else if(json.length === 1) {
				
				temp += "onclick=\"showDpInfo1(1,'" + buttonPathname + "','" + buttonProgrammaticPathname + "')\"";
			}
			temp += ">DP Info</button>"
			if(bDevice) {
				temp += "<button id=\"testButton_" + g_sPlanningTreeDatapointPath + "\" onclick=\"testDevice(6, this," + id + ", '" + g_sPlanningTreeDatapointPath + "')\">Test</button>";
				temp += "<button  onclick=\"winkDevice(" + id + ", '" + g_sPlanningTreeDatapointPath + "')\"";
				if(protocol !== "lon")
					temp += " disabled";
				temp += ">Wink</button>";
			} 
			if(json.length === 1) 
				temp += "<input type=\"checkbox\" id=\"planningConfigCheckbox\"  onchange=\"treeShowConfiguration()\"";
			else 
				temp += "<input type=\"checkbox\" id=\"planningConfigCheckbox\"  onchange=\"treeShowConfigurationAll()\"";
			if(g_bPlanningShowConfiguration) 
				temp += " checked";
			temp += ">Properties";
			
			temp += "<input type=\"checkbox\" id=\"planningPollCheckbox\"  onchange=\"planningPollCheckBox()\"";
			if(g_bPlanningDpPollingEnabled) 
				temp += " checked";
			temp += ">Poll";
			temp += "<input id=\"planningPollrate\" onchange=\"planningPollCheckBox()\" value=\"" + g_iPlanningPollInterval + "\" size=\"4\"></div>";
			temp += "<button onclick=\"getPlanningTreeShowTreeDatapointsRequest(3, '')\">On Demand</button>";
			temp += "<button onclick=\"subscribeRequest()\">Re-Subscribe</button>";
			
			temp += "<button onclick=\"getPlanningTreeShowTreeDatapointsRequest(1, '')\">Refresh</button>";
				// remove hiddencheckbox only in datapoints view temp += "<input type=\"checkbox\" id=\"hiddencheckbox\"  onchange=\"planningShowHiddenCheckBox()\"";
				//if(g_bPlanningDpPollingEnabled) 
				//	temp += " checked";
				//temp += ">Show Hidden DPs";
			
			
			content = newPath + "<br><br>" + temp + content; //json[0].deviceName + temp + content;
			
		}
			
		for(i=0; i < json.length; i++)
		{
			// a lot of the additions are for favorites view
			if(typeof json[i].values !== "undefined") {
				if(typeof json[i].values.level !== "undefined") {
					if(typeof json[i].values.level === "string") 
						json[i].values.level = Number(json[i].values.level);
				}
			}
			if(mode !== 2) {
				dpPath = json[i].blockName + "/" + json[i].blockIndex + "/"
				if(typeof json[i].name !== "undefined"){
					if(json[i].name !== null){
						dpPath += json[i].name;
					}
					else {
						dpPath += json[i].datapointName;
						json[i].name = json[i].datapointName;
					}
				}
				else {
					dpPath += json[i].datapointName;
					json[i].name = json[i].datapointName;
				}
				json[i].dpPath = dpPath;
				json[i].dpName = json[i].name;
				json[i].pathname = json[i].deviceName + "/" + dpPath;
				json[i].block = json[i].blockName + "/" + json[i].blockIndex;
				json[i].programmaticPathname = json[i].deviceName + "/" + json[i].blockName + "/" + json[i].blockIndex + "/" + json[i].datapointName; 
				json[i].urlPath = json[i].deviceName + "/if/" + json[i].blockName + "/" + json[i].blockIndex + "/";
				if(g_iSmartServerVersion >= 320114)
					json[i].urlPath += "*+xifName==";
				json[i].urlPath += json[i].datapointName;
				try {
					json[i].priority = json[i].values.level;
				}
				catch (err) {}
				
			}
			if(mode === 0) {
				try {
					json[i].priority = json[i].values.level;
				}
				catch (err) {}
				try { 
					if(!json[i].hasOwnProperty("hidden")) {
						json[i].hidden = false;
					}
					json[i].unit = "";
					if(json[i].hasOwnProperty("lon.cfg")) {
						lon_cfg = json[i]["lon.cfg"];
						json[i].unit = lon_cfg.unit;
						json[i].hidden = lon_cfg.hidden;
					}
				} catch (err) 	{
					json[i].unit = "";
					json[i].hidden = false;
				} 
			}
			if(typeof json[i].locValue === "number")
				json[i].valueStr = json[i].value.toString();
			else
				json[i].valueStr = JSON.stringify(json[i].value);
			try { 
				if(!(typeof json[i].locValue === "undefined")) {
					json[i].locValue = json[i].value; // GET request
					if(json[i].locValue !== null) {
						if(json[i].locValue !== "")
							if(typeof json[i].locValue === "number")
								json[i].locValueStr = json[i].locValue.toString();
							else
								json[i].locValueStr = JSON.stringify(json[i].locValue);
						}
						else 
							json[i].locValueStr = "";
					}
				else 
					json[i].locValueStr = "";
			} catch (err) {}
			
			try {
				if(typeof json[i].local === "undefined") {
					local = currentTime;
					utc = "";
				}
				else 
					local = json[i].local;

				timestamp1 = local;
				local = timestamp1;
				iPtr = timestamp1.lastIndexOf("[");
				if(iPtr > 0) {
					iPtr = timestamp1.lastIndexOf("-",iPtr);
					if(iPtr > 0) {
						timestamp1 = timestamp1.substr(0, iPtr);
						timestamp1 = timestamp1.replace(/T/g," ");
					}
				}
				json[i].timestampStr = timestamp1;
			}
			catch (err) {}
			try{
				if(typeof json[i].presetValue === "undefined")
					json[i].presetValue = "";
				else if (json[i].presetValue === null)
					json[i].presetValue = "";
			} catch(err) {}
			
			
			
		}
		
		if(mode === 0) {
			bContinue = true;
			while(bContinue)
			{
				bContinue = false;
				for(i=0; i < (json.length - 1); i++)
				{
					if(json[i].dpPath > json[i + 1].dpPath) {
						obj = {};
						obj = JSON.parse(JSON.stringify(json[i]));
						json[i] = JSON.parse(JSON.stringify(json[i + 1]));
						json[i + 1] = obj;
						bContinue = true;
					}
				}
			}
		}
		

		
		for(i=0; i < json.length; i++)
		{
			
			bContinue = false;
			
			dpPath = json[i].dpPath;
			if(mode === 2)
				bContinue = json[i].bProcess;
			else {
				if(bDevice) {
					if(json[i].deviceName === path) {
						bContinue = true;
					}
				}
				else {
					//fullPath = json[i].deviceName + "/" + dpPath;
					//if(fullPath === path)
					if(json[i].programmaticPathname === path)
						bContinue = true;
				}
			}


			if(bContinue) {

				valueStr = JSON.stringify(json[i].locValue);
				if(typeof json[i].presetValue === "undefined") {
					if(json[i].presetValue !== null)
						valueStr = json[i].presetValue;
				}
				
				if(mode === 0) {
					planningDpList.push(json[i]);
					index ++; // 3.2 supports hidden flag so don't show hidden datapoints
					content += "<tr><td>" + index.toString() + "</td>";
					pathname = json[i].pathname;
					z = -1;
					// check if dp already in favorites list
					for(j=0; j < favDpList.length; j++ )
					{
						if(json[i].pathname === favDpList[j]. pathname) {
							z = j;
							break;
						}
					}
					content += "<td><input type=\"checkbox\" id=\"fav_" + json[i].pathname + "\" onclick=\"addToFavorites1(1, '" + json[i].pathname + "')\"";
					if(z !== -1)
						content += " checked";
					content += "></td>";
					
					content += "<td><button id=\"dpMenu_" + json[i].pathname + "\" style=\"margin-left:5px;margin-right:5px;\" onclick=\"menuDp1(1, event, ";  // may need to ffixx
					content += "0, ";
					content += i + ", '" + json[i].pathname + "', '" + json[i].programmaticPathname + "')\">...</button></td>";
					
					content += "<td>" + dpPath + "</td><td>" + json[i].name + "</td><td>";
					if(json[i].cat === "out")
						content += "<div id=\"localValue_" + pathname + "\" class=\"treeTdValueDiv\">" + valueStr  + "</div>";
					else if(json[i].cat === "in") {   
						content += "<div class=\"treeTdValueWriteDiv\">";
						content += "<input id=\"localValue_" + pathname + "\" class=\"treeTdValueInput\" size=\"50\" "; 
						bHasPresets = false;
						if(typeof json[i].presets !== "undefined") {
							if(json[i].presets !== null) {
								if(json[i].presets.enabled) {
									if(json[i].presets.map.length > 0) {
										bHasPresets = true;
										content += " list='dpNewValuePresetList_" + pathname + "' value='" + valueStr + "'><datalist id='dpNewValuePresetList_" + pathname + "'>"
										for(k=0; k <json[i].presets.map.length; k++)
										{
											name1 = json[i].presets.map[k].name;
											content += "<option value='" + name1 + "'>"  + name1 + "</option>";
										}
										content += "<option value='" + valueStr + "'>Raw Value</option>";
										content += "</datalist>";
									}
								}
							} 
						}
						if(!bHasPresets) {
							content += " list='dpNewValuePresetList_" + pathname + "' value='" + valueStr + "'><datalist id='dpNewValuePresetList_" + pathname + "'>";
							content += "<option value='" + valueStr + "'>Raw Value</option>";
							content += "</datalist>";
						} 
						content += "<button style=\"margin-left:10px\" onclick=\"inputBoxSendValue1(1, this, event, " + i + ", '" + pathname + "')\">Send</button></div>";
					}
					content += "</td>";
					if(json[i].cat === "out") {
						content += '<td></td>';
					   // tablePaneContent += "<td><span id=\"priority_" + pathname + "\">" + dashboardDpList[i].priority + "</span></td>";
					}
					else { // in
						//content += "<td ><div style=\"display:flex\"><input id=\"priority_" + pathname + "\" value=\"" + json[i].priority + "\" size=\"3\">";
						content += "<td><div class=\"treeTdPriorityDiv\"><select id=\"priority_" + pathname + "\">";
						for(s=1; s < 17; s++)
						{
							content += "<option value=\"" + s + "\"";
							if(json[i].priority === s)
								content += " selected";
							content += ">" + s + "</option>";
						}
						content += "<option value=\"17\"";
						if(json[i].priority === 17)
							content += " selected";
						content += ">" + "Normal" + "</option>";
						content += "</select>"
						content += "<button id=\"dpValueMenu_" + pathname + "\" style=\"margin-left:10px\" onclick=\"menuDpValue1(13,this, " + i + ", '" + json[i].programmaticPathname + "')\">...</button></div></td>";
					}
					
					if(json.length > 1) {
						try {
							content += "<td class=\"tableHideCol\">";
							if(bLonProtocol)
								content +=  json[i]["lon.cfg"].unit;
							content +=  "</td>";
							content += "<td class=\"tableHideCol\">" + json[i].cat + "</td>";
							content += "<td class=\"tableHideCol\">" + json[i].type + "</td>";
							content += "<td class=\"tableHideCol\">" + json[i].blockName + "/" + json[i].blockIndex + "/" + json[i].datapointName + "</td>";

							//content += "<td><button class=\"menuDivButton\" onclick=\"showDlaByName1(1,'" + json[i].pathname + "','" + json[i].programmaticPathname + "')\">Show</button></td>";
							content += "<td class=\"tableHideCol\">";
							if(typeof json[i].property !== "undefined") 
								content +=  json[i].property;
							content += "</td>";
							
							if(bLonProtocol) {
								content += "<td class=\"tableHideCol\">";
								if(typeof json[i]["lon.cfg"].relatesTo !== "undefined") {
									content += json[i]["lon.cfg"].relatesTo;
								}
								content += "</td>";
							}
							
							content += "<td class=\"tableHideCol\">";
							
							if(typeof json[i]["read-only"] !== "undefined") 
								content += json[i]['read-only'];
							content += "</td>";
							if(typeof json[i].monitor === "undefined") {
								if(bLonProtocol) {
									content += "<td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td>";
									content += "<td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td>";
									content += "<td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td>";
								}
								else {
									content += "<td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td>";
									content += "<td class=\"tableHideCol\"></td><td class=\"tableHideCol\">";
								}
							}
							else {
								content += "<td class=\"tableHideCol\">" + json[i].monitor.rate + "</td>";
								content += "<td class=\"tableHideCol\">"
								try {
									if(typeof json[i].monitor.event !== "undefined")
										content +=  json[i].monitor.event;
								} catch {}
								content += "</td>"
								content += "<td class=\"tableHideCol\">" + json[i].monitor.throttle + "</td>";
								content += "<td class=\"tableHideCol\">" + json[i].monitor.heartbeat + "</td>";
								content += "<td class=\"tableHideCol\">" + json[i].monitor.threshold + "</td>";
								content += "<td class=\"tableHideCol\">" + json[i].monitor.receiveTimeout + "</td>";
								if(bLonProtocol) {
									content += "<td class=\"tableHideCol\">" + json[i].monitor["lon.cfg"].propagationThrottle + "</td>";
									content += "<td class=\"tableHideCol\">" + json[i].monitor["lon.cfg"].propagationHeartbeat + "</td>";
									content += "<td class=\"tableHideCol\">" + json[i].monitor["lon.cfg"].propagationThreshold + "</td>";
								}
								
							}
							content += "<td class=\"tableHideCol\"><div>"
							try {
								if(typeof json[i].localization !== "undefined") {
									if(json[i].localization === null)
									{}
									else if(typeof json[i].localization === "object") {
										sTemp = JSON.stringify(json[i].localization);
										if(sTemp !== "{}")
											content += sTemp;
									}
									else 
										content += json[i].localization;
									
								}
							} catch {}
							content += "</div></td>";
							content += "<td class=\"tableHideCol\"><div>";
							if(typeof json[i].presets !== "undefined") {
								if(json[i].presets !== null) {
									if(json[i].presets.map.length > 0) {
										content += JSON.stringify(json[i].presets.map);
									}
								}
							}
							content += "<div></td>";
							if(bLonProtocol)
								content += "<td class=\"tableHideCol\"><div>" + json[i].desc + "</div></td>";
							if(!bLonProtocol){
								content += "<td class=\"tableHideCol\"><div>";
								if(typeof json[i].default !== "undefined") {
									if(json[i].default === null)
									{}
									else if(typeof json[i].default === "object")
										content += JSON.stringify(json[i].default);
									else
										content += jon[i].default;
									
								}
									content += "</div></td>";
							}
							content += "<td class=\"tableHideCol\"><div>"
							try {
								if(typeof json[i]["Initial Value"] !== "undefined") {
									if(json[i]["Initial Value"] === null)
									{}
									else if(typeof json[i]["Initial Value"] === "object")
										content += JSON.stringify(json[i]["Initial Value"]);
									else
										content += jon[i]["Initial Value"];
									
								}
							} catch {}
							content += "</div></td>";
							content += "<td class=\"tableHideCol\">"
							try {
								if(typeof json[i]["Write Initial"] !== "undefined") {
									content += json[i]["Write Initial"];
									
								}
							} catch {}
							content += "</td>";
							content += "<td class=\"tableHideCol\">"
							try {
								if(typeof json[i].interfaceType !== "undefined")
									content += json[i].interfaceType;
								
							} catch {}
							content += "</td>";
						}
						catch {}

					}


					content += "</tr>";

					if(json.length === 1) {
						// single datapoint show configuration in separate table
						bSingleDp = true;
						g_bPlanningShowConfigurationSingleDp = true;
						content += "</tbody></table>";
						content += "<br>";
						content += "<div id=\"treeDpProperty\" style=\"display:";
						if(g_bPlanningShowConfiguration)
							content += "inline-block\">";
						else
							content += "none\">";
						
						content += "<hr>";
						content += "<br>Properties:";
						//content += "<button style=\"50px\" onclick=\"showDlaByName1(1,'" + json[i].pathname + "','" + json[i].programmaticPathname + "')\">Device Type DP Properties</button><br>";
						content += "<br>";
						content += "<table id=\"treeDpProperties\"><thead><tr><th class=\"tablePropertyHideCol\">Property</th><th class=\"tablePropertyHideCol\">Value</th></tr></thead><tbody>";
						try {
							content += "<tr><td>Type</td><td>" + json[i].type + "</td></tr>";
							//if(json[i].hasOwnProperty("lon.cfg")) {
							if(typeof json[i]["lon.cfg"] !== "undefined") {
								content += "<tr><td>Units</td><td>" + json[i]["lon.cfg"].unit + "</td></tr>";
							}
							if(typeof json[i]["read-only"] !== "undefined") 
								content += "<tr><td>Read-only</td><td>" + json[i]["read-only"] + "</td></tr>";
							content += "<tr><td>Direction</td><td>" + json[i].cat + "</td></tr>";
							content += "<tr><td>Property</td><td>" + json[i].property + "</td></tr>";
							if(typeof json[i]["lon.cfg"] !== "undefined") {
								if(typeof json[i]["lon.cfg"].relatesTo !== "undefined") {
									content += "<tr><td>Property For</td><td>" + json[i]["lon.cfg"].relatesTo + "</td></tr>";
								}
							}
							if(typeof json[i].desc !== "undefined")
								content += "<tr><td>Description</td><td>" + json[i].desc + "</td></tr>";
							
							if(typeof json[i].monitor !== "undefined") {
								content += "<tr><td>Monitor Poll Rate</td><td>" + json[i].monitor.rate + "</td></tr>";
								content += "<tr><td>Monitor Event</td><td>"
								try {
									if(typeof json[i].monitor.event !== "undefined")
										content +=  json[i].monitor.event;
								} catch {}
								
								content += "</td></tr>";
								content += "<tr><td>Monitor Rate</td><td>" + json[i].monitor.rate + "</td></tr>";
								content += "<tr><td>Monitor Throttle</td><td>" + json[i].monitor.throttle + "</td></tr>";
								content += "<tr><td>Monitor Heartbeat</td><td>" + json[i].monitor.heartbeat + "</td></tr>";
								content += "<tr><td>Monitor Threshold</td><td>" + json[i].monitor.threshold + "</td></tr>";
								content += "<tr><td>Monitor ReceiveTimeout</td><td>" + json[i].monitor.receiveTimeout + "</td></tr>";
								try {
									if(typeof json[i].monitor["lon.cfg"] !== "undefined") {
										content += "<tr><td>Propagation Throttle</td><td>" + json[i].monitor["lon.cfg"].propagationThrottle + "</td></tr>";
										content += "<tr><td>Propagation Heartbeat</td><td>" + json[i].monitor["lon.cfg"].propagationHeartbeat + "</td></tr>";
										content += "<tr><td>Propagation Threshold</td><td>" + json[i].monitor["lon.cfg"].propagationThreshold + "</td></tr>";
									}
								} catch {}
							}
							
							
							try {
								if(typeof json[i].localization !== "undefined") {
									content += "<tr><td>Localization</td><td><div>";
									if(json[i].localization === null)
									{}
									else if(typeof json[i].localization === "object") {
										sTemp = JSON.stringify(json[i].localization);
											if(sTemp !== "{}")
												content += sTemp;
									}
									else 
										content += json[i].localization;
									content +=  "</div></td></tr>";
								}
							} catch {}
							content += "<tr><td>Presets</td><td>";
							try {
								if(typeof json[i].presets !== "undefined") {
									if(json[i].presets !== null) {
										if(json[i].presets.map.length > 0) {
											content += JSON.stringify(json[i].presets.map);
										}
									}
								}
							} catch {}
							content +=  "</td></tr>";
							try {
								if(typeof json[i].default !== "undefined") {
									content += "<tr><td>Default</td><td><div>";
									if(json[i].default === null)
									{}
									else if(typeof json[i].default === "object")
										content += JSON.stringify(json[i].default);
									else
										content += jon[i].default;
									content +=  "</div></td></tr>";
								}
							} catch {}
							try {
								if(typeof json[i]["Initial Value"] !== "undefined") {
									content += "<tr><td>Initial Value</td><td><div>";
									if(json[i]["Initial Value"] === null)
									{}
									else if(typeof json[i]["Initial Value"] === "object")
										content += JSON.stringify(json[i]["Initial Value"]);
									else
										content += jon[i]["Initial Value"];
									content +=  "</div></td></tr>";
								}
							} catch {}
							
							
							try {
								if(typeof json[i]["Write Initial"] !== "undefined") {
									content += "<tr><td>Write Initial</td><td>";
									content += json[i]["Write Initial"];
									content +=  "</td></tr>";
								}
							} catch {}
							if(typeof json[i].interfaceType !== "undefined")
								content += "<tr><td>Interface</td><td>" + json[i].interfaceType + "</td></tr>";
						} catch {}
						
						content += "</tbody></table></div>";
					}

				}
				else {
					if((mode !== 2) || ((mode === 2) && json[i].bProcess)) {
						z = -1;
						for(j=0; j < planningDpList.length; j++)
						{
							if(planningDpList[j].pathname === json[i].pathname) {
								z = j;
								break;
							}
						}
						if(z !== -1) {
							bContinue1 = false;
							if (mode === 1) {
								element = document.getElementById("planningPollCheckbox");
								if(element !== null) {
									if(!element.checked) {
										bContinue1 = true;
									}
								}
							}
							if(isNotEqual(planningDpList[z].value, json[i].value) || bContinue1) {
								planningDpList[z].value = json[i].value;
								planningDpList[z].valueStr = json[i].valueStr;
								planningDpList[z].locValue = json[i].locValue;
								planningDpList[z].locValueStr = json[i].locValueStr;
								planningDpList[z].timestampStr = json[i].timestampStr;
								planningDpList[z].presetValue = json[i].presetValue;
								
								element = document.getElementById("localValue_" + json[i].pathname);
								if(element !== null) {
									if(planningDpList[z].cat === "out")
										element.innerHTML = valueStr;
									else
										element.value = valueStr;
								}
							}
							
							if(mode === 1) { //refresh
								if(isNotEqual(planningDpList[z].values,json[i].values))
									planningDpList[z].values = json[i].values;
								if(typeof json[i].priority === "number") {
									if(planningDpList[z].priority !== json[i].priority) {
										planningDpList[z].priority = json[i].priority;
									}
									element = document.getElementById("priority_" + json[i].pathname);
									if(element !== null) {
										if(Number(element.value) !== json[i].priority)
											element.value = json[i].priority;
									}
									
								}
								
							}
							
						}
						
					}
				}
			}
		}
		if(mode === 0) {
			content += "</tbody></table>";
			document.getElementById("planningPaneDetails").innerHTML = content; 
			
			createRequestString(planningDpList);
			subscribeRequest();
			planningPollCheckBox();
			
			
		}
		if(mode === 0) {
			if(bSingleDp)
				treeShowConfiguration();
			else
				treeShowConfigurationAll();
			
		}
		if(bRequestFollowupRead) {
			if(g_planningDpTimerId !== 0)
				clearTimeout(g_planningDpTimerId);
			//g_timerId = window.setTimeout("timerHandler()",g_planningDpOnDemandTimerInterval); 
		}
		
		
	}
	catch(err) {}
	if(mode === 0)
		cursorClearWait();
		
}
function getPlanningTreeRequestFailure(mode, requestUrl, json) {
	
	if(mode === 0)
		cursorClearWait();
	document.getElementById("planningPaneDetails").innerHTML = "";
}
function getPlanningTreeShowTreeDatapointsUpdatePrioritesResponse(mode, requestUrl, json) {
	// mode: 0=creat table, 1= 2=Websocket, 3= on demandfollowup request, 4=refresh [same as 0 but don't create table]
	// Table data
	try {
		var i, j, z;
		if(!(mode === 23) || (mode === 24))
			return;
		
		for(i=0; i < json.length; i++)
		{ // check if in
			z = -1; 
			for(j=0; j < planningDpList.length; j++)
			{
				if(json[i].dpQualifier === planningDpList[j].dpQualifier) {
					if(json[i].cat === "in") {
						if(typeof json[i].values !== "undefined") {
							if(typeof json[i].values.level !== "undefined") {
								if(typeof json[i].values.level === "string") 
									json[i].values.level = Number(json[i].values.level); // required dued to bug in current shipping iox
								if((planningDpList[j].priority !== json[i].values.level) 
									|| (planningDpList[j].values.level !== json[i].values.level)
									|| (isNotEqual(planningDpList[j].values.level, json[i].values.level))) {
									
									planningDpList[j].priority = json[i].values.level;
									planningDpList[j].values = JSON.parse(JSON.stringify(json[i].values));
									element = document.getElementById("priority_" + planningDpList[j].programmaticPathname);
									if(element !== null) {
										element.value = json[i].values.level;
									}
								}
							}
						}
					}
					break;
				}
			}
		}
	}
	catch(err) {}
}
function getPlanningTreeShowTreeDetails(mode, id) {
	//mode: 61=resize
	var json, json1;
	var sResult = "";
	var sTemp, sTemp1, items, items1, sTemp;
	var bContinue = false;
	var sResults;
	var x, i, j, m, n, z;
	var treeContext = null;
	var sidItems = [];
	var bAbove = false;
	var image = "",width=-1, height=-1,location ="";
	var bAddImage = true; // if context already has an image defined don't over write with one 
	var bContentAdded = false;  //if not customtags then maybe use map
	var sContextContent = "";
	g_iMainDisplayMode = DISPLAYMODE_PLANNING;
	g_sSiteDashboardSelected = "";
	g_DashboardImage = null;
	g_iDashboardImageWidth = null;
	g_iDashboardImageHeight = null;
	g_bPlanningContextClicked = true;
	
	g_sContextContent = "";
	try {
		g_sPlanningTreeDatapointPath = ""; // only used for Devices and Datapoints nodes
		g_iPlanningPaneSelectedContextType = 0;
		g_dashboardChartList = [];
		g_zoomDashboardChartList = [];
		g_oDashboardLayout = null;
		if(mode === 61) {
			mode = 1; // called do to a resize event
			g_bPlanningContextClicked = false;
			menuCloseAll1(1);
		}
		else {
			g_bPlanningContextClicked = true;
			g_oPLanningContextDivs = [];
			planningInitContextZoomInfo();
			menuCloseAll();
			g_bEditModeEnabled = false;
			if(g_iShowEditButton > 0) {
				if(g_iShowEditButton === 2) 
					g_bEditModeEnabled = true;
			}
		}
		planningDpList = [];
		g_bPollingEnabled = false;
		ivbWsProcessDatapointUpdate = false;
		g_PollingType = 0;
		if(g_planningDpTimerId !== 0)
			clearTimeout(g_planningDpTimerId);

		//document.getElementById("planningContextDetailsDiv").style.visibility = "visible";
		//document.getElementById("planningRefreshButton").style.visibility = "visible";
		cursorClearWait();
		if(mode === 0) {
			// change color of tree context to indicate selected
			
			if(g_iPlanningPaneSelectedContextId !== -1) {
				treeContext = document.getElementById("planningTreeContext_" + g_iPlanningPaneSelectedContextId);
				if(treeContext !== null) {
					treeContext.classList.remove("treeSelected")
					//treeContext.style.color = "white";
				}
			}
			treeContext = document.getElementById("planningTreeContext_" + id);
			if(treeContext !== null) {
				//treeContext.style.color = "red";
				treeContext.classList.add("treeSelected");
			}
		}

		g_iPlanningPaneSelectedContextId = id;
		if(g_iPlanningPaneSelectedContextId === "__sites__") {
			treeviewSitesPaneContent();
			return;
		}

		if(id === "_NoContext") {
			if(false) {
				if(g_bMapEnabled) {
					json = getPlanningTreeShowTreeDetailsGetObj(planningList, id, 0);
					json1 = getPlanningTreeShowTreeDetailsGetObj(planningList, json.parentId, 0);
					//if((json.contextType === "WORLD") || (json.contextType === "REGION") || (json.contextType === "CAMPUS") || (json.contextType === "BUILDING")  
					//	|| ((json.contextType === "AREA") && ((json1.contextType === "WORLD") || (json1.contextType === "REGION") || (json1.contextType === "CAMPUS")))) {
					//if((json.contextType === "WORLD") || (json.contextType === "REGION") || (json.contextType === "CAMPUS") || (json.contextType === "BUILDING")  
					//		|| ((json.contextType === "AREA") && ((json1.contextType === "WORLD") || (json1.contextType === "REGION") || (json1.contextType === "CAMPUS")))) {	
						try {
							//(mode,name, type, index)
						//	showMap(0,json.name,json.contextType,0); //
								
						}
						catch {}
					//}
				}
				document.getElementById("planningPaneDetails").innerHTML = "Un-assigned Devices<br><br>Devices which are not assigned to a Context";
				return; // un-assigned node in tree
			}
		}
		json = getPlanningTreeShowTreeDetailsGetObj(planningList, id, 0);
		//if((g_iPlanningTreeShowDevices === 1)  || (json.contextType === "REGION") || (json.contextType === "CAMPUS") || (json.contextType === "BUILDING")) { 
		if((json.contextType === "WORLD") || (json.contextType === "REGION") || (json.contextType === "CAMPUS") || (json.contextType === "BUILDING")) { 
			//json = getPlanningTreeShowTreeDetailsGetObj(planningList, id, 0); 
			sTemp = g_sTreeNoContent;
			bContinue = true;
				// check if context has image
			if((json.customFields !== null) &&  (json.contextType !== "CAMPUS")){
				if(json.customFields.hasOwnProperty("image")) {
					bContinue = false; // found image 
					sTemp1 = json.customFields["image"];
					if(sTemp1.indexOf(",") !== -1) {
						// single tag with all image inforation
						items = sTemp1.split(",");
						image = ""; width = -1; height = -1;
						location = "";
						above = true;
						sid = null;
						for(i=0; i < items.length; i++)
						{
							if(items[i] !== "") {
								items1 = items[i].split("=");
								if(items1.length === 2) {
									items1[0] = items1[0].trim().toLowerCase();
									items1[1] = items1[1].trim();
									if(items1[0] === "image") {
										image =items1[1].trim();
									}
									else if(items1[0] === "width") {
										width =items1[1].trim();
									}
									else if(items1[0] === "height") {
										height =items1[1].trim();
									}
									/*else if(items1[0] === "sid") {
										if(items[1].trim().toLowerCase() !== "null") {
											sid = items1[1].trim();
										}
										bSidFound = true;
									} */
									else if(items1[0] === "location") {
										location =items1[1].trim();
									}
									else if(items1[0] === "above") {
										items1[1] = items1[1].trim().toLowerCase();
										if(items1[1] === "false")
											above = false;
									}
								}
							}
						}
						if(image !== "") {
							sTemp = "";
							if((location !== "") && above) {
								sTemp += location;
							}
							bAddImage = false;
							sTemp += "<div style=\"display:block;margin-left:50 px;margin-top:10px;margin-right:10px\"><img src=\"" +  image + "\" alt=\"";
							sTemp += json.contextType + " image\"";
							if(!isNaN(width)) {
								width = Number(width);
								if(width > 0)
									sTemp += " width=\"" + width + "px\"";
							}
							if(!isNaN(height)) {
								height = Number(height);
								if(height > 0)
									sTemp += " height=\"" + height + "px\"";
							}
							sTemp += "></div>";
							if((location !== "") && !above) {
								sTemp += location;
							}
						}
					}
					else {
						if(json.customFields.hasOwnProperty("above")) {
							if(json.customFields["above"]) 
								bAbove = true;
						}
						if(bAbove) {
							if(json.customFields.hasOwnProperty("location")) {
								if(json.customFields["location"] !== "") {
									sTemp += g_contextImages[j].location;
								}
							}
						}
						if(json.customFields["image"] !== "") {
							bAddImage = false;
							sTemp += "<div style=\"display:block;margin-left:50 px;margin-top:10px;margin-right:10px\"><img src=\"" +  json.customFields["image"] + "\" alt=\"";
							sTemp += json.contextType + " image\"";
							if(json.customFields.hasOwnProperty("width")) {
								sTemp1 = json.customFields["width"];
								try {
									sTemp1 = Number(sTemp1);
									if(!isNaN(sTemp1)) {
										sTemp += " width=\"" + sTemp1 + "px\"";
									}
								}
								catch {}
								
									
							}
							if(json.customFields.hasOwnProperty("height")) {
								sTemp1 = json.customFields["height"];
								try {
									sTemp1 = Number(sTemp1);
									if(!isNaN(sTemp1)) 
										sTemp += " height=\"" + sTemp1 + "px\"";
								}
								catch {}
							}
							sTemp += "></div>";
							
						}
						if(!bAbove) {
							if(json.customFields.hasOwnProperty("location")) {
								if(json.customFields["location"] !== "") {
									sTemp += g_contextImages[j].location;
								}
							}
						}
					}
					
				}
			}
			if(bContinue) {
				// check if images specified in user.js
				for(n=0; n < 2; n++)
				{
					for(j=0; j < g_contextImages.length; j++)
					{
						
						if(json.contextType.toLowerCase() === g_contextImages[j].contextType) {
						
							bContinue = false;
							
							if(n === 0) {
								// check if sid defined
								if(g_contextImages[j].sid !== null) {

									if(g_contextImages[j].sid.indexOf(",") !== -1) {
										sidItems = g_contextImages[j].sid.indexOf(",");
									}
									else {
										sidItems.push(g_contextImages[j].sid);
										
									}
									for(m=0; m < sidItems.length; m++)
									{
										if(g_iSmarserverSid === sidItems[m]) {
											bContinue = getPlanningTreeShowTreeDetailsCheckContext(g_contextImages[j].contextType, json.contextType.toLowerCase());
											if(bContinue)
												break;
										}
									}
								}
							}
							else if(n === 1) {
								// sid not defined
								bContinue = getPlanningTreeShowTreeDetailsCheckContext(g_contextImages[j].contextType, json.contextType.toLowerCase());
								
							}
							
							if(bContinue) {
								sTemp = "";
								if(g_contextImages[j].bLocationAboveImage) {
									if(g_contextImages[j].location !== null) {
										sTemp += g_contextImages[j].location;
									}
								}
								if(g_contextImages[j].image !== null) {
									sTemp += "<div style=\"display:block;margin-left:50 px;margin-top:10px;margin-right:10px\"><img src=\"" +  g_contextImages[j].image + "\" alt=\"" + g_contextImages[j].contextType + " image\"";
									if(g_contextImages[j].width !== null)
										sTemp += " width=\"" + g_contextImages[j].width + "px\"";
									if(g_contextImages[j].height !== null)
										sTemp += " height=\"" + g_contextImages[j].height + "px\"";
									sTemp += "></div>";
									bContentAdded = true;
									bAddImage = false;
									
								}
								if(!g_contextImages[j].bLocationAboveImage) {
									if(g_contextImages[j].location !== null) {
										sTemp += g_contextImages[j].location;
									}
								}
								break;
							}
							
						}
						
					}
					if(bContinue)
						break;
				}
			}
			sContextContent = "";
			if((json.contextType === "WORLD") || (json.contextType === "REGION") || (json.contextType === "CAMPUS") || (json.contextType === "BUILDING")) {
				if(!bAddImage) 
					sContextContent = "<br>" + sTemp; // for dashboard code if datapoints are provided
				
				if(false) { //if((sTemp === "No Content") && (g_bMapEnabled)) {
					json = getPlanningTreeShowTreeDetailsGetObj(planningList, id, 0);
					json1 = getPlanningTreeShowTreeDetailsGetObj(planningList, json.parentId, 0);
					if((json.contextType === "WORLD") || (json.contextType === "REGION") || (json.contextType === "CAMPUS") || (json.contextType === "BUILDING")  
						|| ((json.contextType === "AREA") && ((json1.contextType === "WORLD") || (json1.contextType === "REGION") || (json1.contextType === "CAMPUS")))) {
						
						try {
							showMap(0,json);
								
						}
						catch {}
					}
					return;
				}
			}
			sTemp = "<div id=\"dashboardbreadcombar\" style=\"float:left;cursor:pointer\">" + planningCreateContextbreadcrumbs(json['path']) + "</div><br><br>" + sTemp;
			if((json.contextType !== "REGION") && (json.contextType !== "CAMPUS") && (json.contextType !== "BUILDING"))
				sTemp = "<br>" + sTemp;
			

			document.getElementById("planningPaneDetails").innerHTML = sTemp;
			
			//getPlanningTreeShowTreeDevices(id); yyyy
			//mike check if context datapoints
			if((json.contextType === "WORLD") || (json.contextType === "REGION") || (json.contextType === "CAMPUS") || (json.contextType === "BUILDING")) {
				z = -1;
				sTemp = json.path.toLowerCase();
				for(i=0; i < g_campusTags.contextList.length; i++)
				{
					if(g_campusTags.contextList[i].contextName.toLowerCase() === sTemp) {
						z = i;
						break;
					}
				}
				if(z !== -1) {
					g_sContextContent = sContextContent; // only if the context has custom tags with an image.
					if((g_campusTags.contextList[z].dpList.length > 0) || (bAddImage && (g_campusTags.contextList[z].image !== null)))
						getPlanningTreeShowSiteDashboard1(0, bAddImage,json.id,json.path);
				}
				else {
					if(g_bMapEnabled && !bContentAdded) {
						json = getPlanningTreeShowTreeDetailsGetObj(planningList, id, 0);
						json1 = getPlanningTreeShowTreeDetailsGetObj(planningList, json.parentId, 0);
						if((json.contextType === "WORLD") || (json.contextType === "REGION") || (json.contextType === "CAMPUS") || (json.contextType === "BUILDING")  
							|| ((json.contextType === "AREA") && ((json1.contextType === "WORLD") || (json1.contextType === "REGION") || (json1.contextType === "CAMPUS")))) {
							
							try {
								if(json === null)
								{
								//	showMap(0,0,null,null);
								}
								else
									showMap(0,json.name,json.path, json.contextType,id, -1);
									
							}
							catch {}
						}
						return;
					}
				}
			}
			//showContextDevices(id);
			return;
		}
		else if(g_iPlanningTreeShowDevices === 0) {
			getPlanningTreeShowTreeFloorplan(id);
			//showContextDevices(id);
			return;
		}

		document.getElementById("planningPaneDetails").style.display = "inline-block";
		json = getPlanningTreeShowTreeDetailsGetObj(planningList, id, 0);
		
		if(json === null)
			document.getElementById("planningPaneDetails").innerHTML = "Details<br><br>No Details";
		else {
			// sort
			while(bContinue)
			{
				bContinue = false;
				for(i=0; i < json.length; i)
				{

				}
			}
			for (x in json)
			{
				if(x === "devices") {
					sResult += "<tr><td>Devices</td><td>" + json[x].length + "</td></tr>";
				}
				else if(typeof json[x] === "undefined")
					sResult += "<tr><td>" + x + "</td><td></td></tr>";
				else if (json[x] === null )
					sResult += "<tr><td>" + x + "</td><td></td></tr>";
				else if(json[x] === "undefined")
					sResult += "<tr><td>" + x + "</td><td></td></tr>";
				else if(x === "treeLevel")
					sResult += "<tr><td>Tree Level</td><td>" + json[x] + "</td></tr>"; 
				else if(x === "children")
					sResult += "<tr><td>Number of children</td><td>" + json[x].length + "</td></tr>";
				else if(x === "image")  {
					
					sResult += "<tr><td>images</td><td>" + json[x].length + "</td></tr>";
				}
				else if((typeof json[x] === "object")  || Array.isArray(json[x])) {
					sTemp = JSON.stringify(json[x]);
					sResult += "<tr><td>" + x + "</td><td>" + sTemp + "</td></tr>"; 
				}
				else 
					sResult += "<tr><td>" + x + "</td><td>" + json[x] + "</td></tr>"; 
			}
			if(sResult !== "") {
				sResult = "<table id=\"myTable\"><thead><tr><th>Property</th><th>Value</th></tr></thead><tbody>" + sResult + "</tbody></table>"; 
				sResult = "<br>" + json['path'] + "<br><br>Details<button style=\"margin-left:40px;\" onclick=\"showContextDevices(" + id + ")\">Show Devices</button><br><br>" + sResult;
				sResult += addTopButton();
				document.getElementById("planningPaneDetails").innerHTML = sResult;
				sortTable(0); 
			}
		}
		
	}
	catch {}
	cursorClearWait();
}
function getPlanningTreeShowTreeDetailsCheckContext(contexts, context) {
	var bResult = false;
	var i;
	var contextItems = [];
	try { 
		if((contexts === null) || (context === null)){

		}
		else {
			if(contexts.indexOf(",") === -1) {
				contextItems.push(contexts);
			}
			else {
				contextItems = contexts.split(",");
			}
			for(i=0; i < contextItems.length; i++)
			{
				if(contextItems[i] === context) {
					bResult = true;
					break;
				}
			}
		}
	}
	catch {}
	return bResult;

}
function getPlanningTreeShowTreeDetailsGetObj(json, id, level) {
	var i;
	var jsonResult = null;
	level ++;
	if(json === null)
		return null;
	try {
		for(i=0; i < json.length; i++)
		{
			if(json[i].id === id) {
				jsonResult = JSON.parse(JSON.stringify(json[i]));
				break;
			}
			else if (json[i].children !== null) {
				if(json[i].children.length > 0) {
					jsonResult = getPlanningTreeShowTreeDetailsGetObj(json[i].children, id, level);
					if(jsonResult !== null) 
						break;
				}
			}
		}
	}
	catch { jsonResult = null;}
	
	return jsonResult;
}
function getPlanningTreeShowTreeDetailsGetObjPlusFloorplan(json, id, level, image) {
	var i;
	var jsonResult = null;
	level ++;
	if(json === null)
		return null;
	try {
		for(i=0; i < json.length; i++)
		{
			if(json[i].id === id) {
				jsonResult = JSON.parse(JSON.stringify(json[i]));
				if((jsonResult.image.image === null) || (jsonResult.image.image === "")) {
				
					if(image !== null)
						jsonResult.image = image;
				}
				break;
			}
			else if (json[i].children !== null) {
				if(json[i].children.length > 0) {
					if(json[i].contextType === "FLOOR") {
						if((json[i].image.image !== null) && (json[i].image.image !== "")) 
							image = json[i].image;
							image.floorId = json[i].contextualEntityId;
					}
					jsonResult = getPlanningTreeShowTreeDetailsGetObjPlusFloorplan(json[i].children, id, level, image);
					if(jsonResult !== null) 
						break;
				}
			}
		}
	}
	catch { jsonResult = null;}
	
	return jsonResult;
}
function getPlanningTreeShowTreeFloorplan (id) {
	try { 
		var sTemp = "";
		var floorId = -1;
		var decodedImagestringAtoB = null;
		var json;
		var imageStr = "";
		var element;
		var i;
		var obj, obj1, obj2, obj3;
		
		g_planningFloorplanObjs = {};
		g_planningFloorplanGroups = [];
		g_bAtLeastOneDeviceFound = false;
		document.getElementById("planningPaneDetails").style.display = "inline-block";
		json = getPlanningTreeShowTreeDetailsGetObjPlusFloorplan(planningList, id, 0, null);
		if((json.contextType === "REGION") || (json.contextType === "CAMPUS") || (json.contextType === "BUILDING")){
			sTemp = "Floor plans not supported for " + json.contextType + "<br><br>Supported Floorplans: floor, and rooms and areas inside a floor";
			document.getElementById("planningPaneDetails").innerHTML = sTemp;
			return;
		}
		else if(json.contextType === "FLOOR") {
			floorId = json.contextualEntityId;
		}
		else {
			if(json.image !== null) 
				floorId = json.image.floorId;
		}
		g_iContextTableX = 0; //used to locate datapoint table in room or area
		g_iContextTableY = 0;
		json.browserFloorId = floorId;
		if(json.image.image === null) {
		//if((json.image.image === null) || (json.image.imageType === null)) {
			document.getElementById("planningPaneDetails").innerHTML = "";
			return;
		}
		
		if( json.image.imageType === null) {
			if(json.image.image.length > 10) {
				imageStr = json.image.image.substr(0,10);
				decodedImagestringAtoB = atob(imageStr)
				decodedImagestringAtoB = decodedImagestringAtoB.substr(1,3)
				if(decodedImagestringAtoB.startsWith("PNG")) {
					json.image.imageType = "png";
				}
				else 
					json.image.imageType = "jpeg";
			}
		}
		else if( json.image.imageType === "null") {
			if(json.image.image.length > 10) {
				imageStr = json.image.image.substr(0,10);
				decodedImagestringAtoB = atob(imageStr)
				decodedImagestringAtoB = decodedImagestringAtoB.substr(1,3)
				if(decodedImagestringAtoB.startsWith("PNG")) {
					json.image.imageType = "png";
				}
				else 
					json.image.imageType = "jpeg";
			}
		}
		
		if(( json.image.imageType !== "png") && ( json.image.imageType !== "jpeg")) {
			document.getElementById("planningPaneDetails").innerHTML = ""; // not supported yet
				return;
		}
		if(json.contextualEntityId === null) {
			if( json.image.imageType === "png")
				sTemp = "<img src=\"data:image/png;base64," + json.image.image + "\">";
			else if( json.image.imageType === "jpeg")
				sTemp = "<img src=\"data:image/jpeg;base64," + json.image.image + "\">";
			document.getElementById("planningPaneDetails").innerHTML = sTemp;
		}
		else {
			/*document.getElementById("planningPaneDetails").innerHTML = "Getting floor plan ...."; */
			element = document.getElementById("planningPaneDetails");
			if(element !== null) {
				sTemp = "<div id=\"planningPaneDetails_title\"  style=\"float:left;cursor:pointer\">" + planningCreateContextbreadcrumbs(json.path) + "</div><div id=\"planningPaneDetails_Details\"><br><div class=\"gettingInfo\">" + addWaitSpinner(1) + "</div>";
				element.innerHTML = sTemp;
			}
			//if(sTemp.indexOf("class=\"spinnerLoader\"") === -1) // to remove extra spinners
			//	document.getElementById("planningPaneDetails").innerHTML += addWaitSpinner();
			if(g_iSmartServerVersion >= 410000) {
				//use information already in /iap/context instead
				obj = {}
				sTemp = "<div id=\"floorplanTitle\">" + json.path;
				sTemp += "<br><br> Getting Floor plan ....</div><br><div id=\"floorplanDiv\"><div id=\"floorplanimageDiv\"><img id=\"floorplanimage\" src=\"data:image/png;base64," + json.image.image + "\" style=\"visibility:hidden\"></div></div>";
				document.getElementById("planningPaneDetails").innerHTML = sTemp;
				obj.contextobj = JSON.parse(JSON.stringify(json));
				obj.floorplan = [];//JSON.parse(JSON.stringify(json));
				// create floorplan array from contexts data
				if(json.contextType === "FLOOR") {
					for(i=0; i < json.children.length; i++)
					{
						obj1 = {};
						obj1.floorId = json.contextualEntityId;
						obj1.id = json.children[i].id;
						obj1.name = json.children[i].name;
						obj1.color = "red";
						if(typeof json.children[i].customFields !== "undefined") {
							if(typeof json.children[i].customFields.color !== "undefined") 
								obj1.color = json.children[i].customFields.color;
						}
						obj1.contextId = json.id;
						obj1.polygon = {};
						obj1.polygon.type = "Polygon";
						obj1.polygon.coordinates = [];
						obj3 = [];
						for(j=0; j< json.children[i].contextLocation.length; j++)
						{
							obj2 = [];
							obj2.push(json.children[i].contextLocation[j].long);
							obj2.push(json.children[i].contextLocation[j].lat);
							obj3.push(JSON.parse(JSON.stringify(obj2)));
						}
						
						obj1.polygon.coordinates.push(JSON.parse(JSON.stringify(obj3)));

						obj.floorplan.push(JSON.parse(JSON.stringify(obj1)));

					}
				}
				else if ((json.contextType === "ROOM") || (json.contextType === "AREA")) {
					// room or area
					obj1 = {};
					obj1.floorId = json.contextualEntityId;
					obj1.id = json.id;
					obj1.name = json.name;
					obj1.color = "red";
					if(typeof json.customFields !== "undefined") {
						if(typeof json.customFields.color !== "undefined") 
							obj1.color = json.customFields.color;
					}
					switch (i) {
						case 0: obj1.color = "orange"; break;
						case 1: obj1.color = "blue"; break;
						case 2: obj1.color = "cyan"; break;
					}
					obj1.contextId = json.id;
					obj1.polygon = {};
					obj1.polygon.type = "Polygon";
					obj1.polygon.coordinates = [];
					obj3 = [];
					for(j=0; j< json.contextLocation.length; j++)
					{
						obj2 = [];
						obj2.push(json.contextLocation[j].long);
						obj2.push(json.contextLocation[j].lat);
						obj3.push(JSON.parse(JSON.stringify(obj2)));
					}
					
					obj1.polygon.coordinates.push(JSON.parse(JSON.stringify(obj3)));

					obj.floorplan.push(JSON.parse(JSON.stringify(obj1)));
				}
				if(obj.floorplan.length > 0) {
					sTemp = "/iap/devs?contextid=" + obj.contextobj.id + "&short=true";//contextobj.contextualEntityId;
					requestGetData(obj, sTemp, getPlanningTreeShowTreeFloorplanShowDevices, readFailCallback);
				}
			}
			else {
				sTemp = "/iap/zones/*+floor.id==" + json.browserFloorId; //json.contextualEntityId;
				requestGetData(json, sTemp, getPlanningTreeShowTreeFloorplanShowPolygons, readFailCallback);
			}
		}

	}
	catch {}
}
function getPlanningTreeShowTreeFloorplanShowPolygons (contextobj, url, json) {
	try { 
		var sTemp = "";
		var obj = {}
		sTemp = "<div id=\"floorplanTitle\">" + contextobj.path;
		sTemp += "<br><br> Getting Floor plan ....</div><br><div id=\"floorplanDiv\"><div id=\"floorplanimageDiv\"><img id=\"floorplanimage\" src=\"data:image/png;base64," + contextobj.image.image + "\" style=\"visibility:hidden\"></div></div>";
		document.getElementById("planningPaneDetails").innerHTML = sTemp;
		obj.contextobj = JSON.parse(JSON.stringify(contextobj));
		obj.floorplan = JSON.parse(JSON.stringify(json));
		sTemp = "/iap/devs?floorid=" + contextobj.browserFloorId;//contextobj.contextualEntityId;
		requestGetData(obj, sTemp, getPlanningTreeShowTreeFloorplanShowDevices, readFailCallback);

	}
	catch {}
}
function getPlanningTreeShowTreeFloorplanShowPolygons1 (zoomIncrement) {
	try { 
		var sTemp = "";
		var obj = {};
		var contextobj = null;
		if((g_oPlanningContextZoom.floorplanObjs !== null) && (g_oPlanningContextZoom.url !== "") && (g_oPlanningContextZoom.json1.length !== 0)) {
			if(g_oPlanningContextZoom.floorplanObjs.contextobj.path !== "") {
				contextobj = JSON.parse(JSON.stringify(g_oPlanningContextZoom.floorplanObjs.contextobj));
				g_planningFloorplanGroups = [];
				sTemp = "<div id=\"floorplanTitle\">" + g_oPlanningContextZoom.floorplanObjs.contextobj.path;
				sTemp += "<br><br> Getting Floor plan ....</div><br><div id=\"floorplanDiv\"><div id=\"floorplanimageDiv\"><img id=\"floorplanimage\" src=\"data:image/png;base64," + contextobj.image.image + "\" style=\"visibility:hidden\"></div></div>";
				document.getElementById("planningPaneDetails").innerHTML = sTemp;
				getPlanningTreeShowTreeFloorplanShowDevices1(1, g_oPlanningContextZoom.floorplanObjs, g_oPlanningContextZoom.url, g_oPlanningContextZoom.json1, zoomIncrement);
			}
		}
	}
	catch {}
}

function getPlanningTreeShowTreeFloorplanShowDevices(floorplanObjs, url, json1) {
	getPlanningTreeShowTreeFloorplanShowDevices1(0, floorplanObjs, url, json1, 0);
}

function getPlanningTreeShowTreeFloorplanShowDevices1(mode, floorplanObjs, url, json1, zoomIncrement) {
	// mode: 0=initial, 1=zoom (add zoomOffset)
	// had to wait for device list as need time for image to load.
	var i, j, k, m, z;
	var coordinates;
	var top=0,left=0;
	var sTemp, sTemp1;
	var detailImage = null; //document.getElementById("planningPaneDetails");
	var offsets = null; //detailDiv.getBoundingClientRect(); 
	var roomOffsetx = 0,roomOffsety = 0; // floor: always 0, room and area: offset in backgroundimage
	var contextualEntityId;
	var x, y, x1, x2, y1, y2; // used to determine full size of canvas and set canas width and lenght
	var coordList = [], obj, obj1;
	var contextobj;
	var width = 20;
	var multiplier = 1;
	var color;
	var bContinue = false;
	var floorId = -1;
	var minImageWidth = 800; //px
	var changeColor = "";
	var groupNum;
	var json;
	var r,w;
	var url;
	var planningCount, count = 0;
	var content;
	var bPlanningContextClicked = false;
	var expand = 0; //used when zoom is smaller than initial zoom so you can see ajacent rooms
	var bContinue1 = false, bFullFloorplan = false;
	var element;
	
	try {
		cursorSetWait();
		
		contextobj = floorplanObjs.contextobj;
		contextualEntityId = contextobj.contextualEntityId;
		floorId = contextobj.browserFloorId;
		json = floorplanObjs.floorplan;
		g_oPLanningContextDivs = [];
		//sTemp = "<div>" + contextobj.path + "</div><div><span id=\"planningDeviceCount\" style=\"visibility:hidden;margin-left:20px\">  [ 0 devices]</span>";
		sTemp = "<div style=\"float:left;cursor:pointer\">" + planningCreateContextbreadcrumbs(contextobj.path) + "</div><div><span id=\"planningDeviceCount\" style=\"display:none;margin-left:20px\">  [ 0 devices]</span>";
		if(g_iShowEditButton > 0) {
			//g_iShowEditButton: 0=disabled, 1=show switch (default readonly), 2=show switch(default write)
			sTemp += "<div id=\"editButtonDiv\" class=\"editButtonDiv\">(<input id=\"editButton\" type=\"checkbox\" onclick=\"dashboardEditCheckBox()\"";
			if(g_bEditModeEnabled)
				sTemp += " checked";
			sTemp += "> edit)</div>";
		}
		if(g_bPlanningContextClicked) {
			bPlanningContextClicked = true;
		}
		g_bPlanningContextClicked = false;
		sTemp += "<div id=\"planningContextZoomButtonDiv\" class=\"planningContextZoomButtonDiv\">";
		sTemp += "<button id=\"planningContextZoomDownButton\" onclick=\"planningContextZoomButtonClicked(-1)\" title=\"Zoom in context\">-</button>";
		sTemp += "<button id=\"planningContextZoomUpButton\" onclick=\"planningContextZoomButtonClicked(1)\" title=\"Zoom Out context\"\">+</button>";
		sTemp += "</div>";
		sTemp += "</div>"
		document.getElementById("floorplanTitle").innerHTML = sTemp;
		detailImage = document.getElementById("floorplanimage"); //("floorplanimageDiv");
		if(g_bAllowContextZoom && (contextobj.contextType === "FLOOR")) {
			if(bPlanningContextClicked) {
				element = document.getElementById("planningContextZoomDownButton");
				if(element !== null) 
					element.disabled = true;
				g_oPlanningContextZoom.multiplierIncrement = 0;
				g_oPlanningContextZoom.floorplanObjs = JSON.parse(JSON.stringify(floorplanObjs));
				g_oPlanningContextZoom.url = url;
				g_oPlanningContextZoom.json1 = JSON.parse(JSON.stringify(json1));
			}
			else {
				if(mode === 0) {

				}
				else { // zoom
					
					if((g_oPlanningContextZoom.multiplierIncrement > 0) || (zoomIncrement > 0))
						g_oPlanningContextZoom.multiplierIncrement += zoomIncrement;
					if(g_oPlanningContextZoom.multiplierIncrement === 0) {
						element = document.getElementById("planningContextZoomDownButton");
						if(element !== null) 
							element.disabled = true;
						}
				}
				g_oPlanningContextZoom.multiplier = g_oPlanningContextZoom.multiplierDefault + g_oPlanningContextZoom.multiplierIncrement;
				multiplier = g_oPlanningContextZoom.multiplier;
				offsets = detailImage.getBoundingClientRect();
				detailImage.width = (offsets.width * multiplier);
				detailImage.height = (offsets.height * multiplier);
			}
		}
		else if((g_bplanningContextZoomButtons) && (g_bAllowContextZoom && ((contextobj.contextType === "ROOM") || (contextobj.contextType === "AREA")) && (json.length === 1))) {
			
			if(mode === 0) {
				
				g_oPlanningContextZoom.floorplanObjs = JSON.parse(JSON.stringify(floorplanObjs));
				g_oPlanningContextZoom.url = url;
				g_oPlanningContextZoom.json1 = JSON.parse(JSON.stringify(json1));
				if(!bPlanningContextClicked) {
					if(g_oPlanningContextZoom.zoomFullScreenMode === 0) {
						bFullFloorplan = true;
						element = document.getElementById("planningContextZoomDownButton");
							if(element !== null) 
								element.disabled = true;
					}
					else if(g_oPlanningContextZoom.bFullFloorplan) {
						//element = document.getElementById("planningContextZoomButtonDiv");
						//if(element !== null) 
						//	element.style.display = "none";
					}
				}
			}
			if(mode === 1) {
				if(g_oPlanningContextZoom.zoomFullScreenMode === 0) { //Needed to know when to transisition to multiplier before going to full screen mode -1=context always in full screen mode, 1=zoom mode, 0=in zoom full screen 
					if(zoomIncrement === 1) {
						g_oPlanningContextZoom.multiplier = g_oPlanningContextZoom.multiplierDefault + zoomIncrement;
						g_oPlanningContextZoom.multiplierIncrement = 1;
						g_oPlanningContextZoom.zoomFullScreenMode = 1; //back in zoom mode
						g_oPlanningContextZoom.polygonMarginX1 = g_oPlanningContextZoom.xMargin;
						g_oPlanningContextZoom.polygonMarginX2 = g_oPlanningContextZoom.xMargin;
						g_oPlanningContextZoom.polygonMarginY1 = g_oPlanningContextZoom.yMargin;
						g_oPlanningContextZoom.polygonMarginY2 = g_oPlanningContextZoom.yMargin;
					}
				}
				else {
					g_oPlanningContextZoom.multiplier += zoomIncrement;  //should be +1 or -1
					if(g_oPlanningContextZoom.zoomFullScreenMode === 1) {
						if(zoomIncrement === -1) {
							if(g_oPlanningContextZoom.multiplier <= g_oPlanningContextZoom.multiplierDefault) {
								bFullFloorplan = true;
								g_oPlanningContextZoom.zoomFullScreenMode = 0; // in full screen mode
								g_oPlanningContextZoom.minZoomMultiplier = g_oPlanningContextZoom.multiplier - zoomIncrement;
								g_oPlanningContextZoom.multiplier = g_oPlanningContextZoom.multiplierDefault;
								g_oPlanningContextZoom.multiplierIncrement = 0;
								element = document.getElementById("planningContextZoomDownButton");
								if(element !== null) 
									element.disabled = true;
							}
							else 
								g_oPlanningContextZoom.multiplier += zoomIncrement;  //should be +1 or -1
						}
						else {
							g_oPlanningContextZoom.multiplierIncrement += zoomIncrement;
						}
					}

				}
				

			}
		}
		else 
			bPlanningContextClicked = true;

		//if()
		//	sTemp
		
		
		sTemp = "";
		
		offsets = detailImage.getBoundingClientRect(); 
		
		if (bPlanningContextClicked) {
			g_oPlanningContextZoom.imgWidth = detailImage.width;
			g_oPlanningContextZoom.imgHeight = detailImage.height;
			if(g_bAllowContextZoom && ((contextobj.contextType === "ROOM") || (contextobj.contextType === "AREA"))) {
				if((g_oPlanningContextZoom.imgWidth === -1) || (g_oPlanningContextZoom.imgHeight === -1)) {
					
				}
			}
			else  {
				// zoom in if image width is less than 1000
				if(offsets.width > 0 ) {
					if(offsets.width < minImageWidth) {
						multiplier = (minImageWidth / offsets.width);
						multiplier =  Math.ceil(multiplier);
						if(multiplier > 1) {
							detailImage.width = (offsets.width * multiplier);
							detailImage.height = (offsets.height * multiplier);
							offsets = detailImage.getBoundingClientRect(); 
						}
						else 
							multiplier = 1;


					}
				}
				if(mode === 0) {
					g_oPlanningContextZoom.multiplier = multiplier;
					g_oPlanningContextZoom.minMultiplier = multiplier;
					g_oPlanningContextZoom.multiplierIncrement = 0;
					g_oPlanningContextZoom.multiplierDefault = multiplier; // shows full floorplan
				}
			}
		}
		else {
			multiplier = g_oPlanningContextZoom.multiplier;
		}
		
		detailImage.style.visibility = "visible";
		
		if(json !== null) {
			

			for(i=0; i < json.length; i++)
			{ // get x1,x2, y1 and y2 to figure out width and height
				bContinue = false;
				bContinue1 = true;
				/*
				if((mode === 1) && (g_oPlanningContextZoom.multiplier < g_oPlanningContextZoom.multiplierDefault) && (g_bAllowContextZoom && ((contextobj.contextType === "ROOM") 
					|| (contextobj.contextType === "AREA")) && (json.length === 1))) {
					bFullFloorplan = true;
					//bContinue1 = false; // show full floorplan
					if(g_oPlanningContextZoom.zoomFullScreenMode === 1)  //Needed to know when to transisition to multiplier before going to full screen mode -1=context always in full screen mode, 1=zoom mode, 0=in zoom full screen 
						g_oPlanningContextZoom.minZoomMultiplier = g_oPlanningContextZoom.multiplier;
					g_oPlanningContextZoom.multiplier = g_oPlanningContextZoom.multiplierDefault;
					element = document.getElementById("planningContextZoomDownButton");
					if(element !== null)
						element.disabled = true;
				}
				*/
				obj = {};
				obj.x1 = -1;
				obj.x2 = -1;
				obj.y1 = -1;
				obj.y2 = -1;
				obj.width = 0;
				obj.height = 0;
				if((contextobj.contextType === "FLOOR") || ((contextobj.contextType === "ROOM") && (contextobj.children.length > 0)))
					bContinue = true;
				else if(contextobj.contextualEntityId === json[i].id)
					bContinue = true;
				if(bContinue) {
					coordinates = json[i].polygon.coordinates['0'];
					for(j=0; j < coordinates.length; j++) 
					{
						var cordinate = coordinates[j];
						if(j==0) {
							x1 = x2 = cordinate['0'];
							y1 = y2 = cordinate['1'];
							//sTemp= x1 + "," + y1;
						}
						else {
							
							if(x1 > cordinate['0'])
								x1 = cordinate['0'];
							if(x2 < cordinate['0'])
								x2 = cordinate['0'];
							if(y1 > cordinate['1'])
								y1 = cordinate['1'];
							if(y2 < cordinate['1'])
								y2 = cordinate['1'];
							//sTemp += " " +  cordinate['0'] + "," +  cordinate['1'];
						}
					}
					
					obj.x1 = x1;
					obj.x2 = x2;
					obj.y1 = y1;
					obj.y2 = y2;
					obj.width = x2 - x1; // polygon 
					obj.height = y2 - y1; // polygon 
					if(g_bAllowContextZoom && ((contextobj.contextType === "ROOM") || (contextobj.contextType === "AREA")) && (json.length === 1) && bContinue1) {
						if(g_oPlanningContextZoom.bFullFloorplan || bFullFloorplan ) {
							multiplier = g_oPlanningContextZoom.multiplier;
							g_oPlanningContextZoom.polygonMarginX1 = 0;
							g_oPlanningContextZoom.polygonMarginX2 = 0;
							g_oPlanningContextZoom.polygonMarginY1 = 0;
							g_oPlanningContextZoom.polygonMarginY2 = 0;
							roomOffsetx = 0;
							roomOffsety = 0;
							detailImage.width = (offsets.width * multiplier);
							detailImage.height = (offsets.height * multiplier);
							offsets = detailImage.getBoundingClientRect(); 
							bFullFloorplan = true;
							if(bPlanningContextClicked) {
								element = document.getElementById("planningContextZoomDownButton");
								if(element !== null) 
									element.disabled = true;
							}
						}
						else { // only when you first add the page
							// determine multipler for room and area
							// zoom in if image width is less than 1000
							bContinue1 = true;
							multiplier = 1;
							if((obj.width < (g_oPlanningContextZoom.imgWidth / 2)) && (obj.width < g_oPlanningContextZoom.zoomMaxWidth)) {
								// do multiplier
								if(g_oPlanningContextZoom.zoomInitialMaxHeight > (screen.height - 120))
									g_oPlanningContextZoom.zoomMaxHeight = screen.height - 120;
								else 
									g_oPlanningContextZoom.zoomMaxHeight = g_oPlanningContextZoom.zoomInitialMaxHeight;
								
								detailImage.style.display = "none";
								detailImage.id = detailImage.id + "1";
								detailImage = null;
								detailImage = document.createElement("DIV");
								detailImage.id = "floorplanimage";
								detailImage.style.backgroundRepeat = "no-repeat";
								detailImage.style.width = g_oPlanningContextZoom.imgWidth + "px";
								detailImage.style.height = g_oPlanningContextZoom.imgHeight + "px";
								//detailImage.setAttribute("class", "img-zoom-lens");
								detailImage.style.backgroundImage = "url(data:image/png;base64," + contextobj.image.image + ")";
								detailImage.style.backgroundRepeat = "no-repeat";
								document.getElementById("floorplanimageDiv").appendChild(detailImage);
								detailImage = document.getElementById("floorplanimage");
								if(bPlanningContextClicked) {
									expand = 0;
									if(obj.width > 0 ) {
										if(obj.width > (3/4 * g_oPlanningContextZoom.imgWidth )) {
											if(obj.width < minImageWidth) {
												multiplier = (minImageWidth / offsets.width);
												multiplier =  Math.ceil(multiplier);
												/*
												if(multiplier > 1) {
													detailImage.width = (obj.width * multiplier);
													detailImage.height = (obj.height * multiplier);
													offsets = detailImage.getBoundingClientRect(); 
												}
												else 
													multiplier = 1;
							*/
												expand = obj.width * 0.1;
											}
										}
										else if((g_oPlanningContextZoom.imgWidth) < g_oPlanningContextZoom.zoomMaxWidth) {
											if((g_oPlanningContextZoom.imgHeight) < g_oPlanningContextZoom.zoomMaxHeight) {
												multiplier = g_oPlanningContextZoom.imgWidth / obj.width;
												multiplier =  Math.ceil(multiplier);
												expand = obj.width * 0.2;
												if((multiplier * obj.height) > g_oPlanningContextZoom.zoomMaxHeight) {
													//multiplier = multiplier * (g_oPlanningContextZoom.zoomMaxHeight - obj.height) / g_oPlanningContextZoom.zoomMaxHeight;
													offsets = detailImage.getBoundingClientRect();
													//multiplier = (offsets.top + window.pageYOffset + g_oPlanningContextZoom.zoomMaxHeight + g_oPlanningContextZoom.yMargin + g_oPlanningContextZoom.yMargin) / obj.height;
													multiplier = (screen.height - (offsets.height + window.pageYOffset)) / obj.height;
													//multiplier =  Math.floor(multiplier);
													expand = obj.height * 0.1;
													if(multiplier < 1)
														multiplier = 1;
												}
											}
											else {
												multiplier = g_oPlanningContextZoom.zoomMinHeight / obj.height;
												multiplier =  Math.ceil(multiplier);
												expand = obj.height * 0.2;
											}
										}
										else {
											
											multiplier = g_oPlanningContextZoom.zoomMinWidth /  obj.width;
											multiplier =  Math.ceil(multiplier);
											expand = obj.width * 0.2;
										}
										if(multiplier > 1) {
											detailImage.width = (obj.width * multiplier);
											detailImage.height = (obj.height * multiplier);
											offsets = detailImage.getBoundingClientRect(); 
										}
										else 
											multiplier = 1;
											
											if(mode === 0) { //g_oPlanningContextZoom.multiplier === -1) {
												g_oPlanningContextZoom.multiplier = multiplier;
												g_oPlanningContextZoom.minMultiplier = multiplier;
												g_oPlanningContextZoom.multiplierIncrement = 0;
												g_oPlanningContextZoom.multiplierDefault = multiplier; // shows full floorplan
												if(offsets.width < minImageWidth) {
													g_oPlanningContextZoom.multiplierDefault = (minImageWidth / offsets.width);
													g_oPlanningContextZoom.multiplierDefault =  Math.ceil(g_oPlanningContextZoom.multiplierDefault);
												}
												if(g_oPlanningContextZoom.multiplierDefault < 1)
													g_oPlanningContextZoom.multiplierDefault = 1;
												g_oPlanningContextZoom.polygonWidth = obj.width;
												g_oPlanningContextZoom.polygonHeight = obj.height;
												g_oPlanningContextZoom.polygonX1 = obj.x1;
												g_oPlanningContextZoom.polygonX2 = obj.x2;
												g_oPlanningContextZoom.polygonY1 = obj.y1;
												g_oPlanningContextZoom.polygonY2 = obj.y2;
												g_oPlanningContextZoom.polygonMarginX1 = g_oPlanningContextZoom.xMargin;
												g_oPlanningContextZoom.polygonMarginX2 = g_oPlanningContextZoom.xMargin;
												g_oPlanningContextZoom.polygonMarginY1 = g_oPlanningContextZoom.yMargin;
												g_oPlanningContextZoom.polygonMarginY2 = g_oPlanningContextZoom.yMargin;
												g_oPlanningContextZoom.polygonInitialMarginX1 = g_oPlanningContextZoom.xMargin;
												g_oPlanningContextZoom.polygonInitialMarginX2 = g_oPlanningContextZoom.xMargin;
												g_oPlanningContextZoom.polygonInitialMarginY1 = g_oPlanningContextZoom.yMargin;
												g_oPlanningContextZoom.polygonInitialMarginY2 = g_oPlanningContextZoom.yMargin;
												g_oPlanningContextZoom.expandZoom = expand;
												g_oPlanningContextZoom.zoomFullScreenMode = 1;
												g_oPlanningContextZoom.minZoomMultiplier = 1;
												//calculate margins
												if((x1 - g_oPlanningContextZoom.polygonMarginX1) < 0)
													g_oPlanningContextZoom.polygonMarginX1 = x1;
												if((x2 + g_oPlanningContextZoom.polygonMarginX2) > g_oPlanningContextZoom.imgWidth)
													g_oPlanningContextZoom.polygonMarginX2 = g_oPlanningContextZoom.imgWidth - x2;
												if((y1 - g_oPlanningContextZoom.polygonMarginY1) < 0)
													g_oPlanningContextZoom.polygonMarginY1 = y1;
												if((y2 + g_oPlanningContextZoom.polygonMarginY2) > g_oPlanningContextZoom.imgHeight)
													g_oPlanningContextZoom.polygonMarginY2 = g_oPlanningContextZoom.imgHeight - y2;
												roomOffsetx = x1 - g_oPlanningContextZoom.polygonMarginX1;
												roomOffsety = (g_oPlanningContextZoom.imgHeight - y2) - g_oPlanningContextZoom.polygonMarginY2;
												//roomOffsety = y1 - g_oPlanningContextZoom.polygonMarginY1;
												//roomOffsety = (y2 - g_oPlanningContextZoom.polygonMarginY2);
												//roomOffsety = (y2 + g_oPlanningContextZoom.yMargin);


												/*
												g_oPlanningContextZoom.top = -1;
												g_oPlanningContextZoom.left = -1;
												g_oPlanningContextZoom.right = -1;
												g_oPlanningContextZoom.bottom = -1;
												g_oPlanningContextZoom.xMargin = 10;
												g_oPlanningContextZoom.yMargin = 10;
												g_oPlanningContextZoom.multiplier = -1;
												
												g_oPlanningContextZoom.zoomMinHeight = -1;
												g_oPlanningContextZoom.zoomMaxHeight = -1;
												g_oPlanningContextZoom.minMultiplier = -1;
												*/
											}
											/*
											//context zoom is based on offsets from top down.
											detailImage.style.width = ((obj.width + g_oPlanningContextZoom.polygonMarginX1 + g_oPlanningContextZoom.polygonMarginX2) *  multiplier) + "px";
											detailImage.style.height = ((obj.height + g_oPlanningContextZoom.polygonMarginY1 + g_oPlanningContextZoom.polygonMarginY2) *  multiplier) + "px";	
											detailImage.style.backgroundSize = (g_oPlanningContextZoom.imgWidth *  multiplier) + "px " + (g_oPlanningContextZoom.imgHeight *  multiplier) + "px";
											detailImage.style.backgroundPosition = "-" + ((x1 - g_oPlanningContextZoom.polygonMarginX1) * multiplier) + "px -" + (((g_oPlanningContextZoom.imgHeight - y2) - g_oPlanningContextZoom.polygonMarginY2)  * multiplier) + "px";
											*/
									}
								}
								else {
									multiplier = g_oPlanningContextZoom.multiplier;
									g_oPlanningContextZoom.polygonMarginX1 = g_oPlanningContextZoom.polygonInitialMarginX1;
									g_oPlanningContextZoom.polygonMarginX2 = g_oPlanningContextZoom.polygonInitialMarginX2;
									g_oPlanningContextZoom.polygonMarginY1 = g_oPlanningContextZoom.polygonInitialMarginY1;
									g_oPlanningContextZoom.polygonMarginY2 = g_oPlanningContextZoom.polygonInitialMarginY2;
									if((mode === 1) && (bFullFloorplan)) {
										
										g_oPlanningContextZoom.polygonMarginX1 = 0;
										g_oPlanningContextZoom.polygonMarginX2 = 0;
										g_oPlanningContextZoom.polygonMarginY1 = 0;
										g_oPlanningContextZoom.polygonMarginY2 = 0;
										bContinue1 = false;
										element = document.getElementById("planningContextZoomDownButton");
										if(element !== null) 
											element.style.enabled = false;
									}
									else if((mode === 1) && (g_oPlanningContextZoom.multiplierIncrement < 0)) {
										
										g_oPlanningContextZoom.polygonMarginX1 = g_oPlanningContextZoom.polygonInitialMarginX1 - (g_oPlanningContextZoom.multiplierIncrement * g_oPlanningContextZoom.expandZoom);
										g_oPlanningContextZoom.polygonMarginX2 = g_oPlanningContextZoom.polygonInitialMarginX2 - (g_oPlanningContextZoom.multiplierIncrement * g_oPlanningContextZoom.expandZoom);
										g_oPlanningContextZoom.polygonMarginY1 = g_oPlanningContextZoom.polygonInitialMarginY1 - (g_oPlanningContextZoom.multiplierIncrement * g_oPlanningContextZoom.expandZoom);
										g_oPlanningContextZoom.polygonMarginY2 = g_oPlanningContextZoom.polygonInitialMarginY2 - (g_oPlanningContextZoom.multiplierIncrement * g_oPlanningContextZoom.expandZoom);
										
									}
									if((x1 - g_oPlanningContextZoom.polygonMarginX1) < 0)
										g_oPlanningContextZoom.polygonMarginX1 = x1;
									if((x2 + g_oPlanningContextZoom.polygonMarginX2) > g_oPlanningContextZoom.imgWidth)
										g_oPlanningContextZoom.polygonMarginX2 = g_oPlanningContextZoom.imgWidth - x2;
									if((y1 - g_oPlanningContextZoom.polygonMarginY1) < 0)
										g_oPlanningContextZoom.polygonMarginY1 = y1;
									if((y2 + g_oPlanningContextZoom.polygonMarginY2) > g_oPlanningContextZoom.imgHeight)
										g_oPlanningContextZoom.polygonMarginY2 = g_oPlanningContextZoom.imgHeight - y2;
									roomOffsetx = x1 - g_oPlanningContextZoom.polygonMarginX1;
									roomOffsety = (g_oPlanningContextZoom.imgHeight - y2) - g_oPlanningContextZoom.polygonMarginY2;
								}
								if(bContinue1) {
									detailImage.style.width = ((obj.width + g_oPlanningContextZoom.polygonMarginX1 + g_oPlanningContextZoom.polygonMarginX2) *  g_oPlanningContextZoom.multiplier) + "px";
									detailImage.style.height = ((obj.height + g_oPlanningContextZoom.polygonMarginY1 + g_oPlanningContextZoom.polygonMarginY2) *  g_oPlanningContextZoom.multiplier) + "px";	
									detailImage.style.backgroundSize = (g_oPlanningContextZoom.imgWidth *  g_oPlanningContextZoom.multiplier) + "px " + (g_oPlanningContextZoom.imgHeight *  g_oPlanningContextZoom.multiplier) + "px";
									detailImage.style.backgroundPosition = "-" + ((x1 - g_oPlanningContextZoom.polygonMarginX1) * g_oPlanningContextZoom.multiplier) + "px -" + (((g_oPlanningContextZoom.imgHeight - y2) - g_oPlanningContextZoom.polygonMarginY2)  * g_oPlanningContextZoom.multiplier) + "px";
								}
								else {

								}
							}
							else { // full size
								if(bPlanningContextClicked) {
									if(offsets.width > 0 ) {
										if(offsets.width < minImageWidth) {
											multiplier = (minImageWidth / offsets.width);
											multiplier =  Math.ceil(multiplier);
											if(multiplier > 1) {
												detailImage.width = (offsets.width * multiplier);
												detailImage.height = (offsets.height * multiplier);
												offsets = detailImage.getBoundingClientRect(); 
											}
											else 
												multiplier = 1;
						
						
										}
									}
									g_oPlanningContextZoom.multiplier = multiplier;
									g_oPlanningContextZoom.multiplierDefault = multiplier;
									g_oPlanningContextZoom.bFullFloorplan = true;
									g_oPlanningContextZoom.polygonMarginX1 = 0;
									g_oPlanningContextZoom.polygonMarginX2 = 0;
									g_oPlanningContextZoom.polygonMarginY1 = 0;
									g_oPlanningContextZoom.polygonMarginY2 = 0;
									g_oPlanningContextZoom.zoomFullScreenMode = 0; //Needed to know when to transisition to multiplier before going to full screen mode -1=context always in full screen mode, 1=zoom mode, 0=in zoom full screen 
									element = document.getElementById("planningContextZoomDownButton");
									if(element !== null) 
										element.disabled = true;
								}
								else {
									multiplier = g_oPlanningContextZoom.multiplier;
									roomOffsetx = 0; //x1 - g_oPlanningContextZoom.polygonMarginX1;
									roomOffsety = 0;
									//if(g_oPlanningContextZoom.bFullFloorplan) {
									//	element = document.getElementById("planningContextZoomButtonDiv");
									//	if(element !== null)
									//		element.style.display = "none";
									//}
									detailImage.width = (offsets.width * multiplier);
									detailImage.height = (offsets.height * multiplier);
									offsets = detailImage.getBoundingClientRect(); 
								}
							}
						}
					}
				}
				coordList.push(obj);
			}
			//if(g_bAllowContextZoom && ((contextobj.contextType === "ROOM") || (contextobj.contextType === "AREA")) && (json.length === 1)) 
			//	multiplier = g_oPlanningContextZoom.multiplier;
			for(i=0; i < json.length; i++)
			{
				// add polygon
				bContinue = false;
				if(contextobj.contextType === "FLOOR")
					bContinue = true;
				else if((contextobj.contextType === "ROOM") && (contextobj.children.length > 0)) {
					for(j=0; j < contextobj.children.length; j++) 
					{
						if(contextobj.children[j].id === json[i].contextId) {
							bContinue = true;
							break;
						}
					}
					
				}
				else if(contextobj.contextualEntityId === json[i].id)
					bContinue = true;
				if(bContinue) {
					coordinates = json[i].polygon.coordinates['0'];
					sTemp = "";
					x = coordList[i].x1;
					y = coordList[i].y1;
					if((contextobj.contextType !== "FLOOR") && (json.length === 1)) {
						//room and area zoom
						//x = x - roomOffsetx; // may need to remove - used for room and area zoom
						//y = y - roomOffsety;
					}

					for(j=0; j < coordinates.length; j++) 
					{
						var coordinate = coordinates[j];
						sTemp += " " +  ((coordinate['0'] - x) * multiplier) + "," +  ((coordList[i].height - (coordinate['1'] - y)) * multiplier);
					}
					if(g_bAllowContextZoom && ((contextobj.contextType === "ROOM") || (contextobj.contextType === "AREA")) && (json.length === 1) 
						&& (g_oPlanningContextZoom.polygonWidth !== -1) && !bFullFloorplan) {
						//fix polygon for context zoom
						x = ((coordList[i].x1 - g_oPlanningContextZoom.polygonX1 + g_oPlanningContextZoom.polygonMarginX1) * multiplier);//-  (width / 2);
						y = (g_oPlanningContextZoom.polygonMarginY2 * multiplier);
						//"planningPaneDetails"	
						//x = offsets.x + window.pageXOffset + ((coordList[i].x1 - g_oPlanningContextZoom.polygonX1 + g_oPlanningContextZoom.polygonMarginX1) * multiplier);//-  (width / 2);
						//y = offsets.top + window.pageYOffset + (g_oPlanningContextZoom.polygonMarginY2 * multiplier);


					}
					else {
						
						x = (coordList[i].x1 * multiplier);
						y = ((g_oPlanningContextZoom.imgHeight - coordList[i].y2) * multiplier);
						//"planningPaneDetails"
						//x = offsets.x + window.pageXOffset + (coordList[i].x1 * multiplier);
						//y = offsets.bottom + window.pageYOffset - ((coordList[i].height + coordList[i].y1) * multiplier);
					}
					//sTemp = "<polygon points=\"" + sTemp + "\" style=\"fill:" + json[i].color + ";stroke:" + json[i].color + ";stroke-width:3\" opacity=\"0.3\"/>";
					sTemp = "<polygon points=\"" + sTemp + "\" style=\"fill:" + json[i].color + ";stroke:black;stroke-width:3\" opacity=\"0.3\" />"
					sTemp = "<div id=\"polygonDiv_" + i + "\"  style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:4\"> <svg width=\"" + ( coordList[i].width * multiplier) + "\" height=\"" + (coordList[i].height * multiplier) + "\"><g><title>" + json[i].name + "</title>" + sTemp + "</g></svg></div>";
					//sTemp = "<div id=\"polygonDiv_" + i + "\"  style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:4\"> <svg width=\"" + ( coordList[i].width * multiplier) + "\" height=\"" + (coordList[i].height * multiplier) + "\"><title>" + json[i].name + "</title>" + sTemp + "</svg></div>";
					//sTemp = "<div id=\"polygonDiv_" + i + "\" style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:4\"> <svg width=\"" + ( coordList[i].width * multiplier) + "\" height=\"" + (coordList[i].height * multiplier) + "\">" + sTemp + "</svg></div>";				
					// title doesn't work sTemp = "<div id=\"polygonDiv_" + i + "\" title=\"" + json[i].name + "\" style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:4\"> <svg width=\"" + ( coordList[i].width * multiplier) + "\" height=\"" + (coordList[i].height * multiplier) + "\">" + sTemp + "</svg></div>";				
					document.getElementById("floorplanimageDiv").innerHTML += sTemp;
					//document.getElementById("planningPaneDetails").innerHTML += sTemp;
					//g_oPLanningContextDivs.push("polygonDiv_" + i); // for planningPaneDetails"
					
				}
		
			}
		}
		
		if(json1 !== null) {
			//place device shape on image
			for(i=0; i < json1.length; i++)
			{
				if(json1[i].hasOwnProperty('floorCoordinates')) {
					//if(json1[i].floorCoordinates.floorId === contextualEntityId) {
					bContinue = false;
					id = -1;
					if(contextobj.contextType !== "FLOOR") {
						//room or area, determine if device in room/area
						for(j=0; j < json1[i].contexts.length; j++)
						{
							if(json1[i].contexts[j] === contextobj.id) {
								bContinue = true;
								break;
							}
							else {
								for(k =0; k < contextobj.children.length; k++) 
								{
									if(contextobj.children[k].id === json1[i].contexts[j]) {
										bContinue = true;
										break;
									}
								}
							}
						}
					}


					if((json1[i].floorCoordinates.floorId === floorId) && ((contextobj.contextType === "FLOOR") || ((contextobj.contextType !== "FLOOR") && bContinue))) {
						// if floor show all devices on floor, if room/area only show its devices
						count ++;
						var coordinate = json1[i].floorCoordinates;
						// check if more than one device at same location, if so only add one and assign device to group
						z = -1;
						if(json1[i].status.state === "provisioned") {
							if((json1[i].status.health === "normal") || (json1[i].category === "SC"))
								color = "lawngreen";
							else if(json1[i].status.health === "down")
								color = "red";
							else if(json1[i].status.health === "suspect")
								color = "yellow";
							else
								color = "darkred";
						}
						else if(json1[i].status.state === "unlicensed")
							color = "#BA55D3";
						else if(json1[i].status.state === "provisioning")
							color = "cyan";
						else 
							color = "blue";
						for(j=0; j < g_planningFloorplanGroups.length; j++) 
						{
							if((g_planningFloorplanGroups[j].x === coordinate['x']) && (g_planningFloorplanGroups[j].y === coordinate['y'])) {
								g_planningFloorplanGroups[j].deviceList.push(JSON.parse(JSON.stringify(json1[i])));
								if(g_planningFloorplanGroups[j].color !== color) {
									if(((g_planningFloorplanGroups[j].color === "blue") || (g_planningFloorplanGroups[j].color === "cyan") || (g_planningFloorplanGroups[j].color === "#BA55D3"))
										&& ((color === "blue") || (color === "cyan") || (color === "#BA55D3")))
										changeColor = "blue";
									else
										changeColor = "yellow";
								}
								/*
								if((color === "red") && (g_planningFloorplanGroups[j].color !== "red"))
									changeColor = color;
								else if((color === "#BA55D3") && (g_planningFloorplanGroups[j].color !== "#BA55D3"))
									changeColor = color;
								else if((color === "yellow") && (g_planningFloorplanGroups[j].color !== "red") && (g_planningFloorplanGroups[j].color !== "yellow"))
									changeColor = color;
								else if((color === "cyan") && (g_planningFloorplanGroups[j].color !== "red") && (g_planningFloorplanGroups[j].color !== "yellow") && (g_planningFloorplanGroups[j].color !== "cyan"))
									changeColor = color;
								else if((color === "blue") && (g_planningFloorplanGroups[j].color !== "red") && (g_planningFloorplanGroups[j].color !== "yellow") && (g_planningFloorplanGroups[j].color !== "cyan")
									&& (g_planningFloorplanGroups[j].color !== "blue"))
									changeColor = color;
								else if(color !== g_planningFloorplanGroups[j].color)
									changeColor = color;
*/
								if(changeColor !== "") {
									g_planningFloorplanGroups[j].color = changeColor;
									if (g_bShowDeviceStatusInFloorplan !== 0)
										document.getElementById(g_planningFloorplanGroups[j].displayId).style.fill = changeColor;
								}
								z = j;
								break;
							}
						}
						if(z === -1) {
							//place device shape on image
							if(g_bAllowContextZoom && ((contextobj.contextType === "ROOM") || (contextobj.contextType === "AREA")) && (json.length === 1) 
								&& (g_oPlanningContextZoom.polygonWidth !== -1)  && !bFullFloorplan) {
								//fix for context zoom
								x = ((coordinate['y'] - roomOffsetx) * multiplier) - (width / 2);
								y = ((g_oPlanningContextZoom.polygonY2 - coordinate['x'] + g_oPlanningContextZoom.polygonMarginY2) * multiplier) + (width / 2);
								
								//x = offsets.x + window.pageXOffset + ((coordinate['y'] - roomOffsetx) * multiplier) - (width / 2);
								//y = offsets.top + window.pageYOffset + ((g_oPlanningContextZoom.polygonY2 - coordinate['x'] + g_oPlanningContextZoom.polygonMarginY2) * multiplier) + (width / 2);
								
							}
							else {
								x = (coordinate['y'] * multiplier)  - (width / 2);
								y = ((g_oPlanningContextZoom.imgHeight - coordinate['x']) * multiplier)  - (width / 2);
								//x = offsets.x + window.pageXOffset + (coordinate['y'] * multiplier) - (width / 2);
								//y = offsets.bottom + window.pageYOffset - (coordinate['x'] * multiplier) + (width / 2);
							}
		
							groupNum = g_planningFloorplanGroups.length;
							sTemp = "<div id=\"deviceMenuDiv_" + json1[i].name + "\" style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:7\">";
							//sTemp += "<svg height=\"32\" width=\"32\"> <circle id=\"deviceMenu_" + json1[i].name + "\" cx=\"16\" cy=\"16\" r=\"14\" stroke=\"black\" stroke-width=\"3\" fill=\"" + color + "\"";
							//sTemp += " onclick=\"getPlanningFloorplanMenu(" + groupNum + ")\">"
							sTemp += "<svg height=\"32\" width=\"32\">";
							sTemp += "<g><title>" + json1[i].name  + "</title>";
							sTemp += "<circle id=\"deviceMenu_" + json1[i].name + "\"  cx=\"16\" cy=\"16\" r=\"14\" stroke=\"black\" stroke-width=\"3\" fill=\"" + color + "\"";
							sTemp += " onclick=\"getPlanningFloorplanMenu(" + groupNum + ")\" />";
							//sTemp += " onclick=\"menuDevice(2, event," + json1[i].id + ", '" + json1[i].name  + "', '" + json1[i].typeId  + "')\">";
							//sTemp += " /></svg> </div>";
							sTemp += "</g>";
							sTemp += "</svg> </div>";
							
							//g_oPLanningContextDivs.push("deviceMenuDiv_" + json1[i].name);

							obj = {};
							obj.displayId = "deviceMenu_" + json1[i].name;
							obj.color = color;
							obj.deviceList = [];
							obj.x = coordinate['x'];
							obj.y = coordinate['y'];
							obj.textX = x;
							obj.textY = y;
							obj.contextType = contextobj.contextType; // needed for context breadcrumbs later on
							obj.contextId = contextobj.id; // needed for context breadcrumbs later on
							obj.content = ""; // since a floor may have more than one device at different locations, we need to save dp values next to device location.
							obj.deviceList.push(JSON.parse(JSON.stringify(json1[i])));
							g_planningFloorplanGroups.push(obj);
							if (g_bShowDeviceStatusInFloorplan !== 0) 
								document.getElementById("floorplanimageDiv").innerHTML += sTemp;
								//document.getElementById("planningPaneDetails").innerHTML += sTemp;
							if(contextobj.contextType !== "FLOOR") {
								if(getPlanningTreeShowTreeFloorplanShowDevicesCheckContext(contextobj.id, json1[i].contexts)) {
									if(g_iContextTableX === 0) {
										g_iContextTableX = x;
										
									}
									else if(x < g_iContextTableX)
										g_iContextTableX = x;
									if(g_iContextTableY === 0) {
										g_iContextTableY = y;
										
									}
									else if(y > g_iContextTableY) {
										g_iContextTableY = y;
										
									}
									contextobj.iContextTableX = g_iContextTableX;
									contextobj.iContextTableY = g_iContextTableY;
								}
							}


						}
						
					}
				}
			}
			for(i=0; i < g_planningFloorplanGroups.length; i ++) {
				if(g_planningFloorplanGroups[i].deviceList.length > 1) {
					if(g_bAllowContextZoom && ((contextobj.contextType === "ROOM") || (contextobj.contextType === "AREA")) && (json.length === 1) && (g_oPlanningContextZoom.polygonWidth !== -1)) {
						//fix for context zoom
						if(g_planningFloorplanGroups[i].deviceList.length < 10) {
							x = ((coordinate['y'] - roomOffsetx) * multiplier) - (width / 2) - 8;
							y = ((g_oPlanningContextZoom.polygonY2 - coordinate['x'] + g_oPlanningContextZoom.polygonMarginY2) * multiplier) + (width / 2);
						}
						else if(g_planningFloorplanGroups[i].deviceList.length < 10) {
							x = ((coordinate['y'] - roomOffsetx) * multiplier) - (width / 2) - 12;
							y = ((g_oPlanningContextZoom.polygonY2 - coordinate['x'] + g_oPlanningContextZoom.polygonMarginY2) * multiplier) + (width / 2);
						}
						else {
							x = ((coordinate['y'] - roomOffsetx) * multiplier) - (width / 2) - 15;
							y = ((g_oPlanningContextZoom.polygonY2 - coordinate['x'] + g_oPlanningContextZoom.polygonMarginY2) * multiplier) + (width / 2);
						}
					}
					else {
						if(g_planningFloorplanGroups[i].deviceList.length < 10) {
							x = (g_planningFloorplanGroups[i].y * multiplier) + (width / 2) - 8;
							y = ((g_oPlanningContextZoom.imgHeight - g_planningFloorplanGroups[i].x) * multiplier) + (width / 2) + 5;

						}	
						else if(g_planningFloorplanGroups[i].deviceList.length < 100) {
							x = (g_planningFloorplanGroups[i].y * multiplier) + (width / 2) - 12;
							y = ((g_oPlanningContextZoom.imgHeight - g_planningFloorplanGroups[i].x) * multiplier) + (width / 2) + 5;

						}
						else {
							x = (g_planningFloorplanGroups[i].y * multiplier) + (width / 2) - 15;
							y = ((g_oPlanningContextZoom.imgHeight - g_planningFloorplanGroups[i].x) * multiplier) + (width / 2) + 5;

						}
							//x = (coordinate['y'] * multiplier)  - (width / 2);
							//	y = ((g_oPlanningContextZoom.imgHeight - coordinate['x']) * multiplier)  - (width / 2);
								//x = offsets.x + window.pageXOffset + (coordinate['y'] * multiplier) - (width / 2);
								//y = offsets.bottom + window.pageYOffset - (coordinate['x'] * multiplier) + (width / 2);
						
						/* ffix for context zoom
						if(g_planningFloorplanGroups[i].deviceList.length < 10) {
							x = offsets.x + window.pageXOffset + (g_planningFloorplanGroups[i].y * multiplier) + (width / 2) - 8;
							y = offsets.bottom + window.pageYOffset - (g_planningFloorplanGroups[i].x * multiplier) + (width / 2) + 5;
						}
						else if(g_planningFloorplanGroups[i].deviceList.length < 100) {
							x = offsets.x + window.pageXOffset + (g_planningFloorplanGroups[i].y * multiplier) + (width / 2) - 12;
							y = offsets.bottom + window.pageYOffset - (g_planningFloorplanGroups[i].x * multiplier) + (width / 2) + 5;
						}
						else  {
							x = offsets.x + window.pageXOffset + (g_planningFloorplanGroups[i].y * multiplier) + (width / 2) - 15;
							y = offsets.bottom + window.pageYOffset - (g_planningFloorplanGroups[i].x * multiplier) + (width / 2) + 5;
						}
						*/
					}
					sTemp = "<div id=\"groupDiv_" + i + "\" style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:8; color:black\" onclick=\"getPlanningFloorplanMenu(" + i + ")\">" + g_planningFloorplanGroups[i].deviceList.length + "</div>";
					//sTemp = "<div style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:8; color:white; cursor:default\" onclick=\"getPlanningFloorplanMenu(" + i + ")\">888</div>";
					if (g_bShowDeviceStatusInFloorplan !== 0) {
						document.getElementById("floorplanimageDiv").innerHTML += sTemp;
						//document.getElementById("planningPaneDetails").innerHTML += sTemp;
						//g_oPLanningContextDivs.push("groupDiv_" + i);
						// rename id for groups of devices
						document.getElementById("deviceMenu_" + g_planningFloorplanGroups[i].deviceList[0].name).id = "deviceMenu1_" + i;  // change id for groups so no conflict with devicemenu_<name>
					}
					/*
					// keep for future grahics
					if(g_planningFloorplanGroups[i].deviceList.length < 10) {
						r = 10;
						w = (2 * r) +  4;
						x1 = ((w / 2) - 5);
						y1 = ((w / 2) + 5);
						x2 = 6;
						y2 = 0;
					}
					else if(g_planningFloorplanGroups[i].deviceList.length < 100) {
						r = 12;
						w = (2 * r) +  4;
						x1 = ((w / 2) - 8);
						y1 = ((w / 2) + 5);
						x2 = 8;
						y2 = 4;
					}
					else  {
						r = 15;
						w = (2 * r) +  4;
						x1 = ((w / 2) - 12);
						y1 = ((w / 2) + 5);
						x2 = 8;
						y2 = 2;
					}
					var x = offsets.x + window.pageXOffset + (g_planningFloorplanGroups[i].y * multiplier) + (w - x2);
					var y = offsets.bottom + window.pageYOffset - (g_planningFloorplanGroups[i].x * multiplier) - ((w / 4) - y2);
					sTemp = "<div style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:7\">";
					sTemp += "<svg height=\"" + w + "\" width=\"" + w + "\"> <circle id=\"deviceMenu_" + json1[i].name + "\" cx=\"" + (w / 2) + "\" cy=\"" + (w / 2) + "\" r=\"" + r + "\" stroke=\"yellow\" stroke-width=\"3\" fill=\"yellow\" />";
					sTemp += "<text x=\"" + x1 + "\" y=\"" + y1 + "\">" + g_planningFloorplanGroups[i].deviceList.length + "</text></svg></div>"
					document.getElementById("planningPaneDetails").innerHTML += sTemp;
					*/
				}
				
			}
			
		} 
		planningCount = document.getElementById("planningDeviceCount");
		g_iDisplayIndex = 0;
		if(planningCount !== null) {
			g_sContextDpQualifierList = "";
			g_sContextDpQualifierDeviceList = []; //used for alarms
			g_displayTypeList = []; // used to use "s3" or "s4" for SNVT_switch
			if((contextobj.contextType === "REGION") || (contextobj.contextType === "CAMPUS") || (contextobj.contextType === "BUILDING"))
				getPlanningFloorPlanShowContextDps(contextobj); // added for navtree
			if((contextobj.contextType === "FLOOR") || (count === 0)) {
				planningCount.innerText = "  [" + count + " devices]";
				try {
					for(m=0; m < floorplanObjs.contextobj.children.length; m++)
					{
						if(floorplanObjs.contextobj.children[m].children.length > 0) { 
							// floor/room/area
							for(m1=0; m1 < floorplanObjs.contextobj.children[m].children.length; m1++)
							{
								getPlanningFloorPlanShowContextDps(floorplanObjs.contextobj.children[m].children[m1], true); 
						
							}
						}
						getPlanningFloorPlanShowContextDps(floorplanObjs.contextobj.children[m], true); // room or area
					}
				}
				catch {}
				getPlanningFloorPlanShowContextDps(contextobj,true); // added for navtree

			}
			else if((contextobj.contextType === "ROOM") || (count > 0)) {
				planningCount.innerText = "  [" + count + " devices]";
				try {
					//room/area
					for(m=0; m < floorplanObjs.contextobj.children.length; m++)
					{
						getPlanningFloorPlanShowContextDps(floorplanObjs.contextobj.children[m], false); // room or area
					}
				}
				catch {}
				getPlanningFloorPlanShowContextDps(contextobj,false); // added for navtree
				//getPlanningFloorPlanShowContextDps(contextobj,true); // added for navtree

			}
			else {
				planningCount.innerText = "  [" + contextobj.devices.length + "/" + count + " floor devices]";
				getPlanningFloorPlanShowContextDps(contextobj, false); // added for navtree
			}
			planningCount.style.visibility = "visible";
			
			
			/*
			if(sTemp !== "") {
				if((contextobj.contextType === "FLOOR") || (!g_bShowRoomTableContextOnImage)) {
					document.getElementById("planningPaneDetails").innerHTML += "<br>" + sTemp;
					//document.getElementById("planningPaneDetails").innerHTML += "<div style=\"inline-block\">" + sTemp + "</div>";
				}
				else {
					//room and area
					g_iContextTableX += iTableOffsetX;
					g_iContextTableY += iTableOffsetY;
					sTemp = "<div style=\"position:absolute;left:" + g_iContextTableX +"px;top:" + g_iContextTableY + "px; background-color: white;padding:5px;z-index:10\">" + sTemp + "</div>"
					document.getElementById("planningPaneDetails").innerHTML += sTemp;
				}
			}
			*/
			for(i=0; i < g_planningFloorplanGroups.length; i ++) {
				// place datapoint list for each group fffix
				if(g_planningFloorplanGroups[i].content !== "") {

					try {
						content = g_planningFloorplanGroups[i].content;
						if(!g_bShowRoomTableContextOnImage) {
							//if((contextobj.contextType === "FLOOR") || (!g_bShowRoomTableContextOnImage)) {
							document.getElementById("planningPaneDetails").innerHTML += "<br>" + content;
							
						}
						else {
							//room and area
							z = -1;
							x = null;
							y = null;
							iXoffset = null;
							iYoffset = null;
							
							//for(j=0; j < g_planningFloorplanGroups[i].deviceList.length; j++)
							//{
							//	for(k=0; k < g_planningFloorplanGroups[i].deviceList[j].contexts.length; k++)
							//	{
									//if(g_planningFloorplanGroups[i].deviceList[j].contexts[k] === contextobj.id) {
										x = g_planningFloorplanGroups[i].textX;
										y = g_planningFloorplanGroups[i].textY;
										iXoffset = g_planningFloorplanGroups[i].textiXoffset;
										iYoffset = g_planningFloorplanGroups[i].textiYoffset;
									//	z = contextobj.id;
									//	break;
									//}
							//	}
							//	if(z !== -1)
							//		break;
							//}
								
							
							if((x !== null) && (y !== null) && g_bAtLeastOneDeviceFound) {
			
								
								sTemp = "<div id=\"groupDpDiv_" + i + "\" style=\"position:absolute;left:";
								if((iXoffset === 0) && (iYoffset === 0))
									sTemp += (x + g_iContextTableOffsetX);
								else
									sTemp += (x + iXoffset);
								sTemp += "px;top:";
								if((iXoffset === 0) && (iYoffset === 0))
									sTemp += (y + g_iContextTableOffsetY);
								else
									sTemp += (y + iYoffset);
								content = sTemp + "px; background-color:white;padding:5px;border-radius:10px;border: 1px solid black;z-index:5\">" + content + "</div>";
								document.getElementById("floorplanimageDiv").innerHTML += content;
								//document.getElementById("planningPaneDetails").innerHTML += content;
								//g_oPLanningContextDivs.push("groupDpDiv_" + i);
							}
						}
						
					}
					catch {}
				}
			}
			//if(!g_bPlanningContextClicked && (g_oPlanningContextZoom.contextDpsListResponse.mode !== -1) && (g_oPlanningContextZoom.contextDpsListResponse.json.length !== 0)) {
			//	getPlanningContextDpsListResponse(g_oPlanningContextZoom.contextDpsListResponse.mode, g_oPlanningContextZoom.contextDpsListResponse.json, g_oPlanningContextZoom.contextDpsListResponse.json);
			//}
			if(g_bShowAlarms && (g_sContextDpQualifierDeviceList.length > 0)) {
			
				obj1 = g_sContextDpQualifierDeviceList[0];
				g_sContextDpQualifierDeviceList.shift();
				obj = {};
				obj.mode = 11;
				obj.deviceName = obj1.deviceName;
				obj.deviceId = obj1.deviceId;
				getPlanningGetAlarmsForDevice(obj);
			}
			else if(g_sContextDpQualifierList !== "") {
				url = "https://" + location.host + "/iap/devs/*/if/*/*/*+qualifier=-" + g_sContextDpQualifierList + "/*?noxs=true";
				requestGetData(0, url, getPlanningContextDpsListResponse, null);
			}
		}
	}
	catch {}
	cursorClearWait();
}

function getPlanningTreeShowTreeFloorplanShowDevicesCheckContext(currentContextId,list) {
	// check if ContextId is in list
	var bResult = false;
	var i;
	try {
		if(list !== null) {
			for(i=0; i < list.length; i++)
			{
				if(currentContextId === list[i]) {
					bResult = true;
					break;
				}
			}
		}
	}
	catch {}
	return bResult;
}
function getPlanningFloorplanMenu(groupNum) {
	try {
		var sTemp = "", i, list, sResult = "", jon1, status = "";
		if(groupNum < g_planningFloorplanGroups.length) {
			if(g_planningFloorplanGroups[groupNum].deviceList.length === 1) {
				menuDeviceFloorplan(2, null, g_planningFloorplanGroups[groupNum].deviceList[0].id , g_planningFloorplanGroups[groupNum].deviceList[0].name, g_planningFloorplanGroups[groupNum].deviceList[0].typeId, g_planningFloorplanGroups[groupNum].deviceList[0].protocol);
			}
			else {
				// create Div to show all datapoints
				list = g_planningFloorplanGroups[groupNum].deviceList;
				for(i = 0; i < list.length; i++)
				{
					
					if(typeof list[i].id !== "number") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					else if (typeof list[i].name !== "string") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					else if (typeof list[i].deviceTypeName !== "string") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					//sResult += "<tr class=\"planningdevicetableTr\"><td><button class=\"clickabletext\" onclick=\"showDeviceByName(0, '" + list[i].name + "')\">" + list[i].name + "</button></td></tr>"; //ffix
					
					
					sResult += "<tr class=\"planningdevicetableTr\"><td class=\"planningdevicetableTd\">";
					sResult += "<div><canvas id=\"canvas_" + list[i].name +"\" width=\"12\" height=\"12\"></canvas></div>"; 
					

					sResult += "</td><td class=\"planningdevicetableTd\"><button id=\"deviceMenu_" + list[i].name + "\" class=\"clickabletext\"";
					//sResult += " onclick=\"menuDevice(1, event," + list[i].id + ", '" + list[i].name  + "', '" + list[i].deviceTypeName  + "')\">";
					sResult += " onclick=\"menuDeviceFloorplan(2, event," + list[i].id + ", '" + list[i].name  + "', '" + list[i].deviceTypeName  + "', '" + list[i].protocol  + "')\">";
					sResult += list[i].name + "</button></td></tr>"; 
				}
				
				if(sResult !== "") { 
					//sResult = "<hr><div class=\"planningdevicetableDiv\"><table id=\"myTablePlanningTree\" class=\"planningdevicetable\"><tbody>" + sResult + "</tbody></table></div>";
					sResult = "<div class=\"planningdevicetableDiv\"><table id=\"myTablePlanningTree\" class=\"planningdevicetable\"><tbody>" + sResult + "</tbody></table></div>";
					//sResult = "<br>" + json['path'] + "<button style=\"margin-left:40px;\" onclick=\"showContextDevices(" + id + ")\">Show Devices Detail</button><br><br>" + sResult;
					
					//sortTable(0); 
				}
				

				for(i=0; i < g_planningFloorplanGroups[groupNum].deviceList.length; i ++)
				{
					
					sTemp += "<div>" + g_planningFloorplanGroups[groupNum].deviceList[i].name;
				}
				
				var x = 0;
				var y = 0;
		
				//var menuContent ="<div style=\"display:flex;width:300px\"><div style=\"display:inline-block;float:left\">Devices: ";
				var menuContent ="<div style=\"width:300px\"><div style=\"display:inline-block;float:left\">Devices: ";
				menuContent += g_planningFloorplanGroups[groupNum].deviceList.length;
				//menuContent +=  "</div><div style=\"display:inline-block;float:right\"><button class=\"closeButton\" onclick=\"planningMenuCancel()\">X</button></div></div><br>";
				menuContent +=  "</div><button class=\"closeButton\" onclick=\"planningMenuCancel()\">X</button></div><br>";
				g_bAlwaysIngnoreMouseClick = false;
				g_menuDivXOffset = 35;
				g_menuDivYOffset = 30;
				g_menuDivWidth = 150;
				
				menuContent += "<div>" + sResult + "</div>";
				var menuButton = document.getElementById("deviceMenu1_" + groupNum);
				var offsets;
				
				if(menuButton !== null) {
					offsets = menuButton.getBoundingClientRect(); 
					if((offsets.x + offsets.width + window.pageXOffset + g_menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
						x = offsets.x + window.pageXOffset - g_menuDivWidth - 10; // takes into account viewport (scrolling)
					else
						x = offsets.x + offsets.width + window.pageXOffset + g_menuDivXOffset; // takes into account viewport (scrolling)
					y = offsets.y + window.pageYOffset - g_menuDivYOffset; // takes into account viewport (scrolling)
					document.getElementById("planningDiv").style.left = x.toString() + "px";
					document.getElementById("planningDiv").style.top = y.toString() + "px";
					document.getElementById("planningDiv").innerHTML = menuContent;
					if(sResult !== "") {
						for(i = 0; i < list.length; i++)
						{
							status = "normal";
							if(typeof list[i].deviceStatus === "undefined") {
								if(list[i].category === "SC") {
								}
								else if(list[i].status.state === "provisioned") {
									status = list[i].status.health;
								}
								else {
									status = list[i].status.state;
								}

							}
							else {
								status = list[i].deviceStatus;
							}
							deviceStatusColorCanvas("canvas_" + list[i].name, list[i].category, status);
							//deviceStatusColor("canvas_" + list[i].id, list[i].deviceStatus);
						}
					}
					document.getElementById("planningDiv").className = "planningDivShow"; // doesn't currently guaranty that menu is shown in viewport
					g_bInoreMouseClick = true;
					//document.addEventListener("click", planningMenuCancel);
					menuOverlayDivShow(1, null);
				}
				
					
				 
			}
		}

		
	}
	catch {}
}
function getPlanningTreeShowTreeFloorplanShowPolygonsFail (id) {
	try { 
		var 
		sTemp = "<br>Problem getting floorplan info";
		document.getElementById("planningPaneDetails").innerHTML = sTemp;

	}
	catch {}
}

function getPlanningFloorPlanShowContextDps(contextobj, bFloor) {
	//Determines which datapoints to show
	var content = "";
	var i, j, k, m, x=null, y = null, z;
	var items = [];
	var x1;
	var sTemp = "", sTemp1, sTemp2, sTemp3="";
	var customFields = {};
	var displayType = "n";
	var obj = {};
	var bAddBr = false;
	var nameItems = [];
	var iDpDisplayType = 0; // 0=show as table, 1 show as textonly
	var dpList = [], dpList1 = [];
	var label = "";
	var bContinue = true;
	var tempObj;
	var bShow = true;
	var bShowFloor = true;
	var units = "", color = "", field = "", size, precision;
	var item;
	var writeable = "";
	var bReadonly;
	var bWrite = false;
	var iXoffset = 0, iYoffset = 0, iTemp; 
	var bLocalContextSettingsUsed = true;
	
	
	if(contextobj === null) 
		return;
	try {
		customFields = contextobj.customFields;
		if(contextobj.contextType !== "FLOOR")
			iDpDisplayType = 1;

		for(x in customFields)
		{
			x1 = x.toLowerCase();
			if(x1 === "label")
				label = customFields[x];
			else if (x === "offsetx") {
				sTemp1 = customFields[x];
				try {
					iTemp = Number(sTemp1);
					if(!isNaN(iTemp))
						iXoffset = iTemp;
				}
				catch {}
			}
			else if (x === "offsety") {
				sTemp1 = customFields[x];
				try {
					iTemp = Number(sTemp1);
					if(!isNaN(iTemp))
						iYoffset = iTemp;
				}
				catch {}
			}
			else if (x === "show") {
				
				if(customFields[x].toLowerCase() === "false")
					bShow = false;
			}
			else if (x === "floor") {
				
				if(customFields[x].toLowerCase() === "false")
					bShowFloor = false;
			}
			else if(x.startsWith("dp")) {
				obj = {};
				obj.name = x + " ";
				obj.parameters = customFields[x];
				dpList1.push(obj);
			}
		}
		x = null;
		if(contextobj.contextType === "FLOOR") {
			if(!bShowFloor)
				return; // don't show on floor context
		}
		else {
			if(!bShow)
				return; // don't show on floor context
		}
		if(label !== "")
			sTemp += label + "<br>"; 
		if(dpList1.length > 0) {
			// reorder
			for(i=0; i < dpList1.length; i++)
			{
				dpList.unshift(dpList1[i]);
			}
			while(bContinue)
			{
				bContinue = false;
				for(i=0; i < (dpList.length - 1); i++)
				{
					if(dpList[i].name > dpList[i + 1].name) {
						tempObj = JSON.parse(JSON.stringify(dpList[i]));
						dpList[i] = JSON.parse(JSON.stringify(dpList[i + 1]));
						dpList[i + 1] = tempObj;
						bContinue = true;
					}
				}
			}
		}
		if(dpList1.length === 0) {
			// no context dps so use campus tags
			bLocalContextSettingsUsed = false;
			if(g_campusTags !== null) {
				if(g_campusTags.deviceTypesList.length > 0) {
					devices = contextobj.devices;
					if(devices.length > 0) {
						for(i=0; i < devices.length; i++)
						{
							for(k=0; k < g_campusTags.deviceTypesList.length; k++) 
							{
								for(m=0; m < g_campusTags.deviceTypesList[k].dpList.length; m++)
								{
									for(j=0; j < 3; j++)
									{
										if(j===0) {
											// looks for device name
											if((g_campusTags.deviceTypesList[k].type === "devicename") && (g_campusTags.deviceTypesList[k].name === devices[i].name.toLowerCase())) {
												if((bFloor && (g_campusTags.deviceTypesList[k].dpList[m].contexts.indexOf("floor") !== -1))
													|| (!bFloor && (g_campusTags.deviceTypesList[k].dpList[m].contexts.indexOf("room") !== -1))) {
														obj = {};
														obj = JSON.parse(JSON.stringify((g_campusTags.deviceTypesList[k].dpList[m])))
														obj.name = devices[i].name + "/" + obj.name;
														dpList.push(obj);
														break;
												}
											}
										}
										else if(j===1) {
											// look for device type
											if((g_campusTags.deviceTypesList[k].type === "devicetype") && (g_campusTags.deviceTypesList[k].name === devices[i].deviceTypeName.toLowerCase())) {
												if((bFloor && (g_campusTags.deviceTypesList[k].dpList[m].contexts.indexOf("floor") !== -1))
													|| (!bFloor && (g_campusTags.deviceTypesList[k].dpList[m].contexts.indexOf("room") !== -1))) {
														obj = {};
														obj = JSON.parse(JSON.stringify((g_campusTags.deviceTypesList[k].dpList[m])))
														obj.name = devices[i].name + "/" + obj.name;
														dpList.push(obj);
														break;
												}
											}
										}
										else  {
											// look for programid
											if((g_campusTags.deviceTypesList[k].type === "programid") && (g_campusTags.deviceTypesList[k].name === devices[i].programId.toLowerCase())) {
												if((bFloor && (g_campusTags.deviceTypesList[k].dpList[m].contexts.indexOf("floor") !== -1))
													|| (!bFloor && (g_campusTags.deviceTypesList[k].dpList[m].contexts.indexOf("room") !== -1))) {
														obj = {};
														obj = JSON.parse(JSON.stringify((g_campusTags.deviceTypesList[k].dpList[m])))
														obj.name = devices[i].name + "/" + obj.name;
														dpList.push(obj);
														break;
												}
											}
										}
									}
								}
							}
						}
						// reorder based on context
						if(dpList.length > 0) {
							bContinue = true;
							while(bContinue)
							{
								bContinue = false;
								for(i=0; i < (dpList.length - 1); i++)
								{
									if(dpList[i].contextOrder > dpList[i + 1].contextOrder) {
										tempObj = JSON.parse(JSON.stringify(dpList[i]));
										dpList[i] = JSON.parse(JSON.stringify(dpList[i + 1]));
										dpList[i + 1] = tempObj;
										bContinue = true;
									}
								}
							}
						}
					}
				}
			}
		}
		for(k=0; k < dpList.length; k++)
		{
			displayType = "r";
			label = "";
			units = "";
			color = "";
			sTemp1 = "";
			field = "";
			size = -1;
			precision = -1;
			bReadonly = false; //bReadonly = true;
			try {
				if(bLocalContextSettingsUsed) {
					if(dpList[k].parameters !== "") {
						
						sTemp1 = dpList[k].parameters;
						bWrite = false;
						
						if(sTemp1.indexOf(",") !== -1)
							items = sTemp1.split(",");
						else 
							items.push(sTemp1);
							
							
						try {
							for(i=0; i < items.length; i++)
							{
								item = items[i].trim();
								if(i===0) {
									//datapoint path
								}
								else if(item.startsWith("label=")) {
									label = item.substr("label=".length).trim();
								}
								else if(item.startsWith("displaytype=")) {
									
									displayType = item.substr("displaytype=".length).toLowerCase();
									if((displayType === "l2") || (displayType === "l3") || (displayType === "l4") || (displayType === "s2") || (displayType === "s3") || (displayType === "s4")){
										// datapoint needs to be SNVT_switch
									}
									else if(displayType === "r") {
										// read-only "n"
									}
									else
										displayType = "n";
								}
								else if(item.startsWith("units=")) {
									units = item.substr("units=".length);
								}
								else if(item.startsWith("field=")) {
									field = item.substr("field=".length);
								}
								else if(item.startsWith("color=")) {
									color = item.substr("color=".length);
								}
								else if(item.startsWith("precision=")) {
									sTemp2 = item.substr("precision=".length);
									if(!isNaN(sTemp2)) 
									obj1.precision =  Number(sTemp2);
								}
								else if(item.startsWith("size=")) {
									// only used on floorplan, not dashboard
									sTemp2 = item.substr("size=".length);
									if(!isNaN(sTemp2)) 
										obj1.size = Number(sTemp2);
								}
								else if(item.startsWith("write=")) {
									// need to take into account write priorities
									// all datapoints are read-only unless specifed by write.  valid "all", "none", or combination of "o" = owner, "s" = supervisor, "u" = user
									//   e.g.,   "write=owner" means write for only owner, "write=super" means write for owner and supervisor, 
									sTemp1 = item.substr("write=".length).toLowerCase();
									writeable = 0;
									if(sTemp1 === "all")
										writeable = 7;
									else {
										
										if(sTemp1 === "none") {
										}
										else if(sTemp1 === "owner")
											writeable = 4;
										else if(sTemp1 === "super")
											writeable = 6;
									}
									bWrite = false;
									if(g_bSingleUserType)
										bWrite = checkIfUserTypeSupported(writeable);
									else if(writeable === "all")
										bWrite = true;
								}
								else if(item.startsWith("readonly=")) {
									sTemp1 = item.substr("readonly=".length);
									if(sTemp1 === "false")
										bReadonly = false;
								}
							} // for(i=0; i < items.length; i++)
						}
						catch {}
							
						obj = {};
						obj.displayType = displayType; 
						obj.field = field;
						obj.fieldPath = "";
						sTemp1 = items[0].trim();
						sTemp1 = getPlanningFloorPlanShowContextDpsDeviceName(sTemp1, contextobj);
						
					}
				}
				else { 	//Use Campus Tags bLocalContextSettingsUsed = false;
					sTemp1 = dpList[k].name;
					displayType = dpList[k].contextDisplayType;
					label = dpList[k].label
					units = dpList[k].units;
					color = dpList[k].backgroundColor;
					field = dpList[k].field;
					bReadonly = dpList[k].readonly;
					size = dpList[k].size;
					precision = dpList[k].precision
					
				}

				if(sTemp1 !== "") { // full path using device name
					obj = {};
					obj.displayType = displayType; 
					obj.field = field; // field including subfields
					obj.fieldPath = "";
					
					nameItems = sTemp1.split("/");
					/* //may not need anymore as field is now a separate parameter
					sTemp1 = "";
					for(i=0; i < nameItems.length; i++)
					{
						nameItems[i] = nameItems[i].trim();
						if(i !== 0) {
							sTemp1 += "/";
							obj.fieldPath += "/";
						}
						sTemp1 += nameItems[i];
						if(i > 3) {
							if(obj.field !== "")
								obj.field += "/";
							obj.field += nameItems[i];
						}
						
						obj.fieldPath += nameItems[i];
					} 
					*/
					obj.field = field; // field including subfields
					if(label === "")
						label = nameItems[nameItems.length - 1]
					obj.label = label;
					g_iDisplayIndex ++;
					obj.path = nameItems[0] + "/" + nameItems[1] + "/" + nameItems[2] + "/" + nameItems[3];
					obj.displayIndex = g_iDisplayIndex;
					obj.fieldPath = sTemp1;
					obj.displayId = g_iDisplayIndex + "__"  + sTemp1;
					obj.divDisplayId = "";
					obj.readonly = bReadonly;
					obj.size = size;
					obj.precision = precision;
					//obj.bWriteable = bWrite; // "" = read-only
					obj.backgroundColor = color;
					sTemp = "";
					if(iDpDisplayType === 0) {
						sTemp += "<tr id=\"contextDpDivRow_" + g_iDisplayIndex + "__"  + sTemp1 + "\"><td>";
						sTemp += "<div id=\"datapointName_" +  + g_iDisplayIndex + "__"  + sTemp1 + "\" style=\"display:flex\">"
						sTemp += "<div id=\"bell_" +  + g_iDisplayIndex + "__"  + sTemp1 + "\"></div>"
						sTemp += label + "</div></td><td>";
						sTemp += "<div  id=\"contextDpDiv_" + g_iDisplayIndex + "__"  + sTemp1 + "\" ></div>"
						obj.divDisplayId = "contextDpDiv_" + g_iDisplayIndex + "__"  + sTemp1;
						
						if(units !== "") 
							sTemp += "&nbsp;" + units;
						sTemp += "</td></tr>";
					}
					else {
						//if((sTemp !== "") && bAddBr)
						//	sTemp += "<br>"
						if(displayType === "r") {
							
							sTemp += "<div class=\"contextDpDivRow\">";
							sTemp += "<div id=\"datapointName_" +  + g_iDisplayIndex + "__"  + sTemp1 + "\" style=\"display:flex\">"
							sTemp += "<div id=\"bell_" +  + g_iDisplayIndex + "__"  + sTemp1 + "\"></div>"
							sTemp += "<div class=\"contextDpDivLabel\""; 
							if(g_iShowContextDpLabels === 2)
								sTemp +=  " title =\"" + nameItems[0] + "\""; 
							sTemp += ">";
							if(g_iShowContextDpLabels !== 0)
								sTemp +=  label + ": ";
							sTemp +=  "</div></div>";
							//sTemp += "<span id=\"localValue_" + g_iDisplayIndex + "__" + sTemp1 + "\" ></span>";
							
							sTemp += "<div  class=\"contextDpDivValue\" id=\"contextDpDiv_" + g_iDisplayIndex + "__"  + sTemp1 + "\"";
							if((g_iShowContextDpLabels === 0) && (g_iShowContextToolTip > 0)) {
								sTemp += " title=\"";
								if(g_iShowContextToolTip === 2)
									sTemp +=  label;
								else if(g_iShowContextToolTip === 3)
									sTemp +=  label + " [";
								if((g_iShowContextToolTip === 1) || (g_iShowContextToolTip === 3))
									sTemp += obj.path;
								if(g_iShowContextToolTip === 3)
									sTemp +=  "]";
								sTemp += "\"";
							}
							sTemp += "></div>";
							
							obj.divDisplayId = "contextDpDiv_" + g_iDisplayIndex + "__" + sTemp1;
							bAddBr = true;
						}
						else {
							sTemp += "<div class=\"contextDpDivRow\">";
							sTemp += "<div id=\"datapointName_" +  + g_iDisplayIndex + "__"  + sTemp1 + "\" style=\"display:flex\">"
							sTemp += "<div id=\"bell_" +  + g_iDisplayIndex + "__"  + sTemp1 + "\"></div>"
							sTemp += "<div class=\"contextDpDivLabel\""; 
							if(g_iShowContextDpLabels === 2)
								sTemp +=  " title =\"" + nameItems[0] + "\""; 
							sTemp += ">";
							if(g_iShowContextDpLabels !== 0)
								sTemp +=  label + ": "; 
							sTemp +=  "</div></div>";
							sTemp += "<div  class=\"contextDpDivValue\" id=\"contextDpDiv_" + g_iDisplayIndex + "__"  + sTemp1 + "\"";
							if((g_iShowContextDpLabels === 0) && (g_iShowContextToolTip > 0)) {
								sTemp += " title=\"";
								if(g_iShowContextToolTip === 2)
									sTemp +=  label;
								else if(g_iShowContextToolTip === 3)
									sTemp +=  label + " [";
								if((g_iShowContextToolTip === 1) || (g_iShowContextToolTip === 3))
									sTemp += obj.path;
								if(g_iShowContextToolTip === 3)
									sTemp +=  "]";
								sTemp += "\"";
							}
							sTemp += "></div>";
							
							obj.divDisplayId = "contextDpDiv_" + g_iDisplayIndex + "__" + sTemp1;
							
							bAddBr = false;
						}
						if(units !== "") 
							sTemp += "<div>&nbsp;" + units + "</div>";
						sTemp += "</div>"
					}
					sTemp3 += sTemp;
					g_displayTypeList.push(obj); // used to use "s3" or "s4" for SNVT_switch
					for(i=0; i < g_planningFloorplanGroups.length; i ++)
					{
						for(j=0; j < g_planningFloorplanGroups[i].deviceList.length; j ++)
						{
							if(g_planningFloorplanGroups[i].deviceList[j].name === nameItems[0]) {
								g_planningFloorplanGroups[i].content += sTemp;
								g_planningFloorplanGroups[i].textiXoffset = iXoffset;
								g_planningFloorplanGroups[i].textiYoffset = iYoffset;
								g_bAtLeastOneDeviceFound = true;
								break;
							}
						}
					}
					for(i=0; i < deviceListAll.length; i ++)
					{

						if(deviceList[i].name.toLowerCase() === nameItems[0].toLowerCase()) {
							
							z = -1;
							for(j=0; j< g_sContextDpQualifierDeviceList.length; j++)
							{
								if(g_sContextDpQualifierDeviceList[j].deviceId === deviceListAll[i].id) {
									g_bAtLeastOneDeviceFound = true;
									z = j;
									break;
								}
							}
							if(z === -1) {
								obj = {};
								obj.deviceId = deviceListAll[i].id;
								obj.deviceName = deviceListAll[i].name; //deviceListAll[i].deviceName;
								g_sContextDpQualifierDeviceList.push(obj); // used for alarms
								g_bAtLeastOneDeviceFound = true; // needed for single datapoint
							}


							if(g_sContextDpQualifierList !== "")
								g_sContextDpQualifierList += ",";
							g_sContextDpQualifierList += encodeUriString(deviceListAll[i].scId + "/" +  deviceListAll[i].protocol + "/" + deviceListAll[i].DID + "/" + nameItems[1] + "/" + nameItems[2] + "/" + nameItems[3]);
							break;
						}
					}
				}
			}
			catch {}
			
		} //for(k=0; k < dpList.length; k++)
		if(sTemp3 !== "") {  
			if(iDpDisplayType === 0)
				content = "<table class=\"tableInContext\">" + sTemp3 + "</table>";
			else
				content = sTemp3;
		}
	}
	catch {
		content = "";
	}
	// place on image -- no longer used as a device may be in more than one context and devices can be in more than one location on context
	if(false) {
		try {
			if(content !== "") {
				if((contextobj.contextType === "FLOOR") || (!g_bShowRoomTableContextOnImage)) {
					document.getElementById("planningPaneDetails").innerHTML += "<br>" + content;
					
				}
				else {
					//room and area
					z = -1;
					x = null;
					y = null;
					for(i=0; i <g_planningFloorplanGroups.length; i++)
					{
						for(j=0; j < g_planningFloorplanGroups[i].deviceList.length; j++)
						{
							for(k=0; k < g_planningFloorplanGroups[i].deviceList[j].contexts.length; k++)
							{
								if(g_planningFloorplanGroups[i].deviceList[j].contexts[k] === contextobj.id) {
									x = g_planningFloorplanGroups[i].textX;
									y = g_planningFloorplanGroups[i].textY;
									z = contextobj.id;
									break;
								}
							}
							if(z !== -1)
								break;
						}
						if(z !== -1)
								break;
					}
					if((x !== null) && (y !== null) && bAtLeastOneDeviceFound) {

						
						sTemp = "<div style=\"position:absolute;left:";
						if((iXoffset === 0) && (iYoffset === 0))
							sTemp += (x + g_iContextTableOffsetX);
						else
							sTemp += (x + iXoffset);
						sTemp += "px;top:";
						if((iXoffset === 0) && (iYoffset === 0))
							sTemp += (y + g_iContextTableOffsetY);
						else
							sTemp += (y + iYoffset);
						content = sTemp + "px; background-color:white;padding:5px;border-radius:10px;border: 1px solid black;z-index:5\">" + content + "</div>"
						document.getElementById("planningPaneDetails").innerHTML += content;
					}
				}
			}
		}
		catch {}
	}
	return content;
}
function getPlanningFloorPlanShowContextDpsDeviceName(path, contextobj) {
	// check if device name, device type starts with "[", or program ID starts with "("
	var sResult = path, device;
	var i, iPtr; 
	var blockpath = "";
	var devices = [];
	var bDeviceType = false;
	try {
		sResult = sResult.trim();
		if(contextobj.contextType === "FLOOR")
			devices = deviceListAll;
		else 	if(contextobj.devices !== null) 
			devices = contextobj.devices;
		if(devices.length > 0)	{
			iPtr = path.indexOf("/");
			if(iPtr > 2) { //   {x}/ or [x]/
				device = path.substr(0, iPtr).toLowerCase();
				blockpath = path.substr(iPtr);
				sResult = "";
				if((device.charAt(0) === "[") || (device.charAt(0) === "(")) {
					if(device.charAt(0) === "[")
						bDeviceType = true;
					device = device.substr(1, iPtr - 2).toLowerCase();
					for(i=0; i < devices.length; i++)
					{
						if(bDeviceType) { //sResult.charAt(0) === "[") {
							//check against device types
							if(device === devices[i].deviceTypeName.toLowerCase()) {
								sResult = devices[i].name + blockpath;
								break;
							}

						}
						else {
							// check against program ID
							if(device === devices[i].programId.toLowerCase()) {
								sResult = devices[i].name + blockpath;
								break;
							}

						}
					}
				}
				else  {
					sResult = "";
					for(i=0; i < devices.length; i++)
					{
						
						if(device === devices[i].name.toLowerCase()) {
							sResult = devices[i].name + blockpath;
							break;
						}

					}
				}
			}
			
		}
		else
			sResult = "";
	} catch { sResult = path; }
	return sResult;
}
function getPlanningContextDpsListResponse(mode, requestUrl, json) {
	// got context datapoint (e.g, floor, room, area)
	var i, z, j, k, z,element, contextPath = "";
	var missingValueDps = [];
    var missingSnvtTypes = [];
	var json1, bFound, obj;
	try {
		g_oPlanningContextZoom.contextDpsListResponse = {};
		g_oPlanningContextZoom.contextDpsListResponse.mode = -1;
		g_oPlanningContextZoom.contextDpsListResponse.requestUrl = requestUrl;
		g_oPlanningContextZoom.contextDpsListResponse.json = []; 
		if(json === null)
			return;
		if(json.length !== 0) {
			if(g_bRemoveDuplicateDps) {
				// check if 
				json1 = JSON.parse(JSON.stringify(json));
				json = [];
				for(j=0; j < json1.length; j ++) 
				{
					bFound = false;
					for(i=0; i < json.length; i ++) 
					{
						if(json[i].dpQualifier === json1[j].dpQualifier) {
							bFound = true;
							break;
						}
					}
					if(!bFound) {
						json.push(JSON.parse(JSON.stringify(json1[j])));
					}
				}
				if(json.length === 0)
					return;
			}
		}
		if(json.length === 0) {
			//check if g_s
			element = document.getElementById("planningPaneDetails");
			if(element !== null) {
				if(g_sContextContent !== "") {
					element.innerHTML = "<div  style=\"float:left;cursor:pointer\">" + planningCreateContextbreadcrumbs(g_sSiteDashboardSelected) + "</div>" + g_sContextContent; 
				}
				else  {
					element.innerHTML = "<div style=\"float:left;cursor:pointer\">" + planningCreateContextbreadcrumbs(g_sSiteDashboardSelected) + "</div><br><br>No Content"; 
				}
			}
			return;
		}
		g_oPlanningContextZoom.contextDpsListResponse.mode = mode;
		g_oPlanningContextZoom.contextDpsListResponse.json = JSON.parse(JSON.stringify(json));
		obj = {};
		obj.mode = mode;
		dashboardDpList = JSON.parse(JSON.stringify(json));
		// check if any have value = null
		for(i=0; i < json.length; i++)
		{
			if(json[i].value === null) {
				missingValueDps.push(JSON.parse(JSON.stringify(json[i])))
				
			}
		}
		if(missingValueDps.length > 0){
			//alert("showDashboardUi at least one \"value=null\""); // remove
		   
			for(i=0; i < missingValueDps.length; i++)
			{
				z = -1;
				for(j=0; j < missingSnvtTypes.length; j++)
				{
					if(missingValueDps[i].type ===  missingSnvtTypes[j]) {
						z = j;
						break;
					}
				}
				if(z === -1 ) {
					if((missingValueDps[i].type !== "scalar") && (missingValueDps[i].type !== "float") && (missingValueDps[i].type !== "boolean"))
						missingSnvtTypes.push(JSON.parse(JSON.stringify(missingValueDps[i].type)));
				}
			}
			k = 0;
			if(missingSnvtTypes.length > 0) {
				// check if already have SNVT type
				if(g_snvtTypes.length > 0) {
					z = -1;
					for(i=0; i < missingSnvtTypes; i++)
					{
						for(j=0; j < g_snvtTypes.length; j++)
						{
							if(g_snvtTypes[j].typeId === missingSnvtTypes[i]) {
								z = j;
								break;
							}

						}
					}
					if(z === -1)
						k++;
				}
				else {
					k = missingValueDps.length;
				}
			}
			//alert("Count Dps with value=null: " + missingValueDps.length + ",\r\nmissingSnvtTypes: " + missingSnvtTypes.length + ",\r\nNot In SnvtTypesList: " + k);
			if(k !== 0) {
				if(missingSnvtTypes.length === 1) {
					// get only the missing SNVT Type
					showDashboardUiGetSnvtType(0, obj, missingSnvtTypes[0]);
				}
				else {
					// get all SNVT types
					showDashboardUiGetAllSnvtType(0, obj)
				}
				return;
			}
			
		}
		if(dashboardDpList.length > 0) {
			if(g_sSiteDashboardSelected !== "") {
				showDashboardDeviceDpListResponseForSiteDashboard(0, "", dashboardDpList);
			}
			else
				getPlanningContextDpsListResponseBuildUi(obj);
		}
	}
	catch {}
}
function getPlanningContextDpsListResponseBuildUi(objList) {
	// got context datapoint (e.g, floor, room, area)
	// When first starting up or device just added it is posible that the datapoint value is null, so need to leave element blank until value read
	try {
		// use s1 for span with 
		var i, j, k, m, s, w, x, z, z1,iTemp;
		var json, mode;
		var pathname, programmaticPathname, presetValue, sTemp, colorElement, color,colorType, deviceStatus;
		var value, valueStr, locValue, locValueStr;
		var iPtr;
		var d = new Date();
		var currentTimeMs = d.getTime();
		var t = d.toTimeString();
		var date = d.toLocaleDateString();
		var currentTime = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0);
		var currentTime1 = currentTime + "T";
		var utcTime = d.toUTCString();
		var element, element1, obj, obj1;
		var displayElement = {};
		var displayIndex = 0, displayId, displayElementIndex;
		var bContinue,bContinue2, field, fieldItems, dpTypeParams, dpType;
		
		currentTime += " ";
		iPtr = t.indexOf(" ");
		t = t.substr(0, iPtr);
		currentTime += t + ".000";
		currentTime1 += t + ".000Z[UTC]";

		if(dashboardDpList === null)
			return;
		if(dashboardDpList.length === 0)
			return;
		mode = objList.mode;
		json = JSON.parse(JSON.stringify(dashboardDpList));
		dashboardDpList = [];
		for(i=0; i < json.length; i++)
		{
			z = -1;
			programmaticPathname = json[i].deviceName + "/" + json[i].blockName  + "/" + json[i].blockIndex  + "/" + json[i].datapointName; 
			for(j=0; j < dashboardDpList.length; j++) 
			{
				if(dashboardDpList[j] === programmaticPathname) {
					z = j;
					break;
				}
			}
			if(z === -1) {
				// create dp obj
				obj = {};
				obj = JSON.parse(JSON.stringify(json[i]));
				colorElement = null; color = ""; colorType = "";
				
				//obj.cat = "out"; // Only want DPs, writes not supported
				obj.datapointQualifier = json[i].dpQualifier;
				obj.updateDpValue = true;
				
				pathname = json[i].deviceName + "/" + json[i].blockName  + "/" + json[i].blockIndex  + "/" + json[i].name;
				obj.programmaticPathname = programmaticPathname;
				obj.pathname = pathname;
				obj.block = json[i].blockName  + "/" + json[i].blockIndex;
				obj.urlPath = json[i].deviceName + "/if/" + json[i].blockName + "/" + json[i].blockIndex + "/";
				if(g_iSmartServerVersion >= 320114)
					obj.urlPath += "*+xifName==";
				obj.urlPath += json[i].datapointName;
				obj.dpName = json[i].name;
				try { 
					presetValue = json[i].presetValue;
					if(presetValue === null)
						presetValue = "";
				} catch (err) {}
				obj.presetValue = presetValue;
				obj.bStructure = false;
				obj.bNumber = false;
				obj.bString = false; // enum
				obj.alarm = null;
				obj.displayElements = []; // add one entry for each display element -- used to support fields, or see datapoint more than once on web page
				obj.writePriority = g_OwnerUserTypeWritePriority;
				obj.clearPriority = g_OwnerUserTypeClearPriority;
				obj.custom = {};
				obj.custom.useDefaults = true;
				if(g_currentUser === "SUPERVISOR") {
					obj.writePriority = g_supervisorUserWriteTypePriority;
					obj.clearPriority = g_supervisorUserTypeClearPriority;
				}
				else if(g_currentUser === "USER") {
					obj.writePriority = g_userUserTypeWritePriority;
					obj.clearPriority = g_userUserTypeClearPriority;
				}
				obj.writePriorityStart = 1; 
				obj.writePriorityEnd = 17;
				obj.writePriorityNormal = true;
				if(obj.cat === "in") {
					if(obj.writePriority !== "all") {
						try {
							z = obj.writePriority;
							if(obj.writePriority.charAt(0) !== ">") {
									// single priority
									obj.writePriorityStart = Number(z);
									if((obj.writePriorityStart > 0) && (obj.writePriorityStart < 18)) {
										jobj.writePriorityEnd = obj.writePriorityStart + 1;
										obj.writePriorityNormal = false;
									}
							}
							else {
								// priority 
								if(z.length > 1) {
									z = z.substr(1);
									obj.writePriorityStart = Number(z);
									if((obj.writePriorityStart > 0) && (obj.writePriorityStart < 18)) {
										obj.writePriorityNormal = true;
									}
								}
							}
						}
						catch {
							obj.writePriorityStart = 1
							objwritePriorityEnd = 17;
							obj.writePriorityNormal = true;
						}
					}
				}
				deviceStatus = "";
				if(g_bShowDpDeviceDown) {
					try {
						for(m=0; m < deviceListAll.length; m++)
						{
							if(deviceListAll[m].id === obj.deviceId) {
								deviceStatus = deviceListAll[m].status.state;
								if(deviceStatus === "provisioned") {
									deviceStatus = deviceListAll[m].status.health;
									if(deviceStatus === "normal")
										deviceStatus = "";
								}
							}
						}
					}
					catch {deviceStatus = "";}
				}
				obj.deviceStatus = deviceStatus;
				// check if alarm
				for(m=0; m < g_deviceAlarmsList.length; m++)
				{
					if(g_deviceAlarmsList[m].deviceId === obj.deviceId) {
						for(k=0; k < g_deviceAlarmsList[m].alarms.length; k++)
						{
							if(g_deviceAlarmsList[m].alarms[k].pathname === obj.pathname) {
								obj.alarm = JSON.parse(JSON.stringify(g_deviceAlarmsList[m].alarms[k]));
								m = g_deviceAlarmsList.length + 2;
								break;
							}
						   
						}
					}
				}  
				


				dashboardDpList.push(obj);
				z = dashboardDpList.length - 1;
			
				value = dashboardDpList[z].value;
			
				value = dashboardDpList[z].value;
				displayIndex ++;
				displayId = displayIndex + dashboardDpList[z].programmaticPathname;
				z1 = -1;
				for(k=0; k < g_snvtTypes.length; k++)
				{
					if(obj.type === g_snvtTypes[k].typeId) {
						z1 = k;
						dashboardDpList[z].snvtType = JSON.parse(JSON.stringify(g_snvtTypes[k]))
						break;
					}
				}
				if(z1 !== -1) {
					obj1 = JSON.parse(JSON.stringify(g_snvtTypes[z1]));
					
					if(obj1.valueType.toLowerCase() === "object") {
						dashboardDpList[z].bStructure = true;
					}
					else if(obj1.valueType.toLowerCase() === "boolean") {
						dashboardDpList[z].bNumber = true;
						//dashboardDpList[z].bBoolean = true;
						
					}
					else if(obj1.valueType.toLowerCase() === "enum") {
						dashboardDpList[z].bEnum = true;
						dashboardDpList[z].enums = JSON.parse(JSON.stringify(obj1.typeJson.enum));
					}
					else if(obj1.valueType.toLowerCase() === "string") {
						dashboardDpList[z].bString = true;
					}
					else if((obj1.valueType.toLowerCase() === "integer") || (obj1.valueType.toLowerCase() === "float")  || (obj1.valueType.toLowerCase() === "scalar")){
						dashboardDpList[z].bNumber = true;
					}
				}
				if(dashboardDpList[z].value === null) {
					valueStr = "";
					locValue = "";
					locValueStr = "";
					
					
				}
				else {
					try {
						if(!(typeof dashboardDpList[z].locValue === "undefined"))  {
							locValue = dashboardDpList[z].locValue;
							locValueStr = locValue;
							if(locValue !== null) {
								if(typeof locValue === "number") {
									locValueStr = locValue.toString();
									dashboardDpList[z].bNumber = true;
								}
								else if(typeof locValue === "object") {
									dashboardDpList[z].bStructure = true;
									locValueStr = JSON.stringify(locValue);
									if(locValueStr.length > 2) {
										if((locValueStr.charAt(0) === "{") && (locValueStr.charAt(locValueStr.length - 1) === "}")) {
											dashboardDpList[z].bStructure = true;
											locValueStr = locValueStr.substr(1, (locValueStr.length - 2));
										}
									}
								}
							}
						}	
					} 	catch (err) {}


					
					if(typeof value === "number")
						valueStr = value;
					else
						valueStr = JSON.stringify(value);
				}
				dashboardDpList[z].valueStr = valueStr;
				dashboardDpList[z].locValue = locValue;
				dashboardDpList[z].locValueStr = locValueStr;
				// check displaytype
				
				for(j=0; j < g_displayTypeList.length; j++)
				{ //check device types 
					try {
						// currently only support read only
						if(g_displayTypeList[j].path === dashboardDpList[z].programmaticPathname) {
							displayElementIndex = -1;
							displayElement = {};
							displayElement.dashboardType =g_displayTypeList[j].displayType; // normal
							displayElement.defaultDashboardType = ""; // normal
							displayElement.field = g_displayTypeList[j].field;
							displayElement.fieldPath = g_displayTypeList[j].fieldPath;
							displayElement.backgroundColor = "";
							if(g_displayTypeList[j].backgroundColor !== "")
								displayElement.backgroundColor = g_displayTypeList[j].backgroundColor;
							displayElement.displayIndex = g_displayTypeList[j].displayIndex
							displayElement.displayId = g_displayTypeList[j].displayId;
							displayElement.bNumber = false;
							displayElement.bEnum = false;
							displayElement.enums = [];
							displayElement.bStructure = false;
							displayElement.bString = false;
							displayElement.bBoolean = false;
							displayElement.readonly = g_displayTypeList[j].readonly;
							displayElement.writeable = false; // should be able to rmove this
							displayElement.chartIndex = null;
							displayElement.size = g_displayTypeList[j].size; // used to adjust input element size
							displayElement.precision = g_displayTypeList[j].precision;
							displayElement.bHasPriorityButton = false;
							displayElement.dpTypeNotAssigned = true;
							
							if(typeof dashboardDpList[z].snvtType !== "undefined") {
								dpTypeParams = readSnvtTypeFieldValue(dashboardDpList[z].snvtType, displayElement.field);
								if(dpTypeParams.valid) {
									if(displayElement.field === "")
										dpType = dpTypeParams.data.valueType.toLowerCase();
									else 
										dpType = dpTypeParams.data.type.toLowerCase();
									displayElement.dpTypeNotAssigned = false;
									if(dpType === "object") {
										displayElement.bStructure = true;
									}
									else if(dpType === "boolean") {
										displayElement.bNumber = true;
										//displayElement.bBoolean = true;
										
									}
									else if(dpType === "bitfield") {
										displayElement.bNumber = true;
										
									}
									else if(dpType === "enum") {
										displayElement.bEnum = true;
										displayElement.enums = JSON.parse(JSON.stringify(dpTypeParams.data.typeJson.enum));
									}
									else if(dpType === "string") {
										displayElement.bString = true;
									}
									else if((dpType === "integer") || (dpType === "float")  || (dpType === "scalar")){
										displayElement.bNumber = true;
									}
								}
							}
							else {
								if(dashboardDpList[z].value !== null) {
									if(typeof dashboardDpList[z].value === "object")
										dashboardDpList[z].bStructure = true;
								}
							}
							bContinue = true;
							if((displayElement.field !== "")  && dashboardDpList[z].bStructure) {
								locValue = dashboardDpList[z].locValue;
								
									
								if(dashboardDpList[z].value === null) {
                                    //fix need to support value=null by looking at SNVT type
                                    
                                    locValueStr = "";
                                    if(typeof dashboardDpList[z].snvtType !== "undefined")
                                    	bContinue = false;
                                }
								else if(typeof locValue === "object") {
									fieldItems = readFieldValue(locValue,displayElement.field);
                                    if(fieldItems.valid) {
                                        locValue = fieldItems.data;
                                        bContinue = true;
                                    }
								}
								else 
									bContinue = false;
								
							}
							else {
								
								
								
							}
							if(bContinue) {
								if(typeof dashboardDpList[z].snvtType === "undefined") {
									if(typeof locValue === "string") {
										displayElement.bString = true;
	
									}
									else if(typeof locValue === "number") {
										displayElement.bNumber = true;
										
									}
									else if(typeof locValue === "boolean") {
										displayElement.bBoolean = true;
										
									}
								}
							}
							if(bContinue) {
								if(typeof dashboardDpList[z].snvtType === "undefined") {

								}
								if(displayElement.bStructure) { //if(typeof locValue === "object") {
									if(g_displayTypeList[j].displayType === "r")
										g_displayTypeList[j].displayType = ""; //
									locValueStr = JSON.stringify(locValue);
									if(locValueStr.length > 2) {
										if((locValueStr.charAt(0) === "{") && (locValueStr.charAt(locValueStr.length - 1) === "}")) {
											locValueStr = locValueStr.substr(1, (locValueStr.length - 2));
										}
									}
								}
								else if(typeof locValue === "number") {
									locValueStr = locValue.toString();
								}
								else if(typeof locValue === "boolean") {
									locValueStr = locValue.toString();
								}
								
								//tablePaneContent += "<td id=\"datapointName_" + displayId + "\"";
								//w = 0;
								


								element = document.getElementById(g_displayTypeList[j].divDisplayId)
								if(element !== null) {
									displayElement.dashboardType = "r";
									dashboardDpList[z].displayElements.push(displayElement);
									displayElementIndex = dashboardDpList[z].displayElements.length - 1;
									deviceStatus = "";
									color = ""; // mike
									if(g_bShowDpDeviceDown) {
										deviceStatus = dashboardDpList[z].deviceStatus;
									}
									if(g_bShowDpDeviceDown && (deviceStatus !== "")) {
										color = g_sTableDeviceDownColor;
									}
									else if(dashboardDpList[z].alarm !== null) { 
										if((dashboardDpList[z].alarm.warningLevel < 5) && ((g_iAlarmDisplayType === 1) || (g_iAlarmDisplayType === 3)))  {
											color = g_alarmColors[dashboardDpList[z].alarm.warningLevel];
										}
									}
									if(color !== "") {
										//element = document.getElementById("contextDpDivRow_" + g_displayTypeList[j].divDisplayId);
										element1 = document.getElementById("datapointName_" + displayElement.displayId);
										if(element1 !== null) {
											element1.style.backgroundColor = color; 
											// add vell
											
											sTemp = "<img src=\"images/navtree/Bellred.gif\" alt=\"alarmimage\"onclick=\"alarmMenu(";
											if(!dashboardDpList[z].displayElements[displayElementIndex].readonly && ((displayElement.dashboardType === "s1") || (displayElement.dashboardType === "s2")  
												|| (displayElement.dashboardType === "s3")   || (displayElement.dashboardType === "s4")))
												sTemp += 1; // writable -- use menudpvalue
											else
												sTemp += 0; // readonly -- show only alarm state
											sTemp += ",this," + z + "," + displayElementIndex + ",'bell_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\"";
											sTemp += "><span style=\"margin-left:5px\"></span>";
											element1 = document.getElementById("bell_" + displayElement.displayId);
											if(element1 !== null)
												element1.innerHTML = sTemp;
											//w = 1;
										}
									}

									if(g_displayTypeList[j].displayType === "d") { 
										dashboardDpList[z].displayElements[displayElementIndex].dashboardType = g_displayTypeList[j].displayType;
										sTemp = "";
										//sTemp = "<span id=\"localValue_" + displayElement.displayId + "\" >" + locValueStr + "</span>";
										//if((g_bPlanningShowContextDpMenuButton) && (dashboardDpList[z].cat === "in"))
										//	sTemp += '<button class="planningContextDpMenuButton">...</button>';
										

										if(dashboardDpList[z].displayElements[displayElementIndex].bEnum) {
											//if((field === "") && dashboardDpList[i].isEnum) { // remove
											sTemp += "<div style=\"display:flex\"><select id=\"localValue_" + displayElement.displayId + "\" onchange=\"dashboardDropdownSelected(this," + z + ", " + displayElementIndex + ", '" + dashboardDpList[z].programmaticPathname + "','" + displayElement.displayId + "')\">"; 
											bHasPresets = false;
											valueStr = null; 
											if((field === "") && (dashboardDpList[z].presetValue !== ""))
												valueStr = dashboardDpList[z].presetValue;
											else {
												if(field === "")
													dashboardDpList[z].locValueStr;
												else
													valueStr = dashboardDpList[z].displayElements[displayElementIndex].locValueStr;
											}
											if((field === "") && (typeof dashboardDpList[z].presets !== "undefined")) {
												if(dashboardDpList[z].presets !== null) {
													if(dashboardDpList[z].presets.enabled) {
														if(dashboardDpList[z].presets.map.length > 0) {
															bHasPresets = true;
															for(s=0; s < dashboardDpList[z].presets.map.length; s++)
															{
																name1 = dashboardDpList[z].presets.map[s].name;
																sTemp += "<option value='" + name1 + "'"; 
																if(valueStr === name1)
																	sTemp += " selected";
																sTemp += ">"  + name1 + "</option>";
															}
															
														}
													}
												} 
											}
											enums = [];
											if(dashboardDpList[z].displayElements[displayElementIndex].enums.length > 0) 
												enums = JSON.parse(JSON.stringify(dashboardDpList[z].displayElements[displayElementIndex].enums));
											else {
												for(s=0; s < g_snvtTypes.length; s++)
												{
													if(dashboardDpList[z].type === g_snvtTypes[s].typeId) {
														enums = g_snvtTypes[s];
														temp = readSnvtTypeFieldValue(g_snvtTypes[s], field);
														if(temp.valid) {
															enums = JSON.parse(JSON.stringify(temp.datatypeJson.enum));
														}
													}
												}
											}
												
											for(s = 0; s < enums.length; s++)
											{
												sTemp += "<option value='" + enums[s].id + "'";
												if(valueStr === enums[s].id)
													sTemp += " selected";
												sTemp += ">"  + enums[s].id + "</option>";
											}
											sTemp += "</select>";
											addElementToEditButtonElementList("localValue_" + displayElement.displayId, "d", "disable");
											if(g_bPlanningShowContextDpMenuButton) {
												sTemp += "<button id=\"menu_" + displayElement.displayId + "\" class=\"planningContextDpMenuButton\" onclick=\"menuDpValue1(14,this, " + z + "," + displayElementIndex +  ",'localValue_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">...</button>";
												addElementToEditButtonElementList("menu_" + displayElement.displayId, "menu", "visible");
											}
											sTemp += "</div>";
										}
										element.innerHTML = sTemp;
									}
									
									else if(g_displayTypeList[j].displayType === "r") { //mainly used for context datapoints
										dashboardDpList[z].displayElements[displayElementIndex].dashboardType = g_displayTypeList[j].displayType;
										
										sTemp = "<span id=\"localValue_" + displayElement.displayId + "\"";
										sTemp += " onclick=\"getPlanningTreeShowDashboard(0,'Device_" + dashboardDpList[z].deviceId + "','" + dashboardDpList[z].deviceName + "')\"";
										sTemp += ">" + locValueStr + "</span>";
										//if((g_bPlanningShowContextDpMenuButton) && (dashboardDpList[z].cat === "in"))
										//	sTemp += '<button class="planningContextDpMenuButton">...</button>';
										element.innerHTML = sTemp;
										
									}
									else if(g_displayTypeList[j].displayType === "n") {
										dashboardDpList[z].displayElements[displayElementIndex].dashboardType = g_displayTypeList[j].displayType;
										
										if((dashboardDpList[z].cat === "in") && !displayElement.readonly) {
											//element.innerHTML = "<span id=\"localValue_" + displayElement.displayId + "\" class=\"contextDpSpanInput\" onclick=\"menuDpShow(1)\">" + locValueStr + "</span>";

											if(dashboardDpList[z].displayElements[displayElementIndex].bStructure) {
												
												element.innerHTML = "<div style=\"display:flex\"><span id=\"localValue_" + displayElement.displayId + "\" style=\"display:inline-block;width:150px;border: 1px solid black;;overflow:hidden;white-space:nowrap\"";
												sTemp += " onclick=\"menuDpValue1(14, this, " + z + ", " + displayElementIndex + ", 'localValue_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">";
												sTemp += locValueStr + "</span>";
												dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "s1";
												dashboardDpList[z].displayElements[displayElementIndex].readonly = false;
												addElementToEditButtonElementList("localValue_" + displayId, "s1", "disable");
                                    			if(g_bPlanningShowContextDpMenuButton) {
													sTemp += "<button id=\"menu_" + displayElement.displayId + "\" class=\"planningContextDpMenuButton\" onclick=\"menuDpValue1(14,this, " + z + "," + displayElementIndex +  ",'localValue_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">...</button>";
													addElementToEditButtonElementList("menu_" + displayElement.displayId, "menu", "visible");
												}
												sTemp += "</div>"
											}
											else {
												//ffixMBW need to add code for editmode - not edit then clicking goes to device dashboard
												//element.innerHTML = "<span id=\"localValue_" + displayElement.displayId + "\">" + locValueStr + "</span>";
												sTemp = "<input id=\"localValue_" + displayElement.displayId + "\" value=\"" + locValueStr + "\"";
												z1=0;
												if(dashboardDpList[z].displayElements[displayElementIndex].field === "") {
													if(typeof dashboardDpList[z].presets !== "undefined") {
														if(dashboardDpList[z].presets.map.length > 0) {
															sTemp += " onclick=\"menuDpValue1(11,this, " + z + "," + displayElementIndex +  ",'localValue_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\""
															sTemp += " readonly"; 
															z1 = 1;
														}
													}
													
												}
												else if (dashboardDpList[z].displayElements[displayElementIndex].bNumber) {
													iTemp = -1;
													if(typeof dashboardDpList[z].displayElements[displayElementIndex].size !== "undefined")
														iTemp = dashboardDpList[z].displayElements[displayElementIndex].size;
													if(iTemp === -1) {
														if(g_iPlanningFloorplanInputElementSize !== -1) 
															iTemp = g_iPlanningFloorplanInputElementSize;
													}
													if(iTemp !== -1) {
														if(locValueStr.length > iTemp)
															iTemp = locValueStr.length + 3;
														dashboardDpList[z].displayElements[displayElementIndex].inputSize = iTemp;
														sTemp += " size=\"" + iTemp + "\"";
													}
												}
												if(z1 === 0) {
													sTemp += "	onkeyup=\"inputBoxKey(this, event, " + z + "," +  displayElementIndex + ",'" + displayElement.displayId + "')\"";
												}
												sTemp += ">";
												addElementToEditButtonElementList("localValue_" + displayElement.displayId, "i", "disable");
												if(g_bPlanningShowContextDpMenuButton) {
														sTemp += "<button id=\"menu_" + displayElement.displayId + "\" class=\"planningContextDpMenuButton\" onclick=\"menuDpValue1(14,this, " + z + "," + displayElementIndex +  ",'localValue_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">...</button>";
														addElementToEditButtonElementList("menu_" + displayElement.displayId, "menu", "visible");
												}
												
												
												dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "n";
												
											}
											element.innerHTML = sTemp;
										}
										else {
											/*
											element.innerHTML = "<span id=\"localValue_" + displayElement.displayId + "\" class=\"contextDpSpan\"";
											if(typeof locValue === "object")
												element.innerHTML += " onclick=\"menuDpShow(0)\"";
											element.innerHTML += ">" + locValue + "</span>"; */

											dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "r";
											//class not working sTemp = "<span id=\"localValue_" + displayElement.displayId + "\" class=\"contextDpSpan\"";
											if(typeof locValue === "object") {
												sTemp = "<span id=\"localValue_" + displayElement.displayId + "\" style=\"display:inline-block;width:150px;overflow:hidden;white-space:nowrap\"";
												sTemp += " onclick=\"menuDpPlanningShowStructuredDp(10,this," + z + "," + displayElementIndex + ",'" + programmaticPathname + "')\">";
												sTemp += locValueStr + "</span>";
												dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "s0";
											}
											else {
												sTemp = "<span id=\"localValue_" + displayElement.displayId + "\">" + locValueStr + "</span>";
											}
											element.innerHTML = sTemp;
											
											
										}
										
									}
									else if((g_displayTypeList[j].displayType === "l2") || (g_displayTypeList[j].displayType === "l3") || (g_displayTypeList[j].displayType === "l4")
										|| (g_displayTypeList[j].displayType === "s2") ||(g_displayTypeList[j].displayType === "s3") || (g_displayTypeList[j].displayType === "s4")) {

											

											if(g_displayTypeList[j].displayType === "l2")	{ 
												
												if( (((dashboardDpList[z].type ===  "binary") || (dashboardDpList[z].type ===  "scalar") || (dashboardDpList[z].type ===  "boolean") || (dashboardDpList[z].type.toLowerCase() ===  "bit")
													|| (dashboardDpList[z].type ===  "SNVT_count")) && (displayElement.field === "")) 
														|| ((displayElement.field !== "") && displayElement.bNumber) ) {
													sTemp = '<span id="localValueSwitch_' + displayElement.displayId + '"'; 
													//sTemp = '<span id="localValue_' + displayElement.displayId + '"'; 
													if(dashboardDpList[z].value === null) {

													}
													else if(typeof locValue === "number") {
														if(locValue === 0)
															sTemp += ' class="ledDotOff"';
														else {
															sTemp += ' class="ledDotOn"';
															if(displayElement.backgroundColor !== ""){
																sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
															}
														}
													}
													else if(typeof locValue === "bit") {
														if(locValue === 0)
															sTemp += ' class="ledDotOff"';
														else {
															sTemp += ' class="ledDotOn"';
															if(displayElement.backgroundColor !== ""){
																sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
															}
														}
													}
													else if(typeof locValue === "boolean") {
														if(typeof locValue ===  "boolean") {
															if(locValue === 0)
																sTemp += ' class="ledDotOff"';
															else {
																sTemp += ' class="ledDotOn"';
																if(displayElement.backgroundColor !== ""){
																	sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
																}
															}
																
														}
														else {
															if(locValue === 0)
																sTemp += ' class="ledDotOff"';
															else {
																sTemp += ' class="ledDotOn"';
																if(displayElement.backgroundColor !== ""){
																	sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
																}
															}
																
														}
													}
													sTemp += " onclick=\"getPlanningTreeShowDashboard(0,'Device_" + dashboardDpList[z].deviceId + "','" + dashboardDpList[z].deviceName + "')\"";
													sTemp += '>';
													element.innerHTML = sTemp;
													if(typeof dashboardDpList[z].displayElements[displayElementIndex].color === "undefined") 
														dashboardDpList[z].displayElements[displayElementIndex].color = g_sPlanningLedOnColor;
													else if(dashboardDpList[z].displayElements[displayElementIndex].color === null) 
														dashboardDpList[z].displayElements[displayElementIndex].color = g_sPlanningLedOnColor;
													else if(dashboardDpList[z].displayElements[displayElementIndex].color === "") 
														dashboardDpList[z].displayElements[displayElementIndex].color = g_sPlanningLedOnColor;
													if(dashboardDpList[z].displayElements[displayElementIndex].backgroundColor === "") 
														dashboardDpList[z].displayElements[displayElementIndex].backgroundColor = g_sPlanningLedOffColor;
													dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "l2";
												}
											}
											else if(g_displayTypeList[j].displayType === "s2")	{ // "l4"
												
												if((((dashboardDpList[i].type ===  "binary") || (dashboardDpList[i].type ===  "scalar") || (dashboardDpList[i].type ===  "boolean") || (dashboardDpList[i].type.toLowerCase() ===  "bit")
													|| (dashboardDpList[i].type ===  "SNVT_count"))  && (displayElement.field === "") ) || ((displayElement.field !== "") && displayElement.bNumber)) {
													//sTemp = '<span id="localValueSwitch_' + displayElement.displayId + '"'; 
													if((dashboardDpList[i].type ===  "boolean") && (typeof dashboardDpList[i].locValue === "string")) {
														sTemp = "<div style=\"display:flex\">";
														sTemp += "<div id=\"sliderSwitch_" +  displayElement.displayId  + "\">";
														sTemp += "<label class=\"sliderSwitch\" ><input type=\"checkbox\"";
														sTemp += " id=\"localValueSwitch_" + displayElement.displayId + "\" onclick=\"sliderSwitchClicked(this, '" + displayElement.displayId + "', " + i + "," + displayElementIndex + ")\" class=\"sliderInput\" ";
														if(dashboardDpList[z].value === null) {

														}
														else if(locValue !== "false") {
															sTemp += ' checked';
														}
														sTemp += '><span id="localValueSpan_' + displayElement.displayId + '" class="sliderSlider sliderRound"';
														if(dashboardDpList[i].backgroundColor !== "false"){
															if(locValue) 
																sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
															
														}
														sTemp += '></span></label></div>';
														addElementToEditButtonElementList2(true, "localValueSwitch_" + displayElement.displayId, "s2", "disable", "localValueSpan_" + displayElement.displayId, z, displayElementIndex, displayElement.displayId);
														if(g_bPlanningShowContextDpMenuButton) {
															sTemp += "<button id=\"menu_" + displayElement.displayId + "\" class=\"planningContextDpMenuButton\" onclick=\"menuDpValue1(14,this, " + z + "," + displayElementIndex +  ",'localValueSwitch_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">...</button>";
															addElementToEditButtonElementList("menu_" + displayElement.displayId, "menu", "disable");
														}
														stemp += "</div>";
													}
													else if(typeof locValue === "boolean") {
														sTemp = "<div style=\"display:flex\">";
														sTemp += "<div id=\"sliderSwitch_" +  displayElement.displayId  + "\">";
														sTemp += "<label class=\"sliderSwitch\" ><input type=\"checkbox\"";
														sTemp += " id=\"localValueSwitch_" + displayElement.displayId + "\" onclick=\"sliderSwitchClicked(this, '" + displayElement.displayId + "', " + i + "," + displayElementIndex + ")\" class=\"sliderInput\" ";
														if(dashboardDpList[z].value === null) {

														}
														else if(locValue) {
															sTemp += ' checked';
														}
														sTemp += '><span id="localValueSpan_' + displayElement.displayId + '" class="sliderSlider sliderRound"';
														if(dashboardDpList[z].value === null) {

														}
														else if(displayElement.backgroundColor !== ""){
															if(locValue) 
																sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
															
														}
														sTemp += '></span></label></div>';
														addElementToEditButtonElementList2(true, "localValueSwitch_" + displayElement.displayId, "s2", "disable", "localValueSpan_" + displayElement.displayId, z, displayElementIndex, displayElement.displayId);
														if(g_bPlanningShowContextDpMenuButton) {
															sTemp += "<button id=\"menu_" + displayElement.displayId + "\" class=\"planningContextDpMenuButton\" onclick=\"menuDpValue1(14,this, " + z + "," + displayElementIndex +  ",'localValueSwitch_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">...</button>";
															addElementToEditButtonElementList("menu_" + displayElement.displayId, "menu", "disable");
														}
														stemp += "</div>";
													}
													else  {
														sTemp = "<div style=\"display:flex\">";
														sTemp += "<div id=\"sliderSwitch_" +  displayElement.displayId  + "\">";
														sTemp += "<label class=\"sliderSwitch\" ><input type=\"checkbox\"";
														sTemp += " id=\"localValueSwitch_" + displayElement.displayId + "\" onclick=\"sliderSwitchClicked(this, '" + displayElement.displayId + "', " + i + "," + displayElementIndex + ")\" class=\"sliderInput\" ";
														if(dashboardDpList[z].value === null) {

														}
														else if(locValue !== 0) {
															sTemp += ' checked';
														}
														sTemp += '><span id="localValueSpan_' + displayElement.displayId + '" class="sliderSlider sliderRound"';
														if(dashboardDpList[z].value === null) {

														}
														else if(displayElement.backgroundColor !== "") {
															if(locValue !== 0) 
																sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
															
														}
														sTemp += '></span></label></div>';
														addElementToEditButtonElementList2(true, "localValueSwitch_" + displayElement.displayId, "s2", "disable", "localValueSpan_" + displayElement.displayId, z, displayElementIndex, displayElement.displayId);
														if(g_bPlanningShowContextDpMenuButton) {
															sTemp += "<button id=\"menu_" + displayElement.displayId + "\" class=\"planningContextDpMenuButton\" onclick=\"menuDpValue1(14,this, " + z + "," + displayElementIndex +  ",'localValueSwitch_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">...</button>";
															addElementToEditButtonElementList("menu_" + displayElement.displayId, "menu", "disable");
														}
														sTemp += "</div>";
													}
													
													element.innerHTML = sTemp;
													dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "s2";
													dashboardDpList[z].displayElements[displayElementIndex].defaultDashboardType = "s2";
													dashboardDpList[z].displayElements[displayElementIndex].readonly = false;
												}
											}
											else if((dashboardDpList[z].type === "SNVT_switch") && (displayElement.field === "")) {
												if(g_displayTypeList[j].displayType === "l3")	{ // "l4"
													sTemp = "<div style=\"display:flex\">";
													sTemp += "<div>"; //sTemp += "<div style=\"width:70px\">"
													sTemp += '<span id="localValueSwitch_' + displayElement.displayId + '"'; 
													if(dashboardDpList[z].value === null) {

													}
													else if(locValue.state === 1) {
														sTemp += ' class="ledDotOn"';
														if(displayElement.backgroundColor !== ""){
															sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
														}
													}
													else 
														sTemp += ' class="ledDotOff"';
													sTemp += " onclick=\"getPlanningTreeShowDashboard(0,'Device_" + dashboardDpList[z].deviceId + "','" + dashboardDpList[z].deviceName + "')\"";
													sTemp += '></span></div>';
													sTemp += '<div id="localValue_' + displayElement.displayId + '" style="margin-left:10px;width:30px;">' + locValue.value.toString() + '</div>'; 
																					
													sTemp += '</div>';
													element.innerHTML = sTemp;
													dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "l3";
												}
												else if(g_displayTypeList[j].displayType === "s3")	{ // "l4"
													sTemp = "<div style=\"display:flex\">";
													sTemp += "<div id=\"sliderSwitch_" +  displayElement.displayId  + "\">"; //sTemp += "<div style=\"width:70px\">"
													sTemp += "<label class=\"sliderSwitch\" ><input type=\"checkbox\"";
													sTemp += " id=\"localValueSwitch_" + displayElement.displayId + "\" onclick=\"sliderSwitchClicked(this, '" + displayElement.displayId + "', " + i + "," + displayElementIndex + ")\" class=\"sliderInput\" ";
													if(dashboardDpList[z].value === null) {

													}
													else if(locValue.state === 1) {
														sTemp += ' checked';
													}
													sTemp += '><span id="localValueSpan_' + displayElement.displayId + '" class="sliderSlider sliderRound"';
													if(displayElement.backgroundColor !== ""){
														if(locValue.state === 1) 
															sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
														
													}
													sTemp += '></span></label></div>';
													sTemp += '<input id="localValue_' + displayElement.displayId + '" style="margin-left:10px;width:30px;"';
													if(dashboardDpList[z].value !== null) 
														sTemp += 'value="' + locValue.value.toString() + '"';
													sTemp += "	onkeyup=\"inputBoxKey(this, event, " + z + "," +  displayElementIndex + ",'" + displayElement.displayId + "')\"";
													sTemp += '>'; 
													addElementToEditButtonElementList2(true, "localValueSwitch_" + displayElement.displayId, "s3", "disable", "localValueSpan_" + displayElement.displayId, z, displayElementIndex, displayElement.displayId);
													addElementToEditButtonElementList("localValue_" + displayElement.displayId, "i", "disable");
													if(g_bPlanningShowContextDpMenuButton) {
														sTemp += "<button id=\"menu_" + displayElement.displayId + "\" class=\"planningContextDpMenuButton\" onclick=\"menuDpValue1(14,this, " + z + "," + displayElementIndex +  ",'localValue_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">...</button>";
														addElementToEditButtonElementList("menu_" + displayElement.displayId, "menu", "visible");
													}
													sTemp += '</div>';
													element.innerHTML = sTemp;
													dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "s3";
													dashboardDpList[z].displayElements[displayElementIndex].defaultDashboardType = "s3";
													dashboardDpList[z].displayElements[displayElementIndex].readonly = false;
												}
												else if(g_displayTypeList[j].displayType === "l4")	{ 
													sTemp = '<span id="localValueSwitch_' + displayElement.displayId + '"'; 
													if(dashboardDpList[z].value === null) {

													}
													else if(locValue.state === 1) {
														sTemp += ' class="ledDotOn"';
														if(displayElement.backgroundColor !== ""){
															sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
														}
													}
													else 
														sTemp += ' class="ledDotOff"';
													sTemp += " onclick=\"getPlanningTreeShowDashboard(0,'Device_" + dashboardDpList[z].deviceId + "','" + dashboardDpList[z].deviceName + "')\"";
													sTemp += '>';
													element.innerHTML = sTemp;
													dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "l4";
												}
												else if(g_displayTypeList[j].displayType === "s4")	{ 
													sTemp = "<div style=\"display:flex\">";
													sTemp += "<div id=\"sliderSwitch_" +  displayElement.displayId  + "\">";
													sTemp += "<label class=\"sliderSwitch\" ><input type=\"checkbox\"";
													sTemp += " id=\"localValueSwitch_" + displayElement.displayId + "\" onclick=\"sliderSwitchClicked(this, '" + displayElement.displayId + "', " + i + "," + displayElementIndex + ")\" class=\"sliderInput\" ";
													if(dashboardDpList[z].value === null) {

													}
													else if(locValue.state === 1) {
														sTemp += ' checked';
													}
													sTemp += '><span id="localValueSpan_' + displayElement.displayId + '" class="sliderSlider sliderRound"';
													if(dashboardDpList[z].value === null) {

													}
													else if(displayElement.backgroundColor !== ""){
														if(locValue.state === 1) 
															sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
														
													}
													sTemp += '></span></label></div>';
													addElementToEditButtonElementList2(true, "localValueSwitch_" + displayElement.displayId, "s4", "disable", "localValueSpan_" + displayElement.displayId, z, displayElementIndex, displayElement.displayId);
													addElementToEditButtonElementList("localValue_" + displayElement.displayId, "s4", "disable");
													if(g_bPlanningShowContextDpMenuButton) {
														sTemp += "<button id=\"menu_" + displayElement.displayId + "\" class=\"planningContextDpMenuButton\" onclick=\"menuDpValue1(14,this, " + z + "," + displayElementIndex +  ",'localValueSwitch_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">...</button>";
														addElementToEditButtonElementList("menu_" + displayElement.displayId, "menu", "visible");
													}
													sTemp += "</div>";
													element.innerHTML = sTemp;
													dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "s4";
													dashboardDpList[z].displayElements[displayElementIndex].defaultDashboardType = "s4";
													dashboardDpList[z].displayElements[displayElementIndex].readonly = false;
													if(g_iShowContextDpLabels !== 0)
														element.classList.add("planningContextDpDiv");//	element.style.padding = "2px 2px";
												}
											}
											else {
												element.innerHTML = "<span id=\"localValue_" + displayElement.displayId + "\" >" + locValueStr + "</span>";
											}

									}
									else {
										if((dashboardDpList[z].cat === "in") && !dashboardDpList[z].displayElements[displayElementIndex].readonly) {
											//class not working element.innerHTML = "<span id=\"localValue_" + displayElement.displayId + "\" class=\"contextDpSpanInput\" onclick=\"menuDpShow(1)\">" + locValueStr + "</span>";
											if(dashboardDpList[z].displayElements[displayElementIndex].bStructure) {
												
												sTemp =  "<div style=\"display:flex\"><span id=\"localValue_" + displayElement.displayId + "\" style=\"display:inline-block;width:150px;border: 1px solid black;;overflow:hidden;white-space:nowrap;text-overflow:ellipsis\"";
												sTemp += " onclick=\"menuDpValue1(14, this, " + z + ", " + displayElementIndex + ", 'localValue_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">";
												sTemp += locValueStr + "</span>";
												dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "s1";
												dashboardDpList[z].displayElements[displayElementIndex].readonly = false;
												addElementToEditButtonElementList("localValue_" + displayElement.displayId, "s1", "disable");
												if(g_bPlanningShowContextDpMenuButton) {
													sTemp += "<button id=\"menu_" + displayElement.displayId + "\" class=\"planningContextDpMenuButton\" onclick=\"menuDpValue1(14, this, " + z + ", " + displayElementIndex + ", 'localValue_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">...</button>";
													addElementToEditButtonElementList("menu_" + displayElement.displayId, "menu", "visible");
												}
												sTemp += "</div>";
											}
											else {
												sTemp = "<span id=\"localValue_" + displayElement.displayId + "\">" + locValueStr + "</span>";
												if(g_bPlanningShowContextDpMenuButton)
														sTemp += "<button class=\"planningContextDpMenuButton\" onclick=\"menuDpValue1(13,this, " + z + "," + displayElementIndex +  ",'localValue_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">...</button>";
												dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "n";
											}
											element.innerHTML = sTemp;
										}
										else {
											dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "r";
											//class not working sTemp = "<span id=\"localValue_" + displayElement.displayId + "\" class=\"contextDpSpan\"";
											if(typeof locValue === "object") {
												sTemp = "<span id=\"localValue_" + displayElement.displayId + "\" style=\"display:inline-block;width:150px;overflow:hidden;white-space:nowrap;text-overflow:ellipsis\"";
												sTemp += " onclick=\"menuDpPlanningShowStructuredDp(10,this," + z + "," + displayElementIndex + ",'" + programmaticPathname + "')\">";
												sTemp += locValueStr + "</span>";
												dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "s0";
											}
											else {
												sTemp = "<span id=\"localValue_" + displayElement.displayId + "\"";
												sTemp += " onclick=\"getPlanningTreeShowDashboard(0,'Device_" + dashboardDpList[z].deviceId + "','" + dashboardDpList[z].deviceName + "')\"";
												sTemp += ">" + locValueStr + "</span>";
											}
											element.innerHTML = sTemp;
										}
									}
									
								} // if(element !== null)
							} // if(bContinue)
							// remove as we now support fields break;
						}
					}
					catch {}
					
				}
				/*
				if(dashboardDpList[i].dashboardType === "n") {
					element = document.getElementById("localValue_" + dashboardDpList[i].programmaticPathname);
					if(element !== null) {
						element.innerHTML = locValueStr;
					}
				}
				*/
			} // z=== -1
			
		} //for(i=0; i < dashboardDpList.length; i++)
		dashboardEditButtonProcess();
		createRequestString(dashboardDpList);
		if(bivUseWebSockets) {
			if(g_bAutoSubscribe) {
				if(g_sWebSocketSubscribePayload !== g_sWebSocketSubscribePayload_oldvalue)
					subscribeRequest();
			}
		}
		g_bDashboardDataLogGetInProgress = false;
		dashboardProcessWebSocketDpData(currentTime, d.getTime(),  dashboardDpList);
		for(i=0; i < dashboardDpList.length; i++)
			dashboardDpList[i].updateDpValue = true; // needed as current dp value may be old as Web Socket updates between initial and end of building UI are not ignored
		g_bPollingEnabled = true;
		g_iPollingRequestCount = g_iPollingRequestCountMax;
		ivbWsProcessDatapointUpdate = true; 
		try {
			// ivGetDeviceList(); // IOT get device list later
			if(g_timerId === 0)
				g_timerId = window.setInterval("timerHandler()", g_iTimerInterval);
		} catch (err) {} 
	}
	catch {}
}
function goBackToContext(contextId) {
	
	g_iPlanningPaneSelectedContextId = -1;
	getPlanningTreeShowTreeDetails(0, contextId);
}
function planningContextZoomButtonClicked(zoomIncrement) {
	try {
		if((g_oPlanningContextZoom.floorplanObjs !== null) && (g_oPlanningContextZoom.url !== "") && (g_oPlanningContextZoom.json1.length !== 0))
			getPlanningTreeShowTreeFloorplanShowPolygons1(zoomIncrement);
			
	}
	catch {}
}
function planningCreateContextbreadcrumbs(path) {
	var sResult = path;
	var id;
	var newPath = "", pathItems;
	var result1;
	try {
		var pathItems = path.split("/");
		var i;
		sResult = "";
		for(i=0; i <pathItems.length; i++)
		{
			if(newPath !== "")
				newPath += "/";
			newPath += pathItems[i];
			id = treeviewfindContextIdFromPath(newPath,planningList)
			if(sResult !== "")
				sResult += "/";
			if(id !== null) {
				sResult += "<span onclick=\"getPlanningTreeShowTreeDetails(0, " + id + ")\">";
			} 
			sResult += pathItems[i];
			if(id !== null) {
				sResult += "</span>";
			} 
		}
	}
	catch {sResult = path;}
	return sResult;
}
function planningExpandDevicesNodeInTree() {
	var i, n;
	try {
		for(i=0; i < g_treeviewInitialCollapseList.length; i++)
		{
			if(g_treeviewInitialCollapseList[i].indexOf("treeDevicesButton") !== -1) {
				if(g_bPlanningShowDevice) {
					n = document.getElementById(g_treeviewInitialCollapseList[i]);
					if(n !== null) {
						if(!n.parentNode.parentElement.querySelector(".treeviewNested").classList.contains("treeviewActive")) {
							n.parentNode.parentElement.querySelector(".treeviewNested").classList.toggle("treeviewActive");
							//n.parentElement.parentElement.classList.toggle("treeviewLiActive");
							if(n.parentElement !== null ) {
								if(n.parentElement.parentElement !== null) {  
									if(n.parentElement.parentElement.nextSibling !== null) {
										n.parentElement.parentElement.classList.toggle("treeviewLiNotActive");
									}
									else { // last Li 
										n.parentElement.parentElement.classList.toggle("treeviewLiNotActiveLastChild");
									}
								}
							}
							n.classList.toggle("treeviewCaret-down");
						}
					}
				}
				else {
					n = document.getElementById(g_treeviewInitialCollapseList[i]);
					if(n !== null) {
						if(n.parentNode.parentElement.querySelector(".treeviewNested").classList.contains("treeviewActive")) {
							n.parentNode.parentElement.querySelector(".treeviewNested").classList.toggle("treeviewActive");
							//n.parentElement.parentElement.classList.toggle("treeviewLiActive");
							if(n.parentElement !== null ) {
								if(n.parentElement.parentElement !== null) {  
									if(n.parentElement.parentElement.nextSibling !== null) {
										n.parentElement.parentElement.classList.toggle("treeviewLiNotActive");
									}
									else { // last Li 
										n.parentElement.parentElement.classList.toggle("treeviewLiNotActiveLastChild");
									}
								}
							}
							n.classList.toggle("treeviewCaret-down");
						}
					}
				}
			}
		}

	}
	catch(err) {}
	if(g_bPlanningShowDevice) {
		g_bPlanningShowDevice = false;
		document.getElementById("planningTreeShowDevicesButton").innerHTML = "Hide All Devices"
	}
	else {
		g_bPlanningShowDevice = true;
		document.getElementById("planningTreeShowDevicesButton").innerHTML = "Show All Devices"
	}

}
function planningFavoritesCheckbox() {
	//remove not supported
	try {
		var checked,i;
		if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
			checked = document.getElementById("favoritesCheckbox").checked;
			for(i=0; i < planningDpList.length; i ++)
			{
				document.getElementById("fav_" + planningDpList[i].pathname).checked = checked;
				addToFavorites1(1, planningDpList[i].pathname);
			}
		}
	}
	catch {}
}
function planningFavoritesReassign() {
	//remove not supported
	try { 
		var i, j;
		if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
			if((planningDpList.length > 0) && (g_sPlanningTreeDatapointPath !== "")) {
				checked = document.getElementById("favoritesCheckbox").checked;
				for(i=0; i < planningDpList.length; i ++)
				{
					for(j=0; j < favDpList.length; j++ )
					{
						if(planningDpList[i].pathname === favDpList[j]. pathname) {
							document.getElementById("fav_" + planningDpList[i].pathname).checked = true;
							break;
						}
					}
					
					
				}
			}
		}
	}
	catch {}
}
function planningPollCheckBox() {
	var pollRate = document.getElementById("planningPollrate");
	var min;
	if(g_idpGetRequestIndex === -1)
		return;
	if(g_dpGetRequestArr[0] === "") 
		return;
	if(pollRate === null)
		return;
	
	pollRate = pollRate.value;

	if(pollRate === "") {
		showAlertDialog(0,"Error: Invalid poll rate value please enter a number (2 or greater)\r\n\r\n" + pollRate);
		return;
	}
	if(isNaN(pollRate)) {
		showAlertDialog(0,"Error: Invalid poll rate value please enter a number (2 or greater)\r\n\r\n" + pollRate);
		return;
	}
	g_iPlanningPollInterval = document.getElementById("planningPollrate").value;
	
	
	if(planningDpList.length > 0) { 
		if(document.getElementById("planningPollCheckbox").checked) {
			g_bPlanningDpPollingEnabled = true;
			pollRate  = Number(pollRate );
			if(isNaN(pollRate ))
				return;
			g_iPollRate = pollRate;
			g_iPollingRequestCountMax = pollRate;
			min = Math.ceil(planningDpList.length / g_iMaxOfDpsToPollPerInterval);
			if(pollRate < (min * g_iBackgroundPollingRequestCountMax)) 
				g_iPollingRequestCountMax = min + 1;
			g_PollingType = g_iMainDisplayMode;
			//if(g_sWebSocketSubscribePayload !== g_sWebSocketSubscribePayload_oldvalue)
			//	subscribeRequest();
			g_iBackgroundPollingRequestCount = 0; // wait as most time you are just moving back and forth to different DPs in the tree
			g_idpGetRequestIndex = 0;
			g_bPollingEnabled = true;
			
			ivbWsProcessDatapointUpdate = true;
			try {
				// ivGetDeviceList(); // IOT get device list later
				if(g_timerId === 0)
					g_timerId = window.setInterval("timerHandler()", g_iTimerInterval);
			} catch (err) {} 
		}
		else {
			g_bPlanningDpPollingEnabled = false;
			g_bPollingEnabled = false;
			ivbWsProcessDatapointUpdate = false;
			g_PollingType = 0;
		}
	}
}
function planningshowDashboard() {
	dashboardDpList = JSON.parse(JSON.stringify(planningDpList));
	//showDashboard(0, "", -1);
	g_bBuildDashboardDps = true;
	showDashboard(4, "", -1);
}
function planningshowDpInShowDatapoints(mode,pathname, programmaticPathname) {
	var pathItems;
	var url = "";
	try {
		pathItems = pathname.split("/");
		clearDpFilter(2,0,0);
		g_oDpFilter.device = pathItems[0];
		if(pathItems.length > 3){
			g_oDpFilter.blockName = pathItems[1];
			g_oDpFilter.blockIndex = pathItems[2];
			g_oDpFilter.datapointName = pathItems[3];
		}
		
		showAllDps(6);
		g_iMainDisplayMode = DISPLAYMODE_DPS;
		document.getElementById("displayLabel").innerHTML = "Device Datapoints: " + pathname;
		dpList = [];
		ivbWsProcessDatapointUpdate = true;
		pathItems = programmaticPathname.split("/");
		url = "/iap/devs/*+name==" + pathItems[0] + "/if/" + pathItems[1] + "/" + pathItems[2] + "/" + pathItems[3] + "/*";
		url = encodePathString(url);
		getOnDemandDpValues(0, url);
	}
	catch (err) {}
}
function planningSmartServerStorageCallback(mode, url, json) {
	try {
		var content = "", content1 = "";
		var element,key, keys, i;
		var units, multiplier;

		//if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING)
		//	return;
		element = document.getElementById("storageInfo");
		if(element !== null) {
			if(g_smartServerImage !== null) {
				content += "<div style=\"float:left;display:inline-block;margin-left:50 px;margin-top:10px;margin-right:10px\"><img src=\"" +  g_smartServerImage + "\" alt=\"device image\"";
				if(g_smartServerImageWidth !== null)
					content += " width=\"" + g_smartServerImageWidth + "px\"";
				if(g_smartServerImageHeight !== null)
					content += " height=\"" + g_smartServerImageHeight + "px\"";
				content += "></div>";
			}
			else 
				content += "<br>";
			try {
				content += "<div style=\"clear:left\">";
				if(g_iSmartServerVersion >= 410000) {
					if(json.hasOwnProperty("cpuUtilization")) {
						keys =  Object.keys(json.cpuUtilization);
						for(i=0; i < keys.length; i++)
						{
							key = keys[i];
							if((key != "") && ((mode === "") || ((mode !== "") && (key === mode)))) {
							
								if(mode === "") {
									if(content1 !== "")
										content1 += "<br><hr>";
									content1 += "<br><br>" + key + ":";
								} 
								content1 += "<br><br><table><thead><tr><th>Parameter</th><th>Value</th></tr></thead><tbody><tr><td>CPU Utilization</td><td>" +  json.cpuUtilization[key] + "%</td></tr>";
								//content1 += "<br><br>CPU: <br><span class=\"storageSpan\">CPU Utilization = " +  json.cpuUtilization[key];
								if(json.hasOwnProperty("dataLogSize")) {
									//if(content !== "")
									//	content += "<br><br>";
									//content += "<span>Data Log Size = " + json.dataLogSize;
									content1 += "<tr><td>Data Log Size</td><td>" +  json.dataLogSize + "</td></tr>";
								}
								if(json.hasOwnProperty("eventLogSize")) {
									//if(content !== "")
									//	content += "<br><br>";
									//content += "<span>Event Log Size = " + json.eventLogSize;
									content1 += "<tr><td>Event Log Size</td><td>" +  json.eventLogSize + "</td></tr>";
								}
								content1 += "</tbody></table><br><br><table><thead><tr><th>Type</th><th>Total</th><th>Used</th><th>Free</th></thead><tbody>"
								if(json.hasOwnProperty("storageInfo")) {
									if(json.storageInfo.hasOwnProperty(key)) {
										if(json.storageInfo[key].hasOwnProperty("internal")) {
											if(json.storageInfo[key].internal.hasOwnProperty("avail") && json.storageInfo[key].internal.hasOwnProperty("total") && json.storageInfo[key].internal.hasOwnProperty("used")) {
												//if(content1 !== "")
												//	content1 += "<br><br>";
												//content1 += "Internal Flash Drive:<br><span class=\"storageSpan\">Total = " + json.storageInfo[key].internal.total;
												//content1 += " bytes</span><br><span class=\"storageSpan\">Used = " + json.storageInfo[key].internal.used;
												//content1 += " bytes</span><br><span class=\"storageSpan\">Available = " + json.storageInfo[key].internal.avail + " bytes</span>";
												
												if(json.storageInfo[key].internal.total < 1000000000) {
													multiplier = 1024 * 1024; //1000000;
													units = " MB";
												}
												else {
													multiplier = 1024 * 1024 * 1024; //1000000000;
													units = " GB";
												}
												content1 += "<tr><td>Internal Flash Drive</td><td>" +  (json.storageInfo[key].internal.total / multiplier).toFixed(1) + units + "</td>";
												content1 += "<td>" + Math.ceil((100 * json.storageInfo[key].internal.used / json.storageInfo[key].internal.total)) + "% (" +  (json.storageInfo[key].internal.used / multiplier).toFixed(1) + units + ")</td>";
												content1 += "<td>" + Math.ceil((100 * json.storageInfo[key].internal.avail / json.storageInfo[key].internal.total)) + "% (" +  (json.storageInfo[key].internal.avail / multiplier).toFixed(1) + units + ")</td></tr>";

											}
											else {
												//content1 += "internal Flash: Can't Read value";
											}
											
										}
										if(json.storageInfo[key].hasOwnProperty("external")) {
											if(json.storageInfo[key].external.hasOwnProperty("avail") && json.storageInfo[key].external.hasOwnProperty("total") && json.storageInfo[key].external.hasOwnProperty("used")) {
												//if(content1 !== "")
												//	content1 += "<br><br>";
												//content1 += "SD-Card:<br><span class=\"storageSpan\">Total = " + json.storageInfo[key].external.total;
												//content1 += " bytes</span><br><span class=\"storageSpan\">Used = " + json.storageInfo[key].external.used;
												//content1 += " bytes</span><br><span class=\"storageSpan\">Available = " + json.storageInfo[key].external.avail + " bytes</span>";
												multiplier = 1024 * 1024 * 1024; //1000000000;
												units = " GB";
												content1 += "<tr><td>SD-Card</td><td>" +  (json.storageInfo[key].external.total / multiplier).toFixed(1) + units + "</td>";
												content1 += "<td>" + Math.ceil((100 * json.storageInfo[key].external.used / json.storageInfo[key].external.total))  + "% (" +  (json.storageInfo[key].external.used / multiplier).toFixed(1) + units  + ")</td>";
												content1 += "<td>" + Math.ceil((100 * json.storageInfo[key].external.avail / json.storageInfo[key].external.total)) + "% (" +  (json.storageInfo[key].external.avail / multiplier).toFixed(1) + units + ")</td></tr>";
											}
											else {
												//if(content1 !== "")
												//	content1 += "<br><br>";
												//content1 += "SD-Card: Can't Read value";
											}
										}
										if(json.storageInfo[key].hasOwnProperty("memory")) {
											if(json.storageInfo[key].memory.hasOwnProperty("avail") && json.storageInfo[key].memory.hasOwnProperty("total") && json.storageInfo[key].memory.hasOwnProperty("used")) {
												//if(content1 !== "")
												//	content1 += "<br><br>";
												//content1 += "Memory:<br><span class=\"storageSpan\">Total = " + json.storageInfo[key].memory.total;
												//content1 += " bytes</span><br><span class=\"storageSpan\">Used = " + json.storageInfo[key].memory.used;
												//content1 += " bytes</span><br><span class=\"storageSpan\">Available = " + json.storageInfo[key].memory.avail + " bytes</span>";
												multiplier = 1024 * 1024 * 1024; //1000000000;
												units = " GB";
												content1 += "<tr><td>RAM</td><td>" +  (json.storageInfo[key].memory.total / multiplier).toFixed(1) + units + "</td>";
												content1 += "<td>" +  Math.ceil((100 * json.storageInfo[key].memory.used / json.storageInfo[key].memory.total)) + "% (" +  (json.storageInfo[key].memory.used / multiplier).toFixed(1) + units  + ")</td>";
												content1 += "<td>" + Math.ceil((100 * json.storageInfo[key].memory.avail / json.storageInfo[key].memory.total)) + "% (" +  (json.storageInfo[key].memory.avail / multiplier).toFixed(1) + units + ")</td></tr>";
											}
											else {
												//if(content1 !== "")
												//	content1 += "<br><br>";
												//content1 += "Memory: Can't Read value";
											}
										}
									}
									content1 += "</tbody></table>";
									content += content1;
								}
								
							}
						}
					}
					else 
						content = "StorageInfo: Can't Read values";

				}
				content += "</div>"
			}
			catch { content += "<br><br><i>Error reading Storage Information</i></div>" }
			
			element.innerHTML = content;
		}
	}
	catch {}
}
function planningSmartServerStorageFailCallback(mode, url, json) {
	try {
		var content = "";
		var element;

		//if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING)
		//	return;
		element = document.getElementById("storageInfo");
		if(element !== null) {
			if(g_smartServerImage !== null) {
				content += "<div style=\"float:left;display:inline-block;margin-left:50 px;margin-top:10px;margin-right:10px\"><img src=\"" +  g_smartServerImage + "\" alt=\"device image\"";
				if(g_smartServerImageWidth !== null)
					content += " width=\"" + g_smartServerImageWidth + "px\"";
				if(g_smartServerImageHeight !== null)
					content += " height=\"" + g_smartServerImageHeight + "px\"";
				content += "></div>";
			}
			else 
				content += "<br>";
			element.innerHTML = content;
		}


	}
	catch {}

}
function planningTreeHide() {
	try {
		var element1;
		var element = document.getElementById("planningTreeShowTreeExpandButton");
		var value,i;
		var width;
		var height;
		var error;
		if(element !== null) {
			value = element.getAttribute("data-navtree-expand");
			if(typeof value !== "undefined") {
				if(value !== null) {
					if(value === "expanded") {
						element.setAttribute("data-navtree-expand","colapse");
						element = document.getElementById("planningTreeShowDevicesButton");
						if(element !== null)
							element.style.display = "none";
						element = document.getElementById("treeDivTreeResize");
						if(element !== null)
							element.style.display = "none";
						element = document.getElementById("treeLegend");
						if(element !== null)
							element.style.display = "none";
						element = document.getElementById("showLegendMenuDiv");
						if(element !== null)
							element.style.display = "none";
					}
					else {
						element.setAttribute("data-navtree-expand","expanded");
						element = document.getElementById("planningTreeShowDevicesButton");
						if(element !== null)
							element.style.display = "inline-block";
						element = document.getElementById("showLegendMenuDiv");
						if(element !== null)
							element.style.display = "inline-block";
						element = document.getElementById("treeDivTreeResize");
						if(element !== null)
							element.style.display = "block";
						element = document.getElementById("treeLegend");
						if(element !== null)
							element.style.display = "block";
					}
					if(g_iMainDisplayMode === DISPLAYMODE_MAP) {
						// rebuild map with larger size
						mapResize();
					}
				}
			}
		}
	}
	catch (err) 
	{
		error = err.toString();
	}
}
function showLegend() {
	try {
		var element = document.getElementById("showLegendId");
		var element1 = document.getElementById("showLegendDiv");
		if((element !== null) && (element1 !== null)) {
			if(element.checked)
				element1.className = "showLegendShow";
			else 
				element1.className = "showLegendHide";
		}
	}
	catch {}
}
function  showPlanningTree() {
	
	showPlanningTreePane(0)
}
function showPlanningTreeCalendar(mode) {
	var id = "_TreeSchedules";
	try {
		g_iMainDisplayMode = DISPLAYMODE_SCHEDULE;
		menuCloseAll();
		document.getElementById("planningPaneDetails").innerHTML = "Getting Schedule data...<div id=\"gettingInfoId\" class=\"gettingInfo\">" + addWaitSpinner() + "</div>";
		g_bPlanningDpPollingEnabled = false;
		g_bPollingEnabled = false;
		if(g_datalogWsClient !== null)	{
			g_datalogWsClient.close();
		}
		ivbWsProcessDatapointUpdate = false;
		g_bDeviceDataLogGetInProgress = false;
		g_PollingType = 0;
		g_scheduleDiv = 0;
		g_iScheduleView = 3; 
		g_editButtonElementList = [];
		// change color of tree context to indicate selected
		if(g_iPlanningPaneSelectedContextId !== -1) {
			treeContext = document.getElementById("planningTreeContext_" + g_iPlanningPaneSelectedContextId);
			if(treeContext !== null) {
				treeContext.classList.remove("treeSelected")
				//treeContext.style.color = "white";
			}
		}
		treeContext = document.getElementById("planningTreeContext_" + id);
		if(treeContext !== null) {
			//treeContext.style.color = "red";
			treeContext.classList.add("treeSelected")
		}
		g_iPlanningPaneSelectedContextId = id;
		showCalendar(0);
	}
	catch {}
}
function showPlanningTreeDetails(value) {
	g_iPlanningTreeShowDevices = Number(value);
	try {
		document.getElementById("planningDiv").className = "testDivHide";
		document.getElementById("planningOverlayDiv").className = "testDivHide";
	}
	catch {}
	if(g_iPlanningPaneSelectedContextId !== -1)
		getPlanningTreeShowTreeDetails(1, g_iPlanningPaneSelectedContextId);
}
function showPlanningTreePane(mode) {
	// mode: 4, show planning tree, get device list and then get planning data
	var i, element, color="lawngreen";
	var paneTitle = "<label>Planning</label><button id=\"planningTreeShowDevicesButton\" class=\"planningTreeShowDevicesButton\" onclick=\"planningExpandDevicesNodeInTree()\">";
	var displayObj = null;
	return; // this is function is not used in navtree so this function can be removed
	if(g_bPlanningShowDevice)
		paneTitle += "Show All Devices"
	else 
		paneTitle += "Hide All Devices"
	paneTitle += "</button>";
	savePrevousHtmlContent();
	if(mode === 4)
		initializeDisplay(4);
	else
		initializeDisplay();
	g_iMainDisplayMode = DISPLAYMODE_PLANNING;
	//paneTitle += "<button onclick=\"showPlanningRefresh(0)\" style=\"float:right\">Refresh All</button>";
	//paneTitle += "<button id=\"planningRefreshButton\" onclick=\"showPlanningRefresh(1)\" style=\"float:right\">Refresh</button><button onclick=\"showPlanningRefresh(0)\" style=\"float:right\">Refresh All</button>";
	if(false) {
		paneTitle += "<div id=\"planningContextDetailsDiv\" style=\"display:inline-block;float:right;margin-left:300px\">";
		paneTitle += "<input type=\"radio\" id=\"planningTreeRadioButtonDevice\" name=\"planningTreeRadioButton\" onclick=\"showPlanningTreeDetails(this.value)\" value=\"0\"";
		if(g_iPlanningTreeShowDevices === 0)
			paneTitle += " checked";
		paneTitle += "> Floorplan (all Devices) ";
		paneTitle += "<input type=\"radio\" id=\"planningTreeRadioButtonDevice\" name=\"planningTreeRadioButton\" onclick=\"showPlanningTreeDetails(this.value)\" value=\"1\"";
		if(g_iPlanningTreeShowDevices === 1)
			paneTitle += " checked";
		paneTitle += "> Context Devices ";
		paneTitle += "<input type=\"radio\" id=\"planningTreeRadioButtonContextDetails\" name=\"planningTreeRadioButton\" onclick=\"showPlanningTreeDetails(this.value)\" value=\"2\"";
		if(g_iPlanningTreeShowDevices === 2)
			paneTitle += " checked";
		paneTitle += "> Context Details</div>";
	}
	//var paneContent = "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting Planning and device Info ...</span></div>";
	var paneContent = "<div style=\"text-align:center\"><br><div id=\"gettingInfoId\" class=\"gettingInfo\">" + addWaitSpinner() + "</div></div>";
	document.getElementById("main-Header").innerHTML = paneTitle;
	document.getElementById("main").innerHTML = paneContent;
	if(mode === 4)
		return;
	if(g_sPlanningPaneContent !== "") {
		document.getElementById("main").innerHTML = g_sPlanningPaneContent;
		//if((g_sPlanningPaneContent !== "") && (planningDpList.length === 0) && (g_iPlanningPaneSelectedContextId.indexOf("Device_") !== 0)) {
		if(g_sPlanningPaneContent !== "") {
			if(planningDpList.length !== 0) 
				document.getElementById("planningContextDetailsDiv").style.visibility = "hidden";
			else {
				if(typeof g_iPlanningPaneSelectedContextId === "string") {
					if(g_iPlanningPaneSelectedContextId.indexOf("Devices_") === 0) 
						document.getElementById("planningContextDetailsDiv").style.visibility = "hidden";
				}

			}
			//document.getElementById("planningRefreshButton").style.visibility = "hidden";
		}
		planningFavoritesReassign();
		// check if device status changed while looking at other view, ifso update tree
		for(i=0; i < deviceListAll.length; i++)
		{
			if(typeof deviceListAll[i].statusChanged !== "undefined") {
				if(deviceListAll[i].statusChanged) {
					element = document.getElementById("deviceStatus_" + deviceListAll[i].id);
					if(element !== null) {
						if(deviceListAll[i].category !== "SC")
							color = deviceStatusColor (status);
						element.style.backgroundColor = color;
						treeUpdateContextDeviceStatus(-1, deviceListAll[i].id);
					}
				}
			}
		}
		//reenable checkboxes
		element = document.getElementById("planningConfigCheckbox");
		if(element !== null) {
			if(g_bPlanningShowConfiguration)
				element.checked = true;
/*				
			if(g_bPlanningShowConfigurationSingleDp)
				treeShowConfiguration();
			else
				treeShowConfigurationAll();*/
		}
		element = document.getElementById("planningPollrate");
		if(element !== null)
			element.value = g_iPlanningPollInterval;
		element = document.getElementById("planningPollCheckbox");
		if(element !== null) {
			if(g_bPlanningDpPollingEnabled) {
				element.check = true;
				if(planningDpList.length > 0) {
					createRequestString(planningDpList);
					subscribeRequest();
					planningPollCheckBox();
				}
			}
		}
				
		return;
	}
	if(planningList !== null) {
		if(planningList.length > 0) {
			getplanningTreeShowTree(1);
			cursorClearWait();
			if(g_iPlanningPaneSelectedContextId !== -1) {
				// add focus code
				getPlanningTreeShowTreeDetails(0, g_iPlanningPaneSelectedContextId);
			}
			else {
				displayObj = document.getElementById("planningPaneDetails");
				if(displayObj !== null) {
					displayObj.innerHTML = "No Context Selected";
				}
			}
			return;
		}
	}
	getPlanningTree();
	
}
function showPlanningRefresh(mode) {
	try {
		var element = null;
		menuCloseAll();
		planningList = [];
		deviceListAll = [];
		g_deviceAlarmsList = [];
		g_contextImages = [];
		g_iPlanningPaneSelectedContextId = -1;
		g_bPlanningShowDevice = true;
		element = document.getElementById("planningTreeShowDevicesButton");
		if(element !== null) 
			element.innerHTML = "Show All Devices";
	
		element = document.getElementById("planningPaneDetails");
		if(element !== null) {
			element.innerHTML = "<div><div class=\"gettingInfo\">" + addWaitSpinner() + "</div></div>";
		}
		if(g_bUseWebSockets) {
			if(!ivWsSocketConnected) {
				// PC may have hibernated
				try {
					ivWebSocketInit();
				}
				catch {}
			}
		}
		if((g_bShowTimestamp) && (g_iSmartServerVersion >= 410000))
			getSmartServerTime(1);
		if(mode === 0) {
			cursorSetWait();
			if(g_iSmartServerVersion < 420000) {
				g_bPreGetDatapointTypes = true;  // getting datapoint types takes too long for older SmartServer software
				if(g_iSmartServerVersion > 350000) {
					if(g_bShowEps && g_bShowEpsWarningColors) {
						getSmartServerSettings1(0);
					}
					else
						getSmartServerDevicesInfo();
				}
				else
					getSmartServerDevicesInfo();
				return;
			}
			else 
				getDeviceTypes(25);
		}
		else
			showPlanningTree();
	} catch {}
}
function treeviewSitesPaneContent() {
	// searches first to see if sid is defined for this SmartServer, if not check for all SmartServers sid = null
	var sTemp = "", j, k, m, element, bContinue = true, sidItems = [], bNoSidDefined;
	//__sites__
	try {
		element = document.getElementById("planningPaneDetails") 
		if(element !== null) {

			for(k=0; k < 3; k++)
			{
				for(j=0; j < g_contextImages.length; j++)
				{

				
					bContinue = false;
					if(k=== 0) {
						// check if sid defined
						if(g_contextImages[j].sid !== null) {

							if(g_contextImages[j].sid.indexOf(",") !== -1) {
								sidItems = g_contextImages[j].sid.indexOf(",");
							}
							else {
								sidItems.push(g_contextImages[j].sid);
								
							}
							for(m=0; m < sidItems.length; m++)
							{
								if(g_iSmarserverSid === sidItems[m]) {
									bContinue = treeviewSitesPaneContentCheckContext(g_contextImages[j].contextType);
									if(bContinue)
										break;
								}
							}
						}
					}
					else if(k === 1) {
						// sid not defined
						bContinue = treeviewSitesPaneContentCheckContext(g_contextImages[j].contextType);
						
					}
					if(bContinue) {
						//check if context matches 
						sTemp = "";
						if(g_contextImages[j].bLocationAboveImage) {
							if(g_contextImages[j].location !== null) {
								sTemp += g_contextImages[j].location;
							}
						}
						if(g_contextImages[j].image !== null) {
							sTemp += "<div style=\"display:block;margin-left:50 px;margin-right:10px\"><img src=\"" +  g_contextImages[j].image + "\" alt=\"device image\"";
							if(g_contextImages[j].width !== null)
								sTemp += " width=\"" + g_contextImages[j].width + "px\"";
							if(g_contextImages[j].height !== null)
								sTemp += " height=\"" + g_contextImages[j].height + "px\"";
							sTemp += "></div>";
							
						}
						if(!g_contextImages[j].bLocationAboveImage) {
							if(g_contextImages[j].location !== null) {
								sTemp += g_contextImages[j].location;
							}
						}
						
						break;
					}
				}
				if(bContinue) {
					break;
				}
			}
			if(sTemp === "")
				sTemp += "<div class=\"noContentSelected\">No Contexts Selected</div></div>"
			element.innerHTML = sTemp;
			
		}
		
	}
	catch {}
}
function treeviewSitesPaneContentCheckContext(contexts) {
	var bResult = false;
	var i;
	var searchStr = "sites"
	var contextItems = [];
	try { 
		if(contextList.length === 0)
			searchStr = "site";
		if(contexts.indexOf(",") === -1) {
			contextItems.push(contexts);
		}
		else {
			contextItems = contexts.split(",");
		}
		for(i=0; i < contextItems.length; i++)
		{
			if(contextItems[i] === searchStr) {
				bResult = true;
				break;
			}
		}
	}
	catch {}
	return bResult;

}
function treeShowConfiguration() {
	var element = document.getElementById("planningConfigCheckbox");
	var element1 = document.getElementById("treeDpProperty");
	try {
		if(element !== null) {
			g_bPlanningShowConfiguration = element.checked;
			if(element1 !== null) {
				if(g_bPlanningShowConfiguration) {
					element1.style.display = "inline-block";
				}
				else {
					element1.style.display = "none";
				}
				
			}
		}
	}
	catch {}
}
function treeDivTreeMouseDownEvent(n) {
	//if((g_iMainDisplayMode === DISPLAYMODE_PLANNING) && (g_iPlanningPaneSelectedContextType === 0)) {
	if(g_iPlanningPaneSelectedContextType === 0) {
		g_iTreeDivTreeWidth = n.offsetWidth;
		g_iTreeDivTreeHeight = n.offsetHeight;
	}
}
function treeDivTreeMouseUpEvent(n){
	if(g_bMouseTreeRightResizeActive) {
		mouseUpTreeRightResizeHandler(); //treedDiv resize finished
		return;
	}
	if(g_bMouseTreeBottomResizeActive) {
		mouseUpTreeBottomResizeHandler(); //treedDiv resize finished
		return;
	}
	
	//if((g_iMainDisplayMode === DISPLAYMODE_PLANNING) && (g_iPlanningPaneSelectedContextType === 0)) {
	if(g_iPlanningPaneSelectedContextType === 0) {
		if((g_iTreeDivTreeHeight !== 0) && (g_iTreeDivTreeWidth !== 0)) {
			if((g_iTreeDivTreeWidth !== n.offsetWidth) || (g_iTreeDivTreeHeight !== n.offsetHeight)) {
				try {
					if(typeof g_iPlanningPaneSelectedContextId === "number") {
						g_iTreeDivTreeWidth = 0
						g_iTreeDivTreeHeight = 0;
						getPlanningTreeShowTreeDetails(1, g_iPlanningPaneSelectedContextId)
					}
				}
				catch {}
			}
		}
	}

}
function treeDivTreeResizeEvent() {
	
	if(g_iPlanningTreeDivResizeTimerId !== 0)
		clearTimeout(g_iPlanningTreeDivResizeTimerId);
	//if((g_iMainDisplayMode === DISPLAYMODE_PLANNING) && (g_iPlanningPaneSelectedContextType === 0)) {
	if(g_iPlanningPaneSelectedContextType === 0) {
		g_iPlanningTreeDivResizeTimerId = setTimeout(treeDivTreeResizeTimer, 500);
	}
	
}
function treeDivTreeResizeTimer() {
	//getPlanningTreeShowTreeDetails(); //7777
	try {
		var i;
		var element;
		g_iPlanningTreeDivResizeTimerId = 0;
		//if((g_iMainDisplayMode === DISPLAYMODE_PLANNING) && (g_iPlanningPaneSelectedContextType === 0)) {
		if(g_iPlanningPaneSelectedContextType === 0) {
			if(typeof g_iPlanningPaneSelectedContextId === "number") {
				g_iTreeDivTreeWidth = 0
				g_iTreeDivTreeHeight = 0;
				
	
				getPlanningTreeShowTreeDetails(61, g_iPlanningPaneSelectedContextId)
			}
		}
	}
	catch {}

}
function treeShowConfigurationAll() {
	var i;
	var element = document.getElementById("planningConfigCheckbox");
	var nodes = null;
	try {
		if(element !== null) {
			g_bPlanningShowConfiguration = element.checked;
			nodes = document.getElementsByClassName("tableHideCol");
			for(i=0; i < nodes.length; i++)
			{
				if(g_bPlanningShowConfiguration)
					nodes[i].style.display = "table-cell";
				else 
					nodes[i].style.display = "none";
			}
			
		}
	}
	catch {}
}
function treeviewShowDatapoints(n) {
	//fixxxx
}
function treeviewToggle(n) {
	try {
		n.parentNode.parentElement.querySelector(".treeviewNested").classList.toggle("treeviewActive");
		//n.parentElement.parentElement.classList.toggle("treeviewLiActive");
		if(n.parentElement !== null ) {
			if(n.parentElement.parentElement !== null) {  
				if(n.parentElement.parentElement.nextSibling !== null) {
					n.parentElement.parentElement.classList.toggle("treeviewLiNotActive");
				}
				else { // last Li 
					n.parentElement.parentElement.classList.toggle("treeviewLiNotActiveLastChild");
				}
			}
		}
		n.classList.toggle("treeviewCaret-down");
	} catch {}
}
function treeviewToggle1(n, displayId, path) {
	try {
		var url;
		var element = document.getElementById(displayId);
		if(!n.classList.contains("treeviewCaret-down")) {
			// only do if currently node collapsed
			if(element !== null) {
				if(element.innerHTML === "") {
					// need to get child data
					if(path.indexOf("/") === -1) {
						// device
						cursorSetWait();
						path = encodeNameStr(path);
						url = "https://" + location.host + "/iap/devs/*+name==" + path + "/if/*/*/*/*";
						requestGetData(displayId, url, treeViewGetDeviceDatapointsResponse, treeViewGetFailResponse);
						
					}
				}
			}
		}
		n.parentNode.parentElement.querySelector(".treeviewNested").classList.toggle("treeviewActive");
		//n.parentElement.parentElement.classList.toggle("treeviewLiActive");
		if(n.parentElement !== null ) {
			if(n.parentElement.parentElement !== null) {  
				if(n.parentElement.parentElement.nextSibling !== null) {
					n.parentElement.parentElement.classList.toggle("treeviewLiNotActive");
				}
				else { // last Li 
					n.parentElement.parentElement.classList.toggle("treeviewLiNotActiveLastChild");
				}
			}
		}
		n.classList.toggle("treeviewCaret-down");
	} catch {}
}
function treeViewGetDeviceDatapointsResponse(mode, requestUrlString, json){
	var element,obj, i, bContinue, content = "";
	if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING) 
		return;
	if(mode === "")
		return;
	cursorClearWait()
	try {
		if(json.length === 0)
			return;
		var element = document.getElementById(mode);
		if(element !== null) {
			//sort datapoints
			for(i=0; i < json.length; i++) 
			{
				json[i].dpPath = json[i].blockName +  "/" + json[i].blockIndex +  "/" + json[i].datapointName;
				json[i].dpBlockPath = json[i].blockName +  "/" + json[i].blockIndex +  "/";
				json[i].path = json[i].deviceName + "/" + json[i].dpPath;
				json[i].pathname = json[i].deviceName + "/" + json[i].blockName +  "/" + json[i].blockIndex +  "/";
				if(typeof json[i].name === "undefined") {
					json[i].pathname += json[i].datapointName;
					json[i].dpBlockPath += json[i].datapointName;
				}
				else if(json[i].name === null) {
					json[i].pathname += json[i].datapointName;
					json[i].dpBlockPath += json[i].datapointName;
				}
				else { 
					json[i].pathname += json[i].name;
					json[i].dpBlockPath += json[i].name;
				}
			}
			bContinue = true;
			while(bContinue)
			{
				bContinue = false;
				for(i=0; i < (json.length - 1); i++) 
				{
					if(json[i].path > json[i + 1].path) {
						obj = JSON.parse(JSON.stringify(json[i]));
						json[i] = JSON.parse(JSON.stringify(json[i + 1]));
						json[i + 1] = obj;
						bContinue = true;
					}
				}
			}
			for(i=0; i < json.length; i++) 
			{
				if(false) { //i === (json.length - 1)) {
					//content += "<li class=\"treeli treeviewLiActiveLastChild\">" + json[i].dpPath + "</li>";
					content += "<li class=\"treeli\"><p class=\"treeviewNoChildren\">";
					content += "<span id=\"planningTreeContextDp_" + json[i].path + "\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].path + ")\">" + json[i].dpPath;
					content += "</span></p></li>";
				}
				else {
					//content += "<li class=\"treeli treeviewLiActive\">" + json[i].dpPath + "</li>";
					content += "<li class=\"treeli\"><p class=\"treeviewNoChildren\">";
					content += "<span id=\"planningTreeContext_DeviceDp_" + json[i].path + "\"";
					//content += " onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].path + ")\">";
					content += "\" onclick=\"getPlanningTreeShowTreeDatapoints(0, 'DeviceDp_" + json[i].path + "', '" + json[i].path + "')\">";
					content += json[i].dpBlockPath; //json[i].dpPath; //json[i].pathname;
					content += "</span></p></li>";
				}
			}
			element.innerHTML = content;
		} 
	}
	catch (err) {}
}
function treeViewGetFailResponse(mode, requestUrlString, json) {
	cursorClearWait()
}
function treeviewAddDeviceStatusDot(id, name, state, health, category) {
	var str = "lawngreen";
	try {
		if(state === "provisioned") {
			if(health === "normal")
				str = "lawngreen";
			else {
				if(category === "SC")
					str = "lawngreen";
				else 
					str = "red";
			}
		}
		else if(state === "unlicensed") 
			str = "#BA55D3"
		else if(state === "provisioning") 
			str = "cyan";
		else 
			str = "blue";
	}
	catch (err) {}
	if(category === "SC")
		str = '<span id=\"' + id + '\" class="treeviewDeviceSquare" style="background-color:' + str + '"';
	else
		str = '<span id=\"' + id + '\" class="treeviewDeviceDot" style="background-color:' + str + '"';

	//str += " onclick=\"getPlanningTreeShowTreeDatapoints(0, 'Device_" + id + "', '" + name + "')\"></span>";
	str += "></span>";

	return str;
}
function treeviewNodesCollapseNodesInInialCollapseList() {
	var i, n, bExpandAllDevices = true;
	try {
		// only collapse if context is available
		if(planningList.length > 0)
			bExpandAllDevices = false;
		else {
			for(i=0; i < deviceListAll.length; i++)
			{
				if(deviceListAll[i].contexts.length > 0) {
					bExpandAllDevices = true;
					break;
				}
			}
		}

		
		for(i=0; i < g_treeviewInitialCollapseList.length; i++)
		{
			n = document.getElementById(g_treeviewInitialCollapseList[i]);
			if(!bExpandAllDevices || (bExpandAllDevices && (g_treeviewInitialCollapseList[i].indexOf("treeDeviceButton") !== -1))) {
				if(n !== null) {
					n.parentNode.parentElement.querySelector(".treeviewNested").classList.toggle("treeviewActive");
					//n.parentElement.parentElement.classList.toggle("treeviewLiActive");
					if(n.parentElement !== null ) {
						if(n.parentElement.parentElement !== null) {  
							if(n.parentElement.parentElement.nextSibling !== null) {
								n.parentElement.parentElement.classList.toggle("treeviewLiNotActive");
							}
							else { // last Li 
								n.parentElement.parentElement.classList.toggle("treeviewLiNotActiveLastChild");
							}
						}
					}
					//n.classList.toggle("treeviewCaret-down");
					if(g_treeviewInitialCollapseList[i].indexOf("treeDeviceButton") === -1)
						n.classList.remove("treeviewCaret-down");
				}
			}
		}
		
		if(bExpandAllDevices) {
			g_bPlanningShowDevice = false;
			document.getElementById("planningTreeShowDevicesButton").innerHTML = "Hide All Devices"
		}
	}
	catch(err) {}
}
function treeviewfindContextObj(id, objList) {
	var result = null;
	var i;
	try {
		if(objList === null)
			return result;
		for(i=0; i < objList.length; i ++)
		{
			if(objList[i].id === id) {
				result = JSON.parse(JSON.stringify(objList[i]));
				return result;
			}
			else if(objList[i].children.length > 0) {
				result = treeviewfindContextObj(id, objList[i].children)
				if(result !== null)
					return result;
			}
		}
	}
	catch (err) {result = null;}
	return result;

}
function treeviewfindContextPathFromId(id, objList, path) {
	var result = null;
	var i;
	try {
		if(objList === null)
			return result;
		for(i=0; i < objList.length; i ++)
		{
			if(objList[i].id === id) {

				if(path !== "")
					path += "/";
				path += objList[i].name;
				return path;
			}
			else if(objList[i].children.length > 0) {
				if(path !== "")
					path += "/";
				path += objList[i].name;
				result = treeviewfindContextPathFromId(id, objList[i].children, path)
				if(result !== null)
					return result;
			}
		}
	}
	catch (err) {result = null;}
	return result;
}
function treeviewfindContextIdFromPath(contextpath, objList) {
	var result = null;
	var path, paths;
	var i;
	try {
		if(objList === null)
			return result;
		if(contextpath === "")
			return;
		paths = contextpath.split("/");
		if(paths.length > 0) {
			path = paths[0];
			for(i=0; i < objList.length; i ++)
			{
				if(objList[i].name === path) {
					if(paths.length === 1)
						return objList[i].id;
					else {
						if(objList[i].children.length > 0) {
							newPath = "";
							for(j = 1; j < paths.length; j++)
							{
								if(newPath !== "")
									newPath += "/";
								newPath += paths[j];
							}
							if(newPath !== "")
								result = treeviewfindContextIdFromPath(newPath, objList[i].children)
							return result;
						}
						else 
							return result;
					}
					
				}
				
			}
		}
	}
	catch (err) {result = null;}
	return result;
}
function treeUpdateContextDeviceStatus(index, deviceId) {
	var i, j, z = -1, z1 = -1, contextId, contextObj, iTotal, iUp, iDown, iUnProvisioned, iUnLicensed;
	var status, element, sResult = "";
	try {
		//if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING)
		//	return;
		if((deviceListAll.length === 0) || (planningList.length === 0))
			return;
		if(index !== -1) {
			if(index < deviceListAll.length) {
				if(deviceListAll[index].id === deviceId)
					z = index;
			}
		}
		if(z === -1) {
			for(i=0; i < deviceListAll.length; i ++)
			{
				if(deviceListAll[i].id === deviceId) {
					z = i;
					break;
				}
			}
		}
		if(z !== -1) {
			for(i=0; i < deviceListAll[z].contexts.length; i ++)
			{
				contextId = deviceListAll[z].contexts[i];
				contextObj = treeviewfindContextObj(contextId, planningList);
				if(contextObj !== null) {
					element = document.getElementById("planningTreeContextDeviceStatus_" + contextObj.id);
					if(element !== null) {
						sResult = "";
						iTotal = contextObj.devices.length; iUp = 0; iDown = 0; iUnProvisioned = 0; iUnLicensed = 0;
						for(j=0; j < contextObj.devices.length; j ++)
						{
							for(k=0; k < deviceListAll.length; k++)
							{
								if(contextObj.devices[j].id === deviceListAll[k].id) {
									if(deviceListAll[k].status.state === "provisioned") {
										if(deviceListAll[k].status.health === "normal")
											iUp ++;
										else {
											if(deviceListAll[k].category === "SC")
												iUp ++;
											else 
												iDown ++;
										}
									}
									else if(deviceListAll[k].status.state === "unlicensed") 
										iUnLicensed ++;
									else 
										iUnProvisioned ++;
									break;
								}
							}
						}
						if((iDown > 0) && ((iDown + iUnProvisioned) === iTotal))
							sResult += '<span class="dot" style="background-color:red"></span>';
						else if(iDown > 0)
							sResult += '<span class="dot" style="background-color:yellow"></span>';
						if(iUnProvisioned > 0)
							sResult += '<span class="dot" style="background-color:blue"></span>';
						if(iUnLicensed > 0)
							sResult += '<span class="dot" style="background-color:#663399"></span>';
						element.innerHTML = sResult;
					}
					
					
				}
			}
		}

	}
	catch (err) {}

}
function treeviewShowContextDevicesInDetailsPane(contextId){
	
	var url = "";
	
	var treeContext = null;
	g_iMainDisplayMode = DISPLAYMODE_PLANNING;
	g_bPollingEnabled = false;
	ivbWsProcessDatapointUpdate = false;
	menuCloseAll();
	g_dashboardChartList = [];
	g_zoomDashboardChartList = [];
	g_oDashboardLayout = null;
	if(g_iPlanningPaneSelectedContextId !== -1) {
		treeContext = document.getElementById("planningTreeContext_" + g_iPlanningPaneSelectedContextId);
		if(treeContext !== null) {
			treeContext.classList.remove("treeSelected")
			//treeContext.style.color = "white";
		}
	}
	treeContext = document.getElementById("planningTreeContext_" + contextId);
	if(treeContext !== null) {
		//treeContext.style.color = "red";
		treeContext.classList.add("treeSelected")
	}

	g_iPlanningPaneSelectedContextId = contextId;

	document.getElementById("planningPaneDetails").innerHTML = "Devices<br><br>" + g_sTreeDevicesNoContent;

	return; //navtree
	if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING) {
		return;
	}
	
	try {
		
		planningDpList = [];
		g_iPlanningPaneSelectedContextType = 1;
		planningMenuCancel();
		testDeviceCancel();
		if(g_planningDpTimerId !== 0)
				clearTimeout(g_planningDpTimerId);
		g_sPlanningTreeDatapointPath =""; // only used for Devices and Datapoints nodes
		document.getElementById("planningContextDetailsDiv").style.visibility = "hidden";
		document.getElementById("planningRefreshButton").style.visibility = "hidden";
		
		// change color of tree context to indicate selected
		if(g_iPlanningPaneSelectedContextId !== -1) {
			treeContext = document.getElementById("planningTreeContext_" + g_iPlanningPaneSelectedContextId);
			if(treeContext !== null) {
				treeContext.style.backgroundColor = "white";
				//treeContext.style.color = "white";
			}
		}
		g_iPlanningPaneSelectedContextId = "Devices_" + contextId;
		treeContext = document.getElementById("planningTreeContext_" + g_iPlanningPaneSelectedContextId);
		if(treeContext !== null) {
			//treeContext.style.color = "red";
			treeContext.style.backgroundColor = "red";
		}
		
	}
	catch(err) {}

	if(contextId === -1) {
		document.getElementById("planningPaneDetails").innerHTML = "No Devices";
		return;
	}
	if((deviceListAll !== null) && (planningList !== null)) {
		//if((deviceListAll.length > 0) && (planningList.length > 0)) {
		if(deviceListAll.length > 0) {
			if(deviceTypeList.length === 0){
				url = "/iap/devTypes/*?short=false&sortBy=name&sortOrder=asc";
				requestGetData(contextId, url, treeviewShowContextDevicesInDetailsPaneDeviceTypeResponse, getPlanningTreeRequestFailure);
			}
			else 
				treeviewShowContextDevicesInDetailsPaneShow(contextId);
		}
	}
}
function treeviewShowContextDevicesInDetailsPaneDeviceTypeResponse(mode, url, json) {
	try {
		
		//if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING)
		//	return;

		cursorClearWait();
		deviceTypeList = json;
		treeviewShowContextDevicesInDetailsPaneShow(mode);
	}
	catch(err) {}
}

function treeviewShowContextDevicesInDetailsPaneShow(contextId) {

	var paneContent = "";
	var i,j,k, path, sTemp, obj;;
	var contextPath = "";
	var tempStr;
	var iTotal = 0, iUp = 0, iProvisioned = 0, iUnProvisioned = 0, iDown = 0;
	var contextObj = null;
	var treeContext = null;
	if((deviceListAll !== null) && (planningList !== null)) {
		//if((deviceListAll.length > 0) && (planningList.length > 0)) {
		if(deviceListAll.length > 0) {
			try {
				if(contextId === "_NoContext") {
					// unassigned devices
					contextObj = {};
					contextObj.path = "Un-assigned Devices";
					contextObj.devices = [];
					for(i= 0; i < deviceListAll.length; i ++)
					{
						if(deviceListAll[i].contexts.length === 0) {
							contextObj.devices.push(JSON.parse(JSON.stringify(deviceListAll[i])));
						}
					}
					// sort
					bContinue = true;
					while(bContinue)
					{
						bContinue = false;
						for(i= 0; i < (contextObj.devices.length - 1); i ++)
						{
							if(contextObj.devices[i].name > contextObj.devices[i + 1].name) {
								bContinue = true;
								obj = {};
								obj = JSON.parse(JSON.stringify(contextObj.devices[i]));
								contextObj.devices[i] = JSON.parse(JSON.stringify(contextObj.devices[i + 1]));
								contextObj.devices[i + 1] = obj;
							}
						}
					}
				}
				else
					contextObj = treeviewfindContextObj(contextId, planningList);
				if(contextObj === null) {
					document.getElementById("planningPaneDetails").innerHTML = "No Devices";
					return;
				}
				contextPath = contextObj.path;
				paneContent += "<tr><th onclick=\"sortTable(0)\">#</th>";
				paneContent += "<th>Menu</th>"; 
				paneContent += "<th onclick=\"sortTable(1)\">Device Name</th><th onclick=\"sortTable(2)\">Device Status</th>";
				paneContent += "<th onclick=\"sortTable(3)\">Device Type</th><th onclick=\"sortTable(6)\">UID</th>";
				paneContent += "<th onclick=\"sortTable(4)\">Program ID</th>";
				paneContent += "<th onclick=\"sortTable(5)\">Last Update</th><th onclick=\"sortTable(6)\">Protocol</th>"
				//paneContent += "<th onclick=\"sortTable(9)\">Category</th><th onclick=\"sortTable(10)\">SID</th><th onclick=\"sortTable(11)\">Address</th><th>Menu</th></tr>"; 
				paneContent += "<th onclick=\"sortTable(7)\">Category</th>";
				
				
				paneContent += "</tr>"; 
				for(k=0; k < contextObj.devices.length; k++) 
				{
					for(i= 0; i < deviceListAll.length; i ++)
					{	
						if(deviceListAll[i].id === contextObj.devices[k].id) {
							iTotal ++;
							path = "";
							paneContent += "<tr><td>" + iTotal.toString() + "</td>";
							
							if(deviceListAll[i].category	== "SC") {
								paneContent += "<td>";
								paneContent += "<button id=\"deviceMenu_" + deviceListAll[i].name + "\" onclick=\"menuDeviceSmartServer(0, event," + deviceListAll[i].id + ", '" + deviceListAll[i].name  + "')\">...</button>";
								paneContent += "</td>";
								iUp ++;
							}
							else {
								paneContent += "<td><button id=\"deviceMenu_" + deviceListAll[i].name + "\" onclick=\"menuDevice(0, event," + deviceListAll[i].id + ", '" + deviceListAll[i].name  + "', '" + deviceListAll[i].deviceTypeName  + "', '" + deviceListAll[i].protocol  + "')\">...</button></td>";
								if(deviceListAll[i].status.state === "provisioned") {
									if(deviceListAll[i].status.health === "normal")
										iUp ++;
									else
										iDown ++;
								}
								else
									iUnProvisioned ++;
							}
							paneContent += "<td>" + deviceListAll[i].name + "</td>";
							if(deviceListAll[i].category === "SC") {
								paneContent += "<td></td><td></td>";
								paneContent += "<td>" + deviceListAll[i].SID + "</td>";
								paneContent += "<td></td><td></td><td></td>";
							}
							else {
								paneContent += "<td>" + deviceListAll[i].deviceStatus + "</td>";
								paneContent += "<td>" + deviceListAll[i].deviceTypeName  + "</td><td>" + deviceListAll[i].uid  + "</td>";
								z = 0;
								for(j=0; j < deviceTypeList.length; j++)
								{
									if(deviceListAll[i].typeId === deviceTypeList[j].id) {
										paneContent += "<td>" + deviceTypeList[j].programId + "</td>";
										z = 1;
										break;
									}
								}
								if(z === 0)
									paneContent += "<td></td>";
								
								paneContent += "<td>" + deviceListAll[i].mru  + "</td>";
								paneContent += "<td>" + deviceListAll[i].protocol + "</td>";
							}
							paneContent += "<td>" + deviceListAll[i].category + "</td>";
							
							
							paneContent += "</tr>";
							
						}
					}
				}
				sTemp = "Total Devices [" + iTotal + "]: UP = " + iUp + ", Down = " + iDown + ", Unprov = " + iUnProvisioned;
				
				sTemp = "<br><br>" + sTemp +"<br>"
				paneContent = "Devices: " + contextPath + sTemp + "<br><table id=\"myTable\">" + paneContent + "</table>";
				
				document.getElementById("planningPaneDetails").innerHTML = paneContent;
				
			}
			catch {}
		}
		else
			document.getElementById("planningPaneDetails").innerHTML = "No Devices";
	}
	else
		document.getElementById("planningPaneDetails").innerHTML = "No Devices";
		
}