/*
	navtreeopenstreetmap.js (version 0.019) 
	
	This file is uses leaflet.js to access OpenStreetMap.js to create a map 

	init() - Sends message to map.js that map Div is ready, and processes messages from map.js
	
	showMapContent() - creates the map 
	initMap() - runs once, creates the "map" object which is used to add and remove content, called by showMapContent()
	addMapMarker - used to create a marker for a single device
	addMapCircleMarker - used to create a group marker for a group with more than one device meeting the control layer checkboxes states
	mapUpdateMarker() -  WebSocket update, used to update a marker due to device status change or datapoint value change
	mapContentZoomIn() - used to Zoom or out of context
	showMapContentConfigureShowGroupLayer() - used to add or remove control layer layergroups to map
	
	Leaflet info: this information may not be used at this time.
	To change existing marker icon:  markers[theID].setIcon();
		markers[theID].setContent('I am ALASKA!');
		device1Marker.unbindTooltip()
		device1Marker.bindTooltip("Device1: " + g_iTitle)
	To allow two popups open simultaneously

 *	Copyright (C) 2023 EnOcean GmbH.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	EnOcean Example Software License Agreement which is available at
 *	https://enoceanwiki.atlassian.net/wiki/spaces/LON/pages/2425260/Example+Software+License+Agreement.  

	This code is used to show the Priority array popup


*/
var g_oMap = null;
var mapName = "";
var map = null;
var mapPolygon = null;
var mapMarker = null;
var layers = [];
var coordPopup = null;
var g_bInitMap = true;
var mapOriginalZoomLevel = 1;
var mapOriginalLat = 0;
var mapOriginalLng = 0;
var g_bShowDevicesOption = 0;
var g_sDeviceWithPopupOpen = "";
var g_bUseControlLayer = true; // uses leafletjs control layer
var g_mapParentPolygonLayerGroup = null; //control layer
var g_mapCurrentPolygonLayerGroup = null //control layer
var g_mapChildPolygonLayerGroup = null; //control layer
var g_mapDeviceSmartServerLayerGroup = null;  //control layer
var g_mapDeviceUpLayerGroup = null;  //control layer
var g_mapDeviceDownLayerGroup = null; //control layer
var g_mapDeviceUnprovisionedLayerGroup = null; //control layer
var g_mapDeviceLightLayerGroup = null; //control layer
var g_mapDeviceGroupLayerGroup = null; //control layer
var g_mapLayerControl = null;
var g_mapDashboardLayerControl = null;
var g_bAtLeastOneLightDevice = true;
var g_oControlLayerAddedToMap = {};
var g_iMapDisplayIndex = 0;
var G_MAPZOOMINMAX = 19;
var g_oMapSpecialDevice = []; //used for special devices in map dashboard (e.g., l5d1)


var MapLeafIcon =  L.Icon.extend({
		options: {
			shadowUrl: "styles/images/marker-shadow.png",
			iconSize: [25, 41],
			iconAnchor: [12, 41],
			popupAnchor: [1, -34],
			tooltipAnchor: [16, -28],
			shadowSize: [41, 41]
		}
	});


var mapGreenIcon = new MapLeafIcon({iconUrl: 'styles/images/marker-icon-green.png'}),
	mapRedIcon = new MapLeafIcon({iconUrl: 'styles/images/marker-icon-red.png'}),
	mapDarkredIcon = new MapLeafIcon({iconUrl: 'styles/images/marker-icon-darkred.png'}),
	mapYellowIcon = new MapLeafIcon({iconUrl: 'styles/images/marker-icon-yellow.png'}),
	mapYellowDownIcon = new MapLeafIcon({iconUrl: 'styles/images/marker-icon-yellowdown.png'}),
	mapGreyIcon = new MapLeafIcon({iconUrl: 'styles/images/marker-icon-grey.png'}),
	mapGreyDownIcon = new MapLeafIcon({iconUrl: 'styles/images/marker-icon-greydown.png'}),
	mapDarkgreyIcon = new MapLeafIcon({iconUrl: 'styles/images/marker-icon-darkgrey.png'}),
	mapPaleyellowIcon = new MapLeafIcon({iconUrl: 'styles/images/marker-icon-paleyellow.png'}),
	mapPaleyellowDownIcon = new MapLeafIcon({iconUrl: 'styles/images/marker-icon-paleyellowdown.png'}),
	mapDarkyellowIcon = new MapLeafIcon({iconUrl: 'styles/images/marker-icon-darkyellow.png'}),
	mapDarkyellowDownIcon = new MapLeafIcon({iconUrl: 'styles/images/marker-icon-darkyellowdown.png'}),
	mapPinkIcon = new MapLeafIcon({iconUrl: 'styles/images/marker-icon-pink.png'}),
	mapCyanIcon = new MapLeafIcon({iconUrl: 'styles/images/marker-icon-cyan.png'}),
	mapBrownIcon = new MapLeafIcon({iconUrl: 'styles/images/marker-icon-brown.png'}),
	mapBlackIcon = new MapLeafIcon({iconUrl: 'styles/images/marker-icon-black.png'}),
	mapBlueIcon = new MapLeafIcon({iconUrl: 'styles/images/marker-icon.png'}),
	mapPurpleIcon = new MapLeafIcon({iconUrl: 'styles/images/marker-icon-purple.png'}),
	mapOrangeIcon = new MapLeafIcon({iconUrl: 'styles/images/marker-icon-orange.png'}); 


function init() {
	try {
		var i;
		var element = document.getElementById("map");
		var element1, obj;
		var content;
		//initMap(51.505,-0.09,13); // london
		const queryString = window.location.search;
		const urlParams = new URLSearchParams(queryString);

		mapName = urlParams.get('name');
		mapWidth = urlParams.get('width');
		mapHeight = urlParams.get('height');
		init_g_oMapSettings();
		
		//alert("mapName: " + mapName + "\r\nmapWidth: " + mapWidth + "\r\nmapHeight: " + mapHeight);
		if(element !== null) {
			element.style.width = mapWidth;
			element.style.height = mapHeight;
		}
		
		window.addEventListener('message', function (e) {
			// Get the sent data
			// add security check
			
			const data = e.data;
			//this.alert("message from iframe:\r\n\r\n" + data);
			// If you encode the message in JSON before sending them,
			// then decode here
			const decoded = JSON.parse(data);
			if(decoded.action === "initaildata") {
				//
				if(g_bInitMap) {
					g_bInitMap = false;
					g_oMap = {};
					g_oMap = JSON.parse(JSON.stringify(decoded.message));
					showMapContent(0, mapName);
					const message1 = JSON.stringify({
						"action": "initdone"
					});
					window.parent.postMessage(message1, "*");
				}
				
			}
			else if(decoded.action === "restart") {
				//
				if((typeof decoded.mode !== "undefined") && (typeof decoded.message !== "undefined")) {
					if(!g_bInitMap) {
						//remove all old info
						try {
							mapCleanup(decoded.mode);
						}
						catch {}
						
						init_g_oMapSettings();
						g_oMap = {};
						g_oMap = JSON.parse(JSON.stringify(decoded.message));
						mapAddCustomControl();
						showMapContent(1, mapName);
						if(g_oMap.InitialInfo !== null) {
							try {
								if(g_oMap.InitialInfo.popupGroupName !== "")
									g_sDeviceWithPopupOpen = g_oMap.InitialInfo.popupGroupName;
							}
							catch {}
							g_oMap.InitialInfo = null;
						}
						const message1 = JSON.stringify({
							"action": "resetdone"
						});
						window.parent.postMessage(message1, "*");
					}
				}
			}
			else if(decoded.action === "showMouseClickLatLong") {
				//
				if(typeof decoded.checked === "boolean") {
					g_oMap.options.bClickShowLatLong = decoded.checked;
				}
			}
			else if(decoded.action === "datapointupdate") {
				//

				//this.alert("datapoint Update: " + decoded.datapoint + "\r\n" + JSON.stringify(decoded.value));
				if((typeof decoded.datapoint !== "undefined") && (typeof decoded.value !== "undefined") && (typeof decoded.index !== "undefined")
					&& (typeof decoded.programId !== "undefined") && (typeof decoded.deviceName !== "undefined")
					&& (typeof decoded.bDevice !== "undefined")  && (typeof decoded.bDashboard !== "undefined")) {
						if((decoded.bDevice && ((decoded.programId === "800001230E041005") || (decoded.programId === "9FFFFF0501840460") || (decoded.programId === "900001153C000405")))
							|| decoded.bDashboard) {
							mapUpdateMarker(1, decoded);
						}
				}
				
			}
			else  if(decoded.action === "deviceupdate") {
				//

				//this.alert("datapoint Update: " + decoded.datapoint + "\r\n" + JSON.stringify(decoded.value));
				if((typeof decoded.deviceName !== "undefined") && (typeof decoded.message !== "undefined") && (typeof decoded.deviceStatus !== "undefined")) {
					mapUpdateMarker(2, decoded);
				}
			}
			
			else  if(decoded.action === "showTooltips") {
				if(typeof decoded.checked !== "undefined") {
					g_oMap.options.bShowAllTooltips = decoded.checked;
					showMapToolTips(); //only applies to markers no circle marker
					//showMapContent(2, mapName);
				}
			}
			else  if(decoded.action === "zoomtodevice") {
				//this.alert("datapoint Update: " + decoded.datapoint + "\r\n" + JSON.stringify(decoded.value));
				if((typeof decoded.name !== "undefined") && (typeof decoded.groupindex !== "undefined") && (typeof decoded.groupdeviceindex !== "undefined")) {
					if((decoded.groupindex < g_oMap.mapDeviceGroupList.length) && (decoded.groupdeviceindex < g_oMap.mapDeviceGroupList[decoded.groupindex].devices.length)) {
						if(decoded.name === g_oMap.mapDeviceGroupList[decoded.groupindex].devices[decoded.groupdeviceindex].name)
							mapZoomInShowPopup(decoded.name, decoded.groupindex); 
					}
				}
			}
			else  if(decoded.action === "mapDivResize") {
				//this.alert("datapoint Update: " + decoded.datapoint + "\r\n" + JSON.stringify(decoded.value));
				if((typeof decoded.width !== "undefined") && (typeof decoded.height !== "undefined") ) {
					if((decoded.width !== "") && (decoded.height !== "")) {
						if((typeof decoded.width === "number") && (typeof decoded.height === "number")) {
							element1 = document.getElementById("map");
							if(element1 !== null) {
								element1.style.width = decoded.width + "px";
								element1.style.height = decoded.height + "px";
								if(map !== null)
									map.invalidateSize();
							}
						}
					}
				}
			}
			else  if(decoded.action === "getcurrentsettings") {
				if(typeof decoded.mode !== "undefined") {
					if(decoded.mode === 1) {
						try {
							//rebuild g_oMap with current settings: zoom, lat, long, popup
							obj = {};
							obj.zoomLevel = map.getZoom();
							obj.latLng = JSON.parse(JSON.stringify(map.getCenter()));
							obj.popupGroupname = "";
							for(i = 0; i < g_oMap.mapDeviceGroupList.length; i++)
							{
								if(g_oMap.mapDeviceGroupList[i].marker !== null) {
									if(g_oMap.mapDeviceGroupList[i].marker.isPopupOpen()) {
										obj.popupGroupname = g_oMap.mapDeviceGroupList[i].groupName;
										break;
									}
								}
							}
							const message1 = JSON.stringify({
								"action": "currentsettings",
								"mode": decoded.mode,
								"obj": JSON.parse(JSON.stringify(obj))
							});
							window.parent.postMessage(message1, "*");
						}
						catch {}
					}
				}
			}
		});
			
		const message = JSON.stringify({
			"action": "init",
			"message": "success"
		});
		window.parent.postMessage(message, "*");
	}
	catch {}
}
function init_g_oMapSettings() {
	try {
		g_sDeviceWithPopupOpen = "";
		g_mapLayerControl = null;
		g_oControlLayerAddedToMap = {};
		g_oControlLayerAddedToMap = {};
		g_oControlLayerAddedToMap.bSmartServerDevices = false; //true means already added, false means not added
		g_oControlLayerAddedToMap.bSmartServerDevicesNeedToAdd = false;
		g_oControlLayerAddedToMap.bUpDevices = false;
		g_oControlLayerAddedToMap.bUpDevicesNeedToAdd = false;
		g_oControlLayerAddedToMap.bDownDevices = false;
		g_oControlLayerAddedToMap.bDownDevicesNeedToAdd = false;
		g_oControlLayerAddedToMap.bLightDevices = false;
		g_oControlLayerAddedToMap.bLightDevicesNeedToAdd = false;
		g_oControlLayerAddedToMap.bGroupDevices = false;
		g_oControlLayerAddedToMap.bGroupDevicesNeedToAdd = false;
		g_oControlLayerAddedToMap.bUnprovisionedDevices = false;
		g_oControlLayerAddedToMap.bUnprovisionedDevicesNeedToAdd = false;
		g_oControlLayerAddedToMap.bParentRegion = false;
		g_oControlLayerAddedToMap.bCurrentDevices = false;
		g_oControlLayerAddedToMap.bChildRegion = false;

		g_iMapDisplayIndex = 0;
		g_oMapSpecialDevice = [];
	}
	catch {}
}
function mapCleanup(mode) {
	var i = 0, error;
	try {
		showMapContentRemoveMarkerFromOldLayerGroup(null);
		for(i=0; i < g_oMap.mapDeviceGroupList.length; i++)
		{
			if(g_oMap.mapDeviceGroupList[i].marker !== null) {
				
				g_oMap.mapDeviceGroupList[i].marker.unbindTooltip();
				map.removeLayer(g_oMap.mapDeviceGroupList[i].marker);
				g_oMap.mapDeviceGroupList[i].marker = null;
			}
		}
		if(mode < 2) {
			for(i=0; i < g_oMap.mapParentPolygonList.length; i++)
			{
				if(g_oMap.mapParentPolygonList[i].polygon !== null) {
					map.removeLayer(g_oMap.mapParentPolygonList[i].polygon);
					g_oMap.mapParentPolygonList[i].polygon = null;
				}
			}
			for(i=0; i < g_oMap.mapPolygonList.length; i++)
			{
				if(g_oMap.mapPolygonList[i].polygon !== null) {
					map.removeLayer(g_oMap.mapPolygonList[i].polygon);
					g_oMap.mapPolygonList[i].polygon = null;
				}
			}
			for(i=0; i < g_oMap.mapChildPolygonList.length; i++)
			{
				if(g_oMap.mapChildPolygonList[i].polygon !== null) {
					map.removeLayer(g_oMap.mapChildPolygonList[i].polygon);
					g_oMap.mapChildPolygonList[i].polygon = null;
				}
			}
		}
		/*
		if(g_oControlLayerAddedToMap.bSmartServerDevices) {
			if(g_mapDeviceSmartServerLayerGroup !== null) {
				map.removeLayer(g_mapDeviceSmartServerLayerGroup);
				g_oControlLayerAddedToMap.bSmartServerDevices = false;
			}
		}
		if(g_oControlLayerAddedToMap.bUpDevices) {
			if(g_mapDeviceUpLayerGroup !== null) {
				map.removeLayer(g_mapDeviceUpLayerGroup);
				g_oControlLayerAddedToMap.bUpDevices = false;
			}
		}
		if(g_oControlLayerAddedToMap.bLightDevices) {
			if(g_mapDeviceLightLayerGroup !== null) {
				map.removeLayer(g_mapDeviceLightLayerGroup);
				g_oControlLayerAddedToMap.bLightDevices = false;
			}
		}
		if(g_oControlLayerAddedToMap.bDownDevices) {
			if(g_mapDeviceDownLayerGroup !== null) {
				map.removeLayer(g_mapDeviceDownLayerGroup);
				g_oControlLayerAddedToMap.bDownDevices = false;
			}
		}
		if(g_oControlLayerAddedToMap.bGroupDevices) {
			if(g_mapDeviceGroupLayerGroup !== null) {
				map.removeLayer(g_mapDeviceGroupLayerGroup);
				g_oControlLayerAddedToMap.bGroupDevices = false;
			}
		}
		if(g_oControlLayerAddedToMap.bUnprovisionedDevices) {
			if(g_mapDeviceUnprovisionedLayerGroup !== null) {
				map.removeLayer(g_mapDeviceUnprovisionedLayerGroup);
				g_oControlLayerAddedToMap.bUnprovisionedDevices = false;
			}
		}
		*/
		map.removeControl(g_mapLayerControl);
		g_mapLayerControl = null;
		
		map.clearLayers();
	}
	catch (err) 
	{
		error = err.toString();
	}
}
function showMapContent(mode, title) {
	showMapContent1(mode, title, null);
}
function showMapContent1(mode, title, index) {
	//mode: 0=init, 4= device status for single device, 5=rebuild groups with that have 2+ devices (used for checkbox changes), 6=used for group device status change
	//index: null means use 0, 
	try {
		var i,j, z;
		var content = "",content1 = "", content2, element;
		var name, sTemp;
		var iTotal, iTotalFound = 0, iUp, iDown, iSuspect, iUnprovisioned, iOn, iOff, iDim, iSmartservers, iLightDevice, iLightDownDevice;
		var color1;
		var count = 0;
		var value = null; // used for known light deviecs
		var bContinue, bContinue1, bContinue2;
		var borderColor, fillColor;
		var deviceIndex = -1; // for groups, only used if a single device meets all criteria
		var mode1 = 0;
		
		if(mode === 0)
			initMap(g_oMap.center.lat, g_oMap.center.long, g_oMap.center.zoomLevel, title); 
		
		try {
			if((mode === 0) || (mode === 1)) {
				showMapContentShowParentPolygon();
				showMapContentShowCurrentPolygon();
				showMapContentShowChildPolygon();
				
			}
		}
		catch {}
		if(index === null)
			index = 0;
		else if(index >= g_oMap.mapDeviceGroupList.length)
			return;
		
		for(i = index; i < g_oMap.mapDeviceGroupList.length; i++)
		{
			if(g_oMap.mapDeviceGroupList[i].count === 1) {
				if(mode < 5) {
					value = null;
					try {
						if(g_oMap.mapDeviceGroupList[i].devices[0].bLightDevice) {
							value = g_oMap.mapDeviceGroupList[i].devices[0].datapointsList[0].value;
							
						}
					}
					catch { value = null;}
					bContinue = true;
					
					if(bContinue) {
						g_oMap.mapDeviceGroupList[i].marker = addMapMarker(0, i, g_oMap.mapDeviceGroupList[i].lat, g_oMap.mapDeviceGroupList[i].long, g_oMap.mapDeviceGroupList[i].devices[0].name, g_oMap.mapDeviceGroupList[i].devices[0].id,
							g_oMap.mapDeviceGroupList[i].devices[0].status, i, JSON.parse(JSON.stringify(g_oMap.mapDeviceGroupList[i].devices[0])), null);
						
					}
				}
			}
			else {
				// use cluster marker with circle with number inside
				try {
					content = "";
					color1 = "#ffa500"; //"orange";
					iTotal = 0; iTotalFound = 0, iUp = 0; iDown = 0; iSuspect = 0; iUnprovisioned = 0; iOn = 0; iOff = 0; iDim = 0; iSmartservers = 0; iLightDevice = 0; iLightDownDevice = 0;
					content1 = "<button style=\"margin-left:5px\" onclick=\"";
					if(g_oMap.bOnlyWorld)
						content1 += "mapZoomOut()";
					else
						content1 += "mapZoomIn1(1,'',-1, " + i + ")";
					content1 += "\">Zoom Out</button><button style=\"margin-left:5px\" onclick=\"mapZoomIn('',-1, " + i + ")\">Zoom In</button><br><br>";
					content += "<div id=\"mapDeviceList\">";
					content2 = "";
					bContinue1 = true;
					deviceIndex = -1; // only used if a single device meets all criteria
					for(j=0; j < g_oMap.mapDeviceGroupList[i].devices.length; j++)
					{
						//if(j !== 0)
						//	content += "<br>";
						bContinue = true;
						
						
						if(bContinue) {
							bContinue1 = true;
							iTotal ++;
							if(iTotal === 1)
								deviceIndex = j;
							else 
								deviceIndex -1;
							name = g_oMap.mapDeviceGroupList[i].devices[j].name;
							bContinue2 = true;
							content2 = "<div style=\"cursor:pointer\" title=\"" + name + "\r\n\r\nClick to go to show device\" onclick=\"mapShowDevice('" + name + "'," + g_oMap.mapDeviceGroupList[i].devices[j].id + ")\">"
							if(g_oMap.mapDeviceGroupList[i].devices[j].bLightDevice) {
								if(g_oMap.options.bShowLightDevices)
									iLightDevice ++;
								else 
									bContinue2 = false;
							}
							if(bContinue2) {
								bContinue2 = false;
								if((g_oMap.mapDeviceGroupList[i].devices[j].status === "smartserver") && g_oMap.options.bShowSmartServerDevices) {
									content2 += '<span class="mapDot" style="background-color:purple"></span>';
									iSmartservers ++;
									iTotalFound ++;
									bContinue2 = true;
								}
								else if((g_oMap.mapDeviceGroupList[i].devices[j].status === "normal") && g_oMap.options.bShowUpDevices) {
									if(g_oMap.mapDeviceGroupList[i].devices[j].bLightDevice) {
										try {
											if(g_oMap.mapDeviceGroupList[i].devices[j].datapointsList[0].value === null) 
												content2 += '<span class="mapDot" style="background-color:lawngreen"></span>';
											else if(g_oMap.mapDeviceGroupList[i].devices[j].datapointsList[0].value === 0) {
												content2 += '<span class="mapDot" style="background-color:grey"></span>';
												iOff ++;
											}
											else if(g_oMap.mapDeviceGroupList[i].devices[j].datapointsList[0].value > 80) {
												content2 += '<span class="mapDot" style="background-color:yellow"></span>';
												iOn ++;
											}
											else  {
												content2 += '<span class="mapDot" style="background-color:orange"></span>';
												iDim ++;
											}
										}
										catch {}
									}
									else 
										content2 += '<span class="mapDot" style="background-color:lawngreen"></span>';
									iUp ++;
									iTotalFound ++;
									bContinue2 = true;
								}
								else if((g_oMap.mapDeviceGroupList[i].devices[j].status === "on") && g_oMap.mapDeviceGroupList[i].devices[j].bLightDevice && g_oMap.options.bShowLightDevices) {
									content2 += '<span class="mapDot" style="background-color:lawngreen"></span>';
									iUp ++;
									iOn ++;
									iLightDevice ++;
									iTotalFound ++;
									bContinue2 = true;
								}
								else if((g_oMap.mapDeviceGroupList[i].devices[j].status === "dim") && g_oMap.mapDeviceGroupList[i].devices[j].bLightDevice && g_oMap.options.bShowLightDevices) {
									content2 += '<span class="mapDot" style="background-color:lawngreen"></span>';
									iUp ++;
									iDim ++;
									iLightDevice ++;
									iTotalFound ++;
									bContinue2 = true;
								}
								else if ((g_oMap.mapDeviceGroupList[i].devices[j].status === "off") && g_oMap.mapDeviceGroupList[i].devices[j].bLightDevice && g_oMap.options.bShowLightDevices) {
									content2 += '<span class="mapDot" style="background-color:lawngreen"></span>';
									iLightDevice ++;
									iTotalFound ++;
									bContinue2 = true;
								}
								/*
								else if (((g_oMap.mapDeviceGroupList[i].devices[j].status === "down") || (g_oMap.mapDeviceGroupList[i].devices[j].status === "suspect")) 
									&& g_oMap.mapDeviceGroupList[i].devices[j].bLightDevice && g_oMap.options.bShowLightDevices && g_oMap.options.bShowDownDevices) {
									content2 += '<span class="mapDot" style="background-color:red"></span>';
									iLightDownDevice ++;
									iTotalFound ++;
									bContinue2 = true;
								}
								*/
								//else if((g_oMap.mapDeviceGroupList[i].devices[j].status === "down") && g_oMap.options.bShowDownDevices && !g_oMap.mapDeviceGroupList[i].devices[j].bLightDevice) {
								else if((g_oMap.mapDeviceGroupList[i].devices[j].status === "down") && g_oMap.options.bShowDownDevices) {
									content2 += '<span class="mapDot" style="background-color:red"></span>';
									iDown ++;
									iTotalFound ++;
									bContinue2 = true;
								}
								//else if((g_oMap.mapDeviceGroupList[i].devices[j].status === "suspect") && g_oMap.options.bShowDownDevices && !g_oMap.mapDeviceGroupList[i].devices[j].bLightDevice) {
								else if((g_oMap.mapDeviceGroupList[i].devices[j].status === "suspect") && g_oMap.options.bShowDownDevices) {
									content2 += '<span class="mapDot" style="background-color:red"></span>';
									iSuspect ++;
									iTotalFound ++;
									bContinue2 = true;
								}
								//else if((g_oMap.mapDeviceGroupList[i].devices[j].status === "unprovisioned") && !g_oMap.options.bShowLightDevices && g_oMap.options.bShowUnprovisionedDevices) {}
								else if((g_oMap.mapDeviceGroupList[i].devices[j].status === "unprovisioned") && g_oMap.options.bShowUnprovisionedDevices) {
									content2 += '<span class="mapDot" style="background-color:blue"></span>';
									iUnprovisioned ++;
									iTotalFound ++;
									bContinue2 = true;
								}
								/*
								else if((g_oMap.mapDeviceGroupList[i].devices[j].status === "unprovisioned") && g_oMap.options.bShowLightDevices && g_oMap.options.bShowUnprovisionedDevices) {
									content2 += '<span class="mapDot" style="background-color:blue"></span>';
									iUnprovisioned ++;
									iTotalFound ++;
									bContinue2 = true;
								} */
								else if (g_oMap.options.bShowUnprovisionedDevices) {
									if((g_oMap.mapDeviceGroupList[i].devices[j].status !== "normal") && (g_oMap.mapDeviceGroupList[i].devices[j].status !== "down") && (g_oMap.mapDeviceGroupList[i].devices[j].status !== "suspect")
										&& (g_oMap.mapDeviceGroupList[i].devices[j].status !== "on") && (g_oMap.mapDeviceGroupList[i].devices[j].status !== "dim") && (g_oMap.mapDeviceGroupList[i].devices[j].status !== "off")
										&& (g_oMap.mapDeviceGroupList[i].devices[j].status !== "smartserver")  && !g_oMap.mapDeviceGroupList[i].devices[j].bLightDevice) {
										content2 += '<span class="mapDot" style="background-color:blue"></span>';
										iUnprovisioned ++;
										iTotalFound ++;
										bContinue2 = true;
									}
								}
								
								content2 += "</span>";
								content2 += g_oMap.mapDeviceGroupList[i].devices[j].name;
								content2 += "</div>";
							}
							if(bContinue2)
								content += content2;
						}
					}
					if((bContinue1) && (iTotalFound > 0)) {
						// need at least one entry
						if((iTotalFound === 1) && (deviceIndex !== -1)) {
							if(mode >= 5)
								mode1 = 5;
							g_oMap.mapDeviceGroupList[i].marker = addMapMarker(mode1, i, g_oMap.mapDeviceGroupList[i].lat, g_oMap.mapDeviceGroupList[i].long, g_oMap.mapDeviceGroupList[i].devices[deviceIndex].name, 
								g_oMap.mapDeviceGroupList[i].devices[deviceIndex].id,
								g_oMap.mapDeviceGroupList[i].devices[deviceIndex].status, i, JSON.parse(JSON.stringify(g_oMap.mapDeviceGroupList[i].devices[deviceIndex])), null);
							if(g_sDeviceWithPopupOpen === g_oMap.mapDeviceGroupList[i].devices[deviceIndex].name) {
								g_oMap.mapDeviceGroupList[i].marker.openPopup();
							}
						}
						else {
								//group
							g_sDeviceWithPopupOpen = "";
							content += "</div>";
							content1 += '<div style=\"display:flex\">Status: ';
							if(iUp > 0)
								content1 += '<div title="up (normal) devices"><span class="mapDot" style="background-color:lawngreen"></span>' + iUp + '</div>';
							if((iDown > 0) || (iSuspect > 0) || (iLightDownDevice > 0))
								content1 += '<div title="down or suspect devices"><span class="mapDot" style="background-color:red"></span>' + (iDown + iSuspect + iLightDownDevice).toString() + '</div>';
							if(iUnprovisioned > 0)
								content1 += '<div title="unprovisioned or provisioning devices"><span class="mapDot" style="background-color:blue"></span>' + iUnprovisioned + '</div>';
							if(iSmartservers > 0) 
								content1 += '<div title="SmartServers devices"><span class="mapDot" style="background-color:purple"></span>' + iSmartservers + '</div>';
							if((iOn > 0) || (iDim > 0) || (iOff > 0))
								content1 += ' (';
							if(iOn > 0)
								content1 += '<div title="Lights ON devices"><span class="mapDot" style="background-color:yellow"></span>' + iOn + '</div>';
							if(iDim > 0)
								content1 += '<div title="Lights DIMMED devices"><span class="mapDot" style="background-color:orange"></span>' + iDim + '</div>';	
							if(iOff > 0)
								content1 += '<div title="Lights OFF devices"><span class="mapDot" style="background-color:grey"></span>' + iOff + '</div>';	
							if((iOn > 0) || (iDim > 0) || (iOff > 0))
								content1 += ')';
							content1 += "</div><br><br>";
							
							g_oMap.mapDeviceGroupList[i].content = content1 + content;
							borderColor = "blue";
							fillColor = "blue";
							if(iTotal === iSmartservers) {
								borderColor = "purple"; //border
								fillColor = "purple";
							}
							else if (iTotal === (iLightDevice + iLightDownDevice)) {
								if(iTotal === iUnprovisioned) {
									borderColor = "blue";
									fillColor = "blue";
								}
								else if((iDown + iSuspect + iLightDownDevice) > 0 ) {
									fillColor = "red";
									if(iUnprovisioned > 0)
										borderColor = "blue";
									else
										borderColor = "red";
								}
								else if(iTotal === iUp) {
									if(iTotal === iOn) {
										borderColor = "black";
										fillColor = "yellow";
									}
									else if(iTotal === iOff) {
										borderColor = "black";
										fillColor = "grey";
									}
									else if(iTotal === iDim) {
										borderColor = "black";
										fillColor = "orange";
									}
								}
								else if((iUp > 0) && (iDim === 0) && (iOff === 0)) {
									borderColor = "black";
									if(iUnprovisioned > 0)
										borderColor = "blue";
									fillColor = "yellow";
								}
								else if((iUp === 0) && (iDim > 0) && (iOff === 0)) {
									borderColor = "black";
									if(iUnprovisioned > 0)
										borderColor = "blue";
									fillColor = "orange";
								}
								else if((iUp === 0) && (iDim === 0) && (iOff > 0)) {
									borderColor = "black";
									if(iUnprovisioned > 0)
										borderColor = "blue";
									fillColor = "grey";
								}
							}
							else if(iTotal === iUp) {
								borderColor = "green";
								fillColor = "green";
							}
							else if(iTotal === iUnprovisioned) {
								borderColor = "blue";
								fillColor = "blue";
							}
							else if((iDown + iSuspect + iLightDownDevice) > 0 ) {
								fillColor = "red";
								if(iUnprovisioned > 0)
									borderColor = "blue";
								else
									borderColor = "red";
							}
							else if(iUp > 0) {
								fillColor = "green";
								if(iUnprovisioned > 0)
									borderColor = "blue";
								else
									borderColor = "green";
							}
							
							//addMapCircleMarker(lat,lng, title, color, fillColor, count, content1)
							sTemp = "";
							if((g_oMap.mapDeviceGroupList[i].groupContextName !== "") && (g_oMap.mapDeviceGroupList[i].groupContextPath !== "")
								&& (g_oMap.mapDeviceGroupList[i].groupContextId !== -1)) 
								sTemp = "<div onclick=\"mapShowContext(0, " + g_oMap.mapDeviceGroupList[i].groupContextId + ")\" title=\"Click to go to Context\" style=\"cursor:pointer\">" + g_oMap.mapDeviceGroupList[i].groupContextName + "</div><br>";

							g_oMap.mapDeviceGroupList[i].marker = addMapCircleMarker(g_oMap.mapDeviceGroupList[i].lat, g_oMap.mapDeviceGroupList[i].long, sTemp, g_oMap.mapDeviceGroupList[i].groupContextPath,
								 borderColor, fillColor, iTotalFound, g_oMap.mapDeviceGroupList[i].content);
							g_oMap.mapDeviceGroupList[i].sLayerGroupName = "group";
							if(g_mapDeviceGroupLayerGroup === null)
								g_mapDeviceGroupLayerGroup = L.layerGroup();
							g_mapDeviceGroupLayerGroup.addLayer(g_oMap.mapDeviceGroupList[i].marker);
						}
					
					}
				}
				catch {}
			}
			if((mode === 4) || (mode === 6))
				break;
		} 
		if((mode === 0) || (mode === 1)) {
			showMapContentConfigureShowGroupLayer(0);
			if(mode === 0) {
				if(g_oMap.mapDeviceGroupList.length < 2) {
					if(mapOriginalZoomLevel > 16)
						mapOriginalZoomLevel = 16;
				}
			}
			/*
			if(g_oMap.dashboard !== null) {
				if(g_oMap.dashboard.dpList.length > 0) {
					// Set inital map dashboard values
					try {
						for(i=0; i < g_oMap.dashboard.dpList.length; i++)
						{
							if(g_oMap.dashboard.dpList[i].mapDatapointsIndex !== -1) {
								element = document.getElementById("dashboardLocalValue_" + g_oMap.dashboard.dpList[i].mapDatapointsIndex);
								if(element !== null) {
									if(g_oMap.dashboard.dpList[i].mapDatapointsIndex < g_oMap.mapDatapoints.length) {
										z = g_oMap.dashboard.dpList[i].mapDatapointsIndex;
										if(typeof g_oMap.mapDatapoints[z].locValue !== "undefined") {
											if(g_oMap.mapDatapoints[z].locValue !== null) {
												value = g_oMap.mapDatapoints[z].locValue;
												if(g_oMap.dashboard.dpList[i].field !== "") {
													value = mapReadFieldValue(value, g_oMap.dashboard.dpList[i].field);
												}
												if(g_oMap.dashboard.dpList[i].displayType === "r") {
													element.innerHTML =  value;
												}
											}
										}
									}
								}
							}
						}
					}
					catch {}
				}
				
			}
			*/
		}
	}
	catch (err) {
		var error = err.toString();
	}
}
function showMapContentConfigureControlLayer(mode) { 
	try {

		var click_elements;
		if(mode === 0) {
			element = document.getElementById("customControlCheckboxId")
			if(element !== null) {
				if(g_oMap.options.bShowCustomControls) {
					element.checked = true;
				}
				else {
					element = document.getElementById('customControlDivId');
					if(element !== null)
						element.style.display = "none";
					element = document.getElementById('customControlDpDivId');
					if(element !== null)
						element.style.display = "none";
				}
			}
		}
		if(g_oMap.options.bShowSmartServerDevices) {
			element = document.getElementById("mapSmartServerCheckboxId")
			if(element !== null)
				element.checked = true;
		}
		if(g_oMap.options.bShowUpDevices) {
			element = document.getElementById("mapUpCheckboxId")
			if(element !== null)
				element.checked = true;
		}
		if(g_oMap.options.bShowDownDevices) {
			element = document.getElementById("mapDownCheckboxId")
			if(element !== null)
				element.checked = true;
		}
		if(g_oMap.options.bShowLightDevices) {
			element = document.getElementById("mapLightdevicesCheckboxId")
			if(element !== null)
				element.checked = true;
		}
		element = document.getElementById("mapGroupCheckboxId")
		if(element !== null) {
			if(g_oMap.bAtLeastOneGroupWithMultipleDevices) {
				if(g_oMap.options.bShowGroupDevices) 
					element.checked = true;
			}
			else {
				element.disabled = true;
				element = document.getElementById("mapGroupCheckboxSpanId")
				if(element !== null)
					element.style.color = "grey";
			}
		}
		if(g_oMap.options.bShowUnprovisionedDevices) {
			element = document.getElementById("mapUnprovisionedCheckboxId")
			if(element !== null)
				element.checked = true;
		}
		element = document.getElementById("mapParentRegionCheckboxId")
		if(element !== null) {
			if(g_oMap.mapParentPolygonList.length > 0) {
				if(g_oMap.options.bShowParentRegion)
					element.checked = true;
			}
			else {
				element.disabled = true;
				element = document.getElementById("mapParentRegionCheckboxSpanId")
				if(element !== null)
					element.style.color = "grey";
			}
		}
		element = document.getElementById("mapCurrentRegionCheckboxId")
		if(element !== null) {
			
			if(g_oMap.mapPolygonList.length > 0) {
				if(g_oMap.options.bShowCurrentRegion) 
					element.checked = true;
			}
			else {
				element.disabled = true;
				element = document.getElementById("mapCurrentRegionCheckboxSpanId")
				if(element !== null)
					element.style.color = "grey";
			}
		}
		element = document.getElementById("mapChildRegionCheckboxId")
		if(element !== null) {
			if(g_oMap.mapChildPolygonList.length > 0) {
				if(g_oMap.options.bShowChildRegion) 
					element.checked = true;
			}
			else {
				element.disabled = true;
				element = document.getElementById("mapChildRegionCheckboxSpanId")
				if(element !== null)
					element.style.color = "grey";
			}
		}
	}
	catch {}
}
function showMapContentConfigureShowGroupLayer(mode) { 
	showMapContentConfigureShowGroupLayer1(mode, 0);
}
function showMapContentConfigureShowGroupLayer1(mode, region) { 

	// mode: 0=initial, 1=change only specified ones, 2=only region change
	// regions: 0=none, 1=parent, 2=current, 3=child
	try {
		var bContinue;
		if(mode === 0) {
			if(g_oMap.options.bShowParentRegion) {
				if(g_mapParentPolygonLayerGroup !== null) {
					g_mapParentPolygonLayerGroup.addTo(map);
					g_oControlLayerAddedToMap.ParentRegion = true;
					if(g_oControlLayerAddedToMap.bGroupDevices) {
						//needed as group popup isn't clickable otherwise after change
					}
				}
			}
			else {
				if(g_mapParentPolygonLayerGroup !== null) {
					map.removeLayer(g_mapParentPolygonLayerGroup);
					g_oControlLayerAddedToMap.bCurrentRegion = false;
				}
			}
			if(g_oMap.options.bShowCurrentRegion) {
				if(g_mapCurrentPolygonLayerGroup !== null) {
					g_mapCurrentPolygonLayerGroup.addTo(map);
					g_oControlLayerAddedToMap.bCurrentRegion = true;
				}
			}
			else {
				if(g_mapCurrentPolygonLayerGroup !== null) {
					map.removeLayer(g_mapCurrentPolygonLayerGroup);
					g_oControlLayerAddedToMap.bCurrentRegion = false;
				}
			}
			if(g_oMap.options.bShowChildRegion) {
				if(g_mapChildPolygonLayerGroup !== null) {
					g_mapChildPolygonLayerGroup.addTo(map);
					g_oControlLayerAddedToMap.bChildRegion = true;
				}
			}
			else {
				if(g_mapChildPolygonLayerGroup !== null) {
					map.removeLayer(g_mapChildPolygonLayerGroup);
					g_oControlLayerAddedToMap.bChildRegion = false;
				}
			}
		}
		if(mode < 2) {
			if(g_oMap.options.bShowSmartServerDevices && ((mode ===0) || ((mode === 1) && g_oControlLayerAddedToMap.bSmartServerDevicesNeedToAdd))) {
				if(g_mapDeviceSmartServerLayerGroup !== null) {
					g_mapDeviceSmartServerLayerGroup.addTo(map);
					g_oControlLayerAddedToMap.bSmartServerDevices = true;
					g_oControlLayerAddedToMap.bSmartServerDevicesNeedToAdd = false;
				}
			}
			else if(mode === 0) {
				if(g_mapDeviceSmartServerLayerGroup !== null) {
					map.removeLayer(g_mapDeviceSmartServerLayerGroup);
					g_oControlLayerAddedToMap.bSmartServerDevices = false;
				}
			}
			if(g_oMap.options.bShowUpDevices && ((mode ===0) || ((mode === 1) && g_oControlLayerAddedToMap.bUpDevicesNeedToAdd))) {
				if(g_mapDeviceUpLayerGroup !== null) {
					g_mapDeviceUpLayerGroup.addTo(map);
					g_oControlLayerAddedToMap.bUpDevices = true;
					g_oControlLayerAddedToMap.bUpDevicesNeedToAdd = false;
				}
			}
			else if(mode === 0) {
				if(g_mapDeviceUpLayerGroup !== null) {
					map.removeLayer(g_mapDeviceUpLayerGroup);
					g_oControlLayerAddedToMap.bUpDevices = false;
				}
			}
			if(g_oMap.options.bShowLightDevices && ((mode ===0) || ((mode === 1) && g_oControlLayerAddedToMap.bLightDevicesNeedToAdd))) {
				if(g_mapDeviceLightLayerGroup !== null) {
					g_mapDeviceLightLayerGroup.addTo(map);
					g_oControlLayerAddedToMap.bLightDevices = true;
					g_oControlLayerAddedToMap.bLightDevicesNeedToAdd = false
				}
			}
			else if(mode === 0) {
				if(g_mapDeviceLightLayerGroup !== null) {
					map.removeLayer(g_mapDeviceLightLayerGroup);
					g_oControlLayerAddedToMap.bLightDevices = false;
				}
			}
			if(g_oMap.options.bShowDownDevices && ((mode ===0) || ((mode === 1) && g_oControlLayerAddedToMap.bDownDevicesNeedToAdd))) {
				if(g_mapDeviceDownLayerGroup !== null) {
					g_mapDeviceDownLayerGroup.addTo(map);
					g_oControlLayerAddedToMap.bDownDevices = true;
					g_oControlLayerAddedToMap.bDownDevicesNeedToAdd = false
				}
			}
			else if(mode === 0) {
				if(g_mapDeviceDownLayerGroup !== null) {
					map.removeLayer(g_mapDeviceDownLayerGroup);
					g_oControlLayerAddedToMap.bDownDevices = false;
				}
			}
			if(mode === 0) {
				if(g_oMap.options.bShowGroupDevices) {
					if(g_mapDeviceGroupLayerGroup !== null) {
						g_mapDeviceGroupLayerGroup.addTo(map);
						g_oControlLayerAddedToMap.bGroupDevices = true;
					}
				}
				else {
					if(g_mapDeviceGroupLayerGroup !== null) {
						map.removeLayer(g_mapDeviceGroupLayerGroup);
						g_oControlLayerAddedToMap.bGroupDevices = false;
					}
				}
			}
			if(g_oMap.options.bShowUnprovisionedDevices && ((mode ===0) || ((mode === 1) && g_oControlLayerAddedToMap.bUnprovisionedDevicesNeedToAdd))) {
				if(g_mapDeviceUnprovisionedLayerGroup !== null) {
					g_mapDeviceUnprovisionedLayerGroup.addTo(map);
					g_oControlLayerAddedToMap.bUnprovisionedDevices = true;
					g_oControlLayerAddedToMap.bUnprovisionedDevicesNeedToAdd = false;
				}
			}
			else if(mode === 0) {
				if(g_mapDeviceUnprovisionedLayerGroup !== null) {
					map.removeLayer(g_mapDeviceUnprovisionedLayerGroup);
					g_oControlLayerAddedToMap.bUnprovisionedDevices = false;
				}
			}
		}
		if(mode === 2) {
			// this needed as adding a polygon seems to be at a higher zindex then child polygons, makers and circle markers so you need to delete and re-add any already existing 
			bContinue = false;
			if((mode === 2) && (region === 1)) {
				if(g_oControlLayerAddedToMap.bCurrentRegion) {
					//needed as group popup isn't clickable otherwise after change
					map.removeLayer(g_mapCurrentPolygonLayerGroup);
					g_mapCurrentPolygonLayerGroup.addTo(map);
				}
				if(g_oControlLayerAddedToMap.bChildRegion) {
					//needed as group popup isn't clickable otherwise after change
					map.removeLayer(g_mapChildPolygonLayerGroup);
					g_mapChildPolygonLayerGroup.addTo(map);
				}
				bContinue = true;
			}
			else if((mode === 2) && (region === 2)) {
				if(g_oControlLayerAddedToMap.bChildRegion) {
					//needed as group popup isn't clickable otherwise after change
					map.removeLayer(g_mapChildPolygonLayerGroup);
					g_mapChildPolygonLayerGroup.addTo(map);
				}
				bContinue = true;
			}
			else if((mode === 2) && (region === 3)) {
				bContinue = true;
			}
			/*
			else {
				if(g_mapChildPolygonLayerGroup !== null) {
					map.removeLayer(g_mapChildPolygonLayerGroup);
					g_oControlLayerAddedToMap.bChildRegion = false;
				}
			}
			*/
			
			if(bContinue) {
				if(g_oControlLayerAddedToMap.bSmartServerDevices) {
					map.removeLayer(g_mapDeviceSmartServerLayerGroup);
					g_mapDeviceSmartServerLayerGroup.addTo(map);
				}
				if(g_oControlLayerAddedToMap.bUpDevices) {
					map.removeLayer(g_mapDeviceUpLayerGroup);
					g_mapDeviceUpLayerGroup.addTo(map);
				}
				if(g_oControlLayerAddedToMap.bLightDevices) {
					map.removeLayer(g_mapDeviceLightLayerGroup);
					g_mapDeviceLightLayerGroup.addTo(map);
				}
				if(g_oControlLayerAddedToMap.bDownDevices) {
					map.removeLayer(g_mapDeviceDownLayerGroup);
					g_mapDeviceDownLayerGroup.addTo(map);
				}
				if(g_oControlLayerAddedToMap.bGroupDevices) {
					map.removeLayer(g_mapDeviceGroupLayerGroup);
					g_mapDeviceGroupLayerGroup.addTo(map);
				}
			}
		}
		g_oControlLayerAddedToMap.bSmartServerDevicesNeedToAdd = false;
		g_oControlLayerAddedToMap.bUpDevicesNeedToAdd = false;
		g_oControlLayerAddedToMap.bDownDevicesNeedToAdd = false;
		g_oControlLayerAddedToMap.bLightDevicesNeedToAdd = false;
		g_oControlLayerAddedToMap.bGroupDevicesNeedToAdd = false;
		g_oControlLayerAddedToMap.bUnprovisionedDevicesNeedToAdd = false;
	}
	catch {}
}
function showMapContentConfigureControlLayerAddEvents(mode) {
	// mode: 0=add event, 1=remove event
	var element;
	try {
		if(mode === 0) {
			document.getElementById('customControlCheckboxId').addEventListener('change',function() {
				showMapContentConfigureControlLayerCheckboxEventSendUpdate("currentcontrols", this.checked);
				g_oMap.options.bShowCustomControls = this.checked;
				if(this.checked) {
					element = document.getElementById('customControlDivId');
					if(element !== null)
						element.style.display = "block";
					element = document.getElementById('customControlDpDivId');
					if(element !== null)
						element.style.display = "block";
				}
				else {
					element = document.getElementById('customControlDivId');
					if(element !== null)
						element.style.display = "none";
					element = document.getElementById('customControlDpDivId');
					if(element !== null)
						element.style.display = "none";
				}
			});
			if(!g_oMap.bOnlyWorld) {
				document.getElementById('mapParentRegionCheckboxId').addEventListener('change',function() {
					showMapContentConfigureControlLayerCheckboxEventSendUpdate("parentregion", this.checked);
					g_oMap.options.bShowParentRegion = this.checked;
					if(g_oMap.options.bShowParentRegion) {
						if(g_mapParentPolygonLayerGroup !== null) {
							g_mapParentPolygonLayerGroup.addTo(map);
							showMapContentConfigureShowGroupLayer1(2, 1); 
						}
					}
					else {
						if(g_mapParentPolygonLayerGroup !== null)
							map.removeLayer(g_mapParentPolygonLayerGroup);
					}
				});
			}
			document.getElementById('mapCurrentRegionCheckboxId').addEventListener('change',function() {
				showMapContentConfigureControlLayerCheckboxEventSendUpdate("currentregion", this.checked);
				g_oMap.options.bShowCurrentRegion = this.checked;
				if(g_oMap.options.bShowCurrentRegion) {
					if(g_mapCurrentPolygonLayerGroup !== null) {
						g_mapCurrentPolygonLayerGroup.addTo(map);
						showMapContentConfigureShowGroupLayer1(2, 2); 
					}
				}
				else {
					if(g_mapCurrentPolygonLayerGroup !== null)
						map.removeLayer(g_mapCurrentPolygonLayerGroup);
				}
			});
			if(!g_oMap.bOnlyWorld) {
				document.getElementById('mapChildRegionCheckboxId').addEventListener('change',function() {
					showMapContentConfigureControlLayerCheckboxEventSendUpdate("childregion", this.checked);
					g_oMap.options.bShowChildRegion = this.checked;
					if(g_oMap.options.bShowChildRegion) {
						if(g_mapChildPolygonLayerGroup !== null) {
							g_mapChildPolygonLayerGroup.addTo(map);
							showMapContentConfigureShowGroupLayer1(2, 3); 
						}
					}
					else {
						if(g_mapChildPolygonLayerGroup !== null)
							map.removeLayer(g_mapChildPolygonLayerGroup);
					}
				});
			}
			document.getElementById('mapSmartServerCheckboxId').addEventListener('change',function() {
				showMapContentConfigureControlLayerCheckboxEventSendUpdate("smartserver", this.checked);
				showMapContentRemoveMarkerFromOldLayerGroup(null);
				g_oMap.options.bShowSmartServerDevices = this.checked;
				showMapContent(5, mapName);
				if(g_oMap.options.bShowSmartServerDevices) {
					if(g_mapDeviceSmartServerLayerGroup !== null) {
						g_mapDeviceSmartServerLayerGroup.addTo(map);
						g_oControlLayerAddedToMap.bSmartServerDevices = true;
					}
				}
				else {
					if(g_mapDeviceSmartServerLayerGroup !== null) {
						map.removeLayer(g_mapDeviceSmartServerLayerGroup);
						g_oControlLayerAddedToMap.bSmartServerDevices = false;
					}
				}
				showMapContentConfigureShowGroupLayer(1); // add any control layer to the map that needed due to group changes
				//alert('Checkedbox Changed:' + this.id + ", " + this.checked);
			});
			document.getElementById('mapUpCheckboxId').addEventListener('change',function() {
				showMapContentConfigureControlLayerCheckboxEventSendUpdate("up", this.checked);
				showMapContentRemoveMarkerFromOldLayerGroup(null);
				g_oMap.options.bShowUpDevices = this.checked;
				showMapContent(5, mapName);
				if(g_oMap.options.bShowUpDevices) {
					if(g_mapDeviceUpLayerGroup !== null) {
						g_mapDeviceUpLayerGroup.addTo(map);
						g_oControlLayerAddedToMap.bUpDevices = true;
					}
				}
				else {
					if(g_mapDeviceUpLayerGroup !== null) {
						map.removeLayer(g_mapDeviceUpLayerGroup);
						g_oControlLayerAddedToMap.bUpDevices = false;
					}
				}
				showMapContentConfigureShowGroupLayer(1); // add any control layer to the map that needed due to group changes
			});
			document.getElementById('mapDownCheckboxId').addEventListener('change',function() {
				showMapContentConfigureControlLayerCheckboxEventSendUpdate("down", this.checked);
				showMapContentRemoveMarkerFromOldLayerGroup(null);
				g_oMap.options.bShowDownDevices = this.checked;
				showMapContent(5, mapName);
				if(g_oMap.options.bShowDownDevices) {
					if(g_mapDeviceDownLayerGroup !== null) {
						g_mapDeviceDownLayerGroup.addTo(map);
						g_oControlLayerAddedToMap.bDownDevices = true;
					}
				}
				else {
					if(g_mapDeviceDownLayerGroup !== null) {
						map.removeLayer(g_mapDeviceDownLayerGroup);
						g_oControlLayerAddedToMap.bDownDevices = false;
					}
				}
				showMapContentConfigureShowGroupLayer(1); // add any control layer to the map that needed due to group changes
			});
			document.getElementById('mapGroupCheckboxId').addEventListener('change',function() {
				showMapContentConfigureControlLayerCheckboxEventSendUpdate("group", this.checked);
				g_oMap.options.bShowGroupDevices = this.checked;
				if(g_oMap.options.bShowGroupDevices) {
					if(g_mapDeviceGroupLayerGroup !== null) {
						g_mapDeviceGroupLayerGroup.addTo(map);
						g_oControlLayerAddedToMap.bGroupDevices = true;
					}
				}
				else {
					if(g_mapDeviceGroupLayerGroup !== null) {
						map.removeLayer(g_mapDeviceGroupLayerGroup);
						g_oControlLayerAddedToMap.bGroupDevices = false;
					}
				}
				showMapContentConfigureShowGroupLayer(1); // add any control layer to the map that needed due to group changes
			});
			document.getElementById('mapUnprovisionedCheckboxId').addEventListener('change',function() {
				showMapContentConfigureControlLayerCheckboxEventSendUpdate("unprovisioned", this.checked);
				showMapContentRemoveMarkerFromOldLayerGroup(null);
				g_oMap.options.bShowUnprovisionedDevices = this.checked;
				showMapContent(5, mapName);
				if(g_oMap.options.bShowUnprovisionedDevices) {
					if(g_mapDeviceUnprovisionedLayerGroup !== null) {
						g_mapDeviceUnprovisionedLayerGroup.addTo(map);
						g_oControlLayerAddedToMap.bUnprovisionedDevices = true;
					}
				}
				else {
					if(g_mapDeviceUnprovisionedLayerGroup !== null) {
						map.removeLayer(g_mapDeviceUnprovisionedLayerGroup);
						g_oControlLayerAddedToMap.bUnprovisionedDevices = false;
					}
				}
				showMapContentConfigureShowGroupLayer(1); // add any control layer to the map that needed due to group changes
			});
			document.getElementById('mapLightdevicesCheckboxId').addEventListener('change',function() {
				showMapContentConfigureControlLayerCheckboxEventSendUpdate("lightdevice", this.checked);
				showMapContentRemoveMarkerFromOldLayerGroup(null);
				g_oMap.options.bShowLightDevices = this.checked;
				showMapContent(5, mapName);
				if(g_oMap.options.bShowLightDevices) {
					if(g_mapDeviceLightLayerGroup !== null) {
						g_mapDeviceLightLayerGroup.addTo(map);
						g_oControlLayerAddedToMap.bLightDevices = true;
					}
				}
				else {
					if(g_mapDeviceLightLayerGroup !== null) {
						map.removeLayer(g_mapDeviceLightLayerGroup);
						g_oControlLayerAddedToMap.bLightDevices = false;
					}
				}
				showMapContentConfigureShowGroupLayer(1); // add any control layer to the map that needed due to group changes
			});
			
		}
	}
	catch {}
}
function showMapContentConfigureControlLayerCheckboxEventSendUpdate(name, checked) {
	try {
		if((name === null) || (checked === null) || (name === ""))
			return;	
		const message1 = JSON.stringify({
			"action": "optionChange",
			"type": name,
			"checked": checked
		});
		window.parent.postMessage(message1, "*");
	
	}
	catch {}
}
function showMapContentRemoveMarkerFromOldLayerGroup(index) {
	try {
		var i, bExit = false;
		var mode = 0;
		if(index !== null) {
			//only do for index provided.
			mode = 1;
			if(index >= g_oMap.mapDeviceGroupList.length)
				return;
			bExit = true;
		}
		else
			index = 0;
		for(i=index; i < g_oMap.mapDeviceGroupList.length; i++)
		{
			if(((mode === 0) && (g_oMap.mapDeviceGroupList[i].devices.length > 1)) || (mode === 1)) {
				try {
					if(g_oMap.mapDeviceGroupList[i].sLayerGroupName === null) {
					
					}
					else if(g_oMap.mapDeviceGroupList[i].sLayerGroupName === "smartserver") {
						try {
							if(g_mapDeviceSmartServerLayerGroup !== null) {
								if(g_oMap.mapDeviceGroupList[i].marker !== null) {
									g_mapDeviceSmartServerLayerGroup.removeLayer(g_oMap.mapDeviceGroupList[i].marker); 
									g_oMap.mapDeviceGroupList[i].sLayerGroupName = null;
								}
							}
							
						}
						catch {}
					}
					else if(g_oMap.mapDeviceGroupList[i].sLayerGroupName === "up") {
						try {
							if(g_oMap.mapDeviceGroupList[i].marker !== null) {
								g_mapDeviceUpLayerGroup.removeLayer(g_oMap.mapDeviceGroupList[i].marker); 
								g_oMap.mapDeviceGroupList[i].sLayerGroupName = null;
							}
						}
						catch {}
					}
					else if(g_oMap.mapDeviceGroupList[i].sLayerGroupName === "down") {
						try {
							if(g_oMap.mapDeviceGroupList[i].marker !== null) {
								g_mapDeviceDownLayerGroup.removeLayer(g_oMap.mapDeviceGroupList[i].marker); 
								g_oMap.mapDeviceGroupList[i].sLayerGroupName = null;
							}
						}
						catch {}
					}
					else if(g_oMap.mapDeviceGroupList[i].sLayerGroupName === "unprovisioned") {
						try {
							if(g_oMap.mapDeviceGroupList[i].marker !== null) {
								g_mapDeviceUnprovisionedLayerGroup.removeLayer(g_oMap.mapDeviceGroupList[i].marker); 
								g_oMap.mapDeviceGroupList[i].sLayerGroupName = null;
							}
						}
						catch {}
					}
					else if(g_oMap.mapDeviceGroupList[i].sLayerGroupName === "light") {
						try {
							if(g_oMap.mapDeviceGroupList[i].marker !== null) {
								g_mapDeviceLightLayerGroup.removeLayer(g_oMap.mapDeviceGroupList[i].marker); 
								g_oMap.mapDeviceGroupList[i].sLayerGroupName = null;
							}
						}
						catch {}
					}
					else if(g_oMap.mapDeviceGroupList[i].sLayerGroupName === "group") {
						if(g_oMap.mapDeviceGroupList[i].marker !== null) {
							g_mapDeviceGroupLayerGroup.removeLayer(g_oMap.mapDeviceGroupList[i].marker);
							g_oMap.mapDeviceGroupList[i].sLayerGroupName = null;
						}
					}
					if(bExit)
						break; // run only once
				}
				catch {}
			}
		}
	}
	catch {}
}
function showMapContentSendControlLayerOption(name, checked) {
	//mode: 0=false, 1=true
	try {
		var i, name = "";
		alert("whi is this running");
		return;

	}
	catch {}
}

function showMapContentShowParentPolygon() {
	try {
		var i, content2;
		//if(g_oMap.options.bShowParentContext) {
			for(i=0; i < g_oMap.mapParentPolygonList.length; i++)
			{
				content2 = "<div title=\"Click to go to context\" style=\"cursor:pointer\" onclick=\mapShowContext(0, " + g_oMap.mapParentPolygonList[i].contextId + ")\">" + g_oMap.mapParentPolygonList[i].name + "</div>";
				content2 += "<br>";
				//if(g_oMap.mapParentPolygonList[i].parentContextType !== "WORLD")
					//content2 += "<button style=\"margin-left:5px\" onclick=\"mapZoomOut()\">Zoom Out</button>";
					//content2 += "<button style=\"margin-left:5px\" onclick=\"mapContentZoomIn('" + g_oMap.mapParentPolygonList[i].parentPath + "',-1, null)\">Zoom Out</button>";
				content2 += "<button style=\"margin-left:5px\" onclick=\"mapContentZoomIn('" + g_oMap.mapParentPolygonList[i].path + "',0, " + i + ")\">Zoom In</button><br>";
				if(g_oMap.mapParentPolygonList[i].color === "")
					g_oMap.mapParentPolygonList[i].polygon = L.polygon(g_oMap.mapParentPolygonList[i].polygonCoord).bindPopup(content2);
				else 
					g_oMap.mapParentPolygonList[i].polygon = L.polygon(g_oMap.mapParentPolygonList[i].polygonCoord,{color:g_oMap.mapParentPolygonList[i].color}).bindPopup(content2);
				if(g_bUseControlLayer)	{
					if(g_mapParentPolygonLayerGroup === null)
						g_mapParentPolygonLayerGroup = L.layerGroup();
					g_mapParentPolygonLayerGroup.addLayer(g_oMap.mapParentPolygonList[i].polygon);
				}
				
			} 
		//}
	}
	catch {}
}
function showMapContentShowCurrentPolygon() {
	try {
		var i, content2;
		//if(g_oMap.options.bShowContext) {
			for(i=0; i < g_oMap.mapPolygonList.length; i++)
			{
				content2 = "<div title=\"Click to go to context\" style=\"cursor:pointer\" onclick=\"mapShowContext(0, " + g_oMap.mapPolygonList[i].contextId + ")\">" + g_oMap.mapPolygonList[i].name + "</div>";
				content2 += "<br>";
				if(g_oMap.mapParentPolygonList.length > 0) {
					if(g_oMap.mapPolygonList[i].parentContextType === "WORLD")
						content2 += "<button style=\"margin-left:5px\" onclick=\"mmapZoomOut()\">Zoom Out</button>";
					else 
						content2 += "<button style=\"margin-left:5px\" onclick=\"mapContentZoomIn('" + g_oMap.mapPolygonList[i].parentPath + "',0, null)\">Zoom Out</button>";
				}
				content2 += "<button style=\"margin-left:5px\" onclick=\"mapContentZoomIn('" + g_oMap.mapPolygonList[i].path + "',1, " + i + ")\">Zoom In</button><br>";
				if(g_oMap.mapPolygonList[i].color === "")
					g_oMap.mapPolygonList[i].polygon = L.polygon(g_oMap.mapPolygonList[i].polygonCoord).bindPopup(content2);
				else 
					g_oMap.mapPolygonList[i].polygon = L.polygon(g_oMap.mapPolygonList[i].polygonCoord,{color:g_oMap.mapPolygonList[i].color}).bindPopup(content2);
				if(g_bUseControlLayer)	{
					if(g_mapCurrentPolygonLayerGroup === null)
						g_mapCurrentPolygonLayerGroup = L.layerGroup();
					g_mapCurrentPolygonLayerGroup.addLayer(g_oMap.mapPolygonList[i].polygon);
				}
			} 
		//}
	}
	catch {}
}
function showMapContentShowChildPolygon() {
	try {
		var i, content2;
		//if(g_oMap.options.bShowChildContexts) {
			for(i=0; i < g_oMap.mapChildPolygonList.length; i++)
			{
				content2 = "<div title=\"Click to go to context\" style=\"cursor:pointer\" onclick=\"mapShowContext(0, " + g_oMap.mapChildPolygonList[i].contextId + ")\">" + g_oMap.mapChildPolygonList[i].name + "</div>";
				content2 += "<br>";
				if((g_oMap.mapPolygonList.length > 0) || (g_oMap.mapChildPolygonList[i].level > 1)) {
					if(g_oMap.mapChildPolygonList[i].parentContextType === "WORLD")
						content2 += "<button style=\"margin-left:5px\" onclick=\"mapZoomOut()\">Zoom Out</button>";
					else 
						content2 += "<button style=\"margin-left:5px\" onclick=\"mapContentZoomIn('" + g_oMap.mapChildPolygonList[i].parentPath + "'," + g_oMap.mapChildPolygonList[i].parentPolygonArray + ", null)\">Zoom Out</button>";
				}
				content2 += "<button style=\"margin-left:5px\" onclick=\"mapContentZoomIn('" + g_oMap.mapChildPolygonList[i].path + "',2, " + i + ")\">Zoom In</button><br>";
				if(g_oMap.mapChildPolygonList[i].color === "")
					g_oMap.mapChildPolygonList[i].polygon = L.polygon(g_oMap.mapChildPolygonList[i].polygonCoord).bindPopup(content2);
				else 
					g_oMap.mapChildPolygonList[i].polygon = L.polygon(g_oMap.mapChildPolygonList[i].polygonCoord,{color:g_oMap.mapChildPolygonList[i].color}).bindPopup(content2);
				if(g_bUseControlLayer)	{
					if(g_mapChildPolygonLayerGroup === null)
						g_mapChildPolygonLayerGroup = L.layerGroup();
					g_mapChildPolygonLayerGroup.addLayer(g_oMap.mapChildPolygonList[i].polygon);
				}
		//	} 
		}
	}
	catch {}
}
function showMapToolTips() {
	 //only applies to markers no circle marker
	 var i;
	 try {
		for(i=0; i < g_oMap.mapDeviceGroupList.length; i++)
		{
			if(g_oMap.mapDeviceGroupList[i].marker !== null) {
				if(g_oMap.mapDeviceGroupList[i].sLayerGroupName !== "group") {
					g_oMap.mapDeviceGroupList[i].marker.unbindTooltip();
					if(g_oMap.options.bShowAllTooltips) {
						g_oMap.mapDeviceGroupList[i].marker.bindTooltip(g_oMap.mapDeviceGroupList[i].titleContent, {permanent: true});
					}
					else {
						g_oMap.mapDeviceGroupList[i].marker.bindTooltip(g_oMap.mapDeviceGroupList[i].titleContent);
					}
				}
			}
		}
	 }
	 catch {}
}
function onMapClick(e) {
	if(g_oMap.options.bClickShowLatLong) {
		if(coordPopup === null) {
			coordPopup = L.popup()
			.setLatLng(e.latlng)
			.setContent("lat: " + e.latlng.lat + "<br>long: " + e.latlng.lng) //(e.latlng.toString())
			.openOn(map);
		}
		else {
		coordPopup
			.setLatLng(e.latlng)
			.setContent("lat: " + e.latlng.lat + "<br>long: " + e.latlng.lng)//("You clicked the map at " + e.latlng.toString())
			.openOn(map);
		}
	/*
	element = document.getElementById("lat");
	if(element !== null)
		element.innerHTML = "lat=" + e.latlng.lat;
	element = document.getElementById("long");
	if(element !== null)
		element.innerHTML = "long=" + e.latlng.lng;
		*/
	}
}

function initMap(lat, lng, zoomLevel, title) {
	var i;
	var element = document.getElementById("map");
	var content = title; // + "<br><br><button onclick='showContext(\"" + title + "\")'>Info</button>";
	var markerCoordinates = null;
	
	if(map !== null) {
		// required if you are deleting the map div, like you would do in navtree
		try {
			map.off();
			map.remove();
		}
		catch {}
		document.getElementById("map").innerHTML = "";
		map = null;
	}
	mapOriginalZoomLevel = zoomLevel;
	mapOriginalLat = lat;
	mapOriginalLng = lng;
	//alert(mapOriginalLat + ", " + mapOriginalLng + ", " + mapOriginalZoomLevel);
	if(map === null) {
		map = L.map('map').setView([lat, lng], zoomLevel);
		map.on('click', onMapClick);
	}
	else {
		map.setView(new L.LatLng(lat, lng), zoomLevel);
	}
	L.tileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {
		maxZoom: 20,
		attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'
	}).addTo(map);
	//g_mapLayerControl = L.control.layers(null, null).addTo(map);
	mapAddCustomControl();
}
function mapAddCustomControl() {
	try {
		var content = `
		<div class="leaflet-control-layers leaflet-control-layers-expanded">
			<input class="leaflet-control-layers-overlays" id="customControlCheckboxId" title="Show/hide Dashboard" type="checkbox" style=\"float:right;\" /><br>
			<div id="customControlDivId">
			<input class="leaflet-control-layers-overlays" id="mapSmartServerCheckboxId" type="checkbox"  /><span id="mapSmartServerCheckboxSpanId">SmartServer</span><br>
			<input class="leaflet-control-layers-overlays" id="mapUpCheckboxId"  type="checkbox"  /><span id="mapUpCheckboxSpanId">Up Devices</span><br>
			<input class="leaflet-control-layers-overlays" id="mapDownCheckboxId"  type="checkbox"  /><span id="mapDownCheckboxSpanId">Down Devices</span><br>`;
			if(g_bAtLeastOneLightDevice)
				content += `<input class="leaflet-control-layers-overlays" id="mapLightdevicesCheckboxId" type="checkbox"  /><span id="mapLightdevicesCheckboxId">Light Controllers</span><br>`;
			content += `<input class="leaflet-control-layers-overlays" id="mapGroupCheckboxId"  type="checkbox"  /><span id="mapGroupCheckboxSpanId">Device Groups</span><br>
			<input class="leaflet-control-layers-overlays" id="mapUnprovisionedCheckboxId"  type="checkbox"  /><span id="mapUnprovisionedCheckboxSpanId">Unprovisioned Devices</span>
			<hr>`;
			if(!g_oMap.bOnlyWorld)
				content += `<input class="leaflet-control-layers-overlays" id="mapParentRegionCheckboxId" type="checkbox"  /><span id="mapParentRegionCheckboxSpanId">Parent Region</span><br>`;
			content += `<input class="leaflet-control-layers-overlays" id="mapCurrentRegionCheckboxId" type="checkbox"  /><span id="mapCurrentRegionCheckboxSpanId">Current Region</span><br>`;
			if(!g_oMap.bOnlyWorld)
				content += `<input class="leaflet-control-layers-overlays" id="mapChildRegionCheckboxId" type="checkbox" " /><span id="mapChildRegionCheckboxSpanId">Child Regions</span><br>`;
			content += `</div>
		</div>`; 
		content += mapAddMapDashboardDpCustomControl();
		L.Control.myControl= L.Control.extend({
			options: {
				position:"topright"
			},
			
			onAdd: function (map) {
				var container = L.DomUtil.create('div');
				container.id = "mapCustomControls";
				container.innerHTML = content;
				L.DomEvent.disableClickPropagation(container);
				return container;
			},
			onRemove: function (map) {

			}
		});
		L.control.mapControl = function (opts) {
			return new L.Control.myControl();
		};
		g_mapLayerControl = L.control.mapControl().addTo(map);
		mapAddMapDashboardDpCustomControlCreateDpHtmlAddSpecialHtml();
		// Set default states
		showMapContentConfigureControlLayer(0);
		
		// add checkbox onchange events
		showMapContentConfigureControlLayerAddEvents(0);
		
	}
	catch {}

}
function mapAddMapDashboardDpCustomControl() {
	try {
		var content = "";
		var i, name, label, index, z, bContinue, obj;
		var value, field, str;
		//g_oMap.dashboard.dpList[i].bReadOnly
		if(g_oMap.dashboard === null)
			return "";
		content = `<div id="customControlDpDivId">`;
		content += `<div class="leaflet-control-layers leaflet-control-layers-expanded mapDashboardCustomControlsDiv" >`;
		if(g_oMap.dashboard.name !== "")
			content += "<div style=\"width:100%;text-align:center\">" + g_oMap.dashboard.name + "</div><br><br>";
		if(g_oMap.dashboard.dpList.length > 0)
			content += "<table>";
		for(i=0; i < g_oMap.dashboard.dpList.length; i++)
		{
			if(g_oMap.dashboard.dpList[i].displayType === "ts") {
				// update scalevalue on parent 
				try {
					if(g_oMap.dashboard.dpList[i].parentDpListIndex < g_oMap.dashboard.dpList.length) {
						index = g_oMap.dashboard.dpList[i].parentDpListIndex;
						str = g_oMap.dashboard.dpList[index].deviceName + "/" + g_oMap.dashboard.dpList[index].blockPath;
						if(str === g_oMap.dashboard.dpList[i].parentPath) {
							if(g_oMap.dashboard.dpList[i].mapDatapointsIndex !== -1) {
								if(g_oMap.dashboard.dpList[i].mapDatapointsIndex < g_oMap.mapDatapoints.length) {
									z = g_oMap.dashboard.dpList[i].mapDatapointsIndex;
									if(typeof g_oMap.mapDatapoints[z].locValue !== "undefined") {
										if(g_oMap.mapDatapoints[z].locValue !== null) {
											value = g_oMap.mapDatapoints[z].locValue;
											field = g_oMap.dashboard.dpList[index].field;
											bContinue = true;
											if(g_oMap.dashboard.dpList[index].field !== "") {
												value = mapReadFieldValue(value, g_oMap.dashboard.dpList[index].field);
												bContinue = value.valid;
												if(bContinue)
													value = value.data;
											}
											if(bContinue) {
												if(value !== null) 
													g_oMap.dashboard.dpList[index].scaleValue = value;
											}
										}
									}
								}
							}
						}
					}
				}
				catch {}
			}
		}
		for(i=0; i < g_oMap.dashboard.dpList.length; i++)
		{
			if(g_oMap.dashboard.dpList[i].displayType === "l5d1") {
				//multiple UI elements for table row
				obj = {};
				obj.i = i;
				obj.dashboardType = g_oMap.dashboard.dpList[i].displayType;
				obj.deviceName = g_oMap.dashboard.dpList[i].deviceName;
				g_oMapSpecialDevice.push(JSON.parse(JSON.stringify(obj)));
				bContinue3 = false;
			}
			else if(g_oMap.dashboard.dpList[i].displayType !== "ts") {
				label = "";
				if(typeof g_oMap.dashboard.dpList[i].label !== "undefined")
					label = g_oMap.dashboard.dpList[i].label;
				if(label === "") {
					label = g_oMap.dashboard.dpList[i].datapointName;
				}
				name = "";
				if(typeof g_oMap.dashboard.dpList[i].deviceTypeStr !== "undefined") {
					if(g_oMap.dashboard.dpList[i].deviceTypeStr !== "")
						name = g_oMap.dashboard.dpList[i].deviceTypeStr;
				}
				content += "<tr>";
				content += mapAddMapDashboardDpCustomControlCreateDpHtml(i, g_oMap.dashboard.dpList[i].dpQualifier);
				content += "</tr>";
			}
		}
		if(g_oMap.dashboard.dpList.length > 0)
			content += "</table>";
		content += `</div>`;
		content += `</div>`

	}
	catch(err) 
	{
		var errStr = err.toString();
		content = "";
	}
	return content;
}
function mapAddMapDashboardDpCustomControlCreateDpHtml(index, dpQualifier) {
	try {
		var i, z;
		var content = "", content1 = "", field = "", tablePaneContent = "", displayId, name, value;
		var bShowTitle = true, bContinue;
		var g_bDashboardTableReadOnly = true;
		
		if(index === null)
			return "<td></td><td></td>";
		if(index >=  g_oMap.dashboard.dpList.length)
			return "<td></td><td></td>";
		if(g_oMap.dashboard.dpList[index].dpQualifier === dpQualifier) {
			name = g_oMap.dashboard.dpList[index].deviceName;
			content += "<td ";
			if(g_oMap.dashboard.bClickToDevice)
				content += " title=\"" + name + "\r\n\r\nClick to go to device\" onclick=\"mapShowDevice('" + name + "',-1)\"";
			else if(bShowTitle && (name !== ""))
				content += " title=\"" + name + "\""
			g_iMapDisplayIndex ++;
			displayId = g_iMapDisplayIndex;
			g_oMap.dashboard.dpList[index].displayId = displayId;
			
			content += " class=\"mapdashboarddeviceNametd\">" + g_oMap.dashboard.dpList[index].label + "</td><td style=\"display:flex\"><div id=\"dashboardDpDivValue\" style=\"display:flex\">";
			try {
				if(g_oMap.dashboard.dpList[index].mapDatapointsIndex !== -1) {
					if(g_oMap.dashboard.dpList[index].mapDatapointsIndex < g_oMap.mapDatapoints.length) {
						z = g_oMap.dashboard.dpList[index].mapDatapointsIndex;
						if(typeof g_oMap.mapDatapoints[z].locValue !== "undefined") {
							if(g_oMap.mapDatapoints[z].locValue !== null) {
								value = g_oMap.mapDatapoints[z].locValue;
								field = g_oMap.dashboard.dpList[index].field;
								bContinue = true;
								if(g_oMap.dashboard.dpList[index].field !== "") {
									value = mapReadFieldValue(value, g_oMap.dashboard.dpList[index].field);
									bContinue = value.valid;
									if(bContinue)
										value = value.data;
								}
							}
							else {
								value = null;
								bContinue = true;
							}
							if(bContinue) {
								if(g_oMap.dashboard.dpList[index].displayType === "r") {
									if(value !== null) {
										if(typeof g_oMap.dashboard.dpList[index].function !== "undefined") { //if(g_oMap.dashboard.dpList[i].bFunction) {
											if(g_oMap.dashboard.dpList[index].function === "cf") {
												value = mapConvertTemperature(0,value,g_oMap.dashboard.dpList[index].precision);
											}
											else if(g_oMap.dashboard.dpList[index].function === "fc") {
												value = mapConvertTemperature(1,value,g_oMap.dashboard.dpList[index].precision);
											}
										}
										else if( g_oMap.dashboard.dpList[index].precision !== -1) {
											if(typeof value === "number")
												value = mapDashboardNumToFixedLength(value,  g_oMap.dashboard.dpList[index].precision);
										}
									}
									tablePaneContent += "<div id=\"dashboardLocalValue_" + g_iMapDisplayIndex +  "\" style=\"display:inline-block\">";
									if(value !== null)
										tablePaneContent += value;
									tablePaneContent += "</div>";
									g_oMap.dashboard.dpList[index].bValueAdded = true;
									
								}
								else if(g_oMap.dashboard.dpList[index].displayType === "l2") {
									// led binary
									tablePaneContent += '<span id="dashboardLocalValueSwitch_' + displayId + '"'; 
									if(value !== null) {
										g_oMap.dashboard.dpList[index].bNumber = false;
										g_oMap.dashboard.dpList[index].bBoolean = false;
										if(typeof value === "number")
											g_oMap.dashboard.dpList[index].bNumber = true;
										else if(typeof value === "boolean")
											g_oMap.dashboard.dpList[index].bBoolean = true;
										

										if(g_oMap.dashboard.dpList[index].bNumber 
											|| (g_oMap.dashboard.dpList[index].bBoolean && (typeof value === "number"))) {
											if(value === 0) {
												tablePaneContent += ' class="ledDotOff"';
												if(g_oMap.dashboard.dpList[index].backgroundColor !== ""){
													tablePaneContent += " style=\"background-color:" + g_oMap.dashboard.dpList[index].backgroundColor + "\"";
												}
											}
											else {
												tablePaneContent += ' class="ledDotOn"';
												if(g_oMap.dashboard.dpList[index].color !== "")
													tablePaneContent += " style=\"background-color:" + g_oMap.dashboard.dpList[index].color + "\"";
											}
										}
										else if(g_oMap.dashboard.dpList[index].bBoolean) {
											
											if(Value === 1) {
												tablePaneContent += ' class="ledDotOn"';
												if(g_oMap.dashboard.dpList[index].color !== ""){
													tablePaneContent += " style=\"background-Color:" +g_oMap.dashboard.dpList[index].color + "\"";
												}
											}
											else {
												tablePaneContent += ' class="ledDotOff"';
												if(g_oMap.dashboard.dpList[index].backgroundColor !== "")
													tablePaneContent += " style=\"background-color:" + g_oMap.dashboard.dpList[index].backgroundColor + "\"";
											}
											
										}
									}
									tablePaneContent += '></span>';
									tablePaneContent += '</div>';
									g_oMap.dashboard.dpList[index].bValueAdded = true;
								}
								else if((g_oMap.dashboard.dpList[index].displayType === "l3") && (field ===  "")) {
									// Led SNVT_switch value and state
									tablePaneContent += "<div id=\"dashboardSliderSwitch_" +  displayId  + "\" style=\"width:70px\">"
									tablePaneContent += '<span id="dashboardLocalValueSwitch_' + displayId + '"'; 
									if(value === null) {
										
									}
									else if(value.state === 1)
										tablePaneContent += ' class="ledDotOn"';
										if(g_oMap.dashboard.dpList[index].color !== ""){
											tablePaneContent += " style=\"background-Color:" + g_oMap.dashboard.dpList[index].color + "\"";
										}
									else {
										tablePaneContent += ' class="ledDotOff"';
										if(g_oMap.dashboard.dpList[index].backgroundColor !== "")
											tablePaneContent += " style=\"background-color:" + g_oMap.dashboard.dpList[index].backgroundColor + "\"";
										else
											tablePaneContent += " style=\"background-color:transparent\"";
									}
									tablePaneContent += '></span></div>';
									tablePaneContent += '<div id="localValue_' + displayId + '" style="width:30px;">';
									if(value !== null)   
										tablePaneContent += value.toString();
									tablePaneContent += '</div>'; 
																	
									tablePaneContent += '</div>';
									g_oMap.dashboard.dpList[index].bValueAdded = true;
								}
								else if((g_oMap.dashboard.dpList[index].displayType === "l4") && (field ===  "")) {
									tablePaneContent += '<span id="dashboardLocalValueSwitch_' + displayId + '"'; 
									if(value === null) {

									}
									else if(value.state === 1) {
										tablePaneContent += ' class="ledDotOn"';
										if(g_oMap.dashboard.dpList[index].color !== ""){
											tablePaneContent += " style=\"background-Color:" + g_oMap.dashboard.dpList[index].color + "\"";
										}
									}
									else {
										tablePaneContent += ' class="ledDotOff"';
										if(g_oMap.dashboard.dpList[index].backgroundColor !== "")
											tablePaneContent += " style=\"background-color:" + g_oMap.dashboard.dpList[index].backgroundColor + "\"";
										else
											tablePaneContent += " style=\"background-color:transparent\"";
									}
									tablePaneContent += '>';
									tablePaneContent += '</span></div>';
									g_oMap.dashboard.dpList[index].bValueAdded = true;
								}
								else if(g_oMap.dashboard.dpList[index].displayType === "l5") {
									// led binary
									
									if(value === null) {
										g_oMap.dashboard.dpList[index].displayType = "l5_div"; // show unknown square
										tablePaneContent += "<div id=\"dashboardLocalValueSwitchBorder_" + displayId + "\" style=\"width:15px;height:15px;border:1px solid\">";
										tablePaneContent += '<span id="dashboardLocalValueSwitch_' + displayId + '"'; 
										tablePaneContent += '></span>';
										tablePaneContent += '</div>';
									}
									else if(value === 1) {
										tablePaneContent += '<span id="dashboardLocalValueSwitch_' + displayId + '"'; 
										tablePaneContent += ' class="ledDotOff"';
										if(g_oMap.dashboard.dpList[index].backgroundColor !== ""){
											tablePaneContent += " style=\"background-color:" + g_oMap.dashboard.dpList[index].backgroundColor + "\"";
										}
										g_oMap.dashboard.dpList[index].bValueAdded = true;
										tablePaneContent += '></span>';
									}
									else if(value === 0) {
										tablePaneContent += '<span id="dashboardLocalValueSwitch_' + displayId + '"'; 
										tablePaneContent += ' class="ledDotOn"';
										if(g_oMap.dashboard.dpList[index].color !== "")
											tablePaneContent += " style=\"background-color:" + g_oMap.dashboard.dpList[index].color + "\"";
										g_oMap.dashboard.dpList[index].bValueAdded = true;
										tablePaneContent += '></span>';
									}
									else {
										g_oMap.dashboard.dpList[index].displayType = "l5_div"; // show unknown square
										tablePaneContent += "<div id=\"dashboardLocalValueSwitchBorder_" + displayId + "\" style=\"width:15px;height:15px;border:1px solid\">";
										tablePaneContent += '<span id="dashboardLocalValueSwitch_' + displayId + '"'; 
										tablePaneContent += '></span>';
										tablePaneContent += '</div>';
									}
									tablePaneContent += '</div>';
									
								}
								else if(g_oMap.dashboard.dpList[index].displayType === "l5d")  {
                                    // EnOcean Rocker switch - most of the time this is will start out as blank, 
                                    // Led SNVT_switch state only -- e.g., IOX
                                    g_oMap.dashboard.dpList[index].graphicType = 0;
                                    tablePaneContent += "<div id=\"dashboardLocalValueSwitchBorder_" + displayId + "\"";
                                    if(value === null) {
										tablePaneContent += " style=\"width:15px;height:15px;border:1px solid\">";
										tablePaneContent += '<span id="dashboardLocalValueSwitch_' + displayId + '"';
                                        tablePaneContent += ' class="ledDotUnknown"';
                                    }
                                    else if(value === 2) {
										tablePaneContent += " style=\"width:15px;height:15px;border:1px solid\">";
										tablePaneContent += '<span id="dashboardLocalValueSwitch_' + displayId + '"';
                                        tablePaneContent += ' class="ledDotUnknown"';
										g_oMap.dashboard.dpList[index].bValueAdded = true;
                                    }
                                    else if(value === 0) {
										tablePaneContent += '<span id="dashboardLocalValueSwitch_' + displayId + '"';
                                        tablePaneContent += ' class="ledDotOn"';
                                        if(g_oMap.dashboard.dpList[index].color !== ""){
                                            tablePaneContent += " style=\"background-Color:" + g_oMap.dashboard.dpList[index].color + "\"";
                                        }
										g_oMap.dashboard.dpList[index].bValueAdded = true;
                                    }
                                    else {
										tablePaneContent += '<span id="dashboardLocalValueSwitch_' + displayId + '"';
                                        tablePaneContent += ' class="ledDotOff"';
                                        if(g_oMap.dashboard.dpList[index].backgroundColor !== "")
                                            tablePaneContent += " style=\"background-color:" + g_oMap.dashboard.dpList[index].backgroundColor + "\"";
                                        else
                                            tablePaneContent += " style=\"background-color:transparent\"";
										g_oMap.dashboard.dpList[index].bValueAdded = true;
                                    }
                                    tablePaneContent += ' title="Left Rocker Switch">';
                                    tablePaneContent += '</span></div>';
                                    g_iMapDisplayIndex ++;
			                        displayId = g_iMapDisplayIndex + "__" + g_oMap.dashboard.dpList[index].deviceName + "/Rocker A/1/Switch A";
                                    g_oMap.dashboard.dpList[index].new_iDisplayIndex = g_iMapDisplayIndex;
                                    tablePaneContent += "<div id=\"dashboardLocalValueSwitchBorder_" + displayId + "\" style=\"width:15px;height:15px;border:1px solid;margin-left:10px\">";
                                    tablePaneContent += '<span id="dashboardLocalValueSwitch_' + displayId + '"'; 
                                    tablePaneContent += ' class="ledDotUnknown"';
                                    tablePaneContent += ' title="Right Rocker Switch">';
                                    tablePaneContent += '</span></div>';
                                    tablePaneContent += '</div>';
                                }
								content += tablePaneContent;
							}
						}
					}
				}
			}
			catch (err) 
			{ var error = err.toString();}
			
			content += "</div><div style=\"display:inline-block\"";
			bContinue = false;
			if(typeof g_oMap.dashboard.dpList[index].scaleDp !== "undefined") {
				if(g_oMap.dashboard.dpList[index].scaleDp !== "") {
					items = g_oMap.dashboard.dpList[index].scaleDp.split(";");
					items[0] = items[0].trim();
					if(items[0] != "") {
						if((typeof g_oMap.dashboard.dpList[index].scaleDisplayId !== "undefined") && (typeof g_oMap.dashboard.dpList[index].scaleDisplayType !== "undefined"))
							bContinue = true;
					}

				}
			}
			if(bContinue) {
				content += " id=\"scale_" + g_oMap.dashboard.dpList[index].scaleDisplayId + "\">"; 
				if(typeof g_oMap.dashboard.dpList[index].scaleValue !== "undefined") {
					if(g_oMap.dashboard.dpList[index].scaleDisplayType === "ts") {
						if(typeof g_oMap.dashboard.dpList[index].scaleValue !== "undefined") {
							if(g_oMap.dashboard.dpList[index].scaleValue !== null) {
								if(typeof g_oMap.dashboard.dpList[index].scaleValue === "number") {
									if(g_oMap.dashboard.dpList[index].scaleValue === 1)
										content += "°F";
									else 
										content += "°C";
								}
								else {
									if(g_oMap.dashboard.dpList[index].scaleValue === "1")
										content += "°F";
									else 
										content += "°C";
								}
							}
						}
					}
				}
				//determine current scale
			}
			else {
				content += ">";
			 	if(typeof g_oMap.dashboard.dpList[index].units !== "undefined") {
					if(g_oMap.dashboard.dpList[index].units !== "") {
						content += "&nbsp;" + g_oMap.dashboard.dpList[index].units;
					}
				}
			}
			content += "</div>";
		}
	}
	catch 
	{ content = "<td></td><td></td>"; }
	return content;
}
function mapAddMapDashboardDpCustomControlCreateDpHtmlAddSpecialHtml() {
	// This get added 
	var i, i1, j, sTemp2;
	try {
	// add ms1 and pg1 entries
				
		for(j=0; j < g_oMapSpecialDevice.length; j++)
		{
			try {
				if(g_oMapSpecialDevice[j].dashboardType === "l5d1") {
					// find match datapoint -- need to assign display indexes for other datapoints in Map dashboard row
					try {
						i = g_oMapSpecialDevice[j].i;
						sTemp2 = g_oMapSpecialDevice[j].deviceName + "/Rocker B/2/Switch B";
						for(i1 = 0; i1 < g_oMap.dashboard.dpList.length; i1++)
						{
							if(g_oMap.dashboard.dpList[i1].pathname === sTemp2) {
								if(g_oMap.dashboard.dpList[i1].displayType === "l5d") {
									g_oMap.dashboard.dpList[i].displayId = g_oMap.dashboard.dpList[i1].new_iDisplayIndex + "__" + g_oMap.dashboard.dpList[i].deviceName + "/Rocker A/1/Switch A";
									g_oMap.dashboard.dpList[i].displayIndex = g_oMap.dashboard.dpList[i1].new_iDisplayIndex;
									break;
								}
							}
						}
					}
					catch {}
				}
			}
			catch {}
		}
	}
	catch {}
}
function maddAddDashboardDpValueUpdate(index) {
	try {

	}
	catch  {}
}

function mapCustomControlToggleFunction(bool) {
  alert(bool)
}
function mapConvertTemperature(mode,value,precision) {
	var result = value;
	try {
		if(typeof value === "string") {

		}
		if(!isNaN(value)) {
			if((precision === null) || (precision === -1)){
				precision = 0;
				if(mode === 1)
					precision = 1;
			}
			if(mode === 0) {
				// c to f
				result = Number( ((1.8 * value) + 32).toFixed(precision));
			}
			else {
				// f to c
				result = Number(( (value - 32) / 1.8).toFixed(precision));
			}
		}
	}
	catch {result = value;}
	return result;
}
function mapDashboardNumToFixedLength(num, decimalPlaces){
	// used for charts
	var numOrig = num;
    
    try {
        if(decimalPlaces === -1)
            return;
        if(typeof num === "number") {
            if(Number.isInteger(num)) {

            }
            else {
                num = Number(num.toFixed(decimalPlaces));
            }
        }
    }
    catch {num = numOrig}
    return num;
}


function addMapMarker(mode, groupIndex, lat,lng, title, id, status, groupNum, deviceObj, marker) {
	//mode: 0=initial, 1= , 2=datapoint update, just get values and return;
	// value: null=no value, value = 0-100, 0
	try {
		var bPopupOpen = false;
		var content = "<div style=\"cursor:pointer\" title=\"" + name + "\r\n\r\nClick to go to show device\" onclick=\"mapShowDevice('" + title + "'," + id + ")\"><span class=\"mapDot\" style=\"background-color:";
		//var content1 = title + "<br><br><button onclick=\"mapShowDevice('" + title + "'," + id + ")\">Show Device</button><button style=\"margin-left:5px\" onclick=\"mapZoomIn('" + title + "'," + id + ", " + groupNum + ")\">Zoom In</button>";
		var value = null;
		var titleContent = title;
		var titleId = title.replace(/-/g,"__").replace(/\[/g,"___").replace(/\]/g,"____");
		var content1 = "\"></span>" + title + "</div>";
		var content2 = "";
		var content3 = "<input type=\"checkbox\" id=\"mapMarkerEnable_" + titleId + "\" style=\"margin-left:10px\" onchange=\"mapMarkerEnable(this,'" + title + "')\"";
		var content4 = "<br><br>lat: " + lat + "<br>long: " + lng;
		var zoomLevel = 1;

		var latLng = null;
		if((groupIndex >= g_oMap.mapDeviceGroupList.length) || (g_oMap.mapDeviceGroupList[groupIndex].lat !== lat) || (g_oMap.mapDeviceGroupList[groupIndex].long !== lng))
			return null;
		
		content2 = "<br><br><button style=\"margin-left:5px\" onclick=\"";
		if(g_oMap.bOnlyWorld)
			content2 += "mapZoomOut()";
		else
			content2 += "mapZoomIn1(1,'',-1, " + groupIndex + ")";
		content2 += "\">Zoom Out</button><button style=\"margin-left:5px\" onclick=\"mapZoomIn('" + title + "'," + id + ", " + groupNum + ")\">Zoom In</button>";

		if(deviceObj.category !== "SC") {
			content2 += "<button style=\"margin-left:5px\" onclick=\"mapTest(this,'" + title + "'," + id + ", " + groupNum + ")";
			if(status === "unprovisioned")
				content2 += " disabled";
			content2 += "\">Test</button>";
		}
		if(status === "unprovisioned")
			content3 += " disabled";
		content3 += ">";


		content1 +=  content2 + content4;
		
		if(deviceObj.programId === "800001230E041005") {
			
			content3 += "<select id=\"mapValueSelect_" + titleId + "\"><option value=\"2\">Scene 2</option><option value=\"1\">Scene 1</option><option value=\"255\">OFF</option>";
			if(status === "unprovisioned")
				content3 += " disabled";
			content3 += "</select><button id=\"mapValueButton_" + titleId + "\" style=\"margin-left:10px\" ";
			content3 += "onclick=\"mapSendNewDatapointValue('" + title + "','" + deviceObj.programId + "'," + deviceObj.groupIndex + "," + deviceObj.groupDeviceIndex + ")\" disabled>Save</button>";
			content2 = content3 + content2 + content4;
			value = deviceObj.datapointsList[0].value;
			titleContent += "<br>value: <div id=\"titlevalue_" + deviceObj.name + "\" style=\"display:inline-block\">" + value + "</div>"
		}
		
		else if((deviceObj.programId === "9FFFFF0501840460") || (deviceObj.programId === "900001153C000405")) {
			
			// show single Lamp controller value 0-100
			content3 += "<select id=\"mapValueSelect_" + titleId + "\"><option value=\"100\">100</option><option value=\"90\">90</option><option value=\"80\">80</option>";
			content3 += "<option value=\"70\">70</option><option value=\"60\">60</option><option value=\"50\">50</option><option value=\"40\">40</option>";
			content3 += "<option value=\"30\">30</option><option value=\"20\">20</option><option value=\"10\">10</option><option value=\"0\">0</option>";
			if(status === "unprovisioned")
				content3 += " disabled";
			content3 += "</select><button id=\"mapValueButton_" + titleId + "\" style=\"margin-left:10px\" ";
			content3 += "onclick=\"mapSendNewDatapointValue('" + title + "','" + deviceObj.programId + "'," + deviceObj.groupIndex + "," + deviceObj.groupDeviceIndex + ")\" disabled>Save</button>";;
			content2 = content3 + content2 + content4;
			value = deviceObj.datapointsList[0].value;
			//value = value.value;
			titleContent += "<br>value: <div id=\"titlevalue_" + deviceObj.name + "\" style=\"display:inline-block\">" + value + "</div>"
		}
		g_oMap.mapDeviceGroupList[groupIndex].titleContent = titleContent;
		if(mode === 1) {
			zoomLevel = map.getZoom();
			latLng = map.getCenter();
			if(marker !== null) {
				if(map.hasLayer(marker)) {
					bPopupOpen = marker.isPopupOpen();
					map.removeLayer(marker);
					marker = null;
				}
			}
		}
		if(status === "smartserver")
			status = "purple";
		if((status === null) || (status === "")) {
			// keep blue
			content += "blue" + content1;
			if(mode === 2)
				return {content:content,icon:mapBlueIcon};
			marker = L.marker([lat,lng], {icon: mapBlueIcon}).bindPopup(content);
		}
		else if (value !== null) {
			if (status === "normal") {
				if(typeof value === "number") {
					if(value === 0) {
						content += "grey" + "\"></span>" + title + "</div><br><span>value: " + value + "</span>" + content2;
						if(mode === 2)
							return {content:content,icon:mapGreyIcon};
						if(mode === 0)
							marker = L.marker([lat,lng], {icon: mapGreyIcon}).bindPopup(content); //.addTo(map).bindPopup(content);
						else {
							
							marker = L.marker([lat,lng], {icon: mapGreyIcon}).bindPopup(content);
						}
					}
					else if (value > 80) {
						content += "yellow" + "\"></span>" + title + "</div><br><span>value: " + value + "</span>" + content2;
						if(mode === 2)
							return {content:content,icon:mapYellowIcon};
						if(mode === 0)
							marker = L.marker([lat,lng], {icon: mapYellowIcon}).bindPopup(content);
						else {
							marker = L.marker([lat,lng], {icon: mapYellowIcon}).bindPopup(content);
						}
					}
					else {
						content += "orange" + "\"></span>" + title + "</div><br><span>value: " + value + "</span>" + content2;
						if(mode === 2)
							return {content:content,icon:mapDarkyellowIcon};
						if(mode === 0)
							marker = L.marker([lat,lng], {icon: mapDarkyellowIcon}).bindPopup(content);
						else {
							marker = L.marker([lat,lng], {icon: mapDarkyellowIcon}).bindPopup(content);
							
						}
					}
				}
			}
			else if (status === "down") {
				if(typeof value === "number") {
					if(value === 0) {
						content += "red" + "\"></span>" + title + "</div><br><span>value: " + value + "</span>" + content2;
						if(mode === 2)
							return {content:content,icon:mapGreyDownIcon};
						marker = L.marker([lat,lng], {icon: mapGreyDownIcon}).bindPopup(content);
					}
					else if (value > 80) {
						content += "red" + "\"></span>" + title + "</div><br><span>value: " + value + "</span>" + content2;
						if(mode === 2)
					return {content:content,icon:mapYellowDownIcon};
						marker = L.marker([lat,lng], {icon: mapYellowDownIcon}).bindPopup(content);
					}
					else {
						// dim
						content += "red" + "\"></span>" + title + "</div><br><span>value: " + value + "</span>" + content2;
						if(mode === 2)
							return {content:content,icon:mapDarkyellowDownIcon};
						marker = L.marker([lat,lng], {icon: mapDarkyellowDownIcon}).bindPopup(content);
					}
				}
			}
			else if (status === "on") {
				content += "yellow" + "\"></span>" + title + "</div><br><span>value: " + value + "</span>" + content2;
				if(mode === 2)
					return {content:content,icon:mapYellowIcon};
				marker = L.marker([lat,lng], {icon: mapYellowIcon}).bindPopup(content);
			}
			else if(status === "off") {
				content += "grey" + "\"></span>" + title + "</div><br><span>value: " + value + "</span>" + content2;
				if(mode === 2)
					return {content:content,icon:mapGreyIcon};
				marker = L.marker([lat,lng], {icon: mapGreyIcon}).bindPopup(content);
			}
			else if (status === "dim") {
				// dim
				content += "#ffffbf" + "\"></span>" + title + "</div><br><span>value: " + value + "</span>" + content2;
				if(mode === 2)
					return {content:content,icon:mapPaleyellowIcon};
				marker = L.marker([lat,lng], {icon: mapPaleyellowIcon}).bindPopup(content);
			}
			else {
					// keep blue
				content += "blue" + "\"></span>" + title + "</div><br><span>value: " + value + "</span>" + content2;
				if(mode === 2)
					return {content:content,icon:mapBlueIcon};
				marker = L.marker([lat,lng]).bindPopup(content);
			}	
		}
		else if (status === "normal") {
			content += "lawngreen" + content1;
			if(mode === 2)
				return {content:content,icon:mapGreenIcon};
			marker = L.marker([lat,lng], {icon: mapGreenIcon}).bindPopup(content);
		}
		else if (status === "down") {
			content += "red" + content1;
			if(mode === 2)
				return {content:content,icon:mapRedIcon};
			marker = L.marker([lat,lng], {icon: mapRedIcon}).bindPopup(content);
		}
		else if (status === "on") {
			content += "lawngreen" + content1;
			if(mode === 2)
				return {content:content,icon:mapYellowIcon};
			marker = L.marker([lat,lng], {icon: mapYellowIcon}).bindPopup(content);
		}
		else if (status === "off") {
			content += "grey" + content1;
			if(mode === 2)
				return {content:content,icon:mapGreyIcon};
			marker = L.marker([lat,lng], {icon: mapGreyIcon}).bindPopup(content);
		}
		else if (status === "orange") {
			content += status + content1;
			if(mode === 2)
				return {content:content,icon:mapOrangeIcon};
			marker = L.marker([lat,lng], {icon: mapOrangeIcon}).bindPopup(content);
		}
		else if (status === "paleyellow") {
			content += status + content1;
			if(mode === 2)
				return {content:content,icon:mapPaleyellowIcon};
			marker = L.marker([lat,lng], {icon: mapPaleyellowIcon}).bindPopup(content);
		}
		else if (status === "darkyellow") {
			content += status + content1;
			if(mode === 2)
				return {content:content,icon:mapDarkyellowIcon};
			marker = L.marker([lat,lng], {icon: mapDarkyellowIcon}).bindPopup(content);
		}
		else if (status === "pink") {
			content += status + content1;
			if(mode === 2)
				return {content:content,icon:mapPinkIcon};
			marker = L.marker([lat,lng], {icon: mapPinkIcon}).bindPopup(content);
		}
		else if (status === "darkgrey") {
			content += status + content1;
			if(mode === 2)
				return {content:content,icon:mapDarkgreyIcon};
			marker = L.marker([lat,llng], {icon: mapDarkgreyIcon}).bindPopup(content);
		}
		else if (status === "cyan") {
			content += status + content1;
			if(mode === 2)
				return {content:content,icon:mapCyanIcon};
			marker = L.marker([lat,lng], {icon: mapCyanIcon}).bindPopup(content);
		}
		else if (status === "purple") {
			content += status + content1;
			if(mode === 2)
				return {content:content,icon:mapPurpleIcon};
			marker = L.marker([lat,lng], {icon: mapPurpleIcon}).bindPopup(content);
		}
		else if (status === "black") {
			content += status + content1;
			if(mode === 2)
				return {content:content,icon:mapBlackIcon};
			marker = L.marker([lat,lng], {icon: mapBlackIcon}).bindPopup(content);
		}
		else if (status === "brown") {
			content += status + content1;
			if(mode === 2)
				return {content:content,icon:mapBrownIcon};
			marker = L.marker([lat,lng], {icon: mapBrownIcon}).bindPopup(content);
		}
		else {
					// keep blue
			content += "blue" + content1;
			if(mode === 2)
				return {content:content,icon:mapBlueIcon};
			marker = L.marker([lat,lng], {icon: mapBlueIcon}).bindPopup(content);
		}
		
		if(mode === 2)
			return {content:null,icon:null};

		if(g_oMap.options.bShowAllTooltips)
			marker.bindTooltip(titleContent, {permanent: true});
		else 
			marker.bindTooltip(titleContent);
		
		if(bPopupOpen)
			marker.openPopup();
		if(mode === 1) {
			map.setZoomAround([latLng.lat, latLng.lng], zoomLevel);
		}
		//layers.push(marker);
		if(deviceObj !== null) {
			if(g_sDeviceWithPopupOpen === deviceObj.name) {
				marker.openPopup();
			}
			if(deviceObj.category === "SC") {
				if(g_mapDeviceSmartServerLayerGroup === null) {
					g_mapDeviceSmartServerLayerGroup = L.layerGroup();
				}
				if(!g_oControlLayerAddedToMap.bSmartServerDevices)
					g_oControlLayerAddedToMap.bSmartServerDevicesNeedToAdd = true;
				g_mapDeviceSmartServerLayerGroup.addLayer(marker);
				g_oMap.mapDeviceGroupList[groupIndex].sLayerGroupName = "smartserver"; //only set to a name if a single device in group or only one device matches criteria (like up) in group
				

			}
			else if(deviceObj.bLightDevice) {
				if(g_mapDeviceLightLayerGroup === null) {
					g_mapDeviceLightLayerGroup = L.layerGroup();
				}
				if(!g_oControlLayerAddedToMap.bLightDevices && g_oMap.options.bShowLightDevices)
					g_oControlLayerAddedToMap.bLightDevicesNeedToAdd = true;
				if(deviceObj.status === "normal") {
					if(!g_oControlLayerAddedToMap.bUpDevices && g_oMap.options.bShowUpDevices)
						g_oControlLayerAddedToMap.bUpDevicesNeedToAdd = true;
				}
				else if((deviceObj.status === "down") || (deviceObj.status === "suspect")) {
					if(!g_oControlLayerAddedToMap.bDownDevices && g_oMap.options.bShowDownDevices)
						g_oControlLayerAddedToMap.bDownDevicesNeedToAdd = true;
				}
				else if(deviceObj.status === "unprovisioned") {
					if(!g_oControlLayerAddedToMap.bUnprovisionedDevices && g_oMap.options.bUnprovisionedDevices)
						g_oControlLayerAddedToMap.bUnprovisionedDevicesNeedToAdd = true;
				}
				g_mapDeviceLightLayerGroup.addLayer(marker);
				g_oMap.mapDeviceGroupList[groupIndex].sLayerGroupName = "light";
			}
			else if(deviceObj.status === "unprovisioned") {
				if(g_mapDeviceUnprovisionedLayerGroup === null) {
					g_mapDeviceUnprovisionedLayerGroup = L.layerGroup();
				}
				if(!g_oControlLayerAddedToMap.bUnprovisionedDevices && g_oMap.options.bShowUnprovisionedDevices)
					g_oControlLayerAddedToMap.bUnprovisionedDevicesNeedToAdd = true;
				g_mapDeviceUnprovisionedLayerGroup.addLayer(marker);
				g_oMap.mapDeviceGroupList[groupIndex].sLayerGroupName = "unprovisioned";
				
			}
			else if((deviceObj.status === "down") || (deviceObj.status === "suspect")) {
				if(g_mapDeviceDownLayerGroup === null) {
					g_mapDeviceDownLayerGroup = L.layerGroup();
					if(g_oControlLayerAddedToMap.bDownDevices)
						g_oControlLayerAddedToMap.bDownDevicesNeedToAdd = true;
				}
				if(!g_oControlLayerAddedToMap.bDownDevices && g_oMap.options.bShowDownDevices)
					g_oControlLayerAddedToMap.bDownDevicesNeedToAdd = true;
				g_mapDeviceDownLayerGroup.addLayer(marker);
				g_oMap.mapDeviceGroupList[groupIndex].sLayerGroupName = "down";
				
			}
			else if(deviceObj.status === "normal") {
				if(g_mapDeviceUpLayerGroup === null) {
					g_mapDeviceUpLayerGroup = L.layerGroup();
				}
				if(!g_oControlLayerAddedToMap.bUpDevices && g_oMap.options.bShowUpDevices)
					g_oControlLayerAddedToMap.bUpDevicesNeedToAdd = true;
				g_mapDeviceUpLayerGroup.addLayer(marker);
				g_oMap.mapDeviceGroupList[groupIndex].sLayerGroupName = "up";
					
			}
			else {
				if(g_mapDeviceUnprovisionedLayerGroup === null) {
					g_mapDeviceUnprovisionedLayerGroup = L.layerGroup();
				}
				if(!g_oControlLayerAddedToMap.bUnprovisionedDevices && g_oMap.options.bShowUnprovisionedDevices)
					g_oControlLayerAddedToMap.bUnprovisionedDevicesNeedToAdd = true;
				g_mapDeviceUnprovisionedLayerGroup.addLayer(marker);
				g_oMap.mapDeviceGroupList[groupIndex].sLayerGroupName = "unprovisioned";
				
			}
		}
	}
	catch(err) {
		alert("addmarker error: \r\n" + err.toString()); 
		marker = null;
	}
	return marker;
}
function addMapCircle(lat,long, title) {
	try {
		var content = title + "<br><br><button onclick='showContext(\"" + title + "\")'>Show Device</button>";
		var marker = null;
		
			marker = L.circle([lat,long], {
				color: 'red',
				fillColor: '#f03',
				fillOpacity: 0.5,
				radius: 100
			}).addTo(map).bindPopup(content);

		marker.bindTooltip(title);
		//layers.push(marker);
	}
	catch(err) {alert("addmarker error: \r\n" + err.toString()); marker = null;}
	return marker;
}
function addMapCircleMarker(lat,lng, title, contextPath, color, fillColor, count, content1) {
	try {
		var content = "";
		var marker = null;
		var label = null;
		var radius = 14;
		content = title;
		if(count > 1) {
			content += count + " devices";
			if((content1 !== null) && (content1 !== "")) 
				content += "<br><br>" + content1;
			//content += "<br><br><button onclick='showContext(\"" + title + "\")'>Show Device</button>";
			radius = 20;
		}
		
		content += "<br><br>lat: " + lat + "<br>long: " + lng;
		
		
		if(color !== null) {
		}
		else if((status === null) || (status === "")) {
			// keep blue
			color = "blue";
		}
		else if (status === "normal")
			color = "green";
		else if (status === "down")
			color = "red";
		else if (status === "on")
			color = "yellow";
		else if (status === "off")
			color = "grey";
		else if (status === "orange")
			color = status;
		else if (status === "paleyellow")
			color = status;
		else if (status === "darkyellow")
			color = status;
		else if (status === "pink")
			color = status;
		else if (status === "darkgrey")
			color = status;
		else if (status === "cyan")
			color = status;
		else if (status === "purple")
			color = status;
		else if (status === "brown")
			color = status;
		else {
			// keep blue
			color = "blue";
		}

		if((fillColor === null) || (fillColor === ""))
			fillColor = '#f03';
		/* marker = L.circle([lat,lng], {
				color: color,
				fillColor: '#f03',
				fillOpacity: 0.5,
				radius: 3
			}).addTo(map).bindPopup(content);
			*/
		marker = L.circleMarker([lat,lng], {
				color: color, /*border color */
				fillColor: fillColor, /*'#f03', fill color '#f03'*/
				fillOpacity: 0.5,
				radius: radius
			}).bindPopup(content);	
		
		if(count > 1) {
		/*
			label = map.addLayer(new L.Label({ // label.addTo(map) is not implemented.
					noHide: true, // Force label to be shown permanently.
					offset: [6, -15] // Counter-act label CSS styling.
				}).setContent(count).setLatLng([
					lat,
					lng + marker._getLngRadius()
			]));
			*/
			marker.bindTooltip(count.toString(), {
				permanent: true, 
				direction : 'center',
				className: 'label-transparent-tooltip',
				offset: [0, 0]});
				/*
			
			lat += 0.000005;
			lng -= 0.000005;
			
			label = L.marker([lat,lng], {
				icon: L.divIcon({
					className: 'maplabel-icon',
					html: count
				})
			});

			label.addTo(map).bindPopup(content);
			//label = L.[datatype]([lat,Lng]).bindLabel(count, { noHide: true }).addTo(map).showLabel(); 
			//marker.bindLabel(count,{noHide: true}).showLabel(); */
		}
		else
			marker.bindTooltip(title);
		//layers.push(marker);
		//layers.push(label);
	}
	catch(err) {alert("addmarker error: \r\n" + err.toString()); marker = null;}
	
	return marker;
}
function removePx(str) {
	var result = 0;
	var iPtr;
	try {
		if(typeof str === "number") 
			result = str;
		else if(typeof str === "string")  {
			iPtr = str.indexOf(px);
			if(iPtr !== -1)
				result = str.substring(0,iPtr);
			if(!isNaN(str)) {
				result = Number(result);
			}
			else 
				result = 0;

		}
	}
	catch {}
	return result;
}

function determineCenterOfRegion(coords) {
	var centerCoord = {};
	var zoomLevel = 1;
	var x1 = 0, x2 = 0, y1 = 0, y2 = 0;
	try {
		centerCoord.lat = 0;
		centerCoord.long = 0;
		centerCoord.zoomLevel = 1;
		centerCoord.x1 = 0;
		centerCoord.x2 = 0;
		centerCoord.y1 = 0;
		centerCoord.y2 = 0;
		if(coords !== null) {
			
			centerCoord.lat = coords[0].lat; // lat
			centerCoord.long = coords[0].long; // lat
			x1 = centerCoord.lat;
			x2 = centerCoord.lat;
			y1 = centerCoord.long; //long
			y2 = centerCoord.long; // long
			for(i=0; i < coords.length; i++)
			{
				if(x1 > coords[i].lat)
					x1 = coords[i].lat; // lat
				if(x2 < coords[i].lat)
					x2 = coords[i].lat; // lat
				if(y1 > coords[i].long)
					y1 = coords[i].long; // lat
				if(y2 < coords[i].long)
					y2 = coords[i].long; // lat
			}
			centerCoord.lat = (x2 - x1) / 2 + x1;
			centerCoord.long = (y2 - y1) / 2 + y1;
			// determine max zoom level
			if(Math.abs(x2 - x1) > Math.abs(y2 - y1)) {
				zoomLevel = Math.abs(x2 - x1);
			}
			else {
				zoomLevel = Math.abs(y2 - y1);
			}
			centerCoord.x1 = x1;
			centerCoord.x2 = x2;
			centerCoord.y1 = y1;
			centerCoord.y2 = y2;
			//alert("CalZoom: " + zoomLevel);
			if((x1 === x2) && (y1 === y2))
				zoomLevel = G_MAPZOOMINMAX;
			else if(zoomLevel > 100)
				zoomLevel = 4;
			else if(zoomLevel > 10)
				zoomLevel = 6;
			else if(zoomLevel > 1)
				zoomLevel = 8;
			else if(zoomLevel > .5)
				zoomLevel = 10;
			else if(zoomLevel > .1)
				zoomLevel = 11;
			else if(zoomLevel > .05)
				zoomLevel = 12;
			else if(zoomLevel > .01)
				zoomLevel = 13;
			else if(zoomLevel > .005)
				zoomLevel = 14;
			else if(zoomLevel > .001)
				zoomLevel = 16;
			else if(zoomLevel > .0005)
				zoomLevel = 17;
			else if(zoomLevel > .0001)
				zoomLevel = 18;
			else 
				zoomLevel = 18;
			centerCoord.zoomLevel = zoomLevel;
		}
	}
	catch (err) { centerCoord.lat = 0; centerCoord.long = 0; centerCoord.zoomLevel = 5;}
	return centerCoord;
}
function mapMarkerEnable(n, deviceName) {
	try {
		var element, element1;
		var titleId;
		if((n === null) || (deviceName === ""))
			return;
		titleId = deviceName.replace(/-/g,"__").replace(/\[/g,"___").replace(/\]/g,"____");
		element = document.getElementById("mapValueButton_" + titleId);
		element1 = document.getElementById("mapValueSelect_" + titleId);
		if((element !== null) || (element1 !== null)) {
			if(n.checked) {
				element.disabled = false;
				element1.disabled = false;
			}
			else {
				element.disabled = true;
				element1.disabled = true;
			}
		}
	}
	catch {}
}
function mapReadFieldValue(data, field1) {
    var result = {};
    var i, field, value;
    var fieldItems = [];
    var bNotFound = true;
    try {
        result.valid = false;
        result.data = data;
        
        if(field1 !== "") {
            fieldItems = field1.split("/");
        
            if(typeof data === "object") {
                value = data;
                for(i=0; i < fieldItems.length; i++)
                {
                    
                    field = fieldItems[i].trim();
                    if(field !== "") {
                        
                        if(typeof value === "object") {  
                            if(value.hasOwnProperty(field)) {
                                if(i=== (fieldItems.length - 1)) {
                                    result.valid = true;
                                    result.data = value[field];
                                    bNotFound = false;
                                    break;
                                }
                                else 
                                    value = value[field]
                            }
                            else { // assume array Array.isArray(value) doesn't work 
                                result.valid = false;
                                break;
                            }
                        }
                    }
                }
            }
        }
    }
    catch {
        result.valid = false;
    }
    return result;
}
function mapRemoveAllMarkers() {
	try {
		var i;
		if(g_oMap === null)
			return;
		
		for(i=0; i < g_oMap.mapParentPolygonList.length; i++)
		{
			if(g_oMap.mapParentPolygonList[i].polygon !== null) {
				map.removeLayer(g_oMap.mapParentPolygonList[i].polygon);
				g_oMap.mapParentPolygonList[i].polygon = null;
			}
		} 
		for(i=0; i < g_oMap.mapPolygonList.length; i++)
		{
			if(g_oMap.mapPolygonList[i].polygon !== null) {
				map.removeLayer(g_oMap.mapPolygonList[i].polygon);
				g_oMap.mapPolygonList[i].polygon = null;
			}
			
		} 
		for(i=0; i < g_oMap.mapChildPolygonList.length; i++)
		{
			if(g_oMap.mapChildPolygonList[i].polygon !== null) {
				map.removeLayer(g_oMap.mapChildPolygonList[i].polygon);
				g_oMap.mapChildPolygonList[i].polygon = null;
			}
		} 
		
		for(i=0; i < g_oMap.mapDeviceGroupList.length; i++)
		{
			if(g_oMap.mapDeviceGroupList[i].marker !== null) {
				try {
					if(g_oMap.mapDeviceGroupList[i].count === 1) {
						if(g_oMap.mapDeviceGroupList[i].marker.isPopupOpen())
							g_sDeviceWithPopupOpen = g_oMap.mapDeviceGroupList[i].devices[0].name;
					}
					map.removeLayer(g_oMap.mapDeviceGroupList[i].marker);
					g_oMap.mapDeviceGroupList[i].marker = null;
				}
				catch {}
			}
		}
	}
	catch {}
	
}
function mapSendNewDatapointValue(deviceName,programId, groupIndex, groupDeviceIndex) {
	// sends user initiated datapoint update to SmartServer
	try {
		var value;
		var element;
		var titleId = deviceName.replace(/-/g,"__").replace(/\[/g,"___").replace(/\]/g,"____");
		if((programId === "800001230E041005") || (programId === "9FFFFF0501840460") || 	(programId === "900001153C000405")) {
			element = document.getElementById("mapValueSelect_" + titleId);
			if(element !== null) {
				value = element.value;
				element.disabled = true;
				element = document.getElementById("mapMarkerEnable_" + titleId)
				if(element !== null)
					element.checked = false;
				element = document.getElementById("mapValueButton_" + titleId)
				if(element !== null)
					element.disabled = true;
				if(typeof value === "string")
					value = Number(value);
				if(((programId === "800001230E041005") && ((value === 1) || (value === 2) || (value === 255))) 
					||  ((programId === "9FFFFF0501840460") || 	(programId === "900001153C000405") && (value >= 0) && (value <= 100))) {
					if((typeof deviceName === "undefined") || (typeof groupIndex === "undefined") || (typeof groupDeviceIndex === "undefined"))
						return;
					if((deviceName === null) || (groupIndex === null) || (groupDeviceIndex === null))
						return;
					if(groupIndex >= g_oMap.mapDeviceGroupList.length)
						return;
					if(groupDeviceIndex >= g_oMap.mapDeviceGroupList[groupIndex].devices.length)
						return;
					if(g_oMap.mapDeviceGroupList[groupIndex].devices[groupDeviceIndex].name === deviceName) {
						const message = JSON.stringify({
							"action": "datapointwrite",
							"deviceName": deviceName,
							"programId":programId,
							"groupIndex": groupIndex,
							"groupDeviceIndex": groupDeviceIndex,
							"value": value
						});
						window.parent.postMessage(message, "*");
					}
				}
			}
		}
	}
	catch (err) 
	{
		var errstr = err.toString();
	}
}
function mapShowContext(mode, contextId) {
	try {
		const message = JSON.stringify({
			"action": "showcontext",
			"id": contextId,
			"name": name
		});
		window.parent.postMessage(message, "*");
	}
	catch {}
}
function mapShowDevice(name, id) {
	try {
		const message = JSON.stringify({
			"action": "showdevice",
			"id": id,
			"name": name
		});
		window.parent.postMessage(message, "*");
	}
	catch {}
}
function mapTest(n, deviceName , id, groupNum) {
	try {
		var offsets = n.getBoundingClientRect();
		const message = JSON.stringify({
			"action": "testdevice",
			"id": id,
			"name": deviceName,
			"groupNum": groupNum,
			"offsets": offsets
		});
		window.parent.postMessage(message, "*");
	}
	catch {}
}
function mapUpdateMarker(mode, decoded) {
	//mode: 0 = initial, 1= datapoint update, 2=device status update
	try {
		var i,j, z, index = -1, selectedIndex, titleContent = "";
		var value = null;
		if(mode === 1) {
			decoded.bUpdateValue = true;
			try {
				index = decoded.index;
				if(decoded.index >= g_oMap.mapDatapoints.length) 
					return;
			}
			catch {return;}
			
		}
		if(decoded.bDevice) {
			try {
			// device on map
				if(((mode === 1) && (g_oMap.mapDatapoints[index].dpQualifier === decoded.datapoint)) || (mode === 2)) {
					/*
					element = document.getElementById("titlevalue_" + g_oMap.mapDatapoints[index].deviceName);
					if(element !== null) {
						element.innerHTML = decoded.value;
					}
					*/
					// determine marker
					if(mode === 1) {
						g_oMap.mapDatapoints[index].value = decoded.value;
						decoded.bUpdateValue = false;
					}
					z = -1;
					for(i=0; i < g_oMap.mapDeviceGroupList.length; i++)
					{
						for(j=0; j < g_oMap.mapDeviceGroupList[i].devices.length; j++)
						{
							if(g_oMap.mapDeviceGroupList[i].devices[j].name === decoded.deviceName) {
								
								if(g_oMap.mapDeviceGroupList[i].count === 1) {
								
									z = j;
									
									/*
									titleContent = decoded.deviceName + "<br>value: <div id=\"titlevalue_" + decoded.deviceName + "\" style=\"display:inline-block\">" + decoded.value + "</div>"
									const selectedMarker = g_oMap.mapDeviceGroupList[i].marker;
									let iconOptions = selectedMarker.options.icon.options; //get existing icon properties
									iconOptions.text = titleContent; //update icon property
									selectedMarker.setIcon(L.BeautifyIcon.icon(iconOptions)); //update marker icon 
									
									*/
									
									if(mode === 1) { //light devices only
										if(g_oMap.mapDeviceGroupList[i].marker !== null) {
											if(g_oMap.mapDeviceGroupList[i].devices[j].datapointsList.length > 0) {
												if(g_oMap.mapDeviceGroupList[i].devices[j].datapointsList[0].dpQualifier === decoded.datapoint) {
													if(g_oMap.mapDeviceGroupList[i].marker.isPopupOpen())
														g_sDeviceWithPopupOpen = g_oMap.mapDeviceGroupList[i].devices[0].name;
													value = decoded.value;
													if(g_oMap.mapDeviceGroupList[i].devices[0].datapointsList[0].field !== "") {
														value = mapReadFieldValue(value,g_oMap.mapDeviceGroupList[i].devices[0].datapointsList[0].field); // g_oMap.dashboard.dpList[i].field);
														if(value.valid)
															value = value.data; 
														else 
															value = null;
													}
													g_oMap.mapDeviceGroupList[i].devices[0].datapointsList[0].value = value;
													//g_mapDeviceLightLayerGroup.removeLayer(g_oMap.mapDeviceGroupList[i].marker);
													obj = addMapMarker(2, i, g_oMap.mapDeviceGroupList[i].lat, g_oMap.mapDeviceGroupList[i].long, g_oMap.mapDeviceGroupList[i].devices[0].name, g_oMap.mapDeviceList[i].id,
															g_oMap.mapDeviceGroupList[i].devices[0].status, i, JSON.parse(JSON.stringify(g_oMap.mapDeviceGroupList[i].devices[0])), g_oMap.mapDeviceGroupList[i].marker);
													if(obj !== null) {
														if((obj.content !== null) || (obj.icon !== null)) {
															g_oMap.mapDeviceGroupList[i].marker.setIcon(obj.icon);
															g_oMap.mapDeviceGroupList[i].marker.unbindTooltip()
															g_oMap.mapDeviceGroupList[i].marker.bindTooltip(g_oMap.mapDeviceGroupList[i].titleContent);
															if(g_oMap.mapDeviceGroupList[i].marker.isPopupOpen()) {
																bPopupOpen = true;
																g_oMap.mapDeviceGroupList[i].marker.closePopup();
															}
															g_oMap.mapDeviceGroupList[i].marker.unbindPopup();
															if(obj.content === "")
																obj.content = "error";
															g_oMap.mapDeviceGroupList[i].marker.bindPopup(obj.content);
															if(bPopupOpen)
																g_oMap.mapDeviceGroupList[i].marker.openPopup();
														}
													}
													//g_oMap.mapDeviceGroupList[i].marker = addMapMarker(1, i, g_oMap.mapDeviceGroupList[i].lat, g_oMap.mapDeviceGroupList[i].long, g_oMap.mapDeviceGroupList[i].devices[0].name, g_oMap.mapDeviceList[i].id,
													//	g_oMap.mapDeviceGroupList[i].devices[0].status, i, JSON.parse(JSON.stringify(g_oMap.mapDeviceGroupList[i].devices[0])), g_oMap.mapDeviceGroupList[i].marker);
												}
											}
										}
									}
									else if (mode === 2) {
										if(g_oMap.mapDeviceGroupList[i].marker.isPopupOpen())
											g_sDeviceWithPopupOpen = g_oMap.mapDeviceGroupList[i].devices[0].name;
										if(decoded.deviceStatus === "provisioning")
											decoded.deviceStatus = "unprovisioned";
										showMapContentRemoveMarkerFromOldLayerGroup(i);
										
										
										g_oMap.mapDeviceGroupList[i].devices[0].status = decoded.deviceStatus;
										showMapContent1(4, mapName, i);
										showMapContentConfigureShowGroupLayer(1); // add any control layer to the map that needed due to group changes
									}

									
									//alert( decoded.deviceName + "\r\nvalue: " + decoded.value);
									
									break;
								}
								else {
									//if(g_oMap.mapDeviceGroupList[i].marker.isPopupOpen())
									//	g_sDeviceWithPopupOpen = g_oMap.mapDeviceGroupList[i].devices[0].name;
									if(decoded.deviceStatus === "provisioning")
										decoded.deviceStatus = "unprovisioned";
									if((mode === 1) || (mode === 2)) {
										showMapContentRemoveMarkerFromOldLayerGroup(i);
										g_oMap.mapDeviceGroupList[i].devices[0].status = decoded.deviceStatus;
										showMapContent1(6, mapName, i);
										showMapContentConfigureShowGroupLayer(1); // add any control layer to the map that needed due to group changes
									}
								}
							}
						}
						if(z !== -1)
							break;
					}
				}
			}
			catch {}
		}
		if(decoded.bDashboard) {
			// datapoint on map dashboard
			if(mode === 1) 
				mapWebSocketDashboardDpUpdate(JSON.parse(JSON.stringify(decoded)));
		}
	}
	catch {}

}
function mapZoomIn(title, id, groupNum) {
	mapZoomIn1(0, title, id, groupNum);
}
function mapZoomIn1(mode, title, id, groupNum) {
	// mode: 0=zoom in, 1=zoom out
	try {
		if(groupNum === -1) {
			alert("TBD");
		}
		else {
			if(typeof g_oMap.mapDeviceGroupList !== "undefined") {
				if(groupNum < g_oMap.mapDeviceGroupList.length) {
					zoomLevel = G_MAPZOOMINMAX;
					if(mode === 1)
						zoomLevel -= 2;
					if(zoomLevel < 0)
						zoomLevel = 1;
					//map.setZoomAround([g_oMap.mapDeviceGroupList[groupNum].lat, g_oMap.mapDeviceGroupList[groupNum].long], zoomLevel);
					map.setView([g_oMap.mapDeviceGroupList[groupNum].lat, g_oMap.mapDeviceGroupList[groupNum].long],zoomLevel);
				}
			}
			//g_oMap.mapDeviceGroupList[groupNum].lat, g_oMap.mapDeviceGroupList[groupNum].long,
		}
	}
	catch {}
}
function mapZoomInShowPopup(title, groupNum) {
	try {
		if(groupNum === -1) {
			alert("TBD");
		}
		else {
			if(typeof g_oMap.mapDeviceGroupList !== "undefined") {
				if(groupNum < g_oMap.mapDeviceGroupList.length) {
					//map.setZoomAround([g_oMap.mapDeviceGroupList[groupNum].lat, g_oMap.mapDeviceGroupList[groupNum].long], G_MAPZOOMINMAX)
					map.setView([g_oMap.mapDeviceGroupList[groupNum].lat, g_oMap.mapDeviceGroupList[groupNum].long],G_MAPZOOMINMAX);
					g_oMap.mapDeviceGroupList[groupNum].marker.openPopup();
				}
			}
			//g_oMap.mapDeviceGroupList[groupNum].lat, g_oMap.mapDeviceGroupList[groupNum].long,
		}
	}
	catch (err) {
		var error = err.toString();
	}
}
function mapContentZoomIn(path, polygonType, i) {
	// polygonType: 0=parent, 1=current, 2 = child
	try {
		
		if((i=== null) && (polygonType !== null) && (path !== null) && (path !== "")) {
			if(polygonType === 0) {
				for(i=0; i < g_oMap.mapParentPolygonList.length; i++)
				{
					if(g_oMap.mapParentPolygonList[i].path === path) {
						if(g_oMap.mapParentPolygonList[i].polygonCoord.length > 2)
							map.fitBounds(g_oMap.mapParentPolygonList[i].polygonCoord);
							//map.fitBounds(g_oMap.mapParentPolygonList[i].polygon.getBounds())
					}
				}
			}
			if(polygonType === 1) {
				for(i=0; i < g_oMap.mapPolygonList.length; i++)
				{
					if(g_oMap.mapPolygonList[i].path === path) {
						if(g_oMap.mapPolygonList[i].polygonCoord.length > 2)
							map.fitBounds(g_oMap.mapPolygonList[i].polygonCoord);
							//map.fitBounds(g_oMap.mapPolygonList[i].polygon.getBounds())
					}
				}
			}
			if(polygonType === 2) {
				for(i=0; i < g_oMap.mapChildPolygonList.length; i++)
				{
					if(g_oMap.mapChildPolygonList[i].path === path) {
						if(g_oMap.mapChildPolygonList[i].polygonCoord.length > 2)
							map.fitBounds(g_oMap.mapChildPolygonList[i].polygonCoord)
						//map.fitBounds(g_oMap.mapChildPolygonList[i].polygon.getBounds())
					}
				}
			}
		}
		else if (i !== -1) {
			if(polygonType === 0) {
				if(g_oMap.mapParentPolygonList[i].polygonCoord.length > 2)
					map.fitBounds(g_oMap.mapParentPolygonList[i].polygonCoord);
					//map.fitBounds(g_oMap.mapParentPolygonList[i].polygon.getBounds())
			}
			if(polygonType === 1) {
				if(g_oMap.mapPolygonList[i].polygonCoord.length > 2)
					map.fitBounds(g_oMap.mapPolygonList[i].polygonCoord);
					//map.fitBounds(g_oMap.mapPolygonList[i].polygon.getBounds())
			}
			if(polygonType === 2) {
				if(g_oMap.mapChildPolygonList[i].polygonCoord.length > 2)
					map.fitBounds(g_oMap.mapChildPolygonList[i].polygonCoord);
					//map.fitBounds(g_oMap.mapChildPolygonList[i].polygon.getBounds())
			}
		}
	}
	catch {}
}
function mapWebSocketDashboardDpUpdate(json) {
	/* json =
			"action": "datapointupdate",
			"datapoint": dpQualifier,
			"value": value1,
			"index": k,
			"bDevice": g_oMap.mapDatapoints[k].bDevice, // light controllers
			"bDashboard": g_oMap.mapDatapoints[k].bDashboard, // map dashboard
			"deviceName": g_oMap.mapDatapoints[k].deviceName,
			"programId": g_oMap.mapDatapoints[k].programId
		*/
    try {  
        var i,j, k,m, v, z, z1, iTemp;
        var datapointQualifier = "", dpQualifier = "", value1 = "", value2, presetValue = "", locValue,locValueStr, valueStr, displayId, origValue, origLocValue;
        var dashboardType, fieldItems, field, bContinue, color, backgroundColor, borderColor, chartIndex, tempValue, tempValue1, tempValue2, sTemp;
        var value;
        var obj, obj1, element, element1;
        var bInitializeChart = false;
        var bDataEntryRemoved = false;
        var d = new Date();
        var currentTimeMs = d.getTime();
        var fieldValue;
		
		if(g_oMap.dashboard === null)
			return;
		if(g_oMap.dashboard.dpList.length === 0)
			return;
        try {
			z = json.index;
			if(json.index >= g_oMap.mapDatapoints.length) 
				return;
		}
		catch {return;}
		if(g_oMap.mapDatapoints[z].dpQualifier !== json.datapoint) {
			z = -1;
			for(i= 0; i < g_oMap.mapDatapoints.length; i ++)
			{
				if(g_oMap.mapDatapoints[i].dpQualifier !== json.datapoint) {
					z = i;
					break;
				}
			}
		}
		if(!g_oMap.mapDatapoints[z].bDashboard)
			return;
	
        for(i= 0; i < g_oMap.dashboard.dpList.length; i ++)
        {
			if(g_oMap.dashboard.dpList[i].dpQualifier === g_oMap.mapDatapoints[z].dpQualifier) {
				try {
					if(json.bUpdateValue) {
						g_oMap.mapDatapoints[z].value = json.value;
						//g_oMap.dashboard.dpList[i].bUpdateValue = false;
					}
					value = json.value;
					bContinue = true;
					if(g_oMap.dashboard.dpList[i].field !== "") {

						value = mapReadFieldValue(value, g_oMap.dashboard.dpList[i].field);
						bContinue = value.valid;
						if(bContinue)
							value = value.data;
					}
					if(bContinue) {
						displayId = g_oMap.dashboard.dpList[i].displayId;
						if(g_oMap.dashboard.dpList[i].displayType === "r") {
							if(typeof g_oMap.dashboard.dpList[i].function !== "undefined") { //if(g_oMap.dashboard.dpList[i].bFunction) {
								if(g_oMap.dashboard.dpList[i].function === "cf") {
									value = mapConvertTemperature(0,value,g_oMap.dashboard.dpList[i].precision);
								}
								else if(g_oMap.dashboard.dpList[i].function === "fc") {
									value = mapConvertTemperature(1,value,g_oMap.dashboard.dpList[i].precision);
								}
							}
							else if( g_oMap.dashboard.dpList[i].precision !== -1) {
								if(typeof value === "number")
									value = mapDashboardNumToFixedLength(value,  g_oMap.dashboard.dpList[i].precision);
							}
							/*
							else if(g_bDashboardMinMaxDecimalPlaces) {
								if(typeof value === "number")
									value= dashboardNumToFixedLength(value, g_iDashboardDecimalPlaces);
							}
							*/
							document.getElementById("dashboardLocalValue_" + displayId).innerHTML = value;
						}
						else if(g_oMap.dashboard.dpList[i].displayType === "ts") {
							element = document.getElementById("scale_" + g_oMap.dashboard.dpList[i].scaleDisplayId);
							if(element !== null) { 
								if(typeof value === "number") {
									if(value === 1)
										element.innerHTML = "°F";
									else 
										element.innerHTML = "°C";
								}
								else {
									if(value === "1")
										element.innerHTML = "°F";
									else 
										element.innerHTML = "°C";
								}
							}
						}
						else if(g_oMap.dashboard.dpList[i].displayType === "l2") {
							borderColor = "";
							color = g_oMap.dashboard.dpList[i].color;
							backgroundColor = g_oMap.dashboard.dpList[i].backgroundColor;
							if(typeof g_oMap.dashboard.dpList[i].borderColor !== "undefined")
								borderColor = g_oMap.dashboard.dpList[i].borderColor;
							document.getElementById("dashboardLocalValueSwitch_" + displayId).style.removeProperty('background-Color');
							if(typeof g_oMap.dashboard.dpList[i].graphicType !== "undefined") {
								z1 = g_oMap.dashboard.dpList[i].graphicType;
								if(z1 === 5) { // small dot (0 = red, 1=green)
									z1 = 1;
									if(value === 0)
										backgroundColor = "red";
									else 
										color = "lawngreen";
								}
								else if(z1 === 6) { // small dot (0 = green, 1=red)
									z1 = 1;
									if(value === 0)
										backgroundColor = "lawngreen";
									else 
										color = "red";
								}
								else if(z1 === 7) { // large dot with border (0 = red, 1=green)
									z1 = 2;
									if(value === 0)
										backgroundColor = "red";
									else 
										color = "lawngreen";
								}
								else if(z1 === 8) { // large dot with border (0 = red, 1=green)
									z1 = 2;
									if(value=== 0)
										backgroundColor = "lawngreen";
									else 
										color = "red";
								}
								else if(z1 === 9) { // large dot with border (0 = red, 1=green)
									z1 = 3;
									if(value === 0)
										backgroundColor = "red";
									else 
										color = "lawngreen";
								}
								else if(z1 === 10) { // large dot with border (0 = red, 1=green)
									z1 = 3;
									if(value === 0)
										backgroundColor = "lawngreen";
									else 
										color = "red";
								}
							}
							else 
								z1 = 4; //floorplan, room,area
							if(typeof value === "number") {
								if(value === 0) {
									if(z1 === 1)
										document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotSmallOff";
									else if(z1 === 2)
										document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotMediumOff";
									else 
										document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotOff";
									if(backgroundColor !== ""){
										document.getElementById("dashboardLocalValueSwitch_" + displayId).style.backgroundColor = backgroundColor;
									}
									if(borderColor !== "") {
										document.getElementById("dashboardLocalValueSwitch_" + displayId).style.borderColor = borderColor;
									}
								}
								else {
									if(z1 === 1)
										document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotSmallOn";
									else if(z1 === 2)
										document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotMediumOn";
									else if(z1 === 3)
										document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotOnBorder";
									else 
										document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotOn";

									if(color !== ""){
										document.getElementById("dashboardLocalValueSwitch_" + displayId).style.backgroundColor = color;
									}
									if(borderColor !== "") {
										document.getElementById("dashboardLocalValueSwitch_" + displayId).style.borderColor = borderColor;
									}
								}
							}
							else if(typeof value === "boolean") {
								if(value === true) {
									if(z1 === 1)
										document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotSmallOn";
									else if(z1 === 2)
										document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotMediumOn";
									else if(z1=== 3)
										document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotOnBorder";
									else 
										document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotOn";
									if(color !== ""){
										document.getElementById("dashboardLocalValueSwitch_" + displayId).style.backgroundColor = color;
									}
									if(borderColor !== "") {
										document.getElementById("dashboardLocalValueSwitch_" + displayId).style.borderColor = borderColor;
									}
								}
								else {
									if(z1 === 1)
										document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotSmallOff";
									else if(z1 === 2)
										document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotMediumOff";
									else 
										document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotOff";
									if(backgroundColor !== ""){
										document.getElementById("dashboardLocalValueSwitch_" + displayId).style.backgroundColor = backgroundColor;
									}
									if(borderColor !== "") {
										document.getElementById("dashboardLocalValueSwitch_" + displayId).style.borderColor = borderColor;
									}
								}
							}
						}
						else if((g_oMap.dashboard.dpList[i].displayType === "l3") || (g_oMap.dashboard.dpList[i].displayType === "l4")) {
							if(g_oMap.dashboard.dpList[i].displayType === "l3") {
								//with edit mode this can be a span or a text box
								element = document.getElementById("dashboardLocalValue_" + displayId);
								if(element !== null) {
									if(element.nodeName === "INPUT")
										element.value = value.value.toString();
									else 
										element.innerHTML = value.value.toString(); //Span or div
								}
							}
							borderColor = "";
							color = g_oMap.dashboard.dpList[i].color;
							backgroundColor = g_oMap.dashboard.dpList[i].backgroundColor;
							if(typeof g_oMap.dashboard.dpList[i].borderColor !== "undefined")
								borderColor = g_oMap.dashboard.dpList[i].borderColor;
							document.getElementById("dashboardLocalValueSwitch_" + displayId).style.removeProperty('background-Color');
							if(value.state === 1) {
								if(g_oMap.dashboard.dpList[i].graphicType === 1)
									document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotSmallOn";
								else if(g_oMap.dashboard.dpList[i].graphicType === 2)
									document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotMediumOn";
								else if(g_oMap.dashboard.dpList[i].graphicType === 3)
									document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotOnBorder";
								else 
									document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotOn";
								//if(g_sSiteDashboardSelected !== "") {
									if(color !== ""){
										document.getElementById("dashboardLocalValueSwitch_" + displayId).style.backgroundColor = color;
									}
									if(borderColor !== "") {
										document.getElementById("dashboardLocalValueSwitch_" + displayId).style.borderColor = borderColor;
									}
							
							}
							else {
								if(g_oMap.dashboard.dpList[i].graphicType === 1)
									document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotSmallOff";
								else if(g_oMap.dashboard.dpList[i].graphicType === 2)
									document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotMediumOff";
								else 
									document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotOff";
								//if(g_sSiteDashboardSelected !== "") {
									if(backgroundColor !== ""){
										document.getElementById("dashboardLocalValueSwitch_" + displayId).style.backgroundColor = backgroundColor;
									}
									if(borderColor !== "") {
										document.getElementById("dashboardLocalValueSwitch_" + displayId).style.borderColor = borderColor;
									}
								
							}
						}
						else if(g_oMap.dashboard.dpList[i].displayType === "l5") {
							if((value === 1) || (value === 0)) {
								borderColor = "";
								color = g_oMap.dashboard.dpList[i].color;
								backgroundColor = g_oMap.dashboard.dpList[i].backgroundColor;
								if(typeof g_oMap.dashboard.dpList[i].borderColor !== "undefined")
									borderColor = g_oMap.dashboard.dpList[i].borderColor;
								document.getElementById("dashboardLocalValueSwitch_" + displayId).style.removeProperty('background-Color');
								if(typeof g_oMap.dashboard.dpList[i].graphicType !== "undefined") {
									z1 = g_oMap.dashboard.dpList[i].graphicType;
									if(z1 === 5) { // small dot (0 = red, 1=green)
										z1 = 1;
										if(value === 1)
											backgroundColor = "red";
										else 
											color = "lawngreen";
									}
									else if(z1 === 6) { // small dot (0 = green, 1=red)
										z1 = 1;
										if(value === 1)
											backgroundColor = "lawngreen";
										else 
											color = "red";
									}
									else if(z1 === 7) { // large dot with border (0 = red, 1=green)
										z1 = 2;
										if(value === 1)
											backgroundColor = "red";
										else 
											color = "lawngreen";
									}
									else if(z1 === 8) { // large dot with border (0 = red, 1=green)
										z1 = 2;
										if(value=== 1)
											backgroundColor = "lawngreen";
										else 
											color = "red";
									}
									else if(z1 === 9) { // large dot with border (0 = red, 1=green)
										z1 = 3;
										if(value === 1)
											backgroundColor = "red";
										else 
											color = "lawngreen";
									}
									else if(z1 === 10) { // large dot with border (0 = red, 1=green)
										z1 = 3;
										if(value === 1)
											backgroundColor = "lawngreen";
										else 
											color = "red";
									}
								}
								else 
									z1 = 4; //floorplan, room,area
								if(typeof value === "number") {
									if(value === 1) {
										if(z1 === 1)
											document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotSmallOff";
										else if(z1 === 2)
											document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotMediumOff";
										else 
											document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotOff";
										if(backgroundColor !== ""){
											document.getElementById("dashboardLocalValueSwitch_" + displayId).style.backgroundColor = backgroundColor;
										}
										if(borderColor !== "") {
											document.getElementById("dashboardLocalValueSwitch_" + displayId).style.borderColor = borderColor;
										}
									}
									else {
										if(z1 === 1)
											document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotSmallOn";
										else if(z1 === 2)
											document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotMediumOn";
										else if(z1 === 3)
											document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotOnBorder";
										else 
											document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotOn";

										if(color !== ""){
											document.getElementById("dashboardLocalValueSwitch_" + displayId).style.backgroundColor = color;
										}
										if(borderColor !== "") {
											document.getElementById("dashboardLocalValueSwitch_" + displayId).style.borderColor = borderColor;
										}
									}
								}
							}
						}
						else if((g_oMap.dashboard.dpList[i].displayType === "l5d") || (g_oMap.dashboard.dpList[i].displayType === "l5d1") || (g_oMap.dashboard.dpList[i].displayType === "l5_div")) {
                                            
							// values not populated yet so add span and change dashboard type to l5 EnOcean rocker switch
							if((value === 0) || (value === 1)) {
								 
								
									color = g_oMap.dashboard.dpList[i].color;
									backgroundColor = g_oMap.dashboard.dpList[i].backgroundColor;
									borderColor = "";
									if(typeof g_oMap.dashboard.dpList[i].borderColor !== "undefined")
										borderColor = g_oMap.dashboard.dpList[i].borderColor;
									element = document.getElementById("dashboardLocalValueSwitchBorder_" + displayId);
									if(element !== null) {
										element.style.border = "none";
									}
									if(value === 0) { // On
										document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotOn";
										if(color !== "") {
											document.getElementById("dashboardLocalValueSpan_" + displayId).style.backgroundColor = color;
										}
									}
									else { // off
										document.getElementById("dashboardLocalValueSwitch_" + displayId).className = "ledDotOff";
										if(backgroundColor !== ""){
											document.getElementById("dashboardLocalValueSwitch_" + displayId).style.backgroundColor = backgroundColor;
										}
										if(borderColor !== "") {
											document.getElementById("dashboardLocalValueSwitch_" + displayId).style.borderColor = borderColor;
										}
									}
									g_oMap.dashboard.dpList[i].displayType = "l5";
							
								
							}
							else {

							}
							 
						}
					}
            
				}
				catch(err) {
					var error = err.toString();
				}
				break;
            }
			
        } //for(i= 0; i < g_oMap.dashboard.dpList.length; i ++)
		
    }
    catch {}
}
function mapZoomOut() {
	try {
		map.setView(new L.LatLng(mapOriginalLat, mapOriginalLng),mapOriginalZoomLevel);
	} 
	catch {}
}
