/********************************************************************************
 * 
 *  dashboardDpList[i].dashboardType: n=table cell, p=power, c=chart only, t=temperature (thermometer svg + chart) 
 * 
 *  showDashboardUi() - Starts dashboard build process
 *  showDashboardUiBuildWebpage() - Builds the Web page after it has all the datalog, datapoint values and SNVT types (dp types)
 * 
 *  dashboardProcessWebSocketDpData() - process datapoint updates
 *  dashboardProcessWriteDpDataUpdateUi() - After writing new value change all UI
 * 
 *  dashboardEditButtonProcess();
 *  
 *  Chart functions: Charts are SVG so need time to load before you can write to it.
 *  addValueToDashboardChartList()
 *  dashboardChartChangeField()
 *  dashboardDetermineChartMinMaxValuesForChart()
 *  dashboardUpdateCharts()
 *  ivInitializeChart1
 *  initializeSvgDashboard - 
 *  ivUpdateChartsDatalogChart3TwoYaxis - builds the chart (navtreesvg.js)
 *  dashboardDetermineDuration() - uses log duration drop down box, g_iDashboardChartMaxDuration
 *  dataLogChartMouseUp() -  zoom panel,where you select zoom window (navtreedatalogchart.js)
 *  chartZoomIntialize() -  zoom panel,where you select zoom window (navtreedatalogchart.js)
 *  datalogChartZoomIn -  zoom panel,where you select zoom window (navtreedatalogchart.js)
 * 
 *  showDashboardDeviceDpListResponse()  - Builds dpList using g_campustags or devicetypesList used for device dashboard  
 *  showDashboardDeviceDpListResponseForSiteDashboard() - Builds dpList using g_campustags or devicetypesList used for site dashboard, region, campus and building 
 * 
 *  var g_dashboardChartList = [] - contains chart information, the chart data is queue that always has new data at the end, 
 *      and when too much data data is removed at the beginning.  This makes it easier to create charts.
 *      g_idashboardChartMaxNumberOfEntries - max number of chart data
 *      g_iDashboardChartMaxDuration - duration in MS shown in chart. 0=all data
 *      When duration is:
 *          unlimited data: startptr=0
 *          when user select duration like (10min) - startptr points to datapoint that equals the duration, or stored datapoint before duration. 
 * 
 *  displayTypes:
 *      n = Is Input element for inputs and span for outputs, readonly used to control whether input or output 
 *      r = read-only span
 *      rf = read-only span but uses conversion formula (typically celsius to fahrenheit or vice versa)
 *      d = drop down (select)
 *      s0 = structured readonly DP span
 *      s1 = structured writeable DP span
 *      s2 = clickable slider swtich for boolean, binary datapoints
 *      l2 = LED for boolean, binary datapoints, l2a = small dot, l2b = large dot with border, 12c= large dot,
 *           12e=small dot (0 = red, 1=green), 12f=small dot (0 = green, 1=red),
 *           12g=large dot with border (0 = red, 1=green), 12h=large dot with border (0 = green, 1=red)
 *           12i=large dot (0 = red, 1=green), 12j=large dot (0 = green, 1=red)
 *      lr2= rectangle LED for boolean, binary datapoints
 *      s3 = Clickable switch for SNVT_swtich.state, uses input element for SNVT_swtich.value 
 *      l3 = LED for SNVT_swtich.state, uses span element for SNVT_swtich.value, , l3a = small dot, l3b = large dot with border
 *      s4 = Clickable switch for SNVT_swtich.state. No html element for SNVT_swtich.value. Clicking then sends {"state":0,"value":0} or {"state":1,"value":100}
 *      l4 = for SNVT_swtich.state. No html element for SNVT_swtich.value., l4a = small dot, l4b = large dot with border
 *      l5 = LED for EnOcean rocker switch: latches last value (only uses value 0 and 1 and ignores 2)
 *      l5_div = used for first L5 datapoint update, used to remove square no value icon
 *      l5d, l5d1 = used to put both rocker switches for double rocker switch on the same row. 
 *      l6 = LED used for value (0-100): 0=grey, 1-80=orange, >80 = yellow
 *      l7 = same as l6 but also show the value
 *      lr4= rectangle LED for SNVT_swtich.state. No html element for SNVT_swtich.value.,
 *      led1 = small colored led, used on image only. colors by value range
 *      rbt=temperature radio button 0=celsius 1=fahreheiht
 *      c = chart element
 *      cr = readonly chart element
 *      g = guage (color change)
 *      g1= guage (gradient)
 *      g2= guage  (sharp gradient)
 *      gc = guage (color change) with chart
 *      gc1= guage (gradient) with chart
 *      gc2= guage (sharp gradient) with chart
 *      gchart= means chart is part of gc, gc1, gc2, tc or lc and these charts are added during the gc processing and after creating the web page the gchart is changed to "c" 
 *      i = image swapper, limited on number of images due to context tags length
 *      m = meter, green, orange, red or green/orange/red only supports three colors green, orange and red. 
 *      m1 = red/orange/green
 *      m2 = red/orange/green/orang/red
 *      ms = FT 6050 MultiSensor shows multiple datapoints per row, ms is the Lamp/0/nvoLampFB
 *          ms1 = FT 6050 MultiSensor assigned to all datapoints on ms other than Lamp/0/nvoLampFB
 *      pb = pushbutton
 *      pg = PulseGen shows multiple datapoints per row, pg is the nvoLamp1
 *          pg1 = PulseGen assigned to all datapoints on pg other than nvoLamp1
 *      sl= slider
 *      t1 = small colored themometer, used on image only. colors by value range
 *      tc = themometer and chart 
 *      lc = Lux guage and chart 
 *     
 *      p = Meter guage and chart - no longer supported
 * 
 *      gc, gc1, gc2 and gchart are changed after setting up in showDashboardUiBuildWebpage()
 *         - gchart
 *
 *  Still need to add
 *      "d" drop down for fields which are enums, dropdown selected needs priority for floorplan changes
 *      sliderChanged() check if field code works
 *
 *	Copyright (C) 2023 EnOcean GmbH.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	EnOcean Example Software License Agreement which is available at
 *	https://enoceanwiki.atlassian.net/wiki/spaces/LON/pages/2425260/Example+Software+License+Agreement.   
 * 
*/

var dashboardDpList = [];
var g_sliderSwitchEditType = 1; //0=change slider knowb color (.sliderSlider use grey background for off), 1 = change to LED (e.g., change between s3 and l3)
var g_bDashboardSupportLogData = true;
var g_oShowDashboardUi = {};
var g_sDashboardTitle = "";
var g_sDashboardTemplateType = "";
var g_sDashboardTemplateTypeProgramId = "";
var g_sDashboardDeviceName = ""; // used for dashboard menu
var g_sDashboardDevice = "";
var g_sDashboardType = "";
var g_sDashboard = "";
var g_idashboardChartType = 0; //0=trend, 1=stepline
var g_dashboardChartList = [];
let g_dashboardIoxList = [];
var g_oDeviceDpList = {}; // keeps copy of all datapoints for charts that have enum datapoints
var powerIndex = 0;
var g_bDashboardNeedToInitializeSvg = true;
var g_iDashboardInitiCount = "0";
var g_bAddDeviceName = false;
var g_bDashboardChartDynamicRange = true;
var g_bDashboardChartUseTimestamp = false;
var g_bDashboardGetDatalog = true; // get data logs from SmartServer
var g_bSiteDashboardGetDatalog = true;
var g_bShowDatalogDuration = true;
let g_idashboardChartMaxNumberOfPointsDefault = 1000; // 0=unlimited
let g_idashboardChartMaxNumberOfEntries = 0; // 0=unlimited
let g_iDashboardChartMaxDuration = 0; // microsec, 0= no limits
var g_bDashboardDataLogGetInProgress = false;
var g_dashboardTimerInterval = 1500; // firefox takes more time to load svg then chrome
var g_dashboardTimerId = 0; // used to initilize svg elements
var g_dashboardDatalogData = [];
let g_dashboardDataLogRequestInfo = {}; // used to save showdashboard info during getting datalog 
let g_bdashboardChartPause = false;
let g_bDashboardPollEnabled = true;
let g_bDashboardUseNewChart = true;
let giDashboardChartLineWidth = 10;
let g_bDashboardOptionsMenu = false;
let g_sDashboardUseNewChartname = "chart9.svg";
let g_bDashboardSupportDisplayMouseToolTip = true;
let g_bDashboardDisplayMouseToolTip = false;
let g_bDashboardDisplayMouseToolTipShowPresets = true;
let g_bDashboardMinMaxUsePadding = false;
let g_bDashboardMinMaxDecimalPlaces = true; //work inprogress
let g_iDashboardDecimalPlaces = 2;  // max number of decimal places if value greater than 1, -1=no limit
var g_DashboardImage = null;
var g_DashboardImageIcons = null; //used to put icons/images on a background image
var g_iDashboardImageWidth = null;
var g_iDashboardImageHeight = null;
var g_iDashboardImageX = null;
var g_iDashboardImageY = null;
var g_oDashboardImageLayout = null;
var g_oDashboardImageLayout = null;
var g_dashboardGetSnvtTypes = [];
var g_dashboardGetSnvtTypes = [];
var g_smartServerImage = null;
var g_smartServerImageWidth = null;
var g_smartServerImageHeight = null;
var g_chartTextColor = "black";
var g_sSliderOffBackgroundColor = "grey"; //"#ccc";
var g_sSliderBackgroundColor = "white";
var g_sSliderDisabledBackgroundColor = "lightgrey";
var g_sSliderOnDiabledBackgroundColor = "#dimGrey";
var g_sPushbuttonOnBackgroundColor = "lawngreen";
var g_sPushbuttonOffBackgroundColor = "white";
var g_sDashboardLedOnColor = "lawngreen";
var g_sDashboardLedOffColor = "green";
var g_sDashboardLedBorderColor = "black";
var g_iDashboardBackButtonContextId = null;
var g_bBuildDashboardDps = true;
var g_bAtLeastOneChartUsed = false;
var g_bDashboardIngoreMaxNumberOfDatapointsAllowed = true;
var g_sSiteDashboardSelected = ""; // when the NavTree Tree Site Dashboard is selected (later may be used for region, campus and building). Used to indicate to show the site dashboard vs device dashboard 
var g_iDashboardPriorityColumn = -1;
var g_sContextContent = "";  // this is only used for context dashboards when the image is already defined at the context level. 
var g_oDashboardLayout = null;
var g_iDashboardTablePriorityColumnShowType = 0; // 0= use visible and hidden,1 = use display inline-block and none, 2= always show
var g_bDashboardTableReadOnly = false;

function dashboardInit() {
    g_dashboardGetSnvtTypes = [];
    g_smartServerImage = null;
    g_smartServerImageWidth = null;
    g_smartServerImageHeight = null;
    g_DashboardImageIcons = null;
    g_iDashboardBackButtonContextId = null;
    g_bBuildDashboardDps = true;
    g_bDashboardIngoreMaxNumberOfDatapointsAllowed = true;
    g_sSiteDashboardSelected = "";
    g_iDashboardPriorityColumn = -1;
    g_sContextContent = "";
    g_bDashboardGetDatalog = true;
    g_bSiteDashboardGetDatalog = true;
    g_bShowDatalogDuration = true;
    g_idashboardChartMaxNumberOfEntries = g_idashboardChartMaxNumberOfPointsDefault;
    g_oDashboardLayout = null;
    g_oDashboardImageLayout = null;
}

function addLux(displayId, label, shortPathname, pathname, value, presetValue) {
    var content = '<div class="group"   style="float:left;display:inline-block;margin-left:10px;margin-top:10px">';
    g_bAtLeastOneChartUsed = true;
    content += '<div style="float:left;display:inline-block">';
    if(g_bDashboardSupportLogData  && g_bDashboardUseNewChart) 
        content += '<object id="thermometer_' + displayId +'" data-izot-min="0" data-izot-max="500" style="height:200px" type="image/svg+xml" data="images/navtree/lightsensorNoborder.svg"></object>';
    else 
        content += '<object id="thermometer_' + displayId +'" data-izot-min="0" data-izot-max="500" style="height:220px" type="image/svg+xml" data="images/navtree/lightsensorNoborder.svg"></object>';
	content += '</div>';
	content += '<div  style="float:left;display:inline-block">';
	content += '<div style="margin-left: 50px">';
    content += '<span style=\"float:left;display:block\">Light Sensor</span>';
    content += "<button id=\"dpValueMenu_" + displayId + "\" style=\"float:right;display:block;margin-right:30px\" onclick=\"_chartMenu(0, this,'" + pathname +  "','" + label +  "','" + displayId + "')\">...</button>";
    content += '<span id=\"chartvalue_' + displayId + '\" style=\"float:right;display:block;margin-right:30px\">lux</span>';
    content += '<span id=\"chartvalue_' + displayId + '\" style=\"float:right;display:block;margin-right:3px\">' + value + '</span>';
    content += '<span id=\"chartpreset_' + displayId + '\" style=\"float:right;display:block;margin-right:30px\">' + presetValue + '</span>';
    content += '</div>';
    if(g_bDashboardSupportLogData && g_bDashboardUseNewChart) {
        /*
        content += '<div style="clear:both; display:block; margin-top:30px; width: 310px; height:168px; text-align:center; z-index: 5; ">';
        content += '<object id="chartSvg_' + pathname + '" type="image/svg+xml" style="width: 300px; height: 150px;" data-izot-textcolor="white" data="images/' + g_sDashboardUseNewChartname + '"></object>';
        content += '</div>';
*/
        content += '<div id="chartParentDiv_' + displayId + '" style="clear:both; display:block; margin-top:30px; text-align:center; z-index: 5; ">';
        content += '<object id="chartSvg_' + displayId + '" type="image/svg+xml" style="height: 170px;" data-izot-textcolor="' + g_chartTextColor + '" data="images/navtree/' + g_sDashboardUseNewChartname + '"></object>';
        content += '</div>';
    }
    else {
        content += '<div id="chartParentDiv_' + displayId + '" style="clear:both; display:block; margin-left: 10px; margin-top:30px; width: 260px; height:218px; text-align:center; z-index: 5; ">';
        content += '<object id="chartSvg_' + displayId + '" type="image/svg+xml" style="width: 250px;height: 200px;" data-izot-textcolor="' + g_chartTextColor + '" data="images/navtree/chart1.svg"></object>';
        content += '</div>';
    }
	content += '<span style="margin-left: 10px">';
    if(g_bAddDeviceName) {
        if(label === "")
            content += shortPathname;
        else
            content += label + " [" + shortPathname + "]";
    }
    else {
        iPtr = shortPathname.indexOf("/")
        if(iPtr !== -1) {
            if((iPtr + 1) < shortPathname.length) {
                if(label === "")
                    content += shortPathname.substr(iPtr + 1);
                else
                    content += label + " [" + shortPathname.substr(iPtr + 1) + "]";
            }
        }
    }
    content += '</span>';
	content += '<br>';
	content += '</div>';
    content += '</div>';
    return content;
}
function addMultiSensor(divName, deviceName) {
    var content = "<div style=\"clear:both;display:block\">";
	try {
		powerIndex = 0;
		var content = "<div style=\"clear:both;display:block\">";
        g_bAtLeastOneChartUsed = true;
		content += "<div  class=\"group\"  style=\"float:left;display:inline-block;margin-left:10px;margin-top:10px\">";
		content += "<div style=\"display: none\" data-izot-type=\"javascript\" data-izot-function=\"sumPower\" data-izot-elementid=\"powersum" + powerIndex + "\" data-izot-chartid=\"chart" + powerIndex + "\"> ";
		content += "<div data-izot-name=\"" + deviceName + "/Lamp/0/nvoValueFb\"></div> ";
		content += "<div data-izot-name=\"" + deviceName + "/Lamp/1/nvoValueFb\"></div>";
		content += "</div>";
		content += "<div style=\"float:left;display:inline-block\">";
		content += "<div style=\"float:left;display:inline-block\">";
		content += "<object id=\"powersum" + powerIndex + "\" data-izot-min=\"0\" data-izot-max=\"150\" style=\"width:160px;height:160px\" type=\"image/svg+xml\" data=\"images/navtree/gauge.svg\"></object>";
		content += "</div>";
		content += "<br>";
		content += "<div style=\"float:left;display:block\">";
		content += "<div  style=\"float:left;display:inline-block; z-index: 9999;margin-left: 20px;\">";
		content += "<object data-izot-type=\"ledswitchsvg\" data-izot-name=\"" + deviceName + "/Lamp/0/nviValue/state\" data-izot-feedback=\"" + deviceName + "/Lamp/0/nvoValueFb/state\"  data-izot-range-data=\"0:#d3ded3,1:red\" data-izot-basecolor =\"#000000\" style=\"width:40px;height:40px\" type=\"image/svg+xml\" data=\"images/navtree/ledSwitchRound.svg\"></object>";
		content += "<br>";
		content += "<span style=\"margin-left: 2px;top:5px\">LED 0</span>";
		content += "</div>";
		content += "<div  style=\"float:left;display:inline-block; z-index: 9999;margin-left: 20px;\">";
		content += "<object data-izot-type=\"ledswitchsvg\" data-izot-name=\"" + deviceName + "/Lamp/1/nviValue/state\" data-izot-feedback=\"" + deviceName + "/Lamp/1/nvoValueFb/state\"  data-izot-range-data=\"0:#d3ded3,1:red\" data-izot-basecolor =\"#000000\" style=\"width:40px;height:40px\" type=\"image/svg+xml\" data=\"images/navtree/ledSwitchRound.svg\"></object>";
		content += "<br>";
		content += "<span style=\"margin-left:2px;top:5px\">LED 1</span>";
		content += "</div>";
		content += "</div>";
		content += "<br><br>";
		content += "<div style=\"float:left;display:inline-block\">";
		content += "<input data-izot-type=\"textfield\" data-izot-name=\"" + deviceName + "/Lamp/0/nviValue/value\" data-izot-feedback=\"" + deviceName + "/Lamp/0/nvoValueFb/value\" size=\"4\" style=\"margin-left:15px\" value=\"-\" >";
		content += "<input data-izot-type=\"textfield\" data-izot-name=\"" + deviceName + "/Lamp/1/nviValue/value\" data-izot-feedback=\"" + deviceName + "/Lamp/1/nvoValueFb/value\" size=\"4\" style=\"margin-left:15px\" value=\"-\" >";
		content += "</div>";
		content += "</div>";
		content += "<div  style=\"float:left;display:inline-block\">";
		content += "<div style=\"margin-left: 50px\">";
		content += "<span style=\"float:left;display:block\">Power</span>";
		content += "</div>";
        
        if(g_bDashboardSupportLogData && g_bDashboardUseNewChart) {
            content += '<div style="clear:both; display:block; margin-top:30px; text-align:center; z-index: 5; ">';
            content += '<object id="chartSvg_' + pathname + '" type="image/svg+xml" style="height: 170px;" data-izot-textcolor="white" data="images/navtree/' + g_sDashboardUseNewChartname + '"></object>';
            content += '</div>';
        }
        else {
            content += "<div style=\"float:left;display:inline-block; margin-top:10px; width: 240px; height:218px; text-align:center; z-index: 5; \" >";
            content += "<object id=\"chart" + powerIndex + "\" type=\"image/svg+xml\" style=\"width: 250px;height: 200px;\"  data-izot-textcolor=\"white\" data=\"images/chart1.svg\"></object>";
            content += "</div>";
        }
		content += "<br>";
		content += "<span style=\"margin-left: 10px\">" + deviceName + "</span>";
		content += "<br>";
		content += "</div>";
		content += "</div>";
		content += "<div class=\"group\"   style=\"float:left;display:inline-block;margin-left:10px;margin-top:10px\">";
		content += "<div style=\"float:left;display:inline-block\">";
		content += "<object data-izot-type=\"thermometer\" data-izot-name=\"\" + deviceName + \"/LightSensor/0/nvoLuxLevel\" data-izot-min=\"0\" data-izot-max=\"500\" style=\"height:220px\" type=\"image/svg+xml\" data=\"images/navtree/lightsensorNoborder.svg\"></object>";
		content += "</div>";
		content += "<div  style=\"float:left;display:inline-block\">";
		content += "<div style=\"margin-left: 50px\">";
		content += "<span style=\"float:left;display:block\">Light Sensor</span><span style=\"float:right;display:block;margin-right:30px\" data-izot-type=\"showvalue\" data-izot-name=\"" + deviceName + "/LightSensor/0/nvoLuxLevel\">--</span>";
		content += "</div>";
        content += "<div style=\"clear:both; display:block; margin-left: 10px; margin-top:30px; width: 260px; height:218px; text-align:center; z-index: 5; \">";
        if(g_bDashboardSupportLogData  && g_bDashboardUseNewChart)
            content += "<object data-izot-type=\"chartsvg\" type=\"image/svg+xml\" style=\"width: 250px;height: 200px;\" data-izot-name=\"" + deviceName + "/LightSensor/0/nvoLuxLevel\" data-izot-dynamicrange=\"true\" data-izot-textcolor=\"white\" data=\"images/navtree/" + g_sDashboardUseNewChartname + "\"></object>";
        else
            content += "<object data-izot-type=\"chartsvg\" type=\"image/svg+xml\" style=\"width: 250px;height: 200px;\" data-izot-name=\"" + deviceName + "/LightSensor/0/nvoLuxLevel\" data-izot-dynamicrange=\"true\" data-izot-textcolor=\"white\" data=\"images/navtree/chart1.svg\"></object>";
		content += "</div>";
		content += "<span style=\"margin-left: 10px\">" + deviceName + "</span>";
		content += "<br>";
			
		content += "</div>";
        content += "</div>";
        if(divName !== "")
		    document.getElementById(divName).innerHTML += content;
		
	}
    catch {}
    return content;
}
function addLightmeter1(displayId, index, displayElementIndex, label, shortPathname, pathname, field, value, alarmWarningLevel) {
    // css Lightsensor - 
    //pathname is programmaticPathname
    // alarmWarningLevel: 0=no alarm, otherwise low error, low warning, high warning and high error
    // dashboardDpList[i].displayElements[t].thermometerObj
    var iPtr,i;
    var content = '<div class="group"   style="float:left;display:inline-block;margin-left:10px;margin-top:10px;min-height:252px">';
    var bContinue = false;
    var displayType,temp;
    var tempContent = "";
    var guageChartdisplayElementIndex = -1;
    var thermometerObj;
    try {
        
        var tempObj = dashboardDpList[index].displayElements[displayElementIndex].thermometerObj;
        if((typeof tempObj.min === "undefined") || (typeof tempObj.max === "undefined"))
            return "";
        if((tempObj.min === null) || (tempObj.max === null))
            return "";
        if(tempObj.min === tempObj.max)
            return "";

        displayType = dashboardDpList[index].displayElements[displayElementIndex].dashboardType;
        
        content += '<div  style="flex">'
       
            
        content += '<div  style="float:left;display:inline-block">';
        // add lightmeter

        content += '<div style="margin-left: 0px;margin-right: 0px;margin-top:2px;">';
        content += '<div  style="display:flex">'
        content += '<div class=\"thermometerLargeValuesDiv\"></div>';
        
        // lightmeter with deg C and deg F 
        content += '<div id="lightmeterDiv_' + displayId + '" class="lightmeterLargeDiv lightmeterLargeFontDiv">';
        content += '<div class="lightmeterLargeBar"></div>';
        content += '<div id="thermometerBar1_' + displayId + '" class="lightmeterLargeBar1"'
        if(tempObj.color !== null)
            content += ' style=\"background-color:' + tempObj.color + '\"'
        content += '></div>';
        
        content += '<div class="lightmeterLargeRight">';
        if(dashboardDpList[index].displayElements[displayElementIndex].units !== "")
            content += dashboardDpList[index].displayElements[displayElementIndex].units;
        content += '</div>';
        content += '<div class="lightmeterLargeScale">'
        temp = (tempObj.max - tempObj.min) / 10;
        content += createThermometerLines(tempObj.min,tempObj.max, temp, 4,"lightmeterLargeLineMinor","lightmeterLargeLineMajor");
        content += '</div>';
        content += '<div class="lightmeterLargeScaleNumber">'
        content += createThermometerNumbers(tempObj.min,tempObj.max,temp,"lightmeterLargeLineNumber");
        content+= '</div>';
        /*
        content += '<div class=\"thermometerLargeValuesDiv\"><span id=\"lightmeter_' + displayId + '\" class=\"lightmeterLargeValuesRight\"></span></div>';*/
        content += '</div>';
        
        
        content += '</div>';
        content += '</div>';
        content += '</div>';

        
        
        try {
            
            displayElementIndex = tempObj.chartDisplayElementIndex;
            

                displayId = dashboardDpList[index].displayElements[displayElementIndex].displayId;
                content += '<div style=\"display:inline-block\">';
                content += addGuageChart (1, displayId, index, displayElementIndex, label, shortPathname, pathname, field, value, alarmWarningLevel, "");
                content += '</div>';
            
        }
        catch {}
        
        content += '</div>';
        
       
        content += '</div>';
    }
    catch {content = ""}
    return content;
}
function addThermometer1(displayId, index, displayElementIndex, label, shortPathname, pathname, field, value, alarmWarningLevel) {
    // css thermometer - 
    //pathname is programmaticPathname
    // alarmWarningLevel: 0=no alarm, otherwise low error, low warning, high warning and high error
    // dashboardDpList[i].displayElements[t].thermometerObj
    var iTemp;
    var content = '<div class="group"   style="float:left;display:inline-block;margin-left:10px;margin-top:10px;min-height:252px">';
    var units = "";
    var bContinue = false;
    var displayType;
    var tempContent = "";
    var guageChartdisplayElementIndex = -1;
    var thermometerObj;
    try {
        
        var tempObj = dashboardDpList[index].displayElements[displayElementIndex].thermometerObj;
        if((typeof tempObj.style === "undefined") || (typeof tempObj.source === "undefined"))
            return "";
        

        displayType = dashboardDpList[index].displayElements[displayElementIndex].dashboardType;
        
        content += '<div  style="display:flex">'
       
            
        content += '<div  style="float:left;display:inline-block">';
        // add thermometer

        content += '<div style="margin-left: 0px;margin-right: 0px;margin-top:2px;">';
        content += '<div  style="display:flex">'
        /*content += '<div class=\"thermometerLargeValuesDiv\"><span id=\"thermometer_c_' + displayId + '\" class=\"thermometerLargeValuesLeft\"></span></div>'; */
        
        // Thermometer with deg C and deg F 
        content += '<div id="thermometer' + displayId + '" class="thermometerLargeDiv thermometerLargeFontDiv">';
        content += '<div class="thermometerLargeBar"></div>';
        content += '<div id="thermometerBar1_' + displayId + '" class="thermometerLargeBar1"></div>';
        // scale on the left hand side of meter
        if((tempObj.style === "cf") || (tempObj.style === "fc")) {
            content += '<div class="thermometerLargeLeft">&deg;C</div>';
            content += '<div class="thermometerLargeCScale">'
            content += createThermometerLines(-30,50, 10, 4,"thermometerLargeCLineMinor","thermometerLargeCLineMajor");
            content += '</div>';
            content += '<div class="thermometerLargeCScaleNumber">'
            content += createThermometerNumbers(-30,50,10,"thermometerMedimumCLineNumber");
            content += '</div>';
            if(tempObj.style === "cf")
                units = "&deg;F";
            else
                units = "&deg;C";
            
        }
        // scale on the right hand side of meter
        if(tempObj.custom) {
            // height is 200, must be major lines are 10%
            content += '<div class="thermometerLargeRight">';
            if(tempObj.style === "c") {
                content += '&deg;C';
                units = "&deg;C";
            }
            else { 
                content += '&deg;F';
                units = "&deg;F";
            }
            content += '</div>';
            content += '<div class="thermometerLargeGScale">';
            iTemp = Math.ceil((tempObj.degMax - tempObj.degMin) / 10)
            content += createThermometerLines(tempObj.degMin,tempObj.degMax, iTemp, 4,"thermometerLargeGLineMinor","thermometerLargeGLineMajor");  
            content += '</div>';
            content += '<div class="thermometerLargeGScaleNumber">'
            content += createThermometerNumbers(tempObj.degMin,tempObj.degMax,iTemp,"thermometerLargeGLineNumber");
            content+= '</div>';
        }
        else if(tempObj.style === "c") {
            content += '<div class="thermometerLargeRight">&deg;C</div>';
            content += '<div class="thermometerLargeCScaleRight">'
            content += createThermometerLines(-30,50, 10, 4,"thermometerLargeCLineMinorRight","thermometerLargeCLineMajorRight");
            content += '</div>';
            content += '<div class="thermometerLargeCScaleNumberRight">'
            content += createThermometerNumbers(-30,50,10,"thermometerMedimumCLineNumberRight");
            content += '</div>';
            units = "&deg;C";
        }
        else {
            content += '<div class="thermometerLargeRight">&deg;F</div>';
            content += '<div class="thermometerLargeFScale">'
            content += createThermometerLines(-20,120, 10, 4,"thermometerLargeFLineMinor","thermometerLargeFLineMajor");
            content += '</div>';
            content += '<div class="thermometerLargeFScaleNumber">'
            content += createThermometerNumbers(-20,120,10,"thermometerLargeFLineNumber");
            content+= '</div>';
        }



        content += '<div id="circle" class="thermometerLargeCirle"></div>';
        content += '</div>';

        content += '<div class=\"';
        if((tempObj.style === "cf") || (tempObj.style === "fc") || (tempObj.bAddOtherTemp && ((tempObj.style === "c") || (tempObj.style === "c"))))
            content += 'thermometerLargeValuesDivTwoValues';
        else 
            content += 'thermometerLargeValuesDiv';
        content += '\">';
        if((tempObj.style === "cf") || (tempObj.style === "fc") || (tempObj.style === "f"))
            content += '<span id=\"thermometer_f_' + displayId + '\" class=\"thermometerLargeValuesRight\"></span>';
        if((tempObj.style === "cf") || (tempObj.style === "fc"))
            content += '<br><div class=\"thermometerLargeDoubleTempExtDiv\"></div>';
        
        if((tempObj.style === "cf") || (tempObj.style === "fc") || (tempObj.style === "c") || (tempObj.bAddOtherTemp && (tempObj.style === "c")))
            content += '<span id=\"thermometer_c_' + displayId + '\" class=\"thermometerLargeValuesRight\"></span>';

        if(tempObj.bAddOtherTemp && (tempObj.style === "c")) {
            content += '<br><div class=\"thermometerLargeDoubleTempExtDiv\"></div>';
            content += '<span id=\"thermometer_f_' + displayId + '\" class=\"thermometerLargeValuesRight\"></span>';
        }   
        content += '</div>';
        content += '</div>';
        
        
        
        content += '</div>';
        content += '</div>';

        
        
        try {
            
            displayElementIndex = tempObj.chartDisplayElementIndex;
            

                                        
                displayId = dashboardDpList[index].displayElements[displayElementIndex].displayId;
                content += '<div style=\"display:inline-block\">';
                content += addGuageChart (1, displayId, index, displayElementIndex, label, shortPathname, pathname, field, value, alarmWarningLevel, units);
                content += '</div>';
            
        }
        catch {}
        
        content += '</div>';
        
       
        content += '</div>';
    }
    catch {content = ""}
    return content;
}
function addThermometerSvg(displayId, label, shortPathname, pathname, value, presetValue) {
    // SVG - no longer works with new browsers
    var content = '<div class="group"   style="float:left;display:inline-block;margin-left:10px;margin-top:10px">';
    g_bAtLeastOneChartUsed = true;
    content += '<div style="float:left;display:inline-block">';
    if(g_bDashboardSupportLogData && g_bDashboardUseNewChart)
        content += '<object id="thermometer_' + displayId +'" data-izot-min="0" data-izot-max="500" style="height:200px" type="image/svg+xml" data="images/navtree/thermometerNoborder.svg"></object>';
    else
        content += '<object id="thermometer_' + displayId +'" data-izot-min="0" data-izot-max="500" style="height:220px" type="image/svg+xml" data="images/navtree/thermometerNoborder.svg"></object>';
	content += '</div>';
	content += '<div  style="float:left;display:inline-block">';
	content += '<div style="margin-left: 50px">';
	content += '<span style=\"float:left;display:block\">Thermometer</span>';
    content += "<button id=\"dpValueMenu_" + displayId + "\" style=\"float:right;display:block;margin-right:30px\" onclick=\"_chartMenu(0, this,'" + pathname +  "','" + label +  "','" + displayId + "')\">...</button>";
    content += '<span id=\"chartvalue_' + displayId + '\" style=\"float:right;display:block;margin-right:30px\">' + value + '</span>';
    content += '<span id=\"chartpreset_' + displayId + '\" style=\"float:right;display:block;margin-right:30px\">' + presetValue + '</span>';
	content += '</div>';
    if(g_bDashboardSupportLogData && g_bDashboardUseNewChart) {
     
/*        content += '<div style="clear:both; display:block; margin-left: 10px; margin-top:30px; height:168px; text-align:center; z-index: 5; ">';
        content += '<object id="chartSvg_' + pathname + '" type="image/svg+xml" style="height: 150px;" data-izot-textcolor="white" data="images/' + g_sDashboardUseNewChartname + '"></object>';
        content += '</div>'; */
        content += '<div id="chartParentDiv_' + displayId + '" style="clear:both; display:block; margin-top:30px; text-align:center; z-index: 5; ">';
        content += '<object id="chartSvg_' + displayId + '" type="image/svg+xml" style="height: 170px;" data-izot-textcolor="' + g_chartTextColor + '" data="images/navtree/' + g_sDashboardUseNewChartname + '"></object>';
        content += '</div>';
    }
    else {
        content += '<div id="chartParentDiv_' + displayId + '" style="clear:both; display:block; margin-left: 10px; margin-top:30px; width: 260px; height:218px; text-align:center; z-index: 5; ">';
        content += '<object id="chartSvg_' + displayId + '" type="image/svg+xml" style="width: 250px;height: 200px;" data-izot-textcolor="' + g_chartTextColor + '" data="images/navtree/chart1.svg"></object>';
        content += '</div>';
    }
	content += '<span style="margin-left: 10px">';
    if(g_bAddDeviceName) {
        if(label === "")
            content += shortPathname;
        else
            content += label + " [" + shortPathname + "]";
    }
    else {
        iPtr = shortPathname.indexOf("/")
        if(iPtr !== -1) {
            if((iPtr + 1) < shortPathname.length) {
                if(label === "")
                    content += shortPathname.substr(iPtr + 1);
                else
                    content += label + " [" + shortPathname.substr(iPtr + 1) + "]";
            }
        }
    }
    content += '</span>';
	content += '<br>';
	content += '</div>';
    content += '</div>';
    return content;
}
function addChart(displayId, index, displayElementIndex, label, shortPathname, pathname, value, presetValue) {
    return addChart1(displayId, index, displayElementIndex, label, shortPathname, pathname, "", [], "", value, presetValue, false,0);
}
function addChart1(displayId, index, displayElementIndex, label, shortPathname, pathname, field, fieldList, defaultField, value, presetValue,bAddWriteButton, alarmWarningLevel) {
    return addChart2(0, displayId, index, displayElementIndex, label, shortPathname, pathname, field, fieldList, defaultField, value, presetValue,bAddWriteButton, alarmWarningLevel, "");
}
function addChart2(iHideBorder, displayId, index, displayElementIndex, label, shortPathname, pathname, field, fieldList, defaultField, value, presetValue,bAddWriteButton, alarmWarningLevel, units) {
    // iHideBorder: 0 = only a chart, 1= guage and chart so add border, 2 = thermometer and chart
    //pathname is programmaticPathname
    // alarmWarningLevel: 0=no alarm, otherwise low error, low warning, high warning and high error
    var iPtr,i;
    var content = '<div class="group"   style="float:left;display:inline-block;margin-left:10px;margin-top:10px">';
    g_bAtLeastOneChartUsed = true;
    if(typeof units === "undefined")
        units = "";
    else if(units === null)
        units = "";
    if(iHideBorder > 0) {
        content = '<div    style="float:left;display:inline-block;">';
    }
	content += '<div  style="float:left;display:inline-block">';
    content += '<div style="margin-left: 50px">';
    if(bAddWriteButton)
        //content += "<button id=\"dpValueMenu_" + displayId + "\" style=\"float:right;display:block;margin-right:30px\" onclick=\"menuDpValue1(0, this, " + index + "," + displayElementIndex + ", 'dpValueMenu_" + displayId + "', '" + pathname + "')\">...</button>";
        content += "<button id=\"dpValueMenu_" + displayId + "\" style=\"float:right;display:block;margin-right:30px\" onclick=\"_chartMenuInputDp(0, this,'" + pathname +  "','" + label +  "','" + displayId + "'," + index + "," + displayElementIndex + ")\">...</button>";
        
    else 
        content += "<button id=\"dpValueMenu_" + displayId + "\" style=\"float:right;display:block;margin-right:30px\" onclick=\"_chartMenu(0, this,'" + pathname +  "','" + label +  "','" + displayId + "')\">...</button>";
    if(units !== "") {
        content += '<span id=\"chartunits2_' + displayId + '\" style=\"float:right;display:block;margin-right:30px\">' + units + '</span>';
        content += '<span id=\"chartvalue_' + displayId + '\" style=\"float:right;display:block;;margin-right:3px\">' + value + '</span>';
    }
    else 
        content += '<span id=\"chartvalue_' + displayId + '\" style=\"float:right;display:block;margin-right:30px\">' + value + '</span>';
    content += '<span id=\"chartpreset_' + displayId + '\" style=\"float:right;display:block;margin-right:30px\">' + presetValue + '</span>';
   
	content += '</div>';
    
    if(g_bDashboardSupportLogData && g_bDashboardUseNewChart) {
        /*
        content += '<div style="clear:both; display:block; margin-left: 10px; margin-top:30px;  height:160px; text-align:center; z-index: 5; ">';
        content += '<object id="chartSvg_' + pathname + '" type="image/svg+xml" style="height: 150px;" data-izot-textcolor="white" data="images/' + g_sDashboardUseNewChartname + '"></object>';
        content += '</div>'; */
        /*
        content += '<div style="clear:both; display:block; margin-top:30px; text-align:center; z-index: 5; ">';
        content += '<object id="chartSvg_' + pathname + '" type="image/svg+xml" style="height: 170px;" data-izot-textcolor="white" data="images/' + g_sDashboardUseNewChartname + '"></object>';
        content += '</div>'; */

        content += '<div id="chartParentDiv_' + displayId + '" style="clear:both; display:block; margin-top:30px; text-align:center; z-index: 5; ">';
        content += '<object id="chartSvg_' + displayId + '" type="image/svg+xml" style="height: 170px;" data-izot-textcolor="' + g_chartTextColor + '" data="images/navtree/' + g_sDashboardUseNewChartname + '"></object>';
        content += '</div>';

    }
    else {
        content += '<div id="chartParentDiv_' + displayId + '" style="clear:both; display:block; margin-left: 10px; margin-top:30px; width: 260px; height:218px; text-align:center; z-index: 5; ">';
        content += '<object id="chartSvg_' + displayId + '" type="image/svg+xml" style="width: 250px;height: 200px;" data-izot-textcolor="' + g_chartTextColor + '" data="images/navtree/chart1.svg"></object>';
        content += '</div>';
    }
    if ((iHideBorder === 0) || (iHideBorder === 2)){
        content += "<div id=\"datapointName_" + displayId + "\"style=\"display:flex;";
        if(alarmWarningLevel !== 0)
            content += "background-color:" + g_alarmColors[alarmWarningLevel];

        content += "\">";
        
        content += "<div id=\"bell_" + displayId + "\" >";
        if(alarmWarningLevel !== 0) {
            content += "<img src=\"images/navtree/Bellred.gif\" alt=\"alarmimage\"onclick=\"alarmMenu(";
            content +=  0; // readonly -- show only alarm state
            content += ",this," + index + "," + displayElementIndex + ",'bell_" + displayId + "','" + pathname + "')\"";
            content += "><span style=\"margin-left:5px\"></span>";
        }
        content += "</div>";
        content += '<span style="margin-left: 10px"';
        if((label !== "") && (g_iShowDashboardDp === 3)) {
            content += ' title="';
            if(g_sSiteDashboardSelected !== "")
                content += shortPathname + '"';
            else {
                iPtr = shortPathname.indexOf("/")
                if(iPtr !== -1) {
                    if((iPtr + 1) < shortPathname.length)
                        content += shortPathname.substr(iPtr + 1) + '"';
                    else
                        content += shortPathname + '"';
                }
                else 
                    content += shortPathname + '"';
            }
        }
        if((g_sSiteDashboardSelected  !== "") && g_bSiteDashboardClickDpPathToDevice) {
            content += " class=\"treeviewName\" onclick=\"getPlanningTreeShowDashboard(0,'Device_" + dashboardDpList[index].deviceId + "','" + dashboardDpList[index].deviceName + "')\"";
        }
        content += '>';
        if(g_bAddDeviceName) {
            if(label === "")
                content += shortPathname;
            else {
                content += label;
                if(g_iShowDashboardDp !== 3) 
                    content += " [" + shortPathname + "]";
            }
        }
        else {
            iPtr = shortPathname.indexOf("/")
            if(iPtr !== -1) {
                if((iPtr + 1) < shortPathname.length) {
                    if(label === "")
                        content += shortPathname.substr(iPtr + 1);
                    else {
                        content += label;
                        if(g_iShowDashboardDp === 3)  {
                            if((g_sSiteDashboardSelected  !== "") && dashboardDpList[index].displayElements[displayElementIndex].bAddDeviceName) {
                                content +=  " [" + dashboardDpList[index].deviceName + "]";
                            }
                        }
                        else
                            content += " [" + shortPathname.substr(iPtr + 1) + "]";
                    }
                }
            }
        }
        content += '</span>';
        content += "</div>";
    }
    content += "<div id=\"datapointfield_" + displayId + "\" style=\"display:none;margin-top:5px"; //"<div id=\"datapointfield_" + displayId + "\" style=\"display:flex;"; 
    content += "\"><br>";
    if(fieldList.length > 0)  
        content += "Field: ";
    content += "<select id=\"datapointfieldselect_" + displayId + "\" ";
    if(fieldList.length === 0) 
        content += " style=\"visibility:hidden\"";
    else
        content += " onchange=\"dashboardChartChangeField(" + index + "," + displayElementIndex + ",'" + displayId + "','datapointfieldselect_" + displayId + "')\"";
    content += ">";
    if(field === "") {
        if(defaultField !== "") {
        defaultField = defaultField.toLowerCase();
            for(i=0; i < fieldList.length; i++)
            {
                content += '<option value=\"' + fieldList[i] + '\""';
                if(defaultField !== "") {
                    if(defaultField === fieldList[i].toLowerCase())
                        content+= ' selected';
                }
                content += '>'+ fieldList[i] + '</option>';
            }
        }
    }
    content += '</select>';
    
    content += '<br>';
    content += '</div>';
    if(iHideBorder === 0)
        content += "<div style=\"display:block;height:3.5px\"></div>"; // only used to make sure chart by itself has a higher height than guagechart, otherwise the table is in the wrong place
	content += '</div>';
    content += '</div>';
    return content;
}
function addGuage1(displayId, index, displayElementIndex, label, shortPathname, pathname, field, value, alarmWarningLevel) {
    //pathname is programmaticPathname
    // alarmWarningLevel: 0=no alarm, otherwise low error, low warning, high warning and high error
    var iPtr,i;
    var content = '<div class="group"   style="float:left;display:inline-block;margin-left:10px;margin-top:10px">';
    var bContinue = false;
    var displayType;
    var tempContent = "";
    var guageChartdisplayElementIndex = -1;
    try {
        
        var tempObj = dashboardDpList[index].displayElements[displayElementIndex].guageObj;
        if((typeof tempObj.guageMin === "undefined") || (typeof tempObj.guageMax === "undefined") || (typeof tempObj.guageColors === "undefined"))
            return "";
        if(tempObj.guageColors.length === 0)
            return "";
        

        displayType = dashboardDpList[index].displayElements[displayElementIndex].dashboardType;
        if(displayType === "gc") {
            content += '<div  style="flex">'
        }
            
        content += '<div  style="float:left;display:inline-block">';
        // add guage

        content += '<div style="margin-left: 20px;margin-right: 20px';
        if(displayType === "gc")
            content += ';margin-top:40px;'
        content += '">';


        content += '<div class="guage">';
        content += '<div class="guageBody">';
        content += '<div id="guageFill_' + displayId + '"'
        if(tempObj.type === 0)
            content += ' class="guageFill"></div>';
        else if(tempObj.type === 1)
            content += ' class="guageFillGradient"></div>';
        else if(tempObj.type === 2)
            content += ' class="guageFillGradientLine"></div>';
        content += '<div id="guageHoleLarge_' + displayId + '" class="guageHoleLarge"></div>';
        content += '<div id="guageneedle_' + displayId + '" class="guageNeedle"></div>';
        content += '<div id="guageHole_' + displayId + '" class="guageHole"></div>'
        content += '</div>';
        content += '</div>';
        content += '<div class="guagevalues">';
        content += '<div id="minValue_' + displayId + '" class="guageMinValue"><div class="guageMinMax">' + tempObj.guageMin + '</div></div>';
        content += '<div id="maxValue_' + displayId + '" class="guageMaxValue"><div class="guageMinMax">' + tempObj.guageMax + '</div></div>';
        content += '</div>';


        content += '</div>';
        if(displayType === "g") {
            content += "<div id=\"datapointName_" + displayId + "\"style=\"display:flex;";
            if(alarmWarningLevel !== 0)
                content += "background-color:" + g_alarmColors[alarmWarningLevel];

            content += "\">";

            content += "<div id=\"bell_" + displayId + "\" >";
            if(alarmWarningLevel !== 0) {
                content += "<img src=\"images/navtree/Bellred.gif\" alt=\"alarmimage\"onclick=\"alarmMenu(";
                content +=  0; // readonly -- show only alarm state
                content += ",this," + index + "," + displayElementIndex + ",'bell_" + displayId + "','" + pathname + "')\"";
                content += "><span style=\"margin-left:5px\"></span>";
            }
            content += "</div>";
            content += '<span style="margin-left: 10px"';
            if((label !== "") && (g_iShowDashboardDp === 3)) {
                content += ' title="';
                if(g_sSiteDashboardSelected  !== "")
                    content += shortPathname + '"';
                else {
                    iPtr = shortPathname.indexOf("/")
                    if(iPtr !== -1) {
                        if((iPtr + 1) < shortPathname.length)
                            content += shortPathname.substr(iPtr + 1) + '"';
                        else
                            content += shortPathname + '"';
                    }
                    else 
                        content += shortPathname + '"';
                }
            }
            if((g_sSiteDashboardSelected  !== "") && g_bSiteDashboardClickDpPathToDevice) {
                content += " class=\"treeviewName\" onclick=\"getPlanningTreeShowDashboard(0,'Device_" + dashboardDpList[index].deviceId + "','" + dashboardDpList[index].deviceName + "')\"";
            }
            content += '>';
            if(g_bAddDeviceName) {
                if(label === "")
                    content += shortPathname;
                else {
                    content += label;
                    if(g_iShowDashboardDp !== 3) 
                        content += " [" + shortPathname + "]";
                }
            }
            else {
                iPtr = shortPathname.indexOf("/")
                if(iPtr !== -1) {
                    if((iPtr + 1) < shortPathname.length) {
                        if(label === "")
                            content += shortPathname.substr(iPtr + 1);
                        else {
                            content += label;
                            if(g_iShowDashboardDp === 3)  {
                                if((g_sSiteDashboardSelected  !== "") && dashboardDpList[index].displayElements[displayElementIndex].bAddDeviceName) {
                                    content +=  " [" + dashboardDpList[index].deviceName + "]";
                                }
                            }
                            else
                                content += " [" + shortPathname.substr(iPtr + 1) + "]";
                        }
                    }
                }
            }
            content += '</span>';
            content += "</div>";
            content += "<div id=\"datapointfield_" + displayId + "\" style=\"display:none;margin-top:5px"; //"<div id=\"datapointfield_" + displayId + "\" style=\"display:flex;"; 
            content += "\"><br>";
            
            
            content += '<br>';
            content += '</div>';
        }
        
        
        content += '</div>';
        if(displayType === "gc") {
            try {
                
                displayElementIndex = tempObj.chartDisplayElementIndex;
                if(dashboardDpList[index].displayElements[displayElementIndex].dashboardType === "gchart") {

                    displayId = dashboardDpList[index].displayElements[displayElementIndex].displayId;
                    content += '<div style=\"display:inline-block\">';
                    content += addGuageChart (0, displayId, index, displayElementIndex, label, shortPathname, pathname, field, value, alarmWarningLevel, "");
                    content += '</div>';
                }
            }
            catch {}
            content += '</div>';
        }
        if(displayType === "gc") {
            content += "<div style=\"display:block\">";
            content += "<div id=\"datapointName_" + displayId + "\"style=\"display:flex;";
            if(alarmWarningLevel !== 0)
                content += "background-color:" + g_alarmColors[alarmWarningLevel];

            content += "\">";

            content += "<div id=\"bell_" + displayId + "\" >";
            if(alarmWarningLevel !== 0) {
                content += "<img src=\"images/navtree/Bellred.gif\" alt=\"alarmimage\"onclick=\"alarmMenu(";
                content +=  0; // readonly -- show only alarm state
                content += ",this," + index + "," + displayElementIndex + ",'bell_" + displayId + "','" + pathname + "')\"";
                content += "><span style=\"margin-left:5px\"></span>";
            }
            content += "</div>";
            content += '<span style="margin-left: 10px"';
            if((label !== "") && (g_iShowDashboardDp === 3)) {
                content += ' title="';
                if(g_sSiteDashboardSelected  !== "")
                    content += shortPathname + '"';
                else {
                    iPtr = shortPathname.indexOf("/")
                    if(iPtr !== -1) {
                        if((iPtr + 1) < shortPathname.length)
                            content += shortPathname.substr(iPtr + 1) + '"';
                        else
                            content += shortPathname + '"';
                    }
                    else 
                        content += shortPathname + '"';
                }
            }
            if((g_sSiteDashboardSelected  !== "") && g_bSiteDashboardClickDpPathToDevice) {
                content += " class=\"treeviewName\" onclick=\"getPlanningTreeShowDashboard(0,'Device_" + dashboardDpList[index].deviceId + "','" + dashboardDpList[index].deviceName + "')\"";
            }
            content += '>';
            if(g_bAddDeviceName) {
                if(label === "")
                    content += shortPathname;
                else {
                    content += label;
                    if(g_iShowDashboardDp !== 3) 
                        content += " [" + shortPathname + "]";
                }
            }
            else {
                iPtr = shortPathname.indexOf("/")
                if(iPtr !== -1) {
                    if((iPtr + 1) < shortPathname.length) {
                        if(label === "")
                            content += shortPathname.substr(iPtr + 1);
                        else {
                            content += label;
                            if(g_iShowDashboardDp !== 3) 
                                content += " [" + shortPathname.substr(iPtr + 1) + "]";
                        }
                    }
                }
            }
            content += '</span>';
            content += "</div>";
            content += "<div id=\"datapointfield_" + displayId + "\" style=\"display:none;margin-top:5px"; //"<div id=\"datapointfield_" + displayId + "\" style=\"display:flex;"; 
            content += "\"><br>";
            
            
            content += '<br>';
            content += "</div>";
            content += "</div>";
        }
        content += '</div>';
    }
    catch {content = ""}
    return content;
}
function addGuageChart (mode,displayId, index, displayElementIndex, label, shortPathname, pathname, field, tempValue, alarmWarningLevel, units) {
    // mode: 0=guageChart, 1=thermostatChart
    var paneContent = "", i = index, t = displayElementIndex;
    var tempValueStr, tempValue, value1, presetValue = "", fieldList, defaultField, bContinue1;
    try {
        pathname = dashboardDpList[i].pathname; //dashboardDpList[i].programmaticPathname;
        shortPathname = dashboardDpList[i].shortPathName;
        if(field !== "")
            shortPathname += "/" + field;
        if(tempValue === null)
            tempValue = dashboardDpList[i].displayElements[t].locValue;
        tempValue = dashboardNumToFixedLength(tempValue, g_iDashboardDecimalPlaces);
        presetValue = "";
        if(field === "") {
            if(dashboardDpList[i].presetValue ===  "")
                presetValue = dashboardDpList[i].presetValue;
        }
        fieldList = [];
        defaultField = "";
        // determine chart displayElement
        if(field === "") {
            if(typeof dashboardDpList[i].snvtType !== "undefined") {
                if(typeof dashboardDpList[i].snvtType !== null) {
                    if(dashboardDpList[i].snvtType.valueType === "OBJECT"){
                        fieldList = createFieldListFromSnvtType(dashboardDpList[i].snvtType);
                        bAtLeastOneChartWithFieldDropdown = true;
                        //fieldList = Object.keys(dashboardDpList[i].value);
                        defaultField = fieldList[0];
                        value1 = readFieldValue(tempValue, defaultField);
                        if(value1.valid)
                            tempValue =  value1.data;
                        else 
                            tempValue = "";
                    }
                }
            }
        }
        
        if(typeof tempValue === "string")
            tempValueStr = tempValue;
        else
            tempValueStr = tempValue.toString();
        bContinue1 = false;
        if(dashboardDpList[i].cat === "in")
            bContinue1 = true;
                       
        paneContent += addChart2(mode + 1, displayId, i, t, label, shortPathname, pathname, field, fieldList, defaultField, tempValueStr, presetValue, bContinue1, alarmWarningLevel, units);
        dashboardDpList[i].displayElements[t].createBrowserGrapic = false;
        if(typeof dashboardDpList[i].value === "object") {
            if(field === "") {
                field = defaultField;
            }
            dashboardDpList[i].displayElements[t].field = field;
        }
        createChartObject(i, t, displayId, pathname, field, tempValue, null, null, true, null, "both");
    }
    catch {}
    return paneContent;
}
function addValueToDashboardChartList(mode, chartIndex, value, origValue, presetValue, timestamp) {
    // mode: needed for enums and strings, 0 same value, 1=new value
    // value: value or field value
    // origValue: mode=0 then null, mode=1 value or full structure value
    try { //fix only have two entries per datapoint value. change last entry if previous value two values are the same
        var i,j, z, obj1, obj, value1;
        var d;
        var lastIndex = g_dashboardChartList[chartIndex].data.length - 1;
        if(mode === 0) {
            if(g_dashboardChartList[chartIndex].data.length > 1) {
                // if structure then value is the field value
                if(isEqual(g_dashboardChartList[chartIndex].data[lastIndex].value, value)) {
                    //if(g_idashboardChartType === 0)
                    //    return;
                    if(isEqual(g_dashboardChartList[chartIndex].data[lastIndex - 1].value, value)) {
                        // just update last entry
                    }
                    else {
                        g_dashboardChartList[chartIndex].data.push(JSON.parse(JSON.stringify(g_dashboardChartList[chartIndex].data[lastIndex])));
                        if(g_dashboardChartList[chartIndex].bStructure)
                            g_dashboardChartList[chartIndex].datalogData.push(JSON.parse(JSON.stringify(g_dashboardChartList[chartIndex].datalogData[lastIndex])));
                        lastIndex++;
                    }
                    
                }
            }
            else {
                g_dashboardChartList[chartIndex].data.push(JSON.parse(JSON.stringify(g_dashboardChartList[chartIndex].data[lastIndex])));
                if(g_dashboardChartList[chartIndex].bStructure)
                    g_dashboardChartList[chartIndex].datalogData.push(JSON.parse(JSON.stringify(g_dashboardChartList[chartIndex].datalogData[lastIndex])));
                lastIndex++;
            }
            g_dashboardChartList[chartIndex].data[lastIndex].timestamp = timestamp; 
            if(g_dashboardChartList[chartIndex].bStructure)
                g_dashboardChartList[chartIndex].datalogData[lastIndex].timestamp = timestamp;
            return;
        }
        else { // new value
            obj1 = {};
            obj1.value = origValue;
            if(presetValue !== "")
                obj1.presetValue = presetValue;
            obj1.timestamp = timestamp;
            d =  new Date(timestamp);
            obj1.localTime = d.toLocaleDateString() + " " + d.toLocaleTimeString();
            if(g_dashboardChartList[chartIndex].bStructure) {
                g_dashboardChartList[chartIndex].datalogData.push(JSON.parse(JSON.stringify(obj1)));
                /*
                if(g_dashboardChartList[chartIndex].field !== "") {
                    value1 = readFieldValue(value, "field");
                        if(value1.valid)
                            value = value1.data;
                }
                */
            }
            obj1.value = value;

            //g_dashboardChartList[chartIndex].chartlabels = "both";
            if(g_dashboardChartList[chartIndex].bEnum || g_dashboardChartList[chartIndex].bString) {
                
                // convert strings and enums
                if(g_dashboardChartList[chartIndex].bEnum) {
                    z = -1;
                    for(j=0; j < g_dashboardChartList[chartIndex].enums.length; j++) {
                        if(value === g_dashboardChartList[chartIndex].enums[j].id) {
                            z = j;
                            break;
                        }
                    }
                    obj1.str = value;
                    if(z !== -1) {
                        obj1.value = g_dashboardChartList[chartIndex].enums[z].value;
                    
                    }
                    else {
                        obj = {};
                        obj.str = value;
                        value1 = 1;
                        if(typeof value === "number") {
                            // check if value matches other values
                            // pick new value to show
                            value1 = value;
                            while(bContinue)
                            {
                                bContinue = false;
                                for(j=0; j < chart.enums.length; j++)
                                {
                                    if(value1 === chart.enums[j].value) {
                                        value1 ++;
                                        bContinue = true;
                                    }
                                }
                            }
                        }
                        // check if value matches other values
                        obj.value = value1;
                        obj1.value = value1;
                        g_dashboardChartList[chartIndex].enums.push(JSON.parse(JSON.stringify(obj)));
                        
                        
                    }
                }
                else if(g_dashboardChartList[chartIndex].bString) {
                    z = -1;
                    for(j=0; j < g_dashboardChartList[chartIndex].strings.length; j++) {
                        if(value === g_dashboardChartList[chartIndex].strings[j].str) {
                            z = j;
                            break;
                        }
                    }
                    obj1.str = value;
                    if(z !== -1) {
                        obj1.value = g_dashboardChartList[chartIndex].strings[z].value;
                        
                    }
                    else {
                        obj = {};
                        obj.str = value;
                        obj.value = g_dashboardChartList[chartIndex].strings.length;
                        obj1.value = obj.value;
                        g_dashboardChartList[chartIndex].strings.push(JSON.parse(JSON.stringify(obj)));
                        
                    
                    }
                }
            }
            g_dashboardChartList[chartIndex].data.push(JSON.parse(JSON.stringify(obj1)));
        }
        
    }
    catch {}
}
function configureDashboardChartsParameters() {
    // this is used to setup the XY lengths for the dashboard based on the chart type
    try {
        
        if(g_bDashboardSupportLogData) {
            if(g_bDashboardUseNewChart) {
                switch(g_sDashboardUseNewChartname) {
                    case "chart1.svg":
                        ivChartXLengthLargeChart = ivChartXYLengthChart1; // chart2
                        ivChartYLengthLargeChart = ivChartXYLengthChart1;
                        break;
                    case "chart2.svg":
                        ivChartXLengthLargeChart = ivChartXLengthLargeChart2; // chart2
                        ivChartYLengthLargeChart = ivChartYLengthLargeChart2;
                        break;
                    case "chart4.svg":
                        ivChartXLengthLargeChart = ivChartXLengthLargeChart2; // chart2
                        ivChartYLengthLargeChart = ivChartYLengthLargeChart2;
                        break;
                    case "chart8.svg":
                    case "chart9.svg":
                        ivChartXLengthLargeChart = ivChartXLengthLargeChart9; // chart8
                        ivChartYLengthLargeChart = ivChartYLengthLargeChart9;
                        break;
                }
            }
        }
    }
    catch {}
}
function dashboardAddTableResize(index, bSomeWithMaxWidthSpecified) {
    var sResult = "<div id=\"tableCol_" + index + "\" class=\"tableResizeDiv\" onmousedown=\"mouseDownTableResizeHandler(event," +  index + "," +  bSomeWithMaxWidthSpecified + ")\"></div>";

    return sResult;
}
function dashboardGetDatalogCheckBox() {
    g_bDashboardGetDatalog = document.getElementById("dashboardGetDatalogCheckbox").checked;
}
function dashboardNumToFixedLength(num, decimalPlaces){
	// used for charts
	var numOrig = num;
    
    try {
        if(decimalPlaces === -1)
            return;
        if(typeof num === "number") {
            if(Number.isInteger(num)) {

            }
            else {
                num = Number(num.toFixed(decimalPlaces));
            }
        }
    }
    catch {num = numOrig}
    return num;
}
function dashboardProcessWebSocketDpData(currentTime, timestamp, json) {
    try {  
        var i,j, k,m, v, z, z1, iTemp;
        var datapointQualifier = "", dpQualifier = "", value1 = "", value2, presetValue = "", locValue,locValueStr, valueStr, displayId, origValue, origLocValue;
        var dashboardType, fieldItems, field, bContinue, color, backgroundColor, borderColor, chartIndex, tempValue, tempValue1, tempValue2, sTemp;
        var value;
        var obj, obj1, element, element1;
        var bInitializeChart = false;
        var bDataEntryRemoved = false;
        var d = new Date();
        var currentTimeMs = d.getTime();
        var fieldValue;
        if(g_bDashboardDataLogGetInProgress)
            return;
        for(i= 0; i < json.length; i ++)
        {
            // Web socket response
            datapointQualifier = ""; value1 = "";
            presetValue = "";
            locValue = "";
            locValueStr = "";
            value = "";
            obj = json[i];
            try {
                datapointQualifier = obj.datapointQualifier;
            }
            catch (err) {}
            try {
                value1 = obj.value
            }
            catch (err) {}
            try {
                if(!(typeof obj.presetValue === "undefined"))  {
                    if(obj.presetValue !== null) {
                        presetValue = obj.presetValue;
                    }
                }	
            } 	catch (err) {}
            try {
                if(!(typeof obj.locValue === "undefined"))  {
                    locValue = json[i].locValue;
                    locValueStr = locValue;
                    if(locValue !== null) {
                        if(typeof locValue === "number") {
                            locValueStr = locValue.toString();
                            json[i].bNumber = true;
                        }
                        else if(typeof locValue === "object") {
                            locValueStr = JSON.stringify(locValue);
                            if(locValueStr.length > 2) {
                                if((locValueStr.charAt(0) === "{") && (locValueStr.charAt(locValueStr.length - 1) === "}")) {
                                    json[i].bStructure = true;
                                    locValueStr = locValueStr.substr(1, (locValueStr.length - 2));
                                }
                            }
                        }
                    }
                }	
            } 	catch (err) {}

            for(k=0; k < dashboardDpList.length; k++)
            {
                dpQualifier = dashboardDpList[k].dpQualifier;
                //if(dashboardDpList[k].dpQualifier === datapointQualifier) {
                if(dpQualifier === datapointQualifier) {
                    try {
                        bContinue = true;
                        if(dashboardDpList[k].cat === "in") {
                            if(!dashboardDpList[k].updateDpValue) {
                                if(dashboardDpList[k].feedbackDelay) {
                                    bContinue = false;
                                    if(currentTimeMs > dashboardDpList[k].feedbackDelayTimeout) {
                                        dashboardDpList[k].feedbackDelay = false;
                                        dashboardDpList[k].feedbackDelayTimeout = 0;
                                        bContinue = true;
                                        dashboardDpList[k].updateDpValue = true;
                                    }
                                    //else if ((dashboardDpList[k].locValueStr !== locValueStr) && isNotEqual(dashboardDpList[k].feedbackDelayOldValue, locValue)) {
                                    else if (isNotEqual(dashboardDpList[k].locValue, locValue) && isNotEqual(dashboardDpList[k].feedbackDelayOldValue, locValue)) {
                                        dashboardDpList[k].feedbackDelay = false;
                                        dashboardDpList[k].feedbackDelayTimeout = 0;
                                        bContinue = true;
                                        dashboardDpList[k].updateDpValue = true;
                                    }
                                }
                            }
                        }
                        if(bContinue && (dashboardDpList[k].updateDpValue || (isNotEqual(value1, dashboardDpList[k].value)))){
                            dashboardDpList[k].updateDpValue = false;
                            dashboardDpList[k].value = value1;
                            origValue = JSON.parse(JSON.stringify(value1));
                            origLocValue = JSON.parse(JSON.stringify(locValue));
                            if(typeof value1 === "number")
                                valueStr = value1;
                            else
                                valueStr = JSON.stringify(value1);
                            dashboardDpList[k].valueStr = valueStr;
                            dashboardDpList[k].locValue = locValue;
                            dashboardDpList[k].locValueStr = locValueStr;
                            dashboardDpList[k].presetValue = presetValue;
                            dashboardType = "";
                            
                            for(z = 0; z < dashboardDpList[k].displayElements.length; z++)
                            {
                                try {
                                    dashboardType = dashboardDpList[k].displayElements[z].dashboardType;
                                    displayId = dashboardDpList[k].displayElements[z].displayId; // ffix88888
                                    if(dashboardDpList[k].bStructure) {
                                        locValue = {};
                                        locValue =  JSON.parse(JSON.stringify(dashboardDpList[k].locValue));
                                    }
                                    else
                                        locValue =  dashboardDpList[k].locValue;
                                    locValueStr = dashboardDpList[k].locValueStr;
                                    presetValue = dashboardDpList[k].presetValue;
                                    if(presetValue === " ")
                                        presetValue = "";
                                    field = dashboardDpList[k].displayElements[z].field;
                                    color = dashboardDpList[k].displayElements[z].color;  //for leds this is the on color
                                    backgroundColor = dashboardDpList[k].displayElements[z].backgroundColor; //for leds this is the off color
                                    bContinue = true;
                                    if(field !== "") {
                                        presetValue = "";
                                        
                                        if(typeof locValue === "object") {
                                            bContinue = false;
                                            fieldValue = readFieldValue(locValue, field);
                                            if(fieldValue.valid) {
                                                locValue = fieldValue.data;
                                                bContinue = true;
                                            }
                                            
                                        }
                                        else 
                                            bContinue = false;
                                        if(bContinue) {
                                        
                                            if(typeof locValue === "object") {
                                                //displayElement.bStructure = true;
                                                locValueStr = JSON.stringify(locValue);
                                                if(locValueStr.length > 2) {
                                                    if((locValueStr.charAt(0) === "{") && (locValueStr.charAt(locValueStr.length - 1) === "}")) {
                                                        locValueStr = locValueStr.substr(1, (locValueStr.length - 2));
                                                    }
                                                }
                                            }
                                            else if(typeof locValue === "string") {
                                                
            
                                            }
                                            else if(typeof locValue === "number") {
                                                
                                                locValueStr = locValue.toString();
                                            }
                                            else if(typeof locValue === "boolean") {
                                                
                                                locValueStr = locValue.toString();
                                            }
                                        }
                                    }
                                    
                                    
                                    if(bContinue) {
                                        
                                        if((dashboardType === "n") || (dashboardType === "r") || (dashboardType === "s0") || (dashboardType === "s1")) {
                                            if((dashboardType === "n") || (dashboardType === "r")) {
                                                if(dashboardDpList[k].displayElements[z].bFunction) {
                                                    if(dashboardDpList[k].displayElements[z].function === "cf") {
                                                        locValueStr = convertTemperature(0,locValue,dashboardDpList[k].displayElements[z].precision);
                                                    }
                                                    else if(dashboardDpList[k].displayElements[z].function === "fc") {
                                                        locValueStr = convertTemperature(1,locValue,dashboardDpList[k].displayElements[z].precision);
                                                    }
                                                }
                                                else if(dashboardDpList[k].displayElements[z].precision !== -1) {
                                                    if(typeof locValue === "number")
                                                        locValueStr = dashboardNumToFixedLength(locValue, dashboardDpList[k].displayElements[z].precision);
                                                }
                                                else if(g_bDashboardMinMaxDecimalPlaces) {
                                                    if(typeof locValue === "number")
                                                        locValueStr = dashboardNumToFixedLength(locValue, g_iDashboardDecimalPlaces);
                                                }
                                            }
                                            if((dashboardDpList[k].displayElements[z].field === "") && (presetValue !== ""))
                                                locValueStr = presetValue;
                                            if((dashboardDpList[k].cat === "in") && (dashboardType !== "r") && (dashboardType !== "s1"))
                                                document.getElementById("localValue_" + displayId).value = locValueStr;  //locValue required for input
                                            else
                                                document.getElementById("localValue_" + displayId).innerHTML = locValueStr;
                                            dashboardDpList[k].timestampStr = currentTime;
                                            //document.getElementById("timestamp_" + dashboardDpList[k].pathname).innerHTML = dashboardDpList[k].timestampStr;
                                        }
                                        else if(dashboardType === "g") { //guage
                                            element = document.getElementById("guageneedle_" + dashboardDpList[k].displayElements[z].displayId);
                                            try {
                                                if(element !== null) {
                                                    if(typeof locValue === "number") {
                                                        tempValue = locValue;
                                                        tempValue = tempValue - dashboardDpList[k].displayElements[z].guageObj.guageMin;
                                                        tempValue = tempValue / (dashboardDpList[k].displayElements[z].guageObj.guageMax - dashboardDpList[k].displayElements[z].guageObj.guageMin);
                                                        if(tempValue < 0)
                                                            tempValue = 0;
                                                        else if (tempValue > 1)
                                                            tempValue = 1; 
                                                        tempValue1 = tempValue;
                                                        if(tempValue1 < .01)
                                                            tempValue1 = .02;
                                                        else if(tempValue1 > .99)
                                                            tempValue1 = .99;
                                                            
                                                        element1 = document.getElementById("guageHole_" + dashboardDpList[k].displayElements[z].displayId)
                                                        if(element1 !== null) {
                                                            tempValue2 = locValue;
                                                            if(typeof tempValue2 === "string") {
                                                                if(!isNaN(tempValue2)) 
                                                                    tempValue2 = Number(tempValue2);
                                                                    
                                                            }
                                                            if(typeof tempValue2 === "number") {
                                                                if(Number.isInteger(tempValue2)) {

                                                                }
                                                                else {
                                                                    if(dashboardDpList[k].displayElements[z].precision !== -1) {
                                                                        tempValue2 = dashboardNumToFixedLength(tempValue2, dashboardDpList[k].displayElements[z].precision);
                                                                    }
                                                                    else if(g_bDashboardMinMaxDecimalPlaces) 
                                                                        tempValue2 = dashboardNumToFixedLength(tempValue2, g_iDashboardDecimalPlaces);
                                                                }
                                                            }
                                                            element1.textContent = tempValue2; //locValue; //(Math.round(tempValue * 100)).toString();
                                                        }
                                                        
                                                        if(dashboardDpList[k].displayElements[z].guageObj.type === 0) {
                                                            element1 = document.getElementById("guageFill_" + dashboardDpList[k].displayElements[z].displayId)
                                                            if(element1 !== null) {
                                                                element1.style.transform = 'rotate(' + (tempValue / 2).toString() + 'turn)';
                                                                for(v=0; v < dashboardDpList[k].displayElements[z].guageObj.guageColors.length; v++)
                                                                {
                                                                    if(dashboardDpList[k].displayElements[z].guageObj.guageColors[v].value === null) {
                                                                        element1.style.background = dashboardDpList[k].displayElements[z].guageObj.guageColors[v].color;
                                                                    }
                                                                    else if(v === (dashboardDpList[k].displayElements[z].guageObj.guageColors.length - 1)) {
                                                                        element1.style.background = dashboardDpList[k].displayElements[z].guageObj.guageColors[v].color;
                                                                        break;
                                                                    }
                                                                    else if(locValue < dashboardDpList[k].displayElements[z].guageObj.guageColors[v].value) {
                                                                        element1.style.background = dashboardDpList[k].displayElements[z].guageObj.guageColors[v].color;
                                                                        break;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        tempValue1 = Math.floor(tempValue1 * 180) + 180;
                                                        element.style.transform = 'rotate(' + tempValue1.toString() + 'deg)';
                                                    }
                                                }
                                                dashboardDpList[k].timestampStr = currentTime;
                                            }
                                            catch {}
                                        }
                                        else if(dashboardType === "m") {
                                            try {
                                                element = document.getElementById("localValue_" + dashboardDpList[k].displayElements[z].displayId);
                                                if(element !== null) {
                                                    element.innerHTML = locValue;
                                                    if(typeof locValue === "number") {
                                                        element = document.getElementById("meter_" + dashboardDpList[k].displayElements[z].displayId);
                                                        if(element !== null) {
                                                            element.value = locValue;
                                                            if(dashboardDpList[k].displayElements[z].guageObj.type === 0) {
                                                                // green, orange, red or green/orange/red
                                                                if(dashboardDpList[k].displayElements[z].guageObj.guageColors.length === 1) {
                                                                    if(dashboardDpList[k].displayElements[z].guageObj.guageColors[0].color !== "") {
                                                                        if(dashboardDpList[k].displayElements[z].guageObj.guageColors[0].color === "orange") {
                                                                            // orange
                                                                            element.low = "0";
                                                                            element.high = "0";
                                                                            element.optimum = "0";
                                                                        }
                                                                        else if(dashboardDpList[k].displayElements[z].guageObj.guageColors[0].color === "red") {
                                                                            // red
                                                                            if(locValue >
                                                                                (((dashboardDpList[k].displayElements[z].guageObj.guageMax - dashboardDpList[k].displayElements[z].guageObj.guageMin) / 2
                                                                                    + dashboardDpList[k].displayElements[z].guageObj.guageMin))) {

                                                                                element.low = (locValue - dashboardDpList[k].displayElements[z].guageObj.guageMin) / 3;
                                                                                element.high = (locValue - dashboardDpList[k].displayElements[z].guageObj.guageMin) / 2;
                                                                                element.optimum = (locValue - dashboardDpList[k].displayElements[z].guageObj.guageMin) / 4;
                                                                            }
                                                                            else {
                                                                                element.low = (dashboardDpList[k].displayElements[z].guageObj.guageMax - dashboardDpList[k].displayElements[z].guageObj.guageMin) * 0.8;
                                                                                element.high = (dashboardDpList[k].displayElements[z].guageObj.guageMax - dashboardDpList[k].displayElements[z].guageObj.guageMin) * 0.9;
                                                                                element.optimum = dashboardDpList[k].displayElements[z].guageObj.guageMax;
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                                else if(dashboardDpList[k].displayElements[z].guageObj.guageColors.length === 3) {
                                                                    if((dashboardDpList[k].displayElements[z].guageObj.guageColors[0].value !== null) && (dashboardDpList[k].displayElements[z].guageObj.guageColors[1].value !== null)) {
                                                                        // green/orange/red
                                                                        if(locValue >= dashboardDpList[k].displayElements[z].guageObj.guageColors[1].value) {
                                                                            //red
                                                                            element.low = (locValue - dashboardDpList[k].displayElements[z].guageObj.guageMin) / 3;
                                                                            element.high = (locValue - dashboardDpList[k].displayElements[z].guageObj.guageMin) / 2;
                                                                            element.optimum = (locValue - dashboardDpList[k].displayElements[z].guageObj.guageMin) / 4;
                                                                        }
                                                                        else if(locValue >= dashboardDpList[k].displayElements[z].guageObj.guageColors[0].value) {
                                                                            // orange
                                                                            element.low = "0";
                                                                            element.high = "0";
                                                                            element.optimum = "0";
                                                                        }
                                                                        else {
                                                                            //green
                                                                            element.low = "0";
                                                                            element.high = "0";
                                                                            element.optimum = locValue;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                            else if(dashboardDpList[k].displayElements[z].guageObj.type === 1) {
                                                                // red/orange/green
                                                                if(dashboardDpList[k].displayElements[z].guageObj.guageColors.length === 3) {
                                                                    if((dashboardDpList[k].displayElements[z].guageObj.guageColors[0].value !== null) && (dashboardDpList[k].displayElements[z].guageObj.guageColors[1].value !== null)) {
                                                                        if(locValue >= dashboardDpList[k].displayElements[z].guageObj.guageColors[1].value) {
                                                                            //green
                                                                            element.low = "0";
                                                                            element.high = "0";
                                                                            element.optimum = locValue;
                                                                        }
                                                                        else if(locValue >= dashboardDpList[k].displayElements[z].guageObj.guageColors[0].value) {
                                                                            // orange
                                                                            element.low = "0";
                                                                            element.high = "0";
                                                                            element.optimum = "0";
                                                                        }
                                                                        else {
                                                                            //red
                                                                            element.low = (dashboardDpList[k].displayElements[z].guageObj.guageMax - dashboardDpList[k].displayElements[z].guageObj.guageMin) * 0.8;
                                                                            element.high = (dashboardDpList[k].displayElements[z].guageObj.guageMax - dashboardDpList[k].displayElements[z].guageObj.guageMin) * 0.9;
                                                                            element.optimum = dashboardDpList[k].displayElements[z].guageObj.guageMax;
                                                                            
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                            else if(dashboardDpList[k].displayElements[z].guageObj.type === 2) {
                                                                // red/orange/green/orange/red
                                                                if(dashboardDpList[k].displayElements[z].guageObj.guageColors.length === 5) {
                                                                    if((dashboardDpList[k].displayElements[z].guageObj.guageColors[0].value !== null) && (dashboardDpList[k].displayElements[z].guageObj.guageColors[1].value !== null)
                                                                        && (dashboardDpList[k].displayElements[z].guageObj.guageColors[2].value !== null) && (dashboardDpList[k].displayElements[z].guageObj.guageColors[3].value !== null)){
                                                                        if(locValue >= dashboardDpList[k].displayElements[z].guageObj.guageColors[3].value) {
                                                                            //red
                                                                            element.low = (locValue - dashboardDpList[k].displayElements[z].guageObj.guageMin) / 3;
                                                                            element.high = (dlocValue - dashboardDpList[k].displayElements[z].guageObj.guageMin) / 2;
                                                                            element.optimum = (locValue - dashboardDpList[k].displayElements[z].guageObj.guageMin) / 4;
                                                                        }
                                                                        else if(locValue >= dashboardDpList[k].displayElements[z].guageObj.guageColors[2].value) {
                                                                            // orange
                                                                            element.low = "0";
                                                                            element.high = "0";
                                                                            element.optimum = "0";
                                                                        }
                                                                        else if(locValue >= dashboardDpList[k].displayElements[z].guageObj.guageColors[1].value) {
                                                                            //green
                                                                            element.low = "0";
                                                                            element.high = "0";
                                                                            element.optimum = locValue;
                                                                        }
                                                                        else if(locValue >= dashboardDpList[k].displayElements[z].guageObj.guageColors[0].value) {
                                                                            // orange
                                                                            element.low = "0";
                                                                            element.high = "0";
                                                                            element.optimum = "0";
                                                                        }
                                                                        else {
                                                                            //red
                                                                            element.low = (dashboardDpList[k].displayElements[z].guageObj.guageMax - dashboardDpList[k].displayElements[z].guageObj.guageMin) * 0.8;
                                                                            element.high = (dashboardDpList[k].displayElements[z].guageObj.guageMax - dashboardDpList[k].displayElements[z].guageObj.guageMin) * 0.9;
                                                                            element.optimum = dashboardDpList[k].displayElements[z].guageObj.guageMax;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                dashboardDpList[k].timestampStr = currentTime;
                                            }
                                            catch {}
                                        }
                                        else if(dashboardType === "tc") {
                                            
                                            // Thermometer
                                            if((dashboardDpList[k].displayElements[z].thermometerObj.style === "cf") 
                                                || (dashboardDpList[k].displayElements[z].thermometerObj.style === "fc")
                                                || (dashboardDpList[k].displayElements[z].thermometerObj.style === "c")) {

                                                if(dashboardDpList[k].displayElements[z].thermometerObj.source === "c") {
                                                    dashboardSetThermometerValue (0, dashboardDpList[k].displayElements[z].thermometerObj.source, locValue,dashboardDpList[k].displayElements[z].thermometerObj.degMin,dashboardDpList[k].displayElements[z].thermometerObj.degMax, dashboardDpList[k].displayElements[z].displayId);
                                                    element = document.getElementById("thermometer_c_" + dashboardDpList[k].displayElements[z].displayId);
                                                    if(element !== null) {
                                                        sTemp = locValue.toFixed(1) + " &deg;C";
                                                        if(dashboardDpList[k].displayElements[z].thermometerObj.style !== "c")
                                                            sTemp = "(" + sTemp + ")";
                                                        element.innerHTML = sTemp;
                                                        
                                                    }
                                                }
                                                if((dashboardDpList[k].displayElements[z].thermometerObj.style === "c") && (dashboardDpList[k].displayElements[z].thermometerObj.bAddOtherTemp)) {
                                                    sTemp = (1.8 * locValue) + 32;
                                                    element = document.getElementById("thermometer_f_" + dashboardDpList[k].displayElements[z].displayId);
                                                    if(element !== null) {
                                                        element.innerHTML = "(" + sTemp.toFixed(0) + " &deg;F)";
                                                    }
                                                }
                                            }
                                            if((dashboardDpList[k].displayElements[z].thermometerObj.style === "cf") 
                                            || (dashboardDpList[k].displayElements[z].thermometerObj.style === "fc")
                                            || (dashboardDpList[k].displayElements[z].thermometerObj.style === "f")) {
                                                sTemp = locValue;
                                                if(dashboardDpList[k].displayElements[z].thermometerObj.source === "c") {
                                                    locValue = (1.8 * locValue) + 32;
                                                    
                                                }
                                                else 
                                                    dashboardSetThermometerValue (0, dashboardDpList[k].displayElements[z].thermometerObj.source, locValue,dashboardDpList[k].displayElements[z].thermometerObj.degMin,dashboardDpList[k].displayElements[z].thermometerObj.degMax, dashboardDpList[k].displayElements[z].displayId);
                                                element = document.getElementById("thermometer_f_" + dashboardDpList[k].displayElements[z].displayId);
                                                if(element !== null) {
                                                    element.innerHTML = locValue.toFixed(0) + " &deg;F";;
                                                }
                                                if((dashboardDpList[k].displayElements[z].thermometerObj.style === "f") && (dashboardDpList[k].displayElements[z].thermometerObj.bAddOtherTemp)) {
                                                    sTemp = (sTemp - 32) / 1.8 //(1.8 * sTemp) + 32;
                                                    element = document.getElementById("thermometer_c_" + dashboardDpList[k].displayElements[z].displayId);
                                                    if(element !== null) {
                                                        element.innerHTML = "(" + sTemp.toFixed(1) + " &deg;C)";
                                                    }
                                                }
                                            }
                                        }
                                        else if(dashboardType === "lc") {
                                            // lightSensor
                                            dashboardSetThermometerValue (0, "l", locValue,dashboardDpList[k].displayElements[z].thermometerObj.min,dashboardDpList[k].displayElements[z].thermometerObj.max, dashboardDpList[k].displayElements[z].displayId);
                                            element = document.getElementById("lightmeter_" + dashboardDpList[k].displayElements[z].displayId);
                                            if(element !== null) {
                                                element.innerHTML = locValue.toFixed(0);
                                                if(dashboardDpList[k].displayElements[z].units !== "")
                                                    element.innerHTML += " " +dashboardDpList[k].displayElements[z].units;
                                            }
                                        }
                                        else if((dashboardType === "i") ||  (dashboardType === "t1")  ||  (dashboardType === "led1")){
                                            // image swapper, small thermostat
                                            try {
                                                if(typeof dashboardDpList[k].displayElements[z].imageSwapper !== "undefined") {
                                                    v = -1;
                                                    for(j=0; j < dashboardDpList[k].displayElements[z].imageSwapper.length; j++)
                                                    {
                                                        
                                                        if(dashboardDpList[k].displayElements[z].imageSwapper[j].test === ">") {
                                                            if(locValue > dashboardDpList[k].displayElements[z].imageSwapper[j].value) {
                                                                v = j;
                                                                break;
                                                            }
                                                        }
                                                        else if(dashboardDpList[k].displayElements[z].imageSwapper[j].test === ">=") {
                                                            if(locValue >= dashboardDpList[k].displayElements[z].imageSwapper[j].value) {
                                                                v = j;
                                                                break;
                                                            }
                                                        }
                                                        else if(dashboardDpList[k].displayElements[z].imageSwapper[j].test === "=") {
                                                            if(locValue === dashboardDpList[k].displayElements[z].imageSwapper[j].value) {
                                                                v = j;
                                                                break;
                                                            }
                                                        }
                                                        else if(dashboardDpList[k].displayElements[z].imageSwapper[j].test === "<=") {
                                                            if(locValue <= dashboardDpList[k].displayElements[z].imageSwapper[j].value) {
                                                                // check if next value lower value
                                                                if(j === (dashboardDpList[k].displayElements[z].imageSwapper.length - 1)) {
                                                                    v = j;
                                                                    break;
                                                                }
                                                                else if(locValue > dashboardDpList[k].displayElements[z].imageSwapper[j + 1].value){
                                                                    v = j;
                                                                    break;
                                                                }
                                                            }
                                                        }
                                                        else if(dashboardDpList[k].displayElements[z].imageSwapper[j].test === "<") {
                                                            if(locValue < dashboardDpList[k].displayElements[z].imageSwapper[j].value) {
                                                                // check if next value lower value
                                                                if(j === (dashboardDpList[k].displayElements[z].imageSwapper.length - 1)) {
                                                                    v = j;
                                                                    break;
                                                                }
                                                                else if(locValue > dashboardDpList[k].displayElements[z].imageSwapper[j + 1].value){
                                                                    v = j;
                                                                    break;
                                                                }
                                                            }
                                                        }
                                                        
                                                    }
                                                    if(v !== -1) {
                                                        sTemp = dashboardDpList[k].displayElements[z].imageSwapper[v].image;
                                                        if(dashboardType === "i") {
                                                            element = document.getElementById("imagelocalValue_" + dashboardDpList[k].displayElements[z].displayId);
                                                            if(element !== null) {
                                                                if(element.src !== sTemp)
                                                                    element.src = sTemp;
                                                            }
                                                        }
                                                        else if(dashboardType === "t1") {
                                                            sTemp = dashboardDpList[k].displayElements[z].imageSwapper[v].image;
                                                            if(sTemp === "red")
                                                                sTemp = "thermometerSmallBar";
                                                            else if(sTemp === "green")
                                                                sTemp = "thermometerSmallBarGreen";
                                                            else if(sTemp === "yellow")
                                                                sTemp = "thermometerSmallBarYellow";
                                                                else if(sTemp === "orange")
                                                                sTemp = "thermometerSmallBarOrange";
                                                            else if(sTemp === "cyan")
                                                                sTemp = "thermometerSmallBarCyan";
                                                            else if(sTemp === "blue")
                                                                sTemp = "thermometerSmallBarBlue";
                                                            else
                                                                sTemp = "";
                                                            if(sTemp !== "") {
                                                                element = document.getElementById("thermometerBarlocalValue_" + dashboardDpList[k].displayElements[z].displayId);
                                                                if(element !== null) {
                                                                    
                                                                    if(element.className !== sTemp)
                                                                        element.className = sTemp;
                                                                }
                                                                sTemp = dashboardDpList[k].displayElements[z].imageSwapper[v].image;
                                                                if(sTemp === "red")
                                                                    sTemp = "thermometerSmallCircle";
                                                                else if(sTemp === "green")
                                                                    sTemp = "thermometerSmallCircleGreen";
                                                                else if(sTemp === "yellow")
                                                                    sTemp = "thermometerSmallCircleYellow";
                                                                else if(sTemp === "orange")
                                                                    sTemp = "thermometerSmallCircleOrange";
                                                                else if(sTemp === "cyan")
                                                                    sTemp = "thermometerSmallCircleCyan";
                                                                else if(sTemp === "blue")
                                                                    sTemp = "thermometerSmallCircleBlue";
                                                                else
                                                                    sTemp = "";
                                                                if(sTemp !== "") {
                                                                    element = document.getElementById("thermometerCirclelocalValue_" + dashboardDpList[k].displayElements[z].displayId);
                                                                    if(element !== null) {
                                                                        
                                                                        if(element.className !== sTemp)
                                                                            element.className = sTemp;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        else if(dashboardType === "led1") {
                                                            element = document.getElementById("localValueLed_" + dashboardDpList[k].displayElements[z].displayId);
                                                            if(element !== null) {
                                                                if(element.style.backgroundColor !== sTemp)
                                                                    element.style.backgroundColor = sTemp
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            catch 
                                            {}
                                        }
                                        else if(dashboardType === "sl") {
                                            try { //slider
                                                element = document.getElementById("localValue_" + dashboardDpList[k].displayElements[z].displayId);
                                                if(element !== null) {
                                                    element.innerHTML = locValue;
                                                    if(typeof locValue === "number") {
                                                        element = document.getElementById("slider_" + dashboardDpList[k].displayElements[z].displayId);
                                                        if(element !== null) {
                                                            element.value = locValue;
                                                            if(false) {
                                                                    //doesn't work
                                                                if(dashboardDpList[k].displayElements[z].guageObj.type === 0) {
                                                                                    
                                                                    for(v=0; v < dashboardDpList[k].displayElements[z].guageObj.guageColors.length; v++)
                                                                    {
                                                                        if(dashboardDpList[k].displayElements[z].guageObj.guageColors[v].value === null) {
                                                                            element.style.background = dashboardDpList[k].displayElements[z].guageObj.guageColors[v].color;
                                                                        }
                                                                        else if(v === (dashboardDpList[k].displayElements[j].guageObj.guageColors.length - 1)) {
                                                                            element.style.background = dashboardDpList[k].displayElements[z].guageObj.guageColors[v].color;
                                                                            break;
                                                                        }
                                                                        else if(locValue < dashboardDpList[k].displayElements[z].guageObj.guageColors[v].value) {
                                                                            element.style.background = dashboardDpList[k].displayElements[z].guageObj.guageColors[v].color;
                                                                            break;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                dashboardDpList[k].timestampStr = currentTime;
                                            }
                                            catch {}
                                        }
                                        else if((dashboardType === "a") && (!dashboardDpList[k].displayElements[z].readonly)) { //SNVT_str_ascii
                                            locValueStr = value1.ascii;
                                            if(presetValue !== "")
                                                locValueStr = presetValue;
                                            if(dashboardDpList[k].cat === "in")
                                                document.getElementById("localValue_" + displayId).innerHTML = locValueStr;
                                            else
                                                document.getElementById("localValue_" + displayId).innerHTML = locValueStr;
                                            dashboardDpList[k].timestampStr = currentTime;
                                            //document.getElementById("timestamp_" + dashboardDpList[k].pathname).innerHTML = dashboardDpList[k].timestampStr;
                                        }
                                        else if((dashboardType === "d") && (!dashboardDpList[k].displayElements[z].readonly)) { //drop down in table
                                            if(presetValue !== "")
                                                locValueStr = presetValue;
                                            if(typeof locValueStr === "string") {
                                                if(locValueStr.charAt(0) === "\"")
                                                    if(locValueStr.length > 1)
                                                        locValueStr = locValueStr.substr(1,locValueStr.length - 2);
                                            }
                                            document.getElementById("localValue_" + displayId).value = locValueStr;
                                            dashboardDpList[k].timestampStr = currentTime;
                                        }
                                        else if(dashboardType === "l2") {
                                            borderColor = "";
                                            color = dashboardDpList[k].displayElements[z].color;
                                            backgroundColor = dashboardDpList[k].displayElements[z].backgroundColor;
                                            if(typeof dashboardDpList[k].displayElements[z].borderColor !== "undefined")
                                                borderColor = dashboardDpList[k].displayElements[z].borderColor;
                                            document.getElementById("localValueSwitch_" + displayId).style.removeProperty('background-Color');
                                            if(typeof dashboardDpList[k].displayElements[z].graphicType !== "undefined") {
                                                z1 = dashboardDpList[k].displayElements[z].graphicType;
                                                if(z1 === 5) { // small dot (0 = red, 1=green)
                                                    z1 = 1;
                                                    if(locValue === 0)
                                                        backgroundColor = "red";
                                                    else 
                                                        color = "lawngreen";
                                                }
                                                else if(z1 === 6) { // small dot (0 = green, 1=red)
                                                    z1 = 1;
                                                    if(locValue === 0)
                                                        backgroundColor = "lawngreen";
                                                    else 
                                                        color = "red";
                                                }
                                                else if(z1 === 7) { // large dot with border (0 = red, 1=green)
                                                    z1 = 2;
                                                    if(locValue === 0)
                                                        backgroundColor = "red";
                                                    else 
                                                        color = "lawngreen";
                                                }
                                                else if(z1 === 8) { // large dot with border (0 = red, 1=green)
                                                    z1 = 2;
                                                    if(locValue=== 0)
                                                        backgroundColor = "lawngreen";
                                                    else 
                                                        color = "red";
                                                }
                                                else if(z1 === 9) { // large dot with border (0 = red, 1=green)
                                                    z1 = 3;
                                                    if(locValue === 0)
                                                        backgroundColor = "red";
                                                    else 
                                                        color = "lawngreen";
                                                }
                                                else if(z1 === 10) { // large dot with border (0 = red, 1=green)
                                                    z1 = 3;
                                                    if(locValue === 0)
                                                        backgroundColor = "lawngreen";
                                                    else 
                                                        color = "red";
                                                }
                                            }
                                            else 
                                                z1 = 4; //floorplan, room,area
                                            if(typeof locValue === "number") {
                                                if(locValue === 0) {
                                                    if(z1 === 1)
                                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotSmallOff";
                                                    else if(z1 === 2)
                                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotMediumOff";
                                                    else 
                                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotOff";
                                                    if(backgroundColor !== ""){
                                                        document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = backgroundColor;
                                                    }
                                                    if(borderColor !== "") {
                                                        document.getElementById("localValueSwitch_" + displayId).style.borderColor = borderColor;
                                                    }
                                                }
                                                else {
                                                    if(z1 === 1)
                                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotSmallOn";
                                                    else if(z1 === 2)
                                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotMediumOn";
                                                    else if(z1 === 3)
                                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotOnBorder";
                                                    else 
                                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotOn";

                                                    if(color !== ""){
                                                        document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = color;
                                                    }
                                                    if(borderColor !== "") {
                                                        document.getElementById("localValueSwitch_" + displayId).style.borderColor = borderColor;
                                                    }
                                                }
                                            }
                                            else if(typeof locValue === "boolean") {
                                                if(locValue === true) {
                                                    if(z1 === 1)
                                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotSmallOn";
                                                    else if(z1 === 2)
                                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotMediumOn";
                                                    else if(z1=== 3)
                                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotOnBorder";
                                                    else 
                                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotOn";
                                                    if(color !== ""){
                                                        document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = color;
                                                    }
                                                    if(borderColor !== "") {
                                                        document.getElementById("localValueSwitch_" + displayId).style.borderColor = borderColor;
                                                    }
                                                }
                                                else {
                                                    if(z1 === 1)
                                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotSmallOff";
                                                    else if(z1 === 2)
                                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotMediumOff";
                                                    else 
                                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotOff";
                                                    if(backgroundColor !== ""){
                                                        document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = backgroundColor;
                                                    }
                                                    if(borderColor !== "") {
                                                        document.getElementById("localValueSwitch_" + displayId).style.borderColor = borderColor;
                                                    }
                                                }
                                            }
                                        }
                                        else if((dashboardType === "l3") || (dashboardType === "l4")) {
                                            if(dashboardType === "l3") {
                                                //with edit mode this can be a span or a text box
                                                element = document.getElementById("localValue_" + displayId);
                                                if(element !== null) {
                                                    if(element.nodeName === "INPUT")
                                                        element.value = locValue.value.toString();
                                                    else 
                                                        element.innerHTML = locValue.value.toString(); //Span or div
                                                }
                                            }
                                            borderColor = "";
                                            color = dashboardDpList[k].displayElements[z].color;
                                            backgroundColor = dashboardDpList[k].displayElements[z].backgroundColor;
                                            if(typeof dashboardDpList[k].displayElements[z].borderColor !== "undefined")
                                                borderColor = dashboardDpList[k].displayElements[z].borderColor;
                                            document.getElementById("localValueSwitch_" + displayId).style.removeProperty('background-Color');
                                            if(locValue.state === 1) {
                                                if(dashboardDpList[k].displayElements[z].graphicType === 1)
                                                    document.getElementById("localValueSwitch_" + displayId).className = "ledDotSmallOn";
                                                else if(dashboardDpList[k].displayElements[z].graphicType === 2)
                                                    document.getElementById("localValueSwitch_" + displayId).className = "ledDotMediumOn";
                                                else if(dashboardDpList[k].displayElements[z].graphicType === 3)
                                                    document.getElementById("localValueSwitch_" + displayId).className = "ledDotOnBorder";
                                                else 
                                                    document.getElementById("localValueSwitch_" + displayId).className = "ledDotOn";
                                                if(color !== ""){
                                                    document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = color;
                                                }
                                                if(borderColor !== "") {
                                                    document.getElementById("localValueSwitch_" + displayId).style.borderColor = borderColor;
                                                }
                                            }
                                            else {
                                                if(dashboardDpList[k].displayElements[z].graphicType === 1)
                                                    document.getElementById("localValueSwitch_" + displayId).className = "ledDotSmallOff";
                                                else if(dashboardDpList[k].displayElements[z].graphicType === 2)
                                                    document.getElementById("localValueSwitch_" + displayId).className = "ledDotMediumOff";
                                                else 
                                                    document.getElementById("localValueSwitch_" + displayId).className = "ledDotOff";
                                                if(backgroundColor !== ""){
                                                    document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = backgroundColor;
                                                }
                                                if(borderColor !== "") {
                                                    document.getElementById("localValueSwitch_" + displayId).style.borderColor = borderColor;
                                                }
                                            }
                                        }
                                        else if(dashboardType === "l5") {
                                            if(locValue === null) {

                                            }
                                            else if((locValue === 0) || (locValue === 1)) {
                                                color = dashboardDpList[k].displayElements[z].color;
                                                backgroundColor = dashboardDpList[k].displayElements[z].backgroundColor;
                                                borderColor = "";
                                                if(typeof dashboardDpList[k].displayElements[z].borderColor !== "undefined")
                                                    borderColor = dashboardDpList[k].displayElements[z].borderColor;
                                                if(locValue === 0) {
                                                    //on
                                                    document.getElementById("localValueSwitch_" + displayId).className = "ledDotOn";
                                                    if(color !== ""){
                                                        document.getElementById("localValueSpan_" + displayId).style.backgroundColor = color;
                                                    }
                                                } 
                                                
                                                else if (locValue === 1)  { 
                                                    // off
                                                    document.getElementById("localValueSwitch_" + displayId).className = "ledDotOff";
                                                    if(backgroundColor !== "")
                                                        document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = backgroundColor;
                                                    if(borderColor !== "") 
                                                        document.getElementById("localValueSwitch_" + displayId).style.borderColor = borderColor;
                                                }
                                            }
                                            else {

                                            }
                                        
                                        }
                                        else if((dashboardType === "l5d") || (dashboardType === "l5d1")  || (dashboardType === "l5_div")) {
                                            
                                            // values not populated yet so add span and change dashboard type to l5 EnOcean rocker switch
                                            if((locValue === 0) || (locValue === 1)) {
                                                color = dashboardDpList[k].displayElements[z].color;
                                                backgroundColor = dashboardDpList[k].displayElements[z].backgroundColor;
                                                borderColor = "";
                                                if(typeof dashboardDpList[k].displayElements[z].borderColor !== "undefined")
                                                    borderColor = dashboardDpList[k].displayElements[z].borderColor;
                                                element = document.getElementById("localValueSwitchBorder_" + displayId);
                                                if(element !== null) {
                                                    element.style.border = "none";
                                                }
                                                if(locValue === 0) { // On
                                                    document.getElementById("localValueSwitch_" + displayId).className = "ledDotOn";
                                                    if(color !== "") {
                                                        document.getElementById("localValueSpan_" + displayId).style.backgroundColor = color;
                                                    }
                                                }
                                                else { // off
                                                    document.getElementById("localValueSwitch_" + displayId).className = "ledDotOff";
                                                    if(backgroundColor !== ""){
                                                        document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = backgroundColor;
                                                    }
                                                    if(borderColor !== "") {
                                                        document.getElementById("localValueSwitch_" + displayId).style.borderColor = borderColor;
                                                    }
                                                }
                                                dashboardDpList[k].displayElements[z].dashboardType = "l5";
                                            }
                                            else {

                                            }
                                             
                                        }
                                        else if((dashboardType === "l6") || (dashboardType === "l7")) {
                                            if(dashboardType === "l7") {
                                                //with edit mode this can be a span or a text box
                                                element = document.getElementById("localValue_" + displayId);
                                                if(element !== null) {
                                                    if(element.nodeName === "INPUT")
                                                        element.value = locValue;
                                                    else 
                                                        element.innerHTML = locValue; //Span or div
                                                }
                                            }
                                            borderColor = "";
                                            color = dashboardDpList[k].displayElements[z].color;
                                            backgroundColor = dashboardDpList[k].displayElements[z].backgroundColor;
                                            if(typeof dashboardDpList[k].displayElements[z].borderColor !== "undefined")
                                                borderColor = dashboardDpList[k].displayElements[z].borderColor;
                                            document.getElementById("localValueSwitch_" + displayId).style.removeProperty('background-Color');
                                            if(locValue === 0) {
                                                if(dashboardDpList[k].displayElements[z].graphicType === 1)
                                                    document.getElementById("localValueSwitch_" + displayId).className = "ledDotSmallOff";
                                                else if(dashboardDpList[k].displayElements[z].graphicType === 2)
                                                    document.getElementById("localValueSwitch_" + displayId).className = "ledDotMediumOff";
                                                else 
                                                    document.getElementById("localValueSwitch_" + displayId).className = "ledDotOff";
                                                if(backgroundColor !== ""){
                                                    document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = backgroundColor;
                                                }
                                                if(borderColor !== "") {
                                                    document.getElementById("localValueSwitch_" + displayId).style.borderColor = borderColor;
                                                }
                                            }
                                            else  {
                                                if(dashboardDpList[k].displayElements[z].graphicType === 1)
                                                    document.getElementById("localValueSwitch_" + displayId).className = "ledDotSmallOn";
                                                else if(dashboardDpList[k].displayElements[z].graphicType === 2)
                                                    document.getElementById("localValueSwitch_" + displayId).className = "ledDotMediumOn";
                                                else if(dashboardDpList[k].displayElements[z].graphicType === 3)
                                                    document.getElementById("localValueSwitch_" + displayId).className = "ledDotOnBorder";
                                                else 
                                                    document.getElementById("localValueSwitch_" + displayId).className = "ledDotOn";
                                                if(locValue > 80)
                                                    document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = "lime";
                                                else 
                                                    document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = "orange";
                                            }
                                        }
                                        else if(dashboardType === "ms1") {
                                            if((dashboardDpList[k].pathname === dashboardDpList[i].deviceName + "/Lamp/0/nvoLampFb") || (dashboardDpList[k].pathname === dashboardDpList[i].deviceName + "/Lamp/1/nvoLampFb")
                                                || (dashboardDpList[k].pathname === dashboardDpList[i].deviceName + "/Switch/1/nvoSwitch")){
                                                
                                                if(dashboardDpList[i1].displayElements[i2].locValue !== null) {
                                                    dashboardDpList[i].displayElements[t].dashboardType = "l4";

                                                    element = document.getElementById("localValueSwitch_" + dashboardDpList[i].displayElements[t].displayId);
                                                    if(element !== null) {
                                                        if(dashboardDpList[i].locValue.state === 1) {
                                                            element.className = "ledDotOn";
                                                            if(dashboardDpList[i].displayElements[t].color !== "")
                                                                element.style.backgroundColor =  dashboardDpList[i].displayElements[t].color;
                                                        }
                                                        else {
                                                            element.className = "ledDotOff";
                                                            if(dashboardDpList[i].displayElements[t].backgroundColor !== "")
                                                                element.style.backgroundColor =  dashboardDpList[i].displayElements[t].backgroundColor;
                                                            else
                                                             element.style.backgroundColor =  "transparent";
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        else if(dashboardType === "pg1") {
                                            if((dashboardDpList[k].pathname === dashboardDpList[i].deviceName + "/device/0/nvoLamp1") || (dashboardDpList[k].pathname === dashboardDpList[i].deviceName + "/device/0/nvoLamp2")
                                            (dashboardDpList[k].pathname === dashboardDpList[i].deviceName + "/device/0/nvoSwitch2")) {
                                                
                                                if(dashboardDpList[i1].displayElements[i2].locValue !== null) {
                                                    dashboardDpList[i].displayElements[t].dashboardType = "l4";

                                                    element = document.getElementById("localValueSwitch_" + dashboardDpList[i].displayElements[t].displayId);
                                                    if(element !== null) {
                                                        if(dashboardDpList[i].locValue.state === 1) {
                                                            element.className = "ledDotOn";
                                                            if(dashboardDpList[i].displayElements[t].color !== "")
                                                                element.style.backgroundColor =  dashboardDpList[i].displayElements[t].color;
                                                        }
                                                        else {
                                                            element.className = "ledDotOff";
                                                            if(dashboardDpList[i].displayElements[t].backgroundColor !== "")
                                                                element.style.backgroundColor =  dashboardDpList[i].displayElements[t].backgroundColor;
                                                            else
                                                             element.style.backgroundColor =  "transparent";
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        else if(dashboardType === "s2") {
                                            document.getElementById("localValueSpan_" + displayId).style.removeProperty('background-Color');
                                            if(typeof locValue === "number") {
                                                if(locValue === 1) {
                                                    document.getElementById("localValueSwitch_" + displayId).checked = true;
                                                    if(color !== ""){
                                                        document.getElementById("localValueSpan_" + displayId).style.backgroundColor = color;
                                                    }
                                                }
                                                else { 
                                                    document.getElementById("localValueSwitch_" + displayId).checked = false;
                                                    if(backgroundColor !== ""){
                                                        document.getElementById("localValueSpan_" + displayId).style.backgroundColor = backgroundColor;
                                                    }
                                                }
                                            }
                                            else if(typeof locValue === "boolean") {
                                                if(typeof locValue === "number") {
                                                    if(locValue === 0) {
                                                        document.getElementById("localValueSwitch_" + displayId).checked = false;
                                                        if(backgroundColor !== ""){
                                                            document.getElementById("localValueSpan_" + displayId).style.backgroundColor = backgroundColor;
                                                        }
                                                        
                                                    }
                                                    else { 
                                                        document.getElementById("localValueSwitch_" + displayId).checked = true;
                                                        if(color !== ""){
                                                            document.getElementById("localValueSpan_" + displayId).style.backgroundColor = color;
                                                        }
                                                    }
                                                }
                                                else {
                                                    if(locValue === true) {
                                                        document.getElementById("localValueSwitch_" + displayId).checked = true;
                                                        if(color !== ""){
                                                            document.getElementById("localValueSpan_" + displayId).style.backgroundColor = color;
                                                        }
                                                    }
                                                    else { 
                                                        document.getElementById("localValueSwitch_" + displayId).checked = false;
                                                        if(backgroundColor !== ""){
                                                            document.getElementById("localValueSpan_" + displayId).style.backgroundColor = backgroundColor;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        else if((dashboardType === "s3") || (dashboardType === "s4")) {
                                            document.getElementById("localValueSpan_" + displayId).style.removeProperty('background-Color');
                                            if(dashboardType === "s3")
                                                document.getElementById("localValue_" + displayId).value = locValue.value.toString();
                                            if(locValue.state === 1) {
                                                
                                                if(color !== ""){
                                                    document.getElementById("localValueSpan_" + displayId).style.backgroundColor = color;
                                                }
                                                document.getElementById("localValueSwitch_" + displayId).checked = true;
                                            }
                                            else { 
                                                
                                                if(backgroundColor !== ""){
                                                    document.getElementById("localValueSpan_" + displayId).style.backgroundColor = backgroundColor;
                                                }
                                                document.getElementById("localValueSwitch_" + displayId).checked = false;
                                            }
                                        }
                                        else if((dashboardType === "lr2")   || (dashboardType === "lr4")) {
                                            iTemp = locValue;
                                            if(dashboardType === "lr4") {
                                                try {
                                                    iTemp = locValue.state;
                                                    
                                                }
                                                catch { iTemp = null;}
                                            }
                                            if((typeof iTemp === "number") || (typeof iTemp ===  "boolean")) { //mike
                                                if(z === 0) {
                                                    if(iTemp === 0) {
                                                        if(backgroundColor !== ""){
                                                            document.getElementById("localValueSwitch_" + displayId).style.backgroundColor= backgroundColor;
                                                        }
                                                        else {
                                                            document.getElementById("localValueSwitch_" + displayId).style.backgroundColor= "transparent";
                                                        }
                                                    }
                                                    else {
                                                        if(color !== ""){
                                                            document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = color;
                                                        }
                                                    }
                                                }
                                            }
                                            else if(typeof iTemp === "boolean") {
                                                if(z === 0) {
                                                    if(iTemp === 0) {
                                                        if(backgroundColor !== ""){
                                                            document.getElementById("localValueSwitch_" + displayId).style.backgroundColor= "transparent";
                                                        }
                                                    }
                                                    else { 
                                                        if(backgroundColor !== ""){
                                                            document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = backgroundColor;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        else if(dashboardType === "rbt") {
                                            
                                                value = 0; // used as bContinue
                                                if(typeof locValue === "boolean") {
                                                    value = 1;
                                                    if(locValue)
                                                        locValue = 1;
                                                    else
                                                        locValue = 0;
                                                }
                                                else if(typeof locValue === "string") {
                                                    if(!isNaN(locValue)) {
                                                        value = 1;
                                                        locValue = Number(locValue);
                                                    }
                                                }
                                                else if(typeof locValue === "number")
                                                    value = 1;
                                                if(value === 1) {
                                                    if(typeof locValue === "number") {
                                                        if((locValue === 0) || (locValue === 1)) {
                                                            element = document.getElementById("rbt__" + dashboardDpList[k].displayElements[z].displayId + "_" + locValue);
                                                            if(element !== null) {
                                                                element.checked = true;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        else if (dashboardType === "pb") {
                                            if(g_bEditModeEnabled) {
                                                // pushbutton mmike
                                                element = document.getElementById("localValuePushbuttonOuter_" + dashboardDpList[k].displayElements[z].displayId);
                                                element1 = document.getElementById("localValuePushbuttonInner_" + dashboardDpList[k].displayElements[z].displayId);
                                                if((element !== null) && (element1 !== null)) {
                                                    if(g_sSiteDashboardSelected !== "") {
                                                        color = dashboardDpList[k].displayElements[z].color;
                                                        backgroundColor = dashboardDpList[k].displayElements[z].backgroundColor;
                                                        
                                                        
                                                    }
                                                    else {
                                                        if(typeof dashboardDpList[k].displayElements[z].color !== "undefined") {
                                                            if(dashboardDpList[k].displayElements[z].color !== null) {
                                                                if(dashboardDpList[k].displayElements[z].color !== "") {
                                                                    color = dashboardDpList[k].displayElements[z].color;
                                                                }
                                                            }
                                                        }
                                                        
                                                        if(typeof dashboardDpList[k].displayElements[z].backgroundColor !== "undefined") {
                                                            if(dashboardDpList[k].displayElements[z].backgroundColor !== null) {
                                                                if(dashboardDpList[k].displayElements[z].backgroundColor !== "") {
                                                                    backgroundColor = dashboardDpList[k].displayElements[z].backgroundColor;
                                                                }
                                                            }
                                                        }
                                                        if(typeof dashboardDpList[k].displayElements[z].borderColor !== "undefined") {
                                                            if(dashboardDpList[k].displayElements[z].borderColor !== null) {
                                                                if(dashboardDpList[k].displayElements[z].borderColor !== "") {
                                                                    borderColor = dashboardDpList[k].displayElements[z].borderColor;
                                                                }
                                                            }
                                                        }
                                                    }
                                                    if(typeof locValue === "number") {
                                                        if(locValue === 0) {
                                                            if(backgroundColor !== ""){
                                                                element.style.backgroundColor= backgroundColor;
                                                                element1.style.backgroundColor= backgroundColor;
                                                            }
                                                        }
                                                        else {
                                                            if(backgroundColor !== ""){
                                                                element.style.backgroundColor = color;
                                                                element1.style.backgroundColor = color;
                                                            }
                                                        }
                                                        element.dataset.value = locValue;
                                                    }
                                                    else if(typeof locValue === "boolean") {
                                                        if(locValue === true) {
                                                            locValue = 1;
                                                            if(backgroundColor !== ""){
                                                                element.style.backgroundColor = color;
                                                                element1.style.backgroundColor = color;
                                                            }
                                                        }
                                                        else {
                                                            locValue = 0
                                                            if(backgroundColor !== ""){
                                                                element.style.backgroundColor = backgroundColor;
                                                                element1.style.backgroundColor= backgroundColor;
                                                            }
                                                        }
                                                        element.dataset.value = locValue;
                                                    }
                                                    
                                                }
                                                
                                            }
                                            else {
                                                // PB led dot similar to l2
                                                color = g_sPushbuttonOnBackgroundColor;
                                                backgroundColor = "transparent";
                                                borderColor = "";
                                                if(g_sSiteDashboardSelected !== "") {
                                                    color = dashboardDpList[k].displayElements[z].color;
                                                    backgroundColor = dashboardDpList[k].displayElements[z].backgroundColor;
                                                    borderColor = dashboardDpList[k].displayElements[z].borderColor;
                                                    
                                                }
                                                else {
                                                    if(typeof dashboardDpList[k].displayElements[z].color !== "undefined") {
                                                        if(dashboardDpList[k].displayElements[z].color !== null) {
                                                            if(dashboardDpList[k].displayElements[z].color !== "") {
                                                                color = dashboardDpList[k].displayElements[z].color;
                                                            }
                                                        }
                                                    }
                                                    
                                                    if(typeof dashboardDpList[k].displayElements[z].backgroundColor !== "undefined") {
                                                        if(dashboardDpList[k].displayElements[z].backgroundColor !== null) {
                                                            if(dashboardDpList[k].displayElements[z].backgroundColor !== "") {
                                                                backgroundColor = dashboardDpList[k].displayElements[z].backgroundColor;
                                                            }
                                                        }
                                                    }
                                                    if(typeof dashboardDpList[k].displayElements[z].borderColor !== "undefined") {
                                                        if(dashboardDpList[k].displayElements[z].borderColor !== null) {
                                                            if(dashboardDpList[k].displayElements[z].borderColor !== "") {
                                                                borderColor = dashboardDpList[k].displayElements[z].borderColor;
                                                            }
                                                        }
                                                    }
                                                }
                                                if(typeof locValue === "number") {
                                                    if(locValue === 0) {
                                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotOff";
                                                        if(backgroundColor !== ""){
                                                            document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = backgroundColor;
                                                        }
                                                    }
                                                    else {
                                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotOnBorder";
                                                        if(color !== ""){
                                                            document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = color;
                                                        }
                                                    }
                                                }
                                                else if(typeof locValue === "boolean") {
                                                    if(locValue === true) {
                                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotOnBorder";
                                                        
                                                        if(color !== ""){
                                                            document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = color;
                                                        }
                                                    }
                                                    else {
                                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotOff";
                                                        if(backgroundColor !== ""){
                                                            document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = backgroundColor;
                                                        }
                                                    }
                                                }
                                                if(borderColor !== "")
                                                    document.getElementById("localValueSwitch_" + displayId).style.borderColor = borderColor;
                                            }
                                        }
                                        else if(dashboardType !== "") {
                                            // all others have chart "c", "xi", "xf"
                                            chartIndex = dashboardDpList[k].displayElements[z].chartIndex;
                                            if(chartIndex !== null) {
                                                    // determine if range changed
                                                value = locValue
                                                if(dashboardDpList[k].displayElements[z].custom !== null) {
                                                    if(dashboardDpList[k].displayElements[z].custom.dashboardType ===  "tc") {
                                                        if(dashboardDpList[k].displayElements[z].custom.thermometerObj !==  null) {
                                                            if(dashboardDpList[k].displayElements[z].custom.thermometerObj.style ===  "cf") {
                                                                value = Number( ((1.8 * value) + 32).toFixed(0));
                                                            }
                                                            else if(dashboardDpList[k].displayElements[z].custom.thermometerObj.style ===  "fc") {
                                                                value = Number(( (value - 32) / 1.8).toFixed(1));
                                                            }
                                                        }
                                                    }
                                                }
                                                if(dashboardType === "xi") { // IOX input level -- no longer used
                                                value = value.level;
                                                    if(value === true)
                                                        value = 1;
                                                    else 
                                                        value = 0;
                                                }
                                                else if(dashboardType === "xf") { // IOX input frequency - no longer used
                                                    value = value.freqency;
                                                    
                                                }
                                                if(dashboardDpList[k].displayElements[z].precision !== -1) {
                                                    if(typeof locValue === "number")
                                                        value = dashboardNumToFixedLength(value, dashboardDpList[k].displayElements[z].precision);
                                                }
                                                else if(g_bDashboardMinMaxDecimalPlaces) {
                                                    if(typeof locValue === "number")
                                                        value = dashboardNumToFixedLength(value, g_iDashboardDecimalPlaces);
                                                }
                                                bInitializeChart = false;
                                                if(g_bDashboardChartDynamicRange) {
                                                    bDataEntryRemoved = false;
                                                    if(g_bDashboardSupportLogData) {
                                                        addValueToDashboardChartList(1, chartIndex, value, origLocValue, presetValue, timestamp); // if structure then this is the structured value
                                                        bDataEntryRemoved = checkDashboardChartListRemoveOldEntries(chartIndex, currentTimeMs);
                                                        if(g_dashboardChartList[chartIndex].data.length > 0) {
                                                            if(g_iDashboardChartMaxDuration > 0) {
                                                                if(dashboardChartDetermineStartTime(1, chartIndex, timestamp)) {
                                                                    bDataEntryRemoved = true;
                                                                    bInitializeChart = true;
                                                                }
                                                            }
                                                            else 
                                                                g_dashboardChartList[chartIndex].startTimestamp = g_dashboardChartList[chartIndex].data[0].timestamp
                                                            g_dashboardChartList[chartIndex].endTimestamp = g_dashboardChartList[chartIndex].data[g_dashboardChartList[chartIndex].data.length - 1].timestamp
                                                            g_dashboardChartList[chartIndex].endPtr = g_dashboardChartList[chartIndex].data.length - 1;
                                                            g_dashboardChartList[chartIndex].dataCurrentEntries = g_dashboardChartList[chartIndex].data.length;
                                                            
                                                        }
                                                        else {
                                                            g_dashboardChartList[chartIndex].startTimestamp = null;
                                                            g_dashboardChartList[chartIndex].endTimestamp = null;
                                                            g_dashboardChartList[chartIndex].dataCurrentEntries = 0;
                                                            g_dashboardChartList[chartIndex].startPtr = -1;
                                                            g_dashboardChartList[chartIndex].endPtr = -1;
                                                        }
                                                    }
                                                    if(g_dashboardChartList[chartIndex].data.length === 1) {
                                                        // needed in case the charts are cleared with a clear chart button
                                                        bDataEntryRemoved = true;
                                                        bInitializeChart = true;
                                                    }

                                                    if(bDataEntryRemoved)
                                                        dashboardDetermineChartMinMaxValuesForChart(0, chartIndex, null, true);
                                                    else {
                                                        value2 = value;
                                                        if(g_dashboardChartList[chartIndex].bEnum || g_dashboardChartList[chartIndex].bString)
                                                            value2 = g_dashboardChartList[chartIndex].data[g_dashboardChartList[chartIndex].data.length - 1].value;
                                                        dashboardDetermineChartMinMaxValuesForChart(1, chartIndex, value2, true);
                                                    }
                                                }
                                                else {
                                                    if(value > g_dashboardChartList[chartIndex].maxValue) {
                                                        fvalue = parseFloat(value);
                                                        if(fvalue < 0) 
                                                            fvalue1 = 0;
                                                        else if(fvalue < 1) 
                                                            fvalue1 = 1;
                                                        else if(fvalue < 5)
                                                            fvalue1 = 5;
                                                        else if(fvalue > 1) 
                                                            fvalue1 = (Math.round(fvalue / 10) + 1) * 10;
                                                        g_dashboardChartList[chartIndex].maxValue = fvalue1;
                                                        bInitializeChart = true;
                                                    }
                                                    if(value < g_dashboardChartList[chartIndex].minValue) {
                                                        fvalue = parseFloat(value);
                                                        if(fvalue < 0) 
                                                            fvalue1 = (Math.round(fvalue / 10) - 1) * 10;
                                                        else if(fvalue < 1) 
                                                            fvalue1 = 0;
                                                        else if(fvalue < 5)
                                                            fvalue1 = 0;
                                                        else if(fvalue > 1) 
                                                            fvalue1 = (Math.round(fvalue / 10) - 1) * 10;
                                                        g_dashboardChartList[chartIndex].minValue = fvalue1;
                                                        bInitializeChart = true;
                                                    }
                                                }
                                                if(g_bDashboardNeedToInitializeSvg) {

                                                }
                                                else if(!g_bdashboardChartPause && !g_dashboardChartList[chartIndex].paused) {
                                                    if(bInitializeChart) {
                                                        
                                                        ivInitializeChart1(g_bDashboardSupportLogData, "chartSvg_" + g_dashboardChartList[chartIndex].displayId, g_dashboardChartList[chartIndex].minValue, g_dashboardChartList[chartIndex].maxValue, null, null, g_chartTextColor, null, g_dashboardChartList[chartIndex].chartLabels);
                                                    }
                                                    
                                                    document.getElementById("chartvalue_" + dashboardDpList[k].displayElements[z].displayId).innerHTML = value;
                                                    document.getElementById("chartpreset_" + dashboardDpList[k].displayElements[z].displayId).innerHTML = presetValue;
                                                    dashboardUpdateCharts(chartIndex, value, null);
                                                    
                                                    
                                                }
                                            }
                                        }
                                    } // if(bContinue)
                                }
                                catch (err) {

                                }
                            } //for(z = 0; z < dashboardDpList[k].displayElements.length; z++)
                        }
                        else { // same value but different timestamp
                            for(z = 0; z < dashboardDpList[k].displayElements.length; z++)
                            {
                                if(dashboardDpList[k].displayElements[z].chartIndex !== null) {
                                    chartIndex = dashboardDpList[k].displayElements[z].chartIndex;
                                    value = g_dashboardChartList[chartIndex].data[g_dashboardChartList[chartIndex].data.length - 1].value;
                                    addValueToDashboardChartList(0, chartIndex, value, null, presetValue, timestamp); // if structure then this is the field value
                                    bDataEntryRemoved = checkDashboardChartListRemoveOldEntries(chartIndex, currentTimeMs);
                                    
                                    if(g_dashboardChartList[chartIndex].data.length > 0) {
                                        if(g_iDashboardChartMaxDuration > 0) {
                                            if(dashboardChartDetermineStartTime(1, chartIndex, timestamp)) {
                                                bDataEntryRemoved = true;
                                                bInitializeChart = true;
                                            }
                                        }
                                        else 
                                            g_dashboardChartList[chartIndex].startTimestamp = g_dashboardChartList[chartIndex].data[0].timestamp
                                        g_dashboardChartList[chartIndex].endTimestamp = g_dashboardChartList[chartIndex].data[g_dashboardChartList[chartIndex].data.length - 1].timestamp
                                        g_dashboardChartList[chartIndex].endPtr = g_dashboardChartList[chartIndex].data.length - 1;
                                        g_dashboardChartList[chartIndex].dataCurrentEntries = g_dashboardChartList[chartIndex].data.length;
                                    }
                                    if(bDataEntryRemoved) {
                                        dashboardDetermineChartMinMaxValuesForChart(0, chartIndex, null, true);
                                    }
                                    if(g_bDashboardNeedToInitializeSvg) {

                                    }
                                    else if(!g_bdashboardChartPause  && !g_dashboardChartList[chartIndex].paused) {
                                        if(bInitializeChart)
                                            ivInitializeChart1(g_bDashboardSupportLogData, "chartSvg_" + g_dashboardChartList[chartIndex].displayId, g_dashboardChartList[chartIndex].minValue, g_dashboardChartList[chartIndex].maxValue, null, null, g_chartTextColor, null, g_dashboardChartList[chartIndex].chartLabels);
                                        dashboardUpdateCharts(chartIndex, value, null);
                                    }
                                }
                            }
                        }
                    }
                    catch {}
                    break;
                }
            }
        }
    }
    catch {}
}
function dashboardProcessWriteDpDataUpdateUi(k, dpQualifier) {
    // change all input UI elements but charts after a changing value with menudpvalue
    try {  
        var j, z;
        var value1 = "", value2, presetValue = "",  locValue, locValueStr, valueStr, displayId, origValue;
        var dashboardType, fieldItems, field, bContinue, backgroundColor, chartIndex, sTemp, color;
        var value;
        var obj, obj1;
        var bInitializeChart = false;
        var bDataEntryRemoved = false;
        var d = new Date();
        var currentTimeMs = d.getTime();
        var fieldValue;
        var element, element1;
        if((g_iMainDisplayMode !== DISPLAYMODE_DASHBOARD) && (g_iMainDisplayMode !== DISPLAYMODE_PLANNING))
            return;
        if((k !== -1) && (dpQualifier !== ""))  {
            if(dashboardDpList[k].dpQualifier !== dpQualifier)
                return;
           
            
            
            try {
                bContinue = true;
                if(dashboardDpList[k].cat === "in") {
                                        
                    for(z = 0; z < dashboardDpList[k].displayElements.length; z++)
                    {
                        dashboardType = dashboardDpList[k].displayElements[z].dashboardType;
                        displayId = dashboardDpList[k].displayElements[z].displayId; // ffix88888
                        if(dashboardDpList[k].bStructure) {
                            locValue = {};
                            locValue = JSON.parse(JSON.stringify(dashboardDpList[k].locValue));
                        }
                        else
                            locValue =  dashboardDpList[k].locValue;
                        locValueStr = "";
                        locValueStr = dashboardDpList[k].locValueStr;
                        presetValue = dashboardDpList[k].presetValue;
                        if(presetValue === " ")
                            presetValue = "";
                        field = dashboardDpList[k].displayElements[z].field;
                        color = dashboardDpList[k].displayElements[z].color;
                        backgroundColor = dashboardDpList[k].displayElements[z].backgroundColor;
                        bContinue = true;
                        if(field !== "") {
                            presetValue = "";
                            
                            if(typeof locValue === "object") {
                                bContinue = false;
                                fieldValue = readFieldValue(locValue, field);
                                if(fieldValue.valid) {
                                    locValue = fieldValue.data;
                                    bContinue = true;
                                }
                                /*
                                fieldItems = field.split("/");
                                for(j=0; j < fieldItems.length; j ++)
                                {
                                    field = fieldItems[j].trim();
                                    if(field != "") {
                                        if(locValue.hasOwnProperty(field)) {
                                            locValue = locValue[field];
                                            if(j === (fieldItems.length - 1))
                                                bContinue = true;
                                        }
                                    }
                                    else {
                                        bContinue = false;
                                        break;
                                    } 

                                }
                                */
                            }
                            else 
                                bContinue = false;
                            if(bContinue) {
                                
                                if(typeof locValue === "object") {
                                    //displayElement.bStructure = true;
                                    locValueStr = JSON.stringify(locValue);
                                    if(locValueStr.length > 2) {
                                        if((locValueStr.charAt(0) === "{") && (locValueStr.charAt(locValueStr.length - 1) === "}")) {
                                            locValueStr = locValueStr.substr(1, (locValueStr.length - 2));
                                        }
                                    }
                                }
                                else if(typeof locValue === "string") {
                                    

                                }
                                else if(typeof locValue === "number") {
                                    
                                    locValueStr = locValue.toString();
                                }
                                else if(typeof locValue === "boolean") {
                                    
                                    locValueStr = locValue.toString();
                                }
                            }
                        }
                        else {
                            if(typeof locValue === "object") {
                                //displayElement.bStructure = true;
                                locValueStr = JSON.stringify(locValue);
                                if(locValueStr.length > 2) {
                                    if((locValueStr.charAt(0) === "{") && (locValueStr.charAt(locValueStr.length - 1) === "}")) {
                                        locValueStr = locValueStr.substr(1, (locValueStr.length - 2));
                                    }
                                }
                            }
                        }
                        
                        
                        if(bContinue) {
                            
                            if((dashboardType === "n") || (dashboardType === "r") || (dashboardType === "s0") || (dashboardType === "s1")) {
                                if((dashboardType === "n") || (dashboardType === "r")) {
                                    if(g_bDashboardMinMaxDecimalPlaces) {
                                        if(typeof locValue === "number")
                                            locValueStr = dashboardNumToFixedLength(locValue, g_iDashboardDecimalPlaces);
                                    }
                                }
                                if((dashboardDpList[k].displayElements[z].field === "") && (presetValue !== ""))
                                    locValueStr = presetValue;
                                if((dashboardDpList[k].cat === "in") && (dashboardType !== "r") && (dashboardType !== "s1"))
                                    document.getElementById("localValue_" + displayId).value = locValueStr;  //locValue required for input
                                else
                                    document.getElementById("localValue_" + displayId).innerHTML = locValueStr;
                                //document.getElementById("timestamp_" + dashboardDpList[k].pathname).innerHTML = dashboardDpList[k].timestampStr;
                            }
                            else if((dashboardType === "a") && (!dashboardDpList[k].displayElements[z].readonly)) { //SNVT_str_ascii
                                locValueStr = value1.ascii;
                                if(presetValue !== "")
                                    locValueStr = presetValue;
                                if(dashboardDpList[k].cat === "in")
                                    document.getElementById("localValue_" + displayId).innerHTML = locValueStr;
                                else
                                    document.getElementById("localValue_" + displayId).innerHTML = locValueStr;
                                //document.getElementById("timestamp_" + dashboardDpList[k].pathname).innerHTML = dashboardDpList[k].timestampStr;
                            }
                            else if((dashboardType === "d") && (!dashboardDpList[k].displayElements[z].readonly)) { //drop down in table
                                if(presetValue !== "")
                                    locValueStr = presetValue;
                                if(typeof locValueStr === "string") {
                                    if(locValueStr.charAt(0) === "\"")
                                        if(locValueStr.length > 1)
                                            locValueStr = locValueStr.substr(1,locValueStr.length - 2);
                                }
                                document.getElementById("localValue_" + displayId).value = locValueStr;
                                
                            }
                            else if(dashboardType === "l2") {
                                if(typeof locValue === "number") {
                                    if(locValue === 0) {
                                        if(dashboardDpList[k].displayElements[z].graphicType === 1)
                                            document.getElementById("localValueSwitch_" + displayId).className = "ledDotSmallOff";
                                        else if(dashboardDpList[k].displayElements[z].graphicType === 2)
                                            document.getElementById("localValueSwitch_" + displayId).className = "ledDotMediumOff";
                                        else 
                                            document.getElementById("localValueSwitch_" + displayId).className = "ledDotOff";
                                        if(backgroundColor !== ""){
                                            document.getElementById("localValueSwitch_" + displayId).style.backgroundColor= "transparent";
                                        }
                                    }
                                    else {
                                        if(dashboardDpList[k].displayElements[z].graphicType === 1)
                                            document.getElementById("localValueSwitch_" + displayId).className = "ledDotSmallOn";
                                        else if(dashboardDpList[k].displayElements[z].graphicType === 2)
                                            document.getElementById("localValueSwitch_" + displayId).className = "ledDotMediumOn";
                                        else if(dashboardDpList[k].displayElements[z].graphicType === 3)
                                            document.getElementById("localValueSwitch_" + displayId).className = "ledDotOnBorder";
                                        else 
                                            document.getElementById("localValueSwitch_" + displayId).className = "ledDotOn";
                                        if(backgroundColor !== ""){
                                            document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = backgroundColor;
                                        }
                                    }
                                }
                                else if(typeof locValue === "boolean") {
                                    if(locValue === true) {
                                        if(dashboardDpList[k].displayElements[z].graphicType === 1)
                                            document.getElementById("localValueSwitch_" + displayId).className = "ledDotSmallOn";
                                        else if(dashboardDpList[k].displayElements[z].graphicType === 2)
                                            document.getElementById("localValueSwitch_" + displayId).className = "ledDotMediumOn";
                                        else if(dashboardDpList[k].displayElements[z].graphicType === 3)
                                            document.getElementById("localValueSwitch_" + displayId).className = "ledDotOnBorder";
                                        else 
                                            document.getElementById("localValueSwitch_" + displayId).className = "ledDotOn";
                                        if(backgroundColor !== ""){
                                            document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = backgroundColor;
                                        }
                                    }
                                    else {
                                        if(dashboardDpList[k].displayElements[z].graphicType === 1)
                                            document.getElementById("localValueSwitch_" + displayId).className = "ledDotSmallOff";
                                        else if(dashboardDpList[k].displayElements[z].graphicType === 2)
                                            document.getElementById("localValueSwitch_" + displayId).className = "ledDotMediumOff";
                                        else 
                                            document.getElementById("localValueSwitch_" + displayId).className = "ledDotOff";
                                        if(backgroundColor !== ""){
                                            document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = "transparent";
                                        }
                                    }
                                }
                            }
                            else if((dashboardType === "l3") || (dashboardType === "l4")) {
                                if(dashboardType === "l3")
                                    document.getElementById("localValue_" + displayId).innerHTML = locValue.value.toString();
                                if(locValue.state === 1) {
                                    if(dashboardDpList[k].displayElements[z].graphicType === 1)
                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotSmallOn";
                                    else if(dashboardDpList[k].displayElements[z].graphicType === 2)
                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotMediumOn";
                                    else if(dashboardDpList[k].displayElements[z].graphicType === 3)
                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotOnBorder";
                                    else 
                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotOn";
                                    if(color !== ""){
                                        document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = color;
                                    }
                                }
                                else {
                                    if(dashboardDpList[k].displayElements[z].graphicType === 1)
                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotSmallOff";
                                    else if(dashboardDpList[k].displayElements[z].graphicType === 2)
                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotMediumOff";
                                    else 
                                        document.getElementById("localValueSwitch_" + displayId).className = "ledDotOff";
                                    if(backgroundColor !== ""){
                                        document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = backgroundColor;
                                    }
                                    else
                                        document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = "transparent";
                                }
                            }
                            else if(dashboardType === "s2") {
                                if(typeof locValue === "number") {
                                    if(locValue === 1) {
                                        document.getElementById("localValueSwitch_" + displayId).checked = true;
                                        if(color !== ""){
                                            document.getElementById("localValueSpan_" + displayId).style.backgroundColor = color;
                                        }
                                    }
                                    else { 
                                        document.getElementById("localValueSwitch_" + displayId).checked = false;
                                        if(backgroundColor !== ""){
                                            document.getElementById("localValueSpan_" + displayId).style.backgroundColor = backgroundColorr;
                                        }
                                    }
                                }
                                else if(typeof locValue === "boolean") {
                                    if(typeof locValue === "number") {
                                        if(locValue === 0) {
                                            document.getElementById("localValueSwitch_" + displayId).checked = false;
                                            if(backgroundColor !== ""){
                                                document.getElementById("localValueSpan_" + displayId).style.backgroundColor = backgroundColor;
                                            }
                                            
                                        }
                                        else { 
                                            document.getElementById("localValueSwitch_" + displayId).checked = true;
                                            if(color !== ""){
                                                document.getElementById("localValueSpan_" + displayId).style.backgroundColor = color;
                                            }
                                        }
                                    }
                                    else {
                                        if(locValue === true) {
                                            document.getElementById("localValueSwitch_" + displayId).checked = true;
                                            if(color !== ""){
                                                document.getElementById("localValueSpan_" + displayId).style.backgroundColor = color;
                                            }
                                        }
                                        else { 
                                            document.getElementById("localValueSwitch_" + displayId).checked = false;
                                            if(backgroundColor !== ""){
                                                document.getElementById("localValueSpan_" + displayId).style.backgroundColor = backgroundColor;
                                            }
                                        }
                                    }
                                }
                            }
                            else if((dashboardType === "s3") || (dashboardType === "s4")) {
                                if(dashboardType === "s3")
                                    document.getElementById("localValue_" + displayId).value = locValue.value.toString();
                                if(locValue.state === 1) {
                                    
                                    if(color !== ""){
                                        document.getElementById("localValueSpan_" + displayId).style.backgroundColor = color;
                                    }
                                    document.getElementById("localValueSwitch_" + displayId).checked = true;
                                }
                                else { 
                                    
                                    if(backgroundColor !== ""){
                                        document.getElementById("localValueSpan_" + displayId).style.backgroundColor = backgroundColor;
                                    }
                                    document.getElementById("localValueSwitch_" + displayId).checked = false;
                                }
                            }
                            else if(dashboardType === "pb") {
                                //add code
                                
                                if(g_bEditModeEnabled) {
                                    // pushbutton
                                    element = document.getElementById("localValuePushbuttonOuter_" + dashboardDpList[k].displayElements[z].displayId);
                                    element1 = document.getElementById("localValuePushbuttonInner_" + dashboardDpList[k].displayElements[z].displayId);
                                    if((element !== null) && (element1 !== null)) {
                                        if(g_sSiteDashboardSelected !== "") {
                                            color = dashboardDpList[k].displayElements[z].color;
                                            backgroundColor = dashboardDpList[k].displayElements[z].backgroundColor;
                                            
                                            
                                        }
                                        if(typeof locValue === "number") {
                                            if(locValue === 0) {
                                                if(backgroundColor !== ""){
                                                    element.style.backgroundColor= backgroundColor;
                                                    element1.style.backgroundColor= backgroundColor;
                                                }
                                            }
                                            else {
                                                if(backgroundColor !== ""){
                                                    element.style.backgroundColor = color;
                                                    element1.style.backgroundColor = color;
                                                }
                                            }
                                            element.dataset.value = locValue;
                                        }
                                        else if(typeof locValue === "boolean") {
                                            if(locValue === true) {
                                                locValue = 1;
                                                if(backgroundColor !== ""){
                                                    element.style.backgroundColor = color;
                                                    element1.style.backgroundColor = color;
                                                }
                                            }
                                            else {
                                                locValue = 0
                                                if(backgroundColor !== ""){
                                                    element.style.backgroundColor = backgroundColor;
                                                    element1.style.backgroundColor= backgroundColor;
                                                }
                                            }
                                            element.dataset.value = locValue;
                                        }
                                        
                                    }
                                    
                                }
                                else {
                                    // PB led dot similar to l2
                                    color = g_sPushbuttonOnBackgroundColor;
                                    backgroundColor = "transparent";
                                    borderColor = "";
                                    if(g_sSiteDashboardSelected !== "") {
                                        color = dashboardDpList[k].displayElements[z].color;
                                        backgroundColor = dashboardDpList[k].displayElements[z].backgroundColor;
                                        borderColor = dashboardDpList[k].displayElements[z].borderColor;
                                        
                                    }
                                    if(typeof locValue === "number") {
                                        if(locValue === 0) {
                                            document.getElementById("localValueSwitch_" + displayId).className = "ledDotOff";
                                            if(backgroundColor !== ""){
                                                document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = backgroundColor;
                                            }
                                        }
                                        else {
                                            document.getElementById("localValueSwitch_" + displayId).className = "ledDotOnBorder";
                                            if(color !== ""){
                                                document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = color;
                                            }
                                        }
                                    }
                                    else if(typeof locValue === "boolean") {
                                        if(locValue === true) {
                                            document.getElementById("localValueSwitch_" + displayId).className = "ledDotOnBorder";
                                            
                                            if(color !== ""){
                                                document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = color;
                                            }
                                        }
                                        else {
                                            document.getElementById("localValueSwitch_" + displayId).className = "ledDotOff";
                                            if(backgroundColor !== ""){
                                                document.getElementById("localValueSwitch_" + displayId).style.backgroundColor = backgroundColor;
                                            }
                                        }
                                    }
                                    if(borderColor !== "")
                                        document.getElementById("localValueSwitch_" + displayId).style.borderColor = borderColor;
                                }
                                
                            }
                            else if(dashboardType !== "") {
                                // all others have chart "c", "xi", "xf" do nothing
                            }
                            
                        } // if(bContinue)
                        if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
                            // update any priority buttons
                            element = document.getElementById("dpValueMenu_" + displayId);
                            if(element !== null) {
                                sTemp = "...";
                                if((Number(dashboardDpList[k].priority) === 17) || (g_iCurrentPriorityButtonType === 1))
                                    sTemp = "...";
                                else
                                    sTemp = "P " + dashboardDpList[k].priority;
                                if(element.innerHTML !== sTemp)
                                    element.innerHTML = sTemp;
                            }
                        }
                    } //for(z = 0; z < dashboardDpList[k].displayElements.length; z++)
                }
                
            }
            catch {}
        }
    }
    catch {}
}
function dashboardEditCheckBox() {
	var min;
	
    var element = document.getElementById("editButton");
    if(element !== null) {
        if(element.checked) {
            g_bEditModeEnabled = true;
        }
        else
            g_bEditModeEnabled = false;

        dashboardEditButtonProcess();
    }
	
}
function dashboardEditButtonProcess() {
    // there are three types of display elements
    //  1. dahsboard Table - when edit disabled do nothing when datapoint clicked. When edit enabled, has priority menu
    //  2. context table - when edit disabled go to device dashboard.  When edit enabled, has priority menu
    //  3. grapic can be in dashboard or context views, no priority menu, has fixed priority 
    // types with "_grapics" means in edit disable will go to device dashboard when clicked
    try {
        var i, z, table, element = null, element2, index, deIndex, displayId, dashboardType, tempContent = "", value, locValue;
        var color, backgroundColor, borderColor, sTemp1;
        var deviceId, deviceName;
        var displayId;
        if(g_iShowEditButton > 0) {
            if(g_sliderSwitchEditType === 0) {
                if(g_bEditModeEnabled)
                    document.documentElement.style.setProperty("--switchslider-backgroundColor", g_sSliderBackgroundColor);
                else
                    document.documentElement.style.setProperty("--switchslider-backgroundColor", g_sSliderDisabledBackgroundColor);
            }
            if(g_editButtonElementList.length > 0) {
                for(i=0; i < g_editButtonElementList.length; i++)
                {
                    try {
                        element = null;
                        displayId = g_editButtonElementList[i].displayId;
                        if(g_editButtonElementList[i].type === "rbt_graphic")
                            displayId += "_0";
                        element = document.getElementById(displayId);
                        if(element !== null) {
                            try {
                                if((g_editButtonElementList[i].action === "disable") || (g_editButtonElementList[i].action === "visible")) {
                                    if(g_bEditModeEnabled) {
                                        if((g_editButtonElementList[i].type === "s2_graphic") || (g_editButtonElementList[i].type === "s3_graphic") || (g_editButtonElementList[i].type === "s4_graphic")) {

                                        }
                                        else if((g_editButtonElementList[i].type === "s2") || (g_editButtonElementList[i].type === "s3") || (g_editButtonElementList[i].type === "s4")) {
                                            element.disabled = false;
                                            if(g_sliderSwitchEditType === 1) {
                                                // check default type
                                                index = g_editButtonElementList[i].dpIndex;
                                                deIndex = g_editButtonElementList[i].displayElementIndex;
                                                displayId = g_editButtonElementList[i].baseDisplayId;
                                                color = dashboardDpList[index].displayElements[deIndex].color;
                                                backgroundColor = dashboardDpList[index].displayElements[deIndex].backgroundColor;
                                                
                                                if(dashboardDpList[index].displayElements[deIndex].displayId === displayId) {
                                                    tempContent = "";
                                                    element2 = document.getElementById("sliderSwitch_" + displayId);
                                                    if(element2 !== null) {
                                                        tempContent += "<label class=\"sliderSwitch\" ><input type=\"checkbox\"";
                                                        tempContent += " id=\"localValueSwitch_" + displayId + "\" onclick=\"sliderSwitchClicked(this, '" + displayId + "', " + index + ", " + deIndex + ")\" class=\"sliderInput\" ";
                                                        if((g_editButtonElementList[i].type === "s3") || (g_editButtonElementList[i].type === "s4")) {
                                                            if(dashboardDpList[index].locValue.state === 1)
                                                                tempContent += ' checked';
                                                            tempContent += '><span id="localValueSpan_' + displayId + '" class="sliderSlider sliderRound"';
                                                            if(color !== "") {
                                                                if(dashboardDpList[index].locValue.state === 1)
                                                                    tempContent +=  ' style="background-Color:' + color + '"';
                                                            }
                                                            tempContent += '></span></label>'
                                                        }
                                                        else if (g_editButtonElementList[i].type === "s2") {
                                                            locValue = dashboardDpList[index].locValue;
                                                            if(typeof locValue === "number") {
                                                                if(locValue === 1) {
                                                                    tempContent += ' checked';
                                                                }
                                                                tempContent += '><span id="localValueSpan_' + displayId + '" class="sliderSlider sliderRound"';
                                                                if(color !== "") {
                                                                    if(locValue === 1)
                                                                        tempContent +=  ' style="background-Color:' + color + '"';
                                                                }
                                                                tempContent += '></span></label>'
                                                            }
                                                            else if(typeof locValue === "boolean") {
                                                                if(typeof locValue === "number") {
                                                                    if(locValue === 1) {
                                                                        tempContent += ' checked';
                                                                    }
                                                                    tempContent += '><span id="localValueSpan_' + displayId + '" class="sliderSlider sliderRound"';
                                                                    if(color !== "") {
                                                                        if(locValue === 1)
                                                                            tempContent +=  ' style="background-Color:' + color + '"';
                                                                    }
                                                                    tempContent += '></span></label>'
                                                                }
                                                                else {
                                                                    if(locValue === true) {
                                                                        tempContent += ' checked';
                                                                    }
                                                                    tempContent += '><span id="localValueSpan_' + displayId + '" class="sliderSlider sliderRound"';
                                                                    if(color !== "") {
                                                                        if(locValue === true)
                                                                            tempContent +=  ' style="background-Color:' + color + '"';
                                                                    }
                                                                    tempContent += '></span></label>'
                                                                }
                                                            }
                                                        }
                                                        
                                                        element2.innerHTML = tempContent;
                                                        dashboardDpList[index].displayElements[deIndex].dashboardType = g_editButtonElementList[i].type;
                                                    }
                                                }
                                            }
                                        }
                                        else if(g_editButtonElementList[i].type === "pb_graphic") {
                                            element.disabled = false;
                                            // check default type
                                            index = g_editButtonElementList[i].dpIndex;
                                            deIndex = g_editButtonElementList[i].displayElementIndex;
                                            displayId = g_editButtonElementList[i].baseDisplayId;
                                            color = g_sPushbuttonOnBackgroundColor;
                                            backgroundColor = g_sPushbuttonOffBackgroundColor; //"transparent";
                                            borderColor = "";
                                            if(g_sSiteDashboardSelected !== "") {
                                                color = dashboardDpList[index].displayElements[deIndex].color;
                                                backgroundColor = dashboardDpList[index].displayElements[deIndex].backgroundColor;
                                                borderColor = dashboardDpList[index].displayElements[deIndex].borderColor;
                                                if(borderColor !== "")
                                                    borderColor = ";border-Color:" + borderColor;
                                            }
                                            else {
                                                if(typeof dashboardDpList[index].displayElements[deIndex].color !== "undefined") {
                                                    if(dashboardDpList[index].displayElements[deIndex].color !== null) {
                                                        if(dashboardDpList[index].displayElements[deIndex].color !== "") {
                                                            color = dashboardDpList[index].displayElements[deIndex].color;
                                                        }
                                                    }
                                                }
                                                
                                                if(typeof dashboardDpList[index].displayElements[deIndex].backgroundColor !== "undefined") {
                                                    if(dashboardDpList[index].displayElements[deIndex].backgroundColor !== null) {
                                                        if(dashboardDpList[index].displayElements[deIndex].backgroundColor !== "") {
                                                            backgroundColor = dashboardDpList[index].displayElements[deIndex].backgroundColor;
                                                        }
                                                    }
                                                }
                                                if(typeof dashboardDpList[index].displayElements[deIndex].borderColor !== "undefined") {
                                                    if(dashboardDpList[index].displayElements[deIndex].borderColor !== null) {
                                                        if(dashboardDpList[index].displayElements[deIndex].borderColor !== "") {
                                                            borderColor = ";border-Color:" + dashboardDpList[index].displayElements[deIndex].borderColor;
                                                        }
                                                    }
                                                }
                                            }
                                            
                                            if(dashboardDpList[index].displayElements[deIndex].displayId === displayId) {
                                                tempContent = "";
                                                element2 = document.getElementById("pushbuttonDiv_" + displayId);
                                                sTemp1 = "";
                                                if(element2 !== null) {
                                                    locValue = dashboardDpList[index].locValue;
                                                    z = 0;
                                                    
                                                    if((typeof locValue === "number") || (typeof locValue ===  "boolean")) { //mike
                                                        if(z === 0) {
                                                            if(locValue === 0) {
                                                                if(backgroundColor !== ""){
                                                                    sTemp1 = " style=\"background-Color:" + backgroundColor + borderColor + "\"";
                                                                }
                                                            }
                                                            else {
                                                                value = 1;
                                                                if(color !== ""){
                                                                    sTemp1 = " style=\"background-Color:" + color + borderColor + "\"";
                                                                }
                                                            }
                                                        }
                                                    }
                                                    else if(typeof locValue === "boolean") {
                                                        if(z === 0) {
                                                            if(locValue === 0) {
                                                                if(backgroundColor !== ""){
                                                                    sTemp1 = " style=\"background-Color:" + backgroundColor + borderColor + "\"";
                                                                }
                                                            }
                                                            else { 
                                                                if(color !== ""){
                                                                    sTemp1 = " style=\"background-Color:" + color + borderColor + "\"";
                                                                }
                                                            }
                                                        }
                                                    }

                                                    tempContent += '<div id="localValuePushbuttonOuter_' + displayId + '" ';
                    
                                                    tempContent += 'class="pushbuttonOuter" ' + sTemp1;
                                                    if(typeof dashboardDpList[index].displayElements[deIndex].fullLabel !== "undefined") {
                                                        if(dashboardDpList[index].displayElements[deIndex].fullLabel !== "")
                                                            tempContent += "\" title=\"" + dashboardDpList[index].displayElements[deIndex].fullLabel + "\"";
                                                    }
                                                    tempContent += " data-value=\"" + locValue + "\"";
                                                    tempContent += " onclick=\"pushButtonClicked(this, '" + displayId + "', " + index + ", " + deIndex + ")\"";
                                                    tempContent += '>';
                                                    tempContent += '<div id="localValuePushbuttonInner_' + displayId + '" class="pushbuttonInnerBorder" ' + sTemp1 + '></div></div>';
                                                    element2.innerHTML = tempContent;
                                                    dashboardDpList[index].displayElements[deIndex].dashboardType = "pb"; //g_editButtonElementList[i].type;
                                                }
                                            }
                                            
                                        }
                                        else if (g_editButtonElementList[i].type === "s1") {
                                            element.disabled = false;
                                            element.style.borderColor = "black";
                                        }
                                        else if (g_editButtonElementList[i].type === "sl") {
                                            element.disabled = false;
                                            element.style.borderColor = "black";
                                        }
                                        else if (g_editButtonElementList[i].type === "input") {
                                            //element.style.borderColor = "black";
                                            //ffixMBW need to add code for editmode - not edit then clicking goes to device dashboard
                                            element.disabled = false;
                                            element.style.borderStyle = "inset";
                                        }
                                        else if (g_editButtonElementList[i].type === "input_graphic") {
                                            //element.style.borderColor = "black";
                                            //ffixMBW need to add code for editmode - not edit then clicking goes to device dashboard
                                            element.disabled = false;
                                            element.style.borderStyle = "inset";
                                        }
                                        else if (g_editButtonElementList[i].type === "b") { //} ((g_editButtonElementList[i].type === "b") && (g_sSiteDashboardSelected !== "")) {
                                            //element.style.borderColor = "black";
                                            element.disabled = false;
                                            element.style.visibility = "visible";
                                        }
                                        else if(g_editButtonElementList[i].type === "rbt_graphic") { //radio button
                                            element = document.getElementById(g_editButtonElementList[i].displayId + "_0");
                                            if(element !== null)
                                                element.disabled = false;
                                            element = document.getElementById(g_editButtonElementList[i].displayId + "_1");
                                            if(element !== null)
                                                element.disabled = false;
                                        }
                                        else if (g_editButtonElementList[i].type === "d_graphic") {
                                            element.disabled = false;
                                        }
                                        else if (g_editButtonElementList[i].type === "d") {
                                            element.disabled = false;
                                        }
                                        else if (g_editButtonElementList[i].type === "menu") {
                                            element.disabled = false;
                                        }
                                    }
                                    else { 
                                        // read-only mode 
                                        if((g_editButtonElementList[i].type === "s2") || (g_editButtonElementList[i].type === "s3") || (g_editButtonElementList[i].type === "s4")
                                            || (g_editButtonElementList[i].type === "s2_graphic") || (g_editButtonElementList[i].type === "s3_graphic") || (g_editButtonElementList[i].type === "s4_graphic")) {
                                            // show as l2, l3 or l4 instead
                                            element.disabled = true;
                                            if(g_sliderSwitchEditType === 1) {
                                                index = g_editButtonElementList[i].dpIndex;
                                                deIndex = g_editButtonElementList[i].displayElementIndex;
                                                displayId = g_editButtonElementList[i].baseDisplayId;
                                                color = dashboardDpList[index].displayElements[deIndex].color;
                                                backgroundColor = dashboardDpList[index].displayElements[deIndex].backgroundColor;
                                                deviceId = dashboardDpList[index].deviceId;
                                                deviceName = dashboardDpList[index].deviceName;
                                                if(dashboardDpList[index].displayElements[deIndex].displayId === displayId) {
                                                    tempContent = "";
                                                    element2 = document.getElementById("sliderSwitch_" + displayId);
                                                    if(element2 !== null) {
                                                        tempContent += '<span id="localValueSwitch_' + displayId + '"'; 
                                                        if((g_editButtonElementList[i].type === "s3") || (g_editButtonElementList[i].type === "s4")
                                                            || (g_editButtonElementList[i].type === "s3_graphic") || (g_editButtonElementList[i].type === "s4_graphic")) {
                                                            if(dashboardDpList[index].locValue.state === 1) {
                                                                tempContent += ' class="ledDotOn"';
                                                                if(color !== "")
                                                                    tempContent += ' style="background-Color:' + color + '"';
                                                            }
                                                            else { 
                                                                tempContent += ' class="ledDotOff"';
                                                                if(backgroundColor !== "")
                                                                    tempContent +=  ' style="background-color:' + backgroundColor + '"';
                                                                else
                                                                    tempContent +=  ' style="background-color:transparent"';
                                                            }
                                                        }
                                                        else if ((g_editButtonElementList[i].type === "s2") || (g_editButtonElementList[i].type === "s2_graphic")) {
                                                            locValue = dashboardDpList[index].locValue;
                                                            if(typeof locValue === "number") {
                                                                if(locValue === 1) {
                                                                    tempContent += ' class="ledDotOn"';
                                                                    if(color !== "")
                                                                        tempContent +=  ' style="background-Color:' + color + '"';
                                                                }
                                                                else { 
                                                                    tempContent += ' class="ledDotOff"';
                                                                    if(backgroundColor !== "")
                                                                        tempContent +=  ' style="background-color:' + backgroundColor + '"';
                                                                    else
                                                                        tempContent +=  ' style="background-color:transparent"';
                                                                }
                                                            }
                                                            else if(typeof locValue === "boolean") {
                                                                if(typeof locValue === "number") {
                                                                    if(locValue === 0) {
                                                                        tempContent += ' class="ledDotOff"';
                                                                        if(backgroundColor !== "")
                                                                            tempContent +=  ' style="background-color:' + backgroundColor + '"';
                                                                        else
                                                                            tempContent +=  ' style="background-color:transparent"';
                                                                    }
                                                                    else { 
                                                                        tempContent += ' class="ledDotOn"';
                                                                        if(color !== "")
                                                                            tempContent +=  ' style="background-Color:' + color + '"';
                                                                    }
                                                                }
                                                                else {
                                                                    if(locValue === true) {
                                                                        tempContent += ' class="ledDotOn"';
                                                                        if(color !== "")
                                                                            tempContent +=  ' style="background-Color:' + color + '"';
                                                                    }
                                                                    else { 
                                                                        tempContent += ' class="ledDotOff"';
                                                                        if(backgroundColor !== "")
                                                                            tempContent +=  ' style="background-color:' + backgroundColor + '"';
                                                                        else
                                                                            tempContent +=  ' style="background-color:transparent"';
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        if((g_editButtonElementList[i].type === "s2_graphic") || (g_editButtonElementList[i].type === "s3_graphic") || (g_editButtonElementList[i].type === "s4_graphic"))
                                                            tempContent += "onclick=\"getPlanningTreeShowDashboard(0,'Device_" + g_editButtonElementList[i].deviceId + "','" + g_editButtonElementList[i].deviceName + "')\"";
                                                        tempContent += '></span>'; //mike
                                                        element2.innerHTML = tempContent;
                                                        dashboardDpList[index].displayElements[deIndex].dashboardType = "l" + g_editButtonElementList[i].type.charAt(1);
                                                    }
                                                }
                                            }
                                        }
                                        else if(g_editButtonElementList[i].type === "pb_graphic") {
                                            // LED like l2
                                            // check default type
                                            element.disabled = true;
                                            index = g_editButtonElementList[i].dpIndex;
                                            deIndex = g_editButtonElementList[i].displayElementIndex;
                                            displayId = g_editButtonElementList[i].baseDisplayId;
                                            color = g_sPushbuttonOnBackgroundColor;
                                            backgroundColor = g_sPushbuttonOffBackgroundColor; //"transparent";
                                            borderColor = "";
                                            if(g_sSiteDashboardSelected !== "") {
                                                color = dashboardDpList[index].displayElements[deIndex].color;
                                                backgroundColor = dashboardDpList[index].displayElements[deIndex].backgroundColor;
                                                borderColor = dashboardDpList[index].displayElements[deIndex].borderColor;
                                                if(borderColor !== "")
                                                    borderColor = ";border-Color:" + borderColor;
                                            }
                                            else {
                                                if(typeof dashboardDpList[index].displayElements[deIndex].color !== "undefined") {
                                                    if(dashboardDpList[index].displayElements[deIndex].color !== null) {
                                                        if(dashboardDpList[index].displayElements[deIndex].color !== "") {
                                                            color = dashboardDpList[index].displayElements[deIndex].color;
                                                        }
                                                    }
                                                }
                                                
                                                if(typeof dashboardDpList[index].displayElements[deIndex].backgroundColor !== "undefined") {
                                                    if(dashboardDpList[index].displayElements[deIndex].backgroundColor !== null) {
                                                        if(dashboardDpList[index].displayElements[deIndex].backgroundColor !== "") {
                                                            backgroundColor = dashboardDpList[index].displayElements[deIndex].backgroundColor;
                                                        }
                                                    }
                                                }
                                                
                                                
                                                
                                                if(typeof dashboardDpList[index].displayElements[deIndex].borderColor !== "undefined") {
                                                    if(dashboardDpList[index].displayElements[deIndex].borderColor !== null) {
                                                        if(dashboardDpList[index].displayElements[deIndex].borderColor !== "") {
                                                            borderColor = ";border-Color:" + dashboardDpList[index].displayElements[deIndex].borderColor;
                                                        }
                                                    }
                                                }
                                            }
                                            if(dashboardDpList[index].displayElements[deIndex].displayId === displayId) {
                                                tempContent = "";
                                                element2 = document.getElementById("pushbuttonDiv_" + displayId);
                                                sTemp1 = "";
                                                if(element2 !== null) {
                                                    locValue = dashboardDpList[index].locValue;
                                                    z = 0;
                                                    if((typeof locValue === "number") || (typeof locValue ===  "boolean")) { //mike
                                                        if(z === 0) {
                                                            if(locValue === 0) {
                                                                if(backgroundColor !== ""){
                                                                    sTemp1 = " style=\"background-Color:" + backgroundColor + borderColor + "\"";
                                                                }
                                                            }
                                                            else {
                                                                if(color !== ""){
                                                                    sTemp1 = " style=\"background-Color:" + color + borderColor + "\"";
                                                                }
                                                            }
                                                        }
                                                    }
                                                    else if(typeof locValue === "boolean") {
                                                        if(z === 0) {
                                                            if(locValue === 0) {
                                                                if(backgroundColor !== ""){
                                                                    sTemp1 = " style=\"background-Color:" + ackgroundColor + borderColor + "\"";
                                                                }
                                                            }
                                                            else { 
                                                                if(color !== ""){
                                                                    sTemp1 = " style=\"background-Color:" + color + borderColor + "\"";
                                                                }
                                                            }
                                                        }
                                                    }
                                                    tempContent += '<span id="localValueSwitch_' + dashboardDpList[index].displayElements[deIndex].displayId + '"';
                                                    if(typeof dashboardDpList[index].displayElements[deIndex].fullLabel !== "undefined") {
                                                        if(dashboardDpList[index].displayElements[deIndex].fullLabel !== "")
                                                            tempContent += "\" title=\"" + dashboardDpList[index].displayElements[deIndex].fullLabel + "\"";
                                                    }
                                                    if((g_sSiteDashboardSelected !== "") && g_bSiteDashboardClickDpPathToDevice) 
                                                        tempContent += "  onclick=\"getPlanningTreeShowDashboard(0,'Device_" + dashboardDpList[index].deviceId + "','" + dashboardDpList[index].deviceName + "')\"";
                                                    tempContent += " class=\"pushbuttonLedDot\"" + sTemp1;
                                                    tempContent +=  '></span>';

                                                    element2.innerHTML = tempContent;
                                                    dashboardDpList[index].displayElements[deIndex].dashboardType = "pb"; //g_editButtonElementList[i].type;
                                                }
                                            }
                                        }
                                        else if (g_editButtonElementList[i].type === "s1") {
                                            element.disabled = true;
                                            element.style.borderColor = "lightgrey";
                                        }
                                        else if (g_editButtonElementList[i].type === "s1_graphic") {
                                            element.disabled = true;
                                            element.style.borderColor = "lightgrey";
                                        }
                                        else if (g_editButtonElementList[i].type === "sl") {
                                            element.disabled = true;
                                            element.style.borderColor = "lightgrey";
                                        }
                                        else if (g_editButtonElementList[i].type === "input") {
                                            //ffixMBW need to add code for editmode - not edit then clicking goes to device dashboard
                                            element.disabled = true;
                                            element.style.borderStyle = "solid";
                                            //element.style.borderColor = "whitesmoke";
                                        }
                                        else if (g_editButtonElementList[i].type === "input_grapic") {
                                            //ffixMBW need to add code for editmode - not edit then clicking goes to device dashboard
                                            element.disabled = true;
                                            element.style.borderStyle = "solid";
                                            //element.style.borderColor = "whitesmoke";
                                        }
                                        else if (g_editButtonElementList[i].type === "b") { //((g_editButtonElementList[i].type === "b") && (g_sSiteDashboardSelected !== "")) {
                                            //element.style.borderColor = "black";
                                            element.disabled = true;
                                            element.style.visibility = "hidden";
                                        }
                                        else if(g_editButtonElementList[i].type === "rbt_graphic") {
                                            element = document.getElementById(g_editButtonElementList[i].displayId + "_0");
                                            if(element !== null)
                                                element.disabled = true;
                                            element = document.getElementById(g_editButtonElementList[i].displayId + "_1");
                                            if(element !== null)
                                                element.disabled = true;
                                        }
                                        else if (g_editButtonElementList[i].type === "d") {
                                            element.disabled = true;
                                        }
                                        else if (g_editButtonElementList[i].type === "d_graphic") {
                                            element.disabled = true;
                                        }
                                        else if (g_editButtonElementList[i].type === "menu") {
                                            element.disabled = true;
                                        }
                                    }
                                }
                                else if(g_editButtonElementList[i].action === "visible") {
                                    if(g_bEditModeEnabled)
                                        element.style.visibility = "visible";
                                    else 
                                        element.style.visibility = "hidden";
                                }
                            }
                            catch {}
                        }
                    }
                    catch {}
                }
            }
            if(g_bDeviceDashboardHidePrioirtyColumnInNonEditMode && (g_iDashboardPriorityColumn !== -1)) {
                if(g_iDashboardTablePriorityColumnShowType === 0) { // 0= use visible and hidden,1 = use display inline-block and none)
                    tempContent = "hidden";
                    if(g_bEditModeEnabled) {
                        tempContent = "visible"; //"table-cell";
                    }
                }
                else if(g_iDashboardTablePriorityColumnShowType === 1) { // 0= use visible and hidden,1 = use display inline-block and none)
                    tempContent = "none";
                    if(g_bEditModeEnabled) {
                        tempContent = "inline-block"; //"table-cell";
                    }
                }
                if(g_sSiteDashboardSelected !== "") {
                    try {
                        if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
                            if((!g_bDashboardTableReadOnly) && (g_iDashboardTablePriorityColumnShowType !== 2)) {
                                
                                table = document.getElementById("myTable");
                                if(table !== null) {
                                    for(i=0; i < table.rows.length; i++)
                                    {
                                        if(g_iDashboardTablePriorityColumnShowType === 0)
                                            table.rows[i].cells[g_iDashboardPriorityColumn].style.visibility = tempContent;
                                        else if(g_iDashboardTablePriorityColumnShowType === 1)
                                            table.rows[i].cells[g_iDashboardPriorityColumn].style.display = tempContent;
                                    }
                                }
                            }
                        }
                    }
                    catch {}
                }
            }
        }
    }
    catch {}
}
function dashboardPollCheckBox() {
	var min;
	if(g_idpGetRequestIndex === -1)
		return;
	if(g_dpGetRequestArr[0] === "") 
		return;
	if((g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) && (dashboardDpList.length > 0)) { 
		if(document.getElementById("dashboardPollCheckbox").checked) {
            /*
			var pollRate = document.getElementById("pollrate").value;   
			pollRate  = Number(pollRate );
			if(isNaN(pollRate ))
				return;
			g_iPollingRequestCountMax = pollRate;
			min = Math.ceil(dashboardDpList.length / g_iMaxOfDpsToPollPerInterval);
				if(pollRate < (min * g_iBackgroundPollingRequestCountMax)) 
                */
            g_bDashboardPollEnabled = true;
            g_PollingType = DISPLAYMODE_DASHBOARD;
            g_idpGetRequestIndex = 0;
            g_bPollingEnabled = true;
            g_iPollingRequestCount = g_iPollingRequestCountMax;
            ivbWsProcessDatapointUpdate = true;
            if(g_sWebSocketSubscribePayload !== g_sWebSocketSubscribePayload_oldvalue)
			    subscribeRequest();
			//g_iBackgroundPollingRequestCount = g_iBackgroundPollingRequestCountMax + 12; //start request
            g_bDashboardPollEnabled = true;
			
			try {
				// ivGetDeviceList(); // IOT get device list later
				if(g_timerId === 0)
					g_timerId = window.setInterval("timerHandler()", g_iTimerInterval);
			} catch (err) {} 
		}
		else {
            g_bDashboardPollEnabled = false;
            g_PollingType = 0;
            g_bPollingEnabled = false;
            //ivbWsProcessDatapointUpdate = false;
        }
	}
}
function dashboardSaveData(mode) {
    menuCancel();
    saveData(mode);
}
function dashboardSteplinCheckBox() {
    g_idashboardChartType = 0;
    if(document.getElementById("dashboardSteplineCheckbox").checked)
        g_idashboardChartType = 1;
}
function dashboardOptionsCheckBox() {
    try {
        g_bDashboardOptionsMenu = document.getElementById("dashboardOptionsCheckbox").checked;
        if(g_bDashboardOptionsMenu)
            document.getElementById("dashboardOptionsMenu").style.display = "inline-block";
        else
            document.getElementById("dashboardOptionsMenu").style.display = "none";
    }
    catch {}
}
function  dashboardDetermineDuration() {
    try {
    // mode: 0=initial value, 1=have data need to determine new minmax
        var i;
        var t = Date.now();
        switch(g_iDashboardChartDuration) {
            case 0:
                g_iDashboardChartMaxDuration = 0; 
                break;
            case 1:
                g_iDashboardChartMaxDuration = 10 * 60 * 1000; //10 minutes
                break;
            case 2:
                g_iDashboardChartMaxDuration = 30 * 60 * 1000; // hour
                break;
            case 3:
                g_iDashboardChartMaxDuration = 60 * 60 * 1000; // hour
                break;
            case 4:
                g_iDashboardChartMaxDuration = 120 * 60 * 1000; // 2 hours
                break;
            case 5:
                g_iDashboardChartMaxDuration = 60 * 24  * 60 * 1000; // 1 day
                break;
            default:
                g_iDashboardChartMaxDuration = 60 * 60 * 1000; // hour
                break;
        } 
        for(i=0; i < g_dashboardChartList.length; i++) {
            dashboardChartDetermineStartTime(0, i, t);
            dashboardDetermineChartMinMaxValuesForChart(0, i, null, true);
            /*ivInitializeChart1(g_bDashboardSupportLogData, "chartSvg_" + g_dashboardChartList[i].displayId, g_dashboardChartList[i].minValue,
                g_dashboardChartList[i].maxValue, null, null, "white", null, g_dashboardChartList[i].chartLabels); */
            ivInitializeChart1(g_bDashboardSupportLogData, "chartSvg_" + g_dashboardChartList[i].displayId, g_dashboardChartList[i].minValue,
                g_dashboardChartList[i].maxValue, null, null, g_chartTextColor, null, g_dashboardChartList[i].chartLabels);
	        dashboardUpdateCharts(i, null, null);
        }
    }
    catch {}
}
function dashboardLogSelectionChanged() {
    try {
        var element = document.getElementById("dashboardLogDuration");
        if(element !== null) {
            g_iDashboardDatalogRangeDropdown = element.value;
            if(typeof g_iDashboardDatalogRangeDropdown === "string") {
                g_iDashboardDatalogRangeDropdown = Number(g_iDashboardDatalogRangeDropdown);
                if(g_iDashboardDatalogRangeDropdown === 1) 
                    g_iDashboardDatalogRange = 0;
                else if(g_iDashboardDatalogRangeDropdown === 1) 
                    g_iDashboardDatalogRange = 10; // 10min
                else if(g_iDashboardDatalogRangeDropdown === 2) 
                    g_iDashboardDatalogRange = 60; // hour
                else if(g_iDashboardDatalogRangeDropdown === 4) 
                    g_iDashboardDatalogRange = 24 * 60; // day
            }
        }
        var element = document.getElementById("dashboardDuration");
        if(element !== null) {
            g_iDashboardChartDuration = element.value;
            if(typeof g_iDashboardChartDuration === "string")
                g_iDashboardChartDuration = Number(g_iDashboardChartDuration);
        
            //g_idashboardChartMaxNumberOfEntries = 0;
            //g_iDashboardChartMaxDuration = 0;
            dashboardDetermineDuration();
        }
 
    }
    catch {}

} 
function dashboardOutputsCheckbox() {
    g_bUseChartForAllOutputs = document.getElementById("dashboardChartOutputsCheckbox").checked;
    g_sDashboardMainContent = "";
    g_sDashboardPaneTitleContext = "";
    showDashboard(7,'', -1);

} 
function dashboardInputsCheckbox() {
    g_bUseChartForAllInputs = document.getElementById("dashboardChartInputsCheckbox").checked;
    g_sDashboardMainContent = "";
    g_sDashboardPaneTitleContext = "";
    showDashboard(7,'', -1);

} 
function dashboardMapDevice(index,deviceName, path) {
    
    if(g_bMapEnabled) {
        g_bPreviousDeviceMap = true;
        showMap(2, deviceName, path, "DEVICE", index, g_sMapTreeNodeId);
        g_sMapDeviceWithPopupOpen = deviceName;
    }
}
function dashboardTestDevice(n,deviceName) {
    try {
        var i, id;
        for(i=0; i < deviceListAll.length; i++)
        {
            if(deviceListAll[i].name === deviceName) {
                testDevice(0, n, deviceListAll[i].id, deviceName);
                break;
            }
        }
        
    }
    catch {}
}
function dashboardToolTipCheckbox() {
    try {
        if(g_bDashboardSupportDisplayMouseToolTip) 
            g_bDashboardDisplayMouseToolTip = document.getElementById("dashboardChartToolTipCheckbox").checked;
    }
    catch (err) {}
}
function dashboardToolTipPresetCheckbox() {
    try {
        if(g_bDashboardSupportDisplayMouseToolTip) 
            g_bDashboardDisplayMouseToolTipShowPresets  = document.getElementById("dashboardChartToolTipPresetCheckbox").checked;
    }
    catch (err) {}
}
function dashboardPause() {
    var text = document.getElementById("pauseButton").innerText;
    if(text === "Pause") {
        g_bdashboardChartPause = true;
        document.getElementById("pauseButton").innerText = "Continue";
    }
    else {
        g_bdashboardChartPause = false;
        document.getElementById("pauseButton").innerText = "Pause";
    }
}
function dashboardRadtioButtonTemperatureChange(n, index, displayElementIndex, programmaticPathname, displayId) {
    // for radio button temperature (rbt)
    try {
        var url;
        var i,value = 0, state, value1, element,obj, objs, bContinue;
        var currentTime;
        var priority = null;
        var value = n.value;
        if((g_iMainDisplayMode !== DISPLAYMODE_DASHBOARD) && (g_iMainDisplayMode !== DISPLAYMODE_PLANNING))
            return;
        if(value === null)
            return;
        if (value === "")
            return;  
        if(typeof value === "string") {
            if(value !== "") {
                if(isNaN(value))
                    return;
                value = Number(value);
            }
        }              
                        
        if((index < dashboardDpList.length) && (displayElementIndex < dashboardDpList[index].displayElements.length)) {
            if(dashboardDpList[index].programmaticPathname === programmaticPathname) {
                if(dashboardDpList[index].displayElements[displayElementIndex].displayId === displayId) {
                    if((value === 0) || (value===1)) {
                            // write value
                            
                        
                        objs = dashboardDpList;
                        bContinue = false;
                        
                        if(objs[index].displayElements[displayElementIndex].field !== "") {
                            if(objs[index].displayElements[displayElementIndex].bNumber)
                                value = Number(value);
                            value = changeFieldValue(objs[index].locValue, objs[index].displayElements[displayElementIndex].field, value);
                            if(value.valid) 
                                value = JSON.stringify(value.data);
                            else  {
                                showAlertDialog(0,"Can't process input data");
                                return;
                            }
                        }
                        for(i=0; i < objs.length; i++)
                        {  // find datapoint
                            if(objs[index].programmaticPathname === programmaticPathname) {
                                var value1 = objs[index].value;
                                    
                                    // add feedback
                                objs[index].feedbackDelay = true;
                                currentTime = new Date().getTime();
                                objs[index].feedbackDelayTimeout = currentTime + g_iFeedbackDelayTime; // ms  10000 = 10 s
                                if(objs[index].bStructure)
                                    objs[index].feedbackDelayOldValue = JSON.parse(JSON.stringify(objs[index].locValue));
                                else 
                                    objs[index].feedbackDelayOldValue = objs[index].locValue;
                                objs[index].valueStr = value;
                                                // check if using field or full datapoint value
                                if(objs[index].bStructure)
                                    objs[index].value = JSON.parse(JSON.stringify(value));
                                else
                                    objs[index].value = value;
                                //  fixxxxxx  Determine preset value
                                z = index;
                                break;
                            }
                            index ++;
                            if(index >= objs.length)
                                index = 0;
                        }
                        if(z !== -1) {
                            if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
                                if(priority !== null)
                                    priority = priority.value;
                            }
                            else if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING) {
                                //ffix add code 
                            }
                            
                            url = "/iap/devs/*+name=="; //iot
                            url += objs[z].urlPath.replace(/ /g,"%20").replace(/:/g,"%3A").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
                            if(priority !== null)
                                url += "/overrides/" + priority;
                            url += "/localization/value";
                            //objs[z].updateDpValue = true; // sync up value, localValue and Preset
                            writeDpValue(1,url,value, null, writeFailCallback);
                            
                        }
                    }
                }
            }
        }
    }
    catch {}
}
function dashboardRefresh() {
    //
    // remove datalog data
    g_bDashboardDataLogGetInProgress = true;
    try {
        for(i=0; i < g_dashboardChartList.length; i ++)
        {
            g_dashboardChartList[i].data = [];
            g_dashboardChartList[i].maxValue = null;
            g_dashboardChartList[i].minValue = null;
            g_dashboardChartList[i].bMinMaxEqual = true;
        }
        for(i=0; i < g_dashboardChartList.length; i ++)
        {
            dashboardDpList[i].datalogData = [];
            dashboardDpList[i].updateDpValue = true;
        }
        if(g_bDashboardGetDatalog && (g_iDashboardDatalogRange > 0) && g_bMaxDataLogSizeNotReached) {
            getDashboardDatalogData(50, "", "", "");
        }
        else
            g_bDashboardDataLogGetInProgress = false;

    }
    catch {}
    ivInitializeChart3Clear2Yaxis(false, "", g_dashboardChartList);
}
function dashboardUseCurrentPriorityCheckbox() {
    //g_bDashboard_UseCurrentPriorityForAllRights = document.getElementById("dashboardUseCurrentPriorityCheckbox").checked;
    //showDashboard(0,'', -1);
    showAlertDialog(0,"Not supported yet");

}
function dashboardUpdateCharts(chartIndex, value, timestamp) {
    if(g_bDashboardNeedToInitializeSvg)
        return;
    if(g_bDashboardSupportLogData && g_bDashboardUseNewChart) {
        //ffix change to using dynmic timestamp charting
        //ivUpdateCharts(chartIndex, value, null);
        var chartObj = JSON.parse(JSON.stringify(g_dashboardChartList[chartIndex]));
        var chartObjList = [];
        var temp = 1;
        var sExtraStr = "";  //used to specify duration
        chartObjList.push(chartObj);
        //ivUpdateChartsDatalog(chartObj.displayId, sExtraStr, g_idashboardChartType, chartIndex, g_dashboardChartList, null,chartObj.minValue, chartObj.maxValue, chartObj.startTimestamp, chartObj.endTimestamp);
        ivUpdateChartsDatalogChart3TwoYaxis("chartSvg_" + chartObj.displayId, sExtraStr, g_idashboardChartType, 0, chartObjList,  null,chartObj.minValue, chartObj.maxValue, null, null, 
            chartObj.startTimestamp, chartObj.endTimestamp, giDashboardChartLineWidth, true, "both");
        
    }
    else
        ivUpdateCharts(chartIndex, value, null);
}
function dashboardRestart() {  //remove no longer used
    try {
        var i, index, err,step;
        // showDashboard(0) - going to Dashboard View from another view
        createRequestString(dashboardDpList);
        for(i = 0; i < g_dashboardChartList.length; i++)
        {
            index = i;
            step = 0;
            if(g_dashboardChartList[index].data.length > 0) {
                g_dashboardChartList[index].creatChartLine = true;
                step = 1;
                ivInitializeChart1(g_bDashboardSupportLogData, g_dashboardChartList[index].displayId, g_dashboardChartList[index].minValue, g_dashboardChartList[index].maxValue, null, null, "white", null, g_dashboardChartList[index].chartLabels);
                step = 2;
                dashboardUpdateCharts(index, null, null);
                step = 3;
            }
        }
        step = 4;
        for(i=0; i < dashboardDpList.length; i++)
        {
            
            dashboardDpList[i].updateDpValue = true;
            
        }
        //initializeSvgDashboard(); // already have chart so just use new values
        if(g_bDashboardPollEnabled)
            g_PollingType = DISPLAYMODE_DASHBOARD;
        bDataLogGetInProgress = false;
        g_bDashboardDataLogGetInProgress = false;
        showAlertDialog(0,"reset complete");
        if(g_timerId === 0)
            g_timerId = window.setInterval("timerHandler()", g_iTimerInterval);
        
    }
    catch (e) {
        err = "Error: " + e.toString() + "\r\n\r\nindex = " + index + ", step: " + step; 
        showAlertDialog(0,err);
    }
}
function getDashboardDatalogData(mode, title, templateType, bAddDeviceName) {
    // mode: 50=refresh (don't re-draw screen)
    var d, t, t1 = 1, iPtr, n, wsUrl = "/iap/ws?";
    if(g_bDashboardGetDatalog && (g_iDashboardDatalogRange > 0) && g_bMaxDataLogSizeNotReached) {
        try {
            var element = document.getElementById("planningPaneDetails_Details");
            //if(element !== null) {
                //element.innerHTML = "<br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting data logs ....</span>";
           //     element.innerHTML = "<br><div id=\"gettingInfoId\" class=\"gettingInfo\">" + addWaitSpinner() + "</div>";
           // }
            //enhancements change wsUrl for device or specific datapoint
            g_dashboardDataLogRequestInfo = {};
            g_dashboardDataLogRequestInfo.mode = mode;
            g_dashboardDataLogRequestInfo.title = title;
            g_dashboardDataLogRequestInfo.templateType = templateType;
            g_dashboardDataLogRequestInfo.bAddDeviceName = bAddDeviceName;
            d = new Date();
            d.setTime(d.getTime() - (g_iDashboardDatalogRange * 60 * 1000)); // 10 min
            /*
            if(g_iDashboardDatalogRange === 1) 
                d.setTime(d.getTime() - (10 * 60 * 1000)); // 10 min
            else if(g_iDashboardDatalogRange === 2) 
                d.setTime(d.getTime() - (t1 * 60 * 60 * 1000)); // hour
            else if(g_iDashboardDatalogRange === 4) 
                    d.setTime(d.getTime() - (t1 * 24 * 60 * 60 * 1000)); // day

                    */
            //else if(g_iDashboardDatalogRange === 3) {
            //    t1 = 10;
            //    d.setTime(d.getTime() - (t1  * 60 * 1000)); //min
            //}
            if(g_sSiteDashboardSelected !== "") {
                if(title !== "") {
                    wsUrl += "dev=%2A%2Bname==" + encodeNameStr(title);
                    wsUrl += "&value=";
                }
                else
                    wsUrl += "value=";
            }
            else {
                wsUrl += "dev=%2A%2Bname==" + encodeNameStr(title);
                wsUrl += "&value=";
            }
            n = d.toISOString();
            n = n.substr(0, n.length - 1);
            if(n !== "") {
                n = n.replace(/:/g,"%3A")
                wsUrl += "%2A%2Butc%3E" + n;
            }
            g_bDashboardDataLogGetInProgress = true;
            if(mode !== 50)
                mode = 30;
            createDataLogClientWebSocketConnection(mode, wsUrl);
        }
        catch {
            showDashboardUiBuildGetSnvtTypes();
            //showDashboardUi((mode + 20), title, null, templateType, bAddDeviceName);
        }
    }
    else {
        showDashboardUiBuildGetSnvtTypes();
        //showDashboardUi((mode + 20), title, null, templateType, bAddDeviceName);
    }
}
function getDashboardDatalogDataResponse(mode, request, datalogData) {
    try {
        var j;
        
        if(datalogData !== null) { //"") {
            g_dashboardDatalogData = datalogData; //JSON.parse("[" + datalogData + "]");
            //populate datapoint information

            // clear current cache
            for(j=0; j < dashboardDpList.length; j++)
            {
                dashboardDpList[j].datalogData = [];
    
            }
        }
        if(mode === 50) {
            // refresh
            getDashboardDatalogDataResponseProcessData(mode);
        }
        else 
            showDashboardUiBuildGetSnvtTypes()
        
    }
    catch {}
}

function getDashboardDatalogDataResponseProcessData(mode) {
    try {
        var i,j, d, data,temp,k, ms, bDPsWithAtleastOneOutofOrdervalue = 0, timestamp1, timestamp2,bContinue;
        var tempObj, bContinue, chartIndex;
        if(g_dashboardDatalogData.length >0) {

            for(i=0; i < g_dashboardDatalogData.length; i++)
            {
                for(j=0; j < dashboardDpList.length; j++)
                {
                    if(g_dashboardDatalogData[i].dpQualifier === dashboardDpList[j].dpQualifier) {
                        data = {};
                        data.value = g_dashboardDatalogData[i].localizedValue; //g_dashboardDatalogData[i].value;
                        data.utc = g_dashboardDatalogData[i].utc;
                        data.local = g_dashboardDatalogData[i].local;
                        if(typeof g_dashboardDatalogData[i].presetValue !== "undefined") {
                            if(g_dashboardDatalogData[i].presetValue !== "")
                                data.presetValue = g_dashboardDatalogData[i].presetValue;
                        }
                        temp = g_dashboardDatalogData[i].utc;
                        data.timestamp = Date.parse(temp.substr(0,(temp.length - 5)));
                        //data.timestamp = d1.getTime();
                        dashboardDpList[j].datalogData.unshift(data);
                        
                    }
                }
            }
            // reorder if necessary
            
            
            for(i=0; i < dashboardDpList.length; i++)
            {
                bContinue = true;
                if(dashboardDpList[i].datalogData.length > 0) {
                    while(bContinue)
                    {
                        bContinue = false;
                        for(j=0; j < (dashboardDpList[i].datalogData.length - 1); j++)
                        {
                            timestamp1 = dashboardDpList[i].datalogData[j].timestamp;
                            timestamp2 = dashboardDpList[i].datalogData[j + 1].timestamp;
                            if(timestamp1 > timestamp2) {
                                bContinue = true;
                                tempObj = {};
                                tempObj = JSON.parse(JSON.stringify(dashboardDpList[i].datalogData[j]));
                                dashboardDpList[i].datalogData[j] = JSON.parse(JSON.stringify(dashboardDpList[i].datalogData[j + 1]));
                                dashboardDpList[i].datalogData[j + 1] = tempObj;
                                bDPsWithAtleastOneOutofOrdervalue ++;
                            }
                        }

                    }
                    // change start and end times
                    k = dashboardDpList[i].datalogData.length;
                    dashboardDpList[i].startTimestamp = dashboardDpList[i].datalogData[0].timestamp;
                    dashboardDpList[i].endTimestamp = dashboardDpList[i].datalogData[k - 1].timestamp;
                    // make sure current value is the latest value otherwise the chart show line backtracking
                    temp = dashboardDpList[i].utc;
                    ms = Date.parse(temp.substr(0,(temp.length - 5)));
                    for(j=k-1; j >= 0; j--)
                    {
                        if(dashboardDpList[i].datalogData[j].timestamp >= ms) {
                            dashboardDpList[i].datalogData.pop();
                        }
                        else
                            break;

                    }
                }
            }
        }
    }
    catch {g_dashboardDatalogData = [];} 
    //if(bDPsWithAtleastOneOutofOrdervalue > 0)
    //    alert("Datalog DPs with out of order logs = " + bDPsWithAtleastOneOutofOrdervalue);
    if(mode === 50) {
        // refresh
        for(i=0; i < dashboardDpList.length; i++)
        {
            for(j=0; j < dashboardDpList[i].displayElements.length; j++)
            {
                if(dashboardDpList[i].displayElements[j].chartIndex !== null) {
                    dashboardDpList[i].displayElements[j].updateDpValue = true;
                    chartIndex = dashboardDpList[i].chartIndex;
                    if(chartIndex < g_dashboardChartList.length) {
                        g_dashboardChartList[chartIndex].data = dashboardDpList[i].datalogData;
                        if(g_dashboardChartList[chartIndex].data.length > 0) {
                            g_dashboardChartList[chartIndex].endPtr = g_dashboardChartList[chartIndex].data.length - 1;
                            g_dashboardChartList[chartIndex].startTimestamp = g_dashboardChartList[chartIndex].data[0].timestamp;
                            g_dashboardChartList[chartIndex].endTimestamp = g_dashboardChartList[chartIndex].data[g_dashboardChartList[chartIndex].data.length - 1].timestamp;
                            g_dashboardChartList[chartIndex].dataCurrentEntries = g_dashboardChartList[chartIndex].data.length;
                            dashboardDetermineChartMinMaxValuesForChart(0, chartIndex, null, true);
                            dashboardUpdateCharts(chartIndex, null, null);
                        }
                        else {
                            g_dashboardChartList[chartIndex].endPtr = 0;
                            g_dashboardChartList[chartIndex].startTimestamp = 0;
                            g_dashboardChartList[chartIndex].endTimestamp = 0;
                            g_dashboardChartList[chartIndex].dataCurrentEntries = 0;
                        }
                    }
                }
            }
        }
        //initializeSvgDashboard(); // already have chart so just use new values
        g_bDashboardDataLogGetInProgress = false;
        return;
    }
    else {

    }

    //showDashboardUi((g_dashboardDataLogRequestInfo.mode + 20), g_dashboardDataLogRequestInfo.title, null, g_dashboardDataLogRequestInfo.templateType, g_dashboardDataLogRequestInfo.bAddDeviceName);
    
}
function showDashboard(mode, title, index) {
    g_sSiteDashboardSelected = ""; // device dashboard
    showDashboard1(mode, title, index);
}
function showDashboard1(mode, title, index) {
    // mode: 10= got data log data now populate dashboard
    var i, j, z;
    var dps = [], dpsTemp = [], replacementDps, url;
    var paneTitle = "<div id=\"dashboardbreadcombar\" style=\"float:left;cursor:pointer\">";
    var paneContent = "<div style=\"text-align:center\"><br><div id=\"gettingInfoId\" class=\"gettingInfo\">" + addWaitSpinner(1) + "</div></div>";
    var color = "red";
    var contextId = -1,sTemp = "";
    var deviceIndex = -1;
    try {
        
        if(g_sSiteDashboardSelected !== "") {
            if(g_sSiteDashboardSelected === "_sitedashboard")
                paneTitle +="Site Dashboard: "; 
            else {
                paneTitle += planningCreateContextbreadcrumbs(g_sSiteDashboardSelected);
            }
            if(g_iShowEditButton > 0) {
                //g_iShowEditButton: 0=disabled, 1=show switch (default readonly), 2=show switch(default write)
                paneTitle += "<div id=\"editButtonDiv\" class=\"editButtonDiv\" title=\"Enables writing to datapoints\">(<input id=\"editButton\" type=\"checkbox\" onclick=\"dashboardEditCheckBox()\"";
                if(g_bEditModeEnabled)
                    paneTitle += " checked";
                paneTitle += "> edit)</div>";
            }
        }
        else if(g_bShowDeviceStatusInDashboard) {
            for(i=0; i < deviceListAll.length; i++)
            {
                if(deviceListAll[i].id === index) {
                    if(deviceListAll[i].name === title) {
                        deviceIndex = i;

                        break;
                    }
                }
            }
            if(deviceIndex === -1)
                return;
            sTemp = "";
            if(g_bShowDeviceDashboardBreadCrumbs) {
                // add device breadcrumbs

                if(deviceListAll[deviceIndex].contexts.length === 1) {
                    contextId = deviceListAll[deviceIndex].contexts[0];
                    if(contextId !== -1) {
                        sTemp = treeviewfindContextPathFromId(contextId, planningList, "")
                        if(sTemp !== "")
                            sTemp = planningCreateContextbreadcrumbs(sTemp);
                        if(sTemp !== "")
                            sTemp += "/"
                        //sTemp +=  "<span id=\"dashboardTitle\" onclick=\"showDashboard1(" + mode + ",'" +  title + "'," +  index + ")\">" + title + "</span>";
                        sTemp +=  "<span id=\"dashboardTitle\">" + title +"</span>";
                    }
                    else 
                        sTemp =  "<span id=\"dashboardTitle\">" + title +"</span>";
                    
                }
                else 
                    sTemp =  "<span id=\"dashboardTitle\">" + title +"</span>";
                paneTitle += sTemp; //"Dashboard: " + sTemp;
            }
            else 
                paneTitle +="Dashboard: <span id=\"dashboardTitle\">" + title +"</span>";
            
            color = showDashboardDeviceStatus(deviceIndex, title);
            paneTitle += ' <span id=\"dashboardDeviceStatus_' + title + '\" class="treeviewDeviceDot" style="background-color:' + color + '"></span> ';
        
            if(g_iShowEditButton > 0) {
                //g_iShowEditButton: 0=disabled, 1=show switch (default readonly), 2=show switch(default write)
                paneTitle += "<div id=\"editButtonDiv\" class=\"editButtonDiv\" title=\"Enable Writes to Datapoint\">(<input id=\"editButton\" type=\"checkbox\"  onclick=\"dashboardEditCheckBox()\"";
                if(g_bEditModeEnabled)
                    paneTitle += " checked";
                paneTitle += "> edit)</div>";
            }
        }
        paneTitle += "</div>";
        
        
        /* may want to remove
        if(g_iDashboardBackButtonContextId !== null) {
            paneTitle += "<button style=\"margin-left:50px\" onclick=\"goBackToContext(" + g_iDashboardBackButtonContextId + ")\">Back</button>"
        }
        */
        if((mode === 0) || (mode === 1)) {
            if(g_snvtTypes.length === 0)
                getAllSnvtType(0);
        }

        paneTitle += "<div id=\"dashboardmenubar\" style=\"float:right;margin-left:30px\">"
        if(mode !== 7){
            savePrevousHtmlContent();
            initializeDisplay();
            dashboardDetermineDuration();
            g_DashboardImage = null;
            g_iDashboardImageWidth = null;
            g_iDashboardImageHeight = null;
            g_iDashboardImageX = null;
            g_iDashboardImageY = null;
            g_oDashboardImageLayout = null;
            if(mode !== 0)
                g_bdashboardChartPause = false;
        }
        g_iMainDisplayMode = DISPLAYMODE_DASHBOARD; 
        g_bDashboardNeedToInitializeSvg = true;
        g_bDashboardDataLogGetInProgress = true; // disable background polling until UI built, and if svg until svg initializaed
        configureDashboardChartsParameters();
        if(((mode === 0) && (dashboardDpList.length > 0)) || (mode === 7)) {
            title = g_sDashboardTitle;
            paneContent = "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Building Dashboard ...</span></div>";;
        }
        g_sDashboardPaneTitleContext = "";
        g_sDashboardMainContent = "";
        if(checkIfUserTypeSupported(g_showAdvancedCheckbox)) {
            if(g_bDashboardSupportLogData) { 
                
                
                    paneTitle += "<div id=\"dashboardOptionsMenu\" style=\"display:";
                    if(g_bDashboardOptionsMenu)
                        paneTitle += "inline-block";
                    else
                        paneTitle += "none";
                    paneTitle += "\">";
                    paneTitle += "<input id=\"dashboardGetDatalogCheckbox\" type=\"checkbox\" onclick=\"dashboardGetDatalogCheckBox()\"";
                    if(g_bDashboardGetDatalog)
                        paneTitle += " checked";
                    paneTitle += ">";
                    //paneTitle += "1 hour Data Log";
                    paneTitle += "<select id=\"dashboardLogDuration\" onchange=\"dashboardLogSelectionChanged()\">";
                    paneTitle += "<option value=\"1\">10 Min Log</option><option value=\"2\" selected>1 Hour Log</option>";
                    paneTitle += "<option value=\"4\">1 Day Log</option>"
                    paneTitle += "</select>";
                    paneTitle += "<span style=\"margin-left:10px\">Duration </span>";
                    paneTitle += "<select id=\"dashboardDuration\" onchange=\"dashboardLogSelectionChanged()\">";
                    paneTitle += "<option value=\"0\">No Limit</option><option value=\"1\">10 Min</option>";
                    paneTitle += "<option value=\"2\">30 Min</option><option value=\"3\">1 Hour</option>";
                    paneTitle += "<option value=\"4\">2 Hour</option><option value=\"5\">1 Day</option>"
                    paneTitle += "</select>";
                
            }
            
            paneTitle += "<input id=\"dashboardPollCheckbox\" type=\"checkbox\" onclick=\"dashboardPollCheckBox()\"";
            if(g_bDashboardPollEnabled)
                paneTitle += " checked";
            paneTitle += ">Poll ";

            

            paneTitle += "<input id=\"dashboardSteplineCheckbox\" type=\"checkbox\" onclick=\"dashboardSteplinCheckBox()\"";
            if(g_idashboardChartType)
                paneTitle += " checked";
            paneTitle += ">Stepline ";
            
            paneTitle += "<input id=\"dashboardChartInputsCheckbox\" type=\"checkbox\" onclick=\"dashboardInputsCheckbox()\"";
            if(g_bUseChartForAllInputs) 
                paneTitle += " checked";
            
            paneTitle += ">Chart Scalars Inputs";
            paneTitle += "<input id=\"dashboardChartOutputsCheckbox\" type=\"checkbox\" onclick=\"dashboardOutputsCheckbox()\"";
            if(g_bUseChartForAllOutputs) 
                paneTitle += " checked";
            
            paneTitle += ">Chart Scalars Outputs";
            if(g_bDashboardSupportDisplayMouseToolTip) {
                paneTitle += "<input id=\"dashboardChartToolTipCheckbox\" type=\"checkbox\" onclick=\"dashboardToolTipCheckbox()\"";
                if(g_bDashboardDisplayMouseToolTip) 
                    paneTitle += " checked";
                paneTitle += ">Chart Tooltip [";
                paneTitle += "<input id=\"dashboardChartToolTipPresetCheckbox\" type=\"checkbox\" onclick=\"dashboardToolTipPresetCheckbox()\"";
                if(g_bDashboardDisplayMouseToolTipShowPresets)
                    paneTitle += " checked";
                paneTitle += ">Preset]";
            }
            paneTitle += " Decmial Places <select id=\"dashboardDecimalPlaces\" onchange=\"dashboardDecimialPlaces()\"><option value=\"-1\">all</option>";
            paneTitle += "<option value=\"0\">none</option><option value=\"1\">1</option>";
            paneTitle += "<option value=\"2\">2</option><option value=\"3\">3</option><option value=\"4\">4</option></select>";
            paneTitle += "<button id=\"dashboardSaveButton\" onclick=\"menuDashboardSave(this)\">Save</button>"
            paneTitle += "  </div>"
            if(g_sSiteDashboardSelected === "") {
                if(checkIfUserTypeSupported(g_showAdvancedCheckbox)) {
                    paneTitle += "<input id=\"dashboardOptionsCheckbox\" type=\"checkbox\" onclick=\"dashboardOptionsCheckBox()\"";
                    if(g_bDashboardOptionsMenu)
                        paneTitle += " checked";
                    paneTitle += "> Advanced ";
                }
                if(g_bUseWebSockets) {
                    if(!g_bHideSubscribeButton)
                    paneTitle += "<button onclick=\"subscribeRequest()\">re-Subscribe</button>";
                }
            }
        }
        else if (g_showAdvancedCheckbox === NONE) {
            if(g_bShowDatalogDuration) {
                paneTitle += "<div id=\"dashboardOptionsMenu\" style=\"display:inline-block\">";
                paneTitle += "<span style=\"margin-left:10px\">Chart Duration </span>";
                paneTitle += "<select id=\"dashboardDuration\" onchange=\"dashboardLogSelectionChanged()\" title=\"Changes Chart Duration\">";
                paneTitle += "<option value=\"0\">No Limit</option><option value=\"1\">10 Min</option>";
                paneTitle += "<option value=\"2\">30 Min</option><option value=\"3\">1 Hour</option>";
                paneTitle += "<option value=\"4\">2 Hour</option><option value=\"5\">1 Day</option>"
                paneTitle += "</select>";
                paneTitle += "</div>"
            }
        }
        g_sDashboardDeviceName = title;
        if(g_sSiteDashboardSelected === "") {
            if(g_bShowDeviceLogsInDashboard)
                paneTitle += "<button id=\"showDeviceLogsButton_"+ title + "\" title=\"Get Device Data Logs\" onclick=\"showDeviceLogs(" + index + ",'"+ title + "')\">Logs</button>";
            if(g_bShowDeviceSchedulesInDashboard)
                paneTitle += "<button id=\"showDeviceScheduleButton_"+ title + "\" title=\"Get Device Schedules\" onclick=\"showDeviceSchedule(" + index + ",'"+ title + "','')\">Schedules</button>";
            if(g_bShowDeviceTestButton) {
                paneTitle += "<button id=\"testButton_"+ title + "\" title=\"Test Device\" onclick=\"dashboardTestDevice(this,'"+ title + "')\">Test Device</button>"; //mainly used by apollo user
                //menuContent += "<button class=\"menuDivButton\" onclick=\"testDevice(" + mode + ", this," + id + ", '" + pathname + "')\">Test</button>";
            }
            if(g_bMapEnabled) {
                paneTitle += "<button id=\"mapButton_"+ title + "\" title=\"Show on map\" onclick=\"dashboardMapDevice(" + index + ",'"+ title + "','" + g_sSiteDashboardSelected + "')\">Map</button>"; //mainly used by apollo user
            }
        }
        paneTitle += "<div id=\"dashboardPauseButtonDiv\" style=\"display:inline-block; width=100px\"><button id =\"dashboardPauseButton\" onclick=\"dashboardPause()\"";
        paneTitle += " title=\"Pause Charts\">";
        if(!g_bdashboardChartPause)
            paneTitle += "Pause";
        else 
            paneTitle += "Continue";
        paneTitle += "</button></div>";
        //paneTitle += "<button class=\"refresh\" onclick=\"dashboardRefresh()\">\u21BB</button>";
        //paneTitle += "<button onclick=\"dashboardRefresh()\">Refresh</button>";
        paneTitle += "<button id=\"dashboardClearChartsButton\" onclick=\"clearDashboardCharts()\"  title=\"Clears All Charts\">Clear Charts</button>";
        paneTitle += "</div>";

        //paneTitle += "<input id=\"dashboardChartBacnetAvCheckbox\" type=\"checkbox\" onclick=\"dashboardUseCurrentPriorityCheckbox()\"";
        //if(g_bDashboard_UseCurrentPriority) 
        //    paneTitle += " checked";
        
        //paneTitle += ">Use Current Priority (TBD)";
        if(mode !== 7) {
            //navtree
            //document.getElementById("main-Header").innerHTML = paneTitle;
            element = document.getElementById("planningPaneDetails");
            if(element !== null)
                element.innerHTML = "<div id=\"planningPaneDetails_title\">" + paneTitle + "</div><div id=\"planningPaneDetails_Details\"><br><div class=\"gettingInfo\">" + addWaitSpinner(1) + "</div>";
        }
        //document.getElementById("main").innerHTML =  paneContent;
        try {
            if(checkIfUserTypeSupported(g_showAdvancedCheckbox)) 
                document.getElementById("dashboardLogDuration").value = g_iDashboardDatalogRangeDropdown;
            if(checkIfUserTypeSupported(g_showAdvancedCheckbox) || g_bShowDatalogDuration) 
                document.getElementById("dashboardDuration").value = g_iDashboardChartDuration;
            if(checkIfUserTypeSupported(g_showAdvancedCheckbox)) 
                document.getElementById("dashboardDecimalPlaces").value = g_iDashboardDecimalPlaces;
        }
        catch {}
        showDashboardEnableMenu(false);
        if(g_bDashboardSupportLogData) { 
            //ffixx add code for select 
        }
        
        if(mode === 35) {
            return; // used only to create title bar
        }
        else if(mode === 0) {
            if(dashboardDpList.length > 0)
                showDashboardUi(60, title, null, "", g_bAddDeviceName); // showDashboardUi(20, title, null, "", g_bAddDeviceName);
            else
                showDashboardUi(0, "", null, "", g_bAddDeviceName);
        }
        else if(mode === 1){
            menuCancel();
            
            
            g_sDashboardDevice = title;
            g_bAddDeviceName = false;
            if(g_sSiteDashboardSelected !== "") {
                // already have datapoint list
                return;
                //showDashboardDeviceDpListResponseForSiteDashboard(0,"",)
            }
            else {
                for(i=0; i < deviceListAll.length; i++)
                {
                    if(deviceListAll[i].id === index) {
                        if(deviceListAll[i].name === title) {
                            if(typeof deviceListAll[i].deviceTypeName === "undefined") {
                                // get device type
                                var url = "https://" + location.host + "/iap/devs/*+name==" + title;
                                requestGetData(title, url, showDashboardDeviceTemplateResponse, readFailCallback);
                            }
                            else {
                                g_sDashboardTemplateType = deviceListAll[i].deviceTypeName; 
                                g_sDashboardTemplateTypeProgramId = deviceListAll[i].programId;
                                url = "/iap/devs/*+name==" + title + "/if/*/*/*/*?noxs=true";
                                if(checkIfUserTypeSupported(g_useVisibilityFilter))
                                    url += "&visible=true";
                                requestGetData(title, url, showDashboardDeviceDpListResponse, readFailCallback);
                            }
                            break;
                        }
                    }
                }
            }
        }
        else if(mode === 2) {
            g_bAddDeviceName = true;
            g_sDashboardDevice = title;
            showDashboardUi(1, title, dpList, "", g_bAddDeviceName);
            
            
        }
        else if(mode === 3) {
            g_bAddDeviceName = true;
            g_sDashboardDevice = title;
            showDashboardUi(1, title, favDpList, "", g_bAddDeviceName);
            
        }
        else if(mode === 4) {
            g_bAddDeviceName = true;
            g_sDashboardDevice = title;
            showDashboardUi(1, title, planningDpList, "", g_bAddDeviceName);
            
        }
        else if(mode === 7) {
                // rebuild
            
            showDashboardUi(1, title, null, "", g_bAddDeviceName);
            
        }
        else if(mode === 8)
            showDashboardUi(1, g_sDashboardDevice, dpList, g_sDashboardTemplateType, g_bAddDeviceName);
    }
    catch {}
}
function showDashboardDeviceStatus(deviceIndex,deviceName) {
    //function treeviewAddDeviceStatusDot(id, name, state, health, category) {
    var str = "darkred";
    var health = "";
    var state = "";
    try {
        if(deviceListAll[deviceIndex].name !== deviceName) {
            str = "darkred";
        }
        else if((deviceName === "") || (deviceIndex === -1))
            str = "darkred";
        else {
            health = deviceListAll[deviceIndex].status.health;
            state = deviceListAll[deviceIndex].status.state;
            if(state === "provisioned") {
                if(health === "normal")
                    str = "lawngreen";
                else 
                str = "red";
            }
            else if(state === "unlicensed") 
                str = "#BA55D3"
            else if(state === "provisioning") 
                str = "cyan";
            else 
                str = "blue";
        }
    }
    catch (err) {}
    return str;
}
function showDashboardDeviceTemplateResponse(mode, requestUrl, json) {
    // mode = device name
    for(i = 0; i < deviceListAll.length; i ++)
    {
        if(deviceListAll[i].name === mode) {
            deviceListAll[i].deviceTypeName === json[0].deviceTypeName;
            g_sDashboardTemplateType = deviceListAll[i].deviceTypeName; 
            g_sDashboardTemplateTypeProgramId = deviceListAll[i].programId;
            requestGetData(mode, "/iap/devs/*+name==" + mode + "/if/*/*/*/*", showDashboardDeviceDpListResponse, readFailCallback);
            break;
        }
    }

}
function showDashboardDeviceDpListResponse(mode, requestUrl, json) {
    // mode = device name
    var i, j, k, m, z = -1, obj, programmaticPathname, pathname, presetValue = "", locValueStr = "", locValue, unit, priority = -1, lon_cfg;
    var custom = [];
    var deviceTypeName, programId;
    var dps = [], dpsTemp = [], replacementDps = [], mode2, deviceName, bContinue = true, campusTagsDeviceTypeIndex = -1;
    var bAtLeastOneEnum = false, image = "", width="", height="";
    var bAddDeviceNameToDpList = true;
    var json1 = [];
    var bFound;
    var bContinue;
    if(json.length === 0)
        return;
    
    g_oDeviceDpList = {};
    g_oDeviceDpList.name = "";
    g_oDeviceDpList.dps = [];
    if(g_bRemoveDuplicateDps) {
        // check if 
        json1 = JSON.parse(JSON.stringify(json));
        json = [];
        for(j=0; j < json1.length; j ++) 
        {
            bFound = false;
            for(i=0; i < json.length; i ++) 
            {
                if(json[i].dpQualifier === json1[j].dpQualifier) {
                    bFound = true;
                    break;
                }
            }
            if(!bFound) {
                json.push(JSON.parse(JSON.stringify(json1[j])));
            }
        }
        if(json.length === 0)
            return;
    }
    g_oDeviceDpList.dps = JSON.parse(JSON.stringify(json)); // needed  for data logs with enums;    
    for(i=0; i < json.length; i ++)
    {
        if(bAddDeviceNameToDpList) {
            bAddDeviceNameToDpList = false;
            g_oDeviceDpList.name = json[i].deviceName;
        }
        unit = ""; presetValue = ""; LocValueStr = ""; locValue = null; programmaticPathname = ""; pathname = ""; priority = -1;
        if(json[i].name === null)
            json[i].name = json[i].datapointName;
        programmaticPathname = json[i].deviceName + "/" + json[i].blockName  + "/" + json[i].blockIndex  + "/" + json[i].datapointName;
        pathname = json[i].deviceName + "/" + json[i].blockName  + "/" + json[i].blockIndex  + "/" + json[i].name;
        json[i].programmaticPathname = programmaticPathname;
        json[i].pathname = pathname;
        json[i].block = json[i].blockName  + "/" + json[i].blockIndex;
        json[i].urlPath = json[i].deviceName + "/if/" + json[i].blockName + "/" + json[i].blockIndex + "/";
		if(g_iSmartServerVersion >= 320114)
			json[i].urlPath += "*+xifName==";
		json[i].urlPath += json[i].datapointName;
        json[i].dpName = json[i].name;
        try { 
            presetValue = json[i].presetValue;
            if(presetValue === null)
                presetValue = "";
        } catch (err) {}
        json[i].presetValue = presetValue;
        json[i].bStructure = false;
        json[i].bNumber = false;
        json[i].bString = false; // enum
        try { 
            if(!(typeof json[i].locValue === "undefined")) {
                locValue = json[i].locValue;
                locValueStr = locValue;
                if(locValue !== null) {
                    if(typeof locValue === "number") {
                        locValueStr = locValue.toString();
                        json[i].bNumber = true;
                    }
                    else if(typeof locValue === "object") {
                        locValueStr = JSON.stringify(locValue);
                        if(locValueStr.length > 2) {
                            z = locValueStr.charAt(0);
                            m = locValueStr.charAt(locValueStr.length - 1);
                            if((locValueStr.charAt(0) === "{") && (locValueStr.charAt(locValueStr.length - 1) === "}")) {
                                json[i].bStructure = true;
                                locValueStr = locValueStr.substr(1, (locValueStr.length - 2));
                            }
                        }
                    }
                }
            }
        } catch (err) {}
        json[i].locValueStr = locValueStr;
        try {
            if(typeof json[i].values.level === "string")
                json[i].values.level = Number(json[i].values.level); // needed for iox. old software specified string and not a number
            priority = json[i].values.level;
        }
        catch (err) {}
        json[i].priority = priority;
        try { lon_cfg = obj["lon.cfg"];
            if(typeof lon_cfg.unit !== "undefined")
                unit = lon_cfg.unit;
            if(unit === null)
                unit = "";
        } catch (err) {}
        json[i].unit = unit;
        json[i].writePriority = g_OwnerUserTypeWritePriority;
        json[i].clearPriority = g_OwnerUserTypeClearPriority;
        json[i].custom = {};
        json[i].custom.useDefaults = true;
        if(g_currentUser === "SUPERVISOR") {
            json[i].writePriority = g_supervisorUserWriteTypePriority;
            json[i].clearPriority = g_supervisorUserTypeClearPriority;
        }
        else if(g_currentUser === "USER") {
            json[i].writePriority = g_userUserTypeWritePriority;
            json[i].clearPriority = g_userUserTypeClearPriority;
        }
        json[i].writePriorityStart = 1; 
        json[i].writePriorityEnd = 17;
        json[i].writePriorityNormal = true;

    }
    z = -1;
    for(i=0; i < deviceDpList.length; i++)
    {
        if(deviceDpList[i].deviceName === mode){
            deviceDpList[i].datapoints = JSON.parse(JSON.stringify(json));
            z = i;
            break;
        }
    }
    if(z === -1) {
        obj = {};
        obj.deviceName = mode;
        obj.deviceTypeName = g_sDashboardTemplateType;
        obj.programId = g_sDashboardTemplateTypeProgramId;
        obj.datapoints = JSON.parse(JSON.stringify(json));
        deviceDpList.push(obj);
    }

    bContinue = true;
    // Build up DpList for device datapoints and then
    for(i=0; i < deviceDpList.length; i++)
    {
        if(deviceDpList[i].deviceName === mode){
            z = -1;
            g_sDashboardTemplateType = deviceDpList[i].deviceTypeName;
            g_sDashboardTemplateTypeProgramId = deviceDpList[i].programId;
            dps = JSON.parse(JSON.stringify(deviceDpList[i].datapoints));
            if(g_campusTags.hasOwnProperty("deviceTypesList")) {
                if(i === 0) {
                    deviceName = deviceDpList[i].deviceName.toLowerCase();
                    deviceTypeName = deviceDpList[i].deviceTypeName.toLowerCase();
                    programId = deviceDpList[i].programId.toLowerCase();
                
                    for(j=0; j < 3; j++)
                    {
                        for(k=0; k < g_campusTags.deviceTypesList.length; k++)
                        {
                            if(j===0) {
                                // looks for device name
                                if((g_campusTags.deviceTypesList[k].type === "devicename") && (g_campusTags.deviceTypesList[k].name === deviceName)) {
                                    z = k;
                                    break;
                                }
                            }
                            else if(j===1) {
                                // look for device type
                                if((g_campusTags.deviceTypesList[k].type === "devicetype") && (g_campusTags.deviceTypesList[k].name === deviceTypeName)) {
                                    z = k;
                                    break;
                                }
                            }
                            else  {
                                // look for programid
                                if((g_campusTags.deviceTypesList[k].type === "programid") && (g_campusTags.deviceTypesList[k].name === programId)) {
                                    z = k;
                                    break;
                                    
                                }
                            }
                        }
                        if(z !== -1) {
                            campusTagsDeviceTypeIndex = z;
                            bContinue = false;
                            g_DashboardImage = null;
                            g_iDashboardImageWidth = null;
                            g_iDashboardImageHeight = null;
                            g_iDashboardImageX = null;
                            g_iDashboardImageY = null;
                            g_oDashboardImageLayout = null;
                            if(typeof g_campusTags.deviceTypesList[z].image !== "undefined")
                                g_DashboardImage = g_campusTags.deviceTypesList[z].image;
                            if(typeof g_campusTags.deviceTypesList[z].width !== "undefined")
                                g_iDashboardImageWidth = g_campusTags.deviceTypesList[z].width;
                            if(typeof g_campusTags.deviceTypesList[z].height !== "undefined")
                                g_iDashboardImageHeight = g_campusTags.deviceTypesList[z].height;
                            if(typeof g_campusTags.deviceTypesList[z].x !== "undefined")
                                g_iDashboardImageX = g_campusTags.deviceTypesList[z].x;
                            if(typeof g_campusTags.deviceTypesList[z].y !== "undefined")
                                g_iDashboardImageY = g_campusTags.deviceTypesList[z].y;
                            if(typeof g_campusTags.deviceTypesList[z].imageLayout !== "undefined")
                                g_oDashboardImageLayout = g_campusTags.deviceTypesList[z].imageLayout;
                            replacementDps = g_campusTags.deviceTypesList[z].dpList;
                            break; // added so only go once
                        }
                        
                    }
                }
                if((campusTagsDeviceTypeIndex !== -1) && (replacementDps.length > 0) && !g_bIgnoreUserJsReplacements) {
                    for(j=0; j < dps.length; j ++)
                    {
                        for(k=0; k < replacementDps.length; k++)
                        {
                            if(checkIfDpsMatch(dps[j].blockName + "/" + dps[j].blockIndex + "/" + dps[j].datapointName, replacementDps[k].blockPath)) {
                                custom = {};
                                custom.label = replacementDps[k].label;
                                custom.useDefaults = false;
                                custom.dashboardType = replacementDps[k].displayType;
                                custom.writePriority = "all";
                                custom.clearPriority = "all";
                                custom.units = replacementDps[k].units;
                                custom.field = replacementDps[k].field;
                                custom.fieldPath = replacementDps[k].fieldPath;
                                custom.dropdownList = [];
                                custom.x = replacementDps[k].x;
                                custom.y = replacementDps[k].y;
                                custom.padding = replacementDps[k].padding;
                                custom.paddingChar = replacementDps[k].paddingChar;
                                custom.graphicDisplayType = replacementDps[k].graphicDisplayType;
                                custom.graphicType = replacementDps[k].graphicType;
                                custom.precision = replacementDps[k].precision;
                                custom.readonly = false; //replacementDps[k].precision; mike
                                custom.color = ""; //null;
                                custom.backgroundColor = ""; //null;
                                if((custom.x !== "") && (custom.y !== "")) {
                                    if(typeof replacementDps[k].dashboardColor !== "undefined") {
                                        if(replacementDps[k].dashboardColor !== "") {
                                            custom.dashboardColor = replacementDps[k].dashboardColor;
                                        }
                                    }
                                    if(typeof replacementDps[k].dashboardBackgroundColor !== "undefined") {
                                        if(replacementDps[k].dashboardBackgroundColor !== "") {
                                            custom.dashboardBackgroundColor = replacementDps[k].dashboardBackgroundColor;
                                        }
                                    }
                                    if(typeof replacementDps[k].dashboardBorderColor !== "undefined") {
                                        if(replacementDps[k].dashboardBorderColor !== "") {
                                            custom.dashboardBorderColor = replacementDps[k].dashboardBorderColor;
                                        }
                                    }
                                }
                                custom.guageObj = null;
                                if(typeof replacementDps[k].color !== "undefined") {
                                    if(replacementDps[k].color !== null) {
                                        if(typeof replacementDps[k].color !== "")
                                            custom.color = replacementDps[k].color;
                                    }
                                }
                                if(typeof replacementDps[k].backgroundColor !== "undefined") {
                                    if(replacementDps[k].backgroundColor !== null) {
                                        if(replacementDps[k].backgroundColor !== "")
                                        custom.backgroundColor = replacementDps[k].backgroundColor;
                                    }
                                }
                                if(typeof replacementDps[k].guageObj !== "undefined")
                                    custom.guageObj = replacementDps[k].guageObj;
                                if(typeof replacementDps[k].thermometerObj !== "undefined")
                                    custom.thermometerObj = replacementDps[k].thermometerObj;
                                bContinue = true;
                                if(g_currentUser === "OWNER") {
                                    if((replacementDps[k].visibility & OWNER) !== 0) // bit masked 
                                        bContinue = false;
                                    if((replacementDps[k].userReadonly & OWNER) !== 0) { // bitmasked
                                        if(dps[j].cat === "in")
                                            dps[j].cat === "out";
                                    }
                                }
                                else if(g_currentUser === "SUPERVISOR") {
                                    if((replacementDps[k].visibility & SUPERVISOR) !== 0)
                                        bContinue = false;
                                    if((replacementDps[k].userReadonly & SUPERVISOR) !== 0) {
                                        if(dps[j].cat === "in")
                                            dps[j].cat === "out";
                                    }
                                }
                                else if(g_currentUser === "USER") {
                                    if((replacementDps[k].visibility & USER) !== 0)
                                        bContinue = false;
                                    if((replacementDps[k].userReadonly & USER) !== 0) {
                                        if(dps[j].cat === "in")
                                            dps[j].cat === "out";
                                    }
                                    
                                }
                                if(bContinue) {
                                    if((custom.dashboardType === "s3") || (custom.dashboardType === "s4")) {
                                        if(dps[j].type === "SNVT_switch") {
                                            if(dps[j].cat === "out") {
                                                custom.dashboardType = "l" + custom.dashboardType.charAt(1);
                                            }
                                        }
                                    } 
                                    else if(custom.dashboardType === "c") {
                                        /* structures, enums and strings now supported so remove 
                                        custom.dashboardType = "n";
                                        if(typeof dps[j].value === "number") {
                                            custom.dashboardType = "c";
                                        }
                                        */
                                    }
                                    else if(custom.dashboardType === "d") {
                                        custom.dashboardType = "n";
                                        if(typeof dps[j].presets !== "undefined") {
                                            if(typeof dps[j].presets.map !== "undefined") {
                                                if(dps[j].presets.map.length > 0)
                                                    custom.dashboardType = "d";
                                            }
                                        }
                                    }
                                    else if(replacementDps[k].dashboardType === "d1") {
                                        custom.dashboardType = "n";
                                        if(replacementDps[k].dropdownList !== null) {
                                            custom.dashboardType = "d1";
                                            custom.dropdownList = replacementDps[k].dropdownList;
                                        }
                                    }
                                    
                                }

                                if(bContinue) {
                                    dps[j].custom = custom;
                                    if(g_currentUser === "USER") {
                                        if(replacementDps[k].UserTypeWritePriority !== null)
                                            dps[j].writePriority = replacementDps[k].UserTypeWritePriority;
                                        if(replacementDps[k].userClearPriority !== null)
                                            dps[j].clearPriority = replacementDps[k].userClearPriority;  
                                    }
                                    dpsTemp.push(JSON.parse(JSON.stringify(dps[j])))
                                    // remove as we now support fields and multiple displayelements per datapoint break;
                                }
                            }
                        }
                    }
                    
                    if(dpsTemp.length > 0)
                        json = dpsTemp;
                }
                bContinue = true;
                if(campusTagsDeviceTypeIndex !== -1) 
                    bContinue = false;
            }
            

            if(bContinue) {
                if((g_deviceTypesReplacementsDpList.length > 0) && !g_bIgnoreUserJsReplacements) {
                    z = -1;
                    for(m=0; m < 3; m ++)
                    {
                        for(j=0; j < g_deviceTypesReplacementsDpList.length; j ++)
                        {  // look for device name, followed by device type and finally by program ID
                            if(m === 0) {
                                if(g_deviceTypesReplacementsDpList[j].type == "d") { // device name
                                    if(g_deviceTypesReplacementsDpList[j].name.toLowerCase() == deviceDpList[i].deviceName.toLowerCase()){
                                        z = j;
                                        break;
                                    }
                                }
                            }
                            else if(m=== 1) {
                                if(g_deviceTypesReplacementsDpList[j].type == "dt") { // device type
                                    if(g_deviceTypesReplacementsDpList[j].name.toLowerCase() == deviceDpList[i].deviceTypeName.toLowerCase()){
                                        z = j;
                                        break;
                                    }
                                }

                            }
                            else if(m === 2) {
                                if(g_deviceTypesReplacementsDpList[j].type == "p") { // program ID
                                    if(g_deviceTypesReplacementsDpList[j].name.toLowerCase() == deviceDpList[i].programId.toLowerCase()){
                                        z = j;
                                        break;
                                    }
                                }
                            }
                        }
                        if(z !== -1)
                            break;

                    }
                    if(z !== -1) {
                        // check which dps match
                        g_DashboardImage = null;
                        g_iDashboardImageWidth = null;
                        g_iDashboardImageHeight = null;
                        g_iDashboardImageX = null;
                        g_iDashboardImageY = null;
                        g_oDashboardImageLayout = null;
                        if(typeof g_deviceTypesReplacementsDpList[z].image !== "undefined")
                            g_DashboardImage = g_deviceTypesReplacementsDpList[z].image;
                        if(typeof g_deviceTypesReplacementsDpList[z].width !== "undefined")
                            g_iDashboardImageWidth = g_deviceTypesReplacementsDpList[z].width;
                        if(typeof g_deviceTypesReplacementsDpList[z].height !== "undefined")
                            g_iDashboardImageHeight = g_deviceTypesReplacementsDpList[z].height;
                        if(typeof g_deviceTypesReplacementsDpList[z].x !== "undefined")
                            g_iDashboardImageX = g_deviceTypesReplacementsDpList[z].x;
                        if(typeof g_deviceTypesReplacementsDpList[z].y !== "undefined")
                            g_iDashboardImageY = g_deviceTypesReplacementsDpList[z].y;
                        if(typeof g_deviceTypesReplacementsDpList[z].imageLayout !== "undefined")
                            g_oDashboardImageLayout = g_deviceTypesReplacementsDpList[z].imageLayout;
                        
                        replacementDps = g_deviceTypesReplacementsDpList[z].dpList;
                        
                        if(replacementDps.length > 0) {
                            // some devices only have image, some have image and datapoint list
                            for(j=0; j < dps.length; j ++)
                            {
                                for(k=0; k < replacementDps.length; k++)
                                {
                                    if(checkIfDpsMatch(dps[j].blockName + "/" + dps[j].blockIndex + "/" + dps[j].datapointName, replacementDps[k].blockPath)) {
                                        custom = {};
                                        custom.useDefaults = false;
                                        custom.dashboardType = null;
                                        custom.writePriority = "all";
                                        custom.clearPriority = "all";
                                        custom.units = replacementDps[k].units;
                                        custom.field = replacementDps[k].field;
                                        custom.fieldPath = replacementDps[k].fieldPath;
                                        custom.dropdownList = [];
                                        custom.label = replacementDps[k].label = "";
                                        custom.x = replacementDps[k].x;
                                        custom.y = replacementDps[k].y;
                                        custom.width = replacementDps[k].width = "";
                                        custom.height = replacementDps[k].height = "";
                                        custom.padding = replacementDps[k].padding;
                                        custom.paddingChar = replacementDps[k].paddingChar;
                                        custom.alarmType = replacementDps[k].alarmType = "";
                                        custom.siteDashboard = replacementDps[k].siteDashboard = false; // used to specify point is used for site dashboard
                                        custom.graphicDisplayType = replacementDps[k].graphicDisplayType;
                                        custom.graphicType = replacementDps[k].graphicType;
                                        custom.layout = replacementDps[k].layout;
                                        custom.precision = replacementDps[k].precision;
                                        bContinue = true;
                                        if(g_currentUser === "OWNER") {
                                            if((replacementDps[k].visibility & OWNER) !== 0) // bit masked 
                                                bContinue = false;
                                            if((replacementDps[k].userReadonly & OWNER) !== 0) { // bitmasked
                                                if(dps[j].cat === "in")
                                                    dps[j].cat === "out";
                                            }
                                        }
                                        else if(g_currentUser === "SUPERVISOR") {
                                            if((replacementDps[k].visibility & SUPERVISOR) !== 0)
                                                bContinue = false;
                                            if((replacementDps[k].userReadonly & SUPERVISOR) !== 0) {
                                                if(dps[j].cat === "in")
                                                    dps[j].cat === "out";
                                            }
                                        }
                                        else if(g_currentUser === "USER") {
                                            if((replacementDps[k].visibility & USER) !== 0)
                                                bContinue = false;
                                            if((replacementDps[k].userReadonly & USER) !== 0) {
                                                if(dps[j].cat === "in")
                                                    dps[j].cat === "out";
                                            }
                                            
                                        }
                                        if(bContinue) {
                                            if((replacementDps[k].dashboardType === "s3") || (replacementDps[k].dashboardType === "s4")) {
                                                if(dps[j].type === "SNVT_switch") {
                                                    if(dps[j].cat === "out") {
                                                        custom.dashboardType = "l" + replacementDps[k].dashboardType.charAt(1);
                                                    }
                                                    else 
                                                        custom.dashboardType = replacementDps[k].dashboardType;
                                                }
                                            } 
                                            else if(replacementDps[k].dashboardType === "c") {
                                                if((typeof dps[j].value === "number") || (dps[j].value === null))
                                                    custom.dashboardType = replacementDps[k].dashboardType;
                                            }
                                            else if(replacementDps[k].dashboardType === "d") {
                                                if(typeof dps[j].presets !== "undefined") {
                                                    if(typeof dps[j].presets.map !== "undefined") {
                                                        if(dps[j].presets.map.length > 0)
                                                            custom.dashboardType = "d";
                                                    }
                                                }
                                            }
                                            else if(replacementDps[k].dashboardType === "d1") {
                                                if(replacementDps[k].dropdownList !== null) {
                                                    custom.dashboardType = "d1";
                                                    custom.dropdownList = replacementDps[k].dropdownList;
                                                }
                                            }
                                            else  {
                                                custom.dashboardType = replacementDps[k].dashboardType;
                                            }
                                        }

                                        if(bContinue) {
                                            dps[j].custom = custom;
                                            if(g_currentUser === "USER") {
                                                if(replacementDps[k].UserTypeWritePriority !== null)
                                                    dps[j].writePriority = replacementDps[k].UserTypeWritePriority;
                                                if(replacementDps[k].userClearPriority !== null)
                                                    dps[j].clearPriority = replacementDps[k].userClearPriority;  
                                            }
                                            dpsTemp.push(JSON.parse(JSON.stringify(dps[j])))
                                            break;
                                        }
                                    }
                                }
                            }
                            
                            if(dpsTemp.length > 0)
                                json = JSON.parse(JSON.stringify(dpsTemp));
                        }
                    }

                } // if(g_deviceTypesReplacementsDpList.length > 0)
            } // if(bContinue)
            //showDashboardUi(1, title, dps, "", g_bAddDeviceName); //ffix33333
            //return;
        }
    }
    //check if enum and setup write priorities
    bAtLeastOneEnum = false; // set true if need to get enum list
    g_dashboardGetSnvtTypes = [];
    for(i=0; i < json.length; i++)
    {

        json[i].isEnum = false;
        if(typeof json[i].value === "string") {
            z = -1;
            json[i].isEnum = true;
            if(json[i].cat === "in") {
                for(k=0; k < g_snvtTypes.length; k++)
                {
                    if(g_snvtTypes[k].typeId === json[i].type) {
                        if(g_snvtTypes[k].valueType === "ENUM") {
                            //enums = g_snvtTypes[i].typeJson.enum;
                            //bUseDropdown = true;
                            z = k;
                            break;
                        }
                    }
                }
                if(z === -1) {
                    bAtLeastOneEnum = true;
                    g_dashboardGetSnvtTypes.push(json[i].type);
                }
            }
        }
        if(json[i].cat === "in") {
            if(json[i].writePriority !== "all") {
                try {
                    z = json[i].writePriority;
                    if(json[i].writePriority.charAt(0) !== ">") {
                            // single priority
                            json[i].writePriorityStart = Number(z);
                            if((json[i].writePriorityStart > 0) && (json[i].writePriorityStart < 18)) {
                                json[i].writePriorityEnd = json[i].writePriorityStart + 1;
                                json[i].writePriorityNormal = false;
                            }
                    }
                    else {
                        // priority 
                        if(z.length > 1) {
                            z = z.substr(1);
                            json[i].writePriorityStart = Number(z);
                            if((json[i].writePriorityStart > 0) && (json[i].writePriorityStart < 18)) {
                                json[i].writePriorityNormal = true;
                            }
                        }
                    }
                }
                catch {
                    json[i].writePriorityStart = 1
                    json[i].writePriorityEnd = 17;
                    json[i].writePriorityNormal = true;
                }
            }
        }
    }
    if(bAtLeastOneEnum) {
        mode2 = {};
        mode2.mode = mode;
        mode2.json = json;
        getDashboardGetEnums(mode2);
    }
    else {
        showDashboardUi(21, mode, json, "", g_bAddDeviceName);
    }
    //showDashboardUi(1, mode, json, "", g_bAddDeviceName);
    
}
function showDashboardDeviceDpListResponseForSiteDashboard(mode, requestUrl, json) {
    // used for SiteDashboard, the contexts region, campus and building 
    // mode = device name
    var i, j, k, m, z = -1, obj, programmaticPathname, pathname, presetValue = "", locValueStr = "", locValue, unit, priority = -1, lon_cfg, sTemp;
    var sDeviceName = "";
    var bAtleastOneChartUsed = false;
    var custom = [];
    var deviceTypeName, programId;
    var dps = [], dpsTemp = [], replacementDps = [], mode2, deviceName, bContinue = true, campusTagsDeviceTypeIndex = -1;
    var bAtLeastOneEnum = false, image = "", width="", height="";
    var bAddDeviceNameToDpList = true;
    var bContinue, tempObj;
    var tags = {};
    dashboardDpList = [];
    if(json.length === 0)
        return;
    
    g_oDeviceDpList = {};
    g_oDeviceDpList.name = "";
    g_oDeviceDpList.dps = [];
    g_oDeviceDpList.dps = JSON.parse(JSON.stringify(json)); // needed  for data logs with enums;   
    if(g_sSiteDashboardSelected === "_sitedashboard") {
        if(g_campusTags.dashboard.length === 0)
            return; 
        tags = JSON.parse(JSON.stringify(g_campusTags.dashboard[0]));
    }
    else {
        // context dashboards
        if(g_campusTags.contextList.length === 0)
            return; 
        sTemp = g_sSiteDashboardSelected.toLowerCase();
        for(i=0; i < g_campusTags.contextList.length; i++)
        {
            if(g_campusTags.contextList[i].contextName.toLowerCase() === sTemp) {
                z = i;
                break;
            }
        }
        if(z === -1) {
            return;
        }
        
        tags = JSON.parse(JSON.stringify(g_campusTags.contextList[z]));
    }
    // check which dps match
    g_DashboardImage = null;
    g_iDashboardImageWidth = null;
    g_iDashboardImageHeight = null;
    g_iDashboardImageX = null;
    g_iDashboardImageY = null;
    g_oDashboardImageLayout = null;
    g_DashboardImageIcons = null;
    if(typeof tags.image !== "undefined")
        g_DashboardImage = tags.image;
    if(typeof tags.width !== "undefined")
        g_iDashboardImageWidth = tags.width;
    if(typeof tags.height !== "undefined")
        g_iDashboardImageHeight = tags.height;
    if(typeof tags.x !== "undefined")
        g_iDashboardImageX = tags.x;
    if(typeof tags.y !== "undefined")
        g_iDashboardImageY = tags.y;
    if(typeof tags.imageLayout !== "undefined")
        g_oDashboardImageLayout = tags.imageLayout;
    if(typeof tags.icons !== "undefined") {
        if(tags.icons !== null)
            g_DashboardImageIcons = tags.icons;
    }
    // sort datapoints -- so if more than one device matches a dp tag then matches are in alphabetical order 
    bContinue = true;
    for(i=0; i < json.length; i++)
    {
        json[i].sortOrder = json[i].deviceName + "__";
    }
    while(bContinue)
    {
        bContinue = false;
        for(i=0; i < json.length - 1; i++)
        {
            if(json[i].sortOrder > json[i + 1].sortOrder) {
                tempObj = {};
                tempObj = JSON.parse(JSON.stringify(json[i]));
                json[i] =  JSON.parse(JSON.stringify(json[i + 1]));
                json[i + 1] = JSON.parse(JSON.stringify(tempObj));
                bContinue = true;
            }
        }
    }
    for(i=0; i < json.length; i ++)
    {
        /*
        if(bAddDeviceNameToDpList) {
            bAddDeviceNameToDpList = false;
            g_oDeviceDpList.name = json[i].deviceName;
        }
        */
        unit = ""; presetValue = ""; locValueStr = ""; locValue = null; programmaticPathname = ""; pathname = ""; priority = -1;
        if(json[i].name === null)
            json[i].name = json[i].datapointName;
        programmaticPathname = json[i].deviceName + "/" + json[i].blockName  + "/" + json[i].blockIndex  + "/" + json[i].datapointName;
        pathname = json[i].deviceName + "/" + json[i].blockName  + "/" + json[i].blockIndex  + "/" + json[i].name;
        json[i].programmaticPathname = programmaticPathname;
        json[i].pathname = pathname;
        json[i].block = json[i].blockName  + "/" + json[i].blockIndex;
        json[i].urlPath = json[i].deviceName + "/if/" + json[i].blockName + "/" + json[i].blockIndex + "/";
		if(g_iSmartServerVersion >= 320114)
			json[i].urlPath += "*+xifName==";
		json[i].urlPath += json[i].datapointName;
        json[i].dpName = json[i].name;
        try { 
            presetValue = json[i].presetValue;
            if(presetValue === null)
                presetValue = "";
        } catch (err) {}
        json[i].presetValue = presetValue;
        json[i].bStructure = false;
        json[i].bNumber = false;
        json[i].bString = false; // enum
        try { 
            if(!(typeof json[i].locValue === "undefined")) {
                locValue = json[i].locValue;
                locValueStr = locValue;
                if(locValue !== null) {
                    if(typeof locValue === "number") {
                        locValueStr = locValue.toString();
                        json[i].bNumber = true;
                    }
                    else if(typeof locValue === "object") {
                        locValueStr = JSON.stringify(locValue);
                        if(locValueStr.length > 2) {
                            z = locValueStr.charAt(0);
                            m = locValueStr.charAt(locValueStr.length - 1);
                            if((locValueStr.charAt(0) === "{") && (locValueStr.charAt(locValueStr.length - 1) === "}")) {
                                json[i].bStructure = true;
                                locValueStr = locValueStr.substr(1, (locValueStr.length - 2));
                            }
                        }
                    }
                }
            }
        } catch (err) {}
        json[i].locValueStr = locValueStr;
        try {
            if(typeof json[i].values.level === "string")
                json[i].values.level = Number(json[i].values.level); // needed for iox. old software specified string and not a number
            priority = json[i].values.level;
        }
        catch (err) {}
        json[i].priority = priority;
        try { lon_cfg = obj["lon.cfg"];
            if(typeof lon_cfg.unit !== "undefined")
                unit = lon_cfg.unit;
            if(unit === null)
                unit = "";
        } catch (err) {}
        json[i].unit = unit;
        json[i].writePriority = g_OwnerUserTypeWritePriority;
        json[i].clearPriority = g_OwnerUserTypeClearPriority;
        json[i].custom = {};
        json[i].custom.useDefaults = true;
        if(g_currentUser === "SUPERVISOR") {
            json[i].writePriority = g_supervisorUserWriteTypePriority;
            json[i].clearPriority = g_supervisorUserTypeClearPriority;
        }
        else if(g_currentUser === "USER") {
            json[i].writePriority = g_userUserTypeWritePriority;
            json[i].clearPriority = g_userUserTypeClearPriority;
        }
        json[i].writePriorityStart = 1; 
        json[i].writePriorityEnd = 17;
        json[i].writePriorityNormal = true;
    
    
    
        for(k=0; k < tags.dpList.length; k++)
        {
            if(tags.dpList[k].pathname === programmaticPathname) { //pathname) {
                bContinue = false;
                if(g_bShowOnlyProvisionedDevicesOnSiteDashboard) {
                    z= -1;
                    for(j=0; j < deviceListAll.length; j++)
                    {
                        if(deviceListAll[j].name.toLowerCase() === tags.dpList[k].deviceName.toLowerCase()) {
                            if(deviceListAll[j].status.state === "provisioned")
                                bContinue = true;
                            break;
                        }
                    }
                }
                else 
                    bContinue = true;
                if(bContinue) {
                    dps = {};
                    dps = JSON.parse(JSON.stringify(json[i]));
                    custom = {};
                    custom.label = tags.dpList[k].label;
                    custom.useDefaults = false;
                    custom.dashboardType = tags.dpList[k].displayType;
                    custom.writePriority = "all";
                    custom.clearPriority = "all";
                    custom.units = tags.dpList[k].units;
                    custom.field = tags.dpList[k].field;
                    custom.fieldPath = tags.dpList[k].fieldPath;
                    custom.dropdownList = [];
                    custom.x = tags.dpList[k].x;
                    custom.y = tags.dpList[k].y;
                    custom.padding = tags.dpList[k].padding;
                    custom.paddingChar = tags.dpList[k].paddingChar;
                    custom.graphicDisplayType = tags.dpList[k].graphicDisplayType;
                    custom.graphicType = tags.dpList[k].graphicType;
                    custom.layout = tags.dpList[k].layout;
                    custom.precision = tags.dpList[k].precision;
                    if(typeof tags.dpList[k].width !== "undefined")
                        custom.width = tags.dpList[k].width;
                    if(typeof tags.dpList[k].height !== "undefined")
                        custom.height = tags.dpList[k].height;
                    if(typeof tags.dpList[k].fontsize !== "undefined")
                        custom.fontsize = tags.dpList[k].fontsize;
                    if(typeof tags.dpList[k].color !== "undefined")
                        custom.color = tags.dpList[k].color;
                    if(typeof tags.dpList[k].backgroundColor !== "undefined")
                        custom.backgroundColor = tags.dpList[k].backgroundColor;
                    if(typeof tags.dpList[k].imageSwapper !== "undefined")
                        custom.imageSwapper = tags.dpList[k].imageSwapper;
                    if((custom.x !== "") && (custom.y !== "")) {
                        if(typeof tags.dpList[k].dashboardColor !== "undefined") {
                            if(tags.dpList[k].dashboardColor !== "") {
                                custom.dashboardColor = tags.dpList[k].dashboardColor;
                            }
                        }
                        if(typeof tags.dpList[k].dashboardBackgroundColor !== "undefined") {
                            if(tags.dpList[k].dashboardBackgroundColor !== "") {
                                custom.dashboardBackgroundColor = tags.dpList[k].dashboardBackgroundColor;
                            }
                        }
                        if(typeof tags.dpList[k].dashboardBorderColor !== "undefined") {
                            if(tags.dpList[k].dashboardBorderColor !== "") {
                                custom.dashboardBorderColor = tags.dpList[k].dashboardBorderColor;
                            }
                        }
                    }

                    custom.contextOrder = tags.dpList[k].contextOrder + "__" + tags.dpList[k].deviceName + "__";
                    custom.readonly = true;
                    
                    custom.deviceTypeStr = tags.dpList[k].deviceTypeStr;
                    custom.bAddDeviceName = false; // if datapoint is specified for multiple device names, a device type or program Id then add device name to dashbaord UI
                    if(tags.dpList[k].deviceTypeStr.indexOf(";") !== -1)
                        custom.bAddDeviceName = true;
                    else if((tags.dpList[k].deviceTypeStr.charAt(0) === "(") || (tags.dpList[k].deviceTypeStr.charAt(0) === "["))
                        custom.bAddDeviceName = true;

                    custom.guageObj = tags.dpList[k].guageObj;
                    bContinue = true;
                    //if(dps.cat === "in")
                    //    dps.cat = "out";
                    
                    if(bContinue) {
                        if(custom.dashboardType === "n") {
                            //custom.dashboardType = "r";
                        }
                        if(custom.dashboardType === "s1") {
                            //custom.dashboardType = "s0";
                            custom.readonly = tags.dpList[k].readonly;
                            
                        }
                        else if((custom.dashboardType === "s2") || (custom.dashboardType === "s3") || (custom.dashboardType === "s4")) {
                            //custom.dashboardType = "l" + custom.dashboardType.charAt(1);
                        } 
                        else if(custom.dashboardType === "c") {
                            
                        }
                        else if(custom.dashboardType === "d") {
                            custom.dashboardType = "r";
                            if(typeof dps[j].presets !== "undefined") {
                                if(typeof dps[j].presets.map !== "undefined") {
                                    if(dps[j].presets.map.length > 0)
                                        custom.dashboardType = "d";
                                }
                            }
                        }
                        else if(custom.dashboardType === "d1") {
                            custom.dashboardType = "r";
                            if(replacementDps[k].dropdownList !== null) {
                                custom.dashboardType = "d1";
                                custom.dropdownList = replacementDps[k].dropdownList;
                            }
                        }
                        
                    }
                    if(bContinue) {
                        dps.custom = custom;
                        dpsTemp.push(JSON.parse(JSON.stringify(dps)));
                    }
                }
            }
        }
    }
    if(dpsTemp.length > 0)
        json = JSON.parse(JSON.stringify(dpsTemp));
    else
        json = [];
    
    // reorder datapoints based on .dp<number>
    bContinue = true;
    while(bContinue)
    {
        bContinue = false;
        for(i=0; i < json.length - 1; i++)
        {
            if(json[i].custom.contextOrder > json[i + 1].custom.contextOrder) {
                tempObj = {};
                tempObj = JSON.parse(JSON.stringify(json[i]));
                json[i] =  JSON.parse(JSON.stringify(json[i + 1]));
                json[i + 1] = JSON.parse(JSON.stringify(tempObj));
                bContinue = true;
            }
        }
    }

    //check if enum and setup write priorities
    bAtLeastOneEnum = false; // set true if need to get enum list
    g_dashboardGetSnvtTypes = [];
    for(i=0; i < json.length; i++)
    {

        json[i].isEnum = false;
        if(typeof json[i].value === "string") {
            z = -1;
            json[i].isEnum = true;
            if(json[i].cat === "in") {
                for(k=0; k < g_snvtTypes.length; k++)
                {
                    if(g_snvtTypes[k].typeId === json[i].type) {
                        if(g_snvtTypes[k].valueType === "ENUM") {
                            //enums = g_snvtTypes[i].typeJson.enum;
                            //bUseDropdown = true;
                            z = k;
                            break;
                        }
                    }
                }
                if(z === -1) {
                    bAtLeastOneEnum = true;
                    g_dashboardGetSnvtTypes.push(json[i].type);
                }
            }
        }
    }
    if(bAtLeastOneEnum) {
        mode2 = {};
        mode2.mode = mode;
        mode2.json = json;
        getDashboardGetEnums(mode2);
    }
    else {
        //if(g_sSiteDashboardSelected) {
            obj = {};
            obj.mode = 1;
            obj.title = "Site";
            obj.templateType = "";
            obj.bAddDeviceName = false;
            dashboardDpList = JSON.parse(JSON.stringify(json));
            sDeviceName = ""; // check if chart dp for more than one device
            // ffixmbw get data log
            mode = 21;
            if(g_bDashboardSupportLogData) {
                if(g_bDashboardGetDatalog && g_bSiteDashboardGetDatalog) {
                    if(mode < 22) {
    
                        for(i=0; i<dashboardDpList.length; i++)
                        {
                            if(typeof dashboardDpList[i].dashboardType !== "undefined" ) {
                                if((dashboardDpList[i].dashboardType === "c")
                                  || (dashboardDpList[i].dashboardType === "cr")
                                  || (dashboardDpList[i].dashboardType === "tc")  || (dashboardDpList[i].dashboardType === "lc")
                                  || dashboardDpList[i].dashboardType.startsWith("gc")  
                                  ) {
                                    bAtleastOneChartUsed = true;
                                    if(sDeviceName === "") {
                                        sDeviceName = dashboardDpList[i].deviceName;
                                    }
                                    else if(sDeviceName !== dashboardDpList[i].deviceName) {
                                        sDeviceName = ""; //get logs for all devices
                                        break;
                                    }
                                }
                            }
                            else {
                                if(typeof dashboardDpList[i].custom !== "undefined" ) {
                                    if(!dashboardDpList[i].custom.useDefaults) {
                                        if(typeof dashboardDpList[i].custom.dashboardType !== "undefined" ) {
                                            if((dashboardDpList[i].custom.dashboardType === "c") 
                                                || (dashboardDpList[i].custom.dashboardType === "cr")
                                                || (dashboardDpList[i].custom.dashboardType === "tc")  || (dashboardDpList[i].custom.dashboardType === "lc")
                                                || dashboardDpList[i].custom.dashboardType.startsWith("gc") 
                                                ) {
                                                    bAtleastOneChartUsed = true;
                                                    if(sDeviceName === "") {
                                                        sDeviceName = dashboardDpList[i].deviceName;
                                                    }
                                                    else if(sDeviceName !== dashboardDpList[i].deviceName) {
                                                        sDeviceName = ""; //get logs for all devices
                                                        break;
                                                    }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        if(bAtleastOneChartUsed) {
                            
                            getDashboardDatalogData(21, sDeviceName, "", g_bAddDeviceName);
                            return;
                        }
    
                    }
                    
                }
            }
            obj.mode = 1;
            showDashboardUiBuildWebpage(obj);
       // }
        
    }
    //showDashboardUi(1, mode, json, "", g_bAddDeviceName);
    
}

function showDashboardEnableMenu(bEnable) {
    try {
        var title = g_sDashboardDeviceName;
        var element = document.getElementById("editButton");
        var bDisabled = !bEnable;
        
        if(element !== null) 
            element.disabled = bDisabled;
        element = document.getElementById("showDeviceLogsButton_"+ title);
        if(element !== null) 
            element.disabled = bDisabled;
        element = document.getElementById("showDeviceScheduleButton_"+ title);
        if(element !== null) 
            element.disabled = bDisabled;
        if(g_bShowDeviceTestButton) {
            element = document.getElementById("testButton_"+ title);
            if(element !== null) 
                element.disabled = bDisabled;
        }
        element = document.getElementById("dashboardPauseButton");
        if(element !== null) 
            element.disabled = bDisabled;
        element = document.getElementById("dashboardClearChartsButton");
        if(element !== null) 
            element.disabled = bDisabled;
        
    }
    catch {}
   
}
function showDashboardUi(mode, title, objList, templateType, bAddDeviceName) {
    // mode: 0=show existing, 1=Show Device, 2=Show DpList, 4=Show FavList, 5= Contexts 60=use cached data
    // dashboardType: c = chart, n = normal, p = power, l = light, t = temperature, 
    // s0= span readonly structure, s1=span writeable structure, s2 = slider switch (binary), s3 = slider switch (SNVT_switch), s4 = slider switch (SNVT_switch 0 0 or 1 100 only), 
    // l2 = led
    //     xi = iox input level, xo = iox output level, xf= frequency xc = pulse_counter xr = relay, z = don't show (used for some iox datapoints)

    //          Process (performed using multiple functions)
    // Start with dashboardDpList listing which each item being a html element. This means that a datapoint can show up multiple times. 
    // Checks if IOX device, if so will try to determine which datapoints to use based on mode. For example if a DI is level then the SNVT_switch datapoint is shown.
    // Checks if any charts are used, if so it will get the data logs for that device. Getting data logs on large systems may take a long time so only get data logs if charts used.
    // Checks if it needs to get SNVT_types
    // Later dashboardDpList will be broken up into one object per datapoint with displayelements for each html element.
    //  - during this process data log data is added. The last entries are checked to see if the log data is newer than the current value as current value is read before the data log.
    //      in this case the data logs are removed so there isn't a time issue in the chart.
    // Should not be used for site dashboard, region, campus or building
    
    
    var i,j;  // i and t are used for indexes
    var paneContent = "<div style=\"text-align:center\"><br><div id=\"gettingInfoId\" class=\"gettingInfo\"></div></div>";
    var element, element1, sTemp;
    
    try {
        
        g_iMainDisplayMode = DISPLAYMODE_DASHBOARD;
        //document.getElementById("main").innerHTML =  paneContent;
        element = document.getElementById("planningPaneDetails_Details"); //navtree
        //    if(element !== null)
        //        element.innerHTML = paneContent;
        
               
        if(title !== "") {
            
            g_sDashboardTitle = g_sDashboardDevice;
        }
        else 
            g_sDashboardTitle = title;
        document.getElementById("dashboardTitle").innerHTML = title;
        g_editButtonElementList = []; 
        if(mode === 60) {
            // click show Dashboard - use cached values
           for(i=0; i < dashboardDpList.length; i++)
            {
                if(typeof dashboardDpList[i].chartIndex !== "undefined" ) {
                    if(dashboardDpList[i].chartIndex < g_dashboardChartList.length) {
                        j = dashboardDpList[i].chartIndex;
                        if(dashboardDpList[i].pathname === g_dashboardChartList[j].pathname) {
                            dashboardDpList[i].datalogData = JSON.parse(JSON.stringify(g_dashboardChartList[j].data));
                        }
                    }
                }
            }
            mode = 20;
        }
        g_dashboardChartList = [];   
        if((mode !== 0) && (mode < 20))
            g_sDashboardType = mode;
        
        if(objList !== null) {
            dashboardDpList = JSON.parse(JSON.stringify(objList));

        }
        if(dashboardDpList.length === 0) {
            paneContent = "<br><br><br>No Datapoints selected - Click on one of the following sidebar menu buttons to select datapoints for dashboard<br>Planning - select device";
            paneContent += "<br>Devices - click on device Menu<br>Datapoints - click on datapoint Menu<br>Favorite DPs - click on datapoint Menu";
            element = document.getElementById("planningPaneDetails_Details"); //navtree
            if(element !== null)
                element.innerHTML = paneContent;
           // document.getElementById("main").innerHTML =  paneContent;
            return;
        }
        else if(dashboardDpList.length > g_iDashboardMaxNumberOfDatapointsAllowed) {
            if(!g_bDashboardIngoreMaxNumberOfDatapointsAllowed) {
                paneContent = "<br><br>Too many datapoints - Dashboard only supports up to" + g_iDashboardMaxNumberOfDatapointsAllowed + " datapoints<br><br>This device has " + dashboardDpList.length + " datapoints";
                element = document.getElementById("planningPaneDetails_Details"); //navtree
                if(element !== null)
                    element.innerHTML = paneContent;
                sTemp = "<br><br>Too many datapoints for this device (" + dashboardDpList.length  +  "), which may make datapoints appear to be non-responsive\r\n\r\nClick OK to see datapoints or cancel to stop";
                //document.getElementById("main").innerHTML =  paneContent;
                //if(!confirm(sTemp))
                //    return;
                g_bDashboardIngoreMaxNumberOfDatapointsAllowed = true;
                element = document.getElementById("warningDiv");
                element1 = document.getElementById("warningOverlayDiv");
                try {
                    if((element === null) || (element1 === null))
                        return;
                    menuOverlayDivShow(7, null);
                    sTemp += "<br><br><div style=\"width:100%;text-align:right\">";
                    sTemp += "<button class=\"warningDivShowButton\" onclick=\"clearDashboardCharts1(" + mode + "," + title + "," + objList + "," + templateType + "," + bAddDeviceName + ")\">Continue</button>";
                    sTemp += "<button class=\"warningDivShowButton\" onclick=\"showAlertDialogHide()\">Cancel</button>";
                    sTemp += "</div>";
                    element.innerHTML = sTemp; 

                }
                catch {}
                
            }
        }
        showDashboardUi2(mode, title, objList, templateType, bAddDeviceName);
    }
    catch {}
}
function showDashboardUi1(mode, title, objList, templateType, bAddDeviceName) {
    g_bDashboardIngoreMaxNumberOfDatapointsAllowed = true;
    showDashboardUi2(mode, title, objList, templateType, bAddDeviceName);
}



function showDashboardUi2(mode, title, objList, templateType, bAddDeviceName) {
    // mode: 0=show existing, 1=Show Device, 2=Show DpList, 4=Show FavList, 5= Contexts 60=use cached data
    // dashboardType: c = chart, n = normal, p = power, l = light, t = temperature, 
    // s0= span readonly structure, s1=span writeable structure, s2 = slider switch (binary), s3 = slider switch (SNVT_switch), s4 = slider switch (SNVT_switch 0 0 or 1 100 only), 
    // l2 = led
    //     xi = iox input level, xo = iox output level, xf= frequency xc = pulse_counter xr = relay, z = don't show (used for some iox datapoints)

    //          Process (performed using multiple functions)
    // Start with dashboardDpList listing which each item being a html element. This means that a datapoint can show up multiple times. 
    // Checks if IOX device, if so will try to determine which datapoints to use based on mode. For example if a DI is level then the SNVT_switch datapoint is shown.
    // Checks if any charts are used, if so it will get the data logs for that device. Getting data logs on large systems may take a long time so only get data logs if charts used.
    // Checks if it needs to get SNVT_types
    // Later dashboardDpList will be broken up into one object per datapoint with displayelements for each html element.
    //  - during this process data log data is added. The last entries are checked to see if the log data is newer than the current value as current value is read before the data log.
    //      in this case the data logs are removed so there isn't a time issue in the chart.
    // Should not be used for site dashboard, region, campus or building
    
    var paneTitle = "";
    var bNoTemplateFound = true;  // supported templates: 6kEvbMultiSensor
    var i,j, k, s, t, x, y,w, z, iPtr, value;  // i and t are used for indexes
    var name1, obj, obj1, lfrequency = [], meterCharts = [], meterChartsOrder = [];
    var paneContent = "<div style=\"text-align:center\"><br><div id=\"gettingInfoId\" class=\"gettingInfo\"></div></div>";
    var tablePaneContent = "";
    var divNum = -1, dpListIndex;
    var index = 0;
    var tableColumnsMax = 2;
    var bAddTable = true;
    var bHasPresets = false,  bAddEndingDiv = false;
    var element, dashboardImageDivElement = null, offsets, graphicDpContentList = [];
    var presetValue;
    var bContinue, bContinue1 = false, tempObj, sTemp, sTemp1, valueStr, table, bAtLeastOneSvgElement = false,label, graphicDpContent = "", bAtleastOneChartUsed = false;
    var mode1 = null, modeIndex = -1, value = null, valueIndex = -1, switchIndex = -1, tempValue,tempValueStr;
    var pathname = "", shortPathname = "", programmaticPathname = "", shortDeviceName, field, fieldPath, displayId, dashboardType, fieldItems, alarmWarningLevel;
    var bShowLabelForDataPointname; // used to show label instead of datapoint pathname in charts or table
    var fullBlockPath;
    var bUnitsUsed = false;
    var bRemoveDeviceName = false; // only remove if all datapoints from single device
    var bUseDefault,json, bMatchFound = false;
    var displayElement = {};
    
    g_bAtLeastOneChartUsed = false;
    
    try {
        /* remove
        if(g_bDashboardSupportLogData) {
            if(g_bDashboardGetDatalog) {
                if(mode < 22) {

                    for(i=0; i<dashboardDpList.length; i++)
                    {
                        if(typeof dashboardDpList[i].dashboardType !== "undefined" ) {
                            if(dashboardDpList[i].dashboardType === "c") {
                                bAtleastOneChartUsed = true;
                                break;
                            }
                        }
                        if(!bAtleastOneChartUsed) {
                            if(typeof dashboardDpList[i].custom !== "undefined" ) {
                                if(dashboardDpList[i].custom.dashboardType === "c") {
                                    bAtleastOneChartUsed = true;
                                    break;
                                }
                            }
                        }
                    }
                    if(bAtleastOneChartUsed) {
                        getDashboardDatalogData(mode, title, templateType, bAddDeviceName);
                        return;
                    }

                }
                if(mode === 41)
                    mode = 1;
                else
                    mode -= 20;
            }
        }
        */
        if(g_bBuildDashboardDps) {
            // rebuild dashboardDpList as initial dashboardDpList may include fields.
            // reorder by 
            bContinue = true;
            while(bContinue)
            {
                bContinue = false;
                for(i=0; i < (dashboardDpList.length - 1); i++)
                {
                    // use space so that name1, name2, name11 go in correct order
                    if((dashboardDpList[i].pathname + " ") > (dashboardDpList[i + 1].pathname + " ")) {
                        bContinue = true;
                        tempObj = {};
                        tempObj = dashboardDpList[i];
                        dashboardDpList[i] = dashboardDpList[i + 1];
                        dashboardDpList[i + 1] = tempObj
                    }
                }

            }

            
            // create new  dashboardDpList with displayelements
            json = JSON.parse(JSON.stringify(dashboardDpList));
            dashboardDpList = [];
            if(json[0].deviceName.startsWith("iox") && json[0].deviceName.endsWith(".sys")) {
            
                        g_DashboardImage = "images/navtree/iox.png";
                        g_iDashboardImageHeight = 310;  
            }
            if(json[0].deviceName.startsWith("iox") && json[0].deviceName.endsWith(".dio")) {
                try {
                    // check if floorplan or campus tags already exist for this device is so ignore rest and use custom tags.
                    if(!dashboardCheckIfTagsAlreadyExist(json[0].deviceName)) {
                    // check dp mode and only use required dps
                    //if(json[0].deviceTypeName === "IOX_DIO") {
                        // determine DI

                        g_DashboardImage = "images/navtree/iox.png";
                        g_iDashboardImageHeight = 310;   
                        for(i=1; i < 9; i++)
                        { 
                            sTemp = "di/" + i + "/mode";
                            for(j=0; j < json.length; j++)
                            {
                                sTemp1 = json[j].block + "/" + json[j].datapointName;
                                if(sTemp === sTemp1) {
                                    if((json[j].value.type === "type_none") || (json[j].value.type === "none")) {
                                    }
                                    else if(json[j].value.type === "level") {
                                        sTemp = "di/" + i + "/switch";
                                        for(k=0; k < json.length; k++)
                                        {
                                            sTemp1 = json[k].block + "/" + json[k].datapointName;
                                            if(sTemp === sTemp1) {
                                                try {
                                                    dashboardDpList.push(JSON.parse(JSON.stringify(json[k])));
                                                    z = dashboardDpList.length - 1;
                                                    obj = {};
                                                    obj.useDefaults = false;
                                                    obj.label = "";
                                                    obj.field = "";
                                                    obj.fieldPath = "";
                                                    obj.dashboardType = "l4";
                                                    obj.units = "";
                                                    obj.x = "";
                                                    obj.y = "";
                                                    if(g_bIoxShowLedsOnImage) {
                                                        if((g_iIoxShowLedsOnImageDiX !== -1) && (g_iIoxShowLedsOnImageDiDeltaX !== -1) && (g_iIoxShowLedsOnImageDiY !== -1)) {
                                                            obj.x = g_iIoxShowLedsOnImageDiX + (i * g_iIoxShowLedsOnImageDiDeltaX);
                                                            obj.y = g_iIoxShowLedsOnImageDiY;
                                                            obj.graphicType = 1; // same as l4a
                                                        }
                                                    }
                                                    dashboardDpList[z].custom = obj;
                                                    if(g_iIoxHighestPriority !== -1) {
                                                        if(g_iIoxHighestPriority === 17)
                                                            dashboardDpList[z].writePriority = g_iIoxHighestPriority.toString();
                                                        else 
                                                            dashboardDpList[z].writePriority = ">" + g_iIoxHighestPriority.toString();
                                                        dashboardDpList[z].writePriorityStart = g_iIoxHighestPriority;
                                                    }
                                                } catch {}
                                                break;
                                            }
                                        }
                                    }
                                    else {
                                        sTemp = "di/" + i + "/input";
                                        for(k=0; k < json.length; k++)
                                        {
                                            sTemp1 = json[k].block + "/" + json[k].datapointName;
                                            if(sTemp === sTemp1) {
                                                try {
                                                    dashboardDpList.push(JSON.parse(JSON.stringify(json[k])));
                                                    z = dashboardDpList.length - 1;
                                                    obj = {};
                                                    obj.useDefaults = false;
                                                    obj.label = "";
                                                    obj.field = "";
                                                    obj.fieldPath = "";
                                                    obj.dashboardType = "r";
                                                    obj.units = "";
                                                    obj.x = "";
                                                    obj.y = "";
                                                    if(json[j].value.type === "counter") {
                                                        obj.field = "pulse_counter/counter_toggle/counter"
                                                        obj.fieldPath = json[k].block + "/" + json[k].datapointName + "/" + obj.field;
                                                        dashboardDpList[z].custom = obj;
                                                        if(g_iIoxHighestPriority !== -1) {
                                                            if(g_iIoxHighestPriority === 17)
                                                                dashboardDpList[z].writePriority = g_iIoxHighestPriority.toString();
                                                            else 
                                                                dashboardDpList[z].writePriority = ">" + g_iIoxHighestPriority.toString();
                                                            dashboardDpList[z].writePriorityStart = g_iIoxHighestPriority;
                                                        }
                                                    }
                                                    else if(json[j].value.type === "frequency") {
                                                        obj.label = "frequency " + i;
                                                        obj.field = "frequency"
                                                        obj.fieldPath = json[k].block + "/" + json[k].datapointName + "/" + obj.field;
                                                        obj.dashboardType = "c";
                                                        obj.units = "Hz";
                                                        dashboardDpList[z].custom = obj;
                                                        if(g_iIoxHighestPriority !== -1) {
                                                            if(g_iIoxHighestPriority === 17)
                                                                dashboardDpList[z].writePriority = g_iIoxHighestPriority.toString();
                                                            else 
                                                                dashboardDpList[z].writePriority = ">" + g_iIoxHighestPriority.toString();
                                                            dashboardDpList[z].writePriorityStart = g_iIoxHighestPriority;
                                                        }
                                                    }
                                                    else if(json[j].value.type === "toggle") {
                                                        obj.field = "level"
                                                        obj.fieldPath = json[k].block + "/" + json[k].datapointName + "/" + obj.field;
                                                        dashboardDpList[z].custom = obj;
                                                        if(g_iIoxHighestPriority !== -1) {
                                                            if(g_iIoxHighestPriority === 17)
                                                                dashboardDpList[z].writePriority = g_iIoxHighestPriority.toString();
                                                            else 
                                                                dashboardDpList[z].writePriority = ">" + g_iIoxHighestPriority.toString();
                                                            dashboardDpList[z].writePriorityStart = g_iIoxHighestPriority;
                                                        }
                                                    }
                                                }
                                                catch {}
                                                break;
                                            }
                                        } 
                                    }
                                    break;
                                }
                            }
                        }
                        // determine DO
                        for(i=1; i < 7; i++)
                        { 
                            sTemp = "do/" + i + "/mode";
                            for(j=0; j < json.length; j++)
                            {
                                sTemp1 = json[j].block + "/" + json[j].datapointName;
                                if(sTemp === sTemp1) {
                                    if((json[j].value.type === "type_none") || (json[j].value.type === "none")) {
                                    }
                                    else if(json[j].value.type === "level") {
                                        sTemp = "do/" + i + "/switch";
                                        for(k=0; k < json.length; k++)
                                        {
                                            sTemp1 = json[k].block + "/" + json[k].datapointName;
                                            if(sTemp === sTemp1) {
                                                try {
                                                    dashboardDpList.push(JSON.parse(JSON.stringify(json[k])));
                                                    z = dashboardDpList.length - 1;
                                                    obj = {};
                                                    obj.useDefaults = false;
                                                    obj.label = "";
                                                    obj.field = "";
                                                    obj.fieldPath = "";
                                                    obj.dashboardType = "s4";
                                                    obj.units = "";
                                                    obj.x = "";
                                                    obj.y = "";
                                                    if(g_bIoxShowLedsOnImage) {
                                                        if((g_iIoxShowLedsOnImageDoX !== -1) && (g_iIoxShowLedsOnImageDiDeltaX !== -1) && (g_iIoxShowLedsOnImageDoY !== -1)) {
                                                            obj.x = g_iIoxShowLedsOnImageDoX - (i * g_iIoxShowLedsOnImageDiDeltaX);
                                                            obj.y = g_iIoxShowLedsOnImageDoY;
                                                            obj.graphicType = 1; // same as l4a
                                                        }
                                                    }
                                                    dashboardDpList[z].custom = obj;
                                                    if(g_iIoxHighestPriority !== -1) {
                                                        if(g_iIoxHighestPriority === 17)
                                                            dashboardDpList[z].writePriority = g_iIoxHighestPriority.toString();
                                                        else 
                                                            dashboardDpList[z].writePriority = ">" + g_iIoxHighestPriority.toString();
                                                        dashboardDpList[z].writePriorityStart = g_iIoxHighestPriority;
                                                    }
                                                }
                                                catch {}
                                                break;
                                            }
                                        }
                                    }
                                    else {
                                        sTemp = "do/" + i + "/output";
                                        type = json[j].type;
                                        for(k=0; k < json.length; k++)
                                        {
                                            sTemp1 = json[k].block + "/" + json[k].datapointName;
                                            if(sTemp === sTemp1) {
                                                try {
                                                    dashboardDpList.push(JSON.parse(JSON.stringify(json[k])));
                                                    z = dashboardDpList.length - 1;
                                                    obj = {};
                                                    obj.useDefaults = false;
                                                    obj.label = "";
                                                    obj.field = "";
                                                    obj.fieldPath = "";
                                                    obj.dashboardType = "n";
                                                    obj.readonly = false;
                                                    obj.units = "";
                                                    obj.x = "";
                                                    obj.y = "";
                                                    if(json[j].value.type === "pulse") {
                                                        obj.label = "frequency " + i;
                                                        obj.field = "frequency"
                                                        obj.fieldPath = json[k].block + "/" + json[k].datapointName + "/" + obj.field;
                                                        obj.units = "Hz";
                                                        dashboardDpList[z].custom = obj;
                                                        if(g_iIoxHighestPriority !== -1) {
                                                            if(g_iIoxHighestPriority === 17)
                                                                dashboardDpList[z].writePriority = g_iIoxHighestPriority.toString();
                                                            else 
                                                                dashboardDpList[z].writePriority = ">" + g_iIoxHighestPriority.toString();
                                                            dashboardDpList[z].writePriorityStart = g_iIoxHighestPriority;
                                                        }
                                                    }
                                                    else if(json[j].value.type === "frequency") {
                                                        obj.dashboardType = "s1";
                                                        obj.label = "frequency " + i;
                                                        obj.field = "frequency"
                                                        //obj.fieldPath = json[k].block + "/" + json[k].datapointName + "/" + obj.field;
                                                        obj.units = "Hz";
                                                        dashboardDpList[z].custom = obj;
                                                        if(g_iIoxHighestPriority !== -1) {
                                                            if(g_iIoxHighestPriority === 17)
                                                                dashboardDpList[z].writePriority = g_iIoxHighestPriority.toString();
                                                            else 
                                                                dashboardDpList[z].writePriority = ">" + g_iIoxHighestPriority.toString();
                                                            dashboardDpList[z].writePriorityStart = g_iIoxHighestPriority;
                                                        }
                                                    }
                                                    else if(json[j].value.type === "pmw") {
                                                        obj.field = "pmw/pulse_counter/pulse_pwm/pwm/frequency"
                                                        obj.fieldPath = json[k].block + "/" + json[k].datapointName + "/" + obj.field;
                                                        obj.units = "Hz";
                                                        dashboardDpList[z].custom = obj;
                                                        if(g_iIoxHighestPriority !== -1) {
                                                            if(g_iIoxHighestPriority === 17)
                                                                dashboardDpList[z].writePriority = g_iIoxHighestPriority.toString();
                                                            else 
                                                                dashboardDpList[z].writePriority = ">" + g_iIoxHighestPriority.toString();
                                                            dashboardDpList[z].writePriorityStart = g_iIoxHighestPriority;
                                                        }
                                                    }
                                                }
                                                catch {}
                                                break;
                                            }
                                        } 
                                    }
                                    break;
                                }
                            }
                        }
                        for(j=0; j < json.length; j++)
                        {
                            if(json[j].datapointName === "relay-val") {
                                try {
                                    dashboardDpList.push(JSON.parse(JSON.stringify(json[j])));
                                    z = dashboardDpList.length - 1;
                                    obj = {};
                                    obj.useDefaults = false;
                                    obj.label = "";
                                    obj.field = "";
                                    obj.fieldPath = "";
                                    obj.dashboardType = "n";
                                    obj.readonly = false;
                                    obj.units = "";
                                    obj.x = "";
                                    obj.y = "";
                                    dashboardDpList[z].custom = obj;
                                    if(g_iIoxHighestPriority !== -1) {
                                        if(g_iIoxHighestPriority === 17)
                                            dashboardDpList[z].writePriority = g_iIoxHighestPriority.toString();
                                        else 
                                            dashboardDpList[z].writePriority = ">" + g_iIoxHighestPriority.toString();
                                        dashboardDpList[z].writePriorityStart = g_iIoxHighestPriority;
                                    }
                                }
                                catch {}
                            }
                        }
                        json = JSON.parse(JSON.stringify(dashboardDpList));
                    }
                }
                catch 
                {
                
                }
            }
            else if(json[0].deviceName.startsWith("iox") && json[0].deviceName.endsWith(".meter")) {
                try {
                    if(!dashboardCheckIfTagsAlreadyExist(json[0].deviceName)) {
                    // Show charts for any phase (voltaget, current frequency) which has a frequency
                    //if(json[0].deviceTypeName === "IOX_METER") {
                        // determine DI
                        g_DashboardImage = "images/navtree/iox.png";
                        g_iDashboardImageHeight = 310;
                        meterChartsOrder[0] = "N_voltage"; // order to see charts
                        meterChartsOrder[1] = "_current";
                        meterChartsOrder[2] = "_Frequency";
                        for(j=0; j <3; j++)
                        {
                            lfrequency[j] = false; 
                        }   
                        for(j=0; j < json.length; j++)
                        { // determine which phases have frequency > 0, show phase charts for any phase that has a frequency
                            if(json[j].datapointName === "nvoPhaseFrequency"){
                                for(k=1; k < 4; k++) // L1 through L3
                                {
                                    value = readFieldValue(json[j].value, "L" + k + "_Frequency");
                                    if(value.valid) {
                                        if(value.data > 0) {
                                            // display charts
                                            lfrequency[k - 1] = true; 
                                        }
                                    }
                                }
                            }
                        }
   
                        for(j=0; j < json.length; j++)
                        {
                            if((json[j].datapointName === "nvoPower") || (json[j].datapointName === "nvoVoltageAvg") || (json[j].datapointName === "nvoVoltageRMS")
                            || (json[j].datapointName === "nvoCurrentRMS") || (json[j].datapointName === "nvoActiveEnergy") || (json[j].datapointName === "nvoPhaseFrequency")){
                                dashboardDpList.push(JSON.parse(JSON.stringify(json[j])));
                                z = dashboardDpList.length - 1;
                                if(json[j].datapointName === "nvoPower") {
                                    obj = {};
                                    obj.useDefaults = false;
                                    obj.label = "";
                                    obj.field = "";
                                    obj.fieldPath = "";
                                    obj.readonly = true;
                                    obj.dashboardType = "c";
                                    obj.units = "Watts";
                                    obj.x = "";
                                    obj.y = "";
                                    dashboardDpList[z].custom = JSON.parse(JSON.stringify(obj));
                                    dashboardDpList[z].custom.field = "active_power"
                                    dashboardDpList[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + dashboardDpList[z].custom.field;

                                    dashboardDpList.push(JSON.parse(JSON.stringify(json[j])));
                                    z = dashboardDpList.length - 1;
                                    dashboardDpList[z].custom = JSON.parse(JSON.stringify(obj));
                                    dashboardDpList[z].custom.field = "reactive_power"
                                    dashboardDpList[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + dashboardDpList[z].custom.field;

                                    dashboardDpList.push(JSON.parse(JSON.stringify(json[j])));
                                    z = dashboardDpList.length - 1;
                                    dashboardDpList[z].custom = JSON.parse(JSON.stringify(obj));
                                    dashboardDpList[z].custom.field = "apparent_power"
                                    dashboardDpList[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + dashboardDpList[z].custom.field;
                                }
                                else if(json[j].datapointName === "nvoActiveEnergy") {
                                    obj = {};
                                    obj.useDefaults = false;
                                    obj.label = "";
                                    obj.field = "";
                                    obj.fieldPath = "";
                                    obj.readonly = true;
                                    obj.dashboardType = "r";
                                    obj.units = "KWH";
                                    obj.x = "";
                                    obj.y = "";
                                    dashboardDpList[z].custom = JSON.parse(JSON.stringify(obj));
                                    dashboardDpList[z].custom.field = "total"
                                    dashboardDpList[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + dashboardDpList[z].custom.field;
                                }
                                else if(json[j].datapointName === "nvoCurrentRMS") {
                                    obj = {};
                                    obj.useDefaults = false;
                                    obj.label = "";
                                    obj.field = "";
                                    obj.fieldPath = "";
                                    obj.readonly = true;
                                    obj.dashboardType = "r";
                                    obj.units = "Amps";
                                    obj.x = "";
                                    obj.y = "";
                                    dashboardDpList[z].custom = JSON.parse(JSON.stringify(obj));
                                    dashboardDpList[z].custom.field = "L1_current"
                                    dashboardDpList[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + dashboardDpList[z].custom.field;

                                    dashboardDpList.push(JSON.parse(JSON.stringify(json[j])));
                                    z = dashboardDpList.length - 1;
                                    dashboardDpList[z].custom = JSON.parse(JSON.stringify(obj));
                                    dashboardDpList[z].custom.field = "L2_current"
                                    dashboardDpList[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + dashboardDpList[z].custom.field;

                                    dashboardDpList.push(JSON.parse(JSON.stringify(json[j])));
                                    z = dashboardDpList.length - 1;
                                    dashboardDpList[z].custom = JSON.parse(JSON.stringify(obj));
                                    dashboardDpList[z].custom.field = "L3_current"
                                    dashboardDpList[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + dashboardDpList[z].custom.field;

                                    if(lfrequency[2]) {
                                        meterCharts.unshift(JSON.parse(JSON.stringify(json[j])));
                                        z = 0;
                                        meterCharts[z].custom = JSON.parse(JSON.stringify(obj));
                                        meterCharts[z].custom.field = "L3_current"
                                        meterCharts[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + meterCharts[z].custom.field;
                                        meterCharts[z].custom.dashboardType = "c";
                                    }
                                    if(lfrequency[1]) {
                                        meterCharts.unshift(JSON.parse(JSON.stringify(json[j])));
                                        z = 0;
                                        meterCharts[z].custom = JSON.parse(JSON.stringify(obj));
                                        meterCharts[z].custom.field = "L2_current"
                                        meterCharts[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + meterCharts[z].custom.field;
                                        meterCharts[z].custom.dashboardType = "c";
                                    }
                                    if(lfrequency[0]) {
                                        meterCharts.unshift(JSON.parse(JSON.stringify(json[j])));
                                        z = 0;
                                        meterCharts[z].custom = JSON.parse(JSON.stringify(obj));
                                        meterCharts[z].custom.field = "L1_current"
                                        meterCharts[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + meterCharts[z].custom.field;
                                        meterCharts[z].custom.dashboardType = "c";
                                    }

                                }
                                else if(json[j].datapointName === "nvoPhaseFrequency") {
                                    obj = {};
                                    obj.useDefaults = false;
                                    obj.label = "";
                                    obj.field = "";
                                    obj.fieldPath = "";
                                    obj.readonly = true;
                                    obj.dashboardType = "r";
                                    obj.units = "Hz";
                                    obj.x = "";
                                    obj.y = "";
                                    dashboardDpList[z].custom = JSON.parse(JSON.stringify(obj));
                                    dashboardDpList[z].custom.field = "L1_Frequency"
                                    dashboardDpList[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + dashboardDpList[z].custom.field;

                                    dashboardDpList.push(JSON.parse(JSON.stringify(json[j])));
                                    z = dashboardDpList.length - 1;
                                    dashboardDpList[z].custom = JSON.parse(JSON.stringify(obj));
                                    dashboardDpList[z].custom.field = "L2_Frequency"
                                    dashboardDpList[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + dashboardDpList[z].custom.field;

                                    dashboardDpList.push(JSON.parse(JSON.stringify(json[j])));
                                    z = dashboardDpList.length - 1;
                                    dashboardDpList[z].custom = JSON.parse(JSON.stringify(obj));
                                    dashboardDpList[z].custom.field = "L3_Frequency"
                                    dashboardDpList[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + dashboardDpList[z].custom.field;

                                    if(lfrequency[2]) {
                                        meterCharts.unshift(JSON.parse(JSON.stringify(json[j])));
                                        z = 0;
                                        meterCharts[z].custom = JSON.parse(JSON.stringify(obj));
                                        meterCharts[z].custom.field = "L3_Frequency"
                                        meterCharts[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + meterCharts[z].custom.field;
                                        meterCharts[z].custom.dashboardType = "c";
                                    }
                                    if(lfrequency[2]) {
                                        meterCharts.unshift(JSON.parse(JSON.stringify(json[j])));
                                        z = 0;
                                        meterCharts[z].custom = JSON.parse(JSON.stringify(obj));
                                        meterCharts[z].custom.field = "L2_Frequency"
                                        meterCharts[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + meterCharts[z].custom.field;
                                        meterCharts[z].custom.dashboardType = "c";
                                    }
                                    if(lfrequency[0]) {
                                        meterCharts.unshift(JSON.parse(JSON.stringify(json[j])));
                                        z = 0;
                                        meterCharts[z].custom = JSON.parse(JSON.stringify(obj));
                                        meterCharts[z].custom.field = "L1_Frequency"
                                        meterCharts[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + meterCharts[z].custom.field;
                                        meterCharts[z].custom.dashboardType = "c";
                                    }
                                }
                                else if(json[j].datapointName === "nvoVoltageAvg") {
                                    obj = {};
                                    obj.useDefaults = false;
                                    obj.label = "";
                                    obj.field = "";
                                    obj.fieldPath = "";
                                    obj.readonly = true;
                                    obj.dashboardType = "r";
                                    obj.units = "Volts";
                                    obj.x = "";
                                    obj.y = "";
                                    dashboardDpList[z].custom = JSON.parse(JSON.stringify(obj));
                                    dashboardDpList[z].custom.field = "average_LN_voltage"
                                    dashboardDpList[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + dashboardDpList[z].custom.field;

                                    dashboardDpList.push(JSON.parse(JSON.stringify(json[j])));
                                    z = dashboardDpList.length - 1;
                                    dashboardDpList[z].custom = JSON.parse(JSON.stringify(obj));
                                    dashboardDpList[z].custom.field = "average_LL_voltage"
                                    dashboardDpList[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + dashboardDpList[z].custom.field;
                                }
                                else if(json[j].datapointName === "nvoVoltageRMS") {
                                    obj = {};
                                    obj.useDefaults = false;
                                    obj.label = "";
                                    obj.field = "";
                                    obj.fieldPath = "";
                                    obj.readonly = true;
                                    obj.dashboardType = "r";
                                    obj.units = "Volts";
                                    obj.x = "";
                                    obj.y = "";
                                    dashboardDpList[z].custom = JSON.parse(JSON.stringify(obj));
                                    dashboardDpList[z].custom.field = "L1N_voltage"
                                    dashboardDpList[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + dashboardDpList[z].custom.field;

                                    dashboardDpList.push(JSON.parse(JSON.stringify(json[j])));
                                    z = dashboardDpList.length - 1;
                                    dashboardDpList[z].custom = JSON.parse(JSON.stringify(obj));
                                    dashboardDpList[z].custom.field = "L2N_voltage"
                                    dashboardDpList[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + dashboardDpList[z].custom.field;

                                    dashboardDpList.push(JSON.parse(JSON.stringify(json[j])));
                                    z = dashboardDpList.length - 1;
                                    dashboardDpList[z].custom = JSON.parse(JSON.stringify(obj));
                                    dashboardDpList[z].custom.field = "L3N_voltage"
                                    dashboardDpList[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + dashboardDpList[z].custom.field;

                                    dashboardDpList.push(JSON.parse(JSON.stringify(json[j])));
                                    z = dashboardDpList.length - 1;
                                    dashboardDpList[z].custom = JSON.parse(JSON.stringify(obj));
                                    dashboardDpList[z].custom.field = "L1L2_voltage"
                                    dashboardDpList[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + dashboardDpList[z].custom.field;

                                    dashboardDpList.push(JSON.parse(JSON.stringify(json[j])));
                                    z = dashboardDpList.length - 1;
                                    dashboardDpList[z].custom = JSON.parse(JSON.stringify(obj));
                                    dashboardDpList[z].custom.field = "L2L3_voltage"
                                    dashboardDpList[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + dashboardDpList[z].custom.field;

                                    dashboardDpList.push(JSON.parse(JSON.stringify(json[j])));
                                    z = dashboardDpList.length - 1;
                                    dashboardDpList[z].custom = JSON.parse(JSON.stringify(obj));
                                    dashboardDpList[z].custom.field = "L1L3_voltage"
                                    dashboardDpList[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + dashboardDpList[z].custom.field;

                                    if(lfrequency[2]) {
                                        meterCharts.unshift(JSON.parse(JSON.stringify(json[j])));
                                        z = 0;
                                        meterCharts[z].custom = JSON.parse(JSON.stringify(obj));
                                        meterCharts[z].custom.field = "L3N_voltage"
                                        meterCharts[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" +meterCharts[z].custom.field;
                                        meterCharts[z].custom.dashboardType = "c";
                                    }
                                    if(lfrequency[1]) {
                                        meterCharts.unshift(JSON.parse(JSON.stringify(json[j])));
                                        z = 0;
                                        meterCharts[z].custom = JSON.parse(JSON.stringify(obj));
                                        meterCharts[z].custom.field = "L2N_voltage"
                                        meterCharts[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + meterCharts[z].custom.field;
                                        meterCharts[z].custom.dashboardType = "c";
                                    }
                                    if(lfrequency[0]) {
                                        meterCharts.unshift(JSON.parse(JSON.stringify(json[j])));
                                        z = 0;
                                        meterCharts[z].custom = JSON.parse(JSON.stringify(obj));
                                        meterCharts[z].custom.field = "L1N_voltage"
                                        meterCharts[z].custom.fieldPath = json[j].block + "/" + json[j].datapointName + "/" + meterCharts[z].custom.field;
                                        meterCharts[z].custom.dashboardType = "c";
                                    }
                                }
                            }
                        }
                        if(meterCharts.length > 0) {
                            for(k=3; k > 0; k--)
                            {
                                for(m=2; m >= 0 ; m--)
                                {
                                    sTemp = "L" + k + meterChartsOrder[m];
                                    for(j=0; j < meterCharts.length; j++) {
                                        if(meterCharts[j].custom.field === sTemp) {
                                            dashboardDpList.unshift(JSON.parse(JSON.stringify(meterCharts[j])));
                                            break;
                                        } 
                                    }
                                }
                            }
                        }
                        json = JSON.parse(JSON.stringify(dashboardDpList));
                    }
                }
                catch 
                {
                
                }
            }
            else {
                // fix - add support for multiple display elements for a single datapoint - currently on one per datapoint but each datapoint can be in table/chart plus on grahics
            }

            obj = {};
            obj.mode = mode;
            obj.title = title, 
            obj.templateType = templateType;
            obj.bAddDeviceName = bAddDeviceName;
            g_oShowDashboardUi = obj;
            dashboardDpList = JSON.parse(JSON.stringify(json));


            if(g_bDashboardSupportLogData) {
                if(g_bDashboardGetDatalog) {
                    if(mode < 22) {
    
                        for(i=0; i<dashboardDpList.length; i++)
                        {
                            if(typeof dashboardDpList[i].dashboardType !== "undefined" ) {
                                if((dashboardDpList[i].dashboardType === "c")
                                  || (dashboardDpList[i].dashboardType === "cr")
                                  || (dashboardDpList[i].dashboardType === "tc")  || (dashboardDpList[i].dashboardType === "lc")
                                  || dashboardDpList[i].dashboardType.startsWith("gc")  
                                  ) {
                                    bAtleastOneChartUsed = true;
                                    break;
                                }
                            }
                            if(!bAtleastOneChartUsed) {
                                if(typeof dashboardDpList[i].custom !== "undefined" ) {
                                    if(!dashboardDpList[i].custom.useDefaults) {
                                        if(typeof dashboardDpList[i].custom.dashboardType !== "undefined" ) {
                                            if((dashboardDpList[i].custom.dashboardType === "c") 
                                                || (dashboardDpList[i].custom.dashboardType === "cr")
                                                || (dashboardDpList[i].custom.dashboardType === "tc")  || (dashboardDpList[i].custom.dashboardType === "lc")
                                                || dashboardDpList[i].custom.dashboardType.startsWith("gc") 
                                                ) {
                                                bAtleastOneChartUsed = true;
                                                break;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        if(bAtleastOneChartUsed) {
                            getDashboardDatalogData(mode, title, templateType, bAddDeviceName);
                            return;
                        }
    
                    }
                    if(mode === 41)
                        mode = 1;
                    else
                        mode -= 20;
                }
            }
            g_oShowDashboardUi.mode = mode;
            showDashboardUiBuildGetSnvtTypes();
        }
 
    }
    catch{}
}
function showDashboardUiBuildGetSnvtTypes() {
    //When first starting up SmartServer it is possible that the datapoint value has never been read so need to get SNVT type  to know how to set up the UI
    var i, j, k, z, obj;
    var missingValueDps = [];
    var missingSnvtTypes = [];
    try {
        obj = g_oShowDashboardUi;
        // check if any have value = null or is a chart
        for(i=0; i < dashboardDpList.length; i++)
        {
            if(dashboardDpList[i].value === null) {
                missingValueDps.push(JSON.parse(JSON.stringify(dashboardDpList[i])))
            }
            else if (typeof dashboardDpList[i].custom !== "undefined") {
                if(typeof dashboardDpList[i].custom.dashboardType !== "undefined") {
                    if(dashboardDpList[i].custom.dashboardType === "c") 
                        missingValueDps.push(JSON.parse(JSON.stringify(dashboardDpList[i])))
                }
            }
        }
        if(missingValueDps.length > 0){
            //alert("showDashboardUi at least one \"value=null\""); // remove
            
            for(i=0; i < missingValueDps.length; i++)
            {
                z = -1;
                for(j=0; j < missingSnvtTypes.length; j++)
                {
                    if(missingValueDps[i].type ===  missingSnvtTypes[j]) {
                        z = j;
                        break;
                    }
                }
                if(z === -1 )
                    missingSnvtTypes.push(JSON.parse(JSON.stringify(missingValueDps[i].type)));
            }
            if(missingSnvtTypes.length > 0) {
                // check if already have SNVT type
                k = 0;
                if(g_snvtTypes.length > 0) {
                    z = -1;
                    for(i=0; i < missingSnvtTypes; i++)
                    {
                        for(j=0; j < g_snvtTypes.length; j++)
                        {
                            if(g_snvtTypes[j].typeId === missingSnvtTypes[i]) {
                                z = j;
                                break;
                            }

                        }
                    }
                    if(z === -1)
                        k++;
                }
                else {
                    k = missingValueDps.length;
                }
            }
            if(k !== 0) {
                if(missingSnvtTypes.length === 1) {
                    // get only the missing SNVT Type --- fix only do if 4 or less missing
                    showDashboardUiGetSnvtType(1, obj, missingSnvtTypes[0]);
                }
                else {
                    // get all SNVT types
                    showDashboardUiGetAllSnvtType(1, obj)
                }
                return;
            }
            
        }
        if(dashboardDpList.length > 0)
            showDashboardUiBuildWebpage(obj);
       
    }
    catch {}
}
function showDashboardUiBuildWebpage(obj) {
       // mode: 0=show existing, 1=Show Device, 2=Show DpList, 4=Show FavList, 5= Contexts 60=use cached data
    // dashboardType: c = chart, n = normal, p = power, l = light, t = temperature, 
    // s0= span readonly structure, s1=span writeable structure, s2 = slider switch (binary), s3 = slider switch (SNVT_switch), s4 = slider switch (SNVT_switch 0 0 or 1 100 only), 
    // l2 = led, i=readonly imageswapper
    //     xi = iox input level, xo = iox output level, xf= frequency xc = pulse_counter xr = relay, z = don't show (used for some iox datapoints)
    // This functions builds the UI elements. Defaults is to dynamically create the UI. Custom tags allow you to specify column/row/elementcolumn or row/column
    
    var paneTitle = "";
    var bSingleDevice = false;
    var bDisableEditCheckbox = false;
    var bNoTemplateFound = true;  // supported templates: 6kEvbMultiSensor
    var h, i, i1, i2, j, k, s, t, x, y, v, w, z, iPtr;  // i and t are used for indexes
    var name1, obj, obj1, obj2, dpTypeParams, tableX = null, tableY = null, tableLayout = null;
    var paneContent = "<div style=\"text-align:center\"><br><div id=\"gettingInfoId\" class=\"gettingInfo\"></div></div>";
    var tablePaneContent = "";
    var tempContent = ""; // used for each UI element
    var divNum = -1, dpListIndex;
    var index = 0;
    var tableColumnsMax = 2;
    var bHasPresets = false,  bAddEndingDiv = false;
    var element, element1, dashboardImageDivElement = null, offsets, graphicDpContentList = [];
    var presetValue;
    var bContinue, bContinue1 = false, bContinue2 = false, bContinue3, tempObj, sTemp, sTemp1, sTemp2, valueStr, table, bAtLeastOneSvgElement = false,label, graphicDpContent = "";
    var mode1 = null, modeIndex = -1, value = null, value1, value2, valueIndex = -1, switchIndex = -1, tempValue,tempValueStr, locValue, locValueStr;
    var pathname = "", shortPathname = "", programmaticPathname = "", shortDeviceName, field, fieldPath, displayId, dashboardType, fieldItems, alarmWarningLevel, type1;
    var tempValue, tempValue1, tempValue2, backgroundColor;
    var deviceStatus = "";
    var bShowLabelForDataPointname; // used to show label instead of datapoint pathname in charts or table
    var fullBlockPath;
    var bUnitsUsed = false, temp, enums, minmax;
    var bRemoveDeviceName = false; // only remove if all datapoints from single device
    var bUseDefault,json = [], bMatchFound = false;
    var mode, title, objList, templateType, bAddDeviceName;
    var bAtLeastOneChartWithFields = false;
    var chartsfieldList = []; // If at least one chart with fields then this list is used to display the space so charts with fields and those without use the same amount of space
    var fieldList = []; // used for charting structured datapoints
    var defaultField = ""; // used for charting structured datapoints
    var bAtLeastOneChartWithFieldDropdown = false;
    var bAtLeastOneGuageUsed = false;
    var bAtleastOneWritableDp = false;
    var bImageAdded = false, iAddedChartIndex;
    var bReduceInputTextBoxSize = true;
    var iInputTextBoxSize = 9;
    var color, backgroundColor, borderColor;
    var bFixedLayout = false;
    var layoutList = []; // for fixed layout - lists all the UI elements  obj.layout, obj.content
    var layoutOrderList = []; // for fixed layout - list layout elements by column or row. cre layoutOrderList[].columnNumber, layoutOrderList[].rows = []
    var layoutUiList = []; // x,y fixed locations of UI elements like charts, and guages, used to put at absolute location, like on a picture or to have put elements at fixecd locations.
    var passCount = 9;
    var bTableUsed = true;
    var specialDevice = []; //used to put multiple ui elements on a single row. For example pulsgen and multisensor when site dashboard has too many datapoints
    var specialDevicesWithValue = [];
            

    try {
        g_bAtLeastOneChartUsed = false;
        g_iDashboardPriorityColumn = -1; 
        g_editButtonElementList = [];
        g_iDashboardTablePriorityColumnShowType = 0;
        g_bDashboardTableReadOnly = false;
        if(dashboardDpList === null)
            return;
        else {
            mode = obj.mode;
            title = obj.title;
            templateType = obj.templateType;
            bAddDeviceName = obj.bAddDeviceName;
            if(g_sSiteDashboardSelected !== "") {
                //mike
                title = "Site";
                templateType = "";

            }
            else {
                bSingleDevice = true;
                //disable edit button if device is not provisioned
            }
            if(dashboardDpList.length > 0)
                json = JSON.parse(JSON.stringify(dashboardDpList));
            dashboardDpList = [];
            g_iDisplayIndex = 0;
            if(g_oDashboardLayout !== null) {
                if(g_oDashboardLayout.layout !== "") { //.layout .table.x .eWidth .eHeight = height;
                    if((g_oDashboardLayout.layout === "cre") || (g_oDashboardLayout.layout === "cr") ||  (g_oDashboardLayout.layout === "rc")) {
                       bFixedLayout = true;
                    }
                    bContinue2 = true;
                    // check if table included
                    if(g_oDashboardLayout.table !== null) {
                        if(!g_oDashboardLayout.table.enabled)
                            bTableUsed = false;
                        if(bTableUsed) {
                            if((g_oDashboardLayout.table.x !== null) && (g_oDashboardLayout.table.y !== null)) {
                                if((g_oDashboardLayout.table.x !== -1) && (g_oDashboardLayout.table.y !== -1)) {
                                    tableX = g_oDashboardLayout.table.x;
                                    tableY = g_oDashboardLayout.table.y;
                                    // 1 doesn't work g_iDashboardTablePriorityColumnShowType = 1; // use display inline-block and none
                                }
                                
                            }
                            if((tableX === null) && (tableX === null)) {
                                if((g_oDashboardLayout.table.c !== -1) || (g_oDashboardLayout.table.r !== -1) || (g_oDashboardLayout.table.e !== -1)) {
                                    tableLayout = JSON.parse(JSON.stringify(g_oDashboardLayout.table));
                                    // 1 doesn't work g_iDashboardTablePriorityColumnShowType = 1; // use display inline-block and none
                                }
                            }
                            if(g_oDashboardLayout.table.readonly)
                                g_bDashboardTableReadOnly = true;
                            if(g_oDashboardLayout.table.showPriorities)
                                g_iDashboardTablePriorityColumnShowType = 2;
                        }
                    }
                }
            }



            for(j=0; j < json.length; j++)
            {
                z = -1;
                for(i=0; i < dashboardDpList.length; i++)
                {
                    if(json[j].programmaticPathname === dashboardDpList[i].programmaticPathname) {
                        z = i;
                        break;
                    }
                }
                if(z === -1) {
                    obj = {};
                    obj = JSON.parse(JSON.stringify(json[j]));
                    //obj.createBrowserGrapic = true;
                    obj.updateDpValue = false;
                    obj.bNumber = false;
                    obj.bStructure = false;
                    obj.bString = false;
                    obj.bBoolean = false;
                    obj.readonly = true;
                    obj.bArray = false; // []
                    obj.bObject = false; // {}
                    obj.displayElements = []; // add one entry for each display element -- used to support fields, or see datapoint more than once on web page
                    field = "";
                    if(typeof obj.field !== "undefined") {
                        if(obj.field !== null) {
                            if(obj.field !== "") {
                                field = obj.field;
                            }
                        }
                    }


                    if(obj.cat === "in") {
                        obj.feedbackDelay = true;
                        obj.feedbackDelayTimeout = 0;
                        obj.feedbackDelayOldValue = null;
                    }
                    if(obj.pathname === "") {
                        obj.pathname = obj.programmaticPathname;
                    }
                    if(obj.pathname.startsWith("iox")) {
                        obj.shortPathName = obj.pathname;
                        obj.shortDeviceName = obj.deviceName;
                    }
                    else {
                        // remove CT subsystems
                        shortPathname = obj.pathname;
                        iPtr = shortPathname.indexOf("/");
                        if(iPtr > 0) {
                            iPtr = shortPathname.lastIndexOf(".", iPtr - 1);
                            if(iPtr > 0)
                                shortPathname = shortPathname.substr(iPtr + 1);
                        }
                        obj.shortPathName = shortPathname;
                        
                        shortDeviceName = obj.deviceName;
                        iPtr = shortDeviceName.lastIndexOf(".");
                        if(iPtr > 0) {
                            sTemp = shortDeviceName.substr(iPtr + 1);
                            if(isNaN(sTemp))
                                shortDeviceName = sTemp;
                            else { 
                                // subsystem 1.datalog.1
                                iPtr = shortDeviceName.lastIndexOf(".", (iPtr - 1));
                                if(iPtr > 0) 
                                    shortDeviceName = shortDeviceName.substr(iPtr + 1);
                            }
                        }
                        obj.shortDeviceName = shortDeviceName;
                    }
                    locValue = obj.locValue;
                    if(field !== "") {
                        if(locValue !== null) {
                            value2 = readFieldValue(locValue, field);
                            if(value2.valid)
                                locValue = value2.data;
                        }
                    }
                    locValueStr = "";
                    z = -1;
                    for(i=0; i < g_snvtTypes.length; i++)
                    {
                        if(obj.type === g_snvtTypes[i].typeId) {
                            z = i;
                            
                            break;
                        }
                    }
                    if(z !== -1) {
                        obj1 = JSON.parse(JSON.stringify(g_snvtTypes[z]));
                        if(obj1.valueType.toLowerCase() === "object") {
                            obj.bStructure = true;
                            locValueStr = JSON.stringify(locValue);
                            if(locValueStr.length > 2) {
                                if((locValueStr.charAt(0) === "{") && (locValueStr.charAt(locValueStr.length - 1) === "}")) {
                                    obj.bObject = true;
                                    if(locValue !== null)
                                        locValueStr = locValueStr.substr(1, (locValueStr.length - 2));
                                }
                                else if((locValueStr.charAt(0) === "[") && (locValueStr.charAt(locValueStr.length - 1) === "]")) {
                                    obj.bArray = true;
                                }
                            }
                        }
                        else if(obj1.valueType.toLowerCase() === "boolean") {
                            obj.bNumber = true;
                            if(locValue !== null)
                                locValueStr = locValue.toString();
                        }
                        else if(obj1.valueType.toLowerCase() === "enum") {
                            obj.bEnum = true;
                            if(locValue !== null)
                                locValueStr = locValue;
                        }
                        else if (obj1.valueType.toLowerCase() === "string") {
                            obj.bString = true;
                            if(locValue !== null)
                                locValueStr = locValue;
                        }
                        else if((obj1.valueType.toLowerCase() === "integer") || (obj1.valueType.toLowerCase() === "float")){
                            obj.bNumber = true;
                            if(locValue !== null)
                                locValueStr = locValue.toString();
                        }
                    }

                    else if(obj.value === null) {
                        // change code to look at SNVT type
                        
                        locValueStr = "";
                    }
                    else if(typeof locValue === "object") {
                        obj.bStructure = true;
                        locValueStr = JSON.stringify(locValue);
                        if(locValueStr.length > 2) {
                            if((locValueStr.charAt(0) === "{") && (locValueStr.charAt(locValueStr.length - 1) === "}")) {
                                obj.bObject = true;
                                locValueStr = locValueStr.substr(1, (locValueStr.length - 2));
                            }
                            else if((locValueStr.charAt(0) === "[") && (locValueStr.charAt(locValueStr.length - 1) === "]")) {
                                obj.bArray = true;
                            }
                        }
                    }
                    else if((typeof locValue === "string") || obj.isEnum) {
                        // isEnum means check if string or enum

                        obj.bString = true;
                        locValueStr = locValue;
                    }
                    else if(typeof locValue === "number") {
                        obj.bNumber = true;
                        locValueStr = locValue.toString();
                    }
                    else if(typeof locValue === "boolean") {
                        obj.bBoolean = true;
                        locValueStr = locValue.toString();
                    }
                    obj.locValueStr = locValueStr;
                    if(typeof obj.values === "undefined")  // some iox doen't have values (priority array)
                        obj.values = null;
                    obj.alarm = null;
                    
                    
                    // check if alarm
                    for(i=0; i < g_deviceAlarmsList.length; i++)
                    {
                        if(g_deviceAlarmsList[i].deviceId === obj.deviceId) {
                            for(k=0; k < g_deviceAlarmsList[i].alarms.length; k++)
                            {
                                if(g_deviceAlarmsList[i].alarms[k].pathname === obj.pathname) {
                                    obj.alarm = JSON.parse(JSON.stringify(g_deviceAlarmsList[i].alarms[k]));
                                    i = g_deviceAlarmsList.length + 2
                                    break;
                                }
                               
                            }
                        }
                    }    
                    dashboardDpList.push(obj)
                    z = dashboardDpList.length - 1;
                    

                }
                if(z !== -1) {
                    obj = {};
                    obj.label = "";
                    obj.dashboardType = "";
                    obj.custom = json[j].custom;
                    g_iDisplayIndex ++;
                    obj.displayIndex = g_iDisplayIndex;
                    obj.createBrowserGrapic = true;
                    obj.bNumber = false;
                    obj.bStructure = false;
                    obj.bString = false;
                    obj.bEnum = false;
                    obj.bBoolean = false;
                    obj.readonly = true;
                    obj.array = false; // []
                    obj.object = false; // {}
                    obj.writeable = false;
                    obj.field = "";
                    obj.fieldPath = "";
                    obj.chartIndex = null;
                    obj.bShowLabelForDataPointname = false;
                    obj.bHasPriorityButton = false;
                    obj.sWidth = "";
                    obj.x = ""; // used to position datapoint on graphic
                    obj.y = ""; // used to position datapoint on graphic
                    obj.padding = "";
                    obj.paddingChar = "";
					obj.graphicAlarmType = ""; // used to position datapoint on graphic
                    obj.graphicDisplayType = ""; // used to position datapoint on graphic
                    obj.units = "";
                    obj.graphicType = 0; // used with l2 and l4 to show different size dots
                    obj.precision = -1; // used to override localization precision.
                    obj.width = "";
                    obj.height = "";
                    obj.fontsize = "";
                    obj.color = "";  // for leds and sliders this is the ON color
                    obj.backgroundColor = ""; // for leds and sliders this is the OFF color
                    obj.borderColor = ""; // for leds and sliders this is the border color
                    obj.layout = null;
                    obj.bFunction = false; //bFunction and function are used if there is a conversion function like celsius to fahrenheit and vice versa
                    obj.function = "";
                    
                    obj.fullBlockPath =  dashboardDpList[z].programmaticPathname // including fiels 
                    
                    if(!json[j].custom.useDefaults) {
                        obj.label = json[j].custom.label;
                        obj.field = json[j].custom.field;
                        obj.fieldPath = json[j].custom.fieldPath;
                        obj.readonly = json[j].custom.readonly;
                        obj.x = json[j].custom.x;
                        obj.y = json[j].custom.y;
                        obj.units = json[j].custom.units;
                        obj.padding = json[j].custom.padding;
                        obj.paddingChar = json[j].custom.paddingChar;
                        obj.graphicType = json[j].custom.graphicType;
                        obj.precision = json[j].custom.precision;
                        obj.layout = json[j].custom.layout;
                        obj.guageObj = null;
                        if(typeof json[j].custom.sWidth)
                            obj.sWidth = json[j].custom.sWidth;
                        if(g_sSiteDashboardSelected !== "")
                            obj.bAddDeviceName = json[j].custom.bAddDeviceName;
                        if(typeof json[j].custom.guageObj !== "undefined") {
                            if(json[j].custom.guageObj !== null)
                                obj.guageObj = json[j].custom.guageObj;
                        }
                        obj.graphicDisplayType = "";
                        if(typeof json[j].custom.graphicDisplayType !== "undefined")
                            obj.graphicDisplayType = json[j].custom.graphicDisplayType;
                        if(typeof json[j].custom.width !== "undefined")
                            obj.width = json[j].custom.width;
                        if(typeof json[j].custom.height !== "undefined")
                            obj.height = json[j].custom.height;
                        if(typeof json[j].custom.fontsize !== "undefined")
                            obj.fontsize = json[j].custom.fontsize;
                        if(typeof json[j].custom.color !== "undefined") {
                            if(json[j].custom.color !== null) {
                                if(json[j].custom.color !== "")
                                    obj.color = json[j].custom.color;
                            }
                        }
                        if(json[j].custom.backgroundColor !== "undefined") {
                            if(json[j].custom.backgroundColor !== "undefined") {
                                if(json[j].custom.backgroundColor !== "undefined")
                                    obj.backgroundColor = json[j].custom.backgroundColor;
                            }
                        }
                        if(json[j].custom.borderColor !== "undefined") {
                            if(json[j].custom.borderColor !== "undefined") {
                                if(json[j].custom.borderColor !== "undefined")
                                    obj.borderColor = json[j].custom.borderColor;
                            }
                        }
                        
                        if(typeof json[j].custom.imageSwapper !== "undefined")
                            obj.imageSwapper = json[j].custom.imageSwapper;

                        if(typeof json[j].custom.thermometerObj !== "undefined")
                            obj.thermometerObj = json[j].custom.thermometerObj;
                        
                        if(json[j].custom.dashboardType !== "") { 
                            obj.dashboardType = json[j].custom.dashboardType;
                        }
                        
                    }
                    else {
                        // 
                        if(json[j].cat === "in")
                            obj.readonly = false;
                    }
                    obj.displayId =  g_iDisplayIndex + "__" + json[j].programmaticPathname;
                    if(obj.field !== "") {
                        obj.displayId += "/" + obj.field;
                        obj.fullBlockPath += "/" + obj.field;
                    }
                    obj.defaultDashboardType =  obj.dashboardType;
                    
                    dashboardDpList[z].displayElements.push(JSON.parse(JSON.stringify(obj)));
                    iAddedChartIndex = -1;
                    // check if "gc", if so add chart display element
                    if(obj.dashboardType === "gc") {
                        w = dashboardDpList[z].displayElements.length - 1;
                        dashboardDpList[z].displayElements[w].dashboardType = "gchart";
                        iAddedChartIndex = w;
                        g_iDisplayIndex ++;
                        dashboardDpList[z].displayElements[w].guageObj.guageDisplayElementIndex = w + 1;
                        
                        dashboardDpList[z].displayElements.push(JSON.parse(JSON.stringify(obj)));
                        w = dashboardDpList[z].displayElements.length - 1;
                        dashboardDpList[z].displayElements[w].dashboardType = "gc";
                        dashboardDpList[z].displayElements[w].displayIndex = g_iDisplayIndex;
                        dashboardDpList[z].displayElements[w].displayId =  g_iDisplayIndex + "__" + json[j].programmaticPathname;
                        dashboardDpList[z].displayElements[w].guageObj.chartDisplayElementIndex = w - 1;
                    }
                    // check if "t", if so add chart display element
                    if((obj.dashboardType === "tc")  || (obj.dashboardType === "lc")){
                        w = dashboardDpList[z].displayElements.length - 1;
                        dashboardDpList[z].displayElements[w].dashboardType = "gchart";
                        iAddedChartIndex = w;
                        g_iDisplayIndex ++;
                        dashboardDpList[z].displayElements[w].thermometerObj.guageDisplayElementIndex = w + 1;
                        
                        dashboardDpList[z].displayElements.push(JSON.parse(JSON.stringify(obj)));
                        w = dashboardDpList[z].displayElements.length - 1;
                        dashboardDpList[z].displayElements[w].dashboardType = obj.dashboardType;
                        dashboardDpList[z].displayElements[w].displayIndex = g_iDisplayIndex;
                        dashboardDpList[z].displayElements[w].displayId =  g_iDisplayIndex + "__" + json[j].programmaticPathname;
                        dashboardDpList[z].displayElements[w].thermometerObj.chartDisplayElementIndex = w - 1;
                    }

                    // check if display element on device image, if so then first push for dashboard x,y and add second display element for non-dashboard image
                    if((typeof obj.x === "number") && (typeof obj.y === "number")) {
                        k =  dashboardDpList[z].displayElements.length - 1;
                        if(obj.graphicDisplayType === "")
                            obj.graphicDisplayType = obj.dashboardType;
                        if((obj.graphicDisplayType === "r") || (obj.graphicDisplayType === "n") || (obj.graphicDisplayType === "c"))
                            dashboardDpList[z].displayElements[k].dashboardType = "r";
						else if((obj.graphicDisplayType === "s2") || (obj.graphicDisplayType === "l2"))
                            dashboardDpList[z].displayElements[k].dashboardType = "l2";
						else if((obj.graphicDisplayType === "s3") || (obj.graphicDisplayType === "l3"))
                            dashboardDpList[z].displayElements[k].dashboardType = "l4";	
                        else if((obj.graphicDisplayType === "s4") || (obj.graphicDisplayType === "l4"))
                            dashboardDpList[z].displayElements[k].dashboardType = "l4";	
                        else if(obj.graphicDisplayType === "i") 
                            dashboardDpList[z].displayElements[k].dashboardType = "i";
                        else if(obj.graphicDisplayType === "t1") 
                            dashboardDpList[z].displayElements[k].dashboardType = "t1";
                        else if(obj.graphicDisplayType === "led1") 
                            dashboardDpList[z].displayElements[k].dashboardType = "led1";
                        else if((obj.graphicDisplayType === "pb") || (obj.graphicDisplayType === "lr2") || (obj.graphicDisplayType === "lr4")  || (obj.graphicDisplayType === "rbt"))
                            dashboardDpList[z].displayElements[k].dashboardType = obj.graphicDisplayType;
                        else
                            dashboardDpList[z].displayElements[k].dashboardType = "r";
                        dashboardDpList[z].displayElements[k].defaultDashboardType = dashboardDpList[z].displayElements[k].dashboardType;
                        if((obj.graphicDisplayType === "s2") || (obj.graphicDisplayType === "l2") || (obj.graphicDisplayType === "s3") || (obj.graphicDisplayType === "l3")
                            || (obj.graphicDisplayType === "s4") || (obj.graphicDisplayType === "l4")) {
                            if(typeof json[j].custom.dashboardColor !== "undefined") {
                                if(json[j].custom.dashboardColor !== null) {
                                    if(json[j].custom.dashboardColor !== "")
                                        dashboardDpList[z].displayElements[k].color = json[j].custom.dashboardColor;
                                }
                            }
                            if(typeof json[j].custom.dashboardBackgroundColor !== "undefined") {
                                if(json[j].custom.dashboardBackgroundColor !== null) {
                                    if(json[j].custom.dashboardBackgroundColor !== "")
                                        dashboardDpList[z].displayElements[k].backgroundColor = json[j].custom.dashboardBackgroundColor;
                                }
                            }
                            if(typeof json[j].custom.dashboardBorderColor !== "undefined") {
                                if(json[j].custom.dashboardBorderColor !== null) {
                                    if(json[j].custom.dashboardBorderColor !== "")
                                        dashboardDpList[z].displayElements[k].borderColor = json[j].custom.dashboardBorderColor;
                                }
                            }
                        }
                        else {
                            if(typeof json[j].custom.dashboardColor !== "undefined") {
                                if(json[j].custom.dashboardColor !== null) {
                                    if(json[j].custom.dashboardColor !== "")
                                        dashboardDpList[z].displayElements[k].color = json[j].custom.dashboardColor;
                                }
                            }
                            if(typeof json[j].custom.dashboardBackgroundColor !== "undefined") {
                                if(json[j].custom.dashboardBackgroundColor !== null) {
                                    if(json[j].custom.dashboardBackgroundColor !== "")
                                        dashboardDpList[z].displayElements[k].backgroundColor = json[j].custom.dashboardBackgroundColor;
                                }
                            }
                            if(typeof json[j].custom.dashboardBorderColor !== "undefined") {
                                if(json[j].custom.dashboardBorderColor !== null) {
                                    if(json[j].custom.dashboardBorderColor !== "")
                                        dashboardDpList[z].displayElements[k].borderColor = json[j].custom.dashboardBorderColor;
                                }
                            }
                        }
                        if(!json[j].custom.useDefaults) {
                            if(typeof json[j].custom.graphicType !== "undefined")
                                dashboardDpList[z].displayElements[k].graphicType = json[j].custom.graphicType;
                        }
                        if(obj.dashboardType !== "none") {
                            obj.x = "";
                            obj.y = "";
                            g_iDisplayIndex ++;
                            obj.displayIndex = g_iDisplayIndex;
                            obj.displayId =  g_iDisplayIndex + "__" + json[j].programmaticPathname;
                            
                            dashboardDpList[z].displayElements.push(JSON.parse(JSON.stringify(obj)));
                            if(iAddedChartIndex !== -1) {
                                // take into account the dashboard element is between gchart and gc/tc/lc
                                k =  dashboardDpList[z].displayElements.length - 1;
                                if(obj.dashboardType === "gc") {
                                    dashboardDpList[z].displayElements[iAddedChartIndex].guageObj.guageDisplayElementIndex = k;
                                    dashboardDpList[z].displayElements[k].guageObj.chartDisplayElementIndex = iAddedChartIndex;
                                }
                                else if((obj.dashboardType === "tc")  || (obj.dashboardType === "lc")){
                                    dashboardDpList[z].displayElements[iAddedChartIndex].thermometerObj.guageDisplayElementIndex = k;
                                    dashboardDpList[z].displayElements[k].thermometerObj.chartDisplayElementIndex = iAddedChartIndex;
                                }
                            }
                        }
                    }

                }
            }
            createRequestString(dashboardDpList);
            // add data log data
            if(g_bDashboardSupportLogData) {
                if(g_bDashboardGetDatalog) {
                    if(g_dashboardDatalogData.length > 0)
                        getDashboardDatalogDataResponseProcessData(0);
                }
            }
            g_bBuildDashboardDps = false;
        } //if(g_bBuildDashboardDps = true) {
            
        if(g_sSiteDashboardSelected !== "") {
            // needed to get device status
            for(z=0; z < dashboardDpList.length; z++)
            {
                if(typeof dashboardDpList[z].deviceListIndex === "undefined") {
                    for(i=0; i < deviceListAll.length; i++)
                    {
                        if(deviceListAll[i].id === dashboardDpList[z].deviceId) {
                            dashboardDpList[z].deviceListIndex = i;
                            break;
                        }
                    }
                }
            }
        }
        else  {
            // determine if device is provisioned
            if(typeof dashboardDpList[0].deviceListIndex === "undefined") {
                for(i=0; i < deviceListAll.length; i++)
                {
                    if(deviceListAll[i].id === dashboardDpList[0].deviceId) {
                        dashboardDpList[0].deviceListIndex = i;
                        break;
                    }
                }
            }
            if(typeof dashboardDpList[0].deviceListIndex !== "undefined") {
                if(deviceListAll[dashboardDpList[0].deviceListIndex].status.state !== "provisioned")
                    bDisableEditCheckbox = true;
            }
        }
        g_iBackgroundPollingRequestCount = -1;
        g_iPollingRequestCount = -1;
        g_iPollingRequestCountMax  = 2;
        //ivbWsProcessDatapointUpdate = false;
        if(g_bDashboardPollEnabled) {
            g_PollingType = DISPLAYMODE_DASHBOARD;
            g_idpGetRequestIndex = 0;
            g_bPollingEnabled = true;
            g_iPollingRequestCount = g_iPollingRequestCountMax;
            ivbWsProcessDatapointUpdate = true;
        }
        

        if(templateType !== "") {
            g_sDashboardTemplateType = templateType;
        }
        paneContent = "";
        if((g_sDashboardType === 1) && (g_sDashboardTemplateType !== "") && (g_sDashboardDevice !== "")) {
            if(false) { //(g_sDashboardTemplateType === "6kEvbMultiSensor") {
                paneContent = addMultiSensor("", g_sDashboardDevice);
                g_bInitializeSvg = false;
                document.getElementById("main").innerHTML =  paneContent;
                bNoTemplateFound = false;
            }
        }
        g_dashboardIoxList = [];
        if(bNoTemplateFound) {
            index = 0;
            if(g_sContextContent !== "") {
                paneContent += "<div id=\"dashboardMainDiv\"><div id=\"dashboardImageDiv\" style=\"float:left;display:inline-block;position:relative;margin-top:10px;margin-right:10px\">" + g_sContextContent + "</div></div>";
                g_sContextContent = "";
                bImageAdded = true;
            }
            else if(g_DashboardImage !== null) {  // MBW need to add code for bFixedLayout
                if(g_DashboardImage !== "") {
                    bContinue = true;
                    if((g_iDashboardImageX !== null) && (g_iDashboardImageY !== null)) {
                        if((g_iDashboardImageX !== "") && (g_iDashboardImageY !== "")) {
                            if(!isNaN(g_iDashboardImageX) && !isNaN(g_iDashboardImageY)) {
                                bContinue = false;
                            }
                        }
                    }
                    paneContent += "<div id=\"dashboardMainDiv\" style=\"display:inline-block;position:relative;\">";
                    tempContent = "<div id=\"dashboardImageDiv\" style=\"float:left;display:inline-block;position:relative;margin-top:10px;margin-right:10px\"><img src=\"" +  g_DashboardImage + "\" alt=\"device image\"";
                    if(g_iDashboardImageWidth !== null) {
                        if(g_iDashboardImageWidth !== "")
                            tempContent += " width=\"" + g_iDashboardImageWidth + "px\"";
                    }
                    if(g_iDashboardImageHeight !== null) {
                        if(g_iDashboardImageHeight !== "")
                        tempContent += " height=\"" + g_iDashboardImageHeight + "px\"";
                    }
                    tempContent += "></div>";
                    if(bContinue){
                        bImageAdded = true;
                        
                        bContinue2 = true;
                        if(bFixedLayout) {
                            if(g_oDashboardImageLayout !== null) {
                                if(g_oDashboardImageLayout !== "") {
                                    bContinue = false;
                                    obj = {};
                                    obj.layout = g_oDashboardImageLayout;
                                    obj.content = tempContent;
                                    obj.dashboardType = "dashboardImage";
                                    layoutList.push(obj);
                                }
                            }
                        }
                        if(bContinue) {
                            bAddEndingDiv = true;
                            paneContent += tempContent;
                        }
                    }
                    else {
                        obj = {};
                        obj.dashboardType = "dashboardImage";
                        obj.x = g_iDashboardImageX;
                        obj.y = g_iDashboardImageY;
                        obj.content = tempContent;
                        layoutUiList.push(obj); 
                    }
                }
            }

            g_bAtLeastOneElementUsesPriority = false;
            
                //Create HTML elements - go through 6 times in order to place elements in correct location on Web page, not all levels used anymore
            passCount = 9; // last pass is table, but table may not always be included
            if(bTableUsed)
                passCount ++; // 10
            for(j=0; j < passCount; j ++)
            { // j is used to order UI based on snvt_type
                if(j === 1)
                    tableColumnsMax = 3;
                else if(j === 4) {
                    /* 7/5/22 should be able to delete
                    if(paneContent !== "")
                        paneContent += "</table><div id=\"brDiv\" style=\"display:block\"><br><br></div>"
                        */
                }
                for(i=0; i < dashboardDpList.length; i ++)
                {
                    alarmWarningLevel = 0;
                    if(dashboardDpList[i].alarm !== null)  {
                        if((dashboardDpList[i].alarm.warningLevel < 5) && ((g_iAlarmDisplayType === 1) || (g_iAlarmDisplayType === 3)))  {
                            alarmWarningLevel = dashboardDpList[i].alarm.warningLevel;
                           
                        }
                    }
                    if(j=== 0) {
                        z = -1;
                        for(w=0; w < g_snvtTypes.length; w++)
                        {
                            if(dashboardDpList[i].type === g_snvtTypes[w].typeId) {
                                z = w;
                                dashboardDpList[i].snvtType = JSON.parse(JSON.stringify(g_snvtTypes[w]));
                                break;
                            }
                        }
                    }
                    for(t=0; t < dashboardDpList[i].displayElements.length; t ++)
                    {
                        bUseDefault = true;
                        dashboardType = dashboardDpList[i].displayElements[t].dashboardType;
                        field = dashboardDpList[i].displayElements[t].field;
                        fieldPath = dashboardDpList[i].displayElements[t].fieldPath;
                        displayId = dashboardDpList[i].displayElements[t].displayId;
                        locValue = dashboardDpList[i].locValue;
                        locValueStr = "";
                        fullBlockPath = dashboardDpList[i].displayElements[t].fullBlockPath;
                        label = dashboardDpList[i].displayElements[t].label;
                        bShowLabelForDataPointname = dashboardDpList[i].displayElements[t].bShowLabelForDataPointname;
                        programmaticPathname = dashboardDpList[i].programmaticPathname;

                        if(!dashboardDpList[i].displayElements[t].custom.useDefaults){
                            if(dashboardDpList[i].displayElements[t].custom.dashboardType !== null){
                                bUseDefault = false;
                            }
                        }
                        if(j === 0) {
                            if((field !== "") && dashboardDpList[i].bStructure)  {
                                
                                bContinue = false;
								if(dashboardDpList[i].value === null) {
                                    //fix need to support value=null by looking at SNVT type
                                    bContinue = false;
                                    locValueStr = "";
                                    if(typeof dashboardDpList[i].snvtType !== "undefined") {
                                        dpTypeParams = readSnvtTypeFieldValue(dashboardDpList[i].snvtType, field);
                                        if(dpTypeParams.valid) {
                                            if(field === "")
                                                type1 = dpTypeParams.data.valueType.toLowerCase();
                                            else 
                                                type1 = dpTypeParams.data.type.toLowerCase();
                                            
                                            if(type1 === "object") {
                                                dashboardDpList[i].displayElements[t].bStructure = true;
                                            }
                                            else if(type1 === "boolean") {
                                                dashboardDpList[i].displayElements[t].bBoolean = true;
                                            }
                                            else if((type1 === "bitfield") || (type1 === "scalar") || (type1 === "integer") || (type1 === "float")) {
                                                dashboardDpList[i].displayElements[t].bNumber = true;
                                            }
                                            else if(type1 === "enum") {
                                                dashboardDpList[i].displayElements[t].bEnum = true;
                                                if(field === "") {
                                                    if(typeof dpTypeParams.data.typeJson !== "undefined")
                                                        dashboardDpList[i].displayElements[t].enums = JSON.parse(JSON.stringify(dpTypeParams.data.typeJson.enum)); // used for charts or dropdown
                                                }
                                                else {
                                                    if(typeof dpTypeParams.data.typeJson !== "undefined")
                                                        dashboardDpList[i].displayElements[t].enums = JSON.parse(JSON.stringify(dpTypeParams.data.type.enum)); // used for charts or dropdown
                                                }
                                            }
                                            else if (type1 === "string") {
                                                dashboardDpList[i].displayElements[t].bString = true;
                                                dashboardDpList[i].displayElements[t].strings = []; //used for charts
                                            }
                                            else if(typeof dashboardDpList[i].value === "number")
                                                dashboardDpList[i].displayElements[t].bNumber = true;
                                        }
                                    }
                                    else {
                                        dashboardDpList[i].displayElements[t].dashboardType = "broken"; // didn't fine field
                                        dashboardDpList[i].displayElements[t].createBrowserGrapic = false;
                                    }
                                    
                                }
								else if(typeof locValue === "object") {
                                    fieldItems = readFieldValue(locValue,field);
                                    if(fieldItems.valid) {
                                        locValue = fieldItems.data;
                                        bContinue = true;
                                    }
                                    /*
									fieldItems = field.split("/");
									for(k=0; k < fieldItems.length; k ++)
									{
										field = fieldItems[k].trim();
										if(field != "") {
											if(locValue.hasOwnProperty(field)) {
												locValue = locValue[field];
                                                if(k === (fieldItems.length - 1))
                                                    bContinue = true;
											}
										}
										else {
											bContinue = false;
											break;
										} 
									}
                                    */
								}
								else 
									bContinue = false;
							}
                            else
                                bContinue = true;
							if(bContinue) {
                                if(dashboardDpList[i].value === null) {
                                    if(field === "") {
                                        locValueStr = "";
                                        dashboardDpList[i].displayElements[t].bStructure = dashboardDpList[i].bStructure;
                                        dashboardDpList[i].displayElements[t].bString = dashboardDpList[i].bString;
                                        dashboardDpList[i].displayElements[t].bNumber = dashboardDpList[i].bNumber;
                                        dashboardDpList[i].displayElements[t].bBoolean = dashboardDpList[i].bBoolean;
                                        dashboardDpList[i].displayElements[t].bEnum = dashboardDpList[i].bEnum;
                                        if(dashboardDpList[i].bEnum) {
                                            if(typeof dashboardDpList[i].enums !== "undefined") {
                                                if((dashboardDpList[i].enums !== null) && (dashboardDpList[i].enums.length > 0)) {
                                                    dashboardDpList[i].displayElements[t].enums = [];
                                                    dashboardDpList[i].displayElements[t].enums = JSON.parse(JSON.stringify(dashboardDpList[i].enums));
                                                }
                                            }
                                        }
                                    }
                                }
                                else {
                                    bContinue2 = true;
                                    if(typeof dashboardDpList[i].snvtType !== "undefined") {
                                        dpTypeParams = readSnvtTypeFieldValue(dashboardDpList[i].snvtType, field);
                                        if(dpTypeParams.valid) {
                                            if(field === "")
                                                type1 = dpTypeParams.data.valueType.toLowerCase();
                                            else 
                                                type1 = dpTypeParams.data.type.toLowerCase();
                                            if(type1 === "enum") {
                                                bContinue2 = false;
                                                dashboardDpList[i].displayElements[t].bEnum = true;
                                                if(field === "") {
                                                    if(typeof dpTypeParams.data.typeJson !== "undefined")
                                                        dashboardDpList[i].displayElements[t].enums = JSON.parse(JSON.stringify(dpTypeParams.data.typeJson.enum)); // used for charts
                                                }
                                                else {
                                                    if(typeof dpTypeParams.data.typeJson !== "undefined")
                                                        dashboardDpList[i].displayElements[t].enums = JSON.parse(JSON.stringify(dpTypeParams.data.type.enum)); // used for charts
                                                }
                                            }
                                        }
                                    }
                                    if(bContinue2) {
                                        if(typeof locValue === "object") {
                                            dashboardDpList[i].displayElements[t].bStructure = true;
                                            locValueStr = JSON.stringify(locValue);
                                            if(locValueStr.length > 2) {
                                                if((locValueStr.charAt(0) === "{") && (locValueStr.charAt(locValueStr.length - 1) === "}")) {
                                                    locValueStr = locValueStr.substr(1, (locValueStr.length - 2));
                                                }
                                            }
                                        }
                                        else if(typeof locValue === "string") {
                                            dashboardDpList[i].displayElements[t].bString = true;
                                            locValueStr = locValue;
                                            if(dashboardDpList[i].bStructure)
                                                showDashboardUiBuildWebpageChangeDashboardType("string", i, t); // if s1 and s2 then replace with new Dashboard type

                                        }
                                        else if(typeof locValue === "number") {
                                            dashboardDpList[i].displayElements[t].bNumber = true;
                                            locValueStr = locValue.toString();
                                            if(dashboardDpList[i].bStructure)
                                                showDashboardUiBuildWebpageChangeDashboardType("number", i, t); // if s1 and s2 then replace with new Dashboard type
                                        }
                                        else if(typeof locValue === "boolean") {
                                            dashboardDpList[i].displayElements[t].bBoolean = true;
                                            locValueStr = locValue.toString();
                                            if(dashboardDpList[i].bStructure)
                                                showDashboardUiBuildWebpageChangeDashboardType("boolean", i, t); // if s1 and s2 then replace with new Dashboard type
                                        }
                                    }
                                }
                                dashboardDpList[i].displayElements[t].locValue = locValue;
                                dashboardDpList[i].displayElements[t].locValueStr = locValueStr;
                            }
                            else {
                                if(dashboardDpList[i].value !== null) {
                                    dashboardDpList[i].displayElements[t].dashboardType = "broken"; // didn't fine field
                                    dashboardDpList[i].displayElements[t].createBrowserGrapic = false;
                                }
                            }
                           
                            
                        }
                        locValue = dashboardDpList[i].displayElements[t].locValue;
                        locValueStr = dashboardDpList[i].displayElements[t].locValueStr;
                        if (((j === 2) && dashboardDpList[i].displayElements[t].createBrowserGrapic && (dashboardType === "g"))
                            || ((j === 3) && dashboardDpList[i].displayElements[t].createBrowserGrapic  && (dashboardType === "gc")) ) {
                            bContinue1 = false;
                            if((dashboardType === "g") || (dashboardType === "gc")) {
                                try {
                                    programmaticPathname = dashboardDpList[i].programmaticPathname;
                                    if(typeof dashboardDpList[i].displayElements[t].guageObj !== "undefined") {
                                        if(dashboardDpList[i].displayElements[t].guageObj !== null) {
                                            divNum ++;
                                            pathname = dashboardDpList[i].pathname; //dashboardDpList[i].programmaticPathname;
                                            shortPathname = dashboardDpList[i].shortPathName;
                                            if(field !== "")
                                                shortPathname += "/" + field;
                                            tempValue = dashboardDpList[i].displayElements[t].locValue;
                                            tempValue = dashboardNumToFixedLength(tempValue, g_iDashboardDecimalPlaces);
                                            presetValue = "";
                                            
                                            defaultField = "";
                                            
                                            if(field === "") {
                                                if(typeof dashboardDpList[i].snvtType !== "undefined") {
                                                    if(typeof dashboardDpList[i].snvtType !== null) {
                                                        if(dashboardDpList[i].snvtType.valueType === "OBJECT"){
                                                            fieldList = createFieldListFromSnvtType(dashboardDpList[i].snvtType);
                                                            bAtLeastOneChartWithFieldDropdown = true;
                                                            //fieldList = Object.keys(dashboardDpList[i].value);
                                                            defaultField = fieldList[0];
                                                            value1 = readFieldValue(tempValue, defaultField);
                                                            if(value1.valid)
                                                                tempValue =  value1.data;
                                                            else 
                                                                tempValue = "";
                                                        }
                                                    }
                                                }
                                            }
                                            /* 7/5/22 should be able to delete
                                            if(divNum > tableColumnsMax) {
                                                divNum = 1;
                                                if(paneContent === "")
                                                    paneContent = "<table>";
                                                else 
                                                    paneContent += "</tr>";
                                                paneContent += '<tr><td>' + addGuage1(dashboardDpList[i].displayElements[t].displayId, i, t, label, shortPathname, programmaticPathname, field,tempValue, alarmWarningLevel) + '</td>';
                                            }
                                            else 
                                                paneContent += '<td>' + addGuage1(dashboardDpList[i].displayElements[t].displayId, i, t, label, shortPathname, programmaticPathname, field, tempValue, alarmWarningLevel) + '</td></tr>';
                                                */
                                            tempContent = addGuage1(dashboardDpList[i].displayElements[t].displayId, i, t, label, shortPathname, programmaticPathname, field, tempValue, alarmWarningLevel);
                                            bContinue2 = true;
                                            if(typeof dashboardDpList[i].displayElements[t].layout !== "undefined") {
                                                if(dashboardDpList[i].displayElements[t].layout !== null) {
                                                    if((dashboardDpList[i].displayElements[t].layout.x !== -1) && (dashboardDpList[i].displayElements[t].layout.y !== -1)) {
                                                        obj = {};
                                                        obj.dashboardType = dashboardType;
                                                        obj.x = dashboardDpList[i].displayElements[t].layout.x;
                                                        obj.y = dashboardDpList[i].displayElements[t].layout.y;
                                                        obj.content = tempContent;;
                                                        layoutUiList.push(obj); 
                                                        bContinue2 = false;
                                                    }
                                                }
                                            }
                                            if(bContinue2) {
                                                if(bFixedLayout) {
                                                    obj = {};
                                                    obj.layout = dashboardDpList[i].displayElements[t].layout;
                                                    obj.content = tempContent;
                                                    obj.dashboardType = dashboardType;
                                                    layoutList.push(obj);

                                                }
                                                else 
                                                    paneContent += tempContent;
                                            }
                                            if(dashboardType === "gc") {
                                                bAtLeastOneSvgElement = true;
                                                chartsfieldList.push(dashboardDpList[i].displayElements[dashboardDpList[i].displayElements[t].guageObj.chartDisplayElementIndex].displayId);
                                            }
                                        }
                                        bAtLeastOneGuageUsed = true;
                                    }
                                }
                                catch {}
                                dashboardDpList[i].displayElements[t].createBrowserGrapic = false;
                            }
                        }
                        if ((j === 4) && dashboardDpList[i].displayElements[t].createBrowserGrapic && (dashboardType === "tc")) {
                            bContinue1 = false;
                            
                            try {
                                programmaticPathname = dashboardDpList[i].programmaticPathname;
                                if(typeof dashboardDpList[i].displayElements[t].thermometerObj !== "undefined") {
                                    if(dashboardDpList[i].displayElements[t].thermometerObj !== null) {
                                        divNum ++;
                                        pathname = dashboardDpList[i].pathname; //dashboardDpList[i].programmaticPathname;
                                        shortPathname = dashboardDpList[i].shortPathName;
                                        if(field !== "")
                                            shortPathname += "/" + field;
                                        tempValue = dashboardDpList[i].displayElements[t].locValue;
                                        tempValue = dashboardNumToFixedLength(tempValue, g_iDashboardDecimalPlaces);
                                        presetValue = "";
                                        
                                        defaultField = "";
                                        
                                        if(field === "") {
                                            if(typeof dashboardDpList[i].value === "object"){
                                                fieldList = createFieldListFromSnvtType(dashboardDpList[i].snvtType);
                                                bAtLeastOneChartWithFieldDropdown = true;
                                                //fieldList = Object.keys(dashboardDpList[i].value);
                                                defaultField = fieldList[0];
                                                value1 = readFieldValue(tempValue, defaultField);
                                                if(value1.valid)
                                                    tempValue =  value1.data;
                                                else 
                                                    tempValue = "";

                                            }
                                        }
                                        if(dashboardDpList[i].displayElements[t].custom !== null) {
                                            if(dashboardDpList[i].displayElements[t].custom.thermometerObj !== null) {
                                                if(dashboardDpList[i].displayElements[t].custom.thermometerObj.style ===  "cf") {
                                                    tempValue = Number( ((1.8 * tempValue) + 32).toFixed(0));
                                                }
                                                else if(dashboardDpList[i].displayElements[t].custom.thermometerObj.style ===  "fc") {
                                                    tempValue = Number(( (tempValue - 32) / 1.8).toFixed(1));
                                                }
                                            }
                                        }
                                        tempContent = addThermometer1(dashboardDpList[i].displayElements[t].displayId, i, t, label, shortPathname, programmaticPathname, field, tempValue, alarmWarningLevel);
                                        bContinue2 = true;
                                            if(typeof dashboardDpList[i].displayElements[t].layout !== "undefined") {
                                                if(dashboardDpList[i].displayElements[t].layout !== null) {
                                                    if((dashboardDpList[i].displayElements[t].layout.x !== -1) && (dashboardDpList[i].displayElements[t].layout.y !== -1)) {
                                                        obj = {};
                                                        obj.dashboardType = dashboardType;
                                                        obj.x = dashboardDpList[i].displayElements[t].layout.x;
                                                        obj.y = dashboardDpList[i].displayElements[t].layout.y;
                                                        obj.content = tempContent;;
                                                        layoutUiList.push(obj); 
                                                        bContinue2 = false;
                                                    }
                                                }
                                            }
                                        if(bContinue2) {
                                            if(bFixedLayout) {
                                                obj = {};
                                                obj.layout = dashboardDpList[i].displayElements[t].layout;
                                                obj.content = tempContent;
                                                obj.dashboardType = dashboardType;
                                                layoutList.push(obj);

                                            }
                                            else 
                                                paneContent += tempContent;
                                        }
                                        bAtLeastOneSvgElement = true;
                                        chartsfieldList.push(dashboardDpList[i].displayElements[dashboardDpList[i].displayElements[t].thermometerObj.chartDisplayElementIndex].displayId);
                                        
                                    }
                                    bAtLeastOneGuageUsed = true;
                                }
                            }
                            catch {}
                            dashboardDpList[i].displayElements[t].createBrowserGrapic = false;
                           
                        }
                        if ((j === 5) && dashboardDpList[i].displayElements[t].createBrowserGrapic && (dashboardType === "lc")) {
                            bContinue1 = false;
                            
                            try {
                                programmaticPathname = dashboardDpList[i].programmaticPathname;
                                if(typeof dashboardDpList[i].displayElements[t].thermometerObj !== "undefined") {
                                    if(dashboardDpList[i].displayElements[t].thermometerObj !== null) {
                                        divNum ++;
                                        pathname = dashboardDpList[i].pathname; //dashboardDpList[i].programmaticPathname;
                                        shortPathname = dashboardDpList[i].shortPathName;
                                        if(field !== "")
                                            shortPathname += "/" + field;
                                        tempValue = dashboardDpList[i].displayElements[t].locValue;
                                        tempValue = dashboardNumToFixedLength(tempValue, g_iDashboardDecimalPlaces);
                                        presetValue = "";
                                        
                                        defaultField = "";
                                        
                                        if(field === "") {
                                            if(typeof dashboardDpList[i].value === "object"){
                                                fieldList = createFieldListFromSnvtType(dashboardDpList[i].snvtType);
                                                bAtLeastOneChartWithFieldDropdown = true;
                                                //fieldList = Object.keys(dashboardDpList[i].value);
                                                defaultField = fieldList[0];
                                                value1 = readFieldValue(tempValue, defaultField);
                                                if(value1.valid)
                                                    tempValue =  value1.data;
                                                else 
                                                    tempValue = "";

                                            }
                                        }
                                        tempContent = addLightmeter1(dashboardDpList[i].displayElements[t].displayId, i, t, label, shortPathname, programmaticPathname, field, tempValue, alarmWarningLevel);
                                        bContinue2 = true;
                                        if(typeof dashboardDpList[i].displayElements[t].layout !== "undefined") {
                                            if(dashboardDpList[i].displayElements[t].layout !== null) {
                                                if((dashboardDpList[i].displayElements[t].layout.x !== -1) && (dashboardDpList[i].displayElements[t].layout.y !== -1)) {
                                                    obj = {};
                                                    obj.dashboardType = dashboardType;
                                                    obj.x = dashboardDpList[i].displayElements[t].layout.x;
                                                    obj.y = dashboardDpList[i].displayElements[t].layout.y;
                                                    obj.content = tempContent;;
                                                    layoutUiList.push(obj); 
                                                    bContinue2 = false;
                                                }
                                            }
                                        }
                                        if(bContinue2) {
                                            if(bFixedLayout) {
                                                obj = {};
                                                obj.layout = dashboardDpList[i].displayElements[t].layout;
                                                obj.content = tempContent;
                                                obj.dashboardType = dashboardType;
                                                layoutList.push(obj);

                                            }
                                            else 
                                                paneContent += tempContent;
                                        }
                                        bAtLeastOneSvgElement = true;
                                        chartsfieldList.push(dashboardDpList[i].displayElements[dashboardDpList[i].displayElements[t].thermometerObj.chartDisplayElementIndex].displayId);
                                        
                                    }
                                    bAtLeastOneGuageUsed = true;
                                }
                            }
                            catch {}
                            dashboardDpList[i].displayElements[t].createBrowserGrapic = false;
                           
                        }
                        else if ((j === 6) && (bUseDefault || (dashboardType === "c"))) {
                            
                            bContinue1 = false;
                            //if(g_bDashboard_UseChartForAllBacnetAvs) {
                            if(dashboardType === "c") {
                                bContinue1 = true;
                                /* remove as fields,enums and strings are supported
                                if(typeof locValue === "number") {
                                    bContinue1 = true;
                                }
                                else {
                                    dashboardType = "";
                                    dashboardDpList[i].displayElements[t].dashboardType = ""; 
                                    bContinue1 = false;
                                }
                                */
                            }
                            else if(g_bUseChartForAllInputs) {
                                sTemp = dashboardDpList[i].dpQualifier;
                                sTemps = sTemp.split("/");
                                if(sTemps.length > 1) {
                                    //if(((sTemps[1] === "bacnet") || (sTemps[1] === "modbus")) && (dashboardDpList[i].cat === "in"))
                                    if(dashboardDpList[i].cat === "in")
                                        bContinue1 = true;
                                }
                            }
                            
                            if( dashboardDpList[i].displayElements[t].createBrowserGrapic 
                                && ((g_bUseChartForAllOutputs && (dashboardDpList[i].cat === "out") && (typeof dashboardDpList[i].displayElements[t].locValue === "number")) 
                                || bContinue1)) {
                                divNum ++;
                                dashboardDpList[i].displayElements[t].dashboardType = "c"; // chart
                                bAtLeastOneSvgElement = true;
                                pathname = dashboardDpList[i].pathname; //dashboardDpList[i].programmaticPathname;
                                shortPathname = dashboardDpList[i].shortPathName;
                                if(field !== "")
                                    shortPathname += "/" + field;
                                tempValue = dashboardDpList[i].displayElements[t].locValue;
                                tempValue = dashboardNumToFixedLength(tempValue, g_iDashboardDecimalPlaces);
                                presetValue = "";
                                if(field === "") {
                                    if(dashboardDpList[i].presetValue ===  "")
                                        presetValue = dashboardDpList[i].presetValue;
                                }
                                fieldList = [];
                                defaultField = "";
                                
                                if(field === "") {
                                    if(typeof dashboardDpList[i].snvtType !== "undefined") {
                                        if(typeof dashboardDpList[i].snvtType !== null) {
                                            if(dashboardDpList[i].snvtType.valueType === "OBJECT"){
                                                fieldList = createFieldListFromSnvtType(dashboardDpList[i].snvtType);
                                                bAtLeastOneChartWithFieldDropdown = true;
                                                //fieldList = Object.keys(dashboardDpList[i].value);
                                                defaultField = fieldList[0];
                                                value1 = readFieldValue(tempValue, defaultField);
                                                if(value1.valid)
                                                    tempValue =  value1.data;
                                                else 
                                                    tempValue = "";
                                            }
                                        }
                                    }
                                }
                                if(tempValue !== null) {
                                    if(typeof tempValue === "string")
                                        tempValueStr = tempValue;
                                    else
                                        tempValueStr = tempValue.toString();
                                    bContinue1 = false;
                                }
                                else 
                                    tempValueStr = "";
                                if(dashboardDpList[i].cat === "in")
                                    bContinue1 = true;
                                /* 7/5/22 should be able to delete
                                if(divNum > tableColumnsMax) {
                                    divNum = 1;
                                    if(paneContent === "")
                                        paneContent = "<table>";
                                    else 
                                        paneContent += "</tr>";
                                    paneContent += '<tr><td>' + addChart1(dashboardDpList[i].displayElements[t].displayId, i, t, label, shortPathname, programmaticPathname, field, fieldList, defaultField,tempValueStr, presetValue, bContinue1, alarmWarningLevel) + '</td>';
                                }
                                else 
                                    paneContent += '<td>' + addChart1(dashboardDpList[i].displayElements[t].displayId, i, t, label, shortPathname, programmaticPathname, field, fieldList, defaultField, tempValueStr, presetValue, bContinue1, alarmWarningLevel) + '</td></tr>';
                                    */
                                //tempContent = addChart1(dashboardDpList[i].displayElements[t].displayId, i, t, label, shortPathname, programmaticPathname, field, fieldList, defaultField, tempValueStr, presetValue, bContinue1, alarmWarningLevel);
                                tempContent = addChart2(0, dashboardDpList[i].displayElements[t].displayId, i, t, label, shortPathname, programmaticPathname, field, fieldList, defaultField, tempValueStr, presetValue, bContinue1, alarmWarningLevel, dashboardDpList[i].displayElements[t].units);
                                bContinue2 = true;
                                if(typeof dashboardDpList[i].displayElements[t].layout !== "undefined") {
                                    if(dashboardDpList[i].displayElements[t].layout !== null) {
                                        if((dashboardDpList[i].displayElements[t].layout.x !== -1) && (dashboardDpList[i].displayElements[t].layout.y !== -1)) {
                                            obj = {};
                                            obj.dashboardType = dashboardType;
                                            obj.x = dashboardDpList[i].displayElements[t].layout.x;
                                            obj.y = dashboardDpList[i].displayElements[t].layout.y;
                                            obj.content = tempContent;;
                                            layoutUiList.push(obj); 
                                            bContinue2 = false;
                                        }
                                    }
                                }
                                if(bContinue2) {
                                    if(bFixedLayout) {
                                        obj = {};
                                        obj.layout = dashboardDpList[i].displayElements[t].layout;
                                        obj.content = tempContent;
                                        obj.dashboardType = dashboardType;
                                        layoutList.push(obj);

                                    }
                                    else 
                                        paneContent += tempContent;
                                }
                                dashboardDpList[i].displayElements[t].createBrowserGrapic = false;
                                chartsfieldList.push(displayId); // datapointfield_
                                if((field !== "") && dashboardDpList[i].bStructure)
                                    bAtLeastOneChartWithFields = true;
                                if(typeof dashboardDpList[i].value === "object") {
                                    if(field === "") {
                                        field = defaultField;
                                    }
                                    dashboardDpList[i].displayElements[t].field = field;
                                }
                                createChartObject(i, t, displayId, pathname, field, locValue, null, null, true, null, "both");
                            }
                        }
                        //else if ((j === 4) && bUseDefault && dashboardDpList[i].displayElements[t].createBrowserGrapic) {
                        
                        else if(j === 7) {
                            // check if graphic datapoints
                            if((dashboardDpList[i].displayElements[t].x !== "") && (dashboardDpList[i].displayElements[t].y !== "")) {
                                try {
                                    obj = {};
                                    obj.x = dashboardDpList[i].displayElements[t].x;
                                    obj.y = dashboardDpList[i].displayElements[t].y;
                                    obj.index = i;
                                    obj.programmaticPathname = dashboardDpList[i].programmaticPathname;
                                    obj.displayElementIndex = t;
                                    obj.displayId = dashboardDpList[i].displayElements[t].displayId;
                                    obj.deviceName = dashboardDpList[i].deviceName;
                                    obj.deviceId = dashboardDpList[i].deviceId;
                                    obj.label = dashboardDpList[i].displayElements[t].label;
                                    obj.width = dashboardDpList[i].displayElements[t].width;
                                    obj.height = dashboardDpList[i].displayElements[t].height;
                                    obj.fontsize = dashboardDpList[i].displayElements[t].fontsize;
                                    obj.color = dashboardDpList[i].displayElements[t].color;
                                    obj.backgroundColor = dashboardDpList[i].displayElements[t].backgroundColor;
                                    if(typeof dashboardDpList[i].displayElements[t].borderColor !== "undefined")
                                        obj.borderColor = dashboardDpList[i].displayElements[t].borderColor;
                                    obj.bNumber = dashboardDpList[i].displayElements[t].bNumber;
                                    obj.bFunction = false;
                                    obj.function = "";
                                    if(dashboardDpList[i].displayElements[t].dashboardType === "r") {
                                        if(typeof dashboardDpList[i].displayElements[t].thermometerObj !== "undefined") {
                                            if(dashboardDpList[i].displayElements[t].thermometerObj !== null) {
                                                if((dashboardDpList[i].displayElements[t].custom.thermometerObj.style ===  "cf")
                                                    || (dashboardDpList[i].displayElements[t].custom.thermometerObj.style ===  "fc")) {
                                                    dashboardDpList[i].displayElements[t].bFunction = true;
                                                    dashboardDpList[i].displayElements[t].function = dashboardDpList[i].displayElements[t].custom.thermometerObj.style;
                                                    obj.bFunction = true;
                                                    obj.function = dashboardDpList[i].displayElements[t].function;
                                                }
                                            }
                                        }
                                    }
                                    else {
                                        if((dashboardDpList[i].displayElements[t].dashboardType === "l2") || (dashboardDpList[i].displayElements[t].dashboardType === "l4")
                                            || (dashboardDpList[i].displayElements[t].dashboardType === "pb") || (dashboardDpList[i].displayElements[t].dashboardType === "rbt")) {
                                            
                                            if(obj.color === "") {
                                                obj.color = g_sDashboardLedOnColor;
                                                dashboardDpList[i].displayElements[t].color = obj.color;
                                            }
                                            if(obj.backgroundColor === "") {
                                                obj.backgroundColor = g_sDashboardLedOffColor;
                                                dashboardDpList[i].displayElements[t].backgroundColor = obj.backgroundColor;
                                            }
                                            if(g_sSiteDashboardSelected !== "") {
                                                if(typeof obj.borderColor === "undefined") {
                                                    if(g_sDashboardLedBorderColor !== "") {
                                                        obj.borderColor = g_sDashboardLedBorderColor;
                                                        dashboardDpList[i].displayElements[t].borderColor = obj.borderColor;
                                                    }
                                                }
                                                else if(obj.borderColor === "") {
                                                    if(g_sDashboardLedBorderColor !== "") {
                                                        obj.borderColor = g_sDashboardLedBorderColor;
                                                        dashboardDpList[i].displayElements[t].borderColor = obj.borderColor;
                                                    }
                                                }
                                            }
                                        }
                                        if((dashboardDpList[i].displayElements[t].dashboardType === "pb") || (dashboardDpList[i].displayElements[t].dashboardType === "rbt"))
                                            bAtleastOneWritableDp = true;
                                    }
                                    if(typeof dashboardDpList[i].displayElements[t].imageSwapper !== "undefined")
                                        obj.imageSwapper = dashboardDpList[i].displayElements[t].imageSwapper;
                                    if(obj.label === "") {
                                        if(g_sSiteDashboardSelected !== "")
                                            obj.label += dashboardDpList[i].deviceName + "/";
                                        obj.label += dashboardDpList[i].block + "/" + dashboardDpList[i].dpName;
                                        if(dashboardDpList[i].displayElements[t].field !== "")
                                            obj.label += "/" +  dashboardDpList[i].displayElements[t].field;
                                    }
                                    else {
                                        obj.label += " [";
                                        if(g_sSiteDashboardSelected !== "")
                                            obj.label += dashboardDpList[i].deviceName + "/";
                                        obj.label += dashboardDpList[i].block + "/" + dashboardDpList[i].dpName;
                                        if(dashboardDpList[i].displayElements[t].field !== "")
                                            obj.label += "/" +  dashboardDpList[i].displayElements[t].field;
                                        obj.label += "]";
                                    }
                                    dashboardDpList[i].displayElements[t].fullLabel = obj.label;
                                    obj.locValue = dashboardDpList[i].displayElements[t].locValue;
                                    obj.locValueStr = dashboardDpList[i].displayElements[t].locValueStr;
                                    if(dashboardDpList[i].displayElements[t].dashboardType === "l4") {
                                        obj.locValue = obj.locValue.state;
                                        obj.locValueStr = obj.locValue;
                                    }
                                    obj.locValueStr = dashboardDpList[i].displayElements[t].locValueStr;
                                    obj.dashboardType = dashboardDpList[i].displayElements[t].dashboardType;
                                    obj.units = "";
                                    obj.graphicType = 0; // use default
                                    if(typeof dashboardDpList[i].displayElements[t].custom !== "undefined") {
                                        if(!dashboardDpList[i].displayElements[t].custom.useDefaults) {
                                            if(typeof dashboardDpList[i].displayElements[t].custom.graphicType !== "undefined")
                                                obj.graphicType = dashboardDpList[i].displayElements[t].custom.graphicType;
                                        }
                                    }
                                    if(typeof dashboardDpList[i].displayElements[t].units !== "undefined")
                                        obj.units = dashboardDpList[i].displayElements[t].units;
                                    graphicDpContentList.push(obj);
                                }
                                catch {}
                                dashboardDpList[i].displayElements[t].createBrowserGrapic = false;
                            }

                        }
                        else if (j === 8) {
                            // if no input or spans using structured datapoints then reduce the input text size 
                            if(bReduceInputTextBoxSize) {
                                if(dashboardType === "n") {
                                    if(dashboardDpList[i].displayElements[t].bStructure) {
                                        bReduceInputTextBoxSize = false;
                                        iInputTextBoxSize = 0;
                                    }
                                    else {
                                        
                                        if(field === "") {
                                            if(dashboardDpList[i].locValueStr !== "") {
                                                if(typeof dashboardDpList[i].locValueStr === "string") {
                                                    if(iInputTextBoxSize < ( dashboardDpList[i].locValueStr.length + 2))
                                                        iInputTextBoxSize = dashboardDpList[i].locValueStr.length + 2 
                                                }
                                            }
                                        }
                                        else {
                                            if(dashboardDpList[i].displayElements[t].locValueStr !== "") {
                                                if(typeof dashboardDpList[i].displayElements[t].locValueStr === "string") {
                                                    if(iInputTextBoxSize < ( dashboardDpList[i].displayElements[t].locValueStr.length + 2))
                                                        iInputTextBoxSize = dashboardDpList[i].displayElements[t].locValueStr.length + 2 
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        else if(j === 9) {
                            // s0= span readonly structure, s1=span writeable structure, s2 = slider switch (binary), s3 = slider switch (SNVT_switch), s4 = slider switch (SNVT_switch 0 0 or 1 100 only), 
                        // l2 = led, l3 = led (SNVT_switch, led for state, span for value), l4 = LED SNVT_switch state only
                            bContinue3 = true;
                            if((dashboardDpList[i].displayElements[t].dashboardType === "l5d1") || (dashboardDpList[i].displayElements[t].dashboardType === "ms1")
                                    || (dashboardDpList[i].displayElements[t].dashboardType === "pg1")) {
                                //multiple UI elements for table row
                                dashboardDpList[i].displayElements[t].createBrowserGrapic = false; // elements add now for row but values populated later
                                obj = {};
                                obj.i = i;
                                obj.t = t;
                                obj.dashboardType = dashboardType;
                                obj.deviceName = dashboardDpList[i].deviceName;
                                specialDevice.push(JSON.parse(JSON.stringify(obj)));
                                bContinue3 = false;
                            }
                            if(dashboardDpList[i].displayElements[t].createBrowserGrapic && bContinue3) {
                                programmaticPathname = dashboardDpList[i].programmaticPathname;
                                if(!bUseDefault && (field === "")) {
                                    //dashboardDpList[i].displayElements[t].dashboardType = dashboardDpList[i].custom.dashboardType;
                                    dashboardDpList[i].displayElements[t].dashboardType = dashboardDpList[i].displayElements[t].custom.dashboardType;
                                    
                                    dashboardType = dashboardDpList[i].displayElements[t].dashboardType;
                                }
                                else {
                                    if((field ===  "") && !((dashboardDpList[i].type ===  "SNVT_switch") || (dashboardDpList[i].unit === " ") || (dashboardDpList[i].unit.indexOf("unit") !== 1)))
                                        bUnitsUsed = true;
                                    
                                    if((field ===  "") && (dashboardDpList[i].type ===  "SNVT_str_asc"))
                                        dashboardDpList[i].displayElements[t].dashboardType = "a";
                                    else if ((field ===  "") && ((dashboardDpList[i].type ===  "binary") || (dashboardDpList[i].type ===  "boolean") || (dashboardDpList[i].type.toLowerCase() ===  "bit"))) {
                                        if(dashboardDpList[i].cat === "in")
                                            dashboardDpList[i].displayElements[t].dashboardType = "s2";
                                        else
                                            dashboardDpList[i].displayElements[t].dashboardType = "l2";
                                    }
                                    else if((field === "") && (programmaticPathname.startsWith("DIO/DI/0/DI_")))
                                        dashboardDpList[i].displayElements[t].dashboardType = "l2"; // Adam-4150
                                    else if((field === "") && (programmaticPathname.startsWith("DIO/DO/0/DO_")))
                                        dashboardDpList[i].displayElements[t].dashboardType = "s2"; // Adam-4150
                                    else if((field === "") && (programmaticPathname.startsWith("DIO-01/Digital Input/") && programmaticPathname.endsWith("/nvoValue")))
                                        dashboardDpList[i].displayElements[t].dashboardType = "l4"; // SC100
                                    else if((field === "") && (programmaticPathname.startsWith("DIO-01/Digital Output/") && programmaticPathname.endsWith("/nviValue")))
                                        dashboardDpList[i].displayElements[t].dashboardType = "s4"; // SC100
                                    else if ((field === "") && (dashboardDpList[i].type ===  "SNVT_switch")) {
                                        if(dashboardDpList[i].cat === "in")
                                            dashboardDpList[i].displayElements[t].dashboardType = "s3";
                                        else
                                            dashboardDpList[i].displayElements[t].dashboardType = "l3";
                                    }
                                    else if(dashboardDpList[i].displayElements[t].dashboardType === "")
                                        dashboardDpList[i].displayElements[t].dashboardType = "n";
                                }
                                
                                dashboardType = dashboardDpList[i].displayElements[t].dashboardType;
                                if(dashboardType === "") {
                                    if(dashboardDpList[i].displayElements[t].bStructure) {
                                        if((dashboardDpList[i].cat === "out") || dashboardDpList[i].displayElements[t].readonly) 
                                            dashboardDpList[i].displayElements[t].dashboardType = "s0";
                                        else  
                                            dashboardDpList[i].displayElements[t].dashboardType = "s1";
                                    }
                                    else {
                                        if((dashboardDpList[i].cat === "out") || dashboardDpList[i].displayElements[t].readonly)
                                            dashboardDpList[i].displayElements[t].dashboardType = "r";
                                        else
                                            dashboardDpList[i].displayElements[t].dashboardType = "n";
                                    }
                                    dashboardType = dashboardDpList[i].displayElements[t].dashboardType;
                                }
                                else if(dashboardType === "n") {
                                    if(dashboardDpList[i].displayElements[t].bStructure) {
                                        if((dashboardDpList[i].cat === "out") || dashboardDpList[i].displayElements[t].readonly) 
                                            dashboardDpList[i].displayElements[t].dashboardType = "s0";
                                        else  
                                            dashboardDpList[i].displayElements[t].dashboardType = "s1";
                                            dashboardType = dashboardDpList[i].displayElements[t].dashboardType;
                                    }
                                }
                                if(g_bDashboardTableReadOnly) {
                                    if(dashboardDpList[i].displayElements[t].dashboardType === "r")
                                        dashboardDpList[i].displayElements[t].dashboardType = "n";
                                    else if(dashboardDpList[i].displayElements[t].dashboardType === "s1")
                                        dashboardDpList[i].displayElements[t].dashboardType = "s0";
                                    if(dashboardDpList[i].displayElements[t].dashboardType === "s2")
                                        dashboardDpList[i].displayElements[t].dashboardType = "l2";
                                    else if(dashboardDpList[i].displayElements[t].dashboardType === "s3")
                                        dashboardDpList[i].displayElements[t].dashboardType = "l3";
                                    else if(dashboardDpList[i].displayElements[t].dashboardType === "s4")
                                        dashboardDpList[i].displayElements[t].dashboardType = "l4";

                                }
                                if((dashboardDpList[i].displayElements[t].dashboardType === "n") || (dashboardDpList[i].displayElements[t].dashboardType === "s1")
                                    || (dashboardDpList[i].displayElements[t].dashboardType === "s2") || (dashboardDpList[i].displayElements[t].dashboardType === "s3")
                                    || (dashboardDpList[i].displayElements[t].dashboardType === "s4") || (dashboardDpList[i].displayElements[t].dashboardType === "sl")) 
                                    bAtleastOneWritableDp = true;




                                index ++;
                                tablePaneContent += "<tr><td>" + index + "</td>";
                                pathname = dashboardDpList[i].pathname;//dashboardDpList[i].programmaticPathname;
                                if(bAddDeviceName) {
                                    tablePaneContent += "<td";
                                    if((g_sSiteDashboardSelected !== "") && g_bSiteDashboardClickDpPathToDevice) {
                                        tablePaneContent += " onclick=\"getPlanningTreeShowDashboard(0,'Device_" + dashboardDpList[i].deviceId + "','" + dashboardDpList[i].deviceName + "')\"";
                                    }
                                    tablePaneContent += ">" + dashboardDpList[i].shortDeviceName + "</td>";
                                }
                                tablePaneContent += "<td id=\"datapointName_" + displayId + "\"";
                                w = 0;
                                if(g_sSiteDashboardSelected !== "") {
                                    // check device status
                                    if(typeof dashboardDpList[i].deviceListIndex === "undefined") {
                                        for(s=0; s < deviceListAll.length; s++)
                                        {
                                            if(deviceListAll[s].id === dashboardDpList[i].deviceId) {
                                                dashboardDpList[i].deviceListIndex = s;
                                                break;
                                            }
                                        }
                                    }
                                    if(typeof dashboardDpList[i].deviceListIndex !== "undefined") {
                                        if(dashboardDpList[i].deviceId ===  deviceListAll[dashboardDpList[i].deviceListIndex].id) {
                                            deviceStatus = deviceListAll[dashboardDpList[i].deviceListIndex].status.state;
                                            if(deviceStatus === "provisioned") 
                                                deviceStatus = deviceListAll[dashboardDpList[i].deviceListIndex].status.health;
                                            if(deviceStatus === "normal")
                                                deviceStatus = "";
                                        }
                                    }
                                }
                                if(g_bShowDpDeviceDown && (deviceStatus !== "")) {
                                    tablePaneContent += " style=\"background-color:";
                                    tablePaneContent += g_sTableDeviceDownColor;
                                    tablePaneContent +=  " \"";
                                    w = 1;
                                }
                                else if(dashboardDpList[i].alarm !== null)  {
                                    if((dashboardDpList[i].alarm.warningLevel < 5) && ((g_iAlarmDisplayType === 1) || (g_iAlarmDisplayType === 3)))  {
                                        tablePaneContent += " style=\"background-color:";
                                        tablePaneContent += g_alarmColors[dashboardDpList[i].alarm.warningLevel];
                                        tablePaneContent +=  " \"";
                                        w = 1;
                                    }
                                }
                                
                                tablePaneContent += "><div style=\"display:flex\">";
                                tablePaneContent += "<div id=\"bell_" + displayId + "\" >";
                                if(w === 1) {
                                    tablePaneContent += "<img src=\"images/navtree/Bellred.gif\" alt=\"alarmimage\"onclick=\"alarmMenu(";
                                    if(!dashboardDpList[i].displayElements[t].readonly && ((dashboardType === "s1") || (dashboardType === "s2")  || (dashboardType === "s3")   || (dashboardType === "s4")))
                                        tablePaneContent += 1; // writable -- use menudpvalue
                                    else
                                        tablePaneContent += 0; // readonly -- show only alarm state
                                    tablePaneContent += ",this," + i + "," + t + ",'bell_" + displayId + "','" + programmaticPathname + "')\"";
                                    tablePaneContent += "><span style=\"margin-left:5px\"></span>";
                                }
                                tablePaneContent += "</div>";
                                // add dp label or dp path
                                //g_iShowDashboardDp = 3; //0=dp path, 1= label only, 2= label + [path], 3 = label + path tooltip
                                tablePaneContent += "<div><span id=\"label_" + displayId + "\"";
                                if((label !== "") && (g_iShowDashboardDp === 3)) {
                                    tablePaneContent += ' title="';
                                    if(g_sSiteDashboardSelected !== "")
                                        tablePaneContent += dashboardDpList[i].deviceName + "/" + dashboardDpList[i].block  + "/" + dashboardDpList[i].dpName + '"';
                                    else {
                                        tablePaneContent += dashboardDpList[i].block  + "/" + dashboardDpList[i].dpName + '"';
                                    }
                                    if(field !== "")
                                        tablePaneContent += "/" + field;
                                }
                                
                                if(!bAddDeviceName && (g_sSiteDashboardSelected !== "") && g_bSiteDashboardClickDpPathToDevice) {
                                    tablePaneContent += " class=\"treeviewName\" onclick=\"getPlanningTreeShowDashboard(0,'Device_" + dashboardDpList[i].deviceId + "','" + dashboardDpList[i].deviceName + "')\"";
                                }
                                
                                tablePaneContent +=  ">"; 
                                if((dashboardType === "ms") || (dashboardType === "pg") || (dashboardType === "l5d")) {
                                    tablePaneContent +=  dashboardDpList[i].deviceName
                                }
                                else if(label === "") {
                                    if(g_sSiteDashboardSelected !== "")
                                        tablePaneContent +=  dashboardDpList[i].deviceName + "/";
                                    tablePaneContent +=  dashboardDpList[i].block  + "/" + dashboardDpList[i].dpName;
                                }
                                else {
                                    tablePaneContent += label;
                                    if(g_iShowDashboardDp === 3)  {
                                        if((g_sSiteDashboardSelected !== "") && dashboardDpList[i].displayElements[t].bAddDeviceName) {
                                            tablePaneContent +=  " [" + dashboardDpList[i].deviceName + "]";
                                        }
                                    }
                                    else {
                                        if(g_iShowDashboardDp === 2) 
                                            tablePaneContent +=  " [";
                                        if((g_iShowDashboardDp === 0) || (g_iShowDashboardDp === 2)) {
                                            if(g_sSiteDashboardSelected !== "")
                                                tablePaneContent +=  dashboardDpList[i].deviceName + "/";
                                            tablePaneContent += dashboardDpList[i].block  + "/" + dashboardDpList[i].dpName;
                                        }
                                    }
                                }
                                if(field !== "")
                                    tablePaneContent += "/" + field;
                                if((g_iShowDashboardDp === 2) && (label !== ""))
                                    tablePaneContent += "]";
                                tablePaneContent += "</span></div></div>";
                                tablePaneContent += "</td>";
                                if(dashboardType === "m") {
                                    bAtLeastOneGuageUsed = true;
                                    tempObj = dashboardDpList[i].displayElements[t].guageObj;
                                    
                                    tablePaneContent += "<td class=\"tdValue\" ><div style=\"display:flex;overflow:hidden;\">";
                                    tablePaneContent += '<div id="localValueDiv_' + displayId + '" style=\"display:flex\" ><div>';
                                    tablePaneContent += '<meter id="meter_' + displayId + '"'; 
                                    if(typeof locValue === "number")
                                        tablePaneContent += ' value="' + locValue + '"';
                                    if((typeof tempObj.guageMin !== "undefined") && (typeof tempObj.guageMin !== "undefined")) {
                                        if((tempObj.guageMin !== null) && (tempObj.guageMax !== null)) {
                                            tablePaneContent += ' min="' + tempObj.guageMin + '"';
                                            if((tempObj.guageColors.length > 0) && (!((tempObj.guageColors.length === 1) && (tempObj.guageColors[0].color === "green")))) {
                                                if((typeof tempObj.guageLow !== "undefined") || (typeof tempObj.guageHigh !== "undefined")) {
                                                    if((tempObj.guageMax - tempObj.guageMin) !== 0) {
                                                        if((typeof tempObj.guageLow !== "undefined"))
                                                            tablePaneContent += ' low="' + ((tempObj.guageLow - tempObj.guageMin) (tempObj.guageMax - tempObj.guageMin) / 2).toString() + '"';
                                                        if((typeof tempObj.guageLow !== "undefined"))
                                                            tablePaneContent += ' high="' + ((tempObj.guagehigh - tempObj.guageMin) (tempObj.guageMax - tempObj.guageMin) / 2).toString() + '"';
                                                    }
                                                }
                                                else 
                                                    tablePaneContent += ' low="" high="" optimum=""';
                                            }
                                            tablePaneContent += ' max="' + tempObj.guageMax + '"';
                                            tablePaneContent += ' title="min=' + tempObj.guageMin + ',max='+ tempObj.guageMax + '"';
                                        }
                                    }
                                    tablePaneContent += '></meter></div><div><span id="localValue_' + displayId + '" style=\"display:inline-block;margin-left:10px';
                                    if(g_bMeterShowToolTips) {
                                        try {
                                            sTemp1 = tempObj.guageMax.toString();
                                            sTemp2 = tempObj.guageMin.toString();
                                            if((sTemp1 !== "") && (sTemp1 !== "")) {
                                                iTemp = sTemp1.length;
                                                if(sTemp1.length < sTemp2.length)
                                                    iTemp = sTemp2.length;
                                                if(iTemp > 0) {
                                                    tablePaneContent += ';width:' + iTemp.toString() + 'em';
                                                }
                                            }
                                            
                                        }
                                        catch {}
                                    }
                                    tablePaneContent += '\">';
                                    if(typeof locValue === "number")
                                        tablePaneContent += locValue;
                                    tablePaneContent += '</span></div>'; 
                                    tablePaneContent += '</div></td>';
                                    tablePaneContent += "<td><span id=\"unit_" + displayId + "\">";
                                    if(typeof dashboardDpList[i].displayElements[t].units !== "undefined") {
                                        if(dashboardDpList[i].displayElements[t].units !== "") {
                                            if(dashboardDpList[i].displayElements[t].units !== "undefined") {
                                                if(dashboardDpList[i].displayElements[t].units.indexOf(",") === -1) {
                                                    tablePaneContent += dashboardDpList[i].displayElements[t].units;
                                                    bUnitsUsed = true;
                                                }
                                            }
                                        }
                                    }
                                    tablePaneContent += "</span></td>";
                                    //tablePaneContent += "<td><span id=\"priority_" + pathname + "\">" + dashboardDpList[i].priority + "</span></td>";
                                    if(!g_bDashboardTableReadOnly) {
                                        tablePaneContent += '<td></td>';
                                    }
                                    tablePaneContent += "</tr>";
                                    
                                }
                                else if(dashboardType === "sl") {
                                    bAtLeastOneGuageUsed = true;
                                    tempObj = dashboardDpList[i].displayElements[t].guageObj;
                                    
                                    tablePaneContent += "<td class=\"tdValue\" ><div style=\"display:flex;overflow:hidden;\">";
                                    tablePaneContent += '<div id="localValueDiv_' + displayId + '" >';
                                    tablePaneContent += '<input type="range" id="slider_' + displayId + '"'; 
                                    if(typeof locValue === "number")
                                        tablePaneContent += ' value="' + locValue + '"';
                                    if(typeof tempObj.guageMin !== "undefined") {
                                        if(tempObj.guageMin !== null) {
                                            tablePaneContent += ' min="' + tempObj.guageMin + '"';
                                        }
                                    }
                                    if(typeof tempObj.guageMin !== "undefined") {
                                        if(tempObj.guageMin !== null) {
                                            tablePaneContent += ' max="' + tempObj.guageMax + '"';
                                        }
                                    }
                                    //tablePaneContent += ' class="slider" onchange="sliderChanged(this, \"' + displayId + '\", ' + i + ',' + t + ')"></div>'
                                    tablePaneContent += " class=\"slider\" onchange=\"sliderChanged(this, " + i + "," + t + ",'" + displayId + "','" + programmaticPathname  + "')\"></div>";
                                    tablePaneContent += '<div><span id="localValue_' + displayId + '" class=\"sliderValue\">';
                                    if(typeof locValue === "number")
                                        tablePaneContent += locValue;
                                    tablePaneContent += '</span></div>'; 
                                    tablePaneContent += '</div></td>';
                                    tablePaneContent += "<td><span id=\"unit_" + displayId + "\">";
                                    if(typeof dashboardDpList[i].displayElements[t].units !== "undefined") {
                                        if(dashboardDpList[i].displayElements[t].units !== "") {
                                            if(dashboardDpList[i].displayElements[t].units !== "undefined") {
                                                if(dashboardDpList[i].displayElements[t].units.indexOf(",") === -1) {
                                                    tablePaneContent += dashboardDpList[i].displayElements[t].units;
                                                    bUnitsUsed = true;
                                                }
                                            }
                                        }
                                    }
                                    tablePaneContent += "</span></td>";
                                    //tablePaneContent += "<td><span id=\"priority_" + pathname + "\">" + dashboardDpList[i].priority + "</span></td>";
                                    if(!g_bDashboardTableReadOnly) {
                                        if(dashboardDpList[i].values === null) {
                                            tablePaneContent += "<td></td>";
                                        }
                                        else {
                                            tablePaneContent += "<td><div style=\"display:flex\">";
                                            if((dashboardDpList[i].writePriorityStart + 1) === dashboardDpList[i].writePriorityEnd)
                                                tablePaneContent += "<span>" + dashboardDpList[i].writePriorityStart + "</span>";
                                            else {
                                                tablePaneContent += "<select id=\"priority_" + displayId + "\">";
                                                w = dashboardDpList[i].priority;
                                                if(dashboardDpList[i].priority < dashboardDpList[i].writePriorityStart)
                                                    w = dashboardDpList[i].writePriorityStart;
                                                for(s=dashboardDpList[i].writePriorityStart; s < dashboardDpList[i].writePriorityEnd; s++)
                                                {
                                                    tablePaneContent += "<option value=\"" + s + "\"";
                                                    if(w === s)
                                                        tablePaneContent += " selected";
                                                    tablePaneContent += ">" + s + "</option>";
                                                }
                                                if(dashboardDpList[i].writePriorityNormal) {
                                                    tablePaneContent += "<option value=\"17\"";
                                                    if(dashboardDpList[i].priority === 17)
                                                        tablePaneContent += " selected";
                                                    tablePaneContent += ">" + "Normal" + "</option>";
                                                    
                                                }
                                                tablePaneContent += "</select>"
                                            }

                                            tablePaneContent += "<button id=\"dpValueMenu_" + displayId + "\" class=\"";
                                            if(dashboardDpList[i].values.level === 17)
                                                tablePaneContent += "priorityButtonNotActive";
                                            else 
                                                tablePaneContent += "priorityButtonActive";
                                            tablePaneContent += "\" onclick=\"menuDpValue1(4,this, " + i + ", " + t + ", 'dpValueMenu_" + displayId + "','" + programmaticPathname + "')\">";
                                            if((Number(dashboardDpList[i].values.level) === 17) || (g_iCurrentPriorityButtonType === 1))
                                                tablePaneContent += "...";
                                            else
                                                tablePaneContent += "P " + dashboardDpList[i].values.level;
                                            tablePaneContent += "</button>";
                                            tablePaneContent += "</div></td>";
                                            dashboardDpList[i].displayElements[t].bHasPriorityButton = true;
                                            g_bAtLeastOneElementUsesPriority = true;
                                            addElementToEditButtonElementList("priority_" + displayId, "d", "visible");
                                            addElementToEditButtonElementList("dpValueMenu_" + displayId, "menu", "visible");
                                        }
                                    }
                                    tablePaneContent += "</tr>";
                                    if(!g_bDashboardTableReadOnly) {
                                        addElementToEditButtonElementList("slider_" + displayId, "sl", "disable");
                                        
                                    }
                                }
                                else if(dashboardType === "s0") {
                                    // structured read-only span
                                    tablePaneContent += "<td class=\"tdValue\" ><div style=\"display:flex;overflow:hidden;\">";
                                    tablePaneContent += '<div id="localValue_' + displayId + '" style="width:30px;flow:hidden;text-overflow:ellipsis"';
                                    tablePaneContent += " onclick=\"menuDpPlanningShowStructuredDp(4,this," + i + "," + t + ",'" + programmaticPathname + "')\">";
                                    tablePaneContent += dashboardDpList[i].displayElements[t].locValueStr + '</div>'; 
                                                                    
                                    tablePaneContent += '</div></td>';
                                    tablePaneContent += "<td><span id=\"unit_" + displayId + "\"></span></td>";
                                    //tablePaneContent += "<td><span id=\"priority_" + pathname + "\">" + dashboardDpList[i].priority + "</span></td>";
                                    if(!g_bDashboardTableReadOnly)
                                        tablePaneContent += '<td></td>';
                                    tablePaneContent += "</tr>";

                                }
                                else if(dashboardType === "s1") {
                                    // structured write span
                                    tablePaneContent += "<td class=\"tdValue\" ><div id=\"localValueDiv_" + displayId + "\" style=\"display:flex;border: 1px solid black;text-overflow:ellipsis;overflow:hidden;\">";
                                    tablePaneContent += "<div id=\"localValue_" + displayId + "\"";
                                    tablePaneContent +=  " onclick=\"menuDpValue1(4, this, " + i + ", " + t + ", 'localValue_" + displayId + "','" + programmaticPathname + "')\">";
                                    tablePaneContent +=   dashboardDpList[i].displayElements[t].locValueStr + "</div>"; 
                                                                    
                                    tablePaneContent += '</div></td>';
                                    tablePaneContent += "<td><span id=\"unit_" + displayId + "\"></span></td>";
                                    if(!g_bDashboardTableReadOnly) {
                                        if(dashboardDpList[i].values === null) {
                                            tablePaneContent += "<td></td>";
                                        }
                                        else {
                                            tablePaneContent += "<td><div style=\"display:flex\">";
                                            if((dashboardDpList[i].writePriorityStart + 1) === dashboardDpList[i].writePriorityEnd)
                                                tablePaneContent += "<span>" + dashboardDpList[i].writePriorityStart + "</span>";
                                            else {
                                                tablePaneContent += "<select id=\"priority_" + displayId + "\">";
                                                w = dashboardDpList[i].priority;
                                                if(dashboardDpList[i].priority < dashboardDpList[i].writePriorityStart)
                                                    w = dashboardDpList[i].writePriorityStart;
                                                for(s=dashboardDpList[i].writePriorityStart; s < dashboardDpList[i].writePriorityEnd; s++)
                                                {
                                                    tablePaneContent += "<option value=\"" + s + "\"";
                                                    if(w === s)
                                                        tablePaneContent += " selected";
                                                    tablePaneContent += ">" + s + "</option>";
                                                }
                                                if(dashboardDpList[i].writePriorityNormal) {
                                                    tablePaneContent += "<option value=\"17\"";
                                                    if(dashboardDpList[i].priority === 17)
                                                        tablePaneContent += " selected";
                                                    tablePaneContent += ">" + "Normal" + "</option>";
                                                    
                                                }
                                                tablePaneContent += "</select>"
                                            }

                                            tablePaneContent += "<button id=\"dpValueMenu_" + displayId + "\" class=\"";
                                            if(dashboardDpList[i].values.level === 17)
                                                tablePaneContent += "priorityButtonNotActive";
                                            else 
                                                tablePaneContent += "priorityButtonActive";
                                            tablePaneContent += "\" onclick=\"menuDpValue1(4,this, " + i + ", " + t + ", 'dpValueMenu_" + displayId + "','" + programmaticPathname + "')\">";
                                            if((Number(dashboardDpList[i].values.level) === 17) || (g_iCurrentPriorityButtonType === 1))
                                                tablePaneContent += "...";
                                            else
                                                tablePaneContent += "P " + dashboardDpList[i].values.level;
                                            tablePaneContent += "</button>";
                                            tablePaneContent += "</div></td>";
                                            dashboardDpList[i].displayElements[t].bHasPriorityButton = true;
                                            g_bAtLeastOneElementUsesPriority = true;
                                            addElementToEditButtonElementList("priority_" + displayId, "d", "visible");
                                            addElementToEditButtonElementList("dpValueMenu_" + displayId, "menu", "visible");
                                        }
                                    }
                                    tablePaneContent += "</tr>";
                                    if(!g_bDashboardTableReadOnly) {
                                        addElementToEditButtonElementList("localValueDiv_" + displayId, "s1", "disable");
                                        
                                    }
                                }
                                else if(dashboardDpList[i].displayElements[t].dashboardType === "s2") {
                                    // boolean or binary slider switch
                                    dashboardDpList[i].displayElements[t].graphicType = 0;
                                    tablePaneContent += "<td class=\"tdValue\" ><div id=\"sliderSwitch_" +  displayId  + "\" style=\"display:flex\">";
                                    tablePaneContent += "<label class=\"sliderSwitch\" ><input type=\"checkbox\"";
                                    tablePaneContent += " id=\"localValueSwitch_" + displayId + "\" onclick=\"sliderSwitchClicked(this, '" + displayId + "', " + i + ", " + t + ")\" class=\"sliderInput\" ";
                                    if(dashboardDpList[i].value === null) {
                                        
                                    }
                                    else if(typeof dashboardDpList[i].locValue === "number") {
                                        if(dashboardDpList[i].locValue === 1)
                                            tablePaneContent += ' checked';
                                    }
                                    else if(typeof dashboardDpList[i].locValue === "boolean") {
                                        
                                        if(dashboardDpList[i].locValue)
                                            tablePaneContent += ' checked';
                                    
                                    }
                                    tablePaneContent += '><span id="localValueSpan_' + displayId + '" class="sliderSlider sliderRound"></span></label>'
                                    tablePaneContent +=  '</div></td>';
                                    tablePaneContent += "<td><span id=\"unit_" + displayId + "\">";
                                    if(typeof dashboardDpList[i].displayElements[t].units !== "undefined") {
                                        if(dashboardDpList[i].displayElements[t].units !== "") {
                                            if(dashboardDpList[i].displayElements[t].units !== "undefined") {
                                                if(dashboardDpList[i].displayElements[t].units.indexOf(",") === -1) {
                                                    tablePaneContent += dashboardDpList[i].displayElements[t].units;
                                                    bUnitsUsed = true;
                                                }
                                            }
                                        }
                                    }
                                    tablePaneContent += "</span></td>";
                                    if(!g_bDashboardTableReadOnly) {
                                        if(dashboardDpList[i].values === null) {
                                            tablePaneContent += "<td></td>";
                                        }
                                        else {
                                            //tablePaneContent += "<td><input id=\"priority_" + pathname + "\" value=\"" + dashboardDpList[i].priority + "\" size=\"3\">";
                                            tablePaneContent += "<td><div style=\"display:flex\">";
                                            if((dashboardDpList[i].writePriorityStart + 1) === dashboardDpList[i].writePriorityEnd)
                                                tablePaneContent += "<span>" + dashboardDpList[i].writePriorityStart + "</span>";
                                            else {
                                                tablePaneContent += "<select id=\"priority_" + displayId + "\">";
                                                w = dashboardDpList[i].priority;
                                                if(dashboardDpList[i].priority < dashboardDpList[i].writePriorityStart)
                                                    w = dashboardDpList[i].writePriorityStart;
                                                for(s=dashboardDpList[i].writePriorityStart; s < dashboardDpList[i].writePriorityEnd; s++)
                                                {
                                                    tablePaneContent += "<option value=\"" + s + "\"";
                                                    if(w === s)
                                                        tablePaneContent += " selected";
                                                    tablePaneContent += ">" + s + "</option>";
                                                }
                                                if(dashboardDpList[i].writePriorityNormal) {
                                                    tablePaneContent += "<option value=\"17\"";
                                                    if(dashboardDpList[i].priority === 17)
                                                        tablePaneContent += " selected";
                                                    tablePaneContent += ">" + "Normal" + "</option>";
                                                    
                                                }
                                                tablePaneContent += "</select>"
                                            }

                                            tablePaneContent += "<button id=\"dpValueMenu_" + displayId + "\" style=\"margin-left:10px\" onclick=\"menuDpValue1(4, this, " + i + ", " + t + ", 'dpValueMenu_" + displayId + "','" + programmaticPathname + "')\">...</button>";
                                            tablePaneContent += "</div></td>";
                                            dashboardDpList[i].displayElements[t].bHasPriorityButton = true;
                                            g_bAtLeastOneElementUsesPriority = true;
                                            addElementToEditButtonElementList("priority_" + displayId, "d", "visible");
                                            addElementToEditButtonElementList("dpValueMenu_" + displayId, "menu", "visible");
                                        }
                                    }
                                    tablePaneContent += "</tr>";
                                    if(!g_bDashboardTableReadOnly) {
                                        addElementToEditButtonElementList1("localValueSwitch_" + displayId, "s2", "disable", "localValueSpan_" + displayId, i, t, displayId);
                                        
                                    }
                                }
                                else if((dashboardDpList[i].displayElements[t].dashboardType === "s3") && (field ===  "")) {
                                    // SNVT_switch slider switch value and state
                                    tablePaneContent += "<td class=\"tdValue\" ><div style=\"display:flex\">";
                                    tablePaneContent += "<div id=\"sliderSwitch_" +  displayId  + "\" style=\"width:70px\">";
                                    tablePaneContent += "<label class=\"sliderSwitch\" ><input type=\"checkbox\"";
                                    tablePaneContent += " id=\"localValueSwitch_" + displayId + "\" onclick=\"sliderSwitchClicked(this, '" + displayId + "', " + i + ", " + t + ")\" class=\"sliderInput\" ";
                                    if(dashboardDpList[i].value === null) {
                                        
                                    }
                                    else if(dashboardDpList[i].locValue.state === 1)
                                        tablePaneContent += ' checked';
                                    
                                    tablePaneContent += '><span id="localValueSpan_' + displayId + '" class="sliderSlider sliderRound"></span></label></div>'
                                    tablePaneContent += '<div><input id="localValue_' + displayId + '" style="width:30px;"';
                                    if(dashboardDpList[i].value === null) {
                                        
                                    }
                                    else  
                                        tablePaneContent += 'value="' + dashboardDpList[i].displayElements[t].locValue.value.toString() + '"';
                                    tablePaneContent += " onkeyup=\"inputBoxKey(this, event, " + i + ", " + t + ", '" + displayId + "')\""; 
                                    tablePaneContent += '></div>';
                                    tablePaneContent +=  '</div></td>';
                                    tablePaneContent += "<td><span id=\"unit_" + displayId + "\"></span></td>";
                                    //tablePaneContent += "<td><input id=\"priority_" + pathname + "\" value=\"" + dashboardDpList[i].priority + "\" size=\"3\">";
                                    
                                    if(!g_bDashboardTableReadOnly) {
                                        tablePaneContent += "<td><div style=\"display:flex\">";
                                        if((dashboardDpList[i].writePriorityStart + 1) === dashboardDpList[i].writePriorityEnd)
                                            tablePaneContent += "<span>" + dashboardDpList[i].writePriorityStart + "</span>";
                                        else {
                                            tablePaneContent += "<select id=\"priority_" + displayId + "\">";
                                            w = dashboardDpList[i].priority;
                                            if(dashboardDpList[i].priority < dashboardDpList[i].writePriorityStart)
                                                w = dashboardDpList[i].writePriorityStart;
                                            for(s=dashboardDpList[i].writePriorityStart; s < dashboardDpList[i].writePriorityEnd; s++)
                                            {
                                                tablePaneContent += "<option value=\"" + s + "\"";
                                                if(w === s)
                                                    tablePaneContent += " selected";
                                                tablePaneContent += ">" + s + "</option>";
                                            }
                                            if(dashboardDpList[i].writePriorityNormal) {
                                                tablePaneContent += "<option value=\"17\"";
                                                if(dashboardDpList[i].priority === 17)
                                                    tablePaneContent += " selected";
                                                tablePaneContent += ">" + "Normal" + "</option>";
                                                
                                            }
                                            tablePaneContent += "</select>"
                                        }
                                        
                                        tablePaneContent += "<button id=\"dpValueMenu_" + displayId + "\" class=\"";
                                        if(dashboardDpList[i].values.level === 17)
                                            tablePaneContent += "priorityButtonNotActive";
                                        else 
                                            tablePaneContent += "priorityButtonActive";
                                        tablePaneContent += "\" onclick=\"menuDpValue1(4,this, " + i + ", " + t + ", 'dpValueMenu_" + displayId + "','" + programmaticPathname + "')\">";
                                        if((dashboardDpList[i].values.level === 17) || (g_iCurrentPriorityButtonType === 1))
                                            tablePaneContent += "...";
                                        else 
                                            tablePaneContent += "P " + dashboardDpList[i].values.level;
                                        tablePaneContent += "</button></div></td>";
                                        addElementToEditButtonElementList("priority_" + displayId, "d", "visible");
                                        addElementToEditButtonElementList("dpValueMenu_" + displayId, "menu", "visible");
                                    }
                                    tablePaneContent += "</tr>";
                                    dashboardDpList[i].displayElements[t].bHasPriorityButton = true;
                                    g_bAtLeastOneElementUsesPriority = true;
                                    
                                    if(!g_bDashboardTableReadOnly) {
                                        addElementToEditButtonElementList1("localValueSwitch_" + displayId, "s3", "disable", "localValueSpan_" + displayId, i, t, displayId);
                                        addElementToEditButtonElementList("localValue_" + displayId, "input", "disable");
                                    }
                                }
                                else if((dashboardDpList[i].displayElements[t].dashboardType === "s4") && (field ===  "")) {
                                    // SNVT_switch Slider uses state only
                                    dashboardDpList[i].displayElements[t].graphicType = 0;
                                    tablePaneContent += "<td class=\"tdValue\" ><div id=\"sliderSwitch_" +  displayId  + "\" style=\"display:flex\">";
                                    tablePaneContent += "<label class=\"sliderSwitch\" ><input type=\"checkbox\"";
                                    tablePaneContent += " id=\"localValueSwitch_" + displayId + "\" onclick=\"sliderSwitchClicked(this, '" + displayId + "', " + i + "," + t + ")\" class=\"sliderInput\" ";
                                    if(dashboardDpList[i].value === null) {
                                        
                                    }
                                    else if(dashboardDpList[i].locValue.state === 1)
                                            tablePaneContent += ' checked';
                                    
                                    tablePaneContent += '><span id="localValueSpan_' + displayId + '" class="sliderSlider sliderRound"></span></label>'
                                    tablePaneContent +=  '</div></td>';
                                    tablePaneContent += "<td><span id=\"unit_" + displayId + "\"></span></td>";
                                    //tablePaneContent += "<td><input id=\"priority_" + pathname + "\" value=\"" + dashboardDpList[i].priority + "\" size=\"3\">";
                                    if(!g_bDashboardTableReadOnly) {
                                        tablePaneContent += "<td><div style=\"display:flex\">";
                                        if((dashboardDpList[i].writePriorityStart + 1) === dashboardDpList[i].writePriorityEnd)
                                            tablePaneContent += "<span>" + dashboardDpList[i].writePriorityStart + "</span>";
                                        else {
                                            tablePaneContent += "<select id=\"priority_" + displayId + "\">";
                                            w = dashboardDpList[i].priority;
                                            if(dashboardDpList[i].priority < dashboardDpList[i].writePriorityStart)
                                                w = dashboardDpList[i].writePriorityStart;
                                            for(s=dashboardDpList[i].writePriorityStart; s < dashboardDpList[i].writePriorityEnd; s++)
                                            {
                                                tablePaneContent += "<option value=\"" + s + "\"";
                                                if(w === s)
                                                    tablePaneContent += " selected";
                                                tablePaneContent += ">" + s + "</option>";
                                            }
                                            if(dashboardDpList[i].writePriorityNormal) {
                                                tablePaneContent += "<option value=\"17\"";
                                                if(dashboardDpList[i].priority === 17)
                                                    tablePaneContent += " selected";
                                                tablePaneContent += ">" + "Normal" + "</option>";
                                                
                                            }
                                            tablePaneContent += "</select>"
                                        }
                                        
                                        tablePaneContent += "<button id=\"dpValueMenu_" + displayId + "\" class=\"";
                                        if(dashboardDpList[i].values.level === 17)
                                            tablePaneContent += "priorityButtonNotActive";
                                        else 
                                            tablePaneContent += "priorityButtonActive";
                                        tablePaneContent += "\" onclick=\"menuDpValue1(4, this, " + i + ", " + t + ", 'dpValueMenu_" + displayId + "','" + programmaticPathname + "')\">";
                                        if((dashboardDpList[i].values.level === 17) || (g_iCurrentPriorityButtonType === 1))
                                            tablePaneContent += "...";
                                        else
                                            tablePaneContent += "P " + dashboardDpList[i].values.level;
                                        tablePaneContent += "</div></td></button>";
                                        addElementToEditButtonElementList("priority_" + displayId, "d", "visible");
                                        addElementToEditButtonElementList("dpValueMenu_" + displayId, "menu", "visible");
                                    }
                                    tablePaneContent += "</tr>";
                                    dashboardDpList[i].displayElements[t].bHasPriorityButton = true;
                                    g_bAtLeastOneElementUsesPriority = true;
                                    if(!g_bDashboardTableReadOnly) {
                                        addElementToEditButtonElementList1("localValueSwitch_" + displayId, "s4", "disable", "localValueSpan_" + displayId, i, t, displayId);
                                    }
                                }
                                else if(dashboardDpList[i].displayElements[t].dashboardType === "l2") {
                                    // led binary
                                    
                                    dashboardDpList[i].displayElements[t].graphicType = 0;
                                    tablePaneContent += "<td class=\"tdValue\" ><div style=\"display:flex\">";
                                    tablePaneContent += '<span id="localValueSwitch_' + displayId + '"'; 
                                    if(dashboardDpList[i].value === null) {
                                        
                                    }
                                    else if(dashboardDpList[i].displayElements[t].bNumber 
                                        || (dashboardDpList[i].displayElements[t].bBoolean && (typeof dashboardDpList[i].displayElements[t].locValue === "number"))) {
                                        if(dashboardDpList[i].displayElements[t].locValue === 0) {
                                            tablePaneContent += ' class="ledDotOff"';
                                            if(dashboardDpList[i].displayElements[t].backgroundColor !== ""){
                                                tablePaneContent += " style=\"background-color:" + dashboardDpList[i].displayElements[t].backgroundColor + "\"";
                                            }
                                        }
                                        else {
                                            tablePaneContent += ' class="ledDotOn"';
                                            if(dashboardDpList[i].displayElements[t].color !== "")
                                                tablePaneContent += " style=\"background-color:" + dashboardDpList[i].displayElements[t].color + "\"";
                                        }
                                    }
                                    else if(dashboardDpList[i].displayElements[t].bBoolean) {
                                        
                                        if(dashboardDpList[i].displayElements[t].locValue === 1) {
                                            tablePaneContent += ' class="ledDotOn"';
                                            if(dashboardDpList[i].displayElements[t].color !== ""){
                                                tablePaneContent += " style=\"background-Color:" + dashboardDpList[i].displayElements[t].color + "\"";
                                            }
                                        }
                                        else {
                                            tablePaneContent += ' class="ledDotOff"';
                                            if(dashboardDpList[i].displayElements[t].backgroundColor !== "")
                                                tablePaneContent += " style=\"background-color:" + dashboardDpList[i].displayElements[t].backgroundColor + "\"";
                                        }
                                        
                                    }
                                    tablePaneContent += '></span>';
                                    tablePaneContent += '</div></td>';
                                    tablePaneContent += "<td><span id=\"unit_" + displayId + "\">";
                                    if(typeof dashboardDpList[i].displayElements[t].units !== "undefined") {
                                        if(dashboardDpList[i].displayElements[t].units !== "") {
                                            if(dashboardDpList[i].displayElements[t].units !== "undefined") {
                                                if(dashboardDpList[i].displayElements[t].units.indexOf(",") === -1) {
                                                    tablePaneContent += dashboardDpList[i].displayElements[t].units;
                                                    bUnitsUsed = true;
                                                }
                                            }
                                        }
                                    }
                                    tablePaneContent += "</span></td>";
                                    if(!g_bDashboardTableReadOnly) 
                                        tablePaneContent += '<td></td>';
                                    //tablePaneContent += "<td><span id=\"priority_" + pathname + "\">" + dashboardDpList[i].priority + "</span></td>";
                                    tablePaneContent += "</tr>";
                                    /* remove color
                                    borderColor = "";
                                    if(g_sSiteDashboardSelected !== "") {
                                        dashboardDpList[i].displayElements[t].color = dashboardDpList[i].displayElements[t].backgroundColor; //ffix remove after fully changing color and background code
                                        dashboardDpList[i].displayElements[t].backgroundColor = "transparent"; //ffix remove after fully changing color and background code
                                        dashboardDpList[i].displayElements[t].borderColor = borderColor; //ffix remove after fully changing color and background code
                                        
                                    }
                                    */
                                }
                                else if((dashboardDpList[i].displayElements[t].dashboardType === "l3") && (field ===  "")) {
                                    // Led SNVT_switch value and state
                                    tablePaneContent += "<td class=\"tdValue\" ><div style=\"display:flex\">";
                                    tablePaneContent += "<div id=\"sliderSwitch_" +  displayId  + "\" style=\"width:70px\">"
                                    tablePaneContent += '<span id="localValueSwitch_' + displayId + '"'; 
                                    if(dashboardDpList[i].value === null) {
                                        
                                    }
                                    else if(dashboardDpList[i].locValue.state === 1)
                                        tablePaneContent += ' class="ledDotOn"';
                                        if(dashboardDpList[i].displayElements[t].color !== ""){
                                            tablePaneContent += " style=\"background-Color:" + dashboardDpList[i].displayElements[t].color + "\"";
                                        }
                                    else {
                                        tablePaneContent += ' class="ledDotOff"';
                                        if(dashboardDpList[i].displayElements[t].backgroundColor !== "")
                                            tablePaneContent += " style=\"background-color:" + dashboardDpList[i].displayElements[t].backgroundColor + "\"";
                                        else
                                            tablePaneContent += " style=\"background-color:transparent\"";
                                    }
                                    tablePaneContent += '></span></div>';
                                    tablePaneContent += '<div id="localValue_' + displayId + '" style="width:30px;">';
                                    if(dashboardDpList[i].value !== null)   
                                        tablePaneContent +=dashboardDpList[i].displayElements[t].locValue.value.toString();
                                    tablePaneContent += '</div>'; 
                                                                    
                                    tablePaneContent += '</div></td>';
                                    tablePaneContent += "<td><span id=\"unit_" + displayId + "\"></span></td>";
                                    //tablePaneContent += "<td><span id=\"priority_" + pathname + "\">" + dashboardDpList[i].priority + "</span></td>";
                                    if(!g_bDashboardTableReadOnly) 
                                        tablePaneContent += '<td></td>';
                                    tablePaneContent += "</tr>";
                                }
                                else if((dashboardType === "l4") && (field ===  "")) {
                                    // Led SNVT_switch state only -- e.g., IOX
                                    dashboardDpList[i].displayElements[t].graphicType = 0;
                                    tablePaneContent += "<td class=\"tdValue\" ><div style=\"display:flex\">";
                                    tablePaneContent += '<span id="localValueSwitch_' + displayId + '"'; 
                                    if(dashboardDpList[i].value === null) {
                                        
                                    }
                                    else if(dashboardDpList[i].locValue.state === 1) {
                                        tablePaneContent += ' class="ledDotOn"';
                                        if(dashboardDpList[i].displayElements[t].color !== ""){
                                            tablePaneContent += " style=\"background-Color:" + dashboardDpList[i].displayElements[t].color + "\"";
                                        }
                                    }
                                    else {
                                        tablePaneContent += ' class="ledDotOff"';
                                        if(dashboardDpList[i].displayElements[t].backgroundColor !== "")
                                            tablePaneContent += " style=\"background-color:" + dashboardDpList[i].displayElements[t].backgroundColor + "\"";
                                        else
                                            tablePaneContent += " style=\"background-color:transparent\"";
                                    }
                                    tablePaneContent += '>';
                                                                
                                    
                                    tablePaneContent += '</span></div></td>';
                                    tablePaneContent += "<td><span id=\"unit_" + displayId + "\"></span></td>";
                                    if(!g_bDashboardTableReadOnly) 
                                        tablePaneContent += '<td></td>';
                                    tablePaneContent += "</tr>";
                                    
                                }
                                else if(dashboardType === "l5")  {
                                    // EnOcean Rocker switch - most of the time this is will start out as blank, 
                                    // Led SNVT_switch state only -- e.g., IOX
                                    dashboardDpList[i].displayElements[t].graphicType = 0;
                                    tablePaneContent += "<td class=\"tdValue\" ><div style=\"display:flex\">";
                                    if((value === null) || (value === 2)) {
                                        
                                        tablePaneContent += "<div id=\"localValueSwitchBorder_" + displayId + "\" style=\"width:18px;height:18px;border:1px solid\">";
                                        tablePaneContent += '<span id="localValueSwitch_' + displayId + '"></span>';
                                        tablePaneContent += "</div>";
                                        dashboardDpList[i].displayElements[t].dashboardType = "l5_div";
                                    }
                                    else if(value === 0) {
                                        tablePaneContent += '<span id="localValueSwitch_' + displayId + '"';
                                        tablePaneContent += ' class="ledDotOn"';
                                        if(dashboardDpList[i].displayElements[t].color !== ""){
                                            tablePaneContent += " style=\"background-Color:" + dashboardDpList[i].displayElements[t].color + "\"";
                                        }
                                        tablePaneContent += '></span>';
                                    }
                                    else {
                                        tablePaneContent += '<span id="localValueSwitch_' + displayId + '"';
                                        tablePaneContent += ' class="ledDotOff"';
                                        if(dashboardDpList[i].displayElements[t].backgroundColor !== "")
                                            tablePaneContent += " style=\"background-color:" + dashboardDpList[i].displayElements[t].backgroundColor + "\"";
                                        else
                                            tablePaneContent += " style=\"background-color:transparent\"";
                                        tablePaneContent += '></span>';
                                    }
                                    tablePaneContent += '</div></td>';
                                    tablePaneContent += "<td><span id=\"unit_" + displayId + "\"></span></td>";
                                    if(!g_bDashboardTableReadOnly) 
                                        tablePaneContent += '<td></td>';
                                    tablePaneContent += "</tr>";
                                    
                                }
                                else if(dashboardType === "l5d")  {
                                    // EnOcean Rocker switch - most of the time this is will start out as blank, 
                                    // Led SNVT_switch state only -- e.g., IOX
                                    dashboardDpList[i].displayElements[t].graphicType = 0;
                                    tablePaneContent += "<td class=\"tdValue\" ><div style=\"display:flex\">";
                                    tablePaneContent += "<div id=\"localValueSwitchBorder_" + displayId + "\" style=\"width:18px;height:18px;border:1px solid\">";
                                    tablePaneContent += '<span id="localValueSwitch_' + displayId + '"'; 
                                    if(dashboardDpList[i].value === null) {
                                        tablePaneContent += ' class="ledDotUnknown"';
                                    }
                                    else if(dashboardDpList[i].locValue === 2) {
                                        tablePaneContent += ' class="ledDotUnknown"';
                                    }
                                    else if(dashboardDpList[i].locValue === 0) {
                                        tablePaneContent += ' class="ledDotOn"';
                                        if(dashboardDpList[i].displayElements[t].color !== ""){
                                            tablePaneContent += " style=\"background-Color:" + dashboardDpList[i].displayElements[t].color + "\"";
                                        }
                                    }
                                    else {
                                        tablePaneContent += ' class="ledDotOff"';
                                        if(dashboardDpList[i].displayElements[t].backgroundColor !== "")
                                            tablePaneContent += " style=\"background-color:" + dashboardDpList[i].displayElements[t].backgroundColor + "\"";
                                        else
                                            tablePaneContent += " style=\"background-color:transparent\"";
                                    }
                                    tablePaneContent += ' title="Left Rocker Switch">';
                                    tablePaneContent += '</span></div>';
                                    g_iDisplayIndex++;
                                    displayId = g_iDisplayIndex + "__" + dashboardDpList[i].deviceName + "/Rocker A/1/Switch A";
                                    dashboardDpList[i].displayElements[t].new_iDisplayIndex = g_iDisplayIndex;
                                    tablePaneContent += "<div id=\"localValueSwitchBorder_" + displayId + "\" style=\"width:18px;height:18px;border:1px solid;margin-left:10px\">";
                                    tablePaneContent += '<span id="localValueSwitch_' + displayId + '"'; 
                                    tablePaneContent += ' class="ledDotUnknown"';
                                    tablePaneContent += ' title="Right Rocker Switch">';
                                    tablePaneContent += '</span></div>';
                                    tablePaneContent += '</div></td>';
                                    tablePaneContent += "<td><span id=\"unit_" + displayId + "\"></span></td>";
                                    if(!g_bDashboardTableReadOnly) 
                                        tablePaneContent += '<td></td>';
                                    tablePaneContent += "</tr>";
                                    
                                }
                                else if(dashboardType === "ms")  {
                                    // EnOcean Rocker switch - most of the time this is will start out as blank, 
                                    // Led SNVT_switch state only -- e.g., IOX
                                    dashboardDpList[i].displayElements[t].graphicType = 0;
                                    dashboardDpList[i].displayElements[t].new_iDisplayIndex = dashboardDpList[i].displayElements[t].displayIndex;
                                    tablePaneContent += "<td class=\"tdValue\" ><div style=\"display:flex\">";
                                    tablePaneContent += '<span id="localValueSwitch_' + displayId + '"'; 
                                    if(dashboardDpList[i].value === null) {
                                        tablePaneContent += ' class="ledDotUnknown"';
                                    }
                                    else if(dashboardDpList[i].locValue.state === 1) {
                                        tablePaneContent += ' class="ledDotOn"';
                                        if(dashboardDpList[i].displayElements[t].color !== ""){
                                            tablePaneContent += " style=\"background-Color:" + dashboardDpList[i].displayElements[t].color + "\"";
                                        }
                                        obj = {};
                                        obj.i = i;
                                        obj.t = t;
                                        obj.dashboardType = dashboardType;
                                        obj.deviceName = dashboardDpList[i].deviceName;
                                        specialDevicesWithValue.push(JSON.parse(JSON.stringify(obj)));
                                    }
                                    else {
                                        tablePaneContent += ' class="ledDotOff"';
                                        if(dashboardDpList[i].displayElements[t].backgroundColor !== "")
                                            tablePaneContent += " style=\"background-color:" + dashboardDpList[i].displayElements[t].backgroundColor + "\"";
                                        else
                                            tablePaneContent += " style=\"background-color:transparent\"";
                                        obj = {};
                                        obj.i = i;
                                        obj.t = t;
                                        obj.dashboardType = dashboardType;
                                        obj.deviceName = dashboardDpList[i].deviceName;
                                        specialDevicesWithValue.push(JSON.parse(JSON.stringify(obj)));
                                    }
                                    
                                    tablePaneContent += ' title="Switch 1">';
                                    tablePaneContent += '</span>';
                                    displayId = dashboardDpList[i].displayElements[t].displayIndex + "__" + dashboardDpList[i].deviceName + "/Lamp/0/nvoLampFb";
                                    tablePaneContent += '<span id="localValueSwitch_' + displayId + '"'; 
                                    tablePaneContent += ' class="ledDotUnknown"';
                                    tablePaneContent += ' title="LED 1" style="margin-left:5px"></span>';
                                    displayId = dashboardDpList[i].displayElements[t].displayIndex + "__" + dashboardDpList[i].deviceName + "/Switch/1/nvoSwitch";
                                    tablePaneContent += '<span id="localValueSwitch_' + displayId + '"'; 
                                    tablePaneContent += ' class="ledDotUnknown"';
                                    tablePaneContent += ' title="Switch 2" style="margin-left:10px"></span>';
                                    displayId = dashboardDpList[i].displayElements[t].displayIndex + "__" + dashboardDpList[i].deviceName + "/Lamp/1/nvoLampFb";
                                    tablePaneContent += '<span id="localValueSwitch_' + displayId + '"'; 
                                    tablePaneContent += ' class="ledDotUnknown"';
                                    tablePaneContent += ' title="LED 2" style="margin-left:5px"></span>';
                                    displayId = dashboardDpList[i].displayElements[t].displayIndex + "__" + dashboardDpList[i].deviceName + "/TempSensor/0/nvoTemperature";
                                    tablePaneContent += "<div id=\"localValue_" + displayId + "\" class=\"tdValueDiv3\" title=\"Temperature\"></div>";
                                    tablePaneContent += "<span id=\"unit_" + displayId + "\" title=\"Temperature\"></span>,";
                                    displayId = dashboardDpList[i].displayElements[t].displayIndex + "__" + dashboardDpList[i].deviceName + "/LightSensor/0/nvoLightLevel";
                                    tablePaneContent += "<div id=\"localValue_" + displayId + "\" class=\"tdValueDiv3\" title=\"Light Level\"></div>";
                                    tablePaneContent += "<span id=\"unit_" + displayId + "\" title=\"Light Level\"></span>";

                                    tablePaneContent += '</div></td>';
                                    tablePaneContent += "<td></td>";
                                    if(!g_bDashboardTableReadOnly) 
                                        tablePaneContent += '<td></td>';
                                    tablePaneContent += "</tr>";
                                    
                                }
                                else if(dashboardType === "pg")  {
                                    // PulseGen - most of the time this is will start out as blank, 
                                    // Led SNVT_switch state only -- e.g., IOX
                                    dashboardDpList[i].displayElements[t].graphicType = 0;
                                    dashboardDpList[i].displayElements[t].new_iDisplayIndex = dashboardDpList[i].displayElements[t].displayIndex;
                                    tablePaneContent += "<td class=\"tdValue\" ><div style=\"display:flex\">";
                                    
                                    tablePaneContent += '<span id="localValueSwitch_' + displayId + '"'; 
                                    if(dashboardDpList[i].value === null) {
                                        tablePaneContent += ' class="ledDotUnknown"';
                                    }
                                    else if(dashboardDpList[i].locValue.state === 1) {
                                        tablePaneContent += ' class="ledDotOn"';
                                        if(dashboardDpList[i].displayElements[t].color !== ""){
                                            tablePaneContent += " style=\"background-Color:" + dashboardDpList[i].displayElements[t].color + "\"";
                                        }
                                        obj = {};
                                        obj.i = i;
                                        obj.t = t;
                                        obj.dashboardType = dashboardType;
                                        obj.deviceName = dashboardDpList[i].deviceName;
                                        specialDevicesWithValue.push(JSON.parse(JSON.stringify(obj)));
                                    }
                                    else {
                                        tablePaneContent += ' class="ledDotOff"';
                                        if(dashboardDpList[i].displayElements[t].backgroundColor !== "")
                                            tablePaneContent += " style=\"background-color:" + dashboardDpList[i].displayElements[t].backgroundColor + "\"";
                                        else
                                            tablePaneContent += " style=\"background-color:transparent\"";
                                        obj = {};
                                        obj.i = i;
                                        obj.t = t;
                                        obj.dashboardType = dashboardType;
                                        obj.deviceName = dashboardDpList[i].deviceName;
                                        specialDevicesWithValue.push(JSON.parse(JSON.stringify(obj)));
                                    }
                                    
                                    tablePaneContent += ' title="Switch 1">';
                                    tablePaneContent += '</span>';
                                    displayId = dashboardDpList[i].displayElements[t].displayIndex + "__" + dashboardDpList[i].deviceName + "/device/0/nvoLamp1";
                                    tablePaneContent += '<span id="localValueSwitch_' + displayId + '"'; 
                                    tablePaneContent += ' class="ledDotUnknown"';
                                    tablePaneContent += ' title="LED 1" style="margin-left:5px"></span>';
                                    displayId = dashboardDpList[i].displayElements[t].displayIndex + "__" + dashboardDpList[i].deviceName + "/device/0/nvoSwitch2";
                                    tablePaneContent += '<span id="localValueSwitch_' + displayId + '"'; 
                                    tablePaneContent += ' class="ledDotUnknown"';
                                    tablePaneContent += ' title="Switch 2" style="margin-left:10px"></span>';
                                    displayId = dashboardDpList[i].displayElements[t].displayIndex + "__" + dashboardDpList[i].deviceName + "/device/0/nvoLamp2";
                                    tablePaneContent += '<span id="localValueSwitch_' + displayId + '"'; 
                                    tablePaneContent += ' class="ledDotUnknown"';
                                    tablePaneContent += ' title="LED 2" style="margin-left:5px"></span>';
                                    displayId = dashboardDpList[i].displayElements[t].displayIndex + "__" + dashboardDpList[i].deviceName + "/device/0/nvoHVACTemp";
                                    tablePaneContent += "<div id=\"localValue_" + displayId + "\" class=\"tdValueDiv3\" title=\"Temperature\"></div>";
                                    tablePaneContent += "<span id=\"unit_" + displayId + "\" title=\"Temperature\"></span>,";
                                    displayId = dashboardDpList[i].displayElements[t].displayIndex + "__" + dashboardDpList[i].deviceName + "/device/0/nvoLuxLevel";
                                    tablePaneContent += "<div id=\"localValue_" + displayId + "\" class=\"tdValueDiv3\" title=\"Light Level\"></div>";
                                    tablePaneContent += "<span id=\"unit_" + displayId + "\" title=\"Light Level\"></span>,";
                                    displayId = dashboardDpList[i].displayElements[t].displayIndex + "__" + dashboardDpList[i].deviceName + "/device/0/nvoPulseOut";
                                    tablePaneContent += "<div id=\"localValue_" + displayId + "\" class=\"tdValueDiv3\" title=\"PulseOut\"></div>";
                                    tablePaneContent += '</div></td>';
                                    tablePaneContent += "<td></td>";
                                    if(!g_bDashboardTableReadOnly) 
                                        tablePaneContent += '<td></td>';
                                    tablePaneContent += "</tr>";
                                    
                                }
                                else if((dashboardType === "l6") || (dashboardType === "l7")) {
                                    
                                    tablePaneContent += "<td class=\"tdValue\" ><div style=\"display:flex\">";
                                    tablePaneContent += "<div id=\"sliderSwitch_" +  displayId  + "\" style=\"width:70px\">"
                                    tablePaneContent += '<span id="localValueSwitch_' + displayId + '"'; 
                                    if(dashboardDpList[i].value === null) {
                                        
                                    }
                                    else if(locValue > 1) {
                                        tablePaneContent += ' class="ledDotOn"';
                                        tablePaneContent += " style=\"background-Color:";
                                        if(locValue > 80)
                                            tablePaneContent += "lime";
                                        else
                                            tablePaneContent += "orange";
                                        tablePaneContent += "\"";
                                    }
                                    else {
                                        tablePaneContent += ' class="ledDotOff"';
                                        if(dashboardDpList[i].displayElements[t].backgroundColor !== "")
                                            tablePaneContent += " style=\"background-color:" + dashboardDpList[i].displayElements[t].backgroundColor + "\"";
                                        else
                                            tablePaneContent += " style=\"background-color:transparent\"";
                                    }
                                    tablePaneContent += '></span></div>';
                                    if(dashboardType === "l7") {
                                        tablePaneContent += '<div id="localValue_' + displayId + '" style="width:30px;">';
                                        if(dashboardDpList[i].value !== null)   
                                            tablePaneContent += locValue;
                                        tablePaneContent += '</div>'; 
                                    }                       
                                    tablePaneContent += '</div></td>';
                                    tablePaneContent += "<td><span id=\"unit_" + displayId + "\"></span></td>";
                                    //tablePaneContent += "<td><span id=\"priority_" + pathname + "\">" + dashboardDpList[i].priority + "</span></td>";
                                    if(!g_bDashboardTableReadOnly) 
                                        tablePaneContent += '<td></td>';
                                    tablePaneContent += "</tr>";
                                }
                                else {
                                    // "n"
                                    if(typeof dashboardDpList[i].displayElements[t].locValue === "number") {
                                        tempValue = dashboardDpList[i].displayElements[t].locValue;
                                        tempValue = dashboardNumToFixedLength(tempValue, g_iDashboardDecimalPlaces);
                                        tempValueStr = tempValue.toString();
                                        dashboardDpList[i].displayElements[t].locValueStr = tempValueStr;
                                    }
                                    
                                    if((dashboardDpList[i].cat === "out") || (dashboardType === "r") || g_bDashboardTableReadOnly) {
                                        tablePaneContent += "<td class=\"tdValue\"><div id=\"localValue_" + displayId + "\" class=\"tdValueDiv\">";
                                        if((field === "") && (dashboardDpList[i].presetValue !== ""))
                                            tablePaneContent += dashboardDpList[i].presetValue + "</div></div></td>";
                                        else if((field === "") && (dashboardDpList[i].dashboardType === "a")) {
                                            tablePaneContent += dashboardDpList[i].locValue.ascii + "</div></div></td>";
                                        }
                                        else {
                                            tablePaneContent += dashboardDpList[i].displayElements[t].locValueStr + "</div></div></td>";
                                        }
                                    }
                                    else if(dashboardDpList[i].cat === "in") {
                                        if(dashboardDpList[i].displayElements[t].bEnum) {
                                        //if((field === "") && dashboardDpList[i].isEnum) { // remove
                                            dashboardDpList[i].displayElements[t].dashboardType = "d"; // dropdown
                                            tablePaneContent += "<td><div class=\"tdNewValueDiv\"><select id=\"localValue_" + displayId + "\" onchange=\"dashboardDropdownSelected(this," + i + ", " + t + ", '" + programmaticPathname + "','" + displayId + "')\">"; 
                                            bHasPresets = false;
                                            valueStr = null; 
                                            if((field === "") && (dashboardDpList[i].presetValue !== ""))
                                                valueStr = dashboardDpList[i].presetValue;
                                            else {
                                                if(field === "")
                                                    dashboardDpList[i].locValueStr;
                                                else
                                                    valueStr = dashboardDpList[i].displayElements[t].locValueStr;
                                            }
                                            if((field === "") && (typeof dashboardDpList[i].presets !== "undefined")) {
                                                if(dashboardDpList[i].presets !== null) {
                                                    if(dashboardDpList[i].presets.enabled) {
                                                        if(dashboardDpList[i].presets.map.length > 0) {
                                                            bHasPresets = true;
                                                            for(k=0; k < dashboardDpList[i].presets.map.length; k++)
                                                            {
                                                                name1 = dashboardDpList[i].presets.map[k].name;
                                                                tablePaneContent += "<option value='" + name1 + "'"; 
                                                                if(valueStr === name1)
                                                                    tablePaneContent += " selected";
                                                                tablePaneContent += ">"  + name1 + "</option>";
                                                            }
                                                            
                                                        }
                                                    }
                                                } 
                                            }
                                            enums = [];
                                            if(dashboardDpList[i].displayElements[t].enums.length > 0) 
                                                enums = JSON.parse(JSON.stringify(dashboardDpList[i].displayElements[t].enums));
                                            else {
                                                for(k=0; k < g_snvtTypes.length; k++)
                                                {
                                                    if(dashboardDpList[i].type === g_snvtTypes[k].typeId) {
                                                        enums = g_snvtTypes[k];
                                                        temp = readSnvtTypeFieldValue(g_snvtTypes[k], field);
                                                        if(temp.valid) {
                                                            enums = JSON.parse(JSON.stringify(temp.datatypeJson.enum));
                                                        }
                                                    }
                                                }
                                            }
                                               
                                            for(s = 0; s < enums.length; s++)
                                            {
                                                tablePaneContent += "<option value='" + enums[s].id + "'";
                                                if(valueStr === enums[s].id)
                                                    tablePaneContent += " selected";
                                                tablePaneContent += ">"  + enums[s].id + "</option>";
                                            }
                                            tablePaneContent += "</select></div></td>";
                                            if(!g_bDashboardTableReadOnly) 
                                                addElementToEditButtonElementList("localValue_" + displayId, "d", "disable");
                                        }
                                        else {
                                            tablePaneContent += "<td><div class=\"tdNewValueDiv\"><input id=\"localValue_" + displayId;
                                            if(iInputTextBoxSize === 0)
                                                tablePaneContent +=  "\" size=\"35\" "; 
                                            else 
                                                tablePaneContent += "\" size=\"" + iInputTextBoxSize + "\" ";
                                            bHasPresets = false;
                                            valueStr = null; 
                                            if((field === "") && (dashboardDpList[i].presetValue !== ""))
                                                valueStr = dashboardDpList[i].presetValue;
                                            else if (field !== "")
                                                valueStr = tempValueStr;
                                            else if(dashboardDpList[i].dashboardType === "a") 
                                                valueStr = dashboardDpList[i].locValue.ascii;
                                            else
                                                valueStr = dashboardDpList[i].locValueStr;
                                            if((field === "") && (typeof dashboardDpList[i].presets !== "undefined")) {
                                                if(dashboardDpList[i].presets !== null) {
                                                    if(dashboardDpList[i].presets.enabled) {
                                                        if(dashboardDpList[i].presets.map.length > 0) {
                                                            bHasPresets = true;
                                                            tablePaneContent += " list='dpNewValuePresetList_" + displayId + "' value='" + valueStr + "'><datalist id='dpNewValuePresetList_" + displayId + "'>"
                                                            for(k=0; k < dashboardDpList[i].presets.map.length; k++)
                                                            {
                                                                name1 = dashboardDpList[i].presets.map[k].name;
                                                                tablePaneContent += "<option value='" + name1 + "'>"  + name1 + "</option>";
                                                            }
                                                            tablePaneContent += "<option value='" + dashboardDpList[i].locValueStr + "'>Raw Value</option>";
                                                            tablePaneContent += "</datalist>";
                                                        }
                                                    }
                                                } 
                                            }
                                            if(!bHasPresets) {
                                                    tablePaneContent += " list='dpNewValuePresetList_" + displayId + "' value='" + valueStr + "'><datalist id='dpNewValuePresetList_" + displayId + "'>";
                                                    tablePaneContent += "<option value='" + dashboardDpList[i].locValueStr + "'>Raw Value</option>";
                                                    tablePaneContent += "</datalist>";
                                            } 
                                            tablePaneContent += "<button id=\"sendButton_" + displayId + "\" style=\"margin-left:10px\" onclick=\"inputBoxSendValue1(1, this, event, " + i + ", " + t + ", '" + displayId + "')\">Send</button></div></td>";
                                            if(!g_bDashboardTableReadOnly) {
                                                addElementToEditButtonElementList("localValue_" + displayId, "input", "disable");
                                                addElementToEditButtonElementList("sendButton_" + displayId, "b", "disable");
                                            }
                                        }
                                        
                                    }
                                    else 
                                        tablePaneContent += "<td></td>";
                                    tablePaneContent += "<td><span id=\"unit_" + displayId + "\">";
                                    if(typeof dashboardDpList[i].displayElements[t].units !== "undefined") {
                                        if(dashboardDpList[i].displayElements[t].units !== "") {
                                            if(dashboardDpList[i].displayElements[t].units !== "undefined") {
                                                if(dashboardDpList[i].displayElements[t].units.indexOf(",") === -1) {
                                                    tablePaneContent += dashboardDpList[i].displayElements[t].units;
                                                    bUnitsUsed = true;
                                                }
                                            }
                                        }
                                    }
                                    tablePaneContent += "</span></td>";
                                    if(g_bDashboardTableReadOnly)  {

                                    }
                                    else if((dashboardDpList[i].cat === "out") || (dashboardType === "r")) {
                                        tablePaneContent += '<td></td>';
                                    // tablePaneContent += "<td><span id=\"priority_" + pathname + "\">" + dashboardDpList[i].priority + "</span></td>";
                                    }
                                    else { // in
                                            //tablePaneContent += "<td><input id=\"priority_" + pathname + "\" value=\"" + dashboardDpList[i].priority + "\" size=\"3\">";
                                        if(!g_bDashboardTableReadOnly) {
                                            if(typeof dashboardDpList[i].values !== "undefined") {
                                                if(dashboardDpList[i].values !== null) {   
                                                    tablePaneContent += "<td><div style=\"display:flex\">";
                                                    if((dashboardDpList[i].writePriorityStart + 1) === dashboardDpList[i].writePriorityEnd)
                                                        tablePaneContent += "<span>" + dashboardDpList[i].writePriorityStart + "</span>";
                                                    else {
                                                        tablePaneContent += "<select id=\"priority_" + displayId + "\">";
                                                        w = dashboardDpList[i].priority;
                                                        if(dashboardDpList[i].priority < dashboardDpList[i].writePriorityStart)
                                                            w = dashboardDpList[i].writePriorityStart;
                                                        for(s=dashboardDpList[i].writePriorityStart; s < dashboardDpList[i].writePriorityEnd; s++)
                                                        {
                                                            tablePaneContent += "<option value=\"" + s + "\"";
                                                            if(w === s)
                                                                tablePaneContent += " selected";
                                                            tablePaneContent += ">" + s + "</option>";
                                                        }
                                                        if(dashboardDpList[i].writePriorityNormal) {
                                                            tablePaneContent += "<option value=\"17\"";
                                                            if(dashboardDpList[i].priority === 17)
                                                                tablePaneContent += " selected";
                                                            tablePaneContent += ">" + "Normal" + "</option>";
                                                            
                                                        }
                                                        tablePaneContent += "</select>"
                                                    }
                                                    addElementToEditButtonElementList("priority_" + displayId, "d", "visible");
                                                    tablePaneContent += "<button id=\"dpValueMenu_" + displayId + "\" class=\"";
                                                    if(dashboardDpList[i].values.level === 17)
                                                        tablePaneContent += "priorityButtonNotActive";
                                                    else 
                                                        tablePaneContent += "priorityButtonActive";
                                                    tablePaneContent += "\" onclick=\"menuDpValue1(4, this, " + i + ", " + t + ", 'dpValueMenu_" + displayId + "','" + programmaticPathname + "')\">";
                                                    if((dashboardDpList[i].values.level === 17) || (g_iCurrentPriorityButtonType === 1))
                                                        tablePaneContent += "...";
                                                    else
                                                        tablePaneContent += "P " + dashboardDpList[i].values.level;
                                                    tablePaneContent += "</button></div></td>";
                                                    dashboardDpList[i].displayElements[t].bHasPriorityButton = true;
                                                    g_bAtLeastOneElementUsesPriority = true;
                                                    addElementToEditButtonElementList("dpValueMenu_" + displayId, "menu", "visible");
                                                }
                                                else {
                                                    tablePaneContent += "<td></td>"; // required for current shipping IOX iox.sys
                                                }
                                            }
                                            else {
                                                tablePaneContent += "<td></td>"; // should never get to this code but just in case
                                            }
                                        }
                                    }
                                    tablePaneContent += "</tr>";
                                }
                            }
                        } // j === 9
                        
                    } //for(t=0; t < dashboardDpList[i].displayelements.length; t ++)
                } //for(i=0; i < dashboardDpList.length; i ++)
            } // for(j=0; j < 7; j ++)
            

            if(index > 0) {

                if(tablePaneContent !== "") {
                    tempContent = "<div id=\"dashboardTableDiv\">";
                    if(bAddDeviceName) {
                        tempContent += "<table id=\"myTable\" class=\"dashboardTable\">"
                        tempContent += "<tHead><tr><th class=\"tableResizeTh\" onclick=\"sortTable(0)\" >#" + dashboardAddTableResize(0, false) + "</th>";
                        tempContent += "<th class=\"tableResizeTh\" onclick=\"sortTable(1)\">Device" + dashboardAddTableResize(1, false) + "</th>";
                        tempContent += "<th class=\"tableResizeTh\" onclick=\"sortTable(2)\">Datapoint" + dashboardAddTableResize(2, false) + "</th>";
                        tempContent += "<th class=\"tableResizeTh\" onclick=\"sortTable(3)\" class=\"tdValue\">Value" + dashboardAddTableResize(3, true) + "</th>";
                        tempContent += "<th class=\"tableResizeTh\" onclick=\"sortTable(4)\">Units" + dashboardAddTableResize(4, false) + "</th>";
                        if(!g_bDashboardTableReadOnly) 
                            tempContent += "<th class=\"tableResizeTh\" onclick=\"sortTable(5)\">Priority" + dashboardAddTableResize(5, false) + "</th>";
                        tempContent += "</tHead><tbody>";
                    }
                    else {
                        tempContent += "<table id=\"myTable\" class=\"dashboardTable\">"
                        tempContent += "<tHead><tr><th class=\"tableResizeTh\" onclick=\"sortTable(0)\">#" + dashboardAddTableResize(0, false) + "</th>";
                        tempContent += "<th class=\"tableResizeTh\" onclick=\"sortTable(1)\">Datapoint" + dashboardAddTableResize(1, false) + "</th>";
                        tempContent += "<th class=\"tableResizeTh\" onclick=\"sortTable(2)\" class=\"tdValue\">Value" + dashboardAddTableResize(2, true) + "</th>";
                        tempContent += "<th class=\"tableResizeTh\" onclick=\"sortTable(3)\">Units" + dashboardAddTableResize(3, false) + "</th>";
                        if(!g_bDashboardTableReadOnly) 
                            tempContent += "<th class=\"tableResizeTh\" onclick=\"sortTable(4)\">Priority" + dashboardAddTableResize(4, false) + "</th>";
                        tempContent += "</tHead><tbody>";
                    }
                    tablePaneContent = tempContent + tablePaneContent + "</tbody></table></div>";
                    bContinue2 = true;
                    if((tableX !== null) && (tableY !== null)) {
                        obj = {};
                        obj.dashboardType = "dashboardTable";
                        obj.x = tableX;
                        obj.y = tableY;
                        obj.content = tablePaneContent;
                        layoutUiList.push(obj); 
                        bContinue2 = false;
                        
                    }
                    else if(bFixedLayout) {
                        bContinue2 = true;
                        if(tableLayout !== null) {
                            obj = {};
                            obj.layout = tableLayout;
                            obj.content = tablePaneContent;
                            obj.dashboardType = "dashboardTable";
                            layoutList.push(obj);
                            bContinue2 = false;
                        }
                    }
                    if(bContinue2)
                        paneContent += tablePaneContent;
                }
                
            }
            if(bFixedLayout) {
                // first check if all layouts have configuration, need to take into account that there is also table data
                // second order layouts
                // third add UI to layouts
                // graphic with no layout are first in list, table with no layout are last in list or last row. 
                // device with no layout getting added at end depending on layout style
                try {
                    for(i=0; i < layoutList.length; i++)
                    { // check layout info, if not assigned c,r or e then make 1000
                        if((g_oDashboardLayout.layout === "cre") || (g_oDashboardLayout.layout === "rc") || (g_oDashboardLayout.layout === "cr")) {
                            if(layoutList[i].layout === null) {
                                layoutList[i].layout = {};
                                layoutList[i].layout.c = 1000;
                                layoutList[i].layout.r = 1000;
                            }
                            else {
                                if(layoutList[i].layout.c === -1)
                                    layoutList[i].layout.c = 1000;
                                if(layoutList[i].layout.r === -1)
                                    layoutList[i].layout.r = 1000;
                                if(g_oDashboardLayout.layout === "cre") {
                                    if(layoutList[i].layout.e === -1)
                                        layoutList[i].layout.e = 1000;
                                }
                            }
                        }

                    }
                    for(i=0; i < layoutList.length; i++)
                    { // add to layout order - depends on layout type
                        if(g_oDashboardLayout.layout === "cre") {
                            //first item is column, layoutlist object is always at "e" level
                            
                            z = -1;
                            for(j=0; j < layoutOrderList.length; j++)
                            { // checking columns
                                if(layoutList[i].layout.c < layoutOrderList[j].number) {
                                    //insert array.
                                    obj = {};
                                    obj.number = layoutList[i].layout.c;
                                    obj.items = [];
                                    obj.type = "c";

                                    obj1 = {};
                                    obj1.number = layoutList[i].layout.r;
                                    obj1.items = [];
                                    obj1.type = "r";

                                    obj2 = {};
                                    obj2.number = layoutList[i].layout.e;
                                    obj2.items = [];
                                    obj2.type = "e";
                                    obj2.items.push(JSON.parse(JSON.stringify(layoutList[i])))

                                    obj1.items.push(JSON.parse(JSON.stringify(obj2)));
                                    obj.items.push(JSON.parse(JSON.stringify(obj1)));
                                    layoutOrderList.splice(j,0,JSON.parse(JSON.stringify(obj)))
                                    z = j;
                                    break;
                                }
                                else if(layoutList[i].layout.c === layoutOrderList[j].number) {
                                    // check row
                                    for(m=0; m < layoutOrderList[j].items.length; m++)
                                    {
                                        if(layoutList[i].layout.r < layoutOrderList[j].items[m].number) {
                                            //insert array.
                                            obj1 = {};
                                            obj1.number = layoutList[i].layout.r;
                                            obj1.items = [];
                                            obj1.type = "r";

                                            obj2 = {};
                                            obj2.number = layoutList[i].layout.e;
                                            obj2.items = [];
                                            obj2.type = "e";
                                            obj2.items.push(JSON.parse(JSON.stringify(layoutList[i])))

                                            obj1.items.push(JSON.parse(JSON.stringify(obj2)));
                                            layoutOrderList[j].items.splice(m,0,JSON.parse(JSON.stringify(obj1)))
                                            z = m;
                                            break;
                                        }
                                        else if(layoutList[i].layout.r === layoutOrderList[j].items[m].number) {
                                            // check element column
                                            for(k=0; k < layoutOrderList[j].items[m].items.length; k++)
                                            {
                                                if(layoutList[i].layout.e < layoutOrderList[j].items[m].items[k].number) {
                                                    //insert array before.
                                                    obj = {};
                                                    obj.number = layoutList[i].layout.e;
                                                    obj.items = [];
                                                    obj.type = "e";
                                                    obj.items.push(JSON.parse(JSON.stringify(layoutList[i])))
                                                    layoutOrderList[j].items[m].items.splice(k,0,JSON.parse(JSON.stringify(obj)))
                                                    z = k;
                                                    break;
                                                }
                                                else if(layoutList[i].layout.e === layoutOrderList[j].items[m].items[k].number)
                                                    break; // add to bottom of list
                                            }
                                            if(z === -1) {
                                                obj = {};
                                                obj.number = layoutList[i].layout.e;
                                                obj.items = [];
                                                obj.type = "e";
                                                obj.items.push(JSON.parse(JSON.stringify(layoutList[i])))
                                                layoutOrderList[j].items[m].items.push(JSON.parse(JSON.stringify(obj)))
                                                z = k + 1;
                                            }
                                        }
                                    }
                                    if(z === -1) {
                                        obj1 = {};
                                        obj1.number = layoutList[i].layout.r;
                                        obj1.items = [];
                                        obj1.type = "r";
            
                                        obj2 = {};
                                        obj2.number = layoutList[i].layout.e;
                                        obj2.items = [];
                                        obj2.type = "e";
                                        obj2.items.push(JSON.parse(JSON.stringify(layoutList[i])))
            
                                        obj1.items.push(JSON.parse(JSON.stringify(obj2)));
                                        layoutOrderList[j].items.push(JSON.parse(JSON.stringify(obj1)));
                                        z = m + 1;
                                    }
                                    if(z !== -1)
                                        break;
                                }
                            }
                            if(z === -1) {
                                obj = {};
                                obj.number = layoutList[i].layout.c;
                                obj.items = [];
                                obj.type = "c";

                                obj1 = {};
                                obj1.number = layoutList[i].layout.r;
                                obj1.items = [];
                                obj1.type = "r";

                                obj2 = {};
                                obj2.number = layoutList[i].layout.e;
                                obj2.items = [];
                                obj2.type = "e";
                                obj2.items.push(JSON.parse(JSON.stringify(layoutList[i])))

                                obj1.items.push(JSON.parse(JSON.stringify(obj2)));
                                obj.items.push(JSON.parse(JSON.stringify(obj1)));
                                layoutOrderList.push(JSON.parse(JSON.stringify(obj)));
                                z = j + 1;
                            }
                            
                        }
                    }
                    if(layoutOrderList.length > 0) {
                        // add to paneContent
                        tempContent = "";
                        if(layoutOrderList.length > 1)
                            tempContent += "<div style=\"display:flex\">";
                        for(i=0; i < layoutOrderList.length; i++)
                        { 
                            tempContent += "<div style=\"display:block\">";
                            for(j=0; j < layoutOrderList[i].items.length; j++)
                            { 
                                if( layoutOrderList[i].items[j].items.length > 1)
                                    tempContent += "<div style=\"display:flex\">";
                                try {
                                    for(k=0; k < layoutOrderList[i].items[j].items.length; k++)
                                    { 
                                        try {
                                            tempContent += layoutOrderList[i].items[j].items[k].items[0].content; 
                                            if(layoutOrderList[i].items[j].items[k].items[0].dashboardType === "dashboardImage")
                                                bAddEndingDiv = true;
                                            bAddEndingDiv = true;
                                        }
                                        catch {}
                                    }
                                }
                                catch {}
                                if( layoutOrderList[i].items[j].items.length > 1)
                                    tempContent += "</div>";
                                else 
                                    tempContent += "<br>";
                                
                            }
                            tempContent += "</div>";
                        }
                        if(layoutOrderList.length > 1)
                            tempContent += "</div>";
                        paneContent +=  tempContent;
                    }
                }
                catch (err) {
                    sTemp = err.toString();
                }
            }
        }
        //navtree
        if(bAddEndingDiv)
            paneContent += "</div>"; // for image
        element = document.getElementById("planningPaneDetails_Details"); //navtree
        if(element !== null) {
            sTemp = "";
            
            if(dashboardDpList.length >  g_iDashboardMaxNumberOfDatapointsAllowed)
                sTemp = "<div style=\"inline-block\"><br><br>* The number of datapoints may slow down update times</div>"
            element.innerHTML =  "<div>" + paneContent + "</div>" + sTemp;

            // add UI graphics that have x and y specified
            element1 = document.getElementById("dashboardMainDiv"); //("floorplanimageDiv");
            if(element1 !== null) {
                for(i=0; i < layoutUiList.length; i++) {
                    try {
                        x = layoutUiList[i].x;
                        y = layoutUiList[i].y;
                        if(layoutUiList[i].dashboardType === "dashboardImage")
                            bImageAdded = true;
                        sTemp = "<div style=\"position:absolute;padding:5px;top:" + y + "px;left:" + x + "px;background-color:white\">";
                        sTemp += layoutUiList[i].content;
                        sTemp += "</div>";
                        element1.innerHTML += sTemp;
                    }
                    catch {}
                }
            }
            // add ms1 and pg1 entries
            
            for(j=0; j < specialDevice.length; j++)
            {
                try {
                    if(specialDevice[j].dashboardType === "l5d1") {
                        // find match datapoint
                        try {
                            i = specialDevice[j].i;
                            t = specialDevice[j].t;
                            sTemp2 = specialDevice[j].deviceName + "/Rocker B/2/Switch B";
                            for(i1 = 0; i1 < dashboardDpList.length; i1++)
                            {
                                if(dashboardDpList[i1].pathname === sTemp2) {
                                    for(i2 = 0; i2 < dashboardDpList[i1].displayElements.length; i2++)
                                    {
                                        if(dashboardDpList[i1].displayElements[i2].dashboardType === "l5d") {
                                            dashboardDpList[i].displayElements[t].displayId = dashboardDpList[i1].displayElements[i2].new_iDisplayIndex + "__" + dashboardDpList[i1].deviceName + "/Rocker A/1/Switch A";
                                            dashboardDpList[i].displayElements[t].displayIndex = dashboardDpList[i1].displayElements[i2].new_iDisplayIndex;
                                            i1 = dashboardDpList.length + 1;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                        catch {}
                    }
                    else if(specialDevice[j].dashboardType === "ms1") {
                        i = specialDevice[j].i;
                        t = specialDevice[j].t;
                        sTemp2 = dashboardDpList[i].deviceName + "/Switch/0/nvoSwitch";
                        for(i1 = 0; i1 < dashboardDpList.length; i1++)
                        {
                            if(dashboardDpList[i1].pathname === sTemp2) {
                                for(i2 = 0; i2 < dashboardDpList[i1].displayElements.length; i2++)
                                {
                                    if(dashboardDpList[i1].displayElements[i2].dashboardType === "ms") {
                                        try {
                                            if(dashboardDpList[i].pathname === dashboardDpList[i].deviceName + "/LightSensor/0/nvoLightLevel") {
                                                dashboardDpList[i].displayElements[t].displayId = dashboardDpList[i1].displayElements[i2].new_iDisplayIndex + "__" + dashboardDpList[i].deviceName + "/LightSensor/0/nvoLightLevel";
                                                dashboardDpList[i].displayElements[t].displayIndex = dashboardDpList[i1].displayElements[i2].new_iDisplayIndex;
                                                dashboardDpList[i].displayElements[t].dashboardType = "r";
                                                if(dashboardDpList[i].displayElements[t].locValue !== null) {
                                                    element = document.getElementById("localValue_" + dashboardDpList[i].displayElements[t].displayId);
                                                    if(element !== null)
                                                        element.innerHTML = dashboardDpList[i].displayElements[t].locValue;
                                                    if(dashboardDpList[i].displayElements[t].units !== "") {
                                                        element = document.getElementById("unit_" + dashboardDpList[i].displayElements[t].displayId);
                                                        if(element !== null)
                                                            element.innerHTML = "&nbsp;" + dashboardDpList[i].displayElements[i2].units;
                                                    }
                                                }
                                            }
                                            else if(dashboardDpList[i].pathname === dashboardDpList[i].deviceName + "/TempSensor/0/nvoTemperature") {
                                                dashboardDpList[i].displayElements[t].displayId = dashboardDpList[i1].displayElements[i2].new_iDisplayIndex + "__" + dashboardDpList[i].deviceName + "/TempSensor/0/nvoTemperature";
                                                dashboardDpList[i].displayElements[t].displayIndex = dashboardDpList[i1].displayElements[i2].new_iDisplayIndex;
                                                dashboardDpList[i].displayElements[t].dashboardType = "r";
                                                if(dashboardDpList[i].displayElements[t].locValue !== null) {
                                                    element = document.getElementById("localValue_" + dashboardDpList[i].displayElements[t].displayId);
                                                    if(element !== null) {
                                                        tempValue2 = dashboardDpList[i].displayElements[t].locValue;
                                                        if(dashboardDpList[i].displayElements[t].precision !== -1) {
                                                            tempValue2 = dashboardNumToFixedLength(tempValue2, dashboardDpList[i].displayElements[t].precision);
                                                        }
                                                        else if(g_bDashboardMinMaxDecimalPlaces)
                                                            tempValue2 = dashboardNumToFixedLength(tempValue2, g_iDashboardDecimalPlaces);
                                                        element.innerHTML = tempValue2;
                                                    }
                                                    
                                                    if(dashboardDpList[i].displayElements[t].units !== "") {
                                                        element = document.getElementById("unit_" + dashboardDpList[i].displayElements[t].displayId);
                                                        if(element !== null)
                                                            element.innerHTML = "&nbsp;" + dashboardDpList[i1].displayElements[t].units;
                                                    }
                                                }
                                            }
                                            else if((dashboardDpList[i].pathname === dashboardDpList[i].deviceName + "/Lamp/0/nvoLampFb") || (dashboardDpList[i].pathname === dashboardDpList[i].deviceName + "/Lamp/1/nvoLampFb")
                                                 || (dashboardDpList[i].pathname === dashboardDpList[i].deviceName + "/Switch/1/nvoSwitch")) {
                                                dashboardDpList[i].displayElements[t].displayId = dashboardDpList[i1].displayElements[i2].new_iDisplayIndex + "__" + dashboardDpList[i].pathname; //dashboardDpList[i].deviceName + "/Lamp/1/nvoLampFb";
                                                dashboardDpList[i].displayElements[t].displayIndex = dashboardDpList[i1].displayElements[i2].new_iDisplayIndex;
                                                
                                                if(dashboardDpList[i].displayElements[t].locValue !== null) {
                                                    dashboardDpList[i].displayElements[t].dashboardType = "l4";

                                                    element = document.getElementById("localValueSwitch_" + dashboardDpList[i].displayElements[t].displayId);
                                                    if(element !== null) {
                                                        if(dashboardDpList[i].locValue.state === 1) {
                                                            element.className = "ledDotOn";
                                                            if(dashboardDpList[i].displayElements[t].color !== "")
                                                                element.style.backgroundColor =  dashboardDpList[i].displayElements[t].color;
                                                        }
                                                        else {
                                                            element.className = "ledDotOff";
                                                            if(dashboardDpList[i].displayElements[t].backgroundColor !== "")
                                                                element.style.backgroundColor =  dashboardDpList[i].displayElements[t].backgroundColor;
                                                            else
                                                             element.style.backgroundColor =  "transparent";
                                                        }
                                                    }
                                                }
                                            }
                                        } catch {}
                                        i1 = dashboardDpList.length + 1;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    else if(specialDevice[j].dashboardType === "pg1") {
                        i = specialDevice[j].i;
                        t = specialDevice[j].t;
                        sTemp2 = dashboardDpList[i].deviceName + "/device/0/nvoSwitch1";
                        for(i1 = 0; i1 < dashboardDpList.length; i1++)
                        {
                            if(dashboardDpList[i1].pathname === sTemp2) {
                                for(i2 = 0; i2 < dashboardDpList[i1].displayElements.length; i2++)
                                {
                                    if(dashboardDpList[i1].displayElements[i2].dashboardType === "pg") {
                                        try {
                                            if(dashboardDpList[i].pathname === dashboardDpList[i].deviceName + "/device/0/nvoLuxLevel") {
                                                dashboardDpList[i].displayElements[t].displayId = dashboardDpList[i1].displayElements[i2].new_iDisplayIndex + "__" + dashboardDpList[i].deviceName + "/device/0/nvoLuxLevel";
                                                dashboardDpList[i].displayElements[t].displayIndex = dashboardDpList[11].displayElements[i2].new_iDisplayIndex;
                                                dashboardDpList[i].displayElements[t].dashboardType = "r";
                                                if(dashboardDpList[i].displayElements[t].locValue !== null) {
                                                    element = document.getElementById("localValue_" + dashboardDpList[i].displayElements[t].displayId);
                                                    if(element !== null)
                                                        element.innerHTML = dashboardDpList[i].displayElements[t].locValue;
                                                    if(dashboardDpList[i].displayElements[t].units !== "") {
                                                        element = document.getElementById("unit_" + dashboardDpList[i].displayElements[t].displayId);
                                                        if(element !== null)
                                                            element.innerHTML = "&nbsp;" + dashboardDpList[i].displayElements[t].units;
                                                    }
                                                }
                                            }
                                            else if(dashboardDpList[i].pathname === dashboardDpList[i].deviceName + "/device/0/nvoHVACTemp") {
                                                dashboardDpList[i].displayElements[t].displayId = dashboardDpList[i1].displayElements[i2].new_iDisplayIndex + "__" + dashboardDpList[i].deviceName + "/device/0/nvoHVACTemp";
                                                dashboardDpList[i].displayElements[t].displayIndex = dashboardDpList[i1].displayElements[i2].new_iDisplayIndex;
                                                dashboardDpList[i].displayElements[t].dashboardType = "r";
                                                if(dashboardDpList[i].displayElements[t].locValue !== null) {
                                                    element = document.getElementById("localValue_" + dashboardDpList[i].displayElements[t].displayId);
                                                    if(element !== null) {
                                                        tempValue2 = dashboardDpList[i].displayElements[t].locValue;
                                                        if(dashboardDpList[i].displayElements[t].precision !== -1) {
                                                            tempValue2 = dashboardNumToFixedLength(tempValue2, dashboardDpList[i].displayElements[t].precision);
                                                        }
                                                        else if(g_bDashboardMinMaxDecimalPlaces)
                                                            tempValue2 = dashboardNumToFixedLength(tempValue2, g_iDashboardDecimalPlaces);
                                                        element.innerHTML = tempValue2;
                                                    }
                                                    
                                                    if(dashboardDpList[i].displayElements[t].units !== "") {
                                                        element = document.getElementById("unit_" + dashboardDpList[i].displayElements[t].displayId);
                                                        if(element !== null)
                                                            element.innerHTML = "&nbsp;" + dashboardDpList[i].displayElements[t].units;
                                                    }
                                                }
                                            }
                                            else if((dashboardDpList[i].pathname === dashboardDpList[i].deviceName + "/device/0/nvoLamp1") || (dashboardDpList[i].pathname === dashboardDpList[i].deviceName + "/device/0/nvoLamp2")
                                                || (dashboardDpList[i].pathname === dashboardDpList[i].deviceName + "/device/0/nvoSwitch2")) {
                                                
                                                dashboardDpList[i].displayElements[t].displayId = dashboardDpList[i1].displayElements[i2].new_iDisplayIndex + "__" + dashboardDpList[i].pathname; //dashboardDpList[i].deviceName + "/device/0/nvoLamp2";
                                                dashboardDpList[i].displayElements[t].displayIndex = dashboardDpList[i1].displayElements[i2].new_iDisplayIndex;
                                                
                                                if(dashboardDpList[i].displayElements[t].locValue !== null) {
                                                    dashboardDpList[i].displayElements[t].dashboardType = "l4";

                                                    element = document.getElementById("localValueSwitch_" + dashboardDpList[i].displayElements[t].displayId);
                                                    if(element !== null) {
                                                        if(dashboardDpList[i].locValue.state === 1) {
                                                            element.className = "ledDotOn";
                                                            if(dashboardDpList[i].displayElements[t].color !== "")
                                                                element.style.backgroundColor =  dashboardDpList[i].displayElements[t].color;
                                                        }
                                                        else {
                                                            element.className = "ledDotOff";
                                                            if(dashboardDpList[i].displayElements[t].backgroundColor !== "")
                                                                element.style.backgroundColor =  dashboardDpList[i].displayElements[t].backgroundColor;
                                                            else
                                                             element.style.backgroundColor =  "transparent";
                                                        }
                                                    }
                                                }
                                            }
                                            else if(dashboardDpList[i].pathname === dashboardDpList[i].deviceName + "/device/0/nvoPulseOut") {
                                                dashboardDpList[i].displayElements[t].displayId = dashboardDpList[i1].displayElements[i2].new_iDisplayIndex + "__" + dashboardDpList[i].deviceName + "/device/0/nvoPulseOut";
                                                dashboardDpList[i].displayElements[t].displayIndex = dashboardDpList[i1].displayElements[i2].new_iDisplayIndex;
                                                dashboardDpList[i].displayElements[t].dashboardType = "r";
                                                if(dashboardDpList[i].displayElements[t].locValue !== null) {
                                                    element = document.getElementById("localValue_" + dashboardDpList[i].displayElements[t].displayId);
                                                    if(element !== null)
                                                        element.innerHTML = dashboardDpList[i].displayElements[t].locValue;
                                                    if(dashboardDpList[i].displayElements[t].units !== "") {
                                                        element = document.getElementById("unit_" + dashboardDpList[i].displayElements[t].displayId);
                                                        if(element !== null)
                                                            element.innerHTML = "&nbsp;" + dashboardDpList[i].displayElements[t].units;
                                                    }
                                                }
                                            }
                                        } catch {}
                                        i1 = dashboardDpList.length + 1;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
                catch {}
            }
            for(i1=0; i1 < specialDevicesWithValue.length; i1++)
            { // change special datapoints dashboard type if already have initial value
                i = specialDevicesWithValue[i1].i;
                t = specialDevicesWithValue[i1].t;
                if((specialDevicesWithValue[i1].dashboardType === "pg") || (specialDevicesWithValue[i1].dashboardType === "ms")) {
                    dashboardDpList[i].displayElements[t].dashboardType = "l4";
                }
            }
            // add icons graphics - like dashboard floorplan, add device image on top floorplan
            if(g_DashboardImageIcons !== null) {
                if(bImageAdded) {
                    if(dashboardImageDivElement === null) {
                        dashboardImageDivElement = document.getElementById("dashboardImageDiv"); //("floorplanimageDiv");
                    }
                }
                if(dashboardImageDivElement !== null) {
                    offsets = dashboardImageDivElement.getBoundingClientRect(); 
                    for(i=0; i < g_DashboardImageIcons.length; i++)
                    {
                        if((g_DashboardImageIcons[i].image !== null) && g_DashboardImageIcons[i].x && g_DashboardImageIcons[i].y) {
                            x = g_DashboardImageIcons[i].x;
                            //y = offsets.top + window.pageYOffset + graphicDpContentList[i].y;
                            y = g_DashboardImageIcons[i].y;
                            sTemp = "<div style=\"position:absolute;padding:5px;top:" + y + "px;left:" + x + "px;z-index:6\"";
                            if(g_DashboardImageIcons[i].deviceName !== "") {
                                // check if device on system
                                z = -1;
                                sTemp1 = g_DashboardImageIcons[i].deviceName.toLowerCase();
                                for(j=0; j < deviceDpList.length; j++)
                                {
                                    if(deviceListAll[j].name.toLowerCase() === sTemp1) {
                                        z = j;
                                        break;
                                    }
                                }
                                if(z !== -1) {
                                    sTemp += " onclick=\"getPlanningTreeShowDashboard1(false, 0, '', '" + g_DashboardImageIcons[i].deviceName + "')\"";
                                    sTemp += " title=\"" + g_DashboardImageIcons[i].deviceName + "\"";
                                }
                            }
                            sTemp += "><img src=\"" +  g_DashboardImageIcons[i].image + "\" alt=\"device image\"";
                            w = g_DashboardImageIcons[i].width;
                            h = g_DashboardImageIcons[i].height;
                            if(w !== null)
                                sTemp += " width=\"" + w + "px;\""
                            if(h !== null)
                                sTemp += " height=\"" + h + "px;\""
                            
                            sTemp += "></div>";
                            if(sTemp !== "")
                                dashboardImageDivElement.innerHTML += sTemp;
                        }
                    }
                }
                g_DashboardImageIcons = null; 
            }
            // add image graphics
            if(graphicDpContentList.length > 0) {
                if(bImageAdded) {
                    if(dashboardImageDivElement === null) {
                        dashboardImageDivElement = document.getElementById("dashboardImageDiv"); //("floorplanimageDiv");
                    }
                }
                if(dashboardImageDivElement !== null) {
                    offsets = dashboardImageDivElement.getBoundingClientRect(); 
                    graphicDpContent = "";
                    for(i=0; i < graphicDpContentList.length; i++)
                    {
                        try {
                            //x = offsets.x + window.pageXOffset + graphicDpContentList[i].x;
                            z = 0;
                            x = graphicDpContentList[i].x;
                            //y = offsets.top + window.pageYOffset + graphicDpContentList[i].y;
                            y = graphicDpContentList[i].y;
                            sTemp = "<div style=\"position:absolute;padding:5px;top:" + y + "px;left:" + x + "px;";
                            if(graphicDpContentList[i].dashboardType === "r") {
                                sTemp += "color:"
                                if(graphicDpContentList[i].color !== "")
                                    sTemp += graphicDpContentList[i].color;
                                else 
                                    sTemp += "white";
                                sTemp += ";background-color:";
                                if(graphicDpContentList[i].color !== "")
                                    sTemp += graphicDpContentList[i].backgroundColor;
                                else
                                    sTemp += "black";
                                sTemp += ";z-index:6";
                                if(graphicDpContentList[i].width !== "") {
                                    sTemp += ";width:" + graphicDpContentList[i].width;
                                    if(!isNaN(graphicDpContentList[i].width)) // if number then add px
                                        sTemp += "px";
                                }
                                if(graphicDpContentList[i].height !== "") {
                                    sTemp += ";height:" + graphicDpContentList[i].height;
                                    if(!isNaN(graphicDpContentList[i].height)) // if number then add px
                                        sTemp += "px";
                                }
                                if(graphicDpContentList[i].fontsize !== "") {
                                    sTemp += ";font-size:" + graphicDpContentList[i].fontsize;
                                    if(!isNaN(graphicDpContentList[i].fontsize)) // if number then add px
                                        sTemp += "px";
                                }
                                if(g_iDashboardSpanRounded !== 0)
                                    sTemp += ";border-radius:" + g_iDashboardSpanRounded + "px";
                                sTemp += "\">";
                                sTemp += "<span id=\"localValue_" + graphicDpContentList[i].displayId;
                                if(graphicDpContentList[i].label !== "")
                                    sTemp += "\" title=\"" + graphicDpContentList[i].label + "\"";
                                if((g_sSiteDashboardSelected !== "") && g_bSiteDashboardClickDpPathToDevice) 
                                    sTemp += " class=\"treeviewName\" onclick=\"getPlanningTreeShowDashboard(0,'Device_" + graphicDpContentList[i].deviceId + "','" + graphicDpContentList[i].deviceName + "')\"";
                                sTemp += ">";
                                locValueStr = graphicDpContentList[i].locValueStr;
                                locValue = graphicDpContentList[i].locValue;
                                if(graphicDpContentList[i].bFunction) {
                                    if(graphicDpContentList[i].function === "cf")
                                        locValueStr = convertTemperature(0,locValue,graphicDpContentList[i].precision);
                                    else if(graphicDpContentList[i].function === "fc") 
                                        locValueStr = convertTemperature(1,locValue,graphicDpContentList[i].precision);
                                }
                                else if(graphicDpContentList[i].precision !== -1) {
                                    if(typeof locValue === "number")
                                        locValueStr = dashboardNumToFixedLength(locValue, graphicDpContentList[i].precision);
                                }
                                else if(g_bDashboardMinMaxDecimalPlaces) {
                                    if(typeof locValue === "number")
                                        locValueStr = dashboardNumToFixedLength(locValue, g_iDashboardDecimalPlaces);
                                }
                                sTemp += locValueStr + "</span>";
                                if(graphicDpContentList[i].units !== "")
                                    sTemp += "<span style=\"margin-left:5px\">" + graphicDpContentList[i].units + "</span>";
                                sTemp += "</div>"; 
                                graphicDpContent += sTemp;
                            }
                            else if((graphicDpContentList[i].dashboardType === "l2")  || (graphicDpContentList[i].dashboardType === "l3") || (graphicDpContentList[i].dashboardType === "l4")) {
                                color = ""; // on color
                                backgroundColor = "transparent"; //off color
                                borderColor = "";
                                
                                
                                if(typeof graphicDpContentList[i].color !== "undefined") {
                                    if(graphicDpContentList[i].color !== null) {
                                        if(graphicDpContentList[i].color !== "") {
                                            color = graphicDpContentList[i].color;
                                        }
                                    }
                                }
                                if(typeof graphicDpContentList[i].backgroundColor !== "undefined") {
                                    if(graphicDpContentList[i].backgroundColor !== null) {
                                        if(graphicDpContentList[i].backgroundColor !== "") {
                                            backgroundColor = graphicDpContentList[i].backgroundColor;
                                        }
                                    }
                                }
                                if(typeof graphicDpContentList[i].borderColor !== "undefined") {
                                    if(graphicDpContentList[i].borderColor !== null) {
                                        if(graphicDpContentList[i].borderColor !== "") {
                                            borderColor = graphicDpContentList[i].borderColor;
                                        }
                                    }
                                }
                                
                                if(borderColor !== "")
                                    borderColor = ";border-color:" + borderColor;
                                value = graphicDpContentList[i].locValue;
                                sTemp += "z-index:6\">";
                                z = 0;
                                
                                    
                                sTemp += '<span id="localValueSwitch_' + graphicDpContentList[i].displayId + '"';
                                if(typeof graphicDpContentList[i].graphicType !== "undefined") {
                                    z = graphicDpContentList[i].graphicType;
                                    if(z === 5) { // small dot (0 = red, 1=green)
                                        z = 1;
                                        if(value === 0)
                                            backgroundColor = "red";
                                        else 
                                            color = "lawngreen";
                                    }
                                    else if(z === 6) { // small dot (0 = green, 1=red)
                                        z = 1;
                                        if(value === 0)
                                            backgroundColor = "lawngreen";
                                        else 
                                            color = "red";
                                    }
                                    else if(z === 7) { // large dot with border (0 = red, 1=green)
                                        z = 2;
                                        if(value === 0)
                                            backgroundColor = "red";
                                        else 
                                            color = "lawngreen";
                                    }
                                    else if(z === 8) { // large dot with border (0 = red, 1=green)
                                        z = 2;
                                        if(value === 0)
                                            backgroundColor = "lawngreen";
                                        else 
                                            color = "red";
                                    }
                                    else if(z === 9) { // large dot with border (0 = red, 1=green)
                                        z = 3;
                                        if(value === 0)
                                            backgroundColor = "red";
                                        else 
                                            color = "lawngreen";
                                    }
                                    else if(z === 10) { // large dot with border (0 = red, 1=green)
                                        z = 3;
                                        if(value === 0)
                                            backgroundColor = "lawngreen";
                                        else 
                                            color = "red";
                                    }
                                }
                                if((typeof value === "number") || (typeof value ===  "boolean")) { //mike
                                    if(z === 0) {
                                        if(value === 0) {
                                            sTemp += ' class="ledDotOff"';
                                            if(backgroundColor !== ""){
                                                sTemp += " style=\"background-Color:" + backgroundColor + borderColor + "\"";
                                            }
                                        }
                                        else {
                                            sTemp +=  ' class="ledDotOn"';
                                            if(color !== ""){
                                                sTemp += " style=\"background-Color:" + color + borderColor + "\"";
                                            }
                                        }
                                    }
                                    else if(z === 1) {
                                        if(value === 0) {
                                            sTemp += ' class="ledDotSmallOff"';
                                            if(backgroundColor !== ""){
                                                sTemp += " style=\"background-Color:" + backgroundColor + borderColor + "\"";
                                            }
                                        }
                                        else {
                                            sTemp +=  ' class="ledDotSmallOn"';
                                            if(color !== ""){
                                                sTemp += " style=\"background-Color:" + color + borderColor + "\"";
                                            }
                                        }
                                    }
                                    else if(z === 2) {
                                        if(value === 0) {
                                            sTemp += ' class="ledDotMediumOff"';
                                            if(backgroundColor !== ""){
                                                sTemp += " style=\"background-Color:" + backgroundColor + borderColor + "\"";
                                            }
                                        }
                                        else {
                                            sTemp +=  ' class="ledDotMediumOn"';
                                            if(color !== ""){
                                                sTemp += " style=\"background-Color:" + color + borderColor + "\"";
                                            }
                                        }
                                    }
                                    else if(z === 3) {
                                        if(value === 0) {
                                            sTemp += ' class="ledDotOff"';
                                            if(backgroundColor !== ""){
                                                sTemp += " style=\"background-Color:" + backgroundColor + borderColor + "\"";
                                            }
                                        }
                                        else {
                                            sTemp +=  ' class="ledDotOnBorder"';
                                            if(color !== ""){
                                                sTemp += " style=\"background-Color:" + color + borderColor + "\"";
                                            }
                                        }
                                    }
                                }
                                else if(typeof value === "boolean") {
                                    if(z === 0) {
                                        if(value === 0) {
                                            sTemp +=  ' class="ledDotOff"';
                                            if(backgroundColor !== ""){
                                                sTemp += " style=\"background-color:" + backgroundColor + borderColor + "\"";
                                            }
                                        }
                                        else { 
                                            sTemp +=  ' class="ledDotOn"';
                                            if(color !== ""){
                                                sTemp += " style=\"background-Color:" + color + borderColor + "\"";
                                            }
                                        }
                                    }
                                    else if (z === 1) {
                                        if(value === 0) {
                                            sTemp +=  ' class="ledDotSmallOff"';
                                            if(backgroundColor !== ""){
                                                sTemp += " style=\"background-Color:" + backgroundColor + borderColor + "\"";
                                            }
                                        }
                                        else {
                                            sTemp +=  ' class="ledDotSmallOn"';
                                            if(color !== ""){
                                                sTemp += " style=\"background-Color:" + color + borderColor + "\"";
                                            }
                                        }
                                    }
                                    else if (z === 2) {
                                        if(value === 0) {
                                            sTemp +=  ' class="ledDotMediumOff"';
                                            if(backgroundColor !== ""){
                                                sTemp += " style=\"background-Color:" + backgroundColor + borderColor + "\"";
                                            }
                                        }
                                        else {
                                            sTemp +=  ' class="ledDotMediumOn"';
                                            if(color !== ""){
                                                sTemp += " style=\"background-Color:" + color + borderColor + "\"";
                                            }
                                        }
                                    }
                                    else if (z === 3) {
                                        if(value === 0) {
                                            sTemp +=  ' class="ledDotOff"';
                                            if(backgroundColor !== ""){
                                                sTemp += " style=\"background-Color:" + backgroundColor + "\"";
                                            }
                                        }
                                        else {
                                            sTemp +=  ' class="ledDotOnBorder"';
                                            if(color !== ""){
                                                sTemp += " style=\"background-Color:" + color + "\"";
                                            }
                                        }
                                    }
                                }
                                if(graphicDpContentList[i].label !== "")
                                    sTemp += "\" title=\"" + graphicDpContentList[i].label + "\"";
                                if((g_sSiteDashboardSelected !== "") && g_bSiteDashboardClickDpPathToDevice) 
                                    sTemp += " class=\"treeviewName\" onclick=\"getPlanningTreeShowDashboard(0,'Device_" + graphicDpContentList[i].deviceId + "','" + graphicDpContentList[i].deviceName + "')\"";
                                
                                sTemp +=  '></span>';
                                if (graphicDpContentList[i].dashboardType === "l3") {
                                    // add span  mmike
                                    sTemp +=  '<div id="localValue_' + graphicDpContentList[i].displayId + '" style="width:30px;"';
                                    sTemp +=  "onclick=\"getPlanningTreeShowDashboard(0,'Device_" + graphicDpContentList[i].deviceId + "','" + graphicDpContentList[i].deviceName + "')\">";
                                    if(value !== null)   
                                        sTemp += value.toString();
                                    sTemp += '</div>'; 
                                }
                                
                                sTemp += "</div>"; 
                                graphicDpContent += sTemp;
                            }
                            else if((graphicDpContentList[i].dashboardType === "lr2")   || (graphicDpContentList[i].dashboardType === "lr4")) {
                                color = "";
                                backgroundColor = "";
                                if(typeof graphicDpContentList[i].color !== "undefined") {
                                    if(graphicDpContentList[i].color !== null) {
                                        if(graphicDpContentList[i].color !== "") {
                                            color = graphicDpContentList[i].color;
                                        }
                                    }
                                }
                                if(typeof graphicDpContentList[i].backgroundColor !== "undefined") {
                                    if(graphicDpContentList[i].backgroundColor !== null) {
                                        if(graphicDpContentList[i].backgroundColor !== "") {
                                            backgroundColor = graphicDpContentList[i].backgroundColor;
                                        }
                                    }
                                }
                                value = graphicDpContentList[i].locValue;
                                sTemp += "z-index:6\">";
                                z = 0;
                                if(color === "")
                                    color = g_sDashboardLedOnColor;
                                    
                                sTemp += '<div id="localValueSwitch_' + graphicDpContentList[i].displayId + '"';
                                sTemp += ' class="ledRectangle"';
                                if(graphicDpContentList[i].dashboardType === "lr4") {
                                    try {
                                        value = value.state;
                                        
                                    }
                                    catch { value = null;}
                                }
                                if((typeof value === "number") || (typeof value ===  "boolean")) { //mike
                                    if(z === 0) {
                                        if(value === 0) {
                                            if(backgroundColor !== ""){
                                                sTemp += " style=\"background-Color:" + backgroundColor + "\"";
                                            }
                                            else 
                                                sTemp += " style=\"background-Color:transparent\"";
                                        }
                                        else {
                                            if(color !== ""){
                                                sTemp += " style=\"background-Color:" + color + "\"";
                                            }
                                        }
                                    }
                                }
                                else if(typeof value === "boolean") {
                                    if(z === 0) {
                                        if(value === false) {
                                            if(backgroundColor !== ""){
                                                sTemp += " style=\"background-Color:" + backgroundColor + "\"";
                                            }
                                            else 
                                                sTemp += " style=\"background-Color:transparent\"";
                                        }
                                        else {
                                            if(color !== ""){
                                                sTemp += " style=\"background-Color:" + color + "\"";
                                            }
                                        }
                                    }
                                }
                                if(graphicDpContentList[i].label !== "")
                                    sTemp += "\" title=\"" + graphicDpContentList[i].label + "\"";
                                if((g_sSiteDashboardSelected !== "") && g_bSiteDashboardClickDpPathToDevice) 
                                    sTemp += " class=\"treeviewName\" onclick=\"getPlanningTreeShowDashboard(0,'Device_" + graphicDpContentList[i].deviceId + "','" + graphicDpContentList[i].deviceName + "')\"";
                                
                                sTemp +=  '></div>';
                                sTemp += "</div>"; 
                                graphicDpContent += sTemp;
                            }
                            else if (graphicDpContentList[i].dashboardType === "pb") {
                                color = g_sPushbuttonOnBackgroundColor; // on color
                                backgroundColor = "transparent"; //off color
                                borderColor = "";
                                if(typeof graphicDpContentList[i].backgroundColor !== "undefined") {
                                    if(graphicDpContentList[i].backgroundColor !== null) {
                                        if(graphicDpContentList[i].backgroundColor !== "") {
                                            backgroundColor = graphicDpContentList[i].backgroundColor;
                                        }
                                    }
                                }
                                if(g_sSiteDashboardSelected !== "") {
                                    //backgroundColor = g_sPushbuttonOffBackgroundColor;
                                    backgroundColor = g_campusTags.dashboard[0].colorOff;
                                    borderColor = g_campusTags.dashboard[0].colorBorder;
                                }
                                if(borderColor !== "")
                                    borderColor = ";border-color:" + borderColor;
                                value = graphicDpContentList[i].locValue;
                                sTemp += "z-index:6\">";
                                z = 0;
                                sTemp1 = "";
                                if((typeof value === "number") || (typeof value ===  "boolean")) { //mike
                                    if(z === 0) {
                                        if(value === 0) {
                                            if(backgroundColor !== ""){
                                                sTemp1 = " style=\"background-Color:" + backgroundColor + borderColor + "\"";
                                            }
                                        }
                                        else {
                                            if(color !== ""){
                                                sTemp1 = " style=\"background-Color:" + color + borderColor + "\"";
                                            }
                                        }
                                    }
                                }
                                else if(typeof value === "boolean") {
                                    if(z === 0) {
                                        if(value === 0) {
                                            if(backgroundColor !== ""){
                                                sTemp1 = " style=\"background-Color:" + backgroundColor + borderColor + "\"";
                                            }
                                        }
                                        else { 
                                            if(backgroundColor !== ""){
                                                sTemp1 = " style=\"background-Color:" + color + borderColor + "\"";
                                            }
                                        }
                                    }
                                }
                                sTemp += '<div id="pushbuttonDiv_' + graphicDpContentList[i].displayId + '">';
                                sTemp += '<span id="localValueSwitch_' + graphicDpContentList[i].displayId + '"';
                                if(graphicDpContentList[i].label !== "")
                                    sTemp += "\" title=\"" + graphicDpContentList[i].label + "\"";
                                if((g_sSiteDashboardSelected !== "") && g_bSiteDashboardClickDpPathToDevice) 
                                    sTemp += "  onclick=\"getPlanningTreeShowDashboard(0,'Device_" + graphicDpContentList[i].deviceId + "','" + graphicDpContentList[i].deviceName + "')\"";
                                sTemp += " class=\"pushbuttonLedDot\"" + sTemp1;
                                sTemp +=  '></span>';
                                sTemp += "</div>";

                                
                                sTemp += "</div>"; 
                                
                                graphicDpContent += sTemp;
                                addElementToEditButtonElementList1("pushbuttonDiv_" + graphicDpContentList[i].displayId, "pb_graphic", "disable", "", graphicDpContentList[i].index, graphicDpContentList[i].displayElementIndex, graphicDpContentList[i].displayId);
                            }
                            else if (graphicDpContentList[i].dashboardType === "rbt") {
                                sTemp += "z-index:6\">";
                                z = 0;
                                //sTemp1 = "";
                                value = graphicDpContentList[i].locValue;
                                if(typeof value ===  "boolean") {
                                    if(value)
                                        value = 1;
                                    else 
                                        value = 0;
                                }
                                if((typeof value === "number") || (typeof value ===  "boolean")) { 
                                        sTemp += '<input type="radio" name="rbt__' + graphicDpContentList[i].displayId + '"';
                                        sTemp += ' id="rbt__' + graphicDpContentList[i].displayId + '_0"';
                                        sTemp += ' class="horizontalRadio" value="0" ';
                                        sTemp += " onchange=\"dashboardRadtioButtonTemperatureChange(this," + graphicDpContentList[i].index + ", " + graphicDpContentList[i].displayElementIndex + ", '" + graphicDpContentList[i].programmaticPathname + "','" + graphicDpContentList[i].displayId + "')\"";
                                        if(value === 0)
                                            sTemp += ' checked'; 
                                        sTemp += '>°C';
                                        sTemp += '<input type="radio" name="rbt__' + graphicDpContentList[i].displayId + '"';
                                        sTemp += ' id="rbt__' + graphicDpContentList[i].displayId + '_1"';
                                        sTemp += ' class="horizontalRadio" value="1" ';
                                        sTemp += " onchange=\"dashboardRadtioButtonTemperatureChange(this," + graphicDpContentList[i].index + ", " + graphicDpContentList[i].displayElementIndex + ", '" + graphicDpContentList[i].programmaticPathname + "','" + graphicDpContentList[i].displayId + "')\"";
                                        if(value === 1)
                                            sTemp += ' checked';
                                        sTemp += '>°F';
                                }
                                sTemp += "</div>"; 
                                graphicDpContent += sTemp;
                                addElementToEditButtonElementList1("rbt__" + graphicDpContentList[i].displayId, "rbt_graphic", "disable", "", graphicDpContentList[i].index, graphicDpContentList[i].displayElementIndex, graphicDpContentList[i].displayId);
                            }
                            else if(graphicDpContentList[i].dashboardType === "i") {
                                // image swapper
                                value = graphicDpContentList[i].locValue;
                                

                                sTemp += "z-index:6\">";
                                sTemp += "<img id=\"imagelocalValue_" + graphicDpContentList[i].displayId + "\"";
                                sTemp += "src=\"";

                                z = -1;
                                for(j=0; j <graphicDpContentList[i].imageSwapper.length; j++)
                                {
                                    if(graphicDpContentList[i].imageSwapper[j].test === ">") {
                                        if(value > graphicDpContentList[i].imageSwapper[j].value) {
                                            z = j;
                                            break;
                                        }
                                    }
                                    else if(graphicDpContentList[i].imageSwapper[j].test === ">=") {
                                        if(value >= graphicDpContentList[i].imageSwapper[j].value) {
                                            z = j;
                                            break;
                                        }
                                    }
                                    else if(graphicDpContentList[i].imageSwapper[j].test === "=") {
                                        if(value === graphicDpContentList[i].imageSwapper[j].value) {
                                            z = j;
                                            break;
                                        }
                                    }
                                    else if(graphicDpContentList[i].imageSwapper[j].test === "<=") {
                                        if(value <= graphicDpContentList[i].imageSwapper[j].value) {
                                            // check if next value lower value
                                            if(j === (graphicDpContentList[i].imageSwapper.length - 1)) {
                                                z = j;
                                                break;
                                            }
                                            else if(value > graphicDpContentList[i].imageSwapper[j + 1].value){
                                                z = j;
                                                break;
                                            }
                                        }
                                    }
                                    else if(graphicDpContentList[i].imageSwapper[j].test === "<") {
                                        if(value < graphicDpContentList[i].imageSwapper[j].value) {
                                            // check if next value lower value
                                            if(j === (graphicDpContentList[i].imageSwapper.length - 1)) {
                                                z = j;
                                                break;
                                            }
                                            else if(value > graphicDpContentList[i].imageSwapper[j + 1].value){
                                                z = j;
                                                break;
                                            }
                                        }
                                    }
                                }
                                if(z !== -1)
                                    sTemp += graphicDpContentList[i].imageSwapper[z].image;
                                sTemp += "\" alt=\" image\"";
								if(graphicDpContentList[i].width !== null) {
                                    if(graphicDpContentList[i].width !== "") {
                                        sTemp += " width=\"" + graphicDpContentList[i].width;
                                        if(!isNaN(graphicDpContentList[i].width))
                                            sTemp += "px\"";
                                    }
                                }
                                if(graphicDpContentList[i].height !== null) {
                                    if(graphicDpContentList[i].height !== "") {
                                        sTemp += " height=\"" + graphicDpContentList[i].height;
                                        if(!isNaN(graphicDpContentList[i].height))
                                            sTemp += "px\"";
                                    }
                                }
								
                                if(graphicDpContentList[i].label !== "")
                                    sTemp += "\" title=\"" + graphicDpContentList[i].label + "\"";
                                if((g_sSiteDashboardSelected !== "") && g_bSiteDashboardClickDpPathToDevice) 
                                sTemp += " onclick=\"getPlanningTreeShowDashboard(0,'Device_" + graphicDpContentList[i].deviceId + "','" + graphicDpContentList[i].deviceName + "')\"";
                                sTemp +=  '>';
                                sTemp += "</div>"; 
                                graphicDpContent += sTemp;
                            }
                            else if(graphicDpContentList[i].dashboardType === "t1") {
                                // small thermostat
                               
                                value = graphicDpContentList[i].locValue;
                                
                                z = -1;
                                for(j=0; j <graphicDpContentList[i].imageSwapper.length; j++)
                                {
                                    if(graphicDpContentList[i].imageSwapper[j].test === ">") {
                                        if(value > graphicDpContentList[i].imageSwapper[j].value) {
                                            z = j;
                                            break;
                                        }
                                    }
                                    else if(graphicDpContentList[i].imageSwapper[j].test === ">=") {
                                        if(value >= graphicDpContentList[i].imageSwapper[j].value) {
                                            z = j;
                                            break;
                                        }
                                    }
                                    else if(graphicDpContentList[i].imageSwapper[j].test === "=") {
                                        if(value === graphicDpContentList[i].imageSwapper[j].value) {
                                            z = j;
                                            break;
                                        }
                                    }
                                    else if(graphicDpContentList[i].imageSwapper[j].test === "<=") {
                                        if(value <= graphicDpContentList[i].imageSwapper[j].value) {
                                            // check if next value lower value
                                            if(j === (graphicDpContentList[i].imageSwapper.length - 1)) {
                                                z = j;
                                                break;
                                            }
                                            else if(value > graphicDpContentList[i].imageSwapper[j + 1].value){
                                                z = j;
                                                break;
                                            }
                                        }
                                    }
                                    else if(graphicDpContentList[i].imageSwapper[j].test === "<") {
                                        if(value < graphicDpContentList[i].imageSwapper[j].value) {
                                            // check if next value lower value
                                            if(j === (graphicDpContentList[i].imageSwapper.length - 1)) {
                                                z = j;
                                                break;
                                            }
                                            else if(value > graphicDpContentList[i].imageSwapper[j + 1].value){
                                                z = j;
                                                break;
                                            }
                                        }
                                    }
                                }
                                if(z !== -1) {
                                    z = graphicDpContentList[i].imageSwapper[z].image;
                                    if(z === "red")
                                        z = 0;
                                }
                                sTemp += "z-index:6\">";
                                sTemp += "<div  class=\"termometerSmallDiv\"";
                                if(graphicDpContentList[i].label !== "")
                                    sTemp += " title=\"" + graphicDpContentList[i].label + "\"";
                                if((g_sSiteDashboardSelected !== "") && g_bSiteDashboardClickDpPathToDevice) 
                                    sTemp += " onclick=\"getPlanningTreeShowDashboard(0,'Device_" + graphicDpContentList[i].deviceId + "','" + graphicDpContentList[i].deviceName + "')\"";
                                sTemp += ">";
                                sTemp += "<div id=\"thermometerBarlocalValue_" + graphicDpContentList[i].displayId + "\" class=\"";
                                if(z === 0)
                                    sTemp += "thermometerSmallBar";
                                else if(z === "green")
                                    sTemp += "thermometerSmallBarGreen";
                                else if(z === "yellow")
                                    sTemp += "thermometerSmallBarYellow";
                                else if(z === "orange")
                                    sTemp += "thermometerSmallBarOrange";
                                else if(z === "cyan")
                                    sTemp += "thermometerSmallBarCyan";
                                else if(z === "blue")
                                    sTemp += "thermometerSmallBarBlue";
                                sTemp += "\"></div>";
                                sTemp += "<div id=\"thermometerCirclelocalValue_" + graphicDpContentList[i].displayId + "\" class=\"";
                                if(z === 0)
                                    sTemp += "thermometerSmallCircle"
                                else if(z === "green")
                                    sTemp += "thermometerSmallCircleGreen";
                                else if(z === "yellow")
                                    sTemp += "thermometerSmallCircleYellow";
                                else if(z === "orange")
                                    sTemp += "thermometerSmallCircleOrange";
                                else if(z === "cyan")
                                    sTemp += "thermometerSmallCircleCyan";
                                else if(z === "blue")
                                    sTemp += "thermometerSmallCircleBlue";
                                sTemp += "\"></div>"
                                sTemp += "</div></div>";
                                graphicDpContent += sTemp;
                            }
                            else if(graphicDpContentList[i].dashboardType === "led1") {
                                // small led
                               
                                value = graphicDpContentList[i].locValue;
                                
                                z = -1;
                                for(j=0; j <graphicDpContentList[i].imageSwapper.length; j++)
                                {
                                    if(graphicDpContentList[i].imageSwapper[j].test === ">") {
                                        if(value > graphicDpContentList[i].imageSwapper[j].value) {
                                            z = j;
                                            break;
                                        }
                                    }
                                    else if(graphicDpContentList[i].imageSwapper[j].test === ">=") {
                                        if(value >= graphicDpContentList[i].imageSwapper[j].value) {
                                            z = j;
                                            break;
                                        }
                                    }
                                    else if(graphicDpContentList[i].imageSwapper[j].test === "=") {
                                        if(value === graphicDpContentList[i].imageSwapper[j].value) {
                                            z = j;
                                            break;
                                        }
                                    }
                                    else if(graphicDpContentList[i].imageSwapper[j].test === "<=") {
                                        if(value <= graphicDpContentList[i].imageSwapper[j].value) {
                                            // check if next value lower value
                                            if(j === (graphicDpContentList[i].imageSwapper.length - 1)) {
                                                z = j;
                                                break;
                                            }
                                            else if(value > graphicDpContentList[i].imageSwapper[j + 1].value){
                                                z = j;
                                                break;
                                            }
                                        }
                                    }
                                    else if(graphicDpContentList[i].imageSwapper[j].test === "<") {
                                        if(value < graphicDpContentList[i].imageSwapper[j].value) {
                                            // check if next value lower value
                                            if(j === (graphicDpContentList[i].imageSwapper.length - 1)) {
                                                z = j;
                                                break;
                                            }
                                            else if(value > graphicDpContentList[i].imageSwapper[j + 1].value){
                                                z = j;
                                                break;
                                            }
                                        }
                                    }
                                }
                                borderColor = "black";
                                sTemp += "z-index:6\">";
                                sTemp += '<span id="localValueLed_' + graphicDpContentList[i].displayId + '" class="ledDotMediumOn"';
                                sTemp += ' style="background-Color:' + graphicDpContentList[i].imageSwapper[z].image + ';border-color:' + borderColor + ';';
                                if(graphicDpContentList[i].width !== "")
                                    sTemp += ' width:' + graphicDpContentList[i].width + 'px;height:' + graphicDpContentList[i].width + 'px;';
                                sTemp +=  '"';
                                if(graphicDpContentList[i].label !== "")
                                    sTemp += " title=\"" + graphicDpContentList[i].label + "\"";
                                if((g_sSiteDashboardSelected !== "") && g_bSiteDashboardClickDpPathToDevice) 
                                    sTemp += " class=\"treeviewName\" onclick=\"getPlanningTreeShowDashboard(0,'Device_" + graphicDpContentList[i].deviceId + "','" + graphicDpContentList[i].deviceName + "')\"";
                                sTemp +=  '></span>';
                                sTemp += "</div>";
                                graphicDpContent += sTemp;
                                
                            }
                        }
                        catch {}
                    }
                    if(graphicDpContent !== "") {
                        if(dashboardImageDivElement !== null)
                            dashboardImageDivElement.innerHTML += graphicDpContent;
                    }
                }
            }
        }
        
        // if no input datapoints or 
        if(false) { //(g_sSiteDashboardSelected !== "") {
            //always hide priority
            try {
                z = 4;
                if(bAddDeviceName)
                    z++;
                table = document.getElementById("myTable");
                if(table !== null) {
                    for(i=0; i < table.rows.length; i++)
                    {
                        table.rows[i].cells[z].style.visibility = "hidden";
                    }
                }
            }
            catch {}
        }
        else {
            // hide priority
            g_iDashboardPriorityColumn = 4;
            if(bAddDeviceName)
                g_iDashboardPriorityColumn ++;
        }

        // if charts but no structured dps get rid of bottom chart select div
        if(bAtLeastOneChartWithFieldDropdown) {
            for(i=0; i < chartsfieldList.length; i++)
            {
                element = document.getElementById("datapointfield_" + chartsfieldList[i]);
                if(element !== null)
                    element.style.display = "flex";
            }
        }
        
        //remove navtree document.getElementById("main").innerHTML =  "<div>" + paneContent + "</div>";
        table = document.getElementById("myTable");
        if(table !== null) {
           // tableCreateResizableTable("myTable");  //ffix currently max-width used need to remove max-width
        }
        if(!bUnitsUsed) {
            // remove Units column if no units defined
            try {
                z = 3;
                if(bAddDeviceName)
                    z++;
                table = document.getElementById("myTable");
                if(table !== null) {
                    for(i=0; i < table.rows.length; i++)
                    {
                        table.rows[i].cells[z].style.display = "none";
                    }
                }
            }
            catch {}
        }
        if(bRemoveDeviceName) {
            bRemoveDeviceName = true;
            for(i=0; i <dashboardDpList[i]; i++)
            {
                if(i === 0)
                    shortDeviceName = dashboardDpList[i].deviceName;
                else {
                    if(shortDeviceName !== dashboardDpList[i].deviceName) {
                        bRemoveDeviceName = false;
                        break;
                    }
                }
            }
            if(bRemoveDeviceName) {
                try {
                    table = document.getElementById("myTable");
                    if(table !== null) {
                        for(i=0; i < table.rows.length; i++)
                        {
                            table.rows[i].cells[1].style.display = "none";
                        }
                    }
                }
                catch {}
            }
        }
        if(!g_bAtLeastOneChartUsed) {
            try {
                element = document.getElementById("dashboardPauseButtonDiv");
                if(element !== null) {
                    element.style.display = "none";
                }
                element = document.getElementById("dashboardClearChartsButton");
                if(element !== null) {
                    element.style.display = "none";
                }
                element = document.getElementById("dashboardOptionsMenu");
                if(element !== null) {
                    element.style.display = "none";
                }
                if(g_DashboardImage !== null) {
                    if(g_DashboardImage !== "") {
                        // place table side by side to image
                        element = document.getElementById("brDiv");
                        if(element !== null)
                            element.style.display = "inline-block";
                    }
                }
            }
            catch {}
        }
        if(bAtLeastOneGuageUsed) {
            for(i=0; i < dashboardDpList.length; i++)
            {
                for(j=0; j < dashboardDpList[i].displayElements.length; j++)
                {
                    if(dashboardDpList[i].displayElements[j].dashboardType === "gc")
                        dashboardDpList[i].displayElements[j].dashboardType = "g";
                    if(dashboardDpList[i].displayElements[j].dashboardType === "g") {
                        element = document.getElementById("guageneedle_" + dashboardDpList[i].displayElements[j].displayId);
                        try {
                            if(element !== null) {
                                tempValue = dashboardDpList[i].displayElements[j].locValue;
                                locValue = tempValue;
                                if(typeof tempValue === "number") {
                                    minmax = dashboardDpList[i].displayElements[j].guageObj.guageMax - dashboardDpList[i].displayElements[j].guageObj.guageMin;
                                    if(minmax > 0) {
                                        tempValue = tempValue - dashboardDpList[i].displayElements[j].guageObj.guageMin;
                                        tempValue = tempValue / (dashboardDpList[i].displayElements[j].guageObj.guageMax - dashboardDpList[i].displayElements[j].guageObj.guageMin);
                                        if(tempValue < 0)
                                            tempValue = 0;
                                        else if (tempValue > 1)
                                            tempValue = 1; 
                                        tempValue1 = tempValue;
                                        if(tempValue1 < .01)
                                            tempValue1 = .02;
                                        else if(tempValue1 > .99)
                                            tempValue1 = .99;
                                            
                                        tempValue1 = Math.floor(tempValue1 * 180) + 180;
                                        element.style.transform = 'rotate(' + tempValue1.toString() + 'deg)';
                                        element = document.getElementById("guageHole_" + dashboardDpList[i].displayElements[j].displayId)
                                        if(element !== null) {
                                            //element.textContent = (Math.round(tempValue * 100)).toString();
                                            //element.textContent = locValue;
                                            tempValue2 = locValue;
                                            if(typeof tempValue2 === "string") {
                                                if(!isNaN(tempValue2)) 
                                                    tempValue2 = Number(tempValue2);
                                                    
                                            }
                                            if(typeof tempValue2 === "number") {
                                                    if(Number.isInteger(tempValue2)) {

                                                    }
                                                    else {
                                                        if(dashboardDpList[i].displayElements[j].precision !== -1) {
                                                            tempValue2 = dashboardNumToFixedLength(tempValue2, dashboardDpList[i].displayElements[j].precision);
                                                        }
                                                        else if(g_bDashboardMinMaxDecimalPlaces)
                                                            tempValue2 = dashboardNumToFixedLength(tempValue2, g_iDashboardDecimalPlaces);
                                                    }
                                            }
                                            element.textContent = tempValue2; //locValue; //(Math.round(tempValue * 100)).toString();
                                        }
                                        try {
                                            element = document.getElementById("guageFill_" + dashboardDpList[i].displayElements[j].displayId);
                                            if(element !== null) {
                                                if(dashboardDpList[i].displayElements[j].guageObj.type === 0) {
                                                
                                                    element.style.transform = 'rotate(' + (tempValue / 2).toString() + 'turn)';
                                                    for(v=0; v < dashboardDpList[i].displayElements[j].guageObj.guageColors.length; v++)
                                                    {
                                                        if(dashboardDpList[i].displayElements[j].guageObj.guageColors[v].value === null) {
                                                            element.style.background = dashboardDpList[i].displayElements[j].guageObj.guageColors[v].color;
                                                        }
                                                        else if(v === (dashboardDpList[i].displayElements[j].guageObj.guageColors.length - 1)) {
                                                            element.style.background = dashboardDpList[i].displayElements[j].guageObj.guageColors[v].color;
                                                            break;
                                                        }
                                                        else if(locValue < dashboardDpList[i].displayElements[j].guageObj.guageColors[v].value) {
                                                            element.style.background = dashboardDpList[i].displayElements[j].guageObj.guageColors[v].color;
                                                            break;
                                                        }
                                                    }
                                                }
                                                else if(dashboardDpList[i].displayElements[j].guageObj.type === 1) {
                                                    // type 1: add gradients
                                                    sTemp = "";
                                                    tempValue = 0;
                                                    // set color in middle of range
                                                    for(v=0; v < dashboardDpList[i].displayElements[j].guageObj.guageColors.length; v++)
                                                    {
                                                        if(dashboardDpList[i].displayElements[j].guageObj.guageColors[v].color !== "") {
                                                            if(dashboardDpList[i].displayElements[j].guageObj.guageColors[v].value !== null) {
                                                                if(v==0) {
                                                                    tempValue = dashboardDpList[i].displayElements[j].guageObj.guageColors[v].value;
                                                                    tempValue1 = tempValue - dashboardDpList[i].displayElements[j].guageObj.guageMin;
                                                                    tempValue1 = tempValue1 / 2;
                                                                    tempValue -= tempValue1;
                                                                    if(tempValue > dashboardDpList[i].displayElements[j].guageObj.guageMax)
                                                                        tempValue = dashboardDpList[i].displayElements[j].guageObj.guageMax;
                                                                    if(tempValue < dashboardDpList[i].displayElements[j].guageObj.guageMin)
                                                                        tempValue = dashboardDpList[i].displayElements[j].guageObj.guageMin;
                                                                    dashboardDpList[i].displayElements[j].guageObj.guageColors[v].midValue = tempValue;
                                                                }
                                                                else {
                                                                    tempValue = dashboardDpList[i].displayElements[j].guageObj.guageColors[v - 1].value;
                                                                    tempValue1 = dashboardDpList[i].displayElements[j].guageObj.guageColors[v].value;
                                                                    tempValue1 = tempValue1 - tempValue;
                                                                    tempValue1 = tempValue1 / 2;
                                                                    tempValue += tempValue1;
                                                                    if(tempValue > dashboardDpList[i].displayElements[j].guageObj.guageMax)
                                                                        tempValue = dashboardDpList[i].displayElements[j].guageObj.guageMax;
                                                                    if(tempValue < dashboardDpList[i].displayElements[j].guageObj.guageMin)
                                                                        tempValue = dashboardDpList[i].displayElements[j].guageObj.guageMin;
                                                                    dashboardDpList[i].displayElements[j].guageObj.guageColors[v].midValue = tempValue;
                                                                }
                                                            }
                                                            else {
                                                                tempValue = dashboardDpList[i].displayElements[j].guageObj.guageColors[v - 1].value;
                                                                tempValue1 = dashboardDpList[i].displayElements[j].guageObj.guageMax;
                                                                tempValue1 = tempValue1 - tempValue;
                                                                tempValue1 = tempValue1 / 2;
                                                                tempValue += tempValue1;
                                                                if(tempValue > dashboardDpList[i].displayElements[j].guageObj.guageMax)
                                                                    tempValue = dashboardDpList[i].displayElements[j].guageObj.guageMax;
                                                                if(tempValue < dashboardDpList[i].displayElements[j].guageObj.guageMin)
                                                                    tempValue = dashboardDpList[i].displayElements[j].guageObj.guageMin;
                                                                dashboardDpList[i].displayElements[j].guageObj.guageColors[v].midValue = tempValue; 
                                                                break;
                                                            }
                                                        }
                                                    }
                                                    sTemp = "";
                                                    tempValue = 0;
                                                    for(v=0; v < dashboardDpList[i].displayElements[j].guageObj.guageColors.length; v++)
                                                    {
                                                        if(dashboardDpList[i].displayElements[j].guageObj.guageColors[v].color !== "") {
                                                            if(sTemp !== "")
                                                                sTemp += ", ";
                                                            sTemp +=    dashboardDpList[i].displayElements[j].guageObj.guageColors[v].color;
                                                            //if(tempValue > 0)
                                                            //    sTemp  += " " + tempValue.toString() + "deg";
                                                            if(dashboardDpList[i].displayElements[j].guageObj.guageColors[v].midValue !== null) {
                                                                tempValue = dashboardDpList[i].displayElements[j].guageObj.guageColors[v].midValue;
                                                                if(tempValue !== "") {
                                                                    if(!isNaN(tempValue)) {
                                                                        tempValue = tempValue - dashboardDpList[i].displayElements[j].guageObj.guageMin;
                                                                        tempValue = tempValue / minmax;
                                                                        tempValue = tempValue * 180;
                                                                        if(tempValue > 180)
                                                                            tempValue = 180;
                                                                            if(tempValue > 0)
                                                                                sTemp  += " " + tempValue.toString() + "deg";
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    if(sTemp !== "")
                                                        element.style.backgroundImage = "conic-gradient(from -90deg, " + sTemp + ")";
                                                }
                                                else if(dashboardDpList[i].displayElements[j].guageObj.type === 2) {
                                                    // type 2: add gradients sharp lines
                                                    
                                                    sTemp = "";
                                                    tempValue = 0;
                                                    for(v=0; v < dashboardDpList[i].displayElements[j].guageObj.guageColors.length; v++)
                                                    {
                                                        if(dashboardDpList[i].displayElements[j].guageObj.guageColors[v].color !== "") {
                                                            if(sTemp !== "")
                                                                sTemp += ", ";
                                                            sTemp +=    dashboardDpList[i].displayElements[j].guageObj.guageColors[v].color;
                                                            sTemp  += " " + tempValue.toString() + "turn";
                                                            if(dashboardDpList[i].displayElements[j].guageObj.guageColors[v].value !== null) {
                                                                tempValue = dashboardDpList[i].displayElements[j].guageObj.guageColors[v].value;
                                                                if(tempValue !== "") {
                                                                    if(!isNaN(tempValue)) {
                                                                        tempValue = tempValue - dashboardDpList[i].displayElements[j].guageObj.guageMin;
                                                                        tempValue = tempValue / minmax;
                                                                        tempValue = tempValue * 180;
                                                                        if(tempValue > 180)
                                                                            tempValue = 180;
                                                                        tempValue = tempValue * ( .5 / 180);
                                                                        sTemp  += " " + tempValue.toString() + "turn";
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    if(sTemp !== "")
                                                        element.style.backgroundImage = "conic-gradient(from -90deg, " + sTemp + ")";
                                                }
                                            }
                                        }
                                        catch {}
                                    }
                                }
                            }
                        }
                        catch {}
                    }
                    else if(dashboardDpList[i].displayElements[j].dashboardType === "m") {
                        try {
                            
                            element = document.getElementById("meter_" + dashboardDpList[i].displayElements[j].displayId);
                            if(element != null) {
                                if(dashboardDpList[i].displayElements[j].guageObj.type === 0) { // green, orange, red or green/orange/red
                                    if(dashboardDpList[i].displayElements[j].guageObj.guageColors.length === 1) {
                                        if(dashboardDpList[i].displayElements[j].guageObj.guageColors[0].color !== "") {
                                            if(dashboardDpList[i].displayElements[j].guageObj.guageColors[0].color === "orange") {
                                                element.low = "0";
                                                element.high = "0";
                                                element.optimum = "0";
                                            }
                                            else if(dashboardDpList[i].displayElements[j].guageObj.guageColors[0].color === "red") {
                                                //do nothing
                                                if(dashboardDpList[i].displayElements[j].locValue > 
                                                    (((dashboardDpList[i].displayElements[j].guageObj.guageMax - dashboardDpList[i].displayElements[j].guageObj.guageMin) /2) + dashboardDpList[i].displayElements[j].guageObj.guageMin)) {
                                                    
                                                    element.low = (dashboardDpList[i].displayElements[j].locValue - dashboardDpList[i].displayElements[j].guageObj.guageMin) / 3;
                                                    element.high = (dashboardDpList[i].displayElements[j].locValue - dashboardDpList[i].displayElements[j].guageObj.guageMin) / 2;
                                                    element.optimum = (dashboardDpList[i].displayElements[j].locValue - dashboardDpList[i].displayElements[j].guageObj.guageMin) / 4;
                                                }
                                                else {
                                                    // red
                                                    element.low = (dashboardDpList[i].displayElements[j].guageObj.guageMax - dashboardDpList[i].displayElements[j].guageObj.guageMin) * 0.8;
                                                    element.high = (dashboardDpList[i].displayElements[j].guageObj.guageMax - dashboardDpList[i].displayElements[j].guageObj.guageMin) * 0.9;
                                                    element.optimum = dashboardDpList[i].displayElements[j].guageObj.guageMax;
                                                }
                                            }
                                        }
                                    }
                                    else if(dashboardDpList[i].displayElements[j].guageObj.guageColors.length === 3) {
                                        if(dashboardDpList[i].displayElements[j].guageObj.guageColors[1].value !== null) {
                                            // green/orange/red
                                            if(dashboardDpList[i].displayElements[j].locValue >= dashboardDpList[i].displayElements[j].guageObj.guageColors[1].value) {
                                                // red
                                                element.low = (dashboardDpList[i].displayElements[j].locValue - dashboardDpList[i].displayElements[j].guageObj.guageMin) / 3;
                                                element.high = (dashboardDpList[i].displayElements[j].locValue - dashboardDpList[i].displayElements[j].guageObj.guageMin) / 2;
                                                element.optimum = (dashboardDpList[i].displayElements[j].locValue - dashboardDpList[i].displayElements[j].guageObj.guageMin) / 4;
                                            }
                                            else if(dashboardDpList[i].displayElements[j].guageObj.guageColors[0].value !== null) {
                                                if(dashboardDpList[i].displayElements[j].locValue >= dashboardDpList[i].displayElements[j].guageObj.guageColors[0].value) {
                                                    // orange
                                                    element.low = "0";
                                                    element.high = "0";
                                                    element.optimum = "0";
                                                }
                                                else {
                                                    // green
                                                    element.low = "0";
                                                    element.high = "0";
                                                    element.optimum = dashboardDpList[i].displayElements[j].locValue;
                                                }
                                            }
                                        }
                                    }
                                    
                                }
                                else if(dashboardDpList[i].displayElements[j].guageObj.type === 1) { // red/orange/green
                                    if(dashboardDpList[i].displayElements[j].guageObj.guageColors.length === 3) {
                                        if(dashboardDpList[i].displayElements[j].guageObj.guageColors[1].value !== null) {
                                            if(dashboardDpList[i].displayElements[j].locValue >= dashboardDpList[i].displayElements[j].guageObj.guageColors[1].value) {
                                                // green
                                                element.low = "0";
                                                element.high = "0";
                                                element.optimum = dashboardDpList[i].displayElements[j].locValue;
                                                
                                            }
                                            else if(dashboardDpList[i].displayElements[j].guageObj.guageColors[0].value !== null) {
                                                if(dashboardDpList[i].displayElements[j].locValue >= dashboardDpList[i].displayElements[j].guageObj.guageColors[0].value) {
                                                    // orange
                                                    element.low = "0";
                                                    element.high = "0";
                                                    element.optimum = "0";
                                                }
                                                else {
                                                    // red
                                                    element.low = (dashboardDpList[i].displayElements[j].guageObj.guageMax - dashboardDpList[i].displayElements[j].guageObj.guageMin) * 0.8;
                                                    element.high = (dashboardDpList[i].displayElements[j].guageObj.guageMax - dashboardDpList[i].displayElements[j].guageObj.guageMin) * 0.9;
                                                    element.optimum = dashboardDpList[i].displayElements[j].guageObj.guageMax;
                                                }
                                            }
                                        }
                                    }
                                    
                                }
                                else if(dashboardDpList[i].displayElements[j].guageObj.type === 2) { // red/orange/green/orange/red
                                    if(dashboardDpList[i].displayElements[j].guageObj.guageColors.length === 5) {
                                        if((dashboardDpList[i].displayElements[j].guageObj.guageColors[0].value !== null) && (dashboardDpList[i].displayElements[j].guageObj.guageColors[1].value !== null)
                                            && (dashboardDpList[i].displayElements[j].guageObj.guageColors[2].value !== null) && (dashboardDpList[i].displayElements[j].guageObj.guageColors[3].value !== null)){
                                            if(dashboardDpList[i].displayElements[j].locValue >= dashboardDpList[i].displayElements[j].guageObj.guageColors[3].value) {
                                                // red
                                                element.low = (dashboardDpList[i].displayElements[j].locValue - dashboardDpList[i].displayElements[j].guageObj.guageMin) / 3;
                                                element.high = (dashboardDpList[i].displayElements[j].locValue - dashboardDpList[i].displayElements[j].guageObj.guageMin) / 2;
                                                element.optimum = (dashboardDpList[i].displayElements[j].locValue - dashboardDpList[i].displayElements[j].guageObj.guageMin) / 4;
                                            }
                                            else if(dashboardDpList[i].displayElements[j].locValue >= dashboardDpList[i].displayElements[j].guageObj.guageColors[2].value) {
                                                // orange
                                                element.low = "0";
                                                element.high = "0";
                                                element.optimum = "0";
                                            }
                                            else if(dashboardDpList[i].displayElements[j].locValue >= dashboardDpList[i].displayElements[j].guageObj.guageColors[1].value) {
                                                // green
                                                element.low = "0";
                                                element.high = "0";
                                                element.optimum = dashboardDpList[i].displayElements[j].locValue;
                                            }
                                            else if(dashboardDpList[i].displayElements[j].locValue >= dashboardDpList[i].displayElements[j].guageObj.guageColors[0].value) {
                                                // orange
                                                element.low = "0";
                                                element.high = "0";
                                                element.optimum = "0";
                                            }
                                            else {
                                                // red
                                                element.low = (dashboardDpList[i].displayElements[j].guageObj.guageMax - dashboardDpList[i].displayElements[j].guageObj.guageMin) * 0.8;
                                                element.high = (dashboardDpList[i].displayElements[j].guageObj.guageMax - dashboardDpList[i].displayElements[j].guageObj.guageMin) * 0.9;
                                                element.optimum = dashboardDpList[i].displayElements[j].guageObj.guageMax;
                                            }
                                        }
                                    }
                                    
                                }
                            }
                        }
                        catch {}
                    } 
                    else if(dashboardDpList[i].displayElements[j].dashboardType === "tc") {
                        locValue = dashboardDpList[i].displayElements[j].locValue;
                        // Thermometer
                        if((dashboardDpList[i].displayElements[j].thermometerObj.style === "cf") 
                            || (dashboardDpList[i].displayElements[j].thermometerObj.style === "fc")
                            || (dashboardDpList[i].displayElements[j].thermometerObj.style === "c")) {

                            if(dashboardDpList[i].displayElements[j].thermometerObj.source === "c") {
                                dashboardSetThermometerValue (0, dashboardDpList[i].displayElements[j].thermometerObj.source, locValue,dashboardDpList[i].displayElements[j].thermometerObj.degMin,dashboardDpList[i].displayElements[j].thermometerObj.degMax, dashboardDpList[i].displayElements[j].displayId);
                                element = document.getElementById("thermometer_c_" + dashboardDpList[i].displayElements[j].displayId);
                                if(element !== null) {
                                    sTemp = locValue.toFixed(1) + " &deg;C";
                                    if(dashboardDpList[i].displayElements[j].thermometerObj.style !== "c")
                                        sTemp = "(" + sTemp + ")";
                                    element.innerHTML = sTemp;
                                    
                                }
                            }
                            if((dashboardDpList[i].displayElements[j].thermometerObj.style === "c") && (dashboardDpList[i].displayElements[j].thermometerObj.bAddOtherTemp)) {
                                sTemp = (1.8 * locValue) + 32;
                                element = document.getElementById("thermometer_f_" + dashboardDpList[i].displayElements[j].displayId);
                                if(element !== null) {
                                    element.innerHTML = "(" + sTemp.toFixed(0) + " &deg;F)";
                                }
                            }
                        }
                        if((dashboardDpList[i].displayElements[j].thermometerObj.style === "cf") 
                        || (dashboardDpList[i].displayElements[j].thermometerObj.style === "fc")
                        || (dashboardDpList[i].displayElements[j].thermometerObj.style === "f")) {
                            sTemp = locValue;
                            if(dashboardDpList[i].displayElements[j].thermometerObj.source === "c") {
                                locValue = (1.8 * locValue) + 32;
                                
                            }
                            else 
                                dashboardSetThermometerValue (0, dashboardDpList[i].displayElements[j].thermometerObj.source, locValue,dashboardDpList[i].displayElements[j].thermometerObj.degMin,dashboardDpList[i].displayElements[j].thermometerObj.degMax, dashboardDpList[i].displayElements[j].displayId);
                            element = document.getElementById("thermometer_f_" + dashboardDpList[i].displayElements[j].displayId);
                            if(element !== null) {
                                element.innerHTML = locValue.toFixed(0) + " &deg;F";;
                            }
                            if((dashboardDpList[i].displayElements[j].thermometerObj.style === "f") && (dashboardDpList[i].displayElements[j].thermometerObj.bAddOtherTemp)) {
                                sTemp = (sTemp - 32) / 1.8 //(1.8 * sTemp) + 32;
                                element = document.getElementById("thermometer_c_" + dashboardDpList[i].displayElements[j].displayId);
                                if(element !== null) {
                                    element.innerHTML = "(" + sTemp.toFixed(1) + " &deg;C)";
                                }
                            }
                        }
                    }
                    else if(dashboardDpList[i].displayElements[j].dashboardType === "lc") {
                        locValue = dashboardDpList[i].displayElements[j].locValue;
                        dashboardSetThermometerValue (0, "l", locValue,dashboardDpList[i].displayElements[j].thermometerObj.min,dashboardDpList[i].displayElements[j].thermometerObj.max, dashboardDpList[i].displayElements[j].displayId);
                        element = document.getElementById("lightmeter_" + dashboardDpList[i].displayElements[j].displayId);
                        if(element !== null) {
                            element.innerHTML = locValue.toFixed(0);
                            if(dashboardDpList[i].displayElements[j].units !== "")
                                element.innerHTML += " " +dashboardDpList[i].displayElements[j].units;
                            
                        }
                    }
                }
            }
        }
        if(bAtLeastOneSvgElement) {
            //g_iDashboardInitiCount = 0;
            g_bDashboardSvgInit = true;
            //g_bDashboardUpdateCharts = true;
            //g_bUpdateCharts = true;
            try {
                // ivGetDeviceList(); // IOT get device list later
                g_dashboardTimerId = window.setTimeout("timerHandlerDashboard()", g_dashboardTimerInterval);
            } catch (err) {} 
            
        }
        else {
            g_bDashboardDataLogGetInProgress = false;
            g_bDashboardNeedToInitializeSvg = false;
        }
        for(k=0; k < dashboardDpList.length; k++)
            dashboardDpList[k].updateDpValue = true; //makes sure UI gets updated in case value changed since values last read
        
        showDashboardEnableMenu(true);
        if(bDisableEditCheckbox) {
            element = document.getElementById("editButton");
            if(element !== null) 
                element.disabled = true;
            g_bEditModeEnabled = false;
        }
        dashboardEditButtonProcess(); // only allow edit for provisioned devices
        if(!bAtleastOneWritableDp) {
            //disable edit checkbox
            element = document.getElementById("editButtonDiv");
            if(element !== null)
                element.style.display = "none";
        }
        try {
            // ivGetDeviceList(); // IOT get device list later
            if(g_timerId === 0)
                g_timerId = window.setInterval("timerHandler()", g_iTimerInterval);
        } catch (err) {} 
    }
    catch (err) { 
        element = document.getElementById("planningPaneDetails_Details"); //navtree
            if(element !== null)
                element.innerHTML ="Error Processing Dashboard Data<br><br>" + err.toString();
        //document.getElementById("main").innerHTML =  "Error Processing Dashboard Data<br><br>" + err.toString();}
    }
}
function showDashboardUiBuildWebpageChangeDashboardType(type, index, displayIndex) {
    // if datapoint is a object, but field isn't then need to change dashboardType
    try {
        if(dashboardDpList[index].displayElements[displayIndex].dashboardType === "s0") {
            dashboardDpList[index].displayElements[displayIndex].dashboardType = "r";
        }
        else if(dashboardDpList[index].displayElements[displayIndex].dashboardType === "s1") {
            dashboardDpList[index].displayElements[displayIndex].dashboardType = "n";
        }
    }
    catch {}
    return;
}
function showDashboardUiGetSnvtType(mode, obj, snvtTypeName) {
    // mode: 0=planning View, 1=dashboard view, 2=device log
    try {
		var i, bAtLeastOnemore = false;
		var url = "https://" + location.host + "/iap/dp/types?dpTypeName=" + snvtTypeName;
        obj.view = mode;
		requestGetData(obj, url, showDashboardUiGetSnvtTypeResponse, showDashboardUiGetSnvtTypeResponseFailCallback);
	}
	catch(err) {
	}
}
function showDashboardUiGetSnvtTypeResponse(mode, url, json) {
    try {
        var i, j, z;
		for(i=0; i < json.length; i++)
		{
			z = -1;
			for(j=0; j < g_snvtTypes.length; j++)
			{
				if(g_snvtTypes[j].typeId === json[i].typeId) {
					z = j;
					break;
				}
			}
			if(z === -1) {
				g_snvtTypes.push(JSON.parse(JSON.stringify(json[i])));
			}
		}
        if(mode.view === 0) {
            //planning view
            if(g_sSiteDashboardSelected !== "") 
				showDashboardDeviceDpListResponseForSiteDashboard(0, "", dashboardDpList);
            else
                getPlanningContextDpsListResponseBuildUi(mode);
        }
        else if(mode.view === 1) {
            //planning view
            showDashboardUiBuildWebpage(mode);
        }
        else if(mode.view === 2) {
            //dashboard device log
            _getDeviceDatalogChartResponseGetSnvtTypes(mode);
        }
    }
    catch {}

}
function showDashboardUiGetSnvtTypeResponseFailCallback(mode, url, json) {
    try {
        if(mode.view === 0) {
            //planning view
            getPlanningContextDpsListResponseBuildUi(mode);
        }
        else if(mode.view === 1) {
            //planning view
            showDashboardUiBuildWebpage(mode);
        }
        else if(mode.view === 2) {
            //dashboard device log
            _getDeviceDatalogChartResponseGetSnvtTypes(mode);
        }
    }
    catch {}
}



function showDashboardUiGetAllSnvtType(mode, obj) {
    //mode.view: 4=preload All Snvt Types.
    try {
		var i, bAtLeastOnemore = false;
		var url = "https://" + location.host + "/iap/dp/types?datapointsPresence=true";
        if((mode !== 1) || (mode === 1) && (g_snvtTypes.length === 0)) {
            obj.view = mode;
            if(mode === 35)
                g_bSnvtTypePreLoadInProgress = true;
            requestGetData(obj, url, showDashboardUiGetAllSnvtTypeResponse, showDashboardUiGetSnvtTypeResponseFailCallback);
        }
        else if(mode === 1) {
            showDashboardUiBuildWebpage(mode);
        }
	}
	catch(err) {
	}
}
function showDashboardUiGetAllSnvtTypeResponse(mode, url, json) {
    //mode.view: 4=preload All Snvt Types.
    try {
        if(json.length > 0) {
		    g_snvtTypes = JSON.parse(JSON.stringify(json));
            if(mode.view === 35) {
                g_bSnvtTypePreLoadInProgress = false;
                if(g_oSnvtTypePreLoadNextStep !== null) {
                    if(g_oSnvtTypePreLoadNextStep.type === 0) { // site dashboard
                        getPlanningTreeShowSiteDashboard2(g_oSnvtTypePreLoadNextStep.mode, g_oSnvtTypePreLoadNextStep.bAddImage, 
                            g_oSnvtTypePreLoadNextStep.contextId,g_oSnvtTypePreLoadNextStep.contextPath);
                    }
                    if(g_oSnvtTypePreLoadNextStep.type === 1) { //device dashboard
                        getPlanningTreeShowDashboard2(g_oSnvtTypePreLoadNextStep.bTree, g_oSnvtTypePreLoadNextStep.mode, g_oSnvtTypePreLoadNextStep.contextId, g_oSnvtTypePreLoadNextStep.deviceName);
                    }
                    g_oSnvtTypePreLoadNextStep = null;
                }
                return; // preload Dp SNVT types
            }
            else if(mode.view === 4) {
                getDeviceTypes(25);
                return;
            }

        }
        else if(mode.view === 35)
            return; // preload
        else if(mode.view === 4) {
            getDeviceTypes(25);
            return; // preload Dp SNVT types
        }
        if(mode.view === 0) {
            //planning view
            if(g_sSiteDashboardSelected !== "") {
				showDashboardDeviceDpListResponseForSiteDashboard(0, "", dashboardDpList);
			}
			else
				getPlanningContextDpsListResponseBuildUi(mode);
        }
        else if(mode.view === 1) {
            //planning view
            showDashboardUiBuildWebpage(mode);
        }
    }
    catch {}

}

function getSnvtType(mode, snvtTypeName) {
	// mode: mode.mode, mode.this, mode.index, mode.pathname, mode.displayMode;
	try {
		var i, bAtLeastOnemore = false;
		var url = "https://" + location.host + "/iap/dp/types?dpTypeName=" + snvtTypeName;
		requestGetData(mode, url, getSnvtTypeResponse, getSnvtTypeFailResponse);
		 
	}
	catch(err) {

	}
}
function getSnvtTypeResponse(mode, requestUrlString, json) {
	try {
		
		var i, j, z;
		for(i=0; i < json.length; i++)
		{
			z = -1;
			for(j=0; j < g_snvtTypes.length; j++)
			{
				if(g_snvtTypes[j].typeRef === json[i].typeRef) {
					z = j;
					break;
				}
			}
			if(z === -1) {
				g_snvtTypes.push(JSON.parse(JSON.stringify(json[i])));
			}
		}
		if(mode !== "") { // dropdown
			if(typeof mode === "object") {
				
				getDpPriorityforMenuDpValue(mode);
				//menuDpValue2(mode.mode, mode.this, mode.index, mode.pathname);
				
			}
		}
	}
	catch(err) {

	}
	
}






	
function showDashboardBuildUi() {
    try {

    }
    catch {}
}
function sliderChanged(n, index, displayElementIndex, displayId, pathname) {
    
    var url;
    var i,value = 0, state, value1, element,obj, objs, bContinue;
    var currentTime;
    var priority = document.getElementById("priority_" + displayId)

    try {
        if((g_iMainDisplayMode !== DISPLAYMODE_DASHBOARD) && (g_iMainDisplayMode !== DISPLAYMODE_PLANNING))
            return;
        value = n.value;
        if(value === null)
            return;
        if (value === "")
            return;
        objs = dashboardDpList;
        bContinue = false;
        element = document.getElementById("localValue_" + displayId);
        if(element !== null)
            element.innerHTML = value;
        value = Number(value);
        if(objs[index].displayElements[displayElementIndex].field !== "") {
            if(objs[index].displayElements[displayElementIndex].bNumber)
                value = Number(value);
            value = changeFieldValue(objs[index].locValue, objs[index].displayElements[displayElementIndex].field, value);
            if(value.valid) 
                value = JSON.stringify(value.data);
            else  {
                showAlertDialog(0,"Can't process input data");
                return;
            }
        }
        for(i=0; i < objs.length; i++)
        {  // find datapoint
            if(objs[index].programmaticPathname === pathname) {
                var value1 = objs[index].value;
                    
                    // add feedback
                objs[index].feedbackDelay = true;
                currentTime = new Date().getTime();
                objs[index].feedbackDelayTimeout = currentTime + g_iFeedbackDelayTime; // ms  10000 = 10 s
                //if(objs[index].bStructure)
                    //objs[index].feedbackDelayOldValue = JSON.parse(JSON.stringify(objs[index].locValue));
                    objs[index].feedbackDelayOldValue = JSON.parse(JSON.stringify(objs[index].locValue));
                //else 
                //    objs[index].feedbackDelayOldValue = objs[index].locValue;
                objs[index].valueStr = value;
                                // check if using field or full datapoint value
                if(objs[index].bStructure)
                    objs[index].value = JSON.parse(JSON.stringify(value));
                else
                    objs[index].value = value;
                //  fixxxxxx  Determine preset value
                z = index;
                break;
            }
            index ++;
            if(index >= objs.length)
                index = 0;
        }
        if(z !== -1) {
            if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
                if(priority !== null)
                    priority = priority.value;
            }
            else if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING) {
                //ffix add code 
            }
            
            url = "/iap/devs/*+name=="; //iot
            url += objs[z].urlPath.replace(/ /g,"%20").replace(/:/g,"%3A").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
            if(priority !== null)
                url += "/overrides/" + priority;
            url += "/localization/value";
            //objs[z].updateDpValue = true; // sync up value, localValue and Preset
            objs[z].updateDpValue = true; // sync up value, localValue and Preset on next read
            writeDpValue(1,url,value, null, writeFailCallback);
            
        }
    }
    catch {}
}
function sliderSwitchClicked(n, displayId, index, displayElementIndex) {
    try {
        var url;
        var value = 0, state, value1, element;
        var currentTime;
        var priority = document.getElementById("priority_" + displayId)
        if(priority !== null)
            priority = priority.value;
        //alert(n.id + ", " + path + ", " + index); //remove
        if(dashboardDpList[index].displayElements[displayElementIndex].field !== "")
            return;
        element = document.getElementById("localValueSpan_" + displayId);
        if(element === null)
            return;
        element.style.removeProperty('background-Color');
        color = dashboardDpList[index].displayElements[displayElementIndex].color;
        backgroundColor = dashboardDpList[index].displayElements[displayElementIndex].backgroundColor;
        if(dashboardDpList[index].displayElements[displayElementIndex].dashboardType === "s2") {
            if(dashboardDpList[index].displayElements[displayElementIndex].displayId === displayId) {
                if(dashboardDpList[index].displayElements[displayElementIndex].bBoolean && !dashboardDpList[index].displayElements[displayElementIndex].bNumber) {
                    writeDpValueSaveCurrentValue(index); // write to .saved
                    dashboardDpList[index].feedbackDelay = true;
				    currentTime = new Date().getTime();
				    dashboardDpList[index].feedbackDelayTimeout = currentTime + g_iFeedbackDelayTime; // ms  10000 = 10 s
				    dashboardDpList[index].feedbackDelayOldValue = dashboardDpList[index].displayElements[displayElementIndex].locValue;
                    if(document.getElementById(n.id).checked)
                        value = true;
                    else 
                        value = false;
                    dashboardDpList[index].displayElements[displayElementIndex].locValueStr = value;
								// check if using field or full datapoint value
                    if(dashboardDpList[index].displayElements[displayElementIndex].field === "")
                        dashboardDpList[index].value = value;
                    else {
                        // need field support
                    }
                    if((typeof dashboardDpList[index].value) === "number")
                        dashboardDpList[index].locValue = Number(value);
                    else
                        dashboardDpList[index].locValue = JSON.parse(value);
                    
                    if(value) {
                        if(color !== ""){
                            document.getElementById("localValueSpan_" + displayId).style.backgroundColor = color;
                        }
                        document.getElementById("localValueSwitch_" + displayId).checked = true;
                    }
                    else { 
                        
                        if(backgroundColor !== ""){
                            document.getElementById("localValueSpan_" + displayId).style.backgroundColor = backgroundColor;
                        }
                        else
                            document.getElementById("localValueSpan_" + displayId).style.backgroundColor = g_sSliderOffBackgroundColor;
                        document.getElementById("localValueSwitch_" + displayId).checked = false;
                    }
                    
                    dashboardDpList[index].value = "";
                    dashboardDpList[index].valueStr = "";
                    dashboardDpList[index].presetValue = "";
                    url = "https://" + location.host + "/iap/devs/*+name==";
                    url += dashboardDpList[index].urlPath.replace(/ /g,"%20").replace(/:/g,"%3A").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
                    if(priority !== null)
                        url += "/overrides/" + priority;
                    url += "/localization/value"; 
                    writeDpValue(1,url,value, null, writeFailCallback);
                    if((g_iMainDisplayMode === DISPLAYMODE_PLANNING) || (g_iMainDisplayMode === DISPLAYMODE_DASHBOARD)) {
                        dashboardProcessWriteDpDataUpdateUi(index, dashboardDpList[index].dpQualifier);
                    }
                }
                else  {
                    writeDpValueSaveCurrentValue(index); // write to .saved
                    dashboardDpList[index].feedbackDelay = true;
                    currentTime = new Date().getTime();
                    dashboardDpList[index].feedbackDelayTimeout = currentTime + g_iFeedbackDelayTime; // ms  10000 = 10 s
                    dashboardDpList[index].feedbackDelayOldValue = dashboardDpList[index].locValue;
                    value = 0;
                    document.getElementById("localValueSpan_" + displayId).style.removeProperty('background-Color');
                    if(document.getElementById(n.id).checked)
                        value = 1;
                    
                    if(value !== 0) {
                        if(color !== ""){
                            document.getElementById("localValueSpan_" + displayId).style.backgroundColor = color;
                        }
                        document.getElementById("localValueSwitch_" + displayId).checked = true;
                    }
                    else { 
                        
                        if(backgroundColor !== ""){
                            document.getElementById("localValueSpan_" + displayId).style.backgroundColor = backgroundColor;
                        }
                        else
                            document.getElementById("localValueSpan_" + displayId).style.backgroundColor = g_sSliderOffBackgroundColor;
                        document.getElementById("localValueSwitch_" + displayId).checked = false;
                    }
                    
                    dashboardDpList[index].locValue = value;
                    dashboardDpList[index].value = "";
                    dashboardDpList[index].valueStr = "";
                    dashboardDpList[index].presetValue = "";
                    dashboardDpList[index].locValueStr = value;
                    url = "https://" + location.host + "/iap/devs/*+name==";
                    url += dashboardDpList[index].urlPath.replace(/ /g,"%20").replace(/:/g,"%3A").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
                    if(priority !== null)
                        url += "/overrides/" + priority;
                    url += "/localization/value"; 
                    writeDpValue(1,url,value, null, writeFailCallback);
                    if((g_iMainDisplayMode === DISPLAYMODE_PLANNING) || (g_iMainDisplayMode === DISPLAYMODE_DASHBOARD)) {
                        dashboardProcessWriteDpDataUpdateUi(index, dashboardDpList[index].dpQualifier);
                    }
                }

            }
            
        }
        else if(dashboardDpList[index].displayElements[displayElementIndex].dashboardType === "s3") {
            // snvt switch state, use old value
            if(dashboardDpList[index].displayElements[displayElementIndex].displayId === displayId) {
                dashboardDpList[index].feedbackDelay = true;
                currentTime = new Date().getTime();
                dashboardDpList[index].feedbackDelayTimeout = currentTime + g_iFeedbackDelayTime; // ms  10000 = 10 s
                dashboardDpList[index].feedbackDelayOldValue = dashboardDpList[index].locValue;
                writeDpValueSaveCurrentValue(index); // write to .saved    
                state  = 0;
                
                if(document.getElementById(n.id).checked)
                    state = 1;
                if(typeof dashboardDpList[index].locValue.value === "undefined") {
                    element = document.getElementById("localvalue_" + dashboardDpList[index].displayElements[displayElementIndex].displayId);
                    if(element === null)
                        return;
                    value = element.value;
                    if(value.indexOf(".") !== -1) {
                        showAlertDialog(0,"Invalid value (only integer values of 0-255 supported): " + value);
                        return;
                    }
                    value1 = Number(value);
                    if(isNaN(value1)) {
                        showAlertDialog(0,"Invalid value (only only integer values of 0-255 supported): " + value);
                        return;
                    }
                    value = value1;
                }
                else
                    value = dashboardDpList[index].locValue.value;
                
                
               
                if ((value < 0) || (value > 255))   {
                    showAlertDialog(0,"Invalid value (only only integer values of 0-255 supported): " + value);
                    return;
                }
                value = {"value": value, "state": state};
                if(state === 1) {
                    if(color !== ""){
                        document.getElementById("localValueSpan_" + displayId).style.backgroundColor = color;
                    }
                    document.getElementById("localValueSwitch_" + displayId).checked = true;
                }
                else { 
                    
                    if(backgroundColor !== ""){
                        document.getElementById("localValueSpan_" + displayId).style.backgroundColor = backgroundColor;
                    }
                    
                    document.getElementById("localValueSwitch_" + displayId).checked = false;
                }
                dashboardDpList[index].locValue = value;
                dashboardDpList[index].value = "";
                dashboardDpList[index].valueStr = "";
                dashboardDpList[index].presetValue = "";
                value = JSON.stringify(value);
                dashboardDpList[index].locValueStr = value;
                url = "https://" + location.host + "/iap/devs/*+name==";
                url += dashboardDpList[index].urlPath.replace(/ /g,"%20").replace(/:/g,"%3A").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
                if(priority !== null)
                    url += "/overrides/" + priority;
                url += "/localization/value"; 
                writeDpValue(1,url,value, null, writeFailCallback);
                if((g_iMainDisplayMode === DISPLAYMODE_PLANNING) || (g_iMainDisplayMode === DISPLAYMODE_DASHBOARD)) {
					dashboardProcessWriteDpDataUpdateUi(index, dashboardDpList[index].dpQualifier);
				}
            }
        }
        else if(dashboardDpList[index].displayElements[displayElementIndex].dashboardType === "s4") {
            // snvt_switch state only
            if(dashboardDpList[index].displayElements[displayElementIndex].displayId === displayId) {
                writeDpValueSaveCurrentValue(index); // write to .saved   
                dashboardDpList[index].feedbackDelay = true;
                currentTime = new Date().getTime();
                dashboardDpList[index].feedbackDelayTimeout = currentTime + g_iFeedbackDelayTime; // ms  10000 = 10 s
                dashboardDpList[index].feedbackDelayOldValue = dashboardDpList[index].locValue; 
                state = 0;
                if(document.getElementById(n.id).checked) {
                    value = {"value": 100, "state": 1};
                    state = 1;
                }
                else
                    value = {"value": 0, "state": 0};
                dashboardDpList[index].locValue = value;
                dashboardDpList[index].value = "";
                dashboardDpList[index].valueStr = "";
                dashboardDpList[index].presetValue = "";
                if(state === 1) {
                    if(color !== ""){
                        document.getElementById("localValueSpan_" + displayId).style.backgroundColor = color;
                    }
                    document.getElementById("localValueSwitch_" + displayId).checked = true;
                }
                else { 
                    
                    if(backgroundColor !== ""){
                        document.getElementById("localValueSpan_" + displayId).style.backgroundColor = backgroundColor;
                    }
                    
                    document.getElementById("localValueSwitch_" + displayId).checked = false;
                }

                value = JSON.stringify(value);
                dashboardDpList[index].locValueStr = value;
                url = "https://" + location.host + "/iap/devs/*+name==";
                url += dashboardDpList[index].urlPath.replace(/ /g,"%20").replace(/:/g,"%3A").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
                if(priority !== null)
                    url += "/overrides/" + priority;
                else
                    url += "/overrides/17";
                url += "/localization/value"; 
                writeDpValue(1,url,value, null, writeFailCallback);
                if((g_iMainDisplayMode === DISPLAYMODE_PLANNING) || (g_iMainDisplayMode === DISPLAYMODE_DASHBOARD)) {
					dashboardProcessWriteDpDataUpdateUi(index, dashboardDpList[index].dpQualifier);
				}
            }
        }
    }
    catch {}
    

}
function pushButtonClicked(n, displayId, index, displayElementIndex) {
    try {
        var url;
        var value = 0, state, value1, element;
        var element1, element2;
        var currentTime;
        var sColor, color,backgroundColor,borderColor;
        var priority = document.getElementById("priority_" + displayId)
        if(priority !== null)
            priority = priority.value;
        //alert(n.id + ", " + path + ", " + index); //remove
        if(!g_bEditModeEnabled)
            return;
        if(dashboardDpList[index].displayElements[displayElementIndex].field !== "")
            return;
        if(dashboardDpList[index].displayElements[displayElementIndex].dashboardType === "pb") {
            if(dashboardDpList[index].displayElements[displayElementIndex].displayId === displayId) {
                element = document.getElementById(n.id);
                element1 = document.getElementById("localValuePushbuttonInner_" + dashboardDpList[index].displayElements[displayElementIndex].displayId);
                if((element !== null) || (element1 !== null)) {
                    value = element.dataset.value;
                    if(typeof value === "string") {
                        if(value === "")
                            value = null;
                    }
                    else
                        value = null;
                    if(value !== null) {
                        if(dashboardDpList[index].displayElements[displayElementIndex].bBoolean && !dashboardDpList[index].displayElements[displayElementIndex].bNumber) {
                            writeDpValueSaveCurrentValue(index); // write to .saved
                            dashboardDpList[index].feedbackDelay = true;
                            currentTime = new Date().getTime();
                            dashboardDpList[index].feedbackDelayTimeout = currentTime + g_iFeedbackDelayTime; // ms  10000 = 10 s
                            dashboardDpList[index].feedbackDelayOldValue = dashboardDpList[index].displayElements[displayElementIndex].locValue;
                            sColor = document.getElementById(n.id).style.backgroundColor;
                            showAlertDialog(0,"TBD - sColor = " + sColor);
                            return;

                            if(document.getElementById(n.id).checked)
                                value = true;
                            else 
                                value = false;
                            dashboardDpList[index].displayElements[displayElementIndex].locValueStr = value;
                                        // check if using field or full datapoint value
                            if(dashboardDpList[index].displayElements[displayElementIndex].field === "")
                                dashboardDpList[index].value = value;
                            else {
                                // need field support
                            }
                            if((typeof dashboardDpList[index].value) === "number")
                                dashboardDpList[index].locValue = Number(value);
                            else
                                dashboardDpList[index].locValue = JSON.parse(value);
                            
                            backgroundColor = dashboardDpList[index].displayElements[displayElementIndex].backgroundColor;
                            if(value) {
                                if(backgroundColor !== ""){
                                    document.getElementById("localValueSpan_" + displayId).style.backgroundColor = backgroundColor;
                                }
                                document.getElementById("localValueSwitch_" + displayId).checked = true;
                            }
                            else { 
                                
                                if(backgroundColor !== ""){
                                    document.getElementById("localValueSpan_" + displayId).style.backgroundColor = g_sSliderOffBackgroundColor;
                                }
                                document.getElementById("localValueSwitch_" + displayId).checked = false;
                            }
                            dashboardDpList[index].value = "";
                            dashboardDpList[index].valueStr = "";
                            dashboardDpList[index].presetValue = "";
                            url = "https://" + location.host + "/iap/devs/*+name==";
                            url += dashboardDpList[index].urlPath.replace(/ /g,"%20").replace(/:/g,"%3A").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
                            if(priority !== null)
                                url += "/overrides/" + priority;
                            url += "/localization/value"; 
                            writeDpValue(1,url,value, null, writeFailCallback);
                            if((g_iMainDisplayMode === DISPLAYMODE_PLANNING) || (g_iMainDisplayMode === DISPLAYMODE_DASHBOARD)) {
                                dashboardProcessWriteDpDataUpdateUi(index, dashboardDpList[index].dpQualifier);
                            }
                        }
                        else  {
                            writeDpValueSaveCurrentValue(index); // write to .saved
                            dashboardDpList[index].feedbackDelay = true;
                            currentTime = new Date().getTime();
                            dashboardDpList[index].feedbackDelayTimeout = currentTime + g_iFeedbackDelayTime; // ms  10000 = 10 s
                            dashboardDpList[index].feedbackDelayOldValue = dashboardDpList[index].locValue;
                            color = dashboardDpList[index].displayElements[displayElementIndex].color;
                            backgroundColor = dashboardDpList[index].displayElements[displayElementIndex].backgroundColor;
                            
                            
                            if(value !== "0") {
                                value = 0;
                                element.dataset.value = 0;
                                if(backgroundColor !== ""){
                                    element.style.backgroundColor = backgroundColor;
                                    element1.style.backgroundColor = backgroundColor;
                                }
                                else if(g_sPushbuttonOffBackgroundColor !== "") {
                                    element.style.backgroundColor = g_sPushbuttonOffBackgroundColor;
                                    element1.style.backgroundColor = g_sPushbuttonOffBackgroundColor;
                                }
                                
                            }
                            else { 
                                value = 1;
                                element.dataset.value = 1;
                                if(color !== ""){
                                    element.style.backgroundColor = color;
                                    element1.style.backgroundColor = color;
                                }
                                else if(g_sPushbuttonOnBackgroundColor !== "") {
                                    element.style.backgroundColor = g_sPushbuttonOnBackgroundColor;
                                    element1.style.backgroundColor = g_sPushbuttonOnBackgroundColor;
                                }
                               
                            }
                            if(!dashboardDpList[index].bNumber) {
                                if(dashboardDpList[index].bBoolean) {
                                    if(value === 1)
                                        value = true;
                                    else
                                        value = false;
                                }
                            }
                            dashboardDpList[index].locValue = value;
                            dashboardDpList[index].value = "";
                            dashboardDpList[index].valueStr = "";
                            dashboardDpList[index].presetValue = "";
                            dashboardDpList[index].locValueStr = value;
                            url = "https://" + location.host + "/iap/devs/*+name==";
                            url += dashboardDpList[index].urlPath.replace(/ /g,"%20").replace(/:/g,"%3A").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
                            if(priority !== null)
                                url += "/overrides/" + priority;
                            else
                                url += "/overrides/17";
                            url += "/localization/value"; 
                            
                            writeDpValue(1,url,value, null, writeFailCallback);
                            if((g_iMainDisplayMode === DISPLAYMODE_PLANNING) || (g_iMainDisplayMode === DISPLAYMODE_DASHBOARD)) {
                                dashboardProcessWriteDpDataUpdateUi(index, dashboardDpList[index].dpQualifier);
                            }
                        }
                    }
                }

            }
            
        }
        
    }
    catch {}
    

}
function initializeSvgDashboard() {
    try {
        var i, j;
        var fValue, fValue1;
        var value;
        var chartIndex;
        var type;
        var obj;
        g_bDashboardNeedToInitializeSvg = false;
        for(i=0; i < dashboardDpList.length; i ++)
        {
            for(j=0; j < dashboardDpList[i].displayElements.length; j ++)
            {
                try {
                    type = dashboardDpList[i].displayElements[j].dashboardType; 
                    if(type !== "n") {
                        if(typeof dashboardDpList[i].displayElements[j].chartIndex !== "undefined") {
                            chartIndex = dashboardDpList[i].displayElements[j].chartIndex;
                            if(chartIndex !== null) {
                                if(chartIndex !== -1) {
                                    ivInitializeChart1(g_bDashboardSupportLogData, "chartSvg_" + g_dashboardChartList[chartIndex].displayId, g_dashboardChartList[chartIndex].minValue, g_dashboardChartList[chartIndex].maxValue, null, null, g_chartTextColor, null, g_dashboardChartList[chartIndex].chartLabels);
                                    dashboardMouseEventsAddToChart("chartSvg_" + g_dashboardChartList[chartIndex].displayId, "chartParentDiv_" + g_dashboardChartList[chartIndex].pathname, chartIndex);
                                    dashboardUpdateCharts(chartIndex, dashboardDpList[i].locValue, null);
                                }
                            }

                        }
                    /* no longer use svg 
                        if ((type === "t") || (type === "l"))  {
                            //field === ""
                            obj = dashboardDpList[i].displayElements[j];
                            ivInitializeThermometer(0, obj.displayId, i, obj.locValue, obj.min, obj.max, obj.unit)
                        }
                        */
                    }
                }
                catch {}
            }
        }
    }
    catch {}
}
function checkDashboardChartListRemoveOldEntries(index, currentTimeMs) {
    var removeCount = 0, startTimestamp;
    var i;
    var bEntryRemoved = false;
    try {
        if(index < g_dashboardChartList.length) {
            if(g_idashboardChartMaxNumberOfEntries !== 0) { // 0=unlimited
                
                removeCount = g_dashboardChartList[index].data.length - g_idashboardChartMaxNumberOfEntries;
                if(removeCount > 0) {
                    bEntryRemoved = true;
                    for(i=0; i < removeCount; i++)
                    {
                        g_dashboardChartList[index].data.shift();
                        if(g_dashboardChartList[index].bStructure) 
                            g_dashboardChartList[index].datalogData.shift();
                    }
                }
            }
            else if(g_iDashboardChartMaxDuration !== 0) {
                startTimestamp = currentTimeMs - g_iDashboardChartMaxDuration; 
                for(i=0; i < g_dashboardChartList[index].data.length; i++)
                {
                    if(g_dashboardChartList[index].data[i].timestamp < startTimestamp) {
                        g_dashboardChartList[index].data.shift();
                        if(g_dashboardChartList[index].bStructure) 
                            g_dashboardChartList[index].datalogData.shift();
                        bEntryRemoved = true;
                    }
                    else
                        break;
                }
            }
        }
    }
    catch {
        bEntryRemoved = true; // not sure what problem is so calculate new min max
    }
    try {
        if(bEntryRemoved) {
            if(g_dashboardChartList[index].data.length > 0) {
                g_dashboardChartList[index].startTimestamp = g_dashboardChartList[index].data[0].timestamp; //time in milli seconds
                g_dashboardChartList[index].endTimestamp = g_dashboardChartList[index].data[g_dashboardChartList[index].length - 1].timestamp; //time in milli seconds
            }
        }
    }
    catch {}
    g_dashboardChartList[index].dataCurrentEntries = g_dashboardChartList[index].data.length;
    g_dashboardChartList[index].endPtr = g_dashboardChartList[index].data.length - 1;
    return bEntryRemoved;
}
function clearDashboardCharts() {
    var element = document.getElementById("warningDiv");
    var element1 = document.getElementById("warningOverlayDiv");
	var sTemp = "<br>Clear Chart data";
	try {
		if((element === null) || (element1 === null))
			return;
		menuOverlayDivShow(7, null);
		sTemp += "<br><br><br><br><div style=\"width:100%;text-align:right\"><button class=\"warningDivShowButton\" onclick=\"clearDashboardCharts1()\">OK</button>";
        sTemp += "<button class=\"warningDivShowButton\" onclick=\"showAlertDialogHide()\">Cancel</button>";
        sTemp += "</div>";
		element.innerHTML = sTemp; 

	}
	catch {}

}
function clearDashboardCharts1() {
    var i, value, timestampMs;
    var d = new Date();
    var ms = d.getTime();
    // remove datalog data
    
    try {
        showAlertDialogHide();
        for(i=0; i < g_dashboardChartList.length; i ++)
        {
            _clearDashboardChart(0, i);
        }
    }
    catch {}
}

function createChartObject(index, displayElementIndex, displayId, pathname, field, value, min, max, hasDynmaicRange, linecolor, chartLabels) {
    //g_dashboardChartListIndex: null=initial creatation, otherwise replace existing.
    try {
        var fvalue, fvalue1, value1;
        var i, j, z;
        var chart = {}, minmaxObj, obj;
        var d;
        var polygoncolor;
        var type;
        var iDetermineMinMax = -1;
        if(index >= dashboardDpList.length)
            return;
        if(displayElementIndex >= dashboardDpList[index].displayElements.length)
            return;
        if(dashboardDpList[index].displayElements[displayElementIndex].displayId !== displayId)
            return;
        chart.dpIndex = index;
        chart.displayElementIndex = displayElementIndex; 
        chart.paused = false;
        chart.startPtr = 0;
        chart.endPtr = 0;
        chart.pathname = pathname;
        chart.dashboardDpIndex = index;
        chart.displayId = displayId;
        chart.displayId1 = "chartSvg_" + displayId; // used for mouse
        chart.data = [];
        chart.datalogData = [];
        chart.dataCurrentEntries = 1; //iottest
        chart.hasNegativeNumbers = false; 
        chart.bMinMaxEqual = true;
        chart.iDynamicRangeCount = ivChartTotalEntries + 2;
        if(g_bDashboardSupportLogData)
            chart.iDynamicRangeCount = 2;

        chart.creatChartLine = true;
        chart.lineName = "line1"
        chart.color = "blue";
        chart.bStructure = false;
        chart.bEnum = false;
        chart.bString = false;
        chart.enums = [];
        chart.strings = [];
        chart.snvtType = null;
        chart.field = "";
        chart.fieldPath = ""; // not sure this is needed

       
        
        /*
        type = dashboardDpList[index].dashboardType;
        if (type === "t")
            chart.color = "darkred";
        else if (type === "l")
            chart.color = "green";
        */           
        chart.show = true;
        chart.chartLabels = "both";

        chart.bPolygon = !g_bDashboardChartDynamicRange;
        chart.startTimestamp = null; //time in milli seconds
        chart.endTimestamp = null; //time in milli seconds
        if(typeof dashboardDpList[index].snvtType !== "undefined") {
            if(dashboardDpList[index].snvtType !== null) {
                snvtType = dashboardDpList[index].snvtType;
                chart.snvtType = snvtType;
            }
        }
        if(g_bDashboardSupportLogData) {
            bDetermineMinMax = true;
            if(typeof dashboardDpList[index].datalogData !== "undefined") {
                if(dashboardDpList[index].datalogData.length > 0) {
                    //chart.data = JSON.parse(JSON.stringify(dashboardDpList[index].datalogData));
                    if(field === "") {
                        chart.data = JSON.parse(JSON.stringify(dashboardDpList[index].datalogData));
                        // check if need to convert celsius to Fahrenheit or vice versa
                        try {
                            if(dashboardDpList[index].displayElements[displayElementIndex].custom !== null) {
                                if(dashboardDpList[index].displayElements[displayElementIndex].custom.thermometerObj !== null) {
                                    if(dashboardDpList[index].displayElements[displayElementIndex].custom.thermometerObj.style ===  "cf") {
                                        for(i=0; i < chart.data.length; i++)
                                        {
                                            chart.data[i].origValue = chart.data[i].value;
                                            chart.data[i].value = Number( ((1.8 * chart.data[i].value) + 32).toFixed(0));
                                        }
                                        if(chart.data.length > 0)
                                            value = chart.data[chart.data.length - 1].value;
                                    }
                                    else if(dashboardDpList[index].displayElements[displayElementIndex].custom.thermometerObj.style ===  "fc") {
                                        for(i=0; i < chart.data.length; i++)
                                        {
                                            chart.data[i].origValue = chart.data[i].value;
                                            chart.data[i].value = Number(( (chart.data[i].value - 32) / 1.8).toFixed(1));
                                        }
                                        if(chart.data.length > 0)
                                            value = chart.data[chart.data.length - 1].value;
                                    }
                                }
                            }
                        }
                        catch {}
                    }
                    else {
                        chart.datalogData = JSON.parse(JSON.stringify(dashboardDpList[index].datalogData));
                        chart.field = field;
                        for(i=0; i < dashboardDpList[index].datalogData.length; i++)
                        {
                            obj = {};
                            obj = JSON.parse(JSON.stringify(dashboardDpList[index].datalogData[i]));
                            value1 = readFieldValue(obj.value, field);
                            if(value1.valid) 
                                obj.value = value1.data;
                            chart.data.push(obj);
                        }
                    }
                    if(!chart.bString && !chart.bEnum) {
                        // check if data is string or null
                        if(typeof dashboardDpList[index].snvtType !== "undefined") {
                            if(snvtType !== null) {
                                if(field !== "") {
                                    snvtType = readSnvtTypeFieldValue(snvtType, field);
                                    if(snvtType.valid) {
                                        snvtType = snvtType.data;
                                        if(snvtType.type === "enum") {
                                            chart.bEnum = true;
                                            chart.enums = JSON.parse(JSON.stringify(snvtType.enum)); // enum[0].id and enum[0].value
                                        }
                                        else if(snvtType.type === "string") {
                                            chart.bString = true;
                                            chart.strings = [];
                                        }
                                    }
                                }
                                else {
                                    if(snvtType.valueType === "ENUM") {
                                        chart.bEnum = true;
                                        chart.enums = JSON.parse(JSON.stringify(snvtType.typeJson.enum)); // enum[0].id and enum[0].value
                                    }
                                    else if(snvtType.valueType === "STRING") {
                                        chart.bString = true;
                                        chart.strings = [];
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if(dashboardDpList[index].displayElements[displayElementIndex].bStructure) {
                chart.bStructure = true;
                chart.field = dashboardDpList[index].displayElements[displayElementIndex].field;
            }
            if(value !== null) {
                obj = {};
                obj.value = value;
                
                obj.presetValue = "";
                
                d = new Date();
                obj.timestamp = d.getTime();
                if(dashboardDpList[index].displayElements[displayElementIndex].bStructure) {
                    chart.datalogData.push(JSON.parse(JSON.stringify(obj)));
                }
                if(chart.bStructure && chart.field !== "") {
                    value1 = readFieldValue(value, field);
                    if(value1.valid)
                        value = value1.data;
                }
                obj.value = value;
                chart.data.push(JSON.parse(JSON.stringify(obj)));
                
                if(chart.data.length === 1) {
                    if(!chart.bString && !chart.bEnum) {
                        // check if data is string or null
                        if(typeof dashboardDpList[index].snvtType !== "undefined") {
                            if(dashboardDpList[index].snvtType !== null) {
                                snvtType = dashboardDpList[index].snvtType;
                                if(snvtType !== null) {
                                    if(field !== "") {
                                        snvtType = readSnvtTypeFieldValue(snvtType, field);
                                        if(snvtType.valid) {
                                            snvtType = snvtType.data;
                                            if(snvtType.type === "enum") {
                                                chart.bEnum = true;
                                                chart.enums = JSON.parse(JSON.stringify(snvtType.enum)); // enum[0].id and enum[0].value
                                            }
                                            else if(snvtType.type === "string") {
                                                chart.bString = true;
                                                chart.strings = [];
                                            }
                                        }
                                    }
                                    else {
                                        if(snvtType.valueType === "ENUM") {
                                            chart.bEnum = true;
                                            chart.enums = JSON.parse(JSON.stringify(snvtType.typeJson.enum)); // enum[0].id and enum[0].value
                                        }
                                        else if(snvtType.valueType === "STRING") {
                                            chart.bString = true;
                                            chart.strings = [];
                                        }
                                    }
                                }
                                
                            }
                        }
                    }
                }
            }
            
            if(chart.bEnum || chart.bString) {
                chartLabels = "x";
                // convert strings and enums
                for(i=0; i < chart.data.length; i++)
                {
                    if(chart.bEnum) {
                        value = chart.data[i].value;
                        z = -1;
                        for(j=0; j < chart.enums.length; j++) {
                            if(value === chart.enums[j].id) {
                                z = j;
                                break;
                            }
                        }
                        chart.data[i].str = value;
                        if(z !== -1) {
                            value = chart.enums[j].value;
                            chart.data[i].value = value;
                        }
                        else {
                            obj = {};
                            obj.str = value;
                            value1 = 1;
                            if(typeof value === "number") {
                                // check if value matches other values
                                // pick new value to show
                                value1 = value;
                                while(bContinue)
                                {
                                    bContinue = false;
                                    for(j=0; j < chart.enums.length; j++)
                                    {
                                        if(value1 === chart.enums[j].value) {
                                            value1 ++;
                                            bContinue = true;
                                        }
                                    }
                                }
                            }
                            // check if value matches other values
                            obj.value = value1;
                            chart.enums.push(obj);
                            value = obj.value;
                            chart.data[i].value = value;
                        }
                    }
                    else if(chart.bString) {
                        value = chart.data[i].value;
                        z = -1;
                        for(j=0; j < chart.strings.length; j++) {
                            if(value === chart.strings[j].str) {
                                z = j;
                                break;
                            }
                        }
                        chart.data[i].str = value;
                        if(z !== -1) {
                            value = chart.strings[z].value;
                            chart.data[i].value = value;
                        }
                        else {
                            obj = {};
                            obj.str = value;
                            obj.value = chart.strings.length;
                            chart.strings.push(obj);
                            value = obj.value;
                            chart.data[i].value = value;
                        }
                    }
                }
            } 
            iDetermineMinMax = 3;
            
            chart.endPtr = chart.data.length - 1;
            chart.dataCurrentEntries = chart.data.length;
            if(chart.data.length > 0) {
                chart.startTimestamp = chart.data[0].timestamp; //time in milli seconds
                chart.endTimestamp = chart.data[chart.data.length - 1].timestamp; //time in milli seconds
            }
        }
        else {

            chart.data[0] = {};
            chart.data[0].value = value;
            chart.data[0].timestamp = null;
            if(typeof value === "string")
                value = Number(value);
            if(value < 0)
                chart.hasNegativeNumbers = true; 

            if(g_bDashboardChartDynamicRange) {
                iDetermineMinMax = 2;
                
            }   
            else { 
                if(max === null) {
                    fvalue = parseFloat(value);
                    if(g_bDashboardMinMaxUsePadding) {
                        if(fvalue < 0) 
                            fvalue1 = 0;
                        else if(fvalue < 1) 
                            fvalue1 = 1;
                        else if(fvalue < 5)
                            fvalue1 = 5;
                        else if(fvalue > 1) 
                            fvalue1 = (Math.round(fvalue / 10) + 1) * 10;
                    }
                    max = fvalue1;
                }
                if(min === null) {
                    fvalue = parseFloat(value);
                    if(g_bDashboardMinMaxUsePadding) {
                        if(fvalue < 0) 
                        fvalue1 = (Math.round(fvalue / 10) - 1) * 10;
                        else if(fvalue < 1) 
                            fvalue1 = 0;
                        else if(fvalue < 5)
                            fvalue1 = 0;
                        else if(fvalue > 1) 
                            fvalue1 = (Math.round(fvalue / 10) - 1) * 10;
                    }
                    min = fvalue1;
                }
                chart.maxValue = max;
                chart.minValue = min;
                if(min === max)
                    chart.bMinMaxEqual = true;
                else
                    chart.bMinMaxEqual = false;
            }
        }
        
        chart.dynamicRange = hasDynmaicRange;
        chart.chartLabels = chartLabels;
        if(linecolor === null) {
            linecolor = "blue";
        }
        polygoncolor = "light" + linecolor;
        chart.lineColor = linecolor;
        chart.polygoncolor = polygoncolor;
        g_dashboardChartList.push(chart);
        dashboardDpList[index].displayElements[displayElementIndex].chartIndex = g_dashboardChartList.length - 1;
        
        if(iDetermineMinMax !== -1) {
            index = g_dashboardChartList.length - 1;
            if((iDetermineMinMax === 0) || (iDetermineMinMax === 3))
                value = null;
            else
                value = parseFloat(value);
            minmaxObj =  dashboardDetermineChartMinMaxValuesForChart(iDetermineMinMax, index, value, true);
        }
    }
    catch {}
}
function createChartObjectFieldChanged(index, displayId, pathname, field, min, max, hasDynmaicRange, linecolor, chartLabels) {
    //g_dashboardChartListIndex: null=initial creatation, otherwise replace existing.
    try {
        var fvalue, fvalue1, value, value1;
        var i, j, z;
        var chart = {}, minmaxObj, obj, obj1, snvtType;
        var d;
        var polygoncolor;
        var type;
        var iDetermineMinMax = -1;
        var data = [];
        if(g_dashboardChartList === null) 
            return;
        
        if(index >= g_dashboardChartList.length)
            return;
        if(g_dashboardChartList[index].displayId !== displayId)
            return;
        if(!g_dashboardChartList[index].bStructure || (field === ""))
            return;
        
        bDetermineMinMax = true;
        if(typeof g_dashboardChartList[index].datalogData !== "undefined") {
            if(g_dashboardChartList[index].datalogData.length > 0) {
                if(typeof g_dashboardChartList[index].snvtType !== "undefined") {
                    if(g_dashboardChartList[index].snvtType !== null) {
                        snvtType = g_dashboardChartList[index].snvtType;
                        if(snvtType !== null) {
                            snvtType = readSnvtTypeFieldValue(snvtType, field);
                            if(snvtType.valid) {
                                g_dashboardChartList.field = field;
                                g_dashboardChartList[index].chartLabels = "both";
                                g_dashboardChartList[index].bEnum = false;
                                g_dashboardChartList[index].bString = false;
                                snvtType = snvtType.data;
                                if(snvtType.type === "enum") {
                                    g_dashboardChartList[index].bEnum = true;
                                    g_dashboardChartList[index].enums = JSON.parse(JSON.stringify(snvtType.enum)); // enum[0].id and enum[0].value
                                    g_dashboardChartList[index].chartLabels = "x";
                                }
                                else if(snvtType.type === "string") {
                                    g_dashboardChartList[index].bString = true;
                                    g_dashboardChartList[index].strings = [];
                                    g_dashboardChartList[index].chartLabels = "x";
                                }
                            }
                        }
                    }
                }
                
                //chart.data = JSON.parse(JSON.stringify(dashboardDpList[index].datalogData));
                g_dashboardChartList[index].data = [];
                for(i=0; i < g_dashboardChartList[index].datalogData.length; i++)
                {
                    obj = {};
                    obj = JSON.parse(JSON.stringify(g_dashboardChartList[index].datalogData[i]));
                    value1 = readFieldValue(obj.value, field);
                    if(value1.valid) {
                        value = value1.data;
                        obj.value = value;
                        if(g_dashboardChartList[index].bEnum) {
                            z = -1;
                            for(j=0; j < g_dashboardChartList[index].enums.length; j++) {
                                if(value === g_dashboardChartList[index].enums[j].id) {
                                    z = j;
                                    break;
                                }
                            }
                            obj.str = value;
                            if(z !== -1) {
                                obj.value = g_dashboardChartList[index].enums[j].value;
                                
                            }
                            else {
                                obj1 = {};
                                obj1.str = value;
                                value1 = 1;
                                if(typeof value === "number") {
                                    // check if value matches other values
                                    // pick new value to show
                                    value1 = value;
                                    while(bContinue)
                                    {
                                        bContinue = false;
                                        for(j=0; j < g_dashboardChartList[index].enums.length; j++)
                                        {
                                            if(value1 === g_dashboardChartList[index].enums[j].value) {
                                                value1 ++;
                                                bContinue = true;
                                            }
                                        }
                                    }
                                }
                                // check if value matches other values
                                obj1.value = value1;
                                g_dashboardChartList[index].enums.push(obj1);
                                obj1.value = value;
                            }
                        }
                        else if(g_dashboardChartList[index].bString) {
                            z = -1;
                            for(j=0; j < chart.strings.length; j++) {
                                if(value === chart.strings[j].str) {
                                    z = j;
                                    break;
                                }
                            }
                            obj.str = value;
                            if(z !== -1) {
                                obj.value = g_dashboardChartList[index].strings[z].value;
                                
                            }
                            else {
                                obj1 = {};
                                obj1.str = value;
                                obj1.value = g_dashboardChartList[index].strings.length;
                                g_dashboardChartList[index].strings.push(obj1);
                                obj.value = obj1.value;
                                
                            }
                        }
                        g_dashboardChartList[index].data.push(obj);
                    }
                }
            }
            iDetermineMinMax = 3;
            minmaxObj =  dashboardDetermineChartMinMaxValuesForChart(iDetermineMinMax, index, null, true);
            if(g_dashboardChartList[index].bEnum || g_dashboardChartList[index].bString)
                document.getElementById("chartvalue_" + displayId).innerHTML = g_dashboardChartList[index].data[g_dashboardChartList[index].data.length - 1].str;
            else
                document.getElementById("chartvalue_" + displayId).innerHTML = g_dashboardChartList[index].data[g_dashboardChartList[index].data.length - 1].value;
            document.getElementById("chartpreset_" + displayId).innerHTML = ""; // since this is a field should always be  blank g_dashboardChartList[index].data[g_dashboardChartList[index].data.length - 1].presetValue;
        }
    }
    catch {}
}
function dashboardDetermineChartMinMaxValuesForChart(mode, index, value, bSaveChanges) {
    // mode: 0= check all, 1= compare last, 2= initial value so use value, 3=same as 0 but init chart
    var results = {};
    var bNoChanged = true;
    var bUpdateChart = true
    var min, max, value, i, fvalue1;
    var bChange = false;
    var index, maxDecimalPlaces = 3;
    var start;
    var bFirst = true;
    results.min = value;
    results.max = value;
	try {
        if(mode === 3) {
            bUpdateChart = false;
            mode = 0;
        }
		
		if((mode === 2) || ((mode === 1) && (index < g_dashboardChartList.length)) || (mode === 0 && (g_dashboardChartList[index].data !== null))) {
            if(mode === 0) {
                start = 0;
                start = g_dashboardChartList[index].startPtr;
                for(i=start; i < g_dashboardChartList[index].data.length; i ++)
                {
                    if(bFirst) { //(i === 0) {
                        bFirst = false;
                        min = g_dashboardChartList[index].data[i].value;
                        max = min;
                    }
                    else {
                        value = g_dashboardChartList[index].data[i].value;
                        if(value < min)
                            min = value;
                        if (value > max)
                            max = value;
                    }
                }
                if(min === max) {
                    g_dashboardChartList[index].bMinMaxEqual = true;
                    max = Math.round((max * 10) + 1) / 10;
                    min = Math.ceil((min * 10) - 1) / 10;
                }
                else 
                    g_dashboardChartList[index].bMinMaxEqual = false;
                bChange = true;
            }
            else if (mode === 1) {
                bNoChange = true;
                max =  g_dashboardChartList[index].maxValue;
                min =  g_dashboardChartList[index].minValue;
                if(g_dashboardChartList[index].bMinMaxEqual) {
                    lastIndex =  g_dashboardChartList[index].data.length - 1;
                    if(lastIndex > 0) {
                        if(g_dashboardChartList[index].data[lastIndex - 1].value !== g_dashboardChartList[index].data[lastIndex].value) {
                            max = g_dashboardChartList[index].data[lastIndex - 1].value;
                            min = max;
                            g_dashboardChartList[index].bMinMaxEqual = false;
                            bNoChanged = false;
                        }
                    }
                }
                if(value >= max){
                    max = value;
                    bNoChanged = false;
                }
                if(value <= min){
                    min = value;
                    bNoChanged = false;
                }
                if(bNoChanged)
                    return results;
            }
            else {
                g_dashboardChartList[index].bMinMaxEqual = true;
                min = max = value;
                max = Math.round((max * 10) + 1) / 10;
                min = Math.ceil((min * 10) - 1) / 10;
            }
            if(g_bDashboardMinMaxUsePadding) {
                if(Math.abs(max) > 100)
                    fvalue1 = (Math.round(max / 10) + 1) * 10;
                else if(Math.abs(max) > 1)
                    fvalue1 = Math.ceil(max + 1);
                else 
                    fvalue1 = Math.ceil((max * 10) + 1) / 10;
            }
            else
                fvalue1 = max;
            if(g_bDashboardMinMaxDecimalPlaces) {
                maxDecimalPlaces = -1;
                if(Math.abs(min) > 2)
                    maxDecimalPlaces = g_iDashboardDecimalPlaces;
                fvalue1 = numToFixedLength(fvalue1, 8, maxDecimalPlaces, true)
            }
            if(mode < 2) {
                if(g_dashboardChartList[index].maxValue !== fvalue1) {
                    if(bSaveChanges)
                        g_dashboardChartList[index].maxValue = fvalue1;
                    bChange = true;
                    
                }
            }
            results.max = fvalue1;
            if(g_bDashboardMinMaxUsePadding) {
                if(Math.abs(min) > 100)
                    fvalue1 = (Math.round(min / 10) - 1) * 10;
                else if(Math.abs(min) > 1)
                    fvalue1 = Math.ceil(min - 1);
                else 
                    fvalue1 = Math.ceil((min * 10) - 1) / 10;
            }
            else
                fvalue1 = min;
            if(g_bDashboardMinMaxDecimalPlaces) {
                
                fvalue1 = numToFixedLength(fvalue1, 8, maxDecimalPlaces, false)
            }
            if(mode < 2) {
                if(g_dashboardChartList[index].minValue !== fvalue1) {
                    if(bSaveChanges)
                        g_dashboardChartList[index].minValue = fvalue1;
                    bChange = true;
                }
            }
            results.min = fvalue1;
            if(bChange) {
                if(g_dashboardChartList[index].dynamicRange) {
                    g_dashboardChartList[index].iDynamicRangeCount = ivChartTotalEntries + 2;
                }
            }
            if(mode  < 2) {
                if(bChange && bUpdateChart && !g_bdashboardChartPause && !g_dashboardChartList[index].paused && bSaveChanges) {
                    try {
                        ivInitializeChart1(g_bDashboardSupportLogData, "chartSvg_" + g_dashboardChartList[index].displayId, g_dashboardChartList[index].minValue, g_dashboardChartList[index].maxValue, null, null, null, null, g_dashboardChartList[index].chartLabels);
                        
                    } catch (err) {}
                }
            }
			
		}
	}
    catch {}
    return results;
}
function dashboardDecimialPlaces() {
    if(g_iMainDisplayMode !== DISPLAYMODE_DASHBOARD)
        return;
    try {
        g_iDashboardDecimalPlaces = document.getElementById("dashboardDecimalPlaces").value;
        g_iDashboardDecimalPlaces = Number(g_iDashboardDecimalPlaces);
    }
    catch(err) {}
}
function dashboardChartChangeField(index1, displayElementIndex, displayId, fieldDisplayId) {
    try {
        var element = document.getElementById(fieldDisplayId);
        var field = "", index;
        if(element !== null) {
            field = element.value;
            if(dashboardDpList === null) 
                return "";
            if(dashboardDpList.length == 0)
                return "";
            if(index1 >= dashboardDpList.length)
                return;
            if(displayElementIndex === -1)
                return;
            if(displayElementIndex >=  dashboardDpList[index1].displayElements.length)
                return;
            if(typeof dashboardDpList[index1].displayElements[displayElementIndex].chartIndex) {
                index = dashboardDpList[index1].displayElements[displayElementIndex].chartIndex;
                if(index === -1)
                    return;
                if(g_dashboardChartList == null) 
                    return "";
                if(g_dashboardChartList.length == 0)
                    return "";
                if(index >= g_dashboardChartList.length)
                    return;
                if(g_dashboardChartList[index].displayId = displayId) {  
                    g_dashboardChartList[index].field = field;
                    dashboardDpList[index1].displayElements[displayElementIndex].field = field;
                    createChartObjectFieldChanged(index, g_dashboardChartList[index].displayId, g_dashboardChartList[index].pathname, field, null, null, true, null, "both");
                    ivInitializeChart1(g_bDashboardSupportLogData, "chartSvg_" + g_dashboardChartList[index].displayId, g_dashboardChartList[index].minValue, g_dashboardChartList[index].maxValue, null, null, g_chartTextColor, null, g_dashboardChartList[index].chartLabels);
                    dashboardUpdateCharts(index, null, null);
                }
            }
        }
    }
    catch {}
}
function dashboardChartDetermineStartTime(mode, chartIndex, timestamp) { 
    //mode: 0=always update, 1=update only if using log duration
    try {
        var bStartTimeChange = false;
        var i;
        var starttime = timestamp;
        var bNotFound = true;
        var start;
        if(timestamp > 0) {
            if(chartIndex < g_dashboardChartList.length) {
                if((mode === 0) || ((mode === 1) && (g_iDashboardChartMaxDuration !== 0))) {
                    
                    if((g_dashboardChartList[chartIndex].startPtr === -1) || (g_dashboardChartList[chartIndex].endPtr === -1) || (g_dashboardChartList[chartIndex].data.length === 0)) {
                        // nothing to do, most likely someone cleared the chart
                    }
                    else {
                        if(g_iDashboardChartMaxDuration === 0) {
                            if(g_dashboardChartList[chartIndex].startPtr !== 0) {
                                bStartTimeChange = true;
                                g_dashboardChartList[chartIndex].startPtr = 0;
                            }
                            g_dashboardChartList[chartIndex].durationStartTimestamp = 0;
                            g_dashboardChartList[chartIndex].startTimestamp = g_dashboardChartList[chartIndex].data[g_dashboardChartList[chartIndex].startPtr].timestamp;
                        }
                        else {
                            timestamp -= g_iDashboardChartMaxDuration;
                            start = g_dashboardChartList[chartIndex].startPtr;
                            if(g_dashboardChartList[chartIndex].data[start].timestamp > timestamp)
                                start = 0;
                            for(i=start; i < g_dashboardChartList[chartIndex].data.length; i++)
                            {
                                if(g_dashboardChartList[chartIndex].data[i].timestamp >= timestamp) {
                                    if(g_dashboardChartList[chartIndex].data[i].timestamp === timestamp)
                                        g_dashboardChartList[chartIndex].startPtr = i;
                                    else {
                                        if(i==0) {
                                            if(g_dashboardChartList[chartIndex].startPtr !== 0) {
                                                bStartTimeChange = true;
                                                g_dashboardChartList[chartIndex].startPtr = 0;
                                            }
                                        }
                                        else {
                                            bStartTimeChange = true;
                                            if(g_dashboardChartList[chartIndex].startPtr !== (i - 1)) 
                                                g_dashboardChartList[chartIndex].startPtr = i - 1;
                                        }
                                    }
                                    bNotFound = false;
                                    break;
                                }
                            }
                            if(bNotFound) {
                                if(g_dashboardChartList[chartIndex].startPtr !== g_dashboardChartList[chartIndex].endPtr) {
                                    g_dashboardChartList[chartIndex].startPtr = g_dashboardChartList[chartIndex].endPtr
                                    bStartTimeChange = true;
                                }
                            }
                            if(bStartTimeChange) {
                                g_dashboardChartList[chartIndex].startTimestamp = g_dashboardChartList[chartIndex].data[g_dashboardChartList[chartIndex].startPtr].timestamp;
                                g_dashboardChartList[chartIndex].durationStartTimestamp = timestamp;
                            }
                        }
                        
                    }
                    
                }
            }
        }
    }
    catch (err) {
        console.log("dashboardChartDetermineStartTime: " + err);
    }
    return bStartTimeChange;
}
function dashboardCheckIfTagsAlreadyExist(deviceName) {
    // check if iox interface is in customtags or user.js
    var bResult = false; //mike
    var i,j,m,z = -1, deviceName, deviceTypeName,programId;
    try {
        for(i=0; i < deviceListAll.length; i++)
        {
            if(deviceName.toLowerCase() === deviceListAll[i].name.toLowerCase()) {
                deviceName = deviceListAll[i].name.toLowerCase();
                deviceTypeName = deviceListAll[i].deviceTypeName;
                programId = deviceListAll[i].programId;
                for(k=0; k < g_campusTags.deviceTypesList.length; k++)
                {
                    for(j=0; j < 3; j++)
                    {
                        if(j===0) {
                            // looks for device name
                            if((g_campusTags.deviceTypesList[k].type === "devicename") && (g_campusTags.deviceTypesList[k].name === deviceName)) {
                                z = k;
                                break;
                            }
                        }
                        else if(j===1) {
                            // look for device type
                            if((g_campusTags.deviceTypesList[k].type === "devicetype") && (g_campusTags.deviceTypesList[k].name === deviceTypeName)) {
                                z = k;
                                break;
                            }
                        }
                        else  {
                            // look for programid
                            if((g_campusTags.deviceTypesList[k].type === "programid") && (g_campusTags.deviceTypesList[k].name === programId)) {
                                z = k;
                                break;
                                
                            }
                        }
                    }
                }
                if(z === -1) {
                    // check if device settings already in global Tags
                    if(!g_bIgnoreUserJsReplacements) {
                        for(j=0; j < g_deviceTypesReplacementsDpList.length; j ++)
                        {
                            for(m=0; m < 3; m ++)
                            {  // look for device name, followed by device type and finally by program ID
                                if(m === 0) {
                                    if(g_deviceTypesReplacementsDpList[j].type == "d") { // device name
                                        if(g_deviceTypesReplacementsDpList[j].name.toLowerCase() == deviceDpList[i].deviceName.toLowerCase()){
                                            z = j;
                                            break;
                                        }
                                    }
                                }
                                else if(m=== 1) {
                                    if(g_deviceTypesReplacementsDpList[j].type == "dt") { // device type
                                        if(g_deviceTypesReplacementsDpList[j].name.toLowerCase() == deviceDpList[i].deviceTypeName.toLowerCase()){
                                            z = j;
                                            break;
                                        }
                                    }

                                }
                                else if(m === 2) {
                                    if(g_deviceTypesReplacementsDpList[j].type == "p") { // program ID
                                        if(g_deviceTypesReplacementsDpList[j].name.toLowerCase() == deviceDpList[i].programId.toLowerCase()){
                                            z = j;
                                            break;
                                        }
                                    }
                                }
                            }
                            if(z !== -1)
                                break;

                        }
                    }
                }
                break;
            }
        }
        if(z !== -1)
            bResult = true;
    }
    catch {}
    return bResult;
}
function dashboardDropdownSelected(n, index, displayElementIndex, pathname, displayId) {
    if((g_iMainDisplayMode !== DISPLAYMODE_DASHBOARD) && (g_iMainDisplayMode !== DISPLAYMODE_PLANNING))
        return;
    try {
        var objs = null, bContinue;
		var i,j, z = -1;
		var tempStr, newValue = {};
		var char;
		var priority = null;
		var checkList = [{char:"{", count: 0}, {char:"}", count: 0}, {char:"[", count: 0}, {char:"]", count: 0}, {char:"\"", count: 0}];
        var value = n.value;
		if(value === null)
			return;
		if (value === "")
			return;
		objs = dashboardDpList;
		value = value.trim(); // remove beginning and trailing spaces
		bContinue = false;
		
		for(i=0; i < objs.length; i++)
		{  // find datapoint
			if(objs[index].programmaticPathname === pathname) {
				var value1 = objs[index].value;
                value = "\"" + value + "\"";
					
					// add feedback
				objs[index].feedbackDelay = true;
				var currentTime = new Date().getTime();
				objs[index].feedbackDelayTimeout = currentTime + g_iFeedbackDelayTime; // ms  10000 = 10 s
				objs[index].feedbackDelayOldValue = JSON.parse(JSON.stringify(objs[index].locValue));
				objs[index].valueStr = value;
								// check if using field or full datapoint value
				objs[index].value = value;
				
				//  fixxxxxx  Determine preset value
				z = index;
				break;
			}
			index ++;
			if(index >= objs.length)
				index = 0;
		}
		if(z !== -1) {
			if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
				if(dashboardDpList[z].dashboardType === "d")  {
				    priority = document.getElementById("priority_" + pathname)
				if(priority !== null)
					priority = priority.value;
				}
			}
            else if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING) {
                //ffix add code 
            }
			url = "/iap/devs/*+name=="; //iot
			url += objs[z].urlPath.replace(/ /g,"%20").replace(/:/g,"%3A").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
			if(priority !== null)
                url += "/overrides/" + priority;
            url += "/localization/value";
			objs[z].updateDpValue = true; // sync up value, localValue and Preset
			writeDpValue(1,url,value, null, writeFailCallback);
            /*
			if((g_iMainDisplayMode === DISPLAYMODE_DPS) || (g_iMainDisplayMode === DISPLAYMODE_FAVDPS)){
				document.getElementById("currentValue_" + objs[z].pathname).innerHTML = objs[z].valueStr;
				document.getElementById("presetValue_"+ objs[z].pathname).innerHTML = objs[z].presetValue;
			} */
		}
	} catch (err) {}
}
function dashboardMouseEventsAddToChart(displayId, parentDivId, chartIndex) {
    // SVG must be in a parent DIV by itself
    var meterObj;
    var meterSvgDoc;
    if(navigator.userAgent.match(/Chrome/))	
    {		
      meterObj = document.getElementById(displayId);
      meterSvgDoc = meterObj.contentDocument;
    }
    else
    meterSvgDoc = document.getElementById(displayId).getSVGDocument();
    
    meterSvgDoc.getElementById("rect1").chartIndex = chartIndex;
    meterSvgDoc.getElementById("rect1").parentDivId = parentDivId;
      
    meterSvgDoc.getElementById("rect1").addEventListener("mousemove",dashboardMousemove);
    meterSvgDoc.getElementById("rect1").addEventListener("mouseenter",dashboardMouseenter);
    meterSvgDoc.getElementById("rect1").addEventListener("mouseout",dashboardMouseout);
}
function dashboardMouseenter(e) {
    if(g_bDashboardDisplayMouseToolTip) {
        dashboardMousemove(e);
    }
    e.preventDefault();
}
function dashboardMousemove(e) {
    //chartIndex: z0=zoomchart
    try {
        var mode = 0;
        var parentDivId, chartIndex;
        if(g_bDashboardDisplayMouseToolTip) {
            parentDivId = e.target.parentDivId;
            chartIndex = e.target.chartIndex;
            if(chartIndex === "z0")
				mode = 1; // ffixmouse
            dashboardMousePositionChartDisplayValue(mode, chartIndex, parentDivId, e.clientX, e.clientY);
        }
        e.preventDefault();
    }
catch (err) {}
}
function dashboardMouseout(e) {
    try {
        if(g_bDashboardDisplayMouseToolTip) {
            var svgObj, svgDoc;
            var tooltip, displayId = "zoomChartSvg";
            var chartIndex = e.target.chartIndex;
            if(g_dashboardChartList == null) 
                return "";
            if(g_dashboardChartList.length == 0)
                return "";
            if(chartIndex >= g_dashboardChartList.length)
                return;
            if(chartIndex !== "z0")
                displayId = g_dashboardChartList[chartIndex].displayId1;
            if(navigator.userAgent.match(/Chrome/))	
            {		
                svgObj = document.getElementById(displayId);
                svgDoc = svgObj.contentDocument;
            }
            else
                svgDoc = document.getElementById(displayId).getSVGDocument();
            tooltip = svgDoc.getElementById("tooltip");
            if(tooltip !== null) 
                tooltip.setAttributeNS(null, "visibility", "hidden");
        }
        e.preventDefault();
    }
    catch {}
}
function showTooltip(evt, text) { //remove
    let tooltip = document.getElementById("tooltip");
    tooltip.innerHTML = text;
    tooltip.style.display = "block";
    tooltip.style.left = evt.pageX + 10 + 'px';
    tooltip.style.top = evt.pageY + 10 + 'px';
}
function dashboardMousePositionChartDisplayValue(mode, chartIndex, parentDivId, eClientX, eClientY) {
	// mode:0=normal chart, 1=zoom
    var sResult = "";
    var svgObj, svgDoc, svgChartRectangle;
    var str = "", value, presetValue = "";
    var d, time, dates, timestamp = 0, i, delta1, delta2, dataIndex = -1;
    var chartList = [];
    var startTimestampMicroSec;
    var endTimestampMicroSec; 
    var xRange; 
    var range; 
    var min, max;
    var oneDayMs = 24 * 60 * 60 * 1000;
    var iTimeOffset = 1; // 1: time only, 2=time + date
    var x,x1 = 0, y,w = 600, wZoom = 250;
    var yoffset, yoffset1 = 400, yoffset2 = 300;   
    var xoffset, xoffset1 = 550, xoffset2 = 60, xoffset3 = 110;
    var yoffset, yZoomOffset1 = 150, yZoomOffset2 = 150;   
    var xoffset, xZoomOffset1 = 480, xZoomOffset2 = -110, xZoomOffset3 = -220;
    var bZoomChart = false;
    var bEnum = false;
    var bString = false;
    var bWideText = false;
    try {
        if(mode === 0) {
            if(g_dashboardChartList == null) 
                return "";
            if(g_dashboardChartList.length == 0)
                return "";
            if(chartIndex >= g_dashboardChartList.length)
                return "";
            if(typeof g_dashboardChartList[chartIndex].data === "undefined")
                return "";
            if(g_dashboardChartList[chartIndex].data === null)
                return ""
            if(g_dashboardChartList[chartIndex].data.length === 0)
                return "";
            
            chartList = JSON.parse(JSON.stringify(g_dashboardChartList[chartIndex]));
        }
        else if(mode === 1) {  
            if(g_zoomDashboardChartList == null) 
                return "";
            if(g_zoomDashboardChartList == 0)
                return "";
            
            if(typeof g_zoomDashboardChartList[0].data === "undefined")
                return "";
            if(g_zoomDashboardChartList[0].data === null)
                return ""
            if(g_zoomDashboardChartList[0].data.length === 0)
                return "";
            
            chartList = JSON.parse(JSON.stringify(g_zoomDashboardChartList[0]));
            chartList.displayId1 = "zoomChartSvg";
            bZoomChart = true;
            
        }
        else if(mode === 4) {  
            // devicelog chart used for device logs and navtree log
            if(g_chartListLogs == null) 
            return "";
            if(g_chartListLogs.length == 0)
                return "";
            if(chartIndex >= g_chartListLogs.length)
                return "";
            if(typeof g_chartListLogs[chartIndex].chartObj.data === "undefined")
                return "";
            if(g_chartListLogs[chartIndex].chartObj.data === null)
                return ""
            if(g_chartListLogs[chartIndex].chartObj.data.length === 0)
                return "";
            
            chartList = JSON.parse(JSON.stringify(g_chartListLogs[chartIndex].chartObj));
            
        }
        else 
            return;

        if(typeof chartList.bEnum !== "undefined")
            bEnum = chartList.bEnum;
        if(typeof chartList.bString !== "undefined")
            bString = chartList.bString;
        
        min = chartList.minValue;
        max = chartList.maxValue;
        startTimestampMicroSec = chartList.startTimestamp;
        endTimestampMicroSec = chartList.endTimestamp;
        xRange = endTimestampMicroSec - startTimestampMicroSec; // MicroSec
        if(navigator.userAgent.match(/Chrome/))	
        {		
            svgObj = document.getElementById(chartList.displayId1);
            svgDoc = svgObj.contentDocument;
        }
        else
            svgDoc = document.getElementById(chartList.displayId1).getSVGDocument();
        svgChartRectangle = svgDoc.getElementById("rect1");
        svgP = ivSvgPoint(svgDoc, svgChartRectangle, eClientX, eClientY);
        if(svgP != null) {
            if((svgP.x >= 0) && (svgP.y >= 0)) {
                
                if((min != null) && (max != null)) {
                range = max - min;
            
                timestamp = (svgP.y / ivChartXLengthLargeChart) * xRange;
                timestamp += startTimestampMicroSec;
                if(timestamp <= endTimestampMicroSec) {
                    // determine closest saved value
                    if(chartList.data.length === 1) {
                        value = chartList.data[0].value;
                        timestamp = chartList.data[0].timestamp;
                        dataIndex = 0;
                        if(typeof chartList.data[dataIndex].presetValue !== "undefined")
                            presetValue = chartList.data[dataIndex].presetValue;
                    }
                    else {

                        for(i=0; i < chartList.data.length; i++)
                        {
                            if(timestamp < chartList.data[i].timestamp) {
                                if (i === 0) {
                                    value = chartList.data[0].value;
                                    timestamp = chartList.data[0].timestamp;
                                    dataIndex = i;
                                    if(typeof chartList.data[dataIndex].presetValue !== "undefined")
                                        presetValue = chartList.data[dataIndex].presetValue;
                                }
                                else {
                                // check if previous stored value closer
                                    delta1 = timestamp - chartList.data[i - 1].timestamp;
                                    delta2 = chartList.data[i].timestamp - timestamp;
                                    dataIndex = i;
                                    if(delta1 < delta2)
                                        dataIndex --;
                                    }
                                    value = chartList.data[dataIndex].value;
                                    timestamp = chartList.data[dataIndex].timestamp;
                                    if(typeof chartList.data[dataIndex].presetValue !== "undefined")
                                        presetValue = chartList.data[dataIndex].presetValue;
                                    break;
                                }
                            }
                        }
                    }
                    if(dataIndex !== -1) {
                        if(g_bDashboardDisplayMouseToolTipShowPresets && (presetValue !== ""))
                            value = presetValue;
                        if (bEnum || bString) {
                            value = chartList.data[dataIndex].str;
                        }
                        else {
                            if(typeof value === "number") {
                                if(value.toString().indexOf(".") !== -1) {
                                    if(min > 10)
                                        str = value.toFixed(2);
                                    else if(max > 50)
                                        str = value.toFixed(2);
                                    else if(max >= 1)
                                        str = value.toFixed(2);
                                    else if(min > 1)
                                        str = value.toFixed(3);
                                    else
                                        str = value;
                                    value = str;
                                }
                            }
                        }
                        if(value.length > g_iTooltipTextMaxLen1) {
                            bWideText = true;
                            if(value.length > g_iTooltipTextMaxLen2) {
                                value = value.substr(0, g_iTooltipTextMaxLen2 - 3);
                                value += "...";
                            }
                            if(bZoomChart)
                                wZoom *= 2
                            else
                                w *= 2;
                        }
                        d = new Date();
                        d.setTime(timestamp);
                        time = d.toLocaleTimeString();
                        //dates = d.toLocaleDateString().split("/");
                        str = time;
                        if(bZoomChart) {
                            if(xRange > oneDayMs) {
                                iTimeOffset = 2;
                                str += " " + d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0); //dates[2] + "-" +  ivPadStart(dates[0], "0", 2) + "-" +  ivPadStart(dates[1], "0", 2);
                            }
                            sResult = value + "<br>" + str;
    
                            x =  svgP.y + xZoomOffset1;
                            if(bWideText && ((svgP.y + (wZoom * iTimeOffset)) > (ivChartXLengthLargeChart + 95))) {
                                //x = xoffset1 + ivChartXLengthLargeChart + 95 - (wZoom * iTimeOffset);
                                //x = svgP.y - (ivChartXLengthLargeChart + 95 - (wZoom * iTimeOffset));
                                x = ivChartXLengthLargeChart;
                            }
                            else if((x + (wZoom * iTimeOffset / 2)) > (ivChartXLengthLargeChart + 95)){
                                if(bWideText)
                                    x =   svgP.y - xZoomOffset3;
                                else 
                                    x =   svgP.y - xZoomOffset2;
                            }
                            y = ivChartYLengthLargeChart + 100 - svgP.x - yZoomOffset1;
                            if(y < 0)
                                y = yZoomOffset2;
                        }
                        else {
                            if(xRange > oneDayMs) {
                                iTimeOffset = 2;
                                str += " " + d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0); //dates[2] + "-" +  ivPadStart(dates[0], "0", 2) + "-" +  ivPadStart(dates[1], "0", 2);
                            }
                            sResult = value + "<br>" + str;
    
                            x =  svgP.y + xoffset1;
                            if(bWideText && ((svgP.y + (w * iTimeOffset)) > (ivChartXLengthLargeChart + 95))) {
                                x = xoffset1 + ivChartXLengthLargeChart + 95 - (w * iTimeOffset);
                                //x = ivChartXLengthLargeChart;
                            }
                            else if((x + (w * iTimeOffset)) > (ivChartXLengthLargeChart + 95)) {
                                if(bWideText)
                                    x =   svgP.y - xoffset3;
                                else
                                    x =   svgP.y - xoffset2;
                            }
                            y = ivChartYLengthLargeChart + 100 - svgP.x - yoffset1;
                            if(y < 0)
                                y = yoffset2;
                        }
                    
                        tooltip = svgDoc.getElementById("tooltip");
                        if(tooltip !== null) {
                        // tooltip.setAttributeNS(null, "x", svgP.x + 200);//mouseX + 6 / CTM.a);
                        //  tooltip.setAttributeNS(null, "y", svgP.y + 200);//mouseY + 20 / CTM.d);
                            tooltip.setAttributeNS(null, "visibility", "visible");
                            tooltiptext = svgDoc.getElementById("tooltiptextrect");
                            tooltiptext.setAttributeNS(null, "x", x - 20);
                            tooltiptext.setAttributeNS(null, "y", y);
                            if(iTimeOffset === 2) {
                                //ffixx  add g_dashboardChartList[chartIndex].tooltipWidth and clear on clear button and reenter dashboard
                                //if( g_dashboardChartList[chartIndex].tooltipWidth !== 2)
                                if(bZoomChart)
                                    tooltiptext.setAttributeNS(null, "width", (wZoom * iTimeOffset));
                                else 
                                    tooltiptext.setAttributeNS(null, "width", (w * iTimeOffset));
                            }
                            else {
                                //if( g_dashboardChartList[chartIndex].tooltipWidth !== 1)
                                
                                if(bZoomChart)
                                    tooltiptext.setAttributeNS(null, "width", (wZoom * iTimeOffset));
                                else 
                                    tooltiptext.setAttributeNS(null, "width", (w * iTimeOffset));
                            }




                            tooltiptext = svgDoc.getElementById("tooltiptext1");
                            tooltiptext.setAttributeNS(null, "x", x);
                            if(bZoomChart)
                                tooltiptext.setAttributeNS(null, "y", y + 45);
                            else 
                                tooltiptext.setAttributeNS(null, "y", y + 100);
                            tooltiptext.textContent = value;
                            tooltiptext = svgDoc.getElementById("tooltiptext2");
                            tooltiptext.setAttributeNS(null, "x", x);
                            if(bZoomChart)
                                tooltiptext.setAttributeNS(null, "y", y + 55);
                            else
                                tooltiptext.setAttributeNS(null, "y", y + 150);
                            tooltiptext.textContent = str;
                            
                            
                        }
                    }
                }
            }
        }
    }
    catch (err) {
        sResult += "<br>" + err.toString();
    }
return sResult;
}
function dashboardMousePositionChartDisplayValue_orig(mode, chartIndex, parentDivId, eClientX, eClientY) {
    //mode: 0=dashboard chart, 1=zoomchart
    var sResult = "";
    var svgObj, svgDoc, svgChartRectangle;
    var str = "", value, presetValue = "";
    var d, time, dates, timestamp = 0, i, delta1, delta2, dataIndex = -1;
    var chartList = [];
    var startTimestampMicroSec;
    var endTimestampMicroSec; 
    var xRange; 
    var range; 
    var min, max;
    var oneDayMs = 24 * 60 * 60 * 1000;
    var iTimeOffset = 1; // 1: time only, 2=time + date
    var x,y,w = 500;
    var yoffset, yoffset1 = 400, yoffset2 = 300;   
    var xoffset, xoffset1 = 550, xoffset2 = 50;
    var bZoomChart = false;
    try {
        if(mode === 0) {
            if(g_dashboardChartList == null) 
                return "";
            if(g_dashboardChartList.length == 0)
                return "";
            if(chartIndex >= g_dashboardChartList.length)
                return "";
            if(typeof g_dashboardChartList[chartIndex].data === "undefined")
                return "";
            if(g_dashboardChartList[chartIndex].data === null)
                return ""
            if(g_dashboardChartList[chartIndex].data.length === 0)
                return "";
        }
        else if(mode === 1) {  
            if(g_zoomDashboardChartList == null) 
                return "";
            if(g_zoomDashboardChartList == 0)
                return "";
            
            if(typeof g_zoomDashboardChartList[0].data === "undefined")
                return "";
            if(g_zoomDashboardChartList[0].data === null)
                return ""
            if(g_zoomDashboardChartList[0].data.length === 0)
                return "";
            
            chartList = g_zoomDashboardChartList[0];
            bZoomChart = true;
        }
        else 
            return;
        
        chartList = g_dashboardChartList[chartIndex].data;
        min = g_dashboardChartList[chartIndex].minValue;
        max = g_dashboardChartList[chartIndex].maxValue;
        startTimestampMicroSec = g_dashboardChartList[chartIndex].startTimestamp;
        endTimestampMicroSec = g_dashboardChartList[chartIndex].endTimestamp;
        xRange = endTimestampMicroSec - startTimestampMicroSec; // MicroSec
        if(navigator.userAgent.match(/Chrome/))	
        {		
            svgObj = document.getElementById(g_dashboardChartList[chartIndex].displayId1);
            svgDoc = svgObj.contentDocument;
        }
        else
            svgDoc = document.getElementById(g_dashboardChartList[chartIndex].displayId1).getSVGDocument();
        svgChartRectangle = svgDoc.getElementById("rect1");
        svgP = ivSvgPoint(svgDoc, svgChartRectangle, eClientX, eClientY);
        if(svgP != null) {
            if((svgP.x >= 0) && (svgP.y >= 0)) {
                
                if((min != null) && (max != null)) {
                range = max - min;
            
                timestamp = (svgP.y / ivChartXLengthLargeChart) * xRange;
                timestamp += startTimestampMicroSec;
                if(timestamp <= endTimestampMicroSec) {
                    // determine closest saved value
                    if(g_dashboardChartList[chartIndex].data.length === 1) {
                        value = g_dashboardChartList[chartIndex].data[0].value;
                        timestamp = g_dashboardChartList[chartIndex].data[0].timestamp;
                        dataIndex = 0;
                        if(typeof g_dashboardChartList[chartIndex].data[dataIndex].presetValue !== "undefined")
                            presetValue = g_dashboardChartList[chartIndex].data[dataIndex].presetValue;
                    }
                    else {

                        for(i=0; i < g_dashboardChartList[chartIndex].data.length; i++)
                        {
                            if(timestamp < g_dashboardChartList[chartIndex].data[i].timestamp) {
                                if (i === 0) {
                                    value = g_dashboardChartList[chartIndex].data[0].value;
                                    timestamp = g_dashboardChartList[chartIndex].data[0].timestamp;
                                    dataIndex = i;
                                    if(typeof g_dashboardChartList[chartIndex].data[dataIndex].presetValue !== "undefined")
                                        presetValue = g_dashboardChartList[chartIndex].data[dataIndex].presetValue;
                                }
                                else {
                                // check if previous stored value closer
                                    delta1 = timestamp - g_dashboardChartList[chartIndex].data[i - 1].timestamp;
                                    delta2 = g_dashboardChartList[chartIndex].data[i].timestamp - timestamp;
                                    dataIndex = i;
                                    if(delta1 < delta2)
                                        dataIndex --;
                                    }
                                    value = g_dashboardChartList[chartIndex].data[dataIndex].value;
                                    timestamp = g_dashboardChartList[chartIndex].data[dataIndex].timestamp;
                                    if(typeof g_dashboardChartList[chartIndex].data[dataIndex].presetValue !== "undefined")
                                        presetValue = g_dashboardChartList[chartIndex].data[dataIndex].presetValue;
                                    break;
                                }
                            }
                        }
                    }
                    if(dataIndex !== -1) {
                        if(g_bDashboardDisplayMouseToolTipShowPresets && (presetValue !== ""))
                            value = presetValue;
                        else {
                            if(typeof value === "number") {
                                if(value.toString().indexOf(".") !== -1) {
                                    if(min > 10)
                                        str = value.toFixed(2);
                                    else if(max > 50)
                                        str = value.toFixed(2);
                                    else if(max >= 1)
                                        str = value.toFixed(2);
                                    else if(min > 1)
                                        str = value.toFixed(3);
                                    else
                                        str = value;
                                    value = str;
                                }
                            }
                        }
                        
                        d = new Date();
                        d.setTime(timestamp);
                        time = d.toLocaleTimeString();
                        //dates = d.toLocaleDateString().split("/");
                        str = time;
                        if(xRange > oneDayMs) {
                            iTimeOffset = 2;
                            str += " " + d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0); //dates[2] + "-" +  ivPadStart(dates[0], "0", 2) + "-" +  ivPadStart(dates[1], "0", 2);
                        }
                        sResult = value + "<br>" + str;

                        x =  svgP.y + xoffset1;
                        if((x + (w * iTimeOffset)) > (ivChartXLengthLargeChart + 100))
                            x =   svgP.y - xoffset2;
                        y = ivChartYLengthLargeChart + 100 - svgP.x - yoffset1;
                        if(y < 0)
	                        y = yoffset2;
                    
                        tooltip = svgDoc.getElementById("tooltip");
                        if(tooltip !== null) {
                        // tooltip.setAttributeNS(null, "x", svgP.x + 200);//mouseX + 6 / CTM.a);
                        //  tooltip.setAttributeNS(null, "y", svgP.y + 200);//mouseY + 20 / CTM.d);
                            tooltip.setAttributeNS(null, "visibility", "visible");
                            tooltiptext = svgDoc.getElementById("tooltiptextrect");
                            tooltiptext.setAttributeNS(null, "x", x - 20);
                            tooltiptext.setAttributeNS(null, "y", y);
                            tooltiptext = svgDoc.getElementById("tooltiptext1");
                            tooltiptext.setAttributeNS(null, "x", x);
                            tooltiptext.setAttributeNS(null, "y", y + 100);
                            tooltiptext.textContent = value;
                            tooltiptext = svgDoc.getElementById("tooltiptext2");
                            tooltiptext.setAttributeNS(null, "x", x);
                            tooltiptext.setAttributeNS(null, "y", y + 150);
                            tooltiptext.textContent = str;
                            if(iTimeOffset === 2) {
                                //ffixx  add g_dashboardChartList[chartIndex].tooltipWidth and clear on clear button and reenter dashboard
                                //if( g_dashboardChartList[chartIndex].tooltipWidth !== 2)
                                tooltiptext.setAttributeNS(null, "width", (w * iTimeOffset));
                            }
                            else {
                                //if( g_dashboardChartList[chartIndex].tooltipWidth !== 1)
                                tooltiptext.setAttributeNS(null, "width", (w * iTimeOffset));
                            }
                        }
                    }
                }
            }
        }
    }
    catch (err) {
        sResult += "<br>" + err.toString();
    }
return sResult;
}
function dashboardSetThermometerValue (mode, Source, value,degMin,degMax,displayId) {
    // mode: 0=medium thermometer, 
	var height = 207; // not used
	var heightOffset = 20; //not used
	var bottom = 0, top = 0, fTop = 201, fBottom = 13; // cBottom = 10, cTop = 203, fTop = 201, fBottom = 12;
	var tempRange = 0, barRange = 0; 
    if(displayId === null)
        return;
    if(displayId === "")
        return;
	element = document.getElementById("thermometerBar1_" + displayId);
	try {
		if(element === null)
			return;
		if(isNaN(value))
			return;
		if(mode === 0) {
            // has both celius and fahrenheit
            height = 207;
	        heightOffset = 20;
            if((degMin !== null) && (degMax !== null)) {
                bottom = 0; 
                top = bottom + 200;
            }
            else if(Source === "l") {
                // deg f
                if(degMax == null)
                    degMax = 100;
                if(degMin == null)
                    degMin = 0;
                top = 200; 
                bottom = 0;
            }
            else if(Source === "f") {
                // deg f
                if(degMax == null)
                    degMax = 120;
                if(degMin == null)
                    degMin = -20;
                top = 201; 
                bottom = 13;
            }
            else {
                // deg c
                if(degMax == null)
                    degMax = 50;
                if(degMin == null)
                    degMin = -30;
                top = 203;
                bottom = 11;
                
            }
        }
		if(typeof value === "string")
			value = Number(value.trim());
		if((height - heightOffset) === 0)
				return;
		barRange = top - bottom; //height - heightOffset;
		
		
        if((degMin === null) ||(degMax === null))
            return;
        else if((degMin === "") ||(degMax === ""))
            return;
        else if(isNaN(degMin) ||isNaN(degMax))
            return;
        if(typeof degMin === "string")
            degMin = Number(degMin.trim());
        if(typeof degMax === "string")
            degMax = Number(degMax.trim());
        if((degMin === 0) && (degMax === 0))
            return;
        tempRange = degMax - degMin;
        if(tempRange === 0)
            return;
			
        if(value >= degMax)
            value = top;
        else if(value <= degMin)
            value = fBottom;
        else {
            value = value - degMin;
            value = value * barRange;
            value = value / tempRange;
            value += bottom;
        }
        element.style.height = value + "px";
	}
	catch {}
}
function createThermometerLines(min,max,delta, minorCount,minorClass, majorClass) {
	var sResult = "<ul>";
	var i,j;
	try {
		for(i=max; i >= min; i -= delta)
		{
			sResult += '<li class="' + majorClass + '"> </li>';
			if(i > min) {
				for(j=0; j < minorCount; j++)
				{
					sResult += '<li class="' + minorClass + '"> </li>';
				}
			}
		}
		sResult += "</ul>"
	}
	catch { sResult = "";}
	return sResult;
}
function createThermometerNumbers(min,max,delta,className) {
	var sResult = "<ul>";
	var i,j;
	try {
		for(i=max; i >= min; i -= delta)
		{
			sResult += '<li class="' + className + '">' + i.toString() + '</li>';
		}
		sResult += "</ul>"
	}
	catch { sResult = "";}
	return sResult;
}
function getDashboardGetEnums(mode) {
    try {
        var url;
        var element = document.getElementById("planningPaneDetails_Details");
        //if(element !== null)
        //    element.innerHTML = "<br><div id=\"gettingInfoId\" class=\"gettingInfo\">" + addWaitSpinner() + "</div>";
        if(g_dashboardGetSnvtTypes.length > 0) {
            url = "https://" + location.host + "/iap/dp/types?dpTypeName=" + g_dashboardGetSnvtTypes[0];
            g_dashboardGetSnvtTypes.shift();
		    requestGetData(mode, url, getDashboardGetEnumsResponse, getDashboardGetEnumsFailResponse);
        }
        else {
            // got all SNVT types so start dashboard
            if(g_sSiteDashboardSelected !== "") {
                //showDashboardDeviceDpListResponseForSiteDashboard(0, "", dashboardDpList); // not sure this is correct, may need to go to some other function
                obj = {};
                obj.mode = 1;
                obj.title = "Site";
                obj.templateType = "";
                obj.bAddDeviceName = false;
                dashboardDpList = JSON.parse(JSON.stringify(json));
                showDashboardUiBuildWebpage(obj);
            }
			else
                showDashboardUi(21, mode.mode, mode.json, "", g_bAddDeviceName);
        }
    }
    catch {}
}
function getDashboardGetEnumsResponse(mode, requestUrlString, json) {
	try {
		if(json.length > 0) 
		    g_snvtTypes.push(JSON.parse(JSON.stringify(json[0])));
		getDashboardGetEnums(mode);
	}
	catch(err) { }

}
function getDashboardGetEnumsFailResponse(mode, requestUrlString, json) {
    getDashboardGetEnums(mode);
}
function timerHandlerDashboard() {
    // used only once
    var i;
    g_bDashboardSvgInit = false;
    try {
        if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
            // mode: 1= timer    
            initializeSvgDashboard();
            for(i=0; i < g_dashboardChartList.length; i++)
            {
                if( g_dashboardChartList[i].iDynamicRangeCount > 0) {
                    g_dashboardChartList[i].iDynamicRangeCount --;
                    if(g_dashboardChartList[i].iDynamicRangeCount === 1) {
                        dashboardDetermineChartMinMaxValuesForChart(0, i, null, true);
                        g_dashboardChartList[i].iDynamicRangeCount = 0;
                    }
                }
                dashboardUpdateCharts(i, null, null);
            }

        }
    }
    catch (err) {}
    g_bDashboardNeedToInitializeSvg = false;
    g_bDashboardUpdateCharts = false;
    g_bDashboardDataLogGetInProgress = false;
}
function updateDashboardCharts(mode) {
    return; // no longer used
    var bContinue = true;
    try 
    {
        var i;
        if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
            // mode: 1= timer    
            if(g_bDashboardSvgInit) {
                bContinue = false;
                g_iDashboardInitiCount ++;
                if(g_iDashboardInitiCount > 2)  {
                    g_iDashboardInitiCount = 0;
                    g_bDashboardSvgInit = false;
                    initializeSvgDashboard();
                    if(g_bDashboardSupportLogData) {
                        bContinue = true;
                        g_bDashboardUpdateCharts = false;
                        g_bDashboardDataLogGetInProgress = false;
                    }
                }
            }
            
            if(bContinue) {
                
                for(i=0; i < g_dashboardChartList.length; i++)
                {
                    if( g_dashboardChartList[i].iDynamicRangeCount > 0) {
                        g_dashboardChartList[i].iDynamicRangeCount --;
                        if(g_dashboardChartList[i].iDynamicRangeCount === 1) {
                            dashboardDetermineChartMinMaxValuesForChart(0, i, null, true);
                            g_dashboardChartList[i].iDynamicRangeCount = 0;
                        }
                    }
                    dashboardUpdateCharts(i, null, null);
                }
                
            }
        }
    }
    catch {}
}
