/*
	menu.js (version 0.019) 
	
	_menuDpValueSave() - used to write new value

 *	Copyright (C) 2023 EnOcean GmbH.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	EnOcean Example Software License Agreement which is available at
 *	https://enoceanwiki.atlassian.net/wiki/spaces/LON/pages/2425260/Example+Software+License+Agreement.  

	This code is used to show the Priority array popup


*/
var g_menuDivPermissions = [];
var g_bDatapointMenuShowPreset = false;
var g_iMenuDpCurrentPage = 1;
var g_iMenuDpPageSize = 50;
var g_iMenuDpCount = 0;
var g_bGetOptomizedData = true;
var g_bSortOptomizedData = true;
var g_oCmsOptomizedData = null; //contains the names of blockinsdexs, blocknames, datapoint Names, datapoint types,datapointXNames, deviceNames and device types
var g_oProtocols = null;
function alarmMenu(mode,n,index,displayElementIndex,displayId, programmaticPathname) {
	// call menuDpValue with radio button showing alarm only
	//mode: 0= show all (value and priority array), 1= no priority array, 2 =show only priority array 3=show only alarm

	//pathname is programmatic pathname
	try { 
		//var event1 = window.event;
		var x = 0; // = event.clientX;
		var y = 0;// = event.clientY;
		var menuContent = "",pathname,displayIdPath;
		var bContinue = false;
		var offsets;
		var value = null;
		var values = null, levels = null;
		var dpIndex;
		var presets = null;
		var obj = null,iPtr;
		var menuDivXOffset = 30;//-250;
		var menuDivYOffset = 20;
		var menuDivWidth = 150;
		g_bInoreMouseClick = true;
		g_bAlwaysIngnoreMouseClick = true; // needed otherwise clicking dropdown will close window
		menuStructuredDpDialogCancel();
		if(index >= dashboardDpList.length)
			return;
		if(dashboardDpList[index].programmaticPathname !== programmaticPathname) 
			return;
		if(displayElementIndex >= dashboardDpList[index].displayElements.length)
			return;
		
		if(mode === 1) {
			//use menudpvalue function
			return;
		}

		cursorClearWait();
			// check dpIndex
		if(index < dashboardDpList.length) {
			if(dashboardDpList[index].programmaticPathname === programmaticPathname) {
				
				bContinue = true;
				//dpObj = dashboardDpList[index];
				pathname = dashboardDpList[index].pathname;
			}
		}
		else
			return;
		iPtr = displayId.indexOf("_");
		if(iPtr === -1)
			return;
		if((iPtr + 1) > displayId.length)
			return;
		displayIdPath = displayId.substr(iPtr + 1);
	
		if(dashboardDpList[index].displayElements[displayElementIndex].displayId !== displayIdPath)
			return;
		
		if(!bContinue){
			showAlertDialog(0,"DP Path doesn't match DP index\r\n\r\n" + programmaticPathname)
			return;
		}
		menuContent = "<div class=\"menuDivBorder\">";
		menuContent += "<div>";
		menuContent += "<div class=\"menuDivName\">";
		iPtr = pathname.indexOf("/");
		if(iPtr === -1)
			menuContent += pathname;
		else
			menuContent += pathname.substr(iPtr + 1);
		menuContent += "</div>";
		menuContent +="<button style=\"float:right\" onclick=\"menuDivClose()\">X</button>";
		menuContent += "</div>";
		

		menuContent += "<br><br><div style=\"width:100%\"<h3 style=\"align-text:center\">Active Alarm</h3>";
		if(dashboardDpList[index].alarm.Id !== -1)
			menuContent += "<button style=\"float:right\" onclick=\"clearDpAlarm(0," + index + "," + dashboardDpList[index].alarm.id + ",'" + displayId + "','" + programmaticPathname + "')\">Clear Alarm</button>";
		
		
		menuContent += "</div>";
		menuContent += "<br><br>";
		menuContent += "<table style=\"border-top: 1px solid black\"><tr ><td>Alarm</td><td>" + dashboardDpList[index].alarm.warningMessage + "</td></tr>";
		menuContent += "<tr><td>Trigger value</td><td>" + dashboardDpList[index].alarm.warningValue + "</td></tr>";
		menuContent += "<tr><td>Current value</td><td>";
		
		if((dashboardDpList[index].displayElements[displayElementIndex].field === "") && (dashboardDpList[index].presetValue !== "")) {
			menuContent +=   dashboardDpList[index].presetValue  + "</td></tr><tr><td>Current value (raw)</td><td>"
		}
		menuContent += dashboardDpList[index].locValueStr;
		menuContent += "</td></tr></table>";
		
		
		
		var menuButton = document.getElementById(displayId);
		
		if(menuButton !== null) {
			offsets = menuButton.getBoundingClientRect(); 
			if((offsets.x + offsets.width + window.pageXOffset + menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
				x = offsets.x + window.pageXOffset - menuDivWidth - 10; // takes into account viewport (scrolling)
			else
				x = offsets.x + offsets.width + window.pageXOffset + menuDivXOffset; // takes into account viewport (scrolling)
			
			y = offsets.y + window.pageYOffset - menuDivYOffset; // takes into account viewport (scrolling)
			if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
				x += menuDivXOffset;
				y -= 70;
			}
			else if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
				x += menuDivXOffset;
				y -= 70;
			}
			document.getElementById("menuDiv").style.left = x.toString() + "px";
			document.getElementById("menuDiv").style.top = y.toString() + "px";
			document.getElementById("menuDiv").innerHTML = menuContent;
			document.getElementById("menuDiv").className = "menuDivDpValueShow";  // doesn't currently guaranty that menu is shown in viewport

			g_bInoreMouseClick = true;
			//document.addEventListener("click", menuMouseCancel);
			//document.addEventListener("click", function() {menuMouseCancel(event);});
			//menuContent = "";
			
			
			//document.getElementById("menuDiv").innerHTML += menuContent;
			
		}
		else 
			return;

		
	} catch {}
}
function clearDpFilter(mode, index, displayMode) {
	if((mode === 0) || (mode === 1)) {
		if((index === 0) || (index === 1)) {
			g_oDeviceFilter.smartServer = "";
			if(displayMode === 1) {
			//	document.getElementById("menuDpFilterSmartServer").value = "";
			}
		}
		if((index === 0) || (index === 2)) {
			g_oDeviceFilter.protocol = "";
			if(displayMode === 1) {
				document.getElementById("menuDpFilterProtocol").value = "";
			}
		}
		if((index === 0) || (index === 3)) {
			g_oDeviceFilter.deviceType = "";
			if(displayMode === 1) {
				document.getElementById("menuDpFilterDeviceType").value = "";
			}
		}
		if((index === 0) || (index === 11)) {
			g_oDeviceFilter.deviceStatus = "";
			if(displayMode === 1) {
				document.getElementById("menuDpFilterDeviceStatus").value = "";
			}
		}
		if((index === 0) || (index === 4)) {
			g_oDeviceFilter.device = "";
			if(displayMode === 1) {
				document.getElementById("menuDpFilterDevice").value = "";
			}
		}
		
	}
	if((mode === 0) || (mode === 2)) {
		if((index === 0) || (index === 1)) {
			g_oDpFilter.smartServer = "";
			if(displayMode === 1) {
			//	document.getElementById("menuDpFilterSmartServer").value = "";
			}
		}
		if((index === 0) || (index === 2)) {
			g_oDpFilter.protocol = "";
			if(displayMode === 1) {
				document.getElementById("menuDpFilterProtocol").value = "";
			}
		}
		if((index === 0) || (index === 3)) {
			g_oDpFilter.deviceType = "";
			if(displayMode === 1) {
				document.getElementById("menuDpFilterDeviceType").value = "";
			}
		}
		if((index === 0) || (index === 4)) {
			g_oDpFilter.device = "";
			if(displayMode === 1) {
				document.getElementById("menuDpFilterDevice").value = "";
			}
		}
		if((index === 0) || (index === 5)) {
			g_oDpFilter.blockName = "";
			if(displayMode === 1) {
				document.getElementById("menuDpFilterBlockName").value = "";
			}
		}
		if((index === 0) || (index === 6)) {
			g_oDpFilter.blockIndex = "";
			if(displayMode === 1) {
				document.getElementById("menuDpFilterBlockIndex").value = "";
			}
		}
		if((index === 0) || (index === 7)) {
			g_oDpFilter.datapointName = "";
			if(displayMode === 1) {
				document.getElementById("menuDpFilterDatapoint").value = "";
			}
		}
		if((index === 0) || (index === 8)) {
			g_oDpFilter.override = "";
			if(displayMode === 1) {
				document.getElementById("menuDpFilterOverride").value = "";
			}
		}
		if((index === 0) || (index === 9)) {
			g_oDpFilter.priority = "";
			if(displayMode === 1) {
				document.getElementById("menuDpFilterPriority").value = "";
			}
		}
		if((index === 0) || (index === 10)) {
			g_oDpFilter.datapointType = "";
			if(displayMode === 1) {
				document.getElementById("menuDpFilterDatapointType").value = "";
			}
		}
		if((index === 0) || (index === 12)) {
			g_oDpFilter.direction = "";
			if(displayMode === 1) {
				document.getElementById("menuDpFilterDirection").value = "";
			}
		}
	}
}
function createMenuSwitchLedElements(mode, displayId, displayType, value) {
    try {
        var content = "";
        if(displayType === "s2") {
            // boolean or binary slider switch
			content += "<div style=\"display:flex\">";
            content += "<td class=\"<div id=\"sliderSwitch_" +  displayId  + "\" style=\"display:flex\">";
            content += "<label class=\"sliderSwitch\" ><input type=\"checkbox\"";
            content += " id=\"localValueSwitch_" + displayId + "\" class=\"sliderInput\" ";
            if(value === null) {
                
            }
            else if(typeof value === "number") {
                if(value === 1)
                    content += ' checked';
            }
            else if(typeof value === "boolean") {
                
                if(value)
                    content += ' checked';
            
            }
            content += '><span id="localValueSpan_' + displayId + '" class="sliderSlider sliderRound"></span></label>'
            content +=  '</div>';
            
        }
        else if(displayType === "s3") {
            // SNVT_switch slider switch value and state
			
            content += "<div style=\"display:flex\">";
            content += "<div id=\"sliderSwitch_" +  displayId  + "\" style=\"width:70px\">";
            content += "<label class=\"sliderSwitch\" ><input type=\"checkbox\"";
            content += " id=\"localValueSwitch_" + displayId + "\" class=\"sliderInput\" ";
            if(value === null) {
                
            }
            else if(value.state === 1)
                content += ' checked';
            
            content += '><span id="localValueSpan_' + displayId + '" class="sliderSlider sliderRound"></span></label></div>'
            content += '<div><input id="localValue_' + displayId + '" style="width:30px;"';
            if(value === null) {
                
            }
            else  
                content += 'value="' + value.value.toString() + '"';
            content += '></div>';
            content +=  '</div>';
            
        }
        else if(displayType === "s4") {
            // SNVT_switch Slider uses state only
            content += "<div id=\"sliderSwitch_" +  displayId  + "\" style=\"display:flex\">";
            content += "<label class=\"sliderSwitch\" ><input type=\"checkbox\"";
            content += " id=\"localValueSwitch_" + displayId + "\" class=\"sliderInput\" ";
            if(value === null) {
                
            }
            else if(value.state === 1)
                    content += ' checked';
            
            content += '><span id="localValueSpan_' + displayId + '" class="sliderSlider sliderRound"></span></label>'
            content +=  '</div>';
            
        }
        else if(displayType === "l2") {
            // led binary
            content += "<div style=\"display:flex\">";
            content += '<span id="localValueSwitch_' + displayId + '"'; 
            if(value === null) {
                
            }
            else if(typeof value === "number") {
                if(value === 0)
                    content += ' class="ledDotOff"';
                else 
                    content += ' class="ledDotOn"';
            }
            else if(typeof value === "boolean") {
                
                if(value)
                    content += ' class="ledDotOn"';
                else 
                    content += ' class="ledDotOff"';
            }
            content += '></span>';
            content += '</div>';
        }
        else if(displayType === "l3") {
            // Led SNVT_switch value and state
            content += "<div style=\"display:flex\">";
            content += "<div id=\"sliderSwitch_" +  displayId  + "\" style=\"width:70px\">"
            content += '<span id="localValueSwitch_' + displayId + '"'; 
            if(value === null) {
                
            }
            else if(value.state === 1)
                content += ' class="ledDotOn"';
            else 
                content += ' class="ledDotOff"';
            
            content += '></span></div>';
            content += '<div id="localValue_' + displayId + '" style="width:30px;">';
            if(value !== null)   
                content += value.value.toString();
            content += '</div>'; 
            content += '</div>';
        }
        else if(displayType === "l4") {
            // Led SNVT_switch state only -- e.g., IOX
            content += "<div style=\"display:flex\">";
            content += '<span id="localValueSwitch_' + displayId + '"'; 
            if(value === null) {
                
            }
            else if(value.state === 1)
                content += ' class="ledDotOn"';
            else 
                content += ' class="ledDotOff"';
            
            content += '>';
            content += '</span></div>';
            
        }
    }
    catch {}
	return content;
}
function colorMenu(mode,n, displayId) {
	// call menuDpValue with radio button showing alarm only
	//mode: 0= show all (value and priority array), 1= no priority array, 2 =show only priority array 3=show only alarm

	//pathname is programmatic pathname
	try { 
		//var event1 = window.event;
		var x = 0; // = event.clientX;
		var y = 0;// = event.clientY;
		var menuContent = "",pathname,displayIdPath;
		var offsets;
		var i,j = 0;
		var iPtr;
		var element, color, colors;
		var colorList = ["#51a7f9","#70bf41","#f5d328","#f39019","#ec5d57","#b36ae2", 
							"#0365c0","#00882b","#dcbd23","#de6a10","#c82506","#773f9b",
							"#164f86","#0b5d18","#c3971a","#bd5b0c","#861001","#5f327c",
							"#002452","#054109","#a37512","#924607","#570706","#3b1f4e",
							"#ffffff","#dcdee0","#a6aaa9","#727272","#53585f","#000000"]
	
		element = document.getElementById(displayId);
		if(element === null)
			return;
		color = element.style.backgroundColor;
		iPtr = color.indexOf("rgb(");
		if(iPtr !== -1) {

			color = color.substr(4,color.length - 5 );
			colors = color.split(",");
			if(colors.length === 3)
				color = "#" + Number(colors[0]).toString(16).padStart(2,0) + Number(colors[1]).toString(16).padStart(2,0)  + Number(colors[2]).toString(16).padStart(2,0);

		}
		menuContent = "<div class=\"menuDivBorder\">";
		menuContent += "<div>";
		menuContent += "<div id=\"menuDivHeader\" class=\"menuDivName menuDivDpValueShowDragDivHeader\">";
		menuContent += "Color:</div><br><br>";
		menuContent += "<div id=\"colorId\" style=\"background-color:" + color + "\">" + color + "</div>"
		menuContent += "<div>";
		for(i=0; i < colorList.length; i++ )
		{
			menuContent += "<div class=\"colorDiv\" style=\"background-color:" + colorList[i] + "\" onclick=\"colorMenuColorClicked('" + colorList[i] + "')\"></div>";
			j++;
			if(j > 5) {
				menuContent += "<br>";
				j = 0;
			}
		}
		menuContent += "</div>";
		menuContent += "<br>";
		menuContent += "<div style=\"margin-left:100px\">";
		menuContent +="<button onclick=\"menuDivClose()\">Cancel</button>";
		menuContent +="<button onclick=\"colorMenuSelect('" + displayId + "')\">Select</button>";
		menuContent += "</div>";
		menuContent += "</div>";
		menuContent += "</div>";


		
		var menuButton = document.getElementById(displayId);
		
		if(menuButton !== null) {
			offsets = menuButton.getBoundingClientRect(); 
			x = offsets.x + window.pageXOffset; // takes into account viewport (scrolling)
			
			
			y = offsets.y + window.pageYOffset; // takes into account viewport (scrolling)
			
			document.getElementById("menuDiv").style.left = x.toString() + "px";
			document.getElementById("menuDiv").style.top = y.toString() + "px";
			document.getElementById("menuDiv").innerHTML = menuContent;
			document.getElementById("menuDiv").className = "menuDivColorShow";  // doesn't currently guaranty that menu is shown in viewport
			dragDiv("menuDiv");
			g_bInoreMouseClick = true;
			
			
		}
		else 
			return;

		
	} catch {}
}

function colorMenuColorClicked(color) {
	var textColor = "";
	var element = document.getElementById("colorId");
	try {
		if (element !== null) {
			element.style.backgroundColor = color;
			element.innerHTML = color;
			textColor = determineTextColorBasedOnDarkness(color)
			element.style.textColor = textColor;
		}
	}
	catch{}
}
function colorMenuSelect(displayId) {
	var element = document.getElementById("colorId");
	var color
	try {
		if (element !== null) {
			color = element.innerHTML;
			element = document.getElementById(displayId);
			if(element !== null) {
				element.style.backgroundColor = color;
				menuDivClose();
			}
		}
	}
	catch{}
}
function dragDiv(divName) {
	try {
		var g_dragCoord = {x:0, y:0};
		var g_dragDiv = document.getElementById(divName);
		if(g_dragDiv === null)
			return;
		if (document.getElementById(divName + "Header")) {
		/* if present, the header is where you move the DIV from:*/
		document.getElementById(divName + "Header").onmousedown = dragMouseDown;
		} else {
		/* otherwise, move the DIV from anywhere inside the DIV:*/
		g_dragDiv.onmousedown = dragMouseDown;
		}
	
		function dragMouseDown(e) {
		if(g_dragDiv === null)
			return;  
		e = e || window.event;
		e.preventDefault();
		// get initial mouse xy
		g_dragCoord.x = e.clientX;
		g_dragCoord.y = e.clientY;
		document.onmouseup = closeDragElement;
		// call a function whenever the cursor moves:
		document.onmousemove = elementDrag;
		}
	
		function elementDrag(e) {
		var x,y
		if(g_dragDiv === null)
			return;
		e = e || window.event;
		e.preventDefault();
		// determin new value:
		x = g_dragCoord.x - e.clientX;
		y = g_dragCoord.y - e.clientY;
		g_dragCoord.x = e.clientX;
		g_dragCoord.y = e.clientY;
		// set the element's new position:
		g_dragDiv.style.top = (g_dragDiv.offsetTop - y) + "px";
		g_dragDiv.style.left = (g_dragDiv.offsetLeft - x) + "px";
		}
	
		function closeDragElement() {
		// remove mouse event when mouse button released
		document.onmouseup = null;
		document.onmousemove = null;
		
		
		}
	}
	catch {}
}
function menuDivClose() {
	try {
		document.getElementById("menuDiv").className = "menuDivHide";
		document.getElementById("menuOverlayDiv").className = "menuOverlayDivHide";
		g_dragDiv = null;
	}
	catch {}
}
function menuDivClose1() {
	try {
		g_idpGetPropertiesRequestCount = g_idpGetPropertiesRequestMaxCount + 2;  // active priorities may have been removed so check 
		document.getElementById("menuDiv").className = "menuDivHide";
		document.getElementById("menuOverlayDiv").className = "menuOverlayDivHide";
		g_dragDiv = null;
	}
	catch {}
}

function menuDatapoints(mode) {
	// mode: 0=all dps, 1=CurrentDpList, 2=show fav dps, 6=show paneTitle and exit,
	
	try { 
		//var event1 = window.event;
		var x = 0; // = event.clientX;
		var y = 0;// = event.clientY;
		var menuContent = "", paneConent="";
		var offsets;
		var i,j = 0;
		var iPtr;
		var element;
		var menuButton;
		var url;
		
		g_favDpList = [];
		g_dpList = [];
		g_bMenuDatapointsShowSelected = false;
		
		
		menuContent = "<div class=\"menuDivBorder\">";
		menuContent += "<div style=\"margin-left:50px;float:right\"><button  onclick=\"menuDatapointsClose()\">X</button></div>";
		menuContent += "<div id=\"testDivHeader\" class=\"menuDivName menuDivDpValueShowDragDivHeader\">";
		menuContent += "Selected Datapoints: <span id=\"menuDatapointCount\">0</span>";
		menuContent += "</div>";
		menuContent += "<div>";
		
		
		menuContent += "<br><br>";
		
		menuContent += "<button id=\"menuDpFilterButton\" onclick=\"menuDpFilter(2)\">Search</button>";
		menuContent += "<div id=\"menuDatapointsFilters\" style=\"display:inline-block\"></div>";
		menuContent += "<input type=\"checkbox\" id=\"autoSubscribeCheckbox\"  onchange=\"menuDatapointsShowSelected()\"><span>Show Selected</span>"
		//menuContent +="<button style=\"margin-left:30px\" onclick=\"menuDpFilterShowDatapointList(2, '', [])\">Show Selected</button>";
		menuContent += "<div style=\"float:right\"><button id=\"menuDpFilterButton\" onclick=\"menuDatapointsSave()\">Save</button></div>";
		
		menuContent += "</div>";
		menuContent += "<div id=\"datapointListDiv\" class=\"menuDivDatapointsListDiv\"><br><br><div style=\"text-align:center\"Getting datapoints ....</div></div>";
		menuContent += "</div>";
		menuContent += "<div class=\"menuBottomDivDp\"></div>"; //required for footer

		
		//menuButton = document.getElementById("planningDiv");
		menuButton = document.getElementById("scheduleCreateDiv");
		
		if(menuButton !== null) {
			offsets = menuButton.getBoundingClientRect(); 
			x = offsets.x + window.pageXOffset; // takes into account viewport (scrolling)
			
			
			y = offsets.y + window.pageYOffset; // takes into account viewport (scrolling)
			
			document.getElementById("testDiv").style.left = x.toString() + "px";
			document.getElementById("testDiv").style.top = (y + 20).toString() + "px";
			document.getElementById("testDiv").innerHTML = menuContent;
			document.getElementById("testDiv").className = "menuDivDatapointsShow";  // doesn't currently guaranty that menu is shown in viewport

			g_bInoreMouseClick = true;
			menuOverlayDivShow(3, null);
			dragDiv("testDiv");
			
		}
		else 
			return;

		if((g_oDpFilter.smartServer === "") && (g_oDpFilter.protocol === "") && (g_oDpFilter.deviceType === "") && (g_oDpFilter.device === "")
			&& (g_oDpFilter.blockName === "") && (g_oDpFilter.blockIndex === "") && (g_oDpFilter.datapointName === "")
			&& (g_oDpFilter.override === "") && (g_oDpFilter.datapointType === "") && (g_oDpFilter.priority === "")) {
				menuDpFilterShowDatapointList(0,"",[]);
		}
		else {
			menuDpFilterShowDps(1);
			
		}
		
	} catch {}

return;





	//ivbWsProcessDatapointUpdate = true;
	if(mode === 1)
		paneTitle = "<label id=\"displayLabel\">Device Datapoints</label><span id=\"dpCount\"></span>";
	else if(mode === 2) {
		paneTitle = "<label id=\"displayLabel\">Favorite Datapoints</label><span id=\"dpCount\"></span>";
		g_iMainDisplayMode = DISPLAYMODE_FAVDPS;
	}
	paneTitle += "<button onclick=\"getOnDemandDpValuesRequest(1)\" style=\"float:right\">Refresh</button>";
	paneTitle += "<button onclick=\"subscribeRequest()\" style=\"float:right\">re-Subscribe</button>";
	paneTitle += "<button onclick=\"getOnDemandDpValuesRequest(3)\" style=\"float:right\">On Demand</button>";
	paneTitle += "<div style=\"float:right\">";
	paneTitle += "<input type=\"checkbox\" id=\"autoSubscribeCheckbox\"  onchange=\"autoSubscribeCheckBox()\"";
	if(g_bAutoSubscribe)
		paneTitle += " checked";
	paneTitle += ">Auto Subscribe";
	
	
	
	//paneTitle +=  "<input type=\"checkbox\" id=\"additionalInfoCheckbox\"  onchange=\"showAllDpAdditionalInfoCheckBox()\">Additional Ifo";
	if(mode === 2) {
		paneTitle += "<button onclick=\"showDashboard(3,'Favorites',-1)\">Dashboard</button>";
		paneTitle += "<button onclick=\"showDataLog0(1)\">Data Logs</button>";
		paneTitle += "<button onclick=\"showAllDpsGetFavoriteClear()\">Clear</button>";
		paneTitle += "<button onclick=\"showAllDpsGetFavoriteDps(0)\">Get BrowserFav</button>";
		paneTitle += "<button onclick=\"showAllDpsReplaceFavoriteDps('BrowserFav')\">Save BrowserFav</button>";
		paneTitle += "<button id=\"favsButton\" onclick=\"menuCmsDpFavorites()\">FAVs Menu</button>";
	}
	else {
		paneTitle += "<button onclick=\"showDashboard(2,'Datapoints',-1)\">Dashboard</button>";
		paneTitle += "<button onclick=\"showDataLog0(0)\">Data Logs</button>";
		paneTitle += "<button id=\"menuDpFilterButton\" onclick=\"menuDpFilter(2)\">Get DPs by Filter</button>";
		//if(((mode === 0) || (mode === 1)) && (g_bShowGetAllDatapoints))
		//	paneTitle += "<button id=\"getAllDatapointsButton\" onclick=\"showAllDps(0)\">Get All Datapoints</button>";
	}
/*
	paneTitle += "<input type=\"checkbox\" id=\"pollCheckbox\"  onchange=\"pollCheckBox()\"";
	

	if(mode === 2) {
		if(g_bFavoritesPollingEnabled)
			paneTitle += " checked";
	}
	else {
		if(g_bDatapointsPollingEnabled)
			paneTitle += " checked";
	}
	
	paneTitle += ">Poll";
	if(mode === 2) {
		paneTitle += "<input id=\"pollrate\" onchange=\"pollCheckBox()\" value=\"" + g_iFavoritesPollInterval + "\" size=\"4\"></div>";
	}
	else {
		paneTitle += "<input id=\"pollrate\" onchange=\"pollCheckBox()\" value=\"" + g_iDatapointsPollInterval + "\" size=\"4\"></div>";
		//paneTitle += "<input id=\"pollrate\" value=\"30\" size=\"4\"></div>";
	}
	*/
	
	var paneContent = "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting DP Info ...</span></div>";
	document.getElementById("main-Header").innerHTML = paneTitle;
	document.getElementById("main").innerHTML = paneContent;

	g_PollingType = DISPLAYMODE_NONE;	
	if(mode === 6)
		return;
	if(mode === 0) {
		g_iMainDisplayMode = DISPLAYMODE_DPS;
		getOnDemandDpValues(0, "/iap/devs/*/if/*/*/*/*")
	}
	else if(mode === 1){
		g_iMainDisplayMode = DISPLAYMODE_DPS;
		if((dpList === null) || (dpList.length === 0))
			document.getElementById("main").innerHTML = "<span id=\"gettingInfoId\" class=\"gettingInfo\">No Datapoints selected</span>"; 
		else {
			createRequestString(dpList);
			showDatapointList(dpList);
			g_PollingType = DISPLAYMODE_DPS;
			pollCheckBox();
		}
	}
	else if (mode === 2) {
		g_iMainDisplayMode = DISPLAYMODE_FAVDPS;
		if((favDpList === null) || (favDpList.length === 0))
			document.getElementById("main").innerHTML = "<span id=\"gettingInfoId\" class=\"gettingInfo\">No Datapoints selected</span>"; 
		else {
			createRequestString(favDpList);
			showDatapointList(favDpList);
			g_PollingType = DISPLAYMODE_FAVDPS;	
			pollCheckBox();
		}
	}
}

function menuDatapointsClose() {
	g_bDatapointMenuShowPreset = false;
	testDeviceCancel();
	menuDivClose();
	// for schedule datapoints
	scheduleShowEditEventFullCheck(2);
}
function menuDatapointSave(pathname){
	// save single datapoint to schedule
	try {
		var i,z=-1;
		var element = document.getElementById("favrow_" + pathname);
		if(element != null) {
			element.style.backgroundColor = "lightgrey";
			element = document.getElementById("favcheck_" + pathname);
			if(element != null) {
				element.innerHTML = "";
				element = document.getElementById("favadd_" + pathname);
				if(element != null) {
					element.innerHTML = "";
					for(i=0; i < g_menuDatapointsEventDatapoints.length; i++ )
					{
						if(pathname === g_menuDatapointsEventDatapoints[i]) {
							z = i;
							break;
						}
					}
					if(z === -1) {
						//add to schedule list
						scheduleShowEditEventAddFavDpListToScheduleDatapoints(pathname);
					}
				}
			}
		}
	}
	catch {}
	
}
function menuDatapointsSave(){
	g_bDatapointMenuShowPreset = false;
	testDeviceCancel();
	scheduleShowEditEventAddFavDpsListToScheduleDatapoints()
}
function menuDatapointsShowSelected() {
	if(g_bMenuDatapointsShowSelected) {
		g_bMenuDatapointsShowSelected = false;
		menuDpFilterShowDatapointList(3, '', []);
	}
	else {
		g_bMenuDatapointsShowSelected = true;
		menuDpFilterShowDatapointList(2, '', [])
	}
}
function menuDatapointsFiltersList() {
	sResult = "";
	try {
		/*
		document.getElementById("menuDpFilterProtocol").value = g_oDpFilter.protocol;
		document.getElementById("menuDpFilterDeviceType").value = g_oDpFilter.deviceType;
		document.getElementById("menuDpFilterDevice").value = g_oDpFilter.device;
		document.getElementById("menuDpFilterBlockName").value = g_oDpFilter.blockName;
		document.getElementById("menuDpFilterBlockIndex").value = g_oDpFilter.blockIndex;
		document.getElementById("menuDpFilterDatapoint").value = g_oDpFilter.datapointName;
		document.getElementById("menuDpFilterOverride").value = g_oDpFilter.override; 
		document.getElementById("menuDpFilterPriority").value = g_oDpFilter.priority; */
		if(g_oDpFilter.datapointType !== "")
			sResult += "<div id=\"dpFilter_dptype\"><span style=\"margin-left:10px;\">Dp Type:" + g_oDpFilter.datapointType + "</span><button onclick=\"clearDpFilterParameter('dptype')\">X</button></div>";
		document.getElementById("menuDpFilterDatapointType").value = g_oDpFilter.datapointType;
		if(g_oDpFilter.direction !== "")
			sResult += "<div id=\"dpFilter_direction\"><span style=\"margin-left:10px;\">Dp Type:" + g_oDpFilter.direction + "</span><button onclick=\"clearDpFilterParameter('direction')\">X</button></div>";
		document.getElementById("menuDpFilterDatapointType").value = g_oDpFilter.direction;
	}
	catch {}
	return sResult;
}
function clearDpFilterParameter(filter) {
	try {
		if(filter === "dptype") {
			g_oDpFilter.datapointType = "";
			document.getElementById("dpFilter_dptype").style.display = "none";
		}
		if(filter === "direction") {
			g_oDpFilter.direction = "";
			document.getElementById("dpFilter_direction").style.display = "none";
		}
	}
	catch {}
}
function menuDpFilter(mode) {

	try {
		var url
		var x = 0; // = event.clientX;
		var y = 0;// = event.clientY;
		var filter = "";
		var menuContent = "";
		var offsets;
		var menuDivWidth;
		var menuButton;
		if(g_bGetOptomizedData && (g_oCmsOptomizedData === null)) {
			
		
			g_bAlwaysIngnoreMouseClick = false;
			g_menuDivXOffset = 30;
			g_menuDivYOffset = 20;
			
			menuContent = "<div class=\"menuDivBorder\">";
			menuContent += "<button  onclick=\"menuDivClose()\" style=\"float:right\">X</button>";
			menuContent += "<div id=\"menuDivHeader\" class=\"menuDivName menuDivDpValueShowDragDivHeader\">";
			if(mode === 1)
				menuContent += "Device Filter";
			else 
				menuContent += "Datapoint Filter";
			
			menuContent += "</div>";
			menuContent += "<div class=\"gettingInfoSpinnerLog\" style=\"width:100%\">" + addWaitSpinner(1) + "</div>";
			menuContent += "<br><br>";
			menuContent += "</div>";
			menuButton = document.getElementById("menuDpFilterButton");
			if(menuButton !== null) {
				offsets = menuButton.getBoundingClientRect(); 
				document.getElementById("menuDiv").innerHTML = menuContent;
			}
			if(g_oProtocols === null) {
				url = "https://" + location.host + "/iap/protocols?sortBy=userName&sortOrder=asc";
				requestGetData(mode, url, menuDpFilterGetProtocolsResponse, menuDpFilterGetProtocolsFailResponse);
			}
			else {
				url = "https://" + location.host + "/iap/blocks/optimizedInfo";
				requestGetData(mode, url, menuDpFilterGetOptimizedInfoResponse, menuDpFilterGetOptimizedInfoFailResponse); 
			}
		}
		else 
			menuDpFilter1(mode);
	}
	catch {}
}
function menuDpFilterGetProtocolsResponse(mode, requestUrl, json) {
	try {
		var url = "https://" + location.host + "/iap/blocks/optimizedInfo";
		if(json !== null) {
			g_oProtocols = [];
			g_oProtocols = JSON.parse(JSON.stringify(json));
		}
		requestGetData(mode, url, menuDpFilterGetOptimizedInfoResponse, menuDpFilterGetOptimizedInfoFailResponse);
	}
	catch {}
}
function menuDpFilterGetProtocolsFailResponse(mode, requestUrl, json) {
	try {
		var url = "https://" + location.host + "/iap/blocks/optimizedInfo";
		requestGetData(mode, url, menuDpFilterGetOptimizedInfoResponse, menuDpFilterGetOptimizedInfoFailResponse);
	}
	catch {}
}
function menuDpFilterGetOptimizedInfoResponse(mode, requestUrl, json) {
	try {
		var i,x,temp, temp1, bContinue = true, bChanged,objs;
		if(json !== null) {
			g_oCmsOptomizedData = JSON.parse(JSON.stringify(json));
			if(g_bSortOptomizedData) {
				for(x in g_oCmsOptomizedData)
				{
					bContinue = true;
					bChanged = false;
					while(bContinue)
					{
						objs = g_oCmsOptomizedData[x];
						bContinue = false;
						for(i=0; i < (objs.length - 1); i++)
						{
							if(objs[i] > objs[i + 1]) {
								bChanged = true;
								temp = objs[i];
								objs[i] = objs[i + 1];
								objs[i + 1] = temp;
								bContinue =true;
							}
						}
					}
				}
			}
			menuDpFilter1(mode);
		}
	}
	catch {}

}
function menuDpFilterGetOptimizedInfoFailResponse(mode, requestUrl, json) {
	try {
		menuDpFilter1(mode);
	}
	catch {}
}

function menuDpFilter1(mode) {
	try { 
		//var event1 = window.event;
		var x = 0; // = event.clientX;
		var y = 0;// = event.clientY;
		var x1;
		var filter = "";
		var menuContent = "";
		var offsets;
		var menuDivWidth;
		var menuButton;
		
		g_bAlwaysIngnoreMouseClick = false;
		g_menuDivXOffset = 30;
		g_menuDivYOffset = 20;
		
		menuContent = "<div class=\"menuDivBorder\">";
		menuContent += "<button  onclick=\"menuDivClose()\" style=\"float:right\">X</button>";
		menuContent += "<div id=\"menuDivHeader\" class=\"menuDivName menuDivDpValueShowDragDivHeader\">";
		if(mode === 1)
			menuContent += "Device Filter";
		else 
			menuContent += "Datapoint Filter";
		
		menuContent += "</div>";
		menuContent += "<br><br><table class=\"tableTop\">";
		if(g_oCmsOptomizedData === null) {
			//menuContent += "<tr><td>SmartServer</td><td><span id=\"menuDpFilterSmartServer\" class=\"tdValueFilter\"></span></td><td><button onclick=\"clearDpFilter(" + mode + ", 1, 1)\">X</button></td></tr>";
			menuContent += "<tr><td>Protocol</td><td><input id=\"menuDpFilterProtocol\" class=\"tdValueFilter\"></td><td><button onclick=\"clearDpFilter(" + mode + ", 2, 1)\" >X</button></td></tr>";
			menuContent += "<tr></tr><tr><td>Override</td><td><select id=\"menuDpFilterOverride\" class=\"tdValueFilter\">";
			menuContent += "<option value=\"\">None</option><option value=\"active\">Active</option><option value=\"notactive\">Not Active</option>";
			menuContent += "</select></td><td><button onclick=\"clearDpFilter(" + mode + ", 8, 1)\">X</button></td></tr>";
			if(mode === 2) {
				menuContent += "<tr><td>Priority (1 - 16)</td><td><input id=\"menuDpFilterPriority\" class=\"tdValueFilter\"></td><td><button onclick=\"clearDpFilter(" + mode + ", 9, 1)\">X</button></td></tr>";
			
				menuContent += "<tr><td>SNVT Type</td><td><input id=\"menuDpFilterDatapointType\" class=\"tdValueFilter\"></td><td><button onclick=\"clearDpFilter(" + mode + ", 10, 1)\">X</button></td></tr>";
				menuContent += "<tr style=\"display:none\"><td >Direction</td><td><input id=\"menuDpFilterDirection\" class=\"tdValueFilter\"></td><td><button onclick=\"clearDpFilter(" + mode + ", 12, 1)\">X</button></td></tr>";
			}
			menuContent += "<tr><td>Device Type</td><td><input id=\"menuDpFilterDeviceType\" class=\"tdValueFilter\"></td><td><button onclick=\"clearDpFilter(" + mode + ", 3, 1)\">X</button></td></tr>";
			if(mode == 1) {
				menuContent += "<tr><td>Device Status</td><td><select id=\"menuDpFilterDeviceStatus\" class=\"tdValueFilter\">";
				menuContent += "<option value=\"\">None</option><option value=\"up\">Normal</option><option value=\"PROVISIONED\">Provisioned</option><option value=\"unprovisioned\">Deprovisioned</option>";
				menuContent += "<option value=\"PROVISIONING\">Provisioning</option><option value=\"nc\">Suspect</option><option value=\"down\">Down</option>"
				menuContent += "</select></td><td><button onclick=\"clearDpFilter(" + mode + ", 11, 1)\">X</button></td></tr>";
			}


			menuContent += "<tr><td>Device</td><td><input id=\"menuDpFilterDevice\" class=\"tdValueFilter\"></td><td><button onclick=\"clearDpFilter(" + mode + ", 4, 1)\">X</button></td></tr>";
			if(mode === 2) {
				menuContent += "<tr><td>Block Name</td><td><input id=\"menuDpFilterBlockName\" class=\"tdValueFilter\"></td><td><button onclick=\"clearDpFilter(" + mode + ", 5, 1)\">X</button></td></tr>";
				menuContent += "<tr><td>Block Index</td><td><input id=\"menuDpFilterBlockIndex\" class=\"tdValueFilter\"></td><td><button onclick=\"clearDpFilter(" + mode + ", 6, 1)\">X</button></td></tr>";
				menuContent += "<tr><td>Datapoint</td><td><input id=\"menuDpFilterDatapoint\" class=\"tdValueFilter\"></td><td><button onclick=\"clearDpFilter(" + mode + ", 7, 1)\">X</button></td></tr>";
				
			}
		}
		else {
			menuContent += "<tr><td>Protocol</td><td><input id=\"menuDpFilterProtocol\" class=\"tdValueFilter\" list=\"searchprotocollist\">";
			if(g_oProtocols !== null) {
				menuContent += "<datalist id=\"searchprotocollist\">";
				for(x1 = 0; x1 < g_oProtocols.length; x1++)
				{
						menuContent += "<option value=\"" + g_oProtocols[x1].systemName + "\">";
				}
				menuContent += "</datalist>";
			}
			menuContent += "</td><td><button onclick=\"clearDpFilter(" + mode + ", 2, 1)\" >X</button></td></tr>";
			
			
			
			
			menuContent += "<tr><td>Override</td><td><select id=\"menuDpFilterOverride\" class=\"tdValueFilter\">";
			menuContent += "<option value=\"\">None</option><option value=\"active\">Active</option><option value=\"notactive\">Not Active</option>";
			menuContent += "</select></td><td><button onclick=\"clearDpFilter(" + mode + ", 8, 1)\">X</button></td></tr>";
			if(mode === 2) {
				menuContent += "<tr><td>Priority (1 - 16)</td><td><input id=\"menuDpFilterPriority\" class=\"tdValueFilter\" list=\"searchprioritylist\">"
				menuContent += "<datalist id=\"searchprioritylist\">";
				for(x1 = 1; x1 < 17; x1++)
				{
						menuContent += "<option value=\"" + x1 + "\">";
				}
				menuContent += "</datalist>";
				menuContent += "</td><td><button onclick=\"clearDpFilter(" + mode + ", 9, 1)\">X</button></td></tr>";
			
				menuContent += "<tr><td>Datapoint Type</td><td><input id=\"menuDpFilterDatapointType\" class=\"tdValueFilter\" list=\"snvttypes\"></td>";
				if(typeof g_oCmsOptomizedData.datapointTypes !== "undefined") {
					menuContent += "<datalist id=\"snvttypes\">";
					for(x1 in g_oCmsOptomizedData.datapointTypes)
					{
						menuContent += "<option value=\"" + g_oCmsOptomizedData.datapointTypes[x1] + "\">";
					}
					menuContent += "</datalist>";
				}
				
				menuContent += "<td><button onclick=\"clearDpFilter(" + mode + ", 10, 1)\">X</button></td></tr>";
				menuContent += "<tr style=\"display:none\"><td >Direction</td><td><input id=\"menuDpFilterDirection\" class=\"tdValueFilter\"></td><td><button onclick=\"clearDpFilter(" + mode + ", 12, 1)\">X</button></td></tr>";
			}
			menuContent += "<tr><td>Device Type</td><td><input id=\"menuDpFilterDeviceType\" class=\"tdValueFilter\" list=\"devicetypes\">";
			if(typeof g_oCmsOptomizedData.deviceTypes !== "undefined") {
				menuContent += "<datalist id=\"devicetypes\">";
				for(x1 in g_oCmsOptomizedData.deviceTypes)
				{
					menuContent += "<option value=\"" + g_oCmsOptomizedData.deviceTypes[x1] + "\">";
				}
				menuContent += "</datalist>";
			}
			menuContent += "</td><td><button onclick=\"clearDpFilter(" + mode + ", 3, 1)\">X</button></td></tr>";
			if(mode == 1) {
				menuContent += "<tr><td>Device Status</td><td><select id=\"menuDpFilterDeviceStatus\" class=\"tdValueFilter\">";
				menuContent += "<option value=\"\">None</option><option value=\"up\">Normal</option><option value=\"PROVISIONED\">Provisioned</option><option value=\"unprovisioned\">Deprovisioned</option>";
				menuContent += "<option value=\"PROVISIONING\">Provisioning</option><option value=\"nc\">Suspect</option><option value=\"down\">Down</option>"
				menuContent += "</select></td><td><button onclick=\"clearDpFilter(" + mode + ", 11, 1)\">X</button></td></tr>";
			}


			menuContent += "<tr><td>Device</td><td><input id=\"menuDpFilterDevice\" class=\"tdValueFilter\" list=\"devicenames\">";
			if(typeof g_oCmsOptomizedData.deviceNames !== "undefined") {
				menuContent += "<datalist id=\"devicenames\">";
				for(x1 in g_oCmsOptomizedData.deviceNames)
				{
					menuContent += "<option value=\"" + g_oCmsOptomizedData.deviceNames[x1] + "\">";
				}
				menuContent += "</datalist>";
			}
			menuContent += "</td><td><button onclick=\"clearDpFilter(" + mode + ", 4, 1)\">X</button></td></tr>";
			if(mode === 2) {
				menuContent += "<tr><td>Block Name</td><td><input id=\"menuDpFilterBlockName\" class=\"tdValueFilter\" list=\"blocknames\">"
				if(typeof g_oCmsOptomizedData.blockNames !== "undefined") {
					menuContent += "<datalist id=\"blocknames\">";
					for(x1 in g_oCmsOptomizedData.blockNames)
					{
						menuContent += "<option value=\"" + g_oCmsOptomizedData.blockNames[x1] + "\">";
					}
					menuContent += "</datalist>";
				}
				menuContent += "</td><td><button onclick=\"clearDpFilter(" + mode + ", 5, 1)\">X</button></td></tr>";
				menuContent += "<tr><td>Block Index</td><td><input id=\"menuDpFilterBlockIndex\" class=\"tdValueFilter\"  list=\"blockIndexes\">";
				if(typeof g_oCmsOptomizedData.blockIndices !== "undefined") {
					menuContent += "<datalist id=\"blockIndexes\">";
					for(x1 in g_oCmsOptomizedData.blockIndices)
					{
						menuContent += "<option value=\"" + g_oCmsOptomizedData.blockIndices[x1] + "\">";
					}
					menuContent += "</datalist>";
				}
				menuContent += "</td><td><button onclick=\"clearDpFilter(" + mode + ", 6, 1)\">X</button></td></tr>";
				menuContent += "<tr><td>Datapoint</td><td><input id=\"menuDpFilterDatapoint\" class=\"tdValueFilter\"  list=\"datapointnames\">";
				if(typeof g_oCmsOptomizedData.datapointNames !== "undefined") {
					menuContent += "<datalist id=\"datapointnames\">";
					for(x1 in g_oCmsOptomizedData.datapointNames)
					{
						menuContent += "<option value=\"" + g_oCmsOptomizedData.datapointNames[x1] + "\">";
					}
					menuContent += "</datalist>";
				}
				menuContent += "</td><td><button onclick=\"clearDpFilter(" + mode + ", 7, 1)\">X</button></td></tr>";
				
			}

		}

		
		menuContent += "</table><br><br>";
		
		menuContent += "Exact match (Device only) use \"=\" (\"=PulseGen1\")<br><br>";
		menuContent += "<button  onclick=\"clearDpFilter(" + mode + ", 0, 1)\">Clear Filter</button>";
		if(mode === 1)
			menuContent += "<button  onclick=\"menuDpFilterShowDevices()\">Get Devices</button>";
		else if (mode === 2)
			menuContent += "<button  onclick=\"menuDpFilterShowDps(0)\">Get Datapoints</button>";
		//menuContent += "<button class=\"menuDivButton\" onclick=\"menuDpFilterShowDps('" + filter + "')\">Clear</button>";
		menuContent += "<br><br>";
		menuContent += "</div>";
		menuButton = document.getElementById("menuDpFilterButton");
		
		
		if(menuButton !== null) {
			offsets = menuButton.getBoundingClientRect(); 
			document.getElementById("menuDiv").innerHTML = menuContent;
			dragDiv("menuDiv");

			
			if(mode === 1) {
				// device
				//document.getElementById("menuDpFilterSmartServer").innerHTML = g_oDeviceFilter.smartserver;
				document.getElementById("menuDpFilterProtocol").value = g_oDeviceFilter.protocol;
				document.getElementById("menuDpFilterDeviceType").value = g_oDeviceFilter.deviceType;
				document.getElementById("menuDpFilterDeviceStatus").value = g_oDeviceFilter.deviceStatus;
				document.getElementById("menuDpFilterDevice").value = g_oDeviceFilter.device;
			}
			else if(mode === 2) {
				// datapoint
				//document.getElementById("menuDpFilterSmartServer").innerHTML = g_oDpFilter.smartserver;
				document.getElementById("menuDpFilterProtocol").value = g_oDpFilter.protocol;
				document.getElementById("menuDpFilterDeviceType").value = g_oDpFilter.deviceType;
				document.getElementById("menuDpFilterDevice").value = g_oDpFilter.device;
				document.getElementById("menuDpFilterBlockName").value = g_oDpFilter.blockName;
				document.getElementById("menuDpFilterBlockIndex").value = g_oDpFilter.blockIndex;
				document.getElementById("menuDpFilterDatapoint").value = g_oDpFilter.datapointName;
				document.getElementById("menuDpFilterOverride").value = g_oDpFilter.override; 
				document.getElementById("menuDpFilterPriority").value = g_oDpFilter.priority;
				document.getElementById("menuDpFilterDatapointType").value = g_oDpFilter.datapointType;
				document.getElementById("menuDpFilterDirection").value = g_oDpFilter.direction;
			}
			document.getElementById("menuDiv").className = "menuDivDpSearchShow";  // doesn't currently guaranty that menu is shown in viewport

			menuDivWidth = document.getElementById("menuDiv").offsetWidth;
			if((offsets.x + offsets.width + window.pageXOffset + menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
				x = offsets.x + window.pageXOffset - menuDivWidth - 10; // takes into account viewport (scrolling)
			else
				x = offsets.x + offsets.width + window.pageXOffset + g_menuDivXOffset; // takes into account viewport (scrolling)
			y = offsets.y + window.pageYOffset - g_menuDivYOffset; // takes into account viewport (scrolling)
			document.getElementById("menuDiv").style.left = x.toString() + "px";
			document.getElementById("menuDiv").style.top = y.toString() + "px";
			
			menuOverlayDivShow(0, null);
			
			g_bInoreMouseClick = true;
			//document.addEventListener("click", menuMouseCancel);
			//document.addEventListener("click", function() {menuMouseCancel(event);});
			
		}
	} catch {}
}
function menuDpFilterShowDevices() {
	try {
		var devicesPath;
		g_sDevicesContext = "";
		if(g_iMainDisplayMode === DISPLAYMODE_ALLDEVICES) {
			devicesPath = document.getElementById("devicesPath");
			if(devicesPath !== null)
				devicesPath.innerHTML = "";
		}
		g_oDeviceFilter.smartServer = ""; //document.getElementById("menuDpFilterSmartServer").innerHTML.trim();
		g_oDeviceFilter.protocol = document.getElementById("menuDpFilterProtocol").value.trim();
		g_oDeviceFilter.deviceType = document.getElementById("menuDpFilterDeviceType").value.trim();
		g_oDeviceFilter.device = document.getElementById("menuDpFilterDevice").value.trim();
		g_oDeviceFilter.deviceStatus = document.getElementById("menuDpFilterDeviceStatus").value.trim();
		
		g_sDeviceFilter = "";
		if(g_oDeviceFilter.smartServer !== "") {
			
			g_sDeviceFilter += "*+scName=~" + g_oDpFilter.smartServer.replace(/ /g,"%20");
		}
		if(g_oDeviceFilter.protocol !== "") {
			if(g_sDeviceFilter === "")
				g_sDeviceFilter += "*+";
			else 
				g_sDeviceFilter += "&";
			g_sDeviceFilter += "protocol=~" + g_oDeviceFilter.protocol;
		}
		if(g_oDeviceFilter.deviceType !== "") {
			if(g_sDeviceFilter === "")
				g_sDeviceFilter += "*+";
			else 
				g_sDeviceFilter += "&";
			if(g_oDeviceFilter.deviceType.charAt(0) === "=")
				g_sDeviceFilter += "typeName==" + g_oDeviceFilter.deviceType.substr(1).replace(/ /g,"%20");
			else
				g_sDeviceFilter += "typeName=~" + g_oDeviceFilter.deviceType.replace(/ /g,"%20");
		}
		if(g_oDeviceFilter.deviceStatus !== "") {
			if(g_sDeviceFilter === "")
			g_sDeviceFilter += "*?"; //g_sDeviceFilter += "*+";
			else 
				g_sDeviceFilter += "&";
			g_sDeviceFilter += "sts=" + g_oDeviceFilter.deviceStatus;
		}
		if(g_oDeviceFilter.device !== "") {
			if(g_sDeviceFilter === "")
				g_sDeviceFilter += "*+";
			else 
				g_sDeviceFilter += "&";
			if(g_oDeviceFilter.device.charAt(0) === "=")
				g_oDeviceFilter += "name==" + g_oDeviceFilter.device.substr(1).replace(/ /g,"%20");
			else
				g_sDeviceFilter += "name=~" + g_oDeviceFilter.device.replace(/ /g,"%20");
		}
		menuDivClose();
		if(g_sDeviceFilter === "")
			url = "https://" + location.host + "/iap/devs?noxs=true&sortBy=name&pg=1&sz=100";
		//else if(g_oDeviceFilter.device === "")
		//	url = "https://" + location.host + "/iap/devs" + g_sDeviceFilter + "?noxs=true&sortBy=name&pg=1&sz=100";
		else if(g_sDeviceFilter.indexOf("?") === -1)
			url = "https://" + location.host + "/iap/devs/" + g_sDeviceFilter + "?noxs=true&sortBy=name&pg=1&sz=100";
		else
		url = "https://" + location.host + "/iap/devs/" + g_sDeviceFilter + "&noxs=true&sortBy=name&pg=1&sz=100";
		deviceList = []; 
		requestGetData(0, url, getDeviceListCallback, readFailCallback);
	}
	catch {}
}
function menuDpFilterShowDps(mode) {
	//mode: 0=get filter settings from Dpfilter div, 1=already have dpfilter settings
	// sort request:
	//  /iap/devs/*/if/*/*/*+type==SNVT_switch/*?pg=1&sz=25&sortBy=blockIndex&sortOrder=asc&noxs=true
	//  /iap/devs/*/if/*/*/*+type==SNVT_switch/*?pg=1&sz=25&sortBy=blockIndex&sortOrder=desc&noxs=true
	//   /iap/devs/*/if/*/*/*+type==SNVT_switch/*?pg=1&sz=25&sortBy=blockIndex&sortOrder=desc&noxs=true
	//  iap/devs/*/if/*/*/*+type==SNVT_switch/*?pg=1&sz=25&sortBy=blockIndex,deviceName,blockName&sortOrder=desc,asc,asc&nox
	try {
		var url = "";
		var bContinue = true;
		var bAddPageSize = false;
		
		
		if(mode === 0) {
			g_oDpFilter.smartServer = ""; //document.getElementById("menuDpFilterSmartServer").innerHTML.trim();
			g_oDpFilter.protocol = document.getElementById("menuDpFilterProtocol").value.trim();
			g_oDpFilter.deviceType = document.getElementById("menuDpFilterDeviceType").value.trim();
			g_oDpFilter.device = document.getElementById("menuDpFilterDevice").value.trim();
			g_oDpFilter.blockName = document.getElementById("menuDpFilterBlockName").value.trim();
			g_oDpFilter.blockIndex = document.getElementById("menuDpFilterBlockIndex").value.trim();
			g_oDpFilter.datapointName = document.getElementById("menuDpFilterDatapoint").value.trim();
			g_oDpFilter.override = document.getElementById("menuDpFilterOverride").value; 
			g_oDpFilter.datapointType = document.getElementById("menuDpFilterDatapointType").value; 
			g_oDpFilter.priority = document.getElementById("menuDpFilterPriority").value.trim();
			g_oDpFilter.direction = document.getElementById("menuDpFilterDirection").value.trim();
			
		}
		
		g_sDpFilter = "";
		if((g_oDpFilter.smartServer === "") && (g_oDpFilter.protocol === "") && (g_oDpFilter.deviceType === "") && (g_oDpFilter.device === "")
			&& (g_oDpFilter.blockName === "") && (g_oDpFilter.blockIndex === "") && (g_oDpFilter.datapointName === "")
			&& (g_oDpFilter.override === "") && (g_oDpFilter.datapointType === "") && (g_oDpFilter.priority === "")) {

			//if(confirm("No DP filters selected, will get max of 100 DPs"))
				bAddPageSize = true;
			//else
			//	return;
		}

		if(g_oDpFilter.smartServer !== "") {
			g_sDpFilter += "*+scName=~" + g_oDpFilter.smartServer.replace(/ /g,"%20");
		}
		if(g_oDpFilter.protocol !== "") {
			if(g_sDpFilter === "")
				g_sDpFilter += "*+";
			else 
				g_sDpFilter += "&";
			g_sDpFilter += "protocol=~" + g_oDpFilter.protocol;
		}
		if(g_oDpFilter.deviceType !== "") {
			if(g_sDpFilter === "")
				g_sDpFilter += "*+";
			else 
				g_sDpFilter += "&";
			g_sDpFilter += "typeName=~" + g_oDpFilter.deviceType.replace(/ /g,"%20");
		}
		if(g_oDpFilter.device !== "") {
			if(g_sDpFilter === "")
				g_sDpFilter += "*+";
			else 
				g_sDpFilter += "&";
			if(g_oDpFilter.device.charAt(0) === "=")
				g_sDpFilter += "name==" + g_oDpFilter.device.substr(1).replace(/ /g,"%20");
			else
				g_sDpFilter += "name=~" + g_oDpFilter.device.replace(/ /g,"%20");
		}
		if(g_sDpFilter === "")
			g_sDpFilter += "*+status==PROVISIONED/if";
		else 
			g_sDpFilter += "&status==PROVISIONED/if";
		if(g_oDpFilter.blockName !== "") {
			if(g_oDpFilter.blockName.charAt(0) === "=")
				g_sDpFilter += "/*+name==" + g_oDpFilter.blockName.substr(1).replace(/ /g,"%20");
			else
				g_sDpFilter += "/*+name=~" + g_oDpFilter.blockName.replace(/ /g,"%20");
		}
		else 
			g_sDpFilter += "/*"
		if(g_oDpFilter.blockIndex !== "") {
			g_sDpFilter += "/" + g_oDpFilter.blockIndex;
		}
		else 
			g_sDpFilter += "/*"
		if(g_oDpFilter.datapointName !== "") {
			if(g_oDpFilter.datapointName.charAt(0) === "=")
				g_sDpFilter += "/*+name==" + g_oDpFilter.datapointName.substr(1).replace(/ /g,"%20").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
			else
				g_sDpFilter += "/*+name=~" + g_oDpFilter.datapointName.replace(/ /g,"%20").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
		}
		else if(g_oDpFilter.datapointType) {
			if(g_oDpFilter.datapointType.charAt(0) === "=")
				g_sDpFilter += "/*+type==" + g_oDpFilter.datapointType.substr(1).replace(/ /g,"%20").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
			else
				g_sDpFilter += "/*+type=~" + g_oDpFilter.datapointType.replace(/ /g,"%20").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
		}
		else
			g_sDpFilter += "/*"
		
		if(mode === 0)
			menuDivClose();
		url = "https://" + location.host + "/iap/devs/" + g_sDpFilter;
		if((g_oDpFilter.override === "active") || (g_oDpFilter.override === "inactive")) {
			if(g_oDpFilter.override === "active")
				url += "/*+values/level!+17&value!=%7B%7D&values!=%7B%7D&type!=%7B%7D";
			else 
				url += "/*+values/level==17&value!=%7B%7D&values!=%7B%7D&type!=%7B%7D";
		}
		else {
			if (g_oDpFilter.priority !== "") {
				if(typeof g_oDpFilter.priority === "string") {
					priority = Number(g_oDpFilter.priority);
					if((priority > 0) && (priority < 17))
						//url += "/level==" + priority  + "&value!=%7B%7D&values!=%7B%7D?noxs=true&pg1&sz=100";
						//url += "/level==" + priority  + "?value!=%7B%7D&noxs=truepg1&sz=100";
						url += "/*+values/level==" + priority  + "&value!=%7B%7D&values!=%7B%7D&type!=%7B%7D";
					else {
						showAlertDialog(0,"Priority is not blank or number between 1 throudh 16");
						return;
					}
				}
				else {
					showAlertDialog(0,"Priority is not blank or number between 1 throudh 16");
					return;
				}
				bContinue = false;
			}
			
		}
		
		//paneContent = "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting DP Info ...</span></div>";
		//document.getElementById("main").innerHTML = paneContent;
		
		dpList = [];
		g_iMenuDpCount = 0;
		g_sMenuDpUrl = url;
		url += "/count";
		requestGetData(0, url, menuDpFilterShowDpsCountResponse, menuDpFilterShowDpsCountFailResponse);
	}
	catch {}
}
function menuDpFilterShowDpsCountResponse(mode, url, json) {
	try {
		var element = document.getElementById("favrowsperpageTotalDps");
		var sTemp;
		var iPtr = url.lastIndexOf("/count");
		if(typeof json === "object") {
			if(typeof json.value !== "undefined") {
				g_iMenuDpCount = json.value;
			}
		}
		if(iPtr > 0) {
			url = url.substring(0,iPtr);
		}
		url += "/*";
		if(g_iMenuDpPageSize !== 0) {
			if(url.indexOf("sz=") === -1) {
				if(url.indexOf("?") > 0)
					url += "&noxs=true&pg=1&sz=" + g_iMenuDpPageSize;
				else
					url += "?noxs=true&pg=1&sz=" + g_iMenuDpPageSize;
			}
		}
		if(g_iMenuDpCount !== 0) {
			if(g_iMenuDpPageSize !== 0) {
				if(element !== null) {
					element.innerHTML = g_iMenuDpCount;
					element = document.getElementById("favrowsperpagerange");
					if(element !== null) {
						
						if(g_iMenuDpCount > g_iMenuDpPageSize)
							sTemp = g_iMenuDpPageSize;
						else 
							sTemp = g_iMenuDpCount;
						element.innerHTML = "1 - " + sTemp;
					}
				}
			}
			requestGetData(0, url, menuDpFilterShowDatapointList, menuDpFilterShowDatapointListFailCallback);

		}
		else {
			document.getElementById("datapointListDiv").innerHTML = "";
			element = document.getElementById("favrowsperpagerange");
			if(element !== null) 
				element.innerHTML = 0;
			
		}
		
	}
	catch {}
}
function menuDpFilterShowDpsCountFailResponse(mode, url, json) {
	try {
		var element = document.getElementById("favrowsperpageTotalDps");
		document.getElementById("datapointListDiv").innerHTML = "";
		if(g_iMenuDpPageSize !== 0) {
			if(element !== null) {
				element.innerHTML = 0;
				element = document.getElementById("favrowsperpagerange");
				if(element !== null) 
				
					element.innerHTML = 0;
			}
		}
	}
	catch {}

}
function menuDpFilterShowDatapointListFailCallback(mode, url, json) {
	menuDpFilterShowDatapointList(mode, url, [])
}
function menuDpFilterShowDatapointList(mode, url, json) {  // mode:Updated value 0=Build Dp list, 1=
	// mode 0=normal Get request response, 1= Web socket response (notsupported yet), 2=showfavorites, 3= show g_dpList
	// mode: 0=normal,
	// json list of dps
	// IzoT Vision Types: sv=Show Value, tb=textbox, dl=dropdown list, sdl= substitution dropdown list cb=combobox
	var paneContent = "",bContinue;
	var i, j, w, z,iCount = 0;
	var bHasPresets = false, name1, name2, sTemp;
	var iCol = -1;
	var iStart = 0;
	var bUsePath = false;
	

	try {
		if((g_iMenuDpPageSize !== 0) && (g_iMenuDpCurrentPage !== 0)) {
			iStart = ((g_iMenuDpCurrentPage - 1) *  g_iMenuDpPageSize) + 1;
		}
		iCol ++;
		paneContent = "<tHead><tr><th onclick=\"sortTable1('dpTable'," + iCol + ")\">#</th>";
		paneContent += "<th><div style=\"display:flex\"><input type=\"checkbox\" id=\"favoritesCheckbox\" onclick=\"menuFavoritesCheckbox()\">";
		paneContent += "</div></th>";
		iCol += 2;
		if(bUsePath) {
			paneContent += "<th onclick=\"sortTable1('dpTable'," + iCol + ")\"\">Path</th>";
			iCol ++;
			paneContent += "<th onclick=\"sortTable1('dpTable'," + iCol + ")\">Dp Type</th>";
			iCol ++;
			paneContent += "<th onclick=\"sortTable1('dpTable'," + iCol + ")\">Dir</th>";
			iCol ++;
			paneContent += "<th onclick=\"sortTable1('dpTable'," + iCol + ")\">Path (Programmatic)</th>";
			iCol ++;
			paneContent += "<th onclick=\"sortTable1('dpTable'," + iCol + ")\">Add</th>";
		}
		else {
			paneContent += "<th onclick=\"sortTable1('dpTable'," + iCol + ")\"\">Device</th>";
			iCol ++;
			paneContent += "<th onclick=\"sortTable1('dpTable'," + iCol + ")\"\">Block Name</th>";
			iCol ++;
			paneContent += "<th onclick=\"sortTable1('dpTable'," + iCol + ")\"\">Block Index</th>";
			iCol ++;
			paneContent += "<th onclick=\"sortTable1('dpTable'," + iCol + ")\"\">DP Name</th>";
			iCol ++;
			paneContent += "<th onclick=\"sortTable1('dpTable'," + iCol + ")\">Dp Type</th>";
			iCol ++;
			paneContent += "<th onclick=\"sortTable1('dpTable'," + iCol + ")\">Direction</th>";
			iCol ++;
			paneContent += "<th onclick=\"sortTable1('dpTable'," + iCol + ")\"\">Path</th>";
			iCol ++;
			paneContent += "<th onclick=\"sortTable1('dpTable'," + iCol + ")\"\">DP XIF name</th>";
			iCol ++;
			paneContent += "<th onclick=\"sortTable1('dpTable'," + iCol + ")\">Add</th>";

		}
		paneContent += "</tr></tHead><tbody>";
		
			// clear javascript Object information
		if(mode === 2) 
			json = JSON.parse(JSON.stringify(g_favDpList));
		else if(mode === 3)
			json = JSON.parse(JSON.stringify(g_dpList));
		else {
			g_dpList = [];
			for(j= 0; j < json.length; j ++)
			{
				bContinue = true;
				/*
				if(g_oDpFilter.direction !== "") {
					if(g_oDpFilter.direction !== json[j].cat)
						bContinue = false;
				} */
				if(bContinue) {
					json[j].pathname = json[j].deviceName + "/" + json[j].blockName + "/" + json[j].blockIndex + "/" + json[j].name;
					json[j].programmaticPathname = json[j].deviceName + "/" + json[j].blockName + "/" + json[j].blockIndex + "/" + json[j].datapointName;
					g_dpList.push(JSON.parse(JSON.stringify(json[j])));
				}
			}
			json = JSON.parse(JSON.stringify(g_dpList));

		}
		// reorder based on time
		bContinue = true;
		while(bContinue) 
		{
			bContinue = false;
			for(i= 0; i < (json.length - 1); i ++)
			{
				name1 = json[i].pathname + " ";
				name2 = json[i + 1].pathname + " ";
				if(name1 > name2) {
					tempObj = {};
					tempObj = JSON.parse(JSON.stringify(json[i]));
					json[i] = JSON.parse(JSON.stringify(json[i + 1]));
					json[i + 1] = tempObj;
					bContinue = true;
				}
			}
		}

		for(j= 0; j < json.length; j ++)
	  	{
			// check if in favorites
			z = -1;
			if(mode === 2)
				z = 1;
			else {
				for(i=0; i < g_favDpList.length; i++ )
				{
					if(json[j].pathname === g_favDpList[i].pathname) {
						z = i;
						break;
					}
				}
			}
			// check if already in schedulelist
			w = -1;
			for(i=0; i < g_menuDatapointsEventDatapoints.length; i++ )
			{
				if(json[j].pathname === g_menuDatapointsEventDatapoints[i]) {
					w = i;
					break;
				}
			}
			paneContent += "<tr id=\"favrow_" + json[j].pathname + "\"";
			if(w !== -1)
				paneContent += " style=\"background-color:lightgrey\"";
			//iCount ++;
			paneContent += "><td>" + (iStart + j).toString() + "</td>";
			if(w !== -1) {
				paneContent += "<td></td>";
			}
			else if(z === -1)
				paneContent += "<td id=\"favcheck_" + json[j].pathname + "\" ><input type=\"checkbox\" id=\"fav_" + json[j].pathname + "\" onclick=\"menuFavoritesAddToFavorites('" + json[j].pathname + "')\"></td>";
			else 
				paneContent += "<td id=\"favcheck_" + json[j].pathname + "\"><input type=\"checkbox\" id=\"fav_" + json[j].pathname + "\" onclick=\"menuFavoritesAddToFavorites('" + json[j].pathname + "')\" checked></td>";
			
			if(bUsePath) 
				paneContent += "<td class=\"pathname\" title=\"" + json[j].pathname + "\">" + json[j].pathname + "</td>";
			else { 
				paneContent += "<td>" + json[j].deviceName + "</td><td>" + json[j].blockName + "</td><td>" + json[j].blockIndex + "</td><td>" + json[j].name + "</td>";
			}
			
			paneContent += "<td>" + json[j].type + "</td><td>" + json[j].cat + "</td>";
			if(bUsePath) 
				paneContent += "<td class=\"pathnameOverflowElippse\" title=\"" + json[j].programmaticPathname + "\">" + json[j].programmaticPathname + "</td>";
			else {
				paneContent += "<td class=\"pathnameScheduleSelectDp\" title=\"" + json[j].pathname + "\">" + json[j].pathname + "</td>";
				paneContent += "<td>" + json[j].datapointName + "</td>";
			}
			paneContent += "<td id=\"favadd_" + json[j].pathname + "\">";
			if(w === -1)
				paneContent += "<button onclick=\"menuDatapointSave('" + json[j].pathname + "')\">+</button>";
			paneContent += "</td>";
			paneContent += "</tr>"; 
		} //for(i= 0; 
		
		paneContent = "<br><table id=\"dpTable\">" + paneContent + "</tbody></table>";
		if(g_iMenuDpPageSize !== 0) {
			paneContent += "<br><div style=\"display:block;width:100%\"><div style=\"float:right;\"><div style=\"display:flex\">Rows per page";
			paneContent += "<select id=\"favrowsperpage\" style=\"margin-left:5px;margin-right:5px\" onchange=\"menuDpFilterShowDatapointListRowsPerPage()\">";
			paneContent += "<option value=\"5\">5</option><option value=\"25\">25</option><option value=\"50\">50</option><option value=\"75\">75</option>";
			paneContent += "<option value=\"100\">100</option>";
			paneContent += "</select>";
		
			paneContent += "<span id=\"favrowsperpagerange\" style=\"margin-right:5px\">1 - 100</span><span style=\"margin-left:5px;margin-right:5px\"> of </span><span id=\"favrowsperpageTotalDps\">" + g_iMenuDpCount + "</span>";
			paneContent += "<button onclick=\"menuDpFilterShowDatapointListPageGoToFirstPage()\"><<</button>";
			paneContent += "<button onclick=\"menuDpFilterShowDatapointListPageGoToPreviousPage()\"><</button>";
			paneContent += "<input id=\"favpagenumber\" style=\"margin-left:5px;margin-right:5px\" onclick=\"menuDpFilterShowDatapointListSelectPage()\" value=\"" + g_iMenuDpCurrentPage + "\" size=\"5\">";
			paneContent += "<button id=\"favpageNextButton\" onclick=\"menuDpFilterShowDatapointListPageGoToNextPage()\">></button><button id=\"favpageLastButton\" onclick=\"menuDpFilterShowDatapointListPageGoToLastPage()\">>></button>";
			paneContent += "</div></div></div>";
		}
		//paneContent += addTopButton();
		document.getElementById("datapointListDiv").innerHTML = paneContent;
		//document.getElementById("dpCount").innerHTML = "[" + json.length + "]";
		tableCreateResizableTable("dpTable");
		if(g_iMenuDpPageSize !== 0) {
			document.getElementById("favrowsperpage").value = g_iMenuDpPageSize;
			if(g_iMenuDpCount !== 0) {
				sTemp = (((g_iMenuDpCurrentPage - 1) * g_iMenuDpPageSize) + 1).toString() + " - ";
				if((g_iMenuDpCurrentPage * g_iMenuDpPageSize) > g_iMenuDpCount)
					sTemp += g_iMenuDpCount;
				else
					sTemp += (g_iMenuDpCurrentPage * g_iMenuDpPageSize).toString();
				document.getElementById("favrowsperpagerange").innerHTML = sTemp;
			}
		}
	}
	catch (err) {}
	//setTopContainerSize();
	

}
function menuDpFilterShowDatapointListGetNextDpList() {
	try {
		var element = document.getElementById("favpagenumber");
		var url, sTemp, iTemp;
		if(element !== null) {
			sTemp = element.value;
			if(typeof sTemp === "string") {
				if(isNaN(sTemp)) {
					alert("Invalid, not a number")
					return;
				}
				iTemp = Number(sTemp);
			}
			else if(typeof sTemp === "number")
				iTemp = sTemp;
			if(iTemp < 1) {
				iTemp = 1;
				element.value = iTemp;
			}
			else if	((iTemp * g_iMenuDpPageSize) > g_iMenuDpCount) {
				iTemp = Math.ceil(g_iMenuDpCount / g_iMenuDpPageSize);
				document.getElementById("favpageNextButton").disabled = true;
				document.getElementById("favpageLastButton").disabled = true;
			}
			
			g_iMenuDpCurrentPage = iTemp;
			url = g_sMenuDpUrl + "/*";
			if(g_iMenuDpPageSize !== 0) {
				if(url.indexOf("sz=") === -1) {
					if(url.indexOf("?") > 0)
						url += "&noxs=true&pg=" + g_iMenuDpCurrentPage + "&sz=" + g_iMenuDpPageSize;
					else
						url += "?noxs=true&pg=" + g_iMenuDpCurrentPage + "&sz=" + g_iMenuDpPageSize;
				}
			}
			if(g_iMenuDpCount !== 0) {
				if(g_iMenuDpPageSize !== 0) {
					if(element !== null) {
						element.innerHTML = g_iMenuDpCount;
						element = document.getElementById("favrowsperpagerange");
						if(element !== null) {
							
							if(g_iMenuDpCount > g_iMenuDpPageSize)
								sTemp = g_iMenuDpPageSize;
							else 
								sTemp = g_iMenuDpCount;
							element.innerHTML = "1 - " + sTemp;
						}
					}
				}
			}
			requestGetData(0, url, menuDpFilterShowDatapointList, menuDpFilterShowDatapointListFailCallback);	
		}
	}
	catch {}

}
function menuDpFilterShowDatapointListRowsPerPage() {
	try {
		var element = document.getElementById("favrowsperpage");
		if(element !== null) {
			g_iMenuDpPageSize = element.value;
			element = document.getElementById("favpagenumber");
			if(element !== null) {
				element.value = 1;
				g_iMenuDpCurrentPage = 1;
				menuDpFilterShowDatapointListGetNextDpList();
			}
		}
	}
	catch {}
}
function menuDpFilterShowDatapointListPageGoToFirstPage() {
	try {
		var element = document.getElementById("favpagenumber");
		if(element !== null) {
			element.value = 1;
			if(document.getElementById("favpageNextButton").disabled)
				document.getElementById("favpageNextButton").disabled = false;
			if(document.getElementById("favpageLastButton").disabled)
				document.getElementById("favpageLastButton").disabled = false;
			g_iMenuDpCurrentPage = 1;
			element.value = 1;
			menuDpFilterShowDatapointListGetNextDpList();
		}
	}
	catch{}
}
function menuDpFilterShowDatapointListPageGoToPreviousPage() {
	try {
		var element = document.getElementById("favpagenumber");
		var url, sTemp, iTemp = 1;
		if(element !== null) {
			sTemp = element.value;
			if(typeof sTemp === "string") {
				if(isNaN(sTemp)) {
					alert("Invalid, not a number")
					return;
				}
				iTemp = Number(sTemp);
			}
			else if(typeof sTemp === "number")
				iTemp = sTemp;
			
			iTemp--;
			if(iTemp < 1)
				iTemp = 1;
			element.value = iTemp;
			if(document.getElementById("favpageNextButton").disabled)
				document.getElementById("favpageNextButton").disabled = false;
			if(document.getElementById("favpageLastButton").disabled)
				document.getElementById("favpageLastButton").disabled = false;
			g_iMenuDpCurrentPage = iTemp;
			menuDpFilterShowDatapointListGetNextDpList();
		}
	}
	catch{}
}
function menuDpFilterShowDatapointListPageGoToLastPage() {
	try {
		var element = document.getElementById("favpagenumber");
		var iTemp;
		if(element !== null) {
			iTemp = Math.ceil(g_iMenuDpCount / g_iMenuDpPageSize);
			
			document.getElementById("favpageNextButton").disabled = true;
			document.getElementById("favpageLastButton").disabled = true;
			element.value = iTemp;
			g_iMenuDpCurrentPage = iTemp;
			menuDpFilterShowDatapointListGetNextDpList();
		}
	}
	catch{}
}
function menuDpFilterShowDatapointListPageGoToNextPage() {
	try {
		var element = document.getElementById("favpagenumber");
		var url, sTemp, iTemp;
		if(element !== null) {
			sTemp = element.value;
			if(typeof sTemp === "string") {
				if(isNaN(sTemp)) {
					alert("Invalid, not a number")
					return;
				}
				iTemp = Number(sTemp);
			}
			else if(typeof sTemp === "number")
				iTemp = sTemp;
			iTemp++;
			if	(((iTemp + 1) * g_iMenuDpPageSize) > g_iMenuDpCount) {
				iTemp = Math.ceil(g_iMenuDpCount / g_iMenuDpPageSize);
				
				document.getElementById("favpageNextButton").disabled = true;
				document.getElementById("favpageLastButton").disabled = true;
			}
			element.value = iTemp;
			g_iMenuDpCurrentPage = iTemp;
			menuDpFilterShowDatapointListGetNextDpList();
		}
	}
	catch{}

}
function menuDpFilterShowDatapointListSelectPage() {
	
	try {
		var element = document.getElementById("favpagenumber");
		var url, sTemp, iTemp;
		if(element !== null) {
			sTemp = element.value;
			if(typeof sTemp === "string") {
				if(isNaN(sTemp)) {
					alert("Invalid, not a number")
					return;
				}
				iTemp = parseInt(sTemp);
			}
			else if(typeof sTemp === "number")
				iTemp = sTemp;
			if(iTemp < 1)
				iTemp = 1;
			if	(((iTemp + 1) * g_iMenuDpPageSize) > g_iMenuDpCount) {
				iTemp = Math.ceil(g_iMenuDpCount / g_iMenuDpPageSize);
				
				document.getElementById("favpageNextButton").disabled = true;
				document.getElementById("favpageLastButton").disabled = true;
			}
			element.value = iTemp;
			g_iMenuDpCurrentPage = iTemp;
			menuDpFilterShowDatapointListGetNextDpList();
		}
	}
	catch{}
}
function menuDpValue(n, index, displayElementIndex, displayId, programmaticPathname) {
	menuDpValue1(0, n, index, displayElementIndex, displayId, programmaticPathname);
}
function menuDpValue1(mode, n, index, displayElementIndex, displayId, programmaticPathname) {
		// if enueration check if we already have the SNVT type informatin, if not get the snvt type before
		menuDpValue2(mode, n, index, displayElementIndex, displayId, programmaticPathname);
		
}



function menuDpValue2(mode, n, index, displayElementIndex, displayId, programmaticPathname) {
	//mode: 0= show all (value and priority array), 1= no priority array, 2 =show only priority array 3=show only alarm

	//pathname is programmatic pathname
	try { 
		//var event1 = window.event;
		var x = 0; // = event.clientX;
		var y = 0;// = event.clientY;
		var menuContent = "",pathname,displayIdPath;
		var bContinue = false;
		var offsets, field, chartIndex;
		var value = null;
		var values = null, levels = null;
		var dpIndex;
		var presets = null;
		var width;
		var obj = null, dpObj, iPtr;
		var menuDivXOffset = 15;//-250;
		var menuDivYOffset = 20;
		var menuDivWidth = 150;
		g_bInoreMouseClick = true;
		g_bAlwaysIngnoreMouseClick = true; // needed otherwise clicking dropdown will close window
		menuStructuredDpDialogCancel();
		if(index >= dashboardDpList.length)
			return;
		if(dashboardDpList[index].programmaticPathname !== programmaticPathname) 
			return;
		if(displayElementIndex >= dashboardDpList[index].displayElements.length)
			return;
		
		

		cursorClearWait();

			// check dpIndex
		if(index < dashboardDpList.length) {
			if(dashboardDpList[index].programmaticPathname === programmaticPathname) {
				
				bContinue = true;
				dpObj = dashboardDpList[index];
				pathname = dashboardDpList[index].pathname;
			}
		}
		else
			return;
		// check if structured DP
		if(g_iShowEditButton > 0) {
			if(!g_bEditModeEnabled) {
				if(dashboardDpList[index].displayElements[displayElementIndex].dashboardType !== "c") {
					//if(typeof dashboardDpList[index].displayElements[displayElementIndex].locValue === "object") {
					if((dashboardDpList[index].displayElements[displayElementIndex].dashboardType === "s0") || (dashboardDpList[index].displayElements[displayElementIndex].dashboardType === "s1")) {
						menuDpPlanningShowStructuredDp(mode,n, index, displayElementIndex, programmaticPathname);
						menuOverlayDivShow(4, null);
						return;
					}
				}
			}
			/* don't know if this is needed
			if(typeof dashboardDpList[index].displayElements[displayElementIndex].locValue === "object") {
				menuDpPlanningShowStructuredDp(mode,n, index, displayElementIndex, programmaticPathname);
				menuOverlayDivShow(4, null);
				return;
			}
			*/
		}

		iPtr = displayId.indexOf("_");
		if(iPtr === -1)
			return;
		if((iPtr + 1) > displayId.length)
			return;
		displayIdPath = displayId.substr(iPtr + 1);
	
		if(dashboardDpList[index].displayElements[displayElementIndex].displayId !== displayIdPath)
			return;
		
		if(!bContinue){
			showAlertDialog(0,"DP Path doesn't match DP index\r\n\r\n" + programmaticPathname)
			return;
		}
		menuContent = "<div class=\"menuDivDpValueShow1\"><div class=\"menuDivBorder\">";
		menuContent += "<div>";
		menuContent += "<div id=\"menuDivHeader\" class=\"menuDivName menuDivDpValueShowDragDivHeader\">";
		iPtr = pathname.indexOf("/");
		if(iPtr === -1)
			menuContent += pathname;
		else
			menuContent += pathname.substr(iPtr + 1);
		menuContent += "</div>";
		
		menuContent +="<button style=\"float:right\" onclick=\"menuDivClose()\">X</button>";
		menuContent += "</div>";
		if(dashboardDpList[index].displayElements[displayElementIndex].field !== "") {
			field = dashboardDpList[index].displayElements[displayElementIndex].field;
			if(dashboardDpList[index].displayElements[displayElementIndex].dashboardType === "c") {
				if(dashboardDpList[index].displayElements[displayElementIndex].chartIndex !== -1) {
					chartIndex = dashboardDpList[index].displayElements[displayElementIndex].chartIndex;
					if(chartIndex < g_dashboardChartList.length) {
						if(g_dashboardChartList[chartIndex].field !== "") {
							field = g_dashboardChartList[chartIndex].field;
						}
					}
				}
			}
			menuContent += "<div class=\"menuDivName\">Field: " + field + "</div>";
		}
		
		menuContent += "<br><br>Getting Current Data....<br><br>";
		
		
		
		var menuButton = document.getElementById(displayId);
		
		if(menuButton !== null) {
			offsets = menuButton.getBoundingClientRect(); 
			width = offsets.width;
			if(width > 200)
				width = 200;  // needed for structures
			if((offsets.x + width + window.pageXOffset + menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
				x = offsets.x + window.pageXOffset - menuDivWidth - 10; // takes into account viewport (scrolling)
			else
				x = offsets.x + width + window.pageXOffset + menuDivXOffset; // takes into account viewport (scrolling)
			
			y = offsets.y + window.pageYOffset - menuDivYOffset; // takes into account viewport (scrolling)
			if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
				x += menuDivXOffset;
				y -= 70;
			}
			else if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
				x += menuDivXOffset;
				y -= 70;
			}
			document.getElementById("menuDiv").style.left = x.toString() + "px";
			document.getElementById("menuDiv").style.top = y.toString() + "px";
			document.getElementById("menuDiv").innerHTML = menuContent;
			document.getElementById("menuDiv").className = "menuDivDpValueShow";  // doesn't currently guaranty that menu is shown in viewport

			g_bInoreMouseClick = true;
			menuOverlayDivShow(0, null);
			dragDiv("menuDiv");
			
			//document.addEventListener("click", menuMouseCancel);
			//document.addEventListener("click", function() {menuMouseCancel(event);});
			
		}
		else 
			return;

		obj = {};
		obj.mode = mode;
		obj.this = n;
		obj.index = index;
		obj.displayElementIndex = displayElementIndex;
		obj.programmaticPathname = programmaticPathname;
		obj.displayId = displayId;
		obj.type = dashboardDpList[index].type;
		
		// check if have snvttype values if not get snvt type
		bContinue = false;
		
		for(i=0; i < g_snvtTypes.length; i++)
		{
			//if(dashboardDpList[index].type === g_snvtTypes[i].typeId) {
			if(dashboardDpList[index].type === g_snvtTypes[i].typeRef) {
				bContinue = true;
				break;
			}
		}
		if(!bContinue) {
			// get SNVT_type  
			cursorSetWait();
			getSnvtType(obj, dashboardDpList[index].type);
			return;
		}
			
		
		if(bContinue) {
			cursorSetWait();
			getDpPriorityforMenuDpValue(obj);
			//menuDpValue2(mode, n,index, pathname);
		}

		
		
		//if(presets === null) //ffixxxxxxxxxxx
		//	menuDpValueGetPresets(index, pathname);
		//else 
		//	menuDpValueGetPresetsResponse(index, pathname, null)
	} catch {}
}
function menuDpValuePrioritiesRefresh(mode, index, displayElementIndex, displayId, programmaticPathname) {
	try { // refresh
		var obj = {};
		var url = "https://" + location.host + "/iap/devs/*/if/*/*/*+qualifier=-";
		var dpQualifier = dashboardDpList[index].dpQualifier;
		dpQualifier = _encodePathNames(dpQualifier);
		dpQualifier = dpQualifier.replace(/\//g,"%2F");
		url += dpQualifier + "/*?max_age=0&noxs=true";
		obj.mode = mode;
		obj.index = index;
		obj.displayId = displayId;
		obj.displayElementIndex = displayElementIndex;
		obj.programmaticPathname = programmaticPathname;
		requestGetData(obj, url, menuDpValuePrioritiesResponse, readFailCallback);
	}
	catch {}
}
function menuDpValuePrioritiesResponse(mode, requestUrl, json) {
	try {
		getOnDemandDpValuesResponse(3, requestUrl, json);
		menuDpValueSetup(mode.mode, mode.index, mode.displayElementIndex, mode.displayId, mode.programmaticPathname);  
	}
	catch {}

}
function menuDpValueDivSelect() {
	try {
		var bShowValue = false;
		var bShowPriority = false;
		var element;
		if(document.getElementById("menudpValueRadioButtonValue").checked) {
			bShowValue = true;
		}
		else if(document.getElementById("menudpValueRadioButtonPriority").checked) {
			bShowPriority = true;
		}
		else if(document.getElementById("menudpValueRadioButtonBoth").checked) {
			bShowValue = true;
			bShowPriority = true;;
		}
		element = document.getElementById("menuDivDpValueDivId");
		if(element !== null) {
			if(bShowValue)
				element.style.display = "block";
			else 
				element.style.display = "none";
		}
		element = document.getElementById("menuDivDpPriorityDivId");
		if(element !== null) {
			if(bShowPriority)
				element.style.display = "block";
			else 
				element.style.display = "none";
		}
		
	}
	catch {}
}
function menuDpValueOverrideValueSelect() {
	try {
		var bShowValue = false;
		var bShowFullValue = false;
		var selectedValue = document.querySelector('input[name="menudpOverrideRadioButton"]:checked');
		var table = document.getElementById("priorityTable");
		var element, i;
		
		if((table !== null) && (selectedValue !== null)) {
			if(selectedValue.value === "value")
				bShowValue = true;
			else if(selectedValue.value === "fullvalue")
				bShowFullValue = true;
			else {
				bShowValue = true;
				bShowFullValue = true;
			}
			// show/hide columns
			for(i=0; i < table.rows.length; i++)
			{
				if(bShowValue) {
					table.rows[i].cells[1].style.display = "table-cell";
				}
				else {
					table.rows[i].cells[1].style.display = "none";
				}
				if(bShowFullValue) {
					table.rows[i].cells[2].style.display = "table-cell";
				}
				else {
					table.rows[i].cells[2].style.display = "none";
				}
			}
		}
	}
	catch {}
}
function menuDpValueDivPresetSelectChanged(displayType,index, displayElementIndex, displayId, programmaticPathname) {
	try {
		var presetSelect = document.getElementById("menuDpValuePresetSelect");
		var presetName, dpTypeObj = {}, saveObj,i;
		var preset = "";
		var value = "",i;
		if(index >= dashboardDpList.length)
			return;
		if(dashboardDpList[index].programmaticPathname !== programmaticPathname) {
			showAlertDialog(0,"Response DP Path doesn't match DP index\r\n\r\n" + programmaticPathname);
			return;
		}
		if(displayElementIndex >= dashboardDpList[index].displayElements.length)
			return;
		if(presetSelect !== null) {
			preset = presetSelect.options[presetSelect.selectedIndex].text;
			if(preset.trim() !== "") {
				if (typeof dashboardDpList[index].presets !== "undefined") {
					if(dashboardDpList[index].presets.map.length > 0) {
						for(i=0; i < dashboardDpList[index].presets.map.length; i++)
						{
							preset = preset.toLowerCase();
							presetName = dashboardDpList[index].presets.map[i].name.toLowerCase();
							if(preset === presetName) {
								value = dashboardDpList[index].presets.map[i].value;
								if(displayType === "input") {
									element = document.getElementById("menuDpValueCurrentValue_" + programmaticPathname);
									if(element !== null)
										element.value = value;
								}
								else if(displayType === "object") {
									dpTypeObj.dpType = "Value";
									if(dashboardDpList[index].displayElements[displayElementIndex].field === "") {
										
										if(typeof dashboardDpList[index].type !== "undefined") {
											dpTypeObj.dpType = dashboardDpList[index].type;
											dpTypeObj.snvtTypeObj = null;
											// add SNVTdata
											for(i=0; i < g_snvtTypes.length; i++)
											{
												//if(dashboardDpList[index].type === g_snvtTypes[i].typeId) {
												if(dashboardDpList[index].type === g_snvtTypes[i].typeRef) {
													dpTypeObj.snvtTypeObj = JSON.parse(JSON.stringify(g_snvtTypes[i]));
													break;
												}
											}
										}

										
										//content = menuStructuredDpdecodedJson(value, "", 0, dptype, readonly); // div content
									}
									saveObj = {};
									saveObj.type = "menuDpValue";
									saveObj.index = index;
									saveObj.displayElementIndex = displayElementIndex;
									saveObj.programmaticPathname = dashboardDpList[index].programmaticPathname;
									menuContent = menuStructuredDpdecodedJsonTree(value, "", 0, dpTypeObj, dashboardDpList[index].displayElements[displayElementIndex].readonly,false, saveObj); // tree view
									element = document.getElementById("StructuredDpTreeDiv");
									if(element !== null)
										element.innerHTML = menuContent;
									break;
								}
							}
						}
					}
				}
			}
			else {
				// put current preset

			}
		}
	}
	catch {}

} 
function menuDpValueSetup(mode, index, displayElementIndex, displayId, programmaticPathname){
	//mode: 0=show both values and priority array, 1=show values only, 2=show only priority array, 3= show alarm only, 4=same as but values selected, 5=same as 0 but priority selected, 6=same as 0 but alarm selected 
	//      10= same as 0 but show device name, 11= same as 1 but show device name, 12=same as 2 but show device name, 13=same as 3 but show device name
	
	try {
		var i, j, z, len,iPtr, count;
		var bFound;
		var pathname = "";
		var id = " ", name = " ", name1, value, valueStr, locValue, locValueStr, type, enums = null, dptype, saveObj; 
		var obj;
		var x, x1;
		var menuContent = "";
		var bContinue = false;
		var presets = null;
		var presetValue = "";
		var bPresetsAdded = false;
		var datapointQualifier = "";
		var bNumber = false;
		var sLevel, level;
		var priority = "";
		var values;
		var urlPathname = ""; // uses xif pathname
		var bUseDropdown = false;
		var sPermittedPriorites = "";
		var menuDiv = null;
		var snvtObj = {}, dpTypeObj = {};
		var bShowDeviceName = false;
		var displayType, displayType1;
		var bShowStructure = false,readonly = true;
		var field = "",displayIdPath;
		var bValuedDivCreated = false;
		var bPriorityDivCreated = false;
		var iSelectedDiv = -1;
		var menuValueDisplayType ="input"; //input
		var chartIndex = -1;
		var defaultField = ""; 	//  defaultField: If structure Dp use this default for field dropdown
		var bEditModeEnabled = g_bEditModeEnabled;
		var bLongText = false;
		var enums = [];
		var bEnum = false;
		var snvtTypeData;
		var tempObj;
		
		
		
		if(mode >= 10) {
			bShowDeviceName = true;
			mode -= 10;
		}

		
		var presetContent = "";
		var bShowAdvancedInfo = false;

		if(index >= dashboardDpList.length)
			return;
		if(dashboardDpList[index].programmaticPathname !== programmaticPathname) {
			showAlertDialog(0,"Response DP Path doesn't match DP index\r\n\r\n" + programmaticPathname);
			return;
		}
		if(displayElementIndex >= dashboardDpList[index].displayElements.length)
			return;
		iPtr = displayId.indexOf("_");
		if(iPtr === -1)
			return;
		if((iPtr + 1) > displayId.length)
			return;
		displayIdPath = displayId.substr(iPtr + 1);
	
		if(dashboardDpList[index].displayElements[displayElementIndex].displayId !== displayIdPath)
			return;

		g_menuDivPermissions = [];
		defaultField = dashboardDpList[index].displayElements[displayElementIndex].field;
		if(dashboardDpList[index].displayElements[displayElementIndex].dashboardType === "c") {
			if(dashboardDpList[index].displayElements[displayElementIndex].chartIndex !== -1) {
				chartIndex = dashboardDpList[index].displayElements[displayElementIndex].chartIndex;
				if(chartIndex < g_dashboardChartList.length) {
					if(g_dashboardChartList[chartIndex].field !== "") {
						defaultField = g_dashboardChartList[chartIndex].field;
					}
				}
			}
		}
		bContinue = true;
		if(!(typeof dashboardDpList[index].values === "undefined"))
			values = dashboardDpList[index].values;
		pathname = dashboardDpList[index].pathname;
		value = dashboardDpList[index].value;
		valueStr = dashboardDpList[index].valueStr;
		locValue = dashboardDpList[index].locValue;
		locValueStr = dashboardDpList[index].locValueStr;
		presetValue = dashboardDpList[index].presetValue;
		presets = dashboardDpList[index].presets;
		priority = dashboardDpList[index].priority;
		type = dashboardDpList[index].type;
		urlPathname = dashboardDpList[index].urlPath; //.urlPathname;
		programmaticPathname = dashboardDpList[index].programmaticPathname;
		sPermittedPriorites = dashboardDpList[index].writePriorityStart;
		displayType = dashboardDpList[index].displayElements[displayElementIndex].dashboardType;

		if(defaultField !== "") {
			value2 = readFieldValue(value, defaultField);
			if(value2.valid)
				value = value2.data;
			value2 = readFieldValue(locValue, defaultField);
			if(value2.valid)
				locValue = value2.data;
			if(dashboardDpList[index].displayElements[displayElementIndex].bString) {
				if(locValue.length > 9) {
					bLongText = true;
				}
			}
			if(dashboardDpList[index].displayElements[displayElementIndex].bNumber) {
				valueStr = value.toString();
				locValueStr = locValue.toString();
			}
			else {
				valueStr = value;
				locValueStr = locValue;
			}
			if(typeof dashboardDpList[index].snvtType !== "undefined") {
				snvtTypeData = readSnvtTypeFieldValue(dashboardDpList[index].snvtType, defaultField);
				if(snvtTypeData.valid) {
					if(snvtTypeData.data.type === "enum") {
						if(typeof snvtTypeData.data.enum !== "undefined") {
							bEnum = true;
							enums = JSON.parse(JSON.stringify(snvtTypeData.data.enum));
						}
					}
				} 
			}
		}
		else if(dashboardDpList[index].displayElements[displayElementIndex].bEnum) {
			bEnum = true;
			enums = JSON.parse(JSON.stringify(dashboardDpList[index].displayElements[displayElementIndex].enums));
		}

		if((dashboardDpList[index].writePriorityStart + 1) !== dashboardDpList[index].writePriorityEnd)
			sPermittedPriorites +=  " - " + (dashboardDpList[index].writePriorityEnd - 1).toString();
		else
			sPermittedPriorites += " only";
		bFound = false;

		if(typeof dashboardDpList[index].snvtObj !== "undefined") {
			if(dashboardDpList[index].snvtObj !== null) {
				if(typeof dashboardDpList[index].snvtObj.name !== "undefined")
					bFound = true;
			}
		}
		
		if(!bFound)	{
				dashboardDpList[index].snvtObj = {};
			for(j=0; j < g_snvtTypes.length; j++)
			{
				if(g_snvtTypes[j].typeId === type) {
					snvtObj = g_snvtTypes[j];
					dashboardDpList[index].snvtObj = JSON.parse(JSON.stringify(g_snvtTypes[j]));
					
					z = j;
					break;
				}
			}
		}
		snvtObj = dashboardDpList[index].snvtObj;
		menuContent = "<div class=\"menuDivDpValueShow1\"><div class=\"menuDivBorder\">";
		
		menuContent += "<div>";
		menuContent +="<button style=\"float:right\" onclick=\"menuDivClose()\">X</button>";
		menuContent += "<div id=\"menuDivHeader\" class=\"menuDivName menuDivDpValueShowDragDivHeader\">";
		iPtr = pathname.indexOf("/");
		if(iPtr === -1)
			menuContent += pathname;
		else {
			if(bShowDeviceName) {
				menuContent += pathname.substr(0, iPtr);
				menuContent += "<br><br>"
			}
			menuContent += pathname.substr(iPtr + 1);
		}
		menuContent += "</div>";
		
		menuContent += "</div>";
		if(defaultField !== "") {
			menuContent += "<div class=\"menuDivName\">Field: " + defaultField + "</div><br>";
		}
		if(displayType === "c") {
			chartIndex = dashboardDpList[index].displayElements[displayElementIndex].chartIndex;
			menuContent += "<button id=\"pause_" + index + "\" class=\"menuDivButton\" onclick=\"_chartPauseSingle(" + chartIndex  + ")\">";
			if(g_dashboardChartList[chartIndex].paused)
				menuContent += "Continue";
			else
				menuContent += "Pause"
			menuContent + "</button><br>";
			if(g_bZoomChartSupported) {
				menuContent += "<button class=\"menuDivButton\" onclick=\"_chartZoom(0," + chartIndex + ",'";
				menuContent += dashboardDpList[index].displayElements[displayElementIndex].programmaticPathname;
				menuContent += "','" + dashboardDpList[index].displayElements[displayElementIndex].label  + "','";
				menuContent += g_dashboardChartList[chartIndex].field + "')\">Zoom</button><br>";
			}
			if(g_bAllowSaveChartData) {
				menuContent += "<button class=\"menuDivButton\" onclick=\"saveData1(0,0," + chartIndex + ",'";
				menuContent += dashboardDpList[index].displayElements[displayElementIndex].programmaticPathname;
				menuContent += "','" + dashboardDpList[index].displayElements[displayElementIndex].label  + "')\">Save</button>";
			}
			menuContent += "<button class=\"menuDivButton\" onclick=\"_clearDashboardChart(1," + chartIndex + ")\">Clear Chart</button>"

		}
		if(g_bShowScheduleButtonInMenu && dashboardDpList[index].cat === "in") {
			menuContent +="<br><button style=\"float:right\" onclick=\"showDpSchedule(" + index + ",'" + dashboardDpList[index].programmaticPathname + "','" + dashboardDpList[index].dpQualifier + "')\">Schedules</button><br>";
		}
		
		if(typeof value === "number")
			bNumber = true;
		
		if(values !== null) {
			if(values.levels !== null) {
				levels = values.levels;
			}
		}
		if((mode === 0) || (mode > 2)) {
			menuContent += "<br>Display:<br>";

			menuContent += "<input type=\"radio\" id=\"menudpValueRadioButtonNone\" name=\"menudpValueRadioButton\" onclick=\"menuDpValueDivSelect()\" value=\"None\"";
			if((mode === 0) && (dashboardDpList[index].displayElements[displayElementIndex].dashboardType === "c") && (!g_bEditModeEnabled)) {
				menuContent += " checked";
				iSelectedDiv = 4;
			}
			menuContent += "><label for=\"menudpValueRadioButtonNone\">None</label>";
			menuContent += "<input type=\"radio\" id=\"menudpValueRadioButtonValue\" name=\"menudpValueRadioButton\" onclick=\"menuDpValueDivSelect()\" value=\"Value\"";
			if(mode === 4) {
				menuContent += " checked";
				iSelectedDiv = 1;
			}
			menuContent += "><label for=\"menudpValueRadioButtonValue\">Value</label>";
			menuContent += "<input type=\"radio\" id=\"menudpValueRadioButtonPriority\" name=\"menudpValueRadioButton\" onclick=\"menuDpValueDivSelect()\"";
			if(mode === 5) {
				menuContent += " checked";
				iSelectedDiv = 2;
			}
			menuContent += "><label for=\"menudpValueRadioButtonPriority\">Priority Values</label>";
			menuContent += "<input type=\"radio\" id=\"menudpValueRadioButtonActiveAlarm\" name=\"menudpValueRadioButton\" onclick=\"menuDpValueDivSelect()\"";
			if(mode === 6) {
				menuContent += " checked";
				iSelectedDiv = 2;
			}
			menuContent += "><label for=\"menudpValueRadioButtonActiveAlarm\">Active Alarm</label>";
			menuContent += "<input type=\"radio\" id=\"menudpValueRadioButtonBoth\" name=\"menudpValueRadioButton\" onclick=\"menuDpValueDivSelect()\"";
			if((mode === 0) && (!((dashboardDpList[index].displayElements[displayElementIndex].dashboardType === "c") && (!g_bEditModeEnabled)))) {
				menuContent += " checked";
				iSelectedDiv = 0;
			}
			menuContent += "><label for=\"menudpValueRadioButtonBoth\">All</label><br><br>";
			
		}
		menuContent += "<br>Current Priority: ";
		if(values.level === 17)
			menuContent += "normal";
		else 
			menuContent += values.level;
		
		menuContent += "<br>";
		if(mode !== 2) {
			// datapoints
			menuContent += "<div id=\"menuDivDpValueDivId\">";
			z = snvtObj;
			i = displayType;
			menuContent += "<hr>";
			
			// add prioirity write dropdown
			menuContent += "<div>"
			
			menuContent += "Priority: ";
			level = values.level;
			if(!bEditModeEnabled) {
				menuContent += "<span id=\"menuDpValuePriority\">";
				if(level === 17)
					menuContent += "normal";
				else
					menuContent += level;
				menuContent += "</span>";
			}
			else if((dashboardDpList[index].writePriorityStart + 1) === dashboardDpList[index].writePriorityEnd) {
				menuContent += "<span id=\"menuDpValuePriority\">" + dashboardDpList[index].writePriorityStart + "</span>";
			}
			else {
				menuContent += "<select id=\"menuDpValuePriority\">";
				j = -1;
				for(i= dashboardDpList[index].writePriorityStart; i < (dashboardDpList[index].writePriorityEnd + 1); i ++) 
				{
					if(i === 17) {
						menuContent += "<option";
						if((level === i) || (j === -1))
							menuContent += " selected";
						menuContent += ">normal</option>";
					}
					else {
						menuContent += i;
						menuContent += "<option";
						if(level === i) {
							menuContent += " selected";
							j = i;
						}
						menuContent += ">" + i + "</option>";
					}
				}
				menuContent += "</select>";
			}
			menuContent += "<button style=\"margin-left:10px;float:right\" onclick='menuStructuredDpDialogValueCancel()'";
			if(!bEditModeEnabled)
				menuContent +=  " disabled";
			menuContent += ">Cancel</button>"
			menuContent += "</div><br><br>";
			if((dashboardDpList[index].displayElements[displayElementIndex].field === "") && ((displayType === "s0") || (displayType === "s1")
				|| (typeof value === "object"))) {
				menuValueDisplayType = "object";
			}

			if(dashboardDpList[index].displayElements[displayElementIndex].field === "") {
				// add preset dropdown
				if (typeof dashboardDpList[index].presets !== "undefined") {
					if(dashboardDpList[index].presets.map.length > 0) {
						menuContent += "Presets: ";
						menuContent += "<select id=\"menuDpValuePresetSelect\" onchange=\"menuDpValueDivPresetSelectChanged('" + menuValueDisplayType + "'," + index + "," + displayElementIndex + ",'" + displayId + "','" +  programmaticPathname + "')\">";
						menuContent += "<option ";
						if (dashboardDpList[index].presetValue !== null)
							menuContent += " selected";
						menuContent += ">   </option>";
						for(i=0; i < dashboardDpList[index].presets.map.length; i++)
						{

							

							menuContent += "<option";
							if (dashboardDpList[index].presetValue !== null) {
								if(dashboardDpList[index].presetValue.toLowerCase() === dashboardDpList[index].presets.map[i].name.toLowerCase())
									menuContent += " selected";
							}
							menuContent += ">" + dashboardDpList[index].presets.map[i].name + "</option>";
						}
						menuContent += "</select>";
						menuContent += "<br><br>";
					}
				}
			}
			
			
			if((dashboardDpList[index].displayElements[displayElementIndex].field === "") && (displayType !== "s3") && (displayType !== "s4")
				&&  ((displayType === "s0") || (displayType === "s1") || (typeof value === "object"))) {
			//else if((dashboardDpList[index].displayElements[displayElementIndex].field === "") && (typeof dashboardDpList[index].locValue === "object")) {
				readonly = dashboardDpList[index].displayElements[displayElementIndex].readonly;
				/* remove
				menuContent += "<div><div style=\"clear:right\">";
				if(readonly){
					menuContent += "<button style=\"float:right;margin-left:20px\" onclick='menuStructuredDpDialogCancel()'>Close</button>"
				}
				else {
					menuContent += "<button onclick='menuStructuredDpDialogSave(" + index + ",\"" + programmaticPathname + "\")'>Send</button>";
					menuContent += "<button style=\"margin-left:20px\" onclick='menuStructuredDpDialogCancel()'>Cancel</button>"
				}
				menuContent += "</div><br>";
				menuContent += "</div>";
				*/
				menuContent += "<div id=\"StructuredDpTreeDiv\"><br><br></div>"
				menuContent += "<br>";
				
				bShowStructure = true;
			}
			else {
				menuContent += "<div class=\"menuDivDpValueDiv\">";
				/*
				if((displayType === "s2") || (displayType === "s3") || (displayType === "s4") 
					|| (displayType === "l2") || (displayType === "l3") || (displayType === "l4")) {
					

				} */
				menuContent += "<br><br><div style=\"display: flex\">";
				menuContent += "<div style=\"inline-block\">Value: </div>";
				menuContent += "<div style=\"margin-left:10px\">";
				if((displayType === "s2") || (displayType === "s3") || (displayType === "s4")) {
						
					menuContent += createMenuSwitchLedElements(0, "menu_" + dashboardDpList[index].programmaticPathname, displayType, locValue);
				}
				else { 
					tempObj = null;
					if(displayType === "sl") {
						bLongText = false;
						if(typeof dashboardDpList[index].displayElements[displayElementIndex].guageObj !== "undefined") {
							if(dashboardDpList[index].displayElements[displayElementIndex].guageObj !== null) {
								tempObj = dashboardDpList[index].displayElements[displayElementIndex].guageObj
							}
						}
						if(tempObj !== null) {
							menuContent += '<input type="range" id="menuDpValueSlider_' + dashboardDpList[index].programmaticPathname + '"'; 
							if(typeof locValue === "number")
								menuContent += ' value="' + locValue + '"';
							if(typeof tempObj.guageMin !== "undefined") {
								if(tempObj.guageMin !== null) {
									menuContent += ' min="' + tempObj.guageMin + '"';
								}
							}
							if(typeof tempObj.guageMin !== "undefined") {
								if(tempObj.guageMin !== null) {
									menuContent += ' max="' + tempObj.guageMax + '"';
								}
							}
							//tablePaneContent += ' class="slider" onchange="sliderChanged(this, \"' + displayId + '\", ' + i + ',' + t + ')"></div>'
							menuContent += " class=\"slider\" style=\"margin-right:10px\" onchange=\"menuDpValueSliderChanged(this, " + index + "," + displayElementIndex + ",'" + displayId + "','" + dashboardDpList[index].programmaticPathname  + "')\"></div>";
						}
					}
					menuContent += "<div class=\"tdNewValueDiv\">";
					if(g_bEditModeEnabled && bEnum) {
						menuContent += "<select id=\"menuDpValueCurrentValue_" + dashboardDpList[index].programmaticPathname + "\">";
						for(i=0; i < enums.length; i++)
						{
							menuContent += "<option value=\"" + enums[i].id + "\"";
							if(enums[i].id === locValue)
								menuContent += " selected";
							menuContent += ">" + enums[i].id + "</option>";
						}
						menuContent += "</select>";
					}
					else {
						menuContent += "<input class=\"";
						if(bLongText)
							menuContent += "menuDpValueInputLong";
						else
							menuContent += "menuDpValueInput";
						menuContent += "\" id=\"menuDpValueCurrentValue_" + dashboardDpList[index].programmaticPathname + "\"";
						menuContent += 	" value=\"" + locValueStr + "\"";
						if((displayType === "sl") && (tempObj !== null)) {
							menuContent += 	"onchange=\"menuDpValueSliderValueChanged(this, " + index + "," + displayElementIndex + ",'" + displayId + "','" + dashboardDpList[index].programmaticPathname  + "')\"";
						}
						if(!bEditModeEnabled)
							menuContent += " disabled";
						menuContent += ">";
					}
					menuContent += "</div>";
				}
				menuContent += "</div>";
				menuContent += "<div><button style=\"margin-left:10px\" onclick=\"_menuDpValueSave(0," + index + "," + displayElementIndex + ",'"  +  dashboardDpList[index].programmaticPathname + "'," + null + ",'" + defaultField + "')\""
				if(!bEditModeEnabled)
					menuContent +=  " disabled";
				menuContent += ">Send</button></div>";
				menuContent += "</div>";
				menuContent += "<br>";
				menuContent += "</div><br>";
			}

			menuContent += "</div>";
			bValuedDivCreated = true;
		}
		
		
		if(mode !== 1) {
			//priority

			menuContent += "<div id=\"menuDivDpPriorityDivId\">";
			menuContent += "<br><hr>";
			
			//menuContent += "<button style=\"float:right\" onclick=\"menuDpValueRefresh(" + index + ",'" + programmaticPathname + "')\">Refresh</button>";
			menuContent += "<button style=\"float:right\" onclick=\"menuDpValuePrioritiesRefresh(0," + index + "," + displayElementIndex + ",'" + displayId + "','"  +  dashboardDpList[index].programmaticPathname + "')\">Refresh</button>";
			menuContent += "<br><br>";
			if(defaultField !== "") {
				menuContent += "<input type=\"radio\" id=\"menudpOverrideRadioButtonValue\" name=\"menudpOverrideRadioButton\" onclick=\"menuDpValueOverrideValueSelect()\" value=\"value\" checked>"
				menuContent += "<label for=\"menudpOverrideRadioButtonValue\">Value</label>";
				menuContent += "<input type=\"radio\" id=\"menudpOverrideRadioButtonFullValue\" name=\"menudpOverrideRadioButton\" onclick=\"menuDpValueOverrideValueSelect()\" value=\"fullvalue\">"
				menuContent += "<label for=\"menudpOverrideRadioButtonFullValue\">Full value</label>";
				menuContent += "<input type=\"radio\" id=\"menudpOverrideRadioButtonBoth\" name=\"menudpOverrideRadioButton\" onclick=\"menuDpValueOverrideValueSelect()\" value=\"both\">"
				menuContent += "<label for=\"menudpOverrideRadioButtonBoth\">Both</label>" 
				menuContent += "<br>"
			}
			menuContent += "<table id=\"priorityTable\"><thead><tr><th>Override</th>";
			if(defaultField !== "") {
				menuContent += "<th>Value</th><th>Full Value</td>";
			}
			else 
				menuContent += "<th>Value</th>";
			menuContent += "<th>Relinquish</th><th></th></tr></thead><tbody>"
			//menuContent += "<table id=\"priority\"><thead><tr><th>Level</th><th>Active</th><th>Value</th><th>Remove</th></tr></thead><tbody>"
				// priority array
			sLevel = values.level.toString();
			if(levels !== null) {
				for(x in levels)
				{
					menuContent += "<tr><td>";
					x1 = Number(x);
					if(x === "17")
						menuContent += "normal";
					else
						menuContent += x;
					//	menuContent += "ALWAYS";
					//menuContent += "</td>";
					menuContent +=  "</td>"; 
					if(defaultField !== ""){
						menuContent += "<td class=\"tdValue\"><div class=\"tdValueDiv\">";
						value2 = readFieldValue(levels[x], defaultField);
						if(value2.valid)
							menuContent += value2.data; 
						menuContent += "</div></td>";
					}
					menuContent += "<td class=\"tdValue\"><div class=\"tdValueDiv\">";
					if((displayType === "s2") || (displayType === "s3") || (displayType === "s4")) {
						
						displayType1 = "l" + displayType.charAt(1);
						menuContent += createMenuSwitchLedElements(0, "priorityarray_" + x1, displayType1, levels[x]);
					}
					else {
						
						menuContent += JSON.stringify(levels[x]);
					}
					menuContent += "</div></td><td>";
					if(x !== "17") {
						if((x1 >= dashboardDpList[index].writePriorityStart) && (x1 < dashboardDpList[index].writePriorityEnd)) {
							count ++; // used to determine if need to hide buttons
							menuContent += "<input type=\"checkbox\" id=\"menuDiv_priority_" + x1 + "\">";
							g_menuDivPermissions.push(x1);
							//menuContent += "<button style=\"float:right\" onclick=\"clearDpOverrideFromTable('priority', this," + Number(x) + ", '" +  programmaticPathname + "')\">Relinquish</button>";
						}
						
					}
					menuContent += "</td><td>";
					if(x === sLevel) 
						menuContent += " * ";
					menuContent += "</td></tr>";	
				}
			}
			menuContent += "</tbody></table>";
			menuContent += "Relinquish Permission: " + sPermittedPriorites;
			menuContent += "<br><br>";
			menuContent += "<button id=\"_relinquishSelectedPriorities\" style=\"margin-right:10px\" onclick=\"_relinquishSelectedPriorities(1,'" + dashboardDpList[index].pathname +"'," + index + ")\"";
			if(!bEditModeEnabled)
				menuContent +=  " disabled";
			menuContent += ">Relinquish Selected</button>";
			menuContent += "<button id=\"_priorityRelinquishAll\" style=\"float:right\" onclick=\"_relinquishSelectedPriorities(0,'" + dashboardDpList[index].pathname +"'," + index + ")\"";
			if(!bEditModeEnabled)
				menuContent +=  " disabled";
			menuContent +=">Relinquish All</button>";
			//menuContent += "<button id=\"_priorityRelinquishAll\" style=\"float:right\" onclick=\"_menuPriorityRelinquishAll('" + n.id + "')\">Relinquish All</button>";
			menuContent += "<br><br>";
			menuContent += "</div>";
			bPriorityDivCreated = true;
						
		}
		
		menuContent += "</div>";
		
		menuContent += "</div></div>";
		menuContent += "</div>";
		menuContent += "</div>";
		document.getElementById("menuDiv").innerHTML = menuContent;
		
		dragDiv("menuDiv");
		if(mode !== 1) {
			if(document.getElementById("priorityTable") !== null) {
				//tableCreateResizableTable("priorityTable"); //ffix currently max-width used need to remove max-width
			}
		}
		

		/* navttree not sure this is needed anymore -- fix this needs to be readded

		if(mode !== 2) {
			if(!bPresetsAdded) {
				if(g_bUseLocalizationForAllWrites)
					document.getElementById("menuDpValueCurrentValue_" + pathname).value = locValueStr;
				else 
					document.getElementById("menuDpValueCurrentValue_" + pathname).value = valueStr;
			}
			document.getElementById("menuDpValueUseLocalValue_" + pathname).checked = g_bUseLocalizationForAllWrites;
		}
		document.getElementById("menuDpValuePriority_" + pathname).value = values.level; // show current priority
		if(mode !== 1) {
			if(count === 0) {
				document.getElementById("_priorityRelinquishAll").disabled = true;
				document.getElementById("_relinquishSelectedPriorities").disabled = true;
			}
		}	
		*/
		if(bShowStructure) {
			//menuContent = menuStructuredDpDialogBuildFieldTree(mode, n, readonly,index, displayElementIndex, programmaticPathname, field);
			dpTypeObj.dpType = "Value";
			if(dashboardDpList[index].displayElements[displayElementIndex].field === "") {
                value = dashboardDpList[index].value;
                if(typeof dashboardDpList[index].type !== "undefined") {
					dpTypeObj.dpType= dashboardDpList[index].type;
					dpTypeObj.snvtTypeObj = null;
					// add SNVTdata
					for(i=0; i < g_snvtTypes.length; i++)
					{
						//if(dashboardDpList[index].type === g_snvtTypes[i].typeId) {
						if(dashboardDpList[index].type === g_snvtTypes[i].typeRef) {
							dpTypeObj.snvtTypeObj = JSON.parse(JSON.stringify(g_snvtTypes[i]));
							break;
						}
					}
				}
                
                //content = menuStructuredDpdecodedJson(value, "", 0, dptype, readonly); // div content
            }
			saveObj = {};
			saveObj.type = "menuDpValue";
			saveObj.index = index;
			saveObj.displayElementIndex = displayElementIndex;
			saveObj.programmaticPathname = dashboardDpList[index].programmaticPathname;
			menuContent = menuStructuredDpdecodedJsonTree(locValue, "", 0, dpTypeObj, readonly,false, saveObj); // tree view
            element = document.getElementById("StructuredDpTreeDiv");
            if(element !== null)
                element.innerHTML = menuContent;
		}
		if(bValuedDivCreated && bPriorityDivCreated ) {
			if(iSelectedDiv !== -1) {
				if(iSelectedDiv === 1) {
					document.getElementById("menuDivDpPriorityDivId").style.display = "none";
					document.getElementById("menuDivDpAlarmDivId").style.display = "none";
				}
				else if(iSelectedDiv === 2) {
					document.getElementById("menuDivDpValueDivId").style.display = "none";
					document.getElementById("menuDivDpAlarmDivId").style.display = "none";
				}
				else if(iSelectedDiv === 3) {
					document.getElementById("menuDivDpValueDivId").style.display = "none";
					document.getElementById("menuDivDpPriorityDivId").style.display = "none";
				}
				else if(iSelectedDiv === 4) {
					document.getElementById("menuDivDpValueDivId").style.display = "none";
					document.getElementById("menuDivDpPriorityDivId").style.display = "none";
				}
			}
		}
		if(defaultField !== "")
			menuDpValueOverrideValueSelect();
		
	}
	catch {}
}
function menuDpValueScheduleValue(mode, n) {
	//mode: 0= show all (value and priority array), 1= no priority array, 2 =show only priority array 3=show only alarm

	//pathname is programmatic pathname
	try { 
		//var event1 = window.event;
		var x = 0; // = event.clientX;
		var y = 0;// = event.clientY;
		var menuContent = "",pathname,displayIdPath;
		var bContinue = false;
		var offsets;
		var value = null;
		var values = null, levels = null;
		var dpIndex;
		var presets = null;
		var obj = null,iPtr;
		var menuDivXOffset = 30;//-250;
		var menuDivYOffset = 20;
		var menuDivWidth = 150;
		var menuButton = document.getElementById("eventValue");
		if(menuButton === null)
			return;
		if(!menuButton.readOnly)
			return;

		g_bInoreMouseClick = true;
		g_bAlwaysIngnoreMouseClick = true; // needed otherwise clicking dropdown will close window
		menuStructuredDpDialogCancel();
		
		
		

		cursorClearWait();
		
		menuContent = "<div class=\"menuDivBorder\">";
		menuContent += "<div>";
		menuContent += "<div class=\"menuDivName\">";
		
		menuContent += "</div>";
		menuContent +="<button style=\"float:right\" onclick=\"menuDivClose()\">X</button>";
		menuContent += "</div>";
		

		//menuContent += "<br><br>Getting Current Data....<br><br>";
		
		
		
		
		
		if(menuButton !== null) {
			offsets = menuButton.getBoundingClientRect(); 
			//if((offsets.x + offsets.width + window.pageXOffset + menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
			if((offsets.x + window.pageXOffset + menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
				x = offsets.x + window.pageXOffset - menuDivWidth - 10; // takes into account viewport (scrolling)
			else
				//x = offsets.x + offsets.width + window.pageXOffset + menuDivXOffset; // takes into account viewport (scrolling)
				x = offsets.x + window.pageXOffset + menuDivXOffset; // takes into account viewport (scrolling)
			
			y = offsets.y + window.pageYOffset - menuDivYOffset; // takes into account viewport (scrolling)
			if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
				x += menuDivXOffset;
				y -= 70;
			}
			else if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
				x += menuDivXOffset;
				y -= 70;
			}
			document.getElementById("menuDiv").style.left = x.toString() + "px";
			document.getElementById("menuDiv").style.top = y.toString() + "px";
			document.getElementById("menuDiv").innerHTML = menuContent;
			document.getElementById("menuDiv").className = "menuDivDpSearchShow";  // doesn't currently guaranty that menu is shown in viewport
			menuOverlayDivShow(0, null);
			g_bInoreMouseClick = true;
			//document.addEventListener("click", menuMouseCancel);
			//document.addEventListener("click", function() {menuMouseCancel(event);});
			menuDpValueSetupScheduleValue(mode, n);
		}
		else 
			return;

		
	} catch {}
}
function menuDpValueSetupScheduleValue(mode, n){
	//mode: 0=show both values and priority array, 1=show values only, 2=show only priority array, 3= show alarm only, 4=same as but values selected, 5=same as 0 but priority selected, 6=same as 0 but alarm selected 
	//      10= same as 0 but show device name, 11= same as 1 but show device name, 12=same as 2 but show device name, 13=same as 3 but show device name
	
	try {
		var i, j, z, len,iPtr, count;
		var pathname = "";
		var id = " ", name = " ", name1, value, valueStr, locValue, locValueStr, type, enums = null, dptype, saveObj; 
		var obj;
		var x, x1;
		var menuContent = "", element;
		var bContinue = false;
		var presets = null;
		var presetValue = "";
		var bPresetsAdded = false;
		var datapointQualifier = "";
		var bNumber = false;
		var sLevel, level;
		var priority = "";
		var values;
		var urlPathname = ""; // uses xif pathname
		var bUseDropdown = false;
		var sPermittedPriorites = "";
		var menuDiv = null;
		var snvtObj = {}, dpTypeObj = {};
		var bShowDeviceName = false;
		var displayType;
		var bShowStructure = false,readonly = true;
		var field = "",displayIdPath;
		var bValuedDivCreated = false;
		var bPriorityDivCreated = false;
		var iSelectedDiv = -1;
		var menuValueDisplayType ="input"; //input
		var presetContent = "";
		var bShowAdvancedInfo = false;
		//eventValue
		
		
		g_menuDivPermissions = [];
		
		bContinue = true;
		
		
		menuContent = "<div class=\"menuDivBorder\">";

		menuContent += "<div>";
		menuContent += "<div id=\"menuDivHeader\" class=\"menuDivName menuDivDpValueShowDragDivHeader1\">Schedule: ";
		element = document.getElementById("eventName");
		if(element !== null)
			menuContent += element.value;
		menuContent += "</div>";
		menuContent += "<div style=\"display:inline-block;float:right;margin-top:5px\">"
		menuContent += "<button style=\"margin-left:30px\" onclick='menuDpValueSetupScheduleSave()'>Save</button>"
		menuContent += "<button style=\"margin-left:30px;margin-right:5px;\" onclick=\"menuDivClose()\">X</button>";
		
		menuContent += "</div>";
		menuContent += "</div>";

		menuContent += "<br><br>";

		menuContent += "<div id=\"StructuredDpTreeDiv\"><br><br></div>"
		

		menuContent += "</div>"
		document.getElementById("menuDiv").innerHTML = menuContent;
		dragDiv("menuDiv");

		

		/* navttree not sure this is needed anymore -- fix this needs to be readded

		if(mode !== 2) {
			if(!bPresetsAdded) {
				if(g_bUseLocalizationForAllWrites)
					document.getElementById("menuDpValueCurrentValue_" + pathname).value = locValueStr;
				else 
					document.getElementById("menuDpValueCurrentValue_" + pathname).value = valueStr;
			}
			document.getElementById("menuDpValueUseLocalValue_" + pathname).checked = g_bUseLocalizationForAllWrites;
		}
		document.getElementById("menuDpValuePriority_" + pathname).value = values.level; // show current priority
		if(mode !== 1) {
			if(count === 0) {
				document.getElementById("_priorityRelinquishAll").disabled = true;
				document.getElementById("_relinquishSelectedPriorities").disabled = true;
			}
		}	
		*/
			element = document.getElementById("eventValue");
			if(element === null) {
					element.innerHTML = "Internal Error: Can't get event value";
				return;
			}
			value = element.value;
			value = JSON.parse(value);
			//menuContent = menuStructuredDpDialogBuildFieldTree(mode, n, readonly,index, displayElementIndex, programmaticPathname, field);
			dpTypeObj.dpType = "Value";
			dpTypeObj.snvtTypeObj = null;

			var element = document.getElementById("eventDatapointTypeSelect");
			if(element !== null) {
				dpTypeObj.dpType = element.options[element.selectedIndex].text;
				
				for(i=0; i < g_dpTypesAvailableList.length; i++)
				{
					if(g_dpTypesAvailableList[i].typeId === dpTypeObj.dpType) {
						dpTypeObj.snvtTypeObj = JSON.parse(JSON.stringify(g_dpTypesAvailableList[i]));
						break;
					}
				}
				
			}

			saveObj = {};
			saveObj.type = "menuScheduleEvents";
			saveObj.index = -1;
			saveObj.displayElementIndex = "";
			saveObj.programmaticPathname = "";
			menuContent = menuStructuredDpdecodedJsonTree(value, "", 0, dpTypeObj, false,false, saveObj); // tree view
            element = document.getElementById("StructuredDpTreeDiv");
            if(element !== null)
                element.innerHTML = menuContent;
		
		
	}
	catch {}
}
function menuDpValueSetupScheduleSave() {
	try {
		var value, element;
		var bAbort = false;
    	var result;
    	var newValue;
    	var data;
		if(!menuStructuredDpInputErrorCheckAll()) {
			showAlertDialog(0,"Error: One or more values are wrong. \r\nCorrect and try again");
			return;
		}
		element = document.getElementById("eventValue");
		if(element === null) {
				element.innerHTML = "Internal Error: Can't get event value";
			return;
		}
		value = element.value;
		data = JSON.parse(value);
		for(i=0; i < g_structuredDpsDialogFields.length; i++)
		{
			element = document.getElementById(g_structuredDpsDialogFields[i].displayId)
			if(element !== null) {
				if(element.tagName === "SELECT") {
					newValue = element.options[element.selectedIndex].text;
				}
				else {
					newValue = element.value;
					if((g_structuredDpsDialogFields[i].type === "number") && (typeof newValue === "string")) {
						newValue = Number(newValue);
						if(isNaN(newValue)) {
							bAbort = true;
						}
					}
				}
				if(!bAbort) {
					result =  readFieldValue(data, g_structuredDpsDialogFields[i].fieldPath);
					if(result.valid) {
						if(newValue !== result.data) { //compare against current value
							result = changeFieldValue(data, g_structuredDpsDialogFields[i].fieldPath, newValue)
							if(!result.valid) {
								bAbort = true;
								break;
							}
						}
					}
					else {
						bAbort = true;
						break;
					}
				}
				else 
					break;
			}
			else {
				bAbort = true;
				break;
			}

		}
		if(bAbort) {
			showAlertDialog(0,"Can't process update: missing HTML element or Can't find field");
			return;
		}
		element = document.getElementById("eventValue");
		if(element === null) {
				element.innerHTML = "Internal Error: Can't save event value";
			return;
		}
		element.value = JSON.stringify(data);
		menuDivClose();
	}
	catch {}
}
function menuDpValueInputBoxKey(n, event, index, displayElementId, pathname) {
	// determine if value matches a preset
	try {
		var valueStr = document.getElementById("menuDpValueCurrentValue_" + pathname).value;
		var presets = null;
		var bContinue = false;
		var i; 
		var values;
		if(valueStr === "") {

		}
		else if(g_iMainDisplayMode === DISPLAYMODE_DPS) {
			if(index < dpList.length) {
				if(dpList[index].pathname === pathname) {
					bContinue = true;
					presets = dpList[index].presets;
				}
			}
		}
		else if(g_iMainDisplayMode === DISPLAYMODE_FAVDPS) {
			if(index < favDpList.length) {
				if(favDpList[index].pathname === pathname) {
					bContinue = true;
					presets = favDpList[index].presets;
				}
			}
		}
		if(bContinue) {
			if(presets !== null) {
				if(!(typeof presets[0].value === "number"))
					value = JSON.parse(valueStr);
				else 
					value = Number(valueStr);

				for(i=0; i < presets.length; i ++)
				{
					if(isEqual(presets[i].value, value))	{
						document.getElementById("menuDpValuePreset_" + pathname ).selectedIndex = i.toString();
						break;
					}
				}
			}
		}
	} catch { } // expect a lot of exceptions as user will be doing back spaces and adding content
}
function menuDpValuePresetChanged(index, displayElementId, pathname) {
	try {
		var presetValue = document.getElementById("menuDpValuePreset_" + pathname).value;
		var presets = null;
		var bContinue = false;
		var i; 
		if(g_iMainDisplayMode === DISPLAYMODE_DPS) {
			if(index < dpList.length) {
				if(dpList[index].pathname === pathname) {
					bContinue = true;
					presets = dpList[index].presets;
				}
			}
		}
		else if(g_iMainDisplayMode === DISPLAYMODE_FAVDPS) {
			if(index < favDpList.length) {
				if(favDpList[index].pathname === pathname) {
					bContinue = true;
					presets = favDpList[index].presets;
				}
			}
		}
		if(bContinue) {
			if(presets !== null) {
				for(i=0; i < presets.length; i ++)
				{
					if(presets[i].name === presetValue){
						document.getElementById("menuDpValueCurrentValue_" + pathname).value = JSON.stringify(presets[i].value);
						break;
					}
				}
			}
		}
	}
	catch {}
}
function menuDpValueRefresh(index , pathname) {
	try {
		var url = pathname;
		var iPtr = pathname.indexOf("/");
		if(iPtr > 0) {
			url = pathname.substr(0,iPtr) + "/if" + pathname.substr(iPtr) + "/*";
		}
		url = encodePathString(url); // url.replace(/ /g,"%20").replace(/:/g,"%3A").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
		url = "https://" + location.host + "/iap/devs/*+name==" + url + "/*";
		requestGetData(index, url, menuDpValueRefreshResponse, null); // get Device list
	}
	catch {}	
}

function menuDpValueRefreshResponse(index , requestUrlString, json) {
try {
		var pathname = requestUrlString;
		var pathnames;
		var programmaticPathname = "";
		var iPtr;
		var mode = 0;
		var priorityElement;
		
		//if(g_iMainDisplayMode === DISPLAYMODE_PLANNING)
		//	getPlanningTreeShowTreeDatapointsRequestProcessWebSocketData(1,"websocketdata", json); // refresh results
		//else
		processGetDeviceDpData(43, 0, requestUrlString, json); 
		return;
		iPtr = requestUrlString.indexOf("==");
		if(iPtr > 0) {
			iPtr += 2;
			pathname = pathname.substr(iPtr);
			pathnames = pathname.split("/");
			pathname = pathnames[0] + "/" + pathnames[2] + "/" + pathnames[3] + "/" + pathnames[4];
			programmaticPathname = pathname.replace(/%20/g," ").replace(/%3A/g,":").replace(/%5B/g,"[").replace(/%5D/g,"]"); // programmaticPathname

			// Determine pathname
			if(g_iMainDisplayMode === DISPLAYMODE_DPS) {
				if(index < dpList.length) {
					if(dpList[index].programmaticPathname === programmaticPathname) {
						pathname = dpList[index].pathname;
						menuDpValue(null, index, pathname);
					}
						
				}
			}
			else if(g_iMainDisplayMode === DISPLAYMODE_FAVDPS) {
				if(index < favDpList.length) {
					if(favDpList[index].programmaticPathname === programmaticPathname) {
						pathname = favDpList[index].pathname;
						menuDpValue(null,  index, pathname);
					}
				}
			}
			else if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
				if(index < dashboardDpList.length) {
					if(dashboardDpList[index].programmaticPathname === programmaticPathname) 
					{
						pathname = dashboardDpList[index].pathname;
						mode = 2;
						if(dashboardDpList[index].dashboardType === "c")
							mode = 0;
						else {

						}
						menuDpValue1(mode, null, index, pathname);
					}
				}
			}
			else if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
				if(index < planningDpList.length) {
					if(planningDpList[index].programmaticPathname === programmaticPathname) 
					{
						pathname = planningDpList[index].pathname;
						menuDpValue1(0, null, index, pathname);
					}
				}
			}
			else
				pathname = "";
			
		}
		
		
	}
	catch {}
}

function _menuDpValueSave(mode, index, displayElementIndex, programmaticPathname, newValue, field) {
	// mode:0=uses input element, 1=structured DP
	try {
		var bContinue = false;
		var i;
		var url, parameter, urlPath;
		var iPtr;
		var presetValue, valueStr, iTemp;
		var value;
		var char;
		var bNumber = null, bString = false, bEnum = false;;
		var objs = null, chartIndex;
		var priorityElement = null;
		//var presetValueElement = document.getElementById("menuDpValuePreset_" + pathname); 
		var valueElement;
		var priorityElement = document.getElementById("menuDpValuePriority");
		var bUseLocalValue = g_bUseLocalizationForAllWrites;
		var displayType = "";
		var element, element1;
		var sTemp;
		var sErrMsg, type1;
		
		
		if(priorityElement === null) {
			showAlertDialog(0,"error: can't write value");
			return;
		}
		if(priorityElement.tagName === "SPAN") {
			priority = priorityElement.innerHTML;
		}
		else {
			priority = priorityElement.options[priorityElement.selectedIndex].text;
			if(priority.trim() === "") { 
				showAlertDialog(0,"Error: Priority not selected\r\n\r\nPlease Select Priority and try again");
				return;
			}
		}
		if(priority.toLowerCase() === "normal")
			priority = 17;
		else
			priority = Number(priority);
		
		if(index < dashboardDpList.length) {
			if(dashboardDpList[index].programmaticPathname === programmaticPathname) {
				bContinue = true;

				// save old value incase write priority is not the latest 
				dashboardDpList[index].saved = {};
				if(dashboardDpList[index].bStructure) {
					dashboardDpList[index].saved.value = JSON.parse(JSON.stringify(dashboardDpList[index].value));
					dashboardDpList[index].saved.locValue = JSON.parse(JSON.stringify(dashboardDpList[index].locValue));
				}
				else {
					dashboardDpList[index].saved.value = dashboardDpList[index].value;
					dashboardDpList[index].saved.locValue = dashboardDpList[index].locValue;
				}
				dashboardDpList[index].saved.valueStr = dashboardDpList[index].valueStr;
				dashboardDpList[index].saved.locValueStr = dashboardDpList[index].locValueStr;
				dashboardDpList[index].saved.presetValue = dashboardDpList[index].presetValue;
				dashboardDpList[index].saved.priority = dashboardDpList[index].priority;

				// continue with new values

				presets = dashboardDpList[index].presets;
				value = dashboardDpList[index].value;
				if(typeof value === "number")
					bNumber = true;
				else if(typeof value === "string")
					bString = true;
				objs = dashboardDpList;
				value = newValue;
				displayType = dashboardDpList[index].displayElements[displayElementIndex].dashboardType;
				//field = dashboardDpList[index].displayElements[displayElementIndex].field;
				bNumber = dashboardDpList[index].displayElements[displayElementIndex].bNumber;
				bString = dashboardDpList[index].displayElements[displayElementIndex].bString;
				bEnum = dashboardDpList[index].displayElements[displayElementIndex].bEnum;
				if(field !== "") {
					if(typeof dashboardDpList[index].snvtType !== "undefined") {
						dpTypeParams = readSnvtTypeFieldValue(dashboardDpList[index].snvtType, field);
						if(dpTypeParams.valid) {
							bNumber = false;
							bString = false;
							bEnum = false;
							if(field === "")
								type1 = dpTypeParams.data.valueType.toLowerCase();
							else 
								type1 = dpTypeParams.data.type.toLowerCase();
							
							if(type1 === "object") {
								
							}
							else if(type1 === "boolean") {
								
							}
							else if((type1 === "bitfield")  || (type1 === "scalar") || (type1 === "integer") || (type1 === "float")) {
								bNumber = true;
							}
							else if(type1 === "enum") {
								bEnum = true;
							}
							else if(type1 === "string") {
								bString = true;
							}
							else 
								bNumber = dashboardDpList[index].displayElements[displayElementIndex].bNumber;
						}
					}
				}
			}
		}
		
		if(bContinue) {
			if(mode === 0) {
				if(displayType === "s2") {
					element = document.getElementById("localValueSwitch_menu_" + programmaticPathname);//mike
					if(element !== null) {
						value = 0;
						if(element.checked)
							value = 1;
						if(dashboardDpList[index].displayElements[displayElementIndex].bBoolean) {
							if(value === 1)
								value = true;
							else
								value = false;
						}
						valueStr = value;
					}
				}
				else if (displayType === "s3") {
					element = document.getElementById("localValueSwitch_menu_" + programmaticPathname);//mike
					element1 = document.getElementById("localValue_menu_" + programmaticPathname);
					sErrMsg = "value must be greater than or equal to 0 and less than or equal to 100"
					if((element !== null) && (element1 !== null)) {
						value = {};
						iTemp = 0;
						if(element.checked)
							iTemp = 1;
						value.state = iTemp;
						sTemp = element1.value;
						if(isNaN(sTemp)) {
							sErrMsg += "\r\n\r\nThe following is not a valid number: " + sTemp;
							showAlertDialog(0,sErrMsg)
							return;
						}
						iTemp = Number(sTemp);
						if(!Number.isInteger(iTemp)){
							sErrMsg += "\r\n\r\nThe following is not a valid number: " + sTemp;
							showAlertDialog(0,sErrMsg)
							return;
						}
						if((iTemp < 0) || (iTemp > 100)) {
							sErrMsg += "\r\n\r\nThe following is not a valid number: " + sTemp;
							showAlertDialog(0,sErrMsg)
							return;
						}
						value.value = iTemp;
						valueStr = JSON.stringify(value);
					}
				} 
				else if (displayType === "s4") {
					element = document.getElementById("localValueSwitch_menu_" + programmaticPathname);//mike
					if(element !== null) {
						value = {};
						value.state = 0;
						value.value = 0;
						if(element.checked) {
							value.state = 1;
							value.value = 100;
						}
						valueStr = JSON.stringify(value);
					}
				}
				else {
					valueElement = document.getElementById("menuDpValueCurrentValue_" + programmaticPathname);
					if(valueElement === null)
						return;
					value = valueElement.value;
				}
				
			
				/* dont send preset just send value
				char = value.charAt(0);
				if((char !== "{") && (char !== "[")) {
					if(objs[index].presets !== null) {
						if(typeof objs[index].presets !== "undefined") { // needed for internal apps
							if(objs[index].presets.enabled) {
								if(objs[index].presets.map.length > 0) {
									for(i=0; i < objs[index].presets.map.length; i++)
									{
										if(value === objs[index].presets.map[i].name) {
											objs[index].presetValue = objs[index].presets.map[i].name;
											if(bUseLocalValue) {
												objs[index].locValue = objs[index].presets.map[i].value;
												objs[index].locValueStr = JSON.stringify(objs[index].value);
												objs[index].value = "";
												objs[index].valueStr = "";
											}
											else {
												objs[index].locValue = "";
												objs[index].locValueStr = "";
												objs[index].value = objs[index].presets.map[i].value;
												objs[index].valueStr = JSON.stringify(objs[index].value);
											}
											objs[index].priority = priority;
												document.getElementById("localValue_" + pathname).innerHTML = valueStr;
												priorityElement = document.getElementById("priority_" + pathname);
												if(priorityElement !== null) 
													//priorityElement.innerHTML = priority;  //<input>
													priorityElement.value = priority; // <select>
											
											urlPath = encodePathString(objs[index].urlPath);
											//urlPath = objs[index].urlPath.replace(/ /g,"%20").replace(/:/g,"%3A").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
											sendPresetValue(value, urlPath, false, priority);
											objs[index].updateDpValue = true; // sync up value, localValue and Preset on next read
											g_sUpdateDataPoint = urlPath; //pathName;
											g_iUpdateDataPointCount = 0;
											menuCancel();
											return;  
										}
									}
								}
							}
						}
					}
				}
				*/
			}
			else 
				valueStr = JSON.stringify(value); // mode 1 value is object


			if(bContinue) {
				if((mode === 0) && (displayType !== "s2") && (displayType !== "s3") && (displayType !== "s4")) {
					valueStr = valueElement.value;
					if(bNumber) {
						valueStr = Number(valueStr);
					}
					else if((field === "") && (bString || bEnum))
						valueStr = "\"" + valueStr + "\"";
					if(field !== "") {
						//valueStr = changeFieldValue(objs[index].locValue, objs[index].displayElements[displayElementIndex].field, valueStr);
						valueStr = changeFieldValue(objs[index].locValue, field, valueStr);
						if(valueStr.valid) 
							valueStr = JSON.stringify(valueStr.data);
						else  {
							showAlertDialog(0,"Can't process input data");
							return;
						}
					}
				}
				
					// add feedback
				objs[index].feedbackDelay = true;
				var currentTime = new Date().getTime();
				objs[index].feedbackDelayTimeout = currentTime + g_iFeedbackDelayTime; // ms  10000 = 10 s
				objs[index].feedbackDelayOldValue = JSON.parse(JSON.stringify(objs[index].locValue));

				/*
				if(!(typeof valueStr === "number")) {
					try {
						value = JSON.parse(valueStr)
					}
					catch 
					{
						alert("Error: Not Saved - value is not a valid JSON string \r\n\r\n" + valueStr)
						return;
					}
				}
				*/
 
				url = "https://" + location.host + "/iap/devs/*+name=="; 
				urlPath = encodePathString(objs[index].urlPath); //encodeUriString(objs[index].urlPath);
				//urlPath = objs[index].urlPath.replace(/ /g,"%20").replace(/:/g,"%3A").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
				if(!g_bUsePriorityForAllWrites && !bUseLocalValue)
					url = "/iap/devs/*+name==" + urlPath + "/value"; //iot
				else if(!g_bUsePriorityForAllWrites) 
					url = "/iap/devs/*+name==" + urlPath +  "/localization/value";
				else if (bUseLocalValue) {
					//localized and priority
					objs[index].priority = priority;
					url = "/iap/devs/*+name==" + urlPath + "/overrides/" + priority + "/localization/value";
				}
				else {
					// use value and priority 
					objs[index].priority = priority;
					url = "/iap/devs/*+name==" + urlPath + "/overrides/" + priority + "/value";
				}

				writeDpValue(1,url,valueStr, null, writeFailCallback);
				
				
				dashboardDpList[index].updateDpValue = true; // sync up value, localValue and Preset on next read
				dashboardDpList[index].presetValue = " ";
				dashboardDpList[index].bUpdatePriorityArray = true;
				dashboardDpList[index].priority = priority;
				if(bUseLocalValue) {
					dashboardDpList[index].locValue = value;
					dashboardDpList[index].locValueStr = valueStr;
					dashboardDpList[index].value = "";
					dashboardDpList[index].valueStr = "";
				}
				else {
					dashboardDpList[index].value = value;
					dashboardDpList[index].valueStr = valueStr;
					dashboardDpList[index].locValue = "";
					dashboardDpList[index].locValueStr = "";
				}
			
				/* replaced by 
				if(bUseLocalValue) {
					
					document.getElementById("localValue_" + pathname).innerHTML = valueStr;
				}
				else { 
					
					document.getElementById("localValue_" + pathname).innerHTML = "";
				}
				*/
				/* ffix this is for each display element so need to change
				priorityElement = document.getElementById("priority_" + pathname);
				if(priorityElement !== null) {
					if((g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) || (g_iMainDisplayMode === DISPLAYMODE_PLANNING))
						priorityElement.value = priority;
					else
						priorityElement.innerHTML = priority;
				}
				*/
				// change all UI elements 
				if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD){
					dashboardProcessWriteDpDataUpdateUi(index, dashboardDpList[index].dpQualifier);
				}
				else if (g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
					dashboardProcessWriteDpDataUpdateUi(index, dashboardDpList[index].dpQualifier);
				}
				g_sUpdateDataPoint = urlPath; //pathName; // programmatic
				g_iUpdateDataPointCount = 0;
			}
		}
	}
	catch {}
	menuCancel();

}
function menuDpValueSavePriority(index , pathname) {
	// Dashboard table only priority saved
	try {
		var bContinue = false;
		var i;
		var url, parameter, urlPath;
		var iPtr;
		var presetValue, valueStr;
		var value;
		var char;
		var bNumber = null;
		var objs = null;
		var priorityElement = null;
		
		var priority = document.getElementById("menuDpValuePriority_" + pathname).value;
		
		priority = Number(priority);
		if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
			if(index < dashboardDpList.length) {
				if(dashboardDpList[index].pathname === pathname) {
					priorityElement = document.getElementById("priority_"+ dashboardDpList[index].pathname);
					if(priorityElement !== null)
						priorityElement.value = priority;
				}
			}
		}
		else if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
			if(index < planningDpList.length) {
				if(planningDpList[index].pathname === pathname) {
					priorityElement = document.getElementById("priority_"+ planningDpList[index].pathname);
					if(priorityElement !== null)
						priorityElement.value = priority;
				}
			}
		}
	}
	catch {}
	menuCancel();
}
function menuDpValueSliderChanged(n, index, displayElementIndex, displayId, programmaticPathname ) {
	try {
		var element = document.getElementById("menuDpValueSlider_" + dashboardDpList[index].programmaticPathname);
		var element1 = document.getElementById("menuDpValueCurrentValue_" + dashboardDpList[index].programmaticPathname)
		if((element !== null) && (element1 !== null)) {
			element1.value = element.value;
		}
	}
	catch {}
}
function menuDpValueSliderValueChanged(n, index, displayElementIndex, displayId, programmaticPathname ) {
	try {
		var element1 = document.getElementById("menuDpValueSlider_" + dashboardDpList[index].programmaticPathname);
		var element = document.getElementById("menuDpValueCurrentValue_" + dashboardDpList[index].programmaticPathname)
		var temp;
		if((element !== null) && (element1 !== null)) {
			if(element.value !== "") {
				temp = element.value;
				temp = temp.trim();
				if(temp !== "") {
					if(!isNaN(temp))
						element1.value = Number(temp);
				}
			}
		}
	}
	catch {}
}
function menuFavoritesCheckbox() {
	try {
		var checked,i;
		var element = document.getElementById("favoritesCheckbox");
		if(element !== null) {
			checked = element.checked;
			for(i=0; i < g_dpList.length; i ++)
			{
				element = document.getElementById("fav_" + g_dpList[i].pathname);
				if(element !== null) {
					element.checked = checked;
					menuFavoritesAddToFavorites(g_dpList[i].pathname);
				}
			}
			try {
				element = document.getElementById("menuDatapointCount");
				if(element !== null)
					element.innerHTML = g_favDpList.length.toString();
			}
			catch{}
		}
	}
	catch {}
}
function menuFavoritesAddToFavorites(pathname) {
	menuFavoritesAddToFavorites1(0, pathname);
}
function menuFavoritesAddToFavorites1(mode, pathname) {
	//mode: 0= g_dpList, 1=planningDpList, 2 = dla or 
	
	try {
		var bListChanged = false;
		var i, z = -1;
		var count = 1, index = 0;
		var obj = {};
		if(pathname === null)
			return;
		if(pathname === "")
			return;
			
		if(g_favDpList === null)
			return;
		for (i=0; i < g_favDpList.length; i++)
		{
			if(g_favDpList[i].pathname === pathname) {
				z = i;
				break;
			}
		}
		
		if(document.getElementById("fav_" + pathname).checked) {
			// add to favorites
			if(z === -1) {
				if(mode === 0) {
					for (i=0; i < g_dpList.length; i++)
					{
						
						if(g_dpList[i].pathname === pathname) {
							z = i;
							break;
						}
					}
				}
				else {
					for (i=0; i < planningDpList.length; i++)
					{
						if(planningDpList[i].pathname === pathname) {
							z = i;
							break;
						}
					}
				}
				if(z !== -1) {
					bListChanged = true;
					if(mode === 0)
						obj = g_dpList[z];
					else 
						obj = planningDpList[z];
					g_iDisplayIndex++;
					obj.favs_valueDisplayId = "favCurrentValue_" + g_iDisplayIndex;
					obj.favs_newValueDisplayId = "favsNewValue_" + g_iDisplayIndex;
					g_favDpList.push(obj);
				}
			}
		}
		else {
			// remove from favorite
			if(z !== -1) {
				bListChanged = true;
				g_favDpList.splice(z, 1)
			}
		}
		
		if((bListChanged) && (g_favDpList.length > 0)) {
			// sort
			var bContinue = true;
			var tempObj;
			
			while (bContinue)
			{
				bContinue = false;
				for (i=0; i < (g_favDpList.length - 1); i++)
				{
					if(g_favDpList[i].pathname > g_favDpList[i + 1].pathname) {
						tempObj = {};
						tempObj = JSON.parse(JSON.stringify(g_favDpList[i]));
						g_favDpList[i] = JSON.parse(JSON.stringify(g_favDpList[i + 1]));
						g_favDpList[i + 1] = tempObj;
						bContinue = true;
					}
				}
			}
		}
		
	}
	catch {}
	try {
		element = document.getElementById("menuDatapointCount");
		if(element !== null)
			element.innerHTML = g_favDpList.length.toString();
	}
	catch{}
	
}
function menuOverlayDivShow(mode, zIndex) {
	// mode:0=menuDiv, 1=planningDiv, 2=calendar, 3=testDiv
	// zindex: null means determine menuDiv zIndex - 3;
	try {
		var element = document.getElementById("menuOverlayDiv");
		var element1, zI, style;
		
		if(mode === 0) {
			element = document.getElementById("menuOverlayDiv");
			element1 = document.getElementById("menuDiv");
		}
		else if(mode === 1) {
			element = document.getElementById("planningOverlayDiv");
			element1 = document.getElementById("planningDiv");
		}
		else if(mode === 2) {
			element = document.getElementById("scheduleCreateOverlayDiv");
			element1 = document.getElementById("scheduleCreateDiv");
		}
		else if(mode === 3) {
			element = document.getElementById("testOverlayDiv");
			element1 = document.getElementById("testDiv");
		}
		else if(mode === 4) {
			element = document.getElementById("menuOverlayDiv");
			element1 = document.getElementById("structuredDpDiv");
		}
		else if(mode === 5) {
			element = document.getElementById("chartZoomOverlayDiv");
			element1 = document.getElementById("chartZoomDiv");
		}
		else if(mode === 6) {
			element = document.getElementById("scheduleOverlayDiv");
			element1 = document.getElementById("scheduleDiv");
		}
		else if(mode === 7) {
			element = document.getElementById("warningOverlayDiv");
			element1 = document.getElementById("warningDiv");
			element1.className = "warningDivShow";
		}
		
			
		if(element !== null) {
			element.className = "menuOverlayDivShow";
			if(zIndex !== null)
				element.style.zIndex = zIndex;
			else {
				if(element1 !== null) {
					//since z index may be only be css then 
					style = window.getComputedStyle(element1);
					zI = style.zIndex;
					zIndex = Number(zI);
					element.style.zIndex = zIndex - 1;
				}
			}
		}
	}
	catch {}
	

}
function _relinquishSelectedPriorities(mode, dpName, index) {
	var sTemp = "all the priorities for this datapoint";
	var element, element1;
	if(index >= dashboardDpList.length)
		return;
	if(mode === 1)
		sTemp = " the selected priorities<br><br>"

	sTemp = "<br><br>Do you really want to relinquish " + sTemp + "<br><br>";

	element = document.getElementById("warningDiv");
	element1 = document.getElementById("warningOverlayDiv");
	try {
		if((element === null) || (element1 === null))
			return;
		menuOverlayDivShow(7, null);
		sTemp += "<br><br><br><div style=\"width:100%;text-align:right\"><button class=\"warningDivShowButton\" onclick=\"_relinquishSelectedPriorities1(" + mode + ",'" + dpName + "'," + index + ")\">OK</button>";
		sTemp += "<button class=\"warningDivShowButton\" onclick=\"showAlertDialogHide()\">Cancel</button>";
		sTemp += "</div>";
		element.innerHTML = sTemp; 

	}
	catch {}
}
function _relinquishSelectedPriorities1(mode, dpName, index) {
	// mode: 0=all, 1=Selected
	try {
		var i, levels, x, priorityList = [], count = 0, dp, dpPath, key, element, dpQualifier, mode, bContinue, count1, row;
		var url = "https://" + location.host + "/iap/devs/*+name==", url1;
		var table = document.getElementById("priorityTable");
		var sTemp = "all the priorities for this datapoint";
		showAlertDialogHide();
		if(index >= dashboardDpList.length)
			return;
		if(mode === 1)
			sTemp = " the selected priorities"
		
		if(dpName === dashboardDpList[index].pathname) {
				
			if(dashboardDpList[index].writePriorityStart === null)
				return;
			if(dashboardDpList[index].writePriorityStart === dashboardDpList[index].writePriorityEnd)
				return;
		
			levels = dashboardDpList[index].values.levels;

			for(x in levels) 
			{
				x = Number(x);
				if((x >= dashboardDpList[index].writePriorityStart) && (x < dashboardDpList[index].writePriorityEnd)) 
					priorityList.push(x);
			}
			count1 = priorityList.length;
			for(i = 0; i < count1; i++)
			{
				priority = priorityList.pop();
				bContinue = false;
				if(mode === 0)
					bContinue = true;
				else if(mode === 1) {
					element = document.getElementById("menuDiv_priority_" + priority);
					if(element !== null) {
						if(element.checked) {
							bContinue = true;
						}
					}
				}
				if(bContinue) {
					count ++;
					try {
							// remove table entry
							if(table !== null) {
								element = document.getElementById("menuDiv_priority_" + priority);
								if(element !== null) {
									row = element.parentElement.parentElement.rowIndex;
									table.deleteRow(row);
								}
							}
					}
					catch {}
					dp = _encodePathNames(dpName);
					dpPath = dp.split("/");
					url1 = url +  dpPath[0] + "/if/" + dpPath[1] + "/" + dpPath[2] + "/" + dpPath[3] + "/overrides/" + priority + "/value"; 
					requestDeleteFunction(0, url1, "", null, null); 
					delete dashboardDpList[index].values.levels[priority];
					key = Object.keys(dashboardDpList[index].values.levels)[0];
					key = Number(key);
					//g_dpList[i].values.level = key;
					//g_dpList[i].priority = key;
					//g_dpList[i].value = g_dpList[i].values.levels[key];
				}
			}
			if(count === 0) {
				showAlertDialog(0,"Warning: No Relinquish Priority checkboxes checked");
			}
			else {
				//menuCancel();
				key = Object.keys(dashboardDpList[index].values.levels)[0];
				key = Number(key);
				if(key === 17) {
					/*
					// remove priority buttons
					for(k=0; k < g_dpList[index].displayElements.length; k++)
					{
						
						if(g_dpList[index].displayElements[k].displayType === "priority_span") { 
							// span current datapoint priority
							
							document.getElementById(g_dpList[index].displayElements[k].displayId).innerHTML = 17;
						}
						else if(g_dpList[index].displayElements[k].displayType === "priority_indicator") { 
							
							element = document.getElementById(g_dpList[index].displayElements[k].displayId);
							if(element !== null) {
								element.style.visibility = "hidden";
							}
						}
						else if(g_dpList[index].displayElements[k].displayType === "clearoverride_button") { 
							// make visible button based on whether priority is actve

							if((g_dpList[index].displayElements[k].clearoverrideType === "button") 
								|| (g_dpList[index].displayElements[k].clearoverrideType === "prioritybutton")) {
								element = document.getElementById(g_dpList[index].displayElements[k].displayId);
								if(element !== null) {
											element.style.visibility = "hidden";
								}
							}
							else if(g_dpList[index].displayElements[k].clearoverrideType === "switch") {
								element = document.getElementById(g_dpList[index].displayElements[k].displayId);
								if(element !== null) {
											element.checked = false;
											element.disabled = true;
								}
							}
						}
					}
					//12345
					*/
					// request update
					url = "https://" + location.host + "/iap/devs/*/if/*/*/*+qualifier=-";
					dpQualifier = dashboardDpList[index].dpQualifier;
					dpQualifier = _encodePathNames(dpQualifier);
					dpQualifier = dpQualifier.replace(/\//g,"%2F");
					url += dpQualifier + "/*?max_age=0&noxs=true";
					mode = 3;
					if(!g_bUseWebSockets) {
						mode = 5;
					}
					mode += 20;
					requestGetData(mode, url, getOnDemandDpValuesResponse, readFailCallback)
					
				}
			}
		}
		else {
			showAlertDialog(0,"Error: Can't override priorities - datapoint name doesn't match");
		}
	}
	catch (err) {
		showAlertDialog(0,"Error: Can't override priorities - exception");
	}

}
function _encodePathNames(path) {
	return path.replace(/\[/g,"%5B").replace(/\]/g,"%5D");; //1234
}
//remove ???
function _clearOverrides(n, type) {
	_clearOverrides1(n, type, null);
}
function _clearOverrides1(n, type, priority) {
	// n=this
	// type: "b" = button, "s" = sliderswitch
	var element;
	var displayId;
	var i,j, k, dp, dpPath, obj, priority = null, key, keys, value, levels = [], levels1 = [];
	var url = "https://" + location.host + "/iap/devs/*+name==", url1;
	try {
		displayId = n.id;
		for(i=0; i < g_dpList.length; i++)
		{
			for(j=0; j < g_dpList[i].displayElements.length; j++)
			{
				if(g_dpList[i].displayElements[j].displayId === displayId) {
					if(priority === null)
						priority = g_dpList[i].displayElements[j].priorityNum;
					if(priority === null){

					}
					else if(priority === -1) {
						// invalid selection
					}
					else if (priority === 0) {
						// clear all active
						element = document.getElementById(displayId);
						if((element !== null) && (priority !== null)) {
							
							obj = g_dpList[i];
							dp = obj.dpName;
							dp = encodePathNames(dp);
							dpPath = dp.split("/");
							levels = g_dpList[i].values.levels;
							keys = Object.keys(g_dpList[i].values.levels);
							levels1 = JSON.parse(JSON.stringify(levels));
							for(k=(keys.length - 1); k >= 0; k --)
							{ // relinquish lower priorities first so that only priority 17 value gets sent out
								key = Number(keys[k]);
								if(key === 17) {
									
								}
								else {
									if((g_sPriorityRelinquishPermissions === "all") || g_arrPriorityRelinquishPermissions[key - 1].permission) {
										delete levels1[key];
										url1 = url + dpPath[0] + "/if/" + dpPath[1] + "/" + dpPath[2] + "/" + dpPath[3] + "/overrides/" + key + "/value"; 
										requestDeleteData(0, url1, "", null, null); 
									}
								}
							}
							g_iIgnoreLastRead = true; // used to remove datapoint value flicker
							key = Object.keys(g_dpList[i].values.levels)[0];
							if(key === 17) {
								if(type = "b")
									element.style.visibility = "hidden"; //1234
								else if(type = "s")
									element.disabled = "true"; //1234
							}
							g_dpList[i].values.level = key;
							g_dpList[i].priority = key;
							g_dpList[i].values.levels = levels1;
							g_dpList[i].value = levels1[key];
							updateAllDisplayElements(0, g_dpList[i].dpName, i, null, null, false, true, null, null);
						}
					}
					else { // single priority
						element = document.getElementById(displayId);
						if((element !== null) && (priority !== null)) {
							if(type = "b")
								element.style.visibility = "hidden"; //1234
							else if(type = "s")
								element.disabled = "true"; //1234
							obj = g_dpList[i];
							dp = obj.dpName;
							dp = encodePathNames(dp);
							dpPath = dp.split("/");
							url1 = url +  dpPath[0] + "/if/" + dpPath[1] + "/" + dpPath[2] + "/" + dpPath[3] + "/overrides/" + priority + "/value"; 
							requestDeleteData(0, url1, "", null, null); 
							g_iIgnoreLastRead = true; // used to remove datapoint value flicker
							delete g_dpList[i].values.levels[priority];
							key = Object.keys(g_dpList[i].values.levels)[0];
							g_dpList[i].values.level = key;
							g_dpList[i].priority = key;
							value = g_dpList[i].values.levels[key];
							g_dpList[i].value = value;
							updateAllDisplayElements(0, g_dpList[i].dpName, i, null, null, false, true, null, null);
						}
					}
					i = g_dpList.length + 2;
					break;
				}
			}
		}
	}
	catch (err) {}
}


function _menuPriorityRelinquishAll(displayId) {
	try {
	var menuDiv = document.getElementById("menuDiv");
	g_priorityMenuAtLeastOnePriorityRelinquishedElementDisplayId = "";
	if(menuDiv !== null)
		menuDiv.remove("menuDiv");
	element = document.getElementById(displayId);
	if(element !== null)
		_clearOverrides1(element, "b", 0)
	
	}
	catch(err) {}
}
function _menuPriorityRelinquishSingle(n, displayId, dpName, priority) {
	try {
		var table = document.getElementById("menuprioritytbl");
		var url = "https://" + location.host + "/iap/devs/*+name==", url1;
		var dpPath, dp;
		g_priorityMenuAtLeastOnePriorityRelinquishedElementDisplayId = displayId;
		
		table = document.getElementById("menuprioritytbl");
		if(table !== null) {
			i = n.parentNode.parentNode.rowIndex;
			table.deleteRow(i);
		}

		return;

	}
	catch (err) {}
}
function _menuDivClose() {
	try {
		var displayId, i, j;
		var menuDiv = document.getElementById("menuDiv");
		document.getElementById("menuDiv").innerHTML = "";
		if(menuDiv !== null)
		menuDiv.remove("menuDiv");
		if(g_priorityMenuAtLeastOnePriorityRelinquishedElementDisplayId !== "") {
			displayId = g_priorityMenuAtLeastOnePriorityRelinquishedElementDisplayId;
			g_priorityMenuAtLeastOnePriorityRelinquishedElementDisplayId = "";
			try {
				for(i=0; i < g_dpList.length; i++)
				{
					for(j=0; j < g_dpList[i].displayElements.length; j++)
					{
						if(g_dpList[i].displayElements[j].displayId === displayId) {
							updateAllDisplayElements(0, g_dpList[i].dpName, i, null, false, true, null, null);
							i = g_dpList.length + 2;
							break;
						}
					}
				}
			}
			catch (err) {}
			
			// add code to show update on priority
		}
	}
	catch {}
}

function _showPriorityArrayRelinquish(n) { //remove
	//displayId: = datapointpath/pa, strip
	//mode: 0= show all, 1= no priority array, 2 =show only priority array
	//pathname is programmatic pathname
	try { 
		//var event1 = window.event;
		var displayId;
		var x = 0; // = event.clientX;
		var y = 0;// = event.clientY;
		var menuContent = "";
		var offsets;
		var value = null;
		var values = null, levels = null;
		var i, j, count = 0;
		var value;
		var menuContent = "";
		var bNumber = false;
		var values;
		var menuDivXOffset = -250; //30;
		var menuDivYOffset = 20;
		var menuDivWidth = 150;
        var menuDiv = null;
        var node;
		var name;
		var pathname = []
		displayId = n.id;
		

		
		var menuButton = document.getElementById(displayId);
		
		if(menuButton !== null) {
            menuDiv = document.getElementById("menuDiv");
            if(menuDiv === null) {
                // add menuDiv to Body
                node = document.createElement("div");
                node.id = "menuDiv";
                document.body.appendChild(node);
                menuDiv = document.getElementById("menuDiv");
                if(menuDiv === null)
                    return;
            }
			
			for(i=0; i < g_dpList.length; i++)
			{
				for(j=0; j < g_dpList[i].displayElements.length; j++)
				{
					if(g_dpList[i].displayElements[j].displayId === displayId) {
						name = g_dpList[i].dpName;
						if(g_iPriorityMenuDpNameType === 0) //0=Don't show, 1=full name, 2=block/dpname, 3=dpname
							name = "";
						else if (g_iPriorityMenuDpNameType === 2) {
							pathname = name.split("/");
							name = pathname[1] + "/" + pathname[2] + "/" + pathname[3];
						}
						else if (g_iPriorityMenuDpNameType === 3) {
							pathname = name.split("/");
							name = pathname[3];
						}
						menuContent = "<div class=\"menuDivName\">" + name + "</div>";
						
						offsets = menuButton.getBoundingClientRect(); 
						if((offsets.x + offsets.width + window.pageXOffset + menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
							x = offsets.x + window.pageXOffset - menuDivWidth - 10; // takes into account viewport (scrolling)
						else
							x = offsets.x + offsets.width + window.pageXOffset + menuDivXOffset; // takes into account viewport (scrolling)
						
						y = offsets.y + window.pageYOffset - menuDivYOffset; // takes into account viewport (scrolling)
						
						menuDiv.style.left = x.toString() + "px";
						menuDiv.style.top = y.toString() + "px";
						menuDiv.innerHTML = menuContent;
						menuDiv.className = "menuDivDpValueShow";  // doesn't currently guaranty that menu is shown in viewport
				
						
						values = g_dpList[i].values;
						
						if(typeof value === "number")
							bNumber = true;
						
						if(values !== null) {
							if(values.levels !== null) {
								levels = values.levels;
							}
						}
						menuContent += "<div class=\"menuDivDpValueDiv\"><div>";
						menuContent += "<br>";
						menuContent += "Current Priority: " + values.level + "<br><br>";
						menuContent += "<table id=\"menuprioritytbl\"><thead><tr><th>Override</th>";
						if(g_bShowRelinquishValue)
							menuContent += "<th style=\"width:158px\">Value</th>";
						menuContent += "<th>Relinquish</th></tr></thead><tbody>"
					
							// priority array
							
						if(levels !== null) {
							for(x in levels)
							{
								x1 = Number(x);
								if(x1 === 17)
									menuContent += "<tr><td>normal</td>";
								else
									menuContent += "<tr><td>" + x + "</td>";
								if(g_bShowRelinquishValue)
									menuContent += "<td class=\"tdValue\"><div class=\"tdValueDiv\">" + JSON.stringify(levels[x]) + "</div></td>";
								menuContent += "<td>";
								if(x1 !== 17) {
									if((g_sPriorityRelinquishPermissions === "all") || g_arrPriorityRelinquishPermissions[x1 - 1].permission) {
										count ++;
										menuContent += "<input type=\"checkbox\" id=\"_priority_" + x1 + "\">"
									}
									//	menuContent += "<button id=\"\" onclick=\"_menuPriorityRelinquishSingle(this,'" + n.id + "', '" + g_dpList[i].dpName + "', " + Number(x) + ")\">Relinquish</button>"
								}
								menuContent += "</td></tr>";
							}
						}
						menuContent += "</tbody></table>";
						if(g_sPriorityRelinquishPermissionsString !== "")
							menuContent += "Relinquish Permissions: " + g_sPriorityRelinquishPermissionsString;
						menuContent += "<br><br>";
						menuContent += "</div>";
						
						menuContent += "</div>"
						menuContent += "<button onclick=\"_menuDivClose()\">Close</button>";
						//menuContent += "<button style=\"float:right\" onclick=\"_menuDivCancel()\">Cancel</button>";
						menuContent += "<button id=\"_priorityRelinquishAll\" style=\"float:right\" onclick=\"_menuPriorityRelinquishAll('" + n.id + "')\">Relinquish All</button>";
						menuContent += "<button id=\"_relinquishSelectedPriorities\" style=\"float:right;margin-right:10px\" onclick=\"_relinquishSelectedPriorities('" + g_dpList[i].dpName +"'," + i + ")\">Relinquish Selected</button><br><br>";
						menuContent += "</div>"
						menuDiv.innerHTML = menuContent;
						if(count === 0) {
							document.getElementById("_priorityRelinquishAll").disabled = true;
							document.getElementById("_relinquishSelectedPriorities").disabled = true;
						}
						return;
					}
				}
			}
        }
	
	}
	catch {}
}
