/*
	map.js (version 0.019) - Only use for 4.1
	
    mapCreateDivContent()
    mapCreateMapDataAndSendToIframe(); - creates map data and sends to the openstreetmap iFrame
	mapProcessiFrameMessages(data); - processes messages from map iFrame
       
    mapProcessWebSocketDpData()
    showStatusInformationDiv() - navtree.js shows temporary information in upper-right hand corner

 *	Copyright (C) 2023 EnOcean GmbH.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	EnOcean Example Software License Agreement which is available at
 *	https://enoceanwiki.atlassian.net/wiki/spaces/LON/pages/2425260/Example+Software+License+Agreement. 

*/
var g_bAddIframeEventListener = true;
var g_bMapCheckForLightDevices = true;
var g_oMap = {};
var g_bMapView = false;
var g_iMapSeqNum = 0;
var g_oMapInfo = {};
var MAPPOLYGON_OFFSET = 0.000005; // Used for smartServer with no contexts so that world polygon doesn't cover up devices
var g_oMapOptionsSetting = {};
var g_bPreviousDeviceMap = false;
var g_sMapDeviceWithPopupOpen = "";
var g_sMapFindSearchName = "";
var g_bMapFindUseExactMatch = false;
var g_iMapFindGroupIndex = -1;
var g_iMapFindGroupDeviceIndex = -1;
var g_bMapOnlyShowDevicesWithLatLong = false; // not supported yet, need to take into account going from device view to map (true then show smartserver on map for device without lat long)
var g_oMapTreeExpandSettings = null;
var g_oMapScaleDisplayId = 0; // only used for datapoints that have a matching scaling datapoint like the Tstat which has a scale datapoint
var g_iMapDashboardMaxNumberOfRows = 20;
var g_iMapDashboardSmallMonitorMaxNumberOfRows = 10;
function mapInit(mode) {
    if(mode === 0) {
        g_bAddIframeEventListener = true;
        g_oMapOptionsSetting = {};
        g_oMapOptionsSetting.bShowAllDevices = false; // false=show all devices but devices in a building, true all devices
        g_oMapOptionsSetting.iShowDevicesMode = 0; // 0=all, 1=provisioned, 2=down, 3=light, 4=specified
        g_oMapOptionsSetting.bShowLightDevice = false; // 0=all, 1=provisioned, 2=down, 3=light, 4=specified
        g_oMapOptionsSetting.bShowHideSmartServers = false; // 0=all, 1=provisioned, 2=down, 3=light, 4=specified
        g_oMapOptionsSetting.bShowSmartServerDevices = true;
        g_oMapOptionsSetting.bShowUpDevices = true;
        g_oMapOptionsSetting.bShowLightDevices = true;
        g_oMapOptionsSetting.bShowDownDevices = true;
        g_oMapOptionsSetting.bShowGroupDevices = true;
        g_oMapOptionsSetting.bShowUnprovisionedDevices = true;
        g_oMapOptionsSetting.bShowParentRegion = true; //
        g_oMapOptionsSetting.bShowCurrentRegion = true;
        g_oMapOptionsSetting.bShowChildRegion = true; // all
        g_oMapOptionsSetting.bClickShowLatLong = false; // true means show lat long when mouse clicked
        g_oMapOptionsSetting.bShowAllTooltips = false; // true means show lat long when mouse clicked
        g_oMapOptionsSetting.bShowCustomControls = true; 
        g_oMapOptionsSetting.bGroupBuildingDevices = g_bMapGroupBuildingDevices;
        

        g_bPreviousDeviceMap = false;
        g_sMapDeviceWithPopupOpen = "";
        g_sMapFindSearchName = "";
        g_bMapFindUseExactMatch = false;
        g_oMapTreeExpandSettings = null;
        
        
    }
    g_iMapFindGroupIndex = -1;
    g_iMapFindGroupDeviceIndex = -1;
    if(!g_bPreviousDeviceMap)
        g_sMapDeviceWithPopupOpen = "";
    g_bPreviousDeviceMap = false;
    g_oMap = {};
    g_oMapInfo = {};
    g_oMapInfo.mode = -1;
    g_oMapInfo.title = ""; //contextPath
    g_oMapInfo.path = ""; //contextPath
    g_oMapInfo.index = -1; //contextid
    g_oMapInfo.type = ""; //contextType
    g_oMapInfo.iDownTimer = g_iDownTimer;
    g_bMapView = false;
    g_iMapScreenWidth = null; // usedx for map when user moves between screen sizes 
	g_iMapScreenHeight = null;
}
function showMap(mode,name, path, type, index, treeId) {
	// treeId should be -1 except no planning 
	try { 
        var treeContext = null;

        // change color of tree context to indicate selected
        if(treeId !== -1) {
            if(g_iPlanningPaneSelectedContextId !== -1) {
                treeContext = document.getElementById("planningTreeContext_" + g_iPlanningPaneSelectedContextId);
                if(treeContext !== null) {
                    treeContext.classList.remove("treeSelected")
                    //treeContext.style.color = "white";
                }
            }
            treeContext = document.getElementById("planningTreeContext_" + treeId);
            if(treeContext !== null) {
                //treeContext.style.color = "red";
                treeContext.classList.add("treeSelected");
                g_iPlanningPaneSelectedContextId = treeId;
            }
        }

		//alert("map[" + mode + "]: " + name + " [type = " + type + ", index = " + index + "]\r\n\r\n\tTBD");
        g_iMainDisplayMode = DISPLAYMODE_MAP;
        if(false) { //(element !== null) {
            // map already there just delete old and add new content

        }
        else
		    mapCreateDivContent(mode, name, path, type, index);	
	
		
	} catch {}
}

function changeMapOptionLatLong(n) {
	try { 
        var  element = document.getElementById("mapShowLatLongCheckbox");
        if((g_iMainDisplayMode !== DISPLAYMODE_MAP) || !g_bMapView)
            return;
        if(element !== null) {
            g_oMapOptionsSetting.bClickShowLatLong = element.checked;
            g_oMap.options.bClickShowLatLong = g_oMapOptionsSetting.bClickShowLatLong;
            const message = JSON.stringify({
				"action": "showMouseClickLatLong",
				"checked": g_oMapOptionsSetting.bClickShowLatLong
			});
			element = document.getElementById("mapIframe");
			if(element !== null)
				element.contentWindow.postMessage(message, "*");
        }

	} catch {}
}
function changeMapShowBuildingDevices(n) {
	try { 
        if((g_iMainDisplayMode !== DISPLAYMODE_MAP) || !g_bMapView)
            return;
            g_oMapOptionsSetting.bGroupBuildingDevices = n.checked;

            //g_oMap.options.bGroupBuildingDevices = g_oMapOptionsSetting.bGroupBuildingDevices;
            const message = JSON.stringify({
				"action": "getcurrentsettings",
                "mode": 1
			});
			element = document.getElementById("mapIframe");
			if(element !== null)
				element.contentWindow.postMessage(message, "*");
       
	} catch {}
}
function changeMapShowTooltips(n) {
	try { 
        if((g_iMainDisplayMode !== DISPLAYMODE_MAP) || !g_bMapView)
            return;
            g_oMapOptionsSetting.bShowAllTooltip = n.checked;
            g_oMap.options.bShowAllTooltips = g_oMapOptionsSetting.bShowAllTooltips;
            const message = JSON.stringify({
				"action": "showTooltips",
				"checked": g_oMapOptionsSetting.bShowAllTooltip
			});
			element = document.getElementById("mapIframe");
			if(element !== null)
				element.contentWindow.postMessage(message, "*");
       
	} catch {}
}
function createMapRegions(mode, contextPath, type, id) {
    try {
        var json, json1;
        var obj, obj1;
        var i, j;
        if(planningList === null)
            return;
        //if(planningList === null)
        //    return;
        if(mode === 0) {
            json = getPlanningTreeShowTreeDetailsGetObj(planningList, id, 0);
			json1 = getPlanningTreeShowTreeDetailsGetObj(planningList, json.parentId, 0);
            if(json === null)
                return;
            if((json.contextType === "FLOOR") || (json.contextType === "ROOM"))
                return;
            if(json1 !== null) {
                // parent
                if((json.contextType == "AREA") && (json1.contextType === "FLOOR"))
                    return;
                obj = {};
                obj.name = json1.name;
                obj.path = json1.path;
                obj.contextId = json1.id;
                obj.contextType = json1.contextType;
                obj.level = -1;
                obj.parentPath = "";
                obj.parentContextType = null;
                obj.parentIndex = -1;
                obj.parentPolygonArray = "parent";
                obj.bParentHasRegion = true;
                if(json.contextType == "WORLD") {
                    
                    obj.bParentHasRegion = false;
                }
                if(json1 !== null) {
                    obj.parentPath = json1.path;
                    obj.parentContextType = json1.contextType;
                    obj.parentIndex = json.parentId;
                }
                obj.color = createMapRegionsColor(json1.contextType);
                obj.polygonCoord = [];
                obj.polygon = null;

                obj.polygonCoord = [];
                for(j=0; j < json1.contextLocation.length; j++)
                {
                    obj1 = [];
                    obj1 = [json1.contextLocation[j].lat,json1.contextLocation[j].long];
                    obj.polygonCoord.push(obj1);
                }
                g_oMap.mapParentPolygonList.push(obj);
                
            }
            if(json.contextType !== "WORLD") {
                obj = {};
                obj.name = json.name; //getPathLastName(contextPath);
                obj.path = json.path;
                obj.contextId = json.id;
                obj.contextType = json.contextType;
                obj.level = 0;
                obj.parentPath = "";
                obj.parentContextType = null;
                obj.parentIndex = -1;
                obj.parentPolygonArray = "parent";
                obj.bParentHasRegion = true;
                if(g_oMap.mapPolygonList.length === 0)
                    obj.bParentHasRegion = false;
                if(json1 !== null) {
                    obj.parentPath = json1.path;
                    obj.parentContextType = json1.contextType;
                    obj.parentIndex = json.parentId;
                    
                }
                
                obj.polygonCoord = [];
                obj.color = "blue"; //current region is always blue createMapRegionsColor(json.contextType);
                obj.polygon = null;
                obj.polygonCoord = [];
                for(j=0; j < json.contextLocation.length; j++)
                {
                    obj1 = [];
                    obj1 = [json.contextLocation[j].lat,json.contextLocation[j].long];
                    obj.polygonCoord.push(obj1);
                }
                g_oMap.mapPolygonList.push(obj);
            }
            for(i=0; i < json.children.length; i++)
            {
                if((json.contextType === "BUILDING") && (json.children[i].contextType !== "AREA") && (json.children[i].contextType !== "ROOM")) {
                }
                else {
                    json2= {};
                    json2 = JSON.parse(JSON.stringify(json.children[i]));
                    createMapRegionsChildRegions(0, 0, json.contextType, json2, json.path, json.contextType, json.id);
                }
            }
        }
    }
    catch {};
}
function createMapRegionsChildRegions(mode, level, parentContextType, json, parentPath, parentContext, parentId) {
    try {
        var i, id;
        level ++;
        obj = {};
        obj.name = json.name; //getPathLastName(contextPath);
        obj.path = json.path;
        obj.contextId = json.id;
        obj.contextType = json.contextType;
        obj.parentPath = parentPath;
        obj.parentContextType = parentContextType;
        obj.parentIndex = parentId;
        obj.level = level;
        obj.parentPolygonArray = 1;
        if(level > 1)
            obj.parentPolygonArray = 2;
        obj.polygonCoord = [];
        obj.color = createMapRegionsColor(json.contextType);
        obj.polygon = null;
        obj.polygonCoord = [];
        for(j=0; j < json.contextLocation.length; j++)
        {
            obj1 = [];
            obj1 = [json.contextLocation[j].lat,json.contextLocation[j].long];
            obj.polygonCoord.push(obj1);
        }
        g_oMap.mapChildPolygonList.push(obj);
        for(i=0; i < json.children.length; i++)
        {
            if((json.contextType === "BUILDING") && (json.children[i].contextType !== "AREA") && (json.children[i].contextType !== "ROOM")) {
            }
            else {
                json2= {};
                json2 = JSON.parse(JSON.stringify(json.children[i]));
                createMapRegionsChildRegions(0, level, json.contextType, json2, json.path, json.contextType, json.id);
            }
        }
    }
    catch {}
    return;
}
function createMapRegionsColor(contextType) {
    try {
        var color = "";
        if(contextType === "WORLD")
            color = "blue";
        else if(contextType === "REGION")
            color = "red";
        else if(contextType === "CAMPUS")
            color = "green";
        else if(contextType === "BUILDING")
            color = "yellow";
    }
    catch {}
    return color;
}
function mapCreateDivContent(mode, title, path, type, index) {
    //mode: 0=init, 1=map already there just refresh data, 2=single device
    try {
        var element = document.getElementById("planningPaneDetails");
        var element1 = null;
        var content = "";
		var width = 200;
		var height = 200;
        var bWorldOnly = false;
        
        if(element !== null) {

			
            content = "<div id=\"planningPaneDetails_title\">" + title + "</div>";
            
            
               
            if(element !== null) {
                g_iMapScreenWidth = screen.width; // usedx for map when user moves between screen sizes 
	            g_iMapScreenHeight = screen.height;
                width = (g_iMapScreenWidth - element.offsetLeft -  100);
                height = (g_iMapScreenHeight - 290);
                g_iMapScreenWidth = width; // usedx for map when user moves between screen sizes 
	            g_iMapScreenHeight = height;
                       
                if(planningList === null)
                    bWorldOnly = true;
                else if(planningList.length === 0)
                    bWorldOnly = true;
                else if(planningList[0].children.length === 0)
                    bWorldOnly = true;
                
			
            	content = "<div id=\"planningPaneDetails_title\" style=\"margin-bottom:5px\">"; // + title;
                content += "<div  style=\"float:left;cursor:pointer\">" + planningCreateContextbreadcrumbs(path) + "</div>";
                content += "<div style=\"display:flex;float:right\">";
                content += "<input type=\"textbox\" id=\"mapFindTextbox\"";
                if(g_sMapFindSearchName !== "")
                    content += " value=\"" + g_sMapFindSearchName + "\"";
                content += " placeholder=\"device name\" title=\"find device name\" onchange=\"mapfindtextchanged(this)\" />";
                content += "<button id=\"mapFind\" title=\"clear Find text\" onclick=\"mapFindClearTextbox()\">x</button>"
                content += "<div style=\"display:flex;white-space:nowrap\"><input type=\"checkbox\" id=\"mapFindExactMatchCheckbox\"  /><span  title=\"Use exact match for searches\">Exact</span></div>";
                content += "<button id=\"mapFind\" onclick=\"mapFindNext(0)\">Find</button>"
                content += "<button id=\"mapFind\" onclick=\"mapFindNext(2)\">&lt;</button>"
                content += "<button id=\"mapFind\" onclick=\"mapFindNext(1)\">&GT;</button>"
                
                content += "<div style=\"display:flex;white-space:nowrap\"><input type=\"checkbox\" id=\"mapShowLatLongCheckbox\" onchange=\"changeMapOptionLatLong(this)\" /><span  title=\"Show Mouse Latitudes/Longitudes\">Lat/Long</span></div>";
                content += "<div style=\"display:flex;white-space:nowrap\"><input type=\"checkbox\" id=\"mapShowTooltipsCheckbox\" onchange=\"changeMapShowTooltips(this)\" /><span  title=\"Show all Device names\">Names</span></div>";
                content += "<div style=\"display:flex;white-space:nowrap\"";
                if(mode === 2)
                    content += " disabled";
                content += "><input type=\"checkbox\" id=\"mapShowBuildingDevicesCheckbox\" onchange=\"changeMapShowBuildingDevices(this)\" /><span  title=\"Group/Ungroup Building Devices\">Building Devices</span></div>";
                content += "</div>";

                
                content += "</div>";
            	content += "<div id=\"planningPaneDetails_Details\"><div style=\"position:relative\">";
				content += "<iframe id=\"mapIframe\" src=\"navtreeopenstreetmap.html?name=" + title + "&width=" + (width - 30) + "px&height=" + (height - 30) + "px\"";
			
				content += " width=\"" + width + "px\" height=\"" + height + "px\"></iframe></div>";
                
				content += "</div>";
                /* delete no longer needed as leafletjs layercontrol is used
                content += "<div style=\"display:flex;\">";//float:right\">";
                content += "<div class=\"mapOption\">Status: </div>";
                content += "<div class=\"mapOption\" title=\"Show all outside devices\"><input type=\"radio\" id=\"mapDeviceOptionAll\" name=\"mapDeviceOption\" value=\"0\" onchange=\"changeMapOption(this)\" /><label for=\"all\">All</label></div>";
                content += "<div class=\"mapOption\" title=\"Show all outside provisioned devices\"><input type=\"radio\" id=\"mapDeviceOptionProvisioned\" name=\"mapDeviceOption\" value=\"1\" onchange=\"changeMapOption(this)\" /><label for=\"all\">Provis.</label></div>";
                content += "<div class=\"mapOption\" title=\"Show all outside down devices\"><input type=\"radio\" id=\"mapDeviceOptionDown\" name=\"mapDeviceOption\" value=\"2\" onchange=\"changeMapOption(this)\" /><label for=\"all\">Down</label></div>";
                content += "<div class=\"mapOption\" title=\"Show all outside unprovisioned devices\"><input type=\"radio\" id=\"mapDeviceOptionUnProvisioned\" name=\"mapDeviceOption\" value=\"3\" onchange=\"changeMapOption(this)\" /><label for=\"all\">UnProv.</label></div>";
                content += "<div class=\"mapOption\" title=\"Show specified device\"><input type=\"radio\" id=\"mapDeviceOptionSpecified\" name=\"mapDeviceOption\" value=\"4\" onchange=\"changeMapOption(this)\" /><label for=\"all\">Selected</label></div>";
                content += "<div id=\"mapShowLightCheckboxDivId\" style=\"display:flex;white-space:nowrap\"><input type=\"checkbox\" id=\"mapShowLightCheckbox\" onchange=\"changeMapOptionLightDevice(this)\" /><span  title=\"Show Light devices only\">Lights</span></div>";
                if(!bWorldOnly)
                    content += "<div id=\"mapShowParentContextCheckboxDivId\" style=\"display:flex;white-space:nowrap\"><input type=\"checkbox\" id=\"mapShowParentContextCheckbox\" onchange=\"changeMapOptionParentContext(this)\" /><span  id=\"mapShowParentContextCheckboxSpan\" title=\"Show Parent Region\">Parent region</span></div>";
                content += "<div id=\"mapShowContextCheckboxDivId\" style=\"display:flex;white-space:nowrap\"><input type=\"checkbox\" id=\"mapShowContextCheckbox\" onchange=\"changeMapOptionContext(this)\" /><span id=\"mapShowContextCheckboxSpan\" title=\"Show context\">Show region</span></div>";
                if(!bWorldOnly)
                    content += "<div style=\"display:flex;white-space:nowrap\"><input type=\"checkbox\" id=\"mapShowChildContextCheckbox\" onchange=\"changeMapOptionChildContexts(this)\" /><span  title=\"Show Child region\">Child region</span></div>";
                */
                content += "</div>";
                
                element.innerHTML = content; 
                
                mapCreateDivContentSetOptions(0, path,bWorldOnly);
                /*
                try {
                    if(g_oMapOptionsSetting.iShowDevicesMode === 0)
                        document.getElementById("mapDeviceOptionAll").checked = true;
                    else if(g_oMapOptionsSetting.iShowDevicesMode === 1)
                        document.getElementById("mapDeviceOptionProvisioned").checked = true;
                    else if(g_oMapOptionsSetting.iShowDevicesMode === 2)
                        document.getElementById("mapDeviceOptionDown").checked = true;
                    else if(g_oMapOptionsSetting.iShowDevicesMode === 3)
                        document.getElementById("mapDeviceOptionLight").checked = true;
                    else if(g_oMapOptionsSetting.iShowDevicesMode === 4)
                        document.getElementById("mapDeviceOptionSpecified").checked = true;
                    
                }
                catch {}
				if(element !== null)
                    element.value = g_oMapOptionsSetting.iShowDevicesMode;
                element = document.getElementById("mapShowParentContextCheckbox");
                if(element !== null)
                    element.checked = g_oMapOptionsSetting.bShowParentContext;
                element = document.getElementById("mapShowContextCheckbox");
                if(element !== null)
                    element.checked = g_oMapOptionsSetting.bShowContext;
                element = document.getElementById("mapShowChildContextCheckbox");
                if(element !== null)
                    element.checked = g_oMapOptionsSetting.bShowChildContexts;
                element = document.getElementById("mapShowLatLongCheckbox");
                if(element !== null)
                    element.checked = g_oMapOptionsSetting.bClickShowLatLong;
                */

                
                g_oMapInfo = {};
                g_oMapInfo.mode = mode;
                g_oMapInfo.title = title;
                g_oMapInfo.path = path;
                g_oMapInfo.index = index;
                g_oMapInfo.type = type;
                g_bMapView = true;
				if(g_bAddIframeEventListener) {
                    g_bAddIframeEventListener = false;
					window.addEventListener('message', function (e) {
						// Get the sent data
						const data = e.data;
                        mapProcessiFrameMessages(data);
						
					});
				}
			}
        }
    }
    catch (err) {}
    
    return;

}
function mapGetChangeDpValueGetResponse(mode, url, json) {
    try {
        var value = null,url;
        if((g_iMainDisplayMode !== DISPLAYMODE_MAP) || !g_bMapView)
            return;
        if(typeof mode === "object") {
            if(mode.mode === 1) {
                if(json === null) {
                    showStatusInformationDiv(3,"Write aborted<br>can't get existing value: <br>" + mode.deviceObj.deviceName);
                    return;
                }
                if(mode.deviceObj.programId === "800001230E041005") {
                    try {
                        var priority = null;
                        value = JSON.parse(JSON.stringify(json[0].locValue));
                        value.state = "SW_RECALL_SCENE";
                        value.scene_number = mode.value;
                        url = "/iap/devs/*+name=="; //iot
                        url += mode.deviceObj.datapointsList[1].dpRequest;
                        if(priority !== null)
                            url += "/overrides/" + priority;
                        url += "/localization/value";
                        value = JSON.stringify(value);
                        //objs[z].updateDpValue = true; // sync up value, localValue and Preset
                        writeDpValue(1,url,value, null, mapGetChangeDpValueWriteFailResponse);
                    }
                    catch {
                        showStatusInformationDiv(3,"Write aborted<br>can't write new value: <br>" + mode.deviceObj.deviceName);
                    }
                }
                
            }
        }
    }
    catch {}
}

function mapGetChangeDpValueGetFailResponse(mode, url, json) {
    try {
        if((g_iMainDisplayMode !== DISPLAYMODE_MAP) || !g_bMapView)
            return;
        if(typeof mode === "object") {
            if(mode.mode === 1) {
                showStatusInformationDiv(3,"Write aborted<br>can't get existing value: <br>" + mode.deviceObj.deviceName);
            }
        }
        else {
            showStatusInformationDiv(3,"Write aborted<br>can't get existing value");
        }
    }
    catch {}
}
function mapGetChangeDpValueWriteFailResponse(mode, url, json) {
    try {
        if((g_iMainDisplayMode !== DISPLAYMODE_MAP) || !g_bMapView)
            return;
        showStatusInformationDiv(2,"Write priority too low or write aborted");
        
    }
    catch {}
}
function mapGetDpValues(mode) {
    try {
        var url = "";
        var dpListUrl = "";
        var i;
        if((g_iMainDisplayMode !== DISPLAYMODE_MAP) || !g_bMapView)
            return;
        if(g_oMap.mapDatapoints.length > 300) {
            // too big just show map
            mapGetDpValuesSendInitialData(mode);
        }
        else {
            for(i=0; i < g_oMap.mapDatapoints.length; i++)
            {
                if(typeof g_oMap.mapDatapoints[i].dpQualifier !== "undefined") {
                    if(i > 0)
                        dpListUrl += ",";
                    dpListUrl += encodePathString(g_oMap.mapDatapoints[i].dpQualifier.replace(/\//g,"%2F"));
                }
            }
            if(dpListUrl !== "") {
                url = "https://" + location.host + "/iap/devs/*/if/*/*/*+qualifier=-" + dpListUrl + "/value?&noxs=true"; //"/value?max_age=1&noxs=true";
                requestGetData(mode, url, mapGetDpValuesSuccessCallback, mapGetDpValuesFailCallback);
            }
            else 
                mapGetDpValuesSendInitialData(mode);
        }
    }
    catch {}
    

}
function mapGetDpValuesSuccessCallback(mode,url,json) {
    try {
        var i,j,z,z1;
        if((g_iMainDisplayMode !== DISPLAYMODE_MAP) || !g_bMapView || (json === null))
            return;
        // save results
        for(i=0; i < json.length; i++)
        {
            for(j=0; j < g_oMap.mapDatapoints.length; j++)
            {
                if((g_oMap.mapDatapoints[j].deviceName === json[i].deviceName) && (g_oMap.mapDatapoints[j].dpQualifier === json[i].dpQualifier)) {
                    if(typeof json[i].value === "object")
                        g_oMap.mapDatapoints[j].value = JSON.parse(JSON.stringify(json[i].value));
                    else 
                        g_oMap.mapDatapoints[j].value = json[i].value;
                    if(typeof json[i].locValue === "object")
                        g_oMap.mapDatapoints[j].locValue = JSON.parse(JSON.stringify(json[i].locValue));
                    else 
                        g_oMap.mapDatapoints[j].locValue = json[i].locValue;
                    g_oMap.mapDatapoints[j].preset = json[i].preset;
                    g_oMap.mapDatapoints[j].local = json[i].local;
                    g_oMap.mapDatapoints[j].utc = json[i].utc;
                    z = g_oMap.mapDatapoints[j].groupIndex;
                    z1 = g_oMap.mapDatapoints[j].groupDeviceIndex;
                    try {
                        if(g_oMap.mapDeviceGroupList[z].devices[z1].datapointsList[0].dpQualifier === json[i].dpQualifier) {
                            if(g_oMap.mapDeviceGroupList[z].devices[z1].programId === "800001230E041005") {
                                g_oMap.mapDeviceGroupList[z].devices[z1].datapointsList[0].value = json[i].locValue.setting.value;
                            }
                            else if((g_oMap.mapDeviceGroupList[z].devices[z1].programId === "9FFFFF0501840460") || 	(g_oMap.mapDeviceGroupList[z].devices[z1].programId === "900001153C000405")) {
                                g_oMap.mapDeviceGroupList[z].devices[z1].datapointsList[0].value = json[i].locValue.value;
                            }
                        }
                    }
                    catch {}
                    break;
                }
            }
        }
        mapGetDpValuesSendInitialData(mode);
    }
    catch {}
}
function mapGetDpValuesFailCallback(mode,url,json) {
    try {
        if((g_iMainDisplayMode !== DISPLAYMODE_MAP) || !g_bMapView)
            return;
        mapGetDpValuesSendInitialData(mode);
    }
    catch {}
}

function mapGetDpValuesSendInitialData(mode) {
    try {
        var message;
        if((g_iMainDisplayMode !== DISPLAYMODE_MAP) || !g_bMapView)
            return;
        if(g_oMap === null)
            return;
        if(mode === 0) {
            message = JSON.stringify({
                "action": "initaildata",
                "message": g_oMap,
                "seqnum": g_iMapSeqNum
            });
        }
        else {
            message = JSON.stringify({
                "action": "restart",
                "mode": 1,
                "message": g_oMap,
                "seqnum": g_iMapSeqNum
            });
        }
        element = document.getElementById("mapIframe");
        if(element !== null)
            element.contentWindow.postMessage(message, "*");
    }
    catch{}
    
}
function mapGetDeviceParentRegion(contexts) {
    try {
        var i, json, json1, bFound = false;
        if(typeof contexts === "undefined") 
            return;
        if(contexts === null) 
            return;
        if(contexts.length === 0) 
            return;
        try {
            for(j = 0; j < contexts.length; j++)
            {
                // only add one region. Only time two regions is when areas are used
                json = getPlanningTreeShowTreeDetailsGetObj(planningList, contexts[j], 0);
                if(json === null) {
                }
                else if((json.contextType === "AREA") || (json.contextType === "ROOM")) {
                    // look for building
                    json1 = getPlanningTreeShowTreeDetailsGetObj(planningList, json.parentId, 0);
                    if(json1 === null) {
                    }
                    else if(json1.contextType === "FLOOR") {
                        json1 = getPlanningTreeShowTreeDetailsGetObj(planningList, json1.parentId, 0);
                        createMapRegions(0, json1.path, json1.contextType, json1.id);
                        
                    }
                    else if(json1.contextType === "BUILDING") {
                        createMapRegions(0, json1.path, json1.contextType, json1.id);
                        
                    }
                    else if (json.contextType === "AREA") {
                        createMapRegions(0, json.path, json.contextType, json.id);
                        
                    }
                    else {

                    }
                }
                else {
                    createMapRegions(0, json.path, json.contextType, json.id);
                    
                }
               
            }
            
        }
        catch {}
        
    }
    catch {}
}
function mapFindClearTextbox() {
    try {
        var element = document.getElementById("mapFindTextbox");
        if((g_iMainDisplayMode !== DISPLAYMODE_MAP) || !g_bMapView)
            return;
        g_sMapFindSearchName = "";
        if(element !== null) 
            element.value = "";
    }
    catch {}
}
function mapFindNext(mode) {
    //mode: 1=previous, 2=next
    try {
        var element = document.getElementById("mapFindTextbox");
        var element1 = document.getElementById("mapFindExactMatchCheckbox");
        var bFound = false, bContinue, bContinue1;
        var groupStartIndex, groupDeviceStartIndex;
        var iMapFindGroupIndex = g_iMapFindGroupIndex;
        var iMapFindGroupDeviceIndex = g_iMapFindGroupDeviceIndex;
        if((g_iMainDisplayMode !== DISPLAYMODE_MAP) || !g_bMapView)
            return;
        if(g_oMap.mapDeviceGroupList.length === 0) {
            showStatusInformationDiv(2,"There are no devices in map" + g_sMapFindSearchName);
            return;
        }
        if((element !== null) && (element1 !== null)){
            g_sMapFindSearchName = element.value;
            g_bMapFindUseExactMatch = element1.checked;
            if(g_sMapFindSearchName !== "")
                g_sMapFindSearchName = g_sMapFindSearchName.trim();
            if(g_sMapFindSearchName === "") {
                alert("Abort - Find search name not specified");
                return;
            }
            if(g_iMapFindGroupIndex >= g_oMap.mapDeviceGroupList.length)
                g_iMapFindGroupIndex = -1;
            if(mode === 0) {
                mode = 1;
                g_iMapFindGroupIndex = -1;
                g_iMapFindGroupDeviceIndex = -1;
            }
            iMapFindGroupIndex = g_iMapFindGroupIndex;
            iMapFindGroupDeviceIndex = g_iMapFindGroupDeviceIndex;
            if(mode === 1) {
                // next
                if((g_iMapFindGroupIndex === -1) || (g_iMapFindGroupDeviceIndex === -1)) {
                    for(i=0; i < g_oMap.mapDeviceGroupList.length; i++)
                    {
                        for(j=0; j < g_oMap.mapDeviceGroupList[i].devices.length; j++)
                        {
                            if((g_bMapFindUseExactMatch && (g_sMapFindSearchName.toLowerCase() === g_oMap.mapDeviceGroupList[i].devices[j].name.toLowerCase())) 
                                        || (!g_bMapFindUseExactMatch && (g_oMap.mapDeviceGroupList[i].devices[j].name.toLowerCase().indexOf(g_sMapFindSearchName.toLowerCase()) !== -1))) {
                                bFound = true;
                                g_iMapFindGroupIndex = i;
                                g_iMapFindGroupDeviceIndex = j;
                                break;
                            }
                        }
                        if(bFound)
                            break;
                    }
                }
                else {
                    // find should only find the first device in group that matches text
                    /*
                    groupDeviceStartIndex = g_iMapFindGroupDeviceIndex + 1;
                    groupStartIndex = g_iMapFindGroupIndex;
                    if(groupDeviceStartIndex >= g_oMap.mapDeviceGroupList[groupStartIndex].devices.length) {
                        groupStartIndex ++;
                        groupDeviceStartIndex = 0;
                    }
                    */
                    groupStartIndex = g_iMapFindGroupIndex + 1;
                    groupDeviceStartIndex = 0;
                    bContinue = true;
                    if(groupStartIndex >= g_oMap.mapDeviceGroupList.length) {
                        groupStartIndex = 0;
                        groupDeviceStartIndex = 0;
                        bContinue = false;
                    }
                    for(i = groupStartIndex; i < g_oMap.mapDeviceGroupList.length; i++)
                    {
                        for(j = groupDeviceStartIndex; j < g_oMap.mapDeviceGroupList[i].devices.length; j++)
                        {
                            if((g_bMapFindUseExactMatch && (g_sMapFindSearchName.toLowerCase() === g_oMap.mapDeviceGroupList[i].devices[j].name.toLowerCase())) 
                                        || (!g_bMapFindUseExactMatch && (g_oMap.mapDeviceGroupList[i].devices[j].name.toLowerCase().indexOf(g_sMapFindSearchName.toLowerCase()) !== -1))) {
                                bFound = true;
                                g_iMapFindGroupIndex = i;
                                g_iMapFindGroupDeviceIndex = j;
                                break;
                            }
                        }
                        if(bFound)
                            break;
                    }
                    if(!bFound && bContinue) {
                        bContinue = true;
                        for(i=0; i < g_oMap.mapDeviceGroupList.length; i++)
                        {
                            for(j=0; j < g_oMap.mapDeviceGroupList[i].devices.length; j++)
                            {
                                if((i === groupStartIndex) && (j === g_iMapFindGroupDeviceIndex)) {
                                    bContinue = false;
                                }
                                else if((g_bMapFindUseExactMatch && (g_sMapFindSearchName.toLowerCase() === g_oMap.mapDeviceGroupList[i].devices[j].name.toLowerCase())) 
                                        || (!g_bMapFindUseExactMatch && (g_oMap.mapDeviceGroupList[i].devices[j].name.toLowerCase().indexOf(g_sMapFindSearchName.toLowerCase()) !== -1))) {
                                    bFound = true;
                                    bContinue = false;
                                    g_iMapFindGroupIndex = i;
                                    g_iMapFindGroupDeviceIndex = j;
                                    break;
                                }
                            }
                            if(!bContinue)
                                break;
                        }
                    }
                }
            }
            else if(mode === 2) {
                // previous
                if((g_iMapFindGroupIndex === -1) || (g_iMapFindGroupDeviceIndex === -1)) {
                    for(i=(g_oMap.mapDeviceGroupList.length - 1); i >=0; i--)
                    {
                        for(j=(g_oMap.mapDeviceGroupList[i].devices.length -1); j >= 0; j--)
                        {
                            if((g_bMapFindUseExactMatch && (g_sMapFindSearchName.toLowerCase() === g_oMap.mapDeviceGroupList[i].devices[j].name.toLowerCase())) 
                                        || (!g_bMapFindUseExactMatch && (g_oMap.mapDeviceGroupList[i].devices[j].name.toLowerCase().indexOf(g_sMapFindSearchName.toLowerCase()) !== -1))) {
                                bFound = true;
                                g_iMapFindGroupIndex = i;
                                g_iMapFindGroupDeviceIndex = j;
                                break;
                            }
                        }
                        if(bFound)
                            break;
                    }
                }
                else {
                    // find should only find the first device in group that matches text

                    /*groupDeviceStartIndex = g_iMapFindGroupDeviceIndex - 1;
                    groupStartIndex = g_iMapFindGroupIndex;
                    bContinue1 = false;
                    if(groupDeviceStartIndex < 0) {
                        groupStartIndex --;
                        groupDeviceStartIndex = 0;
                        bContinue1 = true;
                    }
                    */
                    bContinue = true;
                    
                    groupStartIndex = g_iMapFindGroupIndex - 1;
                    groupDeviceStartIndex = 0;
                    if(groupStartIndex < 0) {
                        bContinue = false;
                        groupStartIndex = g_oMap.mapDeviceGroupList.length - 1;
                        groupDeviceStartIndex = g_oMap.mapDeviceGroupList[groupStartIndex].devices.length - 1;
                    }
                    else { //else if(bContinue1) {
                        groupDeviceStartIndex = g_oMap.mapDeviceGroupList[groupStartIndex].devices.length - 1;
                    }
                    for(i = groupStartIndex; i >=0; i--)
                    {
                        for(j = groupDeviceStartIndex; j >= 0; j--)
                        {
                            if((g_bMapFindUseExactMatch && (g_sMapFindSearchName.toLowerCase() === g_oMap.mapDeviceGroupList[i].devices[j].name.toLowerCase())) 
                                        || (!g_bMapFindUseExactMatch && (g_oMap.mapDeviceGroupList[i].devices[j].name.toLowerCase().indexOf(g_sMapFindSearchName.toLowerCase()) !== -1))) {
                                bFound = true;
                                g_iMapFindGroupIndex = i;
                                g_iMapFindGroupDeviceIndex = j;
                                break;
                            }
                        }
                        if(bFound)
                            break;
                    }
                    if(!bFound && bContinue) {
                        bContinue = true;
                        for(i=(g_oMap.mapDeviceGroupList.length - 1); i >= 0; i--)
                        {
                            for(j=(g_oMap.mapDeviceGroupList[i].devices.length - 1); j >= 0; j--)
                            {
                                if((i === groupStartIndex) && (j === g_iMapFindGroupDeviceIndex)) {
                                    bContinue = false;
                                }
                                else if((g_bMapFindUseExactMatch && (g_sMapFindSearchName.toLowerCase() === g_oMap.mapDeviceGroupList[i].devices[j].name.toLowerCase())) 
                                        || (!g_bMapFindUseExactMatch && (g_oMap.mapDeviceGroupList[i].devices[j].name.toLowerCase().indexOf(g_sMapFindSearchName.toLowerCase()) !== -1))) {
                                    bFound = true;
                                    bContinue = false;
                                    g_iMapFindGroupIndex = i;
                                    g_iMapFindGroupDeviceIndex = j;
                                    break;
                                }
                            }
                            if(!bContinue)
                                break;
                        }
                    }
                }
            }
            
            if((g_iMainDisplayMode === DISPLAYMODE_MAP) && g_bMapView) {

                if(bFound && ((iMapFindGroupIndex !== g_iMapFindGroupIndex) || (iMapFindGroupDeviceIndex !== g_iMapFindGroupDeviceIndex))
                    && (g_iMapFindGroupIndex !== -1)  && (g_iMapFindGroupDeviceIndex !== -1)) {
                        // determine how many device in group match name
                    iCount = 0;
                    sTemp = "";
                    for(j=(g_oMap.mapDeviceGroupList[i].devices.length - 1); j >= 0; j--)
                    {
                       if((g_bMapFindUseExactMatch && (g_sMapFindSearchName.toLowerCase() === g_oMap.mapDeviceGroupList[g_iMapFindGroupIndex].devices[j].name.toLowerCase())) 
                                || (!g_bMapFindUseExactMatch && (g_oMap.mapDeviceGroupList[g_iMapFindGroupIndex].devices[j].name.toLowerCase().indexOf(g_sMapFindSearchName.toLowerCase()) !== -1))) {
                            iCount ++;
                        }
                    }
                    
                        // zoom in and show popup for found device

                    const message = JSON.stringify({
                        "action": "zoomtodevice",
                        "name":g_oMap.mapDeviceGroupList[g_iMapFindGroupIndex].devices[g_iMapFindGroupDeviceIndex].name,
                        "groupindex": g_iMapFindGroupIndex,
                        "groupdeviceindex": g_iMapFindGroupDeviceIndex
                    });
                    element = document.getElementById("mapIframe");
                    if(element !== null)
                        element.contentWindow.postMessage(message, "*");
                    if(iCount > 1)
                        showStatusInformationDiv(1, iCount + " devices found in group");
                }
                else {
                    showStatusInformationDiv(2,"Device Not found<br>" + g_sMapFindSearchName);
                }
            }
        }
    }
    catch {}
}
function mapFindold(n) {
    //not used - as currently embedding find into the UI itself.
    try {
        var element = document.getElementById("findDiv");
        var content = "";
        var offsets, x, y;
        var menuDivWidth = 0,  menuDivYOffset = -20;
        var width = 0;
        if((n !== null) && (element !== null)) {
            content += "not supported yet"
            content += "Device: <input id=\"mapFindStr\" value=\"\" placeholder=\"enter device name\" >";
            content += "<button onclick=\"mapFindFind('mapFindStr')\">Find</button>";
            offsets = n.getBoundingClientRect(); 
			
			if((offsets.x + width + window.pageXOffset + menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
				x = offsets.x + window.pageXOffset - menuDivWidth - 10; // takes into account viewport (scrolling)
			else
				x = offsets.x + width + window.pageXOffset + menuDivXOffset; // takes into account viewport (scrolling)
			
			y = offsets.y + window.pageYOffset - menuDivYOffset; // takes into account viewport (scrolling)
			
			element.style.left = x.toString() + "px";
			element.style.top = y.toString() + "px";
			element.innerHTML = menuContent;
			element.className = "menuMapFindShow";  // doesn't currently guaranty that menu is shown in viewport

			g_bInoreMouseClick = true;

            element.innerHTML = content;
            dragDiv("findDiv");
        }
    }
    catch {}
}
function mapFindFind(str) {
    try {
        var value = "error";
        var element;
        try {
            if((str !== null) && (str !== "")) {
                element = document.getElementById(str);
                if(element !== null)
                    value = element.value;
            }
            else 
                value = "error invalid value (1)";
        }
        catch {value = "error invalid value";}
        alert("map find not supported yet\r\n\r\n" + value)
    }
    catch {}
}
function mapfindtextchanged(n) {
    try {
        g_sMapFindSearchName = n.value;
    }
    catch {}
}
function mapProcessiFrameMessages(data) {
    try {
        var dp, obj, url, element;
        var priority = null;
        var objList, i, iTemp;
// add security check
        if((g_iMainDisplayMode !== DISPLAYMODE_MAP) || !g_bMapView)
            return;
        //this.alert("message from iframe:\r\n\r\n" + data);
        // If you encode the message in JSON before sending them,
        // then decode here
        const decoded = JSON.parse(data);
        if(decoded.action === "init") {
            //send object to iframe
            if(decoded.message === "success") {
                if(g_oMapInfo.mode !== -1) {
                    
                    mapCreateMapDataAndSendToIframe(g_oMapInfo.mode, g_oMapInfo.title, g_oMapInfo.path, g_oMapInfo.type, g_oMapInfo.index);
                    
                }
            }

        }
        else if (decoded.action === "showdevice") {
            if((typeof decoded.name !== "undefined") && (typeof decoded.id !== "undefined")) {
                mapInit(1);
                iTemp = decoded.id;
                if(iTemp === -1) {
                    for(i=0; i < deviceListAll.length; i++)
                    {
                        if(deviceListAll[i].name === decoded.name) {
                            iTemp = deviceListAll[i].did;
                            break;
                        }
                    }
                }
                if(iTemp !== -1)
                    getPlanningTreeShowDashboard1(false, 0, "Device_" + iTemp, decoded.name);
            }
        }
        else if (decoded.action === "showcontext") {
            if((typeof decoded.name !== "undefined") && (typeof decoded.id !== "undefined")) {
                getPlanningTreeShowTreeDetails(0, decoded.id);
            }
        }
        else if (decoded.action === "changevalue") {
            if((typeof decoded.dp !== "undefined") && (typeof decoded.value !== "undefined")  && (typeof decoded.dpType !== "undefined")
                && (typeof decoded.dpQualifier !== "undefined") && (typeof decoded.deviceName !== "undefined")) {
                alert("not supported yet\r\n\r\n" + decoded.deviceName + "\r\n" +  typeof decoded.dpQualifier + "\r\n" +  typeof decoded.value)
            }
        }
        else if (decoded.action === "datapointwrite") {
            if((typeof decoded.groupDeviceIndex !== "undefined") && (typeof decoded.groupIndex !== "undefined") && (typeof decoded.value !== "undefined")
                && (typeof decoded.programId !== "undefined") && (typeof decoded.deviceName !== "undefined")) {
                    if(decoded.groupIndex >= g_oMap.mapDeviceGroupList.length)
                        return;
                    if(decoded.groupDeviceIndex >= g_oMap.mapDeviceGroupList[decoded.groupIndex].devices.length)
                        return;
                    if(g_oMap.mapDeviceGroupList[decoded.groupIndex].devices[decoded.groupDeviceIndex].name === decoded.deviceName) {
                        dp = g_oMap.mapDeviceGroupList[decoded.groupIndex].devices[decoded.groupDeviceIndex].datapointsList[1].dpRequest;
                        //alert("datapointwrite1: not supported yet\r\n\r\n" + decoded.deviceName + "\r\n" + decoded.programId + "\r\n" +  dp + "\r\n" +  decoded.value)
                        showStatusInformationDiv(1,"writing new value to: " + decoded.deviceName + "<br>value: " +  decoded.value);
                        if(decoded.programId === "800001230E041005") {
                            obj = {};
                            obj.mode = 1;
                            obj.deviceObj = {};
                            obj.deviceObj = JSON.parse(JSON.stringify(g_oMap.mapDeviceGroupList[decoded.groupIndex].devices[decoded.groupDeviceIndex]));
                            obj.value = decoded.value;
                            url = "https://" + location.host + "/iap/devs/*+name==" + dp +  "/value";
                            requestGetData(obj, url, mapGetChangeDpValueGetResponse, mapGetChangeDpValueGetFailResponse);
                        }
                        else if ((decoded.programId === "9FFFFF0501840460") || 	(decoded.programId === "900001153C000405")) {
                            try {
                                if(decoded.value > 0)
                                    value = {"state":1,"value":decoded.value}; 
                                else
                                    value = {"state":0,"value":0};
                                url = "/iap/devs/*+name=="; //iot
                                url += dp;
                                if(priority !== null)
                                    url += "/overrides/" + priority;
                                url += "/localization/value";
                                value = JSON.stringify(value);
                                //objs[z].updateDpValue = true; // sync up value, localValue and Preset
                                writeDpValue(1,url,value, null, mapGetChangeDpValueWriteFailResponse);
                            }
                            catch {
                                showStatusInformationDiv(3,"Write aborted<br>can't write new value: <br>" + mode.deviceObj.deviceName);
                            
                            }
                        }
                        //alert("datapointwrite2: not supported yet\r\n\r\n" + decoded.deviceName + "\r\n" + decoded.programId + "\r\n" +  dp + "\r\n" +  decoded.value)
                        // get current value
                    }
            }
        }
        else if (decoded.action === "initdone") {
            try {
                if(g_oMap.mapDatapoints.length > 0) {
                    
                    createRequestString(g_oMap.mapDatapoints);
                    if(g_sOnDemandDpRequestUrl !== "") {
                        g_iBackgroundPollingRequestCount = g_iBackgroundPollingRequestCountMax + 12;
                        g_idpGetRequestIndex = 0;
                        mapStartNextRequest();
                        if(g_mapTimerId === 0) {
                            g_mapTimerId = window.setInterval("mapTimerHandler()", 4100);
                        }
                        ivbWsProcessDatapointUpdate = true;
                    }
                }
            } catch (err) {}
        }
        else if (decoded.action === "testdevice") {
            try {
                if((typeof decoded.id !== "undefined") && (typeof decoded.name !== "undefined") && (typeof decoded.groupNum !== "undefined") && (typeof decoded.offsets !== "undefined")) {
                    testDevice1(10, null, decoded.id, decoded.name, decoded.offsets);
                }
            } catch (err) {}
        }
        else if (decoded.action === "optionChange") {
            try {
                if((typeof decoded.type !== "undefined") && (typeof decoded.checked !== "undefined")) {
                    if(decoded.type === "smartserver") {
                        g_oMapOptionsSetting.bShowSmartServerDevices = decoded.checked;
                        g_oMap.options.bShowSmartServerDevices =  g_oMapOptionsSetting.bShowSmartServerDevices;
                    }
                    else if(decoded.type === "up") {
                        g_oMapOptionsSetting.bShowUpDevices = decoded.checked;
                        g_oMap.options.bShowUpDevices =  g_oMapOptionsSetting.bShowUpDevices;
                    }
                    else if(decoded.type === "down") {
                        g_oMapOptionsSetting.bShowDownDevices = decoded.checked;
                        g_oMap.options.bShowDownDevices =  g_oMapOptionsSetting.bShowDownDevices;
                    }
                    else if(decoded.type === "unprovisioned") {
                        g_oMapOptionsSetting.bShowUnprovisionedDevices = decoded.checked;
                        g_oMap.options.bShowUnprovisionedDevices =  g_oMapOptionsSetting.bShowUnprovisionedDevices;
                    }
                    else if(decoded.type === "group") {
                        g_oMapOptionsSetting.bShowGroupDevices = decoded.checked;
                        g_oMap.options.bShowGroupDevices =  g_oMapOptionsSetting.bShowGroupDevices;
                    }
                    else if(decoded.type === "lightdevice") {
                        g_oMapOptionsSetting.bShowLightDevices = decoded.checked;
                        g_oMap.options.bShowLightDevices =  g_oMapOptionsSetting.bShowLightDevices;
                    }
                    else if(decoded.type === "parentregion") {
                        g_oMapOptionsSetting.bShowParentRegion = decoded.checked;
                        g_oMap.options.bShowParentRegion =  g_oMapOptionsSetting.bShowParentRegion;
                    }
                    else if(decoded.type === "currentregion") {
                        g_oMapOptionsSetting.bShowCurrentRegion = decoded.checked;
                        g_oMap.options.bShowCurrentRegion =  g_oMapOptionsSetting.bShowCurrentRegion;
                    }
                    else if(decoded.type === "childregion") {
                        g_oMapOptionsSetting.bShowChildRegion = decoded.checked;
                        g_oMap.options.bShowChildRegion =  g_oMapOptionsSetting.bShowChildRegion;
                    }
                    else if(decoded.type === "currentcontrols") {
                        g_oMapOptionsSetting.bShowCustomControls  = decoded.checked
                        g_oMap.options.bShowCustomControls =  g_oMapOptionsSetting.bShowCustomControls;
                    }
                }
            } catch (err) {}
        }
        else if(decoded.action === "currentsettings") {
            if((typeof decoded.mode !== "undefined") && (typeof decoded.obj !== "undefined")) {
                if(decoded.mode === 1) {
                    //rebuild g_oMap with current settings: zoom, lat, long, popup
                    mapCreateMapDataAndSendToIframe(1, g_oMapInfo.title, g_oMapInfo.path, g_oMapInfo.type, g_oMapInfo.index);
                    /*
                    alert("currentsettings: \r\nmode = " + decoded.mode + "\r\n" + JSON.stringify(decoded.obj));
                    const message = JSON.stringify({
                        "action": "restart",
                        "mode": 1,
                        "message": null
                    });
                    element = document.getElementById("mapIframe");
                    if(element !== null)
                        element.contentWindow.postMessage(message, "*"); */
                }
            }
        }
    }
    catch {}

}
function mapProcessWebSocketDpData(currentTime, timestamp, json) {
    try {  
        var i,j, k,m, v, z, z1, iTemp;
        var datapointQualifier = "", dpQualifier = "", value1 = "", value2, presetValue = "", locValue,locValueStr, valueStr, displayId, origValue, origLocValue;
        var dashboardType, fieldItems, field, bContinue, color, backgroundColor, borderColor, chartIndex, tempValue, tempValue1, tempValue2, sTemp;
        var value;
        var obj, obj1, element, element1;
        var bInitializeChart = false;
        var bDataEntryRemoved = false;
        var d = new Date();
        var currentTimeMs = d.getTime();
        var fieldValue;
        if((g_iMainDisplayMode !== DISPLAYMODE_MAP) || !g_bMapView)
            return;
        for(i= 0; i < json.length; i ++)
        {
            // Web socket response
            datapointQualifier = ""; value1 = "";
            presetValue = "";
            locValue = "";
            locValueStr = "";
            value = "";
            obj = json[i];
            try {
                datapointQualifier = obj.datapointQualifier;
            }
            catch (err) {}
            try {
                value1 = obj.value
            }
            catch (err) {}
            try {
                if(!(typeof obj.presetValue === "undefined"))  {
                    if(obj.presetValue !== null) {
                        presetValue = obj.presetValue;
                    }
                }	
            } 	catch (err) {}
            try {
                if(!(typeof obj.locValue === "undefined"))  {
                    locValue = json[i].locValue;
                    locValueStr = locValue;
                    if(locValue !== null) {
                        if(typeof locValue === "number") {
                            locValueStr = locValue.toString();
                            json[i].bNumber = true;
                        }
                        else if(typeof locValue === "object") {
                            locValueStr = JSON.stringify(locValue);
                            if(locValueStr.length > 2) {
                                if((locValueStr.charAt(0) === "{") && (locValueStr.charAt(locValueStr.length - 1) === "}")) {
                                    json[i].bStructure = true;
                                    locValueStr = locValueStr.substr(1, (locValueStr.length - 2));
                                }
                            }
                        }
                    }
                }	
            } 	catch (err) {}

            for(k=0; k < g_oMap.mapDatapoints.length; k++)
            {
                dpQualifier = g_oMap.mapDatapoints[k].dpQualifier;
                //if(dashboardDpList[k].dpQualifier === datapointQualifier) {
                if(dpQualifier === datapointQualifier) {
                    try {
                        bContinue = true;
/*                        
                        if(dashboardDpList[k].cat === "in") {
                            if(!dashboardDpList[k].updateDpValue) {
                                if(dashboardDpList[k].feedbackDelay) {
                                    bContinue = false;
                                    if(currentTimeMs > dashboardDpList[k].feedbackDelayTimeout) {
                                        dashboardDpList[k].feedbackDelay = false;
                                        dashboardDpList[k].feedbackDelayTimeout = 0;
                                        bContinue = true;
                                        dashboardDpList[k].updateDpValue = true;
                                    }
                                    //else if ((dashboardDpList[k].locValueStr !== locValueStr) && isNotEqual(dashboardDpList[k].feedbackDelayOldValue, locValue)) {
                                    else if (isNotEqual(dashboardDpList[k].locValue, locValue) && isNotEqual(dashboardDpList[k].feedbackDelayOldValue, locValue)) {
                                        dashboardDpList[k].feedbackDelay = false;
                                        dashboardDpList[k].feedbackDelayTimeout = 0;
                                        bContinue = true;
                                        dashboardDpList[k].updateDpValue = true;
                                    }
                                }
                            }
                        }
                        */
                        if(bContinue && (g_oMap.mapDatapoints[k].updateDpValue || (isNotEqual(value1, g_oMap.mapDatapoints[k].value)))){
                            g_oMap.mapDatapoints[k].updateDpValue = false;
                            g_oMap.mapDatapoints[k].value = value1;
                            /* if(g_oMap.mapDatapoints[k].programId === "800001230E041005") {
                                value1 = value1.setting.value;
                            } */
                            
                            const message = JSON.stringify({
                                "action": "datapointupdate",
                                "datapoint": dpQualifier,
                                "value": value1,
                                "index": k,
                                "bDevice": g_oMap.mapDatapoints[k].bDevice, // light controllers
                                "bDashboard": g_oMap.mapDatapoints[k].bDashboard, // map dashboard
                                "deviceName": g_oMap.mapDatapoints[k].deviceName,
                                "programId": g_oMap.mapDatapoints[k].programId
                            });
                            element = document.getElementById("mapIframe");
                            if(element !== null)
                                element.contentWindow.postMessage(message, "*");
                        }
                    }
                    catch {}
                    break;
                }
            }
        }
    }
    catch {}
}
function mapResize() {
    try {
        var element, element1, width, height, value;
        element = element = document.getElementById("mapIframe");
        if(element !== null) {
            element1 = document.getElementById("planningTreeShowTreeExpandButton");
            if(element1 !== null) {
                value = element1.getAttribute("data-navtree-expand");
                element1 = document.getElementById("planningPaneDetails");
                if(element1 !== null) {
                    width = (screen.width - element1.offsetLeft -  100);
                    height = (screen.height - 290);
                    try {
                        if(value === "expanded") {
                            // tree shows up so smaller map (narrower)
                            //make map div smaller followed by iframe, followed by resize in iframe window.dispatchEvent(new Event('resize'));
                            // send to iframe map dimensions: (width - 30) + "px&height=" + (height - 30)
                            mapSendMapDivResize((width - 30),(height - 30));
                            element.style.width = width.toString() + "px";
                            element.style.height = height.toString() + "px";
                        }
                        else {
                            // tree hidden so larger map (wider)
                            //change iframe size first then map div, followed by resize in iframe window.dispatchEvent(new Event('resize'));
                            element.style.width = width.toString() + "px";
                            element.style.height = height.toString() + "px";
                            mapSendMapDivResize((width - 30),(height - 30));
                            
                        }
                    }
                    catch (err) {
                        error = err.toString();
                    }
                }
            }
        }
    }
    catch {}
}
function mapCreateMapDataAndSendToIframe(mode, contextName, contextPath, type, index) {
    //mode: 0=context, 1=restart, 2=device
    var center, lat, long, zoomLevel, defaultLat = 0; defaultLong = 0;;
    var coordinates = [];
    var defaultLatLong = [];
    var bContinue;
    var json = null;
    var i, j, k, m, z, iTemp;
    var obj = {}, obj1;
    var bAtLeastOneLightDevice = false;
	var element;
    var bRestart = false;
    var bSmallDisplay = false;
    try {
		g_oMap = {};
		g_oMap.mode = mode;
		g_oMap.name = contextName;
        g_oMap.path = contextPath;
		g_oMap.type = type;
		g_oMap.index = index;
        g_oMap.numberOfLightDevices = 0;
        g_oMap.bAtLeastOneGroupWithMultipleDevices = false; // true:show group checkbox on map
        g_oMap.bOnlyWorld = false; // used for zoom out
        g_oMap.sDpRequestUrl = ""; // light devices only
        g_oMap.mapDatapoints = []; // light devices only
        g_oMap.mapParentPolygonList = [];
		g_oMap.mapPolygonList = []; // current context 
        g_oMap.mapChildPolygonList = [];
        g_oMap.mapDeviceList = [];
        g_oMap.mapDeviceGroupList = [];
        g_oMap.center = {};
        g_oMap.options = {};
        g_oMap.InitialInfo = null;
        g_oMap.dashboard = null; // shows dashboard on map
        g_oMap.options.bClickShowLatLong = g_oMapOptionsSetting.bClickShowLatLong; // true means show lat long when mouse clicked
        g_oMap.options.iShowDevicesMode =  g_oMapOptionsSetting.iShowDevicesMode; // all
        g_oMap.options.bShowSmartServerDevices =  g_oMapOptionsSetting.bShowSmartServerDevices;
        g_oMap.options.bShowUpDevices =  g_oMapOptionsSetting.bShowUpDevices;
        g_oMap.options.bShowLightDevices =  g_oMapOptionsSetting.bShowLightDevices;
        g_oMap.options.bShowDownDevices =  g_oMapOptionsSetting.bShowDownDevices;
        g_oMap.options.bShowGroupDevices =  g_oMapOptionsSetting.bShowGroupDevices;
        g_oMap.options.bShowUnprovisionedDevices =  g_oMapOptionsSetting.bShowUnprovisionedDevices;
        g_oMap.options.bShowParentRegion = g_oMapOptionsSetting.bShowParentRegion; // all
        g_oMap.options.bShowCurrentRegion = g_oMapOptionsSetting.bShowCurrentRegion; // all
        g_oMap.options.bShowChildRegion = g_oMapOptionsSetting.bShowChildRegion; // all
        g_oMap.options.bShowLightDevice =  g_oMapOptionsSetting.bShowLightDevice;
        g_oMap.options.bShowHideSmartServers = g_oMapOptionsSetting.bShowHideSmartServers;
        g_oMap.options.bShowAllTooltips = g_oMapOptionsSetting.bShowAllTooltips;
        g_oMap.options.bShowContext = g_oMapOptionsSetting.bShowContext;
        g_oMap.options.bShowCustomControls = g_oMapOptionsSetting.bShowCustomControls

        if(screen.width < 1600)
            bSmallDisplay = true;

        if(mode === 1) {
            bRestart = true;
            mode = 0;
            g_oMap.InitialInfo = {};
            g_oMap.InitialInfo.lat = "";
            g_oMap.InitialInfo.long = "";
            g_oMap.InitialInfo.zoomLevel = "";
            g_oMap.InitialInfo.popupGroupName = "";
        }

        if(mode === 0) {
            z = -1;
            if(g_campusTags !== null) {
                if(typeof g_campusTags.map !== "undefined") {
                    if(!g_bCustomTagsHasMapObjs) {
                        g_campusTags.map = [];
                    }
                    if(g_campusTags.map.length === 1) {
                        g_oMap.dashboard = {};
                        g_oMap.dashboard.bShowDashboard = true;
                        g_oMap.dashboard.name = "Starter Kit";
                        g_oMap.dashboard.iShowContextNames = false;
                        g_oMap.dashboard.bClickToDevice = g_campusTags.map[0].bClickToDevice;
                        g_oMap.dashboard.dpList = [];
                        k = g_campusTags.map[0].dpList.length;
                        if(bSmallDisplay && (g_campusTags.map[0].dpList.length > g_iMapDashboardSmallMonitorMaxNumberOfRows))
                            k = g_iMapDashboardSmallMonitorMaxNumberOfRows;

                        for(m=0; m < k; m++)
                        {
                            for(j=0; j < deviceListAll.length; j++)
                            {
                                obj = {};
                                if(deviceListAll[j].category !== "SC") {
                                    if(g_campusTags.map[0].dpList[m].deviceName.toLowerCase() === deviceListAll[j].name.toLowerCase()) {
                                        if(deviceListAll[j].status.state === "provisioned") {
                                            g_oMap.dashboard.dpList.push(JSON.parse(JSON.stringify(g_campusTags.map[0].dpList[m])));
                                            try {
                                                i = g_oMap.dashboard.dpList.length - 1;
                                                g_oMap.dashboard.dpList[i].deviceName = g_oMap.dashboard.dpList[i].deviceTypeStr;
                                                g_oMap.dashboard.dpList[i].deviceTypeName = g_oMap.dashboard.dpList[i].deviceTypeStr;
                                                for(j=0; j < deviceListAll.length; j++)
                                                {
                                                    obj = {};
                                                    if(deviceListAll[j].category !== "SC") {
                                                        if(g_oMap.dashboard.dpList[i].deviceName.toLowerCase() === deviceListAll[j].name.toLowerCase()) {
                                                            g_oMap.dashboard.dpList[i].scId = deviceListAll[j].scId;
                                                            if(typeof deviceListAll[j].programId === "undefined") {
                                                                for(k=0; k < deviceTypeList.length; k++)
                                                                {
                                                                    if(deviceListAll[j].typeId === deviceTypeList[k].id) {
                                                                        deviceListAll[j].deviceTypeName = deviceTypeList[k].name;
                                                                        deviceListAll[j].programId = deviceTypeList[k].programId;
                                                                        break;
                                                                    }
                                                                }
                                                            }
                                                            g_oMap.dashboard.dpList[i].programId = deviceListAll[j].programId;
                                                            g_oMap.dashboard.dpList[i].DID = deviceListAll[j].DID;
                                                            g_oMap.dashboard.dpList[i].bValueAdded = false;
                                                            g_oMap.dashboard.dpList[i].protocol = deviceListAll[j].protocol;
                                                            g_oMap.dashboard.dpList[i].dpRequest =  deviceListAll[j].name + "/if/" + g_oMap.dashboard.dpList[i].blockPath;
                                                            g_oMap.dashboard.dpList[i].dpQualifier =  deviceListAll[j].scId + "/" + deviceListAll[j].protocol + "/" + deviceListAll[j].DID + "/" + g_oMap.dashboard.dpList[i].blockPath;
                                                            j = deviceListAll.length + 2;
                                                            break;
                                                        }
                                                    }
                                                    
                                                }
                                            }
                                            catch {}
                                        }
                                    }
                                }
                            }
                        }
                        z = g_oMap.dashboard.dpList.length;
                    }
                    else if(g_campusTags.map.length === 0) {
                        if (g_oMapDashboard !== null) {
                            if(g_oMapDashboard.dpList.length > 0) {
                                g_oMap.dashboard = {};
                                g_oMap.dashboard.bShowDashboard = g_oMapDashboard.bShowDashboard;
                                g_oMap.dashboard.name = g_oMapDashboard.name;
                                g_oMap.dashboard.iShowContextNames = false;
                                g_oMap.dashboard.bClickToDevice = g_oMapDashboard.bClickToDevice;
                                g_oMap.dashboard.dpList = [];

                                k = g_oMapDashboard.dpList.length;
                                if(bSmallDisplay && (g_oMapDashboard.dpList.length > g_iMapDashboardSmallMonitorMaxNumberOfRows))
                                    k = g_iMapDashboardSmallMonitorMaxNumberOfRows;
        
                                for(m=0; m < k; m++)
                                {
                                    for(j=0; j < deviceListAll.length; j++)
                                    {
                                        obj = {};
                                        if(deviceListAll[j].category !== "SC") {
                                            if(g_oMapDashboard.dpList[m].deviceName.toLowerCase() === deviceListAll[j].name.toLowerCase()) {
                                                if(deviceListAll[j].status.state === "provisioned") {
                                                    g_oMap.dashboard.dpList.push(JSON.parse(JSON.stringify(g_oMapDashboard.dpList[m])));
                                                    try {
                                                        i = g_oMap.dashboard.dpList.length - 1;
                                                        g_oMap.dashboard.dpList[i].deviceName = g_oMap.dashboard.dpList[i].deviceTypeStr;
                                                        g_oMap.dashboard.dpList[i].deviceTypeName = g_oMap.dashboard.dpList[i].deviceTypeStr;
                                                        for(j=0; j < deviceListAll.length; j++)
                                                        {
                                                            obj = {};
                                                            if(deviceListAll[j].category !== "SC") {
                                                                if(g_oMap.dashboard.dpList[i].deviceName.toLowerCase() === deviceListAll[j].name.toLowerCase()) {
                                                                    g_oMap.dashboard.dpList[i].scId = deviceListAll[j].scId;
                                                                    if(typeof deviceListAll[j].programId === "undefined") {
                                                                        for(k=0; k < deviceTypeList.length; k++)
                                                                        {
                                                                            if(deviceListAll[j].typeId === deviceTypeList[k].id) {
                                                                                deviceListAll[j].deviceTypeName = deviceTypeList[k].name;
                                                                                deviceListAll[j].programId = deviceTypeList[k].programId;
                                                                                break;
                                                                            }
                                                                        }
                                                                    }
                                                                    g_oMap.dashboard.dpList[i].programId = deviceListAll[j].programId;
                                                                    g_oMap.dashboard.dpList[i].DID = deviceListAll[j].DID;
                                                                    g_oMap.dashboard.dpList[i].bValueAdded = false;
                                                                    g_oMap.dashboard.dpList[i].protocol = deviceListAll[j].protocol;
                                                                    g_oMap.dashboard.dpList[i].dpRequest =  deviceListAll[j].name + "/if/" + g_oMap.dashboard.dpList[i].blockPath;
                                                                    g_oMap.dashboard.dpList[i].dpQualifier =  deviceListAll[j].scId + "/" + deviceListAll[j].protocol + "/" + deviceListAll[j].DID + "/" + g_oMap.dashboard.dpList[i].blockPath;
                                                                    j = deviceListAll.length + 2;
                                                                    break;
                                                                }
                                                            }
                                                            
                                                        }
                                                    }
                                                    catch {}
                                                }
                                            }
                                        }
                                    }
                                }
                                z = g_oMap.dashboard.dpList.length;
                            }
                        }
                    }
                    else 
                        z = -1;
                }
                else if (g_oMapDashboard !== null) {
                    if(g_oMapDashboard.dpList.length > 0) {
                        g_oMap.dashboard = {};
                        g_oMap.dashboard.bShowDashboard = g_oMapDashboard.bShowDashboard;
                        g_oMap.dashboard.name = g_oMapDashboard.name;
                        g_oMap.dashboard.iShowContextNames = false;
                        g_oMap.dashboard.bClickToDevice = g_oMapDashboard.bClickToDevice;
                        g_oMap.dashboard.dpList = [];
                        k = g_oMapDashboard.dpList.length;
                        if(bSmallDisplay && (g_oMapDashboard.dpList.length > g_iMapDashboardSmallMonitorMaxNumberOfRows))
                            k = g_iMapDashboardSmallMonitorMaxNumberOfRows;

                        for(m=0; m < k; m++)
                        {
                            for(j=0; j < deviceListAll.length; j++)
                            {
                                obj = {};
                                if(deviceListAll[j].category !== "SC") {
                                    if(g_oMapDashboard.dpList[m].deviceName.toLowerCase() === deviceListAll[j].name.toLowerCase()) {
                                        if(deviceListAll[j].status.state === "provisioned") {
                                            g_oMap.dashboard.dpList.push(JSON.parse(JSON.stringify(g_oMapDashboard.dpList[m])));
                                            try {
                                                i = g_oMap.dashboard.dpList.length - 1;
                                                g_oMap.dashboard.dpList[i].deviceName = g_oMap.dashboard.dpList[i].deviceTypeStr;
                                                g_oMap.dashboard.dpList[i].deviceTypeName = g_oMap.dashboard.dpList[i].deviceTypeStr;
                                                for(j=0; j < deviceListAll.length; j++)
                                                {
                                                    obj = {};
                                                    if(deviceListAll[j].category !== "SC") {
                                                        if(g_oMap.dashboard.dpList[i].deviceName.toLowerCase() === deviceListAll[j].name.toLowerCase()) {
                                                            g_oMap.dashboard.dpList[i].scId = deviceListAll[j].scId;
                                                            if(typeof deviceListAll[j].programId === "undefined") {
                                                                for(k=0; k < deviceTypeList.length; k++)
                                                                {
                                                                    if(deviceListAll[j].typeId === deviceTypeList[k].id) {
                                                                        deviceListAll[j].deviceTypeName = deviceTypeList[k].name;
                                                                        deviceListAll[j].programId = deviceTypeList[k].programId;
                                                                        break;
                                                                    }
                                                                }
                                                            }
                                                            g_oMap.dashboard.dpList[i].programId = deviceListAll[j].programId;
                                                            g_oMap.dashboard.dpList[i].DID = deviceListAll[j].DID;
                                                            g_oMap.dashboard.dpList[i].bValueAdded = false;
                                                            g_oMap.dashboard.dpList[i].protocol = deviceListAll[j].protocol;
                                                            g_oMap.dashboard.dpList[i].dpRequest =  deviceListAll[j].name + "/if/" + g_oMap.dashboard.dpList[i].blockPath;
                                                            g_oMap.dashboard.dpList[i].dpQualifier =  deviceListAll[j].scId + "/" + deviceListAll[j].protocol + "/" + deviceListAll[j].DID + "/" + g_oMap.dashboard.dpList[i].blockPath;
                                                            j = deviceListAll.length + 2;
                                                            break;
                                                        }
                                                    }
                                                    
                                                }
                                            }
                                            catch {}
                                        }
                                    }
                                }
                            }
                        }
                        z = g_oMap.dashboard.dpList.length;
                    }
                }
            }
            if(z !== -1) {
                for(i=0; i < z; i++)
                {
                    // check if any datapoints have scaledp rbt
                    if(typeof g_oMap.dashboard.dpList[i].scaleDp !== "undefined") {
                        if(g_oMap.dashboard.dpList[i].scaleDp !== "") {
                            try {
                                    obj = {};
                                    obj = JSON.parse(JSON.stringify(g_oMap.dashboard.dpList[i]));
                                    obj.displayType = g_oMap.dashboard.dpList[i].scaleDisplayType;
                                    g_oMapScaleDisplayId ++;
                                    g_oMap.dashboard.dpList[i].scaleDisplayId = g_oMapScaleDisplayId; // use to make connect datapoints
                                    obj.scaleDisplayId = g_oMapScaleDisplayId; // use to make connect datapoints
                                    obj.parentDpListIndex = i;
                                    obj.parentPath = g_oMap.dashboard.dpList[i].deviceName + "/"  + obj.blockPath;
                                    obj.scaleValue = null;
                                    obj.blockPath = g_oMap.dashboard.dpList[i].scaleDp;
                                    obj.dp = obj.blockPath;
                                    obj.field = "";
                                    obj.dpRequest =  g_oMap.dashboard.dpList[i].name + "/if/" + obj.blockPath;
                                    obj.dpQualifier =  g_oMap.dashboard.dpList[i].scId + "/" + g_oMap.dashboard.dpList[i].protocol + "/" + g_oMap.dashboard.dpList[i].DID + "/" + obj.blockPath;
                                    g_oMap.dashboard.dpList.push(JSON.parse(JSON.stringify(obj)));
                                
                            }
                            catch {}
                        }
                    }
                }
            }
        }
        for(i=0; i < deviceListAll.length; i++)
        {
            obj = {};
            if(deviceListAll[i].category === "SC") {
                obj.lat = deviceListAll[i].latitude;
                obj.long = deviceListAll[i].longitude;
                obj.name = deviceListAll[i].name;
                obj.sid = deviceListAll[i].SID;
                defaultLatLong.push(obj);
            }
            
        }
        
        // not all devices are assigned lat long so use smartServer
        for(i=0; i < deviceListAll.length; i++)
        {
            obj = {};
            obj.name = deviceListAll[i].name;
            if((mode === 0) || ((mode === 2) && (contextName === deviceListAll[i].name))) {
                obj.id = deviceListAll[i].id;
                obj.scId = deviceListAll[i].scId;
                obj.deviceTypeName = "";
                obj.programId = "";
                obj.DID = "";
                obj.category = deviceListAll[i].category;
                if(deviceListAll[i].category !== "SC") {
                    obj.programId = deviceListAll[i].programId;
                    obj.deviceTypeName = deviceListAll[i].deviceTypeName;
                    obj.DID = deviceListAll[i].DID;
                }
                
                z = -1;
                if((deviceListAll[i].latitude === "NaN") || (deviceListAll[i].longitude  === "NaN")) {
                    
                    for(j=0; j < defaultLatLong.length; j++)
                    {
                        if(defaultLatLong[j].sid === deviceListAll[i].scId) {
                            obj.lat = defaultLatLong[j].lat;
                            obj.long = defaultLatLong[j].long;
                            z = j;
                            break;
                        }
                    }
                    
                }
                else {
                    z = 1;
                    obj.lat = deviceListAll[i].latitude;
                    obj.long = deviceListAll[i].longitude;
                }
                if(z !== -1) {
                    bContinue = true;
                    //if(contextPath !== "World") {
                        //only use devices in context or its child contexts
                    //    bContinue = false;
                        if(typeof deviceListAll[i].contextPaths === "undefined") {
                            deviceListAll[i].contextPaths = [];
                            for(j=0; j < deviceListAll[i].contexts.length; j++)
                            {
                                deviceListAll[i].contextPaths.push(treeviewfindContextPathFromId(deviceListAll[i].contexts[j], planningList, ""));
                            }
                        }
                        /*
                        for(j=0; j < deviceListAll[i].contextPaths.length; j++)
                        {
                            
                            sTemp = deviceListAll[i].contextPaths[j];
                            if(sTemp.startsWith(contextPath)) {
                                bContinue = true;
                                break;
                            }
                        }
                    }
                    */
                    if(bContinue) {
                        coordinates.push(JSON.parse(JSON.stringify(obj)));
                        if(deviceListAll[i].category === "SC")
                            obj.status = "smartserver";
                        else {
                            obj.status = deviceListAll[i].deviceStatus;
                            if(obj.status === "provisioning")
                                obj.status = "unprovisioned";
                            if((deviceListAll[i].programId === "800001230E041005") || (deviceListAll[i].programId === "9FFFFF0501840460") || (deviceListAll[i].programId === "900001153C000405"))
                                bAtLeastOneLightDevice = true;
                        }
                        obj.lightType = 0; // 0 = none, 1=snvt switch, 2, snvt_swtich_2
                        obj.lightDp = ""; // if light feedback then specify light datapoint to poll
                        obj.marker = null;
                        obj.category = deviceListAll[i].category;
                        obj.contextPaths = JSON.parse(JSON.stringify(deviceListAll[i].contextPaths));
                        g_oMap.mapDeviceList.push(JSON.parse(JSON.stringify(obj)));
                    }
                }
                if(mode === 2) {
                    // add parent region
                    center = {};
                    center.zoomLevel = 18;
                    center.lat = obj.lat; 
                    center.long = obj.long;
                    g_oMap.center = JSON.parse(JSON.stringify(center));
                    
                    mapGetDeviceParentRegion(deviceListAll[i].contexts);
                    break; // only single device
                }
            }
        }
        
        if(!bAtLeastOneLightDevice) {
            element = document.getElementById("mapShowLightCheckboxDivId")
            if(element !== null) {
                element.style.display = "none";
            }
        }
        json = null;
        if(mode === 0) {
            g_oMap.center = null;
            if(contextPath === "World") {
                try {
                    if((planningList.length === 0) || (planningList[0].children === 0)) {
                        g_oMap.bOnlyWorld = true; // used for zoom out
                        center = mapDetermineCenterOfRegion(coordinates);
                        lat = center.lat; 
                        long = center.long;
                        g_oMap.center = JSON.parse(JSON.stringify(center));
                        obj = {};
                        obj.name = getPathLastName(contextPath);
                        obj.path = contextPath;
                        obj.color = "";
                        obj.polygonCoord = [];
                        obj.polygon = null;
                        coordinates = [];
                        coordinates[0] = [center.x1 - MAPPOLYGON_OFFSET,center.y1 - MAPPOLYGON_OFFSET]; //{"lat":center.x1, "lng":center.y1};
                        coordinates[1] = [center.x1 - MAPPOLYGON_OFFSET,center.y2 + MAPPOLYGON_OFFSET];  //{"lat":center.x1, "lng":center.y2};
                        coordinates[2] = [center.x2 + MAPPOLYGON_OFFSET,center.y2 + MAPPOLYGON_OFFSET];  //{"lat":center.x2, "lng":center.y2};
                        coordinates[3] = [center.x2 + MAPPOLYGON_OFFSET,center.y1 - MAPPOLYGON_OFFSET];  //{"lat":center.x2, "lng":center.y1};
                        coordinates[4] = [center.x1 - MAPPOLYGON_OFFSET,center.y1 - MAPPOLYGON_OFFSET];  //{"lat":center.x1, "lng":center.y1};
                        obj.polygonCoord = JSON.parse(JSON.stringify(coordinates));  // this is only used for SmartServer with no contexts
                    
                    
                        if((center.x1 === center.x2) && (center.y1 === center.y2)) {
                            //only one group means no Polygon so remove 
                            element = document.getElementById("mapShowContextCheckboxDivId");
                            if(element !== null)
                                element.style.display = "none";
                            
                        }
                        else {
                            if(contextPath === "World") {
                                g_oMap.mapPolygonList.push(obj);

                            }
                        }
                    }
                    else {
                        // use children and devices lat long for center of 
                        coordinates = [];
                        for(i=0; i < planningList[0].devices.length; i++)
                        {
                            obj = {};
                            obj.lat = planningList[0].devices[i].latitude;
                            obj.long = planningList[0].devices[i].longitude;
                            coordinates.push(JSON.parse(JSON.stringify(obj)));
                        }
                        for(i=0; i < planningList[0].children.length; i++)
                        {
                            if(i === 0) {
                                if(coordinates.length === 0)
                                    coordinates = JSON.parse(JSON.stringify(planningList[0].children[i].contextLocation))
                                else
                                    coordinates = coordinates.concat(planningList[0].children[i].contextLocation);
                            }
                            else {
                                json = getPlanningTreeShowTreeDetailsGetObj(planningList, planningList[0].children[i].id, 0);
                                coordinates = coordinates.concat(json.contextLocation);
                            }
                        }
                        center = mapDetermineCenterOfRegion(coordinates);
                        lat = center.lat; 
                        long = center.long;
                        
                        if(planningList[0].devices.length > 0) {
                            // not all devices are in child regions
                            if(center.zoomLevel > 1)
                                center.zoomLevel --;
                            obj = {};
                            obj.name = getPathLastName(contextPath);
                            obj.path = contextPath;
                            obj.color = "blue";
                            obj.polygonCoord = [];
                            obj.polygon = null;
                            coordinates = [];
                            coordinates[0] = [center.x1 - MAPPOLYGON_OFFSET,center.y1 - MAPPOLYGON_OFFSET]; //{"lat":center.x1, "lng":center.y1};
                            coordinates[1] = [center.x1 - MAPPOLYGON_OFFSET,center.y2 + MAPPOLYGON_OFFSET];  //{"lat":center.x1, "lng":center.y2};
                            coordinates[2] = [center.x2 + MAPPOLYGON_OFFSET,center.y2 + MAPPOLYGON_OFFSET];  //{"lat":center.x2, "lng":center.y2};
                            coordinates[3] = [center.x2 + MAPPOLYGON_OFFSET,center.y1 - MAPPOLYGON_OFFSET];  //{"lat":center.x2, "lng":center.y1};
                            coordinates[4] = [center.x1 - MAPPOLYGON_OFFSET,center.y1 - MAPPOLYGON_OFFSET];  //{"lat":center.x1, "lng":center.y1};
                            obj.polygonCoord = JSON.parse(JSON.stringify(coordinates));  // this is only used for SmartServer with no contexts
                            g_oMap.mapPolygonList.push(obj);
                        }
                        g_oMap.center = JSON.parse(JSON.stringify(center));
                        json = JSON.parse(JSON.stringify(planningList[0]));
                    }
                }
                catch {}
            }
            else {
                json = getPlanningTreeShowTreeDetailsGetObj(planningList, index, 0);
                center = mapDetermineCenterOfRegion(json.contextLocation);
                lat = center.lat; 
                long = center.long;
                g_oMap.center = JSON.parse(JSON.stringify(center));
            }
            createMapRegions(mode, contextPath, type, index);
            // add groups for any buildings, all devices in that building go into this group
            if(g_oMapOptionsSetting.bGroupBuildingDevices) {
                if(json !== null)
                    mapCreateContextGroupList(JSON.parse(JSON.stringify(json)));
            }
            //check if more than one device at same location
        }
        
        for(i=0; i < g_oMap.mapDeviceList.length;i++)
        {
            k = -1;
            z = -1;
            for(j = 0; j < g_oMap.mapDeviceGroupList.length; j++)
            {
                bContinue = false;
                if(g_oMap.mapDeviceGroupList[j].groupType === "building") {
                    //check if device has a context starting with 
                    for(m=0; m < g_oMap.mapDeviceList[i].contextPaths.length; m++)
                    {
                        if(g_oMap.mapDeviceList[i].contextPaths[m].startsWith(g_oMap.mapDeviceGroupList[j].groupContextPath)) {
                            bContinue = true;
                            break;
                        }
                    }
                }
                else {
                    if((g_oMap.mapDeviceList[i].lat === g_oMap.mapDeviceGroupList[j].lat) && (g_oMap.mapDeviceList[i].long === g_oMap.mapDeviceGroupList[j].long))
                        bContinue = true;
                }
                if(bContinue) {
                    k = j;
                    g_oMap.mapDeviceGroupList[j].count ++;
                    obj1 = {};
                    obj1.name = g_oMap.mapDeviceList[i].name;
                    obj1.id = g_oMap.mapDeviceList[i].id;
                    obj1.status = g_oMap.mapDeviceList[i].status;
                    obj1.DID = g_oMap.mapDeviceList[i].DID;
                    obj1.programId = g_oMap.mapDeviceList[i].programId;
                    obj1.deviceTypeName = g_oMap.mapDeviceList[i].deviceTypeName;
                    obj1.scId = g_oMap.mapDeviceList[i].scId;
                    obj1.category = g_oMap.mapDeviceList[i].category;
                    obj1.datapointsList = [];
                    obj1.bLightDevice = false;
                    obj1.oLightDevice = null;
                    obj1.groupIndex = j;
                    obj1.groupDeviceIndex = g_oMap.mapDeviceGroupList[j].devices.length;
                    g_oMap.bAtLeastOneGroupWithMultipleDevices = true;
                    g_oMap.mapDeviceGroupList[j].devices.push(JSON.parse(JSON.stringify(obj1)));
                    break;
                }
            }
            if(k === -1) {
                obj = {};
                obj.count = 1;
                obj.groupName = "group" + (g_oMap.mapDeviceGroupList.length - 1).toString();
                obj.groupType = "devices"; // all devices not in a building 
                obj.groupContextName = ""; //used for buildings
                obj.groupContextPath = ""; //used for buildings
                obj.groupContextId = -1; //used for buildings
                obj.lat = g_oMap.mapDeviceList[i].lat;
                obj.long = g_oMap.mapDeviceList[i].long;
                obj.bAtLeastOneLightDevice = false;
                obj.sLayerGroupName = null; //only set to a name if a single device in group or only one device matches criteria (like up) in group
                obj.devices = [];
                obj1 = {};
                obj1.name = g_oMap.mapDeviceList[i].name;
                obj1.id = g_oMap.mapDeviceList[i].id;
                obj1.status = g_oMap.mapDeviceList[i].status;
                obj1.DID = g_oMap.mapDeviceList[i].DID;
                obj1.programId = g_oMap.mapDeviceList[i].programId;
                obj1.scId = g_oMap.mapDeviceList[i].scId;
                obj1.category = g_oMap.mapDeviceList[i].category;
                obj1.deviceTypeName = g_oMap.mapDeviceList[i].deviceTypeName;
                obj1.bLightDevice = false;
                obj1.oLightDevice = null;
                obj1.datapointsList = [];
                obj1.groupIndex = g_oMap.mapDeviceGroupList.length;
                obj1.groupDeviceIndex = 0;
                obj.devices.push(obj1);
                g_oMap.mapDeviceGroupList.push(JSON.parse(JSON.stringify(obj)));
                k = g_oMap.mapDeviceGroupList.length - 1;
            }
            if(g_bMapCheckForLightDevices && (k !== -1)) {
                // supported Light devices like CPDsim
                z = g_oMap.mapDeviceGroupList[k].devices.length - 1;
                mapCheckForSpecialDevice(k,z);
                
            }
        }
        if(mode === 0) {
            // add map dashboard datapoints
            mapCheckForMapDashboardDatapoints();
        }
        g_iMapSeqNum ++;
        //if(g_oMap.numberOfLightDevices >  0) {
        if(g_oMap.mapDatapoints.length > 0) {
            //get intial datapoint values
            iTemp = 0;
            if(bRestart)
                iTemp = 1;
            mapGetDpValues(iTemp);
            return;
        }
        if(bRestart) {
            message = JSON.stringify({
                "action": "restart",
                "message": g_oMap,
                "seqnum": g_iMapSeqNum
            });
        }
        else { //initial
            message = JSON.stringify({
                "action": "initaildata",
                "message": g_oMap,
                "seqnum": g_iMapSeqNum
            });
        }
        
        element = document.getElementById("mapIframe");
        if(element !== null)
            element.contentWindow.postMessage(message, "*");
        
        
    }
    catch (err) {}
}
function mapCheckForSpecialDevice(k,z) {
    try {
        // supported Light devices like CPDsim
        var obj, obj1, i, j;
        if(k > (g_oMap.mapDeviceGroupList.length - 1))
            return;
        
        if(z >= 0) {
            
            if(g_oMap.mapDeviceGroupList[k].devices[z].programId === "800001230E041005") {
                g_oMap.mapDeviceGroupList[k].bAtLeastOneLightDevice = true;
                g_oMap.mapDeviceGroupList[k].devices[z].bLightDevice = true;
                obj = {};
                obj.name = g_oMap.mapDeviceGroupList[k].devices[z].name;
                obj.datapointList = [];
                obj.sLightDeviceDeviceType = g_oMap.mapDeviceGroupList[k].devices[z].deviceTypeName;
                obj.sLightDeviceType = "SNVT_switch_2";
                g_oMap.mapDeviceGroupList[k].devices[z].oLightDevice = {};
                g_oMap.mapDeviceGroupList[k].devices[z].oLightDevice = JSON.parse(JSON.stringify(obj));
                obj1 = {};
                obj1.deviceName = obj.name;
                obj1.dp = "LuminairCntrl/0/nvoLampFb"; // read
                obj1.cat = "out";
                obj1.type = "SNVT_switch_2";
                obj1.field = "setting/value";
                obj1.dpQualifier = g_oMap.mapDeviceGroupList[k].devices[z].scId + "/lon/" +  g_oMap.mapDeviceGroupList[k].devices[z].DID + "/" + obj1.dp;
                obj1.dpRequest = g_oMap.mapDeviceGroupList[k].devices[z].name + "/if/" + obj1.dp;
                obj1.value = null;
                obj1.g_oMap_mapDatapointsIndex = g_oMap.mapDatapoints.length;
                g_oMap.mapDeviceGroupList[k].devices[z].datapointsList.push(JSON.parse(JSON.stringify(obj1)));
                obj1.groupIndex = k;
                obj1.groupDeviceIndex = z;
                obj1.updateDpValue = false;
                obj1.programId = g_oMap.mapDeviceGroupList[k].devices[z].programId;
                obj1.bDevice = true;
                obj1.bDashboard = false;
                g_oMap.mapDatapoints.push(JSON.parse(JSON.stringify(obj1)));
                obj1 = {};
                obj1.deviceName = obj.name;
                obj1.dp = "LuminairCntrl/0/nviLampValue"; //write
                obj1.type = "SNVT_switch_2";
                obj1.dpQualifier = g_oMap.mapDeviceGroupList[k].devices[z].scId + "/lon/" +  g_oMap.mapDeviceGroupList[k].devices[z].DID + "/" + obj1.dp;
                obj1.dpRequest = g_oMap.mapDeviceGroupList[k].devices[z].name + "/if/" + obj1.dp;
                obj1.cat = "in";
                obj1.value = null;
                obj1.field = "";
                obj1.dpQualifier = "";
                obj1.g_oMap_mapDatapointsIndex = null;
                g_oMap.mapDeviceGroupList[k].devices[z].datapointsList.push(JSON.parse(JSON.stringify(obj1)));
                g_oMap.numberOfLightDevices ++;
            }
            else if(g_bMapMultiSensorDeviceEnabled) {
                if((g_oMap.mapDeviceGroupList[k].devices[z].programId === "9FFFFF0501840460") || 	(g_oMap.mapDeviceGroupList[k].devices[z].programId === "900001153C000405")) {
                    g_oMap.mapDeviceGroupList[k].bAtLeastOneLightDevice = true;
                    g_oMap.mapDeviceGroupList[k].devices[z].bLightDevice = true;
                    obj = {};
                    obj.name = g_oMap.mapDeviceGroupList[k].devices[z].name;
                    obj.datapointList = [];
                    obj.sLightDeviceDeviceType = g_oMap.mapDeviceGroupList[k].devices[z].deviceTypeName;
                    obj.sLightDeviceType = "SNVT_switch";
                    g_oMap.mapDeviceGroupList[k].devices[z].oLightDevice = {};
                    g_oMap.mapDeviceGroupList[k].devices[z].oLightDevice = JSON.parse(JSON.stringify(obj));
                    obj1 = {};
                    obj1.deviceName = obj.name;
                    obj1.dp = "";
                    if(g_oMap.mapDeviceGroupList[k].devices[z].programId === "9FFFFF0501840460")
                        obj1.dp = "Lamp/1/nvoLampFb"; // read
                    else if (g_oMap.mapDeviceGroupList[k].devices[z].programId === "900001153C000405")
                        obj1.dp = "device/0/nvoLamp2"; // read
                    obj1.cat = "out";
                    obj1.type = "SNVT_switch";
                    obj1.dpQualifier = g_oMap.mapDeviceGroupList[k].devices[z].scId + "/lon/" +  g_oMap.mapDeviceGroupList[k].devices[z].DID + "/" + obj1.dp;
                    obj1.dpRequest = g_oMap.mapDeviceGroupList[k].devices[z].name + "/if/" + obj1.dp;
                    obj1.value = null;
                    obj1.field = "value"; //"value/value";
                    obj1.g_oMap_mapDatapointsIndex = g_oMap.mapDatapoints.length;
                    g_oMap.mapDeviceGroupList[k].devices[z].datapointsList.push(JSON.parse(JSON.stringify(obj1)));
                    obj1.groupIndex = k;
                    obj1.groupDeviceIndex = z;
                    obj1.updateDpValue = false;
                    obj1.programId = g_oMap.mapDeviceGroupList[k].devices[z].programId;
                    obj1.bDevice = true;
                    obj1.bDashboard = false;
                    g_oMap.mapDatapoints.push(JSON.parse(JSON.stringify(obj1)));
                    obj1 = {};
                    obj1.deviceName = obj.name;
                    obj1.dp = "";
                    if(g_oMap.mapDeviceGroupList[k].devices[z].programId === "9FFFFF0501840460") // multisensor
                        obj1.dp = "Lamp/1/nviLamp"; // write
                    else if (g_oMap.mapDeviceGroupList[k].devices[z].programId === "900001153C000405") // pulsegen
                        obj1.dp = "device/0/nviLamp2"; // write
                    obj1.type = "SNVT_switch";
                    obj1.dpQualifier = g_oMap.mapDeviceGroupList[k].devices[z].scId + "/lon/" +  g_oMap.mapDeviceGroupList[k].devices[z].DID + "/" + obj1.dp;
                    obj1.dpRequest = g_oMap.mapDeviceGroupList[k].devices[z].name + "/if/" + obj1.dp;
                    obj1.cat = "in";
                    obj1.value = null;
                    obj1.field = "";
                    obj1.dpQualifier = "";
                    obj1.g_oMap_mapDatapointsIndex = null;
                    g_oMap.mapDeviceGroupList[k].devices[z].datapointsList.push(JSON.parse(JSON.stringify(obj1)));
                    g_oMap.numberOfLightDevices ++;
                }
            }
        }
    }
    catch {}
}
function mapCheckForMapDashboardDatapoints() {
    try {
        var i, j, z;
        for(i=0; i < g_oMap.dashboard.dpList.length; i++)
        {
            z = -1;
            for(j=0; j < g_oMap.mapDatapoints.length; j++)
            {
                if(g_oMap.mapDatapoints[j].dpQualifier === g_oMap.dashboard.dpList[i].dpQualifier) {
                    z = j;
                    break;
                }
            }
            if(z === -1) {
                obj1 = {};
                obj1.deviceName = g_oMap.dashboard.dpList[i].deviceTypeName;
                obj1.programId = g_oMap.dashboard.dpList[i].programId;
                obj1.dp = g_oMap.dashboard.dpList[i].blockPath;
                obj1.cat = "";
                obj1.type = "";
                obj1.dpQualifier = g_oMap.dashboard.dpList[i].dpQualifier; // g_oMap.dashboard.dpList[i].scId + "/lon/" +  g_oMap.dashboard.dpList[i].DID + "/" + g_oMap.dashboard.dpList[i].blockPath;
                obj1.dpRequest = g_oMap.dashboard.dpList[i].dpRequest; //obj1.deviceName + "/if/" + g_oMap.dashboard.dpList[i].blockPath;
                obj1.value = null;
                obj1.field = "";
                obj1.g_oMap_mapDatapointsIndex = g_oMap.mapDatapoints.length;
                obj1.groupIndex = -1;
                obj1.groupDeviceIndex = -1;
                obj1.updateDpValue = false;
                obj1.programId = g_oMap.dashboard.dpList[i].programId;
                obj1.bDevice = false;
                obj1.bDashboard = true;
                g_oMap.mapDatapoints.push(JSON.parse(JSON.stringify(obj1)));
                z = g_oMap.mapDatapoints.length - 1;
            }
            else {
                g_oMap.mapDatapoints[z].bDashboard = true;
            }
            g_oMap.dashboard.dpList[i].mapDatapointsIndex = z;
            
        }

        
    }
    catch {}

}
function mapCreateContextGroupList(json) {
    try {
        var i;
        if(json === null)
            return;
        
        for(i=0; i < json.children.length; i++)
        {
            if(json.contextType === "BUILDING") {
                // add new group
                mapCreateContextGroupListCreateBuildingGroup(JSON.parse(JSON.stringify(json.children[i])));
            }
            else {
                mapCreateContextGroupListRecursive(0, JSON.parse(JSON.stringify(json.children[i])));
            }
        }
    }
    catch {}
}
function mapCreateContextGroupListRecursive(level, json) {
    try {
        var i;
        level++;
        if(json === null)
            return;
        
        for(i=0; i < json.children.length; i++)
        {
            if(json.contextType === "BUILDING") {
                // add new group
                mapCreateContextGroupListCreateBuildingGroup(JSON.parse(JSON.stringify(json)));
            }
            else {
                mapCreateContextGroupListRecursive(level, JSON.parse(JSON.stringify(json.children[i])));
            }
        }
    }
    catch {}
}
function mapCreateContextGroupListCreateBuildingGroup(json) {
    try {
        var obj = {}, center;
        var z;
        if(json === null)
            return;
        obj.count = 0;
        obj.groupName = "group" + (g_oMap.mapDeviceGroupList.length - 1).toString();
        obj.groupType = "building"; // all devices in building 
        obj.groupContextName = json.name;
        obj.groupContextPath = json.path;
        obj.groupContextId = json.id; //used for buildings
        obj.lat = -1;
        obj.long = -1;
        center = mapDetermineCenterOfRegion(json.contextLocation);
        obj.lat = ((center.x2 - center.x1) / 2) + center.x1;
        obj.long = ((center.y2 - center.y1) / 2) + center.y1;
        obj.bAtLeastOneLightDevice = false;
        obj.sLayerGroupName = null; //only set to a name if a single device in group or only one device matches criteria (like up) in group
        obj.devices = [];
        g_oMap.mapDeviceGroupList.push(JSON.parse(JSON.stringify(obj)));
        z = g_oMap.mapDeviceGroupList.length - 1;
        //mapCreateContextGroupListCreateBuildingGroupAddDevices(z,JSON.parse(JSON.stringify(json.children[i])));
    }
    catch {}
}
function mapCreateContextGroupListCreateBuildingGroupAddDevices(index,json) {
    try {
        var i, obj1;
        if(z >= mapDeviceGroupList.length)
            return;
        for(i=0; i < json.devices; i++) {
            obj1 = {};
            obj1.name = g_oMap.mapDeviceList[i].name;
            obj1.id = g_oMap.mapDeviceList[i].id;
            obj1.status = g_oMap.mapDeviceList[i].status;
            obj1.DID = g_oMap.mapDeviceList[i].DID;
            obj1.programId = g_oMap.mapDeviceList[i].programId;
            obj1.scId = g_oMap.mapDeviceList[i].scId;
            obj1.category = g_oMap.mapDeviceList[i].category;
            obj1.deviceTypeName = g_oMap.mapDeviceList[i].deviceTypeName;
            obj1.bLightDevice = false;
            obj1.oLightDevice = null;
            obj1.datapointsList = [];
            obj1.groupIndex = g_oMap.mapDeviceGroupList.length;
            obj1.groupDeviceIndex = 0;
            g_oMap.mapDeviceGroupList[index].devices.push(obj1);
        }
        for(i=0; i < json.children.length; i++)
        {
            mapCreateContextGroupListCreateBuildingGroupAddDevices(index,JSON.parse(JSON.stringify(json.children[i])))
        }
    }
    catch {}
}
function mapDetermineCenterOfRegion(coords) {
    var centerCoord = {};
    var zoomLevel = 1;
    var x1 = 0, x2 = 0, y1 = 0, y2 = 0;
    try {
        centerCoord.lat = 0;
        centerCoord.long = 0;
        centerCoord.zoomLevel = 1;
        centerCoord.x1 = 0;
        centerCoord.x2 = 0;
        centerCoord.y1 = 0;
        centerCoord.y2 = 0;
        if(coords !== null) {
            
            centerCoord.lat = coords[0].lat; // lat
            centerCoord.long = coords[0].long; // lat
            x1 = centerCoord.lat;
            x2 = centerCoord.lat;
            y1 = centerCoord.long; //long
            y2 = centerCoord.long; // long
            for(i=0; i < coords.length; i++)
            {
                if(x1 > coords[i].lat)
                    x1 = coords[i].lat; // lat
                if(x2 < coords[i].lat)
                    x2 = coords[i].lat; // lat
                if(y1 > coords[i].long)
                    y1 = coords[i].long; // lat
                if(y2 < coords[i].long)
                    y2 = coords[i].long; // lat
            }
            centerCoord.lat = (x2 - x1) / 2 + x1;
            centerCoord.long = (y2 - y1) / 2 + y1;
            // determine max zoom level
            if(Math.abs(x2 - x1) > Math.abs(y2 - y1)) {
                zoomLevel = Math.abs(x2 - x1);
            }
            else {
                zoomLevel = Math.abs(y2 - y1);
            }
            centerCoord.x1 = x1;
            centerCoord.x2 = x2;
            centerCoord.y1 = y1;
            centerCoord.y2 = y2;
            //alert("CalZoom: " + zoomLevel);
            if((x1 === x2) && (y1 === y2))
                zoomLevel = 19;
            else if(zoomLevel > 100)
                zoomLevel = 4;
            else if(zoomLevel > 10)
                zoomLevel = 6;
            else if(zoomLevel > 1)
                zoomLevel = 8;
            else if(zoomLevel > .5)
                zoomLevel = 10;
            else if(zoomLevel > .1)
                zoomLevel = 11;
            else if(zoomLevel > .05)
                zoomLevel = 12;
            else if(zoomLevel > .01)
                zoomLevel = 13;
            else if(zoomLevel > .005)
                zoomLevel = 14;
            else if(zoomLevel > .001)
                zoomLevel = 16;
            else if(zoomLevel > .0005)
                zoomLevel = 17;
            else if(zoomLevel > .0001)
                zoomLevel = 18;
            else 
                zoomLevel = 18;
            centerCoord.zoomLevel = zoomLevel;
        }
    }
    catch (err) { centerCoord.lat = 0; centerCoord.long = 0; centerCoord.zoomLevel = 5;}
    return centerCoord;
}
function mapCreateDivContentSetOptions(mode,contextPath,bWorldOnly) {
    try {
        var element;var sParentPath = "";
        var sParentPath = "";
        /* delete no longer needed as leafletjs layercontrol is used
        try {
            if(g_oMapOptionsSetting.iShowDevicesMode === 0)
                document.getElementById("mapDeviceOptionAll").checked = true;
            else if(g_oMapOptionsSetting.iShowDevicesMode === 1)
                document.getElementById("mapDeviceOptionProvisioned").checked = true;
            else if(g_oMapOptionsSetting.iShowDevicesMode === 2)
                document.getElementById("mapDeviceOptionDown").checked = true;
            else if(g_oMapOptionsSetting.iShowDevicesMode === 3)
                document.getElementById("mapDeviceOptionLight").checked = true;
            else if(g_oMapOptionsSetting.iShowDevicesMode === 4)
                document.getElementById("mapDeviceOptionSpecified").checked = true;
            
        }
        catch {}
        if(contextPath !== "World")
            sParentPath = getParentPath(contextPath);
        element = document.getElementById("mapShowParentContextCheckbox");
        if(element !== null) {
            if((sParentPath === "") || (sParentPath === "World")) {
                element.disabled = true;
                element = document.getElementById("mapShowParentContextCheckboxSpan");
                if(element !== null)
                    element.style.color = "grey";
            }
            else
                element.checked = g_oMapOptionsSetting.bShowParentContext;
        }
        element = document.getElementById("mapShowContextCheckbox");
        if(element !== null) {
            if((sParentPath === "") && !bWorldOnly) {
                element.disabled = true;
                element = document.getElementById("mapShowContextCheckboxSpan");
                if(element !== null)
                    element.style.color = "grey";
            }
            else
                element.checked = g_oMapOptionsSetting.bShowContext;
        }
        element = document.getElementById("mapShowChildContextCheckbox");
        if(element !== null)
            element.checked = g_oMapOptionsSetting.bShowChildContexts;
        */
        element = document.getElementById("mapShowLatLongCheckbox");
        if(element !== null)
            element.checked = g_oMapOptionsSetting.bClickShowLatLong;
        element = document.getElementById("mapShowBuildingDevicesCheckbox");
        if(element !== null)
            element.checked = g_oMapOptionsSetting.bGroupBuildingDevices;
        
    }
    catch {}
}
function mapSendMapDivResize(width,height) {
    try {
        var element;
        const message = JSON.stringify({
            "action": "mapDivResize",
            "width": width,
            "height": height
        });
        element = document.getElementById("mapIframe");
        if(element !== null)
            element.contentWindow.postMessage(message, "*");
    }
    catch {}
}
function mapStartNextRequest() {
    try {
        var sTemp, url, timeDifference;
        if((g_iMainDisplayMode !== DISPLAYMODE_MAP) || !g_bMapView)
            return;
        if(g_idpGetRequestIndex !== -1) {
            if(g_dpGetRequestArr[0] !== "") {
                if(g_sWebSocketSubscribePayload === "")
                    return;
                if(g_sWebSocketSubscribePayload !== g_sWebSocketSubscribePayload_oldvalue)
                    subscribeRequest();
                sTemp = "value";
                
                if(g_idpGetRequestIndex === 0) {
                    if(g_iAutoSubscribeRate !== 0) {
                        g_iAutoSubscribeCount ++;
                        
                    }
                }
                if(g_iAutoSubscribeCount >= g_iAutoSubscribeRate) {
                    if(g_idpGetRequestIndex === g_iAutoSubscribeCountRequestIndex) // distributes subscribe so if there is more than one datapoint request that eventually all datapoints get read 
                        subscribeRequest();  
                }
                url = "https://" + location.host + "/iap/devs/*/if/*/*/*+qualifier=-";
                if(g_iMax_Age === -1) 
                    url += g_dpGetRequestArr[g_idpGetRequestIndex] + "/" + sTemp + "?&noxs=true";
                else 
                    url += g_dpGetRequestArr[g_idpGetRequestIndex] + "/" + sTemp + "?max_age=" + g_iMax_Age + "&noxs=true";			
                g_idpGetRequestIndex ++;
                g_iBackgroundPollingRequestCount = 0;
                if(g_idpGetRequestIndex >= g_dpGetRequestArr.length) {
                    g_iBackgroundPollingRequestCount = -1;
                    g_iPollingRequestCount = 0;
                    g_idpGetRequestIndex = 0;
                    
                    if(g_dpGetRequestArr.length > 1) {
                        g_dtPollGetRequestArrEndTime = new Date();
                        timeDifference = (g_dtPollGetRequestArrEndTime.getTime() - g_dtPollGetRequestArrStartTime.getTime()) / 1000;
                        if(timeDifference > g_iPollRate) 
                            g_iPollingRequestCount = g_iPollingRequestCountMax + 1; //startNextRequest(); // don't wait 
                        else {
                            g_iPollingRequestCount = Math.floor(timeDifference);
                        }
                    }
                }
                else {
                    if(g_idpGetRequestIndex == 1)
                        g_dtPollGetRequestArrStartTime = new Date();
                }
            }
        }
        requestGetData(0, url, mapStartNextRequestDpValuesResponse, mapStartNextRequestDpValuesResponse);
    }
    catch {}
}
function mapStartNextRequestDpValuesResponse(mode, url, json) {
    try {
        if((g_iMainDisplayMode !== DISPLAYMODE_MAP) || !g_bMapView)
            return;
        // don't do anything with the data
        if(ivbWsStartWebSocket) {
            if(bivUseWebSockets) {
                try {
                    // PC hibernates for longer than WebSocket timeout, then automatically try to reconnect a couple of times.
                    // If this is not implemented then use has to refresh the Web page
                    ivbWsStartWebSocket = false;
                    ivWebSocketInit();
                }
                catch {}
            }
        }
    }
    catch {}
}
function mapTimerHandler() {
	// pressing Ondemand button or at polling interval causes one or more GET requests depending on number of datapoints
	// Every Poll interval controlled by UI starts ondemand process to read all specified DPs, 
	//   - ondemand process can take multiple GET requests with a minimum delay of 2 seconds per request.
	//   - g_iPollingRequestCountMax controls delay between UI controlled polls
	//   - g_iBackgroundPollingRequestCountMax controls delay between GET requests
	 var request;
	 var d1;
	 var d = new Date();
	try {
        if((g_iMainDisplayMode !== DISPLAYMODE_MAP) || !g_bMapView)
            return;
		//if(g_bPauseMainTimer)
		//	return;  // used if can't create a WebSocket
		if(g_bInoreMouseClick)
			g_bInoreMouseClick = false;
		/*
		if(g_sUpdateDataPoint !== "") {
			
				// need to wait at least 1 second
			if(g_iUpdateDataPointCount > 1) {
				try {
					request = "https://" + location.host + "/iap/devs/*+name==";
					g_sUpdateDataPoint = addIfToPathname(g_sUpdateDataPoint);
					request += g_sUpdateDataPoint + "/*";
					requestGetData(2, request, getOnDemandDpPropertiesResponse, null);
				}
				catch {}
				g_sUpdateDataPoint = "";
				return;
			}
			else 
				g_iUpdateDataPointCount ++;
		} 
		*/
		if(true) { //(g_bPollingEnabled || (g_PollingType === DISPLAYMODE_ONETIMEPOLL)) {
			if(g_iBackgroundPollingRequestCount !== -1)
				g_iBackgroundPollingRequestCount ++;  // used for GET request rate 
			if(g_iPollingRequestCount !== -1)
				g_iPollingRequestCount ++; // used for background ondemamdn request controlled by poll rate
			if(requestInProgress !== 0)
			{	// needed for fast updates, otherwise user interface gets locked out
				requestInProgress ++;
				if(requestInProgress > 60)
						requestInProgress = 0;
					else
						return;
						
			}
			
			if(requestFailureDelayCount !=0)
			{
				requestFailureDelayCount ++;  // defined in main.c
				if(requestFailureDelayCount > requestFailureDelayCountMax)
					requestFailureDelayCount = 0;
			}
			if((requestInProgress === 0) && (requestFailureDelayCount === 0))
			{
				//if(g_bPollingEnabled) {
									
					if(g_iBackgroundPollingRequestCount !== -1) {
						// Each Ondemand request or background polling may require
						if((g_iBackgroundPollingRequestCount >= (g_iBackgroundPollingRequestCountMax + g_iBackgroundPollingRequestExtended))
								&& bivServerOnline) {
							g_iBackgroundPollingRequestCount = -1;
							mapStartNextRequest();
						}
					}
					else { //if(g_bPollingEnabled) {
						if(g_iPollingRequestCount !== -1) {
							if(g_iPollingRequestCount > g_iPollingRequestCountMax){
								g_iPollingRequestCount = 0; // next timer tick go get request
								mapStartNextRequest();
							}
						}  // used when ondemand DP request and there are more than 10 dps
					}
				//}
			}
		}
	} 
    catch (err) 
    {
        var error = err.toString();
    }
}

