/*	main.js

	This file provides the low level drivers used to access the IzoT SDK server.
	
	Uppercase functions are keep to support legacy web pages.


 *	Copyright (C) 2023 EnOcean GmbH.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	EnOcean Example Software License Agreement which is available at
 *	https://enoceanwiki.atlassian.net/wiki/spaces/LON/pages/2425260/Example+Software+License+Agreement. 



*/

var bWebPageExitSupported = false; // function needs to be in web page js file (e.g., dashboard)
var isIE = false; // Web Browser
var IEversion = 0;
var isSafari = false; 
var isFirefox = false;
var isChrome = false;
var isiPadiPhone = false;
var isiPad = false;
var isiPhone = false;
var isAndroid = false;
var is_touch_device = false;
var bAbortServerRequest = false;
var timerInterval = 1000;
var TimerId = 0;
var getJqxhr = null;  // used to abort Get Request
var bShowErrAlerts = true; 
var requestInProgress = 0; // used for long soap response time to make sure user interface doesn't get locked out 
var requestFailureCount = 0;  // must see at least two failure before reporting problem, 
var requestFailureCountMax = 0;				//  changing web pages causes request failure popup
var requestFailureDelayCount = 0;  // once a failure pop up occurs don't do another request for max seconds to 
var requestFailureDelayCountMax = 10;  // allow user to exit web page, other wise you get a continuous pop ups
var csrftoken;
var ingoreTableValueChangeFor = " "; // used for manually updating tables
var ingoreTableValueChangeForCurrentValue = " ";
var currentMessageLogPriority  = 0;
var bUseMessageLogForErrors = false;
var bCheckForTripleClick = false;


function init(){
	isiPadiPhone = /iphone|ipod|ipad/.test(window.navigator.userAgent.toLowerCase());
	isiPhone = /iphone/.test(window.navigator.userAgent.toLowerCase());
	isSafari = /safari/.test(window.navigator.userAgent.toLowerCase());
	is_touch_device = 'ontouchstart' in document.documentElement;
	isIE = /msie/.test(window.navigator.userAgent.toLowerCase());
	if(isIE) {
		IEversion = parseInt(window.navigator.userAgent.toLowerCase().split('msie')[1]);
	}
	else {
		isIE = (/trident\/7\./).test(window.navigator.userAgent.toLowerCase()); // needed for IE11
		if(!isIE) {
			isChrome = /chrome/.test(window.navigator.userAgent.toLowerCase());
			isFirefox = /Firefox/.test(window.navigator.userAgent.toLowerCase());
		}
	}
	window.onbeforeunload = (function() {
		ExitWebPage();
	});
	
	AddWifiTimeout();
	//$.ajaxSetup({ cache:false });	
	init1();
}
function convertIsoDateStringToDateObj(isoTimeStamp) {
	// required because IE9 and maybe IE10 new Date() can't process ISO timestamps
	var returnObj = null;
	if(isIE &&  (IEversion < 11)) {
		if(typeof isoTimeStamp === 'string') {
			var s = isoTimeStamp.split(/\D/);
			returnObj = new Date(Date.UTC(s[0], --s[1]||'', s[2]||'', s[3]||'', s[4]||'', s[5]||'', s[6]||''));
		}
		else {
			returnObj = isoTimeStamp;
		}
	}
	else {
  		returnObj = isoTimeStamp;
	}
	return returnObj;
}
function GotoWebPage(url) {
	gotoWebPage(url);
}
function gotoWebPage(url) {	
	if(url !== " ")
	{
		ExitWebPage();
		window.open(url,'_self',false);
	}
}
function GotoHelpWebPage(url) {	
	gotoHelpWebPage(url);	
}
function gotoHelpWebPage(url) {	
	// determine which hardware platform and then go to specific web page
	if(url !== " ")
	{
		var url1 = "/manual/#t=";
		url1 += "IzoT_Examples/Web_Pages/" +  url;
		var newWindow = window.open(url1,'_blank');
		newWindow.focus();
	}
}
function LoginWebPage(n) {
	loginWebPage(n);
}
function loginWebPage(n) {
	var value = document.getElementById("loginId").text; 
	LoginServer(value);
}
function LoginServer(value) {
	loginServer(value);
}
function loginServer(value) {
	if(value === " ")
		return;
	var url = 'https://' + location.host + '/user/';
	if(value === "Log out") {
		try {
			url = 'https://' + location.host + "/iap/auth/logout";
			requestPostFunction(0, url, "", null, null);
		}
		catch {}
		url = 'https://' + location.host + '/user/login.html?next=' + document.URL; 
		GotoWebPage(url);
	}
	else if(value === "Log in") {
		url = 'https://' + location.host + '/user/login.html?next=' + document.URL; 
		GotoWebPage(url);
	}

}
function AddLoginHtml(headerid,footerid) {
	addLoginHtml(headerid,footerid);
}
function addLoginHtml(headerid,footerid) {
	try {
		var id;
		var str = '<button type="button" id="loginId" style="float:right;';
		str += 'margin-right:30px;text-align:right;';
		if(isiPadiPhone) {
		}
		else
			str += 'margin-top:8px;';
		str += 'font-size:small;color:#ffffff;background-color:#366184;';
		str += 'border: none" onClick="LoginWebPage(\'loginId\')">Log out</button>';
		if(isiPadiPhone) {
			id = document.getElementById(footerid);
			if(id !== null) {  // jquery gives dummy data when id is not found
				id.insertAdjacentElement("beforeend", str);
			}

		}
		else {
			id = document.getElementById(headerid);
			if(id !== null) {  // jquery gives dummy data when id is not found
				id.insertAdjacentElement("beforeend", str);
			}

		}
	}
	catch (err) {}

}
function ExitWebPage () {
	return exitWebPage ();
}
function exitWebPage () {
	try { 
		// webPageExit - defined in web page specific file.  Used to do anything special for the web page.
		//  for example, the colorpicker needs to reset color values.
		if(bWebPageExitSupported) {
			if(WebPageExit())
				return;
		}
	} catch (err) {}
	bUseMessageLogForErrors = false;
	bAbortServerRequest = true;
	bShowErrAlerts = false;
	try {
		if(TimerId !== 0)
			clearTimeout(TimerId);
	} catch (err) {}
	try {
		if(getJqxhr !== null) {
			if(getJqxhr !== 0)
				getJqxhr.abort(); // abort any outstanding Get request
		}
	} catch (err) {}

}
function AddWifiTimeout() {
	addWifiTimeout();
}
function addWifiTimeout() {
	try {
			if(isiPadiPhone) {
				$.ajaxSetup({
				//  Wifi requires longer timeout
					timeout: 30000
				});
				

			}
	} catch (err) {}
}
function ClearWebPageElementsSelection() {
	clearWebPageElementsSelection();
}
function clearWebPageElementsSelection() {
	if(window.getSelection)
	{
		bCheckForTripleClick = true;
		if(window.getSelection().empty)
			window.getSelection().empty(); // chrome
		else if(window.getSelection().removeAllRanges)
			window.getSelection().removeAllRanges(); // firefox
	}
	else if (document.selection)
		document.selection.empty();  // IE?
}
function make_base_auth(user, password) {
		var tok = user + ':' + password;
		var hash = btoa(tok);
		return "Basic " + hash;
}
function RequestGetData(mode, requestUrlString, callback) {
	requestGetData(mode, requestUrlString, callback, null);
}
function requestGetData(mode, requestUrlString, callback, failCallback) {
	try {
			
		if(bAbortServerRequest)
			return;
		requestInProgress = 1;

		var bNoPagination = true;
		if(requestUrlString.includes("&sz="))
			bNoPagination = false;
		
		var xhr = new XMLHttpRequest();
		xhr.onreadystatechange = function() {
			if (xhr.readyState === 4 && xhr.status === 200) {
				// success
				if(bNoPagination)
					requestInProgress = 0;
				requestFailureCount = 0;
				if(bUseMessageLogForErrors) {
					try {
						if(currentMessageLogPriority !== 0)
							logErrorMessage (0, " "); // clear log
					} catch (err) {}
				}
				var json = null;
				if(this.responseText !== "") {
					try {
						json = this.responseText;
						if((json.charAt(0) === "[") || (json.charAt(0) === "{"))
							json = JSON.parse(json); 
					}
					catch {
						json = null;
					}
				}
				if(callback && typeof(callback) === "function") {
					callback(mode, requestUrlString,  json);
				}
			}
			else if(xhr.readyState === 4 && xhr.status === 401)
			{  // not logged in
				requestInProgress = 0;
				requestFailureCount ++;
				//alert(xhr.status + ", " + xhr.statusText); 
				loginServer("Log in");

			}
			else if(xhr.readyState === 4 && xhr.status === 404)
			{ // not found
				requestInProgress = 0;
				requestFailureCount ++;
				if(requestFailureCount > requestFailureCountMax) {
					requestFailureCount = 0;
					requestFailureDelayCount ++;
					if(bUseMessageLogForErrors) {
						try {
							logErrorMessage (2, "Error: " + xhr.readyState + ", " + requestUrlString);
						}
						catch(e) {}
					}
				}
				if(failCallback && typeof(failCallback) === "function") {
					failCallback(mode, requestUrlString,  xhr.status);
				}
			}
			else if(xhr.readyState === 4)
			{
				requestInProgress = 0;
				requestFailureCount ++;
				if(requestFailureCount > requestFailureCountMax) {
					requestFailureCount = 0;
					requestFailureDelayCount ++;
					if(bUseMessageLogForErrors) {
						try {
							logErrorMessage (2, "Error: " + xhr.readyState + ", " + requestUrlString);
						}
						catch(e) {}
					}
				}
				if(failCallback && typeof(failCallback) === "function") {
					failCallback(mode, requestUrlString, xhr.status);
				}
			}					
		};
		xhr.open("GET", requestUrlString, true);
		xhr.send();
	}
	catch(err) {
		if(failCallback && typeof(failCallback) === "function") {
			failCallback(mode, requestUrlString, err);
		}
		else {
			if(bShowErrAlerts)
				alert(location.href + "Get request failure: " + requestUrlString + ", " + err);
		}
		requestInProgress = 0;
		ingoreTableValueChangeFor = " ";
		ingoreTableValueChangeForCurrentValue = " ";
	}
}
function RequestPutData(mode, requestUrlString, requestDataString, callback) {
	requestPutData(mode, requestUrlString, requestDataString, callback, null);
}
function requestPutData(mode, requestUrlString, payload, callback, failCallback) {
		// mode: only used by this function,
		
		try {
			var obj;
			var xhr = new XMLHttpRequest();
  			xhr.onreadystatechange = function() {
    			if (xhr.readyState === 4 && ((xhr.status === 200) || (xhr.status === 204))) {
					// Write successful
					
					ingoreTableValueChangeFor = " ";
					ingoreTableValueChangeForCurrentValue = " ";
					if(callback && typeof(callback) === "function") {
						callback(mode, requestUrlString);
					}
    			}
				else if(xhr.readyState === 4 && xhr.status === 401)
				{
					login();
				}
				else if(xhr.readyState === 4)
				{
					ingoreTableValueChangeFor = " ";
					ingoreTableValueChangeForCurrentValue = " ";
					requestFailureCount ++;
					if(requestFailureCount > requestFailureCountMax) {
						requestFailureCount = 0;
						requestFailureDelayCount ++;
					
						
					}
					if(failCallback && typeof(failCallback) === "function") {
						obj = {}
						obj.status = xhr.status;
						obj.response = xhr.response;
						//obj.payload = payload;
						failCallback(mode, requestUrlString, payload, obj);
					}
				}
  			};
  			xhr.open("PUT", requestUrlString, true);
			xhr.setRequestHeader('Content-type','application/json; charset=utf-8');
			xhr.send(payload);
		
		}
		catch(err) {
			if(failCallback && typeof(failCallback) === "function") {
				failCallback(mode, requestUrlString, requestDataString, err);
			}
			else if(!bUseMessageLogForErrors) {
				if(bShowErrAlerts)
					alert("PUT request failure: " + err);
			}
			requestInProgress = 0;
			ingoreTableValueChangeFor = " ";
			ingoreTableValueChangeForCurrentValue = " ";
		}
}
function RequestPostFunction(mode, requestUrlString, requestDataString, callback) {
	requestPostFunction(mode, requestUrlString, requestDataString, callback, null);
} 
function requestPostFunction(mode, requestUrlString, payload, callback, failCallback) {
		// mode: only used by this function,
		
		try {
			var obj;
			var xhr = new XMLHttpRequest();
  				xhr.onreadystatechange = function() {
    				if (xhr.readyState === 4 && xhr.status === 204) {
						// Write successful
						
						ingoreTableValueChangeFor = " ";
						ingoreTableValueChangeForCurrentValue = " ";
						if(callback && typeof(callback) === "function") {
							callback(mode, requestUrlString);
						}
					}
					else if (xhr.readyState === 4 && xhr.status === 200) {
						// Write successful -- has payload
						  
						  ingoreTableValueChangeFor = " ";
						  ingoreTableValueChangeForCurrentValue = " ";
						  if(callback && typeof(callback) === "function") {
								if(mode === 1) {
									if(this.responseText !== "") {
										//json = JSON.parse(this.responseText); 
										callback(mode, requestUrlString, this.responseText);
									}
									else 
										callback(mode, requestUrlString,  xhr.response);
								}
						  }
					}
					else if(xhr.readyState === 4 && xhr.status === 401)
					{
						login();
					}
					else if(xhr.readyState === 4)
					{
						ingoreTableValueChangeFor = " ";
						ingoreTableValueChangeForCurrentValue = " ";
						requestFailureCount ++;
						if(requestFailureCount > requestFailureCountMax) {
							requestFailureCount = 0;
							requestFailureDelayCount ++;
					
							
						}
						if(failCallback && typeof(failCallback) === "function") {
							obj = {}
							obj.status = xhr.status;
							obj.response = xhr.response;
							failCallback(mode, requestUrlString, obj);
						}
					}
  				};
  				xhr.open("POST", requestUrlString, true);
				xhr.setRequestHeader('Content-type','application/json; charset=utf-8');
 				xhr.send(payload);
			
			
		}
		catch(err) {
			if(failCallback && typeof(failCallback) === "function") {
				failCallback(mode, requestUrlString, requestDataString, err);
			}
			else if(!bUseMessageLogForErrors) {
				if(bShowErrAlerts)
					alert("POST request failure: " + err);
			}
			requestInProgress = 0;
			ingoreTableValueChangeFor = " ";
			ingoreTableValueChangeForCurrentValue = " ";
		}
}
function RequestDeleteFunction(mode, requestUrlString, payload, callback) {
	requestDeleteFunction(mode, requestUrlString,  payload, callback, null);
}
function requestDeleteFunction(mode, requestUrlString,  payload, callback, failCallback) {
		// mode: only used by this function,
		
	try {
		var xhr = new XMLHttpRequest();
		xhr.onreadystatechange = function() {
			if (xhr.readyState === 4 && xhr.status === 204) {
			  // Write successful
				if(bUseMessageLogForErrors) {
					try {
						if(currentMessageLogPriority !== 0)
							logErrorMessage (0, " "); // clear log
					} catch (err) {}
				}	
				ingoreTableValueChangeFor = " ";
				ingoreTableValueChangeForCurrentValue = " ";
				if(callback && typeof(callback) === "function") {
					  callback(mode, requestUrlString);
				}
			}
			else if(xhr.readyState === 4 && xhr.status === 401)
			{
				login();
			}
			else if(xhr.readyState === 4)
			{
				ingoreTableValueChangeFor = " ";
				ingoreTableValueChangeForCurrentValue = " ";
				requestFailureCount ++;
				if(requestFailureCount > requestFailureCountMax) {
					requestFailureCount = 0;
					requestFailureDelayCount ++;
			
					if(bUseMessageLogForErrors) {
						try {
							 logErrorMessage (2, "Error: " + xhr.readyState + ", " + requestUrlString); 
						} 
						catch (err) {}
					}
				}
				if(failCallback && typeof(failCallback) === "function") {
				  failCallback(mode, requestUrlString, xhr.status);
				}
			}
		};
		xhr.open("DELETE", requestUrlString, true);
		xhr.setRequestHeader('Content-type','application/json; charset=utf-8');
 		xhr.send();
		
	}
	catch(err) {
		if(failCallback && typeof(failCallback) === "function") {
			failCallback(mode, requestUrlString, err);
		}
		if(!bUseMessageLogForErrors) {
			if(bShowErrAlerts)
				alert("POST request failure: " + err);
		}
		requestInProgress = 0;
		ingoreTableValueChangeFor = " ";
		ingoreTableValueChangeForCurrentValue = " ";
	}
}

function AddCsrfTokenToAjaxRequest()  {
	// no longer used but some legacy web pages may still have it 
}
function GetCsrfTokenForAjaxRequest(getJqxhr1) {
	getCsrfTokenForAjaxRequest(getJqxhr1);
}
function getCsrfTokenForAjaxRequest(getJqxhr1) {
		if(csrftoken === null)
		{
			csrftoken = "";
			var str = getJqxhr1.getAllResponseHeaders();
			var iPtr = str.indexOf("IzoTServer");
			if(iPtr > 0) {
				iPtr = str.indexOf("(",iPtr);
				if(iPtr > 0) {
					var iPtr1 = str.indexOf(")",iPtr);
					if(iPtr1 > 0) {
						csrftoken = str.substr(iPtr + 1, iPtr1 - iPtr - 1);
						//alert("csrftoken:" + csrftoken);
								
								
					}
				}
			}
				
			csrftoken = getCookie("csrftoken-" + csrftoken);
			//alert(document.cookie + ", " + csrftoken);
			$.ajaxSetup({
				// *** FIX -- need additional code to check if URL is a same-origin URL
				beforeSend: function(xhr) {
					xhr.setRequestHeader("X-CSRFToken", csrftoken);
				}
			});
		}
}
function getCookie(name)
{
	var cookieValue = null;
		
	if(document.cookie && (document.cookie !== ''))
	{
		var cookies = document.cookie.split(';');
		for (var i=0; i < cookies.length; i ++)
		{
			var cookie = jQuery.trim(cookies[i]);
			if(cookie.substring(0, name.length + 1) === (name + '='))
			{
				cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
				break;
			}
		}
	}
	return cookieValue;
}
function JsonToString(json, iTabs) {
	return jsonToString(json, iTabs);
}
function jsonToString(json, iTabs){
		try {
			var result = "";

			if($.isArray(json))
			{
				iTabs ++;
				for(var i=0;i<json.length;i++){
					result += "\r\n";
        				var obj = json[i];
	        			for(var key in obj){
        	    				var attrName = key;
	        				var attrValue = obj[key];
						result += "\r\n";
						for(var j=0; j < iTabs; j++)
						{
							result += "\t";
						}
						result += attrName + ": ";
						if(attrValue !== null)
						{
							if ((typeof attrValue === 'string') || (typeof attrValue === 'number')
								|| (typeof attrValue === 'boolean'))
							{
								result += attrValue;
							}
							else
							{
								result +=  JsonToString(attrValue, iTabs);
							}
						}
						//result += "\r\n" + attrName + ": " + attrValue;
					}
				}				
	        	}
			else if ((typeof json === 'string') || (typeof json === 'number')
				|| (typeof json === 'boolean'))
			{
				result += json;
			}
			else if ((json !== null) && (typeof json === 'object'))
			{	// object
					
				
				
				for(var key in json){
        	    			var attrName = key;
	            			var attrValue = json[key];
					result += "\r\n" + attrName + ": " + attrValue;
				}
			}
		}
		catch(err) {}
		return result;

}
function validateInputString(modestr, bWarnUserOnError, textStr , min, max) {
		var bValid = false;
		var value;
		// mode: 0=int, 1=float
		try {
			switch (modestr)
			{
				case "int": value = parseInt(textStr); 
					if((value >= min) && (value <= max))
						bValid = true;
					break;
				case "float": value = parsefloat(textStr); 
					if((value >= min) && (value <= max))
						bValid = true;
					break;
				default: break;
			}

		}
		catch (err) 
		{
			
		}
		if(!bValid && bWarnUserOnError) {
			var msg ='Error: Invalid input - please enter using correct types';
			msg += '\r\n\r\nInput = ' + textStr + '\r\n\r\nValid entry: ';
			if(modestr === "int")
				msg += "integer number (0-9)";
			else if(modestr === "float")
				msg += "float number (1, 1.0)";
			msg += ', between \"' + min  + '\" and \"' + max + '\"';
			alert(msg);
		}
		return bValid
		
}
function SortJsonObject(type, serverDevicesOnTop, sortOrder, json) {
		sortJsonObject(type, serverDevicesOnTop, sortOrder, json, null, null);
}
function sortJsonObject(type, serverDevicesOnTop, sortOrder, json, sortText, sortText2, sortText3, sortText4) {
	// up to 3 levels of sorting
	// type - 0 = device, 1 = datapoints, 2 = use sortText
	// serverDevicesOnTop - true - put server host device on Top
	// 			- false - sort above as normal devices
	// sortOrder: 0=ascend a-z, 1 = descend z-a
	// sortText2: if !== null then do second sort on sortText2
	if(json === null)
		return json;
	if($.isArray(json)) {
		if(json.length === 1)
			return json;
	}
	else if(typeof json === 'object')
		return json;
	var count = json.length;
	
	var obj, name, deviceType, oldObj, oldSortText, count1;
	
	var resultArray = json;
	var count = json.length;
	var bSecSort = false;
	var bThirdSort = false;
	var bForthSort = false;
	var bSwap = false;
	
	
	try {
		if(type === 2) {
			if(sortText === null)
				return json;
			else if(sortText.length !== count)
				return json;
			if(sortText2 !== null)
				bSecSort = true;
			if(sortText3 !== null)
				bThirdSort = true;
			if(sortText4 !== null)
				bForthSort = true;
		}
		else {  // type = 0 or 1
			sortText = new Array();
			// create sortText
			for(var i=0;i<json.length;i++){
				obj = json[i];
				name = obj.name;
				oldSortText = "";
				if((type === 0) && serverDevicesOnTop) {
					deviceType = obj.type;
					if(deviceType === "host") {
						oldSortText = "   ";
					}
				}
				if(type === 0) {
					oldSortText += name + obj.uid;
				}
				else
					oldSortText += name;
				sortText[i] = oldSortText.toUpperCase();
			}
				
		}
		var noChanges = false;
		var offset = 0; //parseInt((count / 2), 10);
		for(var k=0;k< (count - 1);i++){
			noChanges = true;
			
			for(var i=0;i< (count - 1);i++){
				bSwap = false;
				if(((sortOrder === 0) && (sortText[i] > sortText[i + 1])) 
					|| ((sortOrder === 1) && (sortText[i + 1] > sortText[i]))) {
					bSwap = true;
				}
				else if (bSecSort && (sortText[i] === sortText[i + 1])) {
					try {
						if(((sortOrder === 0) && (sortText2[i] > sortText2[i + 1])) 
							|| ((sortOrder === 1) && (sortText2[i + 1] > sortText2[i]))) {
							bSwap = true;
						}
						else if (bThirdSort && (sortText2[i] === sortText2[i + 1])) {
							try {
								if(((sortOrder === 0) && (sortText3[i] > sortText3[i + 1])) 
									|| ((sortOrder === 1) && (sortText3[i + 1] > sortText3[i]))) {
									bSwap = true;
								}
								else if (bThirdSort && (sortText3[i] === sortText3[i + 1])) {
									try {
										if(((sortOrder === 0) && (sortText4[i] > sortText4[i + 1])) 
											|| ((sortOrder === 1) && (sortText4[i + 1] > sortText4[i]))) {
											bSwap = true;
										}
									}
									catch (err) {}
								}
							}
							catch (err) {}
						}
					}
					catch (err) {}

				}
				if(bSwap) {
					noChanges = false;
					oldObj = resultArray[i];
					resultArray[i] = resultArray[i +  1];
					resultArray[i + 1] = oldObj;
					oldSortText = sortText[i];
					sortText[i] = sortText[i + 1];
					sortText[i + 1] = oldSortText;
					if(bSecSort) {
						oldSortText = sortText2[i];
						sortText2[i] = sortText2[i + 1];
						sortText2[i + 1] = oldSortText;
					}
					if(bThirdSort) {
						oldSortText = sortText3[i];
						sortText3[i] = sortText3[i + 1];
						sortText3[i + 1] = oldSortText;
					}
					if(bForthSort) {
						oldSortText = sortText4[i];
						sortText4[i] = sortText4[i + 1];
						sortText4[i + 1] = oldSortText;
					}
						
				}
				
			}
			if(noChanges)
				break;
		}
	}
	catch (err) {};
	return resultArray;
} 