/*************************************************************************************************
 *  elementresizer.js
 * 
 * 	This file contains code that can be used to resize a div or table column. A div is added to the 
 *  parent element (div or table column) which is used to show the resize icon when hovering over the
 *  border.  
 * 
 *  Since mouse events are used in other parts of the code, these events need to ignore the false event
 *  due to the resize mouse events. The following two flags are used to ignore the false events.
 *  g_bMouseTreeRightResizeActive	
 *  g_bMouseTreeBottomResizeActive
 * 
 *	Copyright (C) 2023 EnOcean GmbH.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	EnOcean Example Software License Agreement which is available at
 *	https://enoceanwiki.atlassian.net/wiki/spaces/LON/pages/2425260/Example+Software+License+Agreement. 
 * 
 ***************************************************************************************************/
let g_resizeX = 0; // The current position of mouse
let g_resizey = 0; // The current position of mouse

let g_resizeW = 0; // The dimension of the element
let g_resizeH = 0; // The dimension of the element
let g_resizeNavTreeMinW = 100;
let g_resizeMinW = 0; // Used for Tables
let g_bMouseTreeRightResizeActive = false; // used in other code files to detect resize mouse events
let g_bMouseTreeBottomResizeActive = false; // used in other code files to detect resize mouse events
let g_sTableResizeCol = "";
let g_iTableResizeColIndex = -1;
let g_bTableResizeColSetMaxWidth = false;

/*******************************************************
 * 
 * 
 */
function mouseDownTreeResizeRightHandler(e) {
    mouseDownTreeResizeHandler(0, e)
}
function mouseDownTreeResizeBottomHandler(e) {
    mouseDownTreeResizeHandler(1, e)
}
function mouseDownTreeResizeHandler(mode, e) {
    var styles;
    var element
    // Get the current mouse position
    g_resizeX = e.pageX;//e.clientX;
    g_resizeY = e.pageY;//e.clientY;
    g_bMouseResizeActive = true;
    // Calculate the dimension of element
    element = document.getElementById("treeDivTree");
    if(element !== null) {
        styles = window.getComputedStyle(element);
        g_resizeW = parseInt(styles.width, 10);
        g_resizeH = parseInt(styles.height, 10);
        if(mode === 0) { // right
            element = document.getElementById("treeDivResizeRightDiv");
            g_bMouseTreeRightResizeActive = true;
            if(element !== null) {
                document.addEventListener('mousemove', mouseMoveTreeRightResizeHandler);
                document.addEventListener('mouseup', mouseUpTreeRightResizeHandler);
            }
        }
        else { // bottom
            element = document.getElementById("treeDivResizeBottomDiv");
            g_bMouseTreeBottomResizeActive = true;
            if(element !== null) {
                document.addEventListener('mousemove', mouseMoveTreeBottomResizeHandler);
                document.addEventListener('mouseup', mouseUpTreeBottomResizeHandler);
            }
        }
        // Attach the listeners to `document`
        
    }
}
function mouseMoveTreeRightResizeHandler(e) {
    // How far the mouse has been moved
    var dx = e.pageX - g_resizeX;
    var dx1 = 10;
    var sx = 0;
    var element = document.getElementById("treeDivTree");
    var element1 = document.getElementById("treeDivTreeResize");
    if((element !== null) && (element1 !== null)) {
        if(element.scrollWidth > element.clientWidth);// take into account scroll bars
            sx = 5;
        if((g_resizeW + dx) < g_resizeNavTreeMinW) {
            element.style.width = (g_resizeNavTreeMinW).toString() + "px";
            element1.style.width = (g_resizeNavTreeMinW + dx1 + sx).toString() + "px";
        }
        else {
            element.style.width = (g_resizeW + dx).toString() + "px";
            element1.style.width = (g_resizeW + dx + dx1 + sx).toString() + "px";
        }
        
        
        document.getSelection().removeAllRanges();
    }
}
function mouseMoveTreeBottomResizeHandler(e) {
    // How far the mouse has been moved
    var dy = e.pageY - g_resizeY;
    var element = document.getElementById("treeDivTree");
    if(element !== null) {
        
        element.style.height = (g_resizeH + dy).toString() + "px";
        document.getSelection().removeAllRanges();
    }
}

function mouseUpTreeRightResizeHandler() {
    // Remove the handlers of `mousemove` and `mouseup`
    var element;
    if(g_bMouseTreeRightResizeActive) {
        g_bMouseTreeRightResizeActive = false;
        element = document.getElementById("treeDivResizeRightDiv");
        if(element !== null) {
            document.removeEventListener('mousemove', mouseMoveTreeRightResizeHandler);
            document.removeEventListener('mouseup', mouseUpTreeRightResizeHandler);
            document.getSelection().removeAllRanges();
        }
    }
    
}
function mouseUpTreeBottomResizeHandler() {
    // Remove the handlers of `mousemove` and `mouseup`
    var element;
    if(g_bMouseTreeBottomResizeActive) {
        g_bMouseTreeBottomResizeActive = false;
        element = document.getElementById("treeDivResizeBottomDiv");
        if(element !== null) {
            document.removeEventListener('mousemove', mouseMoveTreeBottomResizeHandler);
            document.removeEventListener('mouseup', mouseUpTreeBottomResizeHandler);
            document.getSelection().removeAllRanges();
        }
    }
}
function mouseDownTableResizeHandler(e, index, bSomeWithMaxWidthSpecified) {
    // bSomeWithMaxWidthSpecified: Structured datapoints may require max-width specified using tdValue class
    var styles;
    var element, table, i, j, row, cell; 
    var errStr;
    // Get the current mouse position
    
    g_resizeX = e.clientX;//e.clientX;
    g_iTableResizeColIndex = -1;
    g_sTableResizeCol = "tableCol_" + index;
    g_resizeMinW = -1;
    try {
        element = document.getElementById(g_sTableResizeCol);
        if(element !== null) {
            if(bSomeWithMaxWidthSpecified) {
                table = document.getElementById("myTable");
                if(table !== null) {
                    for(i=0; i < table.rows.length; i++)
                    {
                        row = table.rows[i];
                        cell = row.cells[index];
                        // check if class with max width specified
                        if(cell.className === "tdValue") {
                            g_bTableResizeColSetMaxWidth = true;  // structured dp so maxwidth specified
                            styles = window.getComputedStyle(cell);
                            g_resizeW = parseInt(styles.maxWidth, 10);
                            g_resizeMinW = parseInt(styles.minWidth, 10);
                            break;
                        }
                    
                    }
                    if(g_bTableResizeColSetMaxWidth)
                        g_iTableResizeColIndex = index;
                    
                }
            }
            styles = window.getComputedStyle(element.parentElement);
            if(!g_bTableResizeColSetMaxWidth)
                g_resizeW = parseInt(styles.width, 10);
            document.addEventListener('mousemove', mouseMoveTableResizeHandler);
            document.addEventListener('mouseup', mouseUpTableResizeHandler);
            g_bMouseTableResizeActive = true;
            
        }
        else 
            g_sTableResizeCol = "";
    }
    catch (err) {
        errStr = err.toString();
    }
}
function mouseMoveTableResizeHandler(e) {
    // How far the mouse has been moved
    var dx = e.clientX - g_resizeX;
    var errStr;
    var element;
    try {
        if(g_sTableResizeCol) {
            
            element = document.getElementById(g_sTableResizeCol);
            if(element !== null) {
                if(g_bTableResizeColSetMaxWidth && (g_iTableResizeColIndex !== -1)) {
                    if(g_resizeMinW !== -1) {
                        if((g_resizeW + dx) <= g_resizeMinW)
                            return;
                    }
                    table = document.getElementById("myTable");
                    if(table !== null) {
                        for(i=0; i < table.rows.length; i++)
                        {
                            row = table.rows[i];
                            cell = row.cells[g_iTableResizeColIndex];
                            // check if class with max width specified
                            if(cell.className === "tdValue") {
                                cell.style.maxWidth = (g_resizeW + dx).toString() + "px";
                                cell.style.width = (g_resizeW + dx).toString() + "px";
                            }
                        }
                    }
                }
                element.parentElement.style.width = (g_resizeW + dx).toString() + "px";
                document.getSelection().removeAllRanges();
            }
        }
    }
    catch (err) {
        errStr = err.toString();
    }
}

function mouseUpTableResizeHandler() {
    document.removeEventListener('mousemove',mouseMoveTableResizeHandler);
    document.removeEventListener('mouseup', mouseUpTableResizeHandler);
    document.getSelection().removeAllRanges();
    g_sTableResizeCol = "";
    g_bTableResizeColSetMaxWidth = false;
    g_iTableResizeColIndex = -1;
    setTimeout(mouseTableResizeClearActiveTimerHandler, 150)
}
function mouseTableResizeClearActiveTimerHandler() {
    g_bMouseTableResizeActive = false;
    
}
