/********************************************************************
 *  Built-in functions don't change
 *
 * 	Copyright (C) 2023 EnOcean GmbH.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	EnOcean Example Software License Agreement which is available at
 *	https://enoceanwiki.atlassian.net/wiki/spaces/LON/pages/2425260/Example+Software+License+Agreement. 
 *******************************************************************/
var g_oGlobalTags = {};
function addDeviceTypeWebPage(sid, deviceType, url, width, height) {
    // used for replacement web page shown in iframe
    try {
        if((deviceType === null) || (url === null) || (width === null) || (height === null))
            return;
        var obj = {};
        obj.sid = sid;
        obj.deviceTypeName = deviceType;
        obj.url = url;
        obj.width = width;
        obj.height = height;
        g_deviceTypesReplacementsDeviceType.push(obj);
    }
    catch {}
}
function addProgramIdWebPage(sid, programId, allVersions, url, width, height) {
    // used for replacement web page shown in iframe
    try {
        if((programId === null) || (url === null) || (width === null) || (height === null))
            return;
        var obj = {};
        obj.sid = sid;
        obj.programId = programId;
        obj.allVersions = allVersions
        obj.url = url;
        obj.width = width;
        obj.height = height;
        g_deviceTypesReplacementsProgramId.push(obj);
    }
    catch {}
}
function addDeviceDpList(sid, deviceName, dpList, image, width, height) {
    try {
        addTypeToDeviceTypeDpList(sid, "d", deviceName, dpList, image, width, height);
    }
    catch {}
   
}
function addDeviceTypeProgramIdDpList(sid, programId, dpList, image, width, height) {
    try {
        addTypeToDeviceTypeDpList(sid, "p", programId, dpList, image, width, height);
    }
    catch {}
   
}
function addDeviceTypeDpList(sid, deviceType, dpList, image, width, height) {
    try {
        addTypeToDeviceTypeDpList(sid, "dt", deviceType, dpList, image, width, height);
    }
    catch {}
}
function addTypeToDeviceTypeDpList(sid, type, name, dpList, image, width, height) {
    // type: "dt" = device type, "d" = device name, "p" = program Id
    try {
        var i;
        var obj = {};
        obj.sid = sid;
        obj.type = type
        obj.name = name;
        //obj.deviceTypeName = deviceType;
        obj.image = image;
        obj.width = width;
        obj.height = height;

        obj.dpList = [];
        if(dpList !== null) {
            for(i=0; i < dpList.length; i++){
                if(typeof dpList[i] !== "object")
                    dpList[i] = addDpObj(dpList[i]);
                dpList[i].blockPath = dpList[i].blockPath.trim().toLowerCase();
            }
            obj.dpList = dpList;
        }
        g_deviceTypesReplacementsDpList.push(obj);
    }
    catch {}
}
function addSmartServerImage(sid, image, width, height) {
    g_smartServerImage = image;
    g_smartServerImageWidth = width;
    g_smartServerImageHeight = height;
}
function addDpObj(blockPath) {
    return addDpObjAll(null, blockPath, null, null, null, null, null, null);  
}
function addDpObjAll(sid, blockPath, displayElementType, userVisibility, userReadtonly, normalUserWritePriority,normalUserClearPriority, units) {
    //displayElementType: c=chart, d=dropdown (only if datapoint has presets, enums are automatically "d"), d1=dropdown use dropdownList
    //          s1= slider, s2 = slider switch (binary), s3 = slider switch (SNVT_switch), s4 = slider switch (SNVT_switch 0 0 or 1 100 only), 
    //          l2 = led, l3 = led (SNVT_switch, led for state, span for value), l4 = LED SNVT_switch state only
    var items, i;
    var obj = {}
    obj.sid = sid;
    obj.blockPath = blockPath;
    obj.field = "";
    obj.fieldPath = "";
    obj.units = "";
    if(units !== null)
        obj.units = units;

    
    
    items = blockPath.split("/");
    if(items.length > 3) {
        obj.blockPath = items[0].trim(); + "/" + items[1].trim() + "/" + items[2].trim();
        
        for(i=0; i < items.length; i++)
        {
            items[i] = items[i].trim();
            if(i > 3) {
                if(obj.field !== "")
                    obj.field += "/";
                obj.field += items[i];
            }
            if(obj.fieldPath !== "")
                obj.fieldPath += "/";
            obj.fieldPath += items[i];
            
        }
    }
    if(userVisibility === null)
        userVisibility = 0;
    if(userReadtonly === null)
        userReadtonly = 0;
    obj.visibility = userVisibility; // null or 0=all, 1=owner only, 2=owner + supervisor, 3=user only
    obj.userReadonly = userReadtonly; // applies to inputs only, null or 0=writable, 1=user only, 2=user + supervisor, 3=readable only
    obj.dashboardType = displayElementType; 
    obj.UserTypeWritePriority = normalUserWritePriority; // only applies to the user user-type, doesn't apply to owner or supervisor
    obj.userClearPriority = normalUserClearPriority
    obj.dropdownList = [];

    // additional required for site dashboard and device dashboard 
    obj.label = "";
    obj.contextDisplayType = "";
	obj.contexts = "";
    obj.color = "";
	obj.backgroundColor = "";
    obj.precision = -1;
	obj.graphicType = 0; // used with l2 and l4 to show different size dots
	obj.x = ""; // used for Dashboard positioning
	obj.y = ""; // Used for Dashboard positioning
    obj.width = "";
	obj.height = "";
	obj.padding = "";
	obj.paddingChar = "";
	obj.alarmType = "";
	obj.siteDashboard = false; // used to specify point is used for site dashboard
	obj.guageObj = null;
	obj.layout = null; // used specify where UI element is shown, c,r,e,x,y  e.g., c1;r5



    return obj; 
}
function deviceTypeAddDashboardDpObjStr(contextOrder, str) {
    //displayElementType: c=chart, d=dropdown (only if datapoint has presets, enums are automatically "d"), d1=dropdown use dropdownList
    //          s1= slider, s2 = slider switch (binary), s3 = slider switch (SNVT_switch), s4 = slider switch (SNVT_switch 0 0 or 1 100 only), 
    //          l2 = led, l3 = led (SNVT_switch, led for state, span for value), l4 = LED SNVT_switch state only
    // example str = (9FFFFF0501840460)/TempSensor/0/nvoTemperature, label=Temp 2, displaytype=r;c, units=°C, contexts=floor;room,dashboard=200;310
    
    // ***mbw*** not complete yet, need to check if existing replacement datapoint, if so add to that list
    //tagType: dashboard, map
    var items, value;
    var obj = {}, obj1, obj2, obj3;
    var i, j, k, m, x, y, x1, y1, z, iPtr, iPtr1, iTemp, bContinue2;
	var items = [], items1;
	var x1;
	var sTemp = "", sTemp1, sTemp2,name, name1, names,type, image, width,height, location = "", above = true, sid = null, bSidFound, sFolder;
	var displayType = "n";
	var contextPath = "";
	var layout,ltable,bAtLeastOneItem; 
	var dpList = [], dpList1 = [], items, items1, items2, item3,  items3, item4;
	var label = "";
	var bContinue = true;
	var element;

    obj.sid = "";
    obj.blockPath = "";
    obj.field = "";
    obj.fieldPath = "";
    obj.units = "";
    
    
    /*
    
    if(userVisibility === null)
        userVisibility = 0;
    if(userReadtonly === null)
        userReadtonly = 0;
    */
    obj.visibility = 0; // userVisibility; // null or 0=all, 1=owner only, 2=owner + supervisor, 3=user only
    obj.userReadonly = 3; //userReadtonly; // applies to inputs only, null or 0=writable, 1=user only, 2=user + supervisor, 3=readable only
    obj.dashboardType = ""; //displayElementType; 
    obj.UserTypeWritePriority = 17; //= normalUserWritePriority; // only applies to the user user-type, doesn't apply to owner or supervisor
    obj.userClearPriority = 17; //= normalUserClearPriority
    obj.dropdownList = [];

    // additional required for site dashboard and device dashboard 
    obj.label = "";
    obj.contextDisplayType = "";
	obj.contexts = "";
    obj.color = "";
	obj.backgroundColor = "";
    obj.precision = -1;
	obj.graphicType = 0; // used with l2 and l4 to show different size dots
	obj.x = ""; // used for Dashboard positioning
	obj.y = ""; // Used for Dashboard positioning
    obj.width = "";
	obj.height = "";
	obj.padding = "";
	obj.paddingChar = "";
	obj.alarmType = "";
	obj.siteDashboard = false; // used to specify point is used for site dashboard
	obj.guageObj = null;
	obj.layout = null; // used specify where UI element is shown, c,r,e,x,y  e.g., c1;r5
    obj.datapointName = "";
    
					
        // devicetype_pulsegen.dp1: (9FFFFF0501840460)/device/0/nviLamp1, Lamp1, displaytype=s4, context=floor;room
        // devicetype_pulsegen.image:  devicetype=(9FFFFF0501840460),url=images/user/ft6050_device.jpg,width=null,height=null
        
        try {
            items = str.split(",");
            items1 = items[0].split("/");
            if(items1.length > 3) {
                items1[0] = items1[0].trim();
                items1[1] = items1[1].trim();
                items1[2] = items1[2].trim();
                items1[3] = items1[3].trim();
                obj.blockPath = items1[1] + "/" + items1[2] + "/" + items1[3];
                obj.name = obj.blockPath;
                obj.path = obj.blockPath;
                obj.deviceName = items1[0];
                obj.deviceTypeStr = items1[0];
                obj.pathname = items[0].trim();
                obj.datapointName = items1[3];
                obj.contextOrder = contextOrder;
                obj.deviceListIndex = -1;
                obj.scaleDp = "";
                for(i=0; i < items1.length; i++)
                {
                    items1[i] = items1[i].trim();
                    if(i > 3) {
                        if(obj.field !== "")
                            obj.field += "/";
                        obj.field += items[i];
                    }
                    if(obj.fieldPath !== "")
                        obj.fieldPath += "/";
                    obj.fieldPath += items1[i];
                    
                }
                for(i=0; i < deviceListAll.length; i++)
                {
                    if(deviceListAll[i].name === obj.deviceName) {
                        obj.deviceListIndex = i;
                        break;
                    }
                }
            }
            for(k=1; k < items.length; k++) {
                items1 = [];
                iPtr = items[k].indexOf("=")
                if((iPtr !== -1) && ((iPtr + 1) < items[k].length)) {
                    items1[0] = items[k].substr(0,iPtr).trim();
                    items1[1] = items[k].substr(iPtr + 1).trim();
                    try {
                        if((items1[0] === "") || (items1[1] === "")) {

                        }
                        else if(items1[0].startsWith("label")) {
                            obj.label = items1[1];
                        }
                        else if(items1[0] === "contexts") {
                            if(items1[1] !== "")
                                obj.contexts = items1[1].toLowerCase();
                        }
                        else if(items1[0].startsWith("units")) {
                            obj.units = items1[1];
                        }
                        else if(items1[0] === "displaytype") {
                            if(items1[1].indexOf(";") !== -1) {
                                items2 = items1[1].split(";");
                                if(items2.length === 2) {
                                    obj.contextDisplayType = items2[0].trim();
                                    obj.displayType = items2[1].trim();
                                    
                                }
                                else if(items2[0] !== "") {
                                    obj.contextDisplayType = items2[0].trim();
                                    obj.displayType = items2[0].trim();
                                }
                            }
                            else {
                                obj.contextDisplayType = items1[1];
                                obj.displayType = items1[1];
                            }
                        }
                        else if(items1[0] === "readonly") {
                            if(items1[1] === "false")
                                obj.readonly = false;
                            else 
                                obj.readonly = true;
                        }
                        else if(items1[0] === "color") {
                            if(items1[1].indexOf(";") === -1)
                                obj.color = items1[1];  //usually on color
                            else {
                                items2 = items1[1].split(";");
                                if(items2.length === 2) {
                                    obj.color = items2[0]; // on color
                                    obj.backgroundColor = items2[1]; //offcolor
                                }
                            }
                        }
                        else if(items1[0] === "units") {
                            obj.units = items1[1];
                        }
                        else if(items1[0] === "precision") {
                            if(!isNaN(items1[1])) 
                            obj.precision =  Number(items1[1]);
                        }
                        else if(items1[0] === "size") {
                            // only used on floorplan, not dashboard
                            if(!isNaN(items1[1])) 
                                obj.size = Number(items1[1]);
                        }
                        else if(items1[0] === "fontsize") {
                            obj.fontsize = items1[1]; // used for text input and span
                        }
                        else if(items1[0] === "width") {
                            obj.width = items1[1]; // used for text input and span
                        }
                        else if(items1[0] === "height") {
                            obj.height = items1[1]; // used for text input and span
                        }
                        else  if(items1[0] === "folder") {
                            sFolder = items1[1];
                        }
                        else  if(items1[0] === "scaledp") {
													
                            obj.scaleDisplayType = "ts";
                            items2 = items1[1].split(";");
                            if(items2.length > 0) {
                                items2[0] = items2[0].trim();
                                obj.scaleDp = items2[0];
                                if(items2.length === 2) {
                                    items2[1] = items2[1].trim();
                                    obj.scaleDisplayType = items2[1];
                                }
                            }
                        }
                        else if(items1[0] === "dashboard") {
                            //used to add span, s1,s4 to graphics
                            // x,y,displaytype,padding,paddingCar,alarmtype
                            try {
                                obj2 = {};
                                obj2.x = "";
                                obj2.y = "";
                                obj2.graphicDisplayType = "";
                                obj2.padding = "";
                                obj2.paddingChar = "";
                                obj2.alarmType = "";
                                obj2.color = "";
                                obj2.graphicType = 0; // used with l2 and l4 to show different size dots
                                if(items1[1].indexOf(";") !== -1) {
                                    items2 = items1[1].split(";");
                                    for(m=0;m < items2.length; m++)
                                    {
                                        item3 = items2[m].trim();
                                        if(m === 0)
                                            obj2.x = item3;
                                        else if(m === 1)
                                            obj2.y = item3;
                                        else if(m === 2) {
                                            if((item3.startsWith("l2") || item3.startsWith("l4")) && item3.endsWith("a")) {
                                                obj2.graphicDisplayType = item3.substr(0,2);
                                                obj2.graphicType = 1; // small dot
                                            }
                                            else if((item3.startsWith("l2") || item3.startsWith("l4")) && item3.endsWith("b")) {
                                                obj2.graphicDisplayType = item3.substr(0,2);
                                                obj2.graphicType = 2; // large dot with border
                                            }
                                            else if((item3.startsWith("l2") || item3.startsWith("l4")) && item3.endsWith("c")) {
                                                obj2.graphicDisplayType = item3.substr(0,2);
                                                obj2.graphicType = 3; // large dot with border
                                            }
                                            else if(item3.startsWith("l2") && item3.endsWith("e")) {
                                                obj2.graphicDisplayType = item3.substr(0,2);
                                                obj2.graphicType = 5; // small dot (0 = red, 1=green)
                                            }
                                            else if(item3.startsWith("l2") && item3.endsWith("f")) {
                                                obj2.graphicDisplayType = item3.substr(0,2);
                                                obj2.graphicType = 6; // small dot (0 = green, 1=red)
                                            }
                                            else if(item3.startsWith("l2") && item3.endsWith("g")) {
                                                obj2.graphicDisplayType = item3.substr(0,2);
                                                obj2.graphicType = 7; // large dot with border (0 = red, 1=green)
                                            }
                                            else if(item3.startsWith("l2") && item3.endsWith("h")) {
                                                obj2.graphicDisplayType = item3.substr(0,2);
                                                obj2.graphicType = 8; // large dot with border (0 = green, 1=red)
                                            }
                                            else if(item3.startsWith("l2") && item3.endsWith("i")) {
                                                obj2.graphicDisplayType = item3.substr(0,2);
                                                obj2.graphicType = 9; // large dot (0 = red, 1=green)
                                            }
                                            else if(item3.startsWith("l2") && item3.endsWith("j")) {
                                                obj2.graphicDisplayType = item3.substr(0,2);
                                                obj2.graphicType = 10; // large dot (0 = green, 1=red)
                                            }
                                            else
                                                obj2.graphicDisplayType = item3;
                                        }
                                        else if(m === 3){
                                            obj2.dashboardColor = item3;
                                        }
                                        else if(m === 4){
                                            obj2.dashboardBackgroundColor = item3;
                                        }
                                        else if(m === 5) {
                                            if((obj2.graphicDisplayType === "r") || (obj2.graphicDisplayType === "n"))
                                                obj2.padding = item3;
                                            else 
                                                obj2.dashboardBorderColor = item3;
                                        }
                                        else if(m === 6)
                                            obj2.paddingChar = item3;
                                        else if(m === 7)
                                            obj2.alarmType = item3;
                                    }
                                }
                            }
                            catch {
                                obj2 = null;
                            }
                            
                        }
                        else if(items1[0] === "layout") { // used specify where UI element is shown, c,r,e,x,y  e.g., c1;r5
                            // layout=c2;r3;e2;w200;h600, ewidth=300, eheight=200
                            try {
                                obj3 = {};
                                obj3.c = -1;
                                obj3.r = -1;
                                obj3.e = -1;
                                obj3.w = -1;
                                obj3.h = -1;
                                obj3.x = -1;
                                obj3.y= -1;
                                items2 = items1[1].split(";");
                                for(m=0; m < items2.length; m++)
                                {
                                    if(items2[m] !== "") {
                                        if(items2[m].length > 1) {
                                            if(items2[m].charAt(0) === "c") {
                                                sTemp2 = items2[m].substring(1);
                                                if(!isNaN(sTemp2)) {
                                                    obj3.c = Number(sTemp2);
                                                }
                                            }
                                            else if(items2[m].charAt(0) === "r") {
                                                sTemp2 = items2[m].substring(1);
                                                if(!isNaN(sTemp2)) {
                                                    obj3.r = Number(sTemp2);
                                                }
                                                else if(sTemp2 === "b")
                                                    obj3.r = 1000; //means last one
                                            }
                                            else if(items2[m].charAt(0) === "e") {
                                                sTemp2 = items2[m].substring(1);
                                                if(!isNaN(sTemp2)) {
                                                    obj3.e = Number(sTemp2);
                                                }
                                            }
                                            else if(items2[m].charAt(0) === "w") {
                                                sTemp2 = items2[m].substring(1);
                                                if(!isNaN(sTemp2)) {
                                                    obj3.w = Number(sTemp2);
                                                }
                                            }
                                            else if(items2[m].charAt(0) === "h") {
                                                sTemp2 = items2[m].substring(1);
                                                if(!isNaN(sTemp2)) {
                                                    obj3.h = Number(sTemp2);
                                                }
                                            }
                                            else if(items2[m].charAt(0) === "x") {
                                                sTemp2 = items2[m].substring(1);
                                                if(!isNaN(sTemp2)) {
                                                    obj3.x = Number(sTemp2);
                                                }
                                            }
                                            else if(items2[m].charAt(0) === "y") {
                                                sTemp2 = items2[m].substring(1);
                                                if(!isNaN(sTemp2)) {
                                                    obj3.y = Number(sTemp2);
                                                }
                                            }
                                        }
                                    }
                                }
                                if((obj3.c !== -1) || (obj3.r !== -1) || (obj3.e !== -1)  || (obj3.w !== -1)  || (obj3.h !== -1) || ((obj3.x !== -1)  && (obj3.y !== -1))) {
                                    obj.layout = JSON.parse(JSON.stringify(obj3)); // used specify where UI element is shown, c,r,e,x,y  e.g., c1;r5
                                }
                            }
                            catch {}
                        }
                        else if(items1[0] === "value") {
                            value = items1[1];
                        }
                        else if(items1[0] === "guagemin") {
                            // only used on floorplan, not dashboard
                            if(obj.guageObj === null) {
                                obj.guageObj = {};
                                obj.guageObj.type = 0;
                                obj.guageObj.guageMin = null;
                                obj.guageObj.guageMax = null;
                                obj.guageObj.guageColors = [];
                            }
                            if(!isNaN(items1[1])) 
                                obj.guageObj.guageMin = Number(items1[1]);
                        }
                        else if(items1[0] === "guagemax") {
                            // only used on floorplan, not dashboard
                            if(obj.guageObj === null) {
                                obj.guageObj = {};
                                obj.guageObj.type = 0;
                                obj.guageObj.guageMin = null;
                                obj.guageObj.guageMax = null;
                                obj.guageObj.guageColors = [];
                            }
                            if(!isNaN(items1[1])) 
                                obj.guageObj.guageMax = Number(items1[1]);
                        }
                        else if(items1[0] === "guagecolors") {
                            // only used on floorplan, not dashboard
                            if(obj.guageObj === null) {
                                obj.guageObj = {};
                                obj.guageObj.type = 0;
                                obj.guageObj.guageMin = null;
                                obj.guageObj.guageMax = null;
                                obj.guageObj.guageColors = [];
                            }
                            if(items1[1].indexOf(";") !== -1) {
                                
                                items2 = items1[1].split(";");
                            }
                            else {
                                items2 = [];
                                items2[0] = items1[1];
                            }
                            
                            for(m=0;m < items2.length; m++)
                            {
                                item3 = items2[m].trim();
                                items3 = item3.split("(");
                                
                                if(items3.length === 0) {

                                }
                                else if(items3.length === 1) {
                                    obj3 = {};
                                    obj3.value = null;
                                    obj3.color = items3[0].trim();
                                    if(obj3.color !== "")
                                        obj3.color = obj3.color.toLowerCase();
                                    obj.guageObj.guageColors.push(obj3);
                                }
                                else if (items3.length === 2) {
                                    
                                    obj3 = {};
                                    obj3.value = null;
                                    obj3.color = items3[0].trim();
                                    if(obj3.color !== "")
                                        obj3.color = obj3.color.toLowerCase();
                                    item4 = items3[1];
                                    item4 = item4.trim();
                                    if(item4.charAt(item4.length - 1) === ")") {
                                        item4 = item4.substr(0, item4.length - 1);
                                        if(!isNaN(item4)) 
                                            obj3.value = Number(item4);
                                    }
                                    obj.guageObj.guageColors.push(obj3);
                                }
                            }
                            
                        }
                        else if(items1[0] === "field") 
                            obj.field = items1[1];
                    }
                    catch {}
                }
            } //for(k=1; k < items.length; k++)
            // checkif guage
            if(obj.guageObj !== null) {
                if(obj.displayType === "g1"){
                    obj.displayType = "g"
                    obj.guageObj.type = 1;
                }
                else if(obj.displayType === "g2"){
                    obj.displayType = "g"
                    obj.guageObj.type = 2;
                }
                else if(obj.displayType === "gc1"){
                    obj.displayType = "gc"
                    obj.guageObj.type = 1;
                }
                else if(obj.displayType === "gc2"){
                    obj.displayType = "gc"
                    obj.guageObj.type = 2;
                }
                else if(obj.displayType === "m1"){
                    obj.displayType = "m"
                    obj.guageObj.type = 1; // red/yellow/green
                }
                else if(obj.displayType === "m2"){
                    obj.displayType = "m"; // red/yellow/green/yellow/red
                    obj.guageObj.type = 2; 
                }
                // move range to previous color
                for(m=1;m < obj.guageObj.guageColors.length; m++)
                {
                    obj.guageObj.guageColors[m-1].value = obj.guageObj.guageColors[m].value;
                    obj.guageObj.guageColors[m].value = null;
                }
            }
            if(value !== null) {
                bContinue2 = false;
                if((obj.displayType === "i") || (obj.displayType === "t1")) {
                    bContinue2 = true;
                    if(obj.displayType === "t1")
                            sFolder
                }
                else if (obj2 !== null) {
                    if(typeof obj2.graphicDisplayType !== "undefined") {
                        if((obj2.graphicDisplayType === "i") || (obj2.graphicDisplayType === "t1"))
                            bContinue2 = true;
                        if(obj2.graphicDisplayType === "t1")
                            sFolder
                    }
                }
                if(bContinue2) {
                    try {
                        // convert value to imageswapper value
                        obj.imageSwapper = [];
                        items2 = items1[1].split(";");
                        y = 1;
                        for(m=0;m < items2.length; m++)
                        {
                            items3 = items2[m].split(":");
                            if(items3.length === 2) {
                                items3[0] = items3[0].trim();
                                items3[1] = items3[1].trim();
                                
                                obj3 = {};
                                obj3.value = items3[0];
                                obj3.sortValue = 2;
                                obj3.test = "=";
                                
                                iPtr = obj3.value.indexOf(">=");
                                if(iPtr !== -1) {
                                    obj3.sortValue = 3;
                                    obj3.value = obj3.value.substr(iPtr + 2).trim();
                                    obj3.test = ">=";
                                    if(isNaN(obj3.value))
                                        y = 0;
                                }
                                else {
                                    iPtr = obj3.value.indexOf("=>");
                                    if(iPtr !== -1) {
                                        obj3.sortValue = 3;
                                        obj3.value = obj3.value.substr(iPtr + 2).trim();
                                        obj3.test = ">=";
                                        if(isNaN(obj3.value))
                                            y = 0;
                                    }
                                    else {
                                        iPtr = obj3.value.indexOf("<=");
                                        if(iPtr !== -1) {
                                            obj3.sortValue = 1;
                                            obj3.value = obj3.value.substr(iPtr + 2).trim();
                                            obj3.test = "<=";
                                            if(isNaN(obj3.value))
                                                y = 0;
                                        }
                                        else {
                                            iPtr = obj3.value.indexOf("=<");
                                            if(iPtr !== -1) {
                                                obj3.sortValue = 1;
                                                obj3.value = obj3.value.substr(iPtr + 2).trim();
                                                obj3.test = "<=";
                                                if(isNaN(obj3.value))
                                                    y = 0;
                                            }
                                            else {
                                                iPtr = obj3.value.indexOf(">");
                                                if(iPtr !== -1) {
                                                    obj3.sortValue = 4;
                                                    obj3.value = obj3.value.substr(iPtr + 1).trim();
                                                    obj3.test = ">";
                                                    if(isNaN(obj3.value))
                                                        y = 0;
                                                }
                                                else {
                                                    iPtr = obj3.value.indexOf("<");
                                                    if(iPtr !== -1) {
                                                        obj3.sortValue = 0;
                                                        obj3.value = obj3.value.substr(iPtr + 1).trim();
                                                        obj3.test = "<";
                                                        if(isNaN(obj3.value))
                                                        y = 0;
                                                    }
                                                    else {
                                                        iPtr = obj3.value.indexOf("=");
                                                        if(iPtr !== -1) {
                                                            obj3.sortValue = 0;
                                                            obj3.value = obj3.value.substr(iPtr + 1).trim();
                                                        }
                                                        if(isNaN(obj3.value))
                                                            y = 0;
                                                    }
                                                }
                                            }
                                        }
                                        
                                    }
                                }
                                if(sFolder !== "")
                                    obj3.image = sFolder + items3[1];  //used for both color and image
                                else 
                                    obj3.image = items3[1]; //used for both color and image
                                
                                obj.imageSwapper.unshift(obj3);
                                
                            }
                        }
                        // sort values
                        if(y === 1) {
                            
                            for(m=0;m < obj.imageSwapper.length; m++)
                            {
                                obj.imageSwapper[m].value = Number(obj.imageSwapper[m].value);
                            }
                            if(y === 1) {
                                while(bContinue2)
                                {
                                    bContinue2 = false;
                                    for(m=0;m < obj.imageSwapper.length - 1; m++)
                                    {
                                        if(obj.imageSwapper[m].value < obj.imageSwapper[m + 1].value) {
                                            y = obj.imageSwapper[m].value;
                                            obj.imageSwapper[m].value = obj.imageSwapper[m + 1].value;
                                            obj.imageSwapper[m + 1].value = y;
                                            bContinue2 = true;
                                        }
                                        else if(obj.imageSwapper[m].value === obj.imageSwapper[m + 1].value) {
                                            if(obj.imageSwapper[m].sortValue < obj.imageSwapper[m + 1].sortValue) {
                                                y = obj.imageSwapper[m].value;
                                                obj.imageSwapper[m].value = obj.imageSwapper[m + 1].value;
                                                obj.imageSwapper[m + 1].value = y;
                                                bContinue2 = true;
                                            }
                                        }
                                    }
                                }
                                // remove sortvalue
                                for(m=0;m < obj.imageSwapper.length; m++)
                                {
                                    delete obj.imageSwapper[m].sortValue;
                                }
                            }
                        }
                    }
                    catch {}
                }
            }
            if(obj.label === "") {
                obj.label = obj.deviceName + " " + obj.datapointName;
            }
            if(obj2 !== null) {
                try {
                    if((obj2.x !== "") && (obj2.y !== "")) {
                        obj2.x = Number(obj2.x);
                        obj2.y = Number(obj2.y);
                        if(isNaN(obj2.x) || isNaN(obj2.y))
                            obj2 = null;
                        /*
                        else if((obj.displayType === "r") || (obj.displayType === "n") || (obj.displayType === "c"))
                            obj.displayType = "r";
                        else if((obj.displayType === "s2") || (obj.displayType === "l2"))
                            obj.displayType = "l2";
                        else if((obj.displayType === "s4") || (obj.displayType === "l4"))
                            obj.displayType = "l4";	
                        else */
                        else {
                            if(obj2.graphicDisplayType === "") {
                                obj2.graphicDisplayType = obj.displayType;
                            }
                            if(!((obj2.graphicDisplayType === "r") || (obj2.graphicDisplayType === "n") || (obj2.graphicDisplayType === "c")  || (obj2.graphicDisplayType === "cr")
                            || (obj2.graphicDisplayType === "i") || (obj2.graphicDisplayType === "t1")
                            || (obj2.graphicDisplayType === "s2") || (obj2.graphicDisplayType === "l2") || (obj2.graphicDisplayType === "s3") || (obj2.graphicDisplayType === "l3")
                            || (obj2.graphicDisplayType === "s4") || (obj2.graphicDisplayType === "l4")
                            || (obj2.graphicDisplayType === "lr2") || (obj2.graphicDisplayType === "lr4")
                            || (obj2.graphicDisplayType === "rbt")
                            || (obj2.graphicDisplayType === "pb") ))
                            obj2 = null;
                        }
                        if(obj2 !== null) {
                            
                            obj.x = obj2.x;
                            obj.y = obj2.y;
                            obj.padding = obj2.padding;
                            obj.paddingChar = obj2.paddingChar;
                            obj.alarmType = obj2.alarmType;
                            obj.graphicDisplayType = obj2.graphicDisplayType;
                            obj.graphicType = obj2.graphicType;
                            /*if((obj2.graphicDisplayType === "l2") || (obj2.graphicDisplayType === "l3") || (obj2.graphicDisplayType === "l4")) {
                                if(typeof obj2.color !== "undefined")
                                    obj.backgroundColor = obj2.color;
                            } */
                            if((obj2.graphicDisplayType === "l2") || (obj2.graphicDisplayType === "l3") || (obj2.graphicDisplayType === "l4")) {
                                if(typeof obj2.dashboardColor !== "undefined")
                                    obj.dashboardColor = obj2.dashboardColor;
                                if(typeof obj2.dashboardBackgroundColor !== "undefined")
                                    obj.dashboardBackgroundColor = obj2.dashboardBackgroundColor;
                                if(typeof obj2.dashboardBorderColor !== "undefined")
                                    obj.dashboardBorderColor = obj2.dashboardBorderColor;
                            }
                            else { // r and n
                                if(typeof obj2.dashboardColor !== "undefined")
                                    obj.dashboardColor = obj2.dashboardColor;
                                if(typeof obj2.dashboardBackgroundColor !== "undefined")
                                    obj.dashboardBackgroundColor = obj2.dashboardBackgroundColor;
                            }
                        }
                    }
                }
                catch {}
            }
            // add to existing devicetype or create new one
            
        }
        catch {}
        
    return obj; // 
}
function deviceTypeAddDashboardLayout(tagNameType, str) {
    try {
        var i, j, z, iTemp;
        var sTemp, width = "", height = "", layout = "", ltable = null, sTemp1 = "", sTemp2;
        var bAtLeastOneItem, obj, items, items1;
        if((tagNameType === null) || (str === null))
            return;
        if((tagNameType === "") || (str === ""))
            return;
        if(tagNameType.startsWith("layout")) {
            // .layout: layout=cre, table=c2;r3;e2, ewidth=300, eheight=200
            width = "";
            height = "";
            layout = "";
            ltable = null;
            sTemp1 = "";
            bAtLeastOneItem = false;
            items = str.split(",");
            for(i=0; i < items.length; i++)
            {
                if(items[i] !== "") {
                    items1 = items[i].split("=");
                    if(items1.length === 2) {
                        items1[0] = items1[0].trim().toLowerCase();
                        items1[1] = items1[1].trim();
                        
                        
                        if(items1[0] === "layout") {
                            layout = items1[1];
                            if((layout === "rc") || (layout === "cre")) {
                                bAtLeastOneItem = true;
                            }
                            else
                                layout = "";
                        }
                        else if(items1[0] === "ewidth") {
                            if(items1[1] !== "null") {
                                width = items1[1];
                                if(isNaN(width))
                                    width = "";
                                else {
                                    width = Number(width);
                                    bAtLeastOneItem = true;
                                }
                            }
                        }
                        else if(items1[0] === "eheight") {
                            if(items1[1] !== "null") {
                                height = items1[1];
                                if(isNaN(height))
                                    height = "";
                                else {
                                    height = Number(height);
                                    bAtLeastOneItem = true;
                                }
                            }
                        }
                        else if(items1[0] === "table") {
                                sTemp1 = items1[1];
                        }
                    }
                }
            }
            if(sTemp1 !== "") {
                iTemp = 0;
                
                ltable = {};
                ltable.enabled = true;
                ltable.c = -1;
                ltable.r = -1;
                ltable.e = -1;
                ltable.x = -1;
                ltable.y = -1;
                ltable.showPriorities = false;
                ltable.readonly = false;
                try {
                    if(sTemp1 === "none") {
                        ltable.enabled = false;
                        bAtLeastOneItem = true;
                    }
                    else {
                        items = sTemp1.split(";");
                        for(i=0; i < items.length; i++)
                        {
                            if(items[i] !== "") {
                                if(items[i].length > 1) {
                                    if(items[i] === "readonly") {
                                        ltable.readonly = true;
                                    }
                                    if(items[i] === "showpriorities") {
                                        ltable.showPriorities = true;
                                    }
                                    else if(items[i].charAt(0) === "c") {
                                        sTemp2 = items[i].substring(1);
                                        if(!isNaN(sTemp2)) {
                                            ltable.c = Number(sTemp2);
                                        }
                                    }
                                    else if(items[i].charAt(0) === "r") {
                                        sTemp2 = items[i].substring(1);
                                        if(!isNaN(sTemp2)) {
                                            ltable.r = Number(sTemp2);
                                        }
                                        else if(sTemp2 === "b")
                                            ltable.r = 1000; //means last one
                                    }
                                    else if(items[i].charAt(0) === "e") {
                                        sTemp2 = items[i].substring(1);
                                        if(!isNaN(sTemp2)) {
                                            ltable.e = Number(sTemp2);
                                        }
                                    }
                                    else if(items[i].charAt(0) === "x") {
                                        sTemp2 = items[i].substring(1);
                                        if(!isNaN(sTemp2)) {
                                            ltable.x = Number(sTemp2);
                                        }
                                    }
                                    else if(items[i].charAt(0) === "y") {
                                        sTemp2 = items[i].substring(1);
                                        if(!isNaN(sTemp2)) {
                                            ltable.y = Number(sTemp2);
                                        }
                                    }
                                }
                            }
                        }
                        if((ltable.c !== -1) || (ltable.r !== -1) || (ltable.e !== -1) || ((ltable.x !== -1) && (ltable.y !== -1))
                            || ltable.readonly || ltable.showPriorities) {
                            bAtLeastOneItem = true;
                        }
                        else 
                            ltable = null;
                    }
                }
                catch {
                    ltable = null;
                }
            }
            if(bAtLeastOneItem) {

                if(g_siteDashboardReplacementList.length === 0){
                    obj = {};
                    obj.name = names[i];
                    obj.type = type;
                    obj.image = "";
                    obj.width = "";
                    obj.height = "";
                    obj.dpList = [];
                    obj.colorOn = g_sDashboardLedOffColor;
                    obj.colorOff = g_sDashboardLedOffColor;
                    obj.colorBorder = g_sDashboardLedBorderColor;
                    obj.layout = null;
                    obj.imageLayout = null;
                    obj.icons = null;
                    g_siteDashboardReplacementList.push(JSON.parse(JSON.stringify(obj)));
                    z = g_siteDashboardReplacementList.length - 1;
                }
                z = g_siteDashboardReplacementList.length - 1;
                if(z !== -1) {
                    obj = {};
                    obj.layout = layout;
                    obj.table = ltable;
                    obj.eWidth = width;
                    obj.eHeight = height;
                    g_siteDashboardReplacementList[z].layout = obj;
                }
            }
        }
    }
    catch {}
}
function deviceTypeAddDashboardImage(tagNameType, str) {
    try {
        var i, j, z, iTemp;;
        var sTemp, width = "", height = "", layout = "", ltable = null, sTemp1 = "", sTemp2;
        var names = [], type = "", image = "", width = "", height = "";
        var bAtLeastOneItem, obj, items, items1;
        if((tagNameType === null) || (str === null))
            return;
        if((tagNameType === "") || (str === ""))
            return;
        if(tagNameType.startsWith("image")) {
            names = [];
            type = "";
            image = "";
            width = "";
            height = "";
            x1 = "";
            y1 = "";
            sTemp1 = "";
            bAtLeastOneItem = false;
            items = str.split(",");
            for(i=0; i < items.length; i++)
            {
                if(items[i] !== "") {
                    items1 = items[i].split("=");
                    if(items1.length === 2) {
                        items1[0] = items1[0].trim().toLowerCase();
                        items1[1] = items1[1].trim();
                        
                        
                        if(items1[0] === "image") {
                            image = items1[1];
                        }
                        else if(items1[0] === "width") {
                            if(items1[1] !== "null")
                                width = items1[1];
                        }
                        else if(items1[0] === "height") {
                            if(items1[1] !== "null")
                                height = items1[1];
                        }
                        else if(items1[0] === "x") {
                            if(items1[1] !== "null")
                                x1 = items1[1];
                        }
                        else if(items1[0] === "y") {
                            if(items1[1] !== "null")
                                y1 = items1[1];
                        }
                        else if(items1[0] === "layout") {
                            sTemp1 = items1[1];
                        }
                    }
                }

            }
            if(sTemp1 !== "") {
                iTemp = 0;
                items = sTemp1.split(";");
                ltable = {};
                ltable.c = -1;
                ltable.r = -1;
                ltable.e = -1;
                ltable.x = -1;
                ltable.y = -1;
                try {
                    for(i=0; i < items.length; i++)
                    {
                        if(items[i] !== "") {
                            if(items[i].length > 1) {
                                if(items[i].charAt(0) === "c") {
                                    sTemp2 = items[i].substring(1);
                                    if(!isNaN(sTemp2)) {
                                        ltable.c = Number(sTemp2);
                                    }
                                }
                                else if(items[i].charAt(0) === "r") {
                                    sTemp2 = items[i].substring(1);
                                    if(!isNaN(sTemp2)) {
                                        ltable.r = Number(sTemp2);
                                    }
                                    else if(sTemp2 === "b")
                                        ltable.r = 1000; //means last one
                                }
                                else if(items[i].charAt(0) === "e") {
                                    sTemp2 = items[i].substring(1);
                                    if(!isNaN(sTemp2)) {
                                        ltable.e = Number(sTemp2);
                                    }
                                }
                                else if(items[i].charAt(0) === "x") {
                                    sTemp2 = items[i].substring(1);
                                    if(!isNaN(sTemp2)) {
                                        ltable.x = Number(sTemp2);
                                    }
                                }
                                else if(items[i].charAt(0) === "y") {
                                    sTemp2 = items[i].substring(1);
                                    if(!isNaN(sTemp2)) {
                                        ltable.y = Number(sTemp2);
                                    }
                                }
                            }
                        }
                    }
                    if((ltable.c !== -1) || (ltable.r !== -1) || (ltable.e !== -1) || ((ltable.x !== -1) && (ltable.y !== -1))) {
                        bAtLeastOneItem = true;
                    }
                    else 
                        ltable = null;
                }
                catch {
                    ltable = null;
                }
            }
            if(g_siteDashboardReplacementList.length === 0){
                obj = {};
                    obj.name = names[i];
                    obj.type = type;
                    obj.image = "";
                    obj.width = "";
                    obj.height = "";
                    obj.x = "";
                    obj.y = "";
                    obj.dpList = [];
                    obj.colorOn = g_sDashboardLedOffColor;
                    obj.colorOff = g_sDashboardLedOffColor;
                    obj.colorBorder = g_sDashboardLedBorderColor;
                    obj.layout = null;
                    obj.imageLayout = null;
                    obj.icons = null;
                    g_siteDashboardReplacementList.push(JSON.parse(JSON.stringify(obj)));
                    z = g_siteDashboardReplacementList.length - 1;
            }
            z = g_siteDashboardReplacementList.length - 1;
            if(z !== -1) {
                g_siteDashboardReplacementList[z].image = image;
                g_siteDashboardReplacementList[z].width = width;
                g_siteDashboardReplacementList[z].height = height;
                g_siteDashboardReplacementList[z].x = x1;
                g_siteDashboardReplacementList[z].y = y1;
                if(bAtLeastOneItem)
                    g_siteDashboardReplacementList[z].imageLayout = ltable;
            }
        }
        else if(tagNameType.startsWith("icon")) {
            // used to show a graphic on top of an image. For example, show a FT 6050 EVB on top of a floorplan
            names = "";
            type = "";
            image = "";
            width = "";
            height = "";
            x1 = "";
            y1 = "";
            sTemp1 = "";
            bAtLeastOneItem = false;
            items = str.split(",");
            for(i=0; i < items.length; i++)
            {
                if(items[i] !== "") {
                    items1 = items[i].split("=");
                    if(items1.length === 2) {
                        items1[0] = items1[0].trim().toLowerCase();
                        items1[1] = items1[1].trim();
                        
                        
                        if(items1[0] === "image") {
                            image = items1[1];
                        }
                        else if(items1[0] === "width") {
                            if(items1[1] !== "null")
                                width = items1[1];
                        }
                        else if(items1[0] === "height") {
                            if(items1[1] !== "null")
                                height = items1[1];
                        }
                        else if(items1[0] === "x") {
                            if(items1[1] !== "null")
                                x1 = items1[1];
                        }
                        else if(items1[0] === "y") {
                            if(items1[1] !== "null")
                                y1 = items1[1];
                        }
                        else if(items1[0] === "device") {
                            names = items1[1];
                        }
                    }
                }

            }
            if((image !== "") && (x1 !== "") && (y1 !== "")) {
                if(g_campusTags.dashboard.length === 0){
                    obj = {};
                        obj.name = [];
                        obj.type = type;
                        obj.image = "";
                        obj.width = "";
                        obj.height = "";
                        obj.x = "";
                        obj.y = "";
                        obj.dpList = [];
                        obj.colorOn = g_sDashboardLedOffColor;
                        obj.colorOff = g_sDashboardLedOffColor;
                        obj.colorBorder = g_sDashboardLedBorderColor;
                        obj.layout = null;
                        obj.imageLayout = null;
                        obj.icons = null;
                        g_siteDashboardReplacementList.push(JSON.parse(JSON.stringify(obj)));
                        z = g_siteDashboardReplacementList.length - 1;
                }
                z = g_siteDashboardReplacementList.length - 1;
                if(z !== -1) {
                    if(g_siteDashboardReplacementList[z].icons === null)
                        g_siteDashboardReplacementList[z].icons = [];
                    obj = {};
                    obj.image = image;
                    obj.x = x1;
                    obj.y = y1;
                    obj.deviceName = names;
                    if(width !== "")
                        obj.width = width;
                    else 
                        obj.width = null;
                    if(height !== "")
                        obj.height = height;
                    else 
                        obj.height= null;	
                    
                    g_siteDashboardReplacementList[z].icons.push(JSON.parse(JSON.stringify(obj)));
                }
            }
        }
        else if(tagNameType.startsWith("colors")) {
            names = [];
            type = "";
            image = "";
            width = "";
            height = "";
            items = str.split(",");
            for(i=0; i < items.length; i++)
            {
                if(items[i] !== "") {
                    items1 = items[i].split("=");
                    if(items1.length === 2) {
                        items1[0] = items1[0].trim().toLowerCase();
                        items1[1] = items1[1].trim();
                        
                        
                        if(items1[0] === "coloron") {
                            image = items1[1];
                        }
                        else if(items1[0] === "coloroff") {
                            if(items1[1] !== "null")
                                width = items1[1];
                        }
                        else if(items1[0] === "colorborder") {
                            if(items1[1] !== "null")
                                height = items1[1];
                        }
                    }
                }

            }
            if(g_siteDashboardReplacementList.length === 0){
                obj = {};
                    obj.name = names[i];
                    obj.type = type;
                    obj.image = "";
                    obj.width = "";
                    obj.height = "";
                    obj.dpList = [];
                    obj.colorOn = g_sDashboardLedOffColor;
                    obj.colorOff = g_sDashboardLedOffColor;
                    obj.colorBorder = g_sDashboardLedBorderColor;
                    obj.layout = null;
                    obj.imageLayout = null;
                    obj.icons = null;
                    g_siteDashboardReplacementList.push(JSON.parse(JSON.stringify(obj)));
                    z = g_siteDashboardReplacementList.length - 1;
            }
            z = g_siteDashboardReplacementList.length - 1;
            if(z !== -1) {
                g_siteDashboardReplacementList[z].colorOn = image;
                g_siteDashboardReplacementList[z].colorOff = width;
                g_siteDashboardReplacementList[z].colorBorder = height;
            }
        }
    }
    catch {}
}
function addDpObjStr(str) {
    //displayElementType: c=chart, d=dropdown (only if datapoint has presets, enums are automatically "d"), d1=dropdown use dropdownList
    //          s1= slider, s2 = slider switch (binary), s3 = slider switch (SNVT_switch), s4 = slider switch (SNVT_switch 0 0 or 1 100 only), 
    //          l2 = led, l3 = led (SNVT_switch, led for state, span for value), l4 = LED SNVT_switch state only
    // example str = (9FFFFF0501840460)/TempSensor/0/nvoTemperature, label=Temp 2, displaytype=r;c, units=°C, contexts=floor;room,dashboard=200;310
    
    // ***mbw*** not complete yet, need to check if existing replacement datapoint, if so add to that list
    var items, i;
    var obj = {}
    var i, j, k, m, x, y, x1, y1, z, iPtr, iPtr1, iTemp, bContinue2;
	var items = [], items1;
	var x1;
	var sTemp = "", sTemp1, sTemp2,name, name1, names,type, image, width,height, location = "", above = true, sid = null, bSidFound, sFolder;
	var displayType = "n";
	var contextPath = "";
	var layout,ltable,bAtLeastOneItem; 
	var dpList = [], dpList1 = [], items, items1, items2, item3,  items3, item4;
	var label = "";
	var bContinue = true;
	var element;

    obj.sid = sid;
    obj.blockPath = blockPath;
    obj.field = "";
    obj.fieldPath = "";
    obj.units = "";
    
    
    
    
    if(userVisibility === null)
        userVisibility = 0;
    if(userReadtonly === null)
        userReadtonly = 0;
    obj.visibility = userVisibility; // null or 0=all, 1=owner only, 2=owner + supervisor, 3=user only
    obj.userReadonly = userReadtonly; // applies to inputs only, null or 0=writable, 1=user only, 2=user + supervisor, 3=readable only
    obj.dashboardType = displayElementType; 
    obj.UserTypeWritePriority = normalUserWritePriority; // only applies to the user user-type, doesn't apply to owner or supervisor
    obj.userClearPriority = normalUserClearPriority
    obj.dropdownList = [];

    // additional required for site dashboard and device dashboard 
    obj.label = "";
    obj.contextDisplayType = "";
	obj.contexts = "";
    obj.color = "";
	obj.backgroundColor = "";
    obj.precision = -1;
	obj.graphicType = 0; // used with l2 and l4 to show different size dots
	obj.x = ""; // used for Dashboard positioning
	obj.y = ""; // Used for Dashboard positioning
    obj.width = "";
	obj.height = "";
	obj.padding = "";
	obj.paddingChar = "";
	obj.alarmType = "";
	obj.siteDashboard = false; // used to specify point is used for site dashboard
	obj.guageObj = null;
	obj.layout = null; // used specify where UI element is shown, c,r,e,x,y  e.g., c1;r5

    
					
        // devicetype_pulsegen.dp1: (9FFFFF0501840460)/device/0/nviLamp1, Lamp1, displaytype=s4, context=floor;room
        // devicetype_pulsegen.image:  devicetype=(9FFFFF0501840460),url=images/user/ft6050_device.jpg,width=null,height=null
        
        try {
            items = str.split(",");
            items1 = items.split("/");
            if(items1.length > 3) {
                obj.blockPath = items1[0].trim(); + "/" + items1[1].trim() + "/" + items1[2].trim();
                
                for(i=0; i < items1.length; i++)
                {
                    items1[i] = items1[i].trim();
                    if(i > 3) {
                        if(obj.field !== "")
                            obj.field += "/";
                        obj.field += items[i];
                    }
                    if(obj.fieldPath !== "")
                        obj.fieldPath += "/";
                    obj.fieldPath += items1[i];
                    
                }
            }
            for(k=1; k < items.length; k++) {
                items1 = [];
                iPtr = items[k].indexOf("=")
                if((iPtr !== -1) && ((iPtr + 1) < items[k].length)) {
                    items1[0] = items[k].substr(0,iPtr).trim();
                    items1[1] = items[k].substr(iPtr + 1).trim();
                    try {
                        if((items1[0] === "") || (items1[1] === "")) {

                        }
                        else if(items1[0].startsWith("label")) {
                            obj.label = items1[1];
                        }
                        else if(items1[0] === "contexts") {
                            if(items1[1] !== "")
                                obj.contexts = items1[1].toLowerCase();
                        }
                        else if(items1[0].startsWith("units")) {
                            obj.units = items1[1];
                        }
                        else if(items1[0] === "displaytype") {
                            if(items1[1].indexOf(";") !== -1) {
                                items2 = items1[1].split(";");
                                if(items2.length === 2) {
                                    obj.contextDisplayType = items2[0].trim();
                                    obj.displayType = items2[1].trim();
                                    
                                }
                                else if(items2[0] !== "") {
                                    obj.contextDisplayType = items2[0].trim();
                                    obj.displayType = items2[0].trim();
                                }
                            }
                            else {
                                obj.contextDisplayType = items1[1];
                                obj.displayType = items1[1];
                            }
                        }
                        else if(items1[0] === "readonly") {
                            if(items1[1] === "false")
                                obj.readonly = false;
                            else 
                                obj.readonly = true;
                        }
                        else if(items1[0] === "color") {
                            if(items1[1].indexOf(";") === -1)
                                obj.color = items1[1];  //usually on color
                            else {
                                items2 = items1[1].split(";");
                                if(items2.length === 2) {
                                    obj.color = items2[0]; // on color
                                    obj.backgroundColor = items2[1]; //offcolor
                                }
                            }
                        }
                        else if(items1[0] === "units") {
                            obj.units = items1[1];
                        }
                        else if(items1[0] === "precision") {
                            if(!isNaN(items1[1])) 
                            obj.precision =  Number(items1[1]);
                        }
                        else if(items1[0] === "size") {
                            // only used on floorplan, not dashboard
                            if(!isNaN(items1[1])) 
                                obj.size = Number(items1[1]);
                        }
                        else if(items1[0] === "fontsize") {
                            obj.fontsize = items1[1]; // used for text input and span
                        }
                        else if(items1[0] === "width") {
                            obj.width = items1[1]; // used for text input and span
                        }
                        else if(items1[0] === "height") {
                            obj.height = items1[1]; // used for text input and span
                        }
                        else  if(items1[0] === "folder") {
                            sFolder = items1[1];
                        }
                        else if(items1[0] === "dashboard") {
                            //used to add span, s1,s4 to graphics
                            // x,y,displaytype,padding,paddingCar,alarmtype
                            try {
                                obj2 = {};
                                obj2.x = "";
                                obj2.y = "";
                                obj2.graphicDisplayType = "";
                                obj2.padding = "";
                                obj2.paddingChar = "";
                                obj2.alarmType = "";
                                obj2.color = "";
                                obj2.graphicType = 0; // used with l2 and l4 to show different size dots
                                if(items1[1].indexOf(";") !== -1) {
                                    items2 = items1[1].split(";");
                                    for(m=0;m < items2.length; m++)
                                    {
                                        item3 = items2[m].trim();
                                        if(m === 0)
                                            obj2.x = item3;
                                        else if(m === 1)
                                            obj2.y = item3;
                                        else if(m === 2) {
                                            if((item3.startsWith("l2") || item3.startsWith("l4")) && item3.endsWith("a")) {
                                                obj2.graphicDisplayType = item3.substr(0,2);
                                                obj2.graphicType = 1; // small dot
                                            }
                                            else if((item3.startsWith("l2") || item3.startsWith("l4")) && item3.endsWith("b")) {
                                                obj2.graphicDisplayType = item3.substr(0,2);
                                                obj2.graphicType = 2; // large dot with border
                                            }
                                            else if((item3.startsWith("l2") || item3.startsWith("l4")) && item3.endsWith("c")) {
                                                obj2.graphicDisplayType = item3.substr(0,2);
                                                obj2.graphicType = 3; // large dot with border
                                            }
                                            else if(item3.startsWith("l2") && item3.endsWith("e")) {
                                                obj2.graphicDisplayType = item3.substr(0,2);
                                                obj2.graphicType = 5; // small dot (0 = red, 1=green)
                                            }
                                            else if(item3.startsWith("l2") && item3.endsWith("f")) {
                                                obj2.graphicDisplayType = item3.substr(0,2);
                                                obj2.graphicType = 6; // small dot (0 = green, 1=red)
                                            }
                                            else if(item3.startsWith("l2") && item3.endsWith("g")) {
                                                obj2.graphicDisplayType = item3.substr(0,2);
                                                obj2.graphicType = 7; // large dot with border (0 = red, 1=green)
                                            }
                                            else if(item3.startsWith("l2") && item3.endsWith("h")) {
                                                obj2.graphicDisplayType = item3.substr(0,2);
                                                obj2.graphicType = 8; // large dot with border (0 = green, 1=red)
                                            }
                                            else if(item3.startsWith("l2") && item3.endsWith("i")) {
                                                obj2.graphicDisplayType = item3.substr(0,2);
                                                obj2.graphicType = 9; // large dot (0 = red, 1=green)
                                            }
                                            else if(item3.startsWith("l2") && item3.endsWith("j")) {
                                                obj2.graphicDisplayType = item3.substr(0,2);
                                                obj2.graphicType = 10; // large dot (0 = green, 1=red)
                                            }
                                            else
                                                obj2.graphicDisplayType = item3;
                                        }
                                        else if(m === 3){
                                            obj2.dashboardColor = item3;
                                        }
                                        else if(m === 4){
                                            obj2.dashboardBackgroundColor = item3;
                                        }
                                        else if(m === 5) {
                                            if((obj2.graphicDisplayType === "r") || (obj2.graphicDisplayType === "n"))
                                                obj2.padding = item3;
                                            else 
                                                obj2.dashboardBorderColor = item3;
                                        }
                                        else if(m === 6)
                                            obj2.paddingChar = item3;
                                        else if(m === 7)
                                            obj2.alarmType = item3;
                                    }
                                }
                            }
                            catch {
                                obj2 = null;
                            }
                            
                        }
                        else if(items1[0] === "layout") { // used specify where UI element is shown, c,r,e,x,y  e.g., c1;r5
                            // layout=c2;r3;e2;w200;h600, ewidth=300, eheight=200
                            try {
                                obj3 = {};
                                obj3.c = -1;
                                obj3.r = -1;
                                obj3.e = -1;
                                obj3.w = -1;
                                obj3.h = -1;
                                obj3.x = -1;
                                obj3.y= -1;
                                items2 = items1[1].split(";");
                                for(m=0; m < items2.length; m++)
                                {
                                    if(items2[m] !== "") {
                                        if(items2[m].length > 1) {
                                            if(items2[m].charAt(0) === "c") {
                                                sTemp2 = items2[m].substring(1);
                                                if(!isNaN(sTemp2)) {
                                                    obj3.c = Number(sTemp2);
                                                }
                                            }
                                            else if(items2[m].charAt(0) === "r") {
                                                sTemp2 = items2[m].substring(1);
                                                if(!isNaN(sTemp2)) {
                                                    obj3.r = Number(sTemp2);
                                                }
                                                else if(sTemp2 === "b")
                                                    obj3.r = 1000; //means last one
                                            }
                                            else if(items2[m].charAt(0) === "e") {
                                                sTemp2 = items2[m].substring(1);
                                                if(!isNaN(sTemp2)) {
                                                    obj3.e = Number(sTemp2);
                                                }
                                            }
                                            else if(items2[m].charAt(0) === "w") {
                                                sTemp2 = items2[m].substring(1);
                                                if(!isNaN(sTemp2)) {
                                                    obj3.w = Number(sTemp2);
                                                }
                                            }
                                            else if(items2[m].charAt(0) === "h") {
                                                sTemp2 = items2[m].substring(1);
                                                if(!isNaN(sTemp2)) {
                                                    obj3.h = Number(sTemp2);
                                                }
                                            }
                                            else if(items2[m].charAt(0) === "x") {
                                                sTemp2 = items2[m].substring(1);
                                                if(!isNaN(sTemp2)) {
                                                    obj3.x = Number(sTemp2);
                                                }
                                            }
                                            else if(items2[m].charAt(0) === "y") {
                                                sTemp2 = items2[m].substring(1);
                                                if(!isNaN(sTemp2)) {
                                                    obj3.y = Number(sTemp2);
                                                }
                                            }
                                        }
                                    }
                                }
                                if((obj3.c !== -1) || (obj3.r !== -1) || (obj3.e !== -1)  || (obj3.w !== -1)  || (obj3.h !== -1) || ((obj3.x !== -1)  && (obj3.y !== -1))) {
                                    obj.layout = JSON.parse(JSON.stringify(obj3)); // used specify where UI element is shown, c,r,e,x,y  e.g., c1;r5
                                }
                            }
                            catch {}
                        }
                        else if(items1[0] === "value") {
                            value = items1[1];
                        }
                        else if(items1[0] === "guagemin") {
                            // only used on floorplan, not dashboard
                            if(obj.guageObj === null) {
                                obj.guageObj = {};
                                obj.guageObj.type = 0;
                                obj.guageObj.guageMin = null;
                                obj.guageObj.guageMax = null;
                                obj.guageObj.guageColors = [];
                            }
                            if(!isNaN(items1[1])) 
                                obj.guageObj.guageMin = Number(items1[1]);
                        }
                        else if(items1[0] === "guagemax") {
                            // only used on floorplan, not dashboard
                            if(obj.guageObj === null) {
                                obj.guageObj = {};
                                obj.guageObj.type = 0;
                                obj.guageObj.guageMin = null;
                                obj.guageObj.guageMax = null;
                                obj.guageObj.guageColors = [];
                            }
                            if(!isNaN(items1[1])) 
                                obj.guageObj.guageMax = Number(items1[1]);
                        }
                        else if(items1[0] === "guagecolors") {
                            // only used on floorplan, not dashboard
                            if(obj.guageObj === null) {
                                obj.guageObj = {};
                                obj.guageObj.type = 0;
                                obj.guageObj.guageMin = null;
                                obj.guageObj.guageMax = null;
                                obj.guageObj.guageColors = [];
                            }
                            if(items1[1].indexOf(";") !== -1) {
                                
                                items2 = items1[1].split(";");
                            }
                            else {
                                items2 = [];
                                items2[0] = items1[1];
                            }
                            
                            for(m=0;m < items2.length; m++)
                            {
                                item3 = items2[m].trim();
                                items3 = item3.split("(");
                                
                                if(items3.length === 0) {

                                }
                                else if(items3.length === 1) {
                                    obj3 = {};
                                    obj3.value = null;
                                    obj3.color = items3[0].trim();
                                    if(obj3.color !== "")
                                        obj3.color = obj3.color.toLowerCase();
                                    obj.guageObj.guageColors.push(obj3);
                                }
                                else if (items3.length === 2) {
                                    
                                    obj3 = {};
                                    obj3.value = null;
                                    obj3.color = items3[0].trim();
                                    if(obj3.color !== "")
                                        obj3.color = obj3.color.toLowerCase();
                                    item4 = items3[1];
                                    item4 = item4.trim();
                                    if(item4.charAt(item4.length - 1) === ")") {
                                        item4 = item4.substr(0, item4.length - 1);
                                        if(!isNaN(item4)) 
                                            obj3.value = Number(item4);
                                    }
                                    obj.guageObj.guageColors.push(obj3);
                                }
                            }
                            
                        }
                        else if(items1[0] === "field") 
                            obj.field = items1[1];
                    }
                    catch {}
                }
            } //for(k=1; k < items.length; k++)
            // checkif guage
            if(obj.guageObj !== null) {
                if(obj.displayType === "g1"){
                    obj.displayType = "g"
                    obj.guageObj.type = 1;
                }
                else if(obj.displayType === "g2"){
                    obj.displayType = "g"
                    obj.guageObj.type = 2;
                }
                else if(obj.displayType === "gc1"){
                    obj.displayType = "gc"
                    obj.guageObj.type = 1;
                }
                else if(obj.displayType === "gc2"){
                    obj.displayType = "gc"
                    obj.guageObj.type = 2;
                }
                else if(obj.displayType === "m1"){
                    obj.displayType = "m"
                    obj.guageObj.type = 1; // red/yellow/green
                }
                else if(obj.displayType === "m2"){
                    obj.displayType = "m"; // red/yellow/green/yellow/red
                    obj.guageObj.type = 2; 
                }
                // move range to previous color
                for(m=1;m < obj.guageObj.guageColors.length; m++)
                {
                    obj.guageObj.guageColors[m-1].value = obj.guageObj.guageColors[m].value;
                    obj.guageObj.guageColors[m].value = null;
                }
            }
            if(value !== null) {
                bContinue2 = false;
                if((obj.displayType === "i") || (obj.displayType === "t1")) {
                    bContinue2 = true;
                    if(obj.displayType === "t1")
                            sFolder
                }
                else if (obj2 !== null) {
                    if(typeof obj2.graphicDisplayType !== "undefined") {
                        if((obj2.graphicDisplayType === "i") || (obj2.graphicDisplayType === "t1"))
                            bContinue2 = true;
                        if(obj2.graphicDisplayType === "t1")
                            sFolder
                    }
                }
                if(bContinue2) {
                    try {
                        // convert value to imageswapper value
                        obj.imageSwapper = [];
                        items2 = items1[1].split(";");
                        y = 1;
                        for(m=0;m < items2.length; m++)
                        {
                            items3 = items2[m].split(":");
                            if(items3.length === 2) {
                                items3[0] = items3[0].trim();
                                items3[1] = items3[1].trim();
                                
                                obj3 = {};
                                obj3.value = items3[0];
                                obj3.sortValue = 2;
                                obj3.test = "=";
                                
                                iPtr = obj3.value.indexOf(">=");
                                if(iPtr !== -1) {
                                    obj3.sortValue = 3;
                                    obj3.value = obj3.value.substr(iPtr + 2).trim();
                                    obj3.test = ">=";
                                    if(isNaN(obj3.value))
                                        y = 0;
                                }
                                else {
                                    iPtr = obj3.value.indexOf("=>");
                                    if(iPtr !== -1) {
                                        obj3.sortValue = 3;
                                        obj3.value = obj3.value.substr(iPtr + 2).trim();
                                        obj3.test = ">=";
                                        if(isNaN(obj3.value))
                                            y = 0;
                                    }
                                    else {
                                        iPtr = obj3.value.indexOf("<=");
                                        if(iPtr !== -1) {
                                            obj3.sortValue = 1;
                                            obj3.value = obj3.value.substr(iPtr + 2).trim();
                                            obj3.test = "<=";
                                            if(isNaN(obj3.value))
                                                y = 0;
                                        }
                                        else {
                                            iPtr = obj3.value.indexOf("=<");
                                            if(iPtr !== -1) {
                                                obj3.sortValue = 1;
                                                obj3.value = obj3.value.substr(iPtr + 2).trim();
                                                obj3.test = "<=";
                                                if(isNaN(obj3.value))
                                                    y = 0;
                                            }
                                            else {
                                                iPtr = obj3.value.indexOf(">");
                                                if(iPtr !== -1) {
                                                    obj3.sortValue = 4;
                                                    obj3.value = obj3.value.substr(iPtr + 1).trim();
                                                    obj3.test = ">";
                                                    if(isNaN(obj3.value))
                                                        y = 0;
                                                }
                                                else {
                                                    iPtr = obj3.value.indexOf("<");
                                                    if(iPtr !== -1) {
                                                        obj3.sortValue = 0;
                                                        obj3.value = obj3.value.substr(iPtr + 1).trim();
                                                        obj3.test = "<";
                                                        if(isNaN(obj3.value))
                                                        y = 0;
                                                    }
                                                    else {
                                                        iPtr = obj3.value.indexOf("=");
                                                        if(iPtr !== -1) {
                                                            obj3.sortValue = 0;
                                                            obj3.value = obj3.value.substr(iPtr + 1).trim();
                                                        }
                                                        if(isNaN(obj3.value))
                                                            y = 0;
                                                    }
                                                }
                                            }
                                        }
                                        
                                    }
                                }
                                if(sFolder !== "")
                                    obj3.image = sFolder + items3[1];  //used for both color and image
                                else 
                                    obj3.image = items3[1]; //used for both color and image
                                
                                obj.imageSwapper.unshift(obj3);
                                
                            }
                        }
                        // sort values
                        if(y === 1) {
                            
                            for(m=0;m < obj.imageSwapper.length; m++)
                            {
                                obj.imageSwapper[m].value = Number(obj.imageSwapper[m].value);
                            }
                            if(y === 1) {
                                while(bContinue2)
                                {
                                    bContinue2 = false;
                                    for(m=0;m < obj.imageSwapper.length - 1; m++)
                                    {
                                        if(obj.imageSwapper[m].value < obj.imageSwapper[m + 1].value) {
                                            y = obj.imageSwapper[m].value;
                                            obj.imageSwapper[m].value = obj.imageSwapper[m + 1].value;
                                            obj.imageSwapper[m + 1].value = y;
                                            bContinue2 = true;
                                        }
                                        else if(obj.imageSwapper[m].value === obj.imageSwapper[m + 1].value) {
                                            if(obj.imageSwapper[m].sortValue < obj.imageSwapper[m + 1].sortValue) {
                                                y = obj.imageSwapper[m].value;
                                                obj.imageSwapper[m].value = obj.imageSwapper[m + 1].value;
                                                obj.imageSwapper[m + 1].value = y;
                                                bContinue2 = true;
                                            }
                                        }
                                    }
                                }
                                // remove sortvalue
                                for(m=0;m < obj.imageSwapper.length; m++)
                                {
                                    delete obj.imageSwapper[m].sortValue;
                                }
                            }
                        }
                    }
                    catch {}
                }
            }
            if(obj.label === "") {
                obj.label = obj.datapointName;
            }
            if(obj2 !== null) {
                try {
                    if((obj2.x !== "") && (obj2.y !== "")) {
                        obj2.x = Number(obj2.x);
                        obj2.y = Number(obj2.y);
                        if(isNaN(obj2.x) || isNaN(obj2.y))
                            obj2 = null;
                        /*
                        else if((obj.displayType === "r") || (obj.displayType === "n") || (obj.displayType === "c"))
                            obj.displayType = "r";
                        else if((obj.displayType === "s2") || (obj.displayType === "l2"))
                            obj.displayType = "l2";
                        else if((obj.displayType === "s4") || (obj.displayType === "l4"))
                            obj.displayType = "l4";	
                        else */
                        else {
                            if(obj2.graphicDisplayType === "") {
                                obj2.graphicDisplayType = obj.displayType;
                            }
                            if(!((obj2.graphicDisplayType === "r") || (obj2.graphicDisplayType === "n") || (obj2.graphicDisplayType === "c")  || (obj2.graphicDisplayType === "cr")
                            || (obj2.graphicDisplayType === "i") || (obj2.graphicDisplayType === "t1")
                            || (obj2.graphicDisplayType === "s2") || (obj2.graphicDisplayType === "l2") || (obj2.graphicDisplayType === "s3") || (obj2.graphicDisplayType === "l3")
                            || (obj2.graphicDisplayType === "s4") || (obj2.graphicDisplayType === "l4")
                            || (obj2.graphicDisplayType === "lr2") || (obj2.graphicDisplayType === "lr4")
                            || (obj2.graphicDisplayType === "rbt")
                            || (obj2.graphicDisplayType === "pb") ))
                            obj2 = null;
                        }
                        if(obj2 !== null) {
                            
                            obj.x = obj2.x;
                            obj.y = obj2.y;
                            obj.padding = obj2.padding;
                            obj.paddingChar = obj2.paddingChar;
                            obj.alarmType = obj2.alarmType;
                            obj.graphicDisplayType = obj2.graphicDisplayType;
                            obj.graphicType = obj2.graphicType;
                            /*if((obj2.graphicDisplayType === "l2") || (obj2.graphicDisplayType === "l3") || (obj2.graphicDisplayType === "l4")) {
                                if(typeof obj2.color !== "undefined")
                                    obj.backgroundColor = obj2.color;
                            } */
                            if((obj2.graphicDisplayType === "l2") || (obj2.graphicDisplayType === "l3") || (obj2.graphicDisplayType === "l4")) {
                                if(typeof obj2.dashboardColor !== "undefined")
                                    obj.dashboardColor = obj2.dashboardColor;
                                if(typeof obj2.dashboardBackgroundColor !== "undefined")
                                    obj.dashboardBackgroundColor = obj2.dashboardBackgroundColor;
                                if(typeof obj2.dashboardBorderColor !== "undefined")
                                    obj.dashboardBorderColor = obj2.dashboardBorderColor;
                            }
                            else { // r and n
                                if(typeof obj2.dashboardColor !== "undefined")
                                    obj.dashboardColor = obj2.dashboardColor;
                                if(typeof obj2.dashboardBackgroundColor !== "undefined")
                                    obj.dashboardBackgroundColor = obj2.dashboardBackgroundColor;
                            }
                        }
                    }
                }
                catch {}
            }
            // add to existing devicetype or create new one
            
        }
        catch {}
        
    return obj; // 
}
function addImageForContext(sid, contextType,contextName,image,imageWidth,imageHeight,location, bLocationAboveImage) {
    // only supports campus and building
    try {
        var obj = {};

        obj.bLocationAboveImage = true;
        if(bLocationAboveImage !== null) {
            if(typeof bLocationAboveImage === "boolean")
                obj.bLocationAboveImage = bLocationAboveImage;
        }
        obj.sid = sid;
        if(contextType !== null) {
            contextType = contextType.toLowerCase();
        }
        if(contextName !== null) {
            contextName = contextName.toLowerCase();
        }
        obj.contextType = contextType
        obj.contextName = contextName;
        //obj.deviceTypeName = deviceType;
        obj.image = image;
        obj.width = imageWidth;
        obj.height = imageHeight;
        obj.location = location;
        g_contextImages.push(obj);
    }
    catch {}
}
function addCustomTag(tagStr) {

    addCustomTag1(null, null,tagStr);
}
function addDashboardCustomTag(dashboardName, sid, tagStr) {

    addCustomTag1(dashboardName, sid, tagStr);

}
function addCustomTag1(dashboardName, sid,tagStr) {
    // only supports campus and building
    try {
        var obj = {};
        var i, z, obj, items, items1;
        var tagName = "", tagName1 = "", tagValue = "", tagNameName = "", tagNameType = "";
        var iPtr,iPtr1;
        if(typeof tagStr === "string") {
            iPtr = tagStr.indexOf(":");
            if(iPtr !== -1) {
                tagName = tagStr.substr(0,iPtr).trim();
                tagValue = tagStr.substr(iPtr + 1).trim();
                tagNameType = "";
                iPtr = tagName.indexOf("_");
                iPtr1 = tagName.indexOf(".");
                if(iPtr1 > iPtr) {
                    tagName1 = tagName.substr(0,iPtr).trim();
                    tagNameName = tagName.substring(iPtr + 1, iPtr1).toLowerCase().trim();
                    tagNameType = tagName.substring(iPtr1 + 1).toLowerCase().trim();  // .dp
                } 
                if(tagName1 === "dashboard") {
                    // check if tagNameType already in 
                    z = -1;
                    if(tagNameType !== "") {
                        for(i=0; i < g_siteDashboardReplacementList.length; i++)
                        {
                            //if(g_siteDashboardReplacementList[i].tagNameName === tagNameName) {
                            if(g_siteDashboardReplacementList[i].tagName === tagName1) {
                                z = i;
                                break;
                            }
                        }
                        if(z === -1) {
                            obj = {};
                            obj.name = [];
                            //obj.tagNameName = tagNameName;
                            obj.tagName = tagName1;
                            obj.type = "";
                            obj.image = "";
                            obj.width = "";
                            obj.height = "";
                            obj.dpList = [];
                            obj.colorOn = g_sDashboardLedOffColor;
                            obj.colorOff = g_sDashboardLedOffColor;
                            obj.colorBorder = g_sDashboardLedBorderColor;
                            obj.layout = null;
                            obj.imageLayout = null;
                            obj.icons = null;
                            g_siteDashboardReplacementList.push(JSON.parse(JSON.stringify(obj)));
                            z = g_siteDashboardReplacementList.length - 1;

                        }
                        if(z !== -1) {
                            if(tagNameType.startsWith("dp")) {
                                obj = {};
                                obj = deviceTypeAddDashboardDpObjStr(tagName, tagValue);
                                if(obj !== null) {
                                    if(Object.keys(obj).length > 0)
                                        g_siteDashboardReplacementList[z].dpList.push(JSON.parse(JSON.stringify(obj)));
                                }
                            }
                            else if(tagNameType.startsWith("image") || tagNameType.startsWith("icon") || tagNameType.startsWith("color")) {
                                deviceTypeAddDashboardImage(tagNameType, tagValue);
                            }
                            else if(tagNameType.startsWith("layout")) {
                                deviceTypeAddDashboardLayout(tagNameType, tagValue);
                            }
                        }
                    }
                }
                else if (tagName1 === "map") {
					
					// devicetype_pulsegen.dp1: (9FFFFF0501840460)/device/0/nviLamp1, Lamp1, displaytype=s4, context=floor;room
					// devicetype_pulsegen.image:  devicetype=(9FFFFF0501840460),url=images/user/ft6050_device.jpg,width=null,height=null
					//g_oMapDashboard
					try {
                        if(tagNameType.startsWith("dp")) {
                            if(g_oMapDashboard === null) {
                                g_oMapDashboard = {};
                                g_oMapDashboard.iShowContextNames = 0;
                                g_oMapDashboard.bClickToDevice = true;
                                g_oMapDashboard.dpList = [];
                                g_oMapDashboard.bShowDashboard = true;
                                g_oMapDashboard.name = "";
                                g_oMapDashboard.bReadOnly = false;
                            }
                            obj = {};
                            //obj.name = tagName + " ";
                            //obj.parameters = tagValue;
                            //obj.type = "map";
                            obj = deviceTypeAddDashboardDpObjStr(tagName, tagValue);
                            if(obj !== null) {
                                if(Object.keys(obj).length > 0)
                                    g_oMapDashboard.dpList.push(JSON.parse(JSON.stringify(obj)));
                            }

                        }
                        else if(sTemp2.startsWith("layout")) {
                            // .layout: layout=cre, table=c2;r3;e2, ewidth=300, eheight=200
                            items = tagValue.split(",");
                            for(i=0; i < items.length; i++)
                            {
                                if(items[i] !== "") {
                                    items1 = items[i].split("=");
                                    if(items1.length === 2) {
                                        items1[0] = items1[0].trim().toLowerCase();
                                        items1[1] = items1[1].trim();
                                        
                                        
                                        if(items1[0] === "name") {
                                            if(g_oMapDashboard === null) {
                                                g_oMapDashboard = {};
                                                g_oMapDashboard.iShowContextNames = 0;
                                                g_oMapDashboard.bClickToDevice = true;
                                                g_oMapDashboard.dpList = [];
                                                g_oMapDashboard.bShowDashboard = true;
                                                g_oMapDashboard.name = "";
                                                g_oMapDashboard.bReadOnly = false;
                                            }
                                            g_oMapDashboard.name = items1[1];
                                        }
                                        else if(items1[0] === "showcontextnames") {
                                            if(g_oMapDashboard === null) {
                                                g_oMapDashboard = {};
                                                g_oMapDashboard.iShowContextNames = 0;
                                                g_oMapDashboard.bClickToDevice = true;
                                                g_oMapDashboard.dpList = [];
                                                g_oMapDashboard.bShowDashboard = true;
                                                g_oMapDashboard.name = "";
                                                g_oMapDashboard.bReadOnly = false;
                                            }
                                            g_oMapDashboard.iShowContextNames = items1[1];
                                        }
                                        else if(items1[0] === "datapointclick") {
                                            if(g_oMapDashboard === null) {
                                                g_oMapDashboard = {};
                                                g_oMapDashboard.iShowContextNames = 0;
                                                g_oMapDashboard.bClickToDevice = true;
                                                g_oMapDashboard.dpList = [];
                                                g_oMapDashboard.bShowDashboard = true;
                                                g_oMapDashboard.name = "";
                                                g_oMapDashboard.bReadOnly = false;
                                            }
                                            if(items1[1] === "1")
                                                g_oMapDashboard.bClickToDevice = true;
                                            else if(items1[1] === "0")
                                                g_oMapDashboard.bClickToDevice = false;
                                        }
                                        else if(items1[0] === "readonly") {
                                            if(g_oMapDashboard === null) {
                                                g_oMapDashboard = {};
                                                g_oMapDashboard.iShowContextNames = 0;
                                                g_oMapDashboard.bClickToDevice = true;
                                                g_oMapDashboard.dpList = [];
                                                g_oMapDashboard.bShowDashboard = true;
                                                g_oMapDashboard.name = "";
                                                g_oMapDashboard.bReadOnly = false;
                                            }
                                            if(items1[1] === "1")
                                                g_oMapDashboard.bReadOnly = true;
                                            else if(items1[1] === "0")
                                                g_oMapDashboard.bReadOnly = false;
                                        }
                                    }
                                }
                            }
                        }
					}
					catch {}
					
				}
                else if(tagName1 === "devicetype") {

                }
                else {
                    // only supports campus and building
                    if((tagName !== "") && (tagValue !== ""))
                        g_oGlobalTags[tagName] = tagValue;
                }
            }
        }
    }
    catch {}
}
function addCustomTagPair(tagName, tagValue) {
    // only supports campus and building
    try {
        var obj = {};
        if((typeof tagName === "string") && (typeof tagValue === "string")) {
            if((tagName !== "") && (tagValue !== "")) {
                
                g_oGlobalTags.push(tagName + ": " + tagValue);
            }
        }
    }
    catch {}
}
