/******************************************************************
 *  demo()
 * 
 * demo() is used to define auto created Dashboard or Map dashboard if Custom tags don't exists and device match the device types defined in this file
 * For a starter kit, expected device names are (Thermostat-01, Adam-DIO-01, SC100-DIO-01 and Multi-Sensor-01)
 * 
 * 	Copyright (C) 2023 EnOcean GmbH.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	EnOcean Example Software License Agreement which is available at
 *	https://enoceanwiki.atlassian.net/wiki/spaces/LON/pages/2425260/Example+Software+License+Agreement. 
*/
var g_oDemoDashboardDeviceTypeList = null;
function demoCheckForDashboardDevices() {
    try {
        var obj, i, j, bAtLeastOneDevice = false;
        var dpNum = 0; // used to order dps on dashboard
        var iCount = 0, iCount1 = 0;
        var bTooManyDps = false;
        var bContinue = true;
        var bStarterKit = false;
        var iMaxAllowedForDpPerRow = 60;
        var iMaxAllowed = 100;
        var bAddAtLeastOneChartDevice = true;
        g_siteDashboardReplacementList = [];

        if(g_bPlanningAutoDetectDevces) {
            if(g_campusTags.hasOwnProperty("dashboard")) {
                if(g_campusTags.dashboard.length > 0)
                    return;
            }

            g_oDemoDashboardDeviceTypeList = [];
            obj = {};
            obj = {protocol:"bacnet",name:"thermostat",deviceList: [],programId:""};
            g_oDemoDashboardDeviceTypeList.push(JSON.parse(JSON.stringify(obj)));
            obj = {};
            obj = {protocol:"modbus",name:"adam",deviceList: [],programId:"9F0096052804DB01"};
            g_oDemoDashboardDeviceTypeList.push(JSON.parse(JSON.stringify(obj)));
            obj = {};
            obj = {protocol:"lon",name:"multisenor",deviceList: [],programId:"9FFFFF0501840460"};
            g_oDemoDashboardDeviceTypeList.push(JSON.parse(JSON.stringify(obj)));
            obj = {};
            obj = {protocol:"lon",name:"sc100",deviceList: [],programId:"90000F0501EF0407"};
            g_oDemoDashboardDeviceTypeList.push(JSON.parse(JSON.stringify(obj)));
            obj = {};
            obj = {protocol:"lon",name:"pulsegen",deviceList: [],programId:"900001153C000405"};
            g_oDemoDashboardDeviceTypeList.push(JSON.parse(JSON.stringify(obj)));
            obj = {};
            obj = {protocol:"lon",name:"cpdsim",deviceList: [],programId:"800001230E041005"};
            g_oDemoDashboardDeviceTypeList.push(JSON.parse(JSON.stringify(obj)));
            obj = {};
            obj = {protocol:"enocean",name:"enoceandoublerockerswitch",deviceList: [],programId:"8A000BF60204E001"};  //EDRPU
            g_oDemoDashboardDeviceTypeList.push(JSON.parse(JSON.stringify(obj)));
            obj = {};
            obj = {protocol:"enocean",name:"enoceansinglerockerswitch",deviceList: [],programId:"8A000BF60204E002"}; //ESRPU
            g_oDemoDashboardDeviceTypeList.push(JSON.parse(JSON.stringify(obj)));
            obj = {};
            obj = {protocol:"enocean",name:"enoceanOSxUOccupancySensor",deviceList: [],programId:"8A000BA50701E001"};
            g_oDemoDashboardDeviceTypeList.push(JSON.parse(JSON.stringify(obj)));
            obj = {};
            obj = {protocol:"enocean",name:"enoceanstm550multisensor",deviceList: [],programId:"8A000BD21441E001"};
            g_oDemoDashboardDeviceTypeList.push(JSON.parse(JSON.stringify(obj)));
            obj = {};
            obj = {protocol:"enocean",name:"enoceanenoceanELLSULightLevel",deviceList: [],programId:"8A000BA50602E001"};
            g_oDemoDashboardDeviceTypeList.push(JSON.parse(JSON.stringify(obj)));
            obj = {};
            obj = {protocol:"enocean",name:"enoceanETHSUTempHumSensor",deviceList: [],programId:"8A000BA50403E001"};
            g_oDemoDashboardDeviceTypeList.push(JSON.parse(JSON.stringify(obj)));
            obj = {};
            obj = {protocol:"enocean",name:"enoceanEMDCUMotionLightSensor",deviceList: [],programId:"8A000BA50703E001"};
            g_oDemoDashboardDeviceTypeList.push(JSON.parse(JSON.stringify(obj)));
            obj = {};
            obj = {protocol:"enocean",name:"noceanEMCSUmagnetcontactSensor",deviceList: [],programId:"8A000BD50001E001"};
            g_oDemoDashboardDeviceTypeList.push(JSON.parse(JSON.stringify(obj)));
            obj = {};
            obj = {protocol:"lorawan",name:"Milesight_AM319",deviceList: [],programId:"8002590A5A04E100"}; //Milesight_AM319
            g_oDemoDashboardDeviceTypeList.push(JSON.parse(JSON.stringify(obj)));
            obj = {};
            obj = {protocol:"lorawan",name:"Milesight_WS301",deviceList: [],programId:"8002590A5A04E103"}; //Milesight_AM319
            g_oDemoDashboardDeviceTypeList.push(JSON.parse(JSON.stringify(obj)));
            
            for(i=0; i < deviceListAll.length; i++)
            {
                if(deviceListAll[i].category !== "SC") {
                    for(j = 0; j <  g_oDemoDashboardDeviceTypeList.length; j++)
                    {
                        if(deviceListAll[i].protocol === "bacnet") {
                            if(g_oDemoDashboardDeviceTypeList[j].name === "thermostat") {
                                if(deviceListAll[i].name.toLowerCase().startsWith("thermostat-")) {
                                    bAtLeastOneDevice = true;
                                    g_oDemoDashboardDeviceTypeList[j].deviceList.push(JSON.parse(JSON.stringify(deviceListAll[i])))
                                    break;
                                }
                            }
                        }
                        else if(deviceListAll[i].protocol === g_oDemoDashboardDeviceTypeList[j].protocol) {
                            if(g_oDemoDashboardDeviceTypeList[j].programId !== "" ) {
                                if(g_oDemoDashboardDeviceTypeList[j].programId ===  deviceListAll[i].programId) {
                                    bAtLeastOneDevice = true;
                                    g_oDemoDashboardDeviceTypeList[j].deviceList.push(JSON.parse(JSON.stringify(deviceListAll[i])))
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            if(bAtLeastOneDevice) {
                dpNum = 0;
                
                obj = demoGetDeviceTypeListObj("thermostat");
                if(obj !== null) {
                    if(obj.deviceList.length > 0) {
                        obj = demoGetDeviceTypeListObj("adam");
                        if(obj !== null) {
                            if(obj.deviceList.length > 0) {
                                obj = demoGetDeviceTypeListObj("multisenor");
                                if(obj !== null) {
                                    if(obj.deviceList.length > 0) {
                                        obj = demoGetDeviceTypeListObj("sc100");
                                        if(obj !== null) {
                                            if(obj.deviceList.length > 0) 
                                                //starter kit
                                                demoAddStarterKitDashboard();
                                                if(g_siteDashboardReplacementList.length > 0) {
                                                    if(g_siteDashboardReplacementList[0].dpList.length > 0) {
                                                        dpNum = g_siteDashboardReplacementList[0].dpList.length;
                                                        iCount = dpNum;
                                                        iCount1 = iCount;
                                                        bStarterKit = true;
                                                        bAddAtLeastOneChartDevice = false;
                                                    }
                                                }
                                        }  
                                    }
                                    
                                }   
                            }
                        }
                    }
                }
                // determine if too many datapoints
                for(j = 0; j <  g_oDemoDashboardDeviceTypeList.length; j++)
                {
                    if(g_oDemoDashboardDeviceTypeList[i].deviceList.length > 0) {
                        if(g_oDemoDashboardDeviceTypeList[i].deviceList.name === "multisenor") 
                            iCount += 7;
                        else if (g_oDemoDashboardDeviceTypeList[i].deviceList.name === "sc100") 
                            iCount += 7;
                        else if (g_oDemoDashboardDeviceTypeList[i].deviceList.name === "Milesight_AM319") 
                            iCount += 6;
                        else 
                            iCount ++;
                    }
                }
                if(iCount > iMaxAllowedForDpPerRow) {
                    bTooManyDps = true; // this is used for MultiSensor and PulseGen. bTooManyDps then use one row per device instead od one row per datapoint
                }
                if(bContinue) {
                    obj = demoGetDeviceTypeListObj("pulsegen");
                    if(obj !== null) {
                        if(obj.deviceList.length > 0) {
                            try {
                                for(i=0; i < obj.deviceList.length; i++)
                                {
                                    dpNum += 7;
                                    iCount1+= 7;
                                    if(bAddAtLeastOneChartDevice) {
                                        demoAddPulseGenDpList(dpNum, obj.deviceList[i].name);
                                        bAddAtLeastOneChartDevice = false;
                                    }
                                    else 
                                        demoAddPulseGenDpListSingleRow(dpNum, obj.deviceList[i].name);
                                    if(iCount1 > iMaxAllowed) {
                                        bContinue = false;
                                        break;
                                    }
                                }
                            } catch {}
                        }
                    }
                }
                if(bContinue) {
                    obj = demoGetDeviceTypeListObj("multisenor");
                    if(obj !== null) {
                        if(obj.deviceList.length > 0) {
                            try {
                                for(i=0; i < obj.deviceList.length; i++)
                                {
                                    if(!bStarterKit || (bStarterKit && obj.deviceList[i].name.toLowerCase() !== "multi-sensor-01")) {
                                        dpNum += 7;
                                        iCount1+= 7;
                                        if(bAddAtLeastOneChartDevice) {
                                            demoAddSensorDpList(dpNum, obj.deviceList[i].name);
                                            bAddAtLeastOneChartDevice = false;
                                        }
                                        else 
                                            demoAddSensorDpListSingleRow(dpNum, obj.deviceList[i].name);
                                        if(iCount1 > iMaxAllowed) {
                                            bContinue = false;
                                            break;
                                        }
                                    }
                                }
                            } catch {}
                        }
                    }
                }
                if(bContinue) {
                    obj = demoGetDeviceTypeListObj("cpdsim");
                    if(obj !== null) {
                        if(obj.deviceList.length > 0) {
                            try {
                                for(i=0; i < obj.deviceList.length; i++)
                                {
                                    dpNum ++;
                                    iCount1+= 7;
                                    demoAddCPDSimDpList(dpNum, obj.deviceList[i].name);
                                    if(iCount1 > iMaxAllowed) {
                                        bContinue = false;
                                        break;
                                    }
                                }
                            } catch {}
                        }
                    }
                }
                if(bContinue) {
                    obj = demoGetDeviceTypeListObj("enoceansinglerockerswitch");
                    if(obj !== null) {
                        if(obj.deviceList.length > 0) {
                            try {
                                for(i=0; i < obj.deviceList.length; i++)
                                {
                                    dpNum ++;
                                    iCount1++;
                                    demoAddEnoceanSingleRockerSwitchDpList(dpNum, obj.deviceList[i].name);
                                    if(iCount1 > iMaxAllowed) {
                                        bContinue = false;
                                        break;
                                    }
                                }
                            } catch {}
                        }
                    }
                }
                if(bContinue) {
                    obj = demoGetDeviceTypeListObj("enoceandoublerockerswitch");
                    if(obj !== null) {
                        if(obj.deviceList.length > 0) {
                            try {
                                for(i=0; i < obj.deviceList.length; i++)
                                {
                                    dpNum += 2;
                                    iCount1+= 2;
                                    demoAddEnoceanDoubleRockerSwitchDpList(dpNum, obj.deviceList[i].name);
                                    if(iCount1 > iMaxAllowed) {
                                        bContinue = false;
                                        break;
                                    }
                                }
                            } catch {}
                        }
                    }
                }
                if(bContinue) {
                    obj = demoGetDeviceTypeListObj("enoceanstm550multisensor");
                    if(obj !== null) {
                        if(obj.deviceList.length > 0) {
                            try {
                                for(i=0; i < obj.deviceList.length; i++)
                                {
                                    dpNum += 7;
                                    iCount1+= 7;
                                    demoAddEnoceanstm550MultisensorDpList(dpNum, obj.deviceList[i].name);
                                    if(iCount1 > iMaxAllowed) {
                                        bContinue = false;
                                        break;
                                    }
                                }
                            } catch {}
                        }
                    }
                }
                if(bContinue) {
                    obj = demoGetDeviceTypeListObj("enoceanETHSUTempHumSensor");
                    if(obj !== null) {
                        if(obj.deviceList.length > 0) {
                            try {
                                for(i=0; i < obj.deviceList.length; i++)
                                {
                                    dpNum += 7;
                                    iCount1+= 7;
                                    demoAddEnoceanETHSUTempHumDpList(dpNum, obj.deviceList[i].name);
                                    if(iCount1 > iMaxAllowed) {
                                        bContinue = false;
                                        break;
                                    }
                                }
                            } catch {}
                        }
                    }
                }
                if(bContinue) {
                    obj = demoGetDeviceTypeListObj("enoceanELLSULightLevelSensor");
                    if(obj !== null) {
                        if(obj.deviceList.length > 0) {
                            try {
                                for(i=0; i < obj.deviceList.length; i++)
                                {
                                    dpNum += 2;
                                    iCount1+= 2;
                                    demoAddEnoceanELLSULightLevelDpList(dpNum, obj.deviceList[i].name);
                                    if(iCount1 > iMaxAllowed) {
                                        bContinue = false;
                                        break;
                                    }
                                }
                            } catch {}
                        }
                    }
                }
                if(bContinue) {
                    obj = demoGetDeviceTypeListObj("enoceanOSxUOccupancySensor");
                    if(obj !== null) {
                        if(obj.deviceList.length > 0) {
                            try {
                                for(i=0; i < obj.deviceList.length; i++)
                                {
                                    dpNum += 2;
                                    iCount1+= 2;
                                    demoAddEnoceanEOSxUOccupancyDpList(dpNum, obj.deviceList[i].name);
                                    if(iCount1 > iMaxAllowed) {
                                        bContinue = false;
                                        break;
                                    }
                                }
                            } catch {}
                        }
                    }
                }
                if(bContinue) {
                    obj = demoGetDeviceTypeListObj("enoceanEMDCUMotionLightSensor");
                    if(obj !== null) {
                        if(obj.deviceList.length > 0) {
                            try {
                                for(i=0; i < obj.deviceList.length; i++)
                                {
                                    dpNum += 3;
                                    iCount1+= 3;
                                    demoAddEnoceanEMDCUMotionLightDpList(dpNum, obj.deviceList[i].name);
                                    if(iCount1 > iMaxAllowed) {
                                        bContinue = false;
                                        break;
                                    }
                                }
                            } catch {}
                        }
                    }
                }
                if(bContinue) {
                    obj = demoGetDeviceTypeListObj("enoceanEMCSUmagnetcontactSensor"); 
                    if(obj !== null) {
                        if(obj.deviceList.length > 0) {
                            try {
                                for(i=0; i < obj.deviceList.length; i++)
                                {
                                    dpNum += 7;
                                    iCount1+= 7;
                                    demoAddEnoceanEMCSUmagnetcontactDpList(dpNum, obj.deviceList[i].name);
                                    if(iCount1 > iMaxAllowed) {
                                        bContinue = false;
                                        break;
                                    }
                                }
                            } catch {}
                        }
                    }
                }
                if(bContinue) {
                    obj = demoGetDeviceTypeListObj("Milesight_AM319");
                    if(obj !== null) {
                        if(obj.deviceList.length > 0) {
                            try {
                                for(i=0; i < obj.deviceList.length; i++)
                                {
                                    dpNum += 2;
                                    iCount1+= 2;
                                    demoAddMilesight_AM319DpList(dpNum, obj.deviceList[i].name);
                                    if(iCount1 > iMaxAllowed) {
                                        bContinue = false;
                                        break;
                                    }
                                }
                            } catch {}
                        }
                    }
                }
                if(bContinue) {
                    obj = demoGetDeviceTypeListObj("Milesight_WS301");
                    if(obj !== null) {
                        if(obj.deviceList.length > 0) {
                            try {
                                for(i=0; i < obj.deviceList.length; i++)
                                {
                                    dpNum += 2;
                                    iCount1+= 2;
                                    demoAddMilesight_WS301DpList(dpNum, obj.deviceList[i].name);
                                    if(iCount1 > iMaxAllowed) {
                                        bContinue = false;
                                        break;
                                    }
                                }
                            } catch {}
                        }
                    }
                }
                
            }
            else 
                g_oDemoDashboardDeviceTypeList = null;
        }
    }
    catch 
    {
        g_oDemoDashboardDeviceTypeList = null;
    }
    try {
        if(g_oDemoDashboardDeviceTypeList.length > 0) {
            obj = JSON.parse(JSON.stringify(g_oDemoDashboardDeviceTypeList));
            g_oDemoDashboardDeviceTypeList = [];
            for(i=0;i < obj.length; i++ )
            {
                if(obj[i].deviceList.length > 0) {
                    for(j=0; j < obj[i].deviceList.length; j++)
                    {
                        if(obj[i].deviceList[j].status.state === "provisioned") {
                            g_oDemoDashboardDeviceTypeList.push(JSON.parse(JSON.stringify(obj[i])));
                            i = obj.length + 2;  // only need to see one provisioned device
                            break;
                        }
                    }
                }
            }
            if(g_oDemoDashboardDeviceTypeList.length === 0)
                g_oDemoDashboardDeviceTypeList = null;
            else if(g_siteDashboardReplacementList.length > 0) {
                if(!g_campusTags.hasOwnProperty("dashboard")) 
                    g_campusTags.dashboard = [];
                g_campusTags.dashboard.push(JSON.parse(JSON.stringify(g_siteDashboardReplacementList[0])));
            }
        }
        else 
            g_oDemoDashboardDeviceTypeList = null;
    }
    catch 
    {
        g_oDemoDashboardDeviceTypeList = null;
    }
} 
function demoAddSensorDpList(dpNum, name) {
    // Global Tags - same as Campus Tags - not currently supported
    // used to reduce number of datapoints displayed and adds picture
    try {

        addCustomTag("dashboard_sensor.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Lamp/0/nviLamp, label=LampIn 1, displaytype=s3, color=orange");
        addCustomTag("dashboard_sensor.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Lamp/0/nvoLampFb, label=LampOut 1, displaytype=l3,color=orange dashboard=100;405");
        addCustomTag("dashboard_sensor.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Lamp/1/nviLamp,label= LampIn 2, displaytype=s4");
        addCustomTag("dashboard_sensor.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Lamp/1/nvoLampFb, label=LampOut 2, displaytype=l4,dashboard=250;405;l4;mediumblue");
        addCustomTag("dashboard_sensor.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/LightSensor/0/nvoLightLevel, label=Light Level, units=lux, displaytype=r;c,dashboard=100;310");
        addCustomTag("dashboard_sensor.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/TempSensor/0/nvoTemperature, label=Temp, displaytype=r;c, units=°C,dashboard=200;310, precision=1");
        addCustomTag("dashboard_sensor.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Switch/0/nvoSwitch, label=SwitchOut 1, displaytype=l4,dashboard=60;405");
        addCustomTag("dashboard_sensor.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Switch/1/nvoSwitch, label=SwitchOut 2, displaytype=l4,dashboard=210;405");
        //addCustomTag("devicetype_sensor.image: devicetype=(9FFFFF0501840460),image=images/user/ft6050_device.jpg,width=null,height=null");
    }
    catch {}
}
function demoAddSensorDpListSingleRow(dpNum, name) {
    try {
        addCustomTag("dashboard_sensor.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Switch/0/nvoSwitch, label=SwitchOut 1, displaytype=ms");
        addCustomTag("dashboard_sensor.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Lamp/0/nvoLampFb, label=LampOut 1, displaytype=ms1,color=orange");
        addCustomTag("dashboard_sensor.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Switch/1/nvoSwitch, label=SwitchOut 2, displaytype=ms1");
        addCustomTag("dashboard_sensor.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Lamp/1/nvoLampFb, label=LampOut 2, displaytype=ms1");
        addCustomTag("dashboard_sensor.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/LightSensor/0/nvoLightLevel, label=Light Level, units=lux, displaytype=ms1");
        addCustomTag("dashboard_sensor.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/TempSensor/0/nvoTemperature, label=Temp, displaytype=ms1, units=°C, precision=1");
    }
    catch {}
}
function demoAddCPDSimDpList(dpNum, name) {
    try {
        addCustomTag("dashboard_cpdsim.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/LuminairCntrl/0/nvoLampFb, label=" + name + ", field=setting/value, displaytype=l7");
        
    }
    catch {}
}

function demoAddEnoceanSingleRockerSwitchDpList(dpNum, name) {
    try {
        addCustomTag("dashboard_enoceansinglerocker.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Rocker B/1/Switch B, label=" + name + " Rocker Switch, displaytype=l5");
        
    }
    catch {}
}
function demoAddEnoceanDoubleRockerSwitchDpList(dpNum, name) {
    try {
        //addCustomTag("dashboard_enoceandoublerocker.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Rocker B/2/Switch B, label=" + name + " Left Rocker Switch, displaytype=l5");
        //addCustomTag("dashboard_enoceandoublerocker.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Rocker A/1/Switch A, label=" + name + " Right Rocker Switch, displaytype=l5");
        //addCustomTag("dashboard_enoceandoublerocker.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "Rocker A/1/Switch A, label=" + name + ", field=setting/value, displaytype=l5d");
         // double rocker
         addCustomTag("dashboard_enoceandoublerocker.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Rocker B/2/Switch B, label=EnOcean Double Rocker SW,displaytype=l5d");
         addCustomTag("dashboard_enoceandoublerocker.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Rocker A/1/Switch A, label=EnOcean Double Rocker SW,displaytype=l5d1");
    }
    catch {}
}
function demoAddEnoceanstm550MultisensorDpList(dpNum, name) {
    try {
        addCustomTag("dashboard_enoceanstm550.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Luminance/3/Luminance, label=" + name + " Light Sensor,displaytype=r,units=lux");
        addCustomTag("dashboard_enoceanstm550.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Temperature/1/Temperature, label=" + name + " Temperature,displaytype=r,units=°C");
        addCustomTag("dashboard_enoceanstm550.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Humidity/2/Humidity, label=" + name + " Humidity,displaytype=r,units=%");
        addCustomTag("dashboard_enoceanstm550.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Contact State/5/Contact State, label=" + name + " Contact,displaytype=l2");
        addCustomTag("dashboard_enoceanstm550.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Acceleration/4/Acceleration Status, label=" + name + " Acceleration,displaytype=r");
        
        addCustomTag("dashboard_enoceanstm550.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Acceleration/4/Acceleration X, label=" + name + " Acceleration X,displaytype=r");
        addCustomTag("dashboard_enoceanstm550.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Acceleration/4/Acceleration Y, label=" + name + " Acceleration Y,displaytype=r");
        addCustomTag("dashboard_enoceanstm550.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "Acceleration/4/Acceleration Z, label=" + name + " Acceleration Z,displaytype=r");
        
    }
    catch {}
}
function demoAddEnoceanETHSUTempHumDpList(dpNum, name) {
    try {
         addCustomTag("dashboard_enoceanETHSUTempHum.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Temperature/2/Temperature, label=ETHUSU Temperture,displaytype=r,units=°C");
         addCustomTag("dashboard_enoceanETHSUTempHum.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Humidity/1/Humidity, label=ETHUSU Humidity,displaytype=r,units=%");
    }
    catch {}
}
function demoAddEnoceanELLSULightLevelDpList(dpNum, name) {
    try { //8A000BA50602E001
         addCustomTag("dashboard_enoceanELLSULightLevelSensors.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Luminance/2/Luminance, label=ELLSU Luminance,displaytype=r,units=lux");
         addCustomTag("dashboard_enoceanELLSULightLevelSensors.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Voltage/1/Voltage, label=ELLSU Humidity,displaytype=r,units=%");
    }
    catch {}
}
function demoAddEnoceanEOSxUOccupancyDpList(dpNum, name) {
    try { //8A000BA50701E001
         addCustomTag("dashboard_enoceanEOSxUOccupancySensors.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Occupied/2/Occupied, label=ETHUSU Occupancy,displaytype=l2,color=mediumblue");
         addCustomTag("dashboard_enoceanEOSxUOccupancySensors.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Voltage/1/Voltage, label=ETHUSU Humidity,displaytype=r,units=%");
    }
    catch {}
}
function demoAddEnoceanEMDCUMotionLightDpList(dpNum, name) {
    try { //8A000BA50703E001
         addCustomTag("dashboard_enoceanEMDCUMotionLightSensors.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Luminance/2/Luminance, label=EMDCU Luminance,displaytype=r,units=lux");
         addCustomTag("dashboard_enoceanEMDCUMotionLightSensors.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Occupied/3/Occupied, label=EMDCU Humidity,displaytype=r,units=%");
         addCustomTag("dashboard_enoceanEMDCUMotionLightSensors.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Voltage/1/Voltage, label=EMDCU Voltage,displaytype=r,color=mediumblue");
    }
    catch {}
}
function demoAddEnoceanEMCSUmagnetcontactDpList(dpNum, name) {
    try { //8A000BD50001E001
         addCustomTag("dashboard_enoceanEMCSUmagnetcontactSensors.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Contact State/1/Contact State, label=EMCS Contact,displaytype=l2,color=mediumblue");
    }
    catch {}
}
function demoAddMilesight_AM319DpList(dpNum, name) {
    // Global Tags - same as Campus Tags - not currently supported
    // used to reduce number of datapoints displayed and adds picture
    try {

        addCustomTag("dashboard_milesightam31.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Sensors/0/Temperature, label=" + name + " Temperature, displaytype=r, units=°C");
        addCustomTag("dashboard_milesightam31.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Sensors/0/Light Level, label=" + name + " Light Level, displaytype=r, units=lux");
        addCustomTag("dashboard_milesightam31.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Sensors/0/Pressure, label=" + name + " Pressure, displaytype=r");
        addCustomTag("dashboard_milesightam31.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Sensors/0/CO2, label=" + name + " CO2, displaytype=r");
        addCustomTag("dashboard_milesightam31.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Sensors/0/Humidity, label=" + name + " Humidity, displaytype=r, units=%");
        addCustomTag("dashboard_milesightam31.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Sensors/0/PIR, label=" + name + " Occupancy, displaytype=r, units=lux");
        
    }
    catch {}
}
function demoAddMilesight_WS301DpList(dpNum, name) {
    try {
        addCustomTag("dashboard_milesight_ws301.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/Sensors/0/Temperature, label=" + name + " Contact Switch, displaytype=r");
    }
    catch {}
}
function demoAddPulseGenDpList(dpNum, name) {
    // Global Tags - same as Campus Tags - not currently supported
    // used to reduce number of datapoints displayed and adds picture
    try {
        addCustomTag("dashboard_pulsegen.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/device/0/nviLamp1, label=LampIn 1a, displaytype=s4");
        addCustomTag("dashboard_pulsegen.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/device/0/nvoLamp1, label=LampOut 1a, displaytype=l4");
        addCustomTag("dashboard_pulsegen.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/device/0/nviLamp2, label=LampIn 1b, displaytype=s3,color=orange");
        addCustomTag("dashboard_pulsegen.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/device/0/nvoLamp2, label=LampOut 1b, displaytype=l3,color=mediumblue");
        addCustomTag("dashboard_pulsegen.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/device/0/nvoSwitch1, label=SwitchOut 1a, displaytype=l4");
        addCustomTag("dashboard_pulsegen.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/device/0/nvoSwitch2, label=SwitchOut 1b, displaytype=l4");
        addCustomTag("dashboard_pulsegen.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/device/0/nvoPulseOut, label=PulseOut, displaytype=c");
        addCustomTag("dashboard_pulsegen.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/device/0/nvoLuxLevel, label=Light Level 1, displaytype=r;c, units=lux");
        addCustomTag("dashboard_pulsegen.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/device/0/nvoHVACTemp, label=Temp 1, displaytype=r;c,units=°C, precision=1");
    }
    catch {}
}
function demoAddPulseGenDpListSingleRow(dpNum, name) {
    // Global Tags - same as Campus Tags - not currently supported
    // used to reduce number of datapoints displayed and adds picture
    try {
        addCustomTag("dashboard_pulsegen.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/device/0/nvoSwitch1, label=LampOut 1a, displaytype=pg");
        addCustomTag("dashboard_pulsegen.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/device/0/nvoLamp1, label=LampOut 1a, displaytype=pg1,color=mediumblue");
        addCustomTag("dashboard_pulsegen.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/device/0/nvoSwitch2, label=LampOut 1b, displaytype=pg1");
        addCustomTag("dashboard_pulsegen.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/device/0/nvoLamp2, label=LampOut 1b, displaytype=pg1,color=mediumblue");
        addCustomTag("dashboard_pulsegen.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/device/0/nvoLuxLevel, label=Light Level 1, displaytype=pg1, units=lux");
        addCustomTag("dashboard_pulsegen.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/device/0/nvoHVACTemp, label=Temp 1, displaytype=pg1,units=°C, precision=1");
        addCustomTag("dashboard_pulsegen.dp" + dpNum.toString().padStart(3, "0") + ": " + name + "/device/0/nvoPulseOut, label=PulseOut, displaytype=pg1");
    }
    catch {}
}
function demoAddStarterKitDashboard() {

    try {
        var bUseNoLayout = false
        var iScreenWidth = screen.width;
        //alert(screen.width);
        if(bUseNoLayout) {
                // no loayout specified
            addCustomTag("dashboard_colors.colors:coloron:yellowgreen, coloroff=green, colorborder=black");
            addCustomTag("dashboard_dashboard1.dp01:(9FFFFF0501840460)/Lamp/0/nviLamp, label=LampIn 1, displaytype=s3, color=orange,");
            addCustomTag("dashboard_dashboard1.dp02:(9FFFFF0501840460)/Lamp/0/nvoLampFb, label=LampOut 1, displaytype=l4,color=red, contexts=floor;room, dashboard=95;300;lr4;DodgerBlue;navy");
            addCustomTag("dashboard_dashboard1.dp03:(9FFFFF0501840460)/Lamp/1/nviLamp,label= LampIn 2, displaytype=s4, contexts=floor;room");
            addCustomTag("dashboard_dashboard1.dp04:(9FFFFF0501840460)/Lamp/1/nvoLampFb, label=LampOut 2, displaytype=l4, color=orange,contexts=floor;room,dashboard=135;300;lr4;DodgerBlue;navy");
            addCustomTag("dashboard_dashboard1.dp05:(9FFFFF0501840460)/LightSensor/0/nvoLightLevel, label=Light Level, units=lux, displaytype=r;c,room,dashboard=75;260;r,width=4em");
            addCustomTag("dashboard_dashboard1.dp06:(9FFFFF0501840460)/TempSensor/0/nvoTemperature, label=Temp 2, displaytype=g2, guagemin=-20,guagemax=50,guagecolors=blue;cyan(0);green(10);orange(30);red(40),dashboard=75;236;r,width=4em, units=°C, precision=1");
            addCustomTag("dashboard_dashboard1.dp07:(9FFFFF0501840460)/Switch/0/nvoSwitch, label=Switch 1, displaytype=l4, contexts=floor;room, dashboard=80;298;l4b");
            addCustomTag("dashboard_dashboard1.dp08:(9FFFFF0501840460)/Switch/1/nvoSwitch, label=Switch 2, displaytype=l4,contexts=floor;room,dashboard=120;298;l4b");
            addCustomTag("dashboard_dashboard1.dp11:SC100-DIO-01/Digital Input/0/nvoDI,label=DI 0,displaytype=l4,dashboard=274;40;l4c");
            addCustomTag("dashboard_dashboard1.dp12:SC100-DIO-01/Digital Input/1/nvoDI,label=DI 1,displaytype=l4,dashboard=274;75;l4c");
            addCustomTag("dashboard_dashboard1.dp13:SC100-DIO-01/Digital Input/2/nvoDI,label=DI 2,displaytype=l4,dashboard=274;105;l4c");
            addCustomTag("dashboard_dashboard1.dp14:SC100-DIO-01/Digital Input/3/nvoDI,label=DI 3,displaytype=l4");
            addCustomTag("dashboard_dashboard1.dp15:SC100-DIO-01/Digital Output/0/nviDO,label=DO 0,displaytype=s4,dashboard=190;163;l4c");
            addCustomTag("dashboard_dashboard1.dp16:SC100-DIO-01/Digital Output/1/nviDO,label=DO 1,displaytype=s4,dashboard=215;163;l4c");
            addCustomTag("dashboard_dashboard1.dp17:SC100-DIO-01/Digital Output/2/nviDO,label=DO 2,displaytype=s4,dashboard=235;163;l4c");
            addCustomTag("dashboard_dashboard1.dp18:SC100-DIO-01/TempSensor/0/nvoTempSensor, label=Temperature, units=°C, precision=1, displaytype=r;c,dashboard=181;250,width=3.5em");
            addCustomTag("dashboard_dashboard1.dp19:SC100-DIO-01/TempSensor/0/nvoTempSensor, label=Temperature, units=°C, precision=1, displaytype=g2, guagemin=-20,guagemax=50,guagecolors=blue;cyan(0);green(10);orange(30);red(40)");
            addCustomTag("dashboard_dashboard1.dp21:Adam-DIO-01/DI/0/DI_0,displaytype=l2,dashboard=60;330;l2b");
            addCustomTag("dashboard_dashboard1.dp22:Adam-DIO-01/DI/0/DI_1,displaytype=l2,dashboard=60;360;l2b");
            addCustomTag("dashboard_dashboard1.dp23:Adam-DIO-01/DI/0/DI_2,displaytype=l2,dashboard=60;410;l2b");
            addCustomTag("dashboard_dashboard1.dp24:Adam-DIO-01/DI/0/DI_3,displaytype=l2,dashboard=60;435;l2b");
            addCustomTag("dashboard_dashboard1.dp25:Adam-DIO-01/DO/0/DO_0,displaytype=s2,dashboard=140;410;pb");
            addCustomTag("dashboard_dashboard1.dp26:Adam-DIO-01/DO/0/DO_1,displaytype=s2,dashboard=140;435;pb");
            addCustomTag("dashboard_dashboard1.dp31:Thermostat-01/AV/7/Room Temperature, label=Room Temperature,displaytype=r;c, contexts=floor;room, dashboard=205;410,width=2.5em");
            addCustomTag("dashboard_dashboard1.dp32:Thermostat-01/BV/51/Temperature Scale,label=Scale [0=°C;1=°F],displaytype=s2,dashboard=180;385;rbt");
            addCustomTag("dashboard_dashboard1.dp33:Thermostat-01/BI/29/BI 1 Status, label=Occupancy,displaytype=l2,color=red, dashboard=190;360;l2c;red;darkred");
            addCustomTag("dashboard_dashboard1.dp34:Thermostat-01/AV/41/Stand by Heat Setpoint, label=Std HeatSetpt,displaytype=n,dashboard=205;434,width=2.5em");
            addCustomTag("dashboard_dashboard1.dp35:Thermostat-01/AV/7/Room Temperature, label=Room Temperature,displaytype=g2, guagemin=-20,guagemax=100,guagecolors=blue;cyan(0);green(10);orange(80);red(90)");
            addCustomTag("dashboard_dashboard_image.image:image=images/user/starterkit.png,height=500");
        }
        else if (iScreenWidth > 1600) { //1600
            
            addCustomTag("dashboard_colors.colors:coloron:yellowgreen, coloroff=green, colorborder=black");
            addCustomTag("dashboard_dashboard1.dp01:(9FFFFF0501840460)/Lamp/0/nviLamp, label=LampIn 1, displaytype=s3, color=orange,");
            addCustomTag("dashboard_dashboard1.dp02:(9FFFFF0501840460)/Lamp/0/nvoLampFb, label=LampOut 1, displaytype=l4,color=DodgerBlue, contexts=floor;room, dashboard=95;300;lr4;DodgerBlue;navy");
            addCustomTag("dashboard_dashboard1.dp03:(9FFFFF0501840460)/Lamp/1/nviLamp,label= LampIn 2, displaytype=s4, contexts=floor;room");
            addCustomTag("dashboard_dashboard1.dp04:(9FFFFF0501840460)/Lamp/1/nvoLampFb, label=LampOut 2, displaytype=l4, color=DodgerBlue,contexts=floor;room,dashboard=135;300;lr4;DodgerBlue;navy");
            addCustomTag("dashboard_dashboard1.dp05:(9FFFFF0501840460)/LightSensor/0/nvoLightLevel, label=Light Level, units=lux, displaytype=r;c,room,dashboard=75;260;r,width=4em,layout=c2;r1;e1");
            addCustomTag("dashboard_dashboard1.dp06:(9FFFFF0501840460)/TempSensor/0/nvoTemperature, label=Temp 2, displaytype=g2, guagemin=-20,guagemax=50,guagecolors=blue;cyan(0);green(10);orange(30);red(40),dashboard=75;236;r,width=4em, units=°C, precision=1,layout=c1;r2;e1");
            //addCustomTag("dashboard_dashboard1.dp06:(9FFFFF0501840460)/TempSensor/0/nvoTemperature, label=Temp 2, dashboard=75;236;r,width=4em, units=°C, precision=1");
            addCustomTag("dashboard_dashboard1.dp07:(9FFFFF0501840460)/Switch/0/nvoSwitch, label=Switch 1, displaytype=l4, contexts=floor;room, dashboard=80;298;l4b");
            addCustomTag("dashboard_dashboard1.dp08:(9FFFFF0501840460)/Switch/1/nvoSwitch, label=Switch 2, displaytype=l4,contexts=floor;room,dashboard=120;298;l4b");
            addCustomTag("dashboard_dashboard1.dp11:SC100-DIO-01/Digital Input/0/nvoDI,label=DI 0,displaytype=l4,dashboard=274;40;l4c");
            addCustomTag("dashboard_dashboard1.dp12:SC100-DIO-01/Digital Input/1/nvoDI,label=DI 1,displaytype=l4,dashboard=274;75;l4c");
            addCustomTag("dashboard_dashboard1.dp13:SC100-DIO-01/Digital Input/2/nvoDI,label=DI 2,displaytype=l4,dashboard=274;105;l4c");
            addCustomTag("dashboard_dashboard1.dp14:SC100-DIO-01/Digital Input/3/nvoDI,label=DI 3,displaytype=l4");
            addCustomTag("dashboard_dashboard1.dp15:SC100-DIO-01/Digital Output/0/nviDO,label=DO 0,displaytype=s4,dashboard=190;163;l4c");
            addCustomTag("dashboard_dashboard1.dp16:SC100-DIO-01/Digital Output/1/nviDO,label=DO 1,displaytype=s4,dashboard=215;163;l4c");
            addCustomTag("dashboard_dashboard1.dp17:SC100-DIO-01/Digital Output/2/nviDO,label=DO 1,displaytype=s4,dashboard=235;163;l4c");
            addCustomTag("dashboard_dashboard1.dp18:SC100-DIO-01/TempSensor/0/nvoTempSensor, label=Temperature, units=°C, precision=1, displaytype=r;c,layout=c2;r3;e1, dashboard=181;250,width=3.5em");
            //addCustomTag("dashboard_dashboard1.dp18:SC100-DIO-01/TempSensor/0/nvoTempSensor, label=Temperature, units=°C, precision=1, displaytype=r, dashboard=181;250,width=3.5em");
            //addCustomTag("dashboard_dashboard1.dp19:SC100-DIO-01/TempSensor/0/nvoTempSensor, label=Temperature, units=°C, precision=1, displaytype=g2,layout=c2;r2;e1,guagemin=-20,guagemax=50,guagecolors=blue;cyan(0);green(10);orange(30);red(40)");
            addCustomTag("dashboard_dashboard1.dp21:Adam-DIO-01/DI/0/DI_0,displaytype=l2,dashboard=60;330;l2b");
            addCustomTag("dashboard_dashboard1.dp22:Adam-DIO-01/DI/0/DI_1,displaytype=l2,dashboard=60;360;l2b");
            addCustomTag("dashboard_dashboard1.dp23:Adam-DIO-01/DI/0/DI_2,displaytype=l2,dashboard=60;410;l2b");
            addCustomTag("dashboard_dashboard1.dp24:Adam-DIO-01/DI/0/DI_3,displaytype=l2,dashboard=60;435;l2b");
            addCustomTag("dashboard_dashboard1.dp25:Adam-DIO-01/DO/0/DO_0,displaytype=s2,dashboard=140;410;pb");
            addCustomTag("dashboard_dashboard1.dp26:Adam-DIO-01/DO/0/DO_1,displaytype=s2,dashboard=140;435;pb");
            addCustomTag("dashboard_dashboard1.dp31:Thermostat-01/AV/7/Room Temperature, label=Room Temperature,displaytype=r;c,layout=c2;r2;e1, contexts=floor;room, dashboard=205;410,width=2.5em");
            addCustomTag("dashboard_dashboard1.dp32:Thermostat-01/BV/51/Temperature Scale,label=Scale [0=°C;1=°F],displaytype=s2,dashboard=180;385;rbt");
            addCustomTag("dashboard_dashboard1.dp33:Thermostat-01/BI/29/BI 1 Status, label=Occupancy,displaytype=l2,color=red, dashboard=190;360;l2c;red;darkred");
            addCustomTag("dashboard_dashboard1.dp34:Thermostat-01/AV/41/Stand by Heat Setpoint, label=Std HeatSetpt,displaytype=n,dashboard=205;434,width=2.5em");
            //addCustomTag("dashboard_dashboard1.dp35:Thermostat-01/AV/7/Room Temperature, label=Room Temperature,displaytype=g2,layout=c2;r3;e1, guagemin=-20,guagemax=100,guagecolors=blue;cyan(0);green(10);orange(80);red(90)");
            addCustomTag("dashboard_dashboard1.layout:layout=cre, table=c3;r1000;e1, eWidth=300, eHeight=200");
            addCustomTag("dashboard_dashboard_image.image:image=images/user/starterkit.png,height=500,layout=c1;r1;e1");
        }
        else { // small screen
            addCustomTag("dashboard_colors.colors:coloron:yellowgreen, coloroff=green, colorborder=black");
            addCustomTag("dashboard_dashboard1.dp01:(9FFFFF0501840460)/Lamp/0/nviLamp, label=LampIn 1, displaytype=s3, color=orange,");
            addCustomTag("dashboard_dashboard1.dp02:(9FFFFF0501840460)/Lamp/0/nvoLampFb, label=LampOut 1, displaytype=l4,color=DodgerBlue, contexts=floor;room, dashboard=95;300;lr4;DodgerBlue;navy");
            addCustomTag("dashboard_dashboard1.dp03:(9FFFFF0501840460)/Lamp/1/nviLamp,label= LampIn 2, displaytype=s4, contexts=floor;room");
            addCustomTag("dashboard_dashboard1.dp04:(9FFFFF0501840460)/Lamp/1/nvoLampFb, label=LampOut 2, displaytype=l4, color=DodgerBlue,contexts=floor;room,dashboard=135;300;lr4;DodgerBlue;navy");
            addCustomTag("dashboard_dashboard1.dp05:(9FFFFF0501840460)/LightSensor/0/nvoLightLevel, label=Light Level, units=lux, displaytype=r;c,room,dashboard=75;260;r,width=4em,layout=c2;r1;e1");
            //addCustomTag("dashboard_dashboard1.dp06:(9FFFFF0501840460)/TempSensor/0/nvoTemperature, label=Temp 2, displaytype=g2, guagemin=-20,guagemax=50,guagecolors=blue;cyan(0);green(10);orange(30);red(40),dashboard=75;236;r,width=4em, units=°C, precision=1");
            addCustomTag("dashboard_dashboard1.dp06:(9FFFFF0501840460)/TempSensor/0/nvoTemperature, label=Temp 2, dashboard=75;236;r,width=4em, units=°C, precision=1");
            addCustomTag("dashboard_dashboard1.dp07:(9FFFFF0501840460)/Switch/0/nvoSwitch, label=Switch 1, displaytype=l4, contexts=floor;room, dashboard=80;298;l4b");
            addCustomTag("dashboard_dashboard1.dp08:(9FFFFF0501840460)/Switch/1/nvoSwitch, label=Switch 2, displaytype=l4,contexts=floor;room,dashboard=120;298;l4b");
            addCustomTag("dashboard_dashboard1.dp11:SC100-DIO-01/Digital Input/0/nvoDI,label=DI 0,displaytype=l4,dashboard=274;40;l4c");
            addCustomTag("dashboard_dashboard1.dp12:SC100-DIO-01/Digital Input/1/nvoDI,label=DI 1,displaytype=l4,dashboard=274;75;l4c");
            addCustomTag("dashboard_dashboard1.dp13:SC100-DIO-01/Digital Input/2/nvoDI,label=DI 2,displaytype=l4,dashboard=274;105;l4c");
            addCustomTag("dashboard_dashboard1.dp14:SC100-DIO-01/Digital Input/3/nvoDI,label=DI 3,displaytype=l4");
            addCustomTag("dashboard_dashboard1.dp15:SC100-DIO-01/Digital Output/0/nviDO,label=DO 0,displaytype=s4,dashboard=190;163;l4c");
            addCustomTag("dashboard_dashboard1.dp16:SC100-DIO-01/Digital Output/1/nviDO,label=DO 1,displaytype=s4,dashboard=215;163;l4c");
            addCustomTag("dashboard_dashboard1.dp17:SC100-DIO-01/Digital Output/2/nviDO,label=DO 1,displaytype=s4,dashboard=235;163;l4c");
            //addCustomTag("dashboard_dashboard1.dp18:SC100-DIO-01/TempSensor/0/nvoTempSensor, label=Temperature, units=°C, precision=1, displaytype=r;c,layout=c3;r2;e1, dashboard=181;250,width=3.5em");
            addCustomTag("dashboard_dashboard1.dp18:SC100-DIO-01/TempSensor/0/nvoTempSensor, label=Temperature, units=°C, precision=1, displaytype=r, dashboard=181;250,width=3.5em");
            //addCustomTag("dashboard_dashboard1.dp19:SC100-DIO-01/TempSensor/0/nvoTempSensor, label=Temperature, units=°C, precision=1, displaytype=g2,layout=c2;r2;e1,guagemin=-20,guagemax=50,guagecolors=blue;cyan(0);green(10);orange(30);red(40)");
            addCustomTag("dashboard_dashboard1.dp21:Adam-DIO-01/DI/0/DI_0,displaytype=l2,dashboard=60;330;l2b");
            addCustomTag("dashboard_dashboard1.dp22:Adam-DIO-01/DI/0/DI_1,displaytype=l2,dashboard=60;360;l2b");
            addCustomTag("dashboard_dashboard1.dp23:Adam-DIO-01/DI/0/DI_2,displaytype=l2,dashboard=60;410;l2b");
            addCustomTag("dashboard_dashboard1.dp24:Adam-DIO-01/DI/0/DI_3,displaytype=l2,dashboard=60;435;l2b");
            addCustomTag("dashboard_dashboard1.dp25:Adam-DIO-01/DO/0/DO_0,displaytype=s2,dashboard=140;410;pb");
            addCustomTag("dashboard_dashboard1.dp26:Adam-DIO-01/DO/0/DO_1,displaytype=s2,dashboard=140;435;pb");
            //addCustomTag("dashboard_dashboard1.dp31:Thermostat-01/AV/7/Room Temperature, label=Room Temperature,displaytype=r;c,layout=c2;r1;e1, contexts=floor;room, dashboard=205;410,width=2.5em");
            addCustomTag("dashboard_dashboard1.dp31:Thermostat-01/AV/7/Room Temperature, label=Room Temperature,displaytype=r, contexts=floor;room, dashboard=205;410,width=2.5em");
            addCustomTag("dashboard_dashboard1.dp32:Thermostat-01/BV/51/Temperature Scale,label=Scale [0=°C;1=°F],displaytype=s2,dashboard=180;385;rbt");
            addCustomTag("dashboard_dashboard1.dp33:Thermostat-01/BI/29/BI 1 Status, label=Occupancy,displaytype=l2,color=red, dashboard=190;360;l2c;red;darkred");
            addCustomTag("dashboard_dashboard1.dp34:Thermostat-01/AV/41/Stand by Heat Setpoint, label=Std HeatSetpt,displaytype=n,dashboard=205;434,width=2.5em");
            addCustomTag("dashboard_dashboard1.dp35:Thermostat-01/AV/7/Room Temperature, label=Room Temperature,displaytype=g2,layout=c2;r1;e2, guagemin=-20,guagemax=100,guagecolors=blue;cyan(0);green(10);orange(80);red(90)");
            addCustomTag("dashboard_dashboard1.layout:layout=cre, table=c2;r1000;e1, eWidth=300, eHeight=200");
            addCustomTag("dashboard_dashboard_image.image:image=images/user/starterkit.png,height=500,layout=c1;r1;e1");
        }
    }
    catch {}
}
function demoGetDeviceTypeListObj(name) {
    var result = null;
    try {
        for(i=0; i < g_oDemoDashboardDeviceTypeList.length; i++)
        {
            if(g_oDemoDashboardDeviceTypeList[i].name === name) {
                result = g_oDemoDashboardDeviceTypeList[i];
                break;
            }
        }
    }
    catch 
    {
        result = null;
    }
    return result;
}
/********************************************************************
 *  userInitMap() - Used for Map dashboard. Runs after context and devices are read.
 * 
 *  
 *   
 * 
 *******************************************************************/
function userInitMap(deviceList) {
    try {
        // See if one of our demo kits
        var bStarterKit_Thermostat = false;
        var sStarterKit_ThermostatName = "";
        var bStarterKit_Multisensor = false;
        var bStarterKit_Adam = false;
        var bStarterKit_SC100 = false;
        var iStarterKit = 0;
        var oPulseGen = [];
        var oCPDSim = [];
        var oDevices = [];
        var oMultiSensor = [];
        var index, obj, tempObj, bContinue, i;
        var iTotal = 0;
        var iMaxCount = 10;
        var programId;
        var iStarterKitMultiSensorDeviceIndex = -1, iStarterKitAdamDeviceIndex = -1, iStarterKitSc100DeviceIndex = -1, iStarterKitThermostatDeviceIndex =-1;
        g_oMapDashboard = null;
        iMaxCount = g_iMapDashboardMaxNumberOfRows; // defined in map.js, actual number shown on dashboard will be determined later based on screen size
        if(!g_bMapDashboardAutoDetectDevices)
            return;
        for(i=0; i < deviceList.length; i++)
        {
            if(deviceList[i].category === "SC") {
                
            }
            else {
                programId = deviceList[i].programId.toUpperCase();
                if(deviceList[i].name.toLowerCase() === "thermostat-01") {
                    iStarterKit ++;
                    iStarterKitThermostatDeviceIndex = i;
                }
                else if((deviceList[i].name.toLowerCase() === "multi-sensor-01") && (programId === "9FFFFF0501840460")) {
                    iStarterKit ++;
                    sStarterKit_ThermostatName = deviceList[i].name;
                    iStarterKitMultiSensorDeviceIndex = i;
                }
                else if(deviceList[i].name.toLowerCase() === "adam-dio-01") {
                    iStarterKit ++;
                    sStarterKit_ThermostatName = deviceList[i].name;
                    iStarterKitAdamDeviceIndex = i;
                }
                else if(deviceList[i].name.toLowerCase() === "sc100-dio-01") {
                    iStarterKit ++;
                    sStarterKit_ThermostatName = deviceList[i].name;
                    iStarterKitSc100DeviceIndex = i;
                }
                else if(((deviceList[i].name.toLowerCase() === "pulsegen-1") || (deviceList[i].name.toLowerCase() === "pulsegen1")  || (deviceList[i].name.toLowerCase() === "pulsegen 1"))
                    && (programId === "900001153C000405")) {
                    if(oPulseGen.length < 2) {
                        obj = {};
                        obj.name = deviceList[i].name;
                        obj.nameStr = deviceList[i].name.toLowerCase();
                        obj.index = i;
                        oPulseGen.push(JSON.parse(JSON.stringify(obj)));
                    }
                }
                else if(programId === "9FFFFF0501840460") {
                    // FT-6050 Sensor
                    
                    if(oMultiSensor.length < 2) {
                        obj = {};
                        obj.name = deviceList[i].name;
                        obj.nameStr = deviceList[i].name.toLowerCase();
                        obj.index = i;
                        oMultiSensor.push(JSON.parse(JSON.stringify(obj)));
                    }
                }
                else if(programId === "800001230E041005") { // CPDSim
                    if(oCPDSim.length < 6) {
                        obj = {};
                        obj.name = deviceList[i].name;
                        obj.nameStr = deviceList[i].name.toLowerCase();
                        obj.index = i;
                        oCPDSim.push(JSON.parse(JSON.stringify(obj)));
                    }
                }
                else {
                    
                    if((programId === "8A000BF60204E001") || (programId === "8A000BF60204E002") || (programId === "8A000BD21441E001"))  {
                        //8A000BF60204E001 = EDRPU, 8A000BF60204E002 = ESRPU
                        obj = {};
                        obj.name = deviceList[i].name;
                        obj.nameStr = deviceList[i].name.toLowerCase();
                        obj.index = i;
                        obj.programId = programId
                        oDevices.push(JSON.parse(JSON.stringify(obj)));
                    }


                }
            }
        }
        if(!((iStarterKit > 0) || (oCPDSim.length > 0) || (oPulseGen.length > 0)))
            return;
        g_oMapDashboard = {};
        g_oMapDashboard.iShowContextNames = 0;
        g_oMapDashboard.bClickToDevice = true;
        g_oMapDashboard.dpList = [];
        g_oMapDashboard.bShowDashboard = true;
        g_oMapDashboard.name = "";
        g_oMapDashboard.bReadOnly = false;
        // see if has pulsegen
        if(iStarterKit > 2) {
            g_oMapDashboard.name = "Starter Kit";
            iTotal += 7;
            addCustomTag("map_dashboard.dp01:Multi-Sensor-01/Lamp/1/nvoLampFb, label=LampOut 2, displaytype=l4, color=orange");
            addCustomTag("map_dashboard.dp02:Multi-Sensor-01/LightSensor/0/nvoLightLevel, label=Light Level, units=lux, displaytype=r");
            addCustomTag("map_dashboard.dp03:Multi-Sensor-01/TempSensor/0/nvoTemperature, label=Temp 2, displaytype=r, units=°C, precision=1");
            addCustomTag("map_dashboard.dp04:SC100-DIO-01/TempSensor/0/nvoTempSensor, label=Temperature, units=°C, precision=1, displaytype=r");
            addCustomTag("map_dashboard.dp05:Adam-DIO-01/DI/0/DI_2, label=DI_2,displaytype=l2");
            addCustomTag("map_dashboard.dp06:Thermostat-01/AV/7/Room Temperature, label=Room Temperature,displaytype=r, precision=1, scaledp=BV/51/Temperature Scale;ts");
            addCustomTag("map_dashboard.dp07:Thermostat-01/BI/29/BI 1 Status, label=Occupancy,displaytype=l2,color=DodgerBlue");
        }
        if(iTotal < iMaxCount) {
            if(oPulseGen.length > 0) {
                bContinue = true;
                if(g_oMapDashboard.name === "")
                    g_oMapDashboard.name = "PulsGen";
                while(bContinue)
                {
                    bContinue = false;
                    for(i=0; i < (oPulseGen.length - 1); i++)
                    {
                        if(oPulseGen[i].nameStr > oPulseGen[i + 1].nameStr) {
                            tempObj = {};
                            tempObj = JSON.parse(JSON.stringify(oPulseGen[i]));
                            oPulseGen[i] = JSON.parse(JSON.stringify(oPulseGen[i + 1]));
                            oPulseGen[i + 1] = JSON.parse(JSON.stringify(tempObj));
                            bContinue = true;
                        }
                    }
                }
                for(i=0; i < oPulseGen.length; i++)
                {
                    index = oPulseGen[i].index
                    if(deviceList[index].name.toLowerCase() === oPulseGen[i].name.toLowerCase()) {
                        obj = {};
                        obj.contextOrder = "map_dashboard.dp" + i + "1";
                        obj.deviceName = deviceList[index].name;
                        obj.deviceTypeStr = obj.deviceName;
                        obj.blockPath = "device/0/nvoLamp2";
                        obj.label = "Lamp 2";
                        if(oPulseGen.length > 0) {
                            iPtr = obj.deviceName.lastIndexOf("-");
                            if(iPtr !== -1) {
                                obj.label += "-" + obj.deviceName.substring(iPtr);
                            }
                            else 
                                obj.label += "-" + (i + 1).toString();
                        }
                        obj.path = obj.blockPath;
                        obj.name = obj.blockPath;
                        obj.datapointName = "nvoLamp2"; 
                        obj.field = "";
                        obj.displayType = "l4";
                        obj.color = "color";
                        obj.backgroundColor = "";
                        obj.precision = -1;
                        obj.units = "";
                        obj.readonly = true;
                        obj.scId = deviceList[index].scId;
                        obj.DID = deviceList[index].DID;
                        obj.bValueAdded = false;
                        obj.programId = deviceList[index].programId;
                        obj.protocol = deviceList[index].protocol;
                        obj.dpRequest =  deviceList[index].name + "/if/" + obj.blockPath;
                        obj.dpQualifier = deviceList[index].scId + "/" + obj.protocol + "/" + obj.DID + "/" + obj.blockPath;
                        g_oMapDashboard.dpList.push(obj);

                        obj = {};
                        obj.contextOrder = "map_dashboard.dp" + i + "2";
                        obj.deviceName = deviceList[index].name;
                        obj.deviceTypeStr = obj.deviceName;
                        obj.blockPath = "device/0/nvoLuxLevel";
                        obj.label = "Light Level";
                        if(oPulseGen.length > 0) {
                            iPtr = obj.deviceName.lastIndexOf("-");
                            if(iPtr !== -1) {
                                obj.label += "-" + obj.deviceName.substring(iPtr);
                            }
                            else 
                                obj.label += "-" + (i + 1).toString();
                        }
                        obj.path = obj.blockPath;
                        obj.name = obj.blockPath;
                        obj.datapointName = "nvoLuxLevel"; 
                        obj.field = "";
                        obj.displayType = "r";
                        obj.color = "";
                        obj.backgroundColor = "";
                        obj.precision = -1;
                        obj.units = "lux";
                        obj.readonly = true;
                        obj.scId = deviceList[index].scId;
                        obj.DID = deviceList[index].DID;
                        obj.bValueAdded = false;
                        obj.programId = deviceList[index].programId;
                        obj.protocol = deviceList[index].protocol;
                        obj.dpRequest =  deviceList[index].name + "/if/" + obj.blockPath;
                        obj.dpQualifier = deviceList[index].scId + "/" + obj.protocol + "/" + obj.DID + "/" + obj.blockPath;
                        g_oMapDashboard.dpList.push(obj);
                        
                        obj = {};
                        obj.contextOrder = "map_dashboard.dp" + i + "3";
                        obj.deviceName = deviceList[index].name;
                        obj.deviceTypeStr = obj.deviceName;
                        obj.blockPath = "device/0/nvoHVACTemp";
                        obj.label = "Temp";
                        if(oPulseGen.length > 0) {
                            iPtr = obj.deviceName.lastIndexOf("-");
                            if(iPtr !== -1) {
                                obj.label += "-" + obj.deviceName.substring(iPtr);
                            }
                            else 
                                obj.label += "-" + (i + 1).toString();
                        }
                        obj.path = obj.blockPath;
                        obj.name = obj.blockPath;
                        obj.datapointStr = "nvoHVACTemp"; 
                        obj.field = "";
                        obj.displayType = "r";
                        obj.color = "";
                        obj.backgroundColor = "";
                        obj.precision = 1;
                        obj.units = "°C";
                        obj.readonly = true;
                        obj.scId = deviceList[index].scId;
                        obj.DID = deviceList[index].DID;
                        obj.bValueAdded = false;
                        obj.programId = deviceList[index].programId;
                        obj.protocol = deviceList[index].protocol;
                        obj.dpRequest =  deviceList[index].name + "/if/" + obj.blockPath;
                        obj.dpQualifier = deviceList[index].scId + "/" + obj.protocol + "/" + obj.DID + "/" + obj.blockPath;
                        g_oMapDashboard.dpList.push(obj);

                        obj = {};
                        obj.contextOrder = "map_dashboard.dp" + i + "4";
                        obj.deviceName = deviceList[index].name;
                        obj.deviceTypeStr = obj.deviceName;
                        obj.blockPath = "device/0/nvoPulseOut";
                        obj.label = "PulseOut";
                        if(oPulseGen.length > 0) {
                            iPtr = obj.deviceName.lastIndexOf("-");
                            if(iPtr !== -1) {
                                obj.label += "-" + obj.deviceName.substring(iPtr);
                            }
                            else 
                                obj.label += "-" + (i + 1).toString();
                        }
                        obj.path = obj.blockPath;
                        obj.name = obj.blockPath;
                        obj.datapointName = "nvoPulseOut"; 
                        obj.field = "";
                        obj.displayType = "r";
                        obj.color = "";
                        obj.backgroundColor = "";
                        obj.precision = 1;
                        obj.units = "";
                        obj.readonly = true;
                        obj.scId = deviceList[index].scId;
                        obj.DID = deviceList[index].DID;
                        obj.bValueAdded = false;
                        obj.programId = deviceList[index].programId;
                        obj.protocol = deviceList[index].protocol;
                        obj.dpRequest =  deviceList[index].name + "/if/" + obj.blockPath;
                        obj.dpQualifier = deviceList[index].scId + "/" + obj.protocol + "/" + obj.DID + "/" + obj.blockPath;
                        g_oMapDashboard.dpList.push(obj);
                        
                    }
                }
            }
        }
        if(iTotal < iMaxCount) {
            if(oMultiSensor.length > 0) {
                bContinue = true;
                if(g_oMapDashboard.name === "")
                    g_oMapDashboard.name = "MultiSensor";
                while(bContinue)
                {
                    bContinue = false;
                    for(i=0; i < (oMultiSensor.length - 1); i++)
                    {
                        if(oMultiSensor[i].nameStr > oMultiSensor[i + 1].nameStr) {
                            tempObj = {};
                            tempObj = JSON.parse(JSON.stringify(oMultiSensor[i]));
                            oMultiSensor[i] = JSON.parse(JSON.stringify(oMultiSensor[i + 1]));
                            oMultiSensor[i + 1] = JSON.parse(JSON.stringify(tempObj));
                            bContinue = true;
                        }
                    }
                }
                for(i=0; i < oMultiSensor.length; i++)
                {
                    index = oMultiSensor[i].index
                    if(deviceList[index].name.toLowerCase() === oMultiSensor[i].name.toLowerCase()) {
                        obj = {};
                        obj.contextOrder = "map_dashboard.dp" + i + "1";
                        obj.deviceName = deviceList[index].name;
                        obj.deviceTypeStr = obj.deviceName;
                        obj.blockPath = "Lamp/1/nvoLampFb";
                        obj.label = "Lamp 2";
                        if(oMultiSensor.length > 0) {
                            iPtr = obj.deviceName.lastIndexOf("-");
                            if(iPtr !== -1) {
                                obj.label += "-" + obj.deviceName.substring(iPtr);
                            }
                            else 
                                obj.label += "-" + (i + 1).toString();
                        }
                        obj.path = obj.blockPath;
                        obj.name = obj.blockPath;
                        obj.datapointName = "nvoLampFb"; 
                        obj.field = "";
                        obj.displayType = "l4";
                        obj.color = "color";
                        obj.backgroundColor = "";
                        obj.precision = -1;
                        obj.units = "";
                        obj.readonly = true;
                        obj.scId = deviceList[index].scId;
                        obj.DID = deviceList[index].DID;
                        obj.bValueAdded = false;
                        obj.programId = deviceList[index].programId;
                        obj.protocol = deviceList[index].protocol;
                        obj.dpRequest =  deviceList[index].name + "/if/" + obj.blockPath;
                        obj.dpQualifier = deviceList[index].scId + "/" + obj.protocol + "/" + obj.DID + "/" + obj.blockPath;
                        g_oMapDashboard.dpList.push(obj);

                        obj = {};
                        obj.contextOrder = "map_dashboard.dp" + i + "2";
                        obj.deviceName = deviceList[index].name;
                        obj.deviceTypeStr = obj.deviceName;
                        obj.blockPath = "LightSensor/0/nvoLightLevel";
                        obj.label = "Light Level";
                        if(oPulseGen.length > 0) {
                            iPtr = obj.deviceName.lastIndexOf("-");
                            if(iPtr !== -1) {
                                obj.label += "-" + obj.deviceName.substring(iPtr);
                            }
                            else 
                                obj.label += "-" + (i + 1).toString();
                        }
                        obj.path = obj.blockPath;
                        obj.name = obj.blockPath;
                        obj.datapointName = "nvoLightLevel"; 
                        obj.field = "";
                        obj.displayType = "r";
                        obj.color = "";
                        obj.backgroundColor = "";
                        obj.precision = -1;
                        obj.units = "lux";
                        obj.readonly = true;
                        obj.scId = deviceList[index].scId;
                        obj.DID = deviceList[index].DID;
                        obj.bValueAdded = false;
                        obj.programId = deviceList[index].programId;
                        obj.protocol = deviceList[index].protocol;
                        obj.dpRequest =  deviceList[index].name + "/if/" + obj.blockPath;
                        obj.dpQualifier = deviceList[index].scId + "/" + obj.protocol + "/" + obj.DID + "/" + obj.blockPath;
                        g_oMapDashboard.dpList.push(obj);
                        
                        obj = {};
                        obj.contextOrder = "map_dashboard.dp" + i + "3";
                        obj.deviceName = deviceList[index].name;
                        obj.deviceTypeStr = obj.deviceName;
                        obj.blockPath = "TempSensor/0/nvoTemperature";
                        obj.label = "Temp";
                        if(oPulseGen.length > 0) {
                            iPtr = obj.deviceName.lastIndexOf("-");
                            if(iPtr !== -1) {
                                obj.label += "-" + obj.deviceName.substring(iPtr);
                            }
                            else 
                                obj.label += "-" + (i + 1).toString();
                        }
                        obj.path = obj.blockPath;
                        obj.name = obj.blockPath;
                        obj.datapointStr = "nvoTemperature"; 
                        obj.field = "";
                        obj.displayType = "r";
                        obj.color = "";
                        obj.backgroundColor = "";
                        obj.precision = 1;
                        obj.units = "°C";
                        obj.readonly = true;
                        obj.scId = deviceList[index].scId;
                        obj.DID = deviceList[index].DID;
                        obj.bValueAdded = false;
                        obj.programId = deviceList[index].programId;
                        obj.protocol = deviceList[index].protocol;
                        obj.dpRequest =  deviceList[index].name + "/if/" + obj.blockPath;
                        obj.dpQualifier = deviceList[index].scId + "/" + obj.protocol + "/" + obj.DID + "/" + obj.blockPath;
                        g_oMapDashboard.dpList.push(obj);
                    }
                }
            }
        }
        if(iTotal < iMaxCount) {
            if(oCPDSim.length > 0) {
                // re-order
                g_oMapDashboard.name = "Powerline Demo";
                bContinue = true;
                while(bContinue)
                {
                    bContinue = false;
                    for(i=0; i < (oCPDSim.length - 1); i++)
                    {
                        if(oCPDSim[i].nameStr > oCPDSim[i + 1].nameStr) {
                            tempObj = {};
                            tempObj = JSON.parse(JSON.stringify(oCPDSim[i]));
                            oCPDSim[i] = JSON.parse(JSON.stringify(oCPDSim[i + 1]));
                            oCPDSim[i + 1] = JSON.parse(JSON.stringify(tempObj));
                            bContinue = true;
                        }
                    }
                }
                for(i=0; i < oCPDSim.length; i++)
                {
                    index = oCPDSim[i].index
                    if(deviceList[index].name.toLowerCase() === oCPDSim[i].name.toLowerCase()) {
                        obj = {};
                        obj.contextOrder = "map_dashboard.dp" + i.toString().padStart(2,'0');
                        obj.deviceName = deviceList[index].name;
                        obj.deviceTypeStr = obj.deviceName;
                        obj.blockPath = "LuminairCntrl/0/nvoLampFb";
                        obj.label = "Lamp-";
                        iPtr = obj.deviceName.lastIndexOf("-");
                        if(iPtr !== -1) {
                            obj.label += obj.deviceName.substring(iPtr);
                        }
                        else 
                            obj.label += (i + 1).toString();
                        obj.path = obj.blockPath;
                        obj.name = obj.blockPath;
                        obj.datapointName = "nvoLampFb"; 
                        obj.field = "setting/value";
                        obj.displayType = "r";
                        obj.color = "";
                        obj.backgroundColor = "";
                        obj.precision = -1;
                        obj.units = "";
                        obj.readonly = true;
                        obj.scId = deviceList[index].scId;
                        obj.DID = deviceList[index].DID;
                        obj.bValueAdded = false;
                        obj.programId = deviceList[index].programId;
                        obj.protocol = deviceList[index].protocol;
                        obj.dpRequest =  deviceList[index].name + "/if/" + obj.blockPath;
                        obj.dpQualifier = deviceList[index].scId + "/" + obj.protocol + "/" + obj.DID + "/" + obj.blockPath;
                        g_oMapDashboard.dpList.push(obj);
                    }
                }
            }
        }
        if(iTotal < iMaxCount) {
            //sort by device name
            bContinue = true;
            while(bContinue)
            {
                bContinue = false;
                for(i=0; i < (oDevices.length - 1); i++) 
                {
                    if((oDevices[i].name + " ") > (oDevices[i + 1].name + " ")) {
                        obj = {}
                        obj = JSON.parse(JSON.stringify(oDevices[i]));
                        oDevices[i] = JSON.parse(JSON.stringify(oDevices[i + 1]));
                        oDevices[i + 1] = JSON.parse(JSON.stringify(obj));
                        bContinue = true;
                    }
                }
            }
            for(i=0; i < oDevices.length; i++) 
            {
                if(oDevices[i].programId === "8A000BF60204E001") { //EDRPU
                    iTotal++;
                    addCustomTag("map_dashboard.dp" + iTotal.toString().padStart(2,0) + ":" + oDevices[i].name + "/Rocker B/2/Switch B, label=Double Rocker SW,displaytype=l5d");
                    addCustomTag("map_dashboard.dp" + iTotal.toString().padStart(2,0) + "a:" + oDevices[i].name + "/Rocker A/1/Switch A, label=Double Right Rocker SW,displaytype=l5d1");
                }
                else if (oDevices[i].programId === "8A000BF60204E002") { //ESRPU
                    iTotal++;
                    addCustomTag("map_dashboard.dp" + iTotal.toString().padStart(2,0) + ":" + oDevices[i].name + "/Rocker B/1/Switch B, label=" + oDevices[i].name + " Rocker SW,displaytype=l5");
                }
                else if (oDevices[i].programId === "8A000BD21441E001") { //STM 550 multi-sensor
                    iTotal++;
                    addCustomTag("map_dashboard.dp" + iTotal.toString().padStart(2,0) + ":" + oDevices[i].name + "/Luminance/3/Luminance, label=" + oDevices[i].name + " Light Sensor,displaytype=r,units=lux");
                    if(iTotal < iMaxCount) {
                        iTotal++;
                        addCustomTag("map_dashboard.dp" + iTotal.toString().padStart(2,0) + ":" + oDevices[i].name + "/Temperature/1/Temperature, label=" + oDevices[i].name + " Temperature,displaytype=r,units=°C");
                    }
                    if(iTotal < iMaxCount) {
                        iTotal++;
                        addCustomTag("map_dashboard.dp" + iTotal.toString().padStart(2,0) + ":" + oDevices[i].name + "/Humidity/2/Humidity, label=" + oDevices[i].name + " Humidity,displaytype=r,units=%");
                    }
                    if(iTotal < iMaxCount) {
                        iTotal++;
                        addCustomTag("map_dashboard.dp" + iTotal.toString().padStart(2,0) + ":" + oDevices[i].name + "/Contact State/5/Contact State, label=" + oDevices[i].name + " Contact,displaytype=l2");
                    }
                    if((iTotal + 4) < iMaxCount) {
                        iTotal++;
                        addCustomTag("map_dashboard.dp" + iTotal.toString().padStart(2,0) + ":" + oDevices[i].name + "/Acceleration/4/Acceleration Status, label=" + oDevices[i].name + " Acceleration,displaytype=r");
                    }
                }
                if(iTotal > iMaxCount)
                    break;
            }
        }
        //sort map dashboard datapoint list
        if(g_oMapDashboard !== null) {
            if(g_oMapDashboard.dpList.length > 0) {
                bContinue = true;
                while(bContinue)
                {
                    bContinue = false;
                    if(typeof g_oMapDashboard.dpList[0].contextOrder !== "undefined") {
                        for(i=0; i < (g_oMapDashboard.dpList.length - 1); i++) 
                        {
                            if(g_oMapDashboard.dpList[i].contextOrder > g_oMapDashboard.dpList[i + 1].contextOrder) {
                                obj = {}
                                obj = JSON.parse(JSON.stringify(g_oMapDashboard.dpList[i]));
                                g_oMapDashboard.dpList[i] = JSON.parse(JSON.stringify(g_oMapDashboard.dpList[i + 1]));
                                g_oMapDashboard.dpList[i + 1] = JSON.parse(JSON.stringify(obj));
                                bContinue = true;
                            }
                        }
                    }
                }
            }
        }
    }
    catch (err) 
    {
        var error = err.toString();
    }

}


