/*
	Calendar.j used to show scheduled events

	SmartServer dates use "yyyy-mm-dd" format but if you use new Date() then you will get an incorrect milliseconds number
	You need to convert the "yyyy-mm-dd" to "yyyy/mm/dd" using .replace(/\-/g, "/") in order to get the correct millisecond number

	scheduleShowWeekSchedule1() - show Week schedule 
	scheduleShowEditEvent() - used to create or edit events
	scheduleShowEditEvent1() - builds UI
	scheduleShowEditEventCreateSchedule() - creates schedule event object and send to SmartServer

 *	Copyright (C) 2023 EnOcean GmbH.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	EnOcean Example Software License Agreement which is available at
 *	https://enoceanwiki.atlassian.net/wiki/spaces/LON/pages/2425260/Example+Software+License+Agreement. 

*/
var g_iScheduleView = 3; // -1:not sepecified, 1=year, 1 year, 2=month,3=week, 4=day
var g_calendarDate; // date used by calendar. Initially is today's date but changes based on customer selection
var g_todayDate;
var g_calendarObj = {};
var g_iScheduleShowScheduleListShowType =0; //used to select what is shown is the schedule list 0=all, 1=current events,2, future events, 3=expired events
var g_bYearShowJanuary = false;
var g_bScheduleEventInProgress = false;
var g_scheduleEventsPresetList = [];
var g_favoritesList = [];
var g_dpTypesAvailableList = [];
var g_scheduleEditEventDayMask = 0; // sun - sat; 0x7f means all selected.  sun = 0x40, sat = 0x1
var g_sceduleEventDatapointList = []; // list of all datapoints for a schedule event.
var g_scheduleEventDlaList = [];
var g_scheduleGetDpRequestList = []; // this is needed when there are two many datapoints specified in the schedule or schedules
var g_iScheduleEventMinHeight = 15;
var g_iScheduleWeekMaxTimeSlots = 9;
var g_bScheduleToolTipShowDpCount = true; // adds datapoint count to event tool tip
var g_bScheduleToolTipShowDpList = true; // shows up to first 10 Dps and and last DP 
var g_bScheduleToolTipMonthShow = true; // adds tool tip to month and year
var g_bScheduleNoSchedulesShowInformationDialog = false; // only used when first going in to schedules when no schedules are available




const monthsList = [
	"January",
	"Feburary",
	"March",
	"April",
	"May",
	"June",
	"July",
	"August",
	"September",
	"October",
	"November",
	"December",
]
const daysList = [
	"Sunday",
	"Monday",
	"Tuesday",
	"WednesDay",
	"Thursday",
	"Friday",
	"Saturday"
]
function calendarInit() {
	g_iScheduleShowScheduleListShowType =0;
	g_bScheduleEventInProgress = 0;
	g_calendarDate = new Date();
	
}
function calendarYearButtonsClicked(mode) {
	var dateStr;
	if(mode === 0) {
		g_calendarDate.setFullYear(g_calendarDate.getFullYear() - 1);
		
	}
	else { 
		g_calendarDate.setFullYear(g_calendarDate.getFullYear() + 1);
		
	}
	scheduleShowYearSchedule(1);
}
function calendarMonthButtonsClicked(mode) {
	var dateStr;
	if(mode === 0) {
		g_calendarDate.setMonth(g_calendarDate.getMonth() - 1);
		
	}
	else { 
		g_calendarDate.setMonth(g_calendarDate.getMonth() + 1);
		
	}
	scheduleShowMonthSchedule();
}
function calendarWeekButtonsClicked(mode) {
	var dateStr;
	if(mode === 0) {
		g_calendarDate.setDate(g_calendarDate.getDate() - 7);
		dateStr = g_calendarDate.getFullYear() + "-" +(g_calendarDate.getMonth() + 1).toString().padStart(2,0) + "-" + g_calendarDate.getDate().toString().padStart(2,0);
	}
	else { 
		g_calendarDate.setDate(g_calendarDate.getDate() + 7);
		dateStr = g_calendarDate.getFullYear() + "-" +(g_calendarDate.getMonth() + 1).toString().padStart(2,0) + "-" + g_calendarDate.getDate().toString().padStart(2,0);
	}
	scheduleShowWeekSchedule1(1, dateStr);
}
function calendarDayButtonsClicked(mode) {
	var dateStr;
	if(mode === 0) {
		g_calendarDate.setDate(g_calendarDate.getDate() - 1);
		dateStr = g_calendarDate.getFullYear() + "-" +(g_calendarDate.getMonth() + 1).toString().padStart(2,0) + "-" + g_calendarDate.getDate().toString().padStart(2,0);
	}
	else { 
		g_calendarDate.setDate(g_calendarDate.getDate() + 1);
		dateStr = g_calendarDate.getFullYear() + "-" +(g_calendarDate.getMonth() + 1).toString().padStart(2,0) + "-" + g_calendarDate.getDate().toString().padStart(2,0);
	}
	scheduleShowDaySchedule1(1, dateStr);
}
function menuScheduleCreateDivClose() {
	var element = document.getElementById("scheduleCreateDiv");
	if(element !== null) {
		element.className = "menuDivHide";
		element = document.getElementById("scheduleCreateOverlayDiv");
		if(element !== null)
			element.className = "menuOverlayDivHide";

	}
	menuDivClose();
	testDeviceCancel();
}
function convertRgbStrToHex(rgbStr) {
	var iPtr, i;
	var color = rgbStr;
	try {
		iPtr = color.indexOf("rgb(");
		if(iPtr !== -1) {

			color = color.substr(4,color.length - 5 );
			colors = color.split(",");
			if(colors.length === 3) 
				rgbStr = "#" + Number(colors[0]).toString(16).padStart(2,0) + Number(colors[1]).toString(16).padStart(2,0)  + Number(colors[2]).toString(16).padStart(2,0);

		}
	}
	catch {}
	return rgbStr;
}
function determineTextColorBasedOnDarkness (color) {
	//if light color then use black otherwise white
	var result = "white";
	var hsp
	var r=-1, g=-1, b=-1;
	if(typeof color === "undefined") {

	}
	else if(color.charAt(0) === "#") {
		r = parseInt("0x" + color.charAt(1) + color.charAt(2))
		g = parseInt("0x" + color.charAt(3) + color.charAt(4))
		b = parseInt("0x" + color.charAt(5) + color.charAt(6))
		hsp = Math.sqrt( (0.299 * (r * r)) + (0.587 * (g * g)) + (0.114 * (b * b)))
		if(hsp > 127.5) {
			// light
			result = "black";
		}
		else {
			// dark
		}
	}
	return result;
}
function determineTimeStrFromSolorTime(solar, offsetType, offsetHours, offsetMinutes, isNegative, time) {
	var sunrise, sunset, items, iTemp, iPtr, iTemp;
	var sTemp = "";
	try {
		if(offsetType === "SUNRISE") {
			if(g_bUseFixedSunsriseSunset)
				time = "06:00"; //navtree fix - determine real sunrise
			else {
				try{
					sunrise = new Date(solar.sunrise).getTime();
					iTemp = ((offsetHours * 60 * 60) + (offsetMinutes * 60)) * 1000;
					if(isNegative)
						iTemp = -iTemp;
					sunrise = new Date(sunrise + iTemp).toLocaleTimeString('en-GB');
					items = sunrise.split(":");
					sunrise = items[0] + ":" + items[1];
					time = sunrise; 
				}
				catch {}
			}
		}
		else if(offsetType === "SUNSET") {
			if(g_bUseFixedSunsriseSunset)
				time = "18:00"; //navtree fix - determine real sunset
			else {
				try{
					sunset = new Date(solar.sunset).getTime();
					iTemp = ((offsetHours * 60 * 60) + (offsetMinutes * 60)) * 1000;
					if(isNegative)
						iTemp = -iTemp;
					sunset = new Date(sunset + iTemp).toLocaleTimeString('en-GB');
					items = sunset.split(":");
					sunset = items[0] + ":" + items[1];
					time = sunset; 
				}
				catch {}
			}
		}
		
		if(g_b12hourClock) {
			iPtr = time.indexOf(":");
			iTemp = time.substr(0,iPtr);
			try {
				iTemp = Number(iTemp);
				if(iTemp < 12) {
					if(iTemp === 0)
						sTemp += 12;
					else
						sTemp += iTemp.toString();
					sTemp += time.substr(iPtr) + "AM";
				}
				else {	
					iTemp -= 12;
					if(iTemp === 0)
						sTemp += 12;
					else
						sTemp += iTemp.toString();
					sTemp += time.substr(iPtr) + "PM";
				}
			}
			catch {}
		}
		else 
			sTemp += time;
		if(offsetType === "SUNRISE") {
			sTemp += " (";
			if((offsetHours !== 0) || (offsetMinutes !== 0)) {
				if(offsetHours !== 0) 
					sTemp += offsetHours + " hours ";
				if(offsetMinutes !== 0) 
					sTemp += offsetMinutes + " minutes ";
				if(isNegative)
					sTemp += "before ";
				else	
					sTemp += "after ";
			}
			sTemp += "sunrise)";
		}
		else if(offsetType === "SUNSET") {
			sTemp += " (";
			if((offsetHours !== 0) || (offsetMinutes !== 0)) {
				if(offsetHours !== 0) 
					sTemp += offsetHours + " hours ";
				if(offsetMinutes !== 0) 
					sTemp += offsetMinutes + " minutes ";
				if(isNegative)
					sTemp += "before ";
				else	
					sTemp += "after ";
			}
			sTemp += "sunset)";
		}
	}
	catch {}
	return sTemp;
}
function menuScheduleDivClose() {
	var element = document.getElementById("scheduleDiv");
	if(element !== null)
		element.className = "menuDivHide";
	element = document.getElementById("scheduleOverlayDiv");
	if(element !== null)
		element.className = "menuOverlayDivHide";
	
}
function today(mode) {
    g_calendarDate = new Date();
	switch(mode) {
		case 0: addYearCalendar(1); break; // current timestamp g_bYearShowJanuary = false;
		case 1: addYearCalendar(1);  break; // beginning of year g_bYearShowJanuary = true;
		case 2: addMonthCalendar(1); break;
		case 3: scheduleShowWeekSchedule1(1, ""); break;
		case 4: scheduleShowDaySchedule(1,""); break;
		default: break;
	}
    
}
function showCalendar(mode) {
	g_iMainDisplayMode = DISPLAYMODE_SCHEDULE;
	g_calendarObj = {};
	g_calendarObj.mode = 0; // All Schedules
	g_calendarObj.dashboardDpListIndex = "";
	g_calendarObj.pathname = "";
	g_calendarObj.dpQualifier = "";
	g_calendarObj.scheduleView = g_iScheduleView;
	g_calendarDate = new Date();
	g_todayDate = new Date(g_calendarDate.getFullYear + "/" + (g_calendarDate.getMonth() + 1).toString().padStart(2,0) + "/" + (g_calendarDate.getDate()).toString().padStart(2,0));
    getSchedules(0, "");
	
}
function showDeviceSchedule(index, pathname, dpQualifier) {
	showDpSchedule1(2, index, pathname, dpQualifier);
}
function showDpSchedule(index, pathname, dpQualifier) {
	showDpSchedule1(1, index, pathname, dpQualifier);
}
function showDpSchedule1(mode, index, pathname, dpQualifier) {
	//menuCloseAll();
	var element, element1 = document.getElementById("planningPaneDetails")
	var offsets, x, y, sTemp;
	
	try {
		menuDivClose();
		
		g_calendarObj = {};
		if(element1 !== null) {

			offsets = element1.getBoundingClientRect(); 
			x = offsets.x + window.pageXOffset; // takes into account viewport (scrolling)
			y = offsets.y + window.pageYOffset; // takes into account viewport (scrolling)
		
			element = document.getElementById("scheduleDiv");
			if(element != null) {
				
				g_calendarObj.mode = mode; // 0=All Schedules, 1=schedules for specific DP, 2= schedules for specific device
				g_calendarObj.dashboardDpListIndex = index;
				g_calendarObj.pathname = pathname;
				g_calendarObj.dpQualifier = dpQualifier;
				g_calendarObj.scheduleView = g_iScheduleView;
				element.className = "showScheduleDiv";
				element.style.left = x.toString() + "px";
				element.style.top = y.toString() + "px";
				sTemp = "Calendar<button id=\"menuScheduleDivCloseId\" style=\"float:right;visibility:hidden\" onclick=\"menuScheduleDivClose()\">X</button><br><br>";
				sTemp += pathname;
				sTemp += "<br><br><div id=\"showScheduleDivId\"><span style=\"text-align:center\">Getting Schedule data...</span><div><div class=\"gettingInfo\">" + addWaitSpinner(0) + "</div></div><div>";
				element.innerHTML = sTemp;
				menuOverlayDivShow(6, null);
				getSchedules(0, "");
			}
		}
	}
	catch {}
}
function addYearCalendar(mode) {
    try {
		var element;
        var content = "";
		var year = "";
		var nextYear;
		var today = new Date().toDateString();
		/* remove
		if(mode === 1) {
			nextYear = new Date(g_calendarDate.getTime());
			nextYear.setFullYear(nextYear.getFullYear() + 1);
			year = g_calendarDate.getFullYear() + " - " + nextYear.getFullYear();
		}
		else //beginning of year mode=0
			year = g_calendarDate.getFullYear();
			*/
        content += "<div id=\"calendarContainerId\" class=\"calendarContainer\">";
        	content += "<div class=\"calendarYear\">";
        		content += "<div class=\"month\">";
				content += "<div style=\"text-align:left;\"><span class=\"calendarMenuSpan\" onclick=\"today(0)\"  title=\"Show Today in Year Calendar\">Today</span>";
				content += "<span class=\"calendarMenuSpan\"  onclick=\"menuScheduleTypeChangeScheduleType(4)\" title=\"Show Day Calendar\" title=\"Show Day Calendar\">Day</span>";
				content += "<span class=\"calendarMenuSpan\" onclick=\"menuScheduleTypeChangeScheduleType(3)\" title=\"Show Week Calendar\" title=\"Show Week Calendar\">Week</span>";
				content += "<span class=\"calendarMenuSpan\" onclick=\"menuScheduleTypeChangeScheduleType(2)\" title=\"Show Month Calendar\" title=\"Show Month Calendar\">Month</span>";
				content += "<span class=\"calendarMenuSpanCurrent\" onclick=\"menuScheduleTypeChangeScheduleType(0)\" title=\"Show Year Calendar\">Year</span></div>";
        			content += "<span id=\"prev\" class=\"schedulePrev\" onclick=\"calendarYearButtonsClicked(0)\" title=\"Show Prevous Year\">&#10094;</span>";
		
		//content += "<span onclick=\"today()\">Dri May 29, 2020</span>";
        			content += "<div class=\"date\">";
        				content += "<h1 id=\"years\" class=\"calenderH1\"></h1>";
        			//	content += "<p onclick=\"today(0)\">" + today + "</p>";
        			content += "</div>";
        			content += "<span id=\"next\" class=\"schedulePrev\" onclick=\"calendarYearButtonsClicked(1)\"  title=\"Show Next Year\">&#10095;</span>";
					content += "<button id=\"calendarMenu\"  onclick=\"menuScheduleType(0)\" title=\"Calendar Menu\">...</button>";
					content += "<img id=\"calendarMenuIcon\"  onclick=\"menuCalenderPicker(0)\" src=\"images/navtree/calendarIcon.png\"  title=\"Select Day\">";
        		content += "</div>";
        		
       			 content += "<div id=\"months1\"></div>";
        	content += "</div>";
        content += "</div>";
		
		if(g_calendarObj.mode === 0) {		
			element = document.getElementById("planningPaneDetails"); //navtree
			if(element !== null) {
				element.innerHTML =  "<div>" + content + "</div>" + addTopButton();
				if(mode === 0)
					g_calendarDate = new Date();
				scheduleShowYearSchedule(mode);
			}
		}
		else if(g_calendarObj.mode === 1) {		
			element = document.getElementById("scheduleDiv"); //navtree
			if(element !== null) {
				element.innerHTML =  "<div>" + g_calendarObj.pathname + "<button id=\"menuScheduleDivCloseId\" class=\"menuScheduleDivClose\" onclick=\"menuScheduleDivClose()\">X</button></div><div class=\"scheduleEventsDiv\">" + content + "</div>";
				if(mode === 0)
					g_calendarDate = new Date();
				scheduleShowYearSchedule(mode);
			}
		}
    }
    catch {}

}
function addMonthCalendar(mode) {
    try {
		var element;
        var content = "";
        content += "<div id=\"calendarContainerId\" class=\"calendarContainer\">";
        	content += "<div class=\"calendar\">";
        		content += "<div class=\"month\">";
				content += "<div style=\"text-align:left;\"><span class=\"calendarMenuSpan\" onclick=\"today(2)\" title=\"Show Today in Month Calendar\">Today</span>";
				content += "<span class=\"calendarMenuSpan\"  onclick=\"menuScheduleTypeChangeScheduleType(4)\" title=\"Show Day Calendar\">Day</span>";
				content += "<span class=\"calendarMenuSpan\" onclick=\"menuScheduleTypeChangeScheduleType(3)\" title=\"Show Week Calendar\">Week</span>";
				content += "<span class=\"calendarMenuSpanCurrent\" onclick=\"menuScheduleTypeChangeScheduleType(2)\" title=\"Show Month Calendar\">Month</span>";
				content += "<span class=\"calendarMenuSpan\" onclick=\"menuScheduleTypeChangeScheduleType(0)\" title=\"Show Year Calendar\">Year</span></div>";
        			
        			content += "<span id=\"prev\" class=\"schedulePrev\" onclick=\"calendarMonthButtonsClicked(0)\" title=\"Show Prevous Month\">&#10094;</span>";
		
		//content += "<span onclick=\"today()\">Dri May 29, 2020</span>";
        			content += "<div class=\"date\">";
						content += "<h1 class=\"calenderH1 calendarMonthText\">May</h1>";
        			//	content += "<p onclick=\"today(1)\">Dri May 29, 2020</p>";
        			content += "</div>";
        			content += "<span id=\"next\" class=\"schedulePrev\" onclick=\"calendarMonthButtonsClicked(1)\"  title=\"Show Next Month\">&#10095;</span>";
					content += "<button id=\"calendarMenu\"  onclick=\"menuScheduleType(2)\" title=\"Calendar Menu\">...</button>";
					content += "<img id=\"calendarMenuIcon\"  onclick=\"menuCalenderPicker(2)\" src=\"images/navtree/calendarIcon.png\" title=\"Select Day\">";
        		content += "</div>";
        		content += "<div class=\"weekdays\">";
        		content += "<div>Sun</div><div>Mon</div><div>Tue</div><div>Wed</div><div>Thur</div><div>Fri</div><div>Sat</div></div>";
				if(g_bShowEventCountInCalendar)
					content += "<div id=\"days1\" class=\"daysPlusEvents\"></div>";
				else
       			 content += "<div id=\"days1\" class=\"days\"></div>";
        	content += "</div>";
        content += "</div>";
		
		if(g_calendarObj.mode === 0) {		
			element = document.getElementById("planningPaneDetails"); //navtree
			if(element !== null) {
				element.innerHTML =  "<div>" + content + "</div>" + addTopButton();
				if(mode === 0)
					g_calendarDate = new Date();
				scheduleShowMonthSchedule();
			}
		}
		else if(g_calendarObj.mode === 1) {		
			element = document.getElementById("scheduleDiv"); //navtree
			if(element !== null) {
				element.innerHTML =  "<div>" + g_calendarObj.pathname + "<button id=\"menuScheduleDivCloseId\" class=\"menuScheduleDivClose\" onclick=\"menuScheduleDivClose()\">X</button></div><div class=\"scheduleEventsDiv\">" + content + "</div>";
				if(mode === 0)
					g_calendarDate = new Date();
				scheduleShowMonthSchedule();
			}
		}
    }
    catch {}

}
function addWeekCalendar(mode) {
    try {
		var element,i,j;
		var content = "";
		var todayDate = new Date();
		var todayDateMs;
		var weekStr = "", oneJan, weekNum = 1;

		var beginningDt = new Date(g_calendarDate.getTime());
		var beginningMs;
		var endingDt = new Date(g_calendarDate.getTime());
		var dateStr = "", weekStr;
		todayDate = new Date(todayDate.getFullYear(), todayDate.getMonth(),todayDate.getDate());
		todayDateMs = todayDate.getTime();
		dateStr =   beginningDt.getFullYear()+ "/" + (beginningDt.getMonth() + 1).toString().padStart(2,0) + "/" + beginningDt.getDate().toString().padStart(2,0);
		beginningDt = new Date(dateStr);
		beginningDt.setDate(beginningDt.getDate() - g_calendarDate.getDay());
		dateStr =  (beginningDt.getMonth() + 1).toString().padStart(2,0) + "/" + beginningDt.getDate().toString().padStart(2,0) + "/" + beginningDt.getFullYear();
		endingDt = new Date(beginningDt.getTime());
		endingDt.setDate(endingDt.getDate() + 6);
		dateStr += " - " + (endingDt.getMonth() + 1).toString().padStart(2,0) + "/" + endingDt.getDate().toString().padStart(2,0) + "/"  + endingDt.getFullYear();

		oneJan = new Date(endingDt.getFullYear(),0,1);
		
		weekNum = Math.floor((endingDt - oneJan) / (24 * 60 * 60 * 1000));
		weekNum = Math.ceil(( endingDt.getDay() + 1 + weekNum) / 7);
		//weekStr = "Week [" + weekNum + "] Sun " + daysList[beginningDt.getDay()].substr(0,3) + " " + monthsList[beginningDt.getMonth()].substr(0,3) + " " + beginningDt.getDate() + " " + beginningDt.getFullYear();
		weekStr = monthsList[endingDt.getMonth()] + " " + endingDt.getFullYear();// + " Week[" + weekNum + "]";
        content += "<div id=\"calendarContainerId\" class=\"calendarContainer\">";
        	content += "<div class=\"calendarDay\">";
        		content += "<div class=\"month\">";
				content += "<div style=\"text-align:left;\"><span class=\"calendarMenuSpan\" onclick=\"today(3)\" title=\"Show Today in Week Calendar\">Today</span>";
				content += "<span class=\"calendarMenuSpan\"  onclick=\"menuScheduleTypeChangeScheduleType(4)\" title=\"Show Day Calendar\">Day</span>";
				content += "<span class=\"calendarMenuSpanCurrent\" onclick=\"menuScheduleTypeChangeScheduleType(3)\" title=\"Show Week Calendar\">Week</span>";
				content += "<span class=\"calendarMenuSpan\" onclick=\"menuScheduleTypeChangeScheduleType(2)\" title=\"Show Month Calendar\">Month</span>";
				content += "<span class=\"calendarMenuSpan\" onclick=\"menuScheduleTypeChangeScheduleType(0)\" title=\"Show Year Calendar\">Year</span></div>";
        			content += "<span id=\"prev\" class=\"schedulePrev\" onclick=\"calendarWeekButtonsClicked(0)\" title=\"Show Prevous Week\">&#10094;</span>";
		
		//content += "<span onclick=\"today()\">Dri May 29, 2020</span>";
        			content += "<div class=\"date\">";
        				content += "<h1 class=\"calenderH1 calendarWeekText\">" + weekStr + "</h1>"; 
        	/*			content += "<p onclick=\"today()\">Dri May 29, 2020</p>"; */
        			content += "</div>";
        			content += "<span id=\"next\" class=\"schedulePrev\" onclick=\"calendarWeekButtonsClicked(1)\" title=\"Show Next Week\">&#10095;</span>";
					content += "<button id=\"calendarMenu\" onclick=\"menuScheduleType(3)\" title=\"Calendar Menu\">...</button>";
					content += "<img id=\"calendarMenuIcon\"  onclick=\"menuCalenderPicker(3)\" src=\"images/navtree/calendarIcon.png\" title=\"Select Day\">";
        		content += "</div>";
				
				
				content += "<div style=\"display:flex\">"
				content += "<div class=\"daytime\"></div>";
				for(j=0; j < 7; j++)
				{
					beginningMs = beginningDt.getTime();
					dateStr = beginningDt.getFullYear() + "/" + (beginningDt.getMonth() + 1).toString().padStart(2,0) + "/" + beginningDt.getDate().toString().padStart(2,0);
					if(beginningMs === todayDateMs)
						content += "<div  class=\"weekheadervaluetoday\" onclick=\"scheduleShowDaySchedule(1,'" + dateStr + "')\">" + beginningDt.getDate() + " " + daysList[j].substr(0,3) + "</div>";
					else
						content += "<div  class=\"weekheadervalue\" onclick=\"scheduleShowDaySchedule(1,'" + dateStr + "')\">" + beginningDt.getDate() + " " + daysList[j].substr(0,3) + "</div>";
					beginningDt.setDate(beginningDt.getDate() + 1);
				
					
				}
				content += "</div>"

				content += "<div style=\"display:flex\">"
					content += "<div class=\"daytimes\">";
						
							j = 0;
							for(i=0; i < 24; i++ )
							{
								if(i === 13) {
									if(g_b12hourClock) 
										j = 12;
								}
								content += "<div class=\"daytime\">";
								if(i === 0)
									content += "12";
								else
									content += (i - j).toString().padStart(2,0);
								content += ":00";
								if(g_b12hourClock) {
									if(i < 12) 
										content += "AM";
									else	
										content += "PM";
								}
								content += "</div>";
							}
						
					content += "</div>";
					for(j=0; j < 7; j++)
					{
						content += "<div class=\"daytimesValues\">";
						for(i=0; i < 48; i++ )
						{
							content += "<div id=\"daytimevalue_" + j + "_" + i + "\" class=\"weekvalue\"></div>";
						}
						content += "</div>";
					}
        		
        	content += "</div>";
        content += "</div>";
		if(g_calendarObj.mode === 0) {		
			element = document.getElementById("planningPaneDetails"); //navtree
			if(element !== null) {
				element.innerHTML =  "<div>" + content + "</div>" + addTopButton();
				//calendarInitDaybuttons()
				
			}
		}
		else if(g_calendarObj.mode === 1) {		
			element = document.getElementById("scheduleDiv"); //navtree
			if(element !== null) {
				
				element.innerHTML =  "<div>" + g_calendarObj.pathname + "<button id=\"menuScheduleDivCloseId\" class=\"menuScheduleDivClose\" onclick=\"menuScheduleDivClose()\">X</button></div><div class=\"scheduleEventsDiv\">" + content + "</div>";
				//calendarInitDaybuttons()
				
			}
		}
    }
    catch {}

}

function addDayCalendar(mode) {
    try {
		var element,i,j;
        var content = "";
        content += "<div id=\"calendarContainerId\" class=\"calendarContainer\">";
        	content += "<div class=\"calendarDay\">";
        		content += "<div class=\"month\">";
				content += "<div style=\"text-align:left;\"><span class=\"calendarMenuSpan\" onclick=\"today(4)\" title=\"Show Today in Day Calendar\">Today</span>";
				content += "<span class=\"calendarMenuSpanCurrent\"  onclick=\"menuScheduleTypeChangeScheduleType(4)\" title=\"Show Day Calendar\">Day</span>";
				content += "<span class=\"calendarMenuSpan\" onclick=\"menuScheduleTypeChangeScheduleType(3)\" title=\"Show Week Calendar\">Week</span>";
				content += "<span class=\"calendarMenuSpan\" onclick=\"menuScheduleTypeChangeScheduleType(2)\" title=\"Show Month Calendar\">Month</span>";
				content += "<span class=\"calendarMenuSpan\" onclick=\"menuScheduleTypeChangeScheduleType(0)\" title=\"Show Year Calendar\">Year</span></div>";
        			content += "<span id=\"prev\" class=\"schedulePrev\" onclick=\"calendarDayButtonsClicked(0)\" title=\"Show Prevous Day\">&#10094;</span>";
		
		//content += "<span onclick=\"today()\">Dri May 29, 2020</span>";
        			content += "<div class=\"date\">";
        				content += "<h1 class=\"calenderH1 calendarDayText\">May</h1>"; 
        	/*			content += "<p onclick=\"today()\">Dri May 29, 2020</p>"; */
        			content += "</div>";
        			content += "<span id=\"next\" class=\"schedulePrev\" onclick=\"calendarDayButtonsClicked(1)\" title=\"Show Next Day\">&#10095;</span>";
					content += "<button id=\"calendarMenu\" onclick=\"menuScheduleType(4)\" title=\"Calendar Menu\">...</button>";
					content += "<img id=\"calendarMenuIcon\"  onclick=\"menuCalenderPicker(4)\" src=\"images/navtree/calendarIcon.png\" title=\"Select Day\">";
        		content += "</div>";
				content += "<div style=\"display:flex\">"
					content += "<div class=\"daytimes\">";
						
							j = 0;
							for(i=0; i < 24; i++ )
							{
								if(i === 13) {
									if(g_b12hourClock) 
										j = 12;
								}
								content += "<div class=\"daytime\">";
								if(i === 0)
									content += "12";
								else
									content += (i - j).toString().padStart(2,0);
								content += ":00";
								if(g_b12hourClock) {
									if(i < 12) 
										content += "AM";
									else	
										content += "PM";
								}
								content += "</div>";
							}
						
					content += "</div>";
					content += "<div class=\"daytimesValues\">";
						for(i=0; i < 48; i++ )
						{
							content += "<div id=\"daytimevalue_" + i + "\" class=\"dayvalue\"></div>";
						}
					content += "</div>";
        		
        	content += "</div>";
        content += "</div>";
		if(g_calendarObj.mode === 0) {		
			element = document.getElementById("planningPaneDetails"); //navtree
			if(element !== null) {
				element.innerHTML =  "<div>" + content + "</div>" + addTopButton();
				//calendarInitDaybuttons()
				
			}
		}
		else if(g_calendarObj.mode === 1) {		
			element = document.getElementById("scheduleDiv"); //navtree
			if(element !== null) {
				//element.innerHTML =  g_calendarObj.pathname + "<div>" + content + "</div>";
				element.innerHTML =  "<div>" + g_calendarObj.pathname + "<button id=\"menuScheduleDivCloseId\" class=\"menuScheduleDivClose\" onclick=\"menuScheduleDivClose()\">X</button></div><div class=\"scheduleEventsDiv\">" + content + "</div>";
				//element.innerHTML =  "<div>" + g_calendarObj.pathname + "<button id=\"menuScheduleDivCloseId\" style=\"float:right\" onclick=\"menuScheduleDivClose()\">X</button></div><div>" + content + "</div>";
				//calendarInitDaybuttons()
				
			}
		}
    }
    catch {}

}
function getSchedules(mode, url) {
	//mode: 0= build calender, 1=update calendar, 5=same as 0 but one week starting with week

	var	url = ""; //"/iap/devTypes/*/if/*/*/*/dla?includeUnconfigured=false";
	var iPtr;
	var d = new Date();
	var currentDay = d.getDay(); // shows mon-sun, we want sun-sat
	var currentDate = d.toLocaleDateString();
	var startOfWeek = Date.parse(currentDate);
	var sBegWeek, ibegWeek,sEndWeek
	var oneDay = 60 * 60 * 24 * 1000;
	var dayOffset = 1; // (g_sScheduleRange === "week (sun - sat)")
	schedulesList = []; // full dplist or if from planning or dashboard then single dp
	g_schedulesListOrig = []; // always full dp list
	if(url === "") {
		if(mode === 0) { 
			/*
			d = new Date(g_calendarDate.getTime());
			sBegWeek = d.toISOString(); 
			iPtr = sBegWeek.indexOf("T");
			if(iPtr > 0)
				sBegWeek = sBegWeek.substr(0, iPtr);
			ibegWeek = startOfWeek;
			d.setTime(ibegWeek + (oneDay * 1));
			sEndWeek = d.toISOString(); 
			iPtr = sEndWeek.indexOf("T");
			if(iPtr > 0)
				sEndWeek = sEndWeek.substr(0, iPtr);
			url = "https://" + location.host + url;
			url += "/iap/sev/*?end=" +  sEndWeek + "&start=" + sBegWeek;
			*/
			url = "https://" + location.host + url;
			url += "/iap/sev/*";
		}
		else if((mode === 5) && ((g_sScheduleRange.toLowerCase() === "week (sun - sat)") || (g_sScheduleRange.toLowerCase() === "week (mon - sun)"))) {
			currentDay = d.getDay(); // shows mon-sun, we want sun-sat
			currentDate = d.toLocaleDateString();
			startOfWeek = Date.parse(currentDate);
			
			if(g_sScheduleRange.toLowerCase() === "week (mon - sun)") 
				dayOffset = 0;
			ibegWeek = startOfWeek - ((currentDay + dayOffset) * oneDay);
			d.setTime(ibegWeek);
			sBegWeek = d.toISOString(); 
			iPtr = sBegWeek.indexOf("T");
			if(iPtr > 0)
				sBegWeek = sBegWeek.substr(0, iPtr);
			d.setTime(ibegWeek + (oneDay * 7));
			sEndWeek = d.toISOString(); 
			iPtr = sEndWeek.indexOf("T");
			if(iPtr > 0)
				sEndWeek = sEndWeek.substr(0, iPtr);
			url = "https://" + location.host + url;
			url += "/iap/sev/*?end=" +  sEndWeek + "&start=" + sBegWeek;
		} 
		else { 
		//else if (g_sScheduleRange === "all") {
			url = "https://" + location.host + url;
			url += "/iap/sev/*?end=" +  sEndWeek + "&start=" + sBegWeek;
		}
	}
	requestGetData(0, url, getSchedulesResponse, readFailCallback);
}

function getSchedulesResponse(mode, requestUrlString, json) {
	var i,j, k, z, requestString = "", dp, dpQualifier, name, list = [], element, sTemp, obj, deviceId,items;
	var iCount = 0, maxCount = 50;
	g_scheduleGetDpRequestList = []; // this is needed when there are two many datapoints specified in the schedule or schedules
	g_bScheduleNoSchedulesShowInformationDialog = false;
	if(json.length === 0) {
		if(g_iMainDisplayMode === DISPLAYMODE_SCHEDULE) {
			g_bScheduleNoSchedulesShowInformationDialog = true;
			//showStatusInformationDiv(11,"No schedules were found"); // can't use this here as planningdetails pane is not available yet
			//showAlertDialog(0,"No schedules were found");
		}
	}
	
	g_scheduleJsonResponse = [];
	if(mode === 9) {
		
		if(json.length === 0) {
			g_sDpInfoPaneContent += " None";
			return;
		}
	}
	try {

		if(g_calendarObj.mode === 1) {
			//only show events for specified datapoint
			for(i=0; i < json.length; i++)
			{
				for(j=0; j < json[i].metadata.datapoints.length; j++)
				{
					if(json[i].metadata.datapoints[j].dpQualifier === g_calendarObj.dpQualifier) {
						obj = JSON.parse(JSON.stringify(json[i].metadata.datapoints[j]));
						json[i].metadata.datapoints = [];
						json[i].metadata.datapoints.push(obj);
						
						json[i].datapoints = [];
						json[i].datapoints.push(obj.dpQualifier);
						list.push(JSON.parse(JSON.stringify(json[i])));
						break;
					}
				}
			}
			json = [];
			json = list; // only schedule events that apply to specific datapoint
			element = document.getElementById("menuScheduleDivCloseId")
			if(element !== null)
				element.style.visibility = "visible";
			if(json.length === 0) {
				element = document.getElementById("showScheduleDivId")
				if(element !== null)
					element.innerHTML = "<span  style=\"text-align:center\">No schedules were found</span>";
				return;
				
			}
		}
		else if(g_calendarObj.mode === 2) {
			//only show events for specified device
				// find device id
			g_calendarObj.mode = 1;
			z = -1;

			for(i=0; i < deviceListAll.length; i++)
			{
				if(deviceListAll[i].name.toLowerCase() === g_calendarObj.pathname.toLowerCase()) {
					z = i;
					break;
				}
			}
			if(z !== -1) {
				deviceId = deviceListAll[z].DID;
				for(i=0; i < json.length; i++)
				{
					for(j=0; j < json[i].metadata.datapoints.length; j++)
					{
						sTemp = json[i].metadata.datapoints[j].dpQualifier;
						items = sTemp.split("/");
						if(items.length > 2) {
							sTemp = items[2];
							if(deviceId === sTemp) {
								obj = JSON.parse(JSON.stringify(json[i].metadata.datapoints[j]));
								json[i].metadata.datapoints = [];
								json[i].metadata.datapoints.push(obj);
								
								json[i].datapoints = [];
								json[i].datapoints.push(obj.dpQualifier);
								list.push(JSON.parse(JSON.stringify(json[i])));
								break;
							}
						}
					}
				}
			}
			json = [];
			json = list; // only schedule events that apply to specific datapoint
			element = document.getElementById("menuScheduleDivCloseId")
			if(element !== null)
				element.style.visibility = "visible";
			if(json.length === 0) {
				element = document.getElementById("showScheduleDivId")
				if(element !== null)
					element.innerHTML = "<span  style=\"text-align:center\">No schedules were found</span>";
				return;
				
			}
		}
		
// need to get datapoint instance name from datapoint XIF name

		for(i=0; i < json.length; i++)
		{
			obj = json[i];
			try {
				if(!(typeof obj.metadata === "undefined")) {
					if(!(typeof obj.metadata.datapoints === "undefined")) {
						for(j=0; j < obj.metadata.datapoints.length; j ++)
						{
							dpQualifier = obj.metadata.datapoints[j].dpQualifier;
							name = obj.metadata.datapoints[j].deviceName;
							dpQualifierPathList = dpQualifier.split("/");
							if(dpQualifierPathList.length >= 6) {
								dp = name + "/" + dpQualifierPathList[3] + "/" + dpQualifierPathList[4] + "/" + dpQualifierPathList[5] ;
								z = -1;
								for(k=0; k < g_scheduleUrlDpXifList.length; k++)
								{
									if(dp === g_scheduleUrlDpXifList[k].dpProgrammaticPath) {
										z = k;
										break;
									}
								}
								if(z === -1) {
									iCount++
									if(iCount > maxCount) {
										g_scheduleGetDpRequestList.push(requestString);
										requestString = "";
										iCount = 0;
									}
	
									if(requestString !== "")
										requestString += ",";
									requestString += dpQualifier;

								}

							}
						}
					}
				}
			} catch { }
			if(requestString !== "")
				g_scheduleGetDpRequestList.push(requestString);
			/*
			if(requestString !== "") {
				g_scheduleJsonResponse = JSON.parse(JSON.stringify(json));
				getScheduleResponseGetDpList(mode, requestString);
				return;
			}
			*/
				
		}
		if(g_scheduleGetDpRequestList.length > 0) {
			requestString = g_scheduleGetDpRequestList.shift();
			g_scheduleJsonResponse = JSON.parse(JSON.stringify(json));
			getScheduleResponseGetDpList(mode, requestString);
			return;
		}
	
	}
	catch {}
 //g_scheduleUrlDpXifList
	getSchedulesResponseProcessData(mode, requestUrlString, json);
}
function getScheduleResponseGetDpList(mode, requestString) { 
	var url = "https://" + location.host + "/iap/devs/*/if/*/*/*+qualifier=-";
	requestString = encodeUriString(requestString); // remove "/" and  "/[]""
	url += requestString + "/value?&noxs=true"; //"/value?max_age=1&noxs=true";
	requestGetData(mode, url, getScheduleResponseGetDpListResponse, readFailCallback);
}
function getScheduleResponseGetDpListResponse(mode, requestUrlString, json) {
	var bSaveToDpInfoPaneContent = false;
	var i, j, z, obj, dpPath, dpXifPath;
	var requestString;
	if(mode === 9) {
		
	}
	
	try {
		for(i=0; i < json.length; i ++)
		{
			dpPath = json[i].deviceName + "/" + json[i].blockName + "/" + json[i].blockIndex + "/" + json[i].datapointName;
			dpXifPath = dpPath;
			if(json[i].name !== null)
				dpPath = json[i].deviceName + "/" + json[i].blockName + "/" + json[i].blockIndex + "/" + json[i].name;
			z = -1;
			for(j=0; j < g_scheduleUrlDpXifList.length; j++)
			{

				if(dpPath === g_scheduleUrlDpXifList[j].dpPath) {
					z = j;
					break;
				}
			}
			if(z === -1) {
				obj = {};
				obj.dpPath = dpPath;
				obj.dpProgrammaticPath = dpXifPath;
				obj.dpQualifier = json[i].dpQualifier;
				obj.blockPath = json[i].blockName + "/" + json[i].blockIndex + "/" + json[i].datapointName;
				obj.blockName = json[i].blockName;
				obj.blockIndex = json[i].blockIndex;
				obj.datapointName = json[i].datapointName;
				obj.dpType = json[i].type;
				//obj.deviceTypePath = json[i].type + "/" + json[i].blockName + "/" + json[i].blockIndex + "/" + json[i].datapointName;
				g_scheduleUrlDpXifList.push(obj);

			}
		}
		if(g_scheduleGetDpRequestList.length > 0) {
			requestString = g_scheduleGetDpRequestList.shift();
			getScheduleResponseGetDpList(mode, requestString);
			return;
		}
		
	}
	catch {}
	getSchedulesResponseProcessData(mode, requestUrlString, g_scheduleJsonResponse);
}

function getSchedulesResponseProcessData(mode, requestUrlString, json) {
	try {
		var i, j, k;
		var obj, obj1;
		var name, dpQualifier;
		var sDps = "", sXifDps = "", dp = "", xifDp="", name = "", sDpsStr = "", sXifDpsStr = "", scheduleDpList = [];
		var dpQualifierPathList;
		var browserType;
		var objList = [];  //only used if g_sSchedulePathame !== "all"
		var paneContent;
		var bAddToList = false;
		var iType = 0; // 0=all, 1=device, 2=DP
		var start,end;
		var tempObj;
		var bContinue = true;
		var tblName = "schTable";
		var d, ms, newDate, newMs;
		var dayMs = 24 * 60 * 60 * 1000;

		var bSaveToDpInfoPaneContent = false;
		var i, j, z, obj, dpPath, dpXifPath;
		if(mode === 9) {
			bSaveToDpInfoPaneContent = true;
			mode = 0;
			if(json.length === 0) {
				g_sDpInfoPaneContent += " None";
				return;
			}
		}
		
		
		if(mode === 0) {
			try {
				if(g_sSchedulePathname === "") 
					g_sSchedulePathname = "all";
				if(g_sSchedulePathname === "all") {
					iType = 0;
				}
				else { 
					iPtr = g_sSchedulePathname.indexOf("/");
					if(iPtr === -1)
						iType = 1;
					else 
						iType = 2;
				}
			} catch {iType = 0;}
			for(i= 0; i < json.length; i ++)
			{ // make sure all datapoints we are interested in are polulated
				bAddToList = false;
				obj = json[i];
				sDps = "";	sDpsStr = ""; sXifDpsStr = ""; browserType = "";	name = ""; dp = ""; sXifDps = ""; xifDp = "";
				bAddToList = false;
				scheduleDpList = [];
				json[i].bShowDatapointType = true;
				json[i].browserRepeatCount = -1;
				json[i].browserDatapointList = [];
				try {
					if(!(typeof obj.metadata === "undefined")) {
						if(!(typeof obj.metadata.datapoints === "undefined")) {
							for(j=0; j < obj.metadata.datapoints.length; j ++)
							{
								dpQualifier = obj.metadata.datapoints[j].dpQualifier;
								name = obj.metadata.datapoints[j].deviceName;
								dpQualifierPathList = dpQualifier.split("/");
								if(dpQualifierPathList.length >= 6) {
									xifDp = name + "/" + dpQualifierPathList[3] + "/" + dpQualifierPathList[4] + "/" + dpQualifierPathList[5] ;
									dp = xifDp;
									for(k=0; k < g_scheduleUrlDpXifList.length; k++)
									{

										if(xifDp === g_scheduleUrlDpXifList[k].dpProgrammaticPath) {
											dp = g_scheduleUrlDpXifList[k].dpPath;
											break;
										}
									}
									if(sDps !== "") {
										sDps += ",<br>";
										json[i].bShowDatapointType = false;
									}
									sDps += dp;
									if(sDpsStr !== "")
										sDpsStr += ",";
									sDpsStr += dp;
									if(sXifDps !== "") 
										sXifDps += ",<br>";
									sXifDps += xifDp;
									if(sXifDpsStr !== "")
										sXifDpsStr += ",";
									sXifDpsStr += xifDp;
									scheduleDpList.push(dp);
									obj1 = {};
									obj1.deviceName = name;
									obj1.path = dp;
									obj1.programmaticPath = xifDp;
									json[i].browserDatapointList.push(obj1);
									if(iType === 1) {
										if(name === g_sSchedulePathname) {
											bAddToList = true;
										}
									}
								}
							}
						}
					}
				} catch { }
				json[i].browserDpList = sDps;
				json[i].dpListStr = sDpsStr;
				json[i].xifDpListStr = sXifDpsStr;
				json[i].browserXifDpList = sXifDps;
				sTemp = "";
				try {
					if(typeof obj.metadata.repeatOption !== "undefined" ) {
						sTemp = obj.metadata.repeatOption;
					}
					else if(!(typeof obj.weekly === "undefined" )) {
						if(obj.weekly !== null) {
							sTemp = JSON.stringify(obj.weekly);
						}
						else {
							if(obj.repeat === null) 
								sTemp = "Single Event: "
							sTemp += "{startTime:" + obj.startingTime + " " +  obj.startingDate + ", endTime" + obj.endingTime + " " +  obj.endingDate + "}";
						}
					}
					else if(!(typeof obj.repeat === "undefined" )) {
						if(obj.repeat !== null) {
							if(sTemp !== "")
								sTemp += ",";
							sTemp += JSON.stringify(obj.repeat);
						}
					}
				} catch {}
				json[i].browserType = sTemp;
				if(typeof json[i].metadata.endDateType !== null) {
					if(obj.metadata.endDateType === "REPEATS") {
						try {
							if(typeof json[i].metadata.repeatsCount !== null) {
								json[i].browserRepeatCount = json[i].metadata.repeatsCount;
								if(typeof json[i].end === "undefined") {
									// determine end date from startdate + ((RepeatCount) * duration) - 1 day). Note if daily event starts today Mon then enddate is Sunday, not Monday. 
									// Today is Monday but first event is Sunday then if firs 
									json[i].end =  obj.metadata.endDateType;
									if(typeof json[i].metadata.repeatOptions !== "undefined") {
										d = new Date(json[i].startingDate.replace(/\-/g,"/"));
										ms = d.getTime();
										newMs = 0;
										if(json[i].metadata.repeatOptions === "DAILY") {
											//newMs = new Date(json[i].browserRepeatCount - 1) * dayMs; // need to subtract one day otherwise happens twice
											d.setDate(d.getDate() + json[i].browserRepeatCount - 1);
										}
										else if((json[i].metadata.repeatOptions === "WEEKDAY") (json[i].repeatOptions === "EVERY_WEEKDAY")) {
											d.setDate(d.getDate() + (json[i].browserRepeatCount * 7) - 1);
											//newMs = ms + (json[i].browserRepeatCount * 7 * dayMs) - dayMs; // need to subtract one day otherwise happens twice
										}
										else if(json[i].metadata.repeatOptions === "CUSTOM_WEEKLY") {
											d.setDate(d.getDate() + (json[i].browserRepeatCount * 7) - 1);
											//newMs = ms + (json[i].browserRepeatCount - 1) * dayMs; // need to subtract one day otherwise happens twice
										}
										else if(json[i].metadata.repeatOptions === "CUSTOM_MONTHLY") {
											// there is every month (or specific month
											//newMs = ms + (json[i].browserRepeatCount * 7 * dayMs) - dayMs; // need to subtract one day otherwise happens twice
											d.setMonth(d.getMonth() + json[i].browserRepeatCount);
											d.setDate(d.getDate() - 1);
										}
										if(ms !== 0) {
											newDate = new Date(newMs);
											json[i].end = d.getFullYear() + "-" + (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0);
										}
									}
								}
							}
						}
						catch {}
					}
				}
				sTemp = "";
				/*
				try {
					if(typeof json[i].end === "undefined") {
						json[i].end =  obj.metadata.endDateType;
					}
					
				} catch {} */
				try {
					if(json[i].end === "NONE")
						sTemp = obj.start + " (no end date)";
					else if(json[i].obj.metadata.endDateType === "NO_REPEAT")
						sTemp = obj.start;
					else 
						sTemp = obj.start + " thru " +json[i].end;
				} catch {}
				json[i].browserDuration = sTemp;
				json[i].value = JSON.stringify(json[i].value);
				if(iType > 0) {
					if(iType === 2) {
						bAddToList = false;
						for(j=0; j < scheduleDpList.length; j++) 
						{
								// datapoint
								if(scheduleDpList[j] === g_sSchedulePathname) {
									bAddToList = true;
									break;
							}
						}
					}
					if(bAddToList)
						objList.push(json[i]);
				}
				
			}
			if(iType > 0)
				schedulesList = objList;
			else 
				schedulesList = json;
			g_schedulesListOrig = JSON.parse(JSON.stringify(json)); //no need to re-order
				// re-order based on start time
			bContinue = true;
			while(bContinue)
			{
				bContinue = false;
				for(i= 0; i < (schedulesList.length - 1); i ++)
				{
					try {
						start = Number(schedulesList[i].startingTime.replace(":","."));
						end = Number(schedulesList[i + 1].startingTime.replace(":","."));
						if(start > end) {
							tempObj = schedulesList[i];
							schedulesList[i] = schedulesList[i + 1];
							schedulesList[i + 1] = tempObj;
							bContinue = true;
						}
					}
					catch {}
				}
			}

		}
		else 
			schedulesList = json; 
		
	}
	catch (err) {
		err = err;
	}
	if(g_calendarObj.mode === 1) {
		element = document.getElementById("menuScheduleDivCloseId");
		if(element !== null)
			element.style.visibility = "visible";
		
	}
	menuScheduleTypeChangeScheduleType(g_calendarObj.scheduleView);
	//addMonthCalendar(0);
} 
function menuCalenderPicker(mode) {
// mode: 0=year,1=month,2=week,3=day
	var element, menuButton, menuContent = "", element;
	var currentDate;
	var x,y,offsets;
	try {
		menuContent = "<div class=\"menuDivCalendarBorder\">";
		
		menuContent += "<div>";
		menuContent += "<button  onclick=\"menuCalenderPickerToday()\">Today</button>";
		menuContent += "<button style=\"float:right\" onclick=\"menuDivClose();\">X</button>";
		menuContent += "<button style=\"float:right\" onclick=\"menuCalenderPickerSave(" + mode + ")\">Save</button>";
		menuContent += "</div>";
		menuContent += "<br><br>";
		menuContent += "<div class\"menuCalendarPicker\">"
		menuContent += "<input id=\"menuCalendarPicker\" type=\"date\" style=\"margin:10px\">";
		menuContent += "</div>"
		
		menuContent += "</div>";
		
		menuButton = document.getElementById("calendarMenuIcon");
		element = document.getElementById("menuDiv");
		if((menuButton === null) || (element === null))
			return;

		offsets = menuButton.getBoundingClientRect(); 
		x = offsets.x + window.pageXOffset - 150; // takes into account viewport (scrolling)
		y = offsets.y + window.pageYOffset + 20; // takes into account viewport (scrolling)
		element.style.left = x.toString() + "px";
		element.style.top = y.toString() + "px";
		element.innerHTML = menuContent;
		element.className = "menuScheduleType";  // doesn't currently guaranty that menu is shown in viewport 

		currentDate = g_calendarDate.getFullYear() + "-" + ( g_calendarDate.getMonth() + 1).toString().padStart(2,"0") + "-" + g_calendarDate.getDate().toString().padStart(2,"0");
		document.getElementById("menuCalendarPicker").value = currentDate;

		g_bInoreMouseClick = true;
	}
catch {}
}
function  menuCalenderPickerSave(mode) {

	try {
		var element = document.getElementById("menuCalendarPicker");
		var newDate;
		if(element !== null) {
			newDate = element.value;
			newDate = newDate.replace(/\-/g,"/");
			g_calendarDate = new Date(newDate);
			menuDivClose();
			switch(mode) {
				case 0: addYearCalendar(1); break; // current timestamp g_bYearShowJanuary = false;
				case 1: addYearCalendar(1);  break; // beginning of year g_bYearShowJanuary = true;
				case 2: addMonthCalendar(1); break;
				case 3: scheduleShowWeekSchedule1(1, ""); break;
				case 4: scheduleShowDaySchedule(1,""); break;
				default: break;
			}
		}
	}
	catch {}
}
function menuCalenderPickerToday() {
	try {
		var today = new Date();
		var element = document.getElementById("menuCalendarPicker");
		if(element !== null) {
			element.value =  today.getFullYear() + "-" + (today.getMonth() + 1).toString().padStart(2,"0") + "-" + today.getDate().toString().padStart(2,"0");
		}
	}
	catch {}
}
function menuScheduleType(mode) {
	// mode: 0=year,1=year 2=month,3=week,4=day
	var element, menuButton, menuContent = "", paneContent = "", i, iPtr, bContinue, element;
	var startDate, endDate;
	var currentDate, currentDateMs, tempObj, i, list=[];
	var x,y,offsets, menuDivYOffset = 100;
	var sTemp;
	var tblName = "scheduleListTable";
	

	try {
		
		//alert(currentDate);
		//currentDateMs = currentDate.getTime();
		menuContent = "<div class=\"menuDivBorder\">";
		menuContent += "<div>";
		menuContent += "<div style=\"display:flex\">";
		menuContent += "<div id=\"planningDivHeader\"  class=\"menuDivName menuDivDpValueShowDragDivHeader\">Schedule Menu</div>";
		menuContent += "<button style=\"float:right\" onclick=\"planningMenuCancel()\">X</button>";
		menuContent += "</div>";
		menuContent += "<br><br>";
		if(g_bShowEventCountInCalendarAllow) {
			menuContent += "<input type=\"checkbox\" id=\"menuScheduleTypeShowEventCount\" onclick=\"menuScheduleTypeShowEventCount(" + mode + ")\"";
			if(g_bShowEventCountInCalendar)
				menuContent += " checked";
			menuContent += "> Show Event Count<br><br>";
				
		}
		menuContent += "<button class=\"menuScheduleTypeButton\" onclick=\"menuScheduleTypeChangeScheduleType(1)\">Year (Jan)</button><br>";
		
		if(g_bShowEventEdit) 
			menuContent += "<hr><button class=\"menuScheduleTypeButton\" onclick=\"scheduleShowEditEvent(0," + mode + ", null, '', '')\">Create Event</button><br>"

		menuContent += "<hr>";
		//menuContent += "<button class=\"menuScheduleTypeButton\" onclick=\"scheduleShowScheduleList(0, '')\">Show All Events</button><br>"
		menuContent += "<button style=\"white-space: nowrap;\" onclick=\"scheduleShowScheduleList(0, '')\">Show All Events</button><br><br>"
		if(!g_bUseFixedSunsriseSunset)
			menuContent += "<button style=\"white-space: nowrap;\" onclick=\"sunriseSunsetTimesDialog()\">Sunrise/Sunset Times</button><br>"
		//if(mode === 3) {
			
		//}	


		menuContent += "</div></div>";
		
		menuButton = document.getElementById("calendarMenu");
		element = document.getElementById("planningDiv");
		if((menuButton === null) || (element === null))
			return;

		offsets = menuButton.getBoundingClientRect(); 
		x = offsets.x + window.pageXOffset - 50; // takes into account viewport (scrolling)
		y = offsets.y + window.pageYOffset - menuDivYOffset; // takes into account viewport (scrolling)
		element.style.left = x.toString() + "px";
		element.style.top = y.toString() + "px";
		element.innerHTML = menuContent;
		element.className = "menuScheduleType";  // doesn't currently guaranty that menu is shown in viewport 
		//menuOverlayDivShow(1, null);
		dragDiv("planningDiv");
		g_bInoreMouseClick = true;
	}
	catch {}
}
function menuScheduleTypeShowEventCount(mode) {
	try {
		var element = document.getElementById("menuScheduleTypeShowEventCount");
		if(element !== null) {
			if(element.checked)
				g_bShowEventCountInCalendar = true;
			else 
				g_bShowEventCountInCalendar = false;
			switch(mode) {
				case 0: g_bYearShowJanuary = false; addYearCalendar(1); break; // current timestamp
				case 1: g_bYearShowJanuary = true; addYearCalendar(1);  break; // beginning of year
				case 2: addMonthCalendar(1); break;
				case 3: scheduleShowWeekSchedule1(1, ""); break;
				case 4: scheduleShowDaySchedule(1,""); break;
			}
		}
	}
	catch {}
}
function  menuScheduleTypeChangeScheduleType(mode) {
	planningMenuCancel();
	g_calendarObj.scheduleView = mode;
	switch(mode) {
		case 0: g_bYearShowJanuary = false; addYearCalendar(1); break; // current timestamp
		case 1: g_bYearShowJanuary = true; addYearCalendar(1);  break; // beginning of year
		case 2: addMonthCalendar(1); break;
		case 3: scheduleShowWeekSchedule1(1, ""); break;
		case 4: scheduleShowDaySchedule(1,""); break;
		default: break;
	}
	if(g_bScheduleNoSchedulesShowInformationDialog) {
		g_bScheduleNoSchedulesShowInformationDialog = false;
		showStatusInformationDiv(11,"No schedules were found");
	}
}
function menuCalendarDivClose() {
	menuScheduleListDiv();
	menuScheduleDpListDiv();
}
function menuScheduleListDiv() {
	planningMenuCancel();
	menuScheduleDpListDiv()
	
}
function menuScheduleDpListDiv(){
	testDeviceCancel();
}

function scheduleShowYearSchedule(mode) {
    var count = 0, i, dateStr, sExtra = "", todayClass = "today";
    //var monthDays = document.querySelector(".days");
    var monthDays = document.getElementById("days1");
    var prevLastDay,lastDay, firstDayIndex, lastDayIndex, nextDays, lastMonthDt, lastMonthStr, nextMonthDt, nextMonthStr;
	var nextYear,year;
	var todayDate = new Date();
	todayDate = new Date(todayDate.getFullYear()+ "/" + (todayDate.getMonth() + 1).toString().padStart(2,0) + "/" + todayDate.getDate().toString().padStart(2,0))
    
    var days = "";
	/*
	if(date !== "") {
		currentDate = new Date(date.replace(/\-/g, "/"));
		currentDateMs = currentDate.getTime();
		g_calendarDate = new Date(currentDateMs);
	}
	else {
		currentDate = new Date(g_calendarDate.getTime());
	} */
	beginningDt = new Date(g_calendarDate.getTime());
	if(g_bYearShowJanuary) { // beginning of year
		beginningDt.setMonth(0);
		year = beginningDt.getFullYear();
	}
	else {
		nextYear = new Date(beginningDt.getTime());
		nextYear.setFullYear(nextYear.getFullYear() + 1);
		year = beginningDt.getFullYear() + " - " + nextYear.getFullYear();
	}
	element = document.getElementById("years");
	if(element !== null)
		element.innerHTML = year;

	currentDate = new Date(beginningDt.getTime());
	monthDays = document.getElementById("months1");
	if(g_bShowEventCountInCalendar)
		sExtra = "<br>";
	for(s=0; s < 12; s++)
	{
		
		currentDateMs = currentDate.getTime();

		
    


		prevLastDay = new Date(currentDate.getFullYear(), currentDate.getMonth(), 0).getDate(); // last day of prev month
		lastDay = new Date(currentDate.getFullYear(), currentDate.getMonth() + 1, 0).getDate(); // last day of current month
	
	
		//var firstDayIndex = date.getDay(); // days are 0 based.  Sat = 0, Sun = 6
		firstDayIndex = new Date(currentDate.getFullYear(),currentDate.getMonth(), 1).getDay(); 
		lastDayIndex = new Date(currentDate.getFullYear(), currentDate.getMonth() + 1, 0).getDay(); // last day of prev month
		nextDays = 7 - lastDayIndex - 1;
	
		lastMonthDt = new Date(currentDate.getFullYear(), currentDate.getMonth() - 1, 0);
		lastMonthStr = lastMonthDt.getFullYear() +  + "-" + (lastMonthDt.getMonth() + 1).toString().padStart(2,0);
		nextMonthDt = new Date(currentDate.getFullYear(), currentDate.getMonth() + 1, 0);
		nextMonthStr = nextMonthDt.getFullYear() +  + "-" + (nextMonthDt.getMonth() + 1).toString().padStart(2,0);
	



		list=[]; 
		//days += "<div class=\"yearMonth\">"; 
		
		days += "<div class=\"yearMonth\">"; 
		days += "<div class=\"yearMonthHeader\"><p class=\"calenderYearMonth\">" + monthsList[currentDate.getMonth()] + "</p></div>";
		if(g_bShowEventCountInCalendar) {
			days += "<div  class=\"yearDaysPlusEvents\">";
			todayClass = "todayPlusEvents";
		}
		else
			days += "<div  class=\"yearDays\">";
		days += "<div>Sun</div><div>Mon</div><div>Tue</div><div>Wed</div><div>Thur</div><div>Fri</div><div>Sat</div>";
		//days += "<div  class=\"days\">";


		for(i = firstDayIndex; i > 0; i--)
		{
			dateStr = lastMonthStr + "-" + (prevLastDay - i + 1).toString().padStart(2,0); 
			days += "<div class=\"prev-date\" ></div>";
			count ++;
		}
		for(i = 1; i <= lastDay; i++)
		{
			dateStr = currentDate.getFullYear() + "-" +(currentDate.getMonth() + 1).toString().padStart(2,0) + "-" + i.toString().padStart(2,0);
			if((i === todayDate.getDate()) && (currentDate.getMonth() === todayDate.getMonth())  && (currentDate.getFullYear() === todayDate.getFullYear())) {
				days += "<div class=\"";
				days += todayClass;
				days += "\" onclick=\"scheduleShowDaySchedule(1, '" + dateStr + "')\">" + sExtra + i  + schedulesGetDayActiveEventCount(dateStr) +"</div>";
			}
			else {
				days += "<div onclick=\"scheduleShowDaySchedule(1, '" + dateStr + "')\">" + sExtra + i  + schedulesGetDayActiveEventCount(dateStr) + "</div>";
			}
			count ++;
		
		}
		//if(count <= 35)
		//	nextDays += 7;
		for(i = 1; i < (nextDays + 1); i++)
		{
			dateStr = nextMonthStr + "-" + i.toString().padStart(2,0);
			days += "<div class=\"next-date\" ></div>";
		}
		days += "</div>";
		days += "</div>";
		currentDate.setMonth(currentDate.getMonth() + 1); // next day
	}
    monthDays.innerHTML = days;
}
function scheduleShowMonthSchedule() {
    var count = 0, i, dateStr;
	var sExtra = "";
    //var monthDays = document.querySelector(".days");
    var monthDays = document.getElementById("days1");
    


    var prevLastDay = new Date(g_calendarDate.getFullYear(), g_calendarDate.getMonth(), 0).getDate(); // last day of prev month
    var lastDay = new Date(g_calendarDate.getFullYear(), g_calendarDate.getMonth() + 1, 0).getDate(); // last day of current month


    //var firstDayIndex = date.getDay(); // days are 0 based.  Sat = 0, Sun = 6
    var firstDayIndex = new Date(g_calendarDate.getFullYear(),g_calendarDate.getMonth(), 1).getDay(); 
    var lastDayIndex = new Date(g_calendarDate.getFullYear(), g_calendarDate.getMonth() + 1, 0).getDay(); // last day of prev month
    var nextDays = 7 - lastDayIndex - 1;

	var lastMonthDt = new Date(g_calendarDate.getFullYear(), g_calendarDate.getMonth() - 1, 0);
	var lastMonthStr = lastMonthDt.getFullYear() +  + "-" + (lastMonthDt.getMonth() + 1).toString().padStart(2,0);
	var nextMonthDt = new Date(g_calendarDate.getFullYear(), g_calendarDate.getMonth() + 1, 0);
	var nextMonthStr = nextMonthDt.getFullYear() +  + "-" + (nextMonthDt.getMonth() + 1).toString().padStart(2,0);

    
    document.querySelector(".date h1").innerHTML = monthsList[g_calendarDate.getMonth()] + " " + g_calendarDate.getFullYear();
    //document.querySelector(".date p").innerHTML = new Date().toDateString();
    var days = "";
	if(g_bShowEventCountInCalendar) {
		sExtra = "<br>";
		todayClass = "todayPlusEvents";
	}
    for(i = firstDayIndex; i > 0; i--)
    {
		dateStr = lastMonthStr + "-" + (prevLastDay - i + 1).toString().padStart(2,0); 
        days += "<div class=\"prev-date\" onclick=\"scheduleShowDaySchedule(1, '" + dateStr + "')\">" + sExtra + (prevLastDay - i + 1) + "</div>";
        count ++;
    }
    for(i = 1; i <= lastDay; i++)
    {
		dateStr = g_calendarDate.getFullYear() + "-" +(g_calendarDate.getMonth() + 1).toString().padStart(2,0) + "-" + i.toString().padStart(2,0);
		if((i === new Date().getDate()) && (g_calendarDate.getMonth() === new Date().getMonth())) {
            days += "<div class=\"";
			days += todayClass;
			days += "\" onclick=\"scheduleShowDaySchedule(1, '" + dateStr + "')\">" + sExtra + i + schedulesGetDayActiveEventCount(dateStr) +"</div>";
		}
        else {
            days += "<div onclick=\"scheduleShowDaySchedule(1, '" + dateStr + "')\">" + sExtra + i  + schedulesGetDayActiveEventCount(dateStr) + "</div>";
		}
        count ++;
    
    }
    if(count <= 35)
        nextDays += 7;
    for(i = 1; i < (nextDays + 1); i++)
    {
		dateStr = nextMonthStr + "-" + i.toString().padStart(2,0);
        days += "<div class=\"next-date\" onclick=\"scheduleShowDaySchedule(1, '" + dateStr + "')\">" + sExtra + i + "</div>";
    }
    monthDays.innerHTML = days;
}

function schedulesGetDayActiveEventCount(day) {
	var result = "", bContinue = false;;
	var i, iCount = 0,startMs, endMs;
	var currentDay, currentDate1;
	
	try {
		
		var currentDate = new Date(day.replace(/\-/g, "/"));
		var currentDateMs = currentDate.getTime();
		if(g_bShowEventCountInCalendar) {
			for(i= 0; i < schedulesList.length; i ++)
			{
				
				schedulesList[i].startingDateMs = Date.parse(schedulesList[i].startingDate.replace(/\-/g, "/"));
				if(schedulesList[i].startingDateMs <= currentDateMs) {
					bContinue = false;
					if(typeof schedulesList[i].end === "undefined") {
						bContinue = true;
						schedulesList[i].endingDateMs = -1;
					}
					else if(schedulesList[i].end === "NONE") {
						bContinue = true;
						schedulesList[i].endingDateMs = -1;
					}
					else {
						schedulesList[i].endingDateMs = Date.parse(schedulesList[i].end.replace(/\-/g, "/"));
						if(currentDateMs <= schedulesList[i].endingDateMs) {
							bContinue = true;
						}
					}
					if(bContinue) {
						bContinue = false;
						if(schedulesList[i].browserType === "DAILY") {
							// no more checking needed
							bContinue = true;
						}
						else if(schedulesList[i].browserType === "EVERY_WEEKDAY") {
							// no more checking needed
							currentDay = currentDate.getDay();  // sun-sat 0-6
							if((currentDay > 0) && (currentDay < 6))
								bContinue = true; 
						}
						else if(schedulesList[i].browserType === "EVERY_WEEKEND_DAY") {
							// no more checking needed
							currentDay = currentDate.getDay();
							if((currentDay === 0) || (currentDay === 6))
								bContinue = true; 
						}
						else if(schedulesList[i].browserType === "NO_REPEAT") {
							// no more checking needed
							bContinue = true; 
						}
						else if(schedulesList[i].browserType === "CUSTOM_WEEKLY") {
							currentDay = currentDate.getDay();
							if(currentDay === schedulesList[i].metadata.dayOfWeek) //currentDate.getDay() = Sun-Sat 0-6 // metadata.dayOfWeek = Mon-Sun 1-4
								bContinue = true;
						}
						else if(schedulesList[i].browserType === "CUSTOM_MONTHLY") {
							if(schedulesList[i].metadata.customMonthlyOption === "DAY_OF_THE_MONTH") {
								if(schedulesList[i].metadata.monthOption === -1) {
									currentDate1 = currentDate.getDate();
									if(currentDate1 === schedulesList[i].metadata.day)
										bContinue = true;
								}
								else {
									if((schedulesList[i].metadata.monthOption === currentDate1) && (currentDate1 === schedulesList[i].metadata.day))
										bContinue = true;
								}
							}
							else if(schedulesList[i].metadata.customMonthlyOption === "WEEK_NUMBER_AND_DAY_OF_WEEK") {
								if(schedulesList[i].metadata.monthOption === -1) {
									currentDay = currentDate.getDay();
									if(schedulesList[i].metadata.dayOfWeek === (currentDay + 1))
										bContinue = true;
								}
								else  {
									if((schedulesList[i].metadata.monthOption === (currentDay + 1)) && ((currentDay + 1) === schedulesList[i].metadata.dayOfWeek))
										bContinue = true;
								}
							}
						}
					}
					if(bContinue) {
						iCount ++;
					}
				}
			}
			if(iCount > 0)
				result = "<br><span style=\"display:block;margin-top:10px\">(" + iCount.toString() + ")</span>";
			//result = "<span style=\"margin-top:15px\">(" + iCount.toString() + ")</span>";
			//result = "<span class=\"scheduleEventCount\">" + iCount.toString() + "</span>";
		}
	}
	catch {}
	return result;
}
function schedulesGetDayActiveEventCount_old(day) {
	var result = "";
	var i, iCount = 0,startMs, endMs;
	
	try {
		
		var d = new Date(day.replace(/\-/g, "/"));
		var dayMs = d.getTime();
		if(g_bShowEventCountInCalendar) {
			for(i= 0; i < schedulesList.length; i ++)
			{
				
				startMs = Date.parse(schedulesList[i].start);
				if(dayMs >= startMs) {
					if(schedulesList[i].metadata.endDateType === "NONE")
						iCount ++;
					else if(schedulesList[i].metadata.repeatOption === "NO_REPEAT") {
						if(dayMs >= startMs)
							iCount ++;
					}
					else {
						if(schedulesList[i].hasOwnProperty("end")) {
							endMs = Date.parse(schedulesList[i].start);
							if(dayMs <= endMs)
								iCount ++;
						}
						else
							iCount ++;
					}
				}
			}
			if(iCount > 0)
				result = "<br><span style=\"display:block;margin-top:10px\">(" + iCount.toString() + ")</span>";
			//result = "<span style=\"margin-top:15px\">(" + iCount.toString() + ")</span>";
			//result = "<span class=\"scheduleEventCount\">" + iCount.toString() + "</span>";
		}
	}
	catch {}
	return result;
}
function scheduleShowWeekSchedule1(mode, date, pathname) {
	// use Day calender
	var element, menuButton, menuContent = "", paneContent = "", i, j, k, s, t, z, iPtr, bContinue, bContinue1;
	var startDate, endDate;
	var currentDate, currentDateMs, currentDay, currentDate1, startingDateMs, endingDateMs, tempObj, i, list=[], timeList = [],bucket = [], timeObj, slotIndex, currentDateStr = "";
	var x,y,offsets, menuDivYOffset = 100;
	var content, sTemp, width, height, items, slotsMax, sizePerSlot, bMultiDayEvent;
	var sTemp;
	var len;
	var tblName = "scheduleListTable"
	var todayDate = new Date();
	var beginningDt, endingDt;
	var dateStr = "";
	var solar, sunrise, sunset, iTemp, items,todayDateMs,oneJan;
	var weekNum = 1;
	var bSlotsMaxReached = false;
	var bHasStart;
	todayDate = new Date(todayDate.getFullYear(), todayDate.getMonth(),todayDate.getDate());
	todayDateMs = todayDate.getTime();
	
	


	try {
		addWeekCalendar(0);
		if(date !== "") {
			currentDate = new Date(date.replace(/\-/g, "/"));
			currentDateMs = currentDate.getTime();
			g_calendarDate = new Date(currentDateMs);
		}
		else {
			currentDate = new Date(g_calendarDate.getTime());
			currentDateMs = currentDate.getTime();
		}
		


		beginningDt = new Date(g_calendarDate.getTime());
		endingDt = new Date(g_calendarDate.getTime());
		dateStr =   beginningDt.getFullYear()+ "/" + (beginningDt.getMonth() + 1).toString().padStart(2,0) + "/" + beginningDt.getDate().toString().padStart(2,0);
		beginningDt = new Date(dateStr);
		beginningDt.setDate(beginningDt.getDate() - g_calendarDate.getDay());
		dateStr =  (beginningDt.getMonth() + 1).toString().padStart(2,0) + "/" + beginningDt.getDate().toString().padStart(2,0) + "/" + beginningDt.getFullYear();
		endingDt.setDate(endingDt.getDate() - (7 - g_calendarDate.getDay()));
		dateStr += " - " + (endingDt.getMonth() + 1).toString().padStart(2,0) + "/" + endingDt.getDate().toString().padStart(2,0) + "/"  + endingDt.getFullYear();

		//alert(currentDate);
		//currentDateMs = currentDate.getTime();
		//dateStr = daysList[currentDate.getDay()].substr(0,3) + " " + monthsList[currentDate.getMonth()].substr(0,3) + " " + currentDate.getDate() + " " + currentDate.getFullYear();

		oneJan = new Date(beginningDt.getFullYear(),0,1);
		
		weekNum = Math.floor((beginningDt - oneJan) / (24 * 60 * 60 * 1000));
		weekNum = Math.ceil(( beginningDt.getDay() + 1 + weekNum) / 7);
		dateStr = monthsList[beginningDt.getMonth()] + " " + beginningDt.getFullYear();// + " Week[" + weekNum + "]";;
		document.querySelector(".date h1").innerHTML = dateStr;
		element = document.getElementById("planningDiv");
		menuButton = document.getElementById("calendarContainerId");
		if((menuButton === null) || (element === null))
			return;

		offsets = menuButton.getBoundingClientRect(); 
		x = offsets.x + window.pageXOffset; // takes into account viewport (scrolling)
		y = offsets.y + window.pageYOffset - menuDivYOffset; // takes into account viewport (scrolling)
		element.style.left = x.toString() + "px";
		element.style.top = y.toString() + "px";
		element.innerHTML = menuContent;
		//element.className = "scheduleShowDaySchedule";  // doesn't currently guaranty that menu is shown in viewport

		g_bInoreMouseClick = true;
		for(s = 0; s < 7; s++)
		{
			currentDate = new Date(beginningDt.getTime());
			currentDateMs = currentDate.getTime();
			currentDateStr = currentDate.getFullYear()+ "/" + (currentDate.getMonth() + 1).toString().padStart(2,0) + "/" + currentDate.getDate().toString().padStart(2,0);
			list=[]; timeList = [];bucket = [];
			//create list of only events for this day
			for(i= 0; i < schedulesList.length; i ++)
			{
				
				schedulesList[i].startingDateMs = Date.parse(schedulesList[i].startingDate.replace(/\-/g, "/"));
				if(schedulesList[i].startingDateMs <= currentDateMs) {
					bContinue = false;
					if(typeof schedulesList[i].end === "undefined") {
						bContinue = true;
						schedulesList[i].endingDateMs = -1;
					}
					else if(schedulesList[i].end === "NONE") {
						bContinue = true;
						schedulesList[i].endingDateMs = -1;
					}
					else {
						schedulesList[i].endingDateMs = Date.parse(schedulesList[i].end.replace(/\-/g, "/"));
						if(currentDateMs <= schedulesList[i].endingDateMs) {
							bContinue = true;
						}
					}
					if(bContinue) {
						bContinue = false;
						if(schedulesList[i].browserType === "DAILY") {
							// no more checking needed
							bContinue = true;
						}
						else if(schedulesList[i].browserType === "EVERY_WEEKDAY") {
							// no more checking needed
							currentDay = currentDate.getDay();  // sun-sat 0-6
							if((currentDay > 0) && (currentDay < 6))
								bContinue = true; 
						}
						else if(schedulesList[i].browserType === "EVERY_WEEKEND_DAY") {
							// no more checking needed
							currentDay = currentDate.getDay();
							if((currentDay === 0) || (currentDay === 6))
								bContinue = true; 
						}
						else if(schedulesList[i].browserType === "NO_REPEAT") {
							// no more checking needed
							bContinue = true; 
						}
						else if(schedulesList[i].browserType === "CUSTOM_WEEKLY") {
							currentDay = currentDate.getDay();
							if(currentDay === schedulesList[i].metadata.dayOfWeek) //currentDate.getDay() = Sun-Sat 0-6 // metadata.dayOfWeek = Mon-Sun 1-4
								bContinue = true;
						}
						else if(schedulesList[i].browserType === "CUSTOM_MONTHLY") {
							if(schedulesList[i].metadata.customMonthlyOption === "DAY_OF_THE_MONTH") {
								if(schedulesList[i].metadata.monthOption === -1) {
									currentDate1 = currentDate.getDate();
									if(currentDate1 === schedulesList[i].metadata.day)
										bContinue = true;
								}
								else {
									if((schedulesList[i].metadata.monthOption === currentDate1) && (currentDate1 === schedulesList[i].metadata.day))
										bContinue = true;
								}
							}
							else if(schedulesList[i].metadata.customMonthlyOption === "WEEK_NUMBER_AND_DAY_OF_WEEK") {
								if(schedulesList[i].metadata.monthOption === -1) {
									currentDay = currentDate.getDay();
									if(schedulesList[i].metadata.dayOfWeek === (currentDay + 1))
										bContinue = true;
								}
								else  {
									if((schedulesList[i].metadata.monthOption === (currentDay + 1)) && ((currentDay + 1) === schedulesList[i].metadata.dayOfWeek))
										bContinue = true;
								}
							}
						}
					}
					if(bContinue) {
						// check if overlaps multiple days
						bMultiDayEvent = false;
						if((typeof schedulesList[i].startingDate !== "undefined") && (typeof schedulesList[i].endingDate !== "undefined")) {
							if(schedulesList[i].startingDate !== schedulesList[i].endingDate)
							bMultiDayEvent = true;
						}
						list.push(JSON.parse(JSON.stringify(schedulesList[i])));
						if(bMultiDayEvent) {
							// event spans mulitple days so create up to two events - need to check if 
							z = list.length - 1;
							list[z].overlappingDay = true;
							startingDateMs = Date.parse(schedulesList[i].startingDate.replace(/\-/g, "/"));
							endingDateMs = Date.parse(schedulesList[i].endingDate.replace(/\-/g, "/"));
							list[z].origStartingTime = list[z].startingTime;
							list[z].origEndingTime = list[z].endingTime;
							list[z].origStartingDateMs = startingDateMs;
							list[z].origEndingDateMs = endingDateMs;
							list[z].origStartingOffsetType = list[z].metadata.startingOffsetType;
							list[z].origEndingOffsetType = list[z].metadata.endingOffsetType;
							list[z].origStartingOffset = JSON.parse(JSON.stringify(list[z].metadata.startingOffset));
							list[z].origEndingOffset = JSON.parse(JSON.stringify(list[z].metadata.endingOffset));
							if(((startingDateMs + (24 * 60 * 60 * 1000)) <= currentDateMs) && (endingDateMs <= currentDateMs)) {
								list.push(JSON.parse(JSON.stringify(schedulesList[i])));
								if((list[z].metadata.startingOffsetType === "SUNRISE") || (list[z].metadata.startingOffsetType === "SUNSET")) {
									//list[z].metadata.endingOffset = JSON.parse(JSON.stringify(list[z].metadata.startingOffset))
									list[z].metadata.startingOffset = {};
									list[z].metadata.startingOffset.isNegative = false;
									list[z].metadata.startingOffsetType = "LOCAL_TIME";
								}
								// remove list[z].endingTime = list[z].startingTime;
								list[z].startingTime = "00:00";
								list[z].startingDate = list[z + 1].endingDate;
								list[z + 1].overlappingDay = true;
								list[z + 1].origStartingTime = list[z + 1].startingTime;
								list[z + 1].origEndingTime = list[z + 1].endingTime;
								list[z + 1].origStartingDateMs = startingDateMs;
								list[z + 1].origEndingDateMs = endingDateMs;
								list[z + 1].origStartingOffsetType = list[z + 1].metadata.startingOffsetType;
								list[z + 1].origEndingOffsetType = list[z + 1].metadata.endingOffsetType;
								list[z + 1].origStartingOffset = JSON.parse(JSON.stringify(list[z + 1].metadata.startingOffset));
								list[z + 1].origEndingOffset = JSON.parse(JSON.stringify(list[z + 1].metadata.endingOffset));
								if((list[z + 1].metadata.endingOffsetType === "SUNRISE") || (list[z + 1].metadata.endingOffsetType === "SUNSET")) {
									//list[z + 1].metadata.startingOffset = JSON.parse(JSON.stringify(list[z + 1].metadata.endingOffset))
									list[z + 1].metadata.endingOffset = {};
									list[z + 1].metadata.endingOffset.isNegative = false;
									list[z + 1].metadata.endingOffsetType = "LOCAL_TIME";
								}
								// remove list[z + 1].startingTime = list[z + 1].endingTime;
								list[z + 1].endingTime = "24:00";
								list[z + 1].endingDate = list[z + 1].startingDate;
							}
							else if((startingDateMs + (24 * 60 * 60 * 1000)) <= currentDateMs)  { //if(endingDateMs <= currentDateMs) {
								// If single event - 2nd day
								list[z].origStartingTime = list[z].startingTime;
								list[z].origEndingTime = list[z].endingTime;
								list[z].origStartingDateMs = startingDateMs;
								list[z].origEndingDateMs = endingDateMs;
								list[z].origStartingOffsetType = list[z].metadata.startingOffsetType;
								list[z].origEndingOffsetType = list[z].metadata.endingOffsetType;
								list[z].origStartingOffset = JSON.parse(JSON.stringify(list[z].metadata.startingOffset));
								list[z].origEndingOffset = JSON.parse(JSON.stringify(list[z].metadata.endingOffset));
								if((list[z].metadata.startingOffsetType === "SUNRISE") || (list[z].metadata.startingOffsetType === "SUNSET")) {
									//list[z].metadata.endingOffset = JSON.parse(JSON.stringify(list[z].metadata.startingOffset))
									list[z].metadata.startingOffset = {};
									list[z].metadata.startingOffset.isNegative = false;
									list[z].metadata.startingOffsetType = "LOCAL_TIME";
								}
								// remove list[z].endingTime = list[z].startingTime;
								list[z].startingTime = "00:00";
								list[z].startingDate = list[z].endingDate;
							}
							else {
								//first day event is valid
								list[z].origStartingTime = list[z].startingTime;
								list[z].origEndingTime = list[z].endingTime;
								list[z].origStartingDateMs = startingDateMs;
								list[z].origEndingDateMs = endingDateMs;
								list[z].origStartingOffsetType = list[z].metadata.startingOffsetType;
								list[z].origEndingOffsetType = list[z].metadata.endingOffsetType;
								list[z].origStartingOffset = JSON.parse(JSON.stringify(list[z].metadata.startingOffset));
								list[z].origEndingOffset = JSON.parse(JSON.stringify(list[z].metadata.endingOffset));
								if((list[z].metadata.endingOffsetType === "SUNRISE") || (list[z].metadata.endingOffsetType === "SUNSET")) {
									list[z].metadata.endingOffset = {};
									list[z].metadata.endingOffset.isNegative = false;
									list[z].metadata.endingOffsetType = "LOCAL_TIME";
								}
								// remove list[z].startingTime = list[z].endingTime;
								list[z].endingTime = "24:00";
								list[z].endingDate = list[z].startingDate;
							}
						}
					}
				}
			}
			solar = new solarCalc(currentDate,g_dLatitude, g_dLongitude);
			//sunrise =  (new Date(solar.sunrise).toLocaleTimeString('en-GB'));
			//sunset = (new Date(solar.sunset).toLocaleTimeString('en-GB'));
			for(i=0; i < list.length; i++) 
			{
				if(list[i].metadata.hasOwnProperty("allDay")) {
					if(list[i].metadata.allDay)
						list[i].endingTime = "24:00";
				}
				if(list[i].metadata.startingOffsetType === "SUNRISE") {
					list[i].startingTimeOrig = list[i].startingTime;
					if(g_bUseFixedSunsriseSunset)
						list[i].startingTime = "06:00"; //navtree fix - determine real sunrise
					else {
						try{
							sunrise = new Date(solar.sunrise).getTime();
							iTemp = ((list[i].metadata.startingOffset.hours * 60 * 60) + (list[i].metadata.startingOffset.minutes * 60)) * 1000;
							if(list[i].metadata.startingOffset.isNegative)
								iTemp = -iTemp;
							sunrise = new Date(sunrise + iTemp).toLocaleTimeString('en-GB');
							items = sunrise.split(":");
							sunrise = items[0] + ":" + items[1];
							list[i].startingTime = sunrise; 
						}
						catch {}
					}
				}
				else if(list[i].metadata.startingOffsetType === "SUNSET") {
					list[i].startingTimeOrig = list[i].startingTime;
					if(g_bUseFixedSunsriseSunset)
						list[i].startingTime = "18:00"; //navtree fix - determine real sunset
					else {
						try{
							sunset = new Date(solar.sunset).getTime();
							iTemp = ((list[i].metadata.startingOffset.hours * 60 * 60) + (list[i].metadata.startingOffset.minutes * 60)) * 1000;
							if(list[i].metadata.startingOffset.isNegative)
								iTemp = -iTemp;
							sunset = new Date(sunset + iTemp).toLocaleTimeString('en-GB');
							items = sunset.split(":");
							sunset = items[0] + ":" + items[1];
							list[i].startingTime = sunset; 
						}
						catch {}
					}
				}
				if(list[i].metadata.endingOffsetType === "SUNRISE") {
					list[i].endingTimeOrig = list[i].endingTime;
					if(g_bUseFixedSunsriseSunset)
						list[i].endingTime = "06:00"; //navtree fix - determine real sunrise
					else {
						try{
							sunrise = new Date(solar.sunrise).getTime();
							iTemp = ((list[i].metadata.endingOffset.hours * 60 * 60) + (list[i].metadata.endingOffset.minutes * 60)) * 1000;
							if(list[i].metadata.endingOffset.isNegative)
								iTemp = -iTemp;
							sunrise = new Date(sunrise + iTemp).toLocaleTimeString('en-GB');
							items = sunrise.split(":");
							sunrise = items[0] + ":" + items[1];
							list[i].endingTime = sunrise; 
						}
						catch {}
					}
				}
				else if(list[i].metadata.endingOffsetType === "SUNSET") {
					list[i].endingTimeOrig = list[i].endingTime;
					if(g_bUseFixedSunsriseSunset)
						list[i].endingTime = "18:00"; //navtree fix - determine real sunset
					else {
						try{
							sunset = new Date(solar.sunset).getTime();
							iTemp = ((list[i].metadata.endingOffset.hours * 60 * 60) + (list[i].metadata.endingOffset.minutes * 60)) * 1000;
							if(list[i].metadata.endingOffset.isNegative)
								iTemp = -iTemp;
							sunset = new Date(sunset + iTemp).toLocaleTimeString('en-GB');
							items = sunset.split(":");
							sunset = items[0] + ":" + items[1];
							list[i].endingTime = sunset; 
						}
						catch {}
					}
				}
			}
			
			if(list.length > 0) {
				// determine length of event
				for(i=0; i < list.length; i++) 
				{
					list[i].width = -1;
					sTemp = list[i].startingTime.trim();
					items = sTemp.split(":");
					list[i].startingTimeMin = (Number(items[0]) * 60) + Number(items[1]);
					sTemp = list[i].endingTime.trim();
					items = sTemp.split(":");
					list[i].endingTimeMin = (Number(items[0]) * 60) + Number(items[1]);
					list[i].size = list[i].endingTimeMin - list[i].startingTimeMin;
					list[i].bNeedToProcess = true;
					list[i].slotIndex = -1;
				}
				// 48 30 buckets
				for(i=0; i < 48; i++)
				{ // two entries per hour
					timeObj = {};
					timeObj.start = i * 30;
					timeObj.end = timeObj.start + 30;
					timeObj.slots = [];
					timeList.push(JSON.parse(JSON.stringify(timeObj)));
				}
				// determine how many events per time row, use side by side for event, need to take into account buckets already full, so no overlapping 
					// process based on longest events first, so longest are to the left, fill in holes on left of events with smaller events.
				
				for(i=0; i < list.length; i++) 
				{
					// find largest
					z = i;
					/*
					for(j=0; j < list.length; j++) 
					{
						// find largest
						if(list[j].bNeedToProcess) {
							if(z === -1)
								z = j;
							else {
								if(list[j].size > list[z].size) {
									z = j;
								}
							}
							
						}
					} */
					if(z !== -1) {
						// determine what buckets are free in each timeObj, use left most if empty
						bContinue = true;
						startingIndex = list[z].startingTimeMin / 30;
						list[z].startingIndex = startingIndex;

						if(!Number.isInteger(startingIndex)) {
							list[z].startingIndex = parseInt(startingIndex);

						}
						list[z].slotIndex = 0;
						if(list.length > 0) {
							while(bContinue) {
								bContinue = false;
								bContinue1 = false;
								for(j=list[z].startingIndex; j < 48; j++)
								{
									if(timeList[j].slots.length === list[z].slotIndex) {
										bContinue = true;
										
										if(((list[z].endingTimeMin) <= timeList[j].end) || (j === 47)) {
											// this slotIndex is free
											list[z].bNeedToProcess = false;
											list[z].endingIndex = j;
											bContinue = false;
											break;
										}
									}
									else if(timeList[j].slots.length > list[z].slotIndex) {
										// check for empty slots
										t = 0;
										for(k=list[z].slotIndex; k < timeList[j].slots.length; k++)
										{
											if(timeList[j].slots[k] === -1) {
												t = 2;
												if(k !== list[z].slotIndex) {
													t = 1;
													list[z].slotIndex = k;
												}
												
												break;
											}
										}
										if(t === 0) {
											list[z].slotIndex = timeList[j].slots.length;
										if(t < 2)
											bContinue = true;
											break; // restart slot check
										}
										else {
											if(((list[z].endingTimeMin) <= timeList[j].end) || (j === 47)) {
												// this slotIndex is free
												list[z].bNeedToProcess = false;
												list[z].endingIndex = j;
												bContinue = false;
												break;
											}
										}
									}
									else  {
										if(((list[z].endingTimeMin) <= timeList[j].end) || (j === 47)) {
											// this slotIndex is free
											list[z].bNeedToProcess = false;
											list[z].endingIndex = j;
											bContinue = false;
											break;
										}
									}
								}
							}
						}
						//found slotIndex so up date update - add slot infoto
						for(j=list[z].startingIndex; j < list[z].endingIndex + 1; j++)
						{
							if(timeList[j].slots.length ===  list[z].slotIndex) 
								timeList[j].slots.push(z);
							else if(timeList[j].slots.length > list[z].slotIndex) 
								timeList[j].slots.push(z);
							else {
								//
								len = list[z].slotIndex - timeList[j].slots.length;
								for(k=0; k < len; k++)
								{
									timeList[j].slots.push(-1);
								}
								timeList[j].slots.push(z);
							}
						}
					}
				} //for(i=0; i < list.length; i++) 
				
				//determin maximum number of slots
				slotsMax = 0;
				sTemp = "";
				bSlotsMaxReached = false;
				for(j=0; j < timeList.length; j++)
				{
					if(timeList[j].slots.length > slotsMax) {
						slotsMax =  timeList[j].slots.length;
						if(slotsMax > g_iScheduleWeekMaxTimeSlots) {
							slotsMax =  g_iScheduleWeekMaxTimeSlots;
							bSlotsMaxReached = true;
							break;
						}
					}
					sTemp = j + ": " + JSON.stringify(timeList[j].slots);


				}
				
				sizePerSlot = 200;
				if(slotsMax !== 0)
					sizePerSlot = sizePerSlot / slotsMax
				// populate events - may consider using side by side for event
				//process all slot 0 first followed by slot 1 and so on.  Will need to add padding if slots are not ajacent
				
				for(i=0; i < list.length; i++) 
				{ 
					element = document.getElementById("daytimevalue_" + s + "_" + list[i].startingIndex);
					if(element !== null) {
						//offsets = element.getBoundingClientRect(); 
						//x = offsets.x + offsets.width + window.pageXOffset + (sizePerSlot * list[i].slotIndex); // takes into account viewport (scrolling)
						if(list[i].slotIndex < (g_iScheduleWeekMaxTimeSlots - 1)) {
							x = (sizePerSlot * list[i].slotIndex)
							y = list[i].startingIndex * 30;
							y = (list[i].startingTimeMin - y) * 27 / 30;
							//y = offsets.y + window.pageYOffset + y; // takes into account viewport (scrolling)
							if(!Number.isInteger(y)) {
								y = parseInt(y);

							}
							width = sizePerSlot;
							height = list[i].size * 27 / 30;
							if(height < g_iScheduleEventMinHeight)
								height = g_iScheduleEventMinHeight;
								
							content = "<div class=\"scheduleEventDiv\" style=\"color:";
							content += determineTextColorBasedOnDarkness(list[i].color);
							content += ";top:" + y + "px;left:" + x + "px;width:" + width + "px;height:" + height + "px;background-color:"
							content += list[i].color + ";border:1px solid;box-sizing:border-box\"";
							content += " onclick=\"scheduleShowEventDetail(this,3," + list[i].id + ",'" + currentDateStr + "')\"";
							content += " title=\"";
							content += list[i].name;
							content += "\r\ntype = " + list[i].browserType;
							content += "\r\npriority = ";
							if((list[i].priority === "17")  || (list[i].priority === 17))
								content += "normal";
							else
								content += list[i].priority;
							content += "\r\nvalue = ";

							if(typeof list[i].presetName !== "undefined")
								sTemp = list[i].presetName;
							else {
								sTemp = list[i].value;
								if(sTemp !== null) {
									if(sTemp.length > 2) {
										if((sTemp.charAt(0) === "{") || (sTemp.charAt(0) === "[")) {
											sTemp = sTemp.substr(1, sTemp.length - 2);
										}
									}
									if(sTemp.length > 0) {
										sTemp = sTemp.replace(/\"/g,"&quot;");
										if(sTemp.length > 50)
											sTemp = sTemp.substr(0,50) + "...";
									}
								}
							}
							bHasStart = false;
							// add times for sunrise and sunset
							sTemp += "\r\nstart time = ";
							if(typeof list[i].overlappingDay !== "undefined") {
								sTemp += determineTimeStrFromSolorTime(solar, list[i].origStartingOffsetType, list[i].origStartingOffset.hours,
									list[i].origStartingOffset.minutes, list[i].origStartingOffset.isNegative, list[i].origStartingTime);
							}
							else {
							
								bHasStart = true;
								if(g_b12hourClock) {
									iPtr = list[i].startingTime.indexOf(":");
									iTemp = list[i].startingTime.substr(0,iPtr);
									try {
										iTemp = Number(iTemp);
										if(iTemp < 12) {
											if(iTemp === 0)
												sTemp += 12;
											else
												sTemp += iTemp.toString();
											sTemp += list[i].startingTime.substr(iPtr) + "AM";
										}
										else {	
											iTemp -= 12;
											if(iTemp === 0)
												sTemp += 12;
											else
												sTemp += iTemp.toString();
											sTemp += list[i].startingTime.substr(iPtr) + "PM";
										}
									}
									catch {}
								}
								else 
									sTemp += list[i].startingTime;
								if(list[i].metadata.startingOffsetType === "SUNRISE") {
									sTemp += " (";
									if((list[i].metadata.startingOffset.hours !== 0) || (list[i].metadata.startingOffset.minutes !== 0)) {
										if(list[i].metadata.startingOffset.hours !== 0) 
											sTemp += list[i].metadata.startingOffset.hours + " hours ";
										if(list[i].metadata.startingOffset.minutes !== 0) 
											sTemp += list[i].metadata.startingOffset.minutes + " minutes ";
										if(list[i].metadata.startingOffset.isNegative)
											sTemp += "before ";
										else	
											sTemp += "after ";
									}
									sTemp += "sunrise)";
								}
								else if(list[i].metadata.startingOffsetType === "SUNSET") {
									sTemp += " (";
									if((list[i].metadata.startingOffset.hours !== 0) || (list[i].metadata.startingOffset.minutes !== 0)) {
										if(list[i].metadata.startingOffset.hours !== 0) 
											sTemp += list[i].metadata.startingOffset.hours + " hours ";
										if(list[i].metadata.startingOffset.minutes !== 0) 
											sTemp += list[i].metadata.startingOffset.minutes + " minutes ";
										if(list[i].metadata.startingOffset.isNegative)
											sTemp += "before ";
										else	
											sTemp += "after ";
									}
									sTemp += "sunset)";
								}
							}
							sTemp += "\r\n";
							sTemp += "end time = ";
							if(typeof list[i].overlappingDay !== "undefined") {
								sTemp += determineTimeStrFromSolorTime(solar, list[i].origEndingOffsetType, list[i].origEndingOffset.hours,
									list[i].origEndingOffset.minutes, list[i].origEndingOffset.isNegative, list[i].origEndingTime);
							}
							else {
								if(g_b12hourClock) {
									if(list[i].endingTime === "24:00")
										sTemp += "12:00AM";
									else {
										iPtr = list[i].endingTime.indexOf(":");
										iTemp = list[i].endingTime.substr(0,iPtr);
										try {
											iTemp = Number(iTemp);
											if(iTemp < 12) {
												if(iTemp === 0)
													sTemp += 12;
												else
													sTemp += iTemp.toString();
												sTemp += list[i].endingTime.substr(iPtr) + "AM";
											}
											else {	
												iTemp -= 12;
												if(iTemp === 0)
													sTemp += 12;
												else
													sTemp += iTemp.toString();
												sTemp += list[i].endingTime.substr(iPtr) + "PM";
											}
										}
										catch {}
									}
								}
								else {
									if(list[i].endingTime === "24:00")
										sTemp += "00:00";
									else
										sTemp += list[i].endingTime;
								}
								if(list[i].metadata.endingOffsetType === "SUNRISE") {
									sTemp += " (";
									if((list[i].metadata.endingOffset.hours !== 0) || (list[i].metadata.endingOffset.minutes !== 0)) {
										if(list[i].metadata.endingOffset.hours !== 0) 
											sTemp += list[i].metadata.endingOffset.hours + " hours ";
										if(list[i].metadata.endingOffset.minutes !== 0) 
											sTemp += list[i].metadata.endingOffset.minutes + " minutes ";
										if(list[i].metadata.endingOffset.isNegative)
											sTemp += "before ";
										else	
											sTemp += "after ";
									}
									sTemp += "sunrise)";
								}
								else if(list[i].metadata.endingOffsetType === "SUNSET") {
									sTemp += " (";
									if((list[i].metadata.endingOffset.hours !== 0) || (list[i].metadata.endingOffset.minutes !== 0)) {
										if(list[i].metadata.endingOffset.hours !== 0) 
											sTemp += list[i].metadata.endingOffset.hours + " hours ";
										if(list[i].metadata.endingOffset.minutes !== 0) 
											sTemp += list[i].metadata.endingOffset.minutes + " minutes ";
										if(list[i].metadata.endingOffset.isNegative)
											sTemp += "before ";
										else	
											sTemp += "after ";
									}
									sTemp += "sunset)";
								}
							}
							
							if(g_bScheduleToolTipShowDpCount) {
								sTemp += "\r\ndatapoints = ";
								if(typeof list[i].datapoints !== "undefined") {
									if(list[i].datapoints.length === 0)
										sTemp += "none";
									else
										sTemp += list[i].datapoints.length;
								}
								else 
									sTemp += "none";
							}
							if(g_bScheduleToolTipShowDpList) {
								sTemp += "\r\n";
								if(typeof list[i].browserDatapointList !== "undefined") {
									for(m=0;m < list[i].browserDatapointList.length; m++)
									{
										sTemp += list[i].browserDatapointList[m].path;
										if(m > 5) {
											sTemp += "\r\n  :";
											Temp += list[i].browserDatapointList[list[i].browserDatapointList.length - 1].path;
											break;
										}
									}
								}
							}
							content += sTemp + "\">";
							if(list[i].metadata.startingOffsetType === "SUNRISE")
								content += "<img src=\"images/navtree/SunUp.gif\" alt=\"sunrise\" class=\"imgTopDiv\">";
							else if(list[i].metadata.startingOffsetType === "SUNSET")
								content += "<img src=\"images/navtree/SunDown.gif\" alt=\"sunrise\" class=\"imgTopDiv\">";
							content += "<span class=\"scheduleEventDivSpan\" style=\"width:" + (sizePerSlot - 10) + "px\">" + list[i].name + "</span>";
							if(list[i].metadata.endingOffsetType === "SUNRISE")
								content += "<img src=\"images/navtree/SunUp.gif\" alt=\"sunrise\" class=\"imgBottomDiv\">";
							else if(list[i].metadata.endingOffsetType === "SUNSET")
								content += "<img src=\"images/navtree/SunDown.gif\" alt=\"sunrise\" class=\"imgBottomDiv\">";
							content += "</div>";
							element.innerHTML += content;
						}
					}
				}
				if(bSlotsMaxReached) {
					element = document.getElementById("daytimevalue_" + s + "_0");
					if(element !== null) {
						x = (sizePerSlot * (g_iScheduleWeekMaxTimeSlots - 1));
						y = 0;
						//y = offsets.y + window.pageYOffset + y; // takes into account viewport (scrolling)
						
						width = sizePerSlot;
						height = (24 * 60) * 27 / 30; // 24hr * 60 min/hr
						if(height < g_iScheduleEventMinHeight)
							height = g_iScheduleEventMinHeight;
							
						content = "<div class=\"scheduleEventDiv\" style=\"color:black";
						content += ";top:" + y + "px;left:" + x + "px;width:" + width + "px;height:" + height + "px;background-color:"
						content += "white;border:1px solid;box-sizing:border-box\"";
						content += " onclick=\"scheduleShowDaySchedule(1,'" + currentDateStr + "')\"";
						content += " title=\"Not all events can be shown,\r\nclick to see all events for this day";
						content += "\">...</div>";
						element.innerHTML += content;
					}
				}
			}
			beginningDt.setDate(beginningDt.getDate() + 1); // next day
		} // each day  for(s = 0; s < 7; s++)

	}
	catch {
		//alert("i=" + i + ",j=" + j + ",z=" + z);
	}
}
function scheduleShowDaySchedule(mode, date) {
	scheduleShowDaySchedule1(mode, date, "");
}
function scheduleShowDaySchedule1(mode, date, pathname) {
	// use Day calender
	var element, menuButton, menuContent = "", paneContent = "", i, j, k, m, t, z, iPtr, bContinue, bContinue1;
	var startDate, endDate;
	var currentDate, currentDateMs, currentDay, currentDate1, currentDateStr, tempObj, i, list=[], timeList = [],bucket = [], timeObj, slotIndex;
	var x,y,offsets, menuDivYOffset = 100;
	var content, sTemp, width, height, items, slotsMax, sizePerSlot, dateStr;
	var bMultiDayEvent = false;
	var sTemp;
	var len;
	var solar, sunrise, sunset;
	var bHasStart;
	var tblName = "scheduleListTable"

	try {
		addDayCalendar(0);
		if(date !== "") {
			currentDate = new Date(date.replace(/\-/g, "/"));
			currentDateMs = currentDate.getTime();
			g_calendarDate = new Date(currentDateMs);
		}
		else {
			currentDate = new Date(g_calendarDate.getTime());
			currentDateMs = currentDate.getTime();
		}
		
		currentDateStr = currentDate.getFullYear()+ "/" + (currentDate.getMonth() + 1).toString().padStart(2,0) + "/" + currentDate.getDate().toString().padStart(2,0);
		//alert(currentDate);
		//currentDateMs = currentDate.getTime();
		dateStr = daysList[currentDate.getDay()].substr(0,3) + " " + monthsList[currentDate.getMonth()].substr(0,3) + " " + currentDate.getDate() + " " + currentDate.getFullYear();
		document.querySelector(".date h1").innerHTML = dateStr;
		element = document.getElementById("planningDiv");
		menuButton = document.getElementById("calendarContainerId");
		if((menuButton === null) || (element === null))
			return;

		offsets = menuButton.getBoundingClientRect(); 
		x = offsets.x + window.pageXOffset; // takes into account viewport (scrolling)
		y = offsets.y + window.pageYOffset - menuDivYOffset; // takes into account viewport (scrolling)
		element.style.left = x.toString() + "px";
		element.style.top = y.toString() + "px";
		element.innerHTML = menuContent;
		//element.className = "scheduleShowDaySchedule";  // doesn't currently guaranty that menu is shown in viewport

		g_bInoreMouseClick = true;
		//create list of only events for this day
		for(i= 0; i < schedulesList.length; i ++)
		{
			
			schedulesList[i].startingDateMs = Date.parse(schedulesList[i].startingDate.replace(/\-/g, "/"));
			if(schedulesList[i].startingDateMs <= currentDateMs) {
				bContinue = false;
				if(typeof schedulesList[i].end === "undefined") {
					bContinue = true;
					schedulesList[i].endingDateMs = -1;
				}
				else if(schedulesList[i].end === "NONE") {
					bContinue = true;
					schedulesList[i].endingDateMs = -1;
				}
				else {
					schedulesList[i].endingDateMs = Date.parse(schedulesList[i].end.replace(/\-/g, "/"));
					if(currentDateMs <= schedulesList[i].endingDateMs) {
						bContinue = true;
					}
				}
				if(bContinue) {
					bContinue = false;
					if(schedulesList[i].browserType === "DAILY") {
						// no more checking needed
						bContinue = true;
					}
					else if(schedulesList[i].browserType === "EVERY_WEEKDAY") {
						// no more checking needed
						currentDay = currentDate.getDay();  // sun-sat 0-6
						if((currentDay > 0) && (currentDay < 6))
							bContinue = true; 
					}
					else if(schedulesList[i].browserType === "EVERY_WEEKEND_DAY") {
						// no more checking needed
						currentDay = currentDate.getDay();
						if((currentDay === 0) || (currentDay === 6))
							bContinue = true; 
					}
					else if(schedulesList[i].browserType === "NO_REPEAT") {
						// no more checking needed
						bContinue = true; 
					}
					else if(schedulesList[i].browserType === "CUSTOM_WEEKLY") {
						currentDay = currentDate.getDay();
						if(currentDay === schedulesList[i].metadata.dayOfWeek) //currentDate.getDay() = Sun-Sat 0-6 // metadata.dayOfWeek = Mon-Sun 1-4
							bContinue = true;
					}
					else if(schedulesList[i].browserType === "CUSTOM_MONTHLY") {
						if(schedulesList[i].metadata.customMonthlyOption === "DAY_OF_THE_MONTH") {
							if(schedulesList[i].metadata.monthOption === -1) {
								currentDate1 = currentDate.getDate();
								if(currentDate1 === schedulesList[i].metadata.day)
									bContinue = true;
							}
							else {
								if((schedulesList[i].metadata.monthOption === currentDate1) && (currentDate1 === schedulesList[i].metadata.day))
									bContinue = true;
							}
						}
						else if(schedulesList[i].metadata.customMonthlyOption === "WEEK_NUMBER_AND_DAY_OF_WEEK") {
							if(schedulesList[i].metadata.monthOption === -1) {
								currentDay = currentDate.getDay();
								if(schedulesList[i].metadata.dayOfWeek === (currentDay + 1))
									bContinue = true;
							}
							else  {
								if((schedulesList[i].metadata.monthOption === (currentDay + 1)) && ((currentDay + 1) === schedulesList[i].metadata.dayOfWeek))
									bContinue = true;
							}
						}
					}
				}
				if(bContinue) {
					// check if overlaps multiple days
					bMultiDayEvent = false;
					if((typeof schedulesList[i].startingDate !== "undefined") && (typeof schedulesList[i].endingDate !== "undefined")) {
						if(schedulesList[i].startingDate !== schedulesList[i].endingDate)
						bMultiDayEvent = true;
					}
					list.push(JSON.parse(JSON.stringify(schedulesList[i])));
					if(bMultiDayEvent) {
						// event spans mulitple days so create up to two events - need to check if 
						z = list.length - 1;
						list[z].overlappingDay = true;
						startingDateMs = Date.parse(schedulesList[i].startingDate.replace(/\-/g, "/"));
						endingDateMs = Date.parse(schedulesList[i].endingDate.replace(/\-/g, "/"));
						list[z].origStartingTime = list[z].startingTime;
						list[z].origEndingTime = list[z].endingTime;
						list[z].origStartingDateMs = startingDateMs;
						list[z].origEndingDateMs = endingDateMs;
						list[z].origStartingOffsetType = list[z].metadata.startingOffsetType;
						list[z].origEndingOffsetType = list[z].metadata.endingOffsetType;
						list[z].origStartingOffset = JSON.parse(JSON.stringify(list[z].metadata.startingOffset));
						list[z].origEndingOffset = JSON.parse(JSON.stringify(list[z].metadata.endingOffset));
						if(((startingDateMs + (24 * 60 * 60 * 1000)) <= currentDateMs) && (endingDateMs <= currentDateMs)) {
							list.push(JSON.parse(JSON.stringify(schedulesList[i])));
							if((list[z].metadata.startingOffsetType === "SUNRISE") || (list[z].metadata.startingOffsetType === "SUNSET")) {
								//list[z].metadata.endingOffset = JSON.parse(JSON.stringify(list[z].metadata.startingOffset))
								list[z].metadata.startingOffset = {};
								list[z].metadata.startingOffset.isNegative = false;
								list[z].metadata.startingOffsetType = "LOCAL_TIME";
							}
							// remove list[z].endingTime = list[z].startingTime;
							list[z].startingTime = "00:00";
							list[z].startingDate = list[z + 1].endingDate;
							list[z + 1].overlappingDay = true;
							list[z + 1].origStartingTime = list[z + 1].startingTime;
							list[z + 1].origEndingTime = list[z + 1].endingTime;
							list[z + 1].origStartingDateMs = startingDateMs;
							list[z + 1].origEndingDateMs = endingDateMs;
							list[z + 1].origStartingOffsetType = list[z + 1].metadata.startingOffsetType;
							list[z + 1].origEndingOffsetType = list[z + 1].metadata.endingOffsetType;
							list[z + 1].origStartingOffset = JSON.parse(JSON.stringify(list[z + 1].metadata.startingOffset));
							list[z + 1].origEndingOffset = JSON.parse(JSON.stringify(list[z + 1].metadata.endingOffset));
							if((list[z + 1].metadata.endingOffsetType === "SUNRISE") || (list[z + 1].metadata.endingOffsetType === "SUNSET")) {
								//list[z + 1].metadata.startingOffset = JSON.parse(JSON.stringify(list[z + 1].metadata.endingOffset))
								list[z + 1].metadata.endingOffset = {};
								list[z + 1].metadata.endingOffset.isNegative = false;
								list[z + 1].metadata.endingOffsetType = "LOCAL_TIME";
							}
							// remove list[z + 1].startingTime = list[z + 1].endingTime;
							list[z + 1].endingTime = "24:00";
							list[z + 1].endingDate = list[z + 1].startingDate;
						}
						else if((startingDateMs + (24 * 60 * 60 * 1000)) <= currentDateMs)  { //if(endingDateMs <= currentDateMs) {
							// If single event - 2nd day
							list[z].origStartingTime = list[z].startingTime;
							list[z].origEndingTime = list[z].endingTime;
							list[z].origStartingDateMs = startingDateMs;
							list[z].origEndingDateMs = endingDateMs;
							list[z].origStartingOffsetType = list[z].metadata.startingOffsetType;
							list[z].origEndingOffsetType = list[z].metadata.endingOffsetType;
							list[z].origStartingOffset = JSON.parse(JSON.stringify(list[z].metadata.startingOffset));
							list[z].origEndingOffset = JSON.parse(JSON.stringify(list[z].metadata.endingOffset));
							if((list[z].metadata.startingOffsetType === "SUNRISE") || (list[z].metadata.startingOffsetType === "SUNSET")) {
								//list[z].metadata.endingOffset = JSON.parse(JSON.stringify(list[z].metadata.startingOffset))
								list[z].metadata.startingOffset = {};
								list[z].metadata.startingOffset.isNegative = false;
								list[z].metadata.startingOffsetType = "LOCAL_TIME";
							}
							// remove list[z].endingTime = list[z].startingTime;
							list[z].startingTime = "00:00";
							list[z].startingDate = list[z].endingDate;
						}
						else {
							//first day event is valid
							list[z].origStartingTime = list[z].startingTime;
							list[z].origEndingTime = list[z].endingTime;
							list[z].origStartingDateMs = startingDateMs;
							list[z].origEndingDateMs = endingDateMs;
							list[z].origStartingOffsetType = list[z].metadata.startingOffsetType;
							list[z].origEndingOffsetType = list[z].metadata.endingOffsetType;
							list[z].origStartingOffset = JSON.parse(JSON.stringify(list[z].metadata.startingOffset));
							list[z].origEndingOffset = JSON.parse(JSON.stringify(list[z].metadata.endingOffset));
							if((list[z].metadata.endingOffsetType === "SUNRISE") || (list[z].metadata.endingOffsetType === "SUNSET")) {
								list[z].metadata.endingOffset = {};
								list[z].metadata.endingOffset.isNegative = false;
								list[z].metadata.endingOffsetType = "LOCAL_TIME";
							}
							// remove list[z].startingTime = list[z].endingTime;
							list[z].endingTime = "24:00";
							list[z].endingDate = list[z].startingDate;
						}
					}
				}
			}

		}
		// Determine all day and sunrise/sunset events
		
		solar = new solarCalc(currentDate,g_dLatitude, g_dLongitude);
        //sunrise =  (new Date(solar.sunrise).toLocaleTimeString('en-GB'));
        //sunset = (new Date(solar.sunset).toLocaleTimeString('en-GB'));
		for(i=0; i < list.length; i++) 
		{
			if(list[i].metadata.hasOwnProperty("allDay")) {
				if(list[i].metadata.allDay)
					list[i].endingTime = "24:00";
			}
			if(list[i].metadata.startingOffsetType === "SUNRISE") {
				list[i].startingTimeOrig = list[i].startingTime;
				if(g_bUseFixedSunsriseSunset)
					list[i].startingTime = "06:00"; //navtree fix - determine real sunrise
				else {
					try{
						sunrise = new Date(solar.sunrise).getTime();
						iTemp = ((list[i].metadata.startingOffset.hours * 60 * 60) + (list[i].metadata.startingOffset.minutes * 60)) * 1000;
						if(list[i].metadata.startingOffset.isNegative)
							iTemp = -iTemp;
						sunrise = new Date(sunrise + iTemp).toLocaleTimeString('en-GB');
						items = sunrise.split(":");
						sunrise = items[0] + ":" + items[1];
						list[i].startingTime = sunrise; 
					}
					catch {}
				}
			}
			else if(list[i].metadata.startingOffsetType === "SUNSET") {
				list[i].startingTimeOrig = list[i].startingTime;
				if(g_bUseFixedSunsriseSunset)
					list[i].startingTime = "18:00"; //navtree fix - determine real sunset
				else {
					try{
						sunset = new Date(solar.sunset).getTime();
						iTemp = ((list[i].metadata.startingOffset.hours * 60 * 60) + (list[i].metadata.startingOffset.minutes * 60)) * 1000;
						if(list[i].metadata.startingOffset.isNegative)
							iTemp = -iTemp;
						sunset = new Date(sunset + iTemp).toLocaleTimeString('en-GB');
						items = sunset.split(":");
						sunset = items[0] + ":" + items[1];
						list[i].startingTime = sunset; 
					}
					catch {}
				}
			}
			if(list[i].metadata.endingOffsetType === "SUNRISE") {
				list[i].endingTimeOrig = list[i].endingTime;
				if(g_bUseFixedSunsriseSunset)
					list[i].endingTime = "06:00"; //navtree fix - determine real sunrise
				else {
					try{
						sunrise = new Date(solar.sunrise).getTime();
						iTemp = ((list[i].metadata.endingOffset.hours * 60 * 60) + (list[i].metadata.endingOffset.minutes * 60)) * 1000;
						if(list[i].metadata.endingOffset.isNegative)
							iTemp = -iTemp;
						sunrise = new Date(sunrise + iTemp).toLocaleTimeString('en-GB');
						items = sunrise.split(":");
						sunrise = items[0] + ":" + items[1];
						list[i].endingTime = sunrise; 
					}
					catch {}
				}
			}
			else if(list[i].metadata.endingOffsetType === "SUNSET") {
				list[i].endingTimeOrig = list[i].endingTime;
				if(g_bUseFixedSunsriseSunset)
					list[i].endingTime = "18:00"; //navtree fix - determine real sunset
				else {
					try{
						sunset = new Date(solar.sunset).getTime();
						iTemp = ((list[i].metadata.endingOffset.hours * 60 * 60) + (list[i].metadata.endingOffset.minutes * 60)) * 1000;
						if(list[i].metadata.endingOffset.isNegative)
							iTemp = -iTemp;
						sunset = new Date(sunset + iTemp).toLocaleTimeString('en-GB');
						items = sunset.split(":");
						sunset = items[0] + ":" + items[1];
						list[i].endingTime = sunset; 
					}
					catch {}
				}
			}
		}

		if(list.length > 0) {
			// determine length of event
			for(i=0; i < list.length; i++) 
			{
				list[i].width = -1;
				sTemp = list[i].startingTime.trim();
				items = sTemp.split(":");
				list[i].startingTimeMin = (Number(items[0]) * 60) + Number(items[1]);
				sTemp = list[i].endingTime.trim();
				items = sTemp.split(":");
				list[i].endingTimeMin = (Number(items[0]) * 60) + Number(items[1]);
				list[i].size = list[i].endingTimeMin - list[i].startingTimeMin;
				list[i].bNeedToProcess = true;
				list[i].slotIndex = -1;
			}
			// 48 30 buckets
			for(i=0; i < 48; i++)
			{ // two entries per hour
				timeObj = {};
				timeObj.start = i * 30;
				timeObj.end = timeObj.start + 30;
				timeObj.slots = [];
				timeList.push(JSON.parse(JSON.stringify(timeObj)));
			}
			// determine how many events per time row, use side by side for event, need to take into account buckets already full, so no overlapping 
				// process based on longest events first, so longest are to the left, fill in holes on left of events with smaller events.
			
			for(i=0; i < list.length; i++) 
			{
				// find largest
				z = i;
				/*
				for(j=0; j < list.length; j++) 
				{
					// find largest
					if(list[j].bNeedToProcess) {
						if(z === -1)
							z = j;
						else {
							if(list[j].size > list[z].size) {
								z = j;
							}
						}
						
					}
				} */
				if(z !== -1) {
					// determine what buckets are free in each timeObj, use left most if empty
					bContinue = true;
					startingIndex = list[z].startingTimeMin / 30;
					list[z].startingIndex = startingIndex;

					if(!Number.isInteger(startingIndex)) {
						list[z].startingIndex = parseInt(startingIndex);

					}
					list[z].slotIndex = 0;
					if(list.length > 0) {
						while(bContinue) {
							bContinue = false;
							bContinue1 = false;
							for(j=list[z].startingIndex; j < 48; j++)
							{
								if(timeList[j].slots.length === list[z].slotIndex) {
									bContinue = true;
									
									if(((list[z].endingTimeMin) <= timeList[j].end) || (j === 47)) {
										// this slotIndex is free
										list[z].bNeedToProcess = false;
										list[z].endingIndex = j;
										bContinue = false;
										break;
									}
								}
								else if(timeList[j].slots.length > list[z].slotIndex) {
									// check for empty slots
									t = 0;
									for(k=list[z].slotIndex; k < timeList[j].slots.length; k++)
									{
										if(timeList[j].slots[k] === -1) {
											t = 2;
											if(k !== list[z].slotIndex) {
												t = 1;
												list[z].slotIndex = k;
											}
											 
											break;
										}
									}
									if(t === 0) {
										list[z].slotIndex = timeList[j].slots.length;
									if(t < 2)
										bContinue = true;
										break; // restart slot check
									}
									else {
										if(((list[z].endingTimeMin) <= timeList[j].end) || (j === 47)) {
											// this slotIndex is free
											list[z].bNeedToProcess = false;
											list[z].endingIndex = j;
											bContinue = false;
											break;
										}
									}
								}
								else  {
									if(((list[z].endingTimeMin) <= timeList[j].end) || (j === 47)) {
										// this slotIndex is free
										list[z].bNeedToProcess = false;
										list[z].endingIndex = j;
										bContinue = false;
										break;
									}
								}
							}
						}
					}
					//found slotIndex so up date update - add slot infoto
					for(j=list[z].startingIndex; j < list[z].endingIndex + 1; j++)
					{
						if(timeList[j].slots.length ===  list[z].slotIndex) 
							timeList[j].slots.push(z);
						else if(timeList[j].slots.length > list[z].slotIndex) 
							timeList[j].slots.push(z);
						else {
							//
							len = list[z].slotIndex - timeList[j].slots.length;
							for(k=0; k < len; k++)
							{
								timeList[j].slots.push(-1);
							}
							timeList[j].slots.push(z);
						}
					}
				}
			} //for(i=0; i < list.length; i++) 
			
			//determin maximum number of slots
			slotsMax = 0;
			sTemp = "";

			for(j=0; j < timeList.length; j++)
			{
				if(timeList[j].slots.length > slotsMax) 
					slotsMax =  timeList[j].slots.length;
				sTemp = j + ": " + JSON.stringify(timeList[j].slots);


			}
			
			sizePerSlot = 800;
			if(slotsMax !== 0)
				sizePerSlot = sizePerSlot / slotsMax
			// populate events - may consider using side by side for event
			//process all slot 0 first followed by slot 1 and so on.  Will need to add padding if slots are not ajacent
			
			for(i=0; i < list.length; i++) 
			{ 
				element = document.getElementById("daytimevalue_" + list[i].startingIndex);
				if(element !== null) {
					//offsets = element.getBoundingClientRect(); 
					//x = offsets.x + offsets.width + window.pageXOffset + (sizePerSlot * list[i].slotIndex); // takes into account viewport (scrolling)
					x = (sizePerSlot * list[i].slotIndex)
					y = list[i].startingIndex * 30;
					y = (list[i].startingTimeMin - y) * 27 / 30;
					//y = offsets.y + window.pageYOffset + y; // takes into account viewport (scrolling)
					if(!Number.isInteger(y)) {
						y = parseInt(y);

					}
					width = sizePerSlot;
					height = list[i].size * 27 / 30;
					if(height < g_iScheduleEventMinHeight)
						height = g_iScheduleEventMinHeight;
						
					content = "<div class=\"scheduleEventDiv\" style=\"color:";
					content += determineTextColorBasedOnDarkness(list[i].color);
					content += ";top:" + y + "px;left:" + x + "px;width:" + width + "px;height:" + height + "px;background-color:"
					content += list[i].color + ";border:1px solid;box-sizing:border-box\"";
					content += " onclick=\"scheduleShowEventDetail(this,4," + list[i].id + ",'" + currentDateStr + "')\"";
					content += " title=\"";
					content += list[i].name;
					content += "\r\ntype = " + list[i].browserType;
					content += "\r\npriority = ";
					if((list[i].priority === "17") || (list[i].priority === 17))
						content += "normal";
					else
						content += list[i].priority;
					content += "\r\nvalue = ";
					if(typeof list[i].presetName !== "undefined")
						sTemp = list[i].presetName;
					else {
						sTemp = list[i].value;
						if(sTemp !== null) {
							if(sTemp.length > 2) {
								if((sTemp.charAt(0) === "{") || (sTemp.charAt(0) === "[")) {
									sTemp = sTemp.substr(1, sTemp.length - 2);
								}
							}
							if(sTemp.length > 0) {
								sTemp = sTemp.replace(/\"/g,"&quot;");
								if(sTemp.length > 50)
									sTemp = sTemp.substr(0,50) + "...";
							}
						}
					}
					bHasStart = false;
					// add times for sunrise and sunset
					sTemp += "\r\nstart time = ";
					if(typeof list[i].overlappingDay !== "undefined") {
						sTemp += determineTimeStrFromSolorTime(solar, list[i].origStartingOffsetType, list[i].origStartingOffset.hours,
							list[i].origStartingOffset.minutes, list[i].origStartingOffset.isNegative, list[i].origStartingTime);
					}
					else {
					
						bHasStart = true;
						if(g_b12hourClock) {
							iPtr = list[i].startingTime.indexOf(":");
							iTemp = list[i].startingTime.substr(0,iPtr);
							try {
								iTemp = Number(iTemp);
								if(iTemp < 12) {
									if(iTemp === 0)
										sTemp += 12;
									else
										sTemp += iTemp.toString();
									sTemp += list[i].startingTime.substr(iPtr) + "AM";
								}
								else {	
									iTemp -= 12;
									if(iTemp === 0)
										sTemp += 12;
									else
										sTemp += iTemp.toString();
									sTemp += list[i].startingTime.substr(iPtr) + "PM";
								}
							}
							catch {}
						}
						else 
							sTemp += list[i].startingTime;
						if(list[i].metadata.startingOffsetType === "SUNRISE") {
							sTemp += " (";
							if((list[i].metadata.startingOffset.hours !== 0) || (list[i].metadata.startingOffset.minutes !== 0)) {
								if(list[i].metadata.startingOffset.hours !== 0) 
									sTemp += list[i].metadata.startingOffset.hours + " hours ";
								if(list[i].metadata.startingOffset.minutes !== 0) 
									sTemp += list[i].metadata.startingOffset.minutes + " minutes ";
								if(list[i].metadata.startingOffset.isNegative)
									sTemp += "before ";
								else	
									sTemp += "after ";
							}
							sTemp += "sunrise)";
						}
						else if(list[i].metadata.startingOffsetType === "SUNSET") {
							sTemp += " (";
							if((list[i].metadata.startingOffset.hours !== 0) || (list[i].metadata.startingOffset.minutes !== 0)) {
								if(list[i].metadata.startingOffset.hours !== 0) 
									sTemp += list[i].metadata.startingOffset.hours + " hours ";
								if(list[i].metadata.startingOffset.minutes !== 0) 
									sTemp += list[i].metadata.startingOffset.minutes + " minutes ";
								if(list[i].metadata.startingOffset.isNegative)
									sTemp += "before ";
								else	
									sTemp += "after ";
							}
							sTemp += "sunset)";
						}
					}
					sTemp += "\r\n";
					sTemp += "end time = ";
					if(typeof list[i].overlappingDay !== "undefined") {
						sTemp += determineTimeStrFromSolorTime(solar, list[i].origEndingOffsetType, list[i].origEndingOffset.hours,
							list[i].origEndingOffset.minutes, list[i].origEndingOffset.isNegative, list[i].origEndingTime);
					}
					else {
						if(g_b12hourClock) {
							if(list[i].endingTime === "24:00")
								sTemp += "12:00AM";
							else {
								iPtr = list[i].endingTime.indexOf(":");
								iTemp = list[i].endingTime.substr(0,iPtr);
								try {
									iTemp = Number(iTemp);
									if(iTemp < 12) {
										if(iTemp === 0)
											sTemp += 12;
										else
											sTemp += iTemp.toString();
										sTemp += list[i].endingTime.substr(iPtr) + "AM";
									}
									else {	
										iTemp -= 12;
										if(iTemp === 0)
											sTemp += 12;
										else
											sTemp += iTemp.toString();
										sTemp += list[i].endingTime.substr(iPtr) + "PM";
									}
								}
								catch {}
							}
						}
						else {
							if(list[i].endingTime === "24:00")
								sTemp += "00:00";
							else
								sTemp += list[i].endingTime;
						}
						if(list[i].metadata.endingOffsetType === "SUNRISE") {
							sTemp += " (";
							if((list[i].metadata.endingOffset.hours !== 0) || (list[i].metadata.endingOffset.minutes !== 0)) {
								if(list[i].metadata.endingOffset.hours !== 0) 
									sTemp += list[i].metadata.endingOffset.hours + " hours ";
								if(list[i].metadata.endingOffset.minutes !== 0) 
									sTemp += list[i].metadata.endingOffset.minutes + " minutes ";
								if(list[i].metadata.endingOffset.isNegative)
									sTemp += "before ";
								else	
									sTemp += "after ";
							}
							sTemp += "sunrise)";
						}
						else if(list[i].metadata.endingOffsetType === "SUNSET") {
							sTemp += " (";
							if((list[i].metadata.endingOffset.hours !== 0) || (list[i].metadata.endingOffset.minutes !== 0)) {
								if(list[i].metadata.endingOffset.hours !== 0) 
									sTemp += list[i].metadata.endingOffset.hours + " hours ";
								if(list[i].metadata.endingOffset.minutes !== 0) 
									sTemp += list[i].metadata.endingOffset.minutes + " minutes ";
								if(list[i].metadata.endingOffset.isNegative)
									sTemp += "before ";
								else	
									sTemp += "after ";
							}
							sTemp += "sunset)";
						}
					}
					if(g_bScheduleToolTipShowDpCount) {
						sTemp += "\r\ndatapoints = ";
						if(typeof list[i].datapoints !== "undefined") {
							if(list[i].datapoints.length === 0)
								sTemp += "none";
							else
								sTemp += list[i].datapoints.length;
						}
						else 
							sTemp += "none";
					}
					if(g_bScheduleToolTipShowDpList) {
						sTemp += "\r\n";
						if(typeof list[i].browserDatapointList !== "undefined") {
							for(m=0;m < list[i].browserDatapointList.length; m++)
							{
								sTemp += list[i].browserDatapointList[m].path;
								if(m > 5) {
									sTemp += "\r\n  :";
									Temp += list[i].browserDatapointList[list[i].browserDatapointList.length - 1].path;
									break;
								}
							}
						}
					}
					content += sTemp + "\">";
					if(list[i].metadata.startingOffsetType === "SUNRISE")
						content += "<img src=\"images/navtree/SunUp.gif\" alt=\"sunrise\" class=\"imgTopDiv\">";
					else if(list[i].metadata.startingOffsetType === "SUNSET")
						content += "<img src=\"images/navtree/SunDown.gif\" alt=\"sunrise\"  class=\"imgTopDiv\">";
					content += "<span class=\"scheduleEventDivSpan\" style=\"width:" + (sizePerSlot - 10) + "px\">" + list[i].name + "</span>";
					if(list[i].metadata.endingOffsetType === "SUNRISE")
						content += "<img src=\"images/navtree/SunUp.gif\" alt=\"sunrise\" class=\"imgBottomDiv\">";
					else if(list[i].metadata.endingOffsetType === "SUNSET")
						content += "<img src=\"images/navtree/SunDown.gif\" alt=\"sunrise\" class=\"imgBottomDiv\">";
					content += "</div>";
					element.innerHTML += content;
				}
			}
		}

	}
	catch {
		//alert("i=" + i + ",j=" + j + ",z=" + z);
	}
}
function scheduleShowEventDetail(n, scheduleView, scheduleId, date) {
	var element, menuButton, menuContent = "", paneContent = "", i, iPtr, bContinue;
	var startDate, endDate;
	var currentDate, currentDateMs, i, list=[];
	var x,y,offsets, xOffset = 50, yOffset = 200;
	var sTemp, scheduleObj,d, iTemp,items, sTemp1;
	var tblName = "scheduleListTable"
	var objList = [], obj;
	var solar = null;
	
	
	
	try {
		var i,element, content;
		for(i=0; i < schedulesList.length; i++)
		{
			if(schedulesList[i].id === scheduleId) {
				scheduleObj = JSON.parse(JSON.stringify(schedulesList[i]));
				
				break;
			}
		}

		// shows a table of schedule events either all or for a specific datapoint
	
	// use planningDiv
	
		
		//alert(currentDate);
		//currentDateMs = currentDate.getTime();
		
		element = document.getElementById("planningDiv");
		//menuButton = document.getElementById("calendarContainerId");
		//if((menuButton === null) || (element === null))
		//	return;



		//offsets = menuButton.getBoundingClientRect(); 
		offsets = n.getBoundingClientRect(); 

		x = offsets.x + window.pageXOffset - xOffset; // takes into account viewport (scrolling)
		y = offsets.y + window.pageYOffset - yOffset; // takes into account viewport (scrolling)
		if(y < 50)
			y = 50;
		//if(g_calendarObj.mode !== 0) {
		//	element = document.getElementById("scheduleDiv");
		//	if(element === null)
		//		return;
		//}
		element.style.left = x.toString() + "px";
		element.style.top = y.toString() + "px";


		element.innerHTML = menuContent;
		element.className = "menuDivDpValueShow";  // doesn't currently guaranty that menu is shown in viewport
		element.style.zIndex = 26;
		g_bInoreMouseClick = true;
		//document.addEventListener("click", menuMouseCancel);
		//document.addEventListener("click", function() {menuMouseCancel(event);});

		menuContent = "<div class=\"menuDivBorder\">";
		menuContent += "<div style=\"width:100%\">";
		menuContent +="<button style=\"float:right\" onclick=\"planningMenuCancel()\">X</button>";
		menuContent += "<div id=\"planningDivHeader\" class=\"menuDivName menuDivDpValueShowDragDivHeader\">";
		menuContent += "Event: " + scheduleObj.name;
		
		
		
		menuContent += "</div>";
		menuContent += "</div>";
		
		if(g_bShowEventEdit) {
				menuContent += "<br>"
				menuContent += "<div style=\"display:flex\">";
				menuContent += "<button class=\"showEditEventButton\" onclick=\"scheduleShowEditEvent(2," + scheduleView + "," + scheduleId + ", '', '')\">Edit</button>"
				menuContent += "<button class=\"showEditEventButton\" onclick=\"scheduleShowEditEvent(1," + scheduleView + "," + scheduleId + ", '', '')\">Copy</button>";
				menuContent += "<button class=\"showEditEventButton\" onclick=\"scheduleShowEditDelete(" + scheduleView + ",'" +  scheduleObj.name + "'," + scheduleId + ")\">Delete</button>";
				menuContent += "</div><br>"
		}
		menuContent += "<br>";
		d = new Date(date);
		menuContent += "Date: " + d.toLocaleDateString() + "<br>";
		paneContent = "<table class=\"tableTop\">";
		paneContent += "<tr><td>Start time</td><td>";
		if((scheduleObj.startingTime.indexOf("R") === -1) && (scheduleObj.startingTime.indexOf("S") === -1)) {
			paneContent += scheduleObj.startingTime;
		}
		else {
			
			solar = new solarCalc(d,g_dLatitude, g_dLongitude);
			iPtr = scheduleObj.startingTime.indexOf("R");
			if(iPtr !== -1) {
				d = new Date(solar.sunrise);
				if(iPtr === 0) {
					sTemp = scheduleObj.startingTime.substr(1);
					items = sTemp.split(":");
					iTemp = (Number(items[0]) * 60) + Number(items[1]);
					sTemp1 = iTemp + " mins After Sunrise";
					d.setMinutes(d.getMinutes() + iTemp);
				}
				else {
					sTemp = scheduleObj.startingTime.substr(0, scheduleObj.startingTime.length - 1);
					items = sTemp.split(":");
					iTemp = (Number(items[0]) * 60) + Number(items[1]);
					sTemp1 = iTemp + " mins Before Sunrise";
					d.setMinutes(d.getMinutes() - iTemp);
				}
			}
			else {
				iPtr = scheduleObj.startingTime.indexOf("S");
				if(iPtr !== -1) {
					d = new Date(solar.sunset);
					if(iPtr === 0) {
						sTemp = scheduleObj.startingTime.substr(1);
						items = sTemp.split(":");
						iTemp = (Number(items[0]) * 60) + Number(items[1]);
						sTemp1 = iTemp + " mins After Sunset";
						d.setMinutes(d.getMinutes() + iTemp);
					}
					else {
						sTemp = scheduleObj.startingTime.substr(0, scheduleObj.startingTime.length - 1);
						items = sTemp.split(":");
						iTemp = (Number(items[0]) * 60) + Number(items[1]);
						sTemp1 = iTemp + " mins Before Sunset";
						d.setMinutes(d.getMinutes() - iTemp);
					}
				}
				else {
					showAlertDialog(0,"Error: Invalid scheduleinfo");
					return;
				}
			}
			//sTemp = d.toLocaleTimeString();
			//if(g_b12hourClock)
			//	sTemp += "   [" + d.toLocaleTimeString('en-GB') + "]";

			sTemp = d.toLocaleTimeString('en-GB') + "   [" + sTemp1 + "]";	
			//items = sTemp.split(":");
			//sTemp = items[0] + ":" + items[1];
			paneContent += sTemp;
		}
		paneContent +=  "</td></tr>";
		bContinue = true;
		if(typeof scheduleObj.metadata !== "undefined") {
			if(typeof scheduleObj.metadata.allDay !== "undefined") {
				if(scheduleObj.metadata.allDay) {
					bContinue = false;
					paneContent += "<tr><td>All Day</td><td>true</td></tr>";
				}
			}
		}
		if(bContinue) {
			paneContent += "<tr><td>End time</td><td>";
			if((scheduleObj.endingTime.indexOf("R") === -1) && (scheduleObj.endingTime.indexOf("S") === -1)) {
				paneContent += scheduleObj.endingTime;
			}
			else {
				d = new Date(date);
				solar = new solarCalc(d,g_dLatitude, g_dLongitude);
				iPtr = scheduleObj.endingTime.indexOf("R");
				if(iPtr !== -1) {
					d = new Date(solar.sunrise);
					if(iPtr === 0) {
						sTemp = scheduleObj.endingTime.substr(1);
						items = sTemp.split(":");
						iTemp = (Number(items[0]) * 60) + Number(items[1]);
						sTemp1 = iTemp + " mins After Sunrise";
						d.setMinutes(d.getMinutes() + iTemp);
					}
					else {
						sTemp = scheduleObj.endingTime.substr(0, scheduleObj.endingTime.length - 1);
						items = sTemp.split(":");
						iTemp = (Number(items[0]) * 60) + Number(items[1]);
						sTemp1 = iTemp + " mins Before Sunrise";
						d.setMinutes(d.getMinutes() - iTemp);
					}
				}
				else {
					iPtr = scheduleObj.endingTime.indexOf("S");
					if(iPtr !== -1) {
						d = new Date(solar.sunset);
						if(iPtr === 0) {
							sTemp = scheduleObj.endingTime.substr(1);
							items = sTemp.split(":");
							iTemp = (Number(items[0]) * 60) + Number(items[1]);
							sTemp1 = iTemp + " mins After Sunset";
							d.setMinutes(d.getMinutes() + iTemp);
						}
						else {
							sTemp = scheduleObj.endingTime.substr(0, scheduleObj.endingTime.length - 1);
							items = sTemp.split(":");
							iTemp = (Number(items[0]) * 60) + Number(items[1]);
							sTemp1 = iTemp + " mins Before Sunset";
							d.setMinutes(d.getMinutes() - iTemp);
						}
					}
					else {
						showAlertDialog(0,"Error: Invalid scheduleinfo");
						return;
					}
				}
				//sTemp = d.toLocaleTimeString();
				//if(g_b12hourClock)
				//	sTemp += "   [" + d.toLocaleTimeString('en-GB') + "]";
				sTemp = d.toLocaleTimeString('en-GB') + "   [" + sTemp1 + "]";	
				//items = sTemp.split(":");
				//sTemp = items[0] + ":" + items[1];
				paneContent += sTemp;
			}
		
			paneContent +=  "</td></tr>";
		}
		paneContent += "<tr><td>Start date</td><td>" + scheduleObj.start + "</td></tr>";
		paneContent += "<tr><td>End date</td><td>";
		if(typeof scheduleObj.end !== "undefined")
			paneContent +=  scheduleObj.end;
		paneContent +=  "</td></tr>";
		if(typeof scheduleObj.metadata.repeatsCount !== "undefined")
			paneContent += "<tr><td>Repeat Count</td><td>" + scheduleObj.metadata.repeatsCount + "</td></tr>";
		



		paneContent += "<tr><td>Priority</td><td>" + scheduleObj.priority + "</td></tr>";
		paneContent += "<tr><td>Datapoints</td><td><div style=\"max-height:100px\">";
		/*
		for(i=0; i < scheduleObj.datapoints.length; i++) {
			
			items = scheduleObj.datapoints[i].split("/");
			
			if(items.length > 1) {
				// determine device name
				for(j=0; j < deviceListAll.length; j ++) 
				{
					if(deviceListAll[j].category !== "SC") {
						if((deviceListAll[j].protocol === items[1]) && (deviceListAll[j].DID === items[2])) {
							obj = {};
							obj.deviceName = deviceListAll[j].name + " ";
							obj.path = deviceListAll[j].name + "/" + items[3] + "/" + items[4] + "/" + items[5];
							objList.push(obj);
							break;
						}
					}
				}
			}
		}
		*/
		if(scheduleObj.browserDatapointList.length > 0)
			objList = JSON.parse(JSON.stringify(scheduleObj.browserDatapointList));
		
			// list datapoints in alphabe
		bContinue = true;
		while(bContinue) 
		{
			bContinue = false;
			for(i= 0; i < (objList.length - 1); i ++)
			{
				if(objList[i].deviceName > objList[i + 1].deviceName) {
					tempObj = {};
					tempObj = JSON.parse(JSON.stringify(objList[i]));
					objList[i] = JSON.parse(JSON.stringify(objList[i + 1]));
					objList[i + 1] = tempObj;
					bContinue = true;
				}
			}
		}
		
		for(i=0; i < objList.length; i++) {
			if(i !== 0)
				paneContent +="<br>";
			paneContent += objList[i].path;
		}
		paneContent +="<div></td></tr>";
		if(scheduleObj.browserType === "CUSTOM_WEEKLY")
			paneContent += "<tr><td>Type</td><td>" + "Every " + daysList[scheduleObj.metadata.dayOfWeek] + "</td></tr>";
		else if(scheduleObj.browserType === "CUSTOM_MONTHLY") {
			if(scheduleObj.metadata.customMonthlyOption === "DAY_OF_THE_MONTH") {
				paneContent += "<tr><td>Type</td><td>";
				if(scheduleObj.metadata.monthOption === -1)
					paneContent += "Every Month on day " + scheduleObj.metadata.day;
				else 
					paneContent += "Every " + monthsList[scheduleObj.metadata.monthOption] + " on day " + scheduleObj.metadata.day;
				paneContent += "</td></tr>";
			}
			else if(scheduleObj.metadata.customMonthlyOption === "WEEK_NUMBER_AND_DAY_OF_WEEK") {
				paneContent += "<tr><td>Type</td><td>";
				if(scheduleObj.metadata.monthOption === -1)
					paneContent += "Every Month every " + daysList[scheduleObj.metadata.dayOfWeek];
				else 
					paneContent += "Every " + monthsList[scheduleObj.metadata.monthOption] + " every " + daysList[scheduleObj.metadata.dayOfWeek];
				paneContent += "</td></tr>";
			}
			

		}
		else 
			paneContent += "<tr><td>Type</td><td>" + scheduleObj.browserType + "</td></tr>";
		paneContent += "<tr><td>Value</td><td>" + scheduleObj.value + "</td></tr>";

		if(typeof scheduleObj.datapointTypeRef !== "undefined")
			paneContent += "<tr><td>Datapoint Type</td><td>" + scheduleObj.datapointTypeRef + "</td></tr>";
		else if(typeof scheduleObj.presetName !== "undefined")
			paneContent += "<tr><td>Preset</td><td>" + scheduleObj.presetName + "</td></tr>";
		
		
		
		paneContent += "</table>";
		paneContent += "</div>";
		
		//paneContent += addTopButton();
		
		element.innerHTML = menuContent + paneContent;
		dragDiv("planningDiv");
	}
	catch{
		showAlertDialog(0,"Error: Can't show schedule list");
	}
}
function scheduleShowEditDelete(scheduleView, name, scheduleId) {
	var sTemp = "<br>Do you really want to Delete<br></br>" + name;
	var element, element1;
	element = document.getElementById("warningDiv");
	element1 = document.getElementById("warningOverlayDiv");
	try {
		if((element === null) || (element1 === null))
			return;
		menuOverlayDivShow(7, null);
		sTemp += "<br><br><br><div style=\"width:100%;text-align:right\"><button class=\"warningDivShowButton\"";
		sTemp += " onclick=\"scheduleShowEditDeleteYes('" + scheduleView + "','" +  name + "'," +  scheduleId + ")\">OK</button>";
		sTemp += "<button class=\"warningDivShowButton\" onclick=\"scheduleShowEditDeleteNo()\">Cancel</button>";
		sTemp += "</div>";
		element.innerHTML = sTemp; 

	}
	catch {}	

}
function scheduleShowEditDeleteYes(scheduleView, name, scheduleId) {
	try {
		var url, rsp, payload = [];
		//if(confirm("Do you really want to Delete\r\n\r\n" + name)) {
			try {
				url = "https://" + location.host + "/iap/sev/delete";
				payload.push(scheduleId);
				payload = JSON.stringify(payload);
				rsp = requestPutData(0, url, payload,  scheduleShowEditEventRefresh, scheduleShowEditEventRefresh); 
			}
			catch {}
		//}
		planningMenuCancel();
		showAlertDialogHide();
	}
	catch {}
}
function scheduleShowEditDeleteNo() {
	showAlertDialogHide();
}
function scheduleShowEditEvent(mode, scheduleMode, scheduleId, date, time) {
	// mode: 0=create, 1=copy, 2= edit
	// scheduleMode: 0 year, 1 = year, 2=month, 3=week, 4,day
	//scheduleId: null=create
	var element, menuButton, menuContent = "", paneContent = "", i, iPtr, bContinue;
	var startDate, endDate;
	var currentDate, currentDateMs, i, list=[];
	var x,y,offsets, menuDivYOffset = 100;
	var sTemp, scheduleObj = null;
	var tblName = "scheduleListTable"
	var objList = [], obj,url, requestStr = "", element;
	
	
	try {
		var i,element, content;
		
		planningMenuCancel();
		
		
		element = document.getElementById("scheduleCreateDiv");
		if(element === null) {
			//create deiv
			element = document.createElement("div");
			element.setAttribute("id", "scheduleCreateDiv");
			document.body.appendChild(element);
			element = document.createElement("div");
			element.setAttribute("id", "scheduleCreateOverlayDiv");
			document.body.appendChild(element);

			element = document.getElementById("scheduleCreateDiv");
			

		}
		if(element === null)
			return;
		menuOverlayDivShow(2, null);

		menuButton = document.getElementById("calendarContainerId");
		if((menuButton === null) || (element === null))
			return;

		offsets = menuButton.getBoundingClientRect(); 
		x = offsets.x + window.pageXOffset + 25; // takes into account viewport (scrolling)
		y = offsets.y + window.pageYOffset + 100; // takes into account viewport (scrolling)
		element.style.left = x.toString() + "px";
		element.style.top = y.toString() + "px";
		element.innerHTML = menuContent;
		element.className = "menuDivDpValueShow";  // doesn't currently guaranty that menu is shown in viewport
		element.style.zIndex = 26;
		g_bInoreMouseClick = true;
		
		menuContent = "<div class=\"menuWhiteBackgroundDiv\"><div class=\"menuDivBorder\">";
		menuContent +="<button style=\"float:right\" onclick=\"menuScheduleCreateDivClose()\">X</button>";
		menuContent += "<div id=\"scheduleCreateDivHeader\" class=\"menuDivName menuDivDpValueShowDragDivHeader\">";
		
		
		menuContent += "<div class=\"menuDivTitle\">";


		if(scheduleId === null)
			menuContent += "Create Event";
		else {
			if(mode === 1) {
				menuContent += "Copy Event"
			}
			else if(mode === 2)
				menuContent += "Edit Event";
		}
				
		
		menuContent += "</div>";
		
		menuContent += "</div>";
		menuContent += "<br><br>";
		menuContent += "<div id=\"eventDataDiv\"  style=\"min-width:600px;min-Height:400px\"><div style=\"width:100%;margin-top:200px\">" + addWaitSpinner(1) + "</div></div></div>";
		element.innerHTML = menuContent + paneContent;
		dragDiv("scheduleCreateDiv");
		g_bScheduleEventInProgress = true;
		obj = {};
		obj.mode = mode;
		obj.scheduleMode = scheduleMode; // used to refresh view after changes.
		obj.scheduleId = scheduleId;
		obj.date = date;
		obj.time = time;
		g_scheduleEventsPresetList = [];
		g_favoritesList = [];
		g_dpTypesAvailableList = [];
		g_menuDatapointsEventDatapoints = [];
		g_sceduleEventDatapointList = [];
		g_scheduleEventDlaList = [];
		if(mode > 0) {
			if(scheduleId === null) {
				showAlertDialog(0,"Error: Invalid Schedule Id. Refresh Schedules and try again.")
				return;
			}
			// get datapoint info
			url = "https://" + location.host + "/iap/devs/*/if/*/*/*+qualifier=-";
			z = -1;
			for(i=0; i < g_schedulesListOrig.length; i++)
			{
				if(g_schedulesListOrig[i].id === scheduleId) {
					scheduleObj = JSON.parse(JSON.stringify(g_schedulesListOrig[i]));
					z = i;
					break;
				}
			}
			if(z !== -1) {
				for(i=0; i < g_schedulesListOrig[z].datapoints.length; i++)
				{
					if(i !== 0)
						requestStr += ",";
					requestStr += g_schedulesListOrig[z].datapoints[i];
				}
				requestStr = encodeUriString(requestStr); // remove "/" and  "/[]""
				url += requestStr + "/*?max_age=1&noxs=true";
				requestGetData(obj, url, scheduleShowEditEventGetDatapointsResponse, scheduleShowEditEventGetDatapointsFailCallback); 
			}
			else {
				showAlertDialog(0,"Error: Invalid Schedule Information. Refresh Schedules and try again.")
				return;
			}
		}
		else {
			url = "https://" + location.host + "/iap/dp/presets/names";
			requestGetData(obj, url, scheduleShowEditEventGetPresetsResponse, scheduleShowEditEventGetPresetsFailCallback); // get Device list
		}
	}
	catch {}
}
function scheduleShowEditEvent1(mode, scheduleView, scheduleId, date, time) {
	// mode: 0=create, 1=copy, 2= edit
	//  scheduleView: 0=year, 1= year, 2=month, 3=week, 4 = day
	var element, menuButton, menuContent = "", paneContent = "", i, iPtr, bContinue;
	var startDate, endDate;
	var currentDate, currentDateMs, i, j, list=[];
	var x,y,offsets, menuDivYOffset = 100;
	var sTemp, scheduleObj = null, table, value, bAllDayEvent = false;
	var tblName = "scheduleListTable"
	var objList = [], obj, color = "#ffffff";
	var dateStr = "";
	var z = -1;
	var sTemp, sTemp1, temp, d1, solar;
	var daySelectDivStr = "";
	//var mode = modeObj.mode; // mode: 0=create, 1=copy, 2= edit
	var d = new Date();
	var time = d.getHours() + 1;

	
	
	try {
		var i,element, content;
		element = document.getElementById("scheduleCreateDiv");
		if(element === null)
			return;
		element = document.getElementById("eventDataDiv");
		if(element === null)
			return;
		if(!g_bScheduleEventInProgress)
			return;
		g_bScheduleEventInProgress = false;
		
		
		// shows a table of schedule events either all or for a specific datapoint
	
	// use planningDiv
		clearDpFilter(0);
		/* for 3.4
		daySelectDivStr += "<span class=\"eventDayCheckboxSpan\">Mon</span><input id=\"eventMon\" type=\"checkbox\">";
		daySelectDivStr += "<span class=\"eventDayCheckboxSpan\">Tues</span><input id=\"eventTue\" type=\"checkbox\">";
		daySelectDivStr += "<span class=\"eventDayCheckboxSpan\">Wed</span><input id=\"eventWed\" type=\"checkbox\">";
		daySelectDivStr += "<span class=\"eventDayCheckboxSpan\">Thur</span><input id=\"eventThur\" type=\"checkbox\">";
		daySelectDivStr += "<span class=\"eventDayCheckboxSpan\">Fri</span><input id=\"eventFri\" type=\"checkbox\">";
		daySelectDivStr += "<span class=\"eventDayCheckboxSpan\">Sat</span><input id=\"eventSat\" type=\"checkbox\">";
		daySelectDivStr += "<span class=\"eventDayCheckboxSpan\">Sun</span><input id=\"eventSun\" type=\"checkbox\">";
*/

		
		
		g_scheduleEventDlaIndex = 0; // if using presets get preset list

		daySelectDivStr += "<span class=\"eventDayCheckboxSpan\">Mon</span><input id=\"eventMon\" type=\"checkbox\" onclick=\"scheduleShowEditEventDayCheckbox(0)\">";
		daySelectDivStr += "<span class=\"eventDayCheckboxSpan\">Tues</span><input id=\"eventTue\" type=\"checkbox\" onclick=\"scheduleShowEditEventDayCheckbox(1)\">";
		daySelectDivStr += "<span class=\"eventDayCheckboxSpan\">Wed</span><input id=\"eventWed\" type=\"checkbox\" onclick=\"scheduleShowEditEventDayCheckbox(2)\">";
		daySelectDivStr += "<span class=\"eventDayCheckboxSpan\">Thur</span><input id=\"eventThur\" type=\"checkbox\" onclick=\"scheduleShowEditEventDayCheckbox(3)\">";
		daySelectDivStr += "<span class=\"eventDayCheckboxSpan\">Fri</span><input id=\"eventFri\" type=\"checkbox\" onclick=\"scheduleShowEditEventDayCheckbox(4)\">";
		daySelectDivStr += "<span class=\"eventDayCheckboxSpan\">Sat</span><input id=\"eventSat\" type=\"checkbox\" onclick=\"scheduleShowEditEventDayCheckbox(5)\">";
		daySelectDivStr += "<span class=\"eventDayCheckboxSpan\">Sun</span><input id=\"eventSun\" type=\"checkbox\" onclick=\"scheduleShowEditEventDayCheckbox(6)\">";

		
		//alert(currentDate);
		//currentDateMs = currentDate.getTime();
		
		element = document.getElementById("eventDataDiv");
		paneContent += "<textarea id=\"eventDescriptionTextarea\" style=\"display:none\"></textarea>";
		paneContent += "Event Name: <input id=\"eventName\" onchange=\"scheduleShowEditEventNameChanged()\" size=\"50\"><span id=\"eventId\" style=\"display:none\">-1</span><span style=\"margin-left:30px;margin-right:5px\">Color:</span>";
		
		//menuContent += "<input type=\"color\" id=\"eventColor1\" name=\"favcolor\" value=\"#000000\">"
		//menuContent += "<div style=\"display:inline-block;margin-top:5px;border:1px solid Black\" onclick=\"colorMenu(0,this, 'eventColorDiv')\"><div id=\"eventColorDiv\" style=\"margin:4px;border:1px solid Black;width:60px;height:10px\"></div></div>"
		//menuContent += "<span id=\"eventColorDiv\" style=\"display:inline-block;margin-left:50px:;border:1px solid Black;width:60px;height:15px;background-color:" + color + "\" onclick=\"colorMenu(0,this, 'eventColorDiv')\"></span>"
		paneContent += "<input id=\"eventColorDiv\" style=\"margin-left:150px:;border:1px solid Black;background-color:" + color + "\"  size=\"10\" onclick=\"colorMenu(0,this, 'eventColorDiv')\">"
		paneContent += "<span style=\"margin-left:30px\">Timezone: </span><span>" + g_sTimezone + "</span>";
		paneContent += "<span id=\"eventScheduleView\" style=\"display:none\">" + scheduleView + "</span>";
		paneContent += "<br><span id=\"eventNameError\" class=\"eventErrorSpan\" style=\"margine-left:30px;\"></span><br>";
		paneContent += "<div style=\"display:flex\">"
		paneContent += "<div>";
		paneContent += "<span style=\"display:inline-block;width:75px;white-space:nowrap;margin-right:5px\">Start Date: </span><input type=\"date\" id=\"eventStartingDate\" onchange=\"scheduleShowEditEventStartDateChanged()\"></div>";
		paneContent += "<div id=\"eventStartingTimeDiv\" style=\"display:flex;margin-left:30px;width:170px\"><span id=\"eventStartingTimeSpan\" style=\"white-space: nowrap;width:90px\">Starting Time: </span><input type=\"text\" id=\"eventStartingTime\" style=\"margin-left:10px;display:inline-block;width:50px\" value=\"" + time.toString().padStart(2,0) + ":00\">";
		paneContent += "<span id=\"eventStartingTimeSunsetSpan\" style=\"margin-left:10px;display:none;width:50px\"></span></div>";
		
		paneContent += "<div id=\"evenAllDayDiv\" style=\"display:flex;margin-left:10px;width:80px\"><input type=\"checkbox\" id=\"eventAllDay\" onclick=\"scheduleShowEditEventAllDayCheckBox()\" ><label style=\"margin-left5px\">All Day</label></div>";
		paneContent += "<div>";
		paneContent += "<label id=\"eventStartSunriseSunsetRelativeLabel\" style=\"margin-left:10px\">Sunrise/Sunset Relative: </label><select id=\"eventStartOffsetType\" onchange=\"scheduleShowEditEventOffsetType(0)\">";
		paneContent += "<option value=\"No\" selected>No</option>";
		paneContent += "<option value=\"Before Sunrise\">Before Sunrise</option>";
		paneContent += "<option value=\"After Sunrise\">After Sunrise</option>";
		paneContent += "<option value=\"Before Sunset\">Before Sunset</option>";
		paneContent += "<option value=\"After Sunset\">After Sunset</option>";
		paneContent += "</select>";
		paneContent += "</div>";
		paneContent += "<div id=\"eventStartSunsetDiv\" style=\"display:none\">"
		paneContent += "<span id=\"eventStartSunsetMin\" style=\"margin-left:10px\" >Minutes: </span><input type=\"number\" id=\"eventStartSunset\" value=\"0\" min=\"0\" size=\"5\">"
		paneContent += "</div>"
		paneContent += "<div id=\"eventStartTimezoneDiv\" style=\"display:none\">"
		paneContent += "<span style=\"margin-left:10px\">Timezone: </span><span>" + g_sTimezone + "</span>";//<select id=\"eventStartTimezone\"></select>";
		paneContent += "</div>"
		paneContent += "</div>";
		
		

						//end event
		paneContent += "<br>";
		paneContent += "<div style=\"display:flex\">"
		paneContent += "<div>";
		paneContent += "<span id=\"eventEndDateSpan\" style=\"display:inline-block;width:75px;white-space:nowrap;margin-right:5px\">End Date: </span><input type=\"date\" id=\"eventEndingDate\"></div>";
		paneContent += "<div id=\"eventEndingTimeDiv\" style=\"display:flex;margin-left:30px;width:170px\"><span id=\"eventEndingTimeSpan\" style=\"white-space: nowrap;width:90px\">Ending Time: </span><input type=\"text\" id=\"eventEndingTime\" style=\"margin-left:10px;display:inline-block;width:50px\" value=\"" + (time + 1).toString().padStart(2,0) + ":00\">";
		paneContent += "<span id=\"eventEndingTimeSunsetSpan\" style=\"margin-left:10px;display:none;width:50px\"></span></div>"
		paneContent += "<div style=\"display:flex;margin-left:10px;width:80px\"></div>";
		paneContent += "<div>"
		paneContent += "<label id=\"eventEndSunriseSunsetRelativeLabel\" style=\"margin-left:10px\">Sunrise/Sunset Relative: </label><select id=\"eventEndOffsetType\" onchange=\"scheduleShowEditEventOffsetType(1)\">";
		paneContent += "<option value=\"No\" selected>No</option>";
		paneContent += "<option value=\"Before Sunrise\">Before Sunrise</option>";
		paneContent += "<option value=\"After Sunrise\">After Sunrise</option>";
		paneContent += "<option value=\"Before Sunset\">Before Sunset</option>";
		paneContent += "<option value=\"After Sunset\">After Sunset</option>";
		paneContent += "</select>";
		paneContent += "</div>";
		paneContent += "<div id=\"eventEndSunsetDiv\" style=\"display:none\">"
		paneContent += "<span id=\"eventEndSunsetMin\" style=\"margin-left:10px\">Minutes: </span><input type=\"number\" id=\"eventEndSunset\" value=\"0\" min=\"0\" size=\"5\">"
		paneContent += "</div>"
		paneContent += "<div id=\"eventEndTimezoneDiv\" style=\"display:none\">"
		paneContent += "<span style=\"margin-left:10px\">Timezone: </span>" + g_sTimezone + "</span>";//<select id=\"eventEndTimezone\"></select>";
		paneContent += "</div>"
		paneContent += "</div>";
		paneContent += "<div><span id=\"eventDateErrorSpan\" class=\"eventErrorSpan\" style=\"margin-left:30px;\"></span></div>";

		//paneContent += "<br>";
		paneContent += "<div style=\"display:flex\">";
		paneContent += "<div style=\"display:flex\">"
		paneContent += "<div style=\"margin-right:10px;width:80px;white-space: nowrap;\">Repeat: </div><div><select id=\"eventRepeatType\" onclick=\"scheduleShowEditEventRepeatType()\">";
		paneContent += "<option selected value=\"No Repeat\">No Repeat</option>"
		paneContent += "<option value=\"Daily\">Daily</option>"
		paneContent += "<option value=\"Weekly\">Weekly</option>"
		paneContent += "<option value=\"Weekday\">Weekday</option>" // In 3.4 Weekly will support selecting multiple days
		paneContent += "<option value=\"Weekend\">Weekend</option>"; // In 3.4 Weekly will support selecting multiple days
		paneContent += "<option value=\"Month by day of Month\">Month by day of Month</option>"
		paneContent += "<option value=\"Month by day of Week\">Month by day of Week</option>"
		paneContent += "<option value=\"Year by month and day\">Year by month and day</option>"
		paneContent += "<option value=\"Year by month, week and day\">Year by month, week and day</option>"
		paneContent += "</select>"
		paneContent += "</div>"
		paneContent += "</div>"
		//paneContent += "<div id=\"eventRepeatOptionDiv\" style=\"display:flex;margin-left:20px; width:700px\">";
		paneContent += "<div id=\"eventRepeatOptionDiv\" style=\"display:flex;margin-left:20px;min-width:530px\">";
		paneContent += "<div id=\"eventDaysCheckbox\" style=\"display:none;marging-left:10px\">" + daySelectDivStr + "</div>";

		paneContent += "<div id=\"eventMonthByDayOfMonth\" style=\"display:none;marging-left:10px\">";
		paneContent += "<span style=\"margin-left:5px\">Day of Month:</span><input  type=\"number\" id=\"eventDayOfMonth\" value =\"1\" size=\"7\" min=\"0\" max=\"31\">";
		paneContent += "<span style=\"margin-right:15px;margin-left:10px\">Months To Skip:</span><input  type=\"number\" id=\"eventMonthsToSkip\" value =\"1\" size=\"7\" min=\"0\" max=\"11\">";
		paneContent += "</div>";

		paneContent += "<div id=\"eventMonthByDayOfWeek\" style=\"display:none;marging-left:10px\">";
		paneContent += "<span style=\"margin-left:5px\">Day of Week:</span><select  type=\"number\" id=\"eventDayOfWeek\">";
		paneContent += "<option selected>Saturday</option>"
		paneContent += "<option>Sunday</option>"
		paneContent += "<option>Monday</option>"
		paneContent += "<option>Tuesay</option>"
		paneContent += "<option>Wednesday</option>"
		paneContent += "<option>Thursday</option>"
		paneContent += "<option>Friday</option>"
		paneContent += "<option>Saturday</option>"
		paneContent += "</select>"
		paneContent += "<span style=\"margin-right:15px;margin-left:10px\">Day of Week:</span><select  type=\"number\" id=\"eventDayOfWeek\">";
		paneContent += "<option selected>1 (1st - 7th)</option>"
		paneContent += "<option>2 (8th - 14th)</option>";
		paneContent += "<option>3 (15th - 21st)</option>";
		paneContent += "<option>4 (22nd - 28th)</option>";
		paneContent += "<option>Last</option>";
		paneContent += "</select>";
		paneContent += "</div>";
		
		paneContent += "<div id=\"eventYearByMonthDay\" style=\"display:none;marging-left:10px\">";
		paneContent += "<span style=\"margin-left:5px\">Day of Week:</span><select  type=\"number\" id=\"eventMonth\">";
		paneContent += "<option selected>January</option>"
		paneContent += "<option>February</option>"
		paneContent += "<option>March</option>"
		paneContent += "<option>April</option>"
		paneContent += "<option>May</option>"
		paneContent += "<option>June</option>"
		paneContent += "<option>July</option>"
		paneContent += "<option>August</option>"
		paneContent += "<option>September</option>"
		paneContent += "<option>October</option>"
		paneContent += "<option>November</option>"
		paneContent += "<option>Decemenber</option>"
		paneContent += "</select>"
		paneContent += "<span style=\"margin-right:15px;margin-left:10px\">Day of Month:</span><select  type=\"number\" id=\"eventDayOfMonth\">";
		iTemp = 32
		for(i=1; i < iTemp; i++)
		{
			paneContent += "<option";
			if(i===1)
				paneContent += " selected";
			paneContent += ">" + i + "</option>";
		}
		paneContent += "</select>"
		paneContent += "</div>";

		paneContent += "<div id=\"eventYearByMonthWeekDay\" style=\"display:none;marging-left:10px\">";
		paneContent += "<span style=\"margin-left:5px;margin-right:5px;white-space: nowrap;\">Day of Week:</span><select  type=\"number\" id=\"eventMonth\">";
		paneContent += "<option selected>January</option>"
		paneContent += "<option>February</option>"
		paneContent += "<option>March</option>"
		paneContent += "<option>April</option>"
		paneContent += "<option>May</option>"
		paneContent += "<option>June</option>"
		paneContent += "<option>July</option>"
		paneContent += "<option>August</option>"
		paneContent += "<option>September</option>"
		paneContent += "<option>October</option>"
		paneContent += "<option>November</option>"
		paneContent += "<option>Decemenber</option>"
		paneContent += "</select>"
		paneContent += "<span style=\"margin-right:5px;margin-left:10px;white-space: nowrap\">Day of Week:</span><select  type=\"number\" id=\"eventDayOfWeek\">";
		paneContent += "<option selected>1 (1st - 7th)</option>"
		paneContent += "<option>2 (8th - 14th)</option>";
		paneContent += "<option>3 (15th - 21st)</option>";
		paneContent += "<option>4 (22nd - 28th)</option>";
		paneContent += "<option>Last</option>";
		paneContent += "</select>";
		paneContent += "<span style=\"margin-right:5px;margin-left:10px;white-space: nowrap\">Day of Week:</span><select  type=\"number\" id=\"eventDayOfWeek\">";
		paneContent += "<option selected>Saturday</option>";
		paneContent += "<option>Sunday</option>";
		paneContent += "<option>Monday</option>";
		paneContent += "<option>Tuesay</option>";
		paneContent += "<option>Wednesday</option>";
		paneContent += "<option>Thursday</option>";
		paneContent += "<option>Friday</option>";
		paneContent += "<option>Saturday</option>";
		paneContent += "</select>";
		paneContent += "</div>";


		
		paneContent += "</div>";
		paneContent += "</div>";
		paneContent += "<br>";
		paneContent += "<div id=\"eventEndRepeatDiv\" style=\"display:flex;visibility:hidden\" ><div style=\"margin-right:10px;width:80px;white-space: nowrap;\">End Repeat: </div><div>";
		paneContent += "<select id=\"eventRepeatEnd\" onchange=\"scheduleShowEditEventRpeatEnd()\">";
		paneContent += "<option value=\"Never\" selected>Never</option>";
		paneContent += "<option value=\"Date\">Date</option>";
		paneContent += "<option value=\"Repeat count\">Repeat count</option>";
		paneContent += "</select>";
		paneContent += "</div>";
		paneContent == "</div>";
		paneContent += "<div id=\"eventEndDateDiv\" style=\"display:none;margin-left:5px;margin-right:5px\"><input type=\"date\" id=\"eventEndDate\"></div>";
		paneContent += "<div id=\"eventSpecificRepeatDiv\" style=\"display:none;margin-left:5px;margin-right:5px\"><input type=\"number\" id=\"eventEndRepeatCount\" min=\"1\" value=\"1\" size=\"5\"></div>";
		paneContent += "</div>";
		paneContent += "</div>";
		paneContent += "<br>";
		
		/*
		paneContent += "<select id=\"daysOverlap\" style=\"margin-left:50px\">";
		paneContent += "<option selected>Same Day</option>"
		paneContent += "<option>1 day later</option>"
		paneContent += "<option>2 day later</option>"
		paneContent += "<option>3 day later</option>"
		paneContent += "</select><br><br>"
		*/

		

		
		paneContent += "Action: <select id=\"eventActionSelect\" onchange=\"scheduleShowEditEventActionChanged()\">";
		paneContent += "<option value=\"Set datapoint value\" selected>Set datapoint value</option>"
		paneContent += "<option value=\"Set datapoint preset\">Set datapoint preset</option>"
		paneContent += "</select>";
		paneContent += "<span style=\"display:inline-block;margin-left:20px\">Target: </span> <select id=\"eventTargetSelect\">";
		paneContent += "<option value=\"Datapoint\" selected>Datapoint</option>"
		paneContent += "<option value=\"Favorite\">Favorite</option>"
		paneContent += "</select>";

		paneContent += "<div id=\"eventDatapointType\" style=\"display:inline-block;margin-left:20px;\">Datapoint type: <select id=\"eventDatapointTypeSelect\" onchange=\"scheduleShowEditEventDatapointTypeSelect()\">";
		for(i=0; i < g_dpTypesAvailableList.length; i++)
		{
			paneContent += "<option value=\"" + g_dpTypesAvailableList[i].typeId + "\"";
			if(g_dpTypesAvailableList[i].typeId === "SNVT_switch")
				paneContent += " selected";
			paneContent += ">" + g_dpTypesAvailableList[i].typeId + "</option>"
		}
		paneContent += "</select></div>";

		paneContent += "<br><br>Datapoints:<span id=\"eventDatapointsCount\" style=\"margin-left: 5px;width:20px\">0</span><button style=\"margin-left: 20px\" onclick=\"scheduleShowEditEventAddDatapoints()\">+</button><br><br>";
		paneContent += "<div id=\"eventDatapointDiv\" style=\"min-height:50px;max-height:300px;margin-left:20px;padding:5px;border:1px solid lightgrey;\"><table id=\"eventDatapointTable\"></table></div>";


		paneContent += "<div id=\"eventdatapoints\"></div>";
		paneContent += "<br><br>";
		paneContent += "<div style=\"display:flex\">";
		//paneContent += "<div id=\"eventValueDiv\" style=\"width:400px\"><span style=\"display:inline-block;width:50px\">Value: </span><input  id=\"eventValue\" size=\"40\" readonly=\"readonly\"><button id=\"eventValueEditButton\" style=\"margin-left:10px\" onclick=\"menuDpValueScheduleValue(0, this)\">Edit</button></div>";
		paneContent += "<div id=\"eventValueDiv\" style=\"width:400px\"><span style=\"display:inline-block;width:50px\">Value: </span><input  id=\"eventValue\" onclick=\"menuDpValueScheduleValue(0, this)\" size=\"40\" readonly></div>";
		paneContent += "<div id=\"eventDropdownValueDiv\" style=\"display:none;width:400px\"><span style=\"display:inline-block;width:50px\">Value: </span><select  id=\"eventDropdownValue\" style=\"width:30px\"></Select></div>";
		paneContent += "<div id=\"eventPresetDiv\" style=\"display:none;width:400px\">Presets: <select id=\"eventPresets\" onchange=\"scheduleShowEditEventPresetChanged()\" style=\"width:50px\">";
		for(i=0; i < g_scheduleEventsPresetList.length; i++)
		{
			paneContent += "<option>" + g_scheduleEventsPresetList[i] + "</option>"
		}
		
		paneContent += "</select></div>";
		
		paneContent += "<div style=\"width:150px\">Priority:</span><select id=\"eventPriority\">";
		for(i=0; i < 17; i++)
		{
			paneContent += "<option value=\"" + i + "\">" + i + "</option>";
		}
		paneContent += "<option value=\"17\" selected>Normal</option>";
		paneContent += "</select>";
		paneContent += "</div>";
		paneContent += "<div style=\"display:inline-block\">";
		paneContent += "<span style=\"display:inline-block;margin-left:10px\">Heatbeat (seconds):</span><input  type=\"number\" id=\"eventHeartbeat\" value =\"0\" size=\"7\" min=\"0\">";
		paneContent += "</div>";
		paneContent += "</div>";
		paneContent += "<div id=\"eventValueError\" class=\"eventErrorSpan\" style=\"margin-left:30px;\"></div>";
		paneContent += "<br>";


		paneContent += "<div style=\"display:flex\">";
		paneContent += "<div style=\"width:400px\"><span style=\"display:inline-block;width:50px\">Tags: </span><input  id=\"eventTags\" value =\"\" size=\"40\"></div>";
		paneContent += "<div style=\"width:150px\">QoS: <select id=\"eventQoS\">";
		for(i=0; i < 3; i++)
		{
			paneContent += "<option";
			if(i=== 0)
				paneContent += " selected";
			paneContent += ">" + i + "</option>"
		}
		
		paneContent += "</select></div>";
		paneContent += "<div style=\"display:inline-block\">";
		paneContent += "<span style=\"margin-left:10px;display:inline-block\">Stagger (seconds):</span><input  type=\"number\" id=\"eventStagger\" value =\"0\" style=\"margin-left:5px\" size=\"7\" min=\"0\">";
		paneContent += "</div>";
		paneContent += "</div>";
		
		paneContent += "<br><br><button onclick=\"scheduleShowEditEventCreateSchedule(" + mode + ")\">Save</button>";

		element.innerHTML = paneContent;
		if(mode < 2) {
			if(g_calendarDate.getTime() < g_todayDate.getTime())
				g_calendarDate = new Date(g_todayDate.getTime());
		}

		dateStr = g_calendarDate.getFullYear() + "-" + (g_calendarDate.getMonth() + 1).toString().padStart(2,0) + "-" + g_calendarDate.getDate().toString().padStart(2,0);
		document.getElementById("eventStartingDate").value = dateStr;
		document.getElementById("eventEndingDate").value = dateStr;
		//document.getElementById("eventEndingDate").value = dateStr;
		value = {};
		value.value = 0;
		value.state = 0;
		document.getElementById("eventValue").value = JSON.stringify(value);
		//document.getElementById("eventValue").readOnly = true;
		if(scheduleId !== null) {
			for(i=0; i < g_schedulesListOrig.length; i++)
			{
				if(g_schedulesListOrig[i].id === scheduleId) {
					scheduleObj = JSON.parse(JSON.stringify(g_schedulesListOrig[i]));
					z = i;
					break;
				}
			}
		}
		if(scheduleObj !== null) {
			//populate UI with existing event
			document.getElementById("eventName").value = scheduleObj.name;
			if(mode === 1)
				document.getElementById("eventName").value = scheduleObj.name + "_Copy";
			if(mode === 2)
				document.getElementById("eventId").innerHTML = scheduleObj.id;

			document.getElementById("eventColorDiv").style.backgroundColor = scheduleObj.color;


			document.getElementById("eventStartingDate").value = scheduleObj.startingDate;
			document.getElementById("eventEndingDate").value = scheduleObj.endingDate;
			
			if(typeof scheduleObj.description !== "")
				document.getElementById("eventDescriptionTextarea").value = scheduleObj.description;
			


			temp = scheduleObj.startingTime;
			if(typeof scheduleObj.metadata !== "undefined") {
				if(typeof scheduleObj.metadata.allDay !== "undefined") {
					bAllDayEvent = scheduleObj.metadata.allDay;
				}
			}
			if(bAllDayEvent) {

			}
			else {
				if(temp.charAt(0) === "S") {
					document.getElementById("eventStartOffsetType").value = "After Sunset";
					temp = temp.substr(1);
					items = temp.split(":");
					iTemp = (Number(items[0]) * 60) + Number(items[1]);
					document.getElementById("eventStartSunsetDiv").style.display = "inline-block";
					document.getElementById("eventStartSunset").value = iTemp;
					document.getElementById("eventStartTimezoneDiv").style.display = "none";
					document.getElementById("eventStartingTimeDiv").style.visibility = "hidden";
					/*
					if(!g_bUseFixedSunsriseSunset) {
						d = new Date(scheduleObj.startingDate.replace(/\-/g,"/"));
						solar = new solarCalc(d,g_dLatitude, g_dLongitude);
						d = new Date(solar.sunset);
						d.setMinutes(d.getMinutes() - iTemp);
						document.getElementById("eventStartingTime").style.display = "none";
						document.getElementById("eventStartingTimeSunsetSpan").style.display = "inline-block";
						document.getElementById("eventStartingTimeSunsetSpan").innerHTML = d.toLocaleTimeString('en-GB');
					}
					*/
				}
				else if(temp.charAt(0) === "R") {
					document.getElementById("eventStartOffsetType").value = "After Sunrise";
					temp = temp.substr(1);
					items = temp.split(":");
					iTemp = (Number(items[0]) * 60) + Number(items[1]);
					document.getElementById("eventStartSunsetDiv").style.display = "inline-block";
					document.getElementById("eventStartSunset").value = iTemp;
					document.getElementById("eventStartTimezoneDiv").style.display = "none";
					document.getElementById("eventStartingTimeDiv").style.visibility = "hidden";
					/*
					if(!g_bUseFixedSunsriseSunset) {
						d = new Date(scheduleObj.startingDate.replace(/\-/g,"/"));
						solar = new solarCalc(d,g_dLatitude, g_dLongitude);
						d = new Date(solar.sunrise);
						d.setMinutes(d.getMinutes() - iTemp);
						document.getElementById("eventStartingTime").style.display = "none";
						document.getElementById("eventStartingTimeSunsetSpan").style.display = "inline-block";
						document.getElementById("eventStartingTimeSunsetSpan").innerHTML = d.toLocaleTimeString('en-GB');
					}
					*/
				}
				else if(temp.charAt(temp.length - 1) === "S") {
					document.getElementById("eventStartOffsetType").value = "Before Sunset";
					temp = temp.substr(0, (temp.length - 1));
					items = temp.split(":");
					iTemp = (Number(items[0]) * 60) + Number(items[1]);
					document.getElementById("eventStartSunsetDiv").style.display = "inline-block";
					document.getElementById("eventStartSunset").value = iTemp;
					document.getElementById("eventStartTimezoneDiv").style.display = "none";
					document.getElementById("eventStartingTimeDiv").style.visibility = "hidden";
					/*
					if(!g_bUseFixedSunsriseSunset) {
						d = new Date(scheduleObj.startingDate.replace(/\-/g,"/"));
						solar = new solarCalc(d,g_dLatitude, g_dLongitude);
						d = new Date(solar.sunset);
						d.setMinutes(d.getMinutes() + iTemp);
						document.getElementById("eventStartingTime").style.display = "none";
						document.getElementById("eventStartingTimeSunsetSpan").style.display = "inline-block";
						document.getElementById("eventStartingTimeSunsetSpan").innerHTML = d.toLocaleTimeString('en-GB');
					}
					*/
				}
				else if(temp.charAt(temp.length - 1) === "R") {
					document.getElementById("eventStartOffsetType").value = "Before Sunrise";
					temp = temp.substr(0, (temp.length - 1));
					items = temp.split(":");
					iTemp = (Number(items[0]) * 60) + Number(items[1]);
					document.getElementById("eventStartSunsetDiv").style.display = "inline-block";
					document.getElementById("eventStartSunset").value = iTemp;
					document.getElementById("eventStartTimezoneDiv").style.display = "none";
					document.getElementById("eventStartingTimeDiv").style.visibility = "hidden";
					/*
					if(!g_bUseFixedSunsriseSunset) {
						d = new Date(scheduleObj.startingDate.replace(/\-/g,"/"));
						solar = new solarCalc(d,g_dLatitude, g_dLongitude);
						d = new Date(solar.sunrise);
						d.setMinutes(d.getMinutes() + iTemp);
						document.getElementById("eventStartingTime").style.display = "none";
						document.getElementById("eventStartingTimeSunsetSpan").style.display = "inline-block";
						document.getElementById("eventStartingTimeSunsetSpan").innerHTML = d.toLocaleTimeString('en-GB');
					}
					*/
				}
				else {
					document.getElementById("eventStartOffsetType").value = "No";
					document.getElementById("eventStartSunsetDiv").style.display = "none";
					document.getElementById("eventStartingTime").value = scheduleObj.startingTime;
					document.getElementById("eventStartTimezoneDiv").style.display = "none";
					if(!g_bUseFixedSunsriseSunset) {
						document.getElementById("eventStartingTime").style.display = "inline-block";
						document.getElementById("eventStartingTimeSunsetSpan").style.display = "none";
					}
				}
				

				temp = scheduleObj.endingTime;
				if(temp.charAt(0) === "S") {
					document.getElementById("eventEndOffsetType").value = "After Sunset";
					temp = temp.substr(1);
					items = temp.split(":");
					iTemp = (Number(items[0]) * 60) + Number(items[1]);
					document.getElementById("eventEndSunsetDiv").style.display = "inline-block";
					document.getElementById("eventEndSunset").value = iTemp;
					document.getElementById("eventEndTimezoneDiv").style.display = "none";
					document.getElementById("eventEndingTimeDiv").style.visibility = "hidden";
					/*
					if(!g_bUseFixedSunsriseSunset) {
						d = new Date(scheduleObj.endingDate.replace(/\-/g,"/"));
						solar = new solarCalc(d,g_dLatitude, g_dLongitude);
						d = new Date(solar.sunset);
						d.setMinutes(d.getMinutes() - iTemp);
						document.getElementById("eventEndingTime").style.display = "none";
						document.getElementById("eventEndingTimeSunsetSpan").style.display = "inline-block";
						document.getElementById("eventEndingTimeSunsetSpan").innerHTML = d.toLocaleTimeString('en-GB');
					}
					*/
				}
				else if(temp.charAt(0) === "R") {
					document.getElementById("eventEndOffsetType").value = "After Sunrise";
					temp = temp.substr(1);
					items = temp.split(":");
					iTemp = (Number(items[0]) * 60) + Number(items[1]);
					document.getElementById("eventEndSunsetDiv").style.display = "inline-block";
					document.getElementById("eventEndSunset").value = iTemp;
					document.getElementById("eventEndTimezoneDiv").style.display = "none";
					document.getElementById("eventEndingTimeDiv").style.visibility = "hidden";
					/*
					if(!g_bUseFixedSunsriseSunset) {
						d = new Date(scheduleObj.endingDate.replace(/\-/g,"/"));
						solar = new solarCalc(d,g_dLatitude, g_dLongitude);
						d = new Date(solar.sunrise);
						d.setMinutes(d.getMinutes() - iTemp);
						document.getElementById("eventEndingTime").style.display = "none";
						document.getElementById("eventEndingTimeSunsetSpan").style.display = "inline-block";
						document.getElementById("eventEndingTimeSunsetSpan").innerHTML = d.toLocaleTimeString('en-GB');
					}
					*/
				}
				else if(temp.charAt(temp.length - 1) === "S") {
					document.getElementById("eventEndOffsetType").value = "Before Sunset";
					temp = temp.substr(0, (temp.length - 1));
					items = temp.split(":");
					iTemp = (Number(items[0]) * 60) + Number(items[1]);
					document.getElementById("eventEndSunsetDiv").style.display = "inline-block";
					document.getElementById("eventEndSunset").value = iTemp;
					document.getElementById("eventEndTimezoneDiv").style.display = "none";
					document.getElementById("eventEndingTimeDiv").style.visibility = "hidden";
					/*
					if(!g_bUseFixedSunsriseSunset) {
						d = new Date(scheduleObj.endingDate.replace(/\-/g,"/"));
						solar = new solarCalc(d,g_dLatitude, g_dLongitude);
						d = new Date(solar.sunset);
						d.setMinutes(d.getMinutes() + iTemp);
						document.getElementById("eventEndingTime").style.display = "none";
						document.getElementById("eventEndingTimeSunsetSpan").style.display = "inline-block";
						document.getElementById("eventEndingTimeSunsetSpan").innerHTML = d.toLocaleTimeString('en-GB');
					}
					*/
				}
				else if(temp.charAt(temp.length - 1) === "R") {
					document.getElementById("eventStartOffsetType").value = "Before Sunrise";
					temp = temp.substr(0, (temp.length - 1));
					items = temp.split(":");
					iTemp = (Number(items[0]) * 60) + Number(items[1]);
					document.getElementById("eventEndSunsetDiv").style.display = "inline-block";
					document.getElementById("eventEndSunset").value = iTemp;
					document.getElementById("eventEndTimezoneDiv").style.display = "none";
					document.getElementById("eventEndingTimeDiv").style.visibility = "hidden";
					/*
					if(!g_bUseFixedSunsriseSunset) {
						d = new Date(scheduleObj.endingDate.replace(/\-/g,"/"));
						solar = new solarCalc(d,g_dLatitude, g_dLongitude);
						d = new Date(solar.sunrise);
						d.setMinutes(d.getMinutes() + iTemp);
						document.getElementById("eventEndingTime").style.display = "none";
						document.getElementById("eventEndingTimeSunsetSpan").style.display = "inline-block";
						document.getElementById("eventEndingTimeSunsetSpan").innerHTML = d.toLocaleTimeString('en-GB');
					}
					*/
				}
				else {
					document.getElementById("eventEndOffsetType").value = "No";
					document.getElementById("eventEndSunsetDiv").style.display = "none";
					document.getElementById("eventEndingTime").value = scheduleObj.endingTime;
					document.getElementById("eventEndTimezoneDiv").style.display = "none";
					if(!g_bUseFixedSunsriseSunset) {
						document.getElementById("eventEndingTime").style.display = "inline-block";
						document.getElementById("eventEndingTimeSunsetSpan").style.display = "none";
					}
				}
			
/*
				if((document.getElementById("eventStartOffsetType").value === "No") && (document.getElementById("eventEndOffsetType").value === "No")) {
					document.getElementById("evenAllDayDiv").style.visibility = "visible";
				}
				else {
					document.getElementById("evenAllDayDiv").style.visibility = "hidden";
				}
*/
			}
			
			

			document.getElementById("eventRepeatEnd").text = "Never";
			document.getElementById("eventEndDateDiv").style.display = "none";
			document.getElementById("eventSpecificRepeatDiv").style.display = "none";
			document.getElementById("eventDaysCheckbox").style.display = "none";
			if(typeof scheduleObj.end !== "undefined") {
				if(scheduleObj.end === "NONE") {
					document.getElementById("eventRepeatEnd").value = "Never";
				}
				else {
					bContinue = true;
					if(typeof scheduleObj.metadata.endDateType !== "undefined") {
						if(scheduleObj.metadata.endDateType === "REPEATS"){
							if(typeof scheduleObj.metadata.repeatsCount !== "undefined") {

								bContinue = false;
								document.getElementById("eventRepeatEnd").value = "Repeat count";
								document.getElementById("eventSpecificRepeatDiv").style.display = "flex";
								document.getElementById("eventEndRepeatCount").value = scheduleObj.metadata.repeatsCount;

							}
						}
					}
					if(bContinue) {
						document.getElementById("eventRepeatEnd").value = "Date";
						document.getElementById("eventEndDateDiv").style.display = "flex";
						document.getElementById("eventEndDate").value = scheduleObj.end;
					}
				}
			}

			//event repeat
			if(typeof scheduleObj.repeat === "object") { 
				if(scheduleObj.repeat === null) {

				}
				else if(typeof scheduleObj.repeat.month !== "undefined") {
					if(scheduleObj.repeat.month === -1) {
						// every month
					}
					else {

					}
					if(typeof scheduleObj.repeat.week !== "undefined") {

					}
					else {

					}
					if(typeof scheduleObj.repeat.day !== "undefined") {
						
					}
					else {

					}

				}
				else if(typeof scheduleObj.repeat.week !== "undefined") {
					if(typeof scheduleObj.repeat.day !== "undefined") {
						
					}
					else {
						
					}
				}
				else if(typeof scheduleObj.repeat.weekday !== "undefined") { // weekday: 1 - 7 Mon - Sun, 8 = daily, 9 week days, 10=week end, 11 = Fri and Sat
					if((scheduleObj.repeat.weekday >=0) && (scheduleObj.repeat.weekday < 8)) {
						document.getElementById("eventRepeatType").value = "Weekly";
						document.getElementById("eventDaysCheckbox").style.display = "flex";
						switch(scheduleObj.repeat.weekday) {
							case 1: document.getElementById("eventMon").checked = true; break;
							case 2: document.getElementById("eventTue").checked = true; break;
							case 3: document.getElementById("eventWed").checked = true; break;
							case 4: document.getElementById("eventThur").checked = true; break;
							case 5: document.getElementById("eventFri").checked = true; break;
							case 6: document.getElementById("eventSat").checked = true; break;
							case 7: document.getElementById("eventSun").checked = true; break;
						}
					}
					else if (scheduleObj.repeat.weekday = 8)
						document.getElementById("eventRepeatType").value = "Daily";
					else if (scheduleObj.repeat.weekday = 9)
						document.getElementById("eventRepeatType").value = "Weekday";
					else if (scheduleObj.repeat.weekday = 10)
						document.getElementById("eventRepeatType").value = "Weekend";
				}
			}
			else if(typeof scheduleObj.repeat === "string") {
				if(scheduleObj.repeat === "NO_REPEAT") {
					document.getElementById("eventRepeatType").value = "No Repeat";
					document.getElementById("eventEndRepeatDiv").style.visibility = "visible";
				}
				else 
					document.getElementById("eventEndRepeatDiv").style.visibility = "visible";
			}
			element = document.getElementById("eventRepeatType");
			if(element !== null) {
				if(element.options[element.selectedIndex].text === "No Repeat") 
					document.getElementById("eventEndRepeatDiv").style.visibility = "hidden";
				else 
					document.getElementById("eventEndRepeatDiv").style.visibility = "visible";
			}

			document.getElementById("eventPriority").value = scheduleObj.priority;
			document.getElementById("eventStagger").value = scheduleObj.stagger;


			element = document.getElementById("eventActionSelect");
			if(element !== null) {
				if(typeof scheduleObj.presetName !== "undefined") {
					element.value = "Set datapoint preset";
					document.getElementById("eventDatapointType").style.display = "none";
					document.getElementById("eventValueDiv").style.display = "none";
					document.getElementById("eventPresetDiv").style.display = "flex";
					document.getElementById("eventPresets").value = scheduleObj.presetName;
				}
				else {
					element.value = "Set datapoint value";
					document.getElementById("eventValueDiv").style.display = "flex";
					document.getElementById("eventDatapointType").style.display = "inline-block";
					document.getElementById("eventPresetDiv").style.display = "none";
					document.getElementById("eventDatapointTypeSelect").value = scheduleObj.datapointTypeRef;
					value = scheduleObj.localizedValue;
					if(typeof value === "object") {
						document.getElementById("eventValue").value = JSON.stringify(value);
						//document.getElementById("eventValueEditButton").style.visibility = "visible";
						document.getElementById("eventValue").readOnly = true;
					}
					else {
						scheduleShowEditEventCreateValueFromDpType(1,value);
						
					}
				}
			}
			
			/*
			if(scheduleObj.metadata.endDateType === "NONE") {
				document.getElementById("eventRepeatEnd").text = "Never";
				document.getElementById("eventEndDateDiv").style.display = "none";
				document.getElementById("eventSpecificRepeatDiv").style.display = "none";
			}
			else if(scheduleObj.metadata.endDateType === "DATE") {
				document.getElementById("eventRepeatEnd").text = "Date";
				document.getElementById("eventEndDateDiv").style.display = "inline-block";
				document.getElementById("eventSpecificRepeatDiv").style.display = "none";
				if(typeof scheduleObj.end !== "undefined")
					document.getElementById("eventEndDate").value = scheduleObj.end;
			}
			else {
				document.getElementById("eventRepeatEnd").text = "Repeat count";
				document.getElementById("eventEndDateDiv").style.display = "none";
				document.getElementById("eventSpecificRepeatDiv").style.display = "inline-block";
			}
			*/
			sTemp = "<table id=\"eventDatapointTable\">"
			for(i=0; i < scheduleObj.metadata.datapoints.length; i++)
			{
				sTemp1 =  "";
				
				for(j=0; j < g_sceduleEventDatapointList.length; j ++)
				{
					if(g_sceduleEventDatapointList[j].dpQualifier === scheduleObj.metadata.datapoints[i].dpQualifier ) {
						sTemp1 = g_sceduleEventDatapointList[j].dpPath;
						break;
					}
				}
				
				sTemp += "<tr><td>" + sTemp1;
				sTemp += "</td><td><button onclick=\"scheduleShowEditEventTableRemoveRow(this)\">X</button></td><td id=\"sch_dpErr__" + sTemp1 + "\" class=\"eventErrorSpan\"></td></tr>";

			}
			sTemp += "</table>"
			document.getElementById("eventDatapointDiv").innerHTML = sTemp;
			table = document.getElementById("eventDatapointTable")
			document.getElementById("eventDatapointsCount").innerHTML = table.rows.length.toString();
			
			if(bAllDayEvent) {
				document.getElementById("eventAllDay").checked = true;
				scheduleShowEditEventAllDayCheckBox();
			}
		}
		else {
			// brand new schedule event, make sure value matches datapoint type selected.
			scheduleShowEditEventDatapointTypeSelect();
		}
		
	}
	catch{
		showAlertDialog(0,"Error: Can't show schedule list");
	}
}
function scheduleShowEditEventAddDatapoints() {
	var element = document.getElementById("eventActionSelect");
	var table = document.getElementById("eventDatapointTable");
	var value, len;
	try {
		if((element !== null) && (table !== null)) {
			value = element.options[element.selectedIndex].text;
			
			if(value === "Set datapoint value") {
				element = document.getElementById("eventDatapointTypeSelect");
				if(element !== null) {
					g_oDpFilter.datapointType = element.options[element.selectedIndex].text;
					g_oDpFilter.direction = "in";
				}
			}
			else {
				g_oDpFilter.direction = "in";
			}
			g_menuDatapointsEventDatapoints = [];
			len = table.rows.length;
			for(i=0;i < len; i++)
			{
				g_menuDatapointsEventDatapoints.push(table.rows[i].cells[0].innerHTML);
			}
			g_bDatapointMenuShowPreset = true;
			if(value === "Set datapoint value")
				g_bDatapointMenuShowPreset = false;
			menuDatapoints(0);
			
		}
	}
	catch {}
	
}
function scheduleShowEditEventCheckPresets(mode, requestUrl, json) {
	// Navtree no longer needed in 3.3 as presets object in datapoint properties has been fixed
	// add presets from DLA
	var i,j, z, url, presetValue, deviceTypePath;
	try {
		if(g_scheduleEventDlaIndex === -1) {
			return;
		}
		element = document.getElementById("eventPresets");
		if(element === null) {
			// something wrong not in schedule
			return;
		}
		if(element.options[element.selectedIndex].text !== "Set datapoint preset")
			return;
		if(mode === 1) {
			if(json !== null) {
				
				for(i= 0; i < json.length; i++)
				{
					z = -1;
					for(j=0; j <g_scheduleEventDlaList.length; j++ )
					{
						if(json[i].deviceTypeName === g_scheduleEventDlaList[j].deviceTypeName) {
							if(json[i].fullDpName === g_scheduleEventDlaList[j].fullDpName) {
								z = j;
								break;
							}
						}
					}
					if(z === -1) {
						
						g_scheduleEventDlaList.push(JSON.parse(JSON.stringify(json[i])));
					}
					
				}
			}
		}
		//check if need to do request
		if(g_scheduleEventDlaIndex < g_sceduleEventDatapointList.length) {
		
			for(i= g_scheduleEventDlaIndex; i < g_sceduleEventDatapointList.length; i++)
			{
				z = -1;
				
				for(j=0; j <g_scheduleEventDlaList.length; j++ )
				{
					deviceTypePath = g_scheduleEventDlaList[j].deviceTypeName + "/" + g_scheduleEventDlaList[j].fullDpName;
					if(g_sceduleEventDatapointList[i].dpDeviceTypePath === deviceTypePath) {
						z = j;
						break;
					}
				}
				if(z === -1) {
					g_scheduleEventDlaIndex = z + 1;
					url = "https://" + location.host + "/iap/devTypes/*/if/*+name=~" + g_sceduleEventDatapointList[i].blockName;
					url += "/*+name=~" + g_sceduleEventDatapointList[i].blockIndex + "/*+name=~" + g_sceduleEventDatapointList[i].datapointName + "/dla"
					requestGetData(1, url, scheduleShowEditEventCheckPresets, scheduleShowEditEventCheckPresetsFailCallback);
					return;
				}
				else 
					g_scheduleEventDlaIndex ++;
			}
			
		}
		g_scheduleEventDlaIndex = -1;

		// check if datapoints support the current selected preset
		presetValue = element.options[element.selectedIndex].text;
		presetValue = presetValue.toLowerCase();
		if(presetValue !== "") {
			for(i= 0; i < g_sceduleEventDatapointList.length; i++)
			{
				for(j=0; j <g_scheduleEventDlaList.length; j++ )
				{
					deviceTypePath = g_scheduleEventDlaList[j].deviceTypeName + "/" + g_scheduleEventDlaList[j].fullDpName;
					if(g_sceduleEventDatapointList[i].dpDeviceTypePath === deviceTypePath) {
						z = j;
						break;
					}
				}
				if(z !== -1) {
					z = -1;
					//determine which row datapoint is in.
					element = document.getElementById("sch_dpErr__" + g_sceduleEventDatapointList[i].pathname);
					if(element !== null) {


						z = -1;
						for(j=0; j <g_scheduleEventDlaList[z].presets.length; j++ )
						{
							if(g_scheduleEventDlaList[z].presets[j].toLowerCase() === presetValue) {
								z = -1;
								break;
							}
						}
						if(z=== -1) {
							// has value
							element.innerHTML = "* this preset not supported";
						}
						else {
							element.innerHTML = "";
						}
					}
				
				}
			}
		}
	}
	catch {}
}
function scheduleShowEditEventCheckPresetsFailCallback(mode, requestUrl, json) {
	scheduleShowEditEventCheckPresets(2, requestUrl, []);
}
function scheduleShowEditEventAddFavDpListToScheduleDatapoints(pathname) {
	// add single datapoint
	var table = document.getElementById("eventDatapointTable");
	var row, cell1, cell2, cell3;
	var iRow = 0,iCount = 0, len, obj, i;
	var name1, name2;
	var element, sTemp;
	try {
		if(table === null)
			return;
		if(g_dpList.length === 0)
			return;
		g_scheduleEventDlaIndex = g_sceduleEventDatapointList.length;

		for(i=0; i < g_dpList.length; i++)
		{
			if(g_dpList[i].pathname === pathname) {
				//navtreeffix - need to add code so no duplicates
				// check if already in list if not add
				name1 = g_dpList[i].pathname + " ";
				obj = {};
				obj.dpPath = g_dpList[i].pathname; //fixx
				obj.dpProgrammaticPath = g_dpList[i].programmaticPath;
				obj.deviceName = g_dpList[i].deviceName;
				obj.dpQualifier = g_dpList[i].dpQualifier;
				obj.dpBlockPath = g_dpList[i].blockName + "/" + g_dpList[i].blockIndex + "/" + g_dpList[i].datapointName;
				obj.blockName = g_dpList[i].blockName;
				obj.blockIndex = g_dpList[i].blockIndex;
				obj.datapointName = g_dpList[i].datapointName;
				obj.dpType = g_dpList[i].type;
				obj.dpDeviceTypePath = "";
				z = -1;
				for(j=0; j < deviceListAll.length; j++)
				{
					if(deviceListAll[j].name === obj.deviceName) {
						z = j;
						obj.dpDeviceTypePath = deviceListAll[j].deviceTypeName + "/" + g_dpList[i].blockName + "/" + g_dpList[i].blockIndex + "/" + g_dpList[i].datapointName;
					}
				}
				if(z !== -1) {
					
				}


				g_sceduleEventDatapointList.push(obj);
				
				len = table.rows.length;
				iRow = len;
				for(j=0; j < len; j++)
				{
					name2 = table.rows[j].cells[0].innerHTML + " ";
					if(name1 < name2 ){
						iRow = j;
						break;
					}
				}
				row = table.insertRow(iRow);
				cell1 = row.insertCell(0);
				cell2 = row.insertCell(1);
				cell3 = row.insertCell(2);
				cell1.innerHTML = g_dpList[i].pathname;
				cell2.innerHTML = "<button onclick=\"scheduleShowEditEventTableRemoveRow(this)\">X</button>";
				cell3.innerHTML = "";
				cell3.id = "sch_dpErr__" + g_dpList[i].pathname;
				cell3.className = "eventErrorSpan";
				//cell3.style.color = "red";
				break;
			}
		}
		document.getElementById("eventDatapointsCount").innerHTML = table.rows.length.toString();
		// not sure this is needed    scheduleShowEditEventFullCheck(2);
	}
	catch {}
	
}
function scheduleShowEditEventAddFavDpsListToScheduleDatapoints() {
	var table = document.getElementById("eventDatapointTable");
	var row, cell1, cell2, cell3;
	var iRow = 0,iCount = 0, len, obj, i;
	var name1, name2;
	var element, sTemp;
	try {
		if(table === null)
			return;
		if(g_favDpList.length === 0)
			return;
		g_scheduleEventDlaIndex = g_sceduleEventDatapointList.length;
		for(i=0; i < g_favDpList.length; i++)
		{
			//navtreeffix - need to add code so no duplicates
			// check if already in list if not add
			name1 = g_favDpList[i].pathname + " ";
			obj = {};
			obj.dpPath = g_favDpList[i].pathname; //fixx
			obj.dpProgrammaticPath = g_favDpList[i].programmaticPath;
			obj.deviceName = g_favDpList[i].deviceName;
			obj.dpQualifier = g_favDpList[i].dpQualifier;
			obj.dpBlockPath = g_favDpList[i].blockName + "/" + g_favDpList[i].blockIndex + "/" + g_favDpList[i].datapointName;
			obj.blockName = g_favDpList[i].blockName;
			obj.blockIndex = g_favDpList[i].blockIndex;
			obj.datapointName = g_favDpList[i].datapointName;
			obj.dpType = g_favDpList[i].type;
			obj.dpDeviceTypePath = "";
			z = -1;
			for(j=0; j < deviceListAll.length; j++)
			{
				if(deviceListAll[j].name === obj.deviceName) {
					z = j;
					obj.dpDeviceTypePath = deviceListAll[j].deviceTypeName + "/" + g_favDpList[i].blockName + "/" + g_favDpList[i].blockIndex + "/" + g_favDpList[i].datapointName;
				}
			}
			if(z !== -1) {
				
			}


			g_sceduleEventDatapointList.push(obj);
			
			len = table.rows.length;
			iRow = len;
			for(j=0; j < len; j++)
			{
				name2 = table.rows[j].cells[0].innerHTML + " ";
				if(name1 < name2 ){
					iRow = j;
					break;
				}
			}
			row = table.insertRow(iRow);
			cell1 = row.insertCell(0);
			cell2 = row.insertCell(1);
			cell3 = row.insertCell(2);
			cell1.innerHTML = g_favDpList[i].pathname;
			cell2.innerHTML = "<button onclick=\"scheduleShowEditEventTableRemoveRow(this)\">X</button>";
			cell3.innerHTML = "";
			cell3.id = "sch_dpErr__" + g_favDpList[i].pathname;
			cell3.className = "eventErrorSpan";
			//cell3.style.color = "red";
		}
		document.getElementById("eventDatapointsCount").innerHTML = table.rows.length.toString();
		scheduleShowEditEventFullCheck(2);
	}
	catch {}
	
}
function scheduleShowEditEventCreateSchedule(mode) {
	// mode: 0=create, 1=copy, 2= edit
	try {
		var element, i, j, len, rsp, value, d;
		var url = "https://" + location.host + "/iap/sev?customerId=" + g_customerId;
		var sch = {};
		var schStr;
		var days = ["Mon","Tue","Wed","Thur","Fri","Sat", "Sun"];
		var table = document.getElementById("eventDatapointTable");
		if(table === null)
			return;

		sch.name = document.getElementById("eventName").value;  //required
		if(!scheduleShowEditEventFullCheck(0)) {
			showAlertDialog(0,"Error: there are one or more errors");
			return;
		}
		
		if(mode === 2) {
			if(document.getElementById("eventId").innerHTML !== "-1")
				sch.id = document.getElementById("eventName").innerHTML;  // only add if editing event
		}
		sch.color = document.getElementById("eventColorDiv").style.backgroundColor;
		sch.color = convertRgbStrToHex(sch.color);
		sch.color = sch.color.toUpperCase(); //required
		sch.customerId = g_customerId; // required

		//sch.description = document.getElementById("eventDescriptionTextarea").value;
		//if(sch.description === "") {
		//	sch.description = sch.name + " created by NavTree";
		//}
		element = document.getElementById("eventPriority");
		sch.priority = element.options[element.selectedIndex].text; //required
		if(sch.priority === "Normal")
			sch.priority = 17;
		sch.stagger = document.getElementById("eventStagger").value;
		sch.stagger = Number(sch.stagger);
		sch.tags = []; //document.getElementById("eventTags").value;
		value = document.getElementById("eventTags").value.trim();
		if(value !== "") {

		}
		sch.start = document.getElementById("eventStartingDate").value; //required
		sch.startingDate = document.getElementById("eventStartingDate").value; //required
		if(document.getElementById("eventAllDay").checked) {
			sch.startingTime = "00:00"; //required
			sch.endingDate = sch.startingDate; //required
		
			//sch.endingTime = document.getElementById("eventEndingTime").value; //not used
			if(typeof sch.metadata === "undefined")
				sch.metadata = {};
				sch.metadata.allDay = true;
		}
		else {
			sch.endingDate = document.getElementById("eventEndingDate").value; //required
			sch.startingTime = document.getElementById("eventStartingTime").value; //required
			sch.endingTime = document.getElementById("eventEndingTime").value; //required
			sTemp = document.getElementById("eventStartOffsetType").value;
			if(sTemp === "After Sunset") {
				value = document.getElementById("eventStartSunset").value;
				iTemp = Math.floor(value / 60);
				sTemp = "S" + iTemp.toString().padStart(2,0) + ":" + (value - (iTemp * 60)).toString().padStart(2,0);
				sch.startingTime = sTemp;
			}
			else if(sTemp === "Before Sunset") {
				value = document.getElementById("eventStartSunset").value;
				iTemp = Math.floor(value / 60);
				sTemp = iTemp.toString().padStart(2,0) + ":" + (value - (iTemp * 60)).toString().padStart(2,0) + "S";
				sch.startingTime = sTemp;
			}
			if(sTemp === "After Sunrise") {
				value = document.getElementById("eventStartSunset").value;
				iTemp = Math.floor(value / 60);
				sTemp = "R" + iTemp.toString().padStart(2,0) + ":" + (value - (iTemp * 60)).toString().padStart(2,0);
				sch.startingTime = sTemp;
			}
			else if(sTemp === "Before Sunrise") {
				value = document.getElementById("eventStartSunset").value;
				iTemp = Math.floor(value / 60);
				sTemp = iTemp.toString().padStart(2,0) + ":" + (value - (iTemp * 60)).toString().padStart(2,0) + "R"
				sch.startingTime = sTemp;
			}

			sTemp = document.getElementById("eventEndOffsetType").value;
			if(sTemp === "After Sunset") {
				value = document.getElementById("eventEndSunset").value;
				iTemp = Math.floor(value / 60);
				sTemp = "S" + iTemp.toString().padStart(2,0) + ":" + (value - (iTemp * 60)).toString().padStart(2,0);
				sch.endingTime = sTemp;
			}
			else if(sTemp === "Before Sunset") {
				value = document.getElementById("eventEndSunset").value;
				iTemp = Math.floor(value / 60);
				sTemp = iTemp.toString().padStart(2,0) + ":" + (value - (iTemp * 60)).toString().padStart(2,0) + "S";
				sch.endingTime = sTemp;
			}
			if(sTemp === "After Sunrise") {
				value = document.getElementById("eventEndSunset").value;
				iTemp = Math.floor(value / 60);
				sTemp = "R" + iTemp.toString().padStart(2,0) + ":" + (value - (iTemp * 60)).toString().padStart(2,0);
				sch.endingTime = sTemp;
			}
			else if(sTemp === "Before Sunrise") {
				value = document.getElementById("eventEndSunset").value;
				iTemp = Math.floor(value / 60);
				sTemp = iTemp.toString().padStart(2,0) + ":" + (value - (iTemp * 60)).toString().padStart(2,0) + "R"
				sch.endingTime = sTemp;
			}
		}

		sch.datapoints = []; //required
		//sch.datapoints.push("17qam77/lon/1/Lamp/0/nviLamp"); 
		//sch.datapointTypeRef = "SNVT_switch";

		element = document.getElementById("eventActionSelect");
		if(element !== null) {
			if(element.value === "Set datapoint preset") {
				element = document.getElementById("eventPresets");
				sch.presetName = element.options[element.selectedIndex].text;
				sch.value = null;
			}
			else { // "Set datapoint value"
				value = document.getElementById("eventDatapointTypeSelect").value
				sch.datapointTypeRef = value;
				sch.localizedValue = {}; //required
				value = null;
				//value.state = 1;
				//value.value = 27;
				if(document.getElementById("eventValueDiv").display === "inline-block") {
					value = JSON.parse(document.getElementById("eventValue").value);
				}
				else if (document.getElementById("eventDropdownValueDiv").display === "inline-block") {
					value = JSON.parse(document.getElementById("eventDropdownValue").value);
				}
				else {

				}
				value = JSON.parse(document.getElementById("eventValue").value);
				sch.localizedValue = value;
				sch.value = null;
			}
		}





		
		sch.repeat = {}; //required

		element = document.getElementById("eventRepeatType");
		value = element.options[element.selectedIndex].text; //required
		if(value === "No Repeat") {
			sch.repeat = null;
			sch.start = sch.startingDate;
			sch.end = sch.endingDate;
			//sch.repeat = "NO_REPEAT";
		}
		else if(value === "Daily") {
			sch.repeat["weekday"] = 8;  // weekday: 1 - 7 Mon - Sun, 8 = daily, 9 week days, 10=week end, 11 = Fri and Sat
		}
		else if(value === "Weekly") {
			// only single day can be selected
			for(i=0; i < 7; i++)
			{
				element = document.getElementById("event" + days[i]);
				if(element !== null) {
					if(element.checked) {
						sch.repeat["weekday"] = i + 1;  // weekday: 1 - 7 Mon - Sun, 8 = daily, 9 week days, 10=week end, 11 = Fri and Sat
						break;
					}
				}
			}
		}
		else if(value === "Weekday") {
			sch.repeat["weekday"] = 9;  // weekday: 1 - 7 Mon - Sun, 8 = daily, 9 week days, 10=week end, 11 = Fri and Sat
		}
		else if(value === "Weekend") {
			sch.repeat["weekday"] = 10;  // weekday: 1 - 7 Mon - Sun, 8 = daily, 9 week days, 10=week end, 11 = Fri and Sat
		}
		else if(value === "Month by day of Month") {
			//sch.repeat["weekday"] = 9;  // weekday: 1 - 7 Mon - Sun, 8 = daily, 9 week days, 10=week end, 11 = Fri and Sat
			showAlertDialog(0,value + "\r\n\r\nAborted - Not supported yet");
			return;
		}
		else if(value === "Month by day of Week") {
			//sch.repeat["weekday"] = 10;  // weekday: 1 - 7 Mon - Sun, 8 = daily, 9 week days, 10=week end, 11 = Fri and Sat
			showAlertDialog(0,value + "\r\n\r\nAborted - Not supported yet");
			return;
		}
		else if(value === "Year by month and day") {
			//sch.repeat["weekday"] = 9;  // weekday: 1 - 7 Mon - Sun, 8 = daily, 9 week days, 10=week end, 11 = Fri and Sat
			showAlertDialog(0,value + "\r\n\r\nAborted - Not supported yet");
			return;
		}
		else if(value === "Year by month, week and day") {
			//sch.repeat["weekday"] = 10;  // weekday: 1 - 7 Mon - Sun, 8 = daily, 9 week days, 10=week end, 11 = Fri and Sat
			showAlertDialog(0,value + "\r\n\r\nAborted - Not supported yet");
			return;
		}

		// populate datapoints
		len = table.rows.length;
		if(len === 0) {
			showAlertDialog(0,"Event: Need to add at least one datapoint");
			return;
		}
		for(i=0;i < len; i++)
		{
			value = table.rows[i].cells[0].innerHTML;
			for(j=0; j< g_sceduleEventDatapointList.length; j++)
			{
				if(g_sceduleEventDatapointList[j].dpPath === value) {
					sch.datapoints.push(g_sceduleEventDatapointList[j].dpQualifier);
					break;
				}
			}

		}
		value = document.getElementById("eventRepeatEnd").value;
		if(value === "Date") {
			sch.end = document.getElementById("eventEndDate").value;
		}
		else if(value === "Repeat count") {
			if(typeof sch.metadata === "undefined")
				sch.metadata = {};
			sch.metadata.endDateType = "REPEATS";
			value = document.getElementById("eventEndRepeatCount").value;
			value = Number(value);
			if(value < 1) {
				showAlertDialog(0,"Repeat Count has to be 1 or greater")
				return;
			}
			sch.metadata.repeatsCount = value;
			d = new Date(sch.start.replace(/\-/g,"/"));
			d.setDate(d.getDate() + value);
			sch.end = d.getFullYear() + "-" + (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0); 
		}
		else {

		}
		
		

		/*
		sch.weekly = {};
		sch.weekly["8"] = {};
		sch.weekly["8"]["08:00"] = {};
		sch.weekly["8"]["08:00"].state = 1;
		sch.weekly["8"]["08:00"].value = 62;
		*/
		
		//sch.repeat["month"] = 8;
		//sch.repeat["day"] = 16;
		
/*
//sch.end = document.getElementById("eventEndDate").value;
		sch.localizedValue = document.getElementById("eventValue").value;
		sch.value = null;

		sch.metadata = {};
		sch.metadata.datapoints = [];

		

		sch.metadata.endingOffset = {};
		element = document.getElementById("eventEndOffsetType");
		sch.metadata.endingOffsetType =  element.options[element.selectedIndex].text;
		sch.metadata.fromWidget = false;
		//sch.metadata.localStorageEndingTime = 
		//sch.metadata.localStorageStartingTime = 
		sch.metadata.notNullDatapointValue = {};
		sch.metadata.selectedDatapointType = {};
		element = document.getElementById("eventActionSelect");
		value = element.options[element.selectedIndex].text;
		for(i=0; i < g_dpTypesAvailableList.length; i++)
		{
			if(g_dpTypesAvailableList[i].typeId === value) {
				sch.metadata.selectedDatapointType = JSON.parse(JSON.stringify(g_dpTypesAvailableList[i]))
				break;
			}
		}

		element = document.getElementById("eventEndOffsetType");
		value = element.options[element.selectedIndex].text;
		sch.metadata.repeatOption = value;
		
		sch.metadata.startingOffset = {};
		element = document.getElementById("eventStartOffsetType");
		sch.metadata.startingOffsetType =  element.options[element.selectedIndex].text;
		element = document.getElementById("eventTargetSelect");
		value = element.options[element.selectedIndex].text;
		if(value === "Datapoint value")
			value = "datapoint"
		else 
			value = "favorite"
		sch.metadata.targetType = value;

		len = table.rows.length;
		for(i=0;i < len; i++)
		{
			value = table.rows[i].cells[0].innerHTML;
			for(j=0; j< g_sceduleEventDatapointList.length; j++)
			{
				if(g_sceduleEventDatapointList[j].pathname === value) {
					sch.datapoints.push(g_sceduleEventDatapointList[j].dpQualifier);
					sch.metadata.datapoints.push(JSON.parse(JSON.stringify(g_sceduleEventDatapointList[j])));
					if(i === 0) {
						sch.metadata.notNullDatapointValue = JSON.parse(JSON.stringify(g_sceduleEventDatapointList[j]));
					}
					break;
				}
			}

		}
		*/
		
		url = "https://" + location.host;
		if(mode === 0) {
			// create
			schStr = JSON.stringify(sch);
			//alert(schStr);
			g_iScheduleView = 3;
			element = document.getElementById("eventScheduleView");
			if(element !== null)
				g_iScheduleView = element.value;
			url += "/iap/sev?customerId=" + g_customerId;
			Rsp = requestPostFunction(1, url, schStr,  scheduleShowEditEventRefresh, scheduleShowEditEventRefreshFailCallback); 
			
		}
		else if(mode === 1) {
			// copy
			schStr = JSON.stringify(sch);
			//alert(schStr);
			g_iScheduleView = 3;
			element = document.getElementById("eventScheduleView");
			if(element !== null)
				g_iScheduleView = element.value;
			url += "/iap/sev?customerId=" + g_customerId;
			Rsp = requestPostFunction(1, url, schStr,  scheduleShowEditEventRefresh, scheduleShowEditEventRefreshFailCallback); 
			
		} 
		else if(mode === 2) {
			// edit
			element = document.getElementById("eventId");
			if(element !== null) {
				if(element.innerHTML !== "") {
					sch.id = Number(element.innerHTML);
					schStr = JSON.stringify(sch);
					//alert(schStr);
					
					url += "/iap/sev/" + Number(element.innerHTML);
					g_iScheduleView = 3;
					element = document.getElementById("eventScheduleView");
					if(element !== null)
						g_iScheduleView = element.value;

					Rsp = requestPutData(0, url, schStr,  scheduleShowEditEventRefresh, scheduleShowEditEventRefreshFailCallback); 
				}
			}
		}
		menuScheduleCreateDivClose();
		//navtreeadd add refresh current week/month/year/day
	}
	catch {
		showAlertDialog(0,"Event Create/Edit aborted: Something wrong with data");
		return;
	}
}
function scheduleShowEditEventRefresh(mode, url,json) {
	 
	getSchedules(0, "");
}
function scheduleShowEditEventRefreshFailCallback(mode, url,json) {
	try {
		var sTemp = "";
		if(json === null) {
		}
		if(json.response === null){
		}
		
		if(json.response !== "") {
			try {
				obj = JSON.parse(json.response);
				if(typeof obj.message !== "undefined") {
					sTemp = obj.message;
					sTemp = sTemp.replaceAll("<br/>","\r\n");
				}

			}
			catch {}
		}
		showAlertDialog(0,"Error: Schedule not created/modified\r\n\r\n" + sTemp)
	}
	catch {}
}
function scheduleShowEditEventAllDayCheckBox() {
	try {
		var visibility =  "visible"
		if(document.getElementById("eventAllDay").checked) {
			visibility =  "hidden";
		}
		else {

		}
		//document.getElementById("eventStartingTime").style.visibility = visibility;
		//document.getElementById("eventEndingTime").style.visibility = visibility;
		//document.getElementById("eventStartingTimeSpan").style.visibility = visibility;
		//document.getElementById("eventEndingTimeSpan").style.visibility = visibility;

		if(visibility ===  "hidden") {
			document.getElementById("eventStartingTimeDiv").style.visibility = visibility;
			document.getElementById("eventEndingTimeDiv").style.visibility = visibility;
			
		}
		else {
			// check if sunrise/sunset relative is no
			if(document.getElementById("eventStartOffsetType").value === "No") {
				document.getElementById("eventStartingTimeDiv").style.visibility = "visible";
				
			}
			else  {
				document.getElementById("eventStartingTimeDiv").style.visibility = "hidden";
				
			}
			if(document.getElementById("eventEndOffsetType").value === "No") {
				document.getElementById("eventEndingTimeDiv").style.visibility = "visible";
				
			}
			else  {
				document.getElementById("eventEndingTimeDiv").style.visibility = "hidden";
				
			}
		}


		document.getElementById("eventStartOffsetType").style.visibility = visibility;
		document.getElementById("eventStartSunset").style.visibility = visibility;
		document.getElementById("eventEndOffsetType").style.visibility = visibility;
		document.getElementById("eventEndSunset").style.visibility = visibility;
		document.getElementById("eventStartSunsetMin").style.visibility = visibility;
		document.getElementById("eventEndSunsetMin").style.visibility = visibility;

		
		document.getElementById("eventStartSunriseSunsetRelativeLabel").style.visibility = visibility;
		
		document.getElementById("eventEndSunriseSunsetRelativeLabel").style.visibility = visibility;
		document.getElementById("eventEndDateSpan").style.visibility = visibility;
		document.getElementById("eventEndingDate").style.visibility = visibility;
	}
	catch {}
}
function scheduleShowEditEventCreateScheduleCheck(mode, value) {
	var bResult = true;
	var result = {};
	var regex = /^[A-Za-z0-9-_]+$/; // nospaces only english regex = /^[\w-]+$/;
	var iPtr;
	try {
		result.result = true;
		result.errMsg = "";
		if(mode === 0) {
			if(value.length === 0) {
				result.result = false;
				result.errMsg = "Name must be at least 3 characters";
			}
			else {	
				if(value.indexOf(" ") !== -1) {
					result.result = false;
					result.errMsg = "No Spaces are allowed in name";
				}
				else {
					bResult = regex.test(value);
					if(bResult) {
						iPtr = value.lastIndexOf("_");
						if(iPtr !== -1) {
							if(iPtr === value.length - 1) {
								result.result = false;
								result.errMsg = "Name can't end with \"_\"";
							}
						}
						iPtr = value.lastIndexOf("-");
						if(iPtr !== -1) {
							if(iPtr === value.length - 1){
								result.result = false;
								result.errMsg = "Name can't end with \"-\"";
							}
						}
					}
				}
			}
		}
	}
	catch {

	}
	return result
}
function scheduleShowEditEventStartDateChanged() {
	try {
		element = document.getElementById("eventStartingDate");
		if(element !== null) {
			document.getElementById("eventEndingDate").value = element.value;
		}
	}
	catch {}
}
function scheduleShowEditEventDayCheckbox(day) {
	//use prior to 3.4 in which only one day can be selected at a time, in 3.4 you will be able to select multiple days. 
	try {
		var element;
		var days = ["Mon","Tue","Wed","Thur","Fri","Sat", "Sun"];
		for(i=0; i < 7; i++)
		{
			if(i !== day) {
				element = document.getElementById("event" + days[i]);
				if(element !== null)
					element.checked = false;
			}
		}
	}
	catch {}
}
function scheduleShowEditEventCreateValueFromDpType(mode, value1) {
	try {
		var value, i, j;
		var typeJson;
		var sTemp = "";
		var element = document.getElementById("eventDatapointTypeSelect");
		var element1 = document.getElementById("eventValue");
		var element2 = document.getElementById("eventDropdownValue");
		var element3 = document.getElementById("eventValueDiv");
		var element4 = document.getElementById("eventDropdownValueDiv");
		if((element !== null) && (element1 !== null)) {
			value = element.options[element.selectedIndex].text;
			for(i=0; i < g_dpTypesAvailableList.length; i++)
			{
				if(g_dpTypesAvailableList[i].typeId === value) {
					typeJson = g_dpTypesAvailableList[i].typeJson;
					// create value from typeJson

					if((typeJson.type === "integer") || (typeJson.type === "scalar") || (typeJson.type === "float") || (typeJson.type === "boolean")){
						document.getElementById("eventValue").readOnly = false;
						if(typeof typeJson.values !== "undefined") {
							//typeJson.enum
							document.getElementById("eventValueDiv").style.display = "none";
							document.getElementById("eventDropdownValueDiv").style.display = "inline-block";
							//document.getElementById("eventValueEditButton").style.display = "none";
							sTemp = "<span style=\"display:inline-block;width:50px\">Value: </span><select  id=\"eventDropdownValue\" style=\"min-width:30px\">"
							for(j=0; j < typeJson.values.length; j++)
							{
								sTemp += "<option value=\"" + typeJson.values[j] + "\"";
								if(mode === 0) {
									if(j===0)
										sTemp += " selected";
								}
								else if(mode === 1) {
									if(typeJson.values[j] === value1)
										sTemp += " selected";
								}
								sTemp += ">" + typeJson.values[j] + "</option>";
							}
							sTemp += "</Select>";
							document.getElementById("eventDropdownValueDiv").innerHTML = sTemp;
						}
						else {
							document.getElementById("eventValueDiv").style.display = "inline-block";
							document.getElementById("eventDropdownValueDiv").style.display = "none";
							//document.getElementById("eventValueEditButton").style.display = "none";
							if(mode === 0) {
								inValid = null;
								if(typeof typeJson.inValid !== "undefined")
									inValid = typeJsonn.inValid;
								if(typeof typeJson.min === "undefined") {
									element1.value = 0;
									
								}
								else if((typeJson.min <= 0) && (typeJson.max >= 0)) {
									if(inValid !== null) {
										if(inValid !== 0)
											element1.value = 0;
										else 
											element1 = typeJson.min;
									}
									else {
										element1.value = 0;
									}
								}
								else {
									if(inValid !== null) {
										if(inValid === typeJson.min)
											element1.value = typeJson.min + 1;
										else 
											element1.value = typeJson.min;
									}
									else 
										element1.value = typeJson.min;
								}
							}
							else 
								element1.value = value1;
						}
					}
					else if(typeJson.type === "enum") {
						//typeJson.enum
						document.getElementById("eventValueDiv").style.display = "none";
						document.getElementById("eventDropdownValueDiv").style.display = "inline-block";

						sTemp = "<span style=\"display:inline-block;width:50px\">Value: </span><select  id=\"eventDropdownValue\" style=\"min-width:30px\">"
						for(j=0; j < typeJson.enum.length; j++)
						{
							sTemp += "<option value=\"" + typeJson.enum[j].id + "\"";
							if(mode === 0) {
								if(j===0)
									sTemp += " selected";
							}
							else if(mode === 1) {
								if(typeJson.values[j] === value1)
									sTemp += " selected";
							}

							sTemp += ">" + typeJson.enum[j].id + "</option>";
						}
						sTemp += "</Select>";
						document.getElementById("eventDropdownValueDiv").innerHTML = sTemp;
						
					}
					else if(typeJson.type === "aggregate") {
						
						document.getElementById("eventValue").readOnly = true;
						document.getElementById("eventValueDiv").style.display = "inline-block";
						document.getElementById("eventDropdownValueDiv").style.display = "none";
						//document.getElementById("eventValueEditButton").style.display = "inline-block";
						if(mode === 0)
							element1.value = JSON.stringify(scheduleShowEditEventCreateValueFromDpType1(typeJson.members, 0));
					}
					else if(typeJson.type === "string") {
						//typeJson.enum
						document.getElementById("eventValue").readOnly = false;
						document.getElementById("eventValueDiv").style.display = "inline-block";
						document.getElementById("eventDropdownValueDiv").style.display = "none";
						//document.getElementById("eventValueEditButton").style.display = "none";
						if(mode === 0)
							element1.value = "";
						else if (mode === 1) {
							element1.value = value1;
						}
						
					}
					break;
				}
			}
			
		}
	}
	catch {}
}
function scheduleShowEditEventCreateValueFromDpType1(members, level) {
	try {
		var result = {};
		var obj;
		var value;
		var i;
		
		for(i=0; i < members.length; i++)
		{
			if((members[i].type === "scalar") || (members[i].type === "float")) {
				value = 0;
				if(members[i].type === "float")
					value = 0.0;
				if((members[i].min > 0) || (members[i].max < 0 )) {
					value = members[i].min;
				}
				if(typeof members[i].invalid !== "undefined") {
					if(value === members[i].invalid)
						value ++;
				}
				result[members[i].id] = value;
			}
			else if(members[i].type === "bitfield") {

				result[members[i].id] = 0;
			}
			else if(members[i].type === "enum") {

				result[members[i].id] = members[i].enum[0].id;
			}
			else if((members[i].type === "object") || (members[i].type === "aggregate")) {
				level ++;
				result[members[i].id] = scheduleShowEditEventCreateValueFromDpType1(members[i].members, level); //scheduleShowEditEventCreateValue1(members[i].members, level);
			}
		}
	}
	catch {}
	return result;
}
function scheduleShowEditEventDatapointTypeSelect() {
	try {
		scheduleShowEditEventCreateValueFromDpType(0, "");
	}
	catch {}
}
function scheduleShowEditEventFullCheck(mode) {
	try {
		var bResult = false; // true=no errors
		var startingDateMs, endingDateMs;
		var startingTime, endingTime;
		var sTemp, sTemps;
		var errMsg = "";
		var element;
		var bContinue;
		if((mode === 0) || (mode === 1)) {
			bResult = scheduleShowEditEventNameChanged();
			if((!bResult) || (mode === 1)) {
				return bResult;
			}
		}
		if((mode === 0) || (mode === 2)) {
			bResult = scheduleShowEditEventCheckIfValidDatapoint();
			if((!bResult) || (mode === 2)) {
				return bResult;
			}
		}
		if((mode === 0) || (mode === 3)) {
			// verify that endingdate is same or later than starting date
			bResult = false;
			element = document.getElementById("eventStartingDate");
			if(element !== null) {
				startingDateMs = new Date(element.value.replace(/\-/g,"/")).getTime();
				element = document.getElementById("eventEndingDate");
				if(element !== null) {
					endingDateMs = new Date(element.value.replace(/\-/g,"/")).getTime();
					// check if sunsent to next day sunrise, if so then need to make sure date is different
					element1 = document.getElementById("eventStartOffsetType");
					if(element1 !== null) {
						bContinue = true;
						if(element1.value.indexOf("Sunset") !== -1) {
							element1 = document.getElementById("eventEndOffsetType");
							if(element1 !== null) {
								if(element1.value.indexOf("Sunrise") !== -1) {
									// start and end dates can't be the same
									bContinue = false;
									if(endingDateMs > startingDateMs)
										bResult = true;
									else 
										errMsg = "* Error: Ending Date must be later than Starting Date";
								}
							}
						}
						if(bContinue) {
							if(endingDateMs > startingDateMs)
								bResult = true;
							else if(endingDateMs === startingDateMs) {
								errMsg = "* Error: Ending Time must be later than Starting time";
								element = document.getElementById("eventStartingTime");

								if(element !== null) {
									sTemp = element.value;
									sTemp = sTemp.trim();
									sTemps = sTemp.split(":");
									if(sTemps.length === 2) {
										if((sTemp[0] !== "") && (sTemp[1] !== "")) {
											try {
												sTemps[0] = sTemps[0].trim();
												sTemps[1] = sTemps[1].trim();
												startingTime = (Number(sTemps[0]) * 60) + Number(sTemps[1]);
												element = document.getElementById("eventEndingTime");
												if(element !== null) {
													sTemp = element.value;
													sTemp = sTemp.trim();
													sTemps = sTemp.split(":");
													if(sTemps.length === 2) {
														if((sTemp[0] !== "") && (sTemp[1] !== "")) {
															sTemps[0] = sTemps[0].trim();
															sTemps[1] = sTemps[1].trim();
															endingTime = (Number(sTemps[0]) * 60) + Number(sTemps[1]);
															if(startingTime < endingTime)
																bResult = true;
														}
													}
												}
											}
											catch {}
										}
									}
								}
							}
							else
								errMsg =  "* Error: Ending Date must be same or later than Starting Date";
						}
					}
					else
							errMsg =  "* Error: Missing setting";
				}
			}
			element = document.getElementById("eventDateErrorSpan");
			if(element !== null) {
				if(bResult)
					element.innerHTML = "";
				else
					element.innerHTML = errMsg;
			}
			
			if((!bResult) || (mode === 3)) {
				return bResult;
			}
		}
		/*
		if((mode === 0) || (mode === 3)) {
			g_scheduleEventDlaIndex = 0;
			scheduleShowEditEventCheckPresets(0, "", []);
		} */

	}
	catch {}
	return bResult;
}
function scheduleShowEditEventNameChanged() {
 	try {
		var bResult = true;
		var name;
		var obj;
		var element = document.getElementById("eventName");
		if(element !== null) { 
			name = element.value;  //required
			if(name === "") {
				bResult = false;
				element = document.getElementById("eventNameError");
				if(element !== null)
					element.innerHTML = "* Need to add Schedule Name";
				return;
			}
			else if((name.length < 3) || (name.length > 64)) {
				bResult = false;
				element = document.getElementById("eventNameError");
				if(element !== null)
					element.innerHTML = "* Schedule Name needs to be between 3 and 64 characters";
				return;
			}
			else { 
				obj = scheduleShowEditEventCreateScheduleCheck(0, name);
				if(!obj.result) {
					bResult = false;
					element = document.getElementById("eventNameError");
					if(element !== null)
						element.innerHTML = "* " + obj.errMsg;
				}
				else {
					element = document.getElementById("eventNameError");
					if(element !== null)
						element.innerHTML = "";
				}
			}
		}
 	}
	catch {}
	return bResult;
}
function scheduleShowEditEventCheckIfValidDatapoint() {
	// if using datapoint type then verify this datapoint supports the specified datapoint type
	// if using presets then verify that this datapoint supports the specified preset
	var bResult = false, i, j;
	var element = document.getElementById("eventActionSelect");
	var table = document.getElementById("eventDatapointTable");
	var value, errMsg;

	var i;
	try {
		if((element !== null) && (table !== null)) {
			value = element.options[element.selectedIndex].text;
			
			if(value === "Set datapoint value") {
				element = document.getElementById("eventDatapointTypeSelect");
				if(element !== null) {
					value = element.options[element.selectedIndex].text;
					bResult = true;
					for(i=0;i < g_sceduleEventDatapointList.length; i++)
					{
						errMsg = "";
						if(typeof g_sceduleEventDatapointList[i].dpType === "undefined") {
							errMsg = "* Error: Can't find datapoint type";
							bResult = false;
						}
						else if(g_sceduleEventDatapointList[i].dpType !== value) {
								errMsg = "* Error: datapoint type is " +  g_sceduleEventDatapointList[i].dpType + ", but expected " + value;
								bResult = false;
						}
						element = document.getElementById("sch_dpErr__" + g_sceduleEventDatapointList[i].dpPath);
						if(element !== null) {
							element.innerHTML = errMsg;
						}
						
					}
				}
			}
			else {
				element = document.getElementById("eventPresets");
				if(element !== null) {
					value = element.options[element.selectedIndex].text;
					bResult = true;
					bFail = false;
					for(i=0;i < g_sceduleEventDatapointList.length; i++)
					{
						errMsg = "";
						if(g_sceduleEventDatapointList[i].presets !== null) {
							if(g_sceduleEventDatapointList[i].presets.map.length === 0)
								bResult = false;
							else {
								for(j=0;j < g_sceduleEventDatapointList[i].presets.map.length; i++)
								{
								}
							}
							if(g_sceduleEventDatapointList[i].presets !== null) {
								bResult = false;
							}
						}
						else 
							bResult = false;
						element = document.getElementById("sch_dpErr__" + g_sceduleEventDatapointList[i].dpPath);
						if(element !== null) {
							element.innerHTML = errMsg;
						}

					}
					element = document.getElementById("sch_dpErr__" + g_sceduleEventDatapointList[i].dpPath);
					if(element !== null) {
						if(bFail) {
							element.innerHTML = "* Error: Preset not supported";
						}
						else {
							element.innerHTML = "";
						}
					}
				}
			}
		}
	}
	catch {}
	return bResult;
}
function scheduleShowEditEventPresetChanged() {
	g_scheduleEventDlaIndex = 0;
	scheduleShowEditEventCheckPresets(0, "", []);
}
function scheduleShowEditEventOffsetType(mode) {
	//mode: 0=start, 1=end
	try {
		var element;
		var value;
		if(mode === 0) {
			element = document.getElementById("eventStartOffsetType");
			if(element !== null) {
				value = element.value;
				if(value === "No") {
					document.getElementById("eventStartSunsetDiv").style.display = "none"; 
					document.getElementById("eventStartingTimeDiv").style.visibility = "visible";
					//document.getElementById("eventStartTimezoneDiv").style.display = "flex";
					if(document.getElementById("eventEndOffsetType").value === "No")
						document.getElementById("evenAllDayDiv").style.visibility = "visible";
					else 
						document.getElementById("evenAllDayDiv").style.visibility = "hidden";
				}
				else {
					document.getElementById("eventStartSunsetDiv").style.display = "flex";
					document.getElementById("eventStartingTimeDiv").style.visibility = "hidden";
					document.getElementById("evenAllDayDiv").style.visibility = "hidden";
				}
	
			}
		}
		else if(mode === 1) {
			element = document.getElementById("eventEndOffsetType");
			if(element !== null) {
				value = element.value;
				if(value === "No") {
					document.getElementById("eventEndSunsetDiv").style.display = "none";
					document.getElementById("eventEndingTimeDiv").style.visibility = "visible";
					//document.getElementById("eventEndTimezoneDiv").style.display = "flex";
					if(document.getElementById("eventStartOffsetType").value === "No")
						document.getElementById("evenAllDayDiv").style.visibility = "visible";
					else 
						document.getElementById("evenAllDayDiv").style.visibility = "hidden";
				}
				else {
					document.getElementById("eventEndSunsetDiv").style.display = "flex";
					document.getElementById("eventEndingTimeDiv").style.visibility = "hidden";
					document.getElementById("evenAllDayDiv").style.visibility = "hidden";
					//document.getElementById("eventEndTimezoneDiv").style.display = "none";
				}
			}
		}
	}
	catch {}
}
function scheduleShowEditEventTableRemoveRow(n) {
	try {
		var table = document.getElementById("eventDatapointTable");
		var path, i;
		var rowIndex = -1;
		if(table !== null) {
			rowIndex = n.parentElement.parentElement.rowIndex;
			path = table.rows[rowIndex].cells[0].innerHTML;
			for(i=0; i < g_sceduleEventDatapointList.length; i++) // remove from list
			{
				if(path === g_sceduleEventDatapointList[i].dpPath )
				{
					g_sceduleEventDatapointList.splice(i, 1);
					break;
				}
			}
			table.deleteRow(rowIndex);
			document.getElementById("eventDatapointsCount").innerHTML = table.rows.length.toString();
		}
	}
	catch {}
	
}
function scheduleShowEditEventRpeatEnd() {
	var element = document.getElementById("eventRepeatEnd");
	var value;
	try {
		if(element !== null) {
			value = element.options[element.selectedIndex].text;
			element = document.getElementById("eventEndDateDiv");
			if(element !== null) {
				if(value === "Date") {
					element.style.display = "inline-block";
					document.getElementById("eventSpecificRepeatDiv").style.display = "none";
				}
				else if(value === "Repeat count") {
					element.style.display = "none";
					document.getElementById("eventSpecificRepeatDiv").style.display = "inline-block";
				}
				else {
					element.style.display = "none";
					document.getElementById("eventSpecificRepeatDiv").style.display = "none";
				}
			}
		}
	}
	catch {}
}
function scheduleShowEditEventRepeatType() {
	var element = document.getElementById("eventRepeatType");
	var value;
	try {
		if(element !== null) {
			value = element.options[element.selectedIndex].text;
			if(value === "No Repeat") 
				document.getElementById("eventEndRepeatDiv").style.visibility = "hidden";
			else 
				document.getElementById("eventEndRepeatDiv").style.visibility = "visible";
			
			element = document.getElementById("eventRepeatOptionDiv");
			if(element !== null) {
				//if(value !== "None") 
				if(value !== "No Repeat") 
					element.style.display = "inline-block";
				else 
					element.style.display = "none";
				document.getElementById("eventDaysCheckbox").style.display = "none";
				document.getElementById("eventMonthByDayOfMonth").style.display = "none";
				document.getElementById("eventMonthByDayOfWeek").style.display = "none";
				document.getElementById("eventYearByMonthDay").style.display = "none";
				document.getElementById("eventYearByMonthWeekDay").style.display = "none";
				if(value === "Weekly") 
					document.getElementById("eventDaysCheckbox").style.display = "inline-block";
				else if(value === "Month by day of Month") 
					document.getElementById("eventMonthByDayOfMonth").style.display = "inline-block";
				else if(value === "Month by day of Week") 
					document.getElementById("eventMonthByDayOfWeek").style.display = "inline-block";
				else if(value === "Year by month and day") 
					document.getElementById("eventYearByMonthDay").style.display = "inline-block";
				else if(value === "Year by month, week and day") 
					document.getElementById("eventYearByMonthWeekDay").style.display = "flex";
			}
		}
	}
	catch {}
	
		
}
function scheduleShowEditEventActionChanged() {
	var element = document.getElementById("eventActionSelect");
	var value;
	try {
		if(element !== null) {
			value = element.options[element.selectedIndex].text;
			element = document.getElementById("eventValueDiv");
			if(element !== null) {
				if(value === "Set datapoint value") {
					element.style.display = "inline-block";
					document.getElementById("eventPresetDiv").style.display = "none";
					document.getElementById("eventDatapointType").style.display = "inline-block";
				}
				else {
					element.style.display = "none";
					document.getElementById("eventPresetDiv").style.display = "inline-block";
					document.getElementById("eventDatapointType").style.display = "none";
				}
				scheduleShowEditEventFullCheck(2);
			}
		}
	}
	catch {}
}
function scheduleShowEditEventGetDatapointsResponse(mode, requestUrl,json) {
	try {
		var url,obj,i;
		for(i=0; i < json.length; i++)
		{
			obj = {};
			obj.dpPath = json[i].deviceName + "/" + json[i].blockName + "/" + json[i].blockIndex + "/" + json[i].name;
			obj.dpProgrammaticPath = json[i].deviceName + "/" + json[i].blockName + "/" + json[i].blockIndex + "/" + json[i].datapointName;
			obj.dpQualifier = json[i].dpQualifier;
			obj.blockPath = json[i].blockName + "/" + json[i].blockIndex + "/" + json[i].datapointName;
			obj.blockName = json[i].blockName;
			obj.blockIndex = json[i].blockIndex;
			obj.datapointName = json[i].datapointName;
			obj.dpType = json[i].type;
			g_sceduleEventDatapointList.push(obj);
		}
		url = "https://" + location.host + "/iap/dp/presets/names";
		requestGetData(mode, url, scheduleShowEditEventGetPresetsResponse, scheduleShowEditEventGetPresetsFailCallback); // get Device list
	}
	catch {
	}
}
function scheduleShowEditEventGetDatapointsFailCallback(mode, requestUrl,json) {
	try {
		var url;

		url = "https://" + location.host + "/iap/dp/presets/names";
		requestGetData(mode, url, scheduleShowEditEventGetPresetsResponse, scheduleShowEditEventGetPresetsFailCallback); // get Device list
	}
	catch {
	}
}
function scheduleShowEditEventGetPresetsResponse(mode, requestUrl, json) {
	var url;
	if(!g_bScheduleEventInProgress)
		return;
	try {
		g_scheduleEventsPresetList = json;
		
		url = "https://" + location.host + "/iap/dp/favorites";
		requestGetData(mode, url, scheduleShowEditEventGetFavoritesResponse, scheduleShowEditEventGetFavoritesFailCallback); 
	}
	catch {}

}
function scheduleShowEditEventGetPresetsFailCallback(mode, requestUrl, json) {
	var url;
	if(!g_bScheduleEventInProgress)
		return;
	try {
		
		url = "https://" + location.host + "/iap/dp/favorites";
		requestGetData(mode, url, scheduleShowEditEventGetFavoritesResponse, scheduleShowEditEventGetFavoritesFailCallback); 
	}
	catch {}
}
function scheduleShowEditEventGetFavoritesResponse(mode, requestUrl, json) {
	var url;
	if(!g_bScheduleEventInProgress)
		return;
	try {
		g_favoritesList = json;
		url = "https://" + location.host + "/iap/dp/types?datapointsPresense=true";
		requestGetData(mode, url, scheduleShowEditEventGetDpTypesResponse, scheduleShowEditEventGetDpTypesFailCallback); 
	}
	catch{}
}
function scheduleShowEditEventGetFavoritesFailCallback(mode, requestUrl, json) {
	var url;
	if(!g_bScheduleEventInProgress)
		return;
	try {
		
		url = "https://" + location.host + "/iap/dp/types?datapointsPresense=true";
		requestGetData(mode, url, scheduleShowEditEventGetDpTypesResponse, scheduleShowEditEventGetDpTypesFailCallback); 
	}
	catch{}
}
function scheduleShowEditEventGetDpTypesResponse(mode, requestUrl, json) {

	if(!g_bScheduleEventInProgress)
		return;
	try{
		g_dpTypesAvailableList = json;
		scheduleShowEditEvent1(mode.mode, mode.scheduleView, mode.scheduleId, mode.date, mode.time)
	}
	catch {}

}
function scheduleShowEditEventGetDpTypesFailCallback(mode, requestUrl, json) {
	if(!g_bScheduleEventInProgress)
		return;
	try{
		scheduleShowEditEvent1(mode.mode, mode.scheduleView, mode.scheduleId, mode.date, mode.time)
	}
	catch {}
}
function scheduleColorPalette(color) {

}
function scheduleShowScheduleList(mode, date) {
	scheduleShowScheduleList1(mode, date, "",[]);
}
function scheduleShowScheduleList1(mode, date, pathname,list) {
	// shows a table of schedule events either all or for a specific datapoint
	
	// use planningDiv
	var element, menuButton, menuContent = "", paneContent = "", i, iPtr, iPtr1, bContinue;
	var startDate, endDate;
	//var currentDate, currentDateMs, tempObj, i, list=[], list1 = [], items;
	var currentDate, currentDateMs, tempObj, i, list1 = [], items;
	var x,y,offsets, menuDivYOffset = 100;
	var sTemp;
	var tblName = "scheduleListTable"
	var d = new Date();
	var dateStr = d.getFullYear() + "-" + (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0); 
	var todayDate, todayDateMs;
	var endDateMs;
	var iTemp, status, iCols = -1;
	var bInit = true;
	
	try {
		//todayDate = new Date(dateStr);  //"new Date() and new Date("yyyy-mm-dd") do no give the same millisecond count
		todayDateMs = new Date(dateStr.replace(/\-/g, "/")).getTime(); // convert todayDateMs to beginning of day the same as new Date("yyyy-mm-dd")
		
		currentDateMs = Date.parse(date);
		//alert(currentDate);
		//currentDateMs = currentDate.getTime();

		if(mode >= 10) {
			bInit = false;
			mode -= 10;
		}

		if(bInit) {
			element = document.getElementById("planningDiv");
			menuButton = document.getElementById("calendarContainerId");
			if((menuButton === null) || (element === null))
				return;

			offsets = menuButton.getBoundingClientRect(); 
			x = offsets.x + window.pageXOffset; // takes into account viewport (scrolling)
			y = offsets.y + window.pageYOffset; // takes into account viewport (scrolling)
			element.style.left = x.toString() + "px";
			element.style.top = y.toString() + "px";
			element.innerHTML = menuContent;
			element.className = "menuDivDpValueShow";  // doesn't currently guaranty that menu is shown in viewport
			element.style.zIndex = 29;
			g_bInoreMouseClick = true;
			//document.addEventListener("click", menuMouseCancel);
			//document.addEventListener("click", function() {menuMouseCancel(event);});
			menuOverlayDivShow(1, null);
			menuContent = "<div class=\"menuWhiteBackgroundDiv\"><div class=\"menuDivBorder\">";
			menuContent += "<div>";
			menuContent += "<div class=\"menuDivName\" style=\"width:100%\">";
			if((mode === 0) || (mode=== 1)) 
				menuContent += "All Events:"
			else {
				iPtr = pathname.indexOf("/");
				if(iPtr === -1)
					menuContent += pathname;
				else
					menuContent += pathname.substr(iPtr + 1);
			}
			menuContent += "<div style=\"display:inline-block;margin-left:50px\"><span style=\"display:inline-block;margin-left:15px;margin-right:5px;width:40px;background-color:pink;border: 1px solid black\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>Future event";
			menuContent += "<span style=\"display:inline-block;margin-left:15px;margin-right:5px;width:40px;background-color:lightgrey;border: 1px solid black\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>Expired event";
			menuContent += "</div>";

			menuContent += "<div style=\"display:inline-block;margin-left:50px\">";
			menuContent += "Display: <input type=\"radio\" id=\"scheduleShowScheduleListButtonCurrent\" name=\"scheduleShowScheduleListShowType\" onclick=\"scheduleShowScheduleListShowType("+ mode + ",'" + date + "','" + pathname + "')\" value=\"Value\"";
			if(g_iScheduleShowScheduleListShowType === 1) {
				menuContent += " checked";
				
			}
			menuContent += "><label for=\"Value\">Current</label>";
			menuContent += "<input type=\"radio\" id=\"scheduleShowScheduleListButtonFuture\" name=\"scheduleShowScheduleListShowType\" onclick=\"scheduleShowScheduleListShowType("+ mode + ",'"+ date + "','" + pathname + "')\"";
			if(g_iScheduleShowScheduleListShowType === 2) {
				menuContent += " checked";
				
			}
			menuContent += "><label>Future</label>";
			menuContent += "<input type=\"radio\" id=\"scheduleShowScheduleListButtonExpired\" name=\"scheduleShowScheduleListShowType\" onclick=\"scheduleShowScheduleListShowType("+ mode + ",'"+ date + "','" + pathname + "')\"";
			if(g_iScheduleShowScheduleListShowType === 3) {
				menuContent += " checked";
				
			}
			menuContent += "><label>Expired</label>";
			menuContent += "<input type=\"radio\" id=\"scheduleShowScheduleListButtonAll\" name=\"scheduleShowScheduleListShowType\" onclick=\"scheduleShowScheduleListShowType("+ mode + ",'"+ date + "','" + pathname + "')\"";
			if(g_iScheduleShowScheduleListShowType === 0) {
				menuContent += " checked";
				
			}
			menuContent += "><label>All</label>";
			menuContent += "</div>";

			menuContent +="<div style=\"margin-left:50px;margin-right:10px;float:right\"><button  onclick=\"menuScheduleListDiv()\">X</button></div>";
			menuContent += "</div>";
			if(pathname === "") {
				menuContent += "<br>";
				menuContent += "<div style=\"display:flex;margin-top:20px\">"
				menuContent += "Device Name: <input id=\"scheduleShowScheduleList1_DeviceName\" class=\"scheduleFilterInput\" value=\"\" size=\"30\">";
				menuContent += "<button class=\"scheduleFilterClearButton\" onclick=\"scheduleShowScheduleList1ClearFilter(" + mode + ",1,'" + date + "')\">X</button>";
				menuContent += "Block Name: <input id=\"scheduleShowScheduleList1_BlockName\" class=\"scheduleFilterInput\" value=\"\" size=\"15\">";
				menuContent += "<button class=\"scheduleFilterClearButton\" onclick=\"scheduleShowScheduleList1ClearFilter(" + mode + ",2,'" + date + "')\">X</button>";
				menuContent += "Block Index: <input id=\"scheduleShowScheduleList1_BlockIndex\" class=\"scheduleFilterInput\" value=\"\" size=\"4\">";
				menuContent += "<button class=\"scheduleFilterClearButton\" onclick=\"scheduleShowScheduleList1ClearFilter(" + mode + ",3),'" + date + "'\">X</button>";
				menuContent += "Datapoint: <input id=\"scheduleShowScheduleList1_Datapoint\" class=\"scheduleFilterInput\" value=\"\" size=\"30\">";
				menuContent += "<button class=\"scheduleFilterClearButton\" onclick=\"scheduleShowScheduleList1ClearFilter(" + mode + ",4,'" + date + "')\">X</button>";
				menuContent += "<button onclick=\"scheduleShowScheduleList1Search(" + mode + ",'" + date + "')\">Search</button>"
				menuContent += "<button onclick=\"scheduleShowScheduleList1ClearFilter(" + mode + ",0,'" + date + "')\">Clear All</button>"
				menuContent += "</div>";
			}
				//menuContent += "<br><div style=\"margin-top:20px\">Datapoint: <input id=\"scheduleListDatapointInput\" placeholder=\"device1/LightSenor/0/Light\" value=\"\" size=\"60\"></div>"
			menuContent += "<div id=\"scheduleListTableDiv\"></div>";
			element.innerHTML = menuContent;
			if(pathname !== "") {
				element = document.getElementById("scheduleListDatapointInput");
				if(element !== null)
					element.value = pathname;
			}
		}	
		if(schedulesList.length === 0) {
			element = document.getElementById("scheduleListTableDiv");
			if(element !== null) {
				element.innerHTML = "<br><br>No Schedules found<br><br>";
			}
		}
		else {
			element = document.getElementById("scheduleListDatapointInput");
			if(element !== null) {
				try {
					
					sTemp = element.value;
					sTemp.trim();
					if(sTemp !== "") {
						items = sTemp.split()
						pathname = "";
						if(items.length === 4) {
							for(i=0; i< items.length; i++)
							{
								if(i !== 0)
									pathname += "/"
								pathname += items[i].trim();
							}
							
						}
						if(pathname === "") {
							showAlertDialog(0,"Warning: Invalid pathname- you must specify full path\r\nexample:\r\n\tThermostat1/TempSensor/0/Temperature");
						}
					}
					
				}
				catch 
				{
					pathname = "";
				}
			}

			element = document.getElementById("scheduleListTableDiv");
			
			// create list based on g_iScheduleShowScheduleListShowType settings



			if(element !== null) {
			
				
				iCols ++;
				paneContent = "<tHead><tr><th onclick=\"sortTable1('" + tblName + "'," + iCols.toString() + "')\">#</th>";
				//paneContent += "<th>Menu</th>";
				iCols ++;
				paneContent += "<th onclick=\"sortTable1('" + tblName + "'," + iCols.toString() + "')\">Schedule</th>";
				iCols ++;
				paneContent += "<th onclick=\"sortTable1('" + tblName + "'," + iCols.toString() + "')\">Color</th>";
				iCols ++;
				paneContent += "<th onclick=\"sortTable1('" + tblName + "'," + iCols.toString() + "')\">StartTime</th><th>EndTime</th>";
				iCols ++;
				paneContent += "<th onclick=\"sortTable1('" + tblName + "'," + iCols.toString() + "')\">Value</th>";
				iCols ++;
				paneContent += "<th onclick=\"sortTable1('" + tblName + "'," + iCols.toString() + "')\">Priority</th>";
				iCols ++;
				paneContent += "<th onclick=\"sortTable1('" + tblName + "'," + iCols.toString() + "')\">Type</th>";
				iCols ++;
				paneContent += "<th onclick=\"sortTable1('" + tblName + "'," + iCols.toString() + "')\">Datapoints</th>";
				iCols ++;
				paneContent += "<th onclick=\"sortTable1('" + tblName + "'," + iCols.toString() + "')\">Datapoint Type</th>";
				iCols ++;
				paneContent += "<th onclick=\"sortTable1('" + tblName + "'," + iCols.toString() + "')\">StartDate</th>";
				iCols ++;
				paneContent += "<th onclick=\"sortTable1('" + tblName + "'," + iCols.toString() + "')\">EndDate</th>";  
				iCols ++;
				paneContent += "<th onclick=\"sortTable1('" + tblName + "'," + iCols.toString() + "')\">Repeat Count</th>";  
				iCols ++;
				paneContent += "<th onclick=\"sortTable1('" + tblName + "'," + iCols.toString() + "')\">Status</th>";
				
				//paneContent += "<th>Description</th><th>id</th><th>DP XIF Path</th>"; 
				paneContent += "</tHead</tr>"
				if(list.length === 0)
					list = JSON.parse(JSON.stringify(schedulesList));
				/* not sure if this is used
				list = [];
				if(mode === 0)
					list = JSON.parse(JSON.stringify(schedulesList));
				else {
					// get events for specified date
					for(i= 0; i < schedulesList.length; i ++)
					{
						
						schedulesList[i].startingDateMs = Date.parse(schedulesList[i].startingDate);
						
						//if(todayDateMs)
						if(schedulesList[i].startingDateMs < currentDateMs) {
							bContinue = false;
							if(typeof schedulesList[i].endDate === "undefined") {
								bContinue = true;
								schedulesList[i].endingDateMs = -1;
							}
							else {
								schedulesList[i].endingDateMs = Date.parse(schedulesList[i].endingDate);
								if(currentDateMs < schedulesList[i].endingDateMs) {
									bContinue = true;
								}
							}
							if(bContinue) {
								list.push(JSON.parse(JSON.stringify(schedulesList[i])));
							}
						}

					}
				}
				*/
				//create list based on display type
				
				if(g_iScheduleShowScheduleListShowType !== 0) {
					// only show specific type
					list1 = JSON.parse(JSON.stringify(list));
					list = [];
					for(i= 0; i < list1.length; i ++)
					{
						iTemp = new Date(list1[i].start.replace(/\-/g, "/")).getTime();
						status = "";
						if(iTemp > todayDateMs) {
							if(g_iScheduleShowScheduleListShowType === 2)
								list.push(JSON.parse(JSON.stringify(list1[i])));
						}
						else if (typeof list1[i].end === "undefined"){
							if(g_iScheduleShowScheduleListShowType === 1)
								list.push(JSON.parse(JSON.stringify(list1[i])));
						}
						else if (list1[i].end === "NONE") {
							if(g_iScheduleShowScheduleListShowType === 1)
								list.push(JSON.parse(JSON.stringify(list1[i])));
						} 
						else {
							iTemp = new Date(list1[i].end.replace(/\-/g, "/")).getTime();
							if(iTemp < todayDateMs) {
								if(g_iScheduleShowScheduleListShowType === 3)
									list.push(JSON.parse(JSON.stringify(list1[i])));
							}
							else if(g_iScheduleShowScheduleListShowType === 1)
								list.push(JSON.parse(JSON.stringify(list1[i])));
						}
					}
				}

				// reorder based on time
				bContinue = true;
				while(bContinue) {
					bContinue = false;
					for(i= 0; i < (list.length - 1); i ++)
					{
						if(list[i].startingDateMs > list[i + 1].startingDateMs) {
							tempObj = {};
							tempObj = JSON.parse(JSON.stringify(list[i]));
							list[i] = JSON.parse(JSON.stringify(list[i + 1]));
							list[i + 1] = tempObj;
							bContinue = true;
						}
					}
				}

				for(i= 0; i < list.length; i ++)
				{
					if(mode < 2)
						bContinue = true;
					if(bContinue) {
						// 
					}
					if(bContinue) {
						paneContent += "<tr";
						iTemp = new Date(list[i].start.replace(/\-/g, "/")).getTime();

						status = "";
						if(iTemp > todayDateMs) {
							paneContent += " style=\"background-color:pink\"";
							status = "future";
						}
						else if (typeof list[i].end === "undefined"){

						}
						else if (list[i].end === "NONE"){

						}
						else {
							iTemp = new Date(list[i].end.replace(/\-/g, "/")).getTime();
							if(iTemp  < todayDateMs) {
								paneContent += " style=\"background-color:lightgrey\"";
								status = "expired";
							}
						}
						paneContent += "><td>" + (i + 1).toString() + "</td>"; 
						//paneContent += "<td><button id=\"dpDlaMenu_" + list[i].id + "\" onclick=\"menuDla1(4, event, '" + list[i].name + "," + list[i].id + "', '" + list[i].dpListStr + "','"+ list[i].xifDpListStr + "')\">...</button></td>";  //8888
						paneContent += "<td>" + list[i].name + "</td><td style=\"background-color:" + list[i].color + "\"></td><td class=\"showAllEventsTd\">";
						iPtr = list[i].startingTime.indexOf("R");
						iPtr1 = list[i].startingTime.indexOf("S");
						if((iPtr === -1) && (iPtr1 === -1))
							paneContent += list[i].startingTime
						else if(iPtr === 0)
							paneContent += list[i].startingTime.substr(1) + " After Sunrise";
						else if(iPtr > 0)
							paneContent += list[i].startingTime.substr(0, list[i].startingTime.length - 1) + " Before Sunrise";
						else if(iPtr1 === 0)
							paneContent += list[i].startingTime.substr(1) + " After Sunset";
						else if(iPtr1 > 0)
							paneContent += list[i].startingTime.substr(0, list[i].startingTime.length - 1) + " Before Sunset";
						paneContent += "</td>";
						
						paneContent += "<td class=\"showAllEventsTd\">";
						if(typeof list[i].endingTime === "undefined") {
							// 24 hour all day event so no endingTime
							if(typeof list[i].metadata.allDay !== "undefined") 
								paneContent += "All day";
						}
						else {
							
							iPtr = list[i].endingTime.indexOf("R");
							iPtr1 = list[i].endingTime.indexOf("S");
							if((iPtr === -1) && (iPtr1 === -1))
								paneContent += list[i].endingTime
							else if(iPtr === 0)
								paneContent += list[i].endingTime.substr(1) + " After Sunrise";
							else if(iPtr > 0)
								paneContent += list[i].endingTime.substr(0, list[i].endingTime.length - 1) + " Before Sunrise";
							else if(iPtr1 === 0)
								paneContent += list[i].endingTime.substr(1) + " After Sunset";
							else if(iPtr1 > 0)
								paneContent += list[i].endingTime.substr(0, list[i].endingTime.length - 1) + " Before Sunset";
							
						}
						paneContent += "</td>";
						
						paneContent += "<td class=\"tdValue\"><div class=\"tdValueDiv\">";
						if(typeof list[i].presetName === "undefined") {
							if(typeof list[i].value !== "undefined")
								paneContent += list[i].value;
							paneContent += "</div></td>";
						}
						else 
							paneContent += list[i].presetName + "</div></td>";
						paneContent += "<td>" + list[i].priority + "</td>";
						paneContent += "<td class=\"tdValue\"><div class=\"tdValueDiv\">";
						

						if(list[i].browserType === "CUSTOM_WEEKLY")
							paneContent += "Every " + daysList[list[i].metadata.dayOfWeek];
						else if(list[i].browserType === "CUSTOM_MONTHLY") {
							if(list[i].metadata.customMonthlyOption === "DAY_OF_THE_MONTH") {
								if(list[i].metadata.monthOption === -1)
									paneContent += "Every Month on day " + list[i].metadata.day;
								else 
									paneContent += "Every " + monthsList[list[i].metadata.monthOption] + " on day " + list[i].metadata.day;
								
							}
							else if(list[i].metadata.customMonthlyOption === "WEEK_NUMBER_AND_DAY_OF_WEEK") {
								if(list[i].metadata.monthOption === -1)
									paneContent += "Every Month every " + daysList[list[i].metadata.dayOfWeek];
								else 
									paneContent += "Every " + monthsList[list[i].metadata.monthOption] + " every " + daysList[list[i].metadata.dayOfWeek];
								
							}
						}
						else
							paneContent +=  list[i].browserType
						paneContent +=  "</div></td>";
						paneContent += "<td><div style=\"white-space: nowrap;max-height:200px;overflow:auto\">" + list[i].browserDpList + "</div></td>";
						if(typeof list[i].datapointTypeRef !== "undefined")
							paneContent += "<td>" + list[i].datapointTypeRef + "</td>";
						else if(typeof list[i].presetName !== "undefined")
							paneContent += "<td>" + list[i].presetName + "</td>";
						else
							paneContent += "<td></td>";
						//paneContent += "<td style=\"white-space: nowrap;\">" + list[i].browserDuration + "</td>";
						
						paneContent += "<td >";
						items = list[i].start.split("-"); // need to format for us date format
						if(items.length >= 3) 
							paneContent += items[1] + "/" + items[2] + "/" + items[0];
						else
							paneContent += list[i].start
						paneContent += "</td>";
						if(list[i].metadata.endDateType === "NONE")
							paneContent += "<td ></td>";
						else if(list[i].metadata.repeatOption === "NO_REPEAT")
							paneContent += "<td >single day</td>";
						else {
							paneContent += "<td >";
							items = list[i].start.split("-"); // need to format for us date format
							if(items.length >= 3) 
								paneContent += items[1] + "/" + items[2] + "/" + items[0];
							else
								paneContent += list[i].end;
							paneContent += "</td>";

						}
						if(typeof list[i].metadata.repeatsCount === "undefined")
							paneContent += "<td></td>";
						else
							paneContent += "<td>"+ list[i].metadata.repeatsCount + "</td>";
						paneContent += "<td>"+ status + "</td>";
						//paneContent += "<td>" + list[i].description + "</td><td>" + slist[i].id + "</td>";
						//paneContent += "<td><div>" + list[i].browserXifDpList + "</div></td>";
						paneContent += "</tr>";
					}
					
				} //for(i= 0; 
				
				paneContent = "<br><table id=\"" + tblName + "\" class=\"tableScheduleList\">" + paneContent + "</tbody></table></div></div>";
				paneContent += addTopButton();
				element.innerHTML = paneContent;
			}	
		}
		
	}
	catch{
		showAlertDialog(0,"Error: Can't show schedule list");
	}
}
function scheduleShowScheduleList1ClearFilter(mode, index,  date) {
	var element;
	try {
		if((index === 0) || (index === 1)) {
			element = document.getElementById("scheduleShowScheduleList1_DeviceName");
			if(element !== null) {
				element.value = "";
			}
		}
		if((index === 0) || (index === 2)) {
			element = document.getElementById("scheduleShowScheduleList1_BlockName");
			if(element !== null) {
				element.value = "";
			}
		}
		if((index === 0) || (index === 3)) {
			element = document.getElementById("scheduleShowScheduleList1_BlockIndex");
			if(element !== null) {
				element.value = "";
			}
		}
		if((index === 0) || (index === 4)) {
			element = document.getElementById("scheduleShowScheduleList1_Datapoint");
			if(element !== null) {
				element.value = "";
			}
		}
		if((index === 0) || (index === 5)) {
			element = document.getElementById("scheduleShowScheduleList1_label");
			if(element !== null) {
				element.value = "";
			}
		}
		if(index === 0) {
			scheduleShowScheduleList1((mode + 10), date, "",[]);
		}
		
	}
	catch {}
}
function scheduleShowScheduleList1Search(mode, date) {
	var items;
	var bContinue = true, schDpItems;
	var list = [], dpList1 = [];
	var items = ["","","",""], items1;
	try {
		element = document.getElementById("scheduleShowScheduleList1_DeviceName");
		if(element !== null) {
			items[0] = element.value.trim();
			if(items[0] !== "")
				items[0] = items[0].toLocaleLowerCase();
		}
		element = document.getElementById("scheduleShowScheduleList1_BlockName");
		if(element !== null) {
			items[1] = element.value.trim();
			if(items[1] !== "")
				items[1] = items[2].toLocaleLowerCase();
			
		}
		
		element = document.getElementById("scheduleShowScheduleList1_BlockIndex");
		if(element !== null) {
			items[2] = element.value.trim();
			if(items[2] !== "")
				items[2] = items[2].toLocaleLowerCase();
		}
		
		element = document.getElementById("scheduleShowScheduleList1_Datapoint");
		if(element !== null) {
			items[3] = element.value.trim();
			if(items[3] !== "")
				items[3] = items[3].toLocaleLowerCase();
		}
		element = document.getElementById("scheduleListTableDiv");
		if(element !== null)
			element.innerHTML = "";
		// determine if datapoint name or dp have full path.  If so use it.
		
		if(items[0] !== "") {
			if(items[0].indexOf("/") !== -1) {

				bContinue = false;
				items1 = items[0].split("/");
				
				for(i=0; i < items.length; i++)
				{
					items[i] = items1[i].trim();
					
				}
			}
		}
		if((bContinue) && (items[3] !== "")) {
			if(items[3].indexOf("/") !== -1) {

				bContinue = false;
				items1 = items[3].split("/");
				
				for(i=0; i < items.length; i++)
				{
					items[i] = items1[i].trim();
					
				}
			}
		}

		for(j=0; j < schedulesList.length; j++)
		{
			dpList1 = schedulesList[j].dpListStr.split(",");
			for(k=0; k < dpList1.length; k++)
			{
				if(dpList1[k] !== "") {
					schDpItems = dpList1[k].split("/");
					z = 1;
					for(i=0; i < 4; i++)
					{
						if((items[i] === "") || (items[i] === "*")) {

						}
						else {
							if(schDpItems[i].toLowerCase().indexOf(items[i]) === -1) {
								z = 0;
								break;
							}
							
						}
					}
					if(z === 1) {
						list.push(JSON.parse(JSON.stringify(schedulesList[j]))) 
						break; //only need to list once
					}
				}
			}
		}
		
		//

		if(list.length > 0) {
			scheduleShowScheduleList1((mode + 10), date, "",list);
		}

	}
	catch {}
}
function scheduleShowScheduleListShowType(mode, date, pathname) {
	try {
		var bShowValue = false;
		var bShowPriority = false;
		var element;
		if(document.getElementById("scheduleShowScheduleListButtonCurrent").checked) {
			g_iScheduleShowScheduleListShowType = 1;
		}
		else if(document.getElementById("scheduleShowScheduleListButtonFuture").checked) {
			g_iScheduleShowScheduleListShowType = 2;
		}
		else if(document.getElementById("scheduleShowScheduleListButtonExpired").checked) {
			g_iScheduleShowScheduleListShowType = 3;
		}
		else if(document.getElementById("scheduleShowScheduleListButtonAll").checked) {
			g_iScheduleShowScheduleListShowType = 0;
		}

		scheduleShowScheduleList1((mode + 10), date, pathname,[])

		
		
	}
	catch {}
}
function sunriseSunsetTimesDialog() {
	var element = document.getElementById("planningPaneDetails")
	var offsets, x, y, sTemp, currentDate;
	
	try {
		
		
		if(element !== null) {

			offsets = element.getBoundingClientRect(); 
			x = offsets.x + window.pageXOffset; // takes into account viewport (scrolling)
			y = offsets.y + window.pageYOffset; // takes into account viewport (scrolling)
		
			element = document.getElementById("planningDiv");
			if(element != null) {
				
				
				element.className = "showSunriseSunsetDiv";
				element.style.left = x.toString() + "px";
				element.style.top = y.toString() + "px";
				currentDate = g_calendarDate.getFullYear() + "-" + ( g_calendarDate.getMonth() + 1).toString().padStart(2,"0") + "-" + g_calendarDate.getDate().toString().padStart(2,"0");
				sTemp = "<div class=\"menuWhiteBackgroundDiv\"><div class=\"showSunriseSunsetBorder\">" 
				sTemp += "Sunrise/Sunset Times [See notes below]<button  style=\"float:right;\" onclick=\"planningMenuCancel()\">X</button><br><br>";
				sTemp += "Starting Date: <input type=\"date\" id=\"sunriseSunsetDate\" value=\"" + currentDate + "\" onchange=\"sunriseSunsetTimesDate()\">";
				sTemp += "<button style=\"margin-left:30px;background-color:orange\" onclick=\"sunriseSunsetTimesDateToday()\">Today</button><br><br>";
				sTemp += "<div id=\"sunriseSunsetDiv\"></div>";
				sTemp += "</div></div>";
				sTemp += addTopButton();
				element.innerHTML = sTemp;
				sunriseSunsetTimesDate()
				menuOverlayDivShow(1, null);
			}
		}
	}
	catch {}
}
function sunriseSunsetTimesDate() {
	var element = document.getElementById("sunriseSunsetDate");
	var element1 = document.getElementById("sunriseSunsetDiv");
	var offsets, x, y, sTemp, sTemp1, sTemp2, sTemp3;
	var date = "";
	var d;
	var dlStartDate = "", dlEndDate = "", dlStartDateStr = "", dlEndDateStr = "",janTimeOffset;
	
	try {
		// determine

		if((element === null) || (element1 === null))
			return;
		currentDate = element.value;

		today = new Date(currentDate.replace(/\-/g,"/"));

		d = new Date(today.getFullYear(), 0, 1);
		d.setHours(d.getHours() + 3);
		janTimeOffset = d.getTimezoneOffset();
		
		for(i = 1; i < 365; i++)
		{
			if(dlStartDate === "") {
				if(d.getTimezoneOffset() !== janTimeOffset) {
					dlStartDate = d.getFullYear() + "/" + (d.getMonth() + 1).toString().padStart(2,"0") + "/" + d.getDate().toString().padStart(2,"0");
					dlStartDateStr = d.toLocaleDateString();
				}
			}
			else {
				if(dlEndDate === "") {
					if(d.getTimezoneOffset() === janTimeOffset) {
						dlEndDate = d.getFullYear() + "/" + (d.getMonth() + 1).toString().padStart(2,"0") + "/" + d.getDate().toString().padStart(2,"0");
						dlEndDateStr = d.toLocaleDateString(); 
						break;
					}
				}
			}
			d.setDate(d.getDate() + 1);
			
		}
		sTemp = "DayLight: Start Date = " + dlStartDateStr + ", End Date = " + dlEndDateStr + "<br><br>";
		

		sTemp += "<table><thead><tr><th>Date</th><th>Sunrise</th><th>Sunset</th>";
		if(g_b12hourClock) {
			sTemp += "<th>Sunrise (24 hour)</th><th>Sunset (24 hour)</th>";
		}
		sTemp += "</tr></thead><tbdody>";
		d = new Date(currentDate.replace(/\-/g,"/"));
		today = new Date();
		today = today.getFullYear() + "/" + ( today.getMonth() + 1).toString().padStart(2,"0") + "/" + today.getDate().toString().padStart(2,"0");
		for(i = 0; i < 31; i++)
		{
			currentDate = d.getFullYear() + "/" + ( d.getMonth() + 1).toString().padStart(2,"0") + "/" + d.getDate().toString().padStart(2,"0");
			
			solar = new solarCalc(d,g_dLatitude, g_dLongitude);
			//sunrise =  (new Date(solar.sunrise).toLocaleTimeString('en-GB'));
			//sunset = (new Date(solar.sunset).toLocaleTimeString('en-GB'));

			sTemp += "<tr";
			if(today === currentDate)
				sTemp += " style=\"background-color:orange\"";
			else if((currentDate === dlStartDate) || (currentDate === dlEndDate))
				sTemp += " style=\"background-color:yellow\"";
			sTemp += "><th>" + d.toLocaleDateString() + "</th>";
			sTemp1 = solar.sunrise.toLocaleTimeString();
			sTemp2 = solar.sunrise.toString();
			sTemp3 = solar.sunrise.toUTCString();
			sTemp += "<th>" + (new Date(solar.sunrise).toLocaleTimeString()) + "</th>";
			sTemp += "<th>" + (new Date(solar.sunset).toLocaleTimeString()) + "</th>";
			if(g_b12hourClock) {
				sTemp += "<th>" + (new Date(solar.sunrise).toLocaleTimeString('en-GB')) + "</th>";
				sTemp += "<th>" + (new Date(solar.sunset).toLocaleTimeString('en-GB')) + "</th>";
				
			}
			sTemp += "</tr>";
			d.setDate(d.getDate() + 1);
		}
		sTemp += "</tbdody></table>";
		sTemp += "<div style=\"width:450px\">Note:";
		sTemp += "<br>1. Only use if PC and SmartServer IoT in same timezone.";
		sTemp += "<br>2. These times may not be the same as the SmartServer Scheduler times (they may be off by a couple of minutes).";
		sTemp += "<br>3. The SmartServer Sunrise and Sunset times are calculated using Civil Dawn and Civil Dusk with a 6&deg; elevation.";
		sTemp += " Use the Schedule event sunrise/sunset offsets to make any corrections in times";
		sTemp += "<br>4. See <a href=\"https://www.timeanddate.com\" target=\"_blank\">timeanddate.com</a> for more accurate times. Go to \"Sun & Moon > Sun Calculator \" and enter place";
		sTemp += "</div>";
		
/*
		d = new Date(currentDate.replace(/\-/g,"/"));
		today = new Date();
		today = today.getFullYear() + "/" + ( today.getMonth() + 1).toString().padStart(2,"0") + "/" + today.getDate().toString().padStart(2,"0");



		for(i = 0; i < 31; i++)
		{
			currentDate = d.getFullYear() + "/" + ( d.getMonth() + 1).toString().padStart(2,"0") + "/" + d.getDate().toString().padStart(2,"0");
			
			solar = new solarCalc(d,g_dLatitude, g_dLongitude);
			//sunrise =  (new Date(solar.sunrise).toLocaleTimeString('en-GB'));
			//sunset = (new Date(solar.sunset).toLocaleTimeString('en-GB'));

			sTemp += "<tr";
			if(today === currentDate)
				sTemp += " style=\"background-color:orange\"";
			sTemp += "><th>" + d.toLocaleDateString() + "</th>";
			sTemp1 = solar.sunrise.toLocaleTimeString();
			sTemp2 = solar.sunrise.toString();
			sTemp3 = solar.sunrise.toUTCString();
			sTemp += "<th>" + (new Date(solar.sunrise).toLocaleTimeString()) + "</th>";
			sTemp += "<th>" + (new Date(solar.sunset).toLocaleTimeString()) + "</th>";
			if(g_b12hourClock) {
				sTemp += "<th>" + (new Date(solar.sunrise).toLocaleTimeString('en-GB')) + "</th>";
				sTemp += "<th>" + (new Date(solar.sunset).toLocaleTimeString('en-GB')) + "</th>";
				
			}
			sTemp += "</tr>";
			d.setDate(d.getDate() + 1);
		}

*/
		
		element1.innerHTML = sTemp;

	}
	catch {}
}
function sunriseSunsetTimesDateToday() {
	try {
		var d;
		var element = document.getElementById("sunriseSunsetDate");
		if(element !== null) {
			d = new Date();
			element.value = d.getFullYear() + "-" + ( d.getMonth() + 1).toString().padStart(2,"0") + "-" + d.getDate().toString().padStart(2,"0");
			sunriseSunsetTimesDate();
		}
	}
	catch {}
}