#!/bin/bash
# Copyright © 2022 Dialog Semiconductor
# This script is used to install the channel monitor service,  Run as root
. /usr/bin/apollo/apollo-utils.fcn
echo "Install channelMonitor service..."
echo "Scipt Version: 1.07"
echo "Supports 3 parameters: $1: [R|B|C]:, \$2: [0-1439] \$3: [0|1]"
echo "\$2 = 0 disables auto reboot or stack restarts.  If not zero use 60-1439 minutes after"
echo "midnight.  By default \$3 is 0 which means full reboot.  Use 1 to restart the Lon stack only"
echo "---------------------------------"
# 
ROUTERMODE=$1
RAWMODE=0
SCHDTM=0
RESTARTYPE=0

usage () {
    echo "Usage: $0 [R|B|C] [0-1439] [0|1]"
    exit 1
}
if [ "$EUID" -ne 0 ];then
   echo "This script must run as user root"
   exit 1
fi   
if [ "$#" -eq 0 ]
then
   ROUTERMODE="R"
   echo "Installing with channelMon service using repeater mode without scheduled reboot"
fi

read -p "Please enter the apollo users password: " PWD 
if [ -z "$PWD" ];then
   echo "Script will not run without and apollo user password."
   exit 1
fi
     
case "$ROUTERMODE" in
   (r|R)
      RAWMODE=0 ;;
   (b|B)
      RAWMODE=1 ;;   
   (c|C)
      RAWMODE=2 ;;
   (*) usage ;;    
esac
if [ -z "$2" ]; 
then
   SERVICE_ARGS="$RAWMODE 0 0"
else
   if [ -z "$3" ]; 
   then
      SERVICE_ARGS="$RAWMODE $2 0"
   else  
      SERVICE_ARGS="$RAWMODE $2 $3"
   fi      
fi
echo "Using router mode: $ROUTERMODE"
echo "Service Arguments: $SERVICE_ARGS"

APP_DIR="$APOLLO_DATA/apps"
A_SETUP="channelMonitor"
LOG_DIR="/media/sdcard/app_logdata"
if [ ! -d "$APP_DIR" ] || [ ! -d $APP_DIR/$A_SETUP ] 
then
   echo "Creating install directory $APP_DIR"
   mkdir -p "$APP_DIR/$A_SETUP"
   UPDATE=0
   [ ! -d "$LOG_DIR" ] && mkdir -p "$LOG_DIR"
   chown apollo:apollo "$LOG_DIR"
   chmod -R 775 "$LOG_DIR"
fi   
cp ./channelMonitorPackage.zip "$APP_DIR/$A_SETUP"
cd "$APP_DIR/$A_SETUP"
unzip -o ./channelMonitorPackage.zip
rm ./channelMonitorPackage.zip
supervisorctl stop channelMon
mv -f ./channelMon.conf /etc/supervisor/conf.d
chown apollo:apollo *.*
chmod -R 775 $APP_DIR
chmod 666 channelMonitor.js
chown root:apollo /etc/supervisor/conf.d/channelMon.conf
chmod 664 /etc/supervisor/conf.d/channelMon.conf
mv -f ./channelMon-ctl /usr/sbin
chmod 755 /usr/sbin/channelMon-ctl

echo "Moving resources to $APOLLO_DATA/dtp-files.d"
mv -f ./channelMon.zip $APOLLO_DATA/dtp-files.d
chown apollo:apollo $APOLLO_DATA/dtp-files.d/channelMon.zip
chmod 666 $APOLLO_DATA/dtp-files.d/channelMon.zip
mv -f ./ApolloDevXML_1_38.zip $APOLLO_DATA/dtp-files.d
chown apollo:apollo $APOLLO_DATA/dtp-files.d/ApolloDevXML_1_38.zip
chmod 666 $APOLLO_DATA/dtp-files.d/ApolloDevXML_1_38.zip
echo "Loading resources"
load_dtp_files $PWD
sleep 5
sed -i "s/channelMonitor.js.*/channelMonitor.js true $SERVICE_ARGS/g" /etc/supervisor/conf.d/channelMon.conf
sed -i "s/autostart=.*/autostart=true/g" /etc/supervisor/conf.d/channelMon.conf
echo "Starting services."
sleep 5
supervisorctl update channelMon
supervisorctl restart channelMon
echo "ChannelMon Service installed.  Allow 4 minutes for initial start."
cd ~
