#!/bin/bash
# Copyright © 2022 EnOcean Edge Inc
# This script is used to install the channel monitor service,  Run as root
. /usr/bin/apollo/apollo-utils.fcn
echo "Installing DCX manager and Group Controller services"
echo "Scipt Version: 1.04"
echo "---------------------------------"
# 
if [ "$EUID" -ne 0 ];then
    echo "Please run this script as root."
    exit 1
fi
read -p "Please provide the apollo user password: " PSW

APP_DIR="$APOLLO_DATA/apps"
A_SETUP="dcxMngr"
V4_FILE_MARKER="/usr/bin/smartserverctl"

if [ ! -d "$APP_DIR" ] || [ ! -d $APP_DIR/$A_SETUP ];
then
   echo "Creating install directory $APP_DIR"
   mkdir -p "$APP_DIR/$A_SETUP"
   chown -R apollo:apollo "$APP_DIR"
   UPDATE=0
fi   
cp -f ./DCXpackage.zip "$APP_DIR/$A_SETUP"
cd "$APP_DIR/$A_SETUP"
unzip -o ./DCXpackage.zip
rm ./DCXpackage.zip
chown apollo:apollo *.*
echo "Moving resources to $APOLLO_DATA/dtp-files.d"
mv -f ./DcxResources.dtp $APOLLO_DATA/dtp-files.d
chown apollo:apollo $APOLLO_DATA/dtp-files.d/DcxResources.dtp 
chmod 666 $APOLLO_DATA/dtp-files.d/DcxResources.dtp 
chmod -R 775 $APP_DIR
if [ ! -f "$V4_FILE_MARKER" ]; then
    echo "Using pre-4.0 service architecture"
    echo "Stopping the dcx and gc services.  You can ignore errors that may be reported by supervisorctl."
    supervisorctl stop dcx
    mv -f ./dcxMngr.conf /etc/supervisor/conf.d
    mv -f ./gc.conf /etc/supervisor/conf.d
    chmod 666 dcxMngr.js
    chmod 666 gc.js
    # chown root:apollo /etc/supervisor/conf.d/dcx.conf
    # chown root:apollo /etc/supervisor/conf.d/dcx.conf
    chmod 664 /etc/supervisor/conf.d/dcxMngr.conf
    chmod 664 /etc/supervisor/conf.d/gc.conf

    echo "Installing custom resources using apollo password: [$PSW]"
    # load_dtp_files $PSW
    dtp-loader https://$HOSTNAME apollo $PSW /var/apollo/data/dtp-files.d/DcxResources.dtp 
    sleep 30
    echo "Starting services."
    #sleep 30s
    supervisorctl update dcx
    supervisorctl update gc
    supervisorctl restart dcx
    supervisorctl restart gc
    rm *.service
else
    # Need to run services under systemctl 644 permissions on unit files.
    echo "Using 4.X services architecture."
    echo "Stopping the dcx and gc services.  You can ignore errors that may be reported by systemctl."
    systemctl stop dcx
    systemctl stop gc
    # 4.0 no longer uses http on port 8181
    dtp-loader https://$HOSTNAME apollo $PSW /var/apollo/data/dtp-files.d/DcxResources.dtp
    echo "Setting up service unit files"
    chmod 644 ./smartserver-dcx.service
    chmod 644 ./smartserver-gc.service
    chown root:root ./smartserver-dcx.service
    chown root:root ./smartserver-gc.service
    mv -f ./smartserver-dcx.service /lib/systemd/system/
    mv -f ./smartserver-gc.service /lib/systemd/system/
    sleep 2
    echo "Starting dcx and gc services"
    smartserverctl enable smartserver-dcx.service
    smartserverctl enable smartserver-gc.service
    smartserverctl start dcx
    smartserverctl start gc
    rm *.conf
fi    
echo "The DCX Manager (dcx) and GroupContorller (gc) services are installed."  
echo "Enable mqtt port: 1883 on eth1"
ufw allow in on eth1 to any port 1883 proto tcp
cd ~
