/*   
    SmartServer IoT General Purpose WebSocket Driver

    WebSocketes don't work or stop working
    1. If WebSockets are working and the PC hibernates
        a. If the hibernation is short the WebSocket may continue to work (less than 2 minutes hibernation)
        b. If the PC comes out of hibernation but the down time is less than the login timeout
           is less than the login timeout then REST may work but the WebSocket terminated due to the 2 minute timeout
           
           - To recover, this Web page will try to identify the hibernation, and then if REST response are working 
              for polling the Web page will make 3 attempts to reconnect the WebSocket.
        c. If the PC comes out of hibernation but SmartServer rebooted or login timed out

*/
    
let ivSocketRequest = "wss://"+ window.location.hostname + "/iap/ws"; // ":1880/iap/ws";//":8443/iap/ws";
let ivSocket;
let ivWsShowConsoleLog = false;
let ivWsShowConsoleLogOnClose = true;
var ivWsMessage, ivWsLastDatapointUpdate;
var iviWsCount = 0;
var ivWsSocketConnected = false;
var ivWsSocketConnectedInitiallyConnected = false; // this is used to determine if a WebSocket was connected but dropped.
var ivWsSmartServerCpu = 0;
var ivWsExtendMax = 11; // 10 + 1
var ivbWsSaveServicePinMessage = true;
var ivWsServicePinMessageHistory = [];
var ivbWsSaveServicePinShowMessage = false;
var ivbWsProcessDatapointUpdate = false;
var ivWsTempObj = {};
var ivbWsAutoRecoveryEnabled = true; // this used when PC comes out of recovery in which REST still works but the WebSocket is terminated
var ivIWsUnexpectantlyClose = 0; //0=normal
var iviWsUnexpectantlyCloseRetryCount = 0; //-1=initial value, 0 = normal
var iviWsUnexpectantlyCloseRetryCountMax = 3; 
var ivbWsIgnoreUnexpectantlyClose = false;
var iviWsRetryTimeout = 300000; //ms 5 * 60 * 1000 
var ivbWsStartWebSocket = false;
var ivWstimerId = null;

function ivWsLogout() {
    ivbIgnoreUnexpectantlyClose = true;
    ivSocket.close();
}
function ivWebSocketInitize() {
    ivbWsStartWebSocket = false;
    iviWsUnexpectantlyCloseRetryCount = 0;
    if(ivWstimerId !== null) 
		clearTimeout(ivWstimerId);
}
function ivWebSocketInit() {
    var iTemp;
    var element, element1;
    var bRetry = false;
    var sTemp;
    ivWsSocketConnected = false;
    ivWsSocketConnectedInitiallyConnected = false;
    ivWsServicePinMessageHistory = [];
    ivbWsSaveServicePinShowMessage = false;
    

    ivSocket =  new WebSocket(ivSocketRequest);
    ivSocket.onopen = function(event) {
        // alert("[open] connection");
        if(ivWsShowConsoleLog)
            console.log("Web Socket Open");
        ivWsSocketConnected = true;
        ivWsSocketConnectedInitiallyConnected = true;
        ivbWsStartWebSocket = false;
        if(ivbWsAutoRecoveryEnabled)
            iviWsUnexpectantlyCloseRetryCount = iviWsUnexpectantlyCloseRetryCountMax + 1;
    }
    ivSocket.onmessage = function(event) {
        //alert('[message] Data received frm server: ' + event.data);
        
        ivWsMessage = JSON.parse(event.data);
        var i, index = -1;
        var ivWsLastDatapointUpdate;
        try
        {
            if(ivWsMessage.action === "NTF:JOIN") {
                if(ivbWsSaveServicePinMessage) {
                    ivWsTempObj = {};
                    ivWsTempObj.timestamp = new Date().toISOString();
                    ivWsTempObj.serviceMessage = ivWsMessage.payload;
                    ivWsServicePinMessageHistory.splice(0,0,ivWsTempObj);
                    if(ivbWsSaveServicePinShowMessage) {
                        if(typeof webSocketSaveServicePinShowMessage !== 'undefined') { // d
                            webSocketSaveServicePinShowMessage(ivWsTempObj);
                        }
                    }
                    
                }
            }
            else if(ivWsMessage.action === "UPD:CPU") {  // 3.4 3.5 UPD:SU:CPU
                if(g_bShowCpu) {
                    if(g_iCheckIfGettingCpuUpdates !== 0)
                        g_iCheckIfGettingCpuUpdates = 0;
                    ivWsSmartServerCpu = ivWsMessage.payload;
                    document.getElementById("cpuValue").innerHTML = ivWsSmartServerCpu;
                    if(!(typeof g_iackgroundPollingRequestExtended === "undefined")) {
                        if(ivWsSmartServerCpu > 94) {
                            if(g_iBackgroundPollingRequestExtended < ivWsExtendMax)
                                g_iBackgroundPollingRequestExtended ++;
                        }
                        else {
                            if(g_iBackgroundPollingRequestExtended > 0)
                                g_iBackgroundPollingRequestExtended --;
                        }
                    }
                }
            }
            else if(ivWsMessage.action === "UPD:CPU") {  // 3.4 3.5 UPD:SU:CPU
                if(g_bShowCpu) {
                    if(g_iCheckIfGettingCpuUpdates !== 0) {
                        g_iCheckIfGettingCpuUpdates = 0;
                        g_bCpuUpdateTimeout = false;
                    }
                    ivWsSmartServerCpu = ivWsMessage.payload;
                    document.getElementById("cpuValue").innerHTML = ivWsSmartServerCpu;
                    if(!(typeof g_iackgroundPollingRequestExtended === "undefined")) {
                        if(ivWsSmartServerCpu > 94) {
                            if(g_iBackgroundPollingRequestExtended < ivWsExtendMax)
                                g_iBackgroundPollingRequestExtended ++;
                        }
                        else {
                            if(g_iBackgroundPollingRequestExtended > 0)
                                g_iBackgroundPollingRequestExtended --;
                        }
                    }
                }
            }
            else if(ivWsMessage.action === "UPD:SC:CPU") {  // 3.4 3.5 UPD:SU:CPU
                if(g_bShowCpu) {
                    if(g_iCheckIfGettingCpuUpdates !== 0) {
                        g_iCheckIfGettingCpuUpdates = 0;
                        g_bCpuUpdateTimeout = false;
                    }
                    if(Object.keys(ivWsMessage.payload).length === 1) {
                        ivWsSmartServerCpu = Object.entries(ivWsMessage.payload)[0][1];
                        document.getElementById("cpuValue").innerHTML = ivWsSmartServerCpu;
                        if(!(typeof g_iackgroundPollingRequestExtended === "undefined")) {
                            if(ivWsSmartServerCpu > 94) {
                                if(g_iBackgroundPollingRequestExtended < ivWsExtendMax)
                                    g_iBackgroundPollingRequestExtended ++;
                            }
                            else {
                                if(g_iBackgroundPollingRequestExtended > 0)
                                    g_iBackgroundPollingRequestExtended --;
                            }
                        }
                    }
                }
            }
            else if(ivWsMessage.action === "UPD:EPS") {
                if(g_iCheckIfGettingCpuUpdates !== 0) {
                    if(g_bCpuUpdateTimeout) {
                        if(g_cpuTimerId === 0)
                            g_cputimerId = window.setTimeout("cpuTimerHandler()", 5000);
                    }
                    g_bCpuUpdateTimeout = false;
                }
                if(g_bShowEps)
                    document.getElementById("epsValue").innerHTML = ivWsMessage.payload;
            }
            else if(ivWsMessage.action === "UPD:TOTAL_EPS") {
                if(g_iCheckIfGettingCpuUpdates !== 0) {
                    if(g_bCpuUpdateTimeout) {
                        if(g_cpuTimerId === 0)
                            g_cputimerId = window.setTimeout("cpuTimerHandler()", 5000);
                    }
                    g_bCpuUpdateTimeout = false;
                }
                if(g_bShowEps) {
                    //document.getElementById("epsValue").innerHTML = ivWsMessage.payload;
                    element = document.getElementById("epsValue");
                    if(element !== null) {
                        iTemp = ivWsMessage.payload;
                        element.innerHTML = iTemp;
                        if(g_bShowEpsWarningColors) {
                            if(iTemp >= g_iTotalEpsHighWarning) {
                                if(element.style.color !== "red")
                                    element.style.color = "red";
                            }
                            else if(iTemp >= g_iTotalEpsLowWarning) {
                                if(element.style.color !== "orange")
                                    element.style.color = "orange";
                            }
                            else {
                                if(element.style.color !== "black")
                                    element.style.color = "black";
                            }
                        }
                    }
                }
            }
            else if(ivWsMessage.action === "UPD:MONITORINGSTATE") { //3.4
                if(g_bShowIfBackgroundPollingPaused) {
                    if(typeof ivWsMessage.payload.active !== "undefined") {
                        element = document.getElementById("footerStatus3");
                        if(element !== null) { 
                            if(ivWsMessage.payload.active)
                                element.style.visibility = "hidden";
                            else 
                                element.style.visibility = "visible";
                        }
                    }
                    
                }
            }
            /* for remote CMS
            else if(ivWsMessage.action === "UPD:SC:EPS") {
                if(g_bShowEps) {
                    if(Object.keys(ivWsMessage.payload).length === 1)
                        document.getElementById("epsValue").innerHTML = Object.entries(ivWsMessage.payload)[0][1];
                }
            }
            */
            else if(ivWsMessage.action === "UPD:DATAPOINT"){
                //if(g_bNeedToSubscribe) // no longer needed in cae CMS ondemand get or DLA settings update
                if(!ivbWsProcessDatapointUpdate)
                    return;
                //var date = new Date();
                iviWsCount ++;
                ivWsLastMessage = ivWsMessage;
                if(ivWsShowConsoleLog)
                    console.log(ivWsMessage);
                json = [];
                if(typeof ivWsMessage.payload !== 'undefined'){
                    for(i=0; i < ivWsMessage.payload.length; i ++)
                    {
                        index ++;
                        ivWsLastDatapointUpdate = {};
                        ivWsLastDatapointUpdate.datapointQualifier = ivWsMessage.payload[i].datapointQualifier;
                        ivWsLastDatapointUpdate.value = ivWsMessage.payload[i].value;
                        try {
                            if(typeof ivWsMessage.payload[i].presetValue === "undefined") 
                                ivWsLastDatapointUpdate.presetValue = "";
                            else
                                ivWsLastDatapointUpdate.presetValue = ivWsMessage.payload[i].presetValue;
                        } catch { ivWsLastDatapointUpdate.presetValue = ""; }
                        try {
                            if(typeof ivWsMessage.payload[i].locValue === "undefined") 
                                ivWsLastDatapointUpdate.locValue = "";
                            else
                                ivWsLastDatapointUpdate.locValue = ivWsMessage.payload[i].locValue;
                        } catch { ivWsLastDatapointUpdate.locValue = ""; }
                        json[index] = ivWsLastDatapointUpdate;
                    }
                    if(json.length > 0) {
                        processWebSocketDpData(0, 1, "", json);  // defined by user
                    }
                }
            }
            else if(ivWsMessage.action === "UPD:DEVICE") {
                webSocketDeviceStatusUpdate(ivWsMessage.payload);
            }
            else if(ivWsMessage.action === "DEL:DEVICE") {
                webSocketDeviceDeleteUpdate(ivWsMessage.payload);
            }
            else if(ivWsMessage.action === "UPD:DEVICE_TEST_RESULT") {
                webSocketDeviceTestResultUpdate(ivWsMessage.payload);
            }
            else if(ivWsMessage.action === "CRT:ALARM") {
                webSocketDeviceAlarmUpdate(ivWsMessage.payload);
            }
            else if(ivWsMessage.action === "DEL:ALARM") {
                webSocketDeviceAlarmDeletedUpdate(ivWsMessage.payload);
            }
            else if(ivWsMessage.action === "CRT:NOTIFICATION") {
                webSocketNotificationUpdate(ivWsMessage.payload);
            }
        }
        catch {}
    }
    ivSocket.onclose = function(event) {
        ivWsSocketConnected = false;
        if(event.wasClean) {
            if(ivWsShowConsoleLogOnClose)
                console.log("web Socket close cleanly");
            //alert('[close] Connection closed cleanly, code = ' + event.code + 'reason = ' + event.reason);
        
        }
        else {
            if(ivWsShowConsoleLogOnClose)
                console.log('Web Socket died, code = ' + event.code + 'reason = ' + event.reason);
            
            // server process killed, network down, even.code is usually 1006
            //alert('[close] Connection died, code = ' + event.code + 'reason = ' + event.reason);
            //document.getElementById("log").value = '[close] Connection died, code = ' + event.code + 'reason = ' + event.reason + "\r\n\r\n" + document.getElementById("log").value
        }
        if(bRetry) {
            // PC hibernates for longer than WebSocket timeout, then automatically try to reconnect a couple of times.
				// If this is not implemented then use has to refresh the Web page
            iviWsUnexpectantlyCloseRetryCount --;
            if(iviWsUnexpectantlyCloseRetryCount === iviWsUnexpectantlyCloseRetryCountMax)
                ivbWsStartWebSocket = true;
            else if (iviWsUnexpectantlyCloseRetryCount > 0) {
                try {
                    if(ivWstimerId === 0)
                        ivWstimerId = window.setTimeout("ivWebSocketRetryTimerHandler", iviWsRetryTimeout);
                } catch (err) {}
            }
        }
    }
    ivSocket.onerror = function(error) {
        if(ivWsShowConsoleLogOnClose) {
            if(typeof error.message !== "undefined")
                console.log("WebSocket error: " + error.message);
            else
                console.log("WebSocket error: don't have error message");
        }
        if(!ivWsSocketConnected) {
            g_bPauseMainTimer = true; // used to pause sendnext and chart update during WebSocket Error confirm
            sTemp = "Error: ";
            if(ivWsSocketConnectedInitiallyConnected)
                sTemp = "WebSocket disconnected:";
            else
                sTemp = "Can't Create WebSocket:";
            sTemp += "\r\n\r\nThis may happen after a Web server reboot or if session timout";
            sTemp += "\r\n\r\nTry the following:";
            sTemp += "\r\n\r\n\t1. Refresh Web page data"
            sTemp += "\r\n\t2. Refresh the Web browser (F5 or CTRL-F5)";
            sTemp += "\r\n\t3. Log out and back in.";
            sTemp += "\r\n\t4. Try doing another Web browser refresh (F5 or CTRL-F5). ";
            sTemp += "\r\n\t5. If the SmartServer just powered up or rebooted wait 5+ minutes and log out again. ";

            sTemp += "\r\n\t6. Reboot your PC";
            sTemp += "\r\n\t7. Restart the PC - fixes issue if using vpn and PC hibernates";
            sTemp += "\r\n\r\nPress";
            sTemp += "\r\n\tRefresh - to refresh Web page data";
            sTemp += "\r\n\tLog out - to Go to the Login page";
            sTemp += "\r\n\tCancel - Stay in Browser, but either manually do a Web browser refresh or log out";
            //var resp = confirm(message)
            //if(resp) {
            //    logout();
                //var cmsStr =  "https://" + window.location.hostname;
                //window.open(cmsStr,'_self',false);
            //}
            element = document.getElementById("warningDiv");
	        element1 = document.getElementById("warningOverlayDiv");
            try {
                if((element === null) || (element1 === null))
                    return;
                menuOverlayDivShow(7, null);
                sTemp = sTemp.replace(/\t/g,"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").replace(/\r\n/g,"<br>");
                sTemp = "<br><div>" + sTemp + "</div><br>";
                sTemp += "<div style=\"width:100%;text-align:right\">";
                sTemp += "<button class=\"warningDivShowButton\" onclick=\"ivWebSocketOnErrorRetry()\">Refresh</button>";
                sTemp += "<button class=\"warningDivShowButton\" onclick=\"ivWebSocketOnErrorLogout()\">Log out</button>";
                sTemp += "<button class=\"warningDivShowButton\" onclick=\"ivWebSocketOnErrorCancel()\">Cancel</button>";
                sTemp += "</div>";
                element.innerHTML = sTemp; 

            }
            catch {}
        }
        else {
            
            if(ivbWsIgnoreUnexpectantlyClose) {

            }
            else if(ivbWsAutoRecoveryEnabled) {
                // WebSocket previously working - may be due to PC hibernating
                bRetry = true;
            }
        }
    }
}
function ivWebSocketOnErrorRetry() {
    showAlertDialogHide();
    ivWebSocketInit();
    showPlanningRefresh(0);
}
function ivWebSocketOnErrorLogout() {
    showAlertDialogHide();
    logout();
}
function ivWebSocketOnErrorCancel() {
    g_bPauseMainTimer = false; // used to pause sendnext and chart update during WebSocket Error confirm
    showAlertDialogHide();
}
g_bPauseMainTimer = false; // used to pause sendnext and chart update during WebSocket Error confirm
function ivWebSocketRetryTimerHandler() {
	ivbWsStartWebSocket = true;
}

  
    
