/********************************************************************************************
 *  SVG functions
 * 
 *  Charts - the chart graph has x and y are reversed
 *  Chart1 - basic chart 61 buckets
 *  Chart2 - Full chart including zoom
 *  Chart3 - Full chart including zoom and Two Y-Axis
 * *****************************************************************************************/
var ivChartTotalEntries = 61; // chart1
var ivChartXYLength = 420;
var ivChartXYLengthChart1 = 420;
var ivChartXLengthLargeChart = 2400; // chart2
var ivChartYLengthLargeChart = 1100;
var ivChartTotalEntriesLargeChart = 1200;
var ivChartXLengthLargeChart2 = 2400; // chart2
var ivChartYLengthLargeChart2 = 1100;
var ivChartTotalEntriesLargeChart2 = 1200;
var ivChartXLengthLargeChart3 = 2400; // chart2
var ivChartYLengthLargeChart3 = 1100;
var ivChartTotalEntriesLargeChart3 = 1200;
var ivChartXLengthLargeChart9 = 1600; // chart2
var ivChartYLengthLargeChart9 = 800;
var ivChartTotalEntriesLargeChart9 = 1200;
var ivChartXLengthLargeChart10 = 1600; // chart10
var ivChartYLengthLargeChart10 = 200;
var ivChartTotalEntriesLargeChart9 = 1200;

var ivChartLines = [];
var ivChartLineColors = ["blue","red","green", "brown","orange","#ff0066","#cc00ff","#6600ff","#ff6666", "#cc00cc", "#669900", "#00cc66", "#6600ff"];
var ivChartLineColorsIndex = 0;
var ivChartAllowTwoYaxis = true; 
var ivChartUseTwoYaxis = false;
var ivChartNeedTwoYaxis = false; // depends on data.  SNVT_switch dps uses both axis one 0-100 and 2nd 0-1
var ivChart3ZeroLineAlreadyCreated = false;
function ivCreateNewPolyline(displayId, lineName, color, linewidth) {
	var result = false;
	var svgObj, svgDoc, svg2;
	var newLine = document.createElementNS('http://www.w3.org/2000/svg','polyline');
	try {
		if(navigator.userAgent.match(/Chrome/))	
		{		
			svgObj = document.getElementById(displayId);
			svgDoc = svgObj.contentDocument;
		}
		else
			svgDoc = document.getElementById(displayId).getSVGDocument();
			
		newLine.setAttribute('id', lineName);
		if(color === null)
			color = "black"; //"#dcdcdc";
		if(linewidth === null)
			linewidth = 5;
		var newStyleStr = "fill:none;stroke:" + color + ";stroke-width:" + linewidth;
		newLine.setAttribute("style", newStyleStr);
		svg2 = svgDoc.getElementById("svg2");
		//svg2.appendChild(newLine);
		var chart3 = svg2.getElementById("chart1");
		chart3.appendChild(newLine);
		var polyline2Str = "0,0"; // 500,750";
		var polyline = svgDoc.getElementById(lineName);
		polyline.setAttribute("points", polyline2Str);
		result = true;
	}
	catch {}
	return result;
}
function ivCreateNewPolygon(displayId, lineName, color, fill, linewidth, opacity) {
	var result = false;
	var svgObj, svgDoc, svg2;
	var newLine = document.createElementNS('http://www.w3.org/2000/svg','polygon');
	try {
		if(navigator.userAgent.match(/Chrome/))	
		{		
			svgObj = document.getElementById(displayId);
			svgDoc = svgObj.contentDocument;
		}
		else
			svgDoc = document.getElementById(displayId).getSVGDocument();
			
		newLine.setAttribute('id', lineName);
		if(color === null)
			color = "black"; //"#dcdcdc";
		if(linewidth === null)
			linewidth = 5;
		var newStyleStr = "fill:";
		if(fill === null)
			newStyleStr += "none";
		else
			newStyleStr += fill;
		newStyleStr += ";stroke:" + color + ";stroke-width:" + linewidth;
		if(opacity !== null)
			newStyleStr += ";opacity:" + opacity;	
		newLine.setAttribute("style", newStyleStr);
		svg2 = svgDoc.getElementById("svg2");
		//svg2.appendChild(newLine);
		var chart3 = svg2.getElementById("chart1");
		chart3.appendChild(newLine);
		var polyline2Str = "0,0"; // 500,750";
		var polyline = svgDoc.getElementById(lineName);
		polyline.setAttribute("points", polyline2Str);
		result = true;
	}
	catch {}
	return result;
}
function ivConvertValueToDisplayDecimalPlaces(value) {
	if(value > 1) {
		value = value.toFixed(1);
		iPtr = value.indexOf(".0");
		if(iPtr !== -1) {
			value = value.substr(0, iPtr);
		}
	}
	return value;
}
function ivInitializeChart(nameId, ymin, ymax, linecolor, polygoncolor, textcolor, fontsize, chartLabels) {
	ivInitializeChart1(false, nameId, ymin, ymax, linecolor, polygoncolor, textcolor, fontsize, chartLabels);
}
function ivInitializeChart1(bClearDurration, nameId, ymin, ymax, linecolor, polygoncolor, textcolor, fontsize, chartLabels) {
	var middle;
	var svgObj = null, svgDoc = null, middle, i;
	if(navigator.userAgent.match(/Chrome/))	
	{		
		svgObj = document.getElementById(nameId);
		svgDoc = svgObj.contentDocument;
	}
	else
		svgDoc = document.getElementById(nameId).getSVGDocument();
	if(typeof svgDoc === "undefined")
		return;

	if((chartLabels === null) || (chartLabels === "y") || (chartLabels === "both")) {
		if(isNaN(ymin) || isNaN(ymax)) {
			svgDoc.getElementById("tspanY1").textContent = "";
			svgDoc.getElementById("tspanY2").textContent = "";
			svgDoc.getElementById("tspanY3").textContent = "";
		}
		else if(ymin === ymax) {
			//single datapoint
			svgDoc.getElementById("tspanY1").textContent = "";
			svgDoc.getElementById("tspanY2").textContent = ymin;
			svgDoc.getElementById("tspanY3").textContent = "";
		}
		else {
			svgDoc.getElementById("tspanY1").textContent = ymin;
			middle = ymin + ((ymax - ymin) * .50);
			middle = ivConvertValueToDisplayDecimalPlaces(middle);
			svgDoc.getElementById("tspanY2").textContent = middle;
			svgDoc.getElementById("tspanY3").textContent = ymax;
		}
	}
	if((chartLabels === null) || (chartLabels === "x") || (chartLabels === "both")) {
		if(chartLabels === "x") {
			svgDoc.getElementById("tspanY1").textContent = "";
			svgDoc.getElementById("tspanY2").textContent = "";
			svgDoc.getElementById("tspanY3").textContent = "";
		}
		if(bClearDurration)
			svgDoc.getElementById("tspanX4").textContent = "";
		else 
			svgDoc.getElementById("tspanX4").textContent = "1 Minute History";
	}
	svgDoc.getElementById("tspanY4").textContent = "";
	svgDoc.getElementById("tspanX1").textContent = ""; //xmin;
	svgDoc.getElementById("tspanX2").textContent = ""; //(xmax - xmin) * .50;
	svgDoc.getElementById("tspanX3").textContent = ""; //xmax;

	if(linecolor !== null){
		// change line color
		var lineObj = svgDoc.getElementById("polyline1");
		var linestyle = lineObj.getAttribute("style");
		var styleParameters = linestyle.split(";")
		var bFoundStroke = false;
		var newStyleStr = "";
		for(i=0; i < styleParameters.length; i ++)
		{
			if(styleParameters[i].includes("stroke:")) {
				styleParameters[i] = "stroke:" + linecolor;
				bFoundStroke = true;
			}
		}
		if(bFoundStroke) {
			for(i=0; i < styleParameters.length; i ++)
			{
				if(i > 0) {
					newStyleStr += ";";
				}
				newStyleStr += styleParameters[i];
				
			}
		}
		else {
			newStyleStr = linestyle + ";stroke:" + linecolor;
		}
		lineObj.setAttribute("style", newStyleStr);
	}
	if(polygoncolor !== null){
		var PolygonObj = svgDoc.getElementById("polygon1");
		var linestyle = lineObj.getAttribute("style");
		var styleParameters = linestyle.split(";")
		var bFoundStroke = false;
		var newStyleStr = "";
		for(i=0; i < styleParameters.length; i ++)
		{
			if(styleParameters[i].includes("fill:")) {
				styleParameters[i] = "fill:" + polygoncolor;
				bFoundStroke = true;
			}
		}
		if(bFoundStroke) {
			for(i=0; i < styleParameters.length; i ++)
			{
				if(i > 0) {
					newStyleStr += ";";
				}
				newStyleStr += styleParameters[i];
				
			}
		}
		else {
			newStyleStr = linestyle + ";fill:" + polygoncolor;
		}
		PolygonObj.setAttribute("style", newStyleStr);
	}
	if(textcolor !== null) {
		svgDoc.getElementById("textYAxis").style.fill = textcolor; // change text color
		svgDoc.getElementById("textXAxis").style.fill = textcolor; // change text color
	}
	if(fontsize !== null) {
		svgDoc.getElementById("textYAxis").style.fontSize = fontsize;  // change text font size
		svgDoc.getElementById("textXAxis").style.fontSize = fontsize; 
	}
}
function ivInitializeChart3(nameId, ymin, ymax, ymin1, ymax1, bAddZeroLine, bUseTwoYaxis, linecolor, polygoncolor, textcolor, fontsize, chartLabels) {
	// supports two yaxis
	// if ymin1 and ymax1 = null then no Y2
	// set polygocolor to if more than one line
	var svgObj, svgDoc, middle, i;
	var polylineObj, i, y, linestr, middle; 
	if(navigator.userAgent.match(/Chrome/))	
	{		
		svgObj = document.getElementById(nameId);
		svgDoc = svgObj.contentDocument;
	}
	else
		svgDoc = document.getElementById(nameId).getSVGDocument();
	
	if((ymin === null) || (ymax === null)) {
		svgDoc.getElementById("tspanY1").textContent = "";
		svgDoc.getElementById("tspanY2").textContent = "";
		svgDoc.getElementById("tspanY3").textContent = "";
		svgDoc.getElementById("tspanY4").textContent = "";
	}
	else if((chartLabels === null) || (chartLabels === "y") || (chartLabels === "both")) {
		if(ymin === ymax) {
			//single datapoint
			svgDoc.getElementById("tspanY1").textContent = "";
			svgDoc.getElementById("tspanY2").textContent = ymin;
			svgDoc.getElementById("tspanY3").textContent = "";
		}
		else {
			svgDoc.getElementById("tspanY1").textContent = ymin;
			middle = ymin + ((ymax - ymin) * .50);
			middle = ivConvertValueToDisplayDecimalPlaces(middle);
			svgDoc.getElementById("tspanY2").textContent = middle;
			svgDoc.getElementById("tspanY3").textContent = ymax;
		}
		if((ymin1 !== null) && (ymax1 !== null) && bUseTwoYaxis) 
			svgDoc.getElementById("tspanY4").textContent = "Y1";
		else
			svgDoc.getElementById("tspanY4").textContent = "  ";

		if((ymin < 0) && (ymax > 0) && bAddZeroLine) {
			if(!ivChart3ZeroLineAlreadyCreated) {
				y = ((0 - ymin) / (ymax - ymin)) * ivChartYLengthLargeChart - 2;
				ivCreateNewPolyline(nameId, "zeroline", "black", 5)
				polylineObj = svgDoc.getElementById("zeroline");
				linestr = y + ',0 ' + y + ',2400';
				polylineObj.setAttribute("points", linestr);
				ivChart3ZeroLineAlreadyCreated = true;
			}
		}
		else {
			if(ivChart3ZeroLineAlreadyCreated) {
				polylineObj = svgDoc.getElementById("zeroline");
				//polylineObj.setAttribute("color", chartList[k].color);
				polylineObj.setAttribute("points",'0,0');
			}
		}

	}
	if((chartLabels === null) || (chartLabels === "y") || (chartLabels === "both")) {
		if((ymin1 === null) || (ymax1 === null) || !bUseTwoYaxis) {
			svgDoc.getElementById("tspan2ndY1").textContent = "";
			svgDoc.getElementById("tspan2ndY2").textContent = "";
			svgDoc.getElementById("tspan2ndY3").textContent = "";
			svgDoc.getElementById("tspan2ndY4").textContent = "";
		}
		else {
			if(ymin1 === ymax1) {
				svgDoc.getElementById("tspan2ndY1").textContent = "";
				svgDoc.getElementById("tspan2ndY2").textContent = ymin1;
				svgDoc.getElementById("tspan2ndY3").textContent = "";
				svgDoc.getElementById("tspan2ndY4").textContent = "Y2";
			}
			else {
				svgDoc.getElementById("tspan2ndY1").textContent = ymin1;
				svgDoc.getElementById("tspan2ndY2").textContent = ymin1 + ((ymax1 - ymin1) * .50);
				svgDoc.getElementById("tspan2ndY3").textContent = ymax1;
				svgDoc.getElementById("tspan2ndY4").textContent = "Y2";
			}
		}
	}
	/*
	if((chartLabels === null) || (chartLabels === "x") || (chartLabels === "both")) {
		svgDoc.getElementById("tspanX4").textContent = "1 Minute History";
	}
	*/
	svgDoc.getElementById("tspanX4").textContent = "";
	svgDoc.getElementById("tspanX1").textContent = ""; //xmin;
	svgDoc.getElementById("tspanX2").textContent = ""; //(xmax - xmin) * .50;
	svgDoc.getElementById("tspanX3").textContent = ""; //xmax;
	svgDoc.getElementById("tspanX1b").textContent = ""; //xmin;
	svgDoc.getElementById("tspanX2b").textContent = ""; //(xmax - xmin) * .50;
	svgDoc.getElementById("tspanX3b").textContent = ""; //xmax;

	if(linecolor !== null){
		// change line color
		var lineObj = svgDoc.getElementById("polyline1");
		var linestyle = lineObj.getAttribute("style");
		var styleParameters = linestyle.split(";")
		var bFoundStroke = false;
		var newStyleStr = "";
		for(i=0; i < styleParameters.length; i ++)
		{
			if(styleParameters[i].includes("stroke:")) {
				styleParameters[i] = "stroke:" + linecolor;
				bFoundStroke = true;
			}
		}
		if(bFoundStroke) {
			for(i=0; i < styleParameters.length; i ++)
			{
				if(i > 0) {
					newStyleStr += ";";
				}
				newStyleStr += styleParameters[i];
				
			}
		}
		else {
			newStyleStr = linestyle + ";stroke:" + linecolor;
		}
		lineObj.setAttribute("style", newStyleStr);
	}
	if(polygoncolor !== null){
		var PolygonObj = svgDoc.getElementById("polygon1");
		var linestyle = lineObj.getAttribute("style");
		var styleParameters = linestyle.split(";")
		var bFoundStroke = false;
		var newStyleStr = "";
		for(i=0; i < styleParameters.length; i ++)
		{
			if(styleParameters[i].includes("fill:")) {
				styleParameters[i] = "fill:" + polygoncolor;
				bFoundStroke = true;
			}
		}
		if(bFoundStroke) {
			for(i=0; i < styleParameters.length; i ++)
			{
				if(i > 0) {
					newStyleStr += ";";
				}
				newStyleStr += styleParameters[i];
				
			}
		}
		else {
			newStyleStr = linestyle + ";fill:" + polygoncolor;
		}
		PolygonObj.setAttribute("style", newStyleStr);
	}
	if(textcolor !== null) {
		svgDoc.getElementById("textYAxis").style.fill = textcolor; // change text color
		svgDoc.getElementById("textXAxis").style.fill = textcolor; // change text color
	}
	if(fontsize !== null) {
		svgDoc.getElementById("textYAxis").style.fontSize = fontsize;  // change text font size
		svgDoc.getElementById("textXAxis").style.fontSize = fontsize; 
	}
}
function ivInitializeChart3Clear(nameId, chartList) {
	ivInitializeChart3Clear2Yaxis(true, nameId, chartList);
}
function ivInitializeChart3Clear2Yaxis(btwoaxis, nameId, chartList) {
	// supports two yaxis
	// if ymin1 and ymax1 = null then no Y2
	// set polygocolor to if more than one line
	var svgObj, svgDoc, currentEntries, i, nameId, PolylineObj;
	var bUseChartListNameId = false;
	try {
		if(nameId === "")
			bUseChartListNameId = true;
		for(i=0; i < chartList.length; i++)
		{
			if(bUseChartListNameId)
				nameId = chartList[i].displayId;
			if(navigator.userAgent.match(/Chrome/))	
			{		
				svgObj = document.getElementById(nameId);
				svgDoc = svgObj.contentDocument;
			}
			else
				svgDoc = document.getElementById(nameId).getSVGDocument();
			
			
			svgDoc.getElementById("tspanY1").textContent = "";
			svgDoc.getElementById("tspanY2").textContent = "";
			svgDoc.getElementById("tspanY3").textContent = "";
			svgDoc.getElementById("tspanY4").textContent = "";
			if(btwoaxis) {
				svgDoc.getElementById("tspan2ndY1").textContent = "";
				svgDoc.getElementById("tspan2ndY2").textContent = "";
				svgDoc.getElementById("tspan2ndY3").textContent = "";
				svgDoc.getElementById("tspan2ndY4").textContent = "";
			}

			svgDoc.getElementById("tspanX4").textContent = "";
			svgDoc.getElementById("tspanX1").textContent = ""; //xmin;
			svgDoc.getElementById("tspanX2").textContent = ""; //(xmax - xmin) * .50;
			svgDoc.getElementById("tspanX3").textContent = ""; //xmax;
			svgDoc.getElementById("tspanX1b").textContent = ""; //xmin;
			svgDoc.getElementById("tspanX2b").textContent = ""; //(xmax - xmin) * .50;
			svgDoc.getElementById("tspanX3b").textContent = ""; //xmax;
		
			currentEntries = chartList[i].dataCurrentEntries;
			if(currentEntries > 0) {
				PolylineObj = svgDoc.getElementById(chartList[i].lineName);
				if(PolylineObj !== null) {
					PolylineObj.setAttribute("color", "black");
					PolylineObj.setAttribute("points", "0,0");
				}
			}
			
		} // for(k=0; k < chartList.length; k++)
	}
	catch {}
}
function ivChangeChartHistoryInterval(n, nameId, interval) {
	var svgObj, svgDoc;
	if(navigator.userAgent.match(/Chrome/))	
	{		
		svgObj = document.getElementById(nameId);
		svgDoc = svgObj.contentDocument;
	}
	else
		svgDoc = document.getElementById(nameId).getSVGDocument();
	if(interval === 1)
	{
		svgDoc.getElementById("tspanX4").textContent = "1 Minute History";
		ChangeIntervalButtons(interval);
	}
	else if(interval === 2)
	{
		svgDoc.getElementById("tspanX4").textContent = "1 Hour History";
		ChangeIntervalButtons(interval);
	}
	else if(interval === 3)
	{
		svgDoc.getElementById("tspanX4").textContent = "1 Day History";
		ChangeIntervalButtons(interval);
	}
	else if(interval === 4)
	{
		svgDoc.getElementById("tspanX4").textContent = "1 Month History";
		ChangeIntervalButtons(interval);
	}

}
function ivUpdateCharts(Index, fvalue, timestamp) {
	// timestamp not used at this time
	try {
		if(g_dashboardChartList[Index] === null)
			return;
		if(g_dashboardChartList[Index].data === null)
			return;
		if((g_dashboardChartList[Index].data.length === 0) && (fvalue === null))
			return;
		
		if((fvalue === null) && (g_dashboardChartList[Index].endPtr === -1))
			return;
		var endPtr = g_dashboardChartList[Index].endPtr;
		var oldValue = null;
		var bPolygon = true;
		if(g_dashboardChartList[Index].endPtr !== -1)
			oldValue = g_dashboardChartList[Index].data[endPtr].value;
		
		var startIndex = g_dashboardChartList[Index].startPtr;
		var currentEntries = g_dashboardChartList[Index].dataCurrentEntries;
		if(currentEntries < ivChartTotalEntries) {
			endPtr ++;
			currentEntries ++;
			g_dashboardChartList[Index].dataCurrentEntries = currentEntries;
		}
		else {
			endPtr ++;
			if(endPtr >= ivChartTotalEntries)
				endPtr = 0;
			startIndex ++;
			if(startIndex >= ivChartTotalEntries) 
				startIndex = 0;
			g_dashboardChartList[Index].startPtr = startIndex;
		}
		g_dashboardChartList[Index].endPtr = endPtr;
		if(fvalue === null)
			fvalue = oldValue;
			g_dashboardChartList[Index].data[endPtr] = {};
			g_dashboardChartList[Index].data[endPtr].value = fvalue;
		if(timestamp !== null) 
			g_dashboardChartList[Index].data[endPtr].timestamp = timestamp;
		else
			g_dashboardChartList[Index].data[endPtr].timestamp = "";
		
		
		var PointsPerEntry = ivChartXYLength / (ivChartTotalEntries -1) ;
				
		var xIndex = 0;
		var linestr = "";
			// start line on right-side of chart
		if(typeof g_dashboardChartList[Index].bPolygon) {
			bPolygon = g_dashboardChartList[Index].bPolygon;

		}
		if(g_dashboardChartList[Index].data.length < ivChartTotalEntries) {
			xIndex = ivChartTotalEntries - g_dashboardChartList[Index].data.length;
			x = xIndex * PointsPerEntry;
			if(bPolygon)
				linestr += ' ' + 0 + ',' + x;
		}
		

		var range = g_dashboardChartList[Index].maxValue - g_dashboardChartList[Index].minValue;
		var chartMin = g_dashboardChartList[Index].minValue;
		//for(i = 0; i < PowerHistoryCurrentEntries; i ++)
		for(i = 0; i < currentEntries; i ++)
		{
			x = xIndex * PointsPerEntry;
			xIndex ++;
			fvalue = g_dashboardChartList[Index].data[startIndex].value;
			startIndex ++
			if(startIndex >= currentEntries)
			startIndex = 0;
			//y = (fvalue / g_dashboardChartList[Index].maxValue) * ivChartXYLength;
			y = ((fvalue - chartMin) / range) * ivChartXYLength;
			if(i >= (currentEntries -1))
				x = ivChartXYLength + 3;
			linestr += ' ' + y + ',' + x;
		}
		var displayObj = g_dashboardChartList[Index].displayId;
		var svgDoc = document.getElementById(displayObj).getSVGDocument();
		var PolygonObj = svgDoc.getElementById("polygon1");
		//line1str = line1obj.getAttribute("points");
		if(bPolygon) {
			linestr1 = linestr += ' 1,' + x + ', 1,5';
			PolygonObj.setAttribute("points", linestr);
		}
				
		PolylineObj = svgDoc.getElementById("polyline1");
				
		PolylineObj.setAttribute("points", linestr);
	} catch (err) {}

}
function ivUpdateChartsDatalog(displayId, sExtraStr, type, Index, chartList, timestamp,min, max, startTimestamp, endTimestamp) {
	// single scalar datapoint -- chart2
	// type: 0 = trend, 1 =stepline; uses timestamp
	try {
		var xIndex = 0, i, x, y, yOld = 0, fvalue;
		var linestr = "", linestr1;
		var displayObj;
		var svgObj, svgDoc;
		var PolygonObj;
		var range, xRange, startTimestampMicroSec, endTimestampMicroSec;
		var chartMin;
		var startIndex;
		var currentEntries;
		var circleObj;
		var PointsPerEntry;
		var iTemp;
		var sDuration;
		var chartLabels = null;
		var lineInfo = "";
		var time,dates, str, d, startDate, endDate, startDateStr, endDateStr;
		var bShowDates = false;
		
		if(chartList === null)
			return;
		if(chartList.length === 0)
			return;
		if(chartList[Index] === null)
			return;
		if(chartList[Index].data === null)
			return;
		if(chartList[Index].data.length === 0)
			return;
		if(chartList[Index].endPtr === -1)
			return;
		var startPtr = chartList[Index].startPtr;
		var endPtr = chartList[Index].endPtr;
		var oldValue = null;
		
		if(chartList[Index].endPtr !== -1)
			oldValue = chartList[Index].data[endPtr].value;
		
		startIndex = chartList[Index].startPtr;
		currentEntries = chartList[Index].dataCurrentEntries;
		chartLabels = chartList[Index].chartLabels;
		
		if(timestamp !== null) {
			if(chartList[Index].data.length  > 0)
				chartList[Index].data[endPtr].timestamp = timestamp;
		}
/*		
		if(fvalue !== null) {
			if(currentEntries < ivChartTotalEntriesLargeChart) {
				endPtr ++;
				currentEntries ++;
				g_chartList[Index].dataCurrentEntries = currentEntries;
			}
			else {
				endPtr ++;
				if(endPtr >= ivChartTotalEntriesLargeChart)
					endPtr = 0;
				startIndex ++;
				if(startIndex >= ivChartTotalEntriesLargeChart) 
					startIndex = 0;
				g_chartList[Index].startPtr = startIndex;
			}
			chartList[Index].endPtr = endPtr;
			chartList[Index].data[endPtr] = {};
			chartList[Index].data[endPtr].value = fvalue;
			chartList[Index].data[endPtr].timestamp = timestamp;
		}
	*/	
		startTimestampMicroSec = startTimestamp; //chartList[Index].data[startIndex].timestamp;
		endTimestampMicroSec = endTimestamp; //chartList[Index].data[endPtr].timestamp;
		xRange = endTimestampMicroSec - startTimestampMicroSec; // MicroSec
		range = max - min; //chartList[Index].maxValue - chartList[Index].minValue;
		
		
		chartMin = min; //chartList[Index].minValue;
		xIndex = startIndex;
		displayObj = displayId; //chartList[Index].displayId;
		if(navigator.userAgent.match(/Chrome/))	
		{		
			svgObj = document.getElementById(displayObj);
			svgDoc = svgObj.contentDocument;
		}
		else
			svgDoc = document.getElementById(displayObj).getSVGDocument();
		//linestr += ' ' + 0 + ',' + 0;
		/*
		if(currentEntries === 1) {
			PolylineObj = svgDoc.getElementById("polyline1");
			PolylineObj.setAttribute("stroke", "none");
			circleObj = svgDoc.getElementById("dot");
			circleObj.setAttribute("fill", "blue");

		}
		else {
			*/
			for(i = 0; i < currentEntries; i ++)
			{
				/*
				if(i === 0) {
					i = currentEntries - 2;
					xIndex = i;
				}
				*/
				x = ((chartList[Index].data[xIndex].timestamp - startTimestampMicroSec) / xRange) * ivChartXLengthLargeChart;
				fvalue = chartList[Index].data[xIndex].value;
				lineInfo += ", " + fvalue;
				xIndex ++;
				if(xIndex >= currentEntries)
					xIndex = 0;
				//y = (fvalue / g_dashboardChartList[Index].maxValue) * ivChartXYLength;
				y = ((fvalue - chartMin) / range) * ivChartYLengthLargeChart;
				if(type === 1)  {
					if(i !== 0)
						linestr += ' ' + yOld + ',' + x; //stepLine
				}
				//if(i >= (currentEntries -1))
				//	x = ivChartXYLengthLargeChart + 3;
				linestr += ' ' + y + ',' + x;
				yOld = y;
				if(i===0) {
					if(currentEntries === 1) { // create a scquare
						x = ivChartXLengthLargeChart / 2;
						linestr = "";
						for(s=0; s < 25; s++)
						{
							for(t=0; t < 25; t++)
							{
								if(linestr !== "")
									linestr += ' ';
								linestr += (y - 12 + s) + ',' + (x - 12 + t);
							}
						}
					}
				}
			}
			PolygonObj = svgDoc.getElementById("polygon1");
			//line1str = line1obj.getAttribute("points");
			linestr1 = linestr + ' 1,' + x + ', 1,5';
			//linestr += ' 1,' + x + ', 1,5';
			if(currentEntries !== 1)
				PolygonObj.setAttribute("points", linestr1);
					
			PolylineObj = svgDoc.getElementById("polyline1");
					
			PolylineObj.setAttribute("points", linestr);
		//}

		iTemp = xRange / 1000;
		sDuration = "";					
		if(iTemp < 60)
			sDuration = iTemp.toFixed(1) + " s";
		else if(iTemp < (60 * 60))
			sDuration = (iTemp / 60).toFixed(2) + " m";
		else if(iTemp < (60 * 60 * 24))
			sDuration = (iTemp / (60 * 60)).toFixed(2) + " hours";
		else 
			sDuration = (iTemp / (60 * 60 * 24)).toFixed(2) + " days";
		
		if((chartLabels === null) || (chartLabels === "x") || (chartLabels === "both")) {
			//if(currentEntries === 1) {
			if((chartList.length === 1) && (currentEntries === 1)) {
				d = new Date();
				//d.setTime(g_chartList[Index].data[startPtr].timestamp);
				d.setTime(chartList[0].data[0].timestamp);
				time = d.toLocaleTimeString();
				//dates = d.toLocaleDateString().split("/");
				str = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " "; //dates[2] + "-" +  ivPadStart(dates[1], "0", 2) + "-" +  ivPadStart(dates[0], "0", 2) + " ";
				svgDoc.getElementById("tspanX2b").textContent = str;
				svgDoc.getElementById("tspanX2").textContent = time;
			}
			else {
				d = new Date();
				d.setTime(chartList[Index].data[startPtr].timestamp);
				startDate = d.toLocaleDateString();
				startDateStr = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";
				//dates = startDate.split("/");
				startTime = d.toLocaleTimeString();

				d.setTime(chartList[Index].data[endPtr].timestamp);
				endDate = d.toLocaleDateString();
				endDateStr = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";
				//dates = startDate.split("/"); 12345
				endTime = d.toLocaleTimeString();

				if(startDate !== endDate)
					bShowDates = false;
				
				str = "";
				if(bShowDates) {
					//dates = startDate.split("/"); 
					str += startDateStr; //dates[2] + "-" +  ivPadStart(dates[0], "0", 2) + "-" +  ivPadStart(dates[1], "0", 2) + " ";
					svgDoc.getElementById("tspanX1b").textContent = str;
				}
				svgDoc.getElementById("tspanX1").textContent = startTime;

				iTemp = chartList[Index].data[endPtr].timestamp - chartList[Index].data[startPtr].timestamp;
				iTemp = (iTemp / 2) + chartList[Index].data[startPtr].timestamp;
				d = new Date();
				d.setTime(iTemp);
				time = d.toLocaleTimeString();
				
				str = "";
				if(bShowDates) {
					str += d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";
					//dates = d.toLocaleDateString().split("/");
					svgDoc.getElementById("tspanX2b").textContent = str;
				}
				svgDoc.getElementById("tspanX2").textContent = time;

				 
				str = "";
				if(bShowDates) {
					//dates = endDate.split("/");
					str += endDateStr;
					svgDoc.getElementById("tspanX3b").textContent = str;
				}
				svgDoc.getElementById("tspanX3").textContent = endTime;
			}
			svgDoc.getElementById("tspanX4").textContent = sExtraStr + sDuration; // + "   " + lineInfo;
		}

	} catch (err) {}
}
function ivUpdateChartsDatalogChart3TwoYaxis(displayId, sExtraStr, type, yAxisMode, chartList, timestamp,min, max, minY2, maxY2, startTimestamp, endTimestamp, iLineWidth, bExtendToEndTimeStamp, chartLabels) {
	ivUpdateChartsDatalogChart3TwoYaxis2(0, displayId, sExtraStr, type, yAxisMode, chartList, timestamp,min, max, minY2, maxY2, startTimestamp, endTimestamp, iLineWidth, bExtendToEndTimeStamp, chartLabels, ivChartXLengthLargeChart, ivChartYLengthLargeChart);
}
function ivUpdateChartsDatalogChart3TwoYaxis1(displayId, sExtraStr, type, yAxisMode, chartList, timestamp,min, max, minY2, maxY2, startTimestamp, endTimestamp, iLineWidth, bExtendToEndTimeStamp, chartLabels, chartXLengthLargeChart, chartYLengthLargeChart) {
	ivUpdateChartsDatalogChart3TwoYaxis2(0, displayId, sExtraStr, type, yAxisMode, chartList, timestamp,min, max, minY2, maxY2, startTimestamp, endTimestamp, iLineWidth, bExtendToEndTimeStamp, chartLabels, chartXLengthLargeChart, chartYLengthLargeChart);
}
function ivUpdateChartsDatalogChart3TwoYaxis2(mode,displayId, sExtraStr, type, yAxisMode, chartList, timestamp,min, max, minY2, maxY2, startTimestamp, endTimestamp, iLineWidth, bExtendToEndTimeStamp, chartLabels, chartXLengthLargeChart, chartYLengthLargeChart) {
	// chart3.svg 
	// mode: 0=normal or zoomed chart, 2=zoom panel (where you select range)
	// multiple datapoints and structured datapoints that has  -- chart3
	// type: 0 = trend, 1 =stepline; uses timestamp
	// yAxisMode: 0=single both Y1 and Y2 lines use Y1 axis only, 1= show Y1 only, 2= show Y2 only only, 3=show Both YAxis
	// Polygon: used for zoom rectangle 
	// if the chartList[k].startptr = 0, unlimited duration, if the chartList[k].startptr !== 0 then use chartList[k].durationtimestamp
	try {
		var xIndex = 0, i, k, x, y, yOld = 0, fvalue, s,t;
		var linestr = "", linestr1;
		var displayObj;
		var svgObj, svgDoc;
		var PolylineObj, PolygonObj;
		var range, rangeY2 = null, xRange, startTimestampMicroSec, endTimestampMicroSec;
		var chartMin, chartMinY2 = null;
		var startIndex;
		var currentEntries;
		var circleObj;
		var PointsPerEntry;
		var iTemp, lineWidth;
		var sDuration;
		var bLine = true;
		
		var lineInfo = "";
		var time,dates, str, d, startDate, endDate, startTime, endTime, midDate = null, midTime = null, startDateStr, endDateStr, currentDateStr;
		var bShowDates = false;
		var startPtr;
		var endPtr;
		var bDurationTime = false;
		var bChangeStartTime = false;
		if(chartList === null)
			return;
		if(chartList.length === 0)
			return;
		
		if(mode < 1) {
			if(typeof chartList[0].durationStartTimestamp !== "undefined") {
				if(chartList[0].durationStartTimestamp !== 0) {
					if(chartList[0].startPtr !== 0) {
						startTimestamp	= chartList[0].durationStartTimestamp;
						bDurationTime = true;
					}
					else {
						if(chartList[0].durationStartTimestamp > chartList[0].data[0].timestamp) {
							startTimestamp	= chartList[0].durationStartTimestamp;
							bDurationTime = true;
						}
					}
				}
			}
		}
		startTimestampMicroSec = startTimestamp; //chartList[Index].data[startIndex].timestamp;
		endTimestampMicroSec = endTimestamp; //chartList[Index].data[endPtr].timestamp;
		xRange = endTimestampMicroSec - startTimestampMicroSec; // MicroSec
		if(xRange < 0) {
			if(mode === 2) {
				if(chartList[0].data.length === 1) {
					xRange = 0;
					endTimestampMicroSec = startTimestampMicroSec;
					chartList.pop(); // remove 
				}
			}
			else {
				if(chartList.length === 1) {
					if(chartList[0].data.length === 1) {
						xRange = 0;
						endTimestampMicroSec = startTimestampMicroSec;
					}
				}
			}
		}
		range = max - min; //chartList[Index].maxValue - chartList[Index].minValue;
		if((maxY2 !== null) && (minY2 !== null)) {
			rangeY2 = maxY2 - minY2; //chartList[Index].maxValue - chartList[Index].minValue;
			chartMinY2 = minY2;
		}
		displayObj = displayId; //chartList[Index].displayId;
		if(navigator.userAgent.match(/Chrome/))	
		{		
			svgObj = document.getElementById(displayObj);
			svgDoc = svgObj.contentDocument;
		}
		else
			svgDoc = document.getElementById(displayObj).getSVGDocument();
		for(k=0; k < chartList.length; k++)
		{
			
			bLine = true;
			if(typeof chartList[k].bPolygon !== "undefined") {
				if(chartList[k].bPolygon)
					bLine = false;
			}
			currentEntries = chartList[k].dataCurrentEntries;
			if(currentEntries > 0) {
				if(chartList[k].creatChartLine) {
					chartList[k].creatChartLine = false;
					
					if(iLineWidth === null) {
						if(typeof chartList[k].lineWidth !== "undefined")
							lineWidth = chartList[k].lineWidth;
						else
							lineWidth = 1;
					}
					else 
						lineWidth = iLineWidth;
					if(bLine)
						ivCreateNewPolyline(displayId, chartList[k].lineName, chartList[k].color, lineWidth);
					else {
						ivCreateNewPolygon(displayId, chartList[k].lineName, chartList[k].color, chartList[k].fill, lineWidth, chartList[k].opacity)
					}
				}
				if(bLine)
					PolylineObj = svgDoc.getElementById(chartList[k].lineName);
				else 
					PolygonObj = svgDoc.getElementById(chartList[k].lineName);
				if(chartList[k].show) {
					lineInfo = "";
					linestr = "";
					
					startPtr = chartList[k].startPtr;
					endPtr = chartList[k].endPtr;
					//oldValue = null;
					
					//if(chartList[k].endPtr !== -1)
					//	oldValue = chartList[k].data[endPtr].value;
					
					startIndex = chartList[k].startPtr;
					
					//chartLabels = chartList[k].chartLabels;
					
					if(timestamp !== null) {
						if(chartList[k].data.length  > 0)
							chartList[k].data[endPtr].timestamp = timestamp;
					}
					
					chartMin = min; //chartList[Index].minValue;
					xIndex = startIndex;
					yOld = chartList[k].data[xIndex].value;
					
					//linestr += ' ' + 0 + ',' + 0;
	/*				
					if(currentEntries === 1) {
						PolylineObj = svgDoc.getElementById(chartList[k].lineName); //"polyline1");
						PolylineObj.setAttribute("stroke", "none");
						PolylineObj.setAttribute("color", chartList[k].color);
						//circleObj = svgDoc.getElementById("dot");
						//circleObj.setAttribute("fill", "blue");

					}
					else {
	*/					
					if(bDurationTime)
						bChangeStartTime = true;
					for(i = startIndex; i < currentEntries; i ++)
					{
						if(xRange === 0)
							x = chartXLengthLargeChart / 2;
						else {
							if(bChangeStartTime) {
								x = 0;
								bChangeStartTime = false;
							}
							else
								x = ((chartList[k].data[xIndex].timestamp - startTimestampMicroSec) / xRange) * chartXLengthLargeChart;
						}
						fvalue = chartList[k].data[xIndex].value;
						lineInfo += ", " + fvalue;
						xIndex ++;
						if(xIndex >= currentEntries)
							xIndex = 0;
						//y = (fvalue / g_dashboardChartList[Index].maxValue) * ivChartXYLength;
						if(yAxisMode === 0) // show all on single Yaxis -- the default
							y = ((fvalue - chartMin) / range) * chartYLengthLargeChart; 
						else if(yAxisMode === 3) {
							if(chartList[k].yAxis === 1) 
								y = ((fvalue - chartMin) / range) * chartYLengthLargeChart;
							else
								y = ((fvalue - chartMinY2) / rangeY2) * chartYLengthLargeChart;
						}
						else if(chartList[k].yAxis === 1) {
							if(yAxisMode !== 2)
								y = ((fvalue - chartMin) / range) * chartYLengthLargeChart;
						}
						else if(chartList[k].yAxis === 2) {
							if(yAxisMode !== 1)
								y = ((fvalue - chartMinY2) / rangeY2) * chartYLengthLargeChart;
						}
						
						if(type === 1) {
							if(i !== 0)
								linestr += ' ' + yOld + ',' + x; //stepLine
						}
						//if(i >= (currentEntries -1))
						//	x = ivChartXYLengthLargeChart + 3;
						linestr += ' ' + y + ',' + x;
						yOld = y;
						if(i === 0) {
							if(currentEntries === 1) { // create a scquare
								linestr = "";
								for(s=0; s < 25; s++)
								{
									for(t=0; t < 25; t++)
									{
										if(linestr !== "")
											linestr += ' ';
										linestr += (y - 12 + s) + ',' + (x - 12 + t);
									}
								}
							}
						}
					}
					if(bExtendToEndTimeStamp) {
						if(currentEntries > 1) {
							// extend line to right Y-axis
							if(bLine) {
								if(chartList[k].data[endPtr].timestamp < endTimestamp) {
									if(xRange === 0)
										x = chartXLengthLargeChart / 2;
									else
										x = chartXLengthLargeChart;
									linestr += ' ' + y + ',' + x;
								}
							}
						}
					}
					
					/* remove if polygon is no longer going to be supported
					if(chartList.length === 1) {
						PolygonObj = svgDoc.getElementById("polygon1");
						//line1str = line1obj.getAttribute("points");
						linestr1 = linestr + ' 1,' + x + ', 1,5';
						//linestr += ' 1,' + x + ', 1,5';
						PolygonObj.setAttribute("points", linestr1);
					}
					*/

					//PolylineObj = svgDoc.getElementById("polyline1");
					if(bLine) {
						PolylineObj.setAttribute("color", chartList[k].color);
						PolylineObj.setAttribute("points", linestr);
					}
					else {
						PolygonObj = svgDoc.getElementById(chartList[k].lineName);
						//linestr1 = linestr + ' 1,' + x + ', 1,5';
						PolygonObj.setAttribute("points", linestr);
					}
	//				}
				}
				else { // hide line
					if(bLine) {
						PolylineObj.setAttribute("color", "black");
						PolylineObj.setAttribute("points", "0,0");
					}
					else  {
						PolygonObj.setAttribute("color", "black");
						PolygonObj.setAttribute("points", "0,0");
					}
				}
			} // if(currentEntries > 0) {
			else {
				// no data entries
				if(!chartList[k].creatChartLine) {
					// same for polyline or polygon
					PolylineObj = svgDoc.getElementById(chartList[k].lineName);
					if(PolylineObj !== null) {
						PolylineObj.setAttribute("color", "black");
						PolylineObj.setAttribute("points", "0,0");
					}
				}
			}
		} // for(k=0; k < chartList.length; k++)
		iTemp = xRange / 1000;
		sDuration = "";					
		if(iTemp < 60)
			sDuration = iTemp.toFixed(1) + " s";
		else if(iTemp < (60 * 60))
			sDuration = (iTemp / 60).toFixed(1) + " m";
		else if(iTemp < (60 * 60 * 24))
			sDuration = (iTemp / (60 * 60)).toFixed(1) + " hr";
		else 
			sDuration = (iTemp / (60 * 60 * 24)).toFixed(1) + " days";
		
		if((chartLabels === null) || (chartLabels === "x") || (chartLabels === "both")) {
			if((chartList.length === 1) && (currentEntries === 1)) {
				d = new Date();
				//d.setTime(g_chartList[Index].data[startPtr].timestamp);
				d.setTime(chartList[0].data[0].timestamp);
				time = d.toLocaleTimeString();
				dates = d.toLocaleDateString().split("/");
				str = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";
				svgDoc.getElementById("tspanX2b").textContent = str;
				svgDoc.getElementById("tspanX2").textContent = time;
			}
			else {
				d = new Date();
				currentDateStr = d.toLocaleDateString();
				d.setTime(startTimestamp);
				startDate = d.toLocaleDateString();
				startDateStr = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";
				startTime = d.toLocaleTimeString();

				d.setTime(endTimestamp);
				endDate = d.toLocaleDateString();
				endDateStr = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";
				endTime = d.toLocaleTimeString();

				if((startDate !== endDate) || (startDate !== currentDateStr) || (endDate !== currentDateStr)) {
					bShowDates = true;

					d.setTime(((endTimestamp - startTimestamp) / 2) + startTimestamp);
					midDate = d.toLocaleDateString();
					//dates = midDate.split("/");
					midTime = d.toLocaleTimeString();
				}
				str = "";
				if(bShowDates) {
					//dates = startDate.split("/"); 
					str += startDateStr;
					svgDoc.getElementById("tspanX1b").textContent = str;
				}
				else 
					svgDoc.getElementById("tspanX1b").textContent = "  ";
				svgDoc.getElementById("tspanX1").textContent = startTime;

				iTemp = endTimestamp - startTimestamp;
				iTemp = (iTemp / 2) + startTimestamp;
				d = new Date();
				d.setTime(iTemp);
				time = d.toLocaleTimeString();
				
				str = "";
				if(bShowDates) {
					dates = midDate.split("/");
					str += d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";
					dates = d.toLocaleDateString().split("/");
					svgDoc.getElementById("tspanX2b").textContent = str;
				}
				else 
					svgDoc.getElementById("tspanX2b").textContent = "  ";
				svgDoc.getElementById("tspanX2").textContent = time;
				str = "";
				if(bShowDates) {
					//dates = endDate.split("/");
					str += endDateStr;
					svgDoc.getElementById("tspanX3b").textContent = str;
				}
				else 
					svgDoc.getElementById("tspanX3b").textContent = "  ";
				svgDoc.getElementById("tspanX3").textContent = endTime;
			}
			svgDoc.getElementById("tspanX4").textContent = sExtraStr + sDuration; // + "   " + lineInfo;
		}

	} catch (err) {}

}
function ivUpdateChartsDatalogChart3(displayId, sExtraStr, type, Index, chartList, timestamp,min, max, startTimestamp, endTimestamp) {
	// single scalar datapoint -- chart2
	// type: 0 = trend, 1 =stepline; uses timestamp
	try {
		var xIndex = 0, i, k, x, y, yOld = 0, fvalue;
		var linestr = "", linestr1;
		var displayObj;
		var svgObj, svgDoc;
		var PolylineObj, PolygonObj;
		var range, xRange, startTimestampMicroSec, endTimestampMicroSec;
		var chartMin;
		var startIndex;
		var currentEntries;
		var circleObj;
		var PointsPerEntry;
		var iTemp;
		var sDuration;
		var chartLabels = null;
		var lineInfo = "";
		var time,dates, str, d, startDate, endDate, startDateStr, endDateStr;
		var bShowDates = false;
		var startPtr;
		var endPtr;
		if(chartList === null)
			return;
		if(chartList.length === 0)
			return;
		
		startTimestampMicroSec = startTimestamp; //chartList[Index].data[startIndex].timestamp;
		endTimestampMicroSec = endTimestamp; //chartList[Index].data[endPtr].timestamp;
		xRange = endTimestampMicroSec - startTimestampMicroSec; // MicroSec
		range = max - min; //chartList[Index].maxValue - chartList[Index].minValue;
		displayObj = displayId; //chartList[Index].displayId;
		if(navigator.userAgent.match(/Chrome/))	
		{		
			svgObj = document.getElementById(displayObj);
			svgDoc = svgObj.contentDocument;
		}
		else
			svgDoc = document.getElementById(displayObj).getSVGDocument();
		for(k=0; k < chartList.length; k++)
		{
			if(chartList[k].creatChartLine) {
				chartList[k].creatChartLine = false;
				ivCreateNewPolyline(displayId, chartList[k].lineName, chartList[k].color, 5);
			}
			PolylineObj = svgDoc.getElementById(chartList[k].lineName);
			if(chartList[k].show) {
				lineInfo = "";
				linestr = "";
				
				startPtr = chartList[k].startPtr;
				endPtr = chartList[k].endPtr;
				//oldValue = null;
				
				//if(chartList[k].endPtr !== -1)
				//	oldValue = chartList[k].data[endPtr].value;
				
				startIndex = chartList[k].startPtr;
				currentEntries = chartList[k].dataCurrentEntries;
				chartLabels = chartList[k].chartLabels;
				
				if(timestamp !== null) {
					if(chartList[k].data.length  > 0)
						chartList[k].data[endPtr].timestamp = timestamp;
				}
				
				chartMin = min; //chartList[Index].minValue;
				xIndex = startIndex;
				yOld = chartList[k].data[xIndex].value;
				
				//linestr += ' ' + 0 + ',' + 0;
				if(currentEntries === 1) {
					PolylineObj = svgDoc.getElementById(chartList[k].lineName); //"polyline1");
					PolylineObj.setAttribute("stroke", "none");
					PolylineObj.setAttribute("color", chartList[k].color);
					//circleObj = svgDoc.getElementById("dot");
					//circleObj.setAttribute("fill", "blue");

				}
				else {
					for(i = 0; i < currentEntries; i ++)
					{
						/*
						if(i === 0) {
							i = currentEntries - 2;
							xIndex = i;
						}
						*/
						if(xRange === 0)
							x = ivChartXLengthLargeChart / 2;
						else
							x = ((chartList[k].data[xIndex].timestamp - startTimestampMicroSec) / xRange) * ivChartXLengthLargeChart;
						fvalue = chartList[k].data[xIndex].value;
						lineInfo += ", " + fvalue;
						xIndex ++;
						if(xIndex >= currentEntries)
							xIndex = 0;
						//y = (fvalue / g_dashboardChartList[Index].maxValue) * ivChartXYLength;
						y = ((fvalue - chartMin) / range) * ivChartYLengthLargeChart;
						if(type === 1) 
							linestr += ' ' + yOld + ',' + x; //stepLine
						//if(i >= (currentEntries -1))
						//	x = ivChartXYLengthLargeChart + 3;
						linestr += ' ' + y + ',' + x;
						yOld = y;
						if(i === 0) {
							if(currentEntries === 1) { // create a scquare
								linestr = "";
								for(s=0; s < 25; s++)
								{
									for(t=0; t < 25; t++)
									{
										if(linestr !== "")
											linestr += ' ';
										linestr += (y - 12 + s) + ',' + (x - 12 + t);
									}
								}
							}
						}
					}
					/*  Remove if no longer want to show polygon
					if(chartList.length === 1) {
						PolygonObj = svgDoc.getElementById("polygon1");
						//line1str = line1obj.getAttribute("points");
						linestr1 = linestr + ' 1,' + x + ', 1,5';
						//linestr += ' 1,' + x + ', 1,5';
						PolygonObj.setAttribute("points", linestr1);
					}
						*/	
					//PolylineObj = svgDoc.getElementById("polyline1");
					
					PolylineObj.setAttribute("color", chartList[k].color);
							
					PolylineObj.setAttribute("points", linestr);
				}
			}
			else { // hide line
				PolylineObj.setAttribute("color", "black");
				PolylineObj.setAttribute("points", "0,0");
			}
		}
		iTemp = xRange / 1000;
		sDuration = "";					
		if(iTemp < 60)
			sDuration = iTemp.toFixed(1) + " s";
		else if(iTemp < (60 * 60))
			sDuration = (iTemp / 60).toFixed(2) + " m";
		else if(iTemp < (60 * 60 * 24))
			sDuration = (iTemp / (60 * 60)).toFixed(2) + " hours";
		else 
			sDuration = (iTemp / (60 * 60 * 24)).toFixed(2) + " days";
		
		if((chartLabels === null) || (chartLabels === "x") || (chartLabels === "both")) {
			if((chartList.length === 1) && (currentEntries === 1)) {
				d = new Date();
				d.setTime(g_chartList[Index].data[startPtr].timestamp);
				time = d.toLocaleTimeString();
				dates = d.toLocaleDateString().split("/");
				str = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";
				svgDoc.getElementById("tspanX2b").textContent = str;
				svgDoc.getElementById("tspanX2").textContent = time;
			}
			else {
				d = new Date();
				d.setTime(startTimestamp);
				startDate = d.toLocaleDateString();
				//dates = startDate.split("/");
				startDateStr = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";
				startTime = d.toLocaleTimeString();

				d.setTime(endTimestamp);
				endDate = d.toLocaleDateString();
				endDateStr = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";
				endTime = d.toLocaleTimeString();

				if(startDate !== endDate)
					bShowDates;
				
				str = "";
				if(bShowDates) {
					str += startDateStr;
					svgDoc.getElementById("tspanX1b").textContent = str;
				}
				svgDoc.getElementById("tspanX1").textContent = startTime;

				iTemp = endTimestamp - startTimestamp;
				iTemp = (iTemp / 2) + startTimestamp;
				d = new Date();
				d.setTime(iTemp);
				time = d.toLocaleTimeString();
				
				str = "";
				if(bShowDates) {
					str += d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";
					dates = d.toLocaleDateString().split("/");
					svgDoc.getElementById("tspanX2b").textContent = str;
				}
				svgDoc.getElementById("tspanX2").textContent = time;

				 
				str = "";
				if(bShowDates) {
					str += endDateStr;
					svgDoc.getElementById("tspanX3b").textContent = str;
				}
				svgDoc.getElementById("tspanX3").textContent = endTime;
			}
			svgDoc.getElementById("tspanX4").textContent = sExtraStr + sDuration; // + "   " + lineInfo;
		}

	} catch (err) {}

}
function ivUpdateChartsDatalogOrig(type, Index, fvalue, timestamp) {
	// type: 0 = trend, 1 =stepline; uses timestamp
	try {
		var xIndex = 0, i, x, y, yOld = 0;
		var linestr = "", linestr1;
		var displayObj;
		var svgObj, svgDoc;
		var PolygonObj;
		var range, xRange, startTimestampMicroSec, endTimestampMicroSec;
		var chartMin;
		var startIndex;
		var currentEntries;
		var circleObj;
		var PointsPerEntry;
		var iTemp;
		var sDuration;
		var chartLabels = null;
		var lineInfo = "";
		var time,dates, str, d, startDate, endDate, startDateStr, endDateStr;;
		var bShowDates = false;
		if(g_chartList[Index] === null)
			return;
		if(g_chartList[Index].data === null)
			return;
		if(g_chartList[Index].data.length === 0)
			return;
		if(g_chartList[Index].endPtr === -1)
			return;
		var startPtr = g_chartList[Index].startPtr;
		var endPtr = g_chartList[Index].endPtr;
		var oldValue = null;
		
		if(g_chartList[Index].endPtr !== -1)
			oldValue = g_chartList[Index].data[endPtr].value;
		
		startIndex = g_chartList[Index].startPtr;
		currentEntries = g_chartList[Index].dataCurrentEntries;
		chartLabels = g_chartList[Index].chartLabels;
		
		if(timestamp !== null) {
			if(g_chartList[Index].data.length  > 0)
				g_chartList[Index].data[endPtr].timestamp = timestamp;
		}
		if(fvalue !== null) {
			if(currentEntries < ivChartTotalEntriesLargeChart) {
				endPtr ++;
				currentEntries ++;
				g_chartList[Index].dataCurrentEntries = currentEntries;
			}
			else {
				endPtr ++;
				if(endPtr >= ivChartTotalEntriesLargeChart)
					endPtr = 0;
				startIndex ++;
				if(startIndex >= ivChartTotalEntriesLargeChart) 
					startIndex = 0;
				g_chartList[Index].startPtr = startIndex;
			}
			g_chartList[Index].endPtr = endPtr;
			g_chartList[Index].data[endPtr] = {};
			g_chartList[Index].data[endPtr].value = fvalue;
			g_chartList[Index].data[endPtr].timestamp = timestamp;
		}
		
		startTimestampMicroSec = g_chartList[Index].data[startIndex].timestamp;
		endTimestampMicroSec = g_chartList[Index].data[endPtr].timestamp;
		xRange = endTimestampMicroSec - startTimestampMicroSec; // MicroSec
		range = g_chartList[Index].maxValue - g_chartList[Index].minValue;
		
		
		chartMin = g_chartList[Index].minValue;
		xIndex = startIndex;
		displayObj = g_chartList[Index].displayId;
		if(navigator.userAgent.match(/Chrome/))	
		{		
			svgObj = document.getElementById(displayObj);
			svgDoc = svgObj.contentDocument;
		}
		else
			svgDoc = document.getElementById(displayObj).getSVGDocument();
		//linestr += ' ' + 0 + ',' + 0;
		if(currentEntries === 1) {
			PolylineObj = svgDoc.getElementById("polyline1");
			PolylineObj.setAttribute("stroke", "none");
			circleObj = svgDoc.getElementById("dot");
			circleObj.setAttribute("fill", "blue");

		}
		else {
			for(i = 0; i < currentEntries; i ++)
			{
				/*
				if(i === 0) {
					i = currentEntries - 2;
					xIndex = i;
				}
				*/
				x = ((g_chartList[Index].data[xIndex].timestamp - startTimestampMicroSec) / xRange) * ivChartXLengthLargeChart;
				fvalue = g_chartList[Index].data[xIndex].value;
				lineInfo += ", " + fvalue;
				xIndex ++;
				if(xIndex >= currentEntries)
					xIndex = 0;
				//y = (fvalue / g_dashboardChartList[Index].maxValue) * ivChartXYLength;
				y = ((fvalue - chartMin) / range) * ivChartYLengthLargeChart;
				if(type === 1) 
					linestr += ' ' + yOld + ',' + x; //stepLine
				//if(i >= (currentEntries -1))
				//	x = ivChartXYLengthLargeChart + 3;
				linestr += ' ' + y + ',' + x;
				yOld = y;
			}
			PolygonObj = svgDoc.getElementById("polygon1");
			//line1str = line1obj.getAttribute("points");
			linestr1 = linestr + ' 1,' + x + ', 1,5';
			//linestr += ' 1,' + x + ', 1,5';
			PolygonObj.setAttribute("points", linestr1);
					
			PolylineObj = svgDoc.getElementById("polyline1");
					
			PolylineObj.setAttribute("points", linestr);
		}

		iTemp = xRange / 1000;
		sDuration = "";					
		if(iTemp < 60)
			sDuration = iTemp.toFixed(1) + " s";
		else if(iTemp < (60 * 60))
			sDuration = (iTemp / 60).toFixed(2) + " m";
		else if(iTemp < (60 * 60 * 24))
			sDuration = (iTemp / (60 * 60)).toFixed(2) + " hours";
		else 
			sDuration = (iTemp / (60 * 60 * 24)).toFixed(2) + " days";
		
		if((chartLabels === null) || (chartLabels === "x") || (chartLabels === "both")) {
			if(currentEntries === 1) {
				d = new Date();
				d.setTime(g_chartList[Index].data[startPtr].timestamp);
				time = d.toLocaleTimeString();
				str = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";
				svgDoc.getElementById("tspanX2b").textContent = str;
				svgDoc.getElementById("tspanX2").textContent = time;
			}
			else {
				d = new Date();
				d.setTime(g_chartList[Index].data[startPtr].timestamp);
				startDate = d.toLocaleDateString();
				startDateStr = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";
				startTime = d.toLocaleTimeString();

				d.setTime(g_chartList[Index].data[endPtr].timestamp);
				endDate = d.toLocaleDateString();
				endDateStr = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";
				endTime = d.toLocaleTimeString();

				if(startDate !== endDate)
					bShowDates = false;
				
				str = "";
				if(bShowDates) {
					dates = startDate.split("/"); 
					str += dates[2] + "-" +  ivPadStart(dates[0], "0", 2) + "-" +  ivPadStart(dates[1], "0", 2) + " ";
					svgDoc.getElementById("tspanX1b").textContent = str;
				}
				svgDoc.getElementById("tspanX1").textContent = startTime;

				iTemp = g_chartList[Index].data[endPtr].timestamp - g_chartList[Index].data[startPtr].timestamp;
				iTemp = (iTemp / 2) + g_chartList[Index].data[startPtr].timestamp;
				d = new Date();
				d.setTime(iTemp);
				time = d.toLocaleTimeString();
				
				str = "";
				if(bShowDates) {
					str += d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";
					dates = d.toLocaleDateString().split("/");
					svgDoc.getElementById("tspanX2b").textContent = str;
				}
				svgDoc.getElementById("tspanX2").textContent = time;

				 
				str = "";
				if(bShowDates) {
					str += endDateStr;
					svgDoc.getElementById("tspanX3b").textContent = str;
				}
				svgDoc.getElementById("tspanX3").textContent = endTime;
			}
			svgDoc.getElementById("tspanX4").textContent = sDuration; // + "   " + lineInfo;
		}

	} catch (err) {}

}
function ivInitializeThermometer(showvalues, nameId, displayIndex, value, min, max, units) {
	try {
	 // Thermometer, humidity and lightsensor all use similar SVG so common code can be used
	 // showvalues: 0=first intialize, 1=redraw and print numbers, 2=redraw don't print numbers. 3=only done once for web page reload 
	 var thermometerObj;
	 var thermometerSvgDoc;
	 var temp;
	 if(navigator.userAgent.match(/Chrome/))	
	 {		
		 thermometerObj = document.getElementById(nameId);
		 thermometerSvgDoc = thermometerObj.contentDocument;
	 }
	 else
		 thermometerSvgDoc = document.getElementById(nameId).getSVGDocument();
	 var bar = thermometerSvgDoc.getElementById("animateTransform76");
	 var svgMin = bar.getAttribute("from");
	 var svgMax = bar.getAttribute("to");
					 
	 dashboardDpList[displayIndex].svgMin = svgMin;
	 dashboardDpList[displayIndex].svgMax = svgMax;

	 if(showvalues === 0)
	 {
		 inVal = 23;
	 
		 thermometerSvgDoc.getElementById("tspan2492").textContent = units;
		 thermometerSvgDoc.getElementById("tspan2492").textContent = "";
		 thermometerSvgDoc.getElementById("tspan2486").textContent = ""; //inVal;
	 }
	 if((showvalues === 0) || (showvalues === 1))
	 {
		temp = min;
		temp = ivConvertValueToDisplayDecimalPlaces(temp);
		 thermometerSvgDoc.getElementById("tspan2460").textContent = temp;
		 temp = ((max - min) * .10) + min;
		 temp = ivConvertValueToDisplayDecimalPlaces(temp);
		 thermometerSvgDoc.getElementById("tspan2462").textContent = temp;
		 temp = ((max - min) * .20) + min;
		 temp = ivConvertValueToDisplayDecimalPlaces(temp);
		 thermometerSvgDoc.getElementById("tspan2464").textContent = temp;
		 temp = ((max - min) * .30) + min;
		 temp = ivConvertValueToDisplayDecimalPlaces(temp);
		 thermometerSvgDoc.getElementById("tspan2468").textContent = temp;
		 temp = ((max - min) * .40) + min;
		 temp = ivConvertValueToDisplayDecimalPlaces(temp);
		 thermometerSvgDoc.getElementById("tspan2470").textContent = temp;
		 temp = ((max - min) * .50) + min;
		 temp = ivConvertValueToDisplayDecimalPlaces(temp);
		 thermometerSvgDoc.getElementById("tspan2472").textContent = temp;
		 temp = ((max - min) * .60) + min;
		 temp = ivConvertValueToDisplayDecimalPlaces(temp);
		 thermometerSvgDoc.getElementById("tspan2474").textContent = temp;
		 temp = ((max - min) * .70) + min;
		 temp = ivConvertValueToDisplayDecimalPlaces(temp);
		 thermometerSvgDoc.getElementById("tspan2476").textContent = temp;
		 temp = ((max - min) * .80) + min;
		 temp = ivConvertValueToDisplayDecimalPlaces(temp);
		 thermometerSvgDoc.getElementById("tspan2478").textContent = temp;
		 temp = ((max - min) * .90) + min;
		 temp = ivConvertValueToDisplayDecimalPlaces(temp);
		 thermometerSvgDoc.getElementById("tspan2480").textContent = temp;
		 temp = max;
		 temp = ivConvertValueToDisplayDecimalPlaces(temp);
		 thermometerSvgDoc.getElementById("tspan2466").textContent = max;
		 
	 }
	 else
	 {
		 thermometerSvgDoc.getElementById("tspan2460").textContent = " ";
		 thermometerSvgDoc.getElementById("tspan2462").textContent = " ";
		 thermometerSvgDoc.getElementById("tspan2464").textContent = " ";
		 thermometerSvgDoc.getElementById("tspan2468").textContent = " ";
		 thermometerSvgDoc.getElementById("tspan2470").textContent = " ";
		 thermometerSvgDoc.getElementById("tspan2472").textContent = " ";
		 thermometerSvgDoc.getElementById("tspan2474").textContent = " ";
		 thermometerSvgDoc.getElementById("tspan2476").textContent = " ";
		 thermometerSvgDoc.getElementById("tspan2478").textContent = " ";
		 thermometerSvgDoc.getElementById("tspan2480").textContent = " ";
		 thermometerSvgDoc.getElementById("tspan2466").textContent = " ";

	 }
	 if(showvalues === 0)
		 ivSetThermometerValue(nameId, value, min, max, svgMin, svgMax);
	}
	catch (err) 
	{
	 //alert("InitializeThermometer" + showvalues + ", " + nameId + ", " +  type + ", " + min + ", " +  max);
	}
 }
 function ivSetThermometerValue(nameId, inVal, min, max, svgMin, svgMax) {
	 if(navigator.userAgent.match(/Chrome/))	
	 {		
		 thermometerObj = document.getElementById(nameId);
		 thermometerSvgDoc = thermometerObj.contentDocument;
	 }
	 else
		 thermometerSvgDoc = document.getElementById(nameId).getSVGDocument();
	 
	 //thermometerSvgDoc.getElementById("tspan2486").textContent = inVal;
	 
	 visValStr = ivSvgMeterScale(min,max, svgMin, svgMax, inVal);
	 bar = thermometerSvgDoc.getElementById("animateTransform76");
	 if(bar.beginElement && !navigator.userAgent.match(/Chrome/))
	 {
		 bar.setAttribute("from", bar.getAttribute("to"));
		 bar.setAttribute("to", visValStr);
		 bar.setAttribute("begin", "0s"); // required in Chrome
		 bar.beginElement();
		 bar.endElement();
	 }
	 else {
		 rect = thermometerSvgDoc.getElementById("rect");
		 actionType = "scale(" + visValStr +")";
		 rect.setAttribute("transform", actionType);
	 }

 }
 function ivSvgMeterScale(inMin, inMax, svgMin, svgMax, inVal) {
	retArray = new Array();
	var svgMinArray = svgMin.split(/\s+/g); 
	var svgMaxArray = svgMax.split(/\s+/g);
	for(var i=0; i < svgMaxArray.length; i++)
	{
		retArray[i] = ivSvgScale(inMin, inMax, svgMinArray[i], svgMaxArray[i], inVal);
		retArray[i] = ivCheckSvgVisualBoundaries(svgMinArray[i], svgMaxArray[i], retArray[i]);
	}
	ret = retArray.join(" ");
	
	return ret;
}

function ivSvgScale(inMin, inMax, outMin, outMax, inVal) {
	ret = Number(outMin)+(Number(inVal)-Number(inMin))*(Number(outMax)-Number(outMin))/(Number(inMax)-Number(inMin));
	if(ret>Math.max(outMin, outMax)) ret=Math.max(outMin, outMax);
	if(ret<Math.min(outMin, outMax)) ret=Math.min(outMin, outMax);
	return ret;
}
function ivSvgPoint(svgDoc, element, x, y) {
    // translate page to SVG co-ordinates
    if(svgDoc == null) 
        return null;
     //   var pt = g_datalogSvgDoc.createSVGPoint();
    var pt = svgDoc.documentElement.createSVGPoint();
    pt.x = x;
    pt.y = y;
    return pt.matrixTransform(element.getScreenCTM().inverse());

}
function ivCheckSvgVisualBoundaries(min, max, visVal){
	if(visVal > Math.max(min,max)) visVal = Math.max(max, min);
	if(visVal < Math.min(max, min)) visVal = Math.min(max, min);
	return visVal;
}
function ivPadStart(str, padChar, numChars) {
	var sResult = str;
	var sPad = "";
	var i, newChars;
	try {
		if(str.length < numChars) {
			newChars = numChars - str.length;
			for(i = 0; i < newChars; i++)
			{
				sPad += padChar;
			}
			sResult = sPad + str;
		}
	}
	catch {}
	return sResult;
}