/*************************************************************************************************
 *  navtree.js
 * 
 * 	Created by: Mike Wytyshyn
 * 
 *  Contains initialization, and most of the functions for the SmartServer IoT NavTree.
 *  The NavTree Web page allows you to access device datapoints. It works right out of the box.
 * 	The NavTree Web page is made up of a navigation tree and a workspace. The Navtree allows you to access context (previously setup 
 * 	with the CMS Planning Widget) and its assigned devices (which is called the context or floorplan view) and a dashboard view
 *  (which is basically a device plug-in for a single device). 
 * 
 * 	Note: This Web page was developed from the browser.html web page and so there are a lot of functions which are not used for the
 * 	NavTree functions but haven't been removed from these files.
 * 
 *  You can use NavTree with and without setting up the Planning Widget context. If you use the Planning widget you can assign custom tags 
 * 	to the context campus tag for global settings and then use custom tags for rooms or areas to specify what is seen in the floor plan View
 * 	when you are viewing the room/area   
 * 
 *  The heart of the NavTree Web page is the Navigation Tree mostly provided in the navtreeplanning.js file. Clicking a node in the tree
 * 	will display other views in the details pane. This Web page is highly customizable for each site or a group of sites. It defaults to
 * 	showing all datapoints and contexts shown in the CMS Web page. If you specify any datapoints for any of the devices then you need to 
 * 	specify all datapoints for that device, by device name, device type or program ID.
 *  
 * 	Users can control which datapoints are shown by:
 * 	1. using the visible flag for each datapoint in the Device properties widget
 * 	2. Setting global custom tags in Campus or Building context, local custom tags in the floor or room context.
 * 	3. Setting default features, device images and datapoints in the user.js file  
 * 
 *   Specific funcitons are provided 
 *  in other js files.
 * 
 *  - The initial GET for Planning and Device data, use single request for both to get all the data
 * 		- all other function require you to press a button or check a poll checkbox
 * 		- The Dashboard view automatically polls at a two second update
 *  - The browser uses WebSocket updates for the Datapoint and Favs DP functions.  
 *       It is designed to poll no faster than 10 DPs every 2 seconds.
 * 
 *  All REST request require you to encode certain character not allowed in the URI path. encodeURI and encodeURIComponent don't encode
 *  all the characters needed to be decoded by the SmartServer 
 *  	encodePathString(str) is used on the entire uri and tries to remove some characters not allowed in Device or datapont names.
 *      Otherwise use "encodeUriString(str)" on the queries substrings
 * 
 *  Datapoint and FavoriteDps
 * 	processGetDeviceDpData(mode, type, requestUrlString, json)
 * 
 *  WebSocket Datapoint update
 *  processWebSocketDpData(0, 1, "", json)
 * 
 * 	Planning
 * 	getplanningTreeShowTreeContextBuilderWithDevices(json, level, bLastChild) - primary function for building Planning navigation tree
 * 
 *  Datalog
 * 	g_iDatalogPollMode - 0= Get log data + poll log data, 1 = Get log data + poll live data, 2 = poll only live data
 * 	datalogResponseProcessData(mode, requestUrlString, json) -- builds up and updates datalog chart and table 
 * 
 * 	user specific features
 * 	getPlanningCampusContextTags() [navtreeplanning.js] - takes into account user.js and Context tags
 * 
 * 	Arrays:
 * 	dashboardDpList - contains datapoints used for context or dashboard views
 *  g_dashboardChartList - used for dashboard charts
 * 
 * 	To setup a edit button (or similar) on the floorplan view or dashboard
 * 
 *	g_bSupportWriteSwitchInContextDashboardView
 *
 *	This Web page takes into account that when a device is added to the SmartServer all datapoint values are null or after a power up some datapoints 
 *	are null until the SmartServer reads the datapoint.  In this case, input, span elements, and in some cases LED/switch elements are left blank 
 *	initially and will populate automatically as datapoint values are read.
 *
 *	This Web page takes into account that you may have more than one Web Socket Web page that is open for this user. Like the CMS Web page the NavTree
 *
 * 	When viewing datapoints the Web Page will periodically send out a WebSocket subscribe list 
 * 
 *  Copyright (C) 2022 EnOcean GmbH.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	Renesas IzoT(tm) Software Developer's Kit License Agreement which is 
 *	available at www.dialog-semiconductor.com/license/izot_sdk/.  
 * 
 ***************************************************************************************************/
 var g_sNavTreeVersion = "1.18";

 /**************************************************************************
  * Constants
  * 
  *************************************************************************/
 
  // enums - Do not change
let ALL = 0xF; // owner CMS user-type
let ADMIN = 8; // owner CMS user-type  - apollo user
let OWNER = 4; // owner CMS user-type
let SUPERVISOR = 2;// supervisor CMS user-type
let USER = 1; // user CMS user-type
let NONE = 0; // user CMS user-type

 /**************************************************************************
  * User settable variables
  * 
  *************************************************************************/
var g_bUseWebSockets = true; // true = use Websockets to get datapoint updates [default], false = use GET response for datapoint updates
var g_bHideSubscribeButton = true; //Used only with g_bUseWebSockets, false=always show re-subscribe button
var g_iAutoSubscribeRate = 4; // 0= disabled, number indicates how many times entire Dps list is Retrieve with GETs. 
								// If 20 dps takes 2 GET request, a rate of 2 will cause subscribe every 4 GETs.
								// Due to conflict with multitple WebSockets Webpages using same login, need to re-subscribe periodically 
var g_bSingleUserType = true; // false=different device types for each user type (owner,supervisor or user), true=same for all user types [default]
var g_useVisibilityFilter = ALL; // use user-type CONSTANTs (Must be all CAPS) - Follow Datapoint Properties Widget visible flag, NONE - show all datapoints  
var g_bShowDevicesInTree = ALL; // used to show devices in tree - use user-type CONSTANTs (Must be all CAPS)
var g_bDisplayDevicesStatusInFooter = ADMIN; // use user-type CONSTANTs (Must be all CAPS)
var g_iShowTree = ALL;
var g_bShowDeviceStatusInTree = ALL; // use user-type CONSTANTs (Must be all CAPS)
var g_bShowDeviceStatusInDashboard = ALL; // use user-type CONSTANTs (Must be all CAPS)
var g_bShowDeviceStatusInFloorplan = ALL; // use user-type CONSTANTs (Must be all CAPS)
var g_bShowAllDeviceStatus = ALL; // use user-type CONSTANTs (Must be all CAPS)
var g_showAdvancedCheckbox = NONE; // use user-type CONSTANTs (Must be all CAPS)
var g_bUseChartForAllInputs = false; // false [default] Applies to scalars only (numbers)
var g_bUseChartForAllOutputs = true; // true [default] Applies to scalars only (numbers)
var g_iDashboardDatalogRangeDropdown = 2; // 0=no data logs, 1=10min, 2= 1 hour [default], 3 = 1 day. this may slow down Device Web signifantly if data log to big
var g_iDashboardDatalogRange = 60; //in minutes,  changed if g_bDashboardOptionsMenu = true
var g_iDashboardChartDuration = 0; //0= none [default], 1= 1 hour, 2 = 1 hour, 3 = 1 day
var g_iCurrentPriorityButtonType = 2; // 0=don't show, 1= "...", 2 = "P <priority>" when priority and use "..." with no priority
var g_OwnerUserTypeWritePriority = "all"; //"all" = can write all priorities [default], "8" = write at priority 8 only, ">8" can write at priority 9 and below.
var g_OwnerUserTypeClearPriority = "all"; //"all" = can write all priorities [default], "8" = write at priority 8 only, ">8" can write at priority 9 and below.
var g_supervisorUserWriteTypePriority = "all"; //"all" = can write all priorities [default], "8" = write at priority 8 only, ">8" can write at priority 9 and below.
var g_supervisorUserTypeClearPriority = "all"; //"all" = can write all priorities [default], "8" = write at priority 8 only, ">8" can write at priority 9 and below.
var g_userUserTypeWritePriority = "all";  //"all" = can write all priorities [default], "8" = write at priority 8 only, ">8" can write at priority 9 and below.
var g_userUserTypeClearPriority = "all";  //"all" = can write all priorities [default], "8" = write at priority 8 only, ">8" can write at priority 9 and below.
var g_bShowRoomTableContextOnImage = true; // true=show table in image, false=show after image like floor
var g_sTreeDevicesNoContent = "Click specific device";
var g_sTreeNoContent = "No Content"; // "No Content" [default] What text to put when Campus, Building and Devices node clicked  
var g_iContextTableOffsetX = -50; // used for floorplan Context table or text
var g_iContextTableOffsetY = 40;
var g_iShowTreeWhenNoContexts = OWNER; // only ownwer see Web page when no contexts in Planning Widget
var g_NoContextsMessage = "Please Contact Site Administrator"; // If no contexts in Planning Widget
var g_iShowAlarms = ALL; // shows datapoint alarms in context and dashboard, RED=high Alarm, orange=high warning, yellow=low warning, 
var g_iClearAlarms = ALL; // allows you to clear alarms in dashboard
var g_alarmColors = ["white","cyan","yellow","orange","pink"]; //white = no alarm
var g_sTableDeviceDownColor = "pink";
var g_bShowDpDeviceDown = true; // some users may not want to show device status on datapoint values (if communication is spotty)
var g_iAlarmDisplayType = 3; //0: none, 1=coloronly, 2=bell only, 3=color plus bell
var g_bShowDeviceListBasedOnProgramId = true; // used for campus, building, room and unassigned devices.  May only be initially supported by unassigned devices.
var g_bShowDeviceTypeInDashboard = true;
var g_iShowContextDpLabels = 0; // 0=don't show labels next left of value, 1=show label left of value, 2=same as 1 but show device name in title
var g_iShowContextToolTip = 2; // 0=don't show context tool tip, 1=show path, 2=show label for tool tip, 3=show label + path)
var g_iShowDashboardDp = 3; //0=dp path, 1= label only, 2= label + [path], 3 = label + path tooltip
var g_iDashboardMaxNumberOfDatapointsAllowed = 100;
var g_bSiteDashboardClickDpPathToDevice = true;
var g_iShowUnassignedDevicesInTree = ALL;
var g_bShowUnassignedDevicesInTree = true;
var g_bSupportWriteSwitchInContextDashboardView = true;
var g_bPreloadAllSnvtTypes = true;
var g_bShowDeviceDashboardBreadCrumbs = true;
var g_bDeviceDashboardHidePrioirtyColumnInNonEditMode = true;
var g_iDashboardSpanRounded = 5; // used for spans on top of images

var g_iShowCalendar = ADMIN; // used to show calendar for only devices that user has access to  
var g_iShowScheduleButtonInMenu = ADMIN; // used to show calendar for specific datapoint in Context or dashboard views
var g_iShowEventCountInCalendar = ALL;
var g_bShowEventCountInCalendarDefaultShow = true;
var g_iShowEventEdit = ALL;
var g_bUseFixedSunsriseSunset = false;  // fixed times are sunrise at 06:00 and sunset at 18:00
var g_iShowDeviceTestButton = OWNER;// used to show test and wink buttons on dashboard
var g_bZoomChartSupported = true;
var g_iAllowSaveChartData = ALL;
var g_iIoxHighestPriority = 17;
var g_bIoxUseDefaults = true; // Use the built in IOX devices datapoints, set to false if you want to see all datapoints
var g_bIoxShowLedsOnImage = true; // used to show 
var g_iIoxShowLedsOnImageDiX = 87;
var g_iIoxShowLedsOnImageDiDeltaX = 10;
var g_iIoxShowLedsOnImageDiY = 203;
var g_iIoxShowLedsOnImageDoX = 192;
var g_iIoxShowLedsOnImageDoY = 95;
var g_bMeterShowToolTips = true;

var g_bShowDeviceLogsInDashboard = true;
var g_bShowDeviceLogsInDashboardShowOnlySpecifiedDatapoints = false; // not implemented yet. When getting device logs only show datapoints that are used on the dashboard
var g_bShowDeviceSchedulesInDashboard = true;
var g_iMaxDataLogMBSizeSupported = 1000; //in MB, 1GB = 1000 MB; -1: don't check;
var g_bDashboardSiteReadonly = false; // makes sure site dashboard, campus, and building are only readonly
var g_bShowEps = true; // shows in footer
var g_bShowEpsWarningColors = true;
var g_bShowCpu = true; // shows in footer
var g_bShowTimezone = true;
var g_bShowCmsVersion = true;
var g_bShowMouseXY = false; //This is useful for looking at positions on a graphic
var g_sSitedashboardType = "";
var g_sSitedashboardName = "";
var g_bShowLegendDiv = false; // default state of showing legend under tree.

 /**************************************************************************
  *  Internal variables only
  * 
  *************************************************************************/
var g_bShowTree = true;
var g_bCheckUser = true;
var g_currentUser = null; 
var g_currentUserType = null; // OWNER, SUPERVISOR, USER
var g_bShowIfBackgroundPollingPaused = true; // indicates if the CMS Device Widget monitor is play/pause
var g_customerId = "";
var bivUseWebSockets = true; // true = use Websockets to get datapoint updates [default], false = use GET response for datapoint updates
var g_iSmarserverSid = "";
let g_sAllDevicesStatus = "";
var g_bSingleWebpage = false;
var g_bIngnoreDisplayingDeviceDeviceStatus = true; // used to only show device status after getting planning context info,
var g_bShowOnlyProvisionedDevice = true; //For get request
var g_bShowOnlyProvisionedDevicesOnSiteDashboard = true; // used for site Dashboard and context to only show provisioned devices
var g_bShowDashboard = true;
var g_bShowAllDevicesUnderContext = true;
var g_bDashboard_UseChartForAllBacnetAvs = false;
var g_bUsePriorityForAllWrites = true;
var g_bUseLocalizationForAllWrites = true;
var g_bUsePriority17ForNewValue = false;
var g_bUpdateCharts = false; //used for dashboard and data log chart
var g_iDatalogChartMode = 0; // 0=add event, 1= new values
var g_bEnableDataLogLiveData = true;
var g_iDatalogPollMode = 1; // 0=data log only, 1= data log + live polling, 2=live only
var g_bDashboardUpdateCharts = false;
var g_bShowDatalogChart = true; // currently only shows up if a single scalar datapoint is charted
var g_iDatalogChartLineType = 1; //  0=trend,1=stepline
var g_bDatalogChartYMinMax = true; // dynamic min range, true = min max, false = full ( 0 to max)
var g_bAutoSubscribe = true;
var g_bUseDeviceIdForDataLogWebSocket = true; //1234567 true;
var g_bDataLogWebSocketWorkaround = false; //needed when trying to get datalog for specific device, gets all logs and then filter on
let g_iSmartServerVersion = 0;
var g_sSmartServerVersion = "";
var g_sDpNeedUpdating = ""; //used when DP priority removed
var bDataLogShowInConsole = false;
var g_bUseWebSocketsForDataLog = true;
var g_iPlanningTreeShowDevices = 0; // used to show planning tree devices or Context details
var g_iMax_Age = 2;
var g_bShowPollIntervalInConsole = true;
var g_bPollingEnabled = false;
let g_bGetDeviceList = true;
let GET_ALL_DPS_MAX_NUMBER_DEVICES = 10; // if exceeded get all DPs don't show Get all DPs Datapoints
var g_iTimerInterval = 1000;
var g_iMaxOfDpsToPollPerInterval = 10; //5;
var g_iFeedbackDelayTime = 10000; // 5 * 1000
var g_timerId = 0;
let g_iPollRate = 5; // poll rate specified in Datapoints and Favorite
let g_iBackgroundPollingRequestCount = -1; // time between GET requests
let g_iBackgroundPollingRequestCountMax = 2; // time between GET requests 2 second polling rate
let g_iBackgroundPollingRequestExtended = 0;
let g_iPollingRequestCount = -1; // controlled by polling checkbox -1=disabled
let g_iPollingRequestCountMax = 2; // UI controlled Polling interval
var g_contextImages = [];
var deviceListAll = [] ;
var deviceList = [];
var deviceDpList = []; // used for dashboard Device Dp List
var dpList = []; // Used for Datapoints List
var g_dpList = []; // nav tree
var favDpList = []; // list Favorite Dps
var g_favDpList = []; // nav tree
var dlaList = [];
var alarmTypeList = [];
var dlaAlarmList = [];
var deviceTypeList = [];
var planningList = [];
var groupList = [];
var schedulesList = [];
var g_schedulesListOrig = [];
var g_dpGetRequestArr = [];
var contextViewList = []; // /api/context
var g_bInitialization = true;
var g_sfavDpFavoriteName = "";
let g_ArrPaginationResponse = [];
var g_epsInfo = {};
var g_snvtTypes = [];
var g_siteDashboardReplacementList = [];
var g_deviceTypesReplacementsDeviceType = [];
var g_deviceTypesReplacementsProgramId = [];
var g_deviceTypesReplacementsDpList = [];
var g_bAtLeastOneElementUsesPriority = false; //If any priority_span or clearoverride_button then driver periodically needs to read properties instead of just value 

var g_bIgnoreNewDeviceDetection = false;
var g_bIgnoreNewDeviceDeleted = false;
var g_sUpdateDataPoint = "";
var g_iUpdateDataPointCount = 0;
var g_sDevicesContext = "";
var g_sDeviceFilter = "";
var g_oDeviceFilter = {};
var g_sDpFilter = "";
var g_oDpFilter = {};
var g_sDlaDpFilter = "";
var g_oDlaDpFilter = {};
var cmsFavoritesList = [];
var g_bReadCmsFavoritesList = false;
var g_bServicePinShowNewDevicesOnly = true;


var g_idpGetRequestIndex = 0;
var g_idpGetPropertiesRequestCount =0; //-1=disable getting properties update
var g_idpGetPropertiesRequestMaxCount = 4; // GET properties takes more horse power than GET values
var g_sWebSocketSubscribePayload = "";
var g_sWebSocketSubscribePayload_oldvalue = "";
var g_sOnDemandDpRequestUrl = "";
var activeAlarmList = [];
var g_sActiveAlarmList = "";
var alarmDefinitionList = [];
var g_sAlarmDefinitionList = "";
var g_iDisplayIndex = 0;
var g_iMainDisplayMode = 0;
var g_PollingType = 0; //0=nothing active 1=All Device, 2 =Selected Devices, 3=datapoint list, 4=favorite dps, 5=active alarms
var DISPLAYMODE_NONE =0, DISPLAYMODE_ALLDEVICES =1, DISPLAYMODE_DEVICES = 2, DISPLAYMODE_DPS = 3, DISPLAYMODE_FAVDPS = 4, DISPLAYMODE_ACTIVEALARMS = 5;
var DISPLAYMODE_DLA = 6, DISPLAYMODE_DEVICETYPES = 7, DISPLAYMODE_APITESTER = 8, DISPLAYMODE_DATALOG = 9, DISPLAYMODE_PLANNING = 10, DISPLAYMODE_SCHEDULE = 11;	
var DISPLAYMODE_CONTEXTVIEW = 12, DISPLAYMODE_GROUPS = 13, DISPLAYMODE_SERVICEPIN = 14, DISPLAYMODE_ONETIMEPOLL = 15, DISPLAYMODE_DASHBOARD = 16, DISPLAYMODE_CONNECTIONS = 17; 
var DISPLAYMODE_DPINFO = 18; // combines information - DLA,connections, schedules
var DISPLAYMODE_DATALOGLIVEPOLL = 19, DISPLAYMODE_DATALOGONETIMELIVEPOLL = 20, DISPLAYMODE_NODERED = 21, DISPLAYMODE_EXPORT = 22; // used for pollingtype, when doing live polls
var g_dtPollEndDate, g_dtPollStartDate;
var g_dtPollGetRequestArrStartTime, g_dtPollGetRequestArrEndTime; // Each poll may require breaking up large number of DPs into multiple request. Start is for first packet, end is last packet
var g_IgnoreTableValueChangeFor = " ";
var g_IgnoreTableValueChangeForCurrentValue = " ";
var g_iDeviceTestMode = -1; // any other name points to device id
var g_iDeviceTestId = -1;
var g_iDeviceTestDeviceName = "";
var g_iDeviceTestModeContent = "";
var g_bInoreMouseClick = false;
var g_bAlwaysIngnoreMouseClick = false;
var g_iArrPaginationResponse = [];  //
var g_iPaginationPage = 0; // Used for GET pagination
var g_iPaginationPageSize = 100; // Used for GET pagination
var g_iPaginationSnapsnotNumber = 0; // Used for GET pagination
var g_bAbort = false;
var dataLogDpList = []; // used for showing delta value and delta time for specific DP
var dataLogList = [];
var dataLogDpUrlList = []; 
var datalogLiveDataDpList = [];
var g_bDatalogPollingEnabled = false;
let g_bFavoritesPollingEnabled = false;
let g_iFavoritesPollInterval = 5;
let g_bDatapointsPollingEnabled = false
let g_iDatapointsPollInterval = 5;

var dataLogDateList = [];
var schedulePathnameList = [];
var scheduleDurationList = [];
var contextList = [];
var g_sNodeRed = "";
var g_sConnections = "";
var g_sConnectionsDpName = "";
var g_sConnectionsDpDeviceType = "";
var g_sConnectionsDpDeviceName = "";
let g_sSchedulePathname = "all";  // when not "" = all schedules  events, for specific device is device name, for datapoint use datapoint dpQualifier
let g_sScheduleProgrammaticPathname = "";
let g_scheduleUrlDpXifList = []; // list of datapoint name and corresponding XIF name for url,otherwise we have to additional request to figure out datapoint xif name
let g_scheduleJsonResponse = []; // used to temporarity hold the schedule data while getting the datapoint instance name from a XIF name GET request
let g_sScheduleRange = "week (sun - sat)";  // week,day,month,year,custom 
var g_sDatalogHtmlHeaderContent = "";
var g_sDatalogHtmlContent = "";

var g_sApiTesterHeaderHtmlContent = "";
var g_sApiTesterHtmlContent = "";
var g_sScheduleHeaderHtmlContent = "";
var g_sScheduleHtmlContent = "";
var g_sPaneHtmlContentList = [];
var g_sPlanningPaneContent = "";
var g_sDashboardPaneTitleContext = "";
var g_sDashboardMainContent = "";
var g_planningFloorplanObjs = {};
var g_planningFloorplanGroups = [];
var g_sDpInfoPaneContent = "";
let g_sDpInfoPaneTitle = "";
var g_sDpInfoPathname = "";
var g_sDpInfoProgrammaticPathname = "";
var g_dpInfoContextList = [];
var g_bDpInfoForDevice = false;
var g_bDpInfoShowDatalogButton = false;
var g_sActiveAlarmsPaneContent = "";
var g_sActiveAlarmsAlarmDefinitionsPaneContent = "";
var g_apiPaneData = null;
var g_dataLogPaneData = null;
let g_bShowGetAllDatapoints = false;
var g_datalogWsClient = null;  // node.js to SmartServer Server
var g_bDataLogGetInProgress = false;
var g_iDataLogMaxToShow = 20000;
var datalogPaneContent = "";
var g_datalogJson = [];
let g_bDatalogUrlChanged = false; // used for datalog live polling, When checking the polled checked box, and this variable set then need to restart
var g_sDataLogDpPath = "";
var g_sDataLogDpProgrammaticPath = "";
var g_datalogUrlDpXifList = []; // list of datapoint name and corresponding XIF name for url,otherwise we have to additional request to figure out datapoint xif name
let g_datalogUrlDpInstanceNamesList = []; // list ofDp instance names that need to be converted to Xif names
var g_sDataLogDate = "";
var g_dtDataLogStartTime = null; 
var g_dtDataLogReceiveTime = null;
var g_bDatalogAborted = false;
var g_iDataLogSortInterations = 0;
var g_iDataLogPollCount = 0;
var g_iDataLogPollCountMax = -1;
var g_iDataLogLatestTimestamp = null;
var g_iDataLogPollrate = 10; // sec
var g_iDataLogLiveDataPollrate = 5; // sec
var g_iDatalogLiveDataPollEnabled = false;
var g_sDataLogPollRequest = "";
var g_sDataLogDuration = "";
var g_sDataLogStartTime = ""; 
var g_dataLogJson = []; // used for sorting data log data
let g_bDatalogStartGetRequest = false;
let g_bdatalogLiveDataConfigured = false; // used to make sure you don't have recursive function calls by mistake
var g_sDlaByName = "";

var g_bTestDevicesAlreadyStarted = false;
var g_iTestDeviceAllTimeout = 15000;
var g_bTestDevicesPaused = 0; // 0=start, 1 = pause, 2 = cancel
var g_iTestDevices_RestTimeout = 0;
var g_iTestDeviceTestTimeMs = 0; // used because test can be paused
var g_iTestDevices_Tested = 0;
var g_testDevicesList = [];
var g_iTestDevices_Total = 0;
var g_iTestDevices_TotalEdgeDevices = 0;
var g_bTestDevicesInProgress = false;
var g_iTestDevices_Passed = 0;
var g_iTestDevices_Uprovisioned = 0;
var g_iTestDevices_Down = 0;
var g_iTestDevices_Failed = 0;
var g_iTestDevicesTimerId = null;
var g_bTestDevices_provisionedDevicesOnly = true;
var g_iTestDevices_QueryStatusFailed = 0;
var g_testallDeviceFailList = [];
var g_testDevices_IOX = 0;
var g_testDevices_IOX_UnProvisioned = 0;
var g_bShowDeviceDashboard = true;
var g_userList = [];

var g_iAlarmTimerId = null;
var g_iLastAlarmMs = 0;
var g_bAlarmsCountRequestInProgress = false;
var g_bShowAlarms = false;
var g_bAllowedToClearAlarms = false;
var g_deviceAlarmsList = [];
var g_b12hourClock = false;




var g_bShowCalendar = true;
var g_bShowScheduleButtonInMenu = true;
var g_bShowEventCountInCalendarAllow = true; 
var g_bShowEventCountInCalendar = true;
var g_bShowEventEdit = true;
var g_bMenuDatapointsShowSelected = false;
var g_menuDatapointsEventDatapoints = [];
var g_dLatitude = -1;
var g_dLongitude = -1;
var g_SmartServerTimeZone = "";
var g_sTimezoneString = "";
var g_bShowDeviceTestButton = false;// used to show test and wink buttons on dashboard
var g_bAllowSaveChartData = true;
var g_bReadonly = false; // used to specify if user only has readonly for all datapoints
var g_bViewWriteEnabled = false; // true=show write enable switch (default readonly), false=writes are used with g_bSupportWriteSwitchInContextDashboardView

var g_iAutoSubscribeCount = 0;
var g_iAutoSubscribeCountRequestIndex = 0; // distributes subscribe so if there is more than one datapoint request that eventually all datapoints get read 
var g_iShowEditButton = 1; //g_iShowEditButton: 0=disabled, 1=show switch (default readonly), 2=show switch(default write)
var g_bEditModeEnabled = false;
var g_editButtonElementList = []; // this list is used to change html elements in the floorplan and dashboard depending on what the edit button state.
								// for example, if the edit button is supported and editing is disabled then disable the writeable elements.
								// the Each obj will contain the displayId, type (input, dropdown s2-4) and what action (disable,visiblity) for edit/non-edit state
var g_fDatalogSize = 0;
var g_bMaxDataLogSizeNotReached = true;
var g_iCheckIfGettingCpuUpdates = 0;
var g_bCpuUpdateTimeout = false;
var g_cpuTimerId = 0;

var g_iTotalEpsLowWarning = 100000;
var g_iTotalEpsHighWarning = 100000;
var g_bPauseMainTimer = false; // used to pause sendnext and chart update during WebSocket Error confirm

function init1() {
	var i, iPtr, temp, url, d, sTemp, element;
	var displayElement;
	var tokens = [];
	var obj;
	g_bInitialization = true;
	initializeDisplay();
	g_bShowMouseXY = false; //This is useful for looking at positions on a graphic
	g_sSitedashboardType = "";
	g_sSitedashboardName = "";
	g_iShowTree = ALL;
	g_bShowTree = true;
	g_sSmartServerVersion = "";
	g_iSmarserverSid = "";
	g_iDisplayIndex = 0;
	g_bSingleWebpage = false;
	g_iMainDisplayMode = DISPLAYMODE_PLANNING;
	g_PollingType = DISPLAYMODE_NONE;
	g_iDatalogPollMode = 1; // 0=data log only, 1= data log + live polling, 2=live only
	g_bDatalogPollingEnabled = false;
	g_bFavoritesPollingEnabled = true;
	g_iFavoritesPollInterval = 5;
	g_bDatapointsPollingEnabled = true;
	g_iDatapointsPollInterval = 5;
	g_iBackgroundPollingRequestCount = -1;
	g_BackgroundPollingRequestCountMax =2; // using fixed 2 second poll rate
	g_Max_Age = 2;
	g_iContextTableOffsetX = -50; // used for floorplan Context table or text
	g_iContextTableOffsetY = 40;
	g_sWebSocketSubscribePayload = "";
	g_sWebSocketSubscribePayload_oldvalue = "";
	g_sOnDemandDpRequestUrl = "";
	g_dpGetRequestArr = [];
	g_bPollingEnabled = false;
	g_bNeedToSubscribe = true; // change to false when starting to use Web socket dp updates
	g_dtPollStartDate = new Date();
	document.getElementById("menuDiv").className = "menuDivHide";
	document.getElementById("testDiv").className = "testDivHide";
	g_iDeviceTestMode = -1;
	g_iDeviceTestId = -1;
	g_iDeviceTestModeContent = "";
	g_bIngnoreDisplayingDeviceDeviceStatus = true; // used to only show device status after getting planning context info,
	g_contextImages = [];
	deviceListAll = [] ;
	dlaList = [];
	deviceTypeList = [];
	planningList = [];
	planningDpList = [];
	groupList = [];
	schedulesList = [];
	g_dpGetRequestArr = [];
	deviceList = [];
	deviceListAll = [];
	deviceDpList = [];  
	dpList = [];
	favDpList = [];
	g_dpList = []; // nav tree
	g_favDpList = []; // nav tree
	g_idpGetRequestIndex = -1;
	dataLogDpList = [];
	dataLogList = [];
	g_datalogUrlDpXifList = [];
	datalogLiveDataDpList = [];
	g_bdatalogLiveDataConfigured = false;
	contextList = [];
	contextViewList = [];
	activeAlarmList = [];
	g_sActiveAlarmList = "";
	alarmDefinitionList = [];
	alarmTypeList = [];
	dlaAlarmList = [];
	g_siteDashboardReplacementList = [];
	g_bShowOnlyProvisionedDevice = true; //For get request
	g_bShowOnlyProvisionedDevicesOnSiteDashboard = true; // used for site Dashboard and context to only show provisioned devices
	g_sAlarmDefinitionList = "";
	g_sNodeRed = "";
	g_sConnections = "";
	g_sConnectionsDpName = "";
	g_sConnectionsDpDeviceType = "";
	g_sConnectionsDpDeviceName = "";
	g_sPlanningPaneContent = "";
	g_sDashboardPaneTitleContext = "";
    g_sDashboardMainContent = "";
	g_paneHtmlContentList = [];
	cmsFavoritesList = [];
	g_apiPaneData = null;
	g_dataLogPaneData = null;
	g_sDlaByName = "";

	g_bShowDeviceDashboardBreadCrumbs = true;
	g_bShowDeviceDashboard = true;
	g_userList = [];
	
	g_datalogJson = [];
	g_sDeviceFilter = "";
	g_oDeviceFilter = {};
	g_sDpFilter = "";
	g_oDpFilter = {};
	g_sDlaDpFilter = "";
	g_oDlaDpFilter = {};
	g_sSchedulePathname = "";
	g_sDpInfoPaneContent = "";
	g_sDpInfoProgrammaticPathname = "";
	g_sDpInfoPathname = "";
	g_sSchedulePathname = "All";
	g_sScheduleProgrammaticPathname = "";
	g_dpInfoContextList = [];
	g_bDpInfoForDevice = false;
	g_bDpInfoShowDatalogButton = false;
	g_sActiveAlarmsPaneContent = "";
	g_sActiveAlarmsAlarmDefinitionsPaneContent = "";
	g_sDevicesContext = "";

	g_bSiteDashboardClickDpPathToDevice = true;
	
	g_planningFloorplanObjs = {};
	g_planningFloorplanGroups = [];
	g_bIgnoreNewDeviceDetection = false;
	g_bIgnoreNewDeviceDeleted = false;
	g_bShowLegendDiv = false; // default state of showing legend under tree.

	planningInit();
	calendarInit();
	g_scheduleUrlDpXifList = [];
	g_scheduleJsonResponse = [];
	g_bServicePinShowNewDevicesOnly = true;
	g_bDatalogPollingEnabled = false;
	g_bUseChartForAllOutputs = true;
	g_bUseChartForAllInputs = false;
	g_bDashboardPollEnabled = true;
	g_iDashboardDatalogRangeDropdown = 2; // 1 hour
	g_iDashboardDatalogRange = 60; //min
	if(g_bDashboardOptionsMenu) {
		if(g_iDashboardDatalogRangeDropdown === 0)
			g_iDashboardDatalogRange = 0;
		else if(g_iDashboardDatalogRangeDropdown === 1)
			g_iDashboardDatalogRange = 10;
		else if(g_iDashboardDatalogRangeDropdown === 2)
			g_iDashboardDatalogRange = 60;
		else if(g_iDashboardDatalogRangeDropdown === 4)
			g_iDashboardDatalogRange = 24 * 60;
	}
	g_iDashboardChartDuration = 0;  // 1 hour
	g_bApiEncodeRequestStr = true;
	g_epsInfo = {};
	g_deviceAlarmsList = [];

	if(g_iTestDevicesTimerId !== null) 
		clearTimeout(g_iTestDevicesTimerId);
	g_bTestDevicesAlreadyStarted = false;
	g_iTestDevicesPaused = 0; // 0=start, 1 = pause, 2 = cancel
	g_iTestDevices_RestTimeout = 0;
	g_iTestDeviceTestTimeMs = 0; // used because test can be paused
	g_iTestDevices_Tested = 0;
	g_testDevicesList = [];
	g_iTestDevices_Total = 0;
	g_iTestDevices_TotalEdgeDevices = 0;
	g_bTestDevicesInProgress = false;
	g_iTestDevices_Passed = 0;
	g_iTestDevices_Uprovisioned = 0;
	g_iTestDevices_Down = 0;
	g_iTestDevices_Failed = 0;
	g_iTestDevicesTimerId = null;
	g_bTestDevices_provisionedDevicesOnly = true;
	g_iTestDevices_QueryStatusFailed = 0;
	g_testallDeviceFailList = [];
	g_testDevices_IOX = 0;
	g_testDevices_IOX_UnProvisioned = 0;

	if(g_iAlarmTimerId !== null) 
		clearTimeout(g_iAlarmTimerId);
	g_iAlarmTimerId = null;
	g_iLastAlarmMs = 0;
	
	g_bMeterShowToolTips = true;
	g_iShowContextDpLabels = 0;
	g_iShowContextToolTip = 3;
	g_iShowDashboardDp = 3; //0=dp path, 1= label only, 2, label + path tooltip

	g_iTotalEpsLowWarning = 100000;
	g_iTotalEpsHighWarning = 100000;

	g_iCheckIfGettingCpuUpdates = 0;
	g_bCpuUpdateTimeout = false;
	g_cpuTimerId = 0;
	if(g_bShowCpu) {
		g_iCheckIfGettingCpuUpdates = 1;
		g_bCpuUpdateTimeout = true;
	}

	g_iMenuDpCurrentPage = 1;
	g_iMenuDpPageSize = 50;
	g_iMenuDpCount = 0;
	element = document.getElementById("top-Container"); //"main");
	if(element !== null) {
			element.innerHTML = "<div class=\"gettingInfoSpinnerLog\" style=\"width:100%\">" + addWaitSpinner(1) + "</div>";
	}
	element = document.getElementById("footerStatus1");
	if(element !== null)
		element.innerHTML = "";
	
	element = document.getElementById("footerStatus3");
	if(element !== null)
		element.innerHTML = "";

	configureDashboardChartsParameters();
	datalogChartInit(0, null);
	clearDpFilter(0, 0, 0); // clear all
	clearDlaFilter(0, 0, 0); // clear all
	displayElement = document.getElementById("navTreeVersion");
	if(displayElement !== null)
		displayElement.innerHTML = " (" + g_sNavTreeVersion + ")";
	schedulePathnameList = [];
	schedulePathnameList[0] = "all";
	schedulePathnameList[1] = "Sensor1";
	schedulePathnameList[2] = "Sensor1/Lamp/0/nvoValueFb";
	schedulePathnameList[3] = "PulseGen/device/0/nviCount";
	scheduleDurationList = [];
	scheduleDurationList[0] = "all";
	scheduleDurationList[1] = "day";
	scheduleDurationList[2] = "week (sun - sat)";
	scheduleDurationList[2] = "week (mon - sun)";
	scheduleDurationList[3] = "month";
	scheduleDurationList[4] = "year";
	scheduleDurationList[5] = "range: ";
	g_sSchedulePathname = "all";  // when not "" = all schedules  events, for specific device is device name, for datapoint use datapoint dpQualifier
	g_sScheduleRange = "week (sun - sat)";
	g_deviceTypesReplacementsDeviceType = [];
	g_deviceTypesReplacementsProgramId = [];
	g_deviceTypesReplacementsDpList = [];
	g_bShowDevicesInTree = ALL;
	g_iShowUnassignedDevicesInTree = ALL;
	g_bShowUnassignedDevicesInTree = true;
	g_iShowCalendar = ADMIN;
	g_bShowCalendar = true;
	g_iShowScheduleButtonInMenu = ADMIN;
	g_bShowScheduleButtonInMenu = true;
	g_iShowEventCountInCalendar = ALL;
	g_bShowEventCountInCalendarDefaultShow = true; 
	g_bShowEventCountInCalendarAllow = true; // determined by g_iShowEventCountInCalendar
	g_bShowEventCountInCalendar = true; // can be enabled or disable by calender menu
	g_iShowEventEdit = ALL;
	g_bShowEventEdit = true;
	g_bScheduleEventInProgress = false;
	g_SmartServerTimeZone = "";
	g_sTimezoneString = "";
	g_bShowDeviceTestButton = false;// used to show test and wink buttons on dashboard
	g_iShowEditButton = 1; //g_iShowEditButton: 0=disabled, 1=show switch (default readonly), 2=show switch(default write)
	g_bEditModeEnabled = false;
	g_editButtonElementList = [];
	g_fDatalogSize = 0;
	g_iMaxDataLogMBSizeSupported = 1000; //in MB, 1GB = 1000 MB; -1: don't check; if data log in SmartServer exceeds this value don't read datalog as it can take too long
	document.documentElement.style.setProperty("--switchslider-backgroundColor", g_sSliderBackgroundColor);
	g_bFirstTimeRunningZoomChart = true; // required for chrome
	g_bImagesLoaded = []; // used to preload svg images
	for(i=0; i < g_bImagesLoadedCount; i++)
		g_bImagesLoaded[i] = false;
	g_oGlobalTags = {}; // user specific tags defined in the user.js file
	g_bPauseMainTimer = false; // used to pause sendnext and chart update during WebSocket Error confirm
	g_oCmsOptomizedData = null;
	g_oProtocols = null;
	_chartInit();
	dashboardInit();
	userinit(); //user.js file deviceTypeReplacements();
	ivWebSocketInitize();
	
	if(g_bDashboardSupportDisplayMouseToolTip) {
		g_bDashboardDisplayMouseToolTip = true;
		g_bDashboardDisplayMouseToolTipShowPresets = true;
	}
	
	if(!(typeof g_features_Quadcore_iMaxOfDpsToPollPerInterval === "undefined")) {
		g_iMaxOfDpsToPollPerInterval = g_features_Quadcore_iMaxOfDpsToPollPerInterval;
	}
		
	if(!g_bShowDashboard)
		document.getElementById("dashboardButton").display = "none";
	
	window.onscroll = function() {scrollFunction()};
	//try {
	//	if(g_timerId === 0)
	//		g_timerId = window.setInterval("timerHandler()", g_iTimerInterval);
	//} catch (err) {} 
	cursorSetWait(); //
	//document.getElementById("top-Container").style.cursor = "wait"; 
	//document.getElementById("main-Container").style.cursor = "wait"; 
	g_sDevice = "";
	g_UrlTokens = [];  
	
	url = window.location.href;
	iPtr = url.indexOf("?");
	if(iPtr > 0) {
		tokens = url.substr(iPtr + 1).split("&");
		for(i=0; i < tokens.length; i++)
		{
			temp = tokens[i].split("=");
			if(temp.length === 1)
				temp[1] = "";
			g_UrlTokens[temp[0]] = temp[1];
			if(temp[0].toLowerCase() === "device") { // only show one device
				if(temp[1] !== "") {
					g_sDevice = temp[1].replace(/%20/g, " ");
				}
			}
			else if(temp[0].toLowerCase() === "devicename") {  // specify initial device from list of devices
				if(temp[1] !== "") {
					g_sDevice = temp[1].replace(/%20/g, " ");
				}
			}
		}
	}
	d = new Date();
	sTemp = d.toLocaleTimeString();
	g_b12hourClock = false;
	if((sTemp.toLowerCase().indexOf("am") !== -1) || (sTemp.toLowerCase().indexOf("pm") !== -1)){
		g_b12hourClock = true;
	}
	

	getSmartServerVersion(); // get version,  all devices and then show planning tree
	getBackgroundPollingState(); // determine if background polling play/paused
	getSmartServerStorageInfo(); // needed as data log size can be an issue.
	getDeviceTypes(25);
	if(g_bPreloadAllSnvtTypes)
		showDashboardUiGetAllSnvtType(4, {});
	
}
function initializeDisplay() {
	initializeDisplay(0);
}
function initializeDisplay(mode) {
		try {
		var element, errMsg;
		g_iMainDisplayMode = DISPLAYMODE_NONE
		g_PollingType = DISPLAYMODE_NONE;
		if(mode !== 4)
			cursorClearWait(); // don't issue for initialization
		if(g_timerId !== 0) { // to reduce background timer slowness expecially during using F12 debugger
			clearInterval(g_timerId);
			g_timerId = 0;
		}
		if(g_datalogWsClient !== null) {
			try {
				g_datalogWsClient.close();
			}
			catch {}
			g_datalogWsClient = null;
		}
		g_bDatalogAborted = false;
		g_bPollingEnabled = false;
		ivbWsProcessDatapointUpdate = false;
		ivbWsSaveServicePinShowMessage = false;
		g_sWebSocketSubscribePayload = "";
		g_sWebSocketSubscribePayload_oldvalue = "";
		g_iDataLogPollCount = 0;
		g_iDataLogPollCountMax = -1;
		g_bDashboardUpdateCharts = false;
		g_bUpdateCharts = false;
		g_datalogSvgDoc = null;
		g_bDashboardDataLogGetInProgress = false;
		g_bDeviceDataLogGetInProgress = false;
		g_bDataLogGetInProgress = false;
		g_iDashboardPriorityColumn = -1;
		//if(!(typeof g_datalogChartInfo === "undefined"))
		//	g_datalogChartInfo.updateLastEntryToCurrentTimestamp = false;
		
		if(g_planningDpTimerId !== 0)
			clearTimeout(g_planningDpTimerId);

		document.getElementById("menuDiv").className = "menuDivHide";
		document.getElementById("testDiv").className = "testDivHide";
		document.getElementById("testAllDiv").className = "testDivHide";
		document.getElementById("planningDiv").className = "testDivHide";
		document.getElementById("warningDiv").className = "testDivHide";

		document.getElementById("menuOverlayDiv").className = "menuOverlayDivHide";
		document.getElementById("testOverlayDiv").className = "menuOverlayDivHide";
		document.getElementById("testAllDiv").className = "menuOverlayDivHide";
		document.getElementById("planningOverlayDiv").className = "menuOverlayDivHide";
		document.getElementById("scheduleOverlayDiv").className = "menuOverlayDivHide";
		element = document.getElementById("scheduleCreateOverlayDiv");
		if(element !== null)
			element.className = "menuOverlayDivHide";
	}
	catch (err) {
		errMsg = err.toString();
	}
}
function addElementToEditButtonElementList(displayId, type, action) {
	try {
		addElementToEditButtonElementList1(displayId, type, action, "", -1, -1, "");
	}
	catch {}
} 
function addElementToEditButtonElementList1(displayId, type, action, displayId1, dpIndex, displayElementIndex, baseDisplayId) {
	addElementToEditButtonElementList2(false, displayId, type, action, displayId1, dpIndex, displayElementIndex, baseDisplayId);
}
function addElementToEditButtonElementList2(bEditDisabledGoToDevice, displayId, type, action, displayId1, dpIndex, displayElementIndex, baseDisplayId) {
	try {
		var obj = {};
		if(g_iShowEditButton === 0)
			return; // only need to do if edit button is used
		if((displayId === "") || (type === "") || (action === "")) 
			return;
		obj.bGotoDeviceDashboard = bEditDisabledGoToDevice; //when edit disable, clicking element goes to device dashboard; table usually false, on graphic usually true
		obj.displayId = displayId;
		obj.displayId1 = displayId1; 
		obj.type = type;
		obj.action = action;
		obj.dpIndex = dpIndex;
		obj.displayElementIndex = displayElementIndex;
		obj.baseDisplayId = baseDisplayId;
		g_editButtonElementList.push(obj);
	}
	catch {}
} 
function addIfToPathname(pathname) {
	// verify that /if not already included, if not add /if
	try {
		var iPtr1;
		var iPtr = pathname.indexOf("/");
		if(iPtr > 0) {
			iPtr1 = pathname.indexOf("/if",iPtr);
			if((iPtr1 !== iPtr) && (iPtr !== 0))
				pathname = pathname.substr(0, iPtr) + "/if" + pathname.substr(iPtr);
		}
	}
	catch {}
	return pathname;
}
function addIfandNameToPathname(pathname) {
	// verify that /if not already included, if not add /if
	// mode: 0=add xifname if 3.20.114+, 1=always add xifname, 2= never add XIF name not used yet
	var pathnames  = [];
	try {
		var iPtr1;
		var iPtr = pathname.indexOf("/");
		pathnames = pathname.split("/");
		if( ((mode === 0) && (g_iSmartServerVersion >= 320114)) || (mode === 1)) {
			pathname = pathnames[0];
			if(pathnames.length > 1)
				pathname += "/if/*+name==" + pathnames[1];
			if(pathnames.length > 2)	
				pathname +=  "/" + pathnames[2];
			if(pathnames.length > 3)	
				pathname +=   "/*+name==" + pathnames[3];
		}
		
	}
	catch {}
	return pathname;
}
function addIfandXifnameToPathname(mode, pathname) {
	// verify that /if not already included, if not add /if
	// mode: 0=add xifname if 3.20.114+, 1=always add xifname, 2= never add XIF name not used yet
	var pathnames  = [];
	try {
		var iPtr1;
		var iPtr = pathname.indexOf("/");
		pathnames = pathname.split("/");
		if( ((mode === 0) && (g_iSmartServerVersion >= 320114)) || (mode === 1)) {
			pathname = pathnames[0];
			if(pathnames.length > 1)
				pathname += "/if/*+xifName==" + pathnames[1];
			if(pathnames.length > 2)	
				pathname +=  "/" + pathnames[2];
			if(pathnames.length > 3)	
				pathname +=   "/*+xifName==" + pathnames[3];
		}
		else { 
			pathname = pathnames[0]
			if(pathnames.length > 1)
				pathname += "/if/" + pathnames[1]
			if(pathnames.length > 2)	
				pathname +=  "/" + pathnames[2]
			if(pathnames.length > 3)	
				pathname += "/" + pathnames[3];
		}
	}
	catch {}
	return pathname;
}
function addToFavDps_getDpInfoForFixedDp(pathname){
	var url, pathnames;
	menuCancel();
	if(pathname === null)
		return;
	if(pathname === "")
		return;
	pathnames = pathname.split("/");
	if(pathnames.length === 4) {
		url = "https://" + location.hostname + "/iap/devs/*+name==" + pathnames[0] + "/if/" + pathnames[1] + "/" + pathnames[2] + "/" + pathnames[3] + "/*";
		requestGetData(0, url, addToFavDps_getDpInfoResponse, null);
	}
}
function addToFavDps_getDpInfo(bFixed, deviceType, pathname){
	var url, obj;
	menuCancel();
	if(bFixed)
		addToFavDps_getDpInfo1(bFixed, deviceType, pathname);
	else {
		if(deviceTypeList.length > 0)
			addToFavDps_getDpInfo1(bFixed, deviceType, pathname);
		else {
			url = "https://" + location.hostname + "/iap/devTypes/*?short=false&sortBy=name&sortOrder=asc";
			obj = {};
			obj.bFixed = bFixed;
			obj.deviceType = deviceType;
			obj.pathname = pathname;
			requestGetData(obj, url, addToFavDps_getDpInfo_DeviceTypeResponse, null);
		}
	}
}
function addToFavDps_getDpInfo_DeviceTypeResponse(mode, requestUrl, json) {
	var bFixed, deviceType, pathname;
	bFixed = mode.bFixed;
	deviceType = mode.deviceType;
	pathname = mode.pathname;
	deviceTypeList = json;
	addToFavDps_getDpInfo1(bFixed, deviceType, pathname)
}
function addToFavDps_getDpInfo1(bFixed, deviceType, pathname) {
	// deviceType: fixed = deviceName, relative = devicetype, pathname = block Name/Block Index/DP XiF Name
	var i,j, k, z, typeId, bcontinue = false, sDpQualifierPathList = "", newEntry, url, programmaticPathname; //123455
	var path, pathList,	pathnames, pathname1;
	
	try {
		//create dp qualifier list
		if(bFixed) {
			if(pathname.indexOf(",") === -1) {

				for (i=0; i < deviceListAll.length; i++)
				{
					if(deviceListAll[i].name === deviceType) {
						if(deviceListAll[i].status.state === "provisioned") {
							programmaticPathname = deviceListAll[i].name + "/" + pathname;
							z = -1;
							for (j=0; j < favDpList.length; j++)
							{
								if(favDpList[j].programmaticPathname === programmaticPathname) {
									z = j;
									break;
								}
							}
							if(z === -1) {
								newEntry = deviceListAll[i].scId + "/" + deviceListAll[i].protocol + "/" + deviceListAll[i].DID + "/" + pathname;
								newEntry = encodeUriString(newEntry); // encodeUriString(newEntry);
								if(sDpQualifierPathList !== "")
									sDpQualifierPathList += ",";
								sDpQualifierPathList += newEntry;
								bContinue = true;
							}
						}
						break;
					}
				}
			}
			else {
				// pathname contains a string of pathnames
				pathList = pathname.split(",");
				for(k=0; k < pathList.length; k ++) 
				{
					path = pathList[k];
					pathnames = path.split("/");

					for (i=0; i < deviceListAll.length; i++)
					{
						if(deviceListAll[i].name === pathnames[0]) {
							if(deviceListAll[i].status.state === "provisioned") {
								pathname1 = deviceListAll[i].name + "/" + pathnames[1] + "/" + pathnames[2] + "/" + pathnames[3];
								z = -1;
								for (j=0; j < favDpList.length; j++)
								{
									if(favDpList[j].pathname === pathname1) {
										z = j;
										break;
									}
								}
								if(z === -1) {
									newEntry = deviceListAll[i].scId + "/" + deviceListAll[i].protocol + "/" + deviceListAll[i].DID;
									newEntry += "/" + pathnames[1] + "/" + pathnames[2] + "/" + pathnames[3];
									newEntry = encodeUriString(newEntry);
									if(sDpQualifierPathList !== "")
										sDpQualifierPathList += ",";
									sDpQualifierPathList += newEntry;
									bContinue = true;
								}
							}
							break;
						}
					}
				}
			} 
		}
		else {
			for (j=0; j < deviceTypeList.length; j++) 
			{
				if(deviceTypeList[j].name === deviceType) {
					typeId = deviceTypeList[j].id;
					for (i=0; i < deviceListAll.length; i++)
					{
						if(deviceListAll[i].typeId === typeId) {
							z = -1;
							programmaticPathname = deviceListAll[i].deviceName + "/" + pathname;
							for (k=0; k < favDpList.length; k++)
							{
								if(favDpList[k].programmaticPathname === programmaticPathname) {
									z = k;
									break;
								}
							}
							if( z=== -1) {
								try {
									if(deviceListAll[i].status.state === "provisioned") {
										bContinue = true;
										if(sDpQualifierPathList !== "") 
											sDpQualifierPathList += ",";
										newEntry = deviceListAll[i].scId + "/" + deviceListAll[i].protocol + "/" + deviceListAll[i].DID + "/" + pathname;
										newEntry = encodeUriString(newEntry);
										sDpQualifierPathList += newEntry;
									}
								}
								catch {}
							}
						}
					}
					break;
				}
			}
		}
		if(bContinue) {
			url = "https://" + location.hostname + "/iap/devs/*/if/*/*/*+qualifier=-" + sDpQualifierPathList + "/*";
			requestGetData(0, url, addToFavDps_getDpInfoResponse, null);
			
		}
	}
	catch {}
}
function addToFavDps_getDpInfoResponse(mode, request, json) {
	var i, iPtr;
	if(json !== null) {
		if(json.length > 0) {
			for(i=0; i < json.length; i++)
			{
				try {
					path = json[i].deviceName + "/" + json[i].deviceName + "/" + json[i].blockName  + "/" + json[i].blockIndex + "/";
					if(typeof json[i].name === "undefined") {
						path = json[i].datapointName;
						json[i].path = json[i].datapointName;
						json[i].dpName = json[i].datapointName;
						json[i].pathname = json[i].deviceName + "/" + json[i].deviceName + "/" + json[i].blockName  + "/" + json[i].blockIndex + "/" +  json[i].datapointName;
					}
					else {
						path = json[i].name;
						json[i].path = json[i].name;
						json[i].dpName = json[i].name;
						json[i].pathname = json[i].deviceName + "/" + json[i].deviceName + "/" + json[i].blockName  + "/" + json[i].blockIndex + "/" +  json[i].name;
					}
					json[i].pathname = path;
					json[i].programmaticPathname = json[i].deviceName + "/" + json[i].deviceName + "/" + json[i].blockName  + "/" + json[i].blockIndex + "/" +  json[i].datapointName;
					json[i].priority = "";
					if(json[i].cat === "in")
						json[i].priority = json[i].values.level;
					json[i].block = json[i].blockName  + "/" + json[i].blockIndex;
					json[i].unit = " ";
					if(json[i].protocol === "lon") {
						json[i].unit = json[i].lon_cfg.unit
					}
					json[i].timestampStr = json[i].local;
					try {
						iPtr = json[i].local.lastIndexOf("-");
						json[i].timestampStr = json[i].local.substr(0, iPtr);
					}
					catch {}
					try { 
						
						if(json[i].presetValue === null)
							json[i].presetValue = "";
					} catch (err) {}
					try { 
						if(!(typeof json[i].value === "undefined")) {
							if( json[i].value !== null) {
								if(typeof  json[i].value === "number")
									json[i].valueStr =  json[i].value.toString();
								else
									json[i].valueStr = JSON.stringify(json[i].value);
							}
						}
					} catch (err) {}
					try { 
						if(!(typeof json[i].locValue === "undefined")) {
							if( json[i].locValue !== null) {
								if(typeof  json[i].locValue === "number")
									json[i].locValueStr =  json[i].locValue.toString();
								else
									json[i].locValueStr = JSON.stringify(json[i].locValue);
							}
						}
					} catch (err) {}
				}
				catch {}
			}
			addToFavDps(json);
		}
	}

}
function addToFavDps(json) {
	var i,j, z, bcontinue = false, programmaticPathname;
	try {
		for (j=0; j < json.length; j++)
		{
			programmaticPathname = json[j].deviceName + "/" + json[j].deviceName + "/" + json[j].blockName  + "/" + json[j].blockIndex + "/" +  json[j].datapointName;
			z = -1;
			for (i=0; i < favDpList.length; i++)
			{
				if(favDpList[i].programmaticPathname === programmaticPathname) {
					z = i;
					break;
				}
			}
			if(z=== -1) {
				favDpList.push(json[j]);
				bContinue = true;
			}
		}
		while (bContinue)
		{
			bContinue = false;
			for (i=0; i < (favDpList.length - 1); i++)
			{
				if(favDpList[i].pathname > favDpList[i + 1].pathname) {
					tempObj = {};
					tempObj = favDpList[i];
					favDpList[i] = favDpList[i + 1];
					favDpList[i + 1] = tempObj;
					bContinue = true;
				}
			}
		}
		
	}
	catch {}
}

function addTopButton() {
	//return '<br><br><br><br><button id="topButton" onclick="gotoTopOfPage()">Top</button>';
	return '<div style=\"background-color: transparent;\"><br><br><br><br></div><button id="topButton" onclick="gotoTopOfPage()">&#11165;</button>';
}
function addTopContainerHtml() {
	// only used after getting initial devices and 
	// During initiation we want the wait spinner to be in the center of the screen but it can't with the current navtree.html, so change intial top-container content to center spinner and then
	//  replace the topContainer with this original.
	var content = '<div id="main-Container" >';
	content += '<div id="main-Header" > <!-- Pane header -->';
	content += '</div>';
	content += '<div id="main" > <!-- Pane data -->';
	content += '<div id=\"gettingInfoId\" class=\"gettingInfo\">"Getting data ...</div>';
	content += '</div>';
	content += '</div>';
	content += '<div id="main-botton" > <!-- Used to leave space for the footer-->';
	content += '</div>';
	return content;
}
function addWaitSpinner(mode) {
	if(mode === 1)
		return "<div class=\"spinnerLoader1\"></div>";
	else if(mode === 2)
		return "<div class=\"spinnerLoader2\"></div>";
	else
		return "<div class=\"spinnerLoader\"></div>";
}
function alarmCheckForUpdates(mode) {
	var d = new Date();
	if(g_iAlarmTimerId !== null) {
		//wait for timeour // only used if a lot of alarm messages
		return;
	}
	if((d.getTime() - g_iLastAlarmMs) > 10000)
		getActiveAlarmsCount(1);
	else {
		try {
			if(g_timerId === 0)
				g_timerId = window.setInterval("alarmTimerHandler()", 10100);
		} catch (err) {}
	}
}
function alarmGetPathFromDetails(details) {
	var datapointPath = "", iPtr, iPtr1,j;
	try {
		datapointPath = "";
		iPtr1 = details.indexOf("exceeded for ");
		if(iPtr1 !== -1) {
			iPtr1 += "exceeded for ".length + 1;
			iPtr1 = details.indexOf(" ",iPtr1);
			if(iPtr1 !== -1) {
				iPtr1 ++;
				iPtr = details.lastIndexOf(". Triggered value is ")
				if(iPtr > 0) {
					datapointPath = details.substr(iPtr1, (iPtr - iPtr1));
					iPtr = 0;
					// replace "." with "/" note iox and CT uses "." so only replace last three "."
					for(j=0; j < 3; j++)
					{
						if(j=== 0)
							iPtr = datapointPath.lastIndexOf(".");
						else if(j=== 1)
							iPtr = datapointPath.lastIndexOf(" ",iPtr);
						else
							iPtr = datapointPath.lastIndexOf(".",iPtr);
						if(iPtr !== -1) {
							datapointPath = datapointPath.substr(0, iPtr) + "/" + datapointPath.substr(iPtr + 1);
							iPtr--;
						}
					}
				}

			}
		}
	}
	catch {datapointPath = details;}
	return datapointPath;
}
function alarmTimerHandler() {
	clearTimeout(g_iAlarmTimerId);
	g_iAlarmTimerId = null;
	alarmCheckForUpdates(1);
}
function gotoTopOfPage() {
	document.body.scrollTop = 0;
	document.documentElement.scrollTop = 0;
}
function scrollFunction() {
	var topButton = document.getElementById("topButton");
	var width = window.innerWidth; // || document.documentElement.clientWidth || document.body.clientWidth;
	var height = window.innerHeight; // || document.documentElement.clientHeight || document.body.clientHeight;
	//var screenWidth = window.screen.width;
	//var screenHeight = window.screen.height;
	if(topButton !== null) {
		if((document.body.scrollTop > height) || (document.documentElement.scrollTop > height )) {
			topButton.style.display = "block";
		}
		else 
			topButton.style.display = "none";
	}
}
function autoSubscribeCheckBox() {
	if(document.getElementById("autoSubscribeCheckbox").checked)
		g_bAutoSubscribe = true;
	else
		g_bAutoSubscribe = false;
}
function calculateEps() {
	// Need DLA and Node Red settings
	var	url, element;
	g_epsInfo = {};
	g_epsInfo.eps = 0;
	g_epsInfo.pollAve = 0;
	g_epsInfo.dpPollCount = 0;
	g_epsInfo.dlaEps = 0;
	g_epsInfo.dlaPollAve = 0;
	g_epsInfo.dlaEventDpCount = 0;
	g_epsInfo.dlaPollDpCount = 0;
	g_epsInfo.nodeRedPollAve = 0;
	g_epsInfo.nodeRedDpCount = 0;
	g_epsInfo.nodeRedEps = 0;
	g_sDpInfoPaneContent = "";
	element = document.getElementById("displayLabel");
	if(element !== null)
		element.innerHTML = "Calculated EPS";
	url = "https://" + location.hostname + "/iap/devTypes/*?short=false&sortBy=name&sortOrder=asc";
	requestGetData(19, url, getDeviceTypesResponse, readFailCallback);
}
function calculateEpsShowResults() {
	var sTemp = "<br><br>";
	try {
		g_epsInfo.eps += g_epsInfo.nodeRedEps;
		g_epsInfo.dpPollCount = g_epsInfo.dlaPollDpCount + g_epsInfo.nodeRedDpCount;
		if((g_epsInfo.dlaPollDpCount > 0) || (g_epsInfo.nodeRedDpCount > 0)) {
			g_epsInfo.pollAve = ((g_epsInfo.dlaPollAve * g_epsInfo.dlaPollDpCount) + (g_epsInfo.nodeRedPollAve * g_epsInfo.nodeRedDpCount)) / g_epsInfo.dpPollCount;
		}
		sTemp += "<br>Total EPS: " + g_epsInfo.eps.toFixed(2);
		sTemp += "<br>Total Ave Poll rate: " + convertToTimeString(g_epsInfo.pollAve, 1, 2);
		sTemp += "<br>Total DPs Polled: " + g_epsInfo.dpPollCount;
		sTemp += "<br>Total DPs event Driven: " + g_epsInfo.dlaEventDpCount;
		sTemp += "<br><br>---<br><br>DLA EPS: " + g_epsInfo.dlaEps.toFixed(2);
		sTemp += "<br>DLA Ave Poll rate: " + convertToTimeString(g_epsInfo.dlaPollAve, 1, 2);
		sTemp += "<br>DLA DPs Polled: " + g_epsInfo.dlaPollDpCount;
		sTemp += "<br>DLA DPs event Driven: " + g_epsInfo.dlaEventDpCount;
		sTemp += "<br><br>Node-RED EPS: " + g_epsInfo.nodeRedEps.toFixed(2);
		sTemp += "<br>Node-RED Ave Poll rate: " + convertToTimeString(g_epsInfo.nodeRedPollAve, 1, 2);
		sTemp += "<br>Node-RED DPs Polled: " + g_epsInfo.nodeRedDpCount;
		sTemp += "<br>";
		g_sDpInfoPaneContent = sTemp + g_sDpInfoPaneContent;
		document.getElementById("main").innerHTML =  g_sDpInfoPaneContent;

	}
	catch (err) {}
}
function checkIfUserTypeSupported(userTypeMask) {
	//This function is used to verify whether the a function is available to the current user-type
	var bResult = false;
	try {
		if(g_currentUserType === ADMIN) {
			if((userTypeMask & (ADMIN | OWNER | SUPERVISOR | USER)) !== 0) // bit masked 
				bResult = true;
		}
		else if(g_currentUserType === OWNER) {
			if((userTypeMask & (OWNER | SUPERVISOR | USER)) !== 0) // bit masked 
				bResult = true;
		}
		else if(g_currentUserType === SUPERVISOR) {
			if((userTypeMask & (SUPERVISOR | USER)) !== 0)
				bResult = true;
		}
		else if(g_currentUserType === USER) {
			if((userTypeMask & USER) !== 0)
				bResult = true;
		}
		
	}
	catch {}
	return bResult;
}
function checkIfDpsMatchList(dpPath, dpList) {
	var i,j;
	var bResult = false;
	var pathnames = [];
	var pathnames1 = [];
	try {
		if(dpList.length > 0) {
			dpPath = dpPath.trim().toLowerCase();
			pathnames = dpPath.split("/");
			
			if(pathnames.length === 3) {
				for(j=0; j < dpList.length; j ++)
				{
					pathnames1 = dpList[j].split("/");
					bResult = true;
					if(pathnames1.length === 3) {
						for(i=0; i < pathnames.length; i ++)
						{
							pathnames1[i] = pathnames1[i].trim();
							if(pathnames1[i] === "*") {

							}
							else if(pathnames1[i].indexOf("~") === 0) {
								if(pathnames1[i].length > 1) {
									if(pathnames[i].indexOf(pathnames1[i].substr(1)) === -1) {
										bResult = false;
										break;
									}
								}
								else {
									bResult = false;
										break;
								}
							}
							else if(pathnames1[i].indexOf("*") === 0) {
								if(pathnames1[i].length > 1) {
									if(pathnames[i].indexOf(pathnames1[i].substr(1)) === -1) {
										bResult = false;
										break;
									}
								}
								else {
									bResult = false;
										break;
								}
							}
							else if(pathnames1[i].endsWith("*")) {
								if(pathnames1[i].length > 1) {
									if(pathnames[i].indexOf(pathnames1[i].substr(0, (pathnames1[i].length - 1))) !== 0) {
										bResult = false;
										break;
									}
								}
								else {
									bResult = false;
										break;
								}
							}
							else if(pathnames[i] === pathnames1[i]) {

							}
							else {
								bResult = false;
								break;
							}
							
						}
						if(bResult) {
							break;
						}
					}
				}
			}
		}
	}
	catch {
		bResult = false;
	}
	return bResult;
}
function checkIfDpsMatch(dpPath, dpPath1) {
	var i,j;
	var bResult = false;
	var pathnames = [];
	var pathnames1 = [];
	try {
		if(dpPath1.length > 0) {
			dpPath = dpPath.trim().toLowerCase();
			pathnames = dpPath.split("/");
			
			if(pathnames.length === 3) {
				pathnames1 = dpPath1.split("/");
				bResult = true;
				if(pathnames1.length === 3) {
					for(i=0; i < pathnames.length; i ++)
					{
						pathnames1[i] = pathnames1[i].trim().toLowerCase();
						if(pathnames1[i] === "*") {

						}
						else if(pathnames1[i].indexOf("~") === 0) {
							if(pathnames1[i].length > 1) {
								if(pathnames[i].indexOf(pathnames1[i].substr(1)) === -1) {
									bResult = false;
									break;
								}
							}
							else {
								bResult = false;
									break;
							}
						}
						else if(pathnames1[i].indexOf("*") === 0) {
							if(pathnames1[i].length > 1) {
								if(pathnames[i].indexOf(pathnames1[i].substr(1)) === -1) {
									bResult = false;
									break;
								}
							}
							else {
								bResult = false;
									break;
							}
						}
						else if(pathnames1[i].endsWith("*")) {
							if(pathnames1[i].length > 1) {
								if(pathnames[i].indexOf(pathnames1[i].substr(0, (pathnames1[i].length - 1))) !== 0) {
									bResult = false;
									break;
								}
							}
							else {
								bResult = false;
									break;
							}
						}
						else if(pathnames[i] === pathnames1[i]) {

						}
						else {
							bResult = false;
							break;
						}
						
					}
				}
				
			}
		}
	}
	catch {
		bResult = false;
	}
	return bResult;
}
function cpuTimerHandler() {
	// send sends empty PUT request /iap/storage/publishes/true to enable publishing
	try {
		if(g_bShowCpu) {
			if(g_iCheckIfGettingCpuUpdates) {
				g_iCheckIfGettingCpuUpdates = 0;
				g_cpuTimerId = 0;
				requestPutData(0, "/iap/storage/publishes/true", "",  null, null); 
			}
		}
	}
	catch {}
}
function convertToTimeString(value, secDigits, allOtherDigits) {
	var newStr = value;
	try {
		if(value < 0) {
			newStr += " s";
		}
		else if(value < 60)
			newStr = value.toFixed(secDigits) + " s";
		else if(value < (60 * 60))
			newStr = (value / 60).toFixed(allOtherDigits) + " m";
		else if(value < (60 * 60 * 24))
			newStr = (value / (60 * 60)).toFixed(allOtherDigits) + " hours";
		else 
			newStr = (value / (60 * 60 * 24)).toFixed(allOtherDigits) + " days";
	}
	catch (err) {
		newStr = value;
	}
	return newStr;
}

function clearDpAlarm(mode, index, id, displayId, programmaticPath) {
	// mode: 0=context or dashboard so remove alarm color and bell
	var url, payload,element,iPtr,m;
	var element, element1;
	var sTemp = "Are you sure you want to clear this alarm";
	element = document.getElementById("warningDiv");
	element1 = document.getElementById("warningOverlayDiv");
	try {
		if((element === null) || (element1 === null))
			return;
		menuOverlayDivShow(7, null);

		sTemp += "<br><br><br><div style=\"width:100%;text-align:right\">";
		sTemp += "<button class=\"warningDivShowButton\" onclick=\"clearDpAlarm1(" + mode + "," + index + "," + id + "," + displayId + "," + programmaticPath + ")\">OK</button>";
		sTemp += "<button class=\"warningDivShowButton\" onclick=\"showAlertDialogHide()\">Cancel</button>";
		sTemp += "</div>";
		element.innerHTML = sTemp; 

	}
	catch {}
	/*
	if(confirm("Are you sure you want to clear this alarm")) {

	}
	*/
}
function clearDpAlarm1(mode, index, id, displayId, programmaticPath) {
	try {
		menuDivClose();
		if((mode === 0) && (displayId !== "")) {
			element = document.getElementById(displayId);
			if(element !== null)
				element.innerHTML = "";
			iPtr = displayId.indexOf("bell_");
			if(iPtr !== -1) {
				sTemp = "datapointName" + displayId.substr(4);
				element = document.getElementById(sTemp);
				if(element !== null)
					element.style.backgroundColor = g_alarmColors[0];
			}
			if(index < dashboardDpList.length) {
				if(dashboardDpList[index].programmaticPathname === programmaticPath) {
					dashboardDpList[index].alarm = null;
					for(m=0; m < g_deviceAlarmsList.length; m++)
					{
						if(g_deviceAlarmsList[m].deviceId === dashboardDpList[index].deviceId) {
							for(k=0; k < g_deviceAlarmsList[m].alarms.length; k++)
							{
								if(g_deviceAlarmsList[m].alarms[k].pathname === dashboardDpList[index].pathname) {
									g_deviceAlarmsList[m].alarms.splice(k,1);
									break;
								}
							
							}
						}
					}  
				}
			}
		}
		url = "/iap/alarms/clear";
		payload = "[" + id + "]";
		requestPutData(0, url, payload,  clearAlarmResponse, clearAlarmResponse); 
   } catch {}
}
function clearAlarm(index, id, tableRow) {
	 //function clearAlarm(index, id, pathname, tableRow) { 	//remove
	try {
		var url, payload;
		if(g_iMainDisplayMode === DISPLAYMODE_ACTIVEALARMS) {
			if(activeAlarmList.length > 0) {
				if(index < activeAlarmList.length) {
					if(activeAlarmList[index].id === id) {
					//if((activeAlarmList[index].id === id) && (activeAlarmList[index].path === pathname)) { //remove
						if(tableRow !== null) {
							document.getElementById("alarmTable").deleteRow(tableRow);
						}
						url = "/iap/alarms/clear";
						payload = "[" + id + "]";
						requestPutData(0, url, payload,  clearAlarmResponse, clearAlarmResponse); 
					}
				}
			}
		}
	} catch {}
}
function clearAlarmResponse () {
	try {
		//getActiveAlarms(1, "");
		g_iLastAlarmMs = 0;

	}
	catch {}
}
function clearDlaFilter(mode, index, displayMode) {
	
	if((mode === 0) || (mode === 2)) {
		if((index === 0) || (index === 1)) {
			g_oDlaDpFilter.smartServer = "";
			if(displayMode === 1) {
			//	document.getElementById("menuDlaFilterSmartServer").value = "";
			}
		}
		if((index === 0) || (index === 2)) {
			g_oDlaDpFilter.protocol = "";
			if(displayMode === 1) {
				document.getElementById("menuDlaFilterProtocol").value = "";
			}
		}
		if((index === 0) || (index === 3)) {
			g_oDlaDpFilter.deviceType = "";
			if(displayMode === 1) {
				document.getElementById("menuDlaFilterDeviceType").value = "";
			}
		}
		if((index === 0) || (index === 4)) {
			g_oDlaDpFilter.device = "";
			if(displayMode === 1) {
				document.getElementById("menuDlaFilterDevice").value = "";
			}
		}
		if((index === 0) || (index === 5)) {
			g_oDlaDpFilter.blockName = "";
			if(displayMode === 1) {
				document.getElementById("menuDlaFilterBlockName").value = "";
			}
		}
		if((index === 0) || (index === 6)) {
			g_oDlaDpFilter.blockIndex = "";
			if(displayMode === 1) {
				document.getElementById("menuDlaFilterBlockIndex").value = "";
			}
		}
		if((index === 0) || (index === 7)) {
			g_oDlaDpFilter.datapointName = "";
			if(displayMode === 1) {
				document.getElementById("menuDlaFilterDatapoint").value = "";
			}
		}
		if((index === 0) || (index === 8)) {
			g_oDlaDpFilter.override = "";
			if(displayMode === 1) {
				document.getElementById("menuDlaFilterOverride").value = "";
			}
		}
		if((index === 0) || (index === 9)) {
			g_oDlaDpFilter.priority = "";
			if(displayMode === 1) {
				document.getElementById("menuDlaFilterPriority").value = "";
			}
		}
		if((index === 0) || (index === 10)) {
			g_oDlaDpFilter.configured = "configured";
			if(displayMode === 1) {
				document.getElementById("menuDlaFilterConfigured").value = "configured";
			}
		}
	}
}

function clearDpOverrideFromTable(tableId, n, priority, programmaticPathname) {
	var i, j;
	var table = null;
	var currentPriority = null, element, key;
	if((tableId === "") || (n === null))
		return;
	clearDpOverride(priority, programmaticPathname);
	table = document.getElementById(tableId);
	if(table !== null) {
		i = n.parentNode.parentNode.rowIndex;
		table.deleteRow(i);
	}
	try {
		if(g_iMainDisplayMode === DISPLAYMODE_DPS) {
			for(j=0; j < dpList.length; j ++)
			{
				if(dpList[j].programmaticPathname === programmaticPathname) {
					currentPriority = dpList[j].values.level;
					delete dpList[j].values.levels[priority];
					if(priority === currentPriority) {
						key = Object.keys(dpList[j].values.levels)[0];
						key = Number(key);
						dpList[j].values.level = key;
						dpList[j].priority = key;
						currentPriority = key;
					}
					else 
						currentPriority = null;
					break;
				}
			}
		}
		else if(g_iMainDisplayMode === DISPLAYMODE_FAVDPS) {
			for(j=0; j < favDpList.length; j ++)
			{
				if(favDpList[j].programmaticPathname === programmaticPathname) {
					currentPriority = favDpList[j].values.level;
					delete favDpList[j].values.levels[priority];
					if(priority === currentPriority) {
						key = Object.keys(favDpList[j].values.levels)[0];
						key = Number(key);
						favDpList[j].values.level = key;
						favDpList[j].priority = key;
						currentPriority = key;
					}
					else 
						currentPriority = null;
					break;
				}
			}
		}
		else if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) { 
			for(j=0; j < planningDpList.length; j ++)
			{
				if(planningDpList[j].programmaticPathname === programmaticPathname) {
					currentPriority =  planningDpList[j].values.level;
					delete planningDpList[j].values.levels[priority];
					if(priority === currentPriority) {
						key = Object.keys(planningDpList[j].values.levels)[0];
						key = Number(key);
						planningDpList[j].values.level = key;
						planningDpList[j].priority = key;
						currentPriority = key;
					}
					else 
						currentPriority = null;
					break;
				}
			}
		}
		else if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
			for(j=0; j < dashboardDpList.length; j ++)
			{
				if(dashboardDpList[j].programmaticPathname === programmaticPathname) {
					currentPriority = dashboardDpList[j].values.level;
					delete dashboardDpList[j].values.levels[priority];
					if(priority === currentPriority) {
						key = Object.keys(dashboardDpList[j].values.levels)[0];
						key = Number(key);
						dashboardDpList[j].values.level = key;
						dashboardDpList[j].priority = key;
						if(dashboardDpList[j].dashboardType !== "n")
							currentPriority = null; // only if shown in table
						else
							currentPriority = key;
					}
					else 
						currentPriority = null;
					break;
				}
			}
		}
		if(currentPriority !== null) {
			
			if((g_iMainDisplayMode === DISPLAYMODE_DPS) || (g_iMainDisplayMode === DISPLAYMODE_FAVDPS) || (g_iMainDisplayMode === DISPLAYMODE_PLANNING)
				|| (g_iMainDisplayMode === DISPLAYMODE_DASHBOARD)) {
				// change priority in display
				element = document.getElementById("priority_" + programmaticPathname);
				if(element !== null) {
					if(currentPriority === 17)
						currentPriority = "Normal";
					element.value = currentPriority;
				}
			}
		}
	}
	catch(err) {}
	g_sUpdateDataPoint = programmaticPathname;
	g_iUpdateDataPointCount = 0;
}
function clearDpOverride(priority, programmaticPathname) {
	var url = "";
	var pathnames = [];
	
	try {
		if(typeof priority === "number") {
			if(priority === 17)
				return;
		}
		else if(typeof priority === "string") {
			if((priority === "17") || (priority.toLowerCase() === "normal"))
				return;
		}
		pathnames = programmaticPathname.split("/");
		if(pathnames.length === 4) {
			if(g_iSmartServerVersion >= 320114)
				url = "*+name==" + pathnames[0] + "/if/*+xifName==" + pathnames[1] + "/" + pathnames[2]  + "/*+xifName==" + pathnames[3] + "/overrides/" + priority + "/value";
			else 
				url = "*+name==" + pathnames[0] + "/if/" + pathnames[1] + "/" + pathnames[2]  + "/" + pathnames[3] + "/overrides/" + priority + "/value";
			url = encodePathString(url); // url.replace(/ /g,"%20").replace(/:/g,"%3A").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
			url = "https://" + location.hostname + "/iap/devs/" + url;
			g_sDpNeedUpdating = programmaticPathname;
			var Rsp = requestDeleteFunction(programmaticPathname, url, priority,  null, null); 
		}
	}
	catch(err) {}
}

function clearTable() {
	var i;
	var table;
	var paneContent;
	if(g_iMainDisplayMode === DISPLAYMODE_DATALOG) {
		if(g_iDatalogPollMode === 0) {
			dataLogDpList = [];
			dataLogList = [];
			datalogPaneContent = "";
			g_sDataLogDuration = "";
			g_sDataLogStartTime = "";
			document.getElementById("main").innerHTML = "";
		}
		else {
			
			dataLogList = [];
			

			table = document.getElementById("myTable");
			if(table !== null) {
				paneContent = "<tHead><tr><th onclick=\"sortTable(0)\">#</th><th onclick=\"sortTable(1)\">Timestamp</th>";
				paneContent += "<th onclick=\"sortTable(2)\">Device</th><th onclick=\"sortTable(3)\">Block</th><th onclick=\"sortTable(4)\">DP</th>";
				paneContent += "<th onclick=\"sortTable(5)\">Preset</th>";
				paneContent += "<th onclick=\"sortTable(6)\">Local Value</th><th onclick=\"sortTable(7)\">Value</th>";
				paneContent += "<th onclick=\"sortTable(8)\">DeltaValue</th><th onclick=\"sortTable(9)\">DeltaTime</th>";
				paneContent += "<th onclick=\"sortTable(10)\">Device State</th><th onclick=\"sortTable(11)\">PathName</th></tHead><tbody>";
				table.innerHTML = paneContent;
			}
			if(g_bDatalogChartZoomInProgress)
				ivInitializeChart3Clear("dataLogChartSvg", g_zoomChartList);
			else 
				ivInitializeChart3Clear("dataLogChartSvg", g_chartList);
			g_bDatalogChartZoomInProgress = false;
			g_chartList = [];
			g_zoomChartList = [];
			g_chartListLogs = []; // device data logs
			for(i=0; i < dataLogDpList.length; i++)
			{
				dataLogDpList[i].valueList = [];
				dataLogDpList[i].locMax = null;
				dataLogDpList[i].locMin = null;
				dataLogDpList[i].max = null;
				dataLogDpList[i].min = null;
			}
			
		}
	}
	else 
		document.getElementById("main").innerHTML = "";
}
function convertCsvStringToFields(iMode, sLine)
{ //iMode: 0= ignore, 1=convert
	var sResults = [];
	var i, bContinue = true, iCount = 0, iIndex = 0, iPtr, sField, sTemp, sTemp1, bLookForEndQuote = false, iFieldBegPtr = 0, iBegQuoteIndex = -1, sLine1 = sLine;
	var sFieldList = [];
	try
	{
		if((sLine.indexOf("\"") === -1) || (iMode === 0))
		{
			sResults = sLine.split(",");
				return sResults;
		}
		// at least one quote or iMode > 0
		while (bContinue)
		{
			sField = "";
			if (iIndex < sLine1.length)
			{
				sTemp = sLine1.substr(iIndex, 1);
				if (sTemp === "\"")
				{
					if (bLookForEndQuote)
					{ // check if next character quoate (double quote) or non-quoate
						if ((iIndex + 1) < sLine1.length)
						{
							sTemp1 = sLine1.substr(iIndex + 1, 1);
							if (sTemp1 === "\"")
							{ // ignore
								iIndex++;
							}
							else if (sTemp1 === ",")
							{  // end of field
								if (iFieldBegPtr !== iIndex)
								{
									sField = sLine1.substr(iFieldBegPtr + 1, (iIndex - iFieldBegPtr - 1));
									sField = sField.replace(/\\"\\"/, "\""); //sField.Replace("\"\"", "\"");
									sFieldList.push(sField);
								}

								bLookForEndQuote = false;
								iIndex++;
								iFieldBegPtr = iIndex + 1;
							}
							else
							{ // error
								MessageBox.Show("invalid char", "Convert CSV String To Fields");
								bContinue = false;
							}
						}
						else
						{ // end of line 
							bContinue = false;
							sField = sLine1.substr(iFieldBegPtr + 1, (sLine1.length - iFieldBegPtr - 2));
							sField = sField.replace(/\\"\\"/, "\""); //sField.Replace("\"\"", "\"");
							sFieldList.push(sField);
						}
					}
					else
					{ // continue
						bLookForEndQuote = true;
						iFieldBegPtr = iIndex;
					}
				}
				else if (sTemp === ",")
				{
					if (bLookForEndQuote)
					{ // ignore as this is part of string

					}
					else
					{
						sField = sLine1.substr(iFieldBegPtr, iIndex - iFieldBegPtr);
						sField = sField.replace(/\\"\\"/, "\""); //sField.Replace("\"\"", "\"");
						sFieldList.push(sField);
						iFieldBegPtr = iIndex + 1;
					}
				}
			}
			else
			{
				sField = sLine1.substr(iFieldBegPtr, (iIndex - iFieldBegPtr));
				sField = sField.replace(/\\"\\"/, "\""); //sField.Replace("\"\"", "\"");
				sFieldList.push(sField);
				bContinue = false;
			}
			iIndex++;

		}
		sResults = sFieldList;
		/*
		if(sFieldList.Count > 0)
		{  //convert List<string> to string[]
			
			
			sResults = new string[sFieldList.Count];
			for(i = 0; i < sFieldList.Count; i++)
			{
				sResults[i] = sFieldList[i];
			}
			
		}
		*/
	}
	catch
	{
		sResults = null;
	}
	return sResults;
}
function copyToClipboard(displaymode) {
	try {
		var i, len;
		var tempStr = "", temp;

		if(displaymode === DISPLAYMODE_DATALOG) {
			tempStr = "Local Time,UTC Time,Device Name,Block,Datapoint,Value,Delta Value,Delta Time,DP Path";
			for(i = 0; i < dataLogList.length; i++)
			{
				temp = dataLogList[i].local.replace(/ /g,"_");
				tempStr += "\r\n" + temp + "," + dataLogList[i].utc + "," + dataLogList[i].deviceName;
				tempStr += "," + dataLogList[i].block + "," + dataLogList[i].dpName + "," + dataLogList[i].value;
				tempStr += "," + dataLogList[i].deltaValue + "," + dataLogList[i].deltaTime + "," + dataLogList[i].pathname;
				
			}
			
		}
		if(tempStr !== "") {
			var copyElement = document.createElement("textarea");
			copyElement.value = tempStr;
			document.body.appendChild(copyElement);
			copyElement.select();
			document.execCommand("copy");
			document.body.removeChild(copyElement);
		}
	}
	catch (err) 
	{
		showAlertDialog(0,"Error: Can't copy to Clipboard\r\n\r\n" + err.toString());
	}
}

function createDataLogClientWebSocketConnection(mode, request) {
    //datalogClient = new WebSocket(`wss://${sSmartServerIpAddress}:${clientPort}/iap/ws?dp=true`, [], {
	
    var datalogCount = 0;
	var dataLogData = ""; //Datapoint,Local Time,UTC Time,Value,Device Status";
	g_dtDataLogStartTime  = new Date();
	g_dtDataLogReceiveTime = null;
	g_sDataLogDuration = "";
	g_sDataLogStartTime = "";
	g_iDataLogSortInterations = 0;
	g_datalogJson = [];

	g_bDataLogGetInProgress = true;
	try {
		if(g_datalogWsClient !== null)	{
			g_bDatalogAborted = true;
			g_datalogWsClient.close();
		}
	} catch (err) {}

	//g_datalogWsClient = new WebSocket("wss://"+ window.location.hostname + ":8443" + request);
	g_datalogWsClient = new WebSocket("wss://"+ window.location.hostname  + request);
    
    g_datalogWsClient.onopen = function(event) {
    //        console.log(`SmartServer DataLog WebSocket Connection OPEN to ${sSmartServerIpAddress}: ${request}`);
		dataLogData = "";
    };

    g_datalogWsClient.onmessage = function(event) {
        var nowTs = new Date(); // Seconds TS good enough
        var data = event.data;
        try {
			if(!((g_iMainDisplayMode === DISPLAYMODE_DATALOG) || (g_iMainDisplayMode === DISPLAYMODE_DASHBOARD))) {
				return;
			}
			
			datalogCount ++;
			if(bDataLogShowInConsole)
				console.log(JSON.parse(data));
            if(data !== "\"end\"") {
				// UI shows datalogs in descending order
				//    for intial request list in descending order
				//    all polled request list in ascending order inorder to add new entries at top of existing table 
				if(mode === 2) { // ascending order
					if(dataLogData !== "") 
						dataLogData += ",";
					dataLogData += data;
				}
				else { // descending order
                	if(dataLogData !== "") 
						data += ",";
					dataLogData = data + dataLogData;
				}
 
            }
            return;
		}  
		catch(error) {
            console.error(nowTs.toISOString() + ' - SmartServer DataLog Websocket Error: ' + error);
		}
    };
    g_datalogWsClient.onclose = function(event) {
		// descending order except for mode 2 which is ascending
        var nowTs = new Date(); // Seconds TS good enough
        var i = 0, iTemp;
        var d1, d2;
		var temp;
		var count;
		var iNumOutOfOrderDesc = 0, iNumOutOfOrder1 = 0;
		var iNumOutOfOrderAsc = 0;
		var infoElement;
		g_datalogWsClient = null;
		if(g_bDatalogAborted) {
			g_bDatalogAborted = false;
			return;
		}
		if(!g_bDataLogGetInProgress)
			return;
		if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
			if(g_bDeviceDataLogGetInProgress) {
				_getDeviceDatalogChartResponse(mode, request, JSON.parse("[" + dataLogData + "]")); 
			}
			else if(g_bDashboardDataLogGetInProgress)
				getDashboardDatalogDataResponse(mode, request, JSON.parse("[" + dataLogData + "]")); 
			return;
		}
		else if(g_bDashboardDataLogGetInProgress)
			return; // wrong data

        //var dataLogResult = "Datapoint,Timestamp,UTC Time,Value,Device Status";
        //var timeDiff = ((nowTs - datalogStartTime) / 1000).toString() + "s";
        //console.log("**** SmartServer DataLog WebSocket Closed  ****");
		g_dtDataLogReceiveTime = nowTs;
		g_iDataLogSortInterations = 0;
        try {
			if(mode === 0){
				g_bDatalogLogRequestInProgress = true;
				if(dataLogData === "") {
					g_bDataLogGetInProgress = false; // no data don't update UI as this is a periodic read request
					infoElement = document.getElementById("gettingInfoId");
					if(infoElement !== null) {
						if(infoElement.innerHTML.indexOf("Getting DataLog Data") === 0) {
							if(g_iDatalogPollMode === 1) {
								// log + live data - no logs so try log data
								datalogStartLiveData(0);
								
								return;
								
							}
							else
								infoElement.innerHTML = "No Data Log data available"
						}
					}
					return;
				}
			}
			else if(mode === 2) {
				if(dataLogData === "") {
					g_bDataLogGetInProgress = false; // no data don't update UI as this is a periodic read request
					return;
				}
			}
			

            // process data 
			g_datalogJson = JSON.parse("[" + dataLogData + "]");
			if(g_datalogJson.length === 0) {
				g_bDataLogGetInProgress = false; // no data don't update UI as this is a periodic read request
				return;
			}
			// check if in desending order
			for(i=0; i < (g_datalogJson.length - 1); i++)
			{
				temp = g_datalogJson[i].utc;
				d1 = Date.parse(temp.substr(0,(temp.length - 5)));
				g_datalogJson[i].timestamp = d1;
				temp = g_datalogJson[i + 1].utc;
				d2 = Date.parse(temp.substr(0,(temp.length - 5)));
				if(i === (g_datalogJson.length - 2)) 
					g_datalogJson[i + 1].timestamp = d2; // add timestamp to last entry
				if(d1 < d2) {
					iNumOutOfOrderDesc ++;
				}
				else if(d1 > d2) {
					iNumOutOfOrderAsc ++;
				}
			} 
			if(g_datalogJson.length === 1) {
				temp = g_datalogJson[0].utc;
				d1 = Date.parse(temp.substr(0,(temp.length - 5)));
				g_datalogJson[0].timestamp = d1;
			}
			 
			if(((mode !== 2) && (iNumOutOfOrderDesc > 0)) || ((mode === 2) && (iNumOutOfOrderAsc > 0))) {
				

				temp = "Got data, now sorting ....   OutofOrder: Total entries = " + g_datalogJson.length.toString() + ") Failed: before Desending = ";
				temp += iNumOutOfOrderDesc + ", Ascending = " + iNumOutOfOrderAsc;
				//alert(temp);
				temp = "<button onclick=\"dataLogAbort()\">Abort</button><br><br><span id=\"gettingInfoId\" class=\"gettingInfo\">" + temp + "</span>";
				if(mode !== 2)
					document.getElementById("main").innerHTML = temp;
				if(mode === 2) {
					// ascending
					if(iNumOutOfOrderDesc < iNumOutOfOrderAsc) {
						// maybe sorted in reverse order so reverse array
						iTemp = Math.floor(g_datalogJson.length / 2);
						iEnd = g_datalogJson.length - 1;
						for(i=0; i < iTemp; i++)
						{
							createDataLogSwap(i, (iEnd - i));
						} 
					}
					count = createDataLogSort(true, -1);
					g_iDataLogSortInterations = count;
					// verify 
					for(i=0; i < (g_datalogJson.length - 1); i++)
					{
						if(g_datalogJson[i].timestamp > g_datalogJson[i + 1].timestamp) 
							iNumOutOfOrder1 ++;
					} 
				}
				else { // descending
					if(iNumOutOfOrderAsc < iNumOutOfOrderDesc) {
						// maybe sorted in reverse order so reverse array
						iTemp = Math.floor(g_datalogJson.length / 2);
						iEnd = g_datalogJson.length - 1;
						for(i=0; i < iTemp; i++)
						{
							createDataLogSwap(i, (iEnd - i));
						} 
					}
					count = createDataLogSort(false, -1);
					g_iDataLogSortInterations = count;
					for(i=0; i < (g_datalogJson.length - 1); i++)
					{
						if(g_datalogJson[i].timestamp < g_datalogJson[i + 1].timestamp) 
							iNumOutOfOrder1 ++;
					} 
					if((iNumOutOfOrder1 > 0) && (mode !== 2)) {
						temp = "sort(0, " + (g_datalogJson.length - 1).toString() + ") Failed: before Desending = ";
						temp += iNumOutOfOrderDesc + ", Ascending = " + iNumOutOfOrderAsc + "; after sort = " + iNumOutOfOrder1 + ", sort iterations = " + count;
						showAlertDialog(0,temp);
					}
				}
			}
			if(g_iMainDisplayMode === DISPLAYMODE_DATALOG)
				datalogResponseProcessData(mode, request, g_datalogJson); 
        }
        catch (err) {
			g_bDatalogLogRequestInProgress = true;
            showAlertDialog(0,"datalog WebSocket Processing error: " + err);
        }
		g_bDataLogGetInProgress = false;
	};
	g_datalogWsClient.onerror = function(event) {
		showAlertDialog(0,"datalog WebSocket error:\r\n\r\nrequest:" + request + "\r\n\r\n" + event.type);
		g_bDataLogGetInProgress = false;
		g_datalogWsClient = null;
	};
}
function createDataLogSort(bAscending, size) {
	var iCount = 0;
	var i = 0;
	var bContinue = true;
	try {
		var last = g_datalogJson.length;
		var offset = g_datalogJson.length % 2;
		if(size === -1){
			size = Math.floor(g_datalogJson.length / 2);
		} 
		while(bContinue)
		{
			bContinue = false;
			iCount ++;
			//for(i=0; i < ((last - size) + offset); i++)
			for(i=0; i < (last - size); i++)
			{
				if(bAscending) {
					if(g_datalogJson[i].timestamp > g_datalogJson[i + size].timestamp) {
						createDataLogSwap(i, (i + size));
						bContinue = true;
					}
				}
				else { // descending
					if(g_datalogJson[i].timestamp < g_datalogJson[i + size].timestamp) {
						createDataLogSwap(i, (i + size));
						bContinue = true;
					}
				}
			}
			if(size !== 1)
				bContinue = true; // only exit if size = 1 and bContinue = false;
			size = Math.floor(size / 2);
			if(size < 1)
				size = 1;
		} // while(bContinue)
		
	}
	catch (err) {
		showAlertDialog(0,"sort() error: i = " + i + ", Total entries = " + g_datalogJson.length.toString() + ", size = " + size + ", Iterations = " + iCount + " \r\n" + err.toString());
	}
	return iCount;
}
function createDataLogSortReverseArray() {
	try {
		var i;
		len = g_datalogJson.length - 1;
		count = Math.floor(g_datalogJson.length / 2);
		for(i=0; i < count; i ++)
		{
			createDataLogSwap(i, len - i);
		}
	}
	catch {}
}
function createDataLogQsort(bAscending, l,r) {
	try {
		var index;
		if(l < r) {
			index = partition(bAscending, l,r);
			if(l < (index - 1))
				qsort(bAscending, l, (index - 1));
			if(index < r) 
				qsort(bAscending, index, r);
		}    
	}
	catch(err) {console.error(`**** qsort(${l},${r}): ****    ${err}`);}

}
function createDataLogPartition(bAscending, l, r) {
	var i = l - 1;
	var j; 
	var pivotIndex = r; //Math.floor((l + r)/2);
	var pivot = g_datalogJson[r].timestamp; //g_datalogJsonData[pivotIndex].d1;
	
	for(j=l; j <= (r - 1); j++)
	{
		if(bAscending) {
			// asending order
			if(g_datalogJson[j].timestamp <= pivot) {
				i++;
				createDataLogSwap(i,j);
			}
		}
		else {
			// descending order
			if(g_datalogJson[j].timestamp >= pivot) {
				i++;
				createDataLogSwap(i,j);
			}
		}
	}
	createDataLogSwap((i+1), pivotIndex);
	return (i + 1);
}
function createDataLogSwap(firstIndex, secondIndex) {
	var tempObj = g_datalogJson[firstIndex];
	g_datalogJson[firstIndex] = g_datalogJson[secondIndex];
	g_datalogJson[secondIndex] = tempObj;
}
function createRequestString(objList) {
	try {
		var iCount = 0, index = 0, i;
		g_sWebSocketSubscribePayload = "";
		g_sWebSocketSubscribePayload_oldvalue = "";
		g_sOnDemandDpRequestUrl = "";
		g_dpGetRequestArr = [];
		g_idpGetRequestIndex = -1;
		g_dpGetRequestArr[index] = "";
		if(objList.length > 0) {
			g_idpGetRequestIndex = 0;
			for (i=0; i <objList.length; i++)
			{
				if(g_sOnDemandDpRequestUrl !== "")
					g_sOnDemandDpRequestUrl += ",";
				g_sOnDemandDpRequestUrl += encodeUriString(objList[i].dpQualifier);
				if(g_sWebSocketSubscribePayload !== "") 
					g_sWebSocketSubscribePayload += ",";
					g_sWebSocketSubscribePayload += "\"" + objList[i].dpQualifier + "\"";
				if(typeof g_dpGetRequestArr[index] === "undefined")
					g_dpGetRequestArr[index] = "";
				else if(g_dpGetRequestArr[index] !== "")
					g_dpGetRequestArr[index] += ",";
				g_dpGetRequestArr[index] += encodeUriString(objList[i].dpQualifier);
				iCount ++;
				if(iCount >= g_iMaxOfDpsToPollPerInterval) {
					iCount = 0;
					index ++;
				}
			}
			if(g_sWebSocketSubscribePayload !== "") {
				g_sWebSocketSubscribePayload = "[" + g_sWebSocketSubscribePayload + "]";
				//g_sOnDemandDpRequestUrl = encodePathString(g_sAllDevicesStatus);
				//g_sOnDemandDpRequestUrl = g_sOnDemandDpRequestUrl.replace(/\//g,"%2F");
				/*
				for(i=0; i < g_dpGetRequestArr.length; i++)
				{
					g_dpGetRequestArr[i] = encodePathString(g_dpGetRequestArr[i]);
					//g_dpGetRequestArr[i] = g_dpGetRequestArr[i].replace(/\//g,"%2F");
					//g_dpGetRequestArr[i] = g_dpGetRequestArr[i].replace(/\[/g,"%5B");
					//g_dpGetRequestArr[i] = g_dpGetRequestArr[i].replace(/\]/g,"%5D");
				}
				*/
			}
		}
	} catch {}
}
function cursorSetWait() {
	/*
	document.querySelectorAll('*').forEach(function(node) {
		node.style.cursor = "wait";
	});
	*/
}
function cursorClearWait() {
	/* doesn't work in firefox 
	document.querySelectorAll('*').forEach(function(node) {
		node.style.cursor = "default";
	});
	*/
	/* doesn't work
	if(navigator.userAgent.indexOf('Firefox') !== -1) {
		if(document.hasFocus()) {
			//alert("infocus");
			window.blur();
			window.focus();
		}
	}
	*/
}
function dataLogAbort() {
	g_bAbort = true;
}
function dataLogAdvancedCheckBox() {
	if(document.getElementById("dataLogAdvancedCheckbox").checked)
		document.getElementById("dataLogAdvancedDiv").style.display = "block";
	else 
		document.getElementById("dataLogAdvancedDiv").style.display = "none";
}
function dataLogCheckIfUrlIsForDevice(url) {
	var bResult = true;
	try {
			url = url.toLowerCase();
			if(url === "all dps")
				bResult = false;
			else if(url === "favorite dps list")
				bResult = false;
			else if(url === "datapoints list")
				bResult = false;
			else if(url === "Get First Entry")
				bResult = false;
			else if(url === "Get Last Entry")
				bResult = false;
			else if(url.indexOf("/") !== -1)
				bResult = false;
			else if(url.indexOf(",") !== -1)
				bResult = false;
	}
	catch (err) {}
	return bResult;
}
function dataLogDpUrlChanged() {
	// only applies when in live only mode
	var url, url1, temp;
	if(g_iMainDisplayMode !== DISPLAYMODE_DATALOG)
		return;
	if(g_iDatalogPollMode === 2) {
		if(g_bDatalogPollingEnabled) {
			g_bDatalogUrlChanged = false;
			url = document.getElementById("dataLogDpUrl");
			if(url !== null) {
				url = url.value;
				url1 = url.toLowerCase();
				if(url1 === "favorite dps list") {
					dashboardDpList = [];
					g_dashboardChartList = [];
					dataLogRequest();
				}
				else if(url1 === "datapoints list") {
					dashboardDpList = [];
					g_dashboardChartList = [];
					dataLogRequest();
				}
				else if (url.indexOf("/") !== -1) {
					dashboardDpList = [];
					g_dashboardChartList = [];
					datalogGetDpListFromDpInstanceNamesCheck(url);
				}
				else if(dataLogCheckIfUrlIsForDevice(url)) {
					dashboardDpList = [];
					g_dashboardChartList = [];
					dataLogRequest();
				}
				else {
					temp = "\"live only\" supports only:<br><br>Device Name (single Device)<br>Datapoints List<br>";
					temp += "Favorite DPs List<br>Datapoints List \(comma separated): PulseGen 1/Light/0/nviLamp";
					document.getElementById("main").innerHTML = temp;
				}
			}
		}
		else {
			g_bDatalogUrlChanged = true; // used for datalog live polling, When checking the polled checked box, and this variable set then need to restart
		}
	}
}
function datalogGetDpListFromDpInstanceNamesCheck(dpListStr) {
	// determine if one or more DPs
	//g_datalogUrlDpXifList
	
	var i, dp, temp, obj = {}, url;
	var list = dpListStr.split(",");
	if(g_iMainDisplayMode !== DISPLAYMODE_DATALOG)
			return;
	url = document.getElementById("dataLogDpUrl");
	if(url === null)
		return;
	g_datalogUrlDpInstanceNamesList = []; // list ofDp instance names that need to be converted to Xif names
	datalogLiveDataDpList = [];
	for(i = 0; i < list.length; i++)
	{
		if(list[i] !== "") {
			dp = list[i];
			dp = dp.trim();
			// look for three "/"
			iPtr = dp.indexOf("/");
			if(iPtr != -1) {
				iPtr ++;
				iPtr = dp.indexOf("/", iPtr);
				if(iPtr != -1) {
					iPtr ++;
					iPtr = dp.indexOf("/", iPtr);
					if(iPtr != -1) {
						iPtr ++;
						g_datalogUrlDpInstanceNamesList.push(dp);
					}
				}
			}
		}
	}
	if(g_datalogUrlDpInstanceNamesList.length > 0) {
		obj.index = -1;
		obj.url = url.value;
		datalogGetDpListFromDpInstanceNames(obj);
	}
	else {
		if(g_iMainDisplayMode === DISPLAYMODE_DATALOG) {
			main = document.getElementById("main");
			if(main !== null) {
				temp = "<br><br><i>Not a valid Datapoint list</i><br><br>Examples<br>Sensor1/Lamp/0/nviLamp_1<br>Sensor1/Lamp/0/nviLamp_1,PulseGen 2/Lamp/0/nviLamp_1";
				temp += ",*/*/*/nvoHVACTemp";
				main.innerHTML = temp;
			}
		}
	}

}
function datalogGetDpListFromDpInstanceNames(obj) {
	var i, dp, main, temp, url, deviceName, restOfpath, dpName, index,url;
	try {
		if(g_iMainDisplayMode !== DISPLAYMODE_DATALOG)
			return;
		if(g_datalogUrlDpInstanceNamesList.length === 0)
			return;
		index = obj.index;
		if(index >= g_datalogUrlDpInstanceNamesList.length)
			return;
		url = document.getElementById("dataLogDpUrl");
		if(url === null)
			return;
		if(url.value !== obj.url)
			return; // datapoint url was changed so stop existing process
		index ++;
		obj.index = index;
		if(index >= g_datalogUrlDpInstanceNamesList.length) {
			// done 
			if(datalogLiveDataDpList.length > 0) {
				for(i=0; i < datalogLiveDataDpList.length; i++)
					datalogLiveDataDpList[i].dpPath = datalogLiveDataDpList[i].pathname;
				datalogStartLiveDataPolling(); 
				datalogResponseProcessData(30, "", datalogLiveDataDpList); 
				datalogEnablePolling(1);
			}
			else {
				main = document.getElementById("main");
				if(main !== null) {
					temp = "<br><br><i>No valid Datapoints in Datapoint list</i>";
					main.innerHTML = temp;
				}
			}
			return;
		}
		// check if
		dp = g_datalogUrlDpInstanceNamesList[index];
		iPtr = dp.indexOf("/");
		if(iPtr !== -1) {
			deviceName = dp.substr(0,iPtr);
			restOfpath = dp.substr(iPtr);
			if(deviceName !== "*") {
				deviceName = "*+name==" + encodeUriString(deviceName);
				
			}
			iPtr = restOfpath.lastIndexOf("/");
			if(iPtr !== -1) {
				iPtr ++;
				dpName = restOfpath.substr(iPtr);
				restOfpath = restOfpath.substr(0,iPtr) + "*+name=+^" + encodePathString(dpName);
			}
			url = "https://" + location.hostname + "/iap/devs/" + deviceName + "/if" + restOfpath + "/*"; 
			requestGetData(obj, url, datalogGetDpListFromDpInstanceNamesResponse, datalogGetDpListFromDpInstanceNamesResponseFailCallback);
		}
		
		
	}
	catch {}
}
function datalogGetDpListFromDpInstanceNamesResponse(mode, requestUrl, json) {
	try {
		var i, j, z = -1, obj, programmaticPathname, pathname, presetValue = "", locValueStr = "", locValue, unit, priority = -1, lon_cfg;
		var name = "", url, index;
		if(g_iMainDisplayMode !== DISPLAYMODE_DATALOG)
			return;
		url = document.getElementById("dataLogDpUrl");
		if(url === null)
			return;
		if(url.value !== mode.url)
			return; // datapoint url was changed so stop existing process
		if(json.length > 0) {
			name = g_datalogUrlDpInstanceNamesList[mode.index];
			iPtr = name.lastIndexOf("/");
			if(iPtr > 0) {
				name = name.substr(iPtr + 1);
			}
			for(i=0; i < json.length; i ++)
			{
				unit = ""; presetValue = ""; LocValueStr = ""; locValue = null; programmaticPathname = ""; pathname = ""; priority = -1;
				programmaticPathname = json[i].deviceName + "/" + json[i].blockName  + "/" + json[i].blockIndex  + "/" + json[i].datapointName;
				pathname = json[i].deviceName + "/" + json[i].blockName  + "/" + json[i].blockIndex  + "/" + json[i].name;
				json[i].programmaticPathname = programmaticPathname;
				json[i].pathname = pathname;
				json[i].block = json[i].blockName  + "/" + json[i].blockIndex;
				json[i].urlPath = json[i].deviceName + "/if/" + json[i].blockName + "/" + json[i].blockIndex + "/";
				if(g_iSmartServerVersion >= 320114)
					json[i].urlPath += "*+xifName==";
				json[i].urlPath += json[i].datapointName;
				json[i].dpName = json[i].name;
				try { 
					presetValue = json[i].presetValue;
					if(presetValue === null)
						presetValue = "";
				} catch (err) {}
				json[i].presetValue = presetValue;
				try { 
					if(!(typeof json[i].locValue === "undefined")) {
						locValue = json[i].locValue;
						
						if(locValue !== null) {
							if(typeof locValue === "number")
								locValueStr = locValue.toString();
							else
								locValueStr = JSON.stringify(locValue);
						}
					}
				} catch (err) {}
				json[i].locValueStr = locValueStr;
				try {
					priority = json[i].values.level;
				}
				catch (err) {}
				json[i].priority = priority;
				try { lon_cfg = obj["lon.cfg"];
					unit = lon_cfg.unit;
				} catch (err) {}
				json[i].unit = unit;
				if(json[i].name === name) {
					// REST request use like for DP name so only use exact match
					z = -1;
					for(j=0; j < datalogLiveDataDpList.length; j++)
					{
						if(datalogLiveDataDpList[j].pathname === pathname){
							
							z = j;
							break;
						}
					}
					if(z === -1) {
						obj = {};
						obj = JSON.parse(JSON.stringify(json[i]));
						obj.deviceTypeName = "";
						if(obj.deviceState !== "unprovisioned") {
							
							for(j=0; j < deviceListAll.length; j ++) 
							{
								if(obj.deviceName ===  deviceListAll[j].name) {
									obj.deviceTypeName = deviceListAll[j].deviceTypeName;
									break;
								}
							}
							//obj.deviceTypeName = g_sDashboardTemplateType; //ffixx add device type here
							datalogLiveDataDpList.push(obj);
						}
						
					}
				}
			}
		}
		datalogGetDpListFromDpInstanceNames(mode);
		
	}
	catch {}
}
function datalogGetDpListFromDpInstanceNamesResponseFailCallback(mode, requestUrl, json) {
	try {

		datalogGetDpListFromDpInstanceNames(mode);
	}
	catch {}
}
function datalogGetDeviceDpList(deviceName) {

	try {
		var i,z = -1;
		datalogLiveDataDpList = [];
		for(i=0; i < deviceDpList.length; i++)
		{
			if(deviceDpList[i].deviceName === deviceName) {
				
				datalogLiveDataDpList = JSON.parse(JSON.stringify(deviceDpList[i].datapoints));
				for(i=0; i < datalogLiveDataDpList.length; i++)
					datalogLiveDataDpList[i].dpPath = datalogLiveDataDpList[i].pathname;
				datalogStartLiveDataPolling(); 
				if(dataLogDpList.length === 0)
					datalogResponseProcessData(30, "", datalogLiveDataDpList); 
				else
					datalogResponseProcessData(22, "", datalogLiveDataDpList);
				datalogEnablePolling(1);
				return;
			}
		}
		// not in list so do request
		url1 = "https://" + location.hostname + "/iap/devs/*+name==" + deviceName + "/if/*/*/*/*"; 
		requestGetData(deviceName, url1, datalogGetDeviceDpListResponse, readFailCallback);
		//datalogResponseProcessData(30, "", dpObjs);
	}
	catch (err) {}
}
function datalogGetDeviceDpListResponse(mode, requestUrl, json) {
	// the deviceDpList is also used by the dashboard
	// mode = device name
	var i, z = -1, obj, programmaticPathname, pathname, presetValue = "", locValueStr = "", locValue, unit, priority = -1, lon_cfg;
	if(json.length === 0)
		return;
	datalogLiveDataDpList = [];
	for(i=0; i < json.length; i ++)
	{
		unit = ""; presetValue = ""; LocValueStr = ""; locValue = null; programmaticPathname = ""; pathname = ""; priority = -1;
		programmaticPathname = json[i].deviceName + "/" + json[i].blockName  + "/" + json[i].blockIndex  + "/" + json[i].datapointName;
		pathname = json[i].deviceName + "/" + json[i].blockName  + "/" + json[i].blockIndex  + "/" + json[i].name;
		json[i].programmaticPathname = programmaticPathname;
		json[i].pathname = pathname;
		json[i].block = json[i].blockName  + "/" + json[i].blockIndex;
		json[i].urlPath = json[i].deviceName + "/if/" + json[i].blockName + "/" + json[i].blockIndex + "/";
		if(g_iSmartServerVersion >= 320114)
			json[i].urlPath += "*+xifName==";
		json[i].urlPath += json[i].datapointName;
		json[i].dpName = json[i].name;
		try { 
			presetValue = json[i].presetValue;
			if(presetValue === null)
				presetValue = "";
		} catch (err) {}
		json[i].presetValue = presetValue;
		try { 
			if(!(typeof json[i].locValue === "undefined")) {
				locValue = json[i].locValue;
				
				if(locValue !== null) {
					if(typeof locValue === "number")
						locValueStr = locValue.toString();
					else
						locValueStr = JSON.stringify(locValue);
				}
			}
		} catch (err) {}
		json[i].locValueStr = locValueStr;
		try {
			priority = json[i].values.level;
		}
		catch (err) {}
		json[i].priority = priority;
		try { lon_cfg = obj["lon.cfg"];
			unit = lon_cfg.unit;
		} catch (err) {}
		json[i].unit = unit;
	}
	for(i=0; i < deviceDpList.length; i++)
	{
		if(deviceDpList[i].deviceName === mode){
			deviceDpList[i].datapoints = JSON.parse(JSON.stringify(json));
			z = i;
			break;
		}
	}
	if(z === -1) {
		obj = {};
		obj.deviceName = mode;
		obj.deviceTypeName = "";
		for(i=0; i < deviceListAll.length; i ++) 
		{
			if(mode ===  deviceListAll[i].name) {
				obj.deviceTypeName = deviceListAll[i].deviceTypeName;
				obj.programId = deviceListAll[i].programId;
				break;
			}
		}
		obj.deviceTypeName = g_sDashboardTemplateType; //ffixx add device type here
		obj.datapoints = JSON.parse(JSON.stringify(json));
		deviceDpList.push(obj);
		z = deviceDpList.length - 1;
	}
	
	if(z !== -1) {
		datalogLiveDataDpList = JSON.parse(JSON.stringify(deviceDpList[z].datapoints));
		for(i=0; i < datalogLiveDataDpList.length; i++)
			datalogLiveDataDpList[i].dpPath = datalogLiveDataDpList[i].pathname;
		datalogStartLiveDataPolling(); 
		if(dataLogDpList.length === 0)
			datalogResponseProcessData(30, "", datalogLiveDataDpList); 
		else
			datalogResponseProcessData(22, "", datalogLiveDataDpList);
		datalogEnablePolling(1);
	}
}
function dataLogRequest() {
	try {
		var d;
		var n;
		var iPtr, iPtr1, i, j;
		var t;
		var dates, dates1;
		var temp, temp1, temp2, temp3, dpPath;
		var url = document.getElementById("dataLogDpUrl").value;
		var date = document.getElementById("dataLogDpDate").value;
		var urlOrig = url;
		var deviceName = "";
		var url1 = url.toLowerCase();
		var date1 = date.toLowerCase(), date2;
		var paneContent = "";
		var wsUrl = "/iap/ws?dp=true";
		var pathnames;
		var element, element1;
		var sTemp;
		var dpObjs = [];
		var tempObjList = [];
		var tempList = []; 
		var bContinue;
		var bXifNameFound = false;
		var dpStr = "";
		var dpName = "", dpPathList = [], dpPathObjList = [];
		var bUrlChanged = false;
		dataLogDpList = [];
		dataLogList = [];
		datalogLiveDataDpList = [];

		g_bDatalogChartZoomInProgress = false;
		
		g_sDataLogDpPath = url;
		
		g_sDataLogDate = date;
		if(url1 === "favorite dps list") {
			if(favDpList.length === 0) {
				document.getElementById("main").innerHTML = '<br><br>Warning: "Favorite DPs List is empty - requires datapoints in "Favorites DP" View <br><br>';

				return;
			}
		}
			else if(url1 === "datapoints list") {
			if(dpList.length === 0) {
				document.getElementById("main").innerHTML = '<br><br>Warning: "Datapoints List is empty - requires datapoints in "Datapoints" View <br><br>';

				return;
			}
		}
		
		if(g_bEnableDataLogLiveData) {
			if(g_iDatalogPollMode === 2) {
				//sTemp = "Valid Datapoint entries: specific datapoint\r\ndatapoints separated by commas \",\"\r\nDatapoint List\r\nFavorite DPs List";
				sTemp = 'Valid Datapoint entries: <br><br>';
				//sTemp += 'specific datapoints separated by commas ","';
				sTemp += 'Datapoint List - first add datapoint in the Datapoint View and then press the Data Log button';
				sTemp += '<br>Favorite DPs List - first add datapoint in the Favorite DPs View and then press the Data Log button';
				if(url1 === "") {
					document.getElementById("main").innerHTML = '<br><br>Request Aborted: no datapoints specified<br><br>' + sTemp;
					//alert("Request Aborted: no datapoints specified\r\n\r\n" + sTemp);
				}
				else if(url1 === "all dps") {
					document.getElementById("main").innerHTML = '<br><br>Warning: "All DPs" is not valid for live only<br><br>' + sTemp
					//alert("Request Aborted: \"All DPs\" is not valid for live logging\r\n\r\n" + sTemp);
				
				}
				else if (url1.indexOf("/") !== -1) {
					// get datapoint list and continue
					datalogGetDpListFromDpInstanceNamesCheck(url);
					
				}
				else if (dataLogCheckIfUrlIsForDevice(url1)) {
					// get datapoint list and continue
					datalogGetDeviceDpList(url);
				}
				else {
					if(url1 === "favorite dps list") {
						
						datalogLiveDataDpList = JSON.parse(JSON.stringify(favDpList));
					}
					else if(url1 === "datapoints list") {
						
						datalogLiveDataDpList = JSON.parse(JSON.stringify(dpList));
					}
					for(i=0; i < datalogLiveDataDpList.length; i++)
						datalogLiveDataDpList[i].dpPath = datalogLiveDataDpList[i].pathname;
					datalogStartLiveDataPolling(); 
					
					datalogResponseProcessData(30, "", datalogLiveDataDpList); //datalogResponseProcessData(30, "", dpObjs);
					/*
					if(g_iDatalogLiveDataPollEnabled) {
						
						
						g_iDataLogPollCountMax = g_iDataLogLiveDataPollrate; // * 60;
						g_PollingType = DISPLAYMODE_DATALOGLIVEPOLL;
						try {
							if(g_timerId === 0)
								g_timerId = window.setInterval("timerHandler()", g_iTimerInterval);
						} catch (err) {}
					}
					*/
				}
				return;
			}
			else if(g_iDatalogPollMode === 1) {

				if(url1 === "favorite dps list")
					datalogLiveDataDpList = JSON.parse(JSON.stringify(favDpList));
				else if(url1 === "datapoints list")
					datalogLiveDataDpList = JSON.parse(JSON.stringify(dpList));
				for(i=0; i < datalogLiveDataDpList.length; i++)
					datalogLiveDataDpList[i].dpPath = datalogLiveDataDpList[i].pathname;
			}
		}
		
		if((url !== "") && (date !== "")) {
			if((url1 === "all dps") && (date1 === "all logs")) {
				showAlertDialog(0,"Request Aborted:\r\n\r\nThe following is not allowed:\r\nDatapoint: ALL DPS\r\nLog Data: all Logs\r\n\r\nPlease choose different");
				return;
			}
			/* remove
			if(url.indexOf(",") !== -1) {
				bContinue = false;
				//alert("Error: Only single Datapoint is supported: \",\" shown in textbox");
				//return;
				dpObjs = url.split(",");
				if(dpObjs.length > 0) {
					if(dpObjs[0] !== null) {
						iPtr = dpObjs[0].indexOf("/");
						if(iPtr > 0) {
							sTemp = dpObjs[0].substr(0, iPtr + 1);
							for(i= 0; i < dpObjs.length; i++ ) {
								if(dpObjs[i] !== "") {
									if(dpObjs[i].indexOf(sTemp) === 0) {
										bContinue = true;
									}
									else {
										alert("All datapoints mulst be from same device");
										return;
									}
								}
							}
						}
					}
				}
				if(bContinue) {
					for(i= 0; i < dpObjs.length; i++ ) {
						if(dpObjs[i] !== "") {
							
							iPtr = dpObjs[i].lastIndexOf("/");
							if(iPtr > 0) {
								if(dpStr !== "") {
									dpStr += "%7C"
								}
								dpStr += "(" + dpObjs[i].substr(iPtr + 1) + ")";
							}
							
						}
					}
				}
				else
					return;
			}
			*/
			if(url1.toLowerCase() === "get first entry") {
				url1 = "https://" + location.hostname + "/iap/devs/*/if/*/*/*/logs/value/*?sortBy=asc&pg=1&sz=1&noxs=true"; // this is a REST request
				//requestGetData(4, url1, datalogResponse
				requestGetData(0, url1, datalogResponseProcessData, readFailCallback);
				return;
			}
			else if(url1.toLowerCase() === "get last entry") {
				url1 = "https://" + location.hostname + "/iap/devs/*/if/*/*/*/logs/value/*?sortBy=desc&pg=1&sz=1&noxs=true"; // this is a REST request
				//requestGetData(4, url1, datalogResponse
				requestGetData(0, url1, datalogResponseProcessData, readFailCallback);
				return;
			}
			else if (url1.indexOf("/iap/ws?") === 0) {
				url1 = document.getElementById("dataLogDpUrl").value;
				iPtr = url1.indexOf("?value=");
				if(iPtr > 0) {
					iPtr += ("?value=").length
					
					wsUrl = url1.substr(iPtr);
					wsUrl = encodeUriString(wsUrl);
					//wsUrl = wsUrl.replace(/\*/g,"%2A").replace(/\+/g,"%2B").replace(/ /g,"%20").replace(/:/g,"%3A").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
					//wsUrl = wsUrl.replace(/>/g,"%3E").replace(/</g,"%3C")
					wsUrl = url1.substr(0, iPtr) + wsUrl;
				}
				else {
					wsUrl = url1;
				}
			}
			else if(url1 === "all logs") {
				url = "*/if/*/*/*/logs/value/*";
				wsUrl = "/iap/ws?dp=true";
			}
			else  {
				if(url1 === "all dps") {
					url = "*/if/*/*/*/logs/value/*";
					wsUrl = "/iap/ws?value=";
				}
				else {
					if(g_bDataLogWebSocketWorkaround) {
						wsUrl = "/iap/ws?dp=true";

					}
					else {
						//ffixxx  use when url works
						//wsUrl = "/iap/ws?value="; // needed as dev=*+name==PulseGen  doesn't work
						if(url1 === "favorite dps list") {
							g_datalogUrlDpXifList = [];
							url = "";
							for(j=0; j < favDpList.length; j ++)
							{
								obj = {};
								obj.dpPath = favDpList[j].pathname;
								obj.dpProgrammaticPath = favDpList[j].programmaticPathname;
								g_datalogUrlDpXifList.push(obj);
								if(url !== "")
									url += ",";
								url += favDpList[j].pathname;
							}
						}
						else if(url1 === "datapoints list") {
							g_datalogUrlDpXifList = [];
							url = "";
							for(j=0; j < dpList.length; j ++)
							{
								obj = {};
								obj.dpPath = dpList[j].pathname;
								obj.dpProgrammaticPath = dpList[j].programmaticPathname;
								g_datalogUrlDpXifList.push(obj);
								if(url !== "")
									url += ",";
								url += dpList[j].pathname;
							}
						}


						iPtr = url.indexOf("/");
						if(iPtr > 0) { // datapoint list
							wsUrl = "";
							// determine dp XIF name from datapoint instance name
							if(false) { //if(url.indexOf(",") !== -1) {
								dpPathList = url.split(",");
								for(j=0; j < dpPathList.length; j++) 
								{
									dpPathObjList = dpPathList[j].split("/");
									if(deviceName === "")
										deviceName = dpPathObjList[0];
									else {
										if(deviceName !== dpPathObjList[0]) {
											wsUrl = "/iap/ws?value=";
											break

										}
									}
									
								}
								if(wsUrl === "") {
									wsUrl = "/iap/ws?value=";
									for(i=0; i < deviceListAll.length; i++)
									{
										if(deviceListAll[i].name === deviceName) {
											//wsUrl = "/iap/ws?dev=" + deviceListAll[i].id + "&dpName==" + pathnames[4] + "&value=";
											wsUrl = "/iap/ws?dev=" + deviceListAll[i].id + "&value=";
											break;
										}
									}
								}
								
								bUrlChanged = true;
							}
							else {
								if(url.indexOf("xifname:") === -1) {
										// using datapoint instance names
									sTemp = url;
									sTemp = sTemp.trim();
									if(sTemp.indexOf(",") !== -1) {
										pathnames = sTemp.split(",");
										tempObjList = [];
										tempList = [];
										 // create list of pathnames
										for(i=0; i < pathnames.length; i++)
										{ //123a
											tempObjList = pathnames[i].split("/");
											if(tempObjList.length !== 4) {
												sTemp = "Warning: Invalid pathname \r\n\r\nExpected datapoint name to look like:\r\n\t";
												sTemp += "{device name}/{blockname}/{block Index}/{datapoint name},{device name}/{blockname}/{block Index}/{datapoint name}\r\n\r\n"
												sTemp += "but got: \r\n\t" + pathnames[i] + "\r\n\r\nTry again";
												showAlertDialog(0,sTemp);
												return;
		
											}
											for(j=0; j < tempObjList.length; j++)
											{
												tempObjList[j] = tempObjList[j].trim();
											}
											tempList.push(tempObjList);
										}
										sTemp = "";
										pathnames = ["*","*","*","*"];

										// compare pathname to see need to use
										for(j=0; j < 4; j++)
										{
											for(i=0; i < (tempList.length - 1); i++) 
											{
												if(i=== 0)
													sTemp1 = tempList[i][j];
												if((tempList[i][j] === "*") || (tempList[i + 1][j] === "*")) {
														sTemp1 = "*";
													break;
												}
												else if (tempList[i][j] !== tempList[i + 1][j]) {
														sTemp1 = "*";
													break;
												}
											}
											if(j > 0)
												sTemp += "/";
											sTemp += sTemp1;
										}
									}
									pathnames = sTemp.split("/");
									if(pathnames.length !== 4) {
										showAlertDialog(0,"Warning: Invalid pathname \r\n\r\nExpected datapoint name to look like:\r\n\t {device name}/{blockname}/{block Index}/{datapoint name}\r\n\r\nbut got: \r\n\t" + sTemp + "\r\n\r\nTry again");
										return;

									}
									for(j=0; j < pathnames.length; j++)
									{
										pathnames[j] = pathnames[j].trim();
									}
									// assume single datapoint using instance names 
									//url = url.substr(0, iPtr) + "/if" + url.substr(iPtr) + "/logs/value/*";
									wsUrl = "";
									if(pathnames[0] !== "*")
										wsUrl = "dev=%2A%2Bname==" + pathnames[0];
									
									if((pathnames.length > 1) && (pathnames[1] !== "*")) {
										if(wsUrl !== "")
											wsUrl += "&";
										if(g_iSmartServerVersion >= 320114) 
											wsUrl += "blockName="  + pathnames[1];
										else
											wsUrl += "blockName=%2A%2Bname=="  + pathnames[1];
									}
									if((pathnames.length > 2) && (pathnames[2] !== "*")) {
										if(wsUrl !== "")
											wsUrl += "&";
										wsUrl += "blockIndex="  + pathnames[2];
									}
									if((pathnames.length > 3) && (pathnames[3] !== "*")) {
										if(wsUrl !== "")
											wsUrl += "&";
										if(g_iSmartServerVersion >= 320114)
											wsUrl += "dpName="  + pathnames[3];
										else
											wsUrl += "dpName=%2A%2Bname=="  + pathnames[3];
									}
									wsUrl =  "/iap/ws?" + wsUrl + "&value=";
									bUrlChanged = true;
								}
								else {
									// using xif names
									iPtr = url.indexOf("xifname:");
									iPtr += "xifname:".length;
									sTemp = url.substr(iPtr);
									sTemp = sTemp.trim();
									if(sTemp.indexOf(",") !== -1) {
										pathnames = sTemp.split(",");
										tempObjList = [];
										tempList = [];
										 // create list of pathnames
										for(i=0; i < pathnames.length; i++)
										{ //123a
											tempObjList = pathnames[i].split("/");
											if(tempObjList.length !== 4) {
												sTemp = "Warning: Invalid pathname \r\n\r\nExpected datapoint name to look like:\r\n\t";
												sTemp += "{device name}/{blockname}/{block Index}/{datapoint name},{device name}/{blockname}/{block Index}/{datapoint name}\r\n\r\n"
												sTemp += "but got: \r\n\t" + pathnames[i] + "\r\n\r\nTry again";
												showAlertDialog(0,sTemp);
												return;
		
											}
											for(j=0; j < tempObjList.length; j++)
											{
												tempObjList[j] = tempObjList[j].trim();
											}
											tempList.push(tempObjList);
										}
										sTemp = "";
										pathnames = ["*","*","*","*"];

										// compare pathname to see need to use
										for(j=0; j < 4; j++)
										{
											for(i=0; i < (tempList.length - 1); i++) 
											{
												if(i=== 0)
													sTemp1 = tempList[i][j];
												if((tempList[i][j] === "*") || (tempList[i + 1][j] === "*")) {
														sTemp1 = "*";
													break;
												}
												else if (tempList[i][j] !== tempList[i + 1][j]) {
														sTemp1 = "*";
													break;
												}
											}
											if(j > 0)
												sTemp += "/";
											sTemp += sTemp1;
										}
									}
									pathnames = sTemp.split("/");
									for(j=0; j < pathnames.length; j++)
									{
										pathnames[j] = pathnames[j].trim();
									}
									// assume single datapoint using instance names 
									//url = url.substr(0, iPtr) + "/if" + url.substr(iPtr) + "/logs/value/*";
									wsUrl = "";
									if(pathnames[0] !== "*")
										wsUrl = "dev=%2A%2Bname==" + pathnames[0];
									
									if((pathnames.length > 1) && (pathnames[1] !== "*")) {
										if(wsUrl !== "")
											wsUrl += "&";
										if(g_iSmartServerVersion >= 320114)
											wsUrl += "blockName=%2A%2BxifName=="  + pathnames[1];
										else
											wsUrl += "blockName="  + pathnames[1];
										
									}
									if((pathnames.length > 2) && (pathnames[2] !== "*")) {
										if(wsUrl !== "")
											wsUrl += "&";
										wsUrl += "blockIndex="  + pathnames[2];
									}
									if((pathnames.length > 3) && (pathnames[3] !== "*")) {
										if(wsUrl !== "")
											wsUrl += "&";
										if(g_iSmartServerVersion >= 320114)
											wsUrl += "dpName=%2A%2BxifName=="  + pathnames[3];
										else
											wsUrl += "dpName="  + pathnames[3];
									}
									wsUrl =  "/iap/ws?" + wsUrl + "&value=";
									bUrlChanged = true;
								}
								
							}
							
							if(bUrlChanged) {

							}
							else if(g_bUseDeviceIdForDataLogWebSocket) {
								if(deviceListAll === null)
									return;
								if(url.indexOf("/") === -1) {
									//device or all
								}
								else if(pathnames[0] !== "*") {
									for(i=0; i < deviceListAll.length; i++)
									{
										if(deviceListAll[i].name === deviceName) {
											//wsUrl = "/iap/ws?dev=" + deviceListAll[i].id + "&dpName==" + pathnames[4] + "&value=";
											if(dpStr !== "")
												wsUrl = "/iap/ws?dev=" + deviceListAll[i].id + "&dpName=+^" + dpStr + "&value=";
											else
												wsUrl = "/iap/ws?dev=" + deviceListAll[i].id + "&dpName=" + pathnames[4] + "&value=";
											
											break;
										}
									}
								}
								else if((pathnames.length > 4) && (pathnames[2] === "*") && (pathnames[3] === "*")) {
									wsUrl = "/iap/ws?dpName="  + pathnames[4] + "&value=";  // e.g., */*/*/nvoLuxLevel
								}
								if(wsUrl === "")
									wsUrl = "/iap/ws?dp=true&value=";
								
							}
							else {
								if(pathnames[0] !== "*")
									wsUrl = "dev=%2A%Bname==" + pathnames[0];
								
								if((pathnames.length > 1) && (pathnames[2] !== "*")) {
									if(wsUrl !== "")
										wsUrl += "&";
									wsUrl += "blockName=%2A%Bname=="  + pathnames[2];
								}
								if((pathnames.length > 2) && (pathnames[3] !== "*")) {
									if(wsUrl !== "")
										wsUrl += "&";
									wsUrl += "blockIndex=%2A%Bname=="  + pathnames[3];
								}
								if((pathnames.length > 3) && (pathnames[4] !== "*")) {
									if(wsUrl !== "")
										wsUrl += "&";
									wsUrl += "dpName="  + pathnames[4];
								}
								wsUrl =  "/iap/ws?" + wsUrl + "&value=";
							}
						}
						else {
							if(g_bUseDeviceIdForDataLogWebSocket) {
								if(deviceListAll === null)
									return;
								if(url !== "*") {
									for(i=0; i < deviceListAll.length; i++)
									{
										if(deviceListAll[i].name === url) {
											//wsUrl = "/iap/ws?dev=" + deviceListAll[i].id + "&dpName==" + pathnames[4] + "&value=";
											wsUrl = "/iap/ws?dev=" + deviceListAll[i].id + "&value=";
											
											break;
										}
									}
								}
								
								if(wsUrl === "")
									wsUrl = "/iap/ws?dp=true&value=";
								
							}
							else
								wsUrl = "/iap/ws?value=";
						}
					}
					
				}
				g_sDataLogPollRequest = wsUrl;
				if(date1 !== "all logs") {
					if((date1.indexOf("hour") > 0) || (date1.indexOf("min") > 0) || (date1.indexOf("day") > 0)) {
						d = new Date();
						iPtr = date1.indexOf(" hour");
						if(iPtr > 0) {
							t = date1.substr(0, iPtr);
							t1 = Number(t);
							if(isNaN(t1)) {
								showAlertDialog(0,"Error: Invalid Number of hours:  " + date);
								return;
							}
							d.setTime(d.getTime() - (t1 * 60 * 60 * 1000));
						}
						else {
							iPtr = date1.indexOf(" day");
							if(iPtr > 0) {
								t = date1.substr(0, iPtr);
								t1 = Number(t);
								if(isNaN(t1)) {
									showAlertDialog(0,"Error: Invalid Number of hours:  " + date);
									return;
								}
								d.setTime(d.getTime() - (t1 * 24 * 60 * 60 * 1000));
							}
							else {
								iPtr = date1.indexOf(" min");
								if(iPtr > 0) {
									t = date1.substr(0, iPtr);
									t1 = Number(t);
									if(isNaN(t1)) {
										showAlertDialog(0,"Error: Invalid Number of min:  " + date);
										return;
									}
									d.setTime(d.getTime() - (t1  * 60 * 1000));
								}
								else {
									showAlertDialog(0,"Error: Invalid time specified:  " + date);
									return;
								}
							}
						}
						n = d.toISOString();
						n = n.substr(0, n.length - 1);
						if(n !== "") {
							url = "*+name==" + url + "/logs/value/*+utc>" + n;
							//n = n.replace(/:/g,"%3A") // encoding not needed
							wsUrl += "%2A%2Butc%3E" + n;
						}
					}
					else if (date1.toLowerCase() === "yesterday") {
						showAlertDialog(0,"TBD");
						return;
					}
					else {  // custom
						//paneTitle += "<option value=\">2020-04-25 10:58:28.728\">";
						//paneTitle += "<option value=\"2020-04-25 10:58:28.728 thru 2020-04-25 10:58:28.728\">";
						//paneTitle += "<option value=\"2020-04-25T10:58:28.728Z thru 2020-04-25T10:58:28.728Z\">";
						//paneTitle += "<option value=\"2020-04-25\">";
						date1 = date1.trim();
						temp = "";  //prefix
						temp3 = "";
						n = "";
						if(date1.length > 3) {
							dates = date1.split("thru");
							for(j=0; j < dates.length; j ++) 
							{
								temp = "";
								date2 = dates[j].trim();
								//if(j === 1)
								//	temp += "%26utc";
								temp1 = date2.charAt(0);
								if(temp1 === ">") {
									temp += ">"; // encoding not needed"%3F";
									temp1 += date1.charAt(1);
									if(temp1 === "=") {  // >=
										temp += "=";
										temp2 = date2.slice(2);
									}
									else {
										temp2 = date2.slice(1);
									}
								}
								else if(temp === "=") {
									temp += "=";
									if(temp1 === ">") {  // =>
										temp += ">"; // encoding not needed "%3E";
										temp2 = date2.slice(2);
									}
									else if(temp1 === "<") {  // =<
										temp += temp1; // encoding not needed"%3C";
										temp2 = date2.slice(2);
									}
									else {
										temp2 = date2.slice(1);
									}
									temp += "utc";
								}
								else if(temp1 === "<") {
									temp += temp1; // encoding not needed "%3C";
									temp1 += date1.charAt(1);
									if(temp1 === "=") {  // >=
										temp += "=";
										temp2 = date2.slice(2);
									}
									else {
										temp2 = date2.slice(1);
									}
									temp += "utc";
								}
								else {
									temp = "";
									if(j==0) 
										temp = ">"; // encoding not needed %3E";
									else 
										temp = "<="; // encoding not needed "%3C%3D";
									temp2 = date2;
								}
								temp2 = temp2.trim();
								if(temp2.toLowerCase().indexOf("z") > 0) {
									temp2 = temp2.substr(0, (temp2.length - 1));
								}
								else {
									
									t = new Date(temp2);
									temp2 = t.toISOString();
									if(temp2.toLowerCase().indexOf("z") > 0) {
										temp2 = temp2.substr(0, (temp2.length - 1));
									}

								}
								if(j==0)
									temp3 += "*+utc"; //"*+utc" // encoding not needed "%2A%2Butc";
								else 
									temp3 += "%26utc"
								temp3 += temp + temp2;
							}
							temp3 = temp3.replace(/\+/g,"%2B");
							temp3 = temp3.replace(/\*/g,"%2A");
							//temp3 = temp3.replace(/=/g,"%3D");
							wsUrl += temp3;
							
						}
					}
				}
				else {
					g_bDataLogChartUpdateLastEntryToCurrentTimestamp = true;
					wsUrl += "*";
				}
			}
			paneContent = "<button onclick=\"dataLogAbort()\">Abort</button><br><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting DataLog Data ...</span>";
			document.getElementById("main").innerHTML = paneContent;
			g_ArrPaginationResponse = [];
			g_bAbort = false;
			if(g_bUseWebSocketsForDataLog) {
				if((url1 === "all logs") || (wsUrl === "/iap/ws?dp=true")) {
					if(url1 === "all logs")
						temp = "Datapoint = " + urlOrig;
					else if((url.toLowerCase() === "all dps") && (date1 === "all logs")) {
						temp = "date = " + date;
					}
					else
						temp = "Datapoint = All Logs [" + wsUrl + "]";
					element = document.getElementById("warningDiv");
					element1 = document.getElementById("warningOverlayDiv");
					try {
						if((element === null) || (element1 === null))
							return;
						
						menuOverlayDivShow(7, null);
						sTemp = "This request can take more than 10+ minutes and may slow down browser -- Not Recommended<br><br>" + temp + "<br><br>Do you wish to continue?";
						sTemp += "<br><br><br><div style=\"width:100%;text-align:right\"><button class=\"warningDivShowButton\" onclick=\"clearDashboardCharts1()\">OK</button>";
						sTemp += "<button class=\"warningDivShowButton\" onclick=\"showAlertDialogHide()\">Cancel</button>";
						sTemp += "</div>";
						element.innerHTML = sTemp; 
			
					}
					catch {}
					/*
					if(confirm("This request can take more than 10+ minutes and may slow down browser -- Not Recommended\r\n\r\n" + temp + "\r\n\r\nDo you wish to continue?")) {
						createDataLogClientWebSocketConnection(0, wsUrl);
					}
					else {
						paneContent = "<button onclick=\"dataLogAbort()\">Abort</button><br><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting DataLog Data ...</span>";
						document.getElementById("main").innerHTML = paneContent;
					}
					*/
					return;
				}
				else {
					createDataLogClientWebSocketConnection(0, wsUrl);
				}
			}
			else  {
				url = "https://" + location.hostname + "/iap/devs/" + url + "?noxs=true&pg=1&sz=100";
				g_iPaginationPage = 1;
				requestGetData(0, url, datalogResponse, readFailCallback);
			}
		}
		else {
			showAlertDialog(0,"Error: Either Datapoint or date empty");
		}
	} catch {}
}
function dataLogRequestYes(wsUrl) {
	try {
		createDataLogClientWebSocketConnection(0, wsUrl);
	}
	catch {}
	showAlertDialogHide();

}
function dataLogRequestNo() {
	try {
		var element = document.getElementById("main");
		var paneContent = "<button onclick=\"dataLogAbort()\">Abort</button><br><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting DataLog Data ...</span>";
		if(element !== null) {
			element.innerHTML = paneContent;
		}
		showAlertDialogHide();
	}
	catch {}

}
function datalogStartLiveData(mode) {
	// remove not used
	// After datalog is read, next start live data polling
	// no datalogs so need to check if url for a device name, if so need to create DP list before we can do live polling
	// mode: 0=no data logs, 1=datalogs available
	var i, url, url1, temp, duration;
	try {
		if(g_iMainDisplayMode !== DISPLAYMODE_DATALOG)
			return;
		if(g_iDatalogPollMode === 1) {
			duration = document.getElementById("dataLogDpDate").value;
			if(duraton !== null) {
				if(duration.value.indexOf("thru")) {
	
					return;  // polling not valid for ranges 
				}
			}
		}
	}
	catch (err) {}
	

	if(g_bDatalogPollingEnabled) {
		if(g_bdatalogLiveDataConfigured)
			return; // already ran once don't need to run again.  Used to stop endless loops
		g_bdatalogLiveDataConfigured = true;
		url = document.getElementById("dataLogDpUrl").value;
		if((url.trim().toLowerCase() === "all dps") && (mode == 1)) {
			//this only happens if there are any datalog entries returned, if so it only gets live data for the same datapoints being logged 
			datalogLiveDataDpList = JSON.parse(JSON.stringify(dataLogDpList));
			for(i=0; i < datalogLiveDataDpList.length; i++)
				datalogLiveDataDpList[i].dpPath = datalogLiveDataDpList[i].pathname;
			datalogStartLiveDataPolling();
			getOnDemandDpValues(3, "");
			datalogEnablePolling(1);
			
		}
		else if(dataLogCheckIfUrlIsForDevice(url)) {
			datalogGetDeviceDpList(url);
			//url1 = "https://" + location.hostname + "/iap/devs/*+name==" + url + "/if/*/*/*/*"; 
			//requestGetData(url, url1, getOnDemandDpValuesResponse, readFailCallback);
		}
		else if (url.indexOf("/") !== -1) {
			datalogGetDpListFromDpInstanceNamesCheck(url);
		}
		else {
			url1 = url.toLowerCase();
			if((url1 === "favorite dps list") || (url1 === "datapoints list")) {
				if(url1 === "favorite dps list") {
					if(favDpList.length === 0) {
						document.getElementById("main").innerHTML = "Live Polling Stopped as \"Favorite DPs\" list is empty - go to \"Favorites DPs\" View to add datapoint list";
						return;
					}
					datalogLiveDataDpList = JSON.parse(JSON.stringify(favDpList));
				}
				else if(url1 === "datapoints list") {
					if(dpList.length === 0) {
						document.getElementById("main").innerHTML = "Live Polling Stopped as \"Datapoints\" list is empty - go to \"Datapoints\" View to add datapoint list";
						return;
					}
					datalogLiveDataDpList = JSON.parse(JSON.stringify(dpList));
				}
				for(i=0; i < datalogLiveDataDpList.length; i++)
					datalogLiveDataDpList[i].dpPath = datalogLiveDataDpList[i].pathname;
				datalogStartLiveDataPolling();
				getOnDemandDpValues(3, "");
				datalogEnablePolling(1);
			}
			else {
				temp = "Live Polling Stopped as there were no datapoints loggend during this duration<br><br>" + url + "<br><br>Only datapoints that have at least on data log entry will be polled."; 
				temp += '<br>Increase the Log Data duration or change the Datapoint entry to a Device name, use Datapoint List or Favorite DPs List (create list using the Datapoint View or Favorite DPs View)';
				document.getElementById("main").innerHTML = temp;
			}

		}
	}
	else {
		if(mode === 0)
			document.getElementById("main").innerHTML = "No Data Logs found."
		return;
	}
/*
		datalogStartLiveDataPolling(); //fixxzzz 
		g_idpGetRequestIndex = 0;
		g_PollingType = DISPLAYMODE_DATALOGONETIMELIVEPOLL;
		ivbWsProcessDatapointUpdate = true;
		getOnDemandDpValues(3, "");
	*/	
	
}

function datalogStartLiveDataProcessDeviceDpList(mode, requestUrl, json) {
	try {
		var bError = false;
		if(g_iMainDisplayMode !== DISPLAYMODE_DATALOG)
			return;
		if(g_iDatalogPollMode === 0)
			return;
		if(json === null) 
			bError = true;
		else if (json.length === 0)
			bError = true;
		if(bError) {
			document.getElementById("main").innerHTML = mode + " is not found or no datapoints are available";
			return;
		}
		datalogLiveDataDpList = json;
		datalogStartLiveDataPolling();
	}
	catch (err) {}

}
function datalogStartLiveDataPolling() {
	// Do initial request and and enable polling at 5 seconds rate
	let objList = [];
	var url = document.getElementById("dataLogDpUrl").value;
	var url1 = url.toLowerCase();
	var paneContent = "";
	if(g_iDatalogPollMode === 0)
		return;

	if((url1 === "favorite dps list") || (url1 === "datapoints list") || dataLogCheckIfUrlIsForDevice(url1) || (url.indexOf("/") !== -1)) {
		createRequestString(datalogLiveDataDpList);
	}
	else if(url1 === "all dps") {
		if(datalogLiveDataDpList.length === 0) {
			if(g_iDatalogPollMode === 1) {
				paneContent = "No Datapoints found";
				if(g_bDatalogPollingEnabled)
					paneContent += " so no live polling";
				document.getElementById("main").innerHTML = paneContent;
				g_idpGetRequestIndex = -1;
				return;
			}

		}
		createRequestString(datalogLiveDataDpList);
	}

}
function dataLogUrlRequest() {
	try {
		
			dataLogDpList = [];
			dataLogList = [];
			var url = document.getElementById("dataLogUrl").value;
			if(url !== "") {
				url = "https://" + location.hostname + "/iap/alarms?activeOnly=true&order=asc&sortBy=timestamp";
				requestGetData(mode, url, datalogResponse, readFailCallback);
			}
		
		
	} catch {}
}

function datalogResponse(mode, requestUrlString, json) {
	if(g_iMainDisplayMode !== DISPLAYMODE_DATALOG)
		return;
	
	if ((json.length === 0) && (g_ArrPaginationResponse.length === 0)) {
		document.getElementById("main").innerHTML = "No Log Data Available";
		return;
	}
	else if((mode === 4) || !g_bUseWebSocketsForDataLog) {
		if(json.length === 0) {
			document.getElementById("main").innerHTML += "";
			datalogResponseProcessData(mode, requestUrlString, g_ArrPaginationResponse);  // ffixxxxx Add pagination response
			g_ArrPaginationResponse = [];
			requestInProgress = 0;
		}
		else if (requestUrlString.indexOf("/iap/devs/*/if/*/*/*/logs/value/*?pg=1&sz=1&noxs=true") > 0){
			datalogResponseProcessData(0, requestUrlString, json);
		}
		else if (g_bAbort) {
			document.getElementById("main").innerHTML = "User Abort";
		}
		else {
			g_ArrPaginationResponse = g_ArrPaginationResponse.concat(json); // Get results
			var iPtr,k;
			url = requestUrlString;
			iPtr = requestUrlString.indexOf("&pg=");
			if(iPtr > 0)
				url = requestUrlString.substr(0, iPtr);
			g_iPaginationPage ++;
			url += "&pg=" + g_iPaginationPage + "&sz=" + g_iPaginationPageSize;
			requestGetData(0, url, datalogResponse, readFailCallback);
			document.getElementById("main").innerHTML += ".";
		}
	}
}
function datalogChangePollMode (value) {
	var datalogpoll = document.getElementById("datalogPoll");
	if(typeof value === "string")
		value = Number(value);
	g_iDatalogPollMode = value; //ffixx need to add code if Poll mode change after already polling
	if(g_iDatalogPollMode === 2)
		document.getElementById("datalogRequestButton").disabled = true;
	else
		document.getElementById("datalogRequestButton").disabled = false;
	if(datalogpoll !== null) {
		g_iDataLogPollCountMax = -1;
		g_PollingType === DISPLAYMODE_NONE;
		datalogEnablePolling(0);
	}
}
function datalogChartLineType() {
	if(document.getElementById("chartLineType").checked)
		g_iDatalogChartLineType = 1;
	else
		g_iDatalogChartLineType = 0;
	datalogChartUpdate(2);
}
function datalogChartYFullScale() {
	g_bDatalogChartYMinMax = document.getElementById("chartYFullScale").checked;
	datalogChartUpdate(1);
}
function datalogChartYaxisSelected(value) {
	try {

		g_iDatalogChartLineSelectedYaxis = value;
		datalogChartUpdate(1);
	}
	catch {}
}
function datalogEnablePolling(mode) {
	//mode: 0=normal usage, 1=ignore some functions
	try {
		var bContinue = true;
		var temp;
		//if((dataLogList.length > 0) || (g_iDatalogPollMode > 0)) {
			
			if(document.getElementById("datalogPoll").checked) {
				g_bDatalogPollingEnabled = true;
				if(g_iDatalogPollMode > 0) {
					if(!g_bdatalogLiveDataConfigured) {
						datalogStartLiveData(1);
						return;
					}
					if(datalogLiveDataDpList.length === 0)
						return;
					if(mode === 0) {
						if(g_iDatalogPollMode === 2) {
							temp = document.getElementById("dataLogChartSvg");
							if((datalogLiveDataDpList.length === 0) || (temp === null)) {
								dataLogRequest();
								bContinue = false;
							}
						}
						else {
							
							if(datalogLiveDataDpList.length === 0) {
								if(datalogLiveDataDpList.length === 0)
										return; // no datapoints listed
							}
							else {
								try {
									//fffffffff
								}
								catch (err) {}
							}
						}
						if(bContinue)
							datalogStartLiveDataPolling();
					}
					temp = document.getElementById("datalogRate").value;
					if(isNaN(temp)) 
					{
						showAlertDialog(0,"Poll Rate is not a number: " + temp );
						return;
					}
					else if(temp.indexOf(".") !== -1) {
						showAlertDialog(0,"Poll Rate is invalid: " + temp + "\r\n\r\nCannot be a decimial number, only integers");
						return;
					}
					g_iPollingRequestCountMax = Number(temp); // * 60;
					g_iDataLogPollrate = g_iPollingRequestCountMax;
					g_PollingType = DISPLAYMODE_DATALOGLIVEPOLL;
					g_iPollingRequestCount = 0;
					g_idpGetRequestIndex = 0;
					g_bPollingEnabled = true;
					g_iPollingRequestCount = g_iPollingRequestCountMax;
					if((g_iDatalogPollMode === 2) && (g_bDatalogUrlChanged)) {
						dataLogDpUrlChanged();
					}
					else
						ivbWsProcessDatapointUpdate = true;
					try {
						if(g_timerId === 0)
							g_timerId = window.setInterval("timerHandler()", g_iTimerInterval);
					} catch (err) {} 
					
				}
				else {
					g_bDataLogChartUpdateLastEntryToCurrentTimestamp = true;
					if(g_iDataLogPollCountMax === -1)
						g_iDataLogPollCount = 0;
					temp = document.getElementById("datalogRate").value;
					if(isNaN(temp)) 
					{
						showAlertDialog(0,"Poll Rate is not a number: " + temp );
						return;
					}
					else if(temp.indexOf(".") !== -1) {
						showAlertDialog(0,"Poll Rate is invalid: " + temp + "\r\n\r\nCannot be a decimial number, only integers");
						return;
					}
					g_iDataLogPollCountMax = Number(temp); // * 60;
					g_iDataLogPollrate = g_iDataLogPollCountMax;
					g_PollingType = DISPLAYMODE_DATALOG;
					try {
						if(g_timerId === 0)
							g_timerId = window.setInterval("timerHandler()", g_iTimerInterval);
					} catch (err) {} 
				}
			}
			else {
				g_iDataLogPollCountMax = -1;
				g_PollingType = DISPLAYMODE_NONE;
				g_bPollingEnabled = false;
				ivbWsProcessDatapointUpdate = false;
				g_bDatalogPollingEnabled = false;
			}
			 
		//}
	}
	catch {}
}

function datalogResponseProcessData(mode, requestUrlString, json) {
 // This function supports Datalog log data plus live data
// mode: 0= from initial response, 1= append, 2=websocket append(ascending order)  3= show existing list, 4=same as 0 but don't modify UI
// mode 20=, 22=, 30=datapoint list and device live only
 // For all modes except mode = 2 data in descending order,  UI shows descending order
 //  mode=2 inserts new logs into table so discard the panecontent
 
	try {
		var i, j, k, iPtr, iTemp, iIndex, iCount;
		var url = g_sDataLogDpPath.toLowerCase();
		var obj = {}, obj1, origList = [],dpObjList = [];
		var currentLogList = [];
		var startTime = new Date();
		var currentTime;
		var temp, url, url1;
		var bNoDataRemoveChart = false;// this is used when url specifies multiple datapoints and no logs meet criteria.  "<DP 1>,<DP2>" or "xifname:<DP 3>,<DP 4>"
		var timestamp;
		var table = null; 
		var row;
		var rowClass;
		var currentTimestampMs;
		var d1 = new Date;
		var d2;
		var bContinue = true, bLiveData = false;
		var bXifName = false, pathnames = [], tempObjList = [], tempList = [], bValid = true;
		var bLiveDataRequest = false;
		var pathnames = url.split("/");
		var urlPathnames;
		var chartMode = 0;
		var bInitialLogRequestButNoRequiredDps = false;
		var dpPath,sTemp;
		var addToList = 0; // 0= don't add, 1 add to datalog list but not to current list, 2 = add to both
		var cells = [];
		var id1 = " ", deviceHealth = " ",  deviceId = " ",  deviceName = " ",  datapointName = " ", blockIndex = " ", dpQualifier = " ", name = "";
		var blockName = " ", blockIndex = " ", deviceHealth = " ", deviceState = " ", utc = " ",  local = " ", dpQualifier = " ", presetValue = " ";
		var locValue = " ", locValueStr = " ";
		var bAddChartData = false; // Chart is only shown if single datapoint and only if it is a scalar
		var bAtLeastOneNewDatapoint = false;
		var chartContent = "";
		var paneContent = "<tHead><tr><th onclick=\"sortTable(0)\">#</th><th onclick=\"sortTable(1)\">Timestamp</th>";
		paneContent += "<th class=\"tableLogDeviceName\" onclick=\"sortTable(2)\">Device</th><th onclick=\"sortTable(3)\">Block</th><th onclick=\"sortTable(4)\">DP</th>";
		paneContent += "<th onclick=\"sortTable(5)\">Preset</th>";
		paneContent += "<th onclick=\"sortTable(6)\">Local Value</th><th onclick=\"sortTable(7)\">Value</th>";
		paneContent += "<th onclick=\"sortTable(8)\">DeltaValue</th><th onclick=\"sortTable(9)\">DeltaTime</th>";
		paneContent += "<th onclick=\"sortTable(10)\">Device State</th><th onclick=\"sortTable(11)\">PathName</th></tHead><tbody>"; 
		currentTimestampMs = d1.getTime();
		if((mode === 20) || (mode === 22)) {
			bLiveDataRequest = true;
			if((document.getElementById("dataLogChartSvg") === null) || (document.getElementById("myTable") === null))
				mode = 0;
			else
				mode -= 20;
			//if(json.length === 0)
			//	bInitialLogRequestButNoRequiredDps = true;
		}
		else if (mode === 30) {
			bInitialLogRequestButNoRequiredDps = true;
			mode = 0;
		}

		if(mode === 0)
			dataLogList = [];
		if(mode !== 3) {
			if((json.length === 0) && !bInitialLogRequestButNoRequiredDps) {
				if(mode !== 2) {
					if((g_iMainDisplayMode === DISPLAYMODE_DATALOG) && (g_iDatalogPollMode === 0))
						document.getElementById("main").innerHTML = "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">No Data Logs Available</span></div>";
				}
				return;
			}
			if((mode === 2) && g_bDatalogChartZoomInProgress)
				return; // don't update table or chart while zooming into chart
			for(i= 0; i < json.length; i ++)
			{ 
				sTemp = json[i].deviceName + "/" + json[i].blockName + "/" + json[i].blockIndex + "/";
				if(typeof json[i].name === "undefined") {
					sTemp += json[i].datapointName;
					json[i].name = json[i].datapointName;
				}
				else if(json[i].name !== null)
					sTemp += json[i].name;
				else {
					sTemp += json[i].datapointName;
					json[i].name = json[i].datapointName;
				}
				json[i].pathname = sTemp; // needed for Datapoints list and Favorite DPs List
/*	remove			
				if(json[i].dpQualifier === null) { // workaround for 3.1
					dpQualifier = json[i].deviceName + "/" + json[i].blockName + "/" + json[i].blockIndex + "/" + json[i].datapointName; 
					json[i].dpQualifier = dpQualifier;
				}
*/
			}

			origList = json;
			url = document.getElementById("dataLogDpUrl").value;
			url1 = url.toLowerCase();
			if(url.startsWith("/iap/ws")) {
				// device name or datapoint for live data
				origList = json;
			}
			else if(url.indexOf("/") !== -1) {
				if(url.indexOf(",") === -1) 
					origList = json;
				else {
					origList = json;
					json = [];
					bXifName = false;
					pathnames = [];
					tempObjList = [];
					tempList = [];
					bValid = true;
					sTemp = url;
					iPtr = sTemp.indexOf("xifname:");
					if(iPtr !== -1) {
						iPtr += "xifname:".length;
						sTemp = sTemp.substr(iPtr);
						bXifName = true;
					}
					sTemp = sTemp.trim();
					
					pathnames = sTemp.split(",");
					tempObjList = [];
					tempList = [];
						// create list of pathnames
					for(i=0; i < pathnames.length; i++)
					{ //123a
						tempObjList = pathnames[i].split("/");
						for(j=0; j < tempObjList.length; j++)
						{
							tempObjList[j] = tempObjList[j].trim();
							if(j === 2) {
								if(tempObjList[j] !== "*")
									tempObjList[j] = Number(tempObjList[j]);
							}
						}
						tempList.push(tempObjList);
					}
					// check if dp response is for expected datapoint
					
					for(i= 0; i < origList.length; i ++)
					{ 
						
						for(j=0; j < tempList.length; j++)
						{	
							
							for(k=0; k < 4; k++)
							{
								bValid = false;
								if(tempList[j][k] === "*") {
									bValid = true;
								}
								else {
									if(k === 0) {
										if(tempList[j][k] == origList[i].deviceName) {
											bValid = true;
										}
										
									}
									else if(k === 1) {
										if(bXifName) {
											if(tempList[j][k] === origList[i].blockName) {
												bValid = true;
											}
											
										}
										else {
											if(tempList[j][k] === origList[i].blockName) {
												bValid = true;
											}
										}
									}
									else if(k === 2) {
										if(tempList[j][k] === origList[i].blockIndex) {
											bValid = true;
											
										}
									}
									else if(k === 3) {
										if(bXifName) {
											if(tempList[j][k] === origList[i].datapointName) {
												bValid = true;
												break;
											}
										}
										else {
											if(tempList[j][k] === origList[i].name) {
												bValid = true;
												break;
											}
										}
									}
									
								}
								if(!bValid)
									break;
								
							} //for(k=0;
							if(bValid)
								break;
						} //for for(j=0;
						if(bValid) {
							json.push(JSON.parse(JSON.stringify(origList[i])));
						}
					} //for(i= 0;
					if(json.length === 0)
						bNoDataRemoveChart = true;
				}
			}
			/*
			else if((g_iDatalogPollMode !== 2) && (url.indexOf("/") !== -1)) { // may need to do something with g_iDatalogPollMode === 1
				origList = json;
				json = [];
				urlPathnames = url.split(",");
				for(i=0; i < urlPathnames.length; i++)
				{
					urlPathnames[i] = urlPathnames[i].toLowerCase().trim();
				}
				for(i=0; i < origList.length; i++)
				{
					dpPath = origList[i].deviceName + "/" + origList[i].blockName + "/" + origList[i].blockIndex + "/";
					if(origList[i].name !== null)
						dpPath += origList[i].name;
					else 
						dpPath = origList[i].datapointName;
					dpPath = dpPath.toLowerCase();
					for(j=0; j < urlPathnames.length; j++)
					{
						if(urlPathnames[j] === dpPath) {
							json.push(JSON.parse(JSON.stringify(origList[i])))
							break;
						}
					}
				}
				
			}
			*/
			else if((url1 === "datapoints list") || (url1 === "favorite dps list")) {
				// device name
				origList = json;
				json = [];
				if(g_iDatalogPollMode === 0)
					dpObjList = g_datalogUrlDpXifList;
				else if(g_iDatalogPollMode === 1) {
					if(datalogLiveDataDpList.length > 0) {
						if(typeof datalogLiveDataDpList[0].dpPath === "undefined") {
							for(j = 0; j < datalogLiveDataDpList.length; j++) 
								datalogLiveDataDpList[j].dpPath = datalogLiveDataDpList[j].pathname;
						}
						dpObjList = datalogLiveDataDpList;

					}
					else
						dpObjList = g_datalogUrlDpXifList;
				}
				else
					dpObjList = datalogLiveDataDpList;
				for(i=0; i < origList.length; i++)
				{
					//for(j = 0; j < g_datalogUrlDpXifList.length; j++) 
					for(j = 0; j < dpObjList.length; j++) 
					{
						//if(origList[i].pathname === g_datalogUrlDpXifList[j].dpPath) {
						if(origList[i].pathname === dpObjList[j].dpPath) { 
							json.push(JSON.parse(JSON.stringify(origList[i])))
							break;
						}
					}
				}
				
			}
			else if(!((url === "All DPs") || (url === "Get First Entry"))) {
				// device name or datapoint for live data
				if(url.indexOf("/") !== -1) {

				}
				else {
					origList = json;
					json = [];
					for(i=0; i < origList.length; i++)
					{
						if(origList[i].deviceName === url) {
							json.push(JSON.parse(JSON.stringify(origList[i])))
						}
					}
				}
			}
			
			if(json.length === 0) {
				if(mode !== 2) {
					if((g_iMainDisplayMode === DISPLAYMODE_DATALOG)  && (g_iDatalogPollMode === 0)) {
						document.getElementById("main").innerHTML = "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">No Data Logs Available</span></div>";
						return;
					}
					else if ((g_iDatalogPollMode === 1) && !bLiveDataRequest) {
						// GET datalog request has logged data but not for any of the required datapoints, add chart and table
						bInitialLogRequestButNoRequiredDps = true;
					}
					else if ((g_iDatalogPollMode === 2) && bInitialLogRequestButNoRequiredDps) {
						// No data just show chart, table and polling checkbox
					}
					else 
						return;
				}
				else
					return;
			}

			
			for(i= 0; i < json.length; i ++)
			{
				
				id1 = " "; deviceHealth = "";  deviceId = ""; deviceName = ""; datapointName = ""; blockIndex = ""; dpQualifier = ""; utc = ""; local = ""; dpQualifier = "";
				blockName = ""; blockIndex = ""; deviceHealth = ""; deviceState = ""; name="";
				timestamp = 0; presetValue = " "; locValueStr = ""; locValue = "";

				obj = json[i];
				bLiveData = false;
				try { id1 = obj.id;	} catch (err) {}
				try { local = obj.local; } catch (err) {}
				try { utc = obj.utc; } catch (err) {}
				try { dpQualifier = obj.dpQualifier; } catch (err) {}
				try { deviceId = obj.deviceId; } catch (err) {}
				try { deviceName = obj.deviceName; } catch (err) {}
				try { blockName = obj.blockName; } catch (err) {}
				try { blockIndex = obj.blockIndex; } catch (err) {}
				try { datapointName = obj.datapointName; } catch (err) {}
				try { name = obj.name; } catch (err) {}
				try {
					if(typeof obj.liveData !== "undefined")
						bLiveData = obj.liveData;
					
				}catch {}
				try { 
					if(typeof obj.deviceState !== "undefined")	// prior to 3.1 deviceState was included, 3.1 no longer have a preset value
						deviceState = obj.deviceState; 
				} catch (err) {}
				try { deviceHealth = obj.deviceHealth; } catch (err) {}
				try { 
					if(typeof obj.presetValue !== "undefined") { // prior to 3.1 presetValue always included, 3.1 presetValue only included if there is a preset value
						presetValue = obj.presetValue;
						if(presetValue === null)
							presetValue = " "; 
					}
				} catch (err) {}
					
				try { value = obj.value; } catch (err) {}
				try {
					if(typeof obj.timestamp !== "undefined")
						timestamp = obj.timestamp;
					else if(typeof obj.timestampStr !== "undefined") {
						d2 = Date.parse(obj.timestampStr);
						timestamp = d2.getTime();
					}
					else 
						timestamp = currentTimestampMs;
				 	}	 catch (err) { timestamp = currentTimestampMs; }

				try {
					if(!(typeof obj.localizedValue === "undefined"))
						locValue = obj.localizedValue;
					else if(!(typeof obj.locValue === "undefined")) 
						locValue = obj.locValue; // GET request
					if(locValue !== null) { 
						if(locValue !== "") {
							if(typeof locValue === "number")
								locValueStr = locValue;
							else
								locValueStr = JSON.stringify(locValue);
						}
					}
				}
				catch {}
				if(deviceState === "") // prior to 3.1 deviceState was included, 3.1 no longer have a preset value
					deviceState = deviceHealth;
				else if(deviceState === "provisioned")
					deviceState = deviceHealth;
				else
					deviceState = deviceState;
				valueStr = JSON.stringify(value);
				iPtr = local.indexOf("[");
				if(iPtr > 0) {
					local = local.substr(0, iPtr);
				}

				z = -1;
				for(j=0; j < dataLogDpList.length; j ++) 
				{
					if(dataLogDpList[j].dpQualifier === dpQualifier) {
						z = j;
						break;
					}
				}
				
				if(z === -1) {
					bAtLeastOneNewDatapoint = true;
					dataLogObj = {};
					dataLogObj.id = id1;
					dataLogObj.local = local.substr(0,(local.length - 6)).replace(/T/," "); 
					dataLogObj.utc = utc.substr(0,(utc.length - 5)); 
					dataLogObj.dpQualifier = dpQualifier;
					dataLogObj.deviceId = deviceId; 
					dataLogObj.deviceName = deviceName;
					dataLogObj.blockName = blockName;
					dataLogObj.blockIndex = blockIndex;
					dataLogObj.block = blockName + "/" + blockIndex;
					dataLogObj.dpName = datapointName; //XIF name
					dataLogObj.name = name; // DP instance name
					dataLogObj.pathname = deviceName + "/" + dataLogObj.block + "/" + datapointName;
					dataLogObj.pathnameUI = deviceName + "/" + dataLogObj.block + "/" + name;
					dataLogObj.min = null;
					dataLogObj.max = null;
					dataLogObj.localMin = null;
					dataLogObj.locMax = null;
					dataLogObj.hasNegativeNumbers = false; // only used for scalars

					
					dataLogObj.valueList = [];
					/*
					dataLogObj.valueList[0] = {};
					dataLogObj.valueList[0].value = value;
					dataLogObj.valueList[0].valueStr = valueStr;
					dataLogObj.valueList[0].locValue = locValue;
					dataLogObj.valueList[0].locValueStr = locValueStr;
					dataLogObj.valueList[0].presetValue = presetValue;
					dataLogObj.valueList[0].deviceState = deviceState;
					dataLogObj.valueList[0].timestamp = timestamp; // timestamp was defined by this program not in REST request
					*/
					dataLogObj.bNumber = false; 
					if(typeof value === "number") {
						dataLogObj.bNumber = true; 
						dataLogObj.min = value;
						dataLogObj.max = value;
						dataLogObj.locMin = locValue;
						dataLogObj.locMax = locValue;
						if(locValue < 0)
							dataLogObj.hasNegativeNumbers = true;
					}
						
					if(g_bDataLogWebSocketWorkaround) { //needed 2.80.015 can't determine url for specific pathnames
						
				
						if(url  === "all dps") {
								dataLogDpList.push(dataLogObj);
								z = dataLogDpList.length - 1;
						}
						else {
								
							bContinue = false;
							
							
							if(pathnames[0] === "*")
								bContinue = true;
							else {
								if(deviceName.toLowerCase() === pathnames[0])
									bContinue = true;
							}
							if(bContinue) {
								if(pathnames.length > 1) {
									bContinue = false;
									if(pathnames[1] === "*")
										bContinue = true;
									else {
										if(blockName.toLowerCase() === pathnames[1])
											bContinue = true;
									}
								}
							}
							if(bContinue) {
								if(pathnames.length > 2) {
									bContinue = false;
									if(pathnames[2] === "*")
										bContinue = true;
									else {
										if(blockIndex === pathnames[2])
											bContinue = true;
									}
								}
							}
							if(bContinue) {
								if(pathnames.length > 3) {
									bContinue = false;
									if(pathnames[3] === "*")
										bContinue = true;
									else {
										if(datapointName.toLowerCase() === pathnames[3])
											bContinue = true;
									}
								}
							}
							if(bContinue) {
								if(pathnames.length > 4)
									bContinue = false;
							}
							if(bContinue) {
								dataLogDpList.push(dataLogObj);
								z = dataLogDpList.length - 1;
							}
						}
					} //if(g_bDataLogWebSocketWorkaround)
					else {
						dataLogDpList.push(dataLogObj);
						z = dataLogDpList.length - 1;
					}
					
				} //if(z === -1)
				
				if(z !== -1) {
					
					obj = {};
					obj.deviceName = deviceName;
					obj.dpQualifier = dpQualifier;
					obj.block = blockName + "/" + blockIndex;
					obj.dpName = datapointName;
					obj.pathname = deviceName + "/" + obj.block + "/" + datapointName;
					obj.name = name;
					if(deviceState === "") {  // 3.1 no longer has deviceState
						obj.deviceState = deviceHealth;
					}
					else if(deviceState === "provisioned")
						obj.deviceState = deviceHealth;
					else
						obj.deviceState = deviceState;
					obj.value = value;
					obj.valueStr = valueStr;
					obj.locValue = locValue;
					obj.locValueStr = locValueStr;
					obj.presetValue = presetValue;
					obj.deviceState = deviceState;
					obj.deltaValue = 0;
					obj.local = local.substr(0,(local.length - 6)).replace(/T/," ");;
					obj.utc = utc.substr(0,(utc.length - 5));
					obj.timestamp = timestamp; // timestamp was defined by this program not in REST request
					obj.deltaTime = "0";
					obj.liveData = bLiveData;
					
					try {
						if(dataLogDpList[z].bNumber) {
							if(value > dataLogDpList[z].max)
								dataLogDpList[z].max = value;
							if(value < dataLogDpList[z].min)
								dataLogDpList[z].min = value;
							if(locValue > dataLogDpList[z].locMax)
								dataLogDpList[z].locMax = locValue;
							if(locValue < dataLogDpList[z].locMin)
								dataLogDpList[z].locMin = locValue;
							if(locValue < 0)
								dataLogDpList[z].hasNegativeNumbers = true;
						}
						if(mode === 2) {
							//if(dataLogDpList[z].valueList.length > 1) {
							if(dataLogDpList[z].valueList.length > 0) {
								iIndex = dataLogDpList[z].valueList.length - 1;
								if(dataLogDpList[z].bNumber) {
									if(mode === 2)
										obj.deltaValue =  value - dataLogDpList[z].valueList[0].value;
									else {
										//obj.deltaValue =  dataLogDpList[z].valueList[iIndex].value - value;
										// search json for next time dp shows up
									}
								}
								//iTemp = (timestamp - json[i + 1].timestamp) / 1000;
								//iTemp = (timestamp - dataLogDpList[z].valueList[iIndex].timestamp) / 1000;
								iTemp = (timestamp - dataLogDpList[z].valueList[0].timestamp) / 1000;
								
								if(iTemp < 60)
									obj.deltaTime = iTemp.toFixed(1) + " s";
								else if(iTemp < (60 * 60))
									obj.deltaTime = (iTemp / 60).toFixed(2) + " m";
								else if(iTemp < (60 * 60 * 24))
									obj.deltaTime = (iTemp / (60 * 60)).toFixed(2) + " hours";
								else 
									obj.deltaTime = (iTemp / (60 * 60 * 24)).toFixed(2) + " days";
							}
						}
						else if(json.length > 1){
							// First time read DP not in datalogDpList still need to find deltas - need to find other entry in json
							// find next entry for same datapoint
							for(k=(i + 1); k < json.length; k++)
							{
								if(dpQualifier === json[k].dpQualifier) {
									if(dataLogDpList[z].bNumber) {
										obj.deltaValue = value - json[k].value;
									}
									//iTemp = (timestamp - json[i + 1].timestamp) / 1000;
									iTemp = (timestamp - json[k].timestamp) / 1000;
									if(iTemp < 60)
										obj.deltaTime = iTemp.toFixed(1) + " s";
									else if(iTemp < (60 * 60))
										obj.deltaTime = (iTemp / 60).toFixed(2) + " m";
									else if(iTemp < (60 * 60 * 24))
										obj.deltaTime = (iTemp / (60 * 60)).toFixed(2) + " hours";
									else 
										obj.deltaTime = (iTemp / (60 * 60 * 24)).toFixed(2) + " days";
									break;
								}
							}
						}
					}
					catch {}
					
					obj1 = {}
					obj1.value = value;
					obj1.valueStr = valueStr;
					obj1.locValue = locValue;
					obj1.locValueStr = locValueStr;
					obj1.deviceState = deviceState;
					//obj1.presetName = presetName; // not used
					obj1.timestamp = timestamp;
					obj1.liveData = bLiveData;
					
					if(mode === 2) { // add ascending order items to beginning of list
						addToList = 2;
						if(bLiveData) {
							// check if 
							if(dataLogDpList[z].valueList.length > 0) {
								//if(dataLogDpList[z].valueList[0].liveData) {
								// compare old and new values if the same update timestamp don't add to list just update last entry
									if(isEqual (dataLogDpList[z].valueList[0].value, value)) {
										addToList = 1;
										if(dataLogDpList[z].valueList.length > 1) {
											if(isEqual (dataLogDpList[z].valueList[1].value, value)) {
												addToList = 0; // need to maintain inital timestampso need two entries of same value, after always change last value timestamp
												dataLogDpList[z].valueList[0].timestamp = timestamp;
											}
										}
									}
								//}
							}
						}
						
						if(addToList > 1) {
							currentLogList.push(obj);  // allows new log values to be inserted in exisiting table versus re creating table from scratch
							
						}
						if(addToList > 0) {
							
							dataLogDpList[z].valueList.unshift(obj1);
						}
					}
					else { // add descending order items to end of list
						addToList = 2;
						if(bLiveData) {
							// check if 
						}
						
						if(addToList > 0) {
							currentLogList.push(obj);  // allows new log values to be inserted in exisiting table versus re creating table from scratch
							dataLogDpList[z].valueList.push(obj1);
						}
					}
					
				} //if(z !== -1)
				
			} //for(i= 0; 
			

			// Show log
			len = dataLogList.length;
			j = currentLogList.length;
			
			if(mode === 2)
				table = document.getElementById("myTable");
			for(i=0; i < currentLogList.length; i++)
			{
				obj = {};
				obj = currentLogList[i];
				if(mode === 2) {
					dataLogList.unshift(obj);

					if(g_iMainDisplayMode === DISPLAYMODE_DATALOG) {
						row = table.insertRow(1);
						cells = [];
						for(k=0; k < 12; k++)
						{
							cells[k] = row.insertCell(k);
							if(obj.deviceState === "") {

							}
							else if(!(obj.deviceState === "normal"))
								cells[k].style.backgroundColor = "violet";
						}
						cells[0].innerHTML = (len + i + 1).toString();
						cells[1].innerHTML = obj.local;
						cells[2].innerHTML = obj.deviceName;
						cells[3].innerHTML = obj.block;
						cells[4].innerHTML = obj.name; //obj.dpName;
						cells[5].className = "tdPreset";
						cells[5].innerHTML = obj.presetValue;
						cells[6].className = "tdValue";
						cells[6].innerHTML = "<div class=\"tdValueDiv\">" + obj.locValueStr  + "</div>";
						cells[7].className = "tdValue";
						cells[7].innerHTML = "<div class=\"tdValueDiv\">" + obj.valueStr  + "</div>";
						if(typeof obj.locValue === "number")
							cells[8].innerHTML = obj.deltaValue;
						else 
							cells[8].innerHTML = "-";
						cells[9].innerHTML = obj.deltaTime;
						cells[10].innerHTML = obj.deviceState;
						cells[11].innerHTML = obj.pathname
					}
					//row.background
				}
				else {
					dataLogList.push(obj);
					rowClass = "tdDown";
					if((obj.deviceState === "normal") || (obj.deviceState === ""))
						rowClass = "tdNormal"
					paneContent += "<tr class=\"" + rowClass + "\"><td>" + (len + j - i).toString() + "</td><td>" + obj.local + "</td><td>" + obj.deviceName + "</td>";
					//paneContent += "<td>" + obj.block + "</td><td>" + obj.dpName + "</td>";
					paneContent += "<td>" + obj.block + "</td><td>" + obj.name + "</td>";
					paneContent += "<td class=\"tdPreset\">" + obj.presetValue  + "</td>";
					paneContent += "<td class=\"tdValue\"><div class=\"tdValueDiv\">" + obj.locValueStr  + "</div></td><td class=\"tdValue\"><div class=\"tdValueDiv\">" + obj.valueStr  + "</div></td>";
					paneContent += "<td>";
					if(typeof obj.locValue === "number")
						paneContent += obj.deltaValue 
					else
						paneContent += "-";
						
					paneContent +=  "</td><td>" + obj.deltaTime + "</td>";
					paneContent += "<td>" + obj.deviceState + "</td><td>" + obj.pathname + "</td></tr>"; 
					 

				}
			} //for(i=0;
		} // if(mode !== 3)
		else {
			// mode === 3  - cached values
			// Show log
			len = dataLogList.length;
			iCount = len;
			if(dataLogList.length > g_iDataLogMaxToShow)
				iCount = g_iDataLogMaxToShow;
			for(i=0; i < dataLogList.length; i++)
			{
				obj = {};
				obj = dataLogList[i];
				paneContent += "<tr><td>" + (len - i).toString() + "</td><td>" + obj.local + "</td><td>" + obj.deviceName + "</td>";
				paneContent += "<td>" + obj.block + "</td><td>" + obj.dpName + "</td>";
				paneContent += "<td class=\"tdPreset\">" + obj.presetValue  + "</td>";
				paneContent += "<td class=\"tdValue\"><div class=\"tdValueDiv\">" + obj.locValueStr  + "</div></td><td class=\"tdValue\"><div class=\"tdValueDiv\">" + obj.valueStr  + "</div></td>";
				paneContent += "<td >" + obj.deltaValue + "</td><td>" + obj.deltaTime + "</td>";
				paneContent += "<td>" + obj.deviceState + "</td>";
				paneContent += "<td>" + obj.pathname + "</td></tr>"; 
			}
		}
		g_sDataLogDuration = "";
		g_sDataLogStartTime = "";
		if(dataLogList.length > 1) {
			g_sDataLogDuration = dataLogList[dataLogList.length - 1].local + " thru " + dataLogList[0].local;
			iTemp = (dataLogList[0].timestamp - dataLogList[dataLogList.length - 1].timestamp) / 1000;
			temp = "";
			if(iTemp < 60)
				temp = iTemp.toFixed(1) + " sec";
			else if(iTemp < (60 * 60))
				temp = (iTemp / 60).toFixed(2) + " min";
			else if(iTemp < (60 * 60 * 24))
				temp = (iTemp / (60 * 60)).toFixed(2) + " hours";
			else 
				temp = (iTemp / (60 * 60 * 24)).toFixed(2) + " days";
			
			g_sDataLogDuration += " [" + temp + "]";
		}
		else {
			if(dataLogList.length > 0)
				g_sDataLogDuration = "Single entry -" + dataLogList[dataLogList.length - 1].local;
		}
		if(mode !== 2) {
			paneContent = "<br><br>Duration: <span id=\"datalogDuration\" style=\"margin-bottom:5px\">" + g_sDataLogDuration + "</span><br><table id=\"myTable\">" + paneContent + "</tbody></table>"; 
			temp = "<button onclick=\"datalogSmartSort()\">DP sort</button><button onclick=\"clearTable()\">Clear Log</button>";
			temp += "<button onclick=\"copyToClipboard(" + DISPLAYMODE_DATALOG + ")\">Copy to Clipboard</button>";
			temp += "<button onclick=\"saveData(0)\">Save</button>";
			if(mode !== 4) {
				if(g_iMainDisplayMode === DISPLAYMODE_DATALOG) {
					if(g_bShowDatalogChart) {
						if((dataLogDpList.length > 0) || (g_iDatalogPollMode === 2)){
							
							temp += "<input type=\"checkbox\" id=\"chartLineType\" style=\"margin-left:20px\" onchange=\"datalogChartLineType()\"";
							if(g_iDatalogChartLineType === 1)
								temp += " checked";
							temp += "> Stepline Chart";
							temp += "<input type=\"checkbox\" id=\"chartYFullScale\" style=\"margin-left:20px\" onchange=\"datalogChartYFullScale()\"";
							if(g_bDatalogChartYMinMax)
								temp += " checked";
							temp += "> Y-Axis show Min Max";
						}
						temp += "<div id=\"datalogRadioButtons\"style=\"display:inline-block;margin-left:20px\"></div>";  // only added if two Y axis are needed 
					}
				}
			}



			if(dataLogList.length <= g_iDataLogMaxToShow) {
				
				
				
				if(!g_bEnableDataLogLiveData) {
					temp += "<div style=\"float:right\">";
					temp += "<input id=\"datalogPoll\" type=\"checkbox\" onchange=\"datalogEnablePolling(0)\">Poll";
					temp += " <input id=\"datalogRate\" onblur=\"datalogEnablePolling(0)\" value=\"" + g_iDataLogPollrate + "\"> sec";
					temp += "<button onclick=\"subscribeRequest()\" style=\"visibility:";
					if(g_iDatalogPollMode > 0)
						temp += "visible";
					else
						temp += "hidden";
					temp += "\">Re-Subscribe</button>";
					temp += "</div>"
				}
				
			}
			paneContent =  temp + paneContent;
			if(dataLogList.length > g_iDataLogMaxToShow) {
				paneContent = "Too many Data Log items [" + dataLogList.length + "] - only showing last " + g_iDataLogMaxToShow + ", Click \"Copy to Clipboard\" to see full list<br>" + paneContent;
			}
		}
		
		if((mode === 0) || (mode === 4)) {
			try {
				currentTime = new Date();
				if(!bInitialLogRequestButNoRequiredDps) {
					if((g_dtDataLogStartTime !== null) && (g_dtDataLogReceiveTime !== null)) {

						paneContent += "<br>Initial Request TotalTime = " + timeDiff(g_dtDataLogStartTime, currentTime) + "[";
						paneContent += "Get time = " + timeDiff(g_dtDataLogStartTime, g_dtDataLogReceiveTime);
						paneContent += ", SortTime = " + timeDiff(g_dtDataLogReceiveTime, startTime);
						paneContent += ", TableCreation = " + timeDiff(startTime, currentTime);
						paneContent += ", Sort Interation = " + g_iDataLogSortInterations + "]";
					}
				}
			}
			catch {}
		}
		g_dtDataLogStartTime = null;
		g_dtDataLogReceiveTime = null;
		if(dataLogList.length > 0)
			g_iDataLogLatestTimestamp = dataLogList[0].utc;
		if((mode !== 2) && (mode !== 4)) {
			if(g_iMainDisplayMode === DISPLAYMODE_DATALOG) {
				if(g_bShowDatalogChart) {
					if((dataLogDpList.length > 0) || bInitialLogRequestButNoRequiredDps) {//if(dataLogDpList.length === 1) {
						//if(dataLogDpList[0].valueList.length > 0) {
						//	if(typeof dataLogDpList[0].valueList[0].value === "number") {
								// add datalog chart

								g_chartList = [];

								chartContent += '<div style=\"height:10px"><label id=\"chartRangeLabel\" style=\"width:200px\"></label><label id=\"mouseInfoLabel\" style=\"margin:left:50px\"></label></div>'
								chartContent += '<div style=\"display:flex\">';
								chartContent += '<div style="margin-left: 10px; margin-top:30px;">';
								//chartContent += '<div style="display:block; margin-left: 10px; margin-top:30px; width: 52px; height:436px; text-align:center; z-index: 5; ">';
								//chartContent += '<object id="dataLogChartSvg" type="image/svg+xml" style="width: 1000px;height: 400px;" data-izot-textcolor="white" data="images/chart1.svg"></object>';
								chartContent += '<object id="dataLogChartSvg" type="image/svg+xml" style="height: 400px;" data-izot-textcolor="white" data="images/chart3.svg"></object>';
								chartContent += '</div>';
								chartContent += '<div id=\"chartLegend\" style=\"display:block;min-width:300px\"></div></div><br>';

								//chartContent += '<br><br>';
								paneContent = chartContent + paneContent;
								chartMode = 0;
								if(requestUrlString !== null) {
									if(requestUrlString !== "") {
										// if there is an end date then chartMode=1
									}
								}
								
								g_datalogChartInfo.displayId = "dataLogChartSvg";
								datalogChartInit(1, g_datalogChartInfo.displayId);
								createChartObjectLargeChart3(true, chartMode, 0, "dataLogChartSvg", dataLogDpList); 
								g_iDatalogChartMode = 0;
								
								//createChartObjectLargeChart(chartMode, 0, "dataLogChartSvg", dataLogDpList[0].pathname, dataLogDpList[0].valueList, dataLogDpList[0].locMin, dataLogDpList[0].locMax, g_bDatalogChartYMinMax, "blue", "both");
								g_bUpdateCharts = true;
								g_bCreateChartLegend = true;
								g_bCreateChartLines = true;
								try {
									window.setTimeout("timerHandlerChart()", 1000);
								} catch (err) {} 
						//	}
						//}
					}
				}
				if(mode === 0)
					paneContent += addTopButton();
				document.getElementById("main").innerHTML = paneContent;
				
				if(g_bUpdateCharts) {
					//datalogChartAddEventListener("dataLogChartSvg");
					// zzzzzzz add y-axis radio buttons
					if(g_bDataLogChartUsesTwoYaxis) {
						
						datalogResponseAddChartRadioButtons();
					}
					else 
						g_iDatalogChartLineSelectedYaxis = 0;
				}
			}
		}
		if((mode === 0) || (mode === 1)) {
			// add pagination
		}
		if(mode === 2) {
			datalogPaneContent = "";
			if(g_iMainDisplayMode === DISPLAYMODE_DATALOG) {
				// fix - currently rebuilding chart info every time, modify code to just add new datapoints
				document.getElementById("datalogDuration").innerHTML = g_sDataLogDuration;
				g_chartList = [];
				chartMode = 0;
				
				
				createChartObjectLargeChart3(false, chartMode, 0, "dataLogChartSvg", dataLogDpList); 
				if(bAtLeastOneNewDatapoint) {
					// add new Datapoint lines
					createChartLegend();  
				}
				datalogChartUpdate(g_iDatalogChartMode);
				/* remove
				g_bUpdateCharts = true;
				g_iDatalogChartMode = 1;
				try {
					window.setTimeout("timerHandlerChart()", 1000);
				} catch (err) {} 
				*/
			}
		}
		else
			datalogPaneContent = paneContent;
		// start background polling 
		if(mode === 0) {
			if(g_iDatalogPollMode === 0) {
				//log + log
				// timerHandlerChart will start timerHandler
			}
			else {
				if(g_bEnableDataLogLiveData) {
					temp = document.getElementById("dataLogDpUrl").value;
					if(temp.trim().toLowerCase() === "all dps" ) {
						if(dataLogDpList.length > 0) {
							datalogLiveDataDpList = JSON.parse(JSON.stringify(dataLogDpList));
							datalogStartLiveData(1);
						}
						else {
							datalogLiveDataDpList = [];
							return; // no log data so don't poll data
						}
					}
					else {
						datalogStartLiveData(1);
					}
					
		
				}
			}
		}
		
	}

	catch (err) {
		document.getElementById("main").innerHTML = "<div style=\"text-align:center\"><br>Problem processing Datalog<br><br><p>" + err.toString() + "</p></div>";
	}
}
function datalogResponseAddChartRadioButtons () {
	var temp = "Y-Axis Displayed: <input type=\"radio\" id=\"datalogChartYaxisSelected_3\" name=\"yaxisselection\" onclick=\"datalogChartYaxisSelected(this.value)\" value=\"3\">Both Y1 and Y2 ";
	temp += "<input type=\"radio\" id=\"datalogChartYaxisSelected_1\" name=\"yaxisselection\" onclick=\"datalogChartYaxisSelected(this.value)\" value=\"1\">Y1 Only ";
	temp += "<input type=\"radio\" id=\"datalogChartYaxisSelected_2\" name=\"yaxisselection\" onclick=\"datalogChartYaxisSelected(this.value)\" value=\"2\">Y2 Only ";
	temp += "<input type=\"radio\" id=\"datalogChartYaxisSelected_0\" name=\"yaxisselection\" onclick=\"datalogChartYaxisSelected(this.value)\" value=\"0\">Single";
	document.getElementById("datalogRadioButtons").innerHTML = temp;
	
	document.getElementById("datalogChartYaxisSelected_" + g_iDatalogChartLineSelectedYaxis).checked = true;
}
function datalogSmartSort() {
	smartSortTable("desc", 8, 1, null) ;
}
function decodeJson(json, iTabs) {
	try {
		var result = "";
		var tabStr = "";

		if(Array.isArray(json))
		{
			iTabs ++;
			
			for(var i=0;i<json.length;i++){
				result += "\r\n";
					var obj = json[i];
				if (typeof obj === 'string')
				{
					
					for(j=0; j < iTabs; j++)
					{
						result += "\t";
					}
					result += obj;
				}
				else {
						for(var key in obj){
								var attrName = key;
							var attrValue = obj[key];
						result += "\r\n";
						for(j=0; j < iTabs; j++)
						{
							result += "\t";
						}
						result += attrName + ": ";
						if(attrValue !== null)
						{
							if ((typeof attrValue === 'string') || (typeof attrValue === 'number'))
							{
								result += attrValue;
							}
							else
							{
								result +=  decodeJson(attrValue, iTabs);
							}
						}
						//result += "\r\n" + attrName + ": " + attrValue;
					}
				}
			}				
			}
		else if ((typeof json === 'string') || (typeof json === 'number') 
			|| (typeof json === 'boolean'))
		{
			result += json;
		}
		else if ((json !== null) && (typeof json === 'object'))
		{	// object
				
			sTemp = JSON.stringify(json);
			/*
			try {
				sTemp = '{"name":"' + json.name + '","value":"' + json.value + '"}';
				$("#requestInputPutUrl").val($("#requestInput").val());
			} catch (err) {}
			$("#requestInputPutData").val(sTemp);
			*/
			tabStr = "";
			for(j=0; j < iTabs + 1; j++)
			{
				tabStr += "\t";
			}
			for(var key in json){
						var attrName = key;
						var attrValue = json[key];
				if ((typeof  attrValue === 'string') || (typeof  attrValue === 'number')
					|| (typeof attrValue === 'boolean'))
					result += "\r\n" + tabStr + attrName + ": " + attrValue;
				else if(attrValue === null)
					result += "\r\n" + tabStr + attrName + ": null";
				else 
					result +=  decodeJson(attrValue, iTabs + 1);
					
			}
		}
	}
	catch(err) {}
	return result;

}
function deviceStatusColorCanvas(displayId, category, deviceStatus) {
	try 
	{	var color = "lawngreen";;
		var c = document.getElementById(displayId);
		var ctx = c.getContext("2d");
		ctx.beginPath();
		ctx.arc(6,6,5, 0, 2 * Math.PI);
		if(category !== "SC")
			color = deviceStatusColor (deviceStatus);
		ctx.fillStyle = color;
		ctx.strokeStyle = ctx.fillStyle;
		ctx.stroke();
		ctx.fill();
	}
	catch {}
} 
function deviceStatusColorSvg(displayId, category, deviceStatus) {
	try 
	{
		var color = "lawngreen";
		var c = document.getElementById(displayId);
		if(c != null) {
			if(category !== "SC")
				color = deviceStatusColor (deviceStatus);
			c.style.fill= color;
		}
	}
	catch {}
} 
function deviceStatusColor (deviceStatus) {
	var color = "red";
	if(deviceStatus === "normal") {
		color = "lawngreen";
	}
	else if(deviceStatus === "down") {

		color = "red"; //"darkred";
	}
	else if(deviceStatus === "unprovisioned") {
		color = "blue";
	}
	else if(deviceStatus === "provisioning") {
		color = "cyan";
	}
	else if(deviceStatus === "suspect") {
		color = "gold";
	}
	else if(deviceStatus === "unlicensed") {
		color = "#663399";
	}
	else  {
		color = "darkred";
	}
	return color;

}
function displayDeviceStatus() {
	try {
		var i, iUp = 0, iDown = 0, iUnProvisioned = 0, iDevicesNoContext = 0, iUnlicensed = 0;
		var element, sTemp = "";
		if(g_bIngnoreDisplayingDeviceDeviceStatus)
			return;
		if(checkIfUserTypeSupported(g_bDisplayDevicesStatusInFooter)) {
		
			for(i=0; i < deviceListAll.length; i++)
			{
				if(deviceListAll[i].category === "SC")
					iUp ++;
				else if(deviceListAll[i].status.state === "unlicensed") 
					iUnlicensed ++;
				else if(deviceListAll[i].status.state === "provisioned") {
					
					if(deviceListAll[i].status.health === "normal")
						iUp ++;
					else {
						
							iDown ++;
					}
				}
				else 
					iUnProvisioned ++;
			//	if(deviceListAll[i].contexts.length === 0)
			//		iDevicesNoContext ++;
			}
			//sTemp = "Total Devices [" + deviceListAll.length + "]: UP = " + iUp + ", Down = " + iDown + ", Unprovisioned = " + iUnProvisioned;
			sTemp = ": " + deviceListAll.length + " [UP = " + iUp + ", Down = " + iDown + ", Unprovisioned = " + iUnProvisioned;
			if(iUnlicensed > 0)
				sTemp += ", Not Licensed = " + iUnlicensed;
			sTemp += "]";
			//if(iDevicesNoContext > 0)
			//	sTemp += "; Devices with no context (not in tree, use device view) = " + iDevicesNoContext;
			element = document.getElementById("footerStatus");
			if(element !== null)
				element.innerHTML = sTemp;
		}
	}
	catch(err) {}	
}
function encodeUriString(str) {
	// encodeURI and encodeURIComponent don't encode all the characters needed to be decoded by the SmartServer 
	// don't use on entire uri, just on the queries. That means you may need to run it on different parts of uri
	//e.g., Path Parameter /iap/devs/*+name={device_name}/if/{block_name}/{block_index}/{datapoint_name}/value [/{prop_name}]
	//     every name in surrounded iby "{}" may need to be individually encoded
	
	str = str.replace(/\//g,"%2F").replace(/\[/g,"%5B").replace(/\]/g,"%5D").replace(/&/g,"%26").replace(/=/g,"%3D").replace(/\+/g,"%2B").replace(/\*/g,"%2A");
	
	//str = encodeURIComponent(str);  // encodes most but not all - encodes "#$&+,/:;=?@[]   \"\r\n%<>\\^`{}|"
									// doesn't encode the following "!()*'-._~"
	//str = str.replace(/!/g,"%21").replace(/\(/g,"%28").replace(/\)/g,"%29").replace(/\*/g,"%2A").replace(/'/g,"%27").replace(/-/g,"%2D");
	//str = str.replace(/\./g,"%2E").replace(/_/g,"%2F").replace(/~/g,"%7E");
	
	return str;
}
function encodeNameStr(str) {
	str = str.replace(/ /g,"%20").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
	return str;
}
function encodePathString(str) {
	
									
	str = str.replace(/\[/g,"%5B").replace(/\]/g,"%5D");
	
	return str;
}
function encodePathString1(str) {
	// more restrictive then encodePathString(str) but not used yet
	// leaves slashes and "," but encodes most other special characters 
	 // encodes most but not all - encodes "#$&+,/:;=?@[]   \"\r\n%<>\\^`{}|"
									
	str = str.replace(/ /g,"%20").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
	str = str.replace(/!/g,"%21").replace(/\(/g,"%28").replace(/\)/g,"%29").replace(/\*/g,"%2A").replace(/'/g,"%27").replace(/-/g,"%2D");
	str = str.replace(/\./g,"%2E").replace(/_/g,"%2F").replace(/~/g,"%7E");
	return str;
}


function getActiveAlarms(mode, url) {
	
	// used for Web sockets
	if(url === "") {
		url = "https://" + location.hostname + "/iap/alarms?activeOnly=true&order=asc&sortBy=timestamp";
	}
	else {
		url = "https://" + location.hostname + url;
	}
	
	requestGetData(mode, url, getActiveAlarmsResponse, readFailCallback);
}

function getActiveAlarmsResponse(mode, requestUrlString, json) {

	if((mode === 9) || (g_iMainDisplayMode === DISPLAYMODE_DPINFO))  {
		if (json.length === 0) {
			g_sDpInfoPaneContent += " None";
			getDpInfoDla();
			return;
		}
	}
	else if ((json.length === 0) && (g_iMainDisplayMode === DISPLAYMODE_ACTIVEALARMS))  {
		g_sActiveAlarmsPaneContent = "No Active Alarms<br><br><br><div id=\"alarmDefinitions\">" + g_sActiveAlarmsAlarmDefinitionsPaneContent + "</div>";
		document.getElementById("gettingInfoId").innerHTML = g_sActiveAlarmsPaneContent;
		
		return;
	}
	else if (g_iMainDisplayMode !== DISPLAYMODE_ACTIVEALARMS)
		return;
	try {
		var i, j, iPtr, iPtr1, iPtr2;
		var dpValueRequestStr = "", bAddToList = false;
		var dpStr, url;
		var obj, alarmIndex, bAllAlarmsForDevice = false, bDpAlarm = false;
		var alarmObj = {};
		var id1 = " ",  timestamp = " ", state = " ", targetName = " ", targetType = "", details = "", uid = "", value = "", category = "", dpQualifier = "", dpPath = "", deviceName = "";
		var path = "";
		var deviceTypeName = "";
		
		var paneContent = "<tHead><tr><th>#</th><th>Menu</th><th>ID</th><th>Timestamp</th><th>Target Name</th><th>Target type</th><th>Target ID</th><th>Category</th>";
		paneContent += "<th class=\"tdValue\">Details</th>";
		if(mode !== 9)
			paneContent += "<th class=\"tdValue\">Current Value</th>";
		paneContent += "<th>Clear Alarm</th><th>PathName</th></tr></tHead><tbody>"; 

		

	
		  var bNewDeviceDetected = false;
/*		  
	  	if(latestTimestamp !== null) {
			timestampStr = new Date(convertIsoDateStringToDateObj(latestTimestamp));
			timestamp1ms = timestampStr.getTime();
		}
*/		
		activeAlarmList = [];
		g_sActiveAlarmList = "";
		
		for(i= 0; i < json.length; i ++)
	  	{
			id1 = " "; timestamp = " "; state = " "; targetName = " "; targetType = ""; details = ""; uid = ""; value = "";
			category = ""; dpQualifier = ""; dpPath = ""; deviceName = "";

			obj = json[i];
			
			try {
				id1 = obj.id;
			}
			catch (err) {}
			try {
				timestamp = obj.timestamp;
			}
			catch (err) {}
			
			try {
				state = obj.state;
			}
			catch (err) {}
			try {
				targetName = obj.device.name;
			}
			catch (err) {}
			try {
				targetType = obj.type;
			}
			catch (err) {}
			try {
				details = obj.details
			}
			catch (err) {}
			try {
				uid = obj.device.uid;
			}
			catch (err) {}
			try {
				category = obj.category;
			}
			catch (err) {}
				
			
			
/*			
				// get latest timestamp
			if(ivLatestTimestamp === null) {
				ivLatestTimestamp = timestamp1;
				timestampStr = new Date(convertIsoDateStringToDateObj(ivLatestTimestamp));
				timestamp1ms = timestampStr.getTime();
			}
			else {
				timestampStr = new Date(convertIsoDateStringToDateObj(timestamp1));
				timestamp2ms = timestampStr.getTime();
				if(timestamp2ms > timestamp1ms) {
					bTimeStampChanged = true;
					ivLatestTimestamp = timestamp1;
					timestamp1ms = timestamp2ms;
				}
			}
*/			
			bAddToList = true;
			bDpAlarm = false;
			dpPath = "";
			path = "";
			dpStr = "";
			try {
				iPtr = details.toLowerCase().indexOf("exceeded for ");
				if((category === "System-HW") && (iPtr > 1)) { 
					
					dpStr = details.substr(iPtr + "exceeded for".length);
					iPtr = dpStr.indexOf(". Triggered value is");
					if(iPtr > 0)
						dpStr = dpStr.substr(0, iPtr);
					dpStr = dpStr.trim();
					dpPath = dpStr;
					iPtr = dpStr.lastIndexOf(".");
					if(iPtr > 0 ) {
						iPtr1 = dpStr.lastIndexOf(".", iPtr - 1);
						iPtr2 = dpStr.lastIndexOf(" ", iPtr - 1);
						if((iPtr1 > 0) && (iPtr2 > 0)) {
							iPtr1 ++;
							iPtr2 ++;
							dpStr = dpStr.substr(iPtr1, iPtr2 - iPtr1 - 1) + "/" + dpStr.substr(iPtr2, iPtr - iPtr2) + "/" + dpStr.substr(iPtr + 1);
							bDpAlarm = true;
							for(j=0; j < deviceListAll.length; j ++)
							{
								if(deviceListAll[j].name === targetName) {
									deviceName = targetName;
									dpQualifier = deviceListAll[j].scId + "/" + deviceListAll[j].protocol + "/" + deviceListAll[j].DID + "/" + dpStr;
									if(dpValueRequestStr !== "")
										dpValueRequestStr += ",";
									dpValueRequestStr += dpQualifier;
									dpStr = targetName + "/" + dpStr;
									path = dpStr;
									break;
								}

							}
							if(mode === 9) {
								if(g_bDpInfoForDevice) {
									if(deviceName !== g_sDpInfoProgrammaticPathname)
										bAddToList = false;
								}
								else if(dpStr !== g_sDpInfoProgrammaticPathname)
									bAddToList = false;
							}
							
						}
					}
				}

			} catch {}
			if(bAddToList) {
				alarmObj = {};
				alarmObj.timestamp = timestamp;
				alarmObj.id = id1;
				alarmObj.uid = uid;
				alarmObj.details = details;
				alarmObj.state = state;
				alarmObj.type = targetType;
				alarmObj.name = targetName;
				alarmObj.category = category;
				alarmObj.path = dpPath;
				alarmObj.dpQualifier = dpQualifier;
				activeAlarmList.push(alarmObj);
				alarmIndex = activeAlarmList.length - 1;
				
				
				paneContent += "<tr><td>" + (i + 1).toString() + "</td>";
				if(bDpAlarm)
					paneContent += "<td><button id=\"dpDlaMenu_" + id1 + "\" onclick=\"menuDla(5, event, '" + id1 + "','" + path + "')\">...</button></td>";  //8888
				else
					paneContent += "<td></td>";
				
				paneContent += "<td>" + id1 + "</td><td>" + timestamp + "</td><td>" + targetName + "</td><td>" + targetType + "</td><td>" + uid + "</td>";
				paneContent += "<td class=\"tdValue\">" + category + "</td><td class=\"tdValue\">" + details + "</td>";
				if(mode !== 9)
					paneContent += "<td id=\"alarmcurrentvalue_" + dpQualifier + "\" class=\"tdValue\">---</td>";
				paneContent += "<td><button style=\"margin-left:5px;margin-right:5px\" onclick=\"clearAlarm(" + alarmIndex + ", " + id1 + "," +  (alarmIndex + 1) + ")\">Clear</button></td>"; 
				//paneContent += "<td><button style=\"margin-left:5px;margin-right:5px\" onclick=\"clearAlarm(" + alarmIndex + ", " + id1 + ", '" + dpPath  + "'," +  (alarmIndex + 1) + ")\">Clear</button></td>"; //remove
				paneContent += "<td>" + dpStr + "</td></tr>";
			}	
		} //for(i= 0; 
		paneContent = "<br><table id=\"alarmTable\">" + paneContent + "</tbody></table>";
		if(mode === 9) {
			if(activeAlarmList.length > 0)
				g_sDpInfoPaneContent += paneContent;
			else 
				g_sDpInfoPaneContent += " None";
			getDpInfoDla();
			return;
		}
		document.getElementById("main").innerHTML = paneContent;

		if(dpValueRequestStr !== "") {
			dpValueRequestStr = encodeURI(dpValueRequestStr);
			dpValueRequestStr = dpValueRequestStr.replace(/\//g,"%2F");
			
			if( mode === 0)
				url = "https://" + location.hostname + "/iap/devs/*/if/*/*/*+qualifier=-" + dpValueRequestStr + "/value?noxs=true";
			else if( mode === 1)
				url = "https://" + location.hostname + "/iap/devs/*/if/*/*/*+qualifier=-" + dpValueRequestStr + "/value?max_age=0&noxs=true";
			requestGetData(0, url, getActiveAlarmsValuesResponse, readFailCallback);
		}
	}
	catch (err) {}

}
function  getActiveAlarmsValuesResponse (mode, requestUrlString, json) {

	try {
		var type = 0;
		var i, j, k, z, len, iCount;
		var obj, dpObj;
		var id1 = " ", name1 = " ", value1 = " ", timestamp1 = " ", url1 = " ", value2;
		var notes1 = " ", type1 = " ", dir1 = " ", device1 = " ", units1 = " ", blockIndex = " ", blockName = " ";
		var datapointQualifier = " ";
		var pathname = " ";
		var bContinue = true;
		var len = dpList.length - 1;
		var tempObj;
		if ((json.length === 0) || (g_iMainDisplayMode !== DISPLAYMODE_ACTIVEALARMS)) {
		
			return;
		}
		for(i= 0; i < json.length; i ++)
	  	{
			id1 = " ";
			name1 = " ";
			value1 = " ";
			timestamp1 = " ";
			url1 = " ";
			notes1 = " ";
			type1 = " "; 
			dir1 = " ";
			device1 = " ";
			units1 = " ";
			datapointQualifier = " ";
			pathname = "";

			obj = json[i];
			if(type === 0) {
				try {
					name1 = obj.datapointName
				}
				catch (err) {}
				try {
					id1 = obj.id
				}
				catch (err) {}
				try {
					//type1 = obj.type
				}
				catch (err) {}
				try {
					timestamp1 = obj.timestamp
				}
				catch (err) {}
				try {
					url1 = obj.url
				}
				catch (err) {}
				try {
					value1 = obj.value
				}
				catch (err) {}
				try {
					notes1 = obj.notes
				}
				catch (err) {}
				try {
					blockIndex = obj.blockIndex
				}
				catch (err) {}
				try {
					blockName = obj.blockName
				}
				catch (err) {}
				try {
					device1 = obj.deviceName
				}
				catch (err) {}
				try {
					//active1 = obj.active
				}
				catch (err) {}
				try {
					//state1 = obj.state
				}
				catch (err) {}
				try {
					datapointQualifier = obj.dpQualifier;
				}
				catch (err) {}
				pathname = device1 + "/" + blockName  + "/" + blockIndex  + "/" + name1;
			}
			else if(type === 1) { 
				// Web socket response
				try {
					datapointQualifier = obj.datapointQualifier;
				}
				catch (err) {}
				try {
					value1 = obj.value
					
				}
				catch (err) {}
			}
			valueStr = JSON.stringify(value1);

			document.getElementById("alarmcurrentvalue_" + datapointQualifier).innerHTML = valueStr;
		}
		g_sActiveAlarmsPaneContent = document.getElementById("main").innerHTML;
	} catch {}
}
function getActiveAlarmsCount(mode) {
	
	var url = "https://" + location.hostname + "/iap/alarms/count?activeOnly=true";
	g_bAlarmsCountRequestInProgress = true;
	requestGetData(mode, url, getActiveAlarmsCountResponse, getActiveAlarmsCountFailResponse);
}
function getActiveAlarmsCountResponse(mode, requestUrlString, json) {
  
  var d = new Date();
  g_iLastAlarmMs = d.getTime();
  g_bAlarmsCountRequestInProgress = false;
  
  //navtree remove document.getElementById("footerStatus1").innerHTML = json.value;
}
function getActiveAlarmsCountFailResponse(mode, requestUrlString, json) {
	
	var d = new Date();
	g_iLastAlarmMs = d.getTime();
	g_bAlarmsCountRequestInProgress = false;
}
function getAlarmDefinitions(mode) {
	var	url = "https://" + location.hostname + "/iap/alarms/definitions";
	requestGetData(mode, url, getAlarmDefinitionsResponse, readFailCallback);
}

function getAlarmDefinitionsResponse(mode, requestUrlString, json) {

	if((mode === 9) || (g_iMainDisplayMode === DISPLAYMODE_DPINFO))  {
		if (json.length === 0) {
			g_sDpInfoPaneContent += " None";
			getDpInfoSchedule();
			return;
		}
	}
	else if ((json.length === 0) && (g_iMainDisplayMode === DISPLAYMODE_ACTIVEALARMS))  {
		document.getElementById("gettingInfoId").innerHTML = "No Active Alarms<br><br><br><div id=\"alarmDefinitions\"></div>";
		return;
	}
	else if (g_iMainDisplayMode !== DISPLAYMODE_ACTIVEALARMS)
		return;
	try {
		var i, j, k, iPtr, iPtr1, iPtr2,count = 0;
		var dpValueRequestStr = "", bAddToList = false;
		var dpStr, url;
		var obj, alarmIndex;
		var alarmObj = {};
		var id = " ",  name, description, alarmType, subscribers, emailList, targetList, target, deviceName;
		
		var paneContent = "<tHead><tr><th>#</th><th>Name</th><th><div>Alarm Type<br>(DLA Alarm Name)</div></th><th>Description</th><th>Scope</th><th>Email List</th>";
		if(mode !== 9)
			paneContent += "<th>Targets</th>"
		paneContent += "</tr></tHead><tbody>"; 
		  var bNewDeviceDetected = false;
		alarmDefinitionList = [];
		g_sAlarmDefinitionList = "";

		for(i= 0; i < json.length; i ++)
	  	{
			id = " ";  name= " "; description= " "; alarmType= -1; subscribers = []; emailList= ""; target = []; targetList = ""; deviceName = "";

			obj = json[i];
			name = obj.name;
			id = obj.id;
			alarmType = obj.alarmType;
			target = obj.target;
			try {
				subscribers = obj.subscribers;
				if(typeof subscribers === "object") {
					if(subscribers !== null) {
						for(j=0; j < subscribers.length; j++)
						{
							if(emailList !== "")
								emailList += "<br>";
							emailList += subscribers[j].userName + " (" + subscribers[j].emailAddress + ")";
						}
					}
				}
				/*
				for(x in obj)
				{
					if(x === "scope") {
						if(scope1 === "")
							scope1 = obj[x];
						else 
							scope2 = obj[x];
					}
				}
				*/
			}
			catch (err) {}
			bAddToList = true;
			try {
				
				if(mode === 9) {
					bAddToList = false;
					for(j=0; j < dlaAlarmList.length; j++)
					{
						if(dlaAlarmList[j].id === alarmType) {
							bAddToList = true;
							obj.alarmName = dlaAlarmList[j].alarmName;
							break;
						}
					}
				}
				else {  
					for(j=0; j < alarmTypeList.length; j++)
					{
						if(alarmTypeList[j].id === alarmType) {
							
							obj.alarmName = alarmTypeList[j].name;
							break;
						}
					}
					if(typeof target === "object") {
						for(j=0; j < target.length; j++)
						{
							if(targetList !== "") 
								targetList += ", ";
							deviceName = "";
							for(k=0; k < deviceListAll.length; k++)
							{
								if(deviceListAll[k].id === target[j]) {
									deviceName = deviceListAll[k].name;
									break;
								}
							}
							targetList += deviceName;
						}
					}
					
				}
				obj.targetList = targetList;
				
			} catch {}
			if(bAddToList) {
				count ++;
				obj.emailList = emailList;
				//obj.scope1 = scope1;
				//obj.scope2 = scope2;
				alarmDefinitionList.push(obj);
				paneContent += "<tr><td>" + count + "</td><td>" + name + "</td><td>" + obj.alarmName + "</td><td>" + obj.description + "</td><td>" + obj.scope + "</td>";
				paneContent += "<td class=\"tdEmailList\">" + obj.emailList + "</td>";
				if(mode !== 9)
					paneContent += "<td class=\"tdTarget\">" + obj.targetList + "</td>";
				paneContent += "</tr>";
				
			}	
		} //for(i= 0; 
		paneContent = "<br><table id=\"alarmDefinitionsTable\">" + paneContent + "</tbody></table>";
		g_sAlarmDefinitionList = paneContent;
		if(mode === 9) {
			if(alarmDefinitionList.length > 0)
				g_sDpInfoPaneContent += paneContent;
			else 
				g_sDpInfoPaneContent += " None";
			getDpInfoSchedule();
			return;
		}
		else {
			g_sActiveAlarmsAlarmDefinitionsPaneContent = paneContent;
			paneContent = "AlarmDefinitions:" + paneContent;
			document.getElementById("alarmDefinitions").innerHTML = paneContent;
			g_sActiveAlarmsPaneContent = document.getElementById("main").innerHTML;
		}
		
	}
	catch (err) {}

}
function getAlarmsForDevice(id) {
	var	url = "https://" + location.hostname + "/iap/alarms/device/" + id;
	if(id !== "")
		requestGetData(mode, url, getAlarmsForDeviceResponse, readFailCallback);

}
function getAlarmsForDeviceResponse(mode, requestUrlString, json) {
	try {
		if(json !== null) {
		//g_deviceAlarmsList
		}
	}
	catch {}
}
function getAlarmTypes(mode) {
	if((mode === 9) && (g_iMainDisplayMode === DISPLAYMODE_DPINFO)) {
		
	}
	else if(g_iMainDisplayMode !== DISPLAYMODE_ACTIVEALARMS)
		return;
	var	url = "https://" + location.hostname + "/iap/alarms/types";
	alarmTypeList = []; 
	requestGetData(mode, url, getAlarmTypesResponse, readFailCallback);
}
function getAlarmTypesResponse(mode, requestUrlString, json) {
	var i, j;
	if((mode === 9) && (g_iMainDisplayMode === DISPLAYMODE_DPINFO)) {
		if(json.length === 0) {
			g_sDpInfoPaneContent += " None";
			getDpInfoSchedule();
			return;
		}

	}
	else if(g_iMainDisplayMode !== DISPLAYMODE_ACTIVEALARMS)
		return;
	alarmTypeList = json;
	if(mode === 9) {
		for(i=0; i < dlaAlarmList.length; i ++)
		{
			for(j=0; j < alarmTypeList.length; j ++)
			{
				if(dlaAlarmList[i].alarmName === alarmTypeList[j].name) {
					dlaAlarmList[i].id = alarmTypeList[j].id;
					break;
				}
			}
		}
	
		getAlarmDefinitions(9);
	}
	else if(g_iMainDisplayMode === DISPLAYMODE_ACTIVEALARMS)
		getAlarmDefinitions(0);
}
function getBackgroundPollingState() {
	try {
		var url = "https://" + location.host + "/iap/dlaRules/monitoring";
		if(g_bShowIfBackgroundPollingPaused) {
			
			requestGetData(0, url, getBackgroundPollingStateResponse, null);
		}
	}
	catch {}
}
function getBackgroundPollingStateResponse(mode, requestUrlString, json) {
	try {
		var element = document.getElementById("footerStatus3");
		if(g_bShowIfBackgroundPollingPaused) {
			if(json === null)
				return;
			if(typeof json.value === "undefined")
				return;
			if(element !== null) {
				element.innerHTML = "Monitoring Paused";
				element.className = "footerBackgroundPollingValue";
				element.title = "Background Polling State (CMS play/paused state)"
				if(json.value)
					element.style.visibility = "hidden";
				else 
					element.style.visibility = "visible";
			}
		}
	}
	catch {}
}
function getConnections(mode) {
	try { 
		var url = "https://" + location.host + "/iap/con/export";
		var Rsp = requestPostFunction(1, url, "",  getConnectionsResponse, null); 
	}
	catch {}
}
function getConnectionsResponse(mode, requestUrlString, json) {
	try {
		//var mode: 4=show raw, otherwise show excel view, 9=DatapointInformation
		//var buf = new Buffer(json, 'base64'); // decode
		//var jsonStr = buf.toString('utf8');
		var sLines;
		var sLine;
		var sCols, sCol, rule;
		var sRow;
		var i, j, iDeviceNamePtr = -1, iDpNamePtr = -1, iDeviceTypePtr = -1, iRuleIdPtr = -1, iRefereneceTypePtr = -1, z, pathname;
		var paneContent = "";
		var bAddToTable = true, bCheckForSpecificConnection = false;
		var bAtLeastOneConnection = false;
		var ruleList = [];
		if((mode === 9) && (g_iMainDisplayMode === DISPLAYMODE_DPINFO)) {

		}
		else if(g_iMainDisplayMode !== DISPLAYMODE_CONNECTIONS)
			return;
		var rows, row;
		if(typeof json === "string") {
			g_sConnections = json;
			if(json.indexOf("#filetype,con") === 0) {
				sLines = json.split("\n");
				// determine DeviceName, device Type and Datapoint name columns
				sLine = sLines[1];
				sCols = convertCsvStringToFields(1, sLine);
				for(i=0; i < sCols.length; i ++)
				{
					sCol = sCols[i];
					if(sCol === "Device Name")
						iDeviceNamePtr = i;
					else if(sCol === "Device Type")
						iDeviceTypePtr = i;
					else if(sCol === "Datapoint Name")
						iDpNamePtr = i;
					else if(sCol === "Reference Type")
						iRefereneceTypePtr = i;
					else if((sCol === "Rule ID") || (sCol === "Template Name"))
						iRuleIdPtr = i;
				}
				if((g_sConnectionsDpName !== "") && (g_sConnectionsDpDeviceType !== "") && (g_sConnectionsDpDeviceName !== "")) {
					
					if((iDeviceNamePtr !== -1) && (iDeviceTypePtr !== -1) && (iDpNamePtr !== -1) && (iRuleIdPtr !== -1))
						bCheckForSpecificConnection = true;
				}
				
				if(bCheckForSpecificConnection) {
					// create rule list - ignore 1st two lines of export data
					for(j=2; j < sLines.length; j ++) 
					{
						sLine = sLines[j];
						if(sLine !== "") {
							sCols = convertCsvStringToFields(1, sLine);
							if((g_sConnectionsDpName === sCols[iDpNamePtr]) && ((g_sConnectionsDpDeviceType === sCols[iDeviceTypePtr]) || (g_sConnectionsDpDeviceName === sCols[iDeviceNamePtr]))) {
								rule = sCols[iRuleIdPtr];
								z = -1;
								for(i=0; i < ruleList.length; i ++)
								{
									if(ruleList[i] === rule) {
										z = i;
										break;
									}
								}
								if(z === -1)
									ruleList.push(rule);
							}
						}
					}
					// add only if has supported rules
					for(z=0; z < ruleList.length; z ++) 
					{
						rule = ruleList[z];
						for(j=1; j < sLines.length; j ++) 
						{
							bAtLeastOneConnection = true;
							sLine = sLines[j];
							if(sLine !== "") {
								sCols = convertCsvStringToFields(1, sLine);
								sRow = "";
								for(i=0; i < sCols.length; i ++)
								{
									sCol = sCols[i];
									if(mode !== 4) {
										if(sCol.charAt(0) === "\"")
											sCol = sCol.substr(1, sCol.length - 2);
										sCol = sCol.replace(/\"\"/g,"\"");
									}
									if(j== 1) {
										if(i === 0)
											sRow += "<th>Menu</th>";
										sRow += "<th onclick=\"sortTable1('conTable'," + (i + 1).toString + "')\">" + sCol + "</th>";
									}
									else {
										if(i === 0) {
											if(iRefereneceTypePtr !== -1) {
												if(sCols[iRefereneceTypePtr].toLowerCase() === "fixed") {
													if((iDeviceNamePtr !== -1) && (iDpNamePtr !== -1)) {
														pathname = sCols[iDeviceNamePtr] + "/" + sCols[iDpNamePtr];
														sRow += "<td><button id=\"dpDlaMenu_" + pathname + "\" onclick=\"menuDla(1, event, '" + sCols[iDeviceNamePtr] + "', '" + sCols[iDpNamePtr] + "')\">...</button>"; //123455
													}
													else
														sRow += "<td></td>";

												}
												else {
													if((iDeviceTypePtr !== -1) && (iDpNamePtr !== -1)) {
														pathname = sCols[iDeviceTypePtr] + "/" + sCols[iDpNamePtr];
														sRow += "<td><button id=\"dpDlaMenu_" + pathname + "\" onclick=\"menuDla(0, event, '" + sCols[iDeviceTypePtr] + "', '" + sCols[iDpNamePtr] + "')\">...</button>"; //123455
													}
													else 
														sRow += "<td></td>";
												}
											}
											else 
												sRow += "<td></td>";
										}
										sRow += "<td>" + sCol + "</td>";
									}
								}
								if(j === 1)
									paneContent += "<thead><tr>" + sRow + "</tr></thead><tbody>";
								else if(rule === sCols[iRuleIdPtr]) 
									paneContent += "<tr>" + sRow + "</tr>";
							}
						}
					}
				}
				else {
					bAtLeastOneConnection = true;
					for(j=1; j < sLines.length; j ++) 
						{
							sLine = sLines[j];
							if(sLine !== "") {
								sCols = convertCsvStringToFields(1, sLine);
								sRow = "";
								bAddToTable = true;
								for(i=0; i < sCols.length; i ++)
								{
									sCol = sCols[i];
									if(mode !== 4) {
										if(sCol.charAt(0) === "\"")
											sCol = sCol.substr(1, sCol.length - 2);
										sCol = sCol.replace(/\"\"/g,"\"");
									}
									if(j== 1) {
										if(i === 0)
											sRow += "<th>Menu</th>";
										sRow += "<th onclick=\"sortTable1('conTable'," + (i + 1).toString + "')\">" + sCol + "</th>";
									}
									else {
										if(i === 0) {
											if(iRefereneceTypePtr !== -1) {
												if(sCols[iRefereneceTypePtr].toLowerCase() === "fixed") {
													if((iDeviceNamePtr !== -1) && (iDpNamePtr !== -1)) {
														pathname = sCols[iDeviceNamePtr] + "/" + sCols[iDpNamePtr];
														sRow += "<td><button id=\"dpDlaMenu_fixed_" + pathname + "\" onclick=\"menuDla(1, event, '" + sCols[iDeviceNamePtr] + "', '" + sCols[iDpNamePtr] + "')\">...</button>"; //123455
													}
													else
														sRow += "<td></td>";

												}
												else {
													if((iDeviceTypePtr !== -1) && (iDpNamePtr !== -1)) {
														pathname = sCols[iDeviceTypePtr] + "/" + sCols[iDpNamePtr];
														sRow += "<td><button id=\"dpDlaMenu_" + pathname + "\" onclick=\"menuDla(0, event, '" + sCols[iDeviceTypePtr] + "', '" + sCols[iDpNamePtr] + "')\">...</button>"; //123455
													}
													else 
														sRow += "<td></td>";
												}
											}
											else 
												sRow += "<td></td>";
										}
										sRow += "<td>" + sCol + "</td>";
									}
								}
								if(j==1)
									paneContent += "<thead><tr>" + sRow + "</tr></thead><tbody>";
								else 
									paneContent += "<tr>" + sRow + "</tr>";
							}
							
						}
				}
				paneContent = "<table id=\"conTable\">" + paneContent + "</tbody></table>"; 
			}
			else
				paneContent = "<textarea  rows=\"25\" cols=\"75\">" + json + "</textarea>";

			
		}
		if(mode === 9) {
			if(bAtLeastOneConnection)
				g_sDpInfoPaneContent += "<br><br>" + paneContent; 
			else 
				g_sDpInfoPaneContent += " None";
			//document.getElementById("main").innerHTML = g_sDpInfoPaneContent;
		}
		else {
			if(bAtLeastOneConnection)
				g_sDpInfoPaneContent = paneContent;
			else
				g_sDpInfoPaneContent = "<br><br>None";
			
			document.getElementById("main").innerHTML = g_sDpInfoPaneContent;
		}
	}
	catch {}
}
function getDeviceInfoUsingDeviceList() {
	try {
		var i;
		var url = "/iap/devs/listByIDs";
		var payload = "";
		for(i=0; i < deviceList.length; i++)
		{
			if(payload !== "")
				payload += ",";
			payload += deviceList[i].id;
		}
		if(payload !== "") {
			payload += "[" + payload + "]";
			requestPutData(0, url, payload, getDeviceListCallback, readFailCallback);
		}
	}
	catch {}
}
function getDeviceList(url) { 
	g_PollingType = 0; 
	deviceList = [];
	if(url === "") {
		url = "/iap/devs?short=true&sortBy=name";
		g_sDevicesContext = "";
	}
	requestGetData(0, url, getDeviceListCallback, readFailCallback); // get Device list
}
function getDeviceListOnlyDontDisplay() { 
	g_PollingType = 0; 
	deviceList = [];
	var url = "/iap/devs?short=true&sortBy=name";
	g_sDevicesContext = "";
	requestGetData(4, url, getDeviceListCallback, readFailCallback); // get Device list

}
function getDeviceListCallback(mode, requestUrlString, json){
	// mode: 4=don't change display, 9=device info
	bivServerOnline = true;
	if((json === null) || (json.length === 0)) {
		if(mode !== 4)
			element = document.getElementById("main");
			if(element === null) {
				// add html content
				element = document.getElementById("top-Container");
				if(element !== null)
					element.innerHTML = addTopContainerHtml();
			}
			element = document.getElementById("main");
			if(element === null) 
				element.innerHTML = "No data avaiable";
		return;
	}
	
	try {
		var i, j, k, len,iPtr, z = -1;
		var device1, device2;
		var id = " ", name = " ", scId = " ", scName = " ", protocol = " ", status = " ", health = " ", did = " ", category = " ", deviceType = " ", uid = " ", mru = " ";
		var networkAddress = " ", path;
		var tempStr, sTemp, sTemp1, element2;
		var obj;
		var deviceObj ={};
		var iCount1 = 0, index1 = 0;
		var bAddDevice = false;
		var paneContent = "";
		var bContinue = true;
		var tempObj;
		var bShowAdvancedInfo = false;
		var iTotal = 0, iUp = 0, iProvisioned = 0, iUnProvisioned = 0, iDown = 0, iUnlicensed = 0;

		
		g_dpGetDeviceByIdStr = "";
		if(requestUrlString === "/iap/devs?short=true&sortBy=name") {
			g_sAllDevicesStatus = "";
			if(json.length < GET_ALL_DPS_MAX_NUMBER_DEVICES)
				g_bShowGetAllDatapoints = true;
			else 
				g_bShowGetAllDatapoints = false;
		}
		else if (requestUrlString === "/iap/devs?noxs=true&sortBy=name") {
			bShowAdvancedInfo = true;
			g_sAllDevicesStatus = "";
		}
		
		
		for(i= 0; i < json.length; i ++)
		{
			id = " ";
			name = " ";
			scId = " ";
			scName = " ";
			protocol = " ";
			status = " ";
			health = " "; 
			did = " ";
			category = " ";
			deviceType = " "; uid = " "; mru = " ";
			deviceObj = {};
			networkAddress = " ";
			

			obj = json[i];
			try {
				name = obj.name;
			}
			catch (err) {}
			try {
				category = obj.category;
			}
			catch (err) {}
			/*
			try {
				id = obj.id
			}
			catch (err) {}
			*/
			if(category === "SC") {
				try {
					g_sTimezone = obj.timezone;
					
				}
				catch {}

			}
			else {
				/*
				try {
					scId = obj.scId;
				}
				catch (err) {}
				try {
					scName = obj.scName;
				}
				catch (err) {}
				try {
					protocol = obj.protocol
				}
				catch (err) {}
				catch (err) {}
				try {
					did = obj.DID;
				}
				catch (err) {}
				try { uid = obj.uid; } catch (err) {}
				try { deviceType = obj.deviceTypeName; } catch (err) {}
				*/
				try { status = obj.status.state;} 	catch  {}
				try { health = obj.status.health;} catch {}
				
				
				try { mru = obj.mru; 
					iPtr = mru.indexOf("[");
					if(iPtr > 0) {
						
						iPtr = mru.lastIndexOf("-",iPtr);
						if(iPtr > 0)
							mru = mru.substr(0, iPtr);
					}
					mru = mru.replace(/-/g," ");
				} catch (err) {}
				
				
			}
			try {
				if(bShowAdvancedInfo) {
					networkAddress = obj.additionalDeviceInfo.domain[0].domainId + "/" + obj.additionalDeviceInfo.domain[0].subnet;
					networkAddress += "/" + obj.additionalDeviceInfo.domain[0].nodeId;
				}
			}
			catch{}
			json[i].networkAddress = networkAddress;
			///bAddDevice = true;
			
				// get latest timestamp
			/*				
			deviceObj.name = name;
			deviceObj.id = id;
			deviceObj.protocol = protocol;
			deviceObj.scId = scId;
			deviceObj.scName = scName;
			deviceObj.DID = did;
			deviceObj.uid = uid;
			deviceObj.deviceType = deviceType;
			deviceObj.mru = mru;
			deviceObj.category = category;
			*/
			json[i].contextStr = null;
			json[i].mru = mru;
			if(category === "SC") {
				iUp ++;
				g_iSmarserverSid = json[i].SID;
				g_dLatitude = json[i].latitude;
				g_dLongitude = json[i].longitude;
				g_SmartServerTimeZone = json[i].timezone;
				if(g_bShowTimezone || g_bShowCmsVersion) {
					element2 = document.getElementById("footerStatus1")
					if(element2 !== null) {
						sTemp = "";
						sTemp1 = g_SmartServerTimeZone;
						iPtr = sTemp1.indexOf("/");
						if((iPtr > 0) && (iPtr < sTemp1.length)) {
							sTemp1 = sTemp1.substring(iPtr + 1,sTemp1.length);
						}
						g_sTimezoneString = sTemp1;
						
						element2.innerHTML = sTemp;
						sTemp = "";
					}
				}
			}
			else if(status === "provisioned") {
				
				json[i].deviceStatus = health;
				if(health === "normal")
					iUp ++;
				else {
					 
						iDown ++;
				}
			}
			else if(status === "unlicensed") {
				iUnlicensed ++;
				json[i].deviceStatus = status;
			}
			else {
				iUnProvisioned ++;
				json[i].deviceStatus = status;
			}
			//else
			//	deviceObj.status = status;
			//deviceObj.onDemandPath = scId + "/" + protocol + "/" + did;
			//deviceList.push(deviceObj);
			
		} //for(i= 0; i < json.length; i ++)
		// sort deviceList, Segment controllers first
		bContinue = true;
		len = json.length - 1;
		while(bContinue) 
		{
			bContinue = false;
			for(j=0; j < len; j ++)
			{
				device1 = "b/";
				if(json[j].category === "SC")
					device1 = "a/" +  json[j].name + " ";
				else
					device1 += json[j].scName + "/" + json[j].name + " ";
				device2 = "b/";
				if(json[j + 1].category === "SC")
					device2 = "a/" + json[j + 1].name + " ";
				else
					device2 += json[j + 1].scName + "/" + json[j + 1].name + " ";

				if(device1.toLowerCase() > device2.toLowerCase()) {  
					tempObj = {};
					tempObj = json[j + 1];
					json[j + 1] = json[j];
					json[j] = tempObj;
					bContinue = true;
				}
			}
		}
		
		if(mode !== 4) {
			// populate table
			paneContent += "<thead><tr><th onclick=\"sortTable(0)\">#</th>";
			paneContent += "<th>Menu</th>";
			paneContent += "<th onclick=\"sortTable(2)\">Device Name</th><th onclick=\"sortTable(2)\">id</th><th onclick=\"sortTable(3)\">Device Status</th>";
			paneContent += "<th onclick=\"sortTable(5)\">Device Type</th><th onclick=\"sortTable(6)\">Program ID</th><th onclick=\"sortTable(7)\">UID</th>";
			if(bShowAdvancedInfo) {
				paneContent += "<th onclick=\"sortTable(8)\">Domain/S/N IDs</th>";
				paneContent += "<th onclick=\"sortTable(9)\">Last Update</th><th onclick=\"sortTable(10)\">Protocol</th><th onclick=\"sortTable(11)\">DID</th>"
				paneContent += "<th onclick=\"sortTable(12)\">Category</th><th onclick=\"sortTable(13)\">SID</th>"; 
			}
			else {
				paneContent += "<th onclick=\"sortTable(8)\">Last Update</th><th onclick=\"sortTable(9)\">Protocol</th><th onclick=\"sortTable(10)\">DID</th>"
				paneContent += "<th onclick=\"sortTable(11)\">Category</th><th onclick=\"sortTable(12)\">SID</th>";
			}
			if(g_iSmartServerVersion >= 280000) {
				paneContent += "<th>Context</th>";
				paneContent += "<th>Context Path</th>";
			}
			paneContent += "</tr></thead><tbody>"; 
				
			for(i= 0; i < json.length; i ++)
			{
				tempStr = "";
				path = "";
				paneContent += "<tr><td>" + (i+1).toString() + "</td>";
				if(json[i].category	== "SC")
					paneContent += "<td><button id=\"deviceMenu_" + json[i].name + "\" onclick=\"menuDeviceSmartServer(0, event," + json[i].id + ", '" + json[i].name  + "')\">...</button></td>";
				else
					paneContent += "<td><button id=\"deviceMenu_" + json[i].name + "\" onclick=\"menuDevice(0, event," + json[i].id + ", '" + json[i].name  + "', '" + json[i].deviceTypeName  + "', '" + json[i].protocol  + "')\">...</button></td>";
				paneContent += "<td>" + json[i].name + "</td><td>" + json[i].id + "</td>";
				if(json[i].category === "SC") {
					
					paneContent += "<td></td><td></td><td></td>";
				}
				else {
					paneContent += "<td>" + json[i].deviceStatus + "</td>";
					paneContent += "<td>" + json[i].deviceTypeName  + "</td>";
					z = 0;
					for(j=0; j < deviceTypeList.length; j++)
					{
						if(json[i].typeId === deviceTypeList[j].id) {
							paneContent += "<td>" + deviceTypeList[j].programId + "</td>";
							json[i].programId = deviceTypeList[j].programId;
							z = 1;
							break;
						}
					}
					if(z === 0)
						paneContent += "<td></td>";
				}
				if(json[i].category === "SC")
					paneContent += "<td>" + json[i].SID + "</td>";
				else
					paneContent += "<td>" + json[i].uid  + "</td>";
				if(bShowAdvancedInfo) {
					if(json[i].category === "SC")
						paneContent += "<td></td>";
					else 
						paneContent += "<td>" + json[i].networkAddress + "</td>"; // short=true doesn't provide network address
				}
				if(json[i].category === "SC")
					paneContent += "<td></td><td></td><td></td>";
				else {
					paneContent += "<td>" + json[i].mru  + "</td>";
					paneContent += "<td>" + json[i].protocol + "</td><td>" + json[i].DID  + "</td>";
				}
				paneContent += "<td>" + json[i].category + "</td>";
				if(json[i].category === "SC")
					paneContent += "<td>" + json[i].SID + "</td>";
				else 
					paneContent += "<td>" + json[i].scId + "</td>";
				
				if(g_iSmartServerVersion >= 280000) {
					try {
						if(json[i].contextStr !== null) {
							paneContent += "<td><div>" + json[i].contextStr + "</div></td>";
						}
						else {
							if(!(typeof json[i].contexts === "undefined")) {
								tempStr = "";
								for(k=0; k < json[i].contexts.length; k++)
								{
									for(j=0; j < contextList.length; j++) 
									{
										if(contextList[j].id === json[i].contexts[k]) {
											if(tempStr !== "")
												tempStr += "<br>"
											tempStr += contextList[j].name; 
											if(path !== "")
												path += "<br>"
											path += contextList[j].path;
											if(mode === 9) {
												g_dpInfoContextList.push(path);
											}
										}
										
									}
								}
								json[i].contextPath = path;
								json[i].contextStr = tempStr;
								paneContent += "<td><div>" + tempStr + "</div></td>";
							}
						}
						if(path === "") {
						 	if(typeof json[i].contextPath === "undefined") {
								for(k=0; k < json[i].contexts.length; k++)
								{
									for(j=0; j < contextList.length; j++) 
									{
										if(contextList[j].id === json[i].contexts[k]) {
											if(path !== "")
												path += "<br>"
											path += contextList[j].path;
										}
									}
								}
							}
							else
								path = json[i].contextPath;
						}
					}
					catch
					{
						paneContent += "<td></td>";
					}
					paneContent += "<td>" + path + "</td>";
				}
				paneContent += "</tr>";
			}
			paneContent = "<br><table id=\"myTable\">" + paneContent + "</tbody></table>";
			if(mode !== 9) {
				//sTemp = "Total Devices [" + json.length + "]: UP = " + iUp + ", Down = " + iDown + ", Unprovisioned = " + iUnProvisioned;
				sTemp = ": " + json.length + " [UP = " + iUp + ", Down = " + iDown + ", Unprovisioned = " + iUnProvisioned;
				if(iUnlicensed > 0)
					sTemp += ", Not Licensed = " + iUnlicensed;
				sTemp += "]";
				if((requestUrlString === "/iap/devs?short=true&sortBy=name") || (requestUrlString === "/iap/devs?noxs=true&sortBy=name")) {
					g_sAllDevicesStatus = sTemp;
				}
				if(g_sDevicesContext !== "")
					sTemp = "<span style='margin-left:50px'>" + sTemp + "</span>";
				paneContent = "<br>" + g_sDevicesContext + sTemp + paneContent; 
				document.getElementById("main").innerHTML = paneContent;
				document.getElementById("deviceCount").innerHTML = " [" + json.length + "]";
				g_PollingType = 1; // ??? why do we have this
			}
			
			
		}
		else {
			// mode = 4
			
			if((requestUrlString === "/iap/devs?short=true&sortBy=name") || (requestUrlString === "/iap/devs?noxs=true&sortBy=name")) {
				//sTemp = "Total Devices [" + json.length + "]: UP = " + iUp + ", Down = " + iDown + ", Unprovisioned = " + iUnProvisioned;
				sTemp = ": " + json.length + " [UP = " + iUp + ", Down = " + iDown + ", Unprovisioned = " + iUnProvisioned;
				if(iUnlicensed > 0)
					sTemp += ", Not Licensed = " + iUnlicensed;
				sTemp += "]";
				//sTemp = " [" + json.length + "]: UP = " + iUp + ", Down = " + iDown + ", Unprovisioned = " + iUnProvisioned;
				
				g_sAllDevicesStatus = sTemp;
				if(!g_bIngnoreDisplayingDeviceDeviceStatus)
					document.getElementById("footerStatus").innerHTML = g_sAllDevicesStatus;
			}
		}
		if(mode !== 9) {
			deviceList = JSON.parse(JSON.stringify(json));
			if(deviceTypeList.length > 0) {
				for(i=0; i < deviceList.length; i++)
				{
					for(j=0; j < deviceTypeList.length; j++)
					{
						if(deviceList[i].typeId === deviceTypeList[j].id) {
							deviceList[i].deviceTypeName = deviceTypeList[j].name;
							deviceList[i].programId = deviceTypeList[j].programId;
							break;
						}
					}
				}
			}
		}
		if(mode === 9) {
			if(g_iMainDisplayMode === DISPLAYMODE_DPINFO) {
				g_sDpInfoPaneContent += paneContent;
				getDpInfoActiveAlarms();
				return;
			}
		}
		if(requestUrlString === "/iap/devs?noxs=true&sortBy=name") {
			deviceListAll = JSON.parse(JSON.stringify(deviceList));
			displayDeviceStatus();
		}
		if(requestUrlString === "/iap/devs?short=true&sortBy=name") {
			deviceListAll = JSON.parse(JSON.stringify(deviceList));
			if(planningList.length === 0) {
				getPlanningTree();
			}
			else if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
				document.getElementById("main").innerHTML = "<br><br>No Context Defined";
			}
			displayDeviceStatus();
		}
		if(g_iMainDisplayMode === DISPLAYMODE_ALLDEVICES)
			testAllDevices(1);
	}
	catch {}
	cursorClearWait();
}
function getDpInfo(pathname, programmaticPathname) {
	// used to start process to get Current value, DLA, schedule and connection information for a given datapoint
	// all Dp info shown in one view
	try {
		var paneTitle = "", paneContent = "";
		var i, iPtr;
		var deviceName = "", deviceType = "";
		g_sDpInfoPaneContent = ""; 
		g_sDpInfoPathname = pathname;
		g_sDpInfoProgrammaticPathname = programmaticPathname;
		g_bDpInfoShowDatalogButton = false;
		g_bDpInfoForDevice = false;
		g_dpInfoContextList = [];
		paneTitle = "<label id=\"displayLabel\">Datapoint Information: " + pathname + "</label><div style=\"float:right\">";
		paneTitle += "<div style=\"display:inline-block;float:right\"><button  onclick=\"getDpInfoNodeRed(1)\">Node-RED Info</button>";
		paneTitle += "<button  onclick=\"calculateEps()\">Calculate EPS</button></div>";
		paneTitle += "<button onclick=\"getDpInfo('" + pathname + "','" + programmaticPathname + "')\">Refresh All</button></div>";
		paneContent = "<br><span id=\"gettingInfoId\" class=\"getting Datapoint Info\"></span><br><br>Getting Datapoint Information ....</div>";
		g_sDpInfoPaneTitle = paneTitle;
		initializeDisplay();
		g_iMainDisplayMode = DISPLAYMODE_DPINFO;
		document.getElementById("main-Header").innerHTML = paneTitle;
		document.getElementById("main").innerHTML = paneContent;

		
		g_sConnectionsDpName = "";
		g_sConnectionsDpDeviceType = "";
		g_sConnectionsDpDeviceName = "";
		iPtr = pathname.indexOf("/");
		if(iPtr !== -1) {
			deviceName = pathname.substr(0, iPtr);
			g_sConnectionsDpName = pathname.substr(iPtr + 1);
		}
		else {
			deviceName = pathname;
			g_bDpInfoForDevice = true;
			// for dpInfo for device, current value is not read as this could be a large list
			

			
		}
		if(deviceName !== "") {
			for(i=0; i < deviceListAll.length; i ++)
			{
				if(deviceListAll[i].name === deviceName) {
					g_sConnectionsDpDeviceName = deviceName;
					g_sConnectionsDpDeviceType = deviceListAll[i].deviceTypeName;
					break;
				}
			}
			if(g_sConnectionsDpDeviceType === "") {
				document.getElementById("main").innerHTML = "<br><br>Can't find Device Device Type for " + g_sDpInfoPathname;
			}
			else {
				g_sConnections = "";
				cursorSetWait(); //	document.getElementById("main").style.cursor = "wait";
				if(g_bDpInfoForDevice) {
					var url = "/iap/devs/*+name==" + deviceName;
					requestGetData(9, url, getDeviceListCallback, readFailCallback); // get Device list
				}
				else
					getDpInfoCurrentValue();
			}
		}

	}
	catch {}
}
function getDpInfoActiveAlarms() {
	g_sDpInfoPaneContent += "<br><br>Active Alarms:";
	getActiveAlarms(9, "");
}
function getDpInfoCurrentValue() {
	var url = "",iPtr;
	if(g_iMainDisplayMode !== DISPLAYMODE_DPINFO)
			return;
	if(g_sDpInfoProgrammaticPathname === "")
		return;
	if(g_iSmartServerVersion >= 320114) {
		url = addIfandXifnameToPathname(0, g_sDpInfoProgrammaticPathname); 
	}
	else {
		iPtr = g_sDpInfoProgrammaticPathname.indexOf("/");
		if(iPtr > 0) {
			url = g_sDpInfoProgrammaticPathname.substr(0,iPtr) + "/if" + g_sDpInfoProgrammaticPathname.substr(iPtr);
		}
	}
	url = "https://" + location.hostname + "/iap/devs/*+name==" + url + "/*";
	g_sDpInfoPaneContent = "<br><br>Current Value:"
		
	requestGetData(0, url, getDpInfoCurrentValueResponse, readFailCallback);

}
function getDpInfoCurrentValueResponse(mode, requestUrl, json) {
	try {
		var paneContent = "";
		var obj, timestamp1, iPtr, locValue, locValueStr, value, valueStr, lon_cfg, units, url, deviceName;
		if(g_iMainDisplayMode !== DISPLAYMODE_DPINFO)
			return;
		if(g_sDpInfoProgrammaticPathname === "")
			return;
		if(json.length === 0) {
			document.getElementById("main").innerHTML = "<br><br>Can't get information for " + g_sDpInfoPathname;
			cursorClearWait(); //document.getElementById("main").style.cursor = "default";
			return;

		}
		else if(json.length > 1) {
			document.getElementById("main").innerHTML = "<br><br>Can't get valid information for " + g_sDpInfoPathname;
			cursorClearWait(); //document.getElementById("main").style.cursor = "default";
			return;
			
		}
		obj = json[0];

		pathname = obj.deviceName + "/" + obj.blockName  + "/" + obj.blockIndex  + "/" + obj.datapointName;
		timestamp1 = obj.local;
		iPtr = timestamp1.lastIndexOf("[");
		if(iPtr > 0) {
			iPtr = timestamp1.lastIndexOf("-",iPtr);
			if(iPtr > 0) {
				timestamp1 = timestamp1.substr(0, iPtr);
				timestamp1 = timestamp1.replace(/T/g," ");
			}
		}
		value = obj.value;
		if(value !== null) {
			if(typeof locValue === "number")
				valueStr = value.toString();
			else
				valueStr = JSON.stringify(value);
		}
		locValue = obj.locValue;
		if(locValue !== null) {
			if(typeof locValue === "number")
				locValueStr = locValue.toString();
			else
				locValueStr = JSON.stringify(locValue);
		}
		try { lon_cfg = obj["lon.cfg"];
			units = lon_cfg.unit;
		} catch (err) {} 

		if(g_sDpInfoProgrammaticPathname === pathname) {
			if(obj.presetValue === null)
				obj.presetValue = "";
			paneContent = "<tHead><tr><th>Device</th><th>Block</th><th>DP</th>";
			paneContent += "<th>DP XIF Name</th><th>Preset</th><th class=\"tdValue\">Local Value</th><th class=\"tdValue\">Value</th>";
			paneContent += "<th>Priority</th><th>Units</th>";
			paneContent += "<th>Timestamp</th><th>DP Type</th><th>Direction</th><th>Path</th></tHead><tbody>"; 
		
			if(obj.name === null)
				obj.name = obj.datapointName;

			paneContent += "<td>" + obj.deviceName + "</td><td>" + obj.blockName  + "/" + obj.blockIndex + "</td><td>" + obj.name + "</td>";
			paneContent += "<td>" + obj.datapointName + "</td><td class=\"tdPreset\"><span>" + obj.presetValue + "</span></td>";
			paneContent += "<td class=\"tdValue\"><div  class=\"tdValueDiv\">" + locValueStr + "</div></td>";
			paneContent += "<td class=\"tdValue\"><div  class=\"tdValueDiv\">" + valueStr + "</div></td>";
			paneContent += "<td><span id=\"priority\">";
			try {
				if(typeof obj.values === "undefined") {
					paneContent += obj.prio;
				}
				else if(typeof obj.values.level === "undefined") {
					paneContent += obj.prio;
				}
				else
					paneContent += obj.values.level;
			} 
			catch {}  
			paneContent += "</span></td>";
			paneContent += "<td><span>" + units + "</span></td>";
			
			paneContent += "<td><span>" + timestamp1 + "</span></td>";
			paneContent += "<td>" + obj.type + "</td><td>" + obj.cat + "</td>";
			paneContent += "<td class=\"pathname\">" + pathname + "</td>";
			
			paneContent += "</tr>"; 
			paneContent = "<br><table id=\"myTable\">" + paneContent + "</tbody></table>";
			paneContent += "<br><br>Device Info";
			g_sDpInfoPaneContent += paneContent;
			//getDpInfoActiveAlarms();
			deviceName = obj.deviceName;
			deviceName = encodePathString(deviceName);
			url = "/iap/devs/*+name==" + deviceName;
			requestGetData(9, url, getDeviceListCallback, readFailCallback); // get Device list

			
			
		}
		else {
			document.getElementById("main").innerHTML = "<br><br>Can't get information for " + g_sDpInfoPathname;
			cursorClearWait(); //document.getElementById("main").style.cursor = "default";
			
			return;
		}
	}
	catch { 
		cursorClearWait(); //document.getElementById("main").style.cursor = "default";
	}
}
function getDpInfoDla() {
	try {
		if(g_iMainDisplayMode !== DISPLAYMODE_DPINFO)
			return;
		if(g_sDpInfoProgrammaticPathname === "")
			return;
		var i=0;
		var	url = "https://" + location.hostname;
		var url = "/iap/devTypes/";
		var pathItems = g_sDpInfoProgrammaticPathname.split("/");
		var deviceType = "";
		var bGetAllDlaForDevice = false;
		if(g_bDpInfoForDevice) {

		}
		else if(pathItems.length < 4) {
			document.getElementById("main").innerHTML = "<br><br>Can't get information for " + g_sDpInfoPathname;
			return;
		}
		// get device type from device name
		for(i=0; i < deviceListAll.length; i++)
		{
			if(deviceListAll[i].name === pathItems[0]) {
				if(!(typeof deviceListAll[i].deviceTypeName === "undefined")) {
					deviceType = deviceListAll[i].deviceTypeName;
				}
				break;
			}
		}
		if(deviceType !== "") {
			
			url += "/*+typeName==" + deviceType;
			if(g_bDpInfoForDevice)
				url += "/if/*/*/*/dla?includeUnconfigured=false";
			else 
				url += "/if/*+name==" + pathItems[1] + "/*+name==" + pathItems[2] + "/*+name==" + pathItems[3] + "/dla?includeUnconfigured=false";
			g_sDpInfoPaneContent += "<br><br>Datapoint Properties (Device Type): <div id=\"deviceInfoDatalogButton\" style=\"display:inline-block\"></div>"; 
			requestGetData(0, url, getDpInfoDlaResponse, getDpInfoResponseFail);
		}
	}
	catch {
		cursorClearWait(); //document.getElementById("main").style.cursor = "default";
	}
}
function getDpInfoDlaResponse(mode, requestUrl, json) {
	try {
		if(g_iMainDisplayMode !== DISPLAYMODE_DPINFO)
			return;
		if(g_sDpInfoProgrammaticPathname === "")
			return;
		if(json.length > 0) 
			getDlaSettingsResponse(9, requestUrl, json);
		else 
			g_sDpInfoPaneContent += " None"; 
		g_sDpInfoPaneContent += "<br><br>Alarm Definitions:"
		if(dlaAlarmList.length === 0) {
			g_sDpInfoPaneContent += " None";
			getDpInfoSchedule();
		}
		else 
			getAlarmTypes(9);
		
		
		
	}
	catch {
		cursorClearWait(); //document.getElementById("main").style.cursor = "default";
	}
}
function getDpInfoSchedule() {
	try {
		if(g_iMainDisplayMode !== DISPLAYMODE_DPINFO)
			return;
		if(g_sDpInfoProgrammaticPathname === "")
			return;
		g_sSchedulePathname = g_sDpInfoPathname;
		g_sScheduleProgrammaticPathname = g_sDpInfoProgrammaticPathname;
		var	url = ""; //"/iap/devTypes/*/if/*/*/*/dla?includeUnconfigured=false";
		var iPtr;
		
		var d = new Date();
		var currentDay = d.getDay(); // shows mon-sun, we want sun-sat
		var currentDate = d.toLocaleDateString();
		var startOfWeek = Date.parse(currentDate);
		var oneDay = 60 * 60 * 24 * 1000;
		var dayOffset = 1; // (g_sScheduleRange === "week (sun - sat)")
		if(g_sScheduleRange.toLowerCase() === "week (mon - sun)") 
			dayOffset = 0;
		var ibegWeek = startOfWeek - ((currentDay + dayOffset) * oneDay);
		d.setTime(ibegWeek);
		var sBegWeek = d.toISOString(); 
		iPtr = sBegWeek.indexOf("T");
		if(iPtr > 0)
			sBegWeek = sBegWeek.substr(0, iPtr);
		d.setTime(ibegWeek + (oneDay * 7));
		
		url = "https://" + location.hostname + "/iap/sev/*?start=" + sBegWeek;
		g_sDpInfoPaneContent += "<br><br>Schedules:" 
		requestGetData(9, url, getDpInfoScheduleResponse, readFailCallback);
	}
	catch {
		document.getElementById("main").innerHTML = g_sDpInfoPaneContent + "<br><br>Error: exception";
		cursorClearWait(); //document.getElementById("main").style.cursor = "default";
	}

}
function getDpInfoScheduleResponse(mode, requestUrl, json) {
	try {
		if(g_iMainDisplayMode !== DISPLAYMODE_DPINFO)
			return;
		if(g_sDpInfoProgrammaticPathname === "")
			return;
		if(json.length > 0) {
			getSchedulesResponse(9, requestUrl, json)
			
		}
		else 
			g_sDpInfoPaneContent += " None"; 
		getDpInfoConnections();
		
	}
	catch {
		document.getElementById("main").innerHTML = g_sDpInfoPaneContent + "<br><br>Error: exception";
		cursorClearWait(); //document.getElementById("main").style.cursor = "default";
	}
}
function getDpInfoConnections() {
	if(g_iMainDisplayMode !== DISPLAYMODE_DPINFO)
		return;
	if(g_sDpInfoProgrammaticPathname === "")
		return;
	g_sDpInfoPaneContent += "<br><br>Connections (CON):" 
	var url = "https://" + location.host + "/iap/con/export";
	var Rsp = requestPostFunction(1, url, "",  getDpInfoConnectionsResponse, null); 
		
}
function getDpInfoConnectionsResponse(mode, requestUrl, json) {
	try {
		if(g_iMainDisplayMode !== DISPLAYMODE_DPINFO) 
			return;
		if(json.length > 0) {
			getConnectionsResponse(9, requestUrl, json);
		}
		else 
			g_sDpInfoPaneContent += " None" 
		getDpInfoNodeRed(0);
		//document.getElementById("main").innerHTML = g_sDpInfoPaneContent;
		//if(g_bDpInfoShowDatalogButton){
		//	document.getElementById("deviceInfoDatalogButton").className === "deviceInfoDatalogButton";
		//	document.getElementById("deviceInfoDatalogButton").innerHTML = "<button onclick=\"showDataLog1('" + g_sDpInfoProgrammaticPathname + "')\">Get Data Log</button>";
		//}
		
	}
	catch {}
		cursorClearWait(); //document.getElementById("main").style.cursor = "default"
	;
}

function getNextPageInfo(mode, requestUrlString, json) {
	// not used yet and not used if using WebSockets 
	try
	{
			// 
				// get how many more pages
			var iSnapshot = json['snapshot'];
			var resources = json['resources'];
			if(resources.length === 0)
			{ // no data
				//requestInProgress =0;
				//g_bReadInProgress = false;
				g_iPaginationPage = 0;
				return;
			}
			else
				g_ArrPaginationResponse = g_ArrPaginationResponse.concat(resources); // Get results
			var pagesLeft = json['remainingPages'];
			
			if(g_iPaginationPage > 1)
			{
				if(iSnapshot !== g_iPaginationSnapsnotNumber)
				{ // error wrong snapshot so wrong data
					//g_bReadInProgress = false;
					g_iPaginationPage = 0;
					return;
				}
			}
			else 
				g_iPaginationSnapsnotNumber = iSnapshot;
			if(pagesLeft === 0)	
			{
				//ivbReadInProgress = false;
				g_iPaginationPage = 0;
			}
			else 
				g_iPaginationPage ++;	
	}
	catch (err) {}
}
function getOnDemandDpValuesRequest(mode) {
	if((g_idpGetRequestIndex === -1) || (g_dpGetRequestArr === null)) {
		
		paneContent = "<div style=\"float:left\">" + paneContent + "</div><div id=\"planningPaneDetails\" style=\"display:inline-block;margin-10;border-color:white\"></div>"
		document.getElementById("main").innerHTML = paneContent;
		return;
	}
	if(g_dpGetRequestArr[0] === "")
		return;

	if(mode === 3) {
		g_iBackgroundPollingRequestCount = g_iBackgroundPollingRequestCountMax + 12;
		g_idpGetRequestIndex = 0;
		if(!g_bPollingEnabled)
			g_PollingType = DISPLAYMODE_ONETIMEPOLL;
	}
	getOnDemandDpValues(mode, "");
}
function getOnDemandDpValues(mode, url) {
	var timeDifference;
	var sTemp = "";
	if(mode === 0) {
		// used for Web sockets
		if(url === "") {
			//url = "https://" + location.hostname; // + ":8443";
			url = "https://" + location.hostname + "/iap/devs/*/if/*/*/*+qualifier=-";
		}
		else {
			url = "https://" + location.hostname + url;
		}
	}
	else if (mode === 1) { // refresh
		url = "https://" + location.hostname + "/iap/devs/*/if/*/*/*+qualifier=-" + g_sOnDemandDpRequestUrl + "/*?noxs=true";; //"/value?noxs=true";
	}
	else if (mode === 2) { // ondemand request
		if(g_sWebSocketSubscribePayload === "")
					return;
		if(g_sWebSocketSubscribePayload !== g_sWebSocketSubscribePayload_oldvalue)
			subscribeRequest();
		url = "https://" + location.hostname + "/iap/devs/*/if/*/*/*+qualifier=-" + g_sOnDemandDpRequestUrl + "/value?max_age=1&noxs=true";
	}
	else if ((mode === 3) || (mode === 4)) { // Use Web socket updates only ignore cached values
		if(g_idpGetRequestIndex !== -1) {
			if(g_dpGetRequestArr[0] !== "") {
				if(g_sWebSocketSubscribePayload === "")
					return;
				if(g_sWebSocketSubscribePayload !== g_sWebSocketSubscribePayload_oldvalue)
					subscribeRequest();
				sTemp = "value";
				
				if((g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) && (g_idpGetRequestIndex === 0) && g_bAtLeastOneElementUsesPriority){
					g_idpGetPropertiesRequestCount ++;
					if(g_idpGetPropertiesRequestCount > g_idpGetPropertiesRequestMaxCount) {
						g_idpGetPropertiesRequestCount = 0;
						mode += 20; // get properties so we can update priority info in different views
						sTemp = "*";
					}
				}
				else if(g_idpGetRequestIndex === 0) {
					if(g_iAutoSubscribeRate !== 0) {
						g_iAutoSubscribeCount ++;
						
					}
				}
				if(g_iAutoSubscribeCount >= g_iAutoSubscribeRate) {
					if(g_idpGetRequestIndex === g_iAutoSubscribeCountRequestIndex) // distributes subscribe so if there is more than one datapoint request that eventually all datapoints get read 
						subscribeRequest();  
				}
				url = "https://" + location.hostname + "/iap/devs/*/if/*/*/*+qualifier=-";
				if(g_iMax_Age === -1) 
					url += g_dpGetRequestArr[g_idpGetRequestIndex] + "/" + sTemp + "?&noxs=true";
				else 
					url += g_dpGetRequestArr[g_idpGetRequestIndex] + "/" + sTemp + "?max_age=" + g_iMax_Age + "&noxs=true";			
				g_idpGetRequestIndex ++;
				g_iBackgroundPollingRequestCount = 0;
				if(g_idpGetRequestIndex >= g_dpGetRequestArr.length) {
					g_iBackgroundPollingRequestCount = -1;
					g_iPollingRequestCount = 0;
					g_idpGetRequestIndex = 0;
					if(g_PollingType === DISPLAYMODE_DATALOGONETIMELIVEPOLL) {

					}
					else if(!g_bPollingEnabled) {
						g_iPollingRequestCount = -1;
						g_PollingType = 0;
					}
					else {
						if(g_dpGetRequestArr.length > 1) {
							g_dtPollGetRequestArrEndTime = new Date();
							timeDifference = (g_dtPollGetRequestArrEndTime.getTime() - g_dtPollGetRequestArrStartTime.getTime()) / 1000;
							if(timeDifference > g_iPollRate) 
								g_iPollingRequestCount = g_iPollingRequestCountMax + 1; //startNextRequest(); // don't wait 
							else {
								g_iPollingRequestCount = Math.floor(timeDifference);
							}
						}
					}
				}
				else {
					if(g_idpGetRequestIndex == 1)
						g_dtPollGetRequestArrStartTime = new Date();
				}
			}
		}
	}
	else if (mode === 8) {
		url = "https://" + location.hostname + url;
	}
	
	requestGetData(mode, url, getOnDemandDpValuesResponse, readFailCallback);
}
function getOnDemandDpValuesResponse(mode, requestUrlString, json) {
	
	if(!((g_iMainDisplayMode === DISPLAYMODE_DPS) || (g_iMainDisplayMode === DISPLAYMODE_FAVDPS) || (g_iMainDisplayMode === DISPLAYMODE_DASHBOARD)
		|| (g_iMainDisplayMode === DISPLAYMODE_PLANNING)
		|| ((g_iMainDisplayMode === DISPLAYMODE_DATALOG) 
		&& ((g_iDatalogPollMode !== 0) && (g_PollingType === DISPLAYMODE_DATALOGLIVEPOLL))
			|| (g_PollingType === DISPLAYMODE_DATALOGONETIMELIVEPOLL)) )) {
		requestInProgress = 0;
		return;
	}
	/* navtree remove
	if(mode === 8) {
		//8=datapoints for dashboard
	}
	else if((mode === 23) || (mode === 24)) {
		//same as mode 3 and 4 except update dp priority info and use Websocket update for dp value
		if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
			try {
				//add planning code to update priority list
				getPlanningTreeShowTreeDatapointsUpdatePrioritesResponse(mode, requestUrlString, json);
				requestInProgress = 0;
			}
			catch (err) {}
		}
		else {
			processGetDeviceDpData(1, 3, requestUrlString, json);
			requestInProgress = 0;
		}
		
		return;
	}
	*/
	if(ivbWsStartWebSocket) {
		if(bivUseWebSockets) {
			try {
				// PC hibernates for longer than WebSocket timeout, then automatically try to reconnect a couple of times.
				// If this is not implemented then use has to refresh the Web page
				ivbWsStartWebSocket = false;
				ivWebSocketInit();
			}
			catch {}
		}
	}

	if((mode === 23) || (mode === 24)) {
		// update priority levele and arrays
		getOnDemandDpPropertiesResponse1(mode, requestUrlString, json);
	}
	else { // if(mode > 1)  { // uses web socket response instead
		requestInProgress = 0;
		return;
	}
	/* navtree remove
		// mode = 0 or 8
	processGetDeviceDpData(mode, 0, requestUrlString, json);// iot
	requestInProgress = 0;
	*/	
}
function getOnDemandDpPropertiesResponse(mode, requestUrlString, json) {
	try {
			var pathname = requestUrlString;
			var iPtr;
			processGetDeviceDpData(2, 0, requestUrlString, json); 
	}
	catch {}
}
function getOnDemandDpPropertiesResponse1(mode, requestUrlString, json) {
	try {
		var i,j, k;	
		var element, sTemp;
		var pathname = requestUrlString;
		var iPtr;
		var programmaticPathname
			
			for(i=0;i < json.length; i++)
			{
				programmaticPathname = json[i].deviceName + "/" + json[i].blockName  + "/" + json[i].blockIndex  + "/" + json[i].datapointName;
				for(j=0; j < dashboardDpList.length; j++) 
				{
					if(dashboardDpList[j].programmaticPathname === programmaticPathname) {
						if(json[i].values.level !== dashboardDpList[j].values.level) {
							// update any priority buttons
							for(k=0; k < dashboardDpList[j].displayElements.length; k ++)
							{
								if(dashboardDpList[j].displayElements[k].bHasPriorityButton) { 
									// only dashboard uses priority buttons
									// fixx add prirority button code
									element = document.getElementById("dpValueMenu_" + dashboardDpList[j].displayElements[k].displayId);
									if(element !== null) {
										if(Number(json[i].values.level) === 17) {
											sTemp = "...";
											if(element.innerText !==  sTemp);
												element.innerText =  sTemp;
										}
										else {
											sTemp = "P " + json[i].values.level;
											if(element.innerText !== sTemp)
												element.innerText =   sTemp;
										}
									}
								}
							}
						}
						if(isNotEqual(json[i].values, dashboardDpList[j].values)) {
							dashboardDpList[j].values = JSON.parse(JSON.stringify(json[i].values));
						}
						break;
					}
				}
			}
	}
	catch {}
}
function preloadImage(url) {
	try {
		const img = new Image();
		img.src = url;
		return;
	}
	catch {}

}
function processGetDeviceDpData(mode, type, requestUrlString, json)
{  
	if((json.length === 0) || (g_iMainDisplayMode !== DISPLAYMODE_DASHBOARD))
		return;
	
	// remove not used for navtree
	// mode:Updated value 0=Build Dp list table, 1= only update value in table,2=update value and priority, 3= update only priority, 8=datapoints for dashboard, 23 or 24= update priorites only, 34=update both value and priority 
	// 2=same as 1 but update priority, 43 = same as 3 plus update menuDiv
	// type: 0=normal Get request response, 1= Web socket response, 2=same as 0 but create g_dpGetRequestArr (needed for getting FAV from CMS), 3=only update priority values
	// 		4=update value and priority
	// json list of dps
	// IzoT Vision Types: sv=Show Value, tb=textbox, dl=dropdown list, sdl= substitution dropdown list cb=combobox
	
	bivServerOnline = true;	
	if ((json.length === 0) || (!( (g_iMainDisplayMode === DISPLAYMODE_DPS) || (g_iMainDisplayMode === DISPLAYMODE_FAVDPS) || (g_iMainDisplayMode === DISPLAYMODE_DASHBOARD)))) {
	//if ((json.length === 0) || (!(((g_iMainDisplayMode === DISPLAYMODE_DPS) && (favDpList !== null)) || ((g_iMainDisplayMode === DISPLAYMODE_FAVDPS) && (dpList !== null))))) {
		if(mode === 0)
			document.getElementById("gettingInfoId").innerHTML = "No Data  avaiable";
		return;
	}
	

	try {
		var bRefresh = 0;
		var bTimeStampChanged = false;
		var i, j, k, z, iPtr;
		var obj, dpObj;
		var id1 = " ", name1 = " ", value1 = " ", timestamp1 = " ", url1 = " ", value2, values = null;
		var notes1 = " ", type1 = " ", dir1 = " ", device1 = " ", units1 = " ", blockIndex = " ", blockName = " ", locValue = " ", locValueStr = "";
		var datapointName = " ", cp = " ", cat = " ", utc;
		var datapointQualifier = " ", priority = " ", unit = " ", lon_cfg = null;
		var deviceState = "", deviceHealth = "";
		var pathname = " ", programmaticPathName = " ", temp, temp1;
		var bUpdateMenuDiv = false, sUpdateMenuDivPathname = "", iIndex = -1;
		var bContinue = true;
		var len = dpList.length - 1;
		var tempObj, priorityElement;
		var objList = [];
		var d = new Date;
		var t = d.toTimeString();
		var presets;
		var date = d.toLocaleDateString();
		//var dates = date.split("/");
		var presetValue = " ";
		var bHasPresets = false;
		var bCreateGetRequestArr = false;
		//var currentTime = dates[2] + "-" + dates[1] + "-" +  dates[0] + " ";
		var currentTime = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0);
		iPtr = t.indexOf(" ");
		t = t.substr(0, iPtr);
		currentTime += t;
/*
		if((mode === 23) || (mode === 24)){
			mode = 1;
			type = 3;
		}
*/		
		if(mode === 43) {
			mode = 3;
			bUpdateMenuDiv = true;
		}
		if(mode === 0) {
			paneContent = "<tHead><tr><th onclick=\"sortTable(0)\">#</th><th>";
			if(g_iMainDisplayMode === DISPLAYMODE_DPS)
				paneContent += "<div style=\"display:flex\"><input type=\"checkbox\" id=\"favoritesCheckbox\" onclick=\"favoritesCheckbox()\">";
			paneContent += "FAV";
			if(g_iMainDisplayMode === DISPLAYMODE_DPS)
				paneContent += "</div>"
			paneContent += "</th><th>Menu</th><th onclick=\"sortTable(3)\">Device</th><th onclick=\"sortTable(4)\">Block</th><th onclick=\"sortTable(5)\">DP</th>";
			paneContent += "<th id=\"info1\" onclick=\"sortTable(6)\">DP XIF Name</th>";
			paneContent += "<th onclick=\"sortTable(7)\">Preset</th><th onclick=\"sortTable(8)\" class=\"tdValue\">Local Value</th><th onclick=\"sortTable(9)\" class=\"tdValue\">Value</th>";
			paneContent += "<th onclick=\"sortTable(10)\">Priority</th><th>New Value (Normal priority only)<br>"; 
			paneContent += " [<input type=\"checkbox\" id=\"usePriority\" onclick=\"usePriority()\"";
			if(g_bUsePriorityForAllWrites)
				paneContent += " checked";
			paneContent += "> Add Priority";
			paneContent += " <input type=\"checkbox\" id=\"useLocalValue\" onclick=\"useLocalValue()\"";
			if(g_bUseLocalizationForAllWrites)
				paneContent += " checked";
			paneContent += ">Local Value]";
			paneContent += "</th>";
			paneContent += "<th onclick=\"sortTable(12)\">Units</th>";
			paneContent += "<th onclick=\"sortTable(13)\">Timestamp</th><th onclick=\"sortTable(14)\">DP Type</th><th onclick=\"sortTable(15)\">Direction</th><th onclick=\"sortTable(16)\">Path</th><th onclick=\"sortTable(17)\">Path (programmatic)</th><th onclick=\"sortTable(18)\">dpQualifier</th></tHead><tbody>"; 
		}
			// clear javascript Object information
		if((g_iMainDisplayMode === DISPLAYMODE_DPS) || (g_iMainDisplayMode === DISPLAYMODE_DASHBOARD)) {
			for(z=0; z < dpList.length; z++)
			{
				dpList[z].valuesChanged = false;
			}
		}
		else if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
			for(z=0; z < dashboardDpList.length; z ++)
			{
				dashboardDpList[z].valuesChanged = false;
			}
		}
		else if(g_iMainDisplayMode === DISPLAYMODE_FAVDPS) {
			for(z=0; z < favDpList.length; z++)
			{
				favDpList[z].valuesChanged = false;
			}
		}
		

		
		
	
		  var bNewDeviceDetected = false;
/*		  
	  	if(latestTimestamp !== null) {
			timestampStr = new Date(convertIsoDateStringToDateObj(latestTimestamp));
			timestamp1ms = timestampStr.getTime();
		}
*/		
		for(i= 0; i < json.length; i ++)
	  	{
			id1 = " ";
			name1 = " ";
			value1 = " ";
			timestamp1 = " ";
			url1 = " ";
			notes1 = " ";
			type1 = " "; 
			dir1 = " ";
			device1 = " ";
			units1 = " ";
			datapointName = " ";
			datapointQualifier = " ";
			priority = " ";
			pathname = ""; type1 = " "; cat = " "; locValue = " "; locValueStr = ""; unit = " ";  lon_cfg = null;
			local = ""; utc = ""; deviceState = ""; deviceHealth = "";
			cp = " ";
			values = null;
			presetValue = " ";

			obj = json[i];
			if(type === 0) {
				try {
					datapointName = obj.datapointName; //xif
				}
				catch (err) {}
				try { 
						if(obj.name === null) // user changeable name
							name1 = obj.datapointName; // CMS shows datapoint XIF name if datapoint instance name is null
						else
							name1= obj.name;  // user changeable name
						
				}
				catch (err) {} // name only started showing up in 2.8
				try {
					id1 = obj.id
				}
				catch (err) {}
				try {
					//type1 = obj.type
				}
				catch (err) {}
				try {
					if(typeof obj.local === "undefined") {
						local = currentTime;
						utc = "";
					}
					else 
						local = obj.local;

					timestamp1 = local;
					local = timestamp1;
					iPtr = timestamp1.lastIndexOf("[");
					if(iPtr > 0) {
						iPtr = timestamp1.lastIndexOf("-",iPtr);
						if(iPtr > 0) {
							timestamp1 = timestamp1.substr(0, iPtr);
							timestamp1 = timestamp1.replace(/T/g," ");
						}
					}

				}
				catch (err) {}
				try {
					url1 = obj.url;
				}
				catch (err) {}
				try {
					value1 = obj.value;
				}
				catch (err) {}
				try {
					notes1 = obj.notes;
				}
				catch (err) {}
				try {
					blockIndex = obj.blockIndex;
				}
				catch (err) {}
				try {
					blockName = obj.blockName;
				}
				catch (err) {}
				try {
					device1 = obj.deviceName;
				}
				catch (err) {}
				try {
					priority = obj.values.level;
				}
				catch (err) {}
				try {
					//state1 = obj.state
				}
				catch (err) {}
				try {
					datapointQualifier = obj.dpQualifier;
				}
				catch (err) {}
				try {
					if(typeof obj.deviceState !== "undefined") {
						deviceState = obj.deviceState;
					}
					if(typeof obj.deviceHealth !== "undefined") {
						deviceHealth = obj.deviceHealth;
					}
					//if((deviceState !== "") && (deviceHealth)) {
					//	if(deviceState === "provisioned")
					//		deviceState = deviceHealth;
					//}
					datapointQualifier = obj.dpQualifier;
				}
				catch (err) {}
				try {
					values = obj.values;
				}
				catch (err) {}
				try { type1 = obj.type; } catch (err) {}
				try { cat = obj.cat; } catch (err) {}
				try { lon_cfg = obj["lon.cfg"];
					unit = lon_cfg.unit;
				 } catch (err) {} 
				
				try { 
					presetValue = obj.presetValue;
					if(presetValue === null)
						presetValue = "";
				 } catch (err) {}
				try {
					presets = obj.presets;
				}
				catch {presets = null; }
				try { 
					if(!(typeof obj.locValue === "undefined")) {
						locValue = obj.locValue; // GET request
					if(locValue !== null) {
						if(locValue !== " ")
							if(typeof locValue === "number")
								locValueStr = locValue.toString();
							else
								locValueStr = JSON.stringify(locValue);
						}
					}
				 } catch (err) {}
				programmaticPathName = device1 + "/" + blockName  + "/" + blockIndex  + "/" + datapointName;
				pathname = device1 + "/" + blockName  + "/" + blockIndex  + "/" + name1;
				if(json.length === 1)
					sUpdateMenuDivPathname = programmaticPathName;
			}
			else if(type === 1) { 
				// Web socket response
				if(typeof obj.local === "undefined") {
					local = currentTime;
					utc = "";
				}
				else 
					local = obj.local;
				timestamp1 = local;
				try {
					datapointQualifier = obj.datapointQualifier;
				}
				catch (err) {}
				try {
					value1 = obj.value
					try {

					}
					catch {}
					
				}
				catch (err) {}
				try { 
					presetValue = obj.presetValue;
					if(presetValue === null)
						presetValue = "";
				 } catch (err) {}
				 try { 
					if(!(typeof obj.locValue === "undefined")) {
						locValue = obj.locValue;
						if(locValue === null)
							locValue = "";
						else {
							if(typeof locValue === "number")
								locValueStr = locValue.toString();
							else
								locValueStr = JSON.stringify(locValue);
						}
					}
				 } catch (err) {}
			}
			else if (type === 3) {
				try {
					datapointQualifier = obj.dpQualifier;
				}
				catch (err) {}
				try {
					values = obj.values;
					priority = obj.values.level;
				}
				catch (err) {}
			}
			if(type !== 3)
				valueStr = JSON.stringify(value1);
/*			
				// get latest timestamp
			if(ivLatestTimestamp === null) {
				ivLatestTimestamp = timestamp1;
				timestampStr = new Date(convertIsoDateStringToDateObj(ivLatestTimestamp));
				timestamp1ms = timestampStr.getTime();
			}
			else {
				timestampStr = new Date(convertIsoDateStringToDateObj(timestamp1));
				timestamp2ms = timestampStr.getTime();
				if(timestamp2ms > timestamp1ms) {
					bTimeStampChanged = true;
					ivLatestTimestamp = timestamp1;
					timestamp1ms = timestamp2ms;
				}
			}
*/			

			z = -1;
			if(g_iMainDisplayMode === DISPLAYMODE_DPS) {
				for(j=0; j < dpList.length; j ++)
				{
					if(dpList[j].dpQualifier === datapointQualifier) {
						z = j;
						break;
					}
				}
			}
			else if(g_iMainDisplayMode === DISPLAYMODE_FAVDPS) {
				for(j=0; j < favDpList.length; j ++)
				{
					if(favDpList[j].dpQualifier === datapointQualifier) {
						z = j;
						break;
					}
				}
			}
			else if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
				for(j=0; j < dashboardDpList.length; j ++)
				{
					if(dashboardDpList[j].dpQualifier === datapointQualifier) {
						iIndex = j;
						z = j;
						break;
					}
				}
			}
			if(((mode === 0) || (mode === 8)) && (z === -1)) {
					dpObj = {};
					dpObj.id = -1;
					dpObj.deviceName = device1;
					dpObj.dpName = name1;
					dpObj.datapointName = datapointName;
					dpObj.pathname = pathname; //deviceName + "/" + dpName;
					dpObj.programmaticPathname = programmaticPathName; 
					dpObj.urlPath = device1 + "/if/" + blockName + "/" + blockIndex + "/";
					if(g_iSmartServerVersion >= 320114)
						dpObj.urlPath += "*+xifName==";
					dpObj.urlPath += datapointName;
					dpObj.blockName = blockName;
					dpObj.blockIndex = blockIndex;
					dpObj.block = blockName + "/" + blockIndex;
					dpObj.dpQualifier = datapointQualifier;
					dpObj.dpTableIndex = "";
					dpObj.value = value1;
					dpObj.valueStr = valueStr;
					dpObj.values = values;  // priority array
					dpObj.locValueStr = locValueStr;
					dpObj.locValue = locValue;
					dpObj.presetValue = presetValue;
					dpObj.type = type1;
					dpObj.priority = priority;
					dpObj.presets = presets;
					dpObj.local = local;
					dpObj.utc = utc;
					dpObj.unit = unit;
					dpObj.lon_cfg = lon_cfg;
					if(deviceState !== "")
						dpObj.deviceState = deviceState;
					if(deviceHealth !== "")
						dpObj.deviceState = deviceHealth;
					dpObj.updateDpValue = false; // used to make sure next web socket update for this dp changes value -- needed for writes, as presets and localization and value out of sync
					
					if((type1.indexOf("SCPT") === 0) || (type1.indexOf("UCPT") === 0)) 
						dpObj.cp = "x";
					else
						dpObj.cp = " ";
					dpObj.cat = cat;
					dpObj.valuesChanged = true;
					dpObj.timestampStr = timestamp1;
					g_iDisplayIndex++;
					dpObj.favDisplayId = "fav_" + g_iDisplayIndex;
					dpObj.valueDisplayId = "currentValue_" + g_iDisplayIndex;
					dpObj.valueDisplayId = "localValue_" + g_iDisplayIndex;
					dpObj.newValueDisplayId = "newValue_" + g_iDisplayIndex;
					if((g_iMainDisplayMode === DISPLAYMODE_DPS) || (g_iMainDisplayMode === DISPLAYMODE_DASHBOARD))
						dpList.push(dpObj);
					else if(g_iMainDisplayMode === DISPLAYMODE_FAVDPS)
						favDpList.push(dpObj); // should only be used for getting fav list from CMS
			}
			else if (z !== -1){
				if(g_iMainDisplayMode === DISPLAYMODE_DPS) {
					if(type === 3) {
						if(isNotEqual(dpList[z].values, values)) {
							dpList[z].priority = priority;
							dpList[z].values = values;
							if(dpList[z].cat === "in") {
								priorityElement =document.getElementById("priority_"+ dpList[z].pathname);
								if(priorityElement !== null) {
									priorityElement.innerHTML = priority;
								}
							}
						}
					}
					else if((!(dpList[z].valueStr === valueStr)) || (mode === 2)) {
						dpList[z].valuesChanged = true;
						dpList[z].value = value1;
						dpList[z].valueStr = valueStr;
						dpList[z].presetValue = presetValue;
						dpList[z].locValueStr = locValueStr;
						dpList[z].locValue = locValue;
						dpList[z].local = local;
						dpList[z].utc = utc;
						if(deviceState !== "")
							dpList[z].deviceState = deviceState;
						if(deviceHealth !== "")
							dpList[z].deviceState = deviceHealth;

						if(mode === 2) {
							//dpList[z].priority  //ffixxzzzzzzz
							dpList[z].values = values; // priority array
							priorityElement =document.getElementById("priority_"+ dpList[z].pathname);
							if(priorityElement !== null) {
								if(priorityElement.innerHTML !== dpList[z].values.level)
									priorityElement.innerHTML = dpList[z].values.level;
							}
						}
						
						if((mode === 1) || (mode === 2)) {
							document.getElementById("currentValue_" + dpList[z].pathname).innerHTML = valueStr;
							document.getElementById("presetValue_" + dpList[z].pathname).innerHTML = presetValue;
							document.getElementById("localValue_"+ dpList[z].pathname).innerHTML = locValueStr;
							dpList[z].timestampStr = timestamp1;
							document.getElementById("timestamp_"+ dpList[z].pathname).innerHTML = dpList[z].timestampStr;
						}
					}
				}
				else if(g_iMainDisplayMode === DISPLAYMODE_FAVDPS) {
					if(type === 3) {
						if(isNotEqual(favDpList[z].values, values)) {
							favDpList[z].priority = priority;
							favDpList[z].values = values;
							if(favDpList[z].cat === "in") {
								priorityElement = document.getElementById("priority_"+ favDpList[z].pathname);
								if(priorityElement !== null) {
									priorityElement.innerHTML = priority;
								}
							}
						}
					}
					else if((!(favDpList[z].valueStr === valueStr)) || (mode === 2)) {
						favDpList[z].valuesChanged = true;
						favDpList[z].value = value1;
						favDpList[z].valueStr = valueStr;
						favDpList[z].presetValue = presetValue;
						favDpList[z].locValueStr = locValueStr;
						favDpList[z].locValue = locValue;
						favDpList[z].local = local;
						favDpList[z].utc = utc;
						if(deviceState !== "")
							favDpList[z].deviceState = deviceState;
						if(deviceHealth !== "")
							favDpList[z].deviceState = deviceHealth;
						if(mode === 2) {
							//dpList[z].priority  //ffixxzzzzzzz
							favDpList[z].values = values; // priority array
							priorityElement = document.getElementById("priority_"+ favDpList[z].pathname);
							if(priorityElement !== null) {
								if(priorityElement.innerHTML !== favDpList[z].values.level)
									priorityElement.innerHTML = favDpList[z].values.level;
							}
						}
						if((mode === 1) || (mode === 2)) {
							document.getElementById("currentValue_" + favDpList[z].pathname).innerHTML = valueStr;
							document.getElementById("presetValue_" + favDpList[z].pathname).innerHTML = presetValue;
							document.getElementById("localValue_"+ favDpList[z].pathname).innerHTML = locValueStr;
							favDpList[z].timestampStr = timestamp1;
							document.getElementById("timestamp_"+ favDpList[z].pathname).innerHTML = favDpList[z].timestampStr;
						}
					}
				}
				else if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
					if(type === 3) {
						if(isNotEqual(dashboardDpList[z].values, values)) {
							dashboardDpList[z].priority = priority;
							dashboardDpList[z].values = values;
							if(dashboardDpList[z].cat === "in") {
								priorityElement = document.getElementById("dpValueMenu_"+ dashboardDpList[z].pathname);
								if(priorityElement !== null) {
									if(priority === 17) {
										temp1 = "priorityButtonNotActive";
										temp = "...";
									}
									else {
										temp1 = "priorityButtonActive";
										temp = "P " + priority;
									}
									if(temp !== priorityElement.innerHTML) {
										priorityElement.innerHTML = temp;
										priorityElement.className = temp1;
									}
								}
							}
						}
					}
					else if((!(dashboardDpList[z].valueStr === valueStr)) || (mode === 2)) {
						dashboardDpList[z].valuesChanged = true;
						dashboardDpList[z].value = value1;
						dashboardDpList[z].valueStr = valueStr;
						dashboardDpList[z].presetValue = presetValue;
						dashboardDpList[z].locValueStr = locValueStr;
						dashboardDpList[z].locValue = locValue;
						dashboardDpList[z].priority = priority;
						dashboardDpList[z].values = values;
						dashboardDpList[z].local = local;
						dashboardDpList[z].utc = utc;
						if(deviceState !== "")
							dashboardDpList[z].deviceState = deviceState;
						if(deviceHealth !== "")
							dashboardDpList[z].deviceState = deviceHealth;

						if(mode === 2) {
							//dpList[z].priority  //ffixxzzzzzzz
							dashboardDpList[z].values = values; // priority array
							priorityElement = document.getElementById("priority_"+ dashboardDpList[z].pathname);
							if(priorityElement !== null) {
								if(priorityElement.value !== dashboardDpList[z].values.level)
									priorityElement.value = dashboardDpList[z].values.level;
							}
						}
						
						if((mode === 1) || (mode === 2)) {
							document.getElementById("currentValue_" + dashboardDpList[z].pathname).innerHTML = valueStr;
							document.getElementById("presetValue_" + dashboardDpList[z].pathname).innerHTML = presetValue;
							document.getElementById("localValue_"+ dashboardDpList[z].pathname).innerHTML = locValueStr;
							dashboardDpList[z].timestampStr = timestamp1;
							document.getElementById("timestamp_"+ dashboardDpList[z].pathname).innerHTML = dashboardDpList[z].timestampStr;
							priorityElement = document.getElementById("priority_"+ dashboardDpList[z].pathname);
							if(priorityElement !== null) {
								priorityElement.value = priority;
							}
						}
					}
				}
				
			}
		} //for(i= 0; 

		if((mode === 0) || (mode === 8)) {
			// sort dplist
			bContinue = true;
			objList = [];
			if(g_iMainDisplayMode === DISPLAYMODE_DPS) {
				while(bContinue) 
				{
					bContinue = false;
					
					for(j=0; j < (dpList.length - 1); j ++)
					{
						if(dpList[j].pathname.toLowerCase() > dpList[j + 1].pathname.toLowerCase()) {  
							tempObj = {};
							tempObj = dpList[j + 1];
							dpList[j + 1] = dpList[j];
							dpList[j] = tempObj;
							bContinue = true;
						}
					}
				}
			}
			else if(g_iMainDisplayMode === DISPLAYMODE_FAVDPS) {
				while(bContinue) 
				{
					bContinue = false;
					
					for(j=0; j < (favDpList.length - 1); j ++)
					{
						if(favDpList[j].pathname.toLowerCase() > favDpList[j + 1].pathname.toLowerCase()) {  
							tempObj = {};
							tempObj = favDpList[j + 1];
							favDpList[j + 1] = favDpList[j];
							favDpList[j] = tempObj;
							bContinue = true;
						}
					}
				}
			}
			if(g_iMainDisplayMode === DISPLAYMODE_DPS)
				objList = dpList;
			else if(g_iMainDisplayMode === DISPLAYMODE_FAVDPS)
				objList = favDpList;
			else if (g_iMainDisplayMode === DISPLAYMODE_DASHBOARD)
				objList = dashboardDpList;

			len = objList.length - 1;
			
			
			if(mode === 8) {
				showDashboard(8,"", -1);
				return;
			}
			// create table

			for(j=0; j < objList.length; j ++)
			{
				paneContent += "<tr><td>" + (j + 1).toString() + "</td>";
					// check if in favorites
				z = -1;
				if(g_iMainDisplayMode === DISPLAYMODE_FAVDPS) {
					z = 1;

				}
				else {
					for(i=0; i < favDpList.length; i++ )
					{
						if(dpList[j].pathname === favDpList[i]. pathname) {
							z = i;
							break;
						}
					}
				}
				
				if(z === -1)
					paneContent += "<td><input type=\"checkbox\" id=\"fav_" + objList[j].pathname + "\" onclick=\"addToFavorites('" + objList[j].pathname + "')\"></td>";
				else 
					paneContent += "<td><input type=\"checkbox\" id=\"fav_" + objList[j].pathname + "\" onclick=\"addToFavorites('" + objList[j].pathname + "')\" checked></td>";
				//paneContent += "<td><button id=\"dpMenu_" + objList[j].programmaticPathname + "\" style=\"margin-left:5px;margin-right:5px;\" onclick=\"menuDp(event, ";
				paneContent += "<td><button id=\"dpMenu_" + objList[j].pathname + "\" style=\"margin-left:5px;margin-right:5px;\" onclick=\"menuDp(event, ";  // may need to ffixx
				if(g_iMainDisplayMode === DISPLAYMODE_FAVDPS)
					paneContent += "1, ";
				else
					paneContent += "0, ";
				paneContent += j + ", '" + objList[j].pathname + "', '" + objList[j].programmaticPathname + "')\">...</button></td>";
				paneContent += "<td>" + objList[j].deviceName + "</td><td>" + objList[j].block  + "</td><td>" + objList[j].dpName + "</td>";
				paneContent += "<td>" + objList[j].datapointName + "</td>";
				//paneContent += "<td class=\"tdValue\"><span id=\"currentValue_" + objList[j].pathname + "\">" + objList[j].valueStr + "</span></td>";
				paneContent += "<td class=\"tdPreset\"><span id=\"presetValue_" + objList[j].pathname + "\">" + objList[j].presetValue + "</span></td>";
				//paneContent += "<td class=\"tdValue\"><div id=\"currentValue_" + objList[j].pathname + "\">" + objList[j].valueStr + "</div></td>";
				paneContent += "<td class=\"tdValue\"><div id=\"localValue_" + objList[j].pathname + "\" class=\"tdValueDiv\">" + objList[j].locValueStr + "</div></td>";
				paneContent += "<td class=\"tdValue\"><div id=\"currentValue_" + objList[j].pathname + "\" class=\"tdValueDiv\">" + objList[j].valueStr + "</div></td>";
				
				if(objList[j].cat === "in") {
					paneContent += "<td><span id=\"priority_" + objList[j].pathname + "\">";
					if(objList[j].priority === 17)
						paneContent += "Normal";
					else
						paneContent += objList[j].priority;
					paneContent += "</span></td>";
					paneContent += "<td><div class=\"tdNewValueDiv\"><input id=\"newValue_" + objList[j].pathname + "\""; 
					/*
					paneContent += " onfocus=\"inputBoxOnFocus(this, " + j + ", '" + objList[j].pathname + "')\"";
					paneContent += " onchange=\"inputBoxChanged(this, " + j + ", '" + objList[j].pathname + "')\"";
					paneContent += " onblur=\"inputBoxLostFocus(this, event, " + j + ", '" + objList[j].pathname + "')\"";
					
					paneContent += " onkeyup=\"inputBoxKey(this, event, " + j + ", '" + objList[j].pathname + "')\""; 
					*/
					bHasPresets = false;
					if(objList[j].hasOwnProperty('presets')) {
						if(objList[j].presets !== null) {
							if(typeof objList[j].presets !== "undefined") { // needed for internal apps
								if(objList[j].presets.enabled) {
									if(objList[j].presets.map.length > 0) {
										bHasPresets = true;
										paneContent += " list=\"dpNewValuePresetList_" + objList[j].pathname + "\"><datalist id=\"dpNewValuePresetList_" + objList[j].pathname + "\">"
										for(i=0; i < objList[j].presets.map.length; i++)
										{
											name1 = objList[j].presets.map[i].name;
											paneContent += "<option value='" + name1 + "'>"  + name1 + "</option>";
										}
										paneContent += "<option value='" + objList[j].valueStr + "'>Raw Value</option>";
										paneContent += "</datalist";
									}
								}
							}
						}
					}
					if(!bHasPresets) {
						paneContent += " list=\"dpNewValuePresetList_" + objList[j].pathname + "\"><datalist id=\"dpNewValuePresetList_" + objList[j].pathname + "\">"
						paneContent += "<option value='" + objList[j].valueStr + "'>Raw Value</option>";
						paneContent += "</datalist";
					} 
					paneContent += "><button style=\"margin-left:10px\" onclick=\"inputBoxSendValue(this, event, " + j + ", '" + objList[j].pathname + "')\">Send</button>";
					paneContent += "<button id=\"dpValueMenu_" + objList[j].pathname + "\" style=\"margin-left:10px\" onclick=\"menuDpValue(this, " + j + ", '" + objList[j].pathname + "')\">...</button></div></td>";
				}
				else 
					paneContent += "<td></td><td></td>";
				paneContent += "<td><span id=\"unit_" + objList[j].pathname + "\">";
				if(typeof objList[j].unit !== "undefined") {
					if(!(objList[j].unit.indexOf("unit") !== -1))
						paneContent += objList[j].unit;
				}
				paneContent += "</span></td>";
				
				paneContent += "<td><span id=\"timestamp_" + objList[j].pathname + "\">" + objList[j].timestampStr + "</span></td>";
				paneContent += "<td>" + objList[j].type + "</td><td>" + objList[j].cat + "</td>";
				paneContent += "<td class=\"pathname\">" + objList[j].pathname + "</td>";
				paneContent += "<td class=\"pathname\">" + objList[j].programmaticPathname + "</td>";
				paneContent += "<td class=\"pathname\">" + objList[j].dpQualifier + "</td>";
				paneContent += "</tr>"; 
			}

			paneContent = "<br><table id=\"myTable\">" + paneContent + "</tbody></table>";
			paneContent += addTopButton();
			document.getElementById("main").innerHTML = paneContent;
			
			 
			document.getElementById("dpCount").innerHTML = " [" + objList.length + "]";
			
			
			
		} // if(mode === 0)
	}	
	catch (err) {}
	//setTopContainerSize();
	try {
		if(mode === 0) {
			if(objList.length > 0) {
				// g_dpGetRequestArr 
				if(g_iMainDisplayMode === DISPLAYMODE_DPS) {
					if(dpList.length > 0) {
						
						createRequestString(dpList);
					}
				}
				else if(g_iMainDisplayMode === DISPLAYMODE_FAVDPS) {
					if(favDpList.length > 0) {
						createRequestString(favDpList);
						if(bivUseWebSockets) {
							if(g_bAutoSubscribe) {
								if(g_sWebSocketSubscribePayload !== g_sWebSocketSubscribePayload_oldvalue)
									subscribeRequest();
							}
						}
					}
				}
			}
			showAllDpAdditionalInfoCheckBox();
			pollCheckBox(); // if start polling if enabled
		}
		if(bUpdateMenuDiv) {
			element = document.getElementById("menuDiv");
			if(element !== null) {
				if((g_sMenuDivPathname !== "") && (sUpdateMenuDivPathname !== "")) {
					if(g_sMenuDivPathname === sUpdateMenuDivPathname) {
						menuDpValueSetup(0, index, "", null); //menuDpValueSetup(0, null, index, "", null);
					}
				}
			}
		}
	}
	catch{}
} 

function getDeviceTypes(mode) {
	
	// used for Web sockets
	var	url = "https://" + location.hostname + "/iap/devTypes/*?short=false&sortBy=name&sortOrder=asc";
	requestGetData(mode, url, getDeviceTypesResponse, readFailCallback);
}

function getDeviceTypesResponse(mode, requestUrlString, json) {
	try {
		var i, url;
		var obj;
		var name = ""; numberOfDevices = "", programId = "", xifName = "", id = "", autoSysLoad = "", autoAppLoad = "", isDefault = "";
		var bNewDeviceDetected = false;
		var paneContent = "<tHead><tr><th onclick=\"sortTable(0)\">#</th><th>Menu</th><th onclick=\"sortTable(2)\">Device Type Name</th><th onclick=\"sortTable(3)\">Driver</th><th onclick=\"sortTable(4)\">Device Count</th><th onclick=\"sortTable(5)\">Program ID</th><th onclick=\"sortTable(6)\">XIF Filename</th>";
		paneContent += "</th><th onclick=\"sortTable(7)\">id</th><th onclick=\"sortTable(8)\">Auto System Load</th><th onclick=\"sortTable(9)\">Auto App Load</th><th onclick=\"sortTable(10)\">Default</th></tr>";  

		
		// only a fresh SmartServer there is only a SmartServer but no device types
		
		
		deviceTypeList = json;
		if(mode === 25) {
			return;
		}
		else if(mode === 5) {
			showServicePinMessagesHistory();
			return;
		}
		else if (mode == 10) {
			showDevicesFromDeviceList(deviceList);
			return;
		}
		else if(mode === 11) {
			getDeviceList("/iap/devs?noxs=true&sortBy=name");
			return;
		}
		else if (mode === 12) {
			getDeviceList("/iap/devs?short=true&sortBy=name");
			return;
		}
		else if (mode === 14) {
			if(deviceList.length === 0)
				getDeviceList("/iap/devs?short=true&sortBy=name");
			else
				getDeviceInfoUsingDeviceList();
			return;
		}
		else if (mode === 19) {
			url = "https://" + location.hostname + "/iap/devTypes/*/if/*/*/*/dla?includeUnconfigured=false";
			requestGetData(mode, url, getDlaSettingsResponse, readFailCallback);
			return;
		}
		if (json.length === 0) {
			if(mode < 4)
				document.getElementById("gettingInfoId").innerHTML = "No Device Types Available";
			return;
		}
		for(i= 0; i < json.length; i ++)
	  	{
			

			obj = json[i];
			name = "";
			numberOfDevices = ""; programId = ""; xifName = ""; id = ""; autoSysLoad = ""; autoAppLoad = ""; isDefault = "";
			try { 	name = obj.name;	} 	catch (err) {}
			try { 	protocol = obj.protocol; }	catch (err) {}
			try { 	numberOfDevices = obj.numberOfDevices;	} 	catch (err) {}
			try { 	programId = obj.programId; }	catch (err) {}
			try { 	xifName = obj.xifName;	} 	catch (err) {}
			try { 	id = obj.id; }	catch (err) {}
			try { 	if(obj.autoSysLoad)
						autoSysLoad = 	obj.autoSysLoad;
			} 	catch (err) {}
			try { 	if(obj.autoAppLoad)
						autoAppLoad = obj.autoAppLoad; 
			}	catch (err) {}
			try { 	if(obj.isDefault)
						isDefault = obj.isDefault	
			} 	catch (err) {}
			
			

			paneContent += "<tr><td>" + (i + 1).toString() + "</td><td><button id=\"deviceTypeMenu_" + name + "\" onclick=\"menuDeviceType(0, event, " + id + ", '" + name + "')\">...</button></td>";
			paneContent += "<td>" + name + "</td><td>" + protocol + "</td><td>" + numberOfDevices + "</td><td>" + programId + "</td>";
			paneContent += "<td>" + xifName + "</td><td>" + id + "</td><td>" + autoSysLoad + "</td><td>" + autoAppLoad + "</td><td>" + isDefault  + "</td>"; 
			paneContent += "</tr>";
		} //for(i= 0; 
		paneContent = "<br><table id=\"myTable\" style=\"margin-bottom: 70px\">" + paneContent + "</tbody></table>";
		document.getElementById("main").innerHTML = paneContent;
	}
	catch (err) {}

}


function getDlaSettings() {
	
	// used for Web sockets
	var	url = "https://" + location.hostname + "/iap/devTypes/*/if/*/*/*/dla?includeUnconfigured=false";
	
	
	requestGetData(0, url, getDlaSettingsResponse, readFailCallback);
}

function getDlaSettingsResponse(mode, requestUrlString, json) {
	// mode: 9=dpInfo
	
	if((mode !== 9) && (mode !== 19)) {
		if (json.length === 0) {
			document.getElementById("gettingInfoId").innerHTML = "No Datapoint properties configured";
			return;
		}
	}
	

	try {
		var i, j, ave = 0, count, iTemp;
		var obj, obj1;
		var id1 = " ", protocol = "", deviceTypeName = "", fullDpName = "", dpType = "", dpCategory = ""; 
		var	monitored = "",  logged = "",  alarmed = "", localization = ""; 
		var polled = "", pollInterval = "", publishInterval = "", publishMinDeltaTime = "", publishMinDeltaValue = "", initialValue = "", logInterval1 = "", logInterval2 = "", logInterval3 = ""; 
		var logRetention1 = "", logRetention2 = "", logRetention3 = "", logMultiply1 = "", logMultiply2 = "", logMultiply3 = "", logMinDeltaTime = "", logMinDeltaValue = "", alarmName = ""; 
		var highWarning = "", lowWarning = "", highAlarm = "", lowAlarm = "", presets = "", alarmDetails = "", visible = ""; 
		
		var paneContent = "<thead><tr><th class=\"tableDlaThCol1\" onclick=\"sortTable(0)\">#</th><th>Menu</th><th class=\"tableDlaThCol2\" onclick=\"sortTable(2)\">Device Type Name</th>";
		paneContent += "<th class=\"tableDlaThCol3\" onclick=\"sortTable(3)\">XIF DP Path</th><th onclick=\"sortTable(4)\">DP Type</th><th onclick=\"sortTable(5)\">DP Category</th>";
		paneContent += "<th onclick=\"sortTable(6)\">Visible</th>";
		paneContent += "<th onclick=\"sortTable(7)\">monitored</th>";
		paneContent += "<th onclick=\"sortTable(8)\">logged</th><th onclick=\"sortTable(9)\">alarmed</th><th>";
		if(g_iSmartServerVersion >= 320000) 
			paneContent += "Monitoring Method";
		else
			paneContent += "polled"; 
		paneContent += "</th><th onclick=\"sortTable(10)\">poll Interval"; 
		paneContent += "</th><th onclick=\"sortTable(11)\">publish Interval</th><th onclick=\"sortTable(12)\">publish MinDeltaTime</th><th onclick=\"sortTable(13)\">publish MinDeltaValue</th>";
		paneContent += "<th onclick=\"sortTable(14)\">initial Value</th><th onclick=\"sortTable(15)\">log Interval1</th><th onclick=\"sortTable(16)\">"; 
		paneContent += "log Interval2</th><th onclick=\"sortTable(17)\">log Interval3</th><th onclick=\"sortTable(18)\">log Retention1</th><th onclick=\"sortTable(19)\">log Retention2</th>";
		paneContent += "<th onclick=\"sortTable(20)\">log Retention3</th><th onclick=\"sortTable(21)\">log Multiply1</th><th onclick=\"sortTable(22)\">"; 
		paneContent += "logMultiply2</th><th onclick=\"sortTable(23)\">log Multiply3</th><th onclick=\"sortTable(24)\">log MinDeltaTime</th><th onclick=\"sortTable(25)\">log MinDeltaValue</th>";
		paneContent += "<th onclick=\"sortTable(26)\">alarmName</th><th onclick=\"sortTable(27)\">"; 
		paneContent += "highWarning</th><th onclick=\"sortTable(28)\">lowWarning</th><th onclick=\"sortTable(29)\">highAlarm</th><th onclick=\"sortTable(30)\">lowAlarm</th>";
		if(g_iSmartServerVersion >= 320000) 
			paneContent += "<th onclick=\"sortTable(31)\">Alarm Details</th>";
		paneContent += "<th onclick=\"sortTable(32)\">Presets</th><th onclick=\"sortTable(33)\">Localization</th></tr></thead>"; 

		
			// clear javascript Object information
/*		
		for(z=0; z < dpList.length; z++)
		{
			dpList[z].valuesChanged = false;
		}
*/
		
		
	
		  var bNewDeviceDetected = false;
/*		  
	  	if(latestTimestamp !== null) {
			timestampStr = new Date(convertIsoDateStringToDateObj(latestTimestamp));
			timestamp1ms = timestampStr.getTime();
		}
*/		
		dlaAlarmList = [];
		dlaList = json;
		for(i= 0; i < json.length; i ++)
	  	{
			id1 = " "; protocol = ""; deviceTypeName = ""; fullDpName = ""; dpType = ""; dpCategory = ""; 
			monitored = "";  logged = "";  alarmed = ""; 
			polled = ""; pollInterval = ""; publishInterval = ""; publishMinDeltaTime = ""; publishMinDeltaValue = ""; initialValue = ""; logInterval1 = ""; logInterval2 = ""; logInterval3 = ""; 
			logRetention1 = ""; logRetention2 = ""; logRetention3 = ""; logMultiply1 = ""; logMultiply2 = ""; logMultiply3 = ""; logMinDeltaTime = ""; logMinDeltaValue = ""; alarmName = ""; 
			highWarning = ""; lowWarning = ""; highAlarm = ""; lowAlarm = ""; 
			presets = "";
			localization = "";
			alarmDetails = "";
			visible = "";

			obj = json[i];
			
			try {
				deviceTypeName = obj.deviceTypeName;
			}
			catch (err) {}
			try {
				fullDpName = obj.fullDpName;
			}
			catch (err) {}
			try {
				visible = obj.visible;
			}
			catch (err) {}
			try {
				if(obj.dpType !== null)
					dpType = obj.dpType;
			}
			catch (err) {}
			try {
				if(obj.dpCategory !== null)
					dpCategory = obj.dpCategory;
			}
			catch (err) {}
			try {
				monitored = obj.monitored;
			}
			catch (err) {}
			try {
				logged = obj.logged;
			}
			catch (err) {}
			try { 	alarmed = obj.alarmed;	} 	catch (err) {}
			try { 	
				if(g_iSmartServerVersion >= 320000) {
					polled = obj.monitoringMethod;
				}
				else 
					polled = obj.polled; }
			catch (err) {}
			try { 	
				if(obj.pollInterval !== null)
					pollInterval = obj.pollInterval;
					
				} 	catch (err) {}
			try { if(obj.publishInterval !== null)	
					publishInterval = obj.publishInterval; }	catch (err) {}
			try { 	
				if(obj.publishMinDeltaTime !== null)
					publishMinDeltaTime = obj.publishMinDeltaTime;	} 	catch (err) {}
			try { 	
				if(obj.publishMinDeltaValue !== null)
					publishMinDeltaValue = obj.publishMinDeltaValue; }	catch (err) {}
			try { 	
				if(obj.initialValue !== null)
					initialValue = obj.initialValue;	} 	catch (err) {}
			try { 	logInterval1 = obj.logInterval1; }	catch (err) {}
			try { 	logInterval2 = obj.logInterval2	} 	catch (err) {}
			try { 	logInterval3 = obj.logInterval3; }	catch (err) {}
			try { 	logRetention1 = obj.logRetention1;	} 	catch (err) {}
			try { 	logRetention2 = obj.logRetention2; }	catch (err) {}
			try { 	logRetention3 = obj.logRetention3;	} 	catch (err) {}
			try { 	logMultiply1 = obj.logMultiply1; }	catch (err) {}
			try { 	logMultiply2 = obj.logMultiply2	} 	catch (err) {}
			try { 	logMultiply3 = obj.logMultiply3; }	catch (err) {}
			try { 	
				if(obj.logMinDeltaTime !== null)
					logMinDeltaTime = obj.logMinDeltaTime;	} 	catch (err) {}
			try { 	
				if(obj.logMinDeltaValue !== null)
					logMinDeltaValue = obj.logMinDeltaValue; }	catch (err) {}
			try { 	
				if(g_iSmartServerVersion >= 320000) {
					if(obj.alarmTypeName !== null) {
						alarmName = obj.alarmTypeName;
						obj1 = {};
						obj1.alarmName = alarmTypeName;
						obj1.id = -1;
						obj1.alarmType = "";
						dlaAlarmList.push(obj1);
					}
				}
				else {	
					if(obj.alarmName !== null) {
						alarmName = obj.alarmName;
						obj1 = {};
						obj1.alarmName = alarmName;
						obj1.id = -1;
						obj1.alarmType = "";
						dlaAlarmList.push(obj1);
					}
				}
			} 	catch (err) {}
			try { 	
				if(g_iSmartServerVersion >= 320000) {
					if(obj.alarmDetails !== null) {
						alarmDetails = obj.alarmDetails;
					}
				}
			} 	catch (err) {}
			try { 	
				if(obj.highWarning !== null)
					highWarning = obj.highWarning; }	catch (err) {}
			try { 	
				if(obj.lowWarning !== null)
					lowWarning = obj.lowWarning	} 	catch (err) {}
			try { 	
				if(obj.highAlarm !== null)
					highAlarm = obj.highAlarm; }	catch (err) {}
			try { 	
				if(obj.lowAlarm !== null)
					lowAlarm = obj.lowAlarm;	} 	catch (err) {}
			try {
				if(!(typeof obj.presets === "undefined"))  {
					if(obj.presets !== null) {
						presets = JSON.stringify(obj.presets);
					}
				}	
			} 	catch (err) {}
			try {
				if(!(typeof obj.localization === "undefined"))  {
					if(obj.localization !== null) {
						localization = JSON.stringify(obj.localization);
					}
				}	
			} 	catch (err) {}
			

			paneContent += "<tr ><td class=\"tableDlaTdCol1\">" + (i + 1).toString();
			paneContent += "<td class=\"tableDlaTd\"><button id=\"dpDlaMenu_" + deviceTypeName + "/" + fullDpName + "\" onclick=\"menuDla(0, event, '" + deviceTypeName + "', '" + fullDpName + "')\">...</button>"; //123455
			paneContent += "</td><td class=\"tableDlaTdCol2\">" + deviceTypeName + "</td><td class=\"tableDlaTdCol3\">" + fullDpName + "</td><td class=\"tableDlaTd\">" + dpType + "</td>";
			paneContent += "<td class=\"tableDlaTd\">" + dpCategory + "</td><td class=\"tableDlaTd\">" + visible + "</td><td class=\"tableDlaTd\">" + monitored + "</td>";
			paneContent += "<td class=\"tableDlaTd\">" + logged + "</td><td class=\"tableDlaTd\">" + alarmed + "</td><td class=\"tableDlaTd\">" + polled + "</td>";
			paneContent += "<td class=\"tableDlaTd\">" + pollInterval + "</td>"; 
			paneContent +=  "<td class=\"tableDlaTd\">" + publishInterval + "</td><td class=\"tableDlaTd\">" + publishMinDeltaTime + "</td>";
			paneContent += "<td class=\"tableDlaTd\">" + publishMinDeltaValue + "</td><td class=\"tableDlaTd\">" + initialValue + "</td><td class=\"tableDlaTd\">" + logInterval1 + "</td>";
			paneContent += "<td class=\"tableDlaTd\">" + logInterval2 + "</td><td class=\"tableDlaTd\">" + logInterval3 + "</td><td class=\"tableDlaTd\">" + logRetention1 + "</td>";
			paneContent += "<td class=\"tableDlaTd\">" + logRetention2 + "</td><td class=\"tableDlaTd\">" + logRetention3 + "</td><td class=\"tableDlaTd\">" + logMultiply1 + "</td>";
			paneContent += "<td class=\"tableDlaTd\">" + logMultiply2 + "</td><td class=\"tableDlaTd\">" + logMultiply3 + "</td><td class=\"tableDlaTd\">" + logMinDeltaTime + "</td>";
			paneContent += "<td class=\"tableDlaTd\">" + logMinDeltaValue + "</td><td class=\"tableDlaTd\">" + alarmName + "</td>";
			paneContent += "<td class=\"tableDlaTd\">" + highWarning + "</td><td class=\"tableDlaTd\">" + lowWarning + "</td><td class=\"tableDlaTd\">" + highAlarm + "</td>";
			paneContent += "<td class=\"tableDlaTd\">" + lowAlarm + "</td>";
			if(g_iSmartServerVersion >= 320000)
				paneContent +=  "<td class=\"tdValue tableDlaTd\"><div class=\"tdValueDiv\">" + alarmDetails + "</div></td>"; 
			paneContent += "<td class=\"tableDlaTd\">" + presets + "</td><td class=\"tableDlaTd\">" + localization + "</td></tr>"; 
			if(mode === 19) {
				count = 0;  
				if(monitored) {
					for(j=0; j < deviceTypeList.length; j++) 
					{	
						if(deviceTypeList[j].name === deviceTypeName) {
							count = deviceTypeList[j].numberOfDevices;
							if(polled) {
								iTemp = Number(pollInterval);
								if(iTemp !== 0) {
									g_epsInfo.dpPollCount += count;
									g_epsInfo.dlaPollDpCount += count;
									ave += (count * iTemp);
									g_epsInfo.eps += (count / iTemp);
								}
							}
							else 
								g_epsInfo.dlaEventDpCount += count;

						}
					}
				
					
				}
			}
		} //for(i= 0;
		if(mode === 19) {
			g_epsInfo.dlaEps = g_epsInfo.eps;
			if(g_epsInfo.dlaPollDpCount !== 0)
				g_epsInfo.dlaPollAve = ave / g_epsInfo.dlaPollDpCount;
			g_epsInfo.pollAve = g_epsInfo.dlaPollAve;
			g_sDpInfoPaneContent += "<br><table id=\"dlaTable\">" + paneContent + "</tbody></table>";
			g_sDpInfoPaneContent = "<br><hr>DLA:<br><br>" + g_sDpInfoPaneContent;
			g_bDpInfoShowDatalogButton = false;
			getDpInfoNodeRed(19);
		}
		else if(mode === 9) {
			g_sDpInfoPaneContent += "<br><table id=\"dlaTable\">" + paneContent + "</tbody></table>";
			g_bDpInfoShowDatalogButton = true;
		} 
		else {
			paneContent = "<br><table id=\"myTable\">" + paneContent + "</tbody></table>";
			paneContent += addTopButton();
			document.getElementById("main").innerHTML = paneContent;
		}
		//setTopContainerSize();
	}
	catch (err) {}

} 
function getGroups() { 
	var url = "https://" + location.hostname + "/iap/grp";
	groupList = [];
	requestGetData(0, url, getGroupsResponse, readFailCallback); // get Device list

} 
function getGroupsResponse(mode, requestUrlString, json){
	bivServerOnline = true;
	if((json === null) || (json.length === 0)) {
		document.getElementById("gettingInfoId").innerHTML = "No data avaiable";
		return;
	}
	
	try {
		var i, j, len,iPtr;
		var device1, device2;
		var id = " ", name = " ", scId = " ", scName = " ", protocol = " ", status = " ", health = " ", did = " ", category = " ", deviceType = " ", uid = " ", mru = " ";
		var obj;
		var deviceObj ={};
		var iCount1 = 0, index1 = 0;
		var bAddDevice = false;
		var paneContent = "";
		var bContinue = true;
		var tempObj;
		if(mode === 0)
			groupList = json;
		paneContent = prettyJson(json);
		document.getElementById("main").innerHTML = "<div><br><br><br>" + paneContent + "</div>";
		return;

		
	}
	catch {}
}
function getHelpButton() {
	window.open("navtreehelp.html", '_blank');
}
function _getParameter(str) {
	try {
		var sResult = str;
		var iPtr = str.indexOf("=");
		if(iPtr > 0) {
			if((iPtr + 1) < str.length) {
				sResult = str.substr(iPtr + 1);
			}
		}
	}
	catch {}
	return sResult;
}
function getSmartServerSettings() {
	getSmartServerSettings1(1);
}
function getSmartServerSettings1(mode) {
	// used to see EPS limits
	var url = "https://" + location.hostname + "/iap/settings/limits/configuration";
	
	requestGetData(mode, url, getSmartServerSettingsCallback, null); // paginagion does't work on device list get Device list
}
function getSmartServerSettingsCallback(mode, requestUrlString, json) {
	//checkForLoginCookie();
	try {
		
		if(json !== null) {
			if((typeof json.totalEpsLowWarning !== "undefined") && (typeof json.totalEpsHighWarning !== "undefined")) {
				g_iTotalEpsLowWarning = json.totalEpsLowWarning;
				g_iTotalEpsHighWarning = json.totalEpsHighWarning;
			}
		}
		if(mode === 0)
			getSmartServerDevicesInfo();
	}
	catch {}
	
}
function getSmartServerSettingsCallbackFailure(mode, requestUrlString, json) {
	//checkForLoginCookie();
	try {
		if(mode === 0)
			getSmartServerDevicesInfo();
	}
	catch {}
	
}
function getSmartServerStorageInfo() {
	var url = "https://" + location.hostname + "/iap/storage";
	
	requestGetData(0, url, getSmartServerStorageInfoCallback, null); // paginagion does't work on device list get Device list
}
function getSmartServerStorageInfoCallback(mode, requestUrlString, json) {
	//checkForLoginCookie();
	try {
		var paneTitle = "", paneContent = "";
		var i, iPtr;
		var deviceName = "", deviceType = "";
		g_fDatalogSize = 0;
		if(json === null)
			return;
		if(typeof json.dataLogSize !== "undefined") {
			g_fDatalogSize = json.dataLogSize;
			if(g_iMaxDataLogMBSizeSupported !== -1) {
				if(g_fDatalogSize > g_iMaxDataLogMBSizeSupported) {
					g_bMaxDataLogSizeNotReached = false;
				}
			}

			
		}
		return;

		if(g_iMainDisplayMode !== DISPLAYMODE_DPINFO)
			return;
		

		
		if(json.hasOwnProperty("storageInfo")) {
			if(json.storageInfo.hasOwnProperty("internal")) {
				if(json.storageInfo.internal.hasOwnProperty("avail") && json.storageInfo.internal.hasOwnProperty("total") && json.storageInfo.internal.hasOwnProperty("used")) {
					paneContent = "Internal Flash Memory:<br><span class=\"storageSpan\">Total Memory = " + json.storageInfo.internal.total;
					paneContent += " MB</span><br><span class=\"storageSpan\">Memory In Use = " + json.storageInfo.internal.used;
					paneContent += " MB</span><br><span class=\"storageSpan\">Available Memory = " + json.storageInfo.internal.avail + " MB</span>";
				}
				else {
					paneContent += "internal Flash Memory: Can't Read value";
				}
				
			}
			if(json.storageInfo.hasOwnProperty("external")) {
				if(json.storageInfo.external.hasOwnProperty("avail") && json.storageInfo.external.hasOwnProperty("total") && json.storageInfo.external.hasOwnProperty("used")) {
					paneContent += "<br><br>SD-Card Memory:<br><span class=\"storageSpan\">Total Memory = " + json.storageInfo.external.total;
					paneContent += " MB</span><br><span class=\"storageSpan\">Memory In Use = " + json.storageInfo.external.used;
					paneContent += " MB</span><br><span class=\"storageSpan\">Available Memory = " + json.storageInfo.external.avail + " MB</span>";
				}
				else {
					paneContent += "<br><br>SD-Card Memory: Can't Read value";
				}
			}
		}
		else {
			paneContent = "StorageInfo: Can't Read values";
		}
		if(json.hasOwnProperty("dataLogSize")) {
			paneContent += "<br><br>Data log Size: " + json.dataLogSize + " MB";
		}
		if(json.hasOwnProperty("eventLogSize")) {
			paneContent += "<br><br>Event log Size: " + json.eventLogSize + " MB";
		}
		g_sDpInfoPaneContent = paneContent; 
		document.getElementById("main").innerHTML = paneContent;
	}
	catch {}
	
}


function getSmartServerVersion() {
	var url = "https://" + location.hostname + "/iap/version";
	
	requestGetData(0, url, getSmartServerVersionCallback, null); // paginagion does't work on device list get Device list
}
function getSmartServerVersionCallback(mode, requestUrlString, json) {
		//checkForLoginCookie();
	var versionList;
	var sidebarContent = "";
	try { // only process once - add tags to datapoints
		//navtree remove document.getElementById("cmsValue").innerHTML += json.type.charAt(0).toUpperCase() + json.type.slice(1).toLowerCase() + " " + json.value;
		g_sSmartServerVersion = json.value;
		versionList = g_sSmartServerVersion.split(".")
		g_iSmartServerVersion = (Number(versionList[0]) * 100000) + (Number(versionList[1]) * 1000) + Number(versionList[2]); 
		getSmartServerImmMode();
		
		// remove getActiveAlarmsCount();
		
	}
	catch (err) {}
		
}
function getUserType() {
	var url = "https://" + location.hostname + "/iap/users/current";
	
	requestGetData(0, url, getUserTypeCallback, getUserTypeFailCallback); 
}
function getUserTypeCallback(mode, requestUrlString, json) {
	
	try { 
		if(json !== null) {
			g_currentUserType = json.userType;
			g_currentUser = json.userName;
			g_customerId = json.customerId;
			if(g_currentUser === "apollo")
				g_currentUserType = ADMIN;
			g_bShowDeviceTestButton = checkIfUserTypeSupported(g_iShowDeviceTestButton);
		}
		
	}
	catch (err) {}
	
}
function getUserTypeFailCallback(mode, requestUrlString, json) {
	
	try { 
		
	}
	catch (err) {}
}
function getSmartServerImmMode() {
	var url = "https://" + location.hostname + "/iap/devs/lonmode";
	
	requestGetData(0, url, getSmartServerImmModeCallback, null); // paginagion does't work on device list get Device list
}
function getSmartServerImmModeCallback(mode, requestUrlString, json) {
		//checkForLoginCookie();
	var versionList;
	var sidebarContent = "";
	try { // only process once - add tags to datapoints
		// navtree remove document.getElementById("cmsValue").innerHTML += " [" + json.value + "]";
		if(bivUseWebSockets) {
			if(typeof ivWebSocketInit !== "undefined") {
				ivWebSocketInit();  // needed to make sure at least first REST request was successful
			}
		}
		
		if(!g_bSingleUserType)
			getUserType();
		
		if(g_iSmartServerVersion > 350000) {
			if(g_bShowEps && g_bShowEpsWarningColors) {
				getSmartServerSettings1(0);
			}
			else
				getSmartServerDevicesInfo()
		}
		else
			getSmartServerDevicesInfo()
	}
	catch (err) {}
		
}
function getSmartServerDevicesInfo() {
	try {
		if(g_iSmartServerVersion >= 280000) { 
			
			getDeviceListOnlyDontDisplay();
			//showPlanningTree();
		}
		else
			showDeviceList(0);
	}
	catch {}
}
function getSnvtType(mode, snvtTypeName) {
	// mode: mode.mode, mode.this, mode.index, mode.pathname, mode.displayMode;
	try {
		var i, bAtLeastOnemore = false;
		var url = "https://" + location.hostname + "/iap/dp/types?dpTypeName=" + snvtTypeName;
		requestGetData(mode, url, getSnvtTypeResponse, getSnvtTypeFailResponse);
		 
	}
	catch(err) {

	}
}
function getSnvtTypeResponse(mode, requestUrlString, json) {
	try {
		
		var i, j, z;
		for(i=0; i < json.length; i++)
		{
			z = -1;
			for(j=0; j < g_snvtTypes.length; j++)
			{
				if(g_snvtTypes[j].typeId === json[i].typeId) {
					z = j;
					break;
				}
			}
			if(z === -1) {
				g_snvtTypes.push(JSON.parse(JSON.stringify(json[i])));
			}
		}
		if(mode !== "") { // dropdown
			if(typeof mode === "object") {
				
				getDpPriorityforMenuDpValue(mode);
				//menuDpValue2(mode.mode, mode.this, mode.index, mode.pathname);
				
			}
		}
	}
	catch(err) {

	}
	
}
function getSnvtTypeFailResponse(mode, requestUrlString, json) {
	// mode: mode.mode, mode.this, mode.index, mode.pathname, mode.displayMode;
	try {
		if(mode !== "") { // dropdown
			if(typeof mode === "object") {
				if(typeof mode.displayMode !== "undefined") {
					if(mode.displayMode === g_iMainDisplayMode) {
						getDpPriorityforMenuDpValue(mode);
					}
				}
			}
		}
	}
	catch (err) {}
}
function getAllSnvtType(mode) {
	// mode: mode.mode, mode.this, mode.index, mode.pathname, mode.displayMode;
	try {
		var i, bAtLeastOnemore = false;
		var url = "https://" + location.hostname + "/iap/dp/types?dpTypeName=" + snvtTypeName;
		requestGetData(mode, url, getAllSnvtTypeResponse, getAllSnvtTypeFailResponse);
		 
	}
	catch(err) {

	}
}
function getAllSnvtTypeResponse(mode, requestUrlString, json) {
	try {
		
		var i, j, z;
		for(i=0; i < json.length; i++)
		{
			z = -1;
			for(j=0; j < g_snvtTypes.length; j++)
			{
				if(g_snvtTypes[j].typeId === json[i].typeId) {
					z = j;
					break;
				}
			}
			if(z === -1) {
				g_snvtTypes.push(JSON.parse(JSON.stringify(json[i])));
			}
		}
		if(mode !== "") { // dropdown
			if(typeof mode === "object") {
				
				getDpPriorityforMenuDpValue(mode);
				//menuDpValue2(mode.mode, mode.this, mode.index, mode.pathname);
				
			}
		}
	}
	catch(err) {

	}
	
}
function getAllSnvtTypeFailResponse(mode, requestUrlString, json) {
	// mode: mode.mode, mode.this, mode.index, mode.pathname, mode.displayMode;
	try {
		g_snvtTypes = JSON.parse(JSON.stringify(json));
	}
	catch (err) {}
}
function getDpPriorityforMenuDpValue(mode) {
	// mode: mode.mode, mode.this, mode.index, mode.pathname, mode.displayMode;
	var pathname;
	var url = "https://" + location.hostname + "/iap/devs/*+name==";
	pathname = mode.programmaticPathname;
	pathname = encodePathString(pathname);
	pathname = addIfandXifnameToPathname(1, pathname);
	url += pathname + "/*";
	requestGetData(mode, url, getDpPriorityforMenuDpValueResponse, getDpPriorityforMenuDpValueFailResponse);
}
function getDpPriorityforMenuDpValueResponse(mode, requestUrlString, json) {
	// mode: mode.mode, mode.this, mode.index, mode.pathname, mode.displayMode;
	var bContinue = false, index, pathname;
	try {
		if(json.length !== 0) {
			if(mode !== "") { // dropdown
				if(typeof mode === "object") {
					index = mode.index;
					if(index < dashboardDpList.length) {
						if(dashboardDpList[index].programmaticPathname === mode.programmaticPathname) {
							if(typeof json[0].values !== "undefined") {
								dashboardDpList[index].values = json[0].values;
								dashboardDpList[index].priority = json[0].values.level;
								if(dashboardDpList[index].value === "") {
									dashboardDpList[index].value = json[0].value;
									//dashboardDpList[index].valueStr = json[0].valueStr;
									dashboardDpList[index].locValue = json[0].locValue;
									//dashboardDpList[index].locValueStr = json[0].locValueStr;
									dashboardDpList[index].presetValue = json[0].presetValue;
								}
							}
							menuDpValueSetup(mode.mode, mode.index, mode.displayElementIndex, mode.displayId, mode.programmaticPathname);
							//menuDpValueSetup(mode.mode, mode.this, mode.index, mode.displayElementIndex, mode.displayId, mode.programmaticPathname);
						}
					}
				}
			}
		}
		else {
			// add error in 
		}
	}
	catch (err) {}

}
function getDpPriorityforMenuDpValueFailResponse(mode, requestUrlString, json) {
	// mode: mode.mode, mode.this, mode.index, mode.pathname, mode.displayMode;
	
	if(mode !== "") { // dropdown
		if(typeof mode === "object") {
			if(typeof mode.displayMode !== "undefined") {
				if(mode.displayMode === g_iMainDisplayMode) { 
				
					menuDpValue2(mode.mode, mode.this, mode.index, mode.displayElementIndex, mode.displayId, mode.programmaticPathname);
				}
			}
		}
	}
}
function gobacktoHomePage() {
	var cmsStr =  "https://" + window.location.hostname;
	window.open(cmsStr,'_self',false);
}

function inputBoxOnFocus(n, index, displayElementIndex, pathname){

	g_IgnoreTableValueChangeFor = index; //url1;
	g_IgnoreTableValueChangeForCurrentValue = n.value;
}
function inputBoxLostFocus(n, e, index, displayElementIndex, pathname){
	// check if old and new values changed
	if(g_IgnoreTableValueChangeForCurrentValue !== n.value) {
		//inputBoxValueChanged(n, index, pathname, n.value);

	}
		
}
function inputBoxChanged(n, index, displayElementIndex, pathname)
{
		//document.getElementById("resultstext").value += "\r\n" + n.value
		g_IgnoreTableValueChangeFor = index;
		
}
	
function inputBoxKey(n, e, index, displayElementIndex, pathname)
{
		//alert("onKey");
	var evtobj=window.event? event : e; // distiguish between IE explicit event an Firefox implicit
	var unicode = evtobj.char? evtobj.charCode : evtobj.keyCode;
	var actualkey=String.fromCharCode(unicode);
		//alert("key [" + unicode + "]: " + actualkey);
	if(unicode === 27) // esc
	{
		g_IgnoreTableValueChangeFor = " ";
		g_IgnoreTableValueChangeForCurrentValue = " ";
		n.blur();
	}
	else if (unicode === 13)
	{
		n.blur();
		if(g_IgnoreTableValueChangeForCurrentValue !== n.value) {
			inputBoxValueChanged(n, index, displayElementIndex, pathname, n.value);
		}
	}
	else
		g_IgnoreTableValueChangeFor = index;
}
function inputBoxSelectChanged(n, index, displayElementIndex)
{
	
  		try{
			//if(!ivDisplayObjs[index].objectReadOnly) {
				//Inputobj.value = n.value;
				inputBoxValueChanged(n, index, displayElementIndex, pathname, n.value);
			//}
			n.blur();
       		} catch(err) {}		
	
}
function inputBoxValueChanged(n, index, displayElementIndex, displayId, value) {
	// ffix need to add field support
	try {
		var objs = null;
		var i,j, z = -1;
		var tempStr, newValue = {};
		var char;
		var value1;
		var priority = null;
		var checkList = [{char:"{", count: 0}, {char:"}", count: 0}, {char:"[", count: 0}, {char:"]", count: 0}, {char:"\"", count: 0}];
		if(value === null)
			return;
		if (value === "")
			return;
		inputBoxSendValue1(2, null, null, index, displayElementIndex, displayId);
		return;
		/* remove
		objs = dashboardDpList;
		value = value.trim(); // remove beginning and trailing spaces
		bContinue = false;
		// check input 
		for(i=0; i < value.length; i++)
		{
			char = value.charAt(i);
			for(j=0; j < checkList.length; j++)
			{
				if(checkList[j].char === char) {
					checkList[j].count ++;
					break;
				}
			}
		}
		tempStr = "";
		if(checkList[0].count !== checkList[1].count)
			tempStr = "\r\n\"{\" and \"}\" counts don't match";
		if(checkList[2].count !== checkList[3].count) 
			tempStr += "\r\n\"[\" and \"]\" counts don't match";
		if((checkList[3].count % 2) !== 0)
			tempStr += "\r\n\"there are an old number of doublequoates ' \" ''";

		if (tempStr !== "") {
			tempStr = "Error: Invalid Input\r\n\r\n" + tempStr + "\r\n\r\nPlease fix and try again";
			alert()
			return;
		}
		z = -1;
		if(objs[index].displayElements[displayElementIndex].displayId !== displayId) {
			for(i=0; i < objs.length; i++)
			{  // find datapoint
				for(j=0; j < objs.length; j++)
				{  // find datapoint
					if(objs[index].displayElements[displayElementIndex].displayId === displayId) {
						index = i;
						displayElementIndex = j;
						z = i;
						break;
					}
				}
			}
			if(z === -1)
				return;
		}
		if(dashboardDpList[index].displayElements[displayElementIndex].dashboardType === "s3") {
			if(typeof value === "string")
				value = Number(value);
			if(isNaN(value)) {
				alert("Error: " + value + " is not a number (only numbers allowed)");
				return;
			}
			if((value < 0) && (value > 100)) {
				alert("Error: " + value + " is not a valid number (only 0 thru 100 allowed)");
				return;
			}
		}
			// check if using field or full datapoint value
		if((typeof objs[index].value) === "number")
			objs[index].displayElements[displayElementIndex].value = Number(value);
		else
			objs[index].displayElements[displayElementIndex].value = JSON.parse(value);
					//  fixxxxxx  Determine preset value
		// add feedback
		objs[index].feedbackDelay = true;
		var currentTime = new Date().getTime();
		objs[index].feedbackDelayTimeout = currentTime + g_iFeedbackDelayTime; // ms  10000 = 10 s
		objs[index].feedbackDelayOldValue = JSON.parse(JSON.stringify(objs[index].locValue));
		

		
		newValue = objs[index].value;
		if(objs[index].displayElements[displayElementIndex].dashboardType === "s3")  {
			newValue.value = value;
			objs[index].value = newValue;
			value = JSON.stringify(newValue);
			objs[index].valueStr = value;	
		}
		else {
			if(objs[index].displayElements[displayElementIndex].field === "")	
				value1 = objs[index].value;
			else {
			// get 
			value1 = objs[index].displayElements[displayElementIndex].value;
			}
			objs[index].valueStr = value;		
			// check if using field or full datapoint value
			if((typeof objs[index].value) === "number")
				objs[index].value = Number(value);
			else if(objs[index].bString)
				objs[index].value = "\"" + value + "\"";
			else
				objs[index].value = JSON.parse(value);
		}
		
		
			
		
		
		//if(objs[index].displayElements[displayElementIndex].dashboardType === "s3")  {
			priority = document.getElementById("priority_" + displayId)
			if(priority !== null)
				priority = priority.value;
		//}
		
		url = "/iap/devs/*+name=="; //iot
		url += objs[index].urlPath.replace(/ /g,"%20").replace(/:/g,"%3A").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
		if(priority !== null)
			url += "/overrides/" + priority;
		url += "/value";
		objs[index].updateDpValue = true; // sync up value, localValue and Preset
		writeDpValue(1,url,value, null, writeFailCallback);
		
		*/
		
	} catch (err) {}
}
function inputBoxSendValue(n, event, index, displayElementIndex, pathname) {
	inputBoxSendValue1(0, n, event, index, displayElementIndex, pathname);
}
function inputBoxSendValue1(mode, n, event, index, displayElementIndex, displayId) {
	//mode: 0=normal, 1=used for dashboard, 2=planning
	try {
		var value = null, value1, state, errorStr;
		var currentTime;
		var objs = null;
		var i,j, z = -1;
		var tempStr;
		var char;
		var valueStr;
		var priority = null, priorityValue;
		var bContinue, bContinue1;
		var urlPath;
		var element;
		var checkList = [{char:"{", count: 0}, {char:"}", count: 0}, {char:"[", count: 0}, {char:"]", count: 0}, {char:"\"", count: 0}];
		var bUseLocalValue = g_bUseLocalizationForAllWrites;
		if((mode === 1) || (mode === 2))
			value = document.getElementById("localValue_" + displayId).value;
		else 
			value = document.getElementById("newValue_" + displayId).value;
		if(value === null)
			return;
		if (value === "")
			return;
		
		objs = dashboardDpList;
		priorityValue = document.getElementById("priority_" + displayId);
		if(priorityValue !== null)
			priority = priorityValue.value;
		
		value = value.trim(); // remove beginning and trailing spaces
		bContinue = false;
		if(index >= objs.length)
			return;
		if(displayElementIndex >= objs[index].displayElements.length)
			return;
		if(objs[index].displayElements[displayElementIndex].displayId !== displayId) {
			z = -1;
			for(i=0; i < objs.length; i++)
			{  // find datapoint
				for(j=0; j < objs[i].displayElement.length; j++)
				{
					if(objs[index].displayElement[j].displayId === displayId) {
						index = i;
						displayElementIndex = j;
						z = i;
						i = objs.length + 2;
						break;
					}
				}
			}
			if(z === -1)
				return;
		}
		bContinue1 = true;
		if(typeof objs[index].displayElements[displayElementIndex].dashboardType !== "undefined") {
			if(objs[index].displayElements[displayElementIndex].dashboardType === "s3"){
				// this is value now add state
				element = document.getElementById("localValueSwitch_" +displayId)
				if(element !== null) {
					state = 0;
					if(element.checked)
						state = 1;
					value = Number(value);
					value = {"value": value, "state": state};
					value = JSON.stringify(value);
					bContinue1 = false;
				}
				else {
					showAlertDialog(0,"Can't process input data");
					return;
				}
			}
		}
		if(bContinue1) {
			if(objs[index].displayElements[displayElementIndex].field !== "") {
				if(objs[index].displayElements[displayElementIndex].bNumber)
					value = Number(value);
				value = changeFieldValue(objs[index].locValue, objs[index].displayElements[displayElementIndex].field, value);
				if(value.valid) 
					value = JSON.stringify(value.data);
				else  {
					showAlertDialog(0,"Can't process input data");
					return;
				}
			}
			// check if preset
			char = value.charAt(0);
			if((char !== "{") && (char !== "[")) {
				if(objs[index].presets !== null) {
					if(typeof objs[index].presets !== "undefined") { // needed for internal apps
						if(objs[index].presets.enabled) {
							if(objs[index].presets.map.length > 0) {
								for(i=0; i < objs[index].presets.map.length; i++)
								{
									if(value === objs[index].presets.map[i].name) {
										objs[index].presetValue = objs[index].presets.map[i].name;
										objs[index].value = ""; //objs[index].presets.map[i].value;
										/*
										valueStr = objs[index].value;
										if(!(typeof valueStr === "number"))
											valueStr = JSON.stringify(objs[index].value);
											*/
										// add feedback
										objs[index].feedbackDelay = true;
										var currentTime = new Date().getTime();
										objs[index].feedbackDelayTimeout = currentTime + g_iFeedbackDelayTime; // ms  10000 = 10 s
										objs[index].feedbackDelayOldValue = JSON.parse(JSON.stringify(objs[index].presets.map[i].value));
										if(bUseLocalValue) {
											objs[index].locValue = objs[index].presets.map[i].value;
											objs[index].locValueStr = JSON.stringify(objs[index].value);
											objs[index].value = "";
											objs[index].valueStr = "";
										}
										else {
											objs[index].locValue = "";
											objs[index].locValueStr = "";
											objs[index].value = objs[index].presets.map[i].value;
											objs[index].valueStr = JSON.stringify(objs[index].value);
										}

										if(mode ===1) {

										}
										else if(g_bUsePriorityForAllWrites) {
											if(g_bUsePriority17ForNewValue)
												priority = 17;
											else 
												priority = objs[index].priority;
										}
										if((g_iMainDisplayMode === DISPLAYMODE_DPS) || (g_iMainDisplayMode === DISPLAYMODE_FAVDPS)){
											
											document.getElementById("currentValue_" + objs[index].pathname).innerHTML = "";
											document.getElementById("localValue_" + objs[index].pathname).innerHTML = "";
											document.getElementById("presetValue_"+ objs[index].pathname).innerHTML = objs[index].presetValue;
											
										}
										else if((g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) || (g_iMainDisplayMode === DISPLAYMODE_PLANNING)) {
											document.getElementById("localValue_" + objs[index].pathname).innerHTML = objs[index].presetValue;
										}
										urlPath = encodePathString(objs[index].urlPath);
										sendPresetValue(value, urlPath, true, priority);
										objs[index].updateDpValue = true; // sync up value, localValue and Preset on next read
										if(!g_bPollingEnabled) {
											g_sUpdateDataPoint = urlPath; //pathName;
											g_iUpdateDataPointCount = 0;
										}
										return;  
									}
								}
							}
						}
					}
				}
			}
		
			// No presets or not listed in presets - check input - make sure same number of {}, [], ""
			for(i=0; i < value.length; i++)
			{
				char = value.charAt(i);
				for(j=0; j < checkList.length; j++)
				{
					if(checkList[j].char === char) {
						checkList[j].count ++;
						break;
					}
				}
			}
			tempStr = "";
			if(checkList[0].count !== checkList[1].count)
				tempStr = "\r\n\"{\" and \"}\" counts don't match";
			if(checkList[2].count !== checkList[3].count) 
				tempStr += "\r\n\"[\" and \"]\" counts don't match";
			if((checkList[3].count % 2) !== 0)
				tempStr += "\r\n\"there are an old number of doublequoates ' \" ''";

			if (tempStr !== "") {
				tempStr = "Error: Invalid Input\r\n\r\n" + tempStr + "\r\n\r\nPlease fix and try again";
				showAlertDialog(0,tempStr);
				return;
			}
		}
		pathname = objs[index].pathname;
		
		i = index;
		value1 = objs[index].value;
		
		// check if s3


			// add feedback
		objs[index].feedbackDelay = true;
		currentTime = new Date().getTime();
		objs[index].feedbackDelayTimeout = currentTime + g_iFeedbackDelayTime; // ms  10000 = 10 s
		objs[index].feedbackDelayOldValue = JSON.parse(JSON.stringify(objs[index].locValue));
		
					// check if using field or full datapoint value
		if(objs[index].displayElements[displayElementIndex].field !== "") {
			//TBD
		}
		objs[index].locValueStr = value;
		if((typeof objs[index].value) === "number")
			objs[index].locValue = Number(value);
		else
			objs[index].locValue = JSON.parse(value);
		objs[index].value = "";
		objs[index].valueStr = "";
		
		
		objs[i].presetValue = "";
		//  fixxxxxx  Determine preset value
		z = index;
		
		
		if(z !== -1) {
			urlPath = objs[index].urlPath.replace(/ /g,"%20").replace(/:/g,"%3A").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
			
			url = "/iap/devs/*+name==" + urlPath;
			if(g_bUsePriorityForAllWrites) {
				if(mode === 1)
					url += "/overrides/" + priority;
				else if(g_bUsePriority17ForNewValue)
					url += "/overrides/17";
				else if(typeof objs[index].priority !== "undefined")
					url += "/overrides/" + objs[index].priority;
				else
					url += "/overrides/17";
			}
			url += "/localization/value";
			

			
			writeDpValue(1,url,value, null, writeFailCallback);
			objs[z].updateDpValue = true; // sync up value, localValue and Preset on next read
			document.getElementById("localValue_" + objs[index].displayElements[displayElementIndex].displayId).innerHTML = objs[index].locValueStr;
			
		}
	} catch (err) {
		errorStr = err;
	}
}
function sendPresetValue(preset, pathname, bUsePriority17Setting, priority) {
	// mode:0=allow all priorities, 1=follow g_bUsePriority17ForNewValue
	var mode = 1;
	try {
		var url = "https://" + location.hostname + "/iap/devs/*+name==";
		pathname = addIfToPathname(pathname);
		url += pathname;
		if(g_bUsePriorityForAllWrites) {
					
			if((bUsePriority17Setting && g_bUsePriority17ForNewValue) || (priority === null))
				url += "/overrides/17";
			else 
				url += "/overrides/" + priority;
		}
		url +=  "/presets/value";
		if(g_bUsePriorityForAllWrites) 
			mode = 422;
		writeDpValue(mode,url,preset, null, writeFailCallback); // preset name
		// requestGetData(preset, url, inputBoxSendValueGetPresetIdResponse, null); // get Device list  no longer needed
	}
	catch {}
	
}
function inputBoxSendValueGetPresetIdResponse(preset, requestUrlString, json) {
	try {
		var presets = null;
		var id,j;
		var url = requestUrlString + "/value";
		if(json === null)
			return;
		presets = json[0].presets;
		if(presets !== null) {

			for(j=0; j < presets.length; j++)
			{
				if(presets[j].name === preset) {
					id = presets[j].id;
					//url = "/iap/dp/*+name==" + objs[index].urlPath + "/presets/value"; //iot
					writeDpValue(1,url,id, null, writeFailCallback);
					break;
				}
			}
		}
			
		
	}
	catch {}
}
function isNotEqual (obj1, obj2) {
	return !isEqual(obj1, obj2);
}
function isEqual(obj1, obj2) {
	try {
		var newObj1, newObj2;
		var i, len1, len2;
		var objKeys;
		var key;
		if(obj1 === null) {
			if(obj2 === null)
				return true;
			else 
				return false;
		}
		else if(obj2 === null)
			return false;
		
		if(typeof obj1 !== typeof obj2)
			return false;
		if(Array.isArray(obj1)) {
			if(obj1.length !== obj2.length)
				return false; 
			for(i = 0; i < obj1.length; i ++)
			{
				
				if(!isEqual(obj1[i], obj2[i]))
					return false;
			}
			return true;
		}
		else if (typeof obj1 === "object") {
			len1 = Object.keys(obj1).length;
			len2 = Object.keys(obj2).length;
			if(len1 !== len2)
				return false; 
			for(i = 0; i < len1; i ++)
			{
				key = Object.keys(obj1)[i];
				if(obj2.hasOwnProperty(key)) {
					if(!isEqual(obj1[key], obj2[key]))
						return false; 
				}
				else 
					return false;
			}
			return true;
		}
		else if(obj1 === obj2)
			return true;
		else 
			return false;
	}
	catch { return false; }
}
function jsonToHtmlTableStr(mode, json) {
	var result = "";
	var obj;
	try {
		if(mode === 1)
			result += "<table><tr><th>Property</th><th>Value</th></tr>";
		for (x in json)
		{
			result += "<tr><td>" + x + "</td><td>" + json[x] + "</td></tr>"; 
		}
		
	}
	catch {}
	if(mode === 1)
			result += "</table>";
	return result;
}
function logout() {
	var url = "https://" + location.host + "/iap/auth/logout";
	var Rsp = requestPostFunction(0, url, "",  null, null); 
	url = "https://" + location.host + "/user/login.html?next=" + document.URL;
	window.open(url,'_self',false);
}
function menuCancel() {
	var url;
	var iPtr;
	try {
		//document.getElementById("menuDiv").style.width= "150px";
		document.getElementById("menuDiv").className = "menuDivHide";
		document.getElementById("menuDiv").innerHTML = "";
		document.getElementById("menuOverlayDiv").className = "menuOverlayDivHide";
		try {
			document.removeEventListener("click", menuMouseCancel);
		}
		catch {}
		if(g_sDpNeedUpdating !== "") {
			//g_sDpNeedUpdating llllllllll
			url = "https://" + location.hostname + "/iap/devs/";
			iPtr = g_sDpNeedUpdating.indexOf("/");
			if(iPtr > 0) { 
				url += "*+name==" + g_sDpNeedUpdating.substr(0, iPtr) + "/if" + g_sDpNeedUpdating.substr(iPtr) + "/*";
				requestGetData(1, url, getOnDemandDpValuesResponse, readFailCallback); // update priority information 
			}
		}
	}
	catch (err) 
	{
		var errStr = err; 
	}
}
function menuCloseAll() {
	menuCloseAll1(0);
}
function menuCloseAll1(mode) {
	if(mode === 0) {
		g_bScheduleEventInProgress = false;
		g_editButtonElementList = [];
		g_sContextContent = "";
		menuScheduleDivClose();
		planningMenuCancel();
		menuDivClose();
		menuCalendarDivClose();
		menuStructuredDpDialogCancel();
		testDeviceCancel();
		menuScheduleCreateDivClose();
		chartZoomClose();
	}
}
function numToFixedLength(num, maxLength, maxDecimalPlaces, bMaxValue){
	// used for charts
	// bMaxValue: round up max value for positive, round down for negative number
	var numOrig = num;
    var numStr = num.toString();
    var len,decimalPlaces, add
    
    try {
		if(numStr.toLowerCase().indexOf("e") > 0) {
			// exponent
		}
		else {
			len = numStr.length;
			if(len > maxLength) {
				iPtr = numStr.indexOf(".");
				if(iPtr !== -1) {
					if(iPtr < maxLength) {
						decimalPlaces = maxLength - iPtr - 1;
						if(maxDecimalPlaces !== -1) {
							if(decimalPlaces > maxDecimalPlaces) {
								decimalPlaces = maxDecimalPlaces
							}
						}
						add = 5 * Math.pow(10, - (decimalPlaces + 1));
						if(bMaxValue) {
							num += add;
						}
						else
							num -= add;
						
						num = Number(num.toFixed(decimalPlaces));
						
					}
					else {
						num = Number(num.toFixed(0));
					}
				}
			}
			else {
				if(maxDecimalPlaces !== -1) {
					decimalPlaces = maxDecimalPlaces;
					add = 5 * Math.pow(10, - (maxDecimalPlaces + 1));
					if(num >= 0) {
						iPtr = numStr.indexOf(".");
						if(iPtr !== -1) {
							if(num > 1) {
								
								if(bMaxValue) {
									num += add;
								}
								else
									num -= add;
								num = Number(num.toFixed(decimalPlaces));
							}
						}
					}
					else {
						iPtr = numStr.indexOf(".");
						if(iPtr !== -1) {
							if(bMaxValue) {
								//num += add;
								num += add;
							}
							else {
								num -= add;
							}
							num = Number(num.toFixed(decimalPlaces));
						}
					}
				}
			}
		}
    }
    catch {num = numOrig}
    return num;
}
function planningMenuCancel() {
	var url;
	var iPtr;
	try {
		g_bScheduleEventInProgress = false;
		document.getElementById("planningDiv").className = "menuDivHide";
		document.getElementById("planningOverlayDiv").className = "menuOverlayDivHide";
		document.removeEventListener("click", planningMenuMouseCancel);
	}
	catch (err) 
	{
		var errStr = err; 
	}
}
function menuCmsDpFavorites() {
	try {
		if(g_bReadCmsFavoritesList) {
			g_bReadCmsFavoritesList = false;
			showAllDpsGetFavoriteDps(3);
		}
		else {
			if(cmsFavoritesList.length > 0) 
				menuCmsDpFavoritesShow(0);
			else 
				showAllDpsGetFavoriteDps(3);  
		}
	}
	catch {}
}
function menuCmsDpFavoritesRefresh(mode) {

}

function menuCmsDpFavoritesShow(mode) {
	// mode: 0=create, 1=refresh
	try {
		
		var x = 0;
		var y = 0;
		var i;
		var d;

		var menuContent ="<div class=\"menuDivName\" style=\"margin-bottom: 70px;\">CMS Favorites</div>";
		g_bAlwaysIngnoreMouseClick = false;
		g_menuDivXOffset = 35;
		g_menuDivYOffset = 30;
		g_menuDivWidth = 350;
		menuContent += "<div style=\"float:right\"><input type=\"checkbox\" id=\"menuCmsKeepOpen\">Keep Open <button  style=\"float:right\" onclick=\"showAllDpsGetFavoriteDps(6)\">Refresh</button><br><br><table>";
		menuContent += "<br><br>" + favDpList.length + " datapoints " + "<input id=\"newFavoriteName\" class=\"menuDivCmsInput\">";
		menuContent += "<button onclick=\"menuCmsSaveDpToFavorites()\">Save</button><br><br><br>Existing Favorites<br><br>";
		menuContent += "<div id=\"cmsFavoritesTableDiv\">";
		if(mode === 1) {
			menuContent = "";

		}
		if(cmsFavoritesList.length > 0) {
			menuContent += "<table>";
			for(i=0; i < cmsFavoritesList.length; i ++)
			{
				d = new Date(cmsFavoritesList[i].lastAccessTime);

				menuContent += "<tr><td><div>" + cmsFavoritesList[i].name + "<br>" + d.toLocaleString();
				menuContent += "  [" + cmsFavoritesList[i].currentDatapointQualifiers.length + " DPs]</div></td>";
				menuContent += "<td><button  onclick=\"menuCmsGetFavoriteDps(0, " + cmsFavoritesList[i].id + ", '" + cmsFavoritesList[i].name + "')\">Get</button></td>";
				menuContent += "<td><button  onclick=\"menuCmsGetFavoriteDps(6, " + cmsFavoritesList[i].id + ", '" + cmsFavoritesList[i].name + "')\">Append</button></td>";
			}
			menuContent += "</table>";
		}
		else {
			menuContent += "<br>No Favorites currently defined in CMS<br>";
		}
		menuContent += "</div>";
		if(mode === 1) {
			document.getElementById("cmsFavoritesTableDiv").innerHTML = menuContent;
			return;
		}

		menuContent += "<br><br>";
		menuContent += "<button  onclick=\"menuDivClose()\" style=\"float:right\">Close</button><br><br>";
		var menuButton = document.getElementById("favsButton");
		var offsets;
		
		if(menuButton !== null) {
			offsets = menuButton.getBoundingClientRect(); 
			if((offsets.x + offsets.width + window.pageXOffset + g_menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
				x = offsets.x + window.pageXOffset - g_menuDivWidth - 10; // takes into account viewport (scrolling)
			else
				x = offsets.x + offsets.width + window.pageXOffset + g_menuDivXOffset; // takes into account viewport (scrolling)
			y = offsets.y + window.pageYOffset - g_menuDivYOffset; // takes into account viewport (scrolling)
			document.getElementById("menuDiv").style.left = x.toString() + "px";
			document.getElementById("menuDiv").style.top = y.toString() + "px";
			document.getElementById("menuDiv").innerHTML = menuContent;
			document.getElementById("menuDiv").className = "menuDivCmsShow"; // doesn't currently guaranty that menu is shown in viewport
			g_bInoreMouseClick = true;
			document.addEventListener("click", menuMouseCancel);
			
			try {
				if(g_timerId === 0)
					g_timerId = window.setInterval("timerHandler()", g_iTimerInterval);
			} catch (err) {} 
			
		}

	} catch {}
}
function menuCmsGetFavoriteDps(mode, favoriteId, favName) {
	// mode: 0=replace existing fav list, 1=append to
	var i, j;
	var payload, dps, url;
	if(mode === 0)
		favDpList = [];
	for(i=0; i < cmsFavoritesList.length; i++)
	{
		if(cmsFavoritesList[i].id === favoriteId) {
			if(cmsFavoritesList[i].name === favName) {
				
				dps = cmsFavoritesList[i].currentDatapointQualifiers;
				for(j=0; j < dps.length; j ++)
				{
					if(payload !== "")
						payload += ",";
					payload += encodeUriString(dps[j]);
				}
				if(!document.getElementById("menuCmsKeepOpen").checked)
					menuCancel();
				if(payload !== "") {
					// do on demand request to build up favList
					

					//payload = payload.replace(/\//g,"%2F");
					//payload = payload.replace(/\"/g,"");
					//payload = payload.replace(/\[/g,"%5B");
					//payload = payload.replace(/\]/g,"%5D");
					url = "https://" + location.hostname + "/iap/devs/*/if/*/*/*+qualifier=-" + payload + "/*?noxs=true";
					requestGetData(mode, url, showAllDpsGetFavoriteDpsPropertiesCallback, readFailCallback);
				}

				
				break;
			}
		}
	}
}
function menuCmsSaveDpToFavorites() {
	try {
		var newFavoriteName = document.getElementById("newFavoriteName").value;
		if(newFavoriteName !== "") {
			showAllDpsSaveFavoriteDpsWrite(newFavoriteName);
			showAllDpsGetFavoriteDps(6);
		}
		else {
			showAlertDialog(0,"Favorite Name can't be blank");
		}
	}
	catch {}
	
}
function menuMouseCancel() {
	try {
		if(g_bInoreMouseClick || g_bAlwaysIngnoreMouseClick)
			return;
		var event = window.event;
		var x = event.clientX;
		var y = event.clientY;
		var offsets = document.getElementById("menuDiv").getBoundingClientRect();
		if(x < offsets.left)
			menuCancel();
		if(x > offsets.right)
			menuCancel();
		if(y < offsets.top)
			menuCancel();
		if(y > offsets.bottom)
			menuCancel();
		if((x < offsets.left) || (x > offsets.right) || (y < offsets.top) || (y > offsets.bottom))
			menuCancel();
	} catch {}
}function menuDashboardSave(event) {
	try {
		
		var x = 0;
		var y = 0;

		var menuContent ="<div class=\"menuDivName\" style=\"text-align:center\">Dashboard Save</div><br><br>";
		g_bAlwaysIngnoreMouseClick = false;
		g_menuDivXOffset = -200;
		g_menuDivYOffset = -10;
		g_menuDivWidth = 200;
		
		menuContent += "<button class=\"menuDivButton\" onclick=\"dashboardSaveData(0)\">Save Current Values</button><br>";
		menuContent += "<button class=\"menuDivButton\" onclick=\"dashboardSaveData(1)\">Save Current + Chart</button><br>";
		menuContent += "<br><button  onclick=\"menuDivClose()\" class=\"menuDivButton\">Close</button><br><br>";

		var menuButton = document.getElementById("dashboardSaveButton");
		var offsets;
		
		if(menuButton !== null) {
			offsets = menuButton.getBoundingClientRect(); 
			if((offsets.x + offsets.width + window.pageXOffset + g_menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
				x = offsets.x + window.pageXOffset - g_menuDivWidth - 10; // takes into account viewport (scrolling)
			else
				x = offsets.x + offsets.width + window.pageXOffset + g_menuDivXOffset; // takes into account viewport (scrolling)
			y = offsets.y + window.pageYOffset - g_menuDivYOffset; // takes into account viewport (scrolling)
			document.getElementById("menuDiv").style.left = x.toString() + "px";
			document.getElementById("menuDiv").style.top = y.toString() + "px";
			document.getElementById("menuDiv").innerHTML = menuContent;
			document.getElementById("menuDiv").className = "menuDashboardSaveDivShow"; // doesn't currently guaranty that menu is shown in viewport
			g_bInoreMouseClick = true;
			document.addEventListener("click", menuMouseCancel);
			
		}

	} catch {}
}
function menuDevice(mode, event, id, pathname, deviceTypeName, protocol) {
	try {
		
		var x = 0;
		var y = 0;
		

		var menuContent ="<div class=\"menuDivDpShowContent\"><div class=\"menuDivDpShowContent\"><div class=\"menuDivName\">" + pathname + "</div>";
		g_bAlwaysIngnoreMouseClick = false;
		g_menuDivXOffset = 35;
		g_menuDivYOffset = 30;
		g_menuDivWidth = 300;
		menuContent += "<span id=\"menuDivType\" style=\"display:none\">deviceMenu_" + pathname + "</span><br><br>";
		menuContent += "<button class=\"menuDivButton\" onclick=\"showDashboard(1, '" + pathname + "', " + id + ")\">Show Dashboard</button>";
		menuContent += "<button class=\"menuDivButton\" id=\"dp_deviceId_" + pathname + "\" onclick=\"showDeviceDpsByDeviceName(0,'" + pathname + "')\">Show Datapoints</button><br>";
		menuContent += "<button class=\"menuDivButton\" onclick=\"showDataLogForDevice('" + pathname + "','" + pathname + "',null)\">Show Data logs</button>";
		menuContent += "<button class=\"menuDivButton\" onclick=\"showSchedulesByName('" + pathname + "','" + pathname + "')\">Show Schedules</button><br>";
		menuContent += "<button class=\"menuDivButton\" onclick=\"showDeviceByName(0, '" + pathname + "')\">Show Device Details</button>"; //xxxxxxxx
		menuContent += "<button class=\"menuDivButton\" onclick=\"showDpInfo1(1,'" + pathname + "','')\">Show DP Info</button><br>";
		menuContent += "<button class=\"menuDivButton\" onclick=\"testDevice(" + mode + ", this," + id + ", '" + pathname + "')\">Test</button>";
		menuContent += "<button class=\"menuDivButton\" onclick=\"winkDevice(" + id + ", '" + pathname + "')\"";
		if(protocol !== "lon")
			menuContent += " disabled";
		menuContent += ">Wink</button><br>";
		menuContent += "<button class=\"menuDivButton\" onclick=\"showDla(1, '" + deviceTypeName + "')\">Datapoint Properties</button>";
		menuContent += "<button  onclick=\"menuDivClose()\" class=\"menuDivButton\">Close</button></div>";
		menuContent += "</div>";
		var menuButton = document.getElementById("deviceMenu_" + pathname);
		var offsets;
		
		if(menuButton !== null) {
			offsets = menuButton.getBoundingClientRect(); 
			if((offsets.x + offsets.width + window.pageXOffset + g_menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
				x = offsets.x + window.pageXOffset - g_menuDivWidth - 10; // takes into account viewport (scrolling)
			else
				x = offsets.x + offsets.width + window.pageXOffset + g_menuDivXOffset; // takes into account viewport (scrolling)
			y = offsets.y + window.pageYOffset - g_menuDivYOffset; // takes into account viewport (scrolling)
			document.getElementById("menuDiv").style.left = x.toString() + "px";
			document.getElementById("menuDiv").style.top = y.toString() + "px";
			document.getElementById("menuDiv").innerHTML = menuContent;
			document.getElementById("menuDiv").className = "menuDivDpShow"; // doesn't currently guaranty that menu is shown in viewport
			g_bInoreMouseClick = true;
			document.addEventListener("click", menuMouseCancel);
			try {
				if(g_timerId === 0)
					g_timerId = window.setInterval("timerHandler()", g_iTimerInterval);
			} catch (err) {} 
		}

	} catch {}
}
function menuDeviceSmartServer(mode, event, id, pathname) {
	try {
		
		var x = 0;
		var y = 0;

		var menuContent ="<div class=\"menuDivDpShowContent\"><div class=\"menuDivName\">" + pathname + "</div>";
		g_bAlwaysIngnoreMouseClick = false;
		g_menuDivXOffset = 35;
		g_menuDivYOffset = 30;
		g_menuDivWidth = 150;
		menuContent += "<span id=\"menuDivType\" style=\"display:none\">deviceMenu_" + pathname + "</span><br><br>";
		menuContent += "<button class=\"menuDivButton\" onclick=\"showSmartServerStorage(1, '" + pathname + "', " + id + ")\">Show Storage</button><br>";
		menuContent += "<br><button  onclick=\"menuDivClose()\" class=\"menuDivButton\">Close</button><br><br></div>";

		var menuButton = document.getElementById("deviceMenu_" + pathname);
		var offsets;
		
		if(menuButton !== null) {
			offsets = menuButton.getBoundingClientRect(); 
			if((offsets.x + offsets.width + window.pageXOffset + g_menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
				x = offsets.x + window.pageXOffset - g_menuDivWidth - 10; // takes into account viewport (scrolling)
			else
				x = offsets.x + offsets.width + window.pageXOffset + g_menuDivXOffset; // takes into account viewport (scrolling)
			y = offsets.y + window.pageYOffset - g_menuDivYOffset; // takes into account viewport (scrolling)
			document.getElementById("menuDiv").style.left = x.toString() + "px";
			document.getElementById("menuDiv").style.top = y.toString() + "px";
			document.getElementById("menuDiv").innerHTML = menuContent;
			document.getElementById("menuDiv").className = "menuDivDpShow"; // doesn't currently guaranty that menu is shown in viewport
			g_bInoreMouseClick = true;
			document.addEventListener("click", menuMouseCancel);
			try {
				if(g_timerId === 0)
					g_timerId = window.setInterval("timerHandler()", g_iTimerInterval);
			} catch (err) {} 
		}

	} catch {}
} 
function menuDeviceFloorplan(mode, event, id, pathname, deviceTypeName, protocol) {
	try {
		
		var x = 0;
		var y = 0;

		var menuContent ="<div class=\"menuDivName\">" + pathname + "</div>";

		//navtree
		document.getElementById("planningDiv").className = "testDivHide";
		getPlanningTreeShowDashboard(10, "", pathname);
		return;


		g_bAlwaysIngnoreMouseClick = false;
		g_menuDivXOffset = 35;
		g_menuDivYOffset = 30;
		g_menuDivWidth = 150;
		menuContent += "<span id=\"menuDivType\" style=\"display:none\">deviceMenu_" + pathname + "</span><br>";
		if(deviceTypeName === "undefined") {
			menuContent += "Segment Controller:<br><br>"
			menuContent += "<button class=\"menuDivPlanningButton\" onclick=\"showDeviceByName(0, '')\">Show Devices</button><br><br>";
		}
		else {
			menuContent += "<button class=\"menuDivPlanningButton\" onclick=\"showDashboard(1, '" + pathname + "', " + id + ")\">Dashboard</button>";
			menuContent += "<button class=\"menuDivPlanningButton\" id=\"dp_deviceId_" + pathname + "\" onclick=\"showDeviceDpsByDeviceName(0,'" + pathname + "')\">Datapoints</button><br>";
			menuContent += "<button class=\"menuDivPlanningButton\" onclick=\"showDataLogForDevice('" + pathname + "','" + pathname + "',null)\">Data logs</button>";
			menuContent += "<button class=\"menuDivPlanningButton\" onclick=\"showSchedulesByName('" + pathname + "','" + pathname + "')\">Schedules</button><br>";
			menuContent += "<button class=\"menuDivPlanningButton\" onclick=\"showDeviceByName(0, '" + pathname + "')\">Device Details</button>"; //xxxxxxxx
			menuContent += "<button class=\"menuDivPlanningButton\" onclick=\"showDpInfo1(1,'" + pathname + "','')\">DP Info</button><br>";
			menuContent += "<button class=\"menuDivPlanningButton\" onclick=\"testDevice(" + mode + ", this," + id + ", '" + pathname + "')\">Test</button>";
			menuContent += "<button class=\"menuDivPlanningButton\" onclick=\"winkDevice(" + id + ", '" + pathname + "')\"";
			if(protocol !== "lon")
				menuContent += " disabled"
			menuContent += ">Wink</button><br>";
			menuContent += "<button class=\"menuDivPlanningButton\" onclick=\"showDla(1, '" + deviceTypeName + "')\">Datapoint Properties</button>";
		}
		menuContent += "<button  onclick=\"menuDivClose()\" class=\"menuDivPlanningButton\">Close</button><br><br>";

		var menuButton = document.getElementById("deviceMenu_" + pathname);
		var offsets;
		
		if(menuButton !== null) {
			offsets = menuButton.getBoundingClientRect(); 
			if((offsets.x + offsets.width + window.pageXOffset + g_menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
				x = offsets.x + window.pageXOffset - g_menuDivWidth - 10; // takes into account viewport (scrolling)
			else
				x = offsets.x + offsets.width + window.pageXOffset + g_menuDivXOffset; // takes into account viewport (scrolling)
			y = offsets.y + window.pageYOffset - g_menuDivYOffset; // takes into account viewport (scrolling)
			document.getElementById("menuDiv").style.left = x.toString() + "px";
			document.getElementById("menuDiv").style.top = y.toString() + "px";
			document.getElementById("menuDiv").innerHTML = menuContent;
			document.getElementById("menuDiv").className = "menuDivDpFloorplanShow"; // doesn't currently guaranty that menu is shown in viewport
			g_bInoreMouseClick = true;
			document.addEventListener("click", menuMouseCancel);
			try {
				if(g_timerId === 0)
					g_timerId = window.setInterval("timerHandler()", g_iTimerInterval);
			} catch (err) {} 
		}

	} catch {}
}
function menuDeviceType(mode, event, id, pathname) {
	try { 
		
		var x = 0;
		var y = 0;
		var menuContent ="<div class=\"menuDivDpShowContent\"><div class=\"menuDivName\">" + pathname + "</div>";
		g_bAlwaysIngnoreMouseClick = false;
		g_menuDivXOffset = 35;
		g_menuDivYOffset = 30;
		g_menuDivWidth = 150;
		menuContent += "<span id=\"menuDivType\" style=\"display:none\">deviceMenu_" + pathname + "</span><br><br>";
		menuContent += "<button class=\"menuDivButton\" onclick=\"showDeviceTypeDevices('" + pathname + "')\">Show Devices</button>";
		menuContent += "<button class=\"menuDivButton\" onclick=\"showDla(3, '" + pathname + "')\">Datapoint Properties</button><br>";
		
		menuContent += "<br><button  onclick=\"menuDivClose()\" class=\"menuDivButton\">Close</button><br><br></div>";
		var menuButton = document.getElementById("deviceTypeMenu_" + pathname);
		var offsets;
		
		if(menuButton !== null) {
			offsets = menuButton.getBoundingClientRect(); 
			if((offsets.x + offsets.width + window.pageXOffset + g_menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
				x = offsets.x + window.pageXOffset - g_menuDivWidth - 10; // takes into account viewport (scrolling)
			else
				x = offsets.x + offsets.width + window.pageXOffset + g_menuDivXOffset; // takes into account viewport (scrolling)
			y = offsets.y + window.pageYOffset - g_menuDivYOffset; // takes into account viewport (scrolling)
			document.getElementById("menuDiv").style.left = x.toString() + "px";
			document.getElementById("menuDiv").style.top = y.toString() + "px";
			document.getElementById("menuDiv").innerHTML = menuContent;
			document.getElementById("menuDiv").className = "menuDivDpShow"; // doesn't currently guaranty that menu is shown in viewport
			g_bInoreMouseClick = true;
			document.addEventListener("click", menuMouseCancel);
			
		}

	} catch {}
}

function menuDla(mode, event, deviceType, pathname) {
	menuDla1(mode, event, deviceType, pathname, "");
}
function menuDla1(mode, event, deviceType, pathname, xifPathStr) {
	// mode: 0=relative, 1 = fixed, 4= same as 1 but with datapoint list and use id for 
	try { 
		
		var x = 0, iPtr;
		var y = 0;
		var displayElement = ""; 
		var menuContent ="<div class=\"menuDivDpShowContent\"><div class=\"menuDivName\">" + pathname + "</div>";
		displayName = pathname;
		if(mode === 4) {
			iPtr = deviceType.indexOf(",");
			if(iPtr > 0) {
				displayElement = deviceType.substr(iPtr + 1);
				deviceType = deviceType.substr(0, iPtr);
				menuContent ="<div class=\"menuDivDpShowContent\"><div class=\"menuDivName\">" + deviceType + "</div>";
			}
			else
				menuContent ="<div class=\"menuDivDpShowContent\"><div class=\"menuDivName\">" + pathname + "</div>";
		}
		else 
			menuContent ="<div class=\"menuDivDpShowContent\"><div class=\"menuDivName\">" + pathname + "</div>";
			
		g_bAlwaysIngnoreMouseClick = false;
		g_menuDivXOffset = 35;
		g_menuDivYOffset = 30;
		g_menuDivWidth = 300; //150;
		menuContent += "<span id=\"menuDivType\" style=\"display:none\">deviceMenu_" + pathname + "</span><br><br>";
		if(mode === 5) {
			menuContent += "<button class=\"menuDivPlanningButton\" onclick=\"addToFavDps_getDpInfoForFixedDp('" + pathname + "')\">Add To Fav DPs</button>";
		}
		else {
			menuContent += "<button class=\"menuDivPlanningButton\" onclick=\"addToFavDps_getDpInfo(";
			if(mode === 0)
				menuContent += "false,'" + deviceType + "','" + pathname + "')\">Add To Fav DPs</button>";
			else if(mode === 4)
				menuContent += "true,'" + deviceType + "','" + xifPathStr + "')\">Add To Fav DPs</button>";
			else
				menuContent += "true,'" + deviceType + "','" + pathname + "')\">Add To Fav DPs</button>";
		}
		

		if(mode === 1)
			menuContent += "<button class=\menuDivPlanningButton\" onclick=\"showDataLog3('" + deviceType + "/" + pathname + "','',null)\">Logs</button><br>"; //77777
		else if((mode === 4) || (mode === 5))
			menuContent += "<button class=\"menuDivPlanningButton\" onclick=\"showDataLog4('" + pathname + "','',null)\">Logs</button><br>"; //77777
		else 
			menuContent += "<button class=\"menuDivPlanningButton\" onclick=\"showDataLogGetDpsFromDeviceType(false,'" + deviceType + "','" + pathname + "')\">Logs</button><br>";
		
		
		menuContent += "<br><button  onclick=\"menuDivClose()\" class=\"menuDivButton\">Close</button><br><br></div>";
		var menuButton = null;
		var offsets;
		if(mode === 0)
			menuButton = document.getElementById("dpDlaMenu_" + deviceType + "/" + pathname);
		else if(mode === 4)
			menuButton = document.getElementById("dpDlaMenu_" + displayElement);
		else if(mode === 5)
			menuButton = document.getElementById("dpDlaMenu_" + deviceType);
		else
			menuButton = document.getElementById("dpDlaMenu_fixed_" + deviceType + "/" + pathname);
		
		if(menuButton !== null) {
			offsets = menuButton.getBoundingClientRect(); 
			if((offsets.x + offsets.width + window.pageXOffset + g_menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
				x = offsets.x + window.pageXOffset - g_menuDivWidth - 10; // takes into account viewport (scrolling)
			else
				x = offsets.x + offsets.width + window.pageXOffset + g_menuDivXOffset; // takes into account viewport (scrolling)
			y = offsets.y + window.pageYOffset - g_menuDivYOffset; // takes into account viewport (scrolling)
			document.getElementById("menuDiv").style.left = x.toString() + "px";
			document.getElementById("menuDiv").style.top = y.toString() + "px";
			document.getElementById("menuDiv").innerHTML = menuContent;
			document.getElementById("menuDiv").className = "menuDivDpShow"; // doesn't currently guaranty that menu is shown in viewport
			document.getElementById("menuDiv").style.width = "310px";
			g_bInoreMouseClick = true;
			document.addEventListener("click", menuMouseCancel);
			
		}

	} catch {}
}

function menuDlaFilter(mode) {
	try { 
		//var event1 = window.event;
		var x = 0; // = event.clientX;
		var y = 0;// = event.clientY;
		var filter = "";
		var menuContent = "Datapoint Filter";
		var offsets;
		var menuDivWidth;
		
		g_bAlwaysIngnoreMouseClick = false;
		g_menuDivXOffset = 30;
		g_menuDivYOffset = 20;
		
		menuContent += "<br><br><table>";
		menuContent += "<tr></tr><tr><td>Configured</td><td><select id=\"menuDlaFilterConfigured\" class=\"tdValueFilter\">";
		menuContent += "<option value=\"configured\">Configured</option><option value=\"unconfigured\">Unconfigured</option><option value=\"all\">All</option>";
		menuContent += "</select></td><td><button onclick=\"clearDlaFilter(" + mode + ", 10, 1)\">X</button></td></tr>";
		//menuContent += "<tr><td>SmartServer</td><td><span id=\"menuDlaFilterSmartServer\" class=\"tdValueFilter\"></span></td><td><button onclick=\"clearDlaFilter(" + mode + ", 1, 1)\">X</button></td></tr>";
		menuContent += "<tr><td>Protocol</td><td><input id=\"menuDlaFilterProtocol\" class=\"tdValueFilter\"></td><td><button onclick=\"clearDlaFilter(" + mode + ", 2, 1)\" >X</button></td></tr>";
		menuContent += "<tr></tr><tr><td>DP Override</td><td><select id=\"menuDlaFilterOverride\" class=\"tdValueFilter\">";
			menuContent += "<option value=\"\">None</option><option value=\"active\">Active</option><option value=\"notactive\">Not Active</option>";
			menuContent += "</select></td><td><button onclick=\"clearDlaFilter(" + mode + ", 8, 1)\">X</button></td></tr>";
			menuContent += "<tr><td>DP Priority (1 - 16)</td><td><input id=\"menuDlaFilterPriority\" class=\"tdValueFilter\"></td><td><button onclick=\"clearDlaFilter(" + mode + ", 9, 1)\">X</button></td></tr>";
		
		menuContent += "<tr><td>Device Type</td><td><input id=\"menuDlaFilterDeviceType\" class=\"tdValueFilter\"></td><td><button onclick=\"clearDlaFilter(" + mode + ", 3, 1)\">X</button></td></tr>";
		menuContent += "<tr><td>Device</td><td><input id=\"menuDlaFilterDevice\" class=\"tdValueFilter\"></td><td><button onclick=\"clearDlaFilter(" + mode + ", 4, 1)\">X</button></td></tr>";
		
			menuContent += "<tr><td>Block Name</td><td><input id=\"menuDlaFilterBlockName\" class=\"tdValueFilter\"></td><td><button onclick=\"clearDlaFilter(" + mode + ", 5, 1)\">X</button></td></tr>";
			menuContent += "<tr><td>Block Index</td><td><input id=\"menuDlaFilterBlockIndex\" class=\"tdValueFilter\"></td><td><button onclick=\"clearDlaFilter(" + mode + ", 6, 1)\">X</button></td></tr>";
			menuContent += "<tr><td>Datapoint</td><td><input id=\"menuDlaFilterDatapoint\" class=\"tdValueFilter\"></td><td><button onclick=\"clearDlaFilter(" + mode + ", 7, 1)\">X</button></td></tr>";

			

		
		menuContent += "</table><br><br>";
		menuContent += "<button  onclick=\"clearDlaFilter(" + mode + ", 0, 1)\">Clear Filter</button>";
		menuContent += "<button  onclick=\"menuDlaFilterShowDps()\">Get Datapoints</button>";
		//menuContent += "<button class=\"menuDivButton\" onclick=\"menuDlaFilterShowDps('" + filter + "')\">Clear</button>";
		menuContent += "<button  onclick=\"menuDivClose()\" style=\"float:right\">Close</button><br><br>";
		
		var menuButton = document.getElementById("menuDlaFilterButton");
		
		
		if(menuButton !== null) {
			offsets = menuButton.getBoundingClientRect(); 
			document.getElementById("menuDiv").innerHTML = menuContent;


			
			
			// datapoint
			//document.getElementById("menuDlaFilterSmartServer").innerHTML = g_oDlaFilter.smartserver;
			document.getElementById("menuDlaFilterConfigured").value = g_oDlaDpFilter.configured;
			document.getElementById("menuDlaFilterProtocol").value = g_oDlaDpFilter.protocol;
			document.getElementById("menuDlaFilterDeviceType").value = g_oDlaDpFilter.deviceType;
			document.getElementById("menuDlaFilterDevice").value = g_oDlaDpFilter.device;
			document.getElementById("menuDlaFilterBlockName").value = g_oDlaDpFilter.blockName;
			document.getElementById("menuDlaFilterBlockIndex").value = g_oDlaDpFilter.blockIndex;
			document.getElementById("menuDlaFilterDatapoint").value = g_oDlaDpFilter.datapointName;
			document.getElementById("menuDlaFilterOverride").value = g_oDlaDpFilter.override; 
			document.getElementById("menuDlaFilterPriority").value = g_oDlaDpFilter.priority;
			
			document.getElementById("menuDiv").className = "menuDivDpValueShow";  // doesn't currently guaranty that menu is shown in viewport

			menuDivWidth = document.getElementById("menuDiv").offsetWidth;
			x = offsets.x;
			x = x / 2;
			if(x < 200)
				x = 200;
			/*
			if((offsets.x + offsets.width + window.pageXOffset + menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
				x = offsets.x + window.pageXOffset - menuDivWidth - 10; // takes into account viewport (scrolling)
			else
				x = offsets.x + offsets.width + window.pageXOffset + g_menuDivXOffset; // takes into account viewport (scrolling)
			*/
			y = offsets.y + window.pageYOffset - g_menuDivYOffset; // takes into account viewport (scrolling)
			document.getElementById("menuDiv").style.left = x.toString() + "px";
			document.getElementById("menuDiv").style.top = y.toString() + "px";
			
			

			g_bInoreMouseClick = true;
			//document.addEventListener("click", menuMouseCancel);
			//document.addEventListener("click", function() {menuMouseCancel(event);});
			
		}
	} catch {}
}

function menuDlaFilterShowDps() {
	try {
		var bContinue = true;
		var paneContent = "";
		g_oDlaDpFilter.configured = document.getElementById("menuDlaFilterConfigured").value; 
		g_oDlaDpFilter.smartServer = ""; //document.getElementById("menuDlaFilterSmartServer").innerHTML.trim();
		g_oDlaDpFilter.protocol = document.getElementById("menuDlaFilterProtocol").value.trim();
		g_oDlaDpFilter.deviceType = document.getElementById("menuDlaFilterDeviceType").value.trim();
		g_oDlaDpFilter.device = document.getElementById("menuDlaFilterDevice").value.trim();
		g_oDlaDpFilter.blockName = document.getElementById("menuDlaFilterBlockName").value.trim();
		g_oDlaDpFilter.blockIndex = document.getElementById("menuDlaFilterBlockIndex").value.trim();
		g_oDlaDpFilter.datapointName = document.getElementById("menuDlaFilterDatapoint").value.trim();
		g_oDlaDpFilter.override = document.getElementById("menuDlaFilterOverride").value; 
		g_oDlaDpFilter.priority = document.getElementById("menuDlaFilterPriority").value.trim();
		g_sDlaDpFilter = "";
		if(g_oDlaDpFilter.smartServer !== "") {
			g_sDlaDpFilter += "*+scName=~" + g_oDlaDpFilter.smartServer.replace(/ /g,"%20");
		}
		if(g_oDlaDpFilter.protocol !== "") {
			if(g_sDlaDpFilter === "")
				g_sDlaDpFilter += "*+";
			else 
				g_sDlaDpFilter += "&";
			g_sDlaDpFilter += "protocol=~" + g_oDlaDpFilter.protocol;
		}
		if(g_oDlaDpFilter.deviceType !== "") {
			if(g_sDlaDpFilter === "")
				g_sDlaDpFilter += "*+";
			else 
				g_sDlaDpFilter += "&";
			if(g_oDlaDpFilter.deviceType.charAt(0) === "=")
				g_sDlaDpFilter += "typeName==" + g_oDlaDpFilter.deviceType.substr(1).replace(/ /g,"%20");
			else 
				g_sDlaDpFilter += "typeName=~" + g_oDlaDpFilter.deviceType.replace(/ /g,"%20");
		}
		if(g_oDlaDpFilter.device !== "") {
			if(g_sDlaDpFilter === "")
				g_sDlaDpFilter += "*+";
			else 
				g_sDlaDpFilter += "&";
			if(g_oDlaDpFilter.device.charAt(0) === "=")
				g_sDlaDpFilter += "name==" + g_oDlaDpFilter.device.substr(1).replace(/ /g,"%20");
			else 
				g_sDlaDpFilter += "name=~" + g_oDlaDpFilter.device.replace(/ /g,"%20");
		}
		if(g_sDlaDpFilter === "")
			g_sDlaDpFilter += "*+status==PROVISIONED/if";
		else 
			g_sDlaDpFilter += "&status==PROVISIONED/if";
		if(g_oDlaDpFilter.blockName !== "") {
			if(g_oDlaDpFilter.blockName.charAt(0) === "=")
				g_sDlaDpFilter += "/*+name==" + g_oDlaDpFilter.blockName.substr(1).replace(/ /g,"%20");
			else 
				g_sDlaDpFilter += "/*+name=~" + g_oDlaDpFilter.blockName.replace(/ /g,"%20");
		}
		else 
			g_sDlaDpFilter += "/*"
		if(g_oDlaDpFilter.blockIndex !== "") {
			g_sDlaDpFilter += "/*+name==" + g_oDlaDpFilter.blockIndex;
		}
		else 
			g_sDlaDpFilter += "/*"
		if(g_oDlaDpFilter.datapointName !== "") {
			if(g_oDlaDpFilter.datapointName.charAt(0) === "=")
				g_sDlaDpFilter += "/*+name==" + g_oDlaDpFilter.datapointName.replace(/ /g,"%20").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
			else
				g_sDlaDpFilter += "/*+name=~" + g_oDlaDpFilter.datapointName.replace(/ /g,"%20").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
		}
		else 
			g_sDlaDpFilter += "/*"

		menuDivClose();
		url = "https://" + location.hostname + "/iap/devs/" + g_sDlaDpFilter;
		if((g_oDlaDpFilter.override === "active") || (g_oDlaDpFilter.override === "inactive")) {
			if(g_oDlaDpFilter.override === "active")
				url += "/level!=17&value!=%7B%7D&values!=%7B%7D?noxs=truepg1&sz=100";
			else 
				url += "/level==17&value!=%7B%7D&values!=%7B%7D?noxs=truepg1&sz=100";
		}
		else {
			if (g_oDlaDpFilter.priority !== "") {
				if(typeof g_oDlaDpFilter.priority === "number") {
					priority = Number(g_oDlaDpFilter.priority);
					if((priority > 0) && (priority < 17))
					url += "/level==" + priority  + "&value!=%7B%7D&values!=%7B%7D?noxs=truepg1&sz=100";
					else {
						showAlertDialog(0,"Priority is not blank or number between 1 throudh 16");
						return;
					}
				}
				else {
					showAlertDialog(0,"Priority is not blank or number between 1 throudh 16");
					return;
				}
			}
			if(bContinue)
				url += "/*?noxs=true?pg1&sz=100";
		}
		
		paneContent = "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting Datapoint Properties (DLA) Info ...</span></div>";
		document.getElementById("main").innerHTML = paneContent;
		dpList = [];
		//https://10.0.0.33/iap/devTypes/*/if/*/*/*+name=~tempset/dla?includeUnconfigured=false&pg=1&sz=25
		requestGetData(0, url, getOnDemandDpValuesResponse, readFailCallback);
	}
	catch {}
}



function menuDpShow(mode) {
	var temp = "Show Input Structure";
	if(mode === 0)
		temp = "Show Output Structure";
	showAlertDialog(0,temp);
}
function menuDpPlanningShowStructuredDp(mode,n, index, displayElementIndex, programmaticPathname) {
	var displayId = "";
	try {
		if(dashboardDpList[index].programmaticPathname === programmaticPathname) {
			displayId = "localValue_" + dashboardDpList[index].displayElements[displayElementIndex].displayId;
			if(displayId === n.id) {
				menuStructuredDpDialog(mode, n, index, displayElementIndex, programmaticPathname, "");
			}
		}

	}
	catch {}
}
function notSupportedYet() {
	showAlertDialog(0,"This Feature is not Supported yet");
}
function readFailCallback () {

}

function pollCheckBox() {
	var displayModeStr = document.getElementById("displayLabel").innerText;
	var pollRate = document.getElementById("pollrate");
	var min;
	if(g_idpGetRequestIndex === -1)
		return;
	if(g_dpGetRequestArr[0] === "") 
		return;
	if(pollRate === null)
		return;
	pollRate = pollRate.value;
	if(pollRate === "") {
		showAlertDialog(0,"Error: Invalid poll rate value please enter a number (2 or greater)\r\n\r\n" + pollRate);
		return;
	}
	if(isNaN(pollRate)) {
		showAlertDialog(0,"Error: Invalid poll rate value please enter a number (2 or greater)\r\n\r\n" + pollRate);
		return;
	}
	if(g_iMainDisplayMode === DISPLAYMODE_FAVDPS) {
		g_bFavoritesPollingEnabled = document.getElementById("pollCheckbox").checked;
		g_iFavoritesPollInterval = document.getElementById("pollrate").value;
	}
	else if(g_iMainDisplayMode === DISPLAYMODE_DPS) {
		g_bDatapointsPollingEnabled = document.getElementById("pollCheckbox").checked;
		g_iDatapointsPollInterval = document.getElementById("pollrate").value;
	}
	
	if(((g_iMainDisplayMode === DISPLAYMODE_DPS) && (dpList.length > 0)) || ((g_iMainDisplayMode === DISPLAYMODE_FAVDPS)  && (favDpList.length > 0))) { 
		if(document.getElementById("pollCheckbox").checked) {
			pollRate  = Number(pollRate );
			if(isNaN(pollRate ))
				return;
			g_iPollRate = pollRate;
			g_iPollingRequestCountMax = pollRate;
			if(g_iMainDisplayMode === DISPLAYMODE_DPS){
				min = Math.ceil(dpList.length / g_iMaxOfDpsToPollPerInterval);
				if(pollRate < (min * g_iBackgroundPollingRequestCountMax)) 
					g_iPollingRequestCountMax = min + 1;
				g_PollingType = g_iMainDisplayMode;
			} 
			else if(g_iMainDisplayMode === DISPLAYMODE_FAVDPS){
				min = Math.ceil(favDpList.length / g_iMaxOfDpsToPollPerInterval);
				if(pollRate < (min * g_iBackgroundPollingRequestCountMax)) 
					g_iPollingRequestCountMax = min + 1;
			} 
			g_PollingType = g_iMainDisplayMode;
			if(g_sWebSocketSubscribePayload !== g_sWebSocketSubscribePayload_oldvalue)
				subscribeRequest();
			g_iBackgroundPollingRequestCount = g_iBackgroundPollingRequestCountMax + 12; //start request
			g_idpGetRequestIndex = 0;
			g_bPollingEnabled = true;
			try {
				// ivGetDeviceList(); // IOT get device list later
				if(g_timerId !== 0)
					clearInterval(g_timerId);
				g_timerId = window.setInterval("timerHandler()", g_iTimerInterval);
			} catch (err) {} 
		}
		else 
			g_bPollingEnabled = false;
	}
}
function processWebSocketDpData (mode, type, requestUrlString, json) {
	// Web sockets only
	var iPtr;
	var d = new Date;
	var currentTimeMs = d.getTime();
	var t = d.toTimeString();
	var date = d.toLocaleDateString();
	//var dates = date.split("/");
	//var currentTime = dates[2] + "-" + dates[1].padStart(2,"0") + "-" +  dates[0].padStart(2,"0") + " ";
	//var currentTime1 = dates[2] + "-" + dates[1].padStart(2,"0") + "-" +  dates[0].padStart(2,"0") + "T";
	var currentTime = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0);
	var currentTime1 = currentTime + "T";
	var utcTime = d.toUTCString();
	currentTime += " ";
	iPtr = t.indexOf(" ");
	t = t.substr(0, iPtr);
	currentTime += t + ".000";
	currentTime1 += t + ".000Z[UTC]";

	if(g_bUseWebSockets)
		dashboardProcessWebSocketDpData(currentTime, d.getTime(), json);
	

}
function refresh(sType) {
	try {
		var i;
		var payload, url;
		if(sType === "devices") {
			deviceTypeList = [];
			deviceList = [];
			deviceListAll = [];
			showDeviceList(3);
			
		}
		else if(sType === "devicesAllInfo") {
			deviceTypeList = [];
			deviceList = [];
			deviceListAll = [];
			showDeviceList(2);
		}
		else if (sType === "devicefilter") {
			if(deviceList !== null){
				deviceTypeList = [];
				deviceList = [];
				showDeviceList(14);
				

/*				for(i=0; i < deviceList.length; i++)
				{
					if(i > 0)
						payload += ",";
					payload = deviceList[i].id;
				}
				showDevicesList(6); ///tttttttt
				url = "/iap/devs/listByIDs";

				*/
			}
		}
	} catch {}
}

function removeIfFromPathname(pathname) {
	try {
		var iPtr = pathname.indexOf("/if");
		if(iPtr > 0) {
			pathname = pathname.substr(0, iPtr) + pathname.substr(iPtr + 3);
		}
	}
	catch {}
	return pathname;
}
function removeSpacesInPathname(pathname, str) {
	var newPathname = "";
	var pathnameList = [];
	try {
		pathnameList = pathname.split(str);
		for(i=0; i < pathnameList.length; i++)
		{
			pathnameList[i] = pathnameList[i].trim();
			if(i > 0)
				newPathname += str;
			newPathname += pathnameList[i];
		}
		pathname = newPathname;
	}
	catch {}
	return pathname;
}
function saveData(mode, type) {
	saveData1(mode, type, -1, "", "")
}
function saveData1(mode, type, index, pathname, label) {
	try {
		// type:0=chartData
		var i, j, z, d, iPtr, sTemp,obj, table, cols, len, time,date;
		var tempStr = "", temp, temp1 = "", objList = [];
		var sFilename = "";
		var d = new Date();
		var currentDate = d.toLocaleDateString().replace(/\./,"_").replace(/\//,"_");
		//var currentDate = d.getFullYear().toString() + "-" + (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0);//dateItems[2] + "-" + dateItems[0] + "-" +dateItems[1];
		var currentTimestamp = currentDate + "_" + d.toTimeString().substr(0,8);
		if(type === 0) {
			if((g_dashboardChartList.length > 0) && (dashboardDpList.length > 0) && (index !== -1)) {
				if(index < g_dashboardChartList.length){
					if(g_dashboardChartList[index].pathname === pathname) {
						tempStr = "Local Time,UTC Time,Preset,Value";
						if(label !== "")
							sFilename += label + "__";
						sFilename += pathname;
						sFilename = "Datalog_" + sFilename + ".csv";
						for(i = 0; i < g_dashboardChartList[index].data.length; i++)
						{
							d = new Date(g_dashboardChartList[index].data[i].timestamp);
							temp = d.toLocaleString().replace(/\,/g," ");
							temp = " " + temp; // used to get Excell to know this is a timestamp
							tempStr += "\r\n" + temp + "," + d.toUTCString().replace(/\,/g," ") + ",";
							if(typeof g_dashboardChartList[index].data[i].presetValue !== "undefined")
								tempStr += g_dashboardChartList[index].data[i].presetValue;
							tempStr += ","
							if(typeof g_dashboardChartList[index].data[i].value === "object") {
								tempStr += "\"" + JSON.stringify(dataLogList[i].locValue).replace(/\"/g,"\"\"") + "\"";
							}
							else if(typeof g_dashboardChartList[index].data[i].value === "string") {
								temp = JSON.stringify(g_dashboardChartList[index].data[i].value);
								if(temp.indexOf(","))
									temp = "\"" + JSON.stringify(g_dashboardChartList[index].data[i].value).replace(/\"/g,"\"\"") + "\"";
							}
							else
								tempStr += g_dashboardChartList[index].data[i].value;
						}
					}
				}
			}
			else {
				showAlertDialog(0,"No data available");
			}
		}

/*		
		if(g_iMainDisplayMode === DISPLAYMODE_DATALOG) {
			tempStr = "Local Time,UTC Time,Device Name,Block,Datapoint,Preset,Local Value,Value,Delta Value,Delta Time,DP Path";
			sFilename = document.getElementById("datalogDuration").innerHTML;
			sFilename = sFilename.replace(/ thru /g, "__").replace(/:/g, "_").replace(/\./g,"_");
			iPtr = sFilename.indexOf(" [");
			if(iPtr > 0)
				sFilename = sFilename.substr(0, iPtr);

			temp1 = document.getElementById("dataLogDpUrl").value;
			iPtr = temp1.lastIndexOf("/");
			try {
				if(iPtr > 0)
					temp1 = temp1.substr(iPtr + 1);
			}
			catch {
				temp1 = document.getElementById("dataLogDpUrl").value;
			}
			temp1 = temp1.replace(/ /g, "_");
			sFilename = "Datalog_" + temp1 + "_" + sFilename + ".csv";
			for(i = 0; i < dataLogList.length; i++)
			{
				temp = dataLogList[i].local.replace(/ /g,"_");
				tempStr += "\r\n" + temp + "," + dataLogList[i].utc + "," + dataLogList[i].deviceName;
				tempStr += "," + dataLogList[i].block + "," + dataLogList[i].dpName + "," + dataLogList[i].presetValue + ",";
				if(typeof dataLogList[i].locValue === "object") {
					tempStr += "\"" + JSON.stringify(dataLogList[i].locValue).replace(/\"/g,"\"\"") + "\"";
				}
				else if(typeof dataLogList[i].locValue === "string") {
					temp = JSON.stringify(dataLogList[i].locValue);
					if(temp.indexOf(","))
						temp = "\"" + JSON.stringify(dataLogList[i].locValue).replace(/\"/g,"\"\"") + "\"";
				}
				else
					tempStr += dataLogList[i].locValue;
				
				tempStr += ","; 

				if(typeof dataLogList[i].value === "object") {
					tempStr += "\"" + JSON.stringify(dataLogList[i].value).replace(/\"/g,"\"\"") + "\"";
				}
				else if(typeof dataLogList[i].value === "string") {
					temp = JSON.stringify(dataLogList[i].value);
					if(temp.indexOf(","))
						temp = "\"" + JSON.stringify(dataLogList[i].value).replace(/\"/g,"\"\"") + "\"";
				}
				else
					tempStr += dataLogList[i].value;
				

				
				tempStr += "," + dataLogList[i].deltaValue + "," + dataLogList[i].deltaTime + "," + dataLogList[i].pathname;
				
			}
			
		}
		else if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
			tempStr = "Local Time,UTC Time,Device Name,Block,Datapoint,Preset,Local Value,Value";
			if(mode === 1)
				tempStr += ",Delta Value,Delta Time";
			tempStr += ",DP Path";
			
			//temp1 = temp1.replace(/ /g, "_");
			
			sFilename = "Dashboard_" + temp1 + "_";
			if(mode === 0)
				sFilename += "CurrentValue_";
			else 
				sFilename += "CurrentPlusChartValue_";
				sFilename +=  currentTimestamp + ".csv";
			objList =  JSON.parse(JSON.stringify(dashboardDpList));
			for(i = 0; i < objList.length; i++)
			{
				len = 1;
				z = -1;
				if(mode === 1) {
					// add chart info
					if(typeof objList[i].chartIndex !== "undefined") {
						temp = objList[i].chartIndex;
						objList[i].data = [];
						objList[i].data = g_dashboardChartList[temp].data;
						len = objList[i].data.length;
						z = 1;
					}
				}
				for(j=0; j < len; j++)
				{
					if(z === -1) {
						temp = objList[i].local.replace(/ /g,"_");
						tempStr += "\r\n" + temp + "," + objList[i].utc;
					}
					else {
						d = new Date();
						d.setTime(objList[i].data[j].timestamp);
						time = d.toLocaleTimeString();
						//dates = d.toLocaleDateString().split("/");
						//tempStr += "\r\n" + dates[2] + "-" +  ivPadStart(dates[0], "0", 2) + "-" +  ivPadStart(dates[1], "0", 2) + " " + time + ",";
						tempStr += "\r\n" + d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " " + time + ",";
					}
					tempStr += "," + objList[i].deviceName;
					tempStr += "," + objList[i].block + "," + objList[i].dpName + ",";
					if(mode === 0) {
						if(typeof  objList[i].presetValue === "undefined")
							tempStr +=  ",,";
						else 
							tempStr +=  + objList[i].presetValue + ",";
						if(typeof objList[i].locValue === "object") {
							tempStr += "\"" + JSON.stringify(objList[i].locValue).replace(/\"/g,"\"\"") + "\"";
						}
						else if(typeof objList[i].locValue === "string") {
							temp = JSON.stringify(objList[i].locValue);
							if(temp.indexOf(","))
								temp = "\"" + JSON.stringify(objList[i].locValue).replace(/\"/g,"\"\"") + "\"";
						}
						else
							tempStr += objList[i].locValue;
						
						tempStr += ","; 
					
					
						if(typeof objList[i].value === "object") {
							tempStr += "\"" + JSON.stringify(objList[i].value).replace(/\"/g,"\"\"") + "\"";
						}
						else if(typeof objList[i].value === "string") {
							temp = JSON.stringify(objList[i].value);
							if(temp.indexOf(","))
								temp = "\"" + JSON.stringify(objList[i].value).replace(/\"/g,"\"\"") + "\"";
						}
						else
							tempStr +=objList[i].value;
					}
					else {
						//chart data
						
						if(z === -1) {
							tempStr +=  + objList[i].presetValue + ",";
							value = objList[i].value;
						}
						else { // chart data
							if(typeof objList[i].data[j].presetValue === "undefined")
							tempStr +=  ","; //tempStr +=  ",,";
							else
								tempStr +=  objList[i].data[j].presetValue + ",";
							value = objList[i].data[j].value;
						}
						if(typeof value === "object") {
							tempStr += "\"" + JSON.stringify(value).replace(/\"/g,"\"\"") + "\"";
						}
						else if(typeof value === "string") {
							temp = JSON.stringify(value);
							if(temp.indexOf(","))
								temp = "\"" + JSON.stringify(value).replace(/\"/g,"\"\"") + "\"";
						}
						else
							tempStr += value;
						tempStr += ","; 
					}
					

					if(mode === 1) {
						if((z === -1) || (j === 0))
							tempStr += ",,";
						else {
							tempStr += ","
							tempStr += (objList[i].data[j].value - objList[i].data[j - 1].value);
							tempStr += ",";
							temp = (objList[i].data[j].timestamp - objList[i].data[j - 1].timestamp);
							temp = temp / 1000;
							if(temp < 60)
								tempStr += temp.toFixed(1) + " s";
							else if(temp < (60 * 60))
								tempStr += (temp / 60).toFixed(2) + " m";
							else if(temp < (60 * 60 * 24))
								tempStr += (temp / (60 * 60)).toFixed(2) + " hours";
							else 
								tempStr += (temp / (60 * 60 * 24)).toFixed(2) + " days";
						}
					}
					tempStr +=  "," + objList[i].pathname;
				}
				
			}
			
		}
		else if(g_iMainDisplayMode === DISPLAYMODE_ALLDEVICES) {

			if(mode === 8) {
				sFilename = "TestAllDevices_ProblemDevices_";
				try {
					if(deviceListAll !== null) {
						for(i=0; i < deviceListAll.length; i++) {
							if(typeof deviceListAll[i].category !== "undefined") {
								if(deviceListAll[i].category === "SC") {
									sFilename += deviceListAll[i].SID + "_";
									break;
								}
							}
						}
					}
				}
				catch {}
				
				sFilename += currentTimestamp + ".csv";
				tempStr = "Device Name,Protocol";
				for(i=0; i < g_testDevicesList.length; i++)
				{
					if(g_testDevicesList[i].category !== "SC") {
						if(g_testDevicesList[i].result === 2) {
							tempStr += "\r\n" + g_testDevicesList[i].name + "," + g_testDevicesList[i].protocol;
						}
					}
				}
			}
			else {
				sFilename = "DeviceInfo_";
			
				try {
					if(deviceListAll !== null) {
						for(i=0; i < deviceListAll.length; i++) {
							if(typeof deviceListAll[i].category !== "undefined") {
								if(deviceListAll[i].category === "SC") {
									sFilename += deviceListAll[i].SID + "_";
									break;
								}
							}
						}
					}
				}
				catch {}

				sFilename += currentTimestamp + ".csv";
				
				// determine if 
				if(table !== null) { 
					table = document.getElementById("myTable");
					z = 0;
					cols = table.rows[0].cells.length;
									
					//for(i=0; i < table.rows[0].cells.length; i++) 
					//{
					//	if(table.rows[0].cells[i].innerHTML.indexOf("Domain") === 0)
					//	{
					//		tempStr += "Domain/S/N IDs,"
					//		z = 1;
					//		break;
					//	}
					//}
					//cols += z;
					
					tempStr = "";
					temp1 = "";
					for(i=0; i <  table.rows.length; i++)
					{
						z = 1;	
						if(i > 0)
							temp1 += "\r\n";
						for(j=2; j < cols; j ++)
						{

							if(i === 0) {
								if(tempStr !== "")
									tempStr += ",";
								tempStr += table.rows[i].cells[j].innerHTML;

							}
							else {
								temp = table.rows[i].cells[j].innerHTML;
								if(j > 2)
									temp1 += ",";
								
								if(temp.indexOf("<b") === -1) {
									if(temp.indexOf("<div") !== -1) {
										// strip off <div></div>
										try {
											iPtr = temp.indexOf(">");
											if(iPtr > 0) {
												temp = temp.substr(iPtr + 1);
												Ptr = temp.indexOf("</div>");
												if(iPtr > 0) 
													temp = temp.substr(0, iPtr);
											}
										}
										catch {}
									}
									if(temp.indexOf(",") !== -1)
										temp = "\"" + temp + "\"";
									temp1 += temp;
								}
							}
						}
						
					}
					tempStr += temp1;
				}
			}
		}
		else if(g_iMainDisplayMode === DISPLAYMODE_SERVICEPIN) {
			sFilename = "ServicePinMessage_";
			try {
				if(deviceListAll !== null) {
					for(i=0; i < deviceListAll.length; i++) {
						if(typeof deviceListAll[i].category !== "undefined") {
							if(deviceListAll[i].category === "SC") {
								sFilename += deviceListAll[i].SID + "_";
								break;
							}
						}
					}
				}
			}
			catch {}
			sFilename += currentTimestamp + ".csv";
			tempStr = "UID,Program ID,Device Type,Protocol,TimeStamp"
			for(i=0; i < ivWsServicePinMessageHistory.length; i++)
			{
				z = -1;
				for(j=0; j < objList.length; j ++)
				{
					if(ivWsServicePinMessageHistory[i].serviceMessage.uid == objList[j]) {
						if(j !== (objList.length -1))
							z = j;
						break;
					}
				}
				if(z === -1) {
					objList.push(ivWsServicePinMessageHistory[i].serviceMessage.uid);
					obj = ivWsServicePinMessageHistory[i];
					sTemp = ""; 
					try {
						for(k=0; k < deviceTypeList.length; k++)
						{
							if(deviceTypeList[k].programId === obj.serviceMessage.type) {
								sTemp = deviceTypeList[k].name;
								break;
							}
						}
					}
					catch {}
					tempStr += "\r\n" + obj.serviceMessage.uid + "," + obj.serviceMessage.type + "," + sTemp + "," + obj.serviceMessage.protocol + "," + obj.timestamp;
				}
			}
		}
		else if(g_iMainDisplayMode === DISPLAYMODE_CONNECTIONS) {
			sFilename = "Connection_" + currentTimestamp + ".csv";
			tempStr = g_sConnections;
		 }
*/
		if(tempStr !== "") {
			var copyElement = document.createElement("a");
			copyElement.setAttribute('href', 'data:text/plain;charset=utf-8,' + encodeURIComponent(tempStr));
			copyElement.setAttribute('download', sFilename);
			copyElement.style.display = 'none';
			document.body.appendChild(copyElement);
			copyElement.click();
			document.body.removeChild(copyElement);
		}
	
	}
	catch (err) 
	{
		showAlertDialog(0,"Error: Can't csave\r\n\r\n" + err.toString());
	}
}

function savePrevousHtmlContent() {
	// save content so when you go back you have previous data
	if(g_iMainDisplayMode === DISPLAYMODE_DATALOG) {
		try {
			g_dataLogPaneData = {};
			g_dataLogPaneData.apiGetUrl = document.getElementById("dataLogDpUrl").value;
			g_dataLogPaneData.apiPutUrl = document.getElementById("dataLogDpDate").value;
			g_dataLogPaneData.apiPayload = document.getElementById("dataLogUrl").value;
		}
		catch {g_dataLogPaneData = null; }
	} 
	else if (g_iMainDisplayMode === DISPLAYMODE_APITESTER) {
		try {
			g_apiPaneData = {};
			g_apiPaneData.apiGetUrl = document.getElementById("getUrl").value;
			g_apiPaneData.apiPutUrl = document.getElementById("putUrl").value; 
			g_apiPaneData.apiPutPayload = document.getElementById("putPayload").value;
			g_apiPaneData.apiAdvancedCheckboxChecked = document.getElementById("advancedCheckbox").checked;
			g_apiPaneData.apiTraceLogCheckboxChecked = document.getElementById("traceLogCheckbox").checked;
			g_apiPaneData.apiData = document.getElementById("apiData").value;
			g_apiPaneData.apiLog = document.getElementById("apiLog").value;
			g_apiPaneData.apiPrettyJsonChecked = document.getElementById("prettyJsonCheckbox").checked;
			g_apiPaneData.apiClearBetweenRequestChecked = document.getElementById("clearBetweenRequestsCheckbox").checked;
		}
		catch {g_apiPaneData = null; }
	}
	if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
		try {
			// ffixxxxx checkif nodes active or hidden
			g_sPlanningPaneContent = document.getElementById("main").innerHTML;
		}
		catch { }
	} 
	if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
		try {
			
		}
		catch { }
	} 
}
function setTopContainerSize() {
	// remove no longer used
	return;
	// fixes sidebar and Main-Container DIV hozontally - used to eliminate main-container DIV from getting moved below sidebar 
	try {
		var screenWidth = screen.width;
		var iSidebarWidth = document.getElementById("sidebar").offsetWidth;
		var iMainContainerWidth = document.getElementById("main-Container").offsetWidth;
		if((iSidebarWidth + iMainContainerWidth) > screenWidth)
			iMainContainerWidth = screenWidth - iSidebarWidth;
		document.getElementById("top-Container").style.minWidth = (iSidebarWidth + iMainContainerWidth).toString() + "px";  // xxxxxx remove 100
		document.getElementById("main-Header").offsetWidth = (iMainContainerWidth - 30).toString() + "px"; // 30 is padding
		document.getElementById("main").offsetWidth = (iMainContainerWidth - 30).toString() + "px";  

	} catch {}
}
function showActiveAlarms() {
	savePrevousHtmlContent();
	showActiveAlarm1(0);
}
function showActiveAlarm1(mode) {
	savePrevousHtmlContent();
	initializeDisplay();
	ivbWsProcessDatapointUpdate = true;
	g_iMainDisplayMode = DISPLAYMODE_ACTIVEALARMS;
	if(mode === 1)
		g_sActiveAlarmsPaneContent = "";
	var paneTitle = "<label id=\"displayLabel\">Active Alarms</label>";
	
	paneTitle += "<button onclick=\"showActiveAlarm1(1)\" style=\"float:right\">Refresh Alarms</button>";
	//paneTitle += "<button onclick=\"showActiveAlarmOnDemand(1)\" style=\"float:right\">Refresh DP value</button>";
	paneTitle += "<div style=\"float:right\">";
	paneTitle += "<button onclick=\"getAlarmTypes(1)\" style=\"float:right\">Alarm Definitions</button>";
	//paneTitle += "<input type=\"checkbox\" id=\"pollCheckbox\"  onchange=\"pollCheckBox()\">Poll";
	//paneTitle += "<input id=\"pollrate\" value=\"30\" size=\"4\"></div>";
	var paneContent = "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting Active Alarm Info ...</span></div>";
	document.getElementById("main-Header").innerHTML = paneTitle;
	if(g_sActiveAlarmsPaneContent !== "") {
		document.getElementById("main").innerHTML = g_sActiveAlarmsPaneContent;
	}
	else {
		document.getElementById("main").innerHTML = paneContent;
		getActiveAlarms(mode, "");
	}

}
function showActiveAlarmOnDemand(mode) {
	showAlertDialog(0,"Not supported yet");
}
function showAlertDialog(mode, msg) {
	// replaces "alert()"
	// mode: 0=Don't add warning/error msg, 1=warning, 2=error
	var element = document.getElementById("warningDiv");
	var sTemp = "";
	try {
		if((msg === "") || (element === null))
			return;
		menuOverlayDivShow(7, null);
		if(mode === 1)
			sTemp = "Warning:<br><br>";
		else if(mode === 2)
			sTemp = "Error:<br><br>";
		msg = msg.replace(/\\r\\n/g, "<br>");
		sTemp += msg;
		sTemp += "<br><br><div style=\"width:100%;text-align:right\"><button class=\"warningDivShowButton\" onclick=\"showAlertDialogHide()\">OK</button></div>";
		element.innerHTML = sTemp; 

	}
	catch {}
} 
function showAlertDialogHide() {
	try {
		var element = document.getElementById("warningDiv");
		if(element !== null)
			element.className = "testDivHide";
		element = document.getElementById("warningOverlayDiv");
			if(element !== null)
				element.className = "testDivHide";
	}
	catch {}
} 

function showConfirmDialog(mode, msg) {
	// not implemented yet
	// replaces "alert()"
	// mode: 0=Don't add warning/error msg, 1=warning, 2=error
	var element = document.getElementById("warningDiv");
	var sTemp = "";
	try {
		if((msg === "") || (element === null))
			return;
		menuOverlayDivShow(7, null);
		if(mode === 1)
			sTemp = "Warning:<br><br>";
		else if(mode === 2)
			sTemp = "Error:<br><br>";
		msg = msg.replace(/\\r\\n/g, "<br>");
		sTemp += msg;
		sTemp += "<br><br><div style=\"width:100%;text-align:right\"><button class=\"warningDivShowButton\" onclick=\"showAlertDialogHide()\">OK</button></div>";
		element.innerHTML = sTemp; 

	}
	catch {}
} 

function showAllDpAdditionalInfoCheckBox() {
	try {
		return;
		if((g_iMainDisplayMode === DISPLAYMODE_DPS) || (g_iMainDisplayMode === DISPLAYMODE_FAVDPS)) {
			if(document.getElementById("additionalInfoCheckbox").checked) {
				document.getElementById("info1").style.display = "block";
				document.getElementById("info2").style.display = "block";
			}
			else {
				document.getElementById("info1").style.display = "none";
				document.getElementById("info2").style.display = "none";
			}
		}
	}
	catch {}
}


function showAllDpsGetFavoriteDps(mode) {
	try {
		var url = "https://" + location.hostname + "/iap/dp/favorites?pg=1&sz=25";
		cmsFavoritesList = [];
		requestGetData(mode, url, showAllDpsGetFavoriteDpsCallback, readFailCallback); // get Device list
	}
	catch {}
	
}

function showAllDpsGetFavoriteDpsCallback(mode, requestUrlString, json){
	// mode: 0=read Favs, 1=replace FAVs (by deleting), 3=menucms 4=don't change display, 5=already have list, 6 =refresh
	var favName = "BrowserFav";
	var iPtr;
	var temp = "";
	
	var i, j, k, len,iPtr;
	
	var url = "";
	var payload = "";
	bivServerOnline = true;

	if(mode === 5) {
		menuCmsDpFavoritesShow(0);
				return;
	}
	else if((json === null) || (json.length === 0)) {
		//if((mode !== 1) && (cmsFavoritesList.length > 0)) {
		if(mode !== 1) {
			// if empty list still show CMS favorties menu
			if(mode === 3) {
				menuCmsDpFavoritesShow(0);
				return;
			}
			else if(mode === 6) {
				menuCmsDpFavoritesShow(1);
				return;
			}
		}
		else if(mode === 1) {
			showAllDpsSaveFavoriteDpsWrite(favName);
			return;
		}
		else if(mode !== 4) {
			if(g_iMainDisplayMode === DISPLAYMODE_FAVDPS)
				document.getElementById("main").innerHTML = "<br><br></br><i>" + favName + " Doesn't exists in CMS, press \"FAVs Menu\" to see existing CMS Favorites";
				return;
		}
		
	}
	else {
		// do next page request
		cmsFavoritesList = cmsFavoritesList.concat(json);
		url = "https://" + location.hostname + "/iap/dp/favorites?pg=";
		iPtr = requestUrlString.indexOf("pg=");
		if(iPtr > 0) {
			iPtr += "pg=".length;
			iPtr1 = requestUrlString.indexOf("&",iPtr - 1);
			if(iPtr1 > 0) {
				temp = requestUrlString.substr(iPtr, iPtr1 - iPtr);
				temp = Number(temp);
				if(!isNaN(temp)) {
					temp ++;
					url += temp;
					url += "&sz=25";
					requestGetData(mode, url, showAllDpsGetFavoriteDpsCallback, readFailCallback);
				}
			}
			return;
		}
		else 
			return;
		
	}
	
	try {
		
		json = cmsFavoritesList;
		if(mode === 0) {
			favDpList = [];
			
		}
		for(i= 0; i < json.length; i ++)
		{
			if(json[i].name === favName) {
				if(mode === 0) {
					dps = json[i].currentDatapointQualifiers;
					for(j=0; j < dps.length; j ++)
					{
						if(payload !== "")
							payload += ",";
						payload += encodeUriString(dps[j]);
					}
					if(payload !== "") {
						// do on demand request to build up favList
						
						//payload = encodePathString(payload);
						//payload = payload.replace(/\//g,"%2F");
						//payload = payload.replace(/\"/g,"");
						//payload = payload.replace(/\[/g,"%5B");
						//payload = payload.replace(/\]/g,"%5D");
						url = "https://" + location.hostname + "/iap/devs/*/if/*/*/*+qualifier=-" + payload + "/*?noxs=true";
						requestGetData(0, url, showAllDpsGetFavoriteDpsPropertiesCallback, readFailCallback);
					}
				}
				else if (mode === 1) {
					url = "https://" + location.hostname + "/iap/dp/favorites/delete";
					payload = "{\"toDelete\":[" + json[i].id + "]}";
					var Rsp = requestPutData(favName, url, payload,  showAllDpsRemoveFavCallback, null);
					return;
				}
				break;
			}
			
		}
		if(mode === 1) {
			showAllDpsSaveFavoriteDpsWrite(favName);
		}
		
	}
	catch {}
}
function showAllDpsGetFavoriteList(mode) {
	try {

		var url = "https://" + location.hostname + "/iap/dp/favorites?pg=1&sz=25";
		
		requestGetData(mode, url, showAllDpsGetFavoriteListCallback, readFailCallback); // get Device list
	}
	catch {}
	
}

function showAllDpsGetFavoriteListCallback(mode, requestUrlString, json){
	// mode: 0=read Favs, 1=replace FAVs (by deleting), 4=don't change display
	var favName = g_sfavDpFavoriteName; //"BrowserFav"; //
	var iPtr;
	var temp = "";
	bivServerOnline = true;
	
	if((json === null) || (json.length === 0)) {
		if(mode === 1) {
			showAllDpsSaveFavoriteDpsWrite(favName);
		}
		else if(mode !== 4) {
			if(g_iMainDisplayMode === DISPLAYMODE_FAVDPS)
				document.getElementById("main").innerHTML = favName + " Doesn't exists in CMS";
		}
		return;
	}
	
	try {
		var i, j, k, len,iPtr;
		
		var url = "";
		var payload = "";
		if(mode === 0)
			favDpList = [];
		for(i= 0; i < json.length; i ++)
		{
			if(json[i].name === favName) {
				if(mode === 0) {
					dps = json[i].currentDatapointQualifiers;
					for(j=0; j < dps.length; j ++)
					{
						if(payload !== "")
							payload += ",";
						payload += dps[j];
					}
					if(payload !== "") {
						// do on demand request to build up favList
						
						payload = encodePathString(payload);
						//payload = payload.replace(/\//g,"%2F");
						//payload = payload.replace(/\"/g,"");
						//payload = payload.replace(/\[/g,"%5B");
						//payload = payload.replace(/\]/g,"%5D");
						url = "https://" + location.hostname + "/iap/devs/*/if/*/*/*+qualifier=-" + payload + "/*?noxs=true";
						requestGetData(0, url, showAllDpsGetFavoriteDpsPropertiesCallback, readFailCallback);
					}
				}
				else if (mode === 1) {
					url = "https://" + location.hostname + "/iap/dp/favorites/delete";
					payload = "{\"toDelete\":[" + json[i].id + "]}";
					var Rsp = requestPutData(favName, url, payload,  showAllDpsRemoveFavCallback, null);
					return;
				}
				break;
			}
			
		}
		if(mode === 1) {
			showAllDpsSaveFavoriteDpsWrite(favName);
		}
		
	}
	catch {}
}
function showAllDpsGetFavoriteClear() {
	try {
		favDpList = [];
		document.getElementById("main").innerHTML = "No Datapoints Selected";
	}
	catch {}

}
function showAllDpsGetFavoriteDpsPropertiesCallback(mode, requestUrlString, json){
	var i, obj;
	if(!((g_iMainDisplayMode === DISPLAYMODE_DPS) || (g_iMainDisplayMode === DISPLAYMODE_FAVDPS))) {
		requestInProgress = 0;
		return;
	}
	if(mode === 6) {
		if(json.length > 0) {
			//json = json.concat(favDpList);
			for(i=0; i < favDpList.length; i ++)
			{
				obj = {};
				obj = favDpList[i];
				obj.name = obj.dpName;
				obj.lon = {};
				obj.lon.cfg = {};
				obj.lon.cfg.unit = obj.unit;
				obj.local = obj.timestampStr.replace(/ /,"T") + "-XX:XX[  ]";
				json.push(obj);
			}
			
		}
		else 
			return;
		favDpList = [];
		mode = 0;
	}
	else if(mode > 1)  { // uses web socket response instead
		requestInProgress = 0;
		return;
	}
	if(mode === 0)
		favDpList = [];
	processGetDeviceDpData(mode, 0, requestUrlString, json);// iot
	requestInProgress = 0;
}
function showAllDpsRemoveFavCallback(mode, requestUrlString, json){
	// mode = favorite name
	// old one removed now add
	showAllDpsSaveFavoriteDpsWrite(mode);  // mode = favorite name
}
function showAllDpsReplaceFavoriteDps(favName) {
	// first delete old favorite and then create new one
	g_sfavDpFavoriteName = favName;
	showAllDpsGetFavoriteDps(1); 
}
function showAllDpsSaveFavoriteDpsWrite(favName) {
	try {
		var url = "https://" + location.hostname + "/iap/dp/favorites";
		var payload = "";
		var i;
		if(favDpList.length > 0) {
			for(i=0; i < favDpList.length; i ++)
			{
				if(payload !== "")
					payload += ",";
				payload += "\"" + favDpList[i].dpQualifier + "\"";
			}
			if(payload !== "") {
				payload = "{\"name\":\"" + favName + "\",\"searchQuery\":\"\",\"currentDatapointQualifiers\":[" + payload;
				payload += "],\"historicalDatapointIds\":[]}"
			}
			var Rsp = requestPostFunction(0, url, payload,  null, null); 
		}
	}
	catch {}
}

function showConnections() {
	showConnections1(0);
}
function showConnections1(mode) {
	// mode: 0= refresh all, 3=specific datapoint
	var paneTitle = "<label id=\"displayLabel\">Connections</label><div style=\"float:right\">";
	var paneContent = "<table id=\"datalogData\"></table><br><span id=\"gettingInfoId\" class=\"getting Connection Info\"></span></div>";
	savePrevousHtmlContent();
	initializeDisplay();
	g_iMainDisplayMode = DISPLAYMODE_CONNECTIONS;
	paneTitle += "<button onclick=\"saveData(0)\">Save</button><button onclick=\"showConnections1(0)\">Refresh All</button><button onclick=\"showConnections1(2)\">Refresh</button></div>";
	paneContent = "<br><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Previous Get Connection Information ...</span>";
	document.getElementById("main-Header").innerHTML = paneTitle;
	document.getElementById("main").innerHTML = paneContent;
	if(mode === 0) {
		g_sConnectionsDpDeviceName = "";
		g_sConnectionsDpDeviceType = "";
		g_sConnectionsDpName = "";
		g_sConnections = "";
	}
	else if(mode === 2) {
		g_sConnections = "";
	}
	if(g_sConnections === "")
		getConnections(mode);
	else 
		getConnectionsResponse(3,"", g_sConnections);
}
function showConnectionsByName(mode, pathname) { //(1,'" + pathname + "') {
	try {
		var i, iPtr;
		var deviceName = "", deviceType = "";
		g_sConnectionsDpName = "";
		g_sConnectionsDpDeviceType = "";
		g_sConnectionsDpDeviceName = "";
		iPtr = pathname.indexOf("/");
		if(iPtr !== -1) {
			deviceName = pathname.substr(0, iPtr);
			g_sConnectionsDpName = pathname.substr(iPtr + 1);
		}
		else {
			deviceName = pathname;
		}
		if(deviceName !== "") {
			for(i=0; i < deviceListAll.length; i ++)
			{
				if(deviceListAll[i].name === deviceName) {
					g_sConnectionsDpDeviceName = deviceName;
					g_sConnectionsDpDeviceType = deviceListAll[i].deviceTypeName;
					break;
				}
			}
			if(g_sConnectionsDpDeviceType === "") {
				document.getElementById("main").innerHTML = "Can't find device, Get All Devices and try again";
			}
			else {
				g_sConnections = "";
				showConnections1(3);
			}
		}
	}
	catch {}
}


function showDatapoints() {
	savePrevousHtmlContent();
	showAllDps(1);
}
function showDatapointList(json) {  // mode:Updated value 0=Build Dp list, 1=
	// type 0=normal Get request response, 1= Web socket response
	// json list of dps
	// IzoT Vision Types: sv=Show Value, tb=textbox, dl=dropdown list, sdl= substitution dropdown list cb=combobox
	var paneContent = "";
	var i, j;
	var bHasPresets = false;
	if(json === null)
		return;

	if (json.length === 0)
		return;

	try {
		
		paneContent = "<tHead><tr><th onclick=\"sortTable(0)\">#</th><th>";
		if(g_iMainDisplayMode === DISPLAYMODE_DPS)
			paneContent += "<div style=\"display:flex\"><input type=\"checkbox\" id=\"favoritesCheckbox\" onclick=\"favoritesCheckbox()\">";
		paneContent += "FAV";
		if(g_iMainDisplayMode === DISPLAYMODE_DPS)
			paneContent += "</div>";
		paneContent += "</th><th>Menu</th><th onclick=\"sortTable(3)\">Device</th><th onclick=\"sortTable(4)\">Block</th><th onclick=\"sortTable(5)\">DP</th>";
		paneContent += "<th id=\"info1\" onclick=\"sortTable(6)\">DP XIF Name</th>";
		paneContent += "<th onclick=\"sortTable(7)\" class=\"tdValue\">Presets</th>";
		paneContent += "<th onclick=\"sortTable(8)\" class=\"tdValue\">Local Value</th><th onclick=\"sortTable(9)\" class=\"tdValue\">Value</th>";
		paneContent += "<th onclick=\"sortTable(10)\">Priority</th><th>New Value (Normal priority only)<br>"; 
		paneContent += " [<input type=\"checkbox\" id=\"usePriority\" onclick=\"usePriority()\"";
		if(g_bUsePriorityForAllWrites)
			paneContent += " checked";
		paneContent += ">Add Priority";
		paneContent += " <input type=\"checkbox\" id=\"useLocalValue\" onclick=\"useLocalValue()\"";
		if(g_bUseLocalizationForAllWrites)
			paneContent += " checked";
		paneContent += ">Local Value]";
		paneContent += "</th>";
		paneContent += "<th onclick=\"sortTable(12)\">Units</th>";
		paneContent += "<th onclick=\"sortTable(13)\">Timestamp</th><th onclick=\"sortTable(14)\">DP Type</th><th onclick=\"sortTable(15)\">Direction</th><th onclick=\"sortTable(16)\">Path</th><th onclick=\"sortTable(17)\">Path (Programmatic)</th><th onclick=\"sortTable(18)\">dpQualifier</th></tHead><tbody>";
		
			// clear javascript Object information
	
		for(j= 0; j < json.length; j ++)
	  	{
			paneContent += "<tr><td>" + (j + 1).toString() + "</td>";
			// check if in favorites
			z = -1;
			if(g_iMainDisplayMode === DISPLAYMODE_FAVDPS)
				z = 1;
			else {
				for(i=0; i < favDpList.length; i++ )
				{
					if(json[j].pathname === favDpList[i].pathname) {
						z = i;
						break;
					}
				}
			}
			if(z === -1)
				paneContent += "<td><input type=\"checkbox\" id=\"fav_" + json[j].pathname + "\" onclick=\"addToFavorites('" + json[j].pathname + "')\"></td>";
			else 
				paneContent += "<td><input type=\"checkbox\" id=\"fav_" + json[j].pathname + "\" onclick=\"addToFavorites('" + json[j].pathname + "')\" checked></td>";
			paneContent += "<td><button id=\"dpMenu_" + json[j].pathname + "\" style=\"margin-left:5px;margin-right:5px;\" onclick=\"menuDp(event, ";
			if(g_iMainDisplayMode === DISPLAYMODE_FAVDPS)
				paneContent += "1, ";
			else
				paneContent += "0, ";
			paneContent += j + ", '" + json[j].pathname + "', '" + json[j].programmaticPathname + "')\">...</button></td>";
			paneContent += "<td>" + json[j].deviceName + "</td><td>" + json[j].block  + "</td><td>" + json[j].dpName;
			paneContent += "</td><td>" + json[j].datapointName;
			paneContent += "</td><td class=\"tdPreset\"><span id=\"presetValue_" + json[j].pathname + "\">" + json[j].presetValue + "</span></td>";
			paneContent += "</td><td class=\"tdValue\"><div id=\"localValue_" + json[j].pathname + "\" class=\"tdValueDiv\">" + json[j].locValueStr + "</div></td>";
			//paneContent += "</td><td class=\"tdValue\"><div id=\"currentValue_" + json[j].pathname + "\">" + json[j].valueStr + "</div></td>";
			paneContent += "</td><td class=\"tdValue\"><div id=\"currentValue_" + json[j].pathname + "\" class=\"tdValueDiv\">" + json[j].valueStr + "</div></td>";
			if(json[j].cat === "in") {
				paneContent += "<td><span id=\"priority_" + json[j].pathname + "\">" + json[j].priority + "</span></td>";
			
				paneContent += "<td><div class=\"tdNewValueDiv\"><input id=\"newValue_" + json[j].pathname + "\""; 
				/*
				paneContent += " onfocus=\"inputBoxOnFocus(this, " + j + ", '" + json[j].pathname + "')\"";
				paneContent += " onchange=\"inputBoxChanged(this, " + j + ", '" + json[j].pathname + "')\"";
				paneContent += " onblur=\"inputBoxLostFocus(this, event, " + j + ", '" + json[j].pathname + "')\"";
				paneContent += " onkeyup=\"inputBoxKey(this, event, " + j + ", '" + json[j].pathname + "')\"";
				*/
				bHasPresets = false;
				if(json[j].presets !== null) {
					if(typeof json[j].presets !== "undefined") {
						if(json[j].presets.enabled) {
							if(json[j].presets.map.length > 0) {
								bHasPresets = true;
								paneContent += " list=\"dpNewValuePresetList_" + json[j].pathname + "\"><datalist id=\"dpNewValuePresetList_" + json[j].pathname + "\">"
								for(i=0; i < json[j].presets.map.length; i++)
								{
									name1 = json[j].presets.map[i].name;
									paneContent += "<option value='" + name1 + "'>"  + name1 + "</option>";
								}
								paneContent += "<option value='" + json[j].valueStr + "'>Raw Value</option>";
								paneContent += "</datalist";
							}
						}
					}
				} 
				if(!bHasPresets) {
					paneContent += " list=\"dpNewValuePresetList_" + json[j].pathname + "\"><datalist id=\"dpNewValuePresetList_" + json[j].pathname + "\">"
					paneContent += "<option value='" + json[j].valueStr + "'>Raw Value</option>";
					paneContent += "</datalist";
				} 
				paneContent += "><button style=\"margin-left:10px\" onclick=\"inputBoxSendValue(this, event, " + j + ", '" + json[j].pathname + "')\">Send</button>";
				paneContent += "<button id=\"dpValueMenu_" + json[j].pathname + "\" style=\"margin-left:10px\" onclick=\"menuDpValue(this,  " + j + ", '" + json[j].pathname + "')\">...</button></div></td>";
			}
			else 
				paneContent += "<td></td><td></td>";
			paneContent += "<td><span id=\"unit_" + json[j].pathname + "\">" + json[j].unit + "</span></td>";
			
			paneContent += "<td><span id=\"timestamp_" + json[j].pathname + "\">" + json[j].timestampStr + "</span></td>";
			paneContent += "<td>" + json[j].type + "</td><td>" + json[j].cat + "</td>";
			paneContent += "<td class=\"pathname\">" + json[j].pathname + "</td>";
			paneContent += "<td class=\"pathname\">" + json[j].programmaticPathname + "</td>";
			paneContent += "<td class=\"pathname\">" + json[j].dpQualifier + "</td>";
			paneContent += "</tr>"; 
		
		} //for(i= 0; 
		paneContent = "<br><table id=\"myTable\">" + paneContent + "</tbody></table>";
		paneContent += addTopButton();
		document.getElementById("main").innerHTML = paneContent;
		document.getElementById("dpCount").innerHTML = "[" + json.length + "]";
		
	}
	catch (err) {}
	//setTopContainerSize();
	try {
		showAllDpAdditionalInfoCheckBox();
	}
	catch {}

}
function showDeviceDpsByDeviceName(mode, pathname) {
	try 
	{
		if(mode === 0) {
			// device name
			for(i=0; i < deviceList.length; i ++)
			{
				if(deviceList[i].name === pathname) {
					dpList = [];
					showDeviceDpsByDeviceId(0, deviceList[i].id);
					break;
				}
			}
		}
		else if(mode === 1) {
			// device type name
		}
	} catch {}
}
function showDeviceDpsByDeviceId(mode, id) {
	var paneTitle = "", paneContent = "";
	savePrevousHtmlContent();
	initializeDisplay();
	ivbWsProcessDatapointUpdate = false;
	g_iMainDisplayMode = DISPLAYMODE_DPS;
	document.getElementById("main-Header").innerHTML = "";
	document.getElementById("main").innerHTML = "";
	if (typeof id === "undefined")
		return;
	if(id === "")
		return;
	var deviceId = Number(id);
	if(isNaN(deviceId))
		return;
	if(deviceList === null)
		return;
	if(deviceList.length === 0)
		return;
	var i;
	if(mode === 0) {
		for(i=0; i < deviceList.length; i ++)
		{
			if(deviceList[i].id === id) {
				clearDpFilter(2,0,0);
				g_oDpFilter.device = deviceList[i].name; 
				/*
				paneTitle += "<label id=\"displayLabel\">Device Datapoints</label>"; 
				paneTitle += "<button onclick=\"getOnDemandDpValuesRequest(1)\" style=\"float:right\">Refresh</button>";
				paneTitle += "<button onclick=\"getOnDemandDpValuesRequest(3)\" style=\"float:right\">On Demand</button>";
				paneTitle += "<div style=\"float:right\">";
				//paneTitle += "<input type=\"checkbox\" id=\"additionalInfoCheckbox\"  onchange=\"showAllDpAdditionalInfoCheckBox()\">Additional Ifo";
				paneTitle += "<button id=\"menuDpFilterButton\" onclick=\"menuDpFilter(2)\">Get DPs by Filter</button>";
				paneTitle += "<input type=\"checkbox\" id=\"pollCheckbox\"  onchange=\"pollCheckBox()\">Poll";
				paneTitle += "<input id=\"pollrate\" value=\"30\" size=\"4\"></div>";
				paneContent = "<span id=\"gettingInfoId\" class=\"gettingInfo\">Getting Device Datapoint Info ...</span>";
				
				document.getElementById("main-Header").innerHTML = paneTitle;
				document.getElementById("main").innerHTML = paneContent;
				*/
				showAllDps(6);
				g_iMainDisplayMode = DISPLAYMODE_DPS;
				document.getElementById("displayLabel").innerHTML = "Device Datapoints: " + deviceList[i].name;
				dpList = [];
				ivbWsProcessDatapointUpdate = true;
				getOnDemandDpValues(0, "/iap/devs/" + id + "/if/*/*/*/*");
			}
		}
	}
	else if(mode === 1) {
		clearDpFilter(2,0,0);
		g_oDpFilter.deviceType = id;
		paneTitle += "<label id=\"displayLabel\">Device Type Datapoints: " + id + "</label>"; 
		paneTitle += "<button onclick=\"getOnDemandDpValuesRequest(1)\" style=\"float:right\">Refresh</button>";
		paneTitle += "<button onclick=\"getOnDemandDpValuesRequest(3)\" style=\"float:right\">On Demand</button>";
		paneTitle += "<div style=\"float:right\">";
		//paneTitle += "<input type=\"checkbox\" id=\"additionalInfoCheckbox\"  onchange=\"showAllDpAdditionalInfoCheckBox()\">Additional Ifo";
		paneTitle += "<button id=\"menuDpFilterButton\" onclick=\"menuDpFilter(2)\">Get DPs by Filter</button>";
		paneTitle += "<input type=\"checkbox\" id=\"pollCheckbox\"  onchange=\"pollCheckBox()\">Poll";
		paneTitle += "<input id=\"pollrate\" value=\"5\" size=\"4\"></div>";
		paneContent = "<span id=\"gettingInfoId\" class=\"gettingInfo\">Getting Device Datapoint Info ...</span>";
		
		document.getElementById("main-Header").innerHTML = paneTitle;
		document.getElementById("main").innerHTML = paneContent;
		dpList = [];
		id = id.replace(/ /g,"%20");
		getOnDemandDpValues(0, "/iap/devs/*+typeName==" + id + "/if/*/*/*/*");
	}
	
	
}
function showContextDevices(id) {
	//g_sDevicesContext
	// determine planning tree path
	var i;
	g_sDevicesContext = "";
	if(id < contextList.length)
	{
		for(i=0; i < contextList.length; i++)
		{
			if(contextList[i].id === id) {
				g_sDevicesContext = contextList[i].path;
				break;
			}
		}
	}

	showDeviceList(6);
	
	getDeviceList("/iap/devs?contextId=" + id + "&noxs=true&short=true");
}
function showDeviceByName(mode, name) {
	savePrevousHtmlContent();
	clearDpFilter(0, 1, 0); // clear all device filters
	if(name === "") {
		// SmartServer IoT so show all devices
		if(mode === 0)
			showDeviceList(0);
		if(mode === 1) {
			showDeviceList(6);
			getDeviceList("/iap/devs/*?noxs=true&short=true");
		}
		return;
	}
	else
		g_oDeviceFilter.device = "=" + name;
	
	deviceList = [];
	if(mode === 0) {
		// use existing data
		for(i=0; i < deviceListAll.length; i++ )
		{
			if(deviceListAll[i].name === name) {
				deviceList[0] = deviceListAll[i];   
				break;
			}
		}
		showDeviceList(1);
	}
	if(mode === 1) {
		showDeviceList(6);
		getDeviceList("/iap/devs/*+=name==" + name + "?noxs=true&short=true");
	}
}
function showDeviceTypeDevices(deviceType) {
	showDeviceList(6); 
	clearDpFilter(0,1,0);
	g_oDeviceFilter.deviceType = deviceType; 
	getDeviceList("/iap/devs/*+typeName==" + deviceType + "?noxs=true&short=true");
}
function showDevices() {
	savePrevousHtmlContent();
	showDeviceList(1);
}
function showDeviceList(mode) {
	
	var paneTitle = "";
	
	paneTitle += "<label id=\"displayLabel\">Devices</label><span id=\"deviceCount\"></span>"; 
	paneTitle += "<div style=\"float:right\">";
	paneTitle += "<button onclick=\"saveData(0)\" >Save</button>";
	paneTitle += "<button id=\"menuDpFilterButton\" onclick=\"menuDpFilter(1)\">Get Devices by Filter</button>";
	paneTitle += "<button id=\"testAllDevices\" onclick=\"testAllDevices(0)\" >Test All</button>";
	paneTitle += "<button onclick=\"refresh('devicesAllInfo')\" >Show Network Addresses (All Devices)</button>";
	paneTitle += "<button onclick=\"refresh('devices')\" >Refresh All</button>";
	paneTitle += "<button onclick=\"refresh('devicefilter')\" >Refresh</button></div>";
	
	var paneContent = "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting Device Info ...</span></div>";
	savePrevousHtmlContent();
	initializeDisplay();
	g_iMainDisplayMode = DISPLAYMODE_ALLDEVICES;
	document.getElementById("main-Header").innerHTML = paneTitle;
	document.getElementById("main").innerHTML = "";
	
	if(mode === 1) {
		if(deviceList.length > 0) {
			if(deviceTypeList.length === 0)
				getDeviceTypes(10);
			else
				showDevicesFromDeviceList(deviceList);
			return;
		}
	}
	document.getElementById("main").innerHTML = paneContent;
	if(mode === 6)
		return;
	if(mode === 14) {
		getDeviceTypes(14);
	}
	else if(mode === 2) {
		if(deviceTypeList.length === 0)
			getDeviceTypes(11);
		else
			getDeviceList("/iap/devs?noxs=true&sortBy=name");
	}
	else {
		if(deviceTypeList.length === 0)
			getDeviceTypes(12);
		else
			getDeviceList("/iap/devs?short=true&sortBy=name");
	}
}
function showDevicesFromDeviceList(objList) {
	var paneContent = "";
	var i,j,k, path, sTemp;
	var tempStr;
	var iTotal = 0, iUp = 0, iProvisioned = 0, iUnProvisioned = 0, iDown = 0;
	
	if(deviceList !== null) {
		if(deviceList.length > 0) {

			try {
				
				paneContent += "<thead><tr><th onclick=\"sortTable(0)\">#</th>";
				paneContent += "<th>Menu</th>"; 
				paneContent += "<th onclick=\"sortTable(2)\">Device Name</th><th onclick=\"sortTable(3)\">id</th><th onclick=\"sortTable(4)\">Device Status</th>";
				paneContent += "<th onclick=\"sortTable(5)\">Device Type</th><th onclick=\"sortTable(6)\">UID</th>";
				paneContent += "<th onclick=\"sortTable(7)\">Program ID</th>";
				paneContent += "<th onclick=\"sortTable(8)\">Last Update</th><th onclick=\"sortTable(9)\">Protocol</th><th onclick=\"sortTable(10)\">DID</th>"
				//paneContent += "<th onclick=\"sortTable(9)\">Category</th><th onclick=\"sortTable(10)\">SID</th><th onclick=\"sortTable(11)\">Address</th><th>Menu</th></tr>"; 
				paneContent += "<th onclick=\"sortTable(11)\">Category</th><th onclick=\"sortTable(12)\">SID</th>";
				if(g_iSmartServerVersion >= 280000) {
					paneContent += "<th onclick=\"sortTable(12)\">Context</th>"
					paneContent += "<th onclick=\"sortTable(13)\">Context Path</th>"
					paneContent += "<th onclick=\"sortTable(14)\">Timezone</th>"
				}
				
				paneContent += "</tr></thead><tbody>"; 
				
				for(i= 0; i < deviceList.length; i ++)
				{
					path = "";
					paneContent += "<tr><td>" + (i+1).toString() + "</td>";
					
					if(deviceList[i].category	== "SC") {
						paneContent += "<td>";
						paneContent += "<button id=\"deviceMenu_" + deviceList[i].name + "\" onclick=\"menuDeviceSmartServer(0, event," + deviceList[i].id + ", '" + deviceList[i].name  + "')\">...</button>";
						paneContent += "</td>";
						iUp ++;
					}
					else {
						paneContent += "<td><button id=\"deviceMenu_" + deviceList[i].name + "\" onclick=\"menuDevice(0, event," + deviceList[i].id + ", '" + deviceList[i].name  + "', '" + deviceList[i].deviceTypeName  + "', '" + deviceList[i].protocol  + "')\">...</button></td>";
						if(deviceList[i].status.state === "provisioned") {
							if(deviceList[i].status.health === "normal")
								iUp ++;
							else
								iDown ++;
						}
						else
							iUnProvisioned ++;
					}
					paneContent += "<td>" + deviceList[i].name + "</td><td>" + deviceList[i].id + "</td>";
					if(deviceList[i].category === "SC") {
						paneContent += "<td></td><td></td>";
						paneContent += "<td>" + deviceList[i].SID + "</td>";
						paneContent += "<td></td><td></td><td></td><td></td>";
					}
					else {
						paneContent += "<td>" + deviceList[i].deviceStatus + "</td>";
						paneContent += "<td>" + deviceList[i].deviceTypeName  + "</td><td>" + deviceList[i].uid  + "</td>";
						z = 0;
						for(j=0; j < deviceTypeList.length; j++)
						{
							if(deviceList[i].typeId === deviceTypeList[j].id) {
								paneContent += "<td>" + deviceTypeList[j].programId + "</td>";
								z = 1;
								break;
							}
						}
						if(z === 0)
							paneContent += "<td></td>";
						
						paneContent += "<td>" + deviceList[i].mru  + "</td>";
						paneContent += "<td>" + deviceList[i].protocol + "</td><td>" + deviceList[i].DID  + "</td>";
					}
					paneContent += "<td>" + deviceList[i].category + "</td>";
					if(deviceList[i].category === "SC")
						paneContent += "<td>" + deviceList[i].SID + "</td>";
					else 
						paneContent += "<td>" + deviceList[i].scId + "</td>";
					//paneContent += "<td>" + deviceList[i].networkAddress + "</td>"; // short=true doesn't provide network address
					if(g_iSmartServerVersion >= 280000) {
						try {
							if(deviceList[i].contextStr !== null) {
								paneContent += "<td><div>" + deviceList[i].contextStr + "</div></td>";
							}
							else {
								if(!(typeof deviceList[i].contexts === "undefined")) {
									tempStr = "";
									for(k=0; k < deviceList[i].contexts.length; k++)
									{
										for(j=0; j < contextList.length; j++) 
										{
											if(contextList[j].id === deviceList[i].contexts[k]) {
												if(tempStr !== "")
													tempStr += "<br>"
												tempStr += contextList[j].name; //contextList[j].path;
												if(path !== "")
													path += "<br>";
												path += contextList[j].path;
											}
										}
										
									}
									paneContent += "<td><div>" + tempStr + "</div></td>";
								}
								deviceList[i].contextPath = path;
							}
						}
						catch
						{
							paneContent += "<td></td>";
						}
						
						if(path === "") {
							if(typeof deviceList[i].contextPath === "undefined"){
								for(k=0; k < deviceList[i].contexts.length; k++)
								{
									for(j=0; j < contextList.length; j++) 
									{
										if(contextList[j].id === deviceList[i].contexts[k]) {
											if(tempStr !== "")
												tempStr += "<br>"
											tempStr += contextList[j].name; //contextList[j].path;
											if(path !== "")
												path += "<br>";
											path += contextList[j].path;
										}
									}
									
								}
								deviceList[i].contextPath = path;
							}
							else
								path = deviceList[i].contextPath;
						}

					}
					paneContent += "<td>" + path + "</td>";
					if(g_iSmartServerVersion >= 280000) {
						if(deviceList[i].category === "SC")
							paneContent += "<td>" + deviceList[i].timezone + "</td>";
						else 
							paneContent += "<td></td>";
					}
					paneContent += "</tr>";
				}
				paneContent += "</tbody>"
				sTemp = "Total Devices [" + deviceList.length + "]: UP = " + iUp + ", Down = " + iDown + ", Unprovisioned = " + iUnProvisioned;
				
				sTemp = "<br>" + sTemp +"<br>"
				paneContent = "<br>" + g_sDevicesContext + sTemp + "<br><table id=\"myTable\">" + paneContent + "</table>";
				paneContent += addTopButton();
				document.getElementById("main").innerHTML = paneContent;
				document.getElementById("deviceCount").innerHTML = "[" + deviceList.length + "]";
				testAllDevices(1);
			}
			catch {}
		}
	}
} 
function showDeviceTypes() {
	var paneTitle = "<label>Device Types</label>";
	savePrevousHtmlContent();
	initializeDisplay(); 
	g_iMainDisplayMode = DISPLAYMODE_DEVICETYPES;
	paneTitle += "<button onclick=\"showDeviceTypes1()\" style=\"float:right\">Refresh</button>";
	
	var paneContent = "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting Device Info ...</span></div>";
	document.getElementById("main-Header").innerHTML = paneTitle;
	document.getElementById("main").innerHTML = paneContent;
	if(deviceTypeList !== null) {
		if(deviceTypeList.length > 0) {
			getDeviceTypesResponse(0, "", deviceTypeList);
			return;
		}
	}
	getDeviceTypes(0);
}
function showDeviceTypes1() {
	deviceTypeList = [];
	showDeviceTypes();
}
function showDla(mode, pathname) {
	// mode: 1=device, 2=dp, 3=deviceType
	showDlaList(6);
	var	url = "https://" + location.hostname + "/iap/devTypes/";
	if((mode === 1) || (mode === 3))
		url += pathname + "/if/*/*/*/dla?includeUnconfigured=false";
	else if (mode === 2) {

		url+=  pathname;
	}
	url += "/dla?includeUnconfigured=false";
	if(url.indexOf("/if/") > 0)
		requestGetData(0, url, getDlaSettingsResponse, readFailCallback);
	
}
function showDlaByName(mode, pathname) {
	// mode: 0=devicename, 1=dp name
	try {
		var i=0;
		var	url = "https://" + location.hostname;
		var url1 = "/iap/devTypes/";
		var pathItems = pathname.split("/");
		var url = "";
		var deviceType = "";
		var deviceTypeId = -1;
		
		if(pathname === null)
			return;
		// get device type from device name
		for(i=0; i < deviceListAll.length; i++)
		{
			if(deviceListAll[i].name === pathItems[0]) {
				if(!(typeof deviceListAll[i].deviceTypeName === "undefined")) {
					deviceType = deviceListAll[i].deviceTypeName;
				}
				break;
			}
		}
		if(deviceType !== "") {
			dlaList = [];
			showDlaList(6);
			clearDlaFilter(0, 0);  //xxxxx
			g_oDlaDpFilter.deviceType = "=" + deviceType;
			url1 += "/*+typeName==" + deviceType;
			if(mode === 0 ) {
				//url += "/*+typeName==" + deviceType;
				url1 += "/if/*/*/*/dla?includeUnconfigured=false";
				g_sDlaDpFilter = url1;
				url = url1;
				requestGetData(0, url, getDlaSettingsResponse, readFailCallback);
			}
			else if(mode === 1) {
				g_oDlaDpFilter.blockName = "=" + pathItems[1];
				g_oDlaDpFilter.blockIndex = "=" + pathItems[2];
				g_oDlaDpFilter.datapointName = "=" + pathItems[3];
				url1 += "/if/*+name==" + pathItems[1] + "/*+name==" + pathItems[2] + "/*+name==" + pathItems[3] + "/dla?includeUnconfigured=false";
				g_sDlaDpFilter = url1;
				url = url1;
				requestGetData(0, url, getDlaSettingsResponse, readFailCallback);
			}
		}
		
	}
	catch {}

}
function showDlaByName1(mode, instancePathname, pathname) {
	g_sDlaByName = instancePathname;
	showDlaByName(mode, pathname);
}
function showDlaSettings() {
	showDlaList(0);
}
function showDlaList(mode) {
	
	var paneTitle = "<label>Device Type Datapoint Properties (DLA)</label>";
	savePrevousHtmlContent();
	initializeDisplay();
	g_iMainDisplayMode = DISPLAYMODE_DLA;
	if(g_sDlaByName !== "")
		paneTitle = "<label style=\"margin-right:50px\">Device Type Datapoint Properties (DLA):  " + g_sDlaByName + "</label>";
	
	g_sDlaByName = "";
	paneTitle += "</label>";
	paneTitle += "<button onclick=\"showDlaSettingsClear()\" style=\"float:right\">Refresh All</button>";
	paneTitle += "<button  id=\"menuDlaFilterButton\" style=\"float:right\" onclick=\"menuDlaFilter(1)\">Get by filter</button>";
	
	var paneContent = "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting DLA Info ...</span></div>";
	document.getElementById("main-Header").innerHTML = paneTitle;
	document.getElementById("main").innerHTML = paneContent;
	if(mode === 6)
		return;
	if(dlaList !== null) {
		if(dlaList.length > 0) {
			getDlaSettingsResponse(0, "", dlaList);
			return;
		}
	}
	getDlaSettings();
}
function showDlaSettingsClear() {
	dlaList = [];
	showDlaSettings();
}
function showExport(mode) {
	// mode: 0= refresh all, 3=specific datapoint
	var paneTitle = "<label id=\"displayLabel\">IMPORT / EXPORT</label><div style=\"float:right\">";
	var paneContent = "<br><br>Not supported yet"; //<br><span id=\"gettingInfoId\" class=\"getting Node-RED Info\"></span></div>";
	savePrevousHtmlContent();
	initializeDisplay();
	g_iMainDisplayMode = DISPLAYMODE_EXPORT; // 9999
	
	document.getElementById("main-Header").innerHTML = paneTitle;
	document.getElementById("main").innerHTML = paneContent;
}
function showFavorites() {
	showAllDps(2);
	
}
function showFooterInfo() {
	try {
		var element;
		// normal operation
		g_bShowTree = checkIfUserTypeSupported(g_iShowTree);
		
		// check for user specific features
		if(g_campusTags.dashboard.length > 0)
			g_bSiteDashboard = true;
		if(checkIfUserTypeSupported(g_iShowAlarms))  
			g_bShowAlarms = true;
		if(!checkIfUserTypeSupported(g_iClearAlarms))
			g_bAllowedToClearAlarms = true;
		g_bShowEventCountInCalendarAllow = checkIfUserTypeSupported(g_iShowEventCountInCalendar);
		if(g_bShowEventCountInCalendarAllow) {
			if(g_bShowEventCountInCalendarDefaultShow) 
				g_bShowEventCountInCalendar = true; // can be enabled or disable by calender menu
			else 
				g_bShowEventCountInCalendar = false;
		}
		else 
			g_bShowEventCountInCalendar = false;
		element = document.getElementById("footerStatusTitle");
		if(element !== null)
			element.innerHTML = "Total Devices";

		if(g_bShowEps) {
			element = document.getElementById("footerEpsValue");
			if(element !== null) {
				element.innerHTML = "<span style=\"margin-left:20px\">EPS: </span><span id=\"epsValue\" style=\"display:inline-block;width:30px\"></span>";
			}
		}
		if(g_bShowCpu) {
			element = document.getElementById("footerCpuValue");
			if(element !== null) {
				element.innerHTML = "<span style=\"margin-left:15px\">CPU: </span><span id=\"cpuValue\" style=\"display:inline-block;width:30px\"></span>";
			}
		}
		g_bIngnoreDisplayingDeviceDeviceStatus = false;
		displayDeviceStatus();

		element = document.getElementById("footerStatus1");
		if(element !== null) {
			sTemp = ""; 
			if(g_bShowTimezone) {
				sTemp += "<span style=\"margin-left:15px\">Timezone: " + g_sTimezoneString + "</span>";
			}
			if(g_bShowCmsVersion) {
				sTemp += "<span style=\"margin-left:15px\">CMS: " + g_sSmartServerVersion + "</span>";
			}
			element.innerHTML = sTemp;
		}
	}
	catch {}
}
function showDpInfo() {
	showDpInfo1(0, "","")
}
function showDpInfo1(mode, pathname, programmaticPathname) {
	var paneTitle = "", paneContent = "";
	savePrevousHtmlContent();
	initializeDisplay();
	g_iMainDisplayMode = DISPLAYMODE_DPINFO;
	if(programmaticPathname === "")
		programmaticPathname = pathname;
	if(mode === 0) {
		if((g_sDpInfoPaneContent === "") || (g_sDpInfoPathname === "")) {
			paneTitle = "<label id=\"displayLabel\">Datapoint Info</label><div style=\"display:inline-block;float:right\">"; //<button  onclick=\"getDpInfoNodeRed(1)\">Node-RED Info</button>";
			paneTitle += "<button  onclick=\"calculateEps()\">Calculate EPS</button></div>";
			paneContent = "<div><br><br>Device or Datapoint Not selected<br>";
			paneContent += "<br><br>Click on one of the following menu buttons to select single datapoint to view Datapoint info<br>Datapoints - click datapoint menu";
			paneContent += "<br>Favorite DPs - click datapoint menu<br>Devices - click Device menu";
			paneContent += "<br><br><br>Datapoint Info Includes the following information for a single datapoint:<br>Current Value, Active Alarms, DLA, Schedules, Connections</div>";
			document.getElementById("main-Header").innerHTML = paneTitle;
			document.getElementById("main").innerHTML = paneContent;
		}
		else {
			if(g_sDpInfoPaneTitle !== "")
				paneTitle = g_sDpInfoPaneTitle;
			else
				paneTitle = "<labelid=\"displayLabel\">Datapoint Info: " + g_sDpInfoPathname + "</label>";
			paneTitle += "<div style=\"display:inline-block;float:right\">"; //<button  onclick=\"getDpInfoNodeRed(1)\">Node-RED Info</button>";
			paneTitle += "<button  onclick=\"calculateEps()\">Calculate EPS</button></div>";
			document.getElementById("main-Header").innerHTML = paneTitle;
			document.getElementById("main").innerHTML = g_sDpInfoPaneContent;
		}

	}
	else if(programmaticPathname !== "") {
		if(mode === 1) {
			paneContent = "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting DP Info ...</span></div>";
			document.getElementById("main").innerHTML = paneContent;
			getDpInfo(pathname, programmaticPathname);
		}
		if(mode === 2) { 
			paneTitle = "<label id=\"displayLabel\">Datapoint Information: SmartServer Storage</label><div style=\"float:right\">";
			//paneTitle += "<button onclick=\"getSmartServerStorageInfo()\">Refresh All</button><button onclick=\"getDpInfoNodeRed(1)\">Node Red Info</button><button  onclick=\"calculateEps()\">Calculate EPS</button></div>";;
			g_sDpInfoPaneTitle = paneTitle;   
			paneContent = "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting SmartServer Storage Info ...</span></div>";
			document.getElementById("main-Header").innerHTML = paneTitle;
			document.getElementById("main").innerHTML = paneContent;
			getSmartServerStorageInfo();
		}
		
	}
}
function showGroups() {
	var paneTitle = "<label>Group settings</label>";
	savePrevousHtmlContent();
	initializeDisplay();
	g_iMainDisplayMode = DISPLAYMODE_GROUPS;
	paneTitle += "<button onclick=\"showGroupsRefresh()\" style=\"float:right\">Refresh</button>";
	
	var paneContent = "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting Group Info ...</span></div>";
	document.getElementById("main-Header").innerHTML = paneTitle;
	document.getElementById("main").innerHTML = paneContent;
	if(groupList !== null) {
		if(groupList.length > 0) {
			getGroupsResponse(1, "", groupList);
			return;
		}
	}
	getGroups()
}
function showGroupsRefresh() {
	try {
		groupList = [];
		showGroups();
	} catch {}
} 



function showSchedules() {
	showSchedule1(0);
}
function showSchedule1(mode) {
	// mode:6=add only title bar
	var paneTitle = "<label id=\"schedulesLabel\">Schedules</label>";
	var currentPath = "all";
	savePrevousHtmlContent();
	initializeDisplay();
	g_iMainDisplayMode = DISPLAYMODE_SCHEDULE;
	paneTitle += "<button onclick=\"showSchedulesRefresh(1)\" style=\"float:right\">Refresh</button>";
	paneTitle += "<button onclick=\"showSchedulesRefresh(0)\" style=\"float:right\">Refresh All</button>";
	
	paneTitle += "<br><br>";
	try {
		if(g_sSchedulePathname === "")
			g_sSchedulePathname = "all";
		else {
			// check if list
			z = -1;
			for(i=0; i < schedulePathnameList.length; i++)
			{
				if(schedulePathnameList[i].toLowerCase() === g_sSchedulePathname.toLowerCase()) {
					z = i;
					break;
				}
			}
			if(z === -1) {
				schedulePathnameList.splice(0,0,g_sSchedulePathname);
			}
			currentPath = g_sSchedulePathname;
		}
		paneTitle += "Type: <input type=\"text\" id=\"schedulepath\" list=\"schedulePathDataList\"  value=\"" + currentPath + "\"><datalist id=\"schedulePathDataList\">";
		if(schedulePathnameList !== null) {
			for(i=0; i < schedulePathnameList.length; i++)
			{ 
				paneTitle += "<option value=\"" + schedulePathnameList[i] + "\">";
			}
		}
		paneTitle += "</datalist>"; 
		if(g_sScheduleRange === "")
			g_sScheduleRange = "week (sun - sat)";
		
		paneTitle += "Range: <input type=\"text\" id=\"scheduleRange\" list=\"scheduleRangeDataList\"  value=\"" + g_sScheduleRange + "\"><datalist id=\"scheduleRangeDataList\">";
		if(schedulePathnameList !== null) {
			for(i=0; i < scheduleDurationList.length; i++)
			{ 
				paneTitle += "<option value=\"" + scheduleDurationList[i] + "\">";
			}
		}
		paneTitle += "</datalist>";
		
	} catch {}
	
	var paneContent = "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting Schedule Info ...</span></div>";
	document.getElementById("main-Header").innerHTML = paneTitle;
	document.getElementById("main").innerHTML = paneContent;
	if(mode === 6)
		return;
	if(schedulesList !== null) {
		if(schedulesList.length > 0) {
			getSchedulesResponse(1, "", schedulesList);
			return;
		}
	}
	getSchedules("")
}
function showSchedulesByName(path, programmaticPathname) {
	var i, z = -1, obj;
	if(path !== g_sSchedulePathname)
		schedulesList = [];
	g_sSchedulePathname = path;
	if(path.indexOf("/") !== -1) {
		for(i=0; i < g_scheduleUrlDpXifList.length; i++)
		{
			if(g_scheduleUrlDpXifList[i].dpPath === path) {
				z = i;
				break;
			}
		}
		if(z === -1) {
			obj = {};
			obj.dpPath = path;
			obj.dpProgrammaticPath = programmaticPathname;
			g_scheduleUrlDpXifList.push(obj);
		}
	}


	showSchedule1(6);
	document.getElementById("schedulesLabel").innerHTML = "Schedules For: " + path;

	getSchedules("");
}
function showSchedulesRefresh(mode) {
	try {
		var paneContent = "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting Schedule Info ...</span></div>";
		if(mode === 0) {
			g_sSchedulePathname = "";
		}
		//g_sSchedulePathname = document.getElementById("schedulepath").value;
		//g_sScheduleRange = document.getElementById("scheduleRange").value;
		schedulesList = [];
		document.getElementById("main").innerHTML = paneContent;
		showSchedules();
	} catch {}
}  
function showServicePinMessages(mode) {
	var i;
	var paneContent = "";
	var paneTitle = "<label id=\"displayLabel\">Service Pins</label>";
	savePrevousHtmlContent();
	initializeDisplay();
	
	g_iMainDisplayMode = DISPLAYMODE_SERVICEPIN;
	paneTitle += "<div style=\"float:right\">"
	paneTitle += "<input type=\"checkbox\" id=\"servicePinDisplayTypeCheckbox\" onclick=\"showServicePinMessagesDisplayTypeCheckBox()\"";
	if(g_bServicePinShowNewDevicesOnly)
		paneTitle += " checked"
	paneTitle += ">Hide Duplicate UIDs";
	paneTitle += "<button onclick=\"saveData(0)\">Save</button>";
	paneTitle += "<button onclick=\"showServicePinMessagesClear()\" >Clear History</button>";
	paneTitle += "</div>"
	
	//paneContent = "<div><br><textarea id=\"servicepin\" rows=30 ></textarea></div>";
	paneContent = "<div><br><table id=\"servicepinTable\"><thead><tr><th>#</th><th>Time</th><th>UID</th><th>Type</th><th>Program Id</th><th>Protcol</th></thead><tbody></tbody></table></div>";
	document.getElementById("main-Header").innerHTML = paneTitle;  
	document.getElementById("main").innerHTML = paneContent;
	//document.getElementById("servicepin").value += "waiting for Service Messages (Service Pin)";
	if(deviceTypeList.length === 0) {
		var	url = "https://" + location.hostname + "/iap/devTypes/*?short=false&sortBy=name&sortOrder=asc";
		requestGetData(5, url, getDeviceTypesResponse, showServicePinMessagesDeviceTypesFailure);
	}
	else 
		showServicePinMessagesHistory();
	
	
}
function showServicePinMessagesDeviceTypesFailure(mode, requestUrl, json) {
	showServicePinMessagesHistory();
}
function showServicePinMessagesHistory() { 
	try {
		var i,j,z,objList = []; 
		if(g_iMainDisplayMode === DISPLAYMODE_SERVICEPIN) {
			var table = document.getElementById("servicepinTable");
			table.innerHTML = "<thead><tr><th>#</th><th>Time</th><th>UID</th><th>Type</th><th>Program Id</th><th>Protcol</th></thead><tbody></tbody>";
			if(ivWsServicePinMessageHistory !== null) {
				for(i=0; i < ivWsServicePinMessageHistory.length; i++)
				{
					z = -1;
					if(g_bServicePinShowNewDevicesOnly) {
						for(j=0; j < objList.length; j ++)
						{
							if(ivWsServicePinMessageHistory[i].serviceMessage.uid == objList[j]) {
								z = j;
								break;
							}
						}

					}
					if(z === -1) {
						objList.push(ivWsServicePinMessageHistory[i].serviceMessage.uid);
						showServicePinMessagesTableRow(0, ivWsServicePinMessageHistory[i]);
					}
				}
			}
			
		}
	} catch {}
	ivbWsSaveServicePinShowMessage = true;
}
function showServicePinMessagesTableRow(mode, json) {
	try {
		var i, j, z;
		if(g_iMainDisplayMode === DISPLAYMODE_SERVICEPIN) {
			
			if(!((typeof json.timestamp === "undefined") || (typeof json.serviceMessage === "undefined"))) {
				//document.getElementById("servicepin").value += "\r\n\r\n" + json.timestamp + ": " + JSON.stringify(json.serviceMessage);
				var i;
				var temp = "Unknown";
				var x = document.getElementById("servicepinTable").rows.length
				var table = document.getElementById("servicepinTable");
				var row;
				var cell1;
				var cell2;
				var cell3;
				var cell4;
				var cell5;
				var cell6;
				z = -1;
				if(mode === 1) {
					for(j=1; j < ivWsServicePinMessageHistory.length; j ++)
					{
						if(ivWsServicePinMessageHistory[j].serviceMessage.uid == json.serviceMessage.uid) {
							z = j;
							break;
						}
					}
				}
				if(z === -1) {
					row = table.insertRow(1);
					cell1 = row.insertCell(0);
					cell2 = row.insertCell(1);
					cell3 = row.insertCell(2);
					cell4 = row.insertCell(3);
					cell5 = row.insertCell(4);
					cell6 = row.insertCell(5);
					cell1.innerHTML = x;
					cell2.innerHTML = json.timestamp;
					cell3.innerHTML = json.serviceMessage.uid
					try {
						for(i=0; i < deviceTypeList.length; i++)
						{
							if(deviceTypeList[i].programId === json.serviceMessage.type) {
								temp = deviceTypeList[i].name;
								break;
							}
						}
					}
					catch {}
					cell4.innerHTML = temp;
					cell5.innerHTML = json.serviceMessage.type;
					cell6.innerHTML = json.serviceMessage.protocol;
				}
			}
		}

	}
	catch {}
}
function showServicePinMessagesClear() {
	try {
		var paneContent = "<div><br><table id=\"servicepinTable\"><thead><tr><th>#</th><th>Time</th><th>UID</th><th>Type</th><th>Program Id</th><th>Protcol</th></thead><tbody></tbody></table></div>";
		ivWsServicePinMessageHistory = [];
		//document.getElementById("servicepin").value += "waiting for Service Messages (Service Pin)";
		
		document.getElementById("main").innerHTML = paneContent;
	}
	catch {}
}
function showServicePinMessagesDisplayTypeCheckBox() {
	if(document.getElementById("servicePinDisplayTypeCheckbox").checked)
		g_bServicePinShowNewDevicesOnly = true;
	else 
		g_bServicePinShowNewDevicesOnly = false;
		showServicePinMessagesHistory();
}
function showSmartServerStorage(mode, pathname, id) {
	showDpInfo1(2, pathname,"");
}


function smartSortTable(dir, col1, col2, col3) {
	// mode: 0=single column, 1 = sort multiple columes 1st device name --> 2nd block name/blockindex --> 3rd datapoint name
	// 
	try {
		var table, rows, switching, i, x, y, shouldSwitch, switchcount = 0;
		
		table = document.getElementById("myTable");
		switching = true;
		// Set the sorting direction to ascending:
		if(dir === "")
			dir = "asc";
		/* Make a loop that will continue until
		no switching has been done: */
		while (switching) {
			// Start by saying: no switching is done:
			switching = false;
			rows = table.rows;
			/* Loop through all table rows (except the
			first, which contains table headers): */
			for (i = 1; i < (rows.length - 1); i++) {
			// Start by saying there should be no switching:
			shouldSwitch = false;
			/* Get the two elements you want to compare,
			one from current row and one from the next: */
			x = rows[i].getElementsByTagName("TD")[col1].innerHTML;
			if	(col2 !== null) { 
				if (col2 !== "") {
					x += "/" + rows[i].getElementsByTagName("TD")[col2].innerHTML;
				}
			}
			if	(col3 !== null) {
				if (col3 !== "") {
					x += "/" + rows[i].getElementsByTagName("TD")[col3].innerHTML;
				}
			}
			y = rows[i + 1].getElementsByTagName("TD")[col1].innerHTML;
			if	(col2 !== null) {  
				if(col2 !== "") {
					y += "/" + rows[i + 1].getElementsByTagName("TD")[col2].innerHTML;
				}
			}
			if	(col3 !== null) { 
				if (col3 !== "") {
					y += "/" + rows[i + 1].getElementsByTagName("TD")[col3].innerHTML;
				}
			}
			/* Check if the two rows should switch place,
			based on the direction, asc or desc: */
			if (dir === "asc") {
				if (x.toLowerCase() > y.toLowerCase()) {
				// If so, mark as a switch and break the loop:
				shouldSwitch = true;
				break;
				}
			} else if (dir === "desc") {
				if (x.toLowerCase() < y.toLowerCase()) {
				// If so, mark as a switch and break the loop:
				shouldSwitch = true;
				break;
				}
			}
			}
			if (shouldSwitch) {
			/* If a switch has been marked, make the switch
			and mark that a switch has been done: */
			rows[i].parentNode.insertBefore(rows[i + 1], rows[i]);
			switching = true;
			// Each time a switch is done, increase this count by 1:
			switchcount ++;
			} else {
			/* If no switching has been done AND the direction is "asc",
			set the direction to "desc" and run the while loop again. */
			if (switchcount === 0 && dir === "asc") {
				dir = "desc";
				switching = true;
			}
			}
		}
	} catch {}
}
function sortDeviceList(mode, deviceList) {
	var newDeviceList = [];
	var result = {};
	var newList = [];
	var iPtr;
	result.valid = false;
	result.deviceList = [];

	try {
		newDeviceList = JSON.parse(JSON.stringify(deviceList));
		for(i=0; i < newDeviceList.length; i++)
		{
			z = -1;
			for(j=0; j < newList.length; j++)
			{
				if(newDeviceList[i].category === "SC") {
					if(newList[j].programId === "SmartServer IoT") {
						z = j;
						break;
					}
				}
				else if(newList[j].programId === newDeviceList[i].programId) {
					z = j;
					break;
				}
			}
			if(z === -1) {
				obj = {};
				if(newDeviceList[i].category === "SC") {
					obj.programId = "SmartServer IoT";
					obj.deviceTypeName = "SmartServer IoT";
				}
				else {
					obj.programId = newDeviceList[i].programId;
					obj.deviceTypeName = newDeviceList[i].deviceTypeName;
					iPtr = obj.deviceTypeName.indexOf("-");
					if(iPtr !== -1) {
						obj.deviceTypeName = obj.deviceTypeName.substr(0, iPtr);
					}
				}
				obj.deviceList = [];
				newList.push(obj);
				z = newList.length - 1;
			}
			if(z !== -1) {
				newList[z].deviceList.push(JSON.parse(JSON.stringify(newDeviceList[i])));
			}
		}
		for(i=0; i < newList.length; i++)
		{
			bContinue = true;
			while(bContinue)
			{
				bContinue = false;
				for(j=0; j < (newList[i].deviceList.length - 1); j++)
				{
					if((newList[i].deviceList[j].name + " ").toLowerCase() > (newList[i].deviceList[j + 1].name + " ").toLowerCase()) {  
						tempObj = {};
						tempObj = JSON.parse(JSON.stringify(newList[i].deviceList[j + 1]));
						newList[i].deviceList[j + 1] = JSON.parse(JSON.stringify(newList[i].deviceList[j]));
						newList[i].deviceList[j] = tempObj;
						bContinue = true;
					}
				}
			}
		}
		result.deviceList = newList;
		result.valid = true;
	}
	catch {
		result.valid = false;
		result.deviceList = [];
	}
	return result;
}
function sortTable(col) {
	sortTable1("myTable", col);
}
function sortTable1(tableName, col) {

	var table = null, rows, switching, i, x, y, shouldSwitch, dir, switchcount = 0, xValue, yValue, iCount = 0;
	var dpCheckCount = 0;
	var maxDpCheckCount = 1000000;
	
	try {
		if(g_bMouseTableResizeActive)
			return; // table column resize in progress, so ignore
		table = document.getElementById(tableName);
		if(table === null)
			return;
		table.style.cursor = "wait";
		switching = true;
		// Set the sorting direction to ascending:
		dir = "asc";
		/* Make a loop that will continue until
		no switching has been done: */
		while (switching) {
			// Start by saying: no switching is done:
			switching = false;
			iCount ++;
			rows = table.rows;
			/* Loop through all table rows (except the
			first, which contains table headers): */
			for (i = 1; i < (rows.length - 1); i++) {
				// Start by saying there should be no switching:
				dpCheckCount ++;
				shouldSwitch = false;
				/* Get the two elements you want to compare,
				one from current row and one from the next: */
				x = rows[i].getElementsByTagName("TD")[col];
				y = rows[i + 1].getElementsByTagName("TD")[col];
				xValue = x.innerHTML;
				yValue = y.innerHTML;

				if(!isNaN(xValue) && !isNaN(yValue)) {
					if (dir === "asc") {
						if(Number(xValue) > Number(yValue))
							shouldSwitch = true;
					}
					else {
						if(Number(xValue) < Number(yValue))
							shouldSwitch = true;
					}
				}
				else {
					if (dir === "asc") {
						if(xValue.toLowerCase() > yValue.toLowerCase())
							shouldSwitch = true;
					}
					else {
						if(xValue.toLowerCase() < yValue.toLowerCase())
							shouldSwitch = true;
					}
				}
				if (shouldSwitch) {
					/* If a switch has been marked, make the switch
					and mark that a switch has been done: */
					rows[i].parentNode.insertBefore(rows[i + 1], rows[i]);
					switching = true;
					// Each time a switch is done, increase this count by 1:
					switchcount ++;
				}
			}
			if (iCount === 1) {
				if(!switching) {
					/* If a switch has been marked, make the switch
					and mark that a switch has been done: */
					if (switchcount === 0 && dir === "asc") {
						dir = "desc";
						switching = true;
						// fix as this is already sorted asc just swap the rows as it may be just one swap
					}
				}
			}
			//if(switching) {
			//	if(dpCheckCount > maxDpCheckCount) {
					// need to break up 
					//setTimeout(function() {sortTable1(tableName, col);},200);
			//	}
			//}
		}
	} catch {}
	if(table !== null)
		table.style.cursor = "default";
	
  }
  function sortTableNumber() {
	  try {
		var table, rows, switching, i, x, y, shouldSwitch;
		table = document.getElementById("myTable");
		switching = true;
		/*Make a loop that will continue until
		no switching has been done:*/
		while (switching) {
		//start by saying: no switching is done:
		switching = false;
		rows = table.rows;
		/*Loop through all table rows (except the
		first, which contains table headers):*/
		for (i = 1; i < (rows.length - 1); i++) {
			//start by saying there should be no switching:
			shouldSwitch = false;
			/*Get the two elements you want to compare,
			one from current row and one from the next:*/
			x = rows[i].getElementsByTagName("TD")[0];
			y = rows[i + 1].getElementsByTagName("TD")[0];
			//check if the two rows should switch place:
			if (Number(x.innerHTML) > Number(y.innerHTML)) {
			//if so, mark as a switch and break the loop:
			shouldSwitch = true;
			break;
			}
		}
		if (shouldSwitch) {
			/*If a switch has been marked, make the switch
			and mark that a switch has been done:*/
			rows[i].parentNode.insertBefore(rows[i + 1], rows[i]);
			switching = true;
		}
		}
	} catch {}
 }
function startNextRequest()
{
	try {
		if(g_bPollingEnabled) {
			if(g_bShowPollIntervalInConsole) {  // show how often poll request gets out
				g_dtPollEndDate= new Date();
				var seconds = (g_dtPollEndDate.getTime() - g_dtPollStartDate.getTime()) / 1000;
				//console.log("Get Request poll interval = " + seconds + " s");
				g_dtPollStartDate = new Date();
			}
			


			getOnDemandDpValues(3, "")
		}
			
	} catch (err) {}
}
function subscribeRequest() {  
	// used to speed up 
	// see if any of the datapoints have a category of d2
	if(g_sWebSocketSubscribePayload === "")
		return;
	var url = "https://" + location.hostname; // + ":8443";
		url += "/iap/dp/updates/subscribe";
	g_iAutoSubscribeCount = 0
	g_iAutoSubscribeCountRequestIndex ++; // distributes subscribe so if there is more than one datapoint request that eventually all datapoints get read 
	if(g_iAutoSubscribeCountRequestIndex >= g_dpGetRequestArr.length)
		g_iAutoSubscribeCountRequestIndex = 0;
	g_sWebSocketSubscribePayload_oldvalue =	g_sWebSocketSubscribePayload;
	var Rsp = requestPutData(0, url, g_sWebSocketSubscribePayload,  ivSubScribeCallback, null); 

}
function ivSubScribeCallback(mode, requestUrlString, json){
	g_bNeedToSubscribe = false;
	
}
function tableCreateResizableTable(tableid) {
	// used to provide table column re
	let table;
	if(tableid === null)
		return;
	if(tableid === "")
		return;	
	table = document.getElementById(tableid);
	if(table === null)
		return;
		const cols = table.querySelectorAll('th');
	[].forEach.call(cols, function (col) {
		// Add a resizer element to the column
		const resizer = document.createElement('div');
		resizer.classList.add('tableColumnResizer');

		// Set the height
		resizer.style.height = `${table.offsetHeight}px`;

		col.appendChild(resizer);

		tableCreateResizableColumn(col, resizer);
	});

}

function tableCreateResizableColumn(col, resizer) {
	let x = 0;
	let w = 0;

	const mouseDownHandler = function (e) {
	x = e.clientX;

		const styles = window.getComputedStyle(col);
		w = parseInt(styles.width, 10);

		document.addEventListener('mousemove', mouseMoveHandler);
		document.addEventListener('mouseup', mouseUpHandler);

		resizer.classList.add('tableColumnResizing');
	};

	const mouseMoveHandler = function (e) {
		const dx = e.clientX - x;
		col.style.width = `${w + dx}px`;
	};

	const mouseUpHandler = function () {
		resizer.classList.remove('tableColumnResizing');
		document.removeEventListener('mousemove', mouseMoveHandler);
		document.removeEventListener('mouseup', mouseUpHandler);
	};

	resizer.addEventListener('mousedown', mouseDownHandler);
}
function testAllDevices(mode) {
	// test all provisioned devices
	// mode: 0=from test button, 1=check if test already in progress
	var divXOffset = -200;
	var divYOffset = 50;
	var divWidth = 400;
	
	var menuButton = document.getElementById("testAllDevices");
	var testDiv = document.getElementById("testAllDiv");
	var sTemp, i, j, x, y, offsets, bContinue, sUid, iTemp, iTemp1, unprovisioned = 0;
	var d = new Date();
	
	var content = "";

	try { //55555
		if(g_iMainDisplayMode !== DISPLAYMODE_ALLDEVICES)
			return;
		if(deviceListAll.length === 0) {
			showAlertDialog(0,"Aborted - No Devices ");
			return;
		}
		testDiv.className = "testDivShowPlanningTree";
		if(mode ===1) {
			if(!g_bTestDevicesAlreadyStarted)
				return;
		}
		else {
			if(g_bTestDevicesAlreadyStarted) {
				showAlertDialog(0,"Test All Devices Already in Progress");
				return;
			}
		}
		if((mode === 0)  && (!g_bTestDevicesAlreadyStarted)) {
			g_testDevicesList = [];
			g_testallDeviceFailList = [];
			g_iTestDevices_Total = 0;
			g_iTestDevices_TotalEdgeDevices = 0;
			g_iTestDevices_Uprovisioned = 0;
			g_iTestDevices_Down = 0;
			g_testDevices_IOX = 0;
			g_testDevices_IOX_UnProvisioned = 0;
			for(i=0; i < deviceListAll.length; i ++)
			{
				if(deviceListAll[i].category.toLowerCase() === "edge") {
					g_iTestDevices_Total ++;
					/*
					if((deviceListAll[i].protocol === "iap") && deviceListAll[i].name.startsWith("iox") 
						&& (deviceListAll[i].name.endsWith(".dio") || deviceListAll[i].name.endsWith(".sys") || deviceListAll[i].name.endsWith(".meter")) ) {
						g_testDevices_IOX ++;
						if(deviceListAll[i].status.state !== "provisioned")
							g_testDevices_IOX_UnProvisioned ++;
					}
					else 
					*/
					if(g_bTestDevices_provisionedDevicesOnly) {
						if(deviceListAll[i].status.state === "provisioned") {
							g_iTestDevices_TotalEdgeDevices ++;
							g_testDevicesList.push(JSON.parse(JSON.stringify(deviceListAll[i])));
							g_testDevicesList[g_testDevicesList.length - 1].result = 0;
						}
						else 
							unprovisioned ++;
					}
					else {
						if(deviceListAll[i].status.state !== "provisioned")
							unprovisioned ++;
						// remove any with "" or all zeros
						if(deviceListAll[i].uid !== "") {
							sUid = deviceListAll[i].uid;
							for(j = 0; j < sUid.length; j++)
							{
								if(sUid.charAt(j) !== "0") {
									g_iTestDevices_TotalEdgeDevices ++;
									g_testDevicesList.push(JSON.parse(JSON.stringify(deviceListAll[i])));
									g_testDevicesList[g_testDevicesList.length - 1].result = 0;
									break;
								}
							}
						}
					}
				}
			}
		}
		
		if(testDiv !== null) {
			sTemp = "Test All Devices\r\n\r\nProvisioned Devices = " + g_testDevicesList.length + "/" + deviceListAll.length;
			sTemp += "\r\n\r\nTest Time (approximately) = " + (g_testDevicesList.length * 8).toString() + "s";
			sTemp += "\r\nPress OK to continue or Cancel to Abort";
			if(mode === 0) {
				bContinue = true; //confirm(sTemp);
			}
			if((mode === 1) || ((mode === 0) && bContinue)) {
				
				if((mode === 0) && (!g_bTestDevicesAlreadyStarted)) {
					//g_bTestDevicesAlreadyStarted = true;
					g_iTestDevices_Tested = -1;
					g_bTestDevicesInProgress = 1;
					g_iTestDevices_Passed = 0;
					g_iTestDevices_Failed = 0;
					g_iTestDeviceTestTimeMs = 0;
					g_iTestDevicesPaused = 0;
					
					g_iTestDevices_RestTimeout = 0;
					g_iTestDevices_QueryStatusFailed = 0;
				}
				if(mode === 1) {
					if(g_iTestDevices_Tested > (g_iTestDevices_Passed + g_iTestDevices_Uprovisioned + g_iTestDevices_Failed)) {
						g_iTestDevices_Tested --; // don't have results for last device tested
					}
				}
				g_iTestDevices_StartTimeStampMs = d.getTime();
				content = "<div id=\"testAllDivContent\"><div id=\"testAllDivBorder\"><hr><hr><div style=\"text-align:center\">Test All Devices (Manage Test)</div><hr><hr>";
				//content += "<span id=\"testDeviceName\">" + deviceName + "</span><hr>";
				content += "<span id=\"testAllDeviceResultsTitle\">";
				if(g_bTestDevicesAlreadyStarted) {
					if(g_iTestDevices_Passed === 1)
						content += "....Testing Paused. ...."
					else
						content += "....Testing ...."
				}
				else
					content += ".... Press Start Button to Start ....";

				content += "</span><hr><br>";
				
				content += "<input type=\"radio\" id=\"testDevices_provisionedDevicesOnly_1\" name=\"testDevices_provisionedDevices\" onclick=\"testDevicesProvisionedDevicesOnly(this.value)\" value=\"1\"";
				if(!g_bTestDevices_provisionedDevicesOnly)
					content += " checked";
				content += ">All Devices";
				content += "<input type=\"radio\" id=\"testDevices_provisionedDevicesOnly_2\" name=\"testDevices_provisionedDevices\" onclick=\"testDevicesProvisionedDevicesOnly(this.value)\" value=\"2\"";
				if(g_bTestDevices_provisionedDevicesOnly)
					content += " checked";
				content += ">Provisioned only";




				content += "<br><br>Total Edge Devices: <span id=\"testDeviceTotal\">" + g_iTestDevices_Total + "</span>";
				content += "<br>Un-Provisioned Devices: <span>" + unprovisioned + "</span>";
				/*
				content += "<br>IOX Devices (not Tested): <span id=\"testDeviceIox\">" + g_testDevices_IOX + "</span>";
				content += "<br><span style=\"margin-left:20px\">IOX un-provisioned: </span> <span id=\"testDeviceIox\">" + g_testDevices_IOX_UnProvisioned + "</span>"; */
				content += "<br><br>Devices Testing: <span id=\"testDeviceTesting\">" +  g_iTestDevices_TotalEdgeDevices + "</span>";
				content += "<br><br>Devices To Test: <span id=\"testDeviceToTest\">";
				if(mode === 0)
					content +=  g_iTestDevices_TotalEdgeDevices;
				else
					content +=  (g_iTestDevices_TotalEdgeDevices - (g_iTestDevices_Passed + g_iTestDevices_Failed)).toString();
				content += "</span>";
				content += "<br>Devices Tested: <span id=\"testDeviceTested\">" + (g_iTestDevices_Passed + g_iTestDevices_Failed).toString() + "</span>";
				content += "<br><span style=\"margin-left:20px\">Pass: </span><span id=\"testDeviceTestingPassed\">" + g_iTestDevices_Passed + "</span>";
				content += "<br><span style=\"margin-left:20px\">Failed: </span><span id=\"testDeviceTestingFailed\">" + g_iTestDevices_Failed + "</span>";
				content += "<br><span style=\"margin-left:40px\">Down: </span><span id=\"testDeviceTestingDown\">" + g_iTestDevices_Down + "</span>";
				content += "<br><span style=\"margin-left:40px\">Unprovisioned: </span><span id=\"testDeviceTestingUnprovisioned\">" + g_iTestDevices_Uprovisioned + "</span>";
				content += "<br><span style=\"margin-left:40px\">No Response: </span><span id=\"testDeviceTestingFailedQueryStatusTimeout\">" + g_iTestDevices_QueryStatusFailed  + "</span>";
				content += "<br><span style=\"margin-left:40px\">Timeout: </span><span id=\"testDeviceTestingFailedRestTimeout\">" + g_iTestDevices_RestTimeout + "</span>";
				
				
				
				
				content += "<br><br>Test time (less than ";
				iTemp = g_testDevicesList.length * 8;
				if(iTemp > 120) 
					content += (iTemp / 60).toFixed(2) + " m";
				else
					content += iTemp.toString() + " s";
				content += "): <span id=\"testAllDevicesTestTime\">" + (g_iTestDeviceTestTimeMs / 1000).toFixed(0) + "</span>"
				content += "<div id=\"testAllDeviceClose\"><br><br><button id=\"testAllDevicesPause\" onclick=\"testAllDevicesPause()\"";
				if(g_iTestDevices_TotalEdgeDevices === 0)
					content += " disabled";
				content += ">";
				if(g_iTestDevicesPaused === 0)
					content += "Start";
				else if(g_iTestDevicesPaused === 1)
					content += "Pause";
				else if(g_iTestDevicesPaused === 2)
					content += "Continue";
				
				content += "</button><button onclick=\"testDeviceAllCancel()\">Close</button></div><br>";
				//content += "<hr>Problem Devices:";
				content += "<div id=\"testDevicesProblemDevices\" ></div>";
				content += "</div></div>";
				testDiv.innerHTML = content;
				testDiv.className = "testDivShowAll";
				if(menuButton !== null) {
					
					offsets = menuButton.getBoundingClientRect(); 
					iTemp = offsets.x + offsets.width + window.pageXOffset + divWidth;
					iTemp1 = window.pageXOffset + window.innerWidth;
					if(iTemp > iTemp1) 
						x = offsets.x + window.pageXOffset - divWidth - 10; // takes into account viewport (scrolling)
					else
						x = offsets.x + offsets.width + window.pageXOffset + divXOffset; // takes into account viewport (scrolling)
					y = offsets.y + window.pageYOffset + divYOffset; // takes into account viewport (scrolling)
					
					document.getElementById("testAllDiv").style.left = x.toString() + "px";
					document.getElementById("testAllDiv").style.top = y.toString() + "px";
				}
				if(g_bTestDevicesAlreadyStarted) {
					g_bTestDevicesInProgress = true;
					if(g_iTestDevicesPaused !== 0)
						testAllDevicesTest();
				}
			}
			else 
				g_testDevicesList = [];
		}
	}
	catch {}
}
function testAllDevicesCancel() {
	g_bTestDevicesAlreadyStarted = false;
	g_bTestDevicesInProgress = false;
	g_iTestDevicesPaused = 0;
	testDeviceCancel();
}
function testAllDevicesTest() {
	var	url, payload, Rsp, id, i, notTested = 0, content = "", d, sTemp, sTemp1, iTemp;
	try {
		if(!g_bTestDevicesInProgress)
			return;
		if(g_iMainDisplayMode !== DISPLAYMODE_ALLDEVICES)
			return;
		g_iTestDevices_Tested ++;
		d = new Date();
		if(g_iTestDevices_Tested > (deviceListAll.length + 1)) {
			g_bTestDevicesInProgress = false;
		}
		else if(g_iTestDevices_Tested >= g_iTestDevices_TotalEdgeDevices) {
			// tests done
			g_bTestDevicesInProgress = false;
			document.getElementById("testAllDeviceResultsTitle").innerHTML = "Test Completed";
			document.getElementById("testDeviceTested").innerHTML =  g_iTestDevices_Tested;
			document.getElementById("testDeviceTestingPassed").innerHTML =  g_iTestDevices_Passed;
			document.getElementById("testDeviceTestingUnprovisioned").innerHTML =  g_iTestDevices_Uprovisioned;
			document.getElementById("testDeviceTestingFailed").innerHTML =  g_iTestDevices_Failed;
			document.getElementById("testDeviceTestingFailedQueryStatusTimeout").innerHTML = g_iTestDevices_QueryStatusFailed;
			document.getElementById("testDeviceTestingFailedRestTimeout").innerHTML =  g_iTestDevices_RestTimeout;
			document.getElementById("testDeviceTestingDown").innerHTML = g_iTestDevices_Down;
			document.getElementById("testAllDevicesPause").style.visibility = "hidden";
			document.getElementById("testDeviceToTest").innerHTML = g_iTestDevices_TotalEdgeDevices - g_iTestDevices_Tested; //44444
			iTemp = ((d.getTime() - g_iTestDevices_StartTimeStampMs) + g_iTestDeviceTestTimeMs) / 1000;
			if(iTemp > 120)
				sTemp = (iTemp / 60).toFixed(0) + " m";
			else 
				sTemp = iTemp.toFixed(0) + " s";
			document.getElementById("testAllDevicesTestTime").innerHTML = sTemp;
			content += "<hr>Problem Devices:   <button onclick=\"saveData(8)\">Save</button><br><div style=\"overflow:auto;max-height:200px\">";
			sTemp = "";
			sTemp1 = "";
			/*
			for(i=0; i < g_testDevicesList.length; i++)
			{
				if(g_testDevicesList[i].result === 2) {
					sTemp1 += "<tr><td>" + (i+1).toString() + "</td><td>" + g_testDevicesList[i].name + "</td><td>" + g_testDevicesList[i].protocol + "</td></tr>";
					//content += "<br>" + g_testDevicesList[i].name + " [" + g_testDevicesList[i].protocol + "]";
				}
				else if(g_testDevicesList[i].result === 0) {
					notTested ++;
				}
			}
			if(sTemp1 !== "") {
				 
				sTemp = "<table id=\"myTable\"><thead><tr><th onclick=\"sortTable(0)\">#</th><th onclick=\"sortTable(1)\">Device Name</th>";
				sTemp += "<th onclick=\"sortTable(2)\">Protocol</th></tr></thead><tbody>" + sTemp1 + "</tbody></table>";
			}
			*/
			if(notTested > 0) {
				if(sTemp !== "")
					sTemp += "<br><br>";
				sTemp += "<hr><br>Note Tested:";
				sTemp1 = "";
				for(i=0; i < g_testDevicesList.length; i++)
				{
					if(g_testDevicesList[i].result === 0) {
						sTemp1 += "<tr><td>" + (i+1).toString() + "</td><td>" + g_testDevicesList[i].name + "</td><td>" + g_testDevicesList[i].protocol + "</td></tr>";
						//content += "<br>" + g_testDevicesList[i].name + " [" + g_testDevicesList[i].protocol + "]";
					}
					
				}
				if(sTemp1 !== "") {
					sTemp += "<table id=\"myTable2\"><thead><tr><th onclick=\"sortTable('myTable2',0)\">#</th><th onclick=\"sortTable('myTable2',1)\">Device Name</th>";
					sTemp += "<th onclick=\"sortTable('myTable2',2)\">Protocol</th></tr></thead><tbody>" + sTemp1 + "</tbody></table>";
				}
				

			}
			content += sTemp;
			content += "</div>";
			for(i=0; i < g_testallDeviceFailList.length; i++)
			{
				element = document.getElementById("test1_" + g_testallDeviceFailList[i]);
				if(element !== null) {
					element.disabled = false;
				}
			}
			
			//if((g_iTestDevices_Failed > 0) || (notTested > 0))
			if(notTested > 0)
				document.getElementById("testDevicesProblemDevices").innerHTML += content;
		}
		else 
		{
			
			document.getElementById("testDeviceTested").innerHTML =  g_iTestDevices_Passed + g_iTestDevices_Failed;
			document.getElementById("testDeviceTestingPassed").innerHTML =  g_iTestDevices_Passed;
			document.getElementById("testDeviceTestingFailed").innerHTML =  g_iTestDevices_Failed;
			document.getElementById("testDeviceTestingDown").innerHTML = g_iTestDevices_Down;
			document.getElementById("testDeviceTestingFailedQueryStatusTimeout").innerHTML = g_iTestDevices_QueryStatusFailed;
			document.getElementById("testDeviceTestingFailedRestTimeout").innerHTML =  g_iTestDevices_RestTimeout;
			document.getElementById("testDeviceToTest").innerHTML = g_iTestDevices_TotalEdgeDevices - g_iTestDevices_Tested;
			iTemp = ((d.getTime() - g_iTestDevices_StartTimeStampMs) + g_iTestDeviceTestTimeMs) / 1000;
			if(iTemp > 120)
				sTemp = (iTemp / 60).toFixed(0) + " m";
			else 
				sTemp = iTemp.toFixed(0) + " s";
			document.getElementById("testAllDevicesTestTime").innerHTML = sTemp;
			id = g_testDevicesList[g_iTestDevices_Tested].id;
			g_sTestDevices_QueryStatusName = "";
			g_iDeviceTestId = id;
			url = "https://" + location.hostname + "/iap/devs/" + id + "/test";
			payload = "{\"ID\":" + id + "}"; 
			Rsp = requestPutData(0, url, payload,  null, null); 
			try {
				if(g_iTestDevicesTimerId !== null)  
					clearTimeout(g_iTestDevicesTimerId);
				g_iTestDevicesTimerId = window.setTimeout("testDeviceAllTimeout()", g_iTestDeviceAllTimeout); 
			} catch (err) {} 
			// test results are processed in 
			// webSocketDeviceTestResultUpdate()
		}
	}
	catch {}
}
function testAllDevicesPause() {
	var i;
	var element = document.getElementById("testAllDevicesPause");
	var element1 = document.getElementById("testAllDeviceResultsTitle");
	var d = new Date();
	if((element !== null) && (element1 !== null)) {
		if(g_iTestDevicesPaused === 0) {
			g_iTestDevicesPaused = 2;
			g_bTestDevicesAlreadyStarted = true;
			g_bTestDevicesPaused = false; 
			g_bTestDevicesInProgress = true;
			element.innerText = "Pause";
			element1.innerHTML = "....Testing ....";
			if(g_iTestDevices_Tested > (g_iTestDevices_Passed + g_iTestDevices_Failed)) {
				g_iTestDevices_Tested --;
				
			}
			g_iTestDevices_StartTimeStampMs = d.getTime();
			testAllDevicesTest();
		}
		else if (g_iTestDevicesPaused === 1) {
			//continue
			if(g_iDeviceTestDeviceName !== "") {
				showAlertDialog(1, "Managed Test for single device in progress -- cancel or close and try again.")
				//alert("Managed Test for single device in progress -- cancel or close and try again.");
				return;
			}

			g_iTestDevicesPaused = 2; 
			
			element.innerText = "Pause";
			element1.innerHTML = "....Testing ....";
			if(g_iTestDevices_Tested > (g_iTestDevices_Passed + g_iTestDevices_Failed)) {
				g_iTestDevices_Tested --;
				
			}
			for(i=0; i < g_testallDeviceFailList.length; i++)
			{
				element = document.getElementById("test1_" + g_testallDeviceFailList[i]);
				if(element !== null) {
					element.disabled = true;
				}
			}
			g_iTestDevices_StartTimeStampMs = d.getTime();
			g_bTestDevicesInProgress = true;
			testAllDevicesTest();
		}
		else if (g_iTestDevicesPaused === 2) {
			// paused
			g_iTestDevicesPaused = 1; 
			g_bTestDevicesInProgress = false;
			element.innerText = "Continue";
			element1.innerHTML = ".... Testing Paused ....";
			for(i=0; i < g_testallDeviceFailList.length; i++)
			{
				element = document.getElementById("test1_" + g_testallDeviceFailList[i]);
				if(element !== null) {
					element.disabled = false;
				}
			}
			if(g_iTestDevicesTimerId !== null)  {
				clearTimeout(g_iTestDevicesTimerId);
				g_iTestDevicesTimerId = null;
			}
			g_iTestDeviceTestTimeMs += d.getTime() - g_iTestDevices_StartTimeStampMs;
		}
	} 
}
function testDevicesProvisionedDevicesOnly(value) {
	try {
		if(value === "1")
			g_bTestDevices_provisionedDevicesOnly = false;
		else 
			g_bTestDevices_provisionedDevicesOnly = true;
		testAllDevices(0);
		
	}
	catch {}
}
	
function testDeviceAllTimeout() {
	var element, table, sTemp, table, row, cell1,cell2,cell3,cell4, cell5;
	if(g_iMainDisplayMode !== DISPLAYMODE_ALLDEVICES)
		return;
	g_iTestDevices_RestTimeout ++;
	if(g_iTestDevicesTimerId !== null) {
		clearTimeout(g_iTestDevicesTimerId);
		g_iTestDevicesTimerId = null;
		if(g_iTestDevices_Tested < (g_testDevicesList.length)) {
			g_testDevicesList[g_iTestDevices_Tested].result = 2;
			g_iTestDevices_Failed ++;
			element = document.getElementById("testDevicesProblemDevices");
			if(element !== null) {
				if(element.innerHTML === "") {
					sTemp = "<table id=\"myTable1\" class=\"testAllTable\"><thead><tr><th onclick=\"sortTable('myTable1',0)\">#</th><th onclick=\"sortTable('myTable1',1)\">Test</th><th onclick=\"sortTable('myTable1',2)\">Device Name</th>";
					sTemp += "<th onclick=\"sortTable('myTable1',3)\">Protocol</th><th onclick=\"sortTable('myTable1',4)\">Failure Type</th></tr></thead><tbody></tbody></table><br>";
					element.innerHTML = sTemp;
				}
				table = document.getElementById("myTable1");
				row = table.insertRow(1);
				cell1 = row.insertCell(0);
				cell2 = row.insertCell(1);
				cell3 = row.insertCell(2);
				cell4 = row.insertCell(3);
				cell5 = row.insertCell(4);
				cell1.innerHTML = (g_iTestDevices_Failed).toString();
				//cell2.innerHTML = "<button>Test</button>";
				g_testallDeviceFailList.push(g_testDevicesList[g_iTestDevices_Tested].name);
				cell2.innerHTML = "<button id=\"test1_" + g_testDevicesList[g_iTestDevices_Tested].name + "\" onclick=\"testDevice(8, this," + g_testDevicesList[g_iTestDevices_Tested].id + ", '" + g_testDevicesList[g_iTestDevices_Tested].name + "')\" disabled>Test</button>";
				document.getElementById("test1_" + g_testDevicesList[g_iTestDevices_Tested].name).disabled = true;
				cell3.innerHTML = "<div class=\"testDivTdAllName\">" + g_testDevicesList[g_iTestDevices_Tested].name + "</div>";
				cell4.innerHTML = g_testDevicesList[g_iTestDevices_Tested].protocol;
				cell5.innerHTML = "Timeout Waiting for response";
				
			}
			testAllDevicesTest();
		}
	}
}
function testDeviceAllWsUpdate(json) {
	var iPassed = 0, state = "timeout"; // 0=failed, 1=passed, 2=unconfigured
	var element, table, sTemp, table, row, cell1,cell2,cell3,cell4, cell5;
	try {
		if(g_iTestDevicesTimerId !== null) {
			clearTimeout(g_iTestDevicesTimerId);
			g_iTestDevicesTimerId = null;
		}
		if(!g_bTestDevicesInProgress)
			return; // testAllDevices
		if(g_testDevicesList[g_iTestDevices_Tested].id === json.deviceId) {
			// test single device
		//if(deviceListAll[i].id === json.deviceId) {
			state = "";
			if(typeof json.results.state !== "undefined") {
				if(json.results.state === "Configured Online") {
					g_iTestDevices_Passed ++;
					iPassed = 1;
				}
				else if(json.results.state === "provisioned") {
					if(typeof json.results.health !== "undefined") {
						if(json.results.health === "normal") {
							g_iTestDevices_Passed ++;
							iPassed = 1;
						}
						else {
							iPassed = 2;
							state = json.results.health;	
							g_iTestDevices_Down ++;
						}
					}
					else {
						iPassed = 2;
						state = "health Not defined";

					}
				}
				else if(json.results.state === "Unconfigured Offline") {
					g_iTestDevices_Uprovisioned ++;
					iPassed = 2;
					state = json.results.state;
				}
				else  {
					
					iPassed = 0;
					state = json.results.state;
				}
			}
			else {
				iPassed = 2;
				state = "State Not defined";
			}
			
			if(iPassed === 1) {
				g_testDevicesList[g_iTestDevices_Tested].result = 1;
				testAllDevicesTest();
			}
			else {
				g_iTestDevices_Failed ++;
				g_testDevicesList[g_iTestDevices_Tested].result = 2;
				element = document.getElementById("testDevicesProblemDevices");
				if(element !== null) {
					if(element.innerHTML === "") {
						sTemp = "<table id=\"myTable1\" class=\"testAllTable\"><thead><tr><th onclick=\"sortTable('myTable1',0)\">#</th><th onclick=\"sortTable('myTable1',1)\">Test</th><th onclick=\"sortTable('myTable1',2)\">Device Name</th>";
						sTemp += "<th onclick=\"sortTable('myTable1',3)\">Protocol</th><th onclick=\"sortTable('myTable1',4)\">Failure Type</th></tr></thead><tbody></tbody></table><br>";
						element.innerHTML = sTemp;
					}
					table = document.getElementById("myTable1");
					row = table.insertRow(1);
					cell1 = row.insertCell(0);
					cell2 = row.insertCell(1);
					cell3 = row.insertCell(2);
					cell4 = row.insertCell(3);
					cell5 = row.insertCell(4);
					cell1.innerHTML = (g_iTestDevices_Failed).toString();
					g_testallDeviceFailList.push(g_testDevicesList[g_iTestDevices_Tested].name);
					cell2.innerHTML = "<button id=\"test1_" + g_testDevicesList[g_iTestDevices_Tested].name + "\" onclick=\"testDevice(8, this," + g_testDevicesList[g_iTestDevices_Tested].id + ", '" + g_testDevicesList[g_iTestDevices_Tested].name + "')\" disabled>Test</button>";
					document.getElementById("test1_" + g_testDevicesList[g_iTestDevices_Tested].name).disabled = true;
					cell3.innerHTML = "<div class=\"testDivTdAllName\">" + g_testDevicesList[g_iTestDevices_Tested].name + "</div>";
					cell4.innerHTML = g_testDevicesList[g_iTestDevices_Tested].protocol;
					if(iPassed === 2)
						cell5.innerHTML = state;
					else
						cell5.innerHTML = state;
				}
				testAllDevicesTest();
			}
		}
		else {
			//ignore for now
		}
		
	}
	catch {}
}
function testDeviceAllWsQueryStatusFailUpdate(json) {
	var messsage = "", element, sTemp, table, row, cell1, cell2, cell3, cell4, cell5;
	try {
		message = json.message;
		if(message === "queryStatus  Device does not respond!") {
			//manage test tries queryStatus twice, so only do something when second queryStatus msg for a specific device is received
			if(g_iDeviceTestDeviceName !== "") {
				//testdevice
				if((g_iMainDisplayMode === DISPLAYMODE_PLANNING) || (g_iMainDisplayMode === DISPLAYMODE_ALLDEVICES)) {
					if(message === "queryStatus  Device does not respond!") {
						if(json.targetType === "DEVICE") {
							sTemp = json.targetName;
							element = document.getElementById("testDeviceResults");
							if(element !== null) 
								element.innerHTML = message;
						}
					}
				}
			}
			else if(g_bTestDevicesInProgress) { 
				//testAllDevices
				if(message === "queryStatus  Device does not respond!") {
					
					if(g_iMainDisplayMode === DISPLAYMODE_ALLDEVICES) {
						if(json.targetType === "DEVICE") {
							if(g_iTestDevicesTimerId !== null)  {
								clearTimeout(g_iTestDevicesTimerId);
								g_iTestDevicesTimerId = null;
							}
							sTemp = json.targetName;
							g_iTestDevices_Failed ++; //44444
							g_iTestDevices_QueryStatusFailed ++;
							g_testDevicesList[g_iTestDevices_Tested].result = 2;
							element = document.getElementById("testDevicesProblemDevices");
							if(element !== null) {
								if(element.innerHTML === "") {
									sTemp = "<table id=\"myTable1\" class=\"testAllTable\"><thead><tr><th onclick=\"sortTable('myTable1',0)\">#</th><th onclick=\"sortTable('myTable1',1)\">Test</th><th onclick=\"sortTable('myTable1',2)\">Device Name</th>";
									sTemp += "<th onclick=\"sortTable('myTable1',3)\">Protocol</th><th onclick=\"sortTable('myTable1',4)\">Failure Type</th></tr></thead><tbody></tbody></table><br>";
									element.innerHTML = sTemp;
								}
								table = document.getElementById("myTable1");
								row = table.insertRow(1);
								
								cell1 = row.insertCell(0);
								cell2 = row.insertCell(1);
								cell3 = row.insertCell(2);
								cell4 = row.insertCell(3);
								cell5 = row.insertCell(4);
								cell1.innerHTML = (g_iTestDevices_Failed).toString();
								g_testallDeviceFailList.push(g_testDevicesList[g_iTestDevices_Tested].name);
								cell2.innerHTML = "<button id=\"test1_" + g_testDevicesList[g_iTestDevices_Tested].name + "\" onclick=\"testDevice(8, this," + g_testDevicesList[g_iTestDevices_Tested].id + ", '" + g_testDevicesList[g_iTestDevices_Tested].name + "')\" disabled>Test</button>";
								document.getElementById("test1_" + g_testDevicesList[g_iTestDevices_Tested].name).disabled = true;
								cell3.innerHTML = "<div class=\"testDivTdAllName\">" + g_testDevicesList[g_iTestDevices_Tested].name + "</div>";
								cell4.innerHTML = g_testDevicesList[g_iTestDevices_Tested].protocol;
								cell5.innerHTML = message;
							}
							testAllDevicesTest();
/*							
							if(sTemp === g_testDevicesList[g_iTestDevices_Tested].name) {
								if(g_sTestDevices_QueryStatusName === "") {
									g_sTestDevices_QueryStatusName = sTemp;
								}
								else if(g_sTestAllDevices_QueryStatusName === sTemp) {
									g_iTestDevices_Failed ++; //44444
									g_sTestDevices_QueryStatusName = "";
									testAllDevicesTest();

								}  
							}  */
						}
					}
				}
			}
		}
	}
	catch {}
}

function testDevice(mode, n, id, deviceName) {
	//mode: 0=, 1=, 2=, 3= same as 0 but don't change position, 4= same as 1 but don't change position, 5=same as 2 but don't change position, 8=same as 0 but testalldevices
	var x,y,bTree = false, bTestAll = false;
	var menuButton = null;
	var offsets;
	var	url = "https://" + location.hostname + "/iap/devs/" + id + "/test";
	var payload = "{\"ID\":" + id + "}"; 
	var content = "<div id=\"testDivContent\"><div id=\"testDivBorder\"><hr><hr><div style=\"text-align:center\">Manage Test</div><hr><hr>";
	content += "<span id=\"testDeviceName\">" + deviceName + "</span><hr>";
	content += "<span id=\"testDeviceResultsTitle\">....Testing ...</span><hr>";
	content += "<br><div id=\"testDeviceResults\">Pings: </div>";
	content += "<div id=\"testDeviceClose\"><br><br><button onclick=\"testDeviceCancel()\">Cancel</button>";
	content += "</div></div></div>";
	document.getElementById("testDiv").innerHTML = content;
	menuCancel();
	document.getElementById("testDiv").className = "testDivShowPlanningTree";
	/*
	if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
		document.getElementById("testDiv").className = "testDivShowPlanningTree";
	*/	
		
	
	if(mode === 8) {
		mode = 0;
		bTestAll = true;
	}
	else {
		// clear testalldevice parameters - not used in this 
		g_testDevicesList = [];
		g_bTestDevicesAlreadyStarted = false;
	}

	if(mode === 6) {
		mode = 0;
		bTree = true;
	}
	if(mode <= 2) {
		if(bTestAll)
			menuButton = document.getElementById("test1_" + deviceName);
		else if(bTree)
			menuButton = document.getElementById("testButton_" + deviceName);
		else
			//menuButton = document.getElementById("deviceMenu_" + deviceName);
			menuButton = document.getElementById("testButton_" + deviceName);
		if(bTestAll) {
			g_menuDivXOffset = -400;
			g_menuDivYOffset = +150;
			g_menuDivWidth = 150;
		}
		else {
			g_menuDivWidth = 150;
			g_menuDivXOffset = -35 - g_menuDivWidth;
			g_menuDivYOffset = -30;
			
		}
		
		if(menuButton !== null) {
			offsets = menuButton.getBoundingClientRect(); 
			if((offsets.x + offsets.width + window.pageXOffset + g_menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
				x = offsets.x + window.pageXOffset - g_menuDivWidth - 10; // takes into account viewport (scrolling)
			else
				x = offsets.x + offsets.width + window.pageXOffset + g_menuDivXOffset; // takes into account viewport (scrolling)
			y = offsets.y + window.pageYOffset - g_menuDivYOffset; // takes into account viewport (scrolling)
			if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
				if(!bTree && (g_iPlanningTreeShowDevices === 0)) {
					// floorsplan
					var imageDiv = document.getElementById("floorplanimageDiv");
					if(imageDiv != null) {
						offsets = imageDiv.getBoundingClientRect(); 
						if((y + 670) >  (offsets.y + window.pageYOffset + offsets.height)) {
							if(y > 310)
								y =  y + g_menuDivYOffset - 310;
							if(y < offsets.y + window.pageYOffset)
								y = offsets.y + window.pageYOffset + 10;
						}


					}
				}
			}
			document.getElementById("testDiv").style.left = x.toString() + "px";
			document.getElementById("testDiv").style.top = y.toString() + "px";
			menuOverlayDivShow(3, null);
		}
	}
/*		
	}
	else
		document.getElementById("testDiv").className = "testDivShow"; */
	if(mode === 3)
		mode = 0;
	else if (mode === 4)
		mode = 1;
	else if (mode === 5)
		mode = 2;
	g_iDeviceTestMode = mode;
	g_iDeviceTestId = id;
	g_iDeviceTestDeviceName = deviceName;
	g_iDeviceTestModeContent = "";
	var Rsp = requestPutData(mode, url, payload,  null, null); 
	// test results are processed in 
	// webSocketDeviceTestResultUpdate()
}
function testDeviceRerun(mode) {
	testDevice(mode, null, g_iDeviceTestId, g_iDeviceTestDeviceName);

}
function testDeviceCancel() {
	g_iDeviceTestId = -1;
	g_iDeviceTestMode = -1;
	g_iDeviceTestDeviceName = "";
	g_iDeviceTestModeContent = "";
	document.getElementById("testDiv").className = "testDivHide";
	document.getElementById("testOverlayDiv").className = "menuOverlayDivHide";
}
function testDeviceAllCancel() {
	g_bTestDevicesAlreadyStarted = false;
	g_bTestDevicesInProgress = 1;
	g_iTestDevices_Passed = 0;
	g_iTestDevices_Failed = 0;
	g_iTestDeviceTestTimeMs = 0;
	g_iTestDevicesPaused = 0;
	g_testDevicesList = [];
	g_testallDeviceFailList = [];
	g_iTestDevices_Total = 0;
	g_iTestDevices_TotalEdgeDevices = 0;
	g_iTestDevices_Uprovisioned = 0;
	g_iTestDevices_Down = 0;
	document.getElementById("testAllDiv").className = "testDivHide";
	document.getElementById("testOverlayDiv").className = "menuOverlayDivHide";
}
function timeDiff(startTime, endTime) {
	var sResult = "";
	try {
		iTemp = ( endTime - startTime) / 1000;
		if(iTemp < 60)
			sResult = iTemp.toFixed(1) + " s";
		else if(iTemp < (60 * 60))
			sResult = (iTemp / 60).toFixed(2) + " m";
		else if(iTemp < (60 * 60 * 24))
			sResult = (iTemp / (60 * 60)).toFixed(2) + " hours";
		else 
			sResult = (iTemp / (60 * 60 * 24)).toFixed(2) + " days";
	}
	catch {}
	return sResult;
}
function timerHandler() {
	// pressing Ondemand button or at polling interval causes one or more GET requests depending on number of datapoints
	// Every Poll interval controlled by UI starts ondemand process to read all specified DPs, 
	//   - ondemand process can take multiple GET requests with a minimum delay of 2 seconds per request.
	//   - g_iPollingRequestCountMax controls delay between UI controlled polls
	//   - g_iBackgroundPollingRequestCountMax controls delay between GET requests
	 var request;
	 var d1;
	 var d = new Date();
	try {
		if(g_bPauseMainTimer)
			return;  // used if can't create a WebSocket
		if(g_bInoreMouseClick)
			g_bInoreMouseClick = false;
		if(g_bUpdateCharts) {
			if(g_bDashboardUpdateCharts) {
				// Dashboard only
				updateDashboardCharts(1);
			}
			
		}
		if(g_sUpdateDataPoint !== "") {
			
				// need to wait at least 1 second
			if(g_iUpdateDataPointCount > 1) {
				try {
					request = "https://" + location.hostname + "/iap/devs/*+name==";
					g_sUpdateDataPoint = addIfToPathname(g_sUpdateDataPoint);
					request += g_sUpdateDataPoint + "/*";
					requestGetData(2, request, getOnDemandDpPropertiesResponse, null);
				}
				catch {}
				g_sUpdateDataPoint = "";
				return;
			}
			else 
				g_iUpdateDataPointCount ++;
		} 
		if(g_iAlarmTimerId === null) {
			if(!g_bAlarmsCountRequestInProgress) {
				if((d.getTime() - g_iLastAlarmMs) > 60000)
					getActiveAlarmsCount(2);
			}
		}
		if(g_bPollingEnabled || (g_PollingType === DISPLAYMODE_ONETIMEPOLL)) {
			if(g_iBackgroundPollingRequestCount !== -1)
				g_iBackgroundPollingRequestCount ++;  // used for GET request rate 
			if(g_iPollingRequestCount !== -1)
				g_iPollingRequestCount ++; // used for background ondemamdn request controlled by poll rate
			if(requestInProgress !== 0)
			{	// needed for fast updates, otherwise user interface gets locked out
				requestInProgress ++;
				if(requestInProgress > 60)
						requestInProgress = 0;
					else
						return;
						
			}
			
			if(requestFailureDelayCount !=0)
			{
				requestFailureDelayCount ++;  // defined in main.c
				if(requestFailureDelayCount > requestFailureDelayCountMax)
					requestFailureDelayCount = 0;
			}
			if((requestInProgress === 0) && (requestFailureDelayCount === 0))
			{
				if(g_bPollingEnabled) {
					/*
				if((g_PollingType === DISPLAYMODE_DPS) || (g_PollingType === DISPLAYMODE_FAVDPS) 
					|| (g_PollingType === DISPLAYMODE_ONETIMEPOLL) 
					|| ((g_PollingType === DISPLAYMODE_DASHBOARD)  && !g_bDashboardDataLogGetInProgress)
					|| (g_PollingType === DISPLAYMODE_PLANNING)
					|| ((g_PollingType === DISPLAYMODE_DATALOGLIVEPOLL) && !g_bDataLogGetInProgress)) {
						*/
					
					if(g_iBackgroundPollingRequestCount !== -1) {
						// Each Ondemand request or background polling may require
						if((g_iBackgroundPollingRequestCount >= (g_iBackgroundPollingRequestCountMax + g_iBackgroundPollingRequestExtended))
								&& bivServerOnline) {
							g_iBackgroundPollingRequestCount = -1;
							startNextRequest();
						}
					}
					else if(g_bPollingEnabled) {
						if(g_iPollingRequestCount !== -1) {
							if(g_iPollingRequestCount > g_iPollingRequestCountMax){
								g_iPollingRequestCount = 0; // next timer tick go get request
								startNextRequest();
							}
						}  // used when ondemand DP request and there are more than 10 dps
					}
				}
				
				
			}
		}
		else if(g_PollingType === DISPLAYMODE_DATALOG) {
			if((g_iDataLogPollCountMax !== -1) && (g_iDataLogLatestTimestamp !== null)) {
				g_iDataLogPollCount++;
				if(!g_bDataLogGetInProgress && !g_bDatalogChartZoomInProgress) {
					if(g_iDataLogPollCount > g_iDataLogPollCountMax) {
						g_iDataLogPollCount = 0;
						request = g_sDataLogPollRequest;
						if(request === "/iap/ws?dp=true") {
							request = "/iap/ws?value=";
						}
						request += "%2A%2Butc%3E" + g_iDataLogLatestTimestamp.substr(0, (g_iDataLogLatestTimestamp.length - 1));

						createDataLogClientWebSocketConnection(2, request);
					}
				} 
			}
		}
		
	} catch {}
}
function timerHandlerChart() {
	// Used for show datalogs, not used for show dashboard
	// pressing Ondemand button or at polling interval causes one or more GET requests depending on number of datapoints
	// Every Poll interval controlled by UI starts ondemand process to read all specified DPs, 
	//   - ondemand process can take multiple GET requests with a minimum delay of 2 seconds per request.
	//   - g_iPollingRequestCountMax controls delay between UI controlled 
	//   - g_iBackgroundPollingRequestCountMax controls delay between GET requests
	var i, lineName, color;
	var poll, temp;
	try {
		if(g_bUpdateCharts) {
			if (g_iMainDisplayMode === DISPLAYMODE_DATALOG) {
				g_bUpdateCharts = false; // only used to initialize the chart
				//datalogChartInit(1, g_datalogChartInfo.displayId);
				if(g_bCreateChartLines) {
					// only run when clicking show Datalog button and datalog chartLists are available
					g_bCreateChartLines = false; 
					for(i=0; i < g_chartLineList.length; i ++) 
					{
						if(g_chartLineList[i].lineName !== "polyline1") {
							lineName = g_chartLineList[i].lineName;
							color = g_chartLineList[i].color;
							ivCreateNewPolyline(g_datalogDisplayId, lineName, color, 5);
						}
					}
				}
				if(g_bCreateChartLegend) {
					createChartLegend();
				}
				if(dataLogDpList.length > 0) {
					datalogChartUpdate(g_iDatalogChartMode);
				}
				if(g_bCreateChartLegend) {
					g_bCreateChartLegend = false;
					
					poll = document.getElementById("datalogPoll");
					if(poll !== null) {
						if(poll.checked) {
							temp = document.getElementById("datalogRate").value;
							if(isNaN(temp)) 
							{
								return;
							}
							else if(temp.indexOf(".") !== -1) {
								return;
							}
							
							if(g_iDatalogPollMode > 0) {
								g_PollingType = DISPLAYMODE_DATALOGLIVEPOLL;
								g_iPollingRequestCount = 0;
								g_idpGetRequestIndex = 0;
								ivbWsProcessDatapointUpdate = true;
								g_iPollingRequestCountMax = Number(temp); // * 60;
								g_iPollingRequestCount = g_iPollingRequestCountMax + 2;
								g_bPollingEnabled = true;
								if(g_sWebSocketSubscribePayload !== g_sWebSocketSubscribePayload_oldvalue)
									subscribeRequest();
							}
							else {
								g_PollingType = DISPLAYMODE_DATALOG;
								g_iDataLogPollCount = 0;
								g_iDataLogPollCountMax = Number(temp); // * 60;
								g_bPollingEnabled = false;
							}
							
							try {
								if(g_timerId === 0)
									g_timerId = window.setInterval("timerHandler()", g_iTimerInterval);
							} catch (err) {} 
						}
					}
					
				}
			}
		}
	}
	catch {}
}

function usePriority() {
	var sTemp = "Datapoint Writes\r\n\r\n";
	var element, element1;
	sTemp += "\r\n\r\nAre you sure you want to do writes with no priority\r\n\r\nmeans all writes are done with current priority";
	if(document.getElementById("usePriority").checked) {
		
		g_bUsePriorityForAllWrites = true;
	}
	else {
		g_bUsePriorityForAllWrites = false;
		element = document.getElementById("warningDiv");
    	element1 = document.getElementById("warningOverlayDiv");
		try {
			if((element === null) || (element1 === null))
				return;
			menuOverlayDivShow(7, null);
			sTemp += "<br><br><br><div style=\"width:100%;text-align:right\"><button class=\"warningDivShowButton\" onclick=\"usePriority1()\">OK</button>";
			sTemp += "<button class=\"warningDivShowButton\" onclick=\"showAlertDialogHide()\">Cancel</button>";
			sTemp += "</div>";
			element.innerHTML = sTemp; 

		}
		catch {}
		//if(!confirm(sTemp)) {
		//	document.getElementById("usePriority").checked = true;
		//	g_bUsePriorityForAllWrites = true;
		//	return;
		//}
		//g_bUsePriorityForAllWrites = false;
	}
}
function usePriority1() {
	document.getElementById("usePriority").checked = true;
	g_bUsePriorityForAllWrites = true;
	showAlertDialogHide();
}
function useLocalValue() {
	var element, element1;
	var sTemp = "Datapoint Writes\r\n\r\nUse value for writes instead of Local Value";
	sTemp += "\r\n\r\nAre you sure you want to use value instead of local value";
	if(document.getElementById("useLocalValue").checked) {
		
		g_bUseLocalizationForAllWrites = true;
	}
	else {
		//if(!confirm(sTemp)) {
		//	document.getElementById("useLocalValue").checked = false;
		//	return;
		//}
		g_bUseLocalizationForAllWrites = true;
		element = document.getElementById("warningDiv");
    	element1 = document.getElementById("warningOverlayDiv");
		try {
			if((element === null) || (element1 === null))
				return;
			menuOverlayDivShow(7, null);
			sTemp += "<br><br><br><div style=\"width:100%;text-align:right\"><button class=\"warningDivShowButton\" onclick=\"useLocalValue1()\">OK</button>";
			sTemp += "<button class=\"warningDivShowButton\" onclick=\"showAlertDialogHide()\">Cancel</button>";
			sTemp += "</div>";
			element.innerHTML = sTemp; 

		}
		catch {}

	}
}
function useLocalValue1() {
	document.getElementById("useLocalValue").checked = false;
	g_bUseLocalizationForAllWrites = false;
	showAlertDialogHide();
}
function viewport( )
{
    this.x = window.pageXOffset ;
    this.w = window.innerWidth ;
    this.x2 = this.x + this.w - 1 ;
    this.y = window.pageYOffset ;
    this.h = window.innerHeight ;
    this.y2 = this.y + this.h - 1 ;
    return this;
}
function webSocketDeviceAlarmUpdate(json) {
	// check if alarm is for datapoint in context or dashboard view
	try {
		var i,j, k,m, n,obj,obj1, index, element1, displayElement,sTemp;
		if(json === null)
			return;
		for(i=0; i < json.length; i++)
		{
			if(json[i].state === "Active") {
				path = alarmGetPathFromDetails(json[i].details);
				for(j=0; j < dashboardDpList.length; j ++)
				{
					if(dashboardDpList[j].pathname === path) {
						obj = {};
						obj.mode = 55;
						obj.deviceId = dashboardDpList[j].deviceId;
						obj.deviceName = dashboardDpList[j].deviceName;
						obj1 = [];
						obj1.push(JSON.parse(JSON.stringify(json[i])));
						getPlanningGetAlarmsForDeviceResponse(obj, "", obj1);
						for(m = 0; m < g_deviceAlarmsList.length; m++)
						{
							if(g_deviceAlarmsList[m].deviceId === dashboardDpList[j].deviceId) {
								for(n = 0; n < g_deviceAlarmsList[m].alarms.length; n++)
								{
									if(g_deviceAlarmsList[m].alarms[n].pathname === dashboardDpList[j].pathname) {
										dashboardDpList[j].alarm = JSON.parse(JSON.stringify(g_deviceAlarmsList[m].alarms[n]));
										// look for display elements
										for(k=0; k < dashboardDpList[j].displayElements.length; k++)
										{
											if(dashboardDpList[j].alarm !== null) { 
												displayElement = dashboardDpList[j].displayElements[k];
												if((dashboardDpList[j].alarm.warningLevel < 5) && ((g_iAlarmDisplayType === 1) || (g_iAlarmDisplayType === 3)))  {
													//element = document.getElementById("contextDpDivRow_" + g_displayTypeList[j].divDisplayId);
													element1 = document.getElementById("datapointName_" + displayElement.displayId);
													if(element1 !== null) {
														element1.style.backgroundColor = g_alarmColors[dashboardDpList[j].alarm.warningLevel]; 
														// add bell
														
														sTemp = "<img src=\"images/navtree/Bellred.gif\" alt=\"alarmimage\"onclick=\"alarmMenu(";
														if(!dashboardDpList[j].displayElements[k].readonly && ((displayElement.dashboardType === "s1") || (displayElement.dashboardType === "s2")  
															|| (displayElement.dashboardType === "s3")   || (displayElement.dashboardType === "s4")))
															sTemp += 1; // writable -- use menudpvalue
														else
															sTemp += 0; // readonly -- show only alarm state
														sTemp += ",this," + j + "," + k + ",'bell_" + displayElement.displayId + "','" + dashboardDpList[j].programmaticPathname + "')\"";
														sTemp += "><span style=\"margin-left:5px\"></span>";
														element1 = document.getElementById("bell_" + displayElement.displayId);
														if(element1 !== null)
															element1.innerHTML = sTemp;
														//w = 1;
													}
												}
											}
										}
									}
								}
								break;
							}
						}
						break;
					}
				}
			}
		}
	}
	catch {}
	//alarmCheckForUpdates(0);
	
}
function webSocketDeviceAlarmDeletedUpdate(json) {
	// check if alarm is for datapoint in context or dashboard view
	try {
		var i,j, k, m, n, index, element1, displayElement,sTemp, displayId,iPtr, sTemp;
		if(json === null)
			return;
		for(i=0; i < json.length; i++)
		{
			if(json[i].state === "Inactive") {
				path = alarmGetPathFromDetails(json[i].details);
				for(j=0; j < dashboardDpList.length; j ++)
				{
					if(dashboardDpList[j].pathname === path) {
						if(dashboardDpList[j].alarm !== null) { 
							dashboardDpList[j].alarm = null;
							for(k=0; k < dashboardDpList[j].displayElements.length; k++)
							{
								if(dashboardDpList[j].displayElements[k].displayId !== "") {
									displayId = dashboardDpList[j].displayElements[k].displayId;
									element = document.getElementById("bell_" + displayId);
									if(element !== null)
										element.innerHTML = "";
									
									element = document.getElementById("datapointName_" + displayId);
									if(element !== null)
										element.style.backgroundColor = g_alarmColors[0];
									
									for(m=0; m < g_deviceAlarmsList.length; m++)
									{
										if(g_deviceAlarmsList[m].deviceId === dashboardDpList[j].deviceId) {
											for(n=0; n < g_deviceAlarmsList[m].alarms.length; n++)
											{
												if(g_deviceAlarmsList[m].alarms[n].pathname === dashboardDpList[j].pathname) {
													g_deviceAlarmsList[m].alarms.splice(n,1);
													break;
												}
											
											}
										}
									}  
								}
							}
						}
						break;
					}
				}
			}
		}
	}
	catch {}
}
function webSocketDeviceDeleteUpdate(json) {
	var content = "",sTemp;
	var element, element1, i, j, k, id, status, color, iUp, iDown, iUnProvisioned;
	var bDeviceDeleted = false;
	var bDeviceStatusChanged = false;
	var color,element,element1, displayElement;
	try {
		if(g_bIgnoreNewDeviceDeleted)
			return;
		
		for(i=0; i < deviceListAll.length; i++)
		{
			if(id === deviceListAll[i].id) {
				bDeviceDeleted = false;
				bDeviceStatusChanged = true;
				break;
			}
		}
		if(bDeviceStatusChanged) {
			displayDeviceStatus();
		}
		if(bDeviceDeleted) {
			if(!g_bIgnoreNewDeviceDeleted) {
				sTemp = "Device deleted\r\n\r\nPress:\r\n\tOK - to refresh Devices and context and show Planning View tree)\r\nCancel - to just continue"
				g_bIgnoreNewDeviceDeleted = true;  // during bulk create you could see a log of these
				/* if(confirm(sTemp)) {
					
					cursorSetWait(); //123
					deviceListAll = [];
					planningList = [];
					deviceTypeList = [];
					getDeviceTypes(25);
					showPlanningRefresh(0);
				} */
				element = document.getElementById("warningDiv");
				element1 = document.getElementById("warningOverlayDiv");
				try {
					if((element === null) || (element1 === null))
						return;
					menuOverlayDivShow(7, null);
					sTemp = sTemp.replace(/\\r\\n/g,"<br>");
					sTemp += "<br><br><br><div style=\"width:100%;text-align:right\"><button class=\"warningDivShowButton\" onclick=\"webSocketDeviceDeleteUpdate1()\">OK</button>";
					sTemp += "<button class=\"warningDivShowButton\" onclick=\"showAlertDialogHide()\">Cancel</button>";
					sTemp += "</div>";
					element.innerHTML = sTemp; 
				}
				catch {}
			}
		}
	}
	catch {}
}
function  webSocketDeviceDeleteUpdate1() {
	cursorSetWait(); //123
	//if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING)
	//	showPlanningTreePane(4)
	deviceListAll = [];
	planningList = [];
	deviceTypeList = [];
	getDeviceTypes(25);
	showPlanningRefresh(0);
}
function webSocketDeviceStatusUpdate(json) {
	var content = "",sTemp;
	var element, element1, i, j, k, id, status, color, iUp, iDown, iUnProvisioned;
	var bNewDevice = true;
	var bDeviceStatusChanged = false;
	var color,element,element1, displayElement;
	try {
		if(g_bIgnoreNewDeviceDetection)
			return;
		if(g_iDeviceTestId === json.id) {
			content = "."; //"pinged successful<br>";
			g_iDeviceTestModeContent += content;
			element = document.getElementById("testDeviceResults");
			if(element !== null)
				element.innerHTML += content;
		}
		// check for tree 
		id = json.id;
		status = json.status.state;
		if(status === "provisioned")
			status = json.status.health;
		for(i=0; i < deviceListAll.length; i++)
		{
			if(id === deviceListAll[i].id) {
				bNewDevice = false;
				if(deviceListAll[i].category !== "SC") {
					if(json.status.state !== deviceListAll[i].status.state)
						bDeviceStatusChanged = true;
					else if (json.status.health !== deviceListAll[i].status.health)
						bDeviceStatusChanged = true;
					else if(deviceListAll[i].category !== "SC") { 
						// possible that device status was changed but the tree was not updated.
						element = document.getElementById("deviceStatus_" + id);
						if(element != null) {
							color = deviceStatusColor (status);
							if(element.style.backgroundColor !== color)
								bDeviceStatusChanged = true;
						}
					}
					if(bDeviceStatusChanged) {
						deviceListAll[i].status.state = json.status.state;
						deviceListAll[i].status.health = json.status.health;
						deviceListAll[i].state = status;
						element = document.getElementById("deviceStatus_" + id);
						if(element != null) {  // device may not  be added in tree yet
							if(deviceListAll[i].category !== "SC") {
								color = deviceStatusColor (status);
								element.style.backgroundColor = color;
								treeUpdateContextDeviceStatus(-1, deviceListAll[i].id);
							}
						}
						//	deviceListAll[i].statusChanged = true; // used when device in tree but looking at some other view like dashboard
						if(g_bShowDeviceStatusInDashboard) {
							if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
								color = showDashboardDeviceStatus(i, deviceListAll[i].name);
								element = document.getElementById("dashboardDeviceStatus_" + deviceListAll[i].name);
								if(element !== null)
									element.style.backgroundColor = color;
							}
						}
					
						if(g_bShowDpDeviceDown && (((g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) && (g_sSiteDashboardSelected !== "")) || (g_iMainDisplayMode === DISPLAYMODE_PLANNING))) {
							for(j=0; j < dashboardDpList.length; j++)
							{
								if(dashboardDpList[j].deviceId === id) {
									// if status normal and no alarms then remove alarm bell
									// if status down then make alarm bell pink
									// if alarm state then make bell alarm state  //mike
									color = "";
									if(status === "normal") {
										if((dashboardDpList[j].alarm !== null) && ((dashboardDpList[j].alarm.warningLevel < 5) && ((g_iAlarmDisplayType === 1) || (g_iAlarmDisplayType === 3)))) {
											color = g_alarmColors[dashboardDpList[j].alarm.warningLevel]; 
										}
									}
									else	
										color = g_sTableDeviceDownColor;
									
									//see webSocketDeviceAlarmUpdate() for information on how to update alarms
									if(color !== "")
										for(k=0; k < dashboardDpList[j].displayElements.length; k++)
										{
											displayElement = dashboardDpList[j].displayElements[k];
											element1 = document.getElementById("datapointName_" + displayElement.displayId);
											if(element1 !== null) {
												element1.style.backgroundColor = color; //g_alarmColors[dashboardDpList[j].alarm.warningLevel]; 
												// add bell
												
												sTemp = "<img src=\"images/navtree/Bellred.gif\" alt=\"alarmimage\"onclick=\"alarmMenu(";
												if(!dashboardDpList[j].displayElements[k].readonly && ((displayElement.dashboardType === "s1") || (displayElement.dashboardType === "s2")  
													|| (displayElement.dashboardType === "s3")   || (displayElement.dashboardType === "s4")))
													sTemp += 1; // writable -- use menudpvalue
												else
													sTemp += 0; // readonly -- show only alarm state
												sTemp += ",this," + j + "," + k + ",'bell_" + displayElement.displayId + "','" + dashboardDpList[j].programmaticPathname + "')\"";
												sTemp += "><span style=\"margin-left:5px\"></span>";
												element1 = document.getElementById("bell_" + displayElement.displayId);
												if(element1 !== null)
													element1.innerHTML = sTemp;
												
											}
											
										}
									else {
										// no alarm and device not down
										for(k=0; k < dashboardDpList[j].displayElements.length; k++)
										{
											if(dashboardDpList[j].displayElements[k].displayId !== "") {
												displayId = dashboardDpList[j].displayElements[k].displayId;
												element = document.getElementById("bell_" + displayId);
												if(element !== null)
													element.innerHTML = "";
												
												element = document.getElementById("datapointName_" + displayId);
												if(element !== null)
													element.style.backgroundColor = g_alarmColors[0];
											}
										}

									}
								}
							}
						}
					}
				}
				
				break;
			}
		}
		if(bDeviceStatusChanged) {
			displayDeviceStatus();
		}
		if(bNewDevice) {
			if(!g_bIgnoreNewDeviceDetection) {
				sTemp = "New Device detected<br><br>Press:<br><br><span style=\"margin-left:10px\">OK - to refresh Devices, contexts and show Planning View tree</span><br><span style=\"margin-left:10px\">Cancel - to just continue</span>"
				g_bIgnoreNewDeviceDetection = true;  // during bulk create you could see a log of these
				/*
				if(confirm(sTemp)) {
					
					cursorSetWait(); //123
					//if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING)
					//	showPlanningTreePane(4)
					deviceListAll = [];
					planningList = [];
					deviceTypeList = [];
					getDeviceTypes(25);
					showPlanningRefresh(0);

				}
				*/
				element = document.getElementById("warningDiv");
				element1 = document.getElementById("warningOverlayDiv");
				try {
					if((element === null) || (element1 === null))
						return;
					menuOverlayDivShow(7, null);
					sTemp = sTemp.replace(/\\r\\n/g,"<br>");
					sTemp += "<br><br><br><div style=\"width:100%;text-align:right\"><button class=\"warningDivShowButton\" onclick=\"webSocketDeviceStatusUpdate1()\">OK</button>";
					sTemp += "<button class=\"warningDivShowButton\" onclick=\"showAlertDialogHide()\">Cancel</button>";
					sTemp += "</div>";
					element.innerHTML = sTemp; 

				}
				catch {}
			}
		}
		
	}
	catch {}
} 
function webSocketDeviceStatusUpdate1() {
	cursorSetWait(); //123
	//if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING)
	//	showPlanningTreePane(4)
	deviceListAll = [];
	planningList = [];
	deviceTypeList = [];
	getDeviceTypes(25);
	showPlanningRefresh(0);
	showAlertDialogHide();
}
function webSocketDeviceTestResultUpdate(json) {
	// manage test results
	var content = g_iDeviceTestModeContent;
	var i, z,  deviceStatus = "", element, color = "lawngreen", contextId, iPtr;
	try {
		if(g_iDeviceTestId === json.deviceId) {
			if(g_bTestDevicesInProgress) {
				try {
					if(g_iMainDisplayMode === DISPLAYMODE_ALLDEVICES) {
						testDeviceAllWsUpdate(json);
					}
					else 
						g_bTestDevicesInProgress = false;
				}
				catch {}
			}
			else {
				content += "<br><hr><br>Device Status<br><br>"
				content += jsonToHtmlTableStr(1, json.results);
				document.getElementById("testDeviceResults").innerHTML += content;
				document.getElementById("testDeviceResultsTitle").innerHTML = "Test Completed";
				
				content = "<hr><button onclick=\"testDeviceCancel()\">Close</button><button style=\"float:right\"";
				if(g_iDeviceTestMode === 0) 
					content += "<button onclick=\"testDeviceRerun(3)\">Re-test</button>";
				else if(g_iDeviceTestMode === 1)
					content += "<button onclick=\"testDeviceRerun(4)\">Re-test</button>";
				else if(g_iDeviceTestMode === 2)
					content += "<button onclick=\"testDeviceRerun(5)\">Re-test</button>";
				document.getElementById("testDeviceClose").innerHTML = content;
			}	
				
			// update devicelist
			z = -1;
			for(i=0; i < deviceListAll.length; i++)
			{
				if(deviceListAll[i].id === json.deviceId) {
					if(deviceListAll[i].category === "SC") {
						deviceStatus = "normal";
					}
					else if(json.results.state === "Configured Online") {
						deviceStatus = "normal";
						deviceListAll[i].status.state = "provisioned";
						deviceListAll[i].status.health = "normal";
					}
					else {
						
						deviceListAll[i].status.state = json.results.state;
						deviceListAll[i].status.health = json.results.health;
						if(json.results.state === "provisioned") {
							if(json.results.error.indexOf("Device does not respond!")) {
								deviceStatus = "down";
								deviceListAll[i].status.health = "down";
							}
							else
							deviceStatus = json.results.health;
						}
						else {
							deviceStatus = json.results.state;
						}
					}
					deviceListAll[i].deviceState = deviceStatus;
					z=i;
					break;
				}
			}
			if(z != -1) {
				if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
					// change canvas
					if(g_sPlanningTreeDatapointPath === "") {
						if(g_iDeviceTestMode < 2)
							deviceStatusColorCanvas("canvas_" + deviceListAll[z].name, deviceListAll[i].category, deviceStatus);
						else 
							deviceStatusColorSvg("deviceMenu_" + deviceListAll[z].name, deviceListAll[i].category, deviceStatus);
					}
					else {
						// tree
						element = document.getElementById("deviceStatus_" + deviceListAll[z].id);
						if(element != null) {
							if(deviceListAll[z].category !== "SC")
								color = deviceStatusColor (deviceStatus);
							element.style.backgroundColor = color;
							try {
								treeUpdateContextDeviceStatus(z, deviceListAll[z].id);
							}
							catch (err) {}
						}
					} 
						
				}
			}
			

		}
		g_iDeviceTestMode = -1;
	}
	catch {}
} 
function webSocketNotificationUpdate(json) {
	var messsage = "", element, sTemp, table, row, cell1, cell2, cell3, cell4;
	try {
		message = json.message;
		if(message === "queryStatus  Device does not respond!") {
			testDeviceAllWsQueryStatusFailUpdate(json);
			
		}
	}
	catch {}
}
function webSocketSaveServicePinShowMessage(json) {
	try {
		if(json === null)
			return;
		if(g_iMainDisplayMode === DISPLAYMODE_SERVICEPIN) {
			showServicePinMessagesTableRow (1, json);
		}
	}
	catch {}
}
function windowResize() {
	try {
		var x = 0;
		var y = 0;
		var menuDiv = null,  menuDivType = null;
		var offsets;
		var menuType = "";
		var bContinue = 0;
		if(document.getElementById("menuDiv").className === "menuDivShow") {
			menuDivType = document.getElementById("menuDivType")
			if(menuDivType !== null) {
				menuType = menuDivType.innerHTML;
				if(menuType.indexOf("deviceMenu_") === 0) {
					g_menuDivXOffset = 35;
					g_menuDivYOffset = 30;
					g_menuDivWidth = 150;
					bContinue = true;
				}
				else if(menuType.indexOf("dpMenu_") === 0) {
					g_menuDivXOffset = 30;
					g_menuDivYOffset = 20;
					g_menuDivWidth = 150;
					bContinue = true;
				}
				if(bContinue) {
					offsets = menuButton.getBoundingClientRect(); 
					if((offsets.x + offsets.width + window.pageXOffset + g_menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
						x = offsets.x + window.pageXOffset - g_menuDivWidth - 10; // takes into account viewport (scrolling)
					else
						x = offsets.x + offsets.width + window.pageXOffset + g_menuDivXOffset; // takes into account viewport (scrolling)
					y = offsets.y + window.pageYOffset - g_menuDivYOffset; // takes into account viewport (scrolling)
					document.getElementById("menuDiv").style.left = x.toString() + "px";
					document.getElementById("menuDiv").style.top = y.toString() + "px";
				}
			}
		}
		if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
			treeDivTreeResizeEvent();
		}
	} catch {}
}
function winkDevice(id, deviceName) {
	var	url = "https://" + location.hostname + "/iap/devs/" + id + "/wink";
	var payload = "{\"ID\":" + id + "}"; 
	menuCancel();
	var Rsp = requestPutData(0, url, payload,  null, null); 
}

function writeDpValue(mode, url, parameterStr, callback, failCallback)
{ // name is parameter name, value = parameter value
	// mode is an object when getting http 244 error
	try {
		g_iBackgroundPollingRequestCount = 0;
		var Rsp = requestPutData(0, url, parameterStr, callback, failCallback); 
			// used to overcome IzoT Server write failures to device
		g_iLastWriteTimeout = new Date().getTime() + 20000;
		
	}
	catch(err) {}
}
function writeDpValueSaveCurrentValue (index) {
	try {
		if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
			if((index !== -1) && (index < dashboardDpList.length)) {
				dashboardDpList[index].saved = {};
				if(dashboardDpList[index].bStructure) {
					dashboardDpList[index].saved.value = JSON.parse(JSON.stringify(dashboardDpList[index].value));
					dashboardDpList[index].saved.locValue = JSON.parse(JSON.stringify(dashboardDpList[index].locValue));
				}
				else {
					dashboardDpList[index].saved.value = dashboardDpList[index].value;
					dashboardDpList[index].saved.locValue = dashboardDpList[index].locValue;
				}
				dashboardDpList[index].saved.valueStr = dashboardDpList[index].valueStr;
				dashboardDpList[index].saved.locValueStr = dashboardDpList[index].locValueStr;
				dashboardDpList[index].saved.presetValue = dashboardDpList[index].presetValue;
				dashboardDpList[index].saved.priority = dashboardDpList[index].priority;
			}
		}
	}
	catch {}
}

function writeFailCallback (mode, requestUrl, requestData, json) {
	var sTemp = "",sTemp1 = "", i;
	var iPtr;
	var bShowPriority = true;
	var sPriority = "";
	try {
		// Multiple reasons: 1. IzoT Server database reset, device deleted
		if(json.status === 422){
			if((g_iMainDisplayMode === DISPLAYMODE_PLANNING) || (g_iMainDisplayMode === DISPLAYMODE_DASHBOARD)) {
				// request immediate read of datapoint
				sTemp = requestUrl;
				iPtr = requestUrl.lastIndexOf("/overrides/");
				if(iPtr > 0) {
					sPriority = requestUrl.substr(iPtr + "/overrides/".length);
					sTemp = requestUrl.substr(0,iPtr);
					iPtr = sPriority.lastIndexOf("/localization/value");
					if(iPtr > 0)
						sPriority = sPriority.substr(0, iPtr);
					if(sPriority === "17")
						sPriority = "normal";
				}
				else {
					sPriority = "normal";
				}
				iPtr = sTemp.indexOf("/*+name==");
				if(iPtr > 0) {
					iPtr += "/*+name==".length;
					sTemp1 = sTemp.substr(iPtr);
					iPtr = sTemp1.indexOf("/if/");
					if(iPtr > 0) {
						sTemp1 = sTemp1.substr(0, iPtr) + "/" + sTemp1.substr(iPtr + "/if/".length);
						if(sTemp1 !== "") {
							iPtr = sTemp1.indexOf("/*+xifName==");
							if(iPtr > 0) {
								sTemp1 = sTemp1.substr(0, iPtr) + "/" + sTemp1.substr(iPtr + "/*+xifName==".length);
								if(sTemp1 !== "") {
									for(i=0; i < dashboardDpList.length; i++)
									{
										if(dashboardDpList[i].programmaticPathname === sTemp1) {
											if(typeof dashboardDpList[i].saved !== "undefined") {
												if(typeof dashboardDpList[i].saved.locValue !== "undefined") {
													dashboardDpList[i].feedbackDelay = false;
													dashboardDpList[i].updateDpValue = true;
													if(dashboardDpList[i].bStructure) {
														dashboardDpList[i].value = JSON.parse(JSON.stringify(dashboardDpList[i].saved.value));
														dashboardDpList[i].locValue = JSON.parse(JSON.stringify(dashboardDpList[i].saved.locValue));
													}
													else {
														dashboardDpList[i].value = dashboardDpList[i].saved.value;
														dashboardDpList[i].locValue = dashboardDpList[i].saved.locValue;
													}
													dashboardDpList[i].valueStr = dashboardDpList[i].saved.valueStr;
													dashboardDpList[i].locValueStr = dashboardDpList[i].saved.locValueStr;
													dashboardDpList[i].presetValue = dashboardDpList[i].saved.presetValue;
													dashboardDpList[i].priority = dashboardDpList[i].saved.priority;
													dashboardProcessWriteDpDataUpdateUi(i, dashboardDpList[i].dpQualifier);
													dashboardDpList[i].saved = {};
												}
											}
											break;
										}
									}
								}
							}
						}
					}
				}
				requestGetData(0, sTemp + "/*", getOnDemandDpValuesResponse, readFailCallback); // get current priority
				requestGetData(0, sTemp + "/value?max_age=2&noxs=true", getOnDemandDpValuesResponse, readFailCallback); // get latest value
			}
			
			//sTemp = "*** Warning ****\r\n\r\nA higher Write Priority is currently Active\r\n\r\n Your value is sent at the priority you specified";
			sTemp = "*** Warning ****<br><br>A higher Write Priority is currently Active<br><br> Your value is sent at the priority you specified";
			if(bShowPriority) {
				if(sPriority !== "") {
					sTemp += " (" + sPriority + ")"
				}
			}
			//sTemp += ",\r\nbut the current value is not changed.";
			sTemp += ",<br>but the current value is not changed.";
			//alert(sTemp);
			
			showAlertDialog(0, sTemp);
		}
		else {
			if(typeof json.message !== "undefined") {
				sTemp = json.message;
				sTemp = sTemp.replaceAll("<br/>", "\r\n");
				sTemp = "\r\n\r\n";
			}
			
			//alert("*** Error ****\r\n\r\nWrite failure" + json.status + sTemp + "\r\n\r\n Try Refreshing Web Browser (F5)");
			showAlertDialog(0, "*** Error ****\r\n\r\nWrite failure" + json.status + sTemp + "\r\n\r\n Try Refreshing Web Browser (F5)");
		}
		//ivChangeDisplayItemsBackToOrigValues(requestUrl, requestData);
		

	} catch(err) {}
}

