#!/bin/bash
# Copyright © 2022 EnOcean Edge Inc
# This script is used to install the channel monitor service,  Run as root
. /usr/bin/apollo/apollo-utils.fcn
echo "Installing BACnetmointor service"
echo "Scipt Version: 1.01"
echo "---------------------------------"
# 
if [ "$EUID" -ne 0 ];then
    echo "Please run this script as root."
    exit 1
fi
read -p "Enter optional hour for daily BACnet restard [24]: " RSH

APP_DIR="$APOLLO_DATA/apps"
A_SETUP="bacnetmonitor"
V4_FILE_MARKER="/usr/bin/smartserverctl"

if [ ! -d "$APP_DIR" ] || [ ! -d $APP_DIR/$A_SETUP ];
then
   echo "Creating install directory $APP_DIR"
   mkdir -p "$APP_DIR/$A_SETUP"
   chown -R apollo:apollo "$APP_DIR"
   UPDATE=0
fi  
cp -f ./bacnetmonitorpackage.zip "$APP_DIR/$A_SETUP"
cd "$APP_DIR/$A_SETUP"
unzip -o ./bacnetmonitorpackage.zip
rm ./bacnetmonitorpackage.zip
chown apollo:apollo *.*
chmod -R 775 $APP_DIR
if [ ! -f "$V4_FILE_MARKER" ]; then
    echo "Using pre-4.0 service architecture"
    echo "Stopping the bacnetmonitor service.  You can ignore errors that may be reported by supervisorctl."
    supervisorctl stop bacnetmonitor
    sed -i "s/bacnetmonitor.js/bacnetmonitor.js $RSH/g" bacnetmonitor.conf
    mv -f ./bacnetmonitor.conf /etc/supervisor/conf.d
    chmod 666 bacnetmonitor.js
    chmod 664 /etc/supervisor/conf.d/bacnetmonitor.conf
    echo "Starting service."
    #sleep 30s
    supervisorctl update bacnetmonitor
    supervisorctl restart bacnetmonitor
    rm *.service
else
    # Need to run services under systemctl 644 permissions on unit files.
    echo "Using 4.X services architecture."
    echo "Stopping the bacnetmonitor.  You can ignore errors that may be reported by systemctl."
    smartserverctl stop bacnetmonitor
    echo "Setting up service unit files"
    sed -i "s/bacnetmonitor.js/bacnetmonitor.js $RSH/g" smartserver-bacnetmonitor.service
    chmod 644 ./smartserver-bacnetmonitor.service
    chown root:root ./smartserver-bacnetmonitor.service
    mv -f ./smartserver-bacnetmonitor.service /lib/systemd/system/
    sleep 2
    echo "Starting bacnetmonitor service"
    smartserverctl enable smartserver-bacnetmonitor.service
    smartserverctl start bacnetmonitor
    rm *.conf
fi    
echo "The bacnetmonitor service is installed."  
cd ~
