/*   
    WebSocket Driver

*/
    
    let ivSocketRequest = "wss://"+ window.location.hostname + "/iap/ws"; // ":1880/iap/ws";//":8443/iap/ws";
    let ivSocket;
    let ivWsShowConsoleLog = false;
    var ivWsMessage, ivWsLastDatapointUpdate;
    var iviWsCount = 0;
    var ivWsSocketConnected = false;
    var ivWsSmartServerCpu = 0;
    var ivWsExtendMax = 11; // 10 + 1
    var ivbWsSaveServicePinMessage = true;
    var ivWsServicePinMessageHistory = [];
    var ivbWsSaveServicePinShowMessage = false;
    var ivbWsProcessDatapointUpdate = false;
    var ivWsTempObj = {};
    
    function ivWsLogout() {
        ivSocket.close();
    }
    function ivWebSocketInit() {
        ivWsSocketConnected = false;
        ivWsServicePinMessageHistory = [];
        ivbWsSaveServicePinShowMessage = false;

        ivSocket =  new WebSocket(ivSocketRequest);
        ivSocket.onopen = function(event) {
            // alert("[open] connection");
            if(ivWsShowConsoleLog)
                console.log("Web Socket Open");
            ivWsSocketConnected = true;
       }
        ivSocket.onmessage = function(event) {
            //alert('[message] Data received frm server: ' + event.data);
            
            ivWsMessage = JSON.parse(event.data);
            var i, index = -1;
            var ivWsLastDatapointUpdate;
            try
            {
                if(ivWsMessage.action === "NTF:JOIN") {
                    if(ivbWsSaveServicePinMessage) {
                        ivWsTempObj = {};
                        ivWsTempObj.timestamp = new Date().toISOString();
                        ivWsTempObj.serviceMessage = ivWsMessage.payload;
                        ivWsServicePinMessageHistory.splice(0,0,ivWsTempObj);
                        if(ivbWsSaveServicePinShowMessage) {
                            if(typeof webSocketSaveServicePinShowMessage !== 'undefined') { // d
                                webSocketSaveServicePinShowMessage(ivWsTempObj);
                            }
                        }
                        
                    }
                }
                else if(ivWsMessage.action === "UPD:CPU") {
                    ivWsSmartServerCpu = ivWsMessage.payload;
                    document.getElementById("cpuValue").innerHTML = ivWsSmartServerCpu;
                    if(!(typeof g_iackgroundPollingRequestExtended === "undefined")) {
                        if(ivWsSmartServerCpu > 94) {
                            if(g_iBackgroundPollingRequestExtended < ivWsExtendMax)
                                g_iBackgroundPollingRequestExtended ++;
                        }
                        else {
                            if(g_iBackgroundPollingRequestExtended > 0)
                                g_iBackgroundPollingRequestExtended --;
                        }
                    }
                }
                else if(ivWsMessage.action === "UPD:EPS") {
                    document.getElementById("epsValue").innerHTML = ivWsMessage.payload;
                }
                
                else if(ivWsMessage.action === "UPD:DATAPOINT"){
                    //if(g_bNeedToSubscribe) // no longer needed in cae CMS ondemand get or DLA settings update
                    if(!ivbWsProcessDatapointUpdate)
                        return;
                    //var date = new Date();
                    iviWsCount ++;
                    ivWsLastMessage = ivWsMessage;
                    if(ivWsShowConsoleLog)
                        console.log(ivWsMessage);
                    json = [];
                    if(typeof ivWsMessage.payload !== 'undefined'){
                        for(i=0; i < ivWsMessage.payload.length; i ++)
                        {
                            index ++;
                            ivWsLastDatapointUpdate = {};
                            ivWsLastDatapointUpdate.datapointQualifier = ivWsMessage.payload[i].datapointQualifier;
                            ivWsLastDatapointUpdate.value = ivWsMessage.payload[i].value;
                            try {
                                if(typeof ivWsMessage.payload[i].presetValue === "undefined") 
                                    ivWsLastDatapointUpdate.presetValue = "";
                                else
                                    ivWsLastDatapointUpdate.presetValue = ivWsMessage.payload[i].presetValue;
                            } catch { ivWsLastDatapointUpdate.presetValue = ""; }
                            try {
                                if(typeof ivWsMessage.payload[i].locValue === "undefined") 
                                    ivWsLastDatapointUpdate.locValue = "";
                                else
                                    ivWsLastDatapointUpdate.locValue = ivWsMessage.payload[i].locValue;
                            } catch { ivWsLastDatapointUpdate.locValue = ""; }
                            json[index] = ivWsLastDatapointUpdate;
                        }
                        if(json.length > 0) {
                            processWebSocketDpData(0, 1, "", json)  // defined by user
                        }
                    }
                }
                else if(ivWsMessage.action === "UPD:DEVICE") {
                    webSocketDeviceStatusUpdate(ivWsMessage.payload);
                }
                else if(ivWsMessage.action === "UPD:DEVICE_TEST_RESULT") {
                    webSocketDeviceTestResultUpdate(ivWsMessage.payload);
                }
                else if(ivWsMessage.action === "CRT:ALARM") {
                    webSocketDeviceAlarmUpdate(ivWsMessage.payload);
                }
                else if(ivWsMessage.action === "DEL:ALARM") {
                    webSocketDeviceAlarmDeletedUpdate(ivWsMessage.payload);
                }
                else if(ivWsMessage.action === "CRT:NOTIFICATION") {
                    webSocketNotificationUpdate(ivWsMessage.payload);
                }
                else if(ivWsMessage.action === "UPD:LIC:CLOUD") {
                    showLicensesDownloadLicensesFromCloudResponse(ivWsMessage.payload);
                }
                else if(ivWsMessage.action === "DEL:LIC") {
                    showLicensesDownloadRevokeLicensesDeleteUpdate(ivWsMessage.payload);
                }
                else if(ivWsMessage.action === "NTF:LIC:ACTION") {
                    showLicensesDownloadLicensesNtfUpdate(ivWsMessage.payload);
                }
                else if(ivWsMessage.action === "UPD:LIC:TOTAL") {
                    //offline activation

                }
            }
            catch {}
        }
        ivSocket.onclose = function(event) {
            ivWsSocketConnected = false;
            if(event.wasClean) {
                if(ivWsShowConsoleLog)
                    console.log("web Socket close cleanly");
                //alert('[close] Connection closed cleanly, code = ' + event.code + 'reason = ' + event.reason);
           
            }
            else {
                if(ivWsShowConsoleLog)
                    console.log('Web Socket died, code = ' + event.code + 'reason = ' + event.reason);
                
                // server process killed, network down, even.code is usually 1006
                //alert('[close] Connection died, code = ' + event.code + 'reason = ' + event.reason);
                //document.getElementById("log").value = '[close] Connection died, code = ' + event.code + 'reason = ' + event.reason + "\r\n\r\n" + document.getElementById("log").value
            }
        }
        ivSocket.onerror = function(error) {
            if(ivWsShowConsoleLog)
                console.log("error: " + error.message);
            if(!ivWsSocketConnected) {
                var message = "Error: Can't Create Web Socket\r\n\r\nPress OK - to Go to CMS Login page\r\n\t - accept self signed certificate (you don't need to login)";
                message += "\r\n\t - Once you accept certificate, hit browser back button to go back to Brower Web page"
                message += "\r\n\r\nCancel - Stay in Browser, but don't use Web sockets";
                var resp = confirm(message)
                if(resp) {
                    var cmsStr =  "https://" + window.location.hostname + "/cms";
		            window.open(cmsStr,'_self',false);
                }
            }
        }
    }
  
    
