/********************************************************************************
 * 
 *  dashboardDpList[i].dashboardType: n=table cell, p=power, c=chart only, t=temperature (thermometer svg + chart) 
 */

var dashboardDpList = [];
var g_bDashboardSupportLogData = true;
var g_sDashboardTitle = "";
var g_sDashboardTemplateType = "";
var g_sDashboardDevice = "";
var g_sDashboardType = "";
var g_sDashboard = "";
var g_idashboardChartType = 0; //0=trend, 1=stepline
var g_dashboardChartList = [];
let g_dashboardIoxList = [];
var powerIndex = 0;
var g_bDashboardNeedToInitializeSvg = true;
var g_iDashboardInitiCount = "0";
var g_bAddDeviceName = false;
var g_bDashboardChartDynamicRange = true;
var g_bDashboardChartUseTimestamp = false;
var g_bDashboardGetDatalog = true;
var g_iDashboardDatalogRange = 2; //0= none, 1= 1 hour
var g_iDashboardChartDuration = 0; //0= none, 1= 1 hour
let g_idashboardChartMaxNumberOfPointsDefault = 1000; // 0=unlimited
let g_idashboardChartMaxNumberOfEntries = 0; // 0=unlimited
let g_iDashboardChartMaxDuration = 0; // microsec, 0= no limits
var g_bDashboardDataLogGetInProgress = false;
var g_dashboardTimerInterval = 1500; // firefox takes more time to load svg then chrome
var g_dashboardTimerId = 0; // used to initilize svg elements
var g_dashboardDatalogData = [];
let g_dashboardDataLogRequestInfo = {}; // used to save showdashboard info during getting datalog 
let g_bdashboardChartPause = false;
let g_bDashboardPollEnabled = true;
let g_bDashboardUseNewChart = true;
let giDashboardChartLineWidth = 10;
let g_bDashboardOptionsMenu = false;
let g_sDashboardUseNewChartname = "chart9.svg";
let g_bDashboardSupportDisplayMouseToolTip = true;
let g_bDashboardDisplayMouseToolTip = false;
let g_bDashboardDisplayMouseToolTipShowPresets = true;
let g_bDashboardMinMaxUsePadding = false;
let g_bDashboardMinMaxDecimalPlaces = true; //work inprogress
let g_iDashboardDecimalPlaces = 2;  // max number of decimal places if value greater than 1, -1=no limit

function addLux(shortPathname, pathName, value, presetValue) {
    var content = '<div class="group"   style="float:left;display:inline-block;margin-left:10px;margin-top:10px">';
    content += '<div style="float:left;display:inline-block">';
    if(g_bDashboardSupportLogData  && g_bDashboardUseNewChart) 
        content += '<object id="thermometer_' + pathName +'" data-izot-min="0" data-izot-max="500" style="height:200px" type="image/svg+xml" data="images/lightsensorNoborder.svg"></object>';
    else 
        content += '<object id="thermometer_' + pathName +'" data-izot-min="0" data-izot-max="500" style="height:220px" type="image/svg+xml" data="images/lightsensorNoborder.svg"></object>';
	content += '</div>';
	content += '<div  style="float:left;display:inline-block">';
	content += '<div style="margin-left: 50px">';
    content += '<span style=\"float:left;display:block\">Light Sensor</span>';
    content += '<span id=\"chartvalue_' + pathName + '\" style=\"float:right;display:block;margin-right:30px\">' + value + '</span>';
    content += '<span id=\"chartpreset_' + pathName + '\" style=\"float:right;display:block;margin-right:30px\">' + presetValue + '</span>';
    content += '</div>';
    if(g_bDashboardSupportLogData && g_bDashboardUseNewChart) {
        /*
        content += '<div style="clear:both; display:block; margin-top:30px; width: 310px; height:168px; text-align:center; z-index: 5; ">';
        content += '<object id="chartSvg_' + pathName + '" type="image/svg+xml" style="width: 300px; height: 150px;" data-izot-textcolor="white" data="images/' + g_sDashboardUseNewChartname + '"></object>';
        content += '</div>';
*/
        content += '<div id="chartParentDiv_' + pathName + '" style="clear:both; display:block; margin-top:30px; text-align:center; z-index: 5; ">';
        content += '<object id="chartSvg_' + pathName + '" type="image/svg+xml" style="height: 170px;" data-izot-textcolor="white" data="images/' + g_sDashboardUseNewChartname + '"></object>';
        content += '</div>';
    }
    else {
        content += '<div id="chartParentDiv_' + pathName + '" style="clear:both; display:block; margin-left: 10px; margin-top:30px; width: 260px; height:218px; text-align:center; z-index: 5; ">';
        content += '<object id="chartSvg_' + pathName + '" type="image/svg+xml" style="width: 250px;height: 200px;" data-izot-textcolor="white" data="images/chart1.svg"></object>';
        content += '</div>';
    }
	content += '<span style="margin-left: 10px">' + shortPathname + '</span>';
	content += '<br>';
	content += '</div>';
    content += '</div>';
    return content;
}
function addMultiSensor(divName, deviceName) {
    var content = "<div style=\"clear:both;display:block\">";
	try {
		powerIndex = 0;
		var content = "<div style=\"clear:both;display:block\">";
	
		content += "<div  class=\"group\"  style=\"float:left;display:inline-block;margin-left:10px;margin-top:10px\">";
		content += "<div style=\"display: none\" data-izot-type=\"javascript\" data-izot-function=\"sumPower\" data-izot-elementid=\"powersum" + powerIndex + "\" data-izot-chartid=\"chart" + powerIndex + "\"> ";
		content += "<div data-izot-name=\"" + deviceName + "/Lamp/0/nvoValueFb\"></div> ";
		content += "<div data-izot-name=\"" + deviceName + "/Lamp/1/nvoValueFb\"></div>";
		content += "</div>";
		content += "<div style=\"float:left;display:inline-block\">";
		content += "<div style=\"float:left;display:inline-block\">";
		content += "<object id=\"powersum" + powerIndex + "\" data-izot-min=\"0\" data-izot-max=\"150\" style=\"width:160px;height:160px\" type=\"image/svg+xml\" data=\"images/gauge.svg\"></object>";
		content += "</div>";
		content += "<br>";
		content += "<div style=\"float:left;display:block\">";
		content += "<div  style=\"float:left;display:inline-block; z-index: 9999;margin-left: 20px;\">";
		content += "<object data-izot-type=\"ledswitchsvg\" data-izot-name=\"" + deviceName + "/Lamp/0/nviValue/state\" data-izot-feedback=\"" + deviceName + "/Lamp/0/nvoValueFb/state\"  data-izot-range-data=\"0:#d3ded3,1:red\" data-izot-basecolor =\"#000000\" style=\"width:40px;height:40px\" type=\"image/svg+xml\" data=\"images/ledSwitchRound.svg\"></object>";
		content += "<br>";
		content += "<span style=\"margin-left: 2px;top:5px\">LED 0</span>";
		content += "</div>";
		content += "<div  style=\"float:left;display:inline-block; z-index: 9999;margin-left: 20px;\">";
		content += "<object data-izot-type=\"ledswitchsvg\" data-izot-name=\"" + deviceName + "/Lamp/1/nviValue/state\" data-izot-feedback=\"" + deviceName + "/Lamp/1/nvoValueFb/state\"  data-izot-range-data=\"0:#d3ded3,1:red\" data-izot-basecolor =\"#000000\" style=\"width:40px;height:40px\" type=\"image/svg+xml\" data=\"images/ledSwitchRound.svg\"></object>";
		content += "<br>";
		content += "<span style=\"margin-left:2px;top:5px\">LED 1</span>";
		content += "</div>";
		content += "</div>";
		content += "<br><br>";
		content += "<div style=\"float:left;display:inline-block\">";
		content += "<input data-izot-type=\"textfield\" data-izot-name=\"" + deviceName + "/Lamp/0/nviValue/value\" data-izot-feedback=\"" + deviceName + "/Lamp/0/nvoValueFb/value\" size=\"4\" style=\"margin-left:15px\" value=\"-\" >";
		content += "<input data-izot-type=\"textfield\" data-izot-name=\"" + deviceName + "/Lamp/1/nviValue/value\" data-izot-feedback=\"" + deviceName + "/Lamp/1/nvoValueFb/value\" size=\"4\" style=\"margin-left:15px\" value=\"-\" >";
		content += "</div>";
		content += "</div>";
		content += "<div  style=\"float:left;display:inline-block\">";
		content += "<div style=\"margin-left: 50px\">";
		content += "<span style=\"float:left;display:block\">Power</span>";
		content += "</div>";
        
        if(g_bDashboardSupportLogData && g_bDashboardUseNewChart) {
            content += '<div style="clear:both; display:block; margin-top:30px; text-align:center; z-index: 5; ">';
            content += '<object id="chartSvg_' + pathName + '" type="image/svg+xml" style="height: 170px;" data-izot-textcolor="white" data="images/' + g_sDashboardUseNewChartname + '"></object>';
            content += '</div>';
        }
        else {
            content += "<div style=\"float:left;display:inline-block; margin-top:10px; width: 240px; height:218px; text-align:center; z-index: 5; \" >";
            content += "<object id=\"chart" + powerIndex + "\" type=\"image/svg+xml\" style=\"width: 250px;height: 200px;\"  data-izot-textcolor=\"white\" data=\"images/chart1.svg\"></object>";
            content += "</div>";
        }
		content += "<br>";
		content += "<span style=\"margin-left: 10px\">" + deviceName + "</span>";
		content += "<br>";
		content += "</div>";
		content += "</div>";
		content += "<div class=\"group\"   style=\"float:left;display:inline-block;margin-left:10px;margin-top:10px\">";
		content += "<div style=\"float:left;display:inline-block\">";
		content += "<object data-izot-type=\"thermometer\" data-izot-name=\"\" + deviceName + \"/LightSensor/0/nvoLuxLevel\" data-izot-min=\"0\" data-izot-max=\"500\" style=\"height:220px\" type=\"image/svg+xml\" data=\"images/lightsensorNoborder.svg\"></object>";
		content += "</div>";
		content += "<div  style=\"float:left;display:inline-block\">";
		content += "<div style=\"margin-left: 50px\">";
		content += "<span style=\"float:left;display:block\">Light Sensor</span><span style=\"float:right;display:block;margin-right:30px\" data-izot-type=\"showvalue\" data-izot-name=\"" + deviceName + "/LightSensor/0/nvoLuxLevel\">--</span>";
		content += "</div>";
        content += "<div style=\"clear:both; display:block; margin-left: 10px; margin-top:30px; width: 260px; height:218px; text-align:center; z-index: 5; \">";
        if(g_bDashboardSupportLogData  && g_bDashboardUseNewChart)
            content += "<object data-izot-type=\"chartsvg\" type=\"image/svg+xml\" style=\"width: 250px;height: 200px;\" data-izot-name=\"" + deviceName + "/LightSensor/0/nvoLuxLevel\" data-izot-dynamicrange=\"true\" data-izot-textcolor=\"white\" data=\"images/" + g_sDashboardUseNewChartname + "\"></object>";
        else
            content += "<object data-izot-type=\"chartsvg\" type=\"image/svg+xml\" style=\"width: 250px;height: 200px;\" data-izot-name=\"" + deviceName + "/LightSensor/0/nvoLuxLevel\" data-izot-dynamicrange=\"true\" data-izot-textcolor=\"white\" data=\"images/chart1.svg\"></object>";
		content += "</div>";
		content += "<span style=\"margin-left: 10px\">" + deviceName + "</span>";
		content += "<br>";
			
		content += "</div>";
        content += "</div>";
        if(divName !== "")
		    document.getElementById(divName).innerHTML += content;
		
	}
    catch {}
    return content;
}
function addThermometer(shortPathname, pathName, value, presetValue) {
    var content = '<div class="group"   style="float:left;display:inline-block;margin-left:10px;margin-top:10px">';
    content += '<div style="float:left;display:inline-block">';
    if(g_bDashboardSupportLogData && g_bDashboardUseNewChart)
        content += '<object id="thermometer_' + pathName +'" data-izot-min="0" data-izot-max="500" style="height:200px" type="image/svg+xml" data="images/thermometerNoborder.svg"></object>';
    else
        content += '<object id="thermometer_' + pathName +'" data-izot-min="0" data-izot-max="500" style="height:220px" type="image/svg+xml" data="images/thermometerNoborder.svg"></object>';
	content += '</div>';
	content += '<div  style="float:left;display:inline-block">';
	content += '<div style="margin-left: 50px">';
	content += '<span style=\"float:left;display:block\">Themometer</span>';
    content += '<span id=\"chartvalue_' + pathName + '\" style=\"float:right;display:block;margin-right:30px\">' + value + '</span>';
    content += '<span id=\"chartpreset_' + pathName + '\" style=\"float:right;display:block;margin-right:30px\">' + presetValue + '</span>';
	content += '</div>';
    if(g_bDashboardSupportLogData && g_bDashboardUseNewChart) {
     
/*        content += '<div style="clear:both; display:block; margin-left: 10px; margin-top:30px; height:168px; text-align:center; z-index: 5; ">';
        content += '<object id="chartSvg_' + pathName + '" type="image/svg+xml" style="height: 150px;" data-izot-textcolor="white" data="images/' + g_sDashboardUseNewChartname + '"></object>';
        content += '</div>'; */
        content += '<div id="chartParentDiv_' + pathName + '" style="clear:both; display:block; margin-top:30px; text-align:center; z-index: 5; ">';
        content += '<object id="chartSvg_' + pathName + '" type="image/svg+xml" style="height: 170px;" data-izot-textcolor="white" data="images/' + g_sDashboardUseNewChartname + '"></object>';
        content += '</div>';
    }
    else {
        content += '<div id="chartParentDiv_' + pathName + '" style="clear:both; display:block; margin-left: 10px; margin-top:30px; width: 260px; height:218px; text-align:center; z-index: 5; ">';
        content += '<object id="chartSvg_' + pathName + '" type="image/svg+xml" style="width: 250px;height: 200px;" data-izot-textcolor="white" data="images/chart1.svg"></object>';
        content += '</div>';
    }
	content += '<span style="margin-left: 10px">' + shortPathname + '</span>';
	content += '<br>';
	content += '</div>';
    content += '</div>';
    return content;
}
function addChart(index, shortPathname, pathName, value, presetValue) {
    return addChart1(index, shortPathname, pathName, value, presetValue, false);
}
function addChart1(index, shortPathname, pathName, value, presetValue,bAddWriteButton) {
    var content = '<div class="group"   style="float:left;display:inline-block;margin-left:10px;margin-top:10px">';
	content += '<div  style="float:left;display:inline-block">';
    content += '<div style="margin-left: 50px">';
    if(bAddWriteButton)
        content += "<button id=\"dpValueMenu_" + pathName + "\" style=\"float:right;display:block;margin-right:30px\" onclick=\"menuDpValue1(0, this, " + index + ", '" + pathName + "')\">...</button>";
    content += '<span id=\"chartvalue_' + pathName + '\" style=\"float:right;display:block;margin-right:30px\">' + value + '</span>';
    content += '<span id=\"chartpreset_' + pathName + '\" style=\"float:right;display:block;margin-right:30px\">' + presetValue + '</span>';
   
	content += '</div>';
    
    if(g_bDashboardSupportLogData && g_bDashboardUseNewChart) {
        /*
        content += '<div style="clear:both; display:block; margin-left: 10px; margin-top:30px;  height:160px; text-align:center; z-index: 5; ">';
        content += '<object id="chartSvg_' + pathName + '" type="image/svg+xml" style="height: 150px;" data-izot-textcolor="white" data="images/' + g_sDashboardUseNewChartname + '"></object>';
        content += '</div>'; */
        /*
        content += '<div style="clear:both; display:block; margin-top:30px; text-align:center; z-index: 5; ">';
        content += '<object id="chartSvg_' + pathName + '" type="image/svg+xml" style="height: 170px;" data-izot-textcolor="white" data="images/' + g_sDashboardUseNewChartname + '"></object>';
        content += '</div>'; */

        content += '<div id="chartParentDiv_' + pathName + '" style="clear:both; display:block; margin-top:30px; text-align:center; z-index: 5; ">';
        content += '<object id="chartSvg_' + pathName + '" type="image/svg+xml" style="height: 170px;" data-izot-textcolor="white" data="images/' + g_sDashboardUseNewChartname + '"></object>';
        content += '</div>';

    }
    else {
        content += '<div id="chartParentDiv_' + pathName + '" style="clear:both; display:block; margin-left: 10px; margin-top:30px; width: 260px; height:218px; text-align:center; z-index: 5; ">';
        content += '<object id="chartSvg_' + pathName + '" type="image/svg+xml" style="width: 250px;height: 200px;" data-izot-textcolor="white" data="images/chart1.svg"></object>';
        content += '</div>';
    }
	content += '<span style="margin-left: 10px">' + shortPathname + '</span>';
	content += '<br>';
	content += '</div>';
    content += '</div>';
    return content;
}
function addValueToDashboardChartList(chartIndex, value, presetValue, timestamp) {
    try { //fix only have two entries per datapoint value. change last entry if previous value two values are the same
        var lastIndex = g_dashboardChartList[chartIndex].data.length;
        if(g_dashboardChartList[chartIndex].data.length > 1) {
            lastIndex --;
            if(isEqual(g_dashboardChartList[chartIndex].data[lastIndex].value, value)) {
                //if(g_idashboardChartType === 0)
                //    return;
                if(isEqual(g_dashboardChartList[chartIndex].data[lastIndex - 1].value, value)) {
                    g_dashboardChartList[chartIndex].data[lastIndex].timestamp = timestamp; 
                    return;
                }
            }
        }
        obj1 = {};
        obj1.value = value;
        if(presetValue !== "")
            obj1.presetValue = presetValue;
        obj1.timestamp = timestamp;
        g_dashboardChartList[chartIndex].data.push(obj1);
    }
    catch {}
}
function configureDashboardChartsParameters() {
    // this is used to setup the XY lengths for the dashboard based on the chart type
    try {
        
        if(g_bDashboardSupportLogData) {
            if(g_bDashboardUseNewChart) {
                switch(g_sDashboardUseNewChartname) {
                    case "chart1.svg":
                        ivChartXLengthLargeChart = ivChartXYLengthChart1; // chart2
                        ivChartYLengthLargeChart = ivChartXYLengthChart1;
                        break;
                    case "chart2.svg":
                        ivChartXLengthLargeChart = ivChartXLengthLargeChart2; // chart2
                        ivChartYLengthLargeChart = ivChartYLengthLargeChart2;
                        break;
                    case "chart4.svg":
                        ivChartXLengthLargeChart = ivChartXLengthLargeChart2; // chart2
                        ivChartYLengthLargeChart = ivChartYLengthLargeChart2;
                        break;
                    case "chart8.svg":
                    case "chart9.svg":
                        ivChartXLengthLargeChart = ivChartXLengthLargeChart9; // chart8
                        ivChartYLengthLargeChart = ivChartYLengthLargeChart9;
                        break;
                }
            }
        }
    }
    catch {}
}
function dashboardGetDatalogCheckBox() {
    g_bDashboardGetDatalog = document.getElementById("dashboardGetDatalogCheckbox").checked;
}
function dashboardNumToFixedLength(num, decimalPlaces){
	// used for charts
	var numOrig = num;
    
    try {
        if(decimalPlaces === -1)
            return;
        if(typeof num === "number") {
            if((num > 1) || (num < 1)) {
                num = Number(num.toFixed(decimalPlaces));
            }
        }
    }
    catch {num = numOrig}
    return num;
}
function dashboardProcessWebSocketDpData(currentTime, timestamp, json) {
    try {  
        var i;
        var datapointQualifier = "", dpQualifier = "", value1 = "", presetValue = "";
        let dashboardType;
        var value;
        var obj, obj1;
        var bInitializeChart = false;
        var bDataEntryRemoved = false;
        var bContinue;
        var d = new Date();
        var currenttimeMs = d.getTime();
        if(g_bDashboardDataLogGetInProgress)
            return;
        for(i= 0; i < json.length; i ++)
        {
            // Web socket response
            datapointQualifier = ""; value1 = "";
            presetValue = "";
            locValue = "";
            locValueStr = "";
            value = "";
            obj = json[i];
            try {
                datapointQualifier = obj.datapointQualifier;
            }
            catch (err) {}
            try {
                value1 = obj.value
            }
            catch (err) {}
            try {
                if(!(typeof obj.presetValue === "undefined"))  {
                    if(obj.presetValue !== null) {
                        presetValue = obj.presetValue;
                    }
                }	
            } 	catch (err) {}
            try {
                if(!(typeof obj.locValue === "undefined"))  {
                    if(obj.locValue !== null) {
                        locValue = obj.locValue;
                        if(typeof locValue === "number") {
                            locValueStr = locValue;
                        }
                        else {
                            locValueStr = JSON.stringify(locValue);
                        }
                    }
                }	
            } 	catch (err) {}

            for(k=0; k < dashboardDpList.length; k++)
            {
                dpQualifier = dashboardDpList[k].dpQualifier;
                //if(dashboardDpList[k].dpQualifier === datapointQualifier) {
                if(dpQualifier === datapointQualifier) {
                    try {
                        bContinue = true;
                        if(dashboardDpList[k].cat === "in") {
                            if(dashboardDpList[k].feedbackDelay) {
                                bContinue = false;
                                if(currenttimeMs > dashboardDpList[k].feedbackDelayTimeout) {
                                    dashboardDpList[k].feedbackDelay = false;
                                    dashboardDpList[k].feedbackDelayTimeout = 0;
                                    bContinue = true;
                                    dashboardDpList[k].updateDpValue = true;
                                }
                                else if ((dashboardDpList[k].locValueStr !== locValueStr) && isNotEqual(dashboardDpList[k].feedbackDelayOldValue, locValue)) {
                                    dashboardDpList[k].feedbackDelay = false;
                                    dashboardDpList[k].feedbackDelayTimeout = 0;
                                    bContinue = true;
                                    dashboardDpList[k].updateDpValue = true;
                                }
                            }
                        }
                        if(bContinue && (dashboardDpList[k].updateDpValue || (isNotEqual(value1, dashboardDpList[k].value)))){
                            dashboardDpList[k].updateDpValue = false;
                            dashboardDpList[k].value = value1;
                            if(typeof value1 === "number")
                                valueStr = value1;
                            else
                                valueStr = JSON.stringify(value1);
                            dashboardDpList[k].valueStr = valueStr;
                            dashboardDpList[k].locValue = locValue;
                            dashboardDpList[k].locValueStr = locValueStr;
                            dashboardDpList[k].presetValue = presetValue;
                            dashboardType = dashboardDpList[k].dashboardType
                            value = locValueStr;
                            
                            if(dashboardType === "n") {
                                if(g_bDashboardMinMaxDecimalPlaces !== -1) {
                                    if(typeof locValue === "number")
                                        locValueStr = dashboardNumToFixedLength(locValueStr, g_iDashboardDecimalPlaces);
                                }
                                if(presetValue !== "")
                                    locValueStr = presetValue;
                                if(dashboardDpList[k].cat === "in")
                                    document.getElementById("localValue_" + dashboardDpList[k].pathName).value = locValueStr;  //locValue required for input
                                else
                                    document.getElementById("localValue_" + dashboardDpList[k].pathName).innerHTML = locValueStr;
                                dashboardDpList[k].timestampStr = currentTime;
                                //document.getElementById("timestamp_" + dashboardDpList[k].pathName).innerHTML = dashboardDpList[k].timestampStr;
                            }
                            else if(dashboardType === "a") { //SNVT_str_ascii
                                locValueStr = value1.ascii;
                                if(presetValue !== "")
                                    locValueStr = presetValue;
                                if(dashboardDpList[k].cat === "in")
                                    document.getElementById("localValue_" + dashboardDpList[k].pathName).innerHTML = locValueStr;
                                else
                                    document.getElementById("localValue_" + dashboardDpList[k].pathName).innerHTML = locValueStr;
                                dashboardDpList[k].timestampStr = currentTime;
                                //document.getElementById("timestamp_" + dashboardDpList[k].pathName).innerHTML = dashboardDpList[k].timestampStr;
                            }
                            else if(dashboardDpList[k].dashboardType === "l2") {
                                if(typeof dashboardDpList[k].locValue === "number") {
                                    if(dashboardDpList[k].locValue === 1)
                                        document.getElementById("localValue_" + dashboardDpList[k].pathName).className = "ledDotOn";
                                    else 
                                        document.getElementById("localValue_" + dashboardDpList[k].pathName).className = "ledDotOff";
                                }
                                else if(typeof dashboardDpList[k].locValue === "boolean") {
                                    if(dashboardDpList[k].locValue === true)
                                        document.getElementById("localValue_" + dashboardDpList[k].pathName).className = "ledDotOn";
                                    else 
                                        document.getElementById("localValue_" + dashboardDpList[k].pathName).className = "ledDotOff";
                                }
                            }
                            else if((dashboardDpList[k].dashboardType === "l3") || (dashboardDpList[k].dashboardType === "l4")) {
                                if(dashboardDpList[k].dashboardType === "l3")
                                    document.getElementById("localValue_" + dashboardDpList[k].pathName).innerHTML = locValue.value.toString();
                                if(dashboardDpList[k].locValue.state === 1) 
                                    document.getElementById("localValueSwitch_" + dashboardDpList[k].pathName).className = "ledDotOn";
                                else 
                                    document.getElementById("localValueSwitch_" + dashboardDpList[k].pathName).className = "ledDotOff";
                            }
                            else if(dashboardDpList[k].dashboardType === "s2") {
                                if(typeof dashboardDpList[k].locValue === "number") {
                                    if(dashboardDpList[k].locValue === 1)
                                        document.getElementById("localValueSwitch_" + dashboardDpList[k].pathName).checked = true;
                                    else 
                                        document.getElementById("localValueSwitch_" + dashboardDpList[k].pathName).checked = false;
                                }
                                else if(typeof dashboardDpList[k].locValue === "boolean") {
                                    
                                    if(dashboardDpList[k].locValue === true)
                                        document.getElementById("localValueSwitch_" + dashboardDpList[k].pathName).checked = true;
                                    else 
                                        document.getElementById("localValueSwitch_" + dashboardDpList[k].pathName).checked = false;
                                   
                                }
                            }
                            else if((dashboardDpList[k].dashboardType === "s3") || (dashboardDpList[k].dashboardType === "s4")) {
                                if(dashboardDpList[k].dashboardType === "s3")
                                    document.getElementById("localValue_" + dashboardDpList[k].pathName).value = locValue.value.toString();
                                if(dashboardDpList[k].locValue.state === 1) 
                                    document.getElementById("localValueSwitch_" + dashboardDpList[k].pathName).checked = true;
                                else 
                                    document.getElementById("localValueSwitch_" + dashboardDpList[k].pathName).checked = false;
                            }
                            else {
                                // all others have chart
                                chartIndex = dashboardDpList[k].chartIndex;
                                    // determine if range changed
                                value = dashboardDpList[k].locValue
                                if(dashboardType === "xi") { // IOX input level
                                   value = value.level;
                                    if(value === true)
                                        value = 1;
                                    else 
                                        value = 0;
                                }
                                else if(dashboardType === "xf") { // IOX input frequency
                                    value = value.freqency;
                                     
                                 }
                                bInitializeChart = false;
                                if(g_bDashboardChartDynamicRange) {
                                    bDataEntryRemoved = false;
                                    if(g_bDashboardSupportLogData) {
                                        addValueToDashboardChartList(chartIndex, value, presetValue, timestamp);
                                        bDataEntryRemoved = checkDashboardChartListRemoveOldEntries(chartIndex, currenttimeMs);
                                        if(g_dashboardChartList[chartIndex].data.length > 0) {
                                            g_dashboardChartList[chartIndex].startTimestamp = g_dashboardChartList[chartIndex].data[0].timestamp
                                            g_dashboardChartList[chartIndex].endTimestamp = g_dashboardChartList[chartIndex].data[g_dashboardChartList[chartIndex].data.length - 1].timestamp
                                            g_dashboardChartList[chartIndex].endPtr = g_dashboardChartList[chartIndex].data.length - 1;
                                            g_dashboardChartList[chartIndex].dataCurrentEntries = g_dashboardChartList[chartIndex].data.length;
                                        }
                                        else {
                                            g_dashboardChartList[chartIndex].startTimestamp = null;
                                            g_dashboardChartList[chartIndex].endTimestamp = null;
                                            g_dashboardChartList[chartIndex].dataCurrentEntries = 0;
                                            g_dashboardChartList[chartIndex].startPtr = -1;
                                            g_dashboardChartList[chartIndex].endPtr = -1;
                                        }
                                    }
                                    if(g_dashboardChartList[chartIndex].data.length === 1) {
                                        // needed in case the charts are cleared with a clear chart button
                                        bDataEntryRemoved = true;
                                        bInitializeChart = true;
                                    }

                                    if(bDataEntryRemoved)
                                        dashboardDetermineChartMinMaxValuesForChart(0, chartIndex, null, true);
                                    else 
                                        dashboardDetermineChartMinMaxValuesForChart(1, chartIndex, value, true);
                                }
                                else {
                                    if(value > g_dashboardChartList[chartIndex].maxValue) {
                                        fvalue = parseFloat(value);
                                        if(fvalue < 0) 
                                            fvalue1 = 0;
                                        else if(fvalue < 1) 
                                            fvalue1 = 1;
                                        else if(fvalue < 5)
                                            fvalue1 = 5;
                                        else if(fvalue > 1) 
                                            fvalue1 = (Math.round(fvalue / 10) + 1) * 10;
                                        g_dashboardChartList[chartIndex].maxValue = fvalue1;
                                        bInitializeChart = true;
                                    }
                                    if(value < g_dashboardChartList[chartIndex].minValue) {
                                        fvalue = parseFloat(value);
                                        if(fvalue < 0) 
                                            fvalue1 = (Math.round(fvalue / 10) - 1) * 10;
                                        else if(fvalue < 1) 
                                            fvalue1 = 0;
                                        else if(fvalue < 5)
                                            fvalue1 = 0;
                                        else if(fvalue > 1) 
                                            fvalue1 = (Math.round(fvalue / 10) - 1) * 10;
                                        g_dashboardChartList[chartIndex].minValue = fvalue1;
                                        bInitializeChart = true;
                                    }
                                }
                                if(g_bDashboardNeedToInitializeSvg) {

                                }
                                else if(!g_bdashboardChartPause) {
                                    if(bInitializeChart) {
                                        
                                        ivInitializeChart1(g_bDashboardSupportLogData, g_dashboardChartList[chartIndex].displayId, g_dashboardChartList[chartIndex].minValue, g_dashboardChartList[chartIndex].maxValue, null, null, "white", null, g_dashboardChartList[chartIndex].chartlabels);
                                    }
                                    if(g_bDashboardMinMaxDecimalPlaces !== -1) {
                                        if(typeof locValue === "number")
                                            value = dashboardNumToFixedLength(value, g_iDashboardDecimalPlaces);
                                    }
                                    document.getElementById("chartvalue_" + dashboardDpList[k].pathName).innerHTML = value;
                                    document.getElementById("chartpreset_" + dashboardDpList[k].pathName).innerHTML = presetValue;
                                    dashboardUpdateCharts(chartIndex, value, null);
                                    if((dashboardType === "t") || (dashboardType === "l")) {
                                        obj = dashboardDpList[k];
                                        if(dashboardType === "l") {
                                            if(g_dashboardChartList[chartIndex].maxValue > obj.max) {
                                                obj.max = g_dashboardChartList[chartIndex].maxValue;
                                                ivInitializeThermometer(0, obj.displayId, i, value, obj.min, obj.max, obj.unit);
                                                //ivInitializeThermometer(0, obj.displayId, i, obj.locValue, obj.min, obj.max, obj.unit)
                                            }
                                        }
                                        ivSetThermometerValue(obj.displayId, value, obj.min, obj.max, obj.svgMin, obj.svgMax)
                                        //ivSetThermometerValue(obj.displayId, obj.locValue, obj.min, obj.max, obj.svgMin, obj.svgMax)
                                    }
                                }
                            }
                           
                        }
                        else { // same value but different timestamp
                            if(typeof dashboardDpList[k].chartIndex !== "undefined") {
                                chartIndex = dashboardDpList[k].chartIndex;
                                value = g_dashboardChartList[chartIndex].data[g_dashboardChartList[chartIndex].data.length - 1].value;
                                addValueToDashboardChartList(chartIndex, value, presetValue, timestamp);
                                bDataEntryRemoved = checkDashboardChartListRemoveOldEntries(chartIndex, currenttimeMs);
                                
                                if(g_dashboardChartList[chartIndex].data.length > 0) {
                                    g_dashboardChartList[chartIndex].startTimestamp = g_dashboardChartList[chartIndex].data[0].timestamp
                                    g_dashboardChartList[chartIndex].endTimestamp = g_dashboardChartList[chartIndex].data[g_dashboardChartList[chartIndex].data.length - 1].timestamp
                                    g_dashboardChartList[chartIndex].endPtr = g_dashboardChartList[chartIndex].data.length - 1;
                                    g_dashboardChartList[chartIndex].dataCurrentEntries = g_dashboardChartList[chartIndex].data.length;
                                }
                                if(bDataEntryRemoved) {
                                    dashboardDetermineChartMinMaxValuesForChart(0, chartIndex, null, true);
                                }
                                if(g_bDashboardNeedToInitializeSvg) {

                                }
                                else if(!g_bdashboardChartPause)
                                    dashboardUpdateCharts(chartIndex, value, null);
                            }
                        }
                    }
                    catch {}
                    break;
                }
            }
        }
    }
    catch {}
}
function dashboardPollCheckBox() {
	var min;
	if(g_idpGetRequestIndex === -1)
		return;
	if(g_dpGetRequestArr[0] === "") 
		return;
	if((g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) && (dashboardDpList.length > 0)) { 
		if(document.getElementById("dashboardPollCheckbox").checked) {
            /*
			var pollRate = document.getElementById("pollrate").value;   
			pollRate  = Number(pollRate );
			if(isNaN(pollRate ))
				return;
			g_iPollingRequestCountMax = pollRate;
			min = Math.ceil(dashboardDpList.length / g_iMaxOfDpsToPollPerInterval);
				if(pollRate < (min * g_iBackgroundPollingRequestCountMax)) 
                */
            g_bDashboardPollEnabled = true;
            g_PollingType = DISPLAYMODE_DASHBOARD;
            g_idpGetRequestIndex = 0;
            g_bPollingEnabled = true;
            g_iPollingRequestCount = g_iPollingRequestCountMax;
            ivbWsProcessDatapointUpdate = true;
            if(g_sWebSocketSubscribePayload !== g_sWebSocketSubscribePayload_oldvalue)
			    subscribeRequest();
			//g_iBackgroundPollingRequestCount = g_iBackgroundPollingRequestCountMax + 12; //start request
            g_bDashboardPollEnabled = true;
			
			try {
				// ivGetDeviceList(); // IOT get device list later
				if(g_timerId === 0)
					g_timerId = window.setInterval("timerHandler()", g_iTimerInterval);
			} catch (err) {} 
		}
		else {
            g_bDashboardPollEnabled = false;
            g_PollingType = 0;
            g_bPollingEnabled = false;
            //ivbWsProcessDatapointUpdate = false;
        }
	}
}
function dashboardSaveData(mode) {
    menuCancel();
    saveData(mode);
}
function dashboardSteplinCheckBox() {
    g_idashboardChartType = 0;
    if(document.getElementById("dashboardSteplineCheckbox").checked)
        g_idashboardChartType = 1;
}
function dashboardOptionsCheckBox() {
    try {
        g_bDashboardOptionsMenu = document.getElementById("dashboardOptionsCheckbox").checked;
        if(g_bDashboardOptionsMenu)
            document.getElementById("dashboardOptionsMenu").style.display = "inline-block";
        else
            document.getElementById("dashboardOptionsMenu").style.display = "none";
    }
    catch {}
}
function  dashboardDetermineDuration() {

    switch(g_iDashboardChartDuration) {
        case 0:
            g_iDashboardChartMaxDuration = 0; 
            break;
        case 1:
            g_iDashboardChartMaxDuration = 10 * 60 * 1000; //10 minutes
            break;
        case 2:
            g_iDashboardChartMaxDuration = 60 * 60 * 1000; // hour
            break;
        case 3:
            g_iDashboardChartMaxDuration = 120 * 60 * 1000; // 2 hours
            break;
        case 4:
            g_iDashboardChartMaxDuration = 60 * 24  * 60 * 1000; // 1 day
            break;
        default:
            g_iDashboardChartMaxDuration = 60 * 60 * 1000; // hour
            break;
    } 
}
function dashboardLogSelectionChanged() {
    try {
        g_iDashboardDatalogRange = document.getElementById("dashboardLogDuration").value;
        if(typeof g_iDashboardDatalogRange === "string")
            g_iDashboardDatalogRange = Number(g_iDashboardDatalogRange);

        g_iDashboardChartDuration = document.getElementById("dashboardDuration").value;
        if(typeof g_iDashboardChartDuration === "string")
            g_iDashboardChartDuration = Number(g_iDashboardChartDuration);
    
        g_idashboardChartMaxNumberOfEntries = 0;
        g_iDashboardChartMaxDuration = 0;
        dashboardDetermineDuration();
 
    }
    catch {}

} 
function dashboardOutputsCheckbox() {
    g_bDashboard_UseChartForAllOutputs = document.getElementById("dashboardChartOutputsCheckbox").checked;
    g_sDashboardMainContent = "";
    g_sDashboardPaneTitleContext = "";
    showDashboard(7,'', -1);

} 
function dashboardInputsCheckbox() {
    g_bDashboard_UseChartForAllInputs = document.getElementById("dashboardChartInputsCheckbox").checked;
    g_sDashboardMainContent = "";
    g_sDashboardPaneTitleContext = "";
    showDashboard(7,'', -1);

} 
function dashboardToolTipCheckbox() {
    try {
        if(g_bDashboardSupportDisplayMouseToolTip) 
            g_bDashboardDisplayMouseToolTip = document.getElementById("dashboardChartToolTipCheckbox").checked;
    }
    catch (err) {}
}
function dashboardToolTipPresetCheckbox() {
    try {
        if(g_bDashboardSupportDisplayMouseToolTip) 
            g_bDashboardDisplayMouseToolTipShowPresets  = document.getElementById("dashboardChartToolTipPresetCheckbox").checked;
    }
    catch (err) {}
}
function dashboardPause() {
    var text = document.getElementById("pauseButton").innerText;
    if(text === "Pause") {
        g_bdashboardChartPause = true;
        document.getElementById("pauseButton").innerText = "Continue";
    }
    else {
        g_bdashboardChartPause = false;
        document.getElementById("pauseButton").innerText = "Pause";
    }
}
function dashboardRefresh() {
    //
    // remove datalog data
    g_bDashboardDataLogGetInProgress = true;
    try {
        for(i=0; i < g_dashboardChartList.length; i ++)
        {
            g_dashboardChartList[i].data = [];
            g_dashboardChartList[i].maxValue = null;
            g_dashboardChartList[i].minValue = null;
            g_dashboardChartList[i].bMinMaxEqual = true;
        }
        for(i=0; i < g_dashboardChartList.length; i ++)
        {
            dashboardDpList[i].datalogData = [];
            dashboardDpList[i].updateDpValue = true;
        }
        if(g_bDashboardGetDatalog && (g_iDashboardDatalogRange > 0)) {
            getDashboardDatalogData(50, "", "", "");
        }
        else
            g_bDashboardDataLogGetInProgress = false;

    }
    catch {}
    ivInitializeChart3Clear2Yaxis(false, "", g_dashboardChartList);
}
function dashboardUseCurrentPriorityCheckbox() {
    //g_bDashboard_UseCurrentPriorityForAllRights = document.getElementById("dashboardUseCurrentPriorityCheckbox").checked;
    //showDashboard(0,'', -1);
    alert("Not supported yet");

}
function dashboardUpdateCharts(chartIndex, value, timestamp) {
    if(g_bDashboardNeedToInitializeSvg)
        return;
    if(g_bDashboardSupportLogData && g_bDashboardUseNewChart) {
        //ffix change to using dynmic timestamp charting
        //ivUpdateCharts(chartIndex, value, null);
        var chartObj = g_dashboardChartList[chartIndex];
        var chartObjList = [];
        var temp = 1;
        var sExtraStr = "";  //used to specify duration
        chartObjList.push(chartObj);
        //ivUpdateChartsDatalog(chartObj.displayId, sExtraStr, g_idashboardChartType, chartIndex, g_dashboardChartList, null,chartObj.minValue, chartObj.maxValue, chartObj.startTimestamp, chartObj.endTimestamp);
        ivUpdateChartsDatalogChart3TwoYaxis(chartObj.displayId, sExtraStr, g_idashboardChartType, 0, chartObjList,  null,chartObj.minValue, chartObj.maxValue, null, null, 
            chartObj.startTimestamp, chartObj.endTimestamp, giDashboardChartLineWidth, true, "both");
        
    }
    else
        ivUpdateCharts(chartIndex, value, null);
}
function dashboardRestart() {  //remove no longer used
    try {
        var i, index, err,step;
        // showDashboard(0) - going to Dashboard View from another view
        createRequestString(dashboardDpList);
        for(i = 0; i < g_dashboardChartList.length; i++)
        {
            index = i;
            step = 0;
            if(g_dashboardChartList[index].data.length > 0) {
                g_dashboardChartList[index].creatChartLine = true;
                step = 1;
                ivInitializeChart1(g_bDashboardSupportLogData, g_dashboardChartList[index].displayId, g_dashboardChartList[index].minValue, g_dashboardChartList[index].maxValue, null, null, "white", null, g_dashboardChartList[index].chartlabels);
                step = 2;
                dashboardUpdateCharts(index, null, null);
                step = 3;
            }
        }
        step = 4;
        for(i=0; i < dashboardDpList.length; i++)
        {
            
            dashboardDpList[i].updateDpValue = true;
            
        }
        //initializeSvgDashboard(); // already have chart so just use new values
        if(g_bDashboardPollEnabled)
            g_PollingType = DISPLAYMODE_DASHBOARD;
        bDataLogGetInProgress = false;
        g_bDashboardDataLogGetInProgress = false;
        alert("reset complete");
        if(g_timerId === 0)
            g_timerId = window.setInterval("timerHandler()", g_iTimerInterval);
        
    }
    catch (e) {
        err = "Error: " + e.toString() + "\r\n\r\nindex = " + index + ", step: " + step; 
        alert(err);
    }
}
function getDashboardDatalogData(mode, title, templateType, bAddDeviceName) {
    // mode: 50=refresh (don't re-draw screen)
    var d, t, t1 = 1, iPtr, n, wsUrl = "/iap/ws?value=";
    if(g_bDashboardGetDatalog && (g_iDashboardDatalogRange > 0)) {
        try {

            //enhancements change wsUrl for device or specific datapoint
            g_dashboardDataLogRequestInfo = {};
            g_dashboardDataLogRequestInfo.mode = mode;
            g_dashboardDataLogRequestInfo.title = title;
            g_dashboardDataLogRequestInfo.templateType = templateType;
            g_dashboardDataLogRequestInfo.bAddDeviceName = bAddDeviceName;
            d = new Date();
            if(g_iDashboardDatalogRange === 1) 
                d.setTime(d.getTime() - (10 * 60 * 1000)); // 10 min
            else if(g_iDashboardDatalogRange === 2) 
                d.setTime(d.getTime() - (t1 * 60 * 60 * 1000)); // hour
            else if(g_iDashboardDatalogRange === 4) 
                    d.setTime(d.getTime() - (t1 * 24 * 60 * 60 * 1000)); // day
            //else if(g_iDashboardDatalogRange === 3) {
            //    t1 = 10;
            //    d.setTime(d.getTime() - (t1  * 60 * 1000)); //min
            //}
            n = d.toISOString();
            n = n.substr(0, n.length - 1);
            if(n !== "") {
                n = n.replace(/:/g,"%3A")
                wsUrl += "%2A%2Butc%3E" + n;
            }
            g_bDashboardDataLogGetInProgress = true;
            if(mode !== 50)
                mode = 30;
            createDataLogClientWebSocketConnection(mode, wsUrl);
        }
        catch {
            showDashboardUi((mode + 20), title, null, templateType, bAddDeviceName);
        }
    }
    else
        showDashboardUi((mode + 20), title, null, templateType, bAddDeviceName);
}
function getDashboardDatalogDataResponse(mode, request, datalogData) {
    try {
        var i,j, data,temp,k, bDPsWithAtleastOneOutofOrdervalue = 0, timestamp1, timestamp2,bContinue;
        var tempObj, bContinue, chartIndex;
        
        if(datalogData !== null) { //"") {
            g_dashboardDatalogData = datalogData; //JSON.parse("[" + datalogData + "]");
            //populate datapoint information

            // clear current cache
            for(j=0; j < dashboardDpList.length; j++)
            {
                dashboardDpList[j].datalogData = [];
    
            }
            for(i=0; i < g_dashboardDatalogData.length; i++)
            {
                for(j=0; j < dashboardDpList.length; j++)
                {
                    if(g_dashboardDatalogData[i].dpQualifier === dashboardDpList[j].dpQualifier) {
                        data = {};
                        data.value = g_dashboardDatalogData[i].localizedValue; //g_dashboardDatalogData[i].value;
                        data.utc = g_dashboardDatalogData[i].utc;
                        data.local = g_dashboardDatalogData[i].local;
                        if(typeof g_dashboardDatalogData[i].presetValue !== "undefined") {
                            if(g_dashboardDatalogData[i].presetValue !== "")
                                data.presetValue = g_dashboardDatalogData[i].presetValue;
                        }
                        temp = g_dashboardDatalogData[i].utc;
                        data.timestamp = Date.parse(temp.substr(0,(temp.length - 5)));
                        //data.timestamp = d1.getTime();
                        dashboardDpList[j].datalogData.unshift(data);
                    }
                }
            }
            // reorder if necessary
            for(i=0; i < dashboardDpList.length; i++)
            {
                bContinue = true;
                if(dashboardDpList[i].datalogData.length > 0) {
                    while(bContinue)
                    {
                        bContinue = false;
                        for(j=0; j < (dashboardDpList[i].datalogData.length - 1); j++)
                        {
                            timestamp1 = dashboardDpList[i].datalogData[j].timestamp;
                            timestamp2 = dashboardDpList[i].datalogData[j + 1].timestamp;
                            if(timestamp1 > timestamp2) {
                                bContinue = true;
                                tempObj = {};
                                tempObj = JSON.parse(JSON.stringify(dashboardDpList[i].datalogData[j]));
                                dashboardDpList[i].datalogData[j] = JSON.parse(JSON.stringify(dashboardDpList[i].datalogData[j + 1]));
                                dashboardDpList[i].datalogData[j + 1] = tempObj;
                                bDPsWithAtleastOneOutofOrdervalue ++;
                            }
                        }

                    }
                    // change start and end times
                    k = dashboardDpList[i].datalogData.length;
                    dashboardDpList[i].startTimestamp = dashboardDpList[i].datalogData[0].timestamp;
                    dashboardDpList[i].endTimestamp = dashboardDpList[i].datalogData[k - 1].timestamp;
                }
            }
        }
    }
    catch {g_dashboardDatalogData = [];} 
    //if(bDPsWithAtleastOneOutofOrdervalue > 0)
    //    alert("Datalog DPs with out of order logs = " + bDPsWithAtleastOneOutofOrdervalue);
    if(mode === 50) {
        // refresh
        for(i=0; i < dashboardDpList.length; i++)
        {
            if(dashboardDpList[i].chartIndex !== null) {
                dashboardDpList[i].updateDpValue = true;
                chartIndex = dashboardDpList[i].chartIndex;
                if(chartIndex < g_dashboardChartList.length) {
                    g_dashboardChartList[chartIndex].data = dashboardDpList[i].datalogData;
                    if(g_dashboardChartList[chartIndex].data.length > 0) {
                        g_dashboardChartList[chartIndex].endPtr = g_dashboardChartList[chartIndex].data.length - 1;
                        g_dashboardChartList[chartIndex].startTimestamp = g_dashboardChartList[chartIndex].data[0].timestamp;
                        g_dashboardChartList[chartIndex].endTimestamp = g_dashboardChartList[chartIndex].data[g_dashboardChartList[chartIndex].data.length - 1].timestamp;
                        g_dashboardChartList[chartIndex].dataCurrentEntries = g_dashboardChartList[chartIndex].data.length;
                        dashboardDetermineChartMinMaxValuesForChart(0, chartIndex, null, true);
                        dashboardUpdateCharts(chartIndex, null, null);
                    }
                    else {
                        g_dashboardChartList[chartIndex].endPtr = 0;
                        g_dashboardChartList[chartIndex].startTimestamp = 0;
                        g_dashboardChartList[chartIndex].endTimestamp = 0;
                        g_dashboardChartList[chartIndex].dataCurrentEntries = 0;
                    }
                }
            }
        }
        //initializeSvgDashboard(); // already have chart so just use new values
        g_bDashboardDataLogGetInProgress = false;
        return;
    }
    showDashboardUi((g_dashboardDataLogRequestInfo.mode + 20), g_dashboardDataLogRequestInfo.title, null, g_dashboardDataLogRequestInfo.templateType, g_dashboardDataLogRequestInfo.bAddDeviceName);
    
}
function showDashboard(mode, title, index) {
    // mode: 10= got data log data now populate dashboard
    var i;
    var paneTitle = "<div style=\"display:inline-block\">Dashboard: <span id=\"dashboardTitle\">" + title + "</span></div><div style=\"display:inline-block;float:right;margin-left:30px\">";
    var paneContent = "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting Data ...</span></div>";
    if(mode !== 7){
        savePrevousHtmlContent();
        initializeDisplay();
        dashboardDetermineDuration();
        if(mode !== 0)
            g_bdashboardChartPause = false;
    }
    g_iMainDisplayMode = DISPLAYMODE_DASHBOARD; 
    g_bDashboardNeedToInitializeSvg = true;
    g_bDashboardDataLogGetInProgress = true; // disable background polling until UI built, and if svg until svg initializaed
    configureDashboardChartsParameters();
    if(((mode === 0) && (dashboardDpList.length > 0)) || (mode === 7)) {
        title = g_sDashboardTitle;
        paneContent = "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Building Dashboard ...</span></div>";;
    }
    g_sDashboardPaneTitleContext = "";
    g_sDashboardMainContent = "";
    
    if(g_bDashboardSupportLogData) { 
        
        
        paneTitle += "<div id=\"dashboardOptionsMenu\" style=\"display:";
        if(g_bDashboardOptionsMenu)
            paneTitle += "inline-block";
        else
            paneTitle += "none";
        paneTitle += "\">";
        paneTitle += "<input id=\"dashboardGetDatalogCheckbox\" type=\"checkbox\" onclick=\"dashboardGetDatalogCheckBox()\"";
        if(g_bDashboardGetDatalog)
            paneTitle += " checked";
        paneTitle += ">";
        //paneTitle += "1 hour Data Log";
        paneTitle += "<select id=\"dashboardLogDuration\" onchange=\"dashboardLogSelectionChanged()\">";
        paneTitle += "<option value=\"1\">10 Min Log</option><option value=\"2\" selected>1 Hour Log</option>";
        paneTitle += "<option value=\"4\">1 Day Log</option>"
        paneTitle += "</select>";
        paneTitle += "<span style=\"margin-left:10px\">Duration </span>";
        paneTitle += "<select id=\"dashboardDuration\" onchange=\"dashboardLogSelectionChanged()\">";
        paneTitle += "<option value=\"0\">No Limit</option><option value=\"1\">10 Min</option><option value=\"2\">1 Hour</option>";
        paneTitle += "<option value=\"3\">2 Hour</option><option value=\"4\">1 Day</option>"
        paneTitle += "</select>";
    }
    
    paneTitle += "<input id=\"dashboardPollCheckbox\" type=\"checkbox\" onclick=\"dashboardPollCheckBox()\"";
    if(g_bDashboardPollEnabled)
        paneTitle += " checked";
    paneTitle += ">Poll ";

    

    paneTitle += "<input id=\"dashboardSteplineCheckbox\" type=\"checkbox\" onclick=\"dashboardSteplinCheckBox()\"";
    if(g_idashboardChartType)
        paneTitle += " checked";
    paneTitle += ">Stepline ";
    
    paneTitle += "<input id=\"dashboardChartInputsCheckbox\" type=\"checkbox\" onclick=\"dashboardInputsCheckbox()\"";
    if(g_bDashboard_UseChartForAllInputs) 
        paneTitle += " checked";
    
    paneTitle += ">Chart Scalars Inputs";
    paneTitle += "<input id=\"dashboardChartOutputsCheckbox\" type=\"checkbox\" onclick=\"dashboardOutputsCheckbox()\"";
    if(g_bDashboard_UseChartForAllOutputs) 
        paneTitle += " checked";
    
    paneTitle += ">Chart Scalars Outputs";
    if(g_bDashboardSupportDisplayMouseToolTip) {
        paneTitle += "<input id=\"dashboardChartToolTipCheckbox\" type=\"checkbox\" onclick=\"dashboardToolTipCheckbox()\"";
        if(g_bDashboardDisplayMouseToolTip) 
            paneTitle += " checked";
        paneTitle += ">Chart Tooltip [";
        paneTitle += "<input id=\"dashboardChartToolTipPresetCheckbox\" type=\"checkbox\" onclick=\"dashboardToolTipPresetCheckbox()\"";
        if(g_bDashboardDisplayMouseToolTipShowPresets)
            paneTitle += " checked";
        paneTitle += ">Preset]";
    }
    paneTitle += " Decmial Places <select id=\"dashboardDecimalPlaces\" onchange=\"dashboardDecimialPlaces()\"><option value=\"-1\">all</option>";
    paneTitle += "<option value=\"0\">none</option><option value=\"1\">1</option>";
    paneTitle += "<option value=\"2\">2</option><option value=\"3\">3</option><option value=\"4\">4</option></select>";
    paneTitle += "<button id=\"dashboardSaveButton\" onclick=\"menuDashboardSave(this)\">Save</button>"
    paneTitle += "  </div>"
    paneTitle += "<input id=\"dashboardOptionsCheckbox\" type=\"checkbox\" onclick=\"dashboardOptionsCheckBox()\"";
    if(g_bDashboardOptionsMenu)
        paneTitle += " checked";
    paneTitle += "> Advanced ";
    paneTitle += "<button onclick=\"subscribeRequest()\">re-Subscribe</button>";
    paneTitle += "<div style=\"display:inline-block; width=100px\"><button id =\"pauseButton\" onclick=\"dashboardPause()\">";
    if(!g_bdashboardChartPause)
        paneTitle += "Pause";
    else 
        paneTitle += "Continue";
    paneTitle += "</button></div>";
    
    paneTitle += "<button onclick=\"dashboardRefresh()\">Refresh</button>";
    paneTitle += "<button onclick=\"clearDashboardCharts()\">Clear Charts</button>";
    

    //paneTitle += "<input id=\"dashboardChartBacnetAvCheckbox\" type=\"checkbox\" onclick=\"dashboardUseCurrentPriorityCheckbox()\"";
    //if(g_bDashboard_UseCurrentPriority) 
    //    paneTitle += " checked";
    
    //paneTitle += ">Use Current Priority (TBD)";
    if(mode !== 7)
        document.getElementById("main-Header").innerHTML = paneTitle;
    document.getElementById("main").innerHTML =  paneContent;
    document.getElementById("dashboardLogDuration").value = g_iDashboardDatalogRange;
    document.getElementById("dashboardDuration").value = g_iDashboardChartDuration;
    document.getElementById("dashboardDecimalPlaces").value = g_iDashboardDecimalPlaces;
    if(g_bDashboardSupportLogData) { 
        //ffixx add code for select 
    }
    

    
    if(mode === 0) {
        if(dashboardDpList.length > 0)
            showDashboardUi(60, title, null, "", g_bAddDeviceName); // showDashboardUi(20, title, null, "", g_bAddDeviceName);
        else
            showDashboardUi(0, "", null, "", g_bAddDeviceName);
    }
    else if(mode === 1){
        menuCancel();
        // Build up DpList for device datapoints and then
        for(i=0; i < deviceDpList.length; i++)
        {
            if(deviceDpList[i].deviceName === title){
                g_sDashboardTemplateType = deviceDpList[i].deviceTypeName;
                showDashboardUi(1, title, JSON.parse(JSON.stringify(deviceDpList[i].datapoints)), "", g_bAddDeviceName);
                return;
            }
        }
        
        g_sDashboardDevice = title;
        g_bAddDeviceName = true;
        for(i=0; i < deviceListAll.length; i++)
        {
            if(deviceListAll[i].id === index) {
                if(deviceListAll[i].name === title) {
                    if(typeof deviceListAll[i].deviceTypeName === "undefined") {
                        // get device type
                        var url = "https://" + location.hostname + "/iap/devs/*+name==" + title;
	                    requestGetData(title, url, showDashboardDeviceTemplateResponse, readFailCallback);
                    }
                    else {
                        g_sDashboardTemplateType = deviceListAll[i].deviceTypeName; 
                        requestGetData(title, "/iap/devs/*+name==" + title + "/if/*/*/*/*", showDashboardDeviceDpListResponse, readFailCallback);
                    }
                    break;
                }
            }
        }
    }
    else if(mode === 2) {
        g_bAddDeviceName = true;
        g_sDashboardDevice = title;
        showDashboardUi(1, title, dpList, "", g_bAddDeviceName);
        
        
    }
    else if(mode === 3) {
        g_bAddDeviceName = true;
        g_sDashboardDevice = title;
        showDashboardUi(1, title, favDpList, "", g_bAddDeviceName);
        
    }
    else if(mode === 4) {
        g_bAddDeviceName = true;
        g_sDashboardDevice = title;
        showDashboardUi(1, title, planningDpList, "", g_bAddDeviceName);
        
    }
    else if(mode === 7) {
            // rebuild
        showDashboardUi(1, title, null, "", g_bAddDeviceName);
        
    }
    else if(mode === 8)
        showDashboardUi(1, g_sDashboardDevice, dpList, g_sDashboardTemplateType, g_bAddDeviceName);
}
function showDashboardDeviceTemplateResponse(mode, requestUrl, json) {
    // mode = device name
    for(i = 0; i < deviceListAll.length; i ++)
    {
        if(deviceListAll[i].name === mode) {
            deviceListAll[i].deviceTypeName === json[0].deviceTypeName;
            g_sDashboardTemplateType = deviceListAll[i].deviceTypeName; 
            requestGetData(mode, "/iap/devs/*+name==" + mode + "/if/*/*/*/*", showDashboardDeviceDpListResponse, readFailCallback);
            break;
        }
    }

}
function showDashboardDeviceDpListResponse(mode, requestUrl, json) {
    // mode = device name
    var i, z = -1, obj, programmaticPathname, pathName, presetValue = "", locValueStr = "", locValue, unit, priority = -1, lon_cfg;
    if(json.length === 0)
        return;
    for(i=0; i < json.length; i ++)
    {
        unit = ""; presetValue = ""; LocValueStr = ""; locValue = null; programmaticPathname = ""; pathName = ""; priority = -1;
        if(json[i].name === null)
            json[i].name = json[i].datapointName;
        programmaticPathname = json[i].deviceName + "/" + json[i].blockName  + "/" + json[i].blockIndex  + "/" + json[i].datapointName;
        pathName = json[i].deviceName + "/" + json[i].blockName  + "/" + json[i].blockIndex  + "/" + json[i].name;
        json[i].programmaticPathname = programmaticPathname;
        json[i].pathName = pathName;
        json[i].block = json[i].blockName  + "/" + json[i].blockIndex;
        json[i].urlPath = json[i].deviceName + "/if/" + json[i].blockName + "/" + json[i].blockIndex + "/";
		if(g_iSmartServerVersion >= 320114)
			json[i].urlPath += "*+xifName==";
		json[i].urlPath += json[i].datapointName;
        json[i].dpName = json[i].name;
        try { 
            presetValue = json[i].presetValue;
            if(presetValue === null)
                presetValue = "";
        } catch (err) {}
        json[i].presetValue = presetValue;
        try { 
            if(!(typeof json[i].locValue === "undefined")) {
                locValue = json[i].locValue;
                
                if(locValue !== null) {
                    if(typeof locValue === "number")
                        locValueStr = locValue.toString();
                    else
                        locValueStr = JSON.stringify(locValue);
                }
            }
        } catch (err) {}
        json[i].locValueStr = locValueStr;
        try {
            priority = json[i].values.level;
        }
        catch (err) {}
        json[i].priority = priority;
        try { lon_cfg = obj["lon.cfg"];
            if(typeof lon_cfg.unit !== "undefined")
                unit = lon_cfg.unit;
            if(unit === null)
                unit = "";
        } catch (err) {}
        json[i].unit = unit;
    }
    for(i=0; i < deviceDpList.length; i++)
    {
        if(deviceDpList[i].deviceName === mode){
            deviceDpList[i].datapoints = JSON.parse(JSON.stringify(json));
            z = i;
            break;
        }
    }
    if(z === -1) {
        obj = {};
        obj.deviceName = mode;
        obj.deviceTypeName = g_sDashboardTemplateType;
        obj.datapoints = JSON.parse(JSON.stringify(json));
        deviceDpList.push(obj);
    }
	

    showDashboardUi(1, mode, json, "", g_bAddDeviceName);
}
function showDashboardUi(mode, title, objList, templateType, bAddDeviceName) {
    // mode: 0=show existing, 1=Show Device, 2=Show DpList, 4=Show FavList, 5= Contexts 60=use cached data
    // dashboardType: c = chart, n = normal, p = power, l = light, t = temperature, 
    // s1= slider, s2 = slider switch (binary), s3 = slider switch (SNVT_switch), s4 = slider switch (SNVT_switch 0 0 or 1 100 only), 
    // l2 = led
    //     xi = iox input level, xo = iox output level, xf= frequency xc = pulse_counter xr = relay, z = don't show (used for some iox datapoints)
    
    var paneTitle = "";
    var bNoTemplateFound = true;  // supported templates: 6kEvbMultiSensor
    var i,j, k, w, z, iPtr;
    var name1, obj, obj1;
    var paneContent = "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting data ...</span></div>";
    var tablePaneContent = "";
    var divNum = -1, dpListIndex;
    var index = 0;
    var tableColumnsMax = 2;
    var bAddTable = true;
    var bHasPresets = false;
    var presetValue;
    var bContinue, bContinue1 = false, tempObj, sTemp, valueStr, table, bAtLeastOneSvgElement = false;
    var mode1 = null, modeIndex = -1, value = null, valueIndex = -1, switchIndex = -1, tempValue,tempValueStr;
    var pathName = "", shortPathname = "", programmaticPathname = "", shortDeviceName;
    var bUnitsUsed = false;
    var bRemoveDeviceName = false; // only remove if all datapoints from single device
    
    try {
        
        g_iMainDisplayMode = DISPLAYMODE_DASHBOARD;
        document.getElementById("main").innerHTML =  paneContent;
        
               
        if(title !== "") {
            
            g_sDashboardTitle = g_sDashboardDevice;
        }
        else 
            g_sDashboardTitle = title;
        document.getElementById("dashboardTitle").innerHTML = title;
        if(mode === 60) {
            // click show Dashboard - use cached values
           for(i=0; i < dashboardDpList.length; i++)
            {
                if(typeof dashboardDpList[i].chartIndex !== "undefined" ) {
                    if(dashboardDpList[i].chartIndex < g_dashboardChartList.length) {
                        j = dashboardDpList[i].chartIndex;
                        if(dashboardDpList[i].pathName === g_dashboardChartList[j].pathName) {
                            dashboardDpList[i].datalogData = JSON.parse(JSON.stringify(g_dashboardChartList[j].data));
                        }
                    }
                }
            }
            mode = 20;
        }
        g_dashboardChartList = [];   
        if((mode !== 0) && (mode < 20))
            g_sDashboardType = mode;
        
        if(objList !== null) {
            dashboardDpList = JSON.parse(JSON.stringify(objList));

        }
        if(dashboardDpList.length === 0) {
            paneContent = "<br><br><br>No Datapoints selected - Click on one of the following sidebar menu buttons to select datapoints for dashboard<br>Planning - select device";
            paneContent += "<br>Devices - click on device Menu<br>Datapoints - click on datapoint Menu<br>Favorite DPs - click on datapoint Menu";
            document.getElementById("main").innerHTML =  paneContent;
            return;
        }
        else if(dashboardDpList.length > 100) {
            paneContent = "<br><br>Too many datapoints - Dashboard only supports up to 100 datapoints";
            document.getElementById("main").innerHTML =  paneContent;
            return;
        }
        if(g_bDashboardSupportLogData) {
            if(g_bDashboardGetDatalog) {
                if(mode < 20) {
                    getDashboardDatalogData(mode, title, templateType, bAddDeviceName);
                    return;
                }
                else 
                    mode -= 20;
            }
        }
        

        createRequestString(dashboardDpList);
        for(i=0; i < dashboardDpList.length; i++) {
            dashboardDpList[i].createBrowserGrapic = true;
            dashboardDpList[i].updateDpValue = false;
        }

                // reorder
        bContinue = true;
        while(bContinue)
        {
            bContinue = false;
            for(i=0; i < (dashboardDpList.length - 1); i++)
            {
                // use space so that name1, name2, name11 go in correct order
                if((dashboardDpList[i].pathName + " ") > (dashboardDpList[i + 1].pathName + " ")) {
                    bContinue = true;
                    tempObj = {};
                    tempObj = dashboardDpList[i];
                    dashboardDpList[i] = dashboardDpList[i + 1];
                    dashboardDpList[i + 1] = tempObj
                }
            }

        }
        g_iBackgroundPollingRequestCount = -1;
        g_iPollingRequestCount = -1;
        g_iPollingRequestCountMax  = 2;
        //ivbWsProcessDatapointUpdate = false;
        if(g_bDashboardPollEnabled) {
            g_PollingType = DISPLAYMODE_DASHBOARD;
            g_idpGetRequestIndex = 0;
            g_bPollingEnabled = true;
            g_iPollingRequestCount = g_iPollingRequestCountMax;
            ivbWsProcessDatapointUpdate = true;
        }
        

        if(templateType !== "") {
            g_sDashboardTemplateType = templateType;
        }
        paneContent = "";
        if((g_sDashboardType === 1) && (g_sDashboardTemplateType !== "") && (g_sDashboardDevice !== "")) {
            if(false) { //(g_sDashboardTemplateType === "6kEvbMultiSensor") {
                paneContent = addMultiSensor("", g_sDashboardDevice);
                g_bInitializeSvg = false;
                document.getElementById("main").innerHTML =  paneContent;
                bNoTemplateFound = false;
            }
        }
        g_dashboardIoxList = [];
        if(bNoTemplateFound) {
            index = 0;
            for(j=0; j < 7; j ++)
            { // j is used to order UI based on snvt_type
                if(j === 1)
                    tableColumnsMax = 3;
                else if(j === 4) {
                    if(paneContent !== "")
                        paneContent += "</table><div style=\"display:block\"><br><br></div>"
                }
                for(i=0; i < dashboardDpList.length; i ++)
                {
                    if(j === 0) {
                        dashboardDpList[i].dashboardType = "n"; // normal
                        if(dashboardDpList[i].cat === "in") {
                            dashboardDpList[i].feedbackDelay = true;
                            dashboardDpList[i].feedbackDelayTimeout = 0;
                            dashboardDpList[i].feedbackDelayOldValue = null;
                        }
                        if(dashboardDpList[i].pathName === "") {
                            dashboardDpList[i].pathName = dashboardDpList[i].programmaticPathname;
                        }
                        if(dashboardDpList[i].pathName.startsWith("iox")) {
                            dashboardDpList[i].shortPathName = dashboardDpList[i].pathName;
                            dashboardDpList[i].shortDeviceName = dashboardDpList[i].deviceName;
                        }
                        else {
                            // remove CT subsystems
                            shortPathname = dashboardDpList[i].pathName;
                            iPtr = shortPathname.indexOf("/");
                            if(iPtr > 0) {
                                iPtr = shortPathname.lastIndexOf(".", iPtr - 1);
                                if(iPtr > 0)
                                    shortPathname = shortPathname.substr(iPtr + 1);
                            }
                            dashboardDpList[i].shortPathName = shortPathname;
                            
                            shortDeviceName = dashboardDpList[i].deviceName;
                            iPtr = shortDeviceName.lastIndexOf(".");
                            if(iPtr > 0) {
                                sTemp = shortDeviceName.substr(iPtr + 1);
                                if(isNaN(sTemp))
                                    shortDeviceName = sTemp;
                                else { 
                                    // subsystem 1.datalog.1
                                    iPtr = shortDeviceName.lastIndexOf(".", (iPtr - 1));
                                    if(iPtr > 0) 
                                        shortDeviceName = shortDeviceName.substr(iPtr + 1);
                                }
                            }
                            dashboardDpList[i].shortDeviceName = shortDeviceName;
                        }
                    }
                    if((false) && (j === 0) && (dashboardDpList[i].type ===  "SNVT_power")){
                        divNum ++;
                        dashboardDpList[i].dashboardType = "p"; //power
                        bAtLeastOneSvgElement = true;
                        pathName = dashboardDpList[i].pathname; //dashboardDpList[i].programmaticPathname;
                        shortPathname = dashboardDpList[i].shortPathName;
                        tempValue = dashboardDpList[i].locValue;
                        tempValue = dashboardNumToFixedLength(tempValue, g_iDashboardDecimalPlaces);
                        tempValueStr = tempValue.toString();
                        if(divNum > tableColumnsMax) {
                            divNum = 1;
                            if(paneContent === "")
                                paneContent = "<table>";
                            else 
                                paneContent += "</tr>";
                            paneContent += '<tr><td>' + addPower(shortPathname, pathName, tempValueStr) + '</td>';
                        }
                        else 
                            paneContent += '<td>' + addPower(shortPathname, pathName, tempValueStr) + '</td></tr>';
                        dashboardDpList[i].createBrowserGrapic = false;
                        
                        
                        

                        createChartObject(i, "chartSvg_" + pathName, pathName, dashboardDpList[i].locValue, null, null, true, null, "both")
                    }
                    else if((j === 1) && (dashboardDpList[i].type ===  "SNVT_lux")){
                        
                        dashboardDpList[i].dashboardType = "l"; // thermometor svg + chart
                        bAtLeastOneSvgElement = true;
                        divNum ++;
                        pathName = dashboardDpList[i].pathName; //dashboardDpList[i].programmaticPathname;
                        shortPathname = dashboardDpList[i].shortPathName;
                        tempValue = dashboardDpList[i].locValue;
                        tempValue = dashboardNumToFixedLength(tempValue, g_iDashboardDecimalPlaces);
                        tempValueStr = tempValue.toString();
                        if(divNum > tableColumnsMax) {
                            divNum = 1;
                            if(paneContent === "")
                                paneContent = "<table>";
                            else 
                                paneContent += "</tr>";
                            paneContent += '<tr><td>' + addLux(shortPathname, pathName, tempValueStr, dashboardDpList[i].presetValue) + '</td>';
                        }
                        else 
                            paneContent += '<td>' + addLux(shortPathname, pathName, tempValueStr, dashboardDpList[i].presetValue) + '</td></tr>';
                        dashboardDpList[i].createBrowserGrapic = false;
                        dashboardDpList[i].displayId = "thermometer_" + pathName;
                        dashboardDpList[i].min = 0;
                        dashboardDpList[i].max = (Math.round(parseFloat(dashboardDpList[i].locValue) / 10) + 1) * 10;
                        
                        createChartObject(i, "chartSvg_" + pathName, pathName, tempValue, 0, dashboardDpList[i].max, true, "orange", "both")
                        
                    }
                    else if((j === 2) && (dashboardDpList[i].type ===  "SNVT_temp_p") && (dashboardDpList[i].cat ===  "out")){
                        divNum ++;
                        dashboardDpList[i].dashboardType = "t"; // temperature
                        bAtLeastOneSvgElement = true;
                        pathName = dashboardDpList[i].pathName; //dashboardDpList[i].programmaticPathname;
                        shortPathname = dashboardDpList[i].shortPathName;
                        tempValue = dashboardDpList[i].locValue;
                        tempValue = dashboardNumToFixedLength(tempValue, g_iDashboardDecimalPlaces);
                        tempValueStr = tempValue.toString();
                        if(divNum > tableColumnsMax) {
                            divNum = 1;
                            if(paneContent === "")
                                paneContent = "<table>";
                            else 
                                paneContent += "</tr>";
                            paneContent += '<tr><td>' + addThermometer(shortPathname, pathName, tempValueStr, dashboardDpList[i].presetValue) + '</td>';
                        }
                        else 
                            paneContent += '<td>' + addThermometer(shortPathname, pathName, tempValueStr, dashboardDpList[i].presetValue) + '</td></tr>';
                        dashboardDpList[i].createBrowserGrapic = false;
                        
                        dashboardDpList[i].displayId = "thermometer_" + pathName;
                        dashboardDpList[i].min = 0;
                        dashboardDpList[i].max = dashboardDpList[i].locValue + 10;
                        var temp = "string";
                        temp.toLowerCase().indexOf
                        if(false) { // not supported yet (dashboardDpList[i].unit.toLowerCase().indexOf("f") > 0) {
                            dashboardDpList[i].max = 120;
                            dashboardDpList[i].min = -30;
                        }
                        else if(false) { // not supported yet(dashboardDpList[i].unit.toLowerCase().indexOf("c") > 0) {
                            dashboardDpList[i].max = 70;
                            dashboardDpList[i].min = -30;
                        }
                        else {
                            if(dashboardDpList[i].locValue > 50) {
                                dashboardDpList[i].max = 120;
                                dashboardDpList[i].min = -30;
                            }
                            else {
                                dashboardDpList[i].max = 70;
                                dashboardDpList[i].min = -30;
                            }
                        }
                        createChartObject(i, "chartSvg_" + pathName, pathName, tempValue, dashboardDpList[i].min, dashboardDpList[i].max, true, "red", "both")
                    }
                    else if((j === 3) && (dashboardDpList[i].type ===  "SNVT_count") && (dashboardDpList[i].dpName ===  "nvoPulseOut")){
                        divNum ++;
                        dashboardDpList[i].dashboardType = "c"; // chart
                        bAtLeastOneSvgElement = true;
                        pathName = dashboardDpList[i].pathName; //dashboardDpList[i].programmaticPathname;
                        shortPathname = dashboardDpList[i].shortPathName;
                        if(divNum > tableColumnsMax) {
                            divNum = 1;
                            if(paneContent === "")
                                paneContent = "<table>";
                            else 
                                paneContent += "</tr>";
                            paneContent += '<tr><td>' + addChart(i, shortPathname, pathName, dashboardDpList[i].locValueStr, dashboardDpList[i].presetValue) + '</td>';
                        }
                        else 
                            paneContent += '<td>' + addChart(i, shortPathname, pathName, dashboardDpList[i].locValueStr, dashboardDpList[i].presetValue) + '</td></tr>';
                        dashboardDpList[i].createBrowserGrapic = false;
                        createChartObject(i, "chartSvg_" + pathName, pathName, dashboardDpList[i].locValue, null, null, true, null, "both")
                    }
                    else if (j === 3) {
                        
                        bContinue1 = false;
                        //if(g_bDashboard_UseChartForAllBacnetAvs) {
                        if(g_bDashboard_UseChartForAllInputs) {
                            sTemp = dashboardDpList[i].dpQualifier;
                            sTemps = sTemp.split("/");
                            if(sTemps.length > 1) {
                                //if(((sTemps[1] === "bacnet") || (sTemps[1] === "modbus")) && (dashboardDpList[i].cat === "in"))
                                if(dashboardDpList[i].cat === "in")
                                    bContinue1 = true;
                            }
                        }
                        
                        if( dashboardDpList[i].createBrowserGrapic 
                        && ((g_bDashboard_UseChartForAllOutputs && (dashboardDpList[i].cat === "out")) || (bContinue1))
                        && (typeof dashboardDpList[i].locValue === "number")) {
                            divNum ++;
                            dashboardDpList[i].dashboardType = "c"; // chart
                            bAtLeastOneSvgElement = true;
                            pathName = dashboardDpList[i].pathName; //dashboardDpList[i].programmaticPathname;
                            shortPathname = dashboardDpList[i].shortPathName;
                            tempValue = dashboardDpList[i].locValue;
                            tempValue = dashboardNumToFixedLength(tempValue, g_iDashboardDecimalPlaces);
                            tempValueStr = tempValue.toString();
                            if(divNum > tableColumnsMax) {
                                divNum = 1;
                                if(paneContent === "")
                                    paneContent = "<table>";
                                else 
                                    paneContent += "</tr>";
                                paneContent += '<tr><td>' + addChart1(i, shortPathname, pathName, tempValueStr, dashboardDpList[i].presetValue, bContinue1) + '</td>';
                            }
                            else 
                                paneContent += '<td>' + addChart1(i, shortPathname, pathName, tempValueStr, dashboardDpList[i].presetValue, bContinue1) + '</td></tr>';
                            dashboardDpList[i].createBrowserGrapic = false;
                            createChartObject(i, "chartSvg_" + pathName, pathName, tempValue, null, null, true, null, "both")
                        }
                    }
                    else if ((j === 4) && dashboardDpList[i].createBrowserGrapic) {
                        bContinue1 = false;
                        if((dashboardDpList[i].deviceName.startsWith("iox")) && (dashboardDpList[i].deviceName.endsWith(".dio"))) {
                        // look for IOX devices
                            if((dashboardDpList[i].block.startsWith("di/") && ((dashboardDpList[i].dpName === "input") || (dashboardDpList[i].dpName === "mode") || (dashboardDpList[i].dpName === "switch")))
                                || (dashboardDpList[i].block.startsWith("do/") && ((dashboardDpList[i].dpName === "output") || (dashboardDpList[i].dpName === "mode") || (dashboardDpList[i].dpName === "switch")))
                                || (dashboardDpList[i].block.startsWith("relay/") && ((dashboardDpList[i].dpName === "relay-val")))
                                ) {
                                z= -1;
                                sTemp = dashboardDpList[i].deviceName + "/" + dashboardDpList[i].block;
                                for(k=0; k < g_dashboardIoxList.length; k++)
                                {
                                    
                                    if(g_dashboardIoxList[k].name === sTemp) {
                                        z = k;
                                        break;
                                    }
                                }
                                if(z === -1) {
                                    obj = {}
                                    obj.name = sTemp;
                                    obj.dps = [];
                                    obj.block = dashboardDpList[i].block;
                                    obj1 = {};
                                    obj1.name = dashboardDpList[i].programmaticPathname;
                                    obj1.block = dashboardDpList[i].block;
                                    obj1.value = dashboardDpList[i].value;
                                    obj1.dpListIndex = i;
                                    obj.dps.push(obj1);
                                    g_dashboardIoxList.push(obj);
                                }
                                else {
                                    w = -1;
                                    pathName = dashboardDpList[i].programmaticPathname;
                                    for(k=0; k < g_dashboardIoxList[z].dps.length; k++)
                                    {
                                        if(g_dashboardIoxList[z].dps[k].name === pathName) {
                                            w = k;
                                            break;
                                        }
                                    }
                                    if(w === -1) {
                                        obj1 = {};
                                        obj1.name = dashboardDpList[i].programmaticPathname;
                                        obj.block = dashboardDpList[i].block;
                                        obj1.value = dashboardDpList[i].value;
                                        obj1.block = dashboardDpList[i].block;
                                        obj1.dpListIndex = i;
                                        g_dashboardIoxList[z].dps.push(obj1);
                                    }
                                }

                            }
                        }
                    }
                    else if(j === 5) {
                        if(i === 0) {
                            // only run once
                            // sort
                            bContinue = true;
                            while(bContinue)
                            {
                                bContinue = false;
                                for(k=0; k < (g_dashboardIoxList.length - 1); k++)
                                {
                                    // use space so that name1, name2, name11 go in correct order
                                    if((g_dashboardIoxList[k].name + " ") > (g_dashboardIoxList[k + 1].name + " ")) {
                                        bContinue = true;
                                        tempObj = {};
                                        tempObj = g_dashboardIoxList[k];
                                        g_dashboardIoxList[k] = g_dashboardIoxList[k + 1];
                                        g_dashboardIoxList[k + 1] = tempObj
                                    }
                                }

                            }


                            for(k=0; k < g_dashboardIoxList.length; k++)
                            {
                                if(g_dashboardIoxList[k].block.startsWith("di/")) {
                                    mode1 = null;
                                    modeIndex = -1;
                                    value = null;
                                    valueIndex = -1;
                                    switchIndex = -1;
                                    bContinue1 = false;
                                    dpListIndex = -1;
                                    for(s=0; s < g_dashboardIoxList[k].dps.length; s++)
                                    {
                                        if(g_dashboardIoxList[k].dps[s].name.endsWith("/mode")) {
                                            mode1 = g_dashboardIoxList[k].dps[s].value;
                                            modeIndex = s;
                                            
                                        }
                                        else if(g_dashboardIoxList[k].dps[s].name.endsWith("/input")) {
                                            value = g_dashboardIoxList[k].dps[s].value;
                                            valueIndex = s;
                                            
                                        }
                                        else if(g_dashboardIoxList[k].dps[s].name.endsWith("/switch")) {
                                            switchIndex = s;
                                            dpListIndex = g_dashboardIoxList[k].dps[s].dpListIndex;
                                        }
                                    }
                                    if((mode1 !== null) && (value !== null)) {
                                        if(mode.type === "level") {
                                            dashboardDpList[g_dashboardIoxList[k].dps[valueIndex].dpListIndex].dashboardType = "xi";
                                            bContinue1 = true;
                                            value = value.level;
                                            if(value === true)
                                                value = 1;
                                            else 
                                                value = 0;
                                            
                                        }
                                        else if(mode1.type === "frequency") {
                                            dashboardDpList[g_dashboardIoxList[k].dps[valueIndex].dpListIndex].dashboardType = "xf";
                                            bContinue1 = true;
                                            value = value.freqency;
                                        }
                                        else if(mode1.type === "counter") {
                                            dashboardDpList[g_dashboardIoxList[k].dps[valueIndex].dpListIndex].dashboardType = "xc";
                                            bContinue1 = true;
                                            value = value.freqency;
                                        }
                                    }
                                    if(bContinue1) {
                                        if(valueIndex !== -1)
                                            dpListIndex = g_dashboardIoxList[k].dps[valueIndex].dpListIndex;
                                        if(modeIndex !== -1) {
                                            dashboardDpList[g_dashboardIoxList[k].dps[modeIndex].dpListIndex].dashboardType = "z";
                                            dashboardDpList[g_dashboardIoxList[k].dps[modeIndex].dpListIndex].createBrowserGrapic = false;
                                        }
                                        if(switchIndex !== null) {
                                            dashboardDpList[g_dashboardIoxList[k].dps[switchIndex].dpListIndex].dashboardType = "z";
                                            dashboardDpList[g_dashboardIoxList[k].dps[switchIndex].dpListIndex].createBrowserGrapic = false;
                                        }
                                        divNum ++;
                                       pathName = pathName = dashboardDpList[dpListIndex].pathName; //dashboardDpList[dpListIndex].programmaticPathname;
                                       shortPathname = dashboardDpList[i].shortPathName;
                                       bAtLeastOneSvgElement = true;
                                        if(divNum > tableColumnsMax) {
                                            divNum = 1;
                                            if(paneContent === "")
                                                paneContent = "<table>";
                                            else 
                                                paneContent += "</tr>";
                                            paneContent += '<tr><td>' + addChart(dpListIndex, shortPathname, pathName, dashboardDpList[dpListIndex].locValueStr, dashboardDpList[dpListIndex].presetValue) + '</td>';
                                        }
                                        else 
                                            paneContent += '<td>' + addChart(dpListIndex, shortPathname, pathName, dashboardDpList[dpListIndex].locValueStr, dashboardDpList[dpListIndex].presetValue) + '</td></tr>';
                                        dashboardDpList[dpListIndex].createBrowserGrapic = false;
                                        createChartObject(dpListIndex, "chartSvg_" + pathName, pathName, value, 0, 2, true, null, "both")
                                    }
                                    else { // don't have all datapoints so not a device dashboard
                                    /*
                                        if(modeIndex !== -1) {
                                            dashboardDpList[g_dashboardIoxList[k].dps[modeIndex].dpListIndex].dashboardType = "z";
                                            dashboardDpList[g_dashboardIoxList[k].dps[modeIndex].dpListIndex].createBrowserGrapic = false;
                                        }
                                        if(valueIndex !== -1) {
                                            dashboardDpList[g_dashboardIoxList[k].dps[valueIndex].dpListIndex].dashboardType = "z";
                                            dashboardDpList[g_dashboardIoxList[k].dps[valueIndex].dpListIndex].createBrowserGrapic = false;
                                        }
                                        if(switchIndex !== -1) {
                                            dashboardDpList[g_dashboardIoxList[k].dps[switchIndex].dpListIndex].dashboardType = "z";
                                            dashboardDpList[g_dashboardIoxList[k].dps[switchIndex].dpListIndex].createBrowserGrapic = false;
                                        }
                                        */

                                    }
                                    
                                }
                                else if(g_dashboardIoxList[k].block.startsWith("do/")) {
                                    /*
                                    for(s=0; s < g_dashboardIoxList[k].dps.length; s++)
                                    {
                                        modeIndex =g_dashboardIoxList[k].dps[s].dpListIndex;
                                        dashboardDpList[modeIndex].dashboardType = "z";
                                        dashboardDpList[modeIndex].createBrowserGrapic = false;
                                        
                                    }
                                    */
                                    
                                }
                                else if(g_dashboardIoxList[k].block.startsWith("relay/")) {

                                }
                                
                            }
                     
                        }
                    }
                    else if(j === 6) {
                        // s1= slider, s2 = slider switch (binary), s3 = slider switch (SNVT_switch), s4 = slider switch (SNVT_switch 0 0 or 1 100 only), 
                    // l2 = led, l3 = led (SNVT_switch, led for state, span for value), l4 = LED SNVT_switch state only
                        if(dashboardDpList[i].createBrowserGrapic) {
                            if(!((dashboardDpList[i].type ===  "SNVT_switch") || (dashboardDpList[i].unit === " ") || (dashboardDpList[i].unit.indexOf("unit") !== 1)))
                                bUnitsUsed = true;
                            programmaticPathname = dashboardDpList[i].programmaticPathname;
                            if(dashboardDpList[i].type ===  "SNVT_str_asc")
                                dashboardDpList[i].dashboardType = "a";
                            else if ((dashboardDpList[i].type ===  "binary") || (dashboardDpList[i].type ===  "boolean") || (dashboardDpList[i].type.toLowerCase() ===  "bit")) {
                                if(dashboardDpList[i].cat === "in")
                                    dashboardDpList[i].dashboardType = "s2";
                                else
                                    dashboardDpList[i].dashboardType = "l2";
                            }
                            else if(programmaticPathname.startsWith("DIO/DI/0/DI_"))
                                dashboardDpList[i].dashboardType = "l2"; // Adam-4150
                            else if(programmaticPathname.startsWith("DIO/DO/0/DO_"))
                                dashboardDpList[i].dashboardType = "s2"; // Adam-4150
                            else if(programmaticPathname.startsWith("DIO-01/Digital Input/") && programmaticPathname.endsWith("/nvoValue"))
                                dashboardDpList[i].dashboardType = "l4"; // SC100
                            else if(programmaticPathname.startsWith("DIO-01/Digital Output/") && programmaticPathname.endsWith("/nviValue"))
                                dashboardDpList[i].dashboardType = "s4"; // SC100
                            else if (dashboardDpList[i].type ===  "SNVT_switch") {
                                if(dashboardDpList[i].cat === "in")
                                    dashboardDpList[i].dashboardType = "s3";
                                else
                                    dashboardDpList[i].dashboardType = "l3";
                            }
                           
                            index ++;
                            tablePaneContent += "<tr><td>" + index + "</td>";
                            pathName = dashboardDpList[i].pathName;//dashboardDpList[i].programmaticPathname;
                            if(bAddDeviceName) 
                                tablePaneContent += "<td>" + dashboardDpList[i].shortDeviceName + "</td>";
                            tablePaneContent += "<td>" + dashboardDpList[i].block  + "/" + dashboardDpList[i].dpName;
                            
                            if(dashboardDpList[i].dashboardType === "s2") {
                                // boolean or binary slider switch
                                tablePaneContent += "<td class=\"tdValue\" ><div style=\"display:flex\">";
                                tablePaneContent += "<label class=\"sliderSwitch\" ><input type=\"checkbox\"";
                                tablePaneContent += " id=\"localValueSwitch_" + pathName + "\" onclick=\"sliderSwitchClicked(this, '" + pathName + "', " + i + ")\" class=\"sliderInput\" ";
                                if(typeof dashboardDpList[i].locValue === "number") {
                                    if(dashboardDpList[i].locValue === 1)
                                        tablePaneContent += ' checked';
                                }
                                else if(typeof dashboardDpList[i].locValue === "boolean") {
                                    
                                    if(dashboardDpList[i].locValue)
                                        tablePaneContent += ' checked';
                                   
                                }
                                tablePaneContent += '><span class="sliderSlider sliderRound"></span></label>'
                                tablePaneContent +=  '</div></td>';
                                tablePaneContent += "<td><span id=\"unit_" + pathName + "\">" + dashboardDpList[i].unit + "</span></td>";
                                //tablePaneContent += "<td><input id=\"priority_" + pathName + "\" value=\"" + dashboardDpList[i].priority + "\" size=\"3\">";
                                tablePaneContent += "<td><select id=\"priority_" + pathName + "\">";
                                for(s=1; s < 17; s++)
                                {
                                    tablePaneContent += "<option value=\"" + s + "\"";
                                    if(dashboardDpList[i].priority === s)
                                        tablePaneContent += " selected";
                                    tablePaneContent += ">" + s + "</option>";
                                }
                                tablePaneContent += "<option value=\"17\"";
                                if(dashboardDpList[i].priority === 17)
                                    tablePaneContent += " selected";
                                tablePaneContent += ">" + "Normal" + "</option>";
                                tablePaneContent += "</select>";

                                tablePaneContent += "<button id=\"dpValueMenu_" + pathName + "\" style=\"margin-left:10px\" onclick=\"menuDpValue1(2, this, " + i + ", '" + dashboardDpList[i].pathName + "')\">...</button>";
                                tablePaneContent += "</td></tr>";
                            }
                            else if(dashboardDpList[i].dashboardType === "s3") {
                                // SNVT_switch slider switch value and state
                                tablePaneContent += "<td class=\"tdValue\" ><div style=\"display:flex\">";
                                tablePaneContent += "<div style=\"width:70px\">";
                                tablePaneContent += "<label class=\"sliderSwitch\" ><input type=\"checkbox\"";
                                tablePaneContent += " id=\"localValueSwitch_" + pathName + "\" onclick=\"sliderSwitchClicked(this, '" + pathName + "', " + i + ")\" class=\"sliderInput\" ";
                                if(dashboardDpList[i].locValue.state === 1)
                                    tablePaneContent += ' checked';
                                
                                tablePaneContent += '><span class="sliderSlider sliderRound"></span></label></div>'
                                tablePaneContent += '<div><input id="localValue_' + pathName + '" style="width:30px;" value="' + dashboardDpList[i].locValue.value.toString() + '"';
                                tablePaneContent += " onkeyup=\"inputBoxKey(this, event, " + i + ", '" + pathName + "')\""; 
                                tablePaneContent += '></div>';
                                tablePaneContent +=  '</div></td>';
                                tablePaneContent += "<td><span id=\"unit_" + pathName + "\">" + dashboardDpList[i].unit + "</span></td>";
                                //tablePaneContent += "<td><input id=\"priority_" + pathName + "\" value=\"" + dashboardDpList[i].priority + "\" size=\"3\">";
                                tablePaneContent += "<td><select id=\"priority_" + pathName + "\">";
                                for(s=1; s < 17; s++)
                                {
                                    tablePaneContent += "<option value=\"" + s + "\"";
                                    if(dashboardDpList[i].priority === s)
                                        tablePaneContent += " selected";
                                    tablePaneContent += ">" + s + "</option>";
                                }
                                tablePaneContent += "<option value=\"17\"";
                                if(dashboardDpList[i].priority === 17)
                                    tablePaneContent += " selected";
                                tablePaneContent += ">" + "Normal" + "</option>";
                                tablePaneContent += "</select>";

                                tablePaneContent += "<button id=\"dpValueMenu_" + pathName + "\" style=\"margin-left:10px\" onclick=\"menuDpValue1(2, this, " + i + ", '" + dashboardDpList[i].pathName + "')\">...</button>";
                                tablePaneContent += "</td></tr>";
                            }
                            else if(dashboardDpList[i].dashboardType === "s4") {
                                // SNVT_switch Slider uses state only
                                tablePaneContent += "<td class=\"tdValue\" ><div style=\"display:flex\">";
                                tablePaneContent += "<label class=\"sliderSwitch\" ><input type=\"checkbox\"";
                                tablePaneContent += " id=\"localValueSwitch_" + pathName + "\" onclick=\"sliderSwitchClicked(this, '" + pathName + "', " + i + ")\" class=\"sliderInput\" ";
                                if(dashboardDpList[i].locValue.state === 1)
                                        tablePaneContent += ' checked';
                                
                                tablePaneContent += '><span class="sliderSlider sliderRound"></span></label>'
                                tablePaneContent +=  '</div></td>';
                                tablePaneContent += "<td><span id=\"unit_" + pathName + "\">" + dashboardDpList[i].unit + "</span></td>";
                                //tablePaneContent += "<td><input id=\"priority_" + pathName + "\" value=\"" + dashboardDpList[i].priority + "\" size=\"3\">";
                                tablePaneContent += "<td><select id=\"priority_" + pathName + "\">";
                                for(s=1; s < 17; s++)
                                {
                                    tablePaneContent += "<option value=\"" + s + "\"";
                                    if(dashboardDpList[i].priority === s)
                                        tablePaneContent += " selected";
                                    tablePaneContent += ">" + s + "</option>";
                                }
                                tablePaneContent += "<option value=\"17\"";
                                if(dashboardDpList[i].priority === 17)
                                    tablePaneContent += " selected";
                                tablePaneContent += ">" + "Normal" + "</option>";
                                tablePaneContent += "</select>";

                                tablePaneContent += "<button id=\"dpValueMenu_" + pathName + "\" style=\"margin-left:10px\" onclick=\"menuDpValue1(2, this, " + i + ", '" + dashboardDpList[i].pathName + "')\">...</button>";
                                tablePaneContent += "</td></tr>";
                            }
                            else if(dashboardDpList[i].dashboardType === "l2") {
                                // led binary
                                tablePaneContent += "<td class=\"tdValue\" ><div style=\"display:flex\">";
                                tablePaneContent += '<span id="localValue_' + pathName + '"'; 
                                if(typeof dashboardDpList[i].locValue === "number") {
                                    if(dashboardDpList[i].locValue === 1)
                                        tablePaneContent += ' class="ledDotOn"';
                                    else 
                                        tablePaneContent += ' class="ledDotOff"';
                                }
                                else if(typeof dashboardDpList[i].locValue === "boolean") {
                                    if(dashboardDpList[i].locValue === 1)
                                        tablePaneContent += ' class="ledDotOn"';
                                    else 
                                        tablePaneContent += ' class="ledDotOff"';
                                }
                                tablePaneContent += '></span>';
                                tablePaneContent += '</div></td>';
                                tablePaneContent += "<td><span id=\"unit_" + pathName + "\">" + dashboardDpList[i].unit + "</span></td>";
                                tablePaneContent += '<td></td>';
                                //tablePaneContent += "<td><span id=\"priority_" + pathName + "\">" + dashboardDpList[i].priority + "</span></td>";
                                tablePaneContent += "</tr>";
                            }
                            else if(dashboardDpList[i].dashboardType === "l3") {
                                // Led SNVT_switch value and state
                                tablePaneContent += "<td class=\"tdValue\" ><div style=\"display:flex\">";
                                tablePaneContent += "<div style=\"width:70px\">"
                                tablePaneContent += '<span id="localValueSwitch_' + pathName + '"'; 
                                if(dashboardDpList[i].locValue.state === 1)
                                    tablePaneContent += ' class="ledDotOn"';
                                else 
                                    tablePaneContent += ' class="ledDotOff"';
                                
                                tablePaneContent += '></span></div>';
                                tablePaneContent += '<div id="localValue_' + pathName + '" style="width:30px;">' + dashboardDpList[i].locValue.value.toString() + '</div>'; 
                                                                
                                tablePaneContent += '</div></td>';
                                tablePaneContent += "<td><span id=\"unit_" + pathName + "\">" + dashboardDpList[i].unit + "</span></td>";
                                //tablePaneContent += "<td><span id=\"priority_" + pathName + "\">" + dashboardDpList[i].priority + "</span></td>";
                                tablePaneContent += '<td></td>';
                                tablePaneContent += "</tr>";
                            }
                            else if(dashboardDpList[i].dashboardType === "l4") {
                                // Led SNVT_switch state only -- e.g., IOX
                                tablePaneContent += "<td class=\"tdValue\" ><div style=\"display:flex\">";
                                tablePaneContent += '<span id="localValueSwitch_' + pathName + '"'; 
                                if(dashboardDpList[i].locValue.state === 1)
                                    tablePaneContent += ' class="ledDotOn"';
                                else 
                                    tablePaneContent += ' class="ledDotOff"';
                                
                                tablePaneContent += '>';
                                                            
                                
                                tablePaneContent += '</span></div></td>';
                                tablePaneContent += "<td><span id=\"unit_" + pathName + "\">" + dashboardDpList[i].unit + "</span></td>";
                                //tablePaneContent += "<td><span id=\"priority_" + pathName + "\">" + dashboardDpList[i].priority + "</span></td>";
                                tablePaneContent += '<td></td>';
                                tablePaneContent += "</tr>";
                            }
                            else {
                                if(typeof dashboardDpList[i].locValue === "number") {
                                    tempValue = dashboardDpList[i].locValue;
                                    tempValue = dashboardNumToFixedLength(tempValue, g_iDashboardDecimalPlaces);
                                    tempValueStr = tempValue.toString();
                                }
                                if(dashboardDpList[i].cat === "out") {
                                    tablePaneContent += "<td class=\"tdValue\"><div id=\"localValue_" + pathName + "\" class=\"tdValueDiv\">";
                                    if(dashboardDpList[i].presetValue !== "")
                                        tablePaneContent += dashboardDpList[i].presetValue + "</div></div></td>";
                                    else if(dashboardDpList[i].dashboardType === "a") {
                                        tablePaneContent += dashboardDpList[i].locValue.ascii + "</div></div></td>";
                                    }
                                    else
                                        tablePaneContent += dashboardDpList[i].locValueStr + "</div></div></td>";
                                }
                                else if(dashboardDpList[i].cat === "in") {
                                    tablePaneContent += "<td><div class=\"tdNewValueDiv\"><input id=\"localValue_" + pathName + "\" size=\"35\" "; 
                                    bHasPresets = false;
                                    valueStr = null; 
                                    if(dashboardDpList[i].presetValue !== "")
                                        valueStr = dashboardDpList[i].presetValue
                                    else if(dashboardDpList[i].dashboardType === "a") 
                                        valueStr = dashboardDpList[i].locValue.ascii
                                    else
                                        valueStr = dashboardDpList[i].locValueStr

                                    if(typeof dashboardDpList[i].presets !== "undefined") {
                                        if(dashboardDpList[i].presets !== null) {
                                            if(dashboardDpList[i].presets.enabled) {
                                                if(dashboardDpList[i].presets.map.length > 0) {
                                                    bHasPresets = true;
                                                    tablePaneContent += " list='dpNewValuePresetList_" + pathName + "' value='" + valueStr + "'><datalist id='dpNewValuePresetList_" + pathName + "'>"
                                                    for(k=0; k < dashboardDpList[i].presets.map.length; k++)
                                                    {
                                                        name1 = dashboardDpList[i].presets.map[k].name;
                                                        tablePaneContent += "<option value='" + name1 + "'>"  + name1 + "</option>";
                                                    }
                                                    tablePaneContent += "<option value='" + dashboardDpList[i].locValueStr + "'>Raw Value</option>";
                                                    tablePaneContent += "</datalist>";
                                                }
                                            }
                                        } 
                                    }
                                    if(!bHasPresets) {
                                            tablePaneContent += " list='dpNewValuePresetList_" + pathName + "' value='" + valueStr + "'><datalist id='dpNewValuePresetList_" + pathName + "'>";
                                            tablePaneContent += "<option value='" + dashboardDpList[i].locValueStr + "'>Raw Value</option>";
                                            tablePaneContent += "</datalist>";
                                    } 
                                    tablePaneContent += "<button style=\"margin-left:10px\" onclick=\"inputBoxSendValue1(1, this, event, " + i + ", '" + pathName + "')\">Send</button></div>";
                                    
                                }
                                else 
                                    tablePaneContent += "<td></td>";
                                tablePaneContent += "<td><span id=\"unit_" + pathName + "\">" + dashboardDpList[i].unit + "</span></td>";
                                if(dashboardDpList[i].cat === "out") {
                                    tablePaneContent += '<td></td>';
                                   // tablePaneContent += "<td><span id=\"priority_" + pathName + "\">" + dashboardDpList[i].priority + "</span></td>";
                                }
                                else { // in
                                        //tablePaneContent += "<td><input id=\"priority_" + pathName + "\" value=\"" + dashboardDpList[i].priority + "\" size=\"3\">";
                                        tablePaneContent += "<td><select id=\"priority_" + pathName + "\">";
                                        for(s=1; s < 17; s++)
                                        {
                                            tablePaneContent += "<option value=\"" + s + "\"";
                                            if(dashboardDpList[i].priority === s)
                                                tablePaneContent += " selected";
                                            tablePaneContent += ">" + s + "</option>";
                                        }
                                        tablePaneContent += "<option value=\"17\"";
                                        if(dashboardDpList[i].priority === 17)
                                            tablePaneContent += " selected";
                                        tablePaneContent += ">" + "Normal" + "</option>";
                                        tablePaneContent += "</select>"

                                        tablePaneContent += "<button id=\"dpValueMenu_" + pathName + "\" style=\"margin-left:10px\" onclick=\"menuDpValue(this, " + i + ", '" + dashboardDpList[i].pathName + "')\">...</button></td>";
                                }
                                tablePaneContent += "</tr>";
                            }
                        }
                    }
                }
            }
            if(index > 0) {

                if(tablePaneContent !== "") {
                    paneContent += "<div id=\"dashboardTableDiv\">";
                    if(bAddDeviceName) {
                        paneContent += "<table id=\"myTable\" class=\"dashboardTable\">"
                        paneContent += "<tHead><tr><th onclick=\"sortTable(0)\">#</th><th onclick=\"sortTable(1)\">Device</th>";
                        paneContent += "<th onclick=\"sortTable(2)\">Datapoint</th>";
                        paneContent += "<th onclick=\"sortTable(3)\" class=\"tdValue\">Value</th>";
                        paneContent += "<th>Units</th><th>Priority</th></tHead><tbody>";
                    }
                    else {
                        paneContent += "<table id=\"myTable\" class=\"dashboardTable\">"
                        paneContent += "<tHead><tr><th onclick=\"sortTable(0)\">#</th><th onclick=\"sortTable(1)\">Datapoint</th>";
                        paneContent += "<th onclick=\"sortTable(2)\" class=\"tdValue\">Value</th>";
                        paneContent += "<th>Units</th><th>Priority</th></tHead><tbody>";
                    }
                    paneContent += tablePaneContent + "</tbody></table></div>"
                }
                
            }
            
            
        }
        
        document.getElementById("main").innerHTML =  "<div>" + paneContent + "</div>";
        if(!bUnitsUsed) {
            // remove Units column if no units defined
            try {
                z = 3;
                if(bAddDeviceName)
                    z++;
                table = document.getElementById("myTable");
                if(table !== null) {
                    for(i=0; i < table.rows.length; i++)
                    {
                        table.rows[i].cells[z].style.display = "none";
                    }
                }
            }
            catch {}
        }
        if(bRemoveDeviceName) {
            bRemoveDeviceName = true;
            for(i=0; i <dashboardDpList[i]; i++)
            {
                if(i === 0)
                    shortDeviceName = dashboardDpList[i].deviceName;
                else {
                    if(shortDeviceName !== dashboardDpList[i].deviceName) {
                        bRemoveDeviceName = false;
                        break;
                    }
                }
            }
            if(bRemoveDeviceName) {
                try {
                    table = document.getElementById("myTable");
                    if(table !== null) {
                        for(i=0; i < table.rows.length; i++)
                        {
                            table.rows[i].cells[1].style.display = "none";
                        }
                    }
                }
                catch {}
            }
        }
        
        if(bAtLeastOneSvgElement) {
            //g_iDashboardInitiCount = 0;
            g_bDashboardSvgInit = true;
            //g_bDashboardUpdateCharts = true;
            //g_bUpdateCharts = true;
            try {
                // ivGetDeviceList(); // IOT get device list later
                g_dashboardTimerId = window.setTimeout("timerHandlerDashboard()", g_dashboardTimerInterval);
            } catch (err) {} 
            
        }
        else {
            g_bDashboardDataLogGetInProgress = false;
            g_bDashboardNeedToInitializeSvg = false;
        }
        
        try {
            // ivGetDeviceList(); // IOT get device list later
            if(g_timerId === 0)
                g_timerId = window.setInterval("timerHandler()", g_iTimerInterval);
        } catch (err) {} 
    }
    catch (err) { document.getElementById("main").innerHTML =  "Error Processing Dashboard Data<br><br>" + err.toString();}
}
	
function showDashboardBuildUi() {
    try {

    }
    catch {}
}
function sliderSwitchClicked(n, path, index) {
    try {
        var url;
        var value = 0, state, value1;
        var currentTime;
        var priority = document.getElementById("priority_" + path)
        if(priority !== null)
            priority = priority.value;
        //alert(n.id + ", " + path + ", " + index); //remove
        if(dashboardDpList[index].dashboardType === "s2") {
            if(dashboardDpList[index].pathName === path) {
                if(dashboardDpList[index].type ===  "boolean") {
                    dashboardDpList[index].feedbackDelay = true;
				    currentTime = new Date().getTime();
				    dashboardDpList[index].feedbackDelayTimeout = currentTime + g_iFeedbackDelayTime; // ms  10000 = 10 s
				    dashboardDpList[index].feedbackDelayOldValue = dashboardDpList[index].locValue;
                    if(document.getElementById(n.id).checked)
                        value = true;
                    else 
                        value = false;
                    dashboardDpList[index].locValueStr = value;
								// check if using field or full datapoint value
                    if((typeof dashboardDpList[index].value) === "number")
                        dashboardDpList[index].locValue = Number(value);
                    else
                        dashboardDpList[index].locValue = JSON.parse(value);
                    dashboardDpList[index].value = "";
                    dashboardDpList[index].valueStr = "";
                    dashboardDpList[index].presetValue = "";
                    url = "https://" + location.hostname + "/iap/devs/*+name==";
                    url += dashboardDpList[index].urlPath.replace(/ /g,"%20").replace(/:/g,"%3A").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
                    if(priority !== null)
                        url += "/overrides/" + priority;
                    url += "/value"; 
                    writeDpValue(1,url,value, null, writeFailCallback);
                }
                else  {
                    dashboardDpList[index].feedbackDelay = true;
                    currentTime = new Date().getTime();
                    dashboardDpList[index].feedbackDelayTimeout = currentTime + g_iFeedbackDelayTime; // ms  10000 = 10 s
                    dashboardDpList[index].feedbackDelayOldValue = dashboardDpList[index].locValue;
                    value = 0;
                    if(document.getElementById(n.id).checked)
                        value = 1;
                    dashboardDpList[index].locValue = value;
                    dashboardDpList[index].value = "";
                    dashboardDpList[index].valueStr = "";
                    dashboardDpList[index].presetValue = "";
                    dashboardDpList[index].locValueStr = value;
                    url = "https://" + location.hostname + "/iap/devs/*+name==";
                    url += dashboardDpList[index].urlPath.replace(/ /g,"%20").replace(/:/g,"%3A").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
                    if(priority !== null)
                        url += "/overrides/" + priority;
                    url += "/value"; 
                    writeDpValue(1,url,value, null, writeFailCallback);
                }

            }
            
        }
        else if(dashboardDpList[index].dashboardType === "s3") {
            // snvt switch state, use old value
            if(dashboardDpList[index].pathName === path) {
                dashboardDpList[index].feedbackDelay = true;
                currentTime = new Date().getTime();
                dashboardDpList[index].feedbackDelayTimeout = currentTime + g_iFeedbackDelayTime; // ms  10000 = 10 s
                dashboardDpList[index].feedbackDelayOldValue = dashboardDpList[index].locValue;
                state  = 0;
                if(document.getElementById(n.id).checked)
                    state = 1;
                if(typeof dashboardDpList[index].locValue.value === "undefined") {
                    element = document.getElementById("localvalue_" + dashboardDpList[index].displayId);
                    if(element === null)
                        return;
                    value = element.value;
                    if(value.indexOf(".") !== -1) {
                        alert("Invalid value (only integer values of 0-255 supported): " + value);
                        return;
                    }
                    value1 = Number(value);
                    if(isNaN(value1)) {
                        alert("Invalid value (only only integer values of 0-255 supported): " + value);
                        return;
                    }
                    value = value1;
                }
                else
                    value = dashboardDpList[index].locValue.value;

                if ((value < 0) || (value > 255))   {
                    alert("Invalid value (only only integer values of 0-255 supported): " + value);
                    return;
                }

                value = {"value": value, "state": state};

                dashboardDpList[index].locValue = value;
                dashboardDpList[index].value = "";
                dashboardDpList[index].valueStr = "";
                dashboardDpList[index].presetValue = "";
                value = JSON.stringify(value);
                dashboardDpList[index].locValueStr = value;
                url = "https://" + location.hostname + "/iap/devs/*+name==";
                url += dashboardDpList[index].urlPath.replace(/ /g,"%20").replace(/:/g,"%3A").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
                if(priority !== null)
                    url += "/overrides/" + priority;
                url += "/value"; 
                writeDpValue(1,url,value, null, writeFailCallback);
            }
        }
        else if(dashboardDpList[index].dashboardType === "s4") {
            // snvt_switch state only
            if(dashboardDpList[index].pathName === path) {
                dashboardDpList[index].feedbackDelay = true;
                currentTime = new Date().getTime();
                dashboardDpList[index].feedbackDelayTimeout = currentTime + g_iFeedbackDelayTime; // ms  10000 = 10 s
                dashboardDpList[index].feedbackDelayOldValue = dashboardDpList[index].locValue; 

                if(document.getElementById(n.id).checked)
                    value = {"value": 100, "state": 1};
                else
                    value = {"value": 0, "state": 0};
                dashboardDpList[index].locValue = value;
                dashboardDpList[index].value = "";
                dashboardDpList[index].valueStr = "";
                dashboardDpList[index].presetValue = "";

                value = JSON.stringify(value);
                dashboardDpList[index].locValueStr = value;
                url = "https://" + location.hostname + "/iap/devs/*+name==";
                url += dashboardDpList[index].urlPath.replace(/ /g,"%20").replace(/:/g,"%3A").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
                if(priority !== null)
                    url += "/overrides/" + priority;
                url += "/value"; 
                writeDpValue(1,url,value, null, writeFailCallback);
            }
        }
    }
    catch {}
    

}
function initializeSvgDashboard() {
    try {
        var i;
        var fValue, fValue1;
        var value;
        var chartIndex;
        var type;
        var obj;
        g_bDashboardNeedToInitializeSvg = false;
        for(i=0; i < dashboardDpList.length; i ++)
        {
            try {
                type = dashboardDpList[i].dashboardType; 
                if(type !== "n") {
                    if(typeof dashboardDpList[i].chartIndex !== "undefined") {
                        chartIndex = dashboardDpList[i].chartIndex;
                        ivInitializeChart1(g_bDashboardSupportLogData, g_dashboardChartList[chartIndex].displayId, g_dashboardChartList[chartIndex].minValue, g_dashboardChartList[chartIndex].maxValue, null, null, "white", null, g_dashboardChartList[chartIndex].chartlabels);
                        dashboardMouseEventsAddToChart(g_dashboardChartList[chartIndex].displayId, "chartParentDiv_" + g_dashboardChartList[chartIndex].pathName, chartIndex);
                        dashboardUpdateCharts(chartIndex, dashboardDpList[i].locValue, null);
                    }
                
                    if ((type === "t") || (type === "l"))  {
                        obj = dashboardDpList[i];
                        ivInitializeThermometer(0, obj.displayId, i, obj.locValue, obj.min, obj.max, obj.unit)
                    }
                }
            }
            catch {}
        }
    }
    catch {}
}
function checkDashboardChartListRemoveOldEntries(index, currenttimeMs) {
    var removeCount = 0;
    var i;
    var bEntryRemoved = false;
    try {
        if(index < g_dashboardChartList.length) {
            if(g_idashboardChartMaxNumberOfEntries !== 0) { // 0=unlimited
                
                removeCount = g_dashboardChartList[index].data.length - g_idashboardChartMaxNumberOfEntries;
                if(removeCount > 0) {
                    bEntryRemoved = true;
                    for(i=0; i < removeCount; i++)
                    {
                        g_dashboardChartList[index].data.shift();
                    }
                }
            }
            if(g_iDashboardChartMaxDuration !== 0) {
                startTimestamp = currenttimeMs - g_iDashboardChartMaxDuration; 
                for(i=0; i < g_dashboardChartList[index].data.length; i++)
                {
                    if(g_dashboardChartList[index].data[i].timestamp < startTimestamp) {
                        g_dashboardChartList[index].data.shift();
                        bEntryRemoved = true;
                    }
                    else
                        break;
                }
            }
        }
    }
    catch {
        bEntryRemoved = true; // not sure what problem is so calculate new min max
    }
    try {
        if(bEntryRemoved) {
            if(g_dashboardChartList[index].data.length > 0) {
                g_dashboardChartList[index].startTimestamp = g_dashboardChartList[index].data[0].timestamp; //time in milli seconds
                g_dashboardChartList[index].endTimestamp = g_dashboardChartList[index].data[g_dashboardChartList[index].length - 1].timestamp; //time in milli seconds
            }
        }
    }
    catch {}
    g_dashboardChartList[index].dataCurrentEntries = g_dashboardChartList[index].data.length;
    g_dashboardChartList[index].endPtr = g_dashboardChartList[index].data.length - 1;
    return bEntryRemoved;
}
function clearDashboardCharts() {
    var i;
    // remove datalog data
    try {
        for(i=0; i < dashboardDpList.length; i ++)
            dashboardDpList[i].updateDpValue = true
        for(i=0; i < g_dashboardChartList.length; i ++)
        {
            g_dashboardChartList[i].data = [];
            g_dashboardChartList[i].maxValue = null;
            g_dashboardChartList[i].minValue = null;
            
        }
    }
    catch {}
    ivInitializeChart3Clear2Yaxis(false, "", g_dashboardChartList);
    
}
function createChartObject(index, displayId, pathName, value, min, max, hasDynmaicRange, linecolor, chartlabels) {
    try {
        var fvalue, fvalue1;
        var chart = {}, minmaxObj, obj;
        var d;
        var polygoncolor;
        var type;
        var iDetermineMinMax = -1;
        if(dashboardDpList[index].pathName !== pathName)
            return;
        chart.startPtr = 0;
        chart.endPtr = 0;
        chart.pathName = pathName;
        chart.dashboardDpIndex = index;
        chart.displayId = displayId;
        chart.data = [];
        chart.dataCurrentEntries = 1; //iottest
        chart.hasNegativeNumbers = false; 
        chart.bMinMaxEqual = true;
        chart.iDynamicRangeCount = ivChartTotalEntries + 2;
        if(g_bDashboardSupportLogData)
        chart.iDynamicRangeCount = 2;

        chart.creatChartLine = true;
        chart.lineName = "line1"
        chart.color = "blue";
        
        /*
        type = dashboardDpList[index].dashboardType;
        if (type === "t")
            chart.color = "darkred";
        else if (type === "l")
            chart.color = "green";
        */           
        chart.show = true;
        chart.chartLabels = "both";

        chart.bPolygon = !g_bDashboardChartDynamicRange;
        chart.startTimestamp = null; //time in milli seconds
        chart.endTimestamp = null; //time in milli seconds
        if(g_bDashboardSupportLogData) {
            bDetermineMinMax = true;
            if(typeof dashboardDpList[index].datalogData !== "undefined") {
                if(dashboardDpList[index].datalogData.length > 0)
                    chart.data = JSON.parse(JSON.stringify(dashboardDpList[index].datalogData));
            }
            if(value !== null) {
                obj = {};
                obj.value = value;
                obj.presetValue = "";
                
                d = new Date();
                obj.timestamp = d.getTime();
                chart.data.push(obj);
            } 
            iDetermineMinMax = 3;
            
            chart.endPtr = chart.data.length - 1;
            chart.dataCurrentEntries = chart.data.length;
            if(chart.data.length > 0) {
                chart.startTimestamp = chart.data[0].timestamp; //time in milli seconds
                chart.endTimestamp = chart.data[chart.data.length - 1].timestamp; //time in milli seconds
            }
        }
        else {

            chart.data[0] = {};
            chart.data[0].value = value;
            chart.data[0].timestamp = null;
            if(typeof value === "string")
                value = Number(value);
            if(value < 0)
                chart.hasNegativeNumbers = true; 

            if(g_bDashboardChartDynamicRange) {
                iDetermineMinMax = 2;
                
            }   
            else { 
                if(max === null) {
                    fvalue = parseFloat(value);
                    if(g_bDashboardMinMaxUsePadding) {
                        if(fvalue < 0) 
                            fvalue1 = 0;
                        else if(fvalue < 1) 
                            fvalue1 = 1;
                        else if(fvalue < 5)
                            fvalue1 = 5;
                        else if(fvalue > 1) 
                            fvalue1 = (Math.round(fvalue / 10) + 1) * 10;
                    }
                    max = fvalue1;
                }
                if(min === null) {
                    fvalue = parseFloat(value);
                    if(g_bDashboardMinMaxUsePadding) {
                        if(fvalue < 0) 
                        fvalue1 = (Math.round(fvalue / 10) - 1) * 10;
                        else if(fvalue < 1) 
                            fvalue1 = 0;
                        else if(fvalue < 5)
                            fvalue1 = 0;
                        else if(fvalue > 1) 
                            fvalue1 = (Math.round(fvalue / 10) - 1) * 10;
                    }
                    min = fvalue1;
                }
                chart.maxValue = max;
                chart.minValue = min;
                if(min === max)
                    chart.bMinMaxEqual = true;
                else
                    chart.bMinMaxEqual = false;
            }
        }
        
        chart.dynamicRange = hasDynmaicRange;
        chart.chartlabels = chartlabels;
        if(linecolor === null) {
            linecolor = "blue";
        }
        polygoncolor = "light" + linecolor;
        chart.lineColor = linecolor;
        chart.polygoncolor = polygoncolor;
        g_dashboardChartList.push(chart);
        dashboardDpList[index].chartIndex = g_dashboardChartList.length - 1;
        if(iDetermineMinMax !== -1) {
            index = g_dashboardChartList.length - 1;
            if((iDetermineMinMax === 0) || (iDetermineMinMax === 3))
                value = null;
            else
                value = parseFloat(value);
            minmaxObj =  dashboardDetermineChartMinMaxValuesForChart(iDetermineMinMax, index, value, true);
        }
    }
    catch {}
}
function dashboardDetermineChartMinMaxValuesForChart(mode, index, value, bSaveChanges) {
    // mode: 0= check all, 1= compare last, 2= initial value so use value, 3=same as 0 but init chart
    var results = {};
    var bNoChanged = true;
    var bUpdateChart = true
    var min, max, value, i, fvalue1;
    var bChange = false;
    var index, maxDecimalPlaces = 3;
    results.min = value;
    results.max = value;
	try {
        if(mode === 3) {
            bUpdateChart = false;
            mode = 0;
        }
		
		if((mode === 2) || ((mode === 1) && (index < g_dashboardChartList.length)) || (mode === 0 && (g_dashboardChartList[index].data !== null))) {
            if(mode === 0) {
                for(i=0; i < g_dashboardChartList[index].data.length; i ++)
                {
                    if(i === 0) {
                        
                        min = g_dashboardChartList[index].data[i].value;
                        max = min;
                    }
                    else {
                        value = g_dashboardChartList[index].data[i].value;
                        if(value < min)
                            min = value;
                        if (value > max)
                            max = value;
                    }
                }
                if(min === max) {
                    g_dashboardChartList[index].bMinMaxEqual = true;
                    max = Math.round((max * 10) + 1) / 10;
                    min = Math.ceil((min * 10) - 1) / 10;
                }
                else 
                    g_dashboardChartList[index].bMinMaxEqual = false;
                bChange = true;
            }
            else if (mode === 1) {
                bNoChange = true;
                max =  g_dashboardChartList[index].maxValue;
                min =  g_dashboardChartList[index].minValue;
                if(g_dashboardChartList[index].bMinMaxEqual) {
                    lastIndex =  g_dashboardChartList[index].data.length - 1;
                    if(lastIndex > 0) {
                        if(g_dashboardChartList[index].data[lastIndex - 1].value !== g_dashboardChartList[index].data[lastIndex].value) {
                            max = g_dashboardChartList[index].data[lastIndex - 1].value;
                            min = max;
                            g_dashboardChartList[index].bMinMaxEqual = false;
                            bNoChanged = false;
                        }
                    }
                }
                if(value >= max){
                    max = value;
                    bNoChanged = false;
                }
                if(value <= min){
                    min = value;
                    bNoChanged = false;
                }
                if(bNoChanged)
                    return results;
            }
            else {
                g_dashboardChartList[index].bMinMaxEqual = true;
                min = max = value;
                max = Math.round((max * 10) + 1) / 10;
                min = Math.ceil((min * 10) - 1) / 10;
            }
            if(g_bDashboardMinMaxUsePadding) {
                if(Math.abs(max) > 100)
                    fvalue1 = (Math.round(max / 10) + 1) * 10;
                else if(Math.abs(max) > 1)
                    fvalue1 = Math.ceil(max + 1);
                else 
                    fvalue1 = Math.ceil((max * 10) + 1) / 10;
            }
            else
                fvalue1 = max;
            if(g_bDashboardMinMaxDecimalPlaces) {
                maxDecimalPlaces = -1;
                if(Math.abs(min) > 2)
                    maxDecimalPlaces = g_iDashboardDecimalPlaces;
                fvalue1 = numToFixedLength(fvalue1, 8, maxDecimalPlaces, true)
            }
            if(mode < 2) {
                if(g_dashboardChartList[index].maxValue !== fvalue1) {
                    if(bSaveChanges)
                        g_dashboardChartList[index].maxValue = fvalue1;
                    bChange = true;
                    
                }
            }
            results.max = fvalue1;
            if(g_bDashboardMinMaxUsePadding) {
                if(Math.abs(min) > 100)
                    fvalue1 = (Math.round(min / 10) - 1) * 10;
                else if(Math.abs(min) > 1)
                    fvalue1 = Math.ceil(min - 1);
                else 
                    fvalue1 = Math.ceil((min * 10) - 1) / 10;
            }
            else
                fvalue1 = min;
            if(g_bDashboardMinMaxDecimalPlaces) {
                
                fvalue1 = numToFixedLength(fvalue1, 8, maxDecimalPlaces, false)
            }
            if(mode < 2) {
                if(g_dashboardChartList[index].minValue !== fvalue1) {
                    if(bSaveChanges)
                        g_dashboardChartList[index].minValue = fvalue1;
                    bChange = true;
                }
            }
            results.min = fvalue1;
            if(bChange) {
                if(g_dashboardChartList[index].dynamicRange) {
                    g_dashboardChartList[index].iDynamicRangeCount = ivChartTotalEntries + 2;
                }
            }
            if(mode  < 2) {
                if(bChange && bUpdateChart && !g_bdashboardChartPause && bSaveChanges) {
                    try {
                        ivInitializeChart1(g_bDashboardSupportLogData, g_dashboardChartList[index].displayId, g_dashboardChartList[index].minValue, g_dashboardChartList[index].maxValue, null, null, null, null, g_dashboardChartList[index].chartlabels);
                        
                    } catch (err) {}
                }
            }
			
		}
	}
    catch {}
    return results;
}
function dashboardDecimialPlaces() {
    if(g_iMainDisplayMode !== DISPLAYMODE_DASHBOARD)
        return;
    try {
        g_iDashboardDecimalPlaces = document.getElementById("dashboardDecimalPlaces").value;
        g_iDashboardDecimalPlaces = Number(g_iDashboardDecimalPlaces);
    }
    catch(err) {}
}
function dashboardMouseEventsAddToChart(displayId, parentDivId, chartIndex) {
    // SVG must be in a parent DIV by itself
    var meterObj;
    var meterSvgDoc;
    if(navigator.userAgent.match(/Chrome/))	
    {		
      meterObj = document.getElementById(displayId);
      meterSvgDoc = meterObj.contentDocument;
    }
    else
    meterSvgDoc = document.getElementById(displayId).getSVGDocument();
    
    meterSvgDoc.getElementById("rect1").chartIndex = chartIndex;
    meterSvgDoc.getElementById("rect1").parentDivId = parentDivId;
      
    meterSvgDoc.getElementById("rect1").addEventListener("mousemove",dashboardMousemove);
    meterSvgDoc.getElementById("rect1").addEventListener("mouseenter",dashboardMouseenter);
    meterSvgDoc.getElementById("rect1").addEventListener("mouseout",dashboardMouseout);
}
function dashboardMouseenter(e) {
    if(g_bDashboardDisplayMouseToolTip) {
        dashboardMousemove(e);
    }
    e.preventDefault();
}
function dashboardMousemove(e) {
    try {
        if(g_bDashboardDisplayMouseToolTip) {
            var parentDivId = e.target.parentDivId;
            var chartIndex = e.target.chartIndex; 
            dashboardMousePositionChartDisplayValue(chartIndex, parentDivId, e.clientX, e.clientY);
        }
        e.preventDefault();
    }
catch (err) {}
}
function dashboardMouseout(e) {
    if(g_bDashboardDisplayMouseToolTip) {
        var svgObj, svgDoc;
        var tooltip;
        var chartIndex = e.target.chartIndex;
        if(g_dashboardChartList == null) 
            return "";
        if(g_dashboardChartList.length == 0)
            return "";
        if(chartIndex >= g_dashboardChartList.length)
            return;
        if(navigator.userAgent.match(/Chrome/))	
        {		
            svgObj = document.getElementById(g_dashboardChartList[chartIndex].displayId);
            svgDoc = svgObj.contentDocument;
        }
        else
            svgDoc = document.getElementById(g_dashboardChartList[chartIndex].displayId).getSVGDocument();
        tooltip = svgDoc.getElementById("tooltip");
        if(tooltip !== null) 
            tooltip.setAttributeNS(null, "visibility", "hidden");
    }
    e.preventDefault();
}
function showTooltip(evt, text) { //remove
    let tooltip = document.getElementById("tooltip");
    tooltip.innerHTML = text;
    tooltip.style.display = "block";
    tooltip.style.left = evt.pageX + 10 + 'px';
    tooltip.style.top = evt.pageY + 10 + 'px';
  }
function dashboardMousePositionChartDisplayValue(chartIndex, parentDivId, eClientX, eClientY) {
// ffix to add enums zzzzzzzzzz
    var sResult = "";
    var svgObj, svgDoc, svgChartRectangle;
    var str = "", value, presetValue = "";
    var d, time, dates, timestamp = 0, i, delta1, delta2, dataIndex = -1;
    var chartList = [];
    var startTimestampMicroSec;
    var endTimestampMicroSec; 
    var xRange; 
    var range; 
    var min, max;
    var oneDayMs = 24 * 60 * 60 * 1000;
    var iTimeOffset = 1; // 1: time only, 2=time + date
    var x,y,w = 500;
    var yoffset, yoffset1 = 400, yoffset2 = 300;   
    var xoffset, xoffset1 = 550, xoffset2 = 50;
    try {
        
        if(g_dashboardChartList == null) 
            return "";
        if(g_dashboardChartList.length == 0)
            return "";
        if(chartIndex >= g_dashboardChartList.length)
            return "";
        if(typeof g_dashboardChartList[chartIndex].data === "undefined")
            return "";
        if(g_dashboardChartList[chartIndex].data === null)
            return ""
        if(g_dashboardChartList[chartIndex].data.length === 0)
            return "";
        
        chartList = g_dashboardChartList[chartIndex].data;
        min = g_dashboardChartList[chartIndex].minValue;
        max = g_dashboardChartList[chartIndex].maxValue;
        startTimestampMicroSec = g_dashboardChartList[chartIndex].startTimestamp;
        endTimestampMicroSec = g_dashboardChartList[chartIndex].endTimestamp;
        xRange = endTimestampMicroSec - startTimestampMicroSec; // MicroSec
        if(navigator.userAgent.match(/Chrome/))	
        {		
            svgObj = document.getElementById(g_dashboardChartList[chartIndex].displayId);
            svgDoc = svgObj.contentDocument;
        }
        else
            svgDoc = document.getElementById(g_dashboardChartList[chartIndex].displayId).getSVGDocument();
        svgChartRectangle = svgDoc.getElementById("rect1");
        svgP = ivSvgPoint(svgDoc, svgChartRectangle, eClientX, eClientY);
        if(svgP != null) {
            if((svgP.x >= 0) && (svgP.y >= 0)) {
                
                if((min != null) && (max != null)) {
                range = max - min;
            
                timestamp = (svgP.y / ivChartXLengthLargeChart) * xRange;
                timestamp += startTimestampMicroSec;
                if(timestamp <= endTimestampMicroSec) {
                    // determine closest saved value
                    if(g_dashboardChartList[chartIndex].data.length === 1) {
                        value = g_dashboardChartList[chartIndex].data[0].value;
                        timestamp = g_dashboardChartList[chartIndex].data[0].timestamp;
                        dataIndex = 0;
                        if(typeof g_dashboardChartList[chartIndex].data[dataIndex].presetValue !== "undefined")
                            presetValue = g_dashboardChartList[chartIndex].data[dataIndex].presetValue;
                    }
                    else {

                        for(i=0; i < g_dashboardChartList[chartIndex].data.length; i++)
                        {
                            if(timestamp < g_dashboardChartList[chartIndex].data[i].timestamp) {
                                if (i === 0) {
                                    value = g_dashboardChartList[chartIndex].data[0].value;
                                    timestamp = g_dashboardChartList[chartIndex].data[0].timestamp;
                                    dataIndex = i;
                                    if(typeof g_dashboardChartList[chartIndex].data[dataIndex].presetValue !== "undefined")
                                        presetValue = g_dashboardChartList[chartIndex].data[dataIndex].presetValue;
                                }
                                else {
                                // check if previous stored value closer
                                    delta1 = timestamp - g_dashboardChartList[chartIndex].data[i - 1].timestamp;
                                    delta2 = g_dashboardChartList[chartIndex].data[i].timestamp - timestamp;
                                    dataIndex = i;
                                    if(delta1 < delta2)
                                        dataIndex --;
                                    }
                                    value = g_dashboardChartList[chartIndex].data[dataIndex].value;
                                    timestamp = g_dashboardChartList[chartIndex].data[dataIndex].timestamp;
                                    if(typeof g_dashboardChartList[chartIndex].data[dataIndex].presetValue !== "undefined")
                                        presetValue = g_dashboardChartList[chartIndex].data[dataIndex].presetValue;
                                    break;
                                }
                            }
                        }
                    }
                    if(dataIndex !== -1) {
                        if(g_bDashboardDisplayMouseToolTipShowPresets && (presetValue !== ""))
                            value = presetValue;
                        else {
                            if(typeof value === "number") {
                                if(value.toString().indexOf(".") !== -1) {
                                    if(min > 10)
                                        str = value.toFixed(2);
                                    else if(max > 50)
                                        str = value.toFixed(2);
                                    else if(max >= 1)
                                        str = value.toFixed(2);
                                    else if(min > 1)
                                        str = value.toFixed(3);
                                    else
                                        str = value;
                                    value = str;
                                }
                            }
                        }
                        
                        d = new Date();
                        d.setTime(timestamp);
                        time = d.toLocaleTimeString();
                        //dates = d.toLocaleDateString().split("/");
                        str = time;
                        if(xRange > oneDayMs) {
                            iTimeOffset = 2;
                            str += " " + d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0); //dates[2] + "-" +  ivPadStart(dates[0], "0", 2) + "-" +  ivPadStart(dates[1], "0", 2);
                        }
                        sResult = value + "<br>" + str;

                        x =  svgP.y + xoffset1;
                        if((x + (w * iTimeOffset)) > (ivChartXLengthLargeChart + 100))
                            x =   svgP.y - xoffset2;
                        y = ivChartYLengthLargeChart + 100 - svgP.x - yoffset1;
                        if(y < 0)
	                        y = yoffset2;
                    
                        tooltip = svgDoc.getElementById("tooltip");
                        if(tooltip !== null) {
                        // tooltip.setAttributeNS(null, "x", svgP.x + 200);//mouseX + 6 / CTM.a);
                        //  tooltip.setAttributeNS(null, "y", svgP.y + 200);//mouseY + 20 / CTM.d);
                            tooltip.setAttributeNS(null, "visibility", "visible");
                            tooltiptext = svgDoc.getElementById("tooltiptextrect");
                            tooltiptext.setAttributeNS(null, "x", x - 20);
                            tooltiptext.setAttributeNS(null, "y", y);
                            tooltiptext = svgDoc.getElementById("tooltiptext1");
                            tooltiptext.setAttributeNS(null, "x", x);
                            tooltiptext.setAttributeNS(null, "y", y + 100);
                            tooltiptext.textContent = value;
                            tooltiptext = svgDoc.getElementById("tooltiptext2");
                            tooltiptext.setAttributeNS(null, "x", x);
                            tooltiptext.setAttributeNS(null, "y", y + 150);
                            tooltiptext.textContent = str;
                            if(iTimeOffset === 2) {
                                //ffixx  add g_dashboardChartList[chartIndex].tooltipWidth and clear on clear button and reenter dashboard
                                //if( g_dashboardChartList[chartIndex].tooltipWidth !== 2)
                                tooltiptext.setAttributeNS(null, "width", (w * iTimeOffset));
                            }
                            else {
                                //if( g_dashboardChartList[chartIndex].tooltipWidth !== 1)
                                tooltiptext.setAttributeNS(null, "width", (w * iTimeOffset));
                            }
                        }
                    }
                }
            }
        }
    }
    catch (err) {
        sResult += "<br>" + err.toString();
    }
return sResult;
}
function timerHandlerDashboard() {
    // used only once
    var i;
    g_bDashboardSvgInit = false;
    try {
        if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
            // mode: 1= timer    
            initializeSvgDashboard();
            for(i=0; i < g_dashboardChartList.length; i++)
            {
                if( g_dashboardChartList[i].iDynamicRangeCount > 0) {
                    g_dashboardChartList[i].iDynamicRangeCount --;
                    if(g_dashboardChartList[i].iDynamicRangeCount === 1) {
                        dashboardDetermineChartMinMaxValuesForChart(0, i, null, true);
                        g_dashboardChartList[i].iDynamicRangeCount = 0;
                    }
                }
                dashboardUpdateCharts(i, null, null);
            }

        }
    }
    catch (err) {}
    g_bDashboardNeedToInitializeSvg = false;
    g_bDashboardUpdateCharts = false;
    g_bDashboardDataLogGetInProgress = false;
}
function updateDashboardCharts(mode) {
    return; // no longer used
    var bContinue = true;
    try 
    {
        var i;
        if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
            // mode: 1= timer    
            if(g_bDashboardSvgInit) {
                bContinue = false;
                g_iDashboardInitiCount ++;
                if(g_iDashboardInitiCount > 2)  {
                    g_iDashboardInitiCount = 0;
                    g_bDashboardSvgInit = false;
                    initializeSvgDashboard();
                    if(g_bDashboardSupportLogData) {
                        bContinue = true;
                        g_bDashboardUpdateCharts = false;
                        g_bDashboardDataLogGetInProgress = false;
                    }
                }
            }
            
            if(bContinue) {
                
                for(i=0; i < g_dashboardChartList.length; i++)
                {
                    if( g_dashboardChartList[i].iDynamicRangeCount > 0) {
                        g_dashboardChartList[i].iDynamicRangeCount --;
                        if(g_dashboardChartList[i].iDynamicRangeCount === 1) {
                            dashboardDetermineChartMinMaxValuesForChart(0, i, null, true);
                            g_dashboardChartList[i].iDynamicRangeCount = 0;
                        }
                    }
                    dashboardUpdateCharts(i, null, null);
                }
                
            }
        }
    }
    catch {}
}
