/********************************************************************************
 * 
 *  Datalog Chart 
 *      -Some functions in browser.js, and browsersvg.js
 * 
 *  This file mostly covers just populating the Data Log View Chart.  Most of the Data log code is in the browser.js file
 * 
 *   g_iDatalogPollMode: (browser.js)
 *      0: get data log, if polling enabled then continuously get new logs at the specifed rate
 *      1: get data log, if polling enabled then live data
 *      2: immediately get live data if polling is enabled.
 * 
 *   createDataLogClientWebSocketConnection(mode, request) - Defined in browser.js is used to get data log data
 */


var g_chartList = []; // currently used for datalog only
var g_zoomChartList = []; // zoom in chartList
var g_enumsList = [];
var g_chartLineList = [];
var g_datalogDisplayId = "";
var g_datalogSvgDoc = null;
var g_datalogChartInfo = {};
var g_enumsListNewValue = .8;
var g_bMouseDown = false;
var g_bDatalogChartZoomInProgress = false;
var g_mouseClickTimerVar = null;
var g_bCreateChartLegend = false;
var g_bDataLogChartUpdateLastEntryToCurrentTimestamp = false;
var g_iDatalogChartLineSelectedYaxis = 0; // 0=single, 1=Y1-only, 2=y2 only, 3= both controlled by radio button, only needed if both Y1 and Y2 are used
var g_iDatalogChartLineShowYaxis = 0; // 0= single Y axis --show all datapoint on Y1, 1 = only show datapoints on Y1, 2 = only show datapoints on Y2, show both Y1 and Y2.
var g_bDatalogChartAddZeroLineForNegNumbers = true;

function showDataLog() {
	showDataLog2("", "", null);
}
function showDataLog0(mode) {
	if(mode === 0)
		g_sDataLogDpPath = "Datapoints List";
	else if(mode === 1)
		g_sDataLogDpPath = "Favorite DPs List";	
	showDataLog1("", "", null);
}
function showDataLogForDevice(dpPath, dpProgrammaticPath, dpPathList) {
	
	showDataLog1(dpPath, dpProgrammaticPath, dpPathList);
}
function showDataLog1(dpPath, dpProgrammaticPath, dpPathList) {
	datalogLiveDataDpList = [];
	dataLogList = [];
	datalogPaneContent = "";
	if(g_iDatalogPollMode !== 2) {
		g_bDatalogStartGetRequest = true;
	}
	showDataLog2(dpPath, dpProgrammaticPath, dpPathList);
}
function showDataLog3(dpPath, dpProgrammaticPath, dpPathList) {
	datalogLiveDataDpList = [];
	dataLogList = [];
	datalogPaneContent = "";
	if(g_iDatalogPollMode === 2) {
		g_iDatalogPollMode = 1;
	}
	g_bDatalogStartGetRequest = true;
	showDataLog2(dpPath, dpProgrammaticPath, dpPathList);
}
function showDataLog4(dpPath, dpProgrammaticPath, dpPathList) {
	datalogLiveDataDpList = [];
	dataLogList = [];
	datalogPaneContent = "";
	if(g_iDatalogPollMode === 2) {
		g_iDatalogPollMode = 1;
	}
	g_bDatalogStartGetRequest = true;
	if(dpPath !== "")
		g_sDataLogDpPath = dpPath;
	else if(dpProgrammaticPath !== "")
	g_sDataLogDpPath = "xifname:" + programmaticPathname;
	showDataLog2(dpPath, dpProgrammaticPath, dpPathList);
}
function showDataLog2(dpPath, dpProgrammaticPath, dpPathList) {
	// dpPathList is used for favorites
	var paneTitle = "<label id=\"displayLabel\">Data Log</label>";
	var paneContent = "";
	var temp, temp1;
	var i, j, z, url, url1;
	var url;
	var obj;
	var d = new Date();
	//var dateItems = d.toLocaleDateString().split("/");
	var currentDate = ""; //dateItems[2] + "-" + dateItems[0] + "-" +dateItems[1];
	var currentTimestamp = ""; //currentDate + " " + d.toTimeString().substr(0,8);
	var currentTimeUtc = d.toISOString();
	var startOfDay; // = new Date(currentDate);
	var startOfDayStr = ""; // = startOfDay.toISOString();
	savePrevousHtmlContent();
	initializeDisplay();
	g_iMainDisplayMode = DISPLAYMODE_DATALOG;
	g_bDataLogChartUpdateLastEntryToCurrentTimestamp = false;
	g_bCreateChartLines = false;
	g_iDatalogChartMode = 0;
	g_PollingType = 0;
	g_bdatalogLiveDataConfigured = false;
	g_sWebSocketSubscribePayload_oldvalue = "";
	ivChartXLengthLargeChart = ivChartXLengthLargeChart3; // chart8
	ivChartYLengthLargeChart = ivChartYLengthLargeChart3;
	g_bDatalogUrlChanged = false; // used for datalog live polling, When checking the polled checked box, and this variable set then need to restart
	try {
		//currentDate = dateItems[2] + "-" + dateItems[0] + "-" +dateItems[1];
		currentDate = d.getFullYear().toString() + "-" + (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0);
		startOfDay = new Date(currentDate);
		startOfDayStr = startOfDay.toISOString();
		currentTimestamp = currentDate + " " + d.toTimeString().substr(0,8);
	}
	catch {}
	if(g_bEnableDataLogLiveData) {
		if(g_iDatalogPollMode === 2)
			g_bPollingEnabled = false;
		paneTitle += "<span style=\"margin-right:10px\">:</span><input type=\"radio\" id=\"datalogPollButtonlog\" name=\"datalogPollRadioButton\" onclick=\"datalogChangePollMode(this.value)\" value=\"0\"";
		if(g_iDatalogPollMode === 0)
			paneTitle += " checked";
		paneTitle += "> log only";
		paneTitle += "<input type=\"radio\" id=\"datalogPollRadioButtonlogLive\" name=\"datalogPollRadioButton\" onclick=\"datalogChangePollMode(this.value)\" value=\"1\"";
		if(g_iDatalogPollMode === 1)
			paneTitle += " checked";
		paneTitle += "> log + live ";
		paneTitle += "<input type=\"radio\" id=\"datalogPollRadioButtonlive\" name=\"datalogPollRadioButton\" onclick=\"datalogChangePollMode(this.value)\" value=\"2\"";
		if(g_iDatalogPollMode === 2)
			paneTitle += " checked";
		paneTitle += "> live only";
		paneTitle += "<input id=\"datalogPoll\" type=\"checkbox\" style=\"margin-left:30px\" onchange=\"datalogEnablePolling(0)\"";
		if(g_bDatalogPollingEnabled) {
			paneTitle += " checked";
			if(g_iDatalogPollMode === 2)
				g_PollingType = DISPLAYMODE_DATALOGLIVEPOLL;
		}
		paneTitle += ">Poll";
		paneTitle += " <input id=\"datalogRate\" onblur=\"datalogEnablePolling(0)\" value=\"" + g_iDataLogPollrate + "\"> sec";
		paneTitle += "<br><br><span style=\"width:100px\"></span>";
		paneTitle += "<button onclick=\"subscribeRequest()\" style=\"visibility:";
		if(g_iDatalogPollMode > 0)
			paneTitle += "visible";
		else
			paneTitle += "hidden";
		paneTitle += "\">Re-Subscribe</button>";

	}
	if(dpPathList !== null) {
		paneTitle += "<span style=\"display:inline-block;margin-left:20px\">Datapoints:</span>"; 
		//paneTitle += "<span style=\"display:inline-block;width:150px;margin-left:20px\">Datapoints:</span>"; 
		if(g_datalogUrlDpXifList.length === 0)
			g_datalogUrlDpXifList = dpPathList;
		else {
			for(i=0; i < dpPathList.length; i++) 
			{
				z = -1;
				for(j=0; j < g_datalogUrlDpXifList.length; j++) 
				{
					if( g_datalogUrlDpXifList[j].dpPath === dpPath) {
						z = j;
						break;
					}
				}
				if(z === -1) {
					obj = {};
					obj.dpPath = dpPathList[i].dpPath;
					obj.dpProgrammaticPath = dpPathList[i].dpProgrammaticPath;
					g_datalogUrlDpXifList.push(obj);
				}
			}
		}
	}
	else if(dpPath === "")
		paneTitle += "<span style=\"display:inline-block;margin-left:20px\">Datapoint:</span>"; 
		//paneTitle += "<span style=\"display:inline-block;width:150px;margin-left:20px\">Datapoint:</span>"; 
	else {
		paneTitle += "<span style=\"display:inline-block;margin-left:20px\">Datapoint:</span>";
		g_sDataLogDpPath = dpPath;
		dataLogList = [];
		if(dpPath.indexOf("/") !== 0) {
			if(dpPathList !== null)
				g_datalogUrlDpXifList = dpPathList;
			else {
				if(dpProgrammaticPath !== "") {
					if(dpProgrammaticPath.indexOf("/") !== 0) {
						if((dpPath.indexOf(",") === -1) && (dpProgrammaticPath.indexOf(",") === -1))
						z = -1;
						for(i=0; i < g_datalogUrlDpXifList.length; i++) 
						{
							if( g_datalogUrlDpXifList === dpPath) {
								z = i;
								break;
							}
						}
						if(z === -1) {
							obj = {};
							obj.dpPath = dpPath;
							obj.dpProgrammaticPath = dpProgrammaticPath;
							g_datalogUrlDpXifList.push(obj);
						}
					}

				}
			}
		}
		
	}
	if (g_sDataLogDpPath === "")
		g_sDataLogDpPath = "All DPs";
	dpPath = g_sDataLogDpPath;
	
	if(g_sDataLogDate === "")
		g_sDataLogDate = "1 hours";
	try {
		
		if(dpPath !== "") {
			paneTitle += "<input type=\"text\" id=\"dataLogDpUrl\" list=\"dataLogDpUrlList\" class=\"dataLogDp\" value=\"" + dpPath + "\" onchange=\"dataLogDpUrlChanged()\">";
			
			z = -1;
			for(i=0; i < dataLogDpUrlList.length; i ++)
			{
				if(dataLogDpUrlList[i] === dpPath) {
					z = i;
					break;
				}
			}
			if(z === -1)
				dataLogDpUrlList.push(dpPath);
		}
		else {
			paneTitle += "<input type=\"text\" id=\"dataLogDpUrl\" list=\"dataLogDpUrlList\" class=\"dataLogDp\" onchange=\"dataLogDpUrlChanged()\">";
			
		}
		
	} catch {}
	paneTitle += "<datalist id=\"dataLogDpUrlList\">";
	for(i=0; i < dataLogDpUrlList.length; i++)
	{
			paneTitle += "<option value=\"" + dataLogDpUrlList[i] + "\">";
	}
	//paneTitle += "<option value='All Logs'>";
	paneTitle += "<option value='All DPs'>";
	paneTitle += "<option value=\"Sensor1/LightSensor/0/nvoLuxLevel\">";
	paneTitle += "<option value=\"PulseGen/device/0/nvoPulseOut\">";
	paneTitle += "<option value=\"xifname:MS-01/Lamp/0/nvoValueFb\">";
	paneTitle += "<option value=\"/iap/ws?dev=*+name==MS-01&blockName=*+name==Lamp&blockIndex=0&dpName=*+name==nvoLampFb_1&value=*+utc>2021-04-22T08:00:00.000&utc<=2021-04-25T21:39:44.000\">";
	paneTitle += "<option value=\"/iap/ws?dev=%2A%2Bname%3D%3DMS-01&blockName=Lamp&blockIndex=0&dpName=nvoValueFb&value=%2A%2Butc%3E2021-04-22T08:00:00.000\">";
	paneTitle += "<option value=\"/iap/ws?dev=%2A%2Bname%3D%3DPulseGen 1&blockName=%2A%2Bname%3D%3Ddevice&blockIndex=0&dpName=%2A%2Bname%3D%3DnvoLuxLevel&value=%2A%2Butc%3E2021-04-22T08:00:00.000%26utc%3C%3D2021-04-22T21:39:44.000\">";
	paneTitle += "<option value=\"Datapoints List\">";
	paneTitle += "<option value=\"Favorite DPs List\">";
	paneTitle += "<option value=\"*/*/*/nvoLuxLevel\">";
	paneTitle += "<option value=\"Get First Entry\">";
	paneTitle += "<option value=\"Get Last Entry\">";
	paneTitle += "</datalist>";
	paneTitle += "<span style=\"display:inline-block;width:75px;margin-left:10px\">Duration:</span>";
	paneTitle += "<input type=\"text\" id=\"dataLogDpDate\" list=\"dataLogDateList\" class=\"dataLogDate\" value = \"" + g_sDataLogDate + "\">";
	paneTitle += "<datalist id=\"dataLogDateList\">";
	paneTitle += "<option value='All Logs'>";
	try {
		for(i=0; i < dataLogDateList.length; i++)
		{
			paneTitle += "<option value='" + dataLogDateList[i] + "'>";
		}
	} catch {}
	paneTitle += "<option value=\"1 minutes\">";
	paneTitle += "<option value=\"1 hours\">";
	paneTitle += "<option value=\"1 days\">";
	paneTitle += "<option value=\"Yesterday\">";

	paneTitle += "<option value=\">" + currentDate + "\">";		
	paneTitle += "<option value=\">" + currentDate + " 01:00:00.000\">";
	paneTitle += "<option value=\"" + currentDate + " 01:00:00.000 thru " + currentTimestamp + "\">";
	paneTitle += "<option value=\"" + startOfDayStr + " thru " + currentTimeUtc + "\">";
	//paneTitle += "<option value=\">2020-04-25 10:58:28.728\">";
	//paneTitle += "<option value=\"2020-04-25 10:58:28.728 thru 2020-04-25 10:58:28.728\">";
	//paneTitle += "<option value=\"2020-04-25T10:58:28.728Z thru 2020-04-25T10:58:28.728Z\">";
	//paneTitle += "<option value=\"2020-04-25\">";
	paneTitle += "</datalist>";
	paneTitle += "<button id=\"datalogRequestButton\" onclick=\"dataLogRequest()\">Get</button><hr></div>";

	
	//paneContent = "<div><button onclick=\"datalogSmartSort()\">DP sort</button><button onclick=\"clearTable()\">Clear Log</button><br>";
	paneContent = "<table id=\"datalogData\"></table><br><span id=\"gettingInfoId\" class=\"gettingInfo\"></span></div>";
	
	if(g_bDataLogGetInProgress) {
		if(g_datalogWsClient != null) {
			g_datalogWsClient.close();
			g_datalogWsClient = null;
		}
		g_bDataLogGetInProgress = false;
		paneContent = "<button onclick=\"dataLogAbort()\">Abort</button><br><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Previous Get DataLog Data Already in progres ...</span>";
	}
	document.getElementById("main-Header").innerHTML = paneTitle;
	document.getElementById("main").innerHTML = paneContent;

	if(g_bEnableDataLogLiveData) {
		if(g_iDatalogPollMode === 2) {
			document.getElementById("datalogRequestButton").disabled = true;
		}
		else {
			
		}
	}
	if(g_iDatalogPollMode === 0)
		temp = "Getting Logs";
	else if(g_iDatalogPollMode === 1)
		temp = "Getting Logs plus live data";
	else if(g_iDatalogPollMode === 2)
		temp = "Getting Live data";
	if(dpPath.toLowerCase() === "favorite dps list") {
		if(favDpList.length === 0) {
			document.getElementById("main").innerHTML = temp + " stopped as \"Favorite DPs\" list is empty - go to \"Favorites DPs\" View to add datapoint list";
			return;
		}
	
	}
	else if(dpPath.toLowerCase() === "datapoints list") {
		if(dpList.length === 0) {
			document.getElementById("main").innerHTML = temp + " stopped as \"Datapoints\" list is empty - go to \"Datapoints\" View to add datapoint list";
			return;
		}
	
	}

	if(!g_bDataLogGetInProgress) {
		if(dataLogList !== null) {
			if(dataLogList.length > 0) {
				if(dataLogDpList.length > 0) {
					if(g_iDatalogPollMode > 0) {
						datalogLiveDataDpList = JSON.parse(JSON.stringify(dataLogDpList));
						createRequestString(datalogLiveDataDpList);
						g_bdatalogLiveDataConfigured = true;
					}
				}
				if(datalogPaneContent !== "") {
					document.getElementById("main").innerHTML = datalogPaneContent;
					if(g_bShowDatalogChart) {
						if(dataLogDpList.length > 0) {
							// add datalog chart
							g_bUpdateCharts = true;
							g_bCreateChartLegend = true;
							// SVG lines need to be re-created 
							ivChart3ZeroLineAlreadyCreated = false;
							g_bCreateChartLines = true;
							
							try {
								window.setTimeout("timerHandlerChart()", 1000);
							} catch (err) {} 
						}
					}

				}
				else 
					datalogResponseProcessData(3, "", null);
			}
			else {
				// add code for live only for datapoints, favorites or device
				if(g_iDatalogPollMode == 2) {
					// live polling
					dataLogDpList = [];
					g_chartList = [];
					if(g_bDatalogPollingEnabled) {
						url = document.getElementById("dataLogDpUrl");
						if(url !== null) {
							url = url.value;
							url1 = url.toLowerCase();
							paneContent = "<button onclick=\"dataLogAbort()\">Abort</button><br><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Get live Data in progres ...</span>";
							document.getElementById("main").innerHTML = paneContent;
							
							if(url1 === "favorite dps list") {
								datalogStartLiveData(0); //dataLogRequest();
							}
							else if(url1 === "datapoints list") {
								datalogStartLiveData(0); //dataLogRequest();
							}
							else if (url.indexOf("/") !== -1) {
								datalogStartLiveData(0); //datalogGetDpListFromDpInstanceNamesCheck(url);
							}
							else if(dataLogCheckIfUrlIsForDevice(url)) {
								datalogStartLiveData(0); //dataLogRequest();
							}
							else {
								temp = "\"live only\" supports only:<br><br>Device Name (single Device)<br>Datapoints List<br>";
								temp += "Favorite DPs List<br>Datapoints List \(comma separated): PulseGen 1/Light/0/nviLamp";
								document.getElementById("main").innerHTML = temp;
							}
						}
					}
				}
				else if(g_bDatalogStartGetRequest) {

					dataLogDpList = [];
					g_chartList = [];
					dataLogRequest();
				}
			}
		}
	}
	
}
function showDataLogGetDpsFromDeviceType (bFixed, deviceType, pathName) {
	try {
		menuCancel();
		if(deviceTypeList.length > 0)
			showDataLogGetDpsFromDevice_getDpInfo(bFixed, deviceType, pathName);
		else {
			url = "https://" + location.hostname + "/iap/devTypes/*?short=false&sortBy=name&sortOrder=asc"; //8888
			obj = {};
			obj.bFixed = bFixed;
			obj.deviceType = deviceType;
			obj.pathName = pathName;
			requestGetData(obj, url, showDataLogGetDpsFromDeviceTypeResponse, null);
		}
	}
	catch (err) {}
}
function showDataLogGetDpsFromDeviceTypeResponse(mode, requestUrl, json) {
	var bFixed, deviceType, pathName;
	bFixed = mode.bFixed;
	deviceType = mode.deviceType;
	pathName = mode.pathName;
	deviceTypeList = json;
	showDataLogGetDpsFromDevice_getDpInfo(bFixed, deviceType, pathName)
}
function showDataLogGetDpsFromDevice_getDpInfo(bFixed, deviceType, pathName) {
	// deviceType: fixed = deviceName, relative = devicetype, pathName = block Name/Block Index/DP XiF Name
	var i,j, k, z, typeId, bcontinue = false, sDpQualifierPathList = "", newEntry, url, programmaticPathname = ""; //123455
	
	try {
		//create dp qualifier list
		if(bFixed) {
			for (i=0; i < deviceListAll.length; i++)
			{
				if(deviceListAll[i].name === deviceType) {
					//if(deviceListAll[i].status.state === "provisioned") {
						programmaticPathname = deviceListAll[i].name + "/" + pathName;
						showDataLog3(programmaticPathname, "", null);
						return;
					//}
					break;
				}
			}
		}
		else {
			for (j=0; j < deviceTypeList.length; j++) 
			{
				if(deviceTypeList[j].name === deviceType) {
					typeId = deviceTypeList[j].id;
					for (i=0; i < deviceListAll.length; i++)
					{
						if(deviceListAll[i].typeId === typeId) {
							z = -1;
							if(programmaticPathname += "")
								programmaticPathname += ",";
							programmaticPathname += deviceListAll[i].name + "/" + pathName;
						}
					}
					break;
				}
			}
			g_sDataLogDpPath = "xifname:" + programmaticPathname;
			showDataLog3("", "", null);
		}
		
	}
	catch {}
}


/************************************************************************ 
 * DataLog Chart
**************************************************************************/ 
function datalogChartUpdate(mode) {
    //mode: 0 = initial show of chart, 1=determine new min max values changed (, or min max) or datapoints selected and unselected, 2=redraw
    var bExtendLinetoEndTimestamp = false; // false for data log, true for live data
    if(mode == 0)
            datalogChartAddEventListener("dataLogChartSvg");
    if(g_PollingType === DISPLAYMODE_DATALOGLIVEPOLL)
        bExtendLinetoEndTimestamp = true;
    if(g_bDatalogChartZoomInProgress) {
        if(mode < 2) {
            determineMinMaxForZoomChartList(1);
            ivInitializeChart3("dataLogChartSvg", g_datalogChartInfo.zoomMinValue, g_datalogChartInfo.zoomMaxValue, g_datalogChartInfo.zoomMinValue2nd, 
                g_datalogChartInfo.zoomMaxValue2nd, g_bDatalogChartAddZeroLineForNegNumbers, g_iDatalogChartLineSelectedYaxis, null, null, "white", null, "both");
        }    
        ivUpdateChartsDatalogChart3TwoYaxis(g_datalogChartInfo.displayId, "Zoom: ", g_iDatalogChartLineType, g_iDatalogChartLineSelectedYaxis, g_zoomChartList, null, 
            g_datalogChartInfo.zoomMinValue, g_datalogChartInfo.zoomMaxValue,g_datalogChartInfo.zoomMinValue2nd, g_datalogChartInfo.zoomMaxValue2nd,
            g_datalogChartInfo.zoomStartTimestamp, g_datalogChartInfo.zoomEndTimestamp, 5, bExtendLinetoEndTimestamp, "both");
    }
    else {
        if(mode < 2) {
            determineMinMaxForChartList(1);
            ivInitializeChart3("dataLogChartSvg", g_datalogChartInfo.minValue, g_datalogChartInfo.maxValue, g_datalogChartInfo.minValue2nd, g_datalogChartInfo.maxValue2nd,
                g_bDatalogChartAddZeroLineForNegNumbers, g_iDatalogChartLineSelectedYaxis, null, null, "white", null, "both");
        }
        ivUpdateChartsDatalogChart3TwoYaxis(g_datalogChartInfo.displayId, "", g_iDatalogChartLineType, g_iDatalogChartLineSelectedYaxis, g_chartList, null,
            g_datalogChartInfo.minValue, g_datalogChartInfo.maxValue, g_datalogChartInfo.minValue2nd, g_datalogChartInfo.maxValue2nd,
            g_datalogChartInfo.startTimestamp, g_datalogChartInfo.endTimestamp, 5, bExtendLinetoEndTimestamp, "both");
    }
}
function datalogChartInit(mode, displayId) {
    if(mode == 0) {
        ivChartAllowTwoYaxis = true;
        ivChartUseTwoYaxis = false;
        g_bDatalogChartYMinMax = true;
        ivChartLines = [];
        ivChartLines[0] = {};
        ivChartLines[0].created = true;
        ivChartLines[0].name = "polyline1";
        ivChartLines[0].color = "blue";
        datalogPaneContent = "";
        g_bCreateChartLegend = false;
        g_iDataLogChartYaxisDisplayed = 0; // 0=only y1, 1=only y2, 2=y1 and y2 
        g_bDataLogChartUpdateLastEntryToCurrentTimestamp = false;
        g_enumsList = [];
        g_enumsListNewValue = .8;
        g_iDatalogChartLineSelectedYaxis = 0; // controlled by radio button, only needed if both Y1 and Y2 are used
    }
    else if(mode < 2) {
        g_chartLineList = [];
        ivChartLineColorsIndex = 0;
        g_iDatalogChartLineType = 1;
        g_bDataLogChartUsesTwoYaxis = false;
        ivChart3ZeroLineAlreadyCreated = false;
        g_iDatalogChartLineShowYaxis = 0; // what is shown in chart
    }
    
    ivChartNeedTwoYaxis = false;
    g_bDatalogChartZoomInProgress = false;
    bDataLogGetInProgress = false;
    g_datalogSvgDoc = null;
    g_chartList = [];
    g_zoomChartList = [];
    g_datalogChartInfo = {};
    g_datalogChartInfo.displayId = displayId;
    g_datalogChartInfo.minValue = null;
    g_datalogChartInfo.maxValue = null;
    g_datalogChartInfo.minValue2nd = null; //yAxis2 - if ivChartUseTwoYaxis
    g_datalogChartInfo.maxValue2nd = null; //yAxis2
    g_datalogChartInfo.startTimestamp = null;
    g_datalogChartInfo.endTimestamp = null;
    g_datalogChartInfo.zoomMinValue = null;
    g_datalogChartInfo.zoomMaxValue = null;
    g_datalogChartInfo.zoomMinValue2nd = null; //yAxis2
    g_datalogChartInfo.zoomMaxValue2nd = null; //yaxis2
    g_datalogChartInfo.zoomStartTimestamp = null;
    g_datalogChartInfo.zoomEndTimestamp = null;
    g_datalogChartInfo.mouseDownX1 = null; // window coordinates used for zoom start of window
    g_datalogChartInfo.mouseDownY1 = null;
    g_datalogChartInfo.mouseDownX2 = null; // window coordinates used for zoom start of window
    g_datalogChartInfo.mouseDownY2 = null;
    g_datalogChartInfo.datapointsWithEnum = 0;
    g_datalogChartInfo.zoomDatapointsWithEnum = 0;
    g_datalogChartInfo.datapointsOnY1 = 0;
    g_datalogChartInfo.datapointsOnY2 = 0;  // datapoint value must be between 0 and 1.
    g_datalogChartInfo.zoomDatapointsOnY1 = 0;
    g_datalogChartInfo.zoomDatapointsOnY2 = 0;  // datapoint value must be between 0 and 1.
    g_datalogChartInfo.bNeedTwoYaxis = false;


}
function chartLineAllEnable() {
    try {
        var i, j, displayId, displayObj;
        var checked = document.getElementById("chartLineAllEnable").checked;
        for(i=0; i < g_chartList.length; i++)
        {
            g_chartList[i].display = checked;
            g_chartList[i].show = checked;
            displayId = "line_" + g_chartList[i].pathName + "__field_" + g_chartList[i].field;
            lineListIndex = g_chartList[i].lineColorIndex;
            if((g_chartLineList[lineListIndex].pathName == g_chartList[i].pathName) && (g_chartLineList[lineListIndex].field == g_chartList[i].field)) {
                g_chartLineList[lineListIndex].show = g_chartList[i].display;
                if((g_iDatalogChartLineSelectedYaxis == 0) || (g_iDatalogChartLineSelectedYaxis == 3))
                    g_chartList[i].show = g_chartList[i].display;
                else if(g_iDatalogChartLineSelectedYaxis == 1) {
                    if(g_chartList[i].yAxis == 1)
                        g_chartList[i].show = g_chartList[i].display;
                    else
                        g_chartList[i].show = false;
                }
                else if(g_iDatalogChartLineSelectedYaxis == 2) {
                    if(g_chartList[i].yAxis == 2)
                        g_chartList[i].show = g_chartList[i].display;
                    else
                        g_chartList[i].show = false;
                }
                g_chartLineList[lineListIndex].show = g_chartList[i].display; // legend checkvox
                if(g_bDatalogChartZoomInProgress) {
                    if((g_zoomChartList[i].pathName == pathName) && (g_zoomChartList[i].field == field)) {
                        g_zoomChartList[i].show = g_chartList[i].show;
                        g_zoomChartList[i].display = g_chartList[i].display;
                        
                    }
                }
            }
            displayObj = document.getElementById(displayId);
            if(displayObj != null)
                displayObj.checked = checked;
        }
        datalogChartUpdate(1);
    }
    catch {}
}
function chartLineEnable(chartListId, pathName, field) {
    try {
        var displayId, lineListIndex;
        if((g_chartList[chartListId].pathName == pathName) && (g_chartList[chartListId].field == field)) {
            displayId = "line_" + g_chartList[chartListId].pathName + "__field_" + g_chartList[chartListId].field;
            lineListIndex = g_chartList[chartListId].lineColorIndex;
            if((g_chartLineList[lineListIndex].pathName == pathName) && (g_chartList[chartListId].field == field)) {
                g_chartList[chartListId].display = document.getElementById(displayId).checked; // legend checkbox
                g_chartLineList[lineListIndex].show = g_chartList[chartListId].display;
                if((g_iDatalogChartLineSelectedYaxis == 0) || (g_iDatalogChartLineSelectedYaxis == 3))
                    g_chartList[chartListId].show = g_chartList[chartListId].display;
                else if(g_iDatalogChartLineSelectedYaxis == 1) {
                    if(g_chartList[chartListId].yAxis == 1)
                        g_chartList[chartListId].show = g_chartList[chartListId].display;
                    else
                        g_chartList[chartListId].show = false;
                }
                else if(g_iDatalogChartLineSelectedYaxis == 2) {
                    if(g_chartList[chartListId].yAxis == 2)
                        g_chartList[chartListId].show = g_chartList[chartListId].display;
                    else
                        g_chartList[chartListId].show = false;
                }
                g_chartLineList[lineListIndex].show = g_chartList[chartListId].display; // legend checkvox
                if(g_bDatalogChartZoomInProgress) {
                    if((g_zoomChartList[chartListId].pathName == pathName) && (g_zoomChartList[chartListId].field == field)) {
                        g_zoomChartList[chartListId].show = g_chartList[chartListId].show;
                        g_zoomChartList[chartListId].display = g_chartList[chartListId].display;
                        
                    }
                }
                datalogChartUpdate(1);
            }

        }
    }
    catch {}
}
function createChartLegend() {
    try {
        var displayId;
        var legend = document.getElementById("chartLegend");
        var legendStr = "";
        var max = 10;
        var count = 0;
        var bAddDivEnd = false;
        var divCount = 1;
        
        if(legend != null) {
            //legend.style.backgroundColor = "#dcdcdc";
            //legend.style.color = "black";
           if(g_chartList != null) {

                for(i=0; i < g_chartList.length; i++)
                {
                    if(g_chartList[i].display)
                        count++;
                    else
                        break;
                }

                legendStr += "<div style=\"text-align:center\">";
                legendStr += "<input type=\"checkbox\" id=\"chartLineAllEnable\"";
                legendStr += " onchange=\"chartLineAllEnable()\"";
                if(count == g_chartList.length)
                    legendStr += " checked";
                legendStr += "> Legend [<span id=\"legendDpCount\">" + g_chartList.length + "</span> Datapoints/Fields]</div><br><div id=\"legendLineDivs\" style=\"display:flex\">";
                count = 0;
                for(i=0; i < g_chartList.length; i++)
                {
                    if(count == 0) {
                        if(bAddDivEnd) {
                            legendStr += "</div>";
                            divCount ++;
                        }
                        legendStr += "<div id=\"legendDiv_" + divCount + "\" style=\"margin-left:5px;min-width:400px\">"
                        bAddDivEnd = true;
                    }
                    displayId = "line_" + g_chartList[i].pathName + "__field_" + g_chartList[i].field;
                    
                    legendStr += "<br><input type=\"checkbox\" id=\"" + displayId + "\"";
                    legendStr += " onchange=\"chartLineEnable(" + i + ",'" +  g_chartList[i].pathName + "', '" + g_chartList[i].field + "')\"";
                    if(g_chartList[i].display)
                        legendStr += " checked";
                    legendStr += "><label style=\"color:" + g_chartList[i].color + ";background-color:#dcdcdc\">";
                    legendStr += g_chartList[i].pathNameUI;
                    if(g_chartList[i].field != "") {
                        legendStr += " [" + g_chartList[i].field + "]";
                    }
                    legendStr += "</label>";
                    i
                    count ++;
                    if(count > max)
                        count = 0;
                    
                }
                if(bAddDivEnd == 0)
                    legendStr += "</div>"
                
            }
            else
                legendStr += "<div style=\"text-align:center\">Legend [0 Datapoints/Fields]";
            legend.innerHTML = legendStr + "</div>";
        }
    }
    catch {}
}

function createChartObjectLargeChart(mode, index, displayId, pathName, valueList, min, max, hasDynmaicRange, linecolor, chartlabels) {
    // single line chart2.svg
    // mode: 0= current end date, 1= has end date
    try {
        var fvalue, fvalue1;
        var chart = {};
        var polygoncolor;
        var obj, obj1;
        var i, iCount = 0;
        var ptr;
        var temp, bAddToChartData = true;
        if(dataLogDpList[index].pathName != pathName)
            return;
        chart.startPtr = 0;
        chart.endPtr = 0;
        chart.pathName = pathName;
        chart.dashboardDpIndex = index;
        chart.displayId = displayId;
        chart.chartLabels = "both";
        chart.data = [];
        chart.dataCurrentEntries = 1; //iottest
        chart.hasNegativeNumbers = dataLogDpList[index].hasNegativeNumbers; 
        if(valueList != null) {
            ptr = valueList.length;
            for(i=0; i < valueList.length; i++)
            {
                ptr --;
                bAddToChartData = true;
                // only add to chart.data if value is different from previous value, if same value then change timestamp - this will greatly reduce number of datapoints to chart
                if(i > 2) {
                    //if(valueList[ptr].value == chart.data[chart.data.length - 1].value) {
                        if(valueList[i].value == chart.data[0].value) {
                            chart.data[0].timestamp = valueList[i].timestamp; // don't use
                            bAddToChartData = false;
                    }
                }
                if(bAddToChartData) {
                    iCount ++;
                    obj = {};
                    obj1 = {};
                    obj = valueList[i];
                    temp = JSON.stringify(obj);
                    obj1 = JSON.parse(temp);
                    chart.data.unshift(obj1);
                }
                //chart.data.push(JSON.parse(Json.stringify(valueList[ptr -  i])));
                if(iCount > ivChartTotalEntriesLargeChart)
                    break;
            }
            //if(mode == 0)
                //chart.data.push(JSON.parse(Json.stringify(valueList[ptr -  i]))); // repeat last line 
        }
        chart.endPtr = chart.data.length - 1;
        chart.dataCurrentEntries = chart.data.length;
        if(max != null) {
            fvalue = parseFloat(max);
            if(fvalue < 0) 
                fvalue1 = 0;
            else if(fvalue < 1) 
                fvalue1 = 1;
            if(fvalue < 5)
                fvalue1 = 5;
            else if(fvalue > 1) 
                fvalue1 = (Math.round(fvalue / 10) + 1) * 10;
			max = fvalue1;
        }
        if(hasDynmaicRange) {
            if(min != null) {
                fvalue = parseFloat(min);
                if(fvalue < 0) 
                fvalue1 = (Math.round(fvalue / 10) - 1) * 10;
                else if(fvalue < 1) 
                    fvalue1 = 0;
                if(fvalue < 5)
                    fvalue1 = 0;
                else if(fvalue > 1) 
                    fvalue1 = (Math.round(fvalue / 10) - 1) * 10;
                min = fvalue1;
            }
        }
        else {
            min = 0;
            if (dataLogDpList[index].hasNegativeNumbers) {
                min = dataLogDpList[index].min;
            }
        }
        g_datalogChartInfo.minValue = min;
        g_datalogChartInfo.maxValue = max; 
        g_datalogChartInfo.startTimestamp = chart.data[0].timestamp;
        g_datalogChartInfo.endTimeStamp = chart.data[chart.data.length - 1].timestamp;
        chart.maxValue = max;
        chart.minValue = min;
        chart.dynamicRange = hasDynmaicRange;
        chart.chartlabels = chartlabels;
        if(linecolor == null) {
            linecolor = "blue";
        }
        polygoncolor = "light" + linecolor;
        chart.lineColor = linecolor;
        chart.polygoncolor = polygoncolor;
        g_chartList.push(chart);
        
    }
    catch {}
}
function createChartObjectLargeChart3(binitial, mode, index, displayId, chartDpList) {
    // chart3.svg
    // this function takes a dplist and creates a line for each scalar datapoint or field that is a scalar [1 level deep]
    // multiline field support
    // mode: 0= current end date, 1= has end date
    // create one chart entry per datapoint field
    try {
        var i, k;
        var obj, obj1;
        var temp, bAddNewEntry, bUpdateLastEntry;
        var atleastoneY1Datapoint = false, atleastoneY2Datapoint = false;
        if(chartDpList == null)
            return;
        if(chartDpList.length == null)
            return;
        datalogChartInit(2, displayId);
        ivChartLineColorsIndex = 0;
        ivChartNeedTwoYaxis = false;
        for(k=0; k < chartDpList.length; k++) {
            if(chartDpList[k].valueList != null) {
                if(chartDpList[k].valueList.length > 0) {
                    if((typeof chartDpList[k].valueList[0].value === "number") || (typeof chartDpList[k].valueList[0].value === "string")){
                        createChartObjectLargeChartLine(mode, index, displayId, chartDpList[k].pathName, chartDpList[k].pathNameUI, "", chartDpList[k].valueList); // string is a enum
                    }
                    else {
                        // field so create a chart line for each field
                        createChartObjectLargeChartFieldLines(mode, index, displayId, chartDpList[k].pathName, chartDpList[k].pathNameUI, chartDpList[k].valueList);
                    }

                } //if(chartDpList[k].valueList.length > 0) {
            }
        } // for(k=0; k < chartDpList; k++)
        for(i=0; i < g_chartList.length; i++)
        {
            if(i==0) {
                g_datalogChartInfo.startTimestamp = g_chartList[i].startTimestamp;
                g_datalogChartInfo.endTimestamp = g_chartList[i].endTimestamp;
            }
            else {
                if(g_datalogChartInfo.startTimestamp > g_chartList[i].startTimestamp)
                    g_datalogChartInfo.startTimestamp = g_chartList[i].startTimestamp;
                if(g_datalogChartInfo.endTimestamp < g_chartList[i].endTimestamp)
                    g_datalogChartInfo.endTimestamp = g_chartList[i].endTimestamp;
            }
        }
        if(g_bDataLogChartUpdateLastEntryToCurrentTimestamp) {
            for(i=0; i < g_chartList.length; i++)
            {
                bAddNewEntry = false;
                bUpdateLastEntry = false;
                if((g_chartList[i].endPtr == 0) && (g_chartList[i].data[g_chartList[i].endPtr].timestamp < g_datalogChartInfo.endTimestamp))
                    bAddNewEntry = true;
                if(g_chartList[i].data[g_chartList[i].endPtr].timestamp < g_datalogChartInfo.endTimestamp) {
                    if(g_chartList[i].dataCurrentEntries > 1) {
                        if(g_chartList[i].data[g_chartList[i].endPtr].value != g_chartList[i].data[g_chartList[i].endPtr - 1].value) {
                            // add new entry
                            bAddNewEntry = true;
                        }
                        else 
                            bUpdateLastEntry = true;
                    }
                    else 
                        bAddNewEntry = true;
                }
                    if(bAddNewEntry) {
                        obj = {};
                        obj1 = {};
                        obj = g_chartList[i].data[g_chartList[i].endPtr];
                        temp = JSON.stringify(obj);
                        obj1 = JSON.parse(temp);
                        g_chartList[i].data.push(obj1);
                        g_chartList[i].endPtr ++;
                        g_chartList[i].dataCurrentEntries = g_chartList[i].data.length;

                    }
                    if(bAddNewEntry || bUpdateLastEntry) 
                        g_chartList[i].data[g_chartList[i].endPtr].timestamp = g_datalogChartInfo.endTimestamp;
                
            }
        }
        if(binitial) {
            // determine if both axis used
            g_bDataLogChartUsesTwoYaxis = false;
            for(i=0; i < g_chartList.length; i++)
            {
                if((g_chartList[i].minValue >= 0) && (g_chartList[i].maxValue > 0) && (g_chartList[i].maxValue <= 1)) 
                    atleastoneY2Datapoint = true;
                else 
                    atleastoneY1Datapoint = true;
            }
            if(atleastoneY1Datapoint && atleastoneY2Datapoint) {
                g_bDataLogChartUsesTwoYaxis = true;
                g_iDatalogChartLineSelectedYaxis = 3;
            }
            else 
                g_iDatalogChartLineSelectedYaxis = 0;
        }
        determineMinMaxForChartList(1);
    }
    catch {}
}
function determineMinMaxForChartList(mode) {
        // Determine if min max values and whether one axis, or both axis are used
        //mode: 0=hidden and visible, 1= visible (show)
        // need to determine if two y-axis are needed and then based on g_iDatalogChartLineSelectedYaxis
    try {
        var i;
        
        g_datalogChartInfo.startTimestamp = null;
        g_datalogChartInfo.endTimestamp = null;
        g_datalogChartInfo.minValue = null;
        g_datalogChartInfo.maxValue = null;
        g_datalogChartInfo.minValue2nd = null;
        g_datalogChartInfo.maxValue2nd = null;
        ivChartNeedTwoYaxis = false;
        g_datalogChartInfo.datapointsOnY1 = 0;
        g_datalogChartInfo.datapointsOnY2 = 0;
        for(i=0; i < g_chartList.length; i++)
        {
            if((mode == 0) || ((mode == 1) && g_chartList[i].show)) {
                if(g_datalogChartInfo.startTimestamp == null) {
                    g_datalogChartInfo.startTimestamp = g_chartList[i].startTimestamp;
                    g_datalogChartInfo.endTimestamp = g_chartList[i].endTimestamp;
                }
                else {
                    if(g_datalogChartInfo.startTimestamp > g_chartList[i].startTimestamp)
                        g_datalogChartInfo.startTimestamp = g_chartList[i].startTimestamp;
                    if(g_datalogChartInfo.endTimestamp < g_chartList[i].endTimestamp)
                        g_datalogChartInfo.endTimestamp = g_chartList[i].endTimestamp;
                }
                if(g_chartList[i].isEnum)
                    g_datalogChartInfo.datapointsWithEnum ++;
                if(g_iDatalogChartLineSelectedYaxis > 0) { //(ivChartAllowTwoYaxis) {
                    if(((g_iDatalogChartLineSelectedYaxis == 2) || (g_iDatalogChartLineSelectedYaxis == 3)) 
                        && (g_chartList[i].minValue >= 0) && (g_chartList[i].maxValue > 0) && (g_chartList[i].maxValue <= 1)) {
                        //ivChartAllowTwoYaxis = true;
                        //ivChartUseTwoYaxis = false;
                        if(g_datalogChartInfo.minValue2nd == null) {
                            g_datalogChartInfo.minValue2nd = g_chartList[i].minValue;
                            g_datalogChartInfo.maxValue2nd = g_chartList[i].maxValue;
                        }
                        else {
                            if(g_datalogChartInfo.minValue2nd > g_chartList[i].minValue)
                                g_datalogChartInfo.minValue2nd = g_chartList[i].minValue;
                            if(g_datalogChartInfo.maxValue2nd < g_chartList[i].maxValue)
                                g_datalogChartInfo.maxValue2nd = g_chartList[i].maxValue;
                        }
                        g_datalogChartInfo.datapointsOnY2 ++;
                    }
                    else {
                        if(g_iDatalogChartLineSelectedYaxis != 2) {
                            if(g_datalogChartInfo.minValue == null) {
                                g_datalogChartInfo.minValue = g_chartList[i].minValue;
                                g_datalogChartInfo.maxValue = g_chartList[i].maxValue;
                            }
                            else {
                                if(g_datalogChartInfo.minValue > g_chartList[i].minValue)
                                    g_datalogChartInfo.minValue = g_chartList[i].minValue;
                                if(g_datalogChartInfo.maxValue < g_chartList[i].maxValue)
                                    g_datalogChartInfo.maxValue = g_chartList[i].maxValue;
                            }
                            g_datalogChartInfo.datapointsOnY1++;
                        }
                    }
                }
                else {
                    if(g_datalogChartInfo.minValue == null) {
                        g_datalogChartInfo.minValue = g_chartList[i].minValue;
                        g_datalogChartInfo.maxValue = g_chartList[i].maxValue;
                    }
                    else {
                        if(g_datalogChartInfo.minValue > g_chartList[i].minValue)
                            g_datalogChartInfo.minValue = g_chartList[i].minValue;
                        if(g_datalogChartInfo.maxValue < g_chartList[i].maxValue)
                            g_datalogChartInfo.maxValue = g_chartList[i].maxValue;
                    }
                }
                
            }
        }
        if((g_datalogChartInfo.datapointsOnY1 > 0) && (g_datalogChartInfo.datapointsOnY2 > 0))
            g_datalogChartInfo.bNeedTwoYaxis = true;
       

        
        
        if((g_datalogChartInfo.minValue2nd != null) && (g_datalogChartInfo.maxValue2nd != null)) {
            if((g_datalogChartInfo.minValue != null) && (g_datalogChartInfo.maxValue != null)) {
                ivChartNeedTwoYaxis = true;
                for(i=0; i < g_chartList.length; i++)
                {
                    if((mode == 0) || ((mode == 1) && g_chartList[i].show)) {
                        if((g_chartList[i].minValue >= 0) && (g_chartList[i].maxValue > 0) && (g_chartList[i].maxValue <= 1)) {
                            g_chartList[i].yAxis = 2;
                        }
                        else 
                            g_chartList[i].yAxis = 1;
                    }
                }
            }
            else { // only Y2 used
                ivChartNeedTwoYaxis = false;
                for(i=0; i < g_chartList.length; i++)
                {
                    g_chartList[i].yAxis = 2;
                    
                }
                //g_datalogChartInfo.minValue =  g_datalogChartInfo.minValue2nd;
                //g_datalogChartInfo.maxValue = g_datalogChartInfo.maxValue2nd;
            }
        }
        else { // only Y1 used
            ivChartNeedTwoYaxis = false;
            for(i=0; i < g_chartList.length; i++)
            {
                g_chartList[i].yAxis = 1;
                
            }
            //g_datalogChartInfo.minValue =  g_datalogChartInfo.minValue2nd;
            //g_datalogChartInfo.maxValue = g_datalogChartInfo.maxValue2nd;
        }
        if((g_datalogChartInfo.maxValue !== null)  && (g_datalogChartInfo.minValue !== null)) {
            g_datalogChartInfo.maxValue = calculatechartMaxValue(g_datalogChartInfo.maxValue);
            if(g_bDatalogChartYMinMax)
                g_datalogChartInfo.minValue = calculatechartMinValue(g_datalogChartInfo.minValue);
        }
        if(ivChartNeedTwoYaxis) {
            if((g_datalogChartInfo.maxValue2nd !== null) && (g_datalogChartInfo.minValue2nd !== null)) {
                g_datalogChartInfo.maxValue2nd = calculatechartMaxValue(g_datalogChartInfo.maxValue2nd);
                if(g_bDatalogChartYMinMax)
                    g_datalogChartInfo.minValue2nd = calculatechartMinValue(g_datalogChartInfo.minValue2nd);
            }
        }
    }
    catch {}
}
function determineMinMaxForZoomChartList(mode) {
    // Determine if min max values and whether one axis, or both axis are used
    //mode: 0=hidden and visible, 1= visible (show)
    // need to determine if two y-axis are needed and then based on g_iDatalogChartLineSelectedYaxis
try {
    var i;
    
    g_datalogChartInfo.zoomStartTimestamp = null;
    g_datalogChartInfo.zoomEndTimestamp = null;
    
    g_datalogChartInfo.zoomMinValue = null;
    g_datalogChartInfo.zoomMaxValue = null;
    g_datalogChartInfo.zoomMinValue2nd = null;
    g_datalogChartInfo.zoomMaxValue2nd = null;
    ivChartNeedTwoYaxis = false;
    g_datalogChartInfo.zoomDatapointsOnY1 = 0;
    g_datalogChartInfo.zoomDatapointsOnY2 = 0;
    for(i=0; i < g_zoomChartList.length; i++)
    {
        if(g_zoomChartList[i].data.length > 0) {
            if((mode == 0) || ((mode == 1) && g_zoomChartList[i].show)) {
                if(g_datalogChartInfo.zoomStartTimestamp == null) {
                    g_datalogChartInfo.zoomStartTimestamp = g_zoomChartList[i].startTimestamp;
                    g_datalogChartInfo.zoomEndTimestamp = g_zoomChartList[i].endTimestamp;
                }
                else {
                    if(g_datalogChartInfo.startTimestamp > g_zoomChartList[i].startTimestamp)
                        g_datalogChartInfo.startTimestamp = g_zoomChartList[i].startTimestamp;
                    if(g_datalogChartInfo.endTimestamp < g_zoomChartList[i].endTimestamp)
                        g_datalogChartInfo.endTimestamp = g_zoomChartList[i].endTimestamp;
                }
                if(g_zoomChartList[i].isEnum)
                    g_datalogChartInfo.zoomDatapointsWithEnum ++;
                if(g_iDatalogChartLineSelectedYaxis > 0) { //(ivChartAllowTwoYaxis) {
                    if(((g_iDatalogChartLineSelectedYaxis == 2) || (g_iDatalogChartLineSelectedYaxis == 3)) 
                        && (g_zoomChartList[i].minValue >= 0) && (g_zoomChartList[i].maxValue > 0) && (g_zoomChartList[i].maxValue <= 1)) {
                        //ivChartAllowTwoYaxis = true;
                        //ivChartUseTwoYaxis = false;
                        if(g_datalogChartInfo.zoomMinValue2nd == null) {
                            g_datalogChartInfo.zoomMinValue2nd = g_zoomChartList[i].minValue;
                            g_datalogChartInfo.zoomMaxValue2nd = g_zoomChartList[i].maxValue;
                        }
                        else {
                            if(g_datalogChartInfo.zoomMinValue2nd > g_zoomChartList[i].minValue)
                                g_datalogChartInfo.zoomMinValue2nd = g_zoomChartList[i].minValue;
                            if(g_datalogChartInfo.zoomMaxValue2nd < g_zoomChartList[i].maxValue)
                                g_datalogChartInfo.zoomMaxValue2nd = g_zoomChartList[i].maxValue;
                        }
                        g_datalogChartInfo.zoomDatapointsOnY2 ++;
                    }
                    else {
                        if(g_iDatalogChartLineSelectedYaxis != 2) {
                            if(g_datalogChartInfo.zoomMinValue == null) {
                                g_datalogChartInfo.zoomMinValue = g_zoomChartList[i].minValue;
                                g_datalogChartInfo.zoomMaxValue = g_zoomChartList[i].maxValue;
                            }
                            else {
                                if(g_datalogChartInfo.zoomMinValue > g_zoomChartList[i].minValue)
                                    g_datalogChartInfo.zoomMinValue = g_zoomChartList[i].minValue;
                                if(g_datalogChartInfo.zoomMaxValue < g_zoomChartList[i].maxValue)
                                    g_datalogChartInfo.zoomMaxValue = g_zoomChartList[i].maxValue;
                            }
                            g_datalogChartInfo.zoomDatapointsOnY1++;
                        }
                    }
                }
                else {
                    if(g_datalogChartInfo.zoomMinValue == null) {
                        g_datalogChartInfo.zoomMinValue = g_zoomChartList[i].minValue;
                        g_datalogChartInfo.zoomMaxValue = g_zoomChartList[i].maxValue;
                    }
                    else {
                        if(g_datalogChartInfo.zoomMinValue > g_zoomChartList[i].minValue)
                            g_datalogChartInfo.zoomMinValue = g_zoomChartList[i].minValue;
                        if(g_datalogChartInfo.zoomMaxValue < g_zoomChartList[i].maxValue)
                            g_datalogChartInfo.zoomMaxValue = g_zoomChartList[i].maxValue;
                    }
                }
                
            }
        }
    }
    if((g_datalogChartInfo.zoomDatapointsOnY1 > 0) && (g_datalogChartInfo.zoomDatapointsOnY2 > 0))
        g_datalogChartInfo.bNeedTwoYaxis = true;
   

    
    
    if((g_datalogChartInfo.zoomMinValue2nd != null) && (g_datalogChartInfo.zoomMaxValue2nd != null)) {
        if((g_datalogChartInfo.zoomMinValue != null) && (g_datalogChartInfo.zoomMaxValue != null)) {
            ivChartNeedTwoYaxis = true;
            for(i=0; i < g_zoomChartList.length; i++)
            {
                if((mode == 0) || ((mode == 1) && g_zoomChartList[i].show)) {
                    if((g_zoomChartList[i].minValue >= 0) && (g_zoomChartList[i].maxValue > 0) && (g_zoomChartList[i].maxValue <= 1)) {
                        g_zoomChartList[i].yAxis = 2;
                    }
                    else 
                        g_zoomChartList[i].yAxis = 1;
                }
            }
        }
        else { // only Y2 used
            ivChartNeedTwoYaxis = false;
            for(i=0; i < g_zoomChartList.length; i++)
            {
                g_zoomChartList[i].yAxis = 2;
                
            }
            //g_datalogChartInfo.minValue =  g_datalogChartInfo.minValue2nd;
            //g_datalogChartInfo.maxValue = g_datalogChartInfo.maxValue2nd;
        }
    }
    else { // only Y1 used
        ivChartNeedTwoYaxis = false;
        for(i=0; i < g_zoomChartList.length; i++)
        {
            g_zoomChartList[i].yAxis = 1;
            
        }
    }
    g_datalogChartInfo.zoomMaxValue = calculatechartMaxValue(g_datalogChartInfo.zoomMaxValue);
    if(g_bDatalogChartYMinMax)
        g_datalogChartInfo.zoomMinValue = calculatechartMinValue(g_datalogChartInfo.zoomMinValue);
    if(ivChartNeedTwoYaxis) {
        g_datalogChartInfo.zoomMaxValue2nd = calculatechartMaxValue(g_datalogChartInfo.zoomMaxValue2nd);
        if(g_bDatalogChartYMinMax)
            g_datalogChartInfo.zoomMinValue2nd = calculatechartMinValue(g_datalogChartInfo.zoomMinValue2nd);
    }
}
catch {}
}
function determineMinMaxForZoomChartList_old(mode) {  //remove if new one works
    // Determine if min max values and whether one axis, or both axis are used
    //mode: 0=hidden and visible, 1= visible (show)
    // need to determine if two y-axis are needed and then based on g_iDatalogChartLineSelectedYaxis
try {
    var i;
    
    g_datalogChartInfo.zoomStartTimestamp = null;
    g_datalogChartInfo.zoomEndTimestamp = null;
    g_datalogChartInfo.zoomMinValue = null;
    g_datalogChartInfo.zoomMaxValue = null;
    g_datalogChartInfo.zoomMinValue2nd = null;
    g_datalogChartInfo.zoomMaxValue2nd = null;
    ivChartNeedTwoYaxis = false;
    g_datalogChartInfo.zoomDatapointsOnY1 = 0;
    g_datalogChartInfo.zoomDatapointsOnY2 = 0;
    for(i=0; i < g_zoomChartList.length; i++)
    {
        if(g_zoomChartList[i].data.length > 0) {
            if((mode == 0) || ((mode == 1) && g_zoomChartList[i].show)) {
                if(g_datalogChartInfo.zoomStartTimestamp == null) {
                    g_datalogChartInfo.zoomStartTimestamp = g_zoomChartList[i].startTimestamp;
                    g_datalogChartInfo.zoomEndTimestamp = g_zoomChartList[i].endTimestamp;
                }
                else {
                    if(g_datalogChartInfo.startTimestamp > g_zoomChartList[i].startTimestamp)
                        g_datalogChartInfo.startTimestamp = g_zoomChartList[i].startTimestamp;
                    if(g_datalogChartInfo.endTimestamp < g_zoomChartList[i].endTimestamp)
                        g_datalogChartInfo.endTimestamp = g_zoomChartList[i].endTimestamp;
                }
                if(g_zoomChartList[i].isEnum)
                    g_datalogChartInfo.zoomDatapointsWithEnum ++;
                if(g_iDatalogChartLineSelectedYaxis > 0) { //(ivChartAllowTwoYaxis) {
                    if(((g_iDatalogChartLineSelectedYaxis == 2) || (g_iDatalogChartLineSelectedYaxis == 3)) 
                        && (g_zoomChartList[i].minValue >= 0) && (g_zoomChartList[i].maxValue > 0) && (g_zoomChartList[i].maxValue <= 1)) {
                        //ivChartAllowTwoYaxis = true;
                        //ivChartUseTwoYaxis = false;
                        if(g_datalogChartInfo.minValue2nd == null) {
                            g_datalogChartInfo.minValue2nd = g_zoomChartList[i].minValue;
                            g_datalogChartInfo.maxValue2nd = g_zoomChartList[i].maxValue;
                        }
                        else {
                            if(g_datalogChartInfo.minValue2nd > g_zoomChartList[i].minValue)
                                g_datalogChartInfo.minValue2nd = g_zoomChartList[i].minValue;
                            if(g_datalogChartInfo.maxValue2nd < g_zoomChartList[i].maxValue)
                                g_datalogChartInfo.maxValue2nd = g_zoomChartList[i].maxValue;
                        }
                        g_datalogChartInfo.zoomDatapointsOnY2 ++;
                    }
                    else {
                        if(g_iDatalogChartLineSelectedYaxis != 2) {
                            if(g_datalogChartInfo.minValue == null) {
                                g_datalogChartInfo.minValue = g_zoomChartList[i].minValue;
                                g_datalogChartInfo.maxValue = g_zoomChartList[i].maxValue;
                            }
                            else {
                                if(g_datalogChartInfo.minValue > g_zoomChartList[i].minValue)
                                    g_datalogChartInfo.minValue = g_zoomChartList[i].minValue;
                                if(g_datalogChartInfo.maxValue < g_zoomChartList[i].maxValue)
                                    g_datalogChartInfo.maxValue = g_zoomChartList[i].maxValue;
                            }
                            g_datalogChartInfo.zoomDatapointsOnY1++;
                        }
                    }
                }
                else {
                    if(g_datalogChartInfo.zoomMinValue == null) {
                        g_datalogChartInfo.zoomMinValue = g_zoomChartList[i].minValue;
                        g_datalogChartInfo.zoomMaxValue = g_zoomChartList[i].maxValue;
                    }
                    else {
                        if(g_datalogChartInfo.zoomMinValue > g_zoomChartList[i].minValue)
                            g_datalogChartInfo.zoomMinValue = g_zoomChartList[i].minValue;
                        if(g_datalogChartInfo.zoomMaxValue < g_zoomChartList[i].maxValue)
                            g_datalogChartInfo.zoomMaxValue = g_zoomChartList[i].maxValue;
                    }
                }
                
            }
        }
    }
    if((g_datalogChartInfo.zoomDatapointsOnY1 > 0) && (g_datalogChartInfo.zoomDatapointsOnY2 > 0))
        g_datalogChartInfo.bNeedTwoYaxis = true;
   

    
    
    if((g_datalogChartInfo.minValue2nd != null) && (g_datalogChartInfo.maxValue2nd != null)) {
        if((g_datalogChartInfo.minValue != null) && (g_datalogChartInfo.maxValue != null)) {
            ivChartNeedTwoYaxis = true;
            for(i=0; i < g_zoomChartList.length; i++)
            {
                if((mode == 0) || ((mode == 1) && g_zoomChartList[i].show)) {
                    if((g_zoomChartList[i].minValue >= 0) && (g_zoomChartList[i].maxValue > 0) && (g_zoomChartList[i].maxValue <= 1)) {
                        g_zoomChartList[i].yAxis = 2;
                    }
                    else 
                        g_zoomChartList[i].yAxis = 1;
                }
            }
        }
        else {
            ivChartNeedTwoYaxis = false;
            //g_datalogChartInfo.minValue =  g_datalogChartInfo.minValue2nd;
            //g_datalogChartInfo.maxValue = g_datalogChartInfo.maxValue2nd;
        }
    }
    g_datalogChartInfo.maxValue = calculatechartMaxValue(g_datalogChartInfo.maxValue);
    if(g_bDatalogChartYMinMax)
        g_datalogChartInfo.minValue = calculatechartMinValue(g_datalogChartInfo.minValue);
    if(ivChartNeedTwoYaxis) {
        g_datalogChartInfo.maxValue2nd = calculatechartMaxValue(g_datalogChartInfo.maxValue2nd);
        if(g_bDatalogChartYMinMax)
            g_datalogChartInfo.minValue2nd = calculatechartMinValue(g_datalogChartInfo.minValue2nd);
    }
}
catch {}
}
function calculatechartMaxValue(max) {
    var result = max;
    var fvalue;
    try {
        if(max != null) {
            fvalue = parseFloat(max);
            if(fvalue < 0) 
                fvalue1 = (Math.round(fvalue / 10) + 1) * 10;
            else if(fvalue < 1) 
                fvalue1 = 1;
            else if(fvalue < 2)
                fvalue1 = 2;
            else if(fvalue < 5)
                fvalue1 = 5;
            else if(fvalue > 1) 
                fvalue1 = (Math.round(fvalue / 10) + 1) * 10;
            max = fvalue1;
        }
    }
    catch {result = max;}
    return max;
}
function calculatechartMinValue(min) {
    var result = min;
    var fvalue;
    try {
        if(min != null) {
            fvalue = parseFloat(min);
            if(fvalue < 0) 
                fvalue1 = (Math.round(fvalue / 10) - 1) * 10;
            else if(fvalue < 1) 
                fvalue1 = 0;
            else if(fvalue < 5)
                fvalue1 = 0;
            else if(fvalue > 1) 
                fvalue1 = (Math.round(fvalue / 10) - 1) * 10;
            min = fvalue1;
        }
    }
    catch {result = min;}
    return min;
}
function createChartObjectLargeChartFieldLines(mode, index, displayId, pathName, pathNameUI, valueList) {
    // multiline field support
    // mode: 0= current end date, 1= has end date
    // create one chart entry per datapoint field
    try {
        var fvalue, fvalue1;
        var chart = {};
        var polygoncolor, show = true;
        var lineNumber = 0, lineName,dpValue, value, valueStr;
        var obj, obj1;
        var i, iCount = 0, z = -1, j, k, field, z;
        var color;
        var ptr,lineObj;
        var charts = []; // one obj for each scalar field
        var temp, baddToChart, bAddToChartData = true;
        if(valueList == null)
            return;
        if(valueList.length == null)
            return;
        // determine fields
        temp = valueList[0].locValue;
        for(field in temp) 
        {
            baddToChart = false;
            if(typeof temp[field] === "number") 
                baddToChart = true;
            else if(typeof temp[field] === "string") {
                if(temp[field].indexOf(" ") == -1)
                    baddToChart = true; // enums don't have spaces
            }
            else if(typeof temp[field] === "boolean") {
                baddToChart = true; // enums don't have spaces
            }
            if(baddToChart)
            {
                chart = {};
                chart.startPtr = 0;
                chart.endPtr = 0;
                chart.pathName = pathName;
                chart.pathNameUI = pathNameUI;
                chart.field = field;
                chart.dashboardDpIndex = index;
                chart.displayId = displayId;
                chart.data = [];
                chart.dataCurrentEntries = 1; //iottest
                chart.hasNegativeNumbers = false; //dataLogDpList[index].hasNegativeNumbers; 
                chart.show = true; // controlled by chart.display and g_iDatalogChartLineSelectedYaxis
                chart.display = true; // controlled by checkbox
                chart.yAxis = 1;
                
                color = "blue";
                lineName = "";
                chart.creatChartLine = false;
                z = -1;
                for(i=0; i < g_chartLineList.length; i ++) 
                {
                    if((g_chartLineList[i].pathName == pathName) && (g_chartLineList[i].field == field)){
                        lineName = g_chartLineList[i].lineName;
                        color = g_chartLineList[i].color;
                        show = g_chartLineList[i].show;
                        z = i;
                        break;
                    }
                }
                if(z == -1) {
                    lineNumber = g_chartLineList.length + 1;
                    lineName = "polyline" + lineNumber;
                    if(lineNumber != 1)  { // line number 1 is there by default
                        // may need to add code to check if line is already created
                        ivChartLineColorsIndex ++;
                        if(ivChartLineColorsIndex >= ivChartLineColors.length)
                            ivChartLineColorsIndex = 0;
                        color = ivChartLineColors[ivChartLineColorsIndex];
                        chart.creatChartLine = true; //ivCreateNewPolyline(displayId, lineName, color, 5);
                    }
                    lineObj = {};
                    lineObj.lineName = lineName;
                    lineObj.color = color;
                    lineObj.pathName = pathName;
                    lineObj.field = field;
                    lineObj.show = true;
                    g_chartLineList.push(lineObj);  // not sure this is needed
                    z = g_chartLineList.length - 1;
                }
                chart.lineColorIndex = z;
                chart.lineName = lineName; //"polyline" + lineNumber;
                chart.color = color;
                chart.show = show;
                chart.isEnum = false;
                chart.isBoolean = false;
                if(typeof temp[field] === "boolean")
                    chart.isBoolean = true;

                charts.push(chart);
            }
        }
        //chart.fields = [];
        if(valueList != null) {
            ptr = valueList.length;
            for(i=0; i < valueList.length; i++)
            {
                ptr --;
                dpValue = valueList[i].locValue;
                dpValue1 = valueList[i].value;
                for(k=0; k < charts.length; k++)
                { // individual fields
                        
                    bAddToChartData = true;

                    value = dpValue[charts[k].field];
                    valuestr = "";
                    if(charts[k].isEnum) {
                        valueStr = value;
                        value = determineEnumValue(value);
                    }
                    else if(chart.isBoolean) {
                        valuestr = value;
                        if(value)
                            value = 1;
                        else 
                            value = 0;
                    }
                    // only add to chart.data if value is different from previous value, if same value then change timestamp - this will greatly reduce number of datapoints to chart
                    if(i > 2) {
                        //if(valueList[ptr].value == chart.data[chart.data.length - 1].value) {
                        if(value == charts[k].data[0].value) {
                            if(value == charts[k].data[1].value) {  //used to show start and end times of group of updates with same value
                                charts[k].data[0].timestamp = valueList[i].timestamp; // don't use
                                bAddToChartData = false;
                            }
                        }
                        
                    }
                    if(bAddToChartData) {
                        if(i==0) {
                            charts[k].maxValue = value;
                            charts[k].minValue = value;
                        }
                        else {
                            if(value > charts[k].maxValue)
                                charts[k].maxValue = value;
                            if(value < charts[k].minValue)
                                charts[k].minValue = value;
                        }
                        if(value < 0)
                            charts[k].hasNegativeNumbers = true;
                        obj = {};
                        obj1 = {};
                        obj = valueList[i];
                        temp = JSON.stringify(obj);
                        obj1 = JSON.parse(temp);
                        obj1.locValue = value;
                        obj1.locValueStr = value;
                        obj1.value = dpValue1[charts[k].field];
                        obj1.valueStr = obj1.value;
                        if(charts[k].isEnum) {
                            obj1.locValueStr = valueStr;
                        }

                        charts[k].data.unshift(obj1);
                    }
                    
                }
                for(k=0; k < charts.length; k++)
                {
                    
                    if(charts[k].data.length > ivChartTotalEntriesLargeChart) {
                        i = valueList.length + 10; //done
                        break;
                    }
                }
            }
            
        }
        for(k=0; k < charts.length; k++)
        {
            charts[k].endPtr = charts[k].data.length - 1;
            charts[k].dataCurrentEntries = charts[k].data.length;
            charts[k].startTimestamp = charts[k].data[0].timestamp;
            charts[k].endTimestamp = charts[k].data[charts[k].data.length - 1].timestamp;
            g_chartList.push(charts[k]);
        }
    }
    catch {}
}
function createChartObjectLargeChartLine(mode, index, displayId, pathName, pathNameUI, field, valueList) {
    // multiline field support
    // mode: 0= current end date, 1= has end date
    // create one chart entry per datapoint field
    try {
        var fvalue, fvalue1;
        var chart = {};
        var polygoncolor, show = true, display = true;
        var lineNumber = 0, lineName, value, valuestr = "";
        var obj, obj1;
        var i, iCount = 0, z = -1;
        var color;
        var ptr,lineObj;
        var temp, bAddToChartData = true;
        if(valueList == null)
            return;
        if(valueList.length == null)
            return;
        
        chart = {};
        chart.startPtr = 0;
        chart.endPtr = 0;
        chart.pathName = pathName;
        chart.pathNameUI = pathNameUI;
        chart.field = field;
        chart.dashboardDpIndex = index;
        chart.displayId = displayId;
        chart.data = [];
        chart.dataCurrentEntries = 1; //iottest
        chart.hasNegativeNumbers = false; //dataLogDpList[index].hasNegativeNumbers; 
        chart.show = true; // controlled by chart.display and g_iDatalogChartLineSelectedYaxis
        chart.display = true; // controlled by checkbox
        chart.yAxis = 1;
        
        color = "blue";
        lineName = "";
        chart.creatChartLine = false;
        for(i=0; i < g_chartLineList.length; i ++) 
        {
            if((g_chartLineList[i].pathName == pathName) && (g_chartLineList[i].field == field)){
                lineName = g_chartLineList[i].lineName;
                color = g_chartLineList[i].color;
                show = g_chartLineList[i].show; // legend checkbox
                display = show;
                z = i;
                break;
            }
        }
        if(z == -1) {
            lineNumber = g_chartLineList.length + 1;
            lineName = "polyline" + lineNumber;
            if(lineNumber != 1)  { // line number 1 is there by default
                // may need to add code to check if line is already created
                ivChartLineColorsIndex ++;
                if(ivChartLineColorsIndex >= ivChartLineColors.length)
                    ivChartLineColorsIndex = 0;
                color = ivChartLineColors[ivChartLineColorsIndex];
                chart.creatChartLine = true; //ivCreateNewPolyline(displayId, lineName, color, 5);
            }
            lineObj = {};
            lineObj.lineName = lineName;
            lineObj.color = color;
            lineObj.pathName = pathName;
            lineObj.field = field;
            lineObj.show = true;  // legend checkbox
            g_chartLineList.push(lineObj);  // not sure this is needed
            z = g_chartLineList.length - 1;
        }
        chart.lineColorIndex = z;
        chart.lineName = lineName; //"polyline" + lineNumber;
        chart.color = color;
        chart.show = show;
        chart.display = display; //checkbox
        chart.isEnum = false;
        chart.isBoolean = false;
        //chart.fields = [];
        if(valueList != null) {
            ptr = valueList.length;
            if(typeof valueList[0].value === "string") {
                // make sure no spaces, if spaces then not an enum
                if(valueList[0].value.indexOf(" ") != -1)
                    return; // not an enum
                else    
                    chart.isEnum = true;
            }
            else if(typeof valueList[0].value === "boolean") {
                // make sure no spaces, if spaces then not an enum
                    chart.isBoolean = true;
            }
            for(i=0; i < valueList.length; i++)
            {
                ptr --;
                bAddToChartData = true;
                valuestr = "";
                value = valueList[i].value;
                if(chart.isEnum) {
                    valuestr = value;
                    value = determineEnumValue(value);
                }
                else if(chart.isBoolean) {
                    valuestr = value;
                    if(value)
                        value = 1;
                    else 
                        value = 0;
                }
                // only add to chart.data if value is different from previous value, if same value then change timestamp - this will greatly reduce number of datapoints to chart
                if(i > 2) {
                    //if(valueList[ptr].value == chart.data[chart.data.length - 1].value) {
                    if(value == chart.data[0].value) {  //data is added to beginning of que so use data index 0
                        if(value == chart.data[1].value) {  //used to show start and end times of group of updates with same value
                            chart.data[0].timestamp = valueList[i].timestamp; // don't use
                            bAddToChartData = false;
                        }
                    }
                }
                if(bAddToChartData) {
                    if(i==0) {
                        chart.maxValue = value;
                        chart.minValue = value;
                    }
                    else {
                        if(value > chart.maxValue)
                            chart.maxValue = value;
                        if(value < chart.minValue)
                            chart.minValue = value;
                    }
                    if(value < 0)
                        chart.hasNegativeNumbers = true;
                    iCount ++;
                    obj = {};
                    obj1 = {};
                    obj = valueList[i];
                    temp = JSON.stringify(obj);
                    obj1 = JSON.parse(temp);
                    if(valueStr != "")
                        obj1.enum = valueStr;
                    chart.data.unshift(obj1);
                }
                //chart.data.push(JSON.parse(Json.stringify(valueList[ptr -  i])));
                if(iCount > ivChartTotalEntriesLargeChart)
                    break;
            }
            //if(mode == 0)
                //chart.data.push(JSON.parse(Json.stringify(valueList[ptr -  i]))); // repeat last line 
        }
        
        chart.endPtr = chart.data.length - 1;
        chart.dataCurrentEntries = chart.data.length;
        chart.startTimestamp = chart.data[0].timestamp;
        chart.endTimestamp = chart.data[chart.data.length - 1].timestamp;
        g_chartList.push(chart);
        
    }
    catch {}
}
function datalogChartAddEventListener(displayId) {
    var svgObj, svgDoc;
    g_datalogDisplayId = displayId;
    if(navigator.userAgent.match(/Chrome/))	
    {		
        svgObj = document.getElementById(displayId);
        svgDoc = svgObj.contentDocument;
    }
    else
        svgDoc = document.getElementById(displayId).getSVGDocument();
    g_datalogSvgDoc = svgDoc;
    
    //svgDoc.addEventListener("mousemove",dataLogChartMouseMove); // when using mouse down can't use mousemove and doubleclick
    //svgDoc.addEventListener("dblclick",dataLogChartMouseDoubleClick);  // to zoom all the way out
    svgDoc.addEventListener("mousedown",dataLogChartMouseDown);
    svgDoc.addEventListener("mouseup",dataLogChartMouseUp);
    
   // svgDoc.addEventListener("mouseout",dataLogChartMouseOut);
    
    //svgChartRectangle.addEventListener("mousemove",dataLogChartMouseMove);
    //g_datalogSvgDoc = svgChartRectangle;
}
function datalogChartDisplayValue(eClientX, eClientY) {
    // Need to add enums zzzzzzzzzz
    var svgObj, svgDoc, svgChartRectangle;
    var str = "", value;
    var d, time, dates, timestamp = 0;
    var chartList = [];
    var startPtr; //= g_chartList[0].startPtr;
    var endPtr; //= g_chartList[0].endPtr;
    var startTimestampMicroSec; //= g_chartList[0].data[startPtr].timestamp;
    var endTimestampMicroSec; //= g_chartList[0].data[endPtr].timestamp;
    var xRange; //= endTimestampMicroSec - startTimestampMicroSec; // MicroSec
    var range, rangeY2; //= g_chartList[0].maxValue - g_chartList[0].minValue;
    var min, max, minY2, maxY2;

    if(g_bDatalogChartZoomInProgress) {
        if(g_zoomChartList == null) 
            return;
        if(g_zoomChartList.length == 0)
            return; 
        chartList = g_zoomChartList;
        if(g_iDatalogChartLineSelectedYaxis != 2) {
            min = g_datalogChartInfo.zoomMinValue;
            max = g_datalogChartInfo.zoomMaxValue;
            
        }
        if((g_iDatalogChartLineSelectedYaxis == 2) || (g_iDatalogChartLineSelectedYaxis == 3)) {
            minY2 = g_datalogChartInfo.zoomMinValue2nd;
            maxY2 = g_datalogChartInfo.zoomMaxValue2nd;
        }
        startTimestampMicroSec = g_datalogChartInfo.zoomStartTimestamp; //chartList[0].data[startPtr].timestamp;
        endTimestampMicroSec = g_datalogChartInfo.zoomEndTimestamp;//chartList[0].data[endPtr].timestamp;
    }
    else {
        if(g_chartList == null) 
            return;
        if(g_chartList.length == 0)
            return;
        chartList = g_chartList;
        if(g_iDatalogChartLineSelectedYaxis != 2) {
            min = g_datalogChartInfo.minValue;
            max = g_datalogChartInfo.maxValue;
           
        }
        if((g_iDatalogChartLineSelectedYaxis == 2) || (g_iDatalogChartLineSelectedYaxis == 3)) {
            minY2 = g_datalogChartInfo.minValue2nd;
            maxY2 = g_datalogChartInfo.maxValue2nd;
            
        }
        startTimestampMicroSec = g_datalogChartInfo.startTimestamp;
        endTimestampMicroSec = g_datalogChartInfo.endTimestamp;
    }
    
    xRange = endTimestampMicroSec - startTimestampMicroSec; // MicroSec

    if(navigator.userAgent.match(/Chrome/))	
    {		
        svgObj = document.getElementById(g_datalogDisplayId);
        svgDoc = svgObj.contentDocument;
    }
    else
        svgDoc = document.getElementById(g_datalogDisplayId).getSVGDocument();
    svgChartRectangle = svgDoc.getElementById("rect1");
    //svgP = svgPoint(svgChartRectangle, e.clientX, e.clientY);
    svgP = svgPoint(svgChartRectangle, eClientX, eClientY);
    if(svgP != null) {
        if((svgP.x >= 0) && (svgP.y >= 0)) {
            //str = "Display [" + e.clientX + ", " + e.clientY + "] = SVG Coordinates [" + svgP.x + ", " + svgP.y + "], value";
            if(g_iDatalogChartLineSelectedYaxis != 2) {
                if((min != null) && (max != null)) {
                    range = max - min;
                    value = (svgP.x / ivChartYLengthLargeChart) * range;
                    value += min;
                    str += "[";
                    if(minY2 != null)
                        str += "Y1: ";
                    if(min > 10)
                        str += value.toFixed(0);
                    else if(max > 50)
                        str += value.toFixed(0);
                    else if(max >= 1)
                        str += value.toFixed(1);
                    else if(min > 1)
                        str += value.toFixed(1);
                    else
                        str += value;
                }
            }
            if((g_iDatalogChartLineSelectedYaxis == 2) || (g_iDatalogChartLineSelectedYaxis == 3)) {
                if((minY2 != null) && (maxY2 != null)) {
                    min = minY2;
                    max = maxY2;
                    rangeY2 = maxY2 - minY2;
                    value = (svgP.x / ivChartYLengthLargeChart) * rangeY2;
                    value += min;
                    if(str == "")
                        str += "[";
                    else 
                        str += ", Y2: ";
                    if(min > 10)
                        str += value.toFixed(0);
                    else if(max > 50)
                        str += value.toFixed(0);
                    else if(max >= 1)
                        str += value.toFixed(1);
                    else if(min > 1)
                        str += value.toFixed(1);
                    else
                        str += value;
                }
            }
            str += ", ";
            
            timestamp = (svgP.y / ivChartXLengthLargeChart) * xRange;
            timestamp += startTimestampMicroSec;
            d = new Date();
            d.setTime(timestamp);
            time = d.toLocaleTimeString();
            //dates = d.toLocaleDateString().split("/");
            
            //str += dates[2] + "-" +  ivPadStart(dates[0], "0", 2) + "-" +  ivPadStart(dates[1], "0", 2) + " " + time + "]";
            str += d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " " + time + "]";
            document.getElementById("mouseInfoLabel").innerHTML = str;   
            //svgDoc.getElementById("tspanX4").textContent = str; // + "   " + lineInfo;
        }
    }
}
function datalogChartDisplayValue1() {
    g_mouseClickTimerVar = null;
    datalogChartDisplayValue(g_datalogChartInfo.mouseDownX1, g_datalogChartInfo.mouseDownY1);
    g_datalogChartInfo.mouseDownX1 = null;
    g_datalogChartInfo.mouseDownY1 = null;
}
function dataLogChartMouseMove(e) {
    //if(!g_bMouseDown)
    //    datalogChartDisplayValue(e.clientX, e.clientY);
}
function dataLogChartMouseDown(e) {
    g_datalogChartInfo.mouseDownX1 = e.clientX; // window coordinates used for zoom start of window
    g_datalogChartInfo.mouseDownY1 = e.clientY;
    g_bMouseDown = true;
}
function dataLogChartMouseUp(e) {
    if((g_datalogChartInfo.mouseDownX1 == null) || (g_datalogChartInfo.mouseDownY1 == null))
        return;
    g_bMouseDown = false;
    if((Math.abs(e.clientX - g_datalogChartInfo.mouseDownX1) < 10) && (Math.abs(e.clientY - g_datalogChartInfo.mouseDownY1) < 10)) {
        if(g_mouseClickTimerVar != null) {
            // doubleclick
            clearTimeout(g_mouseClickTimerVar);
            g_mouseClickTimerVar = null;
            g_bDatalogChartZoomInProgress = false;
            g_bMouseDown = false;
            g_datalogChartInfo.mouseDownX1 = null;
            g_datalogChartInfo.mouseDownY1 = null;
            g_datalogChartInfo.zoomMinValue = null;
            g_datalogChartInfo.zoomMaxValue = null;
            g_datalogChartInfo.zoomMinValue2nd = null; //yAxis2
            g_datalogChartInfo.zoomMaxValue2nd = null; //yaxis2
            g_datalogChartInfo.zoomStartTimestamp = null;
            g_datalogChartInfo.zoomEndTimestamp = null;
            document.getElementById("mouseInfoLabel").innerHTML = "";
            datalogChartUpdate(1);
        }
        else // maybe single click or doubleclick -- single click go to function below.
            g_mouseClickTimerVar = setTimeout(function() {datalogChartDisplayValue1()}, 500);
        
    }
    else {
        g_datalogChartInfo.mouseDownX2 = e.clientX; // window coordinates used for zoom start of window
        g_datalogChartInfo.mouseDownY2 = e.clientY;
        datalogChartZoomIntialize();
        
        
        
    }
}
function dataLogChartMouseOut(e) {
    g_datalogChartInfo.mouseDownX1 = null;
    g_datalogChartInfo.mouseDownY1 = null;
    g_bMouseDown = false;
}
function dataLogChartMouseDoubleClick(e) {
    g_bDatalogChartZoomInProgress = false;
    g_bMouseDown = false;
    g_datalogChartInfo.mouseDownX1 = null;
    g_datalogChartInfo.mouseDownY1 = null;
    ivInitializeChart("dataLogChartSvg", g_datalogChartInfo.minValue, g_datalogChartInfo.maxValue, null, null, "white", null, "both");
	ivUpdateChartsDatalog(g_datalogChartInfo.displayId, "", g_iDatalogChartLineType, 0, g_chartList, null, g_datalogChartInfo.minValue, g_datalogChartInfo.maxValue,
        g_datalogChartInfo.startTimestamp, g_datalogChartInfo.endTimeStamp);
}
function datalogChartZoomIntialize() {
    try {
        var chartList = [];
        var min = 0, max = 0, bSetMinMax = true, startTimestamp, endTimestamp, i, z, fvalue, startIndex = -1, endIndex = -1, show, xRange, str = "", k;
        var  pathName = "", field = "";
        var x1 = g_datalogChartInfo.mouseDownX1; // window coordinates used for zoom start of window
        var y1 = g_datalogChartInfo.mouseDownY1;
        var x2 = g_datalogChartInfo.mouseDownX2; // window coordinates used for zoom start of window
        var y2 = g_datalogChartInfo.mouseDownY2;
        var svgPstart, svgPend, newStartTime, newEndTime, startLocalTime, endLocalTime;

        g_datalogChartInfo.mouseDownX1 = null; // window coordinates used for zoom start of window
        g_datalogChartInfo.mouseDownY1 = null;
        g_datalogChartInfo.mouseDownX2 = null; // window coordinates used for zoom start of window
        g_datalogChartInfo.mouseDownY2 = null;
        g_datalogChartInfo.zoomDatapointsOnY1 = 0; // zzzzzzzz add y1 and y2 count, add count  chart.yAxis
        g_datalogChartInfo.zoomDatapointsOnY2 = 0;  // datapoint value must be between 0 and 1.
        g_datalogChartInfo.zoomDatapointsWithEnum = 0; 

        if(navigator.userAgent.match(/Chrome/))	
        {		
            svgObj = document.getElementById(g_datalogDisplayId);
            svgDoc = svgObj.contentDocument;
        }
        else
            svgDoc = document.getElementById(g_datalogDisplayId).getSVGDocument();
        svgChartRectangle = svgDoc.getElementById("rect1");
        //svgP = svgPoint(svgChartRectangle, e.clientX, e.clientY);
        svgPstart = svgPoint(svgChartRectangle, x1, y1); // zoom window
        svgPend = svgPoint(svgChartRectangle, x2, y2);

        // convert new times to location, later convert to timestamps
        if(svgPstart.y < svgPend.y) {
            // left to right
            newStartTime = svgPstart.y; // y is horizontal and x is vertical
            newEndTime = svgPend.y;
        }
        else {
            // right to left
            newStartTime = svgPend.y;
            newEndTime = svgPstart.y;
        }

        // determine current min max values  zoom window
        if(g_bDatalogChartZoomInProgress) {
            // this is a zoom of a zoom
            chartList = JSON.parse(JSON.stringify(g_zoomChartList));
            min = g_datalogChartInfo.zoomMinValue;
            max = g_datalogChartInfo.zoomMaxValue
            startTimestamp = g_datalogChartInfo.zoomStartTimestamp;
            endTimestamp = g_datalogChartInfo.zoomEndTimestamp;
            
        }
        else {
            chartList = JSON.parse(JSON.stringify(g_chartList));
            
            min = g_datalogChartInfo.minValue;
            max = g_datalogChartInfo.maxValue
            startTimestamp = g_datalogChartInfo.startTimestamp;
            endTimestamp = g_datalogChartInfo.endTimestamp;
        }
        // convert new times to timestamps
        var xRange = endTimestamp - startTimestamp; // MicroSec
        newStartTime = (newStartTime / ivChartXLengthLargeChart) * xRange;
        newStartTime += startTimestamp;
        newEndTime = (newEndTime / ivChartXLengthLargeChart) * xRange;
        newEndTime += startTimestamp;

        d = new Date();
        d.setTime(startTimestamp);
        str = d.toLocaleTimeString() + " " + d.toLocaleDateString();
        d.setTime(endTimestamp);
        str += " thru " + d.toLocaleTimeString() + " " + d.toLocaleDateString() + " ";
        d.setTime(newStartTime);
        startLocalTime = d.toLocaleTimeString() + " " + d.toLocaleDateString();
        d.setTime(newEndTime);
        endLocalTime = d.toLocaleTimeString() + " " + d.toLocaleDateString();
        document.getElementById("mouseInfoLabel").innerHTML = "[zoom window: " + startLocalTime + " - " + endLocalTime + "]";
        //document.getElementById("mouseInfoLabel").innerHTML = str + "[zoom window: " + startLocalTime + " - " + endLocalTime + "]";
        //svgDoc.getElementById("tspanX4").textContent = str + "[zoom window: " + startLocalTime + " - " + endLocalTime + "]";

        g_zoomChartList = [];
        // currently only care about timestamps, add zoom on min max later
        for(k=0; k < chartList.length; k++) 
        {
            if(chartList[k].data.length > 0) {
                startIndex = -1;
                endIndex = -1;
                g_zoomChartList[k] = {};
                g_zoomChartList[k].data = [];
                g_zoomChartList[k].creatChartLine = false;
                g_zoomChartList[k].show = false;
                g_zoomChartList[k].startPtr = -1;
                g_zoomChartList[k].endPtr = -1;
                g_zoomChartList[k].dataCurrentEntries = 0;
                pathName = chartList[k].pathName;
                field = chartList[k].field;
                g_zoomChartList[k].pathName = pathName;
                g_zoomChartList[k].field = field;
                g_zoomChartList[k].isEnum = chartList[k].isEnum;
                g_zoomChartList[k].isBoolean = chartList[k].isBoolean;
                // determine linename
                z = -1;
                for(i=0; i < g_chartLineList.length; i ++) 
                {
                    if((g_chartLineList[i].pathName == pathName) && (g_chartLineList[i].field == field)){
                        g_zoomChartList[k].lineName = g_chartLineList[i].lineName;
                        g_zoomChartList[k].color = g_chartLineList[i].color;
                        g_zoomChartList[k].show = g_chartLineList[i].show;
                        z = i;
                        break;
                    }
                }
                show = false; // true if in zoom window
                if(z == -1) {
                    //bug this shouldn't happen
                }
                for(i=0; i < chartList[k].data.length; i ++)
                {
                    if(chartList[k].data[i].timestamp >= newStartTime) {
                        startIndex = i;
                        break;
                    }
                }
                if(startIndex != -1) {
                    for(i=startIndex; i < chartList[k].data.length; i ++)
                    {
                        if(chartList[k].data[i].timestamp >= newEndTime) {
                            if(chartList[k].data[i].timestamp > newEndTime)
                                endIndex = i - 1;
                            else 
                                endIndex = i;
                            break;
                        }
                    }
                    if(endIndex > -1) {
                        show = true;
                        
                        if(chartList[k].data[startIndex].timestamp > newStartTime) {
                            if(startIndex > 0) {
                                g_zoomChartList[k].data.unshift(chartList[k].data[startIndex - 1]);
                                g_zoomChartList[k].data[0].timestamp = newStartTime;
                            }
                        }
                        for(i=startIndex; i <= endIndex; i ++)
                        {
                            g_zoomChartList[k].data.push(chartList[k].data[i]);
                        }
                        if(chartList[k].data[endIndex].timestamp < newEndTime){
                            if((endIndex + 1) < chartList[k].data.length) {
                                g_zoomChartList[k].data.push(chartList[k].data[endIndex + 1]);
                                g_zoomChartList[k].data[g_zoomChartList[k].data.length - 1].timestamp = newEndTime;
                            }
                        }
                        // determine new min and max for datapoint during this zoom window
                        min = g_zoomChartList[k].data[0].value;
                        max = min;
                        
                        for(i=0; i < g_zoomChartList[k].data.length; i ++)
                        {
                            fvalue = g_zoomChartList[k].data[i].value;
                            if(fvalue > max)
                                max = fvalue;
                            if(fvalue < min)
                                min = fvalue;
                        }
                        g_zoomChartList[k].startPtr = 0;
                        g_zoomChartList[k].endPtr = g_zoomChartList[k].data.length - 1;
                        g_zoomChartList[k].dataCurrentEntries = g_zoomChartList[k].data.length;
                        g_zoomChartList[k].startTimestamp = g_zoomChartList[k].data[0].timestamp;
                        g_zoomChartList[k].endTimestamp = g_zoomChartList[k].data[ g_zoomChartList[k].endPtr].timestamp;
                        g_zoomChartList[k].minValue = min;
                        g_zoomChartList[k].maxValue = max;
                        if(chartList[k].yAxis == 1)
                            g_datalogChartInfo.zoomDatapointsOnY1 ++; 
                        else 
                            g_datalogChartInfo.zoomDatapointsOnY2 ++;

                        if(chartList[k].isEnum) 
                            g_datalogChartInfo.zoomDatapointsWithEnum ++;
                    
                    }
                    if(show && g_zoomChartList[k].show)
                        g_zoomChartList[k].show = true;
                    else
                        g_zoomChartList[k].show = false;
                }
            }
        }
        /*
        g_datalogChartInfo.zoomMinValue = min;
        g_datalogChartInfo.zoomMaxValue = max;
        g_datalogChartInfo.zoomMinValue2 = null; //yAxis2
        g_datalogChartInfo.zoomMaxValue2 = null; //yaxis2
        g_datalogChartInfo.zoomStartTimestamp = newStartTime;
        g_datalogChartInfo.zoomEndTimestamp = newEndTime;
        */
        datalogChartZoomIn();
    }
    catch {}
}
function datalogChartZoomIn() {
    g_bDatalogChartZoomInProgress = true;
    datalogChartUpdate(1);
}
function determineEnumValue (str) {
    try {
        var result = 0;
        var i;
        var str1, obj, bContinue = true, decrementValue = .1, z = -1;
        if(str == "")
            return 0.4;
        str1 = str.toLowerCase();
        for(i=0; i < g_enumsList.length; i++)
        {
            if(str1 == g_enumsList[i].name)
                return g_enumsList[i].value;
        }
        obj = {};
        obj.name = str1;
        if(str1 == "on") {
            obj.value = 1;
            bContinue = false;
        }
        else if(str1.indexOf("on") > 0) {
            obj.value = .9;

        } 
        else if(str1 == "off") {
            obj.value = .1;
            bContinue = false;
        }
        else if(str1.indexOf("off") > 0) {
            obj.value = .2;

        } 
        else if(str1 == "mid") {
            obj.value = .5;
            bContinue = false;
        }
        else if(str1.indexOf("mid") > 0) {
            obj.value = .5;

        } 
        else if(str1 == "auto") {
            obj.value = .6;
            bContinue = false;
        }
        else if(str1.indexOf("auto") > 0) {
            obj.value = .6;

        } 
        
        while(bContinue) 
        {
            g_enumsListNewValue -= decrementValue;
            if(g_enumsListNewValue <= .1) 
                g_enumsListNewValue = .9;
                
            
            if((g_enumsListNewValue == 1) || (g_enumsListNewValue == .9) || (g_enumsListNewValue == .6) || (g_enumsListNewValue == .5) || (g_enumsListNewValue == .1)) {
                
                // reserved values
            }
            else {
                z = -1;
                for(i=0; i < g_enumsList.length; i++)
                {
                    if(g_enumsListNewValue == g_enumsList[i].value) {
                        z = i;
                        break;
                    }
                }
                if(z == -1) {
                    obj.value = g_enumsListNewValue;
                    break;
                }
            }
        }
        g_enumsList.push(ob);
        result = obj.value;
    }
    catch {result = .4;}
    return result;
}
function svgPoint(element, x, y) {
    // translate page to SVG co-ordinates
    if(g_datalogSvgDoc == null) 
        return null;
     //   var pt = g_datalogSvgDoc.createSVGPoint();
    var pt = g_datalogSvgDoc.documentElement.createSVGPoint();
    pt.x = x;
    pt.y = y;
    return pt.matrixTransform(element.getScreenCTM().inverse());

}