/*************************************************************************************************
 *  browserplanning.js
 * 
 *  Contains code for the Planning View navigation tree.
 * 
 *  
 * 
 *  Copyright (C) 2021 Dialog Semiconductor.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	Dialog IzoT(tm) Software Developer's Kit License Agreement which is 
 *	available at www.dialog-semiconductor.com/license/izot_sdk/.  
 * 
 ***************************************************************************************************/
function getPlanningTree() { 
	var url = "https://" + location.hostname + "/iap/context";
	planningList = [];
	contextList = [];
	requestGetData(0, url, getPlanningTreeCallback, readFailCallback); // get Device list

}
function getPlanningTreeCallback(mode, requestUrlString, json){
	bivServerOnline = true;
	if((json === null) || (json.length === 0)) {
		if(g_bInitialization) {
			g_bInitialization = false;
			document.getElementById("gettingInfoId").innerHTML = "No data avaiable";
			showDevices();
		}
		else {
			g_bInitialization = false;
			document.getElementById("gettingInfoId").innerHTML = "No data avaiable";
		}
		return;
	}
	
	try {
		g_bInitialization = false;
		var i, j, len,iPtr;
		var device1, device2;
		var obj;
		var deviceObj ={};
		var iCount1 = 0, index1 = 0;
		var bAddDevice = false;
		var paneContent = "";
		var bContinue = true;
		var tempObj;
		if(mode === 0)
			planningList = json;
		//paneContent = prettyJson(json); //JSON.stringify(json);
		//document.getElementById("main").innerHTML = "<textarea style=\"width:100%;\" cols=\"25\">" + paneContent + "</textarea>";
		getplanningTreeShowTree(0);
		//if(deviceList.length === 0) {
		//	getDeviceListOnlyDontDisplay();
		//}
		
	}
	catch {}
}
function getPlanningTreeInitializePlanningList (mode, json, path, level) {
	try {
		var i, j, k;
		level++;
		var devices = [];
		var tempObj;
		var bContinue;
		
		if(json === null)
			return null;
		for(i=0; i < json.length; i++)
		{
			if(level === 1) {
				json[i].show = true;
				
			}
			else {
				json[i].show = false;
				
			}
			if(path !== "") {
				json[i].path = path + "/" + json[i].name;
				json[i].treeLevel = level;
			}
			else {
				json[i].path = json[i].name;
				json[i].treeLevel = level;
			}
			if(mode === 0) {
				tempObj = {};
				tempObj.path = json[i].path;
				tempObj.treelevel = level;
				tempObj.id = json[i].id;
				tempObj.name = json[i].name;
				contextList.push(tempObj);
			}
			json[i].devices = [];
			devices = [];
				// list devices
			for(k=0; k < deviceListAll.length; k++) 
			{
				for(j=0; j < deviceListAll[k].contexts.length; j++)
				{
					
					if(deviceListAll[k].contexts[j] === json[i].id) 
					{
						devices.push(JSON.parse(JSON.stringify(deviceListAll[k])));
						break;
					}
				}
			}
			if(devices.length > 0) {
				// reorder based on device name
				bContinue = true;
				while(bContinue) 
				{
					bContinue = false;
					for(k=0; k < (devices.length - 1); k++)
					{
						if(devices[k].name > devices[k + 1].name) {
							bContinue = true;
							tempObj = JSON.parse(JSON.stringify(devices[k]));
							devices[k] = JSON.parse(JSON.stringify(devices[k + 1]));
							devices[k + 1] = JSON.parse(JSON.stringify(tempObj));
						}
					}
				}
				json[i].devices = devices;
			}
			if(json[i].children !== null) {
				if(json[i].children.length > 0) {
					json[i].children = getPlanningTreeInitializePlanningList (mode, json[i].children, json[i].path, level);
				}
			}
			
		}
	} catch { sResult = ""; }
	return json;
}
function getplanningTreeShowTree(mode) {
//planningContext, planningContextRoot
	var paneContent = "";
	var i,j, k;
	var tempStr;
	var sidebar = null;
	try{
		planningList = getPlanningTreeInitializePlanningList(mode, planningList, "", 0);
		if(g_iMainDisplayMode === DISPLAYMODE_PLANNING)
			paneContent = getplanningTreeShowTreeContext(planningList, 0) + "<br><br>";
	}
	catch {}
	if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
		sidebar = document.getElementById("sidebar");
		//paneContent = "<div id=\"treeDiv\" style=\"float:left;\">" + paneContent + "</div><div id=\"planningPaneDetails\" style=\"display:inline-block;margin-left:30px;border:1px solid white;min-width:500px;padding:10px;";
		paneContent = "<div style=\"display:flex\"><div id=\"treeDiv\" style=\"float:left;border: 1px black; white-space:nowrap; overflow:auto\">" + paneContent;
		paneContent += 'Legend:<br>';
		paneContent +='<span class="dot" style="background-color:lawngreen"></span> All Devices Up';
		paneContent += '<br><span class="dot" style="background-color:red"></span> All Devices Down';
		paneContent += '<br><span class="dot" style="background-color:yellow"></span> Some Devices Down';
		paneContent += '<br><span class="dot" style="background-color:blue"></span> Some Devices Unprovisioned'
		paneContent += "</div>";
		paneContent += "<div class=\"verticalline\"></div><div id=\"planningPaneDetails\" style=\"display:inline-block;margin-left:30px;border:0px;padding:10px;";
		if(sidebar != null)
			paneContent += "min-height:" + sidebar.offsetHeight + "px";
		paneContent += "\">No Contexts Selected</div>"
		paneContent += "</div>"
		paneContent += addTopButton();
		document.getElementById("main").innerHTML = paneContent;
		var iDivWidth = document.getElementById("treeDiv").offsetWidth;
		document.getElementById("treeDiv").style.minWidth = iDivWidth + "px"; 

		
			
	}
	// adding context to devicesList
	if(mode === 0) {
		if(g_iSmartServerVersion >= 280000) {
			try {
				for(i=0; i < deviceList.length; i++)
				{
					if(deviceList[i].contextStr === null) {
						tempStr = "";
						if(!(typeof deviceList[i].contexts === "undefined")) {
							for(k=0; k < deviceList[i].contexts.length; k++)
							{
								for(j=0; j < contextList.length; j++) 
								{
									if(contextList[j].id === deviceList[i].contexts[k]) {
										if(tempStr !== "")
											tempStr += "<br>"
										tempStr += contextList[j].name; //contextList[j].path;
										break;
									}
								}
								
							}
							deviceList[i].contextStr = tempStr;
						}
					}
				}
			}
			catch
			{
				
			}
		}
	}
}
function getplanningTreeShowTreeContext(json, level) {
	var result = null;
	if(g_bPlanningTreeWithDevices)
		result =  getplanningTreeShowTreeContextBuilderWithDevices(json, level,false);
	else 
		result = getplanningTreeShowTreeContextBuilderNoDevices(json, level,false);
	return result;
}
function getplanningTreeShowTreeContextBuilderWithDevices(json, level, bLastChild) {
	// This is the main code for building Planning Tree
	var sResult = "";
	var i,j, k, index, len, obj;
	var iTotal = 0, iUp = 0, iProvisioned = 0, iUnProvisioned = 0, iDown = 0;
	var bContinue = false;
	
	try {
		level++;
		if(json === null)
			return "";
		var lastIndex = json.length - 1;
		if(level === 1) {
			//if(json.length === 1)
			//	sResult = "<ul style=\"border-left: 1px solid #366184;margin-left: -17px;\">"; // try height:8px;
			//else
				sResult = "<ul>";  // may have a problem with two campuses
		}
		else {
			//if((level === 2) && bLastChild)
			//	sResult = "<ul class=\"treeviewNested treeviewActive\" style=\"border-left: 1px solid #366184;height:0px\">"; // needed as issue on some display with Site line too long
			//else if(bLastChild)
			if(bLastChild)
				sResult = "<ul class=\"treeviewNested treeviewActive\" style=\"border-left: 3px solid #366184;margin-left: -18px;\">";

			else
				sResult = "<ul class=\"treeviewNested treeviewActive\">";
		}
		bLastChild = false;
		
		for(i=0; i < json.length; i++)
		{
			if(json[i].children.length > 0) { 
				// sort children
				if(json[i].children.length === 1)
					bContinue = false;
				else
					bContinue = true;
				while(bContinue)
				{
					bContinue = false;
					len = json[i].children.length - 1;
					for(k=0; k < len; k++)
					{
						if(json[i].children[k].name.toLowerCase() > json[i].children[k + 1].name.toLowerCase()) {
							bContinue = true;
							obj = {};
							obj = JSON.parse(JSON.stringify(json[i].children[k]));
							json[i].children[k] = JSON.parse(JSON.stringify(json[i].children[k + 1]));
							json[i].children[k + 1] = obj;
						}
					}
				}


				if(i === lastIndex) {
					//sResult += "<li class=\"treeviewLiActive\" style=\"border-bottom:0px\"><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
					sResult += "<li class=\"treeviewLiActiveLastChild\" ><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
					bLastChild = true;
				}
				else 
					sResult += "<li class=\"treeviewLiActive\"><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
				switch(json[i].contextType.toLowerCase()) {
					case "campus": sResult += "<a class=\"context-campus\" href=\"#\"></a>"; break;
					case "building": sResult += "<a class=\"context-building\" href=\"#\"></a>"; break;
					case "floor": sResult += "<a class=\"context-floor\"  href=\"#\"></a>"; break;
					case "room": sResult += "<a class=\"context-room\"  href=\"#\"></a>"; break;
					case "area": sResult += "<a class=\"context-area\"  href=\"#\"></a>"; break;
				}
				//sResult += "<img class=\"icon-context-type-building\" src=\"\" width=\"1\" height=\"1\">"; 
					//sResult += "<li class=\"icon1-context-type-building\"></li>";  // Test
					//sResult += "<span class=\"material-icons icon-context-type-building\"></span>";  // Test
				//sResult += "<span class=\"context-icons\">&#x00E;</span>";  // Test
				sResult += "<span id=\"planningTreeContext_" + json[i].id + "\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\">" + json[i].name;
				//sResult += "        (" + json[i].contextType.toLowerCase() + ")";
				if(json[i].devices.length > 0) {
					sResult += " [" + json[i].devices.length + " Devices]";
					if(g_bShowDeviceStatusInTree) {
						iTotal = 0; iUp = 0; iProvisioned = 0; iUnProvisioned = 0; iDown = 0;
						for(k=0; k < json[i].devices.length; k++)
						{
							if(json[i].devices[k].status.state === "provisioned") {
								if(json[i].devices[k].status.health === "normal")
									iUp ++;
								else {
									if(json[i].devices[k].category === "SC")
										iUp ++;
									else 
										iDown ++;
								}
							}
							else 
								iUnProvisioned ++;
						}
						if(iDown === json[i].devices.length)
							sResult += '<span class="dot" style="background-color:red"></span>';
						else if(iDown > 0)
							sResult += '<span class="dot" style="background-color:yellow"></span>';
						if(iUnProvisioned > 0)
							sResult += '<span class="dot" style="background-color:blue"></span>';
					}
				}
				sResult += "</span></p>";
				sResult += getplanningTreeShowTreeContextBuilderWithDevices(json[i].children, level, bLastChild);
				sResult += "</li>";
			}
			else { 
				if(true) {//if(json[i].devices.length === 0)
					sResult += "<li><p class=\"treeviewNoChildren\">";
					switch(json[i].contextType.toLowerCase()) {
						case "campus": sResult += "<a class=\"context-campus\" href=\"#\"></a>"; break;
						case "building": sResult += "<a class=\"context-building\"  href=\"#\"></a>"; break;
						case "floor": sResult += "<a class=\"context-floor\" href=\"#\"></a>"; break;
						case "room": sResult += "<a class=\"context-room\"  href=\"#\"></a>"; break;
						case "area": sResult += "<a class=\"context-area\"  href=\"#\"></a>"; break;
					}
					sResult += "<span id=\"planningTreeContext_" + json[i].id + "\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\">" + json[i].name;
					//sResult += "        (" + json[i].contextType.toLowerCase() + ")";
					if(json[i].devices.length > 0) {
						sResult += "   [" + json[i].devices.length + " Devices]";
						if(g_bShowDeviceStatusInTree) {
							iTotal = 0; iUp = 0; iProvisioned = 0; iUnProvisioned = 0; iDown = 0;
							for(k=0; k < json[i].devices.length; k++)
							{
								if(json[i].devices[k].status.state === "provisioned") {
									if(json[i].devices[k].status.health === "normal")
										iUp ++;
									else {
										if(json[i].devices[k].category === "SC")
											iUp ++;
										else 
											iDown ++;
									}
								}
								else 
									iUnProvisioned ++;
							}
							if(iDown === json[i].devices.length)
								sResult += '<span class="dot" style="background-color:red"></span>';
							else if(iDown > 0)
								sResult += '<span class="dot" style="background-color:yellow"></span>';
							if(iUnProvisioned > 0)
								sResult += '<span class="dot" style="background-color:blue"></span>';
						}
					}
					sResult += "</span></p></li>";
				}
				else {
					sResult += "<li class=\"treeviewLiActiveLastChild\" ><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
					sResult += "<span onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\">" + json[i].name + "    [" + json[i].contextType.toLowerCase() + "]</span></p>";
					sResult += "<ul class=\"treeviewNested treeviewActive\">"
					for(j=0; j <json[i].devices.length - 1; j++)
					{
						sResult += "<li class=\"treeviewLiActive\" ><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewShowDatapoints(this)\"></button>";
						sResult += "<span onclick=\"getPlanningTreeShowDeviceDetails(" + json[i].devices[j].path + ")\">" + json[i].devices[j].name + "</span></p>";

					}
					index = json[i].devices.length - 1;
					sResult += "<li class=\"treeviewLiActiveLastChild\" ><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewShowDatapoints(this)\"></button>";
					sResult += "<span onclick=\"getPlanningTreeShowDeviceDetails(" + json[i].devices[index].path + ")\">" + json[i].devices[index].name + "</span></p>";
					sResult += "</ul></li>";
					//sResult += "<li><p><span onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\">" + json[i].name + "    [" + json[i].contextType.toLowerCase() + "]</span></p>";
					//sResult += "<ul  id=\"" + json[i].path + "\" class=\"treeviewNested\" style=\"border-left: 1px solid #366184;margin-left: -17px;\"><li>devices</li></ul>";
					//sResult += "</li>";
				}
				
			}
		}
		sResult += "</ul>";
	} catch { sResult = "<ul></ul>"; }
	if(level === 1) {
		sResult = "Sites<br>" + sResult; //"Sites<br><div style=\"padding-left:17px\">" + sResult + "</div>"; 
	}
	return sResult;
}
function getplanningTreeShowTreeContextBuilderNoDevices(json, level, bLastChild) {
	var sResult = "";
	var i,j, index;
	try {
		level++;
		if(json === null)
			return "";
		var lastIndex = json.length - 1;
		if(level === 1) {
			//if(json.length === 1)
			//	sResult = "<ul style=\"border-left: 1px solid #366184\">";
			//else
				sResult = "<ul>"; // may have a problem with two campuses
		}
		else {
			if(bLastChild)
				sResult = "<ul class=\"treeviewNested treeviewActive\" style=\"border-left: 3px solid #366184;margin-left: -18px;\">";

			else
				sResult = "<ul class=\"treeviewNested treeviewActive\">";
		}
		bLastChild = false;
		
		for(i=0; i < json.length; i++)
		{
			if(json[i].children.length > 0) { 
				if(i === lastIndex) {
					//sResult += "<li class=\"treeviewLiActive\" style=\"border-bottom:0px\"><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
					sResult += "<li class=\"treeviewLiActiveLastChild\" ><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
					bLastChild = true;
				}
				else 
					sResult += "<li class=\"treeviewLiActive\"><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
				sResult += "<span onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\">" + json[i].name + "    [" + json[i].contextType.toLowerCase() + "]</span></p>";
				sResult += getplanningTreeShowTreeContextBuilderNoDevices(json[i].children, level, bLastChild);
				sResult += "</li>";
			}
			else { 
				sResult += "<li><p><span onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\">" + json[i].name + "    [" + json[i].contextType.toLowerCase() + "]</span></p></li>";
			}
		}
		sResult += "</ul>";
	} catch { sResult = "<ul></ul>"; }
	if(level === 1) {
		sResult = "Sites<br>" + sResult;
	}
	return sResult;
}
function getPlanningTreeShowDeviceDetails() {

}
function getPlanningTreeShowTreeDevices(id) {
	try {
		var sResult = "", i;
		var list = [];
		var bContinue = false;
		var json, json1;
		document.getElementById("planningPaneDetails").style.display = "inline-block";
		json = getPlanningTreeShowTreeDetailsGetObj(planningList, id, 0);
		if(json === null)
			document.getElementById("planningPaneDetails").innerHTML = "<br>" + json['path'] + "<br><br>No Devices";
		else {
			// sort
			
			while(bContinue)
			{
				bContinue = false;
				for(i=0; i < json.length; i)
				{

				}
			}
			list = json["devices"];
			if(list.length === 0 ){
				document.getElementById("planningPaneDetails").innerHTML = "<br>" + json['path'] + "<br><br>No Devices";
			}
			else {
				for(i = 0; i < list.length; i++)
				{
					
					if(typeof list[i].id !== "number") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					else if (typeof list[i].name != "string") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					else if (typeof list[i].deviceTypeName != "string") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					//sResult += "<tr class=\"planningdevicetableTr\"><td><button class=\"clickabletext\" onclick=\"showDeviceByName(0, '" + list[i].name + "')\">" + list[i].name + "</button></td></tr>"; //ffix
					
					
					sResult += "<tr class=\"planningdevicetableTr\"><td class=\"planningdevicetableTd\">";
					sResult += "<div><canvas id=\"canvas_" + list[i].name +"\" width=\"12\" height=\"12\"></canvas></div>"; 
					

					sResult += "</td><td class=\"planningdevicetableTd\"><button id=\"deviceMenu_" + list[i].name + "\" class=\"clickabletext\"";
					sResult += " onclick=\"menuDevice(1, event," + list[i].id + ", '" + list[i].name  + "', '" + list[i].deviceTypeName  + "')\">";
					sResult += list[i].name + "</button></td></tr>"; 
				}
				
				if(sResult !== "") { 
					//sResult = "<hr><div class=\"planningdevicetableDiv\"><table id=\"myTablePlanningTree\" class=\"planningdevicetable\"><tbody>" + sResult + "</tbody></table></div>";
					sResult = "<div class=\"planningdevicetableDiv\"><table id=\"myTablePlanningTree\" class=\"planningdevicetable\"><tbody>" + sResult + "</tbody></table></div>";
					sResult = "<br>" + json['path'] + "<button style=\"margin-left:40px;\" onclick=\"showContextDevices(" + id + ")\">Show Devices Detail</button><br><br>" + sResult;
					document.getElementById("planningPaneDetails").innerHTML = sResult;
					//sortTable(0); 
				}
				if(sResult != "") {
					for(i = 0; i < list.length; i++)
					{
						deviceStatusColorCanvas("canvas_" + list[i].name, list[i].category,list[i].deviceStatus);
						//deviceStatusColor("canvas_" + list[i].id, list[i].deviceStatus);
					}
				}
			}
		}
	}
	catch {}
}
function getPlanningTreeShowTreeDetails(mode, id) {
	var json;
	var sResult = "";
	var sTemp;
	var bContinue = false;
	var sResults;
	var x, i;
	var treeContext = null;
	try {
		if(mode == 0) {
			// change color of tree context to indicate selected
			if(g_iPlanningPaneSelectedContextId != -1) {
				treeContext = document.getElementById("planningTreeContext_" + g_iPlanningPaneSelectedContextId);
				if(treeContext != null) {
					treeContext.style.backgroundColor = "#366184";
					//treeContext.style.color = "white";
				}
			}
			treeContext = document.getElementById("planningTreeContext_" + id);
			if(treeContext != null) {
				//treeContext.style.color = "red";
				treeContext.style.backgroundColor = "red";
			}
		}

		g_iPlanningPaneSelectedContextId = id;
		json = getPlanningTreeShowTreeDetailsGetObj(planningList, id, 0);
		if((g_iPlanningTreeShowDevices === 1) || (json.contextType == "CAMPUS") || (json.contextType == "BUILDING")) {  
			getPlanningTreeShowTreeDevices(id);
			
			//showContextDevices(id);
			return;
		}
		else if(g_iPlanningTreeShowDevices === 0) {
			getPlanningTreeShowTreeFloorplan(id);
			//showContextDevices(id);
			return;
		}

		document.getElementById("planningPaneDetails").style.display = "inline-block";
		json = getPlanningTreeShowTreeDetailsGetObj(planningList, id, 0);
		
		if(json === null)
			document.getElementById("planningPaneDetails").innerHTML = "Details<br><br>No Details";
		else {
			// sort
			while(bContinue)
			{
				bContinue = false;
				for(i=0; i < json.length; i)
				{

				}
			}
			for (x in json)
			{
				if(x === "devices") {
					sResult += "<tr><td>Devices</td><td>" + json[x].length + "</td></tr>";
				}
				else if(typeof json[x] === "undefined")
					sResult += "<tr><td>" + x + "</td><td></td></tr>";
				else if (json[x] === null )
					sResult += "<tr><td>" + x + "</td><td></td></tr>";
				else if(json[x] === "undefined")
					sResult += "<tr><td>" + x + "</td><td></td></tr>";
				else if(x === "treeLevel")
					sResult += "<tr><td>Tree Level</td><td>" + json[x] + "</td></tr>"; 
				else if(x === "children")
					sResult += "<tr><td>Number of children</td><td>" + json[x].length + "</td></tr>";
				else if(x === "image")  {
					
					sResult += "<tr><td>images</td><td>" + json[x].length + "</td></tr>";
				}
				else if((typeof json[x] === "object")  || Array.isArray(json[x])) {
					sTemp = JSON.stringify(json[x]);
					sResult += "<tr><td>" + x + "</td><td>" + sTemp + "</td></tr>"; 
				}
				else 
					sResult += "<tr><td>" + x + "</td><td>" + json[x] + "</td></tr>"; 
			}
			if(sResult !== "") {
				sResult = "<table id=\"myTable\"><thead><tr><th>Property</th><th>Value</th></tr></thead><tbody>" + sResult + "</tbody></table>"; 
				sResult = "<br>" + json['path'] + "<br><br>Details<button style=\"margin-left:40px;\" onclick=\"showContextDevices(" + id + ")\">Show Devices</button><br><br>" + sResult;
				sResult += addTopButton();
				document.getElementById("planningPaneDetails").innerHTML = sResult;
				sortTable(0); 
			}
		}
		
	}
	catch {}
}
function getPlanningTreeShowTreeDetailsGetObj(json, id, level) {
	var i;
	var jsonResult = null;
	level ++;
	if(json === null)
		return null;
	try {
		for(i=0; i < json.length; i++)
		{
			if(json[i].id === id) {
				jsonResult = JSON.parse(JSON.stringify(json[i]));
				break;
			}
			else if (json[i].children !== null) {
				if(json[i].children.length > 0) {
					jsonResult = getPlanningTreeShowTreeDetailsGetObj(json[i].children, id, level);
					if(jsonResult !== null) 
						break;
				}
			}
		}
	}
	catch { jsonResult = null;}
	
	return jsonResult;
}
function getPlanningTreeShowTreeDetailsGetObjPlusFloorplan(json, id, level, image) {
	var i;
	var jsonResult = null;
	level ++;
	if(json === null)
		return null;
	try {
		for(i=0; i < json.length; i++)
		{
			if(json[i].id === id) {
				jsonResult = JSON.parse(JSON.stringify(json[i]));
				if((jsonResult.image.image == null) || (jsonResult.image.image == null)) {
				
					if(image != null)
						jsonResult.image = image;
				}
				break;
			}
			else if (json[i].children !== null) {
				if(json[i].children.length > 0) {
					if(json[i].contextType == "FLOOR") {
						if((json[i].image.image != null) && (json[i].image.image != null)) 
							image = json[i].image;
							image.floorId = json[i].contextualEntityId;
					}
					jsonResult = getPlanningTreeShowTreeDetailsGetObjPlusFloorplan(json[i].children, id, level, image);
					if(jsonResult !== null) 
						break;
				}
			}
		}
	}
	catch { jsonResult = null;}
	
	return jsonResult;
}
function getPlanningTreeShowTreeFloorplan (id) {
	try { 
		var sTemp = "";
		var floorId = -1;
		g_planningFloorplanObjs = {};
		g_planningFloorplanGroups = [];
		document.getElementById("planningPaneDetails").style.display = "inline-block";
		json = getPlanningTreeShowTreeDetailsGetObjPlusFloorplan(planningList, id, 0, null);
		if((json.contextType == "CAMPUS") || (json.contextType == "BUILDING")){
			sTemp = "Floor plans not supported for " + json.contextType + "<br><br>Supported Floorplans: floor, and rooms and areas inside a floor";
			document.getElementById("planningPaneDetails").innerHTML = sTemp;
			return;
		}
		else if(json.contextType == "FLOOR") {
			floorId = json.contextualEntityId;
		}
		else {
			if(json.image != null) 
				floorId = json.image.floorId;
		}
		json.browserFloorId = floorId;
		if((json.image.image === null) || (json.image.imageType === null)) {
			document.getElementById("planningPaneDetails").innerHTML = "";
			return;
		}
		else if(( json.image.imageType !== "png") && ( json.image.imageType !== "jpeg")) {
			document.getElementById("planningPaneDetails").innerHTML = ""; // not supported yet
				return;
		}
		if(json.contextualEntityId === null) {
			if( json.image.imageType === "png")
				sTemp = "<img src=\"data:image/png;base64," + json.image.image + "\">";
			else if( json.image.imageType === "png")
				sTemp = "<img src=\"data:image/jpeg;base64," + json.image.image + "\">";
			document.getElementById("planningPaneDetails").innerHTML = sTemp;
		}
		else {
			document.getElementById("planningPaneDetails").innerHTML = "Getting floor plan ....";
			sTemp = "/iap/zones/*+floor.id==" + json.browserFloorId; //json.contextualEntityId;
			requestGetData(json, sTemp, getPlanningTreeShowTreeFloorplanShowPolygons, readFailCallback);
		}

	}
	catch {}
}
function getPlanningTreeShowTreeFloorplanShowPolygons (contextobj, url, json) {
	try { 
		var sTemp = "";
		var obj = {}
		sTemp = "<div id=\"floorplanTitle\">" + contextobj.path;
		sTemp += "<br><br> Getting Floor plan ....</div><br><div id=\"floorplanimageDiv\"><img id=\"floorplanimage\" src=\"data:image/png;base64," + contextobj.image.image + "\" style=\"visibility:hidden\"></div>";
		document.getElementById("planningPaneDetails").innerHTML = sTemp;
		obj.contextobj = JSON.parse(JSON.stringify(contextobj));
		obj.floorplan = JSON.parse(JSON.stringify(json));
		sTemp = "/iap/devs?floorid=" + contextobj.browserFloorId;//contextobj.contextualEntityId;
		requestGetData(obj, sTemp, getPlanningTreeShowTreeFloorplanShowDevices, readFailCallback);

	}
	catch {}
}

function getPlanningTreeShowTreeFloorplanShowDevices (floorplanObjs, url, json1) {
	// had to wait for device list as need time for image to load.
	var i, j,z;
	var coordinates;
	var top=0,left=0;
	var sTemp;
	var detailImage = null; //document.getElementById("planningPaneDetails");
	var offsets = null; //detailDiv.getBoundingClientRect(); 
	var contextualEntityId;
	var x, y, x1, x2, y1, y2; // used to determine full size of canvas and set canas width and lenght
	var coordList = [], obj;
	var contextobj;
	var width = 20;
	var multiplier = 1;
	var color;
	var bContinue = false;
	var floorId = -1;
	var minImageWidth = 800; //px
	var changeColor = "";
	var groupNum;
	var json;
	var r,w;
	var planningCount, count = 0;
	try {
		contextobj = floorplanObjs.contextobj;
		contextualEntityId = contextobj.contextualEntityId;
		floorId = contextobj.browserFloorId;
		json = floorplanObjs.floorplan;
		document.getElementById("floorplanTitle").innerHTML = "<div>" + contextobj.path + "</div><div><span id=\"planningDeviceCount\" style=\"visibility:hidden;margin-left:20px\">  [ 0 devices]</span></div>";
		detailImage = document.getElementById("floorplanimage"); //("floorplanimageDiv");
		offsets = detailImage.getBoundingClientRect(); 
		// zoom in if image width is less than 1000
		if(offsets.width > 0 ) {
			if(offsets.width < minImageWidth) {
				multiplier = (minImageWidth / offsets.width);
				multiplier =  Math.ceil(multiplier);
				if(multiplier > 1) {
					detailImage.width = (offsets.width * multiplier);
					detailImage.height = (offsets.height * multiplier);
					offsets = detailImage.getBoundingClientRect(); 
				}
				else 
					multiplier = 1;


			}
		}
		detailImage.style.visibility = "visible";
		
		if(json != null) {
			for(i=0; i < json.length; i++)
			{ // get x1,x2, y1 and y2 to figure out width and height
				bContinue = false;
				obj = {};
				obj.x1 = -1;
				obj.x2 = -1;
				obj.y1 = -1;
				obj.y2 = -1;
				obj.width = 0;
				obj.height = 0;
				if(contextobj.contextType === "FLOOR")
					bContinue = true;
				else if(contextobj.contextualEntityId === json[i].id)
					bContinue = true;
				if(bContinue) {
					coordinates = json[i].polygon.coordinates['0'];
					for(j=0; j < coordinates.length; j++) 
					{
						var cordinate = coordinates[j];
						if(j==0) {
							x1 = x2 = cordinate['0'];
							y1 = y2 = cordinate['1'];
							//sTemp= x1 + "," + y1;
						}
						else {
							
							if(x1 > cordinate['0'])
								x1 = cordinate['0'];
							if(x2 < cordinate['0'])
								x2 = cordinate['0'];
							if(y1 > cordinate['1'])
								y1 = cordinate['1'];
							if(y2 < cordinate['1'])
								y2 = cordinate['1'];
							//sTemp += " " +  cordinate['0'] + "," +  cordinate['1'];
						}
					}
					obj.x1 = x1;
					obj.x2 = x2;
					obj.y1 = y1;
					obj.y2 = y2;
					obj.width = x2 - x1;
					obj.height = y2 - y1;
					
				}
				
				coordList.push(obj);
			}
		
			for(i=0; i < json.length; i++)
			{
				bContinue = false;
				if(contextobj.contextType === "FLOOR")
					bContinue = true;
				else if(contextobj.contextualEntityId === json[i].id)
					bContinue = true;
				if(bContinue) {
					coordinates = json[i].polygon.coordinates['0'];
					sTemp = "";
					x = coordList[i].x1;
					y = coordList[i].y1;
					for(j=0; j < coordinates.length; j++) 
					{
						var coordinate = coordinates[j];
						sTemp += " " +  ((coordinate['0'] - x) * multiplier) + "," +  ((coordList[i].height - (coordinate['1'] - y)) * multiplier);
					}
					x = offsets.x + window.pageXOffset + (coordList[i].x1 * multiplier);
					//y = offsets.y + offsets.height + window.pageYOffset - (obj.height + obj.y1); //offsets.y + window.pageYOffset + coordList[i].y1;
					y = offsets.bottom + window.pageYOffset - ((coordList[i].height + coordList[i].y1) * multiplier);
					//sTemp = "<polygon points=\"" + sTemp + "\" style=\"fill:" + json[i].color + ";stroke:" + json[i].color + ";stroke-width:3\" opacity=\"0.3\"/>";
					sTemp = "<polygon points=\"" + sTemp + "\" style=\"fill:" + json[i].color + ";stroke:black;stroke-width:3\" opacity=\"0.3\" />"
					sTemp = "<div style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:4\"> <svg width=\"" + ( coordList[i].width * multiplier) + "\" height=\"" + (coordList[i].height * multiplier) + "\">" + sTemp + "</svg></div>";				

					document.getElementById("planningPaneDetails").innerHTML += sTemp;
				}
		
			}
		}
		
		if(json1 != null) {
			for(i=0; i < json1.length; i++)
			{
				if(json1[i].hasOwnProperty('floorCoordinates')) {
					//if(json1[i].floorCoordinates.floorId === contextualEntityId) {
					if(json1[i].floorCoordinates.floorId === floorId) {
						count ++;
						var coordinate = json1[i].floorCoordinates;
						// check if more than one device at same location, if so only add one and assign device to group
						z = -1;
						if(json1[i].status.state === "provisioned") {
							if((json1[i].status.health === "normal") || (json1[i].category === "SC"))
								color = "lawngreen";
							else if(json1[i].status.health === "down")
								color = "red";
							else if(json1[i].status.health === "suspect")
								color = "yellow";
							else
								color = "darkred";
						}
						else if(json1[i].status.state === "provisioning")
							color = "cyan";
						else 
							color = "blue";
						for(j=0; j < g_planningFloorplanGroups.length; j++) 
						{
							if((g_planningFloorplanGroups[j].x === coordinate['x']) && (g_planningFloorplanGroups[j].y === coordinate['y'])) {
								g_planningFloorplanGroups[j].deviceList.push(JSON.parse(JSON.stringify(json1[i])));
								if((color == "red") && (g_planningFloorplanGroups[j].color != "red"))
									changeColor = color;
								else if((color == "yellow") && (g_planningFloorplanGroups[j].color != "red") && (g_planningFloorplanGroups[j].color != "yellow"))
									changeColor = color;
								else if((color == "cyan") && (g_planningFloorplanGroups[j].color != "red") && (g_planningFloorplanGroups[j].color != "yellow") && (g_planningFloorplanGroups[j].color != "cyan"))
									changeColor = color;
								else if((color == "blue") && (g_planningFloorplanGroups[j].color != "red") && (g_planningFloorplanGroups[j].color != "yellow") && (g_planningFloorplanGroups[j].color != "cyan")
									&& (g_planningFloorplanGroups[j].color != "blue"))
									changeColor = color;
								else if(color != g_planningFloorplanGroups[j].color)
									changeColor = color;

								if(changeColor !== "") {
									g_planningFloorplanGroups[j].color = changeColor;
									document.getElementById(g_planningFloorplanGroups[j].displayId).fill = changeColor;
								}
								z = j;
								break;
							}
						}
						if(z === -1) {
							var x = offsets.x + window.pageXOffset + (coordinate['y'] * multiplier) - (width / 2);
							var y = offsets.bottom + window.pageYOffset - (coordinate['x'] * multiplier) + (width / 2);
							groupNum = g_planningFloorplanGroups.length;
							sTemp = "<div style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:7\">";
							//sTemp += "<svg height=\"32\" width=\"32\"> <circle id=\"deviceMenu_" + json1[i].name + "\" cx=\"16\" cy=\"16\" r=\"14\" stroke=\"black\" stroke-width=\"3\" fill=\"" + color + "\"";
							//sTemp += " onclick=\"getPlanningFloorplanMenu(" + groupNum + ")\">"
							sTemp += "<svg height=\"32\" width=\"32\">";
							sTemp += "<g><title>" + json1[i].name  + "</title>";
							sTemp += "<circle id=\"deviceMenu_" + json1[i].name + "\"  cx=\"16\" cy=\"16\" r=\"14\" stroke=\"black\" stroke-width=\"3\" fill=\"" + color + "\"";
							sTemp += " onclick=\"getPlanningFloorplanMenu(" + groupNum + ")\" />";
							//sTemp += " onclick=\"menuDevice(2, event," + json1[i].id + ", '" + json1[i].name  + "', '" + json1[i].typeId  + "')\">";
							//sTemp += " /></svg> </div>";
							sTemp += "</g>";
							sTemp += "</svg> </div>";
							
							obj = {};
							obj.displayId = "deviceMenu_" + json1[i].name;
							obj.color = color;
							obj.deviceList = [];
							obj.x = coordinate['x'];
							obj.y = coordinate['y'];
							obj.deviceList.push(JSON.parse(JSON.stringify(json1[i])));
							g_planningFloorplanGroups.push(obj);
							document.getElementById("planningPaneDetails").innerHTML += sTemp;

						}
						
					}
				}
			}
			for(i=0; i < g_planningFloorplanGroups.length; i ++) {
				if(g_planningFloorplanGroups[i].deviceList.length > 1) {
					
					
					if(g_planningFloorplanGroups[i].deviceList.length < 10) {
						x = offsets.x + window.pageXOffset + (g_planningFloorplanGroups[i].y * multiplier) + (width / 2) - 8;
						y = offsets.bottom + window.pageYOffset - (g_planningFloorplanGroups[i].x * multiplier) + (width / 2) + 5;
					}
					else if(g_planningFloorplanGroups[i].deviceList.length < 100) {
						x = offsets.x + window.pageXOffset + (g_planningFloorplanGroups[i].y * multiplier) + (width / 2) - 12;
						y = offsets.bottom + window.pageYOffset - (g_planningFloorplanGroups[i].x * multiplier) + (width / 2) + 5;
					}
					else  {
						x = offsets.x + window.pageXOffset + (g_planningFloorplanGroups[i].y * multiplier) + (width / 2) - 15;
						y = offsets.bottom + window.pageYOffset - (g_planningFloorplanGroups[i].x * multiplier) + (width / 2) + 5;
					}
					sTemp = "<div style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:8; color:black\" onclick=\"getPlanningFloorplanMenu(" + i + ")\">" + g_planningFloorplanGroups[i].deviceList.length + "</div>";
					//sTemp = "<div style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:8; color:white; cursor:default\" onclick=\"getPlanningFloorplanMenu(" + i + ")\">888</div>";
					document.getElementById("planningPaneDetails").innerHTML += sTemp;
					// rename id for groups of devices
					document.getElementById("deviceMenu_" + g_planningFloorplanGroups[i].deviceList[0].name).id = "deviceMenu1_" + i;  // change id for groups so no conflict with devicemenu_<name>
/*
					// keep for future grahics
					if(g_planningFloorplanGroups[i].deviceList.length < 10) {
						r = 10;
						w = (2 * r) +  4;
						x1 = ((w / 2) - 5);
						y1 = ((w / 2) + 5);
						x2 = 6;
						y2 = 0;
					}
					else if(g_planningFloorplanGroups[i].deviceList.length < 100) {
						r = 12;
						w = (2 * r) +  4;
						x1 = ((w / 2) - 8);
						y1 = ((w / 2) + 5);
						x2 = 8;
						y2 = 4;
					}
					else  {
						r = 15;
						w = (2 * r) +  4;
						x1 = ((w / 2) - 12);
						y1 = ((w / 2) + 5);
						x2 = 8;
						y2 = 2;
					}
					var x = offsets.x + window.pageXOffset + (g_planningFloorplanGroups[i].y * multiplier) + (w - x2);
					var y = offsets.bottom + window.pageYOffset - (g_planningFloorplanGroups[i].x * multiplier) - ((w / 4) - y2);
					sTemp = "<div style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:7\">";
					sTemp += "<svg height=\"" + w + "\" width=\"" + w + "\"> <circle id=\"deviceMenu_" + json1[i].name + "\" cx=\"" + (w / 2) + "\" cy=\"" + (w / 2) + "\" r=\"" + r + "\" stroke=\"yellow\" stroke-width=\"3\" fill=\"yellow\" />";
					sTemp += "<text x=\"" + x1 + "\" y=\"" + y1 + "\">" + g_planningFloorplanGroups[i].deviceList.length + "</text></svg></div>"
					document.getElementById("planningPaneDetails").innerHTML += sTemp;
					*/
				}
				
			}
			
		} 
		planningCount = document.getElementById("planningDeviceCount");
		if(planningCount != null) {
			if((contextobj.contextType === "FLOOR") || (count === 0))
				planningCount.innerText = "  [" + count + " devices]";
			else
				planningCount.innerText = "  [" + contextobj.devices.length + "/" + count + " floor devices]";
			planningCount.style.visibility = "visible";
			
		}
	}
	catch {}
}
function getPlanningFloorplanMenu(groupNum) {
	try {
		var sTemp = "", i, list, sResult = "", jon1, status = "";
		if(groupNum < g_planningFloorplanGroups.length) {
			if(g_planningFloorplanGroups[groupNum].deviceList.length === 1) {
				menuDeviceFloorplan(2, null, g_planningFloorplanGroups[groupNum].deviceList[0].id , g_planningFloorplanGroups[groupNum].deviceList[0].name, g_planningFloorplanGroups[groupNum].deviceList[0].typeId);
			}
			else {
				// create Div to show all datapoints
				list = g_planningFloorplanGroups[groupNum].deviceList;
				for(i = 0; i < list.length; i++)
				{
					
					if(typeof list[i].id !== "number") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					else if (typeof list[i].name != "string") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					else if (typeof list[i].deviceTypeName != "string") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					//sResult += "<tr class=\"planningdevicetableTr\"><td><button class=\"clickabletext\" onclick=\"showDeviceByName(0, '" + list[i].name + "')\">" + list[i].name + "</button></td></tr>"; //ffix
					
					
					sResult += "<tr class=\"planningdevicetableTr\"><td class=\"planningdevicetableTd\">";
					sResult += "<div><canvas id=\"canvas_" + list[i].name +"\" width=\"12\" height=\"12\"></canvas></div>"; 
					

					sResult += "</td><td class=\"planningdevicetableTd\"><button id=\"deviceMenu_" + list[i].name + "\" class=\"clickabletext\"";
					//sResult += " onclick=\"menuDevice(1, event," + list[i].id + ", '" + list[i].name  + "', '" + list[i].deviceTypeName  + "')\">";
					sResult += " onclick=\"menuDeviceFloorplan(2, event," + list[i].id + ", '" + list[i].name  + "', '" + list[i].deviceTypeName  + "')\">";
					sResult += list[i].name + "</button></td></tr>"; 
				}
				
				if(sResult !== "") { 
					//sResult = "<hr><div class=\"planningdevicetableDiv\"><table id=\"myTablePlanningTree\" class=\"planningdevicetable\"><tbody>" + sResult + "</tbody></table></div>";
					sResult = "<div class=\"planningdevicetableDiv\"><table id=\"myTablePlanningTree\" class=\"planningdevicetable\"><tbody>" + sResult + "</tbody></table></div>";
					//sResult = "<br>" + json['path'] + "<button style=\"margin-left:40px;\" onclick=\"showContextDevices(" + id + ")\">Show Devices Detail</button><br><br>" + sResult;
					
					//sortTable(0); 
				}
				

				for(i=0; i < g_planningFloorplanGroups[groupNum].deviceList.length; i ++)
				{
					
					sTemp += "<div>" + g_planningFloorplanGroups[groupNum].deviceList[i].name;
				}
				
				var x = 0;
				var y = 0;
		
				var menuContent ="<div style=\"display:flex;width:300px\"><div style=\"display:inline-block;float:left\">Devices: ";
				menuContent += g_planningFloorplanGroups[groupNum].deviceList.length;
				menuContent +=  "</div><div style=\"display:inline-block;float:right\"><button class=\"closeButton\" onclick=\"planningMenuCancel()\">X</button></div></div><br>";
				g_bAlwaysIngnoreMouseClick = false;
				g_menuDivXOffset = 35;
				g_menuDivYOffset = 30;
				g_menuDivWidth = 150;
				
				menuContent += "<div>" + sResult + "</div>";
				var menuButton = document.getElementById("deviceMenu1_" + groupNum);
				var offsets;
				
				if(menuButton !== null) {
					offsets = menuButton.getBoundingClientRect(); 
					if((offsets.x + offsets.width + window.pageXOffset + g_menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
						x = offsets.x + window.pageXOffset - g_menuDivWidth - 10; // takes into account viewport (scrolling)
					else
						x = offsets.x + offsets.width + window.pageXOffset + g_menuDivXOffset; // takes into account viewport (scrolling)
					y = offsets.y + window.pageYOffset - g_menuDivYOffset; // takes into account viewport (scrolling)
					document.getElementById("planningDiv").style.left = x.toString() + "px";
					document.getElementById("planningDiv").style.top = y.toString() + "px";
					document.getElementById("planningDiv").innerHTML = menuContent;
					if(sResult != "") {
						for(i = 0; i < list.length; i++)
						{
							status = "normal";
							if(typeof list[i].deviceStatus === "undefined") {
								if(list[i].category === "SC") {
								}
								else if(list[i].status.state === "provisioned") {
									status = list[i].status.health;
								}
								else {
									status = list[i].status.state;
								}

							}
							else {
								status = list[i].deviceStatus;
							}
							deviceStatusColorCanvas("canvas_" + list[i].name, list[i].category, status);
							//deviceStatusColor("canvas_" + list[i].id, list[i].deviceStatus);
						}
					}
					document.getElementById("planningDiv").className = "planningDivShow"; // doesn't currently guaranty that menu is shown in viewport
					g_bInoreMouseClick = true;
					//document.addEventListener("click", planningMenuCancel);
					
				}
				
					
				 
			}
		}

		
	}
	catch {}
}
function getPlanningTreeShowTreeFloorplanShowPolygonsFail (id) {
	try { 
		var 
		sTemp = "<br>Problem getting floorplan info";
		document.getElementById("planningPaneDetails").innerHTML = sTemp;

	}
	catch {}
}
function treeviewShowDatapoints(n) {
	//fixxxx
}
function treeviewToggle(n) {
	try {
		n.parentNode.parentElement.querySelector(".treeviewNested").classList.toggle("treeviewActive");
		//n.parentElement.parentElement.classList.toggle("treeviewLiActive");
		if(n.parentElement !== null ) {
			if(n.parentElement.parentElement !== null) {  
				if(n.parentElement.parentElement.nextSibling !== null) {
					n.parentElement.parentElement.classList.toggle("treeviewLiNotActive");
				}
				else { // last Li 
					n.parentElement.parentElement.classList.toggle("treeviewLiNotActiveLastChild");
				}
			}
		}
		n.classList.toggle("treeviewCaret-down");
	} catch {}
}
