/*************************************************************************************************
 *  browserplanning.js
 * 
 *  Contains code for the Planning View navigation tree.
 * 
 *  This code gets all devices and all context and then builds the navigation tree. Works well on small
 *	sites, but larger sites should probably require user to expand node before getting context and device 
 *	data
 *
 * 
 * When creating the tree, all nodes are fully expanded. A context Devices nodes has all device nodes.  
 * Devices nodes are automatically collapsed so that only context and devices nodes show up initially. 
 * Expanding the devices nodes shows the hidden device nodes. When you exapand a device then a REST call
 * is made to get the device datapoint list. It is difficult to get the tree lines to work correctly. 
 * The last node for must remove the previous <ul> lines so that the lines only goes to the device and
 * not extend down to the children. When this occurs the line ends with no nodes attached.  
 * 
 * The following style must be added to the last node  <ul> of a node list in order to remove vertical dotted line
 *      style=\"border-left: 3px solid #366184;margin-left: -18px; 
 * 
 * devices Node:
 * 	getPlanningTreeShowTreeDatapoints() - shows device datapoints in details pane
 * 	treeviewToggle1 - expands/collapse device datapoints
 *  treeViewGetDeviceDatapointsResponse() - creates datapoint nodes
 * 	getPlanningTreeShowTreeDatapointsRequestDataResponse() - used to process datapoint information
 * 
 *  Copyright (C) 2021 Dialog Semiconductor.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	Dialog IzoT(tm) Software Developer's Kit License Agreement which is 
 *	available at www.dialog-semiconductor.com/license/izot_sdk/.  
 * 
 ***************************************************************************************************/
var g_bPlanningTreeShowDatapointNodes = true;
var g_treeviewInitialCollapseList = [];
var planningDpList = [];
var g_sPlanningTreeDatapointPath = "";
var g_bPlanningDpPollingEnabled = true;
var g_iPlanningPollInterval = 5;
var g_planningDpOnDemandTimerInterval = 10000; // firefox takes more time to load svg then chrome
var g_planningDpTimerId = 0; // used to initilize svg elements
var g_bPlanningShowDevice = true;
var g_bPlanningShowConfiguration = false;
var g_bPlanningShowConfigurationSingleDp = false;
function planningInit() {
	g_sPlanningTreeDatapointPath = "";
	g_bPlanningDpPollingEnabled = true;
	g_iPlanningPollInterval = 5;
	g_bPlanningShowDevice = true;
	g_bPlanningShowConfiguration = false;
	g_bPlanningShowConfigurationSingleDp = false;
}
function getPlanningTree() { 
	var url = "https://" + location.hostname + "/iap/context";
	planningList = [];
	contextList = [];
	requestGetData(0, url, getPlanningTreeCallback, readFailCallback); // get Device list

}
function getPlanningTreeCallback(mode, requestUrlString, json){
	bivServerOnline = true;
	g_bIgnoreNewDeviceDetection = false;
	if((json === null) || (json.length === 0)) {
		if(g_bInitialization) {
			g_bInitialization = false;
			if(deviceListAll.length === 0) {
				document.getElementById("gettingInfoId").innerHTML = "No data avaiable";
				return;
			}
			else if(mode === 0)
				planningList = [];
			
			getplanningTreeShowTree(0);
			//showDevices(); 123
		}
		else {
			g_bInitialization = false;
			if(deviceListAll.length === 0) {
				document.getElementById("gettingInfoId").innerHTML = "No data avaiable";
				return;
			}
			else if(mode === 0)
				planningList = [];
			
				getplanningTreeShowTree(0);
		}
		return;
	}
	
	try {
		g_bInitialization = false;
		var i, j, len,iPtr;
		var device1, device2;
		var obj;
		var deviceObj ={};
		var iCount1 = 0, index1 = 0;
		var bAddDevice = false;
		var paneContent = "";
		var bContinue = true;
		var tempObj;
		if(mode === 0)
			planningList = json;
		//paneContent = prettyJson(json); //JSON.stringify(json);
		//document.getElementById("main").innerHTML = "<textarea style=\"width:100%;\" cols=\"25\">" + paneContent + "</textarea>";
		getplanningTreeShowTree(0);
		//if(deviceList.length === 0) {
		//	getDeviceListOnlyDontDisplay();
		//}
		
	}
	catch {}
}
function getPlanningTreeInitializePlanningList (mode, json, path, level) {
	try {
		var i, j, k;
		level++;
		var devices = [], deviceName1, deviceName2;
		var tempObj;
		var bContinue;
		
		if(json === null)
			return null;
		for(i=0; i < json.length; i++)
		{
			if(level === 1) {
				json[i].show = true;
				
			}
			else {
				json[i].show = false;
				
			}
			if(path !== "") {
				json[i].path = path + "/" + json[i].name;
				json[i].treeLevel = level;
			}
			else {
				json[i].path = json[i].name;
				json[i].treeLevel = level;
			}
			if(mode === 0) {
				tempObj = {};
				tempObj.path = json[i].path;
				tempObj.treelevel = level;
				tempObj.id = json[i].id;
				tempObj.name = json[i].name;
				contextList.push(tempObj);
			}
			json[i].devices = [];
			devices = [];
				// list devices
			for(k=0; k < deviceListAll.length; k++) 
			{
				for(j=0; j < deviceListAll[k].contexts.length; j++)
				{
					
					if(deviceListAll[k].contexts[j] === json[i].id) 
					{
						devices.push(JSON.parse(JSON.stringify(deviceListAll[k])));
						break;
					}
				}
			}
			if(devices.length > 0) {
				// reorder based on device name
				bContinue = true;
				while(bContinue) 
				{
					bContinue = false;
					for(k=0; k < (devices.length - 1); k++)
					{
						deviceName1 = devices[k].name.toLowerCase() + " ";
						if(devices[k].category === "SC")
							deviceName1 = "0" + deviceName1; // make sure smartserver at top of list
						deviceName2 = devices[k + 1].name.toLowerCase() + " ";
						if(devices[k + 1].category === "SC")
							deviceName2 = "0" + deviceName2; // make sure smartserver at top of list
						//if(devices[k].name.toLowerCase() > devices[k + 1].name.toLowerCase()) {
						if(deviceName1 > deviceName2) {
							bContinue = true;
							tempObj = {};
							tempObj = JSON.parse(JSON.stringify(devices[k]));
							devices[k] = JSON.parse(JSON.stringify(devices[k + 1]));
							devices[k + 1] = tempObj;
						}
					}
				}
				json[i].devices = devices;
			}
			if(json[i].children !== null) {
				if(json[i].children.length > 0) {
					json[i].children = getPlanningTreeInitializePlanningList (mode, json[i].children, json[i].path, level);
				}
			}
			
		}
	} catch { sResult = ""; }
	return json;
}
function getplanningTreeShowTree(mode) {
//planningContext, planningContextRoot
	var paneContent = "";
	var i,j, k;
	var tempStr;
	var sidebar = null;
	try{
		planningList = getPlanningTreeInitializePlanningList(mode, planningList, "", 0);
		if(g_iMainDisplayMode === DISPLAYMODE_PLANNING)
			paneContent = getplanningTreeShowTreeContext(planningList, 0) + "<br><br>";
	}
	catch {}
	if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
		sidebar = document.getElementById("sidebar");
		
		//paneContent = "<div style=\"display:flex\"><div id=\"treeDiv\" style=\"float:left;border: 1px black; white-space:nowrap; overflow:auto\">" + paneContent;
		paneContent = "<div style=\"display:flex\"><div id=\"treeDiv\"><div id=\"treeDivTree\">" + paneContent + "</div>";
		paneContent += '<br>Legend:<br>';
		paneContent +='<span class="dot" style="background-color:lawngreen"></span> Device Up';
		paneContent += '<br><span class="dot" style="background-color:red"></span> All Devices Down';
		paneContent += '<br><span class="dot" style="background-color:yellow"></span> Some Devices Down';
		paneContent += '<br><span class="dot" style="background-color:cyan"></span> Device Provisioning';
		paneContent += '<br><span class="dot" style="background-color:blue"></span> Some Devices Unprovisioned'
		paneContent += "</div>";
		// may add back		paneContent += "<div class=\"verticalline\"></div>";
		paneContent += "<div id=\"planningPaneDetails\" style=\"display:inline-block;margin-left:30px;border:0px;padding:10px;";
		if(sidebar != null)
			paneContent += "min-height:" + sidebar.offsetHeight + "px";
		paneContent += "\">No Contexts Selected</div>"
		paneContent += "</div>"
		paneContent += addTopButton();
		document.getElementById("main").innerHTML = paneContent;
		var iDivWidth = document.getElementById("treeDivTree").offsetWidth;
		document.getElementById("treeDivTree").style.minWidth = iDivWidth + "px"; 
		treeviewNodesCollapseNodesInInialCollapseList();
		
			
	}
	// adding context to devicesList
	if(mode === 0) {
		if(g_iSmartServerVersion >= 280000) {
			try {
				for(i=0; i < deviceList.length; i++)
				{
					if(deviceList[i].contextStr === null) {
						tempStr = "";
						if(!(typeof deviceList[i].contexts === "undefined")) {
							for(k=0; k < deviceList[i].contexts.length; k++)
							{
								for(j=0; j < contextList.length; j++) 
								{
									if(contextList[j].id === deviceList[i].contexts[k]) {
										if(tempStr !== "")
											tempStr += "<br>"
										tempStr += contextList[j].name; //contextList[j].path;
										break;
									}
								}
								
							}
							deviceList[i].contextStr = tempStr;
						}
					}
				}
			}
			catch
			{
				
			}
		}
	}
}
function getplanningTreeShowTreeContext(json, level) {
	var result = null;
	if(g_bPlanningTreeShowDatapointNodes) {
		g_treeviewInitialCollapseList = [];
		result =  getplanningTreeShowTreeContextBuilderWithDatapoints(json, -1, null, level,false);
		
	}
	else
		result =  getplanningTreeShowTreeContextBuilderWithDevices(json, level,false);
	
	
	return result;
}
function getplanningTreeShowTreeContextBuilderWithDatapoints(json, devicesId, deviceList, level, bLastChild) {
	// This is the main code for building Planning Tree with Devices, FBs and datapoints in tree.
	// devicesId: this is the previous context id used for the tree
	var sResult = "", sResult1 = "";
	var i,j, k, index, len, obj;
	var iTotal = 0, iUp = 0, iProvisioned = 0, iUnProvisioned = 0, iDown = 0;
	var devicesNoContext = [];
	var bContinue = false;
	
	try {
		level++;
		if(json === null)
			return "";
		var lastIndex = json.length - 1;
		if(level === 1) {
				sResult = "<ul class=\"treeul\">";  // may have a problem with two campuses
				for(i=0; i < deviceListAll.length; i++)
				{
					if(deviceListAll[i].contexts.length === 0) {
						// later on test if hidden
						devicesNoContext.push(JSON.parse(JSON.stringify(deviceListAll[i])));
					}
				}

		}
		else {
			if(bLastChild)
				sResult = "<ul class=\"treeul treeviewNested treeviewActive\" style=\"border-left: 3px solid #366184;margin-left: -18px;\">";

			else
				sResult = "<ul class=\"treeul treeviewNested treeviewActive\">";
		}
		bLastChild = false;
		
		if(devicesId !== -1) {// add devices node
			// device status count
			sResult1 = "";
			if(deviceList.length > 0) {
				//sResult1 += " [" + json[i].devices.length + " Devices]";
				sResult1 += " [" + deviceList.length + "]";
				if(g_bShowDeviceStatusInTree) {
					sResult1 += "<span id=\"planningTreeContextDeviceStatus_" + devicesId + "\">"
					iTotal = 0; iUp = 0; iProvisioned = 0; iUnProvisioned = 0; iDown = 0;
					for(k=0; k < deviceList.length; k++)
					{
						if(deviceList[k].status.state === "provisioned") {
							if(deviceList[k].status.health === "normal")
								iUp ++;
							else {
								if(deviceList[k].category === "SC")
									iUp ++;
								else 
									iDown ++;
							}
						}
						else 
							iUnProvisioned ++;
					}
					if((iDown > 0) && ((iDown + iUnProvisioned) === deviceList.length))
						sResult1 += '<span class="dot" style="background-color:red"></span>';
					else if(iDown > 0)
						sResult1 += '<span class="dot" style="background-color:yellow"></span>';
					if(iUnProvisioned > 0)
						sResult1 += '<span class="dot" style="background-color:blue"></span>';
					sResult1 += "</span>";
				}
			}


			sResult += "<li class=\"treeli treeviewLiActive treeviewDevices\"><p>";
			sResult += "<button id=\"treeDevicesButton_" + devicesId + "\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
			g_treeviewInitialCollapseList.push("treeDevicesButton_" + devicesId); // used to initially collapse all devices and device nodes 
			sResult += "<a class=\"context-devices\" href=\"#\"></a>";
			sResult += "<span id=\"planningTreeContext_Devices_" + devicesId + "\" onclick=\"treeviewShowContextDevicesInDetailsPane(" + devicesId + ")\">Devices" + sResult1 + "</span></p>";
			sResult += "<ul id=\"treeblocks_" + devicesId + "\" class=\"treeul treeviewNested treeviewActive\">";
			if(deviceList !== null) {
				for(j=0; j < deviceList.length; j++)
				{
					sResult += "<li class=\"treeli";
					if(j === (deviceList.length - 1))
						sResult += " treeviewLiActive";
					sResult += "\"><p>";
					if(deviceList[j].category === "SC") 
						sResult += "<span class=\"treeviewSpanNoChildrenSegmentController\"></span>";
					else {
						//sResult += "<button id=\"treeDeviceButton_" + deviceList[j].id + "\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle1(this,'treeblocks_Device_" + deviceList[j].id +  "','" + deviceList[j].name  + "')\"></button>";
						sResult += "<button id=\"treeDeviceButton_" + deviceList[j].id + "\" class=\"treeviewCaret\" onclick=\"treeviewToggle1(this,'treeblocks_Device_" + deviceList[j].id +  "','" + deviceList[j].name  + "')\"></button>";
						g_treeviewInitialCollapseList.push("treeDeviceButton_" + deviceList[j].id); // used to initially collapse all devices and device nodes 
					}

			
					sResult += treeviewAddDeviceStatusDot("deviceStatus_" + deviceList[j].id, deviceList[j].name, deviceList[j].status.state , deviceList[j].status.health, deviceList[j].category);
					sResult += "<span id=\"planningTreeContext_Device_" + deviceList[j].id;
					sResult += "\" onclick=\"getPlanningTreeShowTreeDatapoints(0, 'Device_" + deviceList[j].id + "', '" + deviceList[j].name + "')\">";
					sResult += deviceList[j].name + "</span></p>"
					sResult += "<ul id=\"treeblocks_Device_" + deviceList[j].id + "\" class=\"treeul treeviewNested treeviewActive\"";
					if(j === (deviceList.length - 1))
						sResult += " style=\"border-left: 3px solid #366184;margin-left: -18px;\"";
					sResult += ">";
					sResult += "</ul></li>";
				}
			}
			sResult += "</ul>";
			sResult += "</li>";
			
		}
		
		for(i=0; i < json.length; i++)
		{
			
			if(json[i].children.length > 0) { 
				
				
				// sort children
				if(json[i].children.length === 1)
					bContinue = false;
				else
					bContinue = true;
				while(bContinue)
				{
					bContinue = false;
					len = json[i].children.length - 1;
					for(k=0; k < len; k++)
					{
						if(json[i].children[k].name.toLowerCase() > json[i].children[k + 1].name.toLowerCase()) {
							bContinue = true;
							obj = {};
							obj = JSON.parse(JSON.stringify(json[i].children[k]));
							json[i].children[k] = JSON.parse(JSON.stringify(json[i].children[k + 1]));
							json[i].children[k + 1] = obj;
						}
					}
				}

				//if(i === lastIndex) {
				if( (i === lastIndex) && (((level === 1) && (devicesNoContext.length === 0)) || (level !== 1))) {
					
					sResult += "<li class=\"treeli treeviewLiActiveLastChild\" ><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
					bLastChild = true;
				}
				else 
					sResult += "<li class=\"treeli treeviewLiActive\"><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
				switch(json[i].contextType.toLowerCase()) {
					case "campus": sResult += "<a class=\"context-campus\" href=\"#\"></a>"; break;
					case "building": sResult += "<a class=\"context-building\" href=\"#\"></a>"; break;
					case "floor": sResult += "<a class=\"context-floor\"  href=\"#\"></a>"; break;
					case "room": sResult += "<a class=\"context-room\"  href=\"#\"></a>"; break;
					case "area": sResult += "<a class=\"context-area\"  href=\"#\"></a>"; break;
				}
				sResult += "<span id=\"planningTreeContext_" + json[i].id + "\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\">" + json[i].name;
				
				sResult += "</span></p>";
				devicesId = -1;
				if(json[i].devices.length > 0)
					devicesId = json[i].id;
				sResult += getplanningTreeShowTreeContextBuilderWithDatapoints(json[i].children, devicesId, json[i].devices, level, bLastChild);
				sResult += "</li>";
			}
			else if (json[i].devices.length > 0) {
				// no child contexts but has devices
				if(i === lastIndex) {
					sResult += "<li class=\"treeli treeviewLiActiveLastChild\" ><p>";
					bLastChild = true;
				}
				else  
					sResult += "<li class=\"treeli treeviewLiActive\" ><p>";
				sResult += "<button id=\"treeContextButton_" + json[i].id + "\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
				
				switch(json[i].contextType.toLowerCase()) {
					case "campus": sResult += "<a class=\"context-campus\" href=\"#\"></a>"; break;
					case "building": sResult += "<a class=\"context-building\"  href=\"#\"></a>"; break;
					case "floor": sResult += "<a class=\"context-floor\" href=\"#\"></a>"; break;
					case "room": sResult += "<a class=\"context-room\"  href=\"#\"></a>"; break;
					case "area": sResult += "<a class=\"context-area\"  href=\"#\"></a>"; break;
				}
				sResult += "<span id=\"planningTreeContext_" + json[i].id + "\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\">" + json[i].name;
				sResult1 = "";
				if(json[i].devices.length > 0) {
					sResult1 += "   [" + json[i].devices.length + "]";
					if(g_bShowDeviceStatusInTree) {
						sResult1 += "<span id=\"planningTreeContextDeviceStatus_" + json[i].id + "\">"
						iTotal = 0; iUp = 0; iProvisioned = 0; iUnProvisioned = 0; iDown = 0;
						for(k=0; k < json[i].devices.length; k++)
						{
							if(json[i].devices[k].status.state === "provisioned") {
								if(json[i].devices[k].status.health === "normal")
									iUp ++;
								else {
									if(json[i].devices[k].category === "SC")
										iUp ++;
									else 
										iDown ++;
								}
							}
							else 
								iUnProvisioned ++;
						}
						if((iDown > 0) && ((iDown + iUnProvisioned) === json[i].devices.length))
							sResult1 += '<span class="dot" style="background-color:red"></span>';
						else if(iDown > 0)
							sResult1 += '<span class="dot" style="background-color:yellow"></span>';
						if(iUnProvisioned > 0)
							sResult1 += '<span class="dot" style="background-color:blue"></span>';
						sResult1 += "</span>";
					}
				}
				
				sResult += "</span></p>";
				
				// add devices node
				sResult += "<ul class=\"treeul treeviewNested  treeviewActive treeviewDevices\"";
				if(bLastChild)
					sResult += " style=\"border-left: 3px solid #366184;margin-left: -18px;\"";
				sResult += ">"
				sResult += "<li class=\"treeli treeviewLiActive treeviewDevices\"><p>";
				sResult += "<button id=\"treeDevicesButton_" + json[i].id + "\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
				g_treeviewInitialCollapseList.push("treeDevicesButton_" + json[i].id); // used to initially collapse all devices and device nodes 
				sResult += "<a class=\"context-devices\" href=\"#\"></a>";
				sResult += "<span id=\"planningTreeContext_Devices_" + json[i].id + "\" onclick=\"treeviewShowContextDevicesInDetailsPane(" + json[i].id + ")\">Devices" + sResult1 + "</span></p>";
				sResult += "<ul id=\"treeblocks_" + json[i].id + "\" class=\"treeul treeviewNested treeviewActive\" style=\"border-left: 3px solid #366184;margin-left: -18px;\">";
				// add device list to tree
				
				for(j=0; j < json[i].devices.length; j++)
				{
					sResult += "<li class=\"treeli treeviewLiActive\"><p>";
					if(json[i].devices[j].category === "SC") 
						sResult += "<span class=\"treeviewSpanNoChildrenSegmentController\"></span>";
					else {
						//sResult += "<button id=\"treeDeviceButton_" + json[i].devices[j].id + "\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle1(this,'treeblocks_Device_" + json[i].devices[j].id +  "','" + json[i].devices[j].name  + "')\"></button>";
						sResult += "<button id=\"treeDeviceButton_" + json[i].devices[j].id + "\" class=\"treeviewCaret\" onclick=\"treeviewToggle1(this,'treeblocks_Device_" + json[i].devices[j].id +  "','" + json[i].devices[j].name  + "')\"></button>";
						g_treeviewInitialCollapseList.push("treeDeviceButton_" + json[i].devices[j].id); // used to initially collapse all devices and device nodes 
					}

					
					sResult += treeviewAddDeviceStatusDot("deviceStatus_" + json[i].devices[j].id, json[i].devices[j].name, json[i].devices[j].status.state , json[i].devices[j].status.health, json[i].devices[j].category);
					sResult += "<span id=\"planningTreeContext_Device_" + json[i].devices[j].id + "\"";
					sResult += "\" onclick=\"getPlanningTreeShowTreeDatapoints(0, 'Device_" + json[i].devices[j].id + "', '" + json[i].devices[j].name + "')\">";
					
					sResult += json[i].devices[j].name + "</span></p>"
					sResult += "<ul id=\"treeblocks_Device_" + json[i].devices[j].id + "\" class=\"treeul treeviewNested treeviewActive\"";
					if(j === (json[i].devices.length - 1)) 
						sResult += " style=\"border-left: 3px solid #366184;margin-left: -18px;\"";
					sResult += ">";
					sResult += "</ul></li>";
				}
				
				sResult += "</ul>";
				sResult += "</li></ul>";
					
				
				sResult += "</li>";
			}
			else { 
				// no child contexts and no devices
				sResult += "<li class=\"treeli\"><p class=\"treeviewNoChildren\">";
				sResult += "<span class=\"treeviewSpanNoChildren\"></span>";
				switch(json[i].contextType.toLowerCase()) {
					case "campus": sResult += "<a class=\"context-campus\" href=\"#\"></a>"; break;
					case "building": sResult += "<a class=\"context-building\"  href=\"#\"></a>"; break;
					case "floor": sResult += "<a class=\"context-floor\" href=\"#\"></a>"; break;
					case "room": sResult += "<a class=\"context-room\"  href=\"#\"></a>"; break;
					case "area": sResult += "<a class=\"context-area\"  href=\"#\"></a>"; break;
				}
				sResult += "<span id=\"planningTreeContext_" + json[i].id + "\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\">" + json[i].name;
				sResult += "</span></p>";
				sResult += "</li>";
			}

		} // for(i=0; i < json.length; i++)
		if(level === 1) {
			// add unassinged devices - devices with no context assigned
			if(devicesNoContext.length > 0) {
				sResult += "<li class=\"treeli treeviewLiActiveLastChild\" ><p>";
				sResult += "<button id=\"treeContextButton__NoContext\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
				sResult += "<span id=\"planningTreeContext__NoContext\" onclick=\"getPlanningTreeShowTreeDetails(0, '_NoContext')\">Un-assigned Devices";
				sResult1 = "";
				if(devicesNoContext.length > 0) {
					sResult1 += "   [" + devicesNoContext.length + "]";
					if(g_bShowDeviceStatusInTree) {
						sResult1 += "<span id=\"planningTreeContextDeviceStatus__NoContext\">"
						iTotal = 0; iUp = 0; iProvisioned = 0; iUnProvisioned = 0; iDown = 0;
						for(k=0; k < devicesNoContext.length; k++)
						{
							if(devicesNoContext[k].status.state === "provisioned") {
								if(devicesNoContext[k].status.health === "normal")
									iUp ++;
								else {
									if(devicesNoContext[k].category === "SC")
										iUp ++;
									else 
										iDown ++;
								}
							}
							else 
								iUnProvisioned ++;
						}
						if((iDown > 0) && ((iDown + iUnProvisioned) === devicesNoContext.length))
							sResult1 += '<span class="dot" style="background-color:red"></span>';
						else if(iDown > 0)
							sResult1 += '<span class="dot" style="background-color:yellow"></span>';
						if(iUnProvisioned > 0)
							sResult1 += '<span class="dot" style="background-color:blue"></span>';
						sResult1 += "</span>";
					}
				}
				
				sResult += "</span></p>";
				
				// add devices node
				sResult += "<ul class=\"treeul treeviewNested  treeviewActive treeviewDevices\"";
				//if(bLastChild)
					sResult += " style=\"border-left: 3px solid #366184;margin-left: -18px;\"";
				sResult += ">"
				sResult += "<li class=\"treeli treeviewLiActive treeviewDevices\"><p>";
				sResult += "<button id=\"treeDevicesButton__NoContext\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
				g_treeviewInitialCollapseList.push("treeDevicesButton__NoContext"); // used to initially collapse all devices and device nodes 
				sResult += "<a class=\"context-devices\" href=\"#\"></a>";
				sResult += "<span id=\"planningTreeContext_Devices__NoContext" + "\" onclick=\"treeviewShowContextDevicesInDetailsPane('_NoContext')\">Devices" + sResult1 + "</span></p>";
				sResult += "<ul id=\"treeblocks_NoContext\" class=\"treeul treeviewNested treeviewActive\" style=\"border-left: 3px solid #366184;margin-left: -18px;\">";
				
				for(j=0; j < devicesNoContext.length; j++)
				{
					sResult += "<li class=\"treeli treeviewLiActive\"><p>";
					if(devicesNoContext[j].category === "SC") 
						sResult += "<span class=\"treeviewSpanNoChildrenSegmentController\"></span>";
					else {
						//sResult += "<button id=\"treeDeviceButton_" + devicesNoContext[j].id + "\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle1(this,'treeblocks_Device_" + devicesNoContext[j].id +  "','" + devicesNoContext[j].name  + "')\"></button>";
						sResult += "<button id=\"treeDeviceButton_" + devicesNoContext[j].id + "\" class=\"treeviewCaret\" onclick=\"treeviewToggle1(this,'treeblocks_Device_" + devicesNoContext[j].id +  "','" + devicesNoContext[j].name  + "')\"></button>";
						g_treeviewInitialCollapseList.push("treeDeviceButton_" + devicesNoContext[j].id); // used to initially collapse all devices and device nodes 
					}
	
					sResult += treeviewAddDeviceStatusDot("deviceStatus_" + devicesNoContext[j].id, devicesNoContext[j].name, devicesNoContext[j].status.state , devicesNoContext[j].status.health, devicesNoContext[j].category);
					sResult += "<span id=\"planningTreeContext_Device_" + devicesNoContext[j].id + "\"";
					sResult += "\" onclick=\"getPlanningTreeShowTreeDatapoints(0, 'Device_" + devicesNoContext[j].id + "', '" + devicesNoContext[j].name + "')\">";
					
					sResult += devicesNoContext[j].name + "</span></p>"
					sResult += "<ul id=\"treeblocks_Device_" + devicesNoContext[j].id + "\" class=\"treeul treeviewNested treeviewActive\"";
					if(j === (devicesNoContext.length - 1)) 
						sResult += " style=\"border-left: 3px solid #366184;margin-left: -18px;\"";
					sResult += ">";
					sResult += "</ul></li>";
				}
				
				sResult += "</ul>";
				sResult += "</li></ul>";
					
				
				sResult += "</li>";
			}
		}
		sResult += "</ul>";
	} catch (err) {
		 sResult = "<ul></ul>"; }
	if(level === 1) {
		sResult = "Sites<br>" + sResult; //"Sites<br><div style=\"padding-left:17px\">" + sResult + "</div>"; 
	}
	return sResult;
}
function getplanningTreeShowTreeContextBuilderWithDevices(json, level, bLastChild) {
	// This is the main code for building Planning Tree which shows devices in detail pane but not in the tree
	var sResult = "";
	var i,j, k, index, len, obj;
	var iTotal = 0, iUp = 0, iProvisioned = 0, iUnProvisioned = 0, iDown = 0;
	var bContinue = false;
	
	try {
		level++;
		if(json === null)
			return "";
		var lastIndex = json.length - 1;
		if(level === 1) {
			//if(json.length === 1)
			//	sResult = "<ul style=\"border-left: 1px solid #366184;margin-left: -17px;\">"; // try height:8px;
			//else
				sResult = "<ul class=\"treeul\">";  // may have a problem with two campuses
		}
		else {
			//if((level === 2) && bLastChild)
			//	sResult = "<ul class=\"treeviewNested treeviewActive\" style=\"border-left: 1px solid #366184;height:0px\">"; // needed as issue on some display with Site line too long
			//else if(bLastChild)
			if(bLastChild)
				sResult = "<ul class=\"treeul treeviewNested treeviewActive\" style=\"border-left: 3px solid #366184;margin-left: -18px;\">";

			else
				sResult = "<ul class=\"treeul treeviewNested treeviewActive\">";
		}
		bLastChild = false;
		
		for(i=0; i < json.length; i++)
		{
			if(json[i].children.length > 0) { 
				// sort children
				if(json[i].children.length === 1)
					bContinue = false;
				else
					bContinue = true;
				while(bContinue)
				{
					bContinue = false;
					len = json[i].children.length - 1;
					for(k=0; k < len; k++)
					{
						if(json[i].children[k].name.toLowerCase() > json[i].children[k + 1].name.toLowerCase()) {
							bContinue = true;
							obj = {};
							obj = JSON.parse(JSON.stringify(json[i].children[k]));
							json[i].children[k] = JSON.parse(JSON.stringify(json[i].children[k + 1]));
							json[i].children[k + 1] = obj;
						}
					}
				}


				if(i === lastIndex) {
					//sResult += "<li class=\"treeviewLiActive\" style=\"border-bottom:0px\"><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
					sResult += "<li class=\"treeli treeviewLiActiveLastChild\" ><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
					bLastChild = true;
				}
				else 
					sResult += "<li class=\"treeli treeviewLiActive\"><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
				switch(json[i].contextType.toLowerCase()) {
					case "campus": sResult += "<a class=\"context-campus\" href=\"#\"></a>"; break;
					case "building": sResult += "<a class=\"context-building\" href=\"#\"></a>"; break;
					case "floor": sResult += "<a class=\"context-floor\"  href=\"#\"></a>"; break;
					case "room": sResult += "<a class=\"context-room\"  href=\"#\"></a>"; break;
					case "area": sResult += "<a class=\"context-area\"  href=\"#\"></a>"; break;
				}
				//sResult += "<img class=\"icon-context-type-building\" src=\"\" width=\"1\" height=\"1\">"; 
					//sResult += "<li class=\"icon1-context-type-building\"></li>";  // Test
					//sResult += "<span class=\"material-icons icon-context-type-building\"></span>";  // Test
				//sResult += "<span class=\"context-icons\">&#x00E;</span>";  // Test
				sResult += "<span id=\"planningTreeContext_" + json[i].id + "\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\">" + json[i].name;
				//sResult += "        (" + json[i].contextType.toLowerCase() + ")";
				if(json[i].devices.length > 0) {
					sResult += " [" + json[i].devices.length + " Devices]";
					if(g_bShowDeviceStatusInTree) {
						iTotal = 0; iUp = 0; iProvisioned = 0; iUnProvisioned = 0; iDown = 0;
						for(k=0; k < json[i].devices.length; k++)
						{
							if(json[i].devices[k].status.state === "provisioned") {
								if(json[i].devices[k].status.health === "normal")
									iUp ++;
								else {
									if(json[i].devices[k].category === "SC")
										iUp ++;
									else 
										iDown ++;
								}
							}
							else 
								iUnProvisioned ++;
						}
						if((iDown > 0) && ((iDown + iUnProvisioned) === json[i].devices.length))
							sResult += '<span class="dot" style="background-color:red"></span>';
						else if(iDown > 0)
							sResult += '<span class="dot" style="background-color:yellow"></span>';
						if(iUnProvisioned > 0)
							sResult += '<span class="dot" style="background-color:blue"></span>';
					}
				}
				sResult += "</span></p>";
				sResult += getplanningTreeShowTreeContextBuilderWithDevices(json[i].children, level, bLastChild);
				sResult += "</li>";
			}
			else { 
				
				sResult += "<li class=\"treeli\"><p class=\"treeviewNoChildren\">";
				switch(json[i].contextType.toLowerCase()) {
					case "campus": sResult += "<a class=\"context-campus\" href=\"#\"></a>"; break;
					case "building": sResult += "<a class=\"context-building\"  href=\"#\"></a>"; break;
					case "floor": sResult += "<a class=\"context-floor\" href=\"#\"></a>"; break;
					case "room": sResult += "<a class=\"context-room\"  href=\"#\"></a>"; break;
					case "area": sResult += "<a class=\"context-area\"  href=\"#\"></a>"; break;
				}
				sResult += "<span id=\"planningTreeContext_" + json[i].id + "\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\">" + json[i].name;
				//sResult += "        (" + json[i].contextType.toLowerCase() + ")";
				if(json[i].devices.length > 0) {
					sResult += "   [" + json[i].devices.length + " Devices]";
					if(g_bShowDeviceStatusInTree) {
						iTotal = 0; iUp = 0; iProvisioned = 0; iUnProvisioned = 0; iDown = 0;
						for(k=0; k < json[i].devices.length; k++)
						{
							if(json[i].devices[k].status.state === "provisioned") {
								if(json[i].devices[k].status.health === "normal")
									iUp ++;
								else {
									if(json[i].devices[k].category === "SC")
										iUp ++;
									else 
										iDown ++;
								}
							}
							else 
								iUnProvisioned ++;
						}
						if((iDown > 0) && ((iDown + iUnProvisioned) === json[i].devices.length))
							sResult += '<span class="dot" style="background-color:red"></span>';
						else if(iDown > 0)
							sResult += '<span class="dot" style="background-color:yellow"></span>';
						if(iUnProvisioned > 0)
							sResult += '<span class="dot" style="background-color:blue"></span>';
					}
				}
				sResult += "</span></p></li>";
			}
		}
		sResult += "</ul>";
	} catch { sResult = "<ul></ul>"; }
	if(level === 1) {
		sResult = "Sites<br>" + sResult; //"Sites<br><div style=\"padding-left:17px\">" + sResult + "</div>"; 
	}
	return sResult;
}


function getPlanningTreeShowDeviceDetails() {

}
function getPlanningTreeShowTreeDevices(id) {
	try {
		var sResult = "", i;
		var list = [];
		var bContinue = false;
		var json, json1;
		document.getElementById("planningPaneDetails").style.display = "inline-block";
		json = getPlanningTreeShowTreeDetailsGetObj(planningList, id, 0);
		if(json === null)
			document.getElementById("planningPaneDetails").innerHTML = "<br>" + json['path'] + "<br><br>No Devices";
		else {
			// sort
			
			while(bContinue)
			{
				bContinue = false;
				for(i=0; i < json.length; i)
				{

				}
			}
			list = json["devices"];
			if(list.length === 0 ){
				document.getElementById("planningPaneDetails").innerHTML = "<br>" + json['path'] + "<br><br>No Devices";
			}
			else {
				for(i = 0; i < list.length; i++)
				{
					
					if(typeof list[i].id !== "number") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					else if (typeof list[i].name != "string") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					else if (typeof list[i].deviceTypeName != "string") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					//sResult += "<tr class=\"planningdevicetableTr\"><td><button class=\"clickabletext\" onclick=\"showDeviceByName(0, '" + list[i].name + "')\">" + list[i].name + "</button></td></tr>"; //ffix
					
					
					sResult += "<tr class=\"planningdevicetableTr\"><td class=\"planningdevicetableTd\">";
					sResult += "<div><canvas id=\"canvas_" + list[i].name +"\" width=\"12\" height=\"12\"></canvas></div>"; 
					

					sResult += "</td><td class=\"planningdevicetableTd\"><button id=\"deviceMenu_" + list[i].name + "\" class=\"clickabletext\"";
					sResult += " onclick=\"menuDevice(1, event," + list[i].id + ", '" + list[i].name  + "', '" + list[i].deviceTypeName  + "', '" + list[i].protocol  + "')\">";
					sResult += list[i].name + "</button></td></tr>"; 
				}
				
				if(sResult !== "") { 
					//sResult = "<hr><div class=\"planningdevicetableDiv\"><table id=\"myTablePlanningTree\" class=\"planningdevicetable\"><tbody>" + sResult + "</tbody></table></div>";
					sResult = "<div class=\"planningdevicetableDiv\"><table id=\"myTablePlanningTree\" class=\"planningdevicetable\"><tbody>" + sResult + "</tbody></table></div>";
					sResult = "<br>" + json['path'] + "<button style=\"margin-left:40px;\" onclick=\"showContextDevices(" + id + ")\">Show Devices Detail</button><br><br>" + sResult;
					document.getElementById("planningPaneDetails").innerHTML = sResult;
					//sortTable(0); 
				}
				if(sResult != "") {
					for(i = 0; i < list.length; i++)
					{
						deviceStatusColorCanvas("canvas_" + list[i].name, list[i].category,list[i].deviceStatus);
						//deviceStatusColor("canvas_" + list[i].id, list[i].deviceStatus);
					}
				}
			}
		}
	}
	catch {}
}
function getPlanningTreeShowTreeDatapoints(mode, id, programmaticPathname) {
	var json;
	var sResult = "";
	var sTemp;
	var bContinue = false;
	var sResults;
	var x, i;
	var treeContext = null;
	try {
		if(programmaticPathname === "")
			return;
		planningDpList = [];
		if(g_planningDpTimerId !== 0)
				clearTimeout(g_planningDpTimerId);
		g_sPlanningTreeDatapointPath = programmaticPathname; // only used for Devices and Datapoints nodes
		document.getElementById("planningContextDetailsDiv").style.visibility = "hidden";
		document.getElementById("planningRefreshButton").style.visibility = "hidden";
		if(mode == 0) {
			// change color of tree context to indicate selected
			if(g_iPlanningPaneSelectedContextId != -1) {
				treeContext = document.getElementById("planningTreeContext_" + g_iPlanningPaneSelectedContextId);
				if(treeContext != null) {
					treeContext.style.backgroundColor = "#366184";
					//treeContext.style.color = "white";
				}
			}
			treeContext = document.getElementById("planningTreeContext_" + id);
			if(treeContext != null) {
				//treeContext.style.color = "red";
				treeContext.style.backgroundColor = "red";
			}
		}
		g_iPlanningPaneSelectedContextId = id;
		document.getElementById("planningPaneDetails").innerHTML = "Getting Datapoint information...";
		getPlanningTreeShowTreeDatapointsRequest(0, programmaticPathname); 
		
	}
	catch {}
}
function getPlanningTreeShowTreeDatapointsRequest(mode, path) {
	try {
 		var url = "/iap/devs/*+name==";
		var iPtr = path.indexOf("/");
		var obj = {}; 
		if(mode > 0)
			path = g_sPlanningTreeDatapointPath;
		iPtr = path.indexOf("/");
		if(iPtr === -1) 
			url += path + "/if/*/*/*";
		else {
			url += path.substr(0, iPtr) + "/if" + path.substr(iPtr);
			url = encodeNameStr(url);
			if(g_iSmartServerVersion >= 320114) {
				iPtr = url.lastIndexOf("/");
				if(iPtr > 0) {
					iPtr ++;
					url = url.substr(0, iPtr) + "*+xifName==" + url.substr(iPtr);
				}
			}
			
		}
		url += "/*"
		if(mode === 3)
			url += "?max_age=0&noxs=true";
		obj.mode = mode;
		obj.path = path;
		if(mode === 0)
			cursorSetWait();
 		requestGetData(obj, url, getPlanningTreeShowTreeDatapointsRequestDataResponse, getPlanningTreeRequestFailure);
	}
	catch (err) {}

}

function getPlanningTreeShowTreeDatapointsRequestProcessWebSocketData(mode, requestUrl, json) {
	var obj = {};
	obj.mode = mode;
	obj.path = g_sPlanningTreeDatapointPath;
	getPlanningTreeShowTreeDatapointsRequestDataResponse(obj, requestUrl, json);
}
function getPlanningTreeShowTreeDatapointsRequestDataResponse(obj, requestUrl, json) {
	// mode: 0=creat table, 1= 2=Websocket, 3= on demandfollowup request, 4=refresh [same as 0 but don't create table]
	// Table data
	try {
		
		var iPtr, i, j, z, index = 0;
		var buttonPathname = "", buttonProgrammaticPathname = "", pathName, protocol = "lon";
		var dpPath = "", value, valueStr, fullPath,z, lon_cfg, temp, id = -1, bRequestFollowupRead = false;
		var bDevice = false, bContinue = true, bContinue1 = false, timestamp1,local,utc, bHasPresets, name1, deviceName = "";
		var bSingleDp = false, sTemp = "";
		var element;
		var content = "<br><br><table id=\"myTable\"><thead><tr><th onclick=\"sortTable(0)\">#</th>";
		var path = obj.path;
		var mode = obj.mode;
		var newPath = path;
		var obj, bLonProtocol = false;;
		var d = new Date;
		var sortIndex = 0;
		var t = d.toTimeString();
		//var date = d.toLocaleDateString();
		//var dates = date.split("/");
		var currentTime = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";//dates[2] + "-" + dates[1] + "-" +  dates[0] + " ";
		iPtr = t.indexOf(" ");
		t = t.substr(0, iPtr);
		currentTime += t;
		if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING) 
			return;
		if(g_sPlanningTreeDatapointPath !== path)
			return;
		if(mode > 0) {
			if(planningDpList.length === 0)
				return;
		}
		if(json.length === 0) {
			if(mode === 0) {
				cursorClearWait();
			}
			document.getElementById("planningPaneDetails").innerHTML = "No Datapoints For this Device";
			return;
		}
		
		if(mode === 0) {
			g_bPlanningShowConfigurationSingleDp = false;
			content += "<th><div style=\"display:flex\"><input type=\"checkbox\" id=\"favoritesCheckbox\" onclick=\"planningFavoritesCheckbox()\">FAV</div></th>";
			content += "<th>Menu</th><th onclick=\"sortTable(3)\">Datapoint Path</th><th onclick=\"sortTable(4)\">Datapoint</th><th onclick=\"sortTable(5)\">Value</th>"; 
			content += "<th onclick=\"sortTable(4)\">Priority</th>";
			sortIndex = 5;
			bLonProtocol = false;
			if(json.length > 1) {
				if(typeof json[0]["lon.cfg"] !== "undefined") 
					bLonProtocol = true;
					
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Units</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Direction</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Type</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">XIF DP Path</th>";
				//content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">DP Properties (Device Type)</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Property</th>";
				if(bLonProtocol)
					content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Property For</th>";
				
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Read-only</th>"
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Monitor Rate</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Monitor Event</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Monitor Throttle</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Monitor Heartbeat</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Monitor Threshold</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Monitor ReceiveTimeout</th>";
				if(bLonProtocol) {
					content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Propagation Throttle</th>";
					content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Propagation Heartbeat</th>";
					content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Propagation Threshold</th>";
				}
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Localization</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Presets</th>";
				if(bLonProtocol)
					content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Description</th>";
				if(!bLonProtocol)
					content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Default</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Initial Value</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Write Initial</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Interface</th>"

			}
			
			content += "</tr></thead><tbody>";
		}
		if(mode === 2) {
			for(i=0; i < json.length; i++)
			{ // check if in
				z = -1; 
				for(j=0; j < planningDpList.length; j++)
				{
					if(json[i].datapointQualifier === planningDpList[j].dpQualifier) {
						json[i].bProcess = true;
						json[i].dpPath = planningDpList[j].dpPath;
						json[i].dpName = planningDpList[j].dpName;
						json[i].pathName = planningDpList[j].pathName;
						json[i].block = planningDpList[j].block;
						json[i].programmaticPathname = planningDpList[j].programmaticPathname; 
						json[i].urlPath = planningDpList[j].urlPath;
						z = j;
						break;
					}
				}
				if(z === -1)
					json[i].bProcess = false;
			}
		}
		else {
			iPtr = path.indexOf("/");
			if(mode === 3) {
				mode = 1;
				bRequestFollowupRead = true;
			}
			
			if(iPtr === -1) {
				bDevice = true;
				
				
			}
			else {
				
			}
		}
		if(mode === 0) {
			planningDpList = [];
			temp = "";
			if(bDevice) {
				id = -1;
				for(i=0; i < deviceListAll.length; i++)
				{
					if(deviceListAll[i].name === path) {
						id = deviceListAll[i].id;
						newPath += " [" + deviceListAll[i].deviceTypeName + " (" + deviceListAll[i].protocol  + ")]";
						protocol = deviceListAll[i].protocol;
						deviceName = deviceListAll[i].name;
						break;
					}
				}
				temp = "<button onclick=\"showDashboard(1, '" + path + "', " + id + ")\" style=\"margin-left:0px\">Dashboard</button>";
			}
			else 
				temp = "<button onclick=\"planningshowDashboard()\" style=\"margin-left:0px\">Dashboard</button>";
			temp += "<button onclick=\"showDashboard(3,'Favorites',-1)\">FAV Dashboard</button>";
			if(bDevice)
				//temp += "<button  onclick=\"showDataLogForDevice('" + g_sPlanningTreeDatapointPath + "','" + g_sPlanningTreeDatapointPath + "',null)\">Logs</button>";
				temp += "<button  onclick=\"showDataLog3('" + g_sPlanningTreeDatapointPath + "','" + g_sPlanningTreeDatapointPath + "',null)\">Logs</button>";
			else if(json.length === 1) {
				buttonPathname = json[0].deviceName + "/" + json[0].blockName + "/" + json[0].blockIndex + "/";
				if(typeof json[0].name === "")
					buttonPathname +=  json[0].datapointName;
				if(json[0].name === null)
					buttonPathname +=  json[0].datapointName;
				else
					buttonPathname +=  json[0].name;
				buttonProgrammaticPathname = json[0].deviceName + "/" + json[0].blockName + "/" + json[0].blockIndex + "/" + json[0].datapointName;
				newPath = buttonPathname;
				temp += "<button onclick=\"showDataLog3('" + buttonPathname + "','" + buttonProgrammaticPathname + "',null)\">Logs</button>";
			}
			if(bDevice) {
				temp += "<button onclick=\"showDeviceDpsByDeviceName(0,'" + deviceName + "')\">Datapoints</button>";
			}
			else {
				temp += "<button  onclick=\"planningshowDpInShowDatapoints(0,'" + buttonPathname + "','" + buttonProgrammaticPathname + "')\">Datapoints</button>";
			}
			temp += "<button id=\"planningDpInfoButton\" "; 
			if(bDevice)
				temp += "onclick=\"showDpInfo1(1,'" + g_sPlanningTreeDatapointPath + "','" + g_sPlanningTreeDatapointPath + "')\"";
			else if(json.length === 1) {
				
				temp += "onclick=\"showDpInfo1(1,'" + buttonPathname + "','" + buttonProgrammaticPathname + "')\"";
			}
			temp += ">DP Info</button>"
			if(bDevice) {
				temp += "<button id=\"testButton_" + g_sPlanningTreeDatapointPath + "\" onclick=\"testDevice(6, this," + id + ", '" + g_sPlanningTreeDatapointPath + "')\">Test</button>";
				temp += "<button  onclick=\"winkDevice(" + id + ", '" + g_sPlanningTreeDatapointPath + "')\"";
				if(protocol !== "lon")
					temp += " disabled";
				temp += ">Wink</button>";
			} 
			if(json.length === 1) 
				temp += "<input type=\"checkbox\" id=\"planningConfigCheckbox\"  onchange=\"treeShowConfiguration()\"";
			else 
				temp += "<input type=\"checkbox\" id=\"planningConfigCheckbox\"  onchange=\"treeShowConfigurationAll()\"";
			if(g_bPlanningShowConfiguration) 
				temp += " checked";
			temp += ">Properties";
			
			temp += "<input type=\"checkbox\" id=\"planningPollCheckbox\"  onchange=\"planningPollCheckBox()\"";
			if(g_bPlanningDpPollingEnabled) 
				temp += " checked";
			temp += ">Poll";
			temp += "<input id=\"planningPollrate\" onchange=\"planningPollCheckBox()\" value=\"" + g_iPlanningPollInterval + "\" size=\"4\"></div>";
			temp += "<button onclick=\"getPlanningTreeShowTreeDatapointsRequest(3, '')\">On Demand</button>";
			temp += "<button onclick=\"subscribeRequest()\">Re-Subscribe</button>";
			
			temp += "<button onclick=\"getPlanningTreeShowTreeDatapointsRequest(1, '')\">Refresh</button>";
				// remove hiddencheckbox only in datapoints view temp += "<input type=\"checkbox\" id=\"hiddencheckbox\"  onchange=\"planningShowHiddenCheckBox()\"";
				//if(g_bPlanningDpPollingEnabled) 
				//	temp += " checked";
				//temp += ">Show Hidden DPs";
			
			
			content = newPath + "<br><br>" + temp + content; //json[0].deviceName + temp + content;
			
		}
			
		for(i=0; i < json.length; i++)
		{
			// a lot of the additions are for favorites view
			if(mode !== 2) {
				dpPath = json[i].blockName + "/" + json[i].blockIndex + "/"
				if(typeof json[i].name !== "undefined"){
					if(json[i].name !== null){
						dpPath += json[i].name;
					}
					else {
						dpPath += json[i].datapointName;
						json[i].name = json[i].datapointName;
					}
				}
				else {
					dpPath += json[i].datapointName;
					json[i].name = json[i].datapointName;
				}
				json[i].dpPath = dpPath;
				json[i].dpName = json[i].name;
				json[i].pathName = json[i].deviceName + "/" + dpPath;
				json[i].block = json[i].blockName + "/" + json[i].blockIndex;
				json[i].programmaticPathname = json[i].deviceName + "/" + json[i].blockName + "/" + json[i].blockIndex + "/" + json[i].datapointName; 
				json[i].urlPath = json[i].deviceName + "/if/" + json[i].blockName + "/" + json[i].blockIndex + "/";
				if(g_iSmartServerVersion >= 320114)
					json[i].urlPath += "*+xifName==";
				json[i].urlPath += json[i].datapointName;
				try {
					json[i].priority = json[i].values.level;
				}
				catch (err) {}
				
			}
			if(mode === 0) {
				try {
					json[i].priority = json[i].values.level;
				}
				catch (err) {}
				try { 
					if(!json[i].hasOwnProperty("hidden")) {
						json[i].hidden = false;
					}
					json[i].unit = "";
					if(json[i].hasOwnProperty("lon.cfg")) {
						lon_cfg = json[i]["lon.cfg"];
						json[i].unit = lon_cfg.unit;
						json[i].hidden = lon_cfg.hidden;
					}
				} catch (err) 	{
					json[i].unit = "";
					json[i].hidden = false;
				} 
			}
			if(typeof json[i].locValue === "number")
				json[i].valueStr = json[i].value.toString();
			else
				json[i].valueStr = JSON.stringify(json[i].value);
			try { 
				if(!(typeof json[i].locValue === "undefined")) {
					json[i].locValue = json[i].value; // GET request
					if(json[i].locValue !== null) {
						if(json[i].locValue !== "")
							if(typeof json[i].locValue === "number")
								json[i].locValueStr = json[i].locValue.toString();
							else
								json[i].locValueStr = JSON.stringify(json[i].locValue);
						}
						else 
							json[i].locValueStr = "";
					}
				else 
					json[i].locValueStr = "";
			} catch (err) {}
			
			try {
				if(typeof json[i].local === "undefined") {
					local = currentTime;
					utc = "";
				}
				else 
					local = json[i].local;

				timestamp1 = local;
				local = timestamp1;
				iPtr = timestamp1.lastIndexOf("[");
				if(iPtr > 0) {
					iPtr = timestamp1.lastIndexOf("-",iPtr);
					if(iPtr > 0) {
						timestamp1 = timestamp1.substr(0, iPtr);
						timestamp1 = timestamp1.replace(/T/g," ");
					}
				}
				json[i].timestampStr = timestamp1;
			}
			catch (err) {}
			try{
				if(typeof json[i].presetValue === "undefined")
					json[i].presetValue = "";
				else if (json[i].presetValue === null)
					json[i].presetValue = "";
			} catch(err) {}
			
			
			
		}
		
		if(mode === 0) {
			bContinue = true;
			while(bContinue)
			{
				bContinue = false;
				for(i=0; i < (json.length - 1); i++)
				{
					if(json[i].dpPath > json[i + 1].dpPath) {
						obj = {};
						obj = JSON.parse(JSON.stringify(json[i]));
						json[i] = JSON.parse(JSON.stringify(json[i + 1]));
						json[i + 1] = obj;
						bContinue = true;
					}
				}
			}
		}
		

		
		for(i=0; i < json.length; i++)
		{
			
			bContinue = false;
			
			dpPath = json[i].dpPath;
			if(mode === 2)
				bContinue = json[i].bProcess;
			else {
				if(bDevice) {
					if(json[i].deviceName === path) {
						bContinue = true;
					}
				}
				else {
					//fullPath = json[i].deviceName + "/" + dpPath;
					//if(fullPath === path)
					if(json[i].programmaticPathname === path)
						bContinue = true;
				}
			}


			if(bContinue) {

				valueStr = JSON.stringify(json[i].locValue);
				if(typeof json[i].presetValue === "undefined") {
					if(json[i].presetValue != null)
						valueStr = json[i].presetValue;
				}
				
				if(mode === 0) {
					planningDpList.push(json[i]);
					index ++; // 3.2 supports hidden flag so don't show hidden datapoints
					content += "<tr><td>" + index.toString() + "</td>";
					pathName = json[i].pathName;
					z = -1;
					// check if dp already in favorites list
					for(j=0; j < favDpList.length; j++ )
					{
						if(json[i].pathName === favDpList[j]. pathName) {
							z = j;
							break;
						}
					}
					content += "<td><input type=\"checkbox\" id=\"fav_" + json[i].pathName + "\" onclick=\"addToFavorites1(1, '" + json[i].pathName + "')\"";
					if(z !== -1)
						content += " checked";
					content += "></td>";
					
					content += "<td><button id=\"dpMenu_" + json[i].pathName + "\" style=\"margin-left:5px;margin-right:5px;\" onclick=\"menuDp1(1, event, ";  // may need to ffixx
					content += "0, ";
					content += i + ", '" + json[i].pathName + "', '" + json[i].programmaticPathname + "')\">...</button></td>";
					
					content += "<td>" + dpPath + "</td><td>" + json[i].name + "</td><td>";
					if(json[i].cat === "out")
						content += "<div id=\"localValue_" + pathName + "\" class=\"treeTdValueDiv\">" + valueStr  + "</div>";
					else if(json[i].cat === "in") {   
						content += "<div class=\"treeTdValueWriteDiv\">";
						content += "<input id=\"localValue_" + pathName + "\" class=\"treeTdValueInput\" size=\"50\" "; 
						bHasPresets = false;
						if(typeof json[i].presets !== "undefined") {
							if(json[i].presets !== null) {
								if(json[i].presets.enabled) {
									if(json[i].presets.map.length > 0) {
										bHasPresets = true;
										content += " list='dpNewValuePresetList_" + pathName + "' value='" + valueStr + "'><datalist id='dpNewValuePresetList_" + pathName + "'>"
										for(k=0; k <json[i].presets.map.length; k++)
										{
											name1 = json[i].presets.map[k].name;
											content += "<option value='" + name1 + "'>"  + name1 + "</option>";
										}
										content += "<option value='" + valueStr + "'>Raw Value</option>";
										content += "</datalist>";
									}
								}
							} 
						}
						if(!bHasPresets) {
							content += " list='dpNewValuePresetList_" + pathName + "' value='" + valueStr + "'><datalist id='dpNewValuePresetList_" + pathName + "'>";
							content += "<option value='" + valueStr + "'>Raw Value</option>";
							content += "</datalist>";
						} 
						content += "<button style=\"margin-left:10px\" onclick=\"inputBoxSendValue1(1, this, event, " + i + ", '" + pathName + "')\">Send</button></div>";
					}
					content += "</td>";
					if(json[i].cat === "out") {
						content += '<td></td>';
					   // tablePaneContent += "<td><span id=\"priority_" + pathName + "\">" + dashboardDpList[i].priority + "</span></td>";
					}
					else { // in
						//content += "<td ><div style=\"display:flex\"><input id=\"priority_" + pathName + "\" value=\"" + json[i].priority + "\" size=\"3\">";
						content += "<td><div class=\"treeTdPriorityDiv\"><select id=\"priority_" + pathName + "\">";
						for(s=1; s < 17; s++)
						{
							content += "<option value=\"" + s + "\"";
							if(json[i].priority === s)
								content += " selected";
							content += ">" + s + "</option>";
						}
						content += "<option value=\"17\"";
						if(json[i].priority === 17)
							content += " selected";
						content += ">" + "Normal" + "</option>";
						content += "</select>"
						content += "<button id=\"dpValueMenu_" + pathName + "\" style=\"margin-left:10px\" onclick=\"menuDpValue(this, " + i + ", '" + json[i].pathName + "')\">...</button></div></td>";
					}
					
					if(json.length > 1) {
						try {
							content += "<td class=\"tableHideCol\">";
							if(bLonProtocol)
								content +=  json[i]["lon.cfg"].unit;
							content +=  "</td>";
							content += "<td class=\"tableHideCol\">" + json[i].cat + "</td>";
							content += "<td class=\"tableHideCol\">" + json[i].type + "</td>";
							content += "<td class=\"tableHideCol\">" + json[i].blockName + "/" + json[i].blockIndex + "/" + json[i].datapointName + "</td>";

							//content += "<td><button class=\"menuDivButton\" onclick=\"showDlaByName1(1,'" + json[i].pathName + "','" + json[i].programmaticPathname + "')\">Show</button></td>";
							content += "<td class=\"tableHideCol\">";
							if(typeof json[i].property !== "undefined") 
								content +=  json[i].property;
							content += "</td>";
							
							if(bLonProtocol) {
								content += "<td class=\"tableHideCol\">";
								if(typeof json[i]["lon.cfg"].relatesTo !== "undefined") {
									content += json[i]["lon.cfg"].relatesTo;
								}
								content += "</td>";
							}
							
							content += "<td class=\"tableHideCol\">";
							
							if(typeof json[i]["read-only"] !== "undefined") 
								content += json[i]['read-only'];
							content += "</td>";
							if(typeof json[i].monitor === "undefined") {
								if(bLonProtocol) {
									content += "<td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td>";
									content += "<td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td>";
									content += "<td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td>";
								}
								else {
									content += "<td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td>";
									content += "<td class=\"tableHideCol\"></td><td class=\"tableHideCol\">";
								}
							}
							else {
								content += "<td class=\"tableHideCol\">" + json[i].monitor.rate + "</td>";
								content += "<td class=\"tableHideCol\">"
								try {
									if(typeof json[i].monitor.event !== "undefined")
										content +=  json[i].monitor.event;
								} catch {}
								content += "</td>"
								content += "<td class=\"tableHideCol\">" + json[i].monitor.throttle + "</td>";
								content += "<td class=\"tableHideCol\">" + json[i].monitor.heartbeat + "</td>";
								content += "<td class=\"tableHideCol\">" + json[i].monitor.threshold + "</td>";
								content += "<td class=\"tableHideCol\">" + json[i].monitor.receiveTimeout + "</td>";
								if(bLonProtocol) {
									content += "<td class=\"tableHideCol\">" + json[i].monitor["lon.cfg"].propagationThrottle + "</td>";
									content += "<td class=\"tableHideCol\">" + json[i].monitor["lon.cfg"].propagationHeartbeat + "</td>";
									content += "<td class=\"tableHideCol\">" + json[i].monitor["lon.cfg"].propagationThreshold + "</td>";
								}
								
							}
							content += "<td class=\"tableHideCol\"><div>"
							try {
								if(typeof json[i].localization !== "undefined") {
									if(json[i].localization === null)
									{}
									else if(typeof json[i].localization === "object") {
										sTemp = JSON.stringify(json[i].localization);
										if(sTemp !== "{}")
											content += sTemp;
									}
									else 
										content += json[i].localization;
									
								}
							} catch {}
							content += "</div></td>";
							content += "<td class=\"tableHideCol\"><div>";
							if(typeof json[i].presets !== "undefined") {
								if(json[i].presets !== null) {
									if(json[i].presets.map.length > 0) {
										content += JSON.stringify(json[i].presets.map);
									}
								}
							}
							content += "<div></td>";
							if(bLonProtocol)
								content += "<td class=\"tableHideCol\"><div>" + json[i].desc + "</div></td>";
							if(!bLonProtocol){
								content += "<td class=\"tableHideCol\"><div>";
								if(typeof json[i].default !== "undefined") {
									if(json[i].default === null)
									{}
									else if(typeof json[i].default === "object")
										content += JSON.stringify(json[i].default);
									else
										content += jon[i].default;
									
								}
									content += "</div></td>";
							}
							content += "<td class=\"tableHideCol\"><div>"
							try {
								if(typeof json[i]["Initial Value"] !== "undefined") {
									if(json[i]["Initial Value"] === null)
									{}
									else if(typeof json[i]["Initial Value"] === "object")
										content += JSON.stringify(json[i]["Initial Value"]);
									else
										content += jon[i]["Initial Value"];
									
								}
							} catch {}
							content += "</div></td>";
							content += "<td class=\"tableHideCol\">"
							try {
								if(typeof json[i]["Write Initial"] !== "undefined") {
									content += json[i]["Write Initial"];
									
								}
							} catch {}
							content += "</td>";
							content += "<td class=\"tableHideCol\">"
							try {
								if(typeof json[i].interfaceType !== "undefined")
									content += json[i].interfaceType;
								
							} catch {}
							content += "</td>";
						}
						catch {}

					}


					content += "</tr>";

					if(json.length === 1) {
						// single datapoint show configuration in separate table
						bSingleDp = true;
						g_bPlanningShowConfigurationSingleDp = true;
						content += "</tbody></table>";
						content += "<br>";
						content += "<div id=\"treeDpProperty\" style=\"display:";
						if(g_bPlanningShowConfiguration)
							content += "inline-block\">";
						else
							content += "none\">";
						
						content += "<hr>";
						content += "<br>Properties:";
						//content += "<button style=\"50px\" onclick=\"showDlaByName1(1,'" + json[i].pathName + "','" + json[i].programmaticPathname + "')\">Device Type DP Properties</button><br>";
						content += "<br>";
						content += "<table id=\"treeDpProperties\"><thead><tr><th class=\"tablePropertyHideCol\">Property</th><th class=\"tablePropertyHideCol\">Value</th></tr></thead><tbody>";
						try {
							content += "<tr><td>Type</td><td>" + json[i].type + "</td></tr>";
							//if(json[i].hasOwnProperty("lon.cfg")) {
							if(typeof json[i]["lon.cfg"] !== "undefined") {
								content += "<tr><td>Units</td><td>" + json[i]["lon.cfg"].unit + "</td></tr>";
							}
							if(typeof json[i]["read-only"] !== "undefined") 
								content += "<tr><td>Read-only</td><td>" + json[i]["read-only"] + "</td></tr>";
							content += "<tr><td>Direction</td><td>" + json[i].cat + "</td></tr>";
							content += "<tr><td>Property</td><td>" + json[i].property + "</td></tr>";
							if(typeof json[i]["lon.cfg"] !== "undefined") {
								if(typeof json[i]["lon.cfg"].relatesTo !== "undefined") {
									content += "<tr><td>Property For</td><td>" + json[i]["lon.cfg"].relatesTo + "</td></tr>";
								}
							}
							if(typeof json[i].desc !== "undefined")
								content += "<tr><td>Description</td><td>" + json[i].desc + "</td></tr>";
							
							if(typeof json[i].monitor !== "undefined") {
								content += "<tr><td>Monitor Poll Rate</td><td>" + json[i].monitor.rate + "</td></tr>";
								content += "<tr><td>Monitor Event</td><td>"
								try {
									if(typeof json[i].monitor.event !== "undefined")
										content +=  json[i].monitor.event;
								} catch {}
								
								content += "</td></tr>";
								content += "<tr><td>Monitor Rate</td><td>" + json[i].monitor.rate + "</td></tr>";
								content += "<tr><td>Monitor Throttle</td><td>" + json[i].monitor.throttle + "</td></tr>";
								content += "<tr><td>Monitor Heartbeat</td><td>" + json[i].monitor.heartbeat + "</td></tr>";
								content += "<tr><td>Monitor Threshold</td><td>" + json[i].monitor.threshold + "</td></tr>";
								content += "<tr><td>Monitor ReceiveTimeout</td><td>" + json[i].monitor.receiveTimeout + "</td></tr>";
								try {
									if(typeof json[i].monitor["lon.cfg"] !== "undefined") {
										content += "<tr><td>Propagation Throttle</td><td>" + json[i].monitor["lon.cfg"].propagationThrottle + "</td></tr>";
										content += "<tr><td>Propagation Heartbeat</td><td>" + json[i].monitor["lon.cfg"].propagationHeartbeat + "</td></tr>";
										content += "<tr><td>Propagation Threshold</td><td>" + json[i].monitor["lon.cfg"].propagationThreshold + "</td></tr>";
									}
								} catch {}
							}
							
							
							try {
								if(typeof json[i].localization !== "undefined") {
									content += "<tr><td>Localization</td><td><div>";
									if(json[i].localization === null)
									{}
									else if(typeof json[i].localization === "object") {
										sTemp = JSON.stringify(json[i].localization);
											if(sTemp !== "{}")
												content += sTemp;
									}
									else 
										content += json[i].localization;
									content +=  "</div></td></tr>";
								}
							} catch {}
							content += "<tr><td>Presets</td><td>";
							try {
								if(typeof json[i].presets !== "undefined") {
									if(json[i].presets !== null) {
										if(json[i].presets.map.length > 0) {
											content += JSON.stringify(json[i].presets.map);
										}
									}
								}
							} catch {}
							content +=  "</td></tr>";
							try {
								if(typeof json[i].default !== "undefined") {
									content += "<tr><td>Default</td><td><div>";
									if(json[i].default === null)
									{}
									else if(typeof json[i].default === "object")
										content += JSON.stringify(json[i].default);
									else
										content += jon[i].default;
									content +=  "</div></td></tr>";
								}
							} catch {}
							try {
								if(typeof json[i]["Initial Value"] !== "undefined") {
									content += "<tr><td>Initial Value</td><td><div>";
									if(json[i]["Initial Value"] === null)
									{}
									else if(typeof json[i]["Initial Value"] === "object")
										content += JSON.stringify(json[i]["Initial Value"]);
									else
										content += jon[i]["Initial Value"];
									content +=  "</div></td></tr>";
								}
							} catch {}
							
							
							try {
								if(typeof json[i]["Write Initial"] !== "undefined") {
									content += "<tr><td>Write Initial</td><td>";
									content += json[i]["Write Initial"];
									content +=  "</td></tr>";
								}
							} catch {}
							if(typeof json[i].interfaceType !== "undefined")
								content += "<tr><td>Interface</td><td>" + json[i].interfaceType + "</td></tr>";
						} catch {}
						
						content += "</tbody></table></div>";
					}

				}
				else {
					if((mode !== 2) || ((mode === 2) && json[i].bProcess)) {
						z = -1;
						for(j=0; j < planningDpList.length; j++)
						{
							if(planningDpList[j].pathName === json[i].pathName) {
								z = j;
								break;
							}
						}
						if(z !== -1) {
							bContinue1 = false;
							if (mode === 1) {
								element = document.getElementById("planningPollCheckbox");
								if(element !== null) {
									if(!element.checked) {
										bContinue1 = true;
									}
								}
							}
							if(isNotEqual(planningDpList[z].value, json[i].value) || bContinue1) {
								planningDpList[z].value = json[i].value;
								planningDpList[z].valueStr = json[i].valueStr;
								planningDpList[z].locValue = json[i].locValue;
								planningDpList[z].locValueStr = json[i].locValueStr;
								planningDpList[z].timestampStr = json[i].timestampStr;
								planningDpList[z].presetValue = json[i].presetValue;
								
								element = document.getElementById("localValue_" + json[i].pathName);
								if(element !== null) {
									if(planningDpList[z].cat === "out")
										element.innerHTML = valueStr;
									else
										element.value = valueStr;
								}
							}
							
							if(mode === 1) { //refresh
								if(isNotEqual(planningDpList[z].values,json[i].values))
									planningDpList[z].values = json[i].values;
								if(typeof json[i].priority === "number") {
									if(planningDpList[z].priority !== json[i].priority) {
										planningDpList[z].priority = json[i].priority;
									}
									element = document.getElementById("priority_" + json[i].pathName);
									if(element !== null) {
										if(Number(element.value) !== json[i].priority)
											element.value = json[i].priority;
									}
									
								}
								
							}
							
						}
						
					}
				}
			}
		}
		if(mode === 0) {
			content += "</tbody></table>";
			document.getElementById("planningPaneDetails").innerHTML = content; 
			
			createRequestString(planningDpList);
			subscribeRequest();
			planningPollCheckBox();
			
		}
		if(mode === 0) {
			if(bSingleDp)
				treeShowConfiguration();
			else
				treeShowConfigurationAll();
			
		}
		if(bRequestFollowupRead) {
			if(g_planningDpTimerId !== 0)
				clearTimeout(g_planningDpTimerId);
			//g_timerId = window.setTimeout("timerHandler()",g_planningDpOnDemandTimerInterval); 
		}
		
		
	}
	catch(err) {}
	if(mode === 0)
		cursorClearWait();
		
}
function getPlanningTreeRequestFailure(mode, requestUrl, json) {
	if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING)
		return;
	if(mode === 0)
		cursorClearWait();
	document.getElementById("planningPaneDetails").innerHTML = "";
}
function getPlanningTreeShowTreeDatapointsUpdatePrioritesResponse(mode, requestUrl, json) {
	// mode: 0=creat table, 1= 2=Websocket, 3= on demandfollowup request, 4=refresh [same as 0 but don't create table]
	// Table data
	try {
		var i, j, z;
		if(!(mode === 23) || (mode === 24))
			return;
		if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING)
			return;
		for(i=0; i < json.length; i++)
		{ // check if in
			z = -1; 
			for(j=0; j < planningDpList.length; j++)
			{
				if(json[i].dpQualifier === planningDpList[j].dpQualifier) {
					if(json[i].cat === "in") {
						if(typeof json[i].values !== "undefined") {
							if((planningDpList[j].priority !== json[i].values.level) 
								|| (planningDpList[j].values.level !== json[i].values.level)
								|| (isNotEqual(planningDpList[j].values.level, json[i].values.level))) {
								
								planningDpList[j].priority = json[i].values.level;
								planningDpList[j].values = JSON.parse(JSON.stringify(json[i].values));
								element = document.getElementById("priority_" + planningDpList[j].programmaticPathname);
								if(element !== null) {
									element.value = json[i].values.level;
								}
							}
						}
					}
					break;
				}
			}
		}
	}
	catch(err) {}
}
function getPlanningTreeShowTreeDetails(mode, id) {
	var json;
	var sResult = "";
	var sTemp;
	var bContinue = false;
	var sResults;
	var x, i;
	var treeContext = null;
	try {
		g_sPlanningTreeDatapointPath = ""; // only used for Devices and Datapoints nodes
		planningDpList = [];
		g_bPollingEnabled = false;
		ivbWsProcessDatapointUpdate = false;
		g_PollingType = 0;
		if(g_planningDpTimerId !== 0)
			clearTimeout(g_planningDpTimerId);

		document.getElementById("planningContextDetailsDiv").style.visibility = "visible";
		document.getElementById("planningRefreshButton").style.visibility = "visible";
		cursorClearWait();
		if(mode == 0) {
			// change color of tree context to indicate selected
			if(g_iPlanningPaneSelectedContextId != -1) {
				treeContext = document.getElementById("planningTreeContext_" + g_iPlanningPaneSelectedContextId);
				if(treeContext != null) {
					treeContext.style.backgroundColor = "#366184";
					//treeContext.style.color = "white";
				}
			}
			treeContext = document.getElementById("planningTreeContext_" + id);
			if(treeContext != null) {
				//treeContext.style.color = "red";
				treeContext.style.backgroundColor = "red";
			}
		}

		g_iPlanningPaneSelectedContextId = id;
		if(id === "_NoContext") {
			document.getElementById("planningPaneDetails").innerHTML = "Un-assigned Devices<br><br>Devices which are not assigned to a Context";
			return; // un-assigned node in tree
		}
		json = getPlanningTreeShowTreeDetailsGetObj(planningList, id, 0);
		if((g_iPlanningTreeShowDevices === 1) || (json.contextType == "CAMPUS") || (json.contextType == "BUILDING")) {  
			getPlanningTreeShowTreeDevices(id);
			
			//showContextDevices(id);
			return;
		}
		else if(g_iPlanningTreeShowDevices === 0) {
			getPlanningTreeShowTreeFloorplan(id);
			//showContextDevices(id);
			return;
		}

		document.getElementById("planningPaneDetails").style.display = "inline-block";
		json = getPlanningTreeShowTreeDetailsGetObj(planningList, id, 0);
		
		if(json === null)
			document.getElementById("planningPaneDetails").innerHTML = "Details<br><br>No Details";
		else {
			// sort
			while(bContinue)
			{
				bContinue = false;
				for(i=0; i < json.length; i)
				{

				}
			}
			for (x in json)
			{
				if(x === "devices") {
					sResult += "<tr><td>Devices</td><td>" + json[x].length + "</td></tr>";
				}
				else if(typeof json[x] === "undefined")
					sResult += "<tr><td>" + x + "</td><td></td></tr>";
				else if (json[x] === null )
					sResult += "<tr><td>" + x + "</td><td></td></tr>";
				else if(json[x] === "undefined")
					sResult += "<tr><td>" + x + "</td><td></td></tr>";
				else if(x === "treeLevel")
					sResult += "<tr><td>Tree Level</td><td>" + json[x] + "</td></tr>"; 
				else if(x === "children")
					sResult += "<tr><td>Number of children</td><td>" + json[x].length + "</td></tr>";
				else if(x === "image")  {
					
					sResult += "<tr><td>images</td><td>" + json[x].length + "</td></tr>";
				}
				else if((typeof json[x] === "object")  || Array.isArray(json[x])) {
					sTemp = JSON.stringify(json[x]);
					sResult += "<tr><td>" + x + "</td><td>" + sTemp + "</td></tr>"; 
				}
				else 
					sResult += "<tr><td>" + x + "</td><td>" + json[x] + "</td></tr>"; 
			}
			if(sResult !== "") {
				sResult = "<table id=\"myTable\"><thead><tr><th>Property</th><th>Value</th></tr></thead><tbody>" + sResult + "</tbody></table>"; 
				sResult = "<br>" + json['path'] + "<br><br>Details<button style=\"margin-left:40px;\" onclick=\"showContextDevices(" + id + ")\">Show Devices</button><br><br>" + sResult;
				sResult += addTopButton();
				document.getElementById("planningPaneDetails").innerHTML = sResult;
				sortTable(0); 
			}
		}
		
	}
	catch {}
	cursorClearWait();
}
function getPlanningTreeShowTreeDetailsGetObj(json, id, level) {
	var i;
	var jsonResult = null;
	level ++;
	if(json === null)
		return null;
	try {
		for(i=0; i < json.length; i++)
		{
			if(json[i].id === id) {
				jsonResult = JSON.parse(JSON.stringify(json[i]));
				break;
			}
			else if (json[i].children !== null) {
				if(json[i].children.length > 0) {
					jsonResult = getPlanningTreeShowTreeDetailsGetObj(json[i].children, id, level);
					if(jsonResult !== null) 
						break;
				}
			}
		}
	}
	catch { jsonResult = null;}
	
	return jsonResult;
}
function getPlanningTreeShowTreeDetailsGetObjPlusFloorplan(json, id, level, image) {
	var i;
	var jsonResult = null;
	level ++;
	if(json === null)
		return null;
	try {
		for(i=0; i < json.length; i++)
		{
			if(json[i].id === id) {
				jsonResult = JSON.parse(JSON.stringify(json[i]));
				if((jsonResult.image.image == null) || (jsonResult.image.image == null)) {
				
					if(image != null)
						jsonResult.image = image;
				}
				break;
			}
			else if (json[i].children !== null) {
				if(json[i].children.length > 0) {
					if(json[i].contextType == "FLOOR") {
						if((json[i].image.image != null) && (json[i].image.image != null)) 
							image = json[i].image;
							image.floorId = json[i].contextualEntityId;
					}
					jsonResult = getPlanningTreeShowTreeDetailsGetObjPlusFloorplan(json[i].children, id, level, image);
					if(jsonResult !== null) 
						break;
				}
			}
		}
	}
	catch { jsonResult = null;}
	
	return jsonResult;
}
function getPlanningTreeShowTreeFloorplan (id) {
	try { 
		var sTemp = "";
		var floorId = -1;
		g_planningFloorplanObjs = {};
		g_planningFloorplanGroups = [];
		document.getElementById("planningPaneDetails").style.display = "inline-block";
		json = getPlanningTreeShowTreeDetailsGetObjPlusFloorplan(planningList, id, 0, null);
		if((json.contextType == "CAMPUS") || (json.contextType == "BUILDING")){
			sTemp = "Floor plans not supported for " + json.contextType + "<br><br>Supported Floorplans: floor, and rooms and areas inside a floor";
			document.getElementById("planningPaneDetails").innerHTML = sTemp;
			return;
		}
		else if(json.contextType == "FLOOR") {
			floorId = json.contextualEntityId;
		}
		else {
			if(json.image != null) 
				floorId = json.image.floorId;
		}
		json.browserFloorId = floorId;
		if(json.image.image === null) {
		//if((json.image.image === null) || (json.image.imageType === null)) {
			document.getElementById("planningPaneDetails").innerHTML = "";
			return;
		}
		if( json.image.imageType === null)
			json.image.imageType = "jpeg"; // workaround for imported context.csv file in planning widget is missing imagetype
		if(( json.image.imageType !== "png") && ( json.image.imageType !== "jpeg")) {
			document.getElementById("planningPaneDetails").innerHTML = ""; // not supported yet
				return;
		}
		if(json.contextualEntityId === null) {
			if( json.image.imageType === "png")
				sTemp = "<img src=\"data:image/png;base64," + json.image.image + "\">";
			else if( json.image.imageType === "jpeg")
				sTemp = "<img src=\"data:image/jpeg;base64," + json.image.image + "\">";
			document.getElementById("planningPaneDetails").innerHTML = sTemp;
		}
		else {
			document.getElementById("planningPaneDetails").innerHTML = "Getting floor plan ....";
			sTemp = "/iap/zones/*+floor.id==" + json.browserFloorId; //json.contextualEntityId;
			requestGetData(json, sTemp, getPlanningTreeShowTreeFloorplanShowPolygons, readFailCallback);
		}

	}
	catch {}
}
function getPlanningTreeShowTreeFloorplanShowPolygons (contextobj, url, json) {
	try { 
		var sTemp = "";
		var obj = {}
		sTemp = "<div id=\"floorplanTitle\">" + contextobj.path;
		sTemp += "<br><br> Getting Floor plan ....</div><br><div id=\"floorplanimageDiv\"><img id=\"floorplanimage\" src=\"data:image/png;base64," + contextobj.image.image + "\" style=\"visibility:hidden\"></div>";
		document.getElementById("planningPaneDetails").innerHTML = sTemp;
		obj.contextobj = JSON.parse(JSON.stringify(contextobj));
		obj.floorplan = JSON.parse(JSON.stringify(json));
		sTemp = "/iap/devs?floorid=" + contextobj.browserFloorId;//contextobj.contextualEntityId;
		requestGetData(obj, sTemp, getPlanningTreeShowTreeFloorplanShowDevices, readFailCallback);

	}
	catch {}
}

function getPlanningTreeShowTreeFloorplanShowDevices (floorplanObjs, url, json1) {
	// had to wait for device list as need time for image to load.
	var i, j,z;
	var coordinates;
	var top=0,left=0;
	var sTemp;
	var detailImage = null; //document.getElementById("planningPaneDetails");
	var offsets = null; //detailDiv.getBoundingClientRect(); 
	var contextualEntityId;
	var x, y, x1, x2, y1, y2; // used to determine full size of canvas and set canas width and lenght
	var coordList = [], obj;
	var contextobj;
	var width = 20;
	var multiplier = 1;
	var color;
	var bContinue = false;
	var floorId = -1;
	var minImageWidth = 800; //px
	var changeColor = "";
	var groupNum;
	var json;
	var r,w;
	var planningCount, count = 0;
	try {
		cursorSetWait();
		if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING)
			return;
		contextobj = floorplanObjs.contextobj;
		contextualEntityId = contextobj.contextualEntityId;
		floorId = contextobj.browserFloorId;
		json = floorplanObjs.floorplan;
		document.getElementById("floorplanTitle").innerHTML = "<div>" + contextobj.path + "</div><div><span id=\"planningDeviceCount\" style=\"visibility:hidden;margin-left:20px\">  [ 0 devices]</span></div>";
		detailImage = document.getElementById("floorplanimage"); //("floorplanimageDiv");
		offsets = detailImage.getBoundingClientRect(); 
		// zoom in if image width is less than 1000
		if(offsets.width > 0 ) {
			if(offsets.width < minImageWidth) {
				multiplier = (minImageWidth / offsets.width);
				multiplier =  Math.ceil(multiplier);
				if(multiplier > 1) {
					detailImage.width = (offsets.width * multiplier);
					detailImage.height = (offsets.height * multiplier);
					offsets = detailImage.getBoundingClientRect(); 
				}
				else 
					multiplier = 1;


			}
		}
		detailImage.style.visibility = "visible";
		
		if(json != null) {
			for(i=0; i < json.length; i++)
			{ // get x1,x2, y1 and y2 to figure out width and height
				bContinue = false;
				obj = {};
				obj.x1 = -1;
				obj.x2 = -1;
				obj.y1 = -1;
				obj.y2 = -1;
				obj.width = 0;
				obj.height = 0;
				if(contextobj.contextType === "FLOOR")
					bContinue = true;
				else if(contextobj.contextualEntityId === json[i].id)
					bContinue = true;
				if(bContinue) {
					coordinates = json[i].polygon.coordinates['0'];
					for(j=0; j < coordinates.length; j++) 
					{
						var cordinate = coordinates[j];
						if(j==0) {
							x1 = x2 = cordinate['0'];
							y1 = y2 = cordinate['1'];
							//sTemp= x1 + "," + y1;
						}
						else {
							
							if(x1 > cordinate['0'])
								x1 = cordinate['0'];
							if(x2 < cordinate['0'])
								x2 = cordinate['0'];
							if(y1 > cordinate['1'])
								y1 = cordinate['1'];
							if(y2 < cordinate['1'])
								y2 = cordinate['1'];
							//sTemp += " " +  cordinate['0'] + "," +  cordinate['1'];
						}
					}
					obj.x1 = x1;
					obj.x2 = x2;
					obj.y1 = y1;
					obj.y2 = y2;
					obj.width = x2 - x1;
					obj.height = y2 - y1;
					
				}
				
				coordList.push(obj);
			}
		
			for(i=0; i < json.length; i++)
			{
				bContinue = false;
				if(contextobj.contextType === "FLOOR")
					bContinue = true;
				else if(contextobj.contextualEntityId === json[i].id)
					bContinue = true;
				if(bContinue) {
					coordinates = json[i].polygon.coordinates['0'];
					sTemp = "";
					x = coordList[i].x1;
					y = coordList[i].y1;
					for(j=0; j < coordinates.length; j++) 
					{
						var coordinate = coordinates[j];
						sTemp += " " +  ((coordinate['0'] - x) * multiplier) + "," +  ((coordList[i].height - (coordinate['1'] - y)) * multiplier);
					}
					x = offsets.x + window.pageXOffset + (coordList[i].x1 * multiplier);
					//y = offsets.y + offsets.height + window.pageYOffset - (obj.height + obj.y1); //offsets.y + window.pageYOffset + coordList[i].y1;
					y = offsets.bottom + window.pageYOffset - ((coordList[i].height + coordList[i].y1) * multiplier);
					//sTemp = "<polygon points=\"" + sTemp + "\" style=\"fill:" + json[i].color + ";stroke:" + json[i].color + ";stroke-width:3\" opacity=\"0.3\"/>";
					sTemp = "<polygon points=\"" + sTemp + "\" style=\"fill:" + json[i].color + ";stroke:black;stroke-width:3\" opacity=\"0.3\" />"
					sTemp = "<div style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:4\"> <svg width=\"" + ( coordList[i].width * multiplier) + "\" height=\"" + (coordList[i].height * multiplier) + "\">" + sTemp + "</svg></div>";				

					document.getElementById("planningPaneDetails").innerHTML += sTemp;
				}
		
			}
		}
		
		if(json1 != null) {
			for(i=0; i < json1.length; i++)
			{
				if(json1[i].hasOwnProperty('floorCoordinates')) {
					//if(json1[i].floorCoordinates.floorId === contextualEntityId) {
					if(json1[i].floorCoordinates.floorId === floorId) {
						count ++;
						var coordinate = json1[i].floorCoordinates;
						// check if more than one device at same location, if so only add one and assign device to group
						z = -1;
						if(json1[i].status.state === "provisioned") {
							if((json1[i].status.health === "normal") || (json1[i].category === "SC"))
								color = "lawngreen";
							else if(json1[i].status.health === "down")
								color = "red";
							else if(json1[i].status.health === "suspect")
								color = "yellow";
							else
								color = "darkred";
						}
						else if(json1[i].status.state === "provisioning")
							color = "cyan";
						else 
							color = "blue";
						for(j=0; j < g_planningFloorplanGroups.length; j++) 
						{
							if((g_planningFloorplanGroups[j].x === coordinate['x']) && (g_planningFloorplanGroups[j].y === coordinate['y'])) {
								g_planningFloorplanGroups[j].deviceList.push(JSON.parse(JSON.stringify(json1[i])));
								if((color == "red") && (g_planningFloorplanGroups[j].color != "red"))
									changeColor = color;
								else if((color == "yellow") && (g_planningFloorplanGroups[j].color != "red") && (g_planningFloorplanGroups[j].color != "yellow"))
									changeColor = color;
								else if((color == "cyan") && (g_planningFloorplanGroups[j].color != "red") && (g_planningFloorplanGroups[j].color != "yellow") && (g_planningFloorplanGroups[j].color != "cyan"))
									changeColor = color;
								else if((color == "blue") && (g_planningFloorplanGroups[j].color != "red") && (g_planningFloorplanGroups[j].color != "yellow") && (g_planningFloorplanGroups[j].color != "cyan")
									&& (g_planningFloorplanGroups[j].color != "blue"))
									changeColor = color;
								else if(color != g_planningFloorplanGroups[j].color)
									changeColor = color;

								if(changeColor !== "") {
									g_planningFloorplanGroups[j].color = changeColor;
									document.getElementById(g_planningFloorplanGroups[j].displayId).fill = changeColor;
								}
								z = j;
								break;
							}
						}
						if(z === -1) {
							var x = offsets.x + window.pageXOffset + (coordinate['y'] * multiplier) - (width / 2);
							var y = offsets.bottom + window.pageYOffset - (coordinate['x'] * multiplier) + (width / 2);
							groupNum = g_planningFloorplanGroups.length;
							sTemp = "<div style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:7\">";
							//sTemp += "<svg height=\"32\" width=\"32\"> <circle id=\"deviceMenu_" + json1[i].name + "\" cx=\"16\" cy=\"16\" r=\"14\" stroke=\"black\" stroke-width=\"3\" fill=\"" + color + "\"";
							//sTemp += " onclick=\"getPlanningFloorplanMenu(" + groupNum + ")\">"
							sTemp += "<svg height=\"32\" width=\"32\">";
							sTemp += "<g><title>" + json1[i].name  + "</title>";
							sTemp += "<circle id=\"deviceMenu_" + json1[i].name + "\"  cx=\"16\" cy=\"16\" r=\"14\" stroke=\"black\" stroke-width=\"3\" fill=\"" + color + "\"";
							sTemp += " onclick=\"getPlanningFloorplanMenu(" + groupNum + ")\" />";
							//sTemp += " onclick=\"menuDevice(2, event," + json1[i].id + ", '" + json1[i].name  + "', '" + json1[i].typeId  + "')\">";
							//sTemp += " /></svg> </div>";
							sTemp += "</g>";
							sTemp += "</svg> </div>";
							
							obj = {};
							obj.displayId = "deviceMenu_" + json1[i].name;
							obj.color = color;
							obj.deviceList = [];
							obj.x = coordinate['x'];
							obj.y = coordinate['y'];
							obj.deviceList.push(JSON.parse(JSON.stringify(json1[i])));
							g_planningFloorplanGroups.push(obj);
							document.getElementById("planningPaneDetails").innerHTML += sTemp;

						}
						
					}
				}
			}
			for(i=0; i < g_planningFloorplanGroups.length; i ++) {
				if(g_planningFloorplanGroups[i].deviceList.length > 1) {
					
					
					if(g_planningFloorplanGroups[i].deviceList.length < 10) {
						x = offsets.x + window.pageXOffset + (g_planningFloorplanGroups[i].y * multiplier) + (width / 2) - 8;
						y = offsets.bottom + window.pageYOffset - (g_planningFloorplanGroups[i].x * multiplier) + (width / 2) + 5;
					}
					else if(g_planningFloorplanGroups[i].deviceList.length < 100) {
						x = offsets.x + window.pageXOffset + (g_planningFloorplanGroups[i].y * multiplier) + (width / 2) - 12;
						y = offsets.bottom + window.pageYOffset - (g_planningFloorplanGroups[i].x * multiplier) + (width / 2) + 5;
					}
					else  {
						x = offsets.x + window.pageXOffset + (g_planningFloorplanGroups[i].y * multiplier) + (width / 2) - 15;
						y = offsets.bottom + window.pageYOffset - (g_planningFloorplanGroups[i].x * multiplier) + (width / 2) + 5;
					}
					sTemp = "<div style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:8; color:black\" onclick=\"getPlanningFloorplanMenu(" + i + ")\">" + g_planningFloorplanGroups[i].deviceList.length + "</div>";
					//sTemp = "<div style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:8; color:white; cursor:default\" onclick=\"getPlanningFloorplanMenu(" + i + ")\">888</div>";
					document.getElementById("planningPaneDetails").innerHTML += sTemp;
					// rename id for groups of devices
					document.getElementById("deviceMenu_" + g_planningFloorplanGroups[i].deviceList[0].name).id = "deviceMenu1_" + i;  // change id for groups so no conflict with devicemenu_<name>
/*
					// keep for future grahics
					if(g_planningFloorplanGroups[i].deviceList.length < 10) {
						r = 10;
						w = (2 * r) +  4;
						x1 = ((w / 2) - 5);
						y1 = ((w / 2) + 5);
						x2 = 6;
						y2 = 0;
					}
					else if(g_planningFloorplanGroups[i].deviceList.length < 100) {
						r = 12;
						w = (2 * r) +  4;
						x1 = ((w / 2) - 8);
						y1 = ((w / 2) + 5);
						x2 = 8;
						y2 = 4;
					}
					else  {
						r = 15;
						w = (2 * r) +  4;
						x1 = ((w / 2) - 12);
						y1 = ((w / 2) + 5);
						x2 = 8;
						y2 = 2;
					}
					var x = offsets.x + window.pageXOffset + (g_planningFloorplanGroups[i].y * multiplier) + (w - x2);
					var y = offsets.bottom + window.pageYOffset - (g_planningFloorplanGroups[i].x * multiplier) - ((w / 4) - y2);
					sTemp = "<div style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:7\">";
					sTemp += "<svg height=\"" + w + "\" width=\"" + w + "\"> <circle id=\"deviceMenu_" + json1[i].name + "\" cx=\"" + (w / 2) + "\" cy=\"" + (w / 2) + "\" r=\"" + r + "\" stroke=\"yellow\" stroke-width=\"3\" fill=\"yellow\" />";
					sTemp += "<text x=\"" + x1 + "\" y=\"" + y1 + "\">" + g_planningFloorplanGroups[i].deviceList.length + "</text></svg></div>"
					document.getElementById("planningPaneDetails").innerHTML += sTemp;
					*/
				}
				
			}
			
		} 
		planningCount = document.getElementById("planningDeviceCount");
		if(planningCount != null) {
			if((contextobj.contextType === "FLOOR") || (count === 0))
				planningCount.innerText = "  [" + count + " devices]";
			else
				planningCount.innerText = "  [" + contextobj.devices.length + "/" + count + " floor devices]";
			planningCount.style.visibility = "visible";
			
		}
	}
	catch {}
	cursorClearWait();
}
function getPlanningFloorplanMenu(groupNum) {
	try {
		var sTemp = "", i, list, sResult = "", jon1, status = "";
		if(groupNum < g_planningFloorplanGroups.length) {
			if(g_planningFloorplanGroups[groupNum].deviceList.length === 1) {
				menuDeviceFloorplan(2, null, g_planningFloorplanGroups[groupNum].deviceList[0].id , g_planningFloorplanGroups[groupNum].deviceList[0].name, g_planningFloorplanGroups[groupNum].deviceList[0].typeId, g_planningFloorplanGroups[groupNum].deviceList[0].protocol);
			}
			else {
				// create Div to show all datapoints
				list = g_planningFloorplanGroups[groupNum].deviceList;
				for(i = 0; i < list.length; i++)
				{
					
					if(typeof list[i].id !== "number") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					else if (typeof list[i].name != "string") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					else if (typeof list[i].deviceTypeName != "string") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					//sResult += "<tr class=\"planningdevicetableTr\"><td><button class=\"clickabletext\" onclick=\"showDeviceByName(0, '" + list[i].name + "')\">" + list[i].name + "</button></td></tr>"; //ffix
					
					
					sResult += "<tr class=\"planningdevicetableTr\"><td class=\"planningdevicetableTd\">";
					sResult += "<div><canvas id=\"canvas_" + list[i].name +"\" width=\"12\" height=\"12\"></canvas></div>"; 
					

					sResult += "</td><td class=\"planningdevicetableTd\"><button id=\"deviceMenu_" + list[i].name + "\" class=\"clickabletext\"";
					//sResult += " onclick=\"menuDevice(1, event," + list[i].id + ", '" + list[i].name  + "', '" + list[i].deviceTypeName  + "')\">";
					sResult += " onclick=\"menuDeviceFloorplan(2, event," + list[i].id + ", '" + list[i].name  + "', '" + list[i].deviceTypeName  + "', '" + list[i].protocol  + "')\">";
					sResult += list[i].name + "</button></td></tr>"; 
				}
				
				if(sResult !== "") { 
					//sResult = "<hr><div class=\"planningdevicetableDiv\"><table id=\"myTablePlanningTree\" class=\"planningdevicetable\"><tbody>" + sResult + "</tbody></table></div>";
					sResult = "<div class=\"planningdevicetableDiv\"><table id=\"myTablePlanningTree\" class=\"planningdevicetable\"><tbody>" + sResult + "</tbody></table></div>";
					//sResult = "<br>" + json['path'] + "<button style=\"margin-left:40px;\" onclick=\"showContextDevices(" + id + ")\">Show Devices Detail</button><br><br>" + sResult;
					
					//sortTable(0); 
				}
				

				for(i=0; i < g_planningFloorplanGroups[groupNum].deviceList.length; i ++)
				{
					
					sTemp += "<div>" + g_planningFloorplanGroups[groupNum].deviceList[i].name;
				}
				
				var x = 0;
				var y = 0;
		
				var menuContent ="<div style=\"display:flex;width:300px\"><div style=\"display:inline-block;float:left\">Devices: ";
				menuContent += g_planningFloorplanGroups[groupNum].deviceList.length;
				menuContent +=  "</div><div style=\"display:inline-block;float:right\"><button class=\"closeButton\" onclick=\"planningMenuCancel()\">X</button></div></div><br>";
				g_bAlwaysIngnoreMouseClick = false;
				g_menuDivXOffset = 35;
				g_menuDivYOffset = 30;
				g_menuDivWidth = 150;
				
				menuContent += "<div>" + sResult + "</div>";
				var menuButton = document.getElementById("deviceMenu1_" + groupNum);
				var offsets;
				
				if(menuButton !== null) {
					offsets = menuButton.getBoundingClientRect(); 
					if((offsets.x + offsets.width + window.pageXOffset + g_menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
						x = offsets.x + window.pageXOffset - g_menuDivWidth - 10; // takes into account viewport (scrolling)
					else
						x = offsets.x + offsets.width + window.pageXOffset + g_menuDivXOffset; // takes into account viewport (scrolling)
					y = offsets.y + window.pageYOffset - g_menuDivYOffset; // takes into account viewport (scrolling)
					document.getElementById("planningDiv").style.left = x.toString() + "px";
					document.getElementById("planningDiv").style.top = y.toString() + "px";
					document.getElementById("planningDiv").innerHTML = menuContent;
					if(sResult != "") {
						for(i = 0; i < list.length; i++)
						{
							status = "normal";
							if(typeof list[i].deviceStatus === "undefined") {
								if(list[i].category === "SC") {
								}
								else if(list[i].status.state === "provisioned") {
									status = list[i].status.health;
								}
								else {
									status = list[i].status.state;
								}

							}
							else {
								status = list[i].deviceStatus;
							}
							deviceStatusColorCanvas("canvas_" + list[i].name, list[i].category, status);
							//deviceStatusColor("canvas_" + list[i].id, list[i].deviceStatus);
						}
					}
					document.getElementById("planningDiv").className = "planningDivShow"; // doesn't currently guaranty that menu is shown in viewport
					g_bInoreMouseClick = true;
					//document.addEventListener("click", planningMenuCancel);
					
				}
				
					
				 
			}
		}

		
	}
	catch {}
}
function getPlanningTreeShowTreeFloorplanShowPolygonsFail (id) {
	try { 
		var 
		sTemp = "<br>Problem getting floorplan info";
		document.getElementById("planningPaneDetails").innerHTML = sTemp;

	}
	catch {}
}
function planningExpandDevicesNodeInTree() {
	var i, n;
	try {
		for(i=0; i < g_treeviewInitialCollapseList.length; i++)
		{
			if(g_treeviewInitialCollapseList[i].indexOf("treeDevicesButton") !== -1) {
				if(g_bPlanningShowDevice) {
					n = document.getElementById(g_treeviewInitialCollapseList[i]);
					if(n !== null) {
						if(!n.parentNode.parentElement.querySelector(".treeviewNested").classList.contains("treeviewActive")) {
							n.parentNode.parentElement.querySelector(".treeviewNested").classList.toggle("treeviewActive");
							//n.parentElement.parentElement.classList.toggle("treeviewLiActive");
							if(n.parentElement !== null ) {
								if(n.parentElement.parentElement !== null) {  
									if(n.parentElement.parentElement.nextSibling !== null) {
										n.parentElement.parentElement.classList.toggle("treeviewLiNotActive");
									}
									else { // last Li 
										n.parentElement.parentElement.classList.toggle("treeviewLiNotActiveLastChild");
									}
								}
							}
							n.classList.toggle("treeviewCaret-down");
						}
					}
				}
				else {
					n = document.getElementById(g_treeviewInitialCollapseList[i]);
					if(n !== null) {
						if(n.parentNode.parentElement.querySelector(".treeviewNested").classList.contains("treeviewActive")) {
							n.parentNode.parentElement.querySelector(".treeviewNested").classList.toggle("treeviewActive");
							//n.parentElement.parentElement.classList.toggle("treeviewLiActive");
							if(n.parentElement !== null ) {
								if(n.parentElement.parentElement !== null) {  
									if(n.parentElement.parentElement.nextSibling !== null) {
										n.parentElement.parentElement.classList.toggle("treeviewLiNotActive");
									}
									else { // last Li 
										n.parentElement.parentElement.classList.toggle("treeviewLiNotActiveLastChild");
									}
								}
							}
							n.classList.toggle("treeviewCaret-down");
						}
					}
				}
			}
		}

	}
	catch(err) {}
	if(g_bPlanningShowDevice) {
		g_bPlanningShowDevice = false;
		document.getElementById("planningTreeShowDevicesButton").innerHTML = "Hide All Devices"
	}
	else {
		g_bPlanningShowDevice = true;
		document.getElementById("planningTreeShowDevicesButton").innerHTML = "Show All Devices"
	}

}
function planningFavoritesCheckbox() {
	try {
		var checked,i;
		if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
			checked = document.getElementById("favoritesCheckbox").checked;
			for(i=0; i < planningDpList.length; i ++)
			{
				document.getElementById("fav_" + planningDpList[i].pathName).checked = checked;
				addToFavorites1(1, planningDpList[i].pathName);
			}
		}
	}
	catch {}
}
function planningFavoritesReassign() {
	try { 
		var i, j;
		if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
			if((planningDpList.length > 0) && (g_sPlanningTreeDatapointPath !== "")) {
				checked = document.getElementById("favoritesCheckbox").checked;
				for(i=0; i < planningDpList.length; i ++)
				{
					for(j=0; j < favDpList.length; j++ )
					{
						if(planningDpList[i].pathName === favDpList[j]. pathName) {
							document.getElementById("fav_" + planningDpList[i].pathName).checked = true;
							break;
						}
					}
					
					
				}
			}
		}
	}
	catch {}
}
function planningPollCheckBox() {
	var pollRate = document.getElementById("planningPollrate");
	var min;
	if(g_idpGetRequestIndex === -1)
		return;
	if(g_dpGetRequestArr[0] === "") 
		return;
	if(pollRate === null)
		return;
	if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING)
		return;
	pollRate = pollRate.value;

	if(pollRate === "") {
		alert("Error: Invalid poll rate value please enter a number (2 or greater)\r\n\r\n" + pollRate);
		return;
	}
	if(isNaN(pollRate)) {
		alert("Error: Invalid poll rate value please enter a number (2 or greater)\r\n\r\n" + pollRate);
		return;
	}
	g_iPlanningPollInterval = document.getElementById("planningPollrate").value;
	
	
	if(planningDpList.length > 0) { 
		if(document.getElementById("planningPollCheckbox").checked) {
			g_bPlanningDpPollingEnabled = true;
			pollRate  = Number(pollRate );
			if(isNaN(pollRate ))
				return;
			g_iPollRate = pollRate;
			g_iPollingRequestCountMax = pollRate;
			min = Math.ceil(planningDpList.length / g_iMaxOfDpsToPollPerInterval);
			if(pollRate < (min * g_iBackgroundPollingRequestCountMax)) 
				g_iPollingRequestCountMax = min + 1;
			g_PollingType = g_iMainDisplayMode;
			//if(g_sWebSocketSubscribePayload !== g_sWebSocketSubscribePayload_oldvalue)
			//	subscribeRequest();
			g_iBackgroundPollingRequestCount = 0; // wait as most time you are just moving back and forth to different DPs in the tree
			g_idpGetRequestIndex = 0;
			g_bPollingEnabled = true;
			
			ivbWsProcessDatapointUpdate = true;
			try {
				// ivGetDeviceList(); // IOT get device list later
				if(g_timerId === 0)
					g_timerId = window.setInterval("timerHandler()", g_iTimerInterval);
			} catch (err) {} 
		}
		else {
			g_bPlanningDpPollingEnabled = false;
			g_bPollingEnabled = false;
			ivbWsProcessDatapointUpdate = false;
			g_PollingType = 0;
		}
	}
}
function planningshowDashboard() {
	dashboardDpList = JSON.parse(JSON.stringify(planningDpList));
	//showDashboard(0, "", -1);
	showDashboard(4, "", -1);
}
function planningshowDpInShowDatapoints(mode,pathname, programmaticPathname) {
	var pathItems;
	var url = "";
	try {
		pathItems = pathname.split("/");
		clearDpFilter(2,0,0);
		g_oDpFilter.device = pathItems[0];
		if(pathItems.length > 3){
			g_oDpFilter.blockName = pathItems[1];
			g_oDpFilter.blockIndex = pathItems[2];
			g_oDpFilter.datapointName = pathItems[3];
		}
		
		showAllDps(6);
		g_iMainDisplayMode = DISPLAYMODE_DPS;
		document.getElementById("displayLabel").innerHTML = "Device Datapoints: " + pathname;
		dpList = [];
		ivbWsProcessDatapointUpdate = true;
		pathItems = programmaticPathname.split("/");
		url = "/iap/devs/*+name==" + pathItems[0] + "/if/" + pathItems[1] + "/" + pathItems[2] + "/" + pathItems[3] + "/*";
		url = encodePathString(url);
		getOnDemandDpValues(0, url);
	}
	catch (err) {}
}
function  showPlanningTree() {
	showPlanningTreePane(0)
}
function showPlanningTreePane(mode) {
	// mode: 4, show planning tree, get device list and then get planning data
	var i, element, color="lawngreen";
	var paneTitle = "<label>Planning</label><button id=\"planningTreeShowDevicesButton\" style=\"margin-left:10px;width:130px\" onclick=\"planningExpandDevicesNodeInTree()\">";
	var displayObj = null;
	if(g_bPlanningShowDevice)
		paneTitle += "Show All Devices"
	else 
		paneTitle += "Hide All Devices"
	paneTitle += "</button>";
	savePrevousHtmlContent();
	if(mode === 4)
		initializeDisplay(4);
	else
		initializeDisplay();
	g_iMainDisplayMode = DISPLAYMODE_PLANNING;
	paneTitle += "<button id=\"planningRefreshButton\" onclick=\"showPlanningRefresh(1)\" style=\"float:right\">Refresh</button><button onclick=\"showPlanningRefresh(0)\" style=\"float:right\">Refresh All</button>";
	paneTitle += "<div id=\"planningContextDetailsDiv\" style=\"display:inline-block;float:right;margin-left:300px\">";
	paneTitle += "<input type=\"radio\" id=\"planningTreeRadioButtonDevice\" name=\"planningTreeRadioButton\" onclick=\"showPlanningTreeDetails(this.value)\" value=\"0\"";
	if(g_iPlanningTreeShowDevices === 0)
		paneTitle += " checked";
	paneTitle += "> Floorplan (all Devices) ";
	paneTitle += "<input type=\"radio\" id=\"planningTreeRadioButtonDevice\" name=\"planningTreeRadioButton\" onclick=\"showPlanningTreeDetails(this.value)\" value=\"1\"";
	if(g_iPlanningTreeShowDevices === 1)
		paneTitle += " checked";
	paneTitle += "> Context Devices ";
	paneTitle += "<input type=\"radio\" id=\"planningTreeRadioButtonContextDetails\" name=\"planningTreeRadioButton\" onclick=\"showPlanningTreeDetails(this.value)\" value=\"2\"";
	if(g_iPlanningTreeShowDevices === 2)
		paneTitle += " checked";
	paneTitle += "> Context Details</div>";
	
	var paneContent = "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting Planning and device Info ...</span></div>";
	document.getElementById("main-Header").innerHTML = paneTitle;
	document.getElementById("main").innerHTML = paneContent;
	if(mode === 4)
		return;
	if(g_sPlanningPaneContent !== "") {
		document.getElementById("main").innerHTML = g_sPlanningPaneContent;
		//if((g_sPlanningPaneContent !== "") && (planningDpList.length === 0) && (g_iPlanningPaneSelectedContextId.indexOf("Device_") !== 0)) {
		if(g_sPlanningPaneContent !== "") {
			if(planningDpList.length !== 0) 
				document.getElementById("planningContextDetailsDiv").style.visibility = "hidden";
			else {
				if(typeof g_iPlanningPaneSelectedContextId === "string") {
					if(g_iPlanningPaneSelectedContextId.indexOf("Devices_") === 0) 
						document.getElementById("planningContextDetailsDiv").style.visibility = "hidden";
				}

			}
			//document.getElementById("planningRefreshButton").style.visibility = "hidden";
		}
		planningFavoritesReassign();
		// check if device status changed while looking at other view, ifso update tree
		for(i=0; i < deviceListAll.length; i++)
		{
			if(typeof deviceListAll[i].statusChanged !== "undefined") {
				if(deviceListAll[i].statusChanged) {
					element = document.getElementById("deviceStatus_" + deviceListAll[i].id);
					if(element != null) {
						if(deviceListAll[i].category !== "SC")
							color = deviceStatusColor (status);
						element.style.backgroundColor = color;
						treeUpdateContextDeviceStatus(-1, deviceListAll[i].id);
					}
				}
			}
		}
		//reenable checkboxes
		element = document.getElementById("planningConfigCheckbox");
		if(element !== null) {
			if(g_bPlanningShowConfiguration)
				element.checked = true;
/*				
			if(g_bPlanningShowConfigurationSingleDp)
				treeShowConfiguration();
			else
				treeShowConfigurationAll();*/
		}
		element = document.getElementById("planningPollrate");
		if(element !== null)
			element.value = g_iPlanningPollInterval;
		element = document.getElementById("planningPollCheckbox");
		if(element !== null) {
			if(g_bPlanningDpPollingEnabled) {
				element.check = true;
				if(planningDpList.length > 0) {
					createRequestString(planningDpList);
					subscribeRequest();
					planningPollCheckBox();
				}
			}
		}
				
		return;
	}
	if(planningList !== null) {
		if(planningList.length > 0) {
			getplanningTreeShowTree(1);
			cursorClearWait();
			if(g_iPlanningPaneSelectedContextId != -1) {
				// add focus code
				getPlanningTreeShowTreeDetails(0, g_iPlanningPaneSelectedContextId);
			}
			else {
				displayObj = document.getElementById("planningPaneDetails");
				if(displayObj != null) {
					displayObj.innerHTML = "No Context Selected";
				}
			}
			return;
		}
	}
	getPlanningTree();
	
}
function showPlanningRefresh(mode) {
	try {
		var element = null;
		planningList = [];
		g_iPlanningPaneSelectedContextId = -1;
		g_bPlanningShowDevice = true;
		element = document.getElementById("planningTreeShowDevicesButton");
		if(element !== null) 
			element.innerHTML = "Show All Devices";
	
		if(mode === 0) {
			cursorSetWait();
			getDeviceListOnlyDontDisplay();
		}
		else
			showPlanningTree();
	} catch {}
}
function treeShowConfiguration() {
	var element = document.getElementById("planningConfigCheckbox");
	var element1 = document.getElementById("treeDpProperty");
	try {
		if(element !== null) {
			g_bPlanningShowConfiguration = element.checked;
			if(element1 !== null) {
				if(g_bPlanningShowConfiguration) {
					element1.style.display = "inline-block";
				}
				else {
					element1.style.display = "none";
				}
				
			}
		}
	}
	catch {}
}
function treeShowConfigurationAll() {
	var i;
	var element = document.getElementById("planningConfigCheckbox");
	var nodes = null;
	try {
		if(element !== null) {
			g_bPlanningShowConfiguration = element.checked;
			nodes = document.getElementsByClassName("tableHideCol");
			for(i=0; i < nodes.length; i++)
			{
				if(g_bPlanningShowConfiguration)
					nodes[i].style.display = "table-cell";
				else 
					nodes[i].style.display = "none";
			}
			
		}
	}
	catch {}
}
function treeviewShowDatapoints(n) {
	//fixxxx
}
function treeviewToggle(n) {
	try {
		n.parentNode.parentElement.querySelector(".treeviewNested").classList.toggle("treeviewActive");
		//n.parentElement.parentElement.classList.toggle("treeviewLiActive");
		if(n.parentElement !== null ) {
			if(n.parentElement.parentElement !== null) {  
				if(n.parentElement.parentElement.nextSibling !== null) {
					n.parentElement.parentElement.classList.toggle("treeviewLiNotActive");
				}
				else { // last Li 
					n.parentElement.parentElement.classList.toggle("treeviewLiNotActiveLastChild");
				}
			}
		}
		n.classList.toggle("treeviewCaret-down");
	} catch {}
}
function treeviewToggle1(n, displayId, path) {
	try {
		var url;
		var element = document.getElementById(displayId);
		if(!n.classList.contains("treeviewCaret-down")) {
			// only do if currently node collapsed
			if(element !== null) {
				if(element.innerHTML === "") {
					// need to get child data
					if(path.indexOf("/") === -1) {
						// device
						cursorSetWait();
						path = encodeNameStr(path);
						url = "https://" + location.hostname + "/iap/devs/*+name==" + path + "/if/*/*/*/*";
						requestGetData(displayId, url, treeViewGetDeviceDatapointsResponse, treeViewGetFailResponse);
						
					}
				}
			}
		}
		n.parentNode.parentElement.querySelector(".treeviewNested").classList.toggle("treeviewActive");
		//n.parentElement.parentElement.classList.toggle("treeviewLiActive");
		if(n.parentElement !== null ) {
			if(n.parentElement.parentElement !== null) {  
				if(n.parentElement.parentElement.nextSibling !== null) {
					n.parentElement.parentElement.classList.toggle("treeviewLiNotActive");
				}
				else { // last Li 
					n.parentElement.parentElement.classList.toggle("treeviewLiNotActiveLastChild");
				}
			}
		}
		n.classList.toggle("treeviewCaret-down");
	} catch {}
}
function treeViewGetDeviceDatapointsResponse(mode, requestUrlString, json){
	var element,obj, i, bContinue, content = "";
	if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING) 
		return;
	if(mode === "")
		return;
	cursorClearWait()
	try {
		if(json.length === 0)
			return;
		var element = document.getElementById(mode);
		if(element !== null) {
			//sort datapoints
			for(i=0; i < json.length; i++) 
			{
				json[i].dpPath = json[i].blockName +  "/" + json[i].blockIndex +  "/" + json[i].datapointName;
				json[i].dpBlockPath = json[i].blockName +  "/" + json[i].blockIndex +  "/";
				json[i].path = json[i].deviceName + "/" + json[i].dpPath;
				json[i].pathName = json[i].deviceName + "/" + json[i].blockName +  "/" + json[i].blockIndex +  "/";
				if(typeof json[i].name === "undefined") {
					json[i].pathName += json[i].datapointName;
					json[i].dpBlockPath += json[i].datapointName;
				}
				else if(json[i].name === null) {
					json[i].pathName += json[i].datapointName;
					json[i].dpBlockPath += json[i].datapointName;
				}
				else { 
					json[i].pathName += json[i].name;
					json[i].dpBlockPath += json[i].name;
				}
			}
			bContinue = true;
			while(bContinue)
			{
				bContinue = false;
				for(i=0; i < (json.length - 1); i++) 
				{
					if(json[i].path > json[i + 1].path) {
						obj = JSON.parse(JSON.stringify(json[i]));
						json[i] = JSON.parse(JSON.stringify(json[i + 1]));
						json[i + 1] = obj;
						bContinue = true;
					}
				}
			}
			for(i=0; i < json.length; i++) 
			{
				if(false) { //i === (json.length - 1)) {
					//content += "<li class=\"treeli treeviewLiActiveLastChild\">" + json[i].dpPath + "</li>";
					content += "<li class=\"treeli\"><p class=\"treeviewNoChildren\">";
					content += "<span id=\"planningTreeContextDp_" + json[i].path + "\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].path + ")\">" + json[i].dpPath;
					content += "</span></p></li>";
				}
				else {
					//content += "<li class=\"treeli treeviewLiActive\">" + json[i].dpPath + "</li>";
					content += "<li class=\"treeli\"><p class=\"treeviewNoChildren\">";
					content += "<span id=\"planningTreeContext_DeviceDp_" + json[i].path + "\"";
					//content += " onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].path + ")\">";
					content += "\" onclick=\"getPlanningTreeShowTreeDatapoints(0, 'DeviceDp_" + json[i].path + "', '" + json[i].path + "')\">";
					content += json[i].dpBlockPath; //json[i].dpPath; //json[i].pathName;
					content += "</span></p></li>";
				}
			}
			element.innerHTML = content;
		} 
	}
	catch (err) {}
}
function treeViewGetFailResponse(mode, requestUrlString, json) {
	cursorClearWait()
}
function treeviewAddDeviceStatusDot(id, name, state, health, category) {
	var str = "lawngreen";
	try {
		if(state === "provisioned") {
			if(health === "normal")
				str = "lawngreen";
			else {
				if(category === "SC")
					str = "lawngreen";
				else 
					str = "red";
			}
		}
		else if(state === "provisioning") 
			str = "cyan";
		else 
			str = "blue";
	}
	catch (err) {}
	if(category === "SC")
		str = '<span id=\"' + id + '\" class="treeviewDeviceSquare" style="background-color:' + str + '"';
	else
		str = '<span id=\"' + id + '\" class="treeviewDeviceDot" style="background-color:' + str + '"';

	str += " onclick=\"getPlanningTreeShowTreeDatapoints(0, 'Device_" + id + "', '" + name + "')\"></span>";

	return str;
}
function treeviewNodesCollapseNodesInInialCollapseList() {
	var i, n, bExpandAllDevices = true;
	try {
		// only collapse if context is available
		if(planningList.length > 0)
			bExpandAllDevices = false;
		else {
			for(i=0; i < deviceListAll.length; i++)
			{
				if(deviceListAll[i].contexts.length > 0) {
					bExpandAllDevices = true;
					break;
				}
			}
		}

		
		for(i=0; i < g_treeviewInitialCollapseList.length; i++)
		{
			n = document.getElementById(g_treeviewInitialCollapseList[i]);
			if(!bExpandAllDevices || (bExpandAllDevices && (g_treeviewInitialCollapseList[i].indexOf("treeDeviceButton") !== -1))) {
				if(n !== null) {
					n.parentNode.parentElement.querySelector(".treeviewNested").classList.toggle("treeviewActive");
					//n.parentElement.parentElement.classList.toggle("treeviewLiActive");
					if(n.parentElement !== null ) {
						if(n.parentElement.parentElement !== null) {  
							if(n.parentElement.parentElement.nextSibling !== null) {
								n.parentElement.parentElement.classList.toggle("treeviewLiNotActive");
							}
							else { // last Li 
								n.parentElement.parentElement.classList.toggle("treeviewLiNotActiveLastChild");
							}
						}
					}
					//n.classList.toggle("treeviewCaret-down");
					if(g_treeviewInitialCollapseList[i].indexOf("treeDeviceButton") === -1)
						n.classList.remove("treeviewCaret-down");
				}
			}
		}
		
		if(bExpandAllDevices) {
			g_bPlanningShowDevice = false;
			document.getElementById("planningTreeShowDevicesButton").innerHTML = "Hide All Devices"
		}
	}
	catch(err) {}
}
function treeviewfindContextObj(id, objList) {
	result = null;
	var i;
	try {
		if(objList === null)
			return result;
		for(i=0; i < objList.length; i ++)
		{
			if(objList[i].id === id) {
				result = JSON.parse(JSON.stringify(objList[i]));
				return result;
			}
			else if(objList[i].children.length > 0) {
				result = treeviewfindContextObj(id, objList[i].children)
				if(result !== null)
					return result;
			}
		}
	}
	catch (err) {result = null;}
	return result;

}
function treeUpdateContextDeviceStatus(index, deviceId) {
	var i, j, z = -1, z1 = -1, contextId, contextObj, iTotal, iUp, iDown, iUnProvisioned;
	var status, element, sResult = "";
	try {
		if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING)
			return;
		if((deviceListAll.length === 0) || (planningList.length === 0))
			return;
		if(index !== -1) {
			if(index < deviceListAll.length) {
				if(deviceListAll[index].id === deviceId)
					z = index;
			}
		}
		if(z === -1) {
			for(i=0; i < deviceListAll.length; i ++)
			{
				if(deviceListAll[i].id === deviceId) {
					z = i;
					break;
				}
			}
		}
		if(z !== -1) {
			for(i=0; i < deviceListAll[z].contexts.length; i ++)
			{
				contextId = deviceListAll[z].contexts[i];
				contextObj = treeviewfindContextObj(contextId, planningList);
				if(contextObj !== null) {
					element = document.getElementById("planningTreeContextDeviceStatus_" + contextObj.id);
					if(element != null) {
						sResult = "";
						iTotal = contextObj.devices.length; iUp = 0; iDown = 0; iUnProvisioned = 0;
						for(j=0; j < contextObj.devices.length; j ++)
						{
							for(k=0; k < deviceListAll.length; k++)
							{
								if(contextObj.devices[j].id === deviceListAll[k].id) {
									if(deviceListAll[k].status.state === "provisioned") {
										if(deviceListAll[k].status.health === "normal")
											iUp ++;
										else {
											if(deviceListAll[k].category === "SC")
												iUp ++;
											else 
												iDown ++;
										}
									}
									else 
										iUnProvisioned ++;
									break;
								}
							}
						}
						if((iDown > 0) && ((iDown + iUnProvisioned) === iTotal))
							sResult += '<span class="dot" style="background-color:red"></span>';
						else if(iDown > 0)
							sResult += '<span class="dot" style="background-color:yellow"></span>';
						if(iUnProvisioned > 0)
							sResult += '<span class="dot" style="background-color:blue"></span>';
						element.innerHTML = sResult;
					}
					
					
				}
			}
		}

	}
	catch (err) {}

}
function treeviewShowContextDevicesInDetailsPane(contextId){
	
	var url = "";
	
	var treeContext = null;
	if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING) {
		return;
	}
	
	try {
		
		planningDpList = [];
		if(g_planningDpTimerId !== 0)
				clearTimeout(g_planningDpTimerId);
		g_sPlanningTreeDatapointPath =""; // only used for Devices and Datapoints nodes
		document.getElementById("planningContextDetailsDiv").style.visibility = "hidden";
		document.getElementById("planningRefreshButton").style.visibility = "hidden";
		
		// change color of tree context to indicate selected
		if(g_iPlanningPaneSelectedContextId != -1) {
			treeContext = document.getElementById("planningTreeContext_" + g_iPlanningPaneSelectedContextId);
			if(treeContext != null) {
				treeContext.style.backgroundColor = "#366184";
				//treeContext.style.color = "white";
			}
		}
		g_iPlanningPaneSelectedContextId = "Devices_" + contextId;
		treeContext = document.getElementById("planningTreeContext_" + g_iPlanningPaneSelectedContextId);
		if(treeContext != null) {
			//treeContext.style.color = "red";
			treeContext.style.backgroundColor = "red";
		}
		
	}
	catch(err) {}

	if(contextId === -1) {
		document.getElementById("planningPaneDetails").innerHTML = "No Devices";
		return;
	}
	if((deviceListAll !== null) && (planningList !== null)) {
		//if((deviceListAll.length > 0) && (planningList.length > 0)) {
		if(deviceListAll.length > 0) {
			if(deviceTypeList.length === 0){
				url = "/iap/devTypes/*?short=false&sortBy=name&sortOrder=asc";
				requestGetData(contextId, url, treeviewShowContextDevicesInDetailsPaneDeviceTypeResponse, getPlanningTreeRequestFailure);
			}
			else 
				treeviewShowContextDevicesInDetailsPaneShow(contextId);
		}
	}
}
function treeviewShowContextDevicesInDetailsPaneDeviceTypeResponse(mode, url, json) {
	try {
		
		if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING)
			return;

		cursorClearWait();
		deviceTypeList = json;
		treeviewShowContextDevicesInDetailsPaneShow(mode);
	}
	catch(err) {}
}

function treeviewShowContextDevicesInDetailsPaneShow(contextId) {

	var paneContent = "";
	var i,j,k, path, sTemp, obj;;
	var contextPath = "";
	var tempStr;
	var iTotal = 0, iUp = 0, iProvisioned = 0, iUnProvisioned = 0, iDown = 0;
	var contextObj = null;
	var treeContext = null;
	if((deviceListAll !== null) && (planningList !== null)) {
		//if((deviceListAll.length > 0) && (planningList.length > 0)) {
		if(deviceListAll.length > 0) {
			try {
				if(contextId === "_NoContext") {
					// unassigned devices
					contextObj = {};
					contextObj.path = "Un-assigned Devices";
					contextObj.devices = [];
					for(i= 0; i < deviceListAll.length; i ++)
					{
						if(deviceListAll[i].contexts.length === 0) {
							contextObj.devices.push(JSON.parse(JSON.stringify(deviceListAll[i])));
						}
					}
					// sort
					bContinue = true;
					while(bContinue)
					{
						bContinue = false;
						for(i= 0; i < (contextObj.devices.length - 1); i ++)
						{
							if(contextObj.devices[i].name > contextObj.devices[i + 1].name) {
								bContinue = true;
								obj = {};
								obj = JSON.parse(JSON.stringify(contextObj.devices[i]));
								contextObj.devices[i] = JSON.parse(JSON.stringify(contextObj.devices[i + 1]));
								contextObj.devices[i + 1] = obj;
							}
						}
					}
				}
				else
					contextObj = treeviewfindContextObj(contextId, planningList);
				if(contextObj === null) {
					document.getElementById("planningPaneDetails").innerHTML = "No Devices";
					return;
				}
				contextPath = contextObj.path;
				paneContent += "<tr><th onclick=\"sortTable(0)\">#</th>";
				paneContent += "<th>Menu</th>"; 
				paneContent += "<th onclick=\"sortTable(1)\">Device Name</th><th onclick=\"sortTable(2)\">Device Status</th>";
				paneContent += "<th onclick=\"sortTable(3)\">Device Type</th><th onclick=\"sortTable(6)\">UID</th>";
				paneContent += "<th onclick=\"sortTable(4)\">Program ID</th>";
				paneContent += "<th onclick=\"sortTable(5)\">Last Update</th><th onclick=\"sortTable(6)\">Protocol</th>"
				//paneContent += "<th onclick=\"sortTable(9)\">Category</th><th onclick=\"sortTable(10)\">SID</th><th onclick=\"sortTable(11)\">Address</th><th>Menu</th></tr>"; 
				paneContent += "<th onclick=\"sortTable(7)\">Category</th>";
				
				
				paneContent += "</tr>"; 
				for(k=0; k < contextObj.devices.length; k++) 
				{
					for(i= 0; i < deviceListAll.length; i ++)
					{	
						if(deviceListAll[i].id === contextObj.devices[k].id) {
							iTotal ++;
							path = "";
							paneContent += "<tr><td>" + iTotal.toString() + "</td>";
							
							if(deviceListAll[i].category	== "SC") {
								paneContent += "<td>";
								paneContent += "<button id=\"deviceMenu_" + deviceListAll[i].name + "\" onclick=\"menuDeviceSmartServer(0, event," + deviceListAll[i].id + ", '" + deviceListAll[i].name  + "')\">...</button>";
								paneContent += "</td>";
								iUp ++;
							}
							else {
								paneContent += "<td><button id=\"deviceMenu_" + deviceListAll[i].name + "\" onclick=\"menuDevice(0, event," + deviceListAll[i].id + ", '" + deviceListAll[i].name  + "', '" + deviceListAll[i].deviceTypeName  + "', '" + deviceListAll[i].protocol  + "')\">...</button></td>";
								if(deviceListAll[i].status.state === "provisioned") {
									if(deviceListAll[i].status.health === "normal")
										iUp ++;
									else
										iDown ++;
								}
								else
									iUnProvisioned ++;
							}
							paneContent += "<td>" + deviceListAll[i].name + "</td>";
							if(deviceListAll[i].category === "SC") {
								paneContent += "<td></td><td></td>";
								paneContent += "<td>" + deviceListAll[i].SID + "</td>";
								paneContent += "<td></td><td></td><td></td>";
							}
							else {
								paneContent += "<td>" + deviceListAll[i].deviceStatus + "</td>";
								paneContent += "<td>" + deviceListAll[i].deviceTypeName  + "</td><td>" + deviceListAll[i].uid  + "</td>";
								z = 0;
								for(j=0; j < deviceTypeList.length; j++)
								{
									if(deviceListAll[i].typeId === deviceTypeList[j].id) {
										paneContent += "<td>" + deviceTypeList[j].programId + "</td>";
										z = 1;
										break;
									}
								}
								if(z === 0)
									paneContent += "<td></td>";
								
								paneContent += "<td>" + deviceListAll[i].mru  + "</td>";
								paneContent += "<td>" + deviceListAll[i].protocol + "</td>";
							}
							paneContent += "<td>" + deviceListAll[i].category + "</td>";
							
							
							paneContent += "</tr>";
							
						}
					}
				}
				sTemp = "Total Devices [" + iTotal + "]: UP = " + iUp + ", Down = " + iDown + ", Unprovisioned = " + iUnProvisioned;
				
				sTemp = "<br><br>" + sTemp +"<br>"
				paneContent = "Devices: " + contextPath + sTemp + "<br><table id=\"myTable\">" + paneContent + "</table>";
				
				document.getElementById("planningPaneDetails").innerHTML = paneContent;
				
			}
			catch {}
		}
		else
			document.getElementById("planningPaneDetails").innerHTML = "No Devices";
	}
	else
		document.getElementById("planningPaneDetails").innerHTML = "No Devices";
		
}