/*   
    WebSocket Driver

 *	Copyright (C) 2023 EnOcean GmbH.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	EnOcean Example Software License Agreement which is available at
 *	https://enoceanwiki.atlassian.net/wiki/spaces/LON/pages/2425260/Example+Software+License+Agreement.  

*/
    
    let ivSocketRequest = "wss://"+ window.location.host + "/iap/ws"; // ":1880/iap/ws";//":8443/iap/ws";
    let ivSocket;
    let ivWsShowConsoleLog = false;
    var ivWsMessage, ivWsLastDatapointUpdate;
    var iviWsCount = 0;
    var ivWsSocketConnected = false;
    var ivWsSmartServerCpu = 0;
    var ivWsExtendMax = 11; // 10 + 1
    var ivbWsSaveServicePinMessage = true;
    var ivWsServicePinMessageHistory = [];
    var ivbWsSaveServicePinShowMessage = false;
    var ivbWsProcessDatapointUpdate = false;
    var ivWsTempObj = {};
    var sTemp, iTemp;
    var element;
    
    function ivWsLogout() {
        ivSocket.close();
    }
    function ivWebSocketInit() {
        ivWsSocketConnected = false;
        ivWsServicePinMessageHistory = [];
        ivbWsSaveServicePinShowMessage = false;

        ivSocket =  new WebSocket(ivSocketRequest);
        ivSocket.onopen = function(event) {
            // alert("[open] connection");
            if(ivWsShowConsoleLog)
                console.log("Web Socket Open");
            ivWsSocketConnected = true;
       }
        ivSocket.onmessage = function(event) {
            //alert('[message] Data received frm server: ' + event.data);
            
            ivWsMessage = JSON.parse(event.data);
            var i, index = -1;
            var ivWsLastDatapointUpdate;
            try
            {
                if(ivWsMessage.action === "NTF:JOIN") {
                    if(ivbWsSaveServicePinMessage) {
                        ivWsTempObj = {};
                        ivWsTempObj.timestamp = new Date().toISOString();
                        ivWsTempObj.serviceMessage = ivWsMessage.payload;
                        ivWsServicePinMessageHistory.splice(0,0,ivWsTempObj);
                        if(ivbWsSaveServicePinShowMessage) {
                            if(typeof webSocketSaveServicePinShowMessage !== 'undefined') { // d
                                webSocketSaveServicePinShowMessage(ivWsTempObj);
                            }
                        }
                        
                    }
                }
                else if(ivWsMessage.action === "UPD:CPU") {  //3.4 UPD:CPU
                    ivWsSmartServerCpu = ivWsMessage.payload;
                    document.getElementById("cpuValue").innerHTML = ivWsSmartServerCpu;
                    if(!(typeof g_iackgroundPollingRequestExtended === "undefined")) {
                        if(ivWsSmartServerCpu > 94) {
                            if(g_iBackgroundPollingRequestExtended < ivWsExtendMax)
                                g_iBackgroundPollingRequestExtended ++;
                        }
                        else {
                            if(g_iBackgroundPollingRequestExtended > 0)
                                g_iBackgroundPollingRequestExtended --;
                        }
                    }
                }
                else if(ivWsMessage.action === "UPD:SC:CPU") {  //3.5 UPD:SC:CPU
                    if(Object.keys(ivWsMessage.payload).length === 1) {
                        ivWsSmartServerCpu = Object.entries(ivWsMessage.payload)[0][1];
                        document.getElementById("cpuValue").innerHTML = ivWsSmartServerCpu;
                        if(!(typeof g_iackgroundPollingRequestExtended === "undefined")) {
                            if(ivWsSmartServerCpu > 94) {
                                if(g_iBackgroundPollingRequestExtended < ivWsExtendMax)
                                    g_iBackgroundPollingRequestExtended ++;
                            }
                            else {
                                if(g_iBackgroundPollingRequestExtended > 0)
                                    g_iBackgroundPollingRequestExtended --;
                            }
                        }
                    }
                }
                else if(ivWsMessage.action === "UPD:EPS") { //3.4
                    if(g_iCheckIfGettingCpuUpdates !== 0) {
                        if(g_bCpuUpdateTimeout) {
                            if(g_cpuTimerId === 0)
				                g_cputimerId = window.setTimeout("cpuTimerHandler()", 5000);
                        }
                        g_bCpuUpdateTimeout = false;
                    }
                    document.getElementById("epsValue").innerHTML = ivWsMessage.payload;
                }
                else if(ivWsMessage.action === "UPD:TOTAL_EPS") { // 3.5
                    if(g_iCheckIfGettingCpuUpdates !== 0) {
                        if(g_bCpuUpdateTimeout) {
                            if(g_cpuTimerId === 0)
				                g_cputimerId = window.setTimeout("cpuTimerHandler()", 5000);
                        }
                        g_bCpuUpdateTimeout = false;
                    }
                    element = document.getElementById("epsValue");
                    if(element !== null) {
                        iTemp = ivWsMessage.payload;
                        element.innerHTML = iTemp;
                        
                        if(iTemp >= g_iTotalEpsHighWarning) {
                            if(element.style.color !== "darkred") {
                                element.style.color = "darkred";
                                element = document.getElementById("epslabel");
                                element.style.color = "darkred";
                            }
                        }
                        else if(iTemp >= g_iTotalEpsLowWarning) {
                            if(element.style.color !== "yellow") {
                                element.style.color = "yellow";
                                element = document.getElementById("epslabel");
                                element.style.color = "yellow";
                            }
                        }
                        else {
                            if(element.style.color !== "white") {
                                element.style.color = "white";
                                element = document.getElementById("epslabel");
                                element.style.color = "white";
                            }
                        }
                    }
                }
                else if(ivWsMessage.action === "UPD:MONITORINGSTATE") { //3.4
                    if(g_bShowIfBackgroundPollingPaused) {
                        if(typeof ivWsMessage.payload.active !== "undefined") {
                            if(ivWsMessage.payload.active)
                                document.getElementById("backgroundpollingStateValue").style.visibility = "hidden";
                            else 
                                document.getElementById("backgroundpollingStateValue").style.visibility = "visible";
                        }
                        
                    }
                }
                /* remote cms
                else if(ivWsMessage.action === "UPD:SC:EPS") {
                    if(Object.keys(ivWsMessage.payload).length === 1)
                        document.getElementById("epsValue").innerHTML = Object.entries(ivWsMessage.payload)[0][1];
                }
                */
                else if(ivWsMessage.action === "UPD:SC:MEMORY") { // 3.5
                    if(Object.keys(ivWsMessage.payload).length === 1) {
                        ivWsTempObj == Object.entries(ivWsMessage.payload)[0][1];
                        sTemp = "Mem: " + Math.ceil((ivWsTempObj.memory.used / ivWsTempObj.memory.total * 100)).toFixed(0);
                        sTemp += "%  Storage: " +  Math.ceil((ivWsTempObj.internal.used / ivWsTempObj.internal.total * 100)).toFixed(0);
                        sTemp += "/" +  Math.ceil((ivWsTempObj.external.used / ivWsTempObj.external.total * 100)).toFixed(0);
                        document.getElementById("memoryStatusInfo").innerHTML = sTemp;
                    }
                }
                else if(ivWsMessage.action === "UPD:DATAPOINT"){
                    //if(g_bNeedToSubscribe) // no longer needed in cae CMS ondemand get or DLA settings update
                    if(!ivbWsProcessDatapointUpdate)
                        return;
                    //var date = new Date();
                    iviWsCount ++;
                    ivWsLastMessage = ivWsMessage;
                    if(ivWsShowConsoleLog)
                        console.log(ivWsMessage);
                    json = [];
                    if(typeof ivWsMessage.payload !== 'undefined'){
                        for(i=0; i < ivWsMessage.payload.length; i ++)
                        {
                            index ++;
                            ivWsLastDatapointUpdate = {};
                            ivWsLastDatapointUpdate.datapointQualifier = ivWsMessage.payload[i].datapointQualifier;
                            ivWsLastDatapointUpdate.value = ivWsMessage.payload[i].value;
                            ivWsLastDatapointUpdate.utc = "";
                            ivWsLastDatapointUpdate.local = "";
                            try {
                                if(typeof ivWsMessage.payload[i].presetValue === "undefined") 
                                    ivWsLastDatapointUpdate.presetValue = "";
                                else
                                    ivWsLastDatapointUpdate.presetValue = ivWsMessage.payload[i].presetValue;
                            } catch { ivWsLastDatapointUpdate.presetValue = ""; }
                            try {
                                if(typeof ivWsMessage.payload[i].locValue === "undefined") 
                                    ivWsLastDatapointUpdate.locValue = "";
                                else
                                    ivWsLastDatapointUpdate.locValue = ivWsMessage.payload[i].locValue;
                            } catch { ivWsLastDatapointUpdate.locValue = ""; }
                            try {
                                if(g_iSmartServerVersion >= 410000) {
                                    ivWsLastDatapointUpdate.timestamp = ivWsMessage.payload[i].timestamp; //currently this is utc time
                                }
                            }
                            catch{}
                            json[index] = ivWsLastDatapointUpdate;
                        }
                        if(json.length > 0) {
                            processWebSocketDpData(0, 1, "", json)  // defined by user
                        }
                    }
                }
                else if(ivWsMessage.action === "UPD:DEVICE") {
                    webSocketDeviceStatusUpdate(ivWsMessage.payload);
                }
                else if(ivWsMessage.action === "UPD:DEVICE_TEST_RESULT") {
                    webSocketDeviceTestResultUpdate(ivWsMessage.payload);
                }
                else if(ivWsMessage.action === "CRT:ALARM") {
                    webSocketDeviceAlarmUpdate(ivWsMessage.payload);
                }
                else if(ivWsMessage.action === "DEL:ALARM") {
                    webSocketDeviceAlarmDeletedUpdate(ivWsMessage.payload);
                }
                else if(ivWsMessage.action === "CRT:NOTIFICATION") {
                    webSocketNotificationUpdate(ivWsMessage.payload);
                }
                else if(ivWsMessage.action === "UPD:LIC:CLOUD") {
                    showLicensesDownloadLicensesFromCloudResponse(ivWsMessage.payload);
                }
                else if(ivWsMessage.action === "DEL:LIC") {
                    showLicensesDownloadRevokeLicensesDeleteUpdate(ivWsMessage.payload);
                }
                else if(ivWsMessage.action === "NTF:LIC:ACTION") {
                    showLicensesDownloadLicensesNtfUpdate(ivWsMessage.payload);
                }
                else if(ivWsMessage.action === "UPD:LIC:TOTAL") {
                    //offline activation

                }
                else if(ivWsMessage.action === "NTF:TIME") {
                    if(g_bShowTimestamp) {
                        element = document.getElementById("timeValue");
                        if(element !== null) {
                            showCmsTimeStampInFooter(ivWsMessage.payload.value);
                        }
                        else if(g_sInitialServerTimestamp === "") {
                            g_sInitialServerTimestamp = ivWsMessage.payload.value;
                        }
                    }
                }
            }
            catch {}
        }
        ivSocket.onclose = function(event) {
            ivWsSocketConnected = false;
            if(event.wasClean) {
                if(ivWsShowConsoleLog)
                    console.log("web Socket close cleanly");
                //alert('[close] Connection closed cleanly, code = ' + event.code + 'reason = ' + event.reason);
           
            }
            else {
                if(ivWsShowConsoleLog)
                    console.log('Web Socket died, code = ' + event.code + 'reason = ' + event.reason);
                
                // server process killed, network down, even.code is usually 1006
                //alert('[close] Connection died, code = ' + event.code + 'reason = ' + event.reason);
                //document.getElementById("log").value = '[close] Connection died, code = ' + event.code + 'reason = ' + event.reason + "\r\n\r\n" + document.getElementById("log").value
            }
        }
        ivSocket.onerror = function(error) {
            if(ivWsShowConsoleLog)
                console.log("error: " + error.message);
            if(!ivWsSocketConnected) {
                var message = "Error: Can't Create Web Socket\r\n\r\nPress OK - to Go to CMS Login page\r\n\t - accept self signed certificate (you don't need to login)";
                message += "\r\n\t - Once you accept certificate, hit browser back button to go back to Brower Web page"
                message += "\r\n\r\nCancel - Stay in Browser, but don't use Web sockets";
                var resp = confirm(message)
                if(resp) {
                    var cmsStr =  "https://" + window.location.host;
		            window.open(cmsStr,'_self',false);
                }
            }
        }
    }
  
    
