/*
 *	Copyright (C) 2023 EnOcean GmbH.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	EnOcean Example Software License Agreement which is available at
 *	https://enoceanwiki.atlassian.net/wiki/spaces/LON/pages/2425260/Example+Software+License+Agreement.  
*/
var g_structuredDpsDialogFields = []; // create one entry per.  Each item contains field path and bchanged=false. If value changed then set bChange to true. Only change bChanged fields in original data
var g_structuredDpsListPointer = [];
var g_menuStructureDpFieldList = [];
var g_menuStructuredDpDialogValue = null;
var g_menuDpValueSetupLevels = {}; // used for structured datapoints
function readFieldValue(data, field1) {
    var result = {};
    var i, field, value;
    var fieldItems = [];
    var bNotFound = true;
    try {
        result.valid = false;
        result.data = data;
        
        if(field1 !== "") {
            fieldItems = field1.split("/");
        
            if(typeof data === "object") {
                value = data;
                for(i=0; i < fieldItems.length; i++)
                {
                    
                    field = fieldItems[i].trim();
                    if(field !== "") {
                        
                        if(typeof value === "object") {  
                            if(value.hasOwnProperty(field)) {
                                if(i=== (fieldItems.length - 1)) {
                                    result.valid = true;
                                    result.data = value[field];
                                    bNotFound = false;
                                    break;
                                }
                                else 
                                    value = value[field]
                            }
                            else { // assume array Array.isArray(value) doesn't work 
                                result.valid = false;
                                break;
                            }
                        }
                    }
                }
            }
        }
    }
    catch {
        result.valid = false;
    }
    return result;
}
function readSnvtTypeFieldValue(data, field1) {
    var result = {};
    var i, field, value;
    var fieldItems = [];
    var bNotFound = true;
    try {
        result.valid = false;
        result.data = data;
        
        if(field1 !== "") {
            fieldItems = field1.split("/");
        
            if(typeof data === "object") {
                value = data.typeJson.members;
                for(i=0; i < fieldItems.length; i++)
                {
                    
                    field = fieldItems[i].trim();
                    if(field !== "") {
                        for(j=0; j < value.length; j++)
                        {
                            if(typeof value === "object") {  
                                if(value[j].id == field) {
                                    if(i=== (fieldItems.length - 1)) {
                                        result.valid = true;
                                        result.data = value[j];
                                        bNotFound = false;
                                        
                                    }
                                    else 
                                        value = value[j].members;
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        }
        else
            result.valid = true;
    }
    catch {
        result.valid = false;
    }
    return result;
}
function changeFieldValue(data, field1, newValue) {
    var i, field, value;
    var fieldItems = field1.split("/");
    var result = {};
    try {
        result.valid = false;
        result.data = data;
        if(field1 !== "") {
            if(typeof data === "object") {
                value = data;
                for(i=0; i < fieldItems.length; i++)
                {
                    field = fieldItems[i].trim();
                    if(field !== "") {
                        if(value.hasOwnProperty(field)) {
                            
                            if(i=== (fieldItems.length - 1)) {
                                value[field] = newValue;
                                result.valid = true;
                            }
                            else 
                                value = value[field]
                        }
                    }
                }
            }
        }
    }
    catch {
        result.valid = false;
    
    }
    return result;
}
function menuStructuredDp(mode, n, readonly,index, programmaticPathname, field) {
    var pathname = "";
    g_structuredDpsListPointer = dpList;
    if(g_structuredDpsListPointer[index].programmaticPathname === programmaticPathname) {
        pathname = g_structuredDpsListPointer[index].pathname;
        menuStructuredDpDialog(mode, n, readonly,index, pathname, programmaticPathname, field);
    }

}
function menuStructuredDpDialog(mode, n, bLocalValue, index, displayIdPrefix, programmaticPathname, field) {
    menuStructuredDpDialog1(mode, n, bLocalValue, true, true, index, displayIdPrefix, programmaticPathname, programmaticPathname, null, field,null,"");
}
function menuStructuredDpDialog1(mode, n, bLocalValue, bShowType, bCopy, index, displayIdPrefix, pathname, programmaticPathname, value, field, dpType,label) {
    //mode: 0=datapoint/favorites local or iap value column, 1 menudpvalue priority, 2=menudpvalue write, 3=datapoint/favoriteswrite, 4=planning write
    try { 
        //var event1 = window.event;
        var iPtr;
        var x = 0; // = event.clientX;
        var y = 0;// = event.clientY;
        var menuContent = "";
        var offsets;
        var readonly = true; // fix
        var menuButton;
        var displayType = "";
        var element;
        var writeElement, element2;
        var displayId;
        var menuDivXOffset = 30;
        var menuDivYOffset = 20;
        var menuDivWidth = 150;
        var menuDiv;
        var bottomDiv;
        var bContinue = false;
        var dpTypeObj = {};
        var sPriorityLevelValue = "";
        var json = [];
        g_menuStructuredDpDialogValue = null;
        if(mode === 0) {
            g_bInoreMouseClickForStructured = false;
            menuCancel();
        }
        else if(mode === 1) {
            g_bInoreMouseClickForStructured = true;
            sPriorityLevelValue = index;
        }
        else if(mode === 2) {
            g_bInoreMouseClickForStructured = true;
            writeElement = document.getElementById(displayIdPrefix + pathname);
            if(writeElement === null)
                return;
            value = writeElement.value;
            try {
                value = JSON.parse(value);
            }
            catch {
                alert("Value is not a structure");
                return;
            }
            readonly = false;
        }
        else if((mode === 3) || (mode === 4)) {
            
            writeElement = document.getElementById(displayIdPrefix + pathname);
            if(writeElement === null)
                return;
            value = writeElement.value;
            if(value === "")
                value = null;
            else if((value.trim().charAt(0) === "{") || (value.trim().charAt(0) === "[")) {
                try {
                    value = JSON.parse(value);
                    
                }
                catch {
                    alert("Value is not a structure");
                    return;
                }
            }
            else {
                // could be presets so ignore
                return;
            }
            readonly = false;
            g_bInoreMouseClickForStructured = false;
            menuCancel();
        }
        else if(mode === 5) {
            g_bInoreMouseClickForStructured = false;
            menuCancel();
            pathname = pathname;
            element2 = document.getElementById(displayIdPrefix + pathname);
            if(element2 === null)
                return;
            value = element2.innerHTML;
            dpType = "Value";
            try {
                value = JSON.parse(value);
                
            }
            catch {
                alert("Value is not a structure");
                return;
            }
        }
        g_bAlwaysIngnoreMouseClick = false;
       
       
        if(n === null)
            return;
        if((value === null) || (dpType === null)) {
            if(g_iMainDisplayMode === DISPLAYMODE_DPS) {  //ffix 
                if(index < dpList.length) {
                    if(dpList[index].programmaticPathname === programmaticPathname) {
                        if(typeof dpList[index].values !== "undefined") {
                            bContinue = true;
                            pathname = dpList[index].pathName;
                            dpType = dpList[index].type;
                            if(((mode === 1) || (mode === 3)) && bShowType) {
                                element = document.getElementById("useLocalValue");
                                if(element !== null) {
                                    bLocalValue = false;
                                    if(element.checked)
                                        bLocalValue = true;
                                }
                            }
                            if(value === null) {
                                if(bLocalValue)
                                    value = dpList[index].locValue;
                                else
                                    value = dpList[index].value;
                            }
                        }
                    }
                }
            }
            else if(g_iMainDisplayMode === DISPLAYMODE_FAVDPS) {
                if(index < favDpList.length) {
                    if(favDpList[index].programmaticPathname === programmaticPathname) {
                        if(typeof favDpList[index].values !== "undefined") {
                            bContinue = true;
                            pathname = favDpList[index].pathName;
                            dpType = favDpList[index].type;
                            if(((mode === 1) || (mode === 3)) && bShowType) {
                                element = document.getElementById("useLocalValue");
                                if(element !== null) {
                                    bLocalValue = false;
                                    if(element.checked)
                                        bLocalValue = true;
                                }
                            }
                            if(value === null) {
                                if(bLocalValue)
                                    value = favDpList[index].locValue;
                                else
                                    value = favDpList[index].value;
                            }
                            
                        }
                    }
                }
            }
            else if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
                if(index < dashboardDpList.length) {
                    if(dashboardDpList[index].programmaticPathname === programmaticPathname) {
                        if(typeof dashboardDpList[index].values !== "undefined") {
                            bContinue = true;
                            pathname = dashboardDpList[index].pathName;
                            dpType = dashboardDpList[index].type;
                            if(value === null) {
                                if(bLocalValue)
                                    value = dashboardDpList[index].locValue;
                                else
                                    value = dashboardDpList[index].value;
                            }
                        }
                    }
                }
            }
            else if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
                if(index < planningDpList.length) {
                    if(planningDpList[index].programmaticPathname === programmaticPathname) {
                        if(typeof planningDpList[index].values !== "undefined") {
                            bContinue = true;
                            pathname = planningDpList[index].pathName;
                            dpType = planningDpList[index].type;
                            bLocalValue = true;
                            if(value === null) {
                                if(bLocalValue)
                                    value = planningDpList[index].locValue;
                                else
                                    value = planningDpList[index].value;
                            }
                        }
                    }
                }
                
            }
            else if(g_iMainDisplayMode === DISPLAYMODE_DATALOG) {
                
                bContinue = true;
                pathname = pathname;
                
               
            }
        }
        else 
            bContinue = true;

        if(!bContinue)
            return;

        dpTypeObj.dpType = dpType;
        dpTypeObj.snvtTypeObj = null;
        for(i=0; i < g_snvtTypes.length; i++)
        {
            if(dpType === g_snvtTypes[i].typeId) {
                dpTypeObj.snvtTypeObj = JSON.parse(JSON.stringify(g_snvtTypes[i]));
                break;
            }
        }    
        g_structuredDpsDialogFields = [];
        
        /*
        if((n.tagName === "SPAN") || (n.tagName === "DIV")){
            displayId = "localValue_" + dashboardDpList[index].displayElements[displayElementIndex].displayId;
		    if(n.id !== displayId) 
                return;
        }
        else if (n.tagName === "BUTTON") {

        }
        else
            return;
            */
        /*
        displayType = dashboardDpList[index].displayElements[displayElementIndex].dashboardType;
        if(displayType === "r")
            readonly = true;
        else if (displayType === "n1")
            readonly = false;
        else if((displayType === "n") && (cat === "in"))
            readonly = false;
        */
        
        menuContent = "<div class=\"menuDivDpShowBorder\"><div id=\"structuredDpDivHeader\" class=\"menuDivDpShowPathName menuDivStructuredDpShowDragDivHeader\">"
        iPtr = pathname.indexOf("/");
        if(iPtr !== -1) {
            //menuContent += "Device: "
            menuContent += pathname.substr(0,iPtr);
            iPtr ++;
            menuContent +="<button style=\"float:right;margin-right:10px\"  onclick='menuStructuredDpDialogCancel()'>X</button>";
            //menuContent += "<br><br>Datapoint: " + pathname.substr(iPtr);
            menuContent += "<br><br>" + pathname.substr(iPtr) + "<br><br>";
        }
        else
            menuContent += pathname;
        
        
        menuContent += "</div>";
        g_menuStructuredDpDialogValue = value;
        if(!readonly){
            menuContent += "<div>";
            if(sPriorityLevelValue !== "") {
                menuContent += "Priority " + sPriorityLevelValue;
                if(bShowType)
                    menuContent += ": ";
            }
            if(bShowType) {
                if(bLocalValue)
                    menuContent += "LocValue";
                else
                    menuContent += "IAP Value";
            }
            menuContent += "<div style=\"float:right\">";
            if(bCopy)
                menuContent += "<button onclick='menuStructuredDpDialogCopyToClipboard()'>Copy</button>";
            menuContent += "<button onclick=\"menuStructuredDpDialogSave('" + displayIdPrefix + "','" +  pathname + "')\">Save</button>";
            menuContent += "<button style=\"margin-left:20px\" onclick='menuStructuredDpDialogCancel()'>Cancel</button>"
        
            menuContent += "</div></div><br>";
        }
        else if((bShowType) || (bCopy)) {
            menuContent += "<div>";
            if(bShowType) {
                if(bLocalValue)
                    menuContent += "LocValue";
                else
                    menuContent += "IAP Value";
            }
            menuContent += "<div style=\"float:right\">";
            if(bCopy)
                menuContent += "<button onclick='menuStructuredDpDialogCopyToClipboard()'>Copy</button>";
        
            menuContent += "</div></div><br>";
        }
        if((label !== null) || (label !== "")) {
            menuContent += label + "<br>";
        }
        menuContent += "<div id=\"StructuredDpTreeDiv\" class=\"menuDivDpShowNoBorder\"><br><br></div>"
        menuContent += "<br>";
        
        menuContent += "</div>";
        
        //element = document.getElementById(displayId);
        
        menuButton = n;
        /*
        if(n.tagName === "SPAN")
            menuButton = document.getElementById("localValue_" + programmaticPathname); // if span, can also be a button
        else if (n.tagName === "BUTTON")
            menuButton = document.getElementById("structuredDpMenu_" + programmaticPathname);
        else 
            return;
        */
        
        if(menuButton !== null) {
            offsets = menuButton.getBoundingClientRect(); 
            if((offsets.x + offsets.width + window.pageXOffset + menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
                x = offsets.x + window.pageXOffset - menuDivWidth - 10; // takes into account viewport (scrolling)
            else
                x = offsets.x + offsets.width + window.pageXOffset + menuDivXOffset; // takes into account viewport (scrolling)
            y = offsets.y + window.pageYOffset - menuDivYOffset; // takes into account viewport (scrolling)
            menuDiv = document.getElementById("structuredDpDiv");
            menuDiv.innerHTML = menuContent;
            bottomDiv = document.getElementById("main-botton");
            offsets = menuDiv.getBoundingClientRect();
            if(bottomDiv !== null) {
                if((y + 370) > (bottomDiv.offsetTop)) {
                    y -= 230;
                    if(y < 0)
                        y = 100;
                }
            }
            document.getElementById("structuredDpDiv").style.left = x.toString() + "px";
            document.getElementById("structuredDpDiv").style.top = y.toString() + "px";
            document.getElementById("structuredDpDiv").className = "menuDivStructuredDpShowContent";  // doesn't currently guaranty that menu is shown in viewport
            //if(mode === 1)
            //    document.getElementById("structuredDpDiv").style.width= "310px";
                

            //menuContent = menuStructuredDpDialogBuildFieldTree(mode, n, readonly,index, displayIdPrefix, programmaticPathname, field);
            menuContent = menuStructuredDpdecodedJsonTree(value, "", 0, dpTypeObj, readonly,false, null); 




            element = document.getElementById("StructuredDpTreeDiv");
            if(element !== null)
                element.innerHTML = menuContent;
            g_bInoreMouseClick = true;
            document.addEventListener("click", menuMouseCancel);
            //document.addEventListener("click", function() {menuMouseCancel(event);});
            dragDiv(document.getElementById("structuredDpDiv"));
            
        }
    } catch {}
}
function menuStructuredDpDialogCopyToClipboard() {
    var value = g_menuStructuredDpDialogValue;
    if(value === null)
        return;
    if(typeof value === "object")
        value = JSON.stringify(value);
    navigator.clipboard.writeText(value);
}
function menuStructuredDpDialogBuildFieldTree(mode, n, readonly,index, displayIdPrefix, programmaticPathname, field) {
    var content = "";
    var value,dpTypeObj = {};
    try {
        if(dashboardDpList[index].programmaticPathname === programmaticPathname) {
            if(field === "") {
                value = dashboardDpList[index].locValue;//dashboardDpList[index].value;
                if(typeof dashboardDpList[index].type !== "undefined") {
                    dpTypeObj.dpType = dashboardDpList[index].type;
                    dpTypeObj.snvtTypeObj = null;
					// add SNVTdata
					for(i=0; i < g_snvtTypes.length; i++)
					{
						if(dashboardDpList[index].type === g_snvtTypes[i].typeId) {
							dpTypeObj.snvtTypeObj = JSON.parse(JSON.stringify(g_snvtTypes[i]));
							break;
						}
					}
                }
                content = menuStructuredDpdecodedJsonTree(value, "", 0, dpTypeObj, readonly,false, null); // tree view
                //content = menuStructuredDpdecodedJson(value, "", 0, dptype, readonly); // div content
            }
        }

    }
    catch {content = "Not Valid JSON"}
    return content;
}
function menuStructuredDpDialogCancel() {
    var element = document.getElementById("structuredDpDiv");
    var i;
    element.className = "menuDivStructuredDpHide";
    element.innerHTML = "";
    element = document.getElementById("menuOverlayDiv");
    if(element !== null)
        element.className = "menuOverlayDivHide";
    g_structuredDpsDialogFields = [];
    g_menuStructuredDpDialogValue = null;
    g_menuDpValueSetupLevels = {}; // used for structured datapoints
}

function menuStructuredDpDialogSave(displayElementIndex, pathname) {
    // save values
    var element, element1;
    var bAbort = false;
    var result;
    var newValue;
    var data;
    try {
        element1 = document.getElementById(displayElementIndex + pathname);
        if(element1 === null) {
            alert("Something went wrong, can't save value. Exit and try again");
            return;
        }

        if(!menuStructuredDpInputErrorCheckAll()) {
            showAlertDialog(0,"Error: One or more values are wrong. \r\nCorrect and try again");
            return;
        }
        //data = JSON.parse(JSON.stringify(dashboardDpList[index].value));
        if(g_menuStructuredDpDialogValue === null)
            data = JSON.parse(element1.value);
        else 
            data = g_menuStructuredDpDialogValue;
        for(i=0; i < g_structuredDpsDialogFields.length; i++)
        {
            element = document.getElementById(g_structuredDpsDialogFields[i].displayId)
            if(element !== null) {
                if(element.tagName === "SELECT") {
                    newValue = element.options[element.selectedIndex].text;
                }
                else {
                    newValue = element.value;
                    if((g_structuredDpsDialogFields[i].type === "boolean") && (typeof newValue === "string")) {
                        if(newValue === "true")
                            newValue = true;
                        else if(newValue === "false")
                            newValue = false;
                        else if(newValue === "0")
                            newValue = 0;
                        else if(newValue === "1")
                            newValue = 1;

                    }
                    else if((g_structuredDpsDialogFields[i].type === "number") && (typeof newValue === "string")) {
                        newValue = Number(newValue);
                        if(isNaN(newValue)) {
                            bAbort = true;
                        }
                    }
                }
                if(!bAbort) {
                    result =  readFieldValue(data, g_structuredDpsDialogFields[i].fieldPath);
                    if(result.valid) {
                        if(newValue !== result.data) { //compare against current value
                            result = changeFieldValue(data, g_structuredDpsDialogFields[i].fieldPath, newValue)
                            if(!result.valid) {
                                bAbort = true;
                                break;
                            }
                        }
                    }
                    else {
                        bAbort = true;
                        break;
                    }
                }
                else 
                    break;
            }
            else {
                bAbort = true;
                break;
            }

        }
        if(!bAbort) {
            if(element.tagName === "DIV")
                element1.innerHTML = JSON.stringify(data);
            else if(element.tagName === "INPUT")
                element1.value = JSON.stringify(data);
        }
    /*
        if(!bAbort) {
            _menuDpValueSave(1, index, displayElementIndex, programmaticPathname, data, "");
            //dashboardDpList[index].value = JSON.parse(JSON.stringify(data));
            // document.getElementById("data_" + dashboardDpList[index].programmaticPathname).value = JSON.stringify(dashboardDpList[index].value);
        }
        */
    }
    catch {}
    if(bAbort) {
        showAlertDialog(0,"Can't process update: missing HTML element or Can't find field");
    }
    menuStructuredDpDialogCancel();
}
function menuStructuredDpdecodedJsonTree(json, path, iTabs, dpTypeObj, readonly, bLastChild, saveObj) {
    //saveObj: contains information about what function performs save
	var result = "", i;
    var tabStr = "";
    var obj, obj1, attrName, attrValue, key, iTemp;
    var size1 = 20, size = 10;
    var nameSize = 10;
    var path1;
    var count = 0;
    var total = 0;
    var sTemp;
    var dpType = "value";
    var dpTypeParams;
    try {
		
        if(iTabs === 0) {
            
            key = false;
            g_structuredDpsDialogFields = [];
            if(saveObj !== null) {
                if(saveObj.type === "menuDpValue") 
                    key = true;
            }
            if(key) {
                result += "<div style=\"display:block;width:100%\"><span style=\"float:left\">";
                if(dpTypeObj !== null) {
                    if(dpTypeObj.dpType !== "")
                        dpType = dpTypeObj.dpType;
                }
                result += dpType;
                result += "</span>"
                result += "<button style=\"float:right\" onclick=\"menuStructuredDpDialogSave(" + saveObj.displayElementIndex + ",'" + saveObj.programmaticPathname + "')\">Send</button>";
                result += "</div><br>";
            }
            else {
                if(dpTypeObj !== null) 
                    dpType = dpTypeObj.dpType;
                result += dpType;
            }
            result += "<div id=\"treeStructuredDpsDiv\">";
            result += "<ul class=\"treeul\">";
            
        }
        else {
            if(bLastChild)
				result = "<ul class=\"treeul treeviewNested treeviewActive\" style=\"border-left: 3px solid #366184;margin-left: -18px;\">";

			else
				result = "<ul class=\"treeul treeviewNested treeviewActive\">";
        }
        
		if ((typeof json === 'string') || (typeof json === 'number') 
			|| (typeof json === 'boolean'))
		{
			//result += json;
            if(readonly)
                result += json;
            else {
                if(typeof json === 'string')
                    size = json.length + 2;
                else if ((typeof json === 'number') || (typeof json === 'boolean'))
                    size = json.toString().length + 2;
                if(size > size1)
                    size = size1;
                obj1 = {};
                obj1.fieldTypeParams = null;
                obj1.fieldDisplayType = "i";
                if(dpTypeObj.snvtTypeObj !== null) {
                    dpTypeParams = readSnvtTypeFieldValue(dpTypeObj.snvtTypeObj, path);
                    if(dpTypeParams.valid) {
                        obj1.fieldTypeParams = dpTypeParams.data;
                    }
                }
                // remove for textarea  result += "<br>" + tabStr +  "<input id='structuredDpId_" + path + "' value='" + json +"' size='" + size + "'>";
                result += "<li class=\"treeli treeviewLiActive\"><p>";
                if(obj1.fieldTypeParams.type === "enum") {
                    obj1.fieldDisplayType = "d";
                    result += "<select id='structuredDpId_" + path1 + "'>";
                    for(i=0; i < obj1.fieldTypeParams.enum.length; i++)
                    {
                        result += "<option";
                        if(obj1.fieldTypeParams.enum[i].id.toLowerCase() === attrValue.toLowerCase()) {
                            result += " selected";
                        }
                        result += ">" + obj1.fieldTypeParams.enum[i].id + "</option>";
                    }
                    result += "</select>";
                }
                else {
                    result += "<input id='structuredDpId_" + path + "' value='" + json +"' ' size='" + size + "' class='menuDivDpRowMargin'";
                    result += " onchange=\"menuStructuredDpInputErrorCheck(" + iTemp + ",'" + path + "')\">";
                }
                result += "<span id='structuredDpErrId_" + path + "' style=\"color:red;margin-left:10px\"></span>";
                
                result += "</p></li>";
                
                obj1.field = attrName;
                obj1.fieldPath = path;
                obj1.type = typeof  json;
                obj1.value = json;
                obj1.displayId = "structuredDpId_" + path;
                g_structuredDpsDialogFields.push(obj1);
            }
		}
		else if ((json !== null) && (typeof json === 'object'))
		{	// object
				
			//sTemp = JSON.stringify(json);
			
			tabStr = "";
            /*
			for(j=0; j < ((iTabs + 1) * 10); j++)
			{
				//tabStr += "\t";
                tabStr += "&nbsp;"
			}
            */
            if(iTabs === 0)
                path = "";
            total = Object.keys(json).length;

			for(key in json){
                count ++;
				attrName = key;
				attrValue = json[key];
                
                
				if ((typeof  attrValue === 'string') || (typeof  attrValue === 'number')
					|| (typeof attrValue === 'boolean')) {
					
                    // remove for textarea result += "<br>" + tabStr + attrName.padEnd(nameSize," ") + ": ";
                    if(readonly) {
                        // remove for textarea  result += attrValue;
                        sTemp = attrName + ": ";
                        result += "<li class=\"treeli menuDivDpRowMargin\"><p>";
                        result += "<span id=\"structuredDpButton__NoContext\" class=\"structuredDpTreeSpan\">" + sTemp.padEnd(nameSize," ") + "</span>";
                        result += "<span id='structuredDpId_" + path1 + "'  class='menuDivDpRowMargin'>" + attrValue + "</span>";
                        result += "</p></li>";
                    }
                    else {
                        if(typeof attrValue === 'string')
                            size = attrValue.length + 2;
                        else if ((typeof attrValue === 'number') || (typeof attrValue === 'boolean'))
                            size = attrValue.toString().length + 2;
                        if(size > size1)
                            size = size1;
                        path1 = path;
                        if(path1 !== "")
                            path1 += "/";
                        path1 += key;
                        // remove for textarea  result += "<input id='structuredDpId_" + path1 + "' value='" + attrValue +"' ' size='" + size + "'>";
                        sTemp = attrName + ": ";
                        iTemp = g_structuredDpsDialogFields.length;
                        obj1 = {};
                        obj1.fieldTypeParams = null;
                        obj1.fieldDisplayType = "i";
                        if(dpTypeObj.snvtTypeObj !== null) {
                            dpTypeParams = readSnvtTypeFieldValue(dpTypeObj.snvtTypeObj, path1);
                            if(dpTypeParams.valid) {
                                obj1.fieldTypeParams = dpTypeParams.data;
                            }
                        }


                        result += "<li class=\"treeli menuDivDpRowMargin\"><p>";
                        result += "<span id=\"structuredDpButton__NoContext\" class=\"structuredDpTreeSpan\">" + sTemp.padEnd(nameSize," ") + "</span>";
                        if(obj1.fieldTypeParams.type === "enum") {
                            obj1.fieldDisplayType = "d";
                            result += "<select id='structuredDpId_" + path1 + "'>";
                            for(i=0; i < obj1.fieldTypeParams.enum.length; i++)
                            {
                                result += "<option";
                                if(obj1.fieldTypeParams.enum[i].id.toLowerCase() === attrValue.toLowerCase()) {
                                    result += " selected";
                                }
                                result += ">" + obj1.fieldTypeParams.enum[i].id + "</option>";
                            }
                            result += "</select>";
                        }
                        else {
                            result += "<input id='structuredDpId_" + path1 + "' value='" + attrValue +"' ' size='" + size + "' class='menuDivDpRowMargin'";
                            result += " onchange=\"menuStructuredDpInputErrorCheck(" + iTemp + ",'" + path1 + "')\">";
                        }
                        result += "<span id='structuredDpErrId_" + path1 + "' style=\"color:red;margin-left:10px\"></span>";
                        result += "</p></li>";

                        
                        obj1.field = attrName;
                        
                        obj1.fieldPath = path1;
                        obj1.type = typeof  attrValue;
                        obj1.value = attrValue;
                        obj1.displayId = "structuredDpId_" + path1;
                        g_structuredDpsDialogFields.push(obj1);
                    }
                }
				else if(attrValue === null) {
                    
                    // remove for textarea result += "<br>" + tabStr + attrName.padEnd(nameSize," ") + ": ";
                    if(readonly) {
                        // remove for textarea result += "null";
					    sTemp = attrName + ": ";
                        result += "<li class=\"treeli menuDivDpRowMargin\"><p>";
                        result += "<span id=\"structuredDpButton__NoContext\" class=\"structuredDpTreeSpan\">" + sTemp.padEnd(nameSize," ") + "</span>";
                        result += "<span id='structuredDpId_" + path1 + "'  class='menuDivDpRowMargin'></span>";
                        result += "</p></li>";
                    }
                    else {
                        path1 = path;
                        if(path1 !== "")
                            path1 += "/";
                        path1 += key;
                        // remove for textarea result += "<input id='structuredDpId_" + path1  + "' value='\"null\"' ' size='" + size + "'>";
                        //result += "\r\n" + tabStr + attrName + ": " + "<" 
                        obj1 = {};
                        obj1.fieldTypeParams = null;
                        obj1.fieldDisplayType = "i";
                        if(dpTypeObj.snvtTypeObj !== null) {
                            dpTypeParams = readSnvtTypeFieldValue(dpTypeObj.snvtTypeObj, path1);
                            if(dpTypeParams.valid) {
                                obj1.fieldTypeParams = dpTypeParams.data;
                            }
                        }

                        sTemp = attrName + ": ";
                        result += "<li class=\"treeli \"><p>";
                        result += "<span id=\"structuredDpButton__NoContext\" class=\"structuredDpTreeSpan\">" + sTemp.padEnd(nameSize," ") + "</span>";
                        if(obj1.fieldTypeParams.type === "enum") {
                            obj1.fieldDisplayType = "d";
                            result += "<select id='structuredDpId_" + path1 + "'>";
                            for(i=0; i < obj1.fieldTypeParams.enum.length; i++)
                            {
                                result += "<option";
                                if(obj1.fieldTypeParams.enum[i].id.toLowerCase() === attrValue.toLowerCase()) {
                                    result += " selected";
                                }
                                result += ">" + obj1.fieldTypeParams.enum[i].id + "</option>";
                            }
                            result += "</select>";
                        }
                        else {
                            result += "<input id='structuredDpId_" + path1 + "' value='" + attrValue +"' ' size='" + size + "' class='menuDivDpRowMargin'";
                            result += " onchange=\"menuStructuredDpInputErrorCheck(" + iTemp + ",'" + path1 + "')\">";
                        }
                        result += "<span id='structuredDpErrId_" + path1 + "' style=\"color:red;margin-left:10px\"></span>";
                        result += "</p></li>";

                        
                        obj1.field = attrName;
                        obj1.fieldPath = path1;
                        obj1.type = typeof  attrValue;
                        obj1.value = "null";
                        obj1.displayId = "structuredDpId_" + path1;
                        g_structuredDpsDialogFields.push(obj1);
                    }
                    

                }
				else {
                    
                    path1 = path;
                    if(path1 !== "")
                        path1 += "/";
                    path1 += attrName;
                    //result += "<br>" + tabStr + attrName.padEnd(nameSize," ") + ":";
                    sTemp = attrName + ": ";
                    bLastChild = false;
                    if(count >= total)
                        bLastChild = true;
                    result += "<li class=\"treeli";
                    
                    if(bLastChild)
                        result += " treeviewLiActiveLastChild";
                    else
                        result += " treeviewLiActive";
                    result += "\" ><p>";
                    result += "<button id=\"structuredDpButton__NoContext\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"structuredDpsTreeviewToggle(this)\"></button>";
                    result += "<span id=\"planningTreeContext__NoContext\" onclick=\"getPlanningTreeShowTreeDetails(0, '_NoContext')\">" + sTemp.padEnd(nameSize," ");
                    result += "</span></p>";
                    bLastChild = false;
                    if(count >= total)
                        bLastChild = true;
                    //result += "\r\n" + tabStr + attrName + ":"; //fix add to brower.html
					result +=  menuStructuredDpdecodedJsonTree(attrValue, path1, iTabs + 1, dpTypeObj, readonly, bLastChild, null);
                    result += "</li>"
                    
                }
					
			} // for(key in json){
		} //else if ((json !== null) && (typeof json === 'object'))
        
        result += "</ul>";
        if(iTabs === 0)
            result += "</div>";
    }
	catch(err) { 
            result = "<ul></ul>";
    }
	return result;

}
function menuStructuredDpInputErrorCheck(index, displayId) {
    try {
        var element = document.getElementById("structuredDpId_" + displayId)
        var errElement = document.getElementById("structuredDpErrId_" + displayId)
        var fieldTypeParams;
        var value;
        var size;
        var bInteger = false;
        var fieldTypeParams;
        if(index >= g_structuredDpsDialogFields.length)
            return;
        if((element !== null) && (errElement !== null)) {
            if(g_structuredDpsDialogFields[index].fieldDisplayType === "i") {
                fieldTypeParams = g_structuredDpsDialogFields[index].fieldTypeParams;
                if(fieldTypeParams.base.startsWith("int") || fieldTypeParams.base.startsWith("uint")) {
                    value = element.value;
                    bInteger = true;
                    if(fieldTypeParams.hasOwnProperty("encoding")) {
                        try {
                            if(fieldTypeParams["encoding"] === "decimal")
                                bInteger = false;
                        }
                        catch 
                        {
                            errElement.innerHTML = "Can't check";
                        }
                    }
                    if(bInteger && (value.indexOf(".") !== -1)) {
                        errElement.innerHTML = "Error: use integers " + fieldTypeParams.min + " thru " + fieldTypeParams.max;
                    }
                    else {
                        value = Number(value);
                        if(isNaN(value)) {
                            errElement.innerHTML = "Error: use " + fieldTypeParams.min + " thru " + fieldTypeParams.max;
                        }
                        else {
                            if((value <  fieldTypeParams.min) || (value >  fieldTypeParams.max))
                                errElement.innerHTML = "Error: use " + fieldTypeParams.min + " thru " + fieldTypeParams.max
                            else
                                errElement.innerHTML = "";
                        }
                    }
                }
                else if(fieldTypeParams.base === "unsigned char") {
                    value = element.value;
                    try {
                        if(fieldTypeParams.hasOwnProperty("array-size")) {
                            size = fieldTypeParams["array-size"];
                            if(!isNaN(size)) {
                                size = Number(size);
                                if(value.length > size) {
                                    errElement.innerHTML = " too long(" + size + "): " + value.length;
                                }
                            }
                            else {
                                errElement.innerHTML = "Can't check";
                            }
                            
                        }
                    }
                    catch (err) {

                    }
                }
                else if(fieldTypeParams.base === "float") {
                    value = element.value;
                    value = Number(value);
                    if(isNaN(value)) {
                        errElement.innerHTML = "Error: use " + fieldTypeParams.min + " thru " + fieldTypeParams.max;
                    }
                    else {
                        
                        if((value <  fieldTypeParams.min) || (value >  fieldTypeParams.max)) {
                            errElement.innerHTML = "Error: use " + fieldTypeParams.min + " thru " + fieldTypeParams.max
                            bResult = false;
                           
                        }
                        else 
                            errElement.innerHTML = "";
                    }
                }
                else
                    errElement.innerHTML = element.value;
            }
        }
    }
    catch {}
}
function menuStructuredDpInputErrorCheckAll() {
    var bResult = true;
    var element, errElement;
    var size;
    var bInteger = false;
    var fieldTypeParams;
    try {
        
        
        for(i=0; i < g_structuredDpsDialogFields.length; i++) 
        {
            if(g_structuredDpsDialogFields[i].fieldDisplayType === "i") {
                // check for errors
                //if error bResult = false; break;
                element = document.getElementById(g_structuredDpsDialogFields[i].displayId);
                errElement = document.getElementById("structuredDpErrId_" + g_structuredDpsDialogFields[i].fieldPath);
                if(element !== null) {
                    fieldTypeParams = g_structuredDpsDialogFields[i].fieldTypeParams;
                    if(fieldTypeParams.base.startsWith("int") || fieldTypeParams.base.startsWith("uint")) {
                        value = element.value;
                        try {
                            if(fieldTypeParams["encoding"] === "decimal")
                                bInteger = false;
                        }
                        catch 
                        {
                            errElement.innerHTML = "Can't check";
                        }
                        if(bInteger && (value.indexOf(".") !== -1)) {
                            errElement.innerHTML = "Error: use integers " + fieldTypeParams.min + " thru " + fieldTypeParams.max;
                            bResult = false;
                            break;
                        }
                        else {
                            value = Number(value);
                            if(isNaN(value)) {
                                errElement.innerHTML = "Error: use " + fieldTypeParams.min + " thru " + fieldTypeParams.max;
                                bResult = false;
                                break;
                            }
                            else {
                                
                                if((value <  fieldTypeParams.min) || (value >  fieldTypeParams.max)) {
                                    errElement.innerHTML = "Error: use " + fieldTypeParams.min + " thru " + fieldTypeParams.max
                                    bResult = false;
                                    break;
                                }
                                else 
                                    errElement.innerHTML = "";
                            }
                        }
                    }
                    else if(fieldTypeParams.base === "unsigned char") {
                        value = element.value;
                        try {
                            if(fieldTypeParams.hasOwnProperty("array-size")) {
                                size = fieldTypeParams["array-size"];
                                if(!isNaN(size)) {
                                    size = Number(size);
                                    if(value.length > size) {
                                        errElement.innerHTML = " too long(" + size + "): " + value.length;
                                    }
                                }
                                else {
                                    errElement.innerHTML = "Can't check";
                                }
                                
                            }
                        }
                        catch (err) {

                        }
                    }
                    else if(fieldTypeParams.base === "float") {
                        value = element.value;
                        value = Number(value);
                        if(isNaN(value)) {
                            errElement.innerHTML = "Error: use " + fieldTypeParams.min + " thru " + fieldTypeParams.max;
                            bResult = false;
                            break;
                        }
                        else {
                            
                            if((value <  fieldTypeParams.min) || (value >  fieldTypeParams.max)) {
                                errElement.innerHTML = "Error: use " + fieldTypeParams.min + " thru " + fieldTypeParams.max
                                bResult = false;
                                break;
                            }
                            else 
                                errElement.innerHTML = "";
                        }
                    }
                    else {
                        errElement.innerHTML = element.value;
                        bResult = false;
                        break;
                    }
                }
            }
        }
        
    }
    catch {}
    return bResult;
}
function structuredDpsTreeviewToggle(n) {
	try {
		n.parentNode.parentElement.querySelector(".treeviewNested").classList.toggle("treeviewActive");
		//n.parentElement.parentElement.classList.toggle("treeviewLiActive");
		if(n.parentElement !== null ) {
			if(n.parentElement.parentElement !== null) {  
				if(n.parentElement.parentElement.nextSibling !== null) {
					n.parentElement.parentElement.classList.toggle("treeviewLiNotActive");
				}
				else { // last Li 
					n.parentElement.parentElement.classList.toggle("treeviewLiNotActiveLastChild");
				}
			}
		}
		n.classList.toggle("treeviewCaret-down");
	} catch {}
}
function menuStructuredDpdecodedJson(json, path, iTabs, dptype, readonly) {
	try {
		var result = "";
		var tabStr = "";
        var obj, obj1, attrName, attrValue, key;
        var size1 = 20, size = 10;
        var nameSize = 10;
        var path1;
        if(iTabs === 0)
            result += dptype;

		if ((typeof json === 'string') || (typeof json === 'number') 
			|| (typeof json === 'boolean'))
		{
			//result += json;
            if(readonly)
                result += json;
            else {
                if(typeof json === 'string')
                    size = json.length + 2;
                else if ((typeof json === 'number') || (typeof json === 'boolean'))
                    size = json.toString().length + 2;
                if(size > size1)
                    size = size1;
                result += "<br>" + tabStr +  "<input id='structuredDpId_" + path + "' value='" + json +"' size='" + size + "'>";
                obj1 = {};
                obj1.field = attrName;
                obj1.fieldPath = path;
                obj1.type = typeof  json;
                obj1.value = json;
                obj1.displayId = "structuredDpId_" + path;
                g_structuredDpsDialogFields.push(obj1);
            }
		}
		else if ((json !== null) && (typeof json === 'object'))
		{	// object
				
			//sTemp = JSON.stringify(json);
			
			tabStr = "";
			for(j=0; j < ((iTabs + 1) * 10); j++)
			{
				//tabStr += "\t";
                tabStr += "&nbsp;"
			}
            if(iTabs === 0)
                path = "";
			for(key in json){
					attrName = key;
					attrValue = json[key];
                
                
				if ((typeof  attrValue === 'string') || (typeof  attrValue === 'number')
					|| (typeof attrValue === 'boolean')) {
					//result += "\r\n" + tabStr + attrName + ": " + attrValue;
                    result += "<br>" + tabStr + attrName.padEnd(nameSize," ") + ": ";
                    if(readonly)
                        result += attrValue;
                    else {
                        if(typeof attrValue === 'string')
                            size = attrValue.length + 2;
                        else if ((typeof attrValue === 'number') || (typeof attrValue === 'boolean'))
                            size = attrValue.toString().length + 2;
                        if(size > size1)
                            size = size1;
                        path1 = path;
                        if(path1 !== "")
                            path1 += "/";
                        path1 += key;
                        result += "<input id='structuredDpId_" + path1 + "' value='" + attrValue +"' ' size='" + size + "'>";
                        obj1 = {};
                        obj1.field = attrName;
                        
                        obj1.fieldPath = path1;
                        obj1.type = typeof  attrValue;
                        obj1.value = attrValue;
                        obj1.displayId = "structuredDpId_" + path1;
                        g_structuredDpsDialogFields.push(obj1);
                    }
                }
				else if(attrValue === null) {
                    result += "<br>" + tabStr + attrName.padEnd(nameSize," ") + ": ";
                    if(readonly)
                        result += "null";
					    //result += "\r\n" + tabStr + attrName + ": null";
                    else {
                        path1 = path;
                        if(path1 !== "")
                            path1 += "/";
                        path1 += key;
                        result += "<input id='structuredDpId_" + path1  + "' value='\"null\"' ' size='" + size + "'>";
                        //result += "\r\n" + tabStr + attrName + ": " + "<" 
                        obj1 = {};
                        obj1.field = attrName;
                        obj1.fieldPath = path1;
                        obj1.type = typeof  attrValue;
                        obj1.value = "null";
                        obj1.displayId = "structuredDpId_" + path1;
                        g_structuredDpsDialogFields.push(obj1);
                    }

                }
				else {
                    path1 = path;
                    if(path1 !== "")
                        path1 += "/";
                    path1 += attrName;
                    result += "<br>" + tabStr + attrName.padEnd(nameSize," ") + ":";
                    //result += "\r\n" + tabStr + attrName + ":"; //fix add to brower.html
					result +=  menuStructuredDpdecodedJson(attrValue, path1, iTabs + 1, dptype, readonly);
                }
					
			}
		}
	}
	catch(err) {}
	return result;

}

function createFieldListFromSnvtType(dpType) {
    //saveObj: contains information about what function performs save
    g_menuStructureDpFieldList = [];
    try {
		
        if(dpType.valueType === "OBJECT")
        
        createFieldListFromSnvtType1("", 1, dpType.typeJson.members);
    }
	catch(err) { 
            
    }
	return g_menuStructureDpFieldList;

}
function createFieldListFromSnvtType1(path, iLevel, dpType) {
	try {
		var result = "";
		var tabStr = "";
        var obj, obj1, attrName, attrValue, key;
        var size1 = 20, size = 10;
        var nameSize = 10;
        var path1;
        for(i=0; i < dpType.length; i++)
        {
            path1 = path;
            if(path !== "")
                path1 += "/";
            path1 += dpType[i].id;
            if((dpType[i].type === "object") || (dpType[i].type === "aggregate"))
                createFieldListFromSnvtType1(path1, iLevel, dpType[i].members);
            else {
                
                g_menuStructureDpFieldList.push(path1);
            }
        }

	}
	catch(err) {}
}