/*************************************************************************************************
 *  browsernodred.js
 * 
 *  Contains code for Node-RED.
 * 
 *  
 * 
 *	Copyright (C) 2023 EnOcean GmbH.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	EnOcean Example Software License Agreement which is available at
 *	https://enoceanwiki.atlassian.net/wiki/spaces/LON/pages/2425260/Example+Software+License+Agreement.   
 * 
 ***************************************************************************************************/
 function getDpInfoNodeRed(mode) {
	//mode: 1=show NodeRed
	var current = new Date();
	var element;
	if(((mode !== 1) && (g_iMainDisplayMode !== DISPLAYMODE_DPINFO)) || ((mode === 1) && (g_iMainDisplayMode !== DISPLAYMODE_NODERED)))
		return;
	if(mode === 1) {
		element = document.getElementById("displayLabel");
		if(element !== null)
			element.innerHTML = "Node-RED input/output nodes";
		g_sDpInfoProgrammaticPathname = "_all_";
		g_sDpInfoPaneContent = "";
		document.getElementById("main").innerHTML =  "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting Node Red DP Info ...</span></div>";
	}
	else if (mode === 19){

	}
	else if(g_sDpInfoProgrammaticPathname === "")
		return;
	if(mode !== 1)
		g_sDpInfoPaneContent += "<br><br>Node Red:" 
	var url = "https://" + location.host + "/node-red/flows?_=" + current.getTime();
	requestGetData(mode, url, getDpInfoNodeRedResponse, getDpInfoResponseFail);
		
}
function getDpInfoNodeRedResponse(mode, requestUrl, json) {
	// mode: 0= Device or DP, 1=all, 19=eps
	try {
		let i,j, k, m, z, bFoundTab, bTabDisabled, bContinue, bShowEps = false, iCount = 0, iMqttCount = 0;
		var calculatedPollRate = 0, avePollRate = 0, numberOfDps = 0;
		var sTemp = "", sTemp1 = "", sTemp2 = "", sConnectionPath = g_sConnectionsDpDeviceName + "/" + g_sConnectionsDpName;
		var sMqttInput = "";
		var sNames;
		var sPath = "";
		var selectedDp = [];
		var obj, flowTabs = [], rowData = [];
		var flowTabIndex = -1;
		var content = "";

		if((g_iMainDisplayMode !== DISPLAYMODE_DPINFO) && (g_iMainDisplayMode !== DISPLAYMODE_NODERED))
			return;
		if(g_iMainDisplayMode === DISPLAYMODE_NODERED)
			g_sNodeRed = "";
		if(mode === 19) {
			mode = 1;
			bShowEps = true;
		}
		if(json.length > 0) {
			for(i=0; i < json.length; i++)
			{
				if(json[i].type === "tab") {
					obj = {};
					obj = json[i];
					obj.contextList = [];
					obj.deviceList = [];
					obj.fixCount = 0;
					obj.relativeCount = 0;
					obj.inputCount = 0;
					obj.outputCount = 0;
					obj.fastest = "";
					obj.slowest = "";
					obj.eps = "";
					flowTabs.push(obj);
					
				}
			}
			for(i=0; i < json.length; i++)
			{
				if((json[i].type === "mqtt in") || (json[i].type === "mqtt out")) {
					if(g_iMainDisplayMode === DISPLAYMODE_NODERED) {
						iMqttCount ++;
						sMqttInput += "<tr><td>" + iMqttCount + "</td>";

						if(json[i].name === "")
							sMqttInput += "<td>" + json[i].type + "</td>";
						else
							sMqttInput += "<td>" + json[i].name + "</td>";
						sMqttInput += "<td>" + json[i].id + "</td><td>" + json[i].type + "</td>";
						
						sMqttInput += "<td>" + json[i].topic + "</td>";
						
						sMqttInput += "</tr>";
					}
				}
				else if((json[i].type === "iap-output") || (json[i].type === "iap-input-sub")) {
					selectedDp = JSON.parse(json[i].selecteddp);
					if(selectedDp.length > 0) {
						for(j=0; j < selectedDp.length; j++)
						{
							sTemp = "";
							if((mode === 1) || (g_bDpInfoForDevice)) {
								if((mode === 1) || (selectedDp[j].deviceName === g_sConnectionsDpDeviceName)) {
									flowTabIndex = -1;
									iCount ++;
									if(json[i].name === "")
										sTemp += "<td>" + json[i].type + "</td>";
									else
										sTemp += "<td>" + json[i].name + "</td>";
									sTemp += "<td>" + json[i].id + "</td><td>" + json[i].type + "</td>";
									
									sTemp += "<td>" + selectedDp[j].deviceName;
									sTemp += "/" + selectedDp[j].blockName + "/" + selectedDp[j].blockIndex;
									sTemp += "/" + selectedDp[j].datapointName + "</td>";
									sTemp += "<td>" + selectedDp[j].name + "</td>";
									sTemp += "<td>" + selectedDp[j].datapointName + "</td>";
									
									
									try {
										bFoundTab = false;
										bTabDisabled = false;
										//polling data
										for(k=0; k< flowTabs.length; k++)
										{
												if(flowTabs[k].id === json[i].z) {
													flowTabIndex = k;
													bFoundTab = true;
													sTemp += "<td>" + flowTabs[k].label + "</td>";
													if(!flowTabs[k].disabled)
														sTemp += "<td>true</td>";
													else
														sTemp += "<td></td>";
													if(mode === 1) {
														if(json[i].type === "iap-input-sub") {
															if(json[i].polling !== "0") {
																z = Number(json[i].polling);
																if(!flowTabs[k].disabled) {
																	
																	calculatedPollRate += (1 / z);
																	avePollRate += z;
																	numberOfDps ++;
																	g_epsInfo.nodeRedPollAve += z;
																	g_epsInfo.nodeRedDpCount ++;
																	g_epsInfo.nodeRedEps += (1 / z);
																	
																}
																if(flowTabs[k].fastest === "") {
																	flowTabs[k].fastest = z;
																	flowTabs[k].slowest = z;
																	flowTabs[k].eps = (1 / z);
																}
																else {
																	if( z <flowTabs[k].fastest)
																		flowTabs[k].fastest = z;
																	if( z > flowTabs[k].slowest)
																		flowTabs[k].slowest = z;
																	flowTabs[k].eps += (1 / z);
																}
															}
														}
														
													}
													break;
												}
										}
										if(!bFoundTab) {
											sTemp += "<td></td>-<td></td>";
											if(mode === 1) {
												if(json[i].type === "iap-input-sub") {
													if(json[i].polling !== "0") {
														z = Number(json[i].polling);
														calculatedPollRate += (1 / z);
														avePollRate += z;
														numberOfDps ++;
														g_epsInfo.nodeRedPollAve += z;
														g_epsInfo.nodeRedDpCount ++;
														g_epsInfo.nodeRedEps += (1 / z);
													}
												}
											}
										}
										// flow tab data
										if((mode === 1) && (flowTabIndex !== -1)) {
											
											if(json[i].fixed)
												flowTabs[flowTabIndex].fixCount ++;
											else
												flowTabs[flowTabIndex].relativeCount ++;
											
											if(json[i].type === "iap-input-sub")
												flowTabs[flowTabIndex].inputCount ++;
											else
												flowTabs[flowTabIndex].outputCount ++;
											// contexts - ignore context for relative datapoints as this changes after apply - only include contexts for fixd datapoints
											z = -1;
											if(!json[i].fixed && (json[i].type === "iap-input-sub")) {
												/*
												if(typeof selectedDp[j].context.name !== "undefined") {
													for(m=0; m< flowTabs[flowTabIndex].contextList.length; m++)
													{
														if(flowTabs[flowTabIndex].contextList[m] === selectedDp[j].context.name) {
															z = m;
															break;
														}
													}
												}
												if(z === -1)
													flowTabs[flowTabIndex].contextList.push(selectedDp[j].context.name);
													*/
											}
											else if(!json[i].fixed && (json[i].type === "iap-output")) {
												/*
												if(typeof selectedDp[j].payload.context.name !== "undefined") {
													for(m=0; m< flowTabs[flowTabIndex].contextList.length; m++)
													{
														if(flowTabs[flowTabIndex].contextList[m] === selectedDp[j].payload.context.name) {
															z = m;
															break;
														}
													}
												}
												if(z === -1)
													flowTabs[flowTabIndex].contextList.push(selectedDp[j].payload.context.name);
													*/
											}
											else  {
												// ignore context for relative datapoints - only on flow tabs not service flow tabs
													if(typeof selectedDp[j].contextFullPath !== "undefined") {
														for(m=0; m< flowTabs[flowTabIndex].contextList.length; m++)
														{
															if(flowTabs[flowTabIndex].contextList[m] === selectedDp[j].contextFullPath[0]) {
																z = m;
																break;
															}
														}
													}
													if(z === -1)
														flowTabs[flowTabIndex].contextList.push(selectedDp[j].contextFullPath[0]);
												
											}
											// devices
											z = -1;
											if(!json[i].fixed && (json[i].type === "iap-input-sub")) {
												
												for(m=0; m< flowTabs[flowTabIndex].deviceList.length; m++)
												{
													if(flowTabs[flowTabIndex].deviceList[m] === selectedDp[j].deviceName) {
														z = m;
														break;
													}
												}
												
												if(z === -1)
													flowTabs[flowTabIndex].deviceList.push(selectedDp[j].deviceName);
											}
											else if(!json[i].fixed && (json[i].type === "iap-output")) {
												
												for(m=0; m< flowTabs[flowTabIndex].deviceList.length; m++)
												{
													if(flowTabs[flowTabIndex].deviceList[m] === selectedDp[j].deviceName) {
														z = m;
														break;
													}
												}
												
												if(z === -1)
													flowTabs[flowTabIndex].deviceList.push(selectedDp[j].deviceName);
											}
											else  {
												
												for(m=0; m< flowTabs[flowTabIndex].deviceList.length; m++)
												{
													if(flowTabs[flowTabIndex].deviceList[m] === selectedDp[j].deviceName) {
														z = m;
														break;
													}
												}
												
												if(z === -1)
													flowTabs[flowTabIndex].deviceList.push(selectedDp[j].deviceName);
											}
										}
										
										if(json[i].type === "iap-input-sub")
											sTemp += "<td>" + json[i].polling + "</td>";
										else
											sTemp += "<td></td>";
										
										if(json[i].fixed)
											sTemp += "<td>Fixed</td>";
										else
											sTemp += "<td>Relative</td>";
										
										sTemp += "<td>" + selectedDp[j].device.deviceTypeName + "</td>";
										if(!json[i].fixed && (json[i].type === "iap-input-sub")) {
											// relative DP input node
											if(typeof selectedDp[j].context !== "undefined") {
												if(typeof selectedDp[j].context.contextType !== "undefined") {
													sTemp += "<td>" + selectedDp[j].context.contextType + "</td>";
												}
												else 
													sTemp += "<td></td>";
												if(typeof selectedDp[j].context.name !== "undefined") {
													sTemp += "<td>" + selectedDp[j].context.name + "</td>";
												}
												else 
													sTemp += "<td></td>";
												if(typeof selectedDp[j].context.description === "undefined") {
													if(selectedDp[j].context.description !== null) {
														z = 1;
														sTemp += "<td class=\"tdValueDiv\">" + selectedDp[j].context.description + "</td>";
													}
													else 
														sTemp += "<td></td>";
												}
												else 
													sTemp += "<td></td>";
											}
											else 
												sTemp += "<td></td><td></td><td></td>";
										}
										else if(!json[i].fixed && (json[i].type === "iap-output")){
											// relative DP output node
											if(typeof selectedDp[j].payload.context !== "undefined") {
												if(typeof selectedDp[j].payload.context.contextType !== "undefined") {
													sTemp += "<td>" + selectedDp[j].payload.context.contextType + "</td>";
												}
												else 
													sTemp += "<td></td>";
												if(typeof selectedDp[j].payload.context.name !== "undefined") {
													sTemp += "<td>" + selectedDp[j].payload.context.name + "</td>";
												}
												else 
													sTemp += "<td></td>";
												if(typeof selectedDp[j].payload.context.description === "undefined") {
													if(selectedDp[j].payload.context.description !== null) {
														z = 1;
														sTemp += "<td class=\"tdValueDiv\">" + selectedDp[j].payload.context.description + "</td>";
													}
													else 
														sTemp += "<td></td>";
												}
												else 
													sTemp += "<td></td>";
											}
											else 
												sTemp += "<td></td><td></td><td></td>";
										}
										else {
											// fixed DP nodes
											sTemp += "<td>-</td>";
											if(typeof selectedDp[j].contextFullPath !== "undefined") {

												if(selectedDp[j].contextFullPath.length === 0 )
													sTemp += "<td></td>";
												else 
													sTemp += "<td>" + removeSpacesInPathname(JSON.stringify(selectedDp[j].contextFullPath[0]), "/") + "</td>";
											}
											sTemp += "<td></td>";	
											
										}
										
										//if(z === -1)
										//	sTemp += "<td></td>";
									}
									catch {}
									//sTemp += "</tr>";
									obj = {};
									obj.path =  selectedDp[j].deviceName + "/" + selectedDp[j].blockName + "/" + selectedDp[j].blockIndex + "/" + selectedDp[j].datapointName + " ";
									obj.str = sTemp;
									rowData.push(obj);
									break;
								}
							}
							else {
								sPath = selectedDp[j].deviceName;
								sPath += "/" + selectedDp[j].blockName + "/" + selectedDp[j].blockIndex;
								//sPath += "/" + selectedDp[j].datapointName;
								sPath += "/" + selectedDp[j].name;  
								if(sPath === sConnectionPath) {
									if(json[i].name === "")
										sTemp += "<td>" + json[i].type + "</td>";
									else
										sTemp += "<td>" + json[i].name + "</td>";
									sTemp += "<td>" + json[i].id + "</td><td>" + json[i].type + "</td>";
									sTemp += "<td>" + selectedDp[j].deviceName;
									sTemp += "/" + selectedDp[j].blockName + "/" + selectedDp[j].blockIndex;
									sTemp += "/" + selectedDp[j].datapointName + "</td>";
									sTemp += "<td>" + selectedDp[j].name + "</td>";
									sTemp += "<td>" + selectedDp[j].datapointName + "</td>";
									try {
									
									
										bFoundTab = false;
										bTabDisabled = false;
										for(k=0; k< flowTabs.length; k++)
										{
												if(flowTabs[k].id === json[i].z) {
													bFoundTab = true;
													sTemp += "<td>" + flowTabs[k].label + "</td>";
													if(!flowTabs[k].disabled)
														sTemp += "<td>true</td>";
													else
														sTemp += "<td></td>";
													break;
												}
										}
										if(!bFoundTab)
											sTemp += "<td></td><td>-</td>";
										if(json[i].type === "iap-input-sub")
											sTemp += "<td>" + json[i].polling + "</td>";
										else
											sTemp += "<td></td>";
										if(json[i].fixed)
											sTemp += "<td>Fixed</td>";
										else
											sTemp += "<td>Relative</td>";
										sTemp += "<td>" + selectedDp[j].device.deviceTypeName + "</td>";
										if(typeof selectedDp[j].context !== "undefined") {
											if(typeof selectedDp[j].context.contextType !== "undefined") {
												sTemp += "<td>" + selectedDp[j].context.contextType + "</td>";
											}
											else 
												sTemp += "<td></td>";
											if(typeof selectedDp[j].context.name !== "undefined") {
												sTemp += "<td>" + selectedDp[j].context.name + "</td>";
											}
											else 
												sTemp += "<td></td>";
											if(typeof selectedDp[j].context.description === "undefined") {
												if(selectedDp[j].context.description !== null) {
													z = 1;
													sTemp += "<td class=\"tdValueDiv\">" + selectedDp[j].context.description + "</td>";
												}
												else 
													sTemp += "<td></td>";
											}
											else 
												sTemp += "<td></td>";
										}
										else 
											sTemp += "<td></td><td></td><td></td>";
									}
									catch {}
									
									//sTemp += "</tr>";
									obj = {};
									obj.path =  selectedDp[j].deviceName + "/" + selectedDp[j].blockName + "/" + selectedDp[j].blockIndex + "/" + selectedDp[j].datapointName + " ";
									obj.str = sTemp;
									rowData.push(obj);
									break;
								}
							}
						}
						
					}
				}
			}
			sTemp = "";
			if(rowData.length > 0) {
				// sort
				bContinue = true;
				while(bContinue)
				{
					bContinue = false;
					for(i=0; i < (rowData.length - 1); i++)
					{
						if(rowData[i].path > rowData[i+1].path) {
							obj = {};
							obj = rowData[i];
							rowData[i] = rowData[i + 1];
							rowData[i + 1] = obj;
							bContinue = true;
						}
					}
				}
				for(i=0; i < rowData.length; i++)
				{
					sTemp += "<tr><td>" + (i + 1).toString() + "</td>" + rowData[i].str + "</tr>";
				}
			}
			if(sTemp === "")
				content += "none";
			else {
				if((mode === 1) || (g_bDpInfoForDevice)) {
					content += "<br><br><table id=\"myTable\"><thead>";
					content += "<th onclick=\"sortTable(0)\">#</th>";
					content += "<th onclick=\"sortTable(1)\">Node Name</th><th onclick=\"sortTable(2)\">Id</th><th onclick=\"sortTable(3)\">Node Red Type</th>";
					
					content += "<th onclick=\"sortTable(4)\">DP</th>";
					content += "<th onclick=\"sortTable(5)\">DP Instance Name</th>";
					content += "<th onclick=\"sortTable(6)\">DP XIF Name</th>";
					
					content += "<th onclick=\"sortTable(7)\">Flow Tab</th><th onclick=\"sortTable(8)\">Tab Enabled</th>";
					content += "<th onclick=\"sortTable(9)\">Poll Rate</th><th onclick=\"sortTable(10)\">Datapoint Type</th>";
					content += "<th onclick=\"sortTable(11)\">Device Type</th>";
					content += "<th onclick=\"sortTable(12)\">Context Type</th><th onclick=\"sortTable(13)\">Contexts</th>";
					content += "<th onclick=\"sortTable(14)\">Description</th>";
					content += "</thead>" + sTemp + "</table>";
				}
				else {
					content += "<br><br><table id=\"myTable\"><thead>";
					content += "<th onclick=\"sortTable(0)\">#</th>";
					content += "<th onclick=\"sortTable(1)\">Node Name</th><th onclick=\"sortTable(2)\">Id</th>";
					content += "<th onclick=\"sortTable(3)\">Node Red Type</th>";
					content += "<th onclick=\"sortTable(4)\">DP</th>";
					content += "<th onclick=\"sortTable(5)\">DP Instance Name</th>";
					content += "<th onclick=\"sortTable(6)\">DP XIF Name</th>";
					
					content += "<th onclick=\"sortTable(7)\">Flow Tab</th><th onclick=\"sortTable(8)\">Tab Enabled</th>";
					content += "<th onclick=\"sortTable(9)\">Poll Rate</th><th onclick=\"sortTable(10)\">Datapoint Type</th>";
					content += "<th onclick=\"sortTable(11)\">Device Type</th>";
					content += "<th onclick=\"sortTable(12)\">Context Type</th><th onclick=\"sortTable(13)\">Contexts</th>";
					content += "<th onclick=\"sortTable(14)\">Description</th>";
					content += "</thead>" + sTemp + "</table>";
				}
				sTemp2 = "<br><br>Calculated (Enabled Tabs):";
				calculatedPollRate = calculatedPollRate.toFixed(2);
				sTemp2 += "<br>DPs polled per second = " + calculatedPollRate;
				sTemp2 += "<br>ave poll rate = ";
				if(numberOfDps !== 0) {
					sTemp1 = (avePollRate / numberOfDps);
					sTemp1 = sTemp1.toFixed(2);
					sTemp2 += sTemp1;
					g_epsInfo.nodeRedPollAve = Number(sTemp1);
					
				}
				else
					sTemp2 += "0";
				sTemp2 += " s";
				sTemp2 += "<br>Num Of Polled DPs = " + numberOfDps;
				if(mode === 1) {

					//add flow tab table
					sTemp = "";
					sTemp += "Flow Tabs:<br><table id=\"myTable1\"><thead><tr>";
					sTemp += "<th onclick=\"sortTable1('myTable1', 0)\">#</th>";
					sTemp += "<th onclick=\"sortTable1('myTable1', 1)\">Flow Tab</th><th onclick=\"sortTable1('myTable1', 2)\">Enabled</th>";
					sTemp += "<th onclick=\"sortTable1('myTable1', 3)\"># of Contexts</th>";
					sTemp += "<th onclick=\"sortTable1('myTable1', 4)\"># of Devices</th><th onclick=\"sortTable1('myTable1', 5)\"># of Fixed DPs</th>"
					sTemp += "<th onclick=\"sortTable1('myTable1', 6)\"># of Relative DPs</th><th onclick=\"sortTable1('myTable1', 7)\"># of Input Nodes</th>";
					sTemp += "<th onclick=\"sortTable1('myTable1', 8)\"># of Output Nodes</th>";
					sTemp += "<th onclick=\"sortTable1('myTable1', 9)\">Fastest Poll Rate (s)</th><th onclick=\"sortTable1('myTable1', 10)\">Slowest Poll Rate (s)</th>";
					sTemp += "<th onclick=\"sortTable1('myTable1', 11)\">Calculated EPS</th>";
					sTemp += "</tr></thead><tbody>";
					for(m=0; m < flowTabs.length; m++)
					{
						sTemp += "<tr><td>" + (m+1).toString() + "</td><td>" + flowTabs[m].label  + "</td>";
						if(!flowTabs[m].disabled)
							sTemp += "<td>true</td>";
						else
							sTemp += "<td></td>";
						sTemp += "<td>" + flowTabs[m].contextList.length + "</td><td>" + flowTabs[m].deviceList.length + "</td>";
						sTemp += "<td>" + flowTabs[m].fixCount + "</td><td>" + flowTabs[m].relativeCount + "</td>";
						sTemp += "<td>" + flowTabs[m].inputCount + "</td><td>" + flowTabs[m].outputCount + "</td>";
						sTemp += "<td>" + flowTabs[m].fastest + "</td><td>" + flowTabs[m].slowest + "</td>";
						if(flowTabs[m].eps === "")
							sTemp += "<td></td>";
						else {
							sTemp += "<td>" + flowTabs[m].eps.toFixed(2);
							if(flowTabs[m].disabled)
								sTemp += " (not enabled)";
							sTemp += "</td>";
						}
						sTemp += "</tr>";
					}
					sTemp += "</tbody></table>"
					if(mode === 1)
						content = sTemp + sTemp2 + "<br><br>Nodes:" + content;
					else 
						content= sTemp + "<br><br>Nodes:" + content + sTemp2;
					/*
					if(mode === 1)
						g_sDpInfoPaneContent = sTemp + sTemp2 + "<br><br>Nodes:" + g_sDpInfoPaneContent;
					else 
						g_sDpInfoPaneContent = sTemp + "<br><br>Nodes:" + g_sDpInfoPaneContent + sTemp2;
						*/
				}
				
			}
			if(g_iMainDisplayMode === DISPLAYMODE_DPINFO) {
				g_sDpInfoPaneContent += content + "<br></br><br>"; 
				g_sDpInfoPaneContent += addTopButton();
			}
			else if(g_iMainDisplayMode === DISPLAYMODE_NODERED) { //yyyy
					g_sNodeRed  += content + "<br></br><br>";
					g_sNodeRed += addTopButton();
			}
		}
		else {
			if(g_iMainDisplayMode === DISPLAYMODE_DPINFO)
				g_sDpInfoPaneContent += " None<br></br><br>"; 
			else if(g_iMainDisplayMode === DISPLAYMODE_NODERED)
				g_sNodeRed  += " None<br></br><br>";
		}
		
		if(g_iMainDisplayMode === DISPLAYMODE_DPINFO) {
			if(bShowEps) {
				calculateEpsShowResults();
				return;
			}
			document.getElementById("main").innerHTML = g_sDpInfoPaneContent;
			if(g_bDpInfoShowDatalogButton){
				document.getElementById("deviceInfoDatalogButton").className === "deviceInfoDatalogButton";
				document.getElementById("deviceInfoDatalogButton").innerHTML = "<button onclick=\"showDataLog2('" + g_sDpInfoPathname + "','" + g_sDpInfoProgrammablePathname + "',null)\">Get Data Log</button>";
			}
		}
		else if(g_iMainDisplayMode === DISPLAYMODE_NODERED) { 
			sTemp = "<table id=\"mqttTable\"><thead><th onclick=\"sortTable1('mqttTable', 0)\">#</th><th onclick=\"sortTable1('mqttTable', 1)\">Name</th>";
			sTemp += "<th onclick=\"sortTable1('mqttTable', 2)\">ID</th><th onclick=\"sortTable1('mqttTable', 3)\">Type</th><th onclick=\"sortTable1('mqttTable', 4)\">Topic</th></tr></thead>"
			sMqttInput = sTemp + "<tbody>" + sMqttInput + "</tbody></table>";
			sTemp = g_sNodeRed;
			g_sNodeRed = "<br><br>MQTT Input/Output Nodes<br>";
			if(sMqttInput === "")
				g_sNodeRed += "none";
			else
				g_sNodeRed += sMqttInput;
			g_sNodeRed += "<br><br>IAP Input/Output Nodes<br>" + sTemp;
			
			document.getElementById("main").innerHTML = g_sNodeRed;
		}
		
	}
	catch {}
		cursorClearWait(); //document.getElementById("main").style.cursor = "default"
	;
}
function getDpInfoResponseFail(mode, requestUrl, json) {
	if(g_iMainDisplayMode !== DISPLAYMODE_DPINFO)
			return;
	if(mode === 19) {
		calculateEpsShowResults();
		return;
	}
	if(g_sDpInfoPaneContent !== "")
		g_sDpInfoPaneContent += "<br><br>"
	g_sDpInfoPaneContent += "Error getting all Datapoint Info for " + g_sDpInfoPathname;
	document.getElementById("main").innerHTML = g_sDpInfoPaneContent;
}
function showNodeRed(mode) {
	// mode: 0= refresh all, 3=specific datapoint
	var paneTitle = "<label id=\"displayLabel\">Node-RED</label><div style=\"float:right\">";
	var paneContent = "<br><span id=\"gettingInfoId\" class=\"getting Node-RED Info\"></span></div>";
	savePrevousHtmlContent();
	initializeDisplay();
	g_iMainDisplayMode = DISPLAYMODE_NODERED; 
	paneTitle += "<div style=\"display:inline-block;float:right\">";
	paneTitle += "<button onclick=\"saveData(0)\">Save</button><button  onclick=\"getDpInfoNodeRed(1)\">Refresh</button></div>";
	//<button  onclick=\"calculateEps()\">Calculate EPS</button>
	document.getElementById("main-Header").innerHTML = paneTitle;
	document.getElementById("main").innerHTML = paneContent;
	if(g_sNodeRed !== "") {
		document.getElementById("main").innerHTML = g_sNodeRed;
	}
	else {
		getDpInfoNodeRed(1);
	}
	
}