/*************************************************************************************************
 *  browserlicense.js
 * 
 *  Contains code for SmartServer License code - Device Capacity and Maintenance.
 * 
 *  
 * 
 *	Copyright (C) 2023 EnOcean GmbH.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	EnOcean Example Software License Agreement which is available at
 *	https://enoceanwiki.atlassian.net/wiki/spaces/LON/pages/2425260/Example+Software+License+Agreement.  
 * 
 ***************************************************************************************************/
 var g_bShowLicenseCloud = false;
 var g_oLicenseCloud = [];
 var g_oCurrentLicense = [];
 var g_oLicenseStatus = null;
 var g_notActivatedLicenses = [];
function showLicense(mode) {
	// mode: 0= refresh all, 3=specific datapoint
	var paneTitle = "<label id=\"displayLabel\">SmartServer Licenses</label><div style=\"float:right\">";
	var paneContent = "<br>";
	savePrevousHtmlContent();
	initializeDisplay();
	g_bLicenseRevokeGetLatest = false;
	g_bShowLicenseCloud = false;
	g_oLicenseCloud = [];
	g_oCurrentLicense = [];
	if(g_iSmartServerVersion < 330000)
		return;
	g_iMainDisplayMode = DISPLAYMODE_LICENSING; 
	paneTitle += "<div style=\"display:inline-block;float:right\">";
	paneTitle += "<button onclick=\"showLicensesShowKey(0)\">Show Key</button>";
	paneTitle += "<button onclick=\"showLicensesCurrent(0)\">Show Current Licenses</button><button  onclick=\"showLicensesDownloadLicensesFromCloud(0)\">Download Available Licenses</button>";
	paneTitle += "<button id=\"showLicensesOffline\" onclick=\"showLicensesOfflineActivation(0)\">OffLine Import</button>";
	// not supported yet paneTitle += "<button onclick=\"showLicensesEditNotification(0)\">Edit Notifications</button>";
	paneTitle += "<button onclick=\"showLicensesReturn(0)\">Return Licenses</button></div>";
	//<button  onclick=\"calculateEps()\">Calculate EPS</button>
	document.getElementById("main-Header").innerHTML = paneTitle;
	document.getElementById("main").innerHTML = paneContent;
	
	showLicensesCurrent(0);
	
}
function showLicensesShowKey(mode) {
	try {
		var paneTitle = "<label id=\"displayLabel\">SmartServer Customer License Key</label><div style=\"float:right\"><button onclick=\"showLicense(0)\">BACK</button></div>";
		var paneContent = "<br><div style=\"margin-left:50px\">";
		paneContent += "<input id=\"licenseKeyInput\" type=\"text\" value=\""; 
		if(g_oLicenseStatus !== null) {
			if(g_oLicenseStatus.length === 1) {
				if(typeof g_oLicenseStatus[0].licensingId !== "undefined") {
					paneContent += g_oLicenseStatus[0].licensingId;
				}
			}
		}
		paneContent += "\" size=\"50\"><button style=\"margin-left:20px\" onclick=\"showLicenseReplacekey()\">Change</button><br><br><div id\"licenseShowKeyNotes\" style=\"color:red\"></div></div>";
		document.getElementById("main-Header").innerHTML = paneTitle;
		document.getElementById("main").innerHTML = paneContent;
	}
	catch {}
}
function showLicenseReplacekey() {
	try {
		var url = "https://" + location.host + "/iap/lic/accounts?segmnetId=1";
		var payload = "";
		var element = document.getElementById("licenseKeyInput");
		var value;
				//<button  onclick=\"calculateEps()\">Calculate EPS</button>
		if(element !== null) {
			value = element.value;
			if(value === "") {
				alert("No Customer license defined")
				return;
			}
			requestPutData(0, url, value, showLicenseReplacekeyResponse, showLicenseReplacekeyFailCallback); // data in WebSocket update 
		}
	}
	catch {}
}
function showLicenseReplacekeyResponse(mode,url,json) {
	try {
		getSmartServerLicenseInfo();
		showLicense(1);
	}
	catch {}
}
function showLicenseReplacekeyFailCallback(mode,url,json) {
	try {
		var element = document.getElementById("licenseShowKeyNotes");
		if(element !== null) {
			element.innerHTML = "*** Error: write failed. ***"
		}

	}
	catch {}
}
function showLicensesCurrent(mode) {
	try {
		g_bShowLicenseCloud = false;
		var url = "https://" + location.host + "/iap/lic";
		
		var paneContent = "<br><br>Getting Current Licenses";
		document.getElementById("main").innerHTML = paneContent;
		
		requestGetData(0, url, showLicensesCurrentResponse, null); 
		
	}
	catch {}
	
}
function showLicensesCurrentResponse(mode, url, json) {
	try {
		var count = 0, i;
		var paneContent = "<br><br>Getting Current Licenses<br><br>No License Found<br><br><br>** Note - it can take up to a minute to for changes (online download, activating or revoking the license) to take place";
		

		
		element = document.getElementById("showLicensesOffline");
		if(json.length === 0) {
			document.getElementById("main").innerHTML = paneContent;
			if(element !== null) {
				//element.disabled = false;
			}
			return;
		}
		else {
			if(element !== null) {
				//element.disabled = true;
			}
		}
		g_oCurrentLicense = JSON.parse(JSON.stringify(json));
		paneContent = "<br><br>Current Licenses<br><br>";
		paneContent += "<table id=\"myTable\"><thead><tr><th onclick=\"sortTable(" + count + ")\">Segment Controller</th>";
		count ++;
		paneContent += "<th onclick=\"sortTable(" + count + ")\">Decription</th>";
		count ++;
		paneContent += "<th onclick=\"sortTable(" + count + ")\">Status</th>";
		count ++;
		paneContent += "<th onclick=\"sortTable(" + count + ")\">Activation Date</th>";
		count ++;
		paneContent += "<th onclick=\"sortTable(" + count + ")\">License ID</th>";
		count ++;
		paneContent += "<th onclick=\"sortTable(" + count + ")\">Notes</th>";
		paneContent += "</tr></thead><tbody>";
		for(i=0; i < json.length; i++)
		{
			paneContent += "<tr><td>" + json[i].scName + "</td><td>" + json[i].description + "</td><td>" + json[i].status + "</td><td>" + json[i].activationDate + "</td><td>" + json[i].licenseId + "</td><td>";
			if(typeof json[i].note !== "undefined")
				paneContent += json[i].note;
			paneContent += "</td></tr>"; 
		}
		paneContent += "</tbody></table>"
		paneContent += "<br><br>** Note - it can take up to a minute to for changes to take place (activating or revoking a license)";
		document.getElementById("main").innerHTML = paneContent;
	}
	catch {}
}
function showLicensesDownloadActivate() {
	try {
		var url = "https://" + location.host + "/iap/lic/cloud/download?scName=";
		var payload = [],element, i;
		var paneTitle = "<label id=\"displayLabel\">SmartServer Licenses</label><div style=\"float:right\">";
		var paneContent = "<br><br>Downloading Available Licenses (this may take a while)...";
		g_notActivatedLicenses = [];
		if(g_sSmartServerName === "") {
			alert("Error: can't get SmartServer name");
			return;
		}
		url += g_sSmartServerName;
		
		for(i=0; i < g_oLicenseCloud.length; i++)
		{
			element = document.getElementById("downloadLic_" + g_oLicenseCloud[i].licenseId);
			if(element !== null) {
				if(element.checked) {
					payload.push(g_oLicenseCloud[i].licenseId);
				}
				else {
					g_notActivatedLicenses.push(JSON.parse(JSON.stringify(g_oLicenseCloud[i])))
				}
			}
		}
		
		
		requestPostFunction(1, url, JSON.stringify(payload), showLicensesDownloadActivateResponse, showLicensesDownloadActivateFail); // data in WebSocket update
	}
	catch {}
}
function showLicensesDownloadActivateResponse(mode, url, json) {
	try {
		g_bShowLicenseCloud = true;
		showLicensesDownloadLicensesFromCloudResponse(g_notActivatedLicenses);
	}
	catch {}
}
function showLicensesDownloadActivateFail(mode, url, json) {
	try {
		alert("Error: Activation Failed");
	}
	catch {}
}
function showLicensesDownloadLicensesFromCloud(mode) {
	try {
		var url = "https://" + location.host + "/iap/lic/cloud";
		var payload = "";
		var paneTitle = "<label id=\"displayLabel\">SmartServer Licenses</label><div style=\"float:right\">";
		var paneContent = "<br><br>Downloading Available Licenses (this may take a while)...";
		g_oLicenseCloud = [];
		paneTitle += "<div style=\"display:inline-block;float:right\">";
		paneTitle += "<button onclick=\"showLicense(1)\">BACK</button><button id=\"showLicensesDownloadLicensesFromCloud\"  onclick=\"showLicensesDownloadActivate()\">ACTIVATE</button>";
		paneTitle += "</div>";
		//<button  onclick=\"calculateEps()\">Calculate EPS</button>
		document.getElementById("main-Header").innerHTML = paneTitle;
		document.getElementById("main").innerHTML = paneContent;

		element = document.getElementById("showLicensesDownloadLicensesFromCloud");
		if(element !== null) 
			element.checked = false;
		g_bShowLicenseCloud = true;
		requestPostFunction(mode, url, payload, null, null); // data in WebSocket update 
	}
	catch {}
}
function showLicensesDownloadLicensesFromCloudResponse(json) {
	// web socket respnose only
	try {
		var count = 0, i;
		var paneContent = "<br><br>Downloading Available Licenses<br><br>No License Found";
		if(g_iMainDisplayMode !== DISPLAYMODE_LICENSING) {
			g_bShowLicenseCloud = false;
			return;
		}
		if(!g_bShowLicenseCloud)
			return;
		g_bShowLicenseCloud = false;

		
		if(json.length === 0) {
			document.getElementById("main").innerHTML = paneContent;
			return;
		}
		g_oLicenseCloud = json;
		paneContent = "<br><br>Available Licenses<br><br>";
		paneContent += "<table id=\"myTable\"><thead><tr>";
		paneContent += "<th><div style=\"display:flex\"><input type=\"checkbox\" id=\"downloadLicensesAllCheckbox\" onclick=\"showLicensesDownloadLicensesFromCloudAllChecked()\"></div></th>";
		count ++;
		paneContent += "<th onclick=\"sortTable(" + count + ")\">License ID</th>";
		count ++;
		paneContent += "<th onclick=\"sortTable(" + count + ")\">Transfer Date</th>";
		count ++;
		paneContent += "<th onclick=\"sortTable(" + count + ")\">Description</th>";
		
		paneContent += "</tr></thead><tbody>";
		for(i=0; i < json.length; i++)
		{
			paneContent += "<tr>";
			paneContent += "<td><input type=\"checkbox\" id=\"downloadLic_" + json[i].licenseId + "\" onclick=\"showLicensesDownloadLicensesFromCloudChecked()\"></td>";
			paneContent += "<td id=\"downloadlicId_" + json[i].licenseId + "\">" + json[i].licenseId + "</td><td>" + json[i].description + "</td><td>" + json[i].transferDate + "</td></tr>";
		}
		paneContent += "</tbody></table>"
		document.getElementById("main").innerHTML = paneContent;
	}
	catch {}
}
function showLicensesDownloadLicensesFromCloudAllChecked() {
	try {
		var checked, i, element;
		if(g_iMainDisplayMode !== DISPLAYMODE_LICENSING) {
			return;
		}
		if(g_oLicenseCloud.length === 0)
			return;
		element = document.getElementById("downloadLicensesAllCheckbox");
		if(element !== null) {
			checked = element.checked;
			element = document.getElementById("showLicensesDownloadLicensesFromCloud");
			if(element !== null) {
				element.disabled = !checked;
				for(i=0; i < g_oLicenseCloud.length; i++)
				{
					element = document.getElementById("downloadLic_" + g_oLicenseCloud[i].licenseId);
					if(element !== null) {
						element.checked = checked;
					}
				}
			}
		}
	}
	catch {}
}
function showLicensesDownloadLicensesFromCloudChecked() {
	// used to change the state of Activate button
	try {
		var i, element, bAtLeastOneChecked = false;;
		for(i=0; i < g_oLicenseCloud.length; i++)
		{
			element = document.getElementById("downloadLic_" + g_oLicenseCloud[i].licenseId);
			if(element !== null) {
				if(element.checked)
					bAtLeastOneChecked = true;
			}
		}
		element = document.getElementById("showLicensesDownloadLicensesFromCloud");
		if(element !== null) 
			element.disabled = !bAtLeastOneChecked;

	}
	catch {}
}
function showLicensesEditNotification(mode) {
	alert("TBD");
}
function showLicensesReturn(mode) {
	var url = "https://" + location.host + "/iap/lic/cloud/upload";
	var payload = "";
	var paneContent = "<br><br>Returning Licenses to the cloud (this may take a while - up to a minute)...";
	if(confirm("Are you sure you want to return all the license to the cloud")) {
		
		g_oLicenseCloud = [];
		
		document.getElementById("main").innerHTML = paneContent;

		element = document.getElementById("showLicensesDownloadLicensesFromCloud");
		if(element !== null) 
			element.checked = false;
		g_bShowLicenseCloud = true;
		obj = {};
		obj.include = [];
		payload = JSON.stringify(obj);
		g_bLicenseRevokeGetLatest = true;
		requestPostFunction(1, url, payload, showLicensesReturnResponse, showLicensesReturnFailCallback); // data in WebSocket update 
	}
	
}
function showLicensesReturnResponse(mode, url, json) {
	try {
		showLicensesCurrent(0);
	}
	catch {}

}
function showLicensesReturnFailCallback(mode, url, json) {
	try {
		alert("Failed to upload licenses to cloud");
		showLicensesCurrent(0);
	}
	catch {}

}
function showLicensesOfflineActivation(mode){
	try {
	
		var paneTitle = "<label id=\"displayLabel\">SmartServer Offline License Import</label><div style=\"float:right\">";
		var paneContent = "<br><br>Downloading Available Licenses (this may take a while)...";
		paneTitle += "<div style=\"display:inline-block;float:right\">";
		paneTitle += "<button onclick=\"showLicense(1)\">BACK</button><button id=\"showLicensesDownloadLicensesFromCloud\"  onclick=\"showLicensesDownloadActivate()\">ACTIVATE</button>";
		paneTitle += "</div>";
		//<button  onclick=\"calculateEps()\">Calculate EPS</button>
		document.getElementById("main-Header").innerHTML = paneTitle;
		
		paneContent += "<br><br><label for=\"myFile\">Import file:</label>";
		paneContent += "<input type=\"file\" id=\"licenseFile\" name=\"myLicensefile\" style=\"color:black;background-color:white\">";
		//menuContent += "<input type=\"file\" id=\"xifFile\" name=\"myfile\" style=\"color:black;background-color:white\" onchange=\"showDeviceTypesImportXifEvent(event)\">";
		paneContent += "<button  style=\"margin-left:30px\" onclick=\"showLicensesOfflineActivation1()\">Import</button><br><br></div>";
		document.getElementById("main").innerHTML = paneContent;
	}
	catch {}
}
function showLicensesOfflineActivation1() {
	try {
		var obj = {},iPtr;
		var element = document.getElementById("licenseFile");
		var filename, fileObj; 
		if(element !== null) {
			if(element.files.length === 0) {
				alert("No filename name specified, please enter filename first");
				return;
			}
			else {
				
				//fileObj = g_oFileImport.files[0];
				fileObj = element.files[0];
				filename = fileObj.name;
				if(filename.indexOf(".") === -1) {
					if(confirm("Continue with License File import for\r\n\r\n" + filename)) {
						//if(g_sCustomerId === "") {
							obj.mode = 1;
							obj.obj = fileObj;
							g_bLicenseRevokeGetLatest = true;
							requestGetData(obj,  "https://" + location.host + "/iap/users/current", showLicensesOfflineActivationGetCustomerIdResponse, showLicensesOfflineActivationGetCustomerIdFailCallback);
				
						//}
						//else 
						//	showLicensesOfflineActivationSendRequest(fileObj);
					}
				}
				else {
					alert("This file type is not supported file\r\n\r\n" + filename);
				}
			}
		}
		
	}
	catch {}


}
function showLicensesOfflineActivationGetCustomerIdResponse(mode, user, json) {
	try {
		showLicensesOfflineActivationSendRequest(mode.obj);
	}
	catch {}

}
function showLicensesOfflineActivationGetCustomerIdFailCallback(mode, user, json) {
	alert("Error: Can't get customer ID")

}
function showLicensesOfflineActivationSendRequest(fileObj) {
	try {
		requestPostLicenseImportFile(fileObj.name, fileObj, null, showDeviceTypesImportFileSendFailCallback);
		showLicense(1);
	}
	catch {}
}
function showLicensesDownloadRevokeLicensesDeleteUpdate(json) {
}
function showLicensesDownloadLicensesNtfUpdate(json) {
	if(g_bLicenseRevokeGetLatest) {
		g_bLicenseRevokeGetLatest = false; // for offline activation or online revoke
		showLicense(0);
	}
}