/*************************************************************************************************
 *  browserbtm.js
 * 
 * 	This file contains code that can be used to create a BTM file. Since only one file can be downloaded
 *  at a time you will need to go to each device
 *  To create a btm file:
 *    1. use existing deviceobj from deviceListAll 
 *    2. Get dp list for device
 *    3. If don't have device type list get device type list
 *    4. Get present dpList
 *    5. create file
 * 
 *  
 *  Comments:
 *  1. "Create BTM Files" create BTM for all but BACnet devices. To go to Devices view device menu
 *  "Create BTM" to create BTM files for BACnet.
 * 
 *  2. Ingnors any device type that doesn't have at least one device.
 * 
 *  3. This file doesn't take into account if localization is used in the datapoint properties. That is,
 *  if the IAP value is degrees celsius and you configured the locationizatio for this datapoint to
 *  degrees Fahrenheit, this file will still show degrees Celsius even though the BACnet tool will see
 *  degrees Fahreheit value. Therefore after you generate the btm file, change the units of any 
 *  degrees Celsius temperatures that has a datapoint localization of degrees Fahrenheit 
 * 
 * 
 *	Copyright (C) 2023 EnOcean GmbH.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	EnOcean Example Software License Agreement which is available at
 *	https://enoceanwiki.atlassian.net/wiki/spaces/LON/pages/2425260/Example+Software+License+Agreement.  
 * 
 ***************************************************************************************************/
var g_bBtmAddStringFields = false; // do not show any datapoint or field that is a string. String are not supported as of 3.50, requires future SmartServer support
var g_bBtmAddDpPathToDescription = true; 
var g_bBtmRemoveDpNviNvoPrefix = false;
var g_bBtmBacnetnameUseDatapointIntanceName = true;
var g_bBtmBacnetnameAddBlockname = false;
var g_iBtmNumBtmFilesCreated = 0;
var g_bBtmstateTextMapType = 2; // 0=uses enum value, 1=uses enum id, 2=uses enum id but removes text before first underscore "_"
var g_btmDeviceType = null;
var g_btmDeviceObj = null;
var g_btmDeviceDpList = [], g_btmDeviceDpTypeList = [], g_btmFilesAreadyCreated = [], g_btmMultipleInstanceFbs = [];
var g_btmDeviceId = "", g_btmDeviceName = "", g_btmDeviceIndex = -1;
var g_btmObjInstanceNumbers = 0;
var g_btmCurrentDeviceIndex = -1; // -1=single btm file, >=0 used for generate BTM for all non BACnet products
var g_sBtmCreateResults = "";
var g_bBtmIncrementBlockNumber = true;
var g_bBtmRemoveNodeObjectDps = true;
var g_sBtmListOfBtmFilesCreated = "";
var dpInstanceName = "";

function btmBuildBtmFile() {
    try {
        var i, j, z = -1, iPtr;
        var sResult = "";
        var header = "";
        var columns = "Block Name,Block Index,Datapoint Name,Address,IAP Type,IAP Field,BACnet Name,BACnet Units,Description,StateTextMap"
        if(g_iMainDisplayMode !== DISPLAYMODE_ALLDEVICES)
            return;
        if((deviceListAll[g_btmDeviceIndex].name !== g_btmDeviceName) || (g_btmDeviceType === null))
            return;
        g_btmObjInstanceNumbers = 0;
        // check for multiple instance FBs
        g_btmMultipleInstanceFbs = [];
        if(g_bBtmRemoveNodeObjectDps) {
            json = JSON.parse(JSON.stringify(g_btmDeviceDpList));
            g_btmDeviceDpList = [];
            for(j=0; j < json.length; j++)
            {
                z = -1;
                if(json[j].blockName === "NodeObject") {
                    switch(json[j].datapointName) {
                        case "nciDevMajVer":
                        case "nciDevMinVer":
                        case "nvoStatus":
                        case "nciNetConfig":
                        case "nviRequest":
                        case "nvoFileDirectory":
                            z = j;
                            break;
                    }
                }
                if(z === -1) {
                    g_btmDeviceDpList.push(JSON.parse(JSON.stringify(json[j])));
                }
            }
            
        }
        if(g_btmDeviceDpList.length > 0) {
            for(i=0; i < g_btmDeviceDpList.length; i ++)
            {
                if(g_btmDeviceDpList[i].blockIndex === 1) {
                    // only need to check for index 1.
                    z = -1;
                    for(j=0; j < g_btmMultipleInstanceFbs.length; j++)
                    {
                        if(g_btmMultipleInstanceFbs[j] === g_btmDeviceDpList[i].blockName) {
                            z = j;
                            break;
                        }
                    }
                    if(z === -1) {
                        g_btmMultipleInstanceFbs.push(g_btmDeviceDpList[i].blockName);
                    }
                }
            }
            for(i=0; i < g_btmDeviceDpList.length; i ++)
            {
                //generates one or more lines. One per field, if no field then only one line
                z = -1;
                for(j=0; j < g_btmDeviceDpTypeList.length; j++)
                {
                    if(g_btmDeviceDpTypeList[j].typeRef === g_btmDeviceDpList[i].type) {
                        z = j;
                        break;
                    }
                }
                if(z !== -1) {
                    dpInstanceName = "";
                    if(typeof g_btmDeviceDpList[i].name !== "undefined") {
                        if(g_btmDeviceDpList[i].name !== null) {
                            if(g_btmDeviceDpList[i].name !== "")
                                dpInstanceName = g_btmDeviceDpList[i].name;
                        }
                    }
                    sResult += btmBuildDatapointList(0, g_btmDeviceDpList[i].blockName, g_btmDeviceDpList[i].blockIndex, dpInstanceName, g_btmDeviceDpList[i].datapointName, "", g_btmDeviceDpList[i].cat,g_btmDeviceDpList[i].type, g_btmDeviceDpTypeList[z]);
                }
            }
            if(sResult !== "") {

                // added header on file and save
                if(typeof g_btmDeviceType.xifName === "undefined") {
                    // check if IOX
                    filename = g_btmDeviceType.name;
                }
                else {
                    filename = g_btmDeviceType.xifName;
                    iPtr = filename.indexOf(".");
                    if(iPtr !== -1) 
                        filename = filename.slice(0, iPtr)
                }
                header = "#filetype,bacnet_type_map\r\n#version,v1.0.0";
                header += "\r\n#product_name," + filename;
                header += "\r\n#program_id," + g_btmDeviceType.programId;
                header += "\r\n#manufacturer,Add manufacturer name"
                header += "\r\n#description,Add description";
                header += "\r\n";
                sResult = header + columns + sResult; 
                filename += ".btm.csv";
                //if(g_btmCurrentDeviceIndex === -1)
                //    alert("btmfile:\r\n\r\n" + sResult);
                btmSaveData(filename, sResult);
                g_iBtmNumBtmFilesCreated ++;
                g_sBtmListOfBtmFilesCreated += "<br>" + filename;
            }
        }
        if(g_btmCurrentDeviceIndex !== -1) {
            btmCreateGetNextDevice(1);
        }
        else 
            menuDivClose();
        
    }
    catch {}
}
function btmCreateBtmFile(mode, id, deviceName) {
    try {
        var i, j, index = -1; z = -1;
        var	url = "";
        g_btmDeviceType = null;
        g_btmDeviceObj = null;
        g_btmDeviceDpList = [];
        g_btmDeviceId = ""; g_btmDeviceName = "";
        g_btmDeviceIndex = -1;
        g_btmDeviceDpTypeList = [];
        g_btmFilesAreadyCreated = [];
        g_btmMultipleInstanceFbs = [];
        g_btmCurrentDeviceIndex = -1; // -1=single btm file, >=0 used for generate BTM for all non BACnet products
        if(g_iMainDisplayMode !== DISPLAYMODE_ALLDEVICES)
            return;
        
        g_btmDeviceName = deviceName;
        g_btmDeviceId = id;
        if(mode === 0)
            g_btmCurrentDeviceIndex = 0; // -1=single btm file, >=0 used for generate BTM for all non BACnet products
         // get datapoint types
         url = "https://" + location.host + "/iap/dp/types?datapointsPresence=true";
         requestGetData(0, url, btmCreateDpTypesResponse, btmCreateBtmFailCallback);
    }
    catch {}
}
function btmCreateBtmFile1(mode,n, id, deviceName) {
    g_sBtmListOfBtmFilesCreated = "";
    if(mode === 0) {
        element = document.getElementById("showDevicesCreateBtm");
        if(element !== null) {
            if(confirm("Do you really want to create btm files for all non-BACnet device types")) {
                element = document.getElementById("showDevicesCreateBtm");
                if(element !== null)
                    menuBtmCreate(0, element);
                    btmCreateBtmFile(0, null, null);
            }
        }
        else 
            btmCreateBtmFile(0, null, null);
    }
    else {
        menuBtmCreate(0, n);
        btmCreateBtmFile(1, id, deviceName);
    }
}
function btmCreateDeviceDpResponse(mode, url, json) {
    try {
        var i;
        var tempObj;
        var bContinue = true;
        if(g_iMainDisplayMode !== DISPLAYMODE_ALLDEVICES)
            return;
        if(json === null)
            return;
        if(json.length === 0)
            return;
        
        if(g_btmDeviceIndex === -1)
            return;
        if(deviceListAll[g_btmDeviceIndex].name !== g_btmDeviceName)
            return;

        for(i=0; i < json.length; i++)
        {
            json[i].sortStr = json[i].blockName + " /"  + json[i].blockIndex + " /"  + json[i].datapointName+ " "
        }
        //sort datapoint
        while(bContinue)
        {
            bContinue = false;
            for(i=0; i < (json.length - 1); i++)
            {
                if(json[i].sortStr > json[i + 1].sortStr){
                    tempObj = {};
                    tempObj = JSON.parse(JSON.stringify(json[i]));
                    json[i] = JSON.parse(JSON.stringify(json[i + 1]));
                    json[i + 1] = JSON.parse(JSON.stringify(tempObj));
                    bContinue = true;
                }
            }
        }
        g_btmDeviceDpList = JSON.parse(JSON.stringify(json))
        btmBuildBtmFile();
    }
    catch {}
}
function btmCreateDpTypesResponse(mode, url, json) {
    try {
        var i;
        if(g_iMainDisplayMode !== DISPLAYMODE_ALLDEVICES)
            return;
        if(json === null)
            return;
        if(json.length === 0)
            return;
        g_btmDeviceDpTypeList = JSON.parse(JSON.stringify(json))
        url = "https://" + location.host + "/iap/devTypes/*?short=false&sortBy=name&sortOrder=asc";
        requestGetData(0, url, btmDeviceTypeListResponse, btmCreateBtmFailCallback);
        
    }
    catch {}
}
function btmDeviceTypeListResponse(mode, url, json){
    try {
        var i,j;
        if(g_iMainDisplayMode !== DISPLAYMODE_ALLDEVICES)
                return;
        deviceTypeList = JSON.parse(JSON.stringify(json));
        if((g_btmDeviceName !== null) && (g_btmDeviceId !== null)) {
            for(i=0; i < deviceListAll.length; i ++)
            {
                if(deviceListAll[i].id === g_btmDeviceId) {
                    if(deviceListAll[i].name = g_btmDeviceName) {
                        g_btmDeviceIndex = i;
                        g_btmDeviceObj = {};
                        g_btmDeviceObj = JSON.parse(JSON.stringify(deviceListAll[i]))
                        for(j=0; j < deviceTypeList.length; j++)
                        {
                            if(deviceTypeList[j].name === deviceListAll[i].deviceTypeName) {
                                g_btmDeviceType = {};
                                g_btmDeviceType = JSON.parse(JSON.stringify(deviceTypeList[j]))

                                // get datapoint list
                                url = "https://" + location.host + "/iap/devs/" + g_btmDeviceId + "/if/*/*/*/*";
                                requestGetData(0, url, btmCreateDeviceDpResponse, btmCreateBtmFailCallback);
                                break;
                            }
                        }
                    }
                    break;
                }
            }
        }
        else 
            btmCreateGetNextDevice(0);
    }
    catch{}
}
function btmCreateGetNextDevice(mode) {
    // get by devicetypes
    try {
        var i,j,k,z, url, bFinished = true;
        if(g_iMainDisplayMode !== DISPLAYMODE_ALLDEVICES)
            return;
        if(g_btmCurrentDeviceIndex === -1)
            return;
        if(!((mode === 0) || (mode === 1)))
            return;
        if(mode=== 1)
            g_btmCurrentDeviceIndex ++; 
        if(g_btmCurrentDeviceIndex === deviceTypeList.length) {
            //done
            //alert("All BTM files created");
            menuDivClose();
        }
        else {
            for(j=g_btmCurrentDeviceIndex; j < deviceTypeList.length; j++)
            {
                if(deviceTypeList[j].protocol === "bacnet") {
                    // don't automatically create btm files for BACnet devices
                }
                else if(deviceTypeList[j].numberOfDevices === 0) {

                }
                else if(typeof deviceTypeList[j].xifName !== "undefined") {
                    // check if btm file already created
                    z = -1;
                    for(i=0; i < g_btmFilesAreadyCreated.length; i ++)
                    {
                        
                        if(g_btmFilesAreadyCreated[i] === deviceTypeList[j].xifName) {
                            z = i;
                            break;
                        }
                    }
                    if( z === -1) {
                    // don't have the btm file yet
                        for(i=0; i < deviceListAll.length; i ++)
                        {
                            if(deviceListAll[i].category !== "SC") {
                                // check if btm already specified
                                // most likely iox
                                if(deviceListAll[i].deviceTypeName === deviceTypeList[j].name) {
                                    if(typeof deviceTypeList[j].xifName !== "undefined")
                                        z = i;
                                    break;
                                }
                            }
                        }
                        if(z !== -1) {
                            // found device now get the device datapoints
                            g_btmFilesAreadyCreated.push(deviceTypeList[j].xifName);
                            g_btmDeviceName = deviceListAll[z].name;
                            g_btmDeviceId = deviceListAll[z].id;
                            g_btmDeviceIndex = z;
                            g_btmDeviceObj = {};
                            g_btmDeviceObj = JSON.parse(JSON.stringify(deviceListAll[z]))
                            g_btmCurrentDeviceIndex = j;
                            for(k=0; k < deviceTypeList.length; k++)
                            {
                                if(deviceTypeList[k].name === deviceListAll[z].deviceTypeName) {
                                    g_btmDeviceType = {};
                                    g_btmDeviceType = JSON.parse(JSON.stringify(deviceTypeList[k]))

                                    // get datapoint list
                                    url = "https://" + location.host + "/iap/devs/" + g_btmDeviceId + "/if/*/*/*/*";
                                    requestGetData(0, url, btmCreateDeviceDpResponse, btmCreateBtmFailCallback);
                                    bFinished = false;
                                    break;
                                }
                            }
                            break;
                        }
                    }
                }
            }
            if(bFinished)
                menuDivClose();
        }
    }
    catch{}
}
function btmCreateGetNextDevice1(mode) {
    // get by devicelist
    try {
        var i,j,z, url;
        if(g_iMainDisplayMode !== DISPLAYMODE_ALLDEVICES)
            return;
        if(g_btmCurrentDeviceIndex === -1)
            return;
        if(!((mode === 0) || (mode === 1)))
            return;
        if(mode=== 1)
            g_btmCurrentDeviceIndex ++; 
        if(g_btmCurrentDeviceIndex === (deviceList.length)) {
            //done
            alert("All BTM files created");
        }
        else {

            for(i=g_btmCurrentDeviceIndex; i < deviceListAll.length; i ++)
            {
                if(deviceListAll[i].category !== "SC") {
                    // check if btm already specified
                    z = -1;
                    for(j=0; j < g_btmFilesAreadyCreated.length; j++)
                    {
                        if(typeof deviceListAll[i].xifName === "undefined") {
                            // most likely iox
                            if(deviceListAll[i].name === g_btmFilesAreadyCreated[j]) {
                                z = 1;
                                break;
                            }
                        }
                        else if(deviceListAll[i].xifName === g_btmFilesAreadyCreated[j]) {
                            z = 1;
                            break;
                        }
                    }
                    if(z === -1) {
                        if(typeof deviceListAll[i].xifName === "undefined")
                            g_btmFilesAreadyCreated.push(deviceListAll[i].name);
                        else 
                            g_btmFilesAreadyCreated.push(deviceListAll[i].xifName);
                        g_btmDeviceName = deviceListAll[i].name;
                        g_btmDeviceId = deviceListAll[i].id;
                        g_btmDeviceIndex = i;
                        g_btmDeviceObj = {};
                        g_btmDeviceObj = JSON.parse(JSON.stringify(deviceListAll[i]))
                        for(j=0; j < deviceTypeList.length; j++)
                        {
                            if(deviceTypeList[j].name === deviceListAll[i].deviceTypeName) {
                                g_btmDeviceType = {};
                                g_btmDeviceType = JSON.parse(JSON.stringify(deviceTypeList[j]))

                                // get datapoint list
                                url = "https://" + location.host + "/iap/devs/" + g_btmDeviceId + "/if/*/*/*/*";
                                requestGetData(0, url, btmCreateDeviceDpResponse, btmCreateBtmFailCallback);
                                break;
                            }
                        }
                        break;
                    }
                }
            }
        }
    }
    catch{}
}
function btmCreateBtmFailCallback(mode, url, json) {
    try {
        if(g_iMainDisplayMode !== DISPLAYMODE_ALLDEVICES)
            return;
    }
    catch {}
}
function btmGetDeviceTypesResponse(mode, url, json) {
    try {
        var url = "https://" + location.host + "/iap/dp/types?datapointsPresence=true";
        if(g_iMainDisplayMode !== DISPLAYMODE_ALLDEVICES)
            return;
        if(json === null)
            return;
        if(json.length === 1) {
            g_btmDeviceType = {};
            g_btmDeviceType = JSON.parse(JSON.stringify(deviceTypeList[0]))
            requestGetData(0, url, btmCreateDpTypesResponse, btmCreateBtmFailCallback);
        }
    }
    catch {}

}
function btmBuildDatapointList(iLevel, block, blockIndex, dpInstanceName, dpName, fieldPath, direction, dpType, dpTypeObj) {
    //known issues:
    // 1. structure datapoints with fields with same name may have same BACnet Name
    // 2. FBs with multiple instances, first instance has no index, others are "_index++" (e.g., FB[0] shows up as nviLamp, FB[1] shows up as nviLamp_2)

    var i, j, z, iTemp;
	var result = "", i,iPtr, sTemp;
    var bUnitsEqNoUnits = false;
    var tabStr = "";
    var obj, obj1, attrName, attrValue, key, iTemp;
    var dpTypeParams;
    var units = "";
    var description = "";
    var stateTextMap = "";
    var bacnetName = "";
    var bacnetType = "";
    var directionType ="";
    var type = "";
    var field, enumList = null;
    var bContinue, bContinue1;
    var enumNewListPos = [], enumNewListNeg = [];

    //var header = "Block Name,Block Index,Datapoint Name,Address,IAP Type,IAP Field,BACnet Name,BACnet Units,Description,StateTextMap"
    try {
        if(g_iMainDisplayMode !== DISPLAYMODE_ALLDEVICES)
            return "";
        iLevel ++;
        type = "";
        if(iLevel === 1) {
            // consider adding code here to check for FBs with multiple instances
            
            
            type = dpTypeObj.valueType.toLowerCase();
            if(type === "OBJECT") {
                if(dpTypeObj.typeRef === "SNVT_str_asc")
                    type = "snvt_str_asc";
            }
        }
        else 
            type =   dpTypeObj.type.toLowerCase();
        
        if((type === "object") || (type === "aggregate")) {
            if(typeof dpTypeObj.typeJson !== "undefined") {
                if(typeof dpTypeObj.typeJson.members !== "undefined") {
                    for(i=0; i < dpTypeObj.typeJson.members.length; i++)
                    {
                        field = fieldPath;
                        if(iLevel > 1)
                            field += ".";
                        sTemp = dpTypeObj.typeJson.members[i].id; //dpTypeObj.typeJson.members[i].name;
                        // some fields names have periods so strip away the ending "."
                        iPtr = sTemp.lastIndexOf(".");
                        if(iPtr === (sTemp.length - 1))
                            sTemp = sTemp.slice(0, iPtr);
                        field +=  sTemp;
                        result += btmBuildDatapointList(iLevel, block, blockIndex, dpInstanceName, dpName, field, direction, dpType, dpTypeObj.typeJson.members[i]);
                    }
                }
            }
            else if(typeof dpTypeObj.members !== "undefined") {
                if(typeof dpTypeObj.members !== "undefined") {
                    // I am not sure all of these are working
                    for(i=0; i < dpTypeObj.members.length; i++)
                    {
                        field = fieldPath;
                        if(iLevel > 1)
                            field += ".";
                        sTemp = dpTypeObj.members[i].id;
                        // some fields names have periods so strip away the ending "."
                        iPtr = sTemp.lastIndexOf(".");
                        if(iPtr === (sTemp.length - 1))
                            sTemp = sTemp.slice(0, iPtr);
                        field +=  sTemp;
                        result += btmBuildDatapointList(iLevel, block, blockIndex, dpInstanceName, dpName, field, direction, dpType, dpTypeObj.members[i]);
                    }
                }
            }
        }
        else {
            bUnitsEqNoUnits = false;
            directionType = "O"; // lonworks input
            bContinue = true;
            if(type === "snvt_str_asc") {
                bacnetType = "S";
            }
            else if((type === "float") || (type === "scalar")){
                bacnetType = "A";
                /*
                // check min max to see if L - L is only supported by 3.5
                if((dpTypeObj.max - dpTypeObj.min) > 64000)
                    bacnetType = "L";
                    */
            }
            else if(type === "integer") {
                
                bacnetType = "A";
                /*
                if(typeof dpTypeObj.typeJson !== "undefined") {
                    if((dpTypeObj.typeJson.max - dpTypeObj.typeJson.min) > 64000)
                        bacnetType = "L";
                }
                */
                // check min max to see if L - L is only supported by 3.5
                
            }
            else if(type === "boolean") {
                bacnetType = "B";
            }
            else if(type === "bitfield") {
                bacnetType = "A";
                
                if((typeof dpTypeObj.base !== "undefined") && (typeof dpTypeObj.min !== "undefined") && (typeof dpTypeObj.max !== "undefined")) {
                    if((dpTypeObj.base.startsWith("uint") || dpTypeObj.base.startsWith("int")) && (typeof dpTypeObj.min === 0) && (dpTypeObj.max === 1)) {
                        bacnetType = "B";
                    }
                }
                if(bacnetType === "A") {
                    if(typeof dpTypeObj.unit !== "undefined") {
                        if(dpTypeObj.unit.toLowerCase() === "boolean")
                            bacnetType = "B";
                    }
                }
            }
            else if(type === "enum") {
                bUnitsEqNoUnits = true;
                bacnetType = "MS";

                
                enumList = null;
                if(typeof dpTypeObj.typeJson !== "undefined") {
                    if(typeof dpTypeObj.typeJson.enum !== "undefined") {
                        enumList = [];
                        enumList = JSON.parse(JSON.stringify(dpTypeObj.typeJson.enum));
                    }
                }
                else {
                    if(typeof dpTypeObj.enum !== "undefined") {
                        enumList = [];
                        enumList = JSON.parse(JSON.stringify(dpTypeObj.enum));
                    }
                }
                if(enumList !== null) {
                    stateTextMap = '"{';
                    // need to reorder enums so 1 and greater are added first then 0 and then -1 ... -10 and so on
                    // original: -4, -1, 0, 1, 5;   new: 1,5,0,-1,-4
                    enumNewListPos = [];
                    enumNewListNeg = [];
                    for(i=0; i < enumList.length; i++)
                    {
                        if(enumList[i].value > 0)
                            enumNewListPos.push(JSON.parse(JSON.stringify(enumList[i])));
                        else 
                            enumNewListNeg.push(JSON.parse(JSON.stringify(enumList[i])));
                    }
                    enumList = [];
                    for(i=0; i < enumNewListPos.length; i++)
                    {
                        enumList.push(JSON.parse(JSON.stringify(enumNewListPos[i])));
                    }
                    for(i=(enumNewListNeg.length - 1); i >= 0; i--)
                    {
                        enumList.push(JSON.parse(JSON.stringify(enumNewListNeg[i])));
                    }
                    for(i=0; i < enumList.length; i++)
                    {
                        if(i > 0)
                            stateTextMap += ",";

                        stateTextMap += '""' + enumList[i].id + '"":';
                        // 0=uses enum value, 1=uses enum id, 2=uses enum id but removes text before first underscore "_"
                        if(g_bBtmstateTextMapType === 0)
                            stateTextMap += enumList[i].value;
                        else if(g_bBtmstateTextMapType === 1)
                            stateTextMap += enumList[i].id;
                        else if(g_bBtmstateTextMapType === 2) {
                            iPtr = enumList[i].id.indexOf("_");
                            if(iPtr !== -1) {
                                sTemp = enumList[i].id.slice((iPtr + 1), enumList[i].id.length);
                                if(sTemp === "NUL")
                                    sTemp = "NULL"
                                sTemp = sTemp.charAt(0).toUpperCase() +   sTemp.slice(1, sTemp.length).toLowerCase();
                                stateTextMap += '""' + sTemp + '""';

                            }
                            else 
                                stateTextMap += enumList.enum[i].id;
                        }
                    }
                    stateTextMap += '}"';
                }
                
            }
            else if(type === "string") {
                bacnetType = "S";
            }
            else {
                bacnetType = "?";
            }
            if(bContinue) {
                if(direction === "out")
                    directionType = "I";
                units = "";
                if(bUnitsEqNoUnits) {
                    units = "no-units"
                }
                else if(typeof dpTypeObj.unit !== "undefined") {
                    
                    units = "";
                    sTemp = "";
                    if(iLevel === 1)
                        sTemp = dpTypeObj.unit;
                    else {
                        if(typeof dpTypeObj.unit !== "undefined")
                            sTemp = dpTypeObj.unit;
                    }
                    if(sTemp === "units")
                        units = "no-units";
                    else {
                        if(sTemp.indexOf(",") !== -1)
                            sTemp = "";
                        if(sTemp !== "") {
                            // get rid of trailing space
                            iPtr = sTemp.lastIndexOf(".");
                            if(iPtr === (sTemp.length - 1))
                                sTemp = sTemp.slice(0, iPtr);
                            sTemp = sTemp.toLowerCase();
                            for(i=0; i < btmUnits.length; i++)
                            {
                                if(btmUnits[i].length === 2) {
                                    if(sTemp === btmUnits[i][0]) {
                                        units = btmUnits[i][1];
                                        break;
                                    }
                                }
                            }
                            if(units === "") {
                                // check if SNVT type
                                if(iLevel === 1) {
                                    for(i=0; i < btmUnitsSnvtType.length; i++)
                                    {
                                        if(btmUnitsSnvtType[i].length === 2) {
                                            if(dpTypeObj.typeRef === btmUnitsSnvtType[i][0]) {
                                                units = btmUnitsSnvtType[i][1];
                                                break;
                                            }
                                        }
                                    }
                                }
                            }
                            if(units === "") {
                                for(i=0; i < btmUnitsNoUnits.length; i++)
                                {
                                    
                                    if(sTemp === btmUnitsNoUnits[i]) {
                                        units = "no-units";
                                        break;
                                    }
                                }
                            }
                            if(units === "") {
                                // check if units starts with this text
                                for(i=0; i < btmUnitsStartsWithStringNoUnits.length; i++)
                                {
                                    if(sTemp.startsWith(btmUnitsStartsWithStringNoUnits[i]) !== -1) {
                                        units = "no-units";
                                        break;
                                    }
                                }
                            }
                            if(units === "") {
                                // check if units contains this text
                                for(i=0; i < btmUnitsContainsStringNoUnits.length; i++)
                                {
                                    if(sTemp.indexOf(btmUnitsContainsStringNoUnits[i]) !== -1) {
                                        units = "no-units";
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    // Remove all this code - for test purposes only
                    if(units === "") {
                        units = "*** " + dpTypeObj.unit; // Remove - used for debug only 
                    }
                }
                else {
                    units = "no-units";
                }
                
                g_btmObjInstanceNumbers++;
                result += "\r\n" + block + "," + blockIndex + "," + dpName;
                //address determine by input/output and AI, and based on datapoint type
                if(g_bBtmBacnetnameUseDatapointIntanceName && (dpInstanceName !== ""))
                    bacnetName = dpInstanceName;
                else
                    bacnetName = dpName;
                if(g_bBtmRemoveDpNviNvoPrefix) {
                    if(bacnetName.toLowerCase().startsWith("nvi") || bacnetName.toLowerCase().startsWith("nvo") || bacnetName.toLowerCase().startsWith("nci")) {
                        if(bacnetName.length > 3)
                            bacnetName = bacnetName.slice(3,bacnetName.length);
                    }
                }
                if(g_bBtmBacnetnameAddBlockname) {
                    bacnetName = block + "/" + blockIndex + " " + bacnetName;
                }
                else {
                    // check if multiple instances of this FB
                    
                    z = -1;
                    for(i=0; i < g_btmMultipleInstanceFbs.length; i++)
                    {
                        if(g_btmMultipleInstanceFbs[i] === block) {
                            z = i;
                            break;
                        }
                    }
                
                    if(z !== -1) {
                        // check if ending with _<number> if so don't add _<number>
                        bContinue1 = true;
                        iPtr = bacnetName.lastIndexOf("_");
                        if(iPtr > 0) {
                            if((iPtr + 1) < bacnetName.length)
                                sTemp = bacnetName.slice(iPtr + 1, bacnetName.length);
                                if(!isNaN(sTemp)) {
                                    bContinue1 = false; //assumes that _<number> may already be there like 6kEvbMultiSensor lamp
                                }
                        }
                        if(bContinue1) {
                            iTemp = blockIndex;
                            if(g_bBtmIncrementBlockNumber) {
                                if(typeof iTemp === "string")
                                    iTemp = Number(iTemp);
                                iTemp ++
                            }
                            bacnetName += "_" + iTemp;
                        }
                    }
                }
                if(iLevel > 1) {
                    //must be field so add lowest field, ex. nvoSwitch value
                    sTemp = dpTypeObj.id; //name;
                    iPtr = sTemp.lastIndexOf(".");
                    if(iPtr === (sTemp.length - 1))
                        sTemp = sTemp.slice(0, iPtr);
                    bacnetName += " " + sTemp;
                }
                else {
                    
                }
                if(g_bBtmAddDpPathToDescription) {
                    description = "";
                    
                    description += block + "/" + blockIndex
                
                    if(description !== "")
                        description += "/";
                    if(dpInstanceName === "")
                        description += dpName;
                    else
                        description += dpInstanceName; //dpName;
                    if(fieldPath !== "")
                        description += "." + fieldPath; //.name; //dpName;
                        
                   
                    description = description.replace(/\,/g, ' ');
                    // change all descripts so first character is always capatilized
                    
                    // get rid of trailing space
                    iPtr = description.lastIndexOf(".");
                    if(iPtr === (description.length - 1))
                        description = description.slice(0, iPtr);
                }
                result += "," + bacnetType +  directionType + ":" + g_btmObjInstanceNumbers + "," + dpType + "," + fieldPath + "," + bacnetName + "," + units + "," + description + "," + stateTextMap;
            }
        }
        return result;
    }
	catch(err) { 
            result = "";
    }
	return result;

}
function btmSaveData(filename, data) {
	try {
		var d = new Date();
		var currentDate = d.toLocaleDateString().replace(/\./,"_").replace(/\//,"_");
		//var currentDate = d.getFullYear().toString() + "-" + (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0);//dateItems[2] + "-" + dateItems[0] + "-" +dateItems[1];
		var currentTimestamp = currentDate + "_" + d.toTimeString().slice(0,8);
        if(g_iMainDisplayMode !== DISPLAYMODE_ALLDEVICES)
            return;


		if(data !== "") {
			var copyElement = document.createElement("a");
			copyElement.setAttribute('href', 'data:text/plain;charset=utf-8,' + encodeURIComponent(data));
			copyElement.setAttribute('download', filename);
			copyElement.style.display = 'none';
			document.body.appendChild(copyElement);
			copyElement.click();
			document.body.removeChild(copyElement);
		}
        
	}
	catch (err) 
	{
		alert("Error: Can't save BTM file\r\n\r\n" + err.toString());
	}
}