/*************************************************************************************************
 *  browserapi.js
 * 
 *  Contains code for the API Tester.
 * 
 *  
 * 
 *	Copyright (C) 2023 EnOcean GmbH.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	EnOcean Example Software License Agreement which is available at
 *	https://enoceanwiki.atlassian.net/wiki/spaces/LON/pages/2425260/Example+Software+License+Agreement.  
 * 
 ***************************************************************************************************/
let g_bApiEncodeRequestStr = true;

function apiClearBetweenRequest() {
	document.getElementById("clearBetweenRequestsCheckbox").checked;
	
}
function apiAdvancedCheckBox() { 
	g_apiPaneData.apiClearBetweenRequestChecked = document.getElementById("advancedCheckbox").checked;
	if(document.getElementById("advancedCheckbox").checked)
		document.getElementById("apiAdvancedDiv").style.display = "block";
	else 
		document.getElementById("apiAdvancedDiv").style.display = "none";
}
function apiAdvancedDeleteCheckBox() {
	if(document.getElementById("advancedDeleteCheckbox").checked)
		document.getElementById("advancedDeleteButton").disabled = false;
	else 
		document.getElementById("advancedDeleteButton").disabled = true;
}
function apiEnclodeRequestCheckBox() {
	g_bApiEncodeRequestStr = document.getElementById("apiEnclodeRequestCheckbox").checked;
}
function apiAdvancedPrettyJson() {
	var element = document.getElementById("apiAdvancedPrettyJson");
	var data = "", prettyJsonStr = "";
	try {
		if(element !== null) {
			try {
				prettyJsonStr = apiPrettyJson(data);
			}
			catch { }
			document.getElementById("apiData").value += "\r\n" + prettyJsonStr;
		}
	}
	catch {}
}
function apiGet() {
	var url = document.getElementById("getUrl").value;
	var d = new Date();
	var d1 = d.toLocaleDateString() + " " + d.toLocaleTimeString();
	if(url !== "") {  
		if(g_bApiEncodeRequestStr)
			url = encodePathString(url);
		url = url = "https://" + location.host + url;
		if(g_apiPaneData.apiClearBetweenRequestChecked)
			document.getElementById("apiData").value = "\r\n\r\n" + d1 + ": GET url = " + url + "\r\n";
		else 
			document.getElementById("apiData").value += "\r\n\r\n" + d1 + ": GET url = " + url + "\r\n";
		document.getElementById("apiLog").value = "\r\n\r\n" + d1 + ": GET url =" + url + "\r\n\r\n" + document.getElementById("apiLog").value;
		
		requestGetData(0, url, apiGetResponse, apiGetResponseFailCallback);
	}
}

function apiGetResponse(mode, requestUrlString, json) {
	var jsonStr = "No Data available";
	var d = new Date();
	var d1 = d.toLocaleDateString() + " " + d.toLocaleTimeString();
	if (json.length === 0)  {
		document.getElementById("apiData").value += "\r\nNo Data";
		return;
	}
	else 
		jsonStr = JSON.stringify(json);
	if(g_apiPaneData.apiPrettyJsonChecked) {
		try {
			prettyJsonStr = apiPrettyJson(json);
		}
		catch {prettyJsonStr = JSON.stringify(json); }
	}
	else 
		prettyJsonStr = jsonStr;
	document.getElementById("apiData").value += "\r\n" + d1 + ": GET Response:\r\n" + prettyJsonStr + "\r\n\r\n";
    if(g_apiPaneData.apiTraceLogCheckboxChecked)
		document.getElementById("apiLog").value = "\r\n\r\n" + d1 + ": GET Response:\r\n" + jsonStr + "\r\n\r\n" + document.getElementById("apiLog").value;
}
function apiGetResponseFailCallback(mode, requestUrlString, json) {
	var jsonStr = "No Data available";
	var d = new Date();
	var d1 = d.toLocaleDateString() + " " + d.toLocaleTimeString();
	prettyJsonStr = "HTTP " + json + " error";
	document.getElementById("apiData").value += "\r\n" + d1 + ": GET Response:\r\n\r\n" + prettyJsonStr + "\r\n\r\n";
    if(g_apiPaneData.apiTraceLogCheckboxChecked)
		document.getElementById("apiLog").value = "\r\n\r\n" + d1 + ": GET Response:\r\n\r\n" + jsonStr + "\r\n\r\n" + document.getElementById("apiLog").value;
}
function apiDataClear() { 
	document.getElementById("apiData").value = "";
}
function apiLogClear() {
	document.getElementById("apiLog").value = "";
}

function apiDeleteRequest() {
	try {
		var url = document.getElementById("putUrl").value;
		var payload = document.getElementById("putPayload").value;
		var d = new Date();
		var d1 = d.toLocaleDateString() + " " + d.toLocaleTimeString();
		url = url.trim();
		if(g_bApiEncodeRequestStr)
			url = encodePathString(url);
		url = "https://" + location.host + url;
		document.getElementById("apiLog").value = "\r\n\r\n" + d1 + ": DELETE:" + url + "\r\nPayload: " + payload + "\r\n\r\n" + document.getElementById("apiLog").value;
		document.getElementById("apiData").value = "\r\n\r\n" + d1 + ": DELETE:" + url + "\r\nPayload: " + payload + "\r\n";

		var Rsp = requestDeleteFunction(0, url, payload,  apiDeleteResponse, apiDeleteResponseFail); 
	}
	catch {}
}
function apiDeleteResponse(mode, requestUrlString, json) {
	try {
		var d = new Date();
		var d1 = d.toLocaleDateString() + " " + d.toLocaleTimeString();
		document.getElementById("apiData").value += "\r\n" + d1 + ": DELETE successful\r\n\r\n";
		document.getElementById("apiLog").value = "\r\n\r\n" + d1 + ": DELETE successful\r\n\r\n" + document.getElementById("apiLog").value;
	} catch {}
}
function apiDeleteResponseFail(mode, requestUrlString, json) {
	try {
		var d = new Date();
		var d1 = d.toLocaleDateString() + " " + d.toLocaleTimeString();
		document.getElementById("apiData").value += "\r\n" + d1 + ": DELETE failed\r\n\r\n";
		document.getElementById("apiLog").value = "\r\n\r\n" + d1 + ": DELETE failed\r\n\r\n" + document.getElementById("apiLog").value;
	} catch {}
}
function apiEncodeString() {
	try {  // substrings to encode
		var str = document.getElementById("apiStringToEncode").value;
		str = encodeUriString(str);
		document.getElementById("apiEncodedString").value = str;
	}
	catch (err) {}
}
function apiPostRequest() {
	try {
		var url = document.getElementById("putUrl").value;
		var payload = document.getElementById("putPayload").value;
		var d = new Date();
		var d1 = d.toLocaleDateString() + " " + d.toLocaleTimeString();
		url = url.trim();
		if(g_bApiEncodeRequestStr)
			url = encodePathString(url);
		url = "https://" + location.host + url;
		document.getElementById("apiLog").value = "\r\n\r\n" + d1 + ": POST:" + url + "\r\nPayload: " + payload + "\r\n\r\n" + document.getElementById("apiLog").value;
		document.getElementById("apiData").value = "\r\n\r\n" + d1 + ": POST:" + url + "\r\nPayload: " + payload + "\r\n";

		var Rsp = requestPostFunction(0, url, payload,  apiPostResponse, apiPostResponseFail); 
	}
	catch {}
}
function apiPostResponse(mode, requestUrlString, json) {
	try {
		var d = new Date();
		var d1 = d.toLocaleDateString() + " " + d.toLocaleTimeString();
		document.getElementById("apiData").value += "\r\n" + d1 + ": POST successful\r\n\r\n";
		document.getElementById("apiLog").value = "\r\n\r\n" + d1 + ": POST successful\r\n\r\n" + document.getElementById("apiLog").value;
	} catch {}
}
function apiPostResponseFail(mode, requestUrlString, json) {
	try {
		var d = new Date();
		var d1 = d.toLocaleDateString() + " " + d.toLocaleTimeString();
		document.getElementById("apiData").value += "\r\n" + d1 + ": POST failed\r\n\r\n";
		document.getElementById("apiLog").value = "\r\n\r\n" + d1 + ": POST failed\r\n\r\n" + document.getElementById("apiLog").value;
	} catch {}
}
function apiPrettyJsonCheckbox() {  
	g_apiPaneData.apiPrettyJsonChecked = document.getElementById("prettyJsonCheckbox").checked;
}

function apiPutRequest() {
	try {
		var url = document.getElementById("putUrl").value;
		var payload = document.getElementById("putPayload").value;
		var d = new Date();
		var d1 = d.toLocaleDateString() + " " + d.toLocaleTimeString();
		url = url.trim();
		if(g_bApiEncodeRequestStr)
			url = encodePathString(url);
		url = "https://" + location.host + url; 
		document.getElementById("apiLog").value = "\r\n\r\n" + d1 + ": PUT:" + url + "\r\nPayload: " + payload + "\r\n\r\n" + document.getElementById("apiLog").value;
		document.getElementById("apiData").value = "\r\n\r\n" + d1 + ": PUT:" + url + "\r\nPayload: " + payload + "\r\n";

		var Rsp = requestPutData(0, url, payload,  apiPutResponse, apiPutResponseFail); 
	}
	catch {}
}
function apiPutResponse(mode, requestUrlString, json) {
	try {
		var d = new Date();
		var d1 = d.toLocaleDateString() + " " + d.toLocaleTimeString();
		document.getElementById("apiData").value += "\r\n" + d1 + ": PUT successful\r\n\r\n";
		document.getElementById("apiLog").value = "\r\n\r\n" + d1 + ": PUT successful\r\n\r\n" + document.getElementById("apiLog").value;
	} catch {}
}
function apiPutResponseFail(mode, requestUrlString, json) {
	try {
		var d = new Date();
		var d1 = d.toLocaleDateString() + " " + d.toLocaleTimeString();
		document.getElementById("apiData").value += "\r\n" + d1 + ": PUT failed\r\n\r\n";
		document.getElementById("apiLog").value = "\r\n\r\n" + d1 + ": PUT failed\r\n\r\n" + document.getElementById("apiLog").value;
	} catch {}
}

function apiPutUrlChanged() {
	try {
		var url1 = "", payload1 = "";
		var cmd = "";
		var iPtr , iPtr1,iPtr2;
		var url = document.getElementById("putUrl").value;
		url1 = url.toLowerCase();
		cmd = "post:";
		iPtr = url1.indexOf(cmd);
		if(iPtr !== 0) {
			cmd = "put:";
			iPtr = url1.indexOf(cmd);
			if(iPtr !== 0) {
				cmd = "delete:";
				iPtr = url1.indexOf(cmd);
				if(iPtr !== 0) {
					return;
				}
			}
		}
		if(cmd !== "") {
			iPtr1 = url1.indexOf(" ");
			iPtr2 = url1.indexOf("\t");
			if(iPtr1 > 0) {
				iPtr = cmd.length;
				url1 = url.substr(iPtr, iPtr1 - iPtr);
				payload1 = url.substr(iPtr1 + 1);
				document.getElementById("putUrl").value = url1;
				document.getElementById("putPayload").value = payload1;
			}
			else if(iPtr2 > 0) {
				iPtr = cmd.length;
				url1 = url.substr(iPtr, iPtr2 - iPtr);
				payload1 = url.substr(iPtr2 + 2);
				document.getElementById("putUrl").value = url1;
				document.getElementById("putPayload").value = payload1;
			}
			else if(cmd === "delete:") 			{
				iPtr = cmd.length;
				url1 = url.substr(iPtr);
				document.getElementById("putUrl").value = url1;
				document.getElementById("putPayload").value = payload1;
			}
		}
	} catch {}
}
function apiPrettyJson(json) {
	var results = null;
	try {
		results =  decodeJson(json, -1);
	} catch {results = json;}
	return results;
}
function apiTimeConversion() {
	try {
		var sTemp = "";
		var element = document.getElementById("apiEpocTime");
		var element1 = document.getElementById("apiEpocTimeLog");
		var value;
		if((element !== null) && (element1 !== null)) {
			if(element1.value !== "")
				element1.value = "----\r\n" + element1.value;
			value = element.value.trim();
			if(value === "") {
				element1.value = "Epoc Time: " + element.value + "\r\nNo value specified - please try again\r\n" + element1.value;
			}
			else {
				if(!isNaN(value)) {
					value = Number(value);
					d = new Date(value);
					sTemp = "Epoc Time: " + element.value + "\r\n";
					sTemp += "UTC Time: "  + d.getUTCFullYear() + "-" + (d.getUTCMonth() + 1).toString().padStart(2,0)+ "-" + (d.getUTCDate()).toString().padStart(2,0);
					sTemp += "T" + (d.getUTCHours()).toString().padStart(2,0) + ":" + + (d.getUTCMinutes()).toString().padStart(2,0) + "Z";
					sTemp += "\r\n";
					sTemp += "PC local Time " + d.toLocaleString() + "\r\n";
					
					element1.value = sTemp + element1.value;
				}
				else 
					element1.value = "Epoc Time: " + element.value + "\r\nError: " + " is not a number\r\n" + element1.value;
					
			}
		}
	}
	catch {}
}
function showApiTester() {
	savePrevousHtmlContent();
	g_bPollingEnabled = false;
	initializeDisplay();
	var d = new Date();
	var sTemp;
	g_iMainDisplayMode = DISPLAYMODE_APITESTER;
	var tempString;
	var paneTitle = "<label id=\"displayLabel\">API Tester</label> (<a href=\"https://enoceanwiki.atlassian.net/wiki/spaces/IEC/overview\" target=\"_blank\" style=\"color:white\">REST request Queries</a>)";
	
	try {
		var apiGetUrl = "", apiPutUrl = "", apiPutPayload = "", apiData = "", apiLog = "";
		var apiAdvancedCheckboxChecked = false;
		var apiPrettyJsonChecked = true;
		var apiClearBetweenRequestChecked = true;
		var apiTraceLogCheckboxChecked = true;
		var paneContent = "<div id=\"apiDiv\">";
		if(g_apiPaneData !== null) {
			try {
				apiGetUrl = g_apiPaneData.apiGetUrl;
				apiPutUrl = g_apiPaneData.apiPutUrl;
				apiPutPayload = g_apiPaneData.apiPutPayload;
				apiAdvancedCheckboxChecked = g_apiPaneData.apiAdvancedCheckboxChecked;
				apiPrettyJsonChecked = g_apiPaneData.apiPrettyJsonChecked;
				apiTraceLogCheckboxChecked = g_apiPaneData.apiTraceLogCheckboxChecked;
				apiClearBetweenRequestChecked = g_apiPaneData.apiClearBetweenRequestChecked;
				apiData = g_apiPaneData.apiData;
				apiLog = g_apiPaneData.apiLog;
			}
			catch {}
		}
		else {
			g_apiPaneData = {};
			g_apiPaneData.apiGetUrl = "";
			g_apiPaneData.apiPutUrl = "";
			g_apiPaneData.apiPutPayload = "";
			g_apiPaneData.apiAdvancedCheckboxChecked = apiAdvancedCheckboxChecked;
			g_apiPaneData.apiPrettyJsonChecked = apiPrettyJsonChecked;
			g_apiPaneData.apiTraceLogCheckboxChecked = apiTraceLogCheckboxChecked;
			g_apiPaneData.apiClearBetweenRequestChecked = apiClearBetweenRequestChecked;
			g_apiPaneData.apiData = "";
			g_apiPaneData.apiLog = "";
		}
	
		paneContent += "<label>Request</label>";
		paneContent += "<input type=\"text\" id=\"getUrl\" list=\"getUrlList\" class=\"getUrl\" value=\"" + apiGetUrl + "\"><datalist id=\"getUrlList\">";
		paneContent += "<option value=\"/iap/version\">"; 
		paneContent += "<option value=\"/iap/lic/status\">";
		paneContent += "<option value=\"/iap/users/current\">";
		paneContent += "<option value=\"/iap/settings/limits/configuration\">";
		paneContent += "<option value=\"/iap/devs\">";
		paneContent += "<option value=\"/iap/devs/2\">";
		paneContent += "<option value=\"/iap/devs/*+name==Sensor-1\">";
		paneContent += "<option value=\"/iap/devs/*+name==Sensor-1/if/Lamp/0/nviLamp/value\">";
		paneContent += "<option value=\"/iap/devs/*+name==Sensor-1/if/Lamp/0/nviLamp/*\">";
		paneContent += "<option value=\"/iap/devs/*+name==Sensor-1/if/Lamp/0/nviLamp/tags/*\">";
		paneContent += "<option value=\"/iap/devs/*+name==Sensor-1/if/Lamp/0/*+name=~nvoLampFb/value\">";
		paneContent += "<option value=\"/iap/devs/*+name==PulseGen-1/if/device/0/nviLamp1/value?max_age=2\">";
		paneContent += "<option value=\"/iap/devs/*+name==PulseGen-1/if/device/0/nviLamp1/*?max_age=2\">";
		paneContent += "<option value=\"/iap/dp/types?dpTypeName=SNVT_hvac_mode\">";
		paneContent += "<option value=\"/iap/devs/*/if/*/*/*+qualifier=-17q4bn7%2Flon%2F2.1%2FJoystick%2F0%2FnciNvType,17q4bn7%2Flon%2F2.1%2FJoystick%2F0%2FnvoValue/value?&noxs=true\">";
		paneContent += "<option value=\"/iap/devs/*/if/*/*/*+qualifier=-17q4bn7%2Flon%2F2.1%2FJoystick%2F0%2FnciNvType,17q4bn7%2Flon%2F2.1%2FJoystick%2F0%2FnvoValue/value?max_age=1&noxs=true\">";
		paneContent += "<option value=\"/iap/devs/count\">";
		paneContent += "<option value=\"/iap/devs/*+status==PROVISIONED/count\">";
		paneContent += "<option value=\"/iap/devs/*+status==down/count\">";
		paneContent += "<option value=\"/iap/devs/*?sts=down&noxs=true&sortBy=name&pg=1&sz=100\">";
		paneContent += "<option value=\"/iap/devs/*+status==PROVISIONED&health==normal/count\">";
		paneContent += "<option value=\"/iap/devs/*+status==PROVISIONED/if/*/*/*/count\">";
		paneContent += "<option value=\"/iap/devs/*/if/*/*/*/*\">";
		paneContent += "<option value=\"/iap/devs/*/if/*/*/*/value\">";
		paneContent += "<option value=\"/iap/devs/*/if/*/*/*/logs/value/*?sortBy=asc&pg=1&sz=1&noxs=true\">"; 
		paneContent += "<option value=\"/iap/devs/*+name=~pulsegen-1/if/*/*/*+name=~nvolux/logs/value/*?noxs=true&pg=1&sortBy=dpQualifier&sortOrder=asc&sz=25\">";
		paneContent += "<option value=\"/iap/devs/*+name==PulseGen-1/if/*/*/*+name==nvoLuxLevel/logs/value/*+utc>2020-11-06T19:50:00.000&utc<=2020-11-06T20:20:00.000\">";
		paneContent += "<option value=\"/iap/devs/*+scName=~SmartServer%20IoT&protocol==lon&typeName=~pulse&name=~Send&status==PROVISIONED/if/*+name=~La/*/*+name=~temp/*?noxs=true&pg=1&sz=100\">";
		paneContent += "<option value=\"/iap/devs/*+typeName=~pulse?noxs=true?pg1&sz=100\">";
		paneContent += "<option value=\"/iap/devs/*+scName=~SmartServer%20IoT\">";
		paneContent += "<option value=\"/iap/devs/*+category==SC\">";
		paneContent += "<option value=\"/iap/sev/*?end=2020-04-11&start=2020-04-04\">";
		paneContent += "<option value=\"/iap/log/data\">";
		paneContent += "<option value=\"/iap/devs/*/if/*/*/*/logs/count?visible=true\">";
		paneContent += "<option value=\"/iap/devs/*+name=~PulseGen-1/if/*/*/*/logs/count?visible=true\">";
		paneContent += "<option value=\"/iap/storage\">";
		paneContent += "</datalist>";
		paneContent += "<button onclick=\"apiGet()\">Get</button><br><br>";
		
		paneContent += "<input type=\"checkbox\" id=\"advancedCheckbox\" onchange=\"apiAdvancedCheckBox()\" >Advanced<br><br>"; 
		tempString = 'put:/iap/devs/*+name==Sensor1/if/Lamp/0/nviValue/value {\"value\":100,\"state\":1}';
		paneContent += "<div id=\"apiAdvancedDiv\" style=\"display:none;\">";
		paneContent += "<div>"
		paneContent += "<span style=\"display:inline-block;width:50px\">Request:</span> <input type=\"text\" id=\"putUrl\" list=\"putUrlList\" class=\"putUrl\" oninput=\"apiPutUrlChanged()\" value=\"" + apiPutUrl + "\">"
		paneContent += "<datalist id=\"putUrlList\">";
		paneContent += "<option value='" + tempString + "'>";
		paneContent += "<option value=\"put:/iap/devs/listByIDs [3,4]\">";
		paneContent += "<option value=\"put:/iap/devs/*+name==PulseGen1/if/Control/0/nviCount/value 201\">";
		paneContent += "<option value=\"put:/iap/devs/*+name==PulseGen1/if/device/0/nviLamp/presets/value ON\">";
		paneContent += "<option value=\"put:/iap/devs/*+name==PulseGen1/if/device/0/nviLamp/overrides/14/presets/value ON\">";
		paneContent += "<option value=\"put:/iap/devs/*+name==PulseGen1/if/device/0/nviCount/17/overrides/value 35\">";
		paneContent += "<option value=\"put:/iap/devs/*+name==PulseGen1/if/device/0/nviCount/17/localization/value 95\">";
		paneContent += "<option value=\"put:/iap/devs/*+name==PulseGen1/if/device/0/nviCount/overrides/17/presets/value ON\">";
		paneContent += "<option value=\"put:/iap/devs/T6tWyex.2/if/Control/0/nviCount/value 201\">";
		paneContent += "<option value='post:/iap/auth/login {\"username\":\"apollo\",\"password\":\"2234-3342\"}'>";
		paneContent += "<option value='post:/iap/devs/*+name==Sensor-1/if/Lamp/0/nviLamp/tags {\"xyz_floor1\"=\"1\"}'>";
		

		//d.setDate(d.getDate() + 1);
		sTemp = d.getUTCFullYear() + "-" + (d.getUTCMonth() + 1).toString().padStart(2,0)+ "-" + (d.getUTCDate()).toString().padStart(2,0);
		sTemp += "T" + (d.getUTCHours()).toString().padStart(2,0) + ":" + + (d.getUTCMinutes()).toString().padStart(2,0);
		paneContent += "<option value='delete:/iap/devs/*/if/*/*/*+timestamp=>" + sTemp + "Z/logs/value/*'>";
		paneContent += "<option value='delete:/iap/devs/*/if/*/*/*+timestamp=>" + sTemp + "Z&timestamp<2022-03-29T00:00Z/logs/value/*'>";
		paneContent += "</datalist>";
		paneContent += "<button onclick=\"apiPutRequest()\">Put</button>";
		paneContent += "<button onclick=\"apiPostRequest()\">Post</button><br><br>";
		paneContent += "<span style=\"display:inline-block;width:50px\">Payload:</span> <input type=\"text\" id=\"putPayload\" class=\"putUrl\" >";
		paneContent += "<input type=\"checkbox\" id=\"advancedDeleteCheckbox\" onchange=\"apiAdvancedDeleteCheckBox()\" >Delete";
		paneContent += "<button id=\"advancedDeleteButton\" onclick=\"apiDeleteRequest()\">Delete</button>";
		paneContent += "</div>";
		
		paneContent += "<br><div>";
		paneContent += "<input type=\"checkbox\" id=\"apiEnclodeRequestCheckbox\" onchange=\"apiEnclodeRequestCheckBox()\"";
		if(g_bApiEncodeRequestStr)
			paneContent += " checked";
		paneContent += "> Encode Request String (GET/PUT/POST/DELETE)<br><br>"
		paneContent += "String To Encode: <input id=\"apiStringToEncode\" type=\"text\" class=\"putEncodeString\" size=\"50\"> <button onclick=\"apiEncodeString()\">Encode</button>";
		paneContent += " Encoded String: <input id=\"apiEncodedString\" type=\"text\" class=\"putEncodeString\" size=\"50\"><br>";
		paneContent += "<i><span style=\"margin-left:10px;background-color: #366184;color: white\">use String Encode if Request string doesn't fully get encoded properly - Do not use full URI, use only for queries substrings</span></i>";
		paneContent += "<br>Pretty Json Data: <input type=\"checkbox\" id=\"advancedPrettyJson\" size=\"200\"><button id=\"advancedDeleteButton\" onclick=\"onchange=\"apiAdvancedPrettyJson()\"\">Pretty JSON</button>";
		paneContent += "</div>";
		paneContent += "</div>";

		paneContent += "<input type=\"checkbox\" id=\"clearBetweenRequestsCheckbox\"  onchange=\"apiClearBetweenRequest(this)\">Clear Between Requests";
		paneContent += "<input type=\"checkbox\" id=\"prettyJsonCheckbox\"  onchange=\"apiPrettyJsonCheckbox(this)\">Pretty JSON";
		paneContent += "<button onclick=\"apiDataClear()\">Clear</button>";
		sTemp += ":" + + (d.getUTCSeconds()).toString().padStart(2,0) + "Z";
		paneContent += "<span style=\"margin-left:100px\">UTC time:  " + sTemp + "</span><span style=\"margin-left:20px\">PC Time:  " + d.toLocaleString() + "</span>";
		paneContent += "<div></div><br><br><textarea id=\"apiData\" rows=\"20\"></textarea><br><br>";
		
		paneContent += "<input type=\"checkbox\" id=\"traceLogCheckbox\"  onchange=\"apiShowTraceLog()\">TraceLog";
		paneContent += "<button onclick=\"apiLogClear()\">Clear</button>";
		
		paneContent += "<br><br><textarea id=\"apiLog\" rows=\"8\"></textarea>";
		paneContent += "<br>Time Conversion:<br><input id=\"apiEpocTime\" value=\"" + d.getTime() + "\"><button style=\"margin-left:10px\" onclick=\"apiTimeConversion()\">Epoc Timestamp to Human Date</button>";
		paneContent += "<br><textarea id=\"apiEpocTimeLog\" rows=\"8\" cols=\"100\"></textarea>"; 
		document.getElementById("main-Header").innerHTML = paneTitle;
		document.getElementById("main").innerHTML = paneContent; // paneContent;
		if(apiPutPayload !== "")
			document.getElementById("putPayload").value = apiPutPayload;
		if(apiData !== "")
			document.getElementById("apiData").value = apiData;
		if(apiLog !== "")
			document.getElementById("apiLog").value = apiLog;
		if(apiAdvancedCheckboxChecked) {
			document.getElementById("advancedCheckbox").checked = apiAdvancedCheckboxChecked;
			if(apiAdvancedCheckboxChecked)
				document.getElementById("apiAdvancedDiv").style.display = "block";
			else	
				document.getElementById("apiAdvancedDiv").style.display = "none";
		}
		if(apiPrettyJsonChecked)
			document.getElementById("prettyJsonCheckbox").checked = apiPrettyJsonChecked;
		if(apiClearBetweenRequestChecked)
			document.getElementById("clearBetweenRequestsCheckbox").checked = apiClearBetweenRequestChecked;
		if(apiTraceLogCheckboxChecked)
			document.getElementById("traceLogCheckbox").checked = apiTraceLogCheckboxChecked;
	} catch {}
}