/*************************************************************************************************
 *  btmmain.js
 * 
 *  Contains initialization, and most of the functions for the SmartServer IoT Browser.  Specific funcitons are provided 
 *  in other js files.
 * 
 *  - The initial GET for Planning and Device data, use single request for both to get all the data
 * 		- all other function require you to press a button or check a poll checkbox
 * 		- The Dashboard view automatically polls at a two second update
 *  - The browser uses WebSocket updates for the Datapoint and Favs DP functions.  
 *       It is designed to poll no faster than 10 DPs every 2 seconds.
 * 
 *  All REST request require you to encode certain character not allowed in the URI path. encodeURI and encodeURIComponent don't encode
 *  all the characters needed to be decoded by the SmartServer 
 *  	encodePathString(str) is used on the entire uri and tries to remove some characters not allowed in Device or datapont names.
 *      Otherwise use "encodeUriString(str)" on the queries substrings
 * 
 *  Datapoint and FavoriteDps
 * 	processGetDeviceDpData(mode, type, requestUrlString, json)
 * 
 * 	Planning
 * 	getplanningTreeShowTreeContextBuilderWithDevices(json, level, bLastChild) - primary function for building Planning navigation tree
 * 
 *  Datalog
 * 	g_iDatalogPollMode - 0= Get log data + poll log data, 1 = Get log data + poll live data, 2 = poll only live data
 * 	datalogResponseProcessData(mode, requestUrlString, json) -- builds up and updates datalog chart and table 
 * 
 *  Copyright (C) 2022 EnOcean Gmbh.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	Dialog IzoT(tm) Software Developer's Kit License Agreement which is 
 *	available at www.dialog-semiconductor.com/license/izot_sdk/.  
 * 
 ***************************************************************************************************/

var g_sVersion = "1.00";
var deviceListAll = []; // defined by what device type is selected
var deviceListAllOrig = []; // does not include BACnet Devices
var deviceListAllPlusBacnetOrig = []; //includes BACnet Devices
var deviceTypeList = []; // defined by what device type is selected
var deviceTypeListOrig = []; // does not include BACnet Devices
var deviceTypeListPlusBacnetOrig = []; //includes BACnet Devices
var xifListOrig = []; // does not include BACnet Devices
var xifListPlusBacnetOrig = []; //includes BACnet Devices
var iDeviceTypesWithAtLeastOneDevice = 0; // does not include BACnet Devices
var iDeviceTypesPlusBacnetWithAtLeastOneDevice = 0; //includes BACnet Devices
var g_iSmartServerVersion = "";
var DISPLAYMODE_ALLDEVICES = 0;
var g_iMainDisplayMode =  DISPLAYMODE_ALLDEVICES;
var g_bBTMShowBacnetDevices = false;


function init1() {
	g_iSmartServerVersion = "";
	deviceListAll = [];
	deviceListAllOrig = [];
	deviceTypeList = [];
	deviceTypeListOrig = [];
	xifListOrig = [];
	deviceListAllPlusBacnetOrig = []; //includes BACnet Devices
	deviceTypeListPlusBacnetOrig = []; //includes BACnet Devices
	xifListPlusBacnetOrig = []; //includes BACnet Devices
	g_iSmartServerVersion = "";
	iDeviceTypesWithAtLeastOneDevice = 0;
	iDeviceTypesPlusBacnetWithAtLeastOneDevice = 0; //includes BACnet Devices
	addHelp();
	document.getElementById("softwareVersion").innerHTML = "(" + g_sVersion + ")";
	document.getElementById("top-Container").innerHTML = "";
	document.getElementById("log").innerHTML = "<div style=\"position:relative\">" + addWaitSpinner(3) + "</div>";
	getSmartServerVersion(); // get version,  all devices and then show planning tree
}
function addWaitSpinner(mode) {
	if(mode === 1)
		return "<div class=\"spinnerLoader1\"></div>";
	else if(mode === 2)
		return "<div class=\"spinnerLoader2\"></div>";
	else if(mode === 3)
		return "<div class=\"spinnerLoader3\"></div>";
	else
		return "<div class=\"spinnerLoader\"></div>";
}
function bacnetcheckbox() {
	try {
		var sel = document.getElementById("deviceTypeList");
		var text = sel.options[sel.selectedIndex].text, xifName;
		var i, z;
		var element, element1;
		var paneContent = "";
		
		var element = document.getElementById("btmshowbacnetDevices");
		if(element !== null) {
			if(element.checked) {
				g_bBTMShowBacnetDevices = true;
			}
			else {
				g_bBTMShowBacnetDevices = false;
			}
			showAvailableInfo(1);
			
			paneContent = deviceTypeOptionList();
			sel.innerHTML = paneContent;
			
			if(text !== "All Device Types") {
				z = -1;
				// verify current selection is still listed if not set to all
				if(g_bBTMShowBacnetDevices) {
					for(i=0; i < deviceTypeListPlusBacnetOrig.length; i++)
					{
						if(deviceTypeListPlusBacnetOrig[i].name === text) {
							z = i;
							break;
						}
					}
				}
				else {
					for(i=0; i < deviceTypeListOrig.length; i++)
					{
						if(deviceTypeListOrig[i].name === text) {
							z = i;
							break;
						}
					}
				}
			}
			if(z === -1) 
				sel.value = "All Device Types";
			else 
				sel.value = text;
			deviceTypeChanged();
		}
	}
	catch {}
}
function getSmartServerVersion() {
	var url = "https://" + location.hostname + "/iap/version";
	
	requestGetData(0, url, getSmartServerVersionCallback, null); // paginagion does't work on device list get Device list
}
function getSmartServerVersionCallback(mode, requestUrlString, json) {
		//checkForLoginCookie();
	var versionList, element;
	try { // only process once - add tags to datapoints
		g_iSmartServerVersion = json.value;
		versionList = g_iSmartServerVersion.split(".")
		

		g_iSmartServerVersion = (Number(versionList[0]) * 100000) + (Number(versionList[1]) * 1000) + Number(versionList[2]); 
		element = document.getElementById("cmsValue");
		if(element !== null)
			element.innerHTML = json.value;
		getDeviceTypes(0);
		
	}
	catch (err) {}
		
}
function getDeviceTypes(mode) {
	try {
		var i, url;
		deviceListAll = [];
		deviceListAllOrig = [];
		deviceTypeList = [];
		deviceTypeListOrig = [];
		deviceListAllPlusBacnetOrig = []; //includes BACnet Devices
		deviceTypeListPlusBacnetOrig = []; //includes BACnet Devices
		xifListOrig = [];
		xifListPlusBacnetOrig = []; //includes BACnet Devices
		iDeviceTypesWithAtLeastOneDevice = 0;
		iDeviceTypesPlusBacnetWithAtLeastOneDevice = 0; //includes BACnet Devices
		
		url = "https://" + location.hostname + "/iap/devTypes/*?short=false&sortBy=name&sortOrder=asc";
		requestGetData(0, url, getDeviceTypesResponse, readFailCallback);
	}
	catch (err) {}

}
function getDeviceTypesResponse(mode, requestUrlString, json) {
	try {
		var i, j, z, url;
		var obj;
		var name = ""; numberOfDevices = "", programId = "", xifName = "", id = "", autoSysLoad = "", autoAppLoad = "", isDefault = "";
		var bNewDeviceDetected = false;
		if((json === null) || (json.length === 0)) {
			document.getElementById("log").innerHTML = "No Device Types avaiable<br><br>You need to create device types and add at least 1 device (doesn't have to be provisioned) for each device type";
			return;
		}
		iDeviceTypesWithAtLeastOneDevice = 0;
		iDeviceTypesPlusBacnetWithAtLeastOneDevice = 0;
		deviceTypeListPlusBacnetOrig = JSON.parse(JSON.stringify(json));
		// remove all BACnet devices
		for(i=0; i < json.length; i++)
		{
			// includes BACnet devices
				if(json[i].numberOfDevices > 0)
					iDeviceTypesPlusBacnetWithAtLeastOneDevice++;
				z = -1;
				for(j=0; j < xifListPlusBacnetOrig.length; j++)
				{
					if(json[i].xifName === xifListPlusBacnetOrig[j]) {
						z = 1;
						break;
					}
				}
				if(z === -1) {
					xifListPlusBacnetOrig.push(json[i].xifName);
				}
			// all but bacnet devices
			if(json[i].protocol !== "bacnet") {
				deviceTypeListOrig.push(JSON.parse(JSON.stringify(json[i])));
				if(json[i].numberOfDevices > 0)
					iDeviceTypesWithAtLeastOneDevice++;
				z = -1;
				for(j=0; j < xifListOrig.length; j++)
				{
					if(json[i].xifName === xifListOrig[j]) {
						z = 1;
						break;
					}
				}
				if(z === -1) {
					xifListOrig.push(json[i].xifName);
				}
			}
		}
		getDeviceList()
	}
	catch (err) {}

}

function getDeviceList() { 
	g_PollingType = 0; 
	deviceListAll = [];
	deviceListAllOrig = [];
	var url = "/iap/devs?short=true&sortBy=name";
	g_sDevicesContext = "";
	requestGetData(0, url, getDeviceListCallback, readFailCallback); // get Device list

}
function getDeviceListCallback(mode, requestUrlString, json){
	var paneContent = "";
	var i;
	try {
		if((json === null) || (json.length === 0)) {
			if(mode !== 4)
				document.getElementById("log").innerHTML = "No Devices avaiable<br><br>You need at least 1 device (doesn't have to be provisioned) for each device type";
			return;
		}
		deviceListAllPlusBacnetOrig = JSON.parse(JSON.stringify(json));
		for(i=0; i < json.length; i++)
		{
			if(json[i].protocol !== "bacnet") {
				deviceListAllOrig.push(JSON.parse(JSON.stringify(json[i])));
			}
		}
		paneContent += "<br><span  class=\"featurespan\">Available: " + "</span><span id=\"availableInfo\" class=\"featurespan\">";
		paneContent += showAvailableInfo(0);
		paneContent += "</span>"
		paneContent += "<br><br><span class=\"featurespan\">Create BTM Files:</span><br><br><span class=\"featurespan\">Options:</span>"; 

		paneContent += "<br><span class=\"featurespanHeader\">BACnet Devices:</span>";
		paneContent += "<br><input id=\"btmshowbacnetDevices\" type=\"checkbox\" class=\"featurecheckbox\" onclick=\"bacnetcheckbox()\"";
		if(g_bBTMShowBacnetDevices)
			paneContent += " checked";
		paneContent += "><span class=\"featurespan\">Include BACnet Devices</span>"


		paneContent += "<br><span class=\"featurespanHeader\">Datapoints:</span>";
		paneContent += "<br><input id=\"btmdatapointRemoveNodeObjectDps\" type=\"checkbox\" class=\"featurecheckbox\"";
		if(g_bBtmRemoveNodeObjectDps)
			paneContent += " checked";
		paneContent += "><span class=\"featurespan\">Removes common NodeObject datapoints (unselected shows all NodeObject datapoints)</span>"
		paneContent += "<br><span class=\"featurespanHeader\">Bacnet datapoint name:</span>";
		paneContent += "<br><input id=\"btmdatapointAddDpBlockname\" type=\"checkbox\" class=\"featurecheckbox\"";
		if(g_bBtmBacnetnameAddBlockname)
			paneContent += " checked";
		paneContent += "><span class=\"featurespan\">Add datapoint block name (selected \"Lamp/1 nvoLamp\", unselected \"nvoLamp_2\")</span>"
		paneContent += "<br><input id=\"btmdatapointInstancename\" type=\"checkbox\" class=\"featurecheckbox\"";
		if(g_bBtmBacnetnameUseDatapointIntanceName)
			paneContent += " checked";
		paneContent += "><span class=\"featurespan\">Use datapoint name (unselected use datapoint XIF name)</span>"
		paneContent += "<br><input id=\"removeDatapointNviNvo\" type=\"checkbox\" class=\"featurecheckbox\"";
		if(g_bBtmRemoveDpNviNvoPrefix)
			paneContent += " checked";
		paneContent += "><span class=\"featurespan\">Remove datapoint nvi/nvo/nci prefix (selected \"Temperature\", unselected \"nvoTemperature\")</span>";
		paneContent += "<br><span class=\"featurespanHeader\">Datapoint Description:</span>";
		paneContent += "<br><input id=\"addDatapointPathToDescription\" type=\"checkbox\" class=\"featurecheckbox\"";
		if(g_bBtmAddDpPathToDescription)
			paneContent += " checked";
			paneContent += "><span class=\"featurespan\">show datapoint XIF path (e.g., TempSensor/0/nvoTemperture)</span>"
		paneContent += "<br><br><span class=\"featurespan\">Device Type: </span><select id=\"deviceTypeList\" style=\"margin-left:10px\" onchange=\"deviceTypeChanged()\">";
		paneContent += deviceTypeOptionList();
		
		paneContent += "</select>";
		paneContent += "<button style=\"margin-left:10px\" onclick=\"createBtmFiles()\">Create BTM File(s)</button>";
		paneContent += "<br><br>"
		document.getElementById("top-Container").innerHTML = paneContent;
		paneContent = "Select device type and click \"Create BTM Files\" to continue";
		
		document.getElementById("log").innerHTML = paneContent;
		document.getElementById("info").innerHTML = "<span class=\"logindent1\">All Device types selected (" + xifListOrig.length + " XIF files)</span>";
	}
	catch {}
	
}
function deviceTypeChanged() {
	var sel = document.getElementById("deviceTypeList");
	var text= sel.options[sel.selectedIndex].text, xifName;
	var element, sTemp;
	var bContinue = false;
	var i, j, z = -1;
	var objList = [];
	try {
		if(text === "All Device Types") {
			sTemp = "<span class=\"logindent1\">All Device types selected (";
			if(g_bBTMShowBacnetDevices)
				sTemp += xifListPlusBacnetOrig.length;
			else 
				sTemp += xifListOrig.length;
			sTemp += " XIF files)</span>";
			document.getElementById("info").innerHTML = sTemp;
		}
		else {
			
			if(g_bBTMShowBacnetDevices)
				objList = JSON.parse(JSON.stringify(deviceTypeListPlusBacnetOrig));
			else 
				objList = JSON.parse(JSON.stringify(deviceTypeListOrig));
			for(i=0; i < objList.length; i++)
			{
				if(objList[i].name === text) {
					sTemp = "<span class=\"logindent1\">Device Type: \""  + objList[i].name + "\"</span>, ";
					if(typeof objList[i].xifName === "undefined")
						sTemp += "XIF File name = none (IOX devices don't have a XIF file)";
					else 
						sTemp += "XIF File name = \"" + objList[i].xifName + "\"";
					sTemp += ", Number Of Devices = " + objList[i].numberOfDevices;
					if(objList[i].numberOfDevices === 0) {
						sTemp += "<br><br>*** BTM file can't be created as device type needs at least one device ***";
						stemp += "<br><br>Add at least one device to this Device type or use a device type that already has a device"
					}
					document.getElementById("info").innerHTML = sTemp;
					break;
				}
			}
		}
	}
	catch {}
}
function deviceTypeOptionList() {
	var paneContent = "<option value=\"All Device Types\">All Device Types</option>";
	var i;
	try {
		if(g_bBTMShowBacnetDevices) {
			for(i=0; i < deviceTypeListPlusBacnetOrig.length; i++)
			{
				paneContent += "<option value=\"" + deviceTypeListPlusBacnetOrig[i].name + "\">" + deviceTypeListPlusBacnetOrig[i].name + "</option>";
			}
		}
		else {
			for(i=0; i < deviceTypeListOrig.length; i++)
			{
				paneContent += "<option value=\"" + deviceTypeListOrig[i].name + "\">" + deviceTypeListOrig[i].name + "</option>";
			}
		}
	}
	catch {}
	return paneContent;
}
function createBtmFiles() {
	try {
		var sel = document.getElementById("deviceTypeList");
		var text= sel.options[sel.selectedIndex].text, xifName;
		var element, sTemp;
		var bContinue = false;
		var i, j, z = -1;
		var objDevices = [], objDeviceTypes = [];
		deviceTypeList = [];
		deviceListAll = [];
		if(text === "All Device Types") {
			if(g_bBTMShowBacnetDevices) {
				deviceTypeList = JSON.parse(JSON.stringify(deviceTypeListPlusBacnetOrig));
				deviceListAll = JSON.parse(JSON.stringify(deviceListAllPlusBacnetOrig));
			}
			else {
				for(i=0; i < deviceTypeListOrig.length; i++)
				{
					if(deviceTypeListOrig[i].protocol !== "bacnet") {
						deviceTypeList.push(JSON.parse(JSON.stringify(deviceTypeListOrig[i])));
					}
				}
				for(i=0; i < deviceListAllOrig.length; i++)
				{
					if(deviceListAllOrig[i].protocol !== "bacnet") {
						deviceListAll.push(JSON.parse(JSON.stringify(deviceListAllOrig[i])));
					}
				}
			}
			if(confirm("Do you really want to create btm files for all non-BACnet device types")) {
				document.getElementById("log").innerHTML += "<br>Creating BTM files for " + deviceTypeList.length + " device types<br><br>Total Devices: " + deviceListAll.length;
				bContinue = true;
			}
			else 
				document.getElementById("log").innerHTML = "Aborted - Creating BTM files";
		}
		else {
			if(g_bBTMShowBacnetDevices) {
				objDeviceTypes = JSON.parse(JSON.stringify(deviceTypeListPlusBacnetOrig));
				objDevices = JSON.parse(JSON.stringify(deviceListAllPlusBacnetOrig));
			}
			else {
				objDeviceTypes = JSON.parse(JSON.stringify(deviceTypeListOrig));
				objDevices = JSON.parse(JSON.stringify(deviceListAllOrig));
			}
			for(i=0; i < deviceTypeListOrig.length; i++)
			{
				if(objDeviceTypes[i].name === text) {
					if(objDeviceTypes[i].numberOfDevices > 0) {
						deviceTypeList.push(JSON.parse(JSON.stringify(objDeviceTypes[i])));
						xifName = objDeviceTypes[i].xifName;
						if(xifName === "") {

						}
						else {
							for(j=0; j < objDevices.length; j++)
							{
								if(objDevices[j].deviceTypeName === text) {
									document.getElementById("log").innerHTML += "<br>Creating BTM files for " + objDevices[j].deviceTypeName;
									deviceListAll.push(JSON.parse(JSON.stringify(objDevices[j])));
									bContinue = true;
									break;
								}
							}
						}
					}
					else {
						sTemp = "<br><br>*** Warning: BTM file not created - "
						sTemp += objDevices[j].deviceTypeName + " has no devices, you must select a device type with at least one device";
						document.getElementById("log").innerHTML += sTemp;
						sTemp = "Warning: BTM file not created\r\n"
						sTemp += objDevices[j].deviceTypeName + " has no devices, you must select a device type with at least one device";
						alert(sTemp);
						return;
					}
					break;
				}
			}
		}
		if(bContinue) {
			element = document.getElementById("removeDatapointNviNvo");
			if(element !== null) {
				if(element.checked)
					g_bBtmRemoveDpNviNvoPrefix = true;
				else
					g_bBtmRemoveDpNviNvoPrefix = false;
				element = document.getElementById("addDatapointPathToDescription");
				if(element !== null) {
					if(element.checked)
						g_bBtmAddDpPathToDescription = true;
					else
						g_bBtmAddDpPathToDescription = false;
					element = document.getElementById("btmdatapointInstancename");
					if(element !== null) {
						if(element.checked)
							g_bBtmBacnetnameUseDatapointIntanceName = true;
						else
							g_bBtmBacnetnameUseDatapointIntanceName = false;
						element = document.getElementById("btmdatapointAddDpBlockname");
						if(element !== null) {
							if(element.checked)
								g_bBtmBacnetnameAddBlockname = true;
							else
								g_bBtmBacnetnameAddBlockname = false;
							element = document.getElementById("btmdatapointRemoveNodeObjectDps");
							if(element !== null) {
								if(element.checked)
								g_bBtmRemoveNodeObjectDps = true;
								else
								g_bBtmRemoveNodeObjectDps = false;

								sTemp = "<br>Processing " + text + "<br><br>";
								/*
								sTemp += "Datapints - remove some NodeObject Datapoints: " +g_bBtmRemoveNodeObjectDps + "<br>";
								sTemp += "BACnet name - add Blockname: " + g_bBtmBacnetnameAddBlockname + "<br>";
								sTemp += "BACnet name - use datapoint instance name (instead of datapoint XIF name): " + g_bBtmBacnetnameUseDatapointIntanceName + "<br>";
								sTemp += "BACnet name - remove prefix nvi/nvo from Datapoint name: " + g_bBtmRemoveDpNviNvoPrefix + "<br>";
								sTemp += "Add datapoint path datapoint description: " + g_bBtmAddDpPathToDescription + "<br>"; */
								sTemp += "<div style=\"position:relative;height:150px\">" + addWaitSpinner(2) + "</div>";
								g_sBtmListOfBtmFilesCreated = "";
								g_iBtmNumBtmFilesCreated = 0;
								document.getElementById("log").innerHTML += sTemp;
								if(text === "All Device Types")
									btmCreateBtmFile(0, null, null);
								else {
									btmCreateBtmFile(1, deviceListAll[0].id, deviceListAll[0].name);
								}
								return;
							}
						}
					}
				}
			}
			document.getElementById("log").innerHTML += "<br>Error: Problem Processing " + text + "<br><br>TBD";
		}
		else 
			document.getElementById("log").innerHTML += "<br>Error: Can't create BTM for " + text;
			

	}
	catch {}
}
function menuDivClose() {
	// Remove Spinner
	try {
		var sTemp = "List of BTM files created (" + g_iBtmNumBtmFilesCreated + "):<br>" + g_sBtmListOfBtmFilesCreated;
		document.getElementById("log").innerHTML = sTemp;
	}
	catch {}
}
function readFailCallback(mode, url, json) {
	alert("Read Failure");
}
function refresh() {
	try {
		document.getElementById("log").innerHTML = addWaitSpinner(2);
		getDeviceTypes(0);
	}
	catch {}
}
function showAvailableInfo(mode) {
	var paneContent = "";
	var element;
	if(g_bBTMShowBacnetDevices) {
		paneContent += "Number of XIF files = " + xifListOrig.length;
		paneContent += ", Number of Device Types = " + deviceTypeListOrig.length +" (" + iDeviceTypesPlusBacnetWithAtLeastOneDevice + " with devices)";
		paneContent += ", Number of Devices = " + deviceListAllOrig.length;
	}
	else {
		paneContent += "Number of XIF files = " + xifListOrig.length;
		paneContent += ", Number of Device Types = " + deviceTypeListOrig.length +" (" + iDeviceTypesWithAtLeastOneDevice + " with devices)";
		paneContent += ", Number of Devices = " + deviceListAllOrig.length + " [BACnet devices excluded]";
	}
	if(mode === 1) {
		element = document.getElementById("availableInfo");
		if(element !== null)
			element.innerHTML = paneContent;
		paneContent = "";
	}
	return paneContent;
}
function addHelp() {
	try {
		var element = document.getElementById("help");
		var element1 = document.getElementById("showhelp");
		var content = ""
		if(element !== null) {
			if(element1 !== null) {
				element1.checked = true;
				element.style.display = "block";
			}
			content = "<ol>"
			content += "<li>The BTM Creation Tool creates BTM files (used to access LON and Modbus datapoints in a BACnet tool) for a single or all device Types<ul>";
			content += "<li>Requires SmartServer IoT 3.40+</li></ul></li>";
			content += "<li>Creates BTM files for XIF files (like *.xif and *.mod) for LON, Modbus and IAP devices (not IOX)<ul>";
			content += "<li>Optionally, creates BTM files for BACnet devices as BACnet devices are already accessible by a BACnet tool</li>";
			content += "<li>For each XIF file, requires one device type with at least one device</li></ul></li>";

			content += "<li>Create the Device Type (which specifies a XIF file) in the SmartServer prior to running the BTM Creator tool<ul>";
			content += "<li>Uses Device types to select XIF file so you need to add at least one device for each Device Type you want to make a BTM file<ul>";
			content += "<li>This device only needs to be added and not provisioned</li>";
			content += "<li>If you have multiple device types using the same XIF file then you only need to add a device to one of the device types</ul></li></ul></li>";
			
			

			content += "<li>Saves files in PC downloads folder";
			content += "<ol><li>Will add \"(&lt;number&gt;)\" to file name if file name already exisits in the downloads folder";
			content += "<li>Consider moving or removing old btm files from downloads directory using Winodws Explorer (CTRL-E) before creating BTM files</li>";
			content += "<li>You will most likely want to modify the BTM file with a text editor or Excel to reduce the number of datapoints and change datapoint names before importing the BTM file into the SmartServer";
			content += "<ul><li>Excel sometimes mangles content.</li><li>When making changes using Excel make sure to save as csv</li></ul>";
			content += "</li>";
			content += "</ol>";
			content += "<li>Imported BTM files into CMS must match XIF file name - for example, if XIF name is \"6kEvbMultiSensor.xif\"<ol>";
			content += "<li>valid BTM file names:<ol><li>6kEvbMultiSensor.btm</li><li>6kEvbMultiSensor.btm.csv</li></ol>";
			content += "<li>Invalid BTM file names:<ol><li>6kEvbMultiSensor(1).btm</li><li>6kEvbMultiSensor.btm(1).csv</li></ol>";
			content += "</ol></li>";


			content += "<li>Option Notes<ol>";
			content += "<li>BTM files are created for XIF files and so if you have multiple device types using the same XIF file then only one BTM file is created</li>";
			content += "<li>Some Datapoint Blocks have multiple instances (like \"lamp/0/nvoLamp\" and \"\"lamp/1/nvoLamp\")<ul>";
			content += "<li>To make BACnet name unique use the BACnet name Add datapoint block name selection.<ul>";
			content += "<li>If selected the datapoint Block and Block Index will be added to the BACnet name (like \"lamp/1/nvoLamp\").</li>";
			content += "<li>If unselected and there are multiple Block indexes then a \"_&lt;Block Index + 1&gt;\" is added to the BACnet name (like \"nvoLamp_1\").</li>";
			content += "</ul></li>";
			content += "</ul></li>";
			content += "<li>Depending on what version of software you are using (the default software image, use glpo, or re-iamge) the datapoint instance name and datapoint XIF name";
			content += "may be different on the SmartServer you created the BTM files and the one you imported the files.<ul>";
			content += "<li>Using the CMS Datapoint Widget \"show detailed properties\" (click the Widget action menu \"...\") verify the datapoints Instance and XIF names are the same";
			content += "</ul></li>";
			content += "<li>Datapoints - remove NodeObject datapoints<ul>";
			content += "<li>Some datapoints on the NodeObject Block are not really useful for a BACnet Tool so you may want to remove them</li>";
			content += "<li>If selected the following are removed: nciDevMajVer, nciDevMinVer, nvoStatus, nciNetConfig, nviRequest, and nvoFileDirectory</li></ul>";
			content += "</ol></li>";
			content += "<li>CMS Warning Messages<ol>";
			content += "<li>Yellow Warning message ending in \"btm missing mandatory column bacnet_type\"</li><ul>";
			content += "<li>Usually means the BACnet address is incorrect</li>";
			content += "<li>Look for any column with \"?\", fix value or remove row from file, and re-import into Smartserver CMS</li>";
			content += "</ol>";
			content += "</ol>";
			element.innerHTML = content;
		}
		element = document.getElementById("instructions");
		if(element !== null) {
			content = "";				
			content += "Instructions<ol>";
			content += "<li>SmartServer<ul><li>Add device types with at least one device per device type</li></ul></li>";
			content += "<li>[Optional] Move or delete any existing BTM files in the PC downloads folder</li>";
			content += "<li>BTM Creation Tool<ol>";
			content += "<li>Select BTM creation options</li>";
			content += "<li>Select Device Type and click \"Create BTM Files\"</li></ol>";
			content += "<li>Find BTM files in PC downloads directory\"</li>";
			content += "<li>Rename any BTM file with \"(&lt;number&gt;)\" included in filename";
			content += "<ul><li>Rename 6kEvbMultiSensor(1).btm.csv or 6kEvbMultiSensor.btm(1).csv to 6kEvbMultiSensor.btm.csv</li></ul></li>";
			content += "<li>Edit File using a Text Editor or Excel<ul>";
			content += "<li>Modify contents of BTM file to limit the number of datapoints and to rename datapoint names</li></ul>";
			content += "<li>Import BTM file or add to DTP file and import DTP file into the SmartServer</li>";
			content += "</ol>";
			
			element.innerHTML = content;
		}

	}
	catch {}
	
}
function toggleHelp() {
	try {
		
		var element = document.getElementById("help");
		var element1 = document.getElementById("showhelp");
		if(element !== null) {
			if(element1 !== null) {
				if(element1.checked) {
					element.style.display = "block";
				}
				else {
					element.style.display = "none";
				}
			}
		}
	}
	catch {}
}

