# C and C++
- Brian W. Kernighan, Dennis Ritchie. C Programming Language, 2nd Edition.
- Bjarne Stroustrup. 2013. The C++ Programming Language (4th. ed.). Addison-Wesley Professional.
- [C type system](https://en.cppreference.com/w/c/language/type)
- [C++ type system](https://en.cppreference.com/w/cpp/language/type)
- [Const type qualifier](https://en.cppreference.com/w/c/language/const)
- [Restrict type qualifier](https://en.cppreference.com/w/c/language/restrict)
- [Volatile type qualifier](https://en.cppreference.com/w/c/language/volatile)
- [Struct declaration](https://en.cppreference.com/w/c/language/struct) in C language
- [Class declaration](https://en.cppreference.com/w/cpp/language/class) in C++ language
- Union declaration in [C language](https://en.cppreference.com/w/c/language/union) and [C++ language](https://en.cppreference.com/w/cpp/language/union)

# AddressSanitizer
- A Guide to Undefined Behavior in C and C++, [Part 1](https://blog.regehr.org/archives/213)
- [Address Sanitizer](https://github.com/google/sanitizers/wiki/AddressSanitizer)
- [Address Sanitizer Flags](https://github.com/google/sanitizers/wiki/AddressSanitizerFlags)

# Clang, LLVM
- Clang AST Matcher [Reference](https://clang.llvm.org/docs/LibASTMatchersReference.html)
- Clang Tutorial - [CS453 Automated Software Testing](https://swtv.kaist.ac.kr/courses/cs453-fall13/Clang%20tutorial%20v4.pdf)
- Syntax Macros: [a Case-Study in Extending Clang](https://llvm.org/devmtg/2016-09/slides/Rink-SyntaxMacros.pdf)
https://stackoverflow.com/questions/49877836/how-can-i-get-macro-name-from-cstylecastexpr-matcher-in-clang-tidy
https://stackoverflow.com/questions/58620022/how-to-get-the-macro-and-its-expansion-with-clang-libtooling

- [LLVM Loop Terminology](https://llvm.org/docs/LoopTerminology.html)
- [CFGBlock](https://clang.llvm.org/doxygen/classclang_1_1CFGBlock.html)