<?php

return [
    'title' => 'E-Invoicing Activation',
    'subject' => 'Important: Your E-Invoicing Service is Now Active',

    'greeting' => 'Welcome to E-Invoicing, :name!',

    'intro' => "This service enables you to:",
    'intro_items' => "
        • Send and receive invoices electronically<br>
        • Ensure compliance with tax regulations<br>
        • Speed up payment processing<br>
        • Reduce manual data entry and errors<br>
    ",

    'requirements_title' => 'Important Requirements',
    'requirements_intro' => 'To ensure successful e-invoicing, please verify these critical business details:',
    'requirements_items' => "
            • Legal Business Name - Must exactly match your official registration<br>
            • Tax/VAT Number - Must be current and validated<br>
            • Business Identifiers (ABN/EORI/GLN) - Must be accurate and active<br>
            • Business Address - Must match official records<br>
            • Contact Details - Must be up to date and monitored<br>
        ",

    'validation_title' => 'Why Accurate Information Matters',
    'validation_items' => "
            • Incorrect details may cause invoice rejection<br>
            • Tax authorities require exact matching of registration numbers<br>
            • Payment systems rely on correct business identifiers<br>
            • Legal compliance depends on accurate business information<br>
        ",

    'next_steps' => 'Next Steps',
    'next_steps_items' => "
            1. Review your company details in account settings<br>
            2. Update any outdated information<br>
            3. Verify tax registration numbers<br>
            4. Send a test e-invoice<br>
        ",
    'support_title' => 'Need Assistance?',
    'support_message' => "Our support team is ready to help with any questions about e-invoicing requirements or setup.<br>
                    Contact support: :email<br>
                    Thank you for choosing our e-invoicing service.<br>
    ",
    'text' => "
E-Rechnungsaktivierung

Willkommen bei E-Rechnung.

Dieser Service ermöglicht Ihnen:
• Elektronisches Senden und Empfangen von Rechnungen
• Einhaltung der Steuerbestimmungen sicherstellen
• Beschleunigung der Zahlungsabwicklung
• Reduzierung manueller Dateneingaben und Fehler

Wichtige Anforderungen

Um erfolgreiches E-Invoicing zu gewährleisten, überprüfen Sie bitte diese wichtigen Geschäftsdaten:
• Offizieller Firmenname - Muss exakt mit Ihrer offiziellen Registrierung übereinstimmen
• Steuer-/Umsatzsteuer-Nummer - Muss aktuell und validiert sein
• Geschäftsidentifikatoren (ABN/EORI/GLN) - Müssen korrekt und aktiv sein
• Geschäftsadresse - Muss mit offiziellen Unterlagen übereinstimmen
• Kontaktdaten - Müssen aktuell und überwacht sein

Warum genaue Informationen wichtig sind

• Falsche Angaben können zur Ablehnung von Rechnungen führen
• Steuerbehörden erfordern exakte Übereinstimmung der Registrierungsnummern
• Zahlungssysteme basieren auf korrekten Geschäftsidentifikatoren
• Rechtliche Compliance hängt von genauen Geschäftsinformationen ab

Nächste Schritte

Überprüfen Sie Ihre Unternehmensdetails in den Kontoeinstellungen
Aktualisieren Sie veraltete Informationen
Überprüfen Sie Steuerregistrierungsnummern
Senden Sie eine Test-E-Rechnung
Benötigen Sie Hilfe?

Unser Support-Team hilft Ihnen gerne bei Fragen zu E-Rechnungsanforderungen oder der Einrichtung.

Kontaktieren Sie den Support: contact@invoiceninja.com

Vielen Dank, dass Sie sich für unseren E-Rechnungsservice entschieden haben.
    "

];
