<?php
/**
 * @OA\Schema(
 *   schema="RecurringExpense",
 *   type="object",
 *       @OA\Property(property="id", type="string", example="Opnel5aKBz", description="The hashed id of the recurring expense"),
 *       @OA\Property(property="user_id", type="string", example="Opnel5aKBz", description="The hashed id of the user who created the recurring expense"),
 *       @OA\Property(property="assigned_user_id", type="string", example="Opnel5aKBz", description="The hashed id of the user assigned to this recurring expense"),
 *       @OA\Property(property="company_id", type="string", example="Opnel5aKBz", description="The hashed id of the company"),
 *       @OA\Property(property="client_id", type="string", example="Opnel5aKBz", description="The hashed id of the client"),
 *       @OA\Property(property="invoice_id", type="string", example="Opnel5aKBz", description="The hashed id of the invoice"),
 *       @OA\Property(property="bank_id", type="string", example="22", description="The id of the bank associated with this recurring expense"),
 *       @OA\Property(property="invoice_currency_id", type="string", example="1", description="The currency id of the invoice associated with this recurring expense"),
 *       @OA\Property(property="expense_currency_id", type="string", example="1", description="The currency id of the expense associated with this recurring expense"),
 *       @OA\Property(property="invoice_category_id", type="string", example="1", description="The category id of the invoice"),
 *       @OA\Property(property="payment_type_id", type="string", example="1", description="The payment type id"),
 *       @OA\Property(property="private_notes", type="string", example="Private and confidential", description="The recurring expense private notes"),
 *       @OA\Property(property="public_notes", type="string", example="This is the best client in the world", description="The recurring expense public notes"),
 *       @OA\Property(property="transaction_reference", type="string", example="EXP-1223-2333", description="The recurring expense transaction reference"),
 *       @OA\Property(property="transcation_id", type="string", example="1233312312", description="The transaction id of the recurring expense"),
 *       @OA\Property(property="custom_value1", type="string", example="$1000", description="Custom value field"),
 *       @OA\Property(property="custom_value2", type="string", example="2022-10-10", description="Custom value field"),
 *       @OA\Property(property="custom_value3", type="string", example="short text", description="Custom value field"),
 *       @OA\Property(property="custom_value4", type="string", example="very long text", description="Custom value field"),
 *       @OA\Property(property="tax_name1", type="string", example="GST", description="The tax name"),
 *       @OA\Property(property="tax_name2", type="string", example="VAT", description="The tax name"),
 *       @OA\Property(property="tax_rate1", type="number", format="float", example="10.00", description="The tax rate"),
 *       @OA\Property(property="tax_rate2", type="number", format="float", example="10.00", description="The tax rate"),
 *       @OA\Property(property="tax_name3", type="string", example="", description="The tax name"),
 *       @OA\Property(property="tax_rate3", type="number", format="float", example="10.00", description="The tax rate"),
 *       @OA\Property(property="amount", type="number", format="float", example="10.00", description="The total amount of the recurring expense"),
 *       @OA\Property(property="frequency_id", type="number", format="int", example="1", description="The frequency this recurring expense fires"),
 *       @OA\Property(property="remaining_cycles", type="number", format="int", example="1", description="The number of remaining cycles for this recurring expense"),
 *       @OA\Property(property="foreign_amount", type="number", format="float", example="10.00", description="The foreign currency amount of the recurring expense"),
 *       @OA\Property(property="exchange_rate", type="number", format="float", example="0.80", description="The exchange rate for the expernse"),
 *       @OA\Property(property="date", type="string", example="", description="The date of the expense"),
 *       @OA\Property(property="payment_date", type="string", example="", description="The date the expense was paid"),
 *       @OA\Property(property="should_be_invoiced", type="boolean", example=true, description="Boolean flag determining if the expense should be invoiced"),
 *       @OA\Property(property="is_deleted", type="boolean", example=true, description="Boolean flag determining if the recurring expense is deleted"),
 *       @OA\Property(property="last_sent_date", type="string", format="date", example="1994-07-30", description="The Date it was sent last"),
 *       @OA\Property(property="next_send_date", type="string", format="date", example="1994-07-30", description="The next send date"),
 *       @OA\Property(property="invoice_documents", type="boolean", example=true, description="Boolean flag determining if the documents associated with this expense should be passed onto the invoice if it is converted to an invoice"),
 *       @OA\Property(property="updated_at", type="number", format="integer", example="1434342123", description="Timestamp"),
 *       @OA\Property(property="archived_at", type="number", format="integer", example="1434342123", description="Timestamp"),
 * )
 */
