<?php

/**
 * Invoice Ninja (https://invoiceninja.com).
 *
 * @link https://github.com/invoiceninja/invoiceninja source repository
 *
 * @copyright Copyright (c) 2024. Invoice Ninja LLC (https://invoiceninja.com)
 *
 * @license https://www.elastic.co/licensing/elastic-license
 */

namespace App\DataProviders;

use Illuminate\Support\Facades\Http;

class USStates
{
    public static array $states = [
        'AL' => 'Alabama',
        'AK' => 'Alaska',
        'AZ' => 'Arizona',
        'AR' => 'Arkansas',
        'CA' => 'California',
        'CO' => 'Colorado',
        'CT' => 'Connecticut',
        'DE' => 'Delaware',
        'DC' => 'District Of Columbia',
        'FL' => 'Florida',
        'GA' => 'Georgia',
        'HI' => 'Hawaii',
        'ID' => 'Idaho',
        'IL' => 'Illinois',
        'IN' => 'Indiana',
        'IA' => 'Iowa',
        'KS' => 'Kansas',
        'KY' => 'Kentucky',
        'LA' => 'Louisiana',
        'ME' => 'Maine',
        'MD' => 'Maryland',
        'MA' => 'Massachusetts',
        'MI' => 'Michigan',
        'MN' => 'Minnesota',
        'MS' => 'Mississippi',
        'MO' => 'Missouri',
        'MT' => 'Montana',
        'NE' => 'Nebraska',
        'NV' => 'Nevada',
        'NH' => 'New Hampshire',
        'NJ' => 'New Jersey',
        'NM' => 'New Mexico',
        'NY' => 'New York',
        'NC' => 'North Carolina',
        'ND' => 'North Dakota',
        'OH' => 'Ohio',
        'OK' => 'Oklahoma',
        'OR' => 'Oregon',
        'PA' => 'Pennsylvania',
        'RI' => 'Rhode Island',
        'SC' => 'South Carolina',
        'SD' => 'South Dakota',
        'TN' => 'Tennessee',
        'TX' => 'Texas',
        'UT' => 'Utah',
        'VT' => 'Vermont',
        'VA' => 'Virginia',
        'WA' => 'Washington',
        'WV' => 'West Virginia',
        'WI' => 'Wisconsin',
        'WY' => 'Wyoming',
    ];

    private static array $zip_code_map = [
        '00601' => 'PR',
        '00602' => 'PR',
        '00603' => 'PR',
        '00606' => 'PR',
        '00610' => 'PR',
        '00611' => 'PR',
        '00612' => 'PR',
        '00616' => 'PR',
        '00617' => 'PR',
        '00622' => 'PR',
        '00623' => 'PR',
        '00624' => 'PR',
        '00627' => 'PR',
        '00631' => 'PR',
        '00636' => 'PR',
        '00637' => 'PR',
        '00638' => 'PR',
        '00641' => 'PR',
        '00646' => 'PR',
        '00647' => 'PR',
        '00650' => 'PR',
        '00652' => 'PR',
        '00653' => 'PR',
        '00656' => 'PR',
        '00659' => 'PR',
        '00660' => 'PR',
        '00662' => 'PR',
        '00664' => 'PR',
        '00667' => 'PR',
        '00669' => 'PR',
        '00670' => 'PR',
        '00674' => 'PR',
        '00676' => 'PR',
        '00677' => 'PR',
        '00678' => 'PR',
        '00680' => 'PR',
        '00682' => 'PR',
        '00683' => 'PR',
        '00685' => 'PR',
        '00687' => 'PR',
        '00688' => 'PR',
        '00690' => 'PR',
        '00692' => 'PR',
        '00693' => 'PR',
        '00694' => 'PR',
        '00698' => 'PR',
        '00703' => 'PR',
        '00704' => 'PR',
        '00705' => 'PR',
        '00707' => 'PR',
        '00714' => 'PR',
        '00715' => 'PR',
        '00716' => 'PR',
        '00717' => 'PR',
        '00718' => 'PR',
        '00719' => 'PR',
        '00720' => 'PR',
        '00723' => 'PR',
        '00725' => 'PR',
        '00727' => 'PR',
        '00728' => 'PR',
        '00729' => 'PR',
        '00730' => 'PR',
        '00731' => 'PR',
        '00735' => 'PR',
        '00736' => 'PR',
        '00738' => 'PR',
        '00739' => 'PR',
        '00740' => 'PR',
        '00741' => 'PR',
        '00745' => 'PR',
        '00751' => 'PR',
        '00754' => 'PR',
        '00757' => 'PR',
        '00765' => 'PR',
        '00766' => 'PR',
        '00767' => 'PR',
        '00769' => 'PR',
        '00771' => 'PR',
        '00772' => 'PR',
        '00773' => 'PR',
        '00775' => 'PR',
        '00777' => 'PR',
        '00778' => 'PR',
        '00780' => 'PR',
        '00782' => 'PR',
        '00783' => 'PR',
        '00784' => 'PR',
        '00786' => 'PR',
        '00791' => 'PR',
        '00794' => 'PR',
        '00795' => 'PR',
        '00802' => 'VI',
        '00820' => 'VI',
        '00830' => 'VI',
        '00840' => 'VI',
        '00850' => 'VI',
        '00851' => 'VI',
        '00901' => 'PR',
        '00906' => 'PR',
        '00907' => 'PR',
        '00909' => 'PR',
        '00911' => 'PR',
        '00912' => 'PR',
        '00913' => 'PR',
        '00915' => 'PR',
        '00917' => 'PR',
        '00918' => 'PR',
        '00920' => 'PR',
        '00921' => 'PR',
        '00923' => 'PR',
        '00924' => 'PR',
        '00925' => 'PR',
        '00926' => 'PR',
        '00927' => 'PR',
        '00934' => 'PR',
        '00949' => 'PR',
        '00950' => 'PR',
        '00951' => 'PR',
        '00952' => 'PR',
        '00953' => 'PR',
        '00956' => 'PR',
        '00957' => 'PR',
        '00959' => 'PR',
        '00960' => 'PR',
        '00961' => 'PR',
        '00962' => 'PR',
        '00965' => 'PR',
        '00966' => 'PR',
        '00968' => 'PR',
        '00969' => 'PR',
        '00971' => 'PR',
        '00976' => 'PR',
        '00979' => 'PR',
        '00982' => 'PR',
        '00983' => 'PR',
        '00985' => 'PR',
        '00987' => 'PR',
        '01001' => 'MA',
        '01002' => 'MA',
        '01003' => 'MA',
        '01005' => 'MA',
        '01007' => 'MA',
        '01008' => 'MA',
        '01009' => 'MA',
        '01010' => 'MA',
        '01011' => 'MA',
        '01012' => 'MA',
        '01013' => 'MA',
        '01020' => 'MA',
        '01022' => 'MA',
        '01026' => 'MA',
        '01027' => 'MA',
        '01028' => 'MA',
        '01029' => 'MA',
        '01030' => 'MA',
        '01031' => 'MA',
        '01032' => 'MA',
        '01033' => 'MA',
        '01034' => 'MA',
        '01035' => 'MA',
        '01036' => 'MA',
        '01037' => 'MA',
        '01038' => 'MA',
        '01039' => 'MA',
        '01040' => 'MA',
        '01050' => 'MA',
        '01053' => 'MA',
        '01054' => 'MA',
        '01056' => 'MA',
        '01057' => 'MA',
        '01060' => 'MA',
        '01062' => 'MA',
        '01063' => 'MA',
        '01066' => 'MA',
        '01068' => 'MA',
        '01069' => 'MA',
        '01070' => 'MA',
        '01071' => 'MA',
        '01072' => 'MA',
        '01073' => 'MA',
        '01074' => 'MA',
        '01075' => 'MA',
        '01077' => 'MA',
        '01079' => 'MA',
        '01080' => 'MA',
        '01081' => 'MA',
        '01082' => 'MA',
        '01083' => 'MA',
        '01084' => 'MA',
        '01085' => 'MA',
        '01088' => 'MA',
        '01089' => 'MA',
        '01092' => 'MA',
        '01093' => 'MA',
        '01094' => 'MA',
        '01095' => 'MA',
        '01096' => 'MA',
        '01097' => 'MA',
        '01098' => 'MA',
        '01103' => 'MA',
        '01104' => 'MA',
        '01105' => 'MA',
        '01106' => 'MA',
        '01107' => 'MA',
        '01108' => 'MA',
        '01109' => 'MA',
        '01118' => 'MA',
        '01119' => 'MA',
        '01128' => 'MA',
        '01129' => 'MA',
        '01144' => 'MA',
        '01151' => 'MA',
        '01201' => 'MA',
        '01220' => 'MA',
        '01222' => 'MA',
        '01223' => 'MA',
        '01224' => 'MA',
        '01225' => 'MA',
        '01226' => 'MA',
        '01229' => 'MA',
        '01230' => 'MA',
        '01235' => 'MA',
        '01236' => 'MA',
        '01237' => 'MA',
        '01238' => 'MA',
        '01240' => 'MA',
        '01242' => 'MA',
        '01243' => 'MA',
        '01244' => 'MA',
        '01245' => 'MA',
        '01247' => 'MA',
        '01253' => 'MA',
        '01254' => 'MA',
        '01255' => 'MA',
        '01256' => 'MA',
        '01257' => 'MA',
        '01258' => 'MA',
        '01259' => 'MA',
        '01260' => 'MA',
        '01262' => 'MA',
        '01264' => 'MA',
        '01266' => 'MA',
        '01267' => 'MA',
        '01270' => 'MA',
        '01301' => 'MA',
        '01330' => 'MA',
        '01331' => 'MA',
        '01337' => 'MA',
        '01338' => 'MA',
        '01339' => 'MA',
        '01340' => 'MA',
        '01341' => 'MA',
        '01342' => 'MA',
        '01343' => 'MA',
        '01344' => 'MA',
        '01346' => 'MA',
        '01347' => 'MA',
        '01349' => 'MA',
        '01350' => 'MA',
        '01351' => 'MA',
        '01354' => 'MA',
        '01355' => 'MA',
        '01360' => 'MA',
        '01364' => 'MA',
        '01366' => 'MA',
        '01367' => 'MA',
        '01368' => 'MA',
        '01370' => 'MA',
        '01373' => 'MA',
        '01375' => 'MA',
        '01376' => 'MA',
        '01378' => 'MA',
        '01379' => 'MA',
        '01380' => 'MA',
        '01420' => 'MA',
        '01430' => 'MA',
        '01431' => 'MA',
        '01432' => 'MA',
        '01434' => 'MA',
        '01436' => 'MA',
        '01438' => 'MA',
        '01440' => 'MA',
        '01450' => 'MA',
        '01451' => 'MA',
        '01452' => 'MA',
        '01453' => 'MA',
        '01460' => 'MA',
        '01462' => 'MA',
        '01463' => 'MA',
        '01464' => 'MA',
        '01468' => 'MA',
        '01469' => 'MA',
        '01473' => 'MA',
        '01474' => 'MA',
        '01475' => 'MA',
        '01501' => 'MA',
        '01503' => 'MA',
        '01504' => 'MA',
        '01505' => 'MA',
        '01506' => 'MA',
        '01507' => 'MA',
        '01510' => 'MA',
        '01515' => 'MA',
        '01516' => 'MA',
        '01518' => 'MA',
        '01519' => 'MA',
        '01520' => 'MA',
        '01521' => 'MA',
        '01522' => 'MA',
        '01523' => 'MA',
        '01524' => 'MA',
        '01525' => 'MA',
        '01527' => 'MA',
        '01529' => 'MA',
        '01531' => 'MA',
        '01532' => 'MA',
        '01534' => 'MA',
        '01535' => 'MA',
        '01536' => 'MA',
        '01537' => 'MA',
        '01540' => 'MA',
        '01541' => 'MA',
        '01542' => 'MA',
        '01543' => 'MA',
        '01545' => 'MA',
        '01550' => 'MA',
        '01560' => 'MA',
        '01561' => 'MA',
        '01562' => 'MA',
        '01564' => 'MA',
        '01566' => 'MA',
        '01568' => 'MA',
        '01569' => 'MA',
        '01570' => 'MA',
        '01571' => 'MA',
        '01581' => 'MA',
        '01583' => 'MA',
        '01585' => 'MA',
        '01588' => 'MA',
        '01590' => 'MA',
        '01602' => 'MA',
        '01603' => 'MA',
        '01604' => 'MA',
        '01605' => 'MA',
        '01606' => 'MA',
        '01607' => 'MA',
        '01608' => 'MA',
        '01609' => 'MA',
        '01610' => 'MA',
        '01611' => 'MA',
        '01612' => 'MA',
        '01701' => 'MA',
        '01702' => 'MA',
        '01718' => 'MA',
        '01719' => 'MA',
        '01720' => 'MA',
        '01721' => 'MA',
        '01730' => 'MA',
        '01731' => 'MA',
        '01740' => 'MA',
        '01741' => 'MA',
        '01742' => 'MA',
        '01745' => 'MA',
        '01746' => 'MA',
        '01747' => 'MA',
        '01748' => 'MA',
        '01749' => 'MA',
        '01752' => 'MA',
        '01754' => 'MA',
        '01756' => 'MA',
        '01757' => 'MA',
        '01760' => 'MA',
        '01770' => 'MA',
        '01772' => 'MA',
        '01773' => 'MA',
        '01775' => 'MA',
        '01776' => 'MA',
        '01778' => 'MA',
        '01801' => 'MA',
        '01803' => 'MA',
        '01810' => 'MA',
        '01821' => 'MA',
        '01824' => 'MA',
        '01826' => 'MA',
        '01827' => 'MA',
        '01830' => 'MA',
        '01832' => 'MA',
        '01833' => 'MA',
        '01834' => 'MA',
        '01835' => 'MA',
        '01840' => 'MA',
        '01841' => 'MA',
        '01843' => 'MA',
        '01844' => 'MA',
        '01845' => 'MA',
        '01850' => 'MA',
        '01851' => 'MA',
        '01852' => 'MA',
        '01854' => 'MA',
        '01860' => 'MA',
        '01862' => 'MA',
        '01863' => 'MA',
        '01864' => 'MA',
        '01867' => 'MA',
        '01876' => 'MA',
        '01879' => 'MA',
        '01880' => 'MA',
        '01886' => 'MA',
        '01887' => 'MA',
        '01890' => 'MA',
        '01901' => 'MA',
        '01902' => 'MA',
        '01904' => 'MA',
        '01905' => 'MA',
        '01906' => 'MA',
        '01907' => 'MA',
        '01908' => 'MA',
        '01913' => 'MA',
        '01915' => 'MA',
        '01921' => 'MA',
        '01922' => 'MA',
        '01923' => 'MA',
        '01929' => 'MA',
        '01930' => 'MA',
        '01937' => 'MA',
        '01938' => 'MA',
        '01940' => 'MA',
        '01944' => 'MA',
        '01945' => 'MA',
        '01949' => 'MA',
        '01950' => 'MA',
        '01951' => 'MA',
        '01952' => 'MA',
        '01960' => 'MA',
        '01965' => 'MA',
        '01966' => 'MA',
        '01969' => 'MA',
        '01970' => 'MA',
        '01982' => 'MA',
        '01983' => 'MA',
        '01984' => 'MA',
        '01985' => 'MA',
        '02019' => 'MA',
        '02021' => 'MA',
        '02025' => 'MA',
        '02026' => 'MA',
        '02030' => 'MA',
        '02032' => 'MA',
        '02035' => 'MA',
        '02038' => 'MA',
        '02043' => 'MA',
        '02045' => 'MA',
        '02047' => 'MA',
        '02048' => 'MA',
        '02050' => 'MA',
        '02052' => 'MA',
        '02053' => 'MA',
        '02054' => 'MA',
        '02056' => 'MA',
        '02061' => 'MA',
        '02062' => 'MA',
        '02066' => 'MA',
        '02067' => 'MA',
        '02071' => 'MA',
        '02072' => 'MA',
        '02081' => 'MA',
        '02090' => 'MA',
        '02093' => 'MA',
        '02108' => 'MA',
        '02109' => 'MA',
        '02110' => 'MA',
        '02111' => 'MA',
        '02113' => 'MA',
        '02114' => 'MA',
        '02115' => 'MA',
        '02116' => 'MA',
        '02118' => 'MA',
        '02119' => 'MA',
        '02120' => 'MA',
        '02121' => 'MA',
        '02122' => 'MA',
        '02124' => 'MA',
        '02125' => 'MA',
        '02126' => 'MA',
        '02127' => 'MA',
        '02128' => 'MA',
        '02129' => 'MA',
        '02130' => 'MA',
        '02131' => 'MA',
        '02132' => 'MA',
        '02133' => 'MA',
        '02134' => 'MA',
        '02135' => 'MA',
        '02136' => 'MA',
        '02138' => 'MA',
        '02139' => 'MA',
        '02140' => 'MA',
        '02141' => 'MA',
        '02142' => 'MA',
        '02143' => 'MA',
        '02144' => 'MA',
        '02145' => 'MA',
        '02148' => 'MA',
        '02149' => 'MA',
        '02150' => 'MA',
        '02151' => 'MA',
        '02152' => 'MA',
        '02155' => 'MA',
        '02163' => 'MA',
        '02169' => 'MA',
        '02170' => 'MA',
        '02171' => 'MA',
        '02176' => 'MA',
        '02180' => 'MA',
        '02184' => 'MA',
        '02186' => 'MA',
        '02188' => 'MA',
        '02189' => 'MA',
        '02190' => 'MA',
        '02191' => 'MA',
        '02199' => 'MA',
        '02203' => 'MA',
        '02205' => 'MA',
        '02210' => 'MA',
        '02215' => 'MA',
        '02301' => 'MA',
        '02302' => 'MA',
        '02322' => 'MA',
        '02324' => 'MA',
        '02325' => 'MA',
        '02330' => 'MA',
        '02332' => 'MA',
        '02333' => 'MA',
        '02338' => 'MA',
        '02339' => 'MA',
        '02341' => 'MA',
        '02343' => 'MA',
        '02346' => 'MA',
        '02347' => 'MA',
        '02350' => 'MA',
        '02351' => 'MA',
        '02356' => 'MA',
        '02357' => 'MA',
        '02359' => 'MA',
        '02360' => 'MA',
        '02364' => 'MA',
        '02366' => 'MA',
        '02367' => 'MA',
        '02368' => 'MA',
        '02370' => 'MA',
        '02375' => 'MA',
        '02379' => 'MA',
        '02382' => 'MA',
        '02420' => 'MA',
        '02421' => 'MA',
        '02445' => 'MA',
        '02446' => 'MA',
        '02451' => 'MA',
        '02452' => 'MA',
        '02453' => 'MA',
        '02457' => 'MA',
        '02458' => 'MA',
        '02459' => 'MA',
        '02460' => 'MA',
        '02461' => 'MA',
        '02462' => 'MA',
        '02464' => 'MA',
        '02465' => 'MA',
        '02466' => 'MA',
        '02467' => 'MA',
        '02468' => 'MA',
        '02472' => 'MA',
        '02474' => 'MA',
        '02476' => 'MA',
        '02478' => 'MA',
        '02481' => 'MA',
        '02482' => 'MA',
        '02492' => 'MA',
        '02493' => 'MA',
        '02494' => 'MA',
        '02532' => 'MA',
        '02534' => 'MA',
        '02535' => 'MA',
        '02536' => 'MA',
        '02537' => 'MA',
        '02538' => 'MA',
        '02539' => 'MA',
        '02540' => 'MA',
        '02542' => 'MA',
        '02543' => 'MA',
        '02553' => 'MA',
        '02554' => 'MA',
        '02556' => 'MA',
        '02557' => 'MA',
        '02558' => 'MA',
        '02559' => 'MA',
        '02561' => 'MA',
        '02562' => 'MA',
        '02563' => 'MA',
        '02564' => 'MA',
        '02568' => 'MA',
        '02571' => 'MA',
        '02575' => 'MA',
        '02576' => 'MA',
        '02584' => 'MA',
        '02601' => 'MA',
        '02630' => 'MA',
        '02631' => 'MA',
        '02632' => 'MA',
        '02633' => 'MA',
        '02635' => 'MA',
        '02637' => 'MA',
        '02638' => 'MA',
        '02639' => 'MA',
        '02641' => 'MA',
        '02642' => 'MA',
        '02643' => 'MA',
        '02644' => 'MA',
        '02645' => 'MA',
        '02646' => 'MA',
        '02647' => 'MA',
        '02648' => 'MA',
        '02649' => 'MA',
        '02650' => 'MA',
        '02652' => 'MA',
        '02653' => 'MA',
        '02655' => 'MA',
        '02657' => 'MA',
        '02659' => 'MA',
        '02660' => 'MA',
        '02663' => 'MA',
        '02664' => 'MA',
        '02666' => 'MA',
        '02667' => 'MA',
        '02668' => 'MA',
        '02670' => 'MA',
        '02671' => 'MA',
        '02672' => 'MA',
        '02673' => 'MA',
        '02675' => 'MA',
        '02702' => 'MA',
        '02703' => 'MA',
        '02713' => 'MA',
        '02715' => 'MA',
        '02717' => 'MA',
        '02718' => 'MA',
        '02719' => 'MA',
        '02720' => 'MA',
        '02721' => 'MA',
        '02723' => 'MA',
        '02724' => 'MA',
        '02725' => 'MA',
        '02726' => 'MA',
        '02738' => 'MA',
        '02739' => 'MA',
        '02740' => 'MA',
        '02743' => 'MA',
        '02744' => 'MA',
        '02745' => 'MA',
        '02746' => 'MA',
        '02747' => 'MA',
        '02748' => 'MA',
        '02760' => 'MA',
        '02762' => 'MA',
        '02763' => 'MA',
        '02764' => 'MA',
        '02766' => 'MA',
        '02767' => 'MA',
        '02769' => 'MA',
        '02770' => 'MA',
        '02771' => 'MA',
        '02777' => 'MA',
        '02779' => 'MA',
        '02780' => 'MA',
        '02790' => 'MA',
        '02791' => 'MA',
        '02802' => 'RI',
        '02804' => 'RI',
        '02806' => 'RI',
        '02807' => 'RI',
        '02808' => 'RI',
        '02809' => 'RI',
        '02812' => 'RI',
        '02813' => 'RI',
        '02814' => 'RI',
        '02815' => 'RI',
        '02816' => 'RI',
        '02817' => 'RI',
        '02818' => 'RI',
        '02822' => 'RI',
        '02823' => 'RI',
        '02824' => 'RI',
        '02825' => 'RI',
        '02826' => 'RI',
        '02827' => 'RI',
        '02828' => 'RI',
        '02829' => 'RI',
        '02830' => 'RI',
        '02831' => 'RI',
        '02832' => 'RI',
        '02833' => 'RI',
        '02835' => 'RI',
        '02836' => 'RI',
        '02837' => 'RI',
        '02838' => 'RI',
        '02839' => 'RI',
        '02840' => 'RI',
        '02841' => 'RI',
        '02842' => 'RI',
        '02852' => 'RI',
        '02857' => 'RI',
        '02858' => 'RI',
        '02859' => 'RI',
        '02860' => 'RI',
        '02861' => 'RI',
        '02863' => 'RI',
        '02864' => 'RI',
        '02865' => 'RI',
        '02871' => 'RI',
        '02872' => 'RI',
        '02873' => 'RI',
        '02874' => 'RI',
        '02875' => 'RI',
        '02876' => 'RI',
        '02878' => 'RI',
        '02879' => 'RI',
        '02881' => 'RI',
        '02882' => 'RI',
        '02885' => 'RI',
        '02886' => 'RI',
        '02888' => 'RI',
        '02889' => 'RI',
        '02891' => 'RI',
        '02892' => 'RI',
        '02893' => 'RI',
        '02894' => 'RI',
        '02895' => 'RI',
        '02896' => 'RI',
        '02898' => 'RI',
        '02903' => 'RI',
        '02904' => 'RI',
        '02905' => 'RI',
        '02906' => 'RI',
        '02907' => 'RI',
        '02908' => 'RI',
        '02909' => 'RI',
        '02910' => 'RI',
        '02911' => 'RI',
        '02912' => 'RI',
        '02914' => 'RI',
        '02915' => 'RI',
        '02916' => 'RI',
        '02917' => 'RI',
        '02918' => 'RI',
        '02919' => 'RI',
        '02920' => 'RI',
        '02921' => 'RI',
        '03031' => 'NH',
        '03032' => 'NH',
        '03033' => 'NH',
        '03034' => 'NH',
        '03036' => 'NH',
        '03037' => 'NH',
        '03038' => 'NH',
        '03042' => 'NH',
        '03043' => 'NH',
        '03044' => 'NH',
        '03045' => 'NH',
        '03046' => 'NH',
        '03047' => 'NH',
        '03048' => 'NH',
        '03049' => 'NH',
        '03051' => 'NH',
        '03052' => 'NH',
        '03053' => 'NH',
        '03054' => 'NH',
        '03055' => 'NH',
        '03057' => 'NH',
        '03060' => 'NH',
        '03062' => 'NH',
        '03063' => 'NH',
        '03064' => 'NH',
        '03070' => 'NH',
        '03071' => 'NH',
        '03076' => 'NH',
        '03077' => 'NH',
        '03079' => 'NH',
        '03082' => 'NH',
        '03084' => 'NH',
        '03086' => 'NH',
        '03087' => 'NH',
        '03101' => 'NH',
        '03102' => 'NH',
        '03103' => 'NH',
        '03104' => 'NH',
        '03106' => 'NH',
        '03109' => 'NH',
        '03110' => 'NH',
        '03215' => 'NH',
        '03216' => 'NH',
        '03217' => 'NH',
        '03218' => 'NH',
        '03220' => 'NH',
        '03221' => 'NH',
        '03222' => 'NH',
        '03223' => 'NH',
        '03224' => 'NH',
        '03225' => 'NH',
        '03226' => 'NH',
        '03227' => 'NH',
        '03229' => 'NH',
        '03230' => 'NH',
        '03231' => 'NH',
        '03233' => 'NH',
        '03234' => 'NH',
        '03235' => 'NH',
        '03237' => 'NH',
        '03238' => 'NH',
        '03240' => 'NH',
        '03241' => 'NH',
        '03242' => 'NH',
        '03243' => 'NH',
        '03244' => 'NH',
        '03245' => 'NH',
        '03246' => 'NH',
        '03249' => 'NH',
        '03251' => 'NH',
        '03253' => 'NH',
        '03254' => 'NH',
        '03255' => 'NH',
        '03256' => 'NH',
        '03257' => 'NH',
        '03258' => 'NH',
        '03259' => 'NH',
        '03260' => 'NH',
        '03261' => 'NH',
        '03262' => 'NH',
        '03263' => 'NH',
        '03264' => 'NH',
        '03266' => 'NH',
        '03268' => 'NH',
        '03269' => 'NH',
        '03273' => 'NH',
        '03275' => 'NH',
        '03276' => 'NH',
        '03278' => 'NH',
        '03279' => 'NH',
        '03280' => 'NH',
        '03281' => 'NH',
        '03282' => 'NH',
        '03284' => 'NH',
        '03285' => 'NH',
        '03287' => 'NH',
        '03290' => 'NH',
        '03291' => 'NH',
        '03293' => 'NH',
        '03301' => 'NH',
        '03303' => 'NH',
        '03304' => 'NH',
        '03307' => 'NH',
        '03431' => 'NH',
        '03440' => 'NH',
        '03441' => 'NH',
        '03442' => 'NH',
        '03443' => 'NH',
        '03444' => 'NH',
        '03445' => 'NH',
        '03446' => 'NH',
        '03447' => 'NH',
        '03448' => 'NH',
        '03449' => 'NH',
        '03450' => 'NH',
        '03451' => 'NH',
        '03452' => 'NH',
        '03455' => 'NH',
        '03456' => 'NH',
        '03457' => 'NH',
        '03458' => 'NH',
        '03461' => 'NH',
        '03462' => 'NH',
        '03464' => 'NH',
        '03465' => 'NH',
        '03466' => 'NH',
        '03467' => 'NH',
        '03470' => 'NH',
        '03561' => 'NH',
        '03570' => 'NH',
        '03574' => 'NH',
        '03575' => 'NH',
        '03576' => 'NH',
        '03579' => 'NH',
        '03580' => 'NH',
        '03581' => 'NH',
        '03582' => 'NH',
        '03583' => 'NH',
        '03584' => 'NH',
        '03585' => 'NH',
        '03586' => 'NH',
        '03588' => 'NH',
        '03590' => 'NH',
        '03592' => 'NH',
        '03593' => 'NH',
        '03595' => 'NH',
        '03597' => 'NH',
        '03598' => 'NH',
        '03601' => 'NH',
        '03602' => 'NH',
        '03603' => 'NH',
        '03604' => 'NH',
        '03605' => 'NH',
        '03607' => 'NH',
        '03608' => 'NH',
        '03609' => 'NH',
        '03740' => 'NH',
        '03741' => 'NH',
        '03743' => 'NH',
        '03745' => 'NH',
        '03748' => 'NH',
        '03750' => 'NH',
        '03751' => 'NH',
        '03752' => 'NH',
        '03753' => 'NH',
        '03755' => 'NH',
        '03765' => 'NH',
        '03766' => 'NH',
        '03768' => 'NH',
        '03770' => 'NH',
        '03771' => 'NH',
        '03773' => 'NH',
        '03774' => 'NH',
        '03777' => 'NH',
        '03779' => 'NH',
        '03780' => 'NH',
        '03781' => 'NH',
        '03782' => 'NH',
        '03784' => 'NH',
        '03785' => 'NH',
        '03801' => 'NH',
        '03809' => 'NH',
        '03810' => 'NH',
        '03811' => 'NH',
        '03812' => 'NH',
        '03813' => 'NH',
        '03814' => 'NH',
        '03816' => 'NH',
        '03817' => 'NH',
        '03818' => 'NH',
        '03819' => 'NH',
        '03820' => 'NH',
        '03823' => 'NH',
        '03824' => 'NH',
        '03825' => 'NH',
        '03826' => 'NH',
        '03827' => 'NH',
        '03830' => 'NH',
        '03832' => 'NH',
        '03833' => 'NH',
        '03835' => 'NH',
        '03836' => 'NH',
        '03837' => 'NH',
        '03838' => 'NH',
        '03839' => 'NH',
        '03840' => 'NH',
        '03841' => 'NH',
        '03842' => 'NH',
        '03844' => 'NH',
        '03845' => 'NH',
        '03846' => 'NH',
        '03847' => 'NH',
        '03848' => 'NH',
        '03849' => 'NH',
        '03850' => 'NH',
        '03851' => 'NH',
        '03852' => 'NH',
        '03853' => 'NH',
        '03854' => 'NH',
        '03855' => 'NH',
        '03856' => 'NH',
        '03857' => 'NH',
        '03858' => 'NH',
        '03860' => 'NH',
        '03861' => 'NH',
        '03862' => 'NH',
        '03864' => 'NH',
        '03865' => 'NH',
        '03867' => 'NH',
        '03868' => 'NH',
        '03869' => 'NH',
        '03870' => 'NH',
        '03871' => 'NH',
        '03872' => 'NH',
        '03873' => 'NH',
        '03874' => 'NH',
        '03875' => 'NH',
        '03878' => 'NH',
        '03882' => 'NH',
        '03883' => 'NH',
        '03884' => 'NH',
        '03885' => 'NH',
        '03886' => 'NH',
        '03887' => 'NH',
        '03890' => 'NH',
        '03894' => 'NH',
        '03897' => 'NH',
        '03901' => 'ME',
        '03902' => 'ME',
        '03903' => 'ME',
        '03904' => 'ME',
        '03905' => 'ME',
        '03906' => 'ME',
        '03907' => 'ME',
        '03908' => 'ME',
        '03909' => 'ME',
        '03910' => 'ME',
        '03911' => 'ME',
        '04001' => 'ME',
        '04002' => 'ME',
        '04003' => 'ME',
        '04005' => 'ME',
        '04006' => 'ME',
        '04008' => 'ME',
        '04009' => 'ME',
        '04010' => 'ME',
        '04011' => 'ME',
        '04015' => 'ME',
        '04017' => 'ME',
        '04019' => 'ME',
        '04020' => 'ME',
        '04021' => 'ME',
        '04022' => 'ME',
        '04024' => 'ME',
        '04027' => 'ME',
        '04029' => 'ME',
        '04030' => 'ME',
        '04032' => 'ME',
        '04037' => 'ME',
        '04038' => 'ME',
        '04039' => 'ME',
        '04040' => 'ME',
        '04041' => 'ME',
        '04042' => 'ME',
        '04043' => 'ME',
        '04046' => 'ME',
        '04047' => 'ME',
        '04048' => 'ME',
        '04049' => 'ME',
        '04050' => 'ME',
        '04051' => 'ME',
        '04055' => 'ME',
        '04056' => 'ME',
        '04057' => 'ME',
        '04061' => 'ME',
        '04062' => 'ME',
        '04063' => 'ME',
        '04064' => 'ME',
        '04066' => 'ME',
        '04068' => 'ME',
        '04069' => 'ME',
        '04071' => 'ME',
        '04072' => 'ME',
        '04073' => 'ME',
        '04074' => 'ME',
        '04076' => 'ME',
        '04079' => 'ME',
        '04083' => 'ME',
        '04084' => 'ME',
        '04085' => 'ME',
        '04086' => 'ME',
        '04087' => 'ME',
        '04088' => 'ME',
        '04090' => 'ME',
        '04091' => 'ME',
        '04092' => 'ME',
        '04093' => 'ME',
        '04095' => 'ME',
        '04096' => 'ME',
        '04097' => 'ME',
        '04101' => 'ME',
        '04102' => 'ME',
        '04103' => 'ME',
        '04105' => 'ME',
        '04106' => 'ME',
        '04107' => 'ME',
        '04108' => 'ME',
        '04109' => 'ME',
        '04110' => 'ME',
        '04210' => 'ME',
        '04216' => 'ME',
        '04217' => 'ME',
        '04219' => 'ME',
        '04220' => 'ME',
        '04221' => 'ME',
        '04222' => 'ME',
        '04224' => 'ME',
        '04226' => 'ME',
        '04227' => 'ME',
        '04231' => 'ME',
        '04234' => 'ME',
        '04236' => 'ME',
        '04237' => 'ME',
        '04238' => 'ME',
        '04239' => 'ME',
        '04240' => 'ME',
        '04250' => 'ME',
        '04252' => 'ME',
        '04253' => 'ME',
        '04254' => 'ME',
        '04255' => 'ME',
        '04256' => 'ME',
        '04257' => 'ME',
        '04258' => 'ME',
        '04259' => 'ME',
        '04260' => 'ME',
        '04261' => 'ME',
        '04263' => 'ME',
        '04265' => 'ME',
        '04267' => 'ME',
        '04268' => 'ME',
        '04270' => 'ME',
        '04271' => 'ME',
        '04274' => 'ME',
        '04275' => 'ME',
        '04276' => 'ME',
        '04280' => 'ME',
        '04281' => 'ME',
        '04282' => 'ME',
        '04284' => 'ME',
        '04285' => 'ME',
        '04286' => 'ME',
        '04287' => 'ME',
        '04289' => 'ME',
        '04290' => 'ME',
        '04292' => 'ME',
        '04294' => 'ME',
        '04330' => 'ME',
        '04341' => 'ME',
        '04342' => 'ME',
        '04344' => 'ME',
        '04345' => 'ME',
        '04346' => 'ME',
        '04347' => 'ME',
        '04348' => 'ME',
        '04349' => 'ME',
        '04350' => 'ME',
        '04351' => 'ME',
        '04352' => 'ME',
        '04353' => 'ME',
        '04354' => 'ME',
        '04355' => 'ME',
        '04357' => 'ME',
        '04358' => 'ME',
        '04359' => 'ME',
        '04360' => 'ME',
        '04363' => 'ME',
        '04364' => 'ME',
        '04401' => 'ME',
        '04406' => 'ME',
        '04408' => 'ME',
        '04410' => 'ME',
        '04411' => 'ME',
        '04412' => 'ME',
        '04413' => 'ME',
        '04414' => 'ME',
        '04415' => 'ME',
        '04416' => 'ME',
        '04417' => 'ME',
        '04418' => 'ME',
        '04419' => 'ME',
        '04421' => 'ME',
        '04422' => 'ME',
        '04424' => 'ME',
        '04426' => 'ME',
        '04427' => 'ME',
        '04428' => 'ME',
        '04429' => 'ME',
        '04430' => 'ME',
        '04431' => 'ME',
        '04434' => 'ME',
        '04435' => 'ME',
        '04438' => 'ME',
        '04441' => 'ME',
        '04442' => 'ME',
        '04443' => 'ME',
        '04444' => 'ME',
        '04448' => 'ME',
        '04449' => 'ME',
        '04450' => 'ME',
        '04451' => 'ME',
        '04453' => 'ME',
        '04454' => 'ME',
        '04455' => 'ME',
        '04456' => 'ME',
        '04457' => 'ME',
        '04459' => 'ME',
        '04460' => 'ME',
        '04461' => 'ME',
        '04462' => 'ME',
        '04463' => 'ME',
        '04464' => 'ME',
        '04468' => 'ME',
        '04469' => 'ME',
        '04471' => 'ME',
        '04472' => 'ME',
        '04473' => 'ME',
        '04474' => 'ME',
        '04475' => 'ME',
        '04476' => 'ME',
        '04478' => 'ME',
        '04479' => 'ME',
        '04481' => 'ME',
        '04485' => 'ME',
        '04487' => 'ME',
        '04488' => 'ME',
        '04489' => 'ME',
        '04490' => 'ME',
        '04491' => 'ME',
        '04492' => 'ME',
        '04493' => 'ME',
        '04495' => 'ME',
        '04496' => 'ME',
        '04497' => 'ME',
        '04530' => 'ME',
        '04535' => 'ME',
        '04537' => 'ME',
        '04538' => 'ME',
        '04539' => 'ME',
        '04541' => 'ME',
        '04543' => 'ME',
        '04544' => 'ME',
        '04547' => 'ME',
        '04548' => 'ME',
        '04551' => 'ME',
        '04553' => 'ME',
        '04554' => 'ME',
        '04555' => 'ME',
        '04556' => 'ME',
        '04558' => 'ME',
        '04562' => 'ME',
        '04563' => 'ME',
        '04564' => 'ME',
        '04568' => 'ME',
        '04570' => 'ME',
        '04571' => 'ME',
        '04572' => 'ME',
        '04573' => 'ME',
        '04574' => 'ME',
        '04575' => 'ME',
        '04576' => 'ME',
        '04578' => 'ME',
        '04579' => 'ME',
        '04605' => 'ME',
        '04606' => 'ME',
        '04607' => 'ME',
        '04609' => 'ME',
        '04611' => 'ME',
        '04612' => 'ME',
        '04613' => 'ME',
        '04614' => 'ME',
        '04616' => 'ME',
        '04617' => 'ME',
        '04619' => 'ME',
        '04622' => 'ME',
        '04623' => 'ME',
        '04624' => 'ME',
        '04625' => 'ME',
        '04626' => 'ME',
        '04627' => 'ME',
        '04628' => 'ME',
        '04630' => 'ME',
        '04631' => 'ME',
        '04634' => 'ME',
        '04635' => 'ME',
        '04640' => 'ME',
        '04642' => 'ME',
        '04643' => 'ME',
        '04645' => 'ME',
        '04646' => 'ME',
        '04648' => 'ME',
        '04649' => 'ME',
        '04650' => 'ME',
        '04652' => 'ME',
        '04653' => 'ME',
        '04654' => 'ME',
        '04655' => 'ME',
        '04657' => 'ME',
        '04658' => 'ME',
        '04660' => 'ME',
        '04662' => 'ME',
        '04664' => 'ME',
        '04666' => 'ME',
        '04667' => 'ME',
        '04668' => 'ME',
        '04669' => 'ME',
        '04671' => 'ME',
        '04673' => 'ME',
        '04674' => 'ME',
        '04675' => 'ME',
        '04676' => 'ME',
        '04677' => 'ME',
        '04679' => 'ME',
        '04680' => 'ME',
        '04681' => 'ME',
        '04683' => 'ME',
        '04684' => 'ME',
        '04685' => 'ME',
        '04686' => 'ME',
        '04691' => 'ME',
        '04693' => 'ME',
        '04694' => 'ME',
        '04730' => 'ME',
        '04732' => 'ME',
        '04733' => 'ME',
        '04734' => 'ME',
        '04735' => 'ME',
        '04736' => 'ME',
        '04737' => 'ME',
        '04739' => 'ME',
        '04740' => 'ME',
        '04742' => 'ME',
        '04743' => 'ME',
        '04745' => 'ME',
        '04746' => 'ME',
        '04747' => 'ME',
        '04750' => 'ME',
        '04756' => 'ME',
        '04757' => 'ME',
        '04758' => 'ME',
        '04760' => 'ME',
        '04761' => 'ME',
        '04762' => 'ME',
        '04763' => 'ME',
        '04764' => 'ME',
        '04765' => 'ME',
        '04766' => 'ME',
        '04768' => 'ME',
        '04769' => 'ME',
        '04772' => 'ME',
        '04773' => 'ME',
        '04774' => 'ME',
        '04776' => 'ME',
        '04777' => 'ME',
        '04779' => 'ME',
        '04780' => 'ME',
        '04781' => 'ME',
        '04783' => 'ME',
        '04785' => 'ME',
        '04786' => 'ME',
        '04787' => 'ME',
        '04841' => 'ME',
        '04843' => 'ME',
        '04847' => 'ME',
        '04848' => 'ME',
        '04849' => 'ME',
        '04851' => 'ME',
        '04852' => 'ME',
        '04853' => 'ME',
        '04854' => 'ME',
        '04855' => 'ME',
        '04856' => 'ME',
        '04858' => 'ME',
        '04859' => 'ME',
        '04860' => 'ME',
        '04861' => 'ME',
        '04862' => 'ME',
        '04863' => 'ME',
        '04864' => 'ME',
        '04901' => 'ME',
        '04910' => 'ME',
        '04911' => 'ME',
        '04912' => 'ME',
        '04915' => 'ME',
        '04917' => 'ME',
        '04918' => 'ME',
        '04920' => 'ME',
        '04921' => 'ME',
        '04922' => 'ME',
        '04923' => 'ME',
        '04924' => 'ME',
        '04925' => 'ME',
        '04926' => 'ME',
        '04927' => 'ME',
        '04928' => 'ME',
        '04929' => 'ME',
        '04930' => 'ME',
        '04932' => 'ME',
        '04936' => 'ME',
        '04937' => 'ME',
        '04938' => 'ME',
        '04939' => 'ME',
        '04940' => 'ME',
        '04941' => 'ME',
        '04942' => 'ME',
        '04943' => 'ME',
        '04944' => 'ME',
        '04945' => 'ME',
        '04947' => 'ME',
        '04949' => 'ME',
        '04950' => 'ME',
        '04951' => 'ME',
        '04952' => 'ME',
        '04953' => 'ME',
        '04955' => 'ME',
        '04956' => 'ME',
        '04957' => 'ME',
        '04958' => 'ME',
        '04961' => 'ME',
        '04963' => 'ME',
        '04964' => 'ME',
        '04965' => 'ME',
        '04966' => 'ME',
        '04967' => 'ME',
        '04969' => 'ME',
        '04970' => 'ME',
        '04971' => 'ME',
        '04973' => 'ME',
        '04974' => 'ME',
        '04975' => 'ME',
        '04976' => 'ME',
        '04978' => 'ME',
        '04979' => 'ME',
        '04981' => 'ME',
        '04982' => 'ME',
        '04983' => 'ME',
        '04984' => 'ME',
        '04985' => 'ME',
        '04986' => 'ME',
        '04987' => 'ME',
        '04988' => 'ME',
        '04989' => 'ME',
        '04992' => 'ME',
        '05001' => 'VT',
        '05009' => 'VT',
        '05030' => 'VT',
        '05031' => 'VT',
        '05032' => 'VT',
        '05033' => 'VT',
        '05034' => 'VT',
        '05035' => 'VT',
        '05036' => 'VT',
        '05037' => 'VT',
        '05038' => 'VT',
        '05039' => 'VT',
        '05040' => 'VT',
        '05041' => 'VT',
        '05042' => 'VT',
        '05043' => 'VT',
        '05045' => 'VT',
        '05046' => 'VT',
        '05048' => 'VT',
        '05050' => 'VT',
        '05051' => 'VT',
        '05052' => 'VT',
        '05053' => 'VT',
        '05055' => 'VT',
        '05056' => 'VT',
        '05058' => 'VT',
        '05059' => 'VT',
        '05060' => 'VT',
        '05061' => 'VT',
        '05062' => 'VT',
        '05065' => 'VT',
        '05067' => 'VT',
        '05068' => 'VT',
        '05069' => 'VT',
        '05070' => 'VT',
        '05071' => 'VT',
        '05072' => 'VT',
        '05073' => 'VT',
        '05075' => 'VT',
        '05076' => 'VT',
        '05077' => 'VT',
        '05079' => 'VT',
        '05081' => 'VT',
        '05083' => 'VT',
        '05084' => 'VT',
        '05086' => 'VT',
        '05088' => 'VT',
        '05089' => 'VT',
        '05091' => 'VT',
        '05101' => 'VT',
        '05141' => 'VT',
        '05142' => 'VT',
        '05143' => 'VT',
        '05146' => 'VT',
        '05148' => 'VT',
        '05149' => 'VT',
        '05150' => 'VT',
        '05151' => 'VT',
        '05152' => 'VT',
        '05153' => 'VT',
        '05154' => 'VT',
        '05155' => 'VT',
        '05156' => 'VT',
        '05158' => 'VT',
        '05161' => 'VT',
        '05201' => 'VT',
        '05250' => 'VT',
        '05251' => 'VT',
        '05252' => 'VT',
        '05253' => 'VT',
        '05254' => 'VT',
        '05255' => 'VT',
        '05257' => 'VT',
        '05260' => 'VT',
        '05261' => 'VT',
        '05262' => 'VT',
        '05301' => 'VT',
        '05340' => 'VT',
        '05341' => 'VT',
        '05342' => 'VT',
        '05343' => 'VT',
        '05344' => 'VT',
        '05345' => 'VT',
        '05346' => 'VT',
        '05350' => 'VT',
        '05351' => 'VT',
        '05352' => 'VT',
        '05353' => 'VT',
        '05354' => 'VT',
        '05355' => 'VT',
        '05356' => 'VT',
        '05358' => 'VT',
        '05359' => 'VT',
        '05360' => 'VT',
        '05361' => 'VT',
        '05362' => 'VT',
        '05363' => 'VT',
        '05401' => 'VT',
        '05403' => 'VT',
        '05404' => 'VT',
        '05405' => 'VT',
        '05408' => 'VT',
        '05439' => 'VT',
        '05440' => 'VT',
        '05441' => 'VT',
        '05442' => 'VT',
        '05443' => 'VT',
        '05444' => 'VT',
        '05445' => 'VT',
        '05446' => 'VT',
        '05447' => 'VT',
        '05448' => 'VT',
        '05450' => 'VT',
        '05452' => 'VT',
        '05454' => 'VT',
        '05455' => 'VT',
        '05456' => 'VT',
        '05457' => 'VT',
        '05458' => 'VT',
        '05459' => 'VT',
        '05461' => 'VT',
        '05462' => 'VT',
        '05463' => 'VT',
        '05464' => 'VT',
        '05465' => 'VT',
        '05468' => 'VT',
        '05471' => 'VT',
        '05472' => 'VT',
        '05473' => 'VT',
        '05474' => 'VT',
        '05476' => 'VT',
        '05477' => 'VT',
        '05478' => 'VT',
        '05481' => 'VT',
        '05482' => 'VT',
        '05483' => 'VT',
        '05485' => 'VT',
        '05486' => 'VT',
        '05487' => 'VT',
        '05488' => 'VT',
        '05489' => 'VT',
        '05491' => 'VT',
        '05492' => 'VT',
        '05494' => 'VT',
        '05495' => 'VT',
        '05602' => 'VT',
        '05640' => 'VT',
        '05641' => 'VT',
        '05647' => 'VT',
        '05648' => 'VT',
        '05649' => 'VT',
        '05650' => 'VT',
        '05651' => 'VT',
        '05652' => 'VT',
        '05653' => 'VT',
        '05654' => 'VT',
        '05655' => 'VT',
        '05656' => 'VT',
        '05658' => 'VT',
        '05660' => 'VT',
        '05661' => 'VT',
        '05663' => 'VT',
        '05664' => 'VT',
        '05666' => 'VT',
        '05667' => 'VT',
        '05669' => 'VT',
        '05670' => 'VT',
        '05672' => 'VT',
        '05673' => 'VT',
        '05674' => 'VT',
        '05675' => 'VT',
        '05676' => 'VT',
        '05677' => 'VT',
        '05678' => 'VT',
        '05679' => 'VT',
        '05680' => 'VT',
        '05681' => 'VT',
        '05682' => 'VT',
        '05701' => 'VT',
        '05730' => 'VT',
        '05731' => 'VT',
        '05732' => 'VT',
        '05733' => 'VT',
        '05734' => 'VT',
        '05735' => 'VT',
        '05736' => 'VT',
        '05737' => 'VT',
        '05738' => 'VT',
        '05739' => 'VT',
        '05742' => 'VT',
        '05743' => 'VT',
        '05744' => 'VT',
        '05746' => 'VT',
        '05747' => 'VT',
        '05748' => 'VT',
        '05751' => 'VT',
        '05753' => 'VT',
        '05757' => 'VT',
        '05758' => 'VT',
        '05759' => 'VT',
        '05760' => 'VT',
        '05761' => 'VT',
        '05762' => 'VT',
        '05763' => 'VT',
        '05764' => 'VT',
        '05765' => 'VT',
        '05766' => 'VT',
        '05767' => 'VT',
        '05768' => 'VT',
        '05769' => 'VT',
        '05770' => 'VT',
        '05772' => 'VT',
        '05773' => 'VT',
        '05774' => 'VT',
        '05775' => 'VT',
        '05776' => 'VT',
        '05777' => 'VT',
        '05778' => 'VT',
        '05819' => 'VT',
        '05820' => 'VT',
        '05821' => 'VT',
        '05822' => 'VT',
        '05824' => 'VT',
        '05825' => 'VT',
        '05826' => 'VT',
        '05827' => 'VT',
        '05828' => 'VT',
        '05829' => 'VT',
        '05830' => 'VT',
        '05832' => 'VT',
        '05833' => 'VT',
        '05836' => 'VT',
        '05837' => 'VT',
        '05839' => 'VT',
        '05840' => 'VT',
        '05841' => 'VT',
        '05842' => 'VT',
        '05843' => 'VT',
        '05845' => 'VT',
        '05846' => 'VT',
        '05847' => 'VT',
        '05850' => 'VT',
        '05851' => 'VT',
        '05853' => 'VT',
        '05855' => 'VT',
        '05857' => 'VT',
        '05858' => 'VT',
        '05859' => 'VT',
        '05860' => 'VT',
        '05862' => 'VT',
        '05866' => 'VT',
        '05867' => 'VT',
        '05868' => 'VT',
        '05871' => 'VT',
        '05872' => 'VT',
        '05873' => 'VT',
        '05874' => 'VT',
        '05875' => 'VT',
        '05901' => 'VT',
        '05902' => 'VT',
        '05903' => 'VT',
        '05904' => 'VT',
        '05905' => 'VT',
        '05906' => 'VT',
        '05907' => 'VT',
        '06001' => 'CT',
        '06002' => 'CT',
        '06010' => 'CT',
        '06013' => 'CT',
        '06016' => 'CT',
        '06018' => 'CT',
        '06019' => 'CT',
        '06020' => 'CT',
        '06021' => 'CT',
        '06022' => 'CT',
        '06023' => 'CT',
        '06024' => 'CT',
        '06026' => 'CT',
        '06027' => 'CT',
        '06029' => 'CT',
        '06031' => 'CT',
        '06032' => 'CT',
        '06033' => 'CT',
        '06035' => 'CT',
        '06037' => 'CT',
        '06039' => 'CT',
        '06040' => 'CT',
        '06042' => 'CT',
        '06043' => 'CT',
        '06051' => 'CT',
        '06052' => 'CT',
        '06053' => 'CT',
        '06057' => 'CT',
        '06058' => 'CT',
        '06059' => 'CT',
        '06060' => 'CT',
        '06061' => 'CT',
        '06062' => 'CT',
        '06063' => 'CT',
        '06065' => 'CT',
        '06066' => 'CT',
        '06067' => 'CT',
        '06068' => 'CT',
        '06069' => 'CT',
        '06070' => 'CT',
        '06071' => 'CT',
        '06072' => 'CT',
        '06073' => 'CT',
        '06074' => 'CT',
        '06076' => 'CT',
        '06078' => 'CT',
        '06079' => 'CT',
        '06080' => 'CT',
        '06081' => 'CT',
        '06082' => 'CT',
        '06084' => 'CT',
        '06085' => 'CT',
        '06088' => 'CT',
        '06089' => 'CT',
        '06090' => 'CT',
        '06091' => 'CT',
        '06092' => 'CT',
        '06093' => 'CT',
        '06095' => 'CT',
        '06096' => 'CT',
        '06098' => 'CT',
        '06103' => 'CT',
        '06105' => 'CT',
        '06106' => 'CT',
        '06107' => 'CT',
        '06108' => 'CT',
        '06109' => 'CT',
        '06110' => 'CT',
        '06111' => 'CT',
        '06112' => 'CT',
        '06114' => 'CT',
        '06117' => 'CT',
        '06118' => 'CT',
        '06119' => 'CT',
        '06120' => 'CT',
        '06226' => 'CT',
        '06231' => 'CT',
        '06232' => 'CT',
        '06234' => 'CT',
        '06235' => 'CT',
        '06237' => 'CT',
        '06238' => 'CT',
        '06239' => 'CT',
        '06241' => 'CT',
        '06242' => 'CT',
        '06243' => 'CT',
        '06247' => 'CT',
        '06248' => 'CT',
        '06249' => 'CT',
        '06250' => 'CT',
        '06254' => 'CT',
        '06255' => 'CT',
        '06256' => 'CT',
        '06258' => 'CT',
        '06259' => 'CT',
        '06260' => 'CT',
        '06262' => 'CT',
        '06263' => 'CT',
        '06264' => 'CT',
        '06266' => 'CT',
        '06268' => 'CT',
        '06269' => 'CT',
        '06277' => 'CT',
        '06278' => 'CT',
        '06279' => 'CT',
        '06280' => 'CT',
        '06281' => 'CT',
        '06282' => 'CT',
        '06320' => 'CT',
        '06330' => 'CT',
        '06331' => 'CT',
        '06332' => 'CT',
        '06333' => 'CT',
        '06334' => 'CT',
        '06335' => 'CT',
        '06336' => 'CT',
        '06338' => 'CT',
        '06339' => 'CT',
        '06340' => 'CT',
        '06350' => 'CT',
        '06351' => 'CT',
        '06353' => 'CT',
        '06354' => 'CT',
        '06355' => 'CT',
        '06357' => 'CT',
        '06359' => 'CT',
        '06360' => 'CT',
        '06365' => 'CT',
        '06370' => 'CT',
        '06371' => 'CT',
        '06373' => 'CT',
        '06374' => 'CT',
        '06375' => 'CT',
        '06376' => 'CT',
        '06377' => 'CT',
        '06378' => 'CT',
        '06379' => 'CT',
        '06380' => 'CT',
        '06382' => 'CT',
        '06384' => 'CT',
        '06385' => 'CT',
        '06387' => 'CT',
        '06389' => 'CT',
        '06390' => 'NY',
        '06401' => 'CT',
        '06403' => 'CT',
        '06405' => 'CT',
        '06409' => 'CT',
        '06410' => 'CT',
        '06412' => 'CT',
        '06413' => 'CT',
        '06414' => 'CT',
        '06415' => 'CT',
        '06416' => 'CT',
        '06417' => 'CT',
        '06418' => 'CT',
        '06419' => 'CT',
        '06420' => 'CT',
        '06422' => 'CT',
        '06423' => 'CT',
        '06424' => 'CT',
        '06426' => 'CT',
        '06437' => 'CT',
        '06438' => 'CT',
        '06439' => 'CT',
        '06441' => 'CT',
        '06442' => 'CT',
        '06443' => 'CT',
        '06444' => 'CT',
        '06447' => 'CT',
        '06450' => 'CT',
        '06451' => 'CT',
        '06455' => 'CT',
        '06456' => 'CT',
        '06457' => 'CT',
        '06459' => 'CT',
        '06460' => 'CT',
        '06461' => 'CT',
        '06467' => 'CT',
        '06468' => 'CT',
        '06469' => 'CT',
        '06470' => 'CT',
        '06471' => 'CT',
        '06472' => 'CT',
        '06473' => 'CT',
        '06475' => 'CT',
        '06477' => 'CT',
        '06478' => 'CT',
        '06479' => 'CT',
        '06480' => 'CT',
        '06481' => 'CT',
        '06482' => 'CT',
        '06483' => 'CT',
        '06484' => 'CT',
        '06488' => 'CT',
        '06489' => 'CT',
        '06492' => 'CT',
        '06498' => 'CT',
        '06510' => 'CT',
        '06511' => 'CT',
        '06512' => 'CT',
        '06513' => 'CT',
        '06514' => 'CT',
        '06515' => 'CT',
        '06516' => 'CT',
        '06517' => 'CT',
        '06518' => 'CT',
        '06519' => 'CT',
        '06524' => 'CT',
        '06525' => 'CT',
        '06604' => 'CT',
        '06605' => 'CT',
        '06606' => 'CT',
        '06607' => 'CT',
        '06608' => 'CT',
        '06610' => 'CT',
        '06611' => 'CT',
        '06612' => 'CT',
        '06614' => 'CT',
        '06615' => 'CT',
        '06702' => 'CT',
        '06704' => 'CT',
        '06705' => 'CT',
        '06706' => 'CT',
        '06708' => 'CT',
        '06710' => 'CT',
        '06712' => 'CT',
        '06716' => 'CT',
        '06750' => 'CT',
        '06751' => 'CT',
        '06752' => 'CT',
        '06753' => 'CT',
        '06754' => 'CT',
        '06755' => 'CT',
        '06756' => 'CT',
        '06757' => 'CT',
        '06758' => 'CT',
        '06759' => 'CT',
        '06762' => 'CT',
        '06763' => 'CT',
        '06770' => 'CT',
        '06776' => 'CT',
        '06777' => 'CT',
        '06778' => 'CT',
        '06779' => 'CT',
        '06782' => 'CT',
        '06783' => 'CT',
        '06784' => 'CT',
        '06785' => 'CT',
        '06786' => 'CT',
        '06787' => 'CT',
        '06790' => 'CT',
        '06791' => 'CT',
        '06793' => 'CT',
        '06794' => 'CT',
        '06795' => 'CT',
        '06796' => 'CT',
        '06798' => 'CT',
        '06801' => 'CT',
        '06804' => 'CT',
        '06807' => 'CT',
        '06810' => 'CT',
        '06811' => 'CT',
        '06812' => 'CT',
        '06820' => 'CT',
        '06824' => 'CT',
        '06825' => 'CT',
        '06830' => 'CT',
        '06831' => 'CT',
        '06840' => 'CT',
        '06850' => 'CT',
        '06851' => 'CT',
        '06853' => 'CT',
        '06854' => 'CT',
        '06855' => 'CT',
        '06870' => 'CT',
        '06877' => 'CT',
        '06878' => 'CT',
        '06880' => 'CT',
        '06883' => 'CT',
        '06890' => 'CT',
        '06896' => 'CT',
        '06897' => 'CT',
        '06901' => 'CT',
        '06902' => 'CT',
        '06903' => 'CT',
        '06905' => 'CT',
        '06906' => 'CT',
        '06907' => 'CT',
        '07001' => 'NJ',
        '07002' => 'NJ',
        '07003' => 'NJ',
        '07004' => 'NJ',
        '07005' => 'NJ',
        '07006' => 'NJ',
        '07008' => 'NJ',
        '07009' => 'NJ',
        '07010' => 'NJ',
        '07011' => 'NJ',
        '07012' => 'NJ',
        '07013' => 'NJ',
        '07014' => 'NJ',
        '07016' => 'NJ',
        '07017' => 'NJ',
        '07018' => 'NJ',
        '07020' => 'NJ',
        '07021' => 'NJ',
        '07022' => 'NJ',
        '07023' => 'NJ',
        '07024' => 'NJ',
        '07026' => 'NJ',
        '07027' => 'NJ',
        '07028' => 'NJ',
        '07029' => 'NJ',
        '07030' => 'NJ',
        '07031' => 'NJ',
        '07032' => 'NJ',
        '07033' => 'NJ',
        '07034' => 'NJ',
        '07035' => 'NJ',
        '07036' => 'NJ',
        '07039' => 'NJ',
        '07040' => 'NJ',
        '07041' => 'NJ',
        '07042' => 'NJ',
        '07043' => 'NJ',
        '07044' => 'NJ',
        '07045' => 'NJ',
        '07046' => 'NJ',
        '07047' => 'NJ',
        '07050' => 'NJ',
        '07052' => 'NJ',
        '07054' => 'NJ',
        '07055' => 'NJ',
        '07057' => 'NJ',
        '07058' => 'NJ',
        '07059' => 'NJ',
        '07060' => 'NJ',
        '07062' => 'NJ',
        '07063' => 'NJ',
        '07064' => 'NJ',
        '07065' => 'NJ',
        '07066' => 'NJ',
        '07067' => 'NJ',
        '07068' => 'NJ',
        '07069' => 'NJ',
        '07070' => 'NJ',
        '07071' => 'NJ',
        '07072' => 'NJ',
        '07073' => 'NJ',
        '07074' => 'NJ',
        '07075' => 'NJ',
        '07076' => 'NJ',
        '07077' => 'NJ',
        '07078' => 'NJ',
        '07079' => 'NJ',
        '07080' => 'NJ',
        '07081' => 'NJ',
        '07082' => 'NJ',
        '07083' => 'NJ',
        '07086' => 'NJ',
        '07087' => 'NJ',
        '07088' => 'NJ',
        '07090' => 'NJ',
        '07092' => 'NJ',
        '07093' => 'NJ',
        '07094' => 'NJ',
        '07095' => 'NJ',
        '07102' => 'NJ',
        '07103' => 'NJ',
        '07104' => 'NJ',
        '07105' => 'NJ',
        '07106' => 'NJ',
        '07107' => 'NJ',
        '07108' => 'NJ',
        '07109' => 'NJ',
        '07110' => 'NJ',
        '07111' => 'NJ',
        '07112' => 'NJ',
        '07114' => 'NJ',
        '07201' => 'NJ',
        '07202' => 'NJ',
        '07203' => 'NJ',
        '07204' => 'NJ',
        '07205' => 'NJ',
        '07206' => 'NJ',
        '07208' => 'NJ',
        '07302' => 'NJ',
        '07304' => 'NJ',
        '07305' => 'NJ',
        '07306' => 'NJ',
        '07307' => 'NJ',
        '07310' => 'NJ',
        '07311' => 'NJ',
        '07401' => 'NJ',
        '07403' => 'NJ',
        '07405' => 'NJ',
        '07407' => 'NJ',
        '07410' => 'NJ',
        '07416' => 'NJ',
        '07417' => 'NJ',
        '07418' => 'NJ',
        '07419' => 'NJ',
        '07420' => 'NJ',
        '07421' => 'NJ',
        '07422' => 'NJ',
        '07423' => 'NJ',
        '07424' => 'NJ',
        '07430' => 'NJ',
        '07432' => 'NJ',
        '07435' => 'NJ',
        '07436' => 'NJ',
        '07438' => 'NJ',
        '07439' => 'NJ',
        '07440' => 'NJ',
        '07442' => 'NJ',
        '07444' => 'NJ',
        '07446' => 'NJ',
        '07450' => 'NJ',
        '07452' => 'NJ',
        '07456' => 'NJ',
        '07457' => 'NJ',
        '07458' => 'NJ',
        '07460' => 'NJ',
        '07461' => 'NJ',
        '07462' => 'NJ',
        '07463' => 'NJ',
        '07465' => 'NJ',
        '07470' => 'NJ',
        '07480' => 'NJ',
        '07481' => 'NJ',
        '07501' => 'NJ',
        '07502' => 'NJ',
        '07503' => 'NJ',
        '07504' => 'NJ',
        '07505' => 'NJ',
        '07506' => 'NJ',
        '07508' => 'NJ',
        '07512' => 'NJ',
        '07513' => 'NJ',
        '07514' => 'NJ',
        '07522' => 'NJ',
        '07524' => 'NJ',
        '07601' => 'NJ',
        '07603' => 'NJ',
        '07604' => 'NJ',
        '07605' => 'NJ',
        '07606' => 'NJ',
        '07607' => 'NJ',
        '07608' => 'NJ',
        '07620' => 'NJ',
        '07621' => 'NJ',
        '07624' => 'NJ',
        '07626' => 'NJ',
        '07627' => 'NJ',
        '07628' => 'NJ',
        '07630' => 'NJ',
        '07631' => 'NJ',
        '07632' => 'NJ',
        '07640' => 'NJ',
        '07641' => 'NJ',
        '07642' => 'NJ',
        '07643' => 'NJ',
        '07644' => 'NJ',
        '07645' => 'NJ',
        '07646' => 'NJ',
        '07647' => 'NJ',
        '07648' => 'NJ',
        '07649' => 'NJ',
        '07650' => 'NJ',
        '07652' => 'NJ',
        '07656' => 'NJ',
        '07657' => 'NJ',
        '07660' => 'NJ',
        '07661' => 'NJ',
        '07662' => 'NJ',
        '07663' => 'NJ',
        '07666' => 'NJ',
        '07670' => 'NJ',
        '07675' => 'NJ',
        '07676' => 'NJ',
        '07677' => 'NJ',
        '07701' => 'NJ',
        '07702' => 'NJ',
        '07703' => 'NJ',
        '07704' => 'NJ',
        '07711' => 'NJ',
        '07712' => 'NJ',
        '07716' => 'NJ',
        '07717' => 'NJ',
        '07718' => 'NJ',
        '07719' => 'NJ',
        '07720' => 'NJ',
        '07721' => 'NJ',
        '07722' => 'NJ',
        '07723' => 'NJ',
        '07724' => 'NJ',
        '07726' => 'NJ',
        '07727' => 'NJ',
        '07728' => 'NJ',
        '07730' => 'NJ',
        '07731' => 'NJ',
        '07732' => 'NJ',
        '07733' => 'NJ',
        '07734' => 'NJ',
        '07735' => 'NJ',
        '07737' => 'NJ',
        '07738' => 'NJ',
        '07739' => 'NJ',
        '07740' => 'NJ',
        '07746' => 'NJ',
        '07747' => 'NJ',
        '07748' => 'NJ',
        '07750' => 'NJ',
        '07751' => 'NJ',
        '07753' => 'NJ',
        '07755' => 'NJ',
        '07756' => 'NJ',
        '07757' => 'NJ',
        '07758' => 'NJ',
        '07760' => 'NJ',
        '07762' => 'NJ',
        '07764' => 'NJ',
        '07801' => 'NJ',
        '07803' => 'NJ',
        '07820' => 'NJ',
        '07821' => 'NJ',
        '07822' => 'NJ',
        '07823' => 'NJ',
        '07825' => 'NJ',
        '07826' => 'NJ',
        '07827' => 'NJ',
        '07828' => 'NJ',
        '07830' => 'NJ',
        '07831' => 'NJ',
        '07832' => 'NJ',
        '07833' => 'NJ',
        '07834' => 'NJ',
        '07836' => 'NJ',
        '07838' => 'NJ',
        '07840' => 'NJ',
        '07842' => 'NJ',
        '07843' => 'NJ',
        '07844' => 'NJ',
        '07846' => 'NJ',
        '07847' => 'NJ',
        '07848' => 'NJ',
        '07849' => 'NJ',
        '07850' => 'NJ',
        '07851' => 'NJ',
        '07852' => 'NJ',
        '07853' => 'NJ',
        '07856' => 'NJ',
        '07857' => 'NJ',
        '07860' => 'NJ',
        '07863' => 'NJ',
        '07865' => 'NJ',
        '07866' => 'NJ',
        '07869' => 'NJ',
        '07870' => 'NJ',
        '07871' => 'NJ',
        '07874' => 'NJ',
        '07876' => 'NJ',
        '07878' => 'NJ',
        '07880' => 'NJ',
        '07881' => 'NJ',
        '07882' => 'NJ',
        '07885' => 'NJ',
        '07901' => 'NJ',
        '07920' => 'NJ',
        '07921' => 'NJ',
        '07922' => 'NJ',
        '07924' => 'NJ',
        '07926' => 'NJ',
        '07927' => 'NJ',
        '07928' => 'NJ',
        '07930' => 'NJ',
        '07931' => 'NJ',
        '07932' => 'NJ',
        '07933' => 'NJ',
        '07934' => 'NJ',
        '07935' => 'NJ',
        '07936' => 'NJ',
        '07939' => 'NJ',
        '07940' => 'NJ',
        '07945' => 'NJ',
        '07946' => 'NJ',
        '07950' => 'NJ',
        '07960' => 'NJ',
        '07961' => 'NJ',
        '07970' => 'NJ',
        '07974' => 'NJ',
        '07976' => 'NJ',
        '07977' => 'NJ',
        '07979' => 'NJ',
        '07980' => 'NJ',
        '07981' => 'NJ',
        '08001' => 'NJ',
        '08002' => 'NJ',
        '08003' => 'NJ',
        '08004' => 'NJ',
        '08005' => 'NJ',
        '08006' => 'NJ',
        '08007' => 'NJ',
        '08008' => 'NJ',
        '08009' => 'NJ',
        '08010' => 'NJ',
        '08011' => 'NJ',
        '08012' => 'NJ',
        '08014' => 'NJ',
        '08015' => 'NJ',
        '08016' => 'NJ',
        '08019' => 'NJ',
        '08020' => 'NJ',
        '08021' => 'NJ',
        '08022' => 'NJ',
        '08023' => 'NJ',
        '08026' => 'NJ',
        '08027' => 'NJ',
        '08028' => 'NJ',
        '08029' => 'NJ',
        '08030' => 'NJ',
        '08031' => 'NJ',
        '08032' => 'NJ',
        '08033' => 'NJ',
        '08034' => 'NJ',
        '08035' => 'NJ',
        '08036' => 'NJ',
        '08037' => 'NJ',
        '08038' => 'NJ',
        '08039' => 'NJ',
        '08041' => 'NJ',
        '08042' => 'NJ',
        '08043' => 'NJ',
        '08045' => 'NJ',
        '08046' => 'NJ',
        '08048' => 'NJ',
        '08049' => 'NJ',
        '08050' => 'NJ',
        '08051' => 'NJ',
        '08052' => 'NJ',
        '08053' => 'NJ',
        '08054' => 'NJ',
        '08055' => 'NJ',
        '08056' => 'NJ',
        '08057' => 'NJ',
        '08059' => 'NJ',
        '08060' => 'NJ',
        '08061' => 'NJ',
        '08062' => 'NJ',
        '08063' => 'NJ',
        '08064' => 'NJ',
        '08065' => 'NJ',
        '08066' => 'NJ',
        '08067' => 'NJ',
        '08068' => 'NJ',
        '08069' => 'NJ',
        '08070' => 'NJ',
        '08071' => 'NJ',
        '08072' => 'NJ',
        '08073' => 'NJ',
        '08074' => 'NJ',
        '08075' => 'NJ',
        '08077' => 'NJ',
        '08078' => 'NJ',
        '08079' => 'NJ',
        '08080' => 'NJ',
        '08081' => 'NJ',
        '08083' => 'NJ',
        '08084' => 'NJ',
        '08085' => 'NJ',
        '08086' => 'NJ',
        '08087' => 'NJ',
        '08088' => 'NJ',
        '08089' => 'NJ',
        '08090' => 'NJ',
        '08091' => 'NJ',
        '08092' => 'NJ',
        '08093' => 'NJ',
        '08094' => 'NJ',
        '08095' => 'NJ',
        '08096' => 'NJ',
        '08097' => 'NJ',
        '08098' => 'NJ',
        '08102' => 'NJ',
        '08103' => 'NJ',
        '08104' => 'NJ',
        '08105' => 'NJ',
        '08106' => 'NJ',
        '08107' => 'NJ',
        '08108' => 'NJ',
        '08109' => 'NJ',
        '08110' => 'NJ',
        '08201' => 'NJ',
        '08202' => 'NJ',
        '08203' => 'NJ',
        '08204' => 'NJ',
        '08205' => 'NJ',
        '08210' => 'NJ',
        '08212' => 'NJ',
        '08215' => 'NJ',
        '08217' => 'NJ',
        '08221' => 'NJ',
        '08223' => 'NJ',
        '08224' => 'NJ',
        '08225' => 'NJ',
        '08226' => 'NJ',
        '08230' => 'NJ',
        '08232' => 'NJ',
        '08234' => 'NJ',
        '08240' => 'NJ',
        '08241' => 'NJ',
        '08242' => 'NJ',
        '08243' => 'NJ',
        '08244' => 'NJ',
        '08245' => 'NJ',
        '08246' => 'NJ',
        '08247' => 'NJ',
        '08248' => 'NJ',
        '08251' => 'NJ',
        '08260' => 'NJ',
        '08270' => 'NJ',
        '08302' => 'NJ',
        '08310' => 'NJ',
        '08311' => 'NJ',
        '08312' => 'NJ',
        '08314' => 'NJ',
        '08316' => 'NJ',
        '08317' => 'NJ',
        '08318' => 'NJ',
        '08319' => 'NJ',
        '08320' => 'NJ',
        '08321' => 'NJ',
        '08322' => 'NJ',
        '08323' => 'NJ',
        '08324' => 'NJ',
        '08326' => 'NJ',
        '08327' => 'NJ',
        '08328' => 'NJ',
        '08329' => 'NJ',
        '08330' => 'NJ',
        '08332' => 'NJ',
        '08340' => 'NJ',
        '08341' => 'NJ',
        '08343' => 'NJ',
        '08344' => 'NJ',
        '08345' => 'NJ',
        '08346' => 'NJ',
        '08348' => 'NJ',
        '08349' => 'NJ',
        '08350' => 'NJ',
        '08352' => 'NJ',
        '08353' => 'NJ',
        '08360' => 'NJ',
        '08361' => 'NJ',
        '08401' => 'NJ',
        '08402' => 'NJ',
        '08403' => 'NJ',
        '08406' => 'NJ',
        '08501' => 'NJ',
        '08502' => 'NJ',
        '08505' => 'NJ',
        '08510' => 'NJ',
        '08511' => 'NJ',
        '08512' => 'NJ',
        '08514' => 'NJ',
        '08515' => 'NJ',
        '08518' => 'NJ',
        '08520' => 'NJ',
        '08525' => 'NJ',
        '08527' => 'NJ',
        '08528' => 'NJ',
        '08530' => 'NJ',
        '08533' => 'NJ',
        '08534' => 'NJ',
        '08535' => 'NJ',
        '08536' => 'NJ',
        '08540' => 'NJ',
        '08542' => 'NJ',
        '08544' => 'NJ',
        '08550' => 'NJ',
        '08551' => 'NJ',
        '08553' => 'NJ',
        '08554' => 'NJ',
        '08555' => 'NJ',
        '08558' => 'NJ',
        '08559' => 'NJ',
        '08560' => 'NJ',
        '08561' => 'NJ',
        '08562' => 'NJ',
        '08608' => 'NJ',
        '08609' => 'NJ',
        '08610' => 'NJ',
        '08611' => 'NJ',
        '08618' => 'NJ',
        '08619' => 'NJ',
        '08620' => 'NJ',
        '08628' => 'NJ',
        '08629' => 'NJ',
        '08638' => 'NJ',
        '08640' => 'NJ',
        '08641' => 'NJ',
        '08648' => 'NJ',
        '08690' => 'NJ',
        '08691' => 'NJ',
        '08701' => 'NJ',
        '08720' => 'NJ',
        '08721' => 'NJ',
        '08722' => 'NJ',
        '08723' => 'NJ',
        '08724' => 'NJ',
        '08730' => 'NJ',
        '08731' => 'NJ',
        '08732' => 'NJ',
        '08733' => 'NJ',
        '08734' => 'NJ',
        '08735' => 'NJ',
        '08736' => 'NJ',
        '08738' => 'NJ',
        '08740' => 'NJ',
        '08741' => 'NJ',
        '08742' => 'NJ',
        '08750' => 'NJ',
        '08751' => 'NJ',
        '08752' => 'NJ',
        '08753' => 'NJ',
        '08755' => 'NJ',
        '08757' => 'NJ',
        '08758' => 'NJ',
        '08759' => 'NJ',
        '08801' => 'NJ',
        '08802' => 'NJ',
        '08804' => 'NJ',
        '08805' => 'NJ',
        '08807' => 'NJ',
        '08809' => 'NJ',
        '08810' => 'NJ',
        '08812' => 'NJ',
        '08816' => 'NJ',
        '08817' => 'NJ',
        '08820' => 'NJ',
        '08821' => 'NJ',
        '08822' => 'NJ',
        '08823' => 'NJ',
        '08824' => 'NJ',
        '08825' => 'NJ',
        '08826' => 'NJ',
        '08827' => 'NJ',
        '08828' => 'NJ',
        '08829' => 'NJ',
        '08830' => 'NJ',
        '08831' => 'NJ',
        '08832' => 'NJ',
        '08833' => 'NJ',
        '08835' => 'NJ',
        '08836' => 'NJ',
        '08837' => 'NJ',
        '08840' => 'NJ',
        '08844' => 'NJ',
        '08846' => 'NJ',
        '08848' => 'NJ',
        '08850' => 'NJ',
        '08852' => 'NJ',
        '08853' => 'NJ',
        '08854' => 'NJ',
        '08857' => 'NJ',
        '08858' => 'NJ',
        '08859' => 'NJ',
        '08861' => 'NJ',
        '08863' => 'NJ',
        '08865' => 'NJ',
        '08867' => 'NJ',
        '08869' => 'NJ',
        '08872' => 'NJ',
        '08873' => 'NJ',
        '08876' => 'NJ',
        '08879' => 'NJ',
        '08880' => 'NJ',
        '08882' => 'NJ',
        '08884' => 'NJ',
        '08886' => 'NJ',
        '08887' => 'NJ',
        '08889' => 'NJ',
        '08890' => 'NJ',
        '08901' => 'NJ',
        '08902' => 'NJ',
        '08904' => 'NJ',
        '10001' => 'NY',
        '10002' => 'NY',
        '10003' => 'NY',
        '10004' => 'NY',
        '10005' => 'NY',
        '10006' => 'NY',
        '10007' => 'NY',
        '10009' => 'NY',
        '10010' => 'NY',
        '10011' => 'NY',
        '10012' => 'NY',
        '10013' => 'NY',
        '10014' => 'NY',
        '10016' => 'NY',
        '10017' => 'NY',
        '10018' => 'NY',
        '10019' => 'NY',
        '10020' => 'NY',
        '10021' => 'NY',
        '10022' => 'NY',
        '10023' => 'NY',
        '10024' => 'NY',
        '10025' => 'NY',
        '10026' => 'NY',
        '10027' => 'NY',
        '10028' => 'NY',
        '10029' => 'NY',
        '10030' => 'NY',
        '10031' => 'NY',
        '10032' => 'NY',
        '10033' => 'NY',
        '10034' => 'NY',
        '10035' => 'NY',
        '10036' => 'NY',
        '10037' => 'NY',
        '10038' => 'NY',
        '10039' => 'NY',
        '10040' => 'NY',
        '10044' => 'NY',
        '10065' => 'NY',
        '10069' => 'NY',
        '10075' => 'NY',
        '10103' => 'NY',
        '10110' => 'NY',
        '10111' => 'NY',
        '10112' => 'NY',
        '10115' => 'NY',
        '10119' => 'NY',
        '10128' => 'NY',
        '10152' => 'NY',
        '10153' => 'NY',
        '10154' => 'NY',
        '10162' => 'NY',
        '10165' => 'NY',
        '10167' => 'NY',
        '10168' => 'NY',
        '10169' => 'NY',
        '10170' => 'NY',
        '10171' => 'NY',
        '10172' => 'NY',
        '10173' => 'NY',
        '10174' => 'NY',
        '10177' => 'NY',
        '10199' => 'NY',
        '10271' => 'NY',
        '10278' => 'NY',
        '10279' => 'NY',
        '10280' => 'NY',
        '10282' => 'NY',
        '10301' => 'NY',
        '10302' => 'NY',
        '10303' => 'NY',
        '10304' => 'NY',
        '10305' => 'NY',
        '10306' => 'NY',
        '10307' => 'NY',
        '10308' => 'NY',
        '10309' => 'NY',
        '10310' => 'NY',
        '10311' => 'NY',
        '10312' => 'NY',
        '10314' => 'NY',
        '10451' => 'NY',
        '10452' => 'NY',
        '10453' => 'NY',
        '10454' => 'NY',
        '10455' => 'NY',
        '10456' => 'NY',
        '10457' => 'NY',
        '10458' => 'NY',
        '10459' => 'NY',
        '10460' => 'NY',
        '10461' => 'NY',
        '10462' => 'NY',
        '10463' => 'NY',
        '10464' => 'NY',
        '10465' => 'NY',
        '10466' => 'NY',
        '10467' => 'NY',
        '10468' => 'NY',
        '10469' => 'NY',
        '10470' => 'NY',
        '10471' => 'NY',
        '10472' => 'NY',
        '10473' => 'NY',
        '10474' => 'NY',
        '10475' => 'NY',
        '10501' => 'NY',
        '10502' => 'NY',
        '10503' => 'NY',
        '10504' => 'NY',
        '10505' => 'NY',
        '10506' => 'NY',
        '10507' => 'NY',
        '10509' => 'NY',
        '10510' => 'NY',
        '10511' => 'NY',
        '10512' => 'NY',
        '10514' => 'NY',
        '10516' => 'NY',
        '10517' => 'NY',
        '10518' => 'NY',
        '10519' => 'NY',
        '10520' => 'NY',
        '10522' => 'NY',
        '10523' => 'NY',
        '10524' => 'NY',
        '10526' => 'NY',
        '10527' => 'NY',
        '10528' => 'NY',
        '10530' => 'NY',
        '10532' => 'NY',
        '10533' => 'NY',
        '10535' => 'NY',
        '10536' => 'NY',
        '10537' => 'NY',
        '10538' => 'NY',
        '10540' => 'NY',
        '10541' => 'NY',
        '10542' => 'NY',
        '10543' => 'NY',
        '10545' => 'NY',
        '10546' => 'NY',
        '10547' => 'NY',
        '10548' => 'NY',
        '10549' => 'NY',
        '10550' => 'NY',
        '10552' => 'NY',
        '10553' => 'NY',
        '10560' => 'NY',
        '10562' => 'NY',
        '10566' => 'NY',
        '10567' => 'NY',
        '10570' => 'NY',
        '10573' => 'NY',
        '10576' => 'NY',
        '10577' => 'NY',
        '10578' => 'NY',
        '10579' => 'NY',
        '10580' => 'NY',
        '10583' => 'NY',
        '10588' => 'NY',
        '10589' => 'NY',
        '10590' => 'NY',
        '10591' => 'NY',
        '10594' => 'NY',
        '10595' => 'NY',
        '10596' => 'NY',
        '10597' => 'NY',
        '10598' => 'NY',
        '10601' => 'NY',
        '10603' => 'NY',
        '10604' => 'NY',
        '10605' => 'NY',
        '10606' => 'NY',
        '10607' => 'NY',
        '10701' => 'NY',
        '10703' => 'NY',
        '10704' => 'NY',
        '10705' => 'NY',
        '10706' => 'NY',
        '10707' => 'NY',
        '10708' => 'NY',
        '10709' => 'NY',
        '10710' => 'NY',
        '10801' => 'NY',
        '10803' => 'NY',
        '10804' => 'NY',
        '10805' => 'NY',
        '10901' => 'NY',
        '10910' => 'NY',
        '10911' => 'NY',
        '10913' => 'NY',
        '10914' => 'NY',
        '10915' => 'NY',
        '10916' => 'NY',
        '10917' => 'NY',
        '10918' => 'NY',
        '10919' => 'NY',
        '10920' => 'NY',
        '10921' => 'NY',
        '10922' => 'NY',
        '10923' => 'NY',
        '10924' => 'NY',
        '10925' => 'NY',
        '10926' => 'NY',
        '10927' => 'NY',
        '10928' => 'NY',
        '10930' => 'NY',
        '10931' => 'NY',
        '10932' => 'NY',
        '10933' => 'NY',
        '10940' => 'NY',
        '10941' => 'NY',
        '10950' => 'NY',
        '10952' => 'NY',
        '10953' => 'NY',
        '10954' => 'NY',
        '10956' => 'NY',
        '10958' => 'NY',
        '10960' => 'NY',
        '10962' => 'NY',
        '10963' => 'NY',
        '10964' => 'NY',
        '10965' => 'NY',
        '10968' => 'NY',
        '10969' => 'NY',
        '10970' => 'NY',
        '10973' => 'NY',
        '10974' => 'NY',
        '10975' => 'NY',
        '10976' => 'NY',
        '10977' => 'NY',
        '10979' => 'NY',
        '10980' => 'NY',
        '10983' => 'NY',
        '10984' => 'NY',
        '10985' => 'NY',
        '10986' => 'NY',
        '10987' => 'NY',
        '10988' => 'NY',
        '10989' => 'NY',
        '10990' => 'NY',
        '10992' => 'NY',
        '10993' => 'NY',
        '10994' => 'NY',
        '10996' => 'NY',
        '10998' => 'NY',
        '11001' => 'NY',
        '11003' => 'NY',
        '11004' => 'NY',
        '11005' => 'NY',
        '11010' => 'NY',
        '11020' => 'NY',
        '11021' => 'NY',
        '11023' => 'NY',
        '11024' => 'NY',
        '11030' => 'NY',
        '11040' => 'NY',
        '11042' => 'NY',
        '11050' => 'NY',
        '11096' => 'NY',
        '11101' => 'NY',
        '11102' => 'NY',
        '11103' => 'NY',
        '11104' => 'NY',
        '11105' => 'NY',
        '11106' => 'NY',
        '11109' => 'NY',
        '11201' => 'NY',
        '11203' => 'NY',
        '11204' => 'NY',
        '11205' => 'NY',
        '11206' => 'NY',
        '11207' => 'NY',
        '11208' => 'NY',
        '11209' => 'NY',
        '11210' => 'NY',
        '11211' => 'NY',
        '11212' => 'NY',
        '11213' => 'NY',
        '11214' => 'NY',
        '11215' => 'NY',
        '11216' => 'NY',
        '11217' => 'NY',
        '11218' => 'NY',
        '11219' => 'NY',
        '11220' => 'NY',
        '11221' => 'NY',
        '11222' => 'NY',
        '11223' => 'NY',
        '11224' => 'NY',
        '11225' => 'NY',
        '11226' => 'NY',
        '11228' => 'NY',
        '11229' => 'NY',
        '11230' => 'NY',
        '11231' => 'NY',
        '11232' => 'NY',
        '11233' => 'NY',
        '11234' => 'NY',
        '11235' => 'NY',
        '11236' => 'NY',
        '11237' => 'NY',
        '11238' => 'NY',
        '11239' => 'NY',
        '11249' => 'NY',
        '11354' => 'NY',
        '11355' => 'NY',
        '11356' => 'NY',
        '11357' => 'NY',
        '11358' => 'NY',
        '11359' => 'NY',
        '11360' => 'NY',
        '11361' => 'NY',
        '11362' => 'NY',
        '11363' => 'NY',
        '11364' => 'NY',
        '11365' => 'NY',
        '11366' => 'NY',
        '11367' => 'NY',
        '11368' => 'NY',
        '11369' => 'NY',
        '11370' => 'NY',
        '11371' => 'NY',
        '11372' => 'NY',
        '11373' => 'NY',
        '11374' => 'NY',
        '11375' => 'NY',
        '11377' => 'NY',
        '11378' => 'NY',
        '11379' => 'NY',
        '11385' => 'NY',
        '11411' => 'NY',
        '11412' => 'NY',
        '11413' => 'NY',
        '11414' => 'NY',
        '11415' => 'NY',
        '11416' => 'NY',
        '11417' => 'NY',
        '11418' => 'NY',
        '11419' => 'NY',
        '11420' => 'NY',
        '11421' => 'NY',
        '11422' => 'NY',
        '11423' => 'NY',
        '11424' => 'NY',
        '11426' => 'NY',
        '11427' => 'NY',
        '11428' => 'NY',
        '11429' => 'NY',
        '11430' => 'NY',
        '11432' => 'NY',
        '11433' => 'NY',
        '11434' => 'NY',
        '11435' => 'NY',
        '11436' => 'NY',
        '11439' => 'NY',
        '11451' => 'NY',
        '11501' => 'NY',
        '11507' => 'NY',
        '11509' => 'NY',
        '11510' => 'NY',
        '11514' => 'NY',
        '11516' => 'NY',
        '11518' => 'NY',
        '11520' => 'NY',
        '11530' => 'NY',
        '11542' => 'NY',
        '11545' => 'NY',
        '11547' => 'NY',
        '11548' => 'NY',
        '11549' => 'NY',
        '11550' => 'NY',
        '11552' => 'NY',
        '11553' => 'NY',
        '11554' => 'NY',
        '11556' => 'NY',
        '11557' => 'NY',
        '11558' => 'NY',
        '11559' => 'NY',
        '11560' => 'NY',
        '11561' => 'NY',
        '11563' => 'NY',
        '11565' => 'NY',
        '11566' => 'NY',
        '11568' => 'NY',
        '11569' => 'NY',
        '11570' => 'NY',
        '11572' => 'NY',
        '11575' => 'NY',
        '11576' => 'NY',
        '11577' => 'NY',
        '11579' => 'NY',
        '11580' => 'NY',
        '11581' => 'NY',
        '11590' => 'NY',
        '11596' => 'NY',
        '11598' => 'NY',
        '11691' => 'NY',
        '11692' => 'NY',
        '11693' => 'NY',
        '11694' => 'NY',
        '11697' => 'NY',
        '11701' => 'NY',
        '11702' => 'NY',
        '11703' => 'NY',
        '11704' => 'NY',
        '11705' => 'NY',
        '11706' => 'NY',
        '11709' => 'NY',
        '11710' => 'NY',
        '11713' => 'NY',
        '11714' => 'NY',
        '11715' => 'NY',
        '11716' => 'NY',
        '11717' => 'NY',
        '11718' => 'NY',
        '11719' => 'NY',
        '11720' => 'NY',
        '11721' => 'NY',
        '11722' => 'NY',
        '11724' => 'NY',
        '11725' => 'NY',
        '11726' => 'NY',
        '11727' => 'NY',
        '11729' => 'NY',
        '11730' => 'NY',
        '11731' => 'NY',
        '11732' => 'NY',
        '11733' => 'NY',
        '11735' => 'NY',
        '11738' => 'NY',
        '11739' => 'NY',
        '11740' => 'NY',
        '11741' => 'NY',
        '11742' => 'NY',
        '11743' => 'NY',
        '11746' => 'NY',
        '11747' => 'NY',
        '11749' => 'NY',
        '11751' => 'NY',
        '11752' => 'NY',
        '11753' => 'NY',
        '11754' => 'NY',
        '11755' => 'NY',
        '11756' => 'NY',
        '11757' => 'NY',
        '11758' => 'NY',
        '11762' => 'NY',
        '11763' => 'NY',
        '11764' => 'NY',
        '11765' => 'NY',
        '11766' => 'NY',
        '11767' => 'NY',
        '11768' => 'NY',
        '11769' => 'NY',
        '11770' => 'NY',
        '11771' => 'NY',
        '11772' => 'NY',
        '11776' => 'NY',
        '11777' => 'NY',
        '11778' => 'NY',
        '11779' => 'NY',
        '11780' => 'NY',
        '11782' => 'NY',
        '11783' => 'NY',
        '11784' => 'NY',
        '11786' => 'NY',
        '11787' => 'NY',
        '11788' => 'NY',
        '11789' => 'NY',
        '11790' => 'NY',
        '11791' => 'NY',
        '11792' => 'NY',
        '11793' => 'NY',
        '11794' => 'NY',
        '11795' => 'NY',
        '11796' => 'NY',
        '11797' => 'NY',
        '11798' => 'NY',
        '11801' => 'NY',
        '11803' => 'NY',
        '11804' => 'NY',
        '11901' => 'NY',
        '11930' => 'NY',
        '11931' => 'NY',
        '11932' => 'NY',
        '11933' => 'NY',
        '11934' => 'NY',
        '11935' => 'NY',
        '11937' => 'NY',
        '11939' => 'NY',
        '11940' => 'NY',
        '11941' => 'NY',
        '11942' => 'NY',
        '11944' => 'NY',
        '11946' => 'NY',
        '11947' => 'NY',
        '11948' => 'NY',
        '11949' => 'NY',
        '11950' => 'NY',
        '11951' => 'NY',
        '11952' => 'NY',
        '11953' => 'NY',
        '11954' => 'NY',
        '11955' => 'NY',
        '11956' => 'NY',
        '11957' => 'NY',
        '11958' => 'NY',
        '11959' => 'NY',
        '11960' => 'NY',
        '11961' => 'NY',
        '11962' => 'NY',
        '11963' => 'NY',
        '11964' => 'NY',
        '11965' => 'NY',
        '11967' => 'NY',
        '11968' => 'NY',
        '11970' => 'NY',
        '11971' => 'NY',
        '11972' => 'NY',
        '11973' => 'NY',
        '11975' => 'NY',
        '11976' => 'NY',
        '11977' => 'NY',
        '11978' => 'NY',
        '11980' => 'NY',
        '12007' => 'NY',
        '12008' => 'NY',
        '12009' => 'NY',
        '12010' => 'NY',
        '12015' => 'NY',
        '12017' => 'NY',
        '12018' => 'NY',
        '12019' => 'NY',
        '12020' => 'NY',
        '12022' => 'NY',
        '12023' => 'NY',
        '12024' => 'NY',
        '12025' => 'NY',
        '12027' => 'NY',
        '12028' => 'NY',
        '12029' => 'NY',
        '12031' => 'NY',
        '12032' => 'NY',
        '12033' => 'NY',
        '12035' => 'NY',
        '12036' => 'NY',
        '12037' => 'NY',
        '12040' => 'NY',
        '12041' => 'NY',
        '12042' => 'NY',
        '12043' => 'NY',
        '12045' => 'NY',
        '12046' => 'NY',
        '12047' => 'NY',
        '12051' => 'NY',
        '12052' => 'NY',
        '12053' => 'NY',
        '12054' => 'NY',
        '12056' => 'NY',
        '12057' => 'NY',
        '12058' => 'NY',
        '12059' => 'NY',
        '12060' => 'NY',
        '12061' => 'NY',
        '12062' => 'NY',
        '12063' => 'NY',
        '12064' => 'NY',
        '12065' => 'NY',
        '12066' => 'NY',
        '12067' => 'NY',
        '12068' => 'NY',
        '12069' => 'NY',
        '12070' => 'NY',
        '12071' => 'NY',
        '12072' => 'NY',
        '12074' => 'NY',
        '12075' => 'NY',
        '12076' => 'NY',
        '12077' => 'NY',
        '12078' => 'NY',
        '12082' => 'NY',
        '12083' => 'NY',
        '12084' => 'NY',
        '12085' => 'NY',
        '12086' => 'NY',
        '12087' => 'NY',
        '12090' => 'NY',
        '12092' => 'NY',
        '12093' => 'NY',
        '12094' => 'NY',
        '12095' => 'NY',
        '12106' => 'NY',
        '12108' => 'NY',
        '12110' => 'NY',
        '12115' => 'NY',
        '12116' => 'NY',
        '12117' => 'NY',
        '12118' => 'NY',
        '12120' => 'NY',
        '12121' => 'NY',
        '12122' => 'NY',
        '12123' => 'NY',
        '12124' => 'NY',
        '12125' => 'NY',
        '12130' => 'NY',
        '12131' => 'NY',
        '12132' => 'NY',
        '12134' => 'NY',
        '12136' => 'NY',
        '12137' => 'NY',
        '12138' => 'NY',
        '12139' => 'NY',
        '12140' => 'NY',
        '12143' => 'NY',
        '12144' => 'NY',
        '12147' => 'NY',
        '12148' => 'NY',
        '12149' => 'NY',
        '12150' => 'NY',
        '12151' => 'NY',
        '12153' => 'NY',
        '12154' => 'NY',
        '12155' => 'NY',
        '12156' => 'NY',
        '12157' => 'NY',
        '12158' => 'NY',
        '12159' => 'NY',
        '12160' => 'NY',
        '12161' => 'NY',
        '12164' => 'NY',
        '12165' => 'NY',
        '12166' => 'NY',
        '12167' => 'NY',
        '12168' => 'NY',
        '12169' => 'NY',
        '12170' => 'NY',
        '12172' => 'NY',
        '12173' => 'NY',
        '12174' => 'NY',
        '12175' => 'NY',
        '12176' => 'NY',
        '12177' => 'NY',
        '12180' => 'NY',
        '12182' => 'NY',
        '12183' => 'NY',
        '12184' => 'NY',
        '12185' => 'NY',
        '12186' => 'NY',
        '12187' => 'NY',
        '12188' => 'NY',
        '12189' => 'NY',
        '12190' => 'NY',
        '12192' => 'NY',
        '12193' => 'NY',
        '12194' => 'NY',
        '12195' => 'NY',
        '12196' => 'NY',
        '12197' => 'NY',
        '12198' => 'NY',
        '12202' => 'NY',
        '12203' => 'NY',
        '12204' => 'NY',
        '12205' => 'NY',
        '12206' => 'NY',
        '12207' => 'NY',
        '12208' => 'NY',
        '12209' => 'NY',
        '12210' => 'NY',
        '12211' => 'NY',
        '12222' => 'NY',
        '12226' => 'NY',
        '12302' => 'NY',
        '12303' => 'NY',
        '12304' => 'NY',
        '12305' => 'NY',
        '12306' => 'NY',
        '12307' => 'NY',
        '12308' => 'NY',
        '12309' => 'NY',
        '12401' => 'NY',
        '12404' => 'NY',
        '12405' => 'NY',
        '12406' => 'NY',
        '12407' => 'NY',
        '12409' => 'NY',
        '12410' => 'NY',
        '12411' => 'NY',
        '12412' => 'NY',
        '12413' => 'NY',
        '12414' => 'NY',
        '12416' => 'NY',
        '12417' => 'NY',
        '12418' => 'NY',
        '12419' => 'NY',
        '12420' => 'NY',
        '12421' => 'NY',
        '12422' => 'NY',
        '12423' => 'NY',
        '12424' => 'NY',
        '12427' => 'NY',
        '12428' => 'NY',
        '12429' => 'NY',
        '12430' => 'NY',
        '12431' => 'NY',
        '12432' => 'NY',
        '12433' => 'NY',
        '12434' => 'NY',
        '12435' => 'NY',
        '12436' => 'NY',
        '12438' => 'NY',
        '12439' => 'NY',
        '12440' => 'NY',
        '12441' => 'NY',
        '12442' => 'NY',
        '12443' => 'NY',
        '12444' => 'NY',
        '12446' => 'NY',
        '12448' => 'NY',
        '12449' => 'NY',
        '12450' => 'NY',
        '12451' => 'NY',
        '12452' => 'NY',
        '12453' => 'NY',
        '12454' => 'NY',
        '12455' => 'NY',
        '12456' => 'NY',
        '12457' => 'NY',
        '12458' => 'NY',
        '12459' => 'NY',
        '12460' => 'NY',
        '12461' => 'NY',
        '12463' => 'NY',
        '12464' => 'NY',
        '12465' => 'NY',
        '12466' => 'NY',
        '12468' => 'NY',
        '12469' => 'NY',
        '12470' => 'NY',
        '12471' => 'NY',
        '12472' => 'NY',
        '12473' => 'NY',
        '12474' => 'NY',
        '12475' => 'NY',
        '12477' => 'NY',
        '12480' => 'NY',
        '12481' => 'NY',
        '12482' => 'NY',
        '12483' => 'NY',
        '12484' => 'NY',
        '12485' => 'NY',
        '12486' => 'NY',
        '12487' => 'NY',
        '12489' => 'NY',
        '12490' => 'NY',
        '12491' => 'NY',
        '12492' => 'NY',
        '12493' => 'NY',
        '12494' => 'NY',
        '12495' => 'NY',
        '12496' => 'NY',
        '12498' => 'NY',
        '12501' => 'NY',
        '12502' => 'NY',
        '12503' => 'NY',
        '12504' => 'NY',
        '12507' => 'NY',
        '12508' => 'NY',
        '12512' => 'NY',
        '12513' => 'NY',
        '12514' => 'NY',
        '12515' => 'NY',
        '12516' => 'NY',
        '12517' => 'NY',
        '12518' => 'NY',
        '12520' => 'NY',
        '12521' => 'NY',
        '12522' => 'NY',
        '12523' => 'NY',
        '12524' => 'NY',
        '12525' => 'NY',
        '12526' => 'NY',
        '12527' => 'NY',
        '12528' => 'NY',
        '12529' => 'NY',
        '12530' => 'NY',
        '12531' => 'NY',
        '12533' => 'NY',
        '12534' => 'NY',
        '12538' => 'NY',
        '12540' => 'NY',
        '12542' => 'NY',
        '12543' => 'NY',
        '12544' => 'NY',
        '12545' => 'NY',
        '12546' => 'NY',
        '12547' => 'NY',
        '12548' => 'NY',
        '12549' => 'NY',
        '12550' => 'NY',
        '12553' => 'NY',
        '12561' => 'NY',
        '12563' => 'NY',
        '12564' => 'NY',
        '12565' => 'NY',
        '12566' => 'NY',
        '12567' => 'NY',
        '12569' => 'NY',
        '12570' => 'NY',
        '12571' => 'NY',
        '12572' => 'NY',
        '12574' => 'NY',
        '12575' => 'NY',
        '12577' => 'NY',
        '12578' => 'NY',
        '12580' => 'NY',
        '12581' => 'NY',
        '12582' => 'NY',
        '12583' => 'NY',
        '12585' => 'NY',
        '12586' => 'NY',
        '12589' => 'NY',
        '12590' => 'NY',
        '12592' => 'NY',
        '12594' => 'NY',
        '12601' => 'NY',
        '12603' => 'NY',
        '12604' => 'NY',
        '12701' => 'NY',
        '12719' => 'NY',
        '12720' => 'NY',
        '12721' => 'NY',
        '12722' => 'NY',
        '12723' => 'NY',
        '12724' => 'NY',
        '12725' => 'NY',
        '12726' => 'NY',
        '12729' => 'NY',
        '12732' => 'NY',
        '12733' => 'NY',
        '12734' => 'NY',
        '12736' => 'NY',
        '12737' => 'NY',
        '12738' => 'NY',
        '12740' => 'NY',
        '12741' => 'NY',
        '12742' => 'NY',
        '12743' => 'NY',
        '12745' => 'NY',
        '12746' => 'NY',
        '12747' => 'NY',
        '12748' => 'NY',
        '12749' => 'NY',
        '12750' => 'NY',
        '12751' => 'NY',
        '12752' => 'NY',
        '12754' => 'NY',
        '12758' => 'NY',
        '12759' => 'NY',
        '12760' => 'NY',
        '12762' => 'NY',
        '12763' => 'NY',
        '12764' => 'NY',
        '12765' => 'NY',
        '12766' => 'NY',
        '12767' => 'NY',
        '12768' => 'NY',
        '12769' => 'NY',
        '12770' => 'NY',
        '12771' => 'NY',
        '12775' => 'NY',
        '12776' => 'NY',
        '12777' => 'NY',
        '12778' => 'NY',
        '12779' => 'NY',
        '12780' => 'NY',
        '12781' => 'NY',
        '12783' => 'NY',
        '12784' => 'NY',
        '12785' => 'NY',
        '12786' => 'NY',
        '12787' => 'NY',
        '12788' => 'NY',
        '12789' => 'NY',
        '12790' => 'NY',
        '12791' => 'NY',
        '12792' => 'NY',
        '12801' => 'NY',
        '12803' => 'NY',
        '12804' => 'NY',
        '12808' => 'NY',
        '12809' => 'NY',
        '12810' => 'NY',
        '12811' => 'NY',
        '12812' => 'NY',
        '12814' => 'NY',
        '12815' => 'NY',
        '12816' => 'NY',
        '12817' => 'NY',
        '12819' => 'NY',
        '12820' => 'NY',
        '12821' => 'NY',
        '12822' => 'NY',
        '12823' => 'NY',
        '12824' => 'NY',
        '12827' => 'NY',
        '12828' => 'NY',
        '12831' => 'NY',
        '12832' => 'NY',
        '12833' => 'NY',
        '12834' => 'NY',
        '12835' => 'NY',
        '12836' => 'NY',
        '12837' => 'NY',
        '12838' => 'NY',
        '12839' => 'NY',
        '12841' => 'NY',
        '12842' => 'NY',
        '12843' => 'NY',
        '12844' => 'NY',
        '12845' => 'NY',
        '12846' => 'NY',
        '12847' => 'NY',
        '12849' => 'NY',
        '12850' => 'NY',
        '12851' => 'NY',
        '12852' => 'NY',
        '12853' => 'NY',
        '12854' => 'NY',
        '12855' => 'NY',
        '12856' => 'NY',
        '12857' => 'NY',
        '12858' => 'NY',
        '12859' => 'NY',
        '12860' => 'NY',
        '12861' => 'NY',
        '12862' => 'NY',
        '12863' => 'NY',
        '12864' => 'NY',
        '12865' => 'NY',
        '12866' => 'NY',
        '12870' => 'NY',
        '12871' => 'NY',
        '12872' => 'NY',
        '12873' => 'NY',
        '12874' => 'NY',
        '12878' => 'NY',
        '12883' => 'NY',
        '12884' => 'NY',
        '12885' => 'NY',
        '12886' => 'NY',
        '12887' => 'NY',
        '12901' => 'NY',
        '12903' => 'NY',
        '12910' => 'NY',
        '12911' => 'NY',
        '12912' => 'NY',
        '12913' => 'NY',
        '12914' => 'NY',
        '12915' => 'NY',
        '12916' => 'NY',
        '12917' => 'NY',
        '12918' => 'NY',
        '12919' => 'NY',
        '12920' => 'NY',
        '12921' => 'NY',
        '12922' => 'NY',
        '12923' => 'NY',
        '12924' => 'NY',
        '12926' => 'NY',
        '12927' => 'NY',
        '12928' => 'NY',
        '12929' => 'NY',
        '12930' => 'NY',
        '12932' => 'NY',
        '12933' => 'NY',
        '12934' => 'NY',
        '12935' => 'NY',
        '12936' => 'NY',
        '12937' => 'NY',
        '12939' => 'NY',
        '12941' => 'NY',
        '12942' => 'NY',
        '12943' => 'NY',
        '12944' => 'NY',
        '12945' => 'NY',
        '12946' => 'NY',
        '12950' => 'NY',
        '12952' => 'NY',
        '12953' => 'NY',
        '12955' => 'NY',
        '12956' => 'NY',
        '12957' => 'NY',
        '12958' => 'NY',
        '12959' => 'NY',
        '12960' => 'NY',
        '12961' => 'NY',
        '12962' => 'NY',
        '12964' => 'NY',
        '12965' => 'NY',
        '12966' => 'NY',
        '12967' => 'NY',
        '12969' => 'NY',
        '12970' => 'NY',
        '12972' => 'NY',
        '12973' => 'NY',
        '12974' => 'NY',
        '12975' => 'NY',
        '12976' => 'NY',
        '12977' => 'NY',
        '12978' => 'NY',
        '12979' => 'NY',
        '12980' => 'NY',
        '12981' => 'NY',
        '12983' => 'NY',
        '12985' => 'NY',
        '12986' => 'NY',
        '12987' => 'NY',
        '12989' => 'NY',
        '12992' => 'NY',
        '12993' => 'NY',
        '12996' => 'NY',
        '12997' => 'NY',
        '12998' => 'NY',
        '13020' => 'NY',
        '13021' => 'NY',
        '13024' => 'NY',
        '13026' => 'NY',
        '13027' => 'NY',
        '13028' => 'NY',
        '13029' => 'NY',
        '13030' => 'NY',
        '13031' => 'NY',
        '13032' => 'NY',
        '13033' => 'NY',
        '13034' => 'NY',
        '13035' => 'NY',
        '13036' => 'NY',
        '13037' => 'NY',
        '13039' => 'NY',
        '13040' => 'NY',
        '13041' => 'NY',
        '13042' => 'NY',
        '13044' => 'NY',
        '13045' => 'NY',
        '13051' => 'NY',
        '13052' => 'NY',
        '13053' => 'NY',
        '13054' => 'NY',
        '13057' => 'NY',
        '13060' => 'NY',
        '13061' => 'NY',
        '13062' => 'NY',
        '13063' => 'NY',
        '13065' => 'NY',
        '13066' => 'NY',
        '13068' => 'NY',
        '13069' => 'NY',
        '13071' => 'NY',
        '13072' => 'NY',
        '13073' => 'NY',
        '13074' => 'NY',
        '13076' => 'NY',
        '13077' => 'NY',
        '13078' => 'NY',
        '13080' => 'NY',
        '13081' => 'NY',
        '13082' => 'NY',
        '13083' => 'NY',
        '13084' => 'NY',
        '13087' => 'NY',
        '13088' => 'NY',
        '13090' => 'NY',
        '13092' => 'NY',
        '13101' => 'NY',
        '13102' => 'NY',
        '13103' => 'NY',
        '13104' => 'NY',
        '13108' => 'NY',
        '13110' => 'NY',
        '13111' => 'NY',
        '13112' => 'NY',
        '13113' => 'NY',
        '13114' => 'NY',
        '13115' => 'NY',
        '13116' => 'NY',
        '13117' => 'NY',
        '13118' => 'NY',
        '13119' => 'NY',
        '13120' => 'NY',
        '13121' => 'NY',
        '13122' => 'NY',
        '13123' => 'NY',
        '13124' => 'NY',
        '13126' => 'NY',
        '13131' => 'NY',
        '13132' => 'NY',
        '13134' => 'NY',
        '13135' => 'NY',
        '13136' => 'NY',
        '13138' => 'NY',
        '13140' => 'NY',
        '13141' => 'NY',
        '13142' => 'NY',
        '13143' => 'NY',
        '13144' => 'NY',
        '13145' => 'NY',
        '13146' => 'NY',
        '13147' => 'NY',
        '13148' => 'NY',
        '13152' => 'NY',
        '13153' => 'NY',
        '13154' => 'NY',
        '13155' => 'NY',
        '13156' => 'NY',
        '13157' => 'NY',
        '13158' => 'NY',
        '13159' => 'NY',
        '13160' => 'NY',
        '13162' => 'NY',
        '13163' => 'NY',
        '13164' => 'NY',
        '13165' => 'NY',
        '13166' => 'NY',
        '13167' => 'NY',
        '13202' => 'NY',
        '13203' => 'NY',
        '13204' => 'NY',
        '13205' => 'NY',
        '13206' => 'NY',
        '13207' => 'NY',
        '13208' => 'NY',
        '13209' => 'NY',
        '13210' => 'NY',
        '13211' => 'NY',
        '13212' => 'NY',
        '13214' => 'NY',
        '13215' => 'NY',
        '13219' => 'NY',
        '13224' => 'NY',
        '13244' => 'NY',
        '13290' => 'NY',
        '13301' => 'NY',
        '13302' => 'NY',
        '13303' => 'NY',
        '13304' => 'NY',
        '13305' => 'NY',
        '13308' => 'NY',
        '13309' => 'NY',
        '13310' => 'NY',
        '13312' => 'NY',
        '13313' => 'NY',
        '13314' => 'NY',
        '13315' => 'NY',
        '13316' => 'NY',
        '13317' => 'NY',
        '13318' => 'NY',
        '13319' => 'NY',
        '13320' => 'NY',
        '13321' => 'NY',
        '13322' => 'NY',
        '13323' => 'NY',
        '13324' => 'NY',
        '13325' => 'NY',
        '13326' => 'NY',
        '13327' => 'NY',
        '13328' => 'NY',
        '13329' => 'NY',
        '13331' => 'NY',
        '13332' => 'NY',
        '13333' => 'NY',
        '13334' => 'NY',
        '13335' => 'NY',
        '13337' => 'NY',
        '13338' => 'NY',
        '13339' => 'NY',
        '13340' => 'NY',
        '13342' => 'NY',
        '13343' => 'NY',
        '13345' => 'NY',
        '13346' => 'NY',
        '13348' => 'NY',
        '13350' => 'NY',
        '13352' => 'NY',
        '13353' => 'NY',
        '13354' => 'NY',
        '13355' => 'NY',
        '13357' => 'NY',
        '13360' => 'NY',
        '13361' => 'NY',
        '13363' => 'NY',
        '13364' => 'NY',
        '13365' => 'NY',
        '13367' => 'NY',
        '13368' => 'NY',
        '13402' => 'NY',
        '13403' => 'NY',
        '13404' => 'NY',
        '13406' => 'NY',
        '13407' => 'NY',
        '13408' => 'NY',
        '13409' => 'NY',
        '13410' => 'NY',
        '13411' => 'NY',
        '13413' => 'NY',
        '13415' => 'NY',
        '13416' => 'NY',
        '13417' => 'NY',
        '13418' => 'NY',
        '13420' => 'NY',
        '13421' => 'NY',
        '13424' => 'NY',
        '13425' => 'NY',
        '13428' => 'NY',
        '13431' => 'NY',
        '13433' => 'NY',
        '13435' => 'NY',
        '13436' => 'NY',
        '13437' => 'NY',
        '13438' => 'NY',
        '13439' => 'NY',
        '13440' => 'NY',
        '13441' => 'NY',
        '13450' => 'NY',
        '13452' => 'NY',
        '13454' => 'NY',
        '13455' => 'NY',
        '13456' => 'NY',
        '13457' => 'NY',
        '13459' => 'NY',
        '13460' => 'NY',
        '13461' => 'NY',
        '13464' => 'NY',
        '13468' => 'NY',
        '13469' => 'NY',
        '13470' => 'NY',
        '13471' => 'NY',
        '13472' => 'NY',
        '13473' => 'NY',
        '13475' => 'NY',
        '13476' => 'NY',
        '13477' => 'NY',
        '13478' => 'NY',
        '13480' => 'NY',
        '13482' => 'NY',
        '13483' => 'NY',
        '13484' => 'NY',
        '13485' => 'NY',
        '13486' => 'NY',
        '13488' => 'NY',
        '13489' => 'NY',
        '13490' => 'NY',
        '13491' => 'NY',
        '13492' => 'NY',
        '13493' => 'NY',
        '13494' => 'NY',
        '13495' => 'NY',
        '13501' => 'NY',
        '13502' => 'NY',
        '13601' => 'NY',
        '13602' => 'NY',
        '13603' => 'NY',
        '13605' => 'NY',
        '13606' => 'NY',
        '13607' => 'NY',
        '13608' => 'NY',
        '13611' => 'NY',
        '13612' => 'NY',
        '13613' => 'NY',
        '13614' => 'NY',
        '13615' => 'NY',
        '13616' => 'NY',
        '13617' => 'NY',
        '13618' => 'NY',
        '13619' => 'NY',
        '13620' => 'NY',
        '13621' => 'NY',
        '13622' => 'NY',
        '13623' => 'NY',
        '13624' => 'NY',
        '13625' => 'NY',
        '13626' => 'NY',
        '13628' => 'NY',
        '13630' => 'NY',
        '13632' => 'NY',
        '13633' => 'NY',
        '13634' => 'NY',
        '13635' => 'NY',
        '13636' => 'NY',
        '13637' => 'NY',
        '13638' => 'NY',
        '13639' => 'NY',
        '13640' => 'NY',
        '13641' => 'NY',
        '13642' => 'NY',
        '13643' => 'NY',
        '13645' => 'NY',
        '13646' => 'NY',
        '13647' => 'NY',
        '13648' => 'NY',
        '13649' => 'NY',
        '13650' => 'NY',
        '13651' => 'NY',
        '13652' => 'NY',
        '13654' => 'NY',
        '13655' => 'NY',
        '13656' => 'NY',
        '13658' => 'NY',
        '13659' => 'NY',
        '13660' => 'NY',
        '13661' => 'NY',
        '13662' => 'NY',
        '13664' => 'NY',
        '13665' => 'NY',
        '13666' => 'NY',
        '13667' => 'NY',
        '13668' => 'NY',
        '13669' => 'NY',
        '13670' => 'NY',
        '13672' => 'NY',
        '13673' => 'NY',
        '13674' => 'NY',
        '13675' => 'NY',
        '13676' => 'NY',
        '13678' => 'NY',
        '13679' => 'NY',
        '13680' => 'NY',
        '13681' => 'NY',
        '13682' => 'NY',
        '13683' => 'NY',
        '13684' => 'NY',
        '13685' => 'NY',
        '13687' => 'NY',
        '13690' => 'NY',
        '13691' => 'NY',
        '13692' => 'NY',
        '13693' => 'NY',
        '13694' => 'NY',
        '13695' => 'NY',
        '13696' => 'NY',
        '13697' => 'NY',
        '13699' => 'NY',
        '13730' => 'NY',
        '13731' => 'NY',
        '13732' => 'NY',
        '13733' => 'NY',
        '13734' => 'NY',
        '13736' => 'NY',
        '13738' => 'NY',
        '13739' => 'NY',
        '13740' => 'NY',
        '13743' => 'NY',
        '13744' => 'NY',
        '13746' => 'NY',
        '13747' => 'NY',
        '13748' => 'NY',
        '13750' => 'NY',
        '13751' => 'NY',
        '13752' => 'NY',
        '13753' => 'NY',
        '13754' => 'NY',
        '13755' => 'NY',
        '13756' => 'NY',
        '13757' => 'NY',
        '13760' => 'NY',
        '13774' => 'NY',
        '13775' => 'NY',
        '13776' => 'NY',
        '13777' => 'NY',
        '13778' => 'NY',
        '13780' => 'NY',
        '13782' => 'NY',
        '13783' => 'NY',
        '13784' => 'NY',
        '13786' => 'NY',
        '13787' => 'NY',
        '13788' => 'NY',
        '13790' => 'NY',
        '13795' => 'NY',
        '13796' => 'NY',
        '13797' => 'NY',
        '13801' => 'NY',
        '13802' => 'NY',
        '13803' => 'NY',
        '13804' => 'NY',
        '13806' => 'NY',
        '13807' => 'NY',
        '13808' => 'NY',
        '13809' => 'NY',
        '13810' => 'NY',
        '13811' => 'NY',
        '13812' => 'NY',
        '13813' => 'NY',
        '13814' => 'NY',
        '13815' => 'NY',
        '13820' => 'NY',
        '13825' => 'NY',
        '13826' => 'NY',
        '13827' => 'NY',
        '13830' => 'NY',
        '13832' => 'NY',
        '13833' => 'NY',
        '13834' => 'NY',
        '13835' => 'NY',
        '13838' => 'NY',
        '13839' => 'NY',
        '13841' => 'NY',
        '13842' => 'NY',
        '13843' => 'NY',
        '13844' => 'NY',
        '13846' => 'NY',
        '13847' => 'NY',
        '13849' => 'NY',
        '13850' => 'NY',
        '13856' => 'NY',
        '13859' => 'NY',
        '13860' => 'NY',
        '13861' => 'NY',
        '13862' => 'NY',
        '13863' => 'NY',
        '13864' => 'NY',
        '13865' => 'NY',
        '13901' => 'NY',
        '13902' => 'NY',
        '13903' => 'NY',
        '13904' => 'NY',
        '13905' => 'NY',
        '14001' => 'NY',
        '14004' => 'NY',
        '14005' => 'NY',
        '14006' => 'NY',
        '14008' => 'NY',
        '14009' => 'NY',
        '14011' => 'NY',
        '14012' => 'NY',
        '14013' => 'NY',
        '14020' => 'NY',
        '14024' => 'NY',
        '14025' => 'NY',
        '14026' => 'NY',
        '14027' => 'NY',
        '14028' => 'NY',
        '14029' => 'NY',
        '14030' => 'NY',
        '14031' => 'NY',
        '14032' => 'NY',
        '14033' => 'NY',
        '14034' => 'NY',
        '14035' => 'NY',
        '14036' => 'NY',
        '14037' => 'NY',
        '14039' => 'NY',
        '14040' => 'NY',
        '14041' => 'NY',
        '14042' => 'NY',
        '14043' => 'NY',
        '14047' => 'NY',
        '14048' => 'NY',
        '14051' => 'NY',
        '14052' => 'NY',
        '14054' => 'NY',
        '14055' => 'NY',
        '14056' => 'NY',
        '14057' => 'NY',
        '14058' => 'NY',
        '14059' => 'NY',
        '14060' => 'NY',
        '14061' => 'NY',
        '14062' => 'NY',
        '14063' => 'NY',
        '14065' => 'NY',
        '14066' => 'NY',
        '14067' => 'NY',
        '14068' => 'NY',
        '14069' => 'NY',
        '14070' => 'NY',
        '14072' => 'NY',
        '14075' => 'NY',
        '14080' => 'NY',
        '14081' => 'NY',
        '14082' => 'NY',
        '14083' => 'NY',
        '14085' => 'NY',
        '14086' => 'NY',
        '14091' => 'NY',
        '14092' => 'NY',
        '14094' => 'NY',
        '14098' => 'NY',
        '14101' => 'NY',
        '14102' => 'NY',
        '14103' => 'NY',
        '14105' => 'NY',
        '14108' => 'NY',
        '14109' => 'NY',
        '14111' => 'NY',
        '14112' => 'NY',
        '14113' => 'NY',
        '14120' => 'NY',
        '14125' => 'NY',
        '14126' => 'NY',
        '14127' => 'NY',
        '14129' => 'NY',
        '14130' => 'NY',
        '14131' => 'NY',
        '14132' => 'NY',
        '14134' => 'NY',
        '14135' => 'NY',
        '14136' => 'NY',
        '14138' => 'NY',
        '14139' => 'NY',
        '14141' => 'NY',
        '14143' => 'NY',
        '14145' => 'NY',
        '14150' => 'NY',
        '14166' => 'NY',
        '14167' => 'NY',
        '14168' => 'NY',
        '14169' => 'NY',
        '14170' => 'NY',
        '14171' => 'NY',
        '14172' => 'NY',
        '14173' => 'NY',
        '14174' => 'NY',
        '14201' => 'NY',
        '14202' => 'NY',
        '14203' => 'NY',
        '14204' => 'NY',
        '14206' => 'NY',
        '14207' => 'NY',
        '14208' => 'NY',
        '14209' => 'NY',
        '14210' => 'NY',
        '14211' => 'NY',
        '14212' => 'NY',
        '14213' => 'NY',
        '14214' => 'NY',
        '14215' => 'NY',
        '14216' => 'NY',
        '14217' => 'NY',
        '14218' => 'NY',
        '14219' => 'NY',
        '14220' => 'NY',
        '14221' => 'NY',
        '14222' => 'NY',
        '14223' => 'NY',
        '14224' => 'NY',
        '14225' => 'NY',
        '14226' => 'NY',
        '14227' => 'NY',
        '14228' => 'NY',
        '14260' => 'NY',
        '14261' => 'NY',
        '14301' => 'NY',
        '14302' => 'NY',
        '14303' => 'NY',
        '14304' => 'NY',
        '14305' => 'NY',
        '14411' => 'NY',
        '14413' => 'NY',
        '14414' => 'NY',
        '14415' => 'NY',
        '14416' => 'NY',
        '14418' => 'NY',
        '14420' => 'NY',
        '14422' => 'NY',
        '14423' => 'NY',
        '14424' => 'NY',
        '14425' => 'NY',
        '14427' => 'NY',
        '14428' => 'NY',
        '14432' => 'NY',
        '14433' => 'NY',
        '14435' => 'NY',
        '14437' => 'NY',
        '14441' => 'NY',
        '14445' => 'NY',
        '14450' => 'NY',
        '14453' => 'NY',
        '14454' => 'NY',
        '14456' => 'NY',
        '14462' => 'NY',
        '14463' => 'NY',
        '14464' => 'NY',
        '14466' => 'NY',
        '14467' => 'NY',
        '14468' => 'NY',
        '14469' => 'NY',
        '14470' => 'NY',
        '14471' => 'NY',
        '14472' => 'NY',
        '14475' => 'NY',
        '14476' => 'NY',
        '14477' => 'NY',
        '14478' => 'NY',
        '14479' => 'NY',
        '14480' => 'NY',
        '14481' => 'NY',
        '14482' => 'NY',
        '14485' => 'NY',
        '14486' => 'NY',
        '14487' => 'NY',
        '14489' => 'NY',
        '14502' => 'NY',
        '14504' => 'NY',
        '14505' => 'NY',
        '14506' => 'NY',
        '14507' => 'NY',
        '14510' => 'NY',
        '14511' => 'NY',
        '14512' => 'NY',
        '14513' => 'NY',
        '14514' => 'NY',
        '14515' => 'NY',
        '14516' => 'NY',
        '14517' => 'NY',
        '14519' => 'NY',
        '14521' => 'NY',
        '14522' => 'NY',
        '14525' => 'NY',
        '14526' => 'NY',
        '14527' => 'NY',
        '14529' => 'NY',
        '14530' => 'NY',
        '14532' => 'NY',
        '14533' => 'NY',
        '14534' => 'NY',
        '14536' => 'NY',
        '14537' => 'NY',
        '14539' => 'NY',
        '14541' => 'NY',
        '14542' => 'NY',
        '14543' => 'NY',
        '14544' => 'NY',
        '14545' => 'NY',
        '14546' => 'NY',
        '14548' => 'NY',
        '14549' => 'NY',
        '14550' => 'NY',
        '14551' => 'NY',
        '14555' => 'NY',
        '14556' => 'NY',
        '14557' => 'NY',
        '14559' => 'NY',
        '14560' => 'NY',
        '14561' => 'NY',
        '14564' => 'NY',
        '14568' => 'NY',
        '14569' => 'NY',
        '14571' => 'NY',
        '14572' => 'NY',
        '14580' => 'NY',
        '14585' => 'NY',
        '14586' => 'NY',
        '14588' => 'NY',
        '14589' => 'NY',
        '14590' => 'NY',
        '14591' => 'NY',
        '14592' => 'NY',
        '14604' => 'NY',
        '14605' => 'NY',
        '14606' => 'NY',
        '14607' => 'NY',
        '14608' => 'NY',
        '14609' => 'NY',
        '14610' => 'NY',
        '14611' => 'NY',
        '14612' => 'NY',
        '14613' => 'NY',
        '14614' => 'NY',
        '14615' => 'NY',
        '14616' => 'NY',
        '14617' => 'NY',
        '14618' => 'NY',
        '14619' => 'NY',
        '14620' => 'NY',
        '14621' => 'NY',
        '14622' => 'NY',
        '14623' => 'NY',
        '14624' => 'NY',
        '14625' => 'NY',
        '14626' => 'NY',
        '14627' => 'NY',
        '14642' => 'NY',
        '14701' => 'NY',
        '14706' => 'NY',
        '14707' => 'NY',
        '14708' => 'NY',
        '14709' => 'NY',
        '14710' => 'NY',
        '14711' => 'NY',
        '14712' => 'NY',
        '14714' => 'NY',
        '14715' => 'NY',
        '14716' => 'NY',
        '14717' => 'NY',
        '14718' => 'NY',
        '14719' => 'NY',
        '14720' => 'NY',
        '14721' => 'NY',
        '14722' => 'NY',
        '14723' => 'NY',
        '14724' => 'NY',
        '14726' => 'NY',
        '14727' => 'NY',
        '14728' => 'NY',
        '14729' => 'NY',
        '14731' => 'NY',
        '14732' => 'NY',
        '14733' => 'NY',
        '14735' => 'NY',
        '14736' => 'NY',
        '14737' => 'NY',
        '14738' => 'NY',
        '14739' => 'NY',
        '14740' => 'NY',
        '14741' => 'NY',
        '14742' => 'NY',
        '14743' => 'NY',
        '14744' => 'NY',
        '14747' => 'NY',
        '14748' => 'NY',
        '14750' => 'NY',
        '14752' => 'NY',
        '14753' => 'NY',
        '14754' => 'NY',
        '14755' => 'NY',
        '14756' => 'NY',
        '14757' => 'NY',
        '14760' => 'NY',
        '14767' => 'NY',
        '14769' => 'NY',
        '14770' => 'NY',
        '14772' => 'NY',
        '14774' => 'NY',
        '14775' => 'NY',
        '14777' => 'NY',
        '14778' => 'NY',
        '14779' => 'NY',
        '14781' => 'NY',
        '14782' => 'NY',
        '14783' => 'NY',
        '14784' => 'NY',
        '14785' => 'NY',
        '14787' => 'NY',
        '14788' => 'NY',
        '14801' => 'NY',
        '14802' => 'NY',
        '14803' => 'NY',
        '14804' => 'NY',
        '14805' => 'NY',
        '14806' => 'NY',
        '14807' => 'NY',
        '14808' => 'NY',
        '14809' => 'NY',
        '14810' => 'NY',
        '14812' => 'NY',
        '14813' => 'NY',
        '14814' => 'NY',
        '14815' => 'NY',
        '14816' => 'NY',
        '14817' => 'NY',
        '14818' => 'NY',
        '14819' => 'NY',
        '14820' => 'NY',
        '14821' => 'NY',
        '14822' => 'NY',
        '14823' => 'NY',
        '14824' => 'NY',
        '14825' => 'NY',
        '14826' => 'NY',
        '14827' => 'NY',
        '14830' => 'NY',
        '14836' => 'NY',
        '14837' => 'NY',
        '14838' => 'NY',
        '14839' => 'NY',
        '14840' => 'NY',
        '14841' => 'NY',
        '14842' => 'NY',
        '14843' => 'NY',
        '14845' => 'NY',
        '14846' => 'NY',
        '14847' => 'NY',
        '14850' => 'NY',
        '14853' => 'NY',
        '14854' => 'NY',
        '14855' => 'NY',
        '14856' => 'NY',
        '14858' => 'NY',
        '14859' => 'NY',
        '14860' => 'NY',
        '14861' => 'NY',
        '14864' => 'NY',
        '14865' => 'NY',
        '14867' => 'NY',
        '14869' => 'NY',
        '14870' => 'NY',
        '14871' => 'NY',
        '14872' => 'NY',
        '14873' => 'NY',
        '14874' => 'NY',
        '14877' => 'NY',
        '14878' => 'NY',
        '14879' => 'NY',
        '14880' => 'NY',
        '14881' => 'NY',
        '14882' => 'NY',
        '14883' => 'NY',
        '14884' => 'NY',
        '14885' => 'NY',
        '14886' => 'NY',
        '14889' => 'NY',
        '14891' => 'NY',
        '14892' => 'NY',
        '14893' => 'NY',
        '14894' => 'NY',
        '14895' => 'NY',
        '14897' => 'NY',
        '14898' => 'NY',
        '14901' => 'NY',
        '14903' => 'NY',
        '14904' => 'NY',
        '14905' => 'NY',
        '15001' => 'PA',
        '15003' => 'PA',
        '15004' => 'PA',
        '15005' => 'PA',
        '15006' => 'PA',
        '15007' => 'PA',
        '15009' => 'PA',
        '15010' => 'PA',
        '15012' => 'PA',
        '15014' => 'PA',
        '15015' => 'PA',
        '15017' => 'PA',
        '15018' => 'PA',
        '15019' => 'PA',
        '15020' => 'PA',
        '15021' => 'PA',
        '15022' => 'PA',
        '15024' => 'PA',
        '15025' => 'PA',
        '15026' => 'PA',
        '15027' => 'PA',
        '15028' => 'PA',
        '15030' => 'PA',
        '15031' => 'PA',
        '15033' => 'PA',
        '15034' => 'PA',
        '15035' => 'PA',
        '15037' => 'PA',
        '15038' => 'PA',
        '15042' => 'PA',
        '15043' => 'PA',
        '15044' => 'PA',
        '15045' => 'PA',
        '15046' => 'PA',
        '15047' => 'PA',
        '15049' => 'PA',
        '15050' => 'PA',
        '15051' => 'PA',
        '15052' => 'PA',
        '15053' => 'PA',
        '15054' => 'PA',
        '15055' => 'PA',
        '15056' => 'PA',
        '15057' => 'PA',
        '15059' => 'PA',
        '15060' => 'PA',
        '15061' => 'PA',
        '15062' => 'PA',
        '15063' => 'PA',
        '15064' => 'PA',
        '15065' => 'PA',
        '15066' => 'PA',
        '15067' => 'PA',
        '15068' => 'PA',
        '15071' => 'PA',
        '15072' => 'PA',
        '15074' => 'PA',
        '15075' => 'PA',
        '15076' => 'PA',
        '15077' => 'PA',
        '15078' => 'PA',
        '15081' => 'PA',
        '15082' => 'PA',
        '15083' => 'PA',
        '15084' => 'PA',
        '15085' => 'PA',
        '15086' => 'PA',
        '15087' => 'PA',
        '15088' => 'PA',
        '15089' => 'PA',
        '15090' => 'PA',
        '15101' => 'PA',
        '15102' => 'PA',
        '15104' => 'PA',
        '15106' => 'PA',
        '15108' => 'PA',
        '15110' => 'PA',
        '15112' => 'PA',
        '15116' => 'PA',
        '15120' => 'PA',
        '15122' => 'PA',
        '15123' => 'PA',
        '15126' => 'PA',
        '15129' => 'PA',
        '15131' => 'PA',
        '15132' => 'PA',
        '15133' => 'PA',
        '15135' => 'PA',
        '15136' => 'PA',
        '15137' => 'PA',
        '15139' => 'PA',
        '15140' => 'PA',
        '15142' => 'PA',
        '15143' => 'PA',
        '15144' => 'PA',
        '15145' => 'PA',
        '15146' => 'PA',
        '15147' => 'PA',
        '15148' => 'PA',
        '15201' => 'PA',
        '15202' => 'PA',
        '15203' => 'PA',
        '15204' => 'PA',
        '15205' => 'PA',
        '15206' => 'PA',
        '15207' => 'PA',
        '15208' => 'PA',
        '15209' => 'PA',
        '15210' => 'PA',
        '15211' => 'PA',
        '15212' => 'PA',
        '15213' => 'PA',
        '15214' => 'PA',
        '15215' => 'PA',
        '15216' => 'PA',
        '15217' => 'PA',
        '15218' => 'PA',
        '15219' => 'PA',
        '15220' => 'PA',
        '15221' => 'PA',
        '15222' => 'PA',
        '15223' => 'PA',
        '15224' => 'PA',
        '15225' => 'PA',
        '15226' => 'PA',
        '15227' => 'PA',
        '15228' => 'PA',
        '15229' => 'PA',
        '15232' => 'PA',
        '15233' => 'PA',
        '15234' => 'PA',
        '15235' => 'PA',
        '15236' => 'PA',
        '15237' => 'PA',
        '15238' => 'PA',
        '15239' => 'PA',
        '15241' => 'PA',
        '15243' => 'PA',
        '15260' => 'PA',
        '15275' => 'PA',
        '15282' => 'PA',
        '15290' => 'PA',
        '15301' => 'PA',
        '15310' => 'PA',
        '15311' => 'PA',
        '15312' => 'PA',
        '15313' => 'PA',
        '15314' => 'PA',
        '15315' => 'PA',
        '15316' => 'PA',
        '15317' => 'PA',
        '15320' => 'PA',
        '15321' => 'PA',
        '15322' => 'PA',
        '15323' => 'PA',
        '15324' => 'PA',
        '15325' => 'PA',
        '15327' => 'PA',
        '15329' => 'PA',
        '15330' => 'PA',
        '15331' => 'PA',
        '15332' => 'PA',
        '15333' => 'PA',
        '15334' => 'PA',
        '15337' => 'PA',
        '15338' => 'PA',
        '15340' => 'PA',
        '15341' => 'PA',
        '15342' => 'PA',
        '15344' => 'PA',
        '15345' => 'PA',
        '15346' => 'PA',
        '15347' => 'PA',
        '15348' => 'PA',
        '15349' => 'PA',
        '15350' => 'PA',
        '15351' => 'PA',
        '15352' => 'PA',
        '15353' => 'PA',
        '15357' => 'PA',
        '15358' => 'PA',
        '15359' => 'PA',
        '15360' => 'PA',
        '15361' => 'PA',
        '15362' => 'PA',
        '15363' => 'PA',
        '15364' => 'PA',
        '15365' => 'PA',
        '15366' => 'PA',
        '15367' => 'PA',
        '15368' => 'PA',
        '15370' => 'PA',
        '15376' => 'PA',
        '15377' => 'PA',
        '15378' => 'PA',
        '15379' => 'PA',
        '15380' => 'PA',
        '15401' => 'PA',
        '15410' => 'PA',
        '15411' => 'PA',
        '15412' => 'PA',
        '15413' => 'PA',
        '15416' => 'PA',
        '15417' => 'PA',
        '15419' => 'PA',
        '15420' => 'PA',
        '15421' => 'PA',
        '15422' => 'PA',
        '15423' => 'PA',
        '15424' => 'PA',
        '15425' => 'PA',
        '15427' => 'PA',
        '15428' => 'PA',
        '15429' => 'PA',
        '15430' => 'PA',
        '15431' => 'PA',
        '15432' => 'PA',
        '15433' => 'PA',
        '15434' => 'PA',
        '15435' => 'PA',
        '15436' => 'PA',
        '15437' => 'PA',
        '15438' => 'PA',
        '15440' => 'PA',
        '15442' => 'PA',
        '15443' => 'PA',
        '15444' => 'PA',
        '15445' => 'PA',
        '15446' => 'PA',
        '15447' => 'PA',
        '15448' => 'PA',
        '15449' => 'PA',
        '15450' => 'PA',
        '15451' => 'PA',
        '15454' => 'PA',
        '15455' => 'PA',
        '15456' => 'PA',
        '15458' => 'PA',
        '15459' => 'PA',
        '15460' => 'PA',
        '15461' => 'PA',
        '15462' => 'PA',
        '15463' => 'PA',
        '15464' => 'PA',
        '15465' => 'PA',
        '15466' => 'PA',
        '15467' => 'PA',
        '15468' => 'PA',
        '15469' => 'PA',
        '15470' => 'PA',
        '15472' => 'PA',
        '15473' => 'PA',
        '15474' => 'PA',
        '15475' => 'PA',
        '15476' => 'PA',
        '15477' => 'PA',
        '15478' => 'PA',
        '15479' => 'PA',
        '15480' => 'PA',
        '15482' => 'PA',
        '15483' => 'PA',
        '15484' => 'PA',
        '15486' => 'PA',
        '15488' => 'PA',
        '15489' => 'PA',
        '15490' => 'PA',
        '15492' => 'PA',
        '15501' => 'PA',
        '15502' => 'PA',
        '15510' => 'PA',
        '15520' => 'PA',
        '15521' => 'PA',
        '15522' => 'PA',
        '15530' => 'PA',
        '15531' => 'PA',
        '15532' => 'PA',
        '15533' => 'PA',
        '15534' => 'PA',
        '15535' => 'PA',
        '15536' => 'PA',
        '15537' => 'PA',
        '15538' => 'PA',
        '15539' => 'PA',
        '15540' => 'PA',
        '15541' => 'PA',
        '15542' => 'PA',
        '15544' => 'PA',
        '15545' => 'PA',
        '15546' => 'PA',
        '15547' => 'PA',
        '15550' => 'PA',
        '15551' => 'PA',
        '15552' => 'PA',
        '15554' => 'PA',
        '15555' => 'PA',
        '15557' => 'PA',
        '15558' => 'PA',
        '15559' => 'PA',
        '15560' => 'PA',
        '15561' => 'PA',
        '15562' => 'PA',
        '15563' => 'PA',
        '15564' => 'PA',
        '15565' => 'PA',
        '15601' => 'PA',
        '15610' => 'PA',
        '15611' => 'PA',
        '15612' => 'PA',
        '15613' => 'PA',
        '15615' => 'PA',
        '15616' => 'PA',
        '15617' => 'PA',
        '15618' => 'PA',
        '15619' => 'PA',
        '15620' => 'PA',
        '15622' => 'PA',
        '15623' => 'PA',
        '15624' => 'PA',
        '15625' => 'PA',
        '15626' => 'PA',
        '15627' => 'PA',
        '15628' => 'PA',
        '15629' => 'PA',
        '15631' => 'PA',
        '15632' => 'PA',
        '15633' => 'PA',
        '15634' => 'PA',
        '15635' => 'PA',
        '15636' => 'PA',
        '15637' => 'PA',
        '15638' => 'PA',
        '15639' => 'PA',
        '15640' => 'PA',
        '15641' => 'PA',
        '15642' => 'PA',
        '15644' => 'PA',
        '15646' => 'PA',
        '15647' => 'PA',
        '15650' => 'PA',
        '15655' => 'PA',
        '15656' => 'PA',
        '15658' => 'PA',
        '15660' => 'PA',
        '15661' => 'PA',
        '15662' => 'PA',
        '15663' => 'PA',
        '15665' => 'PA',
        '15666' => 'PA',
        '15668' => 'PA',
        '15670' => 'PA',
        '15671' => 'PA',
        '15672' => 'PA',
        '15673' => 'PA',
        '15674' => 'PA',
        '15675' => 'PA',
        '15676' => 'PA',
        '15677' => 'PA',
        '15678' => 'PA',
        '15679' => 'PA',
        '15680' => 'PA',
        '15681' => 'PA',
        '15682' => 'PA',
        '15683' => 'PA',
        '15684' => 'PA',
        '15686' => 'PA',
        '15687' => 'PA',
        '15688' => 'PA',
        '15689' => 'PA',
        '15690' => 'PA',
        '15691' => 'PA',
        '15692' => 'PA',
        '15693' => 'PA',
        '15695' => 'PA',
        '15696' => 'PA',
        '15697' => 'PA',
        '15698' => 'PA',
        '15701' => 'PA',
        '15705' => 'PA',
        '15710' => 'PA',
        '15711' => 'PA',
        '15712' => 'PA',
        '15713' => 'PA',
        '15714' => 'PA',
        '15715' => 'PA',
        '15716' => 'PA',
        '15717' => 'PA',
        '15720' => 'PA',
        '15721' => 'PA',
        '15722' => 'PA',
        '15723' => 'PA',
        '15724' => 'PA',
        '15725' => 'PA',
        '15727' => 'PA',
        '15728' => 'PA',
        '15729' => 'PA',
        '15730' => 'PA',
        '15731' => 'PA',
        '15732' => 'PA',
        '15733' => 'PA',
        '15734' => 'PA',
        '15736' => 'PA',
        '15737' => 'PA',
        '15738' => 'PA',
        '15739' => 'PA',
        '15741' => 'PA',
        '15742' => 'PA',
        '15744' => 'PA',
        '15745' => 'PA',
        '15746' => 'PA',
        '15747' => 'PA',
        '15748' => 'PA',
        '15750' => 'PA',
        '15752' => 'PA',
        '15753' => 'PA',
        '15754' => 'PA',
        '15756' => 'PA',
        '15757' => 'PA',
        '15759' => 'PA',
        '15760' => 'PA',
        '15761' => 'PA',
        '15762' => 'PA',
        '15763' => 'PA',
        '15764' => 'PA',
        '15765' => 'PA',
        '15767' => 'PA',
        '15770' => 'PA',
        '15771' => 'PA',
        '15772' => 'PA',
        '15773' => 'PA',
        '15774' => 'PA',
        '15775' => 'PA',
        '15776' => 'PA',
        '15777' => 'PA',
        '15778' => 'PA',
        '15779' => 'PA',
        '15780' => 'PA',
        '15781' => 'PA',
        '15783' => 'PA',
        '15784' => 'PA',
        '15801' => 'PA',
        '15821' => 'PA',
        '15823' => 'PA',
        '15824' => 'PA',
        '15825' => 'PA',
        '15827' => 'PA',
        '15828' => 'PA',
        '15829' => 'PA',
        '15831' => 'PA',
        '15832' => 'PA',
        '15834' => 'PA',
        '15840' => 'PA',
        '15841' => 'PA',
        '15845' => 'PA',
        '15846' => 'PA',
        '15847' => 'PA',
        '15848' => 'PA',
        '15849' => 'PA',
        '15851' => 'PA',
        '15853' => 'PA',
        '15856' => 'PA',
        '15857' => 'PA',
        '15860' => 'PA',
        '15861' => 'PA',
        '15863' => 'PA',
        '15864' => 'PA',
        '15865' => 'PA',
        '15866' => 'PA',
        '15868' => 'PA',
        '15870' => 'PA',
        '15901' => 'PA',
        '15902' => 'PA',
        '15904' => 'PA',
        '15905' => 'PA',
        '15906' => 'PA',
        '15909' => 'PA',
        '15920' => 'PA',
        '15921' => 'PA',
        '15922' => 'PA',
        '15923' => 'PA',
        '15924' => 'PA',
        '15925' => 'PA',
        '15926' => 'PA',
        '15927' => 'PA',
        '15928' => 'PA',
        '15929' => 'PA',
        '15930' => 'PA',
        '15931' => 'PA',
        '15934' => 'PA',
        '15935' => 'PA',
        '15936' => 'PA',
        '15937' => 'PA',
        '15938' => 'PA',
        '15940' => 'PA',
        '15942' => 'PA',
        '15943' => 'PA',
        '15944' => 'PA',
        '15945' => 'PA',
        '15946' => 'PA',
        '15948' => 'PA',
        '15949' => 'PA',
        '15951' => 'PA',
        '15952' => 'PA',
        '15953' => 'PA',
        '15954' => 'PA',
        '15955' => 'PA',
        '15956' => 'PA',
        '15957' => 'PA',
        '15958' => 'PA',
        '15960' => 'PA',
        '15961' => 'PA',
        '15962' => 'PA',
        '15963' => 'PA',
        '16001' => 'PA',
        '16002' => 'PA',
        '16020' => 'PA',
        '16022' => 'PA',
        '16023' => 'PA',
        '16024' => 'PA',
        '16025' => 'PA',
        '16027' => 'PA',
        '16028' => 'PA',
        '16029' => 'PA',
        '16030' => 'PA',
        '16033' => 'PA',
        '16034' => 'PA',
        '16035' => 'PA',
        '16036' => 'PA',
        '16037' => 'PA',
        '16038' => 'PA',
        '16040' => 'PA',
        '16041' => 'PA',
        '16045' => 'PA',
        '16046' => 'PA',
        '16048' => 'PA',
        '16049' => 'PA',
        '16050' => 'PA',
        '16051' => 'PA',
        '16052' => 'PA',
        '16053' => 'PA',
        '16054' => 'PA',
        '16055' => 'PA',
        '16056' => 'PA',
        '16057' => 'PA',
        '16059' => 'PA',
        '16061' => 'PA',
        '16063' => 'PA',
        '16066' => 'PA',
        '16101' => 'PA',
        '16102' => 'PA',
        '16105' => 'PA',
        '16110' => 'PA',
        '16111' => 'PA',
        '16112' => 'PA',
        '16113' => 'PA',
        '16114' => 'PA',
        '16115' => 'PA',
        '16116' => 'PA',
        '16117' => 'PA',
        '16120' => 'PA',
        '16121' => 'PA',
        '16123' => 'PA',
        '16124' => 'PA',
        '16125' => 'PA',
        '16127' => 'PA',
        '16130' => 'PA',
        '16131' => 'PA',
        '16132' => 'PA',
        '16133' => 'PA',
        '16134' => 'PA',
        '16136' => 'PA',
        '16137' => 'PA',
        '16140' => 'PA',
        '16141' => 'PA',
        '16142' => 'PA',
        '16143' => 'PA',
        '16145' => 'PA',
        '16146' => 'PA',
        '16148' => 'PA',
        '16150' => 'PA',
        '16151' => 'PA',
        '16153' => 'PA',
        '16154' => 'PA',
        '16155' => 'PA',
        '16156' => 'PA',
        '16157' => 'PA',
        '16159' => 'PA',
        '16160' => 'PA',
        '16161' => 'PA',
        '16172' => 'PA',
        '16201' => 'PA',
        '16210' => 'PA',
        '16211' => 'PA',
        '16212' => 'PA',
        '16213' => 'PA',
        '16214' => 'PA',
        '16217' => 'PA',
        '16218' => 'PA',
        '16220' => 'PA',
        '16222' => 'PA',
        '16223' => 'PA',
        '16224' => 'PA',
        '16226' => 'PA',
        '16228' => 'PA',
        '16229' => 'PA',
        '16230' => 'PA',
        '16232' => 'PA',
        '16233' => 'PA',
        '16235' => 'PA',
        '16236' => 'PA',
        '16238' => 'PA',
        '16239' => 'PA',
        '16240' => 'PA',
        '16242' => 'PA',
        '16244' => 'PA',
        '16245' => 'PA',
        '16246' => 'PA',
        '16248' => 'PA',
        '16249' => 'PA',
        '16250' => 'PA',
        '16253' => 'PA',
        '16254' => 'PA',
        '16255' => 'PA',
        '16256' => 'PA',
        '16258' => 'PA',
        '16259' => 'PA',
        '16260' => 'PA',
        '16262' => 'PA',
        '16263' => 'PA',
        '16301' => 'PA',
        '16311' => 'PA',
        '16312' => 'PA',
        '16313' => 'PA',
        '16314' => 'PA',
        '16316' => 'PA',
        '16317' => 'PA',
        '16319' => 'PA',
        '16321' => 'PA',
        '16322' => 'PA',
        '16323' => 'PA',
        '16326' => 'PA',
        '16327' => 'PA',
        '16328' => 'PA',
        '16329' => 'PA',
        '16331' => 'PA',
        '16332' => 'PA',
        '16333' => 'PA',
        '16334' => 'PA',
        '16335' => 'PA',
        '16340' => 'PA',
        '16341' => 'PA',
        '16342' => 'PA',
        '16343' => 'PA',
        '16344' => 'PA',
        '16345' => 'PA',
        '16346' => 'PA',
        '16347' => 'PA',
        '16350' => 'PA',
        '16351' => 'PA',
        '16352' => 'PA',
        '16353' => 'PA',
        '16354' => 'PA',
        '16360' => 'PA',
        '16361' => 'PA',
        '16362' => 'PA',
        '16364' => 'PA',
        '16365' => 'PA',
        '16370' => 'PA',
        '16371' => 'PA',
        '16372' => 'PA',
        '16373' => 'PA',
        '16374' => 'PA',
        '16401' => 'PA',
        '16402' => 'PA',
        '16403' => 'PA',
        '16404' => 'PA',
        '16405' => 'PA',
        '16406' => 'PA',
        '16407' => 'PA',
        '16410' => 'PA',
        '16411' => 'PA',
        '16412' => 'PA',
        '16415' => 'PA',
        '16416' => 'PA',
        '16417' => 'PA',
        '16420' => 'PA',
        '16421' => 'PA',
        '16422' => 'PA',
        '16423' => 'PA',
        '16424' => 'PA',
        '16426' => 'PA',
        '16427' => 'PA',
        '16428' => 'PA',
        '16430' => 'PA',
        '16433' => 'PA',
        '16434' => 'PA',
        '16435' => 'PA',
        '16436' => 'PA',
        '16438' => 'PA',
        '16440' => 'PA',
        '16441' => 'PA',
        '16442' => 'PA',
        '16443' => 'PA',
        '16444' => 'PA',
        '16475' => 'PA',
        '16501' => 'PA',
        '16502' => 'PA',
        '16503' => 'PA',
        '16504' => 'PA',
        '16505' => 'PA',
        '16506' => 'PA',
        '16507' => 'PA',
        '16508' => 'PA',
        '16509' => 'PA',
        '16510' => 'PA',
        '16511' => 'PA',
        '16546' => 'PA',
        '16550' => 'PA',
        '16563' => 'PA',
        '16601' => 'PA',
        '16602' => 'PA',
        '16611' => 'PA',
        '16613' => 'PA',
        '16616' => 'PA',
        '16617' => 'PA',
        '16619' => 'PA',
        '16620' => 'PA',
        '16621' => 'PA',
        '16622' => 'PA',
        '16623' => 'PA',
        '16624' => 'PA',
        '16625' => 'PA',
        '16627' => 'PA',
        '16630' => 'PA',
        '16631' => 'PA',
        '16633' => 'PA',
        '16634' => 'PA',
        '16635' => 'PA',
        '16636' => 'PA',
        '16637' => 'PA',
        '16638' => 'PA',
        '16639' => 'PA',
        '16640' => 'PA',
        '16641' => 'PA',
        '16645' => 'PA',
        '16646' => 'PA',
        '16647' => 'PA',
        '16648' => 'PA',
        '16650' => 'PA',
        '16651' => 'PA',
        '16652' => 'PA',
        '16654' => 'PA',
        '16655' => 'PA',
        '16656' => 'PA',
        '16657' => 'PA',
        '16659' => 'PA',
        '16661' => 'PA',
        '16662' => 'PA',
        '16664' => 'PA',
        '16665' => 'PA',
        '16666' => 'PA',
        '16667' => 'PA',
        '16668' => 'PA',
        '16669' => 'PA',
        '16670' => 'PA',
        '16671' => 'PA',
        '16672' => 'PA',
        '16673' => 'PA',
        '16674' => 'PA',
        '16675' => 'PA',
        '16677' => 'PA',
        '16678' => 'PA',
        '16679' => 'PA',
        '16680' => 'PA',
        '16682' => 'PA',
        '16683' => 'PA',
        '16684' => 'PA',
        '16685' => 'PA',
        '16686' => 'PA',
        '16689' => 'PA',
        '16691' => 'PA',
        '16692' => 'PA',
        '16693' => 'PA',
        '16694' => 'PA',
        '16695' => 'PA',
        '16699' => 'PA',
        '16701' => 'PA',
        '16720' => 'PA',
        '16724' => 'PA',
        '16725' => 'PA',
        '16726' => 'PA',
        '16727' => 'PA',
        '16729' => 'PA',
        '16730' => 'PA',
        '16731' => 'PA',
        '16732' => 'PA',
        '16733' => 'PA',
        '16734' => 'PA',
        '16735' => 'PA',
        '16738' => 'PA',
        '16740' => 'PA',
        '16743' => 'PA',
        '16744' => 'PA',
        '16745' => 'PA',
        '16746' => 'PA',
        '16748' => 'PA',
        '16749' => 'PA',
        '16750' => 'PA',
        '16801' => 'PA',
        '16802' => 'PA',
        '16803' => 'PA',
        '16820' => 'PA',
        '16821' => 'PA',
        '16822' => 'PA',
        '16823' => 'PA',
        '16825' => 'PA',
        '16826' => 'PA',
        '16827' => 'PA',
        '16828' => 'PA',
        '16829' => 'PA',
        '16830' => 'PA',
        '16832' => 'PA',
        '16833' => 'PA',
        '16834' => 'PA',
        '16835' => 'PA',
        '16836' => 'PA',
        '16837' => 'PA',
        '16838' => 'PA',
        '16839' => 'PA',
        '16840' => 'PA',
        '16841' => 'PA',
        '16843' => 'PA',
        '16844' => 'PA',
        '16845' => 'PA',
        '16847' => 'PA',
        '16848' => 'PA',
        '16849' => 'PA',
        '16851' => 'PA',
        '16852' => 'PA',
        '16853' => 'PA',
        '16854' => 'PA',
        '16855' => 'PA',
        '16856' => 'PA',
        '16858' => 'PA',
        '16859' => 'PA',
        '16860' => 'PA',
        '16861' => 'PA',
        '16863' => 'PA',
        '16864' => 'PA',
        '16865' => 'PA',
        '16866' => 'PA',
        '16868' => 'PA',
        '16870' => 'PA',
        '16871' => 'PA',
        '16872' => 'PA',
        '16874' => 'PA',
        '16875' => 'PA',
        '16876' => 'PA',
        '16877' => 'PA',
        '16878' => 'PA',
        '16879' => 'PA',
        '16881' => 'PA',
        '16882' => 'PA',
        '16901' => 'PA',
        '16910' => 'PA',
        '16911' => 'PA',
        '16912' => 'PA',
        '16914' => 'PA',
        '16915' => 'PA',
        '16917' => 'PA',
        '16920' => 'PA',
        '16921' => 'PA',
        '16922' => 'PA',
        '16923' => 'PA',
        '16925' => 'PA',
        '16926' => 'PA',
        '16927' => 'PA',
        '16928' => 'PA',
        '16929' => 'PA',
        '16930' => 'PA',
        '16932' => 'PA',
        '16933' => 'PA',
        '16935' => 'PA',
        '16936' => 'PA',
        '16937' => 'PA',
        '16938' => 'PA',
        '16939' => 'PA',
        '16940' => 'PA',
        '16941' => 'PA',
        '16942' => 'PA',
        '16943' => 'PA',
        '16946' => 'PA',
        '16947' => 'PA',
        '16948' => 'PA',
        '16950' => 'PA',
        '17002' => 'PA',
        '17003' => 'PA',
        '17004' => 'PA',
        '17005' => 'PA',
        '17006' => 'PA',
        '17007' => 'PA',
        '17009' => 'PA',
        '17010' => 'PA',
        '17011' => 'PA',
        '17013' => 'PA',
        '17014' => 'PA',
        '17015' => 'PA',
        '17016' => 'PA',
        '17017' => 'PA',
        '17018' => 'PA',
        '17019' => 'PA',
        '17020' => 'PA',
        '17021' => 'PA',
        '17022' => 'PA',
        '17023' => 'PA',
        '17024' => 'PA',
        '17025' => 'PA',
        '17026' => 'PA',
        '17027' => 'PA',
        '17028' => 'PA',
        '17029' => 'PA',
        '17030' => 'PA',
        '17032' => 'PA',
        '17033' => 'PA',
        '17034' => 'PA',
        '17035' => 'PA',
        '17036' => 'PA',
        '17037' => 'PA',
        '17038' => 'PA',
        '17039' => 'PA',
        '17040' => 'PA',
        '17041' => 'PA',
        '17042' => 'PA',
        '17043' => 'PA',
        '17044' => 'PA',
        '17045' => 'PA',
        '17046' => 'PA',
        '17047' => 'PA',
        '17048' => 'PA',
        '17049' => 'PA',
        '17050' => 'PA',
        '17051' => 'PA',
        '17052' => 'PA',
        '17053' => 'PA',
        '17054' => 'PA',
        '17055' => 'PA',
        '17056' => 'PA',
        '17057' => 'PA',
        '17058' => 'PA',
        '17059' => 'PA',
        '17060' => 'PA',
        '17061' => 'PA',
        '17062' => 'PA',
        '17063' => 'PA',
        '17064' => 'PA',
        '17065' => 'PA',
        '17066' => 'PA',
        '17067' => 'PA',
        '17068' => 'PA',
        '17069' => 'PA',
        '17070' => 'PA',
        '17071' => 'PA',
        '17073' => 'PA',
        '17074' => 'PA',
        '17075' => 'PA',
        '17076' => 'PA',
        '17077' => 'PA',
        '17078' => 'PA',
        '17080' => 'PA',
        '17081' => 'PA',
        '17082' => 'PA',
        '17084' => 'PA',
        '17086' => 'PA',
        '17087' => 'PA',
        '17088' => 'PA',
        '17090' => 'PA',
        '17093' => 'PA',
        '17094' => 'PA',
        '17097' => 'PA',
        '17098' => 'PA',
        '17099' => 'PA',
        '17101' => 'PA',
        '17102' => 'PA',
        '17103' => 'PA',
        '17104' => 'PA',
        '17109' => 'PA',
        '17110' => 'PA',
        '17111' => 'PA',
        '17112' => 'PA',
        '17113' => 'PA',
        '17120' => 'PA',
        '17201' => 'PA',
        '17202' => 'PA',
        '17210' => 'PA',
        '17211' => 'PA',
        '17212' => 'PA',
        '17213' => 'PA',
        '17214' => 'PA',
        '17215' => 'PA',
        '17217' => 'PA',
        '17219' => 'PA',
        '17220' => 'PA',
        '17221' => 'PA',
        '17222' => 'PA',
        '17223' => 'PA',
        '17224' => 'PA',
        '17225' => 'PA',
        '17228' => 'PA',
        '17229' => 'PA',
        '17232' => 'PA',
        '17233' => 'PA',
        '17235' => 'PA',
        '17236' => 'PA',
        '17237' => 'PA',
        '17238' => 'PA',
        '17239' => 'PA',
        '17240' => 'PA',
        '17241' => 'PA',
        '17243' => 'PA',
        '17244' => 'PA',
        '17246' => 'PA',
        '17247' => 'PA',
        '17249' => 'PA',
        '17250' => 'PA',
        '17251' => 'PA',
        '17252' => 'PA',
        '17253' => 'PA',
        '17254' => 'PA',
        '17255' => 'PA',
        '17257' => 'PA',
        '17260' => 'PA',
        '17261' => 'PA',
        '17262' => 'PA',
        '17263' => 'PA',
        '17264' => 'PA',
        '17265' => 'PA',
        '17266' => 'PA',
        '17267' => 'PA',
        '17268' => 'PA',
        '17271' => 'PA',
        '17301' => 'PA',
        '17302' => 'PA',
        '17303' => 'PA',
        '17304' => 'PA',
        '17306' => 'PA',
        '17307' => 'PA',
        '17309' => 'PA',
        '17311' => 'PA',
        '17313' => 'PA',
        '17314' => 'PA',
        '17315' => 'PA',
        '17316' => 'PA',
        '17317' => 'PA',
        '17318' => 'PA',
        '17319' => 'PA',
        '17320' => 'PA',
        '17321' => 'PA',
        '17322' => 'PA',
        '17323' => 'PA',
        '17324' => 'PA',
        '17325' => 'PA',
        '17327' => 'PA',
        '17329' => 'PA',
        '17331' => 'PA',
        '17339' => 'PA',
        '17340' => 'PA',
        '17342' => 'PA',
        '17343' => 'PA',
        '17344' => 'PA',
        '17345' => 'PA',
        '17347' => 'PA',
        '17349' => 'PA',
        '17350' => 'PA',
        '17352' => 'PA',
        '17353' => 'PA',
        '17355' => 'PA',
        '17356' => 'PA',
        '17360' => 'PA',
        '17361' => 'PA',
        '17362' => 'PA',
        '17363' => 'PA',
        '17364' => 'PA',
        '17365' => 'PA',
        '17366' => 'PA',
        '17368' => 'PA',
        '17370' => 'PA',
        '17371' => 'PA',
        '17372' => 'PA',
        '17401' => 'PA',
        '17402' => 'PA',
        '17403' => 'PA',
        '17404' => 'PA',
        '17406' => 'PA',
        '17407' => 'PA',
        '17408' => 'PA',
        '17501' => 'PA',
        '17502' => 'PA',
        '17504' => 'PA',
        '17505' => 'PA',
        '17506' => 'PA',
        '17507' => 'PA',
        '17508' => 'PA',
        '17509' => 'PA',
        '17512' => 'PA',
        '17516' => 'PA',
        '17517' => 'PA',
        '17518' => 'PA',
        '17519' => 'PA',
        '17520' => 'PA',
        '17522' => 'PA',
        '17527' => 'PA',
        '17529' => 'PA',
        '17532' => 'PA',
        '17534' => 'PA',
        '17535' => 'PA',
        '17536' => 'PA',
        '17538' => 'PA',
        '17540' => 'PA',
        '17543' => 'PA',
        '17545' => 'PA',
        '17547' => 'PA',
        '17550' => 'PA',
        '17551' => 'PA',
        '17552' => 'PA',
        '17554' => 'PA',
        '17555' => 'PA',
        '17557' => 'PA',
        '17560' => 'PA',
        '17562' => 'PA',
        '17563' => 'PA',
        '17565' => 'PA',
        '17566' => 'PA',
        '17568' => 'PA',
        '17569' => 'PA',
        '17570' => 'PA',
        '17572' => 'PA',
        '17576' => 'PA',
        '17578' => 'PA',
        '17579' => 'PA',
        '17581' => 'PA',
        '17582' => 'PA',
        '17584' => 'PA',
        '17601' => 'PA',
        '17602' => 'PA',
        '17603' => 'PA',
        '17606' => 'PA',
        '17701' => 'PA',
        '17702' => 'PA',
        '17720' => 'PA',
        '17721' => 'PA',
        '17723' => 'PA',
        '17724' => 'PA',
        '17727' => 'PA',
        '17728' => 'PA',
        '17729' => 'PA',
        '17730' => 'PA',
        '17731' => 'PA',
        '17737' => 'PA',
        '17739' => 'PA',
        '17740' => 'PA',
        '17742' => 'PA',
        '17744' => 'PA',
        '17745' => 'PA',
        '17747' => 'PA',
        '17748' => 'PA',
        '17749' => 'PA',
        '17750' => 'PA',
        '17751' => 'PA',
        '17752' => 'PA',
        '17754' => 'PA',
        '17756' => 'PA',
        '17758' => 'PA',
        '17760' => 'PA',
        '17762' => 'PA',
        '17763' => 'PA',
        '17764' => 'PA',
        '17765' => 'PA',
        '17768' => 'PA',
        '17769' => 'PA',
        '17771' => 'PA',
        '17772' => 'PA',
        '17774' => 'PA',
        '17776' => 'PA',
        '17777' => 'PA',
        '17778' => 'PA',
        '17779' => 'PA',
        '17801' => 'PA',
        '17810' => 'PA',
        '17812' => 'PA',
        '17813' => 'PA',
        '17814' => 'PA',
        '17815' => 'PA',
        '17820' => 'PA',
        '17821' => 'PA',
        '17822' => 'PA',
        '17823' => 'PA',
        '17824' => 'PA',
        '17827' => 'PA',
        '17829' => 'PA',
        '17830' => 'PA',
        '17832' => 'PA',
        '17834' => 'PA',
        '17835' => 'PA',
        '17836' => 'PA',
        '17837' => 'PA',
        '17840' => 'PA',
        '17841' => 'PA',
        '17842' => 'PA',
        '17844' => 'PA',
        '17845' => 'PA',
        '17846' => 'PA',
        '17847' => 'PA',
        '17850' => 'PA',
        '17851' => 'PA',
        '17853' => 'PA',
        '17855' => 'PA',
        '17856' => 'PA',
        '17857' => 'PA',
        '17858' => 'PA',
        '17859' => 'PA',
        '17860' => 'PA',
        '17861' => 'PA',
        '17862' => 'PA',
        '17864' => 'PA',
        '17865' => 'PA',
        '17866' => 'PA',
        '17867' => 'PA',
        '17868' => 'PA',
        '17870' => 'PA',
        '17872' => 'PA',
        '17876' => 'PA',
        '17878' => 'PA',
        '17880' => 'PA',
        '17881' => 'PA',
        '17884' => 'PA',
        '17885' => 'PA',
        '17886' => 'PA',
        '17887' => 'PA',
        '17888' => 'PA',
        '17889' => 'PA',
        '17901' => 'PA',
        '17920' => 'PA',
        '17921' => 'PA',
        '17922' => 'PA',
        '17923' => 'PA',
        '17925' => 'PA',
        '17929' => 'PA',
        '17930' => 'PA',
        '17931' => 'PA',
        '17933' => 'PA',
        '17934' => 'PA',
        '17935' => 'PA',
        '17936' => 'PA',
        '17938' => 'PA',
        '17941' => 'PA',
        '17943' => 'PA',
        '17944' => 'PA',
        '17945' => 'PA',
        '17946' => 'PA',
        '17948' => 'PA',
        '17949' => 'PA',
        '17951' => 'PA',
        '17952' => 'PA',
        '17953' => 'PA',
        '17954' => 'PA',
        '17957' => 'PA',
        '17959' => 'PA',
        '17960' => 'PA',
        '17961' => 'PA',
        '17963' => 'PA',
        '17964' => 'PA',
        '17965' => 'PA',
        '17967' => 'PA',
        '17968' => 'PA',
        '17970' => 'PA',
        '17972' => 'PA',
        '17974' => 'PA',
        '17976' => 'PA',
        '17978' => 'PA',
        '17979' => 'PA',
        '17980' => 'PA',
        '17981' => 'PA',
        '17982' => 'PA',
        '17983' => 'PA',
        '17985' => 'PA',
        '18011' => 'PA',
        '18012' => 'PA',
        '18013' => 'PA',
        '18014' => 'PA',
        '18015' => 'PA',
        '18017' => 'PA',
        '18018' => 'PA',
        '18020' => 'PA',
        '18030' => 'PA',
        '18031' => 'PA',
        '18032' => 'PA',
        '18034' => 'PA',
        '18035' => 'PA',
        '18036' => 'PA',
        '18037' => 'PA',
        '18038' => 'PA',
        '18040' => 'PA',
        '18041' => 'PA',
        '18042' => 'PA',
        '18045' => 'PA',
        '18046' => 'PA',
        '18049' => 'PA',
        '18051' => 'PA',
        '18052' => 'PA',
        '18053' => 'PA',
        '18054' => 'PA',
        '18055' => 'PA',
        '18056' => 'PA',
        '18058' => 'PA',
        '18059' => 'PA',
        '18062' => 'PA',
        '18063' => 'PA',
        '18064' => 'PA',
        '18065' => 'PA',
        '18066' => 'PA',
        '18067' => 'PA',
        '18069' => 'PA',
        '18070' => 'PA',
        '18071' => 'PA',
        '18072' => 'PA',
        '18073' => 'PA',
        '18074' => 'PA',
        '18076' => 'PA',
        '18077' => 'PA',
        '18078' => 'PA',
        '18079' => 'PA',
        '18080' => 'PA',
        '18081' => 'PA',
        '18083' => 'PA',
        '18085' => 'PA',
        '18086' => 'PA',
        '18087' => 'PA',
        '18088' => 'PA',
        '18091' => 'PA',
        '18092' => 'PA',
        '18101' => 'PA',
        '18102' => 'PA',
        '18103' => 'PA',
        '18104' => 'PA',
        '18106' => 'PA',
        '18109' => 'PA',
        '18195' => 'PA',
        '18201' => 'PA',
        '18202' => 'PA',
        '18210' => 'PA',
        '18211' => 'PA',
        '18212' => 'PA',
        '18214' => 'PA',
        '18216' => 'PA',
        '18218' => 'PA',
        '18219' => 'PA',
        '18220' => 'PA',
        '18221' => 'PA',
        '18222' => 'PA',
        '18223' => 'PA',
        '18224' => 'PA',
        '18225' => 'PA',
        '18229' => 'PA',
        '18230' => 'PA',
        '18231' => 'PA',
        '18232' => 'PA',
        '18234' => 'PA',
        '18235' => 'PA',
        '18237' => 'PA',
        '18239' => 'PA',
        '18240' => 'PA',
        '18241' => 'PA',
        '18242' => 'PA',
        '18244' => 'PA',
        '18245' => 'PA',
        '18246' => 'PA',
        '18248' => 'PA',
        '18249' => 'PA',
        '18250' => 'PA',
        '18252' => 'PA',
        '18254' => 'PA',
        '18255' => 'PA',
        '18256' => 'PA',
        '18301' => 'PA',
        '18302' => 'PA',
        '18321' => 'PA',
        '18322' => 'PA',
        '18323' => 'PA',
        '18324' => 'PA',
        '18325' => 'PA',
        '18326' => 'PA',
        '18327' => 'PA',
        '18328' => 'PA',
        '18330' => 'PA',
        '18331' => 'PA',
        '18332' => 'PA',
        '18333' => 'PA',
        '18334' => 'PA',
        '18335' => 'PA',
        '18336' => 'PA',
        '18337' => 'PA',
        '18340' => 'PA',
        '18342' => 'PA',
        '18343' => 'PA',
        '18344' => 'PA',
        '18346' => 'PA',
        '18347' => 'PA',
        '18349' => 'PA',
        '18350' => 'PA',
        '18351' => 'PA',
        '18353' => 'PA',
        '18354' => 'PA',
        '18355' => 'PA',
        '18356' => 'PA',
        '18357' => 'PA',
        '18360' => 'PA',
        '18370' => 'PA',
        '18371' => 'PA',
        '18372' => 'PA',
        '18403' => 'PA',
        '18405' => 'PA',
        '18407' => 'PA',
        '18411' => 'PA',
        '18413' => 'PA',
        '18414' => 'PA',
        '18415' => 'PA',
        '18417' => 'PA',
        '18419' => 'PA',
        '18420' => 'PA',
        '18421' => 'PA',
        '18424' => 'PA',
        '18425' => 'PA',
        '18426' => 'PA',
        '18428' => 'PA',
        '18430' => 'PA',
        '18431' => 'PA',
        '18433' => 'PA',
        '18434' => 'PA',
        '18435' => 'PA',
        '18436' => 'PA',
        '18437' => 'PA',
        '18438' => 'PA',
        '18439' => 'PA',
        '18440' => 'PA',
        '18441' => 'PA',
        '18443' => 'PA',
        '18444' => 'PA',
        '18445' => 'PA',
        '18446' => 'PA',
        '18447' => 'PA',
        '18451' => 'PA',
        '18452' => 'PA',
        '18453' => 'PA',
        '18454' => 'PA',
        '18455' => 'PA',
        '18456' => 'PA',
        '18457' => 'PA',
        '18458' => 'PA',
        '18460' => 'PA',
        '18461' => 'PA',
        '18462' => 'PA',
        '18463' => 'PA',
        '18464' => 'PA',
        '18465' => 'PA',
        '18466' => 'PA',
        '18469' => 'PA',
        '18470' => 'PA',
        '18471' => 'PA',
        '18472' => 'PA',
        '18473' => 'PA',
        '18503' => 'PA',
        '18504' => 'PA',
        '18505' => 'PA',
        '18507' => 'PA',
        '18508' => 'PA',
        '18509' => 'PA',
        '18510' => 'PA',
        '18512' => 'PA',
        '18517' => 'PA',
        '18518' => 'PA',
        '18519' => 'PA',
        '18602' => 'PA',
        '18603' => 'PA',
        '18610' => 'PA',
        '18612' => 'PA',
        '18614' => 'PA',
        '18615' => 'PA',
        '18616' => 'PA',
        '18617' => 'PA',
        '18618' => 'PA',
        '18619' => 'PA',
        '18621' => 'PA',
        '18622' => 'PA',
        '18623' => 'PA',
        '18624' => 'PA',
        '18625' => 'PA',
        '18626' => 'PA',
        '18627' => 'PA',
        '18628' => 'PA',
        '18629' => 'PA',
        '18630' => 'PA',
        '18631' => 'PA',
        '18632' => 'PA',
        '18634' => 'PA',
        '18635' => 'PA',
        '18636' => 'PA',
        '18640' => 'PA',
        '18641' => 'PA',
        '18642' => 'PA',
        '18643' => 'PA',
        '18644' => 'PA',
        '18651' => 'PA',
        '18655' => 'PA',
        '18656' => 'PA',
        '18657' => 'PA',
        '18660' => 'PA',
        '18661' => 'PA',
        '18701' => 'PA',
        '18702' => 'PA',
        '18704' => 'PA',
        '18705' => 'PA',
        '18706' => 'PA',
        '18707' => 'PA',
        '18708' => 'PA',
        '18709' => 'PA',
        '18801' => 'PA',
        '18810' => 'PA',
        '18812' => 'PA',
        '18814' => 'PA',
        '18816' => 'PA',
        '18817' => 'PA',
        '18818' => 'PA',
        '18820' => 'PA',
        '18821' => 'PA',
        '18822' => 'PA',
        '18823' => 'PA',
        '18824' => 'PA',
        '18825' => 'PA',
        '18826' => 'PA',
        '18828' => 'PA',
        '18829' => 'PA',
        '18830' => 'PA',
        '18831' => 'PA',
        '18832' => 'PA',
        '18833' => 'PA',
        '18834' => 'PA',
        '18837' => 'PA',
        '18840' => 'PA',
        '18842' => 'PA',
        '18843' => 'PA',
        '18844' => 'PA',
        '18845' => 'PA',
        '18846' => 'PA',
        '18847' => 'PA',
        '18848' => 'PA',
        '18850' => 'PA',
        '18851' => 'PA',
        '18853' => 'PA',
        '18854' => 'PA',
        '18901' => 'PA',
        '18902' => 'PA',
        '18912' => 'PA',
        '18913' => 'PA',
        '18914' => 'PA',
        '18915' => 'PA',
        '18917' => 'PA',
        '18920' => 'PA',
        '18921' => 'PA',
        '18923' => 'PA',
        '18925' => 'PA',
        '18927' => 'PA',
        '18929' => 'PA',
        '18930' => 'PA',
        '18932' => 'PA',
        '18933' => 'PA',
        '18935' => 'PA',
        '18936' => 'PA',
        '18938' => 'PA',
        '18940' => 'PA',
        '18942' => 'PA',
        '18944' => 'PA',
        '18946' => 'PA',
        '18947' => 'PA',
        '18950' => 'PA',
        '18951' => 'PA',
        '18954' => 'PA',
        '18955' => 'PA',
        '18960' => 'PA',
        '18962' => 'PA',
        '18964' => 'PA',
        '18966' => 'PA',
        '18969' => 'PA',
        '18970' => 'PA',
        '18972' => 'PA',
        '18974' => 'PA',
        '18976' => 'PA',
        '18977' => 'PA',
        '18980' => 'PA',
        '19001' => 'PA',
        '19002' => 'PA',
        '19003' => 'PA',
        '19004' => 'PA',
        '19006' => 'PA',
        '19007' => 'PA',
        '19008' => 'PA',
        '19009' => 'PA',
        '19010' => 'PA',
        '19012' => 'PA',
        '19013' => 'PA',
        '19014' => 'PA',
        '19015' => 'PA',
        '19017' => 'PA',
        '19018' => 'PA',
        '19020' => 'PA',
        '19021' => 'PA',
        '19022' => 'PA',
        '19023' => 'PA',
        '19025' => 'PA',
        '19026' => 'PA',
        '19027' => 'PA',
        '19029' => 'PA',
        '19030' => 'PA',
        '19031' => 'PA',
        '19032' => 'PA',
        '19033' => 'PA',
        '19034' => 'PA',
        '19035' => 'PA',
        '19036' => 'PA',
        '19038' => 'PA',
        '19040' => 'PA',
        '19041' => 'PA',
        '19043' => 'PA',
        '19044' => 'PA',
        '19046' => 'PA',
        '19047' => 'PA',
        '19050' => 'PA',
        '19052' => 'PA',
        '19053' => 'PA',
        '19054' => 'PA',
        '19055' => 'PA',
        '19056' => 'PA',
        '19057' => 'PA',
        '19060' => 'PA',
        '19061' => 'PA',
        '19063' => 'PA',
        '19064' => 'PA',
        '19066' => 'PA',
        '19067' => 'PA',
        '19070' => 'PA',
        '19072' => 'PA',
        '19073' => 'PA',
        '19074' => 'PA',
        '19075' => 'PA',
        '19076' => 'PA',
        '19078' => 'PA',
        '19079' => 'PA',
        '19081' => 'PA',
        '19082' => 'PA',
        '19083' => 'PA',
        '19085' => 'PA',
        '19086' => 'PA',
        '19087' => 'PA',
        '19090' => 'PA',
        '19094' => 'PA',
        '19095' => 'PA',
        '19096' => 'PA',
        '19102' => 'PA',
        '19103' => 'PA',
        '19104' => 'PA',
        '19106' => 'PA',
        '19107' => 'PA',
        '19108' => 'PA',
        '19109' => 'PA',
        '19111' => 'PA',
        '19112' => 'PA',
        '19113' => 'PA',
        '19114' => 'PA',
        '19115' => 'PA',
        '19116' => 'PA',
        '19118' => 'PA',
        '19119' => 'PA',
        '19120' => 'PA',
        '19121' => 'PA',
        '19122' => 'PA',
        '19123' => 'PA',
        '19124' => 'PA',
        '19125' => 'PA',
        '19126' => 'PA',
        '19127' => 'PA',
        '19128' => 'PA',
        '19129' => 'PA',
        '19130' => 'PA',
        '19131' => 'PA',
        '19132' => 'PA',
        '19133' => 'PA',
        '19134' => 'PA',
        '19135' => 'PA',
        '19136' => 'PA',
        '19137' => 'PA',
        '19138' => 'PA',
        '19139' => 'PA',
        '19140' => 'PA',
        '19141' => 'PA',
        '19142' => 'PA',
        '19143' => 'PA',
        '19144' => 'PA',
        '19145' => 'PA',
        '19146' => 'PA',
        '19147' => 'PA',
        '19148' => 'PA',
        '19149' => 'PA',
        '19150' => 'PA',
        '19151' => 'PA',
        '19152' => 'PA',
        '19153' => 'PA',
        '19154' => 'PA',
        '19301' => 'PA',
        '19310' => 'PA',
        '19311' => 'PA',
        '19312' => 'PA',
        '19316' => 'PA',
        '19317' => 'PA',
        '19319' => 'PA',
        '19320' => 'PA',
        '19330' => 'PA',
        '19333' => 'PA',
        '19335' => 'PA',
        '19341' => 'PA',
        '19342' => 'PA',
        '19343' => 'PA',
        '19344' => 'PA',
        '19345' => 'PA',
        '19348' => 'PA',
        '19350' => 'PA',
        '19352' => 'PA',
        '19355' => 'PA',
        '19358' => 'PA',
        '19362' => 'PA',
        '19363' => 'PA',
        '19365' => 'PA',
        '19367' => 'PA',
        '19369' => 'PA',
        '19372' => 'PA',
        '19373' => 'PA',
        '19374' => 'PA',
        '19375' => 'PA',
        '19380' => 'PA',
        '19382' => 'PA',
        '19383' => 'PA',
        '19390' => 'PA',
        '19401' => 'PA',
        '19403' => 'PA',
        '19405' => 'PA',
        '19406' => 'PA',
        '19422' => 'PA',
        '19425' => 'PA',
        '19426' => 'PA',
        '19428' => 'PA',
        '19435' => 'PA',
        '19436' => 'PA',
        '19437' => 'PA',
        '19438' => 'PA',
        '19440' => 'PA',
        '19442' => 'PA',
        '19444' => 'PA',
        '19446' => 'PA',
        '19453' => 'PA',
        '19454' => 'PA',
        '19456' => 'PA',
        '19457' => 'PA',
        '19460' => 'PA',
        '19462' => 'PA',
        '19464' => 'PA',
        '19465' => 'PA',
        '19468' => 'PA',
        '19472' => 'PA',
        '19473' => 'PA',
        '19474' => 'PA',
        '19475' => 'PA',
        '19477' => 'PA',
        '19490' => 'PA',
        '19492' => 'PA',
        '19501' => 'PA',
        '19503' => 'PA',
        '19504' => 'PA',
        '19505' => 'PA',
        '19506' => 'PA',
        '19507' => 'PA',
        '19508' => 'PA',
        '19510' => 'PA',
        '19511' => 'PA',
        '19512' => 'PA',
        '19516' => 'PA',
        '19518' => 'PA',
        '19520' => 'PA',
        '19522' => 'PA',
        '19523' => 'PA',
        '19525' => 'PA',
        '19526' => 'PA',
        '19529' => 'PA',
        '19530' => 'PA',
        '19533' => 'PA',
        '19534' => 'PA',
        '19535' => 'PA',
        '19536' => 'PA',
        '19538' => 'PA',
        '19539' => 'PA',
        '19540' => 'PA',
        '19541' => 'PA',
        '19543' => 'PA',
        '19544' => 'PA',
        '19545' => 'PA',
        '19547' => 'PA',
        '19549' => 'PA',
        '19550' => 'PA',
        '19551' => 'PA',
        '19554' => 'PA',
        '19555' => 'PA',
        '19559' => 'PA',
        '19560' => 'PA',
        '19562' => 'PA',
        '19564' => 'PA',
        '19565' => 'PA',
        '19567' => 'PA',
        '19601' => 'PA',
        '19602' => 'PA',
        '19604' => 'PA',
        '19605' => 'PA',
        '19606' => 'PA',
        '19607' => 'PA',
        '19608' => 'PA',
        '19609' => 'PA',
        '19610' => 'PA',
        '19611' => 'PA',
        '19701' => 'DE',
        '19702' => 'DE',
        '19703' => 'DE',
        '19706' => 'DE',
        '19707' => 'DE',
        '19709' => 'DE',
        '19710' => 'DE',
        '19711' => 'DE',
        '19713' => 'DE',
        '19716' => 'DE',
        '19717' => 'DE',
        '19720' => 'DE',
        '19730' => 'DE',
        '19731' => 'DE',
        '19732' => 'DE',
        '19733' => 'DE',
        '19734' => 'DE',
        '19735' => 'DE',
        '19736' => 'DE',
        '19801' => 'DE',
        '19802' => 'DE',
        '19803' => 'DE',
        '19804' => 'DE',
        '19805' => 'DE',
        '19806' => 'DE',
        '19807' => 'DE',
        '19808' => 'DE',
        '19809' => 'DE',
        '19810' => 'DE',
        '19901' => 'DE',
        '19902' => 'DE',
        '19904' => 'DE',
        '19930' => 'DE',
        '19931' => 'DE',
        '19933' => 'DE',
        '19934' => 'DE',
        '19936' => 'DE',
        '19938' => 'DE',
        '19939' => 'DE',
        '19940' => 'DE',
        '19941' => 'DE',
        '19943' => 'DE',
        '19944' => 'DE',
        '19945' => 'DE',
        '19946' => 'DE',
        '19947' => 'DE',
        '19950' => 'DE',
        '19951' => 'DE',
        '19952' => 'DE',
        '19953' => 'DE',
        '19954' => 'DE',
        '19955' => 'DE',
        '19956' => 'DE',
        '19958' => 'DE',
        '19960' => 'DE',
        '19962' => 'DE',
        '19963' => 'DE',
        '19964' => 'DE',
        '19966' => 'DE',
        '19967' => 'DE',
        '19968' => 'DE',
        '19970' => 'DE',
        '19971' => 'DE',
        '19973' => 'DE',
        '19975' => 'DE',
        '19977' => 'DE',
        '19979' => 'DE',
        '19980' => 'DE',
        '20001' => 'DC',
        '20002' => 'DC',
        '20003' => 'DC',
        '20004' => 'DC',
        '20005' => 'DC',
        '20006' => 'DC',
        '20007' => 'DC',
        '20008' => 'DC',
        '20009' => 'DC',
        '20010' => 'DC',
        '20011' => 'DC',
        '20012' => 'DC',
        '20015' => 'DC',
        '20016' => 'DC',
        '20017' => 'DC',
        '20018' => 'DC',
        '20019' => 'DC',
        '20020' => 'DC',
        '20024' => 'DC',
        '20032' => 'DC',
        '20036' => 'DC',
        '20037' => 'DC',
        '20045' => 'DC',
        '20052' => 'DC',
        '20057' => 'DC',
        '20059' => 'DC',
        '20064' => 'DC',
        '20105' => 'VA',
        '20106' => 'VA',
        '20109' => 'VA',
        '20110' => 'VA',
        '20111' => 'VA',
        '20112' => 'VA',
        '20115' => 'VA',
        '20117' => 'VA',
        '20119' => 'VA',
        '20120' => 'VA',
        '20121' => 'VA',
        '20124' => 'VA',
        '20129' => 'VA',
        '20130' => 'VA',
        '20132' => 'VA',
        '20135' => 'VA',
        '20136' => 'VA',
        '20137' => 'VA',
        '20141' => 'VA',
        '20143' => 'VA',
        '20144' => 'VA',
        '20147' => 'VA',
        '20148' => 'VA',
        '20151' => 'VA',
        '20152' => 'VA',
        '20155' => 'VA',
        '20158' => 'VA',
        '20164' => 'VA',
        '20165' => 'VA',
        '20166' => 'VA',
        '20169' => 'VA',
        '20170' => 'VA',
        '20171' => 'VA',
        '20175' => 'VA',
        '20176' => 'VA',
        '20180' => 'VA',
        '20181' => 'VA',
        '20184' => 'VA',
        '20186' => 'VA',
        '20187' => 'VA',
        '20190' => 'VA',
        '20191' => 'VA',
        '20194' => 'VA',
        '20197' => 'VA',
        '20198' => 'VA',
        '20204' => 'DC',
        '20220' => 'DC',
        '20230' => 'DC',
        '20240' => 'DC',
        '20245' => 'DC',
        '20250' => 'DC',
        '20260' => 'DC',
        '20317' => 'DC',
        '20319' => 'DC',
        '20373' => 'DC',
        '20388' => 'DC',
        '20390' => 'DC',
        '20408' => 'DC',
        '20415' => 'DC',
        '20418' => 'DC',
        '20422' => 'DC',
        '20427' => 'DC',
        '20431' => 'DC',
        '20510' => 'DC',
        '20515' => 'DC',
        '20520' => 'DC',
        '20530' => 'DC',
        '20535' => 'DC',
        '20540' => 'DC',
        '20542' => 'DC',
        '20551' => 'DC',
        '20560' => 'DC',
        '20565' => 'DC',
        '20566' => 'DC',
        '20591' => 'DC',
        '20601' => 'MD',
        '20602' => 'MD',
        '20603' => 'MD',
        '20606' => 'MD',
        '20607' => 'MD',
        '20608' => 'MD',
        '20609' => 'MD',
        '20611' => 'MD',
        '20612' => 'MD',
        '20613' => 'MD',
        '20615' => 'MD',
        '20616' => 'MD',
        '20617' => 'MD',
        '20618' => 'MD',
        '20619' => 'MD',
        '20620' => 'MD',
        '20621' => 'MD',
        '20622' => 'MD',
        '20623' => 'MD',
        '20624' => 'MD',
        '20625' => 'MD',
        '20626' => 'MD',
        '20628' => 'MD',
        '20629' => 'MD',
        '20630' => 'MD',
        '20632' => 'MD',
        '20634' => 'MD',
        '20636' => 'MD',
        '20637' => 'MD',
        '20639' => 'MD',
        '20640' => 'MD',
        '20645' => 'MD',
        '20646' => 'MD',
        '20650' => 'MD',
        '20653' => 'MD',
        '20656' => 'MD',
        '20657' => 'MD',
        '20658' => 'MD',
        '20659' => 'MD',
        '20660' => 'MD',
        '20661' => 'MD',
        '20662' => 'MD',
        '20664' => 'MD',
        '20667' => 'MD',
        '20670' => 'MD',
        '20674' => 'MD',
        '20675' => 'MD',
        '20676' => 'MD',
        '20677' => 'MD',
        '20678' => 'MD',
        '20680' => 'MD',
        '20684' => 'MD',
        '20685' => 'MD',
        '20686' => 'MD',
        '20687' => 'MD',
        '20688' => 'MD',
        '20689' => 'MD',
        '20690' => 'MD',
        '20692' => 'MD',
        '20693' => 'MD',
        '20695' => 'MD',
        '20701' => 'MD',
        '20705' => 'MD',
        '20706' => 'MD',
        '20707' => 'MD',
        '20708' => 'MD',
        '20710' => 'MD',
        '20711' => 'MD',
        '20712' => 'MD',
        '20714' => 'MD',
        '20715' => 'MD',
        '20716' => 'MD',
        '20720' => 'MD',
        '20721' => 'MD',
        '20722' => 'MD',
        '20723' => 'MD',
        '20724' => 'MD',
        '20732' => 'MD',
        '20733' => 'MD',
        '20735' => 'MD',
        '20736' => 'MD',
        '20737' => 'MD',
        '20740' => 'MD',
        '20742' => 'MD',
        '20743' => 'MD',
        '20744' => 'MD',
        '20745' => 'MD',
        '20746' => 'MD',
        '20747' => 'MD',
        '20748' => 'MD',
        '20751' => 'MD',
        '20754' => 'MD',
        '20755' => 'MD',
        '20758' => 'MD',
        '20759' => 'MD',
        '20762' => 'MD',
        '20763' => 'MD',
        '20764' => 'MD',
        '20765' => 'MD',
        '20769' => 'MD',
        '20770' => 'MD',
        '20771' => 'MD',
        '20772' => 'MD',
        '20774' => 'MD',
        '20776' => 'MD',
        '20777' => 'MD',
        '20778' => 'MD',
        '20779' => 'MD',
        '20781' => 'MD',
        '20782' => 'MD',
        '20783' => 'MD',
        '20784' => 'MD',
        '20785' => 'MD',
        '20794' => 'MD',
        '20812' => 'MD',
        '20814' => 'MD',
        '20815' => 'MD',
        '20816' => 'MD',
        '20817' => 'MD',
        '20818' => 'MD',
        '20832' => 'MD',
        '20833' => 'MD',
        '20837' => 'MD',
        '20838' => 'MD',
        '20839' => 'MD',
        '20841' => 'MD',
        '20842' => 'MD',
        '20850' => 'MD',
        '20851' => 'MD',
        '20852' => 'MD',
        '20853' => 'MD',
        '20854' => 'MD',
        '20855' => 'MD',
        '20860' => 'MD',
        '20861' => 'MD',
        '20862' => 'MD',
        '20866' => 'MD',
        '20868' => 'MD',
        '20871' => 'MD',
        '20872' => 'MD',
        '20874' => 'MD',
        '20876' => 'MD',
        '20877' => 'MD',
        '20878' => 'MD',
        '20879' => 'MD',
        '20880' => 'MD',
        '20882' => 'MD',
        '20886' => 'MD',
        '20889' => 'MD',
        '20892' => 'MD',
        '20894' => 'MD',
        '20895' => 'MD',
        '20896' => 'MD',
        '20899' => 'MD',
        '20901' => 'MD',
        '20902' => 'MD',
        '20903' => 'MD',
        '20904' => 'MD',
        '20905' => 'MD',
        '20906' => 'MD',
        '20910' => 'MD',
        '20912' => 'MD',
        '21001' => 'MD',
        '21005' => 'MD',
        '21009' => 'MD',
        '21010' => 'MD',
        '21012' => 'MD',
        '21013' => 'MD',
        '21014' => 'MD',
        '21015' => 'MD',
        '21017' => 'MD',
        '21023' => 'MD',
        '21028' => 'MD',
        '21029' => 'MD',
        '21030' => 'MD',
        '21031' => 'MD',
        '21032' => 'MD',
        '21034' => 'MD',
        '21035' => 'MD',
        '21036' => 'MD',
        '21037' => 'MD',
        '21040' => 'MD',
        '21042' => 'MD',
        '21043' => 'MD',
        '21044' => 'MD',
        '21045' => 'MD',
        '21046' => 'MD',
        '21047' => 'MD',
        '21048' => 'MD',
        '21050' => 'MD',
        '21051' => 'MD',
        '21052' => 'MD',
        '21053' => 'MD',
        '21054' => 'MD',
        '21056' => 'MD',
        '21057' => 'MD',
        '21060' => 'MD',
        '21061' => 'MD',
        '21071' => 'MD',
        '21074' => 'MD',
        '21075' => 'MD',
        '21076' => 'MD',
        '21077' => 'MD',
        '21078' => 'MD',
        '21082' => 'MD',
        '21084' => 'MD',
        '21085' => 'MD',
        '21087' => 'MD',
        '21090' => 'MD',
        '21093' => 'MD',
        '21102' => 'MD',
        '21104' => 'MD',
        '21105' => 'MD',
        '21108' => 'MD',
        '21111' => 'MD',
        '21113' => 'MD',
        '21114' => 'MD',
        '21117' => 'MD',
        '21120' => 'MD',
        '21122' => 'MD',
        '21128' => 'MD',
        '21130' => 'MD',
        '21131' => 'MD',
        '21132' => 'MD',
        '21133' => 'MD',
        '21136' => 'MD',
        '21140' => 'MD',
        '21144' => 'MD',
        '21146' => 'MD',
        '21152' => 'MD',
        '21153' => 'MD',
        '21154' => 'MD',
        '21155' => 'MD',
        '21156' => 'MD',
        '21157' => 'MD',
        '21158' => 'MD',
        '21160' => 'MD',
        '21161' => 'MD',
        '21162' => 'MD',
        '21163' => 'MD',
        '21201' => 'MD',
        '21202' => 'MD',
        '21204' => 'MD',
        '21205' => 'MD',
        '21206' => 'MD',
        '21207' => 'MD',
        '21208' => 'MD',
        '21209' => 'MD',
        '21210' => 'MD',
        '21211' => 'MD',
        '21212' => 'MD',
        '21213' => 'MD',
        '21214' => 'MD',
        '21215' => 'MD',
        '21216' => 'MD',
        '21217' => 'MD',
        '21218' => 'MD',
        '21219' => 'MD',
        '21220' => 'MD',
        '21221' => 'MD',
        '21222' => 'MD',
        '21223' => 'MD',
        '21224' => 'MD',
        '21225' => 'MD',
        '21226' => 'MD',
        '21227' => 'MD',
        '21228' => 'MD',
        '21229' => 'MD',
        '21230' => 'MD',
        '21231' => 'MD',
        '21233' => 'MD',
        '21234' => 'MD',
        '21236' => 'MD',
        '21237' => 'MD',
        '21239' => 'MD',
        '21240' => 'MD',
        '21244' => 'MD',
        '21250' => 'MD',
        '21251' => 'MD',
        '21252' => 'MD',
        '21285' => 'MD',
        '21286' => 'MD',
        '21287' => 'MD',
        '21401' => 'MD',
        '21402' => 'MD',
        '21403' => 'MD',
        '21405' => 'MD',
        '21409' => 'MD',
        '21502' => 'MD',
        '21520' => 'MD',
        '21521' => 'MD',
        '21523' => 'MD',
        '21524' => 'MD',
        '21529' => 'MD',
        '21530' => 'MD',
        '21531' => 'MD',
        '21532' => 'MD',
        '21536' => 'MD',
        '21538' => 'MD',
        '21539' => 'MD',
        '21540' => 'MD',
        '21541' => 'MD',
        '21542' => 'MD',
        '21543' => 'MD',
        '21545' => 'MD',
        '21550' => 'MD',
        '21555' => 'MD',
        '21557' => 'MD',
        '21560' => 'MD',
        '21561' => 'MD',
        '21562' => 'MD',
        '21601' => 'MD',
        '21607' => 'MD',
        '21610' => 'MD',
        '21612' => 'MD',
        '21613' => 'MD',
        '21617' => 'MD',
        '21619' => 'MD',
        '21620' => 'MD',
        '21622' => 'MD',
        '21623' => 'MD',
        '21624' => 'MD',
        '21625' => 'MD',
        '21626' => 'MD',
        '21627' => 'MD',
        '21628' => 'MD',
        '21629' => 'MD',
        '21631' => 'MD',
        '21632' => 'MD',
        '21634' => 'MD',
        '21635' => 'MD',
        '21636' => 'MD',
        '21638' => 'MD',
        '21639' => 'MD',
        '21640' => 'MD',
        '21641' => 'MD',
        '21643' => 'MD',
        '21644' => 'MD',
        '21645' => 'MD',
        '21647' => 'MD',
        '21648' => 'MD',
        '21649' => 'MD',
        '21650' => 'MD',
        '21651' => 'MD',
        '21652' => 'MD',
        '21653' => 'MD',
        '21654' => 'MD',
        '21655' => 'MD',
        '21657' => 'MD',
        '21658' => 'MD',
        '21659' => 'MD',
        '21660' => 'MD',
        '21661' => 'MD',
        '21662' => 'MD',
        '21663' => 'MD',
        '21664' => 'MD',
        '21665' => 'MD',
        '21666' => 'MD',
        '21667' => 'MD',
        '21668' => 'MD',
        '21669' => 'MD',
        '21671' => 'MD',
        '21672' => 'MD',
        '21673' => 'MD',
        '21675' => 'MD',
        '21676' => 'MD',
        '21677' => 'MD',
        '21678' => 'MD',
        '21679' => 'MD',
        '21701' => 'MD',
        '21702' => 'MD',
        '21703' => 'MD',
        '21704' => 'MD',
        '21705' => 'MD',
        '21710' => 'MD',
        '21711' => 'MD',
        '21713' => 'MD',
        '21714' => 'MD',
        '21715' => 'MD',
        '21716' => 'MD',
        '21717' => 'MD',
        '21718' => 'MD',
        '21719' => 'MD',
        '21722' => 'MD',
        '21723' => 'MD',
        '21727' => 'MD',
        '21733' => 'MD',
        '21734' => 'MD',
        '21737' => 'MD',
        '21738' => 'MD',
        '21740' => 'MD',
        '21742' => 'MD',
        '21746' => 'MD',
        '21750' => 'MD',
        '21754' => 'MD',
        '21755' => 'MD',
        '21756' => 'MD',
        '21757' => 'MD',
        '21758' => 'MD',
        '21762' => 'MD',
        '21766' => 'MD',
        '21767' => 'MD',
        '21769' => 'MD',
        '21770' => 'MD',
        '21771' => 'MD',
        '21773' => 'MD',
        '21774' => 'MD',
        '21776' => 'MD',
        '21777' => 'MD',
        '21778' => 'MD',
        '21779' => 'MD',
        '21780' => 'MD',
        '21781' => 'MD',
        '21782' => 'MD',
        '21783' => 'MD',
        '21784' => 'MD',
        '21787' => 'MD',
        '21788' => 'MD',
        '21790' => 'MD',
        '21791' => 'MD',
        '21793' => 'MD',
        '21794' => 'MD',
        '21795' => 'MD',
        '21797' => 'MD',
        '21798' => 'MD',
        '21801' => 'MD',
        '21804' => 'MD',
        '21810' => 'MD',
        '21811' => 'MD',
        '21813' => 'MD',
        '21814' => 'MD',
        '21817' => 'MD',
        '21821' => 'MD',
        '21822' => 'MD',
        '21824' => 'MD',
        '21826' => 'MD',
        '21829' => 'MD',
        '21830' => 'MD',
        '21835' => 'MD',
        '21837' => 'MD',
        '21838' => 'MD',
        '21840' => 'MD',
        '21841' => 'MD',
        '21842' => 'MD',
        '21849' => 'MD',
        '21850' => 'MD',
        '21851' => 'MD',
        '21853' => 'MD',
        '21856' => 'MD',
        '21861' => 'MD',
        '21862' => 'MD',
        '21863' => 'MD',
        '21864' => 'MD',
        '21865' => 'MD',
        '21866' => 'MD',
        '21867' => 'MD',
        '21869' => 'MD',
        '21871' => 'MD',
        '21872' => 'MD',
        '21874' => 'MD',
        '21875' => 'MD',
        '21890' => 'MD',
        '21901' => 'MD',
        '21902' => 'MD',
        '21903' => 'MD',
        '21904' => 'MD',
        '21911' => 'MD',
        '21912' => 'MD',
        '21913' => 'MD',
        '21914' => 'MD',
        '21915' => 'MD',
        '21917' => 'MD',
        '21918' => 'MD',
        '21919' => 'MD',
        '21920' => 'MD',
        '21921' => 'MD',
        '21930' => 'MD',
        '22003' => 'VA',
        '22015' => 'VA',
        '22025' => 'VA',
        '22026' => 'VA',
        '22027' => 'VA',
        '22030' => 'VA',
        '22031' => 'VA',
        '22032' => 'VA',
        '22033' => 'VA',
        '22035' => 'VA',
        '22039' => 'VA',
        '22041' => 'VA',
        '22042' => 'VA',
        '22043' => 'VA',
        '22044' => 'VA',
        '22046' => 'VA',
        '22060' => 'VA',
        '22066' => 'VA',
        '22079' => 'VA',
        '22101' => 'VA',
        '22102' => 'VA',
        '22124' => 'VA',
        '22125' => 'VA',
        '22134' => 'VA',
        '22150' => 'VA',
        '22151' => 'VA',
        '22152' => 'VA',
        '22153' => 'VA',
        '22172' => 'VA',
        '22180' => 'VA',
        '22181' => 'VA',
        '22182' => 'VA',
        '22191' => 'VA',
        '22192' => 'VA',
        '22193' => 'VA',
        '22201' => 'VA',
        '22202' => 'VA',
        '22203' => 'VA',
        '22204' => 'VA',
        '22205' => 'VA',
        '22206' => 'VA',
        '22207' => 'VA',
        '22209' => 'VA',
        '22211' => 'VA',
        '22213' => 'VA',
        '22214' => 'VA',
        '22301' => 'VA',
        '22302' => 'VA',
        '22303' => 'VA',
        '22304' => 'VA',
        '22305' => 'VA',
        '22306' => 'VA',
        '22307' => 'VA',
        '22308' => 'VA',
        '22309' => 'VA',
        '22310' => 'VA',
        '22311' => 'VA',
        '22312' => 'VA',
        '22314' => 'VA',
        '22315' => 'VA',
        '22401' => 'VA',
        '22405' => 'VA',
        '22406' => 'VA',
        '22407' => 'VA',
        '22408' => 'VA',
        '22427' => 'VA',
        '22432' => 'VA',
        '22433' => 'VA',
        '22435' => 'VA',
        '22436' => 'VA',
        '22437' => 'VA',
        '22438' => 'VA',
        '22443' => 'VA',
        '22448' => 'VA',
        '22454' => 'VA',
        '22460' => 'VA',
        '22469' => 'VA',
        '22472' => 'VA',
        '22473' => 'VA',
        '22476' => 'VA',
        '22480' => 'VA',
        '22482' => 'VA',
        '22485' => 'VA',
        '22488' => 'VA',
        '22503' => 'VA',
        '22504' => 'VA',
        '22508' => 'VA',
        '22509' => 'VA',
        '22511' => 'VA',
        '22514' => 'VA',
        '22520' => 'VA',
        '22529' => 'VA',
        '22534' => 'VA',
        '22535' => 'VA',
        '22538' => 'VA',
        '22539' => 'VA',
        '22542' => 'VA',
        '22546' => 'VA',
        '22548' => 'VA',
        '22551' => 'VA',
        '22553' => 'VA',
        '22554' => 'VA',
        '22556' => 'VA',
        '22560' => 'VA',
        '22567' => 'VA',
        '22572' => 'VA',
        '22576' => 'VA',
        '22578' => 'VA',
        '22580' => 'VA',
        '22601' => 'VA',
        '22602' => 'VA',
        '22603' => 'VA',
        '22610' => 'VA',
        '22611' => 'VA',
        '22620' => 'VA',
        '22623' => 'VA',
        '22624' => 'VA',
        '22625' => 'VA',
        '22627' => 'VA',
        '22630' => 'VA',
        '22637' => 'VA',
        '22639' => 'VA',
        '22640' => 'VA',
        '22641' => 'VA',
        '22642' => 'VA',
        '22643' => 'VA',
        '22644' => 'VA',
        '22645' => 'VA',
        '22646' => 'VA',
        '22650' => 'VA',
        '22652' => 'VA',
        '22654' => 'VA',
        '22655' => 'VA',
        '22656' => 'VA',
        '22657' => 'VA',
        '22660' => 'VA',
        '22663' => 'VA',
        '22664' => 'VA',
        '22701' => 'VA',
        '22709' => 'VA',
        '22711' => 'VA',
        '22712' => 'VA',
        '22713' => 'VA',
        '22714' => 'VA',
        '22715' => 'VA',
        '22716' => 'VA',
        '22718' => 'VA',
        '22719' => 'VA',
        '22720' => 'VA',
        '22722' => 'VA',
        '22723' => 'VA',
        '22724' => 'VA',
        '22725' => 'VA',
        '22726' => 'VA',
        '22727' => 'VA',
        '22728' => 'VA',
        '22729' => 'VA',
        '22730' => 'VA',
        '22731' => 'VA',
        '22732' => 'VA',
        '22733' => 'VA',
        '22734' => 'VA',
        '22735' => 'VA',
        '22736' => 'VA',
        '22737' => 'VA',
        '22738' => 'VA',
        '22740' => 'VA',
        '22741' => 'VA',
        '22742' => 'VA',
        '22743' => 'VA',
        '22746' => 'VA',
        '22747' => 'VA',
        '22749' => 'VA',
        '22801' => 'VA',
        '22802' => 'VA',
        '22807' => 'VA',
        '22810' => 'VA',
        '22811' => 'VA',
        '22812' => 'VA',
        '22815' => 'VA',
        '22820' => 'VA',
        '22821' => 'VA',
        '22824' => 'VA',
        '22827' => 'VA',
        '22830' => 'VA',
        '22831' => 'VA',
        '22832' => 'VA',
        '22834' => 'VA',
        '22835' => 'VA',
        '22840' => 'VA',
        '22841' => 'VA',
        '22842' => 'VA',
        '22843' => 'VA',
        '22844' => 'VA',
        '22845' => 'VA',
        '22846' => 'VA',
        '22847' => 'VA',
        '22849' => 'VA',
        '22850' => 'VA',
        '22851' => 'VA',
        '22853' => 'VA',
        '22901' => 'VA',
        '22902' => 'VA',
        '22903' => 'VA',
        '22904' => 'VA',
        '22908' => 'VA',
        '22911' => 'VA',
        '22920' => 'VA',
        '22922' => 'VA',
        '22923' => 'VA',
        '22931' => 'VA',
        '22932' => 'VA',
        '22935' => 'VA',
        '22936' => 'VA',
        '22937' => 'VA',
        '22938' => 'VA',
        '22939' => 'VA',
        '22940' => 'VA',
        '22942' => 'VA',
        '22943' => 'VA',
        '22946' => 'VA',
        '22947' => 'VA',
        '22948' => 'VA',
        '22949' => 'VA',
        '22952' => 'VA',
        '22957' => 'VA',
        '22958' => 'VA',
        '22959' => 'VA',
        '22960' => 'VA',
        '22963' => 'VA',
        '22964' => 'VA',
        '22967' => 'VA',
        '22968' => 'VA',
        '22969' => 'VA',
        '22971' => 'VA',
        '22972' => 'VA',
        '22973' => 'VA',
        '22974' => 'VA',
        '22976' => 'VA',
        '22980' => 'VA',
        '22989' => 'VA',
        '23002' => 'VA',
        '23004' => 'VA',
        '23005' => 'VA',
        '23009' => 'VA',
        '23011' => 'VA',
        '23015' => 'VA',
        '23021' => 'VA',
        '23022' => 'VA',
        '23023' => 'VA',
        '23024' => 'VA',
        '23025' => 'VA',
        '23027' => 'VA',
        '23030' => 'VA',
        '23032' => 'VA',
        '23035' => 'VA',
        '23038' => 'VA',
        '23039' => 'VA',
        '23040' => 'VA',
        '23043' => 'VA',
        '23045' => 'VA',
        '23047' => 'VA',
        '23050' => 'VA',
        '23055' => 'VA',
        '23056' => 'VA',
        '23059' => 'VA',
        '23060' => 'VA',
        '23061' => 'VA',
        '23062' => 'VA',
        '23063' => 'VA',
        '23065' => 'VA',
        '23066' => 'VA',
        '23068' => 'VA',
        '23069' => 'VA',
        '23070' => 'VA',
        '23071' => 'VA',
        '23072' => 'VA',
        '23075' => 'VA',
        '23076' => 'VA',
        '23079' => 'VA',
        '23081' => 'VA',
        '23083' => 'VA',
        '23084' => 'VA',
        '23085' => 'VA',
        '23086' => 'VA',
        '23089' => 'VA',
        '23091' => 'VA',
        '23092' => 'VA',
        '23093' => 'VA',
        '23102' => 'VA',
        '23103' => 'VA',
        '23106' => 'VA',
        '23108' => 'VA',
        '23109' => 'VA',
        '23110' => 'VA',
        '23111' => 'VA',
        '23112' => 'VA',
        '23113' => 'VA',
        '23114' => 'VA',
        '23116' => 'VA',
        '23117' => 'VA',
        '23119' => 'VA',
        '23120' => 'VA',
        '23123' => 'VA',
        '23124' => 'VA',
        '23126' => 'VA',
        '23128' => 'VA',
        '23129' => 'VA',
        '23130' => 'VA',
        '23138' => 'VA',
        '23139' => 'VA',
        '23140' => 'VA',
        '23141' => 'VA',
        '23146' => 'VA',
        '23147' => 'VA',
        '23148' => 'VA',
        '23149' => 'VA',
        '23150' => 'VA',
        '23153' => 'VA',
        '23156' => 'VA',
        '23160' => 'VA',
        '23161' => 'VA',
        '23163' => 'VA',
        '23168' => 'VA',
        '23169' => 'VA',
        '23173' => 'VA',
        '23175' => 'VA',
        '23176' => 'VA',
        '23177' => 'VA',
        '23180' => 'VA',
        '23181' => 'VA',
        '23185' => 'VA',
        '23188' => 'VA',
        '23192' => 'VA',
        '23219' => 'VA',
        '23220' => 'VA',
        '23221' => 'VA',
        '23222' => 'VA',
        '23223' => 'VA',
        '23224' => 'VA',
        '23225' => 'VA',
        '23226' => 'VA',
        '23227' => 'VA',
        '23228' => 'VA',
        '23229' => 'VA',
        '23230' => 'VA',
        '23231' => 'VA',
        '23233' => 'VA',
        '23234' => 'VA',
        '23235' => 'VA',
        '23236' => 'VA',
        '23237' => 'VA',
        '23238' => 'VA',
        '23250' => 'VA',
        '23284' => 'VA',
        '23294' => 'VA',
        '23298' => 'VA',
        '23301' => 'VA',
        '23302' => 'VA',
        '23303' => 'VA',
        '23304' => 'VA',
        '23306' => 'VA',
        '23307' => 'VA',
        '23308' => 'VA',
        '23310' => 'VA',
        '23314' => 'VA',
        '23315' => 'VA',
        '23316' => 'VA',
        '23320' => 'VA',
        '23321' => 'VA',
        '23322' => 'VA',
        '23323' => 'VA',
        '23324' => 'VA',
        '23325' => 'VA',
        '23336' => 'VA',
        '23337' => 'VA',
        '23347' => 'VA',
        '23350' => 'VA',
        '23354' => 'VA',
        '23356' => 'VA',
        '23357' => 'VA',
        '23358' => 'VA',
        '23359' => 'VA',
        '23389' => 'VA',
        '23395' => 'VA',
        '23398' => 'VA',
        '23401' => 'VA',
        '23405' => 'VA',
        '23407' => 'VA',
        '23408' => 'VA',
        '23409' => 'VA',
        '23410' => 'VA',
        '23413' => 'VA',
        '23414' => 'VA',
        '23415' => 'VA',
        '23416' => 'VA',
        '23417' => 'VA',
        '23418' => 'VA',
        '23420' => 'VA',
        '23421' => 'VA',
        '23422' => 'VA',
        '23423' => 'VA',
        '23426' => 'VA',
        '23427' => 'VA',
        '23430' => 'VA',
        '23432' => 'VA',
        '23433' => 'VA',
        '23434' => 'VA',
        '23435' => 'VA',
        '23436' => 'VA',
        '23437' => 'VA',
        '23438' => 'VA',
        '23440' => 'VA',
        '23441' => 'VA',
        '23442' => 'VA',
        '23451' => 'VA',
        '23452' => 'VA',
        '23453' => 'VA',
        '23454' => 'VA',
        '23455' => 'VA',
        '23456' => 'VA',
        '23457' => 'VA',
        '23459' => 'VA',
        '23460' => 'VA',
        '23461' => 'VA',
        '23462' => 'VA',
        '23464' => 'VA',
        '23480' => 'VA',
        '23486' => 'VA',
        '23487' => 'VA',
        '23488' => 'VA',
        '23502' => 'VA',
        '23503' => 'VA',
        '23504' => 'VA',
        '23505' => 'VA',
        '23507' => 'VA',
        '23508' => 'VA',
        '23509' => 'VA',
        '23510' => 'VA',
        '23511' => 'VA',
        '23513' => 'VA',
        '23517' => 'VA',
        '23518' => 'VA',
        '23523' => 'VA',
        '23551' => 'VA',
        '23601' => 'VA',
        '23602' => 'VA',
        '23603' => 'VA',
        '23604' => 'VA',
        '23605' => 'VA',
        '23606' => 'VA',
        '23607' => 'VA',
        '23608' => 'VA',
        '23651' => 'VA',
        '23661' => 'VA',
        '23662' => 'VA',
        '23663' => 'VA',
        '23664' => 'VA',
        '23665' => 'VA',
        '23666' => 'VA',
        '23667' => 'VA',
        '23668' => 'VA',
        '23669' => 'VA',
        '23681' => 'VA',
        '23690' => 'VA',
        '23691' => 'VA',
        '23692' => 'VA',
        '23693' => 'VA',
        '23696' => 'VA',
        '23701' => 'VA',
        '23702' => 'VA',
        '23703' => 'VA',
        '23704' => 'VA',
        '23707' => 'VA',
        '23708' => 'VA',
        '23709' => 'VA',
        '23801' => 'VA',
        '23803' => 'VA',
        '23805' => 'VA',
        '23821' => 'VA',
        '23824' => 'VA',
        '23827' => 'VA',
        '23828' => 'VA',
        '23829' => 'VA',
        '23830' => 'VA',
        '23831' => 'VA',
        '23832' => 'VA',
        '23833' => 'VA',
        '23834' => 'VA',
        '23836' => 'VA',
        '23837' => 'VA',
        '23838' => 'VA',
        '23839' => 'VA',
        '23840' => 'VA',
        '23841' => 'VA',
        '23842' => 'VA',
        '23843' => 'VA',
        '23844' => 'VA',
        '23845' => 'VA',
        '23846' => 'VA',
        '23847' => 'VA',
        '23850' => 'VA',
        '23851' => 'VA',
        '23856' => 'VA',
        '23857' => 'VA',
        '23860' => 'VA',
        '23866' => 'VA',
        '23867' => 'VA',
        '23868' => 'VA',
        '23870' => 'VA',
        '23872' => 'VA',
        '23874' => 'VA',
        '23875' => 'VA',
        '23876' => 'VA',
        '23878' => 'VA',
        '23879' => 'VA',
        '23881' => 'VA',
        '23882' => 'VA',
        '23883' => 'VA',
        '23884' => 'VA',
        '23885' => 'VA',
        '23887' => 'VA',
        '23888' => 'VA',
        '23889' => 'VA',
        '23890' => 'VA',
        '23891' => 'VA',
        '23893' => 'VA',
        '23894' => 'VA',
        '23897' => 'VA',
        '23898' => 'VA',
        '23899' => 'VA',
        '23901' => 'VA',
        '23909' => 'VA',
        '23915' => 'VA',
        '23917' => 'VA',
        '23919' => 'VA',
        '23920' => 'VA',
        '23921' => 'VA',
        '23922' => 'VA',
        '23923' => 'VA',
        '23924' => 'VA',
        '23927' => 'VA',
        '23930' => 'VA',
        '23934' => 'VA',
        '23936' => 'VA',
        '23937' => 'VA',
        '23938' => 'VA',
        '23942' => 'VA',
        '23943' => 'VA',
        '23944' => 'VA',
        '23947' => 'VA',
        '23950' => 'VA',
        '23952' => 'VA',
        '23954' => 'VA',
        '23955' => 'VA',
        '23958' => 'VA',
        '23959' => 'VA',
        '23960' => 'VA',
        '23962' => 'VA',
        '23963' => 'VA',
        '23964' => 'VA',
        '23966' => 'VA',
        '23967' => 'VA',
        '23968' => 'VA',
        '23970' => 'VA',
        '23974' => 'VA',
        '23976' => 'VA',
        '24011' => 'VA',
        '24012' => 'VA',
        '24013' => 'VA',
        '24014' => 'VA',
        '24015' => 'VA',
        '24016' => 'VA',
        '24017' => 'VA',
        '24018' => 'VA',
        '24019' => 'VA',
        '24020' => 'VA',
        '24022' => 'VA',
        '24053' => 'VA',
        '24054' => 'VA',
        '24055' => 'VA',
        '24058' => 'VA',
        '24059' => 'VA',
        '24060' => 'VA',
        '24061' => 'VA',
        '24064' => 'VA',
        '24065' => 'VA',
        '24066' => 'VA',
        '24067' => 'VA',
        '24069' => 'VA',
        '24070' => 'VA',
        '24072' => 'VA',
        '24073' => 'VA',
        '24076' => 'VA',
        '24077' => 'VA',
        '24078' => 'VA',
        '24079' => 'VA',
        '24082' => 'VA',
        '24083' => 'VA',
        '24084' => 'VA',
        '24085' => 'VA',
        '24086' => 'VA',
        '24087' => 'VA',
        '24088' => 'VA',
        '24089' => 'VA',
        '24090' => 'VA',
        '24091' => 'VA',
        '24092' => 'VA',
        '24093' => 'VA',
        '24095' => 'VA',
        '24101' => 'VA',
        '24102' => 'VA',
        '24104' => 'VA',
        '24105' => 'VA',
        '24112' => 'VA',
        '24120' => 'VA',
        '24121' => 'VA',
        '24122' => 'VA',
        '24124' => 'VA',
        '24127' => 'VA',
        '24128' => 'VA',
        '24129' => 'VA',
        '24131' => 'VA',
        '24132' => 'VA',
        '24133' => 'VA',
        '24134' => 'VA',
        '24136' => 'VA',
        '24137' => 'VA',
        '24138' => 'VA',
        '24139' => 'VA',
        '24141' => 'VA',
        '24142' => 'VA',
        '24147' => 'VA',
        '24148' => 'VA',
        '24149' => 'VA',
        '24150' => 'VA',
        '24151' => 'VA',
        '24153' => 'VA',
        '24161' => 'VA',
        '24162' => 'VA',
        '24165' => 'VA',
        '24167' => 'VA',
        '24168' => 'VA',
        '24171' => 'VA',
        '24174' => 'VA',
        '24175' => 'VA',
        '24176' => 'VA',
        '24179' => 'VA',
        '24184' => 'VA',
        '24185' => 'VA',
        '24201' => 'VA',
        '24202' => 'VA',
        '24210' => 'VA',
        '24211' => 'VA',
        '24216' => 'VA',
        '24217' => 'VA',
        '24219' => 'VA',
        '24220' => 'VA',
        '24221' => 'VA',
        '24224' => 'VA',
        '24225' => 'VA',
        '24226' => 'VA',
        '24228' => 'VA',
        '24230' => 'VA',
        '24236' => 'VA',
        '24237' => 'VA',
        '24239' => 'VA',
        '24243' => 'VA',
        '24244' => 'VA',
        '24245' => 'VA',
        '24246' => 'VA',
        '24248' => 'VA',
        '24250' => 'VA',
        '24251' => 'VA',
        '24256' => 'VA',
        '24258' => 'VA',
        '24260' => 'VA',
        '24263' => 'VA',
        '24265' => 'VA',
        '24266' => 'VA',
        '24269' => 'VA',
        '24270' => 'VA',
        '24271' => 'VA',
        '24272' => 'VA',
        '24273' => 'VA',
        '24277' => 'VA',
        '24279' => 'VA',
        '24280' => 'VA',
        '24281' => 'VA',
        '24282' => 'VA',
        '24283' => 'VA',
        '24290' => 'VA',
        '24292' => 'VA',
        '24293' => 'VA',
        '24301' => 'VA',
        '24311' => 'VA',
        '24312' => 'VA',
        '24313' => 'VA',
        '24314' => 'VA',
        '24315' => 'VA',
        '24316' => 'VA',
        '24317' => 'VA',
        '24318' => 'VA',
        '24319' => 'VA',
        '24322' => 'VA',
        '24323' => 'VA',
        '24324' => 'VA',
        '24325' => 'VA',
        '24326' => 'VA',
        '24327' => 'VA',
        '24328' => 'VA',
        '24330' => 'VA',
        '24333' => 'VA',
        '24340' => 'VA',
        '24343' => 'VA',
        '24347' => 'VA',
        '24348' => 'VA',
        '24350' => 'VA',
        '24351' => 'VA',
        '24352' => 'VA',
        '24354' => 'VA',
        '24360' => 'VA',
        '24361' => 'VA',
        '24363' => 'VA',
        '24366' => 'VA',
        '24368' => 'VA',
        '24370' => 'VA',
        '24374' => 'VA',
        '24375' => 'VA',
        '24377' => 'VA',
        '24378' => 'VA',
        '24380' => 'VA',
        '24381' => 'VA',
        '24382' => 'VA',
        '24401' => 'VA',
        '24411' => 'VA',
        '24412' => 'VA',
        '24413' => 'VA',
        '24415' => 'VA',
        '24416' => 'VA',
        '24421' => 'VA',
        '24422' => 'VA',
        '24426' => 'VA',
        '24430' => 'VA',
        '24431' => 'VA',
        '24432' => 'VA',
        '24433' => 'VA',
        '24435' => 'VA',
        '24437' => 'VA',
        '24439' => 'VA',
        '24440' => 'VA',
        '24441' => 'VA',
        '24442' => 'VA',
        '24445' => 'VA',
        '24448' => 'VA',
        '24450' => 'VA',
        '24457' => 'VA',
        '24458' => 'VA',
        '24459' => 'VA',
        '24460' => 'VA',
        '24464' => 'VA',
        '24465' => 'VA',
        '24467' => 'VA',
        '24469' => 'VA',
        '24471' => 'VA',
        '24472' => 'VA',
        '24473' => 'VA',
        '24474' => 'VA',
        '24476' => 'VA',
        '24477' => 'VA',
        '24479' => 'VA',
        '24482' => 'VA',
        '24483' => 'VA',
        '24484' => 'VA',
        '24485' => 'VA',
        '24486' => 'VA',
        '24487' => 'VA',
        '24501' => 'VA',
        '24502' => 'VA',
        '24503' => 'VA',
        '24504' => 'VA',
        '24515' => 'VA',
        '24517' => 'VA',
        '24520' => 'VA',
        '24521' => 'VA',
        '24522' => 'VA',
        '24523' => 'VA',
        '24526' => 'VA',
        '24527' => 'VA',
        '24528' => 'VA',
        '24529' => 'VA',
        '24530' => 'VA',
        '24531' => 'VA',
        '24534' => 'VA',
        '24536' => 'VA',
        '24538' => 'VA',
        '24539' => 'VA',
        '24540' => 'VA',
        '24541' => 'VA',
        '24549' => 'VA',
        '24550' => 'VA',
        '24551' => 'VA',
        '24553' => 'VA',
        '24554' => 'VA',
        '24555' => 'VA',
        '24556' => 'VA',
        '24557' => 'VA',
        '24558' => 'VA',
        '24562' => 'VA',
        '24563' => 'VA',
        '24565' => 'VA',
        '24566' => 'VA',
        '24569' => 'VA',
        '24570' => 'VA',
        '24571' => 'VA',
        '24572' => 'VA',
        '24574' => 'VA',
        '24577' => 'VA',
        '24578' => 'VA',
        '24579' => 'VA',
        '24580' => 'VA',
        '24581' => 'VA',
        '24586' => 'VA',
        '24588' => 'VA',
        '24589' => 'VA',
        '24590' => 'VA',
        '24592' => 'VA',
        '24593' => 'VA',
        '24594' => 'VA',
        '24595' => 'VA',
        '24597' => 'VA',
        '24598' => 'VA',
        '24599' => 'VA',
        '24601' => 'VA',
        '24602' => 'VA',
        '24603' => 'VA',
        '24604' => 'VA',
        '24605' => 'VA',
        '24606' => 'VA',
        '24607' => 'VA',
        '24609' => 'VA',
        '24612' => 'VA',
        '24613' => 'VA',
        '24614' => 'VA',
        '24620' => 'VA',
        '24622' => 'VA',
        '24630' => 'VA',
        '24631' => 'VA',
        '24634' => 'VA',
        '24635' => 'VA',
        '24637' => 'VA',
        '24639' => 'VA',
        '24641' => 'VA',
        '24646' => 'VA',
        '24649' => 'VA',
        '24651' => 'VA',
        '24656' => 'VA',
        '24657' => 'VA',
        '24701' => 'WV',
        '24712' => 'WV',
        '24714' => 'WV',
        '24715' => 'WV',
        '24716' => 'WV',
        '24719' => 'WV',
        '24724' => 'WV',
        '24726' => 'WV',
        '24729' => 'WV',
        '24731' => 'WV',
        '24733' => 'WV',
        '24736' => 'WV',
        '24737' => 'WV',
        '24738' => 'WV',
        '24739' => 'WV',
        '24740' => 'WV',
        '24747' => 'WV',
        '24801' => 'WV',
        '24808' => 'WV',
        '24811' => 'WV',
        '24813' => 'WV',
        '24815' => 'WV',
        '24816' => 'WV',
        '24817' => 'WV',
        '24818' => 'WV',
        '24822' => 'WV',
        '24823' => 'WV',
        '24826' => 'WV',
        '24827' => 'WV',
        '24828' => 'WV',
        '24830' => 'WV',
        '24831' => 'WV',
        '24834' => 'WV',
        '24836' => 'WV',
        '24839' => 'WV',
        '24843' => 'WV',
        '24844' => 'WV',
        '24845' => 'WV',
        '24846' => 'WV',
        '24847' => 'WV',
        '24848' => 'WV',
        '24849' => 'WV',
        '24850' => 'WV',
        '24851' => 'WV',
        '24853' => 'WV',
        '24854' => 'WV',
        '24855' => 'WV',
        '24857' => 'WV',
        '24860' => 'WV',
        '24861' => 'WV',
        '24862' => 'WV',
        '24866' => 'WV',
        '24867' => 'WV',
        '24868' => 'WV',
        '24869' => 'WV',
        '24870' => 'WV',
        '24871' => 'WV',
        '24872' => 'WV',
        '24873' => 'WV',
        '24874' => 'WV',
        '24878' => 'WV',
        '24879' => 'WV',
        '24880' => 'WV',
        '24881' => 'WV',
        '24882' => 'WV',
        '24884' => 'WV',
        '24887' => 'WV',
        '24888' => 'WV',
        '24892' => 'WV',
        '24894' => 'WV',
        '24895' => 'WV',
        '24898' => 'WV',
        '24901' => 'WV',
        '24910' => 'WV',
        '24915' => 'WV',
        '24916' => 'WV',
        '24918' => 'WV',
        '24920' => 'WV',
        '24924' => 'WV',
        '24925' => 'WV',
        '24927' => 'WV',
        '24931' => 'WV',
        '24934' => 'WV',
        '24935' => 'WV',
        '24938' => 'WV',
        '24941' => 'WV',
        '24943' => 'WV',
        '24944' => 'WV',
        '24945' => 'WV',
        '24946' => 'WV',
        '24951' => 'WV',
        '24954' => 'WV',
        '24957' => 'WV',
        '24962' => 'WV',
        '24963' => 'WV',
        '24966' => 'WV',
        '24970' => 'WV',
        '24974' => 'WV',
        '24976' => 'WV',
        '24977' => 'WV',
        '24981' => 'WV',
        '24983' => 'WV',
        '24984' => 'WV',
        '24985' => 'WV',
        '24986' => 'WV',
        '24991' => 'WV',
        '24993' => 'WV',
        '25002' => 'WV',
        '25003' => 'WV',
        '25005' => 'WV',
        '25007' => 'WV',
        '25008' => 'WV',
        '25009' => 'WV',
        '25011' => 'WV',
        '25015' => 'WV',
        '25019' => 'WV',
        '25021' => 'WV',
        '25022' => 'WV',
        '25024' => 'WV',
        '25025' => 'WV',
        '25028' => 'WV',
        '25030' => 'WV',
        '25031' => 'WV',
        '25033' => 'WV',
        '25035' => 'WV',
        '25036' => 'WV',
        '25039' => 'WV',
        '25040' => 'WV',
        '25043' => 'WV',
        '25044' => 'WV',
        '25045' => 'WV',
        '25047' => 'WV',
        '25048' => 'WV',
        '25049' => 'WV',
        '25051' => 'WV',
        '25053' => 'WV',
        '25054' => 'WV',
        '25057' => 'WV',
        '25059' => 'WV',
        '25060' => 'WV',
        '25061' => 'WV',
        '25062' => 'WV',
        '25063' => 'WV',
        '25064' => 'WV',
        '25067' => 'WV',
        '25070' => 'WV',
        '25071' => 'WV',
        '25075' => 'WV',
        '25076' => 'WV',
        '25081' => 'WV',
        '25082' => 'WV',
        '25083' => 'WV',
        '25085' => 'WV',
        '25086' => 'WV',
        '25088' => 'WV',
        '25090' => 'WV',
        '25093' => 'WV',
        '25102' => 'WV',
        '25103' => 'WV',
        '25106' => 'WV',
        '25107' => 'WV',
        '25108' => 'WV',
        '25109' => 'WV',
        '25110' => 'WV',
        '25111' => 'WV',
        '25112' => 'WV',
        '25113' => 'WV',
        '25114' => 'WV',
        '25115' => 'WV',
        '25118' => 'WV',
        '25119' => 'WV',
        '25121' => 'WV',
        '25123' => 'WV',
        '25124' => 'WV',
        '25125' => 'WV',
        '25126' => 'WV',
        '25130' => 'WV',
        '25132' => 'WV',
        '25133' => 'WV',
        '25134' => 'WV',
        '25136' => 'WV',
        '25139' => 'WV',
        '25140' => 'WV',
        '25141' => 'WV',
        '25142' => 'WV',
        '25143' => 'WV',
        '25148' => 'WV',
        '25149' => 'WV',
        '25152' => 'WV',
        '25154' => 'WV',
        '25156' => 'WV',
        '25159' => 'WV',
        '25160' => 'WV',
        '25161' => 'WV',
        '25162' => 'WV',
        '25164' => 'WV',
        '25165' => 'WV',
        '25168' => 'WV',
        '25169' => 'WV',
        '25173' => 'WV',
        '25174' => 'WV',
        '25177' => 'WV',
        '25180' => 'WV',
        '25181' => 'WV',
        '25183' => 'WV',
        '25185' => 'WV',
        '25186' => 'WV',
        '25187' => 'WV',
        '25193' => 'WV',
        '25201' => 'WV',
        '25202' => 'WV',
        '25203' => 'WV',
        '25204' => 'WV',
        '25205' => 'WV',
        '25206' => 'WV',
        '25208' => 'WV',
        '25209' => 'WV',
        '25211' => 'WV',
        '25213' => 'WV',
        '25214' => 'WV',
        '25231' => 'WV',
        '25234' => 'WV',
        '25235' => 'WV',
        '25239' => 'WV',
        '25241' => 'WV',
        '25243' => 'WV',
        '25244' => 'WV',
        '25245' => 'WV',
        '25247' => 'WV',
        '25248' => 'WV',
        '25251' => 'WV',
        '25252' => 'WV',
        '25253' => 'WV',
        '25259' => 'WV',
        '25260' => 'WV',
        '25261' => 'WV',
        '25262' => 'WV',
        '25264' => 'WV',
        '25265' => 'WV',
        '25266' => 'WV',
        '25267' => 'WV',
        '25268' => 'WV',
        '25270' => 'WV',
        '25271' => 'WV',
        '25275' => 'WV',
        '25276' => 'WV',
        '25285' => 'WV',
        '25286' => 'WV',
        '25287' => 'WV',
        '25301' => 'WV',
        '25302' => 'WV',
        '25303' => 'WV',
        '25304' => 'WV',
        '25305' => 'WV',
        '25306' => 'WV',
        '25309' => 'WV',
        '25311' => 'WV',
        '25312' => 'WV',
        '25313' => 'WV',
        '25314' => 'WV',
        '25315' => 'WV',
        '25320' => 'WV',
        '25387' => 'WV',
        '25401' => 'WV',
        '25403' => 'WV',
        '25404' => 'WV',
        '25405' => 'WV',
        '25411' => 'WV',
        '25413' => 'WV',
        '25414' => 'WV',
        '25419' => 'WV',
        '25420' => 'WV',
        '25421' => 'WV',
        '25422' => 'WV',
        '25425' => 'WV',
        '25427' => 'WV',
        '25428' => 'WV',
        '25430' => 'WV',
        '25431' => 'WV',
        '25432' => 'WV',
        '25434' => 'WV',
        '25437' => 'WV',
        '25438' => 'WV',
        '25442' => 'WV',
        '25443' => 'WV',
        '25444' => 'WV',
        '25446' => 'WV',
        '25501' => 'WV',
        '25502' => 'WV',
        '25503' => 'WV',
        '25504' => 'WV',
        '25505' => 'WV',
        '25506' => 'WV',
        '25507' => 'WV',
        '25508' => 'WV',
        '25510' => 'WV',
        '25511' => 'WV',
        '25512' => 'WV',
        '25514' => 'WV',
        '25515' => 'WV',
        '25517' => 'WV',
        '25520' => 'WV',
        '25521' => 'WV',
        '25523' => 'WV',
        '25524' => 'WV',
        '25526' => 'WV',
        '25529' => 'WV',
        '25530' => 'WV',
        '25534' => 'WV',
        '25535' => 'WV',
        '25537' => 'WV',
        '25540' => 'WV',
        '25541' => 'WV',
        '25544' => 'WV',
        '25545' => 'WV',
        '25547' => 'WV',
        '25550' => 'WV',
        '25555' => 'WV',
        '25557' => 'WV',
        '25559' => 'WV',
        '25560' => 'WV',
        '25564' => 'WV',
        '25565' => 'WV',
        '25567' => 'WV',
        '25570' => 'WV',
        '25571' => 'WV',
        '25573' => 'WV',
        '25601' => 'WV',
        '25606' => 'WV',
        '25607' => 'WV',
        '25608' => 'WV',
        '25611' => 'WV',
        '25612' => 'WV',
        '25617' => 'WV',
        '25621' => 'WV',
        '25624' => 'WV',
        '25625' => 'WV',
        '25628' => 'WV',
        '25630' => 'WV',
        '25632' => 'WV',
        '25634' => 'WV',
        '25635' => 'WV',
        '25637' => 'WV',
        '25638' => 'WV',
        '25639' => 'WV',
        '25644' => 'WV',
        '25646' => 'WV',
        '25647' => 'WV',
        '25649' => 'WV',
        '25650' => 'WV',
        '25651' => 'WV',
        '25652' => 'WV',
        '25653' => 'WV',
        '25654' => 'WV',
        '25661' => 'WV',
        '25666' => 'WV',
        '25667' => 'WV',
        '25669' => 'WV',
        '25670' => 'WV',
        '25671' => 'WV',
        '25672' => 'WV',
        '25674' => 'WV',
        '25676' => 'WV',
        '25678' => 'WV',
        '25685' => 'WV',
        '25688' => 'WV',
        '25690' => 'WV',
        '25692' => 'WV',
        '25696' => 'WV',
        '25699' => 'WV',
        '25701' => 'WV',
        '25702' => 'WV',
        '25703' => 'WV',
        '25704' => 'WV',
        '25705' => 'WV',
        '25755' => 'WV',
        '25801' => 'WV',
        '25810' => 'WV',
        '25811' => 'WV',
        '25812' => 'WV',
        '25813' => 'WV',
        '25817' => 'WV',
        '25818' => 'WV',
        '25820' => 'WV',
        '25823' => 'WV',
        '25825' => 'WV',
        '25826' => 'WV',
        '25827' => 'WV',
        '25831' => 'WV',
        '25832' => 'WV',
        '25836' => 'WV',
        '25837' => 'WV',
        '25839' => 'WV',
        '25840' => 'WV',
        '25841' => 'WV',
        '25843' => 'WV',
        '25844' => 'WV',
        '25845' => 'WV',
        '25846' => 'WV',
        '25848' => 'WV',
        '25849' => 'WV',
        '25851' => 'WV',
        '25853' => 'WV',
        '25854' => 'WV',
        '25855' => 'WV',
        '25857' => 'WV',
        '25862' => 'WV',
        '25864' => 'WV',
        '25865' => 'WV',
        '25866' => 'WV',
        '25868' => 'WV',
        '25870' => 'WV',
        '25871' => 'WV',
        '25873' => 'WV',
        '25875' => 'WV',
        '25876' => 'WV',
        '25878' => 'WV',
        '25879' => 'WV',
        '25880' => 'WV',
        '25882' => 'WV',
        '25901' => 'WV',
        '25902' => 'WV',
        '25904' => 'WV',
        '25907' => 'WV',
        '25908' => 'WV',
        '25909' => 'WV',
        '25911' => 'WV',
        '25913' => 'WV',
        '25915' => 'WV',
        '25916' => 'WV',
        '25917' => 'WV',
        '25918' => 'WV',
        '25920' => 'WV',
        '25921' => 'WV',
        '25922' => 'WV',
        '25928' => 'WV',
        '25932' => 'WV',
        '25936' => 'WV',
        '25938' => 'WV',
        '25942' => 'WV',
        '25943' => 'WV',
        '25951' => 'WV',
        '25958' => 'WV',
        '25962' => 'WV',
        '25966' => 'WV',
        '25969' => 'WV',
        '25971' => 'WV',
        '25972' => 'WV',
        '25976' => 'WV',
        '25977' => 'WV',
        '25978' => 'WV',
        '25979' => 'WV',
        '25981' => 'WV',
        '25984' => 'WV',
        '25985' => 'WV',
        '25986' => 'WV',
        '25989' => 'WV',
        '26003' => 'WV',
        '26030' => 'WV',
        '26031' => 'WV',
        '26032' => 'WV',
        '26033' => 'WV',
        '26034' => 'WV',
        '26035' => 'WV',
        '26036' => 'WV',
        '26037' => 'WV',
        '26038' => 'WV',
        '26039' => 'WV',
        '26040' => 'WV',
        '26041' => 'WV',
        '26047' => 'WV',
        '26050' => 'WV',
        '26055' => 'WV',
        '26056' => 'WV',
        '26058' => 'WV',
        '26059' => 'WV',
        '26060' => 'WV',
        '26062' => 'WV',
        '26070' => 'WV',
        '26074' => 'WV',
        '26075' => 'WV',
        '26101' => 'WV',
        '26104' => 'WV',
        '26105' => 'WV',
        '26133' => 'WV',
        '26134' => 'WV',
        '26136' => 'WV',
        '26137' => 'WV',
        '26138' => 'WV',
        '26141' => 'WV',
        '26142' => 'WV',
        '26143' => 'WV',
        '26146' => 'WV',
        '26147' => 'WV',
        '26148' => 'WV',
        '26149' => 'WV',
        '26150' => 'WV',
        '26151' => 'WV',
        '26152' => 'WV',
        '26155' => 'WV',
        '26159' => 'WV',
        '26160' => 'WV',
        '26161' => 'WV',
        '26162' => 'WV',
        '26164' => 'WV',
        '26167' => 'WV',
        '26169' => 'WV',
        '26170' => 'WV',
        '26175' => 'WV',
        '26178' => 'WV',
        '26180' => 'WV',
        '26181' => 'WV',
        '26184' => 'WV',
        '26187' => 'WV',
        '26201' => 'WV',
        '26202' => 'WV',
        '26203' => 'WV',
        '26205' => 'WV',
        '26206' => 'WV',
        '26208' => 'WV',
        '26209' => 'WV',
        '26210' => 'WV',
        '26215' => 'WV',
        '26217' => 'WV',
        '26218' => 'WV',
        '26222' => 'WV',
        '26224' => 'WV',
        '26228' => 'WV',
        '26230' => 'WV',
        '26234' => 'WV',
        '26236' => 'WV',
        '26237' => 'WV',
        '26238' => 'WV',
        '26241' => 'WV',
        '26250' => 'WV',
        '26253' => 'WV',
        '26254' => 'WV',
        '26257' => 'WV',
        '26259' => 'WV',
        '26260' => 'WV',
        '26261' => 'WV',
        '26263' => 'WV',
        '26264' => 'WV',
        '26266' => 'WV',
        '26267' => 'WV',
        '26268' => 'WV',
        '26269' => 'WV',
        '26270' => 'WV',
        '26271' => 'WV',
        '26273' => 'WV',
        '26275' => 'WV',
        '26276' => 'WV',
        '26278' => 'WV',
        '26280' => 'WV',
        '26282' => 'WV',
        '26283' => 'WV',
        '26285' => 'WV',
        '26287' => 'WV',
        '26288' => 'WV',
        '26289' => 'WV',
        '26291' => 'WV',
        '26292' => 'WV',
        '26293' => 'WV',
        '26294' => 'WV',
        '26296' => 'WV',
        '26298' => 'WV',
        '26301' => 'WV',
        '26320' => 'WV',
        '26321' => 'WV',
        '26323' => 'WV',
        '26325' => 'WV',
        '26327' => 'WV',
        '26330' => 'WV',
        '26335' => 'WV',
        '26337' => 'WV',
        '26338' => 'WV',
        '26339' => 'WV',
        '26342' => 'WV',
        '26343' => 'WV',
        '26346' => 'WV',
        '26347' => 'WV',
        '26348' => 'WV',
        '26349' => 'WV',
        '26351' => 'WV',
        '26354' => 'WV',
        '26361' => 'WV',
        '26362' => 'WV',
        '26366' => 'WV',
        '26369' => 'WV',
        '26372' => 'WV',
        '26374' => 'WV',
        '26376' => 'WV',
        '26377' => 'WV',
        '26378' => 'WV',
        '26384' => 'WV',
        '26385' => 'WV',
        '26386' => 'WV',
        '26404' => 'WV',
        '26405' => 'WV',
        '26408' => 'WV',
        '26410' => 'WV',
        '26411' => 'WV',
        '26412' => 'WV',
        '26415' => 'WV',
        '26416' => 'WV',
        '26419' => 'WV',
        '26421' => 'WV',
        '26422' => 'WV',
        '26424' => 'WV',
        '26425' => 'WV',
        '26426' => 'WV',
        '26430' => 'WV',
        '26431' => 'WV',
        '26435' => 'WV',
        '26436' => 'WV',
        '26437' => 'WV',
        '26438' => 'WV',
        '26440' => 'WV',
        '26443' => 'WV',
        '26444' => 'WV',
        '26447' => 'WV',
        '26448' => 'WV',
        '26451' => 'WV',
        '26452' => 'WV',
        '26456' => 'WV',
        '26463' => 'WV',
        '26501' => 'WV',
        '26505' => 'WV',
        '26506' => 'WV',
        '26508' => 'WV',
        '26519' => 'WV',
        '26520' => 'WV',
        '26521' => 'WV',
        '26524' => 'WV',
        '26525' => 'WV',
        '26534' => 'WV',
        '26537' => 'WV',
        '26541' => 'WV',
        '26542' => 'WV',
        '26543' => 'WV',
        '26544' => 'WV',
        '26546' => 'WV',
        '26547' => 'WV',
        '26554' => 'WV',
        '26559' => 'WV',
        '26560' => 'WV',
        '26562' => 'WV',
        '26563' => 'WV',
        '26568' => 'WV',
        '26570' => 'WV',
        '26571' => 'WV',
        '26572' => 'WV',
        '26574' => 'WV',
        '26575' => 'WV',
        '26576' => 'WV',
        '26581' => 'WV',
        '26582' => 'WV',
        '26585' => 'WV',
        '26586' => 'WV',
        '26587' => 'WV',
        '26588' => 'WV',
        '26590' => 'WV',
        '26591' => 'WV',
        '26601' => 'WV',
        '26610' => 'WV',
        '26611' => 'WV',
        '26615' => 'WV',
        '26617' => 'WV',
        '26619' => 'WV',
        '26621' => 'WV',
        '26623' => 'WV',
        '26624' => 'WV',
        '26627' => 'WV',
        '26629' => 'WV',
        '26631' => 'WV',
        '26636' => 'WV',
        '26638' => 'WV',
        '26651' => 'WV',
        '26656' => 'WV',
        '26660' => 'WV',
        '26662' => 'WV',
        '26667' => 'WV',
        '26671' => 'WV',
        '26676' => 'WV',
        '26678' => 'WV',
        '26679' => 'WV',
        '26680' => 'WV',
        '26681' => 'WV',
        '26684' => 'WV',
        '26690' => 'WV',
        '26691' => 'WV',
        '26704' => 'WV',
        '26705' => 'WV',
        '26707' => 'WV',
        '26710' => 'WV',
        '26711' => 'WV',
        '26714' => 'WV',
        '26716' => 'WV',
        '26717' => 'WV',
        '26719' => 'WV',
        '26720' => 'WV',
        '26722' => 'WV',
        '26726' => 'WV',
        '26731' => 'WV',
        '26739' => 'WV',
        '26743' => 'WV',
        '26750' => 'WV',
        '26753' => 'WV',
        '26755' => 'WV',
        '26757' => 'WV',
        '26761' => 'WV',
        '26763' => 'WV',
        '26764' => 'WV',
        '26767' => 'WV',
        '26801' => 'WV',
        '26802' => 'WV',
        '26804' => 'WV',
        '26807' => 'WV',
        '26808' => 'WV',
        '26810' => 'WV',
        '26812' => 'WV',
        '26814' => 'WV',
        '26815' => 'WV',
        '26817' => 'WV',
        '26818' => 'WV',
        '26823' => 'WV',
        '26833' => 'WV',
        '26836' => 'WV',
        '26838' => 'WV',
        '26845' => 'WV',
        '26847' => 'WV',
        '26851' => 'WV',
        '26852' => 'WV',
        '26855' => 'WV',
        '26865' => 'WV',
        '26866' => 'WV',
        '26884' => 'WV',
        '26886' => 'WV',
        '27006' => 'NC',
        '27007' => 'NC',
        '27009' => 'NC',
        '27011' => 'NC',
        '27012' => 'NC',
        '27013' => 'NC',
        '27014' => 'NC',
        '27016' => 'NC',
        '27017' => 'NC',
        '27018' => 'NC',
        '27019' => 'NC',
        '27020' => 'NC',
        '27021' => 'NC',
        '27022' => 'NC',
        '27023' => 'NC',
        '27024' => 'NC',
        '27025' => 'NC',
        '27027' => 'NC',
        '27028' => 'NC',
        '27030' => 'NC',
        '27040' => 'NC',
        '27041' => 'NC',
        '27042' => 'NC',
        '27043' => 'NC',
        '27045' => 'NC',
        '27046' => 'NC',
        '27047' => 'NC',
        '27048' => 'NC',
        '27050' => 'NC',
        '27051' => 'NC',
        '27052' => 'NC',
        '27053' => 'NC',
        '27054' => 'NC',
        '27055' => 'NC',
        '27101' => 'NC',
        '27103' => 'NC',
        '27104' => 'NC',
        '27105' => 'NC',
        '27106' => 'NC',
        '27107' => 'NC',
        '27109' => 'NC',
        '27110' => 'NC',
        '27127' => 'NC',
        '27201' => 'NC',
        '27202' => 'NC',
        '27203' => 'NC',
        '27205' => 'NC',
        '27207' => 'NC',
        '27208' => 'NC',
        '27209' => 'NC',
        '27212' => 'NC',
        '27213' => 'NC',
        '27214' => 'NC',
        '27215' => 'NC',
        '27217' => 'NC',
        '27229' => 'NC',
        '27231' => 'NC',
        '27233' => 'NC',
        '27235' => 'NC',
        '27239' => 'NC',
        '27242' => 'NC',
        '27243' => 'NC',
        '27244' => 'NC',
        '27247' => 'NC',
        '27248' => 'NC',
        '27249' => 'NC',
        '27252' => 'NC',
        '27253' => 'NC',
        '27256' => 'NC',
        '27258' => 'NC',
        '27259' => 'NC',
        '27260' => 'NC',
        '27262' => 'NC',
        '27263' => 'NC',
        '27265' => 'NC',
        '27268' => 'NC',
        '27278' => 'NC',
        '27281' => 'NC',
        '27282' => 'NC',
        '27283' => 'NC',
        '27284' => 'NC',
        '27288' => 'NC',
        '27291' => 'NC',
        '27292' => 'NC',
        '27295' => 'NC',
        '27298' => 'NC',
        '27299' => 'NC',
        '27301' => 'NC',
        '27302' => 'NC',
        '27305' => 'NC',
        '27306' => 'NC',
        '27310' => 'NC',
        '27311' => 'NC',
        '27312' => 'NC',
        '27313' => 'NC',
        '27314' => 'NC',
        '27315' => 'NC',
        '27316' => 'NC',
        '27317' => 'NC',
        '27320' => 'NC',
        '27325' => 'NC',
        '27326' => 'NC',
        '27330' => 'NC',
        '27332' => 'NC',
        '27340' => 'NC',
        '27341' => 'NC',
        '27342' => 'NC',
        '27343' => 'NC',
        '27344' => 'NC',
        '27349' => 'NC',
        '27350' => 'NC',
        '27351' => 'NC',
        '27355' => 'NC',
        '27356' => 'NC',
        '27357' => 'NC',
        '27358' => 'NC',
        '27360' => 'NC',
        '27370' => 'NC',
        '27371' => 'NC',
        '27374' => 'NC',
        '27376' => 'NC',
        '27377' => 'NC',
        '27379' => 'NC',
        '27401' => 'NC',
        '27403' => 'NC',
        '27405' => 'NC',
        '27406' => 'NC',
        '27407' => 'NC',
        '27408' => 'NC',
        '27409' => 'NC',
        '27410' => 'NC',
        '27411' => 'NC',
        '27412' => 'NC',
        '27455' => 'NC',
        '27501' => 'NC',
        '27502' => 'NC',
        '27503' => 'NC',
        '27504' => 'NC',
        '27505' => 'NC',
        '27506' => 'NC',
        '27507' => 'NC',
        '27508' => 'NC',
        '27509' => 'NC',
        '27510' => 'NC',
        '27511' => 'NC',
        '27513' => 'NC',
        '27514' => 'NC',
        '27516' => 'NC',
        '27517' => 'NC',
        '27518' => 'NC',
        '27519' => 'NC',
        '27520' => 'NC',
        '27521' => 'NC',
        '27522' => 'NC',
        '27523' => 'NC',
        '27524' => 'NC',
        '27525' => 'NC',
        '27526' => 'NC',
        '27527' => 'NC',
        '27529' => 'NC',
        '27530' => 'NC',
        '27531' => 'NC',
        '27533' => 'NC',
        '27534' => 'NC',
        '27536' => 'NC',
        '27537' => 'NC',
        '27539' => 'NC',
        '27540' => 'NC',
        '27541' => 'NC',
        '27542' => 'NC',
        '27544' => 'NC',
        '27545' => 'NC',
        '27546' => 'NC',
        '27549' => 'NC',
        '27551' => 'NC',
        '27553' => 'NC',
        '27555' => 'NC',
        '27556' => 'NC',
        '27557' => 'NC',
        '27559' => 'NC',
        '27560' => 'NC',
        '27562' => 'NC',
        '27563' => 'NC',
        '27565' => 'NC',
        '27568' => 'NC',
        '27569' => 'NC',
        '27570' => 'NC',
        '27571' => 'NC',
        '27572' => 'NC',
        '27573' => 'NC',
        '27574' => 'NC',
        '27576' => 'NC',
        '27577' => 'NC',
        '27581' => 'NC',
        '27582' => 'NC',
        '27583' => 'NC',
        '27584' => 'NC',
        '27587' => 'NC',
        '27589' => 'NC',
        '27591' => 'NC',
        '27592' => 'NC',
        '27593' => 'NC',
        '27594' => 'NC',
        '27596' => 'NC',
        '27597' => 'NC',
        '27599' => 'NC',
        '27601' => 'NC',
        '27603' => 'NC',
        '27604' => 'NC',
        '27605' => 'NC',
        '27606' => 'NC',
        '27607' => 'NC',
        '27608' => 'NC',
        '27609' => 'NC',
        '27610' => 'NC',
        '27612' => 'NC',
        '27613' => 'NC',
        '27614' => 'NC',
        '27615' => 'NC',
        '27616' => 'NC',
        '27617' => 'NC',
        '27695' => 'NC',
        '27697' => 'NC',
        '27701' => 'NC',
        '27703' => 'NC',
        '27704' => 'NC',
        '27705' => 'NC',
        '27707' => 'NC',
        '27708' => 'NC',
        '27709' => 'NC',
        '27712' => 'NC',
        '27713' => 'NC',
        '27801' => 'NC',
        '27803' => 'NC',
        '27804' => 'NC',
        '27805' => 'NC',
        '27806' => 'NC',
        '27807' => 'NC',
        '27808' => 'NC',
        '27809' => 'NC',
        '27810' => 'NC',
        '27812' => 'NC',
        '27813' => 'NC',
        '27814' => 'NC',
        '27815' => 'NC',
        '27816' => 'NC',
        '27817' => 'NC',
        '27818' => 'NC',
        '27819' => 'NC',
        '27820' => 'NC',
        '27821' => 'NC',
        '27822' => 'NC',
        '27823' => 'NC',
        '27824' => 'NC',
        '27825' => 'NC',
        '27826' => 'NC',
        '27827' => 'NC',
        '27828' => 'NC',
        '27829' => 'NC',
        '27830' => 'NC',
        '27831' => 'NC',
        '27832' => 'NC',
        '27834' => 'NC',
        '27837' => 'NC',
        '27839' => 'NC',
        '27840' => 'NC',
        '27841' => 'NC',
        '27842' => 'NC',
        '27843' => 'NC',
        '27844' => 'NC',
        '27845' => 'NC',
        '27846' => 'NC',
        '27847' => 'NC',
        '27849' => 'NC',
        '27850' => 'NC',
        '27851' => 'NC',
        '27852' => 'NC',
        '27853' => 'NC',
        '27855' => 'NC',
        '27856' => 'NC',
        '27857' => 'NC',
        '27858' => 'NC',
        '27860' => 'NC',
        '27861' => 'NC',
        '27862' => 'NC',
        '27863' => 'NC',
        '27864' => 'NC',
        '27865' => 'NC',
        '27866' => 'NC',
        '27869' => 'NC',
        '27870' => 'NC',
        '27871' => 'NC',
        '27872' => 'NC',
        '27873' => 'NC',
        '27874' => 'NC',
        '27875' => 'NC',
        '27876' => 'NC',
        '27877' => 'NC',
        '27878' => 'NC',
        '27879' => 'NC',
        '27880' => 'NC',
        '27881' => 'NC',
        '27882' => 'NC',
        '27883' => 'NC',
        '27884' => 'NC',
        '27885' => 'NC',
        '27886' => 'NC',
        '27888' => 'NC',
        '27889' => 'NC',
        '27890' => 'NC',
        '27891' => 'NC',
        '27892' => 'NC',
        '27893' => 'NC',
        '27896' => 'NC',
        '27897' => 'NC',
        '27909' => 'NC',
        '27910' => 'NC',
        '27915' => 'NC',
        '27916' => 'NC',
        '27917' => 'NC',
        '27919' => 'NC',
        '27920' => 'NC',
        '27921' => 'NC',
        '27922' => 'NC',
        '27923' => 'NC',
        '27924' => 'NC',
        '27925' => 'NC',
        '27926' => 'NC',
        '27927' => 'NC',
        '27928' => 'NC',
        '27929' => 'NC',
        '27932' => 'NC',
        '27935' => 'NC',
        '27936' => 'NC',
        '27937' => 'NC',
        '27938' => 'NC',
        '27939' => 'NC',
        '27941' => 'NC',
        '27942' => 'NC',
        '27943' => 'NC',
        '27944' => 'NC',
        '27946' => 'NC',
        '27947' => 'NC',
        '27948' => 'NC',
        '27949' => 'NC',
        '27950' => 'NC',
        '27953' => 'NC',
        '27954' => 'NC',
        '27956' => 'NC',
        '27957' => 'NC',
        '27958' => 'NC',
        '27959' => 'NC',
        '27960' => 'NC',
        '27962' => 'NC',
        '27964' => 'NC',
        '27965' => 'NC',
        '27966' => 'NC',
        '27967' => 'NC',
        '27968' => 'NC',
        '27969' => 'NC',
        '27970' => 'NC',
        '27972' => 'NC',
        '27973' => 'NC',
        '27974' => 'NC',
        '27976' => 'NC',
        '27978' => 'NC',
        '27979' => 'NC',
        '27980' => 'NC',
        '27981' => 'NC',
        '27982' => 'NC',
        '27983' => 'NC',
        '27985' => 'NC',
        '27986' => 'NC',
        '28001' => 'NC',
        '28006' => 'NC',
        '28007' => 'NC',
        '28009' => 'NC',
        '28012' => 'NC',
        '28016' => 'NC',
        '28017' => 'NC',
        '28018' => 'NC',
        '28019' => 'NC',
        '28020' => 'NC',
        '28021' => 'NC',
        '28023' => 'NC',
        '28024' => 'NC',
        '28025' => 'NC',
        '28027' => 'NC',
        '28031' => 'NC',
        '28032' => 'NC',
        '28033' => 'NC',
        '28034' => 'NC',
        '28036' => 'NC',
        '28037' => 'NC',
        '28039' => 'NC',
        '28040' => 'NC',
        '28041' => 'NC',
        '28042' => 'NC',
        '28043' => 'NC',
        '28052' => 'NC',
        '28054' => 'NC',
        '28056' => 'NC',
        '28071' => 'NC',
        '28072' => 'NC',
        '28073' => 'NC',
        '28074' => 'NC',
        '28075' => 'NC',
        '28076' => 'NC',
        '28077' => 'NC',
        '28078' => 'NC',
        '28079' => 'NC',
        '28080' => 'NC',
        '28081' => 'NC',
        '28083' => 'NC',
        '28086' => 'NC',
        '28088' => 'NC',
        '28089' => 'NC',
        '28090' => 'NC',
        '28091' => 'NC',
        '28092' => 'NC',
        '28097' => 'NC',
        '28098' => 'NC',
        '28101' => 'NC',
        '28102' => 'NC',
        '28103' => 'NC',
        '28104' => 'NC',
        '28105' => 'NC',
        '28107' => 'NC',
        '28108' => 'NC',
        '28109' => 'NC',
        '28110' => 'NC',
        '28112' => 'NC',
        '28114' => 'NC',
        '28115' => 'NC',
        '28117' => 'NC',
        '28119' => 'NC',
        '28120' => 'NC',
        '28124' => 'NC',
        '28125' => 'NC',
        '28127' => 'NC',
        '28128' => 'NC',
        '28129' => 'NC',
        '28133' => 'NC',
        '28134' => 'NC',
        '28135' => 'NC',
        '28136' => 'NC',
        '28137' => 'NC',
        '28138' => 'NC',
        '28139' => 'NC',
        '28144' => 'NC',
        '28146' => 'NC',
        '28147' => 'NC',
        '28150' => 'NC',
        '28152' => 'NC',
        '28159' => 'NC',
        '28160' => 'NC',
        '28163' => 'NC',
        '28164' => 'NC',
        '28166' => 'NC',
        '28167' => 'NC',
        '28168' => 'NC',
        '28169' => 'NC',
        '28170' => 'NC',
        '28173' => 'NC',
        '28174' => 'NC',
        '28202' => 'NC',
        '28203' => 'NC',
        '28204' => 'NC',
        '28205' => 'NC',
        '28206' => 'NC',
        '28207' => 'NC',
        '28208' => 'NC',
        '28209' => 'NC',
        '28210' => 'NC',
        '28211' => 'NC',
        '28212' => 'NC',
        '28213' => 'NC',
        '28214' => 'NC',
        '28215' => 'NC',
        '28216' => 'NC',
        '28217' => 'NC',
        '28223' => 'NC',
        '28226' => 'NC',
        '28227' => 'NC',
        '28244' => 'NC',
        '28262' => 'NC',
        '28269' => 'NC',
        '28270' => 'NC',
        '28273' => 'NC',
        '28274' => 'NC',
        '28277' => 'NC',
        '28278' => 'NC',
        '28280' => 'NC',
        '28282' => 'NC',
        '28301' => 'NC',
        '28303' => 'NC',
        '28304' => 'NC',
        '28305' => 'NC',
        '28306' => 'NC',
        '28307' => 'NC',
        '28308' => 'NC',
        '28310' => 'NC',
        '28311' => 'NC',
        '28312' => 'NC',
        '28314' => 'NC',
        '28315' => 'NC',
        '28318' => 'NC',
        '28320' => 'NC',
        '28323' => 'NC',
        '28325' => 'NC',
        '28326' => 'NC',
        '28327' => 'NC',
        '28328' => 'NC',
        '28330' => 'NC',
        '28331' => 'NC',
        '28332' => 'NC',
        '28333' => 'NC',
        '28334' => 'NC',
        '28337' => 'NC',
        '28338' => 'NC',
        '28339' => 'NC',
        '28340' => 'NC',
        '28341' => 'NC',
        '28342' => 'NC',
        '28343' => 'NC',
        '28344' => 'NC',
        '28345' => 'NC',
        '28347' => 'NC',
        '28348' => 'NC',
        '28349' => 'NC',
        '28350' => 'NC',
        '28351' => 'NC',
        '28352' => 'NC',
        '28355' => 'NC',
        '28356' => 'NC',
        '28357' => 'NC',
        '28358' => 'NC',
        '28359' => 'NC',
        '28360' => 'NC',
        '28362' => 'NC',
        '28363' => 'NC',
        '28364' => 'NC',
        '28365' => 'NC',
        '28366' => 'NC',
        '28367' => 'NC',
        '28368' => 'NC',
        '28369' => 'NC',
        '28371' => 'NC',
        '28372' => 'NC',
        '28373' => 'NC',
        '28374' => 'NC',
        '28375' => 'NC',
        '28376' => 'NC',
        '28377' => 'NC',
        '28378' => 'NC',
        '28379' => 'NC',
        '28382' => 'NC',
        '28383' => 'NC',
        '28384' => 'NC',
        '28385' => 'NC',
        '28386' => 'NC',
        '28387' => 'NC',
        '28390' => 'NC',
        '28391' => 'NC',
        '28392' => 'NC',
        '28393' => 'NC',
        '28394' => 'NC',
        '28395' => 'NC',
        '28396' => 'NC',
        '28398' => 'NC',
        '28399' => 'NC',
        '28401' => 'NC',
        '28403' => 'NC',
        '28405' => 'NC',
        '28409' => 'NC',
        '28411' => 'NC',
        '28412' => 'NC',
        '28420' => 'NC',
        '28421' => 'NC',
        '28422' => 'NC',
        '28423' => 'NC',
        '28424' => 'NC',
        '28425' => 'NC',
        '28428' => 'NC',
        '28429' => 'NC',
        '28430' => 'NC',
        '28431' => 'NC',
        '28432' => 'NC',
        '28433' => 'NC',
        '28434' => 'NC',
        '28435' => 'NC',
        '28436' => 'NC',
        '28438' => 'NC',
        '28439' => 'NC',
        '28441' => 'NC',
        '28442' => 'NC',
        '28443' => 'NC',
        '28444' => 'NC',
        '28445' => 'NC',
        '28447' => 'NC',
        '28448' => 'NC',
        '28449' => 'NC',
        '28450' => 'NC',
        '28451' => 'NC',
        '28452' => 'NC',
        '28453' => 'NC',
        '28454' => 'NC',
        '28455' => 'NC',
        '28456' => 'NC',
        '28457' => 'NC',
        '28458' => 'NC',
        '28460' => 'NC',
        '28461' => 'NC',
        '28462' => 'NC',
        '28463' => 'NC',
        '28464' => 'NC',
        '28465' => 'NC',
        '28466' => 'NC',
        '28467' => 'NC',
        '28468' => 'NC',
        '28469' => 'NC',
        '28470' => 'NC',
        '28472' => 'NC',
        '28478' => 'NC',
        '28479' => 'NC',
        '28480' => 'NC',
        '28501' => 'NC',
        '28504' => 'NC',
        '28508' => 'NC',
        '28509' => 'NC',
        '28510' => 'NC',
        '28511' => 'NC',
        '28512' => 'NC',
        '28513' => 'NC',
        '28515' => 'NC',
        '28516' => 'NC',
        '28518' => 'NC',
        '28519' => 'NC',
        '28520' => 'NC',
        '28521' => 'NC',
        '28523' => 'NC',
        '28524' => 'NC',
        '28525' => 'NC',
        '28526' => 'NC',
        '28527' => 'NC',
        '28528' => 'NC',
        '28529' => 'NC',
        '28530' => 'NC',
        '28531' => 'NC',
        '28532' => 'NC',
        '28533' => 'NC',
        '28537' => 'NC',
        '28538' => 'NC',
        '28539' => 'NC',
        '28540' => 'NC',
        '28542' => 'NC',
        '28543' => 'NC',
        '28544' => 'NC',
        '28546' => 'NC',
        '28547' => 'NC',
        '28551' => 'NC',
        '28552' => 'NC',
        '28553' => 'NC',
        '28554' => 'NC',
        '28555' => 'NC',
        '28556' => 'NC',
        '28557' => 'NC',
        '28560' => 'NC',
        '28562' => 'NC',
        '28570' => 'NC',
        '28571' => 'NC',
        '28572' => 'NC',
        '28573' => 'NC',
        '28574' => 'NC',
        '28575' => 'NC',
        '28577' => 'NC',
        '28578' => 'NC',
        '28579' => 'NC',
        '28580' => 'NC',
        '28581' => 'NC',
        '28582' => 'NC',
        '28584' => 'NC',
        '28585' => 'NC',
        '28586' => 'NC',
        '28587' => 'NC',
        '28589' => 'NC',
        '28590' => 'NC',
        '28594' => 'NC',
        '28601' => 'NC',
        '28602' => 'NC',
        '28604' => 'NC',
        '28605' => 'NC',
        '28606' => 'NC',
        '28607' => 'NC',
        '28609' => 'NC',
        '28610' => 'NC',
        '28611' => 'NC',
        '28612' => 'NC',
        '28613' => 'NC',
        '28615' => 'NC',
        '28616' => 'NC',
        '28617' => 'NC',
        '28618' => 'NC',
        '28619' => 'NC',
        '28621' => 'NC',
        '28622' => 'NC',
        '28623' => 'NC',
        '28624' => 'NC',
        '28625' => 'NC',
        '28626' => 'NC',
        '28627' => 'NC',
        '28628' => 'NC',
        '28629' => 'NC',
        '28630' => 'NC',
        '28631' => 'NC',
        '28634' => 'NC',
        '28635' => 'NC',
        '28636' => 'NC',
        '28637' => 'NC',
        '28638' => 'NC',
        '28640' => 'NC',
        '28641' => 'NC',
        '28642' => 'NC',
        '28643' => 'NC',
        '28644' => 'NC',
        '28645' => 'NC',
        '28646' => 'NC',
        '28649' => 'NC',
        '28650' => 'NC',
        '28651' => 'NC',
        '28652' => 'NC',
        '28653' => 'NC',
        '28654' => 'NC',
        '28655' => 'NC',
        '28657' => 'NC',
        '28658' => 'NC',
        '28659' => 'NC',
        '28660' => 'NC',
        '28662' => 'NC',
        '28663' => 'NC',
        '28664' => 'NC',
        '28665' => 'NC',
        '28666' => 'NC',
        '28667' => 'NC',
        '28668' => 'NC',
        '28669' => 'NC',
        '28670' => 'NC',
        '28671' => 'NC',
        '28672' => 'NC',
        '28673' => 'NC',
        '28675' => 'NC',
        '28676' => 'NC',
        '28677' => 'NC',
        '28678' => 'NC',
        '28679' => 'NC',
        '28681' => 'NC',
        '28682' => 'NC',
        '28683' => 'NC',
        '28684' => 'NC',
        '28685' => 'NC',
        '28689' => 'NC',
        '28690' => 'NC',
        '28692' => 'NC',
        '28693' => 'NC',
        '28694' => 'NC',
        '28697' => 'NC',
        '28698' => 'NC',
        '28701' => 'NC',
        '28702' => 'NC',
        '28704' => 'NC',
        '28705' => 'NC',
        '28707' => 'NC',
        '28708' => 'NC',
        '28709' => 'NC',
        '28710' => 'NC',
        '28711' => 'NC',
        '28712' => 'NC',
        '28713' => 'NC',
        '28714' => 'NC',
        '28715' => 'NC',
        '28716' => 'NC',
        '28717' => 'NC',
        '28718' => 'NC',
        '28719' => 'NC',
        '28720' => 'NC',
        '28721' => 'NC',
        '28722' => 'NC',
        '28723' => 'NC',
        '28725' => 'NC',
        '28726' => 'NC',
        '28729' => 'NC',
        '28730' => 'NC',
        '28731' => 'NC',
        '28732' => 'NC',
        '28733' => 'NC',
        '28734' => 'NC',
        '28735' => 'NC',
        '28736' => 'NC',
        '28739' => 'NC',
        '28740' => 'NC',
        '28741' => 'NC',
        '28742' => 'NC',
        '28743' => 'NC',
        '28745' => 'NC',
        '28746' => 'NC',
        '28747' => 'NC',
        '28748' => 'NC',
        '28749' => 'NC',
        '28751' => 'NC',
        '28752' => 'NC',
        '28753' => 'NC',
        '28754' => 'NC',
        '28755' => 'NC',
        '28756' => 'NC',
        '28757' => 'NC',
        '28758' => 'NC',
        '28759' => 'NC',
        '28761' => 'NC',
        '28762' => 'NC',
        '28763' => 'NC',
        '28766' => 'NC',
        '28768' => 'NC',
        '28770' => 'NC',
        '28771' => 'NC',
        '28772' => 'NC',
        '28773' => 'NC',
        '28774' => 'NC',
        '28775' => 'NC',
        '28777' => 'NC',
        '28778' => 'NC',
        '28779' => 'NC',
        '28781' => 'NC',
        '28782' => 'NC',
        '28783' => 'NC',
        '28785' => 'NC',
        '28786' => 'NC',
        '28787' => 'NC',
        '28788' => 'NC',
        '28789' => 'NC',
        '28790' => 'NC',
        '28791' => 'NC',
        '28792' => 'NC',
        '28801' => 'NC',
        '28803' => 'NC',
        '28804' => 'NC',
        '28805' => 'NC',
        '28806' => 'NC',
        '28901' => 'NC',
        '28902' => 'NC',
        '28904' => 'NC',
        '28905' => 'NC',
        '28906' => 'NC',
        '28909' => 'NC',
        '29001' => 'SC',
        '29003' => 'SC',
        '29006' => 'SC',
        '29009' => 'SC',
        '29010' => 'SC',
        '29014' => 'SC',
        '29015' => 'SC',
        '29016' => 'SC',
        '29018' => 'SC',
        '29020' => 'SC',
        '29030' => 'SC',
        '29031' => 'SC',
        '29032' => 'SC',
        '29033' => 'SC',
        '29036' => 'SC',
        '29037' => 'SC',
        '29038' => 'SC',
        '29039' => 'SC',
        '29040' => 'SC',
        '29042' => 'SC',
        '29044' => 'SC',
        '29045' => 'SC',
        '29046' => 'SC',
        '29047' => 'SC',
        '29048' => 'SC',
        '29051' => 'SC',
        '29052' => 'SC',
        '29053' => 'SC',
        '29054' => 'SC',
        '29055' => 'SC',
        '29056' => 'SC',
        '29058' => 'SC',
        '29059' => 'SC',
        '29061' => 'SC',
        '29062' => 'SC',
        '29063' => 'SC',
        '29065' => 'SC',
        '29067' => 'SC',
        '29069' => 'SC',
        '29070' => 'SC',
        '29072' => 'SC',
        '29073' => 'SC',
        '29074' => 'SC',
        '29075' => 'SC',
        '29078' => 'SC',
        '29079' => 'SC',
        '29080' => 'SC',
        '29081' => 'SC',
        '29082' => 'SC',
        '29101' => 'SC',
        '29102' => 'SC',
        '29104' => 'SC',
        '29105' => 'SC',
        '29107' => 'SC',
        '29108' => 'SC',
        '29111' => 'SC',
        '29112' => 'SC',
        '29113' => 'SC',
        '29114' => 'SC',
        '29115' => 'SC',
        '29117' => 'SC',
        '29118' => 'SC',
        '29122' => 'SC',
        '29123' => 'SC',
        '29125' => 'SC',
        '29126' => 'SC',
        '29127' => 'SC',
        '29128' => 'SC',
        '29129' => 'SC',
        '29130' => 'SC',
        '29133' => 'SC',
        '29135' => 'SC',
        '29137' => 'SC',
        '29138' => 'SC',
        '29142' => 'SC',
        '29145' => 'SC',
        '29146' => 'SC',
        '29148' => 'SC',
        '29150' => 'SC',
        '29152' => 'SC',
        '29153' => 'SC',
        '29154' => 'SC',
        '29160' => 'SC',
        '29161' => 'SC',
        '29162' => 'SC',
        '29163' => 'SC',
        '29164' => 'SC',
        '29166' => 'SC',
        '29168' => 'SC',
        '29169' => 'SC',
        '29170' => 'SC',
        '29172' => 'SC',
        '29175' => 'SC',
        '29177' => 'SC',
        '29178' => 'SC',
        '29180' => 'SC',
        '29201' => 'SC',
        '29203' => 'SC',
        '29204' => 'SC',
        '29205' => 'SC',
        '29206' => 'SC',
        '29207' => 'SC',
        '29208' => 'SC',
        '29209' => 'SC',
        '29210' => 'SC',
        '29212' => 'SC',
        '29223' => 'SC',
        '29225' => 'SC',
        '29229' => 'SC',
        '29301' => 'SC',
        '29302' => 'SC',
        '29303' => 'SC',
        '29306' => 'SC',
        '29307' => 'SC',
        '29316' => 'SC',
        '29320' => 'SC',
        '29321' => 'SC',
        '29322' => 'SC',
        '29323' => 'SC',
        '29324' => 'SC',
        '29325' => 'SC',
        '29329' => 'SC',
        '29330' => 'SC',
        '29331' => 'SC',
        '29332' => 'SC',
        '29333' => 'SC',
        '29334' => 'SC',
        '29335' => 'SC',
        '29338' => 'SC',
        '29340' => 'SC',
        '29341' => 'SC',
        '29346' => 'SC',
        '29349' => 'SC',
        '29351' => 'SC',
        '29353' => 'SC',
        '29355' => 'SC',
        '29356' => 'SC',
        '29360' => 'SC',
        '29364' => 'SC',
        '29365' => 'SC',
        '29368' => 'SC',
        '29369' => 'SC',
        '29370' => 'SC',
        '29372' => 'SC',
        '29373' => 'SC',
        '29374' => 'SC',
        '29375' => 'SC',
        '29376' => 'SC',
        '29377' => 'SC',
        '29378' => 'SC',
        '29379' => 'SC',
        '29384' => 'SC',
        '29385' => 'SC',
        '29388' => 'SC',
        '29401' => 'SC',
        '29403' => 'SC',
        '29404' => 'SC',
        '29405' => 'SC',
        '29406' => 'SC',
        '29407' => 'SC',
        '29409' => 'SC',
        '29410' => 'SC',
        '29412' => 'SC',
        '29414' => 'SC',
        '29418' => 'SC',
        '29420' => 'SC',
        '29424' => 'SC',
        '29425' => 'SC',
        '29426' => 'SC',
        '29429' => 'SC',
        '29431' => 'SC',
        '29432' => 'SC',
        '29434' => 'SC',
        '29435' => 'SC',
        '29436' => 'SC',
        '29437' => 'SC',
        '29438' => 'SC',
        '29439' => 'SC',
        '29440' => 'SC',
        '29445' => 'SC',
        '29446' => 'SC',
        '29448' => 'SC',
        '29449' => 'SC',
        '29450' => 'SC',
        '29451' => 'SC',
        '29452' => 'SC',
        '29453' => 'SC',
        '29455' => 'SC',
        '29456' => 'SC',
        '29458' => 'SC',
        '29461' => 'SC',
        '29464' => 'SC',
        '29466' => 'SC',
        '29468' => 'SC',
        '29469' => 'SC',
        '29470' => 'SC',
        '29471' => 'SC',
        '29472' => 'SC',
        '29474' => 'SC',
        '29475' => 'SC',
        '29477' => 'SC',
        '29479' => 'SC',
        '29481' => 'SC',
        '29482' => 'SC',
        '29483' => 'SC',
        '29485' => 'SC',
        '29486' => 'SC',
        '29487' => 'SC',
        '29488' => 'SC',
        '29492' => 'SC',
        '29493' => 'SC',
        '29501' => 'SC',
        '29505' => 'SC',
        '29506' => 'SC',
        '29510' => 'SC',
        '29511' => 'SC',
        '29512' => 'SC',
        '29516' => 'SC',
        '29518' => 'SC',
        '29519' => 'SC',
        '29520' => 'SC',
        '29525' => 'SC',
        '29526' => 'SC',
        '29527' => 'SC',
        '29530' => 'SC',
        '29532' => 'SC',
        '29536' => 'SC',
        '29540' => 'SC',
        '29541' => 'SC',
        '29543' => 'SC',
        '29544' => 'SC',
        '29545' => 'SC',
        '29546' => 'SC',
        '29547' => 'SC',
        '29550' => 'SC',
        '29554' => 'SC',
        '29555' => 'SC',
        '29556' => 'SC',
        '29560' => 'SC',
        '29563' => 'SC',
        '29564' => 'SC',
        '29565' => 'SC',
        '29566' => 'SC',
        '29567' => 'SC',
        '29568' => 'SC',
        '29569' => 'SC',
        '29570' => 'SC',
        '29571' => 'SC',
        '29572' => 'SC',
        '29574' => 'SC',
        '29575' => 'SC',
        '29576' => 'SC',
        '29577' => 'SC',
        '29579' => 'SC',
        '29580' => 'SC',
        '29581' => 'SC',
        '29582' => 'SC',
        '29583' => 'SC',
        '29584' => 'SC',
        '29585' => 'SC',
        '29588' => 'SC',
        '29589' => 'SC',
        '29590' => 'SC',
        '29591' => 'SC',
        '29592' => 'SC',
        '29593' => 'SC',
        '29594' => 'SC',
        '29596' => 'SC',
        '29601' => 'SC',
        '29605' => 'SC',
        '29607' => 'SC',
        '29609' => 'SC',
        '29611' => 'SC',
        '29613' => 'SC',
        '29614' => 'SC',
        '29615' => 'SC',
        '29617' => 'SC',
        '29620' => 'SC',
        '29621' => 'SC',
        '29624' => 'SC',
        '29625' => 'SC',
        '29626' => 'SC',
        '29627' => 'SC',
        '29628' => 'SC',
        '29630' => 'SC',
        '29631' => 'SC',
        '29634' => 'SC',
        '29635' => 'SC',
        '29638' => 'SC',
        '29639' => 'SC',
        '29640' => 'SC',
        '29642' => 'SC',
        '29643' => 'SC',
        '29644' => 'SC',
        '29645' => 'SC',
        '29646' => 'SC',
        '29649' => 'SC',
        '29650' => 'SC',
        '29651' => 'SC',
        '29653' => 'SC',
        '29654' => 'SC',
        '29655' => 'SC',
        '29657' => 'SC',
        '29658' => 'SC',
        '29659' => 'SC',
        '29661' => 'SC',
        '29662' => 'SC',
        '29664' => 'SC',
        '29665' => 'SC',
        '29666' => 'SC',
        '29667' => 'SC',
        '29669' => 'SC',
        '29670' => 'SC',
        '29671' => 'SC',
        '29672' => 'SC',
        '29673' => 'SC',
        '29676' => 'SC',
        '29678' => 'SC',
        '29680' => 'SC',
        '29681' => 'SC',
        '29682' => 'SC',
        '29683' => 'SC',
        '29684' => 'SC',
        '29685' => 'SC',
        '29686' => 'SC',
        '29687' => 'SC',
        '29689' => 'SC',
        '29690' => 'SC',
        '29691' => 'SC',
        '29692' => 'SC',
        '29693' => 'SC',
        '29696' => 'SC',
        '29697' => 'SC',
        '29702' => 'SC',
        '29704' => 'SC',
        '29706' => 'SC',
        '29707' => 'SC',
        '29708' => 'SC',
        '29709' => 'SC',
        '29710' => 'SC',
        '29712' => 'SC',
        '29714' => 'SC',
        '29715' => 'SC',
        '29717' => 'SC',
        '29718' => 'SC',
        '29720' => 'SC',
        '29724' => 'SC',
        '29726' => 'SC',
        '29727' => 'SC',
        '29728' => 'SC',
        '29729' => 'SC',
        '29730' => 'SC',
        '29732' => 'SC',
        '29733' => 'SC',
        '29741' => 'SC',
        '29742' => 'SC',
        '29743' => 'SC',
        '29745' => 'SC',
        '29801' => 'SC',
        '29803' => 'SC',
        '29805' => 'SC',
        '29809' => 'SC',
        '29810' => 'SC',
        '29812' => 'SC',
        '29816' => 'SC',
        '29817' => 'SC',
        '29819' => 'SC',
        '29821' => 'SC',
        '29824' => 'SC',
        '29826' => 'SC',
        '29827' => 'SC',
        '29828' => 'SC',
        '29829' => 'SC',
        '29831' => 'SC',
        '29832' => 'SC',
        '29834' => 'SC',
        '29835' => 'SC',
        '29836' => 'SC',
        '29838' => 'SC',
        '29840' => 'SC',
        '29841' => 'SC',
        '29842' => 'SC',
        '29843' => 'SC',
        '29844' => 'SC',
        '29845' => 'SC',
        '29847' => 'SC',
        '29848' => 'SC',
        '29849' => 'SC',
        '29851' => 'SC',
        '29853' => 'SC',
        '29856' => 'SC',
        '29860' => 'SC',
        '29899' => 'SC',
        '29902' => 'SC',
        '29904' => 'SC',
        '29905' => 'SC',
        '29906' => 'SC',
        '29907' => 'SC',
        '29909' => 'SC',
        '29910' => 'SC',
        '29911' => 'SC',
        '29912' => 'SC',
        '29915' => 'SC',
        '29916' => 'SC',
        '29918' => 'SC',
        '29920' => 'SC',
        '29921' => 'SC',
        '29922' => 'SC',
        '29923' => 'SC',
        '29924' => 'SC',
        '29926' => 'SC',
        '29927' => 'SC',
        '29928' => 'SC',
        '29929' => 'SC',
        '29932' => 'SC',
        '29934' => 'SC',
        '29935' => 'SC',
        '29936' => 'SC',
        '29939' => 'SC',
        '29940' => 'SC',
        '29941' => 'SC',
        '29943' => 'SC',
        '29944' => 'SC',
        '29945' => 'SC',
        '30002' => 'GA',
        '30004' => 'GA',
        '30005' => 'GA',
        '30008' => 'GA',
        '30009' => 'GA',
        '30011' => 'GA',
        '30012' => 'GA',
        '30013' => 'GA',
        '30014' => 'GA',
        '30016' => 'GA',
        '30017' => 'GA',
        '30018' => 'GA',
        '30019' => 'GA',
        '30021' => 'GA',
        '30022' => 'GA',
        '30024' => 'GA',
        '30025' => 'GA',
        '30028' => 'GA',
        '30030' => 'GA',
        '30032' => 'GA',
        '30033' => 'GA',
        '30034' => 'GA',
        '30035' => 'GA',
        '30038' => 'GA',
        '30039' => 'GA',
        '30040' => 'GA',
        '30041' => 'GA',
        '30043' => 'GA',
        '30044' => 'GA',
        '30045' => 'GA',
        '30046' => 'GA',
        '30047' => 'GA',
        '30052' => 'GA',
        '30054' => 'GA',
        '30055' => 'GA',
        '30056' => 'GA',
        '30058' => 'GA',
        '30060' => 'GA',
        '30062' => 'GA',
        '30064' => 'GA',
        '30066' => 'GA',
        '30067' => 'GA',
        '30068' => 'GA',
        '30070' => 'GA',
        '30071' => 'GA',
        '30072' => 'GA',
        '30075' => 'GA',
        '30076' => 'GA',
        '30078' => 'GA',
        '30079' => 'GA',
        '30080' => 'GA',
        '30082' => 'GA',
        '30083' => 'GA',
        '30084' => 'GA',
        '30087' => 'GA',
        '30088' => 'GA',
        '30090' => 'GA',
        '30092' => 'GA',
        '30093' => 'GA',
        '30094' => 'GA',
        '30096' => 'GA',
        '30097' => 'GA',
        '30101' => 'GA',
        '30102' => 'GA',
        '30103' => 'GA',
        '30104' => 'GA',
        '30105' => 'GA',
        '30106' => 'GA',
        '30107' => 'GA',
        '30108' => 'GA',
        '30110' => 'GA',
        '30111' => 'GA',
        '30113' => 'GA',
        '30114' => 'GA',
        '30115' => 'GA',
        '30116' => 'GA',
        '30117' => 'GA',
        '30118' => 'GA',
        '30120' => 'GA',
        '30121' => 'GA',
        '30122' => 'GA',
        '30124' => 'GA',
        '30125' => 'GA',
        '30126' => 'GA',
        '30127' => 'GA',
        '30132' => 'GA',
        '30134' => 'GA',
        '30135' => 'GA',
        '30137' => 'GA',
        '30139' => 'GA',
        '30141' => 'GA',
        '30143' => 'GA',
        '30144' => 'GA',
        '30145' => 'GA',
        '30147' => 'GA',
        '30148' => 'GA',
        '30149' => 'GA',
        '30152' => 'GA',
        '30153' => 'GA',
        '30157' => 'GA',
        '30161' => 'GA',
        '30165' => 'GA',
        '30168' => 'GA',
        '30170' => 'GA',
        '30171' => 'GA',
        '30173' => 'GA',
        '30175' => 'GA',
        '30176' => 'GA',
        '30177' => 'GA',
        '30178' => 'GA',
        '30179' => 'GA',
        '30180' => 'GA',
        '30182' => 'GA',
        '30183' => 'GA',
        '30184' => 'GA',
        '30185' => 'GA',
        '30187' => 'GA',
        '30188' => 'GA',
        '30189' => 'GA',
        '30204' => 'GA',
        '30205' => 'GA',
        '30206' => 'GA',
        '30213' => 'GA',
        '30214' => 'GA',
        '30215' => 'GA',
        '30216' => 'GA',
        '30217' => 'GA',
        '30218' => 'GA',
        '30220' => 'GA',
        '30222' => 'GA',
        '30223' => 'GA',
        '30224' => 'GA',
        '30228' => 'GA',
        '30229' => 'GA',
        '30230' => 'GA',
        '30233' => 'GA',
        '30234' => 'GA',
        '30236' => 'GA',
        '30238' => 'GA',
        '30240' => 'GA',
        '30241' => 'GA',
        '30248' => 'GA',
        '30250' => 'GA',
        '30251' => 'GA',
        '30252' => 'GA',
        '30253' => 'GA',
        '30256' => 'GA',
        '30257' => 'GA',
        '30258' => 'GA',
        '30259' => 'GA',
        '30260' => 'GA',
        '30263' => 'GA',
        '30265' => 'GA',
        '30268' => 'GA',
        '30269' => 'GA',
        '30272' => 'GA',
        '30273' => 'GA',
        '30274' => 'GA',
        '30275' => 'GA',
        '30276' => 'GA',
        '30277' => 'GA',
        '30281' => 'GA',
        '30284' => 'GA',
        '30285' => 'GA',
        '30286' => 'GA',
        '30288' => 'GA',
        '30289' => 'GA',
        '30290' => 'GA',
        '30291' => 'GA',
        '30292' => 'GA',
        '30293' => 'GA',
        '30294' => 'GA',
        '30295' => 'GA',
        '30296' => 'GA',
        '30297' => 'GA',
        '30303' => 'GA',
        '30305' => 'GA',
        '30306' => 'GA',
        '30307' => 'GA',
        '30308' => 'GA',
        '30309' => 'GA',
        '30310' => 'GA',
        '30311' => 'GA',
        '30312' => 'GA',
        '30313' => 'GA',
        '30314' => 'GA',
        '30315' => 'GA',
        '30316' => 'GA',
        '30317' => 'GA',
        '30318' => 'GA',
        '30319' => 'GA',
        '30322' => 'GA',
        '30324' => 'GA',
        '30326' => 'GA',
        '30327' => 'GA',
        '30328' => 'GA',
        '30329' => 'GA',
        '30331' => 'GA',
        '30332' => 'GA',
        '30334' => 'GA',
        '30336' => 'GA',
        '30337' => 'GA',
        '30338' => 'GA',
        '30339' => 'GA',
        '30340' => 'GA',
        '30341' => 'GA',
        '30342' => 'GA',
        '30344' => 'GA',
        '30345' => 'GA',
        '30346' => 'GA',
        '30349' => 'GA',
        '30350' => 'GA',
        '30354' => 'GA',
        '30360' => 'GA',
        '30363' => 'GA',
        '30401' => 'GA',
        '30410' => 'GA',
        '30411' => 'GA',
        '30412' => 'GA',
        '30413' => 'GA',
        '30414' => 'GA',
        '30415' => 'GA',
        '30417' => 'GA',
        '30420' => 'GA',
        '30421' => 'GA',
        '30423' => 'GA',
        '30425' => 'GA',
        '30426' => 'GA',
        '30427' => 'GA',
        '30428' => 'GA',
        '30429' => 'GA',
        '30434' => 'GA',
        '30436' => 'GA',
        '30439' => 'GA',
        '30441' => 'GA',
        '30442' => 'GA',
        '30445' => 'GA',
        '30446' => 'GA',
        '30448' => 'GA',
        '30449' => 'GA',
        '30450' => 'GA',
        '30451' => 'GA',
        '30452' => 'GA',
        '30453' => 'GA',
        '30454' => 'GA',
        '30455' => 'GA',
        '30456' => 'GA',
        '30457' => 'GA',
        '30458' => 'GA',
        '30460' => 'GA',
        '30461' => 'GA',
        '30464' => 'GA',
        '30467' => 'GA',
        '30470' => 'GA',
        '30471' => 'GA',
        '30473' => 'GA',
        '30474' => 'GA',
        '30477' => 'GA',
        '30501' => 'GA',
        '30504' => 'GA',
        '30506' => 'GA',
        '30507' => 'GA',
        '30510' => 'GA',
        '30511' => 'GA',
        '30512' => 'GA',
        '30513' => 'GA',
        '30516' => 'GA',
        '30517' => 'GA',
        '30518' => 'GA',
        '30519' => 'GA',
        '30520' => 'GA',
        '30521' => 'GA',
        '30522' => 'GA',
        '30523' => 'GA',
        '30525' => 'GA',
        '30527' => 'GA',
        '30528' => 'GA',
        '30529' => 'GA',
        '30530' => 'GA',
        '30531' => 'GA',
        '30533' => 'GA',
        '30534' => 'GA',
        '30535' => 'GA',
        '30536' => 'GA',
        '30537' => 'GA',
        '30538' => 'GA',
        '30539' => 'GA',
        '30540' => 'GA',
        '30541' => 'GA',
        '30542' => 'GA',
        '30543' => 'GA',
        '30545' => 'GA',
        '30546' => 'GA',
        '30547' => 'GA',
        '30548' => 'GA',
        '30549' => 'GA',
        '30552' => 'GA',
        '30553' => 'GA',
        '30554' => 'GA',
        '30555' => 'GA',
        '30557' => 'GA',
        '30558' => 'GA',
        '30559' => 'GA',
        '30560' => 'GA',
        '30562' => 'GA',
        '30563' => 'GA',
        '30564' => 'GA',
        '30565' => 'GA',
        '30566' => 'GA',
        '30567' => 'GA',
        '30568' => 'GA',
        '30571' => 'GA',
        '30572' => 'GA',
        '30573' => 'GA',
        '30575' => 'GA',
        '30576' => 'GA',
        '30577' => 'GA',
        '30581' => 'GA',
        '30582' => 'GA',
        '30597' => 'GA',
        '30598' => 'GA',
        '30601' => 'GA',
        '30602' => 'GA',
        '30605' => 'GA',
        '30606' => 'GA',
        '30607' => 'GA',
        '30609' => 'GA',
        '30619' => 'GA',
        '30620' => 'GA',
        '30621' => 'GA',
        '30622' => 'GA',
        '30623' => 'GA',
        '30624' => 'GA',
        '30625' => 'GA',
        '30627' => 'GA',
        '30628' => 'GA',
        '30629' => 'GA',
        '30630' => 'GA',
        '30631' => 'GA',
        '30633' => 'GA',
        '30634' => 'GA',
        '30635' => 'GA',
        '30639' => 'GA',
        '30641' => 'GA',
        '30642' => 'GA',
        '30643' => 'GA',
        '30646' => 'GA',
        '30648' => 'GA',
        '30650' => 'GA',
        '30655' => 'GA',
        '30656' => 'GA',
        '30660' => 'GA',
        '30662' => 'GA',
        '30663' => 'GA',
        '30664' => 'GA',
        '30665' => 'GA',
        '30666' => 'GA',
        '30667' => 'GA',
        '30668' => 'GA',
        '30669' => 'GA',
        '30673' => 'GA',
        '30677' => 'GA',
        '30678' => 'GA',
        '30680' => 'GA',
        '30683' => 'GA',
        '30701' => 'GA',
        '30705' => 'GA',
        '30707' => 'GA',
        '30708' => 'GA',
        '30710' => 'GA',
        '30711' => 'GA',
        '30720' => 'GA',
        '30721' => 'GA',
        '30724' => 'GA',
        '30725' => 'GA',
        '30726' => 'GA',
        '30728' => 'GA',
        '30730' => 'GA',
        '30731' => 'GA',
        '30733' => 'GA',
        '30734' => 'GA',
        '30735' => 'GA',
        '30736' => 'GA',
        '30738' => 'GA',
        '30739' => 'GA',
        '30740' => 'GA',
        '30741' => 'GA',
        '30742' => 'GA',
        '30746' => 'GA',
        '30747' => 'GA',
        '30750' => 'GA',
        '30751' => 'GA',
        '30752' => 'GA',
        '30753' => 'GA',
        '30755' => 'GA',
        '30756' => 'GA',
        '30757' => 'GA',
        '30802' => 'GA',
        '30803' => 'GA',
        '30805' => 'GA',
        '30807' => 'GA',
        '30808' => 'GA',
        '30809' => 'GA',
        '30810' => 'GA',
        '30812' => 'GA',
        '30813' => 'GA',
        '30814' => 'GA',
        '30815' => 'GA',
        '30816' => 'GA',
        '30817' => 'GA',
        '30818' => 'GA',
        '30820' => 'GA',
        '30821' => 'GA',
        '30822' => 'GA',
        '30823' => 'GA',
        '30824' => 'GA',
        '30828' => 'GA',
        '30830' => 'GA',
        '30833' => 'GA',
        '30901' => 'GA',
        '30904' => 'GA',
        '30905' => 'GA',
        '30906' => 'GA',
        '30907' => 'GA',
        '30909' => 'GA',
        '30912' => 'GA',
        '31001' => 'GA',
        '31002' => 'GA',
        '31003' => 'GA',
        '31004' => 'GA',
        '31005' => 'GA',
        '31006' => 'GA',
        '31007' => 'GA',
        '31008' => 'GA',
        '31009' => 'GA',
        '31011' => 'GA',
        '31012' => 'GA',
        '31014' => 'GA',
        '31015' => 'GA',
        '31016' => 'GA',
        '31017' => 'GA',
        '31018' => 'GA',
        '31019' => 'GA',
        '31020' => 'GA',
        '31021' => 'GA',
        '31022' => 'GA',
        '31023' => 'GA',
        '31024' => 'GA',
        '31025' => 'GA',
        '31027' => 'GA',
        '31028' => 'GA',
        '31029' => 'GA',
        '31030' => 'GA',
        '31031' => 'GA',
        '31032' => 'GA',
        '31033' => 'GA',
        '31034' => 'GA',
        '31035' => 'GA',
        '31036' => 'GA',
        '31037' => 'GA',
        '31038' => 'GA',
        '31039' => 'GA',
        '31041' => 'GA',
        '31042' => 'GA',
        '31044' => 'GA',
        '31045' => 'GA',
        '31046' => 'GA',
        '31047' => 'GA',
        '31049' => 'GA',
        '31050' => 'GA',
        '31051' => 'GA',
        '31052' => 'GA',
        '31054' => 'GA',
        '31055' => 'GA',
        '31057' => 'GA',
        '31058' => 'GA',
        '31060' => 'GA',
        '31061' => 'GA',
        '31062' => 'GA',
        '31063' => 'GA',
        '31064' => 'GA',
        '31065' => 'GA',
        '31066' => 'GA',
        '31067' => 'GA',
        '31068' => 'GA',
        '31069' => 'GA',
        '31070' => 'GA',
        '31071' => 'GA',
        '31072' => 'GA',
        '31075' => 'GA',
        '31076' => 'GA',
        '31077' => 'GA',
        '31078' => 'GA',
        '31079' => 'GA',
        '31081' => 'GA',
        '31082' => 'GA',
        '31083' => 'GA',
        '31084' => 'GA',
        '31085' => 'GA',
        '31087' => 'GA',
        '31088' => 'GA',
        '31089' => 'GA',
        '31090' => 'GA',
        '31091' => 'GA',
        '31092' => 'GA',
        '31093' => 'GA',
        '31094' => 'GA',
        '31096' => 'GA',
        '31097' => 'GA',
        '31098' => 'GA',
        '31201' => 'GA',
        '31204' => 'GA',
        '31206' => 'GA',
        '31207' => 'GA',
        '31210' => 'GA',
        '31211' => 'GA',
        '31213' => 'GA',
        '31216' => 'GA',
        '31217' => 'GA',
        '31220' => 'GA',
        '31301' => 'GA',
        '31302' => 'GA',
        '31303' => 'GA',
        '31305' => 'GA',
        '31307' => 'GA',
        '31308' => 'GA',
        '31309' => 'GA',
        '31312' => 'GA',
        '31313' => 'GA',
        '31314' => 'GA',
        '31315' => 'GA',
        '31316' => 'GA',
        '31318' => 'GA',
        '31320' => 'GA',
        '31321' => 'GA',
        '31322' => 'GA',
        '31323' => 'GA',
        '31324' => 'GA',
        '31326' => 'GA',
        '31327' => 'GA',
        '31328' => 'GA',
        '31329' => 'GA',
        '31331' => 'GA',
        '31333' => 'GA',
        '31401' => 'GA',
        '31404' => 'GA',
        '31405' => 'GA',
        '31406' => 'GA',
        '31407' => 'GA',
        '31408' => 'GA',
        '31409' => 'GA',
        '31410' => 'GA',
        '31411' => 'GA',
        '31415' => 'GA',
        '31419' => 'GA',
        '31421' => 'GA',
        '31501' => 'GA',
        '31503' => 'GA',
        '31510' => 'GA',
        '31512' => 'GA',
        '31513' => 'GA',
        '31516' => 'GA',
        '31518' => 'GA',
        '31519' => 'GA',
        '31520' => 'GA',
        '31522' => 'GA',
        '31523' => 'GA',
        '31524' => 'GA',
        '31525' => 'GA',
        '31527' => 'GA',
        '31532' => 'GA',
        '31533' => 'GA',
        '31535' => 'GA',
        '31537' => 'GA',
        '31539' => 'GA',
        '31542' => 'GA',
        '31543' => 'GA',
        '31544' => 'GA',
        '31545' => 'GA',
        '31546' => 'GA',
        '31547' => 'GA',
        '31548' => 'GA',
        '31549' => 'GA',
        '31550' => 'GA',
        '31551' => 'GA',
        '31552' => 'GA',
        '31553' => 'GA',
        '31554' => 'GA',
        '31555' => 'GA',
        '31556' => 'GA',
        '31557' => 'GA',
        '31558' => 'GA',
        '31560' => 'GA',
        '31561' => 'GA',
        '31562' => 'GA',
        '31563' => 'GA',
        '31564' => 'GA',
        '31565' => 'GA',
        '31566' => 'GA',
        '31567' => 'GA',
        '31568' => 'GA',
        '31569' => 'GA',
        '31599' => 'GA',
        '31601' => 'GA',
        '31602' => 'GA',
        '31605' => 'GA',
        '31606' => 'GA',
        '31620' => 'GA',
        '31622' => 'GA',
        '31623' => 'GA',
        '31624' => 'GA',
        '31625' => 'GA',
        '31626' => 'GA',
        '31627' => 'GA',
        '31629' => 'GA',
        '31630' => 'GA',
        '31631' => 'GA',
        '31632' => 'GA',
        '31634' => 'GA',
        '31635' => 'GA',
        '31636' => 'GA',
        '31637' => 'GA',
        '31638' => 'GA',
        '31639' => 'GA',
        '31641' => 'GA',
        '31642' => 'GA',
        '31643' => 'GA',
        '31645' => 'GA',
        '31647' => 'GA',
        '31648' => 'GA',
        '31649' => 'GA',
        '31650' => 'GA',
        '31698' => 'GA',
        '31699' => 'GA',
        '31701' => 'GA',
        '31704' => 'GA',
        '31705' => 'GA',
        '31707' => 'GA',
        '31709' => 'GA',
        '31711' => 'GA',
        '31712' => 'GA',
        '31714' => 'GA',
        '31716' => 'GA',
        '31719' => 'GA',
        '31720' => 'GA',
        '31721' => 'GA',
        '31722' => 'GA',
        '31727' => 'GA',
        '31730' => 'GA',
        '31733' => 'GA',
        '31735' => 'GA',
        '31738' => 'GA',
        '31743' => 'GA',
        '31744' => 'GA',
        '31747' => 'GA',
        '31749' => 'GA',
        '31750' => 'GA',
        '31753' => 'GA',
        '31756' => 'GA',
        '31757' => 'GA',
        '31763' => 'GA',
        '31764' => 'GA',
        '31765' => 'GA',
        '31768' => 'GA',
        '31771' => 'GA',
        '31772' => 'GA',
        '31773' => 'GA',
        '31774' => 'GA',
        '31775' => 'GA',
        '31778' => 'GA',
        '31779' => 'GA',
        '31780' => 'GA',
        '31781' => 'GA',
        '31783' => 'GA',
        '31784' => 'GA',
        '31787' => 'GA',
        '31788' => 'GA',
        '31789' => 'GA',
        '31790' => 'GA',
        '31791' => 'GA',
        '31792' => 'GA',
        '31793' => 'GA',
        '31794' => 'GA',
        '31795' => 'GA',
        '31796' => 'GA',
        '31798' => 'GA',
        '31801' => 'GA',
        '31803' => 'GA',
        '31804' => 'GA',
        '31805' => 'GA',
        '31806' => 'GA',
        '31807' => 'GA',
        '31808' => 'GA',
        '31810' => 'GA',
        '31811' => 'GA',
        '31812' => 'GA',
        '31814' => 'GA',
        '31815' => 'GA',
        '31816' => 'GA',
        '31820' => 'GA',
        '31821' => 'GA',
        '31822' => 'GA',
        '31823' => 'GA',
        '31824' => 'GA',
        '31825' => 'GA',
        '31826' => 'GA',
        '31827' => 'GA',
        '31829' => 'GA',
        '31830' => 'GA',
        '31831' => 'GA',
        '31832' => 'GA',
        '31833' => 'GA',
        '31836' => 'GA',
        '31901' => 'GA',
        '31903' => 'GA',
        '31904' => 'GA',
        '31905' => 'GA',
        '31906' => 'GA',
        '31907' => 'GA',
        '31909' => 'GA',
        '32003' => 'FL',
        '32008' => 'FL',
        '32009' => 'FL',
        '32011' => 'FL',
        '32013' => 'FL',
        '32024' => 'FL',
        '32025' => 'FL',
        '32033' => 'FL',
        '32034' => 'FL',
        '32038' => 'FL',
        '32040' => 'FL',
        '32043' => 'FL',
        '32044' => 'FL',
        '32046' => 'FL',
        '32052' => 'FL',
        '32053' => 'FL',
        '32054' => 'FL',
        '32055' => 'FL',
        '32058' => 'FL',
        '32059' => 'FL',
        '32060' => 'FL',
        '32061' => 'FL',
        '32062' => 'FL',
        '32063' => 'FL',
        '32064' => 'FL',
        '32065' => 'FL',
        '32066' => 'FL',
        '32068' => 'FL',
        '32071' => 'FL',
        '32073' => 'FL',
        '32079' => 'FL',
        '32080' => 'FL',
        '32081' => 'FL',
        '32082' => 'FL',
        '32083' => 'FL',
        '32084' => 'FL',
        '32086' => 'FL',
        '32087' => 'FL',
        '32091' => 'FL',
        '32092' => 'FL',
        '32094' => 'FL',
        '32095' => 'FL',
        '32096' => 'FL',
        '32097' => 'FL',
        '32102' => 'FL',
        '32110' => 'FL',
        '32112' => 'FL',
        '32113' => 'FL',
        '32114' => 'FL',
        '32117' => 'FL',
        '32118' => 'FL',
        '32119' => 'FL',
        '32124' => 'FL',
        '32127' => 'FL',
        '32128' => 'FL',
        '32129' => 'FL',
        '32130' => 'FL',
        '32131' => 'FL',
        '32132' => 'FL',
        '32133' => 'FL',
        '32134' => 'FL',
        '32136' => 'FL',
        '32137' => 'FL',
        '32139' => 'FL',
        '32140' => 'FL',
        '32141' => 'FL',
        '32145' => 'FL',
        '32147' => 'FL',
        '32148' => 'FL',
        '32157' => 'FL',
        '32159' => 'FL',
        '32162' => 'FL',
        '32163' => 'FL',
        '32164' => 'FL',
        '32168' => 'FL',
        '32169' => 'FL',
        '32174' => 'FL',
        '32176' => 'FL',
        '32177' => 'FL',
        '32179' => 'FL',
        '32180' => 'FL',
        '32181' => 'FL',
        '32182' => 'FL',
        '32187' => 'FL',
        '32189' => 'FL',
        '32190' => 'FL',
        '32192' => 'FL',
        '32193' => 'FL',
        '32195' => 'FL',
        '32202' => 'FL',
        '32203' => 'FL',
        '32204' => 'FL',
        '32205' => 'FL',
        '32206' => 'FL',
        '32207' => 'FL',
        '32208' => 'FL',
        '32209' => 'FL',
        '32210' => 'FL',
        '32211' => 'FL',
        '32212' => 'FL',
        '32214' => 'FL',
        '32216' => 'FL',
        '32217' => 'FL',
        '32218' => 'FL',
        '32219' => 'FL',
        '32220' => 'FL',
        '32221' => 'FL',
        '32222' => 'FL',
        '32223' => 'FL',
        '32224' => 'FL',
        '32225' => 'FL',
        '32226' => 'FL',
        '32227' => 'FL',
        '32228' => 'FL',
        '32233' => 'FL',
        '32234' => 'FL',
        '32244' => 'FL',
        '32246' => 'FL',
        '32250' => 'FL',
        '32254' => 'FL',
        '32256' => 'FL',
        '32257' => 'FL',
        '32258' => 'FL',
        '32259' => 'FL',
        '32266' => 'FL',
        '32277' => 'FL',
        '32301' => 'FL',
        '32303' => 'FL',
        '32304' => 'FL',
        '32305' => 'FL',
        '32306' => 'FL',
        '32307' => 'FL',
        '32308' => 'FL',
        '32309' => 'FL',
        '32310' => 'FL',
        '32311' => 'FL',
        '32312' => 'FL',
        '32313' => 'FL',
        '32317' => 'FL',
        '32320' => 'FL',
        '32321' => 'FL',
        '32322' => 'FL',
        '32323' => 'FL',
        '32324' => 'FL',
        '32327' => 'FL',
        '32328' => 'FL',
        '32330' => 'FL',
        '32331' => 'FL',
        '32332' => 'FL',
        '32333' => 'FL',
        '32334' => 'FL',
        '32336' => 'FL',
        '32337' => 'FL',
        '32340' => 'FL',
        '32343' => 'FL',
        '32344' => 'FL',
        '32346' => 'FL',
        '32347' => 'FL',
        '32348' => 'FL',
        '32350' => 'FL',
        '32351' => 'FL',
        '32352' => 'FL',
        '32355' => 'FL',
        '32356' => 'FL',
        '32358' => 'FL',
        '32359' => 'FL',
        '32360' => 'FL',
        '32361' => 'FL',
        '32399' => 'FL',
        '32401' => 'FL',
        '32403' => 'FL',
        '32404' => 'FL',
        '32405' => 'FL',
        '32407' => 'FL',
        '32408' => 'FL',
        '32409' => 'FL',
        '32410' => 'FL',
        '32413' => 'FL',
        '32420' => 'FL',
        '32421' => 'FL',
        '32423' => 'FL',
        '32424' => 'FL',
        '32425' => 'FL',
        '32426' => 'FL',
        '32427' => 'FL',
        '32428' => 'FL',
        '32430' => 'FL',
        '32431' => 'FL',
        '32432' => 'FL',
        '32433' => 'FL',
        '32435' => 'FL',
        '32437' => 'FL',
        '32438' => 'FL',
        '32439' => 'FL',
        '32440' => 'FL',
        '32442' => 'FL',
        '32443' => 'FL',
        '32444' => 'FL',
        '32445' => 'FL',
        '32446' => 'FL',
        '32448' => 'FL',
        '32449' => 'FL',
        '32455' => 'FL',
        '32456' => 'FL',
        '32459' => 'FL',
        '32460' => 'FL',
        '32461' => 'FL',
        '32462' => 'FL',
        '32463' => 'FL',
        '32464' => 'FL',
        '32465' => 'FL',
        '32466' => 'FL',
        '32501' => 'FL',
        '32502' => 'FL',
        '32503' => 'FL',
        '32504' => 'FL',
        '32505' => 'FL',
        '32506' => 'FL',
        '32507' => 'FL',
        '32508' => 'FL',
        '32509' => 'FL',
        '32511' => 'FL',
        '32512' => 'FL',
        '32514' => 'FL',
        '32526' => 'FL',
        '32530' => 'FL',
        '32531' => 'FL',
        '32533' => 'FL',
        '32534' => 'FL',
        '32535' => 'FL',
        '32536' => 'FL',
        '32539' => 'FL',
        '32541' => 'FL',
        '32542' => 'FL',
        '32544' => 'FL',
        '32547' => 'FL',
        '32548' => 'FL',
        '32550' => 'FL',
        '32561' => 'FL',
        '32563' => 'FL',
        '32564' => 'FL',
        '32565' => 'FL',
        '32566' => 'FL',
        '32567' => 'FL',
        '32568' => 'FL',
        '32569' => 'FL',
        '32570' => 'FL',
        '32571' => 'FL',
        '32577' => 'FL',
        '32578' => 'FL',
        '32579' => 'FL',
        '32580' => 'FL',
        '32583' => 'FL',
        '32601' => 'FL',
        '32603' => 'FL',
        '32605' => 'FL',
        '32606' => 'FL',
        '32607' => 'FL',
        '32608' => 'FL',
        '32609' => 'FL',
        '32610' => 'FL',
        '32612' => 'FL',
        '32615' => 'FL',
        '32616' => 'FL',
        '32617' => 'FL',
        '32618' => 'FL',
        '32619' => 'FL',
        '32621' => 'FL',
        '32622' => 'FL',
        '32625' => 'FL',
        '32626' => 'FL',
        '32628' => 'FL',
        '32631' => 'FL',
        '32634' => 'FL',
        '32639' => 'FL',
        '32640' => 'FL',
        '32641' => 'FL',
        '32643' => 'FL',
        '32648' => 'FL',
        '32653' => 'FL',
        '32656' => 'FL',
        '32658' => 'FL',
        '32664' => 'FL',
        '32666' => 'FL',
        '32667' => 'FL',
        '32668' => 'FL',
        '32669' => 'FL',
        '32680' => 'FL',
        '32681' => 'FL',
        '32683' => 'FL',
        '32686' => 'FL',
        '32692' => 'FL',
        '32693' => 'FL',
        '32694' => 'FL',
        '32696' => 'FL',
        '32697' => 'FL',
        '32701' => 'FL',
        '32702' => 'FL',
        '32703' => 'FL',
        '32707' => 'FL',
        '32708' => 'FL',
        '32709' => 'FL',
        '32712' => 'FL',
        '32713' => 'FL',
        '32714' => 'FL',
        '32720' => 'FL',
        '32723' => 'FL',
        '32724' => 'FL',
        '32725' => 'FL',
        '32726' => 'FL',
        '32730' => 'FL',
        '32732' => 'FL',
        '32735' => 'FL',
        '32736' => 'FL',
        '32738' => 'FL',
        '32744' => 'FL',
        '32746' => 'FL',
        '32750' => 'FL',
        '32751' => 'FL',
        '32754' => 'FL',
        '32757' => 'FL',
        '32759' => 'FL',
        '32763' => 'FL',
        '32764' => 'FL',
        '32765' => 'FL',
        '32766' => 'FL',
        '32767' => 'FL',
        '32768' => 'FL',
        '32771' => 'FL',
        '32773' => 'FL',
        '32775' => 'FL',
        '32776' => 'FL',
        '32778' => 'FL',
        '32779' => 'FL',
        '32780' => 'FL',
        '32784' => 'FL',
        '32789' => 'FL',
        '32792' => 'FL',
        '32796' => 'FL',
        '32798' => 'FL',
        '32801' => 'FL',
        '32803' => 'FL',
        '32804' => 'FL',
        '32805' => 'FL',
        '32806' => 'FL',
        '32807' => 'FL',
        '32808' => 'FL',
        '32809' => 'FL',
        '32810' => 'FL',
        '32811' => 'FL',
        '32812' => 'FL',
        '32814' => 'FL',
        '32816' => 'FL',
        '32817' => 'FL',
        '32818' => 'FL',
        '32819' => 'FL',
        '32820' => 'FL',
        '32821' => 'FL',
        '32822' => 'FL',
        '32824' => 'FL',
        '32825' => 'FL',
        '32826' => 'FL',
        '32827' => 'FL',
        '32828' => 'FL',
        '32829' => 'FL',
        '32830' => 'FL',
        '32831' => 'FL',
        '32832' => 'FL',
        '32833' => 'FL',
        '32835' => 'FL',
        '32836' => 'FL',
        '32837' => 'FL',
        '32839' => 'FL',
        '32899' => 'FL',
        '32901' => 'FL',
        '32903' => 'FL',
        '32904' => 'FL',
        '32905' => 'FL',
        '32907' => 'FL',
        '32908' => 'FL',
        '32909' => 'FL',
        '32920' => 'FL',
        '32922' => 'FL',
        '32925' => 'FL',
        '32926' => 'FL',
        '32927' => 'FL',
        '32931' => 'FL',
        '32934' => 'FL',
        '32935' => 'FL',
        '32937' => 'FL',
        '32940' => 'FL',
        '32948' => 'FL',
        '32949' => 'FL',
        '32950' => 'FL',
        '32951' => 'FL',
        '32952' => 'FL',
        '32953' => 'FL',
        '32955' => 'FL',
        '32958' => 'FL',
        '32959' => 'FL',
        '32960' => 'FL',
        '32962' => 'FL',
        '32963' => 'FL',
        '32966' => 'FL',
        '32967' => 'FL',
        '32968' => 'FL',
        '32970' => 'FL',
        '32976' => 'FL',
        '33001' => 'FL',
        '33004' => 'FL',
        '33009' => 'FL',
        '33010' => 'FL',
        '33012' => 'FL',
        '33013' => 'FL',
        '33014' => 'FL',
        '33015' => 'FL',
        '33016' => 'FL',
        '33018' => 'FL',
        '33019' => 'FL',
        '33020' => 'FL',
        '33021' => 'FL',
        '33022' => 'FL',
        '33023' => 'FL',
        '33024' => 'FL',
        '33025' => 'FL',
        '33026' => 'FL',
        '33027' => 'FL',
        '33028' => 'FL',
        '33029' => 'FL',
        '33030' => 'FL',
        '33031' => 'FL',
        '33032' => 'FL',
        '33033' => 'FL',
        '33034' => 'FL',
        '33035' => 'FL',
        '33036' => 'FL',
        '33037' => 'FL',
        '33039' => 'FL',
        '33040' => 'FL',
        '33042' => 'FL',
        '33043' => 'FL',
        '33050' => 'FL',
        '33051' => 'FL',
        '33054' => 'FL',
        '33055' => 'FL',
        '33056' => 'FL',
        '33060' => 'FL',
        '33062' => 'FL',
        '33063' => 'FL',
        '33064' => 'FL',
        '33065' => 'FL',
        '33066' => 'FL',
        '33067' => 'FL',
        '33068' => 'FL',
        '33069' => 'FL',
        '33070' => 'FL',
        '33071' => 'FL',
        '33073' => 'FL',
        '33076' => 'FL',
        '33101' => 'FL',
        '33109' => 'FL',
        '33122' => 'FL',
        '33125' => 'FL',
        '33126' => 'FL',
        '33127' => 'FL',
        '33128' => 'FL',
        '33129' => 'FL',
        '33130' => 'FL',
        '33131' => 'FL',
        '33132' => 'FL',
        '33133' => 'FL',
        '33134' => 'FL',
        '33135' => 'FL',
        '33136' => 'FL',
        '33137' => 'FL',
        '33138' => 'FL',
        '33139' => 'FL',
        '33140' => 'FL',
        '33141' => 'FL',
        '33142' => 'FL',
        '33143' => 'FL',
        '33144' => 'FL',
        '33145' => 'FL',
        '33146' => 'FL',
        '33147' => 'FL',
        '33149' => 'FL',
        '33150' => 'FL',
        '33154' => 'FL',
        '33155' => 'FL',
        '33156' => 'FL',
        '33157' => 'FL',
        '33158' => 'FL',
        '33160' => 'FL',
        '33161' => 'FL',
        '33162' => 'FL',
        '33165' => 'FL',
        '33166' => 'FL',
        '33167' => 'FL',
        '33168' => 'FL',
        '33169' => 'FL',
        '33170' => 'FL',
        '33172' => 'FL',
        '33173' => 'FL',
        '33174' => 'FL',
        '33175' => 'FL',
        '33176' => 'FL',
        '33177' => 'FL',
        '33178' => 'FL',
        '33179' => 'FL',
        '33180' => 'FL',
        '33181' => 'FL',
        '33182' => 'FL',
        '33183' => 'FL',
        '33184' => 'FL',
        '33185' => 'FL',
        '33186' => 'FL',
        '33187' => 'FL',
        '33189' => 'FL',
        '33190' => 'FL',
        '33193' => 'FL',
        '33194' => 'FL',
        '33196' => 'FL',
        '33301' => 'FL',
        '33304' => 'FL',
        '33305' => 'FL',
        '33306' => 'FL',
        '33308' => 'FL',
        '33309' => 'FL',
        '33311' => 'FL',
        '33312' => 'FL',
        '33313' => 'FL',
        '33314' => 'FL',
        '33315' => 'FL',
        '33316' => 'FL',
        '33317' => 'FL',
        '33319' => 'FL',
        '33321' => 'FL',
        '33322' => 'FL',
        '33323' => 'FL',
        '33324' => 'FL',
        '33325' => 'FL',
        '33326' => 'FL',
        '33327' => 'FL',
        '33328' => 'FL',
        '33330' => 'FL',
        '33331' => 'FL',
        '33332' => 'FL',
        '33334' => 'FL',
        '33351' => 'FL',
        '33388' => 'FL',
        '33401' => 'FL',
        '33403' => 'FL',
        '33404' => 'FL',
        '33405' => 'FL',
        '33406' => 'FL',
        '33407' => 'FL',
        '33408' => 'FL',
        '33409' => 'FL',
        '33410' => 'FL',
        '33411' => 'FL',
        '33412' => 'FL',
        '33413' => 'FL',
        '33414' => 'FL',
        '33415' => 'FL',
        '33417' => 'FL',
        '33418' => 'FL',
        '33426' => 'FL',
        '33428' => 'FL',
        '33430' => 'FL',
        '33431' => 'FL',
        '33432' => 'FL',
        '33433' => 'FL',
        '33434' => 'FL',
        '33435' => 'FL',
        '33436' => 'FL',
        '33437' => 'FL',
        '33438' => 'FL',
        '33440' => 'FL',
        '33441' => 'FL',
        '33442' => 'FL',
        '33444' => 'FL',
        '33445' => 'FL',
        '33446' => 'FL',
        '33449' => 'FL',
        '33455' => 'FL',
        '33458' => 'FL',
        '33460' => 'FL',
        '33461' => 'FL',
        '33462' => 'FL',
        '33463' => 'FL',
        '33467' => 'FL',
        '33469' => 'FL',
        '33470' => 'FL',
        '33471' => 'FL',
        '33472' => 'FL',
        '33473' => 'FL',
        '33476' => 'FL',
        '33477' => 'FL',
        '33478' => 'FL',
        '33480' => 'FL',
        '33483' => 'FL',
        '33484' => 'FL',
        '33486' => 'FL',
        '33487' => 'FL',
        '33493' => 'FL',
        '33496' => 'FL',
        '33498' => 'FL',
        '33503' => 'FL',
        '33510' => 'FL',
        '33511' => 'FL',
        '33513' => 'FL',
        '33514' => 'FL',
        '33521' => 'FL',
        '33523' => 'FL',
        '33525' => 'FL',
        '33527' => 'FL',
        '33530' => 'FL',
        '33534' => 'FL',
        '33538' => 'FL',
        '33540' => 'FL',
        '33541' => 'FL',
        '33542' => 'FL',
        '33543' => 'FL',
        '33544' => 'FL',
        '33545' => 'FL',
        '33547' => 'FL',
        '33548' => 'FL',
        '33549' => 'FL',
        '33550' => 'FL',
        '33556' => 'FL',
        '33558' => 'FL',
        '33559' => 'FL',
        '33563' => 'FL',
        '33565' => 'FL',
        '33566' => 'FL',
        '33567' => 'FL',
        '33569' => 'FL',
        '33570' => 'FL',
        '33572' => 'FL',
        '33573' => 'FL',
        '33574' => 'FL',
        '33576' => 'FL',
        '33578' => 'FL',
        '33579' => 'FL',
        '33584' => 'FL',
        '33585' => 'FL',
        '33592' => 'FL',
        '33594' => 'FL',
        '33596' => 'FL',
        '33597' => 'FL',
        '33598' => 'FL',
        '33602' => 'FL',
        '33603' => 'FL',
        '33604' => 'FL',
        '33605' => 'FL',
        '33606' => 'FL',
        '33607' => 'FL',
        '33609' => 'FL',
        '33610' => 'FL',
        '33611' => 'FL',
        '33612' => 'FL',
        '33613' => 'FL',
        '33614' => 'FL',
        '33615' => 'FL',
        '33616' => 'FL',
        '33617' => 'FL',
        '33618' => 'FL',
        '33619' => 'FL',
        '33620' => 'FL',
        '33621' => 'FL',
        '33624' => 'FL',
        '33625' => 'FL',
        '33626' => 'FL',
        '33629' => 'FL',
        '33634' => 'FL',
        '33635' => 'FL',
        '33637' => 'FL',
        '33647' => 'FL',
        '33701' => 'FL',
        '33702' => 'FL',
        '33703' => 'FL',
        '33704' => 'FL',
        '33705' => 'FL',
        '33706' => 'FL',
        '33707' => 'FL',
        '33708' => 'FL',
        '33709' => 'FL',
        '33710' => 'FL',
        '33711' => 'FL',
        '33712' => 'FL',
        '33713' => 'FL',
        '33714' => 'FL',
        '33715' => 'FL',
        '33716' => 'FL',
        '33744' => 'FL',
        '33755' => 'FL',
        '33756' => 'FL',
        '33759' => 'FL',
        '33760' => 'FL',
        '33761' => 'FL',
        '33762' => 'FL',
        '33763' => 'FL',
        '33764' => 'FL',
        '33765' => 'FL',
        '33767' => 'FL',
        '33770' => 'FL',
        '33771' => 'FL',
        '33772' => 'FL',
        '33773' => 'FL',
        '33774' => 'FL',
        '33776' => 'FL',
        '33777' => 'FL',
        '33778' => 'FL',
        '33781' => 'FL',
        '33782' => 'FL',
        '33785' => 'FL',
        '33786' => 'FL',
        '33801' => 'FL',
        '33803' => 'FL',
        '33805' => 'FL',
        '33809' => 'FL',
        '33810' => 'FL',
        '33811' => 'FL',
        '33812' => 'FL',
        '33813' => 'FL',
        '33815' => 'FL',
        '33823' => 'FL',
        '33825' => 'FL',
        '33827' => 'FL',
        '33830' => 'FL',
        '33834' => 'FL',
        '33835' => 'FL',
        '33837' => 'FL',
        '33838' => 'FL',
        '33839' => 'FL',
        '33840' => 'FL',
        '33841' => 'FL',
        '33843' => 'FL',
        '33844' => 'FL',
        '33847' => 'FL',
        '33848' => 'FL',
        '33849' => 'FL',
        '33850' => 'FL',
        '33851' => 'FL',
        '33852' => 'FL',
        '33853' => 'FL',
        '33854' => 'FL',
        '33855' => 'FL',
        '33856' => 'FL',
        '33857' => 'FL',
        '33858' => 'FL',
        '33859' => 'FL',
        '33860' => 'FL',
        '33865' => 'FL',
        '33867' => 'FL',
        '33868' => 'FL',
        '33870' => 'FL',
        '33872' => 'FL',
        '33873' => 'FL',
        '33875' => 'FL',
        '33876' => 'FL',
        '33877' => 'FL',
        '33880' => 'FL',
        '33881' => 'FL',
        '33884' => 'FL',
        '33890' => 'FL',
        '33896' => 'FL',
        '33897' => 'FL',
        '33898' => 'FL',
        '33901' => 'FL',
        '33903' => 'FL',
        '33904' => 'FL',
        '33905' => 'FL',
        '33907' => 'FL',
        '33908' => 'FL',
        '33909' => 'FL',
        '33912' => 'FL',
        '33913' => 'FL',
        '33914' => 'FL',
        '33916' => 'FL',
        '33917' => 'FL',
        '33919' => 'FL',
        '33920' => 'FL',
        '33921' => 'FL',
        '33922' => 'FL',
        '33924' => 'FL',
        '33928' => 'FL',
        '33930' => 'FL',
        '33931' => 'FL',
        '33935' => 'FL',
        '33936' => 'FL',
        '33944' => 'FL',
        '33946' => 'FL',
        '33947' => 'FL',
        '33948' => 'FL',
        '33950' => 'FL',
        '33952' => 'FL',
        '33953' => 'FL',
        '33954' => 'FL',
        '33955' => 'FL',
        '33956' => 'FL',
        '33957' => 'FL',
        '33960' => 'FL',
        '33965' => 'FL',
        '33966' => 'FL',
        '33967' => 'FL',
        '33971' => 'FL',
        '33972' => 'FL',
        '33973' => 'FL',
        '33974' => 'FL',
        '33976' => 'FL',
        '33980' => 'FL',
        '33981' => 'FL',
        '33982' => 'FL',
        '33983' => 'FL',
        '33990' => 'FL',
        '33991' => 'FL',
        '33993' => 'FL',
        '34101' => 'FL',
        '34102' => 'FL',
        '34103' => 'FL',
        '34104' => 'FL',
        '34105' => 'FL',
        '34108' => 'FL',
        '34109' => 'FL',
        '34110' => 'FL',
        '34112' => 'FL',
        '34113' => 'FL',
        '34114' => 'FL',
        '34116' => 'FL',
        '34117' => 'FL',
        '34119' => 'FL',
        '34120' => 'FL',
        '34134' => 'FL',
        '34135' => 'FL',
        '34137' => 'FL',
        '34138' => 'FL',
        '34139' => 'FL',
        '34140' => 'FL',
        '34141' => 'FL',
        '34142' => 'FL',
        '34145' => 'FL',
        '34201' => 'FL',
        '34202' => 'FL',
        '34203' => 'FL',
        '34205' => 'FL',
        '34207' => 'FL',
        '34208' => 'FL',
        '34209' => 'FL',
        '34210' => 'FL',
        '34211' => 'FL',
        '34212' => 'FL',
        '34215' => 'FL',
        '34216' => 'FL',
        '34217' => 'FL',
        '34219' => 'FL',
        '34221' => 'FL',
        '34222' => 'FL',
        '34223' => 'FL',
        '34224' => 'FL',
        '34228' => 'FL',
        '34229' => 'FL',
        '34231' => 'FL',
        '34232' => 'FL',
        '34233' => 'FL',
        '34234' => 'FL',
        '34235' => 'FL',
        '34236' => 'FL',
        '34237' => 'FL',
        '34238' => 'FL',
        '34239' => 'FL',
        '34240' => 'FL',
        '34241' => 'FL',
        '34242' => 'FL',
        '34243' => 'FL',
        '34250' => 'FL',
        '34251' => 'FL',
        '34266' => 'FL',
        '34267' => 'FL',
        '34268' => 'FL',
        '34269' => 'FL',
        '34275' => 'FL',
        '34285' => 'FL',
        '34286' => 'FL',
        '34287' => 'FL',
        '34288' => 'FL',
        '34289' => 'FL',
        '34291' => 'FL',
        '34292' => 'FL',
        '34293' => 'FL',
        '34420' => 'FL',
        '34428' => 'FL',
        '34429' => 'FL',
        '34431' => 'FL',
        '34432' => 'FL',
        '34433' => 'FL',
        '34434' => 'FL',
        '34436' => 'FL',
        '34442' => 'FL',
        '34445' => 'FL',
        '34446' => 'FL',
        '34448' => 'FL',
        '34449' => 'FL',
        '34450' => 'FL',
        '34452' => 'FL',
        '34453' => 'FL',
        '34461' => 'FL',
        '34465' => 'FL',
        '34470' => 'FL',
        '34471' => 'FL',
        '34472' => 'FL',
        '34473' => 'FL',
        '34474' => 'FL',
        '34475' => 'FL',
        '34476' => 'FL',
        '34479' => 'FL',
        '34480' => 'FL',
        '34481' => 'FL',
        '34482' => 'FL',
        '34484' => 'FL',
        '34487' => 'FL',
        '34488' => 'FL',
        '34491' => 'FL',
        '34498' => 'FL',
        '34601' => 'FL',
        '34602' => 'FL',
        '34604' => 'FL',
        '34606' => 'FL',
        '34607' => 'FL',
        '34608' => 'FL',
        '34609' => 'FL',
        '34610' => 'FL',
        '34613' => 'FL',
        '34614' => 'FL',
        '34637' => 'FL',
        '34638' => 'FL',
        '34639' => 'FL',
        '34652' => 'FL',
        '34653' => 'FL',
        '34654' => 'FL',
        '34655' => 'FL',
        '34661' => 'FL',
        '34667' => 'FL',
        '34668' => 'FL',
        '34669' => 'FL',
        '34677' => 'FL',
        '34679' => 'FL',
        '34681' => 'FL',
        '34683' => 'FL',
        '34684' => 'FL',
        '34685' => 'FL',
        '34688' => 'FL',
        '34689' => 'FL',
        '34690' => 'FL',
        '34691' => 'FL',
        '34695' => 'FL',
        '34698' => 'FL',
        '34705' => 'FL',
        '34711' => 'FL',
        '34714' => 'FL',
        '34715' => 'FL',
        '34729' => 'FL',
        '34731' => 'FL',
        '34734' => 'FL',
        '34736' => 'FL',
        '34737' => 'FL',
        '34739' => 'FL',
        '34741' => 'FL',
        '34743' => 'FL',
        '34744' => 'FL',
        '34746' => 'FL',
        '34747' => 'FL',
        '34748' => 'FL',
        '34753' => 'FL',
        '34756' => 'FL',
        '34758' => 'FL',
        '34759' => 'FL',
        '34760' => 'FL',
        '34761' => 'FL',
        '34762' => 'FL',
        '34769' => 'FL',
        '34771' => 'FL',
        '34772' => 'FL',
        '34773' => 'FL',
        '34785' => 'FL',
        '34786' => 'FL',
        '34787' => 'FL',
        '34788' => 'FL',
        '34797' => 'FL',
        '34945' => 'FL',
        '34946' => 'FL',
        '34947' => 'FL',
        '34949' => 'FL',
        '34950' => 'FL',
        '34951' => 'FL',
        '34952' => 'FL',
        '34953' => 'FL',
        '34956' => 'FL',
        '34957' => 'FL',
        '34972' => 'FL',
        '34974' => 'FL',
        '34981' => 'FL',
        '34982' => 'FL',
        '34983' => 'FL',
        '34984' => 'FL',
        '34986' => 'FL',
        '34987' => 'FL',
        '34990' => 'FL',
        '34994' => 'FL',
        '34996' => 'FL',
        '34997' => 'FL',
        '35004' => 'AL',
        '35005' => 'AL',
        '35006' => 'AL',
        '35007' => 'AL',
        '35010' => 'AL',
        '35013' => 'AL',
        '35014' => 'AL',
        '35016' => 'AL',
        '35019' => 'AL',
        '35020' => 'AL',
        '35022' => 'AL',
        '35023' => 'AL',
        '35031' => 'AL',
        '35032' => 'AL',
        '35033' => 'AL',
        '35034' => 'AL',
        '35035' => 'AL',
        '35036' => 'AL',
        '35040' => 'AL',
        '35042' => 'AL',
        '35043' => 'AL',
        '35044' => 'AL',
        '35045' => 'AL',
        '35046' => 'AL',
        '35049' => 'AL',
        '35051' => 'AL',
        '35052' => 'AL',
        '35053' => 'AL',
        '35054' => 'AL',
        '35055' => 'AL',
        '35057' => 'AL',
        '35058' => 'AL',
        '35060' => 'AL',
        '35061' => 'AL',
        '35062' => 'AL',
        '35063' => 'AL',
        '35064' => 'AL',
        '35068' => 'AL',
        '35070' => 'AL',
        '35071' => 'AL',
        '35072' => 'AL',
        '35073' => 'AL',
        '35074' => 'AL',
        '35077' => 'AL',
        '35078' => 'AL',
        '35079' => 'AL',
        '35080' => 'AL',
        '35082' => 'AL',
        '35083' => 'AL',
        '35085' => 'AL',
        '35087' => 'AL',
        '35089' => 'AL',
        '35091' => 'AL',
        '35094' => 'AL',
        '35096' => 'AL',
        '35097' => 'AL',
        '35098' => 'AL',
        '35111' => 'AL',
        '35112' => 'AL',
        '35114' => 'AL',
        '35115' => 'AL',
        '35116' => 'AL',
        '35117' => 'AL',
        '35118' => 'AL',
        '35119' => 'AL',
        '35120' => 'AL',
        '35121' => 'AL',
        '35124' => 'AL',
        '35125' => 'AL',
        '35126' => 'AL',
        '35127' => 'AL',
        '35128' => 'AL',
        '35130' => 'AL',
        '35131' => 'AL',
        '35133' => 'AL',
        '35135' => 'AL',
        '35136' => 'AL',
        '35143' => 'AL',
        '35146' => 'AL',
        '35147' => 'AL',
        '35148' => 'AL',
        '35149' => 'AL',
        '35150' => 'AL',
        '35151' => 'AL',
        '35160' => 'AL',
        '35171' => 'AL',
        '35172' => 'AL',
        '35173' => 'AL',
        '35175' => 'AL',
        '35176' => 'AL',
        '35178' => 'AL',
        '35179' => 'AL',
        '35180' => 'AL',
        '35181' => 'AL',
        '35183' => 'AL',
        '35184' => 'AL',
        '35185' => 'AL',
        '35186' => 'AL',
        '35188' => 'AL',
        '35203' => 'AL',
        '35204' => 'AL',
        '35205' => 'AL',
        '35206' => 'AL',
        '35207' => 'AL',
        '35208' => 'AL',
        '35209' => 'AL',
        '35210' => 'AL',
        '35211' => 'AL',
        '35212' => 'AL',
        '35213' => 'AL',
        '35214' => 'AL',
        '35215' => 'AL',
        '35216' => 'AL',
        '35217' => 'AL',
        '35218' => 'AL',
        '35221' => 'AL',
        '35222' => 'AL',
        '35223' => 'AL',
        '35224' => 'AL',
        '35226' => 'AL',
        '35228' => 'AL',
        '35229' => 'AL',
        '35233' => 'AL',
        '35234' => 'AL',
        '35235' => 'AL',
        '35242' => 'AL',
        '35243' => 'AL',
        '35244' => 'AL',
        '35249' => 'AL',
        '35254' => 'AL',
        '35401' => 'AL',
        '35404' => 'AL',
        '35405' => 'AL',
        '35406' => 'AL',
        '35441' => 'AL',
        '35442' => 'AL',
        '35443' => 'AL',
        '35444' => 'AL',
        '35446' => 'AL',
        '35447' => 'AL',
        '35452' => 'AL',
        '35453' => 'AL',
        '35456' => 'AL',
        '35457' => 'AL',
        '35458' => 'AL',
        '35459' => 'AL',
        '35460' => 'AL',
        '35461' => 'AL',
        '35462' => 'AL',
        '35463' => 'AL',
        '35464' => 'AL',
        '35466' => 'AL',
        '35469' => 'AL',
        '35470' => 'AL',
        '35473' => 'AL',
        '35474' => 'AL',
        '35475' => 'AL',
        '35476' => 'AL',
        '35477' => 'AL',
        '35480' => 'AL',
        '35481' => 'AL',
        '35487' => 'AL',
        '35490' => 'AL',
        '35491' => 'AL',
        '35501' => 'AL',
        '35503' => 'AL',
        '35504' => 'AL',
        '35540' => 'AL',
        '35541' => 'AL',
        '35542' => 'AL',
        '35543' => 'AL',
        '35544' => 'AL',
        '35545' => 'AL',
        '35546' => 'AL',
        '35548' => 'AL',
        '35549' => 'AL',
        '35550' => 'AL',
        '35552' => 'AL',
        '35553' => 'AL',
        '35554' => 'AL',
        '35555' => 'AL',
        '35559' => 'AL',
        '35563' => 'AL',
        '35564' => 'AL',
        '35565' => 'AL',
        '35570' => 'AL',
        '35571' => 'AL',
        '35572' => 'AL',
        '35573' => 'AL',
        '35574' => 'AL',
        '35575' => 'AL',
        '35576' => 'AL',
        '35577' => 'AL',
        '35578' => 'AL',
        '35579' => 'AL',
        '35580' => 'AL',
        '35581' => 'AL',
        '35582' => 'AL',
        '35584' => 'AL',
        '35585' => 'AL',
        '35586' => 'AL',
        '35587' => 'AL',
        '35592' => 'AL',
        '35593' => 'AL',
        '35594' => 'AL',
        '35601' => 'AL',
        '35603' => 'AL',
        '35610' => 'AL',
        '35611' => 'AL',
        '35613' => 'AL',
        '35614' => 'AL',
        '35615' => 'AL',
        '35616' => 'AL',
        '35618' => 'AL',
        '35619' => 'AL',
        '35620' => 'AL',
        '35621' => 'AL',
        '35622' => 'AL',
        '35630' => 'AL',
        '35632' => 'AL',
        '35633' => 'AL',
        '35634' => 'AL',
        '35640' => 'AL',
        '35643' => 'AL',
        '35645' => 'AL',
        '35646' => 'AL',
        '35647' => 'AL',
        '35648' => 'AL',
        '35649' => 'AL',
        '35650' => 'AL',
        '35651' => 'AL',
        '35652' => 'AL',
        '35653' => 'AL',
        '35654' => 'AL',
        '35660' => 'AL',
        '35661' => 'AL',
        '35670' => 'AL',
        '35671' => 'AL',
        '35672' => 'AL',
        '35673' => 'AL',
        '35674' => 'AL',
        '35677' => 'AL',
        '35739' => 'AL',
        '35740' => 'AL',
        '35741' => 'AL',
        '35744' => 'AL',
        '35745' => 'AL',
        '35746' => 'AL',
        '35747' => 'AL',
        '35748' => 'AL',
        '35749' => 'AL',
        '35750' => 'AL',
        '35751' => 'AL',
        '35752' => 'AL',
        '35754' => 'AL',
        '35755' => 'AL',
        '35756' => 'AL',
        '35757' => 'AL',
        '35758' => 'AL',
        '35759' => 'AL',
        '35760' => 'AL',
        '35761' => 'AL',
        '35763' => 'AL',
        '35764' => 'AL',
        '35765' => 'AL',
        '35766' => 'AL',
        '35768' => 'AL',
        '35769' => 'AL',
        '35771' => 'AL',
        '35772' => 'AL',
        '35773' => 'AL',
        '35774' => 'AL',
        '35775' => 'AL',
        '35776' => 'AL',
        '35801' => 'AL',
        '35802' => 'AL',
        '35803' => 'AL',
        '35805' => 'AL',
        '35806' => 'AL',
        '35808' => 'AL',
        '35810' => 'AL',
        '35811' => 'AL',
        '35816' => 'AL',
        '35824' => 'AL',
        '35896' => 'AL',
        '35901' => 'AL',
        '35903' => 'AL',
        '35904' => 'AL',
        '35905' => 'AL',
        '35906' => 'AL',
        '35907' => 'AL',
        '35950' => 'AL',
        '35951' => 'AL',
        '35952' => 'AL',
        '35953' => 'AL',
        '35954' => 'AL',
        '35956' => 'AL',
        '35957' => 'AL',
        '35958' => 'AL',
        '35959' => 'AL',
        '35960' => 'AL',
        '35961' => 'AL',
        '35962' => 'AL',
        '35963' => 'AL',
        '35966' => 'AL',
        '35967' => 'AL',
        '35968' => 'AL',
        '35971' => 'AL',
        '35972' => 'AL',
        '35973' => 'AL',
        '35974' => 'AL',
        '35975' => 'AL',
        '35976' => 'AL',
        '35978' => 'AL',
        '35979' => 'AL',
        '35980' => 'AL',
        '35981' => 'AL',
        '35983' => 'AL',
        '35984' => 'AL',
        '35986' => 'AL',
        '35987' => 'AL',
        '35988' => 'AL',
        '35989' => 'AL',
        '35990' => 'AL',
        '36003' => 'AL',
        '36005' => 'AL',
        '36006' => 'AL',
        '36008' => 'AL',
        '36009' => 'AL',
        '36010' => 'AL',
        '36013' => 'AL',
        '36016' => 'AL',
        '36017' => 'AL',
        '36020' => 'AL',
        '36022' => 'AL',
        '36024' => 'AL',
        '36025' => 'AL',
        '36026' => 'AL',
        '36027' => 'AL',
        '36028' => 'AL',
        '36029' => 'AL',
        '36030' => 'AL',
        '36031' => 'AL',
        '36032' => 'AL',
        '36033' => 'AL',
        '36034' => 'AL',
        '36035' => 'AL',
        '36036' => 'AL',
        '36037' => 'AL',
        '36038' => 'AL',
        '36039' => 'AL',
        '36040' => 'AL',
        '36041' => 'AL',
        '36042' => 'AL',
        '36043' => 'AL',
        '36046' => 'AL',
        '36047' => 'AL',
        '36048' => 'AL',
        '36049' => 'AL',
        '36051' => 'AL',
        '36052' => 'AL',
        '36053' => 'AL',
        '36054' => 'AL',
        '36057' => 'AL',
        '36064' => 'AL',
        '36066' => 'AL',
        '36067' => 'AL',
        '36069' => 'AL',
        '36071' => 'AL',
        '36075' => 'AL',
        '36078' => 'AL',
        '36079' => 'AL',
        '36080' => 'AL',
        '36081' => 'AL',
        '36082' => 'AL',
        '36083' => 'AL',
        '36088' => 'AL',
        '36089' => 'AL',
        '36091' => 'AL',
        '36092' => 'AL',
        '36093' => 'AL',
        '36101' => 'AL',
        '36104' => 'AL',
        '36105' => 'AL',
        '36106' => 'AL',
        '36107' => 'AL',
        '36108' => 'AL',
        '36109' => 'AL',
        '36110' => 'AL',
        '36111' => 'AL',
        '36112' => 'AL',
        '36113' => 'AL',
        '36114' => 'AL',
        '36115' => 'AL',
        '36116' => 'AL',
        '36117' => 'AL',
        '36130' => 'AL',
        '36201' => 'AL',
        '36203' => 'AL',
        '36205' => 'AL',
        '36206' => 'AL',
        '36207' => 'AL',
        '36250' => 'AL',
        '36251' => 'AL',
        '36255' => 'AL',
        '36256' => 'AL',
        '36258' => 'AL',
        '36260' => 'AL',
        '36262' => 'AL',
        '36263' => 'AL',
        '36264' => 'AL',
        '36265' => 'AL',
        '36266' => 'AL',
        '36267' => 'AL',
        '36268' => 'AL',
        '36269' => 'AL',
        '36271' => 'AL',
        '36272' => 'AL',
        '36273' => 'AL',
        '36274' => 'AL',
        '36276' => 'AL',
        '36277' => 'AL',
        '36278' => 'AL',
        '36279' => 'AL',
        '36280' => 'AL',
        '36301' => 'AL',
        '36303' => 'AL',
        '36305' => 'AL',
        '36310' => 'AL',
        '36311' => 'AL',
        '36312' => 'AL',
        '36313' => 'AL',
        '36314' => 'AL',
        '36316' => 'AL',
        '36317' => 'AL',
        '36318' => 'AL',
        '36319' => 'AL',
        '36320' => 'AL',
        '36321' => 'AL',
        '36322' => 'AL',
        '36323' => 'AL',
        '36330' => 'AL',
        '36340' => 'AL',
        '36343' => 'AL',
        '36344' => 'AL',
        '36345' => 'AL',
        '36346' => 'AL',
        '36350' => 'AL',
        '36351' => 'AL',
        '36352' => 'AL',
        '36353' => 'AL',
        '36360' => 'AL',
        '36362' => 'AL',
        '36370' => 'AL',
        '36371' => 'AL',
        '36373' => 'AL',
        '36374' => 'AL',
        '36375' => 'AL',
        '36376' => 'AL',
        '36401' => 'AL',
        '36420' => 'AL',
        '36421' => 'AL',
        '36425' => 'AL',
        '36426' => 'AL',
        '36432' => 'AL',
        '36435' => 'AL',
        '36436' => 'AL',
        '36439' => 'AL',
        '36441' => 'AL',
        '36442' => 'AL',
        '36444' => 'AL',
        '36445' => 'AL',
        '36446' => 'AL',
        '36451' => 'AL',
        '36453' => 'AL',
        '36454' => 'AL',
        '36455' => 'AL',
        '36456' => 'AL',
        '36460' => 'AL',
        '36467' => 'AL',
        '36470' => 'AL',
        '36471' => 'AL',
        '36473' => 'AL',
        '36474' => 'AL',
        '36475' => 'AL',
        '36476' => 'AL',
        '36477' => 'AL',
        '36480' => 'AL',
        '36481' => 'AL',
        '36482' => 'AL',
        '36483' => 'AL',
        '36502' => 'AL',
        '36503' => 'AL',
        '36505' => 'AL',
        '36507' => 'AL',
        '36509' => 'AL',
        '36511' => 'AL',
        '36512' => 'AL',
        '36513' => 'AL',
        '36518' => 'AL',
        '36521' => 'AL',
        '36522' => 'AL',
        '36523' => 'AL',
        '36524' => 'AL',
        '36525' => 'AL',
        '36526' => 'AL',
        '36527' => 'AL',
        '36528' => 'AL',
        '36529' => 'AL',
        '36530' => 'AL',
        '36532' => 'AL',
        '36535' => 'AL',
        '36538' => 'AL',
        '36539' => 'AL',
        '36540' => 'AL',
        '36541' => 'AL',
        '36542' => 'AL',
        '36543' => 'AL',
        '36544' => 'AL',
        '36545' => 'AL',
        '36547' => 'AL',
        '36548' => 'AL',
        '36549' => 'AL',
        '36550' => 'AL',
        '36551' => 'AL',
        '36553' => 'AL',
        '36555' => 'AL',
        '36556' => 'AL',
        '36558' => 'AL',
        '36559' => 'AL',
        '36560' => 'AL',
        '36561' => 'AL',
        '36562' => 'AL',
        '36564' => 'AL',
        '36567' => 'AL',
        '36568' => 'AL',
        '36569' => 'AL',
        '36571' => 'AL',
        '36572' => 'AL',
        '36574' => 'AL',
        '36575' => 'AL',
        '36576' => 'AL',
        '36578' => 'AL',
        '36579' => 'AL',
        '36580' => 'AL',
        '36581' => 'AL',
        '36582' => 'AL',
        '36583' => 'AL',
        '36584' => 'AL',
        '36585' => 'AL',
        '36587' => 'AL',
        '36602' => 'AL',
        '36603' => 'AL',
        '36604' => 'AL',
        '36605' => 'AL',
        '36606' => 'AL',
        '36607' => 'AL',
        '36608' => 'AL',
        '36609' => 'AL',
        '36610' => 'AL',
        '36611' => 'AL',
        '36612' => 'AL',
        '36613' => 'AL',
        '36615' => 'AL',
        '36617' => 'AL',
        '36618' => 'AL',
        '36619' => 'AL',
        '36652' => 'AL',
        '36663' => 'AL',
        '36688' => 'AL',
        '36693' => 'AL',
        '36695' => 'AL',
        '36701' => 'AL',
        '36703' => 'AL',
        '36720' => 'AL',
        '36722' => 'AL',
        '36723' => 'AL',
        '36726' => 'AL',
        '36727' => 'AL',
        '36728' => 'AL',
        '36732' => 'AL',
        '36736' => 'AL',
        '36738' => 'AL',
        '36740' => 'AL',
        '36741' => 'AL',
        '36742' => 'AL',
        '36744' => 'AL',
        '36748' => 'AL',
        '36749' => 'AL',
        '36750' => 'AL',
        '36751' => 'AL',
        '36752' => 'AL',
        '36753' => 'AL',
        '36754' => 'AL',
        '36756' => 'AL',
        '36758' => 'AL',
        '36759' => 'AL',
        '36761' => 'AL',
        '36763' => 'AL',
        '36764' => 'AL',
        '36765' => 'AL',
        '36766' => 'AL',
        '36767' => 'AL',
        '36768' => 'AL',
        '36769' => 'AL',
        '36773' => 'AL',
        '36775' => 'AL',
        '36776' => 'AL',
        '36782' => 'AL',
        '36783' => 'AL',
        '36784' => 'AL',
        '36785' => 'AL',
        '36786' => 'AL',
        '36790' => 'AL',
        '36792' => 'AL',
        '36793' => 'AL',
        '36801' => 'AL',
        '36804' => 'AL',
        '36830' => 'AL',
        '36832' => 'AL',
        '36849' => 'AL',
        '36850' => 'AL',
        '36851' => 'AL',
        '36852' => 'AL',
        '36853' => 'AL',
        '36854' => 'AL',
        '36855' => 'AL',
        '36856' => 'AL',
        '36858' => 'AL',
        '36860' => 'AL',
        '36861' => 'AL',
        '36862' => 'AL',
        '36863' => 'AL',
        '36865' => 'AL',
        '36866' => 'AL',
        '36867' => 'AL',
        '36869' => 'AL',
        '36870' => 'AL',
        '36871' => 'AL',
        '36874' => 'AL',
        '36875' => 'AL',
        '36877' => 'AL',
        '36879' => 'AL',
        '36901' => 'AL',
        '36904' => 'AL',
        '36907' => 'AL',
        '36908' => 'AL',
        '36910' => 'AL',
        '36912' => 'AL',
        '36913' => 'AL',
        '36915' => 'AL',
        '36916' => 'AL',
        '36919' => 'AL',
        '36921' => 'AL',
        '36922' => 'AL',
        '36925' => 'AL',
        '37010' => 'TN',
        '37012' => 'TN',
        '37013' => 'TN',
        '37014' => 'TN',
        '37015' => 'TN',
        '37016' => 'TN',
        '37018' => 'TN',
        '37019' => 'TN',
        '37020' => 'TN',
        '37022' => 'TN',
        '37023' => 'TN',
        '37025' => 'TN',
        '37026' => 'TN',
        '37027' => 'TN',
        '37028' => 'TN',
        '37029' => 'TN',
        '37030' => 'TN',
        '37031' => 'TN',
        '37032' => 'TN',
        '37033' => 'TN',
        '37034' => 'TN',
        '37035' => 'TN',
        '37036' => 'TN',
        '37037' => 'TN',
        '37040' => 'TN',
        '37042' => 'TN',
        '37043' => 'TN',
        '37046' => 'TN',
        '37047' => 'TN',
        '37048' => 'TN',
        '37049' => 'TN',
        '37050' => 'TN',
        '37051' => 'TN',
        '37052' => 'TN',
        '37055' => 'TN',
        '37057' => 'TN',
        '37058' => 'TN',
        '37059' => 'TN',
        '37060' => 'TN',
        '37061' => 'TN',
        '37062' => 'TN',
        '37064' => 'TN',
        '37066' => 'TN',
        '37067' => 'TN',
        '37069' => 'TN',
        '37072' => 'TN',
        '37073' => 'TN',
        '37074' => 'TN',
        '37075' => 'TN',
        '37076' => 'TN',
        '37078' => 'TN',
        '37079' => 'TN',
        '37080' => 'TN',
        '37082' => 'TN',
        '37083' => 'TN',
        '37085' => 'TN',
        '37086' => 'TN',
        '37087' => 'TN',
        '37090' => 'TN',
        '37091' => 'TN',
        '37095' => 'TN',
        '37096' => 'TN',
        '37097' => 'TN',
        '37098' => 'TN',
        '37101' => 'TN',
        '37110' => 'TN',
        '37115' => 'TN',
        '37118' => 'TN',
        '37122' => 'TN',
        '37127' => 'TN',
        '37128' => 'TN',
        '37129' => 'TN',
        '37130' => 'TN',
        '37132' => 'TN',
        '37134' => 'TN',
        '37135' => 'TN',
        '37137' => 'TN',
        '37138' => 'TN',
        '37140' => 'TN',
        '37141' => 'TN',
        '37142' => 'TN',
        '37143' => 'TN',
        '37144' => 'TN',
        '37145' => 'TN',
        '37146' => 'TN',
        '37148' => 'TN',
        '37149' => 'TN',
        '37150' => 'TN',
        '37151' => 'TN',
        '37153' => 'TN',
        '37160' => 'TN',
        '37165' => 'TN',
        '37166' => 'TN',
        '37167' => 'TN',
        '37171' => 'TN',
        '37172' => 'TN',
        '37174' => 'TN',
        '37175' => 'TN',
        '37178' => 'TN',
        '37179' => 'TN',
        '37180' => 'TN',
        '37181' => 'TN',
        '37183' => 'TN',
        '37184' => 'TN',
        '37185' => 'TN',
        '37186' => 'TN',
        '37187' => 'TN',
        '37188' => 'TN',
        '37189' => 'TN',
        '37190' => 'TN',
        '37191' => 'TN',
        '37201' => 'TN',
        '37203' => 'TN',
        '37204' => 'TN',
        '37205' => 'TN',
        '37206' => 'TN',
        '37207' => 'TN',
        '37208' => 'TN',
        '37209' => 'TN',
        '37210' => 'TN',
        '37211' => 'TN',
        '37212' => 'TN',
        '37213' => 'TN',
        '37214' => 'TN',
        '37215' => 'TN',
        '37216' => 'TN',
        '37217' => 'TN',
        '37218' => 'TN',
        '37219' => 'TN',
        '37220' => 'TN',
        '37221' => 'TN',
        '37228' => 'TN',
        '37232' => 'TN',
        '37238' => 'TN',
        '37301' => 'TN',
        '37302' => 'TN',
        '37303' => 'TN',
        '37305' => 'TN',
        '37306' => 'TN',
        '37307' => 'TN',
        '37308' => 'TN',
        '37309' => 'TN',
        '37310' => 'TN',
        '37311' => 'TN',
        '37312' => 'TN',
        '37313' => 'TN',
        '37315' => 'TN',
        '37316' => 'TN',
        '37317' => 'TN',
        '37318' => 'TN',
        '37321' => 'TN',
        '37322' => 'TN',
        '37323' => 'TN',
        '37324' => 'TN',
        '37325' => 'TN',
        '37326' => 'TN',
        '37327' => 'TN',
        '37328' => 'TN',
        '37329' => 'TN',
        '37330' => 'TN',
        '37331' => 'TN',
        '37332' => 'TN',
        '37333' => 'TN',
        '37334' => 'TN',
        '37335' => 'TN',
        '37336' => 'TN',
        '37337' => 'TN',
        '37338' => 'TN',
        '37339' => 'TN',
        '37340' => 'TN',
        '37341' => 'TN',
        '37342' => 'TN',
        '37343' => 'TN',
        '37345' => 'TN',
        '37347' => 'TN',
        '37348' => 'TN',
        '37350' => 'TN',
        '37351' => 'TN',
        '37352' => 'TN',
        '37353' => 'TN',
        '37354' => 'TN',
        '37355' => 'TN',
        '37356' => 'TN',
        '37357' => 'TN',
        '37359' => 'TN',
        '37360' => 'TN',
        '37361' => 'TN',
        '37362' => 'TN',
        '37363' => 'TN',
        '37365' => 'TN',
        '37366' => 'TN',
        '37367' => 'TN',
        '37369' => 'TN',
        '37370' => 'TN',
        '37373' => 'TN',
        '37374' => 'TN',
        '37375' => 'TN',
        '37376' => 'TN',
        '37377' => 'TN',
        '37379' => 'TN',
        '37380' => 'TN',
        '37381' => 'TN',
        '37383' => 'TN',
        '37385' => 'TN',
        '37387' => 'TN',
        '37388' => 'TN',
        '37391' => 'TN',
        '37394' => 'TN',
        '37396' => 'TN',
        '37397' => 'TN',
        '37398' => 'TN',
        '37402' => 'TN',
        '37403' => 'TN',
        '37404' => 'TN',
        '37405' => 'TN',
        '37406' => 'TN',
        '37407' => 'TN',
        '37408' => 'TN',
        '37409' => 'TN',
        '37410' => 'TN',
        '37411' => 'TN',
        '37412' => 'TN',
        '37415' => 'TN',
        '37416' => 'TN',
        '37419' => 'TN',
        '37421' => 'TN',
        '37450' => 'TN',
        '37601' => 'TN',
        '37604' => 'TN',
        '37614' => 'TN',
        '37615' => 'TN',
        '37616' => 'TN',
        '37617' => 'TN',
        '37618' => 'TN',
        '37620' => 'TN',
        '37640' => 'TN',
        '37641' => 'TN',
        '37642' => 'TN',
        '37643' => 'TN',
        '37645' => 'TN',
        '37650' => 'TN',
        '37656' => 'TN',
        '37657' => 'TN',
        '37658' => 'TN',
        '37659' => 'TN',
        '37660' => 'TN',
        '37663' => 'TN',
        '37664' => 'TN',
        '37665' => 'TN',
        '37680' => 'TN',
        '37681' => 'TN',
        '37682' => 'TN',
        '37683' => 'TN',
        '37686' => 'TN',
        '37687' => 'TN',
        '37688' => 'TN',
        '37690' => 'TN',
        '37691' => 'TN',
        '37692' => 'TN',
        '37694' => 'TN',
        '37701' => 'TN',
        '37705' => 'TN',
        '37708' => 'TN',
        '37709' => 'TN',
        '37710' => 'TN',
        '37711' => 'TN',
        '37713' => 'TN',
        '37714' => 'TN',
        '37715' => 'TN',
        '37716' => 'TN',
        '37719' => 'TN',
        '37721' => 'TN',
        '37722' => 'TN',
        '37723' => 'TN',
        '37724' => 'TN',
        '37725' => 'TN',
        '37726' => 'TN',
        '37727' => 'TN',
        '37729' => 'TN',
        '37730' => 'TN',
        '37731' => 'TN',
        '37732' => 'TN',
        '37733' => 'TN',
        '37737' => 'TN',
        '37738' => 'TN',
        '37742' => 'TN',
        '37743' => 'TN',
        '37745' => 'TN',
        '37748' => 'TN',
        '37752' => 'TN',
        '37753' => 'TN',
        '37754' => 'TN',
        '37755' => 'TN',
        '37756' => 'TN',
        '37757' => 'TN',
        '37760' => 'TN',
        '37762' => 'TN',
        '37763' => 'TN',
        '37764' => 'TN',
        '37765' => 'TN',
        '37766' => 'TN',
        '37769' => 'TN',
        '37770' => 'TN',
        '37771' => 'TN',
        '37772' => 'TN',
        '37774' => 'TN',
        '37777' => 'TN',
        '37779' => 'TN',
        '37801' => 'TN',
        '37803' => 'TN',
        '37804' => 'TN',
        '37806' => 'TN',
        '37807' => 'TN',
        '37809' => 'TN',
        '37810' => 'TN',
        '37811' => 'TN',
        '37813' => 'TN',
        '37814' => 'TN',
        '37818' => 'TN',
        '37819' => 'TN',
        '37820' => 'TN',
        '37821' => 'TN',
        '37825' => 'TN',
        '37826' => 'TN',
        '37828' => 'TN',
        '37829' => 'TN',
        '37830' => 'TN',
        '37840' => 'TN',
        '37841' => 'TN',
        '37843' => 'TN',
        '37845' => 'TN',
        '37846' => 'TN',
        '37847' => 'TN',
        '37848' => 'TN',
        '37849' => 'TN',
        '37851' => 'TN',
        '37852' => 'TN',
        '37853' => 'TN',
        '37854' => 'TN',
        '37857' => 'TN',
        '37860' => 'TN',
        '37861' => 'TN',
        '37862' => 'TN',
        '37863' => 'TN',
        '37865' => 'TN',
        '37866' => 'TN',
        '37869' => 'TN',
        '37870' => 'TN',
        '37871' => 'TN',
        '37872' => 'TN',
        '37873' => 'TN',
        '37874' => 'TN',
        '37876' => 'TN',
        '37877' => 'TN',
        '37878' => 'TN',
        '37879' => 'TN',
        '37880' => 'TN',
        '37881' => 'TN',
        '37882' => 'TN',
        '37885' => 'TN',
        '37886' => 'TN',
        '37887' => 'TN',
        '37888' => 'TN',
        '37890' => 'TN',
        '37891' => 'TN',
        '37892' => 'TN',
        '37902' => 'TN',
        '37909' => 'TN',
        '37912' => 'TN',
        '37914' => 'TN',
        '37915' => 'TN',
        '37916' => 'TN',
        '37917' => 'TN',
        '37918' => 'TN',
        '37919' => 'TN',
        '37920' => 'TN',
        '37921' => 'TN',
        '37922' => 'TN',
        '37923' => 'TN',
        '37924' => 'TN',
        '37929' => 'TN',
        '37931' => 'TN',
        '37932' => 'TN',
        '37934' => 'TN',
        '37938' => 'TN',
        '38001' => 'TN',
        '38002' => 'TN',
        '38004' => 'TN',
        '38006' => 'TN',
        '38007' => 'TN',
        '38008' => 'TN',
        '38011' => 'TN',
        '38012' => 'TN',
        '38015' => 'TN',
        '38016' => 'TN',
        '38017' => 'TN',
        '38018' => 'TN',
        '38019' => 'TN',
        '38021' => 'TN',
        '38023' => 'TN',
        '38024' => 'TN',
        '38028' => 'TN',
        '38029' => 'TN',
        '38030' => 'TN',
        '38034' => 'TN',
        '38036' => 'TN',
        '38037' => 'TN',
        '38039' => 'TN',
        '38040' => 'TN',
        '38041' => 'TN',
        '38042' => 'TN',
        '38044' => 'TN',
        '38046' => 'TN',
        '38047' => 'TN',
        '38049' => 'TN',
        '38050' => 'TN',
        '38052' => 'TN',
        '38053' => 'TN',
        '38054' => 'TN',
        '38057' => 'TN',
        '38058' => 'TN',
        '38059' => 'TN',
        '38060' => 'TN',
        '38061' => 'TN',
        '38063' => 'TN',
        '38066' => 'TN',
        '38067' => 'TN',
        '38068' => 'TN',
        '38069' => 'TN',
        '38070' => 'TN',
        '38075' => 'TN',
        '38076' => 'TN',
        '38077' => 'TN',
        '38079' => 'TN',
        '38080' => 'TN',
        '38103' => 'TN',
        '38104' => 'TN',
        '38105' => 'TN',
        '38106' => 'TN',
        '38107' => 'TN',
        '38108' => 'TN',
        '38109' => 'TN',
        '38111' => 'TN',
        '38112' => 'TN',
        '38113' => 'TN',
        '38114' => 'TN',
        '38115' => 'TN',
        '38116' => 'TN',
        '38117' => 'TN',
        '38118' => 'TN',
        '38119' => 'TN',
        '38120' => 'TN',
        '38122' => 'TN',
        '38125' => 'TN',
        '38126' => 'TN',
        '38127' => 'TN',
        '38128' => 'TN',
        '38131' => 'TN',
        '38132' => 'TN',
        '38133' => 'TN',
        '38134' => 'TN',
        '38135' => 'TN',
        '38138' => 'TN',
        '38139' => 'TN',
        '38141' => 'TN',
        '38152' => 'TN',
        '38201' => 'TN',
        '38220' => 'TN',
        '38221' => 'TN',
        '38222' => 'TN',
        '38224' => 'TN',
        '38225' => 'TN',
        '38226' => 'TN',
        '38229' => 'TN',
        '38230' => 'TN',
        '38231' => 'TN',
        '38232' => 'TN',
        '38233' => 'TN',
        '38235' => 'TN',
        '38236' => 'TN',
        '38237' => 'TN',
        '38240' => 'TN',
        '38241' => 'TN',
        '38242' => 'TN',
        '38251' => 'TN',
        '38253' => 'TN',
        '38254' => 'TN',
        '38255' => 'TN',
        '38256' => 'TN',
        '38257' => 'TN',
        '38258' => 'TN',
        '38259' => 'TN',
        '38260' => 'TN',
        '38261' => 'TN',
        '38301' => 'TN',
        '38305' => 'TN',
        '38310' => 'TN',
        '38311' => 'TN',
        '38313' => 'TN',
        '38315' => 'TN',
        '38316' => 'TN',
        '38317' => 'TN',
        '38318' => 'TN',
        '38320' => 'TN',
        '38321' => 'TN',
        '38326' => 'TN',
        '38327' => 'TN',
        '38328' => 'TN',
        '38329' => 'TN',
        '38330' => 'TN',
        '38332' => 'TN',
        '38333' => 'TN',
        '38334' => 'TN',
        '38337' => 'TN',
        '38338' => 'TN',
        '38339' => 'TN',
        '38340' => 'TN',
        '38341' => 'TN',
        '38342' => 'TN',
        '38343' => 'TN',
        '38344' => 'TN',
        '38345' => 'TN',
        '38347' => 'TN',
        '38348' => 'TN',
        '38351' => 'TN',
        '38352' => 'TN',
        '38355' => 'TN',
        '38356' => 'TN',
        '38357' => 'TN',
        '38358' => 'TN',
        '38359' => 'TN',
        '38361' => 'TN',
        '38362' => 'TN',
        '38363' => 'TN',
        '38365' => 'TN',
        '38366' => 'TN',
        '38367' => 'TN',
        '38368' => 'TN',
        '38369' => 'TN',
        '38370' => 'TN',
        '38371' => 'TN',
        '38372' => 'TN',
        '38374' => 'TN',
        '38375' => 'TN',
        '38376' => 'TN',
        '38379' => 'TN',
        '38380' => 'TN',
        '38381' => 'TN',
        '38382' => 'TN',
        '38387' => 'TN',
        '38388' => 'TN',
        '38389' => 'TN',
        '38390' => 'TN',
        '38391' => 'TN',
        '38392' => 'TN',
        '38401' => 'TN',
        '38425' => 'TN',
        '38449' => 'TN',
        '38450' => 'TN',
        '38451' => 'TN',
        '38452' => 'TN',
        '38453' => 'TN',
        '38454' => 'TN',
        '38455' => 'TN',
        '38456' => 'TN',
        '38457' => 'TN',
        '38459' => 'TN',
        '38460' => 'TN',
        '38461' => 'TN',
        '38462' => 'TN',
        '38463' => 'TN',
        '38464' => 'TN',
        '38468' => 'TN',
        '38469' => 'TN',
        '38471' => 'TN',
        '38472' => 'TN',
        '38473' => 'TN',
        '38474' => 'TN',
        '38475' => 'TN',
        '38476' => 'TN',
        '38477' => 'TN',
        '38478' => 'TN',
        '38481' => 'TN',
        '38482' => 'TN',
        '38483' => 'TN',
        '38485' => 'TN',
        '38486' => 'TN',
        '38487' => 'TN',
        '38488' => 'TN',
        '38501' => 'TN',
        '38503' => 'TN',
        '38504' => 'TN',
        '38505' => 'TN',
        '38506' => 'TN',
        '38541' => 'TN',
        '38542' => 'TN',
        '38543' => 'TN',
        '38544' => 'TN',
        '38545' => 'TN',
        '38547' => 'TN',
        '38548' => 'TN',
        '38549' => 'TN',
        '38550' => 'TN',
        '38551' => 'TN',
        '38552' => 'TN',
        '38553' => 'TN',
        '38554' => 'TN',
        '38555' => 'TN',
        '38556' => 'TN',
        '38558' => 'TN',
        '38559' => 'TN',
        '38560' => 'TN',
        '38562' => 'TN',
        '38563' => 'TN',
        '38564' => 'TN',
        '38565' => 'TN',
        '38567' => 'TN',
        '38568' => 'TN',
        '38569' => 'TN',
        '38570' => 'TN',
        '38571' => 'TN',
        '38572' => 'TN',
        '38573' => 'TN',
        '38574' => 'TN',
        '38575' => 'TN',
        '38577' => 'TN',
        '38578' => 'TN',
        '38579' => 'TN',
        '38580' => 'TN',
        '38581' => 'TN',
        '38582' => 'TN',
        '38583' => 'TN',
        '38585' => 'TN',
        '38587' => 'TN',
        '38588' => 'TN',
        '38589' => 'TN',
        '38601' => 'MS',
        '38603' => 'MS',
        '38606' => 'MS',
        '38610' => 'MS',
        '38611' => 'MS',
        '38614' => 'MS',
        '38617' => 'MS',
        '38618' => 'MS',
        '38619' => 'MS',
        '38620' => 'MS',
        '38621' => 'MS',
        '38622' => 'MS',
        '38623' => 'MS',
        '38625' => 'MS',
        '38626' => 'MS',
        '38627' => 'MS',
        '38629' => 'MS',
        '38631' => 'MS',
        '38632' => 'MS',
        '38633' => 'MS',
        '38635' => 'MS',
        '38637' => 'MS',
        '38639' => 'MS',
        '38641' => 'MS',
        '38642' => 'MS',
        '38643' => 'MS',
        '38644' => 'MS',
        '38645' => 'MS',
        '38646' => 'MS',
        '38647' => 'MS',
        '38650' => 'MS',
        '38651' => 'MS',
        '38652' => 'MS',
        '38654' => 'MS',
        '38655' => 'MS',
        '38658' => 'MS',
        '38659' => 'MS',
        '38661' => 'MS',
        '38663' => 'MS',
        '38664' => 'MS',
        '38665' => 'MS',
        '38666' => 'MS',
        '38668' => 'MS',
        '38670' => 'MS',
        '38671' => 'MS',
        '38672' => 'MS',
        '38673' => 'MS',
        '38674' => 'MS',
        '38676' => 'MS',
        '38677' => 'MS',
        '38680' => 'MS',
        '38683' => 'MS',
        '38685' => 'MS',
        '38701' => 'MS',
        '38703' => 'MS',
        '38720' => 'MS',
        '38721' => 'MS',
        '38722' => 'MS',
        '38723' => 'MS',
        '38725' => 'MS',
        '38726' => 'MS',
        '38730' => 'MS',
        '38731' => 'MS',
        '38732' => 'MS',
        '38733' => 'MS',
        '38736' => 'MS',
        '38737' => 'MS',
        '38738' => 'MS',
        '38740' => 'MS',
        '38744' => 'MS',
        '38745' => 'MS',
        '38746' => 'MS',
        '38748' => 'MS',
        '38751' => 'MS',
        '38753' => 'MS',
        '38754' => 'MS',
        '38756' => 'MS',
        '38759' => 'MS',
        '38760' => 'MS',
        '38761' => 'MS',
        '38762' => 'MS',
        '38764' => 'MS',
        '38765' => 'MS',
        '38767' => 'MS',
        '38768' => 'MS',
        '38769' => 'MS',
        '38771' => 'MS',
        '38772' => 'MS',
        '38773' => 'MS',
        '38774' => 'MS',
        '38776' => 'MS',
        '38778' => 'MS',
        '38781' => 'MS',
        '38801' => 'MS',
        '38804' => 'MS',
        '38821' => 'MS',
        '38824' => 'MS',
        '38826' => 'MS',
        '38827' => 'MS',
        '38828' => 'MS',
        '38829' => 'MS',
        '38833' => 'MS',
        '38834' => 'MS',
        '38838' => 'MS',
        '38839' => 'MS',
        '38841' => 'MS',
        '38843' => 'MS',
        '38844' => 'MS',
        '38846' => 'MS',
        '38847' => 'MS',
        '38848' => 'MS',
        '38849' => 'MS',
        '38850' => 'MS',
        '38851' => 'MS',
        '38852' => 'MS',
        '38855' => 'MS',
        '38856' => 'MS',
        '38857' => 'MS',
        '38858' => 'MS',
        '38859' => 'MS',
        '38860' => 'MS',
        '38862' => 'MS',
        '38863' => 'MS',
        '38864' => 'MS',
        '38865' => 'MS',
        '38866' => 'MS',
        '38868' => 'MS',
        '38869' => 'MS',
        '38870' => 'MS',
        '38871' => 'MS',
        '38873' => 'MS',
        '38876' => 'MS',
        '38878' => 'MS',
        '38879' => 'MS',
        '38901' => 'MS',
        '38913' => 'MS',
        '38914' => 'MS',
        '38915' => 'MS',
        '38916' => 'MS',
        '38917' => 'MS',
        '38920' => 'MS',
        '38921' => 'MS',
        '38922' => 'MS',
        '38923' => 'MS',
        '38924' => 'MS',
        '38925' => 'MS',
        '38927' => 'MS',
        '38928' => 'MS',
        '38929' => 'MS',
        '38930' => 'MS',
        '38940' => 'MS',
        '38941' => 'MS',
        '38943' => 'MS',
        '38944' => 'MS',
        '38946' => 'MS',
        '38947' => 'MS',
        '38948' => 'MS',
        '38949' => 'MS',
        '38950' => 'MS',
        '38951' => 'MS',
        '38952' => 'MS',
        '38953' => 'MS',
        '38954' => 'MS',
        '38957' => 'MS',
        '38961' => 'MS',
        '38962' => 'MS',
        '38963' => 'MS',
        '38964' => 'MS',
        '38965' => 'MS',
        '38966' => 'MS',
        '38967' => 'MS',
        '39038' => 'MS',
        '39039' => 'MS',
        '39040' => 'MS',
        '39041' => 'MS',
        '39042' => 'MS',
        '39044' => 'MS',
        '39045' => 'MS',
        '39046' => 'MS',
        '39047' => 'MS',
        '39051' => 'MS',
        '39054' => 'MS',
        '39056' => 'MS',
        '39057' => 'MS',
        '39058' => 'MS',
        '39059' => 'MS',
        '39061' => 'MS',
        '39062' => 'MS',
        '39063' => 'MS',
        '39066' => 'MS',
        '39067' => 'MS',
        '39069' => 'MS',
        '39071' => 'MS',
        '39073' => 'MS',
        '39074' => 'MS',
        '39078' => 'MS',
        '39079' => 'MS',
        '39082' => 'MS',
        '39083' => 'MS',
        '39086' => 'MS',
        '39088' => 'MS',
        '39090' => 'MS',
        '39092' => 'MS',
        '39094' => 'MS',
        '39095' => 'MS',
        '39096' => 'MS',
        '39097' => 'MS',
        '39108' => 'MS',
        '39110' => 'MS',
        '39111' => 'MS',
        '39113' => 'MS',
        '39114' => 'MS',
        '39115' => 'MS',
        '39116' => 'MS',
        '39117' => 'MS',
        '39119' => 'MS',
        '39120' => 'MS',
        '39140' => 'MS',
        '39144' => 'MS',
        '39145' => 'MS',
        '39146' => 'MS',
        '39148' => 'MS',
        '39149' => 'MS',
        '39150' => 'MS',
        '39152' => 'MS',
        '39153' => 'MS',
        '39154' => 'MS',
        '39156' => 'MS',
        '39157' => 'MS',
        '39159' => 'MS',
        '39160' => 'MS',
        '39162' => 'MS',
        '39166' => 'MS',
        '39167' => 'MS',
        '39168' => 'MS',
        '39169' => 'MS',
        '39170' => 'MS',
        '39173' => 'MS',
        '39174' => 'MS',
        '39175' => 'MS',
        '39176' => 'MS',
        '39177' => 'MS',
        '39179' => 'MS',
        '39180' => 'MS',
        '39183' => 'MS',
        '39189' => 'MS',
        '39191' => 'MS',
        '39192' => 'MS',
        '39193' => 'MS',
        '39194' => 'MS',
        '39201' => 'MS',
        '39202' => 'MS',
        '39203' => 'MS',
        '39204' => 'MS',
        '39206' => 'MS',
        '39208' => 'MS',
        '39209' => 'MS',
        '39210' => 'MS',
        '39211' => 'MS',
        '39212' => 'MS',
        '39213' => 'MS',
        '39216' => 'MS',
        '39217' => 'MS',
        '39218' => 'MS',
        '39232' => 'MS',
        '39269' => 'MS',
        '39272' => 'MS',
        '39301' => 'MS',
        '39305' => 'MS',
        '39307' => 'MS',
        '39309' => 'MS',
        '39320' => 'MS',
        '39322' => 'MS',
        '39323' => 'MS',
        '39324' => 'MS',
        '39325' => 'MS',
        '39326' => 'MS',
        '39327' => 'MS',
        '39328' => 'MS',
        '39330' => 'MS',
        '39332' => 'MS',
        '39335' => 'MS',
        '39336' => 'MS',
        '39337' => 'MS',
        '39338' => 'MS',
        '39339' => 'MS',
        '39341' => 'MS',
        '39342' => 'MS',
        '39345' => 'MS',
        '39346' => 'MS',
        '39347' => 'MS',
        '39348' => 'MS',
        '39350' => 'MS',
        '39352' => 'MS',
        '39354' => 'MS',
        '39355' => 'MS',
        '39356' => 'MS',
        '39358' => 'MS',
        '39359' => 'MS',
        '39360' => 'MS',
        '39361' => 'MS',
        '39362' => 'MS',
        '39363' => 'MS',
        '39364' => 'MS',
        '39365' => 'MS',
        '39366' => 'MS',
        '39367' => 'MS',
        '39401' => 'MS',
        '39402' => 'MS',
        '39406' => 'MS',
        '39421' => 'MS',
        '39422' => 'MS',
        '39423' => 'MS',
        '39425' => 'MS',
        '39426' => 'MS',
        '39427' => 'MS',
        '39428' => 'MS',
        '39429' => 'MS',
        '39437' => 'MS',
        '39439' => 'MS',
        '39440' => 'MS',
        '39443' => 'MS',
        '39451' => 'MS',
        '39452' => 'MS',
        '39455' => 'MS',
        '39456' => 'MS',
        '39459' => 'MS',
        '39461' => 'MS',
        '39462' => 'MS',
        '39464' => 'MS',
        '39465' => 'MS',
        '39466' => 'MS',
        '39470' => 'MS',
        '39474' => 'MS',
        '39475' => 'MS',
        '39476' => 'MS',
        '39477' => 'MS',
        '39478' => 'MS',
        '39479' => 'MS',
        '39480' => 'MS',
        '39481' => 'MS',
        '39482' => 'MS',
        '39483' => 'MS',
        '39501' => 'MS',
        '39503' => 'MS',
        '39507' => 'MS',
        '39520' => 'MS',
        '39525' => 'MS',
        '39529' => 'MS',
        '39530' => 'MS',
        '39531' => 'MS',
        '39532' => 'MS',
        '39534' => 'MS',
        '39540' => 'MS',
        '39553' => 'MS',
        '39556' => 'MS',
        '39560' => 'MS',
        '39561' => 'MS',
        '39562' => 'MS',
        '39563' => 'MS',
        '39564' => 'MS',
        '39565' => 'MS',
        '39567' => 'MS',
        '39571' => 'MS',
        '39572' => 'MS',
        '39573' => 'MS',
        '39574' => 'MS',
        '39576' => 'MS',
        '39577' => 'MS',
        '39581' => 'MS',
        '39595' => 'MS',
        '39601' => 'MS',
        '39629' => 'MS',
        '39630' => 'MS',
        '39631' => 'MS',
        '39633' => 'MS',
        '39635' => 'MS',
        '39638' => 'MS',
        '39641' => 'MS',
        '39643' => 'MS',
        '39645' => 'MS',
        '39647' => 'MS',
        '39648' => 'MS',
        '39652' => 'MS',
        '39653' => 'MS',
        '39654' => 'MS',
        '39656' => 'MS',
        '39657' => 'MS',
        '39661' => 'MS',
        '39662' => 'MS',
        '39663' => 'MS',
        '39664' => 'MS',
        '39665' => 'MS',
        '39666' => 'MS',
        '39667' => 'MS',
        '39668' => 'MS',
        '39669' => 'MS',
        '39701' => 'MS',
        '39702' => 'MS',
        '39705' => 'MS',
        '39730' => 'MS',
        '39735' => 'MS',
        '39736' => 'MS',
        '39737' => 'MS',
        '39739' => 'MS',
        '39740' => 'MS',
        '39741' => 'MS',
        '39743' => 'MS',
        '39744' => 'MS',
        '39745' => 'MS',
        '39746' => 'MS',
        '39747' => 'MS',
        '39750' => 'MS',
        '39751' => 'MS',
        '39752' => 'MS',
        '39753' => 'MS',
        '39755' => 'MS',
        '39756' => 'MS',
        '39759' => 'MS',
        '39762' => 'MS',
        '39766' => 'MS',
        '39767' => 'MS',
        '39769' => 'MS',
        '39771' => 'MS',
        '39772' => 'MS',
        '39773' => 'MS',
        '39776' => 'MS',
        '39813' => 'GA',
        '39815' => 'GA',
        '39817' => 'GA',
        '39819' => 'GA',
        '39823' => 'GA',
        '39824' => 'GA',
        '39825' => 'GA',
        '39826' => 'GA',
        '39827' => 'GA',
        '39828' => 'GA',
        '39832' => 'GA',
        '39834' => 'GA',
        '39836' => 'GA',
        '39837' => 'GA',
        '39840' => 'GA',
        '39841' => 'GA',
        '39842' => 'GA',
        '39845' => 'GA',
        '39846' => 'GA',
        '39851' => 'GA',
        '39854' => 'GA',
        '39859' => 'GA',
        '39861' => 'GA',
        '39862' => 'GA',
        '39866' => 'GA',
        '39867' => 'GA',
        '39870' => 'GA',
        '39877' => 'GA',
        '39885' => 'GA',
        '39886' => 'GA',
        '39897' => 'GA',
        '40003' => 'KY',
        '40004' => 'KY',
        '40006' => 'KY',
        '40007' => 'KY',
        '40008' => 'KY',
        '40009' => 'KY',
        '40010' => 'KY',
        '40011' => 'KY',
        '40012' => 'KY',
        '40013' => 'KY',
        '40014' => 'KY',
        '40019' => 'KY',
        '40020' => 'KY',
        '40022' => 'KY',
        '40023' => 'KY',
        '40025' => 'KY',
        '40026' => 'KY',
        '40031' => 'KY',
        '40033' => 'KY',
        '40036' => 'KY',
        '40037' => 'KY',
        '40040' => 'KY',
        '40041' => 'KY',
        '40045' => 'KY',
        '40046' => 'KY',
        '40047' => 'KY',
        '40049' => 'KY',
        '40050' => 'KY',
        '40051' => 'KY',
        '40052' => 'KY',
        '40055' => 'KY',
        '40056' => 'KY',
        '40057' => 'KY',
        '40058' => 'KY',
        '40059' => 'KY',
        '40060' => 'KY',
        '40061' => 'KY',
        '40062' => 'KY',
        '40063' => 'KY',
        '40065' => 'KY',
        '40067' => 'KY',
        '40068' => 'KY',
        '40069' => 'KY',
        '40070' => 'KY',
        '40071' => 'KY',
        '40075' => 'KY',
        '40076' => 'KY',
        '40077' => 'KY',
        '40078' => 'KY',
        '40104' => 'KY',
        '40107' => 'KY',
        '40108' => 'KY',
        '40109' => 'KY',
        '40110' => 'KY',
        '40111' => 'KY',
        '40115' => 'KY',
        '40117' => 'KY',
        '40118' => 'KY',
        '40119' => 'KY',
        '40121' => 'KY',
        '40140' => 'KY',
        '40142' => 'KY',
        '40143' => 'KY',
        '40144' => 'KY',
        '40145' => 'KY',
        '40146' => 'KY',
        '40150' => 'KY',
        '40152' => 'KY',
        '40155' => 'KY',
        '40157' => 'KY',
        '40160' => 'KY',
        '40161' => 'KY',
        '40162' => 'KY',
        '40165' => 'KY',
        '40170' => 'KY',
        '40171' => 'KY',
        '40175' => 'KY',
        '40176' => 'KY',
        '40177' => 'KY',
        '40178' => 'KY',
        '40202' => 'KY',
        '40203' => 'KY',
        '40204' => 'KY',
        '40205' => 'KY',
        '40206' => 'KY',
        '40207' => 'KY',
        '40208' => 'KY',
        '40209' => 'KY',
        '40210' => 'KY',
        '40211' => 'KY',
        '40212' => 'KY',
        '40213' => 'KY',
        '40214' => 'KY',
        '40215' => 'KY',
        '40216' => 'KY',
        '40217' => 'KY',
        '40218' => 'KY',
        '40219' => 'KY',
        '40220' => 'KY',
        '40221' => 'KY',
        '40222' => 'KY',
        '40223' => 'KY',
        '40228' => 'KY',
        '40229' => 'KY',
        '40231' => 'KY',
        '40241' => 'KY',
        '40242' => 'KY',
        '40243' => 'KY',
        '40245' => 'KY',
        '40258' => 'KY',
        '40272' => 'KY',
        '40280' => 'KY',
        '40291' => 'KY',
        '40299' => 'KY',
        '40310' => 'KY',
        '40311' => 'KY',
        '40312' => 'KY',
        '40313' => 'KY',
        '40316' => 'KY',
        '40322' => 'KY',
        '40324' => 'KY',
        '40328' => 'KY',
        '40330' => 'KY',
        '40334' => 'KY',
        '40336' => 'KY',
        '40337' => 'KY',
        '40339' => 'KY',
        '40342' => 'KY',
        '40346' => 'KY',
        '40347' => 'KY',
        '40348' => 'KY',
        '40350' => 'KY',
        '40351' => 'KY',
        '40353' => 'KY',
        '40355' => 'KY',
        '40356' => 'KY',
        '40357' => 'KY',
        '40358' => 'KY',
        '40359' => 'KY',
        '40360' => 'KY',
        '40361' => 'KY',
        '40363' => 'KY',
        '40370' => 'KY',
        '40371' => 'KY',
        '40372' => 'KY',
        '40374' => 'KY',
        '40376' => 'KY',
        '40379' => 'KY',
        '40380' => 'KY',
        '40383' => 'KY',
        '40385' => 'KY',
        '40387' => 'KY',
        '40390' => 'KY',
        '40391' => 'KY',
        '40402' => 'KY',
        '40403' => 'KY',
        '40404' => 'KY',
        '40409' => 'KY',
        '40419' => 'KY',
        '40422' => 'KY',
        '40434' => 'KY',
        '40437' => 'KY',
        '40440' => 'KY',
        '40442' => 'KY',
        '40444' => 'KY',
        '40445' => 'KY',
        '40447' => 'KY',
        '40448' => 'KY',
        '40456' => 'KY',
        '40460' => 'KY',
        '40461' => 'KY',
        '40464' => 'KY',
        '40468' => 'KY',
        '40472' => 'KY',
        '40475' => 'KY',
        '40481' => 'KY',
        '40484' => 'KY',
        '40486' => 'KY',
        '40489' => 'KY',
        '40502' => 'KY',
        '40503' => 'KY',
        '40504' => 'KY',
        '40505' => 'KY',
        '40507' => 'KY',
        '40508' => 'KY',
        '40509' => 'KY',
        '40510' => 'KY',
        '40511' => 'KY',
        '40513' => 'KY',
        '40514' => 'KY',
        '40515' => 'KY',
        '40516' => 'KY',
        '40517' => 'KY',
        '40526' => 'KY',
        '40536' => 'KY',
        '40601' => 'KY',
        '40701' => 'KY',
        '40729' => 'KY',
        '40734' => 'KY',
        '40737' => 'KY',
        '40740' => 'KY',
        '40741' => 'KY',
        '40744' => 'KY',
        '40759' => 'KY',
        '40763' => 'KY',
        '40769' => 'KY',
        '40771' => 'KY',
        '40801' => 'KY',
        '40803' => 'KY',
        '40806' => 'KY',
        '40807' => 'KY',
        '40808' => 'KY',
        '40810' => 'KY',
        '40813' => 'KY',
        '40815' => 'KY',
        '40816' => 'KY',
        '40818' => 'KY',
        '40819' => 'KY',
        '40820' => 'KY',
        '40823' => 'KY',
        '40824' => 'KY',
        '40826' => 'KY',
        '40827' => 'KY',
        '40828' => 'KY',
        '40829' => 'KY',
        '40830' => 'KY',
        '40831' => 'KY',
        '40840' => 'KY',
        '40843' => 'KY',
        '40844' => 'KY',
        '40845' => 'KY',
        '40847' => 'KY',
        '40849' => 'KY',
        '40854' => 'KY',
        '40855' => 'KY',
        '40856' => 'KY',
        '40858' => 'KY',
        '40862' => 'KY',
        '40863' => 'KY',
        '40865' => 'KY',
        '40868' => 'KY',
        '40870' => 'KY',
        '40873' => 'KY',
        '40874' => 'KY',
        '40902' => 'KY',
        '40903' => 'KY',
        '40906' => 'KY',
        '40913' => 'KY',
        '40914' => 'KY',
        '40915' => 'KY',
        '40921' => 'KY',
        '40923' => 'KY',
        '40927' => 'KY',
        '40935' => 'KY',
        '40939' => 'KY',
        '40940' => 'KY',
        '40941' => 'KY',
        '40943' => 'KY',
        '40946' => 'KY',
        '40949' => 'KY',
        '40953' => 'KY',
        '40958' => 'KY',
        '40962' => 'KY',
        '40964' => 'KY',
        '40965' => 'KY',
        '40972' => 'KY',
        '40977' => 'KY',
        '40979' => 'KY',
        '40981' => 'KY',
        '40982' => 'KY',
        '40983' => 'KY',
        '40988' => 'KY',
        '40995' => 'KY',
        '40997' => 'KY',
        '41001' => 'KY',
        '41002' => 'KY',
        '41003' => 'KY',
        '41004' => 'KY',
        '41005' => 'KY',
        '41006' => 'KY',
        '41007' => 'KY',
        '41008' => 'KY',
        '41010' => 'KY',
        '41011' => 'KY',
        '41014' => 'KY',
        '41015' => 'KY',
        '41016' => 'KY',
        '41017' => 'KY',
        '41018' => 'KY',
        '41030' => 'KY',
        '41031' => 'KY',
        '41033' => 'KY',
        '41034' => 'KY',
        '41035' => 'KY',
        '41039' => 'KY',
        '41040' => 'KY',
        '41041' => 'KY',
        '41042' => 'KY',
        '41043' => 'KY',
        '41044' => 'KY',
        '41045' => 'KY',
        '41046' => 'KY',
        '41048' => 'KY',
        '41049' => 'KY',
        '41051' => 'KY',
        '41052' => 'KY',
        '41055' => 'KY',
        '41056' => 'KY',
        '41059' => 'KY',
        '41063' => 'KY',
        '41064' => 'KY',
        '41071' => 'KY',
        '41073' => 'KY',
        '41074' => 'KY',
        '41075' => 'KY',
        '41076' => 'KY',
        '41080' => 'KY',
        '41083' => 'KY',
        '41085' => 'KY',
        '41086' => 'KY',
        '41091' => 'KY',
        '41092' => 'KY',
        '41093' => 'KY',
        '41094' => 'KY',
        '41095' => 'KY',
        '41097' => 'KY',
        '41098' => 'KY',
        '41101' => 'KY',
        '41102' => 'KY',
        '41121' => 'KY',
        '41124' => 'KY',
        '41129' => 'KY',
        '41132' => 'KY',
        '41135' => 'KY',
        '41139' => 'KY',
        '41141' => 'KY',
        '41142' => 'KY',
        '41143' => 'KY',
        '41144' => 'KY',
        '41146' => 'KY',
        '41149' => 'KY',
        '41159' => 'KY',
        '41164' => 'KY',
        '41166' => 'KY',
        '41168' => 'KY',
        '41169' => 'KY',
        '41171' => 'KY',
        '41174' => 'KY',
        '41175' => 'KY',
        '41179' => 'KY',
        '41180' => 'KY',
        '41181' => 'KY',
        '41183' => 'KY',
        '41189' => 'KY',
        '41201' => 'KY',
        '41203' => 'KY',
        '41204' => 'KY',
        '41214' => 'KY',
        '41216' => 'KY',
        '41219' => 'KY',
        '41222' => 'KY',
        '41224' => 'KY',
        '41226' => 'KY',
        '41230' => 'KY',
        '41231' => 'KY',
        '41232' => 'KY',
        '41234' => 'KY',
        '41238' => 'KY',
        '41240' => 'KY',
        '41250' => 'KY',
        '41254' => 'KY',
        '41255' => 'KY',
        '41256' => 'KY',
        '41257' => 'KY',
        '41260' => 'KY',
        '41262' => 'KY',
        '41263' => 'KY',
        '41264' => 'KY',
        '41265' => 'KY',
        '41267' => 'KY',
        '41268' => 'KY',
        '41271' => 'KY',
        '41274' => 'KY',
        '41301' => 'KY',
        '41310' => 'KY',
        '41311' => 'KY',
        '41314' => 'KY',
        '41317' => 'KY',
        '41332' => 'KY',
        '41339' => 'KY',
        '41348' => 'KY',
        '41351' => 'KY',
        '41352' => 'KY',
        '41360' => 'KY',
        '41364' => 'KY',
        '41365' => 'KY',
        '41366' => 'KY',
        '41367' => 'KY',
        '41385' => 'KY',
        '41386' => 'KY',
        '41390' => 'KY',
        '41397' => 'KY',
        '41408' => 'KY',
        '41421' => 'KY',
        '41425' => 'KY',
        '41464' => 'KY',
        '41465' => 'KY',
        '41472' => 'KY',
        '41501' => 'KY',
        '41503' => 'KY',
        '41512' => 'KY',
        '41513' => 'KY',
        '41514' => 'KY',
        '41517' => 'KY',
        '41519' => 'KY',
        '41522' => 'KY',
        '41524' => 'KY',
        '41526' => 'KY',
        '41527' => 'KY',
        '41528' => 'KY',
        '41531' => 'KY',
        '41534' => 'KY',
        '41535' => 'KY',
        '41537' => 'KY',
        '41538' => 'KY',
        '41539' => 'KY',
        '41540' => 'KY',
        '41543' => 'KY',
        '41544' => 'KY',
        '41547' => 'KY',
        '41548' => 'KY',
        '41553' => 'KY',
        '41554' => 'KY',
        '41555' => 'KY',
        '41557' => 'KY',
        '41558' => 'KY',
        '41559' => 'KY',
        '41560' => 'KY',
        '41562' => 'KY',
        '41563' => 'KY',
        '41564' => 'KY',
        '41566' => 'KY',
        '41567' => 'KY',
        '41568' => 'KY',
        '41571' => 'KY',
        '41572' => 'KY',
        '41601' => 'KY',
        '41602' => 'KY',
        '41603' => 'KY',
        '41604' => 'KY',
        '41605' => 'KY',
        '41606' => 'KY',
        '41607' => 'KY',
        '41612' => 'KY',
        '41615' => 'KY',
        '41616' => 'KY',
        '41619' => 'KY',
        '41621' => 'KY',
        '41622' => 'KY',
        '41630' => 'KY',
        '41631' => 'KY',
        '41632' => 'KY',
        '41635' => 'KY',
        '41636' => 'KY',
        '41640' => 'KY',
        '41642' => 'KY',
        '41643' => 'KY',
        '41645' => 'KY',
        '41647' => 'KY',
        '41649' => 'KY',
        '41650' => 'KY',
        '41651' => 'KY',
        '41653' => 'KY',
        '41655' => 'KY',
        '41659' => 'KY',
        '41660' => 'KY',
        '41663' => 'KY',
        '41666' => 'KY',
        '41667' => 'KY',
        '41669' => 'KY',
        '41701' => 'KY',
        '41712' => 'KY',
        '41713' => 'KY',
        '41714' => 'KY',
        '41719' => 'KY',
        '41721' => 'KY',
        '41722' => 'KY',
        '41723' => 'KY',
        '41725' => 'KY',
        '41727' => 'KY',
        '41729' => 'KY',
        '41731' => 'KY',
        '41735' => 'KY',
        '41739' => 'KY',
        '41740' => 'KY',
        '41745' => 'KY',
        '41746' => 'KY',
        '41749' => 'KY',
        '41751' => 'KY',
        '41754' => 'KY',
        '41759' => 'KY',
        '41760' => 'KY',
        '41762' => 'KY',
        '41763' => 'KY',
        '41764' => 'KY',
        '41766' => 'KY',
        '41772' => 'KY',
        '41773' => 'KY',
        '41774' => 'KY',
        '41775' => 'KY',
        '41776' => 'KY',
        '41777' => 'KY',
        '41778' => 'KY',
        '41804' => 'KY',
        '41810' => 'KY',
        '41812' => 'KY',
        '41815' => 'KY',
        '41817' => 'KY',
        '41819' => 'KY',
        '41821' => 'KY',
        '41822' => 'KY',
        '41824' => 'KY',
        '41825' => 'KY',
        '41826' => 'KY',
        '41828' => 'KY',
        '41831' => 'KY',
        '41832' => 'KY',
        '41833' => 'KY',
        '41834' => 'KY',
        '41835' => 'KY',
        '41836' => 'KY',
        '41837' => 'KY',
        '41838' => 'KY',
        '41839' => 'KY',
        '41840' => 'KY',
        '41843' => 'KY',
        '41844' => 'KY',
        '41845' => 'KY',
        '41847' => 'KY',
        '41848' => 'KY',
        '41849' => 'KY',
        '41855' => 'KY',
        '41858' => 'KY',
        '41859' => 'KY',
        '41861' => 'KY',
        '41862' => 'KY',
        '42001' => 'KY',
        '42003' => 'KY',
        '42020' => 'KY',
        '42021' => 'KY',
        '42022' => 'KY',
        '42023' => 'KY',
        '42024' => 'KY',
        '42025' => 'KY',
        '42027' => 'KY',
        '42028' => 'KY',
        '42029' => 'KY',
        '42031' => 'KY',
        '42032' => 'KY',
        '42035' => 'KY',
        '42036' => 'KY',
        '42037' => 'KY',
        '42038' => 'KY',
        '42039' => 'KY',
        '42040' => 'KY',
        '42041' => 'KY',
        '42044' => 'KY',
        '42045' => 'KY',
        '42047' => 'KY',
        '42048' => 'KY',
        '42049' => 'KY',
        '42050' => 'KY',
        '42051' => 'KY',
        '42053' => 'KY',
        '42054' => 'KY',
        '42055' => 'KY',
        '42056' => 'KY',
        '42058' => 'KY',
        '42060' => 'KY',
        '42061' => 'KY',
        '42064' => 'KY',
        '42066' => 'KY',
        '42069' => 'KY',
        '42071' => 'KY',
        '42076' => 'KY',
        '42078' => 'KY',
        '42079' => 'KY',
        '42081' => 'KY',
        '42082' => 'KY',
        '42083' => 'KY',
        '42085' => 'KY',
        '42086' => 'KY',
        '42087' => 'KY',
        '42088' => 'KY',
        '42101' => 'KY',
        '42103' => 'KY',
        '42104' => 'KY',
        '42120' => 'KY',
        '42122' => 'KY',
        '42123' => 'KY',
        '42124' => 'KY',
        '42127' => 'KY',
        '42129' => 'KY',
        '42130' => 'KY',
        '42131' => 'KY',
        '42133' => 'KY',
        '42134' => 'KY',
        '42140' => 'KY',
        '42141' => 'KY',
        '42151' => 'KY',
        '42153' => 'KY',
        '42154' => 'KY',
        '42156' => 'KY',
        '42157' => 'KY',
        '42159' => 'KY',
        '42160' => 'KY',
        '42163' => 'KY',
        '42164' => 'KY',
        '42166' => 'KY',
        '42167' => 'KY',
        '42170' => 'KY',
        '42171' => 'KY',
        '42202' => 'KY',
        '42204' => 'KY',
        '42206' => 'KY',
        '42207' => 'KY',
        '42210' => 'KY',
        '42211' => 'KY',
        '42214' => 'KY',
        '42215' => 'KY',
        '42217' => 'KY',
        '42220' => 'KY',
        '42223' => 'KY',
        '42232' => 'KY',
        '42234' => 'KY',
        '42236' => 'KY',
        '42240' => 'KY',
        '42252' => 'KY',
        '42254' => 'KY',
        '42256' => 'KY',
        '42259' => 'KY',
        '42261' => 'KY',
        '42262' => 'KY',
        '42265' => 'KY',
        '42266' => 'KY',
        '42273' => 'KY',
        '42274' => 'KY',
        '42275' => 'KY',
        '42276' => 'KY',
        '42280' => 'KY',
        '42285' => 'KY',
        '42286' => 'KY',
        '42301' => 'KY',
        '42303' => 'KY',
        '42320' => 'KY',
        '42321' => 'KY',
        '42322' => 'KY',
        '42323' => 'KY',
        '42324' => 'KY',
        '42325' => 'KY',
        '42326' => 'KY',
        '42327' => 'KY',
        '42328' => 'KY',
        '42330' => 'KY',
        '42332' => 'KY',
        '42333' => 'KY',
        '42337' => 'KY',
        '42338' => 'KY',
        '42339' => 'KY',
        '42343' => 'KY',
        '42344' => 'KY',
        '42345' => 'KY',
        '42347' => 'KY',
        '42348' => 'KY',
        '42349' => 'KY',
        '42350' => 'KY',
        '42351' => 'KY',
        '42352' => 'KY',
        '42354' => 'KY',
        '42355' => 'KY',
        '42356' => 'KY',
        '42361' => 'KY',
        '42366' => 'KY',
        '42367' => 'KY',
        '42368' => 'KY',
        '42369' => 'KY',
        '42370' => 'KY',
        '42371' => 'KY',
        '42372' => 'KY',
        '42374' => 'KY',
        '42376' => 'KY',
        '42378' => 'KY',
        '42404' => 'KY',
        '42406' => 'KY',
        '42408' => 'KY',
        '42409' => 'KY',
        '42410' => 'KY',
        '42411' => 'KY',
        '42413' => 'KY',
        '42420' => 'KY',
        '42431' => 'KY',
        '42436' => 'KY',
        '42437' => 'KY',
        '42440' => 'KY',
        '42441' => 'KY',
        '42442' => 'KY',
        '42444' => 'KY',
        '42445' => 'KY',
        '42450' => 'KY',
        '42451' => 'KY',
        '42452' => 'KY',
        '42453' => 'KY',
        '42455' => 'KY',
        '42456' => 'KY',
        '42458' => 'KY',
        '42459' => 'KY',
        '42461' => 'KY',
        '42462' => 'KY',
        '42463' => 'KY',
        '42464' => 'KY',
        '42501' => 'KY',
        '42503' => 'KY',
        '42516' => 'KY',
        '42518' => 'KY',
        '42519' => 'KY',
        '42528' => 'KY',
        '42533' => 'KY',
        '42539' => 'KY',
        '42541' => 'KY',
        '42544' => 'KY',
        '42553' => 'KY',
        '42565' => 'KY',
        '42566' => 'KY',
        '42567' => 'KY',
        '42602' => 'KY',
        '42603' => 'KY',
        '42629' => 'KY',
        '42631' => 'KY',
        '42633' => 'KY',
        '42634' => 'KY',
        '42635' => 'KY',
        '42638' => 'KY',
        '42642' => 'KY',
        '42647' => 'KY',
        '42649' => 'KY',
        '42653' => 'KY',
        '42701' => 'KY',
        '42712' => 'KY',
        '42713' => 'KY',
        '42715' => 'KY',
        '42716' => 'KY',
        '42717' => 'KY',
        '42718' => 'KY',
        '42721' => 'KY',
        '42722' => 'KY',
        '42724' => 'KY',
        '42726' => 'KY',
        '42728' => 'KY',
        '42729' => 'KY',
        '42732' => 'KY',
        '42733' => 'KY',
        '42740' => 'KY',
        '42741' => 'KY',
        '42742' => 'KY',
        '42743' => 'KY',
        '42746' => 'KY',
        '42748' => 'KY',
        '42749' => 'KY',
        '42753' => 'KY',
        '42754' => 'KY',
        '42757' => 'KY',
        '42758' => 'KY',
        '42759' => 'KY',
        '42762' => 'KY',
        '42764' => 'KY',
        '42765' => 'KY',
        '42776' => 'KY',
        '42782' => 'KY',
        '42784' => 'KY',
        '42788' => 'KY',
        '43001' => 'OH',
        '43002' => 'OH',
        '43003' => 'OH',
        '43004' => 'OH',
        '43005' => 'OH',
        '43006' => 'OH',
        '43007' => 'OH',
        '43008' => 'OH',
        '43009' => 'OH',
        '43010' => 'OH',
        '43011' => 'OH',
        '43013' => 'OH',
        '43014' => 'OH',
        '43015' => 'OH',
        '43016' => 'OH',
        '43017' => 'OH',
        '43018' => 'OH',
        '43019' => 'OH',
        '43021' => 'OH',
        '43022' => 'OH',
        '43023' => 'OH',
        '43025' => 'OH',
        '43026' => 'OH',
        '43027' => 'OH',
        '43028' => 'OH',
        '43029' => 'OH',
        '43030' => 'OH',
        '43031' => 'OH',
        '43032' => 'OH',
        '43033' => 'OH',
        '43035' => 'OH',
        '43036' => 'OH',
        '43037' => 'OH',
        '43040' => 'OH',
        '43044' => 'OH',
        '43045' => 'OH',
        '43046' => 'OH',
        '43047' => 'OH',
        '43050' => 'OH',
        '43054' => 'OH',
        '43055' => 'OH',
        '43056' => 'OH',
        '43060' => 'OH',
        '43061' => 'OH',
        '43062' => 'OH',
        '43064' => 'OH',
        '43065' => 'OH',
        '43066' => 'OH',
        '43067' => 'OH',
        '43068' => 'OH',
        '43070' => 'OH',
        '43071' => 'OH',
        '43072' => 'OH',
        '43074' => 'OH',
        '43076' => 'OH',
        '43077' => 'OH',
        '43078' => 'OH',
        '43080' => 'OH',
        '43081' => 'OH',
        '43082' => 'OH',
        '43084' => 'OH',
        '43085' => 'OH',
        '43101' => 'OH',
        '43102' => 'OH',
        '43103' => 'OH',
        '43105' => 'OH',
        '43106' => 'OH',
        '43107' => 'OH',
        '43109' => 'OH',
        '43110' => 'OH',
        '43111' => 'OH',
        '43112' => 'OH',
        '43113' => 'OH',
        '43115' => 'OH',
        '43116' => 'OH',
        '43117' => 'OH',
        '43119' => 'OH',
        '43123' => 'OH',
        '43125' => 'OH',
        '43126' => 'OH',
        '43127' => 'OH',
        '43128' => 'OH',
        '43130' => 'OH',
        '43135' => 'OH',
        '43136' => 'OH',
        '43137' => 'OH',
        '43138' => 'OH',
        '43140' => 'OH',
        '43142' => 'OH',
        '43143' => 'OH',
        '43144' => 'OH',
        '43145' => 'OH',
        '43146' => 'OH',
        '43147' => 'OH',
        '43148' => 'OH',
        '43149' => 'OH',
        '43150' => 'OH',
        '43151' => 'OH',
        '43152' => 'OH',
        '43153' => 'OH',
        '43154' => 'OH',
        '43155' => 'OH',
        '43156' => 'OH',
        '43157' => 'OH',
        '43158' => 'OH',
        '43160' => 'OH',
        '43162' => 'OH',
        '43164' => 'OH',
        '43201' => 'OH',
        '43202' => 'OH',
        '43203' => 'OH',
        '43204' => 'OH',
        '43205' => 'OH',
        '43206' => 'OH',
        '43207' => 'OH',
        '43209' => 'OH',
        '43210' => 'OH',
        '43211' => 'OH',
        '43212' => 'OH',
        '43213' => 'OH',
        '43214' => 'OH',
        '43215' => 'OH',
        '43217' => 'OH',
        '43218' => 'OH',
        '43219' => 'OH',
        '43220' => 'OH',
        '43221' => 'OH',
        '43222' => 'OH',
        '43223' => 'OH',
        '43224' => 'OH',
        '43227' => 'OH',
        '43228' => 'OH',
        '43229' => 'OH',
        '43230' => 'OH',
        '43231' => 'OH',
        '43232' => 'OH',
        '43235' => 'OH',
        '43240' => 'OH',
        '43302' => 'OH',
        '43310' => 'OH',
        '43311' => 'OH',
        '43314' => 'OH',
        '43315' => 'OH',
        '43316' => 'OH',
        '43317' => 'OH',
        '43318' => 'OH',
        '43319' => 'OH',
        '43320' => 'OH',
        '43321' => 'OH',
        '43322' => 'OH',
        '43323' => 'OH',
        '43324' => 'OH',
        '43325' => 'OH',
        '43326' => 'OH',
        '43330' => 'OH',
        '43331' => 'OH',
        '43332' => 'OH',
        '43333' => 'OH',
        '43334' => 'OH',
        '43336' => 'OH',
        '43337' => 'OH',
        '43338' => 'OH',
        '43340' => 'OH',
        '43341' => 'OH',
        '43342' => 'OH',
        '43343' => 'OH',
        '43344' => 'OH',
        '43345' => 'OH',
        '43346' => 'OH',
        '43347' => 'OH',
        '43348' => 'OH',
        '43350' => 'OH',
        '43351' => 'OH',
        '43356' => 'OH',
        '43357' => 'OH',
        '43358' => 'OH',
        '43359' => 'OH',
        '43360' => 'OH',
        '43402' => 'OH',
        '43403' => 'OH',
        '43406' => 'OH',
        '43407' => 'OH',
        '43408' => 'OH',
        '43410' => 'OH',
        '43412' => 'OH',
        '43413' => 'OH',
        '43414' => 'OH',
        '43416' => 'OH',
        '43420' => 'OH',
        '43430' => 'OH',
        '43431' => 'OH',
        '43432' => 'OH',
        '43433' => 'OH',
        '43434' => 'OH',
        '43435' => 'OH',
        '43436' => 'OH',
        '43437' => 'OH',
        '43438' => 'OH',
        '43439' => 'OH',
        '43440' => 'OH',
        '43442' => 'OH',
        '43443' => 'OH',
        '43445' => 'OH',
        '43446' => 'OH',
        '43447' => 'OH',
        '43449' => 'OH',
        '43450' => 'OH',
        '43451' => 'OH',
        '43452' => 'OH',
        '43456' => 'OH',
        '43457' => 'OH',
        '43458' => 'OH',
        '43460' => 'OH',
        '43462' => 'OH',
        '43463' => 'OH',
        '43464' => 'OH',
        '43465' => 'OH',
        '43466' => 'OH',
        '43467' => 'OH',
        '43468' => 'OH',
        '43469' => 'OH',
        '43501' => 'OH',
        '43502' => 'OH',
        '43504' => 'OH',
        '43505' => 'OH',
        '43506' => 'OH',
        '43510' => 'OH',
        '43511' => 'OH',
        '43512' => 'OH',
        '43515' => 'OH',
        '43516' => 'OH',
        '43517' => 'OH',
        '43518' => 'OH',
        '43519' => 'OH',
        '43520' => 'OH',
        '43521' => 'OH',
        '43522' => 'OH',
        '43523' => 'OH',
        '43524' => 'OH',
        '43525' => 'OH',
        '43526' => 'OH',
        '43527' => 'OH',
        '43528' => 'OH',
        '43529' => 'OH',
        '43530' => 'OH',
        '43531' => 'OH',
        '43532' => 'OH',
        '43533' => 'OH',
        '43534' => 'OH',
        '43535' => 'OH',
        '43536' => 'OH',
        '43537' => 'OH',
        '43540' => 'OH',
        '43541' => 'OH',
        '43542' => 'OH',
        '43543' => 'OH',
        '43545' => 'OH',
        '43547' => 'OH',
        '43548' => 'OH',
        '43549' => 'OH',
        '43551' => 'OH',
        '43553' => 'OH',
        '43554' => 'OH',
        '43555' => 'OH',
        '43556' => 'OH',
        '43557' => 'OH',
        '43558' => 'OH',
        '43560' => 'OH',
        '43565' => 'OH',
        '43566' => 'OH',
        '43567' => 'OH',
        '43569' => 'OH',
        '43570' => 'OH',
        '43571' => 'OH',
        '43604' => 'OH',
        '43605' => 'OH',
        '43606' => 'OH',
        '43607' => 'OH',
        '43608' => 'OH',
        '43609' => 'OH',
        '43610' => 'OH',
        '43611' => 'OH',
        '43612' => 'OH',
        '43613' => 'OH',
        '43614' => 'OH',
        '43615' => 'OH',
        '43616' => 'OH',
        '43617' => 'OH',
        '43619' => 'OH',
        '43620' => 'OH',
        '43623' => 'OH',
        '43701' => 'OH',
        '43711' => 'OH',
        '43713' => 'OH',
        '43716' => 'OH',
        '43717' => 'OH',
        '43718' => 'OH',
        '43719' => 'OH',
        '43720' => 'OH',
        '43721' => 'OH',
        '43722' => 'OH',
        '43723' => 'OH',
        '43724' => 'OH',
        '43725' => 'OH',
        '43727' => 'OH',
        '43728' => 'OH',
        '43730' => 'OH',
        '43731' => 'OH',
        '43732' => 'OH',
        '43733' => 'OH',
        '43734' => 'OH',
        '43735' => 'OH',
        '43736' => 'OH',
        '43738' => 'OH',
        '43739' => 'OH',
        '43740' => 'OH',
        '43746' => 'OH',
        '43747' => 'OH',
        '43748' => 'OH',
        '43749' => 'OH',
        '43750' => 'OH',
        '43754' => 'OH',
        '43755' => 'OH',
        '43756' => 'OH',
        '43758' => 'OH',
        '43759' => 'OH',
        '43760' => 'OH',
        '43761' => 'OH',
        '43762' => 'OH',
        '43764' => 'OH',
        '43766' => 'OH',
        '43767' => 'OH',
        '43768' => 'OH',
        '43771' => 'OH',
        '43772' => 'OH',
        '43773' => 'OH',
        '43777' => 'OH',
        '43778' => 'OH',
        '43779' => 'OH',
        '43780' => 'OH',
        '43782' => 'OH',
        '43783' => 'OH',
        '43786' => 'OH',
        '43787' => 'OH',
        '43788' => 'OH',
        '43791' => 'OH',
        '43793' => 'OH',
        '43802' => 'OH',
        '43804' => 'OH',
        '43805' => 'OH',
        '43811' => 'OH',
        '43812' => 'OH',
        '43821' => 'OH',
        '43822' => 'OH',
        '43824' => 'OH',
        '43830' => 'OH',
        '43832' => 'OH',
        '43836' => 'OH',
        '43837' => 'OH',
        '43840' => 'OH',
        '43842' => 'OH',
        '43843' => 'OH',
        '43844' => 'OH',
        '43845' => 'OH',
        '43901' => 'OH',
        '43902' => 'OH',
        '43903' => 'OH',
        '43905' => 'OH',
        '43906' => 'OH',
        '43907' => 'OH',
        '43908' => 'OH',
        '43909' => 'OH',
        '43910' => 'OH',
        '43912' => 'OH',
        '43913' => 'OH',
        '43914' => 'OH',
        '43915' => 'OH',
        '43917' => 'OH',
        '43920' => 'OH',
        '43925' => 'OH',
        '43926' => 'OH',
        '43928' => 'OH',
        '43930' => 'OH',
        '43931' => 'OH',
        '43932' => 'OH',
        '43933' => 'OH',
        '43934' => 'OH',
        '43935' => 'OH',
        '43938' => 'OH',
        '43939' => 'OH',
        '43940' => 'OH',
        '43942' => 'OH',
        '43943' => 'OH',
        '43944' => 'OH',
        '43945' => 'OH',
        '43946' => 'OH',
        '43947' => 'OH',
        '43948' => 'OH',
        '43950' => 'OH',
        '43951' => 'OH',
        '43952' => 'OH',
        '43953' => 'OH',
        '43961' => 'OH',
        '43962' => 'OH',
        '43963' => 'OH',
        '43964' => 'OH',
        '43967' => 'OH',
        '43968' => 'OH',
        '43971' => 'OH',
        '43972' => 'OH',
        '43973' => 'OH',
        '43974' => 'OH',
        '43976' => 'OH',
        '43977' => 'OH',
        '43981' => 'OH',
        '43983' => 'OH',
        '43985' => 'OH',
        '43986' => 'OH',
        '43988' => 'OH',
        '44001' => 'OH',
        '44003' => 'OH',
        '44004' => 'OH',
        '44010' => 'OH',
        '44011' => 'OH',
        '44012' => 'OH',
        '44017' => 'OH',
        '44021' => 'OH',
        '44022' => 'OH',
        '44023' => 'OH',
        '44024' => 'OH',
        '44026' => 'OH',
        '44028' => 'OH',
        '44030' => 'OH',
        '44032' => 'OH',
        '44035' => 'OH',
        '44039' => 'OH',
        '44040' => 'OH',
        '44041' => 'OH',
        '44044' => 'OH',
        '44045' => 'OH',
        '44046' => 'OH',
        '44047' => 'OH',
        '44048' => 'OH',
        '44049' => 'OH',
        '44050' => 'OH',
        '44052' => 'OH',
        '44053' => 'OH',
        '44054' => 'OH',
        '44055' => 'OH',
        '44056' => 'OH',
        '44057' => 'OH',
        '44060' => 'OH',
        '44062' => 'OH',
        '44064' => 'OH',
        '44065' => 'OH',
        '44067' => 'OH',
        '44068' => 'OH',
        '44070' => 'OH',
        '44072' => 'OH',
        '44074' => 'OH',
        '44076' => 'OH',
        '44077' => 'OH',
        '44080' => 'OH',
        '44081' => 'OH',
        '44082' => 'OH',
        '44084' => 'OH',
        '44085' => 'OH',
        '44086' => 'OH',
        '44087' => 'OH',
        '44089' => 'OH',
        '44090' => 'OH',
        '44092' => 'OH',
        '44093' => 'OH',
        '44094' => 'OH',
        '44095' => 'OH',
        '44099' => 'OH',
        '44101' => 'OH',
        '44102' => 'OH',
        '44103' => 'OH',
        '44104' => 'OH',
        '44105' => 'OH',
        '44106' => 'OH',
        '44107' => 'OH',
        '44108' => 'OH',
        '44109' => 'OH',
        '44110' => 'OH',
        '44111' => 'OH',
        '44112' => 'OH',
        '44113' => 'OH',
        '44114' => 'OH',
        '44115' => 'OH',
        '44116' => 'OH',
        '44117' => 'OH',
        '44118' => 'OH',
        '44119' => 'OH',
        '44120' => 'OH',
        '44121' => 'OH',
        '44122' => 'OH',
        '44123' => 'OH',
        '44124' => 'OH',
        '44125' => 'OH',
        '44126' => 'OH',
        '44127' => 'OH',
        '44128' => 'OH',
        '44129' => 'OH',
        '44130' => 'OH',
        '44131' => 'OH',
        '44132' => 'OH',
        '44133' => 'OH',
        '44134' => 'OH',
        '44135' => 'OH',
        '44136' => 'OH',
        '44137' => 'OH',
        '44138' => 'OH',
        '44139' => 'OH',
        '44140' => 'OH',
        '44141' => 'OH',
        '44142' => 'OH',
        '44143' => 'OH',
        '44144' => 'OH',
        '44145' => 'OH',
        '44146' => 'OH',
        '44147' => 'OH',
        '44149' => 'OH',
        '44201' => 'OH',
        '44202' => 'OH',
        '44203' => 'OH',
        '44212' => 'OH',
        '44214' => 'OH',
        '44215' => 'OH',
        '44216' => 'OH',
        '44217' => 'OH',
        '44221' => 'OH',
        '44223' => 'OH',
        '44224' => 'OH',
        '44230' => 'OH',
        '44231' => 'OH',
        '44232' => 'OH',
        '44233' => 'OH',
        '44234' => 'OH',
        '44235' => 'OH',
        '44236' => 'OH',
        '44240' => 'OH',
        '44241' => 'OH',
        '44243' => 'OH',
        '44250' => 'OH',
        '44251' => 'OH',
        '44253' => 'OH',
        '44254' => 'OH',
        '44255' => 'OH',
        '44256' => 'OH',
        '44260' => 'OH',
        '44262' => 'OH',
        '44264' => 'OH',
        '44266' => 'OH',
        '44270' => 'OH',
        '44272' => 'OH',
        '44273' => 'OH',
        '44274' => 'OH',
        '44275' => 'OH',
        '44276' => 'OH',
        '44278' => 'OH',
        '44280' => 'OH',
        '44281' => 'OH',
        '44285' => 'OH',
        '44286' => 'OH',
        '44287' => 'OH',
        '44288' => 'OH',
        '44301' => 'OH',
        '44302' => 'OH',
        '44303' => 'OH',
        '44304' => 'OH',
        '44305' => 'OH',
        '44306' => 'OH',
        '44307' => 'OH',
        '44308' => 'OH',
        '44310' => 'OH',
        '44311' => 'OH',
        '44312' => 'OH',
        '44313' => 'OH',
        '44314' => 'OH',
        '44319' => 'OH',
        '44320' => 'OH',
        '44321' => 'OH',
        '44325' => 'OH',
        '44333' => 'OH',
        '44401' => 'OH',
        '44402' => 'OH',
        '44403' => 'OH',
        '44404' => 'OH',
        '44405' => 'OH',
        '44406' => 'OH',
        '44408' => 'OH',
        '44410' => 'OH',
        '44411' => 'OH',
        '44412' => 'OH',
        '44413' => 'OH',
        '44415' => 'OH',
        '44417' => 'OH',
        '44418' => 'OH',
        '44420' => 'OH',
        '44423' => 'OH',
        '44424' => 'OH',
        '44425' => 'OH',
        '44427' => 'OH',
        '44428' => 'OH',
        '44429' => 'OH',
        '44430' => 'OH',
        '44431' => 'OH',
        '44432' => 'OH',
        '44436' => 'OH',
        '44437' => 'OH',
        '44438' => 'OH',
        '44439' => 'OH',
        '44440' => 'OH',
        '44441' => 'OH',
        '44442' => 'OH',
        '44443' => 'OH',
        '44444' => 'OH',
        '44445' => 'OH',
        '44446' => 'OH',
        '44449' => 'OH',
        '44450' => 'OH',
        '44451' => 'OH',
        '44452' => 'OH',
        '44454' => 'OH',
        '44455' => 'OH',
        '44460' => 'OH',
        '44470' => 'OH',
        '44471' => 'OH',
        '44473' => 'OH',
        '44481' => 'OH',
        '44483' => 'OH',
        '44484' => 'OH',
        '44485' => 'OH',
        '44490' => 'OH',
        '44491' => 'OH',
        '44493' => 'OH',
        '44502' => 'OH',
        '44503' => 'OH',
        '44504' => 'OH',
        '44505' => 'OH',
        '44506' => 'OH',
        '44507' => 'OH',
        '44509' => 'OH',
        '44510' => 'OH',
        '44511' => 'OH',
        '44512' => 'OH',
        '44514' => 'OH',
        '44515' => 'OH',
        '44555' => 'OH',
        '44601' => 'OH',
        '44606' => 'OH',
        '44607' => 'OH',
        '44608' => 'OH',
        '44609' => 'OH',
        '44610' => 'OH',
        '44611' => 'OH',
        '44612' => 'OH',
        '44613' => 'OH',
        '44614' => 'OH',
        '44615' => 'OH',
        '44618' => 'OH',
        '44619' => 'OH',
        '44620' => 'OH',
        '44621' => 'OH',
        '44622' => 'OH',
        '44624' => 'OH',
        '44625' => 'OH',
        '44626' => 'OH',
        '44627' => 'OH',
        '44628' => 'OH',
        '44629' => 'OH',
        '44630' => 'OH',
        '44632' => 'OH',
        '44633' => 'OH',
        '44634' => 'OH',
        '44637' => 'OH',
        '44638' => 'OH',
        '44639' => 'OH',
        '44640' => 'OH',
        '44641' => 'OH',
        '44643' => 'OH',
        '44644' => 'OH',
        '44645' => 'OH',
        '44646' => 'OH',
        '44647' => 'OH',
        '44651' => 'OH',
        '44652' => 'OH',
        '44653' => 'OH',
        '44654' => 'OH',
        '44656' => 'OH',
        '44657' => 'OH',
        '44659' => 'OH',
        '44660' => 'OH',
        '44661' => 'OH',
        '44662' => 'OH',
        '44663' => 'OH',
        '44665' => 'OH',
        '44666' => 'OH',
        '44667' => 'OH',
        '44669' => 'OH',
        '44670' => 'OH',
        '44671' => 'OH',
        '44672' => 'OH',
        '44675' => 'OH',
        '44676' => 'OH',
        '44677' => 'OH',
        '44678' => 'OH',
        '44680' => 'OH',
        '44681' => 'OH',
        '44682' => 'OH',
        '44683' => 'OH',
        '44685' => 'OH',
        '44687' => 'OH',
        '44688' => 'OH',
        '44689' => 'OH',
        '44690' => 'OH',
        '44691' => 'OH',
        '44693' => 'OH',
        '44695' => 'OH',
        '44697' => 'OH',
        '44699' => 'OH',
        '44702' => 'OH',
        '44703' => 'OH',
        '44704' => 'OH',
        '44705' => 'OH',
        '44706' => 'OH',
        '44707' => 'OH',
        '44708' => 'OH',
        '44709' => 'OH',
        '44710' => 'OH',
        '44714' => 'OH',
        '44718' => 'OH',
        '44720' => 'OH',
        '44721' => 'OH',
        '44730' => 'OH',
        '44802' => 'OH',
        '44804' => 'OH',
        '44805' => 'OH',
        '44807' => 'OH',
        '44809' => 'OH',
        '44811' => 'OH',
        '44813' => 'OH',
        '44814' => 'OH',
        '44815' => 'OH',
        '44817' => 'OH',
        '44818' => 'OH',
        '44820' => 'OH',
        '44822' => 'OH',
        '44824' => 'OH',
        '44825' => 'OH',
        '44826' => 'OH',
        '44827' => 'OH',
        '44828' => 'OH',
        '44830' => 'OH',
        '44833' => 'OH',
        '44836' => 'OH',
        '44837' => 'OH',
        '44838' => 'OH',
        '44839' => 'OH',
        '44840' => 'OH',
        '44841' => 'OH',
        '44842' => 'OH',
        '44843' => 'OH',
        '44844' => 'OH',
        '44846' => 'OH',
        '44847' => 'OH',
        '44849' => 'OH',
        '44850' => 'OH',
        '44851' => 'OH',
        '44853' => 'OH',
        '44854' => 'OH',
        '44855' => 'OH',
        '44856' => 'OH',
        '44857' => 'OH',
        '44859' => 'OH',
        '44861' => 'OH',
        '44864' => 'OH',
        '44865' => 'OH',
        '44866' => 'OH',
        '44867' => 'OH',
        '44870' => 'OH',
        '44874' => 'OH',
        '44875' => 'OH',
        '44878' => 'OH',
        '44880' => 'OH',
        '44881' => 'OH',
        '44882' => 'OH',
        '44883' => 'OH',
        '44887' => 'OH',
        '44889' => 'OH',
        '44890' => 'OH',
        '44901' => 'OH',
        '44902' => 'OH',
        '44903' => 'OH',
        '44904' => 'OH',
        '44905' => 'OH',
        '44906' => 'OH',
        '44907' => 'OH',
        '45001' => 'OH',
        '45002' => 'OH',
        '45003' => 'OH',
        '45005' => 'OH',
        '45011' => 'OH',
        '45013' => 'OH',
        '45014' => 'OH',
        '45015' => 'OH',
        '45030' => 'OH',
        '45032' => 'OH',
        '45033' => 'OH',
        '45034' => 'OH',
        '45036' => 'OH',
        '45039' => 'OH',
        '45040' => 'OH',
        '45041' => 'OH',
        '45042' => 'OH',
        '45044' => 'OH',
        '45050' => 'OH',
        '45051' => 'OH',
        '45052' => 'OH',
        '45053' => 'OH',
        '45054' => 'OH',
        '45055' => 'OH',
        '45056' => 'OH',
        '45062' => 'OH',
        '45064' => 'OH',
        '45065' => 'OH',
        '45066' => 'OH',
        '45067' => 'OH',
        '45068' => 'OH',
        '45069' => 'OH',
        '45070' => 'OH',
        '45101' => 'OH',
        '45102' => 'OH',
        '45103' => 'OH',
        '45105' => 'OH',
        '45106' => 'OH',
        '45107' => 'OH',
        '45111' => 'OH',
        '45112' => 'OH',
        '45113' => 'OH',
        '45115' => 'OH',
        '45118' => 'OH',
        '45119' => 'OH',
        '45120' => 'OH',
        '45121' => 'OH',
        '45122' => 'OH',
        '45123' => 'OH',
        '45130' => 'OH',
        '45131' => 'OH',
        '45132' => 'OH',
        '45133' => 'OH',
        '45135' => 'OH',
        '45140' => 'OH',
        '45142' => 'OH',
        '45144' => 'OH',
        '45146' => 'OH',
        '45147' => 'OH',
        '45148' => 'OH',
        '45150' => 'OH',
        '45152' => 'OH',
        '45153' => 'OH',
        '45154' => 'OH',
        '45155' => 'OH',
        '45156' => 'OH',
        '45157' => 'OH',
        '45158' => 'OH',
        '45159' => 'OH',
        '45160' => 'OH',
        '45162' => 'OH',
        '45164' => 'OH',
        '45166' => 'OH',
        '45167' => 'OH',
        '45168' => 'OH',
        '45169' => 'OH',
        '45171' => 'OH',
        '45172' => 'OH',
        '45174' => 'OH',
        '45176' => 'OH',
        '45177' => 'OH',
        '45202' => 'OH',
        '45203' => 'OH',
        '45204' => 'OH',
        '45205' => 'OH',
        '45206' => 'OH',
        '45207' => 'OH',
        '45208' => 'OH',
        '45209' => 'OH',
        '45211' => 'OH',
        '45212' => 'OH',
        '45213' => 'OH',
        '45214' => 'OH',
        '45215' => 'OH',
        '45216' => 'OH',
        '45217' => 'OH',
        '45218' => 'OH',
        '45219' => 'OH',
        '45220' => 'OH',
        '45223' => 'OH',
        '45224' => 'OH',
        '45225' => 'OH',
        '45226' => 'OH',
        '45227' => 'OH',
        '45229' => 'OH',
        '45230' => 'OH',
        '45231' => 'OH',
        '45232' => 'OH',
        '45233' => 'OH',
        '45236' => 'OH',
        '45237' => 'OH',
        '45238' => 'OH',
        '45239' => 'OH',
        '45240' => 'OH',
        '45241' => 'OH',
        '45242' => 'OH',
        '45243' => 'OH',
        '45244' => 'OH',
        '45245' => 'OH',
        '45246' => 'OH',
        '45247' => 'OH',
        '45248' => 'OH',
        '45249' => 'OH',
        '45251' => 'OH',
        '45252' => 'OH',
        '45255' => 'OH',
        '45267' => 'OH',
        '45301' => 'OH',
        '45302' => 'OH',
        '45303' => 'OH',
        '45304' => 'OH',
        '45305' => 'OH',
        '45306' => 'OH',
        '45307' => 'OH',
        '45308' => 'OH',
        '45309' => 'OH',
        '45310' => 'OH',
        '45311' => 'OH',
        '45312' => 'OH',
        '45314' => 'OH',
        '45315' => 'OH',
        '45316' => 'OH',
        '45317' => 'OH',
        '45318' => 'OH',
        '45319' => 'OH',
        '45320' => 'OH',
        '45321' => 'OH',
        '45322' => 'OH',
        '45323' => 'OH',
        '45324' => 'OH',
        '45325' => 'OH',
        '45326' => 'OH',
        '45327' => 'OH',
        '45328' => 'OH',
        '45330' => 'OH',
        '45331' => 'OH',
        '45332' => 'OH',
        '45333' => 'OH',
        '45334' => 'OH',
        '45335' => 'OH',
        '45336' => 'OH',
        '45337' => 'OH',
        '45338' => 'OH',
        '45339' => 'OH',
        '45340' => 'OH',
        '45341' => 'OH',
        '45342' => 'OH',
        '45344' => 'OH',
        '45345' => 'OH',
        '45346' => 'OH',
        '45347' => 'OH',
        '45348' => 'OH',
        '45349' => 'OH',
        '45350' => 'OH',
        '45351' => 'OH',
        '45352' => 'OH',
        '45353' => 'OH',
        '45354' => 'OH',
        '45356' => 'OH',
        '45358' => 'OH',
        '45359' => 'OH',
        '45360' => 'OH',
        '45361' => 'OH',
        '45362' => 'OH',
        '45363' => 'OH',
        '45365' => 'OH',
        '45368' => 'OH',
        '45369' => 'OH',
        '45370' => 'OH',
        '45371' => 'OH',
        '45372' => 'OH',
        '45373' => 'OH',
        '45377' => 'OH',
        '45378' => 'OH',
        '45380' => 'OH',
        '45381' => 'OH',
        '45382' => 'OH',
        '45383' => 'OH',
        '45384' => 'OH',
        '45385' => 'OH',
        '45387' => 'OH',
        '45388' => 'OH',
        '45389' => 'OH',
        '45390' => 'OH',
        '45402' => 'OH',
        '45403' => 'OH',
        '45404' => 'OH',
        '45405' => 'OH',
        '45406' => 'OH',
        '45409' => 'OH',
        '45410' => 'OH',
        '45414' => 'OH',
        '45415' => 'OH',
        '45416' => 'OH',
        '45417' => 'OH',
        '45419' => 'OH',
        '45420' => 'OH',
        '45423' => 'OH',
        '45424' => 'OH',
        '45426' => 'OH',
        '45428' => 'OH',
        '45429' => 'OH',
        '45430' => 'OH',
        '45431' => 'OH',
        '45432' => 'OH',
        '45433' => 'OH',
        '45434' => 'OH',
        '45435' => 'OH',
        '45439' => 'OH',
        '45440' => 'OH',
        '45449' => 'OH',
        '45458' => 'OH',
        '45459' => 'OH',
        '45469' => 'OH',
        '45501' => 'OH',
        '45502' => 'OH',
        '45503' => 'OH',
        '45504' => 'OH',
        '45505' => 'OH',
        '45506' => 'OH',
        '45601' => 'OH',
        '45612' => 'OH',
        '45613' => 'OH',
        '45614' => 'OH',
        '45616' => 'OH',
        '45617' => 'OH',
        '45618' => 'OH',
        '45619' => 'OH',
        '45620' => 'OH',
        '45621' => 'OH',
        '45622' => 'OH',
        '45623' => 'OH',
        '45624' => 'OH',
        '45628' => 'OH',
        '45629' => 'OH',
        '45630' => 'OH',
        '45631' => 'OH',
        '45634' => 'OH',
        '45636' => 'OH',
        '45638' => 'OH',
        '45640' => 'OH',
        '45642' => 'OH',
        '45644' => 'OH',
        '45645' => 'OH',
        '45646' => 'OH',
        '45647' => 'OH',
        '45648' => 'OH',
        '45650' => 'OH',
        '45651' => 'OH',
        '45652' => 'OH',
        '45653' => 'OH',
        '45654' => 'OH',
        '45656' => 'OH',
        '45657' => 'OH',
        '45658' => 'OH',
        '45659' => 'OH',
        '45660' => 'OH',
        '45661' => 'OH',
        '45662' => 'OH',
        '45663' => 'OH',
        '45669' => 'OH',
        '45671' => 'OH',
        '45672' => 'OH',
        '45673' => 'OH',
        '45674' => 'OH',
        '45677' => 'OH',
        '45678' => 'OH',
        '45679' => 'OH',
        '45680' => 'OH',
        '45681' => 'OH',
        '45682' => 'OH',
        '45684' => 'OH',
        '45685' => 'OH',
        '45686' => 'OH',
        '45688' => 'OH',
        '45690' => 'OH',
        '45692' => 'OH',
        '45693' => 'OH',
        '45694' => 'OH',
        '45695' => 'OH',
        '45696' => 'OH',
        '45697' => 'OH',
        '45698' => 'OH',
        '45699' => 'OH',
        '45701' => 'OH',
        '45710' => 'OH',
        '45711' => 'OH',
        '45714' => 'OH',
        '45715' => 'OH',
        '45716' => 'OH',
        '45719' => 'OH',
        '45720' => 'OH',
        '45721' => 'OH',
        '45723' => 'OH',
        '45724' => 'OH',
        '45727' => 'OH',
        '45729' => 'OH',
        '45732' => 'OH',
        '45734' => 'OH',
        '45735' => 'OH',
        '45739' => 'OH',
        '45740' => 'OH',
        '45741' => 'OH',
        '45742' => 'OH',
        '45743' => 'OH',
        '45744' => 'OH',
        '45745' => 'OH',
        '45746' => 'OH',
        '45750' => 'OH',
        '45760' => 'OH',
        '45761' => 'OH',
        '45764' => 'OH',
        '45766' => 'OH',
        '45767' => 'OH',
        '45768' => 'OH',
        '45769' => 'OH',
        '45770' => 'OH',
        '45771' => 'OH',
        '45772' => 'OH',
        '45773' => 'OH',
        '45775' => 'OH',
        '45776' => 'OH',
        '45778' => 'OH',
        '45779' => 'OH',
        '45780' => 'OH',
        '45782' => 'OH',
        '45783' => 'OH',
        '45784' => 'OH',
        '45786' => 'OH',
        '45788' => 'OH',
        '45789' => 'OH',
        '45801' => 'OH',
        '45804' => 'OH',
        '45805' => 'OH',
        '45806' => 'OH',
        '45807' => 'OH',
        '45808' => 'OH',
        '45809' => 'OH',
        '45810' => 'OH',
        '45812' => 'OH',
        '45813' => 'OH',
        '45814' => 'OH',
        '45815' => 'OH',
        '45816' => 'OH',
        '45817' => 'OH',
        '45819' => 'OH',
        '45820' => 'OH',
        '45821' => 'OH',
        '45822' => 'OH',
        '45826' => 'OH',
        '45827' => 'OH',
        '45828' => 'OH',
        '45830' => 'OH',
        '45831' => 'OH',
        '45832' => 'OH',
        '45833' => 'OH',
        '45835' => 'OH',
        '45836' => 'OH',
        '45838' => 'OH',
        '45840' => 'OH',
        '45841' => 'OH',
        '45843' => 'OH',
        '45844' => 'OH',
        '45845' => 'OH',
        '45846' => 'OH',
        '45848' => 'OH',
        '45849' => 'OH',
        '45850' => 'OH',
        '45851' => 'OH',
        '45853' => 'OH',
        '45854' => 'OH',
        '45855' => 'OH',
        '45856' => 'OH',
        '45858' => 'OH',
        '45859' => 'OH',
        '45860' => 'OH',
        '45861' => 'OH',
        '45862' => 'OH',
        '45863' => 'OH',
        '45864' => 'OH',
        '45865' => 'OH',
        '45866' => 'OH',
        '45867' => 'OH',
        '45868' => 'OH',
        '45869' => 'OH',
        '45870' => 'OH',
        '45871' => 'OH',
        '45872' => 'OH',
        '45873' => 'OH',
        '45874' => 'OH',
        '45875' => 'OH',
        '45876' => 'OH',
        '45877' => 'OH',
        '45879' => 'OH',
        '45880' => 'OH',
        '45881' => 'OH',
        '45882' => 'OH',
        '45883' => 'OH',
        '45884' => 'OH',
        '45885' => 'OH',
        '45886' => 'OH',
        '45887' => 'OH',
        '45888' => 'OH',
        '45889' => 'OH',
        '45890' => 'OH',
        '45891' => 'OH',
        '45893' => 'OH',
        '45894' => 'OH',
        '45895' => 'OH',
        '45896' => 'OH',
        '45897' => 'OH',
        '45898' => 'OH',
        '45899' => 'OH',
        '46001' => 'IN',
        '46011' => 'IN',
        '46012' => 'IN',
        '46013' => 'IN',
        '46016' => 'IN',
        '46017' => 'IN',
        '46030' => 'IN',
        '46031' => 'IN',
        '46032' => 'IN',
        '46033' => 'IN',
        '46034' => 'IN',
        '46035' => 'IN',
        '46036' => 'IN',
        '46037' => 'IN',
        '46038' => 'IN',
        '46039' => 'IN',
        '46040' => 'IN',
        '46041' => 'IN',
        '46044' => 'IN',
        '46045' => 'IN',
        '46047' => 'IN',
        '46048' => 'IN',
        '46049' => 'IN',
        '46050' => 'IN',
        '46051' => 'IN',
        '46052' => 'IN',
        '46055' => 'IN',
        '46056' => 'IN',
        '46057' => 'IN',
        '46058' => 'IN',
        '46060' => 'IN',
        '46062' => 'IN',
        '46063' => 'IN',
        '46064' => 'IN',
        '46065' => 'IN',
        '46068' => 'IN',
        '46069' => 'IN',
        '46070' => 'IN',
        '46071' => 'IN',
        '46072' => 'IN',
        '46074' => 'IN',
        '46075' => 'IN',
        '46076' => 'IN',
        '46077' => 'IN',
        '46102' => 'IN',
        '46103' => 'IN',
        '46104' => 'IN',
        '46105' => 'IN',
        '46106' => 'IN',
        '46107' => 'IN',
        '46110' => 'IN',
        '46111' => 'IN',
        '46112' => 'IN',
        '46113' => 'IN',
        '46115' => 'IN',
        '46117' => 'IN',
        '46118' => 'IN',
        '46120' => 'IN',
        '46121' => 'IN',
        '46122' => 'IN',
        '46123' => 'IN',
        '46124' => 'IN',
        '46125' => 'IN',
        '46126' => 'IN',
        '46127' => 'IN',
        '46128' => 'IN',
        '46130' => 'IN',
        '46131' => 'IN',
        '46133' => 'IN',
        '46135' => 'IN',
        '46140' => 'IN',
        '46142' => 'IN',
        '46143' => 'IN',
        '46144' => 'IN',
        '46146' => 'IN',
        '46147' => 'IN',
        '46148' => 'IN',
        '46149' => 'IN',
        '46150' => 'IN',
        '46151' => 'IN',
        '46154' => 'IN',
        '46155' => 'IN',
        '46156' => 'IN',
        '46157' => 'IN',
        '46158' => 'IN',
        '46160' => 'IN',
        '46161' => 'IN',
        '46162' => 'IN',
        '46163' => 'IN',
        '46164' => 'IN',
        '46165' => 'IN',
        '46166' => 'IN',
        '46167' => 'IN',
        '46168' => 'IN',
        '46170' => 'IN',
        '46171' => 'IN',
        '46172' => 'IN',
        '46173' => 'IN',
        '46175' => 'IN',
        '46176' => 'IN',
        '46180' => 'IN',
        '46181' => 'IN',
        '46182' => 'IN',
        '46183' => 'IN',
        '46184' => 'IN',
        '46186' => 'IN',
        '46201' => 'IN',
        '46202' => 'IN',
        '46203' => 'IN',
        '46204' => 'IN',
        '46205' => 'IN',
        '46206' => 'IN',
        '46208' => 'IN',
        '46214' => 'IN',
        '46216' => 'IN',
        '46217' => 'IN',
        '46218' => 'IN',
        '46219' => 'IN',
        '46220' => 'IN',
        '46221' => 'IN',
        '46222' => 'IN',
        '46224' => 'IN',
        '46225' => 'IN',
        '46226' => 'IN',
        '46227' => 'IN',
        '46228' => 'IN',
        '46229' => 'IN',
        '46231' => 'IN',
        '46234' => 'IN',
        '46235' => 'IN',
        '46236' => 'IN',
        '46237' => 'IN',
        '46239' => 'IN',
        '46240' => 'IN',
        '46241' => 'IN',
        '46250' => 'IN',
        '46254' => 'IN',
        '46256' => 'IN',
        '46259' => 'IN',
        '46260' => 'IN',
        '46268' => 'IN',
        '46278' => 'IN',
        '46280' => 'IN',
        '46290' => 'IN',
        '46301' => 'IN',
        '46302' => 'IN',
        '46303' => 'IN',
        '46304' => 'IN',
        '46307' => 'IN',
        '46310' => 'IN',
        '46311' => 'IN',
        '46312' => 'IN',
        '46319' => 'IN',
        '46320' => 'IN',
        '46321' => 'IN',
        '46322' => 'IN',
        '46323' => 'IN',
        '46324' => 'IN',
        '46327' => 'IN',
        '46340' => 'IN',
        '46341' => 'IN',
        '46342' => 'IN',
        '46345' => 'IN',
        '46346' => 'IN',
        '46347' => 'IN',
        '46348' => 'IN',
        '46349' => 'IN',
        '46350' => 'IN',
        '46356' => 'IN',
        '46360' => 'IN',
        '46365' => 'IN',
        '46366' => 'IN',
        '46368' => 'IN',
        '46371' => 'IN',
        '46373' => 'IN',
        '46374' => 'IN',
        '46375' => 'IN',
        '46376' => 'IN',
        '46377' => 'IN',
        '46379' => 'IN',
        '46381' => 'IN',
        '46382' => 'IN',
        '46383' => 'IN',
        '46385' => 'IN',
        '46390' => 'IN',
        '46391' => 'IN',
        '46392' => 'IN',
        '46393' => 'IN',
        '46394' => 'IN',
        '46402' => 'IN',
        '46403' => 'IN',
        '46404' => 'IN',
        '46405' => 'IN',
        '46406' => 'IN',
        '46407' => 'IN',
        '46408' => 'IN',
        '46409' => 'IN',
        '46410' => 'IN',
        '46501' => 'IN',
        '46502' => 'IN',
        '46504' => 'IN',
        '46506' => 'IN',
        '46507' => 'IN',
        '46508' => 'IN',
        '46510' => 'IN',
        '46511' => 'IN',
        '46513' => 'IN',
        '46514' => 'IN',
        '46516' => 'IN',
        '46517' => 'IN',
        '46524' => 'IN',
        '46526' => 'IN',
        '46528' => 'IN',
        '46530' => 'IN',
        '46531' => 'IN',
        '46532' => 'IN',
        '46534' => 'IN',
        '46536' => 'IN',
        '46537' => 'IN',
        '46538' => 'IN',
        '46539' => 'IN',
        '46540' => 'IN',
        '46542' => 'IN',
        '46543' => 'IN',
        '46544' => 'IN',
        '46545' => 'IN',
        '46550' => 'IN',
        '46552' => 'IN',
        '46553' => 'IN',
        '46554' => 'IN',
        '46555' => 'IN',
        '46556' => 'IN',
        '46561' => 'IN',
        '46562' => 'IN',
        '46563' => 'IN',
        '46565' => 'IN',
        '46567' => 'IN',
        '46570' => 'IN',
        '46571' => 'IN',
        '46572' => 'IN',
        '46573' => 'IN',
        '46574' => 'IN',
        '46580' => 'IN',
        '46582' => 'IN',
        '46590' => 'IN',
        '46595' => 'IN',
        '46601' => 'IN',
        '46613' => 'IN',
        '46614' => 'IN',
        '46615' => 'IN',
        '46616' => 'IN',
        '46617' => 'IN',
        '46619' => 'IN',
        '46624' => 'IN',
        '46628' => 'IN',
        '46635' => 'IN',
        '46637' => 'IN',
        '46701' => 'IN',
        '46702' => 'IN',
        '46703' => 'IN',
        '46704' => 'IN',
        '46705' => 'IN',
        '46706' => 'IN',
        '46710' => 'IN',
        '46711' => 'IN',
        '46714' => 'IN',
        '46721' => 'IN',
        '46723' => 'IN',
        '46725' => 'IN',
        '46730' => 'IN',
        '46731' => 'IN',
        '46732' => 'IN',
        '46733' => 'IN',
        '46737' => 'IN',
        '46738' => 'IN',
        '46740' => 'IN',
        '46741' => 'IN',
        '46742' => 'IN',
        '46743' => 'IN',
        '46745' => 'IN',
        '46746' => 'IN',
        '46747' => 'IN',
        '46748' => 'IN',
        '46750' => 'IN',
        '46755' => 'IN',
        '46759' => 'IN',
        '46760' => 'IN',
        '46761' => 'IN',
        '46763' => 'IN',
        '46764' => 'IN',
        '46765' => 'IN',
        '46766' => 'IN',
        '46767' => 'IN',
        '46770' => 'IN',
        '46771' => 'IN',
        '46772' => 'IN',
        '46773' => 'IN',
        '46774' => 'IN',
        '46776' => 'IN',
        '46777' => 'IN',
        '46778' => 'IN',
        '46779' => 'IN',
        '46781' => 'IN',
        '46783' => 'IN',
        '46784' => 'IN',
        '46785' => 'IN',
        '46786' => 'IN',
        '46787' => 'IN',
        '46788' => 'IN',
        '46789' => 'IN',
        '46791' => 'IN',
        '46792' => 'IN',
        '46793' => 'IN',
        '46794' => 'IN',
        '46795' => 'IN',
        '46796' => 'IN',
        '46797' => 'IN',
        '46798' => 'IN',
        '46799' => 'IN',
        '46802' => 'IN',
        '46803' => 'IN',
        '46804' => 'IN',
        '46805' => 'IN',
        '46806' => 'IN',
        '46807' => 'IN',
        '46808' => 'IN',
        '46809' => 'IN',
        '46814' => 'IN',
        '46815' => 'IN',
        '46816' => 'IN',
        '46818' => 'IN',
        '46819' => 'IN',
        '46825' => 'IN',
        '46835' => 'IN',
        '46845' => 'IN',
        '46901' => 'IN',
        '46902' => 'IN',
        '46910' => 'IN',
        '46911' => 'IN',
        '46913' => 'IN',
        '46914' => 'IN',
        '46915' => 'IN',
        '46917' => 'IN',
        '46919' => 'IN',
        '46920' => 'IN',
        '46922' => 'IN',
        '46923' => 'IN',
        '46926' => 'IN',
        '46928' => 'IN',
        '46929' => 'IN',
        '46930' => 'IN',
        '46931' => 'IN',
        '46932' => 'IN',
        '46933' => 'IN',
        '46936' => 'IN',
        '46937' => 'IN',
        '46938' => 'IN',
        '46939' => 'IN',
        '46940' => 'IN',
        '46941' => 'IN',
        '46943' => 'IN',
        '46945' => 'IN',
        '46946' => 'IN',
        '46947' => 'IN',
        '46950' => 'IN',
        '46951' => 'IN',
        '46952' => 'IN',
        '46953' => 'IN',
        '46957' => 'IN',
        '46958' => 'IN',
        '46959' => 'IN',
        '46960' => 'IN',
        '46961' => 'IN',
        '46962' => 'IN',
        '46965' => 'IN',
        '46967' => 'IN',
        '46968' => 'IN',
        '46970' => 'IN',
        '46971' => 'IN',
        '46974' => 'IN',
        '46975' => 'IN',
        '46978' => 'IN',
        '46979' => 'IN',
        '46980' => 'IN',
        '46982' => 'IN',
        '46984' => 'IN',
        '46985' => 'IN',
        '46986' => 'IN',
        '46987' => 'IN',
        '46988' => 'IN',
        '46989' => 'IN',
        '46990' => 'IN',
        '46991' => 'IN',
        '46992' => 'IN',
        '46994' => 'IN',
        '46996' => 'IN',
        '46998' => 'IN',
        '47001' => 'IN',
        '47003' => 'IN',
        '47006' => 'IN',
        '47010' => 'IN',
        '47011' => 'IN',
        '47012' => 'IN',
        '47016' => 'IN',
        '47017' => 'IN',
        '47018' => 'IN',
        '47020' => 'IN',
        '47021' => 'IN',
        '47022' => 'IN',
        '47023' => 'IN',
        '47024' => 'IN',
        '47025' => 'IN',
        '47030' => 'IN',
        '47031' => 'IN',
        '47032' => 'IN',
        '47033' => 'IN',
        '47034' => 'IN',
        '47035' => 'IN',
        '47036' => 'IN',
        '47037' => 'IN',
        '47038' => 'IN',
        '47040' => 'IN',
        '47041' => 'IN',
        '47042' => 'IN',
        '47043' => 'IN',
        '47060' => 'IN',
        '47102' => 'IN',
        '47104' => 'IN',
        '47106' => 'IN',
        '47108' => 'IN',
        '47110' => 'IN',
        '47111' => 'IN',
        '47112' => 'IN',
        '47114' => 'IN',
        '47115' => 'IN',
        '47116' => 'IN',
        '47117' => 'IN',
        '47118' => 'IN',
        '47119' => 'IN',
        '47120' => 'IN',
        '47122' => 'IN',
        '47123' => 'IN',
        '47124' => 'IN',
        '47125' => 'IN',
        '47126' => 'IN',
        '47129' => 'IN',
        '47130' => 'IN',
        '47135' => 'IN',
        '47136' => 'IN',
        '47137' => 'IN',
        '47138' => 'IN',
        '47140' => 'IN',
        '47141' => 'IN',
        '47142' => 'IN',
        '47143' => 'IN',
        '47145' => 'IN',
        '47147' => 'IN',
        '47150' => 'IN',
        '47160' => 'IN',
        '47161' => 'IN',
        '47162' => 'IN',
        '47163' => 'IN',
        '47164' => 'IN',
        '47165' => 'IN',
        '47166' => 'IN',
        '47167' => 'IN',
        '47170' => 'IN',
        '47172' => 'IN',
        '47174' => 'IN',
        '47175' => 'IN',
        '47177' => 'IN',
        '47201' => 'IN',
        '47203' => 'IN',
        '47220' => 'IN',
        '47223' => 'IN',
        '47224' => 'IN',
        '47225' => 'IN',
        '47226' => 'IN',
        '47227' => 'IN',
        '47229' => 'IN',
        '47230' => 'IN',
        '47231' => 'IN',
        '47232' => 'IN',
        '47234' => 'IN',
        '47235' => 'IN',
        '47236' => 'IN',
        '47240' => 'IN',
        '47243' => 'IN',
        '47244' => 'IN',
        '47246' => 'IN',
        '47247' => 'IN',
        '47250' => 'IN',
        '47260' => 'IN',
        '47263' => 'IN',
        '47264' => 'IN',
        '47265' => 'IN',
        '47270' => 'IN',
        '47272' => 'IN',
        '47273' => 'IN',
        '47274' => 'IN',
        '47280' => 'IN',
        '47281' => 'IN',
        '47282' => 'IN',
        '47283' => 'IN',
        '47302' => 'IN',
        '47303' => 'IN',
        '47304' => 'IN',
        '47305' => 'IN',
        '47306' => 'IN',
        '47320' => 'IN',
        '47324' => 'IN',
        '47325' => 'IN',
        '47326' => 'IN',
        '47327' => 'IN',
        '47330' => 'IN',
        '47331' => 'IN',
        '47334' => 'IN',
        '47335' => 'IN',
        '47336' => 'IN',
        '47337' => 'IN',
        '47338' => 'IN',
        '47339' => 'IN',
        '47340' => 'IN',
        '47341' => 'IN',
        '47342' => 'IN',
        '47344' => 'IN',
        '47345' => 'IN',
        '47346' => 'IN',
        '47348' => 'IN',
        '47351' => 'IN',
        '47352' => 'IN',
        '47353' => 'IN',
        '47354' => 'IN',
        '47355' => 'IN',
        '47356' => 'IN',
        '47357' => 'IN',
        '47358' => 'IN',
        '47359' => 'IN',
        '47360' => 'IN',
        '47361' => 'IN',
        '47362' => 'IN',
        '47366' => 'IN',
        '47367' => 'IN',
        '47368' => 'IN',
        '47369' => 'IN',
        '47370' => 'IN',
        '47371' => 'IN',
        '47373' => 'IN',
        '47374' => 'IN',
        '47380' => 'IN',
        '47381' => 'IN',
        '47382' => 'IN',
        '47383' => 'IN',
        '47384' => 'IN',
        '47385' => 'IN',
        '47386' => 'IN',
        '47387' => 'IN',
        '47388' => 'IN',
        '47390' => 'IN',
        '47392' => 'IN',
        '47393' => 'IN',
        '47394' => 'IN',
        '47396' => 'IN',
        '47401' => 'IN',
        '47403' => 'IN',
        '47404' => 'IN',
        '47405' => 'IN',
        '47406' => 'IN',
        '47408' => 'IN',
        '47420' => 'IN',
        '47421' => 'IN',
        '47424' => 'IN',
        '47427' => 'IN',
        '47429' => 'IN',
        '47431' => 'IN',
        '47432' => 'IN',
        '47433' => 'IN',
        '47434' => 'IN',
        '47435' => 'IN',
        '47436' => 'IN',
        '47437' => 'IN',
        '47438' => 'IN',
        '47441' => 'IN',
        '47443' => 'IN',
        '47445' => 'IN',
        '47446' => 'IN',
        '47448' => 'IN',
        '47449' => 'IN',
        '47451' => 'IN',
        '47452' => 'IN',
        '47453' => 'IN',
        '47454' => 'IN',
        '47455' => 'IN',
        '47456' => 'IN',
        '47457' => 'IN',
        '47458' => 'IN',
        '47459' => 'IN',
        '47460' => 'IN',
        '47462' => 'IN',
        '47464' => 'IN',
        '47465' => 'IN',
        '47467' => 'IN',
        '47468' => 'IN',
        '47469' => 'IN',
        '47470' => 'IN',
        '47471' => 'IN',
        '47501' => 'IN',
        '47512' => 'IN',
        '47513' => 'IN',
        '47514' => 'IN',
        '47515' => 'IN',
        '47516' => 'IN',
        '47519' => 'IN',
        '47520' => 'IN',
        '47521' => 'IN',
        '47522' => 'IN',
        '47523' => 'IN',
        '47524' => 'IN',
        '47525' => 'IN',
        '47527' => 'IN',
        '47528' => 'IN',
        '47529' => 'IN',
        '47531' => 'IN',
        '47532' => 'IN',
        '47535' => 'IN',
        '47537' => 'IN',
        '47541' => 'IN',
        '47542' => 'IN',
        '47546' => 'IN',
        '47550' => 'IN',
        '47551' => 'IN',
        '47552' => 'IN',
        '47553' => 'IN',
        '47557' => 'IN',
        '47558' => 'IN',
        '47561' => 'IN',
        '47562' => 'IN',
        '47564' => 'IN',
        '47567' => 'IN',
        '47568' => 'IN',
        '47573' => 'IN',
        '47574' => 'IN',
        '47575' => 'IN',
        '47576' => 'IN',
        '47577' => 'IN',
        '47578' => 'IN',
        '47579' => 'IN',
        '47580' => 'IN',
        '47581' => 'IN',
        '47584' => 'IN',
        '47585' => 'IN',
        '47586' => 'IN',
        '47588' => 'IN',
        '47590' => 'IN',
        '47591' => 'IN',
        '47596' => 'IN',
        '47597' => 'IN',
        '47598' => 'IN',
        '47601' => 'IN',
        '47610' => 'IN',
        '47611' => 'IN',
        '47612' => 'IN',
        '47613' => 'IN',
        '47615' => 'IN',
        '47616' => 'IN',
        '47619' => 'IN',
        '47620' => 'IN',
        '47630' => 'IN',
        '47631' => 'IN',
        '47633' => 'IN',
        '47634' => 'IN',
        '47635' => 'IN',
        '47637' => 'IN',
        '47638' => 'IN',
        '47639' => 'IN',
        '47640' => 'IN',
        '47648' => 'IN',
        '47649' => 'IN',
        '47654' => 'IN',
        '47660' => 'IN',
        '47665' => 'IN',
        '47666' => 'IN',
        '47670' => 'IN',
        '47683' => 'IN',
        '47708' => 'IN',
        '47710' => 'IN',
        '47711' => 'IN',
        '47712' => 'IN',
        '47713' => 'IN',
        '47714' => 'IN',
        '47715' => 'IN',
        '47720' => 'IN',
        '47725' => 'IN',
        '47802' => 'IN',
        '47803' => 'IN',
        '47804' => 'IN',
        '47805' => 'IN',
        '47807' => 'IN',
        '47809' => 'IN',
        '47831' => 'IN',
        '47832' => 'IN',
        '47833' => 'IN',
        '47834' => 'IN',
        '47836' => 'IN',
        '47837' => 'IN',
        '47838' => 'IN',
        '47840' => 'IN',
        '47841' => 'IN',
        '47842' => 'IN',
        '47845' => 'IN',
        '47846' => 'IN',
        '47847' => 'IN',
        '47848' => 'IN',
        '47849' => 'IN',
        '47850' => 'IN',
        '47851' => 'IN',
        '47853' => 'IN',
        '47854' => 'IN',
        '47855' => 'IN',
        '47857' => 'IN',
        '47858' => 'IN',
        '47859' => 'IN',
        '47860' => 'IN',
        '47861' => 'IN',
        '47862' => 'IN',
        '47863' => 'IN',
        '47865' => 'IN',
        '47866' => 'IN',
        '47868' => 'IN',
        '47869' => 'IN',
        '47870' => 'IN',
        '47871' => 'IN',
        '47872' => 'IN',
        '47874' => 'IN',
        '47875' => 'IN',
        '47876' => 'IN',
        '47879' => 'IN',
        '47880' => 'IN',
        '47881' => 'IN',
        '47882' => 'IN',
        '47884' => 'IN',
        '47885' => 'IN',
        '47901' => 'IN',
        '47904' => 'IN',
        '47905' => 'IN',
        '47906' => 'IN',
        '47907' => 'IN',
        '47909' => 'IN',
        '47916' => 'IN',
        '47917' => 'IN',
        '47918' => 'IN',
        '47920' => 'IN',
        '47921' => 'IN',
        '47922' => 'IN',
        '47923' => 'IN',
        '47924' => 'IN',
        '47925' => 'IN',
        '47926' => 'IN',
        '47928' => 'IN',
        '47929' => 'IN',
        '47930' => 'IN',
        '47932' => 'IN',
        '47933' => 'IN',
        '47940' => 'IN',
        '47941' => 'IN',
        '47942' => 'IN',
        '47943' => 'IN',
        '47944' => 'IN',
        '47946' => 'IN',
        '47948' => 'IN',
        '47949' => 'IN',
        '47950' => 'IN',
        '47951' => 'IN',
        '47952' => 'IN',
        '47954' => 'IN',
        '47955' => 'IN',
        '47957' => 'IN',
        '47958' => 'IN',
        '47959' => 'IN',
        '47960' => 'IN',
        '47963' => 'IN',
        '47964' => 'IN',
        '47965' => 'IN',
        '47966' => 'IN',
        '47967' => 'IN',
        '47968' => 'IN',
        '47969' => 'IN',
        '47970' => 'IN',
        '47971' => 'IN',
        '47974' => 'IN',
        '47975' => 'IN',
        '47977' => 'IN',
        '47978' => 'IN',
        '47980' => 'IN',
        '47981' => 'IN',
        '47982' => 'IN',
        '47983' => 'IN',
        '47986' => 'IN',
        '47987' => 'IN',
        '47989' => 'IN',
        '47990' => 'IN',
        '47991' => 'IN',
        '47992' => 'IN',
        '47993' => 'IN',
        '47994' => 'IN',
        '47995' => 'IN',
        '47997' => 'IN',
        '48001' => 'MI',
        '48002' => 'MI',
        '48003' => 'MI',
        '48005' => 'MI',
        '48006' => 'MI',
        '48009' => 'MI',
        '48014' => 'MI',
        '48015' => 'MI',
        '48017' => 'MI',
        '48021' => 'MI',
        '48022' => 'MI',
        '48023' => 'MI',
        '48025' => 'MI',
        '48026' => 'MI',
        '48027' => 'MI',
        '48028' => 'MI',
        '48030' => 'MI',
        '48032' => 'MI',
        '48033' => 'MI',
        '48034' => 'MI',
        '48035' => 'MI',
        '48036' => 'MI',
        '48038' => 'MI',
        '48039' => 'MI',
        '48040' => 'MI',
        '48041' => 'MI',
        '48042' => 'MI',
        '48043' => 'MI',
        '48044' => 'MI',
        '48045' => 'MI',
        '48047' => 'MI',
        '48048' => 'MI',
        '48049' => 'MI',
        '48050' => 'MI',
        '48051' => 'MI',
        '48054' => 'MI',
        '48059' => 'MI',
        '48060' => 'MI',
        '48062' => 'MI',
        '48063' => 'MI',
        '48064' => 'MI',
        '48065' => 'MI',
        '48066' => 'MI',
        '48067' => 'MI',
        '48069' => 'MI',
        '48070' => 'MI',
        '48071' => 'MI',
        '48072' => 'MI',
        '48073' => 'MI',
        '48074' => 'MI',
        '48075' => 'MI',
        '48076' => 'MI',
        '48079' => 'MI',
        '48080' => 'MI',
        '48081' => 'MI',
        '48082' => 'MI',
        '48083' => 'MI',
        '48084' => 'MI',
        '48085' => 'MI',
        '48088' => 'MI',
        '48089' => 'MI',
        '48091' => 'MI',
        '48092' => 'MI',
        '48093' => 'MI',
        '48094' => 'MI',
        '48095' => 'MI',
        '48096' => 'MI',
        '48097' => 'MI',
        '48098' => 'MI',
        '48101' => 'MI',
        '48103' => 'MI',
        '48104' => 'MI',
        '48105' => 'MI',
        '48108' => 'MI',
        '48109' => 'MI',
        '48111' => 'MI',
        '48114' => 'MI',
        '48116' => 'MI',
        '48117' => 'MI',
        '48118' => 'MI',
        '48120' => 'MI',
        '48122' => 'MI',
        '48124' => 'MI',
        '48125' => 'MI',
        '48126' => 'MI',
        '48127' => 'MI',
        '48128' => 'MI',
        '48130' => 'MI',
        '48131' => 'MI',
        '48133' => 'MI',
        '48134' => 'MI',
        '48135' => 'MI',
        '48137' => 'MI',
        '48138' => 'MI',
        '48139' => 'MI',
        '48140' => 'MI',
        '48141' => 'MI',
        '48143' => 'MI',
        '48144' => 'MI',
        '48145' => 'MI',
        '48146' => 'MI',
        '48150' => 'MI',
        '48152' => 'MI',
        '48154' => 'MI',
        '48157' => 'MI',
        '48158' => 'MI',
        '48159' => 'MI',
        '48160' => 'MI',
        '48161' => 'MI',
        '48162' => 'MI',
        '48164' => 'MI',
        '48165' => 'MI',
        '48166' => 'MI',
        '48167' => 'MI',
        '48168' => 'MI',
        '48169' => 'MI',
        '48170' => 'MI',
        '48173' => 'MI',
        '48174' => 'MI',
        '48176' => 'MI',
        '48177' => 'MI',
        '48178' => 'MI',
        '48179' => 'MI',
        '48180' => 'MI',
        '48182' => 'MI',
        '48183' => 'MI',
        '48184' => 'MI',
        '48185' => 'MI',
        '48186' => 'MI',
        '48187' => 'MI',
        '48188' => 'MI',
        '48189' => 'MI',
        '48190' => 'MI',
        '48191' => 'MI',
        '48192' => 'MI',
        '48193' => 'MI',
        '48195' => 'MI',
        '48197' => 'MI',
        '48198' => 'MI',
        '48201' => 'MI',
        '48202' => 'MI',
        '48203' => 'MI',
        '48204' => 'MI',
        '48205' => 'MI',
        '48206' => 'MI',
        '48207' => 'MI',
        '48208' => 'MI',
        '48209' => 'MI',
        '48210' => 'MI',
        '48211' => 'MI',
        '48212' => 'MI',
        '48213' => 'MI',
        '48214' => 'MI',
        '48215' => 'MI',
        '48216' => 'MI',
        '48217' => 'MI',
        '48218' => 'MI',
        '48219' => 'MI',
        '48220' => 'MI',
        '48221' => 'MI',
        '48223' => 'MI',
        '48224' => 'MI',
        '48225' => 'MI',
        '48226' => 'MI',
        '48227' => 'MI',
        '48228' => 'MI',
        '48229' => 'MI',
        '48230' => 'MI',
        '48233' => 'MI',
        '48234' => 'MI',
        '48235' => 'MI',
        '48236' => 'MI',
        '48237' => 'MI',
        '48238' => 'MI',
        '48239' => 'MI',
        '48240' => 'MI',
        '48242' => 'MI',
        '48243' => 'MI',
        '48301' => 'MI',
        '48302' => 'MI',
        '48304' => 'MI',
        '48306' => 'MI',
        '48307' => 'MI',
        '48309' => 'MI',
        '48310' => 'MI',
        '48312' => 'MI',
        '48313' => 'MI',
        '48314' => 'MI',
        '48315' => 'MI',
        '48316' => 'MI',
        '48317' => 'MI',
        '48320' => 'MI',
        '48322' => 'MI',
        '48323' => 'MI',
        '48324' => 'MI',
        '48326' => 'MI',
        '48327' => 'MI',
        '48328' => 'MI',
        '48329' => 'MI',
        '48331' => 'MI',
        '48334' => 'MI',
        '48335' => 'MI',
        '48336' => 'MI',
        '48340' => 'MI',
        '48341' => 'MI',
        '48342' => 'MI',
        '48346' => 'MI',
        '48348' => 'MI',
        '48350' => 'MI',
        '48353' => 'MI',
        '48356' => 'MI',
        '48357' => 'MI',
        '48359' => 'MI',
        '48360' => 'MI',
        '48362' => 'MI',
        '48363' => 'MI',
        '48367' => 'MI',
        '48370' => 'MI',
        '48371' => 'MI',
        '48374' => 'MI',
        '48375' => 'MI',
        '48377' => 'MI',
        '48380' => 'MI',
        '48381' => 'MI',
        '48382' => 'MI',
        '48383' => 'MI',
        '48386' => 'MI',
        '48390' => 'MI',
        '48393' => 'MI',
        '48401' => 'MI',
        '48410' => 'MI',
        '48411' => 'MI',
        '48412' => 'MI',
        '48413' => 'MI',
        '48414' => 'MI',
        '48415' => 'MI',
        '48416' => 'MI',
        '48417' => 'MI',
        '48418' => 'MI',
        '48419' => 'MI',
        '48420' => 'MI',
        '48421' => 'MI',
        '48422' => 'MI',
        '48423' => 'MI',
        '48426' => 'MI',
        '48427' => 'MI',
        '48428' => 'MI',
        '48429' => 'MI',
        '48430' => 'MI',
        '48432' => 'MI',
        '48433' => 'MI',
        '48434' => 'MI',
        '48435' => 'MI',
        '48436' => 'MI',
        '48437' => 'MI',
        '48438' => 'MI',
        '48439' => 'MI',
        '48440' => 'MI',
        '48441' => 'MI',
        '48442' => 'MI',
        '48444' => 'MI',
        '48445' => 'MI',
        '48446' => 'MI',
        '48449' => 'MI',
        '48450' => 'MI',
        '48451' => 'MI',
        '48453' => 'MI',
        '48454' => 'MI',
        '48455' => 'MI',
        '48456' => 'MI',
        '48457' => 'MI',
        '48458' => 'MI',
        '48460' => 'MI',
        '48461' => 'MI',
        '48462' => 'MI',
        '48463' => 'MI',
        '48464' => 'MI',
        '48465' => 'MI',
        '48466' => 'MI',
        '48467' => 'MI',
        '48468' => 'MI',
        '48469' => 'MI',
        '48470' => 'MI',
        '48471' => 'MI',
        '48472' => 'MI',
        '48473' => 'MI',
        '48475' => 'MI',
        '48476' => 'MI',
        '48502' => 'MI',
        '48503' => 'MI',
        '48504' => 'MI',
        '48505' => 'MI',
        '48506' => 'MI',
        '48507' => 'MI',
        '48509' => 'MI',
        '48519' => 'MI',
        '48529' => 'MI',
        '48532' => 'MI',
        '48601' => 'MI',
        '48602' => 'MI',
        '48603' => 'MI',
        '48604' => 'MI',
        '48607' => 'MI',
        '48609' => 'MI',
        '48610' => 'MI',
        '48611' => 'MI',
        '48612' => 'MI',
        '48613' => 'MI',
        '48614' => 'MI',
        '48615' => 'MI',
        '48616' => 'MI',
        '48617' => 'MI',
        '48618' => 'MI',
        '48619' => 'MI',
        '48620' => 'MI',
        '48621' => 'MI',
        '48622' => 'MI',
        '48623' => 'MI',
        '48624' => 'MI',
        '48625' => 'MI',
        '48626' => 'MI',
        '48627' => 'MI',
        '48628' => 'MI',
        '48629' => 'MI',
        '48630' => 'MI',
        '48631' => 'MI',
        '48632' => 'MI',
        '48633' => 'MI',
        '48634' => 'MI',
        '48635' => 'MI',
        '48636' => 'MI',
        '48637' => 'MI',
        '48638' => 'MI',
        '48640' => 'MI',
        '48642' => 'MI',
        '48647' => 'MI',
        '48649' => 'MI',
        '48650' => 'MI',
        '48651' => 'MI',
        '48652' => 'MI',
        '48653' => 'MI',
        '48654' => 'MI',
        '48655' => 'MI',
        '48656' => 'MI',
        '48657' => 'MI',
        '48658' => 'MI',
        '48659' => 'MI',
        '48661' => 'MI',
        '48662' => 'MI',
        '48701' => 'MI',
        '48703' => 'MI',
        '48705' => 'MI',
        '48706' => 'MI',
        '48708' => 'MI',
        '48710' => 'MI',
        '48720' => 'MI',
        '48721' => 'MI',
        '48722' => 'MI',
        '48723' => 'MI',
        '48724' => 'MI',
        '48725' => 'MI',
        '48726' => 'MI',
        '48727' => 'MI',
        '48728' => 'MI',
        '48729' => 'MI',
        '48730' => 'MI',
        '48731' => 'MI',
        '48732' => 'MI',
        '48733' => 'MI',
        '48734' => 'MI',
        '48735' => 'MI',
        '48737' => 'MI',
        '48738' => 'MI',
        '48739' => 'MI',
        '48740' => 'MI',
        '48741' => 'MI',
        '48742' => 'MI',
        '48743' => 'MI',
        '48744' => 'MI',
        '48745' => 'MI',
        '48746' => 'MI',
        '48747' => 'MI',
        '48748' => 'MI',
        '48749' => 'MI',
        '48750' => 'MI',
        '48754' => 'MI',
        '48755' => 'MI',
        '48756' => 'MI',
        '48757' => 'MI',
        '48759' => 'MI',
        '48760' => 'MI',
        '48761' => 'MI',
        '48762' => 'MI',
        '48763' => 'MI',
        '48765' => 'MI',
        '48766' => 'MI',
        '48767' => 'MI',
        '48768' => 'MI',
        '48770' => 'MI',
        '48801' => 'MI',
        '48806' => 'MI',
        '48807' => 'MI',
        '48808' => 'MI',
        '48809' => 'MI',
        '48811' => 'MI',
        '48813' => 'MI',
        '48815' => 'MI',
        '48816' => 'MI',
        '48817' => 'MI',
        '48818' => 'MI',
        '48819' => 'MI',
        '48820' => 'MI',
        '48821' => 'MI',
        '48822' => 'MI',
        '48823' => 'MI',
        '48824' => 'MI',
        '48825' => 'MI',
        '48827' => 'MI',
        '48829' => 'MI',
        '48831' => 'MI',
        '48832' => 'MI',
        '48834' => 'MI',
        '48835' => 'MI',
        '48836' => 'MI',
        '48837' => 'MI',
        '48838' => 'MI',
        '48840' => 'MI',
        '48841' => 'MI',
        '48842' => 'MI',
        '48843' => 'MI',
        '48845' => 'MI',
        '48846' => 'MI',
        '48847' => 'MI',
        '48848' => 'MI',
        '48849' => 'MI',
        '48850' => 'MI',
        '48851' => 'MI',
        '48852' => 'MI',
        '48853' => 'MI',
        '48854' => 'MI',
        '48855' => 'MI',
        '48856' => 'MI',
        '48857' => 'MI',
        '48858' => 'MI',
        '48859' => 'MI',
        '48860' => 'MI',
        '48861' => 'MI',
        '48862' => 'MI',
        '48864' => 'MI',
        '48865' => 'MI',
        '48866' => 'MI',
        '48867' => 'MI',
        '48870' => 'MI',
        '48871' => 'MI',
        '48872' => 'MI',
        '48873' => 'MI',
        '48874' => 'MI',
        '48875' => 'MI',
        '48876' => 'MI',
        '48877' => 'MI',
        '48878' => 'MI',
        '48879' => 'MI',
        '48880' => 'MI',
        '48881' => 'MI',
        '48883' => 'MI',
        '48884' => 'MI',
        '48885' => 'MI',
        '48886' => 'MI',
        '48888' => 'MI',
        '48889' => 'MI',
        '48890' => 'MI',
        '48891' => 'MI',
        '48892' => 'MI',
        '48893' => 'MI',
        '48894' => 'MI',
        '48895' => 'MI',
        '48896' => 'MI',
        '48897' => 'MI',
        '48906' => 'MI',
        '48910' => 'MI',
        '48911' => 'MI',
        '48912' => 'MI',
        '48915' => 'MI',
        '48917' => 'MI',
        '48933' => 'MI',
        '49001' => 'MI',
        '49002' => 'MI',
        '49004' => 'MI',
        '49006' => 'MI',
        '49007' => 'MI',
        '49008' => 'MI',
        '49009' => 'MI',
        '49010' => 'MI',
        '49011' => 'MI',
        '49012' => 'MI',
        '49013' => 'MI',
        '49014' => 'MI',
        '49015' => 'MI',
        '49017' => 'MI',
        '49021' => 'MI',
        '49022' => 'MI',
        '49024' => 'MI',
        '49026' => 'MI',
        '49027' => 'MI',
        '49028' => 'MI',
        '49029' => 'MI',
        '49030' => 'MI',
        '49031' => 'MI',
        '49032' => 'MI',
        '49033' => 'MI',
        '49034' => 'MI',
        '49036' => 'MI',
        '49037' => 'MI',
        '49038' => 'MI',
        '49040' => 'MI',
        '49042' => 'MI',
        '49043' => 'MI',
        '49045' => 'MI',
        '49046' => 'MI',
        '49047' => 'MI',
        '49048' => 'MI',
        '49050' => 'MI',
        '49051' => 'MI',
        '49052' => 'MI',
        '49053' => 'MI',
        '49055' => 'MI',
        '49056' => 'MI',
        '49057' => 'MI',
        '49058' => 'MI',
        '49060' => 'MI',
        '49061' => 'MI',
        '49063' => 'MI',
        '49064' => 'MI',
        '49065' => 'MI',
        '49066' => 'MI',
        '49067' => 'MI',
        '49068' => 'MI',
        '49070' => 'MI',
        '49071' => 'MI',
        '49072' => 'MI',
        '49073' => 'MI',
        '49074' => 'MI',
        '49075' => 'MI',
        '49076' => 'MI',
        '49078' => 'MI',
        '49079' => 'MI',
        '49080' => 'MI',
        '49082' => 'MI',
        '49083' => 'MI',
        '49084' => 'MI',
        '49085' => 'MI',
        '49087' => 'MI',
        '49088' => 'MI',
        '49089' => 'MI',
        '49090' => 'MI',
        '49091' => 'MI',
        '49092' => 'MI',
        '49093' => 'MI',
        '49094' => 'MI',
        '49095' => 'MI',
        '49096' => 'MI',
        '49097' => 'MI',
        '49098' => 'MI',
        '49099' => 'MI',
        '49101' => 'MI',
        '49102' => 'MI',
        '49103' => 'MI',
        '49104' => 'MI',
        '49106' => 'MI',
        '49107' => 'MI',
        '49111' => 'MI',
        '49112' => 'MI',
        '49113' => 'MI',
        '49115' => 'MI',
        '49116' => 'MI',
        '49117' => 'MI',
        '49119' => 'MI',
        '49120' => 'MI',
        '49125' => 'MI',
        '49126' => 'MI',
        '49127' => 'MI',
        '49128' => 'MI',
        '49129' => 'MI',
        '49130' => 'MI',
        '49201' => 'MI',
        '49202' => 'MI',
        '49203' => 'MI',
        '49220' => 'MI',
        '49221' => 'MI',
        '49224' => 'MI',
        '49227' => 'MI',
        '49228' => 'MI',
        '49229' => 'MI',
        '49230' => 'MI',
        '49232' => 'MI',
        '49233' => 'MI',
        '49234' => 'MI',
        '49235' => 'MI',
        '49236' => 'MI',
        '49237' => 'MI',
        '49238' => 'MI',
        '49240' => 'MI',
        '49241' => 'MI',
        '49242' => 'MI',
        '49245' => 'MI',
        '49246' => 'MI',
        '49247' => 'MI',
        '49248' => 'MI',
        '49249' => 'MI',
        '49250' => 'MI',
        '49251' => 'MI',
        '49252' => 'MI',
        '49253' => 'MI',
        '49254' => 'MI',
        '49255' => 'MI',
        '49256' => 'MI',
        '49258' => 'MI',
        '49259' => 'MI',
        '49261' => 'MI',
        '49262' => 'MI',
        '49263' => 'MI',
        '49264' => 'MI',
        '49265' => 'MI',
        '49266' => 'MI',
        '49267' => 'MI',
        '49268' => 'MI',
        '49269' => 'MI',
        '49270' => 'MI',
        '49271' => 'MI',
        '49272' => 'MI',
        '49274' => 'MI',
        '49276' => 'MI',
        '49277' => 'MI',
        '49279' => 'MI',
        '49282' => 'MI',
        '49283' => 'MI',
        '49284' => 'MI',
        '49285' => 'MI',
        '49286' => 'MI',
        '49287' => 'MI',
        '49288' => 'MI',
        '49289' => 'MI',
        '49301' => 'MI',
        '49302' => 'MI',
        '49303' => 'MI',
        '49304' => 'MI',
        '49305' => 'MI',
        '49306' => 'MI',
        '49307' => 'MI',
        '49309' => 'MI',
        '49310' => 'MI',
        '49312' => 'MI',
        '49315' => 'MI',
        '49316' => 'MI',
        '49318' => 'MI',
        '49319' => 'MI',
        '49320' => 'MI',
        '49321' => 'MI',
        '49322' => 'MI',
        '49323' => 'MI',
        '49325' => 'MI',
        '49326' => 'MI',
        '49327' => 'MI',
        '49328' => 'MI',
        '49329' => 'MI',
        '49330' => 'MI',
        '49331' => 'MI',
        '49332' => 'MI',
        '49333' => 'MI',
        '49335' => 'MI',
        '49336' => 'MI',
        '49337' => 'MI',
        '49338' => 'MI',
        '49339' => 'MI',
        '49340' => 'MI',
        '49341' => 'MI',
        '49342' => 'MI',
        '49343' => 'MI',
        '49344' => 'MI',
        '49345' => 'MI',
        '49346' => 'MI',
        '49347' => 'MI',
        '49348' => 'MI',
        '49349' => 'MI',
        '49401' => 'MI',
        '49402' => 'MI',
        '49403' => 'MI',
        '49404' => 'MI',
        '49405' => 'MI',
        '49406' => 'MI',
        '49408' => 'MI',
        '49409' => 'MI',
        '49410' => 'MI',
        '49411' => 'MI',
        '49412' => 'MI',
        '49415' => 'MI',
        '49417' => 'MI',
        '49418' => 'MI',
        '49419' => 'MI',
        '49420' => 'MI',
        '49421' => 'MI',
        '49423' => 'MI',
        '49424' => 'MI',
        '49425' => 'MI',
        '49426' => 'MI',
        '49428' => 'MI',
        '49430' => 'MI',
        '49431' => 'MI',
        '49434' => 'MI',
        '49435' => 'MI',
        '49436' => 'MI',
        '49437' => 'MI',
        '49440' => 'MI',
        '49441' => 'MI',
        '49442' => 'MI',
        '49443' => 'MI',
        '49444' => 'MI',
        '49445' => 'MI',
        '49446' => 'MI',
        '49448' => 'MI',
        '49449' => 'MI',
        '49450' => 'MI',
        '49451' => 'MI',
        '49452' => 'MI',
        '49453' => 'MI',
        '49454' => 'MI',
        '49455' => 'MI',
        '49456' => 'MI',
        '49457' => 'MI',
        '49458' => 'MI',
        '49459' => 'MI',
        '49460' => 'MI',
        '49461' => 'MI',
        '49464' => 'MI',
        '49503' => 'MI',
        '49504' => 'MI',
        '49505' => 'MI',
        '49506' => 'MI',
        '49507' => 'MI',
        '49508' => 'MI',
        '49509' => 'MI',
        '49512' => 'MI',
        '49519' => 'MI',
        '49525' => 'MI',
        '49534' => 'MI',
        '49544' => 'MI',
        '49546' => 'MI',
        '49548' => 'MI',
        '49601' => 'MI',
        '49611' => 'MI',
        '49612' => 'MI',
        '49613' => 'MI',
        '49614' => 'MI',
        '49615' => 'MI',
        '49616' => 'MI',
        '49617' => 'MI',
        '49618' => 'MI',
        '49619' => 'MI',
        '49620' => 'MI',
        '49621' => 'MI',
        '49622' => 'MI',
        '49623' => 'MI',
        '49625' => 'MI',
        '49626' => 'MI',
        '49627' => 'MI',
        '49628' => 'MI',
        '49629' => 'MI',
        '49630' => 'MI',
        '49631' => 'MI',
        '49632' => 'MI',
        '49633' => 'MI',
        '49634' => 'MI',
        '49635' => 'MI',
        '49636' => 'MI',
        '49637' => 'MI',
        '49638' => 'MI',
        '49639' => 'MI',
        '49640' => 'MI',
        '49642' => 'MI',
        '49643' => 'MI',
        '49644' => 'MI',
        '49645' => 'MI',
        '49646' => 'MI',
        '49648' => 'MI',
        '49649' => 'MI',
        '49650' => 'MI',
        '49651' => 'MI',
        '49653' => 'MI',
        '49654' => 'MI',
        '49655' => 'MI',
        '49656' => 'MI',
        '49657' => 'MI',
        '49659' => 'MI',
        '49660' => 'MI',
        '49663' => 'MI',
        '49664' => 'MI',
        '49665' => 'MI',
        '49667' => 'MI',
        '49668' => 'MI',
        '49670' => 'MI',
        '49674' => 'MI',
        '49675' => 'MI',
        '49676' => 'MI',
        '49677' => 'MI',
        '49679' => 'MI',
        '49680' => 'MI',
        '49682' => 'MI',
        '49683' => 'MI',
        '49684' => 'MI',
        '49685' => 'MI',
        '49686' => 'MI',
        '49688' => 'MI',
        '49689' => 'MI',
        '49690' => 'MI',
        '49696' => 'MI',
        '49701' => 'MI',
        '49705' => 'MI',
        '49706' => 'MI',
        '49707' => 'MI',
        '49709' => 'MI',
        '49710' => 'MI',
        '49712' => 'MI',
        '49713' => 'MI',
        '49715' => 'MI',
        '49716' => 'MI',
        '49717' => 'MI',
        '49718' => 'MI',
        '49719' => 'MI',
        '49720' => 'MI',
        '49721' => 'MI',
        '49722' => 'MI',
        '49724' => 'MI',
        '49725' => 'MI',
        '49726' => 'MI',
        '49727' => 'MI',
        '49728' => 'MI',
        '49729' => 'MI',
        '49730' => 'MI',
        '49733' => 'MI',
        '49735' => 'MI',
        '49736' => 'MI',
        '49738' => 'MI',
        '49740' => 'MI',
        '49743' => 'MI',
        '49744' => 'MI',
        '49745' => 'MI',
        '49746' => 'MI',
        '49747' => 'MI',
        '49748' => 'MI',
        '49749' => 'MI',
        '49751' => 'MI',
        '49752' => 'MI',
        '49753' => 'MI',
        '49755' => 'MI',
        '49756' => 'MI',
        '49757' => 'MI',
        '49759' => 'MI',
        '49760' => 'MI',
        '49762' => 'MI',
        '49764' => 'MI',
        '49765' => 'MI',
        '49766' => 'MI',
        '49768' => 'MI',
        '49769' => 'MI',
        '49770' => 'MI',
        '49774' => 'MI',
        '49775' => 'MI',
        '49776' => 'MI',
        '49777' => 'MI',
        '49779' => 'MI',
        '49780' => 'MI',
        '49781' => 'MI',
        '49782' => 'MI',
        '49783' => 'MI',
        '49784' => 'MI',
        '49788' => 'MI',
        '49791' => 'MI',
        '49793' => 'MI',
        '49795' => 'MI',
        '49796' => 'MI',
        '49799' => 'MI',
        '49801' => 'MI',
        '49802' => 'MI',
        '49805' => 'MI',
        '49806' => 'MI',
        '49807' => 'MI',
        '49808' => 'MI',
        '49812' => 'MI',
        '49814' => 'MI',
        '49815' => 'MI',
        '49816' => 'MI',
        '49817' => 'MI',
        '49818' => 'MI',
        '49820' => 'MI',
        '49821' => 'MI',
        '49822' => 'MI',
        '49825' => 'MI',
        '49826' => 'MI',
        '49827' => 'MI',
        '49829' => 'MI',
        '49831' => 'MI',
        '49833' => 'MI',
        '49834' => 'MI',
        '49835' => 'MI',
        '49836' => 'MI',
        '49837' => 'MI',
        '49838' => 'MI',
        '49839' => 'MI',
        '49840' => 'MI',
        '49841' => 'MI',
        '49847' => 'MI',
        '49848' => 'MI',
        '49849' => 'MI',
        '49852' => 'MI',
        '49853' => 'MI',
        '49854' => 'MI',
        '49855' => 'MI',
        '49858' => 'MI',
        '49861' => 'MI',
        '49862' => 'MI',
        '49863' => 'MI',
        '49864' => 'MI',
        '49866' => 'MI',
        '49868' => 'MI',
        '49870' => 'MI',
        '49871' => 'MI',
        '49872' => 'MI',
        '49873' => 'MI',
        '49874' => 'MI',
        '49876' => 'MI',
        '49877' => 'MI',
        '49878' => 'MI',
        '49879' => 'MI',
        '49880' => 'MI',
        '49881' => 'MI',
        '49883' => 'MI',
        '49884' => 'MI',
        '49885' => 'MI',
        '49886' => 'MI',
        '49887' => 'MI',
        '49891' => 'MI',
        '49892' => 'MI',
        '49893' => 'MI',
        '49894' => 'MI',
        '49895' => 'MI',
        '49896' => 'MI',
        '49901' => 'MI',
        '49902' => 'MI',
        '49903' => 'MI',
        '49905' => 'MI',
        '49908' => 'MI',
        '49910' => 'MI',
        '49911' => 'MI',
        '49912' => 'MI',
        '49913' => 'MI',
        '49915' => 'MI',
        '49916' => 'MI',
        '49917' => 'MI',
        '49918' => 'MI',
        '49919' => 'MI',
        '49920' => 'MI',
        '49921' => 'MI',
        '49922' => 'MI',
        '49925' => 'MI',
        '49927' => 'MI',
        '49929' => 'MI',
        '49930' => 'MI',
        '49931' => 'MI',
        '49934' => 'MI',
        '49935' => 'MI',
        '49938' => 'MI',
        '49942' => 'MI',
        '49945' => 'MI',
        '49946' => 'MI',
        '49947' => 'MI',
        '49948' => 'MI',
        '49950' => 'MI',
        '49952' => 'MI',
        '49953' => 'MI',
        '49955' => 'MI',
        '49958' => 'MI',
        '49959' => 'MI',
        '49960' => 'MI',
        '49961' => 'MI',
        '49962' => 'MI',
        '49963' => 'MI',
        '49965' => 'MI',
        '49967' => 'MI',
        '49968' => 'MI',
        '49969' => 'MI',
        '49970' => 'MI',
        '49971' => 'MI',
        '50001' => 'IA',
        '50002' => 'IA',
        '50003' => 'IA',
        '50005' => 'IA',
        '50006' => 'IA',
        '50007' => 'IA',
        '50008' => 'IA',
        '50009' => 'IA',
        '50010' => 'IA',
        '50012' => 'IA',
        '50013' => 'IA',
        '50014' => 'IA',
        '50020' => 'IA',
        '50021' => 'IA',
        '50022' => 'IA',
        '50023' => 'IA',
        '50025' => 'IA',
        '50026' => 'IA',
        '50027' => 'IA',
        '50028' => 'IA',
        '50029' => 'IA',
        '50031' => 'IA',
        '50032' => 'IA',
        '50033' => 'IA',
        '50034' => 'IA',
        '50035' => 'IA',
        '50036' => 'IA',
        '50038' => 'IA',
        '50039' => 'IA',
        '50040' => 'IA',
        '50041' => 'IA',
        '50042' => 'IA',
        '50044' => 'IA',
        '50046' => 'IA',
        '50047' => 'IA',
        '50048' => 'IA',
        '50049' => 'IA',
        '50050' => 'IA',
        '50051' => 'IA',
        '50052' => 'IA',
        '50054' => 'IA',
        '50055' => 'IA',
        '50056' => 'IA',
        '50057' => 'IA',
        '50058' => 'IA',
        '50060' => 'IA',
        '50061' => 'IA',
        '50062' => 'IA',
        '50063' => 'IA',
        '50064' => 'IA',
        '50065' => 'IA',
        '50066' => 'IA',
        '50067' => 'IA',
        '50068' => 'IA',
        '50069' => 'IA',
        '50070' => 'IA',
        '50071' => 'IA',
        '50072' => 'IA',
        '50073' => 'IA',
        '50074' => 'IA',
        '50075' => 'IA',
        '50076' => 'IA',
        '50078' => 'IA',
        '50101' => 'IA',
        '50102' => 'IA',
        '50103' => 'IA',
        '50104' => 'IA',
        '50105' => 'IA',
        '50106' => 'IA',
        '50107' => 'IA',
        '50108' => 'IA',
        '50109' => 'IA',
        '50110' => 'IA',
        '50111' => 'IA',
        '50112' => 'IA',
        '50115' => 'IA',
        '50116' => 'IA',
        '50117' => 'IA',
        '50118' => 'IA',
        '50119' => 'IA',
        '50120' => 'IA',
        '50122' => 'IA',
        '50123' => 'IA',
        '50124' => 'IA',
        '50125' => 'IA',
        '50126' => 'IA',
        '50127' => 'IA',
        '50128' => 'IA',
        '50129' => 'IA',
        '50130' => 'IA',
        '50131' => 'IA',
        '50132' => 'IA',
        '50133' => 'IA',
        '50134' => 'IA',
        '50135' => 'IA',
        '50136' => 'IA',
        '50137' => 'IA',
        '50138' => 'IA',
        '50139' => 'IA',
        '50140' => 'IA',
        '50141' => 'IA',
        '50142' => 'IA',
        '50143' => 'IA',
        '50144' => 'IA',
        '50145' => 'IA',
        '50146' => 'IA',
        '50147' => 'IA',
        '50148' => 'IA',
        '50149' => 'IA',
        '50150' => 'IA',
        '50151' => 'IA',
        '50152' => 'IA',
        '50153' => 'IA',
        '50154' => 'IA',
        '50155' => 'IA',
        '50156' => 'IA',
        '50157' => 'IA',
        '50158' => 'IA',
        '50160' => 'IA',
        '50161' => 'IA',
        '50162' => 'IA',
        '50163' => 'IA',
        '50164' => 'IA',
        '50165' => 'IA',
        '50166' => 'IA',
        '50167' => 'IA',
        '50168' => 'IA',
        '50169' => 'IA',
        '50170' => 'IA',
        '50171' => 'IA',
        '50173' => 'IA',
        '50174' => 'IA',
        '50201' => 'IA',
        '50206' => 'IA',
        '50207' => 'IA',
        '50208' => 'IA',
        '50210' => 'IA',
        '50211' => 'IA',
        '50212' => 'IA',
        '50213' => 'IA',
        '50214' => 'IA',
        '50216' => 'IA',
        '50217' => 'IA',
        '50218' => 'IA',
        '50219' => 'IA',
        '50220' => 'IA',
        '50222' => 'IA',
        '50223' => 'IA',
        '50225' => 'IA',
        '50226' => 'IA',
        '50227' => 'IA',
        '50228' => 'IA',
        '50229' => 'IA',
        '50230' => 'IA',
        '50231' => 'IA',
        '50232' => 'IA',
        '50233' => 'IA',
        '50234' => 'IA',
        '50235' => 'IA',
        '50236' => 'IA',
        '50237' => 'IA',
        '50238' => 'IA',
        '50239' => 'IA',
        '50240' => 'IA',
        '50241' => 'IA',
        '50242' => 'IA',
        '50243' => 'IA',
        '50244' => 'IA',
        '50246' => 'IA',
        '50247' => 'IA',
        '50248' => 'IA',
        '50249' => 'IA',
        '50250' => 'IA',
        '50251' => 'IA',
        '50252' => 'IA',
        '50254' => 'IA',
        '50255' => 'IA',
        '50256' => 'IA',
        '50257' => 'IA',
        '50258' => 'IA',
        '50261' => 'IA',
        '50262' => 'IA',
        '50263' => 'IA',
        '50264' => 'IA',
        '50265' => 'IA',
        '50266' => 'IA',
        '50268' => 'IA',
        '50269' => 'IA',
        '50271' => 'IA',
        '50272' => 'IA',
        '50273' => 'IA',
        '50274' => 'IA',
        '50275' => 'IA',
        '50276' => 'IA',
        '50277' => 'IA',
        '50278' => 'IA',
        '50309' => 'IA',
        '50310' => 'IA',
        '50311' => 'IA',
        '50312' => 'IA',
        '50313' => 'IA',
        '50314' => 'IA',
        '50315' => 'IA',
        '50316' => 'IA',
        '50317' => 'IA',
        '50319' => 'IA',
        '50320' => 'IA',
        '50321' => 'IA',
        '50322' => 'IA',
        '50323' => 'IA',
        '50324' => 'IA',
        '50325' => 'IA',
        '50327' => 'IA',
        '50401' => 'IA',
        '50420' => 'IA',
        '50421' => 'IA',
        '50423' => 'IA',
        '50424' => 'IA',
        '50426' => 'IA',
        '50427' => 'IA',
        '50428' => 'IA',
        '50430' => 'IA',
        '50431' => 'IA',
        '50432' => 'IA',
        '50433' => 'IA',
        '50434' => 'IA',
        '50435' => 'IA',
        '50436' => 'IA',
        '50438' => 'IA',
        '50439' => 'IA',
        '50440' => 'IA',
        '50441' => 'IA',
        '50444' => 'IA',
        '50446' => 'IA',
        '50447' => 'IA',
        '50448' => 'IA',
        '50449' => 'IA',
        '50450' => 'IA',
        '50451' => 'IA',
        '50452' => 'IA',
        '50453' => 'IA',
        '50454' => 'IA',
        '50455' => 'IA',
        '50456' => 'IA',
        '50457' => 'IA',
        '50458' => 'IA',
        '50459' => 'IA',
        '50460' => 'IA',
        '50461' => 'IA',
        '50464' => 'IA',
        '50465' => 'IA',
        '50466' => 'IA',
        '50467' => 'IA',
        '50468' => 'IA',
        '50469' => 'IA',
        '50470' => 'IA',
        '50471' => 'IA',
        '50472' => 'IA',
        '50473' => 'IA',
        '50475' => 'IA',
        '50476' => 'IA',
        '50477' => 'IA',
        '50478' => 'IA',
        '50479' => 'IA',
        '50480' => 'IA',
        '50482' => 'IA',
        '50483' => 'IA',
        '50484' => 'IA',
        '50501' => 'IA',
        '50510' => 'IA',
        '50511' => 'IA',
        '50514' => 'IA',
        '50515' => 'IA',
        '50516' => 'IA',
        '50517' => 'IA',
        '50518' => 'IA',
        '50519' => 'IA',
        '50520' => 'IA',
        '50521' => 'IA',
        '50522' => 'IA',
        '50523' => 'IA',
        '50524' => 'IA',
        '50525' => 'IA',
        '50527' => 'IA',
        '50528' => 'IA',
        '50529' => 'IA',
        '50530' => 'IA',
        '50531' => 'IA',
        '50532' => 'IA',
        '50533' => 'IA',
        '50535' => 'IA',
        '50536' => 'IA',
        '50538' => 'IA',
        '50539' => 'IA',
        '50540' => 'IA',
        '50541' => 'IA',
        '50542' => 'IA',
        '50543' => 'IA',
        '50544' => 'IA',
        '50545' => 'IA',
        '50546' => 'IA',
        '50548' => 'IA',
        '50551' => 'IA',
        '50552' => 'IA',
        '50554' => 'IA',
        '50556' => 'IA',
        '50557' => 'IA',
        '50558' => 'IA',
        '50559' => 'IA',
        '50560' => 'IA',
        '50561' => 'IA',
        '50562' => 'IA',
        '50563' => 'IA',
        '50565' => 'IA',
        '50566' => 'IA',
        '50567' => 'IA',
        '50568' => 'IA',
        '50569' => 'IA',
        '50570' => 'IA',
        '50571' => 'IA',
        '50573' => 'IA',
        '50574' => 'IA',
        '50575' => 'IA',
        '50576' => 'IA',
        '50577' => 'IA',
        '50578' => 'IA',
        '50579' => 'IA',
        '50581' => 'IA',
        '50582' => 'IA',
        '50583' => 'IA',
        '50585' => 'IA',
        '50586' => 'IA',
        '50588' => 'IA',
        '50590' => 'IA',
        '50591' => 'IA',
        '50592' => 'IA',
        '50593' => 'IA',
        '50594' => 'IA',
        '50595' => 'IA',
        '50597' => 'IA',
        '50598' => 'IA',
        '50599' => 'IA',
        '50601' => 'IA',
        '50602' => 'IA',
        '50603' => 'IA',
        '50604' => 'IA',
        '50605' => 'IA',
        '50606' => 'IA',
        '50607' => 'IA',
        '50608' => 'IA',
        '50609' => 'IA',
        '50611' => 'IA',
        '50612' => 'IA',
        '50613' => 'IA',
        '50616' => 'IA',
        '50619' => 'IA',
        '50620' => 'IA',
        '50621' => 'IA',
        '50622' => 'IA',
        '50623' => 'IA',
        '50624' => 'IA',
        '50625' => 'IA',
        '50626' => 'IA',
        '50627' => 'IA',
        '50628' => 'IA',
        '50629' => 'IA',
        '50630' => 'IA',
        '50631' => 'IA',
        '50632' => 'IA',
        '50633' => 'IA',
        '50634' => 'IA',
        '50635' => 'IA',
        '50636' => 'IA',
        '50638' => 'IA',
        '50641' => 'IA',
        '50642' => 'IA',
        '50643' => 'IA',
        '50644' => 'IA',
        '50645' => 'IA',
        '50647' => 'IA',
        '50648' => 'IA',
        '50649' => 'IA',
        '50650' => 'IA',
        '50651' => 'IA',
        '50652' => 'IA',
        '50653' => 'IA',
        '50654' => 'IA',
        '50655' => 'IA',
        '50657' => 'IA',
        '50658' => 'IA',
        '50659' => 'IA',
        '50660' => 'IA',
        '50662' => 'IA',
        '50664' => 'IA',
        '50665' => 'IA',
        '50666' => 'IA',
        '50667' => 'IA',
        '50668' => 'IA',
        '50669' => 'IA',
        '50670' => 'IA',
        '50671' => 'IA',
        '50672' => 'IA',
        '50673' => 'IA',
        '50674' => 'IA',
        '50675' => 'IA',
        '50676' => 'IA',
        '50677' => 'IA',
        '50680' => 'IA',
        '50681' => 'IA',
        '50682' => 'IA',
        '50701' => 'IA',
        '50702' => 'IA',
        '50703' => 'IA',
        '50707' => 'IA',
        '50801' => 'IA',
        '50830' => 'IA',
        '50831' => 'IA',
        '50833' => 'IA',
        '50835' => 'IA',
        '50836' => 'IA',
        '50837' => 'IA',
        '50839' => 'IA',
        '50840' => 'IA',
        '50841' => 'IA',
        '50842' => 'IA',
        '50843' => 'IA',
        '50845' => 'IA',
        '50846' => 'IA',
        '50847' => 'IA',
        '50848' => 'IA',
        '50849' => 'IA',
        '50851' => 'IA',
        '50853' => 'IA',
        '50854' => 'IA',
        '50857' => 'IA',
        '50858' => 'IA',
        '50859' => 'IA',
        '50860' => 'IA',
        '50861' => 'IA',
        '50862' => 'IA',
        '50863' => 'IA',
        '50864' => 'IA',
        '51001' => 'IA',
        '51002' => 'IA',
        '51003' => 'IA',
        '51004' => 'IA',
        '51005' => 'IA',
        '51006' => 'IA',
        '51007' => 'IA',
        '51008' => 'IA',
        '51009' => 'IA',
        '51010' => 'IA',
        '51011' => 'IA',
        '51012' => 'IA',
        '51014' => 'IA',
        '51015' => 'IA',
        '51016' => 'IA',
        '51018' => 'IA',
        '51019' => 'IA',
        '51020' => 'IA',
        '51022' => 'IA',
        '51023' => 'IA',
        '51024' => 'IA',
        '51025' => 'IA',
        '51026' => 'IA',
        '51027' => 'IA',
        '51028' => 'IA',
        '51029' => 'IA',
        '51030' => 'IA',
        '51031' => 'IA',
        '51033' => 'IA',
        '51034' => 'IA',
        '51035' => 'IA',
        '51036' => 'IA',
        '51037' => 'IA',
        '51038' => 'IA',
        '51039' => 'IA',
        '51040' => 'IA',
        '51041' => 'IA',
        '51044' => 'IA',
        '51045' => 'IA',
        '51046' => 'IA',
        '51047' => 'IA',
        '51048' => 'IA',
        '51049' => 'IA',
        '51050' => 'IA',
        '51051' => 'IA',
        '51052' => 'IA',
        '51053' => 'IA',
        '51054' => 'IA',
        '51055' => 'IA',
        '51056' => 'IA',
        '51058' => 'IA',
        '51060' => 'IA',
        '51061' => 'IA',
        '51062' => 'IA',
        '51063' => 'IA',
        '51101' => 'IA',
        '51103' => 'IA',
        '51104' => 'IA',
        '51105' => 'IA',
        '51106' => 'IA',
        '51108' => 'IA',
        '51109' => 'IA',
        '51111' => 'IA',
        '51201' => 'IA',
        '51230' => 'IA',
        '51231' => 'IA',
        '51232' => 'IA',
        '51234' => 'IA',
        '51235' => 'IA',
        '51237' => 'IA',
        '51238' => 'IA',
        '51239' => 'IA',
        '51240' => 'IA',
        '51241' => 'IA',
        '51242' => 'IA',
        '51243' => 'IA',
        '51244' => 'IA',
        '51245' => 'IA',
        '51246' => 'IA',
        '51247' => 'IA',
        '51248' => 'IA',
        '51249' => 'IA',
        '51250' => 'IA',
        '51301' => 'IA',
        '51331' => 'IA',
        '51333' => 'IA',
        '51334' => 'IA',
        '51338' => 'IA',
        '51340' => 'IA',
        '51341' => 'IA',
        '51342' => 'IA',
        '51343' => 'IA',
        '51345' => 'IA',
        '51346' => 'IA',
        '51347' => 'IA',
        '51350' => 'IA',
        '51351' => 'IA',
        '51354' => 'IA',
        '51355' => 'IA',
        '51357' => 'IA',
        '51358' => 'IA',
        '51360' => 'IA',
        '51363' => 'IA',
        '51364' => 'IA',
        '51365' => 'IA',
        '51366' => 'IA',
        '51401' => 'IA',
        '51430' => 'IA',
        '51431' => 'IA',
        '51432' => 'IA',
        '51433' => 'IA',
        '51436' => 'IA',
        '51439' => 'IA',
        '51440' => 'IA',
        '51441' => 'IA',
        '51442' => 'IA',
        '51443' => 'IA',
        '51444' => 'IA',
        '51445' => 'IA',
        '51446' => 'IA',
        '51447' => 'IA',
        '51448' => 'IA',
        '51449' => 'IA',
        '51450' => 'IA',
        '51451' => 'IA',
        '51452' => 'IA',
        '51453' => 'IA',
        '51454' => 'IA',
        '51455' => 'IA',
        '51458' => 'IA',
        '51459' => 'IA',
        '51460' => 'IA',
        '51461' => 'IA',
        '51462' => 'IA',
        '51463' => 'IA',
        '51465' => 'IA',
        '51466' => 'IA',
        '51467' => 'IA',
        '51501' => 'IA',
        '51503' => 'IA',
        '51510' => 'IA',
        '51520' => 'IA',
        '51521' => 'IA',
        '51523' => 'IA',
        '51525' => 'IA',
        '51526' => 'IA',
        '51527' => 'IA',
        '51528' => 'IA',
        '51529' => 'IA',
        '51530' => 'IA',
        '51531' => 'IA',
        '51532' => 'IA',
        '51533' => 'IA',
        '51534' => 'IA',
        '51535' => 'IA',
        '51536' => 'IA',
        '51537' => 'IA',
        '51540' => 'IA',
        '51541' => 'IA',
        '51542' => 'IA',
        '51543' => 'IA',
        '51544' => 'IA',
        '51545' => 'IA',
        '51546' => 'IA',
        '51548' => 'IA',
        '51549' => 'IA',
        '51550' => 'IA',
        '51551' => 'IA',
        '51552' => 'IA',
        '51553' => 'IA',
        '51554' => 'IA',
        '51555' => 'IA',
        '51556' => 'IA',
        '51557' => 'IA',
        '51558' => 'IA',
        '51559' => 'IA',
        '51560' => 'IA',
        '51561' => 'IA',
        '51562' => 'IA',
        '51563' => 'IA',
        '51564' => 'IA',
        '51565' => 'IA',
        '51566' => 'IA',
        '51570' => 'IA',
        '51571' => 'IA',
        '51572' => 'IA',
        '51573' => 'IA',
        '51575' => 'IA',
        '51576' => 'IA',
        '51577' => 'IA',
        '51578' => 'IA',
        '51579' => 'IA',
        '51601' => 'IA',
        '51630' => 'IA',
        '51631' => 'IA',
        '51632' => 'IA',
        '51636' => 'IA',
        '51637' => 'IA',
        '51638' => 'IA',
        '51639' => 'IA',
        '51640' => 'IA',
        '51645' => 'IA',
        '51646' => 'IA',
        '51647' => 'IA',
        '51648' => 'IA',
        '51649' => 'IA',
        '51650' => 'IA',
        '51651' => 'IA',
        '51652' => 'IA',
        '51653' => 'IA',
        '51654' => 'IA',
        '51656' => 'IA',
        '52001' => 'IA',
        '52002' => 'IA',
        '52003' => 'IA',
        '52030' => 'IA',
        '52031' => 'IA',
        '52032' => 'IA',
        '52033' => 'IA',
        '52035' => 'IA',
        '52036' => 'IA',
        '52037' => 'IA',
        '52038' => 'IA',
        '52039' => 'IA',
        '52040' => 'IA',
        '52041' => 'IA',
        '52042' => 'IA',
        '52043' => 'IA',
        '52044' => 'IA',
        '52045' => 'IA',
        '52046' => 'IA',
        '52047' => 'IA',
        '52048' => 'IA',
        '52049' => 'IA',
        '52050' => 'IA',
        '52052' => 'IA',
        '52053' => 'IA',
        '52054' => 'IA',
        '52056' => 'IA',
        '52057' => 'IA',
        '52060' => 'IA',
        '52064' => 'IA',
        '52065' => 'IA',
        '52066' => 'IA',
        '52068' => 'IA',
        '52069' => 'IA',
        '52070' => 'IA',
        '52071' => 'IA',
        '52072' => 'IA',
        '52073' => 'IA',
        '52074' => 'IA',
        '52075' => 'IA',
        '52076' => 'IA',
        '52077' => 'IA',
        '52078' => 'IA',
        '52079' => 'IA',
        '52101' => 'IA',
        '52132' => 'IA',
        '52133' => 'IA',
        '52134' => 'IA',
        '52135' => 'IA',
        '52136' => 'IA',
        '52140' => 'IA',
        '52141' => 'IA',
        '52142' => 'IA',
        '52144' => 'IA',
        '52146' => 'IA',
        '52147' => 'IA',
        '52151' => 'IA',
        '52154' => 'IA',
        '52155' => 'IA',
        '52156' => 'IA',
        '52157' => 'IA',
        '52158' => 'IA',
        '52159' => 'IA',
        '52160' => 'IA',
        '52161' => 'IA',
        '52162' => 'IA',
        '52163' => 'IA',
        '52164' => 'IA',
        '52165' => 'IA',
        '52166' => 'IA',
        '52168' => 'IA',
        '52169' => 'IA',
        '52170' => 'IA',
        '52171' => 'IA',
        '52172' => 'IA',
        '52175' => 'IA',
        '52201' => 'IA',
        '52202' => 'IA',
        '52203' => 'IA',
        '52205' => 'IA',
        '52206' => 'IA',
        '52207' => 'IA',
        '52208' => 'IA',
        '52209' => 'IA',
        '52210' => 'IA',
        '52211' => 'IA',
        '52212' => 'IA',
        '52213' => 'IA',
        '52214' => 'IA',
        '52215' => 'IA',
        '52216' => 'IA',
        '52217' => 'IA',
        '52218' => 'IA',
        '52219' => 'IA',
        '52220' => 'IA',
        '52221' => 'IA',
        '52222' => 'IA',
        '52223' => 'IA',
        '52224' => 'IA',
        '52225' => 'IA',
        '52227' => 'IA',
        '52228' => 'IA',
        '52229' => 'IA',
        '52231' => 'IA',
        '52232' => 'IA',
        '52233' => 'IA',
        '52235' => 'IA',
        '52236' => 'IA',
        '52237' => 'IA',
        '52240' => 'IA',
        '52241' => 'IA',
        '52242' => 'IA',
        '52245' => 'IA',
        '52246' => 'IA',
        '52247' => 'IA',
        '52248' => 'IA',
        '52249' => 'IA',
        '52251' => 'IA',
        '52252' => 'IA',
        '52253' => 'IA',
        '52254' => 'IA',
        '52255' => 'IA',
        '52257' => 'IA',
        '52301' => 'IA',
        '52302' => 'IA',
        '52305' => 'IA',
        '52306' => 'IA',
        '52307' => 'IA',
        '52308' => 'IA',
        '52309' => 'IA',
        '52310' => 'IA',
        '52312' => 'IA',
        '52313' => 'IA',
        '52314' => 'IA',
        '52315' => 'IA',
        '52316' => 'IA',
        '52317' => 'IA',
        '52318' => 'IA',
        '52320' => 'IA',
        '52321' => 'IA',
        '52322' => 'IA',
        '52323' => 'IA',
        '52324' => 'IA',
        '52325' => 'IA',
        '52326' => 'IA',
        '52327' => 'IA',
        '52328' => 'IA',
        '52329' => 'IA',
        '52330' => 'IA',
        '52332' => 'IA',
        '52333' => 'IA',
        '52334' => 'IA',
        '52335' => 'IA',
        '52336' => 'IA',
        '52337' => 'IA',
        '52338' => 'IA',
        '52339' => 'IA',
        '52340' => 'IA',
        '52341' => 'IA',
        '52342' => 'IA',
        '52344' => 'IA',
        '52345' => 'IA',
        '52346' => 'IA',
        '52347' => 'IA',
        '52348' => 'IA',
        '52349' => 'IA',
        '52351' => 'IA',
        '52352' => 'IA',
        '52353' => 'IA',
        '52354' => 'IA',
        '52355' => 'IA',
        '52356' => 'IA',
        '52358' => 'IA',
        '52359' => 'IA',
        '52361' => 'IA',
        '52362' => 'IA',
        '52401' => 'IA',
        '52402' => 'IA',
        '52403' => 'IA',
        '52404' => 'IA',
        '52405' => 'IA',
        '52411' => 'IA',
        '52501' => 'IA',
        '52530' => 'IA',
        '52531' => 'IA',
        '52533' => 'IA',
        '52534' => 'IA',
        '52535' => 'IA',
        '52536' => 'IA',
        '52537' => 'IA',
        '52540' => 'IA',
        '52542' => 'IA',
        '52543' => 'IA',
        '52544' => 'IA',
        '52548' => 'IA',
        '52549' => 'IA',
        '52550' => 'IA',
        '52551' => 'IA',
        '52552' => 'IA',
        '52553' => 'IA',
        '52554' => 'IA',
        '52555' => 'IA',
        '52556' => 'IA',
        '52557' => 'IA',
        '52560' => 'IA',
        '52561' => 'IA',
        '52562' => 'IA',
        '52563' => 'IA',
        '52565' => 'IA',
        '52566' => 'IA',
        '52567' => 'IA',
        '52568' => 'IA',
        '52569' => 'IA',
        '52570' => 'IA',
        '52571' => 'IA',
        '52572' => 'IA',
        '52573' => 'IA',
        '52574' => 'IA',
        '52576' => 'IA',
        '52577' => 'IA',
        '52580' => 'IA',
        '52581' => 'IA',
        '52583' => 'IA',
        '52584' => 'IA',
        '52585' => 'IA',
        '52586' => 'IA',
        '52588' => 'IA',
        '52590' => 'IA',
        '52591' => 'IA',
        '52593' => 'IA',
        '52594' => 'IA',
        '52595' => 'IA',
        '52601' => 'IA',
        '52619' => 'IA',
        '52620' => 'IA',
        '52621' => 'IA',
        '52623' => 'IA',
        '52624' => 'IA',
        '52625' => 'IA',
        '52626' => 'IA',
        '52627' => 'IA',
        '52630' => 'IA',
        '52631' => 'IA',
        '52632' => 'IA',
        '52635' => 'IA',
        '52637' => 'IA',
        '52638' => 'IA',
        '52639' => 'IA',
        '52640' => 'IA',
        '52641' => 'IA',
        '52644' => 'IA',
        '52645' => 'IA',
        '52646' => 'IA',
        '52647' => 'IA',
        '52649' => 'IA',
        '52650' => 'IA',
        '52651' => 'IA',
        '52652' => 'IA',
        '52653' => 'IA',
        '52654' => 'IA',
        '52655' => 'IA',
        '52656' => 'IA',
        '52657' => 'IA',
        '52658' => 'IA',
        '52659' => 'IA',
        '52660' => 'IA',
        '52701' => 'IA',
        '52720' => 'IA',
        '52721' => 'IA',
        '52722' => 'IA',
        '52726' => 'IA',
        '52727' => 'IA',
        '52728' => 'IA',
        '52729' => 'IA',
        '52730' => 'IA',
        '52731' => 'IA',
        '52732' => 'IA',
        '52737' => 'IA',
        '52738' => 'IA',
        '52739' => 'IA',
        '52742' => 'IA',
        '52745' => 'IA',
        '52746' => 'IA',
        '52747' => 'IA',
        '52748' => 'IA',
        '52749' => 'IA',
        '52750' => 'IA',
        '52751' => 'IA',
        '52752' => 'IA',
        '52753' => 'IA',
        '52754' => 'IA',
        '52755' => 'IA',
        '52756' => 'IA',
        '52757' => 'IA',
        '52758' => 'IA',
        '52759' => 'IA',
        '52760' => 'IA',
        '52761' => 'IA',
        '52765' => 'IA',
        '52766' => 'IA',
        '52767' => 'IA',
        '52768' => 'IA',
        '52769' => 'IA',
        '52771' => 'IA',
        '52772' => 'IA',
        '52773' => 'IA',
        '52774' => 'IA',
        '52776' => 'IA',
        '52777' => 'IA',
        '52778' => 'IA',
        '52801' => 'IA',
        '52802' => 'IA',
        '52803' => 'IA',
        '52804' => 'IA',
        '52806' => 'IA',
        '52807' => 'IA',
        '53001' => 'WI',
        '53002' => 'WI',
        '53003' => 'WI',
        '53004' => 'WI',
        '53005' => 'WI',
        '53006' => 'WI',
        '53007' => 'WI',
        '53010' => 'WI',
        '53011' => 'WI',
        '53012' => 'WI',
        '53013' => 'WI',
        '53014' => 'WI',
        '53015' => 'WI',
        '53016' => 'WI',
        '53017' => 'WI',
        '53018' => 'WI',
        '53019' => 'WI',
        '53020' => 'WI',
        '53021' => 'WI',
        '53022' => 'WI',
        '53023' => 'WI',
        '53024' => 'WI',
        '53027' => 'WI',
        '53029' => 'WI',
        '53031' => 'WI',
        '53032' => 'WI',
        '53033' => 'WI',
        '53034' => 'WI',
        '53035' => 'WI',
        '53036' => 'WI',
        '53037' => 'WI',
        '53038' => 'WI',
        '53039' => 'WI',
        '53040' => 'WI',
        '53042' => 'WI',
        '53044' => 'WI',
        '53045' => 'WI',
        '53046' => 'WI',
        '53047' => 'WI',
        '53048' => 'WI',
        '53049' => 'WI',
        '53050' => 'WI',
        '53051' => 'WI',
        '53057' => 'WI',
        '53058' => 'WI',
        '53059' => 'WI',
        '53061' => 'WI',
        '53063' => 'WI',
        '53065' => 'WI',
        '53066' => 'WI',
        '53069' => 'WI',
        '53070' => 'WI',
        '53072' => 'WI',
        '53073' => 'WI',
        '53074' => 'WI',
        '53075' => 'WI',
        '53076' => 'WI',
        '53078' => 'WI',
        '53079' => 'WI',
        '53080' => 'WI',
        '53081' => 'WI',
        '53083' => 'WI',
        '53085' => 'WI',
        '53086' => 'WI',
        '53088' => 'WI',
        '53089' => 'WI',
        '53090' => 'WI',
        '53091' => 'WI',
        '53092' => 'WI',
        '53093' => 'WI',
        '53094' => 'WI',
        '53095' => 'WI',
        '53097' => 'WI',
        '53098' => 'WI',
        '53099' => 'WI',
        '53103' => 'WI',
        '53104' => 'WI',
        '53105' => 'WI',
        '53108' => 'WI',
        '53110' => 'WI',
        '53114' => 'WI',
        '53115' => 'WI',
        '53118' => 'WI',
        '53119' => 'WI',
        '53120' => 'WI',
        '53121' => 'WI',
        '53122' => 'WI',
        '53125' => 'WI',
        '53126' => 'WI',
        '53127' => 'WI',
        '53128' => 'WI',
        '53129' => 'WI',
        '53130' => 'WI',
        '53132' => 'WI',
        '53137' => 'WI',
        '53139' => 'WI',
        '53140' => 'WI',
        '53142' => 'WI',
        '53143' => 'WI',
        '53144' => 'WI',
        '53146' => 'WI',
        '53147' => 'WI',
        '53149' => 'WI',
        '53150' => 'WI',
        '53151' => 'WI',
        '53153' => 'WI',
        '53154' => 'WI',
        '53156' => 'WI',
        '53157' => 'WI',
        '53158' => 'WI',
        '53167' => 'WI',
        '53168' => 'WI',
        '53170' => 'WI',
        '53172' => 'WI',
        '53176' => 'WI',
        '53177' => 'WI',
        '53178' => 'WI',
        '53179' => 'WI',
        '53181' => 'WI',
        '53182' => 'WI',
        '53183' => 'WI',
        '53184' => 'WI',
        '53185' => 'WI',
        '53186' => 'WI',
        '53188' => 'WI',
        '53189' => 'WI',
        '53190' => 'WI',
        '53191' => 'WI',
        '53192' => 'WI',
        '53195' => 'WI',
        '53202' => 'WI',
        '53203' => 'WI',
        '53204' => 'WI',
        '53205' => 'WI',
        '53206' => 'WI',
        '53207' => 'WI',
        '53208' => 'WI',
        '53209' => 'WI',
        '53210' => 'WI',
        '53211' => 'WI',
        '53212' => 'WI',
        '53213' => 'WI',
        '53214' => 'WI',
        '53215' => 'WI',
        '53216' => 'WI',
        '53217' => 'WI',
        '53218' => 'WI',
        '53219' => 'WI',
        '53220' => 'WI',
        '53221' => 'WI',
        '53222' => 'WI',
        '53223' => 'WI',
        '53224' => 'WI',
        '53225' => 'WI',
        '53226' => 'WI',
        '53227' => 'WI',
        '53228' => 'WI',
        '53233' => 'WI',
        '53235' => 'WI',
        '53295' => 'WI',
        '53402' => 'WI',
        '53403' => 'WI',
        '53404' => 'WI',
        '53405' => 'WI',
        '53406' => 'WI',
        '53501' => 'WI',
        '53502' => 'WI',
        '53503' => 'WI',
        '53504' => 'WI',
        '53505' => 'WI',
        '53506' => 'WI',
        '53507' => 'WI',
        '53508' => 'WI',
        '53510' => 'WI',
        '53511' => 'WI',
        '53515' => 'WI',
        '53516' => 'WI',
        '53517' => 'WI',
        '53518' => 'WI',
        '53520' => 'WI',
        '53521' => 'WI',
        '53522' => 'WI',
        '53523' => 'WI',
        '53525' => 'WI',
        '53526' => 'WI',
        '53527' => 'WI',
        '53528' => 'WI',
        '53529' => 'WI',
        '53530' => 'WI',
        '53531' => 'WI',
        '53532' => 'WI',
        '53533' => 'WI',
        '53534' => 'WI',
        '53536' => 'WI',
        '53537' => 'WI',
        '53538' => 'WI',
        '53540' => 'WI',
        '53541' => 'WI',
        '53543' => 'WI',
        '53544' => 'WI',
        '53545' => 'WI',
        '53546' => 'WI',
        '53548' => 'WI',
        '53549' => 'WI',
        '53550' => 'WI',
        '53551' => 'WI',
        '53553' => 'WI',
        '53554' => 'WI',
        '53555' => 'WI',
        '53556' => 'WI',
        '53557' => 'WI',
        '53558' => 'WI',
        '53559' => 'WI',
        '53560' => 'WI',
        '53561' => 'WI',
        '53562' => 'WI',
        '53563' => 'WI',
        '53565' => 'WI',
        '53566' => 'WI',
        '53569' => 'WI',
        '53570' => 'WI',
        '53571' => 'WI',
        '53572' => 'WI',
        '53573' => 'WI',
        '53574' => 'WI',
        '53575' => 'WI',
        '53576' => 'WI',
        '53577' => 'WI',
        '53578' => 'WI',
        '53579' => 'WI',
        '53580' => 'WI',
        '53581' => 'WI',
        '53582' => 'WI',
        '53583' => 'WI',
        '53584' => 'WI',
        '53585' => 'WI',
        '53586' => 'WI',
        '53587' => 'WI',
        '53588' => 'WI',
        '53589' => 'WI',
        '53590' => 'WI',
        '53593' => 'WI',
        '53594' => 'WI',
        '53597' => 'WI',
        '53598' => 'WI',
        '53599' => 'WI',
        '53703' => 'WI',
        '53704' => 'WI',
        '53705' => 'WI',
        '53706' => 'WI',
        '53711' => 'WI',
        '53713' => 'WI',
        '53714' => 'WI',
        '53715' => 'WI',
        '53716' => 'WI',
        '53717' => 'WI',
        '53718' => 'WI',
        '53719' => 'WI',
        '53726' => 'WI',
        '53792' => 'WI',
        '53801' => 'WI',
        '53802' => 'WI',
        '53803' => 'WI',
        '53804' => 'WI',
        '53805' => 'WI',
        '53806' => 'WI',
        '53807' => 'WI',
        '53808' => 'WI',
        '53809' => 'WI',
        '53810' => 'WI',
        '53811' => 'WI',
        '53812' => 'WI',
        '53813' => 'WI',
        '53816' => 'WI',
        '53817' => 'WI',
        '53818' => 'WI',
        '53820' => 'WI',
        '53821' => 'WI',
        '53825' => 'WI',
        '53826' => 'WI',
        '53827' => 'WI',
        '53901' => 'WI',
        '53910' => 'WI',
        '53911' => 'WI',
        '53913' => 'WI',
        '53916' => 'WI',
        '53919' => 'WI',
        '53920' => 'WI',
        '53922' => 'WI',
        '53923' => 'WI',
        '53924' => 'WI',
        '53925' => 'WI',
        '53926' => 'WI',
        '53928' => 'WI',
        '53929' => 'WI',
        '53930' => 'WI',
        '53931' => 'WI',
        '53932' => 'WI',
        '53933' => 'WI',
        '53934' => 'WI',
        '53935' => 'WI',
        '53936' => 'WI',
        '53937' => 'WI',
        '53939' => 'WI',
        '53940' => 'WI',
        '53941' => 'WI',
        '53942' => 'WI',
        '53943' => 'WI',
        '53944' => 'WI',
        '53946' => 'WI',
        '53947' => 'WI',
        '53948' => 'WI',
        '53949' => 'WI',
        '53950' => 'WI',
        '53951' => 'WI',
        '53952' => 'WI',
        '53953' => 'WI',
        '53954' => 'WI',
        '53955' => 'WI',
        '53956' => 'WI',
        '53959' => 'WI',
        '53960' => 'WI',
        '53961' => 'WI',
        '53962' => 'WI',
        '53963' => 'WI',
        '53964' => 'WI',
        '53965' => 'WI',
        '53968' => 'WI',
        '53969' => 'WI',
        '54001' => 'WI',
        '54002' => 'WI',
        '54003' => 'WI',
        '54004' => 'WI',
        '54005' => 'WI',
        '54006' => 'WI',
        '54007' => 'WI',
        '54009' => 'WI',
        '54011' => 'WI',
        '54013' => 'WI',
        '54014' => 'WI',
        '54015' => 'WI',
        '54016' => 'WI',
        '54017' => 'WI',
        '54020' => 'WI',
        '54021' => 'WI',
        '54022' => 'WI',
        '54023' => 'WI',
        '54024' => 'WI',
        '54025' => 'WI',
        '54026' => 'WI',
        '54027' => 'WI',
        '54028' => 'WI',
        '54082' => 'WI',
        '54101' => 'WI',
        '54102' => 'WI',
        '54103' => 'WI',
        '54104' => 'WI',
        '54106' => 'WI',
        '54107' => 'WI',
        '54110' => 'WI',
        '54111' => 'WI',
        '54112' => 'WI',
        '54113' => 'WI',
        '54114' => 'WI',
        '54115' => 'WI',
        '54119' => 'WI',
        '54120' => 'WI',
        '54121' => 'WI',
        '54123' => 'WI',
        '54124' => 'WI',
        '54125' => 'WI',
        '54126' => 'WI',
        '54127' => 'WI',
        '54128' => 'WI',
        '54129' => 'WI',
        '54130' => 'WI',
        '54135' => 'WI',
        '54136' => 'WI',
        '54137' => 'WI',
        '54138' => 'WI',
        '54139' => 'WI',
        '54140' => 'WI',
        '54141' => 'WI',
        '54143' => 'WI',
        '54149' => 'WI',
        '54150' => 'WI',
        '54151' => 'WI',
        '54152' => 'WI',
        '54153' => 'WI',
        '54154' => 'WI',
        '54155' => 'WI',
        '54156' => 'WI',
        '54157' => 'WI',
        '54159' => 'WI',
        '54160' => 'WI',
        '54161' => 'WI',
        '54162' => 'WI',
        '54165' => 'WI',
        '54166' => 'WI',
        '54169' => 'WI',
        '54170' => 'WI',
        '54171' => 'WI',
        '54173' => 'WI',
        '54174' => 'WI',
        '54175' => 'WI',
        '54177' => 'WI',
        '54180' => 'WI',
        '54201' => 'WI',
        '54202' => 'WI',
        '54204' => 'WI',
        '54205' => 'WI',
        '54207' => 'WI',
        '54208' => 'WI',
        '54209' => 'WI',
        '54210' => 'WI',
        '54211' => 'WI',
        '54212' => 'WI',
        '54213' => 'WI',
        '54214' => 'WI',
        '54215' => 'WI',
        '54216' => 'WI',
        '54217' => 'WI',
        '54220' => 'WI',
        '54227' => 'WI',
        '54228' => 'WI',
        '54229' => 'WI',
        '54230' => 'WI',
        '54232' => 'WI',
        '54234' => 'WI',
        '54235' => 'WI',
        '54241' => 'WI',
        '54245' => 'WI',
        '54246' => 'WI',
        '54247' => 'WI',
        '54301' => 'WI',
        '54302' => 'WI',
        '54303' => 'WI',
        '54304' => 'WI',
        '54307' => 'WI',
        '54311' => 'WI',
        '54313' => 'WI',
        '54401' => 'WI',
        '54403' => 'WI',
        '54405' => 'WI',
        '54406' => 'WI',
        '54407' => 'WI',
        '54408' => 'WI',
        '54409' => 'WI',
        '54410' => 'WI',
        '54411' => 'WI',
        '54412' => 'WI',
        '54413' => 'WI',
        '54414' => 'WI',
        '54416' => 'WI',
        '54417' => 'WI',
        '54418' => 'WI',
        '54420' => 'WI',
        '54421' => 'WI',
        '54422' => 'WI',
        '54423' => 'WI',
        '54424' => 'WI',
        '54425' => 'WI',
        '54426' => 'WI',
        '54427' => 'WI',
        '54428' => 'WI',
        '54430' => 'WI',
        '54433' => 'WI',
        '54435' => 'WI',
        '54436' => 'WI',
        '54437' => 'WI',
        '54440' => 'WI',
        '54441' => 'WI',
        '54442' => 'WI',
        '54443' => 'WI',
        '54446' => 'WI',
        '54447' => 'WI',
        '54448' => 'WI',
        '54449' => 'WI',
        '54450' => 'WI',
        '54451' => 'WI',
        '54452' => 'WI',
        '54454' => 'WI',
        '54455' => 'WI',
        '54456' => 'WI',
        '54457' => 'WI',
        '54458' => 'WI',
        '54459' => 'WI',
        '54460' => 'WI',
        '54462' => 'WI',
        '54463' => 'WI',
        '54464' => 'WI',
        '54465' => 'WI',
        '54466' => 'WI',
        '54467' => 'WI',
        '54469' => 'WI',
        '54470' => 'WI',
        '54471' => 'WI',
        '54473' => 'WI',
        '54474' => 'WI',
        '54475' => 'WI',
        '54476' => 'WI',
        '54479' => 'WI',
        '54480' => 'WI',
        '54481' => 'WI',
        '54482' => 'WI',
        '54484' => 'WI',
        '54485' => 'WI',
        '54486' => 'WI',
        '54487' => 'WI',
        '54488' => 'WI',
        '54489' => 'WI',
        '54490' => 'WI',
        '54491' => 'WI',
        '54493' => 'WI',
        '54494' => 'WI',
        '54495' => 'WI',
        '54498' => 'WI',
        '54499' => 'WI',
        '54501' => 'WI',
        '54511' => 'WI',
        '54512' => 'WI',
        '54513' => 'WI',
        '54514' => 'WI',
        '54515' => 'WI',
        '54517' => 'WI',
        '54519' => 'WI',
        '54520' => 'WI',
        '54521' => 'WI',
        '54524' => 'WI',
        '54525' => 'WI',
        '54526' => 'WI',
        '54527' => 'WI',
        '54529' => 'WI',
        '54530' => 'WI',
        '54531' => 'WI',
        '54534' => 'WI',
        '54536' => 'WI',
        '54537' => 'WI',
        '54538' => 'WI',
        '54539' => 'WI',
        '54540' => 'WI',
        '54541' => 'WI',
        '54542' => 'WI',
        '54545' => 'WI',
        '54546' => 'WI',
        '54547' => 'WI',
        '54548' => 'WI',
        '54550' => 'WI',
        '54552' => 'WI',
        '54554' => 'WI',
        '54555' => 'WI',
        '54556' => 'WI',
        '54557' => 'WI',
        '54558' => 'WI',
        '54559' => 'WI',
        '54560' => 'WI',
        '54561' => 'WI',
        '54562' => 'WI',
        '54563' => 'WI',
        '54564' => 'WI',
        '54565' => 'WI',
        '54566' => 'WI',
        '54568' => 'WI',
        '54601' => 'WI',
        '54603' => 'WI',
        '54610' => 'WI',
        '54611' => 'WI',
        '54612' => 'WI',
        '54613' => 'WI',
        '54614' => 'WI',
        '54615' => 'WI',
        '54616' => 'WI',
        '54618' => 'WI',
        '54619' => 'WI',
        '54621' => 'WI',
        '54622' => 'WI',
        '54623' => 'WI',
        '54624' => 'WI',
        '54625' => 'WI',
        '54626' => 'WI',
        '54627' => 'WI',
        '54628' => 'WI',
        '54629' => 'WI',
        '54630' => 'WI',
        '54631' => 'WI',
        '54632' => 'WI',
        '54634' => 'WI',
        '54635' => 'WI',
        '54636' => 'WI',
        '54637' => 'WI',
        '54638' => 'WI',
        '54639' => 'WI',
        '54642' => 'WI',
        '54643' => 'WI',
        '54644' => 'WI',
        '54645' => 'WI',
        '54646' => 'WI',
        '54648' => 'WI',
        '54650' => 'WI',
        '54651' => 'WI',
        '54652' => 'WI',
        '54653' => 'WI',
        '54654' => 'WI',
        '54655' => 'WI',
        '54656' => 'WI',
        '54657' => 'WI',
        '54658' => 'WI',
        '54659' => 'WI',
        '54660' => 'WI',
        '54661' => 'WI',
        '54664' => 'WI',
        '54665' => 'WI',
        '54666' => 'WI',
        '54667' => 'WI',
        '54669' => 'WI',
        '54670' => 'WI',
        '54701' => 'WI',
        '54703' => 'WI',
        '54720' => 'WI',
        '54721' => 'WI',
        '54722' => 'WI',
        '54723' => 'WI',
        '54724' => 'WI',
        '54725' => 'WI',
        '54726' => 'WI',
        '54727' => 'WI',
        '54728' => 'WI',
        '54729' => 'WI',
        '54730' => 'WI',
        '54731' => 'WI',
        '54732' => 'WI',
        '54733' => 'WI',
        '54734' => 'WI',
        '54736' => 'WI',
        '54737' => 'WI',
        '54738' => 'WI',
        '54739' => 'WI',
        '54740' => 'WI',
        '54741' => 'WI',
        '54742' => 'WI',
        '54745' => 'WI',
        '54746' => 'WI',
        '54747' => 'WI',
        '54748' => 'WI',
        '54749' => 'WI',
        '54750' => 'WI',
        '54751' => 'WI',
        '54754' => 'WI',
        '54755' => 'WI',
        '54756' => 'WI',
        '54757' => 'WI',
        '54758' => 'WI',
        '54759' => 'WI',
        '54760' => 'WI',
        '54761' => 'WI',
        '54762' => 'WI',
        '54763' => 'WI',
        '54766' => 'WI',
        '54767' => 'WI',
        '54768' => 'WI',
        '54769' => 'WI',
        '54770' => 'WI',
        '54771' => 'WI',
        '54772' => 'WI',
        '54773' => 'WI',
        '54801' => 'WI',
        '54805' => 'WI',
        '54806' => 'WI',
        '54810' => 'WI',
        '54812' => 'WI',
        '54813' => 'WI',
        '54814' => 'WI',
        '54817' => 'WI',
        '54819' => 'WI',
        '54820' => 'WI',
        '54821' => 'WI',
        '54822' => 'WI',
        '54824' => 'WI',
        '54826' => 'WI',
        '54827' => 'WI',
        '54828' => 'WI',
        '54829' => 'WI',
        '54830' => 'WI',
        '54832' => 'WI',
        '54835' => 'WI',
        '54836' => 'WI',
        '54837' => 'WI',
        '54838' => 'WI',
        '54839' => 'WI',
        '54840' => 'WI',
        '54841' => 'WI',
        '54842' => 'WI',
        '54843' => 'WI',
        '54844' => 'WI',
        '54845' => 'WI',
        '54846' => 'WI',
        '54847' => 'WI',
        '54848' => 'WI',
        '54849' => 'WI',
        '54850' => 'WI',
        '54853' => 'WI',
        '54854' => 'WI',
        '54855' => 'WI',
        '54856' => 'WI',
        '54857' => 'WI',
        '54858' => 'WI',
        '54859' => 'WI',
        '54861' => 'WI',
        '54862' => 'WI',
        '54864' => 'WI',
        '54865' => 'WI',
        '54867' => 'WI',
        '54868' => 'WI',
        '54870' => 'WI',
        '54871' => 'WI',
        '54872' => 'WI',
        '54873' => 'WI',
        '54874' => 'WI',
        '54875' => 'WI',
        '54876' => 'WI',
        '54880' => 'WI',
        '54888' => 'WI',
        '54889' => 'WI',
        '54891' => 'WI',
        '54893' => 'WI',
        '54895' => 'WI',
        '54896' => 'WI',
        '54901' => 'WI',
        '54902' => 'WI',
        '54904' => 'WI',
        '54909' => 'WI',
        '54911' => 'WI',
        '54913' => 'WI',
        '54914' => 'WI',
        '54915' => 'WI',
        '54921' => 'WI',
        '54922' => 'WI',
        '54923' => 'WI',
        '54926' => 'WI',
        '54927' => 'WI',
        '54928' => 'WI',
        '54929' => 'WI',
        '54930' => 'WI',
        '54931' => 'WI',
        '54932' => 'WI',
        '54933' => 'WI',
        '54935' => 'WI',
        '54937' => 'WI',
        '54940' => 'WI',
        '54941' => 'WI',
        '54942' => 'WI',
        '54943' => 'WI',
        '54944' => 'WI',
        '54945' => 'WI',
        '54946' => 'WI',
        '54947' => 'WI',
        '54948' => 'WI',
        '54949' => 'WI',
        '54950' => 'WI',
        '54952' => 'WI',
        '54956' => 'WI',
        '54960' => 'WI',
        '54961' => 'WI',
        '54962' => 'WI',
        '54963' => 'WI',
        '54964' => 'WI',
        '54965' => 'WI',
        '54966' => 'WI',
        '54967' => 'WI',
        '54968' => 'WI',
        '54970' => 'WI',
        '54971' => 'WI',
        '54974' => 'WI',
        '54977' => 'WI',
        '54978' => 'WI',
        '54979' => 'WI',
        '54980' => 'WI',
        '54981' => 'WI',
        '54982' => 'WI',
        '54983' => 'WI',
        '54984' => 'WI',
        '54985' => 'WI',
        '54986' => 'WI',
        '55001' => 'MN',
        '55003' => 'MN',
        '55005' => 'MN',
        '55006' => 'MN',
        '55007' => 'MN',
        '55008' => 'MN',
        '55009' => 'MN',
        '55011' => 'MN',
        '55012' => 'MN',
        '55013' => 'MN',
        '55014' => 'MN',
        '55016' => 'MN',
        '55017' => 'MN',
        '55018' => 'MN',
        '55019' => 'MN',
        '55020' => 'MN',
        '55021' => 'MN',
        '55024' => 'MN',
        '55025' => 'MN',
        '55026' => 'MN',
        '55027' => 'MN',
        '55029' => 'MN',
        '55030' => 'MN',
        '55031' => 'MN',
        '55032' => 'MN',
        '55033' => 'MN',
        '55036' => 'MN',
        '55037' => 'MN',
        '55038' => 'MN',
        '55040' => 'MN',
        '55041' => 'MN',
        '55042' => 'MN',
        '55043' => 'MN',
        '55044' => 'MN',
        '55045' => 'MN',
        '55046' => 'MN',
        '55047' => 'MN',
        '55049' => 'MN',
        '55051' => 'MN',
        '55052' => 'MN',
        '55053' => 'MN',
        '55054' => 'MN',
        '55055' => 'MN',
        '55056' => 'MN',
        '55057' => 'MN',
        '55060' => 'MN',
        '55063' => 'MN',
        '55065' => 'MN',
        '55066' => 'MN',
        '55068' => 'MN',
        '55069' => 'MN',
        '55070' => 'MN',
        '55071' => 'MN',
        '55072' => 'MN',
        '55073' => 'MN',
        '55074' => 'MN',
        '55075' => 'MN',
        '55076' => 'MN',
        '55077' => 'MN',
        '55079' => 'MN',
        '55080' => 'MN',
        '55082' => 'MN',
        '55084' => 'MN',
        '55085' => 'MN',
        '55087' => 'MN',
        '55088' => 'MN',
        '55089' => 'MN',
        '55090' => 'MN',
        '55092' => 'MN',
        '55101' => 'MN',
        '55102' => 'MN',
        '55103' => 'MN',
        '55104' => 'MN',
        '55105' => 'MN',
        '55106' => 'MN',
        '55107' => 'MN',
        '55108' => 'MN',
        '55109' => 'MN',
        '55110' => 'MN',
        '55111' => 'MN',
        '55112' => 'MN',
        '55113' => 'MN',
        '55114' => 'MN',
        '55115' => 'MN',
        '55116' => 'MN',
        '55117' => 'MN',
        '55118' => 'MN',
        '55119' => 'MN',
        '55120' => 'MN',
        '55121' => 'MN',
        '55122' => 'MN',
        '55123' => 'MN',
        '55124' => 'MN',
        '55125' => 'MN',
        '55126' => 'MN',
        '55127' => 'MN',
        '55128' => 'MN',
        '55129' => 'MN',
        '55130' => 'MN',
        '55150' => 'MN',
        '55155' => 'MN',
        '55301' => 'MN',
        '55302' => 'MN',
        '55303' => 'MN',
        '55304' => 'MN',
        '55305' => 'MN',
        '55306' => 'MN',
        '55307' => 'MN',
        '55308' => 'MN',
        '55309' => 'MN',
        '55310' => 'MN',
        '55311' => 'MN',
        '55312' => 'MN',
        '55313' => 'MN',
        '55314' => 'MN',
        '55315' => 'MN',
        '55316' => 'MN',
        '55317' => 'MN',
        '55318' => 'MN',
        '55319' => 'MN',
        '55320' => 'MN',
        '55321' => 'MN',
        '55322' => 'MN',
        '55324' => 'MN',
        '55325' => 'MN',
        '55327' => 'MN',
        '55328' => 'MN',
        '55329' => 'MN',
        '55330' => 'MN',
        '55331' => 'MN',
        '55332' => 'MN',
        '55333' => 'MN',
        '55334' => 'MN',
        '55335' => 'MN',
        '55336' => 'MN',
        '55337' => 'MN',
        '55338' => 'MN',
        '55339' => 'MN',
        '55340' => 'MN',
        '55341' => 'MN',
        '55342' => 'MN',
        '55343' => 'MN',
        '55344' => 'MN',
        '55345' => 'MN',
        '55346' => 'MN',
        '55347' => 'MN',
        '55349' => 'MN',
        '55350' => 'MN',
        '55352' => 'MN',
        '55353' => 'MN',
        '55354' => 'MN',
        '55355' => 'MN',
        '55356' => 'MN',
        '55357' => 'MN',
        '55358' => 'MN',
        '55359' => 'MN',
        '55360' => 'MN',
        '55362' => 'MN',
        '55363' => 'MN',
        '55364' => 'MN',
        '55366' => 'MN',
        '55367' => 'MN',
        '55368' => 'MN',
        '55369' => 'MN',
        '55370' => 'MN',
        '55371' => 'MN',
        '55372' => 'MN',
        '55373' => 'MN',
        '55374' => 'MN',
        '55375' => 'MN',
        '55376' => 'MN',
        '55378' => 'MN',
        '55379' => 'MN',
        '55381' => 'MN',
        '55382' => 'MN',
        '55384' => 'MN',
        '55385' => 'MN',
        '55386' => 'MN',
        '55387' => 'MN',
        '55388' => 'MN',
        '55389' => 'MN',
        '55390' => 'MN',
        '55391' => 'MN',
        '55395' => 'MN',
        '55396' => 'MN',
        '55397' => 'MN',
        '55398' => 'MN',
        '55401' => 'MN',
        '55402' => 'MN',
        '55403' => 'MN',
        '55404' => 'MN',
        '55405' => 'MN',
        '55406' => 'MN',
        '55407' => 'MN',
        '55408' => 'MN',
        '55409' => 'MN',
        '55410' => 'MN',
        '55411' => 'MN',
        '55412' => 'MN',
        '55413' => 'MN',
        '55414' => 'MN',
        '55415' => 'MN',
        '55416' => 'MN',
        '55417' => 'MN',
        '55418' => 'MN',
        '55419' => 'MN',
        '55420' => 'MN',
        '55421' => 'MN',
        '55422' => 'MN',
        '55423' => 'MN',
        '55424' => 'MN',
        '55425' => 'MN',
        '55426' => 'MN',
        '55427' => 'MN',
        '55428' => 'MN',
        '55429' => 'MN',
        '55430' => 'MN',
        '55431' => 'MN',
        '55432' => 'MN',
        '55433' => 'MN',
        '55434' => 'MN',
        '55435' => 'MN',
        '55436' => 'MN',
        '55437' => 'MN',
        '55438' => 'MN',
        '55439' => 'MN',
        '55441' => 'MN',
        '55442' => 'MN',
        '55443' => 'MN',
        '55444' => 'MN',
        '55445' => 'MN',
        '55446' => 'MN',
        '55447' => 'MN',
        '55448' => 'MN',
        '55449' => 'MN',
        '55450' => 'MN',
        '55454' => 'MN',
        '55455' => 'MN',
        '55601' => 'MN',
        '55602' => 'MN',
        '55603' => 'MN',
        '55604' => 'MN',
        '55605' => 'MN',
        '55606' => 'MN',
        '55607' => 'MN',
        '55609' => 'MN',
        '55612' => 'MN',
        '55613' => 'MN',
        '55614' => 'MN',
        '55615' => 'MN',
        '55616' => 'MN',
        '55702' => 'MN',
        '55703' => 'MN',
        '55704' => 'MN',
        '55705' => 'MN',
        '55706' => 'MN',
        '55707' => 'MN',
        '55708' => 'MN',
        '55709' => 'MN',
        '55710' => 'MN',
        '55711' => 'MN',
        '55712' => 'MN',
        '55713' => 'MN',
        '55716' => 'MN',
        '55717' => 'MN',
        '55718' => 'MN',
        '55719' => 'MN',
        '55720' => 'MN',
        '55721' => 'MN',
        '55722' => 'MN',
        '55723' => 'MN',
        '55724' => 'MN',
        '55725' => 'MN',
        '55726' => 'MN',
        '55731' => 'MN',
        '55732' => 'MN',
        '55733' => 'MN',
        '55734' => 'MN',
        '55735' => 'MN',
        '55736' => 'MN',
        '55738' => 'MN',
        '55741' => 'MN',
        '55742' => 'MN',
        '55744' => 'MN',
        '55746' => 'MN',
        '55748' => 'MN',
        '55749' => 'MN',
        '55750' => 'MN',
        '55751' => 'MN',
        '55752' => 'MN',
        '55753' => 'MN',
        '55756' => 'MN',
        '55757' => 'MN',
        '55758' => 'MN',
        '55760' => 'MN',
        '55763' => 'MN',
        '55764' => 'MN',
        '55765' => 'MN',
        '55767' => 'MN',
        '55768' => 'MN',
        '55769' => 'MN',
        '55771' => 'MN',
        '55772' => 'MN',
        '55775' => 'MN',
        '55779' => 'MN',
        '55780' => 'MN',
        '55781' => 'MN',
        '55782' => 'MN',
        '55783' => 'MN',
        '55784' => 'MN',
        '55785' => 'MN',
        '55786' => 'MN',
        '55787' => 'MN',
        '55790' => 'MN',
        '55792' => 'MN',
        '55793' => 'MN',
        '55795' => 'MN',
        '55796' => 'MN',
        '55797' => 'MN',
        '55798' => 'MN',
        '55802' => 'MN',
        '55803' => 'MN',
        '55804' => 'MN',
        '55805' => 'MN',
        '55806' => 'MN',
        '55807' => 'MN',
        '55808' => 'MN',
        '55810' => 'MN',
        '55811' => 'MN',
        '55812' => 'MN',
        '55814' => 'MN',
        '55901' => 'MN',
        '55902' => 'MN',
        '55903' => 'MN',
        '55904' => 'MN',
        '55905' => 'MN',
        '55906' => 'MN',
        '55909' => 'MN',
        '55910' => 'MN',
        '55912' => 'MN',
        '55917' => 'MN',
        '55918' => 'MN',
        '55919' => 'MN',
        '55920' => 'MN',
        '55921' => 'MN',
        '55922' => 'MN',
        '55923' => 'MN',
        '55924' => 'MN',
        '55925' => 'MN',
        '55926' => 'MN',
        '55927' => 'MN',
        '55929' => 'MN',
        '55931' => 'MN',
        '55932' => 'MN',
        '55933' => 'MN',
        '55934' => 'MN',
        '55935' => 'MN',
        '55936' => 'MN',
        '55939' => 'MN',
        '55940' => 'MN',
        '55941' => 'MN',
        '55943' => 'MN',
        '55944' => 'MN',
        '55945' => 'MN',
        '55946' => 'MN',
        '55947' => 'MN',
        '55949' => 'MN',
        '55950' => 'MN',
        '55951' => 'MN',
        '55952' => 'MN',
        '55953' => 'MN',
        '55954' => 'MN',
        '55955' => 'MN',
        '55956' => 'MN',
        '55957' => 'MN',
        '55959' => 'MN',
        '55960' => 'MN',
        '55961' => 'MN',
        '55962' => 'MN',
        '55963' => 'MN',
        '55964' => 'MN',
        '55965' => 'MN',
        '55967' => 'MN',
        '55968' => 'MN',
        '55969' => 'MN',
        '55970' => 'MN',
        '55971' => 'MN',
        '55972' => 'MN',
        '55973' => 'MN',
        '55974' => 'MN',
        '55975' => 'MN',
        '55976' => 'MN',
        '55977' => 'MN',
        '55979' => 'MN',
        '55981' => 'MN',
        '55982' => 'MN',
        '55983' => 'MN',
        '55985' => 'MN',
        '55987' => 'MN',
        '55990' => 'MN',
        '55991' => 'MN',
        '55992' => 'MN',
        '56001' => 'MN',
        '56003' => 'MN',
        '56007' => 'MN',
        '56009' => 'MN',
        '56010' => 'MN',
        '56011' => 'MN',
        '56013' => 'MN',
        '56014' => 'MN',
        '56016' => 'MN',
        '56017' => 'MN',
        '56019' => 'MN',
        '56020' => 'MN',
        '56021' => 'MN',
        '56022' => 'MN',
        '56023' => 'MN',
        '56024' => 'MN',
        '56025' => 'MN',
        '56026' => 'MN',
        '56027' => 'MN',
        '56028' => 'MN',
        '56029' => 'MN',
        '56030' => 'MN',
        '56031' => 'MN',
        '56032' => 'MN',
        '56033' => 'MN',
        '56034' => 'MN',
        '56035' => 'MN',
        '56036' => 'MN',
        '56037' => 'MN',
        '56039' => 'MN',
        '56041' => 'MN',
        '56042' => 'MN',
        '56043' => 'MN',
        '56044' => 'MN',
        '56045' => 'MN',
        '56046' => 'MN',
        '56048' => 'MN',
        '56050' => 'MN',
        '56051' => 'MN',
        '56052' => 'MN',
        '56054' => 'MN',
        '56055' => 'MN',
        '56056' => 'MN',
        '56057' => 'MN',
        '56058' => 'MN',
        '56060' => 'MN',
        '56062' => 'MN',
        '56063' => 'MN',
        '56065' => 'MN',
        '56068' => 'MN',
        '56069' => 'MN',
        '56071' => 'MN',
        '56072' => 'MN',
        '56073' => 'MN',
        '56074' => 'MN',
        '56075' => 'MN',
        '56078' => 'MN',
        '56080' => 'MN',
        '56081' => 'MN',
        '56082' => 'MN',
        '56083' => 'MN',
        '56085' => 'MN',
        '56087' => 'MN',
        '56088' => 'MN',
        '56089' => 'MN',
        '56090' => 'MN',
        '56091' => 'MN',
        '56093' => 'MN',
        '56096' => 'MN',
        '56097' => 'MN',
        '56098' => 'MN',
        '56101' => 'MN',
        '56110' => 'MN',
        '56111' => 'MN',
        '56113' => 'MN',
        '56114' => 'MN',
        '56115' => 'MN',
        '56116' => 'MN',
        '56117' => 'MN',
        '56118' => 'MN',
        '56119' => 'MN',
        '56120' => 'MN',
        '56121' => 'MN',
        '56122' => 'MN',
        '56123' => 'MN',
        '56125' => 'MN',
        '56127' => 'MN',
        '56128' => 'MN',
        '56129' => 'MN',
        '56131' => 'MN',
        '56132' => 'MN',
        '56134' => 'MN',
        '56136' => 'MN',
        '56137' => 'MN',
        '56138' => 'MN',
        '56139' => 'MN',
        '56140' => 'MN',
        '56141' => 'MN',
        '56142' => 'MN',
        '56143' => 'MN',
        '56144' => 'MN',
        '56145' => 'MN',
        '56146' => 'MN',
        '56147' => 'MN',
        '56149' => 'MN',
        '56150' => 'MN',
        '56151' => 'MN',
        '56152' => 'MN',
        '56153' => 'MN',
        '56155' => 'MN',
        '56156' => 'MN',
        '56157' => 'MN',
        '56158' => 'MN',
        '56159' => 'MN',
        '56160' => 'MN',
        '56161' => 'MN',
        '56162' => 'MN',
        '56164' => 'MN',
        '56165' => 'MN',
        '56166' => 'MN',
        '56167' => 'MN',
        '56168' => 'MN',
        '56169' => 'MN',
        '56170' => 'MN',
        '56171' => 'MN',
        '56172' => 'MN',
        '56173' => 'MN',
        '56174' => 'MN',
        '56175' => 'MN',
        '56176' => 'MN',
        '56178' => 'MN',
        '56180' => 'MN',
        '56181' => 'MN',
        '56183' => 'MN',
        '56185' => 'MN',
        '56186' => 'MN',
        '56187' => 'MN',
        '56201' => 'MN',
        '56207' => 'MN',
        '56208' => 'MN',
        '56209' => 'MN',
        '56210' => 'MN',
        '56211' => 'MN',
        '56212' => 'MN',
        '56214' => 'MN',
        '56215' => 'MN',
        '56216' => 'MN',
        '56218' => 'MN',
        '56219' => 'MN',
        '56220' => 'MN',
        '56221' => 'MN',
        '56222' => 'MN',
        '56223' => 'MN',
        '56224' => 'MN',
        '56225' => 'MN',
        '56226' => 'MN',
        '56227' => 'MN',
        '56228' => 'MN',
        '56229' => 'MN',
        '56230' => 'MN',
        '56231' => 'MN',
        '56232' => 'MN',
        '56235' => 'MN',
        '56236' => 'MN',
        '56237' => 'MN',
        '56239' => 'MN',
        '56240' => 'MN',
        '56241' => 'MN',
        '56243' => 'MN',
        '56244' => 'MN',
        '56245' => 'MN',
        '56248' => 'MN',
        '56249' => 'MN',
        '56251' => 'MN',
        '56252' => 'MN',
        '56253' => 'MN',
        '56255' => 'MN',
        '56256' => 'MN',
        '56257' => 'MN',
        '56258' => 'MN',
        '56260' => 'MN',
        '56262' => 'MN',
        '56263' => 'MN',
        '56264' => 'MN',
        '56265' => 'MN',
        '56266' => 'MN',
        '56267' => 'MN',
        '56270' => 'MN',
        '56271' => 'MN',
        '56273' => 'MN',
        '56274' => 'MN',
        '56276' => 'MN',
        '56277' => 'MN',
        '56278' => 'MN',
        '56279' => 'MN',
        '56280' => 'MN',
        '56281' => 'MN',
        '56282' => 'MN',
        '56283' => 'MN',
        '56284' => 'MN',
        '56285' => 'MN',
        '56287' => 'MN',
        '56288' => 'MN',
        '56289' => 'MN',
        '56291' => 'MN',
        '56292' => 'MN',
        '56293' => 'MN',
        '56294' => 'MN',
        '56295' => 'MN',
        '56296' => 'MN',
        '56297' => 'MN',
        '56301' => 'MN',
        '56303' => 'MN',
        '56304' => 'MN',
        '56307' => 'MN',
        '56308' => 'MN',
        '56309' => 'MN',
        '56310' => 'MN',
        '56311' => 'MN',
        '56312' => 'MN',
        '56313' => 'MN',
        '56314' => 'MN',
        '56315' => 'MN',
        '56316' => 'MN',
        '56318' => 'MN',
        '56319' => 'MN',
        '56320' => 'MN',
        '56321' => 'MN',
        '56323' => 'MN',
        '56324' => 'MN',
        '56325' => 'MN',
        '56326' => 'MN',
        '56327' => 'MN',
        '56328' => 'MN',
        '56329' => 'MN',
        '56330' => 'MN',
        '56331' => 'MN',
        '56332' => 'MN',
        '56334' => 'MN',
        '56335' => 'MN',
        '56336' => 'MN',
        '56338' => 'MN',
        '56339' => 'MN',
        '56340' => 'MN',
        '56342' => 'MN',
        '56343' => 'MN',
        '56345' => 'MN',
        '56347' => 'MN',
        '56349' => 'MN',
        '56350' => 'MN',
        '56352' => 'MN',
        '56353' => 'MN',
        '56354' => 'MN',
        '56355' => 'MN',
        '56356' => 'MN',
        '56357' => 'MN',
        '56358' => 'MN',
        '56359' => 'MN',
        '56360' => 'MN',
        '56361' => 'MN',
        '56362' => 'MN',
        '56363' => 'MN',
        '56364' => 'MN',
        '56367' => 'MN',
        '56368' => 'MN',
        '56369' => 'MN',
        '56371' => 'MN',
        '56373' => 'MN',
        '56374' => 'MN',
        '56375' => 'MN',
        '56376' => 'MN',
        '56377' => 'MN',
        '56378' => 'MN',
        '56379' => 'MN',
        '56381' => 'MN',
        '56382' => 'MN',
        '56384' => 'MN',
        '56385' => 'MN',
        '56386' => 'MN',
        '56387' => 'MN',
        '56389' => 'MN',
        '56401' => 'MN',
        '56425' => 'MN',
        '56431' => 'MN',
        '56433' => 'MN',
        '56434' => 'MN',
        '56435' => 'MN',
        '56437' => 'MN',
        '56438' => 'MN',
        '56440' => 'MN',
        '56441' => 'MN',
        '56442' => 'MN',
        '56443' => 'MN',
        '56444' => 'MN',
        '56446' => 'MN',
        '56447' => 'MN',
        '56448' => 'MN',
        '56449' => 'MN',
        '56450' => 'MN',
        '56452' => 'MN',
        '56453' => 'MN',
        '56455' => 'MN',
        '56458' => 'MN',
        '56461' => 'MN',
        '56464' => 'MN',
        '56465' => 'MN',
        '56466' => 'MN',
        '56467' => 'MN',
        '56468' => 'MN',
        '56469' => 'MN',
        '56470' => 'MN',
        '56472' => 'MN',
        '56473' => 'MN',
        '56474' => 'MN',
        '56475' => 'MN',
        '56477' => 'MN',
        '56479' => 'MN',
        '56481' => 'MN',
        '56482' => 'MN',
        '56484' => 'MN',
        '56501' => 'MN',
        '56510' => 'MN',
        '56511' => 'MN',
        '56514' => 'MN',
        '56515' => 'MN',
        '56516' => 'MN',
        '56517' => 'MN',
        '56518' => 'MN',
        '56519' => 'MN',
        '56520' => 'MN',
        '56521' => 'MN',
        '56522' => 'MN',
        '56523' => 'MN',
        '56524' => 'MN',
        '56525' => 'MN',
        '56527' => 'MN',
        '56528' => 'MN',
        '56529' => 'MN',
        '56531' => 'MN',
        '56533' => 'MN',
        '56534' => 'MN',
        '56535' => 'MN',
        '56536' => 'MN',
        '56537' => 'MN',
        '56540' => 'MN',
        '56541' => 'MN',
        '56542' => 'MN',
        '56543' => 'MN',
        '56544' => 'MN',
        '56545' => 'MN',
        '56546' => 'MN',
        '56547' => 'MN',
        '56548' => 'MN',
        '56549' => 'MN',
        '56550' => 'MN',
        '56551' => 'MN',
        '56552' => 'MN',
        '56553' => 'MN',
        '56554' => 'MN',
        '56556' => 'MN',
        '56557' => 'MN',
        '56560' => 'MN',
        '56562' => 'MN',
        '56563' => 'MN',
        '56565' => 'MN',
        '56566' => 'MN',
        '56567' => 'MN',
        '56568' => 'MN',
        '56569' => 'MN',
        '56570' => 'MN',
        '56571' => 'MN',
        '56572' => 'MN',
        '56573' => 'MN',
        '56574' => 'MN',
        '56575' => 'MN',
        '56576' => 'MN',
        '56578' => 'MN',
        '56579' => 'MN',
        '56580' => 'MN',
        '56581' => 'MN',
        '56583' => 'MN',
        '56584' => 'MN',
        '56585' => 'MN',
        '56586' => 'MN',
        '56587' => 'MN',
        '56588' => 'MN',
        '56589' => 'MN',
        '56590' => 'MN',
        '56591' => 'MN',
        '56592' => 'MN',
        '56594' => 'MN',
        '56601' => 'MN',
        '56621' => 'MN',
        '56623' => 'MN',
        '56626' => 'MN',
        '56627' => 'MN',
        '56628' => 'MN',
        '56629' => 'MN',
        '56630' => 'MN',
        '56633' => 'MN',
        '56634' => 'MN',
        '56636' => 'MN',
        '56637' => 'MN',
        '56639' => 'MN',
        '56641' => 'MN',
        '56644' => 'MN',
        '56646' => 'MN',
        '56647' => 'MN',
        '56649' => 'MN',
        '56650' => 'MN',
        '56651' => 'MN',
        '56652' => 'MN',
        '56653' => 'MN',
        '56654' => 'MN',
        '56655' => 'MN',
        '56657' => 'MN',
        '56658' => 'MN',
        '56659' => 'MN',
        '56660' => 'MN',
        '56661' => 'MN',
        '56662' => 'MN',
        '56663' => 'MN',
        '56666' => 'MN',
        '56667' => 'MN',
        '56668' => 'MN',
        '56669' => 'MN',
        '56670' => 'MN',
        '56671' => 'MN',
        '56672' => 'MN',
        '56673' => 'MN',
        '56676' => 'MN',
        '56678' => 'MN',
        '56680' => 'MN',
        '56681' => 'MN',
        '56683' => 'MN',
        '56684' => 'MN',
        '56685' => 'MN',
        '56686' => 'MN',
        '56688' => 'MN',
        '56701' => 'MN',
        '56710' => 'MN',
        '56711' => 'MN',
        '56713' => 'MN',
        '56714' => 'MN',
        '56715' => 'MN',
        '56716' => 'MN',
        '56720' => 'MN',
        '56721' => 'MN',
        '56722' => 'MN',
        '56723' => 'MN',
        '56724' => 'MN',
        '56725' => 'MN',
        '56726' => 'MN',
        '56727' => 'MN',
        '56728' => 'MN',
        '56729' => 'MN',
        '56731' => 'MN',
        '56732' => 'MN',
        '56733' => 'MN',
        '56734' => 'MN',
        '56735' => 'MN',
        '56736' => 'MN',
        '56737' => 'MN',
        '56738' => 'MN',
        '56742' => 'MN',
        '56744' => 'MN',
        '56748' => 'MN',
        '56750' => 'MN',
        '56751' => 'MN',
        '56754' => 'MN',
        '56755' => 'MN',
        '56756' => 'MN',
        '56757' => 'MN',
        '56758' => 'MN',
        '56759' => 'MN',
        '56760' => 'MN',
        '56761' => 'MN',
        '56762' => 'MN',
        '56763' => 'MN',
        '57001' => 'SD',
        '57002' => 'SD',
        '57003' => 'SD',
        '57004' => 'SD',
        '57005' => 'SD',
        '57006' => 'SD',
        '57007' => 'SD',
        '57010' => 'SD',
        '57012' => 'SD',
        '57013' => 'SD',
        '57014' => 'SD',
        '57015' => 'SD',
        '57016' => 'SD',
        '57017' => 'SD',
        '57018' => 'SD',
        '57020' => 'SD',
        '57021' => 'SD',
        '57022' => 'SD',
        '57024' => 'SD',
        '57025' => 'SD',
        '57026' => 'SD',
        '57027' => 'SD',
        '57028' => 'SD',
        '57029' => 'SD',
        '57030' => 'SD',
        '57031' => 'SD',
        '57032' => 'SD',
        '57033' => 'SD',
        '57034' => 'SD',
        '57035' => 'SD',
        '57036' => 'SD',
        '57037' => 'SD',
        '57038' => 'SD',
        '57039' => 'SD',
        '57040' => 'SD',
        '57041' => 'SD',
        '57042' => 'SD',
        '57043' => 'SD',
        '57045' => 'SD',
        '57046' => 'SD',
        '57047' => 'SD',
        '57048' => 'SD',
        '57049' => 'SD',
        '57050' => 'SD',
        '57051' => 'SD',
        '57052' => 'SD',
        '57053' => 'SD',
        '57054' => 'SD',
        '57055' => 'SD',
        '57057' => 'SD',
        '57058' => 'SD',
        '57059' => 'SD',
        '57061' => 'SD',
        '57062' => 'SD',
        '57063' => 'SD',
        '57064' => 'SD',
        '57065' => 'SD',
        '57066' => 'SD',
        '57067' => 'SD',
        '57068' => 'SD',
        '57069' => 'SD',
        '57070' => 'SD',
        '57071' => 'SD',
        '57072' => 'SD',
        '57073' => 'SD',
        '57075' => 'SD',
        '57076' => 'SD',
        '57077' => 'SD',
        '57078' => 'SD',
        '57103' => 'SD',
        '57104' => 'SD',
        '57105' => 'SD',
        '57106' => 'SD',
        '57107' => 'SD',
        '57108' => 'SD',
        '57110' => 'SD',
        '57117' => 'SD',
        '57197' => 'SD',
        '57201' => 'SD',
        '57212' => 'SD',
        '57213' => 'SD',
        '57214' => 'SD',
        '57216' => 'SD',
        '57217' => 'SD',
        '57218' => 'SD',
        '57219' => 'SD',
        '57220' => 'SD',
        '57221' => 'SD',
        '57223' => 'SD',
        '57224' => 'SD',
        '57225' => 'SD',
        '57226' => 'SD',
        '57227' => 'SD',
        '57231' => 'SD',
        '57232' => 'SD',
        '57233' => 'SD',
        '57234' => 'SD',
        '57235' => 'SD',
        '57236' => 'SD',
        '57237' => 'SD',
        '57238' => 'SD',
        '57239' => 'SD',
        '57241' => 'SD',
        '57242' => 'SD',
        '57243' => 'SD',
        '57245' => 'SD',
        '57246' => 'SD',
        '57247' => 'SD',
        '57248' => 'SD',
        '57249' => 'SD',
        '57251' => 'SD',
        '57252' => 'SD',
        '57255' => 'SD',
        '57256' => 'SD',
        '57257' => 'SD',
        '57258' => 'SD',
        '57259' => 'SD',
        '57260' => 'SD',
        '57261' => 'SD',
        '57262' => 'SD',
        '57263' => 'SD',
        '57264' => 'SD',
        '57265' => 'SD',
        '57266' => 'SD',
        '57268' => 'SD',
        '57269' => 'SD',
        '57270' => 'SD',
        '57271' => 'SD',
        '57272' => 'SD',
        '57273' => 'SD',
        '57274' => 'SD',
        '57276' => 'SD',
        '57278' => 'SD',
        '57279' => 'SD',
        '57301' => 'SD',
        '57311' => 'SD',
        '57312' => 'SD',
        '57313' => 'SD',
        '57314' => 'SD',
        '57315' => 'SD',
        '57317' => 'SD',
        '57319' => 'SD',
        '57321' => 'SD',
        '57322' => 'SD',
        '57323' => 'SD',
        '57324' => 'SD',
        '57325' => 'SD',
        '57328' => 'SD',
        '57329' => 'SD',
        '57330' => 'SD',
        '57331' => 'SD',
        '57332' => 'SD',
        '57334' => 'SD',
        '57335' => 'SD',
        '57337' => 'SD',
        '57339' => 'SD',
        '57340' => 'SD',
        '57341' => 'SD',
        '57342' => 'SD',
        '57344' => 'SD',
        '57345' => 'SD',
        '57346' => 'SD',
        '57348' => 'SD',
        '57349' => 'SD',
        '57350' => 'SD',
        '57353' => 'SD',
        '57354' => 'SD',
        '57355' => 'SD',
        '57356' => 'SD',
        '57358' => 'SD',
        '57359' => 'SD',
        '57361' => 'SD',
        '57362' => 'SD',
        '57363' => 'SD',
        '57364' => 'SD',
        '57365' => 'SD',
        '57366' => 'SD',
        '57367' => 'SD',
        '57368' => 'SD',
        '57369' => 'SD',
        '57370' => 'SD',
        '57371' => 'SD',
        '57373' => 'SD',
        '57374' => 'SD',
        '57375' => 'SD',
        '57376' => 'SD',
        '57379' => 'SD',
        '57380' => 'SD',
        '57381' => 'SD',
        '57382' => 'SD',
        '57383' => 'SD',
        '57384' => 'SD',
        '57385' => 'SD',
        '57386' => 'SD',
        '57401' => 'SD',
        '57420' => 'SD',
        '57421' => 'SD',
        '57422' => 'SD',
        '57424' => 'SD',
        '57426' => 'SD',
        '57427' => 'SD',
        '57428' => 'SD',
        '57429' => 'SD',
        '57430' => 'SD',
        '57432' => 'SD',
        '57433' => 'SD',
        '57434' => 'SD',
        '57435' => 'SD',
        '57436' => 'SD',
        '57437' => 'SD',
        '57438' => 'SD',
        '57439' => 'SD',
        '57440' => 'SD',
        '57441' => 'SD',
        '57442' => 'SD',
        '57445' => 'SD',
        '57446' => 'SD',
        '57448' => 'SD',
        '57449' => 'SD',
        '57450' => 'SD',
        '57451' => 'SD',
        '57452' => 'SD',
        '57454' => 'SD',
        '57455' => 'SD',
        '57456' => 'SD',
        '57457' => 'SD',
        '57460' => 'SD',
        '57461' => 'SD',
        '57465' => 'SD',
        '57466' => 'SD',
        '57467' => 'SD',
        '57468' => 'SD',
        '57469' => 'SD',
        '57470' => 'SD',
        '57471' => 'SD',
        '57472' => 'SD',
        '57473' => 'SD',
        '57474' => 'SD',
        '57475' => 'SD',
        '57476' => 'SD',
        '57477' => 'SD',
        '57479' => 'SD',
        '57481' => 'SD',
        '57501' => 'SD',
        '57520' => 'SD',
        '57521' => 'SD',
        '57522' => 'SD',
        '57523' => 'SD',
        '57528' => 'SD',
        '57529' => 'SD',
        '57531' => 'SD',
        '57532' => 'SD',
        '57533' => 'SD',
        '57534' => 'SD',
        '57536' => 'SD',
        '57537' => 'SD',
        '57538' => 'SD',
        '57540' => 'SD',
        '57541' => 'SD',
        '57543' => 'SD',
        '57544' => 'SD',
        '57547' => 'SD',
        '57548' => 'SD',
        '57551' => 'SD',
        '57552' => 'SD',
        '57553' => 'SD',
        '57555' => 'SD',
        '57559' => 'SD',
        '57560' => 'SD',
        '57562' => 'SD',
        '57563' => 'SD',
        '57564' => 'SD',
        '57566' => 'SD',
        '57567' => 'SD',
        '57568' => 'SD',
        '57569' => 'SD',
        '57570' => 'SD',
        '57571' => 'SD',
        '57572' => 'SD',
        '57574' => 'SD',
        '57576' => 'SD',
        '57577' => 'SD',
        '57579' => 'SD',
        '57580' => 'SD',
        '57584' => 'SD',
        '57585' => 'SD',
        '57601' => 'SD',
        '57620' => 'SD',
        '57621' => 'SD',
        '57622' => 'SD',
        '57623' => 'SD',
        '57625' => 'SD',
        '57626' => 'SD',
        '57630' => 'SD',
        '57631' => 'SD',
        '57632' => 'SD',
        '57633' => 'SD',
        '57634' => 'SD',
        '57636' => 'SD',
        '57638' => 'SD',
        '57639' => 'SD',
        '57640' => 'SD',
        '57641' => 'SD',
        '57642' => 'SD',
        '57644' => 'SD',
        '57645' => 'SD',
        '57646' => 'SD',
        '57648' => 'SD',
        '57649' => 'SD',
        '57650' => 'SD',
        '57651' => 'SD',
        '57652' => 'SD',
        '57656' => 'SD',
        '57657' => 'SD',
        '57658' => 'SD',
        '57659' => 'SD',
        '57660' => 'SD',
        '57661' => 'SD',
        '57701' => 'SD',
        '57702' => 'SD',
        '57703' => 'SD',
        '57706' => 'SD',
        '57714' => 'SD',
        '57716' => 'SD',
        '57717' => 'SD',
        '57718' => 'SD',
        '57719' => 'SD',
        '57720' => 'SD',
        '57722' => 'SD',
        '57724' => 'SD',
        '57725' => 'SD',
        '57730' => 'SD',
        '57732' => 'SD',
        '57735' => 'SD',
        '57737' => 'SD',
        '57738' => 'SD',
        '57741' => 'SD',
        '57744' => 'SD',
        '57745' => 'SD',
        '57747' => 'SD',
        '57748' => 'SD',
        '57750' => 'SD',
        '57751' => 'SD',
        '57752' => 'SD',
        '57754' => 'SD',
        '57755' => 'SD',
        '57756' => 'SD',
        '57758' => 'SD',
        '57759' => 'SD',
        '57760' => 'SD',
        '57761' => 'SD',
        '57762' => 'SD',
        '57763' => 'SD',
        '57764' => 'SD',
        '57766' => 'SD',
        '57767' => 'SD',
        '57769' => 'SD',
        '57770' => 'SD',
        '57772' => 'SD',
        '57773' => 'SD',
        '57775' => 'SD',
        '57776' => 'SD',
        '57779' => 'SD',
        '57780' => 'SD',
        '57782' => 'SD',
        '57783' => 'SD',
        '57785' => 'SD',
        '57787' => 'SD',
        '57788' => 'SD',
        '57790' => 'SD',
        '57791' => 'SD',
        '57792' => 'SD',
        '57793' => 'SD',
        '57794' => 'SD',
        '57799' => 'SD',
        '58001' => 'ND',
        '58002' => 'ND',
        '58004' => 'ND',
        '58005' => 'ND',
        '58006' => 'ND',
        '58007' => 'ND',
        '58008' => 'ND',
        '58009' => 'ND',
        '58011' => 'ND',
        '58012' => 'ND',
        '58013' => 'ND',
        '58015' => 'ND',
        '58016' => 'ND',
        '58017' => 'ND',
        '58018' => 'ND',
        '58021' => 'ND',
        '58027' => 'ND',
        '58029' => 'ND',
        '58030' => 'ND',
        '58031' => 'ND',
        '58032' => 'ND',
        '58033' => 'ND',
        '58035' => 'ND',
        '58036' => 'ND',
        '58038' => 'ND',
        '58040' => 'ND',
        '58041' => 'ND',
        '58042' => 'ND',
        '58043' => 'ND',
        '58045' => 'ND',
        '58046' => 'ND',
        '58047' => 'ND',
        '58048' => 'ND',
        '58049' => 'ND',
        '58051' => 'ND',
        '58052' => 'ND',
        '58053' => 'ND',
        '58054' => 'ND',
        '58056' => 'ND',
        '58057' => 'ND',
        '58058' => 'ND',
        '58059' => 'ND',
        '58060' => 'ND',
        '58061' => 'ND',
        '58062' => 'ND',
        '58063' => 'ND',
        '58064' => 'ND',
        '58065' => 'ND',
        '58067' => 'ND',
        '58068' => 'ND',
        '58069' => 'ND',
        '58071' => 'ND',
        '58072' => 'ND',
        '58074' => 'ND',
        '58075' => 'ND',
        '58076' => 'ND',
        '58077' => 'ND',
        '58078' => 'ND',
        '58079' => 'ND',
        '58081' => 'ND',
        '58102' => 'ND',
        '58103' => 'ND',
        '58104' => 'ND',
        '58105' => 'ND',
        '58201' => 'ND',
        '58202' => 'ND',
        '58203' => 'ND',
        '58204' => 'ND',
        '58205' => 'ND',
        '58210' => 'ND',
        '58212' => 'ND',
        '58214' => 'ND',
        '58216' => 'ND',
        '58218' => 'ND',
        '58219' => 'ND',
        '58220' => 'ND',
        '58222' => 'ND',
        '58223' => 'ND',
        '58224' => 'ND',
        '58225' => 'ND',
        '58227' => 'ND',
        '58228' => 'ND',
        '58229' => 'ND',
        '58230' => 'ND',
        '58231' => 'ND',
        '58233' => 'ND',
        '58235' => 'ND',
        '58236' => 'ND',
        '58237' => 'ND',
        '58238' => 'ND',
        '58239' => 'ND',
        '58240' => 'ND',
        '58241' => 'ND',
        '58243' => 'ND',
        '58244' => 'ND',
        '58249' => 'ND',
        '58250' => 'ND',
        '58251' => 'ND',
        '58254' => 'ND',
        '58255' => 'ND',
        '58256' => 'ND',
        '58257' => 'ND',
        '58258' => 'ND',
        '58259' => 'ND',
        '58260' => 'ND',
        '58261' => 'ND',
        '58262' => 'ND',
        '58265' => 'ND',
        '58266' => 'ND',
        '58267' => 'ND',
        '58269' => 'ND',
        '58270' => 'ND',
        '58271' => 'ND',
        '58272' => 'ND',
        '58273' => 'ND',
        '58274' => 'ND',
        '58275' => 'ND',
        '58276' => 'ND',
        '58277' => 'ND',
        '58278' => 'ND',
        '58281' => 'ND',
        '58282' => 'ND',
        '58301' => 'ND',
        '58310' => 'ND',
        '58311' => 'ND',
        '58313' => 'ND',
        '58316' => 'ND',
        '58317' => 'ND',
        '58318' => 'ND',
        '58321' => 'ND',
        '58323' => 'ND',
        '58324' => 'ND',
        '58325' => 'ND',
        '58327' => 'ND',
        '58329' => 'ND',
        '58330' => 'ND',
        '58331' => 'ND',
        '58332' => 'ND',
        '58335' => 'ND',
        '58338' => 'ND',
        '58339' => 'ND',
        '58341' => 'ND',
        '58343' => 'ND',
        '58344' => 'ND',
        '58345' => 'ND',
        '58346' => 'ND',
        '58348' => 'ND',
        '58351' => 'ND',
        '58352' => 'ND',
        '58353' => 'ND',
        '58355' => 'ND',
        '58356' => 'ND',
        '58357' => 'ND',
        '58361' => 'ND',
        '58362' => 'ND',
        '58363' => 'ND',
        '58365' => 'ND',
        '58366' => 'ND',
        '58367' => 'ND',
        '58368' => 'ND',
        '58369' => 'ND',
        '58370' => 'ND',
        '58372' => 'ND',
        '58374' => 'ND',
        '58377' => 'ND',
        '58379' => 'ND',
        '58380' => 'ND',
        '58381' => 'ND',
        '58382' => 'ND',
        '58384' => 'ND',
        '58385' => 'ND',
        '58386' => 'ND',
        '58401' => 'ND',
        '58402' => 'ND',
        '58405' => 'ND',
        '58413' => 'ND',
        '58415' => 'ND',
        '58416' => 'ND',
        '58418' => 'ND',
        '58420' => 'ND',
        '58421' => 'ND',
        '58422' => 'ND',
        '58423' => 'ND',
        '58424' => 'ND',
        '58425' => 'ND',
        '58426' => 'ND',
        '58428' => 'ND',
        '58429' => 'ND',
        '58430' => 'ND',
        '58431' => 'ND',
        '58433' => 'ND',
        '58436' => 'ND',
        '58438' => 'ND',
        '58439' => 'ND',
        '58440' => 'ND',
        '58441' => 'ND',
        '58442' => 'ND',
        '58443' => 'ND',
        '58444' => 'ND',
        '58445' => 'ND',
        '58448' => 'ND',
        '58451' => 'ND',
        '58452' => 'ND',
        '58454' => 'ND',
        '58455' => 'ND',
        '58456' => 'ND',
        '58458' => 'ND',
        '58460' => 'ND',
        '58461' => 'ND',
        '58463' => 'ND',
        '58464' => 'ND',
        '58466' => 'ND',
        '58467' => 'ND',
        '58472' => 'ND',
        '58474' => 'ND',
        '58475' => 'ND',
        '58476' => 'ND',
        '58477' => 'ND',
        '58478' => 'ND',
        '58479' => 'ND',
        '58480' => 'ND',
        '58481' => 'ND',
        '58482' => 'ND',
        '58483' => 'ND',
        '58484' => 'ND',
        '58486' => 'ND',
        '58487' => 'ND',
        '58488' => 'ND',
        '58490' => 'ND',
        '58492' => 'ND',
        '58494' => 'ND',
        '58495' => 'ND',
        '58496' => 'ND',
        '58497' => 'ND',
        '58501' => 'ND',
        '58503' => 'ND',
        '58504' => 'ND',
        '58505' => 'ND',
        '58520' => 'ND',
        '58521' => 'ND',
        '58523' => 'ND',
        '58524' => 'ND',
        '58528' => 'ND',
        '58529' => 'ND',
        '58530' => 'ND',
        '58531' => 'ND',
        '58532' => 'ND',
        '58533' => 'ND',
        '58535' => 'ND',
        '58538' => 'ND',
        '58540' => 'ND',
        '58541' => 'ND',
        '58542' => 'ND',
        '58544' => 'ND',
        '58545' => 'ND',
        '58549' => 'ND',
        '58552' => 'ND',
        '58554' => 'ND',
        '58558' => 'ND',
        '58559' => 'ND',
        '58560' => 'ND',
        '58561' => 'ND',
        '58562' => 'ND',
        '58563' => 'ND',
        '58564' => 'ND',
        '58565' => 'ND',
        '58566' => 'ND',
        '58568' => 'ND',
        '58569' => 'ND',
        '58570' => 'ND',
        '58571' => 'ND',
        '58572' => 'ND',
        '58573' => 'ND',
        '58575' => 'ND',
        '58576' => 'ND',
        '58577' => 'ND',
        '58579' => 'ND',
        '58580' => 'ND',
        '58581' => 'ND',
        '58601' => 'ND',
        '58620' => 'ND',
        '58621' => 'ND',
        '58622' => 'ND',
        '58623' => 'ND',
        '58625' => 'ND',
        '58626' => 'ND',
        '58627' => 'ND',
        '58630' => 'ND',
        '58631' => 'ND',
        '58632' => 'ND',
        '58634' => 'ND',
        '58636' => 'ND',
        '58638' => 'ND',
        '58639' => 'ND',
        '58640' => 'ND',
        '58641' => 'ND',
        '58642' => 'ND',
        '58643' => 'ND',
        '58644' => 'ND',
        '58645' => 'ND',
        '58646' => 'ND',
        '58647' => 'ND',
        '58649' => 'ND',
        '58650' => 'ND',
        '58651' => 'ND',
        '58652' => 'ND',
        '58653' => 'ND',
        '58654' => 'ND',
        '58655' => 'ND',
        '58656' => 'ND',
        '58701' => 'ND',
        '58703' => 'ND',
        '58704' => 'ND',
        '58705' => 'ND',
        '58707' => 'ND',
        '58710' => 'ND',
        '58711' => 'ND',
        '58712' => 'ND',
        '58713' => 'ND',
        '58716' => 'ND',
        '58718' => 'ND',
        '58721' => 'ND',
        '58722' => 'ND',
        '58723' => 'ND',
        '58725' => 'ND',
        '58727' => 'ND',
        '58730' => 'ND',
        '58731' => 'ND',
        '58733' => 'ND',
        '58734' => 'ND',
        '58735' => 'ND',
        '58736' => 'ND',
        '58737' => 'ND',
        '58740' => 'ND',
        '58741' => 'ND',
        '58744' => 'ND',
        '58746' => 'ND',
        '58748' => 'ND',
        '58750' => 'ND',
        '58752' => 'ND',
        '58755' => 'ND',
        '58756' => 'ND',
        '58757' => 'ND',
        '58758' => 'ND',
        '58759' => 'ND',
        '58760' => 'ND',
        '58761' => 'ND',
        '58762' => 'ND',
        '58763' => 'ND',
        '58765' => 'ND',
        '58768' => 'ND',
        '58769' => 'ND',
        '58770' => 'ND',
        '58771' => 'ND',
        '58772' => 'ND',
        '58773' => 'ND',
        '58775' => 'ND',
        '58776' => 'ND',
        '58778' => 'ND',
        '58779' => 'ND',
        '58781' => 'ND',
        '58782' => 'ND',
        '58783' => 'ND',
        '58784' => 'ND',
        '58785' => 'ND',
        '58787' => 'ND',
        '58788' => 'ND',
        '58789' => 'ND',
        '58790' => 'ND',
        '58792' => 'ND',
        '58793' => 'ND',
        '58794' => 'ND',
        '58795' => 'ND',
        '58801' => 'ND',
        '58830' => 'ND',
        '58831' => 'ND',
        '58833' => 'ND',
        '58835' => 'ND',
        '58838' => 'ND',
        '58843' => 'ND',
        '58844' => 'ND',
        '58845' => 'ND',
        '58847' => 'ND',
        '58849' => 'ND',
        '58852' => 'ND',
        '58853' => 'ND',
        '58854' => 'ND',
        '58856' => 'ND',
        '59001' => 'MT',
        '59002' => 'MT',
        '59003' => 'MT',
        '59006' => 'MT',
        '59007' => 'MT',
        '59008' => 'MT',
        '59010' => 'MT',
        '59011' => 'MT',
        '59012' => 'MT',
        '59013' => 'MT',
        '59014' => 'MT',
        '59015' => 'MT',
        '59016' => 'MT',
        '59018' => 'MT',
        '59019' => 'MT',
        '59020' => 'MT',
        '59022' => 'MT',
        '59024' => 'MT',
        '59025' => 'MT',
        '59026' => 'MT',
        '59027' => 'MT',
        '59028' => 'MT',
        '59029' => 'MT',
        '59030' => 'MT',
        '59031' => 'MT',
        '59032' => 'MT',
        '59033' => 'MT',
        '59034' => 'MT',
        '59035' => 'MT',
        '59036' => 'MT',
        '59037' => 'MT',
        '59038' => 'MT',
        '59039' => 'MT',
        '59041' => 'MT',
        '59043' => 'MT',
        '59044' => 'MT',
        '59046' => 'MT',
        '59047' => 'MT',
        '59050' => 'MT',
        '59052' => 'MT',
        '59053' => 'MT',
        '59054' => 'MT',
        '59055' => 'MT',
        '59057' => 'MT',
        '59058' => 'MT',
        '59059' => 'MT',
        '59061' => 'MT',
        '59062' => 'MT',
        '59063' => 'MT',
        '59064' => 'MT',
        '59065' => 'MT',
        '59066' => 'MT',
        '59067' => 'MT',
        '59068' => 'MT',
        '59069' => 'MT',
        '59070' => 'MT',
        '59071' => 'MT',
        '59072' => 'MT',
        '59074' => 'MT',
        '59075' => 'MT',
        '59076' => 'MT',
        '59077' => 'MT',
        '59078' => 'MT',
        '59079' => 'MT',
        '59081' => 'MT',
        '59082' => 'MT',
        '59083' => 'MT',
        '59085' => 'MT',
        '59086' => 'MT',
        '59087' => 'MT',
        '59088' => 'MT',
        '59089' => 'MT',
        '59101' => 'MT',
        '59102' => 'MT',
        '59105' => 'MT',
        '59106' => 'MT',
        '59201' => 'MT',
        '59211' => 'MT',
        '59212' => 'MT',
        '59213' => 'MT',
        '59214' => 'MT',
        '59215' => 'MT',
        '59217' => 'MT',
        '59218' => 'MT',
        '59219' => 'MT',
        '59221' => 'MT',
        '59222' => 'MT',
        '59223' => 'MT',
        '59225' => 'MT',
        '59226' => 'MT',
        '59230' => 'MT',
        '59231' => 'MT',
        '59240' => 'MT',
        '59241' => 'MT',
        '59242' => 'MT',
        '59243' => 'MT',
        '59244' => 'MT',
        '59247' => 'MT',
        '59248' => 'MT',
        '59250' => 'MT',
        '59252' => 'MT',
        '59253' => 'MT',
        '59254' => 'MT',
        '59255' => 'MT',
        '59256' => 'MT',
        '59257' => 'MT',
        '59258' => 'MT',
        '59259' => 'MT',
        '59260' => 'MT',
        '59261' => 'MT',
        '59262' => 'MT',
        '59263' => 'MT',
        '59270' => 'MT',
        '59273' => 'MT',
        '59274' => 'MT',
        '59275' => 'MT',
        '59276' => 'MT',
        '59301' => 'MT',
        '59311' => 'MT',
        '59312' => 'MT',
        '59313' => 'MT',
        '59314' => 'MT',
        '59315' => 'MT',
        '59316' => 'MT',
        '59317' => 'MT',
        '59318' => 'MT',
        '59319' => 'MT',
        '59322' => 'MT',
        '59323' => 'MT',
        '59324' => 'MT',
        '59326' => 'MT',
        '59327' => 'MT',
        '59330' => 'MT',
        '59332' => 'MT',
        '59333' => 'MT',
        '59336' => 'MT',
        '59337' => 'MT',
        '59338' => 'MT',
        '59339' => 'MT',
        '59343' => 'MT',
        '59344' => 'MT',
        '59345' => 'MT',
        '59347' => 'MT',
        '59349' => 'MT',
        '59351' => 'MT',
        '59353' => 'MT',
        '59354' => 'MT',
        '59401' => 'MT',
        '59404' => 'MT',
        '59405' => 'MT',
        '59410' => 'MT',
        '59411' => 'MT',
        '59412' => 'MT',
        '59414' => 'MT',
        '59416' => 'MT',
        '59417' => 'MT',
        '59418' => 'MT',
        '59419' => 'MT',
        '59420' => 'MT',
        '59421' => 'MT',
        '59422' => 'MT',
        '59424' => 'MT',
        '59425' => 'MT',
        '59427' => 'MT',
        '59430' => 'MT',
        '59432' => 'MT',
        '59433' => 'MT',
        '59434' => 'MT',
        '59435' => 'MT',
        '59436' => 'MT',
        '59440' => 'MT',
        '59441' => 'MT',
        '59442' => 'MT',
        '59443' => 'MT',
        '59444' => 'MT',
        '59446' => 'MT',
        '59447' => 'MT',
        '59448' => 'MT',
        '59450' => 'MT',
        '59451' => 'MT',
        '59452' => 'MT',
        '59453' => 'MT',
        '59454' => 'MT',
        '59456' => 'MT',
        '59457' => 'MT',
        '59460' => 'MT',
        '59461' => 'MT',
        '59462' => 'MT',
        '59463' => 'MT',
        '59464' => 'MT',
        '59465' => 'MT',
        '59466' => 'MT',
        '59467' => 'MT',
        '59468' => 'MT',
        '59469' => 'MT',
        '59471' => 'MT',
        '59472' => 'MT',
        '59474' => 'MT',
        '59477' => 'MT',
        '59479' => 'MT',
        '59480' => 'MT',
        '59482' => 'MT',
        '59483' => 'MT',
        '59484' => 'MT',
        '59485' => 'MT',
        '59486' => 'MT',
        '59487' => 'MT',
        '59489' => 'MT',
        '59501' => 'MT',
        '59520' => 'MT',
        '59521' => 'MT',
        '59522' => 'MT',
        '59523' => 'MT',
        '59524' => 'MT',
        '59525' => 'MT',
        '59526' => 'MT',
        '59527' => 'MT',
        '59528' => 'MT',
        '59529' => 'MT',
        '59530' => 'MT',
        '59531' => 'MT',
        '59532' => 'MT',
        '59535' => 'MT',
        '59537' => 'MT',
        '59538' => 'MT',
        '59540' => 'MT',
        '59542' => 'MT',
        '59544' => 'MT',
        '59545' => 'MT',
        '59546' => 'MT',
        '59547' => 'MT',
        '59601' => 'MT',
        '59602' => 'MT',
        '59623' => 'MT',
        '59625' => 'MT',
        '59631' => 'MT',
        '59632' => 'MT',
        '59633' => 'MT',
        '59634' => 'MT',
        '59635' => 'MT',
        '59636' => 'MT',
        '59638' => 'MT',
        '59639' => 'MT',
        '59640' => 'MT',
        '59642' => 'MT',
        '59643' => 'MT',
        '59644' => 'MT',
        '59645' => 'MT',
        '59647' => 'MT',
        '59648' => 'MT',
        '59701' => 'MT',
        '59710' => 'MT',
        '59711' => 'MT',
        '59713' => 'MT',
        '59714' => 'MT',
        '59715' => 'MT',
        '59716' => 'MT',
        '59718' => 'MT',
        '59720' => 'MT',
        '59721' => 'MT',
        '59722' => 'MT',
        '59724' => 'MT',
        '59725' => 'MT',
        '59727' => 'MT',
        '59728' => 'MT',
        '59729' => 'MT',
        '59730' => 'MT',
        '59731' => 'MT',
        '59732' => 'MT',
        '59733' => 'MT',
        '59735' => 'MT',
        '59736' => 'MT',
        '59739' => 'MT',
        '59740' => 'MT',
        '59741' => 'MT',
        '59743' => 'MT',
        '59745' => 'MT',
        '59746' => 'MT',
        '59747' => 'MT',
        '59748' => 'MT',
        '59749' => 'MT',
        '59750' => 'MT',
        '59751' => 'MT',
        '59752' => 'MT',
        '59754' => 'MT',
        '59755' => 'MT',
        '59756' => 'MT',
        '59758' => 'MT',
        '59759' => 'MT',
        '59760' => 'MT',
        '59761' => 'MT',
        '59762' => 'MT',
        '59801' => 'MT',
        '59802' => 'MT',
        '59803' => 'MT',
        '59804' => 'MT',
        '59808' => 'MT',
        '59812' => 'MT',
        '59820' => 'MT',
        '59821' => 'MT',
        '59823' => 'MT',
        '59824' => 'MT',
        '59825' => 'MT',
        '59826' => 'MT',
        '59827' => 'MT',
        '59828' => 'MT',
        '59829' => 'MT',
        '59830' => 'MT',
        '59831' => 'MT',
        '59832' => 'MT',
        '59833' => 'MT',
        '59834' => 'MT',
        '59837' => 'MT',
        '59840' => 'MT',
        '59841' => 'MT',
        '59842' => 'MT',
        '59843' => 'MT',
        '59844' => 'MT',
        '59845' => 'MT',
        '59846' => 'MT',
        '59847' => 'MT',
        '59848' => 'MT',
        '59851' => 'MT',
        '59853' => 'MT',
        '59854' => 'MT',
        '59855' => 'MT',
        '59856' => 'MT',
        '59858' => 'MT',
        '59859' => 'MT',
        '59860' => 'MT',
        '59863' => 'MT',
        '59864' => 'MT',
        '59865' => 'MT',
        '59866' => 'MT',
        '59867' => 'MT',
        '59868' => 'MT',
        '59870' => 'MT',
        '59871' => 'MT',
        '59872' => 'MT',
        '59873' => 'MT',
        '59874' => 'MT',
        '59875' => 'MT',
        '59901' => 'MT',
        '59910' => 'MT',
        '59911' => 'MT',
        '59912' => 'MT',
        '59913' => 'MT',
        '59914' => 'MT',
        '59915' => 'MT',
        '59916' => 'MT',
        '59917' => 'MT',
        '59918' => 'MT',
        '59919' => 'MT',
        '59920' => 'MT',
        '59922' => 'MT',
        '59923' => 'MT',
        '59925' => 'MT',
        '59926' => 'MT',
        '59927' => 'MT',
        '59928' => 'MT',
        '59929' => 'MT',
        '59930' => 'MT',
        '59931' => 'MT',
        '59932' => 'MT',
        '59933' => 'MT',
        '59934' => 'MT',
        '59935' => 'MT',
        '59936' => 'MT',
        '59937' => 'MT',
        '60002' => 'IL',
        '60004' => 'IL',
        '60005' => 'IL',
        '60007' => 'IL',
        '60008' => 'IL',
        '60010' => 'IL',
        '60012' => 'IL',
        '60013' => 'IL',
        '60014' => 'IL',
        '60015' => 'IL',
        '60016' => 'IL',
        '60018' => 'IL',
        '60020' => 'IL',
        '60021' => 'IL',
        '60022' => 'IL',
        '60025' => 'IL',
        '60026' => 'IL',
        '60029' => 'IL',
        '60030' => 'IL',
        '60031' => 'IL',
        '60033' => 'IL',
        '60034' => 'IL',
        '60035' => 'IL',
        '60040' => 'IL',
        '60041' => 'IL',
        '60042' => 'IL',
        '60043' => 'IL',
        '60044' => 'IL',
        '60045' => 'IL',
        '60046' => 'IL',
        '60047' => 'IL',
        '60048' => 'IL',
        '60050' => 'IL',
        '60051' => 'IL',
        '60053' => 'IL',
        '60056' => 'IL',
        '60060' => 'IL',
        '60061' => 'IL',
        '60062' => 'IL',
        '60064' => 'IL',
        '60067' => 'IL',
        '60068' => 'IL',
        '60069' => 'IL',
        '60070' => 'IL',
        '60071' => 'IL',
        '60072' => 'IL',
        '60073' => 'IL',
        '60074' => 'IL',
        '60075' => 'IL',
        '60076' => 'IL',
        '60077' => 'IL',
        '60081' => 'IL',
        '60083' => 'IL',
        '60084' => 'IL',
        '60085' => 'IL',
        '60087' => 'IL',
        '60088' => 'IL',
        '60089' => 'IL',
        '60090' => 'IL',
        '60091' => 'IL',
        '60093' => 'IL',
        '60096' => 'IL',
        '60097' => 'IL',
        '60098' => 'IL',
        '60099' => 'IL',
        '60101' => 'IL',
        '60102' => 'IL',
        '60103' => 'IL',
        '60104' => 'IL',
        '60106' => 'IL',
        '60107' => 'IL',
        '60108' => 'IL',
        '60109' => 'IL',
        '60110' => 'IL',
        '60111' => 'IL',
        '60112' => 'IL',
        '60113' => 'IL',
        '60115' => 'IL',
        '60118' => 'IL',
        '60119' => 'IL',
        '60120' => 'IL',
        '60123' => 'IL',
        '60124' => 'IL',
        '60126' => 'IL',
        '60129' => 'IL',
        '60130' => 'IL',
        '60131' => 'IL',
        '60133' => 'IL',
        '60134' => 'IL',
        '60135' => 'IL',
        '60136' => 'IL',
        '60137' => 'IL',
        '60139' => 'IL',
        '60140' => 'IL',
        '60141' => 'IL',
        '60142' => 'IL',
        '60143' => 'IL',
        '60144' => 'IL',
        '60145' => 'IL',
        '60146' => 'IL',
        '60148' => 'IL',
        '60150' => 'IL',
        '60151' => 'IL',
        '60152' => 'IL',
        '60153' => 'IL',
        '60154' => 'IL',
        '60155' => 'IL',
        '60156' => 'IL',
        '60157' => 'IL',
        '60160' => 'IL',
        '60162' => 'IL',
        '60163' => 'IL',
        '60164' => 'IL',
        '60165' => 'IL',
        '60169' => 'IL',
        '60171' => 'IL',
        '60172' => 'IL',
        '60173' => 'IL',
        '60174' => 'IL',
        '60175' => 'IL',
        '60176' => 'IL',
        '60177' => 'IL',
        '60178' => 'IL',
        '60180' => 'IL',
        '60181' => 'IL',
        '60183' => 'IL',
        '60184' => 'IL',
        '60185' => 'IL',
        '60187' => 'IL',
        '60188' => 'IL',
        '60189' => 'IL',
        '60190' => 'IL',
        '60191' => 'IL',
        '60192' => 'IL',
        '60193' => 'IL',
        '60194' => 'IL',
        '60195' => 'IL',
        '60201' => 'IL',
        '60202' => 'IL',
        '60203' => 'IL',
        '60208' => 'IL',
        '60301' => 'IL',
        '60302' => 'IL',
        '60304' => 'IL',
        '60305' => 'IL',
        '60401' => 'IL',
        '60402' => 'IL',
        '60403' => 'IL',
        '60404' => 'IL',
        '60406' => 'IL',
        '60407' => 'IL',
        '60408' => 'IL',
        '60409' => 'IL',
        '60410' => 'IL',
        '60411' => 'IL',
        '60415' => 'IL',
        '60416' => 'IL',
        '60417' => 'IL',
        '60418' => 'IL',
        '60419' => 'IL',
        '60420' => 'IL',
        '60421' => 'IL',
        '60422' => 'IL',
        '60423' => 'IL',
        '60424' => 'IL',
        '60425' => 'IL',
        '60426' => 'IL',
        '60428' => 'IL',
        '60429' => 'IL',
        '60430' => 'IL',
        '60431' => 'IL',
        '60432' => 'IL',
        '60433' => 'IL',
        '60435' => 'IL',
        '60436' => 'IL',
        '60437' => 'IL',
        '60438' => 'IL',
        '60439' => 'IL',
        '60440' => 'IL',
        '60441' => 'IL',
        '60442' => 'IL',
        '60443' => 'IL',
        '60444' => 'IL',
        '60445' => 'IL',
        '60446' => 'IL',
        '60447' => 'IL',
        '60448' => 'IL',
        '60449' => 'IL',
        '60450' => 'IL',
        '60451' => 'IL',
        '60452' => 'IL',
        '60453' => 'IL',
        '60455' => 'IL',
        '60456' => 'IL',
        '60457' => 'IL',
        '60458' => 'IL',
        '60459' => 'IL',
        '60460' => 'IL',
        '60461' => 'IL',
        '60462' => 'IL',
        '60463' => 'IL',
        '60464' => 'IL',
        '60465' => 'IL',
        '60466' => 'IL',
        '60467' => 'IL',
        '60468' => 'IL',
        '60469' => 'IL',
        '60470' => 'IL',
        '60471' => 'IL',
        '60472' => 'IL',
        '60473' => 'IL',
        '60474' => 'IL',
        '60475' => 'IL',
        '60476' => 'IL',
        '60477' => 'IL',
        '60478' => 'IL',
        '60479' => 'IL',
        '60480' => 'IL',
        '60481' => 'IL',
        '60482' => 'IL',
        '60484' => 'IL',
        '60487' => 'IL',
        '60490' => 'IL',
        '60491' => 'IL',
        '60501' => 'IL',
        '60502' => 'IL',
        '60503' => 'IL',
        '60504' => 'IL',
        '60505' => 'IL',
        '60506' => 'IL',
        '60510' => 'IL',
        '60511' => 'IL',
        '60512' => 'IL',
        '60513' => 'IL',
        '60514' => 'IL',
        '60515' => 'IL',
        '60516' => 'IL',
        '60517' => 'IL',
        '60518' => 'IL',
        '60519' => 'IL',
        '60520' => 'IL',
        '60521' => 'IL',
        '60523' => 'IL',
        '60525' => 'IL',
        '60526' => 'IL',
        '60527' => 'IL',
        '60530' => 'IL',
        '60531' => 'IL',
        '60532' => 'IL',
        '60534' => 'IL',
        '60536' => 'IL',
        '60537' => 'IL',
        '60538' => 'IL',
        '60539' => 'IL',
        '60540' => 'IL',
        '60541' => 'IL',
        '60542' => 'IL',
        '60543' => 'IL',
        '60544' => 'IL',
        '60545' => 'IL',
        '60546' => 'IL',
        '60548' => 'IL',
        '60549' => 'IL',
        '60550' => 'IL',
        '60551' => 'IL',
        '60552' => 'IL',
        '60553' => 'IL',
        '60554' => 'IL',
        '60555' => 'IL',
        '60556' => 'IL',
        '60557' => 'IL',
        '60558' => 'IL',
        '60559' => 'IL',
        '60560' => 'IL',
        '60561' => 'IL',
        '60563' => 'IL',
        '60564' => 'IL',
        '60565' => 'IL',
        '60585' => 'IL',
        '60586' => 'IL',
        '60601' => 'IL',
        '60602' => 'IL',
        '60603' => 'IL',
        '60604' => 'IL',
        '60605' => 'IL',
        '60606' => 'IL',
        '60607' => 'IL',
        '60608' => 'IL',
        '60609' => 'IL',
        '60610' => 'IL',
        '60611' => 'IL',
        '60612' => 'IL',
        '60613' => 'IL',
        '60614' => 'IL',
        '60615' => 'IL',
        '60616' => 'IL',
        '60617' => 'IL',
        '60618' => 'IL',
        '60619' => 'IL',
        '60620' => 'IL',
        '60621' => 'IL',
        '60622' => 'IL',
        '60623' => 'IL',
        '60624' => 'IL',
        '60625' => 'IL',
        '60626' => 'IL',
        '60628' => 'IL',
        '60629' => 'IL',
        '60630' => 'IL',
        '60631' => 'IL',
        '60632' => 'IL',
        '60633' => 'IL',
        '60634' => 'IL',
        '60636' => 'IL',
        '60637' => 'IL',
        '60638' => 'IL',
        '60639' => 'IL',
        '60640' => 'IL',
        '60641' => 'IL',
        '60642' => 'IL',
        '60643' => 'IL',
        '60644' => 'IL',
        '60645' => 'IL',
        '60646' => 'IL',
        '60647' => 'IL',
        '60649' => 'IL',
        '60651' => 'IL',
        '60652' => 'IL',
        '60653' => 'IL',
        '60654' => 'IL',
        '60655' => 'IL',
        '60656' => 'IL',
        '60657' => 'IL',
        '60659' => 'IL',
        '60660' => 'IL',
        '60661' => 'IL',
        '60706' => 'IL',
        '60707' => 'IL',
        '60712' => 'IL',
        '60714' => 'IL',
        '60803' => 'IL',
        '60804' => 'IL',
        '60805' => 'IL',
        '60827' => 'IL',
        '60901' => 'IL',
        '60910' => 'IL',
        '60911' => 'IL',
        '60912' => 'IL',
        '60913' => 'IL',
        '60914' => 'IL',
        '60915' => 'IL',
        '60917' => 'IL',
        '60918' => 'IL',
        '60919' => 'IL',
        '60920' => 'IL',
        '60921' => 'IL',
        '60922' => 'IL',
        '60924' => 'IL',
        '60926' => 'IL',
        '60927' => 'IL',
        '60928' => 'IL',
        '60929' => 'IL',
        '60930' => 'IL',
        '60931' => 'IL',
        '60932' => 'IL',
        '60933' => 'IL',
        '60934' => 'IL',
        '60935' => 'IL',
        '60936' => 'IL',
        '60938' => 'IL',
        '60939' => 'IL',
        '60940' => 'IL',
        '60941' => 'IL',
        '60942' => 'IL',
        '60945' => 'IL',
        '60946' => 'IL',
        '60948' => 'IL',
        '60949' => 'IL',
        '60950' => 'IL',
        '60951' => 'IL',
        '60952' => 'IL',
        '60953' => 'IL',
        '60954' => 'IL',
        '60955' => 'IL',
        '60956' => 'IL',
        '60957' => 'IL',
        '60958' => 'IL',
        '60959' => 'IL',
        '60960' => 'IL',
        '60961' => 'IL',
        '60962' => 'IL',
        '60963' => 'IL',
        '60964' => 'IL',
        '60966' => 'IL',
        '60967' => 'IL',
        '60968' => 'IL',
        '60969' => 'IL',
        '60970' => 'IL',
        '60973' => 'IL',
        '60974' => 'IL',
        '61001' => 'IL',
        '61006' => 'IL',
        '61007' => 'IL',
        '61008' => 'IL',
        '61010' => 'IL',
        '61011' => 'IL',
        '61012' => 'IL',
        '61013' => 'IL',
        '61014' => 'IL',
        '61015' => 'IL',
        '61016' => 'IL',
        '61018' => 'IL',
        '61019' => 'IL',
        '61020' => 'IL',
        '61021' => 'IL',
        '61024' => 'IL',
        '61025' => 'IL',
        '61027' => 'IL',
        '61028' => 'IL',
        '61030' => 'IL',
        '61031' => 'IL',
        '61032' => 'IL',
        '61036' => 'IL',
        '61037' => 'IL',
        '61038' => 'IL',
        '61039' => 'IL',
        '61041' => 'IL',
        '61042' => 'IL',
        '61043' => 'IL',
        '61044' => 'IL',
        '61046' => 'IL',
        '61047' => 'IL',
        '61048' => 'IL',
        '61049' => 'IL',
        '61050' => 'IL',
        '61051' => 'IL',
        '61052' => 'IL',
        '61053' => 'IL',
        '61054' => 'IL',
        '61057' => 'IL',
        '61059' => 'IL',
        '61060' => 'IL',
        '61061' => 'IL',
        '61062' => 'IL',
        '61063' => 'IL',
        '61064' => 'IL',
        '61065' => 'IL',
        '61067' => 'IL',
        '61068' => 'IL',
        '61070' => 'IL',
        '61071' => 'IL',
        '61072' => 'IL',
        '61073' => 'IL',
        '61074' => 'IL',
        '61075' => 'IL',
        '61077' => 'IL',
        '61078' => 'IL',
        '61079' => 'IL',
        '61080' => 'IL',
        '61081' => 'IL',
        '61084' => 'IL',
        '61085' => 'IL',
        '61087' => 'IL',
        '61088' => 'IL',
        '61089' => 'IL',
        '61091' => 'IL',
        '61101' => 'IL',
        '61102' => 'IL',
        '61103' => 'IL',
        '61104' => 'IL',
        '61107' => 'IL',
        '61108' => 'IL',
        '61109' => 'IL',
        '61111' => 'IL',
        '61112' => 'IL',
        '61114' => 'IL',
        '61115' => 'IL',
        '61201' => 'IL',
        '61230' => 'IL',
        '61231' => 'IL',
        '61232' => 'IL',
        '61233' => 'IL',
        '61234' => 'IL',
        '61235' => 'IL',
        '61236' => 'IL',
        '61237' => 'IL',
        '61238' => 'IL',
        '61239' => 'IL',
        '61240' => 'IL',
        '61241' => 'IL',
        '61242' => 'IL',
        '61243' => 'IL',
        '61244' => 'IL',
        '61250' => 'IL',
        '61251' => 'IL',
        '61252' => 'IL',
        '61254' => 'IL',
        '61256' => 'IL',
        '61257' => 'IL',
        '61258' => 'IL',
        '61259' => 'IL',
        '61260' => 'IL',
        '61261' => 'IL',
        '61262' => 'IL',
        '61263' => 'IL',
        '61264' => 'IL',
        '61265' => 'IL',
        '61270' => 'IL',
        '61272' => 'IL',
        '61273' => 'IL',
        '61274' => 'IL',
        '61275' => 'IL',
        '61276' => 'IL',
        '61277' => 'IL',
        '61278' => 'IL',
        '61279' => 'IL',
        '61281' => 'IL',
        '61282' => 'IL',
        '61283' => 'IL',
        '61284' => 'IL',
        '61285' => 'IL',
        '61301' => 'IL',
        '61310' => 'IL',
        '61311' => 'IL',
        '61312' => 'IL',
        '61313' => 'IL',
        '61314' => 'IL',
        '61315' => 'IL',
        '61316' => 'IL',
        '61317' => 'IL',
        '61318' => 'IL',
        '61319' => 'IL',
        '61320' => 'IL',
        '61321' => 'IL',
        '61322' => 'IL',
        '61323' => 'IL',
        '61324' => 'IL',
        '61325' => 'IL',
        '61326' => 'IL',
        '61327' => 'IL',
        '61328' => 'IL',
        '61329' => 'IL',
        '61330' => 'IL',
        '61331' => 'IL',
        '61332' => 'IL',
        '61333' => 'IL',
        '61334' => 'IL',
        '61335' => 'IL',
        '61336' => 'IL',
        '61337' => 'IL',
        '61338' => 'IL',
        '61340' => 'IL',
        '61341' => 'IL',
        '61342' => 'IL',
        '61344' => 'IL',
        '61345' => 'IL',
        '61346' => 'IL',
        '61348' => 'IL',
        '61349' => 'IL',
        '61350' => 'IL',
        '61353' => 'IL',
        '61354' => 'IL',
        '61356' => 'IL',
        '61358' => 'IL',
        '61359' => 'IL',
        '61360' => 'IL',
        '61361' => 'IL',
        '61362' => 'IL',
        '61363' => 'IL',
        '61364' => 'IL',
        '61367' => 'IL',
        '61368' => 'IL',
        '61369' => 'IL',
        '61370' => 'IL',
        '61371' => 'IL',
        '61372' => 'IL',
        '61373' => 'IL',
        '61374' => 'IL',
        '61375' => 'IL',
        '61376' => 'IL',
        '61377' => 'IL',
        '61378' => 'IL',
        '61379' => 'IL',
        '61401' => 'IL',
        '61402' => 'IL',
        '61410' => 'IL',
        '61411' => 'IL',
        '61412' => 'IL',
        '61413' => 'IL',
        '61414' => 'IL',
        '61415' => 'IL',
        '61416' => 'IL',
        '61417' => 'IL',
        '61418' => 'IL',
        '61419' => 'IL',
        '61420' => 'IL',
        '61421' => 'IL',
        '61422' => 'IL',
        '61423' => 'IL',
        '61424' => 'IL',
        '61425' => 'IL',
        '61426' => 'IL',
        '61427' => 'IL',
        '61428' => 'IL',
        '61430' => 'IL',
        '61431' => 'IL',
        '61432' => 'IL',
        '61433' => 'IL',
        '61434' => 'IL',
        '61435' => 'IL',
        '61436' => 'IL',
        '61437' => 'IL',
        '61438' => 'IL',
        '61439' => 'IL',
        '61440' => 'IL',
        '61441' => 'IL',
        '61442' => 'IL',
        '61443' => 'IL',
        '61447' => 'IL',
        '61448' => 'IL',
        '61449' => 'IL',
        '61450' => 'IL',
        '61451' => 'IL',
        '61452' => 'IL',
        '61453' => 'IL',
        '61454' => 'IL',
        '61455' => 'IL',
        '61458' => 'IL',
        '61459' => 'IL',
        '61460' => 'IL',
        '61462' => 'IL',
        '61465' => 'IL',
        '61466' => 'IL',
        '61467' => 'IL',
        '61468' => 'IL',
        '61469' => 'IL',
        '61470' => 'IL',
        '61471' => 'IL',
        '61472' => 'IL',
        '61473' => 'IL',
        '61474' => 'IL',
        '61475' => 'IL',
        '61476' => 'IL',
        '61477' => 'IL',
        '61478' => 'IL',
        '61479' => 'IL',
        '61480' => 'IL',
        '61482' => 'IL',
        '61483' => 'IL',
        '61484' => 'IL',
        '61485' => 'IL',
        '61486' => 'IL',
        '61488' => 'IL',
        '61489' => 'IL',
        '61490' => 'IL',
        '61491' => 'IL',
        '61501' => 'IL',
        '61516' => 'IL',
        '61517' => 'IL',
        '61519' => 'IL',
        '61520' => 'IL',
        '61523' => 'IL',
        '61524' => 'IL',
        '61525' => 'IL',
        '61526' => 'IL',
        '61528' => 'IL',
        '61529' => 'IL',
        '61530' => 'IL',
        '61531' => 'IL',
        '61532' => 'IL',
        '61533' => 'IL',
        '61534' => 'IL',
        '61535' => 'IL',
        '61536' => 'IL',
        '61537' => 'IL',
        '61539' => 'IL',
        '61540' => 'IL',
        '61541' => 'IL',
        '61542' => 'IL',
        '61543' => 'IL',
        '61544' => 'IL',
        '61545' => 'IL',
        '61546' => 'IL',
        '61547' => 'IL',
        '61548' => 'IL',
        '61550' => 'IL',
        '61552' => 'IL',
        '61553' => 'IL',
        '61554' => 'IL',
        '61559' => 'IL',
        '61560' => 'IL',
        '61561' => 'IL',
        '61562' => 'IL',
        '61563' => 'IL',
        '61564' => 'IL',
        '61565' => 'IL',
        '61567' => 'IL',
        '61568' => 'IL',
        '61569' => 'IL',
        '61570' => 'IL',
        '61571' => 'IL',
        '61572' => 'IL',
        '61602' => 'IL',
        '61603' => 'IL',
        '61604' => 'IL',
        '61605' => 'IL',
        '61606' => 'IL',
        '61607' => 'IL',
        '61610' => 'IL',
        '61611' => 'IL',
        '61614' => 'IL',
        '61615' => 'IL',
        '61616' => 'IL',
        '61625' => 'IL',
        '61701' => 'IL',
        '61704' => 'IL',
        '61705' => 'IL',
        '61720' => 'IL',
        '61721' => 'IL',
        '61722' => 'IL',
        '61723' => 'IL',
        '61724' => 'IL',
        '61725' => 'IL',
        '61726' => 'IL',
        '61727' => 'IL',
        '61728' => 'IL',
        '61729' => 'IL',
        '61730' => 'IL',
        '61731' => 'IL',
        '61732' => 'IL',
        '61733' => 'IL',
        '61734' => 'IL',
        '61735' => 'IL',
        '61736' => 'IL',
        '61737' => 'IL',
        '61738' => 'IL',
        '61739' => 'IL',
        '61740' => 'IL',
        '61741' => 'IL',
        '61742' => 'IL',
        '61743' => 'IL',
        '61744' => 'IL',
        '61745' => 'IL',
        '61747' => 'IL',
        '61748' => 'IL',
        '61749' => 'IL',
        '61750' => 'IL',
        '61751' => 'IL',
        '61752' => 'IL',
        '61753' => 'IL',
        '61754' => 'IL',
        '61755' => 'IL',
        '61756' => 'IL',
        '61759' => 'IL',
        '61760' => 'IL',
        '61761' => 'IL',
        '61764' => 'IL',
        '61769' => 'IL',
        '61770' => 'IL',
        '61771' => 'IL',
        '61772' => 'IL',
        '61773' => 'IL',
        '61774' => 'IL',
        '61775' => 'IL',
        '61776' => 'IL',
        '61777' => 'IL',
        '61778' => 'IL',
        '61801' => 'IL',
        '61802' => 'IL',
        '61810' => 'IL',
        '61811' => 'IL',
        '61812' => 'IL',
        '61813' => 'IL',
        '61814' => 'IL',
        '61815' => 'IL',
        '61816' => 'IL',
        '61817' => 'IL',
        '61818' => 'IL',
        '61820' => 'IL',
        '61821' => 'IL',
        '61822' => 'IL',
        '61830' => 'IL',
        '61831' => 'IL',
        '61832' => 'IL',
        '61833' => 'IL',
        '61834' => 'IL',
        '61839' => 'IL',
        '61840' => 'IL',
        '61841' => 'IL',
        '61842' => 'IL',
        '61843' => 'IL',
        '61844' => 'IL',
        '61845' => 'IL',
        '61846' => 'IL',
        '61847' => 'IL',
        '61848' => 'IL',
        '61849' => 'IL',
        '61850' => 'IL',
        '61851' => 'IL',
        '61852' => 'IL',
        '61853' => 'IL',
        '61854' => 'IL',
        '61855' => 'IL',
        '61856' => 'IL',
        '61857' => 'IL',
        '61858' => 'IL',
        '61859' => 'IL',
        '61862' => 'IL',
        '61863' => 'IL',
        '61864' => 'IL',
        '61865' => 'IL',
        '61866' => 'IL',
        '61870' => 'IL',
        '61871' => 'IL',
        '61872' => 'IL',
        '61873' => 'IL',
        '61874' => 'IL',
        '61875' => 'IL',
        '61876' => 'IL',
        '61877' => 'IL',
        '61878' => 'IL',
        '61880' => 'IL',
        '61882' => 'IL',
        '61883' => 'IL',
        '61884' => 'IL',
        '61910' => 'IL',
        '61911' => 'IL',
        '61912' => 'IL',
        '61913' => 'IL',
        '61914' => 'IL',
        '61917' => 'IL',
        '61919' => 'IL',
        '61920' => 'IL',
        '61924' => 'IL',
        '61925' => 'IL',
        '61928' => 'IL',
        '61929' => 'IL',
        '61930' => 'IL',
        '61931' => 'IL',
        '61932' => 'IL',
        '61933' => 'IL',
        '61936' => 'IL',
        '61937' => 'IL',
        '61938' => 'IL',
        '61940' => 'IL',
        '61941' => 'IL',
        '61942' => 'IL',
        '61943' => 'IL',
        '61944' => 'IL',
        '61949' => 'IL',
        '61951' => 'IL',
        '61953' => 'IL',
        '61955' => 'IL',
        '61956' => 'IL',
        '61957' => 'IL',
        '62001' => 'IL',
        '62002' => 'IL',
        '62006' => 'IL',
        '62009' => 'IL',
        '62010' => 'IL',
        '62011' => 'IL',
        '62012' => 'IL',
        '62013' => 'IL',
        '62014' => 'IL',
        '62015' => 'IL',
        '62016' => 'IL',
        '62017' => 'IL',
        '62018' => 'IL',
        '62019' => 'IL',
        '62021' => 'IL',
        '62022' => 'IL',
        '62023' => 'IL',
        '62024' => 'IL',
        '62025' => 'IL',
        '62026' => 'IL',
        '62027' => 'IL',
        '62028' => 'IL',
        '62030' => 'IL',
        '62031' => 'IL',
        '62032' => 'IL',
        '62033' => 'IL',
        '62034' => 'IL',
        '62035' => 'IL',
        '62036' => 'IL',
        '62037' => 'IL',
        '62040' => 'IL',
        '62044' => 'IL',
        '62045' => 'IL',
        '62046' => 'IL',
        '62047' => 'IL',
        '62048' => 'IL',
        '62049' => 'IL',
        '62050' => 'IL',
        '62051' => 'IL',
        '62052' => 'IL',
        '62053' => 'IL',
        '62054' => 'IL',
        '62056' => 'IL',
        '62058' => 'IL',
        '62059' => 'IL',
        '62060' => 'IL',
        '62061' => 'IL',
        '62062' => 'IL',
        '62063' => 'IL',
        '62067' => 'IL',
        '62069' => 'IL',
        '62074' => 'IL',
        '62075' => 'IL',
        '62076' => 'IL',
        '62077' => 'IL',
        '62078' => 'IL',
        '62079' => 'IL',
        '62080' => 'IL',
        '62081' => 'IL',
        '62082' => 'IL',
        '62083' => 'IL',
        '62084' => 'IL',
        '62085' => 'IL',
        '62086' => 'IL',
        '62087' => 'IL',
        '62088' => 'IL',
        '62089' => 'IL',
        '62090' => 'IL',
        '62091' => 'IL',
        '62092' => 'IL',
        '62093' => 'IL',
        '62094' => 'IL',
        '62095' => 'IL',
        '62097' => 'IL',
        '62098' => 'IL',
        '62201' => 'IL',
        '62203' => 'IL',
        '62204' => 'IL',
        '62205' => 'IL',
        '62206' => 'IL',
        '62207' => 'IL',
        '62208' => 'IL',
        '62214' => 'IL',
        '62215' => 'IL',
        '62216' => 'IL',
        '62217' => 'IL',
        '62218' => 'IL',
        '62219' => 'IL',
        '62220' => 'IL',
        '62221' => 'IL',
        '62223' => 'IL',
        '62225' => 'IL',
        '62226' => 'IL',
        '62230' => 'IL',
        '62231' => 'IL',
        '62232' => 'IL',
        '62233' => 'IL',
        '62234' => 'IL',
        '62236' => 'IL',
        '62237' => 'IL',
        '62238' => 'IL',
        '62239' => 'IL',
        '62240' => 'IL',
        '62241' => 'IL',
        '62242' => 'IL',
        '62243' => 'IL',
        '62244' => 'IL',
        '62245' => 'IL',
        '62246' => 'IL',
        '62248' => 'IL',
        '62249' => 'IL',
        '62250' => 'IL',
        '62253' => 'IL',
        '62254' => 'IL',
        '62255' => 'IL',
        '62256' => 'IL',
        '62257' => 'IL',
        '62258' => 'IL',
        '62260' => 'IL',
        '62261' => 'IL',
        '62262' => 'IL',
        '62263' => 'IL',
        '62264' => 'IL',
        '62265' => 'IL',
        '62266' => 'IL',
        '62268' => 'IL',
        '62269' => 'IL',
        '62271' => 'IL',
        '62272' => 'IL',
        '62273' => 'IL',
        '62274' => 'IL',
        '62275' => 'IL',
        '62277' => 'IL',
        '62278' => 'IL',
        '62279' => 'IL',
        '62280' => 'IL',
        '62281' => 'IL',
        '62282' => 'IL',
        '62284' => 'IL',
        '62285' => 'IL',
        '62286' => 'IL',
        '62288' => 'IL',
        '62289' => 'IL',
        '62292' => 'IL',
        '62293' => 'IL',
        '62294' => 'IL',
        '62295' => 'IL',
        '62297' => 'IL',
        '62298' => 'IL',
        '62301' => 'IL',
        '62305' => 'IL',
        '62311' => 'IL',
        '62312' => 'IL',
        '62313' => 'IL',
        '62314' => 'IL',
        '62316' => 'IL',
        '62319' => 'IL',
        '62320' => 'IL',
        '62321' => 'IL',
        '62323' => 'IL',
        '62324' => 'IL',
        '62325' => 'IL',
        '62326' => 'IL',
        '62330' => 'IL',
        '62334' => 'IL',
        '62336' => 'IL',
        '62338' => 'IL',
        '62339' => 'IL',
        '62340' => 'IL',
        '62341' => 'IL',
        '62343' => 'IL',
        '62344' => 'IL',
        '62345' => 'IL',
        '62346' => 'IL',
        '62347' => 'IL',
        '62348' => 'IL',
        '62349' => 'IL',
        '62351' => 'IL',
        '62352' => 'IL',
        '62353' => 'IL',
        '62354' => 'IL',
        '62355' => 'IL',
        '62356' => 'IL',
        '62357' => 'IL',
        '62358' => 'IL',
        '62359' => 'IL',
        '62360' => 'IL',
        '62361' => 'IL',
        '62362' => 'IL',
        '62363' => 'IL',
        '62365' => 'IL',
        '62366' => 'IL',
        '62367' => 'IL',
        '62370' => 'IL',
        '62373' => 'IL',
        '62374' => 'IL',
        '62375' => 'IL',
        '62376' => 'IL',
        '62378' => 'IL',
        '62379' => 'IL',
        '62380' => 'IL',
        '62401' => 'IL',
        '62410' => 'IL',
        '62411' => 'IL',
        '62413' => 'IL',
        '62414' => 'IL',
        '62417' => 'IL',
        '62418' => 'IL',
        '62419' => 'IL',
        '62420' => 'IL',
        '62421' => 'IL',
        '62422' => 'IL',
        '62423' => 'IL',
        '62424' => 'IL',
        '62425' => 'IL',
        '62426' => 'IL',
        '62427' => 'IL',
        '62428' => 'IL',
        '62431' => 'IL',
        '62432' => 'IL',
        '62433' => 'IL',
        '62434' => 'IL',
        '62436' => 'IL',
        '62438' => 'IL',
        '62439' => 'IL',
        '62440' => 'IL',
        '62441' => 'IL',
        '62442' => 'IL',
        '62443' => 'IL',
        '62444' => 'IL',
        '62445' => 'IL',
        '62446' => 'IL',
        '62447' => 'IL',
        '62448' => 'IL',
        '62449' => 'IL',
        '62450' => 'IL',
        '62451' => 'IL',
        '62452' => 'IL',
        '62454' => 'IL',
        '62458' => 'IL',
        '62459' => 'IL',
        '62460' => 'IL',
        '62461' => 'IL',
        '62462' => 'IL',
        '62463' => 'IL',
        '62464' => 'IL',
        '62465' => 'IL',
        '62466' => 'IL',
        '62467' => 'IL',
        '62468' => 'IL',
        '62469' => 'IL',
        '62471' => 'IL',
        '62473' => 'IL',
        '62474' => 'IL',
        '62475' => 'IL',
        '62476' => 'IL',
        '62477' => 'IL',
        '62478' => 'IL',
        '62479' => 'IL',
        '62480' => 'IL',
        '62481' => 'IL',
        '62501' => 'IL',
        '62510' => 'IL',
        '62512' => 'IL',
        '62513' => 'IL',
        '62514' => 'IL',
        '62515' => 'IL',
        '62517' => 'IL',
        '62518' => 'IL',
        '62519' => 'IL',
        '62520' => 'IL',
        '62521' => 'IL',
        '62522' => 'IL',
        '62523' => 'IL',
        '62526' => 'IL',
        '62530' => 'IL',
        '62531' => 'IL',
        '62532' => 'IL',
        '62533' => 'IL',
        '62534' => 'IL',
        '62535' => 'IL',
        '62536' => 'IL',
        '62537' => 'IL',
        '62538' => 'IL',
        '62539' => 'IL',
        '62540' => 'IL',
        '62541' => 'IL',
        '62543' => 'IL',
        '62544' => 'IL',
        '62545' => 'IL',
        '62546' => 'IL',
        '62547' => 'IL',
        '62548' => 'IL',
        '62549' => 'IL',
        '62550' => 'IL',
        '62551' => 'IL',
        '62553' => 'IL',
        '62554' => 'IL',
        '62555' => 'IL',
        '62556' => 'IL',
        '62557' => 'IL',
        '62558' => 'IL',
        '62560' => 'IL',
        '62561' => 'IL',
        '62563' => 'IL',
        '62565' => 'IL',
        '62567' => 'IL',
        '62568' => 'IL',
        '62570' => 'IL',
        '62571' => 'IL',
        '62572' => 'IL',
        '62573' => 'IL',
        '62601' => 'IL',
        '62610' => 'IL',
        '62611' => 'IL',
        '62612' => 'IL',
        '62613' => 'IL',
        '62615' => 'IL',
        '62617' => 'IL',
        '62618' => 'IL',
        '62621' => 'IL',
        '62622' => 'IL',
        '62624' => 'IL',
        '62625' => 'IL',
        '62626' => 'IL',
        '62627' => 'IL',
        '62628' => 'IL',
        '62629' => 'IL',
        '62630' => 'IL',
        '62631' => 'IL',
        '62633' => 'IL',
        '62634' => 'IL',
        '62635' => 'IL',
        '62638' => 'IL',
        '62639' => 'IL',
        '62640' => 'IL',
        '62642' => 'IL',
        '62643' => 'IL',
        '62644' => 'IL',
        '62649' => 'IL',
        '62650' => 'IL',
        '62655' => 'IL',
        '62656' => 'IL',
        '62661' => 'IL',
        '62663' => 'IL',
        '62664' => 'IL',
        '62665' => 'IL',
        '62666' => 'IL',
        '62667' => 'IL',
        '62668' => 'IL',
        '62670' => 'IL',
        '62671' => 'IL',
        '62672' => 'IL',
        '62673' => 'IL',
        '62674' => 'IL',
        '62675' => 'IL',
        '62677' => 'IL',
        '62681' => 'IL',
        '62682' => 'IL',
        '62684' => 'IL',
        '62685' => 'IL',
        '62688' => 'IL',
        '62689' => 'IL',
        '62690' => 'IL',
        '62691' => 'IL',
        '62692' => 'IL',
        '62693' => 'IL',
        '62694' => 'IL',
        '62695' => 'IL',
        '62701' => 'IL',
        '62702' => 'IL',
        '62703' => 'IL',
        '62704' => 'IL',
        '62706' => 'IL',
        '62707' => 'IL',
        '62711' => 'IL',
        '62712' => 'IL',
        '62801' => 'IL',
        '62803' => 'IL',
        '62806' => 'IL',
        '62807' => 'IL',
        '62808' => 'IL',
        '62809' => 'IL',
        '62810' => 'IL',
        '62811' => 'IL',
        '62812' => 'IL',
        '62814' => 'IL',
        '62815' => 'IL',
        '62816' => 'IL',
        '62817' => 'IL',
        '62818' => 'IL',
        '62819' => 'IL',
        '62820' => 'IL',
        '62821' => 'IL',
        '62822' => 'IL',
        '62823' => 'IL',
        '62824' => 'IL',
        '62825' => 'IL',
        '62827' => 'IL',
        '62828' => 'IL',
        '62829' => 'IL',
        '62830' => 'IL',
        '62831' => 'IL',
        '62832' => 'IL',
        '62833' => 'IL',
        '62835' => 'IL',
        '62836' => 'IL',
        '62837' => 'IL',
        '62838' => 'IL',
        '62839' => 'IL',
        '62841' => 'IL',
        '62842' => 'IL',
        '62843' => 'IL',
        '62844' => 'IL',
        '62846' => 'IL',
        '62848' => 'IL',
        '62849' => 'IL',
        '62850' => 'IL',
        '62851' => 'IL',
        '62852' => 'IL',
        '62853' => 'IL',
        '62854' => 'IL',
        '62856' => 'IL',
        '62858' => 'IL',
        '62859' => 'IL',
        '62860' => 'IL',
        '62861' => 'IL',
        '62862' => 'IL',
        '62863' => 'IL',
        '62864' => 'IL',
        '62865' => 'IL',
        '62867' => 'IL',
        '62868' => 'IL',
        '62869' => 'IL',
        '62870' => 'IL',
        '62871' => 'IL',
        '62872' => 'IL',
        '62874' => 'IL',
        '62875' => 'IL',
        '62876' => 'IL',
        '62877' => 'IL',
        '62878' => 'IL',
        '62879' => 'IL',
        '62880' => 'IL',
        '62881' => 'IL',
        '62882' => 'IL',
        '62883' => 'IL',
        '62884' => 'IL',
        '62885' => 'IL',
        '62886' => 'IL',
        '62887' => 'IL',
        '62888' => 'IL',
        '62889' => 'IL',
        '62890' => 'IL',
        '62891' => 'IL',
        '62892' => 'IL',
        '62893' => 'IL',
        '62894' => 'IL',
        '62895' => 'IL',
        '62896' => 'IL',
        '62897' => 'IL',
        '62898' => 'IL',
        '62899' => 'IL',
        '62901' => 'IL',
        '62902' => 'IL',
        '62903' => 'IL',
        '62905' => 'IL',
        '62906' => 'IL',
        '62907' => 'IL',
        '62908' => 'IL',
        '62910' => 'IL',
        '62912' => 'IL',
        '62914' => 'IL',
        '62915' => 'IL',
        '62916' => 'IL',
        '62917' => 'IL',
        '62918' => 'IL',
        '62919' => 'IL',
        '62920' => 'IL',
        '62921' => 'IL',
        '62922' => 'IL',
        '62923' => 'IL',
        '62924' => 'IL',
        '62926' => 'IL',
        '62927' => 'IL',
        '62928' => 'IL',
        '62930' => 'IL',
        '62931' => 'IL',
        '62932' => 'IL',
        '62933' => 'IL',
        '62934' => 'IL',
        '62935' => 'IL',
        '62938' => 'IL',
        '62939' => 'IL',
        '62940' => 'IL',
        '62941' => 'IL',
        '62942' => 'IL',
        '62943' => 'IL',
        '62946' => 'IL',
        '62947' => 'IL',
        '62948' => 'IL',
        '62949' => 'IL',
        '62950' => 'IL',
        '62951' => 'IL',
        '62952' => 'IL',
        '62953' => 'IL',
        '62954' => 'IL',
        '62956' => 'IL',
        '62957' => 'IL',
        '62958' => 'IL',
        '62959' => 'IL',
        '62960' => 'IL',
        '62961' => 'IL',
        '62962' => 'IL',
        '62963' => 'IL',
        '62964' => 'IL',
        '62965' => 'IL',
        '62966' => 'IL',
        '62967' => 'IL',
        '62969' => 'IL',
        '62970' => 'IL',
        '62972' => 'IL',
        '62974' => 'IL',
        '62975' => 'IL',
        '62976' => 'IL',
        '62977' => 'IL',
        '62979' => 'IL',
        '62982' => 'IL',
        '62983' => 'IL',
        '62984' => 'IL',
        '62985' => 'IL',
        '62987' => 'IL',
        '62988' => 'IL',
        '62990' => 'IL',
        '62992' => 'IL',
        '62994' => 'IL',
        '62995' => 'IL',
        '62996' => 'IL',
        '62997' => 'IL',
        '62998' => 'IL',
        '62999' => 'IL',
        '63005' => 'MO',
        '63010' => 'MO',
        '63011' => 'MO',
        '63012' => 'MO',
        '63013' => 'MO',
        '63014' => 'MO',
        '63015' => 'MO',
        '63016' => 'MO',
        '63017' => 'MO',
        '63019' => 'MO',
        '63020' => 'MO',
        '63021' => 'MO',
        '63023' => 'MO',
        '63025' => 'MO',
        '63026' => 'MO',
        '63028' => 'MO',
        '63030' => 'MO',
        '63031' => 'MO',
        '63033' => 'MO',
        '63034' => 'MO',
        '63036' => 'MO',
        '63037' => 'MO',
        '63038' => 'MO',
        '63039' => 'MO',
        '63040' => 'MO',
        '63041' => 'MO',
        '63042' => 'MO',
        '63043' => 'MO',
        '63044' => 'MO',
        '63045' => 'MO',
        '63047' => 'MO',
        '63048' => 'MO',
        '63049' => 'MO',
        '63050' => 'MO',
        '63051' => 'MO',
        '63052' => 'MO',
        '63053' => 'MO',
        '63055' => 'MO',
        '63056' => 'MO',
        '63060' => 'MO',
        '63061' => 'MO',
        '63068' => 'MO',
        '63069' => 'MO',
        '63070' => 'MO',
        '63071' => 'MO',
        '63072' => 'MO',
        '63073' => 'MO',
        '63074' => 'MO',
        '63077' => 'MO',
        '63079' => 'MO',
        '63080' => 'MO',
        '63084' => 'MO',
        '63087' => 'MO',
        '63088' => 'MO',
        '63089' => 'MO',
        '63090' => 'MO',
        '63091' => 'MO',
        '63101' => 'MO',
        '63102' => 'MO',
        '63103' => 'MO',
        '63104' => 'MO',
        '63105' => 'MO',
        '63106' => 'MO',
        '63107' => 'MO',
        '63108' => 'MO',
        '63109' => 'MO',
        '63110' => 'MO',
        '63111' => 'MO',
        '63112' => 'MO',
        '63113' => 'MO',
        '63114' => 'MO',
        '63115' => 'MO',
        '63116' => 'MO',
        '63117' => 'MO',
        '63118' => 'MO',
        '63119' => 'MO',
        '63120' => 'MO',
        '63121' => 'MO',
        '63122' => 'MO',
        '63123' => 'MO',
        '63124' => 'MO',
        '63125' => 'MO',
        '63126' => 'MO',
        '63127' => 'MO',
        '63128' => 'MO',
        '63129' => 'MO',
        '63130' => 'MO',
        '63131' => 'MO',
        '63132' => 'MO',
        '63133' => 'MO',
        '63134' => 'MO',
        '63135' => 'MO',
        '63136' => 'MO',
        '63137' => 'MO',
        '63138' => 'MO',
        '63139' => 'MO',
        '63140' => 'MO',
        '63141' => 'MO',
        '63143' => 'MO',
        '63144' => 'MO',
        '63146' => 'MO',
        '63147' => 'MO',
        '63155' => 'MO',
        '63301' => 'MO',
        '63303' => 'MO',
        '63304' => 'MO',
        '63330' => 'MO',
        '63332' => 'MO',
        '63333' => 'MO',
        '63334' => 'MO',
        '63336' => 'MO',
        '63339' => 'MO',
        '63341' => 'MO',
        '63343' => 'MO',
        '63344' => 'MO',
        '63345' => 'MO',
        '63347' => 'MO',
        '63348' => 'MO',
        '63349' => 'MO',
        '63350' => 'MO',
        '63351' => 'MO',
        '63352' => 'MO',
        '63353' => 'MO',
        '63357' => 'MO',
        '63359' => 'MO',
        '63361' => 'MO',
        '63362' => 'MO',
        '63363' => 'MO',
        '63365' => 'MO',
        '63366' => 'MO',
        '63367' => 'MO',
        '63368' => 'MO',
        '63369' => 'MO',
        '63373' => 'MO',
        '63376' => 'MO',
        '63377' => 'MO',
        '63379' => 'MO',
        '63380' => 'MO',
        '63381' => 'MO',
        '63382' => 'MO',
        '63383' => 'MO',
        '63384' => 'MO',
        '63385' => 'MO',
        '63386' => 'MO',
        '63387' => 'MO',
        '63388' => 'MO',
        '63389' => 'MO',
        '63390' => 'MO',
        '63401' => 'MO',
        '63430' => 'MO',
        '63431' => 'MO',
        '63432' => 'MO',
        '63433' => 'MO',
        '63434' => 'MO',
        '63435' => 'MO',
        '63436' => 'MO',
        '63437' => 'MO',
        '63438' => 'MO',
        '63439' => 'MO',
        '63440' => 'MO',
        '63441' => 'MO',
        '63443' => 'MO',
        '63445' => 'MO',
        '63446' => 'MO',
        '63447' => 'MO',
        '63448' => 'MO',
        '63450' => 'MO',
        '63451' => 'MO',
        '63452' => 'MO',
        '63453' => 'MO',
        '63454' => 'MO',
        '63456' => 'MO',
        '63457' => 'MO',
        '63458' => 'MO',
        '63459' => 'MO',
        '63460' => 'MO',
        '63461' => 'MO',
        '63462' => 'MO',
        '63463' => 'MO',
        '63465' => 'MO',
        '63466' => 'MO',
        '63467' => 'MO',
        '63468' => 'MO',
        '63469' => 'MO',
        '63471' => 'MO',
        '63472' => 'MO',
        '63473' => 'MO',
        '63474' => 'MO',
        '63501' => 'MO',
        '63530' => 'MO',
        '63531' => 'MO',
        '63532' => 'MO',
        '63533' => 'MO',
        '63534' => 'MO',
        '63535' => 'MO',
        '63536' => 'MO',
        '63537' => 'MO',
        '63538' => 'MO',
        '63539' => 'MO',
        '63540' => 'MO',
        '63541' => 'MO',
        '63543' => 'MO',
        '63544' => 'MO',
        '63545' => 'MO',
        '63546' => 'MO',
        '63547' => 'MO',
        '63548' => 'MO',
        '63549' => 'MO',
        '63551' => 'MO',
        '63552' => 'MO',
        '63555' => 'MO',
        '63556' => 'MO',
        '63557' => 'MO',
        '63558' => 'MO',
        '63559' => 'MO',
        '63560' => 'MO',
        '63561' => 'MO',
        '63563' => 'MO',
        '63565' => 'MO',
        '63566' => 'MO',
        '63567' => 'MO',
        '63601' => 'MO',
        '63620' => 'MO',
        '63621' => 'MO',
        '63622' => 'MO',
        '63623' => 'MO',
        '63624' => 'MO',
        '63625' => 'MO',
        '63626' => 'MO',
        '63627' => 'MO',
        '63628' => 'MO',
        '63629' => 'MO',
        '63630' => 'MO',
        '63631' => 'MO',
        '63633' => 'MO',
        '63636' => 'MO',
        '63637' => 'MO',
        '63638' => 'MO',
        '63640' => 'MO',
        '63645' => 'MO',
        '63648' => 'MO',
        '63650' => 'MO',
        '63653' => 'MO',
        '63654' => 'MO',
        '63655' => 'MO',
        '63656' => 'MO',
        '63660' => 'MO',
        '63662' => 'MO',
        '63663' => 'MO',
        '63664' => 'MO',
        '63665' => 'MO',
        '63670' => 'MO',
        '63673' => 'MO',
        '63674' => 'MO',
        '63675' => 'MO',
        '63701' => 'MO',
        '63703' => 'MO',
        '63730' => 'MO',
        '63732' => 'MO',
        '63735' => 'MO',
        '63736' => 'MO',
        '63738' => 'MO',
        '63739' => 'MO',
        '63740' => 'MO',
        '63742' => 'MO',
        '63743' => 'MO',
        '63744' => 'MO',
        '63745' => 'MO',
        '63746' => 'MO',
        '63747' => 'MO',
        '63748' => 'MO',
        '63750' => 'MO',
        '63751' => 'MO',
        '63755' => 'MO',
        '63758' => 'MO',
        '63760' => 'MO',
        '63763' => 'MO',
        '63764' => 'MO',
        '63766' => 'MO',
        '63767' => 'MO',
        '63769' => 'MO',
        '63770' => 'MO',
        '63771' => 'MO',
        '63774' => 'MO',
        '63775' => 'MO',
        '63780' => 'MO',
        '63781' => 'MO',
        '63782' => 'MO',
        '63783' => 'MO',
        '63784' => 'MO',
        '63785' => 'MO',
        '63787' => 'MO',
        '63801' => 'MO',
        '63820' => 'MO',
        '63821' => 'MO',
        '63822' => 'MO',
        '63823' => 'MO',
        '63824' => 'MO',
        '63825' => 'MO',
        '63826' => 'MO',
        '63827' => 'MO',
        '63828' => 'MO',
        '63829' => 'MO',
        '63830' => 'MO',
        '63833' => 'MO',
        '63834' => 'MO',
        '63837' => 'MO',
        '63839' => 'MO',
        '63840' => 'MO',
        '63841' => 'MO',
        '63845' => 'MO',
        '63846' => 'MO',
        '63847' => 'MO',
        '63848' => 'MO',
        '63849' => 'MO',
        '63850' => 'MO',
        '63851' => 'MO',
        '63852' => 'MO',
        '63853' => 'MO',
        '63855' => 'MO',
        '63857' => 'MO',
        '63860' => 'MO',
        '63862' => 'MO',
        '63863' => 'MO',
        '63866' => 'MO',
        '63867' => 'MO',
        '63868' => 'MO',
        '63869' => 'MO',
        '63870' => 'MO',
        '63873' => 'MO',
        '63874' => 'MO',
        '63876' => 'MO',
        '63877' => 'MO',
        '63878' => 'MO',
        '63879' => 'MO',
        '63880' => 'MO',
        '63882' => 'MO',
        '63901' => 'MO',
        '63932' => 'MO',
        '63933' => 'MO',
        '63934' => 'MO',
        '63935' => 'MO',
        '63936' => 'MO',
        '63937' => 'MO',
        '63939' => 'MO',
        '63940' => 'MO',
        '63941' => 'MO',
        '63942' => 'MO',
        '63943' => 'MO',
        '63944' => 'MO',
        '63945' => 'MO',
        '63950' => 'MO',
        '63951' => 'MO',
        '63952' => 'MO',
        '63953' => 'MO',
        '63954' => 'MO',
        '63955' => 'MO',
        '63956' => 'MO',
        '63957' => 'MO',
        '63960' => 'MO',
        '63961' => 'MO',
        '63962' => 'MO',
        '63964' => 'MO',
        '63965' => 'MO',
        '63966' => 'MO',
        '63967' => 'MO',
        '64001' => 'MO',
        '64011' => 'MO',
        '64012' => 'MO',
        '64014' => 'MO',
        '64015' => 'MO',
        '64016' => 'MO',
        '64017' => 'MO',
        '64018' => 'MO',
        '64019' => 'MO',
        '64020' => 'MO',
        '64021' => 'MO',
        '64022' => 'MO',
        '64024' => 'MO',
        '64028' => 'MO',
        '64029' => 'MO',
        '64030' => 'MO',
        '64034' => 'MO',
        '64035' => 'MO',
        '64036' => 'MO',
        '64037' => 'MO',
        '64040' => 'MO',
        '64048' => 'MO',
        '64050' => 'MO',
        '64052' => 'MO',
        '64053' => 'MO',
        '64054' => 'MO',
        '64055' => 'MO',
        '64056' => 'MO',
        '64057' => 'MO',
        '64058' => 'MO',
        '64060' => 'MO',
        '64061' => 'MO',
        '64062' => 'MO',
        '64063' => 'MO',
        '64064' => 'MO',
        '64065' => 'MO',
        '64066' => 'MO',
        '64067' => 'MO',
        '64068' => 'MO',
        '64070' => 'MO',
        '64071' => 'MO',
        '64072' => 'MO',
        '64074' => 'MO',
        '64075' => 'MO',
        '64076' => 'MO',
        '64077' => 'MO',
        '64078' => 'MO',
        '64079' => 'MO',
        '64080' => 'MO',
        '64081' => 'MO',
        '64082' => 'MO',
        '64083' => 'MO',
        '64084' => 'MO',
        '64085' => 'MO',
        '64086' => 'MO',
        '64088' => 'MO',
        '64089' => 'MO',
        '64090' => 'MO',
        '64092' => 'MO',
        '64093' => 'MO',
        '64096' => 'MO',
        '64097' => 'MO',
        '64098' => 'MO',
        '64101' => 'MO',
        '64102' => 'MO',
        '64105' => 'MO',
        '64106' => 'MO',
        '64108' => 'MO',
        '64109' => 'MO',
        '64110' => 'MO',
        '64111' => 'MO',
        '64112' => 'MO',
        '64113' => 'MO',
        '64114' => 'MO',
        '64116' => 'MO',
        '64117' => 'MO',
        '64118' => 'MO',
        '64119' => 'MO',
        '64120' => 'MO',
        '64123' => 'MO',
        '64124' => 'MO',
        '64125' => 'MO',
        '64126' => 'MO',
        '64127' => 'MO',
        '64128' => 'MO',
        '64129' => 'MO',
        '64130' => 'MO',
        '64131' => 'MO',
        '64132' => 'MO',
        '64133' => 'MO',
        '64134' => 'MO',
        '64136' => 'MO',
        '64137' => 'MO',
        '64138' => 'MO',
        '64139' => 'MO',
        '64145' => 'MO',
        '64146' => 'MO',
        '64147' => 'MO',
        '64149' => 'MO',
        '64150' => 'MO',
        '64151' => 'MO',
        '64152' => 'MO',
        '64153' => 'MO',
        '64154' => 'MO',
        '64155' => 'MO',
        '64156' => 'MO',
        '64157' => 'MO',
        '64158' => 'MO',
        '64161' => 'MO',
        '64163' => 'MO',
        '64164' => 'MO',
        '64165' => 'MO',
        '64166' => 'MO',
        '64167' => 'MO',
        '64401' => 'MO',
        '64402' => 'MO',
        '64420' => 'MO',
        '64421' => 'MO',
        '64422' => 'MO',
        '64423' => 'MO',
        '64424' => 'MO',
        '64426' => 'MO',
        '64427' => 'MO',
        '64428' => 'MO',
        '64429' => 'MO',
        '64430' => 'MO',
        '64431' => 'MO',
        '64432' => 'MO',
        '64433' => 'MO',
        '64434' => 'MO',
        '64436' => 'MO',
        '64437' => 'MO',
        '64438' => 'MO',
        '64439' => 'MO',
        '64440' => 'MO',
        '64441' => 'MO',
        '64442' => 'MO',
        '64443' => 'MO',
        '64444' => 'MO',
        '64445' => 'MO',
        '64446' => 'MO',
        '64448' => 'MO',
        '64449' => 'MO',
        '64451' => 'MO',
        '64453' => 'MO',
        '64454' => 'MO',
        '64455' => 'MO',
        '64456' => 'MO',
        '64457' => 'MO',
        '64458' => 'MO',
        '64459' => 'MO',
        '64461' => 'MO',
        '64463' => 'MO',
        '64465' => 'MO',
        '64466' => 'MO',
        '64467' => 'MO',
        '64468' => 'MO',
        '64469' => 'MO',
        '64470' => 'MO',
        '64471' => 'MO',
        '64473' => 'MO',
        '64474' => 'MO',
        '64475' => 'MO',
        '64476' => 'MO',
        '64477' => 'MO',
        '64479' => 'MO',
        '64480' => 'MO',
        '64481' => 'MO',
        '64482' => 'MO',
        '64483' => 'MO',
        '64484' => 'MO',
        '64485' => 'MO',
        '64486' => 'MO',
        '64487' => 'MO',
        '64489' => 'MO',
        '64490' => 'MO',
        '64491' => 'MO',
        '64492' => 'MO',
        '64493' => 'MO',
        '64494' => 'MO',
        '64496' => 'MO',
        '64497' => 'MO',
        '64498' => 'MO',
        '64499' => 'MO',
        '64501' => 'MO',
        '64503' => 'MO',
        '64504' => 'MO',
        '64505' => 'MO',
        '64506' => 'MO',
        '64507' => 'MO',
        '64601' => 'MO',
        '64620' => 'MO',
        '64622' => 'MO',
        '64623' => 'MO',
        '64624' => 'MO',
        '64625' => 'MO',
        '64628' => 'MO',
        '64630' => 'MO',
        '64631' => 'MO',
        '64632' => 'MO',
        '64633' => 'MO',
        '64635' => 'MO',
        '64636' => 'MO',
        '64637' => 'MO',
        '64638' => 'MO',
        '64639' => 'MO',
        '64640' => 'MO',
        '64641' => 'MO',
        '64642' => 'MO',
        '64643' => 'MO',
        '64644' => 'MO',
        '64645' => 'MO',
        '64646' => 'MO',
        '64647' => 'MO',
        '64648' => 'MO',
        '64649' => 'MO',
        '64650' => 'MO',
        '64651' => 'MO',
        '64652' => 'MO',
        '64653' => 'MO',
        '64654' => 'MO',
        '64655' => 'MO',
        '64656' => 'MO',
        '64657' => 'MO',
        '64658' => 'MO',
        '64659' => 'MO',
        '64660' => 'MO',
        '64661' => 'MO',
        '64664' => 'MO',
        '64667' => 'MO',
        '64668' => 'MO',
        '64670' => 'MO',
        '64671' => 'MO',
        '64672' => 'MO',
        '64673' => 'MO',
        '64674' => 'MO',
        '64676' => 'MO',
        '64679' => 'MO',
        '64681' => 'MO',
        '64682' => 'MO',
        '64683' => 'MO',
        '64686' => 'MO',
        '64688' => 'MO',
        '64689' => 'MO',
        '64701' => 'MO',
        '64720' => 'MO',
        '64722' => 'MO',
        '64723' => 'MO',
        '64724' => 'MO',
        '64725' => 'MO',
        '64726' => 'MO',
        '64728' => 'MO',
        '64730' => 'MO',
        '64733' => 'MO',
        '64734' => 'MO',
        '64735' => 'MO',
        '64738' => 'MO',
        '64739' => 'MO',
        '64740' => 'MO',
        '64741' => 'MO',
        '64742' => 'MO',
        '64743' => 'MO',
        '64744' => 'MO',
        '64745' => 'MO',
        '64746' => 'MO',
        '64747' => 'MO',
        '64748' => 'MO',
        '64750' => 'MO',
        '64752' => 'MO',
        '64755' => 'MO',
        '64756' => 'MO',
        '64759' => 'MO',
        '64761' => 'MO',
        '64762' => 'MO',
        '64763' => 'MO',
        '64765' => 'MO',
        '64767' => 'MO',
        '64769' => 'MO',
        '64770' => 'MO',
        '64771' => 'MO',
        '64772' => 'MO',
        '64776' => 'MO',
        '64778' => 'MO',
        '64779' => 'MO',
        '64780' => 'MO',
        '64781' => 'MO',
        '64783' => 'MO',
        '64784' => 'MO',
        '64788' => 'MO',
        '64790' => 'MO',
        '64801' => 'MO',
        '64804' => 'MO',
        '64830' => 'MO',
        '64831' => 'MO',
        '64832' => 'MO',
        '64833' => 'MO',
        '64834' => 'MO',
        '64835' => 'MO',
        '64836' => 'MO',
        '64840' => 'MO',
        '64841' => 'MO',
        '64842' => 'MO',
        '64843' => 'MO',
        '64844' => 'MO',
        '64847' => 'MO',
        '64848' => 'MO',
        '64849' => 'MO',
        '64850' => 'MO',
        '64854' => 'MO',
        '64855' => 'MO',
        '64856' => 'MO',
        '64857' => 'MO',
        '64858' => 'MO',
        '64859' => 'MO',
        '64861' => 'MO',
        '64862' => 'MO',
        '64863' => 'MO',
        '64865' => 'MO',
        '64866' => 'MO',
        '64867' => 'MO',
        '64868' => 'MO',
        '64870' => 'MO',
        '64873' => 'MO',
        '64874' => 'MO',
        '65001' => 'MO',
        '65010' => 'MO',
        '65011' => 'MO',
        '65013' => 'MO',
        '65014' => 'MO',
        '65016' => 'MO',
        '65017' => 'MO',
        '65018' => 'MO',
        '65020' => 'MO',
        '65023' => 'MO',
        '65024' => 'MO',
        '65025' => 'MO',
        '65026' => 'MO',
        '65032' => 'MO',
        '65034' => 'MO',
        '65035' => 'MO',
        '65037' => 'MO',
        '65039' => 'MO',
        '65040' => 'MO',
        '65041' => 'MO',
        '65043' => 'MO',
        '65046' => 'MO',
        '65047' => 'MO',
        '65048' => 'MO',
        '65049' => 'MO',
        '65050' => 'MO',
        '65051' => 'MO',
        '65052' => 'MO',
        '65053' => 'MO',
        '65054' => 'MO',
        '65058' => 'MO',
        '65059' => 'MO',
        '65061' => 'MO',
        '65062' => 'MO',
        '65063' => 'MO',
        '65064' => 'MO',
        '65065' => 'MO',
        '65066' => 'MO',
        '65067' => 'MO',
        '65068' => 'MO',
        '65069' => 'MO',
        '65072' => 'MO',
        '65074' => 'MO',
        '65075' => 'MO',
        '65076' => 'MO',
        '65077' => 'MO',
        '65078' => 'MO',
        '65079' => 'MO',
        '65080' => 'MO',
        '65081' => 'MO',
        '65082' => 'MO',
        '65083' => 'MO',
        '65084' => 'MO',
        '65085' => 'MO',
        '65101' => 'MO',
        '65109' => 'MO',
        '65201' => 'MO',
        '65202' => 'MO',
        '65203' => 'MO',
        '65215' => 'MO',
        '65216' => 'MO',
        '65230' => 'MO',
        '65231' => 'MO',
        '65232' => 'MO',
        '65233' => 'MO',
        '65236' => 'MO',
        '65237' => 'MO',
        '65239' => 'MO',
        '65240' => 'MO',
        '65243' => 'MO',
        '65244' => 'MO',
        '65246' => 'MO',
        '65247' => 'MO',
        '65248' => 'MO',
        '65250' => 'MO',
        '65251' => 'MO',
        '65254' => 'MO',
        '65255' => 'MO',
        '65256' => 'MO',
        '65257' => 'MO',
        '65258' => 'MO',
        '65259' => 'MO',
        '65260' => 'MO',
        '65261' => 'MO',
        '65262' => 'MO',
        '65263' => 'MO',
        '65264' => 'MO',
        '65265' => 'MO',
        '65270' => 'MO',
        '65274' => 'MO',
        '65275' => 'MO',
        '65276' => 'MO',
        '65278' => 'MO',
        '65279' => 'MO',
        '65280' => 'MO',
        '65281' => 'MO',
        '65282' => 'MO',
        '65283' => 'MO',
        '65284' => 'MO',
        '65285' => 'MO',
        '65286' => 'MO',
        '65287' => 'MO',
        '65301' => 'MO',
        '65305' => 'MO',
        '65320' => 'MO',
        '65321' => 'MO',
        '65322' => 'MO',
        '65323' => 'MO',
        '65324' => 'MO',
        '65325' => 'MO',
        '65326' => 'MO',
        '65327' => 'MO',
        '65329' => 'MO',
        '65330' => 'MO',
        '65332' => 'MO',
        '65333' => 'MO',
        '65334' => 'MO',
        '65335' => 'MO',
        '65336' => 'MO',
        '65337' => 'MO',
        '65338' => 'MO',
        '65339' => 'MO',
        '65340' => 'MO',
        '65344' => 'MO',
        '65345' => 'MO',
        '65347' => 'MO',
        '65348' => 'MO',
        '65349' => 'MO',
        '65350' => 'MO',
        '65351' => 'MO',
        '65354' => 'MO',
        '65355' => 'MO',
        '65360' => 'MO',
        '65401' => 'MO',
        '65409' => 'MO',
        '65436' => 'MO',
        '65438' => 'MO',
        '65439' => 'MO',
        '65440' => 'MO',
        '65441' => 'MO',
        '65443' => 'MO',
        '65444' => 'MO',
        '65446' => 'MO',
        '65449' => 'MO',
        '65452' => 'MO',
        '65453' => 'MO',
        '65456' => 'MO',
        '65457' => 'MO',
        '65459' => 'MO',
        '65461' => 'MO',
        '65462' => 'MO',
        '65463' => 'MO',
        '65464' => 'MO',
        '65466' => 'MO',
        '65468' => 'MO',
        '65470' => 'MO',
        '65473' => 'MO',
        '65479' => 'MO',
        '65483' => 'MO',
        '65484' => 'MO',
        '65486' => 'MO',
        '65501' => 'MO',
        '65529' => 'MO',
        '65534' => 'MO',
        '65535' => 'MO',
        '65536' => 'MO',
        '65541' => 'MO',
        '65542' => 'MO',
        '65543' => 'MO',
        '65548' => 'MO',
        '65550' => 'MO',
        '65552' => 'MO',
        '65555' => 'MO',
        '65556' => 'MO',
        '65557' => 'MO',
        '65559' => 'MO',
        '65560' => 'MO',
        '65564' => 'MO',
        '65565' => 'MO',
        '65566' => 'MO',
        '65567' => 'MO',
        '65570' => 'MO',
        '65571' => 'MO',
        '65580' => 'MO',
        '65582' => 'MO',
        '65583' => 'MO',
        '65584' => 'MO',
        '65586' => 'MO',
        '65588' => 'MO',
        '65589' => 'MO',
        '65590' => 'MO',
        '65591' => 'MO',
        '65601' => 'MO',
        '65603' => 'MO',
        '65604' => 'MO',
        '65605' => 'MO',
        '65606' => 'MO',
        '65608' => 'MO',
        '65609' => 'MO',
        '65610' => 'MO',
        '65611' => 'MO',
        '65612' => 'MO',
        '65613' => 'MO',
        '65614' => 'MO',
        '65616' => 'MO',
        '65617' => 'MO',
        '65618' => 'MO',
        '65619' => 'MO',
        '65620' => 'MO',
        '65622' => 'MO',
        '65623' => 'MO',
        '65624' => 'MO',
        '65625' => 'MO',
        '65626' => 'MO',
        '65627' => 'MO',
        '65629' => 'MO',
        '65630' => 'MO',
        '65631' => 'MO',
        '65632' => 'MO',
        '65633' => 'MO',
        '65634' => 'MO',
        '65635' => 'MO',
        '65637' => 'MO',
        '65638' => 'MO',
        '65640' => 'MO',
        '65641' => 'MO',
        '65644' => 'MO',
        '65646' => 'MO',
        '65647' => 'MO',
        '65648' => 'MO',
        '65649' => 'MO',
        '65650' => 'MO',
        '65652' => 'MO',
        '65653' => 'MO',
        '65654' => 'MO',
        '65655' => 'MO',
        '65656' => 'MO',
        '65657' => 'MO',
        '65658' => 'MO',
        '65660' => 'MO',
        '65661' => 'MO',
        '65662' => 'MO',
        '65663' => 'MO',
        '65664' => 'MO',
        '65666' => 'MO',
        '65667' => 'MO',
        '65668' => 'MO',
        '65669' => 'MO',
        '65672' => 'MO',
        '65674' => 'MO',
        '65675' => 'MO',
        '65676' => 'MO',
        '65679' => 'MO',
        '65680' => 'MO',
        '65681' => 'MO',
        '65682' => 'MO',
        '65685' => 'MO',
        '65686' => 'MO',
        '65688' => 'MO',
        '65689' => 'MO',
        '65690' => 'MO',
        '65692' => 'MO',
        '65702' => 'MO',
        '65704' => 'MO',
        '65705' => 'MO',
        '65706' => 'MO',
        '65707' => 'MO',
        '65708' => 'MO',
        '65710' => 'MO',
        '65711' => 'MO',
        '65712' => 'MO',
        '65713' => 'MO',
        '65714' => 'MO',
        '65715' => 'MO',
        '65717' => 'MO',
        '65720' => 'MO',
        '65721' => 'MO',
        '65722' => 'MO',
        '65723' => 'MO',
        '65724' => 'MO',
        '65725' => 'MO',
        '65726' => 'MO',
        '65727' => 'MO',
        '65728' => 'MO',
        '65729' => 'MO',
        '65730' => 'MO',
        '65731' => 'MO',
        '65732' => 'MO',
        '65733' => 'MO',
        '65734' => 'MO',
        '65735' => 'MO',
        '65737' => 'MO',
        '65738' => 'MO',
        '65739' => 'MO',
        '65740' => 'MO',
        '65741' => 'MO',
        '65742' => 'MO',
        '65744' => 'MO',
        '65745' => 'MO',
        '65746' => 'MO',
        '65747' => 'MO',
        '65752' => 'MO',
        '65753' => 'MO',
        '65754' => 'MO',
        '65755' => 'MO',
        '65756' => 'MO',
        '65757' => 'MO',
        '65759' => 'MO',
        '65760' => 'MO',
        '65761' => 'MO',
        '65762' => 'MO',
        '65764' => 'MO',
        '65766' => 'MO',
        '65767' => 'MO',
        '65768' => 'MO',
        '65769' => 'MO',
        '65770' => 'MO',
        '65771' => 'MO',
        '65772' => 'MO',
        '65773' => 'MO',
        '65774' => 'MO',
        '65775' => 'MO',
        '65777' => 'MO',
        '65778' => 'MO',
        '65779' => 'MO',
        '65781' => 'MO',
        '65783' => 'MO',
        '65784' => 'MO',
        '65785' => 'MO',
        '65786' => 'MO',
        '65787' => 'MO',
        '65788' => 'MO',
        '65789' => 'MO',
        '65790' => 'MO',
        '65791' => 'MO',
        '65793' => 'MO',
        '65801' => 'MO',
        '65802' => 'MO',
        '65803' => 'MO',
        '65804' => 'MO',
        '65806' => 'MO',
        '65807' => 'MO',
        '65809' => 'MO',
        '65810' => 'MO',
        '65897' => 'MO',
        '66002' => 'KS',
        '66006' => 'KS',
        '66007' => 'KS',
        '66008' => 'KS',
        '66010' => 'KS',
        '66012' => 'KS',
        '66013' => 'KS',
        '66014' => 'KS',
        '66015' => 'KS',
        '66016' => 'KS',
        '66017' => 'KS',
        '66018' => 'KS',
        '66020' => 'KS',
        '66021' => 'KS',
        '66023' => 'KS',
        '66024' => 'KS',
        '66025' => 'KS',
        '66026' => 'KS',
        '66027' => 'KS',
        '66030' => 'KS',
        '66031' => 'KS',
        '66032' => 'KS',
        '66033' => 'KS',
        '66035' => 'KS',
        '66039' => 'KS',
        '66040' => 'KS',
        '66041' => 'KS',
        '66042' => 'KS',
        '66043' => 'KS',
        '66044' => 'KS',
        '66045' => 'KS',
        '66046' => 'KS',
        '66047' => 'KS',
        '66048' => 'KS',
        '66049' => 'KS',
        '66050' => 'KS',
        '66052' => 'KS',
        '66053' => 'KS',
        '66054' => 'KS',
        '66056' => 'KS',
        '66058' => 'KS',
        '66060' => 'KS',
        '66061' => 'KS',
        '66062' => 'KS',
        '66064' => 'KS',
        '66066' => 'KS',
        '66067' => 'KS',
        '66070' => 'KS',
        '66071' => 'KS',
        '66072' => 'KS',
        '66073' => 'KS',
        '66075' => 'KS',
        '66076' => 'KS',
        '66078' => 'KS',
        '66079' => 'KS',
        '66080' => 'KS',
        '66083' => 'KS',
        '66085' => 'KS',
        '66086' => 'KS',
        '66087' => 'KS',
        '66088' => 'KS',
        '66090' => 'KS',
        '66091' => 'KS',
        '66092' => 'KS',
        '66093' => 'KS',
        '66094' => 'KS',
        '66095' => 'KS',
        '66097' => 'KS',
        '66101' => 'KS',
        '66102' => 'KS',
        '66103' => 'KS',
        '66104' => 'KS',
        '66105' => 'KS',
        '66106' => 'KS',
        '66109' => 'KS',
        '66111' => 'KS',
        '66112' => 'KS',
        '66115' => 'KS',
        '66118' => 'KS',
        '66160' => 'KS',
        '66202' => 'KS',
        '66203' => 'KS',
        '66204' => 'KS',
        '66205' => 'KS',
        '66206' => 'KS',
        '66207' => 'KS',
        '66208' => 'KS',
        '66209' => 'KS',
        '66210' => 'KS',
        '66211' => 'KS',
        '66212' => 'KS',
        '66213' => 'KS',
        '66214' => 'KS',
        '66215' => 'KS',
        '66216' => 'KS',
        '66217' => 'KS',
        '66218' => 'KS',
        '66219' => 'KS',
        '66220' => 'KS',
        '66221' => 'KS',
        '66223' => 'KS',
        '66224' => 'KS',
        '66226' => 'KS',
        '66227' => 'KS',
        '66251' => 'KS',
        '66401' => 'KS',
        '66402' => 'KS',
        '66403' => 'KS',
        '66404' => 'KS',
        '66406' => 'KS',
        '66407' => 'KS',
        '66408' => 'KS',
        '66409' => 'KS',
        '66411' => 'KS',
        '66412' => 'KS',
        '66413' => 'KS',
        '66414' => 'KS',
        '66415' => 'KS',
        '66416' => 'KS',
        '66417' => 'KS',
        '66418' => 'KS',
        '66419' => 'KS',
        '66422' => 'KS',
        '66423' => 'KS',
        '66424' => 'KS',
        '66425' => 'KS',
        '66427' => 'KS',
        '66428' => 'KS',
        '66429' => 'KS',
        '66431' => 'KS',
        '66432' => 'KS',
        '66434' => 'KS',
        '66436' => 'KS',
        '66438' => 'KS',
        '66439' => 'KS',
        '66440' => 'KS',
        '66441' => 'KS',
        '66442' => 'KS',
        '66449' => 'KS',
        '66451' => 'KS',
        '66501' => 'KS',
        '66502' => 'KS',
        '66503' => 'KS',
        '66506' => 'KS',
        '66507' => 'KS',
        '66508' => 'KS',
        '66509' => 'KS',
        '66510' => 'KS',
        '66512' => 'KS',
        '66514' => 'KS',
        '66515' => 'KS',
        '66516' => 'KS',
        '66517' => 'KS',
        '66518' => 'KS',
        '66520' => 'KS',
        '66521' => 'KS',
        '66522' => 'KS',
        '66523' => 'KS',
        '66524' => 'KS',
        '66526' => 'KS',
        '66527' => 'KS',
        '66528' => 'KS',
        '66531' => 'KS',
        '66532' => 'KS',
        '66533' => 'KS',
        '66534' => 'KS',
        '66535' => 'KS',
        '66536' => 'KS',
        '66537' => 'KS',
        '66538' => 'KS',
        '66539' => 'KS',
        '66540' => 'KS',
        '66541' => 'KS',
        '66542' => 'KS',
        '66543' => 'KS',
        '66544' => 'KS',
        '66546' => 'KS',
        '66547' => 'KS',
        '66548' => 'KS',
        '66549' => 'KS',
        '66550' => 'KS',
        '66552' => 'KS',
        '66554' => 'KS',
        '66603' => 'KS',
        '66604' => 'KS',
        '66605' => 'KS',
        '66606' => 'KS',
        '66607' => 'KS',
        '66608' => 'KS',
        '66609' => 'KS',
        '66610' => 'KS',
        '66611' => 'KS',
        '66612' => 'KS',
        '66614' => 'KS',
        '66615' => 'KS',
        '66616' => 'KS',
        '66617' => 'KS',
        '66618' => 'KS',
        '66619' => 'KS',
        '66621' => 'KS',
        '66622' => 'KS',
        '66701' => 'KS',
        '66710' => 'KS',
        '66711' => 'KS',
        '66712' => 'KS',
        '66713' => 'KS',
        '66714' => 'KS',
        '66716' => 'KS',
        '66717' => 'KS',
        '66720' => 'KS',
        '66724' => 'KS',
        '66725' => 'KS',
        '66732' => 'KS',
        '66733' => 'KS',
        '66734' => 'KS',
        '66735' => 'KS',
        '66736' => 'KS',
        '66738' => 'KS',
        '66739' => 'KS',
        '66740' => 'KS',
        '66741' => 'KS',
        '66742' => 'KS',
        '66743' => 'KS',
        '66746' => 'KS',
        '66748' => 'KS',
        '66749' => 'KS',
        '66751' => 'KS',
        '66753' => 'KS',
        '66754' => 'KS',
        '66755' => 'KS',
        '66756' => 'KS',
        '66757' => 'KS',
        '66758' => 'KS',
        '66760' => 'KS',
        '66761' => 'KS',
        '66762' => 'KS',
        '66763' => 'KS',
        '66767' => 'KS',
        '66769' => 'KS',
        '66770' => 'KS',
        '66771' => 'KS',
        '66772' => 'KS',
        '66773' => 'KS',
        '66775' => 'KS',
        '66776' => 'KS',
        '66777' => 'KS',
        '66778' => 'KS',
        '66779' => 'KS',
        '66780' => 'KS',
        '66781' => 'KS',
        '66782' => 'KS',
        '66783' => 'KS',
        '66801' => 'KS',
        '66830' => 'KS',
        '66833' => 'KS',
        '66834' => 'KS',
        '66835' => 'KS',
        '66838' => 'KS',
        '66839' => 'KS',
        '66840' => 'KS',
        '66842' => 'KS',
        '66843' => 'KS',
        '66845' => 'KS',
        '66846' => 'KS',
        '66849' => 'KS',
        '66850' => 'KS',
        '66851' => 'KS',
        '66852' => 'KS',
        '66853' => 'KS',
        '66854' => 'KS',
        '66856' => 'KS',
        '66857' => 'KS',
        '66858' => 'KS',
        '66859' => 'KS',
        '66860' => 'KS',
        '66861' => 'KS',
        '66862' => 'KS',
        '66863' => 'KS',
        '66864' => 'KS',
        '66865' => 'KS',
        '66866' => 'KS',
        '66868' => 'KS',
        '66869' => 'KS',
        '66870' => 'KS',
        '66871' => 'KS',
        '66872' => 'KS',
        '66873' => 'KS',
        '66901' => 'KS',
        '66930' => 'KS',
        '66932' => 'KS',
        '66933' => 'KS',
        '66935' => 'KS',
        '66936' => 'KS',
        '66937' => 'KS',
        '66938' => 'KS',
        '66939' => 'KS',
        '66940' => 'KS',
        '66941' => 'KS',
        '66942' => 'KS',
        '66943' => 'KS',
        '66944' => 'KS',
        '66945' => 'KS',
        '66946' => 'KS',
        '66948' => 'KS',
        '66949' => 'KS',
        '66951' => 'KS',
        '66952' => 'KS',
        '66953' => 'KS',
        '66955' => 'KS',
        '66956' => 'KS',
        '66958' => 'KS',
        '66959' => 'KS',
        '66960' => 'KS',
        '66961' => 'KS',
        '66962' => 'KS',
        '66963' => 'KS',
        '66964' => 'KS',
        '66966' => 'KS',
        '66967' => 'KS',
        '66968' => 'KS',
        '66970' => 'KS',
        '67001' => 'KS',
        '67002' => 'KS',
        '67003' => 'KS',
        '67004' => 'KS',
        '67005' => 'KS',
        '67008' => 'KS',
        '67009' => 'KS',
        '67010' => 'KS',
        '67012' => 'KS',
        '67013' => 'KS',
        '67016' => 'KS',
        '67017' => 'KS',
        '67018' => 'KS',
        '67019' => 'KS',
        '67020' => 'KS',
        '67021' => 'KS',
        '67022' => 'KS',
        '67023' => 'KS',
        '67024' => 'KS',
        '67025' => 'KS',
        '67026' => 'KS',
        '67028' => 'KS',
        '67029' => 'KS',
        '67030' => 'KS',
        '67031' => 'KS',
        '67035' => 'KS',
        '67036' => 'KS',
        '67037' => 'KS',
        '67038' => 'KS',
        '67039' => 'KS',
        '67041' => 'KS',
        '67042' => 'KS',
        '67045' => 'KS',
        '67047' => 'KS',
        '67049' => 'KS',
        '67050' => 'KS',
        '67051' => 'KS',
        '67052' => 'KS',
        '67053' => 'KS',
        '67054' => 'KS',
        '67055' => 'KS',
        '67056' => 'KS',
        '67057' => 'KS',
        '67058' => 'KS',
        '67059' => 'KS',
        '67060' => 'KS',
        '67061' => 'KS',
        '67062' => 'KS',
        '67063' => 'KS',
        '67065' => 'KS',
        '67066' => 'KS',
        '67067' => 'KS',
        '67068' => 'KS',
        '67070' => 'KS',
        '67071' => 'KS',
        '67072' => 'KS',
        '67073' => 'KS',
        '67074' => 'KS',
        '67101' => 'KS',
        '67102' => 'KS',
        '67103' => 'KS',
        '67104' => 'KS',
        '67105' => 'KS',
        '67106' => 'KS',
        '67107' => 'KS',
        '67108' => 'KS',
        '67109' => 'KS',
        '67110' => 'KS',
        '67111' => 'KS',
        '67112' => 'KS',
        '67114' => 'KS',
        '67117' => 'KS',
        '67118' => 'KS',
        '67119' => 'KS',
        '67120' => 'KS',
        '67122' => 'KS',
        '67123' => 'KS',
        '67124' => 'KS',
        '67127' => 'KS',
        '67131' => 'KS',
        '67132' => 'KS',
        '67133' => 'KS',
        '67134' => 'KS',
        '67135' => 'KS',
        '67137' => 'KS',
        '67138' => 'KS',
        '67140' => 'KS',
        '67142' => 'KS',
        '67143' => 'KS',
        '67144' => 'KS',
        '67146' => 'KS',
        '67147' => 'KS',
        '67149' => 'KS',
        '67150' => 'KS',
        '67151' => 'KS',
        '67152' => 'KS',
        '67154' => 'KS',
        '67155' => 'KS',
        '67156' => 'KS',
        '67159' => 'KS',
        '67202' => 'KS',
        '67203' => 'KS',
        '67204' => 'KS',
        '67205' => 'KS',
        '67206' => 'KS',
        '67207' => 'KS',
        '67208' => 'KS',
        '67209' => 'KS',
        '67210' => 'KS',
        '67211' => 'KS',
        '67212' => 'KS',
        '67213' => 'KS',
        '67214' => 'KS',
        '67215' => 'KS',
        '67216' => 'KS',
        '67217' => 'KS',
        '67218' => 'KS',
        '67219' => 'KS',
        '67220' => 'KS',
        '67221' => 'KS',
        '67223' => 'KS',
        '67226' => 'KS',
        '67227' => 'KS',
        '67228' => 'KS',
        '67230' => 'KS',
        '67232' => 'KS',
        '67235' => 'KS',
        '67260' => 'KS',
        '67301' => 'KS',
        '67330' => 'KS',
        '67332' => 'KS',
        '67333' => 'KS',
        '67334' => 'KS',
        '67335' => 'KS',
        '67336' => 'KS',
        '67337' => 'KS',
        '67340' => 'KS',
        '67341' => 'KS',
        '67342' => 'KS',
        '67344' => 'KS',
        '67345' => 'KS',
        '67346' => 'KS',
        '67347' => 'KS',
        '67349' => 'KS',
        '67351' => 'KS',
        '67352' => 'KS',
        '67353' => 'KS',
        '67354' => 'KS',
        '67355' => 'KS',
        '67356' => 'KS',
        '67357' => 'KS',
        '67360' => 'KS',
        '67361' => 'KS',
        '67363' => 'KS',
        '67364' => 'KS',
        '67401' => 'KS',
        '67410' => 'KS',
        '67416' => 'KS',
        '67417' => 'KS',
        '67418' => 'KS',
        '67420' => 'KS',
        '67422' => 'KS',
        '67423' => 'KS',
        '67425' => 'KS',
        '67427' => 'KS',
        '67428' => 'KS',
        '67430' => 'KS',
        '67431' => 'KS',
        '67432' => 'KS',
        '67436' => 'KS',
        '67437' => 'KS',
        '67438' => 'KS',
        '67439' => 'KS',
        '67441' => 'KS',
        '67442' => 'KS',
        '67443' => 'KS',
        '67444' => 'KS',
        '67445' => 'KS',
        '67446' => 'KS',
        '67447' => 'KS',
        '67448' => 'KS',
        '67449' => 'KS',
        '67450' => 'KS',
        '67451' => 'KS',
        '67452' => 'KS',
        '67454' => 'KS',
        '67455' => 'KS',
        '67456' => 'KS',
        '67457' => 'KS',
        '67458' => 'KS',
        '67459' => 'KS',
        '67460' => 'KS',
        '67464' => 'KS',
        '67466' => 'KS',
        '67467' => 'KS',
        '67468' => 'KS',
        '67470' => 'KS',
        '67473' => 'KS',
        '67474' => 'KS',
        '67475' => 'KS',
        '67476' => 'KS',
        '67478' => 'KS',
        '67480' => 'KS',
        '67481' => 'KS',
        '67482' => 'KS',
        '67483' => 'KS',
        '67484' => 'KS',
        '67485' => 'KS',
        '67487' => 'KS',
        '67490' => 'KS',
        '67491' => 'KS',
        '67492' => 'KS',
        '67501' => 'KS',
        '67502' => 'KS',
        '67505' => 'KS',
        '67510' => 'KS',
        '67511' => 'KS',
        '67512' => 'KS',
        '67513' => 'KS',
        '67514' => 'KS',
        '67515' => 'KS',
        '67516' => 'KS',
        '67518' => 'KS',
        '67519' => 'KS',
        '67520' => 'KS',
        '67521' => 'KS',
        '67522' => 'KS',
        '67523' => 'KS',
        '67524' => 'KS',
        '67525' => 'KS',
        '67526' => 'KS',
        '67529' => 'KS',
        '67530' => 'KS',
        '67543' => 'KS',
        '67544' => 'KS',
        '67545' => 'KS',
        '67546' => 'KS',
        '67547' => 'KS',
        '67548' => 'KS',
        '67550' => 'KS',
        '67552' => 'KS',
        '67553' => 'KS',
        '67554' => 'KS',
        '67556' => 'KS',
        '67557' => 'KS',
        '67559' => 'KS',
        '67560' => 'KS',
        '67561' => 'KS',
        '67563' => 'KS',
        '67564' => 'KS',
        '67565' => 'KS',
        '67566' => 'KS',
        '67567' => 'KS',
        '67568' => 'KS',
        '67570' => 'KS',
        '67572' => 'KS',
        '67573' => 'KS',
        '67574' => 'KS',
        '67575' => 'KS',
        '67576' => 'KS',
        '67578' => 'KS',
        '67579' => 'KS',
        '67581' => 'KS',
        '67583' => 'KS',
        '67584' => 'KS',
        '67601' => 'KS',
        '67621' => 'KS',
        '67622' => 'KS',
        '67623' => 'KS',
        '67625' => 'KS',
        '67626' => 'KS',
        '67627' => 'KS',
        '67628' => 'KS',
        '67629' => 'KS',
        '67631' => 'KS',
        '67632' => 'KS',
        '67634' => 'KS',
        '67635' => 'KS',
        '67637' => 'KS',
        '67638' => 'KS',
        '67639' => 'KS',
        '67640' => 'KS',
        '67642' => 'KS',
        '67643' => 'KS',
        '67644' => 'KS',
        '67645' => 'KS',
        '67646' => 'KS',
        '67647' => 'KS',
        '67648' => 'KS',
        '67649' => 'KS',
        '67650' => 'KS',
        '67651' => 'KS',
        '67653' => 'KS',
        '67654' => 'KS',
        '67656' => 'KS',
        '67657' => 'KS',
        '67658' => 'KS',
        '67659' => 'KS',
        '67660' => 'KS',
        '67661' => 'KS',
        '67663' => 'KS',
        '67664' => 'KS',
        '67665' => 'KS',
        '67667' => 'KS',
        '67669' => 'KS',
        '67671' => 'KS',
        '67672' => 'KS',
        '67673' => 'KS',
        '67674' => 'KS',
        '67675' => 'KS',
        '67701' => 'KS',
        '67730' => 'KS',
        '67731' => 'KS',
        '67732' => 'KS',
        '67733' => 'KS',
        '67734' => 'KS',
        '67735' => 'KS',
        '67736' => 'KS',
        '67737' => 'KS',
        '67738' => 'KS',
        '67739' => 'KS',
        '67740' => 'KS',
        '67741' => 'KS',
        '67743' => 'KS',
        '67744' => 'KS',
        '67745' => 'KS',
        '67747' => 'KS',
        '67748' => 'KS',
        '67749' => 'KS',
        '67751' => 'KS',
        '67752' => 'KS',
        '67753' => 'KS',
        '67756' => 'KS',
        '67757' => 'KS',
        '67758' => 'KS',
        '67761' => 'KS',
        '67762' => 'KS',
        '67764' => 'KS',
        '67801' => 'KS',
        '67831' => 'KS',
        '67834' => 'KS',
        '67835' => 'KS',
        '67836' => 'KS',
        '67837' => 'KS',
        '67838' => 'KS',
        '67839' => 'KS',
        '67840' => 'KS',
        '67841' => 'KS',
        '67842' => 'KS',
        '67843' => 'KS',
        '67844' => 'KS',
        '67846' => 'KS',
        '67849' => 'KS',
        '67850' => 'KS',
        '67851' => 'KS',
        '67853' => 'KS',
        '67854' => 'KS',
        '67855' => 'KS',
        '67857' => 'KS',
        '67859' => 'KS',
        '67860' => 'KS',
        '67861' => 'KS',
        '67862' => 'KS',
        '67863' => 'KS',
        '67864' => 'KS',
        '67865' => 'KS',
        '67867' => 'KS',
        '67868' => 'KS',
        '67869' => 'KS',
        '67870' => 'KS',
        '67871' => 'KS',
        '67876' => 'KS',
        '67877' => 'KS',
        '67878' => 'KS',
        '67879' => 'KS',
        '67880' => 'KS',
        '67882' => 'KS',
        '67901' => 'KS',
        '67950' => 'KS',
        '67951' => 'KS',
        '67952' => 'KS',
        '67953' => 'KS',
        '67954' => 'KS',
        '68001' => 'NE',
        '68002' => 'NE',
        '68003' => 'NE',
        '68004' => 'NE',
        '68005' => 'NE',
        '68007' => 'NE',
        '68008' => 'NE',
        '68010' => 'NE',
        '68014' => 'NE',
        '68015' => 'NE',
        '68016' => 'NE',
        '68017' => 'NE',
        '68018' => 'NE',
        '68019' => 'NE',
        '68020' => 'NE',
        '68022' => 'NE',
        '68023' => 'NE',
        '68025' => 'NE',
        '68028' => 'NE',
        '68029' => 'NE',
        '68030' => 'NE',
        '68031' => 'NE',
        '68033' => 'NE',
        '68034' => 'NE',
        '68036' => 'NE',
        '68037' => 'NE',
        '68038' => 'NE',
        '68039' => 'NE',
        '68040' => 'NE',
        '68041' => 'NE',
        '68042' => 'NE',
        '68044' => 'NE',
        '68045' => 'NE',
        '68046' => 'NE',
        '68047' => 'NE',
        '68048' => 'NE',
        '68050' => 'NE',
        '68055' => 'NE',
        '68056' => 'NE',
        '68057' => 'NE',
        '68058' => 'NE',
        '68059' => 'NE',
        '68061' => 'NE',
        '68062' => 'NE',
        '68063' => 'NE',
        '68064' => 'NE',
        '68065' => 'NE',
        '68066' => 'NE',
        '68067' => 'NE',
        '68068' => 'NE',
        '68069' => 'NE',
        '68070' => 'NE',
        '68071' => 'NE',
        '68072' => 'NE',
        '68073' => 'NE',
        '68102' => 'NE',
        '68104' => 'NE',
        '68105' => 'NE',
        '68106' => 'NE',
        '68107' => 'NE',
        '68108' => 'NE',
        '68110' => 'NE',
        '68111' => 'NE',
        '68112' => 'NE',
        '68113' => 'NE',
        '68114' => 'NE',
        '68116' => 'NE',
        '68117' => 'NE',
        '68118' => 'NE',
        '68122' => 'NE',
        '68123' => 'NE',
        '68124' => 'NE',
        '68127' => 'NE',
        '68128' => 'NE',
        '68130' => 'NE',
        '68131' => 'NE',
        '68132' => 'NE',
        '68133' => 'NE',
        '68134' => 'NE',
        '68135' => 'NE',
        '68136' => 'NE',
        '68137' => 'NE',
        '68138' => 'NE',
        '68142' => 'NE',
        '68144' => 'NE',
        '68147' => 'NE',
        '68152' => 'NE',
        '68154' => 'NE',
        '68157' => 'NE',
        '68164' => 'NE',
        '68178' => 'NE',
        '68182' => 'NE',
        '68183' => 'NE',
        '68301' => 'NE',
        '68303' => 'NE',
        '68304' => 'NE',
        '68305' => 'NE',
        '68307' => 'NE',
        '68309' => 'NE',
        '68310' => 'NE',
        '68313' => 'NE',
        '68314' => 'NE',
        '68315' => 'NE',
        '68316' => 'NE',
        '68317' => 'NE',
        '68318' => 'NE',
        '68319' => 'NE',
        '68320' => 'NE',
        '68321' => 'NE',
        '68322' => 'NE',
        '68323' => 'NE',
        '68324' => 'NE',
        '68325' => 'NE',
        '68326' => 'NE',
        '68327' => 'NE',
        '68328' => 'NE',
        '68329' => 'NE',
        '68330' => 'NE',
        '68331' => 'NE',
        '68332' => 'NE',
        '68333' => 'NE',
        '68335' => 'NE',
        '68336' => 'NE',
        '68337' => 'NE',
        '68338' => 'NE',
        '68339' => 'NE',
        '68340' => 'NE',
        '68341' => 'NE',
        '68342' => 'NE',
        '68343' => 'NE',
        '68344' => 'NE',
        '68345' => 'NE',
        '68346' => 'NE',
        '68347' => 'NE',
        '68348' => 'NE',
        '68349' => 'NE',
        '68350' => 'NE',
        '68351' => 'NE',
        '68352' => 'NE',
        '68354' => 'NE',
        '68355' => 'NE',
        '68357' => 'NE',
        '68358' => 'NE',
        '68359' => 'NE',
        '68360' => 'NE',
        '68361' => 'NE',
        '68362' => 'NE',
        '68364' => 'NE',
        '68365' => 'NE',
        '68366' => 'NE',
        '68367' => 'NE',
        '68368' => 'NE',
        '68370' => 'NE',
        '68371' => 'NE',
        '68372' => 'NE',
        '68375' => 'NE',
        '68376' => 'NE',
        '68377' => 'NE',
        '68378' => 'NE',
        '68379' => 'NE',
        '68380' => 'NE',
        '68381' => 'NE',
        '68382' => 'NE',
        '68401' => 'NE',
        '68402' => 'NE',
        '68403' => 'NE',
        '68404' => 'NE',
        '68405' => 'NE',
        '68406' => 'NE',
        '68407' => 'NE',
        '68409' => 'NE',
        '68410' => 'NE',
        '68413' => 'NE',
        '68414' => 'NE',
        '68415' => 'NE',
        '68416' => 'NE',
        '68417' => 'NE',
        '68418' => 'NE',
        '68419' => 'NE',
        '68420' => 'NE',
        '68421' => 'NE',
        '68422' => 'NE',
        '68423' => 'NE',
        '68424' => 'NE',
        '68428' => 'NE',
        '68429' => 'NE',
        '68430' => 'NE',
        '68431' => 'NE',
        '68433' => 'NE',
        '68434' => 'NE',
        '68436' => 'NE',
        '68437' => 'NE',
        '68438' => 'NE',
        '68439' => 'NE',
        '68440' => 'NE',
        '68441' => 'NE',
        '68442' => 'NE',
        '68443' => 'NE',
        '68444' => 'NE',
        '68445' => 'NE',
        '68446' => 'NE',
        '68447' => 'NE',
        '68448' => 'NE',
        '68450' => 'NE',
        '68452' => 'NE',
        '68453' => 'NE',
        '68454' => 'NE',
        '68455' => 'NE',
        '68456' => 'NE',
        '68457' => 'NE',
        '68458' => 'NE',
        '68460' => 'NE',
        '68461' => 'NE',
        '68462' => 'NE',
        '68463' => 'NE',
        '68464' => 'NE',
        '68465' => 'NE',
        '68466' => 'NE',
        '68467' => 'NE',
        '68502' => 'NE',
        '68503' => 'NE',
        '68504' => 'NE',
        '68505' => 'NE',
        '68506' => 'NE',
        '68507' => 'NE',
        '68508' => 'NE',
        '68510' => 'NE',
        '68512' => 'NE',
        '68514' => 'NE',
        '68516' => 'NE',
        '68517' => 'NE',
        '68520' => 'NE',
        '68521' => 'NE',
        '68522' => 'NE',
        '68523' => 'NE',
        '68524' => 'NE',
        '68526' => 'NE',
        '68527' => 'NE',
        '68528' => 'NE',
        '68531' => 'NE',
        '68532' => 'NE',
        '68588' => 'NE',
        '68601' => 'NE',
        '68620' => 'NE',
        '68621' => 'NE',
        '68622' => 'NE',
        '68623' => 'NE',
        '68624' => 'NE',
        '68626' => 'NE',
        '68627' => 'NE',
        '68628' => 'NE',
        '68629' => 'NE',
        '68631' => 'NE',
        '68632' => 'NE',
        '68633' => 'NE',
        '68634' => 'NE',
        '68635' => 'NE',
        '68636' => 'NE',
        '68637' => 'NE',
        '68638' => 'NE',
        '68640' => 'NE',
        '68641' => 'NE',
        '68642' => 'NE',
        '68643' => 'NE',
        '68644' => 'NE',
        '68647' => 'NE',
        '68648' => 'NE',
        '68649' => 'NE',
        '68651' => 'NE',
        '68652' => 'NE',
        '68653' => 'NE',
        '68654' => 'NE',
        '68655' => 'NE',
        '68658' => 'NE',
        '68659' => 'NE',
        '68660' => 'NE',
        '68661' => 'NE',
        '68662' => 'NE',
        '68663' => 'NE',
        '68664' => 'NE',
        '68665' => 'NE',
        '68666' => 'NE',
        '68667' => 'NE',
        '68669' => 'NE',
        '68701' => 'NE',
        '68710' => 'NE',
        '68711' => 'NE',
        '68713' => 'NE',
        '68714' => 'NE',
        '68715' => 'NE',
        '68716' => 'NE',
        '68717' => 'NE',
        '68718' => 'NE',
        '68719' => 'NE',
        '68720' => 'NE',
        '68722' => 'NE',
        '68723' => 'NE',
        '68724' => 'NE',
        '68725' => 'NE',
        '68726' => 'NE',
        '68727' => 'NE',
        '68728' => 'NE',
        '68729' => 'NE',
        '68730' => 'NE',
        '68731' => 'NE',
        '68732' => 'NE',
        '68733' => 'NE',
        '68734' => 'NE',
        '68735' => 'NE',
        '68736' => 'NE',
        '68739' => 'NE',
        '68740' => 'NE',
        '68741' => 'NE',
        '68742' => 'NE',
        '68743' => 'NE',
        '68745' => 'NE',
        '68746' => 'NE',
        '68747' => 'NE',
        '68748' => 'NE',
        '68749' => 'NE',
        '68751' => 'NE',
        '68752' => 'NE',
        '68753' => 'NE',
        '68755' => 'NE',
        '68756' => 'NE',
        '68757' => 'NE',
        '68758' => 'NE',
        '68759' => 'NE',
        '68760' => 'NE',
        '68761' => 'NE',
        '68763' => 'NE',
        '68764' => 'NE',
        '68765' => 'NE',
        '68766' => 'NE',
        '68767' => 'NE',
        '68768' => 'NE',
        '68769' => 'NE',
        '68770' => 'NE',
        '68771' => 'NE',
        '68773' => 'NE',
        '68774' => 'NE',
        '68776' => 'NE',
        '68777' => 'NE',
        '68778' => 'NE',
        '68779' => 'NE',
        '68780' => 'NE',
        '68781' => 'NE',
        '68783' => 'NE',
        '68784' => 'NE',
        '68785' => 'NE',
        '68786' => 'NE',
        '68787' => 'NE',
        '68788' => 'NE',
        '68789' => 'NE',
        '68790' => 'NE',
        '68791' => 'NE',
        '68792' => 'NE',
        '68801' => 'NE',
        '68803' => 'NE',
        '68810' => 'NE',
        '68812' => 'NE',
        '68813' => 'NE',
        '68814' => 'NE',
        '68815' => 'NE',
        '68816' => 'NE',
        '68817' => 'NE',
        '68818' => 'NE',
        '68820' => 'NE',
        '68821' => 'NE',
        '68822' => 'NE',
        '68823' => 'NE',
        '68824' => 'NE',
        '68825' => 'NE',
        '68826' => 'NE',
        '68827' => 'NE',
        '68828' => 'NE',
        '68831' => 'NE',
        '68832' => 'NE',
        '68833' => 'NE',
        '68834' => 'NE',
        '68835' => 'NE',
        '68836' => 'NE',
        '68837' => 'NE',
        '68838' => 'NE',
        '68840' => 'NE',
        '68841' => 'NE',
        '68842' => 'NE',
        '68843' => 'NE',
        '68844' => 'NE',
        '68845' => 'NE',
        '68846' => 'NE',
        '68847' => 'NE',
        '68849' => 'NE',
        '68850' => 'NE',
        '68852' => 'NE',
        '68853' => 'NE',
        '68854' => 'NE',
        '68855' => 'NE',
        '68856' => 'NE',
        '68858' => 'NE',
        '68859' => 'NE',
        '68860' => 'NE',
        '68861' => 'NE',
        '68862' => 'NE',
        '68863' => 'NE',
        '68864' => 'NE',
        '68865' => 'NE',
        '68866' => 'NE',
        '68869' => 'NE',
        '68870' => 'NE',
        '68871' => 'NE',
        '68872' => 'NE',
        '68873' => 'NE',
        '68874' => 'NE',
        '68875' => 'NE',
        '68876' => 'NE',
        '68878' => 'NE',
        '68879' => 'NE',
        '68881' => 'NE',
        '68882' => 'NE',
        '68883' => 'NE',
        '68901' => 'NE',
        '68920' => 'NE',
        '68922' => 'NE',
        '68923' => 'NE',
        '68924' => 'NE',
        '68925' => 'NE',
        '68926' => 'NE',
        '68927' => 'NE',
        '68928' => 'NE',
        '68929' => 'NE',
        '68930' => 'NE',
        '68932' => 'NE',
        '68933' => 'NE',
        '68934' => 'NE',
        '68935' => 'NE',
        '68936' => 'NE',
        '68937' => 'NE',
        '68938' => 'NE',
        '68939' => 'NE',
        '68940' => 'NE',
        '68941' => 'NE',
        '68942' => 'NE',
        '68943' => 'NE',
        '68944' => 'NE',
        '68945' => 'NE',
        '68946' => 'NE',
        '68947' => 'NE',
        '68948' => 'NE',
        '68949' => 'NE',
        '68950' => 'NE',
        '68952' => 'NE',
        '68954' => 'NE',
        '68955' => 'NE',
        '68956' => 'NE',
        '68957' => 'NE',
        '68958' => 'NE',
        '68959' => 'NE',
        '68960' => 'NE',
        '68961' => 'NE',
        '68964' => 'NE',
        '68966' => 'NE',
        '68967' => 'NE',
        '68970' => 'NE',
        '68971' => 'NE',
        '68972' => 'NE',
        '68973' => 'NE',
        '68974' => 'NE',
        '68975' => 'NE',
        '68976' => 'NE',
        '68977' => 'NE',
        '68978' => 'NE',
        '68979' => 'NE',
        '68980' => 'NE',
        '68981' => 'NE',
        '68982' => 'NE',
        '69001' => 'NE',
        '69020' => 'NE',
        '69021' => 'NE',
        '69022' => 'NE',
        '69023' => 'NE',
        '69024' => 'NE',
        '69025' => 'NE',
        '69026' => 'NE',
        '69027' => 'NE',
        '69028' => 'NE',
        '69029' => 'NE',
        '69030' => 'NE',
        '69032' => 'NE',
        '69033' => 'NE',
        '69034' => 'NE',
        '69036' => 'NE',
        '69037' => 'NE',
        '69038' => 'NE',
        '69039' => 'NE',
        '69040' => 'NE',
        '69041' => 'NE',
        '69042' => 'NE',
        '69043' => 'NE',
        '69044' => 'NE',
        '69045' => 'NE',
        '69046' => 'NE',
        '69101' => 'NE',
        '69120' => 'NE',
        '69121' => 'NE',
        '69122' => 'NE',
        '69123' => 'NE',
        '69125' => 'NE',
        '69127' => 'NE',
        '69128' => 'NE',
        '69129' => 'NE',
        '69130' => 'NE',
        '69131' => 'NE',
        '69132' => 'NE',
        '69133' => 'NE',
        '69134' => 'NE',
        '69135' => 'NE',
        '69138' => 'NE',
        '69140' => 'NE',
        '69141' => 'NE',
        '69142' => 'NE',
        '69143' => 'NE',
        '69144' => 'NE',
        '69145' => 'NE',
        '69146' => 'NE',
        '69147' => 'NE',
        '69148' => 'NE',
        '69149' => 'NE',
        '69150' => 'NE',
        '69151' => 'NE',
        '69152' => 'NE',
        '69153' => 'NE',
        '69154' => 'NE',
        '69155' => 'NE',
        '69156' => 'NE',
        '69157' => 'NE',
        '69161' => 'NE',
        '69162' => 'NE',
        '69163' => 'NE',
        '69165' => 'NE',
        '69166' => 'NE',
        '69167' => 'NE',
        '69168' => 'NE',
        '69169' => 'NE',
        '69170' => 'NE',
        '69171' => 'NE',
        '69201' => 'NE',
        '69210' => 'NE',
        '69211' => 'NE',
        '69212' => 'NE',
        '69214' => 'NE',
        '69216' => 'NE',
        '69217' => 'NE',
        '69218' => 'NE',
        '69219' => 'NE',
        '69220' => 'NE',
        '69221' => 'NE',
        '69301' => 'NE',
        '69331' => 'NE',
        '69333' => 'NE',
        '69334' => 'NE',
        '69335' => 'NE',
        '69336' => 'NE',
        '69337' => 'NE',
        '69339' => 'NE',
        '69340' => 'NE',
        '69341' => 'NE',
        '69343' => 'NE',
        '69345' => 'NE',
        '69346' => 'NE',
        '69347' => 'NE',
        '69348' => 'NE',
        '69350' => 'NE',
        '69351' => 'NE',
        '69352' => 'NE',
        '69353' => 'NE',
        '69354' => 'NE',
        '69355' => 'NE',
        '69356' => 'NE',
        '69357' => 'NE',
        '69358' => 'NE',
        '69360' => 'NE',
        '69361' => 'NE',
        '69365' => 'NE',
        '69366' => 'NE',
        '69367' => 'NE',
        '70001' => 'LA',
        '70002' => 'LA',
        '70003' => 'LA',
        '70005' => 'LA',
        '70006' => 'LA',
        '70030' => 'LA',
        '70031' => 'LA',
        '70032' => 'LA',
        '70036' => 'LA',
        '70037' => 'LA',
        '70038' => 'LA',
        '70039' => 'LA',
        '70040' => 'LA',
        '70041' => 'LA',
        '70043' => 'LA',
        '70047' => 'LA',
        '70049' => 'LA',
        '70050' => 'LA',
        '70051' => 'LA',
        '70052' => 'LA',
        '70053' => 'LA',
        '70056' => 'LA',
        '70057' => 'LA',
        '70058' => 'LA',
        '70062' => 'LA',
        '70065' => 'LA',
        '70067' => 'LA',
        '70068' => 'LA',
        '70070' => 'LA',
        '70071' => 'LA',
        '70072' => 'LA',
        '70075' => 'LA',
        '70076' => 'LA',
        '70079' => 'LA',
        '70080' => 'LA',
        '70082' => 'LA',
        '70083' => 'LA',
        '70084' => 'LA',
        '70085' => 'LA',
        '70086' => 'LA',
        '70087' => 'LA',
        '70090' => 'LA',
        '70091' => 'LA',
        '70092' => 'LA',
        '70094' => 'LA',
        '70112' => 'LA',
        '70113' => 'LA',
        '70114' => 'LA',
        '70115' => 'LA',
        '70116' => 'LA',
        '70117' => 'LA',
        '70118' => 'LA',
        '70119' => 'LA',
        '70121' => 'LA',
        '70122' => 'LA',
        '70123' => 'LA',
        '70124' => 'LA',
        '70125' => 'LA',
        '70126' => 'LA',
        '70127' => 'LA',
        '70128' => 'LA',
        '70129' => 'LA',
        '70130' => 'LA',
        '70131' => 'LA',
        '70139' => 'LA',
        '70148' => 'LA',
        '70163' => 'LA',
        '70301' => 'LA',
        '70310' => 'LA',
        '70339' => 'LA',
        '70340' => 'LA',
        '70341' => 'LA',
        '70342' => 'LA',
        '70343' => 'LA',
        '70344' => 'LA',
        '70345' => 'LA',
        '70346' => 'LA',
        '70352' => 'LA',
        '70353' => 'LA',
        '70354' => 'LA',
        '70355' => 'LA',
        '70356' => 'LA',
        '70357' => 'LA',
        '70358' => 'LA',
        '70359' => 'LA',
        '70360' => 'LA',
        '70363' => 'LA',
        '70364' => 'LA',
        '70372' => 'LA',
        '70373' => 'LA',
        '70374' => 'LA',
        '70375' => 'LA',
        '70377' => 'LA',
        '70380' => 'LA',
        '70390' => 'LA',
        '70391' => 'LA',
        '70392' => 'LA',
        '70393' => 'LA',
        '70394' => 'LA',
        '70395' => 'LA',
        '70397' => 'LA',
        '70401' => 'LA',
        '70402' => 'LA',
        '70403' => 'LA',
        '70420' => 'LA',
        '70422' => 'LA',
        '70426' => 'LA',
        '70427' => 'LA',
        '70431' => 'LA',
        '70433' => 'LA',
        '70435' => 'LA',
        '70436' => 'LA',
        '70437' => 'LA',
        '70438' => 'LA',
        '70441' => 'LA',
        '70442' => 'LA',
        '70443' => 'LA',
        '70444' => 'LA',
        '70445' => 'LA',
        '70446' => 'LA',
        '70447' => 'LA',
        '70448' => 'LA',
        '70449' => 'LA',
        '70450' => 'LA',
        '70451' => 'LA',
        '70452' => 'LA',
        '70453' => 'LA',
        '70454' => 'LA',
        '70455' => 'LA',
        '70456' => 'LA',
        '70457' => 'LA',
        '70458' => 'LA',
        '70460' => 'LA',
        '70461' => 'LA',
        '70462' => 'LA',
        '70463' => 'LA',
        '70464' => 'LA',
        '70465' => 'LA',
        '70466' => 'LA',
        '70471' => 'LA',
        '70501' => 'LA',
        '70503' => 'LA',
        '70506' => 'LA',
        '70507' => 'LA',
        '70508' => 'LA',
        '70510' => 'LA',
        '70512' => 'LA',
        '70513' => 'LA',
        '70514' => 'LA',
        '70515' => 'LA',
        '70516' => 'LA',
        '70517' => 'LA',
        '70518' => 'LA',
        '70519' => 'LA',
        '70520' => 'LA',
        '70522' => 'LA',
        '70523' => 'LA',
        '70524' => 'LA',
        '70525' => 'LA',
        '70526' => 'LA',
        '70528' => 'LA',
        '70529' => 'LA',
        '70531' => 'LA',
        '70532' => 'LA',
        '70533' => 'LA',
        '70534' => 'LA',
        '70535' => 'LA',
        '70537' => 'LA',
        '70538' => 'LA',
        '70541' => 'LA',
        '70542' => 'LA',
        '70543' => 'LA',
        '70544' => 'LA',
        '70546' => 'LA',
        '70548' => 'LA',
        '70549' => 'LA',
        '70550' => 'LA',
        '70551' => 'LA',
        '70552' => 'LA',
        '70554' => 'LA',
        '70555' => 'LA',
        '70556' => 'LA',
        '70558' => 'LA',
        '70559' => 'LA',
        '70560' => 'LA',
        '70563' => 'LA',
        '70570' => 'LA',
        '70575' => 'LA',
        '70576' => 'LA',
        '70577' => 'LA',
        '70578' => 'LA',
        '70580' => 'LA',
        '70581' => 'LA',
        '70582' => 'LA',
        '70583' => 'LA',
        '70584' => 'LA',
        '70585' => 'LA',
        '70586' => 'LA',
        '70589' => 'LA',
        '70591' => 'LA',
        '70592' => 'LA',
        '70601' => 'LA',
        '70605' => 'LA',
        '70607' => 'LA',
        '70609' => 'LA',
        '70611' => 'LA',
        '70615' => 'LA',
        '70629' => 'LA',
        '70630' => 'LA',
        '70631' => 'LA',
        '70632' => 'LA',
        '70633' => 'LA',
        '70634' => 'LA',
        '70637' => 'LA',
        '70638' => 'LA',
        '70639' => 'LA',
        '70640' => 'LA',
        '70643' => 'LA',
        '70644' => 'LA',
        '70645' => 'LA',
        '70646' => 'LA',
        '70647' => 'LA',
        '70648' => 'LA',
        '70650' => 'LA',
        '70651' => 'LA',
        '70652' => 'LA',
        '70653' => 'LA',
        '70654' => 'LA',
        '70655' => 'LA',
        '70656' => 'LA',
        '70657' => 'LA',
        '70658' => 'LA',
        '70659' => 'LA',
        '70660' => 'LA',
        '70661' => 'LA',
        '70662' => 'LA',
        '70663' => 'LA',
        '70665' => 'LA',
        '70668' => 'LA',
        '70669' => 'LA',
        '70706' => 'LA',
        '70710' => 'LA',
        '70711' => 'LA',
        '70712' => 'LA',
        '70714' => 'LA',
        '70715' => 'LA',
        '70719' => 'LA',
        '70721' => 'LA',
        '70722' => 'LA',
        '70723' => 'LA',
        '70725' => 'LA',
        '70726' => 'LA',
        '70729' => 'LA',
        '70730' => 'LA',
        '70732' => 'LA',
        '70733' => 'LA',
        '70734' => 'LA',
        '70736' => 'LA',
        '70737' => 'LA',
        '70739' => 'LA',
        '70740' => 'LA',
        '70743' => 'LA',
        '70744' => 'LA',
        '70747' => 'LA',
        '70748' => 'LA',
        '70749' => 'LA',
        '70750' => 'LA',
        '70752' => 'LA',
        '70753' => 'LA',
        '70754' => 'LA',
        '70755' => 'LA',
        '70756' => 'LA',
        '70757' => 'LA',
        '70759' => 'LA',
        '70760' => 'LA',
        '70761' => 'LA',
        '70762' => 'LA',
        '70763' => 'LA',
        '70764' => 'LA',
        '70767' => 'LA',
        '70769' => 'LA',
        '70770' => 'LA',
        '70772' => 'LA',
        '70773' => 'LA',
        '70774' => 'LA',
        '70775' => 'LA',
        '70776' => 'LA',
        '70777' => 'LA',
        '70778' => 'LA',
        '70780' => 'LA',
        '70782' => 'LA',
        '70783' => 'LA',
        '70785' => 'LA',
        '70786' => 'LA',
        '70787' => 'LA',
        '70788' => 'LA',
        '70789' => 'LA',
        '70791' => 'LA',
        '70801' => 'LA',
        '70802' => 'LA',
        '70803' => 'LA',
        '70805' => 'LA',
        '70806' => 'LA',
        '70807' => 'LA',
        '70808' => 'LA',
        '70809' => 'LA',
        '70810' => 'LA',
        '70811' => 'LA',
        '70812' => 'LA',
        '70813' => 'LA',
        '70814' => 'LA',
        '70815' => 'LA',
        '70816' => 'LA',
        '70817' => 'LA',
        '70818' => 'LA',
        '70819' => 'LA',
        '70820' => 'LA',
        '70825' => 'LA',
        '70836' => 'LA',
        '71001' => 'LA',
        '71002' => 'LA',
        '71003' => 'LA',
        '71004' => 'LA',
        '71006' => 'LA',
        '71007' => 'LA',
        '71008' => 'LA',
        '71009' => 'LA',
        '71016' => 'LA',
        '71018' => 'LA',
        '71019' => 'LA',
        '71021' => 'LA',
        '71023' => 'LA',
        '71024' => 'LA',
        '71027' => 'LA',
        '71028' => 'LA',
        '71029' => 'LA',
        '71030' => 'LA',
        '71031' => 'LA',
        '71032' => 'LA',
        '71033' => 'LA',
        '71034' => 'LA',
        '71037' => 'LA',
        '71038' => 'LA',
        '71039' => 'LA',
        '71040' => 'LA',
        '71043' => 'LA',
        '71044' => 'LA',
        '71045' => 'LA',
        '71046' => 'LA',
        '71047' => 'LA',
        '71048' => 'LA',
        '71049' => 'LA',
        '71051' => 'LA',
        '71052' => 'LA',
        '71055' => 'LA',
        '71060' => 'LA',
        '71061' => 'LA',
        '71063' => 'LA',
        '71064' => 'LA',
        '71065' => 'LA',
        '71066' => 'LA',
        '71067' => 'LA',
        '71068' => 'LA',
        '71069' => 'LA',
        '71070' => 'LA',
        '71071' => 'LA',
        '71072' => 'LA',
        '71073' => 'LA',
        '71075' => 'LA',
        '71078' => 'LA',
        '71079' => 'LA',
        '71082' => 'LA',
        '71101' => 'LA',
        '71103' => 'LA',
        '71104' => 'LA',
        '71105' => 'LA',
        '71106' => 'LA',
        '71107' => 'LA',
        '71108' => 'LA',
        '71109' => 'LA',
        '71110' => 'LA',
        '71111' => 'LA',
        '71112' => 'LA',
        '71115' => 'LA',
        '71118' => 'LA',
        '71119' => 'LA',
        '71129' => 'LA',
        '71201' => 'LA',
        '71202' => 'LA',
        '71203' => 'LA',
        '71209' => 'LA',
        '71212' => 'LA',
        '71218' => 'LA',
        '71219' => 'LA',
        '71220' => 'LA',
        '71222' => 'LA',
        '71223' => 'LA',
        '71225' => 'LA',
        '71226' => 'LA',
        '71227' => 'LA',
        '71229' => 'LA',
        '71230' => 'LA',
        '71232' => 'LA',
        '71233' => 'LA',
        '71234' => 'LA',
        '71235' => 'LA',
        '71237' => 'LA',
        '71238' => 'LA',
        '71241' => 'LA',
        '71242' => 'LA',
        '71243' => 'LA',
        '71245' => 'LA',
        '71247' => 'LA',
        '71250' => 'LA',
        '71251' => 'LA',
        '71253' => 'LA',
        '71254' => 'LA',
        '71256' => 'LA',
        '71259' => 'LA',
        '71260' => 'LA',
        '71261' => 'LA',
        '71263' => 'LA',
        '71264' => 'LA',
        '71266' => 'LA',
        '71268' => 'LA',
        '71269' => 'LA',
        '71270' => 'LA',
        '71272' => 'LA',
        '71275' => 'LA',
        '71276' => 'LA',
        '71277' => 'LA',
        '71279' => 'LA',
        '71280' => 'LA',
        '71282' => 'LA',
        '71286' => 'LA',
        '71291' => 'LA',
        '71292' => 'LA',
        '71295' => 'LA',
        '71301' => 'LA',
        '71302' => 'LA',
        '71303' => 'LA',
        '71316' => 'LA',
        '71320' => 'LA',
        '71322' => 'LA',
        '71323' => 'LA',
        '71325' => 'LA',
        '71326' => 'LA',
        '71327' => 'LA',
        '71328' => 'LA',
        '71330' => 'LA',
        '71331' => 'LA',
        '71333' => 'LA',
        '71334' => 'LA',
        '71336' => 'LA',
        '71339' => 'LA',
        '71340' => 'LA',
        '71341' => 'LA',
        '71342' => 'LA',
        '71343' => 'LA',
        '71345' => 'LA',
        '71346' => 'LA',
        '71350' => 'LA',
        '71351' => 'LA',
        '71353' => 'LA',
        '71354' => 'LA',
        '71355' => 'LA',
        '71356' => 'LA',
        '71357' => 'LA',
        '71358' => 'LA',
        '71359' => 'LA',
        '71360' => 'LA',
        '71362' => 'LA',
        '71366' => 'LA',
        '71367' => 'LA',
        '71368' => 'LA',
        '71369' => 'LA',
        '71371' => 'LA',
        '71373' => 'LA',
        '71375' => 'LA',
        '71378' => 'LA',
        '71401' => 'LA',
        '71403' => 'LA',
        '71404' => 'LA',
        '71405' => 'LA',
        '71406' => 'LA',
        '71407' => 'LA',
        '71409' => 'LA',
        '71410' => 'LA',
        '71411' => 'LA',
        '71414' => 'LA',
        '71415' => 'LA',
        '71416' => 'LA',
        '71417' => 'LA',
        '71418' => 'LA',
        '71419' => 'LA',
        '71422' => 'LA',
        '71423' => 'LA',
        '71424' => 'LA',
        '71425' => 'LA',
        '71426' => 'LA',
        '71427' => 'LA',
        '71428' => 'LA',
        '71429' => 'LA',
        '71430' => 'LA',
        '71432' => 'LA',
        '71433' => 'LA',
        '71434' => 'LA',
        '71435' => 'LA',
        '71438' => 'LA',
        '71439' => 'LA',
        '71441' => 'LA',
        '71446' => 'LA',
        '71447' => 'LA',
        '71449' => 'LA',
        '71450' => 'LA',
        '71452' => 'LA',
        '71454' => 'LA',
        '71455' => 'LA',
        '71456' => 'LA',
        '71457' => 'LA',
        '71459' => 'LA',
        '71461' => 'LA',
        '71462' => 'LA',
        '71463' => 'LA',
        '71465' => 'LA',
        '71466' => 'LA',
        '71467' => 'LA',
        '71468' => 'LA',
        '71469' => 'LA',
        '71472' => 'LA',
        '71473' => 'LA',
        '71474' => 'LA',
        '71475' => 'LA',
        '71479' => 'LA',
        '71480' => 'LA',
        '71483' => 'LA',
        '71485' => 'LA',
        '71486' => 'LA',
        '71497' => 'LA',
        '71601' => 'AR',
        '71602' => 'AR',
        '71603' => 'AR',
        '71630' => 'AR',
        '71631' => 'AR',
        '71635' => 'AR',
        '71638' => 'AR',
        '71639' => 'AR',
        '71640' => 'AR',
        '71642' => 'AR',
        '71643' => 'AR',
        '71644' => 'AR',
        '71646' => 'AR',
        '71647' => 'AR',
        '71651' => 'AR',
        '71652' => 'AR',
        '71653' => 'AR',
        '71654' => 'AR',
        '71655' => 'AR',
        '71658' => 'AR',
        '71659' => 'AR',
        '71660' => 'AR',
        '71661' => 'AR',
        '71662' => 'AR',
        '71663' => 'AR',
        '71665' => 'AR',
        '71666' => 'AR',
        '71667' => 'AR',
        '71670' => 'AR',
        '71671' => 'AR',
        '71674' => 'AR',
        '71675' => 'AR',
        '71676' => 'AR',
        '71677' => 'AR',
        '71678' => 'AR',
        '71701' => 'AR',
        '71720' => 'AR',
        '71721' => 'AR',
        '71722' => 'AR',
        '71724' => 'AR',
        '71725' => 'AR',
        '71726' => 'AR',
        '71728' => 'AR',
        '71730' => 'AR',
        '71740' => 'AR',
        '71742' => 'AR',
        '71743' => 'AR',
        '71744' => 'AR',
        '71745' => 'AR',
        '71747' => 'AR',
        '71748' => 'AR',
        '71749' => 'AR',
        '71751' => 'AR',
        '71752' => 'AR',
        '71753' => 'AR',
        '71758' => 'AR',
        '71759' => 'AR',
        '71762' => 'AR',
        '71763' => 'AR',
        '71764' => 'AR',
        '71765' => 'AR',
        '71766' => 'AR',
        '71770' => 'AR',
        '71772' => 'AR',
        '71801' => 'AR',
        '71820' => 'AR',
        '71822' => 'AR',
        '71823' => 'AR',
        '71825' => 'AR',
        '71826' => 'AR',
        '71827' => 'AR',
        '71831' => 'AR',
        '71832' => 'AR',
        '71833' => 'AR',
        '71834' => 'AR',
        '71835' => 'AR',
        '71836' => 'AR',
        '71837' => 'AR',
        '71838' => 'AR',
        '71839' => 'AR',
        '71841' => 'AR',
        '71842' => 'AR',
        '71845' => 'AR',
        '71846' => 'AR',
        '71847' => 'AR',
        '71851' => 'AR',
        '71852' => 'AR',
        '71853' => 'AR',
        '71854' => 'AR',
        '71855' => 'AR',
        '71857' => 'AR',
        '71858' => 'AR',
        '71859' => 'AR',
        '71860' => 'AR',
        '71861' => 'AR',
        '71862' => 'AR',
        '71864' => 'AR',
        '71865' => 'AR',
        '71866' => 'AR',
        '71901' => 'AR',
        '71909' => 'AR',
        '71913' => 'AR',
        '71921' => 'AR',
        '71922' => 'AR',
        '71923' => 'AR',
        '71929' => 'AR',
        '71933' => 'AR',
        '71935' => 'AR',
        '71937' => 'AR',
        '71940' => 'AR',
        '71941' => 'AR',
        '71942' => 'AR',
        '71943' => 'AR',
        '71944' => 'AR',
        '71945' => 'AR',
        '71949' => 'AR',
        '71950' => 'AR',
        '71952' => 'AR',
        '71953' => 'AR',
        '71956' => 'AR',
        '71957' => 'AR',
        '71958' => 'AR',
        '71959' => 'AR',
        '71960' => 'AR',
        '71961' => 'AR',
        '71962' => 'AR',
        '71964' => 'AR',
        '71965' => 'AR',
        '71968' => 'AR',
        '71969' => 'AR',
        '71970' => 'AR',
        '71971' => 'AR',
        '71972' => 'AR',
        '71973' => 'AR',
        '71998' => 'AR',
        '71999' => 'AR',
        '72001' => 'AR',
        '72002' => 'AR',
        '72003' => 'AR',
        '72004' => 'AR',
        '72005' => 'AR',
        '72006' => 'AR',
        '72007' => 'AR',
        '72010' => 'AR',
        '72011' => 'AR',
        '72012' => 'AR',
        '72013' => 'AR',
        '72014' => 'AR',
        '72015' => 'AR',
        '72016' => 'AR',
        '72017' => 'AR',
        '72019' => 'AR',
        '72020' => 'AR',
        '72021' => 'AR',
        '72022' => 'AR',
        '72023' => 'AR',
        '72024' => 'AR',
        '72025' => 'AR',
        '72026' => 'AR',
        '72027' => 'AR',
        '72028' => 'AR',
        '72029' => 'AR',
        '72030' => 'AR',
        '72031' => 'AR',
        '72032' => 'AR',
        '72034' => 'AR',
        '72035' => 'AR',
        '72036' => 'AR',
        '72038' => 'AR',
        '72039' => 'AR',
        '72040' => 'AR',
        '72041' => 'AR',
        '72042' => 'AR',
        '72044' => 'AR',
        '72045' => 'AR',
        '72046' => 'AR',
        '72047' => 'AR',
        '72048' => 'AR',
        '72051' => 'AR',
        '72052' => 'AR',
        '72053' => 'AR',
        '72055' => 'AR',
        '72057' => 'AR',
        '72058' => 'AR',
        '72059' => 'AR',
        '72060' => 'AR',
        '72061' => 'AR',
        '72063' => 'AR',
        '72064' => 'AR',
        '72065' => 'AR',
        '72066' => 'AR',
        '72067' => 'AR',
        '72068' => 'AR',
        '72069' => 'AR',
        '72070' => 'AR',
        '72072' => 'AR',
        '72073' => 'AR',
        '72074' => 'AR',
        '72075' => 'AR',
        '72076' => 'AR',
        '72079' => 'AR',
        '72080' => 'AR',
        '72081' => 'AR',
        '72082' => 'AR',
        '72083' => 'AR',
        '72084' => 'AR',
        '72085' => 'AR',
        '72086' => 'AR',
        '72087' => 'AR',
        '72088' => 'AR',
        '72099' => 'AR',
        '72101' => 'AR',
        '72102' => 'AR',
        '72103' => 'AR',
        '72104' => 'AR',
        '72106' => 'AR',
        '72107' => 'AR',
        '72108' => 'AR',
        '72110' => 'AR',
        '72111' => 'AR',
        '72112' => 'AR',
        '72113' => 'AR',
        '72114' => 'AR',
        '72116' => 'AR',
        '72117' => 'AR',
        '72118' => 'AR',
        '72119' => 'AR',
        '72120' => 'AR',
        '72121' => 'AR',
        '72122' => 'AR',
        '72123' => 'AR',
        '72125' => 'AR',
        '72126' => 'AR',
        '72127' => 'AR',
        '72128' => 'AR',
        '72129' => 'AR',
        '72130' => 'AR',
        '72131' => 'AR',
        '72132' => 'AR',
        '72133' => 'AR',
        '72134' => 'AR',
        '72135' => 'AR',
        '72136' => 'AR',
        '72137' => 'AR',
        '72139' => 'AR',
        '72140' => 'AR',
        '72141' => 'AR',
        '72142' => 'AR',
        '72143' => 'AR',
        '72150' => 'AR',
        '72152' => 'AR',
        '72153' => 'AR',
        '72156' => 'AR',
        '72157' => 'AR',
        '72160' => 'AR',
        '72165' => 'AR',
        '72166' => 'AR',
        '72167' => 'AR',
        '72168' => 'AR',
        '72169' => 'AR',
        '72170' => 'AR',
        '72173' => 'AR',
        '72175' => 'AR',
        '72176' => 'AR',
        '72178' => 'AR',
        '72179' => 'AR',
        '72180' => 'AR',
        '72181' => 'AR',
        '72182' => 'AR',
        '72183' => 'AR',
        '72199' => 'AR',
        '72201' => 'AR',
        '72202' => 'AR',
        '72204' => 'AR',
        '72205' => 'AR',
        '72206' => 'AR',
        '72207' => 'AR',
        '72209' => 'AR',
        '72210' => 'AR',
        '72211' => 'AR',
        '72212' => 'AR',
        '72223' => 'AR',
        '72227' => 'AR',
        '72301' => 'AR',
        '72311' => 'AR',
        '72313' => 'AR',
        '72315' => 'AR',
        '72320' => 'AR',
        '72322' => 'AR',
        '72324' => 'AR',
        '72325' => 'AR',
        '72326' => 'AR',
        '72327' => 'AR',
        '72328' => 'AR',
        '72329' => 'AR',
        '72330' => 'AR',
        '72331' => 'AR',
        '72332' => 'AR',
        '72333' => 'AR',
        '72335' => 'AR',
        '72338' => 'AR',
        '72339' => 'AR',
        '72340' => 'AR',
        '72341' => 'AR',
        '72342' => 'AR',
        '72346' => 'AR',
        '72347' => 'AR',
        '72348' => 'AR',
        '72350' => 'AR',
        '72351' => 'AR',
        '72352' => 'AR',
        '72353' => 'AR',
        '72354' => 'AR',
        '72355' => 'AR',
        '72358' => 'AR',
        '72359' => 'AR',
        '72360' => 'AR',
        '72364' => 'AR',
        '72365' => 'AR',
        '72366' => 'AR',
        '72367' => 'AR',
        '72368' => 'AR',
        '72369' => 'AR',
        '72370' => 'AR',
        '72372' => 'AR',
        '72373' => 'AR',
        '72374' => 'AR',
        '72376' => 'AR',
        '72377' => 'AR',
        '72379' => 'AR',
        '72383' => 'AR',
        '72384' => 'AR',
        '72386' => 'AR',
        '72387' => 'AR',
        '72389' => 'AR',
        '72390' => 'AR',
        '72391' => 'AR',
        '72392' => 'AR',
        '72394' => 'AR',
        '72395' => 'AR',
        '72396' => 'AR',
        '72401' => 'AR',
        '72404' => 'AR',
        '72405' => 'AR',
        '72410' => 'AR',
        '72411' => 'AR',
        '72412' => 'AR',
        '72413' => 'AR',
        '72414' => 'AR',
        '72415' => 'AR',
        '72416' => 'AR',
        '72417' => 'AR',
        '72419' => 'AR',
        '72421' => 'AR',
        '72422' => 'AR',
        '72424' => 'AR',
        '72425' => 'AR',
        '72426' => 'AR',
        '72427' => 'AR',
        '72428' => 'AR',
        '72429' => 'AR',
        '72430' => 'AR',
        '72431' => 'AR',
        '72432' => 'AR',
        '72433' => 'AR',
        '72434' => 'AR',
        '72435' => 'AR',
        '72436' => 'AR',
        '72437' => 'AR',
        '72438' => 'AR',
        '72440' => 'AR',
        '72441' => 'AR',
        '72442' => 'AR',
        '72443' => 'AR',
        '72444' => 'AR',
        '72445' => 'AR',
        '72447' => 'AR',
        '72449' => 'AR',
        '72450' => 'AR',
        '72453' => 'AR',
        '72454' => 'AR',
        '72455' => 'AR',
        '72456' => 'AR',
        '72457' => 'AR',
        '72458' => 'AR',
        '72459' => 'AR',
        '72460' => 'AR',
        '72461' => 'AR',
        '72462' => 'AR',
        '72464' => 'AR',
        '72466' => 'AR',
        '72467' => 'AR',
        '72469' => 'AR',
        '72470' => 'AR',
        '72471' => 'AR',
        '72472' => 'AR',
        '72473' => 'AR',
        '72476' => 'AR',
        '72478' => 'AR',
        '72479' => 'AR',
        '72482' => 'AR',
        '72501' => 'AR',
        '72512' => 'AR',
        '72513' => 'AR',
        '72515' => 'AR',
        '72517' => 'AR',
        '72519' => 'AR',
        '72520' => 'AR',
        '72521' => 'AR',
        '72522' => 'AR',
        '72523' => 'AR',
        '72524' => 'AR',
        '72526' => 'AR',
        '72527' => 'AR',
        '72528' => 'AR',
        '72529' => 'AR',
        '72530' => 'AR',
        '72531' => 'AR',
        '72532' => 'AR',
        '72533' => 'AR',
        '72534' => 'AR',
        '72536' => 'AR',
        '72537' => 'AR',
        '72538' => 'AR',
        '72539' => 'AR',
        '72540' => 'AR',
        '72542' => 'AR',
        '72543' => 'AR',
        '72544' => 'AR',
        '72546' => 'AR',
        '72550' => 'AR',
        '72553' => 'AR',
        '72554' => 'AR',
        '72555' => 'AR',
        '72556' => 'AR',
        '72560' => 'AR',
        '72561' => 'AR',
        '72562' => 'AR',
        '72564' => 'AR',
        '72565' => 'AR',
        '72566' => 'AR',
        '72567' => 'AR',
        '72568' => 'AR',
        '72569' => 'AR',
        '72571' => 'AR',
        '72572' => 'AR',
        '72573' => 'AR',
        '72576' => 'AR',
        '72577' => 'AR',
        '72578' => 'AR',
        '72579' => 'AR',
        '72581' => 'AR',
        '72583' => 'AR',
        '72584' => 'AR',
        '72585' => 'AR',
        '72587' => 'AR',
        '72601' => 'AR',
        '72611' => 'AR',
        '72615' => 'AR',
        '72616' => 'AR',
        '72617' => 'AR',
        '72619' => 'AR',
        '72623' => 'AR',
        '72624' => 'AR',
        '72626' => 'AR',
        '72628' => 'AR',
        '72629' => 'AR',
        '72630' => 'AR',
        '72631' => 'AR',
        '72632' => 'AR',
        '72633' => 'AR',
        '72634' => 'AR',
        '72635' => 'AR',
        '72636' => 'AR',
        '72638' => 'AR',
        '72639' => 'AR',
        '72640' => 'AR',
        '72641' => 'AR',
        '72642' => 'AR',
        '72644' => 'AR',
        '72645' => 'AR',
        '72648' => 'AR',
        '72650' => 'AR',
        '72651' => 'AR',
        '72653' => 'AR',
        '72655' => 'AR',
        '72658' => 'AR',
        '72660' => 'AR',
        '72661' => 'AR',
        '72662' => 'AR',
        '72663' => 'AR',
        '72666' => 'AR',
        '72668' => 'AR',
        '72669' => 'AR',
        '72670' => 'AR',
        '72672' => 'AR',
        '72675' => 'AR',
        '72677' => 'AR',
        '72679' => 'AR',
        '72680' => 'AR',
        '72682' => 'AR',
        '72683' => 'AR',
        '72685' => 'AR',
        '72686' => 'AR',
        '72687' => 'AR',
        '72701' => 'AR',
        '72703' => 'AR',
        '72704' => 'AR',
        '72712' => 'AR',
        '72713' => 'AR',
        '72714' => 'AR',
        '72715' => 'AR',
        '72717' => 'AR',
        '72718' => 'AR',
        '72719' => 'AR',
        '72721' => 'AR',
        '72722' => 'AR',
        '72727' => 'AR',
        '72729' => 'AR',
        '72730' => 'AR',
        '72732' => 'AR',
        '72734' => 'AR',
        '72736' => 'AR',
        '72738' => 'AR',
        '72739' => 'AR',
        '72740' => 'AR',
        '72742' => 'AR',
        '72744' => 'AR',
        '72745' => 'AR',
        '72747' => 'AR',
        '72749' => 'AR',
        '72751' => 'AR',
        '72752' => 'AR',
        '72753' => 'AR',
        '72756' => 'AR',
        '72758' => 'AR',
        '72760' => 'AR',
        '72761' => 'AR',
        '72762' => 'AR',
        '72764' => 'AR',
        '72768' => 'AR',
        '72769' => 'AR',
        '72773' => 'AR',
        '72774' => 'AR',
        '72776' => 'AR',
        '72801' => 'AR',
        '72802' => 'AR',
        '72821' => 'AR',
        '72823' => 'AR',
        '72824' => 'AR',
        '72826' => 'AR',
        '72827' => 'AR',
        '72828' => 'AR',
        '72829' => 'AR',
        '72830' => 'AR',
        '72832' => 'AR',
        '72833' => 'AR',
        '72834' => 'AR',
        '72835' => 'AR',
        '72837' => 'AR',
        '72838' => 'AR',
        '72839' => 'AR',
        '72840' => 'AR',
        '72841' => 'AR',
        '72842' => 'AR',
        '72843' => 'AR',
        '72845' => 'AR',
        '72846' => 'AR',
        '72847' => 'AR',
        '72851' => 'AR',
        '72852' => 'AR',
        '72853' => 'AR',
        '72854' => 'AR',
        '72855' => 'AR',
        '72856' => 'AR',
        '72857' => 'AR',
        '72858' => 'AR',
        '72860' => 'AR',
        '72863' => 'AR',
        '72865' => 'AR',
        '72901' => 'AR',
        '72903' => 'AR',
        '72904' => 'AR',
        '72905' => 'AR',
        '72908' => 'AR',
        '72916' => 'AR',
        '72921' => 'AR',
        '72923' => 'AR',
        '72926' => 'AR',
        '72927' => 'AR',
        '72928' => 'AR',
        '72930' => 'AR',
        '72932' => 'AR',
        '72933' => 'AR',
        '72934' => 'AR',
        '72935' => 'AR',
        '72936' => 'AR',
        '72937' => 'AR',
        '72938' => 'AR',
        '72940' => 'AR',
        '72941' => 'AR',
        '72943' => 'AR',
        '72944' => 'AR',
        '72945' => 'AR',
        '72946' => 'AR',
        '72947' => 'AR',
        '72948' => 'AR',
        '72949' => 'AR',
        '72950' => 'AR',
        '72951' => 'AR',
        '72952' => 'AR',
        '72955' => 'AR',
        '72956' => 'AR',
        '72958' => 'AR',
        '72959' => 'AR',
        '73001' => 'OK',
        '73002' => 'OK',
        '73003' => 'OK',
        '73004' => 'OK',
        '73005' => 'OK',
        '73006' => 'OK',
        '73007' => 'OK',
        '73008' => 'OK',
        '73009' => 'OK',
        '73010' => 'OK',
        '73011' => 'OK',
        '73012' => 'OK',
        '73013' => 'OK',
        '73014' => 'OK',
        '73015' => 'OK',
        '73016' => 'OK',
        '73017' => 'OK',
        '73018' => 'OK',
        '73019' => 'OK',
        '73020' => 'OK',
        '73021' => 'OK',
        '73022' => 'OK',
        '73024' => 'OK',
        '73025' => 'OK',
        '73026' => 'OK',
        '73027' => 'OK',
        '73028' => 'OK',
        '73029' => 'OK',
        '73030' => 'OK',
        '73031' => 'OK',
        '73032' => 'OK',
        '73033' => 'OK',
        '73034' => 'OK',
        '73036' => 'OK',
        '73038' => 'OK',
        '73040' => 'OK',
        '73041' => 'OK',
        '73042' => 'OK',
        '73043' => 'OK',
        '73044' => 'OK',
        '73045' => 'OK',
        '73047' => 'OK',
        '73048' => 'OK',
        '73049' => 'OK',
        '73050' => 'OK',
        '73051' => 'OK',
        '73052' => 'OK',
        '73053' => 'OK',
        '73054' => 'OK',
        '73055' => 'OK',
        '73056' => 'OK',
        '73057' => 'OK',
        '73058' => 'OK',
        '73059' => 'OK',
        '73061' => 'OK',
        '73062' => 'OK',
        '73063' => 'OK',
        '73064' => 'OK',
        '73065' => 'OK',
        '73066' => 'OK',
        '73067' => 'OK',
        '73068' => 'OK',
        '73069' => 'OK',
        '73070' => 'OK',
        '73071' => 'OK',
        '73072' => 'OK',
        '73073' => 'OK',
        '73074' => 'OK',
        '73075' => 'OK',
        '73077' => 'OK',
        '73078' => 'OK',
        '73079' => 'OK',
        '73080' => 'OK',
        '73082' => 'OK',
        '73084' => 'OK',
        '73086' => 'OK',
        '73089' => 'OK',
        '73090' => 'OK',
        '73092' => 'OK',
        '73093' => 'OK',
        '73095' => 'OK',
        '73096' => 'OK',
        '73097' => 'OK',
        '73098' => 'OK',
        '73099' => 'OK',
        '73102' => 'OK',
        '73103' => 'OK',
        '73104' => 'OK',
        '73105' => 'OK',
        '73106' => 'OK',
        '73107' => 'OK',
        '73108' => 'OK',
        '73109' => 'OK',
        '73110' => 'OK',
        '73111' => 'OK',
        '73112' => 'OK',
        '73114' => 'OK',
        '73115' => 'OK',
        '73116' => 'OK',
        '73117' => 'OK',
        '73118' => 'OK',
        '73119' => 'OK',
        '73120' => 'OK',
        '73121' => 'OK',
        '73122' => 'OK',
        '73127' => 'OK',
        '73128' => 'OK',
        '73129' => 'OK',
        '73130' => 'OK',
        '73131' => 'OK',
        '73132' => 'OK',
        '73134' => 'OK',
        '73135' => 'OK',
        '73139' => 'OK',
        '73141' => 'OK',
        '73142' => 'OK',
        '73145' => 'OK',
        '73149' => 'OK',
        '73150' => 'OK',
        '73151' => 'OK',
        '73159' => 'OK',
        '73160' => 'OK',
        '73162' => 'OK',
        '73165' => 'OK',
        '73169' => 'OK',
        '73170' => 'OK',
        '73173' => 'OK',
        '73179' => 'OK',
        '73401' => 'OK',
        '73425' => 'OK',
        '73430' => 'OK',
        '73432' => 'OK',
        '73433' => 'OK',
        '73434' => 'OK',
        '73435' => 'OK',
        '73436' => 'OK',
        '73437' => 'OK',
        '73438' => 'OK',
        '73439' => 'OK',
        '73440' => 'OK',
        '73441' => 'OK',
        '73442' => 'OK',
        '73443' => 'OK',
        '73444' => 'OK',
        '73446' => 'OK',
        '73447' => 'OK',
        '73448' => 'OK',
        '73449' => 'OK',
        '73450' => 'OK',
        '73453' => 'OK',
        '73455' => 'OK',
        '73456' => 'OK',
        '73458' => 'OK',
        '73459' => 'OK',
        '73460' => 'OK',
        '73461' => 'OK',
        '73463' => 'OK',
        '73481' => 'OK',
        '73487' => 'OK',
        '73488' => 'OK',
        '73491' => 'OK',
        '73501' => 'OK',
        '73503' => 'OK',
        '73505' => 'OK',
        '73507' => 'OK',
        '73520' => 'OK',
        '73521' => 'OK',
        '73523' => 'OK',
        '73526' => 'OK',
        '73527' => 'OK',
        '73528' => 'OK',
        '73529' => 'OK',
        '73530' => 'OK',
        '73531' => 'OK',
        '73532' => 'OK',
        '73533' => 'OK',
        '73537' => 'OK',
        '73538' => 'OK',
        '73539' => 'OK',
        '73540' => 'OK',
        '73541' => 'OK',
        '73542' => 'OK',
        '73543' => 'OK',
        '73544' => 'OK',
        '73546' => 'OK',
        '73547' => 'OK',
        '73548' => 'OK',
        '73549' => 'OK',
        '73550' => 'OK',
        '73551' => 'OK',
        '73552' => 'OK',
        '73553' => 'OK',
        '73554' => 'OK',
        '73555' => 'OK',
        '73556' => 'OK',
        '73557' => 'OK',
        '73559' => 'OK',
        '73560' => 'OK',
        '73562' => 'OK',
        '73564' => 'OK',
        '73565' => 'OK',
        '73566' => 'OK',
        '73567' => 'OK',
        '73568' => 'OK',
        '73569' => 'OK',
        '73570' => 'OK',
        '73571' => 'OK',
        '73572' => 'OK',
        '73573' => 'OK',
        '73601' => 'OK',
        '73620' => 'OK',
        '73622' => 'OK',
        '73624' => 'OK',
        '73625' => 'OK',
        '73626' => 'OK',
        '73627' => 'OK',
        '73628' => 'OK',
        '73632' => 'OK',
        '73638' => 'OK',
        '73639' => 'OK',
        '73641' => 'OK',
        '73642' => 'OK',
        '73644' => 'OK',
        '73645' => 'OK',
        '73646' => 'OK',
        '73647' => 'OK',
        '73650' => 'OK',
        '73651' => 'OK',
        '73654' => 'OK',
        '73655' => 'OK',
        '73658' => 'OK',
        '73659' => 'OK',
        '73660' => 'OK',
        '73661' => 'OK',
        '73662' => 'OK',
        '73663' => 'OK',
        '73664' => 'OK',
        '73666' => 'OK',
        '73667' => 'OK',
        '73668' => 'OK',
        '73669' => 'OK',
        '73673' => 'OK',
        '73701' => 'OK',
        '73703' => 'OK',
        '73705' => 'OK',
        '73716' => 'OK',
        '73717' => 'OK',
        '73718' => 'OK',
        '73719' => 'OK',
        '73720' => 'OK',
        '73722' => 'OK',
        '73724' => 'OK',
        '73726' => 'OK',
        '73727' => 'OK',
        '73728' => 'OK',
        '73729' => 'OK',
        '73730' => 'OK',
        '73731' => 'OK',
        '73733' => 'OK',
        '73734' => 'OK',
        '73735' => 'OK',
        '73736' => 'OK',
        '73737' => 'OK',
        '73738' => 'OK',
        '73739' => 'OK',
        '73741' => 'OK',
        '73742' => 'OK',
        '73743' => 'OK',
        '73744' => 'OK',
        '73746' => 'OK',
        '73747' => 'OK',
        '73749' => 'OK',
        '73750' => 'OK',
        '73753' => 'OK',
        '73754' => 'OK',
        '73755' => 'OK',
        '73756' => 'OK',
        '73757' => 'OK',
        '73758' => 'OK',
        '73759' => 'OK',
        '73760' => 'OK',
        '73761' => 'OK',
        '73762' => 'OK',
        '73763' => 'OK',
        '73764' => 'OK',
        '73766' => 'OK',
        '73768' => 'OK',
        '73770' => 'OK',
        '73771' => 'OK',
        '73772' => 'OK',
        '73773' => 'OK',
        '73801' => 'OK',
        '73832' => 'OK',
        '73834' => 'OK',
        '73835' => 'OK',
        '73838' => 'OK',
        '73840' => 'OK',
        '73841' => 'OK',
        '73842' => 'OK',
        '73843' => 'OK',
        '73844' => 'OK',
        '73848' => 'OK',
        '73851' => 'OK',
        '73852' => 'OK',
        '73853' => 'OK',
        '73855' => 'OK',
        '73857' => 'OK',
        '73858' => 'OK',
        '73859' => 'OK',
        '73860' => 'OK',
        '73901' => 'OK',
        '73931' => 'OK',
        '73932' => 'OK',
        '73933' => 'OK',
        '73937' => 'OK',
        '73938' => 'OK',
        '73939' => 'OK',
        '73942' => 'OK',
        '73944' => 'OK',
        '73945' => 'OK',
        '73946' => 'OK',
        '73947' => 'OK',
        '73949' => 'OK',
        '73950' => 'OK',
        '73951' => 'OK',
        '73960' => 'TX',
        '74001' => 'OK',
        '74002' => 'OK',
        '74003' => 'OK',
        '74006' => 'OK',
        '74008' => 'OK',
        '74010' => 'OK',
        '74011' => 'OK',
        '74012' => 'OK',
        '74014' => 'OK',
        '74015' => 'OK',
        '74016' => 'OK',
        '74017' => 'OK',
        '74019' => 'OK',
        '74020' => 'OK',
        '74021' => 'OK',
        '74022' => 'OK',
        '74023' => 'OK',
        '74026' => 'OK',
        '74027' => 'OK',
        '74028' => 'OK',
        '74029' => 'OK',
        '74030' => 'OK',
        '74032' => 'OK',
        '74033' => 'OK',
        '74034' => 'OK',
        '74035' => 'OK',
        '74036' => 'OK',
        '74037' => 'OK',
        '74038' => 'OK',
        '74039' => 'OK',
        '74041' => 'OK',
        '74042' => 'OK',
        '74044' => 'OK',
        '74045' => 'OK',
        '74046' => 'OK',
        '74047' => 'OK',
        '74048' => 'OK',
        '74050' => 'OK',
        '74051' => 'OK',
        '74052' => 'OK',
        '74053' => 'OK',
        '74054' => 'OK',
        '74055' => 'OK',
        '74056' => 'OK',
        '74058' => 'OK',
        '74059' => 'OK',
        '74060' => 'OK',
        '74061' => 'OK',
        '74062' => 'OK',
        '74063' => 'OK',
        '74066' => 'OK',
        '74068' => 'OK',
        '74070' => 'OK',
        '74071' => 'OK',
        '74072' => 'OK',
        '74073' => 'OK',
        '74074' => 'OK',
        '74075' => 'OK',
        '74077' => 'OK',
        '74078' => 'OK',
        '74079' => 'OK',
        '74080' => 'OK',
        '74081' => 'OK',
        '74082' => 'OK',
        '74083' => 'OK',
        '74084' => 'OK',
        '74085' => 'OK',
        '74103' => 'OK',
        '74104' => 'OK',
        '74105' => 'OK',
        '74106' => 'OK',
        '74107' => 'OK',
        '74108' => 'OK',
        '74110' => 'OK',
        '74112' => 'OK',
        '74114' => 'OK',
        '74115' => 'OK',
        '74116' => 'OK',
        '74117' => 'OK',
        '74119' => 'OK',
        '74120' => 'OK',
        '74126' => 'OK',
        '74127' => 'OK',
        '74128' => 'OK',
        '74129' => 'OK',
        '74130' => 'OK',
        '74131' => 'OK',
        '74132' => 'OK',
        '74133' => 'OK',
        '74134' => 'OK',
        '74135' => 'OK',
        '74136' => 'OK',
        '74137' => 'OK',
        '74145' => 'OK',
        '74146' => 'OK',
        '74171' => 'OK',
        '74301' => 'OK',
        '74330' => 'OK',
        '74331' => 'OK',
        '74332' => 'OK',
        '74333' => 'OK',
        '74337' => 'OK',
        '74338' => 'OK',
        '74339' => 'OK',
        '74340' => 'OK',
        '74342' => 'OK',
        '74343' => 'OK',
        '74344' => 'OK',
        '74346' => 'OK',
        '74347' => 'OK',
        '74349' => 'OK',
        '74350' => 'OK',
        '74352' => 'OK',
        '74354' => 'OK',
        '74358' => 'OK',
        '74359' => 'OK',
        '74360' => 'OK',
        '74361' => 'OK',
        '74363' => 'OK',
        '74364' => 'OK',
        '74365' => 'OK',
        '74366' => 'OK',
        '74367' => 'OK',
        '74368' => 'OK',
        '74369' => 'OK',
        '74370' => 'OK',
        '74401' => 'OK',
        '74403' => 'OK',
        '74421' => 'OK',
        '74422' => 'OK',
        '74423' => 'OK',
        '74425' => 'OK',
        '74426' => 'OK',
        '74427' => 'OK',
        '74428' => 'OK',
        '74429' => 'OK',
        '74430' => 'OK',
        '74431' => 'OK',
        '74432' => 'OK',
        '74434' => 'OK',
        '74435' => 'OK',
        '74436' => 'OK',
        '74437' => 'OK',
        '74438' => 'OK',
        '74441' => 'OK',
        '74442' => 'OK',
        '74445' => 'OK',
        '74446' => 'OK',
        '74447' => 'OK',
        '74450' => 'OK',
        '74451' => 'OK',
        '74452' => 'OK',
        '74454' => 'OK',
        '74455' => 'OK',
        '74456' => 'OK',
        '74457' => 'OK',
        '74458' => 'OK',
        '74459' => 'OK',
        '74460' => 'OK',
        '74462' => 'OK',
        '74463' => 'OK',
        '74464' => 'OK',
        '74467' => 'OK',
        '74468' => 'OK',
        '74469' => 'OK',
        '74470' => 'OK',
        '74471' => 'OK',
        '74472' => 'OK',
        '74477' => 'OK',
        '74501' => 'OK',
        '74521' => 'OK',
        '74522' => 'OK',
        '74523' => 'OK',
        '74525' => 'OK',
        '74528' => 'OK',
        '74530' => 'OK',
        '74531' => 'OK',
        '74533' => 'OK',
        '74534' => 'OK',
        '74535' => 'OK',
        '74536' => 'OK',
        '74538' => 'OK',
        '74540' => 'OK',
        '74543' => 'OK',
        '74546' => 'OK',
        '74547' => 'OK',
        '74549' => 'OK',
        '74552' => 'OK',
        '74553' => 'OK',
        '74554' => 'OK',
        '74555' => 'OK',
        '74556' => 'OK',
        '74557' => 'OK',
        '74558' => 'OK',
        '74560' => 'OK',
        '74561' => 'OK',
        '74562' => 'OK',
        '74563' => 'OK',
        '74565' => 'OK',
        '74567' => 'OK',
        '74569' => 'OK',
        '74570' => 'OK',
        '74571' => 'OK',
        '74572' => 'OK',
        '74574' => 'OK',
        '74576' => 'OK',
        '74577' => 'OK',
        '74578' => 'OK',
        '74601' => 'OK',
        '74604' => 'OK',
        '74630' => 'OK',
        '74631' => 'OK',
        '74632' => 'OK',
        '74633' => 'OK',
        '74636' => 'OK',
        '74637' => 'OK',
        '74640' => 'OK',
        '74641' => 'OK',
        '74643' => 'OK',
        '74644' => 'OK',
        '74646' => 'OK',
        '74647' => 'OK',
        '74650' => 'OK',
        '74651' => 'OK',
        '74652' => 'OK',
        '74653' => 'OK',
        '74701' => 'OK',
        '74720' => 'OK',
        '74721' => 'OK',
        '74722' => 'OK',
        '74723' => 'OK',
        '74724' => 'OK',
        '74726' => 'OK',
        '74727' => 'OK',
        '74728' => 'OK',
        '74729' => 'OK',
        '74730' => 'OK',
        '74731' => 'OK',
        '74733' => 'OK',
        '74734' => 'OK',
        '74735' => 'OK',
        '74736' => 'OK',
        '74737' => 'OK',
        '74738' => 'OK',
        '74740' => 'OK',
        '74741' => 'OK',
        '74743' => 'OK',
        '74745' => 'OK',
        '74747' => 'OK',
        '74748' => 'OK',
        '74750' => 'OK',
        '74753' => 'OK',
        '74754' => 'OK',
        '74755' => 'OK',
        '74756' => 'OK',
        '74759' => 'OK',
        '74760' => 'OK',
        '74761' => 'OK',
        '74764' => 'OK',
        '74766' => 'OK',
        '74801' => 'OK',
        '74804' => 'OK',
        '74820' => 'OK',
        '74824' => 'OK',
        '74825' => 'OK',
        '74826' => 'OK',
        '74827' => 'OK',
        '74829' => 'OK',
        '74830' => 'OK',
        '74831' => 'OK',
        '74832' => 'OK',
        '74833' => 'OK',
        '74834' => 'OK',
        '74836' => 'OK',
        '74837' => 'OK',
        '74839' => 'OK',
        '74840' => 'OK',
        '74842' => 'OK',
        '74843' => 'OK',
        '74844' => 'OK',
        '74845' => 'OK',
        '74848' => 'OK',
        '74849' => 'OK',
        '74850' => 'OK',
        '74851' => 'OK',
        '74852' => 'OK',
        '74854' => 'OK',
        '74855' => 'OK',
        '74856' => 'OK',
        '74857' => 'OK',
        '74859' => 'OK',
        '74860' => 'OK',
        '74864' => 'OK',
        '74865' => 'OK',
        '74866' => 'OK',
        '74867' => 'OK',
        '74868' => 'OK',
        '74869' => 'OK',
        '74871' => 'OK',
        '74872' => 'OK',
        '74873' => 'OK',
        '74875' => 'OK',
        '74878' => 'OK',
        '74880' => 'OK',
        '74881' => 'OK',
        '74883' => 'OK',
        '74884' => 'OK',
        '74901' => 'OK',
        '74902' => 'OK',
        '74930' => 'OK',
        '74931' => 'OK',
        '74932' => 'OK',
        '74935' => 'OK',
        '74936' => 'OK',
        '74937' => 'OK',
        '74939' => 'OK',
        '74940' => 'OK',
        '74941' => 'OK',
        '74942' => 'OK',
        '74943' => 'OK',
        '74944' => 'OK',
        '74945' => 'OK',
        '74946' => 'OK',
        '74947' => 'OK',
        '74948' => 'OK',
        '74949' => 'OK',
        '74951' => 'OK',
        '74953' => 'OK',
        '74954' => 'OK',
        '74955' => 'OK',
        '74956' => 'OK',
        '74957' => 'OK',
        '74959' => 'OK',
        '74960' => 'OK',
        '74962' => 'OK',
        '74963' => 'OK',
        '74964' => 'OK',
        '74965' => 'OK',
        '74966' => 'OK',
        '75001' => 'TX',
        '75002' => 'TX',
        '75006' => 'TX',
        '75007' => 'TX',
        '75009' => 'TX',
        '75010' => 'TX',
        '75013' => 'TX',
        '75019' => 'TX',
        '75020' => 'TX',
        '75021' => 'TX',
        '75022' => 'TX',
        '75023' => 'TX',
        '75024' => 'TX',
        '75025' => 'TX',
        '75028' => 'TX',
        '75032' => 'TX',
        '75033' => 'TX',
        '75034' => 'TX',
        '75035' => 'TX',
        '75036' => 'TX',
        '75038' => 'TX',
        '75039' => 'TX',
        '75040' => 'TX',
        '75041' => 'TX',
        '75042' => 'TX',
        '75043' => 'TX',
        '75044' => 'TX',
        '75048' => 'TX',
        '75050' => 'TX',
        '75051' => 'TX',
        '75052' => 'TX',
        '75054' => 'TX',
        '75056' => 'TX',
        '75057' => 'TX',
        '75058' => 'TX',
        '75060' => 'TX',
        '75061' => 'TX',
        '75062' => 'TX',
        '75063' => 'TX',
        '75065' => 'TX',
        '75067' => 'TX',
        '75068' => 'TX',
        '75069' => 'TX',
        '75070' => 'TX',
        '75071' => 'TX',
        '75072' => 'TX',
        '75074' => 'TX',
        '75075' => 'TX',
        '75076' => 'TX',
        '75077' => 'TX',
        '75078' => 'TX',
        '75080' => 'TX',
        '75081' => 'TX',
        '75082' => 'TX',
        '75087' => 'TX',
        '75088' => 'TX',
        '75089' => 'TX',
        '75090' => 'TX',
        '75092' => 'TX',
        '75093' => 'TX',
        '75094' => 'TX',
        '75098' => 'TX',
        '75101' => 'TX',
        '75102' => 'TX',
        '75103' => 'TX',
        '75104' => 'TX',
        '75105' => 'TX',
        '75109' => 'TX',
        '75110' => 'TX',
        '75114' => 'TX',
        '75115' => 'TX',
        '75116' => 'TX',
        '75117' => 'TX',
        '75119' => 'TX',
        '75124' => 'TX',
        '75125' => 'TX',
        '75126' => 'TX',
        '75127' => 'TX',
        '75132' => 'TX',
        '75134' => 'TX',
        '75135' => 'TX',
        '75137' => 'TX',
        '75140' => 'TX',
        '75141' => 'TX',
        '75142' => 'TX',
        '75143' => 'TX',
        '75144' => 'TX',
        '75146' => 'TX',
        '75147' => 'TX',
        '75148' => 'TX',
        '75149' => 'TX',
        '75150' => 'TX',
        '75152' => 'TX',
        '75153' => 'TX',
        '75154' => 'TX',
        '75155' => 'TX',
        '75156' => 'TX',
        '75157' => 'TX',
        '75158' => 'TX',
        '75159' => 'TX',
        '75160' => 'TX',
        '75161' => 'TX',
        '75163' => 'TX',
        '75164' => 'TX',
        '75165' => 'TX',
        '75166' => 'TX',
        '75167' => 'TX',
        '75169' => 'TX',
        '75172' => 'TX',
        '75173' => 'TX',
        '75180' => 'TX',
        '75181' => 'TX',
        '75182' => 'TX',
        '75189' => 'TX',
        '75201' => 'TX',
        '75202' => 'TX',
        '75203' => 'TX',
        '75204' => 'TX',
        '75205' => 'TX',
        '75206' => 'TX',
        '75207' => 'TX',
        '75208' => 'TX',
        '75209' => 'TX',
        '75210' => 'TX',
        '75211' => 'TX',
        '75212' => 'TX',
        '75214' => 'TX',
        '75215' => 'TX',
        '75216' => 'TX',
        '75217' => 'TX',
        '75218' => 'TX',
        '75219' => 'TX',
        '75220' => 'TX',
        '75223' => 'TX',
        '75224' => 'TX',
        '75225' => 'TX',
        '75226' => 'TX',
        '75227' => 'TX',
        '75228' => 'TX',
        '75229' => 'TX',
        '75230' => 'TX',
        '75231' => 'TX',
        '75232' => 'TX',
        '75233' => 'TX',
        '75234' => 'TX',
        '75235' => 'TX',
        '75236' => 'TX',
        '75237' => 'TX',
        '75238' => 'TX',
        '75240' => 'TX',
        '75241' => 'TX',
        '75243' => 'TX',
        '75244' => 'TX',
        '75246' => 'TX',
        '75247' => 'TX',
        '75248' => 'TX',
        '75249' => 'TX',
        '75251' => 'TX',
        '75252' => 'TX',
        '75253' => 'TX',
        '75254' => 'TX',
        '75261' => 'TX',
        '75270' => 'TX',
        '75287' => 'TX',
        '75390' => 'TX',
        '75401' => 'TX',
        '75402' => 'TX',
        '75407' => 'TX',
        '75409' => 'TX',
        '75410' => 'TX',
        '75411' => 'TX',
        '75412' => 'TX',
        '75413' => 'TX',
        '75414' => 'TX',
        '75415' => 'TX',
        '75416' => 'TX',
        '75417' => 'TX',
        '75418' => 'TX',
        '75420' => 'TX',
        '75421' => 'TX',
        '75422' => 'TX',
        '75423' => 'TX',
        '75424' => 'TX',
        '75426' => 'TX',
        '75428' => 'TX',
        '75429' => 'TX',
        '75431' => 'TX',
        '75432' => 'TX',
        '75433' => 'TX',
        '75434' => 'TX',
        '75435' => 'TX',
        '75436' => 'TX',
        '75437' => 'TX',
        '75438' => 'TX',
        '75439' => 'TX',
        '75440' => 'TX',
        '75441' => 'TX',
        '75442' => 'TX',
        '75446' => 'TX',
        '75447' => 'TX',
        '75448' => 'TX',
        '75449' => 'TX',
        '75450' => 'TX',
        '75451' => 'TX',
        '75452' => 'TX',
        '75453' => 'TX',
        '75454' => 'TX',
        '75455' => 'TX',
        '75457' => 'TX',
        '75459' => 'TX',
        '75460' => 'TX',
        '75462' => 'TX',
        '75468' => 'TX',
        '75469' => 'TX',
        '75470' => 'TX',
        '75471' => 'TX',
        '75472' => 'TX',
        '75473' => 'TX',
        '75474' => 'TX',
        '75475' => 'TX',
        '75476' => 'TX',
        '75477' => 'TX',
        '75478' => 'TX',
        '75479' => 'TX',
        '75480' => 'TX',
        '75481' => 'TX',
        '75482' => 'TX',
        '75486' => 'TX',
        '75487' => 'TX',
        '75488' => 'TX',
        '75489' => 'TX',
        '75490' => 'TX',
        '75491' => 'TX',
        '75492' => 'TX',
        '75493' => 'TX',
        '75494' => 'TX',
        '75495' => 'TX',
        '75496' => 'TX',
        '75497' => 'TX',
        '75501' => 'TX',
        '75503' => 'TX',
        '75550' => 'TX',
        '75551' => 'TX',
        '75554' => 'TX',
        '75555' => 'TX',
        '75556' => 'TX',
        '75558' => 'TX',
        '75559' => 'TX',
        '75560' => 'TX',
        '75561' => 'TX',
        '75562' => 'TX',
        '75563' => 'TX',
        '75564' => 'TX',
        '75565' => 'TX',
        '75566' => 'TX',
        '75567' => 'TX',
        '75568' => 'TX',
        '75569' => 'TX',
        '75570' => 'TX',
        '75571' => 'TX',
        '75572' => 'TX',
        '75573' => 'TX',
        '75574' => 'TX',
        '75601' => 'TX',
        '75602' => 'TX',
        '75603' => 'TX',
        '75604' => 'TX',
        '75605' => 'TX',
        '75630' => 'TX',
        '75631' => 'TX',
        '75633' => 'TX',
        '75638' => 'TX',
        '75639' => 'TX',
        '75640' => 'TX',
        '75641' => 'TX',
        '75642' => 'TX',
        '75643' => 'TX',
        '75644' => 'TX',
        '75645' => 'TX',
        '75647' => 'TX',
        '75650' => 'TX',
        '75651' => 'TX',
        '75652' => 'TX',
        '75654' => 'TX',
        '75656' => 'TX',
        '75657' => 'TX',
        '75658' => 'TX',
        '75659' => 'TX',
        '75661' => 'TX',
        '75662' => 'TX',
        '75667' => 'TX',
        '75668' => 'TX',
        '75669' => 'TX',
        '75670' => 'TX',
        '75671' => 'TX',
        '75672' => 'TX',
        '75680' => 'TX',
        '75681' => 'TX',
        '75682' => 'TX',
        '75683' => 'TX',
        '75684' => 'TX',
        '75686' => 'TX',
        '75687' => 'TX',
        '75689' => 'TX',
        '75691' => 'TX',
        '75692' => 'TX',
        '75693' => 'TX',
        '75694' => 'TX',
        '75701' => 'TX',
        '75702' => 'TX',
        '75703' => 'TX',
        '75704' => 'TX',
        '75705' => 'TX',
        '75706' => 'TX',
        '75707' => 'TX',
        '75708' => 'TX',
        '75709' => 'TX',
        '75711' => 'TX',
        '75750' => 'TX',
        '75751' => 'TX',
        '75752' => 'TX',
        '75754' => 'TX',
        '75755' => 'TX',
        '75756' => 'TX',
        '75757' => 'TX',
        '75758' => 'TX',
        '75759' => 'TX',
        '75760' => 'TX',
        '75762' => 'TX',
        '75763' => 'TX',
        '75764' => 'TX',
        '75765' => 'TX',
        '75766' => 'TX',
        '75770' => 'TX',
        '75771' => 'TX',
        '75773' => 'TX',
        '75778' => 'TX',
        '75779' => 'TX',
        '75780' => 'TX',
        '75782' => 'TX',
        '75783' => 'TX',
        '75784' => 'TX',
        '75785' => 'TX',
        '75788' => 'TX',
        '75789' => 'TX',
        '75790' => 'TX',
        '75791' => 'TX',
        '75792' => 'TX',
        '75801' => 'TX',
        '75803' => 'TX',
        '75831' => 'TX',
        '75833' => 'TX',
        '75835' => 'TX',
        '75838' => 'TX',
        '75839' => 'TX',
        '75840' => 'TX',
        '75844' => 'TX',
        '75845' => 'TX',
        '75846' => 'TX',
        '75847' => 'TX',
        '75848' => 'TX',
        '75849' => 'TX',
        '75850' => 'TX',
        '75851' => 'TX',
        '75852' => 'TX',
        '75853' => 'TX',
        '75855' => 'TX',
        '75856' => 'TX',
        '75858' => 'TX',
        '75859' => 'TX',
        '75860' => 'TX',
        '75861' => 'TX',
        '75862' => 'TX',
        '75865' => 'TX',
        '75884' => 'TX',
        '75886' => 'TX',
        '75901' => 'TX',
        '75903' => 'TX',
        '75904' => 'TX',
        '75925' => 'TX',
        '75926' => 'TX',
        '75928' => 'TX',
        '75929' => 'TX',
        '75930' => 'TX',
        '75931' => 'TX',
        '75932' => 'TX',
        '75933' => 'TX',
        '75934' => 'TX',
        '75935' => 'TX',
        '75936' => 'TX',
        '75937' => 'TX',
        '75938' => 'TX',
        '75939' => 'TX',
        '75941' => 'TX',
        '75942' => 'TX',
        '75943' => 'TX',
        '75944' => 'TX',
        '75946' => 'TX',
        '75948' => 'TX',
        '75949' => 'TX',
        '75951' => 'TX',
        '75954' => 'TX',
        '75956' => 'TX',
        '75959' => 'TX',
        '75960' => 'TX',
        '75961' => 'TX',
        '75962' => 'TX',
        '75964' => 'TX',
        '75965' => 'TX',
        '75966' => 'TX',
        '75968' => 'TX',
        '75969' => 'TX',
        '75972' => 'TX',
        '75973' => 'TX',
        '75974' => 'TX',
        '75975' => 'TX',
        '75976' => 'TX',
        '75977' => 'TX',
        '75979' => 'TX',
        '75980' => 'TX',
        '76001' => 'TX',
        '76002' => 'TX',
        '76005' => 'TX',
        '76006' => 'TX',
        '76008' => 'TX',
        '76009' => 'TX',
        '76010' => 'TX',
        '76011' => 'TX',
        '76012' => 'TX',
        '76013' => 'TX',
        '76014' => 'TX',
        '76015' => 'TX',
        '76016' => 'TX',
        '76017' => 'TX',
        '76018' => 'TX',
        '76020' => 'TX',
        '76021' => 'TX',
        '76022' => 'TX',
        '76023' => 'TX',
        '76028' => 'TX',
        '76031' => 'TX',
        '76033' => 'TX',
        '76034' => 'TX',
        '76035' => 'TX',
        '76036' => 'TX',
        '76039' => 'TX',
        '76040' => 'TX',
        '76041' => 'TX',
        '76043' => 'TX',
        '76044' => 'TX',
        '76048' => 'TX',
        '76049' => 'TX',
        '76050' => 'TX',
        '76051' => 'TX',
        '76052' => 'TX',
        '76053' => 'TX',
        '76054' => 'TX',
        '76055' => 'TX',
        '76058' => 'TX',
        '76059' => 'TX',
        '76060' => 'TX',
        '76061' => 'TX',
        '76063' => 'TX',
        '76064' => 'TX',
        '76065' => 'TX',
        '76066' => 'TX',
        '76067' => 'TX',
        '76070' => 'TX',
        '76071' => 'TX',
        '76073' => 'TX',
        '76077' => 'TX',
        '76078' => 'TX',
        '76082' => 'TX',
        '76084' => 'TX',
        '76085' => 'TX',
        '76086' => 'TX',
        '76087' => 'TX',
        '76088' => 'TX',
        '76092' => 'TX',
        '76093' => 'TX',
        '76102' => 'TX',
        '76103' => 'TX',
        '76104' => 'TX',
        '76105' => 'TX',
        '76106' => 'TX',
        '76107' => 'TX',
        '76108' => 'TX',
        '76109' => 'TX',
        '76110' => 'TX',
        '76111' => 'TX',
        '76112' => 'TX',
        '76114' => 'TX',
        '76115' => 'TX',
        '76116' => 'TX',
        '76117' => 'TX',
        '76118' => 'TX',
        '76119' => 'TX',
        '76120' => 'TX',
        '76123' => 'TX',
        '76126' => 'TX',
        '76127' => 'TX',
        '76129' => 'TX',
        '76131' => 'TX',
        '76132' => 'TX',
        '76133' => 'TX',
        '76134' => 'TX',
        '76135' => 'TX',
        '76137' => 'TX',
        '76140' => 'TX',
        '76148' => 'TX',
        '76155' => 'TX',
        '76164' => 'TX',
        '76177' => 'TX',
        '76179' => 'TX',
        '76180' => 'TX',
        '76182' => 'TX',
        '76201' => 'TX',
        '76203' => 'TX',
        '76205' => 'TX',
        '76207' => 'TX',
        '76208' => 'TX',
        '76209' => 'TX',
        '76210' => 'TX',
        '76225' => 'TX',
        '76226' => 'TX',
        '76227' => 'TX',
        '76228' => 'TX',
        '76230' => 'TX',
        '76233' => 'TX',
        '76234' => 'TX',
        '76238' => 'TX',
        '76239' => 'TX',
        '76240' => 'TX',
        '76241' => 'TX',
        '76244' => 'TX',
        '76245' => 'TX',
        '76247' => 'TX',
        '76248' => 'TX',
        '76249' => 'TX',
        '76250' => 'TX',
        '76251' => 'TX',
        '76252' => 'TX',
        '76253' => 'TX',
        '76255' => 'TX',
        '76258' => 'TX',
        '76259' => 'TX',
        '76261' => 'TX',
        '76262' => 'TX',
        '76263' => 'TX',
        '76264' => 'TX',
        '76265' => 'TX',
        '76266' => 'TX',
        '76267' => 'TX',
        '76268' => 'TX',
        '76270' => 'TX',
        '76271' => 'TX',
        '76272' => 'TX',
        '76273' => 'TX',
        '76301' => 'TX',
        '76302' => 'TX',
        '76305' => 'TX',
        '76306' => 'TX',
        '76308' => 'TX',
        '76309' => 'TX',
        '76310' => 'TX',
        '76311' => 'TX',
        '76351' => 'TX',
        '76354' => 'TX',
        '76357' => 'TX',
        '76360' => 'TX',
        '76363' => 'TX',
        '76364' => 'TX',
        '76365' => 'TX',
        '76366' => 'TX',
        '76367' => 'TX',
        '76370' => 'TX',
        '76371' => 'TX',
        '76372' => 'TX',
        '76373' => 'TX',
        '76374' => 'TX',
        '76377' => 'TX',
        '76379' => 'TX',
        '76380' => 'TX',
        '76384' => 'TX',
        '76388' => 'TX',
        '76389' => 'TX',
        '76401' => 'TX',
        '76402' => 'TX',
        '76424' => 'TX',
        '76426' => 'TX',
        '76427' => 'TX',
        '76429' => 'TX',
        '76430' => 'TX',
        '76431' => 'TX',
        '76432' => 'TX',
        '76433' => 'TX',
        '76435' => 'TX',
        '76436' => 'TX',
        '76437' => 'TX',
        '76439' => 'TX',
        '76442' => 'TX',
        '76443' => 'TX',
        '76444' => 'TX',
        '76445' => 'TX',
        '76446' => 'TX',
        '76448' => 'TX',
        '76449' => 'TX',
        '76450' => 'TX',
        '76452' => 'TX',
        '76453' => 'TX',
        '76454' => 'TX',
        '76455' => 'TX',
        '76457' => 'TX',
        '76458' => 'TX',
        '76459' => 'TX',
        '76460' => 'TX',
        '76462' => 'TX',
        '76463' => 'TX',
        '76464' => 'TX',
        '76466' => 'TX',
        '76469' => 'TX',
        '76470' => 'TX',
        '76471' => 'TX',
        '76472' => 'TX',
        '76474' => 'TX',
        '76475' => 'TX',
        '76476' => 'TX',
        '76481' => 'TX',
        '76483' => 'TX',
        '76484' => 'TX',
        '76486' => 'TX',
        '76487' => 'TX',
        '76490' => 'TX',
        '76491' => 'TX',
        '76501' => 'TX',
        '76502' => 'TX',
        '76504' => 'TX',
        '76511' => 'TX',
        '76513' => 'TX',
        '76518' => 'TX',
        '76519' => 'TX',
        '76520' => 'TX',
        '76522' => 'TX',
        '76523' => 'TX',
        '76524' => 'TX',
        '76525' => 'TX',
        '76527' => 'TX',
        '76528' => 'TX',
        '76530' => 'TX',
        '76531' => 'TX',
        '76534' => 'TX',
        '76537' => 'TX',
        '76538' => 'TX',
        '76539' => 'TX',
        '76541' => 'TX',
        '76542' => 'TX',
        '76543' => 'TX',
        '76544' => 'TX',
        '76548' => 'TX',
        '76549' => 'TX',
        '76550' => 'TX',
        '76554' => 'TX',
        '76556' => 'TX',
        '76557' => 'TX',
        '76559' => 'TX',
        '76561' => 'TX',
        '76565' => 'TX',
        '76566' => 'TX',
        '76567' => 'TX',
        '76569' => 'TX',
        '76570' => 'TX',
        '76571' => 'TX',
        '76573' => 'TX',
        '76574' => 'TX',
        '76577' => 'TX',
        '76578' => 'TX',
        '76579' => 'TX',
        '76596' => 'TX',
        '76597' => 'TX',
        '76598' => 'TX',
        '76599' => 'TX',
        '76621' => 'TX',
        '76622' => 'TX',
        '76623' => 'TX',
        '76624' => 'TX',
        '76626' => 'TX',
        '76627' => 'TX',
        '76628' => 'TX',
        '76629' => 'TX',
        '76630' => 'TX',
        '76631' => 'TX',
        '76632' => 'TX',
        '76633' => 'TX',
        '76634' => 'TX',
        '76635' => 'TX',
        '76636' => 'TX',
        '76637' => 'TX',
        '76638' => 'TX',
        '76639' => 'TX',
        '76640' => 'TX',
        '76641' => 'TX',
        '76642' => 'TX',
        '76643' => 'TX',
        '76645' => 'TX',
        '76648' => 'TX',
        '76649' => 'TX',
        '76650' => 'TX',
        '76651' => 'TX',
        '76652' => 'TX',
        '76653' => 'TX',
        '76654' => 'TX',
        '76655' => 'TX',
        '76656' => 'TX',
        '76657' => 'TX',
        '76660' => 'TX',
        '76661' => 'TX',
        '76664' => 'TX',
        '76665' => 'TX',
        '76666' => 'TX',
        '76667' => 'TX',
        '76670' => 'TX',
        '76671' => 'TX',
        '76673' => 'TX',
        '76676' => 'TX',
        '76678' => 'TX',
        '76679' => 'TX',
        '76680' => 'TX',
        '76681' => 'TX',
        '76682' => 'TX',
        '76685' => 'TX',
        '76686' => 'TX',
        '76687' => 'TX',
        '76689' => 'TX',
        '76690' => 'TX',
        '76691' => 'TX',
        '76692' => 'TX',
        '76693' => 'TX',
        '76701' => 'TX',
        '76704' => 'TX',
        '76705' => 'TX',
        '76706' => 'TX',
        '76707' => 'TX',
        '76708' => 'TX',
        '76710' => 'TX',
        '76711' => 'TX',
        '76712' => 'TX',
        '76798' => 'TX',
        '76801' => 'TX',
        '76802' => 'TX',
        '76820' => 'TX',
        '76821' => 'TX',
        '76823' => 'TX',
        '76824' => 'TX',
        '76825' => 'TX',
        '76827' => 'TX',
        '76828' => 'TX',
        '76831' => 'TX',
        '76832' => 'TX',
        '76834' => 'TX',
        '76836' => 'TX',
        '76837' => 'TX',
        '76841' => 'TX',
        '76842' => 'TX',
        '76844' => 'TX',
        '76845' => 'TX',
        '76848' => 'TX',
        '76849' => 'TX',
        '76852' => 'TX',
        '76853' => 'TX',
        '76854' => 'TX',
        '76856' => 'TX',
        '76857' => 'TX',
        '76858' => 'TX',
        '76859' => 'TX',
        '76861' => 'TX',
        '76862' => 'TX',
        '76864' => 'TX',
        '76865' => 'TX',
        '76866' => 'TX',
        '76869' => 'TX',
        '76870' => 'TX',
        '76871' => 'TX',
        '76872' => 'TX',
        '76873' => 'TX',
        '76874' => 'TX',
        '76875' => 'TX',
        '76877' => 'TX',
        '76878' => 'TX',
        '76880' => 'TX',
        '76882' => 'TX',
        '76884' => 'TX',
        '76885' => 'TX',
        '76887' => 'TX',
        '76888' => 'TX',
        '76890' => 'TX',
        '76901' => 'TX',
        '76902' => 'TX',
        '76903' => 'TX',
        '76904' => 'TX',
        '76905' => 'TX',
        '76908' => 'TX',
        '76909' => 'TX',
        '76930' => 'TX',
        '76932' => 'TX',
        '76933' => 'TX',
        '76934' => 'TX',
        '76935' => 'TX',
        '76936' => 'TX',
        '76937' => 'TX',
        '76939' => 'TX',
        '76940' => 'TX',
        '76941' => 'TX',
        '76943' => 'TX',
        '76945' => 'TX',
        '76950' => 'TX',
        '76951' => 'TX',
        '76953' => 'TX',
        '76955' => 'TX',
        '76957' => 'TX',
        '76958' => 'TX',
        '77002' => 'TX',
        '77003' => 'TX',
        '77004' => 'TX',
        '77005' => 'TX',
        '77006' => 'TX',
        '77007' => 'TX',
        '77008' => 'TX',
        '77009' => 'TX',
        '77010' => 'TX',
        '77011' => 'TX',
        '77012' => 'TX',
        '77013' => 'TX',
        '77014' => 'TX',
        '77015' => 'TX',
        '77016' => 'TX',
        '77017' => 'TX',
        '77018' => 'TX',
        '77019' => 'TX',
        '77020' => 'TX',
        '77021' => 'TX',
        '77022' => 'TX',
        '77023' => 'TX',
        '77024' => 'TX',
        '77025' => 'TX',
        '77026' => 'TX',
        '77027' => 'TX',
        '77028' => 'TX',
        '77029' => 'TX',
        '77030' => 'TX',
        '77031' => 'TX',
        '77032' => 'TX',
        '77033' => 'TX',
        '77034' => 'TX',
        '77035' => 'TX',
        '77036' => 'TX',
        '77037' => 'TX',
        '77038' => 'TX',
        '77039' => 'TX',
        '77040' => 'TX',
        '77041' => 'TX',
        '77042' => 'TX',
        '77043' => 'TX',
        '77044' => 'TX',
        '77045' => 'TX',
        '77046' => 'TX',
        '77047' => 'TX',
        '77048' => 'TX',
        '77049' => 'TX',
        '77050' => 'TX',
        '77051' => 'TX',
        '77053' => 'TX',
        '77054' => 'TX',
        '77055' => 'TX',
        '77056' => 'TX',
        '77057' => 'TX',
        '77058' => 'TX',
        '77059' => 'TX',
        '77060' => 'TX',
        '77061' => 'TX',
        '77062' => 'TX',
        '77063' => 'TX',
        '77064' => 'TX',
        '77065' => 'TX',
        '77066' => 'TX',
        '77067' => 'TX',
        '77068' => 'TX',
        '77069' => 'TX',
        '77070' => 'TX',
        '77071' => 'TX',
        '77072' => 'TX',
        '77073' => 'TX',
        '77074' => 'TX',
        '77075' => 'TX',
        '77076' => 'TX',
        '77077' => 'TX',
        '77078' => 'TX',
        '77079' => 'TX',
        '77080' => 'TX',
        '77081' => 'TX',
        '77082' => 'TX',
        '77083' => 'TX',
        '77084' => 'TX',
        '77085' => 'TX',
        '77086' => 'TX',
        '77087' => 'TX',
        '77088' => 'TX',
        '77089' => 'TX',
        '77090' => 'TX',
        '77091' => 'TX',
        '77092' => 'TX',
        '77093' => 'TX',
        '77094' => 'TX',
        '77095' => 'TX',
        '77096' => 'TX',
        '77098' => 'TX',
        '77099' => 'TX',
        '77204' => 'TX',
        '77301' => 'TX',
        '77302' => 'TX',
        '77303' => 'TX',
        '77304' => 'TX',
        '77306' => 'TX',
        '77316' => 'TX',
        '77318' => 'TX',
        '77320' => 'TX',
        '77326' => 'TX',
        '77327' => 'TX',
        '77328' => 'TX',
        '77331' => 'TX',
        '77334' => 'TX',
        '77335' => 'TX',
        '77336' => 'TX',
        '77338' => 'TX',
        '77339' => 'TX',
        '77340' => 'TX',
        '77341' => 'TX',
        '77342' => 'TX',
        '77345' => 'TX',
        '77346' => 'TX',
        '77350' => 'TX',
        '77351' => 'TX',
        '77354' => 'TX',
        '77355' => 'TX',
        '77356' => 'TX',
        '77357' => 'TX',
        '77358' => 'TX',
        '77359' => 'TX',
        '77360' => 'TX',
        '77362' => 'TX',
        '77363' => 'TX',
        '77364' => 'TX',
        '77365' => 'TX',
        '77367' => 'TX',
        '77368' => 'TX',
        '77369' => 'TX',
        '77371' => 'TX',
        '77372' => 'TX',
        '77373' => 'TX',
        '77374' => 'TX',
        '77375' => 'TX',
        '77376' => 'TX',
        '77377' => 'TX',
        '77378' => 'TX',
        '77379' => 'TX',
        '77380' => 'TX',
        '77381' => 'TX',
        '77382' => 'TX',
        '77384' => 'TX',
        '77385' => 'TX',
        '77386' => 'TX',
        '77388' => 'TX',
        '77389' => 'TX',
        '77396' => 'TX',
        '77401' => 'TX',
        '77406' => 'TX',
        '77407' => 'TX',
        '77412' => 'TX',
        '77414' => 'TX',
        '77415' => 'TX',
        '77417' => 'TX',
        '77418' => 'TX',
        '77419' => 'TX',
        '77420' => 'TX',
        '77422' => 'TX',
        '77423' => 'TX',
        '77426' => 'TX',
        '77428' => 'TX',
        '77429' => 'TX',
        '77430' => 'TX',
        '77431' => 'TX',
        '77432' => 'TX',
        '77433' => 'TX',
        '77434' => 'TX',
        '77435' => 'TX',
        '77436' => 'TX',
        '77437' => 'TX',
        '77440' => 'TX',
        '77441' => 'TX',
        '77442' => 'TX',
        '77443' => 'TX',
        '77444' => 'TX',
        '77445' => 'TX',
        '77446' => 'TX',
        '77447' => 'TX',
        '77448' => 'TX',
        '77449' => 'TX',
        '77450' => 'TX',
        '77451' => 'TX',
        '77453' => 'TX',
        '77454' => 'TX',
        '77455' => 'TX',
        '77456' => 'TX',
        '77457' => 'TX',
        '77458' => 'TX',
        '77459' => 'TX',
        '77460' => 'TX',
        '77461' => 'TX',
        '77464' => 'TX',
        '77465' => 'TX',
        '77466' => 'TX',
        '77467' => 'TX',
        '77468' => 'TX',
        '77469' => 'TX',
        '77470' => 'TX',
        '77471' => 'TX',
        '77473' => 'TX',
        '77474' => 'TX',
        '77475' => 'TX',
        '77476' => 'TX',
        '77477' => 'TX',
        '77478' => 'TX',
        '77479' => 'TX',
        '77480' => 'TX',
        '77481' => 'TX',
        '77482' => 'TX',
        '77483' => 'TX',
        '77484' => 'TX',
        '77485' => 'TX',
        '77486' => 'TX',
        '77488' => 'TX',
        '77489' => 'TX',
        '77493' => 'TX',
        '77494' => 'TX',
        '77498' => 'TX',
        '77502' => 'TX',
        '77503' => 'TX',
        '77504' => 'TX',
        '77505' => 'TX',
        '77506' => 'TX',
        '77507' => 'TX',
        '77510' => 'TX',
        '77511' => 'TX',
        '77514' => 'TX',
        '77515' => 'TX',
        '77517' => 'TX',
        '77518' => 'TX',
        '77519' => 'TX',
        '77520' => 'TX',
        '77521' => 'TX',
        '77523' => 'TX',
        '77530' => 'TX',
        '77531' => 'TX',
        '77532' => 'TX',
        '77533' => 'TX',
        '77534' => 'TX',
        '77535' => 'TX',
        '77536' => 'TX',
        '77538' => 'TX',
        '77539' => 'TX',
        '77541' => 'TX',
        '77545' => 'TX',
        '77546' => 'TX',
        '77547' => 'TX',
        '77550' => 'TX',
        '77551' => 'TX',
        '77554' => 'TX',
        '77555' => 'TX',
        '77560' => 'TX',
        '77561' => 'TX',
        '77562' => 'TX',
        '77563' => 'TX',
        '77564' => 'TX',
        '77565' => 'TX',
        '77566' => 'TX',
        '77568' => 'TX',
        '77571' => 'TX',
        '77573' => 'TX',
        '77575' => 'TX',
        '77577' => 'TX',
        '77578' => 'TX',
        '77580' => 'TX',
        '77581' => 'TX',
        '77582' => 'TX',
        '77583' => 'TX',
        '77584' => 'TX',
        '77585' => 'TX',
        '77586' => 'TX',
        '77587' => 'TX',
        '77590' => 'TX',
        '77591' => 'TX',
        '77597' => 'TX',
        '77598' => 'TX',
        '77611' => 'TX',
        '77612' => 'TX',
        '77613' => 'TX',
        '77614' => 'TX',
        '77615' => 'TX',
        '77616' => 'TX',
        '77617' => 'TX',
        '77619' => 'TX',
        '77622' => 'TX',
        '77623' => 'TX',
        '77624' => 'TX',
        '77625' => 'TX',
        '77627' => 'TX',
        '77629' => 'TX',
        '77630' => 'TX',
        '77632' => 'TX',
        '77640' => 'TX',
        '77642' => 'TX',
        '77650' => 'TX',
        '77651' => 'TX',
        '77655' => 'TX',
        '77656' => 'TX',
        '77657' => 'TX',
        '77659' => 'TX',
        '77660' => 'TX',
        '77661' => 'TX',
        '77662' => 'TX',
        '77663' => 'TX',
        '77664' => 'TX',
        '77665' => 'TX',
        '77701' => 'TX',
        '77702' => 'TX',
        '77703' => 'TX',
        '77705' => 'TX',
        '77706' => 'TX',
        '77707' => 'TX',
        '77708' => 'TX',
        '77713' => 'TX',
        '77801' => 'TX',
        '77802' => 'TX',
        '77803' => 'TX',
        '77807' => 'TX',
        '77808' => 'TX',
        '77830' => 'TX',
        '77831' => 'TX',
        '77833' => 'TX',
        '77835' => 'TX',
        '77836' => 'TX',
        '77837' => 'TX',
        '77840' => 'TX',
        '77843' => 'TX',
        '77845' => 'TX',
        '77852' => 'TX',
        '77853' => 'TX',
        '77855' => 'TX',
        '77856' => 'TX',
        '77857' => 'TX',
        '77859' => 'TX',
        '77861' => 'TX',
        '77863' => 'TX',
        '77864' => 'TX',
        '77865' => 'TX',
        '77866' => 'TX',
        '77867' => 'TX',
        '77868' => 'TX',
        '77871' => 'TX',
        '77872' => 'TX',
        '77873' => 'TX',
        '77875' => 'TX',
        '77876' => 'TX',
        '77878' => 'TX',
        '77879' => 'TX',
        '77880' => 'TX',
        '77882' => 'TX',
        '77901' => 'TX',
        '77904' => 'TX',
        '77905' => 'TX',
        '77950' => 'TX',
        '77951' => 'TX',
        '77954' => 'TX',
        '77957' => 'TX',
        '77960' => 'TX',
        '77961' => 'TX',
        '77962' => 'TX',
        '77963' => 'TX',
        '77964' => 'TX',
        '77968' => 'TX',
        '77969' => 'TX',
        '77970' => 'TX',
        '77971' => 'TX',
        '77973' => 'TX',
        '77974' => 'TX',
        '77975' => 'TX',
        '77976' => 'TX',
        '77977' => 'TX',
        '77978' => 'TX',
        '77979' => 'TX',
        '77982' => 'TX',
        '77983' => 'TX',
        '77984' => 'TX',
        '77986' => 'TX',
        '77987' => 'TX',
        '77988' => 'TX',
        '77990' => 'TX',
        '77991' => 'TX',
        '77993' => 'TX',
        '77994' => 'TX',
        '77995' => 'TX',
        '78001' => 'TX',
        '78002' => 'TX',
        '78003' => 'TX',
        '78004' => 'TX',
        '78005' => 'TX',
        '78006' => 'TX',
        '78007' => 'TX',
        '78008' => 'TX',
        '78009' => 'TX',
        '78010' => 'TX',
        '78011' => 'TX',
        '78012' => 'TX',
        '78013' => 'TX',
        '78014' => 'TX',
        '78015' => 'TX',
        '78016' => 'TX',
        '78017' => 'TX',
        '78019' => 'TX',
        '78021' => 'TX',
        '78022' => 'TX',
        '78023' => 'TX',
        '78024' => 'TX',
        '78025' => 'TX',
        '78026' => 'TX',
        '78027' => 'TX',
        '78028' => 'TX',
        '78029' => 'TX',
        '78039' => 'TX',
        '78040' => 'TX',
        '78041' => 'TX',
        '78043' => 'TX',
        '78044' => 'TX',
        '78045' => 'TX',
        '78046' => 'TX',
        '78050' => 'TX',
        '78052' => 'TX',
        '78055' => 'TX',
        '78056' => 'TX',
        '78057' => 'TX',
        '78058' => 'TX',
        '78059' => 'TX',
        '78061' => 'TX',
        '78062' => 'TX',
        '78063' => 'TX',
        '78064' => 'TX',
        '78065' => 'TX',
        '78066' => 'TX',
        '78067' => 'TX',
        '78069' => 'TX',
        '78070' => 'TX',
        '78071' => 'TX',
        '78072' => 'TX',
        '78073' => 'TX',
        '78074' => 'TX',
        '78075' => 'TX',
        '78076' => 'TX',
        '78101' => 'TX',
        '78102' => 'TX',
        '78104' => 'TX',
        '78107' => 'TX',
        '78108' => 'TX',
        '78109' => 'TX',
        '78111' => 'TX',
        '78112' => 'TX',
        '78113' => 'TX',
        '78114' => 'TX',
        '78116' => 'TX',
        '78117' => 'TX',
        '78118' => 'TX',
        '78119' => 'TX',
        '78121' => 'TX',
        '78122' => 'TX',
        '78123' => 'TX',
        '78124' => 'TX',
        '78125' => 'TX',
        '78130' => 'TX',
        '78132' => 'TX',
        '78133' => 'TX',
        '78140' => 'TX',
        '78141' => 'TX',
        '78142' => 'TX',
        '78143' => 'TX',
        '78144' => 'TX',
        '78145' => 'TX',
        '78146' => 'TX',
        '78147' => 'TX',
        '78148' => 'TX',
        '78150' => 'TX',
        '78151' => 'TX',
        '78152' => 'TX',
        '78154' => 'TX',
        '78155' => 'TX',
        '78159' => 'TX',
        '78160' => 'TX',
        '78161' => 'TX',
        '78162' => 'TX',
        '78163' => 'TX',
        '78164' => 'TX',
        '78201' => 'TX',
        '78202' => 'TX',
        '78203' => 'TX',
        '78204' => 'TX',
        '78205' => 'TX',
        '78207' => 'TX',
        '78208' => 'TX',
        '78209' => 'TX',
        '78210' => 'TX',
        '78211' => 'TX',
        '78212' => 'TX',
        '78213' => 'TX',
        '78214' => 'TX',
        '78215' => 'TX',
        '78216' => 'TX',
        '78217' => 'TX',
        '78218' => 'TX',
        '78219' => 'TX',
        '78220' => 'TX',
        '78221' => 'TX',
        '78222' => 'TX',
        '78223' => 'TX',
        '78224' => 'TX',
        '78225' => 'TX',
        '78226' => 'TX',
        '78227' => 'TX',
        '78228' => 'TX',
        '78229' => 'TX',
        '78230' => 'TX',
        '78231' => 'TX',
        '78232' => 'TX',
        '78233' => 'TX',
        '78234' => 'TX',
        '78235' => 'TX',
        '78236' => 'TX',
        '78237' => 'TX',
        '78238' => 'TX',
        '78239' => 'TX',
        '78240' => 'TX',
        '78242' => 'TX',
        '78243' => 'TX',
        '78244' => 'TX',
        '78245' => 'TX',
        '78247' => 'TX',
        '78248' => 'TX',
        '78249' => 'TX',
        '78250' => 'TX',
        '78251' => 'TX',
        '78252' => 'TX',
        '78253' => 'TX',
        '78254' => 'TX',
        '78255' => 'TX',
        '78256' => 'TX',
        '78257' => 'TX',
        '78258' => 'TX',
        '78259' => 'TX',
        '78260' => 'TX',
        '78261' => 'TX',
        '78263' => 'TX',
        '78264' => 'TX',
        '78266' => 'TX',
        '78330' => 'TX',
        '78332' => 'TX',
        '78336' => 'TX',
        '78338' => 'TX',
        '78339' => 'TX',
        '78340' => 'TX',
        '78341' => 'TX',
        '78342' => 'TX',
        '78343' => 'TX',
        '78344' => 'TX',
        '78347' => 'TX',
        '78349' => 'TX',
        '78351' => 'TX',
        '78352' => 'TX',
        '78353' => 'TX',
        '78355' => 'TX',
        '78357' => 'TX',
        '78358' => 'TX',
        '78359' => 'TX',
        '78360' => 'TX',
        '78361' => 'TX',
        '78362' => 'TX',
        '78363' => 'TX',
        '78368' => 'TX',
        '78369' => 'TX',
        '78370' => 'TX',
        '78371' => 'TX',
        '78372' => 'TX',
        '78373' => 'TX',
        '78374' => 'TX',
        '78375' => 'TX',
        '78376' => 'TX',
        '78377' => 'TX',
        '78379' => 'TX',
        '78380' => 'TX',
        '78382' => 'TX',
        '78383' => 'TX',
        '78384' => 'TX',
        '78385' => 'TX',
        '78387' => 'TX',
        '78389' => 'TX',
        '78390' => 'TX',
        '78391' => 'TX',
        '78393' => 'TX',
        '78401' => 'TX',
        '78402' => 'TX',
        '78404' => 'TX',
        '78405' => 'TX',
        '78406' => 'TX',
        '78407' => 'TX',
        '78408' => 'TX',
        '78409' => 'TX',
        '78410' => 'TX',
        '78411' => 'TX',
        '78412' => 'TX',
        '78413' => 'TX',
        '78414' => 'TX',
        '78415' => 'TX',
        '78416' => 'TX',
        '78417' => 'TX',
        '78418' => 'TX',
        '78419' => 'TX',
        '78501' => 'TX',
        '78503' => 'TX',
        '78504' => 'TX',
        '78516' => 'TX',
        '78520' => 'TX',
        '78521' => 'TX',
        '78526' => 'TX',
        '78535' => 'TX',
        '78536' => 'TX',
        '78537' => 'TX',
        '78538' => 'TX',
        '78539' => 'TX',
        '78540' => 'TX',
        '78541' => 'TX',
        '78542' => 'TX',
        '78543' => 'TX',
        '78545' => 'TX',
        '78547' => 'TX',
        '78548' => 'TX',
        '78549' => 'TX',
        '78550' => 'TX',
        '78552' => 'TX',
        '78557' => 'TX',
        '78558' => 'TX',
        '78559' => 'TX',
        '78560' => 'TX',
        '78561' => 'TX',
        '78562' => 'TX',
        '78563' => 'TX',
        '78564' => 'TX',
        '78565' => 'TX',
        '78566' => 'TX',
        '78567' => 'TX',
        '78569' => 'TX',
        '78570' => 'TX',
        '78572' => 'TX',
        '78573' => 'TX',
        '78574' => 'TX',
        '78575' => 'TX',
        '78576' => 'TX',
        '78577' => 'TX',
        '78578' => 'TX',
        '78579' => 'TX',
        '78580' => 'TX',
        '78582' => 'TX',
        '78583' => 'TX',
        '78584' => 'TX',
        '78585' => 'TX',
        '78586' => 'TX',
        '78588' => 'TX',
        '78589' => 'TX',
        '78590' => 'TX',
        '78591' => 'TX',
        '78592' => 'TX',
        '78593' => 'TX',
        '78594' => 'TX',
        '78595' => 'TX',
        '78596' => 'TX',
        '78597' => 'TX',
        '78598' => 'TX',
        '78599' => 'TX',
        '78602' => 'TX',
        '78605' => 'TX',
        '78606' => 'TX',
        '78607' => 'TX',
        '78608' => 'TX',
        '78609' => 'TX',
        '78610' => 'TX',
        '78611' => 'TX',
        '78612' => 'TX',
        '78613' => 'TX',
        '78614' => 'TX',
        '78615' => 'TX',
        '78616' => 'TX',
        '78617' => 'TX',
        '78618' => 'TX',
        '78619' => 'TX',
        '78620' => 'TX',
        '78621' => 'TX',
        '78622' => 'TX',
        '78623' => 'TX',
        '78624' => 'TX',
        '78626' => 'TX',
        '78628' => 'TX',
        '78629' => 'TX',
        '78631' => 'TX',
        '78632' => 'TX',
        '78633' => 'TX',
        '78634' => 'TX',
        '78635' => 'TX',
        '78636' => 'TX',
        '78638' => 'TX',
        '78639' => 'TX',
        '78640' => 'TX',
        '78641' => 'TX',
        '78642' => 'TX',
        '78643' => 'TX',
        '78644' => 'TX',
        '78645' => 'TX',
        '78648' => 'TX',
        '78650' => 'TX',
        '78652' => 'TX',
        '78653' => 'TX',
        '78654' => 'TX',
        '78655' => 'TX',
        '78656' => 'TX',
        '78657' => 'TX',
        '78658' => 'TX',
        '78659' => 'TX',
        '78660' => 'TX',
        '78661' => 'TX',
        '78662' => 'TX',
        '78663' => 'TX',
        '78664' => 'TX',
        '78665' => 'TX',
        '78666' => 'TX',
        '78669' => 'TX',
        '78670' => 'TX',
        '78671' => 'TX',
        '78672' => 'TX',
        '78674' => 'TX',
        '78675' => 'TX',
        '78676' => 'TX',
        '78677' => 'TX',
        '78681' => 'TX',
        '78701' => 'TX',
        '78702' => 'TX',
        '78703' => 'TX',
        '78704' => 'TX',
        '78705' => 'TX',
        '78712' => 'TX',
        '78717' => 'TX',
        '78719' => 'TX',
        '78721' => 'TX',
        '78722' => 'TX',
        '78723' => 'TX',
        '78724' => 'TX',
        '78725' => 'TX',
        '78726' => 'TX',
        '78727' => 'TX',
        '78728' => 'TX',
        '78729' => 'TX',
        '78730' => 'TX',
        '78731' => 'TX',
        '78732' => 'TX',
        '78733' => 'TX',
        '78734' => 'TX',
        '78735' => 'TX',
        '78736' => 'TX',
        '78737' => 'TX',
        '78738' => 'TX',
        '78739' => 'TX',
        '78741' => 'TX',
        '78742' => 'TX',
        '78744' => 'TX',
        '78745' => 'TX',
        '78746' => 'TX',
        '78747' => 'TX',
        '78748' => 'TX',
        '78749' => 'TX',
        '78750' => 'TX',
        '78751' => 'TX',
        '78752' => 'TX',
        '78753' => 'TX',
        '78754' => 'TX',
        '78756' => 'TX',
        '78757' => 'TX',
        '78758' => 'TX',
        '78759' => 'TX',
        '78801' => 'TX',
        '78802' => 'TX',
        '78827' => 'TX',
        '78828' => 'TX',
        '78829' => 'TX',
        '78830' => 'TX',
        '78832' => 'TX',
        '78833' => 'TX',
        '78834' => 'TX',
        '78836' => 'TX',
        '78837' => 'TX',
        '78838' => 'TX',
        '78839' => 'TX',
        '78840' => 'TX',
        '78841' => 'TX',
        '78842' => 'TX',
        '78843' => 'TX',
        '78850' => 'TX',
        '78851' => 'TX',
        '78852' => 'TX',
        '78860' => 'TX',
        '78861' => 'TX',
        '78870' => 'TX',
        '78871' => 'TX',
        '78872' => 'TX',
        '78873' => 'TX',
        '78877' => 'TX',
        '78879' => 'TX',
        '78880' => 'TX',
        '78881' => 'TX',
        '78883' => 'TX',
        '78884' => 'TX',
        '78885' => 'TX',
        '78886' => 'TX',
        '78931' => 'TX',
        '78932' => 'TX',
        '78933' => 'TX',
        '78934' => 'TX',
        '78935' => 'TX',
        '78938' => 'TX',
        '78940' => 'TX',
        '78941' => 'TX',
        '78942' => 'TX',
        '78943' => 'TX',
        '78944' => 'TX',
        '78945' => 'TX',
        '78946' => 'TX',
        '78947' => 'TX',
        '78948' => 'TX',
        '78949' => 'TX',
        '78950' => 'TX',
        '78951' => 'TX',
        '78953' => 'TX',
        '78954' => 'TX',
        '78956' => 'TX',
        '78957' => 'TX',
        '78959' => 'TX',
        '78962' => 'TX',
        '78963' => 'TX',
        '79001' => 'TX',
        '79002' => 'TX',
        '79003' => 'TX',
        '79005' => 'TX',
        '79007' => 'TX',
        '79008' => 'TX',
        '79009' => 'TX',
        '79010' => 'TX',
        '79011' => 'TX',
        '79012' => 'TX',
        '79013' => 'TX',
        '79014' => 'TX',
        '79015' => 'TX',
        '79016' => 'TX',
        '79018' => 'TX',
        '79019' => 'TX',
        '79021' => 'TX',
        '79022' => 'TX',
        '79024' => 'TX',
        '79025' => 'TX',
        '79027' => 'TX',
        '79029' => 'TX',
        '79031' => 'TX',
        '79032' => 'TX',
        '79033' => 'TX',
        '79034' => 'TX',
        '79035' => 'TX',
        '79036' => 'TX',
        '79039' => 'TX',
        '79040' => 'TX',
        '79041' => 'TX',
        '79042' => 'TX',
        '79043' => 'TX',
        '79044' => 'TX',
        '79045' => 'TX',
        '79046' => 'TX',
        '79051' => 'TX',
        '79052' => 'TX',
        '79053' => 'TX',
        '79054' => 'TX',
        '79056' => 'TX',
        '79057' => 'TX',
        '79058' => 'TX',
        '79059' => 'TX',
        '79061' => 'TX',
        '79062' => 'TX',
        '79063' => 'TX',
        '79064' => 'TX',
        '79065' => 'TX',
        '79066' => 'TX',
        '79068' => 'TX',
        '79070' => 'TX',
        '79072' => 'TX',
        '79073' => 'TX',
        '79078' => 'TX',
        '79079' => 'TX',
        '79080' => 'TX',
        '79081' => 'TX',
        '79082' => 'TX',
        '79083' => 'TX',
        '79084' => 'TX',
        '79085' => 'TX',
        '79086' => 'TX',
        '79087' => 'TX',
        '79088' => 'TX',
        '79091' => 'TX',
        '79092' => 'TX',
        '79093' => 'TX',
        '79094' => 'TX',
        '79095' => 'TX',
        '79096' => 'TX',
        '79097' => 'TX',
        '79098' => 'TX',
        '79101' => 'TX',
        '79102' => 'TX',
        '79103' => 'TX',
        '79104' => 'TX',
        '79106' => 'TX',
        '79107' => 'TX',
        '79108' => 'TX',
        '79109' => 'TX',
        '79110' => 'TX',
        '79111' => 'TX',
        '79118' => 'TX',
        '79119' => 'TX',
        '79121' => 'TX',
        '79124' => 'TX',
        '79201' => 'TX',
        '79220' => 'TX',
        '79223' => 'TX',
        '79225' => 'TX',
        '79226' => 'TX',
        '79227' => 'TX',
        '79229' => 'TX',
        '79230' => 'TX',
        '79231' => 'TX',
        '79233' => 'TX',
        '79234' => 'TX',
        '79235' => 'TX',
        '79236' => 'TX',
        '79237' => 'TX',
        '79239' => 'TX',
        '79240' => 'TX',
        '79241' => 'TX',
        '79243' => 'TX',
        '79244' => 'TX',
        '79245' => 'TX',
        '79247' => 'TX',
        '79248' => 'TX',
        '79250' => 'TX',
        '79251' => 'TX',
        '79252' => 'TX',
        '79255' => 'TX',
        '79256' => 'TX',
        '79257' => 'TX',
        '79258' => 'TX',
        '79259' => 'TX',
        '79261' => 'TX',
        '79311' => 'TX',
        '79312' => 'TX',
        '79313' => 'TX',
        '79314' => 'TX',
        '79316' => 'TX',
        '79322' => 'TX',
        '79323' => 'TX',
        '79324' => 'TX',
        '79325' => 'TX',
        '79326' => 'TX',
        '79329' => 'TX',
        '79330' => 'TX',
        '79331' => 'TX',
        '79336' => 'TX',
        '79339' => 'TX',
        '79342' => 'TX',
        '79343' => 'TX',
        '79344' => 'TX',
        '79345' => 'TX',
        '79346' => 'TX',
        '79347' => 'TX',
        '79350' => 'TX',
        '79351' => 'TX',
        '79353' => 'TX',
        '79355' => 'TX',
        '79356' => 'TX',
        '79357' => 'TX',
        '79358' => 'TX',
        '79359' => 'TX',
        '79360' => 'TX',
        '79363' => 'TX',
        '79364' => 'TX',
        '79366' => 'TX',
        '79367' => 'TX',
        '79369' => 'TX',
        '79370' => 'TX',
        '79371' => 'TX',
        '79372' => 'TX',
        '79373' => 'TX',
        '79376' => 'TX',
        '79377' => 'TX',
        '79378' => 'TX',
        '79379' => 'TX',
        '79380' => 'TX',
        '79381' => 'TX',
        '79382' => 'TX',
        '79383' => 'TX',
        '79401' => 'TX',
        '79402' => 'TX',
        '79403' => 'TX',
        '79404' => 'TX',
        '79406' => 'TX',
        '79407' => 'TX',
        '79410' => 'TX',
        '79411' => 'TX',
        '79412' => 'TX',
        '79413' => 'TX',
        '79414' => 'TX',
        '79415' => 'TX',
        '79416' => 'TX',
        '79423' => 'TX',
        '79424' => 'TX',
        '79501' => 'TX',
        '79502' => 'TX',
        '79503' => 'TX',
        '79504' => 'TX',
        '79505' => 'TX',
        '79506' => 'TX',
        '79508' => 'TX',
        '79510' => 'TX',
        '79511' => 'TX',
        '79512' => 'TX',
        '79517' => 'TX',
        '79518' => 'TX',
        '79519' => 'TX',
        '79520' => 'TX',
        '79521' => 'TX',
        '79525' => 'TX',
        '79526' => 'TX',
        '79527' => 'TX',
        '79528' => 'TX',
        '79529' => 'TX',
        '79530' => 'TX',
        '79532' => 'TX',
        '79533' => 'TX',
        '79534' => 'TX',
        '79535' => 'TX',
        '79536' => 'TX',
        '79537' => 'TX',
        '79538' => 'TX',
        '79539' => 'TX',
        '79540' => 'TX',
        '79541' => 'TX',
        '79543' => 'TX',
        '79544' => 'TX',
        '79545' => 'TX',
        '79546' => 'TX',
        '79547' => 'TX',
        '79548' => 'TX',
        '79549' => 'TX',
        '79553' => 'TX',
        '79556' => 'TX',
        '79560' => 'TX',
        '79561' => 'TX',
        '79562' => 'TX',
        '79563' => 'TX',
        '79565' => 'TX',
        '79566' => 'TX',
        '79567' => 'TX',
        '79601' => 'TX',
        '79602' => 'TX',
        '79603' => 'TX',
        '79605' => 'TX',
        '79606' => 'TX',
        '79607' => 'TX',
        '79699' => 'TX',
        '79701' => 'TX',
        '79703' => 'TX',
        '79705' => 'TX',
        '79706' => 'TX',
        '79707' => 'TX',
        '79713' => 'TX',
        '79714' => 'TX',
        '79718' => 'TX',
        '79719' => 'TX',
        '79720' => 'TX',
        '79721' => 'TX',
        '79730' => 'TX',
        '79731' => 'TX',
        '79733' => 'TX',
        '79734' => 'TX',
        '79735' => 'TX',
        '79738' => 'TX',
        '79739' => 'TX',
        '79741' => 'TX',
        '79742' => 'TX',
        '79743' => 'TX',
        '79744' => 'TX',
        '79745' => 'TX',
        '79748' => 'TX',
        '79749' => 'TX',
        '79752' => 'TX',
        '79754' => 'TX',
        '79755' => 'TX',
        '79756' => 'TX',
        '79758' => 'TX',
        '79759' => 'TX',
        '79761' => 'TX',
        '79762' => 'TX',
        '79763' => 'TX',
        '79764' => 'TX',
        '79765' => 'TX',
        '79766' => 'TX',
        '79769' => 'TX',
        '79770' => 'TX',
        '79772' => 'TX',
        '79776' => 'TX',
        '79777' => 'TX',
        '79778' => 'TX',
        '79780' => 'TX',
        '79781' => 'TX',
        '79782' => 'TX',
        '79783' => 'TX',
        '79785' => 'TX',
        '79788' => 'TX',
        '79789' => 'TX',
        '79821' => 'TX',
        '79830' => 'TX',
        '79832' => 'TX',
        '79834' => 'TX',
        '79835' => 'TX',
        '79836' => 'TX',
        '79837' => 'TX',
        '79838' => 'TX',
        '79839' => 'TX',
        '79842' => 'TX',
        '79843' => 'TX',
        '79845' => 'TX',
        '79846' => 'TX',
        '79847' => 'TX',
        '79848' => 'TX',
        '79849' => 'TX',
        '79851' => 'TX',
        '79852' => 'TX',
        '79853' => 'TX',
        '79854' => 'TX',
        '79855' => 'TX',
        '79901' => 'TX',
        '79902' => 'TX',
        '79903' => 'TX',
        '79904' => 'TX',
        '79905' => 'TX',
        '79906' => 'TX',
        '79907' => 'TX',
        '79908' => 'TX',
        '79911' => 'TX',
        '79912' => 'TX',
        '79915' => 'TX',
        '79916' => 'TX',
        '79918' => 'TX',
        '79920' => 'TX',
        '79922' => 'TX',
        '79924' => 'TX',
        '79925' => 'TX',
        '79927' => 'TX',
        '79928' => 'TX',
        '79930' => 'TX',
        '79932' => 'TX',
        '79934' => 'TX',
        '79935' => 'TX',
        '79936' => 'TX',
        '79938' => 'TX',
        '80002' => 'CO',
        '80003' => 'CO',
        '80004' => 'CO',
        '80005' => 'CO',
        '80007' => 'CO',
        '80010' => 'CO',
        '80011' => 'CO',
        '80012' => 'CO',
        '80013' => 'CO',
        '80014' => 'CO',
        '80015' => 'CO',
        '80016' => 'CO',
        '80017' => 'CO',
        '80018' => 'CO',
        '80019' => 'CO',
        '80020' => 'CO',
        '80021' => 'CO',
        '80022' => 'CO',
        '80023' => 'CO',
        '80024' => 'CO',
        '80025' => 'CO',
        '80026' => 'CO',
        '80027' => 'CO',
        '80030' => 'CO',
        '80031' => 'CO',
        '80033' => 'CO',
        '80045' => 'CO',
        '80101' => 'CO',
        '80102' => 'CO',
        '80103' => 'CO',
        '80104' => 'CO',
        '80105' => 'CO',
        '80106' => 'CO',
        '80107' => 'CO',
        '80108' => 'CO',
        '80109' => 'CO',
        '80110' => 'CO',
        '80111' => 'CO',
        '80112' => 'CO',
        '80113' => 'CO',
        '80116' => 'CO',
        '80117' => 'CO',
        '80118' => 'CO',
        '80120' => 'CO',
        '80121' => 'CO',
        '80122' => 'CO',
        '80123' => 'CO',
        '80124' => 'CO',
        '80125' => 'CO',
        '80126' => 'CO',
        '80127' => 'CO',
        '80128' => 'CO',
        '80129' => 'CO',
        '80130' => 'CO',
        '80131' => 'CO',
        '80132' => 'CO',
        '80133' => 'CO',
        '80134' => 'CO',
        '80135' => 'CO',
        '80136' => 'CO',
        '80137' => 'CO',
        '80138' => 'CO',
        '80202' => 'CO',
        '80203' => 'CO',
        '80204' => 'CO',
        '80205' => 'CO',
        '80206' => 'CO',
        '80207' => 'CO',
        '80209' => 'CO',
        '80210' => 'CO',
        '80211' => 'CO',
        '80212' => 'CO',
        '80214' => 'CO',
        '80215' => 'CO',
        '80216' => 'CO',
        '80218' => 'CO',
        '80219' => 'CO',
        '80220' => 'CO',
        '80221' => 'CO',
        '80222' => 'CO',
        '80223' => 'CO',
        '80224' => 'CO',
        '80226' => 'CO',
        '80227' => 'CO',
        '80228' => 'CO',
        '80229' => 'CO',
        '80230' => 'CO',
        '80231' => 'CO',
        '80232' => 'CO',
        '80233' => 'CO',
        '80234' => 'CO',
        '80235' => 'CO',
        '80236' => 'CO',
        '80237' => 'CO',
        '80238' => 'CO',
        '80239' => 'CO',
        '80241' => 'CO',
        '80246' => 'CO',
        '80247' => 'CO',
        '80249' => 'CO',
        '80260' => 'CO',
        '80264' => 'CO',
        '80266' => 'CO',
        '80290' => 'CO',
        '80293' => 'CO',
        '80294' => 'CO',
        '80301' => 'CO',
        '80302' => 'CO',
        '80303' => 'CO',
        '80304' => 'CO',
        '80305' => 'CO',
        '80310' => 'CO',
        '80401' => 'CO',
        '80403' => 'CO',
        '80419' => 'CO',
        '80420' => 'CO',
        '80421' => 'CO',
        '80422' => 'CO',
        '80423' => 'CO',
        '80424' => 'CO',
        '80425' => 'CO',
        '80426' => 'CO',
        '80427' => 'CO',
        '80428' => 'CO',
        '80430' => 'CO',
        '80432' => 'CO',
        '80433' => 'CO',
        '80434' => 'CO',
        '80435' => 'CO',
        '80436' => 'CO',
        '80438' => 'CO',
        '80439' => 'CO',
        '80440' => 'CO',
        '80442' => 'CO',
        '80443' => 'CO',
        '80444' => 'CO',
        '80446' => 'CO',
        '80447' => 'CO',
        '80448' => 'CO',
        '80449' => 'CO',
        '80451' => 'CO',
        '80452' => 'CO',
        '80453' => 'CO',
        '80454' => 'CO',
        '80455' => 'CO',
        '80456' => 'CO',
        '80457' => 'CO',
        '80459' => 'CO',
        '80461' => 'CO',
        '80463' => 'CO',
        '80465' => 'CO',
        '80466' => 'CO',
        '80467' => 'CO',
        '80468' => 'CO',
        '80469' => 'CO',
        '80470' => 'CO',
        '80471' => 'CO',
        '80473' => 'CO',
        '80474' => 'CO',
        '80475' => 'CO',
        '80476' => 'CO',
        '80478' => 'CO',
        '80479' => 'CO',
        '80480' => 'CO',
        '80481' => 'CO',
        '80482' => 'CO',
        '80483' => 'CO',
        '80487' => 'CO',
        '80498' => 'CO',
        '80501' => 'CO',
        '80503' => 'CO',
        '80504' => 'CO',
        '80510' => 'CO',
        '80512' => 'CO',
        '80513' => 'CO',
        '80514' => 'CO',
        '80515' => 'CO',
        '80516' => 'CO',
        '80517' => 'CO',
        '80520' => 'CO',
        '80521' => 'CO',
        '80524' => 'CO',
        '80525' => 'CO',
        '80526' => 'CO',
        '80528' => 'CO',
        '80530' => 'CO',
        '80532' => 'CO',
        '80534' => 'CO',
        '80535' => 'CO',
        '80536' => 'CO',
        '80537' => 'CO',
        '80538' => 'CO',
        '80540' => 'CO',
        '80542' => 'CO',
        '80543' => 'CO',
        '80544' => 'CO',
        '80545' => 'CO',
        '80546' => 'CO',
        '80547' => 'CO',
        '80549' => 'CO',
        '80550' => 'CO',
        '80601' => 'CO',
        '80602' => 'CO',
        '80603' => 'CO',
        '80610' => 'CO',
        '80611' => 'CO',
        '80612' => 'CO',
        '80615' => 'CO',
        '80620' => 'CO',
        '80621' => 'CO',
        '80622' => 'CO',
        '80623' => 'CO',
        '80624' => 'CO',
        '80631' => 'CO',
        '80634' => 'CO',
        '80640' => 'CO',
        '80642' => 'CO',
        '80643' => 'CO',
        '80644' => 'CO',
        '80645' => 'CO',
        '80646' => 'CO',
        '80648' => 'CO',
        '80649' => 'CO',
        '80650' => 'CO',
        '80651' => 'CO',
        '80652' => 'CO',
        '80653' => 'CO',
        '80654' => 'CO',
        '80701' => 'CO',
        '80705' => 'CO',
        '80720' => 'CO',
        '80721' => 'CO',
        '80722' => 'CO',
        '80723' => 'CO',
        '80726' => 'CO',
        '80727' => 'CO',
        '80728' => 'CO',
        '80729' => 'CO',
        '80731' => 'CO',
        '80732' => 'CO',
        '80733' => 'CO',
        '80734' => 'CO',
        '80735' => 'CO',
        '80736' => 'CO',
        '80737' => 'CO',
        '80740' => 'CO',
        '80741' => 'CO',
        '80742' => 'CO',
        '80743' => 'CO',
        '80744' => 'CO',
        '80745' => 'CO',
        '80746' => 'CO',
        '80747' => 'CO',
        '80749' => 'CO',
        '80750' => 'CO',
        '80751' => 'CO',
        '80754' => 'CO',
        '80755' => 'CO',
        '80757' => 'CO',
        '80758' => 'CO',
        '80759' => 'CO',
        '80801' => 'CO',
        '80802' => 'CO',
        '80804' => 'CO',
        '80805' => 'CO',
        '80807' => 'CO',
        '80808' => 'CO',
        '80809' => 'CO',
        '80810' => 'CO',
        '80812' => 'CO',
        '80813' => 'CO',
        '80814' => 'CO',
        '80815' => 'CO',
        '80816' => 'CO',
        '80817' => 'CO',
        '80818' => 'CO',
        '80819' => 'CO',
        '80820' => 'CO',
        '80821' => 'CO',
        '80822' => 'CO',
        '80823' => 'CO',
        '80824' => 'CO',
        '80825' => 'CO',
        '80826' => 'CO',
        '80827' => 'CO',
        '80828' => 'CO',
        '80829' => 'CO',
        '80830' => 'CO',
        '80831' => 'CO',
        '80832' => 'CO',
        '80833' => 'CO',
        '80834' => 'CO',
        '80835' => 'CO',
        '80836' => 'CO',
        '80840' => 'CO',
        '80860' => 'CO',
        '80861' => 'CO',
        '80862' => 'CO',
        '80863' => 'CO',
        '80864' => 'CO',
        '80902' => 'CO',
        '80903' => 'CO',
        '80904' => 'CO',
        '80905' => 'CO',
        '80906' => 'CO',
        '80907' => 'CO',
        '80908' => 'CO',
        '80909' => 'CO',
        '80910' => 'CO',
        '80911' => 'CO',
        '80913' => 'CO',
        '80914' => 'CO',
        '80915' => 'CO',
        '80916' => 'CO',
        '80917' => 'CO',
        '80918' => 'CO',
        '80919' => 'CO',
        '80920' => 'CO',
        '80921' => 'CO',
        '80922' => 'CO',
        '80923' => 'CO',
        '80924' => 'CO',
        '80925' => 'CO',
        '80926' => 'CO',
        '80927' => 'CO',
        '80928' => 'CO',
        '80929' => 'CO',
        '80930' => 'CO',
        '80938' => 'CO',
        '80939' => 'CO',
        '80951' => 'CO',
        '81001' => 'CO',
        '81003' => 'CO',
        '81004' => 'CO',
        '81005' => 'CO',
        '81006' => 'CO',
        '81007' => 'CO',
        '81008' => 'CO',
        '81019' => 'CO',
        '81020' => 'CO',
        '81021' => 'CO',
        '81022' => 'CO',
        '81023' => 'CO',
        '81024' => 'CO',
        '81025' => 'CO',
        '81027' => 'CO',
        '81029' => 'CO',
        '81030' => 'CO',
        '81033' => 'CO',
        '81036' => 'CO',
        '81039' => 'CO',
        '81040' => 'CO',
        '81041' => 'CO',
        '81043' => 'CO',
        '81044' => 'CO',
        '81045' => 'CO',
        '81046' => 'CO',
        '81047' => 'CO',
        '81049' => 'CO',
        '81050' => 'CO',
        '81052' => 'CO',
        '81054' => 'CO',
        '81055' => 'CO',
        '81057' => 'CO',
        '81058' => 'CO',
        '81059' => 'CO',
        '81062' => 'CO',
        '81063' => 'CO',
        '81064' => 'CO',
        '81067' => 'CO',
        '81069' => 'CO',
        '81071' => 'CO',
        '81073' => 'CO',
        '81076' => 'CO',
        '81077' => 'CO',
        '81081' => 'CO',
        '81082' => 'CO',
        '81084' => 'CO',
        '81087' => 'CO',
        '81089' => 'CO',
        '81090' => 'CO',
        '81091' => 'CO',
        '81092' => 'CO',
        '81101' => 'CO',
        '81120' => 'CO',
        '81121' => 'CO',
        '81122' => 'CO',
        '81123' => 'CO',
        '81124' => 'CO',
        '81125' => 'CO',
        '81126' => 'CO',
        '81128' => 'CO',
        '81129' => 'CO',
        '81130' => 'CO',
        '81131' => 'CO',
        '81132' => 'CO',
        '81133' => 'CO',
        '81136' => 'CO',
        '81137' => 'CO',
        '81138' => 'CO',
        '81140' => 'CO',
        '81141' => 'CO',
        '81143' => 'CO',
        '81144' => 'CO',
        '81146' => 'CO',
        '81147' => 'CO',
        '81148' => 'CO',
        '81149' => 'CO',
        '81151' => 'CO',
        '81152' => 'CO',
        '81154' => 'CO',
        '81155' => 'CO',
        '81201' => 'CO',
        '81210' => 'CO',
        '81211' => 'CO',
        '81212' => 'CO',
        '81220' => 'CO',
        '81221' => 'CO',
        '81222' => 'CO',
        '81223' => 'CO',
        '81224' => 'CO',
        '81225' => 'CO',
        '81226' => 'CO',
        '81227' => 'CO',
        '81228' => 'CO',
        '81230' => 'CO',
        '81232' => 'CO',
        '81233' => 'CO',
        '81235' => 'CO',
        '81236' => 'CO',
        '81237' => 'CO',
        '81239' => 'CO',
        '81240' => 'CO',
        '81241' => 'CO',
        '81242' => 'CO',
        '81243' => 'CO',
        '81244' => 'CO',
        '81248' => 'CO',
        '81251' => 'CO',
        '81252' => 'CO',
        '81253' => 'CO',
        '81301' => 'CO',
        '81303' => 'CO',
        '81320' => 'CO',
        '81321' => 'CO',
        '81323' => 'CO',
        '81324' => 'CO',
        '81325' => 'CO',
        '81326' => 'CO',
        '81327' => 'CO',
        '81328' => 'CO',
        '81330' => 'CO',
        '81331' => 'CO',
        '81332' => 'CO',
        '81334' => 'CO',
        '81335' => 'CO',
        '81401' => 'CO',
        '81403' => 'CO',
        '81410' => 'CO',
        '81411' => 'CO',
        '81413' => 'CO',
        '81415' => 'CO',
        '81416' => 'CO',
        '81418' => 'CO',
        '81419' => 'CO',
        '81422' => 'CO',
        '81423' => 'CO',
        '81424' => 'CO',
        '81425' => 'CO',
        '81426' => 'CO',
        '81427' => 'CO',
        '81428' => 'CO',
        '81429' => 'CO',
        '81430' => 'CO',
        '81431' => 'CO',
        '81432' => 'CO',
        '81433' => 'CO',
        '81434' => 'CO',
        '81435' => 'CO',
        '81501' => 'CO',
        '81503' => 'CO',
        '81504' => 'CO',
        '81505' => 'CO',
        '81506' => 'CO',
        '81507' => 'CO',
        '81520' => 'CO',
        '81521' => 'CO',
        '81522' => 'CO',
        '81523' => 'CO',
        '81524' => 'CO',
        '81525' => 'CO',
        '81526' => 'CO',
        '81527' => 'CO',
        '81601' => 'CO',
        '81610' => 'CO',
        '81611' => 'CO',
        '81612' => 'CO',
        '81615' => 'CO',
        '81620' => 'CO',
        '81621' => 'CO',
        '81623' => 'CO',
        '81624' => 'CO',
        '81625' => 'CO',
        '81630' => 'CO',
        '81631' => 'CO',
        '81632' => 'CO',
        '81633' => 'CO',
        '81635' => 'CO',
        '81637' => 'CO',
        '81638' => 'CO',
        '81639' => 'CO',
        '81640' => 'CO',
        '81641' => 'CO',
        '81642' => 'CO',
        '81643' => 'CO',
        '81645' => 'CO',
        '81646' => 'CO',
        '81647' => 'CO',
        '81648' => 'CO',
        '81649' => 'CO',
        '81650' => 'CO',
        '81652' => 'CO',
        '81653' => 'CO',
        '81654' => 'CO',
        '81655' => 'CO',
        '81656' => 'CO',
        '81657' => 'CO',
        '82001' => 'WY',
        '82005' => 'WY',
        '82007' => 'WY',
        '82009' => 'WY',
        '82050' => 'WY',
        '82051' => 'WY',
        '82052' => 'WY',
        '82053' => 'WY',
        '82054' => 'WY',
        '82055' => 'WY',
        '82058' => 'WY',
        '82059' => 'WY',
        '82060' => 'WY',
        '82061' => 'WY',
        '82063' => 'WY',
        '82070' => 'WY',
        '82072' => 'WY',
        '82073' => 'WY',
        '82081' => 'WY',
        '82082' => 'WY',
        '82083' => 'WY',
        '82084' => 'WY',
        '82190' => 'WY',
        '82201' => 'WY',
        '82210' => 'WY',
        '82212' => 'WY',
        '82213' => 'WY',
        '82214' => 'WY',
        '82215' => 'WY',
        '82217' => 'WY',
        '82218' => 'WY',
        '82219' => 'WY',
        '82221' => 'WY',
        '82222' => 'WY',
        '82223' => 'WY',
        '82224' => 'WY',
        '82225' => 'WY',
        '82227' => 'WY',
        '82229' => 'WY',
        '82240' => 'WY',
        '82242' => 'WY',
        '82243' => 'WY',
        '82244' => 'WY',
        '82301' => 'WY',
        '82310' => 'WY',
        '82321' => 'WY',
        '82322' => 'WY',
        '82323' => 'WY',
        '82324' => 'WY',
        '82325' => 'WY',
        '82327' => 'WY',
        '82329' => 'WY',
        '82331' => 'WY',
        '82332' => 'WY',
        '82334' => 'WY',
        '82335' => 'WY',
        '82336' => 'WY',
        '82401' => 'WY',
        '82410' => 'WY',
        '82411' => 'WY',
        '82412' => 'WY',
        '82414' => 'WY',
        '82420' => 'WY',
        '82421' => 'WY',
        '82422' => 'WY',
        '82423' => 'WY',
        '82426' => 'WY',
        '82428' => 'WY',
        '82430' => 'WY',
        '82431' => 'WY',
        '82432' => 'WY',
        '82433' => 'WY',
        '82434' => 'WY',
        '82435' => 'WY',
        '82440' => 'WY',
        '82441' => 'WY',
        '82442' => 'WY',
        '82443' => 'WY',
        '82450' => 'WY',
        '82501' => 'WY',
        '82510' => 'WY',
        '82512' => 'WY',
        '82513' => 'WY',
        '82514' => 'WY',
        '82515' => 'WY',
        '82516' => 'WY',
        '82520' => 'WY',
        '82523' => 'WY',
        '82601' => 'WY',
        '82604' => 'WY',
        '82609' => 'WY',
        '82620' => 'WY',
        '82630' => 'WY',
        '82633' => 'WY',
        '82635' => 'WY',
        '82636' => 'WY',
        '82637' => 'WY',
        '82638' => 'WY',
        '82639' => 'WY',
        '82640' => 'WY',
        '82642' => 'WY',
        '82643' => 'WY',
        '82644' => 'WY',
        '82646' => 'WY',
        '82648' => 'WY',
        '82649' => 'WY',
        '82701' => 'WY',
        '82710' => 'WY',
        '82711' => 'WY',
        '82712' => 'WY',
        '82714' => 'WY',
        '82716' => 'WY',
        '82718' => 'WY',
        '82720' => 'WY',
        '82721' => 'WY',
        '82723' => 'WY',
        '82725' => 'WY',
        '82727' => 'WY',
        '82729' => 'WY',
        '82730' => 'WY',
        '82731' => 'WY',
        '82732' => 'WY',
        '82801' => 'WY',
        '82831' => 'WY',
        '82832' => 'WY',
        '82833' => 'WY',
        '82834' => 'WY',
        '82835' => 'WY',
        '82836' => 'WY',
        '82837' => 'WY',
        '82838' => 'WY',
        '82839' => 'WY',
        '82842' => 'WY',
        '82844' => 'WY',
        '82845' => 'WY',
        '82901' => 'WY',
        '82922' => 'WY',
        '82923' => 'WY',
        '82925' => 'WY',
        '82929' => 'WY',
        '82930' => 'WY',
        '82932' => 'WY',
        '82933' => 'WY',
        '82934' => 'WY',
        '82935' => 'WY',
        '82936' => 'WY',
        '82937' => 'WY',
        '82938' => 'WY',
        '82939' => 'WY',
        '82941' => 'WY',
        '82942' => 'WY',
        '82943' => 'WY',
        '82944' => 'WY',
        '82945' => 'WY',
        '83001' => 'WY',
        '83011' => 'WY',
        '83012' => 'WY',
        '83013' => 'WY',
        '83014' => 'WY',
        '83025' => 'WY',
        '83101' => 'WY',
        '83110' => 'WY',
        '83111' => 'WY',
        '83112' => 'WY',
        '83113' => 'WY',
        '83114' => 'WY',
        '83115' => 'WY',
        '83116' => 'WY',
        '83118' => 'WY',
        '83119' => 'WY',
        '83120' => 'WY',
        '83121' => 'WY',
        '83122' => 'WY',
        '83123' => 'WY',
        '83124' => 'WY',
        '83126' => 'WY',
        '83127' => 'WY',
        '83128' => 'WY',
        '83201' => 'ID',
        '83202' => 'ID',
        '83203' => 'ID',
        '83204' => 'ID',
        '83209' => 'ID',
        '83210' => 'ID',
        '83211' => 'ID',
        '83212' => 'ID',
        '83213' => 'ID',
        '83214' => 'ID',
        '83215' => 'ID',
        '83217' => 'ID',
        '83218' => 'ID',
        '83220' => 'ID',
        '83221' => 'ID',
        '83223' => 'ID',
        '83226' => 'ID',
        '83227' => 'ID',
        '83228' => 'ID',
        '83232' => 'ID',
        '83233' => 'ID',
        '83234' => 'ID',
        '83235' => 'ID',
        '83236' => 'ID',
        '83237' => 'ID',
        '83238' => 'ID',
        '83239' => 'ID',
        '83241' => 'ID',
        '83243' => 'ID',
        '83244' => 'ID',
        '83245' => 'ID',
        '83246' => 'ID',
        '83250' => 'ID',
        '83251' => 'ID',
        '83252' => 'ID',
        '83253' => 'ID',
        '83254' => 'ID',
        '83255' => 'ID',
        '83261' => 'ID',
        '83262' => 'ID',
        '83263' => 'ID',
        '83271' => 'ID',
        '83272' => 'ID',
        '83274' => 'ID',
        '83276' => 'ID',
        '83277' => 'ID',
        '83278' => 'ID',
        '83281' => 'ID',
        '83283' => 'ID',
        '83285' => 'ID',
        '83286' => 'ID',
        '83287' => 'ID',
        '83301' => 'ID',
        '83302' => 'ID',
        '83311' => 'ID',
        '83312' => 'ID',
        '83313' => 'ID',
        '83314' => 'ID',
        '83316' => 'ID',
        '83318' => 'ID',
        '83320' => 'ID',
        '83321' => 'ID',
        '83322' => 'ID',
        '83323' => 'ID',
        '83324' => 'ID',
        '83325' => 'ID',
        '83327' => 'ID',
        '83328' => 'ID',
        '83330' => 'ID',
        '83332' => 'ID',
        '83333' => 'ID',
        '83334' => 'ID',
        '83335' => 'ID',
        '83336' => 'ID',
        '83337' => 'ID',
        '83338' => 'ID',
        '83340' => 'ID',
        '83341' => 'ID',
        '83342' => 'ID',
        '83344' => 'ID',
        '83346' => 'ID',
        '83347' => 'ID',
        '83348' => 'ID',
        '83349' => 'ID',
        '83350' => 'ID',
        '83352' => 'ID',
        '83353' => 'ID',
        '83354' => 'ID',
        '83355' => 'ID',
        '83401' => 'ID',
        '83402' => 'ID',
        '83404' => 'ID',
        '83406' => 'ID',
        '83414' => 'WY',
        '83420' => 'ID',
        '83421' => 'ID',
        '83422' => 'ID',
        '83423' => 'ID',
        '83424' => 'ID',
        '83425' => 'ID',
        '83427' => 'ID',
        '83428' => 'ID',
        '83429' => 'ID',
        '83431' => 'ID',
        '83433' => 'ID',
        '83434' => 'ID',
        '83435' => 'ID',
        '83436' => 'ID',
        '83438' => 'ID',
        '83440' => 'ID',
        '83442' => 'ID',
        '83443' => 'ID',
        '83444' => 'ID',
        '83445' => 'ID',
        '83446' => 'ID',
        '83448' => 'ID',
        '83449' => 'ID',
        '83450' => 'ID',
        '83451' => 'ID',
        '83452' => 'ID',
        '83454' => 'ID',
        '83455' => 'ID',
        '83460' => 'ID',
        '83462' => 'ID',
        '83463' => 'ID',
        '83464' => 'ID',
        '83465' => 'ID',
        '83466' => 'ID',
        '83467' => 'ID',
        '83468' => 'ID',
        '83469' => 'ID',
        '83501' => 'ID',
        '83520' => 'ID',
        '83522' => 'ID',
        '83523' => 'ID',
        '83524' => 'ID',
        '83525' => 'ID',
        '83526' => 'ID',
        '83530' => 'ID',
        '83533' => 'ID',
        '83535' => 'ID',
        '83536' => 'ID',
        '83537' => 'ID',
        '83539' => 'ID',
        '83540' => 'ID',
        '83541' => 'ID',
        '83542' => 'ID',
        '83543' => 'ID',
        '83544' => 'ID',
        '83545' => 'ID',
        '83546' => 'ID',
        '83547' => 'ID',
        '83548' => 'ID',
        '83549' => 'ID',
        '83552' => 'ID',
        '83553' => 'ID',
        '83554' => 'ID',
        '83555' => 'ID',
        '83602' => 'ID',
        '83604' => 'ID',
        '83605' => 'ID',
        '83607' => 'ID',
        '83610' => 'ID',
        '83611' => 'ID',
        '83612' => 'ID',
        '83615' => 'ID',
        '83616' => 'ID',
        '83617' => 'ID',
        '83619' => 'ID',
        '83622' => 'ID',
        '83623' => 'ID',
        '83624' => 'ID',
        '83626' => 'ID',
        '83627' => 'ID',
        '83628' => 'ID',
        '83629' => 'ID',
        '83631' => 'ID',
        '83632' => 'ID',
        '83633' => 'ID',
        '83634' => 'ID',
        '83636' => 'ID',
        '83637' => 'ID',
        '83638' => 'ID',
        '83639' => 'ID',
        '83641' => 'ID',
        '83642' => 'ID',
        '83643' => 'ID',
        '83644' => 'ID',
        '83645' => 'ID',
        '83646' => 'ID',
        '83647' => 'ID',
        '83648' => 'ID',
        '83650' => 'ID',
        '83651' => 'ID',
        '83654' => 'ID',
        '83655' => 'ID',
        '83656' => 'ID',
        '83657' => 'ID',
        '83660' => 'ID',
        '83661' => 'ID',
        '83666' => 'ID',
        '83669' => 'ID',
        '83670' => 'ID',
        '83672' => 'ID',
        '83676' => 'ID',
        '83677' => 'ID',
        '83686' => 'ID',
        '83687' => 'ID',
        '83702' => 'ID',
        '83703' => 'ID',
        '83704' => 'ID',
        '83705' => 'ID',
        '83706' => 'ID',
        '83709' => 'ID',
        '83712' => 'ID',
        '83713' => 'ID',
        '83714' => 'ID',
        '83716' => 'ID',
        '83720' => 'ID',
        '83725' => 'ID',
        '83801' => 'ID',
        '83802' => 'ID',
        '83803' => 'ID',
        '83804' => 'ID',
        '83805' => 'ID',
        '83806' => 'ID',
        '83808' => 'ID',
        '83809' => 'ID',
        '83810' => 'ID',
        '83811' => 'ID',
        '83812' => 'ID',
        '83813' => 'ID',
        '83814' => 'ID',
        '83815' => 'ID',
        '83821' => 'ID',
        '83822' => 'ID',
        '83823' => 'ID',
        '83824' => 'ID',
        '83825' => 'ID',
        '83826' => 'ID',
        '83827' => 'ID',
        '83830' => 'ID',
        '83832' => 'ID',
        '83833' => 'ID',
        '83834' => 'ID',
        '83835' => 'ID',
        '83836' => 'ID',
        '83837' => 'ID',
        '83839' => 'ID',
        '83840' => 'ID',
        '83841' => 'ID',
        '83842' => 'ID',
        '83843' => 'ID',
        '83844' => 'ID',
        '83845' => 'ID',
        '83846' => 'ID',
        '83847' => 'ID',
        '83848' => 'ID',
        '83849' => 'ID',
        '83850' => 'ID',
        '83851' => 'ID',
        '83852' => 'ID',
        '83854' => 'ID',
        '83855' => 'ID',
        '83856' => 'ID',
        '83857' => 'ID',
        '83858' => 'ID',
        '83860' => 'ID',
        '83861' => 'ID',
        '83864' => 'ID',
        '83866' => 'ID',
        '83867' => 'ID',
        '83868' => 'ID',
        '83869' => 'ID',
        '83870' => 'ID',
        '83871' => 'ID',
        '83872' => 'ID',
        '83873' => 'ID',
        '83874' => 'ID',
        '83876' => 'ID',
        '84001' => 'UT',
        '84002' => 'UT',
        '84003' => 'UT',
        '84004' => 'UT',
        '84005' => 'UT',
        '84006' => 'UT',
        '84007' => 'UT',
        '84008' => 'UT',
        '84009' => 'UT',
        '84010' => 'UT',
        '84013' => 'UT',
        '84014' => 'UT',
        '84015' => 'UT',
        '84017' => 'UT',
        '84018' => 'UT',
        '84020' => 'UT',
        '84021' => 'UT',
        '84022' => 'UT',
        '84023' => 'UT',
        '84024' => 'UT',
        '84025' => 'UT',
        '84026' => 'UT',
        '84027' => 'UT',
        '84028' => 'UT',
        '84029' => 'UT',
        '84031' => 'UT',
        '84032' => 'UT',
        '84033' => 'UT',
        '84034' => 'UT',
        '84035' => 'UT',
        '84036' => 'UT',
        '84037' => 'UT',
        '84038' => 'UT',
        '84039' => 'UT',
        '84040' => 'UT',
        '84041' => 'UT',
        '84042' => 'UT',
        '84043' => 'UT',
        '84044' => 'UT',
        '84045' => 'UT',
        '84046' => 'UT',
        '84047' => 'UT',
        '84049' => 'UT',
        '84050' => 'UT',
        '84051' => 'UT',
        '84052' => 'UT',
        '84053' => 'UT',
        '84054' => 'UT',
        '84055' => 'UT',
        '84056' => 'UT',
        '84057' => 'UT',
        '84058' => 'UT',
        '84059' => 'UT',
        '84060' => 'UT',
        '84061' => 'UT',
        '84062' => 'UT',
        '84063' => 'UT',
        '84064' => 'UT',
        '84065' => 'UT',
        '84066' => 'UT',
        '84067' => 'UT',
        '84069' => 'UT',
        '84070' => 'UT',
        '84071' => 'UT',
        '84072' => 'UT',
        '84073' => 'UT',
        '84074' => 'UT',
        '84075' => 'UT',
        '84076' => 'UT',
        '84078' => 'UT',
        '84080' => 'UT',
        '84081' => 'UT',
        '84082' => 'UT',
        '84083' => 'UT',
        '84084' => 'UT',
        '84085' => 'UT',
        '84086' => 'UT',
        '84087' => 'UT',
        '84088' => 'UT',
        '84092' => 'UT',
        '84093' => 'UT',
        '84094' => 'UT',
        '84095' => 'UT',
        '84096' => 'UT',
        '84097' => 'UT',
        '84098' => 'UT',
        '84101' => 'UT',
        '84102' => 'UT',
        '84103' => 'UT',
        '84104' => 'UT',
        '84105' => 'UT',
        '84106' => 'UT',
        '84107' => 'UT',
        '84108' => 'UT',
        '84109' => 'UT',
        '84111' => 'UT',
        '84112' => 'UT',
        '84113' => 'UT',
        '84114' => 'UT',
        '84115' => 'UT',
        '84116' => 'UT',
        '84117' => 'UT',
        '84118' => 'UT',
        '84119' => 'UT',
        '84120' => 'UT',
        '84121' => 'UT',
        '84123' => 'UT',
        '84124' => 'UT',
        '84128' => 'UT',
        '84129' => 'UT',
        '84138' => 'UT',
        '84150' => 'UT',
        '84180' => 'UT',
        '84301' => 'UT',
        '84302' => 'UT',
        '84304' => 'UT',
        '84305' => 'UT',
        '84306' => 'UT',
        '84307' => 'UT',
        '84308' => 'UT',
        '84309' => 'UT',
        '84310' => 'UT',
        '84311' => 'UT',
        '84312' => 'UT',
        '84313' => 'UT',
        '84314' => 'UT',
        '84315' => 'UT',
        '84316' => 'UT',
        '84317' => 'UT',
        '84318' => 'UT',
        '84319' => 'UT',
        '84320' => 'UT',
        '84321' => 'UT',
        '84322' => 'UT',
        '84324' => 'UT',
        '84325' => 'UT',
        '84326' => 'UT',
        '84327' => 'UT',
        '84328' => 'UT',
        '84329' => 'UT',
        '84330' => 'UT',
        '84331' => 'UT',
        '84332' => 'UT',
        '84333' => 'UT',
        '84334' => 'UT',
        '84335' => 'UT',
        '84336' => 'UT',
        '84337' => 'UT',
        '84338' => 'UT',
        '84339' => 'UT',
        '84340' => 'UT',
        '84341' => 'UT',
        '84401' => 'UT',
        '84403' => 'UT',
        '84404' => 'UT',
        '84405' => 'UT',
        '84408' => 'UT',
        '84414' => 'UT',
        '84501' => 'UT',
        '84511' => 'UT',
        '84512' => 'UT',
        '84513' => 'UT',
        '84515' => 'UT',
        '84516' => 'UT',
        '84518' => 'UT',
        '84520' => 'UT',
        '84521' => 'UT',
        '84522' => 'UT',
        '84523' => 'UT',
        '84525' => 'UT',
        '84526' => 'UT',
        '84528' => 'UT',
        '84529' => 'UT',
        '84530' => 'UT',
        '84531' => 'UT',
        '84532' => 'UT',
        '84533' => 'UT',
        '84534' => 'UT',
        '84535' => 'UT',
        '84536' => 'UT',
        '84537' => 'UT',
        '84539' => 'UT',
        '84540' => 'UT',
        '84542' => 'UT',
        '84601' => 'UT',
        '84602' => 'UT',
        '84604' => 'UT',
        '84606' => 'UT',
        '84620' => 'UT',
        '84621' => 'UT',
        '84622' => 'UT',
        '84623' => 'UT',
        '84624' => 'UT',
        '84626' => 'UT',
        '84627' => 'UT',
        '84628' => 'UT',
        '84629' => 'UT',
        '84630' => 'UT',
        '84631' => 'UT',
        '84632' => 'UT',
        '84633' => 'UT',
        '84634' => 'UT',
        '84635' => 'UT',
        '84636' => 'UT',
        '84637' => 'UT',
        '84638' => 'UT',
        '84639' => 'UT',
        '84640' => 'UT',
        '84642' => 'UT',
        '84643' => 'UT',
        '84644' => 'UT',
        '84645' => 'UT',
        '84646' => 'UT',
        '84647' => 'UT',
        '84648' => 'UT',
        '84649' => 'UT',
        '84651' => 'UT',
        '84652' => 'UT',
        '84653' => 'UT',
        '84654' => 'UT',
        '84655' => 'UT',
        '84656' => 'UT',
        '84657' => 'UT',
        '84660' => 'UT',
        '84662' => 'UT',
        '84663' => 'UT',
        '84664' => 'UT',
        '84665' => 'UT',
        '84667' => 'UT',
        '84701' => 'UT',
        '84710' => 'UT',
        '84711' => 'UT',
        '84712' => 'UT',
        '84713' => 'UT',
        '84714' => 'UT',
        '84715' => 'UT',
        '84716' => 'UT',
        '84718' => 'UT',
        '84719' => 'UT',
        '84720' => 'UT',
        '84721' => 'UT',
        '84722' => 'UT',
        '84723' => 'UT',
        '84724' => 'UT',
        '84725' => 'UT',
        '84726' => 'UT',
        '84728' => 'UT',
        '84729' => 'UT',
        '84730' => 'UT',
        '84731' => 'UT',
        '84732' => 'UT',
        '84733' => 'UT',
        '84734' => 'UT',
        '84735' => 'UT',
        '84736' => 'UT',
        '84737' => 'UT',
        '84738' => 'UT',
        '84739' => 'UT',
        '84740' => 'UT',
        '84741' => 'UT',
        '84742' => 'UT',
        '84743' => 'UT',
        '84744' => 'UT',
        '84745' => 'UT',
        '84746' => 'UT',
        '84747' => 'UT',
        '84749' => 'UT',
        '84750' => 'UT',
        '84751' => 'UT',
        '84752' => 'UT',
        '84753' => 'UT',
        '84754' => 'UT',
        '84755' => 'UT',
        '84756' => 'UT',
        '84757' => 'UT',
        '84758' => 'UT',
        '84759' => 'UT',
        '84760' => 'UT',
        '84761' => 'UT',
        '84762' => 'UT',
        '84763' => 'UT',
        '84764' => 'UT',
        '84765' => 'UT',
        '84766' => 'UT',
        '84767' => 'UT',
        '84770' => 'UT',
        '84772' => 'UT',
        '84773' => 'UT',
        '84774' => 'UT',
        '84775' => 'UT',
        '84776' => 'UT',
        '84779' => 'UT',
        '84780' => 'UT',
        '84781' => 'UT',
        '84782' => 'UT',
        '84783' => 'UT',
        '84784' => 'UT',
        '84790' => 'UT',
        '85003' => 'AZ',
        '85004' => 'AZ',
        '85006' => 'AZ',
        '85007' => 'AZ',
        '85008' => 'AZ',
        '85009' => 'AZ',
        '85012' => 'AZ',
        '85013' => 'AZ',
        '85014' => 'AZ',
        '85015' => 'AZ',
        '85016' => 'AZ',
        '85017' => 'AZ',
        '85018' => 'AZ',
        '85019' => 'AZ',
        '85020' => 'AZ',
        '85021' => 'AZ',
        '85022' => 'AZ',
        '85023' => 'AZ',
        '85024' => 'AZ',
        '85026' => 'AZ',
        '85027' => 'AZ',
        '85028' => 'AZ',
        '85029' => 'AZ',
        '85031' => 'AZ',
        '85032' => 'AZ',
        '85033' => 'AZ',
        '85034' => 'AZ',
        '85035' => 'AZ',
        '85037' => 'AZ',
        '85040' => 'AZ',
        '85041' => 'AZ',
        '85042' => 'AZ',
        '85043' => 'AZ',
        '85044' => 'AZ',
        '85045' => 'AZ',
        '85048' => 'AZ',
        '85050' => 'AZ',
        '85051' => 'AZ',
        '85053' => 'AZ',
        '85054' => 'AZ',
        '85083' => 'AZ',
        '85085' => 'AZ',
        '85086' => 'AZ',
        '85087' => 'AZ',
        '85118' => 'AZ',
        '85119' => 'AZ',
        '85120' => 'AZ',
        '85121' => 'AZ',
        '85122' => 'AZ',
        '85123' => 'AZ',
        '85128' => 'AZ',
        '85131' => 'AZ',
        '85132' => 'AZ',
        '85135' => 'AZ',
        '85137' => 'AZ',
        '85138' => 'AZ',
        '85139' => 'AZ',
        '85140' => 'AZ',
        '85141' => 'AZ',
        '85142' => 'AZ',
        '85143' => 'AZ',
        '85145' => 'AZ',
        '85147' => 'AZ',
        '85172' => 'AZ',
        '85173' => 'AZ',
        '85191' => 'AZ',
        '85192' => 'AZ',
        '85193' => 'AZ',
        '85194' => 'AZ',
        '85201' => 'AZ',
        '85202' => 'AZ',
        '85203' => 'AZ',
        '85204' => 'AZ',
        '85205' => 'AZ',
        '85206' => 'AZ',
        '85207' => 'AZ',
        '85208' => 'AZ',
        '85209' => 'AZ',
        '85210' => 'AZ',
        '85212' => 'AZ',
        '85213' => 'AZ',
        '85215' => 'AZ',
        '85224' => 'AZ',
        '85225' => 'AZ',
        '85226' => 'AZ',
        '85233' => 'AZ',
        '85234' => 'AZ',
        '85236' => 'AZ',
        '85248' => 'AZ',
        '85249' => 'AZ',
        '85250' => 'AZ',
        '85251' => 'AZ',
        '85253' => 'AZ',
        '85254' => 'AZ',
        '85255' => 'AZ',
        '85256' => 'AZ',
        '85257' => 'AZ',
        '85258' => 'AZ',
        '85259' => 'AZ',
        '85260' => 'AZ',
        '85262' => 'AZ',
        '85263' => 'AZ',
        '85264' => 'AZ',
        '85266' => 'AZ',
        '85268' => 'AZ',
        '85281' => 'AZ',
        '85282' => 'AZ',
        '85283' => 'AZ',
        '85284' => 'AZ',
        '85286' => 'AZ',
        '85295' => 'AZ',
        '85296' => 'AZ',
        '85297' => 'AZ',
        '85298' => 'AZ',
        '85301' => 'AZ',
        '85302' => 'AZ',
        '85303' => 'AZ',
        '85304' => 'AZ',
        '85305' => 'AZ',
        '85306' => 'AZ',
        '85307' => 'AZ',
        '85308' => 'AZ',
        '85309' => 'AZ',
        '85310' => 'AZ',
        '85320' => 'AZ',
        '85321' => 'AZ',
        '85322' => 'AZ',
        '85323' => 'AZ',
        '85324' => 'AZ',
        '85325' => 'AZ',
        '85326' => 'AZ',
        '85328' => 'AZ',
        '85329' => 'AZ',
        '85331' => 'AZ',
        '85332' => 'AZ',
        '85333' => 'AZ',
        '85334' => 'AZ',
        '85335' => 'AZ',
        '85336' => 'AZ',
        '85337' => 'AZ',
        '85338' => 'AZ',
        '85339' => 'AZ',
        '85340' => 'AZ',
        '85341' => 'AZ',
        '85342' => 'AZ',
        '85343' => 'AZ',
        '85344' => 'AZ',
        '85345' => 'AZ',
        '85346' => 'AZ',
        '85347' => 'AZ',
        '85348' => 'AZ',
        '85349' => 'AZ',
        '85350' => 'AZ',
        '85351' => 'AZ',
        '85352' => 'AZ',
        '85353' => 'AZ',
        '85354' => 'AZ',
        '85355' => 'AZ',
        '85356' => 'AZ',
        '85357' => 'AZ',
        '85360' => 'AZ',
        '85361' => 'AZ',
        '85362' => 'AZ',
        '85363' => 'AZ',
        '85364' => 'AZ',
        '85365' => 'AZ',
        '85367' => 'AZ',
        '85371' => 'AZ',
        '85373' => 'AZ',
        '85374' => 'AZ',
        '85375' => 'AZ',
        '85377' => 'AZ',
        '85378' => 'AZ',
        '85379' => 'AZ',
        '85381' => 'AZ',
        '85382' => 'AZ',
        '85383' => 'AZ',
        '85387' => 'AZ',
        '85388' => 'AZ',
        '85390' => 'AZ',
        '85392' => 'AZ',
        '85395' => 'AZ',
        '85396' => 'AZ',
        '85501' => 'AZ',
        '85530' => 'AZ',
        '85531' => 'AZ',
        '85532' => 'AZ',
        '85533' => 'AZ',
        '85534' => 'AZ',
        '85535' => 'AZ',
        '85536' => 'AZ',
        '85539' => 'AZ',
        '85540' => 'AZ',
        '85541' => 'AZ',
        '85542' => 'AZ',
        '85543' => 'AZ',
        '85544' => 'AZ',
        '85545' => 'AZ',
        '85546' => 'AZ',
        '85550' => 'AZ',
        '85551' => 'AZ',
        '85552' => 'AZ',
        '85553' => 'AZ',
        '85554' => 'AZ',
        '85601' => 'AZ',
        '85602' => 'AZ',
        '85603' => 'AZ',
        '85605' => 'AZ',
        '85606' => 'AZ',
        '85607' => 'AZ',
        '85608' => 'AZ',
        '85609' => 'AZ',
        '85610' => 'AZ',
        '85611' => 'AZ',
        '85613' => 'AZ',
        '85614' => 'AZ',
        '85615' => 'AZ',
        '85616' => 'AZ',
        '85617' => 'AZ',
        '85618' => 'AZ',
        '85619' => 'AZ',
        '85620' => 'AZ',
        '85621' => 'AZ',
        '85622' => 'AZ',
        '85623' => 'AZ',
        '85624' => 'AZ',
        '85625' => 'AZ',
        '85626' => 'AZ',
        '85627' => 'AZ',
        '85629' => 'AZ',
        '85630' => 'AZ',
        '85631' => 'AZ',
        '85632' => 'AZ',
        '85633' => 'AZ',
        '85634' => 'AZ',
        '85635' => 'AZ',
        '85637' => 'AZ',
        '85638' => 'AZ',
        '85639' => 'AZ',
        '85640' => 'AZ',
        '85641' => 'AZ',
        '85643' => 'AZ',
        '85645' => 'AZ',
        '85646' => 'AZ',
        '85648' => 'AZ',
        '85650' => 'AZ',
        '85653' => 'AZ',
        '85654' => 'AZ',
        '85658' => 'AZ',
        '85701' => 'AZ',
        '85704' => 'AZ',
        '85705' => 'AZ',
        '85706' => 'AZ',
        '85707' => 'AZ',
        '85708' => 'AZ',
        '85709' => 'AZ',
        '85710' => 'AZ',
        '85711' => 'AZ',
        '85712' => 'AZ',
        '85713' => 'AZ',
        '85714' => 'AZ',
        '85715' => 'AZ',
        '85716' => 'AZ',
        '85718' => 'AZ',
        '85719' => 'AZ',
        '85721' => 'AZ',
        '85723' => 'AZ',
        '85724' => 'AZ',
        '85726' => 'AZ',
        '85730' => 'AZ',
        '85734' => 'AZ',
        '85735' => 'AZ',
        '85736' => 'AZ',
        '85737' => 'AZ',
        '85739' => 'AZ',
        '85741' => 'AZ',
        '85742' => 'AZ',
        '85743' => 'AZ',
        '85745' => 'AZ',
        '85746' => 'AZ',
        '85747' => 'AZ',
        '85748' => 'AZ',
        '85749' => 'AZ',
        '85750' => 'AZ',
        '85755' => 'AZ',
        '85756' => 'AZ',
        '85757' => 'AZ',
        '85901' => 'AZ',
        '85902' => 'AZ',
        '85911' => 'AZ',
        '85912' => 'AZ',
        '85920' => 'AZ',
        '85922' => 'AZ',
        '85923' => 'AZ',
        '85924' => 'AZ',
        '85925' => 'AZ',
        '85926' => 'AZ',
        '85927' => 'AZ',
        '85928' => 'AZ',
        '85929' => 'AZ',
        '85930' => 'AZ',
        '85931' => 'AZ',
        '85932' => 'AZ',
        '85933' => 'AZ',
        '85934' => 'AZ',
        '85935' => 'AZ',
        '85936' => 'AZ',
        '85937' => 'AZ',
        '85938' => 'AZ',
        '85939' => 'AZ',
        '85940' => 'AZ',
        '85941' => 'AZ',
        '85942' => 'AZ',
        '86001' => 'AZ',
        '86003' => 'AZ',
        '86004' => 'AZ',
        '86005' => 'AZ',
        '86011' => 'AZ',
        '86015' => 'AZ',
        '86016' => 'AZ',
        '86017' => 'AZ',
        '86018' => 'AZ',
        '86020' => 'AZ',
        '86021' => 'AZ',
        '86022' => 'AZ',
        '86023' => 'AZ',
        '86024' => 'AZ',
        '86025' => 'AZ',
        '86028' => 'AZ',
        '86029' => 'AZ',
        '86030' => 'AZ',
        '86031' => 'AZ',
        '86032' => 'AZ',
        '86033' => 'AZ',
        '86034' => 'AZ',
        '86035' => 'AZ',
        '86036' => 'AZ',
        '86038' => 'AZ',
        '86039' => 'AZ',
        '86040' => 'AZ',
        '86042' => 'AZ',
        '86043' => 'AZ',
        '86044' => 'AZ',
        '86045' => 'AZ',
        '86046' => 'AZ',
        '86047' => 'AZ',
        '86052' => 'AZ',
        '86053' => 'AZ',
        '86054' => 'AZ',
        '86301' => 'AZ',
        '86303' => 'AZ',
        '86305' => 'AZ',
        '86313' => 'AZ',
        '86314' => 'AZ',
        '86315' => 'AZ',
        '86320' => 'AZ',
        '86321' => 'AZ',
        '86322' => 'AZ',
        '86323' => 'AZ',
        '86324' => 'AZ',
        '86325' => 'AZ',
        '86326' => 'AZ',
        '86327' => 'AZ',
        '86329' => 'AZ',
        '86331' => 'AZ',
        '86332' => 'AZ',
        '86333' => 'AZ',
        '86334' => 'AZ',
        '86335' => 'AZ',
        '86336' => 'AZ',
        '86337' => 'AZ',
        '86338' => 'AZ',
        '86343' => 'AZ',
        '86351' => 'AZ',
        '86401' => 'AZ',
        '86403' => 'AZ',
        '86404' => 'AZ',
        '86406' => 'AZ',
        '86409' => 'AZ',
        '86411' => 'AZ',
        '86413' => 'AZ',
        '86426' => 'AZ',
        '86429' => 'AZ',
        '86431' => 'AZ',
        '86432' => 'AZ',
        '86433' => 'AZ',
        '86434' => 'AZ',
        '86435' => 'AZ',
        '86436' => 'AZ',
        '86437' => 'AZ',
        '86438' => 'AZ',
        '86440' => 'AZ',
        '86441' => 'AZ',
        '86442' => 'AZ',
        '86443' => 'AZ',
        '86444' => 'AZ',
        '86445' => 'AZ',
        '86502' => 'AZ',
        '86503' => 'AZ',
        '86504' => 'AZ',
        '86505' => 'AZ',
        '86506' => 'AZ',
        '86507' => 'AZ',
        '86508' => 'AZ',
        '86510' => 'AZ',
        '86511' => 'AZ',
        '86512' => 'AZ',
        '86514' => 'AZ',
        '86515' => 'AZ',
        '86520' => 'AZ',
        '86535' => 'AZ',
        '86538' => 'AZ',
        '86540' => 'AZ',
        '86544' => 'AZ',
        '86545' => 'AZ',
        '86547' => 'AZ',
        '86556' => 'AZ',
        '87001' => 'NM',
        '87002' => 'NM',
        '87004' => 'NM',
        '87005' => 'NM',
        '87006' => 'NM',
        '87007' => 'NM',
        '87008' => 'NM',
        '87010' => 'NM',
        '87011' => 'NM',
        '87012' => 'NM',
        '87013' => 'NM',
        '87014' => 'NM',
        '87015' => 'NM',
        '87016' => 'NM',
        '87017' => 'NM',
        '87018' => 'NM',
        '87020' => 'NM',
        '87021' => 'NM',
        '87022' => 'NM',
        '87023' => 'NM',
        '87024' => 'NM',
        '87025' => 'NM',
        '87026' => 'NM',
        '87027' => 'NM',
        '87028' => 'NM',
        '87029' => 'NM',
        '87031' => 'NM',
        '87032' => 'NM',
        '87034' => 'NM',
        '87035' => 'NM',
        '87036' => 'NM',
        '87037' => 'NM',
        '87038' => 'NM',
        '87040' => 'NM',
        '87041' => 'NM',
        '87042' => 'NM',
        '87043' => 'NM',
        '87044' => 'NM',
        '87045' => 'NM',
        '87046' => 'NM',
        '87047' => 'NM',
        '87048' => 'NM',
        '87049' => 'NM',
        '87051' => 'NM',
        '87052' => 'NM',
        '87053' => 'NM',
        '87056' => 'NM',
        '87059' => 'NM',
        '87060' => 'NM',
        '87061' => 'NM',
        '87062' => 'NM',
        '87063' => 'NM',
        '87064' => 'NM',
        '87068' => 'NM',
        '87070' => 'NM',
        '87072' => 'NM',
        '87083' => 'NM',
        '87101' => 'NM',
        '87102' => 'NM',
        '87104' => 'NM',
        '87105' => 'NM',
        '87106' => 'NM',
        '87107' => 'NM',
        '87108' => 'NM',
        '87109' => 'NM',
        '87110' => 'NM',
        '87111' => 'NM',
        '87112' => 'NM',
        '87113' => 'NM',
        '87114' => 'NM',
        '87116' => 'NM',
        '87117' => 'NM',
        '87120' => 'NM',
        '87121' => 'NM',
        '87122' => 'NM',
        '87123' => 'NM',
        '87124' => 'NM',
        '87144' => 'NM',
        '87151' => 'NM',
        '87301' => 'NM',
        '87305' => 'NM',
        '87310' => 'NM',
        '87311' => 'NM',
        '87312' => 'NM',
        '87313' => 'NM',
        '87315' => 'NM',
        '87316' => 'NM',
        '87317' => 'NM',
        '87319' => 'NM',
        '87320' => 'NM',
        '87321' => 'NM',
        '87322' => 'NM',
        '87323' => 'NM',
        '87325' => 'NM',
        '87326' => 'NM',
        '87327' => 'NM',
        '87328' => 'NM',
        '87347' => 'NM',
        '87357' => 'NM',
        '87364' => 'NM',
        '87365' => 'NM',
        '87375' => 'NM',
        '87401' => 'NM',
        '87402' => 'NM',
        '87410' => 'NM',
        '87412' => 'NM',
        '87413' => 'NM',
        '87415' => 'NM',
        '87416' => 'NM',
        '87417' => 'NM',
        '87418' => 'NM',
        '87419' => 'NM',
        '87420' => 'NM',
        '87421' => 'NM',
        '87455' => 'NM',
        '87461' => 'NM',
        '87499' => 'NM',
        '87501' => 'NM',
        '87505' => 'NM',
        '87506' => 'NM',
        '87507' => 'NM',
        '87508' => 'NM',
        '87510' => 'NM',
        '87511' => 'NM',
        '87512' => 'NM',
        '87513' => 'NM',
        '87514' => 'NM',
        '87515' => 'NM',
        '87516' => 'NM',
        '87517' => 'NM',
        '87518' => 'NM',
        '87519' => 'NM',
        '87520' => 'NM',
        '87521' => 'NM',
        '87522' => 'NM',
        '87523' => 'NM',
        '87524' => 'NM',
        '87525' => 'NM',
        '87527' => 'NM',
        '87528' => 'NM',
        '87529' => 'NM',
        '87530' => 'NM',
        '87531' => 'NM',
        '87532' => 'NM',
        '87535' => 'NM',
        '87537' => 'NM',
        '87538' => 'NM',
        '87539' => 'NM',
        '87540' => 'NM',
        '87543' => 'NM',
        '87544' => 'NM',
        '87547' => 'NM',
        '87548' => 'NM',
        '87549' => 'NM',
        '87551' => 'NM',
        '87552' => 'NM',
        '87553' => 'NM',
        '87554' => 'NM',
        '87556' => 'NM',
        '87557' => 'NM',
        '87558' => 'NM',
        '87560' => 'NM',
        '87562' => 'NM',
        '87564' => 'NM',
        '87565' => 'NM',
        '87566' => 'NM',
        '87567' => 'NM',
        '87569' => 'NM',
        '87571' => 'NM',
        '87573' => 'NM',
        '87575' => 'NM',
        '87577' => 'NM',
        '87578' => 'NM',
        '87579' => 'NM',
        '87580' => 'NM',
        '87581' => 'NM',
        '87582' => 'NM',
        '87583' => 'NM',
        '87701' => 'NM',
        '87710' => 'NM',
        '87711' => 'NM',
        '87712' => 'NM',
        '87713' => 'NM',
        '87714' => 'NM',
        '87715' => 'NM',
        '87718' => 'NM',
        '87722' => 'NM',
        '87723' => 'NM',
        '87724' => 'NM',
        '87728' => 'NM',
        '87729' => 'NM',
        '87730' => 'NM',
        '87731' => 'NM',
        '87732' => 'NM',
        '87733' => 'NM',
        '87734' => 'NM',
        '87735' => 'NM',
        '87736' => 'NM',
        '87740' => 'NM',
        '87742' => 'NM',
        '87743' => 'NM',
        '87745' => 'NM',
        '87746' => 'NM',
        '87747' => 'NM',
        '87749' => 'NM',
        '87750' => 'NM',
        '87752' => 'NM',
        '87753' => 'NM',
        '87801' => 'NM',
        '87820' => 'NM',
        '87821' => 'NM',
        '87823' => 'NM',
        '87824' => 'NM',
        '87825' => 'NM',
        '87827' => 'NM',
        '87828' => 'NM',
        '87829' => 'NM',
        '87830' => 'NM',
        '87831' => 'NM',
        '87832' => 'NM',
        '87901' => 'NM',
        '87930' => 'NM',
        '87931' => 'NM',
        '87933' => 'NM',
        '87935' => 'NM',
        '87936' => 'NM',
        '87937' => 'NM',
        '87939' => 'NM',
        '87940' => 'NM',
        '87941' => 'NM',
        '87942' => 'NM',
        '87943' => 'NM',
        '88001' => 'NM',
        '88002' => 'NM',
        '88003' => 'NM',
        '88004' => 'NM',
        '88005' => 'NM',
        '88007' => 'NM',
        '88008' => 'NM',
        '88009' => 'NM',
        '88011' => 'NM',
        '88012' => 'NM',
        '88020' => 'NM',
        '88021' => 'NM',
        '88022' => 'NM',
        '88023' => 'NM',
        '88024' => 'NM',
        '88025' => 'NM',
        '88026' => 'NM',
        '88027' => 'NM',
        '88028' => 'NM',
        '88029' => 'NM',
        '88030' => 'NM',
        '88034' => 'NM',
        '88038' => 'NM',
        '88039' => 'NM',
        '88040' => 'NM',
        '88041' => 'NM',
        '88042' => 'NM',
        '88043' => 'NM',
        '88044' => 'NM',
        '88045' => 'NM',
        '88046' => 'NM',
        '88047' => 'NM',
        '88048' => 'NM',
        '88049' => 'NM',
        '88051' => 'NM',
        '88052' => 'NM',
        '88053' => 'NM',
        '88055' => 'NM',
        '88056' => 'NM',
        '88061' => 'NM',
        '88063' => 'NM',
        '88065' => 'NM',
        '88072' => 'NM',
        '88081' => 'NM',
        '88101' => 'NM',
        '88103' => 'NM',
        '88112' => 'NM',
        '88113' => 'NM',
        '88114' => 'NM',
        '88115' => 'NM',
        '88116' => 'NM',
        '88118' => 'NM',
        '88119' => 'NM',
        '88120' => 'NM',
        '88121' => 'NM',
        '88124' => 'NM',
        '88125' => 'NM',
        '88126' => 'NM',
        '88130' => 'NM',
        '88132' => 'NM',
        '88134' => 'NM',
        '88135' => 'NM',
        '88136' => 'NM',
        '88201' => 'NM',
        '88203' => 'NM',
        '88210' => 'NM',
        '88220' => 'NM',
        '88230' => 'NM',
        '88231' => 'NM',
        '88232' => 'NM',
        '88240' => 'NM',
        '88242' => 'NM',
        '88244' => 'NM',
        '88250' => 'NM',
        '88252' => 'NM',
        '88253' => 'NM',
        '88254' => 'NM',
        '88255' => 'NM',
        '88256' => 'NM',
        '88260' => 'NM',
        '88262' => 'NM',
        '88263' => 'NM',
        '88264' => 'NM',
        '88265' => 'NM',
        '88267' => 'NM',
        '88268' => 'NM',
        '88301' => 'NM',
        '88310' => 'NM',
        '88311' => 'NM',
        '88312' => 'NM',
        '88314' => 'NM',
        '88316' => 'NM',
        '88317' => 'NM',
        '88318' => 'NM',
        '88321' => 'NM',
        '88323' => 'NM',
        '88324' => 'NM',
        '88325' => 'NM',
        '88330' => 'NM',
        '88336' => 'NM',
        '88337' => 'NM',
        '88338' => 'NM',
        '88339' => 'NM',
        '88340' => 'NM',
        '88341' => 'NM',
        '88342' => 'NM',
        '88343' => 'NM',
        '88344' => 'NM',
        '88345' => 'NM',
        '88346' => 'NM',
        '88347' => 'NM',
        '88348' => 'NM',
        '88349' => 'NM',
        '88350' => 'NM',
        '88351' => 'NM',
        '88352' => 'NM',
        '88353' => 'NM',
        '88354' => 'NM',
        '88355' => 'NM',
        '88401' => 'NM',
        '88410' => 'NM',
        '88411' => 'NM',
        '88414' => 'NM',
        '88415' => 'NM',
        '88416' => 'NM',
        '88417' => 'NM',
        '88418' => 'NM',
        '88419' => 'NM',
        '88421' => 'NM',
        '88422' => 'NM',
        '88424' => 'NM',
        '88426' => 'NM',
        '88427' => 'NM',
        '88430' => 'NM',
        '88431' => 'NM',
        '88434' => 'NM',
        '88435' => 'NM',
        '88436' => 'NM',
        '88439' => 'NM',
        '89001' => 'NV',
        '89002' => 'NV',
        '89003' => 'NV',
        '89004' => 'NV',
        '89005' => 'NV',
        '89007' => 'NV',
        '89008' => 'NV',
        '89010' => 'NV',
        '89011' => 'NV',
        '89012' => 'NV',
        '89013' => 'NV',
        '89014' => 'NV',
        '89015' => 'NV',
        '89017' => 'NV',
        '89018' => 'NV',
        '89019' => 'NV',
        '89020' => 'NV',
        '89021' => 'NV',
        '89022' => 'NV',
        '89025' => 'NV',
        '89026' => 'NV',
        '89027' => 'NV',
        '89029' => 'NV',
        '89030' => 'NV',
        '89031' => 'NV',
        '89032' => 'NV',
        '89034' => 'NV',
        '89039' => 'NV',
        '89040' => 'NV',
        '89042' => 'NV',
        '89043' => 'NV',
        '89044' => 'NV',
        '89045' => 'NV',
        '89046' => 'NV',
        '89047' => 'NV',
        '89048' => 'NV',
        '89049' => 'NV',
        '89052' => 'NV',
        '89054' => 'NV',
        '89060' => 'NV',
        '89061' => 'NV',
        '89070' => 'NV',
        '89074' => 'NV',
        '89081' => 'NV',
        '89084' => 'NV',
        '89085' => 'NV',
        '89086' => 'NV',
        '89101' => 'NV',
        '89102' => 'NV',
        '89103' => 'NV',
        '89104' => 'NV',
        '89106' => 'NV',
        '89107' => 'NV',
        '89108' => 'NV',
        '89109' => 'NV',
        '89110' => 'NV',
        '89113' => 'NV',
        '89115' => 'NV',
        '89117' => 'NV',
        '89118' => 'NV',
        '89119' => 'NV',
        '89120' => 'NV',
        '89121' => 'NV',
        '89122' => 'NV',
        '89123' => 'NV',
        '89124' => 'NV',
        '89128' => 'NV',
        '89129' => 'NV',
        '89130' => 'NV',
        '89131' => 'NV',
        '89134' => 'NV',
        '89135' => 'NV',
        '89138' => 'NV',
        '89139' => 'NV',
        '89141' => 'NV',
        '89142' => 'NV',
        '89143' => 'NV',
        '89144' => 'NV',
        '89145' => 'NV',
        '89146' => 'NV',
        '89147' => 'NV',
        '89148' => 'NV',
        '89149' => 'NV',
        '89156' => 'NV',
        '89158' => 'NV',
        '89161' => 'NV',
        '89166' => 'NV',
        '89169' => 'NV',
        '89178' => 'NV',
        '89179' => 'NV',
        '89183' => 'NV',
        '89191' => 'NV',
        '89301' => 'NV',
        '89310' => 'NV',
        '89311' => 'NV',
        '89314' => 'NV',
        '89315' => 'NV',
        '89316' => 'NV',
        '89317' => 'NV',
        '89318' => 'NV',
        '89319' => 'NV',
        '89402' => 'NV',
        '89403' => 'NV',
        '89404' => 'NV',
        '89405' => 'NV',
        '89406' => 'NV',
        '89408' => 'NV',
        '89409' => 'NV',
        '89410' => 'NV',
        '89411' => 'NV',
        '89412' => 'NV',
        '89413' => 'NV',
        '89414' => 'NV',
        '89415' => 'NV',
        '89418' => 'NV',
        '89419' => 'NV',
        '89420' => 'NV',
        '89421' => 'NV',
        '89422' => 'NV',
        '89423' => 'NV',
        '89424' => 'NV',
        '89425' => 'NV',
        '89426' => 'NV',
        '89427' => 'NV',
        '89428' => 'NV',
        '89429' => 'NV',
        '89430' => 'NV',
        '89431' => 'NV',
        '89433' => 'NV',
        '89434' => 'NV',
        '89436' => 'NV',
        '89437' => 'NV',
        '89438' => 'NV',
        '89439' => 'NV',
        '89440' => 'NV',
        '89441' => 'NV',
        '89442' => 'NV',
        '89444' => 'NV',
        '89445' => 'NV',
        '89446' => 'NV',
        '89447' => 'NV',
        '89448' => 'NV',
        '89449' => 'NV',
        '89450' => 'NV',
        '89451' => 'NV',
        '89460' => 'NV',
        '89496' => 'NV',
        '89501' => 'NV',
        '89502' => 'NV',
        '89503' => 'NV',
        '89506' => 'NV',
        '89508' => 'NV',
        '89509' => 'NV',
        '89510' => 'NV',
        '89511' => 'NV',
        '89512' => 'NV',
        '89519' => 'NV',
        '89521' => 'NV',
        '89523' => 'NV',
        '89557' => 'NV',
        '89701' => 'NV',
        '89703' => 'NV',
        '89704' => 'NV',
        '89705' => 'NV',
        '89706' => 'NV',
        '89801' => 'NV',
        '89815' => 'NV',
        '89820' => 'NV',
        '89821' => 'NV',
        '89822' => 'NV',
        '89823' => 'NV',
        '89825' => 'NV',
        '89826' => 'NV',
        '89828' => 'NV',
        '89830' => 'NV',
        '89831' => 'NV',
        '89832' => 'NV',
        '89833' => 'NV',
        '89834' => 'NV',
        '89835' => 'NV',
        '89883' => 'NV',
        '90001' => 'CA',
        '90002' => 'CA',
        '90003' => 'CA',
        '90004' => 'CA',
        '90005' => 'CA',
        '90006' => 'CA',
        '90007' => 'CA',
        '90008' => 'CA',
        '90010' => 'CA',
        '90011' => 'CA',
        '90012' => 'CA',
        '90013' => 'CA',
        '90014' => 'CA',
        '90015' => 'CA',
        '90016' => 'CA',
        '90017' => 'CA',
        '90018' => 'CA',
        '90019' => 'CA',
        '90020' => 'CA',
        '90021' => 'CA',
        '90022' => 'CA',
        '90023' => 'CA',
        '90024' => 'CA',
        '90025' => 'CA',
        '90026' => 'CA',
        '90027' => 'CA',
        '90028' => 'CA',
        '90029' => 'CA',
        '90031' => 'CA',
        '90032' => 'CA',
        '90033' => 'CA',
        '90034' => 'CA',
        '90035' => 'CA',
        '90036' => 'CA',
        '90037' => 'CA',
        '90038' => 'CA',
        '90039' => 'CA',
        '90040' => 'CA',
        '90041' => 'CA',
        '90042' => 'CA',
        '90043' => 'CA',
        '90044' => 'CA',
        '90045' => 'CA',
        '90046' => 'CA',
        '90047' => 'CA',
        '90048' => 'CA',
        '90049' => 'CA',
        '90052' => 'CA',
        '90056' => 'CA',
        '90057' => 'CA',
        '90058' => 'CA',
        '90059' => 'CA',
        '90061' => 'CA',
        '90062' => 'CA',
        '90063' => 'CA',
        '90064' => 'CA',
        '90065' => 'CA',
        '90066' => 'CA',
        '90067' => 'CA',
        '90068' => 'CA',
        '90069' => 'CA',
        '90071' => 'CA',
        '90073' => 'CA',
        '90077' => 'CA',
        '90079' => 'CA',
        '90089' => 'CA',
        '90094' => 'CA',
        '90095' => 'CA',
        '90201' => 'CA',
        '90210' => 'CA',
        '90211' => 'CA',
        '90212' => 'CA',
        '90220' => 'CA',
        '90221' => 'CA',
        '90222' => 'CA',
        '90230' => 'CA',
        '90232' => 'CA',
        '90240' => 'CA',
        '90241' => 'CA',
        '90242' => 'CA',
        '90245' => 'CA',
        '90247' => 'CA',
        '90248' => 'CA',
        '90249' => 'CA',
        '90250' => 'CA',
        '90254' => 'CA',
        '90255' => 'CA',
        '90260' => 'CA',
        '90262' => 'CA',
        '90263' => 'CA',
        '90265' => 'CA',
        '90266' => 'CA',
        '90270' => 'CA',
        '90272' => 'CA',
        '90274' => 'CA',
        '90275' => 'CA',
        '90277' => 'CA',
        '90278' => 'CA',
        '90280' => 'CA',
        '90290' => 'CA',
        '90291' => 'CA',
        '90292' => 'CA',
        '90293' => 'CA',
        '90301' => 'CA',
        '90302' => 'CA',
        '90303' => 'CA',
        '90304' => 'CA',
        '90305' => 'CA',
        '90401' => 'CA',
        '90402' => 'CA',
        '90403' => 'CA',
        '90404' => 'CA',
        '90405' => 'CA',
        '90501' => 'CA',
        '90502' => 'CA',
        '90503' => 'CA',
        '90504' => 'CA',
        '90505' => 'CA',
        '90506' => 'CA',
        '90601' => 'CA',
        '90602' => 'CA',
        '90603' => 'CA',
        '90604' => 'CA',
        '90605' => 'CA',
        '90606' => 'CA',
        '90620' => 'CA',
        '90621' => 'CA',
        '90623' => 'CA',
        '90630' => 'CA',
        '90631' => 'CA',
        '90638' => 'CA',
        '90639' => 'CA',
        '90640' => 'CA',
        '90650' => 'CA',
        '90660' => 'CA',
        '90670' => 'CA',
        '90680' => 'CA',
        '90701' => 'CA',
        '90703' => 'CA',
        '90704' => 'CA',
        '90706' => 'CA',
        '90710' => 'CA',
        '90712' => 'CA',
        '90713' => 'CA',
        '90715' => 'CA',
        '90716' => 'CA',
        '90717' => 'CA',
        '90720' => 'CA',
        '90723' => 'CA',
        '90731' => 'CA',
        '90732' => 'CA',
        '90740' => 'CA',
        '90742' => 'CA',
        '90743' => 'CA',
        '90744' => 'CA',
        '90745' => 'CA',
        '90746' => 'CA',
        '90747' => 'CA',
        '90755' => 'CA',
        '90802' => 'CA',
        '90803' => 'CA',
        '90804' => 'CA',
        '90805' => 'CA',
        '90806' => 'CA',
        '90807' => 'CA',
        '90808' => 'CA',
        '90810' => 'CA',
        '90813' => 'CA',
        '90814' => 'CA',
        '90815' => 'CA',
        '90822' => 'CA',
        '90831' => 'CA',
        '90840' => 'CA',
        '91001' => 'CA',
        '91006' => 'CA',
        '91007' => 'CA',
        '91008' => 'CA',
        '91010' => 'CA',
        '91011' => 'CA',
        '91016' => 'CA',
        '91020' => 'CA',
        '91024' => 'CA',
        '91030' => 'CA',
        '91040' => 'CA',
        '91042' => 'CA',
        '91046' => 'CA',
        '91101' => 'CA',
        '91103' => 'CA',
        '91104' => 'CA',
        '91105' => 'CA',
        '91106' => 'CA',
        '91107' => 'CA',
        '91108' => 'CA',
        '91125' => 'CA',
        '91201' => 'CA',
        '91202' => 'CA',
        '91203' => 'CA',
        '91204' => 'CA',
        '91205' => 'CA',
        '91206' => 'CA',
        '91207' => 'CA',
        '91208' => 'CA',
        '91210' => 'CA',
        '91214' => 'CA',
        '91301' => 'CA',
        '91302' => 'CA',
        '91303' => 'CA',
        '91304' => 'CA',
        '91306' => 'CA',
        '91307' => 'CA',
        '91311' => 'CA',
        '91316' => 'CA',
        '91320' => 'CA',
        '91321' => 'CA',
        '91324' => 'CA',
        '91325' => 'CA',
        '91326' => 'CA',
        '91330' => 'CA',
        '91331' => 'CA',
        '91335' => 'CA',
        '91340' => 'CA',
        '91342' => 'CA',
        '91343' => 'CA',
        '91344' => 'CA',
        '91345' => 'CA',
        '91350' => 'CA',
        '91351' => 'CA',
        '91352' => 'CA',
        '91354' => 'CA',
        '91355' => 'CA',
        '91356' => 'CA',
        '91360' => 'CA',
        '91361' => 'CA',
        '91362' => 'CA',
        '91364' => 'CA',
        '91367' => 'CA',
        '91371' => 'CA',
        '91377' => 'CA',
        '91381' => 'CA',
        '91384' => 'CA',
        '91387' => 'CA',
        '91390' => 'CA',
        '91401' => 'CA',
        '91402' => 'CA',
        '91403' => 'CA',
        '91405' => 'CA',
        '91406' => 'CA',
        '91411' => 'CA',
        '91423' => 'CA',
        '91436' => 'CA',
        '91501' => 'CA',
        '91502' => 'CA',
        '91504' => 'CA',
        '91505' => 'CA',
        '91506' => 'CA',
        '91601' => 'CA',
        '91602' => 'CA',
        '91604' => 'CA',
        '91605' => 'CA',
        '91606' => 'CA',
        '91607' => 'CA',
        '91608' => 'CA',
        '91701' => 'CA',
        '91702' => 'CA',
        '91706' => 'CA',
        '91708' => 'CA',
        '91709' => 'CA',
        '91710' => 'CA',
        '91711' => 'CA',
        '91722' => 'CA',
        '91723' => 'CA',
        '91724' => 'CA',
        '91730' => 'CA',
        '91731' => 'CA',
        '91732' => 'CA',
        '91733' => 'CA',
        '91737' => 'CA',
        '91739' => 'CA',
        '91740' => 'CA',
        '91741' => 'CA',
        '91744' => 'CA',
        '91745' => 'CA',
        '91746' => 'CA',
        '91748' => 'CA',
        '91750' => 'CA',
        '91752' => 'CA',
        '91754' => 'CA',
        '91755' => 'CA',
        '91759' => 'CA',
        '91761' => 'CA',
        '91762' => 'CA',
        '91763' => 'CA',
        '91764' => 'CA',
        '91765' => 'CA',
        '91766' => 'CA',
        '91767' => 'CA',
        '91768' => 'CA',
        '91770' => 'CA',
        '91773' => 'CA',
        '91775' => 'CA',
        '91776' => 'CA',
        '91780' => 'CA',
        '91784' => 'CA',
        '91786' => 'CA',
        '91789' => 'CA',
        '91790' => 'CA',
        '91791' => 'CA',
        '91792' => 'CA',
        '91801' => 'CA',
        '91803' => 'CA',
        '91901' => 'CA',
        '91902' => 'CA',
        '91905' => 'CA',
        '91906' => 'CA',
        '91910' => 'CA',
        '91911' => 'CA',
        '91913' => 'CA',
        '91914' => 'CA',
        '91915' => 'CA',
        '91916' => 'CA',
        '91917' => 'CA',
        '91931' => 'CA',
        '91932' => 'CA',
        '91934' => 'CA',
        '91935' => 'CA',
        '91941' => 'CA',
        '91942' => 'CA',
        '91945' => 'CA',
        '91948' => 'CA',
        '91950' => 'CA',
        '91962' => 'CA',
        '91963' => 'CA',
        '91977' => 'CA',
        '91978' => 'CA',
        '91980' => 'CA',
        '92003' => 'CA',
        '92004' => 'CA',
        '92007' => 'CA',
        '92008' => 'CA',
        '92009' => 'CA',
        '92010' => 'CA',
        '92011' => 'CA',
        '92014' => 'CA',
        '92019' => 'CA',
        '92020' => 'CA',
        '92021' => 'CA',
        '92024' => 'CA',
        '92025' => 'CA',
        '92026' => 'CA',
        '92027' => 'CA',
        '92028' => 'CA',
        '92029' => 'CA',
        '92036' => 'CA',
        '92037' => 'CA',
        '92040' => 'CA',
        '92054' => 'CA',
        '92055' => 'CA',
        '92056' => 'CA',
        '92057' => 'CA',
        '92058' => 'CA',
        '92059' => 'CA',
        '92060' => 'CA',
        '92061' => 'CA',
        '92064' => 'CA',
        '92065' => 'CA',
        '92066' => 'CA',
        '92067' => 'CA',
        '92069' => 'CA',
        '92070' => 'CA',
        '92071' => 'CA',
        '92075' => 'CA',
        '92078' => 'CA',
        '92081' => 'CA',
        '92082' => 'CA',
        '92083' => 'CA',
        '92084' => 'CA',
        '92086' => 'CA',
        '92091' => 'CA',
        '92092' => 'CA',
        '92093' => 'CA',
        '92096' => 'CA',
        '92101' => 'CA',
        '92102' => 'CA',
        '92103' => 'CA',
        '92104' => 'CA',
        '92105' => 'CA',
        '92106' => 'CA',
        '92107' => 'CA',
        '92108' => 'CA',
        '92109' => 'CA',
        '92110' => 'CA',
        '92111' => 'CA',
        '92113' => 'CA',
        '92114' => 'CA',
        '92115' => 'CA',
        '92116' => 'CA',
        '92117' => 'CA',
        '92118' => 'CA',
        '92119' => 'CA',
        '92120' => 'CA',
        '92121' => 'CA',
        '92122' => 'CA',
        '92123' => 'CA',
        '92124' => 'CA',
        '92126' => 'CA',
        '92127' => 'CA',
        '92128' => 'CA',
        '92129' => 'CA',
        '92130' => 'CA',
        '92131' => 'CA',
        '92132' => 'CA',
        '92134' => 'CA',
        '92135' => 'CA',
        '92136' => 'CA',
        '92139' => 'CA',
        '92140' => 'CA',
        '92145' => 'CA',
        '92147' => 'CA',
        '92154' => 'CA',
        '92155' => 'CA',
        '92161' => 'CA',
        '92173' => 'CA',
        '92179' => 'CA',
        '92182' => 'CA',
        '92201' => 'CA',
        '92203' => 'CA',
        '92210' => 'CA',
        '92211' => 'CA',
        '92220' => 'CA',
        '92222' => 'CA',
        '92223' => 'CA',
        '92225' => 'CA',
        '92227' => 'CA',
        '92230' => 'CA',
        '92231' => 'CA',
        '92233' => 'CA',
        '92234' => 'CA',
        '92236' => 'CA',
        '92239' => 'CA',
        '92240' => 'CA',
        '92241' => 'CA',
        '92242' => 'CA',
        '92243' => 'CA',
        '92249' => 'CA',
        '92250' => 'CA',
        '92251' => 'CA',
        '92252' => 'CA',
        '92253' => 'CA',
        '92254' => 'CA',
        '92256' => 'CA',
        '92257' => 'CA',
        '92258' => 'CA',
        '92259' => 'CA',
        '92260' => 'CA',
        '92262' => 'CA',
        '92264' => 'CA',
        '92266' => 'CA',
        '92267' => 'CA',
        '92268' => 'CA',
        '92270' => 'CA',
        '92273' => 'CA',
        '92274' => 'CA',
        '92275' => 'CA',
        '92276' => 'CA',
        '92277' => 'CA',
        '92278' => 'CA',
        '92280' => 'CA',
        '92281' => 'CA',
        '92282' => 'CA',
        '92283' => 'CA',
        '92284' => 'CA',
        '92285' => 'CA',
        '92301' => 'CA',
        '92304' => 'CA',
        '92305' => 'CA',
        '92307' => 'CA',
        '92308' => 'CA',
        '92309' => 'CA',
        '92310' => 'CA',
        '92311' => 'CA',
        '92313' => 'CA',
        '92314' => 'CA',
        '92315' => 'CA',
        '92316' => 'CA',
        '92317' => 'CA',
        '92320' => 'CA',
        '92321' => 'CA',
        '92322' => 'CA',
        '92324' => 'CA',
        '92325' => 'CA',
        '92327' => 'CA',
        '92328' => 'CA',
        '92332' => 'CA',
        '92333' => 'CA',
        '92335' => 'CA',
        '92336' => 'CA',
        '92337' => 'CA',
        '92338' => 'CA',
        '92339' => 'CA',
        '92341' => 'CA',
        '92342' => 'CA',
        '92344' => 'CA',
        '92345' => 'CA',
        '92346' => 'CA',
        '92347' => 'CA',
        '92350' => 'CA',
        '92352' => 'CA',
        '92354' => 'CA',
        '92356' => 'CA',
        '92358' => 'CA',
        '92359' => 'CA',
        '92363' => 'CA',
        '92364' => 'CA',
        '92365' => 'CA',
        '92368' => 'CA',
        '92369' => 'CA',
        '92371' => 'CA',
        '92372' => 'CA',
        '92373' => 'CA',
        '92374' => 'CA',
        '92376' => 'CA',
        '92377' => 'CA',
        '92378' => 'CA',
        '92382' => 'CA',
        '92384' => 'CA',
        '92385' => 'CA',
        '92386' => 'CA',
        '92389' => 'CA',
        '92391' => 'CA',
        '92392' => 'CA',
        '92394' => 'CA',
        '92395' => 'CA',
        '92397' => 'CA',
        '92398' => 'CA',
        '92399' => 'CA',
        '92401' => 'CA',
        '92404' => 'CA',
        '92405' => 'CA',
        '92407' => 'CA',
        '92408' => 'CA',
        '92410' => 'CA',
        '92411' => 'CA',
        '92415' => 'CA',
        '92501' => 'CA',
        '92503' => 'CA',
        '92504' => 'CA',
        '92505' => 'CA',
        '92506' => 'CA',
        '92507' => 'CA',
        '92508' => 'CA',
        '92509' => 'CA',
        '92518' => 'CA',
        '92521' => 'CA',
        '92530' => 'CA',
        '92532' => 'CA',
        '92536' => 'CA',
        '92539' => 'CA',
        '92543' => 'CA',
        '92544' => 'CA',
        '92545' => 'CA',
        '92548' => 'CA',
        '92549' => 'CA',
        '92551' => 'CA',
        '92553' => 'CA',
        '92555' => 'CA',
        '92557' => 'CA',
        '92561' => 'CA',
        '92562' => 'CA',
        '92563' => 'CA',
        '92567' => 'CA',
        '92570' => 'CA',
        '92571' => 'CA',
        '92582' => 'CA',
        '92583' => 'CA',
        '92584' => 'CA',
        '92585' => 'CA',
        '92586' => 'CA',
        '92587' => 'CA',
        '92590' => 'CA',
        '92591' => 'CA',
        '92592' => 'CA',
        '92595' => 'CA',
        '92596' => 'CA',
        '92602' => 'CA',
        '92603' => 'CA',
        '92604' => 'CA',
        '92606' => 'CA',
        '92610' => 'CA',
        '92612' => 'CA',
        '92614' => 'CA',
        '92617' => 'CA',
        '92618' => 'CA',
        '92620' => 'CA',
        '92624' => 'CA',
        '92625' => 'CA',
        '92626' => 'CA',
        '92627' => 'CA',
        '92629' => 'CA',
        '92630' => 'CA',
        '92637' => 'CA',
        '92646' => 'CA',
        '92647' => 'CA',
        '92648' => 'CA',
        '92649' => 'CA',
        '92651' => 'CA',
        '92653' => 'CA',
        '92655' => 'CA',
        '92656' => 'CA',
        '92657' => 'CA',
        '92660' => 'CA',
        '92661' => 'CA',
        '92662' => 'CA',
        '92663' => 'CA',
        '92672' => 'CA',
        '92673' => 'CA',
        '92675' => 'CA',
        '92676' => 'CA',
        '92677' => 'CA',
        '92678' => 'CA',
        '92679' => 'CA',
        '92683' => 'CA',
        '92688' => 'CA',
        '92691' => 'CA',
        '92692' => 'CA',
        '92694' => 'CA',
        '92697' => 'CA',
        '92701' => 'CA',
        '92703' => 'CA',
        '92704' => 'CA',
        '92705' => 'CA',
        '92706' => 'CA',
        '92707' => 'CA',
        '92708' => 'CA',
        '92780' => 'CA',
        '92782' => 'CA',
        '92801' => 'CA',
        '92802' => 'CA',
        '92804' => 'CA',
        '92805' => 'CA',
        '92806' => 'CA',
        '92807' => 'CA',
        '92808' => 'CA',
        '92821' => 'CA',
        '92823' => 'CA',
        '92831' => 'CA',
        '92832' => 'CA',
        '92833' => 'CA',
        '92835' => 'CA',
        '92840' => 'CA',
        '92841' => 'CA',
        '92843' => 'CA',
        '92844' => 'CA',
        '92845' => 'CA',
        '92860' => 'CA',
        '92861' => 'CA',
        '92865' => 'CA',
        '92866' => 'CA',
        '92867' => 'CA',
        '92868' => 'CA',
        '92869' => 'CA',
        '92870' => 'CA',
        '92879' => 'CA',
        '92880' => 'CA',
        '92881' => 'CA',
        '92882' => 'CA',
        '92883' => 'CA',
        '92886' => 'CA',
        '92887' => 'CA',
        '93001' => 'CA',
        '93003' => 'CA',
        '93004' => 'CA',
        '93010' => 'CA',
        '93012' => 'CA',
        '93013' => 'CA',
        '93015' => 'CA',
        '93021' => 'CA',
        '93022' => 'CA',
        '93023' => 'CA',
        '93030' => 'CA',
        '93033' => 'CA',
        '93035' => 'CA',
        '93036' => 'CA',
        '93040' => 'CA',
        '93041' => 'CA',
        '93042' => 'CA',
        '93043' => 'CA',
        '93060' => 'CA',
        '93063' => 'CA',
        '93064' => 'CA',
        '93065' => 'CA',
        '93066' => 'CA',
        '93067' => 'CA',
        '93101' => 'CA',
        '93103' => 'CA',
        '93105' => 'CA',
        '93106' => 'CA',
        '93108' => 'CA',
        '93109' => 'CA',
        '93110' => 'CA',
        '93111' => 'CA',
        '93117' => 'CA',
        '93201' => 'CA',
        '93202' => 'CA',
        '93203' => 'CA',
        '93204' => 'CA',
        '93205' => 'CA',
        '93206' => 'CA',
        '93207' => 'CA',
        '93208' => 'CA',
        '93210' => 'CA',
        '93212' => 'CA',
        '93215' => 'CA',
        '93218' => 'CA',
        '93219' => 'CA',
        '93220' => 'CA',
        '93221' => 'CA',
        '93222' => 'CA',
        '93223' => 'CA',
        '93224' => 'CA',
        '93225' => 'CA',
        '93226' => 'CA',
        '93227' => 'CA',
        '93230' => 'CA',
        '93234' => 'CA',
        '93235' => 'CA',
        '93237' => 'CA',
        '93238' => 'CA',
        '93239' => 'CA',
        '93240' => 'CA',
        '93241' => 'CA',
        '93242' => 'CA',
        '93243' => 'CA',
        '93244' => 'CA',
        '93245' => 'CA',
        '93246' => 'CA',
        '93247' => 'CA',
        '93249' => 'CA',
        '93250' => 'CA',
        '93251' => 'CA',
        '93252' => 'CA',
        '93254' => 'CA',
        '93255' => 'CA',
        '93256' => 'CA',
        '93257' => 'CA',
        '93258' => 'CA',
        '93260' => 'CA',
        '93261' => 'CA',
        '93262' => 'CA',
        '93263' => 'CA',
        '93265' => 'CA',
        '93266' => 'CA',
        '93267' => 'CA',
        '93268' => 'CA',
        '93270' => 'CA',
        '93271' => 'CA',
        '93272' => 'CA',
        '93274' => 'CA',
        '93276' => 'CA',
        '93277' => 'CA',
        '93280' => 'CA',
        '93283' => 'CA',
        '93285' => 'CA',
        '93286' => 'CA',
        '93287' => 'CA',
        '93291' => 'CA',
        '93292' => 'CA',
        '93301' => 'CA',
        '93304' => 'CA',
        '93305' => 'CA',
        '93306' => 'CA',
        '93307' => 'CA',
        '93308' => 'CA',
        '93309' => 'CA',
        '93311' => 'CA',
        '93312' => 'CA',
        '93313' => 'CA',
        '93314' => 'CA',
        '93401' => 'CA',
        '93402' => 'CA',
        '93405' => 'CA',
        '93407' => 'CA',
        '93408' => 'CA',
        '93409' => 'CA',
        '93410' => 'CA',
        '93420' => 'CA',
        '93422' => 'CA',
        '93424' => 'CA',
        '93426' => 'CA',
        '93427' => 'CA',
        '93428' => 'CA',
        '93429' => 'CA',
        '93430' => 'CA',
        '93432' => 'CA',
        '93433' => 'CA',
        '93434' => 'CA',
        '93436' => 'CA',
        '93437' => 'CA',
        '93440' => 'CA',
        '93441' => 'CA',
        '93442' => 'CA',
        '93444' => 'CA',
        '93445' => 'CA',
        '93446' => 'CA',
        '93449' => 'CA',
        '93450' => 'CA',
        '93451' => 'CA',
        '93452' => 'CA',
        '93453' => 'CA',
        '93454' => 'CA',
        '93455' => 'CA',
        '93458' => 'CA',
        '93460' => 'CA',
        '93461' => 'CA',
        '93463' => 'CA',
        '93465' => 'CA',
        '93501' => 'CA',
        '93505' => 'CA',
        '93510' => 'CA',
        '93512' => 'CA',
        '93513' => 'CA',
        '93514' => 'CA',
        '93516' => 'CA',
        '93517' => 'CA',
        '93518' => 'CA',
        '93519' => 'CA',
        '93522' => 'CA',
        '93523' => 'CA',
        '93524' => 'CA',
        '93526' => 'CA',
        '93527' => 'CA',
        '93528' => 'CA',
        '93529' => 'CA',
        '93530' => 'CA',
        '93531' => 'CA',
        '93532' => 'CA',
        '93534' => 'CA',
        '93535' => 'CA',
        '93536' => 'CA',
        '93541' => 'CA',
        '93543' => 'CA',
        '93544' => 'CA',
        '93545' => 'CA',
        '93546' => 'CA',
        '93549' => 'CA',
        '93550' => 'CA',
        '93551' => 'CA',
        '93552' => 'CA',
        '93553' => 'CA',
        '93554' => 'CA',
        '93555' => 'CA',
        '93558' => 'CA',
        '93560' => 'CA',
        '93561' => 'CA',
        '93562' => 'CA',
        '93563' => 'CA',
        '93581' => 'CA',
        '93591' => 'CA',
        '93601' => 'CA',
        '93602' => 'CA',
        '93603' => 'CA',
        '93604' => 'CA',
        '93605' => 'CA',
        '93606' => 'CA',
        '93608' => 'CA',
        '93609' => 'CA',
        '93610' => 'CA',
        '93611' => 'CA',
        '93612' => 'CA',
        '93614' => 'CA',
        '93615' => 'CA',
        '93616' => 'CA',
        '93618' => 'CA',
        '93619' => 'CA',
        '93620' => 'CA',
        '93621' => 'CA',
        '93622' => 'CA',
        '93623' => 'CA',
        '93624' => 'CA',
        '93625' => 'CA',
        '93626' => 'CA',
        '93627' => 'CA',
        '93628' => 'CA',
        '93630' => 'CA',
        '93631' => 'CA',
        '93633' => 'CA',
        '93634' => 'CA',
        '93635' => 'CA',
        '93636' => 'CA',
        '93637' => 'CA',
        '93638' => 'CA',
        '93640' => 'CA',
        '93641' => 'CA',
        '93643' => 'CA',
        '93644' => 'CA',
        '93645' => 'CA',
        '93646' => 'CA',
        '93647' => 'CA',
        '93648' => 'CA',
        '93650' => 'CA',
        '93651' => 'CA',
        '93652' => 'CA',
        '93653' => 'CA',
        '93654' => 'CA',
        '93656' => 'CA',
        '93657' => 'CA',
        '93660' => 'CA',
        '93662' => 'CA',
        '93664' => 'CA',
        '93665' => 'CA',
        '93666' => 'CA',
        '93667' => 'CA',
        '93668' => 'CA',
        '93669' => 'CA',
        '93670' => 'CA',
        '93673' => 'CA',
        '93675' => 'CA',
        '93701' => 'CA',
        '93702' => 'CA',
        '93703' => 'CA',
        '93704' => 'CA',
        '93705' => 'CA',
        '93706' => 'CA',
        '93710' => 'CA',
        '93711' => 'CA',
        '93720' => 'CA',
        '93721' => 'CA',
        '93722' => 'CA',
        '93723' => 'CA',
        '93725' => 'CA',
        '93726' => 'CA',
        '93727' => 'CA',
        '93728' => 'CA',
        '93730' => 'CA',
        '93737' => 'CA',
        '93740' => 'CA',
        '93741' => 'CA',
        '93901' => 'CA',
        '93905' => 'CA',
        '93906' => 'CA',
        '93907' => 'CA',
        '93908' => 'CA',
        '93920' => 'CA',
        '93921' => 'CA',
        '93923' => 'CA',
        '93924' => 'CA',
        '93925' => 'CA',
        '93926' => 'CA',
        '93927' => 'CA',
        '93928' => 'CA',
        '93930' => 'CA',
        '93932' => 'CA',
        '93933' => 'CA',
        '93940' => 'CA',
        '93943' => 'CA',
        '93944' => 'CA',
        '93950' => 'CA',
        '93953' => 'CA',
        '93954' => 'CA',
        '93955' => 'CA',
        '93960' => 'CA',
        '93962' => 'CA',
        '94002' => 'CA',
        '94005' => 'CA',
        '94010' => 'CA',
        '94014' => 'CA',
        '94015' => 'CA',
        '94018' => 'CA',
        '94019' => 'CA',
        '94020' => 'CA',
        '94021' => 'CA',
        '94022' => 'CA',
        '94024' => 'CA',
        '94025' => 'CA',
        '94027' => 'CA',
        '94028' => 'CA',
        '94030' => 'CA',
        '94037' => 'CA',
        '94038' => 'CA',
        '94040' => 'CA',
        '94041' => 'CA',
        '94043' => 'CA',
        '94044' => 'CA',
        '94060' => 'CA',
        '94061' => 'CA',
        '94062' => 'CA',
        '94063' => 'CA',
        '94065' => 'CA',
        '94066' => 'CA',
        '94070' => 'CA',
        '94074' => 'CA',
        '94080' => 'CA',
        '94085' => 'CA',
        '94086' => 'CA',
        '94087' => 'CA',
        '94089' => 'CA',
        '94102' => 'CA',
        '94103' => 'CA',
        '94104' => 'CA',
        '94105' => 'CA',
        '94107' => 'CA',
        '94108' => 'CA',
        '94109' => 'CA',
        '94110' => 'CA',
        '94111' => 'CA',
        '94112' => 'CA',
        '94114' => 'CA',
        '94115' => 'CA',
        '94116' => 'CA',
        '94117' => 'CA',
        '94118' => 'CA',
        '94121' => 'CA',
        '94122' => 'CA',
        '94123' => 'CA',
        '94124' => 'CA',
        '94127' => 'CA',
        '94128' => 'CA',
        '94129' => 'CA',
        '94130' => 'CA',
        '94131' => 'CA',
        '94132' => 'CA',
        '94133' => 'CA',
        '94134' => 'CA',
        '94158' => 'CA',
        '94188' => 'CA',
        '94301' => 'CA',
        '94303' => 'CA',
        '94304' => 'CA',
        '94305' => 'CA',
        '94306' => 'CA',
        '94401' => 'CA',
        '94402' => 'CA',
        '94403' => 'CA',
        '94404' => 'CA',
        '94501' => 'CA',
        '94502' => 'CA',
        '94503' => 'CA',
        '94505' => 'CA',
        '94506' => 'CA',
        '94507' => 'CA',
        '94508' => 'CA',
        '94509' => 'CA',
        '94510' => 'CA',
        '94511' => 'CA',
        '94512' => 'CA',
        '94513' => 'CA',
        '94514' => 'CA',
        '94515' => 'CA',
        '94516' => 'CA',
        '94517' => 'CA',
        '94518' => 'CA',
        '94519' => 'CA',
        '94520' => 'CA',
        '94521' => 'CA',
        '94523' => 'CA',
        '94525' => 'CA',
        '94526' => 'CA',
        '94528' => 'CA',
        '94530' => 'CA',
        '94531' => 'CA',
        '94533' => 'CA',
        '94534' => 'CA',
        '94535' => 'CA',
        '94536' => 'CA',
        '94538' => 'CA',
        '94539' => 'CA',
        '94541' => 'CA',
        '94542' => 'CA',
        '94544' => 'CA',
        '94545' => 'CA',
        '94546' => 'CA',
        '94547' => 'CA',
        '94548' => 'CA',
        '94549' => 'CA',
        '94550' => 'CA',
        '94551' => 'CA',
        '94552' => 'CA',
        '94553' => 'CA',
        '94555' => 'CA',
        '94556' => 'CA',
        '94558' => 'CA',
        '94559' => 'CA',
        '94560' => 'CA',
        '94561' => 'CA',
        '94562' => 'CA',
        '94563' => 'CA',
        '94564' => 'CA',
        '94565' => 'CA',
        '94566' => 'CA',
        '94567' => 'CA',
        '94568' => 'CA',
        '94569' => 'CA',
        '94571' => 'CA',
        '94572' => 'CA',
        '94573' => 'CA',
        '94574' => 'CA',
        '94575' => 'CA',
        '94576' => 'CA',
        '94577' => 'CA',
        '94578' => 'CA',
        '94579' => 'CA',
        '94580' => 'CA',
        '94582' => 'CA',
        '94583' => 'CA',
        '94585' => 'CA',
        '94586' => 'CA',
        '94587' => 'CA',
        '94588' => 'CA',
        '94589' => 'CA',
        '94590' => 'CA',
        '94591' => 'CA',
        '94592' => 'CA',
        '94595' => 'CA',
        '94596' => 'CA',
        '94597' => 'CA',
        '94598' => 'CA',
        '94599' => 'CA',
        '94601' => 'CA',
        '94602' => 'CA',
        '94603' => 'CA',
        '94605' => 'CA',
        '94606' => 'CA',
        '94607' => 'CA',
        '94608' => 'CA',
        '94609' => 'CA',
        '94610' => 'CA',
        '94611' => 'CA',
        '94612' => 'CA',
        '94613' => 'CA',
        '94618' => 'CA',
        '94619' => 'CA',
        '94621' => 'CA',
        '94702' => 'CA',
        '94703' => 'CA',
        '94704' => 'CA',
        '94705' => 'CA',
        '94706' => 'CA',
        '94707' => 'CA',
        '94708' => 'CA',
        '94709' => 'CA',
        '94710' => 'CA',
        '94720' => 'CA',
        '94801' => 'CA',
        '94803' => 'CA',
        '94804' => 'CA',
        '94805' => 'CA',
        '94806' => 'CA',
        '94901' => 'CA',
        '94903' => 'CA',
        '94904' => 'CA',
        '94920' => 'CA',
        '94922' => 'CA',
        '94923' => 'CA',
        '94924' => 'CA',
        '94925' => 'CA',
        '94928' => 'CA',
        '94929' => 'CA',
        '94930' => 'CA',
        '94931' => 'CA',
        '94933' => 'CA',
        '94937' => 'CA',
        '94938' => 'CA',
        '94939' => 'CA',
        '94940' => 'CA',
        '94941' => 'CA',
        '94945' => 'CA',
        '94946' => 'CA',
        '94947' => 'CA',
        '94949' => 'CA',
        '94950' => 'CA',
        '94951' => 'CA',
        '94952' => 'CA',
        '94954' => 'CA',
        '94956' => 'CA',
        '94957' => 'CA',
        '94960' => 'CA',
        '94963' => 'CA',
        '94964' => 'CA',
        '94965' => 'CA',
        '94970' => 'CA',
        '94971' => 'CA',
        '94972' => 'CA',
        '94973' => 'CA',
        '95002' => 'CA',
        '95003' => 'CA',
        '95004' => 'CA',
        '95005' => 'CA',
        '95006' => 'CA',
        '95007' => 'CA',
        '95008' => 'CA',
        '95010' => 'CA',
        '95012' => 'CA',
        '95013' => 'CA',
        '95014' => 'CA',
        '95017' => 'CA',
        '95018' => 'CA',
        '95019' => 'CA',
        '95020' => 'CA',
        '95023' => 'CA',
        '95030' => 'CA',
        '95032' => 'CA',
        '95033' => 'CA',
        '95035' => 'CA',
        '95037' => 'CA',
        '95039' => 'CA',
        '95041' => 'CA',
        '95043' => 'CA',
        '95045' => 'CA',
        '95046' => 'CA',
        '95050' => 'CA',
        '95051' => 'CA',
        '95053' => 'CA',
        '95054' => 'CA',
        '95060' => 'CA',
        '95062' => 'CA',
        '95064' => 'CA',
        '95065' => 'CA',
        '95066' => 'CA',
        '95070' => 'CA',
        '95073' => 'CA',
        '95075' => 'CA',
        '95076' => 'CA',
        '95110' => 'CA',
        '95111' => 'CA',
        '95112' => 'CA',
        '95113' => 'CA',
        '95116' => 'CA',
        '95117' => 'CA',
        '95118' => 'CA',
        '95119' => 'CA',
        '95120' => 'CA',
        '95121' => 'CA',
        '95122' => 'CA',
        '95123' => 'CA',
        '95124' => 'CA',
        '95125' => 'CA',
        '95126' => 'CA',
        '95127' => 'CA',
        '95128' => 'CA',
        '95129' => 'CA',
        '95130' => 'CA',
        '95131' => 'CA',
        '95132' => 'CA',
        '95133' => 'CA',
        '95134' => 'CA',
        '95135' => 'CA',
        '95136' => 'CA',
        '95138' => 'CA',
        '95139' => 'CA',
        '95140' => 'CA',
        '95148' => 'CA',
        '95202' => 'CA',
        '95203' => 'CA',
        '95204' => 'CA',
        '95205' => 'CA',
        '95206' => 'CA',
        '95207' => 'CA',
        '95209' => 'CA',
        '95210' => 'CA',
        '95211' => 'CA',
        '95212' => 'CA',
        '95215' => 'CA',
        '95219' => 'CA',
        '95220' => 'CA',
        '95221' => 'CA',
        '95222' => 'CA',
        '95223' => 'CA',
        '95224' => 'CA',
        '95225' => 'CA',
        '95226' => 'CA',
        '95227' => 'CA',
        '95228' => 'CA',
        '95230' => 'CA',
        '95231' => 'CA',
        '95232' => 'CA',
        '95233' => 'CA',
        '95236' => 'CA',
        '95237' => 'CA',
        '95240' => 'CA',
        '95242' => 'CA',
        '95245' => 'CA',
        '95246' => 'CA',
        '95247' => 'CA',
        '95248' => 'CA',
        '95249' => 'CA',
        '95251' => 'CA',
        '95252' => 'CA',
        '95253' => 'CA',
        '95254' => 'CA',
        '95255' => 'CA',
        '95257' => 'CA',
        '95258' => 'CA',
        '95301' => 'CA',
        '95303' => 'CA',
        '95304' => 'CA',
        '95305' => 'CA',
        '95306' => 'CA',
        '95307' => 'CA',
        '95309' => 'CA',
        '95310' => 'CA',
        '95311' => 'CA',
        '95312' => 'CA',
        '95313' => 'CA',
        '95315' => 'CA',
        '95316' => 'CA',
        '95317' => 'CA',
        '95318' => 'CA',
        '95319' => 'CA',
        '95320' => 'CA',
        '95321' => 'CA',
        '95322' => 'CA',
        '95323' => 'CA',
        '95324' => 'CA',
        '95325' => 'CA',
        '95326' => 'CA',
        '95327' => 'CA',
        '95328' => 'CA',
        '95329' => 'CA',
        '95330' => 'CA',
        '95333' => 'CA',
        '95334' => 'CA',
        '95335' => 'CA',
        '95336' => 'CA',
        '95337' => 'CA',
        '95338' => 'CA',
        '95340' => 'CA',
        '95341' => 'CA',
        '95345' => 'CA',
        '95346' => 'CA',
        '95348' => 'CA',
        '95350' => 'CA',
        '95351' => 'CA',
        '95354' => 'CA',
        '95355' => 'CA',
        '95356' => 'CA',
        '95357' => 'CA',
        '95358' => 'CA',
        '95360' => 'CA',
        '95361' => 'CA',
        '95363' => 'CA',
        '95364' => 'CA',
        '95365' => 'CA',
        '95366' => 'CA',
        '95367' => 'CA',
        '95368' => 'CA',
        '95369' => 'CA',
        '95370' => 'CA',
        '95372' => 'CA',
        '95374' => 'CA',
        '95375' => 'CA',
        '95376' => 'CA',
        '95377' => 'CA',
        '95379' => 'CA',
        '95380' => 'CA',
        '95382' => 'CA',
        '95383' => 'CA',
        '95385' => 'CA',
        '95386' => 'CA',
        '95387' => 'CA',
        '95388' => 'CA',
        '95389' => 'CA',
        '95391' => 'CA',
        '95401' => 'CA',
        '95403' => 'CA',
        '95404' => 'CA',
        '95405' => 'CA',
        '95407' => 'CA',
        '95409' => 'CA',
        '95410' => 'CA',
        '95412' => 'CA',
        '95415' => 'CA',
        '95417' => 'CA',
        '95419' => 'CA',
        '95420' => 'CA',
        '95421' => 'CA',
        '95422' => 'CA',
        '95423' => 'CA',
        '95425' => 'CA',
        '95426' => 'CA',
        '95427' => 'CA',
        '95428' => 'CA',
        '95429' => 'CA',
        '95430' => 'CA',
        '95431' => 'CA',
        '95432' => 'CA',
        '95435' => 'CA',
        '95436' => 'CA',
        '95437' => 'CA',
        '95439' => 'CA',
        '95441' => 'CA',
        '95442' => 'CA',
        '95443' => 'CA',
        '95444' => 'CA',
        '95445' => 'CA',
        '95446' => 'CA',
        '95448' => 'CA',
        '95449' => 'CA',
        '95450' => 'CA',
        '95451' => 'CA',
        '95452' => 'CA',
        '95453' => 'CA',
        '95454' => 'CA',
        '95456' => 'CA',
        '95457' => 'CA',
        '95458' => 'CA',
        '95459' => 'CA',
        '95460' => 'CA',
        '95461' => 'CA',
        '95462' => 'CA',
        '95463' => 'CA',
        '95464' => 'CA',
        '95465' => 'CA',
        '95466' => 'CA',
        '95467' => 'CA',
        '95468' => 'CA',
        '95469' => 'CA',
        '95470' => 'CA',
        '95471' => 'CA',
        '95472' => 'CA',
        '95476' => 'CA',
        '95480' => 'CA',
        '95482' => 'CA',
        '95485' => 'CA',
        '95486' => 'CA',
        '95488' => 'CA',
        '95490' => 'CA',
        '95492' => 'CA',
        '95493' => 'CA',
        '95494' => 'CA',
        '95497' => 'CA',
        '95501' => 'CA',
        '95503' => 'CA',
        '95511' => 'CA',
        '95514' => 'CA',
        '95519' => 'CA',
        '95521' => 'CA',
        '95524' => 'CA',
        '95525' => 'CA',
        '95526' => 'CA',
        '95527' => 'CA',
        '95528' => 'CA',
        '95531' => 'CA',
        '95536' => 'CA',
        '95537' => 'CA',
        '95538' => 'CA',
        '95540' => 'CA',
        '95542' => 'CA',
        '95543' => 'CA',
        '95545' => 'CA',
        '95546' => 'CA',
        '95547' => 'CA',
        '95548' => 'CA',
        '95549' => 'CA',
        '95550' => 'CA',
        '95551' => 'CA',
        '95552' => 'CA',
        '95553' => 'CA',
        '95554' => 'CA',
        '95555' => 'CA',
        '95556' => 'CA',
        '95558' => 'CA',
        '95559' => 'CA',
        '95560' => 'CA',
        '95562' => 'CA',
        '95563' => 'CA',
        '95564' => 'CA',
        '95565' => 'CA',
        '95567' => 'CA',
        '95568' => 'CA',
        '95569' => 'CA',
        '95570' => 'CA',
        '95571' => 'CA',
        '95573' => 'CA',
        '95585' => 'CA',
        '95587' => 'CA',
        '95589' => 'CA',
        '95595' => 'CA',
        '95601' => 'CA',
        '95602' => 'CA',
        '95603' => 'CA',
        '95604' => 'CA',
        '95605' => 'CA',
        '95606' => 'CA',
        '95607' => 'CA',
        '95608' => 'CA',
        '95610' => 'CA',
        '95612' => 'CA',
        '95613' => 'CA',
        '95614' => 'CA',
        '95615' => 'CA',
        '95616' => 'CA',
        '95618' => 'CA',
        '95619' => 'CA',
        '95620' => 'CA',
        '95621' => 'CA',
        '95623' => 'CA',
        '95624' => 'CA',
        '95625' => 'CA',
        '95626' => 'CA',
        '95627' => 'CA',
        '95628' => 'CA',
        '95629' => 'CA',
        '95630' => 'CA',
        '95631' => 'CA',
        '95632' => 'CA',
        '95633' => 'CA',
        '95634' => 'CA',
        '95635' => 'CA',
        '95636' => 'CA',
        '95637' => 'CA',
        '95638' => 'CA',
        '95639' => 'CA',
        '95640' => 'CA',
        '95641' => 'CA',
        '95642' => 'CA',
        '95645' => 'CA',
        '95646' => 'CA',
        '95648' => 'CA',
        '95650' => 'CA',
        '95651' => 'CA',
        '95652' => 'CA',
        '95653' => 'CA',
        '95655' => 'CA',
        '95658' => 'CA',
        '95659' => 'CA',
        '95660' => 'CA',
        '95661' => 'CA',
        '95662' => 'CA',
        '95663' => 'CA',
        '95664' => 'CA',
        '95665' => 'CA',
        '95666' => 'CA',
        '95667' => 'CA',
        '95668' => 'CA',
        '95669' => 'CA',
        '95670' => 'CA',
        '95671' => 'CA',
        '95672' => 'CA',
        '95673' => 'CA',
        '95674' => 'CA',
        '95675' => 'CA',
        '95676' => 'CA',
        '95677' => 'CA',
        '95678' => 'CA',
        '95679' => 'CA',
        '95680' => 'CA',
        '95681' => 'CA',
        '95682' => 'CA',
        '95683' => 'CA',
        '95684' => 'CA',
        '95685' => 'CA',
        '95686' => 'CA',
        '95687' => 'CA',
        '95688' => 'CA',
        '95689' => 'CA',
        '95690' => 'CA',
        '95691' => 'CA',
        '95692' => 'CA',
        '95693' => 'CA',
        '95694' => 'CA',
        '95695' => 'CA',
        '95697' => 'CA',
        '95698' => 'CA',
        '95699' => 'CA',
        '95701' => 'CA',
        '95703' => 'CA',
        '95709' => 'CA',
        '95713' => 'CA',
        '95714' => 'CA',
        '95715' => 'CA',
        '95717' => 'CA',
        '95720' => 'CA',
        '95721' => 'CA',
        '95722' => 'CA',
        '95726' => 'CA',
        '95728' => 'CA',
        '95735' => 'CA',
        '95736' => 'CA',
        '95742' => 'CA',
        '95746' => 'CA',
        '95747' => 'CA',
        '95757' => 'CA',
        '95758' => 'CA',
        '95762' => 'CA',
        '95765' => 'CA',
        '95776' => 'CA',
        '95811' => 'CA',
        '95814' => 'CA',
        '95815' => 'CA',
        '95816' => 'CA',
        '95817' => 'CA',
        '95818' => 'CA',
        '95819' => 'CA',
        '95820' => 'CA',
        '95821' => 'CA',
        '95822' => 'CA',
        '95823' => 'CA',
        '95824' => 'CA',
        '95825' => 'CA',
        '95826' => 'CA',
        '95827' => 'CA',
        '95828' => 'CA',
        '95829' => 'CA',
        '95830' => 'CA',
        '95831' => 'CA',
        '95832' => 'CA',
        '95833' => 'CA',
        '95834' => 'CA',
        '95835' => 'CA',
        '95837' => 'CA',
        '95838' => 'CA',
        '95841' => 'CA',
        '95842' => 'CA',
        '95843' => 'CA',
        '95864' => 'CA',
        '95901' => 'CA',
        '95903' => 'CA',
        '95910' => 'CA',
        '95912' => 'CA',
        '95913' => 'CA',
        '95914' => 'CA',
        '95915' => 'CA',
        '95916' => 'CA',
        '95917' => 'CA',
        '95918' => 'CA',
        '95919' => 'CA',
        '95920' => 'CA',
        '95922' => 'CA',
        '95923' => 'CA',
        '95925' => 'CA',
        '95926' => 'CA',
        '95928' => 'CA',
        '95929' => 'CA',
        '95930' => 'CA',
        '95932' => 'CA',
        '95934' => 'CA',
        '95935' => 'CA',
        '95936' => 'CA',
        '95937' => 'CA',
        '95938' => 'CA',
        '95939' => 'CA',
        '95941' => 'CA',
        '95942' => 'CA',
        '95943' => 'CA',
        '95944' => 'CA',
        '95945' => 'CA',
        '95946' => 'CA',
        '95947' => 'CA',
        '95948' => 'CA',
        '95949' => 'CA',
        '95950' => 'CA',
        '95951' => 'CA',
        '95953' => 'CA',
        '95954' => 'CA',
        '95955' => 'CA',
        '95956' => 'CA',
        '95957' => 'CA',
        '95958' => 'CA',
        '95959' => 'CA',
        '95960' => 'CA',
        '95961' => 'CA',
        '95962' => 'CA',
        '95963' => 'CA',
        '95965' => 'CA',
        '95966' => 'CA',
        '95968' => 'CA',
        '95969' => 'CA',
        '95970' => 'CA',
        '95971' => 'CA',
        '95972' => 'CA',
        '95973' => 'CA',
        '95974' => 'CA',
        '95975' => 'CA',
        '95977' => 'CA',
        '95978' => 'CA',
        '95979' => 'CA',
        '95981' => 'CA',
        '95982' => 'CA',
        '95983' => 'CA',
        '95984' => 'CA',
        '95986' => 'CA',
        '95987' => 'CA',
        '95988' => 'CA',
        '95991' => 'CA',
        '95993' => 'CA',
        '96001' => 'CA',
        '96002' => 'CA',
        '96003' => 'CA',
        '96006' => 'CA',
        '96007' => 'CA',
        '96008' => 'CA',
        '96009' => 'CA',
        '96010' => 'CA',
        '96011' => 'CA',
        '96013' => 'CA',
        '96014' => 'CA',
        '96015' => 'CA',
        '96016' => 'CA',
        '96017' => 'CA',
        '96019' => 'CA',
        '96020' => 'CA',
        '96021' => 'CA',
        '96022' => 'CA',
        '96023' => 'CA',
        '96024' => 'CA',
        '96025' => 'CA',
        '96027' => 'CA',
        '96028' => 'CA',
        '96029' => 'CA',
        '96031' => 'CA',
        '96032' => 'CA',
        '96033' => 'CA',
        '96034' => 'CA',
        '96035' => 'CA',
        '96037' => 'CA',
        '96038' => 'CA',
        '96039' => 'CA',
        '96040' => 'CA',
        '96041' => 'CA',
        '96044' => 'CA',
        '96046' => 'CA',
        '96047' => 'CA',
        '96048' => 'CA',
        '96050' => 'CA',
        '96051' => 'CA',
        '96052' => 'CA',
        '96054' => 'CA',
        '96055' => 'CA',
        '96056' => 'CA',
        '96057' => 'CA',
        '96058' => 'CA',
        '96059' => 'CA',
        '96061' => 'CA',
        '96062' => 'CA',
        '96063' => 'CA',
        '96064' => 'CA',
        '96065' => 'CA',
        '96067' => 'CA',
        '96068' => 'CA',
        '96069' => 'CA',
        '96071' => 'CA',
        '96073' => 'CA',
        '96074' => 'CA',
        '96075' => 'CA',
        '96076' => 'CA',
        '96078' => 'CA',
        '96080' => 'CA',
        '96084' => 'CA',
        '96085' => 'CA',
        '96086' => 'CA',
        '96087' => 'CA',
        '96088' => 'CA',
        '96090' => 'CA',
        '96091' => 'CA',
        '96092' => 'CA',
        '96093' => 'CA',
        '96094' => 'CA',
        '96096' => 'CA',
        '96097' => 'CA',
        '96101' => 'CA',
        '96103' => 'CA',
        '96104' => 'CA',
        '96105' => 'CA',
        '96106' => 'CA',
        '96107' => 'CA',
        '96108' => 'CA',
        '96109' => 'CA',
        '96110' => 'CA',
        '96111' => 'CA',
        '96112' => 'CA',
        '96113' => 'CA',
        '96114' => 'CA',
        '96115' => 'CA',
        '96116' => 'CA',
        '96117' => 'CA',
        '96118' => 'CA',
        '96119' => 'CA',
        '96120' => 'CA',
        '96121' => 'CA',
        '96122' => 'CA',
        '96123' => 'CA',
        '96124' => 'CA',
        '96125' => 'CA',
        '96126' => 'CA',
        '96128' => 'CA',
        '96129' => 'CA',
        '96130' => 'CA',
        '96132' => 'CA',
        '96133' => 'CA',
        '96134' => 'CA',
        '96135' => 'CA',
        '96136' => 'CA',
        '96137' => 'CA',
        '96140' => 'CA',
        '96141' => 'CA',
        '96142' => 'CA',
        '96143' => 'CA',
        '96145' => 'CA',
        '96146' => 'CA',
        '96148' => 'CA',
        '96150' => 'CA',
        '96155' => 'CA',
        '96161' => 'CA',
        '96701' => 'HI',
        '96703' => 'HI',
        '96704' => 'HI',
        '96705' => 'HI',
        '96706' => 'HI',
        '96707' => 'HI',
        '96708' => 'HI',
        '96710' => 'HI',
        '96712' => 'HI',
        '96713' => 'HI',
        '96714' => 'HI',
        '96716' => 'HI',
        '96717' => 'HI',
        '96719' => 'HI',
        '96720' => 'HI',
        '96722' => 'HI',
        '96725' => 'HI',
        '96726' => 'HI',
        '96727' => 'HI',
        '96728' => 'HI',
        '96729' => 'HI',
        '96730' => 'HI',
        '96731' => 'HI',
        '96732' => 'HI',
        '96734' => 'HI',
        '96737' => 'HI',
        '96738' => 'HI',
        '96740' => 'HI',
        '96741' => 'HI',
        '96742' => 'HI',
        '96743' => 'HI',
        '96744' => 'HI',
        '96746' => 'HI',
        '96747' => 'HI',
        '96748' => 'HI',
        '96749' => 'HI',
        '96750' => 'HI',
        '96751' => 'HI',
        '96752' => 'HI',
        '96753' => 'HI',
        '96754' => 'HI',
        '96755' => 'HI',
        '96756' => 'HI',
        '96757' => 'HI',
        '96759' => 'HI',
        '96760' => 'HI',
        '96761' => 'HI',
        '96762' => 'HI',
        '96763' => 'HI',
        '96764' => 'HI',
        '96765' => 'HI',
        '96766' => 'HI',
        '96768' => 'HI',
        '96769' => 'HI',
        '96770' => 'HI',
        '96771' => 'HI',
        '96772' => 'HI',
        '96773' => 'HI',
        '96774' => 'HI',
        '96776' => 'HI',
        '96777' => 'HI',
        '96778' => 'HI',
        '96779' => 'HI',
        '96780' => 'HI',
        '96781' => 'HI',
        '96782' => 'HI',
        '96783' => 'HI',
        '96785' => 'HI',
        '96786' => 'HI',
        '96789' => 'HI',
        '96790' => 'HI',
        '96791' => 'HI',
        '96792' => 'HI',
        '96793' => 'HI',
        '96795' => 'HI',
        '96796' => 'HI',
        '96797' => 'HI',
        '96799' => 'AS',
        '96813' => 'HI',
        '96814' => 'HI',
        '96815' => 'HI',
        '96816' => 'HI',
        '96817' => 'HI',
        '96818' => 'HI',
        '96819' => 'HI',
        '96820' => 'HI',
        '96821' => 'HI',
        '96822' => 'HI',
        '96825' => 'HI',
        '96826' => 'HI',
        '96848' => 'HI',
        '96850' => 'HI',
        '96853' => 'HI',
        '96857' => 'HI',
        '96858' => 'HI',
        '96859' => 'HI',
        '96860' => 'HI',
        '96863' => 'HI',
        '96910' => 'GU',
        '96913' => 'GU',
        '96915' => 'GU',
        '96916' => 'GU',
        '96917' => 'GU',
        '96928' => 'GU',
        '96929' => 'GU',
        '96950' => 'MP',
        '96951' => 'MP',
        '96952' => 'MP',
        '97001' => 'OR',
        '97002' => 'OR',
        '97003' => 'OR',
        '97004' => 'OR',
        '97005' => 'OR',
        '97006' => 'OR',
        '97007' => 'OR',
        '97008' => 'OR',
        '97009' => 'OR',
        '97011' => 'OR',
        '97013' => 'OR',
        '97014' => 'OR',
        '97015' => 'OR',
        '97016' => 'OR',
        '97017' => 'OR',
        '97018' => 'OR',
        '97019' => 'OR',
        '97020' => 'OR',
        '97021' => 'OR',
        '97022' => 'OR',
        '97023' => 'OR',
        '97024' => 'OR',
        '97026' => 'OR',
        '97027' => 'OR',
        '97028' => 'OR',
        '97029' => 'OR',
        '97030' => 'OR',
        '97031' => 'OR',
        '97032' => 'OR',
        '97033' => 'OR',
        '97034' => 'OR',
        '97035' => 'OR',
        '97037' => 'OR',
        '97038' => 'OR',
        '97039' => 'OR',
        '97040' => 'OR',
        '97041' => 'OR',
        '97042' => 'OR',
        '97045' => 'OR',
        '97048' => 'OR',
        '97049' => 'OR',
        '97050' => 'OR',
        '97051' => 'OR',
        '97053' => 'OR',
        '97054' => 'OR',
        '97055' => 'OR',
        '97056' => 'OR',
        '97057' => 'OR',
        '97058' => 'OR',
        '97060' => 'OR',
        '97062' => 'OR',
        '97063' => 'OR',
        '97064' => 'OR',
        '97065' => 'OR',
        '97067' => 'OR',
        '97068' => 'OR',
        '97070' => 'OR',
        '97071' => 'OR',
        '97078' => 'OR',
        '97080' => 'OR',
        '97086' => 'OR',
        '97089' => 'OR',
        '97101' => 'OR',
        '97102' => 'OR',
        '97103' => 'OR',
        '97106' => 'OR',
        '97107' => 'OR',
        '97108' => 'OR',
        '97109' => 'OR',
        '97110' => 'OR',
        '97111' => 'OR',
        '97112' => 'OR',
        '97113' => 'OR',
        '97114' => 'OR',
        '97115' => 'OR',
        '97116' => 'OR',
        '97117' => 'OR',
        '97118' => 'OR',
        '97119' => 'OR',
        '97121' => 'OR',
        '97122' => 'OR',
        '97123' => 'OR',
        '97124' => 'OR',
        '97125' => 'OR',
        '97127' => 'OR',
        '97128' => 'OR',
        '97130' => 'OR',
        '97131' => 'OR',
        '97132' => 'OR',
        '97133' => 'OR',
        '97134' => 'OR',
        '97135' => 'OR',
        '97136' => 'OR',
        '97137' => 'OR',
        '97138' => 'OR',
        '97140' => 'OR',
        '97141' => 'OR',
        '97144' => 'OR',
        '97145' => 'OR',
        '97146' => 'OR',
        '97147' => 'OR',
        '97148' => 'OR',
        '97149' => 'OR',
        '97201' => 'OR',
        '97202' => 'OR',
        '97203' => 'OR',
        '97204' => 'OR',
        '97205' => 'OR',
        '97206' => 'OR',
        '97208' => 'OR',
        '97209' => 'OR',
        '97210' => 'OR',
        '97211' => 'OR',
        '97212' => 'OR',
        '97213' => 'OR',
        '97214' => 'OR',
        '97215' => 'OR',
        '97216' => 'OR',
        '97217' => 'OR',
        '97218' => 'OR',
        '97219' => 'OR',
        '97220' => 'OR',
        '97221' => 'OR',
        '97222' => 'OR',
        '97223' => 'OR',
        '97224' => 'OR',
        '97225' => 'OR',
        '97227' => 'OR',
        '97229' => 'OR',
        '97230' => 'OR',
        '97231' => 'OR',
        '97232' => 'OR',
        '97233' => 'OR',
        '97236' => 'OR',
        '97239' => 'OR',
        '97266' => 'OR',
        '97267' => 'OR',
        '97301' => 'OR',
        '97302' => 'OR',
        '97303' => 'OR',
        '97304' => 'OR',
        '97305' => 'OR',
        '97306' => 'OR',
        '97310' => 'OR',
        '97317' => 'OR',
        '97321' => 'OR',
        '97322' => 'OR',
        '97324' => 'OR',
        '97325' => 'OR',
        '97326' => 'OR',
        '97327' => 'OR',
        '97329' => 'OR',
        '97330' => 'OR',
        '97331' => 'OR',
        '97333' => 'OR',
        '97335' => 'OR',
        '97336' => 'OR',
        '97338' => 'OR',
        '97341' => 'OR',
        '97342' => 'OR',
        '97343' => 'OR',
        '97344' => 'OR',
        '97345' => 'OR',
        '97346' => 'OR',
        '97347' => 'OR',
        '97348' => 'OR',
        '97350' => 'OR',
        '97351' => 'OR',
        '97352' => 'OR',
        '97355' => 'OR',
        '97357' => 'OR',
        '97358' => 'OR',
        '97360' => 'OR',
        '97361' => 'OR',
        '97362' => 'OR',
        '97364' => 'OR',
        '97365' => 'OR',
        '97366' => 'OR',
        '97367' => 'OR',
        '97368' => 'OR',
        '97369' => 'OR',
        '97370' => 'OR',
        '97371' => 'OR',
        '97373' => 'OR',
        '97374' => 'OR',
        '97375' => 'OR',
        '97376' => 'OR',
        '97377' => 'OR',
        '97378' => 'OR',
        '97380' => 'OR',
        '97381' => 'OR',
        '97383' => 'OR',
        '97384' => 'OR',
        '97385' => 'OR',
        '97386' => 'OR',
        '97388' => 'OR',
        '97389' => 'OR',
        '97390' => 'OR',
        '97391' => 'OR',
        '97392' => 'OR',
        '97394' => 'OR',
        '97396' => 'OR',
        '97401' => 'OR',
        '97402' => 'OR',
        '97403' => 'OR',
        '97404' => 'OR',
        '97405' => 'OR',
        '97406' => 'OR',
        '97408' => 'OR',
        '97410' => 'OR',
        '97411' => 'OR',
        '97412' => 'OR',
        '97413' => 'OR',
        '97414' => 'OR',
        '97415' => 'OR',
        '97416' => 'OR',
        '97417' => 'OR',
        '97419' => 'OR',
        '97420' => 'OR',
        '97423' => 'OR',
        '97424' => 'OR',
        '97426' => 'OR',
        '97429' => 'OR',
        '97430' => 'OR',
        '97431' => 'OR',
        '97432' => 'OR',
        '97434' => 'OR',
        '97435' => 'OR',
        '97436' => 'OR',
        '97437' => 'OR',
        '97438' => 'OR',
        '97439' => 'OR',
        '97441' => 'OR',
        '97442' => 'OR',
        '97443' => 'OR',
        '97444' => 'OR',
        '97446' => 'OR',
        '97447' => 'OR',
        '97448' => 'OR',
        '97449' => 'OR',
        '97450' => 'OR',
        '97451' => 'OR',
        '97452' => 'OR',
        '97453' => 'OR',
        '97454' => 'OR',
        '97455' => 'OR',
        '97456' => 'OR',
        '97457' => 'OR',
        '97458' => 'OR',
        '97459' => 'OR',
        '97461' => 'OR',
        '97462' => 'OR',
        '97463' => 'OR',
        '97465' => 'OR',
        '97466' => 'OR',
        '97467' => 'OR',
        '97469' => 'OR',
        '97470' => 'OR',
        '97471' => 'OR',
        '97473' => 'OR',
        '97476' => 'OR',
        '97477' => 'OR',
        '97478' => 'OR',
        '97479' => 'OR',
        '97480' => 'OR',
        '97481' => 'OR',
        '97484' => 'OR',
        '97486' => 'OR',
        '97487' => 'OR',
        '97488' => 'OR',
        '97489' => 'OR',
        '97490' => 'OR',
        '97492' => 'OR',
        '97493' => 'OR',
        '97494' => 'OR',
        '97495' => 'OR',
        '97496' => 'OR',
        '97497' => 'OR',
        '97498' => 'OR',
        '97499' => 'OR',
        '97501' => 'OR',
        '97502' => 'OR',
        '97503' => 'OR',
        '97504' => 'OR',
        '97520' => 'OR',
        '97522' => 'OR',
        '97523' => 'OR',
        '97524' => 'OR',
        '97525' => 'OR',
        '97526' => 'OR',
        '97527' => 'OR',
        '97530' => 'OR',
        '97531' => 'OR',
        '97532' => 'OR',
        '97534' => 'OR',
        '97535' => 'OR',
        '97536' => 'OR',
        '97537' => 'OR',
        '97538' => 'OR',
        '97539' => 'OR',
        '97540' => 'OR',
        '97541' => 'OR',
        '97543' => 'OR',
        '97544' => 'OR',
        '97601' => 'OR',
        '97603' => 'OR',
        '97604' => 'OR',
        '97620' => 'OR',
        '97621' => 'OR',
        '97622' => 'OR',
        '97623' => 'OR',
        '97624' => 'OR',
        '97625' => 'OR',
        '97626' => 'OR',
        '97627' => 'OR',
        '97630' => 'OR',
        '97632' => 'OR',
        '97633' => 'OR',
        '97634' => 'OR',
        '97635' => 'OR',
        '97636' => 'OR',
        '97637' => 'OR',
        '97638' => 'OR',
        '97639' => 'OR',
        '97640' => 'OR',
        '97641' => 'OR',
        '97701' => 'OR',
        '97702' => 'OR',
        '97703' => 'OR',
        '97707' => 'OR',
        '97709' => 'OR',
        '97710' => 'OR',
        '97711' => 'OR',
        '97712' => 'OR',
        '97720' => 'OR',
        '97721' => 'OR',
        '97722' => 'OR',
        '97730' => 'OR',
        '97731' => 'OR',
        '97732' => 'OR',
        '97733' => 'OR',
        '97734' => 'OR',
        '97735' => 'OR',
        '97736' => 'OR',
        '97737' => 'OR',
        '97738' => 'OR',
        '97739' => 'OR',
        '97741' => 'OR',
        '97750' => 'OR',
        '97751' => 'OR',
        '97752' => 'OR',
        '97753' => 'OR',
        '97754' => 'OR',
        '97756' => 'OR',
        '97758' => 'OR',
        '97759' => 'OR',
        '97760' => 'OR',
        '97761' => 'OR',
        '97801' => 'OR',
        '97810' => 'OR',
        '97812' => 'OR',
        '97813' => 'OR',
        '97814' => 'OR',
        '97817' => 'OR',
        '97818' => 'OR',
        '97819' => 'OR',
        '97820' => 'OR',
        '97823' => 'OR',
        '97824' => 'OR',
        '97825' => 'OR',
        '97826' => 'OR',
        '97827' => 'OR',
        '97828' => 'OR',
        '97830' => 'OR',
        '97833' => 'OR',
        '97834' => 'OR',
        '97835' => 'OR',
        '97836' => 'OR',
        '97837' => 'OR',
        '97838' => 'OR',
        '97839' => 'OR',
        '97840' => 'OR',
        '97841' => 'OR',
        '97842' => 'OR',
        '97843' => 'OR',
        '97844' => 'OR',
        '97845' => 'OR',
        '97846' => 'OR',
        '97848' => 'OR',
        '97850' => 'OR',
        '97856' => 'OR',
        '97857' => 'OR',
        '97859' => 'OR',
        '97862' => 'OR',
        '97864' => 'OR',
        '97865' => 'OR',
        '97867' => 'OR',
        '97868' => 'OR',
        '97869' => 'OR',
        '97870' => 'OR',
        '97873' => 'OR',
        '97874' => 'OR',
        '97875' => 'OR',
        '97876' => 'OR',
        '97877' => 'OR',
        '97880' => 'OR',
        '97882' => 'OR',
        '97883' => 'OR',
        '97884' => 'OR',
        '97885' => 'OR',
        '97886' => 'OR',
        '97901' => 'OR',
        '97902' => 'OR',
        '97903' => 'OR',
        '97904' => 'OR',
        '97905' => 'OR',
        '97906' => 'OR',
        '97907' => 'OR',
        '97908' => 'OR',
        '97909' => 'OR',
        '97910' => 'OR',
        '97911' => 'OR',
        '97913' => 'OR',
        '97914' => 'OR',
        '97917' => 'OR',
        '97918' => 'OR',
        '97920' => 'OR',
        '98001' => 'WA',
        '98002' => 'WA',
        '98003' => 'WA',
        '98004' => 'WA',
        '98005' => 'WA',
        '98006' => 'WA',
        '98007' => 'WA',
        '98008' => 'WA',
        '98010' => 'WA',
        '98011' => 'WA',
        '98012' => 'WA',
        '98014' => 'WA',
        '98019' => 'WA',
        '98020' => 'WA',
        '98021' => 'WA',
        '98022' => 'WA',
        '98023' => 'WA',
        '98024' => 'WA',
        '98025' => 'WA',
        '98026' => 'WA',
        '98027' => 'WA',
        '98028' => 'WA',
        '98029' => 'WA',
        '98030' => 'WA',
        '98031' => 'WA',
        '98032' => 'WA',
        '98033' => 'WA',
        '98034' => 'WA',
        '98036' => 'WA',
        '98037' => 'WA',
        '98038' => 'WA',
        '98039' => 'WA',
        '98040' => 'WA',
        '98042' => 'WA',
        '98043' => 'WA',
        '98045' => 'WA',
        '98047' => 'WA',
        '98050' => 'WA',
        '98051' => 'WA',
        '98052' => 'WA',
        '98053' => 'WA',
        '98055' => 'WA',
        '98056' => 'WA',
        '98057' => 'WA',
        '98058' => 'WA',
        '98059' => 'WA',
        '98065' => 'WA',
        '98068' => 'WA',
        '98070' => 'WA',
        '98072' => 'WA',
        '98074' => 'WA',
        '98075' => 'WA',
        '98077' => 'WA',
        '98087' => 'WA',
        '98092' => 'WA',
        '98101' => 'WA',
        '98102' => 'WA',
        '98103' => 'WA',
        '98104' => 'WA',
        '98105' => 'WA',
        '98106' => 'WA',
        '98107' => 'WA',
        '98108' => 'WA',
        '98109' => 'WA',
        '98110' => 'WA',
        '98112' => 'WA',
        '98115' => 'WA',
        '98116' => 'WA',
        '98117' => 'WA',
        '98118' => 'WA',
        '98119' => 'WA',
        '98121' => 'WA',
        '98122' => 'WA',
        '98125' => 'WA',
        '98126' => 'WA',
        '98133' => 'WA',
        '98134' => 'WA',
        '98136' => 'WA',
        '98144' => 'WA',
        '98146' => 'WA',
        '98148' => 'WA',
        '98154' => 'WA',
        '98155' => 'WA',
        '98158' => 'WA',
        '98164' => 'WA',
        '98166' => 'WA',
        '98168' => 'WA',
        '98174' => 'WA',
        '98177' => 'WA',
        '98178' => 'WA',
        '98188' => 'WA',
        '98195' => 'WA',
        '98198' => 'WA',
        '98199' => 'WA',
        '98201' => 'WA',
        '98203' => 'WA',
        '98204' => 'WA',
        '98207' => 'WA',
        '98208' => 'WA',
        '98220' => 'WA',
        '98221' => 'WA',
        '98222' => 'WA',
        '98223' => 'WA',
        '98224' => 'WA',
        '98225' => 'WA',
        '98226' => 'WA',
        '98229' => 'WA',
        '98230' => 'WA',
        '98232' => 'WA',
        '98233' => 'WA',
        '98235' => 'WA',
        '98236' => 'WA',
        '98237' => 'WA',
        '98238' => 'WA',
        '98239' => 'WA',
        '98240' => 'WA',
        '98241' => 'WA',
        '98243' => 'WA',
        '98244' => 'WA',
        '98245' => 'WA',
        '98247' => 'WA',
        '98248' => 'WA',
        '98249' => 'WA',
        '98250' => 'WA',
        '98251' => 'WA',
        '98252' => 'WA',
        '98253' => 'WA',
        '98255' => 'WA',
        '98256' => 'WA',
        '98257' => 'WA',
        '98258' => 'WA',
        '98260' => 'WA',
        '98261' => 'WA',
        '98262' => 'WA',
        '98263' => 'WA',
        '98264' => 'WA',
        '98266' => 'WA',
        '98267' => 'WA',
        '98270' => 'WA',
        '98271' => 'WA',
        '98272' => 'WA',
        '98273' => 'WA',
        '98274' => 'WA',
        '98275' => 'WA',
        '98276' => 'WA',
        '98277' => 'WA',
        '98278' => 'WA',
        '98279' => 'WA',
        '98280' => 'WA',
        '98281' => 'WA',
        '98282' => 'WA',
        '98283' => 'WA',
        '98284' => 'WA',
        '98286' => 'WA',
        '98288' => 'WA',
        '98290' => 'WA',
        '98292' => 'WA',
        '98294' => 'WA',
        '98295' => 'WA',
        '98296' => 'WA',
        '98297' => 'WA',
        '98303' => 'WA',
        '98304' => 'WA',
        '98305' => 'WA',
        '98310' => 'WA',
        '98311' => 'WA',
        '98312' => 'WA',
        '98314' => 'WA',
        '98315' => 'WA',
        '98320' => 'WA',
        '98321' => 'WA',
        '98323' => 'WA',
        '98325' => 'WA',
        '98326' => 'WA',
        '98327' => 'WA',
        '98328' => 'WA',
        '98329' => 'WA',
        '98330' => 'WA',
        '98331' => 'WA',
        '98332' => 'WA',
        '98333' => 'WA',
        '98335' => 'WA',
        '98336' => 'WA',
        '98337' => 'WA',
        '98338' => 'WA',
        '98339' => 'WA',
        '98340' => 'WA',
        '98342' => 'WA',
        '98345' => 'WA',
        '98346' => 'WA',
        '98349' => 'WA',
        '98350' => 'WA',
        '98351' => 'WA',
        '98353' => 'WA',
        '98354' => 'WA',
        '98355' => 'WA',
        '98356' => 'WA',
        '98357' => 'WA',
        '98358' => 'WA',
        '98359' => 'WA',
        '98360' => 'WA',
        '98361' => 'WA',
        '98362' => 'WA',
        '98363' => 'WA',
        '98364' => 'WA',
        '98365' => 'WA',
        '98366' => 'WA',
        '98367' => 'WA',
        '98368' => 'WA',
        '98370' => 'WA',
        '98371' => 'WA',
        '98372' => 'WA',
        '98373' => 'WA',
        '98374' => 'WA',
        '98375' => 'WA',
        '98376' => 'WA',
        '98377' => 'WA',
        '98380' => 'WA',
        '98381' => 'WA',
        '98382' => 'WA',
        '98383' => 'WA',
        '98385' => 'WA',
        '98387' => 'WA',
        '98388' => 'WA',
        '98390' => 'WA',
        '98391' => 'WA',
        '98392' => 'WA',
        '98394' => 'WA',
        '98396' => 'WA',
        '98402' => 'WA',
        '98403' => 'WA',
        '98404' => 'WA',
        '98405' => 'WA',
        '98406' => 'WA',
        '98407' => 'WA',
        '98408' => 'WA',
        '98409' => 'WA',
        '98416' => 'WA',
        '98418' => 'WA',
        '98421' => 'WA',
        '98422' => 'WA',
        '98424' => 'WA',
        '98430' => 'WA',
        '98433' => 'WA',
        '98438' => 'WA',
        '98439' => 'WA',
        '98443' => 'WA',
        '98444' => 'WA',
        '98445' => 'WA',
        '98446' => 'WA',
        '98447' => 'WA',
        '98465' => 'WA',
        '98466' => 'WA',
        '98467' => 'WA',
        '98498' => 'WA',
        '98499' => 'WA',
        '98501' => 'WA',
        '98502' => 'WA',
        '98503' => 'WA',
        '98505' => 'WA',
        '98506' => 'WA',
        '98512' => 'WA',
        '98513' => 'WA',
        '98516' => 'WA',
        '98520' => 'WA',
        '98524' => 'WA',
        '98526' => 'WA',
        '98527' => 'WA',
        '98528' => 'WA',
        '98530' => 'WA',
        '98531' => 'WA',
        '98532' => 'WA',
        '98533' => 'WA',
        '98535' => 'WA',
        '98536' => 'WA',
        '98537' => 'WA',
        '98538' => 'WA',
        '98539' => 'WA',
        '98541' => 'WA',
        '98542' => 'WA',
        '98544' => 'WA',
        '98546' => 'WA',
        '98547' => 'WA',
        '98548' => 'WA',
        '98550' => 'WA',
        '98552' => 'WA',
        '98555' => 'WA',
        '98556' => 'WA',
        '98557' => 'WA',
        '98558' => 'WA',
        '98559' => 'WA',
        '98560' => 'WA',
        '98562' => 'WA',
        '98563' => 'WA',
        '98564' => 'WA',
        '98565' => 'WA',
        '98566' => 'WA',
        '98568' => 'WA',
        '98569' => 'WA',
        '98570' => 'WA',
        '98571' => 'WA',
        '98572' => 'WA',
        '98575' => 'WA',
        '98576' => 'WA',
        '98577' => 'WA',
        '98579' => 'WA',
        '98580' => 'WA',
        '98581' => 'WA',
        '98582' => 'WA',
        '98583' => 'WA',
        '98584' => 'WA',
        '98585' => 'WA',
        '98586' => 'WA',
        '98587' => 'WA',
        '98588' => 'WA',
        '98589' => 'WA',
        '98590' => 'WA',
        '98591' => 'WA',
        '98592' => 'WA',
        '98593' => 'WA',
        '98595' => 'WA',
        '98596' => 'WA',
        '98597' => 'WA',
        '98601' => 'WA',
        '98602' => 'WA',
        '98603' => 'WA',
        '98604' => 'WA',
        '98605' => 'WA',
        '98606' => 'WA',
        '98607' => 'WA',
        '98609' => 'WA',
        '98610' => 'WA',
        '98611' => 'WA',
        '98612' => 'WA',
        '98613' => 'WA',
        '98614' => 'WA',
        '98616' => 'WA',
        '98617' => 'WA',
        '98619' => 'WA',
        '98620' => 'WA',
        '98621' => 'WA',
        '98623' => 'WA',
        '98624' => 'WA',
        '98625' => 'WA',
        '98626' => 'WA',
        '98628' => 'WA',
        '98629' => 'WA',
        '98631' => 'WA',
        '98632' => 'WA',
        '98635' => 'WA',
        '98638' => 'WA',
        '98639' => 'WA',
        '98640' => 'WA',
        '98641' => 'WA',
        '98642' => 'WA',
        '98643' => 'WA',
        '98644' => 'WA',
        '98645' => 'WA',
        '98647' => 'WA',
        '98648' => 'WA',
        '98649' => 'WA',
        '98650' => 'WA',
        '98651' => 'WA',
        '98660' => 'WA',
        '98661' => 'WA',
        '98662' => 'WA',
        '98663' => 'WA',
        '98664' => 'WA',
        '98665' => 'WA',
        '98670' => 'WA',
        '98671' => 'WA',
        '98672' => 'WA',
        '98673' => 'WA',
        '98674' => 'WA',
        '98675' => 'WA',
        '98682' => 'WA',
        '98683' => 'WA',
        '98684' => 'WA',
        '98685' => 'WA',
        '98686' => 'WA',
        '98801' => 'WA',
        '98802' => 'WA',
        '98811' => 'WA',
        '98812' => 'WA',
        '98813' => 'WA',
        '98814' => 'WA',
        '98815' => 'WA',
        '98816' => 'WA',
        '98817' => 'WA',
        '98819' => 'WA',
        '98821' => 'WA',
        '98822' => 'WA',
        '98823' => 'WA',
        '98824' => 'WA',
        '98826' => 'WA',
        '98827' => 'WA',
        '98828' => 'WA',
        '98829' => 'WA',
        '98830' => 'WA',
        '98831' => 'WA',
        '98832' => 'WA',
        '98833' => 'WA',
        '98834' => 'WA',
        '98836' => 'WA',
        '98837' => 'WA',
        '98840' => 'WA',
        '98841' => 'WA',
        '98843' => 'WA',
        '98844' => 'WA',
        '98845' => 'WA',
        '98846' => 'WA',
        '98847' => 'WA',
        '98848' => 'WA',
        '98849' => 'WA',
        '98850' => 'WA',
        '98851' => 'WA',
        '98852' => 'WA',
        '98853' => 'WA',
        '98855' => 'WA',
        '98856' => 'WA',
        '98857' => 'WA',
        '98858' => 'WA',
        '98859' => 'WA',
        '98860' => 'WA',
        '98862' => 'WA',
        '98901' => 'WA',
        '98902' => 'WA',
        '98903' => 'WA',
        '98908' => 'WA',
        '98921' => 'WA',
        '98922' => 'WA',
        '98923' => 'WA',
        '98925' => 'WA',
        '98926' => 'WA',
        '98930' => 'WA',
        '98932' => 'WA',
        '98933' => 'WA',
        '98934' => 'WA',
        '98935' => 'WA',
        '98936' => 'WA',
        '98937' => 'WA',
        '98938' => 'WA',
        '98939' => 'WA',
        '98940' => 'WA',
        '98941' => 'WA',
        '98942' => 'WA',
        '98943' => 'WA',
        '98944' => 'WA',
        '98946' => 'WA',
        '98947' => 'WA',
        '98948' => 'WA',
        '98950' => 'WA',
        '98951' => 'WA',
        '98952' => 'WA',
        '98953' => 'WA',
        '99001' => 'WA',
        '99003' => 'WA',
        '99004' => 'WA',
        '99005' => 'WA',
        '99006' => 'WA',
        '99008' => 'WA',
        '99009' => 'WA',
        '99011' => 'WA',
        '99012' => 'WA',
        '99013' => 'WA',
        '99014' => 'WA',
        '99016' => 'WA',
        '99017' => 'WA',
        '99018' => 'WA',
        '99019' => 'WA',
        '99020' => 'WA',
        '99021' => 'WA',
        '99022' => 'WA',
        '99023' => 'WA',
        '99025' => 'WA',
        '99026' => 'WA',
        '99027' => 'WA',
        '99029' => 'WA',
        '99030' => 'WA',
        '99031' => 'WA',
        '99032' => 'WA',
        '99033' => 'WA',
        '99034' => 'WA',
        '99036' => 'WA',
        '99037' => 'WA',
        '99039' => 'WA',
        '99040' => 'WA',
        '99101' => 'WA',
        '99102' => 'WA',
        '99103' => 'WA',
        '99105' => 'WA',
        '99109' => 'WA',
        '99110' => 'WA',
        '99111' => 'WA',
        '99113' => 'WA',
        '99114' => 'WA',
        '99115' => 'WA',
        '99116' => 'WA',
        '99117' => 'WA',
        '99118' => 'WA',
        '99119' => 'WA',
        '99121' => 'WA',
        '99122' => 'WA',
        '99123' => 'WA',
        '99124' => 'WA',
        '99125' => 'WA',
        '99126' => 'WA',
        '99128' => 'WA',
        '99129' => 'WA',
        '99130' => 'WA',
        '99131' => 'WA',
        '99133' => 'WA',
        '99134' => 'WA',
        '99135' => 'WA',
        '99136' => 'WA',
        '99137' => 'WA',
        '99138' => 'WA',
        '99139' => 'WA',
        '99140' => 'WA',
        '99141' => 'WA',
        '99143' => 'WA',
        '99144' => 'WA',
        '99146' => 'WA',
        '99147' => 'WA',
        '99148' => 'WA',
        '99149' => 'WA',
        '99150' => 'WA',
        '99151' => 'WA',
        '99152' => 'WA',
        '99153' => 'WA',
        '99154' => 'WA',
        '99155' => 'WA',
        '99156' => 'WA',
        '99157' => 'WA',
        '99158' => 'WA',
        '99159' => 'WA',
        '99160' => 'WA',
        '99161' => 'WA',
        '99163' => 'WA',
        '99166' => 'WA',
        '99167' => 'WA',
        '99169' => 'WA',
        '99170' => 'WA',
        '99171' => 'WA',
        '99173' => 'WA',
        '99174' => 'WA',
        '99176' => 'WA',
        '99179' => 'WA',
        '99180' => 'WA',
        '99181' => 'WA',
        '99185' => 'WA',
        '99201' => 'WA',
        '99202' => 'WA',
        '99203' => 'WA',
        '99204' => 'WA',
        '99205' => 'WA',
        '99206' => 'WA',
        '99207' => 'WA',
        '99208' => 'WA',
        '99212' => 'WA',
        '99216' => 'WA',
        '99217' => 'WA',
        '99218' => 'WA',
        '99223' => 'WA',
        '99224' => 'WA',
        '99251' => 'WA',
        '99258' => 'WA',
        '99301' => 'WA',
        '99320' => 'WA',
        '99321' => 'WA',
        '99322' => 'WA',
        '99323' => 'WA',
        '99324' => 'WA',
        '99326' => 'WA',
        '99328' => 'WA',
        '99329' => 'WA',
        '99330' => 'WA',
        '99333' => 'WA',
        '99335' => 'WA',
        '99336' => 'WA',
        '99337' => 'WA',
        '99338' => 'WA',
        '99341' => 'WA',
        '99343' => 'WA',
        '99344' => 'WA',
        '99345' => 'WA',
        '99346' => 'WA',
        '99347' => 'WA',
        '99348' => 'WA',
        '99349' => 'WA',
        '99350' => 'WA',
        '99352' => 'WA',
        '99353' => 'WA',
        '99354' => 'WA',
        '99356' => 'WA',
        '99357' => 'WA',
        '99359' => 'WA',
        '99360' => 'WA',
        '99361' => 'WA',
        '99362' => 'WA',
        '99363' => 'WA',
        '99371' => 'WA',
        '99401' => 'WA',
        '99402' => 'WA',
        '99403' => 'WA',
        '99501' => 'AK',
        '99502' => 'AK',
        '99503' => 'AK',
        '99504' => 'AK',
        '99505' => 'AK',
        '99506' => 'AK',
        '99507' => 'AK',
        '99508' => 'AK',
        '99513' => 'AK',
        '99515' => 'AK',
        '99516' => 'AK',
        '99517' => 'AK',
        '99518' => 'AK',
        '99519' => 'AK',
        '99530' => 'AK',
        '99540' => 'AK',
        '99546' => 'AK',
        '99547' => 'AK',
        '99548' => 'AK',
        '99549' => 'AK',
        '99550' => 'AK',
        '99551' => 'AK',
        '99552' => 'AK',
        '99553' => 'AK',
        '99554' => 'AK',
        '99555' => 'AK',
        '99556' => 'AK',
        '99557' => 'AK',
        '99558' => 'AK',
        '99559' => 'AK',
        '99561' => 'AK',
        '99563' => 'AK',
        '99564' => 'AK',
        '99565' => 'AK',
        '99566' => 'AK',
        '99567' => 'AK',
        '99568' => 'AK',
        '99569' => 'AK',
        '99571' => 'AK',
        '99572' => 'AK',
        '99573' => 'AK',
        '99574' => 'AK',
        '99575' => 'AK',
        '99576' => 'AK',
        '99577' => 'AK',
        '99578' => 'AK',
        '99579' => 'AK',
        '99580' => 'AK',
        '99581' => 'AK',
        '99583' => 'AK',
        '99585' => 'AK',
        '99586' => 'AK',
        '99587' => 'AK',
        '99588' => 'AK',
        '99589' => 'AK',
        '99590' => 'AK',
        '99591' => 'AK',
        '99602' => 'AK',
        '99603' => 'AK',
        '99604' => 'AK',
        '99605' => 'AK',
        '99606' => 'AK',
        '99607' => 'AK',
        '99608' => 'AK',
        '99609' => 'AK',
        '99610' => 'AK',
        '99611' => 'AK',
        '99612' => 'AK',
        '99613' => 'AK',
        '99614' => 'AK',
        '99615' => 'AK',
        '99620' => 'AK',
        '99621' => 'AK',
        '99622' => 'AK',
        '99623' => 'AK',
        '99624' => 'AK',
        '99625' => 'AK',
        '99626' => 'AK',
        '99627' => 'AK',
        '99628' => 'AK',
        '99630' => 'AK',
        '99631' => 'AK',
        '99632' => 'AK',
        '99633' => 'AK',
        '99634' => 'AK',
        '99635' => 'AK',
        '99636' => 'AK',
        '99637' => 'AK',
        '99638' => 'AK',
        '99639' => 'AK',
        '99640' => 'AK',
        '99641' => 'AK',
        '99643' => 'AK',
        '99644' => 'AK',
        '99645' => 'AK',
        '99647' => 'AK',
        '99648' => 'AK',
        '99649' => 'AK',
        '99650' => 'AK',
        '99651' => 'AK',
        '99652' => 'AK',
        '99653' => 'AK',
        '99654' => 'AK',
        '99655' => 'AK',
        '99656' => 'AK',
        '99657' => 'AK',
        '99658' => 'AK',
        '99659' => 'AK',
        '99660' => 'AK',
        '99661' => 'AK',
        '99662' => 'AK',
        '99663' => 'AK',
        '99664' => 'AK',
        '99665' => 'AK',
        '99666' => 'AK',
        '99667' => 'AK',
        '99668' => 'AK',
        '99669' => 'AK',
        '99670' => 'AK',
        '99671' => 'AK',
        '99672' => 'AK',
        '99674' => 'AK',
        '99675' => 'AK',
        '99676' => 'AK',
        '99677' => 'AK',
        '99678' => 'AK',
        '99679' => 'AK',
        '99680' => 'AK',
        '99681' => 'AK',
        '99682' => 'AK',
        '99683' => 'AK',
        '99684' => 'AK',
        '99685' => 'AK',
        '99686' => 'AK',
        '99688' => 'AK',
        '99689' => 'AK',
        '99690' => 'AK',
        '99691' => 'AK',
        '99692' => 'AK',
        '99693' => 'AK',
        '99694' => 'AK',
        '99695' => 'AK',
        '99701' => 'AK',
        '99702' => 'AK',
        '99703' => 'AK',
        '99704' => 'AK',
        '99705' => 'AK',
        '99706' => 'AK',
        '99707' => 'AK',
        '99709' => 'AK',
        '99712' => 'AK',
        '99714' => 'AK',
        '99720' => 'AK',
        '99721' => 'AK',
        '99722' => 'AK',
        '99723' => 'AK',
        '99724' => 'AK',
        '99725' => 'AK',
        '99726' => 'AK',
        '99727' => 'AK',
        '99729' => 'AK',
        '99730' => 'AK',
        '99732' => 'AK',
        '99733' => 'AK',
        '99734' => 'AK',
        '99736' => 'AK',
        '99737' => 'AK',
        '99738' => 'AK',
        '99739' => 'AK',
        '99740' => 'AK',
        '99741' => 'AK',
        '99742' => 'AK',
        '99743' => 'AK',
        '99744' => 'AK',
        '99745' => 'AK',
        '99746' => 'AK',
        '99747' => 'AK',
        '99748' => 'AK',
        '99749' => 'AK',
        '99750' => 'AK',
        '99751' => 'AK',
        '99752' => 'AK',
        '99753' => 'AK',
        '99754' => 'AK',
        '99755' => 'AK',
        '99756' => 'AK',
        '99757' => 'AK',
        '99758' => 'AK',
        '99759' => 'AK',
        '99760' => 'AK',
        '99761' => 'AK',
        '99762' => 'AK',
        '99763' => 'AK',
        '99764' => 'AK',
        '99765' => 'AK',
        '99766' => 'AK',
        '99767' => 'AK',
        '99768' => 'AK',
        '99769' => 'AK',
        '99770' => 'AK',
        '99771' => 'AK',
        '99772' => 'AK',
        '99773' => 'AK',
        '99774' => 'AK',
        '99775' => 'AK',
        '99776' => 'AK',
        '99777' => 'AK',
        '99778' => 'AK',
        '99780' => 'AK',
        '99781' => 'AK',
        '99782' => 'AK',
        '99783' => 'AK',
        '99784' => 'AK',
        '99785' => 'AK',
        '99786' => 'AK',
        '99788' => 'AK',
        '99789' => 'AK',
        '99790' => 'AK',
        '99791' => 'AK',
        '99801' => 'AK',
        '99820' => 'AK',
        '99824' => 'AK',
        '99825' => 'AK',
        '99826' => 'AK',
        '99827' => 'AK',
        '99829' => 'AK',
        '99830' => 'AK',
        '99832' => 'AK',
        '99833' => 'AK',
        '99835' => 'AK',
        '99836' => 'AK',
        '99840' => 'AK',
        '99841' => 'AK',
        '99850' => 'AK',
        '99901' => 'AK',
        '99903' => 'AK',
        '99918' => 'AK',
        '99919' => 'AK',
        '99921' => 'AK',
        '99922' => 'AK',
        '99923' => 'AK',
        '99925' => 'AK',
        '99926' => 'AK',
        '99927' => 'AK',
        '99929' => 'AK',
        ];

    public static function get(): array
    {
        return self::$states;
    }

    public static function getState(?string $zip = '90210'): string
    {
        if (isset(self::$zip_code_map[$zip])) {
            return self::$zip_code_map[$zip];
        }

        $prefix_state = self::getStateFromThreeDigitPrefix($zip);

        if ($prefix_state) {
            return $prefix_state;
        }

        $zippo_response = self::getStateFromZippo($zip);

        if ($zippo_response) {
            return $zippo_response;
        }

        throw new \Exception('Zip code not found');
    }

    /*
    {
    "post code": "90210",
    "country": "United States",
    "country abbreviation": "US",
    "places": [
            {
                "place name": "Beverly Hills",
                "longitude": "-118.4065",
                "state": "California",
                "state abbreviation": "CA",
                "latitude": "34.0901"
            }
        ]
    }
    */
    public static function getStateFromZippo($zip): mixed
    {

        $response = Http::get("https://api.zippopotam.us/us/{$zip}");

        if ($response->failed()) {
            return false;
        }

        $data = $response->object();

        if (isset($data->places[0])) {
            return $data->places[0]->{'state abbreviation'};
        }

        return false;

    }

    public static function getStateFromThreeDigitPrefix($zip): mixed
    {

        /* 000 to 999 */
        $zip_by_state = [
        '--', '--', '--', '--', '--', 'NY', 'PR', 'PR', 'VI', 'PR', 'MA', 'MA', 'MA',
        'MA', 'MA', 'MA', 'MA', 'MA', 'MA', 'MA', 'MA', 'MA', 'MA', 'MA', 'MA', 'MA',
        'MA', 'MA', 'RI', 'RI', 'NH', 'NH', 'NH', 'NH', 'NH', 'NH', 'NH', 'NH', 'NH',
        'ME', 'ME', 'ME', 'ME', 'ME', 'ME', 'ME', 'ME', 'ME', 'ME', 'ME', 'VT', 'VT',
        'VT', 'VT', 'VT', 'MA', 'VT', 'VT', 'VT', 'VT', 'CT', 'CT', 'CT', 'CT', 'CT',
        'CT', 'CT', 'CT', 'CT', 'CT', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ',
        'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'AE',
        'AE', 'AE', 'AE', 'AE', 'AE', 'AE', 'AE', 'AE', '--', 'NY', 'NY', 'NY', 'NY',
        'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY',
        'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY',
        'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY',
        'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA',
        'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA',
        'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA',
        'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', '--', 'PA', 'PA',
        'PA', 'PA', 'DE', 'DE', 'DE', 'DC', 'VA', 'DC', 'DC', 'DC', 'DC', 'MD', 'MD',
        'MD', 'MD', 'MD', 'MD', 'MD', '--', 'MD', 'MD', 'MD', 'MD', 'MD', 'MD', 'VA',
        'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA',
        'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA',
        'WV', 'WV', 'WV', 'WV', 'WV', 'WV', 'WV', 'WV', 'WV', 'WV', 'WV', 'WV', 'WV',
        'WV', 'WV', 'WV', 'WV', 'WV', 'WV', 'WV', 'WV', 'WV', '--', 'NC', 'NC', 'NC',
        'NC', 'NC', 'NC', 'NC', 'NC', 'NC', 'NC', 'NC', 'NC', 'NC', 'NC', 'NC', 'NC',
        'NC', 'NC', 'NC', 'NC', 'SC', 'SC', 'SC', 'SC', 'SC', 'SC', 'SC', 'SC', 'SC',
        'SC', 'GA', 'GA', 'GA', 'GA', 'GA', 'GA', 'GA', 'GA', 'GA', 'GA', 'GA', 'GA',
        'GA', 'GA', 'GA', 'GA', 'GA', 'GA', 'GA', 'GA', 'FL', 'FL', 'FL', 'FL', 'FL',
        'FL', 'FL', 'FL', 'FL', 'FL', 'FL', 'FL', 'FL', 'FL', 'FL', 'FL', 'FL', 'FL',
        'FL', 'FL', 'AA', 'FL', 'FL', '--', 'FL', '--', 'FL', 'FL', '--', 'FL', 'AL',
        'AL', 'AL', '--', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL',
        'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'TN', 'TN', 'TN', 'TN', 'TN', 'TN', 'TN',
        'TN', 'TN', 'TN', 'TN', 'TN', 'TN', 'TN', 'TN', 'TN', 'MS', 'MS', 'MS', 'MS',
        'MS', 'MS', 'MS', 'MS', 'MS', 'MS', 'MS', 'MS', 'GA', '--', 'KY', 'KY', 'KY',
        'KY', 'KY', 'KY', 'KY', 'KY', 'KY', 'KY', 'KY', 'KY', 'KY', 'KY', 'KY', 'KY',
        'KY', 'KY', 'KY', '--', 'KY', 'KY', 'KY', 'KY', 'KY', 'KY', 'KY', 'KY', '--',
        '--', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH',
        'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH',
        'OH', 'OH', 'OH', 'OH', '--', 'IN', 'IN', 'IN', 'IN', 'IN', 'IN', 'IN', 'IN',
        'IN', 'IN', 'IN', 'IN', 'IN', 'IN', 'IN', 'IN', 'IN', 'IN', 'IN', 'IN', 'MI',
        'MI', 'MI', 'MI', 'MI', 'MI', 'MI', 'MI', 'MI', 'MI', 'MI', 'MI', 'MI', 'MI',
        'MI', 'MI', 'MI', 'MI', 'MI', 'MI', 'IA', 'IA', 'IA', 'IA', 'IA', 'IA', 'IA',
        'IA', 'IA', '--', 'IA', 'IA', 'IA', 'IA', 'IA', 'IA', 'IA', '--', '--', '--',
        'IA', 'IA', 'IA', 'IA', 'IA', 'IA', 'IA', 'IA', 'IA', '--', 'WI', 'WI', 'WI',
        '--', 'WI', 'WI', '--', 'WI', 'WI', 'WI', 'WI', 'WI', 'WI', 'WI', 'WI', 'WI',
        'WI', 'WI', 'WI', 'WI', 'MN', 'MN', '--', 'MN', 'MN', 'MN', 'MN', 'MN', 'MN',
        'MN', 'MN', 'MN', 'MN', 'MN', 'MN', 'MN', 'MN', 'MN', '--', 'DC', 'SD', 'SD',
        'SD', 'SD', 'SD', 'SD', 'SD', 'SD', '--', '--', 'ND', 'ND', 'ND', 'ND', 'ND',
        'ND', 'ND', 'ND', 'ND', '--', 'MT', 'MT', 'MT', 'MT', 'MT', 'MT', 'MT', 'MT',
        'MT', 'MT', 'IL', 'IL', 'IL', 'IL', 'IL', 'IL', 'IL', 'IL', 'IL', 'IL', 'IL',
        'IL', 'IL', 'IL', 'IL', 'IL', 'IL', 'IL', 'IL', 'IL', 'IL', '--', 'IL', 'IL',
        'IL', 'IL', 'IL', 'IL', 'IL', 'IL', 'MO', 'MO', '--', 'MO', 'MO', 'MO', 'MO',
        'MO', 'MO', 'MO', 'MO', 'MO', '--', '--', 'MO', 'MO', 'MO', 'MO', 'MO', '--',
        'MO', 'MO', 'MO', 'MO', 'MO', 'MO', 'MO', 'MO', 'MO', '--', 'KS', 'KS', 'KS',
        '--', 'KS', 'KS', 'KS', 'KS', 'KS', 'KS', 'KS', 'KS', 'KS', 'KS', 'KS', 'KS',
        'KS', 'KS', 'KS', 'KS', 'NE', 'NE', '--', 'NE', 'NE', 'NE', 'NE', 'NE', 'NE',
        'NE', 'NE', 'NE', 'NE', 'NE', '--', '--', '--', '--', '--', '--', 'LA', 'LA',
        '--', 'LA', 'LA', 'LA', 'LA', 'LA', 'LA', '--', 'LA', 'LA', 'LA', 'LA', 'LA',
        '--', 'AR', 'AR', 'AR', 'AR', 'AR', 'AR', 'AR', 'AR', 'AR', 'AR', 'AR', 'AR',
        'AR', 'AR', 'OK', 'OK', '--', 'TX', 'OK', 'OK', 'OK', 'OK', 'OK', 'OK', 'OK',
        'OK', '--', 'OK', 'OK', 'OK', 'OK', 'OK', 'OK', 'OK', 'TX', 'TX', 'TX', 'TX',
        'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX',
        'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX',
        'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX',
        'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'CO', 'CO', 'CO', 'CO', 'CO', 'CO',
        'CO', 'CO', 'CO', 'CO', 'CO', 'CO', 'CO', 'CO', 'CO', 'CO', 'CO', '--', '--',
        '--', 'WY', 'WY', 'WY', 'WY', 'WY', 'WY', 'WY', 'WY', 'WY', 'WY', 'WY', 'WY',
        'ID', 'ID', 'ID', 'ID', 'ID', 'ID', 'ID', '--', 'UT', 'UT', '--', 'UT', 'UT',
        'UT', 'UT', 'UT', '--', '--', 'AZ', 'AZ', 'AZ', 'AZ', '--', 'AZ', 'AZ', 'AZ',
        '--', 'AZ', 'AZ', '--', '--', 'AZ', 'AZ', 'AZ', '--', '--', '--', '--', 'NM',
        'NM', '--', 'NM', 'NM', 'NM', '--', 'NM', 'NM', 'NM', 'NM', 'NM', 'NM', 'NM',
        'NM', 'NM', '--', '--', '--', '--', 'NV', 'NV', '--', 'NV', 'NV', 'NV', '--',
        'NV', 'NV', '--', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', '--',
        'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA',
        'CA', 'CA', 'CA', 'CA', 'CA', 'CA', '--', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA',
        'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA',
        'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA',
        'AP', 'AP', 'AP', 'AP', 'AP', 'HI', 'HI', 'GU', 'OR', 'OR', 'OR', 'OR', 'OR',
        'OR', 'OR', 'OR', 'OR', 'OR', 'WA', 'WA', 'WA', 'WA', 'WA', 'WA', 'WA', '--',
        'WA', 'WA', 'WA', 'WA', 'WA', 'WA', 'WA', 'AK', 'AK', 'AK', 'AK', 'AK'
        ];

        $prefix = substr(($zip ?? ''), 0, 3);
        $index = intval($prefix);
        /* converts prefix to integer */
        return $zip_by_state[$index] == "--" ? false : $zip_by_state[$index];

    }
}
