/*
Apache License

Copyright 2023 Github.com/Barqawiz/IntelliNode

   Licensed under the Apache License, Version 2.0 (the "License");
*/
const fs = require('fs');
const path = require('path');

class Config2 {
  constructor() {
    const configPath = path.join(__dirname, '..', 'config.json');
    this.config = JSON.parse(fs.readFileSync(configPath, 'utf-8'));
  }

  getProperty(key) {
    return key.split('.').reduce((obj, k) => (obj && obj[k] !== null && obj[k] !== 'undefined') ? obj[k] : null, this.config);
  }

  static getInstance() {
    if (!Config2.instance) {
      Config2.instance = new Config2();
    }
    return Config2.instance;
  }
}

module.exports = Config2;