#
# Copyright 2016 The BigDL Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
#

from typing import List
from transformers.dynamic_module_utils import get_imports
from ipex_llm.utils.ipex_importer import IPEXImporter


def patch_flash_attn_import(filename: str) -> List[str]:
    """Work around for https://huggingface.co/microsoft/phi-1_5/discussions/72."""
    imports = get_imports(filename)
    if "flash_attn" in imports:
        imports.remove("flash_attn")
    return imports


def patch_sdpa_available() -> bool:
    if IPEXImporter.is_xpu_version_installed():
        return False
    else:
        try:
            from transformers.utils import is_torch_sdpa_available
            return is_torch_sdpa_available()
        except ImportError:
            return False
