# IPEX-LLM Quickstart

> [!NOTE]
> We are adding more Quickstart guides.

This section includes efficient guide to show you how to:

## Install

- [``bigdl-llm`` Migration Guide](./bigdl_llm_migration.md)
- [Install IPEX-LLM on Linux with Intel GPU](./install_linux_gpu.md)
- [Install IPEX-LLM on Windows with Intel GPU](./install_windows_gpu.md)

## Inference

- [Run IPEX-LLM on Intel NPU](./npu_quickstart.md)
- [Run Performance Benchmarking with IPEX-LLM](./benchmark_quickstart.md)
- [Run Local RAG using Langchain-Chatchat on Intel GPU](./chatchat_quickstart.md)
- [Run Text Generation WebUI on Intel GPU](./webui_quickstart.md)
- [Run Open WebUI on Intel GPU](./open_webui_with_ollama_quickstart.md)
- [Run PrivateGPT with IPEX-LLM on Intel GPU](./privateGPT_quickstart.md)
- [Run Coding Copilot (Continue) in VSCode with Intel GPU](./continue_quickstart.md)
- [Run Dify on Intel GPU](./dify_quickstart.md)
- [Run llama.cpp with IPEX-LLM on Intel GPU](./llama_cpp_quickstart.md)
- [Run Ollama with IPEX-LLM on Intel GPU](./ollama_quickstart.md)
- [Run Llama 3 on Intel GPU using llama.cpp and ollama with IPEX-LLM](./llama3_llamacpp_ollama_quickstart.md)
- [Run RAGFlow with IPEX-LLM on Intel GPU](./ragflow_quickstart.md)
- [Run GraphRAG with IPEX-LLM on Intel GPU](./graphrag_quickstart.md)

## Serving

- [Run IPEX-LLM Serving with FastChat](./fastchat_quickstart.md)
- [Run IPEX-LLM Serving with vLLM on Intel GPU](./vLLM_quickstart.md)
- [Run IPEX-LLM serving on Multiple Intel GPUs using DeepSpeed AutoTP and FastApi](./deepspeed_autotp_fastapi_quickstart.md)

## Finetune

- [Finetune LLM with Axolotl on Intel GPU](./axolotl_quickstart.md)