export default {
  html: {
    fontFamily: 'sans-serif',
    msTextSizeAdjust: '100%',
    webkitTextSizeAdjust: '100%',
  },
  body: {
    marginTop: 0,
    marginRight: 0,
    marginBottom: 0,
    marginLeft: 0,
    boxSizing: 'border-box',
  },
  'article, aside, details, figcaption, figure, footer, header, hgroup, main, menu, nav, section, summary': {
    display: 'block',
  },
  'audio, canvas, progress, video': {
    display: 'inline-block',
    verticalAlign: 'baseline',
  },
  'audio:not([controls])': {
    display: 'none',
    height: 0,
  },
  '[hidden], template': {
    display: 'none',
  },
  a: {
    backgroundColor: 'transparent',
  },
  'a:active, a:hover': {
    outline: 0,
  },
  'abbr[title]': {
    borderBottom: '1px dotted',
  },
  'b, strong': {
    fontWeight: 'bold',
  },
  dfn: {
    fontStyle: 'italic',
  },
  h1: {
    fontSize: '2em',
    marginTop: '0.67em',
    marginRight: 0,
    marginBottom: '0.67em',
    marginLeft: 0,
  },
  mark: {
    background: '#ff0',
    color: '#000',
  },
  small: {
    fontSize: '80%',
  },
  'sub, sup': {
    fontSize: '75%',
    lineHeight: 0,
    position: 'relative',
    verticalAlign: 'baseline',
  },
  sup: {
    top: '-0.5em',
  },
  sub: {
    bottom: '-0.25em',
  },
  img: {
    border: 0,
  },
  'svg:not(:root)': {
    overflow: 'hidden',
  },
  figure: {
    marginTop: '1em',
    marginRight: '40px',
    marginBottom: '1em',
    marginLeft: '40px',
  },
  hr: {
    boxSizing: 'content-box',
    height: 0,
  },
  pre: {
    overflow: 'auto',
  },
  'code, kbd, pre, samp': {
    fontFamily: 'monospace, monospace',
    fontSize: '1em',
  },
  'button, input, optgroup, select, textarea': {
    color: 'inherit',
    font: 'inherit',
    marginTop: 0,
    marginRight: 0,
    marginBottom: 0,
    marginLeft: 0,
  },
  button: {
    overflow: 'visible',
  },
  'button, select': {
    textTransform: 'none',
  },
  'button, html input[type="button"], input[type="reset"], input[type="submit"]': {
    webkitAppearance: 'button',
    cursor: 'pointer',
  },
  'button[disabled], html input[disabled]': {
    cursor: 'default',
  },
  'button::-moz-focus-inner, input::-moz-focus-inner': {
    border: 0,
    paddingTop: 0,
    paddingRight: 0,
    paddingBottom: 0,
    paddingLeft: 0,
  },
  input: {
    lineHeight: 'normal',
  },
  'input[type="checkbox"], input[type="radio"]': {
    boxSizing: 'border-box',
    paddingTop: 0,
    paddingRight: 0,
    paddingBottom: 0,
    paddingLeft: 0,
  },
  'input[type="number"]::-webkit-inner-spin-button, input[type="number"]::-webkit-outer-spin-button': {
    height: 'auto',
  },
  'input[type="search"]': {
    webkitAppearance: 'textfield',
    boxSizing: 'content-box',
  },
  'input[type="search"]::-webkit-search-cancel-button, input[type="search"]::-webkit-search-decoration': {
    webkitAppearance: 'none',
  },
  fieldset: {
    border: '1px solid #c0c0c0',
    marginTop: 0,
    marginRight: '2px',
    marginBottom: 0,
    marginLeft: '2px',
    paddingTop: '0.35em',
    paddingRight: '0.625em',
    paddingLeft: '0.625em',
    paddingBottom: '0.75em',
  },
  legend: {
    border: 0,
    paddingTop: 0,
    paddingRight: 0,
    paddingBottom: 0,
    paddingLeft: 0,
  },
  textarea: {
    overflow: 'auto',
  },
  optgroup: {
    fontWeight: 'bold',
  },
  table: {
    borderCollapse: 'collapse',
    borderSpacing: 0,
  },
  'td, th': {
    paddingTop: 0,
    paddingRight: 0,
    paddingBottom: 0,
    paddingLeft: 0,
  },
}
