<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
  <meta charset=utf-8/>
  <meta name="generator" content="InnoShop {{ innoshop_version() }}">
  <title>@yield('title')</title>
  <style>
      body {
          background-color: #fff0f4;
          font-family: 'Open Sans', sans-serif;
          font-size: 14px;
          color: #3c3c3c;
      }

      .demo p:first-child {
          text-align: center;
          font-family: cursive;
          font-size: 150px;
          font-weight: bold;
          line-height: 100px;
          letter-spacing: 5px;
          color: #fff;
      }

      .demo p:first-child span {
          cursor: pointer;
          text-shadow: 0px 0px 2px #686868,
          0px 1px 1px #ddd,
          0px 2px 1px #d6d6d6,
          0px 3px 1px #ccc,
          0px 4px 1px #c5c5c5,
          0px 5px 1px #c1c1c1,
          0px 6px 1px #bbb,
          0px 7px 1px #777,
          0px 8px 3px rgba(100, 100, 100, 0.4),
          0px 9px 5px rgba(100, 100, 100, 0.1),
          0px 10px 7px rgba(100, 100, 100, 0.15),
          0px 11px 9px rgba(100, 100, 100, 0.2),
          0px 12px 11px rgba(100, 100, 100, 0.25),
          0px 13px 15px rgba(100, 100, 100, 0.3);
          -webkit-transition: all .1s linear;
          transition: all .1s linear;
      }

      .demo p:first-child span:hover {
          text-shadow: 0px 0px 2px #686868,
          0px 1px 1px #fff,
          0px 2px 1px #fff,
          0px 3px 1px #fff,
          0px 4px 1px #fff,
          0px 5px 1px #fff,
          0px 6px 1px #fff,
          0px 7px 1px #777,
          0px 8px 3px #fff,
          0px 9px 5px #fff,
          0px 10px 7px #fff,
          0px 11px 9px #fff,
          0px 12px 11px #fff,
          0px 13px 15px #fff;
          -webkit-transition: all .1s linear;
          transition: all .1s linear;
      }

      .demo p:not(:first-child) {
          text-align: center;
          color: #666;
          font-family: cursive;
          font-size: 20px;
          text-shadow: 0 1px 0 #fff;
          letter-spacing: 1px;
          line-height: 2em;
          margin-top: -50px;
      }

      .btn-back-home {
          display: block;
          width: 120px;
          height: 34px;
          line-height: 34px;
          text-align: center;
          background: #E91E63;
          color: #fff;
          text-decoration: none;
          border-radius: 5px;
          margin: 20px auto;
          box-shadow: 0 5px 0 #ad1457;
      }

      .btn-back-home:hover {
          background: #ad1457;
      }

      .btn-back-home:active {
          box-shadow: none;
          transform: translateY(5px);
      }
  </style>
</head>
<body>
<div class="demo">
  {{--@yield('code')--}}
  @php
    $status = \Illuminate\Support\Facades\View::getSection('code');
    $digits = str_split($status);
  @endphp

  <p>
    @foreach($digits as $digit)<span>{{ $digit }}</span>@endforeach
  </p>

  <p>@yield('message')</p>
  <a href="javascript:history.back()" class="btn-back-home">{{ __('front/common.back_page') }}</a>
</div>
</body>
</html>