<?php
/**
 * Copyright (c) Since 2024 InnoShop - All Rights Reserved
 *
 * @link       https://www.innoshop.com
 * @author     InnoShop <team@innoshop.com>
 * @license    https://opensource.org/licenses/OSL-3.0 Open Software License (OSL 3.0)
 */

return [
    'accepted'        => '您必須接受 :attribute。',
    'accepted_if'     => '當 :other 為 :value 時，必須接受 :attribute。',
    'active_url'      => ':attribute 不係一個有效嘅網址。',
    'after'           => ':attribute 必須要晚過 :date。',
    'after_or_equal'  => ':attribute 必須要等於 :date 或更晚。',
    'alpha'           => ':attribute 只可以由字母組成。',
    'alpha_dash'      => ':attribute 只可以由字母、數字、短划線(-)同埋下划線(_)組成。',
    'alpha_num'       => ':attribute 只可以由字母同數字組成。',
    'array'           => ':attribute 必須係一個陣列。',
    'before'          => ':attribute 必須要早過 :date。',
    'before_or_equal' => ':attribute 必須要等於 :date 或更早。',
    'between'         => [
        'array'   => ':attribute 必須只有 :min - :max 個單元。',
        'file'    => ':attribute 必須介於 :min - :max KB 之間。',
        'numeric' => ':attribute 必須介於 :min - :max 之間。',
        'string'  => ':attribute 必須介於 :min - :max 個字符之間。',
    ],
    'boolean'          => ':attribute 必須為布林值。',
    'confirmed'        => ':attribute 兩次輸入唔一致。',
    'current_password' => '密碼錯誤。',
    'date'             => ':attribute 不係一個有效嘅日期。',
    'date_equals'      => ':attribute 必須等於 :date。',
    'date_format'      => ':attribute 嘅格式必須為 :format。',
    'declined'         => ':attribute 必須係拒絕嘅。',
    'declined_if'      => '當 :other 為 :value 時字段 :attribute 必須係拒絕嘅。',
    'different'        => ':attribute 同 :other 必須唔同。',
    'digits'           => ':attribute 必須係 :digits 位數字。',
    'digits_between'   => ':attribute 必須係介於 :min 同 :max 位嘅數字。',
    'dimensions'       => ':attribute 嘅圖片尺寸唔正確。',
    'distinct'         => ':attribute 已經存在。',
    'email'            => ':attribute 不係一個合法嘅電郵。',
    'ends_with'        => ':attribute 必須以 :values 為結尾。',
    'enum'             => ':attribute 嘅值唔正確。',
    'exists'           => ':attribute 唔存在。',
    'file'             => ':attribute 必須係檔案。',
    'filled'           => ':attribute 不能為空。',
    'gt'               => [
        'array'   => ':attribute 必須多過 :value 個元素。',
        'file'    => ':attribute 必須大過 :value KB。',
        'numeric' => ':attribute 必須大過 :value。',
        'string'  => ':attribute 必須多過 :value 個字符。',
    ],
    'gte' => [
        'array'   => ':attribute 必須多過或等於 :value 個元素。',
        'file'    => ':attribute 必須大過或等於 :value KB。',
        'numeric' => ':attribute 必須大過或等於 :value。',
        'string'  => ':attribute 必須多過或等於 :value 個字符。',
    ],
    'image'    => ':attribute 必須係圖片。',
    'in'       => '已選嘅屬性 :attribute 唔合法。',
    'in_array' => ':attribute 必須喺 :other 之中。',
    'integer'  => ':attribute 必須係整數。',
    'ip'       => ':attribute 必須係有效嘅 IP 地址。',
    'ipv4'     => ':attribute 必須係有效嘅 IPv4 地址。',
    'ipv6'     => ':attribute 必須係有效嘅 IPv6 地址。',
    'json'     => ':attribute 必須係正確嘅 JSON 格式。',
    'lt'       => [
        'array'   => ':attribute 必須少過 :value 個元素。',
        'file'    => ':attribute 必須細過 :value KB。',
        'numeric' => ':attribute 必須細過 :value。',
        'string'  => ':attribute 必須少過 :value 個字符。',
    ],
    'lte' => [
        'array'   => ':attribute 必須少過或等於 :value 個元素。',
        'file'    => ':attribute 必須細過或等於 :value KB。',
        'numeric' => ':attribute 必須細過或等於 :value。',
        'string'  => ':attribute 必須少過或等於 :value 個字符。',
    ],
    'mac_address' => ':attribute 必須係一個有效嘅 MAC 地址。',
    'max'         => [
        'array'   => ':attribute 最多只有 :max 個單元。',
        'file'    => ':attribute 不能大過 :max KB。',
        'numeric' => ':attribute 不能大過 :max。',
        'string'  => ':attribute 不能大過 :max 個字符。',
    ],
    'mimes'     => ':attribute 必須係一個 :values 類型嘅檔案。',
    'mimetypes' => ':attribute 必須係一個 :values 類型嘅檔案。',
    'min'       => [
        'array'   => ':attribute 至少有 :min 個單元。',
        'file'    => ':attribute 大小不能細過 :min KB。',
        'numeric' => ':attribute 必須大於等於 :min。',
        'string'  => ':attribute 至少為 :min 個字符。',
    ],
    'multiple_of'          => ':attribute 必須係 :value 之中嘅多個值。',
    'not_in'               => '已選嘅屬性 :attribute 非法。',
    'not_regex'            => ':attribute 嘅格式錯誤。',
    'numeric'              => ':attribute 必須係一個數字。',
    'password'             => '密碼錯誤',
    'present'              => ':attribute 必須存在。',
    'prohibited'           => ':attribute 欄位被禁止。',
    'prohibited_if'        => '當 :other 為 :value 時，禁止 :attribute 欄位。',
    'prohibited_unless'    => ':attribute 欄位被禁止，除非 :other 位於 :values 中。',
    'prohibits'            => ':attribute 欄位禁止出現 :other。',
    'regex'                => ':attribute 格式唔正確。',
    'required'             => ':attribute 不能為空。',
    'required_array_keys'  => ':attribute 至少包含指定嘅鍵：:values.',
    'required_if'          => '當 :other 為 :value 時 :attribute 不能為空。',
    'required_unless'      => '當 :other 不係 :values 時 :attribute 不能為空。',
    'required_with'        => '當 :values 存在時 :attribute 不能為空。',
    'required_with_all'    => '當 :values 存在時 :attribute 不能為空。',
    'required_without'     => '當 :values 不存在時 :attribute 不能為空。',
    'required_without_all' => '當 :values 都唔存在時 :attribute 不能為空。',
    'same'                 => ':attribute 同 :other 必須相同。',
    'size'                 => [
        'array'   => ':attribute 必須係 :size 個單元。',
        'file'    => ':attribute大小必須係 :size KB。',
        'numeric' => ':attribute 大小必須係 :size。',
        'string'  => ':attribute 必須係 :size 個字符。',
    ],
    'starts_with' => ':attribute 必須以 :values 為開頭。',
    'string'      => ':attribute 必須係一個字符串。',
    'timezone'    => ':attribute 必須係一個合法嘅時區值。',
    'unique'      => ':attribute 已經存在。',
    'uploaded'    => ':attribute 上傳失敗。',
    'url'         => ':attribute 格式唔正確。',
    'uuid'        => ':attribute 必須係有效嘅 UUID。',
    'custom'      => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],
];
