<?php
/**
 * Copyright (c) Since 2024 InnoShop - All Rights Reserved
 *
 * @link       https://www.innoshop.com
 * @author     InnoShop <team@innoshop.com>
 * @license    https://opensource.org/licenses/OSL-3.0 Open Software License (OSL 3.0)
 */

return [
    'accepted'        => 'Вы должны принять :attribute.',
    'accepted_if'     => 'Необходимо принять :attribute, если :other равно :value.',
    'active_url'      => ':attribute не является действительным URL.',
    'after'           => ':attribute должен быть после :date.',
    'after_or_equal'  => ':attribute должен быть после :date или равен ему.',
    'alpha'           => ':attribute может содержать только буквы.',
    'alpha_dash'      => ':attribute может содержать только буквы, цифры и символы "-", "_".',
    'alpha_num'       => ':attribute может содержать только буквы и цифры.',
    'array'           => ':attribute должен быть массивом.',
    'before'          => ':attribute должен быть до :date.',
    'before_or_equal' => ':attribute должен быть до :date или равен ему.',
    'between'         => [
        'array'   => ':attribute должен содержать от :min до :max элементов.',
        'file'    => ':attribute должен быть размером от :min до :max КБ.',
        'numeric' => ':attribute должен быть от :min до :max.',
        'string'  => ':attribute должен содержать от :min до :max символов.',
    ],
    'boolean'          => ':attribute должен быть логическим значением (истина или ложь).',
    'confirmed'        => 'Поле :attribute не совпадает с подтверждением.',
    'current_password' => 'Указанный пароль некорректный.',
    'date'             => ':attribute не является корректной датой.',
    'date_equals'      => ':attribute должен быть равен :date.',
    'date_format'      => 'Формат :attribute должен соответствовать :format.',
    'declined'         => 'Поле :attribute должно быть отклонено.',
    'declined_if'      => 'Поле :attribute должно быть отклонено, если :other равно :value.',
    'different'        => ':attribute и :other должны быть разными.',
    'digits'           => ':attribute должен быть в диапазоне от :digits цифр.',
    'digits_between'   => ':attribute должен быть в диапазоне от :min до :max цифр.',
    'dimensions'       => 'Изображение :attribute имеет некорректные размеры.',
    'distinct'         => 'Поле :attribute должно быть уникальным.',
    'email'            => ':attribute не является корректным электронным адресом.',
    'ends_with'        => ':attribute должен заканчиваться одним из следующих значений: :values.',
    'enum'             => 'Выбранное значение :attribute некорректно.',
    'exists'           => ':attribute не существует.',
    'file'             => ':attribute должен быть файлом.',
    'filled'           => ':attribute обязательно для заполнения.',
    'gt'               => [
        'array'   => ':attribute должен иметь больше :value элементов.',
        'file'    => ':attribute должен быть больше :value КБ.',
        'numeric' => ':attribute должен быть больше :value.',
        'string'  => ':attribute должен содержать больше :value символов.',
    ],
    'gte' => [
        'array'   => ':attribute должен иметь :value или больше элементов.',
        'file'    => ':attribute должен быть размером :value КБ или больше.',
        'numeric' => ':attribute должен быть :value или больше.',
        'string'  => ':attribute должен содержать :value или больше символов.',
    ],
    'image'    => ':attribute должен быть изображением.',
    'in'       => 'Выбранное значение :attribute некорректно.',
    'in_array' => ':attribute должно присутствовать в :other.',
    'integer'  => ':attribute должен быть целым числом.',
    'ip'       => ':attribute должен быть корректным IP-адресом.',
    'ipv4'     => ':attribute должен быть корректным IPv4-адресом.',
    'ipv6'     => ':attribute должен быть корректным IPv6-адресом.',
    'json'     => ':attribute должен быть корректным JSON-форматом.',
    'lt'       => [
        'array'   => ':attribute должен иметь меньше :value элементов.',
        'file'    => ':attribute должен быть меньше :value КБ.',
        'numeric' => ':attribute должен быть меньше :value.',
        'string'  => ':attribute должен содержать меньше :value символов.',
    ],
    'lte' => [
        'array'   => ':attribute должен иметь :value или меньше элементов.',
        'file'    => ':attribute должен быть размером :value КБ или меньше.',
        'numeric' => ':attribute должен быть :value или меньше.',
        'string'  => ':attribute должен содержать :value или меньше символов.',
    ],
    'mac_address' => ':attribute должен быть корректным MAC-адресом.',
    'max'         => [
        'array'   => ':attribute может содержать не более :max элементов.',
        'file'    => ':attribute не должен быть размером более :max КБ.',
        'numeric' => ':attribute не должен быть больше :max.',
        'string'  => ':attribute не должен содержать более :max символов.',
    ],
    'mimes'     => ':attribute должен быть файлом одного из следующих типов: :values.',
    'mimetypes' => ':attribute должен быть файлом одного из следующих типов: :values.',
    'min'       => [
        'array'   => ':attribute должен содержать не менее :min элементов.',
        'file'    => ':attribute должен быть размером не менее :min КБ.',
        'numeric' => ':attribute должен быть не менее :min.',
        'string'  => ':attribute должен содержать не менее :min символов.',
    ],
    'multiple_of'          => ':attribute должен быть кратным :value.',
    'not_in'               => 'Выбранное значение :attribute некорректно.',
    'not_regex'            => 'Формат :attribute некорректен.',
    'numeric'              => ':attribute должен быть числом.',
    'password'             => 'Неправильный пароль.',
    'present'              => ':attribute должен присутствовать.',
    'prohibited'           => ':attribute запрещен.',
    'prohibited_if'        => ':attribute запрещен, если :other равен :value.',
    'prohibited_unless'    => ':attribute запрещен, если :other не находится в :values.',
    'prohibits'            => ':attribute запрещает наличие :other.',
    'regex'                => 'Формат :attribute некорректен.',
    'required'             => ':attribute обязательно для заполнения.',
    'required_array_keys'  => 'Массив :attribute должен содержать ключи: :values.',
    'required_if'          => 'Поле :attribute обязательно для заполнения, если :other равно :value.',
    'required_unless'      => 'Поле :attribute обязательно для заполнения, если :other не равно :values.',
    'required_with'        => 'Поле :attribute обязательно для заполнения, если :values указано.',
    'required_with_all'    => 'Поле :attribute обязательно для заполнения, если :values указано.',
    'required_without'     => 'Поле :attribute обязательно для заполнения, если :values не указано.',
    'required_without_all' => 'Поле :attribute обязательно для заполнения, если ни одно из :values не указано.',
    'same'                 => ':attribute и :other должны совпадать.',
    'size'                 => [
        'array'   => ':attribute должен содержать ровно :size элементов.',
        'file'    => 'Размер :attribute должен быть ровно :size КБ.',
        'numeric' => 'Значение :attribute должно быть ровно :size.',
        'string'  => ':attribute должен содержать ровно :size символов.',
    ],
    'starts_with' => ':attribute должен начинаться с одного из следующих значений: :values.',
    'string'      => ':attribute должен быть строкой.',
    'timezone'    => ':attribute должен быть корректным часовым поясом.',
    'unique'      => ':attribute уже занят.',
    'uploaded'    => ':attribute не был загружен.',
    'url'         => 'Формат :attribute некорректен.',
    'uuid'        => ':attribute должен быть корректным UUID.',
    'custom'      => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],
];
