<?php
/**
 * Copyright (c) Since 2024 InnoShop - All Rights Reserved
 *
 * @link       https://www.innoshop.com
 * @author     InnoShop <team@innoshop.com>
 * @license    https://opensource.org/licenses/OSL-3.0 Open Software License (OSL 3.0)
 */

return [
    'accepted'        => 'Você deve aceitar :attribute.',
    'accepted_if'     => 'Você deve aceitar :attribute quando :other for :value.',
    'active_url'      => ':attribute não é um site válido.',
    'after'           => ':attribute deve ser posterior a :date.',
    'after_or_equal'  => ':attribute deve ser igual ou posterior a :date.',
    'alpha'           => ':attribute deve conter apenas letras.',
    'alpha_dash'      => ':attribute deve conter apenas letras, números, traços e sublinhados.',
    'alpha_num'       => ':attribute deve conter apenas letras e números.',
    'array'           => ':attribute deve ser uma matriz.',
    'before'          => ':attribute deve ser anterior a :date.',
    'before_or_equal' => ':attribute deve ser igual ou anterior a :date.',
    'between'         => [
        'array'   => ':attribute deve ter entre :min e :max itens.',
        'file'    => ':attribute deve ter entre :min e :max KB.',
        'numeric' => ':attribute deve estar entre :min e :max.',
        'string'  => ':attribute deve ter entre :min e :max caracteres.',
    ],
    'boolean'          => ':attribute deve ser verdadeiro ou falso.',
    'confirmed'        => ':attribute não coincide.',
    'current_password' => 'Senha incorreta.',
    'date'             => ':attribute não é uma data válida.',
    'date_equals'      => ':attribute deve ser igual a :date.',
    'date_format'      => ':attribute deve estar no formato :format.',
    'declined'         => ':attribute deve ser recusado.',
    'declined_if'      => 'O campo :attribute deve ser recusado quando :other for :value.',
    'different'        => ':attribute e :other devem ser diferentes.',
    'digits'           => ':attribute deve ter :digits dígitos.',
    'digits_between'   => ':attribute deve ter entre :min e :max dígitos.',
    'dimensions'       => 'As dimensões da imagem :attribute são inválidas.',
    'distinct'         => ':attribute já existe.',
    'email'            => ':attribute não é um e-mail válido.',
    'ends_with'        => ':attribute deve terminar com um dos seguintes valores: :values.',
    'enum'             => 'O valor selecionado para :attribute é inválido.',
    'exists'           => ':attribute não existe.',
    'file'             => ':attribute deve ser um arquivo.',
    'filled'           => ':attribute não pode estar vazio.',
    'gt'               => [
        'array'   => ':attribute deve ter mais do que :value itens.',
        'file'    => ':attribute deve ser maior que :value KB.',
        'numeric' => ':attribute deve ser maior que :value.',
        'string'  => ':attribute deve ter mais do que :value caracteres.',
    ],
    'gte' => [
        'array'   => ':attribute deve ter :value itens ou mais.',
        'file'    => ':attribute deve ser maior ou igual a :value KB.',
        'numeric' => ':attribute deve ser maior ou igual a :value.',
        'string'  => ':attribute deve ter :value caracteres ou mais.',
    ],
    'image'    => ':attribute deve ser uma imagem.',
    'in'       => 'O valor selecionado para :attribute é inválido.',
    'in_array' => ':attribute deve estar em :other.',
    'integer'  => ':attribute deve ser um número inteiro.',
    'ip'       => ':attribute deve ser um endereço IP válido.',
    'ipv4'     => ':attribute deve ser um endereço IPv4 válido.',
    'ipv6'     => ':attribute deve ser um endereço IPv6 válido.',
    'json'     => ':attribute deve ser um JSON válido.',
    'lt'       => [
        'array'   => ':attribute deve ter menos do que :value itens.',
        'file'    => ':attribute deve ser menor que :value KB.',
        'numeric' => ':attribute deve ser menor que :value.',
        'string'  => ':attribute deve ter menos do que :value caracteres.',
    ],
    'lte' => [
        'array'   => ':attribute deve ter :value itens ou menos.',
        'file'    => ':attribute deve ser menor ou igual a :value KB.',
        'numeric' => ':attribute deve ser menor ou igual a :value.',
        'string'  => ':attribute deve ter :value caracteres ou menos.',
    ],
    'mac_address' => ':attribute deve ser um endereço MAC válido.',
    'max'         => [
        'array'   => ':attribute deve ter no máximo :max itens.',
        'file'    => ':attribute não deve ser maior que :max KB.',
        'numeric' => ':attribute não deve ser maior que :max.',
        'string'  => ':attribute não deve ter mais de :max caracteres.',
    ],
    'mimes'     => ':attribute deve ser um arquivo do tipo :values.',
    'mimetypes' => ':attribute deve ser um arquivo do tipo :values.',
    'min'       => [
        'array'   => ':attribute deve ter no mínimo :min itens.',
        'file'    => ':attribute deve ter no mínimo :min KB.',
        'numeric' => ':attribute deve ser :min ou mais.',
        'string'  => ':attribute deve ter no mínimo :min caracteres.',
    ],
    'multiple_of'          => ':attribute deve ser um múltiplo de :value.',
    'not_in'               => 'O valor selecionado para :attribute é inválido.',
    'not_regex'            => 'O formato de :attribute é inválido.',
    'numeric'              => ':attribute deve ser um número.',
    'password'             => 'Senha incorreta',
    'present'              => ':attribute deve estar presente.',
    'prohibited'           => 'O campo :attribute é proibido.',
    'prohibited_if'        => 'O campo :attribute é proibido quando :other for :value.',
    'prohibited_unless'    => 'O campo :attribute é proibido, a menos que :other esteja em :values.',
    'prohibits'            => 'O campo :attribute proíbe :other de estar presente.',
    'regex'                => 'O formato de :attribute é inválido.',
    'required'             => ':attribute é obrigatório.',
    'required_array_keys'  => ':attribute deve conter as chaves: :values.',
    'required_if'          => 'O campo :attribute é obrigatório quando :other for :value.',
    'required_unless'      => 'O campo :attribute é obrigatório a menos que :other esteja em :values.',
    'required_with'        => 'O campo :attribute é obrigatório quando :values estiver presente.',
    'required_with_all'    => 'O campo :attribute é obrigatório quando :values estiverem presentes.',
    'required_without'     => 'O campo :attribute é obrigatório quando :values não estiver presente.',
    'required_without_all' => 'O campo :attribute é obrigatório quando nenhum dos :values estiverem presentes.',
    'same'                 => ':attribute e :other devem ser iguais.',
    'size'                 => [
        'array'   => ':attribute deve ter :size itens.',
        'file'    => ':attribute deve ter :size KB.',
        'numeric' => ':attribute deve ser :size.',
        'string'  => ':attribute deve ter :size caracteres.',
    ],
    'starts_with' => ':attribute deve começar com um dos seguintes valores: :values.',
    'string'      => ':attribute deve ser uma string.',
    'timezone'    => ':attribute deve ser um fuso horário válido.',
    'unique'      => ':attribute já está em uso.',
    'uploaded'    => ':attribute falha ao ser enviado.',
    'url'         => 'O formato de :attribute é inválido.',
    'uuid'        => ':attribute deve ser um UUID válido.',
    'custom'      => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],

];
