<?php
/**
 * Copyright (c) Since 2024 InnoShop - All Rights Reserved
 *
 * @link       https://www.innoshop.com
 * @author     InnoShop <team@innoshop.com>
 * @license    https://opensource.org/licenses/OSL-3.0 Open Software License (OSL 3.0)
 */

return [
    'accepted'        => ':attribute을 반드시 승인해야 합니다.',
    'accepted_if'     => ':other이 :value일 때 :attribute을 반드시 승인해야 합니다.',
    'active_url'      => ':attribute은 유효한 URL이 아닙니다.',
    'after'           => ':attribute은 :date보다 이후 날짜여야 합니다.',
    'after_or_equal'  => ':attribute은 :date 보다 같거나 이후 날짜여야 합니다.',
    'alpha'           => ':attribute은 알파벳만 포함할 수 있습니다.',
    'alpha_dash'      => ':attribute은 알파벳, 숫자, 대시(-), 밑줄(_)만 포함할 수 있습니다.',
    'alpha_num'       => ':attribute은 알파벳과 숫자만 포함할 수 있습니다.',
    'array'           => ':attribute은 배열이어야 합니다.',
    'before'          => ':attribute은 :date보다 이전 날짜여야 합니다.',
    'before_or_equal' => ':attribute은 :date 보다 같거나 이전 날짜여야 합니다.',
    'between'         => [
        'array'   => ':attribute은 :min - :max 개의 항목이 있어야 합니다.',
        'file'    => ':attribute은 :min - :max KB 사이이어야 합니다.',
        'numeric' => ':attribute은 :min - :max 사이이어야 합니다.',
        'string'  => ':attribute은 :min - :max 글자 사이이어야 합니다.',
    ],
    'boolean'          => ':attribute은 부울 값이어야 합니다.',
    'confirmed'        => ':attribute은 확인된 값과 일치해야 합니다.',
    'current_password' => '비밀번호가 틀렸습니다.',
    'date'             => ':attribute은 유효한 날짜가 아닙니다.',
    'date_equals'      => ':attribute은 :date와 같아야 합니다.',
    'date_format'      => ':attribute은 :format 형식을 가져야 합니다.',
    'declined'         => ':attribute은 거부되어야 합니다.',
    'declined_if'      => ':other가 :value 일 때 :attribute은 거부되어야 합니다.',
    'different'        => ':attribute과 :other은 달라야 합니다.',
    'digits'           => ':attribute은 :digits개의 숫자로 구성되어야 합니다.',
    'digits_between'   => ':attribute은 :min에서 :max개의 숫자로 구성되어야 합니다.',
    'dimensions'       => ':attribute은 올바른 이미지 크기를 가져야 합니다.',
    'distinct'         => ':attribute은 중복된 값이어서는 안됩니다.',
    'email'            => ':attribute은 유효한 이메일 주소가 아닙니다.',
    'ends_with'        => ':attribute은 :values 중 하나로 끝나야 합니다.',
    'enum'             => ':attribute에 잘못된 값이 있습니다.',
    'exists'           => ':attribute에 잘못된 값이 있습니다.',
    'file'             => ':attribute은 파일이어야 합니다.',
    'filled'           => ':attribute은 비워둘 수 없습니다.',
    'gt'               => [
        'array'   => ':attribute은 :value개보다 많아야 합니다.',
        'file'    => ':attribute은 :value KB보다 커야 합니다.',
        'numeric' => ':attribute은 :value보다 커야 합니다.',
        'string'  => ':attribute은 :value 글자보다 많아야 합니다.',
    ],
    'gte' => [
        'array'   => ':attribute은 :value개보다 많거나 같아야 합니다.',
        'file'    => ':attribute은 :value KB보다 크거나 같아야 합니다.',
        'numeric' => ':attribute은 :value보다 크거나 같아야 합니다.',
        'string'  => ':attribute은 :value 글자보다 많거나 같아야 합니다.',
    ],
    'image'    => ':attribute은 이미지 파일이어야 합니다.',
    'in'       => ':selected은 :attribute에 유효한 값이 아닙니다.',
    'in_array' => ':attribute은 :other에不存在해야 합니다.',
    'integer'  => ':attribute은 정수이어야 합니다.',
    'ip'       => ':attribute은 유효한 IP 주소이어야 합니다.',
    'ipv4'     => ':attribute은 유효한 IPv4 주소이어야 합니다.',
    'ipv6'     => ':attribute은 유효한 IPv6 주소이어야 합니다.',
    'json'     => ':attribute은 올바른 JSON 포맷이어야 합니다.',
    'lt'       => [
        'array'   => ':attribute은 :value개보다 작아야 합니다.',
        'file'    => ':attribute은 :value KB보다 작아야 합니다.',
        'numeric' => ':attribute은 :value보다 작아야 합니다.',
        'string'  => ':attribute은 :value 글자보다 적어야 합니다.',
    ],
    'lte' => [
        'array'   => ':attribute은 :value개보다 작거나 같아야 합니다.',
        'file'    => ':attribute은 :value KB보다 작거나 같아야 합니다.',
        'numeric' => ':attribute은 :value보다 작거나 같아야 합니다.',
        'string'  => ':attribute은 :value 글자보다 적거나 같아야 합니다.',
    ],
    'mac_address' => ':attribute은 유효한 MAC 주소이어야 합니다.',
    'max'         => [
        'array'   => ':attribute은 :max개의 항목을 넘을 수 없습니다.',
        'file'    => ':attribute은 :max KB를 넘을 수 없습니다.',
        'numeric' => ':attribute은 :max를 넘을 수 없습니다.',
        'string'  => ':attribute은 :max 글자를 넘을 수 없습니다.',
    ],
    'mimes'     => ':attribute은 :values 형식의 파일이어야 합니다.',
    'mimetypes' => ':attribute은 :values 형식의 파일이어야 합니다.',
    'min'       => [
        'array'   => ':attribute은 :min개의 항목이 필요합니다.',
        'file'    => ':attribute은 :min KB보다 커야 합니다.',
        'numeric' => ':attribute은 :min보다 커야 합니다.',
        'string'  => ':attribute은 :min자를 가져야 합니다.',
    ],
    'multiple_of'          => ':attribute은 :value의 다수이어야 합니다.',
    'not_in'               => ':selected :attribute 값이 유효하지 않습니다.',
    'not_regex'            => ':attribute의 형식이 잘못되었습니다.',
    'numeric'              => ':attribute은 숫자여야 합니다.',
    'password'             => '비밀번호가 틀렸습니다.',
    'present'              => ':attribute이 있어야 합니다.',
    'prohibited'           => ':attribute 필드는 금지되어 있습니다.',
    'prohibited_if'        => ':other이 :value 일 때 :attribute 필드는 금지되어 있습니다.',
    'prohibited_unless'    => ':attribute 필드는 :values에 있으면 금지되어 있습니다.',
    'prohibits'            => ':attribute 필드는 :other가 함께 사용되면 안됩니다.',
    'regex'                => ':attribute의 형식이 유효하지 않습니다.',
    'required'             => ':attribute을 입력해주세요.',
    'required_array_keys'  => ':attribute은 다음 키를 포함해야 합니다: :values.',
    'required_if'          => ':other이 :value일 때 :attribute을 입력해주세요.',
    'required_unless'      => ':other이 :values에 없을 때 :attribute을 입력해주세요.',
    'required_with'        => ':values이 있으면 :attribute을 입력해주세요.',
    'required_with_all'    => ':values이 있으면 :attribute을 입력해주세요.',
    'required_without'     => ':values이 없으면 :attribute을 입력해주세요.',
    'required_without_all' => ':values이 모두 없으면 :attribute을 입력해주세요.',
    'same'                 => ':attribute과 :other은 일치해야 합니다.',
    'size'                 => [
        'array'   => ':attribute은 :size개의 항목을 가져야 합니다.',
        'file'    => ':attribute은 :sizeKB여야 합니다.',
        'numeric' => ':attribute은 :size이어야 합니다.',
        'string'  => ':attribute은 :size자여야 합니다.',
    ],
    'starts_with' => ':attribute은 :values 중 하나로 시작해야 합니다.',
    'string'      => ':attribute은 문자열이어야 합니다.',
    'timezone'    => ':attribute은 유효한 시간대이어야 합니다.',
    'unique'      => ':attribute은 이미 존재합니다.',
    'uploaded'    => ':attribute을 업로드하지 못했습니다.',
    'url'         => ':attribute 형식이 유효하지 않습니다.',
    'uuid'        => ':attribute은 유효한 UUID이어야 합니다.',
    'custom'      => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],
];
