<?php
/**
 * Copyright (c) Since 2024 InnoShop - All Rights Reserved
 *
 * @link       https://www.innoshop.com
 * @author     InnoShop <team@innoshop.com>
 * @license    https://opensource.org/licenses/OSL-3.0 Open Software License (OSL 3.0)
 */

return [
    'accepted'        => 'Sie müssen :attribute akzeptieren.',
    'accepted_if'     => 'Sie müssen :attribute akzeptieren, wenn :other :value ist.',
    'active_url'      => ':attribute ist keine gültige URL.',
    'after'           => ':attribute muss nach dem :date liegen.',
    'after_or_equal'  => ':attribute muss gleich oder nach dem :date liegen.',
    'alpha'           => ':attribute darf nur Buchstaben enthalten.',
    'alpha_dash'      => ':attribute darf nur Buchstaben, Zahlen, Bindestriche und Unterstriche enthalten.',
    'alpha_num'       => ':attribute darf nur Buchstaben und Zahlen enthalten.',
    'array'           => ':attribute muss ein Array sein.',
    'before'          => ':attribute muss vor dem :date liegen.',
    'before_or_equal' => ':attribute muss gleich oder vor dem :date liegen.',
    'between'         => [
        'array'   => ':attribute muss zwischen :min und :max Elemente haben.',
        'file'    => ':attribute muss zwischen :min und :max KB groß sein.',
        'numeric' => ':attribute muss zwischen :min und :max liegen.',
        'string'  => ':attribute muss zwischen :min und :max Zeichen lang sein.',
    ],
    'boolean'          => ':attribute muss ein Boolescher Wert sein.',
    'confirmed'        => ':attribute stimmt nicht überein.',
    'current_password' => 'Passwort falsch.',
    'date'             => ':attribute ist kein gültiges Datum.',
    'date_equals'      => ':attribute muss gleich dem :date sein.',
    'date_format'      => ':attribute muss das Format :format haben.',
    'declined'         => ':attribute muss abgelehnt sein.',
    'declined_if'      => 'Wenn :other :value ist, muss :attribute abgelehnt sein.',
    'different'        => ':attribute und :other müssen unterschiedlich sein.',
    'digits'           => ':attribute muss :digits Stellen haben.',
    'digits_between'   => ':attribute muss zwischen :min und :max Stellen haben.',
    'dimensions'       => 'Die Abmessungen von :attribute sind nicht korrekt.',
    'distinct'         => ':attribute wurde bereits verwendet.',
    'email'            => ':attribute ist keine gültige E-Mail-Adresse.',
    'ends_with'        => ':attribute muss mit einem der folgenden Werte enden: :values.',
    'enum'             => 'Der gewählte Wert von :attribute ist nicht gültig.',
    'exists'           => 'Das ausgewählte :attribute existiert nicht.',
    'file'             => ':attribute muss eine Datei sein.',
    'filled'           => ':attribute darf nicht leer sein.',
    'gt'               => [
        'array'   => ':attribute muss mehr als :value Elemente haben.',
        'file'    => ':attribute muss größer als :value KB sein.',
        'numeric' => ':attribute muss größer als :value sein.',
        'string'  => ':attribute muss länger als :value Zeichen sein.',
    ],
    'gte' => [
        'array'   => ':attribute muss mindestens :value Elemente haben.',
        'file'    => ':attribute muss mindestens :value KB groß sein.',
        'numeric' => ':attribute muss mindestens :value sein.',
        'string'  => ':attribute muss mindestens :value Zeichen lang sein.',
    ],
    'image'    => ':attribute muss ein Bild sein.',
    'in'       => 'Das ausgewählte :attribute ist ungültig.',
    'in_array' => ':attribute muss in :other vorhanden sein.',
    'integer'  => ':attribute muss eine ganze Zahl sein.',
    'ip'       => ':attribute muss eine gültige IP-Adresse sein.',
    'ipv4'     => ':attribute muss eine gültige IPv4-Adresse sein.',
    'ipv6'     => ':attribute muss eine gültige IPv6-Adresse sein.',
    'json'     => ':attribute muss ein gültiger JSON-String sein.',
    'lt'       => [
        'array'   => ':attribute muss weniger als :value Elemente haben.',
        'file'    => ':attribute muss kleiner als :value KB sein.',
        'numeric' => ':attribute muss kleiner als :value sein.',
        'string'  => ':attribute muss kürzer als :value Zeichen sein.',
    ],
    'lte' => [
        'array'   => ':attribute muss maximal :value Elemente haben.',
        'file'    => ':attribute muss maximal :value KB groß sein.',
        'numeric' => ':attribute muss maximal :value sein.',
        'string'  => ':attribute muss maximal :value Zeichen lang sein.',
    ],
    'mac_address' => ':attribute muss eine gültige MAC-Adresse sein.',
    'max'         => [
        'array'   => ':attribute darf maximal :max Elemente haben.',
        'file'    => ':attribute darf maximal :max KB groß sein.',
        'numeric' => ':attribute darf maximal :max sein.',
        'string'  => ':attribute darf maximal :max Zeichen lang sein.',
    ],
    'mimes'     => ':attribute muss eine Datei des Typs :values sein.',
    'mimetypes' => ':attribute muss eine Datei des Typs :values sein.',
    'min'       => [
        'array'   => ':attribute muss mindestens :min Elemente haben.',
        'file'    => ':attribute muss mindestens :min KB groß sein.',
        'numeric' => ':attribute muss mindestens :min sein.',
        'string'  => ':attribute muss mindestens :min Zeichen lang sein.',
    ],
    'multiple_of'          => ':attribute muss eine Vielfache von :value sein.',
    'not_in'               => 'Das ausgewählte :attribute ist ungültig.',
    'not_regex'            => 'Das Format von :attribute ist ungültig.',
    'numeric'              => ':attribute muss eine Zahl sein.',
    'password'             => 'Passwort falsch',
    'present'              => ':attribute muss vorhanden sein.',
    'prohibited'           => 'Das :attribute Feld ist verboten.',
    'prohibited_if'        => 'Das :attribute Feld ist verboten, wenn :other :value ist.',
    'prohibited_unless'    => 'Das :attribute Feld ist verboten, außer :other ist in :values.',
    'prohibits'            => 'Das :attribute Feld verbietet :other.',
    'regex'                => 'Das Format von :attribute ist ungültig.',
    'required'             => ':attribute darf nicht leer sein.',
    'required_array_keys'  => ':attribute muss die folgenden Schlüssel enthalten: :values.',
    'required_if'          => 'Wenn :other :value ist, dann muss :attribute ausgefüllt sein.',
    'required_unless'      => 'Wenn :other nicht in :values enthalten ist, dann muss :attribute ausgefüllt sein.',
    'required_with'        => 'Wenn :values vorhanden ist, dann muss :attribute ausgefüllt sein.',
    'required_with_all'    => 'Wenn :values vorhanden ist, dann muss :attribute ausgefüllt sein.',
    'required_without'     => 'Wenn :values nicht vorhanden ist, dann muss :attribute ausgefüllt sein.',
    'required_without_all' => 'Wenn keines der :values vorhanden ist, dann muss :attribute ausgefüllt sein.',
    'same'                 => ':attribute und :other müssen übereinstimmen.',
    'size'                 => [
        'array'   => ':attribute muss :size Elemente haben.',
        'file'    => ':attribute muss :size KB groß sein.',
        'numeric' => ':attribute muss :size sein.',
        'string'  => ':attribute muss :size Zeichen lang sein.',
    ],
    'starts_with' => ':attribute muss mit einem der folgenden Werte beginnen: :values.',
    'string'      => ':attribute muss ein String sein.',
    'timezone'    => ':attribute muss eine gültige Zeitzone sein.',
    'unique'      => ':attribute wird bereits verwendet.',
    'uploaded'    => ':attribute konnte nicht hochgeladen werden.',
    'url'         => 'Das Format von :attribute ist ungültig.',
    'uuid'        => ':attribute muss eine gültige UUID sein.',
    'custom'      => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],
];
