<?php
/**
 * Copyright (c) Since 2024 InnoShop - All Rights Reserved
 *
 * @link       https://www.innoshop.com
 * @author     InnoShop <team@innoshop.com>
 * @license    https://opensource.org/licenses/OSL-3.0 Open Software License (OSL 3.0)
 */

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use InnoShop\Common\Models\Country;
use InnoShop\Common\Repositories\CountryRepo;

class CountrySeeder extends Seeder
{
    public function run(): void
    {
        $items = $this->getCountries();
        if ($items) {
            Country::query()->truncate();
            CountryRepo::getInstance()->createMany($items);
        }
    }

    /**
     * @return array[]
     */
    private function getCountries(): array
    {
        return [
            ['name' => 'Algeria', 'code' => 'DZ', 'continent' => 'Africa'],
            ['name' => 'Angola', 'code' => 'AO', 'continent' => 'Africa'],
            ['name' => 'Benin', 'code' => 'BJ', 'continent' => 'Africa'],
            ['name' => 'Botswana', 'code' => 'BW', 'continent' => 'Africa'],
            ['name' => 'Burkina Faso', 'code' => 'BF', 'continent' => 'Africa'],
            ['name' => 'Burundi', 'code' => 'BI', 'continent' => 'Africa'],
            ['name' => 'Cabo Verde', 'code' => 'CV', 'continent' => 'Africa'],
            ['name' => 'Cameroon', 'code' => 'CM', 'continent' => 'Africa'],
            ['name' => 'Central African Republic (the)', 'code' => 'CF', 'continent' => 'Africa'],
            ['name' => 'Chad', 'code' => 'TD', 'continent' => 'Africa'],
            ['name' => 'Comoros (the)', 'code' => 'KM', 'continent' => 'Africa'],
            ['name' => 'Congo (the Democratic Republic of the)', 'code' => 'CD', 'continent' => 'Africa'],
            ['name' => 'Congo (the)', 'code' => 'CG', 'continent' => 'Africa'],
            ['name' => "Côte d'Ivoire", 'code' => 'CI', 'continent' => 'Africa'],
            ['name' => 'Djibouti', 'code' => 'DJ', 'continent' => 'Africa'],
            ['name' => 'Egypt', 'code' => 'EG', 'continent' => 'Africa'],
            ['name' => 'Equatorial Guinea', 'code' => 'GQ', 'continent' => 'Africa'],
            ['name' => 'Eritrea', 'code' => 'ER', 'continent' => 'Africa'],
            ['name' => 'Eswatini', 'code' => 'SZ', 'continent' => 'Africa'],
            ['name' => 'Ethiopia', 'code' => 'ET', 'continent' => 'Africa'],
            ['name' => 'Gabon', 'code' => 'GA', 'continent' => 'Africa'],
            ['name' => 'Gambia (the)', 'code' => 'GM', 'continent' => 'Africa'],
            ['name' => 'Ghana', 'code' => 'GH', 'continent' => 'Africa'],
            ['name' => 'Guinea', 'code' => 'GN', 'continent' => 'Africa'],
            ['name' => 'Guinea-Bissau', 'code' => 'GW', 'continent' => 'Africa'],
            ['name' => 'Kenya', 'code' => 'KE', 'continent' => 'Africa'],
            ['name' => 'Lesotho', 'code' => 'LS', 'continent' => 'Africa'],
            ['name' => 'Liberia', 'code' => 'LR', 'continent' => 'Africa'],
            ['name' => 'Libya', 'code' => 'LY', 'continent' => 'Africa'],
            ['name' => 'Madagascar', 'code' => 'MG', 'continent' => 'Africa'],
            ['name' => 'Malawi', 'code' => 'MW', 'continent' => 'Africa'],
            ['name' => 'Mali', 'code' => 'ML', 'continent' => 'Africa'],
            ['name' => 'Mauritania', 'code' => 'MR', 'continent' => 'Africa'],
            ['name' => 'Mauritius', 'code' => 'MU', 'continent' => 'Africa'],
            ['name' => 'Mayotte', 'code' => 'YT', 'continent' => 'Africa'],
            ['name' => 'Morocco', 'code' => 'MA', 'continent' => 'Africa'],
            ['name' => 'Mozambique', 'code' => 'MZ', 'continent' => 'Africa'],
            ['name' => 'Namibia', 'code' => 'NA', 'continent' => 'Africa'],
            ['name' => 'Niger (the)', 'code' => 'NE', 'continent' => 'Africa'],
            ['name' => 'Nigeria', 'code' => 'NG', 'continent' => 'Africa'],
            ['name' => 'Réunion', 'code' => 'RE', 'continent' => 'Africa'],
            ['name' => 'Rwanda', 'code' => 'RW', 'continent' => 'Africa'],
            ['name' => 'Saint Helena, Ascension and Tristan da Cunha', 'code' => 'SH', 'continent' => 'Africa'],
            ['name' => 'Sao Tome and Principe', 'code' => 'ST', 'continent' => 'Africa'],
            ['name' => 'Senegal', 'code' => 'SN', 'continent' => 'Africa'],
            ['name' => 'Seychelles', 'code' => 'SC', 'continent' => 'Africa'],
            ['name' => 'Sierra Leone', 'code' => 'SL', 'continent' => 'Africa'],
            ['name' => 'Somalia', 'code' => 'SO', 'continent' => 'Africa'],
            ['name' => 'South Africa', 'code' => 'ZA', 'continent' => 'Africa'],
            ['name' => 'South Sudan', 'code' => 'SS', 'continent' => 'Africa'],
            ['name' => 'Sudan (the)', 'code' => 'SD', 'continent' => 'Africa'],
            ['name' => 'Tanzania, the United Republic of', 'code' => 'TZ', 'continent' => 'Africa'],
            ['name' => 'Togo', 'code' => 'TG', 'continent' => 'Africa'],
            ['name' => 'Tunisia', 'code' => 'TN', 'continent' => 'Africa'],
            ['name' => 'Uganda', 'code' => 'UG', 'continent' => 'Africa'],
            ['name' => 'Western Sahara*', 'code' => 'EH', 'continent' => 'Africa'],
            ['name' => 'Zambia', 'code' => 'ZM', 'continent' => 'Africa'],
            ['name' => 'Zimbabwe', 'code' => 'ZW', 'continent' => 'Africa'],
            ['name' => 'Antarctica', 'code' => 'AQ', 'continent' => 'Antarctic'],
            ['name' => 'Bouvet Island', 'code' => 'BV', 'continent' => 'Antarctic'],
            ['name' => 'French Southern Territories (the)', 'code' => 'TF', 'continent' => 'Antarctic'],
            ['name' => 'Heard Island and McDonald Islands', 'code' => 'HM', 'continent' => 'Antarctic'],
            ['name' => 'South Georgia and the South Sandwich Islands', 'code' => 'GS', 'continent' => 'Antarctic'],
            ['name' => 'Afghanistan', 'code' => 'AF', 'continent' => 'Asia'],
            ['name' => 'Armenia', 'code' => 'AM', 'continent' => 'Asia'],
            ['name' => 'Azerbaijan', 'code' => 'AZ', 'continent' => 'Asia'],
            ['name' => 'Bangladesh', 'code' => 'BD', 'continent' => 'Asia'],
            ['name' => 'Bhutan', 'code' => 'BT', 'continent' => 'Asia'],
            ['name' => 'British Indian Ocean Territory (the)', 'code' => 'IO', 'continent' => 'Asia'],
            ['name' => 'Brunei Darussalam', 'code' => 'BN', 'continent' => 'Asia'],
            ['name' => 'Cambodia', 'code' => 'KH', 'continent' => 'Asia'],
            ['name' => 'China', 'code' => 'CN', 'continent' => 'Asia'],
            ['name' => 'Georgia', 'code' => 'GE', 'continent' => 'Asia'],
            ['name' => 'Hong Kong', 'code' => 'HK', 'continent' => 'Asia'],
            ['name' => 'India', 'code' => 'IN', 'continent' => 'Asia'],
            ['name' => 'Indonesia', 'code' => 'ID', 'continent' => 'Asia'],
            ['name' => 'Japan', 'code' => 'JP', 'continent' => 'Asia'],
            ['name' => 'Kazakhstan', 'code' => 'KZ', 'continent' => 'Asia'],
            ['name' => "Korea (the Democratic People's Republic of)", 'code' => 'KP', 'continent' => 'Asia'],
            ['name' => 'Korea (the Republic of)', 'code' => 'KR', 'continent' => 'Asia'],
            ['name' => 'Kyrgyzstan', 'code' => 'KG', 'continent' => 'Asia'],
            ['name' => "Lao People's Democratic Republic (the)", 'code' => 'LA', 'continent' => 'Asia'],
            ['name' => 'Macao', 'code' => 'MO', 'continent' => 'Asia'],
            ['name' => 'Malaysia', 'code' => 'MY', 'continent' => 'Asia'],
            ['name' => 'Maldives', 'code' => 'MV', 'continent' => 'Asia'],
            ['name' => 'Mongolia', 'code' => 'MN', 'continent' => 'Asia'],
            ['name' => 'Myanmar', 'code' => 'MM', 'continent' => 'Asia'],
            ['name' => 'Nepal', 'code' => 'NP', 'continent' => 'Asia'],
            ['name' => 'Pakistan', 'code' => 'PK', 'continent' => 'Asia'],
            ['name' => 'Philippines (the)', 'code' => 'PH', 'continent' => 'Asia'],
            ['name' => 'Singapore', 'code' => 'SG', 'continent' => 'Asia'],
            ['name' => 'Sri Lanka', 'code' => 'LK', 'continent' => 'Asia'],
            ['name' => 'Taiwan (Province of China)', 'code' => 'TW', 'continent' => 'Asia'],
            ['name' => 'Tajikistan', 'code' => 'TJ', 'continent' => 'Asia'],
            ['name' => 'Thailand', 'code' => 'TH', 'continent' => 'Asia'],
            ['name' => 'Timor-Leste', 'code' => 'TL', 'continent' => 'Asia'],
            ['name' => 'Turkmenistan', 'code' => 'TM', 'continent' => 'Asia'],
            ['name' => 'Uzbekistan', 'code' => 'UZ', 'continent' => 'Asia'],
            ['name' => 'Viet Nam', 'code' => 'VN', 'continent' => 'Asia'],
            ['name' => 'Belize', 'code' => 'BZ', 'continent' => 'Central America'],
            ['name' => 'Costa Rica', 'code' => 'CR', 'continent' => 'Central America'],
            ['name' => 'El Salvador', 'code' => 'SV', 'continent' => 'Central America'],
            ['name' => 'Guatemala', 'code' => 'GT', 'continent' => 'Central America'],
            ['name' => 'Honduras', 'code' => 'HN', 'continent' => 'Central America'],
            ['name' => 'Mexico', 'code' => 'MX', 'continent' => 'Central America'],
            ['name' => 'Nicaragua', 'code' => 'NI', 'continent' => 'Central America'],
            ['name' => 'Panama', 'code' => 'PA', 'continent' => 'Central America'],
            ['name' => 'Åland Islands', 'code' => 'AX', 'continent' => 'Europe'],
            ['name' => 'Albania', 'code' => 'AL', 'continent' => 'Europe'],
            ['name' => 'Andorra', 'code' => 'AD', 'continent' => 'Europe'],
            ['name' => 'Austria', 'code' => 'AT', 'continent' => 'Europe'],
            ['name' => 'Belarus', 'code' => 'BY', 'continent' => 'Europe'],
            ['name' => 'Belgium', 'code' => 'BE', 'continent' => 'Europe'],
            ['name' => 'Bosnia and Herzegovina', 'code' => 'BA', 'continent' => 'Europe'],
            ['name' => 'Bulgaria', 'code' => 'BG', 'continent' => 'Europe'],
            ['name' => 'Croatia', 'code' => 'HR', 'continent' => 'Europe'],
            ['name' => 'Cyprus', 'code' => 'CY', 'continent' => 'Europe'],
            ['name' => 'Czechia', 'code' => 'CZ', 'continent' => 'Europe'],
            ['name' => 'Denmark', 'code' => 'DK', 'continent' => 'Europe'],
            ['name' => 'Estonia', 'code' => 'EE', 'continent' => 'Europe'],
            ['name' => 'Faroe Islands (the)', 'code' => 'FO', 'continent' => 'Europe'],
            ['name' => 'Finland', 'code' => 'FI', 'continent' => 'Europe'],
            ['name' => 'France', 'code' => 'FR', 'continent' => 'Europe'],
            ['name' => 'Germany', 'code' => 'DE', 'continent' => 'Europe'],
            ['name' => 'Gibraltar', 'code' => 'GI', 'continent' => 'Europe'],
            ['name' => 'Greece', 'code' => 'GR', 'continent' => 'Europe'],
            ['name' => 'Guernsey', 'code' => 'GG', 'continent' => 'Europe'],
            ['name' => 'Holy See (the)', 'code' => 'VA', 'continent' => 'Europe'],
            ['name' => 'Hungary', 'code' => 'HU', 'continent' => 'Europe'],
            ['name' => 'Iceland', 'code' => 'IS', 'continent' => 'Europe'],
            ['name' => 'Ireland', 'code' => 'IE', 'continent' => 'Europe'],
            ['name' => 'Isle of Man', 'code' => 'IM', 'continent' => 'Europe'],
            ['name' => 'Italy', 'code' => 'IT', 'continent' => 'Europe'],
            ['name' => 'Jersey', 'code' => 'JE', 'continent' => 'Europe'],
            ['name' => 'Latvia', 'code' => 'LV', 'continent' => 'Europe'],
            ['name' => 'Liechtenstein', 'code' => 'LI', 'continent' => 'Europe'],
            ['name' => 'Lithuania', 'code' => 'LT', 'continent' => 'Europe'],
            ['name' => 'Luxembourg', 'code' => 'LU', 'continent' => 'Europe'],
            ['name' => 'Malta', 'code' => 'MT', 'continent' => 'Europe'],
            ['name' => 'Moldova (the Republic of)', 'code' => 'MD', 'continent' => 'Europe'],
            ['name' => 'Monaco', 'code' => 'MC', 'continent' => 'Europe'],
            ['name' => 'Montenegro', 'code' => 'ME', 'continent' => 'Europe'],
            ['name' => 'Netherlands (the)', 'code' => 'NL', 'continent' => 'Europe'],
            ['name' => 'North Macedonia', 'code' => 'MK', 'continent' => 'Europe'],
            ['name' => 'Norway', 'code' => 'NO', 'continent' => 'Europe'],
            ['name' => 'Poland', 'code' => 'PL', 'continent' => 'Europe'],
            ['name' => 'Portugal', 'code' => 'PT', 'continent' => 'Europe'],
            ['name' => 'Romania', 'code' => 'RO', 'continent' => 'Europe'],
            ['name' => 'Russian Federation (the)', 'code' => 'RU', 'continent' => 'Europe'],
            ['name' => 'San Marino', 'code' => 'SM', 'continent' => 'Europe'],
            ['name' => 'Serbia', 'code' => 'RS', 'continent' => 'Europe'],
            ['name' => 'Slovakia', 'code' => 'SK', 'continent' => 'Europe'],
            ['name' => 'Slovenia', 'code' => 'SI', 'continent' => 'Europe'],
            ['name' => 'Spain', 'code' => 'ES', 'continent' => 'Europe'],
            ['name' => 'Svalbard and Jan Mayen', 'code' => 'SJ', 'continent' => 'Europe'],
            ['name' => 'Sweden', 'code' => 'SE', 'continent' => 'Europe'],
            ['name' => 'Switzerland', 'code' => 'CH', 'continent' => 'Europe'],
            ['name' => 'Turkey', 'code' => 'TR', 'continent' => 'Europe'],
            ['name' => 'Ukraine', 'code' => 'UA', 'continent' => 'Europe'],
            ['name' => 'United Kingdom of Great Britain and Northern Ireland (the)', 'code' => 'GB', 'continent' => 'Europe'],
            ['name' => 'Bahrain', 'code' => 'BH', 'continent' => 'Middle East'],
            ['name' => 'Iran (Islamic Republic of)', 'code' => 'IR', 'continent' => 'Middle East'],
            ['name' => 'Iraq', 'code' => 'IQ', 'continent' => 'Middle East'],
            ['name' => 'Israel', 'code' => 'IL', 'continent' => 'Middle East'],
            ['name' => 'Jordan', 'code' => 'JO', 'continent' => 'Middle East'],
            ['name' => 'Kuwait', 'code' => 'KW', 'continent' => 'Middle East'],
            ['name' => 'Lebanon', 'code' => 'LB', 'continent' => 'Middle East'],
            ['name' => 'Oman', 'code' => 'OM', 'continent' => 'Middle East'],
            ['name' => 'Palestine, State of', 'code' => 'PS', 'continent' => 'Middle East'],
            ['name' => 'Qatar', 'code' => 'QA', 'continent' => 'Middle East'],
            ['name' => 'Saudi Arabia', 'code' => 'SA', 'continent' => 'Middle East'],
            ['name' => 'Syrian Arab Republic (the)', 'code' => 'SY', 'continent' => 'Middle East'],
            ['name' => 'United Arab Emirates (the)', 'code' => 'AE', 'continent' => 'Middle East'],
            ['name' => 'Yemen', 'code' => 'YE', 'continent' => 'Middle East'],
            ['name' => 'Bermuda', 'code' => 'BM', 'continent' => 'North America'],
            ['name' => 'Canada', 'code' => 'CA', 'continent' => 'North America'],
            ['name' => 'Greenland', 'code' => 'GL', 'continent' => 'North America'],
            ['name' => 'Saint Pierre and Miquelon', 'code' => 'PM', 'continent' => 'North America'],
            ['name' => 'United States of America (the)', 'code' => 'US', 'continent' => 'North America'],
            ['name' => 'American Samoa', 'code' => 'AS', 'continent' => 'Oceania'],
            ['name' => 'Australia', 'code' => 'AU', 'continent' => 'Oceania'],
            ['name' => 'Christmas Island', 'code' => 'CX', 'continent' => 'Oceania'],
            ['name' => 'Cocos (Keeling) Islands (the)', 'code' => 'CC', 'continent' => 'Oceania'],
            ['name' => 'Cook Islands (the)', 'code' => 'CK', 'continent' => 'Oceania'],
            ['name' => 'Fiji', 'code' => 'FJ', 'continent' => 'Oceania'],
            ['name' => 'French Polynesia', 'code' => 'PF', 'continent' => 'Oceania'],
            ['name' => 'Guam', 'code' => 'GU', 'continent' => 'Oceania'],
            ['name' => 'Kiribati', 'code' => 'KI', 'continent' => 'Oceania'],
            ['name' => 'Marshall Islands (the)', 'code' => 'MH', 'continent' => 'Oceania'],
            ['name' => 'Micronesia (Federated States of)', 'code' => 'FM', 'continent' => 'Oceania'],
            ['name' => 'Nauru', 'code' => 'NR', 'continent' => 'Oceania'],
            ['name' => 'New Caledonia', 'code' => 'NC', 'continent' => 'Oceania'],
            ['name' => 'New Zealand', 'code' => 'NZ', 'continent' => 'Oceania'],
            ['name' => 'Niue', 'code' => 'NU', 'continent' => 'Oceania'],
            ['name' => 'Norfolk Island', 'code' => 'NF', 'continent' => 'Oceania'],
            ['name' => 'Northern Mariana Islands (the)', 'code' => 'MP', 'continent' => 'Oceania'],
            ['name' => 'Palau', 'code' => 'PW', 'continent' => 'Oceania'],
            ['name' => 'Papua New Guinea', 'code' => 'PG', 'continent' => 'Oceania'],
            ['name' => 'Pitcairn', 'code' => 'PN', 'continent' => 'Oceania'],
            ['name' => 'Samoa', 'code' => 'WS', 'continent' => 'Oceania'],
            ['name' => 'Solomon Islands', 'code' => 'SB', 'continent' => 'Oceania'],
            ['name' => 'Tokelau', 'code' => 'TK', 'continent' => 'Oceania'],
            ['name' => 'Tonga', 'code' => 'TO', 'continent' => 'Oceania'],
            ['name' => 'Tuvalu', 'code' => 'TV', 'continent' => 'Oceania'],
            ['name' => 'United States Minor Outlying Islands (the)', 'code' => 'UM', 'continent' => 'Oceania'],
            ['name' => 'Vanuatu', 'code' => 'VU', 'continent' => 'Oceania'],
            ['name' => 'Wallis and Futuna', 'code' => 'WF', 'continent' => 'Oceania'],
            ['name' => 'Argentina', 'code' => 'AR', 'continent' => 'South America'],
            ['name' => 'Bolivia (Plurinational State of)', 'code' => 'BO', 'continent' => 'South America'],
            ['name' => 'Brazil', 'code' => 'BR', 'continent' => 'South America'],
            ['name' => 'Chile', 'code' => 'CL', 'continent' => 'South America'],
            ['name' => 'Colombia', 'code' => 'CO', 'continent' => 'South America'],
            ['name' => 'Ecuador', 'code' => 'EC', 'continent' => 'South America'],
            ['name' => 'Falkland Islands (the) [Malvinas]', 'code' => 'FK', 'continent' => 'South America'],
            ['name' => 'French Guiana', 'code' => 'GF', 'continent' => 'South America'],
            ['name' => 'Guyana', 'code' => 'GY', 'continent' => 'South America'],
            ['name' => 'Paraguay', 'code' => 'PY', 'continent' => 'South America'],
            ['name' => 'Peru', 'code' => 'PE', 'continent' => 'South America'],
            ['name' => 'Suriname', 'code' => 'SR', 'continent' => 'South America'],
            ['name' => 'Uruguay', 'code' => 'UY', 'continent' => 'South America'],
            ['name' => 'Venezuela (Bolivarian Republic of)', 'code' => 'VE', 'continent' => 'South America'],
            ['name' => 'Anguilla', 'code' => 'AI', 'continent' => 'The Caribbean'],
            ['name' => 'Antigua and Barbuda', 'code' => 'AG', 'continent' => 'The Caribbean'],
            ['name' => 'Aruba', 'code' => 'AW', 'continent' => 'The Caribbean'],
            ['name' => 'Bahamas (the)', 'code' => 'BS', 'continent' => 'The Caribbean'],
            ['name' => 'Barbados', 'code' => 'BB', 'continent' => 'The Caribbean'],
            ['name' => 'Bonaire, Sint Eustatius and Saba', 'code' => 'BQ', 'continent' => 'The Caribbean'],
            ['name' => 'Cayman Islands (the)', 'code' => 'KY', 'continent' => 'The Caribbean'],
            ['name' => 'Cuba', 'code' => 'CU', 'continent' => 'The Caribbean'],
            ['name' => 'Curaçao', 'code' => 'CW', 'continent' => 'The Caribbean'],
            ['name' => 'Dominica', 'code' => 'DM', 'continent' => 'The Caribbean'],
            ['name' => 'Dominican Republic (the)', 'code' => 'DO', 'continent' => 'The Caribbean'],
            ['name' => 'Grenada', 'code' => 'GD', 'continent' => 'The Caribbean'],
            ['name' => 'Guadeloupe', 'code' => 'GP', 'continent' => 'The Caribbean'],
            ['name' => 'Haiti', 'code' => 'HT', 'continent' => 'The Caribbean'],
            ['name' => 'Jamaica', 'code' => 'JM', 'continent' => 'The Caribbean'],
            ['name' => 'Martinique', 'code' => 'MQ', 'continent' => 'The Caribbean'],
            ['name' => 'Montserrat', 'code' => 'MS', 'continent' => 'The Caribbean'],
            ['name' => 'Puerto Rico', 'code' => 'PR', 'continent' => 'The Caribbean'],
            ['name' => 'Saint Barthélemy', 'code' => 'BL', 'continent' => 'The Caribbean'],
            ['name' => 'Saint Kitts and Nevis', 'code' => 'KN', 'continent' => 'The Caribbean'],
            ['name' => 'Saint Lucia', 'code' => 'LC', 'continent' => 'The Caribbean'],
            ['name' => 'Saint Martin (French part)', 'code' => 'MF', 'continent' => 'The Caribbean'],
            ['name' => 'Saint Vincent and the Grenadines', 'code' => 'VC', 'continent' => 'The Caribbean'],
            ['name' => 'Sint Maarten (Dutch part)', 'code' => 'SX', 'continent' => 'The Caribbean'],
            ['name' => 'Trinidad and Tobago', 'code' => 'TT', 'continent' => 'The Caribbean'],
            ['name' => 'Turks and Caicos Islands (the)', 'code' => 'TC', 'continent' => 'The Caribbean'],
            ['name' => 'Virgin Islands (British)', 'code' => 'VG', 'continent' => 'The Caribbean'],
            ['name' => 'Virgin Islands (U.S.)', 'code' => 'VI', 'continent' => 'The Caribbean'],
        ];
    }
}
