var GRUMPIES = {
	'short': {
		'text': "‘తెలుగదేలయన్న దేశంబు తెలుగేను, తెలుగు వల్లభుండ, తెలుగొకండ, ఎల్లనృపులు గొలువనెరుగవే బాసాడి దేశభాషలందు తెలుగులెస్స..!’ ఈ సువర్ణాక్షరాలు కన్నడ రాజ్యరమారమణుడైన శ్రీకృష్ణదేవరాయలే స్వయంగా తన ఆముక్తమాల్యద ప్రబంధంలో చెప్పినవి",
		'columns': [ // single column
			{
				sizes: [72, 60, 48, 36, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12],
				innerblock: 'div'
			}
		],
		'tab': '#headlines'
	},

	'long': {
		'text': "‘తెలుగదేలయన్న దేశంబు తెలుగేను, తెలుగు వల్లభుండ, తెలుగొకండ, ఎల్లనృపులు గొలువనెరుగవే బాసాడి దేశభాషలందు తెలుగులెస్స..!’ ఈ సువర్ణాక్షరాలు కన్నడ రాజ్యరమారమణుడైన శ్రీకృష్ణదేవరాయలే స్వయంగా తన ఆముక్తమాల్యద ప్రబంధంలో చెప్పినవి 01234567890 ",
		'columns': [ // two columns
			{sizes: [20, 19, 18, 17], innerblock: '.textsettingCol1'},
			{sizes: [16, 15, 14, 13, 12, 11, 10], innerblock: '.textsettingCol2'}
		],
		'tab': '#tamiltext'
	},
    
    'longTala': {
		'text': "పత్రిక స్థాయి పెంచే వ్యాసం అనడం లో సందేహం లేదు. ఎన్నో చక్కని విషయాలను పంచుకొన్నందుకు రచయిత అభినందనీయులు. అంతే గాక: ‘Bounded gap problemని తెలుగులో ఏమంటే స్వయంబోధకంగా ఉంటుందా నేనూ సంపాదకుడూ తర్జనభర్జనలు పడ్డాం. చివరికి సీమితపాత సమస్య అని అన్వయించుకుని సమాధానపడ్డాం. ఇంతకంటే మంచి మాట ఉంటే చెప్పమని పాఠకులని కోరుతున్నాం.’ అని ఒక శాస్త్రీయ దృక్పథం కనబరిచినందుకు కూడా. ‘సీమితపాత సమస్య‘ అన్న పదబంధం అర్థబోధలో కొత్త సమస్యను సృష్టిస్తుంది. మనకు గణితం లో , ఇదివరకే అనుపాతాలు (proportions) ఉన్నాయి . మామూలు వాడుకలో (పాతము అంటే పడిపోవటానికి సంబంధించిన అర్థంలో) జలపాతం, రక్తపాతం అన్న పదబంధాలు ఉన్నాయి. ఈ గణిత సందర్భంలో పాతం పొసగడం లేదు, ఎడం/విరామం అన్న పదాలు మెరుగు అలాగే సీమిత అన్న పదం కూడా ముక్కస్య ముక్క అనువాదమే , భావానుగుణంగా నియమిత అని వ్యవహరించడం మేలు. ఆ ప్రకారం ‘The Bounded Gap Problem ‘ని‘ నియమిత విరామ సమస్య ‘గా వాడుక చేయవచ్చు. ఝాంగ్ ఉవాచః ‘ఒక ప్రధాన సంఖ్యకి, దాని తరువాత కనిపించే ప్రధాన సంఖ్యకి మధ్య వచ్చే పాతము పరిబద్ధమైనది లేదా ‘సీమితము’ (bounded) అని అన్నారు. అంటే, ఎంత దూరం వెళ్లినా ఆ ఖాళీ విలువ ఒక అవధి దాటకుండా పరిమితంగానే ఉంటుంది కాని ఎప్పటికీ అనంతం కాదు. ఇంకా నిర్ధిష్టంగా చెప్పాలంటే, ఆ పాతపు విలువ 70,000,000 దాటదు’ అదే పంపిణీ మీద ఈ వాక్యాన్ని తిరగరాస్తే – ‘ఒక ప్రధాన సంఖ్యకి, దాని తరువాత కనిపించే ప్రధాన సంఖ్యకి మధ్య వచ్చే విరామం నియమితం ’ (bounded) అని అన్నారు. అంటే, ఎంత దూరం వెళ్లినా ఆ ఖాళీ విలువ ఒక అవధి దాటకుండా పరిమితంగానే ఉంటుంది కాని ఎప్పటికీ అనంతం కాదు. ఇంకా నిర్ధిష్టంగా చెప్పాలంటే, ఆ విరామం విలువ 70,000,000 దాటదు. మరి కొన్ని చిల్లర విషయాలు: 1. sexy prime numbers : ఆరు ప్రధాన సంఖ్యలుగా అనువదించుకోవచ్చు. Latin లాటిన్ లో ఆరును sex అంటారు దాని మీద శ్లేష వేసి పుట్టించిన పదం ఇది. పోతే, తెలుగులో ఆరుకు సంఖ్యా పరం కాని అర్థాలున్నాయి : అలరారు, ఇంపారు, ఒప్పారు ఆరుకు శృంగార పరమైన అర్థం కూడా ఉన్నది , కాబట్టి ఆరు ప్రధాన సంఖ్యలు అనడం సులువు ; దీనికి బహువచన రూపం సాధించడం కూడా సులువు : ఆర్లు అంటే సరి. లైంగికాలు అనడం బాగాలేదు. 01234567890 ",
		'columns': [ // two columns
			{sizes: [20, 19, 18, 17], innerblock: '.textsettingCol1'},
			{sizes: [16, 15, 14, 13, 12, 11, 10], innerblock: '.textsettingCol2'}
		],
		'tab': '#talatext'
	},

	'lowercaseShort': {
		'text': "the five boxing wizards jump quickly pack my red box with five dozen quality jugs a very big box sailed up then whizzed quickly from japan",
		'columns': [
			{sizes: [72, 60, 48, 36, 30, 24, 18], innerblock: 'div:first'}
		],
		'tab': '#lowercases'
	},

	'lowercaseLong': {
		'text': "serviced tightly trestle custom nosey impugned gooier deeper oat charade smashed welting clopping fondly discard welfare gaudy mission shoddily mooed knelling glance golfed trope togae knocked vulgarly gigabyte curbing snowball outback stepped marmot clayier coltish descry gratify root freedom puree urgency moist careered journal oracle felony marble salary readying besiege twitched ranching snoozing disk mister warbling outwit schism sudsiest street gondola blushing pennon smarted jiving sty rocker griping rocketry dieing tarring A very big box sailed up then whizzed quickly from Japan the five boxing wizards jump quickly pack my red box with five dozen quality jugs",
		'columns': [
			{sizes: [16, 15, 14], innerblock: '.textsettingCol1'},
			{sizes: [13, 12, 11, 10], innerblock: '.textsettingCol2'}
		],
		'tab': '#lowercases'
	},

	'adhesionShort': {
		'text': "హైదరాబాద్‌లో సెల్‌కాన్ పరిశోధన కేంద్రం?.",
		'columns': [
			{sizes: [72, 60, 48, 36, 30, 24, 18], innerblock: 'div:first'}
		],
		'tab': '#adhesion'
	},

	'adhesionLong': {
		'text': "హైదరాబాద్, జూలై 30: రాష్ర్టానికి చెందిన ప్రముఖ మొబైల్ తయారీ సంస్థ సెల్‌కాన్..దక్షిణాదిన అభివృద్ధి, పరిశోధన(ఆర్ అండ్ డీ) సెంటర్‌ను ఏర్పాటు చేయనున్నట్లు ప్రకటించింది. రూ.100 కోట్ల పెట్టుబడితో ఏర్పాటు చేయనున్న ఈ సెంటర్ కోసం హైదరాబాద్‌తోపాటు బెంగళూరు, వైజాగ్ నగరాల్లో అనువైన ప్రాంతం కోసం అన్వేషిస్తున్నట్లు కంపెనీ చైర్మన్, మేనేజింగ్ డైరెక్టర్ వై గురు తెలిపారు. భారత్‌లో మొబైల్ ఆర్ అండ్ డీ సెంటర్‌ను ఏర్పాటు చేయబోతున్న తొలి సంస్థ సెల్‌కాన్ కానుందన్నారు. ఇటీవల రాష్ట్రంలో అసెంబ్లింగ్ యూనిట్‌ను ప్రారంభించిన సెల్‌కాన్.. ఇక్కడే ఆర్ అండ్ డీ సెంటర్‌ను సైతం ఏర్పాటు చేసే అవకాశాలున్నాయని, ఈ విషయంపై త్వరలోనే రాష్ట్ర ప్రభుత్వంతో సంప్రదింపులు జరుపనున్నట్లు గురు తెలిపారు. ప్రస్తుతం సంస్థ చైనాలోని ఆర్ అండ్ డీ సెంటర్‌లో తయారవుతున్న మొబైళ్లను దిగుమతి చేసుకొని భారత్‌లో విక్రయిస్తున్నది. ఇక్కడే ఆర్ అండ్ డీ సెంటర్‌ను ఏర్పాటు చేయడం ద్వారా కంపెనీ నిర్వహణ ఖర్చులు తగ్గడంతోపాటు మొబైల్ ధరలు మరింత తగ్గే అవకాశం ఉంటుందన్నారు.",
		'columns': [
			{sizes: [16, 15, 14], innerblock: '.textsettingCol1'},
			{sizes: [13, 12, 11, 10], innerblock: '.textsettingCol2'}
		],
		'tab': '#adhesion'
	},

	'hamburgefonstivShort': {
		'text': "fortieth boring trait favoring barrage referring thrusting tannest embargo sausage gaining astutest augur hibernate variant hearse beggaring foresee eagerer hearten ensnaring tufting interstate meager veneration stigma feminine tabbing noising trimming throbbing ransoming stiffen oaring fishing rehire overbore bonniest ravishment teensiest mintier shriven unforeseen overrate surgeon smarter submarine revenging assuaging masher amnesia insentient rehashing fresher buttering sorghum thine sitter month serer minting variate torsion gaunt",
		'columns': [
			{sizes: [72, 60, 48, 36, 30, 24, 18], innerblock: 'div:first'}
		],
		'tab': '#hamburgefonstiv'
	},

	'hamburgefonstivLong': {
		'text': "fortieth boring trait favoring barrage referring thrusting tannest embargo sausage gaining astutest augur hibernate variant hearse beggaring foresee eagerer hearten ensnaring tufting interstate meager veneration stigma feminine tabbing noising trimming throbbing ransoming stiffen oaring fishing rehire overbore bonniest ravishment teensiest mintier shriven unforeseen overrate surgeon smarter submarine revenging assuaging masher amnesia insentient rehashing fresher buttering sorghum thine sitter month serer minting variate torsion gaunt berthing goofiest sober informing sourer tonight neigh iratest torte situate rheumier antagonist serening motion guise unseeing masseuse",
		'columns': [
			{sizes: [16, 15, 14], innerblock: '.textsettingCol1'},
			{sizes: [13, 12, 11, 10], innerblock: '.textsettingCol2'}
		],
		'tab': '#hamburgefonstiv'
	},

	'caps': {
		'text': "తర్కము, ఆసక్తి, పద్యము, అశ్వము కట్నము, కాశ్మీరు, భగవద్గీత, హర్షము, పెండ్లి, అగ్ని, అద్భుతము, అభ్యాసము, అర్జున, అరుదైన, అవస్థ, అష్టమి, ఆర్యులు, ఇష్టము, ఈశ్వర, ఓర్పు, కర్పూరము, కల్కి, కల్గి, కష్టము, కార్యం, కీర్తి, క్రమం, క్షేమం, గురుపత్ని, చిత్రము, జిహ్వ, తెల్పు, దర్జా, దుర్గము, దుర్దినము, ద్వాదశి, ధర్మము, నిశ్చలము, నేత్రము, పవిత్ర, పార్వతి, పుష్పము, పొట్లకాయ, ప్రవచనం, ప్రాణం, పారాయణం, బ్రతుకు, భక్తి, మంత్రాలు, మర్కటము, రాజ్యము, రిక్త, వర్షము, విదర్భ, విద్య, విశ్వము, వైష్ణవి, శబ్దము, సత్య, సద్గుణము, సావిత్రి, సాథనము, స్థానము, స్నేహము, స్వప్నము, హస్తము, అభిసారిక, రాష్ట్రపతి, ఈర్ష్య, స్వాతంత్ర్యము, అర్ఘ్యము, ఉచ్ఛ్వాస, జ్యోత్స్న, వస్త్రము, ధృతరాష్ట్రుడు, స్త్రీ, ఇన్స్పెక్టర్, వైశిష్ట్యము, సామర్ధ్యము, దారిద్ర్యము, కక్ష్య, లక్ష్మయ్య, లక్ష్మీ, లక్ష్యా, లక్ష్మణుడు, కర్ఫ్యూ, లక్ష్యము, లక్ష్యాలు, రాష్ట్రము, ఉత్ప్రేక్ష, సంస్కృతి, అంతఃపురం, ఉషఃకిరణాలు, వాఙ్మయం, యజ్ఞము, ప్రాతఃకాలం, ౘౙ, ముత్తైదువ, అష్టైశ్వర్యములు, వాత్స్యాయన, శిష్ట్ల, స్పెక్ట్రమ్, ఊర్థ్వ, శ్శై, స్త్వ, ర్ణ్య, క్రైమ్, పోస్ట్స్, సుధాకర్కి, స్టైల్, ట్రైన్, మార్క్స్, త్రైమాసిక, స్పృహ, ఆర్ద్రత, తార్క్ష్యుడు, వక్తృత్వ, భర్తృహరి, వస్త్వైక్యము, శార్ఙ్గైః, క్చై, స్చై, స్టై వార్ష్ణేయుడు, మౌద్గల్యుఁడు, ధార్ష్ట్యము, ఆర్ద్రం, సార్ద్రం, క్లిన్నం, భుఙ్త్వా, భుఙ్త్క, ఆర్ద్రత, విశ్వభుగవ్యయః, శక్యోపి, వర్జ్యము, గార్డ్స్, జగజ్జ్యోతి, ఇన్స్క్రిప్ట్, గ్రైండింగ్, ప్రక్రియ, స్పృహ, మాతృ కన్సార్టియమ్, తో౽ధినో౾వేదన, సంఖ్య, మహేశ్వరం, సృష్టి, ఫ్లైట్, ఫ్లీట్ 0 1 2 3 4 5 6 7 8 9 ! ?",
		'columns': [
			{sizes: [60, 48, 36, 30, 28, 24, 20, 18, 16, 14, 13], innerblock: 'div'}
		],
		'tab': '#caps'
	},

	'allcaps': {
		'text': "ARROWROOT BARLETY CHERVIL DUMPLING ENDINE FLAXSEED GARBANZO HIJIKI ISHTU JICAMA KALE LYCHEEN MARJORAM NECTARINE OXTAIL PIZZA QUINOA ROQUEFORT SQUASH TOFU UPPUMA VANILLA WHEAT XERGIS YOGURT ZWEIBACK 0 1 2 3 4 5 6 7 8 9 ! ?",
		'columns': [
			{sizes: [60, 48, 36, 30, 28, 24, 20, 18, 16, 14, 13], innerblock: 'div'}
		],
		'tab': '#allcaps'
	}
};

var hintsCaps = "அஆஇஈஉஊஎஏஐஒஓஔஃ";
var hintsLower = "க்ச்ட்த்ப்ற்ஞ்ங்ந்ன்ண்ம்ய்ர்ழ்வ்ள்ல்ஶ்ஜ்ஷ்ஸ்ஹ்க்ஷ் .:;,";
var hintsNumbers= "௦௧௨௩௪௫௬௭௮௯௰௱௲ @&amp;!?#$€%";


function eventTextLineChange(e) {
    var $this = $(this);
    bulkChangeTextForTab(e.data.grumpy, $this.text(), $this);
}


function onblur() {
    var $this = $(this);
    var text = $this.html();
    if ($this.data('enter') !== text) {
        $this.data('enter', text);
        $this.trigger({type: 'change', action : 'save'});
    }
    return $this;
}


function onkeyup() {
    var $this = $(this);
    var text = $this.html();
    if ($this.data('before') !== text) {
        $this.data('before', text);
        $this.trigger({type: 'change', action : 'update'});
    }
    return $this;
}


function onfocus() {
    var $this = $(this);
    $this.data('enter', $this.html());
    $this.data('before', $this.html());
    return $this;
}


function setColumnTemplate(container, grumpy) {
    for (var k = 0; k < grumpy.columns.length; k++) {

        var sizes = grumpy.columns[k].sizes;
        var block = container.find(grumpy.columns[k].innerblock);
        for (var i = 0; i < sizes.length; i++) {
            fontsize = sizes[i].toString();
            block.append($('<p>').addClass('sizelabel').text(fontsize + 'px'));

            var textline = $('<p>').addClass('textline')
                .css('font-size', fontsize + 'px')
                .attr('contenteditable', true)
                .text(grumpy.text)
                .on('focus', onfocus)
                .on('keyup paste', onkeyup)
                .on('blur', onblur)
                .on('change', {'grumpy': grumpy}, eventTextLineChange);

            block.append(textline);
            //block.append($('<p>&nbsp;</p>'));
        }
    }
}

function setColumnTemplate2(container, grumpy) {
    for (var k = 0; k < grumpy.columns.length; k++) {

        var sizes = grumpy.columns[k].sizes;
        var block = container.find(grumpy.columns[k].innerblock);
        for (var i = 0; i < sizes.length; i++) {
            fontsize = sizes[i].toString();
            block.append($('<p>').addClass('sizelabel').text(fontsize + 'px'));

            var textline = $('<p>').addClass('textline')
                .css('font-size', fontsize + 'px')
                .attr('contenteditable', true)
                .text(grumpy.text)
                .on('focus', onfocus)
                .on('keyup paste', onkeyup)
                .on('blur', onblur)
                .on('change', {'grumpy': grumpy}, eventTextLineChange);

            block.append(textline);
            block.append($('<p>&nbsp;</p>'));
        }
    }
}


function setSplitSingleToDual(container, grumpies_short, grumpies_long) {
    setColumnTemplate(container, grumpies_short);
    setColumnTemplate(container, grumpies_long);
}


function bulkChangeTextForTab(grumpy, value, except) {
    for (var i = 0; i < grumpy.columns.length; i++) {
        $(grumpy.tab).find(grumpy.columns[i].innerblock).find('.textline').not(except).text(value);
    }
}


function prepareAndShowFontLayout() {

    setColumnTemplate($('#headlines'), GRUMPIES.short);

    setColumnTemplate2($('#tamiltext'), GRUMPIES.long);

    

    setColumnTemplate2($('#talatext'), GRUMPIES.longTala);

    var $lowercases = $('#lowercases');
    setColumnTemplate($lowercases, GRUMPIES.lowercaseShort);
    setColumnTemplate2($lowercases, GRUMPIES.lowercaseLong);

    var $adhesion = $('#adhesion');
    setColumnTemplate($adhesion, GRUMPIES.adhesionShort);
    setColumnTemplate2($adhesion, GRUMPIES.adhesionLong);

    var $hamburgefonstiv = $('#hamburgefonstiv');
    setColumnTemplate($hamburgefonstiv, GRUMPIES.hamburgefonstivShort);
    setColumnTemplate2($hamburgefonstiv, GRUMPIES.hamburgefonstivLong);

    var $caps = $('#caps');
    setColumnTemplate2($caps, GRUMPIES.caps);
    
    var $allcaps = $('#allcaps');
    setColumnTemplate2($allcaps, GRUMPIES.allcaps);

    var hints_caps = $('.hints-caps');
    var hints_numbers = $('.hints-numbers');
    var hints_lower = $('.hints-lower');
    hints_lower.html(hints_lower.html() + hintsLower);
    hints_caps.html(hints_caps.html() + hintsCaps);
    hints_numbers.html(hints_numbers.html() + hintsNumbers);
}