var GRUMPIES = {
	'short': {
		'text': "அன்பென்ற அழகிய உணர்வின் அற்புதங்களை அனுபவித்தல் சுகமானது. இதுதான் வாழ்வின் ஆனந்தமான தருணங்களின் தோற்றுவாய். ஒவ்வொரு தினமும் அன்பென்பதை ஆராதிப்போம். வாருங்கள். சேருங்கள்.",
		'columns': [ // single column
			{
				sizes: [72, 60, 48, 36, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12],
				innerblock: 'div'
			}
		],
		'tab': '#headlines'
	},

	'long': {
		'text': "உன்னோடிருக்கும் எல்லாமே, நீயும் உன் உணர்வுகளும் மட்டுந்தான் எனக் கற்பனை செய்து கொள். உன்னிடம் எதுவுமேயில்லை. உன் அயலிலும் எதுவுமேயில்லை. அப்போது, உன் அயல் முழுதும் இடைவெளி, மௌனம், வாய்ப்புகள் என பலதும் அமைந்திருக்கக் காண்பாய். 1943ஆம் ஆண்டு பற்றி இந்த நேரத்தில் எதற்குச் சொல்லவேண்டும்? ஓரிடத்தில் அதிகமான பொருள்கள் இருக்கும் நிலையில், அங்குள்ள பெறுமதியான பொருளுக்குக் கூட மதிப்புக் கிடைக்காது. அங்கு அமைதி நிலவாது, எல்லாப் பொருளும் தம்நிலையைத் தக்க வைக்க போட்டி போட்டு கொண்டிருக்க, அங்கு எதுவுமே வெல்ல முடியாது, தோற்றுக் கொண்டிருக்கும். 01234567890 ",
		'columns': [ // two columns
			{sizes: [20, 19, 18, 17], innerblock: '.textsettingCol1'},
			{sizes: [16, 15, 14, 13, 12, 11, 10], innerblock: '.textsettingCol2'}
		],
		'tab': '#tamiltext'
	},
    
    'longTala': {
		'text': "உன்னோடிருக்கும் எல்லாமே, நீயும் உன் உணர்வுகளும் மட்டுந்தான் எனக் கற்பனை செய்து கொள். இங்கு 42 என்ற இலக்கத்தை இடுவது ஒரு பரிசோதனைக்காக மாத்திரமே. உன்னிடம் எதுவுமேயில்லை. உன் அயலிலும் எதுவுமேயில்லை. அப்போது, உன் அயல் முழுதும் இடைவெளி, மௌனம், வாய்ப்புகள் என பலதும் அமைந்திருக்கக் காண்பாய். Words mean more than what is set down on paper. It takes the human voice to infuse them with shades of deeper meaning. I've learned that people will forget what you said, people will forget what you did, but people will never forget how you made them feel. ஓரிடத்தில் அதிகமான பொருள்கள் இருக்கும் நிலையில், அங்குள்ள பெறுமதியான பொருளுக்குக் கூட மதிப்புக் கிடைக்காது. அங்கு அமைதி நிலவாது, எல்லாப் பொருளும் தம்நிலையைத் தக்க வைக்க போட்டி போட்டு கொண்டிருக்க, அங்கு எதுவுமே வெல்ல முடியாது, தோற்றுக் கொண்டிருக்கும். 01234567890 ",
		'columns': [ // two columns
			{sizes: [20, 19, 18, 17], innerblock: '.textsettingCol1'},
			{sizes: [16, 15, 14, 13, 12, 11, 10], innerblock: '.textsettingCol2'}
		],
		'tab': '#talatext'
	},

	'lowercaseShort': {
		'text': "the five boxing wizards jump quickly pack my red box with five dozen quality jugs a very big box sailed up then whizzed quickly from japan",
		'columns': [
			{sizes: [72, 60, 48, 36, 30, 24, 18], innerblock: 'div:first'}
		],
		'tab': '#lowercases'
	},

	'lowercaseLong': {
		'text': "serviced tightly trestle custom nosey impugned gooier deeper oat charade smashed welting clopping fondly discard welfare gaudy mission shoddily mooed knelling glance golfed trope togae knocked vulgarly gigabyte curbing snowball outback stepped marmot clayier coltish descry gratify root freedom puree urgency moist careered journal oracle felony marble salary readying besiege twitched ranching snoozing disk mister warbling outwit schism sudsiest street gondola blushing pennon smarted jiving sty rocker griping rocketry dieing tarring A very big box sailed up then whizzed quickly from Japan the five boxing wizards jump quickly pack my red box with five dozen quality jugs",
		'columns': [
			{sizes: [16, 15, 14], innerblock: '.textsettingCol1'},
			{sizes: [13, 12, 11, 10], innerblock: '.textsettingCol2'}
		],
		'tab': '#lowercases'
	},

	'adhesionShort': {
		'text': "எதுவுமே உன்னிடம் இல்லாமலில்லை என்று உன் மனதால் நீ உணர்கின்ற நிலையில், முழு உலகமுமே உனக்குச் சொந்தமாகிவிடுகிறது.",
		'columns': [
			{sizes: [72, 60, 48, 36, 30, 24, 18], innerblock: 'div:first'}
		],
		'tab': '#adhesion'
	},

	'adhesionLong': {
		'text': "உன்னிடம் எதுவுமில்லாவிட்டாலும், அதுபற்றி நீ திருப்தி கொள்ள வேண்டியிருக்கிறது. “என்னிடம் இது இல்லையே”, “ஐயகோ, என்னிடம் அதுகூட இல்லையே” என்கின்ற உன் உள்ளக்குமுறல்கள் மனதில் கவலையை மட்டுந்தான் விதைக்கும். வெறுமையான ஓரிடத்தில், உன் எண்ணத்தால் வினை செய்வதற்கான வாய்ப்பும் வசதியும் அதிகமாகும். வெறுமை என்பது வாய்ப்புகளின் வெளி என்பதை நீ மறக்கக்கூடாது. உன் எண்ணத்திற்கு போதியளவு இடம் காணப்படுகின்ற நிலையிலேயே, மனதில் அமைதி தோன்ற வாய்ப்பு உண்டு.",
		'columns': [
			{sizes: [16, 15, 14], innerblock: '.textsettingCol1'},
			{sizes: [13, 12, 11, 10], innerblock: '.textsettingCol2'}
		],
		'tab': '#adhesion'
	},

	'hamburgefonstivShort': {
		'text': "fortieth boring trait favoring barrage referring thrusting tannest embargo sausage gaining astutest augur hibernate variant hearse beggaring foresee eagerer hearten ensnaring tufting interstate meager veneration stigma feminine tabbing noising trimming throbbing ransoming stiffen oaring fishing rehire overbore bonniest ravishment teensiest mintier shriven unforeseen overrate surgeon smarter submarine revenging assuaging masher amnesia insentient rehashing fresher buttering sorghum thine sitter month serer minting variate torsion gaunt",
		'columns': [
			{sizes: [72, 60, 48, 36, 30, 24, 18], innerblock: 'div:first'}
		],
		'tab': '#hamburgefonstiv'
	},

	'hamburgefonstivLong': {
		'text': "fortieth boring trait favoring barrage referring thrusting tannest embargo sausage gaining astutest augur hibernate variant hearse beggaring foresee eagerer hearten ensnaring tufting interstate meager veneration stigma feminine tabbing noising trimming throbbing ransoming stiffen oaring fishing rehire overbore bonniest ravishment teensiest mintier shriven unforeseen overrate surgeon smarter submarine revenging assuaging masher amnesia insentient rehashing fresher buttering sorghum thine sitter month serer minting variate torsion gaunt berthing goofiest sober informing sourer tonight neigh iratest torte situate rheumier antagonist serening motion guise unseeing masseuse",
		'columns': [
			{sizes: [16, 15, 14], innerblock: '.textsettingCol1'},
			{sizes: [13, 12, 11, 10], innerblock: '.textsettingCol2'}
		],
		'tab': '#hamburgefonstiv'
	},

	'caps': {
		'text': "ஒரு மற்றும் பயனர் பகுப்பு தமிழ் மேலும் என்று உள்ள இது ஆம் இந்த அல்லது என்ற பல என்பது பக்கம் பற்றி ஆண்டு துடுப்பாட்டம் படிமம் இருக்கும் முதல் உங்கள் ஆகும் பற்றிய இந்திய பக்கத்தில் இவர் சில செய்து இருந்து என பேச்சு அறிந்து போன்ற இல் கொள்ள கீழே அவர் வேண்டும் ஆனால் என்னும் முதல்தர நீங்கள் சிறந்த தேர்வு வரவேற்கிறோம் 0 1 2 3 4 5 6 7 8 9 ! ?",
		'columns': [
			{sizes: [60, 48, 36, 30, 28, 24, 20, 18, 16, 14, 13], innerblock: 'div'}
		],
		'tab': '#caps'
	},

	'allcaps': {
		'text': "ARROWROOT BARLETY CHERVIL DUMPLING ENDINE FLAXSEED GARBANZO HIJIKI ISHTU JICAMA KALE LYCHEEN MARJORAM NECTARINE OXTAIL PIZZA QUINOA ROQUEFORT SQUASH TOFU UPPUMA VANILLA WHEAT XERGIS YOGURT ZWEIBACK 0 1 2 3 4 5 6 7 8 9 ! ?",
		'columns': [
			{sizes: [60, 48, 36, 30, 28, 24, 20, 18, 16, 14, 13], innerblock: 'div'}
		],
		'tab': '#allcaps'
	}
};

var hintsCaps = "அஆஇஈஉஊஎஏஐஒஓஔஃ";
var hintsLower = "க்ச்ட்த்ப்ற்ஞ்ங்ந்ன்ண்ம்ய்ர்ழ்வ்ள்ல்ஶ்ஜ்ஷ்ஸ்ஹ்க்ஷ் .:;,";
var hintsNumbers= "௦௧௨௩௪௫௬௭௮௯௰௱௲ @&amp;!?#$€%";


function eventTextLineChange(e) {
    var $this = $(this);
    bulkChangeTextForTab(e.data.grumpy, $this.text(), $this);
}


function onblur() {
    var $this = $(this);
    var text = $this.html();
    if ($this.data('enter') !== text) {
        $this.data('enter', text);
        $this.trigger({type: 'change', action : 'save'});
    }
    return $this;
}


function onkeyup() {
    var $this = $(this);
    var text = $this.html();
    if ($this.data('before') !== text) {
        $this.data('before', text);
        $this.trigger({type: 'change', action : 'update'});
    }
    return $this;
}


function onfocus() {
    var $this = $(this);
    $this.data('enter', $this.html());
    $this.data('before', $this.html());
    return $this;
}


function setColumnTemplate(container, grumpy) {
    for (var k = 0; k < grumpy.columns.length; k++) {

        var sizes = grumpy.columns[k].sizes;
        var block = container.find(grumpy.columns[k].innerblock);
        for (var i = 0; i < sizes.length; i++) {
            fontsize = sizes[i].toString();
            block.append($('<p>').addClass('sizelabel').text(fontsize + 'px'));

            var textline = $('<p>').addClass('textline')
                .css('font-size', fontsize + 'px')
                .attr('contenteditable', true)
                .text(grumpy.text)
                .on('focus', onfocus)
                .on('keyup paste', onkeyup)
                .on('blur', onblur)
                .on('change', {'grumpy': grumpy}, eventTextLineChange);

            block.append(textline);
            //block.append($('<p>&nbsp;</p>'));
        }
    }
}

function setColumnTemplate2(container, grumpy) {
    for (var k = 0; k < grumpy.columns.length; k++) {

        var sizes = grumpy.columns[k].sizes;
        var block = container.find(grumpy.columns[k].innerblock);
        for (var i = 0; i < sizes.length; i++) {
            fontsize = sizes[i].toString();
            block.append($('<p>').addClass('sizelabel').text(fontsize + 'px'));

            var textline = $('<p>').addClass('textline')
                .css('font-size', fontsize + 'px')
                .attr('contenteditable', true)
                .text(grumpy.text)
                .on('focus', onfocus)
                .on('keyup paste', onkeyup)
                .on('blur', onblur)
                .on('change', {'grumpy': grumpy}, eventTextLineChange);

            block.append(textline);
            block.append($('<p>&nbsp;</p>'));
        }
    }
}


function setSplitSingleToDual(container, grumpies_short, grumpies_long) {
    setColumnTemplate(container, grumpies_short);
    setColumnTemplate(container, grumpies_long);
}


function bulkChangeTextForTab(grumpy, value, except) {
    for (var i = 0; i < grumpy.columns.length; i++) {
        $(grumpy.tab).find(grumpy.columns[i].innerblock).find('.textline').not(except).text(value);
    }
}


function prepareAndShowFontLayout() {

    setColumnTemplate($('#headlines'), GRUMPIES.short);

    setColumnTemplate2($('#tamiltext'), GRUMPIES.long);
    
    setColumnTemplate2($('#talatext'), GRUMPIES.longTala);

    var $lowercases = $('#lowercases');
    setColumnTemplate($lowercases, GRUMPIES.lowercaseShort);
    setColumnTemplate2($lowercases, GRUMPIES.lowercaseLong);

    var $adhesion = $('#adhesion');
    setColumnTemplate($adhesion, GRUMPIES.adhesionShort);
    setColumnTemplate2($adhesion, GRUMPIES.adhesionLong);

    var $hamburgefonstiv = $('#hamburgefonstiv');
    setColumnTemplate($hamburgefonstiv, GRUMPIES.hamburgefonstivShort);
    setColumnTemplate2($hamburgefonstiv, GRUMPIES.hamburgefonstivLong);

    var $caps = $('#caps');
    setColumnTemplate2($caps, GRUMPIES.caps);
    
    var $allcaps = $('#allcaps');
    setColumnTemplate2($allcaps, GRUMPIES.allcaps);

    var hints_caps = $('.hints-caps');
    var hints_numbers = $('.hints-numbers');
    var hints_lower = $('.hints-lower');
    hints_lower.html(hints_lower.html() + hintsLower);
    hints_caps.html(hints_caps.html() + hintsCaps);
    hints_numbers.html(hints_numbers.html() + hintsNumbers);
}