var GRUMPIES = {
	'short': {
		'text': "ഇന്ത്യയിൽ‌ കേരള സംസ്ഥാനത്തിലും ലക്ഷദ്വീപിലും പുതുച്ചേരിയുടെ ഭാഗമായ മയ്യഴിയിലും സംസാരിക്കപ്പെടുന്ന ഭാഷയാണ് മലയാളം. ഇതു ദ്രാവിഡ ഭാഷാ കുടുംബത്തിൽപ്പെടുന്നു ",
		'columns': [ // single column
			{
				sizes: [72, 60, 48, 36, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12],
				innerblock: 'div'
			}
		],
		'tab': '#headlines'
	},

	'long': {
		'text': "ഇന്ത്യയിൽ‌ കേരള സംസ്ഥാനത്തിലും ലക്ഷദ്വീപിലും പുതുച്ചേരിയുടെ ഭാഗമായ മയ്യഴിയിലും സംസാരിക്കപ്പെടുന്ന ഭാഷയാണ് മലയാളം . ഇതു ദ്രാവിഡ ഭാഷാ കുടുംബത്തിൽപ്പെടുന്നു. ഇന്ത്യയിൽ ശ്രേഷ്ഠഭാഷാ പദവി ലഭിക്കുന്ന അഞ്ചാമത്തെ ഭാഷയാണ് മലയാളം. ഇന്ത്യൻ ഭരണഘടനയിലെ എട്ടാം ഷെഡ്യൂളിൽ ഉൾപ്പെടുത്തിയിരിക്കുന്ന ഇന്ത്യയിലെ ഇരുപത്തിരണ്ട് ഔദ്യോഗിക ഭാഷകളിൽ ഒന്നാണ് മലയാളം. മലയാള ഭാഷ കൈരളി എന്നും അറിയപ്പെടുന്നു. കേരള സംസ്ഥാനത്തിലെ ഭരണഭാഷയും കൂടിയാണ്‌ മലയാളം. കേരളത്തിനും ലക്ഷദ്വീപിനും പുറമേ ഗൾഫ് രാജ്യങ്ങൾ, സിംഗപ്പൂർ, മലേഷ്യ എന്നിവിടങ്ങളിലെ കേരളീയ പൈതൃകമുള്ള അനേകം ജനങ്ങളും മലയാളം ഉപയോഗിച്ചുപോരുന്നു. ദേശീയ ഭാഷയായി ഉൾപ്പെടുത്തിയത് മറ്റ് 21 ഭാഷകളുടേതു പോലെ തനതായ വ്യക്തിത്വം ഉള്ളതിനാലാണ്. മലയാള ഭാഷയുടെ ഉല്പത്തിയും പ്രാചീനതയും സംബന്ധിച്ച കാര്യങ്ങൾ ഇന്നും അവ്യക്തമാണ്. പഴയ തമിഴ് ആണ് മലയാളത്തിന്റെ ആദ്യ രൂപം എന്നു കരുതുന്നു. യു.എ.ഇ. യിലെ നാലു ഔദ്യോഗിക ഭാഷകളിൽ ഒന്നു മലയാളം ആണു. മലയാളം സംസാരിക്കുന്ന ജനവിഭാഗത്തിനെ പൊതുവായി മലയാളികൾ എന്നു വിളിക്കുമ്പോഴും, ഭാഷയുടെ കേരളീയപാരമ്പര്യം പരിഗണിച്ച് കേരളീയർ എന്നും വിളിച്ചു പോരുന്നു. ലോകത്താകമാനം 3.75 കോടി ജനങ്ങൾ മലയാള ഭാഷ സംസാരിക്കുന്നുണ്ട്. ദ്രാവിഡഭാഷാ കുടുംബത്തിൽ ഉൾപ്പെടുന്ന മലയാളത്തിനു്, ഇതര ഭാരതീയ ഭാഷകളായ സംസ്കൃതം, തമിഴ് എന്നീ ഉദാത്തഭാഷകളുമായി പ്രകടമായ ബന്ധമുണ്ട് 01234567890 ",
		'columns': [ // two columns
			{sizes: [20, 19, 18, 17], innerblock: '.textsettingCol1'},
			{sizes: [16, 15, 14, 13, 12, 11, 10], innerblock: '.textsettingCol2'}
		],
		'tab': '#malayalamtext'
	},

        'longMlla': {
		'text': "മലയാളഭാഷയെ ഏറ്റവും കൂടുതലായി സ്വാധീനിച്ചതു തമിഴും സംസ്കൃതവും ആണ്‌. ദ്രാവിഡ പൈതൃകവും ബ്രാഹ്മണ മേധാവിത്ത്വവും ആണ്‌ അതിനു കാരണം. എങ്കിലും ഭാരതത്തിലെ ഒട്ടുമിക്ക ഭാഷകൾ മാത്രമല്ല, ലോകത്തിലെ തന്നെ മിക്ക ഭാഷകളുടെയും അംശങ്ങൾ മലയാളത്തിൽ കാണാം. ആദികാലം തൊട്ടേ കേരളത്തിനുണ്ടായിരുന്ന വ്യാപാരബന്ധങ്ങൾ ഭാഷയുടെ പുരോഗതിയെ ഏറെ സ്വാധീനിച്ചതായി കാണാം. ഹിന്ദിയും, അറബിയും, ഉർദുവും, യൂറോപ്പിയൻ ഭാഷകളും, ചൈനീസും എല്ലാം അതിന്റേതായ സംഭാവന മലയാളത്തിനു നൽകിയിട്ടുണ്ട്. And not only the labourers but also the classes directly or indirectly exploiting the labourers are made subject, through the division of labour, to the tool of their function: the empty-minded bourgeois to his own capital and his own insane craving for profits; the lawyer to his fossilised legal conceptions, which dominate him as an independent power; the 'educated classes' in general to their manifold species of local narrow -mindedness and one-sidedness, to their own physical and mental short-sightedness, to their stunted growth due to their narrow specialised education and their being chained for life to this specialised activity even when this specialised activity is merely to do nothing. ഹോർത്തൂസ് മലബാറിക്കൂസ് എന്ന സസ്യശാസ്ത്രഗ്രന്ഥത്തിലാണ് ആദ്യമായി മലയാളഭാഷ അച്ചടിച്ചു കാണുന്നതു്. എന്നാൽ ഹോർത്തൂസിലെ താളുകൾ ഓരോ അക്ഷരത്തിനും പ്രത്യേകമായുള്ള അച്ചുകൾ ഉപയോഗിച്ചല്ല, പകരം ബ്ലോക്കുകളായി വാർത്താണു് അച്ചടിച്ചിരുന്നതു്. ഒറ്റയൊറ്റയായുള്ള കല്ലച്ചുകൾ ഉപയോഗിച്ച് ആദ്യമായി മലയാളഭാഷ ഉൾപ്പെടുന്ന പുസ്തകങ്ങൾ അച്ചടിച്ചതു് 1772-ലാണു്. നസ്രാണികൾ ഒക്കെക്കും അറിയേണ്ടുന്ന സംക്ഷേപവേദാർത്ഥം, ആൽഫബെത്തും എന്നിവയാണു് ഈ പുസ്തകങ്ങൾ. 01234567890 ",
		'columns': [ // two columns
			{sizes: [20, 19, 18, 17], innerblock: '.textsettingCol1'},
			{sizes: [16, 15, 14, 13, 12, 11, 10], innerblock: '.textsettingCol2'}
		],
		'tab': '#talatext'
	},

	'lowercaseShort': {
		'text': "the five boxing wizards jump quickly pack my red box with five dozen quality jugs a very big box sailed up then whizzed quickly from japan",
		'columns': [
			{sizes: [72, 60, 48, 36, 30, 24, 18], innerblock: 'div:first'}
		],
		'tab': '#lowercases'
	},

	'lowercaseLong': {
		'text': "serviced tightly trestle custom nosey impugned gooier deeper oat charade smashed welting clopping fondly discard welfare gaudy mission shoddily mooed knelling glance golfed trope togae knocked vulgarly gigabyte curbing snowball outback stepped marmot clayier coltish descry gratify root freedom puree urgency moist careered journal oracle felony marble salary readying besiege twitched ranching snoozing disk mister warbling outwit schism sudsiest street gondola blushing pennon smarted jiving sty rocker griping rocketry dieing tarring A very big box sailed up then whizzed quickly from Japan the five boxing wizards jump quickly pack my red box with five dozen quality jugs",
		'columns': [
			{sizes: [16, 15, 14], innerblock: '.textsettingCol1'},
			{sizes: [13, 12, 11, 10], innerblock: '.textsettingCol2'}
		],
		'tab': '#lowercases'
	},

	'hamburgefonstivShort': {
		'text': "fortieth boring trait favoring barrage referring thrusting tannest embargo sausage gaining astutest augur hibernate variant hearse beggaring foresee eagerer hearten ensnaring tufting interstate meager veneration stigma feminine tabbing noising trimming throbbing ransoming stiffen oaring fishing rehire overbore bonniest ravishment teensiest mintier shriven unforeseen overrate surgeon smarter submarine revenging assuaging masher amnesia insentient rehashing fresher buttering sorghum thine sitter month serer minting variate torsion gaunt",
		'columns': [
			{sizes: [72, 60, 48, 36, 30, 24, 18], innerblock: 'div:first'}
		],
		'tab': '#hamburgefonstiv'
	},

	'hamburgefonstivLong': {
		'text': "fortieth boring trait favoring barrage referring thrusting tannest embargo sausage gaining astutest augur hibernate variant hearse beggaring foresee eagerer hearten ensnaring tufting interstate meager veneration stigma feminine tabbing noising trimming throbbing ransoming stiffen oaring fishing rehire overbore bonniest ravishment teensiest mintier shriven unforeseen overrate surgeon smarter submarine revenging assuaging masher amnesia insentient rehashing fresher buttering sorghum thine sitter month serer minting variate torsion gaunt berthing goofiest sober informing sourer tonight neigh iratest torte situate rheumier antagonist serening motion guise unseeing masseuse",
		'columns': [
			{sizes: [16, 15, 14], innerblock: '.textsettingCol1'},
			{sizes: [13, 12, 11, 10], innerblock: '.textsettingCol2'}
		],
		'tab': '#hamburgefonstiv'
	},

	'caps': {
		'text': "സബ്ഗ്രൂപ്പ് മുഖ്യമന്ത്രി സ്വാതന്ത്ര്യം പ്രസിഡന്റ് മഞ്ഞപ്പ്രസാദം സാമ്രാജ്യം വൈസ്രോയി അബ്സ്റ്റ്രാക്റ്റ് ഒന്നു് ചര്‍ച്ചയ്ക്കു് ചര്‍ച്ചയ്ക്ക്‍  യൗവനം ഔഷധം കൌമുദി സ്വപ്നം ആന്റണി ആന്റി എന്റുപ്പാപ്പ എന്റെ വിന്റേജ് ആന്റോ എന്‍റിക്കലെക്സി 0 1 2 3 4 5 6 7 8 9 ! ?",
		'columns': [
			{sizes: [60, 48, 36, 30, 28, 24, 20, 18, 16, 14, 13], innerblock: 'div'}
		],
		'tab': '#caps'
	},

	'allcaps': {
		'text': "ARROWROOT BARLETY CHERVIL DUMPLING ENDINE FLAXSEED GARBANZO HIJIKI ISHTU JICAMA KALE LYCHEEN MARJORAM NECTARINE OXTAIL PIZZA QUINOA ROQUEFORT SQUASH TOFU UPPUMA VANILLA WHEAT XERGIS YOGURT ZWEIBACK 0 1 2 3 4 5 6 7 8 9 ! ?",
		'columns': [
			{sizes: [60, 48, 36, 30, 28, 24, 20, 18, 16, 14, 13], innerblock: 'div'}
		],
		'tab': '#allcaps'
	}
};

var hintsCaps = "അആഇഈഉഊഋഌഎഏഐഒഓഔകഖഗഘങചഛജഝഞടഠഡഢണതഥദധനഩപഫബഭമയരറലളഴവശഷസഹ";
var hintsLower = "അആഇഈഉഊഋഌഎഏഐഒഓഔകഖഗഘങചഛജഝഞടഠഡഢണതഥദധനഩപഫബഭമയരറലളഴവശഷസഹ";
var hintsNumbers= "൦ ൧ ൨ ൩ ൪ ൫ ൬ ൭ ൮ ൯ @&amp;!?#$€%";


function eventTextLineChange(e) {
    var $this = $(this);
    bulkChangeTextForTab(e.data.grumpy, $this.text(), $this);
}


function onblur() {
    var $this = $(this);
    var text = $this.html();
    if ($this.data('enter') !== text) {
        $this.data('enter', text);
        $this.trigger({type: 'change', action : 'save'});
    }
    return $this;
}


function onkeyup() {
    var $this = $(this);
    var text = $this.html();
    if ($this.data('before') !== text) {
        $this.data('before', text);
        $this.trigger({type: 'change', action : 'update'});
    }
    return $this;
}


function onfocus() {
    var $this = $(this);
    $this.data('enter', $this.html());
    $this.data('before', $this.html());
    return $this;
}


function setColumnTemplate(container, grumpy) {
    for (var k = 0; k < grumpy.columns.length; k++) {

        var sizes = grumpy.columns[k].sizes;
        var block = container.find(grumpy.columns[k].innerblock);
        for (var i = 0; i < sizes.length; i++) {
            fontsize = sizes[i].toString();
            block.append($('<p>').addClass('sizelabel').text(fontsize + 'px'));

            var textline = $('<p>').addClass('textline')
                .css('font-size', fontsize + 'px')
                .attr('contenteditable', true)
                .text(grumpy.text)
                .on('focus', onfocus)
                .on('keyup paste', onkeyup)
                .on('blur', onblur)
                .on('change', {'grumpy': grumpy}, eventTextLineChange);

            block.append(textline);
            //block.append($('<p>&nbsp;</p>'));
        }
    }
}

function setColumnTemplate2(container, grumpy) {
    for (var k = 0; k < grumpy.columns.length; k++) {

        var sizes = grumpy.columns[k].sizes;
        var block = container.find(grumpy.columns[k].innerblock);
        for (var i = 0; i < sizes.length; i++) {
            fontsize = sizes[i].toString();
            block.append($('<p>').addClass('sizelabel').text(fontsize + 'px'));

            var textline = $('<p>').addClass('textline')
                .css('font-size', fontsize + 'px')
                .attr('contenteditable', true)
                .text(grumpy.text)
                .on('focus', onfocus)
                .on('keyup paste', onkeyup)
                .on('blur', onblur)
                .on('change', {'grumpy': grumpy}, eventTextLineChange);

            block.append(textline);
            block.append($('<p>&nbsp;</p>'));
        }
    }
}


function setSplitSingleToDual(container, grumpies_short, grumpies_long) {
    setColumnTemplate(container, grumpies_short);
    setColumnTemplate(container, grumpies_long);
}


function bulkChangeTextForTab(grumpy, value, except) {
    for (var i = 0; i < grumpy.columns.length; i++) {
        $(grumpy.tab).find(grumpy.columns[i].innerblock).find('.textline').not(except).text(value);
    }
}


function prepareAndShowFontLayout() {

    setColumnTemplate($('#headlines'), GRUMPIES.short);

    setColumnTemplate2($('#malayalamtext'), GRUMPIES.long);

    setColumnTemplate2($('#mllatext'), GRUMPIES.longMlla);

    var $lowercases = $('#lowercases');
    setColumnTemplate($lowercases, GRUMPIES.lowercaseShort);
    setColumnTemplate2($lowercases, GRUMPIES.lowercaseLong);

    var $hamburgefonstiv = $('#hamburgefonstiv');
    setColumnTemplate($hamburgefonstiv, GRUMPIES.hamburgefonstivShort);
    setColumnTemplate2($hamburgefonstiv, GRUMPIES.hamburgefonstivLong);

    var $caps = $('#caps');
    setColumnTemplate2($caps, GRUMPIES.caps);

    var $allcaps = $('#allcaps');
    setColumnTemplate2($allcaps, GRUMPIES.allcaps);

    var hints_caps = $('.hints-caps');
    var hints_numbers = $('.hints-numbers');
    var hints_lower = $('.hints-lower');
    hints_lower.html(hints_lower.html() + hintsLower);
    hints_caps.html(hints_caps.html() + hintsCaps);
    hints_numbers.html(hints_numbers.html() + hintsNumbers);
}
