/*
 * Copyright (c) 2019 Alexander Yaburov
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package me.impa.knockonports.tasker.receiver

import android.content.Context
import android.os.Bundle
import com.twofortyfouram.locale.sdk.client.receiver.AbstractPluginSettingReceiver
import me.impa.knockonports.ext.startSequence
import me.impa.knockonports.tasker.bundle.KnockerBundleValues

class FireReceiver: AbstractPluginSettingReceiver() {

    override fun firePluginSetting(context: Context, bundle: Bundle) {
        context.startSequence(KnockerBundleValues.getSequenceId(bundle))
    }

    override fun isBundleValid(bundle: Bundle) = KnockerBundleValues.isBundleValid(bundle)

    override fun isAsync() = false
}